/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <QtGui>

#include "MMLMonitorDisplay.h"

#ifndef MMLMONITORSDISLPAYS_TABULAR_H
#define MMLMONITORSDISLPAYS_TABULAR_H

class Tabular: public MMLMonitorDisplay{
  Q_OBJECT
  public:
    
    /// constructor
    Tabular(Monitor* monitor,MMLComponent* manager);
    /// destructor
    ~Tabular();
    
    /// update display
    void update();
    /// hide display
    void hide();
    
  public  slots:

    void copy();
    
  private:
    
    /// the tabular
    QTableWidget* table;
    /// row line in monitor table
    int line;
    /// old row size in the monitors table
    int oldRowSize;
    /// event filter which manage opening of the tabular popup menu when rigth click is pressed
    bool eventFilter(QObject *obj, QEvent *event);
};

#endif