
/* Automatically generated by m214003 at 2025-08-10, do not edit */

/* CDILIB_VERSION="2.5.3" */

#if defined(_WIN32) || defined(_WIN64)
#define restrict
#define ssize_t long
#elif ! defined HAVE_CONFIG_H
#define HAVE_UNISTD_H
#endif

#ifdef _ARCH_PWR6
#pragma options nostrict
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE 600
#endif

#ifdef  HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdbool.h>
#include <assert.h>

#ifdef HAVE_LIBGRIB_API
#include <grib_api.h>
#endif

#ifdef HAVE_MMAP
#include <sys/mman.h> /* mmap() is defined in this header */
#endif

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
#endif

#ifdef HAVE_LIBSZ
#include <szlib.h>
#endif

#ifndef HAVE_CONFIG_H
#define  HAVE_LIBGRIB      1
#define  HAVE_LIBCGRIBEX   1
#define  HAVE_LIBSERVICE   1
#define  HAVE_LIBEXTRA     1
#define  HAVE_LIBIEG       1
#define  CDI              -1
#endif

#ifndef ASYNC_WORKER_H
#define ASYNC_WORKER_H

typedef struct AsyncJob AsyncJob;
typedef struct AsyncManager AsyncManager;

// a negative threadCount gives the number of cores that should remain unused by the worker threads, returns an error code
int AsyncWorker_init(AsyncManager **jobManager, int threadCount);

// executes work(data) in a worker thread, must be followed by a call to AsyncWorker_wait()
AsyncJob *AsyncWorker_requestWork(AsyncManager *jobManager, int (*work)(void *data), void *data);

// waits for the async job to finish and returns its result (or some other error code)
int AsyncWorker_wait(AsyncManager *jobManager, AsyncJob *job);

// return the number of workers that are currently idle
int AsyncWorker_availableWorkers(AsyncManager *jobManager);

// waits for all pending jobs to finish, stops all workers, returns a non-zero error code from a pending job if there were any
int AsyncWorker_finalize(AsyncManager *jobManager);

#endif
#ifndef CDI_DATETIME_H
#define CDI_DATETIME_H

#include <stdbool.h>
#include <stdint.h>

// clang-format off

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  int   year;      // year of date
  short month;     // month of date
  short day;       // day of date
} CdiDate;

typedef struct
{
  short hour;      // hour part of time
  short minute;	   // minute part of time
  short second;	   // second part of time
  short ms;        // milli-second part of time. 0<=ms<=999
} CdiTime;

typedef struct
{
  CdiDate date;    // date elements
  CdiTime time;    // time elements
} CdiDateTime;

CdiDateTime cdiDateTime_set(int64_t date, int time);
CdiDate cdiDate_set(int64_t date);
CdiTime cdiTime_set(int time);
int64_t cdiDate_get(CdiDate cdiDate);
int cdiTime_get(CdiTime cdiTime);

CdiDate cdiDate_encode(int year, int month, int day);
void cdiDate_decode(CdiDate cdiDate, int *year, int *month, int *day);
CdiTime cdiTime_encode(int hour, int minute, int second, int ms);
void cdiTime_decode(CdiTime cdiTime, int *hour, int *minute, int *second, int *ms);

void cdiDate_init(CdiDate *cdiDate);
void cdiTime_init(CdiTime *cdiTime);
void cdiDateTime_init(CdiDateTime *cdiDateTime);

bool cdiDate_isEQ(CdiDate cdiDate1, CdiDate cdiDate2);
bool cdiTime_isEQ(CdiTime cdiTime1, CdiTime cdiTime2);
bool cdiDateTime_isEQ(CdiDateTime cdiDateTime1, CdiDateTime cdiDateTime2);
bool cdiDateTime_isNE(CdiDateTime cdiDateTime1, CdiDateTime cdiDateTime2);
bool cdiDateTime_isLT(CdiDateTime cdiDateTime1, CdiDateTime cdiDateTime2);
bool cdiDateTime_isNull(CdiDateTime cdiDateTime);

const char *CdiDateTime_string(CdiDateTime cdiDateTime);

#ifdef __cplusplus
}
#endif

// clang-format on

#endif /* CDI_DATETIME_H */
/*
  CDI C header file

  This is the only file that must be included to use the CDI library from C.
*/

#ifndef CDI_H_
#define CDI_H_

// clang-format off

#include <stdio.h>
#include <stdint.h>    // int64_t
#include <stdbool.h>
#include <sys/types.h>

#ifndef CDI_SIZE_TYPE
#define CDI_SIZE_TYPE int
#endif

typedef CDI_SIZE_TYPE SizeType;

//FINT_ON  <--- don't change or remove this line!!!
// Start of fortran interface for the following routines (make_fint.c)

#ifdef __cplusplus
extern "C" {
#endif

#define  CDI_MAX_NAME             256   // Max length of a name

#define  CDI_UNDEFID               -1
#define  CDI_GLOBAL                -1   // Global var ID for vlist and Z-axis
#define  CDI_XAXIS                  1   // X-axis ID for grid
#define  CDI_YAXIS                  2   // Y-axis ID for grid

// Byte order

#define  CDI_BIGENDIAN              0   // Byte order BIGENDIAN
#define  CDI_LITTLEENDIAN           1   // Byte order LITTLEENDIAN
#define  CDI_PDPENDIAN              2

#define  CDI_REAL                   1   // Real numbers
#define  CDI_COMP                   2   // Complex numbers
#define  CDI_BOTH                   3   // Both numbers

// Error identifier

#define  CDI_NOERR                  0   // No Error
#define  CDI_EEOF                  -1   // The end of file was encountered
#define  CDI_ETMOF                 -9   // Too many open files
#define  CDI_ESYSTEM              -10   // Operating system error
#define  CDI_EINVAL               -20   // Invalid argument
#define  CDI_EISDIR               -21   // Is a directory
#define  CDI_EISEMPTY             -22   // Is empty
#define  CDI_EUFTYPE              -23   // Unsupported file type
#define  CDI_ELIBNAVAIL           -24   // xxx library not available
#define  CDI_EUFSTRUCT            -25   // Unsupported file structure
#define  CDI_EUNC4                -26   // Unsupported NetCDF4 structure
#define  CDI_EDIMSIZE             -27   // Invalid dimension size
#define  CDI_EQENF                -50   // Query entries not found
#define  CDI_EQNAVAIL             -51   // Query not available for file type
#define  CDI_ELIMIT               -99   // Internal limits exceeded

// File types

#define  CDI_FILETYPE_GRB           1   // File type GRIB
#define  CDI_FILETYPE_GRB2          2   // File type GRIB version 2
#define  CDI_FILETYPE_NC            3   // File type NetCDF
#define  CDI_FILETYPE_NC2           4   // File type NetCDF version 2 (64-bit offset)
#define  CDI_FILETYPE_NC4           5   // File type NetCDF version 4
#define  CDI_FILETYPE_NC4C          6   // File type NetCDF version 4 (classic)
#define  CDI_FILETYPE_NC5           7   // File type NetCDF version 5 (64-bit data)
#define  CDI_FILETYPE_SRV           8   // File type SERVICE
#define  CDI_FILETYPE_EXT           9   // File type EXTRA
#define  CDI_FILETYPE_IEG          10   // File type IEG
#define  CDI_FILETYPE_NCZARR       11   // File type NetCDF NCZarr Data Model

// Compatibility defines for release 1.8.3 (obsolete defines)
#define  FILETYPE_GRB               1   // File type GRIB
#define  FILETYPE_GRB2              2   // File type GRIB version 2
#define  FILETYPE_NC                3   // File type NetCDF
#define  FILETYPE_NC2               4   // File type NetCDF version 2 (64-bit offset)
#define  FILETYPE_NC4               5   // File type NetCDF version 4

// Protocols (in filename/URI)

#define CDI_PROTOCOL_OTHER          0   // Any other protocol (might be supported by NetCDF library)
#define CDI_PROTOCOL_FILE           1
#define CDI_PROTOCOL_FDB            2
#define CDI_PROTOCOL_ACROSS         3

// Compress types

#define  CDI_COMPRESS_NONE          0
#define  CDI_COMPRESS_SZIP          1
#define  CDI_COMPRESS_AEC           2
#define  CDI_COMPRESS_ZIP           3
#define  CDI_COMPRESS_JPEG          4
#define  CDI_COMPRESS_FILTER        5

// external data types

// Compatibility defines for release 1.8.3 (obsolete defines)
#define  DATATYPE_PACK16           16
#define  DATATYPE_PACK24           24
#define  DATATYPE_FLT32           132
#define  DATATYPE_FLT64           164
#define  DATATYPE_INT32           232
#define  DATATYPE_INT             251

#define  CDI_DATATYPE_PACK          0
#define  CDI_DATATYPE_PACK1         1
#define  CDI_DATATYPE_PACK2         2
#define  CDI_DATATYPE_PACK3         3
#define  CDI_DATATYPE_PACK4         4
#define  CDI_DATATYPE_PACK5         5
#define  CDI_DATATYPE_PACK6         6
#define  CDI_DATATYPE_PACK7         7
#define  CDI_DATATYPE_PACK8         8
#define  CDI_DATATYPE_PACK9         9
#define  CDI_DATATYPE_PACK10       10
#define  CDI_DATATYPE_PACK11       11
#define  CDI_DATATYPE_PACK12       12
#define  CDI_DATATYPE_PACK13       13
#define  CDI_DATATYPE_PACK14       14
#define  CDI_DATATYPE_PACK15       15
#define  CDI_DATATYPE_PACK16       16
#define  CDI_DATATYPE_PACK17       17
#define  CDI_DATATYPE_PACK18       18
#define  CDI_DATATYPE_PACK19       19
#define  CDI_DATATYPE_PACK20       20
#define  CDI_DATATYPE_PACK21       21
#define  CDI_DATATYPE_PACK22       22
#define  CDI_DATATYPE_PACK23       23
#define  CDI_DATATYPE_PACK24       24
#define  CDI_DATATYPE_PACK25       25
#define  CDI_DATATYPE_PACK26       26
#define  CDI_DATATYPE_PACK27       27
#define  CDI_DATATYPE_PACK28       28
#define  CDI_DATATYPE_PACK29       29
#define  CDI_DATATYPE_PACK30       30
#define  CDI_DATATYPE_PACK31       31
#define  CDI_DATATYPE_PACK32       32
#define  CDI_DATATYPE_CPX32        64
#define  CDI_DATATYPE_CPX64       128
#define  CDI_DATATYPE_FLT32       132
#define  CDI_DATATYPE_FLT64       164
#define  CDI_DATATYPE_INT8        208
#define  CDI_DATATYPE_INT16       216
#define  CDI_DATATYPE_INT32       232
#define  CDI_DATATYPE_UINT8       308
#define  CDI_DATATYPE_UINT16      316
#define  CDI_DATATYPE_UINT32      332

// internal data types
#define  CDI_DATATYPE_INT         251
#define  CDI_DATATYPE_FLT         252
#define  CDI_DATATYPE_TXT         253
#define  CDI_DATATYPE_CPX         254
#define  CDI_DATATYPE_UCHAR       255
#define  CDI_DATATYPE_LONG        256
#define  CDI_DATATYPE_UINT        257

// Chunk types

#define  CDI_CHUNK_AUTO             1  // use default chunk size
#define  CDI_CHUNK_GRID             2
#define  CDI_CHUNK_LINES            3

// GRID types

#define  GRID_GENERIC               1  // Generic grid
#define  GRID_GAUSSIAN              2  // Regular Gaussian lon/lat grid
#define  GRID_GAUSSIAN_REDUCED      3  // Reduced Gaussian lon/lat grid
#define  GRID_LONLAT                4  // Regular longitude/latitude grid
#define  GRID_SPECTRAL              5  // Spherical harmonic coefficients (spectral gaussian)
#define  GRID_FOURIER               6  // Fourier coefficients (spectral gaussian)
#define  GRID_GME                   7  // Icosahedral-hexagonal GME grid
#define  GRID_TRAJECTORY            8  // Trajectory
#define  GRID_UNSTRUCTURED          9  // General unstructured grid
#define  GRID_CURVILINEAR          10  // Curvilinear grid
#define  GRID_HEALPIX              11  // HealPIX grid
#define  GRID_PROJECTION           12  // Projected coordinates
#define  GRID_CHARXY               13  // One horizontal character dimension

#define  CDI_PROJ_RLL              21  // Rotated Latitude Longitude
#define  CDI_PROJ_LCC              22  // Lambert Conformal Conic
#define  CDI_PROJ_LAEA             23  // Lambert Azimuthal Equal Area
#define  CDI_PROJ_SINU             24  // Sinusoidal
#define  CDI_PROJ_STERE            25  // Polar stereographic
#define  CDI_PROJ_HEALPIX          26  // Healpix

// ZAXIS types

#define  ZAXIS_SURFACE              0  // Surface level
#define  ZAXIS_GENERIC              1  // Generic level
#define  ZAXIS_HYBRID               2  // Hybrid level
#define  ZAXIS_HYBRID_HALF          3  // Hybrid half level
#define  ZAXIS_PRESSURE             4  // Isobaric pressure level in Pascal
#define  ZAXIS_HEIGHT               5  // Height above ground
#define  ZAXIS_DEPTH_BELOW_SEA      6  // Depth below sea level in meters
#define  ZAXIS_DEPTH_BELOW_LAND     7  // Depth below land surface in centimeters
#define  ZAXIS_ISENTROPIC           8  // Isentropic
#define  ZAXIS_TRAJECTORY           9  // Trajectory
#define  ZAXIS_ALTITUDE            10  // Altitude above mean sea level in meters
#define  ZAXIS_SIGMA               11  // Sigma level
#define  ZAXIS_MEANSEA             12  // Mean sea level
#define  ZAXIS_TOA                 13  // Norminal top of atmosphere
#define  ZAXIS_SEA_BOTTOM          14  // Sea bottom
#define  ZAXIS_ATMOSPHERE          15  // Entire atmosphere
#define  ZAXIS_CLOUD_BASE          16  // Cloud base level
#define  ZAXIS_CLOUD_TOP           17  // Level of cloud tops
#define  ZAXIS_ISOTHERM_ZERO       18  // Level of 0o C isotherm
#define  ZAXIS_SNOW                19  // Snow level
#define  ZAXIS_LAKE_BOTTOM         20  // Lake or River Bottom
#define  ZAXIS_SEDIMENT_BOTTOM     21  // Bottom Of Sediment Layer
#define  ZAXIS_SEDIMENT_BOTTOM_TA  22  // Bottom Of Thermally Active Sediment Layer
#define  ZAXIS_SEDIMENT_BOTTOM_TW  23  // Bottom Of Sediment Layer Penetrated By Thermal Wave
#define  ZAXIS_MIX_LAYER           24  // Mixing Layer
#define  ZAXIS_REFERENCE           25  // zaxis reference number
#define  ZAXIS_CHAR                26  // Area types
#define  ZAXIS_TROPOPAUSE          27  // Tropopause

// SUBTYPE types

enum {
  SUBTYPE_TILES                   = 0  // Tiles variable
};

#define MAX_KV_PAIRS_MATCH 10

/* Data structure defining a key-value search, possibly with multiple
   key-value pairs in combination.

   Currently, only multiple pairs combined by AND are supported.
*/
typedef struct  {
  int nAND;                                   // no. of key-value pairs that have to match
  int key_value_pairs[2][MAX_KV_PAIRS_MATCH]; // key-value pairs
} subtype_query_t;



// TIME types

#define  TIME_CONSTANT            0  // Time constant
#define  TIME_VARYING             1  // Time varying
#define  TIME_VARIABLE            1  // obsolete, use TIME_VARYING

// TSTEP types

#define  TSTEP_CONSTANT           0  // obsolete, use TIME_CONSTANT
#define  TSTEP_INSTANT            1  // Instant
#define  TSTEP_AVG                2  // Average
#define  TSTEP_ACCUM              3  // Accumulation
#define  TSTEP_MAX                4  // Maximum
#define  TSTEP_MIN                5  // Minimum
#define  TSTEP_DIFF               6  // Difference
#define  TSTEP_RMS                7  // Root mean square
#define  TSTEP_SD                 8  // Standard deviation
#define  TSTEP_COV                9  // Covariance
#define  TSTEP_RATIO             10  // Ratio
#define  TSTEP_SUM               11  // Summation
#define  TSTEP_RANGE             12
#define  TSTEP_INSTANT2          13
#define  TSTEP_INSTANT3          14

// TAXIS types

#define  TAXIS_ABSOLUTE           1
#define  TAXIS_RELATIVE           2
#define  TAXIS_FORECAST           3

// TUNIT types

#define  TUNIT_SECOND             1
#define  TUNIT_MINUTE             2
#define  TUNIT_QUARTER            3
#define  TUNIT_30MINUTES          4
#define  TUNIT_HOUR               5
#define  TUNIT_3HOURS             6
#define  TUNIT_6HOURS             7
#define  TUNIT_12HOURS            8
#define  TUNIT_DAY                9
#define  TUNIT_MONTH             10
#define  TUNIT_YEAR              11

// CALENDAR types

#define  CALENDAR_STANDARD        0  // don't change this value (used also in cgribexlib)!
#define  CALENDAR_GREGORIAN       1
#define  CALENDAR_PROLEPTIC       2
#define  CALENDAR_360DAYS         3
#define  CALENDAR_365DAYS         4
#define  CALENDAR_366DAYS         5
#define  CALENDAR_NONE            6

// number of unsigned char needed to store UUID
#define  CDI_UUID_SIZE           16

// Structs that are used to return data to the user

typedef struct CdiParam { int discipline; int category; int number; } CdiParam;


// Opaque types
typedef struct CdiIterator CdiIterator;
typedef struct CdiGribIterator CdiGribIterator;

// CDI control routines

void    cdiReset(void);

const char *cdiStringError(int cdiErrno);
void    cdiDebug(int debug);

const char *cdiLibraryVersion(void);
void    cdiPrintVersion(void);

int     cdiHaveFiletype(int filetype);

void    cdiDefMissval(double missval);
double  cdiInqMissval(void);
void    cdiDefGlobal(const char *string, int val);

int     namespaceNew(void);
void    namespaceSetActive(int namespaceID);
int     namespaceGetActive(void);
void    namespaceDelete(int namespaceID);


// CDI converter routines

// parameter

void    cdiParamToString(int param, char *paramstr, int maxlen);

void    cdiDecodeParam(int param, int *pnum, int *pcat, int *pdis);
int     cdiEncodeParam(int pnum, int pcat, int pdis);

// date format:  YYYYMMDD
// time format:    hhmmss

void    cdiDecodeDate(int date, int *year, int *month, int *day);
int     cdiEncodeDate(int year, int month, int day);

void    cdiDecodeTime(int time, int *hour, int *minute, int *second);
int     cdiEncodeTime(int hour, int minute, int second);


// STREAM control routines

int     cdiGetFiletype(const char *uri, int *byteorder);
int     cdiGetProtocol(const char *uri, const char **filename);

int     streamOpenReadNCMem(int ncid);
int     streamOpenWriteNCMem(int ncid);
void    streamCloseNCMem(int ncid);

//      streamOpenRead: Open a dataset for reading
int     streamOpenRead(const char *path);

//      streamOpenWrite: Create a new dataset
int     streamOpenWrite(const char *path, int filetype);

int     streamOpenAppend(const char *path);

//      streamClose: Close an open dataset
void    streamClose(int streamID);

//      streamSync: Synchronize an Open Dataset to Disk
void    streamSync(int streamID);

void    streamDefMaxSteps(int streamID, int maxSteps);
void    streamDefNumWorker(int streamID, int numWorker);

int     streamInqNumSteps(int streamID);

//      streamDefVlist: Define the Vlist for a stream
void    streamDefVlist(int streamID, int vlistID);

//      streamInqVlist: Get the Vlist of a stream
int     streamInqVlist(int streamID);

//      streamInqFiletype: Get the filetype
int     streamInqFiletype(int streamID);

//      streamDefByteorder: Define the byteorder
void    streamDefByteorder(int streamID, int byteorder);

//      streamInqByteorder: Get the byteorder
int     streamInqByteorder(int streamID);

void    streamDefShuffle(int streamID, int shuffle);

void    streamDefFilter(int streamID, const char *filterSpec);

//      streamDefCompType: Define compression type
void    streamDefCompType(int streamID, int comptype);

//      streamInqCompType: Get compression type
int     streamInqCompType(int streamID);

//      streamDefCompLevel: Define compression level
void    streamDefCompLevel(int streamID, int complevel);

//      streamInqCompLevel: Get compression level
int     streamInqCompLevel(int streamID);

//      streamDefTimestep: Define time step
int     streamDefTimestep(int streamID, int tsID);

//      streamInqTimestep: Get time step
int     streamInqTimestep(int streamID, int tsID);

//      PIO: query currently set timestep id
int     streamInqCurTimestepID(int streamID);

const char *streamFilename(int streamID);
const char *streamFilesuffix(int filetype);

SizeType streamNvals(int streamID);

int     streamInqNvars(int streamID);

// STREAM var I/O routines (random access)

//      streamWriteVar: Write a variable
void    streamWriteVar(int streamID, int varID, const double data[], SizeType numMissVals);
void    streamWriteVarF(int streamID, int varID, const float data[], SizeType numMissVals);

//      streamReadVar: Read a variable
void    streamReadVar(int streamID, int varID, double data[], SizeType *numMissVals);
void    streamReadVarF(int streamID, int varID, float data[], SizeType *numMissVals);
void    streamReadVarPart(int streamID, int varID, int varType, int start, SizeType size, void *data, SizeType *numMissVals, int memtype);

//      streamWriteVarSlice: Write a horizontal slice of a variable
void    streamWriteVarSlice(int streamID, int varID, int levelID, const double data[], SizeType numMissVals);
void    streamWriteVarSliceF(int streamID, int varID, int levelID, const float data[], SizeType numMissVals);
void    streamReadVarSlicePart(int streamID, int varID, int levelID, int varType, int start, SizeType size, void *data, SizeType *numMissVals, int memtype);

//      streamReadVarSlice: Read a horizontal slice of a variable
void    streamReadVarSlice(int streamID, int varID, int levelID, double data[], SizeType *numMissVals);
void    streamReadVarSliceF(int streamID, int varID, int levelID, float data[], SizeType *numMissVals);

void    streamWriteVarChunk(int streamID, int varID, const int rect[][2], const double data[], SizeType numMissVals);
void    streamWriteVarChunkF(int streamID, int varID, const int rect[][2], const float data[], SizeType numMissVals);


// STREAM field I/O routines (sequential access)

void    streamDefField(int streamID, int  varID, int  levelID);
void    streamInqField(int streamID, int *varID, int *levelID);
void    streamWriteField(int streamID, const double data[], SizeType numMissVals);
void    streamWriteFieldF(int streamID, const float data[], SizeType numMissVals);
void    streamReadField(int streamID, double data[], SizeType *numMissVals);
void    streamReadFieldF(int streamID, float data[], SizeType *numMissVals);
void    streamCopyField(int streamIDdest, int streamIDsrc);

void *  stream_get_pointer(int streamID);
void *  stream_get_vlist_pointer(int streamID);
void    pstreamInqField(void *streamPtr, int *varID, int *levelID);

void    streamInqGRIBinfo(int streamID, int *intnum, float *fltnum, off_t *bignum);


// File driven I/O (may yield better performance than using the streamXXX functions)

// Creation & Destruction
CdiIterator *cdiIterator_new(const char *path);  // Requires a subsequent call to cdiIteratorNextField() to point the iterator at the first field.
CdiIterator *cdiIterator_clone(CdiIterator *me);
char *cdiIterator_serialize(CdiIterator *me);  // Returns a malloc'ed string.
CdiIterator *cdiIterator_deserialize(const char *description);  // description is a string that was returned by cdiIteratorSerialize(). Returns a copy of the original iterator.
void cdiIterator_print(CdiIterator *me, FILE *stream);
void cdiIterator_delete(CdiIterator *me);

// Advancing an iterator
int cdiIterator_nextField(CdiIterator *me);      // Points the iterator at the next field, returns CDI_EEOF if there are no more fields in the file.

// Introspecting metadata
// All outXXX arguments to these functions may be NULL.
char *cdiIterator_inqStartTime(CdiIterator *me);    // Returns the (start) time as an ISO-8601 coded string. The caller is responsible to Free() the returned string.
char *cdiIterator_inqEndTime(CdiIterator *me);      // Returns the end time of an integration period as an ISO-8601 coded string, or NULL if there is no end time. The caller is responsible to Free() the returned string.
char *cdiIterator_inqRTime(CdiIterator *me);        // Returns the reference date as an ISO-8601 coded string. The caller is responsible to Free() the returned string.
char *cdiIterator_inqVTime(CdiIterator *me);        // Returns the validity date as an ISO-8601 coded string. The caller is responsible to Free() the returned string.
int cdiIterator_inqLevelType(CdiIterator *me, int levelSelector, char **outName_optional, char **outLongName_optional, char **outStdName_optional, char **outUnit_optional);      // callers are responsible to Free() strings that they request
int cdiIterator_inqLevel(CdiIterator *me, int levelSelector, double *outValue1_optional, double *outValue2_optional);       // outValue2 is only written to if the level is a hybrid level
int cdiIterator_inqLevelUuid(CdiIterator *me, int *outVgridNumber_optional, int *outLevelCount_optional, unsigned char outUuid_optional[CDI_UUID_SIZE]);   // outUuid must point to a buffer of 16 bytes, returns an error code if no generalized zaxis is used.
int cdiIterator_inqTile(CdiIterator *me, int *outTileIndex, int *outTileAttribute); // Returns CDI_EINVAL if there is no tile information connected to the current field, *outTileIndex and *outTileAttribute will be set to -1 in this case.
int cdiIterator_inqTileCount(CdiIterator *me, int *outTileCount, int *outTileAttributeCount); // outTileAttributeCount is the count for the tile associated with the current field, a total attribute count cannot be inquired. Returns CDI_EINVAL if there is no tile information connected to the current field, *outTileCount and *outTileAttributeCount will be set to 0 in this case.
CdiParam cdiIterator_inqParam(CdiIterator *me);
void cdiIterator_inqParamParts(CdiIterator *me, int *outDiscipline, int *outCategory, int *outNumber);	// Some FORTRAN compilers produce wrong code for the cdiIterator_inqParam()-wrapper, rendering it unusable from FORTRAN. This function is the workaround.
int cdiIterator_inqDatatype(CdiIterator *me);
int cdiIterator_inqFiletype(CdiIterator *me);
int cdiIterator_inqTsteptype(CdiIterator *me);
char *cdiIterator_inqVariableName(CdiIterator *me);     // The caller is responsible to Free() the returned buffer.
int cdiIterator_inqGridId(CdiIterator *me);             // The returned id is only valid until the next call to cdiIteratorNextField().

// Reading data
void cdiIterator_readField(CdiIterator *me, double data[], SizeType *numMissVals_optional);
void cdiIterator_readFieldF(CdiIterator *me, float data[], SizeType *numMissVals_optional);
// TODO[NH]: Add functions to read partial fields.


// Direct access to grib fields
CdiGribIterator *cdiGribIterator_clone(CdiIterator *me);  // Returns NULL if the associated file is not a GRIB file.
void cdiGribIterator_delete(CdiGribIterator *me);

// Callthroughs to GRIB-API
int cdiGribIterator_getLong(CdiGribIterator *me, const char *key, long *value);         // Same semantics as grib_get_long().
int cdiGribIterator_getDouble(CdiGribIterator *me, const char *key, double *value);     // Same semantics as grib_get_double().
int cdiGribIterator_getLength(CdiGribIterator *me, const char *key, size_t *value);     // Same semantics as grib_get_length().
int cdiGribIterator_getString(CdiGribIterator *me, const char *key, char *value, size_t *length);       // Same semantics as grib_get_string().
int cdiGribIterator_getSize(CdiGribIterator *me, const char *key, size_t *value);       // Same semantics as grib_get_size().
int cdiGribIterator_getLongArray(CdiGribIterator *me, const char *key, long *value, size_t *array_size);       // Same semantics as grib_get_long_array().
int cdiGribIterator_getDoubleArray(CdiGribIterator *me, const char *key, double *value, size_t *array_size);   // Same semantics as grib_get_double_array().

// Convenience functions for accessing GRIB-API keys
int cdiGribIterator_inqEdition(CdiGribIterator *me);
long cdiGribIterator_inqLongValue(CdiGribIterator *me, const char *key);       // Aborts on failure to fetch the given key.
long cdiGribIterator_inqLongDefaultValue(CdiGribIterator *me, const char *key, long defaultValue); // Returns the default value if the given key is not present.
double cdiGribIterator_inqDoubleValue(CdiGribIterator *me, const char *key);   // Aborts on failure to fetch the given key.
double cdiGribIterator_inqDoubleDefaultValue(CdiGribIterator *me, const char *key, double defaultValue); // Returns the default value if the given key is not present.
char *cdiGribIterator_inqStringValue(CdiGribIterator *me, const char *key);    // Returns a malloc'ed string.

// VLIST routines

//      vlistCreate: Create a variable list
int     vlistCreate(void);

//      vlistDestroy: Destroy a variable list
void    vlistDestroy(int vlistID);

//      vlistDuplicate: Duplicate a variable list
int     vlistDuplicate(int vlistID);

//      vlistCopyFlag: Copy some entries of a variable list
void    vlistCopyFlag(int vlistID2, int vlistID1);

void    vlistClearFlag(int vlistID);

//      vlistCat: Concatenate two variable lists
void    vlistCat(int vlistID2, int vlistID1);

//      vlistMerge: Merge two variable lists
void    vlistMerge(int vlistID2, int vlistID1);

void    vlistPrint(int vlistID);

//      vlistNumber: Number type in a variable list
int     vlistNumber(int vlistID);

//      vlistNvars: Number of variables in a variable list
int     vlistNvars(int vlistID);

//      vlistNumGrids: Number of grids in a variable list
int     vlistNumGrids(int vlistID);

//      vlistNumZaxis: Number of zaxis in a variable list
int     vlistNumZaxis(int vlistID);

//      vlistNsubtypes: Number of subtypes in a variable list
int     vlistNsubtypes(int vlistID);

void    vlistDefNtsteps(int vlistID, int nts);
int     vlistNtsteps(int vlistID);
SizeType vlistGridsizeMax(int vlistID);
int     vlistGrid(int vlistID, int index);
int     vlistGridIndex(int vlistID, int gridID);
void    vlistChangeGridIndex(int vlistID, int index, int gridID);
void    vlistChangeGrid(int vlistID, int gridID1, int gridID2);
int     vlistZaxis(int vlistID, int index);
int     vlistZaxisIndex(int vlistID, int zaxisID);
void    vlistChangeZaxisIndex(int vlistID, int index, int zaxisID);
void    vlistChangeZaxis(int vlistID, int zaxisID1, int zaxisID2);
int     vlistNumFields(int vlistID);
int     vlistSubtype(int vlistID, int index);
int     vlistSubtypeIndex(int vlistID, int subtypeID);

//      vlistDefTaxis: Define the time axis of a variable list
void    vlistDefTaxis(int vlistID, int taxisID);

//      vlistInqTaxis: Get the time axis of a variable list
int     vlistInqTaxis(int vlistID);

void    vlistDefTable(int vlistID, int tableID);
int     vlistInqTable(int vlistID);
void    vlistDefInstitut(int vlistID, int instID);
int     vlistInqInstitut(int vlistID);
void    vlistDefModel(int vlistID, int modelID);
int     vlistInqModel(int vlistID);


// VLIST VAR routines

//      vlistDefVarTiles: Create a new tile-based variable
int     vlistDefVarTiles(int vlistID, int gridID, int zaxisID, int timetype, int tilesetID);

//      vlistDefVar: Create a new variable
int     vlistDefVar(int vlistID, int gridID, int zaxisID, int timetype);

void    vlistChangeVarGrid(int vlistID, int varID, int gridID);
void    vlistChangeVarZaxis(int vlistID, int varID, int zaxisID);

void    vlistInqVar(int vlistID, int varID, int *gridID, int *zaxisID, int *timetype);
int     vlistInqVarGrid(int vlistID, int varID);
int     vlistInqVarZaxis(int vlistID, int varID);

//      used in MPIOM
int     vlistInqVarID(int vlistID, int code);

void    vlistDefVarTimetype(int vlistID, int varID, int timetype);
int     vlistInqVarTimetype(int vlistID, int varID);

void    vlistDefVarTsteptype(int vlistID, int varID, int tsteptype);

//      vlistInqVarTsteptype: Get the timestep type of a Variable
int     vlistInqVarTsteptype(int vlistID, int varID);

void    vlistDefVarCompType(int vlistID, int varID, int comptype);
int     vlistInqVarCompType(int vlistID, int varID);
void    vlistDefVarCompLevel(int vlistID, int varID, int complevel);
int     vlistInqVarCompLevel(int vlistID, int varID);

//      vlistDefVarParam: Define the parameter number of a Variable
void    vlistDefVarParam(int vlistID, int varID, int param);

//      vlistInqVarParam: Get the parameter number of a Variable
int     vlistInqVarParam(int vlistID, int varID);

//      vlistDefVarCode: Define the code number of a Variable
void    vlistDefVarCode(int vlistID, int varID, int code);

//      vlistInqVarCode: Get the code number of a Variable
int     vlistInqVarCode(int vlistID, int varID);

//      vlistDefVarDatatype: Define the data type of a Variable
void    vlistDefVarDatatype(int vlistID, int varID, int datatype);

//      vlistInqVarDatatype: Get the data type of a Variable
int     vlistInqVarDatatype(int vlistID, int varID);

void    vlistDefVarXYZ(int vlistID, int varID, int xyz);
int     vlistInqVarXYZ(int vlistID, int varID);

void    vlistDefVarNSB(int vlistID, int varID, int nsb);
int     vlistInqVarNSB(int vlistID, int varID);

int     vlistInqVarNumber(int vlistID, int varID);

void    vlistDefVarInstitut(int vlistID, int varID, int instID);
int     vlistInqVarInstitut(int vlistID, int varID);
void    vlistDefVarModel(int vlistID, int varID, int modelID);
int     vlistInqVarModel(int vlistID, int varID);
void    vlistDefVarTable(int vlistID, int varID, int tableID);
int     vlistInqVarTable(int vlistID, int varID);

//      vlistDefVarName: Define the name of a Variable
void    vlistDefVarName(int vlistID, int varID, const char *name);

//      vlistInqVarName: Get the name of a Variable
void    vlistInqVarName(int vlistID, int varID, char *name);

//      vlistCopyVarName: Safe and convenient version of vlistInqVarName
char   *vlistCopyVarName(int vlistId, int varId);

//      vlistDefVarStdname: Define the standard name of a Variable
void    vlistDefVarStdname(int vlistID, int varID, const char *stdname);

//      vlistInqVarStdname: Get the standard name of a Variable
void    vlistInqVarStdname(int vlistID, int varID, char *stdname);

//      vlistDefVarLongname: Define the long name of a Variable
void    vlistDefVarLongname(int vlistID, int varID, const char *longname);

//      vlistInqVarLongname: Get the long name of a Variable
void    vlistInqVarLongname(int vlistID, int varID, char *longname);

//      vlistDefVarUnits: Define the units of a Variable
void    vlistDefVarUnits(int vlistID, int varID, const char *units);

//      vlistInqVarUnits: Get the units of a Variable
void    vlistInqVarUnits(int vlistID, int varID, char *units);

//      vlistDefVarMissval: Define the missing value of a Variable
void    vlistDefVarMissval(int vlistID, int varID, double missval);

//      vlistInqVarMissval: Get the missing value of a Variable
double  vlistInqVarMissval(int vlistID, int varID);

SizeType vlistInqVarSize(int vlistID, int varID);

void    vlistDefIndex(int vlistID, int varID, int levID, int index);
int     vlistInqIndex(int vlistID, int varID, int levID);
void    vlistDefFlag(int vlistID, int varID, int levID, int flag);
int     vlistInqFlag(int vlistID, int varID, int levID);
int     vlistFindVar(int vlistID, int fvarID);
int     vlistFindLevel(int vlistID, int fvarID, int flevelID);
int     vlistMergedVar(int vlistID, int varID);
int     vlistMergedLevel(int vlistID, int varID, int levelID);

int     pvlistInqFlag(void *vlistPtr, int varID, int levelID);

//      cdiClearAdditionalKeys: Clear the list of additional GRIB keys
void    cdiClearAdditionalKeys(void);
//      cdiDefAdditionalKey: Register an additional GRIB key which is read when file is opened
void    cdiDefAdditionalKey(const char *string);

//      vlistDefVarIntKey: Set an arbitrary keyword/integer value pair for GRIB API
void    vlistDefVarIntKey(int vlistID, int varID, const char *name, int value);
//      vlistDefVarDblKey: Set an arbitrary keyword/double value pair for GRIB API
void    vlistDefVarDblKey(int vlistID, int varID, const char *name, double value);

//      vlistHasVarKey: returns 1 if meta-data key was read, 0 otherwise
int     vlistHasVarKey(int vlistID, int varID, const char *name);
//      vlistInqVarDblKey: raw access to GRIB meta-data
double  vlistInqVarDblKey(int vlistID, int varID, const char *name);
//      vlistInqVarIntKey: raw access to GRIB meta-data
int     vlistInqVarIntKey(int vlistID, int varID, const char *name);

// CDI attributes

//      cdiInqNatts: Get number of attributes assigned to this variable
int     cdiInqNatts(int cdiID, int varID, int *nattsp);
//      cdiInqAtt: Get information about an attribute
int     cdiInqAtt(int cdiID, int varID, int attrnum, char *name, int *typep, int *lenp);
int     cdiInqAttLen(int cdiID, int varID, const char *name);
int     cdiInqAttType(int cdiID, int varID, const char *name);
int     cdiDelAtt(int cdiID, int varID, const char *name);

int     cdiCopyAtts(int cdiID1, int varID1, int cdiID2, int varID2);

//      cdiDefAttInt: Define an integer attribute
int     cdiDefAttInt(int cdiID, int varID, const char *name, int type, int len, const int ip[]);
//      cdiDefAttFlt: Define a floating point attribute
int     cdiDefAttFlt(int cdiID, int varID, const char *name, int type, int len, const double dp[]);
//      cdiDefAttTxt: Define a text attribute
int     cdiDefAttTxt(int cdiID, int varID, const char *name, int len, const char *tp_cbuf);

//      cdiInqAttInt: Get the value(s) of an integer attribute
int     cdiInqAttInt(int cdiID, int varID, const char *name, int mlen, int ip[]);
//      cdiInqAttFlt: Get the value(s) of a floating point attribute
int     cdiInqAttFlt(int cdiID, int varID, const char *name, int mlen, double dp[]);
//      cdiInqAttTxt: Get the value(s) of a text attribute
int     cdiInqAttTxt(int cdiID, int varID, const char *name, int mlen, char *tp_cbuf);


// GRID routines

void    gridName(int gridtype, char *gridname);
const char *gridNamePtr(int gridtype);

void    gridCompress(int gridID);

void    gridDefMaskGME(int gridID, const int mask[]);
int     gridInqMaskGME(int gridID, int mask[]);

void    gridDefMask(int gridID, const int mask[]);
int     gridInqMask(int gridID, int mask[]);

//      gridCreate: Create a horizontal Grid
int     gridCreate(int gridtype, SizeType size);

//      gridDestroy: Destroy a horizontal Grid
void    gridDestroy(int gridID);

//      gridDuplicate: Duplicate a Grid
int     gridDuplicate(int gridID);

//      gridDefProj: Define the projection ID of a Grid
void    gridDefProj(int gridID, int projID);

//      gridInqProj: Get the projection ID of a Grid
int     gridInqProj(int gridID);

//      gridInqProjType: Get the projection type
int     gridInqProjType(int gridID);

//      gridInqType: Get the type of a Grid
int     gridInqType(int gridID);

//      gridInqSize: Get the size of a Grid
SizeType gridInqSize(int gridID);

//      gridDefXsize: Define the size of a X-axis
void    gridDefXsize(int gridID, SizeType xsize);

//      gridInqXsize: Get the size of a X-axis
SizeType gridInqXsize(int gridID);

//      gridDefYsize: Define the size of a Y-axis
void    gridDefYsize(int gridID, SizeType ysize);

//      gridInqYsize: Get the size of a Y-axis
SizeType gridInqYsize(int gridID);

void    gridDefIndices(int gridID, const int64_t *indices);
SizeType gridInqIndices(int gridID, int64_t *indices);

//      gridDefNP: Define the number of parallels between a pole and the equator
void    gridDefNP(int gridID, int np);

//      gridInqNP: Get the number of parallels between a pole and the equator
int     gridInqNP(int gridID);

//      gridDefXvals: Define the values of a X-axis
void    gridDefXvals(int gridID, const double xvals[]);

//      gridInqXvals: Get all values of a X-axis
SizeType gridInqXvals(int gridID, double xvals[]);
SizeType gridInqXvalsPart(int gridID, int start, SizeType size, double xvals[]);
const double *gridInqXvalsPtr(int gridID);

//      gridInqXIsc: Find out whether X-coordinate is of type CHAR
int     gridInqXIsc(int gridID);

//      gridInqXCvals: Get strings from X-axis in case grid is of type GRID_CHARXY
SizeType gridInqXCvals(int gridID, char *xcvals[]);

//      gridDefYvals: Define the values of a Y-axis
void    gridDefYvals(int gridID, const double yvals[]);

//      gridInqYvals: Get all values of a Y-axis
SizeType gridInqYvals(int gridID, double yvals[]);
SizeType gridInqYvalsPart(int gridID, int start, SizeType size, double yvals[]);
const double *gridInqYvalsPtr(int gridID);

//      gridInqYIsc: Find out whether Y-coordinate is of type CHAR
int     gridInqYIsc(int gridID);

//      gridInqYCvals: Get strings from Y-axis in case grid is of type GRID_CHARXY
SizeType gridInqYCvals(int gridID, char *ycvals[]);

// CDI var keys

// String keys
#define  CDI_KEY_NAME                          942  // Variable name
#define  CDI_KEY_LONGNAME                      943  // Long name of the variable
#define  CDI_KEY_STDNAME                       944  // CF Standard name of the variable
#define  CDI_KEY_UNITS                         945  // Units of the variable
#define  CDI_KEY_DATATYPE                      946  // Data type
#define  CDI_KEY_REFERENCEURI                  947  // Reference URI to grid file

// Integer keys
#define  CDI_KEY_NUMBEROFGRIDUSED              961  // GRIB2 numberOfGridUsed
#define  CDI_KEY_NUMBEROFGRIDINREFERENCE       962  // GRIB2 numberOfGridInReference
#define  CDI_KEY_NUMBEROFVGRIDUSED             963  // GRIB2 numberOfVGridUsed
#define  CDI_KEY_NLEV                          964  // GRIB2 nlev
#define  CDI_KEY_CHUNKTYPE                     965  // ChunkType: CDI_CHUNK_AUTO/CDI_CHUNK_GRID/CDI_CHUNK_LINES
#define  CDI_KEY_CHUNKSIZE                     966  // ChunkSize
#define  CDI_KEY_CHUNKSIZE_DIMT                967  // ChunkSize time dimension
#define  CDI_KEY_CHUNKSIZE_DIMZ                968  // ChunkSize zaxis dimension
#define  CDI_KEY_CHUNKSIZE_DIMY                969  // ChunkSize yaxis dimension
#define  CDI_KEY_CHUNKSIZE_DIMX                970  // ChunkSize xaxis dimension

// Floating point keys
#define  CDI_KEY_MISSVAL                       701  // Missing value
#define  CDI_KEY_ADDOFFSET                     702  // Add offset
#define  CDI_KEY_SCALEFACTOR                   703  // Scale factor
#define  CDI_KEY_FILTERSPEC_IN                 720  // NetCDF4 filter specification read in
#define  CDI_KEY_FILTERSPEC                    721  // NetCDF4 filter specification

// Byte array keys
#define  CDI_KEY_UUID                          960  // UUID for grid/Z-axis reference [size: CDI_UUID_SIZE]


#define  CDI_KEY_DIMNAME                       941  // Dimension name

#define  CDI_KEY_PSNAME                        950  // Z-axis surface pressure name
#define  CDI_KEY_P0NAME                        951  // Z-axis reference pressure name
#define  CDI_KEY_P0VALUE                       952  // Z-axis reference pressure in Pa

#define  CDI_KEY_TABLESVERSION                 801  // GRIB2 tablesVersion
#define  CDI_KEY_LOCALTABLESVERSION            802  // GRIB2 localTablesVersion
#define  CDI_KEY_TYPEOFGENERATINGPROCESS       803  // GRIB2 typeOfGeneratingProcess
#define  CDI_KEY_PRODUCTDEFINITIONTEMPLATE     804  // GRIB2 productDefinitionTemplate
#define  CDI_KEY_TYPEOFPROCESSEDDATA           805  // GRIB2 typeOfProcessedData
#define  CDI_KEY_SHAPEOFTHEEARTH               806  // GRIB2 shapeOfTheEarth
#define  CDI_KEY_BACKGROUNDPROCESS             807  // GRIB2 backgroundProcess
#define  CDI_KEY_TYPEOFENSEMBLEFORECAST        808  // GRIB2 typeOfEnsembleForecast
#define  CDI_KEY_NUMBEROFFORECASTSINENSEMBLE   809  // GRIB2 numberOfForecastsInEnsemble
#define  CDI_KEY_PERTURBATIONNUMBER            810  // GRIB2 perturbationNumber
#define  CDI_KEY_CENTRE                        811  // GRIB2 centre
#define  CDI_KEY_SUBCENTRE                     812  // GRIB2 subCentre
#define  CDI_KEY_MPIMTYPE                      813  // GRIB2 mpimType
#define  CDI_KEY_MPIMCLASS                     814  // GRIB2 mpimClass
#define  CDI_KEY_MPIMUSER                      815  // GRIB2 mpimUser
#define  CDI_KEY_REVSTATUS                     816  // GRIB2 revStatus
#define  CDI_KEY_REVNUMBER                     817  // GRIB2 revNumber
#define  CDI_KEY_GRIB2LOCALSECTIONNUMBER       818  // GRIB2 grib2LocalSectionNumber
#define  CDI_KEY_SECTION2PADDINGLENGTH         819  // GRIB2 length of section2Padding
#define  CDI_KEY_SECTION2PADDING               820  // GRIB2 section2Padding
#define  CDI_KEY_CONSTITUENTTYPE               821  // GRIB2 constituentType
#define  CDI_KEY_TYPEOFTIMEINCREMENT           822  // GRIB2 typeOfTimeIncrement
#define  CDI_KEY_TYPEOFFIRSTFIXEDSURFACE       823  // GRIB2 typeOfFirstFixedSurface
#define  CDI_KEY_TYPEOFSECONDFIXEDSURFACE      824  // GRIB2 typeOfSecondFixedSurface
#define  CDI_KEY_UVRELATIVETOGRID              825  // GRIB  uvRelativeToGrid
#define  CDI_KEY_SCANNINGMODE                  826  // GRIB  scanningMode

#define  CDI_KEY_VDIMNAME                      920  // Vertex dimension name
#define  CDI_KEY_GRIDMAP_VARTYPE               921  // Grid mapping var datatype
#define  CDI_KEY_GRIDMAP_VARNAME               922  // Grid mapping var name
#define  CDI_KEY_GRIDMAP_NAME                  923  // Grid mapping name

//      cdiDefKeyInt: Define an integer value from a key
int     cdiDefKeyInt(int cdiID, int varID, int key, int value);

//      cdiInqKeyInt: Get an integer value from a key
int     cdiInqKeyInt(int cdiID, int varID, int key, int *value);

//      cdiDefKeyFloat: Define a float value from a key
int     cdiDefKeyFloat(int cdiID, int varID, int key, double value);

//      cdiInqKeyFloat Get a float value from a key
int     cdiInqKeyFloat(int cdiID, int varID, int key, double *value);

//      cdiDefKeyBytes: Define a byte array from a key
int     cdiDefKeyBytes(int cdiID, int varID, int key, const unsigned char bytes[], int length);

//      cdiInqKeyBytes: Get a byte array from a key
int     cdiInqKeyBytes(int cdiID, int varID, int key, unsigned char bytes[], int *length);

//      cdiDefKeyString: Define a string from a key
int     cdiDefKeyString(int cdiID, int varID, int key, const char *string);

//      cdiInqKeyString: Get a string from a key
int     cdiInqKeyString(int cdiID, int varID, int key, char *string, int *length);

//      cdiInqKeyLen: Get the length of the string representation of the key
int     cdiInqKeyLen(int cdiID, int varID, int key, int *length);

int     cdiCopyKeys(int cdiID1, int varID1, int cdiID2, int varID2);

int     cdiCopyKey(int cdiID1, int varID1, int key, int cdiID2);

int     cdiDeleteKey(int cdiID, int varID, int key);

// GRID routines

//      gridDefXname: Define the name of a X-axis
void    gridDefXname(int gridID, const char *xname);

//      gridInqXname: Get the name of a X-axis
void    gridInqXname(int gridID, char *xname);

//      gridDefXlongname: Define the longname of a X-axis
void    gridDefXlongname(int gridID, const char *xlongname);

//      gridInqXlongname: Get the longname of a X-axis
void    gridInqXlongname(int gridID, char *xlongname);

//      gridDefXunits: Define the units of a X-axis
void    gridDefXunits(int gridID, const char *xunits);

//      gridInqXunits: Get the units of a X-axis
void    gridInqXunits(int gridID, char *xunits);

//      gridDefYname: Define the name of a Y-axis
void    gridDefYname(int gridID, const char *yname);

//      gridInqYname: Get the name of a Y-axis
void    gridInqYname(int gridID, char *yname);

//      gridDefYlongname: Define the longname of a Y-axis
void    gridDefYlongname(int gridID, const char *ylongname);

//      gridInqYlongname: Get the longname of a Y-axis
void    gridInqYlongname(int gridID, char *ylongname);

//      gridDefYunits: Define the units of a Y-axis
void    gridDefYunits(int gridID, const char *yunits);

//      gridInqYunits: Get the units of a Y-axis
void    gridInqYunits(int gridID, char *yunits);

void    gridDefDatatype(int gridID, int datatype);
int     gridInqDatatype(int gridID);

//      gridInqXval: Get one value of a X-axis
double  gridInqXval(int gridID, SizeType index);

//      gridInqYval: Get one value of a Y-axis
double  gridInqYval(int gridID, SizeType index);

double  gridInqXinc(int gridID);
double  gridInqYinc(int gridID);

int     gridIsCircular(int gridID);

int     gridInqTrunc(int gridID);
void    gridDefTrunc(int gridID, int trunc);

// Reference of an unstructured grid

//      gridDefNumber: Define the reference number for an unstructured grid
void    gridDefNumber(int gridID, int number);

//      gridInqNumber: Get the reference number to an unstructured grid
int     gridInqNumber(int gridID);

//      gridDefPosition: Define the position of grid in the reference file
void    gridDefPosition(int gridID, int position);

//      gridInqPosition: Get the position of grid in the reference file
int     gridInqPosition(int gridID);

//      gridDefReference: Define the reference URI for an unstructured grid
void    gridDefReference(int gridID, const char *reference);

//      gridInqReference: Get the reference URI to an unstructured grid
int     gridInqReference(int gridID, char *reference);

//      gridDefUUID: Define the UUID of an unstructured grid
void    gridDefUUID(int gridID, const unsigned char uuid[CDI_UUID_SIZE]);

//      gridInqUUID: Get the UUID of an unstructured grid
void    gridInqUUID(int gridID, unsigned char uuid[CDI_UUID_SIZE]);

// Rotated Lon/Lat grid
void    gridDefParamRLL(int gridID, double xpole, double ypole, double angle);
void    gridInqParamRLL(int gridID, double *xpole, double *ypole, double *angle);

// Hexagonal GME grid
void    gridDefParamGME(int gridID, int nd, int ni, int ni2, int ni3);
void    gridInqParamGME(int gridID, int *nd, int *ni, int *ni2, int *ni3);

void    gridDefArea(int gridID, const double area[]);
void    gridInqArea(int gridID, double area[]);
int     gridHasArea(int gridID);

//      gridDefNvertex: Define the number of vertex of a Gridbox
void    gridDefNvertex(int gridID, int nvertex);

//      gridInqNvertex: Get the number of vertex of a Gridbox
int     gridInqNvertex(int gridID);

//      gridDefXbounds: Define the bounds of a X-axis
void    gridDefXbounds(int gridID, const double xbounds[]);

//      gridInqXbounds: Get the bounds of a X-axis
SizeType gridInqXbounds(int gridID, double xbounds[]);
SizeType gridInqXboundsPart(int gridID, int start, SizeType size, double xbounds[]);
const double *gridInqXboundsPtr(int gridID);

//      gridDefYbounds: Define the bounds of a Y-axis
void    gridDefYbounds(int gridID, const double ybounds[]);

//      gridInqYbounds: Get the bounds of a Y-axis
SizeType gridInqYbounds(int gridID, double ybounds[]);
SizeType gridInqYboundsPart(int gridID, int start, SizeType size, double ybounds[]);
const double *gridInqYboundsPtr(int gridID);

void    gridDefReducedPoints(int gridID, int reducedPointsSize, const int reducedPoints[]);
void    gridInqReducedPoints(int gridID, int reducedPoints[]);
void    gridChangeType(int gridID, int gridtype);

void    gridDefComplexPacking(int gridID, int lpack);
int     gridInqComplexPacking(int gridID);

// ZAXIS routines

void    zaxisName(int zaxistype, char *zaxisname);
const char *zaxisNamePtr(int leveltype);

//      zaxisCreate: Create a vertical Z-axis
int     zaxisCreate(int zaxistype, int size);

//      zaxisDestroy: Destroy a vertical Z-axis
void    zaxisDestroy(int zaxisID);

//      zaxisInqType: Get the type of a Z-axis
int     zaxisInqType(int zaxisID);

//      zaxisInqSize: Get the size of a Z-axis
int     zaxisInqSize(int zaxisID);

//      zaxisDuplicate: Duplicate a Z-axis
int     zaxisDuplicate(int zaxisID);

//      zaxisDefLevels: Define the levels of a Z-axis
void    zaxisDefLevels(int zaxisID, const double levels[]);

//      zaxisDefCvals: Define area types of a Z-axis
void    zaxisDefCvals(int zaxisID, const char *cvals[], int clength);

//      zaxisInqLevels: Get all levels of a Z-axis
int     zaxisInqLevels(int zaxisID, double levels[]);

//      zaxisInqCLen: Get maximal string length of character Z-axis
int     zaxisInqCLen(int zaxisID);

//      zaxisInqCVals: Get all string values of a character Z-axis
int     zaxisInqCVals(int zaxisID, char ***clevels);

//      zaxisDefLevel: Define one level of a Z-axis
void    zaxisDefLevel(int zaxisID, int levelID, double levels);

//      zaxisInqLevel: Get one level of a Z-axis
double  zaxisInqLevel(int zaxisID, int levelID);

//      zaxisDefNlevRef: Define the number of half levels of a generalized Z-axis
void    zaxisDefNlevRef(int gridID, int nhlev);

//      zaxisInqNlevRef: Get the number of half levels of a generalized Z-axis
int     zaxisInqNlevRef(int gridID);

//      zaxisDefNumber: Define the reference number for a generalized Z-axis
void    zaxisDefNumber(int gridID, int number);

//      zaxisInqNumber: Get the reference number to a generalized Z-axis
int     zaxisInqNumber(int gridID);

//      zaxisDefUUID: Define the UUID of a generalized Z-axis
void    zaxisDefUUID(int zaxisID, const unsigned char uuid[CDI_UUID_SIZE]);

//      zaxisInqUUID: Get the UUID of a generalized Z-axis
void    zaxisInqUUID(int zaxisID, unsigned char uuid[CDI_UUID_SIZE]);

//      zaxisDefName: Define the name of a Z-axis
void    zaxisDefName(int zaxisID, const char *name_optional);

//      zaxisInqName: Get the name of a Z-axis
void    zaxisInqName(int zaxisID, char *name);

//      zaxisDefLongname: Define the longname of a Z-axis
void    zaxisDefLongname(int zaxisID, const char *longname_optional);

//      zaxisInqLongname: Get the longname of a Z-axis
void    zaxisInqLongname(int zaxisID, char *longname);

//      zaxisDefUnits: Define the units of a Z-axis
void    zaxisDefUnits(int zaxisID, const char *units_optional);

//      zaxisInqUnits: Get the units of a Z-axis
void    zaxisInqUnits(int zaxisID, char *units);

//      zaxisInqStdname: Get the standard name of a Z-axis
void    zaxisInqStdname(int zaxisID, char *stdname);

void    zaxisDefDatatype(int zaxisID, int datatype);
int     zaxisInqDatatype(int zaxisID);

void    zaxisDefPositive(int zaxisID, int positive);
int     zaxisInqPositive(int zaxisID);

void    zaxisDefScalar(int zaxisID);
int     zaxisInqScalar(int zaxisID);

void    zaxisDefVct(int zaxisID, int size, const double vct[]);
void    zaxisInqVct(int zaxisID, double vct[]);
int     zaxisInqVctSize(int zaxisID);
const double *zaxisInqVctPtr(int zaxisID);
void    zaxisDefLbounds(int zaxisID, const double lbounds[]);
int     zaxisInqLbounds(int zaxisID, double lbounds_optional[]);
double  zaxisInqLbound(int zaxisID, int index);
void    zaxisDefUbounds(int zaxisID, const double ubounds[]);
int     zaxisInqUbounds(int zaxisID, double ubounds_optional[]);
double  zaxisInqUbound(int zaxisID, int index);
void    zaxisDefWeights(int zaxisID, const double weights[]);
int     zaxisInqWeights(int zaxisID, double weights_optional[]);
void    zaxisChangeType(int zaxisID, int zaxistype);

// TAXIS routines

//      taxisCreate: Create a Time axis
int     taxisCreate(int taxistype);

//      taxisDestroy: Destroy a Time axis
void    taxisDestroy(int taxisID);

int     taxisDuplicate(int taxisID);

void    taxisCopyTimestep(int taxisIDdes, int taxisIDsrc);

void    taxisDefType(int taxisID, int taxistype);
int     taxisInqType(int taxisID);

//      taxisDefVdate: Define the verification date
void    taxisDefVdate(int taxisID, int date);

//      taxisDefVtime: Define the verification time
void    taxisDefVtime(int taxisID, int time);

//      taxisInqVdate: Get the verification date
int     taxisInqVdate(int taxisID);

//      taxisInqVtime: Get the verification time
int     taxisInqVtime(int taxisID);

//      taxisDefRdate: Define the reference date
void    taxisDefRdate(int taxisID, int date);

//      taxisDefRtime: Define the reference time
void    taxisDefRtime(int taxisID, int time);

//      taxisInqRdate: Get the reference date
int     taxisInqRdate(int taxisID);

//      taxisInqRtime: Get the reference time
int     taxisInqRtime(int taxisID);

int     taxisHasBounds(int taxisID);
void    taxisWithBounds(int taxisID);

void    taxisDeleteBounds(int taxisID);

void    taxisDefVdateBounds(int taxisID, int vdate_lb, int vdate_ub);

void    taxisDefVtimeBounds(int taxisID, int vtime_lb, int vtime_ub);

void    taxisInqVdateBounds(int taxisID, int *vdate_lb, int *vdate_ub);

void    taxisInqVtimeBounds(int taxisID, int *vtime_lb, int *vtime_ub);

//      taxisDefCalendar: Define the calendar
void    taxisDefCalendar(int taxisID, int calendar);

//      taxisInqCalendar: Get the calendar
int     taxisInqCalendar(int taxisID);

void    taxisDefTunit(int taxisID, int tunit);
int     taxisInqTunit(int taxisID);

void    taxisDefForecastTunit(int taxisID, int tunit);
int     taxisInqForecastTunit(int taxisID);

void    taxisDefForecastPeriod(int taxisID, double fc_period);
double  taxisInqForecastPeriod(int taxisID);

void    taxisDefNumavg(int taxisID, int numavg);
int     taxisInqNumavg(int taxisID);

const char *taxisNamePtr(int taxisID);
const char *tunitNamePtr(int tunitID);


// Institut routines

int     institutDef(int center, int subcenter, const char *name, const char *longname);
int     institutInq(int center, int subcenter, const char *name, const char *longname);
int     institutInqNumber(void);
int     institutInqCenter(int instID);
int     institutInqSubcenter(int instID);
const char *institutInqNamePtr(int instID);
const char *institutInqLongnamePtr(int instID);

// Model routines

int     modelDef(int instID, int modelgribID, const char *name);
int     modelInq(int instID, int modelgribID, const char *name);
int     modelInqInstitut(int modelID) ;
int     modelInqGribID(int modelID);
const char *modelInqNamePtr(int modelID);

// Table routines

//      tableFWriteC: write table of parameters to FILE* in C language format
void    tableFWriteC(FILE *ptfp, int tableID);
//      tableWrite: write table of parameters to file in tabular format
void    tableWrite(const char *filename, int tableID);
//      tableRead: read table of parameters from file in tabular format
int     tableRead(const char *tablefile);
int     tableDef(int modelID, int tablenum, const char *tablename);

const char *tableInqNamePtr(int tableID);

int     tableInq(int modelID, int tablenum, const char *tablename);
int     tableInqNumber(void);

int     tableInqNum(int tableID);
int     tableInqModel(int tableID);

void    tableInqEntry(int tableID, int id, int ltype, char *name, char *longname, char *units);

// Subtype routines

//      subtypeCreate: Create a variable subtype
int     subtypeCreate(int subtype);

//      Gives a textual summary of the variable subtype
void    subtypePrint(int subtypeID);

// Compares two subtype data structures
int     subtypeCompare(int subtypeID1, int subtypeID2);

//      subtypeInqSize: Get the size of a subtype (e.g. no. of tiles)
int     subtypeInqSize(int subtypeID);

//      subtypeInqActiveIndex: Get the currently active index of a subtype (e.g. current tile index)
int     subtypeInqActiveIndex(int subtypeID);

//      subtypeDefActiveIndex: Set the currently active index of a subtype (e.g. current tile index)
void    subtypeDefActiveIndex(int subtypeID, int index);

//      Generate a "query object" out of a key-value pair
subtype_query_t keyValuePair(const char *key, int value);

//       Generate an AND-combined "query object" out of two previous query objects
subtype_query_t matchAND(subtype_query_t q1, subtype_query_t q2);

//      subtypeInqSubEntry: Returns subtype entry ID for a given criterion
int     subtypeInqSubEntry(int subtypeID, subtype_query_t criterion);

//      subtypeInqTile: Specialized version of subtypeInqSubEntry looking for tile/attribute pair
int     subtypeInqTile(int subtypeID, int tileindex, int attribute);

//      subtypeInqAttribute: Inquire the value of a subtype attribute. Returns CDI_EINVAL if the attribute does not exist.
int     subtypeInqAttribute(int subtypeID, int index, const char *key, int *outValue);

//      vlistInqVarSubtype: Return subtype ID for a given variable
int     vlistInqVarSubtype(int vlistID, int varID);

void gribapiLibraryVersion(int *major_version, int *minor_version, int *revision_version);

// Compatibility functions for release 1.8.3 (obsolete functions)
void zaxisDefLtype(int zaxisID, int ltype);
int  vlistInqVarTypeOfGeneratingProcess(int vlistID, int varID);
void vlistDefVarTypeOfGeneratingProcess(int vlistID, int varID, int typeOfGeneratingProcess);
void vlistDefVarProductDefinitionTemplate(int vlistID, int varID, int productDefinitionTemplate);

// Compatibility functions for ParaView vtkCDIReader (obsolete functions)
int vlistNgrids(int vlistID); // calls vlistNumGrids()
int vlistNzaxis(int vlistID); // calls vlistNumZaxis()

#ifdef __cplusplus
}
#endif

// End of fortran interface
//FINT_OFF  <--- don't change or remove this line!!!

#ifdef __cplusplus
extern "C" {
#endif

// CDI query interface

typedef struct
{
  int numEntries;
  // Names
  int numNames;
  bool *namesFound;
  char **names;
  // Grid cell indices
  int numCellidx;
  bool *cellidxFound;
  size_t *cellidx;
  // Level indices
  int numLevidx;
  bool *levidxFound;
  int *levidx;
  // Time step indices
  int numStepidx;
  bool *stepidxFound;
  int *stepidx;
} CdiQuery;

CdiQuery *cdiQueryCreate(void);
CdiQuery *cdiQueryClone(const CdiQuery *query);
void cdiQueryDelete(CdiQuery *query);
void cdiQuerySetNames(CdiQuery *query, int numNames, char **names);
void cdiQuerySetCellidx(CdiQuery *query, int numCellidx, size_t *cellidx);
void cdiQuerySetLevidx(CdiQuery *query, int numLevidx, int *levidx);
void cdiQuerySetStepidx(CdiQuery *query, int numStepidx, int *stepidx);
size_t cdiQueryGetCellidx(const CdiQuery *query, int index);
int cdiQueryName(CdiQuery *query, const char *name);
int cdiQueryCellidx(CdiQuery *query, size_t cellidx);
int cdiQueryLevidx(CdiQuery *query, int levidx);
int cdiQueryStepidx(CdiQuery *query, int stepidx);
int cdiQueryNumNames(const CdiQuery *query);
int cdiQueryNumCellidx(const CdiQuery *query);
int cdiQueryNumStepidx(const CdiQuery *query);
int cdiQueryNumEntries(const CdiQuery *query);
int cdiQueryNumEntriesFound(const CdiQuery *query);
void cdiQueryPrint(const CdiQuery *query);
void cdiQueryPrintEntriesNotFound(const CdiQuery *query);

// streamOpenReadQuery: Open a dataset for reading and apply query
int streamOpenReadQuery(const char *path, CdiQuery *query);

// CDI interface for paraview vtkCDIReader.cxx


// taxisDefRdatetime: Define the reference date/time
void taxisDefRdatetime(int taxisID, CdiDateTime rDateTime);
// taxisInqRdatetime: Get the reference date/time
CdiDateTime taxisInqRdatetime(int taxisID);
// taxisDefFdatetime: Define the forecast reference date/time
void taxisDefFdatetime(int taxisID, CdiDateTime fDateTime);
// taxisInqFdatetime: Get the forecast reference date/time
CdiDateTime taxisInqFdatetime(int taxisID);
// taxisDefVdatetime: Define the verification date/time
void taxisDefVdatetime(int taxisID, CdiDateTime vDateTime);
// taxisInqVdatetime: Get the verification date/time
CdiDateTime taxisInqVdatetime(int taxisID);
void taxisDefVdatetimeBounds(int taxisID, CdiDateTime vDateTime_lb, CdiDateTime vDateTime_ub);
void taxisInqVdatetimeBounds(int taxisID, CdiDateTime *vDateTime_lb, CdiDateTime *vDateTime_ub);

// date format:  YYYYMMDD
// time format:    hhmmss

int64_t date_to_julday(int calendar, int64_t date);  // Used in paraview vtkCDIReader.cxx
int64_t julday_to_date(int calendar, int64_t julday);

int time_to_sec(int time);                           // Used in paraview vtkCDIReader.cxx
int sec_to_time(int secofday);

// CDI projection parameter interface

struct CDI_GridProjParams
{
  double mv;     // Missing value
  double lon_0;  // The East longitude of the meridian which is parallel to the Y-axis
  double lat_0;  // Latitude of the projection origin
  double lat_1;  // First latitude from the pole at which the secant cone cuts the sphere
  double lat_2;  // Second latitude at which the secant cone cuts the sphere
  // lat_ts = lat_1;
  double a;      // Semi-major axis or earth radius in metres (optional)
  double b;      // Semi-minor axis in metres (optional)
  double rf;     // Inverse flattening (1/f) (optional)
  double xval_0; // Longitude of the first grid point in degree (optional)
  double yval_0; // Latitude of the first grid point in degree (optional)
  double x_0;    // False easting (optional)
  double y_0;    // False northing (optional)
  double x_SP;   // Longitude of southern pole
  double y_SP;   // Latitude of southern pole
  int nside;     // HEALPix number of points along a side (number of data points should be = 12 * nside * nside)
  int order;     // HEALPix ordering convention (0:ring; 1:nested)
};

void gridProjParamsInit(struct CDI_GridProjParams *gridProjParams);

// Lambert Conformal Conic grid
void gridDefParamsLCC(int gridID, struct CDI_GridProjParams gridProjParams);
int  gridInqParamsLCC(int gridID, struct CDI_GridProjParams *gridProjParams);

// Polar stereographic grid
void gridDefParamsSTERE(int gridID, struct CDI_GridProjParams gridProjParams);
int  gridInqParamsSTERE(int gridID, struct CDI_GridProjParams *gridProjParams);

// HEALPix grid
void gridDefParamsHEALPIX(int gridID, struct CDI_GridProjParams gridProjParams);
int  gridInqParamsHEALPIX(int gridID, struct CDI_GridProjParams *gridProjParams);

#define HAVE_CDI_PROJ_FUNCS 1
extern int (*proj_lonlat_to_lcc_func)(struct CDI_GridProjParams gpp, size_t, double*, double*);
extern int (*proj_lcc_to_lonlat_func)(struct CDI_GridProjParams gpp, double, double, size_t, double*, double*);
extern int (*proj_lonlat_to_stere_func)(struct CDI_GridProjParams gpp, size_t, double*, double*);
extern int (*proj_stere_to_lonlat_func)(struct CDI_GridProjParams gpp, double, double, size_t, double*, double*);

// Used on CDO remap_scrip_io.cc
void cdf_def_var_filter(int ncid, int ncvarID, const char *filterSpec);

int cdi_has_ncfilter(void);
int cdi_has_ncdap(void);
int cdi_has_cgribex(void);

#ifdef __cplusplus
}
#endif

// clang-format on

#endif /* CDI_H_ */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _DMEMORY_H
#define _DMEMORY_H

// clang-format off

#include <stdio.h>

// if DEBUG_MEMORY is defined setenv MEMORY_DEBUG to debug memory
#define  DEBUG_MEMORY

#ifndef  WITH_FUNCTION_NAME
#define  WITH_FUNCTION_NAME
#endif

#ifdef  __cplusplus
extern "C" {
#endif

extern size_t  memTotal(void);
extern void    memDebug(int debug);
extern void    memExitOnError(void);

extern void   *memRealloc(void *ptr, size_t size, const char *file, const char *functionname, int line);
extern void   *memCalloc(size_t nobjs, size_t size, const char *file, const char *functionname, int line);
extern void   *memMalloc(size_t size, const char *file, const char *functionname, int line);
extern void    memFree(void *ptr, const char *file, const char *functionname, int line);

#ifdef  __cplusplus
}
#endif

#ifdef  DEBUG_MEMORY

#ifdef  WITH_FUNCTION_NAME
#define  Realloc(p, s)  memRealloc((p), (s), __FILE__, __func__, __LINE__)
#define   Calloc(n, s)   memCalloc((n), (s), __FILE__, __func__, __LINE__)
#define   Malloc(s)      memMalloc((s), __FILE__, __func__, __LINE__)
#define     Free(p)        memFree((p), __FILE__, __func__, __LINE__)
#else
#define  Realloc(p, s)  memRealloc((p), (s), __FILE__, (void *) NULL, __LINE__)
#define   Calloc(n, s)   memCalloc((n), (s), __FILE__, (void *) NULL, __LINE__)
#define   Malloc(s)      memMalloc((s), __FILE__, (void *) NULL, __LINE__)
#define     Free(p)        memFree((p), __FILE__, (void *) NULL, __LINE__)
#endif

#else

#include <stdlib.h>

#define  Realloc(p, s)  realloc((p), (s))
#define   Calloc(n, s)   calloc((n), (s))
#define   Malloc(s)      malloc((s))
#define     Free(p)        free((p))

#endif /* DEBUG_MEMORY */

// clang-format on

#endif /* _DMEMORY_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _ERROR_H_
#define _ERROR_H_

// clang-format off

#include <stdarg.h>
#include <stdlib.h>
#include <stdbool.h>

#ifndef  WITH_CALLER_NAME
#define  WITH_CALLER_NAME
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int _ExitOnError;  // If set to 1, exit on error (default 1)
extern int _Verbose;      // If set to 1, errors are reported (default 1)
extern int _Debug;        // If set to 1, debuggig (default 0)

void SysError_(const char *caller, const char *fmt, ...);
void    Error_(const char *caller, const char *fmt, ...);
void  Warning_(const char *caller, const char *fmt, ...);
/* delegate used by Warning_ unless mode is PIO */
void cdiWarning(const char *caller, const char *fmt, va_list ap);
void  Message_(const char *caller, const char *fmt, ...);

#ifdef WITH_CALLER_NAME
#  define  SysError(...)  SysError_(__func__, __VA_ARGS__)
#  define    Errorc(...)     Error_(  caller, __VA_ARGS__)
#  define     Error(...)     Error_(__func__, __VA_ARGS__)
#  define   Warning(...)   Warning_(__func__, __VA_ARGS__)
#  define  Messagec(...)   Message_(  caller, __VA_ARGS__)
#  define   Message(...)   Message_(__func__, __VA_ARGS__)
#else
#  define  SysError(...)  SysError_((void *), __VA_ARGS__)
#  define    Errorc(...)     Error_((void *), __VA_ARGS__)
#  define     Error(...)     Error_((void *), __VA_ARGS__)
#  define   Warning(...)   Warning_((void *), __VA_ARGS__)
#  define  Messagec(...)   Message_((void *), __VA_ARGS__)
#  define   Message(...)   Message_((void *), __VA_ARGS__)
#endif

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#  define  __attribute__(x)  /*NOTHING*/
#endif

void cdiAbortC(const char *caller, const char *filename,
               const char *functionname, int line,
               const char *errorString, ... )
  __attribute__((noreturn));
#define xabortC(caller, ...)                                    \
  cdiAbortC(caller, __FILE__, __func__, __LINE__, __VA_ARGS__ )
#define xabort(...)                                             \
  cdiAbortC(NULL, __FILE__, __func__, __LINE__, __VA_ARGS__ )
#define cdiAbort(file, func, line, ...)                 \
  cdiAbortC(NULL, (file), (func), (line), __VA_ARGS__)

#define xassert(arg) do {                       \
    if ((arg)) { } else {                       \
      xabort("assertion `" #arg "` failed");}   \
  } while(0)

void
cdiAbortC_serial(const char *caller, const char *filename,
                 const char *functionname, int line,
                 const char *errorString, va_list ap)
  __attribute__((noreturn));


bool cdiObsoleteInfo(const char *oldFunction, const char *newFunction);

#if defined (__cplusplus)
}
#endif

// clang-format on

#endif /* _ERROR_H_ */
#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
#endif



#include <stdbool.h>

#ifdef HAVE_LIBPTHREAD
#ifdef __APPLE__
#include <dispatch/dispatch.h>
#else
#include <errno.h>
#include <semaphore.h>
#endif

typedef struct sema
{
#ifdef __APPLE__
  dispatch_semaphore_t sem;
#else
  sem_t sem;
#endif
} sema_t;
#endif

struct AsyncJob
{
  bool inUse;
#ifdef HAVE_LIBPTHREAD
  sema_t request, completion;
#endif
  int (*work)(void *data);
  void *data;
  int result;
};

struct AsyncManager
{
  int workerCount, idleWorkerCount;
  AsyncJob *communicators;
};

#ifdef HAVE_LIBPTHREAD
static inline int
sema_init(sema_t *s, int pshared, uint32_t value)
{
  int status = 0;
#ifdef __APPLE__
  dispatch_semaphore_t *sem = &s->sem;

  (void) pshared;
  *sem = dispatch_semaphore_create(value);
#else
  status = sem_init(&s->sem, pshared, value);
#endif
  return status;
}

static inline int
sema_wait(sema_t *s)
{
#ifdef __APPLE__
  dispatch_semaphore_wait(s->sem, DISPATCH_TIME_FOREVER);
#else
  int r;

  do {
    r = sem_wait(&s->sem);
  } while (r == -1 && errno == EINTR);
#endif
  return 0;
}

static inline int
sema_post(sema_t *s)
{
#ifdef __APPLE__
  dispatch_semaphore_signal(s->sem);
#else
  sem_post(&s->sem);
#endif
  return 0;
}

static void *
workerMain(void *arg)
{
  AsyncJob *communicator = (AsyncJob *) arg;

  while (true)
  {
    while (sema_wait(&communicator->request))
      ;
    if (communicator->work)
    {
      communicator->result = communicator->work(communicator->data);
      if (sema_post(&communicator->completion)) xabort("sema_post() failed");
    }
    else
    {
      if (sema_post(&communicator->completion)) xabort("sema_post() failed");
      break;
    }
  }

  return NULL;
}

static void
startWorker(AsyncJob *communicator)
{
  communicator->inUse = false;
  communicator->work = NULL;
  communicator->data = NULL;
  communicator->result = 0;
  if (sema_init(&communicator->request, 0, 0)) xabort("sema_init() failed");
  if (sema_init(&communicator->completion, 0, 0)) xabort("sema_init() failed");

  pthread_t worker;
  if (pthread_create(&worker, NULL, workerMain, communicator)) xabort("pthread_create() failed");
  if (pthread_detach(worker)) xabort("pthread_detach() failed");
}
#endif

int
AsyncWorker_init(AsyncManager **jobManager, int threadCount)
{
  if (threadCount <= 0)
  {
    xabort("CPU core count discovery not implemented yet");
    return CDI_EINVAL;  // TODO: discover CPU core count, and set threadCount to a sensible positive value
  }

  if (*jobManager) return CDI_NOERR;

#ifdef HAVE_LIBPTHREAD
  AsyncManager *jobManager_ = *jobManager = (AsyncManager *) Malloc(sizeof(AsyncManager));
  jobManager_->workerCount = threadCount;
  jobManager_->communicators = (AsyncJob *) Malloc((size_t) threadCount * sizeof(AsyncJob));

  for (int i = 0; i < threadCount; i++) startWorker(jobManager_->communicators + i);
  jobManager_->idleWorkerCount = threadCount;
#else

  Error("pthread support not compiled in!");
#endif

  return CDI_NOERR;
}

AsyncJob *
AsyncWorker_requestWork(AsyncManager *jobManager, int (*work)(void *data), void *data)
{
  if (!jobManager) xabort("AsyncWorker_requestWork() called without calling AsyncWorker_init() first");
  if (!work)
    xabort("AsyncWorker_requestWork() called without a valid function pointer");  // need to catch this condition to stop users from
                                                                                  // terminating our worker threads

  // find an unused worker
  if (!jobManager->idleWorkerCount) return NULL;

  AsyncJob *worker = NULL;
  for (int i = 0; i < jobManager->workerCount; i++)
  {
    if (!jobManager->communicators[i].inUse)
    {
      worker = &jobManager->communicators[i];
      break;
    }
  }
  if (!worker) xabort("internal error: idleWorkerCount is not in sync with the worker states, please report this bug");

  // pass the request to that worker
  jobManager->idleWorkerCount--;
  worker->inUse = true;
  worker->work = work;
  worker->data = data;
  worker->result = 0;
#ifdef HAVE_LIBPTHREAD
  if (sema_post(&worker->request)) xabort("sema_post() failed");
#endif
  return worker;
}

int
AsyncWorker_wait(AsyncManager *jobManager, AsyncJob *job)
{
  if (!jobManager) xabort("AsyncWorker_wait() called without calling AsyncWorker_init() first");
  if (job < jobManager->communicators) return CDI_EINVAL;
  if (job >= jobManager->communicators + jobManager->workerCount) return CDI_EINVAL;
  if (!job->inUse) return CDI_EINVAL;

#ifdef HAVE_LIBPTHREAD
  while (sema_wait(&job->completion))
    ;
#endif
  int result = job->result;

  // reset the communicator
  job->work = NULL;
  job->data = NULL;
  job->result = 0;
  job->inUse = false;
  jobManager->idleWorkerCount++;

  return result;
}

int
AsyncWorker_availableWorkers(AsyncManager *jobManager)
{
  if (!jobManager) return 0;
  return jobManager->idleWorkerCount;
}

int
AsyncWorker_finalize(AsyncManager *jobManager)
{
  int result = CDI_NOERR;
  if (!jobManager) return CDI_NOERR;

  for (int i = 0; i < jobManager->workerCount; i++)
  {
    AsyncJob *curWorker = &jobManager->communicators[i];

    // finish any pending job
    if (curWorker->inUse)
    {
      AsyncWorker_wait(jobManager, curWorker);
      if (curWorker->result) result = curWorker->result;
    }

    // send the teardown signal
    curWorker->inUse = true;
    curWorker->work = NULL;
    curWorker->data = NULL;
    curWorker->result = 0;
#ifdef HAVE_LIBPTHREAD
    if (sema_post(&curWorker->request)) xabort("sema_post() failed");
#endif
    // wait for the worker to exit
    AsyncWorker_wait(jobManager, curWorker);
  }

  Free(jobManager->communicators);
  Free(jobManager);

  return result;
}
#ifndef _BASETIME_H
#define _BASETIME_H

#include <stdbool.h>

typedef struct
{
  int ncvarid;
  int ncdimid;
  int ncvarboundsid;
  int leadtimeid;
  bool hasUnits;
  bool isWRF;  // true for time axis in WRF format
} basetime_t;

void basetimeInit(basetime_t *basetime);

#endif /* _BASETIME_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stddef.h>  // for NULL

void
basetimeInit(basetime_t *basetime)
{
  if (basetime == NULL) Error("Internal problem! Basetime not allocated.");

  if (basetime)
  {
    basetime->ncvarid = CDI_UNDEFID;
    basetime->ncdimid = CDI_UNDEFID;
    basetime->ncvarboundsid = CDI_UNDEFID;
    basetime->leadtimeid = CDI_UNDEFID;
    basetime->hasUnits = false;
    basetime->isWRF = false;
  }
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _FILE_H
#define _FILE_H

#include <stdio.h>
#include <sys/types.h>

#define FILE_UNDEFID -1

#define FILE_TYPE_OPEN 1
#define FILE_TYPE_FOPEN 2

// buffer types for FILE_TYPE_OPEN
#define FILE_BUFTYPE_STD 1
#define FILE_BUFTYPE_MMAP 2

const char *fileLibraryVersion(void);

void fileDebug(int debug);

void *filePtr(int fileID);

int fileSetBufferType(int fileID, int type);
void fileSetBufferSize(int fileID, long buffersize);

int fileOpen(const char *filename, const char *mode);
int fileOpen_serial(const char *filename, const char *mode);
int fileClose(int fileID);
int fileClose_serial(int fileID);

char *fileInqName(int fileID);
int fileInqMode(int fileID);

int fileFlush(int fileID);
void fileClearerr(int fileID);
int fileEOF(int fileID);
int filePtrEOF(void *fileptr);
void fileRewind(int fileID);

off_t fileGetPos(int fileID);
int fileSetPos(int fileID, off_t offset, int whence);

int fileGetc(int fileID);
int filePtrGetc(void *fileptr);

size_t filePtrRead(void *fileptr, void *restrict ptr, size_t size);
size_t fileRead(int fileID, void *restrict ptr, size_t size);
size_t fileWrite(int fileID, const void *restrict ptr, size_t size);

#endif /* _FILE_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef SWAP_H_
#define SWAP_H_

void swap4byte(void *ptr, size_t size);
void swap8byte(void *ptr, size_t size);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef BINARY_H
#define BINARY_H

#ifdef HAVE_CONFIG_H
#endif

#include <stdio.h>
#include <inttypes.h>

#ifndef HOST_ENDIANNESS
#define HOST_ENDIANNESS (((const unsigned char *) &(const uint32_t[1]){ UINT32_C(0x00030201) })[0])
#endif

uint32_t get_uint32(unsigned char *x);
uint64_t get_uint64(unsigned char *x);
uint32_t get_swap_uint32(unsigned char *x);
uint64_t get_swap_uint64(unsigned char *x);

size_t binReadF77Block(int fileID, int byteswap);
void binWriteF77Block(int fileID, int byteswap, size_t blocksize);

int binReadInt32(int fileID, int byteswap, size_t size, int32_t *ptr);
int binReadInt64(int fileID, int byteswap, size_t size, int64_t *ptr);

int binWriteInt32(int fileID, int byteswap, size_t size, int32_t *ptr);
int binWriteInt64(int fileID, int byteswap, size_t size, int64_t *ptr);

int binWriteFlt32(int fileID, int byteswap, size_t size, float *ptr);
int binWriteFlt64(int fileID, int byteswap, size_t size, double *ptr);

#ifdef HAVE__FLOAT16
int binWriteFlt16(int fileID, size_t size, _Float16 *ptr);
#endif

#endif /* BINARY_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#define CDI_BIGENDIAN 0     // Byte order BIGENDIAN
#define CDI_LITTLEENDIAN 1  // Byte order LITTLEENDIAN

uint32_t
get_uint32(unsigned char *x)
{
  // clang-format off
  switch (HOST_ENDIANNESS)
    {
    case CDI_BIGENDIAN:
      return (((uint32_t)x[0])<<24) + (((uint32_t)x[1])<<16) + (((uint32_t)x[2])<< 8) + (uint32_t)x[3];
    case CDI_LITTLEENDIAN:
      return (((uint32_t)x[3])<<24) + (((uint32_t)x[2])<<16) + (((uint32_t)x[1])<< 8) + (uint32_t)x[0];
    default:
      Error("Unhandled endianness %d", HOST_ENDIANNESS);
      return UINT32_C(0xFFFFFFFF);
    }
  // clang-format on
}

uint32_t
get_swap_uint32(unsigned char *x)
{
  // clang-format off
  switch (HOST_ENDIANNESS)
    {
    case CDI_BIGENDIAN:
      return (((uint32_t)x[3])<<24) + (((uint32_t)x[2])<<16) + (((uint32_t)x[1])<< 8) + (uint32_t)x[0];
    case CDI_LITTLEENDIAN:
      return (((uint32_t)x[0])<<24) + (((uint32_t)x[1])<<16) + (((uint32_t)x[2])<< 8) + (uint32_t)x[3];
    default:
      Error("Unhandled endianness %d", HOST_ENDIANNESS);
      return UINT32_C(0xFFFFFFFF);
    }
  // clang-format on
}

uint64_t
get_uint64(unsigned char *x)
{
  // clang-format off
  switch (HOST_ENDIANNESS)
    {
    case CDI_BIGENDIAN:
      return (((uint64_t)x[0])<<56) + (((uint64_t)x[1])<<48) + (((uint64_t)x[2])<<40) + (((uint64_t)x[3])<<32) +
             (((uint64_t)x[4])<<24) + (((uint64_t)x[5])<<16) + (((uint64_t)x[6])<< 8) +   (uint64_t)x[7];
    case CDI_LITTLEENDIAN:
      return (((uint64_t)x[7])<<56) + (((uint64_t)x[6])<<48) + (((uint64_t)x[5])<<40) + (((uint64_t)x[4])<<32) +
             (((uint64_t)x[3])<<24) + (((uint64_t)x[2])<<16) + (((uint64_t)x[1])<< 8) +   (uint64_t)x[0];
    default:
      Error("Unhandled endianness %d", HOST_ENDIANNESS);
      return UINT64_C(0xFFFFFFFFFFFFFFFF);
    }
  // clang-format on
}

uint64_t
get_swap_uint64(unsigned char *x)
{
  // clang-format off
  switch (HOST_ENDIANNESS)
    {
    case CDI_BIGENDIAN:
      return (((uint64_t)x[7])<<56) + (((uint64_t)x[6])<<48) + (((uint64_t)x[5])<<40) + (((uint64_t)x[4])<<32) +
             (((uint64_t)x[3])<<24) + (((uint64_t)x[2])<<16) + (((uint64_t)x[1])<< 8) +   (uint64_t)x[0];
    case CDI_LITTLEENDIAN:
      return (((uint64_t)x[0])<<56) + (((uint64_t)x[1])<<48) + (((uint64_t)x[2])<<40) + (((uint64_t)x[3])<<32) +
             (((uint64_t)x[4])<<24) + (((uint64_t)x[5])<<16) + (((uint64_t)x[6])<< 8) +   (uint64_t)x[7];
    default:
      Error("Unhandled endianness %d", HOST_ENDIANNESS);
      return UINT64_C(0xFFFFFFFFFFFFFFFF);
    }
  // clang-format on
}

size_t
binReadF77Block(int fileID, int byteswap)
{
  unsigned char f77block[4];
  size_t blocklen = 0;

  if (fileRead(fileID, f77block, 4) == 4) { blocklen = byteswap ? get_swap_uint32(f77block) : get_uint32(f77block); }

  return blocklen;
}

void
binWriteF77Block(int fileID, int byteswap, size_t blocksize)
{
  static const unsigned int s[4] = { 0, 8, 16, 24 };
  const unsigned long ublocksize = (unsigned long) blocksize;
  unsigned char f77block[4];

  switch (HOST_ENDIANNESS)
  {
    case CDI_BIGENDIAN:
      if (byteswap)
      {
        for (int i = 0; i <= 3; ++i) f77block[i] = (unsigned char) (ublocksize >> s[i]);
      }
      else
      {
        for (int i = 0; i <= 3; ++i) f77block[3 - i] = (unsigned char) (ublocksize >> s[i]);
      }
      break;
    case CDI_LITTLEENDIAN:
      if (byteswap)
      {
        for (int i = 0; i <= 3; ++i) f77block[3 - i] = (unsigned char) (ublocksize >> s[i]);
      }
      else
      {
        for (int i = 0; i <= 3; ++i) f77block[i] = (unsigned char) (ublocksize >> s[i]);
      }
      break;
    default: Error("Unhandled endianness %d", HOST_ENDIANNESS);
  }

  if (fileWrite(fileID, f77block, 4) != 4) Error("Write failed on %s", fileInqName(fileID));
}

int
binReadInt32(int fileID, int byteswap, size_t size, int32_t *ptr)
{
  fileRead(fileID, (void *) ptr, 4 * size);
  if (byteswap) swap4byte(ptr, size);
  return 0;
}

int
binReadInt64(int fileID, int byteswap, size_t size, int64_t *ptr)
{
  fileRead(fileID, (void *) ptr, 8 * size);
  if (byteswap) swap8byte(ptr, size);
  return 0;
}

int
binWriteInt32(int fileID, int byteswap, size_t size, int32_t *ptr)
{
  if (byteswap) swap4byte(ptr, size);
  fileWrite(fileID, (void *) ptr, 4 * size);
  return 0;
}

int
binWriteInt64(int fileID, int byteswap, size_t size, int64_t *ptr)
{
  if (byteswap) swap8byte(ptr, size);
  fileWrite(fileID, (void *) ptr, 8 * size);
  return 0;
}

int
binWriteFlt32(int fileID, int byteswap, size_t size, float *ptr)
{
  if (byteswap) swap4byte(ptr, size);
  fileWrite(fileID, (void *) ptr, 4 * size);
  return 0;
}

int
binWriteFlt64(int fileID, int byteswap, size_t size, double *ptr)
{
  if (byteswap) swap8byte(ptr, size);
  fileWrite(fileID, (void *) ptr, 8 * size);
  return 0;
}

#ifdef HAVE__FLOAT16
int
binWriteFlt16(int fileID, size_t size, _Float16 *ptr)
{
  fileWrite(fileID, (void *) ptr, 2 * size);
  return 0;
}
#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CALENDAR_H
#define CALENDAR_H

#include <stdint.h>  // int64_t

// clang-format off

#ifdef __cplusplus
extern "C" {
#endif

void decode_calday(int daysPerYear, int64_t days, int *year, int *month, int *day);
int64_t encode_calday(int daysPerYear, int year, int month, int day);

static inline int
calendar_dpy(int calendar)
{
  int daysPerYear = 0;

  if      (calendar == CALENDAR_360DAYS) daysPerYear = 360;
  else if (calendar == CALENDAR_365DAYS) daysPerYear = 365;
  else if (calendar == CALENDAR_366DAYS) daysPerYear = 366;

  return daysPerYear;
}

int days_per_year(int calendar, int year);
int days_per_month(int calendar, int year, int month);

#ifdef __cplusplus
}
#endif

// clang-format on

#endif
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stdio.h>


static const int month_360[12] = { 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30 };
static const int month_365[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
static const int month_366[12] = { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

static const int *
get_dayspermonth_array(int daysPerYear)
{
  // clang-format off
  return  (daysPerYear == 360) ? month_360 :
          (daysPerYear == 365) ? month_365 :
          (daysPerYear == 366) ? month_366 : NULL;
  // clang-format on
}

int
days_per_month(int calendar, int year, int month)
{
  int daysPerYear = calendar_dpy(calendar);
  const int *daysPerMonthArray = (daysPerYear == 360) ? month_360 : ((daysPerYear == 365) ? month_365 : month_366);

  int daysPerMonth = (month >= 1 && month <= 12) ? daysPerMonthArray[month - 1] : 0;

  if (daysPerYear == 0 && month == 2) daysPerMonth = ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) ? 29 : 28;

  return daysPerMonth;
}

int
days_per_year(int calendar, int year)
{
  int daysPerYear = calendar_dpy(calendar);
  if (daysPerYear == 0)
  {
    if (year == 1582 && (calendar == CALENDAR_STANDARD || calendar == CALENDAR_GREGORIAN))
      daysPerYear = 355;
    else if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0)
      daysPerYear = 366;
    else
      daysPerYear = 365;
  }

  return daysPerYear;
}

void
decode_calday(int daysPerYear, int64_t days, int *year, int *month, int *day)
{
  *year = (int) ((days - 1) / daysPerYear);
  days -= (*year * daysPerYear);

  const int *daysPerMonthArray = get_dayspermonth_array(daysPerYear);

  int i = 0;
  if (daysPerMonthArray)
    for (i = 0; i < 12; i++)
    {
      if (days > daysPerMonthArray[i])
        days -= daysPerMonthArray[i];
      else
        break;
    }

  *month = i + 1;
  *day = (int) days;
}

int64_t
encode_calday(int daysPerYear, int year, int month, int day)
{
  int64_t rval = (int64_t) daysPerYear * year + day;

  const int *daysPerMonthArray = get_dayspermonth_array(daysPerYear);

  if (daysPerMonthArray)
    for (int i = 0; i < month - 1; i++) rval += daysPerMonthArray[i];

  return rval;
}
#ifndef CDF_H
#define CDF_H

void cdfDebug(int debug);

extern int CDF_Debug;

const char *cdfLibraryVersion(void);

int cdfOpen(const char *filename, const char *mode, int filetype);
int cdf4Open(const char *filename, const char *mode, int *filetype);
void cdfClose(int fileID);

#endif /* CDF_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDI_FDB_H
#define CDI_FDB_H

#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBFDB5

#include <fdb5/api/fdb_c.h>

typedef struct
{
  char *item;
  char *keys[32];
  char *values[32];
  int numKeys;
} KeyValueItem;

typedef struct
{
  char *keys[32];
  char *values[32];
  int numKeys;
} fdbKeyValueEntry;

typedef struct
{
  int fdbIndex;
  int date;
  int time;
  int param;
  int levtype;
  int ilevel;
} RecordInfoEntry;

void check_fdb_error(int errorNum);
void cdi_fdb_delete_kvlist(int numItems, fdbKeyValueEntry *keyValueList);
void decode_fdbitem(const char *fdbItem, KeyValueItem *keyValue);
int cdi_fdb_fill_kvlist(fdb_handle_t *fdb, fdb_request_t *request, fdbKeyValueEntry **keyValueList);
long cdi_fdb_read_record(fdb_handle_t *fdb, const fdbKeyValueEntry *keyValue, size_t *buffersize, void **gribbuffer);
// int check_keyvalueList(int numItems, fdbKeyValueEntry *keyValueList);
void print_keyvalueList(int numItems, fdbKeyValueEntry *keyValueList);
void print_keyvalueList_sorted(int numItems, fdbKeyValueEntry *keyValueList, RecordInfoEntry *recordInfoList);
void cdi_fdb_sort_datetime(int numItems, RecordInfoEntry *recordInfo);
int get_num_records(int numItems, RecordInfoEntry *recordInfoList);
int decode_keyvalue(int numItems, fdbKeyValueEntry *keyValueList, RecordInfoEntry *recordInfoList);
int remove_duplicate_timesteps(RecordInfoEntry *recordInfoList, int numRecords, int numTimesteps, int *timestepRecordOffset);
fdb_request_t *cdi_create_fdb_request(const char *filename);

#endif

#endif /* CDI_FDB_H */
#ifndef CDF_CONFIG_H_
#define CDF_CONFIG_H_

#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBNETCDF

#include <netcdf.h>

#ifdef NC_FORMAT_64BIT_DATA
#define HAVE_NETCDF5 1
#endif

#if defined HAVE_NETCDF4 && HAVE_DECL_NC_INQ_VAR_FILTER_IDS && HAVE_DECL_NCAUX_H5FILTERSPEC_PARSELIST
#define HAVE_NC4FILTER 1
#endif

#endif

#endif
#ifndef JULIAN_DATE_H
#define JULIAN_DATE_H


// clang-format off

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  int64_t julianDay;
  double secondOfDay;
} JulianDate;

JulianDate julianDate_encode(int calendar, CdiDateTime dt);
CdiDateTime julianDate_decode(int calendar, JulianDate julianDate);
JulianDate julianDate_add_seconds(JulianDate julianDate, int64_t seconds);
JulianDate julianDate_add(JulianDate julianDate1, JulianDate julianDate2);
JulianDate julianDate_sub(JulianDate julianDate1, JulianDate julianDate2);
double julianDate_to_seconds(JulianDate julianDate);

double secofday_encode(CdiTime time);
CdiTime secofday_decode(double secondOfDay);

#ifdef __cplusplus
}
#endif

// clang-format on

#endif /* JULIAN_DATE_H */
#ifndef CDI_LIMITS_H
#define CDI_LIMITS_H

#define MAX_DIMENSIONS 5     // maximum number of dimensions per variable
#define MAX_DIMS_PS 16       // maximum number of dimensions per stream
#define MAX_GRIDS_PS 128     // maximum number of different grids per stream
#define MAX_ZAXES_PS 128     // maximum number of different zaxes per stream
#define MAX_ATTRIBUTES 256   // maximum number of attributes per variable
#define MAX_KEYS 64          // maximum number of keys per variable
#define MAX_SUBTYPES_PS 128  // maximum number of different subtypes per stream

#endif /* CDI_LIMITS_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDI_KEY_H
#define CDI_KEY_H

#include <stdio.h>
#include <stdint.h>

// CDI key
typedef struct
{
  uint16_t key;   // CDI key
  uint16_t type;  // KEY_INT, KEY_FLOAT, KEY_BYTES
  int length;     // number of bytes in v.s
  union
  {
    int i;
    double d;
    unsigned char *s;
  } v;
} cdi_key_t;

typedef struct
{
  uint16_t nalloc;  // number allocated >= nelems
  uint16_t nelems;  // length of the array
  cdi_key_t value[MAX_KEYS];
} cdi_keys_t;

enum
{
  KeyInt = 1,
  KeyFloat,
  KeyBytes
};

void cdiDefVarKeyInt(cdi_keys_t *keysp, int key, int value);
void cdiDefVarKeyFloat(cdi_keys_t *keysp, int key, double value);
void cdiDefVarKeyBytes(cdi_keys_t *keysp, int key, const unsigned char *bytes, int length);
int cdiInqVarKeyInt(const cdi_keys_t *keysp, int key);
int cdiInqVarKeyBytes(const cdi_keys_t *keysp, int key, unsigned char *bytes, int *length);

cdi_key_t *find_key(cdi_keys_t *keysp, int key);
const char *cdiInqVarKeyStringPtr(const cdi_keys_t *keysp, int key);

static inline const char *
cdiInqVarKeyString(const cdi_keys_t *keysp, int key)
{
  const char *string = cdiInqVarKeyStringPtr(keysp, key);
  if (string == NULL) string = "";
  return string;
}

int cdiCopyVarKey(const cdi_keys_t *keysp1, int key, cdi_keys_t *keysp2);
void cdiCopyVarKeys(const cdi_keys_t *keysp1, cdi_keys_t *keysp2);
void cdiDeleteVarKeys(cdi_keys_t *keysp);
void cdiDeleteKeys(int cdiID, int varID);
void cdiPrintKeys(int cdiID, int varID);

void cdiInitKeys(cdi_keys_t *keysp);

int cdi_key_compare(cdi_keys_t *keyspa, cdi_keys_t *keyspb, int keynum);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef RESOURCE_HANDLE_H
#define RESOURCE_HANDLE_H

#ifdef HAVE_CONFIG_H
#endif

#include <stdio.h>

/*
 * CDI internal handling of resource handles given to user code
 */

/*
 * for reasons of compatibility with cfortran.h, the handle type is: int
 */
typedef int cdiResH;

/* return 0 on equality, not 0 otherwise */
typedef int (*valCompareFunc)(void *, void *);
typedef void (*valDestroyFunc)(void *);
typedef void (*valPrintFunc)(void *, FILE *);
typedef int (*valGetPackSizeFunc)(void *, void *context);
typedef void (*valPackFunc)(void *, void *buf, int size, int *pos, void *context);
typedef int (*valTxCodeFunc)(void *);

typedef struct
{
  valCompareFunc valCompare;
  valDestroyFunc valDestroy;
  valPrintFunc valPrint;
  valGetPackSizeFunc valGetPackSize;
  valPackFunc valPack;
  valTxCodeFunc valTxCode;
} resOps;

enum
{
  RESH_IN_USE_BIT = 1 << 0,
  RESH_SYNC_BIT = 1 << 1,
  /* resource holds no value */
  RESH_UNUSED = 0,
  /* resource was deleted and needs to be synced */
  RESH_DESYNC_DELETED = RESH_SYNC_BIT,
  /* resource is synchronized */
  RESH_IN_USE = RESH_IN_USE_BIT,
  /* resource is in use, desynchronized and needs to be synced */
  RESH_DESYNC_IN_USE = RESH_IN_USE_BIT | RESH_SYNC_BIT,
};

void reshListCreate(int namespaceID);
void reshListDestruct(int namespaceID);
int reshPut(void *, const resOps *);
void reshReplace(cdiResH resH, void *p, const resOps *ops);
void reshRemove(cdiResH, const resOps *);
/*> doesn't check resource type */
void reshDestroy(cdiResH);

unsigned reshCountType(const resOps *resTypeOps);

void *reshGetValue(const char *caller, const char *expressionString, cdiResH id, const resOps *ops);
#define reshGetVal(resH, ops) reshGetValue(__func__, #resH, resH, ops)

void reshGetResHListOfType(unsigned numIDs, int IDs[], const resOps *ops);

enum cdiApplyRet
{
  CDI_APPLY_ERROR = -1,
  CDI_APPLY_STOP,
  CDI_APPLY_GO_ON,
};
enum cdiApplyRet cdiResHApply(enum cdiApplyRet (*func)(int id, void *res, const resOps *p, void *data), void *data);
enum cdiApplyRet cdiResHFilterApply(const resOps *p, enum cdiApplyRet (*func)(int id, void *res, void *data), void *data);

int reshPackBufferCreate(char **packBuf, int *packBufSize, void *context);
void reshPackBufferDestroy(char **);
int reshResourceGetPackSize_intern(int resh, const resOps *ops, void *context, const char *caller, const char *expressionString);
#define reshResourceGetPackSize(resh, ops, context) reshResourceGetPackSize_intern(resh, ops, context, __func__, #resh)
void reshPackResource_intern(int resh, const resOps *ops, void *buf, int buf_size, int *position, void *context, const char *caller,
                             const char *expressionString);
#define reshPackResource(resh, ops, buf, buf_size, position, context) \
  reshPackResource_intern(resh, ops, buf, buf_size, position, context, __func__, #resh)

void reshSetStatus(cdiResH, const resOps *, int);
int reshGetStatus(cdiResH, const resOps *);

void reshLock(void);
void reshUnlock(void);

enum reshListMismatch
{
  cdiResHListOccupationMismatch,
  cdiResHListResourceTypeMismatch,
  cdiResHListResourceContentMismatch,
};

int reshListCompare(int nsp0, int nsp1);
void reshListPrint(FILE *fp);
int reshGetTxCode(cdiResH resH);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef TAXIS_H
#define TAXIS_H

#include <stdbool.h>


#ifndef RESOURCE_HANDLE_H
#endif

typedef struct
{
  int self;
  int type;  // time type
  int calendar;
  int unit;  // time units
  int numavg;
  CdiDateTime sDateTime;     // start date/time
  CdiDateTime vDateTime;     // verification date/time
  CdiDateTime rDateTime;     // reference date/time
  CdiDateTime fDateTime;     // forecast reference date/time
  CdiDateTime vDateTime_lb;  // lower bounds of verification date/time
  CdiDateTime vDateTime_ub;  // upper bounds of verification date/time
  double fc_period;          // forecast time period
  int fc_unit;               // forecast time unit
  char *name;
  char *longname;
  char *units;
  bool climatology;
  bool hasBounds;
  cdi_keys_t keys;
} taxis_t;

//      taxisInqSdatetime: Get the start date/time
CdiDateTime taxisInqSdatetime(int taxisID);

void ptaxisInit(taxis_t *taxis);
void ptaxisCopy(taxis_t *dest, taxis_t *source);
taxis_t *taxis_to_pointer(int taxisID);
void cdi_set_forecast_period(double timevalue, taxis_t *taxis);
CdiDateTime cdi_decode_timeval(double timevalue, const taxis_t *taxis);
double cdi_encode_timeval(CdiDateTime datetime, taxis_t *taxis);

void ptaxisDefDatatype(taxis_t *taxisptr, int datatype);
void ptaxisDefName(taxis_t *taxisptr, const char *name);
void ptaxisDefLongname(taxis_t *taxisptr, const char *longname);
void ptaxisDefUnits(taxis_t *taxisptr, const char *units);
char *ptaxisAllocUnits(taxis_t *taxisptr, size_t len);
void taxisDestroyKernel(taxis_t *taxisptr);
#ifndef SX
extern const resOps taxisOps;
#endif

int taxisUnpack(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context,
                int checkForSameID);

enum
{
  TAXIS_MAX_UNIT_STR_LEN = 9
};

#endif /* TAXIS_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _SERVICE_H
#define _SERVICE_H

#include <stdlib.h>

typedef struct
{
  int checked;
  int byteswap;
  int header[8];
  int hprec; /* header precision */
  int dprec; /* data   precision */
  size_t datasize;
  size_t buffersize;
  void *buffer;
} srvrec_t;

const char *srvLibraryVersion(void);

void srvDebug(int debug);

int srvCheckFiletype(int fileID, int *swap);

void *srvNew(void);
void srvDelete(void *srv);

int srvRead(int fileID, void *srv);
void srvWrite(int fileID, void *srv);

int srvInqHeader(void *srv, int *header);
int srvInqDataFP32(void *srv, float *data);
int srvInqDataFP64(void *srv, double *data);

int srvDefHeader(void *srv, const int *header);
int srvDefDataFP32(void *srv, const float *data);
int srvDefDataFP64(void *srv, const double *data);

#endif /* _SERVICE_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _EXTRA_H
#define _EXTRA_H

#ifdef HAVE_CONFIG_H
#endif

#include <stdlib.h>

enum
{
  EXT_REAL = 1,
  EXT_COMP = 2,
};

typedef struct
{
  int checked;
  int byteswap;
  int header[4];
  int prec;    // single or double precison
  int number;  // real or complex
  size_t datasize;
  size_t buffersize;
  void *buffer;
} extrec_t;

const char *extLibraryVersion(void);

void extDebug(int debug);

int extCheckFiletype(int fileID, int *swap);

void *extNew(void);
void extDelete(void *ext);

int extRead(int fileID, void *ext);
int extWrite(int fileID, void *ext);

int extInqHeader(void *ext, int *header);
int extInqDataFP32(void *ext, float *data);
int extInqDataFP64(void *ext, double *data);

int extDefHeader(void *ext, const int *header);
int extDefDataFP32(void *ext, const float *data);
int extDefDataFP64(void *ext, const double *data);

#ifdef HAVE__FLOAT16
int extInqDataFP16(void *ext, _Float16 *data);
int extDefDataFP16(void *ext, const _Float16 *data);
#endif

#endif /* _EXTRA_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _IEG_H
#define _IEG_H

#include <stdlib.h>

// clang-format off

/* Level Types */
#define  IEG_LTYPE_SURFACE               1
#define  IEG_LTYPE_99                   99
#define  IEG_LTYPE_ISOBARIC            100
#define  IEG_LTYPE_MEANSEA             102
#define  IEG_LTYPE_ALTITUDE            103
#define  IEG_LTYPE_HEIGHT              105
#define  IEG_LTYPE_SIGMA               107
#define  IEG_LTYPE_HYBRID              109
#define  IEG_LTYPE_HYBRID_LAYER        110
#define  IEG_LTYPE_LANDDEPTH           111
#define  IEG_LTYPE_LANDDEPTH_LAYER     112
#define  IEG_LTYPE_SEADEPTH            160

/*
 *  Data representation type (Grid Type) [Table 6]
 */
#define  IEG_GTYPE_LATLON             0  /*  latitude/longitude                       */
#define  IEG_GTYPE_LATLON_ROT        10  /*  rotated latitude/longitude               */

#define  IEG_P_CodeTable(x)   (x[ 5])  /*  Version number of code table                 */
#define  IEG_P_Parameter(x)   (x[ 6])  /*  Parameter indicator                          */
#define  IEG_P_LevelType(x)   (x[ 7])  /*  Type of level indicator                      */
#define  IEG_P_Level1(x)      (x[ 8])  /*  Level 1                                      */
#define  IEG_P_Level2(x)      (x[ 9])  /*  Level 2                                      */
#define  IEG_P_Year(x)        (x[10])  /*  Year of century (YY)                         */
#define  IEG_P_Month(x)       (x[11])  /*  Month (MM)                                   */
#define  IEG_P_Day(x)         (x[12])  /*  Day (DD)                                     */
#define  IEG_P_Hour(x)        (x[13])  /*  Hour (HH)                                    */
#define  IEG_P_Minute(x)      (x[14])  /*  Minute (MM)                                  */

/*
 *  Macros for the grid definition section ( Section 2 )
 */
#define  IEG_G_Size(x)        (x[ 0])
#define  IEG_G_NumVCP(x)      (x[3] == 10 ? (x[0]-42)/4 : (x[0]-32)/4)
#define  IEG_G_GridType(x)    (x[ 3])  /*  Data representation type */
#define  IEG_G_NumLon(x)      (x[ 4])  /*  Number of points along a parallel (Ni)       */
#define  IEG_G_NumLat(x)      (x[ 5])  /*  Number of points along a meridian (Nj)       */
#define  IEG_G_FirstLat(x)    (x[ 6])  /*  Latitude of the first grid point             */
#define  IEG_G_FirstLon(x)    (x[ 7])  /*  Longitude of the first grid point            */
#define  IEG_G_ResFlag(x)     (x[ 8])  /*  Resolution flag: 128 regular grid            */
#define  IEG_G_LastLat(x)     (x[ 9])  /*  Latitude of the last grid point              */
#define  IEG_G_LastLon(x)     (x[10])  /*  Longitude of the last grid point             */
#define  IEG_G_LonIncr(x)     (x[11])  /*  i direction increment                        */
#define  IEG_G_LatIncr(x)     (x[12])  /*  j direction increment                        */
#define  IEG_G_ScanFlag(x)    (x[13])
#define  IEG_G_LatSP(x)       (x[16])  /*  Latitude of the southern pole of rotation    */
#define  IEG_G_LonSP(x)       (x[17])  /*  Longitude of the southern pole of rotation   */
#define  IEG_G_ResFac(x)      (x[18])  /*  Resolution factor                            */

// clang-format on

typedef struct
{
  int checked;
  int byteswap;
  int dprec; /* data   precision */
  int ipdb[37];
  double refval;
  int igdb[22];
  double vct[100];
  size_t datasize;
  size_t buffersize;
  void *buffer;
} iegrec_t;

const char *iegLibraryVersion(void);

void iegDebug(int debug);
int iegCheckFiletype(int fileID, int *swap);

void *iegNew(void);
void iegDelete(void *ieg);
void iegInitMem(void *ieg);

int iegRead(int fileID, void *ieg);
int iegWrite(int fileID, void *ieg);

void iegCopyMeta(void *dieg, void *sieg);
int iegInqHeader(void *ieg, int *header);
int iegInqDataFP32(void *ieg, float *data);
int iegInqDataFP64(void *ieg, double *data);

int iegDefHeader(void *ieg, const int *header);
int iegDefDataFP32(void *ieg, const float *data);
int iegDefDataFP64(void *ieg, const double *data);

#endif /* _IEG_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDI_INT_H
#define CDI_INT_H

// strdup() from string.h
#ifdef __STDC_ALLOC_LIB__
#define __STDC_WANT_LIB_EXT2__ 1
#else
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 200809L
#endif

#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBFDB5
#endif

#include <assert.h>
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <math.h>
#include <sys/types.h>


#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
extern pthread_mutex_t CDI_IO_Mutex;
#define CDI_IO_LOCK() pthread_mutex_lock(&CDI_IO_Mutex)
#define CDI_IO_UNLOCK() pthread_mutex_unlock(&CDI_IO_Mutex)
#else
#define CDI_IO_LOCK()
#define CDI_IO_UNLOCK()
#endif

// Base file types

#define CDI_FILETYPE_GRIB 100    // File type GRIB
#define CDI_FILETYPE_NETCDF 101  // File type NetCDF

// dummy use of unused parameters to silence compiler warnings
#ifndef UNUSED
#define UNUSED(x) (void) x
#endif

char *str_to_lower(char *str);
bool strStartsWith(const char *vstr, const char *cstr);

static inline bool
str_is_equal(const char *x, const char *y)
{
  return (*x == *y) && (strcmp(x, y) == 0);
}

#ifndef M_PI
#define M_PI 3.14159265358979323846 /* pi */
#endif

#ifndef ERROR_H
#endif
#ifndef _BASETIME_H
#endif
#ifndef JULIAN_DATE_H
#endif
#ifndef TAXIS_H
#endif
#ifndef CDI_LIMITS_H
#endif
#ifndef _SERVICE_H
#endif
#ifndef _EXTRA_H
#endif
#ifndef _IEG_H
#endif
#ifndef RESOURCE_HANDLE_H
#endif

#define check_parg(arg) \
  if (arg == 0) Warning("Argument '" #arg "' not allocated!")

#ifdef __xlC__ /* performance problems on IBM */
#ifndef DBL_IS_NAN
#define DBL_IS_NAN(x) ((x) != (x))
#endif
#else
#ifndef DBL_IS_NAN
#if defined(HAVE_DECL_ISNAN)
#define DBL_IS_NAN(x) (isnan(x))
#elif defined(FP_NAN)
#define DBL_IS_NAN(x) (fpclassify(x) == FP_NAN)
#else
#define DBL_IS_NAN(x) ((x) != (x))
#endif
#endif
#endif

#ifndef DBL_IS_EQUAL
// #define DBL_IS_EQUAL(x,y) (!(x < y || y < x))
#define DBL_IS_EQUAL(x, y) (DBL_IS_NAN(x) || DBL_IS_NAN(y) ? (DBL_IS_NAN(x) && DBL_IS_NAN(y)) : !(x < y || y < x))
#endif

#ifndef IS_EQUAL
#define IS_NOT_EQUAL(x, y) (x < y || y < x)
#define IS_EQUAL(x, y) (!IS_NOT_EQUAL(x, y))
#endif

enum
{
  TYPE_REC,
  TYPE_VAR,
};

enum
{
  MEMTYPE_DOUBLE = 1,
  MEMTYPE_FLOAT,
};

typedef struct
{
  void *buffer;       // gribapi, cgribex
  size_t buffersize;  // gribapi, cgribex
  off_t position;     // file position
  int param;
  int ilevel;
  int vdate;
  int vtime;
  int gridID;
  int varID;
  int levelID;
  int prec;       // ext, srv
  void *objectp;  // pointer to ieg, ext, srv or cgribex objects
} Record;

// data structure specifying tile-related meta-data. structure contains "-1" if this is no tile-variable.
typedef struct
{
  int tileindex, totalno_of_tileattr_pairs, tileClassification, numberOfTiles, numberOfAttributes, attribute;
} var_tile_t;

typedef struct
{
  short perturbationNumber;
  short typeOfGeneratingProcess;
} VarScanKeys;

static inline void
varScanKeysInit(VarScanKeys *s)
{
  memset(s, 0, sizeof(VarScanKeys));
}

static inline bool
varScanKeysIsEqual(const VarScanKeys *s1, const VarScanKeys *s2)
{
  return memcmp(s1, s2, sizeof(VarScanKeys)) == 0;
}

typedef struct
{
  int levelID;
  short varID;
  short used;
} recinfo_t;

typedef struct
{
  off_t position;
  size_t size;
  size_t gridsize;
  int param;
  int ilevel;
  int ilevel2;
  short ltype;
  short tsteptype;
#ifdef HAVE_LIBGRIB
  int zip;
  VarScanKeys scanKeys;
  var_tile_t tiles;  // tile-related meta-data, currently for GRIB-API only.
#ifdef HAVE_LIBGRIB_API
  char varname[32];
#endif
#endif
#ifdef HAVE_LIBFDB5
  int fdbItemIndex;
#endif
} record_t;

typedef struct
{
  int *recIDs;  // IDs of non constant records
  recinfo_t *recinfo;
  record_t *records;
  int recordSize;   // number of allocated records
  int nrecs;        // number of used records
                    // tsID=0 nallrecs
                    // tsID>0 number of non constant records
  int nallrecs;     // number of all records
  int curRecID;     // current record ID
  int ncStepIndex;  // NetCDF timestep index
  off_t position;   // timestep file position
  taxis_t taxis;
  bool next;
} tsteps_t;

typedef struct
{
  int nlevs;
  int subtypeIndex;  // corresponding tile in subtype_t structure (subtype->self)
  int *recordID;     // record IDs: [nlevs]
  int *lindex;       // level index
} sleveltable_t;

typedef struct
{
  sleveltable_t *recordTable;  // record IDs for each subtype
  int ncvarid;
  int subtypeSize;
  bool defmiss;  // true: if missval is defined in file
  bool isUsed;

  int gridID;
  int zaxisID;
  int tsteptype;  // TSTEP_*
  int subtypeID;  // subtype ID, e.g. for tile-related meta-data (currently for GRIB-API only).
} svarinfo_t;

typedef struct
{
  int ilev;
  int mlev;
  int ilevID;
  int mlevID;
} VCT;

#ifdef HAVE_LIBNETCDF
enum cdfIDIdx
{
  CDF_DIMID_E,  // 3rd dimID of cube sphere grid (len=6)
  CDF_DIMID_X,
  CDF_DIMID_Y,
  CDF_DIMID_RP,  // reducedPoints
  CDF_VARID_X,
  CDF_VARID_Y,
  CDF_VARID_RP,  // reducedPoints
  CDF_VARID_A,
  CDF_VARID_I,  // cellIndices
  CDF_SIZE_NCID,
};

typedef struct
{
  int ncIdVec[CDF_SIZE_NCID];
  int gridID;
  long start;
  long count;
} CdfGrid;

typedef struct
{
  int complexFloatId;
  int complexDoubleId;
  CdfGrid cdfGridVec[MAX_GRIDS_PS];
  int zaxisIdVec[MAX_ZAXES_PS];  // Warning: synchronous array to vlist_to_pointer(vlistID)->zaxisIDs
  int ncZvarIdVec[MAX_ZAXES_PS];
  int ncDimIdVec[MAX_DIMS_PS];
  size_t ncDimLenVec[MAX_DIMS_PS];
  int ncNumDims;
  size_t chunkSizeDimT;
  size_t chunkSizeDimZ;
  VCT vct;
} CdfInfo;
#endif

typedef struct
{
  int self;
  int accesstype;  // TYPE_REC or TYPE_VAR
  int accessmode;
  int filetype;
  int byteorder;
  int fileID;
  int filemode;
  int nrecs;  // number of records
  SizeType numvals;
  char *filename;
  Record *record;
  CdiQuery *query;
  svarinfo_t *vars;
  int nvars;  // number of variables
  int varsAllocated;
  int curTsID;   // current timestep ID
  int rtsteps;   // number of tsteps accessed
  long ntsteps;  // number of tsteps : only set if all records accessed
  int maxSteps;  // max. number of timesteps (needed for CDI_FILETYPE_NCZARR)
  tsteps_t *tsteps;
  int tstepsTableSize;
  int tstepsNextID;
  basetime_t basetime;
  int ncmode;
  int vlistID;
#ifdef HAVE_LIBNETCDF
  CdfInfo cdfInfo;
#endif
  long maxGlobalRecs;
  int globalatts;
  int localatts;
  int unreduced;
  int have_missval;
  int shuffle;
  // netcdf4/HDF5 filter
  char *filterSpec;

  int comptype;   // compression type
  int complevel;  // compression level
  bool sortname;
  bool lockIO;

  void *gribContainers;

  int numWorker;
  int nextGlobalRecId;
  int cachedTsID;
  void *jobs;
  void *jobManager;

  int protocol;
  void *protocolData;

#ifdef HAVE_LIBFDB5
  int fdbNumItems;
  fdbKeyValueEntry *fdbKeyValueList;
#endif
} stream_t;

// Length of optional keyword/value pair list
#define MAX_OPT_GRIB_ENTRIES 500

enum cdi_convention
{
  CDI_CONVENTION_ECHAM,
  CDI_CONVENTION_CF
};

// Data type specification for optional key/value pairs (GRIB)
typedef enum
{
  t_double = 0,
  t_int = 1
} key_val_pair_datatype;

// Data structure holding optional key/value pairs for GRIB
typedef struct
{
  char *keyword;  // keyword string
  bool update;
  key_val_pair_datatype data_type;  // data type of this key/value pair
  double dbl_val;                   // double value (data_type == t_double)
  int int_val;                      // integer value (data_type == t_int)
  int subtype_index;                // tile index for this key-value pair
} opt_key_val_pair_t;

// enum for differenciating between the different times that we handle
typedef enum
{
  kCdiTimeType_referenceTime,
  kCdiTimeType_startTime,
  kCdiTimeType_endTime
} CdiTimeType;

#define CDI_FILETYPE_UNDEF -1  // Unknown/not yet defined file type

extern int cdiDebugExt;
extern int CDI_Debug;  // If set to 1, debuggig (default 0)
extern int CDI_Recopt;
extern bool CDI_gribapi_debug;
extern bool CDI_gribapi_grib1;
extern double CDI_Default_Missval;
extern double CDI_Grid_Missval;
extern int CDI_Default_InstID;
extern int CDI_Default_ModelID;
extern int CDI_Default_TableID;
extern int cdiDefaultLeveltype;
extern int CDI_Default_Calendar;
// extern int cdiNcMissingValue;
extern int CDI_Netcdf_Chunksizehint;
extern int CDI_ChunkType;
extern int CDI_Test;
extern int CDI_Split_Ltype105;
extern bool CDI_Lock_IO;
extern bool CDI_Threadsafe;
extern int cdiDataUnreduced;
extern int cdiSortName;
extern int cdiHaveMissval;
extern bool CDI_Ignore_Att_Coordinates;
extern bool CDI_Coordinates_Lon_Lat;
extern bool CDI_Ignore_Valid_Range;
extern int CDI_Skip_Records;
extern const char *CDI_GRIB1_Template;
extern const char *CDI_GRIB2_Template;
extern int CDI_Convention;
extern int CDI_Inventory_Mode;
extern int CDI_Query_Abort;
extern int CDI_Version_Info;
extern int CDI_Convert_Cubesphere;
extern int CDI_Read_Cell_Center;
extern int CDI_Read_Cell_Corners;
extern int CDI_CMOR_Mode;
extern int CDI_Reduce_Dim;
extern int CDI_Shuffle;
extern size_t CDI_Netcdf_Hdr_Pad;
extern bool CDI_CopyChunkSpec;
extern bool CDI_RemoveChunkSpec;
extern bool CDI_Chunk_Cache_Info;
extern long CDI_Chunk_Cache_In;
extern long CDI_Chunk_Cache_Out;
extern size_t CDI_Chunk_Cache_Max;
extern bool CDI_Netcdf_Lazy_Grid_Load;
extern int STREAM_Debug;

extern char *cdiPartabPath;
extern int cdiPartabIntern;
extern const resOps streamOps;

static inline stream_t *
stream_to_pointer(int idx)
{
  return (stream_t *) reshGetVal(idx, &streamOps);
}

static inline void
stream_check_ptr(const char *caller, stream_t *streamptr)
{
  if (streamptr == NULL) Errorc("stream undefined!");
}

int streamInqFileID(int streamID);

void gridDefHasDims(int gridID, int hasdims);
int gridInqHasDims(int gridID);
int zaxisInqLevelID(int zaxisID, double level);

void streamCheckID(const char *caller, int streamID);

void streamDefineTaxis(int streamID);

int streamsNewEntry(int filetype);
void streamsInitEntry(int streamID);
void cdiStreamSetupVlist(stream_t *streamptr, int vlistID);
// default implementation of the overridable function
void cdiStreamSetupVlist_(stream_t *streamptr, int vlistID);
int stream_new_var(stream_t *streamptr, int gridID, int zaxisID, int tilesetID);

int tstepsNewEntry(stream_t *streamptr);

const char *strfiletype(int filetype);

void cdi_generate_vars(stream_t *streamptr);

void vlist_check_contents(int vlistID);

void cdi_create_records(stream_t *streamptr, int tsID, bool allocRecords);

void streamFCopyRecord(stream_t *streamptr2, stream_t *streamptr1, const char *container_name);

int recordNewEntry(stream_t *streamptr, int tsID);

void cdi_create_timesteps(size_t numTimesteps, stream_t *streamptr);

void recinfoInitEntry(recinfo_t *recinfo);

void cdiCheckZaxis(int zaxisID);

void stream_def_accesstype(stream_t *s, int type);

int getByteswap(int byteorder);

void cdiStreamGetIndexList(unsigned numIDs, int IDs[]);

void cdiInitialize(void);

char *cdiEscapeSpaces(const char *string);
char *cdiUnescapeSpaces(const char *string, const char **outStringEnd);

enum
{
  CDI_UNIT_PA = 1,
  CDI_UNIT_HPA,
  CDI_UNIT_MM,
  CDI_UNIT_CM,
  CDI_UNIT_DM,
  CDI_UNIT_M,
};

struct streamAssoc
{
  int streamID, vlistID;
};

struct streamAssoc streamUnpack(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context);

int cdiStreamOpenDefaultDelegate(const char *filename, char filemode, int filetype, stream_t *streamptr,
                                 int recordBufIsToBeCreated);

int streamOpenID(const char *filename, char filemode, int filetype, int resH);

void cdiStreamDefVlist_(int streamID, int vlistID);

int cdiStreamWriteVar_(int streamID, int varID, int memtype, const void *data, SizeType numMissVals);

void cdiStreamWriteVarChunk_(int streamID, int varID, int memtype, const int rect[][2], const void *data, SizeType numMissVals);
void cdiStreamCloseDefaultDelegate(stream_t *streamptr, int recordBufIsToBeDeleted);

int cdiStreamDefTimestep_(stream_t *streamptr, int tsID);

void cdiStreamSync_(stream_t *streamptr);

const char *cdiUnitNamePtr(int cdi_unit);

enum
{
  // 8192 is known to work on most systems (4096 isn't on Alpha)
  commonPageSize = 8192,
};

size_t cdiGetPageSize(bool largePageAlign);

void zaxisGetIndexList(int nzaxis, int *zaxisIndexList);

// clang-format off

#ifdef __cplusplus
extern "C" {
#endif

// functions used in CDO !!!

void cdiDefTableID(int tableID);

void gridGenXvals(size_t xsize, double xfirst, double xlast, double xinc, double *xvals);
void gridGenYvals(int gridtype, size_t ysize, double yfirst, double ylast, double yinc, double *yvals);

static inline
void cdi_check_gridsize_int_limit(const char *format, SizeType gridsize)
{
  if (gridsize > INT_MAX) Error("%s format grid size (%zu) limit exceeded (%zu)!", format, gridsize, INT_MAX);
}

bool cdiFiletypeIsExse(int filetype);
int cdiBaseFiletype(int filetype);

#ifdef __cplusplus
}
#endif

// clang-format on

#endif /* CDI_INT_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDF_INT_H
#define CDF_INT_H

const char *cdf_strerror(int cdfErrorNo);

#ifdef HAVE_LIBNETCDF

#include <netcdf.h>
#include <stdint.h>  // int64_t

void cdf__create(const char *path, int cmode, int *idp);
void cdf_create(const char *path, int cmode, int *idp);
int cdf_open(const char *path, int omode, int *idp);
void cdf_close(int ncid);

void cdf_redef(int ncid);
void cdf_enddef(int ncid, int streamID);
void cdf__enddef(int ncid, int streamID, size_t hdr_pad);
void cdf_sync(int ncid);

void cdf_inq(int ncid, int *ndimsp, int *nvarsp, int *ngattsp, int *unlimdimidp);

void cdf_def_dim(int ncid, const char *name, size_t len, int *idp);
void cdf_inq_dimid(int ncid, const char *name, int *dimidp);
void cdf_inq_dim(int ncid, int dimid, char *name, size_t *lengthp);
void cdf_inq_dimname(int ncid, int dimid, char *name);
void cdf_inq_dimlen(int ncid, int dimid, size_t *lengthp);
void cdf_def_var(int ncid, const char *name, nc_type xtype, int ndims, const int dimids[], int *varidp);
void cdf_def_var_serial(int ncid, const char *name, nc_type xtype, int ndims, const int dimids[], int *varidp);
void cdf_inq_varid(int ncid, const char *name, int *varidp);
void cdf_inq_nvars(int ncid, int *nvarsp);
void cdf_inq_var(int ncid, int varid, char *name, nc_type *xtypep, int *ndimsp, int dimids[], int *nattsp);
void cdf_inq_varname(int ncid, int varid, char *name);
void cdf_inq_vartype(int ncid, int varid, nc_type *xtypep);
void cdf_inq_varndims(int ncid, int varid, int *ndimsp);
void cdf_inq_vardimid(int ncid, int varid, int dimids[]);
void cdf_inq_varnatts(int ncid, int varid, int *nattsp);

void cdf_copy_att(int ncid_in, int varid_in, const char *name, int ncid_out, int varid_out);
void cdf_put_var_text(int ncid, int varid, const char *tp);
void cdf_put_var_uchar(int ncid, int varid, const unsigned char *up);
void cdf_put_var_schar(int ncid, int varid, const signed char *cp);
void cdf_put_var_short(int ncid, int varid, const short *sp);
void cdf_put_var_int(int ncid, int varid, const int *ip);
void cdf_put_var_int64(int ncid, int varid, const int64_t *ip);
void cdf_put_var_long(int ncid, int varid, const long *lp);
void cdf_put_var_float(int ncid, int varid, const float *fp);
void cdf_put_var_double(int ncid, int varid, const double *dp);

void cdf_get_var_text(int ncid, int varid, char *tp);
void cdf_get_var_uchar(int ncid, int varid, unsigned char *up);
void cdf_get_var_schar(int ncid, int varid, signed char *cp);
void cdf_get_var_short(int ncid, int varid, short *sp);
void cdf_get_var_int(int ncid, int varid, int *ip);
void cdf_get_var_int64(int ncid, int varid, int64_t *ip);
void cdf_get_var_long(int ncid, int varid, long *lp);
void cdf_get_var_float(int ncid, int varid, float *fp);
void cdf_get_var_double(int ncid, int varid, double *dp);

void cdf_get_var1_text(int ncid, int varid, const size_t index[], char *tp);

void cdf_get_var1_double(int ncid, int varid, const size_t index[], double *dp);
void cdf_put_var1_double(int ncid, int varid, const size_t index[], const double *dp);

void cdf_get_vara_uchar(int ncid, int varid, const size_t start[], const size_t count[], unsigned char *tp);
void cdf_get_vara_text(int ncid, int varid, const size_t start[], const size_t count[], char *tp);

void cdf_get_vara_double(int ncid, int varid, const size_t start[], const size_t count[], double *dp);
void cdf_put_vara_double(int ncid, int varid, const size_t start[], const size_t count[], const double *dp);

void cdf_get_vara_float(int ncid, int varid, const size_t start[], const size_t count[], float *fp);
void cdf_put_vara_float(int ncid, int varid, const size_t start[], const size_t count[], const float *fp);

void cdf_get_vara_int(int ncid, int varid, const size_t start[], const size_t count[], int *dp);

void cdf_get_vara(int ncid, int varid, const size_t start[], const size_t count[], void *cp);
void cdf_put_vara(int ncid, int varid, const size_t start[], const size_t count[], const void *cp);

void cdf_put_att_text(int ncid, int varid, const char *name, size_t len, const char *tp);
void cdf_put_att_int(int ncid, int varid, const char *name, nc_type xtype, size_t len, const int *ip);
void cdf_put_att_float(int ncid, int varid, const char *name, nc_type xtype, size_t len, const float *dp);
void cdf_put_att_double(int ncid, int varid, const char *name, nc_type xtype, size_t len, const double *dp);

void cdf_get_att_string(int ncid, int varid, const char *name, char **tp);
void cdf_get_att_text(int ncid, int varid, const char *name, char *tp);
void cdf_get_att_int(int ncid, int varid, const char *name, int *ip);
void cdf_get_att_longlong(int ncid, int varid, const char *name, long long *llp);
void cdf_get_att_double(int ncid, int varid, const char *name, double *dp);

void cdf_inq_att(int ncid, int varid, const char *name, nc_type *xtypep, size_t *lenp);
void cdf_inq_atttype(int ncid, int varid, const char *name, nc_type *xtypep);
void cdf_inq_attlen(int ncid, int varid, const char *name, size_t *lenp);
void cdf_inq_attname(int ncid, int varid, int attnum, char *name);
void cdf_inq_attid(int ncid, int varid, const char *name, int *attnump);

void cdf_def_var_chunking(int ncid, int varid, int storage, const size_t *chunksizesp);

typedef int (*cdi_nc__create_funcp)(const char *path, int cmode, size_t initialsz, size_t *chunksizehintp, int *ncidp);

typedef void (*cdi_cdf_def_var_funcp)(int ncid, const char *name, nc_type xtype, int ndims, const int dimids[], int *varidp);

int cdi_nc_enddef_serial(int ncid, int streamID);
int cdi_nc__enddef_serial(int ncid, int streamID, size_t hdr_pad, size_t v_align, size_t v_minfree, size_t r_align);
typedef int (*cdi_nc_enddef_funcp)(int ncid, int streamID);
typedef int (*cdi_nc__enddef_funcp)(int ncid, int streamID, size_t hdr_pad, size_t v_align, size_t v_minfree, size_t r_align);

size_t cdf_xtype_to_numbytes(nc_type xtype);

#endif

#endif /* CDF_INT_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#include <ctype.h>


#ifdef HAVE_LIBNETCDF
const char *
cdfLibraryVersion(void)
{
  return nc_inq_libvers();
}

int CDF_Debug = 0;  // If set to 1, debugging

void
cdfDebug(int debug)
{
  CDF_Debug = debug;

  if (CDF_Debug) Message("debug level %d", debug);
}

static void
cdfComment(int ncid)
{
  static char comment[256] = "Climate Data Interface version ";
  static bool init = false;

  if (!init)
  {
    init = true;
    const char *libvers = cdiLibraryVersion();

    if (!isdigit((int) *libvers))
      strcat(comment, "??");
    else
      strcat(comment, libvers);
    strcat(comment, " (https://mpimet.mpg.de/cdi)");
  }

  cdf_put_att_text(ncid, NC_GLOBAL, "CDI", strlen(comment), comment);
}

static bool
has_uri_scheme(const char *uri)
{
  const char *pos = strstr(uri, "://");
  if (pos)
  {
    size_t len = (size_t) (pos - uri);
    if (strncmp(uri, "file", len) == 0 || strncmp(uri, "https", len) == 0 || strncmp(uri, "s3", len) == 0) return true;
  }

  return false;
}

static int
cdf_open_read(const char *filename, int *filetype)
{
  int ncid = -1;
  int readmode = NC_NOWRITE;
  int status = cdf_open(filename, readmode, &ncid);
  if (status > 0 && ncid < 0) ncid = CDI_ESYSTEM;
  if (status < -1000 && ncid == -1) ncid = status;
#ifdef HAVE_NETCDF4
  else
  {
    int format = -1;
    status = nc_inq_format(ncid, &format);
    if (status == NC_NOERR && format == NC_FORMAT_NETCDF4_CLASSIC) *filetype = CDI_FILETYPE_NC4C;

#ifdef NC_FORMATX_NCZARR
    int modeNC;
    status = nc_inq_format_extended(ncid, &format, &modeNC);
    if (status == NC_NOERR && format == NC_FORMATX_NCZARR) *filetype = CDI_FILETYPE_NCZARR;
#endif
  }
#endif

  return ncid;
}

static int
cdf_open_write(const char *filename, int *filetype)
{
  int ncid = -1;
  int writemode = NC_CLOBBER;

#ifdef NC_64BIT_OFFSET
  if (*filetype == CDI_FILETYPE_NC2) writemode |= NC_64BIT_OFFSET;
#endif
#ifdef NC_64BIT_DATA
  if (*filetype == CDI_FILETYPE_NC5) writemode |= NC_64BIT_DATA;
#endif
#ifdef HAVE_NETCDF4
  if (*filetype == CDI_FILETYPE_NC4C) writemode |= (NC_NETCDF4 | NC_CLASSIC_MODEL);
  if (*filetype == CDI_FILETYPE_NC4) writemode |= NC_NETCDF4;
  if (*filetype == CDI_FILETYPE_NCZARR) writemode |= NC_NETCDF4;
#endif
  if (*filetype == CDI_FILETYPE_NCZARR)
  {
    if (!has_uri_scheme(filename))
    {
      fprintf(stderr, "URI scheme is missing in NCZarr path!\n");
      return CDI_EINVAL;
    }

    cdf_create(filename, writemode, &ncid);
  }
  else
  {
    if (has_uri_scheme(filename)) fprintf(stderr, "URI scheme defined for non NCZarr Data Model!\n");

    cdf__create(filename, writemode, &ncid);
  }

  return ncid;
}

static int
cdfOpenFile(const char *filename, const char *mode, int *filetype)
{
  int ncid = -1;

  if (filename == NULL) { ncid = CDI_EINVAL; }
  else
  {
    int fmode = tolower(*mode);
    switch (fmode)
    {
      case 'r': ncid = cdf_open_read(filename, filetype); break;
      case 'w':
        ncid = cdf_open_write(filename, filetype);
        if (ncid != CDI_EINVAL)
        {
          if (CDI_Version_Info) cdfComment(ncid);
          cdf_put_att_text(ncid, NC_GLOBAL, "Conventions", 6, "CF-1.6");
        }
        break;
      case 'a': cdf_open(filename, NC_WRITE, &ncid); break;
      default: ncid = CDI_EINVAL;
    }
  }

  return ncid;
}

int
cdfOpen(const char *filename, const char *mode, int filetype)
{
  int fileID = -1;
  bool open_file = true;

  if (CDF_Debug) Message("Open %s with mode %c", filename, *mode);

#ifndef NC_64BIT_OFFSET
  if (filetype == CDI_FILETYPE_NC2) open_file = false;
#endif
#ifndef NC_64BIT_DATA
  if (filetype == CDI_FILETYPE_NC5) open_file = false;
#endif

  if (open_file)
  {
    fileID = cdfOpenFile(filename, mode, &filetype);

    if (CDF_Debug) Message("File %s opened with id %d", filename, fileID);
  }
  else { fileID = CDI_ELIBNAVAIL; }

  return fileID;
}

int
cdf4Open(const char *filename, const char *mode, int *filetype)
{
  if (CDF_Debug) Message("Open %s with mode %c", filename, *mode);

#ifdef HAVE_NETCDF4
  int fileID = cdfOpenFile(filename, mode, filetype);
  if (CDF_Debug) Message("File %s opened with id %d", filename, fileID);
  return fileID;
#else
  return CDI_ELIBNAVAIL;
#endif
}

static void
cdfCloseFile(int fileID)
{

  if (CDF_Debug) Message("Closing cdf file: %d", fileID);
  cdf_close(fileID);
}

void
cdfClose(int fileID)
{
  cdfCloseFile(fileID);
}

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef NAMESPACE_H
#define NAMESPACE_H

#ifdef HAVE_CONFIG_H
#endif

typedef struct
{
  int idx;
  int nsp;
} namespaceTuple_t;

enum namespaceSwitch
{
  NSSWITCH_NO_SUCH_SWITCH = -1,
  NSSWITCH_ABORT,
  NSSWITCH_WARNING,
  NSSWITCH_SERIALIZE_GET_SIZE,
  NSSWITCH_SERIALIZE_PACK,
  NSSWITCH_SERIALIZE_UNPACK,
  NSSWITCH_FILE_OPEN,
  NSSWITCH_FILE_WRITE,
  NSSWITCH_FILE_CLOSE,
  NSSWITCH_STREAM_OPEN_BACKEND,
  NSSWITCH_STREAM_DEF_VLIST_,
  NSSWITCH_STREAM_SETUP_VLIST,
  NSSWITCH_STREAM_WRITE_VAR_,
  NSSWITCH_STREAM_WRITE_VAR_CHUNK_,
  NSSWITCH_STREAM_WRITE_VAR_PART_,
  NSSWITCH_STREAM_WRITE_SCATTERED_VAR_PART_,
  NSSWITCH_STREAM_CLOSE_BACKEND,
  NSSWITCH_STREAM_DEF_TIMESTEP_,
  NSSWITCH_STREAM_SYNC,
  NSSWITCH_VLIST_DESTROY_,
#ifdef HAVE_LIBNETCDF
  NSSWITCH_NC__CREATE,
  NSSWITCH_CDF_DEF_VAR,
  NSSWITCH_NC_ENDDEF,
  NSSWITCH_NC__ENDDEF,
  NSSWITCH_CDF_DEF_TIMESTEP,
  NSSWITCH_CDF_STREAM_SETUP,
  NSSWITCH_CDF_POSTDEFACTION_GRID_PROP,
#endif
  NUM_NAMESPACE_SWITCH,
};

union namespaceSwitchValue
{
  void *data;
  void (*func)(void);
};

#define NSSW_FUNC(p) ((union namespaceSwitchValue){ .func = (void (*)(void))(p) })
#define NSSW_DATA(p) ((union namespaceSwitchValue){ .data = (void *) (p) })

// int              namespaceNew();
// void             namespaceDelete(int namespaceID);
void namespaceCleanup(void);
int namespaceGetNumber(void);
// void             namespaceSetActive(int namespaceID);
// int              namespaceGetActive    ( void );
int namespaceIdxEncode(namespaceTuple_t);
int namespaceIdxEncode2(int, int);
namespaceTuple_t namespaceResHDecode(int);
int namespaceAdaptKey(int originResH, int originNamespace);
int namespaceAdaptKey2(int);
void namespaceSwitchSet(int sw, union namespaceSwitchValue value);
union namespaceSwitchValue namespaceSwitchGet(int sw);
/* reserve new dynamic key */
int cdiNamespaceSwitchNewKey(void);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#include <sys/stat.h>


const char *
cdf_strerror(int cdfErrorNo)
{
#ifdef HAVE_LIBNETCDF
  return nc_strerror(cdfErrorNo);
#else
  return NULL;
#endif
}

#ifdef HAVE_LIBNETCDF

void
cdf_create(const char *path, int cmode, int *ncidp)
{
  int status = nc_create(path, cmode, ncidp);

  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  mode=%d  file=%s", *ncidp, cmode, path);

  if (status != NC_NOERR) Error("%s: %s", path, nc_strerror(status));

  int oldfill;
  status = nc_set_fill(*ncidp, NC_NOFILL, &oldfill);

  if (status != NC_NOERR) Error("%s: %s", path, nc_strerror(status));
}

void
cdf__create(const char *path, int cmode, int *ncidp)
{
  int status = -1;
  size_t chunksizehint = 0;
  size_t initialsz = 0;

#if defined(__SX__) || defined(ES)
  chunksizehint = 16777216;  // 16 MB
#endif

  if (CDI_Netcdf_Chunksizehint != CDI_UNDEFID) chunksizehint = (size_t) CDI_Netcdf_Chunksizehint;

  cdi_nc__create_funcp my_nc__create = (cdi_nc__create_funcp) namespaceSwitchGet(NSSWITCH_NC__CREATE).func;
  status = my_nc__create(path, cmode, initialsz, &chunksizehint, ncidp);

  if (status != NC_NOERR)
  {
    if (CDF_Debug) Message("ncid=%d  mode=%d  chunksizehint=%zu  file=%s", *ncidp, cmode, chunksizehint, path);
    Error("%s: %s", path, nc_strerror(status));
  }

  int oldfill;
  status = nc_set_fill(*ncidp, NC_NOFILL, &oldfill);

  if (status != NC_NOERR) Error("%s: %s", path, nc_strerror(status));
}

int
cdf_open(const char *path, int omode, int *ncidp)
{
  int status = 0;

  if (strstr(path, ":/"))  // ESDM and DAP
  {
    status = nc_open(path, omode, ncidp);
  }
  else
  {
    struct stat filestat;
    if (stat(path, &filestat) != 0) SysError(path);

    size_t chunksizehint = 0;
#ifdef HAVE_STRUCT_STAT_ST_BLKSIZE
    chunksizehint = (size_t) filestat.st_blksize * 4;
    if (chunksizehint > (size_t) filestat.st_size) chunksizehint = (size_t) filestat.st_size;
#endif
    // if (chunksizehint < ChunkSizeMin) chunksizehint = ChunkSizeMin;
    if (CDI_Netcdf_Chunksizehint != CDI_UNDEFID) chunksizehint = (size_t) CDI_Netcdf_Chunksizehint;

    // FIXME: parallel part missing
    status = nc__open(path, omode, &chunksizehint, ncidp);

    if (CDF_Debug) Message("chunksizehint %zu", chunksizehint);
  }

  if (CDF_Debug) Message("ncid=%d  mode=%d  file=%s", *ncidp, omode, path);

  if (CDF_Debug && status != NC_NOERR) Message("%s", nc_strerror(status));
  if (status != NC_NOERR && status < 0) status -= 1000;

  return status;
}

void
cdf_close(int ncid)
{
  int status = nc_close(ncid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_redef(int ncid)
{
  int status = nc_redef(ncid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

int
cdi_nc_enddef_serial(int ncid, int streamID)
{
  (void) streamID;
  return nc_enddef(ncid);
}

int
cdi_nc__enddef_serial(int ncid, int streamID, size_t hdr_pad, size_t v_align, size_t v_minfree, size_t r_align)
{
  (void) streamID;
  return nc__enddef(ncid, hdr_pad, v_align, v_minfree, r_align);
}

void
cdf_enddef(int ncid, int streamID)
{
  cdi_nc_enddef_funcp my_nc_enddef = (cdi_nc_enddef_funcp) namespaceSwitchGet(NSSWITCH_NC_ENDDEF).func;
  int status = my_nc_enddef(ncid, streamID);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf__enddef(int ncid, int streamID, size_t hdr_pad)
{
  size_t v_align = 4UL;    // [B] Alignment of beginning of data section for fixed variables
  size_t v_minfree = 0UL;  // [B] Pad at end of data section for fixed size variables
  size_t r_align = 4UL;    // [B] Alignment of beginning of data section for record variables

  // nc_enddef(ncid) is equivalent to nc__enddef(ncid, 0, 4, 0, 4)
  cdi_nc__enddef_funcp my_nc__enddef = (cdi_nc__enddef_funcp) namespaceSwitchGet(NSSWITCH_NC__ENDDEF).func;
  int status = my_nc__enddef(ncid, streamID, hdr_pad, v_align, v_minfree, r_align);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_sync(int ncid)
{
  int status = nc_sync(ncid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq(int ncid, int *ndimsp, int *nvarsp, int *ngattsp, int *unlimdimidp)
{
  int status = nc_inq(ncid, ndimsp, nvarsp, ngattsp, unlimdimidp);
  if (CDF_Debug || status != NC_NOERR)
    Message("ncid=%d  ndims=%d  nvars=%d  ngatts=%d  unlimid=%d", ncid, *ndimsp, *nvarsp, *ngattsp, *unlimdimidp);

  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_def_dim(int ncid, const char *name, size_t len, int *dimidp)
{
  int status = nc_def_dim(ncid, name, len, dimidp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  name=%s  len=%zu", ncid, name, len);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_dimid(int ncid, const char *name, int *dimidp)
{
  int status = nc_inq_dimid(ncid, name, dimidp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  name=%s  dimid=%d", ncid, name, *dimidp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_dim(int ncid, int dimid, char *name, size_t *lengthp)
{
  int status = nc_inq_dim(ncid, dimid, name, lengthp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  dimid=%d  length=%zu  name=%s", ncid, dimid, *lengthp, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_dimname(int ncid, int dimid, char *name)
{
  int status = nc_inq_dimname(ncid, dimid, name);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  dimid=%d  name=%s", ncid, dimid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_dimlen(int ncid, int dimid, size_t *lengthp)
{
  int status = nc_inq_dimlen(ncid, dimid, lengthp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  dimid=%d  length=%zu", ncid, dimid, *lengthp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_def_var(int ncid, const char *name, nc_type xtype, int ndims, const int dimids[], int *varidp)
{
  cdi_cdf_def_var_funcp my_cdf_def_var = (cdi_cdf_def_var_funcp) namespaceSwitchGet(NSSWITCH_CDF_DEF_VAR).func;
  my_cdf_def_var(ncid, name, xtype, ndims, dimids, varidp);
}

void
cdf_def_var_serial(int ncid, const char *name, nc_type xtype, int ndims, const int dimids[], int *varidp)
{
  int status = nc_def_var(ncid, name, xtype, ndims, dimids, varidp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  name=%s  xtype=%d  ndims=%d  varid=%d", ncid, name, xtype, ndims, *varidp);
  if (status == NC_NOERR)
  {
    int fileFormat;
    status = nc_inq_format(ncid, &fileFormat);
    if (status == NC_NOERR && (fileFormat == NC_FORMAT_NETCDF4 || fileFormat == NC_FORMAT_NETCDF4_CLASSIC))
      status = nc_def_var_fill(ncid, *varidp, 1, NULL);
  }
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_varid(int ncid, const char *name, int *varidp)
{
  int status = nc_inq_varid(ncid, name, varidp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  name=%s  varid=%d", ncid, name, *varidp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_nvars(int ncid, int *nvarsp)
{
  int status = nc_inq_nvars(ncid, nvarsp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  nvars=%d", ncid, *nvarsp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_var(int ncid, int varid, char *name, nc_type *xtypep, int *ndimsp, int dimids[], int *nattsp)
{
  int status = nc_inq_var(ncid, varid, name, xtypep, ndimsp, dimids, nattsp);
  if (CDF_Debug || status != NC_NOERR)
    Message("ncid=%d  varid=%d  ndims=%d  xtype=%d  natts=%d  name=%s", ncid, varid, *ndimsp, *xtypep, *nattsp, name);

  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_varname(int ncid, int varid, char *name)
{
  int status = nc_inq_varname(ncid, varid, name);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  name=%s", ncid, varid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_vartype(int ncid, int varid, nc_type *xtypep)
{
  int status = nc_inq_vartype(ncid, varid, xtypep);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  xtype=%s", ncid, varid, *xtypep);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_varndims(int ncid, int varid, int *ndimsp)
{
  int status = nc_inq_varndims(ncid, varid, ndimsp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_vardimid(int ncid, int varid, int dimids[])
{
  int status = nc_inq_vardimid(ncid, varid, dimids);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_varnatts(int ncid, int varid, int *nattsp)
{
  int status = nc_inq_varnatts(ncid, varid, nattsp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  nattsp=%d", ncid, varid, *nattsp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var_text(int ncid, int varid, const char *tp)
{
  int status = nc_put_var_text(ncid, varid, tp);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %s", ncid, varid, tp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var_short(int ncid, int varid, const short *sp)
{
  int status = nc_put_var_short(ncid, varid, sp);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %hd", ncid, varid, *sp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var_int(int ncid, int varid, const int *ip)
{
  int status = nc_put_var_int(ncid, varid, ip);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %d", ncid, varid, *ip);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var_int64(int ncid, int varid, const int64_t *ip)
{
#ifdef HAVE_NETCDF4
  const long long *llp = (const long long *) ip;
  int status = nc_put_var_longlong(ncid, varid, llp);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %lld", ncid, varid, *llp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
#endif
}

void
cdf_put_var_long(int ncid, int varid, const long *lp)
{
  int status = nc_put_var_long(ncid, varid, lp);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %ld", ncid, varid, *lp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var_float(int ncid, int varid, const float *fp)
{
  int status = nc_put_var_float(ncid, varid, fp);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %f", ncid, varid, *fp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

static const char *
cdf_var_type(nc_type xtype)
{
  const char *ctype = "unknown";

  // clang-format off
  if      (xtype == NC_BYTE  )  ctype = "NC_BYTE";
  else if (xtype == NC_CHAR  )  ctype = "NC_CHAR";
  else if (xtype == NC_SHORT )  ctype = "NC_SHORT";
  else if (xtype == NC_INT   )  ctype = "NC_INT";
  else if (xtype == NC_FLOAT )  ctype = "NC_FLOAT";
  else if (xtype == NC_DOUBLE)  ctype = "NC_DOUBLE";
#ifdef  HAVE_NETCDF4
  else if (xtype == NC_UBYTE )  ctype = "NC_UBYTE";
  else if (xtype == NC_LONG  )  ctype = "NC_LONG";
  else if (xtype == NC_USHORT)  ctype = "NC_USHORT";
  else if (xtype == NC_UINT  )  ctype = "NC_UINT";
  else if (xtype == NC_INT64 )  ctype = "NC_INT64";
  else if (xtype == NC_UINT64)  ctype = "NC_UINT64";
#endif
  // clang-format on

  return ctype;
}

static void
minmaxval(size_t nvals, const double *array, double *minval, double *maxval)
{
  double minv = array[0];
  double maxv = array[0];
  for (size_t i = 0; i < nvals; ++i)
  {
    minv = (array[i] < minv) ? array[i] : minv;
    maxv = (array[i] > maxv) ? array[i] : maxv;
  }

  *minval = minv;
  *maxval = maxv;
}

static void
minmaxvalf(size_t nvals, const float *array, double *minval, double *maxval)
{
  float minv = array[0];
  float maxv = array[0];
  for (size_t i = 0; i < nvals; ++i)
  {
    minv = (array[i] < minv) ? array[i] : minv;
    maxv = (array[i] > maxv) ? array[i] : maxv;
  }

  *minval = minv;
  *maxval = maxv;
}

void
cdf_put_vara_double(int ncid, int varid, const size_t start[], const size_t count[], const double *dp)
{
  int status = nc_put_vara_double(ncid, varid, start, count, dp);
  if (CDF_Debug || status != NC_NOERR)
  {
    char name[256];
    nc_inq_varname(ncid, varid, name);
    nc_type xtype;
    nc_inq_vartype(ncid, varid, &xtype);
    int ndims;
    nc_inq_varndims(ncid, varid, &ndims);
    double minval = 0.0, maxval = 0.0;
    size_t nvals = 1;
    for (int i = 0; i < ndims; ++i) nvals *= count[i];
    minmaxval(nvals, dp, &minval, &maxval);
    Message("name=%s  type=%s  minval=%f  maxval=%f", name, cdf_var_type(xtype), minval, maxval);
  }

  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_vara_float(int ncid, int varid, const size_t start[], const size_t count[], const float *fp)
{
  int status = nc_put_vara_float(ncid, varid, start, count, fp);
  if (CDF_Debug || status != NC_NOERR)
  {
    char name[256];
    nc_inq_varname(ncid, varid, name);
    nc_type xtype;
    nc_inq_vartype(ncid, varid, &xtype);
    int ndims;
    nc_inq_varndims(ncid, varid, &ndims);
    double minval = 0.0, maxval = 0.0;
    size_t nvals = 1;
    for (int i = 0; i < ndims; ++i) nvals *= count[i];
    minmaxvalf(nvals, fp, &minval, &maxval);
    Message("name=%s  type=%s  minval=%f  maxval=%f", name, cdf_var_type(xtype), minval, maxval);
  }

  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_vara(int ncid, int varid, const size_t start[], const size_t count[], const void *cp)
{
  int status = nc_put_vara(ncid, varid, start, count, cp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_vara(int ncid, int varid, const size_t start[], const size_t count[], void *cp)
{
  int status = nc_get_vara(ncid, varid, start, count, cp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_vara_int(int ncid, int varid, const size_t start[], const size_t count[], int *dp)
{
  int status = nc_get_vara_int(ncid, varid, start, count, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_vara_double(int ncid, int varid, const size_t start[], const size_t count[], double *dp)
{
  int status = nc_get_vara_double(ncid, varid, start, count, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  start[0]=%zu  count[0]=%zu", ncid, varid, start[0], count[0]);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_vara_float(int ncid, int varid, const size_t start[], const size_t count[], float *fp)
{
  int status = nc_get_vara_float(ncid, varid, start, count, fp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  start[0]=%zu  count[0]=%zu", ncid, varid, start[0], count[0]);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_vara_text(int ncid, int varid, const size_t start[], const size_t count[], char *tp)
{
  int status = nc_get_vara_text(ncid, varid, start, count, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_vara_uchar(int ncid, int varid, const size_t start[], const size_t count[], unsigned char *tp)
{
  int status = nc_get_vara_uchar(ncid, varid, start, count, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var_double(int ncid, int varid, const double *dp)
{
  int status = nc_put_var_double(ncid, varid, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  val0=%f", ncid, varid, *dp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var1_text(int ncid, int varid, const size_t index[], char *tp)
{
  int status = nc_get_var1_text(ncid, varid, index, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var1_double(int ncid, int varid, const size_t index[], double *dp)
{
  int status = nc_get_var1_double(ncid, varid, index, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_var1_double(int ncid, int varid, const size_t index[], const double *dp)
{
  int status = nc_put_var1_double(ncid, varid, index, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  val=%f", ncid, varid, *dp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var_text(int ncid, int varid, char *tp)
{
  int status = nc_get_var_text(ncid, varid, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var_short(int ncid, int varid, short *sp)
{
  int status = nc_get_var_short(ncid, varid, sp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var_int(int ncid, int varid, int *ip)
{
  int status = nc_get_var_int(ncid, varid, ip);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var_int64(int ncid, int varid, int64_t *ip)
{
#ifdef HAVE_NETCDF4
  long long *llp = (long long *) ip;
  int status = nc_get_var_longlong(ncid, varid, llp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
#endif
}

void
cdf_get_var_long(int ncid, int varid, long *lp)
{
  int status = nc_get_var_long(ncid, varid, lp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var_float(int ncid, int varid, float *fp)
{
  int status = nc_get_var_float(ncid, varid, fp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d", ncid, varid);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_var_double(int ncid, int varid, double *dp)
{
  int status = nc_get_var_double(ncid, varid, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  val[0]=%f", ncid, varid, *dp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_copy_att(int ncid_in, int varid_in, const char *name, int ncid_out, int varid_out)
{
  int status = nc_copy_att(ncid_in, varid_in, name, ncid_out, varid_out);
  if (CDF_Debug || status != NC_NOERR) Message("%d %d %s %d %d", ncid_in, varid_out, name, ncid_out, varid_out);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_att_text(int ncid, int varid, const char *name, size_t len, const char *tp)
{
  int status = nc_put_att_text(ncid, varid, name, len, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  text='%.*s'", ncid, varid, name, (int) len, tp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_att_int(int ncid, int varid, const char *name, nc_type xtype, size_t len, const int *ip)
{
  int status = nc_put_att_int(ncid, varid, name, xtype, len, ip);
  if (status == NC_ERANGE) status = NC_NOERR;
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  val=%d", ncid, varid, name, *ip);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_att_float(int ncid, int varid, const char *name, nc_type xtype, size_t len, const float *dp)
{
  int status = nc_put_att_float(ncid, varid, name, xtype, len, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  val=%g", ncid, varid, name, *dp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_put_att_double(int ncid, int varid, const char *name, nc_type xtype, size_t len, const double *dp)
{
  int status = nc_put_att_double(ncid, varid, name, xtype, len, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  val=%g", ncid, varid, name, *dp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_att_text(int ncid, int varid, const char *name, char *tp)
{
  int status = nc_get_att_text(ncid, varid, name, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  name=%s", ncid, varid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_att_string(int ncid, int varid, const char *name, char **tp)
{
#ifdef HAVE_NETCDF4
  int status = nc_get_att_string(ncid, varid, name, tp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  name=%s", ncid, varid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
#endif
}

void
cdf_get_att_int(int ncid, int varid, const char *name, int *ip)
{
  int status = nc_get_att_int(ncid, varid, name, ip);
  if (status == NC_ERANGE) status = NC_NOERR;
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  val=%d", ncid, varid, name, *ip);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_get_att_longlong(int ncid, int varid, const char *name, long long *llp)
{
#ifdef HAVE_NETCDF4
  int status = nc_get_att_longlong(ncid, varid, name, llp);
  if (status == NC_ERANGE) status = NC_NOERR;
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  val=%lld", ncid, varid, name, *llp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
#endif
}

void
cdf_get_att_double(int ncid, int varid, const char *name, double *dp)
{
  int status = nc_get_att_double(ncid, varid, name, dp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  val=%.9g", ncid, varid, name, *dp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_att(int ncid, int varid, const char *name, nc_type *xtypep, size_t *lenp)
{
  int status = nc_inq_att(ncid, varid, name, xtypep, lenp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s", ncid, varid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_atttype(int ncid, int varid, const char *name, nc_type *xtypep)
{
  int status = nc_inq_atttype(ncid, varid, name, xtypep);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s", ncid, varid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_attlen(int ncid, int varid, const char *name, size_t *lenp)
{
  int status = nc_inq_attlen(ncid, varid, name, lenp);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s  len=%zu", ncid, varid, name, *lenp);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_attname(int ncid, int varid, int attnum, char *name)
{
  int status = nc_inq_attname(ncid, varid, attnum, name);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  attnum=%d  att=%s", ncid, varid, attnum, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

void
cdf_inq_attid(int ncid, int varid, const char *name, int *attnump)
{
  int status = nc_inq_attid(ncid, varid, name, attnump);
  if (CDF_Debug || status != NC_NOERR) Message("ncid=%d  varid=%d  att=%s", ncid, varid, name);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}

#ifdef HAVE_NETCDF4
void
cdf_def_var_chunking(int ncid, int varid, int storage, const size_t *chunksizesp)
{
  int status = nc_def_var_chunking(ncid, varid, storage, chunksizesp);
  if (CDF_Debug || status != NC_NOERR)
    Message("chunks=%zu/%zu/%zu/%zu", chunksizesp[0], chunksizesp[1], chunksizesp[2], chunksizesp[3]);
  if (status != NC_NOERR) Error("%s", nc_strerror(status));
}
#endif

size_t
cdf_xtype_to_numbytes(nc_type xtype)
{
  size_t numBytes = 8;

  // clang-format off
  if      (xtype == NC_BYTE  )  numBytes = 1;
  else if (xtype == NC_CHAR  )  numBytes = 1;
  else if (xtype == NC_SHORT )  numBytes = 2;
  else if (xtype == NC_INT   )  numBytes = 4;
  else if (xtype == NC_FLOAT )  numBytes = 4;
#ifdef HAVE_NETCDF4
  else if (xtype == NC_UBYTE )  numBytes = 1;
  else if (xtype == NC_USHORT)  numBytes = 2;
  else if (xtype == NC_LONG  )  numBytes = 4;
  else if (xtype == NC_UINT  )  numBytes = 4;
#endif
  // clang-format on

  return numBytes;
}

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDF_UTIL_H_
#define CDF_UTIL_H_

#include <stdlib.h>
#include <stdbool.h>

bool xtypeIsText(int xtype);

int get_time_units(size_t len, const char *ptu);

bool is_time_units(const char *timeunits);
bool is_timeaxis_units(const char *timeunits);

bool is_height_units(const char *units);
bool is_pressure_units(const char *units);
bool is_DBL_axis(/*const char *units,*/ const char *longname);
bool is_depth_axis(const char *stdname, const char *longname);
bool is_height_axis(const char *stdname, const char *longname);
bool is_altitude_axis(const char *stdname, const char *longname);
bool is_reference_axis(const char *stdname, const char *longname);

bool is_lon_axis(const char *units, const char *stdname);
bool is_lat_axis(const char *units, const char *stdname);

bool is_x_axis(const char *units, const char *stdname);
bool is_y_axis(const char *units, const char *stdname);

void cdf_set_gridtype(const char *attstring, int *gridtype);
void cdf_set_zaxistype(const char *attstring, int *zaxistype);
int attribute_to_calendar(const char *attstring);

#endif
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <string.h>
#include <ctype.h>


char *
str_to_lower(char *str)
{
  if (str)
    for (size_t i = 0; str[i]; ++i) str[i] = (char) tolower((int) str[i]);

  return str;
}

bool
strStartsWith(const char *vstr, const char *cstr)
{
  bool is_equal = false;
  if (vstr && cstr)
  {
    size_t clen = strlen(cstr);
    size_t vlen = strlen(vstr);
    if (clen <= vlen) is_equal = (memcmp(vstr, cstr, clen) == 0);
  }
  return is_equal;
}

int
get_time_units(size_t len, const char *ptu)
{
  int timeunit = -1;

  while (isspace(*ptu) && len)
  {
    ptu++;
    len--;
  }

  // clang-format off
  if (len > 2)
    {
      if      (strStartsWith(ptu, "sec"))            timeunit = TUNIT_SECOND;
      else if (strStartsWith(ptu, "minute"))         timeunit = TUNIT_MINUTE;
      else if (strStartsWith(ptu, "hour"))           timeunit = TUNIT_HOUR;
      else if (strStartsWith(ptu, "day"))            timeunit = TUNIT_DAY;
      else if (strStartsWith(ptu, "month"))          timeunit = TUNIT_MONTH;
      else if (strStartsWith(ptu, "calendar_month")) timeunit = TUNIT_MONTH;
      else if (strStartsWith(ptu, "year"))           timeunit = TUNIT_YEAR;
    }
  else if     (len == 1 && ptu[0] == 's')            timeunit = TUNIT_SECOND;
  // clang-format on

  return timeunit;
}

bool
is_time_units(const char *timeunits)
{
  while (isspace(*timeunits)) timeunits++;

  // clang-format off
  return (strStartsWith(timeunits, "sec")
       || strStartsWith(timeunits, "minute")
       || strStartsWith(timeunits, "hour")
       || strStartsWith(timeunits, "day")
       || strStartsWith(timeunits, "month")
       || strStartsWith(timeunits, "calendar_month")
       || strStartsWith(timeunits, "year"));
  // clang-format on
}

bool
is_timeaxis_units(const char *timeunits)
{
  bool status = false;

  size_t len = strlen(timeunits);
  char *tu = (char *) malloc((len + 1) * sizeof(char));

  for (size_t i = 0; i < len; i++) tu[i] = (char) tolower((int) timeunits[i]);

  int timeunit = get_time_units(len, tu);
  if (timeunit != -1)
  {
    size_t pos = 0;
    while (!isspace(tu[pos]) && tu[pos] != 0) pos++;
    if (tu[pos])
    {
      while (isspace(tu[pos])) pos++;

      status = strStartsWith(tu + pos, "as") || strStartsWith(tu + pos, "since");
    }
  }

  free(tu);

  return status;
}

bool
is_height_units(const char *units)
{
  int u0 = units[0];

  // clang-format off
  return ((u0=='m' && (!units[1] || strStartsWith(units, "meter")))
       || (!units[2] && units[1]=='m' && (u0=='c' || u0=='d' || u0=='k'))
       || (strStartsWith(units, "decimeter"))
       || (strStartsWith(units, "centimeter"))
       || (strStartsWith(units, "millimeter"))
       || (strStartsWith(units, "kilometer")));
  // clang-format on
}

bool
is_pressure_units(const char *units)
{
  // clang-format off
  return (strStartsWith(units, "millibar")
       || strStartsWith(units, "mb")
       || strStartsWith(units, "hectopas")
       || strStartsWith(units, "hPa")
       || strStartsWith(units, "pa")
       || strStartsWith(units, "Pa"));
  // clang-format on
}

bool
is_DBL_axis(const char *longname)
{
  // clang-format off
  return (str_is_equal(longname, "depth below land")
       || str_is_equal(longname, "depth_below_land")
       || str_is_equal(longname, "levels below the surface"));
  // clang-format on
}

bool
is_depth_axis(const char *stdname, const char *longname)
{
  // clang-format off
  return (str_is_equal(stdname, "depth")
       || str_is_equal(longname, "depth_below_sea")
       || str_is_equal(longname, "depth below sea"));
  // clang-format ofn
}


bool is_height_axis(const char *stdname, const char *longname)
{
  // clang-format off
  return (str_is_equal(stdname, "height")
       || str_is_equal(longname, "height")
       || str_is_equal(longname, "height above the surface"));
  // clang-format on
}

bool
is_altitude_axis(const char *stdname, const char *longname)
{
  // clang-format off
  return (str_is_equal(stdname, "altitude")
       || str_is_equal(longname, "altitude"));
  // clang-format on
}

bool
is_reference_axis(const char *stdname, const char *longname)
{
  // clang-format off
  return ((str_is_equal(longname, "generalized_height") || str_is_equal(longname, "generalized height"))
        && str_is_equal(stdname, "height"));
  // clang-format on
}

bool
is_lon_axis(const char *units, const char *stdname)
{
  bool status = false;
  char lc_units[16];

  memcpy(lc_units, units, 15);
  lc_units[15] = 0;
  str_to_lower(lc_units);

  if ((strStartsWith(lc_units, "degree") || strStartsWith(lc_units, "radian"))
      && (strStartsWith(stdname, "grid_longitude") || strStartsWith(stdname, "longitude")))
  {
    status = true;
  }
  else if (strStartsWith(lc_units, "degree") && !strStartsWith(stdname, "grid_latitude") && !strStartsWith(stdname, "latitude"))
  {
    int ioff = 6;
    if (lc_units[ioff] == 's') ioff++;
    if (lc_units[ioff] == ' ') ioff++;
    if (lc_units[ioff] == '_') ioff++;
    if (lc_units[ioff] == 'e') status = true;
  }

  return status;
}

bool
is_lat_axis(const char *units, const char *stdname)
{
  bool status = false;
  char lc_units[16];

  memcpy(lc_units, units, 15);
  lc_units[15] = 0;
  str_to_lower(lc_units);

  if ((strStartsWith(lc_units, "degree") || strStartsWith(lc_units, "radian"))
      && (strStartsWith(stdname, "grid_latitude") || strStartsWith(stdname, "latitude")))
  {
    status = true;
  }
  else if (strStartsWith(lc_units, "degree") && !strStartsWith(stdname, "grid_longitude") && !strStartsWith(stdname, "longitude"))
  {
    int ioff = 6;
    if (lc_units[ioff] == 's') ioff++;
    if (lc_units[ioff] == ' ') ioff++;
    if (lc_units[ioff] == '_') ioff++;
    if (lc_units[ioff] == 'n' || lc_units[ioff] == 's') status = true;
  }

  return status;
}

bool
is_x_axis(const char *units, const char *stdname)
{
  (void) units;
  return (str_is_equal(stdname, "projection_x_coordinate"));
}

bool
is_y_axis(const char *units, const char *stdname)
{
  (void) units;
  return (str_is_equal(stdname, "projection_y_coordinate"));
}

void
cdf_set_gridtype(const char *attstring, int *gridtype)
{
  // clang-format off
  if      (str_is_equal(attstring, "gaussian_reduced")) *gridtype = GRID_GAUSSIAN_REDUCED;
  else if (str_is_equal(attstring, "gaussian"))         *gridtype = GRID_GAUSSIAN;
  else if (strStartsWith(attstring, "spectral"))        *gridtype = GRID_SPECTRAL;
  else if (strStartsWith(attstring, "fourier"))         *gridtype = GRID_FOURIER;
  else if (str_is_equal(attstring, "trajectory"))       *gridtype = GRID_TRAJECTORY;
  else if (str_is_equal(attstring, "generic"))          *gridtype = GRID_GENERIC;
  else if (str_is_equal(attstring, "cell"))             *gridtype = GRID_UNSTRUCTURED;
  else if (str_is_equal(attstring, "unstructured"))     *gridtype = GRID_UNSTRUCTURED;
  else if (str_is_equal(attstring, "curvilinear")) ;
  else if (str_is_equal(attstring, "characterxy"))      *gridtype = GRID_CHARXY;
  else if (str_is_equal(attstring, "sinusoidal")) ;
  else if (str_is_equal(attstring, "laea")) ;
  else if (str_is_equal(attstring, "lcc2")) ;
  else if (str_is_equal(attstring, "linear")) ; // ignore grid type linear
  else
    {
      static bool warn = true;
      if (warn)
        {
          warn = false;
          Warning("NetCDF attribute grid_type='%s' unsupported!", attstring);
        }
    }
  // clang-format on
}

void
cdf_set_zaxistype(const char *attstring, int *zaxistype)
{
  // clang-format off
  if      (str_is_equal(attstring, "toa"))              *zaxistype = ZAXIS_TOA;
  else if (str_is_equal(attstring, "tropopause"))       *zaxistype = ZAXIS_TROPOPAUSE;
  else if (str_is_equal(attstring, "cloudbase"))        *zaxistype = ZAXIS_CLOUD_BASE;
  else if (str_is_equal(attstring, "cloudtop"))         *zaxistype = ZAXIS_CLOUD_TOP;
  else if (str_is_equal(attstring, "isotherm0"))        *zaxistype = ZAXIS_ISOTHERM_ZERO;
  else if (str_is_equal(attstring, "seabottom"))        *zaxistype = ZAXIS_SEA_BOTTOM;
  else if (str_is_equal(attstring, "lakebottom"))       *zaxistype = ZAXIS_LAKE_BOTTOM;
  else if (str_is_equal(attstring, "sedimentbottom"))   *zaxistype = ZAXIS_SEDIMENT_BOTTOM;
  else if (str_is_equal(attstring, "sedimentbottomta")) *zaxistype = ZAXIS_SEDIMENT_BOTTOM_TA;
  else if (str_is_equal(attstring, "sedimentbottomtw")) *zaxistype = ZAXIS_SEDIMENT_BOTTOM_TW;
  else if (str_is_equal(attstring, "mixlayer"))         *zaxistype = ZAXIS_MIX_LAYER;
  else if (str_is_equal(attstring, "atmosphere"))       *zaxistype = ZAXIS_ATMOSPHERE;
  else
    {
      static bool warn = true;
      if (warn)
        {
          warn = false;
          Warning("NetCDF attribute level_type='%s' unsupported!", attstring);
        }
    }
  // clang-format on
}

int
attribute_to_calendar(const char *attstring)
{
  // clang-format off
  if (strStartsWith(attstring, "standard"))  return CALENDAR_STANDARD;
  if (strStartsWith(attstring, "gregorian")) return CALENDAR_GREGORIAN;
  if (strStartsWith(attstring, "none"))      return CALENDAR_NONE;
  if (strStartsWith(attstring, "proleptic")) return CALENDAR_PROLEPTIC;
  if (strStartsWith(attstring, "360"))       return CALENDAR_360DAYS;
  if (strStartsWith(attstring, "365") ||
      strStartsWith(attstring, "noleap"))    return CALENDAR_365DAYS;
  if (strStartsWith(attstring, "366") ||
      strStartsWith(attstring, "all_leap"))  return CALENDAR_366DAYS;
  // clang-format on

  static bool warn = true;
  if (warn)
  {
    warn = false;
    Warning("Calendar >%s< unsupported!", attstring);
  }

  return CALENDAR_STANDARD;
}
#ifndef CDI_ATT_H
#define CDI_ATT_H

#ifdef HAVE_CONFIG_H
#endif

#ifndef CDI_LIMITS_H
#endif

#include <stdio.h>

// CDI attribute
// clang-format off
typedef struct
{
  size_t    xsz;	  // amount of space at xvalue
  size_t    namesz;       // size of name
  char     *name;         // attribute name
  int       indtype;	  // internal data type of xvalue (INT, FLT or TXT)
  int       exdtype;      // external data type
                          // indtype    exdtype
                          // TXT        TXT
                          // INT        INT16, INT32
                          // FLT        FLT32, FLT64
  size_t    nelems;    	  // number of elements
  void     *xvalue;       // the actual data
} cdi_att_t;
// clang-format on

// clang-format off
typedef struct
{
  size_t     nalloc;		// number allocated >= nelems
  size_t     nelems;		// length of the array
  cdi_att_t  value[MAX_ATTRIBUTES];
} cdi_atts_t;
// clang-format on

int cdiDeleteAtts(int vlistID, int varID);
int cdiAttsGetSize(void *p, int varID, void *context);
void cdiAttsPack(void *p, int varID, void *buf, int size, int *position, void *context);
void cdiAttsUnpack(int cdiID, int varID, void *buf, int size, int *position, void *context);

int cdi_att_compare(cdi_atts_t *attspa, cdi_atts_t *attspb, int attnum);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef GRID_H
#define GRID_H

#include <stdbool.h>


typedef unsigned char mask_t;

typedef struct grid_t grid_t;

enum gridPropInq
{
  GRID_PROP_MASK,
  GRID_PROP_MASK_GME,
  GRID_PROP_XVALS,
  GRID_PROP_YVALS,
  GRID_PROP_AREA,
  GRID_PROP_XBOUNDS,
  GRID_PROP_YBOUNDS,
};

struct gridVirtTable
{
  void (*destroy)(grid_t *gridptr);
  grid_t *(*copy)(grid_t *gridptr);
  void (*copyScalarFields)(grid_t *gridptrOrig, grid_t *gridptrDup);
  void (*copyArrayFields)(grid_t *gridptrOrig, grid_t *gridptrDup);
  void (*defIndices)(grid_t *gridptr, const int64_t *indices);
  SizeType (*inqIndices)(grid_t *gridptr, int64_t *indices);
  const int64_t *(*inqIndicesPtr)(grid_t *gridptr);
  void (*defXVals)(grid_t *gridptr, const double *xvals);
  void (*defYVals)(grid_t *gridptr, const double *yvals);
  void (*defMask)(grid_t *gridptr, const int *mask);
  void (*defMaskGME)(grid_t *gridptr, const int *mask);
  void (*defXBounds)(grid_t *gridptr, const double *xbounds);
  void (*defYBounds)(grid_t *gridptr, const double *ybounds);
  void (*defArea)(grid_t *gridptr, const double *area);
  double (*inqXVal)(grid_t *gridptr, SizeType index);
  double (*inqYVal)(grid_t *gridptr, SizeType index);
  SizeType (*inqXVals)(grid_t *gridptr, double *xvals);
  SizeType (*inqXValsPart)(grid_t *gridptr, int start, SizeType length, double *xvals);
  SizeType (*inqYVals)(grid_t *gridptr, double *yvals);
  SizeType (*inqYValsPart)(grid_t *gridptr, int start, SizeType length, double *yvals);
  const double *(*inqXValsPtr)(grid_t *gridptr);
  const double *(*inqYValsPtr)(grid_t *gridptr);
#ifndef USE_MPI
  int (*inqXIsc)(grid_t *gridptr);
  int (*inqYIsc)(grid_t *gridptr);
  SizeType (*inqXCvals)(grid_t *gridptr, char **xcvals);
  SizeType (*inqYCvals)(grid_t *gridptr, char **ycvals);
  const char **(*inqXCvalsPtr)(grid_t *gridptr);
  const char **(*inqYCvalsPtr)(grid_t *gridptr);
#endif
  double (*inqXInc)(grid_t *gridptr);
  double (*inqYInc)(grid_t *gridptr);
  // return true if for both grids, any xval and all yval differ
  bool (*compareXYFull)(grid_t *gridRef, grid_t *gridTest);
  // return if for both grids, x[0], y[0], x[size-1] and y[size-1] are respectively equal
  bool (*compareXYAO)(grid_t *gridRef, grid_t *gridTest);
  void (*inqArea)(grid_t *gridptr, double *area);
  const double *(*inqAreaPtr)(grid_t *gridptr);
  /* return 1 if inq property is set */
  int (*inqPropPresence)(grid_t *gridptr, enum gridPropInq inq);
  SizeType (*inqMask)(grid_t *gridptr, int *mask);
  int (*inqMaskGME)(grid_t *gridptr, int *mask_gme);
  SizeType (*inqXBounds)(grid_t *gridptr, double *xbounds);
  SizeType (*inqYBounds)(grid_t *gridptr, double *ybounds);
  const double *(*inqXBoundsPtr)(grid_t *gridptr);
  const double *(*inqYBoundsPtr)(grid_t *gridptr);
  int txCode;
  int (*getPackSize)(grid_t *gridptr, void *context);
  int (*getPackSizeScalars)(grid_t *gridptr, void *context);
  int (*getPackSizeArrays)(grid_t *gridptr, void *context);
  int (*unpack)(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context, int force_id);
  grid_t *(*unpackScalars)(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context,
                           int force_id, int *memberMaskP);
  void (*unpackArrays)(grid_t *gridptr, int memberMask, char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos,
                       int originNamespace, void *context);
  void (*pack)(grid_t *gridptr, void *packBuffer, int packBufferSize, int *packBufferPos, void *context);
  /* return member mask */
  int (*packScalars)(grid_t *gridptr, void *packBuffer, int packBufferSize, int *packBufferPos, void *context);
  void (*packArrays)(grid_t *gridptr, int memberMask, void *packBuffer, int packBufferSize, int *packBufferPos, void *context);
};

struct gridaxis_t
{
  size_t size;  // number of values
  short flag;   // 0: undefined 1:vals 2:first+inc
  double first, last, inc;
  double *vals;
  double *bounds;
  cdi_keys_t keys;
#ifndef USE_MPI
  int clength;
  char **cvals;
#endif
};

// GME Grid
struct grid_gme_t
{
  int nd, ni, ni2, ni3;  // parameter for GRID_GME
};

struct grid_t
{
  char *name;
  int self;
  size_t size;
  int type;      // grid type
  int datatype;  // grid data type (used only internal in gridComplete())
  int proj;      // grid projection
  int projtype;  // grid projection type
  mask_t *mask;
  mask_t *mask_gme;
  int64_t *indices;
  double *area;
  struct grid_gme_t gme;
  int trunc;  // parameter for GRID_SPECTRAL
  int nvertex;
  int *reducedPoints;
  int reducedPointsSize;
  int np;                // number of parallels between a pole and the equator
  signed char isCyclic;  // three possible states:
                         // -1 if unknown,
                         //  0 if found not cyclic, or
                         //  1 for global cyclic grids
  bool lcomplex;
  bool hasdims;
  struct gridaxis_t x;
  struct gridaxis_t y;
  const struct gridVirtTable *vtable;
  cdi_keys_t keys;
  cdi_atts_t atts;
  void *extraData;
};

void grid_init(grid_t *gridptr);
void cdiGridTypeInit(grid_t *gridptr, int gridtype, size_t size);
void grid_free(grid_t *gridptr);
grid_t *grid_to_pointer(int gridID);
extern const struct gridVirtTable cdiGridVtable;

unsigned cdiGridCount(void);

void gridVerifyProj(int gridID);

double gridInqXincInMeter(int gridID);
double gridInqYincInMeter(int gridID);

// const double *gridInqXvalsPtr(int gridID);
// const double *gridInqYvalsPtr(int gridID);

const char **gridInqXCvalsPtr(int gridID);
const char **gridInqYCvalsPtr(int gridID);

// const double *gridInqXboundsPtr(int gridID);
// const double *gridInqYboundsPtr(int gridID);
const double *gridInqAreaPtr(int gridID);

int gridInqPropPresence(int gridID, enum gridPropInq inq);

int gridGenerate(const grid_t *grid);

// int gridIsEqual(int gridID1, int gridID2);

void cdiGridGetIndexList(unsigned, int *);

int gridUnpack(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context, int force_id);

/* apply func to each grid */
enum cdiApplyRet cdiGridApply(enum cdiApplyRet (*func)(int id, void *res, void *data), void *data);

struct addIfNewRes
{
  int Id;
  int isNew;
};

struct addIfNewRes cdiVlistAddGridIfNew(int vlistID, grid_t *grid, int mode);

int gridVerifyProjParamsLCC(struct CDI_GridProjParams *gpp);
int gridVerifyProjParamsSTERE(struct CDI_GridProjParams *gpp);
int gridVerifyProjParamsHEALPIX(struct CDI_GridProjParams *gpp);

bool isGaussianLatitudes(size_t nlats, const double *latitudes);
void gaussianLatitudes(size_t nlats, double *latitudes, double *weights);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef _STREAM_CDF_H
#define _STREAM_CDF_H


enum
{
  POSITIVE_UP = 1,
  POSITIVE_DOWN = 2,
};

enum
{
  CDF_MAX_TIME_UNIT_STR     /* maximum length of time unit string */
  = TAXIS_MAX_UNIT_STR_LEN  /* longest result from tunitNamePtr */
    + 7                     /* room for " since " */
    + 7 + 1 + 2 + 1 + 2     /* room for year with 7 digits,
                             * dashes and 2 digits for month and day */
    + 1 + 2 + 1 + 2 + 1 + 2 /* room for " " and 2 digit hour, minute,
                             *                          second */
    + 1                     /* and terminating '\0' */
};

int cdfDefVar(stream_t *streamptr, int varID);
void cdfDefCoordinateVars(stream_t *streamptr);
void cdfDefTimestep(stream_t *streamptr, int tsID, size_t valCount);
int cdfInqTimestep(stream_t *streamptr, int tsID);
int cdfInqContents(stream_t *streamptr);

void cdfEndDef(stream_t *streamptr);
void cdfDefField(stream_t *streamptr);

void cdfCopyField(stream_t *streamptr2, stream_t *streamptr1);

void cdfDefineAttributes(int filetype, int vlistID, int varID, int fileID, int ncvarID);

void cdf_read_field(stream_t *streamptr, int memtype, void *data, size_t *numMissVals);
void cdf_write_field(stream_t *streamptr, int memtype, const void *data, size_t numMissVals);

void cdf_read_var(stream_t *streamptr, int varID, int memtype, void *data, size_t *numMissVals);
void cdf_write_var(stream_t *streamptr, int varID, int memtype, const void *data, size_t numMissVals);

void cdf_read_var_slice(stream_t *streamptr, int varID, int levelID, int memtype, void *data, size_t *numMissVals);
void cdf_write_var_slice(stream_t *streamptr, int varID, int levelID, int memtype, const void *data, size_t numMissVals);

void cdf_write_var_chunk(stream_t *streamptr, int varID, int memtype, const int rect[][2], const void *data, size_t numMissVals);

void cdfDefVarDeflate(int ncid, int ncvarid, int shuffle, int deflateLevel);
void cdfDefTime(stream_t *streamptr);

void cdf_scale_add(size_t size, double *data, double addoffset, double scalefactor);

int cdfDefDatatype(int datatype, stream_t *streamptr);

void cdf_create_records(stream_t *streamptr, size_t tsID);

#define ChunkSizeMax 65536
#define ChunkSizeLim 16777216
size_t calc_chunksize_x(int chunkType, long chunkSize, size_t xsize, bool yIsUndefined);
size_t calc_chunksize_y(int chunkType, size_t gridsize, size_t xsize, size_t ysize);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDF_LAZY_GRID_H_
#define CDF_LAZY_GRID_H_

#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_MMAP
#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
#endif

#include <string.h>


struct xyValGet
{
  double scalefactor, addoffset;
  size_t start[3], count[3], size, dimsize;
  int datasetNCId, varNCId;
  short ndims;
};

struct cdfLazyGridIds
{
  int datasetNCId, varNCId;
};

struct cdfLazyGrid
{
  grid_t base;
  const struct gridVirtTable *baseVtable;
  struct cdfLazyGridIds cellAreaGet, xBoundsGet, yBoundsGet;
  struct xyValGet xValsGet, yValsGet;
#ifdef HAVE_LIBPTHREAD
  pthread_mutex_t loadSerialize;
#endif
};

extern double *cdfPendingLoad;

void cdfLazyGridRenew(struct cdfLazyGrid *restrict *restrict gridpptr, int gridtype);
void cdfBaseGridRenew(struct cdfLazyGrid *restrict *restrict gridpptr, int gridtype);

void cdfLazyGridDestroy(struct cdfLazyGrid *lazyGrid);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBNETCDF

static struct gridVirtTable cdfLazyGridVtable;
double *cdfPendingLoad;
#ifdef HAVE_LIBPTHREAD
static pthread_once_t cdfLazyInitialized = PTHREAD_ONCE_INIT;
#else
static bool cdfLazyInitialized;
#endif

#ifdef HAVE_LIBPTHREAD
#define lock_lazy_load(plGrid) pthread_mutex_lock(&((plGrid)->loadSerialize))
#define unlock_lazy_load(plGrid) pthread_mutex_unlock(&((plGrid)->loadSerialize))
#define destroy_lazy_load_lock(plGrid) pthread_mutex_destroy(&((plGrid)->loadSerialize))
#define init_lazy_load_lock(plGrid) pthread_mutex_init(&((plGrid)->loadSerialize), NULL)
#else
#define lock_lazy_load(plGrid)
#define unlock_lazy_load(plGrid)
#define destroy_lazy_load_lock(plGrid)
#define init_lazy_load_lock(plGrid)
#endif

void
cdfLazyGridDestroy(struct cdfLazyGrid *lazyGrid)
{
  lazyGrid->base.extraData = NULL;
  if (lazyGrid->base.area == cdfPendingLoad) lazyGrid->base.area = NULL;
  if (lazyGrid->base.x.vals == cdfPendingLoad) lazyGrid->base.x.vals = NULL;
  if (lazyGrid->base.y.vals == cdfPendingLoad) lazyGrid->base.y.vals = NULL;
  if (lazyGrid->base.x.bounds == cdfPendingLoad) lazyGrid->base.x.bounds = NULL;
  if (lazyGrid->base.y.bounds == cdfPendingLoad) lazyGrid->base.y.bounds = NULL;
  destroy_lazy_load_lock(lazyGrid);
}

static void
cdfLazyGridDelete(grid_t *grid)
{
  struct cdfLazyGrid *cdfGrid = (struct cdfLazyGrid *) grid;
  void (*baseDestroy)(grid_t * grid) = cdfGrid->baseVtable->destroy;
  cdfLazyGridDestroy(cdfGrid);
  baseDestroy(grid);
}

static void
cdfLazyGridDestroyOnce(void)
{
  /*
#ifdef HAVE_MMAP
  size_t pgSize = cdiGetPageSize(false);
  munmap(cdfPendingLoad, pgSize);
#endif
  */
}

static void
cdfLazyGridDefArea(grid_t *grid, const double *area)
{
  struct cdfLazyGrid *cdfGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(cdfGrid);
  if (grid->area == cdfPendingLoad) grid->area = NULL;
  cdfGrid->cellAreaGet.datasetNCId = -1;
  cdfGrid->cellAreaGet.varNCId = -1;
  cdfGrid->baseVtable->defArea(grid, area);
  unlock_lazy_load(cdfGrid);
}

static const double *
cdfLazyGridInqAreaPtr(grid_t *grid)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  if (grid->area == cdfPendingLoad)
  {
    grid->area = (double *) Malloc(grid->size * sizeof(double));
    cdf_get_var_double(lazyGrid->cellAreaGet.datasetNCId, lazyGrid->cellAreaGet.varNCId, grid->area);
  }
  unlock_lazy_load(lazyGrid);
  return lazyGrid->baseVtable->inqAreaPtr(grid);
}

static void
cdfLazyGridInqArea(grid_t *grid, double *area)
{
  grid->vtable->inqAreaPtr(grid);
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lazyGrid->baseVtable->inqArea(grid, area);
}

static void
cdfLazyLoadXYVals(struct xyValGet *valsGet, double **valsp)
{
  double *grid_vals = (double *) Malloc(valsGet->size * sizeof(double));
  *valsp = grid_vals;
  if (valsGet->ndims == 3)
    cdf_get_vara_double(valsGet->datasetNCId, valsGet->varNCId, valsGet->start, valsGet->count, grid_vals);
  else
    cdf_get_var_double(valsGet->datasetNCId, valsGet->varNCId, grid_vals);
  cdf_scale_add(valsGet->size, grid_vals, valsGet->addoffset, valsGet->scalefactor);
}

static const double *
cdfLazyGridInqXValsPtr(grid_t *grid)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  if (grid->x.vals == cdfPendingLoad) cdfLazyLoadXYVals(&lazyGrid->xValsGet, &grid->x.vals);
  unlock_lazy_load(lazyGrid);
  return lazyGrid->baseVtable->inqXValsPtr(grid);
}

static const double *
cdfLazyGridInqYValsPtr(grid_t *grid)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  if (grid->y.vals == cdfPendingLoad) cdfLazyLoadXYVals(&lazyGrid->yValsGet, &grid->y.vals);
  unlock_lazy_load(lazyGrid);
  return lazyGrid->baseVtable->inqYValsPtr(grid);
}

static double
cdfLazyGridInqXYVal(grid_t *grid, size_t index, const struct xyValGet *valsGet, double *vals,
                    const double *(*inqValsPtr)(grid_t *gridptr))
{
  size_t size = valsGet->size;
  double v;
  if (vals == cdfPendingLoad)
  {
    // prevent full load if only first/last values get inspected
    if (index == 0 || index == size - 1)
    {
      size_t indexND[3];
      if (valsGet->ndims == 3)
      {
        indexND[0] = 0;
        indexND[1] = index / valsGet->count[2];
        indexND[2] = index % valsGet->count[2];
      }
      else if (valsGet->ndims == 2)
      {
        indexND[0] = index / grid->x.size;
        indexND[1] = index % grid->x.size;
      }
      else
        indexND[0] = index;
      cdf_get_var1_double(valsGet->datasetNCId, valsGet->varNCId, indexND, &v);
    }
    else
    {
      const double *grid_vals = inqValsPtr(grid);
      v = grid_vals[index];
    }
  }
  else if (vals)
    v = vals[index];
  else
    v = 0.0;

  return v;
}

static void
cdfLazyGridDefXVals(grid_t *grid, const double *vals)
{
  struct cdfLazyGrid *cdfGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(cdfGrid);
  if (grid->x.vals == cdfPendingLoad) grid->x.vals = NULL;
  cdfGrid->xValsGet.datasetNCId = -1;
  cdfGrid->xValsGet.varNCId = -1;
  cdfGrid->baseVtable->defXVals(grid, vals);
  unlock_lazy_load(cdfGrid);
}

static void
cdfLazyGridDefYVals(grid_t *grid, const double *vals)
{
  struct cdfLazyGrid *cdfGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(cdfGrid);
  if (grid->y.vals == cdfPendingLoad) grid->y.vals = NULL;
  cdfGrid->yValsGet.datasetNCId = -1;
  cdfGrid->yValsGet.varNCId = -1;
  cdfGrid->baseVtable->defYVals(grid, vals);
  unlock_lazy_load(cdfGrid);
}

static double
cdfLazyGridInqXVal(grid_t *grid, SizeType index)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  double rv = cdfLazyGridInqXYVal(grid, (size_t) index, &lazyGrid->xValsGet, grid->x.vals, grid->vtable->inqXValsPtr);
  unlock_lazy_load(lazyGrid);
  return rv;
}

static double
cdfLazyGridInqYVal(grid_t *grid, SizeType index)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  double rv = cdfLazyGridInqXYVal(grid, (size_t) index, &lazyGrid->yValsGet, grid->y.vals, grid->vtable->inqYValsPtr);
  unlock_lazy_load(lazyGrid);
  return rv;
}

static bool
cdfLazyXYValGetCompare(struct cdfLazyGrid *lazyGridRef, struct cdfLazyGrid *lazyGridTest)
{
  struct xyValGet *valsGetXRef = &lazyGridRef->xValsGet, *valsGetYRef = &lazyGridRef->yValsGet,
                  *valsGetXTest = &lazyGridTest->xValsGet, *valsGetYTest = &lazyGridTest->yValsGet;
  if (valsGetXRef->datasetNCId == -1 || valsGetXTest->datasetNCId == -1 || valsGetYRef->datasetNCId == -1
      || valsGetYTest->datasetNCId == -1)
    return lazyGridRef->baseVtable->compareXYFull(&lazyGridRef->base, &lazyGridTest->base);

  return valsGetXRef->datasetNCId != valsGetXTest->datasetNCId || valsGetXRef->varNCId != valsGetXTest->varNCId
         || valsGetYRef->datasetNCId != valsGetYTest->datasetNCId || valsGetYRef->varNCId != valsGetYTest->varNCId;
}

static bool
cdfLazyCompareXYFull(grid_t *gridRef, grid_t *gridTest)
{
  bool diff;
  struct cdfLazyGrid *lazyGridRef = (struct cdfLazyGrid *) gridRef;
  if (gridTest->vtable == &cdfLazyGridVtable)
    diff = cdfLazyXYValGetCompare(lazyGridRef, (struct cdfLazyGrid *) gridTest);
  else
    diff = lazyGridRef->baseVtable->compareXYFull(gridRef, gridTest);
  return diff;
}

static bool
cdfLazyCompareXYAO(grid_t *gridRef, grid_t *gridTest)
{
  bool diff;
  struct cdfLazyGrid *lazyGridRef = (struct cdfLazyGrid *) gridRef;
  if (gridTest->vtable == &cdfLazyGridVtable)
    diff = cdfLazyXYValGetCompare(lazyGridRef, (struct cdfLazyGrid *) gridTest);
  else
    diff = lazyGridRef->baseVtable->compareXYAO(gridRef, gridTest);
  return diff;
}

static const double *
cdfLazyGridInqXBoundsPtr(grid_t *grid)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  if (grid->x.bounds == cdfPendingLoad)
  {
    grid->x.bounds = (double *) Malloc((size_t) grid->nvertex * grid->size * sizeof(double));
    cdf_get_var_double(lazyGrid->xBoundsGet.datasetNCId, lazyGrid->xBoundsGet.varNCId, grid->x.bounds);
  }
  unlock_lazy_load(lazyGrid);
  return lazyGrid->baseVtable->inqXBoundsPtr(grid);
}

static void
cdfLazyGridDefXBounds(grid_t *grid, const double *xbounds)
{
  struct cdfLazyGrid *cdfGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(cdfGrid);
  if (grid->x.bounds == cdfPendingLoad) grid->x.bounds = NULL;
  cdfGrid->xBoundsGet.datasetNCId = -1;
  cdfGrid->xBoundsGet.varNCId = -1;
  cdfGrid->baseVtable->defXBounds(grid, xbounds);
  unlock_lazy_load(cdfGrid);
}

static void
cdfLazyGridDefYBounds(grid_t *grid, const double *ybounds)
{
  struct cdfLazyGrid *cdfGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(cdfGrid);
  if (grid->y.bounds == cdfPendingLoad) grid->y.bounds = NULL;
  cdfGrid->yBoundsGet.datasetNCId = -1;
  cdfGrid->yBoundsGet.varNCId = -1;
  cdfGrid->baseVtable->defYBounds(grid, ybounds);
  unlock_lazy_load(cdfGrid);
}

static const double *
cdfLazyGridInqYBoundsPtr(grid_t *grid)
{
  struct cdfLazyGrid *lazyGrid = (struct cdfLazyGrid *) grid;
  lock_lazy_load(lazyGrid);
  if (grid->y.bounds == cdfPendingLoad)
  {
    grid->y.bounds = (double *) Malloc((size_t) grid->nvertex * grid->size * sizeof(double));
    cdf_get_var_double(lazyGrid->yBoundsGet.datasetNCId, lazyGrid->yBoundsGet.varNCId, grid->y.bounds);
  }
  unlock_lazy_load(lazyGrid);
  return lazyGrid->baseVtable->inqYBoundsPtr(grid);
}

static void
cdfLazyGridCopyScalarFields(grid_t *gridptrOrig, grid_t *gridptrDup)
{
  struct cdfLazyGrid *lazyGridDup = (struct cdfLazyGrid *) gridptrDup, *lazyGridOrig = (struct cdfLazyGrid *) gridptrOrig;
  lazyGridOrig->baseVtable->copyScalarFields(gridptrOrig, &lazyGridDup->base);
  lazyGridDup->baseVtable = lazyGridOrig->baseVtable;
  lazyGridDup->cellAreaGet = lazyGridOrig->cellAreaGet;
  lazyGridDup->xBoundsGet = lazyGridOrig->xBoundsGet;
  lazyGridDup->yBoundsGet = lazyGridOrig->yBoundsGet;
  lazyGridDup->xValsGet = lazyGridOrig->xValsGet;
  lazyGridDup->yValsGet = lazyGridOrig->yValsGet;
  init_lazy_load_lock(lazyGridDup);
}

static void
cdfLazyGridCopyArrayFields(grid_t *gridptrOrig, grid_t *gridptrDup)
{
  size_t reducedPointsSize = (size_t) gridptrOrig->reducedPointsSize;
  size_t gridsize = gridptrOrig->size;
  int gridtype = gridptrOrig->type;
  int irregular = (gridtype == GRID_CURVILINEAR || gridtype == GRID_UNSTRUCTURED);

  if (reducedPointsSize)
  {
    gridptrDup->reducedPoints = (int *) Malloc(reducedPointsSize * sizeof(int));
    memcpy(gridptrDup->reducedPoints, gridptrOrig->reducedPoints, reducedPointsSize * sizeof(int));
  }

  if (gridptrOrig->x.vals != NULL && gridptrOrig->x.vals != cdfPendingLoad)
  {
    size_t size = irregular ? gridsize : gridptrOrig->x.size;
    gridptrDup->x.vals = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->x.vals, gridptrOrig->x.vals, size * sizeof(double));
  }

  if (gridptrOrig->y.vals != NULL && gridptrOrig->y.vals != cdfPendingLoad)
  {
    size_t size = irregular ? gridsize : gridptrOrig->y.size;
    gridptrDup->y.vals = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->y.vals, gridptrOrig->y.vals, size * sizeof(double));
  }

  if (gridptrOrig->x.bounds != NULL && gridptrOrig->x.bounds != cdfPendingLoad)
  {
    size_t size = (irregular ? gridsize : gridptrOrig->x.size) * (size_t) gridptrOrig->nvertex;
    gridptrDup->x.bounds = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->x.bounds, gridptrOrig->x.bounds, size * sizeof(double));
  }

  if (gridptrOrig->y.bounds != NULL && gridptrOrig->y.bounds != cdfPendingLoad)
  {
    size_t size = (irregular ? gridsize : gridptrOrig->y.size) * (size_t) gridptrOrig->nvertex;
    gridptrDup->y.bounds = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->y.bounds, gridptrOrig->y.bounds, size * sizeof(double));
  }

  {
    if (gridptrOrig->area != NULL && gridptrOrig->area != cdfPendingLoad)
    {
      size_t size = gridsize;
      gridptrDup->area = (double *) Malloc(size * sizeof(double));
      memcpy(gridptrDup->area, gridptrOrig->area, size * sizeof(double));
    }
  }

  if (gridptrOrig->mask != NULL)
  {
    size_t size = gridsize;
    gridptrDup->mask = (mask_t *) Malloc(size * sizeof(mask_t));
    memcpy(gridptrDup->mask, gridptrOrig->mask, size * sizeof(mask_t));
  }

  if (gridptrOrig->mask_gme != NULL)
  {
    size_t size = gridsize;
    gridptrDup->mask_gme = (mask_t *) Malloc(size * sizeof(mask_t));
    memcpy(gridptrDup->mask_gme, gridptrOrig->mask_gme, size * sizeof(mask_t));
  }
}

static grid_t *
cdfLazyGridCopy(grid_t *gridptrOrig)
{
  struct cdfLazyGrid *lazyGridDup = (struct cdfLazyGrid *) Malloc(sizeof(*lazyGridDup));
  gridptrOrig->vtable->copyScalarFields(gridptrOrig, &lazyGridDup->base);
  gridptrOrig->vtable->copyArrayFields(gridptrOrig, &lazyGridDup->base);
  return &lazyGridDup->base;
}

static void
cdfLazyGridInitOnce(void)
{
  cdfLazyGridVtable = cdiGridVtable;
  cdfLazyGridVtable.destroy = cdfLazyGridDelete;
  cdfLazyGridVtable.copy = cdfLazyGridCopy;
  cdfLazyGridVtable.copyScalarFields = cdfLazyGridCopyScalarFields;
  cdfLazyGridVtable.copyArrayFields = cdfLazyGridCopyArrayFields;
  cdfLazyGridVtable.defArea = cdfLazyGridDefArea;
  cdfLazyGridVtable.inqAreaPtr = cdfLazyGridInqAreaPtr;
  cdfLazyGridVtable.inqArea = cdfLazyGridInqArea;
  cdfLazyGridVtable.inqXValsPtr = cdfLazyGridInqXValsPtr;
  cdfLazyGridVtable.inqYValsPtr = cdfLazyGridInqYValsPtr;
  cdfLazyGridVtable.inqXVal = cdfLazyGridInqXVal;
  cdfLazyGridVtable.inqYVal = cdfLazyGridInqYVal;
  cdfLazyGridVtable.defXVals = cdfLazyGridDefXVals;
  cdfLazyGridVtable.defYVals = cdfLazyGridDefYVals;
  cdfLazyGridVtable.compareXYFull = cdfLazyCompareXYFull;
  cdfLazyGridVtable.compareXYAO = cdfLazyCompareXYAO;
  cdfLazyGridVtable.defXBounds = cdfLazyGridDefXBounds;
  cdfLazyGridVtable.defYBounds = cdfLazyGridDefYBounds;
  cdfLazyGridVtable.inqXBoundsPtr = cdfLazyGridInqXBoundsPtr;
  cdfLazyGridVtable.inqYBoundsPtr = cdfLazyGridInqYBoundsPtr;
  /* create inaccessible memory area, if possible, this serves as
   * dummy value for pointers to data not yet loaded */
  /*
#ifdef HAVE_MMAP
  {
    size_t pgSize = cdiGetPageSize(false);
    static const char devZero[] = "/dev/zero";
    int fd = open(devZero, O_RDWR);
    if (fd == -1)
      SysError("Could not open %s to map anonymous memory", devZero);
    void *cdfInvalid = mmap(NULL, pgSize, PROT_NONE, MAP_PRIVATE, fd, 0);
    if (cdfInvalid == MAP_FAILED)
      SysError("Could not mmap anonymous memory");
    cdfPendingLoad = cdfInvalid;
    int rc = close(fd);
    if (rc == -1)
      SysError("Could not close %s file handle %d after mapping anonymous"
               " memory", devZero, fd);
  }
#else
  */
  cdfPendingLoad = (double *) &cdfPendingLoad;
  // #endif
  atexit(cdfLazyGridDestroyOnce);
#ifndef HAVE_LIBPTHREAD
  cdfLazyInitialized = true;
#endif
}

static void
cdfBaseGridInit(grid_t *grid, int gridtype)
{
  grid_init(grid);
  cdiGridTypeInit(grid, gridtype, 0);
}

static void
cdfLazyGridInit(struct cdfLazyGrid *grid, int gridtype)
{
#ifdef HAVE_LIBPTHREAD
  pthread_once(&cdfLazyInitialized, cdfLazyGridInitOnce);
#else
  if (!cdfLazyInitialized) cdfLazyGridInitOnce();
#endif
  cdfBaseGridInit(&grid->base, gridtype);
  grid->baseVtable = grid->base.vtable;
  grid->cellAreaGet.datasetNCId = -1;
  grid->cellAreaGet.varNCId = -1;
  grid->xValsGet.datasetNCId = -1;
  grid->xValsGet.varNCId = -1;
  grid->yValsGet.datasetNCId = -1;
  grid->yValsGet.varNCId = -1;
  grid->xBoundsGet.datasetNCId = -1;
  grid->xBoundsGet.varNCId = -1;
  grid->yBoundsGet.datasetNCId = -1;
  grid->yBoundsGet.varNCId = -1;
  grid->base.vtable = &cdfLazyGridVtable;
  init_lazy_load_lock(grid);
}

void
cdfLazyGridRenew(struct cdfLazyGrid *restrict *restrict gridpptr, int gridtype)
{
  struct cdfLazyGrid *restrict grid = *gridpptr;
  if (!grid) *gridpptr = grid = (struct cdfLazyGrid *) Malloc(sizeof(*grid));
  cdfLazyGridInit(grid, gridtype);
}

void
cdfBaseGridRenew(struct cdfLazyGrid *restrict *restrict gridpptr, int gridtype)
{
  struct cdfLazyGrid *restrict grid = *gridpptr;
  if (!grid) *gridpptr = grid = (struct cdfLazyGrid *) Malloc(sizeof(grid_t));
  cdfBaseGridInit((grid_t *) grid, gridtype);
}

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDI_CKSUM_H_
#define CDI_CKSUM_H_

#include <inttypes.h>

/* single checksum computation over one array */
uint32_t cdiCheckSum(int type, int count, const void *data);

/* composable check-sum computation,
 * 0. datatype,
 * 1. init,
 * 2. partial, appendable computation, and
 * 3. final checksum-computation
 */
struct cdiCheckSumState
{
  uint32_t sum;
  off_t len;
};

void cdiCheckSumRStart(struct cdiCheckSumState *state);
void cdiCheckSumRAdd(struct cdiCheckSumState *state, int type, int count, const void *data);
uint32_t cdiCheckSumRValue(struct cdiCheckSumState state);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#include <inttypes.h>
#include <sys/types.h>

void memcrc_r(uint32_t *state, const unsigned char *block, size_t block_len);

void memcrc_r_eswap(uint32_t *state, const unsigned char *elems, size_t num_elems, size_t elem_size);

uint32_t memcrc_finish(uint32_t *state, off_t total_size);

uint32_t memcrc(const unsigned char *b, size_t n);

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#ifndef SERIALIZE_H
#define SERIALIZE_H

#include <string.h>

#ifndef CDI_CKSUM_H_
#endif
#ifndef CDI_KEY_H_
#endif
#ifndef ERROR_H
#endif

/*
 * Generic interfaces for (de-)marshalling
 */
int serializeGetSize(int count, int datatype, void *context);
void serializePack(const void *data, int count, int datatype, void *buf, int buf_size, int *position, void *context);
void serializeUnpack(const void *buf, int buf_size, int *position, void *data, int count, int datatype, void *context);

/*
 * (de-)marshalling function for key/value structures
 */
static inline int
serializeKeysGetPackSize(const cdi_keys_t *keysp, void *context)
{
  int packBuffSize = 0;

  int nelems = (int) keysp->nelems;
  packBuffSize += serializeGetSize(1, CDI_DATATYPE_INT, context);
  for (int keyid = 0; keyid < nelems; keyid++)
  {
    const cdi_key_t *keyp = &(keysp->value[keyid]);
    int type = keyp->type;
    packBuffSize += serializeGetSize(1, CDI_DATATYPE_INT, context);  // key
    packBuffSize += serializeGetSize(1, CDI_DATATYPE_INT, context);  // type
    if (type == KeyBytes)
    {
      int length = keyp->length;
      packBuffSize += serializeGetSize(1, CDI_DATATYPE_INT, context) + serializeGetSize(length, CDI_DATATYPE_TXT, context);
    }
    else if (type == KeyInt) { packBuffSize += serializeGetSize(1, CDI_DATATYPE_INT, context); }
    else if (type == KeyFloat) { packBuffSize += serializeGetSize(1, CDI_DATATYPE_FLT64, context); }
  }
  packBuffSize += serializeGetSize(1, CDI_DATATYPE_UINT32, context);
  return packBuffSize;
}

static inline void
serializeKeysPack(const cdi_keys_t *keysp, void *buf, int buf_size, int *position, void *context)
{
  uint32_t d = 0;

  int nelems = (int) keysp->nelems;
  serializePack(&nelems, 1, CDI_DATATYPE_INT, buf, buf_size, position, context);
  for (int keyid = 0; keyid < nelems; keyid++)
  {
    const cdi_key_t *keyp = &(keysp->value[keyid]);
    int key = keyp->key;
    int type = keyp->type;
    serializePack(&key, 1, CDI_DATATYPE_INT, buf, buf_size, position, context);
    serializePack(&type, 1, CDI_DATATYPE_INT, buf, buf_size, position, context);
    if (type == KeyBytes)
    {
      int length = keyp->length;
      serializePack(&length, 1, CDI_DATATYPE_INT, buf, buf_size, position, context);
      serializePack(keyp->v.s, length, CDI_DATATYPE_TXT, buf, buf_size, position, context);
      d ^= cdiCheckSum(CDI_DATATYPE_TXT, length, keyp->v.s);
    }
    else if (type == KeyInt) { serializePack(&keyp->v.i, 1, CDI_DATATYPE_INT, buf, buf_size, position, context); }
    else if (type == KeyFloat) { serializePack(&keyp->v.d, 1, CDI_DATATYPE_FLT64, buf, buf_size, position, context); }
  }

  serializePack(&d, 1, CDI_DATATYPE_UINT32, buf, buf_size, position, context);
}

static inline void
serializeKeysUnpack(const void *buf, int buf_size, int *position, cdi_keys_t *keysp, void *context)
{
  uint32_t d, d2 = 0;
  void *buffer = NULL;
  int buffersize = 0;

  int nelems;
  serializeUnpack(buf, buf_size, position, &nelems, 1, CDI_DATATYPE_INT, context);
  for (int i = 0; i < nelems; ++i)
  {
    int key, type;
    serializeUnpack(buf, buf_size, position, &key, 1, CDI_DATATYPE_INT, context);
    serializeUnpack(buf, buf_size, position, &type, 1, CDI_DATATYPE_INT, context);
    if (type == KeyBytes)
    {
      int length;
      serializeUnpack(buf, buf_size, position, &length, 1, CDI_DATATYPE_INT, context);
      if (length > buffersize)
      {
        buffersize = length;
        buffer = Realloc(buffer, (size_t) buffersize);
      }
      serializeUnpack(buf, buf_size, position, buffer, length, CDI_DATATYPE_TXT, context);
      cdiDefVarKeyBytes(keysp, key, (unsigned char *) buffer, length);
      d2 ^= cdiCheckSum(CDI_DATATYPE_TXT, length, buffer);
    }
    else if (type == KeyInt)
    {
      int ival;
      serializeUnpack(buf, buf_size, position, &ival, 1, CDI_DATATYPE_INT, context);
      cdiDefVarKeyInt(keysp, key, ival);
    }
    else if (type == KeyFloat)
    {
      double dval;
      serializeUnpack(buf, buf_size, position, &dval, 1, CDI_DATATYPE_FLT64, context);
      cdiDefVarKeyFloat(keysp, key, dval);
    }
  }
  serializeUnpack(buf, buf_size, position, &d, 1, CDI_DATATYPE_UINT32, context);
  xassert(d == d2);
  if (buffer) Free(buffer);
}

/*
 * (de-)marshalling function for common data structures
 */
static inline int
serializeStrTabGetPackSize(const char **strTab, int numStr, void *context)
{
  xassert(numStr >= 0);
  int packBuffSize = 0;
  for (size_t i = 0; i < (size_t) numStr; ++i)
  {
    size_t len = strlen(strTab[i]);
    packBuffSize += serializeGetSize(1, CDI_DATATYPE_INT, context) + serializeGetSize((int) len, CDI_DATATYPE_TXT, context);
  }
  packBuffSize += serializeGetSize(1, CDI_DATATYPE_UINT32, context);
  return packBuffSize;
}

static inline void
serializeStrTabPack(const char **strTab, int numStr, void *buf, int buf_size, int *position, void *context)
{
  uint32_t d = 0;
  xassert(numStr >= 0);
  for (size_t i = 0; i < (size_t) numStr; ++i)
  {
    int len = (int) strlen(strTab[i]);
    serializePack(&len, 1, CDI_DATATYPE_INT, buf, buf_size, position, context);
    serializePack(strTab[i], len, CDI_DATATYPE_TXT, buf, buf_size, position, context);
    d ^= cdiCheckSum(CDI_DATATYPE_TXT, len, strTab[i]);
  }
  serializePack(&d, 1, CDI_DATATYPE_UINT32, buf, buf_size, position, context);
}

static inline void
serializeStrTabUnpack(const void *buf, int buf_size, int *position, char **strTab, int numStr, void *context)
{
  uint32_t d, d2 = 0;
  xassert(numStr >= 0);
  for (size_t i = 0; i < (size_t) numStr; ++i)
  {
    int len;
    serializeUnpack(buf, buf_size, position, &len, 1, CDI_DATATYPE_INT, context);
    serializeUnpack(buf, buf_size, position, strTab[i], len, CDI_DATATYPE_TXT, context);
    strTab[i][len] = '\0';
    d2 ^= cdiCheckSum(CDI_DATATYPE_TXT, len, strTab[i]);
  }
  serializeUnpack(buf, buf_size, position, &d, 1, CDI_DATATYPE_UINT32, context);
  xassert(d == d2);
}

/*
 * Interfaces for marshalling within a single memory domain
 */
int serializeGetSizeInCore(int count, int datatype, void *context);
void serializePackInCore(const void *data, int count, int datatype, void *buf, int buf_size, int *position, void *context);
void serializeUnpackInCore(const void *buf, int buf_size, int *position, void *data, int count, int datatype, void *context);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <inttypes.h>
#include <sys/types.h>
#include <stdlib.h>


uint32_t
cdiCheckSum(int type, int count, const void *buffer)
{
  uint32_t s = 0U;
  xassert(count >= 0);
  size_t elemSize = (size_t) serializeGetSizeInCore(1, type, NULL);
  memcrc_r_eswap(&s, (const unsigned char *) buffer, (size_t) count, elemSize);
  s = memcrc_finish(&s, (off_t) (elemSize * (size_t) count));
  return s;
}

void
cdiCheckSumRStart(struct cdiCheckSumState *state)
{
  state->sum = 0U;
  state->len = 0;
}

void
cdiCheckSumRAdd(struct cdiCheckSumState *state, int type, int count, const void *buffer)
{
  size_t elemSize = (size_t) serializeGetSizeInCore(1, type, NULL);
  memcrc_r_eswap(&state->sum, (const unsigned char *) buffer, (size_t) count, elemSize);
  state->len += (off_t) (elemSize * (size_t) count);
}

uint32_t
cdiCheckSumRValue(struct cdiCheckSumState state)
{
  return memcrc_finish(&state.sum, state.len);
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stdio.h>
#include <string.h>
#include <errno.h>

const char *
cdiStringError(int cdiErrno)
{
  // clang-format off
  static const char UnknownError[] = "Unknown Error";
  static const char _ETMOF[]       = "Too many open files";
  static const char _EINVAL[]      = "Invalid argument";
  static const char _EISDIR[]      = "Is a directory";
  static const char _EISEMPTY[]    = "File is empty";
  static const char _EUFTYPE[]     = "Unsupported file type";
  static const char _ELIBNAVAIL[]  = "Unsupported file type (library support not compiled in)";
  static const char _EUFSTRUCT[]   = "Unsupported file structure";
  static const char _EUNC4[]       = "Unsupported NetCDF4 structure";
  static const char _EDIMSIZE[]    = "Invalid dimension size";
  static const char _EQENF[]       = "Query entries not found";
  static const char _EQNAVAIL[]    = "Query not available for file type";
  static const char _ELIMIT[]      = "Internal limits exceeded";

  if (cdiErrno < -1000)
    {
      const char *cdfErrorString = cdf_strerror(cdiErrno + 1000);
      if (cdfErrorString) return cdfErrorString;
    }

  switch (cdiErrno) {
  case CDI_ESYSTEM:
    {
      const char *cp = strerror(errno);
      if (cp == NULL) break;
      return cp;
    }
  case CDI_ETMOF:      return _ETMOF;
  case CDI_EINVAL:     return _EINVAL;
  case CDI_EISDIR:     return _EISDIR;
  case CDI_EISEMPTY:   return _EISEMPTY;
  case CDI_EUFTYPE:    return _EUFTYPE;
  case CDI_ELIBNAVAIL: return _ELIBNAVAIL;
  case CDI_EUFSTRUCT:  return _EUFSTRUCT;
  case CDI_EUNC4:      return _EUNC4;
  case CDI_EDIMSIZE:   return _EDIMSIZE;
  case CDI_EQENF:      return _EQENF;
  case CDI_EQNAVAIL:   return _EQNAVAIL;
  case CDI_ELIMIT:     return _ELIMIT;
  }
  // clang-format on
  return UnknownError;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stdio.h>
#include <stdlib.h>

// ==================================================================
#ifdef __cplusplus
extern "C"
{
#endif

  // clang-format off
void
cdiDecodeDate(int date, int *year, int *month, int *day)
{
  int iyear = date / 10000;
  *year = iyear;
  int idate = date - iyear * 10000;
  if (idate < 0) idate = -idate;
  int imonth = idate / 100;
  *month = imonth;
  *day = idate - imonth * 100;
}

int
cdiEncodeDate(int year, int month, int day)
{
  int iyear = abs(year);
  int date = iyear * 10000 + month * 100 + day;
  if (year < 0) date = -date;

  return date;
}

void
cdiDecodeTime(int time, int *hour, int *minute, int *second)
{
  int ihour = time / 10000, itime = time - ihour * 10000, iminute = itime / 100;
  *hour = ihour;
  *minute = iminute;
  *second = itime - iminute * 100;
}

int
cdiEncodeTime(int hour, int minute, int second)
{
  return hour * 10000 + minute * 100 + second;
}
  // clang-format on

#ifdef __cplusplus
}
#endif
// ==================================================================

CdiDate
cdiDate_set(int64_t date)
{
  int64_t iyear = date / 10000;
  int year = (int) iyear;
  int64_t idate = date - iyear * 10000;
  if (idate < 0) idate = -idate;
  int64_t imonth = idate / 100;
  int month = (int) imonth;
  int day = (int) (idate - imonth * 100);

  CdiDate cdiDate;
  cdiDate.year = year;
  cdiDate.month = (short) month;
  cdiDate.day = (short) day;

  return cdiDate;
}

CdiTime
cdiTime_set(int time)
{
  int hour, minute, second, ms = 0;
  cdiDecodeTime(time, &hour, &minute, &second);

  CdiTime cdiTime;
  cdiTime.hour = (short) hour;
  cdiTime.minute = (short) minute;
  cdiTime.second = (short) second;
  cdiTime.ms = (short) ms;

  return cdiTime;
}

CdiDateTime
cdiDateTime_set(int64_t date, int time)
{
  CdiDateTime cdiDateTime;
  cdiDateTime.date = cdiDate_set(date);
  cdiDateTime.time = cdiTime_set(time);

  return cdiDateTime;
}

int64_t
cdiDate_get(CdiDate cdiDate)
{
  int64_t iyear = abs(cdiDate.year);
  int64_t date = iyear * 10000 + cdiDate.month * 100 + cdiDate.day;
  if (cdiDate.year < 0) date = -date;

  return date;
}

int
cdiTime_get(CdiTime cdiTime)
{
  return cdiEncodeTime(cdiTime.hour, cdiTime.minute, cdiTime.second);
}

CdiDate
cdiDate_encode(int year, int month, int day)
{
  CdiDate cdiDate;
  cdiDate.year = year;
  cdiDate.month = (short) month;
  cdiDate.day = (short) day;

  return cdiDate;
}

void
cdiDate_decode(CdiDate cdiDate, int *year, int *month, int *day)
{
  *year = cdiDate.year;
  *month = cdiDate.month;
  *day = cdiDate.day;
}

CdiTime
cdiTime_encode(int hour, int minute, int second, int ms)
{
  CdiTime cdiTime;
  cdiTime.hour = (short) hour;
  cdiTime.minute = (short) minute;
  cdiTime.second = (short) second;
  cdiTime.ms = (short) ms;

  return cdiTime;
}

void
cdiTime_decode(CdiTime cdiTime, int *hour, int *minute, int *second, int *ms)
{
  *hour = cdiTime.hour;
  *minute = cdiTime.minute;
  *second = cdiTime.second;
  *ms = cdiTime.ms;
}

void
cdiDate_init(CdiDate *cdiDate)
{
  cdiDate->year = 0;
  cdiDate->month = 0;
  cdiDate->day = 0;
}

void
cdiTime_init(CdiTime *cdiTime)
{
  cdiTime->hour = 0;
  cdiTime->minute = 0;
  cdiTime->second = 0;
  cdiTime->ms = 0;
}

void
cdiDateTime_init(CdiDateTime *cdiDateTime)
{
  cdiDate_init(&cdiDateTime->date);
  cdiTime_init(&cdiDateTime->time);
}

bool
cdiDate_isEQ(CdiDate cdiDate1, CdiDate cdiDate2)
{
  // clang-format off
  return (cdiDate1.year  == cdiDate2.year
       && cdiDate1.month == cdiDate2.month
       && cdiDate1.day   == cdiDate2.day);
  // clang-format on
}

bool
cdiTime_isEQ(CdiTime cdiTime1, CdiTime cdiTime2)
{
  // clang-format off
  return (cdiTime1.hour   == cdiTime2.hour
       && cdiTime1.minute == cdiTime2.minute
       && cdiTime1.second == cdiTime2.second
       && cdiTime1.ms     == cdiTime2.ms);
  // clang-format on
}

bool
cdiDateTime_isEQ(CdiDateTime cdiDateTime1, CdiDateTime cdiDateTime2)
{
  // clang-format off
  return (cdiDateTime1.date.year   == cdiDateTime2.date.year
       && cdiDateTime1.date.month  == cdiDateTime2.date.month
       && cdiDateTime1.date.day    == cdiDateTime2.date.day
       && cdiDateTime1.time.hour   == cdiDateTime2.time.hour
       && cdiDateTime1.time.minute == cdiDateTime2.time.minute
       && cdiDateTime1.time.second == cdiDateTime2.time.second
       && cdiDateTime1.time.ms     == cdiDateTime2.time.ms);
  // clang-format on
}

bool
cdiDateTime_isNE(CdiDateTime cdiDateTime1, CdiDateTime cdiDateTime2)
{
  return !cdiDateTime_isEQ(cdiDateTime1, cdiDateTime2);
}

bool
cdiDateTime_isLT(CdiDateTime cdiDateTime1, CdiDateTime cdiDateTime2)
{
  int64_t date1 = cdiDate_get(cdiDateTime1.date);
  int64_t date2 = cdiDate_get(cdiDateTime2.date);
  int time1 = cdiTime_get(cdiDateTime1.time);
  int time2 = cdiTime_get(cdiDateTime2.time);
  return (date1 < date2 || (date1 == date2 && time1 < time2));
}

bool
cdiDateTime_isNull(CdiDateTime cdiDateTime)
{
  // clang-format off
  return (cdiDateTime.date.year == 0
       && cdiDateTime.date.month == 0
       && cdiDateTime.date.day == 0
       && cdiDateTime.time.hour == 0
       && cdiDateTime.time.minute == 0
       && cdiDateTime.time.second == 0
       && cdiDateTime.time.ms == 0);
  // clang-format on
}

#define DATE_FORMAT "%5.4d-%2.2d-%2.2d"
#define TIME_FORMAT "%2.2d:%2.2d:%2.2d"

const char *
CdiDateTime_string(CdiDateTime cdiDateTime)
{
  int year, month, day;
  cdiDate_decode(cdiDateTime.date, &year, &month, &day);
  int hour, minute, second, ms;
  cdiTime_decode(cdiDateTime.time, &hour, &minute, &second, &ms);

  static char datetimeString[64];
  snprintf(datetimeString, sizeof(datetimeString), DATE_FORMAT "T" TIME_FORMAT, year, month, day, hour, minute, second);

  return datetimeString;
}
#ifndef GRIBAPI_H
#define GRIBAPI_H

#ifdef HAVE_LIBGRIB_API
#include <grib_api.h>
#ifndef ERROR_H
#endif
#endif

#ifndef CDI_INT_H
#endif

// clang-format off

#define  GRIBAPI_MISSVAL  -9.E33

// GRIB2 Level Types
#define  GRIB2_LTYPE_SURFACE               1
#define  GRIB2_LTYPE_CLOUD_BASE            2
#define  GRIB2_LTYPE_CLOUD_TOP             3
#define  GRIB2_LTYPE_ISOTHERM0             4
#define  GRIB2_LTYPE_TROPOPAUSE            7
#define  GRIB2_LTYPE_TOA                   8
#define  GRIB2_LTYPE_SEA_BOTTOM            9
#define  GRIB2_LTYPE_ATMOSPHERE           10
#define  GRIB2_LTYPE_ISOBARIC            100
#define  GRIB2_LTYPE_MEANSEA             101
#define  GRIB2_LTYPE_ALTITUDE            102
#define  GRIB2_LTYPE_HEIGHT              103
#define  GRIB2_LTYPE_SIGMA               104
#define  GRIB2_LTYPE_HYBRID              105
#define  GRIB2_LTYPE_LANDDEPTH           106
#define  GRIB2_LTYPE_ISENTROPIC          107
#define  GRIB2_LTYPE_SNOW                114
#define  GRIB2_LTYPE_REFERENCE           150
#define  GRIB2_LTYPE_SEADEPTH            160  // Depth Below Sea Level
#define  GRIB2_LTYPE_LAKE_BOTTOM         162  // Lake or River Bottom
#define  GRIB2_LTYPE_SEDIMENT_BOTTOM     163  // Bottom Of Sediment Layer
#define  GRIB2_LTYPE_SEDIMENT_BOTTOM_TA  164  // Bottom Of Thermally Active Sediment Layer
#define  GRIB2_LTYPE_SEDIMENT_BOTTOM_TW  165  // Bottom Of Sediment Layer Penetrated By Thermal Wave
#define  GRIB2_LTYPE_MIX_LAYER           166  // Mixing Layer

// GRIB2 Data representation type (Grid Type)
#define  GRIB2_GTYPE_LATLON                0  // Latitude/longitude (or equidistant cylindrical, or Plate Carree)
#define  GRIB2_GTYPE_LATLON_ROT            1  // Rotated Latitude/longitude
#define  GRIB2_GTYPE_LATLON_STR            2  // Stretched Latitude/longitude
#define  GRIB2_GTYPE_LATLON_ROTSTR         3  // Stretched and Rotated Latitude/longitude
#define  GRIB2_GTYPE_STERE                20  // Polar stereographic projection
#define  GRIB2_GTYPE_LCC                  30  // Lambert conformal
#define  GRIB2_GTYPE_LLAM                 33  // Lambert LAM
#define  GRIB2_GTYPE_GAUSSIAN             40  // Gaussian latitude/longitude
#define  GRIB2_GTYPE_GAUSSIAN_ROT         41  // Rotated Gaussian latitude/longitude
#define  GRIB2_GTYPE_GAUSSIAN_STR         42  // Stretched Gaussian latitude/longitude
#define  GRIB2_GTYPE_GAUSSIAN_ROTSTR      43  // Stretched and rotated Gaussian latitude/longitude
#define  GRIB2_GTYPE_SPECTRAL             50  // Spherical harmonic coefficients
#define  GRIB2_GTYPE_GME                 100  // Triangular grid based on an icosahedron (GME)
#define  GRIB2_GTYPE_UNSTRUCTURED        101  // General Unstructured Grid
#define  GRIB2_GTYPE_HEALPIX             150  // HEALPix Grid

const char *gribapiLibraryVersionString(void);
void gribContainersNew(stream_t *streamptr);
void gribContainersDelete(stream_t *streamptr);

#ifdef HAVE_LIBGRIB_API

#ifdef ECCODES_VERSION
#if ECCODES_VERSION >= 23000
#define HAVE_GRIBAPI_FLOAT_INTERFACE 1
#endif
#endif

static inline int have_gribapi_float_interface(void)
{
#ifdef HAVE_GRIBAPI_FLOAT_INTERFACE
  return 1;
#else
  return 0;
#endif
}

static inline int my_grib_set_double(grib_handle* h, const char* key, double val)
{
  if (CDI_gribapi_debug)
    fprintf(stderr, "grib_set_double(\tgrib_handle* h, \"%s\", %f)\n", key, val);

  int retVal = grib_set_double(h, key, val);
  if (retVal != 0)
    fprintf(stderr, "!!! failed call to grib_set_double(\tgrib_handle* h, \"%s\", %f) !!!\n", key, val);
  return retVal;
}

static inline int my_grib_set_long(grib_handle* h, const char* key, long val)
{
  if (CDI_gribapi_debug)
    fprintf(stderr, "grib_set_long(  \tgrib_handle* h, \"%s\", %ld)\n", key, val);

  int retVal = grib_set_long(h, key, val);
  if (retVal != 0)
    fprintf(stderr, "!!! failed call to grib_set_long(  \tgrib_handle* h, \"%s\", %ld) !!!\n", key, val);
  return retVal;
}

static inline int my_grib_set_string(grib_handle* h, const char* key, const char* val, size_t* length)
{
  if (CDI_gribapi_debug)
    fprintf(stderr, "grib_set_string(\tgrib_handle* h, \"%s\", \"%s\")\n", key, val);

  int ret_val = grib_set_string(h, key, val, length);
  if (ret_val != 0)
    fprintf(stderr, "!!! grib_set_string(\tgrib_handle* h, \"%s\", \"%s\") !!!\n", key, val);
  return ret_val;
}
#endif

typedef struct {
  bool init;
  void *gribHandle;
}
gribContainer_t;

// clang-format on

#endif /* GRIBAPI_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CGRIBEX_H
#define CGRIBEX_H

// clang-format off

#include <stdio.h>
#include <stdbool.h>
#include <sys/types.h>

#define  GRIB_MISSVAL  -9.E33

// GRIB1 Level Types
#define  GRIB1_LTYPE_SURFACE               1
#define  GRIB1_LTYPE_CLOUD_BASE            2
#define  GRIB1_LTYPE_CLOUD_TOP             3
#define  GRIB1_LTYPE_ISOTHERM0             4
#define  GRIB1_LTYPE_TROPOPAUSE            7
#define  GRIB1_LTYPE_TOA                   8
#define  GRIB1_LTYPE_SEA_BOTTOM            9
#define  GRIB1_LTYPE_ATMOSPHERE           10
#define  GRIB1_LTYPE_99                   99
#define  GRIB1_LTYPE_ISOBARIC            100
#define  GRIB1_LTYPE_ISOBARIC_PA         210
#define  GRIB1_LTYPE_MEANSEA             102
#define  GRIB1_LTYPE_ALTITUDE            103
#define  GRIB1_LTYPE_HEIGHT              105
#define  GRIB1_LTYPE_SIGMA               107
#define  GRIB1_LTYPE_SIGMA_LAYER         108
#define  GRIB1_LTYPE_HYBRID              109
#define  GRIB1_LTYPE_HYBRID_LAYER        110
#define  GRIB1_LTYPE_LANDDEPTH           111
#define  GRIB1_LTYPE_LANDDEPTH_LAYER     112
#define  GRIB1_LTYPE_ISENTROPIC          113
#define  GRIB1_LTYPE_SEADEPTH            160  // Depth Below Sea Level
#define  GRIB1_LTYPE_LAKE_BOTTOM         162  // Lake or River Bottom
#define  GRIB1_LTYPE_SEDIMENT_BOTTOM     163  // Bottom Of Sediment Layer
#define  GRIB1_LTYPE_SEDIMENT_BOTTOM_TA  164  // Bottom Of Thermally Active Sediment Layer
#define  GRIB1_LTYPE_SEDIMENT_BOTTOM_TW  165  // Bottom Of Sediment Layer Penetrated By Thermal Wave
#define  GRIB1_LTYPE_MIX_LAYER           166  // Mixing Layer

// GRIB1 Data representation type (Grid Type) [Table 6]
#define  GRIB1_GTYPE_LATLON                0  //  latitude/longitude
#define  GRIB1_GTYPE_LATLON_ROT           10  //  rotated latitude/longitude
#define  GRIB1_GTYPE_LATLON_STR           20  //  stretched latitude/longitude
#define  GRIB1_GTYPE_LATLON_ROTSTR        30  //  rotated and stretched latitude/longitude
#define  GRIB1_GTYPE_GAUSSIAN              4  //  gaussian grid
#define  GRIB1_GTYPE_GAUSSIAN_ROT         14  //  rotated gaussian grid
#define  GRIB1_GTYPE_GAUSSIAN_STR         24  //  stretched gaussian grid
#define  GRIB1_GTYPE_GAUSSIAN_ROTSTR      34  //  rotated and stretched gaussian grid
#define  GRIB1_GTYPE_LCC                   3  //  Lambert conformal
#define  GRIB1_GTYPE_SPECTRAL             50  //  spherical harmonics
#define  GRIB1_GTYPE_GME                 192  //  hexagonal GME grid

// Macros for the indicator section ( Section 0 )
#define  ISEC0_GRIB_Len             (isec0[ 0])  //  Number of octets in the GRIB message
#define  ISEC0_GRIB_Version         (isec0[ 1])  //  GRIB edition number


// Macros for the product definition section ( Section 1 )
#define  ISEC1_TABLE4_MINUTE      0
#define  ISEC1_TABLE4_HOUR        1
#define  ISEC1_TABLE4_DAY         2
#define  ISEC1_TABLE4_3HOURS     10
#define  ISEC1_TABLE4_6HOURS     11
#define  ISEC1_TABLE4_12HOURS    12
#define  ISEC1_TABLE4_QUARTER    13
#define  ISEC1_TABLE4_30MINUTES  14


#define  ISEC1_CodeTable            (isec1[ 0])  //  Version number of code table
#define  ISEC1_CenterID             (isec1[ 1])  //  Identification of centre
#define  ISEC1_ModelID              (isec1[ 2])  //  Identification of model
#define  ISEC1_GridDefinition       (isec1[ 3])  //  Grid definition
#define  ISEC1_Sec2Or3Flag          (isec1[ 4])  //  Section 2 or 3 included
#define  ISEC1_Parameter            (isec1[ 5])  //  Parameter indicator
#define  ISEC1_LevelType            (isec1[ 6])  //  Type of level indicator
#define  ISEC1_Level1               (isec1[ 7])  //  Level 1
#define  ISEC1_Level2               (isec1[ 8])  //  Level 2
#define  ISEC1_Year                 (isec1[ 9])  //  Year of century (YY)
#define  ISEC1_Month                (isec1[10])  //  Month (MM)
#define  ISEC1_Day                  (isec1[11])  //  Day (DD)
#define  ISEC1_Hour                 (isec1[12])  //  Hour (HH)
#define  ISEC1_Minute               (isec1[13])  //  Minute (MM)
#define  ISEC1_TimeUnit             (isec1[14])  //  Time unit indicator
#define  ISEC1_TimePeriod1          (isec1[15])  //  P1 Time period
#define  ISEC1_TimePeriod2          (isec1[16])  //  P2 Time period
#define  ISEC1_TimeRange            (isec1[17])  //  Time range indicator
#define  ISEC1_AvgNum               (isec1[18])  //  Number of products included in an average
#define  ISEC1_AvgMiss              (isec1[19])  //  Number of products missing from an average
#define  ISEC1_Century              (isec1[20])  //  Century
#define  ISEC1_SubCenterID          (isec1[21])  //  Subcenter identifier
#define  ISEC1_DecScaleFactor       (isec1[22])  //  Decimal scale factor
#define  ISEC1_LocalFLag            (isec1[23])  //  Flag field to indicate local use in isec1

#define  ISEC1_ECMWF_LocalExtension (isec1[36])
#define  ISEC1_ECMWF_Class          (isec1[37])


// Macros for the grid definition section ( Section 2 )
#define  ISEC2_GridType             (isec2[ 0])  // Data representation type

// Triangular grids

#define  ISEC2_GME_NI2              (isec2[ 1])  //  Number of factor 2 in factorisation of Ni
#define  ISEC2_GME_NI3              (isec2[ 2])  //  Number of factor 3 in factorisation of Ni
#define  ISEC2_GME_ND               (isec2[ 3])  //  Nubmer of diamonds
#define  ISEC2_GME_NI               (isec2[ 4])  //  Number of tri. subdiv. of the icosahedron
#define  ISEC2_GME_AFlag            (isec2[ 5])  //  Flag for orientation of diamonds (Table A)
#define  ISEC2_GME_LatPP            (isec2[ 6])  //  Latitude of pole point
#define  ISEC2_GME_LonPP            (isec2[ 7])  //  Longitude of pole point
#define  ISEC2_GME_LonMPL           (isec2[ 8])  //  Longitude of the first diamond
#define  ISEC2_GME_BFlag            (isec2[ 9])  //  Flag for storage sequence (Table B)

// Spherical harmonic coeficients

#define  ISEC2_PentaJ               (isec2[ 1])  //  J pentagonal resolution parameter
#define  ISEC2_PentaK               (isec2[ 2])  //  K pentagonal resolution parameter
#define  ISEC2_PentaM               (isec2[ 3])  //  M pentagonal resolution parameter
#define  ISEC2_RepType              (isec2[ 4])  //  Representation type
#define  ISEC2_RepMode              (isec2[ 5])  //  Representation mode

// Gaussian grids

#define  ISEC2_NumLon               (isec2[ 1])  //  Number of points along a parallel (Ni)
#define  ISEC2_NumLat               (isec2[ 2])  //  Number of points along a meridian (Nj)
#define  ISEC2_FirstLat             (isec2[ 3])  //  Latitude of the first grid point
#define  ISEC2_FirstLon             (isec2[ 4])  //  Longitude of the first grid point
#define  ISEC2_ResFlag              (isec2[ 5])  //  Resolution flag: 128 regular grid
#define  ISEC2_LastLat              (isec2[ 6])  //  Latitude of the last grid point
#define  ISEC2_LastLon              (isec2[ 7])  //  Longitude of the last grid point
#define  ISEC2_LonIncr              (isec2[ 8])  //  i direction increment
#define  ISEC2_LatIncr              (isec2[ 9])  //  j direction increment
#define  ISEC2_NumPar               (isec2[ 9])  //  Number of parallels between a pole and the E.
#define  ISEC2_ScanFlag             (isec2[10])  //  Scanning mode flags
#define  ISEC2_NumVCP               (isec2[11])  //  Number of vertical coordinate parameters

// Lambert

#define  ISEC2_Lambert_Lov          (isec2[ 6])  //  Orientation of the grid
#define  ISEC2_Lambert_dx           (isec2[ 8])  //  X-direction grid length
#define  ISEC2_Lambert_dy           (isec2[ 9])  //  Y-direction grid length
#define  ISEC2_Lambert_ProjFlag     (isec2[12])  //  Projection centre flag
#define  ISEC2_Lambert_LatS1        (isec2[13])  //  First lat at which the secant cone cuts the sphere
#define  ISEC2_Lambert_LatS2        (isec2[14])  //  Second lat at which the secant cone cuts the sphere
#define  ISEC2_Lambert_LatSP        (isec2[19])  //  Latitude of the southern pole
#define  ISEC2_Lambert_LonSP        (isec2[20])  //  Longitude of the southern pole


#define  ISEC2_Reduced              (isec2[16])  // 0: regular, 1: reduced grid

#define  ISEC2_ReducedPointsPtr     (&isec2[22])
#define  ISEC2_ReducedPoints(i)     (isec2[22+i]) // Number of points along each parallel


#define  ISEC2_LatSP                (isec2[12])  // Latitude of the southern pole of rotation
#define  ISEC2_LonSP                (isec2[13])  // Longitude of the southern pole of rotation

#define  FSEC2_RotAngle             (fsec2[ 0])  // Angle of rotation
#define  FSEC2_StrFact              (fsec2[ 1])  // Stretching factor

// Macros for the bit map section ( Section 3 )

#define  ISEC3_PredefBitmap         (isec3[ 0])  // Predefined bitmap
#define  ISEC3_MissVal              (isec3[ 1])  // Missing data value for integers
#define  FSEC3_MissVal              (fsec3[ 1])  // Missing data value for floats

// Macros for the binary data section ( Section 4 )

#define  ISEC4_NumValues            (isec4[ 0])  // Number of data values for encode/decode
#define  ISEC4_NumBits              (isec4[ 1])  // Number of bits used for each encoded value
#define  ISEC4_NumNonMissValues     (isec4[20])  // Number of non-missing values


#ifdef __cplusplus
extern "C" {
#endif


void  gribFixZSE(int flag);     // 1: Fix ZeroShiftError of simple packed spherical harmonics
void  gribSetConst(int flag);   // 1: Don't pack constant fields on regular grids
void  gribSetDebug(int debug);  // 1: Debugging
void  gribSetRound(int round);
void  gribSetRefDP(double refval);
void  gribSetRefSP(float  refval);
void  gribSetValueCheck(int vcheck);


void  gribExSP(int *isec0, int *isec1, int *isec2, float *fsec2, int *isec3,
               float *fsec3, int *isec4, float *fsec4, int klenp, int *kgrib,
               int kleng, int *kword, const char *hoper, int *kret);

void  gribExDP(int *isec0, int *isec1, int *isec2, double *fsec2, int *isec3,
               double *fsec3, int *isec4, double *fsec4, int klenp, int *kgrib,
               int kleng, int *kword, const char *hoper, int *kret);


const char *cgribexLibraryVersion(void);

void  gribDebug(int debug);
void  gribSetCalendar(int calendar);

void  gribDateTimeX(int *isec1, int *date, int *time, int *startDate, int *startTime);
void  gribDateTime(int *isec1, int *date, int *time);
int   gribRefDate(const int *isec1);
int   gribRefTime(const int *isec1);

bool  gribTimeIsFC(const int *isec1);

void  gribPrintSec0(int *isec0);
void  gribPrintSec1(int *isec0, int *isec1);
void  gribPrintSec2DP(int *isec0, int *isec2, double *fsec2);
void  gribPrintSec2SP(int *isec0, int *isec2, float  *fsec2);
void  gribPrintSec3DP(int *isec0, int *isec3, double *fsec3);
void  gribPrintSec3SP(int *isec0, int *isec3, float  *fsec3);
void  gribPrintSec4DP(int *isec0, int *isec4, double *fsec4);
void  gribPrintSec4SP(int *isec0, int *isec4, float  *fsec4);
void  gribPrintSec4Wave(int *isec4);

void  gribPrintALL(int nrec, long offset, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintPDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintGDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintBMS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintBDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribCheck1(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribRepair1(int nrec, long recsize, unsigned char *gribbuffer);

int   gribGetZip(size_t recsize, unsigned char *gribbuffer, size_t *urecsize);

int   gribBzip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize);
int   gribZip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize);
int   gribUnzip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize);

int   gribOpen(const char *filename, const char *mode);
void  gribClose(int fileID);

int   gribRead(int fileID, void *buffer, size_t *buffersize);
int   gribWrite(int fileID, void *buffer, size_t buffersize);
off_t gribGetPos(int fileID);
size_t gribGetSize(int fileID);
int   gribCheckSeek(int fileID, long *offset, int *version);
int   gribFileSeek(int fileID, long *offset);
size_t gribReadSize(int fileID);
int   gribVersion(unsigned char *buffer, size_t buffersize);

int   grib_info_for_grads(off_t recpos, long recsize, unsigned char *gribbuffer, int *intnum, float *fltnum, off_t *bignum);

double calculate_pfactor_float(const float* spectralField, long fieldTruncation, long subsetTruncation);
double calculate_pfactor_double(const double* spectralField, long fieldTruncation, long subsetTruncation);

int grib1Sections(unsigned char *gribbuffer, long gribbufsize, unsigned char **pdsp, unsigned char **gdsp, unsigned char **bmsp,
                  unsigned char **bdsp, long *gribrecsize);

#ifdef  __cplusplus
}
#endif

// clang-format on

#endif /* CGRIBEX_H */
#ifdef HAVE_CONFIG_H
#endif

#include <ctype.h>


#ifdef HAVE_LIBCGRIBEX
#endif

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>
pthread_mutex_t CDI_IO_Mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

int CDI_Default_Calendar = CALENDAR_PROLEPTIC;

int CDI_Default_InstID = CDI_UNDEFID;
int CDI_Default_ModelID = CDI_UNDEFID;
int CDI_Default_TableID = CDI_UNDEFID;
// int cdiNcMissingValue  = CDI_UNDEFID;
int CDI_Netcdf_Chunksizehint = CDI_UNDEFID;
int CDI_Split_Ltype105 = CDI_UNDEFID;

bool CDI_Ignore_Att_Coordinates = false;
bool CDI_Coordinates_Lon_Lat = false;
bool CDI_Ignore_Valid_Range = false;
int CDI_Skip_Records = 0;
const char *CDI_GRIB1_Template = NULL;
const char *CDI_GRIB2_Template = NULL;
int CDI_Convention = CDI_CONVENTION_ECHAM;
int CDI_Inventory_Mode = 1;
int CDI_Version_Info = 1;
int CDI_Query_Abort = 1;
int CDI_Convert_Cubesphere = 1;
int CDI_Read_Cell_Center = 1;
int CDI_Read_Cell_Corners = 1;
int CDI_CMOR_Mode = 0;
int CDI_Reduce_Dim = 0;
int CDI_Shuffle = 0;
int CDI_Test = 0;
size_t CDI_Netcdf_Hdr_Pad = 0UL;
bool CDI_CopyChunkSpec = false;
bool CDI_RemoveChunkSpec = false;
bool CDI_Chunk_Cache_Info = false;
long CDI_Chunk_Cache_In = -1L;
long CDI_Chunk_Cache_Out = -1L;
size_t CDI_Chunk_Cache_Max = 0UL;
bool CDI_Netcdf_Lazy_Grid_Load = false;

char *cdiPartabPath = NULL;
int cdiPartabIntern = 1;

double CDI_Default_Missval = -9.E33;
double CDI_Grid_Missval = -9999.;

// clang-format off
static const char Filetypes[][9] = {
  "UNKNOWN",
  "GRIB",
  "GRIB2",
  "NetCDF",
  "NetCDF2",
  "NetCDF4",
  "NetCDF4c",
  "NetCDF5",
  "SERVICE",
  "EXTRA",
  "IEG",
  "NCZarr",
  "HDF5",
};
// clang-format on

int CDI_Debug = 0;  // If set to 1, debugging
int CDI_Recopt = 0;

bool CDI_gribapi_debug = false;
bool CDI_gribapi_grib1 = false;
bool CDI_Lock_IO = false;
bool CDI_Threadsafe = false;
int cdiDefaultLeveltype = -1;
int cdiDataUnreduced = 0;
int cdiSortName = 0;
int cdiHaveMissval = 0;

static long
cdi_getenv_int(const char *envName)
{
  long envValue = -1;

  char *envString = getenv(envName);
  if (envString)
  {
    long fact = 1;
    int len = (int) strlen(envString);
    for (int loop = 0; loop < len; loop++)
    {
      if (!isdigit((int) envString[loop]))
      {
        switch (tolower((int) envString[loop]))
        {
          case 'k': fact = 1024; break;
          case 'm': fact = 1048576; break;
          case 'g': fact = 1073741824; break;
          default:
            fact = 0;
            Warning("Invalid number string in %s: %s", envName, envString);
            Warning("%s must comprise only digits [0-9].", envName);
            break;
        }
        break;
      }
    }

    if (fact) envValue = fact * atol(envString);

    if (CDI_Debug) Message("set %s to %ld", envName, envValue);
  }

  return envValue;
}

static void
cdiPrintDefaults(void)
{
  fprintf(stderr,
          "default instID     :  %d\n"
          "default modelID    :  %d\n"
          "default tableID    :  %d\n"
          "default missval    :  %g\n",
          CDI_Default_InstID, CDI_Default_ModelID, CDI_Default_TableID, CDI_Default_Missval);
}

#ifdef HAVE_LIBFDB5
#include <fdb5/fdb5_config.h>
#endif

void
cdiPrintVersion(void)
{
  fprintf(stdout, "     CDI library version : %s\n", cdiLibraryVersion());
#ifdef HAVE_LIBCGRIBEX
  fprintf(stdout, " cgribex library version : %s\n", cgribexLibraryVersion());
#endif
#ifdef HAVE_LIBGRIB_API
  fprintf(stdout, " ecCodes library version : %s\n", gribapiLibraryVersionString());
#endif
#ifdef HAVE_LIBNETCDF
  fprintf(stdout, "  NetCDF library version : %s\n", cdfLibraryVersion());
#endif
#ifdef HAVE_LIBSERVICE
  fprintf(stdout, "    exse library version : %s\n", srvLibraryVersion());
#endif
  fprintf(stdout, "    FILE library version : %s\n", fileLibraryVersion());
#ifdef HAVE_LIBFDB5
  fprintf(stdout, "    FDB5 library version : %s\n", fdb5_version());
#endif
}

static void
cdiPrintDatatypes(void)
{
#define XSTRING(x) #x
#define STRING(x) XSTRING(x)

  fprintf(stderr,
          "+-------------+-------+\n"
          "| types       | bytes |\n"
          "+-------------+-------+\n"
          "| void *      |   %3d |\n"
          "+-------------+-------+\n"
          "| char        |   %3d |\n"
          "+-------------+-------+\n"
          "| bool        |   %3d |\n"
          "| short       |   %3d |\n"
          "| int         |   %3d |\n"
          "| long        |   %3d |\n"
          "| long long   |   %3d |\n"
          "| size_t      |   %3d |\n"
          "| off_t       |   %3d |\n"
          "+-------------+-------+\n"
          "| float       |   %3d |\n"
          "| double      |   %3d |\n"
          "| long double |   %3d |\n"
          "+-------------+-------+\n\n",
          (int) sizeof(void *), (int) sizeof(char), (int) sizeof(bool), (int) sizeof(short), (int) sizeof(int), (int) sizeof(long),
          (int) sizeof(long long), (int) sizeof(size_t), (int) sizeof(off_t), (int) sizeof(float), (int) sizeof(double),
          (int) sizeof(long double));

  fprintf(stderr,
          "+-------------+-----------+\n"
          "| INT32       | %-9s |\n"
          "| INT64       | %-9s |\n"
          "| FLT32       | %-9s |\n"
          "| FLT64       | %-9s |\n"
          "| SizeType    | %-9s |\n"
          "+-------------+-----------+\n",
          STRING(INT32), STRING(INT64), STRING(FLT32), STRING(FLT64), STRING(CDI_SIZE_TYPE));

  fprintf(stderr, "\n  byte ordering is %s\n\n",
          ((HOST_ENDIANNESS == CDI_BIGENDIAN)
               ? "BIGENDIAN"
               : ((HOST_ENDIANNESS == CDI_LITTLEENDIAN) ? "LITTLEENDIAN" : "Unhandled endianness!")));

#undef STRING
#undef XSTRING
}

void
cdiDebug(int level)
{
  unsigned ulevel = (level == 1) ? (1U << 16) : (unsigned) level;

  if (ulevel & 2) CDI_Debug = 1;
  if (ulevel & 4) memDebug(1);
  if (ulevel & 8) fileDebug(1);

  if (ulevel & 16)
  {
#ifdef HAVE_LIBCGRIBEX
    gribSetDebug(1);
#endif
#ifdef HAVE_LIBNETCDF
    cdfDebug(1);
#endif
#ifdef HAVE_LIBSERVICE
    srvDebug(1);
#endif
#ifdef HAVE_LIBEXTRA
    extDebug(1);
#endif
#ifdef HAVE_LIBIEG
    iegDebug(1);
#endif
  }

  if (CDI_Debug)
  {
    cdiPrintDefaults();
    cdiPrintDatatypes();
  }
}

int
cdiHaveFiletype(int filetype)
{
  int status = 0;

  switch (filetype)
  {
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV: status = 1; break;
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT: status = 1; break;
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG: status = 1; break;
#endif
#ifdef HAVE_LIBGRIB
#if defined HAVE_LIBGRIB_API || defined HAVE_LIBCGRIBEX
    case CDI_FILETYPE_GRB: status = 1; break;
#endif
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRB2: status = 1; break;
#endif
#endif
#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NC: status = 1; break;
#ifdef HAVE_NETCDF2
    case CDI_FILETYPE_NC2: status = 1; break;
#endif
#ifdef HAVE_NETCDF4
    case CDI_FILETYPE_NC4: status = 1; break;
    case CDI_FILETYPE_NC4C: status = 1; break;
#endif
#ifdef HAVE_NCZARR
    case CDI_FILETYPE_NCZARR: status = 1; break;
#endif
#ifdef HAVE_NETCDF5
    case CDI_FILETYPE_NC5: status = 1; break;
#endif
#endif
    default: status = 0; break;
  }

  return status;
}

void
cdiDefTableID(int tableID)
{
  CDI_Default_TableID = tableID;
  int modelID = CDI_Default_ModelID = tableInqModel(tableID);
  CDI_Default_InstID = modelInqInstitut(modelID);
}

void
cdiSetEccodesGrib1(bool value)
{
#ifndef HAVE_LIBGRIB_API
  if (value)
  {
    Warning("ecCodes support not compiled in, used CGRIBEX to decode/encode GRIB1 records!");
    value = false;
  }
#endif
  CDI_gribapi_grib1 = value;
}

void
cdiInitialize(void)
{
  static bool Init_CDI = false;

  if (!Init_CDI)
  {
    Init_CDI = true;
    char *envstr;
    long value;

#ifdef HAVE_LIBCGRIBEX
    gribFixZSE(1);    // 1: Fix ZeroShiftError of simple packed spherical harmonics
    gribSetConst(1);  // 1: Don't pack constant fields on regular grids
#endif
#ifdef HAVE_LIBGRIB_API
    grib_multi_support_off(NULL);
#endif

    value = cdi_getenv_int("CDI_DEBUG");
    if (value >= 0) CDI_Debug = (int) value;

    value = cdi_getenv_int("CDI_GRIBAPI_DEBUG");
    if (value >= 0) CDI_gribapi_debug = (bool) value;

    value = cdi_getenv_int("CDI_ECCODES_DEBUG");
    if (value >= 0) CDI_gribapi_debug = (bool) value;

    value = cdi_getenv_int("CDI_ECCODES_GRIB1");
    if (value >= 0) cdiSetEccodesGrib1((bool) value);

    value = cdi_getenv_int("CDI_LOCK_IO");
    if (value >= 0) CDI_Lock_IO = (bool) value;

    value = cdi_getenv_int("CDI_READ_CELL_CENTER");
    if (value >= 0) CDI_Read_Cell_Center = (int) value;

    value = cdi_getenv_int("CDI_READ_CELL_CORNERS");
    if (value >= 0) CDI_Read_Cell_Corners = (int) value;

    value = cdi_getenv_int("CDI_RECOPT");
    if (value >= 0) CDI_Recopt = (int) value;

    value = cdi_getenv_int("CDI_REGULARGRID");
    if (value >= 0) cdiDataUnreduced = (int) value;

    value = cdi_getenv_int("CDI_SORTNAME");
    if (value >= 0) cdiSortName = (int) value;

    value = cdi_getenv_int("CDI_HAVE_MISSVAL");
    if (value >= 0) cdiHaveMissval = (int) value;

    value = cdi_getenv_int("CDI_LEVELTYPE");
    if (value >= 0) cdiDefaultLeveltype = (int) value;

    value = cdi_getenv_int("CDI_NETCDF_HDR_PAD");
    if (value >= 0) CDI_Netcdf_Hdr_Pad = (size_t) value;

    value = cdi_getenv_int("CDI_COPY_CHUNKSPEC");
    if (value >= 0) CDI_CopyChunkSpec = (value > 0);

    value = cdi_getenv_int("CDI_REMOVE_CHUNKSPEC");
    if (value >= 0) CDI_RemoveChunkSpec = (value > 0);

    value = cdi_getenv_int("CDI_CHUNK_CACHE_INFO");
    if (value > 0) CDI_Chunk_Cache_Info = true;

    value = cdi_getenv_int("CDI_CHUNK_CACHE_IN");
    if (value >= 0) CDI_Chunk_Cache_In = value;

    value = cdi_getenv_int("CDI_CHUNK_CACHE_OUT");
    if (value >= 0) CDI_Chunk_Cache_Out = value;

    value = cdi_getenv_int("CDI_CHUNK_CACHE_MAX");
    if (value >= 0) CDI_Chunk_Cache_Max = (size_t) value;

    value = cdi_getenv_int("CDI_TEST");
    if (value >= 0) CDI_Test = (int) value;

    envstr = getenv("CDI_GRIB1_TEMPLATE");
    if (envstr) CDI_GRIB1_Template = envstr;

    envstr = getenv("CDI_GRIB2_TEMPLATE");
    if (envstr) CDI_GRIB2_Template = envstr;

    envstr = getenv("CDI_SHUFFLE");
    if (envstr) CDI_Shuffle = atoi(envstr);

    envstr = getenv("CDI_MISSVAL");
    if (envstr) CDI_Default_Missval = atof(envstr);
    /*
    envstr = getenv("NC_MISSING_VALUE");
    if ( envstr ) cdiNcMissingValue = atoi(envstr);
    */
    envstr = getenv("NC_CHUNKSIZEHINT");
    if (envstr) CDI_Netcdf_Chunksizehint = atoi(envstr);

    envstr = getenv("SPLIT_LTYPE_105");
    if (envstr) CDI_Split_Ltype105 = atoi(envstr);

    envstr = getenv("IGNORE_ATT_COORDINATES");
    if (envstr) CDI_Ignore_Att_Coordinates = atoi(envstr) > 0;

    envstr = getenv("CDI_COORDINATES_LONLAT");
    if (envstr) CDI_Coordinates_Lon_Lat = atoi(envstr) > 0;

    envstr = getenv("IGNORE_VALID_RANGE");
    if (envstr) CDI_Ignore_Valid_Range = atoi(envstr) > 0;

    envstr = getenv("CDI_SKIP_RECORDS");
    if (envstr)
    {
      CDI_Skip_Records = atoi(envstr);
      CDI_Skip_Records = CDI_Skip_Records > 0 ? CDI_Skip_Records : 0;
    }

    envstr = getenv("CDI_CONVENTION");
    if (envstr)
    {
      if (str_is_equal(envstr, "CF") || str_is_equal(envstr, "cf"))
      {
        CDI_Convention = CDI_CONVENTION_CF;
        if (CDI_Debug) Message("CDI convention was set to CF!");
      }
    }

    envstr = getenv("CDI_INVENTORY_MODE");
    if (envstr)
    {
      if (strncmp(envstr, "time", 4) == 0)
      {
        CDI_Inventory_Mode = 2;
        if (CDI_Debug) Message("Inventory mode was set to timestep!");
      }
    }

    envstr = getenv("CDI_QUERY_ABORT");
    if (envstr)
    {
      int ival = atoi(envstr);
      if (ival == 0 || ival == 1)
      {
        CDI_Query_Abort = ival;
        if (CDI_Debug) Message("CDI_Query_Abort = %s", envstr);
      }
    }

    envstr = getenv("CDI_VERSION_INFO");
    if (envstr)
    {
      int ival = atoi(envstr);
      if (ival == 0 || ival == 1)
      {
        CDI_Version_Info = ival;
        if (CDI_Debug) Message("CDI_Version_Info = %s", envstr);
      }
    }

    envstr = getenv("CDI_CONVERT_CUBESPHERE");
    if (envstr)
    {
      int ival = atoi(envstr);
      if (ival == 0 || ival == 1)
      {
        CDI_Convert_Cubesphere = ival;
        if (CDI_Debug) Message("CDI_Convert_Cubesphere = %s", envstr);
      }
    }

    envstr = getenv("CDI_CALENDAR");
    if (envstr)
    {
      // clang-format off
	      if      (strncmp(envstr, "standard", 8)  == 0) CDI_Default_Calendar = CALENDAR_STANDARD;
	      else if (strncmp(envstr, "gregorian", 9) == 0) CDI_Default_Calendar = CALENDAR_GREGORIAN;
	      else if (strncmp(envstr, "proleptic", 9) == 0) CDI_Default_Calendar = CALENDAR_PROLEPTIC;
	      else if (strncmp(envstr, "360days", 7)   == 0) CDI_Default_Calendar = CALENDAR_360DAYS;
	      else if (strncmp(envstr, "365days", 7)   == 0) CDI_Default_Calendar = CALENDAR_365DAYS;
	      else if (strncmp(envstr, "366days", 7)   == 0) CDI_Default_Calendar = CALENDAR_366DAYS;
	      else if (strncmp(envstr, "none", 4)      == 0) CDI_Default_Calendar = CALENDAR_NONE;
      // clang-format on
      if (CDI_Debug) Message("Default calendar set to %s!", envstr);
    }
#ifdef HAVE_LIBCGRIBEX
    gribSetCalendar(CDI_Default_Calendar);
#endif

    envstr = getenv("PARTAB_INTERN");
    if (envstr) cdiPartabIntern = atoi(envstr);

    envstr = getenv("PARTAB_PATH");
    if (envstr) cdiPartabPath = strdup(envstr);
  }
}

const char *
strfiletype(int filetype)
{
  int size = (int) (sizeof(Filetypes) / sizeof(char *));
  return (filetype > 0 && filetype < size) ? Filetypes[filetype] : Filetypes[0];
}

void
cdiDefGlobal(const char *string, int value)
{
  // clang-format off
  if      (str_is_equal(string, "REGULARGRID"))           cdiDataUnreduced = value;
  else if (str_is_equal(string, "LOCKIO"))                CDI_Lock_IO = (bool) value;
  else if (str_is_equal(string, "THREADSAFE"))            CDI_Threadsafe = (bool) value;
  else if (str_is_equal(string, "ECCODES_DEBUG"))         CDI_gribapi_debug = (bool) value;
  else if (str_is_equal(string, "ECCODES_GRIB1"))         cdiSetEccodesGrib1((bool) value);
  else if (str_is_equal(string, "SORTNAME"))              cdiSortName = value;
  else if (str_is_equal(string, "HAVE_MISSVAL"))          cdiHaveMissval = value;
  else if (str_is_equal(string, "NC_CHUNKSIZEHINT"))      CDI_Netcdf_Chunksizehint = value;
  else if (str_is_equal(string, "READ_CELL_CENTER"))      CDI_Read_Cell_Center = value;
  else if (str_is_equal(string, "READ_CELL_CORNERS"))     CDI_Read_Cell_Corners = value;
  else if (str_is_equal(string, "CMOR_MODE"))             CDI_CMOR_Mode = value;
  else if (str_is_equal(string, "REDUCE_DIM"))            CDI_Reduce_Dim = value;
  else if (str_is_equal(string, "NETCDF_HDR_PAD"))        CDI_Netcdf_Hdr_Pad = (size_t) value;
  else if (str_is_equal(string, "NETCDF_LAZY_GRID_LOAD")) CDI_Netcdf_Lazy_Grid_Load = (bool) value;
  else if (str_is_equal(string, "COPY_CHUNKSPEC"))        CDI_CopyChunkSpec = (bool) value;
  else if (str_is_equal(string, "REMOVE_CHUNKSPEC"))      CDI_RemoveChunkSpec = (bool) value;
  else Warning("Unsupported global key: %s", string);
  // clang-format on
}

void
cdiDefMissval(double missval)
{
  cdiInitialize();

  CDI_Default_Missval = missval;
}

double
cdiInqMissval(void)
{
  cdiInitialize();

  return CDI_Default_Missval;
}

bool
cdiFiletypeIsExse(int filetype)
{
  return (filetype == CDI_FILETYPE_SRV || filetype == CDI_FILETYPE_EXT || filetype == CDI_FILETYPE_IEG);
}

int
cdiBaseFiletype(int filetype)
{
  switch (filetype)
  {
    case CDI_FILETYPE_GRB:
    case CDI_FILETYPE_GRB2: return CDI_FILETYPE_GRIB;
    case CDI_FILETYPE_NC:
    case CDI_FILETYPE_NC2:
    case CDI_FILETYPE_NC4:
    case CDI_FILETYPE_NC4C:
    case CDI_FILETYPE_NCZARR:
    case CDI_FILETYPE_NC5: return CDI_FILETYPE_NETCDF;
  }

  return filetype;
}

void
stream_def_accesstype(stream_t *s, int type)
{
  if (s->accesstype == CDI_UNDEFID) { s->accesstype = type; }
  else if (s->accesstype != type)
    Error("Changing access type from %s not allowed!", s->accesstype == TYPE_REC ? "REC to VAR" : "VAR to REC");
}

int
cdi_has_ncfilter(void)
{
#ifdef HAVE_NC4FILTER
  return 1;
#endif
  return 0;
}

int
cdi_has_ncdap(void)
{
#ifdef HAVE_LIBNC_DAP
  return 1;
#endif
  return 0;
}

int
cdi_has_cgribex(void)
{
#ifdef HAVE_LIBCGRIBEX
  return 1;
#endif
  return 0;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <string.h>
#include <stdlib.h>

static int
sum_found(int listSize, bool *listFound)
{
  int numFound = 0;
  for (int i = 0; i < listSize; ++i) numFound += listFound[i];
  return numFound;
}

static int
sum_not_found(int listSize, bool *listFound)
{
  return listSize - sum_found(listSize, listFound);
}

void
cdiQueryInit(CdiQuery *query)
{
  query->numEntries = 0;

  query->numNames = 0;
  query->names = NULL;
  query->namesFound = NULL;

  query->numCellidx = 0;
  query->cellidx = NULL;
  query->cellidxFound = NULL;

  query->numLevidx = 0;
  query->levidx = NULL;
  query->levidxFound = NULL;

  query->numStepidx = 0;
  query->stepidx = NULL;
  query->stepidxFound = NULL;
}

CdiQuery *
cdiQueryCreate(void)
{
  CdiQuery *query = (CdiQuery *) Malloc(sizeof(CdiQuery));
  cdiQueryInit(query);
  return query;
}

void
cdiQueryDelete(CdiQuery *query)
{
  if (query)
  {
    if (query->numNames)
    {
      for (int i = 0; i < query->numNames; ++i) Free(query->names[i]);
      Free(query->names);
      Free(query->namesFound);
    }

    if (query->numCellidx)
    {
      Free(query->cellidx);
      Free(query->cellidxFound);
    }

    if (query->numLevidx)
    {
      Free(query->levidx);
      Free(query->levidxFound);
    }

    if (query->numStepidx)
    {
      Free(query->stepidx);
      Free(query->stepidxFound);
    }

    cdiQueryInit(query);
    Free(query);
  }
}

int
cdiQueryNumNames(const CdiQuery *query)
{
  return query ? query->numNames : 0;
}

int
cdiQueryNumCellidx(const CdiQuery *query)
{
  return query ? query->numCellidx : 0;
}

int
cdiQueryNumStepidx(const CdiQuery *query)
{
  return query ? query->numStepidx : 0;
}

int
cdiQueryNumEntries(const CdiQuery *query)
{
  return query ? query->numEntries : 0;
}

void
cdiQuerySetNames(CdiQuery *query, int numEntries, char **names)
{
  if (numEntries > 0)
  {
    query->numEntries += numEntries;
    query->numNames = numEntries;
    query->namesFound = (bool *) Calloc((size_t) numEntries, sizeof(bool));
    query->names = (char **) Malloc((size_t) numEntries * sizeof(char *));
    for (int i = 0; i < numEntries; ++i) query->names[i] = strdup(names[i]);
  }
}

void
cdiQuerySetCellidx(CdiQuery *query, int numEntries, size_t *cellidx)
{
  if (numEntries > 0)
  {
    query->numEntries += numEntries;
    query->numCellidx = numEntries;
    query->cellidxFound = (bool *) Calloc((size_t) numEntries, sizeof(bool));
    query->cellidx = (size_t *) Malloc((size_t) numEntries * sizeof(size_t));
    for (int i = 0; i < numEntries; ++i) query->cellidx[i] = cellidx[i];
  }
}

void
cdiQuerySetLevidx(CdiQuery *query, int numEntries, int *levidx)
{
  if (numEntries > 0)
  {
    query->numEntries += numEntries;
    query->numLevidx = numEntries;
    query->levidxFound = (bool *) Calloc((size_t) numEntries, sizeof(bool));
    query->levidx = (int *) Malloc((size_t) numEntries * sizeof(int));
    for (int i = 0; i < numEntries; ++i) query->levidx[i] = levidx[i];
  }
}

void
cdiQuerySetStepidx(CdiQuery *query, int numEntries, int *stepidx)
{
  if (numEntries > 0)
  {
    query->numEntries += numEntries;
    query->numStepidx = numEntries;
    query->stepidxFound = (bool *) Calloc((size_t) numEntries, sizeof(bool));
    query->stepidx = (int *) Malloc((size_t) numEntries * sizeof(int));
    for (int i = 0; i < numEntries; ++i) query->stepidx[i] = stepidx[i];
  }
}

size_t
cdiQueryGetCellidx(const CdiQuery *query, int index)
{
  return (index >= 0 && index < query->numCellidx) ? query->cellidx[index] : (size_t) -1;
}

CdiQuery *
cdiQueryClone(const CdiQuery *query)
{
  CdiQuery *queryOut = cdiQueryCreate();

  if (query)
  {
    cdiQuerySetNames(queryOut, query->numNames, query->names);
    cdiQuerySetCellidx(queryOut, query->numCellidx, query->cellidx);
    cdiQuerySetLevidx(queryOut, query->numLevidx, query->levidx);
    cdiQuerySetStepidx(queryOut, query->numStepidx, query->stepidx);
  }

  return queryOut;
}

static void
print_list_compact_int(int n, const int *list)
{
  for (int i = 0; i < n; ++i)
  {
    int value = list[i];
    printf(" %d", value);
    if ((i + 2) < n && (value + 1) == list[i + 1] && (value + 2) == list[i + 2])
    {
      printf("/to/");
      int last = list[++i];
      while ((i + 1) < n && (last + 1) == list[i + 1]) last = list[++i];
      printf("%d", last);
    }
  }
  printf("\n");
}

void
cdiQueryPrint(const CdiQuery *query)
{
  if (query)
  {
    if (query->numNames)
    {
      printf("Names:");
      for (int i = 0; i < query->numNames; ++i) printf(" %s", query->names[i]);
      printf("\n");
    }

    if (query->numCellidx)
    {
      printf("Cellidx:");
      for (int i = 0; i < query->numCellidx; ++i) printf(" %zu", query->cellidx[i]);
      printf("\n");
    }

    if (query->numLevidx)
    {
      printf("Levidx:");
      print_list_compact_int(query->numLevidx, query->levidx);
    }

    if (query->numStepidx)
    {
      printf("Stepidx:");
      print_list_compact_int(query->numStepidx, query->stepidx);
    }
  }
}

int
cdiQueryNumEntriesFound(const CdiQuery *query)
{
  int numEntriesFound = 0;

  if (query)
  {
    if (query->numNames) numEntriesFound += sum_found(query->numNames, query->namesFound);
    if (query->numCellidx) numEntriesFound += sum_found(query->numCellidx, query->cellidxFound);
    if (query->numLevidx) numEntriesFound += sum_found(query->numLevidx, query->levidxFound);
    if (query->numStepidx) numEntriesFound += sum_found(query->numStepidx, query->stepidxFound);
  }

  return numEntriesFound;
}

void
cdiQueryPrintEntriesNotFound(const CdiQuery *query)
{
  if (query)
  {
    int numEntriesNotFound = cdiQueryNumEntries(query) - cdiQueryNumEntriesFound(query);
    if (numEntriesNotFound > 0)
    {
      if (query->numNames)
      {
        if (sum_not_found(query->numNames, query->namesFound) > 0)
        {
          printf("Name not found:");
          for (int i = 0; i < query->numNames; ++i)
            if (!query->namesFound[i]) printf(" %s", query->names[i]);
          printf("\n");
        }
      }

      if (query->numCellidx)
      {
        if (sum_not_found(query->numCellidx, query->cellidxFound) > 0)
        {
          printf("Grid cell index not found:");
          for (int i = 0; i < query->numCellidx; ++i)
            if (!query->cellidxFound[i]) printf(" %zu", query->cellidx[i]);
          printf("\n");
        }
      }

      if (query->numLevidx)
      {
        if (sum_not_found(query->numLevidx, query->levidxFound) > 0)
        {
          printf("Level index not found:");
          for (int i = 0; i < query->numLevidx; ++i)
            if (!query->levidxFound[i]) printf(" %d", query->levidx[i]);
          printf("\n");
        }
      }

      if (query->numStepidx)
      {
        if (sum_not_found(query->numStepidx, query->stepidxFound) > 0)
        {
          printf("Step index not found:");
          for (int i = 0; i < query->numStepidx; ++i)
            if (!query->stepidxFound[i]) printf(" %d", query->stepidx[i]);
          printf("\n");
        }
      }
    }
  }
}

int
cdiQueryName(CdiQuery *query, const char *name)
{
  if (query && query->numNames && name && *name)
  {
    for (int i = 0; i < query->numNames; ++i)
      if (strcmp(name, query->names[i]) == 0)
      {
        query->namesFound[i] = true;
        return 0;
      }
  }

  return -1;
}

int
cdiQueryCellidx(CdiQuery *query, size_t cellidx)
{
  if (query && query->numCellidx)
  {
    for (int i = 0; i < query->numCellidx; ++i)
      if (query->cellidx[i] == cellidx)
      {
        query->cellidxFound[i] = true;
        return 0;
      }
  }

  return -1;
}

int
cdiQueryLevidx(CdiQuery *query, int levidx)
{
  if (query && query->numLevidx)
  {
    for (int i = 0; i < query->numLevidx; ++i)
      if (query->levidx[i] == levidx)
      {
        query->levidxFound[i] = true;
        return 0;
      }
  }

  return -1;
}

int
cdiQueryStepidx(CdiQuery *query, int stepidx)
{
  if (query && query->numStepidx)
  {
    for (int i = 0; i < query->numStepidx; ++i)
      if (query->stepidx[i] == stepidx)
      {
        query->stepidxFound[i] = true;
        return 0;
      }
  }

  return -1;
}
#ifdef HAVE_CONFIG_H
#endif

#ifndef _WIN32
#include <unistd.h>
#endif
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>

void
cdiDecodeParam(int param, int *pnum, int *pcat, int *pdis)
{
  unsigned uparam = (unsigned) param;

  *pdis = (int) (0xffU & uparam);
  *pcat = (int) (0xffU & (uparam >> 8));
  unsigned upnum = 0xffffU & (uparam >> 16);
  if (upnum > 0x7fffU) upnum = 0x8000U - upnum;
  *pnum = (int) upnum;
}

int
cdiEncodeParam(int pnum, int pcat, int pdis)
{
  if (pcat < 0 || pcat > 255) pcat = 255;
  if (pdis < 0 || pdis > 255) pdis = 255;

  unsigned upnum = (unsigned) pnum;
  if (pnum < 0) upnum = (unsigned) (0x8000 - pnum);

  unsigned uparam = (upnum << 16) | (((unsigned) pcat) << 8) | (unsigned) pdis;

  return (int) uparam;
}

void
cdiParamToString(int param, char *paramstr, int maxlen)
{
  int dis, cat, num;
  cdiDecodeParam(param, &num, &cat, &dis);

  size_t umaxlen = maxlen >= 0 ? (unsigned) maxlen : 0U;
  int len;
  if (dis == 255 && (cat == 255 || cat == 0))
    len = snprintf(paramstr, umaxlen, "%d", num);
  else if (dis == 255)
    len = snprintf(paramstr, umaxlen, "%d.%d", num, cat);
  else
    len = snprintf(paramstr, umaxlen, "%d.%d.%d", num, cat, dis);

  if (len >= maxlen || len < 0) fprintf(stderr, "Internal problem (%s): size of input string is too small!\n", __func__);
}

const char *
cdiUnitNamePtr(int cdi_unit)
{
  const char *cdiUnits[] = {
    /*  0 */ "undefined",
    /*  1 */ "Pa",
    /*  2 */ "hPa",
    /*  3 */ "mm",
    /*  4 */ "cm",
    /*  5 */ "dm",
    /*  6 */ "m",
  };
  enum
  {
    numUnits = (int) (sizeof(cdiUnits) / sizeof(char *))
  };
  const char *name = (cdi_unit > 0 && cdi_unit < numUnits) ? cdiUnits[cdi_unit] : NULL;

  return name;
}

size_t
cdiGetPageSize(bool largePageAlign)
{
  long pagesize = -1L;
#if HAVE_DECL__SC_LARGE_PAGESIZE || HAVE_DECL__SC_PAGE_SIZE || HAVE_DECL__SC_PAGESIZE
  bool nameAssigned = false;
  int name = 0;
#if HAVE_DECL__SC_LARGE_PAGESIZE
  if (largePageAlign)
  {
    name = _SC_LARGE_PAGESIZE;
    nameAssigned = true;
  }
  else
#else
  (void) largePageAlign;
#endif
  {
#if HAVE_DECL__SC_PAGESIZE || HAVE_DECL__SC_PAGE_SIZE
    name =
#if HAVE_DECL__SC_PAGESIZE
        _SC_PAGESIZE;
#else
        _SC_PAGE_SIZE;
#endif
    nameAssigned = true;
#endif
  }
  if (nameAssigned) pagesize = sysconf(name);
#endif
  if (pagesize == -1L)
    pagesize =
#if HAVE_DECL_PAGESIZE
        PAGESIZE;
#elif HAVE_DECL_PAGE_SIZE
        PAGE_SIZE;
#else
        commonPageSize;
#endif
  return (size_t) pagesize;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */

// Automatically generated by m214003 at 2024-10-30, do not edit

// CGRIBEXLIB_VERSION="2.3.1"

#if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ > 5) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wconversion"
#pragma GCC diagnostic ignored "-Wsign-conversion"
#pragma GCC diagnostic warning "-Wstrict-overflow"
#endif

#ifdef _ARCH_PWR6
#pragma options nostrict
#include <ppu_intrinsics.h>
#endif

#ifdef HAVE_CONFIG_H
#endif

#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <stdbool.h>
#include <sys/types.h>
#include <limits.h>
#include <inttypes.h>


#ifndef CGRIBEX_TEMPLATES_H
#define CGRIBEX_TEMPLATES_H

// clang-format off
#define CAT(X,Y)      X##_##Y
#define TEMPLATE(X,Y) CAT(X,Y)
// clang-format on

#endif
#ifndef GRIB_INT_H
#define GRIB_INT_H

#ifdef HAVE_CONFIG_H
#endif

#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <math.h>
#include <float.h>

// clang-format off

#ifndef  CGRIBEX_H
#endif
#ifndef  ERROR_H
#endif

#ifndef UCHAR
#define  UCHAR  unsigned char
#endif


#if defined (CRAY) || defined (SX) || defined (__uxpch__)
#define VECTORCODE 1
#endif


#ifdef VECTORCODE
#  define  GRIBPACK     uint32_t
#  define  PACK_GRIB    packInt32
#  define  UNPACK_GRIB  unpackInt32
#else
#  define  GRIBPACK     unsigned char
#endif

#ifndef HOST_ENDIANNESS
#ifdef __cplusplus
static const uint32_t HOST_ENDIANNESS_temp[1] = { UINT32_C(0x00030201) };
#define HOST_ENDIANNESS (((const unsigned char *)HOST_ENDIANNESS_temp)[0])
#else
#define HOST_ENDIANNESS (((const unsigned char *)&(const uint32_t[1]){UINT32_C(0x00030201)})[0])
#endif
#endif

#define  IS_BIGENDIAN()  (HOST_ENDIANNESS == 0)

#if defined (__xlC__) /* performance problems on IBM */
#ifndef DBL_IS_NAN
#  define DBL_IS_NAN(x)     ((x) != (x))
#endif
#else
#ifndef DBL_IS_NAN
#if  defined  (HAVE_DECL_ISNAN)
#  define DBL_IS_NAN(x)     (isnan(x))
#elif  defined  (FP_NAN)
#  define DBL_IS_NAN(x)     (fpclassify(x) == FP_NAN)
#else
#  define DBL_IS_NAN(x)     ((x) != (x))
#endif
#endif
#endif

#ifndef IS_EQUAL
#  define IS_NOT_EQUAL(x,y) (x < y || y < x)
#  define IS_EQUAL(x,y)     (!IS_NOT_EQUAL(x,y))
#endif

/* dummy use of unused parameters to silence compiler warnings */
#ifndef UNUSED
#define  UNUSED(x) (void)(x)
#endif

#define  JP24SET    0xFFFFFF  /* 2**24     (---> 16777215) */
#define  JP23SET    0x7FFFFF  /* 2**23 - 1 (--->  8388607) */

#define  POW_2_M24  0.000000059604644775390625  /* pow(2.0, -24.0) */

#ifdef __cplusplus
extern "C" {
#endif

#define intpow2(x) (ldexp(1.0, (x)))

static inline int
gribrec_len(unsigned b1, unsigned b2, unsigned b3)
{
  /*
    If bit 7 of b1 is set, we have to rescale by factor of 120.
    This is a fixup to get round the restriction on product lengths
    due to the count being only 24 bits. It is only possible because
    the (default) rounding for GRIB products is 120 bytes.
  */
  const int needRescaling = b1 & (1 << 7);

  int gribsize = (int)((((b1&127) << 16)+(b2<<8) + b3));

  if ( needRescaling ) gribsize *= 120;

  return gribsize;

}

unsigned correct_bdslen(unsigned bdslen, long recsize, long gribpos);

/* CDI converter routines */

/* param format:  DDDCCCNNN */

void    cdiDecodeParam(int param, int *pnum, int *pcat, int *pdis);
int     cdiEncodeParam(int pnum, int pcat, int pdis);

/* date format:  YYYYMMDD */
/* time format:  hhmmss   */

void    cdiDecodeDate(int date, int *year, int *month, int *day);
int     cdiEncodeDate(int year, int month, int day);

void    cdiDecodeTime(int time, int *hour, int *minute, int *second);
int     cdiEncodeTime(int hour, int minute, int second);

/* CALENDAR types */

#define  CALENDAR_STANDARD        0  /* don't change this value (used also in cgribexlib)! */
#define  CALENDAR_GREGORIAN       1
#define  CALENDAR_PROLEPTIC       2
#define  CALENDAR_360DAYS         3
#define  CALENDAR_365DAYS         4
#define  CALENDAR_366DAYS         5
#define  CALENDAR_NONE            6

extern FILE *grprsm;

extern int  CGRIBEX_Debug, CGRIBEX_Fix_ZSE, CGRIBEX_Const;
extern int  CGRIBEX_grib_calendar;

void   gprintf(const char *caller, const char *fmt, ...);

void   grsdef(void);

void   prtbin(int kin, int knbit, int *kout, int *kerr);
void   confp3(double pval, int *kexp, int *kmant, int kbits, int kround);
double decfp2(int kexp, int kmant);
void   ref2ibm(double *pref, int kbits);

void   scale_complex_double(double *fpdata, int pcStart, int pcScale, int trunc, int inv);
void   scale_complex_float(float *fpdata, int pcStart, int pcScale, int trunc, int inv);
void   scatter_complex_double(double *fpdata, int pcStart, int trunc, int nsp);
void   scatter_complex_float(float *fpdata, int pcStart, int trunc, int nsp);
void   gather_complex_double(double *fpdata, size_t pcStart, size_t trunc, size_t nsp);
void   gather_complex_float(float *fpdata, size_t pcStart, size_t trunc, size_t nsp);

int    qu2reg2(double *pfield, int *kpoint, int klat, int klon,
	       double *ztemp, double msval, int *kret);
int    qu2reg3_double(double *pfield, int *kpoint, int klat, int klon,
		      double msval, int *kret, int omisng, int operio, int oveggy);
int    qu2reg3_float(float *pfield, int *kpoint, int klat, int klon,
		     float msval, int *kret, int omisng, int operio, int oveggy);

long   packInt32(uint32_t *up, unsigned char *cp, long bc, long tc);
long   packInt64(uint64_t *up, unsigned char *cp, long bc, long tc);
long   unpackInt32(const unsigned char *cp, uint32_t *up, long bc, long tc);
long   unpackInt64(const unsigned char *cp, uint64_t *up, long bc, long tc);

void  grib_encode_double(int *isec0, int *isec1, int *isec2, double *fsec2, int *isec3,
			 double *fsec3, int *isec4, double *fsec4, int klenp, int *kgrib,
			 int kleng, int *kword, int efunc, int *kret);
void  grib_encode_float(int *isec0, int *isec1, int *isec2, float *fsec2, int *isec3,
			float *fsec3, int *isec4, float *fsec4, int klenp, int *kgrib,
			int kleng, int *kword, int efunc, int *kret);

void  grib_decode_double(int *isec0, int *isec1, int *isec2, double *fsec2, int *isec3,
			 double *fsec3, int *isec4, double *fsec4, int klenp, int *kgrib,
			 int kleng, int *kword, int dfunc, int *kret);
void  grib_decode_float(int *isec0, int *isec1, int *isec2, float *fsec2, int *isec3,
			float *fsec3, int *isec4, float *fsec4, int klenp, int *kgrib,
			int kleng, int *kword, int dfunc, int *kret);


int grib1Sections(unsigned char *gribbuffer, long gribbufsize, unsigned char **pdsp,
		  unsigned char **gdsp, unsigned char **bmsp, unsigned char **bdsp, long *gribrecsize);
int grib2Sections(unsigned char *gribbuffer, long gribbufsize, unsigned char **idsp,
		  unsigned char **lusp, unsigned char **gdsp, unsigned char **pdsp,
		  unsigned char **drsp, unsigned char **bmsp, unsigned char **bdsp);

#ifdef  __cplusplus
}
#endif

// clang-format on

#endif /* GRIB_INT_H */
#ifndef GRIBDECODE_H
#define GRIBDECODE_H

// clang-format off

#define  UNDEFINED          9.999e20


#define  GET_INT3(a,b,c)    ((1-(int) ((unsigned) (a & 128) >> 6)) * (int) (((a & 127) << 16)+(b<<8)+c))
#define  GET_INT2(a,b)      ((1-(int) ((unsigned) (a & 128) >> 6)) * (int) (((a & 127) << 8) + b))
#define  GET_INT1(a)        ((1-(int) ((unsigned) (a & 128) >> 6)) * (int) (a&127))

/* this requires a 32-bit default integer machine */
#define  GET_UINT4(a,b,c,d) ((unsigned) ((a << 24) + (b << 16) + (c << 8) + (d)))
#define  GET_UINT3(a,b,c)   ((unsigned) ((a << 16) + (b << 8)  + (c)))
#define  GET_UINT2(a,b)     ((unsigned) ((a << 8)  + (b)))
#define  GET_UINT1(a)       ((unsigned)  (a))

#define  BUDG_START(s)      (s[0]=='B' && s[1]=='U' && s[2]=='D' && s[3]=='G')
#define  TIDE_START(s)      (s[0]=='T' && s[1]=='I' && s[2]=='D' && s[3]=='E')
#define  GRIB_START(s)      (s[0]=='G' && s[1]=='R' && s[2]=='I' && s[3]=='B')
#define  GRIB_FIN(s)        (s[0]=='7' && s[1]=='7' && s[2]=='7' && s[3]=='7')

/* GRIB1 Section 0: Indicator Section (IS) */

#define  GRIB1_SECLEN(s)     GET_UINT3(s[ 4], s[ 5], s[ 6])
#define  GRIB_EDITION(s)     GET_UINT1(s[ 7])

/* GRIB1 Section 1: Product Definition Section (PDS) */

#define  PDS_Len             GET_UINT3(pds[ 0], pds[ 1], pds[ 2])
#define  PDS_CodeTable       GET_UINT1(pds[ 3])
#define  PDS_CenterID        GET_UINT1(pds[ 4])
#define  PDS_ModelID         GET_UINT1(pds[ 5])
#define  PDS_GridDefinition  GET_UINT1(pds[ 6])
#define  PDS_Sec2Or3Flag     GET_UINT1(pds[ 7])
#define  PDS_HAS_GDS         ((pds[7] & 128) != 0)
#define  PDS_HAS_BMS         ((pds[7] &  64) != 0)
#define  PDS_Parameter       GET_UINT1(pds[ 8])
#define  PDS_LevelType       GET_UINT1(pds[ 9])
#define  PDS_Level1          (pds[10])
#define  PDS_Level2	     (pds[11])
#define  PDS_Level	     GET_UINT2(pds[10], pds[11])
#define  PDS_Year            GET_INT1(pds[12])
#define  PDS_Month           GET_UINT1(pds[13])
#define  PDS_Day             GET_UINT1(pds[14])
#define  PDS_Hour            GET_UINT1(pds[15])
#define  PDS_Minute          GET_UINT1(pds[16])
#define  PDS_Date            (PDS_Year*10000+PDS_Month*100+PDS_Day)
#define  PDS_Time            (PDS_Hour*100+PDS_Minute)
#define  PDS_TimeUnit        GET_UINT1(pds[17])
#define  PDS_TimePeriod1     GET_UINT1(pds[18])
#define  PDS_TimePeriod2     GET_UINT1(pds[19])
#define  PDS_TimeRange       GET_UINT1(pds[20])
#define  PDS_AvgNum          GET_UINT2(pds[21], pds[22])
#define  PDS_AvgMiss         GET_UINT1(pds[23])
#define  PDS_Century         GET_UINT1(pds[24])
#define  PDS_Subcenter       GET_UINT1(pds[25])
#define  PDS_DecimalScale    GET_INT2(pds[26],pds[27])


/* GRIB1 Section 2: Grid Description Section (GDS) */

#define  GDS_Len             ((gds) == NULL ? 0 : GET_UINT3(gds[0], gds[1], gds[2]))
#define  GDS_NV              GET_UINT1(gds[ 3])
#define  GDS_PVPL            GET_UINT1(gds[ 4])
#define  GDS_PV	             ((gds[3] ==    0) ? -1 : (int) gds[4] - 1)
#define  GDS_PL	             ((gds[4] == 0xFF) ? -1 : (int) gds[3] * 4 + (int) gds[4] - 1)
#define  GDS_GridType        GET_UINT1(gds[ 5])


/* GRIB1 Triangular grid of DWD */
#define  GDS_GME_NI2         GET_UINT2(gds[ 6], gds[ 7])
#define  GDS_GME_NI3         GET_UINT2(gds[ 8], gds[ 9])
#define  GDS_GME_ND          GET_UINT3(gds[10], gds[11], gds[12])
#define  GDS_GME_NI          GET_UINT3(gds[13], gds[14], gds[15])
#define  GDS_GME_AFlag       GET_UINT1(gds[16])
#define  GDS_GME_LatPP       GET_INT3(gds[17], gds[18], gds[19])
#define  GDS_GME_LonPP       GET_INT3(gds[20], gds[21], gds[22])
#define  GDS_GME_LonMPL      GET_INT3(gds[23], gds[24], gds[25])
#define  GDS_GME_BFlag       GET_UINT1(gds[27])

/* GRIB1 Spectral */
#define  GDS_PentaJ          GET_UINT2(gds[ 6], gds[ 7])
#define  GDS_PentaK          GET_UINT2(gds[ 8], gds[ 9])
#define  GDS_PentaM          GET_UINT2(gds[10], gds[11])
#define  GDS_RepType         GET_UINT1(gds[12])
#define  GDS_RepMode         GET_UINT1(gds[13])

/* GRIB1 Regular grid */
#define  GDS_NumLon          GET_UINT2(gds[ 6], gds[ 7])
#define  GDS_NumLat          GET_UINT2(gds[ 8], gds[ 9])
#define  GDS_FirstLat        GET_INT3(gds[10], gds[11], gds[12])
#define  GDS_FirstLon        GET_INT3(gds[13], gds[14], gds[15])
#define  GDS_ResFlag         GET_UINT1(gds[16])
#define  GDS_LastLat         GET_INT3(gds[17], gds[18], gds[19])
#define  GDS_LastLon         GET_INT3(gds[20], gds[21], gds[22])
#define  GDS_LonIncr         GET_UINT2(gds[23], gds[24])
#define  GDS_LatIncr         GET_UINT2(gds[25], gds[26])
#define  GDS_NumPar          GET_UINT2(gds[25], gds[26])
#define  GDS_ScanFlag        GET_UINT1(gds[27])
#define  GDS_LatSP           GET_INT3(gds[32], gds[33], gds[34])
#define  GDS_LonSP           GET_INT3(gds[35], gds[36], gds[37])
#define  GDS_RotAngle        (GET_Real(&(gds[38])))

/* GRIB1 Lambert */
#define  GDS_Lambert_Lov     GET_INT3(gds[17], gds[18], gds[19])
#define  GDS_Lambert_dx	     GET_INT3(gds[20], gds[21], gds[22])
#define  GDS_Lambert_dy	     GET_INT3(gds[23], gds[24], gds[25])
#define  GDS_Lambert_ProjFlag GET_UINT1(gds[26])
#define  GDS_Lambert_LatS1   GET_INT3(gds[28], gds[29], gds[30])
#define  GDS_Lambert_LatS2   GET_INT3(gds[31], gds[32], gds[33])
#define  GDS_Lambert_LatSP   GET_INT3(gds[34], gds[35], gds[36])
#define  GDS_Lambert_LonSP   GET_INT3(gds[37], gds[37], gds[37])

/* GRIB1 Section 3: Bit Map Section (BMS) */

#define  BMS_Len	     ((bms) == NULL ? 0 : GET_UINT3(bms[0], bms[1], bms[2]))
#define  BMS_UnusedBits      (bms[3])
#define  BMS_Bitmap	     ((bms) == NULL ? NULL : (bms)+6)
#define  BMS_BitmapSize      (((((bms[0]<<16)+(bms[1]<<8)+bms[2]) - 6)<<3) - bms[3])

/* GRIB1 Section 4: Binary Data Section (BDS) */

#define  BDS_Len	    GET_UINT3(bds[0], bds[1], bds[2])
#define  BDS_Flag	    (bds[3])
#define  BDS_BinScale       GET_INT2(bds[ 4], bds[ 5])
#define  BDS_RefValue       (decfp2((int)bds[ 6], (int)(GET_UINT3(bds[7], bds[8], bds[9]))))
#define  BDS_NumBits        ((int) bds[10])
#define  BDS_RealCoef       (decfp2((int)bds[zoff+11], (int)(GET_UINT3(bds[zoff+12], bds[zoff+13], bds[zoff+14]))))
#define  BDS_PackData       ((int) ((bds[zoff+11]<<8) + bds[zoff+12]))
#define  BDS_Power          GET_INT2(bds[zoff+13], bds[zoff+14])
#define  BDS_Z              (bds[13])

/* GRIB1 Section 5: End Section (ES) */

/* GRIB2 */

#define  GRIB2_SECLEN(section)   (GET_UINT4(section[0], section[1], section[2], section[3]))
#define  GRIB2_SECNUM(section)   (GET_UINT1(section[4]))

// clang-format on

#endif /* GRIBDECODE_H */
#ifndef CGRIBEX_GRIB_ENCODE_H
#define CGRIBEX_GRIB_ENCODE_H

#include <limits.h>

// clang-format off

#define PutnZero(n) \
{ \
  for ( size_t i___ = z >= 0 ? (size_t)z : 0; i___ < (size_t)(z+n); i___++ ) lGrib[i___] = 0; \
  z += n; \
}

#define Put1Byte(Value)  (lGrib[z++] = (GRIBPACK)(Value))
#define Put2Byte(Value) ((lGrib[z++] = (GRIBPACK)((Value) >>  8)),      \
                         (lGrib[z++] = (GRIBPACK)(Value)))
#define Put3Byte(Value) ((lGrib[z++] = (GRIBPACK)((Value) >> 16)),      \
                         (lGrib[z++] = (GRIBPACK)((Value) >>  8)),      \
                         (lGrib[z++] = (GRIBPACK)(Value)))
#define Put4Byte(Value) ((lGrib[z++] = (GRIBPACK)((Value) >> 24)),      \
                         (lGrib[z++] = (GRIBPACK)((Value) >> 16)),      \
                         (lGrib[z++] = (GRIBPACK)((Value) >>  8)),      \
                         (lGrib[z++] = (GRIBPACK)(Value)))

#define Put1Int(Value)  {ival = Value; if ( ival < 0 ) ival =     0x80 - ival; Put1Byte(ival);}
#define Put2Int(Value)  {ival = Value; if ( ival < 0 ) ival =   0x8000 - ival; Put2Byte(ival);}
#define Put3Int(Value)  {ival = Value; if ( ival < 0 ) ival = 0x800000 - ival; Put3Byte(ival);}

enum {
  BitsPerInt = (int) (sizeof(int) * CHAR_BIT),
};


#define Put1Real(Value)          \
{                                \
  confp3(Value, &exponent, &mantissa, BitsPerInt, 1); \
  Put1Byte(exponent);            \
  Put3Byte(mantissa);            \
}

// clang-format on

#endif /* CGRIBEX_GRIB_ENCODE_H */
#ifndef CODEC_COMMON_H
#define CODEC_COMMON_H
#define gribSwapByteOrder_uint16(ui16) ((uint16_t) ((ui16 << 8) | (ui16 >> 8)))
#endif /* CODEC_COMMON_H */
/*
icc -g -Wall -O3 -march=native -std=c99 -qopt-report=5 -DTEST_MINMAXVAL -qopenmp -DOMP_SIMD minmax_val.c
 result on hama2 (icc 16.0.0):
     float:
minmax_val: fmin: -500000  fmax: 499999  time:   1.22s
simd      : fmin: -500000  fmax: 499999  time:   1.20s
    double:
minmax_val: fmin: -500000  fmax: 499999  time:   2.86s
orig      : fmin: -500000  fmax: 499999  time:   2.74s
simd      : fmin: -500000  fmax: 499999  time:   2.70s
avx       : fmin: -500000  fmax: 499999  time:   2.99s

gcc -g -Wall -O3 -march=native -std=c99 -DTEST_MINMAXVAL -fopenmp -DOMP_SIMD -Wa,-q minmax_val.c
 result on thunder5 (gcc 6.1.0):
float:
minmax_val: fmin: -500000  fmax: 499999  time:   8.25s
  simd    : fmin: -500000  fmax: 499999  time:   1.24s
double:
minmax_val: fmin: -500000  fmax: 499999  time:   2.73s
  orig    : fmin: -500000  fmax: 499999  time:   9.24s
  simd    : fmin: -500000  fmax: 499999  time:   2.78s
  avx     : fmin: -500000  fmax: 499999  time:   2.90s

gcc -g -Wall -O3 -march=native -std=c99 -DTEST_MINMAXVAL minmax_val.c
 result on bailung (gcc 4.8.2):
  orig    : fmin: -500000  fmax: 499999  time:   4.82s
  sse2    : fmin: -500000  fmax: 499999  time:   4.83s

gcc -g -Wall -O3 -march=native -std=c99 -DTEST_MINMAXVAL -fopenmp -DOMP_SIMD -Wa,-q minmax_val.c
 result on thunder5 (gcc 4.8.2):
  orig    : fmin: -500000  fmax: 499999  time:   3.10s
  simd    : fmin: -500000  fmax: 499999  time:   3.10s # omp simd in gcc 4.9
  avx     : fmin: -500000  fmax: 499999  time:   2.84s

icc -g -Wall -O3 -march=native -std=c99 -qopt-report=5 -DTEST_MINMAXVAL -openmp -DOMP_SIMD minmax_val.c
 result on thunder5 (icc 14.0.2):
  orig    : fmin: -500000  fmax: 499999  time:   2.83s
  simd    : fmin: -500000  fmax: 499999  time:   2.83s
  avx     : fmin: -500000  fmax: 499999  time:   2.92s

xlc_r -g -O3 -qhot -q64 -qarch=auto -qtune=auto -qreport -DTEST_MINMAXVAL minmax_val.c
 result on blizzard (xlc 12):
  orig    : fmin: -500000  fmax: 499999  time:   7.26s
  pwr6u6  : fmin: -500000  fmax: 499999  time:   5.92s
*/
#ifdef _ARCH_PWR6
#pragma options nostrict
#endif

#ifdef OMP_SIMD
#include <omp.h>
#endif

#include <stdlib.h>

// #undef _GET_X86_COUNTER
// #undef _GET_IBM_COUNTER
// #undef _GET_MACH_COUNTER
// #undef _ARCH_PWR6

#if defined(_GET_IBM_COUNTER)
#include <libhpc.h>
#elif defined(_GET_X86_COUNTER)
#include <x86intrin.h>
#elif defined(_GET_MACH_COUNTER)
#include <mach/mach_time.h>
#endif

#if defined(__GNUC__) && !defined(__ICC) && !defined(__clang__)
#if (__GNUC__ >= 4) && (__GNUC_MINOR__ >= 4)
#define GNUC_PUSH_POP
#endif
#endif

#ifndef DISABLE_SIMD
#if defined(__GNUC__) && (__GNUC__ >= 4)
#elif defined(__ICC) && (__ICC >= 1100)
#elif defined(__clang__)
#else
#define DISABLE_SIMD
#endif
#endif

#ifdef DISABLE_SIMD
#define DISABLE_SIMD_MINMAXVAL
#endif

#ifndef TEST_MINMAXVAL
#define DISABLE_SIMD_MINMAXVAL
#endif

#ifdef DISABLE_SIMD_MINMAXVAL
#ifdef ENABLE_AVX
#define _ENABLE_AVX
#endif
#ifdef ENABLE_SSE2
#define _ENABLE_SSE2
#endif
#endif

#ifndef DISABLE_SIMD_MINMAXVAL
#ifdef __AVX__
#define _ENABLE_AVX
#endif
#ifdef __SSE2__
#define _ENABLE_SSE2
#endif
#endif

#include <float.h>
#include <stdint.h>
#include <inttypes.h>

#if defined(_ENABLE_AVX)
#include <immintrin.h>
#elif defined(_ENABLE_SSE2)
#include <emmintrin.h>
#endif

#if defined(_ENABLE_AVX)

static void
avx_minmax_val_double(const double *restrict buf, size_t nframes, double *min, double *max)
{
  double fmin[4], fmax[4];
  __m256d current_max, current_min, work;

  // load max and min values into all four slots of the YMM registers
  current_min = _mm256_set1_pd(*min);
  current_max = _mm256_set1_pd(*max);

  // Work input until "buf" reaches 32 byte alignment
  while (((unsigned long) buf) % 32 != 0 && nframes > 0)
  {

    // Load the next double into the work buffer
    work = _mm256_set1_pd(*buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf++;
    nframes--;
  }

  while (nframes >= 16)
  {

    (void) _mm_prefetch((const char *) (buf + 8), _MM_HINT_NTA);

    work = _mm256_load_pd(buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf += 4;

    work = _mm256_load_pd(buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf += 4;

    (void) _mm_prefetch((const char *) (buf + 8), _MM_HINT_NTA);

    work = _mm256_load_pd(buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf += 4;

    work = _mm256_load_pd(buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf += 4;
    nframes -= 16;
  }

  // work through aligned buffers
  while (nframes >= 4)
  {
    work = _mm256_load_pd(buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf += 4;
    nframes -= 4;
  }

  // work through the remainung values
  while (nframes > 0)
  {
    work = _mm256_set1_pd(*buf);
    current_min = _mm256_min_pd(current_min, work);
    current_max = _mm256_max_pd(current_max, work);
    buf++;
    nframes--;
  }

  // find min & max value through shuffle tricks

  work = current_min;
  work = _mm256_shuffle_pd(work, work, 5);
  work = _mm256_min_pd(work, current_min);
  current_min = work;
  work = _mm256_permute2f128_pd(work, work, 1);
  work = _mm256_min_pd(work, current_min);
  _mm256_storeu_pd(fmin, work);

  work = current_max;
  work = current_max;
  work = _mm256_shuffle_pd(work, work, 5);
  work = _mm256_max_pd(work, current_max);
  current_max = work;
  work = _mm256_permute2f128_pd(work, work, 1);
  work = _mm256_max_pd(work, current_max);
  _mm256_storeu_pd(fmax, work);

  *min = fmin[0];
  *max = fmax[0];

  return;
}

#elif defined(_ENABLE_SSE2)

static void
sse2_minmax_val_double(const double *restrict buf, size_t nframes, double *min, double *max)
{
  __m128d current_max, current_min, work;

  // load starting max and min values into all slots of the XMM registers
  current_min = _mm_set1_pd(*min);
  current_max = _mm_set1_pd(*max);

  // work on input until buf reaches 16 byte alignment
  while (((unsigned long) buf) % 16 != 0 && nframes > 0)
  {

    // load one double and replicate
    work = _mm_set1_pd(*buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf++;
    nframes--;
  }

  while (nframes >= 8)
  {
    // use 64 byte prefetch for double octetts
    // __builtin_prefetch(buf+64,0,0); // for GCC 4.3.2 +

    work = _mm_load_pd(buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf += 2;
    work = _mm_load_pd(buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf += 2;
    work = _mm_load_pd(buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf += 2;
    work = _mm_load_pd(buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf += 2;
    nframes -= 8;
  }

  // work through smaller chunks of aligned buffers without prefetching
  while (nframes >= 2)
  {
    work = _mm_load_pd(buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf += 2;
    nframes -= 2;
  }

  // work through the remaining value
  while (nframes > 0)
  {
    // load the last double and replicate
    work = _mm_set1_pd(*buf);
    current_min = _mm_min_pd(current_min, work);
    current_max = _mm_max_pd(current_max, work);
    buf++;
    nframes--;
  }

  // find final min and max value through shuffle tricks
  work = current_min;
  work = _mm_shuffle_pd(work, work, _MM_SHUFFLE2(0, 1));
  work = _mm_min_pd(work, current_min);
  _mm_store_sd(min, work);
  work = current_max;
  work = _mm_shuffle_pd(work, work, _MM_SHUFFLE2(0, 1));
  work = _mm_max_pd(work, current_max);
  _mm_store_sd(max, work);

  return;
}

#endif  // SIMD

#if defined(_ARCH_PWR6)
static void
pwr6_minmax_val_double_unrolled6(const double *restrict data, size_t datasize, double *fmin, double *fmax)
{
#define __UNROLL_DEPTH_1 6

  // to allow pipelining we have to unroll

  {
    size_t residual = datasize % __UNROLL_DEPTH_1;
    size_t ofs = datasize - residual;
    double dmin[__UNROLL_DEPTH_1];
    double dmax[__UNROLL_DEPTH_1];

    for (size_t j = 0; j < __UNROLL_DEPTH_1; ++j)
    {
      dmin[j] = data[0];
      dmax[j] = data[0];
    }

    for (size_t i = 0; i < datasize - residual; i += __UNROLL_DEPTH_1)
    {
      for (size_t j = 0; j < __UNROLL_DEPTH_1; ++j)
      {
        dmin[j] = __fsel(dmin[j] - data[i + j], data[i + j], dmin[j]);
        dmax[j] = __fsel(data[i + j] - dmax[j], data[i + j], dmax[j]);
      }
    }

    for (size_t j = 0; j < residual; ++j)
    {
      dmin[j] = __fsel(dmin[j] - data[ofs + j], data[ofs + j], dmin[j]);
      dmax[j] = __fsel(data[ofs + j] - dmax[j], data[ofs + j], dmax[j]);
    }

    for (size_t j = 0; j < __UNROLL_DEPTH_1; ++j)
    {
      *fmin = __fsel(*fmin - dmin[j], dmin[j], *fmin);
      *fmax = __fsel(dmax[j] - *fmax, dmax[j], *fmax);
    }
  }
#undef __UNROLL_DEPTH_1
}
#endif

// clang-format off
#if defined(TEST_MINMAXVAL) && defined(__GNUC__)
static void minmax_val_double_orig(const double *restrict data, size_t datasize, double *fmin, double *fmax) __attribute__((noinline));
static void minmax_val_double_simd(const double *restrict data, size_t datasize, double *fmin, double *fmax) __attribute__((noinline));
static void minmax_val_double_omp(const double *restrict data, size_t datasize, double *fmin, double *fmax) __attribute__((noinline));
static void minmax_val_float(const float *restrict data, long datasize, float *fmin, float *fmax) __attribute__((noinline));
static void minmax_val_float_simd(const float *restrict data, size_t datasize, float *fmin, float *fmax) __attribute__((noinline));
#endif
// clang-format on

#if defined(GNUC_PUSH_POP) && defined __OPTIMIZE__
#pragma GCC push_options
#pragma GCC optimize("O3", "fast-math")
#endif
static void
minmax_val_double_orig(const double *restrict data, size_t datasize, double *fmin, double *fmax)
{
  double dmin = *fmin, dmax = *fmax;

#if defined(CRAY)
#pragma _CRI ivdep
#elif defined(SX)
#pragma vdir nodep
#elif defined(__uxp__)
#pragma loop novrec
#elif defined(__ICC)
#pragma ivdep
#endif
  for (size_t i = 0; i < datasize; ++i)
  {
    dmin = (dmin < data[i]) ? dmin : data[i];
    dmax = (dmax > data[i]) ? dmax : data[i];
  }

  *fmin = dmin;
  *fmax = dmax;
}

static void
minmax_val_float(const float *restrict data, long idatasize, float *fmin, float *fmax)
{
  size_t datasize = (size_t) idatasize;
  float dmin = *fmin, dmax = *fmax;

#if defined(CRAY)
#pragma _CRI ivdep
#elif defined(SX)
#pragma vdir nodep
#elif defined(__uxp__)
#pragma loop novrec
#elif defined(__ICC)
#pragma ivdep
#endif
  for (size_t i = 0; i < datasize; ++i)
  {
    dmin = (dmin < data[i]) ? dmin : data[i];
    dmax = (dmax > data[i]) ? dmax : data[i];
  }

  *fmin = dmin;
  *fmax = dmax;
}
#if defined(GNUC_PUSH_POP) && defined __OPTIMIZE__
#pragma GCC pop_options
#endif

// TEST
#if defined(OMP_SIMD)

#if defined(GNUC_PUSH_POP) && defined __OPTIMIZE__
#pragma GCC push_options
#pragma GCC optimize("O3", "fast-math")
#endif
static void
minmax_val_double_omp(const double *restrict data, size_t datasize, double *fmin, double *fmax)
{
  double dmin = *fmin, dmax = *fmax;

#if defined(_OPENMP)
#pragma omp parallel for simd reduction(min : dmin) reduction(max : dmax)
#endif
  for (size_t i = 0; i < datasize; ++i)
  {
    dmin = (dmin < data[i]) ? dmin : data[i];
    dmax = (dmax > data[i]) ? dmax : data[i];
  }

  *fmin = dmin;
  *fmax = dmax;
}

static void
minmax_val_double_simd(const double *restrict data, size_t datasize, double *fmin, double *fmax)
{
  double dmin = *fmin, dmax = *fmax;

#ifdef _OPENMP
#pragma omp simd reduction(min : dmin) reduction(max : dmax)
#endif
  for (size_t i = 0; i < datasize; ++i)
  {
    dmin = (dmin < data[i]) ? dmin : data[i];
    dmax = (dmax > data[i]) ? dmax : data[i];
  }

  *fmin = dmin;
  *fmax = dmax;
}

static void
minmax_val_float_simd(const float *restrict data, size_t datasize, float *fmin, float *fmax)
{
  float dmin = *fmin, dmax = *fmax;

#if defined(_OPENMP)
#pragma omp simd reduction(min : dmin) reduction(max : dmax)
#endif
  for (size_t i = 0; i < datasize; ++i)
  {
    dmin = (dmin < data[i]) ? dmin : data[i];
    dmax = (dmax > data[i]) ? dmax : data[i];
  }

  *fmin = dmin;
  *fmax = dmax;
}
#if defined(GNUC_PUSH_POP) && defined __OPTIMIZE__
#pragma GCC pop_options
#endif
#endif

static void
minmax_val_double(const double *restrict data, long idatasize, double *fmin, double *fmax)
{
#if defined(_GET_X86_COUNTER) || defined(_GET_MACH_COUNTER)
  uint64_t start_minmax, end_minmax;
#endif
  size_t datasize = (size_t) idatasize;

  if (idatasize >= 1)
    ;
  else
    return;

#if defined(_GET_X86_COUNTER)
  start_minmax = _rdtsc();
#endif
#if defined(_GET_MACH_COUNTER)
  start_minmax = mach_absolute_time();
#endif

#if defined(_ENABLE_AVX)

  avx_minmax_val_double(data, datasize, fmin, fmax);

#elif defined(_ENABLE_SSE2)

  sse2_minmax_val_double(data, datasize, fmin, fmax);

#else

#if defined(_ARCH_PWR6)
#define __UNROLL_DEPTH_1 6

    // to allow pipelining we have to unroll

#if defined(_GET_IBM_COUNTER)
  hpmStart(1, "minmax fsel");
#endif

  pwr6_minmax_val_double_unrolled6(data, datasize, fmin, fmax);

#if defined(_GET_IBM_COUNTER)
  hpmStop(1);
#endif

#undef __UNROLL_DEPTH_1

#else  // original loop

#if defined(_GET_IBM_COUNTER)
  hpmStart(1, "minmax base");
#endif

  minmax_val_double_orig(data, datasize, fmin, fmax);

#if defined(_GET_IBM_COUNTER)
  hpmStop(1);
#endif

#endif  // _ARCH_PWR6 && original loop
#endif  // SIMD

#if defined(_GET_X86_COUNTER) || defined(_GET_MACH_COUNTER)
#if defined(_GET_X86_COUNTER)
  end_minmax = _rdtsc();
#endif
#if defined(_GET_MACH_COUNTER)
  end_minmax = mach_absolute_time();
#endif
#if defined(_ENABLE_AVX)
  printf("AVX minmax cycles:: %" PRIu64 "\n", end_minmax - start_minmax);
  fprintf(stderr, "AVX min: %lf max: %lf\n", *fmin, *fmax);
#elif defined(_ENABLE_SSE2)
  printf("SSE2 minmax cycles:: %" PRIu64 "\n", end_minmax - start_minmax);
  fprintf(stderr, "SSE2 min: %lf max: %lf\n", *fmin, *fmax);
#else
  printf("loop minmax cycles:: %" PRIu64 "\n", end_minmax - start_minmax);
  fprintf(stderr, "loop min: %lf max: %lf\n", *fmin, *fmax);
#endif
#endif

  return;
}

#if defined(TEST_MINMAXVAL)

#include <stdio.h>
#include <sys/time.h>

static double
dtime()
{
  double tseconds = 0.0;
  struct timeval mytime;
  gettimeofday(&mytime, NULL);
  tseconds = (double) (mytime.tv_sec + (double) mytime.tv_usec * 1.0e-6);
  return (tseconds);
}

#define NRUN 10000

int
main(void)
{
  long datasize = 1000000;
  double t_begin, t_end;

  printf("datasize %ld\n", datasize);
#if defined(_OPENMP)
  printf("_OPENMP=%d\n", _OPENMP);
#endif

#if defined(__ICC)
  printf("icc\n");
#elif defined(__clang__)
  printf("clang\n");
#elif defined(__GNUC__)
  printf("gcc\n");
#endif

  {
    float fmin, fmax;
    float *data_sp = (float *) malloc(datasize * sizeof(float));

    for (long i = 0; i < datasize / 2; ++i) data_sp[i] = (float) (i);
    for (long i = datasize / 2; i < datasize; ++i) data_sp[i] = (float) (-datasize + i);

    printf("float:\n");

    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_sp[0];
      minmax_val_float(data_sp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("minmax_val: fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);

#if defined(OMP_SIMD)
    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_sp[0];
      minmax_val_float_simd(data_sp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("simd      : fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);
#endif

    free(data_sp);
  }

  {
    double fmin, fmax;
    double *data_dp = (double *) malloc(datasize * sizeof(double));

    // for (long i = datasize-1; i >= 0; --i) data[i] = (double) (-datasize/2 + i);
    for (long i = 0; i < datasize / 2; ++i) data_dp[i] = (double) (i);
    for (long i = datasize / 2; i < datasize; ++i) data_dp[i] = (double) (-datasize + i);

    printf("double:\n");

    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      minmax_val_double(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("minmax_val: fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);

    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      minmax_val_double_orig(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("orig      : fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);

#if defined(OMP_SIMD)
    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      minmax_val_double_simd(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("simd      : fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);

    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      minmax_val_double_omp(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("openmp %d  : fmin: %ld  fmax: %ld  time: %6.2fs\n", omp_get_max_threads(), (long) fmin, (long) fmax, t_end - t_begin);
#endif

#if defined(_ENABLE_AVX)
    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      avx_minmax_val_double(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("avx       : fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);
#elif defined(_ENABLE_SSE2)
    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      sse2_minmax_val_double(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("sse2      : fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);
#endif
#if defined(_ARCH_PWR6)
    t_begin = dtime();
    for (int i = 0; i < NRUN; ++i)
    {
      fmin = fmax = data_dp[0];
      pwr6_minmax_val_double_unrolled6(data_dp, datasize, &fmin, &fmax);
    }
    t_end = dtime();
    printf("pwr6u6  : fmin: %ld  fmax: %ld  time: %6.2fs\n", (long) fmin, (long) fmax, t_end - t_begin);
#endif
    free(data_dp);
  }

  return 0;
}
#endif  // TEST_MINMAXVAL

#undef DISABLE_SIMD_MINMAXVAL
#undef _ENABLE_AVX
#undef _ENABLE_SSE2
#undef GNUC_PUSH_POP
/*
### new version with gribSwapByteOrder_uint16()
icc -g -Wall -O3 -march=native -std=c99 -qopt-report=5 -DTEST_ENCODE encode_array.c
 result on hama2 (icc 16.0.2):
   float:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 1.8731s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 2.0898s
  double:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 3.68089s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 4.30798s
     avx: val1: 1  val2: 1  val3: 2  valn: 66  time: 4.23864s

gcc -g -Wall -O3 -march=native -Wa,-q -std=c99 -DTEST_ENCODE encode_array.c
 result on hama2 (gcc 6.1.0):
float:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 2.22871s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 2.30281s
double:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 4.2669s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 4.81643s
     avx: val1: 1  val2: 1  val3: 2  valn: 66  time: 3.98415s

###
icc -g -Wall -O3 -march=native -std=c99 -qopt-report=5 -DTEST_ENCODE encode_array.c
 result on hama2 (icc 16.0.0):
   float:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 9.10691s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 8.63584s
  double:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 13.5768s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 9.17742s
     avx: val1: 1  val2: 1  val3: 2  valn: 66  time: 3.9488s

gcc -g -Wall -O3 -std=c99 -DTEST_ENCODE encode_array.c
 result on hama2 (gcc 5.2.0):
   float:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 5.32775s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 7.87125s
  double:
    orig: val1: 1  val2: 1  val3: 2  valn: 66  time: 7.85873s
unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time: 12.9979s

###
gcc -g -Wall -O3 -march=native -std=c99 -DTEST_ENCODE encode_array.c
 result on bailung (gcc 4.7):
  orig    : val1: 1  val2: 1  val3: 2  valn: 66  time: 8.4166s
  sse41   : val1: 1  val2: 1  val3: 2  valn: 66  time: 7.1522s

gcc -g -Wall -O3 -march=native -std=c99 -DTEST_ENCODE encode_array.c
 result on thunder5 (gcc 4.7):
  orig    : val1: 1  val2: 1  val3: 2  valn: 66  time: 6.21976s
  avx     : val1: 1  val2: 1  val3: 2  valn: 66  time: 4.54485s

icc -g -Wall -O3 -march=native -std=c99 -vec-report=1 -DTEST_ENCODE encode_array.c
 result on thunder5 (icc 13.2):
  orig    : val1: 1  val2: 1  val3: 2  valn: 66  time: 14.6279s
  avx     : val1: 1  val2: 1  val3: 2  valn: 66  time:  4.9776s

xlc_r -g -O3 -qhot -q64 -qarch=auto -qtune=auto -qreport -DTEST_ENCODE encode_array.c
 result on blizzard (xlc 12):
  orig    : val1: 1  val2: 1  val3: 2  valn: 66  time: 132.25s
  unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time:  27.202s
  orig    : val1: 1  val2: 1  val3: 2  valn: 66  time: 106.627s  // without -qhot
  unrolled: val1: 1  val2: 1  val3: 2  valn: 66  time:  39.929s  // without -qhot
*/
#ifdef _ARCH_PWR6
#pragma options nostrict
#endif

#ifdef TEST_ENCODE
#include <stdio.h>
#include <stdlib.h>
#define GRIBPACK unsigned char

#ifndef HOST_ENDIANNESS
#ifdef __cplusplus
static const uint32_t HOST_ENDIANNESS_temp[1] = { UINT32_C(0x00030201) };
#define HOST_ENDIANNESS (((const unsigned char *) HOST_ENDIANNESS_temp)[0])
#else
#define HOST_ENDIANNESS (((const unsigned char *) &(const uint32_t[1]){ UINT32_C(0x00030201) })[0])
#endif
#endif

#define IS_BIGENDIAN() (HOST_ENDIANNESS == 0)
#define Error(x, y)
#endif

// #undef _GET_X86_COUNTER
// #undef _GET_MACH_COUNTER
// #undef _GET_IBM_COUNTER
// #undef _ARCH_PWR6

#if defined _GET_IBM_COUNTER
#include <libhpc.h>
#elif defined _GET_X86_COUNTER
#include <x86intrin.h>
#elif defined _GET_MACH_COUNTER
#include <mach/mach_time.h>
#endif

#include <stdint.h>
#include <math.h>

#ifndef DISABLE_SIMD
#if defined(__GNUC__) && (__GNUC__ >= 4)
#elif defined(__ICC) && (__ICC >= 1100)
#elif defined(__clang__)
#else
#define DISABLE_SIMD
#endif
#endif

#ifdef DISABLE_SIMD
#define DISABLE_SIMD_ENCODE
#endif

// #define DISABLE_SIMD_ENCODE

#ifdef DISABLE_SIMD_ENCODE
#ifdef ENABLE_AVX
#define _ENABLE_AVX
#endif
#ifdef ENABLE_SSE4_1
#define _ENABLE_SSE4_1
#endif
#endif

#ifndef DISABLE_SIMD_ENCODE
#ifdef __AVX__
#define _ENABLE_AVX
#endif
#ifdef __SSE4_1__
#define _ENABLE_SSE4_1
#endif
#endif

#if defined _ENABLE_AVX
#include <immintrin.h>
#elif defined _ENABLE_SSE4_1
#include <smmintrin.h>
#endif

#if defined _ENABLE_AVX

static void avx_encode_array_2byte_double(size_t datasize, unsigned char *restrict lGrib, const double *restrict data, double zref,
                                          double factor, size_t *gz) __attribute__((optimize(2)));
static void
avx_encode_array_2byte_double(size_t datasize, unsigned char *restrict lGrib, const double *restrict data, double zref,
                              double factor, size_t *gz)
{
  const double *dval = data;
  __m128i *sgrib = (__m128i *) (lGrib + (*gz));

  const __m128i swap = _mm_set_epi8(14, 15, 12, 13, 10, 11, 8, 9, 6, 7, 4, 5, 2, 3, 0, 1);

  const __m256d c0 = _mm256_set1_pd(zref);
  const __m256d c1 = _mm256_set1_pd(factor);
  const __m256d c2 = _mm256_set1_pd(0.5);

  __m256d d0, d3, d2, d1;
  __m128i i0, i1, i2, i3;
  __m128i s0, s1;

  size_t residual = datasize % 16;

  size_t i;
  for (i = 0; i < (datasize - residual); i += 16)
  {
    (void) _mm_prefetch((const char *) (dval + 8), _MM_HINT_NTA);
    //_____________________________________________________________________________

    d0 = _mm256_loadu_pd(dval);
    d0 = _mm256_sub_pd(d0, c0);
    d0 = _mm256_mul_pd(d0, c1);
    d0 = _mm256_add_pd(d0, c2);

    i0 = _mm256_cvttpd_epi32(d0);

    //_____________________________________________________________________________

    d1 = _mm256_loadu_pd(dval + 4);
    d1 = _mm256_sub_pd(d1, c0);
    d1 = _mm256_mul_pd(d1, c1);
    d1 = _mm256_add_pd(d1, c2);

    i1 = _mm256_cvttpd_epi32(d1);

    //_____________________________________________________________________________

    s0 = _mm_packus_epi32(i0, i1);
    s0 = _mm_shuffle_epi8(s0, swap);
    (void) _mm_storeu_si128(sgrib, s0);

    //_____________________________________________________________________________

    (void) _mm_prefetch((const char *) (dval + 16), _MM_HINT_NTA);

    //_____________________________________________________________________________

    d2 = _mm256_loadu_pd(dval + 8);
    d2 = _mm256_sub_pd(d2, c0);
    d2 = _mm256_mul_pd(d2, c1);
    d2 = _mm256_add_pd(d2, c2);

    i2 = _mm256_cvttpd_epi32(d2);

    //_____________________________________________________________________________

    d3 = _mm256_loadu_pd(dval + 12);
    d3 = _mm256_sub_pd(d3, c0);
    d3 = _mm256_mul_pd(d3, c1);
    d3 = _mm256_add_pd(d3, c2);

    i3 = _mm256_cvttpd_epi32(d3);

    //_____________________________________________________________________________

    s1 = _mm_packus_epi32(i2, i3);
    s1 = _mm_shuffle_epi8(s1, swap);
    (void) _mm_storeu_si128(sgrib + 1, s1);

    //_____________________________________________________________________________

    dval += 16;
    sgrib += 2;
  }

  if (i != datasize)
  {
    uint16_t ui16;
    for (size_t j = i; j < datasize; ++j)
    {
      ui16 = (uint16_t) ((data[j] - zref) * factor + 0.5);
      lGrib[*gz + 2 * j] = ui16 >> 8;
      lGrib[*gz + 2 * j + 1] = ui16;
    }
  }

  *gz += 2 * datasize;

  return;
}

#define grib_encode_array_2byte_double avx_encode_array_2byte_double

#elif defined _ENABLE_SSE4_1

static void
sse41_encode_array_2byte_double(size_t datasize, unsigned char *restrict lGrib, const double *restrict data, double zref,
                                double factor, size_t *gz)
{
  const double *dval = data;
  __m128i *sgrib = (__m128i *) (lGrib + (*gz));

  const __m128i swap = _mm_set_epi8(14, 15, 12, 13, 10, 11, 8, 9, 6, 7, 4, 5, 2, 3, 0, 1);

  const __m128d c0 = _mm_set1_pd(zref);
  const __m128d c1 = _mm_set1_pd(factor);
  const __m128d c2 = _mm_set1_pd(0.5);

  __m128d d0, d4, d3, d2, d1;
  __m128i i0, i1, i2, i3, i4;
  __m128i s0, s1;

  size_t residual = datasize % 16;

  size_t i;
  for (i = 0; i < (datasize - residual); i += 16)
  {
    (void) _mm_prefetch((const char *) (dval + 8), _MM_HINT_NTA);
    //_____________________________________________________________________________

    d0 = _mm_loadu_pd(dval);
    d0 = _mm_sub_pd(d0, c0);
    d0 = _mm_mul_pd(d0, c1);
    d0 = _mm_add_pd(d0, c2);

    d4 = _mm_loadu_pd(dval + 2);
    d4 = _mm_sub_pd(d4, c0);
    d4 = _mm_mul_pd(d4, c1);
    d4 = _mm_add_pd(d4, c2);

    i0 = _mm_cvttpd_epi32(d0);
    i4 = _mm_cvttpd_epi32(d4);
    i0 = _mm_unpacklo_epi64(i0, i4);

    //_____________________________________________________________________________

    d1 = _mm_loadu_pd(dval + 4);
    d1 = _mm_sub_pd(d1, c0);
    d1 = _mm_mul_pd(d1, c1);
    d1 = _mm_add_pd(d1, c2);

    d4 = _mm_loadu_pd(dval + 6);
    d4 = _mm_sub_pd(d4, c0);
    d4 = _mm_mul_pd(d4, c1);
    d4 = _mm_add_pd(d4, c2);

    i1 = _mm_cvttpd_epi32(d1);
    i4 = _mm_cvttpd_epi32(d4);
    i1 = _mm_unpacklo_epi64(i1, i4);

    //_____________________________________________________________________________

    s0 = _mm_packus_epi32(i0, i1);
    s0 = _mm_shuffle_epi8(s0, swap);
    (void) _mm_storeu_si128(sgrib, s0);

    //_____________________________________________________________________________

    (void) _mm_prefetch((const char *) (dval + 16), _MM_HINT_NTA);

    //_____________________________________________________________________________

    d2 = _mm_loadu_pd(dval + 8);
    d2 = _mm_sub_pd(d2, c0);
    d2 = _mm_mul_pd(d2, c1);
    d2 = _mm_add_pd(d2, c2);

    d4 = _mm_loadu_pd(dval + 10);
    d4 = _mm_sub_pd(d4, c0);
    d4 = _mm_mul_pd(d4, c1);
    d4 = _mm_add_pd(d4, c2);

    i2 = _mm_cvttpd_epi32(d2);
    i4 = _mm_cvttpd_epi32(d4);
    i2 = _mm_unpacklo_epi64(i2, i4);

    //_____________________________________________________________________________

    d3 = _mm_loadu_pd(dval + 12);
    d3 = _mm_sub_pd(d3, c0);
    d3 = _mm_mul_pd(d3, c1);
    d3 = _mm_add_pd(d3, c2);

    d4 = _mm_loadu_pd(dval + 14);
    d4 = _mm_sub_pd(d4, c0);
    d4 = _mm_mul_pd(d4, c1);
    d4 = _mm_add_pd(d4, c2);

    i3 = _mm_cvttpd_epi32(d3);
    i4 = _mm_cvttpd_epi32(d4);
    i3 = _mm_unpacklo_epi64(i3, i4);

    //_____________________________________________________________________________

    s1 = _mm_packus_epi32(i2, i3);
    s1 = _mm_shuffle_epi8(s1, swap);
    (void) _mm_storeu_si128(sgrib + 1, s1);

    //_____________________________________________________________________________

    dval += 16;
    sgrib += 2;
  }

  if (i != datasize)
  {
    uint16_t ui16;
    for (size_t j = i; j < datasize; ++j)
    {
      ui16 = (uint16_t) ((data[j] - zref) * factor + 0.5);
      lGrib[*gz + 2 * j] = ui16 >> 8;
      lGrib[*gz + 2 * j + 1] = ui16;
    }
  }

  *gz += 2 * datasize;

  return;
}

#define grib_encode_array_2byte_double sse41_encode_array_2byte_double

#else

#define grib_encode_array_2byte_double encode_array_2byte_double

#endif  // SIMD variants

#ifdef TEST_ENCODE

// clang-format off
#define CAT(X,Y)      X##_##Y
#define TEMPLATE(X,Y) CAT(X,Y)

#ifdef T
#undef T
#endif
#define T double

#ifdef T
#undef T
#endif
#define T float
// clang-format on

#include <sys/time.h>

static double
dtime()
{
  double tseconds = 0.0;
  struct timeval mytime;
  gettimeofday(&mytime, NULL);
  tseconds = (double) (mytime.tv_sec + (double) mytime.tv_usec * 1.0e-6);
  return (tseconds);
}

static void
pout(char *name, int s, unsigned char *lgrib, long datasize, double tt)
{
  printf("%8s: val1: %d  val2: %d  val3: %d  valn: %d  time: %gs\n", name, (int) lgrib[s * 1 + 1], (int) lgrib[s * 2 + 1],
         (int) lgrib[s * 3 + 1], (int) lgrib[2 * datasize - 1], tt);
}

int
main(void)
{
  enum
  {
    datasize = 1000000,
    NRUN = 10000,
  };

  double t_begin, t_end;

  float *dataf = (float *) malloc(datasize * sizeof(float));
  double *data = (double *) malloc(datasize * sizeof(double));
  unsigned char *lgrib = (unsigned char *) malloc(2 * datasize * sizeof(unsigned char));

  for (long i = 0; i < datasize; ++i) dataf[i] = (float) (-datasize / 2 + i);
  for (long i = 0; i < datasize; ++i) data[i] = (double) (-datasize / 2 + i);

  int PackStart = 0;
  int nbpv = 16;
  double zref = data[0];
  size_t z;
  double factor = 0.00390625;
  int s = 256;

  if (0)
  {
    encode_array_float(0, 0, 0, NULL, NULL, 0, 0, NULL);
    encode_array_double(0, 0, 0, NULL, NULL, 0, 0, NULL);
  }

#if defined(__ICC)
  printf("icc\n");
#elif defined(__clang__)
  printf("clang\n");
#elif defined(__GNUC__)
  printf("gcc\n");
#endif

  printf("float:\n");

  t_begin = dtime();
  for (int i = 0; i < NRUN; ++i)
  {
    z = 0;
    encode_array_2byte_float(datasize, lgrib, dataf, (float) zref, (float) factor, &z);
  }
  t_end = dtime();
  pout("orig", s, lgrib, datasize, t_end - t_begin);

  t_begin = dtime();
  for (int i = 0; i < NRUN; ++i)
  {
    z = 0;
    encode_array_unrolled_float(nbpv, PackStart, datasize, lgrib, dataf, (float) zref, (float) factor, &z);
  }
  t_end = dtime();
  pout("unrolled", s, lgrib, datasize, t_end - t_begin);

  printf("double:\n");

  t_begin = dtime();
  for (int i = 0; i < NRUN; ++i)
  {
    z = 0;
    encode_array_2byte_double(datasize, lgrib, data, zref, factor, &z);
  }
  t_end = dtime();
  pout("orig", s, lgrib, datasize, t_end - t_begin);

  t_begin = dtime();
  for (int i = 0; i < NRUN; ++i)
  {
    z = 0;
    encode_array_unrolled_double(nbpv, PackStart, datasize, lgrib, data, zref, factor, &z);
  }
  t_end = dtime();
  pout("unrolled", s, lgrib, datasize, t_end - t_begin);

#if defined _ENABLE_AVX
  t_begin = dtime();
  for (int i = 0; i < NRUN; ++i)
  {
    z = 0;
    avx_encode_array_2byte_double(datasize, lgrib, data, zref, factor, &z);
  }
  t_end = dtime();
  pout("avx", s, lgrib, datasize, t_end - t_begin);
#elif defined _ENABLE_SSE4_1
  t_begin = dtime();
  for (int i = 0; i < NRUN; ++i)
  {
    z = 0;
    sse41_encode_array_2byte_double(datasize, lgrib, data, zref, factor, &z);
  }
  t_end = dtime();
  pout("sse41", s, lgrib, datasize, t_end - t_begin);
#endif

  return 0;
}
#endif  // TEST_ENCODE

#undef DISABLE_SIMD_ENCODE
#undef _ENABLE_AVX
#undef _ENABLE_SSE4_1

void
confp3(double pval, int *kexp, int *kmant, int kbits, int kround)
{
  /*

    Purpose:
    --------

    Convert floating point number from machine
    representation to GRIB representation.

    Input Parameters:
    -----------------

       pval    - Floating point number to be converted.
       kbits   - Number of bits in computer word.
       kround  - Conversion type.
                 0 , Closest number in GRIB format less than
                     original number.
                 1 , Closest number in GRIB format to the
                     original number (equal to, greater than or
                     less than original number).

    Output Parameters:
    ------------------

       kexp    - 8 Bit signed exponent.
       kmant   - 24 Bit mantissa.

    Method:
    -------

    Floating point number represented as 8 bit signed
    exponent and 24 bit mantissa in integer values.

    Externals.
    ----------

    decfp2    - Decode from IBM floating point format.

    Reference:
    ----------

    WMO Manual on Codes re GRIB representation.

    Comments:
    ---------

    Routine aborts if an invalid conversion type parameter
    is used or if a 24 bit mantissa is not produced.

    Author:
    -------

    John Hennessy   ECMWF   18.06.91

    Modifications:
    --------------

    Uwe Schulzweida   MPIfM   01/04/2001

    Convert to C from EMOS library version 130

    Uwe Schulzweida   MPIfM   02/08/2002

     - speed up by factor 1.6 on NEC SX6
        - replace 1.0 / pow(16.0, (double)(iexp - 70)) by rpow16m70tab[iexp]
  */

  // extern int CGRIBEX_Debug;

  /* ----------------------------------------------------------------- */
  /*   Section 1 . Initialise                                          */
  /* ----------------------------------------------------------------- */

  // Check conversion type parameter.

  int iround = kround;
  if (iround != 0 && iround != 1)
  {
    Error("Invalid conversion type = %d", iround);

    // If not aborting, arbitrarily set rounding to 'up'.
    iround = 1;
  }

  /* ----------------------------------------------------------------- */
  /*   Section 2 . Convert value of zero.                              */
  /* ----------------------------------------------------------------- */

  if (fabs(pval) <= 0)
  {
    *kexp = 0;
    *kmant = 0;
    goto LABEL900;
  }

  /* ----------------------------------------------------------------- */
  /*   Section 3 . Convert other values.                               */
  /* ----------------------------------------------------------------- */
  {
    double zeps = (kbits != 32) ? 1.0e-12 : 1.0e-8;
    double zref = pval;

    // Sign of value.
    int isign = (zref >= 0.0) ? 0 : 128;
    zref = fabs(zref);

    // Exponent.
    int iexp = (int) (log(zref) / log(16.0) + 65.0 + zeps);

    // only ANSI C99 has log2
    // iexp = (int) (log2(zref) * 0.25 + 65.0 + zeps);

    if (iexp < 0) iexp = 0;
    if (iexp > 127) iexp = 127;

    // double rpowref = zref / pow(16.0, (double)(iexp - 70));
    double rpowref = ldexp(zref, 4 * -(iexp - 70));

    // Mantissa.
    if (iround == 0)
    {
      /*  Closest number in GRIB format less than original number. */
      /*  Truncate for positive numbers. */
      /*  Round up for negative numbers. */
      *kmant = (isign == 0) ? (int) rpowref : (int) lround(rpowref + 0.5);
    }
    else
    {
      /*  Closest number in GRIB format to the original number   */
      /*  (equal to, greater than or less than original number). */
      *kmant = (int) lround(rpowref);
    }

    /*  Check that mantissa value does not exceed 24 bits. */
    /*  If it does, adjust the exponent upwards and recalculate the mantissa. */
    /*  16777215 = 2**24 - 1 */
    if (*kmant > 16777215)
    {

    LABEL350:

      ++iexp;

      // Check for exponent overflow during adjustment
      if (iexp > 127)
      {
        Message("Exponent overflow");
        Message("Original number = %30.20f", pval);
        Message("Sign = %3d, Exponent = %3d, Mantissa = %12d", isign, iexp, *kmant);

        Error("Exponent overflow");

        // If not aborting, arbitrarily set value to zero
        Message("Value arbitrarily set to zero.");
        *kexp = 0;
        *kmant = 0;
        goto LABEL900;
      }

      rpowref = ldexp(zref, 4 * -(iexp - 70));

      if (iround == 0)
      {
        /*  Closest number in GRIB format less than original number. */
        /*  Truncate for positive numbers. */
        /*  Round up for negative numbers. */
        *kmant = (isign == 0) ? (int) rpowref : (int) lround(rpowref + 0.5);
      }
      else
      {
        /*  Closest number in GRIB format to the original number */
        /*  (equal to, greater or less than original number). */
        *kmant = (int) lround(rpowref);
      }

      // Repeat calculation (with modified exponent) if still have mantissa overflow.
      if (*kmant > 16777215) goto LABEL350;
    }

    // Add sign bit to exponent.
    *kexp = iexp + isign;
  }

  /* ----------------------------------------------------------------- */
  /*   Section 9. Return                                               */
  /* ----------------------------------------------------------------- */

LABEL900:
  /*
  if ( CGRIBEX_Debug )
    {
      double zval;

      Message("Conversion type parameter = %4d", kround);
      Message("Original number = %30.20f", pval);

      zval = decfp2(*kexp, *kmant);

      Message("Converted to      %30.20f", zval);
      Message("Sign = %3d, Exponent = %3d, Mantissa = %12d", isign, iexp, *kmant);
    }
  */
  return;
} /* confp3 */
#include <math.h>

double
decfp2(int kexp, int kmant)
{
  /*

    Purpose:
    --------

    Convert GRIB representation of a floating point
    number to machine representation.

    Input Parameters:
    -----------------

    kexp    - 8 Bit signed exponent.
    kmant   - 24 Bit mantissa.

    Output Parameters:
    ------------------

    Return value   - Floating point number represented
                     by kexp and kmant.

    Method:
    -------

    Floating point number represented as 8 bit exponent
    and 24 bit mantissa in integer values converted to
    machine floating point format.

    Externals:
    ----------

    None.

    Reference:
    ----------

    WMO Manual on Codes re GRIB representation.

    Comments:
    ---------

    Rewritten from DECFP, to conform to programming standards.
    Sign bit on 0 value now ignored, if present.
    If using 32 bit reals, check power of 16 is not so small as to
    cause overflows (underflows!); this causes warning to be given
    on Fujitsus.

    Author:
    -------

    John Hennessy   ECMWF   18.06.91

    Modifications:
    --------------

    Uwe Schulzweida   MPIfM   01/04/2001

     - Convert to C from EMOS library version 130

    Uwe Schulzweida   MPIfM   02/08/2002

     - speed up by factor 2 on NEC SX6
        - replace pow(2.0, -24.0) by constant POW_2_M24
        - replace pow(16.0, (double)(iexp - 64)) by pow16m64tab[iexp]
  */

  /* ----------------------------------------------------------------- */
  /*   Section 1 . Convert value of 0.0. Ignore sign bit.              */
  /* ----------------------------------------------------------------- */

  if ((kexp == 128) || (kexp == 0) || (kexp == 255)) return 0.0;

  /* ----------------------------------------------------------------- */
  /*   Section 2 . Convert other values.                               */
  /* ----------------------------------------------------------------- */

  //  Sign of value.

  int iexp = kexp;
  int isign = (iexp < 128) * 2 - 1;

  iexp -= iexp < 128 ? 0 : 128;

  //  Decode value.

  // double pval = isign * pow(2.0, -24.0) * kmant * pow(16.0, (double)(iexp - 64));

  iexp -= 64;

  double pval = ldexp(1.0, 4 * iexp) * isign * POW_2_M24 * kmant;

  /* ----------------------------------------------------------------- */
  /*   Section 9. Return to calling routine.                           */
  /* ----------------------------------------------------------------- */

  return pval;
}
#include <stdarg.h>
#include <stdint.h>

static void
gribDecodeRefDate(const int *isec1, int *year, int *month, int *day)
{
  int ryear = ISEC1_Year;

  int century = ISEC1_Century;
  if (century < 0) century = -century;
  century -= 1;

  if (century == -255 && ryear == 127) { ryear = 0; }
  else
  {
    // if ( century != 0 )
    {
      if (ryear == 100)
      {
        ryear = 0;
        century += 1;
      }

      if (ryear != 255)
      {
        ryear = century * 100 + ryear;
        if (ISEC1_Century < 0) ryear = -ryear;
      }
      else { ryear = 1; }
    }
  }

  *year = ryear;
  *month = ISEC1_Month;
  *day = ISEC1_Day;
}

int
gribRefDate(const int *isec1)
{
  int ryear, rmonth, rday;
  gribDecodeRefDate(isec1, &ryear, &rmonth, &rday);
  return (int) cdiEncodeDate(ryear, rmonth, rday);
}

static void
gribDecodeRefTime(const int *isec1, int *hour, int *minute, int *second)
{
  *hour = ISEC1_Hour;
  *minute = ISEC1_Minute;
  *second = 0;
}

int
gribRefTime(const int *isec1)
{
  int rhour, rminute, rsecond;
  gribDecodeRefTime(isec1, &rhour, &rminute, &rsecond);
  return cdiEncodeTime(rhour, rminute, rsecond);
}

bool
gribTimeIsFC(const int *isec1)
{
  bool isFC = false;

  const int time_period = (ISEC1_TimeRange == 10) ? (ISEC1_TimePeriod1 << 8) + ISEC1_TimePeriod2 : ISEC1_TimePeriod1;

  if (time_period > 0 && ISEC1_Day > 0) { isFC = (ISEC1_TimeRange == 0 || ISEC1_TimeRange == 10); }

  return isFC;
}

static int
getTimeUnitFactor(int timeUnit)
{
  static bool lprint = true;
  // clang-format off
  switch (timeUnit)
    {
    case ISEC1_TABLE4_MINUTE:    return    60; break;
    case ISEC1_TABLE4_QUARTER:   return   900; break;
    case ISEC1_TABLE4_30MINUTES: return  1800; break;
    case ISEC1_TABLE4_HOUR:      return  3600; break;
    case ISEC1_TABLE4_3HOURS:    return 10800; break;
    case ISEC1_TABLE4_6HOURS:    return 21600; break;
    case ISEC1_TABLE4_12HOURS:   return 43200; break;
    case ISEC1_TABLE4_DAY:       return 86400; break;
    default:
      if (lprint)
        {
          gprintf(__func__, "Time unit %d unsupported", timeUnit);
          lprint = false;
        }
      break;
    }
  // clang-format on

  return 0;
}

void
gribDateTimeX(int *isec1, int *date, int *time, int *startDate, int *startTime)
{
  *startDate = 0;
  *startTime = 0;

  CdiDateTime rDateTime = cdiDateTime_set(gribRefDate(isec1), gribRefTime(isec1));

  int64_t time_period = 0, time_period_x = 0;
  if (ISEC1_TimeRange == 10)
    time_period = (ISEC1_TimePeriod1 << 8) + ISEC1_TimePeriod2;
  else if (ISEC1_TimeRange >= 2 && ISEC1_TimeRange <= 5)
  {
    time_period_x = ISEC1_TimePeriod1;
    time_period = ISEC1_TimePeriod2;
  }
  else if (ISEC1_TimeRange == 0)
    time_period = ISEC1_TimePeriod1;

  if (time_period > 0 && rDateTime.date.day > 0)
  {
    JulianDate julianDate = julianDate_encode(CGRIBEX_grib_calendar, rDateTime);

    const int timeUnitFactor = getTimeUnitFactor(ISEC1_TimeUnit);

    if (time_period_x > 0)
    {
      JulianDate julianDate2 = julianDate_add_seconds(julianDate, timeUnitFactor * time_period_x);
      CdiDateTime sDateTime = julianDate_decode(CGRIBEX_grib_calendar, julianDate2);
      sDateTime.time.second = 0;
      *startDate = (int) cdiDate_get(sDateTime.date);
      *startTime = cdiTime_get(sDateTime.time);
    }

    julianDate = julianDate_add_seconds(julianDate, timeUnitFactor * time_period);
    rDateTime = julianDate_decode(CGRIBEX_grib_calendar, julianDate);
  }

  *date = (int) cdiDate_get(rDateTime.date);
  *time = cdiTime_get(rDateTime.time);
}

void
gribDateTime(int *isec1, int *date, int *time)
{
  int sdate, stime;
  gribDateTimeX(isec1, date, time, &sdate, &stime);
}

void
gprintf(const char *caller, const char *fmt, ...)
{
  va_list args;

  if (grprsm == NULL) Error("GRIBEX initialization missing!");

  va_start(args, fmt);

  fprintf(grprsm, "%-18s : ", caller);
  vfprintf(grprsm, fmt, args);
  fputs("\n", grprsm);

  va_end(args);
}

// clang-format off
void
gribExDP(int *isec0, int *isec1, int *isec2, double *fsec2, int *isec3,
	 double *fsec3, int *isec4, double *fsec4, int klenp, int *kgrib,
	 int kleng, int *kword, const char *hoper, int *kret)
{
  int yfunc = *hoper;

  if ( yfunc == 'C' )
    {
      grib_encode_double(isec0, isec1, isec2, fsec2, isec3,
			 fsec3, isec4, fsec4, klenp, kgrib,
			 kleng, kword, yfunc, kret);
    }
  else if ( yfunc == 'D' || yfunc == 'J' || yfunc == 'R' )
    {
      grib_decode_double(isec0, isec1, isec2, fsec2, isec3,
			 fsec3, isec4, fsec4, klenp, kgrib,
			 kleng, kword, yfunc, kret);
    }
  else if ( yfunc == 'V' )
    {
      fprintf(stderr, "  cgribex: Version is %s\n", cgribexLibraryVersion());
    }
  else
    {
      Error("oper %c unsupported!", yfunc);
      *kret=-9;
    }
}


void
gribExSP(int *isec0, int *isec1, int *isec2, float *fsec2, int *isec3,
	 float *fsec3, int *isec4, float *fsec4, int klenp, int *kgrib,
	 int kleng, int *kword, const char *hoper, int *kret)
{
  int yfunc = *hoper;

  if ( yfunc == 'C' )
    {
      grib_encode_float(isec0, isec1, isec2, fsec2, isec3,
			fsec3, isec4, fsec4, klenp, kgrib,
			kleng, kword, yfunc, kret);
    }
  else if ( yfunc == 'D' || yfunc == 'J' || yfunc == 'R' )
    {
      grib_decode_float(isec0, isec1, isec2, fsec2, isec3,
			fsec3, isec4, fsec4, klenp, kgrib,
			kleng, kword, yfunc, kret);
    }
  else if ( yfunc == 'V' )
    {
      fprintf(stderr, " cgribex: Version is %s\n", cgribexLibraryVersion());
    }
  else
    {
      Error("oper %c unsupported!", yfunc);
      *kret=-9;
    }
}
// clang-format on

int CGRIBEX_Fix_ZSE = 0; /* 1: Fix ZeroShiftError of simple packed spherical harmonics */
int CGRIBEX_Const = 0;   /* 1: Don't pack constant fields on regular grids */
int CGRIBEX_Debug = 0;   /* 1: Debugging */

void
gribSetDebug(int debug)
{
  CGRIBEX_Debug = debug;

  if (CGRIBEX_Debug) Message("debug level %d", debug);
}

void
gribFixZSE(int flag)
{
  CGRIBEX_Fix_ZSE = flag;

  if (CGRIBEX_Debug) Message("Fix ZeroShiftError set to %d", flag);
}

void
gribSetConst(int flag)
{
  CGRIBEX_Const = flag;

  if (CGRIBEX_Debug) Message("Const set to %d", flag);
}

void
gribSetRound(int round)
{
  UNUSED(round);
}

void
gribSetRefDP(double refval)
{
  UNUSED(refval);
}

void
gribSetRefSP(float refval)
{
  gribSetRefDP((double) refval);
}

void
gribSetValueCheck(int vcheck)
{
  UNUSED(vcheck);
}
#include <string.h>
#include <math.h>

void
gribPrintSec0(int *isec0)
{
  /*

    Print the information in the Indicator
    Section (Section 0) of decoded GRIB data.

    Input Parameters:

       isec0 - Array of decoded integers from Section 0


    Converted from EMOS routine GRPRS0.

       Uwe Schulzweida   MPIfM   01/04/2001

  */

  grsdef();

  fprintf(grprsm, " \n");
  fprintf(grprsm, " Section 0 - Indicator Section.       \n");
  fprintf(grprsm, " -------------------------------------\n");
  fprintf(grprsm, " Length of GRIB message (octets).     %9d\n", ISEC0_GRIB_Len);
  fprintf(grprsm, " GRIB Edition Number.                 %9d\n", ISEC0_GRIB_Version);
}

void
gribPrintSec1(int *isec0, int *isec1)
{
  /*

    Print the information in the Product Definition
    Section (Section 1) of decoded GRIB data.

    Input Parameters
       isec0 - Array of decoded integers from Section 0

       isec1 - Array of decoded integers from Section 1

    Comments:

       When decoding data from Experimental Edition or Edition 0,
       routine GRIBEX adds the additional fields available in
       Edition 1.


    Converted from EMOS routine GRPRS1.

       Uwe Schulzweida   MPIfM   01/04/2001

  */

  int iprev, icurr, ioffset;
  int ibit, ierr, iout, iyear;
  int jiloop;
  float value;
  char hversion[9];

  grsdef();

  /*
    -----------------------------------------------------------------
    Section 0 . Print required information.
    -----------------------------------------------------------------
  */

  fprintf(grprsm, " \n");
  fprintf(grprsm, " Section 1 - Product Definition Section.\n");
  fprintf(grprsm, " ---------------------------------------\n");

  fprintf(grprsm, " Code Table 2 Version Number.         %9d\n", isec1[0]);
  fprintf(grprsm, " Originating centre identifier.       %9d\n", isec1[1]);
  fprintf(grprsm, " Model identification.                %9d\n", isec1[2]);
  fprintf(grprsm, " Grid definition.                     %9d\n", isec1[3]);

  ibit = 8;
  prtbin(isec1[4], ibit, &iout, &ierr);
  fprintf(grprsm, " Flag (Code Table 1)                   %8.8d\n", iout);
  fprintf(grprsm, " Parameter identifier (Code Table 2). %9d\n", isec1[5]);

  if (isec1[5] != 127)
  {
    fprintf(grprsm, " Type of level (Code Table 3).        %9d\n", isec1[6]);
    fprintf(grprsm, " Value 1 of level (Code Table 3).     %9d\n", isec1[7]);
    fprintf(grprsm, " Value 2 of level (Code Table 3).     %9d\n", isec1[8]);
  }
  else
  {
    fprintf(grprsm, " Satellite identifier.                %9d\n", isec1[6]);
    fprintf(grprsm, " Spectral band.                       %9d\n", isec1[7]);
  }

  iyear = isec1[9];
  if (iyear != 255)
  {
    int date, time;
    gribDateTime(isec1, &date, &time);
    iyear = date / 10000;
    fprintf(grprsm, " Year of reference time of data.      %9d  (%4d)\n", isec1[9], iyear);
  }
  else { fprintf(grprsm, " Year of reference time of data MISSING  (=255)\n"); }

  fprintf(grprsm, " Month of reference time of data.     %9d\n", isec1[10]);
  fprintf(grprsm, " Day of reference time of data.       %9d\n", isec1[11]);
  fprintf(grprsm, " Hour of reference time of data.      %9d\n", isec1[12]);
  fprintf(grprsm, " Minute of reference time of data.    %9d\n", isec1[13]);
  fprintf(grprsm, " Time unit (Code Table 4).            %9d\n", isec1[14]);
  fprintf(grprsm, " Time range one.                      %9d\n", isec1[15]);
  fprintf(grprsm, " Time range two.                      %9d\n", isec1[16]);
  fprintf(grprsm, " Time range indicator (Code Table 5)  %9d\n", isec1[17]);
  fprintf(grprsm, " Number averaged.                     %9d\n", isec1[18]);
  fprintf(grprsm, " Number missing from average.         %9d\n", isec1[19]);
  /*
     All ECMWF data in GRIB Editions before Edition 1 is decoded
     as 20th century data. Other centres are decoded as missing.
  */
  if (isec0[1] < 1 && isec1[1] != 98)
    fprintf(grprsm, " Century of reference time of data.   Not given\n");
  else
    fprintf(grprsm, " Century of reference time of data.   %9d\n", isec1[20]);

  //   Print sub-centre
  fprintf(grprsm, " Sub-centre identifier.               %9d\n", ISEC1_SubCenterID);

  //   Decimal scale factor
  fprintf(grprsm, " Units decimal scaling factor.        %9d\n", isec1[22]);

  /*
    -----------------------------------------------------------------
    Section 1 . Print local DWD information.
    -----------------------------------------------------------------
  */
  if ((ISEC1_CenterID == 78 || ISEC1_CenterID == 215 || ISEC1_CenterID == 250) && (isec1[36] == 253 || isec1[36] == 254))
  {
    fprintf(grprsm, " DWD local usage identifier.          %9d\n", isec1[36]);
    if (isec1[36] == 253) fprintf(grprsm, " (Database labelling and ensemble forecast)\n");
    if (isec1[36] == 254) fprintf(grprsm, " (Database labelling)\n");

    fprintf(grprsm, " Year of database entry                     %3d  (%4d)\n", isec1[43], 1900 + isec1[43]);
    fprintf(grprsm, " Month of database entry                    %3d\n", isec1[44]);
    fprintf(grprsm, " Day of database entry                      %3d\n", isec1[45]);
    fprintf(grprsm, " Hour of database entry                     %3d\n", isec1[46]);
    fprintf(grprsm, " Minute of database entry                   %3d\n", isec1[47]);
    fprintf(grprsm, " DWD experiment number                %9d\n", isec1[48]);
    fprintf(grprsm, " DWD run type                         %9d\n", isec1[49]);
    if (isec1[36] == 253)
    {
      fprintf(grprsm, " User id                              %9d\n", isec1[50]);
      fprintf(grprsm, " Experiment identifier                %9d\n", isec1[51]);
      fprintf(grprsm, " Ensemble identification type         %9d\n", isec1[52]);
      fprintf(grprsm, " Number of ensemble members           %9d\n", isec1[53]);
      fprintf(grprsm, " Actual number of ensemble member     %9d\n", isec1[54]);
      fprintf(grprsm, " Model version                            %2d.%2.2d\n", isec1[55], isec1[56]);
    }
  }

  /*
    -----------------------------------------------------------------
    Section 2 . Print local ECMWF information.
    -----------------------------------------------------------------
  */
  /*
    Regular MARS labelling, or reformatted Washington EPS products.
  */
  if ((ISEC1_CenterID == 98 && ISEC1_LocalFLag == 1) || (ISEC1_SubCenterID == 98 && ISEC1_LocalFLag == 1)
      || (ISEC1_CenterID == 7 && ISEC1_SubCenterID == 98))
  {
    /*   Parameters common to all definitions.  */

    fprintf(grprsm, " ECMWF local usage identifier.        %9d\n", isec1[36]);
    if (isec1[36] == 1) fprintf(grprsm, " (Mars labelling or ensemble forecast)\n");
    if (isec1[36] == 2) fprintf(grprsm, " (Cluster means and standard deviations)\n");
    if (isec1[36] == 3) fprintf(grprsm, " (Satellite image data)\n");
    if (isec1[36] == 4) fprintf(grprsm, " (Ocean model data)\n");
    if (isec1[36] == 5) fprintf(grprsm, " (Forecast probability data)\n");
    if (isec1[36] == 6) fprintf(grprsm, " (Surface temperature data)\n");
    if (isec1[36] == 7) fprintf(grprsm, " (Sensitivity data)\n");
    if (isec1[36] == 8) fprintf(grprsm, " (ECMWF re-analysis data)\n");
    if (isec1[36] == 9) fprintf(grprsm, " (Singular vectors and ensemble perturbations)\n");
    if (isec1[36] == 10) fprintf(grprsm, " (EPS tubes)\n");
    if (isec1[36] == 11) fprintf(grprsm, " (Supplementary data used by analysis)\n");
    if (isec1[36] == 13) fprintf(grprsm, " (Wave 2D spectra direction and frequency)\n");

    fprintf(grprsm, " Class.                               %9d\n", isec1[37]);
    fprintf(grprsm, " Type.                                %9d\n", isec1[38]);
    fprintf(grprsm, " Stream.                              %9d\n", isec1[39]);
    snprintf(hversion, sizeof(hversion), "%4s", (char *) &isec1[40]);
    hversion[4] = 0;
    fprintf(grprsm, " Version number or Experiment identifier.  %4s\n", hversion);
    /*
      ECMWF Local definition 1.
      (MARS labelling or ensemble forecast data)
    */
    if (isec1[36] == 1)
    {
      fprintf(grprsm, " Forecast number.                     %9d\n", isec1[41]);
      if (isec1[39] != 1090) fprintf(grprsm, " Total number of forecasts.           %9d\n", isec1[42]);

      return;
    }
    /*
      ECMWF Local definition 2.
      (Cluster means and standard deviations)
    */
    if (isec1[36] == 2)
    {
      fprintf(grprsm, " Cluster number.                      %9d\n", isec1[41]);
      fprintf(grprsm, " Total number of clusters.            %9d\n", isec1[42]);
      fprintf(grprsm, " Clustering method.                   %9d\n", isec1[43]);
      fprintf(grprsm, " Start time step when clustering.     %9d\n", isec1[44]);
      fprintf(grprsm, " End time step when clustering.       %9d\n", isec1[45]);
      fprintf(grprsm, " Northern latitude of domain.         %9d\n", isec1[46]);
      fprintf(grprsm, " Western longitude of domain.         %9d\n", isec1[47]);
      fprintf(grprsm, " Southern latitude of domain.         %9d\n", isec1[48]);
      fprintf(grprsm, " Eastern longitude of domain.         %9d\n", isec1[49]);
      fprintf(grprsm, " Operational forecast in cluster      %9d\n", isec1[50]);
      fprintf(grprsm, " Control forecast in cluster          %9d\n", isec1[51]);
      fprintf(grprsm, " Number of forecasts in cluster.      %9d\n", isec1[52]);

      for (int jloop = 0; jloop < isec1[52]; jloop++)
        fprintf(grprsm, " Forecast number                      %9d\n", isec1[jloop + 53]);

      return;
    }
    /*
      ECMWF Local definition 3.
      (Satellite image data)
    */
    if (isec1[36] == 3)
    {
      fprintf(grprsm, " Satellite spectral band.             %9d\n", isec1[41]);
      fprintf(grprsm, " Function code.                       %9d\n", isec1[42]);
      return;
    }
    /*
      ECMWF Local definition 4.
      (Ocean model data)
    */
    if (isec1[36] == 4)
    {
      fprintf(grprsm, " Satellite spectral band.             %9d\n", isec1[41]);
      if (isec1[39] != 1090) fprintf(grprsm, " Function code.                       %9d\n", isec1[42]);
      fprintf(grprsm, " Coordinate structure definition.\n");
      fprintf(grprsm, " Fundamental spatial reference system.%9d\n", isec1[43]);
      fprintf(grprsm, " Fundamental time reference.          %9d\n", isec1[44]);
      fprintf(grprsm, " Space unit flag.                     %9d\n", isec1[45]);
      fprintf(grprsm, " Vertical coordinate definition.      %9d\n", isec1[46]);
      fprintf(grprsm, " Horizontal coordinate definition.    %9d\n", isec1[47]);
      fprintf(grprsm, " Time unit flag.                      %9d\n", isec1[48]);
      fprintf(grprsm, " Time coordinate definition.          %9d\n", isec1[49]);
      fprintf(grprsm, " Position definition.     \n");
      fprintf(grprsm, " Mixed coordinate field flag.         %9d\n", isec1[50]);
      fprintf(grprsm, " Coordinate 1 flag.                   %9d\n", isec1[51]);
      fprintf(grprsm, " Averaging flag.                      %9d\n", isec1[52]);
      fprintf(grprsm, " Position of level 1.                 %9d\n", isec1[53]);
      fprintf(grprsm, " Position of level 2.                 %9d\n", isec1[54]);
      fprintf(grprsm, " Coordinate 2 flag.                   %9d\n", isec1[55]);
      fprintf(grprsm, " Averaging flag.                      %9d\n", isec1[56]);
      fprintf(grprsm, " Position of level 1.                 %9d\n", isec1[57]);
      fprintf(grprsm, " Position of level 2.                 %9d\n", isec1[58]);
      fprintf(grprsm, " Grid Definition.\n");
      fprintf(grprsm, " Coordinate 3 flag (x-axis)           %9d\n", isec1[59]);
      fprintf(grprsm, " Coordinate 4 flag (y-axis)           %9d\n", isec1[60]);
      fprintf(grprsm, " Coordinate 4 of first grid point.    %9d\n", isec1[61]);
      fprintf(grprsm, " Coordinate 3 of first grid point.    %9d\n", isec1[62]);
      fprintf(grprsm, " Coordinate 4 of last grid point.     %9d\n", isec1[63]);
      fprintf(grprsm, " Coordinate 3 of last grid point.     %9d\n", isec1[64]);
      fprintf(grprsm, " i - increment.                       %9d\n", isec1[65]);
      fprintf(grprsm, " j - increment.                       %9d\n", isec1[66]);
      fprintf(grprsm, " Flag for irregular grid coordinates. %9d\n", isec1[67]);
      fprintf(grprsm, " Flag for normal or staggered grids.  %9d\n", isec1[68]);
      fprintf(grprsm, " Further information.\n");
      fprintf(grprsm, " Further information flag.            %9d\n", isec1[69]);
      fprintf(grprsm, " Auxiliary information.\n");
      fprintf(grprsm, " No. entries in horizontal coordinate %9d\n", isec1[70]);
      fprintf(grprsm, " No. entries in mixed coordinate defn.%9d\n", isec1[71]);
      fprintf(grprsm, " No. entries in grid coordinate list. %9d\n", isec1[72]);
      fprintf(grprsm, " No. entries in auxiliary array.      %9d\n", isec1[73]);
      /*
        Horizontal coordinate supplement.
      */
      fprintf(grprsm, " Horizontal coordinate supplement.\n");
      if (isec1[70] == 0) { fprintf(grprsm, "(None).\n"); }
      else
      {
        fprintf(grprsm, "Number of items = %d\n", isec1[70]);
        for (int jloop = 0; jloop < isec1[70]; jloop++) fprintf(grprsm, "         %12d\n", isec1[74 + jloop]);
      }
      /*
        Mixed coordinate definition.
      */
      fprintf(grprsm, " Mixed coordinate definition.\n");
      if (isec1[71] == 0) { fprintf(grprsm, "(None).\n"); }
      else
      {
        fprintf(grprsm, "Number of items = %d\n", isec1[71]);
        ioffset = 74 + isec1[70];
        for (int jloop = 0; jloop < isec1[71]; jloop++) fprintf(grprsm, "         %12d\n", isec1[ioffset + jloop]);
      }
      /*
        Grid coordinate list.
      */
      fprintf(grprsm, " Grid coordinate list. \n");
      if (isec1[72] == 0) { fprintf(grprsm, "(None).\n"); }
      else
      {
        fprintf(grprsm, "Number of items = %d\n", isec1[72]);
        ioffset = 74 + isec1[70] + isec1[71];
        for (int jloop = 0; jloop < isec1[72]; jloop++) fprintf(grprsm, "         %12d\n", isec1[ioffset + jloop]);
      }
      /*
        Auxiliary array.
      */
      fprintf(grprsm, " Auxiliary array.      \n");
      if (isec1[73] == 0) { fprintf(grprsm, "(None).\n"); }
      else
      {
        fprintf(grprsm, "Number of items = %d\n", isec1[73]);
        ioffset = 74 + isec1[70] + isec1[71] + isec1[72];
        for (int jloop = 0; jloop < isec1[73]; jloop++) fprintf(grprsm, "         %12d\n", isec1[ioffset + jloop]);
      }
      /*
        Post-auxiliary array.
      */
      fprintf(grprsm, " Post-auxiliary array. \n");
      ioffset = 74 + isec1[70] + isec1[71] + isec1[72] + isec1[73];
      if (isec1[ioffset] == 0) { fprintf(grprsm, "(None).\n"); }
      else
      {
        fprintf(grprsm, "Number of items = %d\n", isec1[ioffset]);
        for (int jloop = 1; jloop < isec1[ioffset]; jloop++) fprintf(grprsm, "         %12d\n", isec1[ioffset + jloop]);
      }

      return;
    }
    /*
      ECMWF Local definition 5.
      (Forecast probability data)
    */
    if (isec1[36] == 5)
    {
      fprintf(grprsm, " Forecast probability number          %9d\n", isec1[41]);
      fprintf(grprsm, " Total number of forecast probabilities %7d\n", isec1[42]);
      fprintf(grprsm, " Threshold units decimal scale factor %9d\n", isec1[43]);
      fprintf(grprsm, " Threshold indicator(1=lower,2=upper,3=both) %2d\n", isec1[44]);
      if (isec1[44] != 2) fprintf(grprsm, " Lower threshold value                %9d\n", isec1[45]);
      if (isec1[44] != 1) fprintf(grprsm, " Upper threshold value                %9d\n", isec1[46]);
      return;
    }
    /*
      ECMWF Local definition 6.
      (Surface temperature data)
    */
    if (isec1[36] == 6)
    {
      iyear = isec1[43];
      if (iyear > 100)
      {
        if (iyear < 19000000) iyear = iyear + 19000000;
        fprintf(grprsm, " Date of SST field used               %9d\n", iyear);
      }
      else
        fprintf(grprsm, "Date of SST field used               Not given\n");
    }
    if (isec1[44] == 0) fprintf(grprsm, " Type of SST field (= climatology)    %9d\n", isec1[44]);
    if (isec1[44] == 1) fprintf(grprsm, " Type of SST field (= 1/1 degree)     %9d\n", isec1[44]);
    if (isec1[44] == 2) fprintf(grprsm, " Type of SST field (= 2/2 degree)     %9d\n", isec1[44]);

    fprintf(grprsm, " Number of ICE fields used:           %9d\n", isec1[45]);

    for (int jloop = 1; jloop <= isec1[45]; jloop++)
    {
      iyear = isec1[44 + (jloop * 2)];
      if (iyear > 100)
      {
        if (iyear < 19000000) iyear = iyear + 19000000;
        fprintf(grprsm, " Date of ICE field%3d                 %9d\n", jloop, iyear);
        fprintf(grprsm, " Satellite number (ICE field%3d)      %9d\n", jloop, isec1[45 + (jloop * 2)]);
      }
      else
        fprintf(grprsm, "Date of SST field used               Not given\n");
    }
    /*
      ECMWF Local definition 7.
      (Sensitivity data)
    */
    if (isec1[36] == 7)
    {
      if (isec1[38] == 51) fprintf(grprsm, " Forecast number                      %9d\n", isec1[41]);
      if (isec1[38] != 51) fprintf(grprsm, " Iteration number                     %9d\n", isec1[41]);
      if (isec1[38] != 52) fprintf(grprsm, " Total number of diagnostics          %9d\n", isec1[42]);
      if (isec1[38] == 52) fprintf(grprsm, " No.interations in diag. minimisation %9d\n", isec1[42]);
      fprintf(grprsm, " Domain(0=Global,1=Europe,2=N.Hem.,3=S.Hem.) %2d\n", isec1[43]);
      fprintf(grprsm, " Diagnostic number                    %9d\n", isec1[44]);
    }
    /*
      ECMWF Local definition 8.
      (ECMWF re-analysis data)
    */
    if (isec1[36] == 8)
    {
      if ((isec1[39] == 1043) || (isec1[39] == 1070) || (isec1[39] == 1071))
      {
        fprintf(grprsm, " Interval between reference times     %9d\n", isec1[41]);
        for (int jloop = 43; jloop <= 54; jloop++)
        {
          jiloop = jloop + 8;
          fprintf(grprsm, " ERA section 1 octet %2d.              %9d\n", jiloop, isec1[jloop - 1]);
        }
      }
      else
      {
        for (int jloop = 42; jloop <= 54; jloop++)
        {
          jiloop = jloop + 8;
          fprintf(grprsm, " ERA section 1 octet %2d.              %9d\n", jiloop, isec1[jloop - 1]);
        }
      }
      return;
    }

    if (isec1[38] > 4 && isec1[38] < 9)
    {
      fprintf(grprsm, " Simulation number.                   %9d\n", isec1[41]);
      fprintf(grprsm, " Total number of simulations.         %9d\n", isec1[42]);
    }
    /*
      ECMWF Local definition 9.
      (Singular vectors and ensemble perturbations)
    */
    if (isec1[36] == 9)
    {
      if (isec1[38] == 60) fprintf(grprsm, " Perturbed ensemble forecast number   %9d\n", isec1[41]);
      if (isec1[38] == 61) fprintf(grprsm, " Initial state perturbation number    %9d\n", isec1[41]);
      if (isec1[38] == 62) fprintf(grprsm, " Singular vector number               %9d\n", isec1[41]);
      if (isec1[38] == 62)
      {
        fprintf(grprsm, " Number of iterations                 %9d\n", isec1[42]);
        fprintf(grprsm, " Number of singular vectors computed  %9d\n", isec1[43]);
        fprintf(grprsm, " Norm used at initial time            %9d\n", isec1[44]);
        fprintf(grprsm, " Norm used at final time              %9d\n", isec1[45]);
        fprintf(grprsm, " Multiplication factor                %9d\n", isec1[46]);
        fprintf(grprsm, " Latitude of north-west corner        %9d\n", isec1[47]);
        fprintf(grprsm, " Longitude of north-west corner       %9d\n", isec1[48]);
        fprintf(grprsm, " Latitude of south-east corner        %9d\n", isec1[49]);
        fprintf(grprsm, " Longitude of south-east corner       %9d\n", isec1[50]);
        fprintf(grprsm, " Accuracy                             %9d\n", isec1[51]);
        fprintf(grprsm, " Number of singular vectors evolved   %9d\n", isec1[52]);
        fprintf(grprsm, " Ritz number one                      %9d\n", isec1[53]);
        fprintf(grprsm, " Ritz number two                      %9d\n", isec1[54]);
      }
    }
    /*
      ECMWF Local definition 10.
      (EPS tubes)
    */
    if (isec1[36] == 10)
    {
      fprintf(grprsm, " Tube number                          %9d\n", isec1[41]);
      fprintf(grprsm, " Total number of tubes                %9d\n", isec1[42]);
      fprintf(grprsm, " Central cluster definition           %9d\n", isec1[43]);
      fprintf(grprsm, " Parameter                            %9d\n", isec1[44]);
      fprintf(grprsm, " Type of level                        %9d\n", isec1[45]);
      fprintf(grprsm, " Northern latitude of domain of tubing%9d\n", isec1[46]);
      fprintf(grprsm, " Western longitude of domain of tubing%9d\n", isec1[47]);
      fprintf(grprsm, " Southern latitude of domain of tubing%9d\n", isec1[48]);
      fprintf(grprsm, " Eastern longitude of domain of tubing%9d\n", isec1[49]);
      fprintf(grprsm, " Tube number of operational forecast  %9d\n", isec1[50]);
      fprintf(grprsm, " Tube number of control forecast      %9d\n", isec1[51]);
      fprintf(grprsm, " Height/pressure of level             %9d\n", isec1[52]);
      fprintf(grprsm, " Reference step                       %9d\n", isec1[53]);
      fprintf(grprsm, " Radius of central cluster            %9d\n", isec1[54]);
      fprintf(grprsm, " Ensemble standard deviation          %9d\n", isec1[55]);
      fprintf(grprsm, " Dist.of tube extreme to ensemble mean%9d\n", isec1[56]);
      fprintf(grprsm, " Number of forecasts in the tube      %9d\n", isec1[57]);

      fprintf(grprsm, " List of ensemble forecast numbers:\n");
      for (int jloop = 1; jloop <= isec1[57]; jloop++) fprintf(grprsm, "    %9d\n", isec1[57 + jloop]);
    }
    /*
      ECMWF Local definition 11.
      (Supplementary data used by the analysis)
    */
    if (isec1[36] == 11)
    {
      fprintf(grprsm, " Details of analysis which used the supplementary data:\n");
      fprintf(grprsm, "   Class                              %9d\n", isec1[41]);
      fprintf(grprsm, "   Type                               %9d\n", isec1[42]);
      fprintf(grprsm, "   Stream                             %9d\n", isec1[43]);
      /*
      snprintf(hversion, sizeof(hversion), "%8d", isec1[44]);
      fprintf(grprsm, "   Version number/experiment identifier:   %4s\n", &hversion[4]);
      */
      iyear = isec1[45];
      iyear = iyear + ((iyear > 50) ? 1900 : 2000);

      fprintf(grprsm, "   Year                               %9d\n", iyear);
      fprintf(grprsm, "   Month                              %9d\n", isec1[46]);
      fprintf(grprsm, "   Day                                %9d\n", isec1[47]);
      fprintf(grprsm, "   Hour                               %9d\n", isec1[48]);
      fprintf(grprsm, "   Minute                             %9d\n", isec1[49]);
      fprintf(grprsm, "   Century                            %9d\n", isec1[50]);
      fprintf(grprsm, "   Originating centre                 %9d\n", isec1[51]);
      fprintf(grprsm, "   Sub-centre                         %9d\n", isec1[52]);
    }
    /*
      ECMWF Local definition 12.
    */
    if (isec1[36] == 12)
    {
      fprintf(grprsm, " (Mean, average, etc)\n");
      fprintf(grprsm, " Start date of the period              %8d\n", isec1[41]);
      fprintf(grprsm, " Start time of the period                  %4.4d\n", isec1[42]);
      fprintf(grprsm, " Finish date of the period             %8d\n", isec1[43]);
      fprintf(grprsm, " Finish time of the period                 %4.4d\n", isec1[44]);
      fprintf(grprsm, " Verifying date of the period          %8d\n", isec1[45]);
      fprintf(grprsm, " Verifying time of the period              %4.4d\n", isec1[46]);
      fprintf(grprsm, " Code showing method                   %8d\n", isec1[47]);
      fprintf(grprsm, " Number of different time intervals used  %5d\n", isec1[48]);
      fprintf(grprsm, " List of different time intervals used:\n");
      iprev = isec1[49];
      unsigned icount = 0;
      for (int jloop = 1; jloop <= isec1[48]; jloop++)
      {
        icurr = isec1[48 + jloop];
        if (icurr != iprev)
        {
          if (icount == 1) fprintf(grprsm, "  - interval %5.4d used       once\n", iprev);
          if (icount == 2) fprintf(grprsm, "  - interval %5.4d used       twice\n", iprev);
          if (icount > 2) fprintf(grprsm, "  - interval %5.4d used %5u times\n", iprev, icount);
          iprev = icurr;
          icount = 1;
        }
        else
          icount = icount + 1;
      }
      if (icount == 1) fprintf(grprsm, "  - interval %5.4d used       once\n", iprev);
      if (icount == 2) fprintf(grprsm, "  - interval %5.4d used       twice\n", iprev);
      if (icount > 2) fprintf(grprsm, "  - interval %5.4d used %5u times\n", iprev, icount);
    }
    /*
      ECMWF Local definition 13.
      (Wave 2D spectra direction and frequency)
    */
    if (isec1[36] == 13)
    {
      fprintf(grprsm, " Direction number                     %9d\n", isec1[43]);
      fprintf(grprsm, " Frequency number                     %9d\n", isec1[44]);
      fprintf(grprsm, " Total number of directions           %9d\n", isec1[45]);
      fprintf(grprsm, " Total number of frequencies          %9d\n", isec1[46]);
      fprintf(grprsm, " Scale factor applied to directions   %9d\n", isec1[47]);
      fprintf(grprsm, " Scale factor applied to frequencies  %9d\n", isec1[48]);
      fprintf(grprsm, " List of directions:\n");
      for (int jloop = 1; jloop <= isec1[45]; jloop++)
      {
        value = (float) (isec1[48 + jloop]) / (float) (isec1[47]);
        if (isec1[43] == jloop)
          fprintf(grprsm, " %2.2d:%15.7f   <-- this field value\n", jloop, value);
        else
          fprintf(grprsm, "%2.2d:%15.7f\n", jloop, value);
      }
      fprintf(grprsm, " List of frequencies:\n");
      for (int jloop = 1; jloop <= isec1[46]; jloop++)
      {
        value = (float) (isec1[48 + isec1[45] + jloop]) / (float) (isec1[48]);
        if (isec1[44] == jloop)
          fprintf(grprsm, " %2.2d:%15.7f   <-- this field value\n", jloop, value);
        else
          fprintf(grprsm, "%2.2d:%15.7f\n", jloop, value);

        if (isec1[49 + isec1[45] + isec1[46]] != 0)
        {
          fprintf(grprsm, " System number (65535 = missing)      %9d\n", isec1[49 + isec1[45] + isec1[46]]);
          fprintf(grprsm, " Method number (65535 = missing)      %9d\n", isec1[50 + isec1[45] + isec1[46]]);
        }
      }
      /*
        ECMWF Local definition 14.
        (Brightness temperature)
      */
      if (isec1[36] == 14)
      {
        fprintf(grprsm, " Channel number                       %9d\n", isec1[43]);
        fprintf(grprsm, " Scale factor applied to frequencies  %9d\n", isec1[44]);
        fprintf(grprsm, " Total number of frequencies          %9d\n", isec1[45]);
        fprintf(grprsm, " List of frequencies:\n");
        for (int jloop = 1; jloop <= isec1[45]; jloop++)
        {
          value = (float) (isec1[45 + jloop]) / (float) (isec1[44]);
          if (isec1[43] == jloop)
            fprintf(grprsm, " %3d:%15.9f   <-- this channel\n", jloop, value);
          else
            fprintf(grprsm, " %3d:%15.9f\n", jloop, value);
        }
      }
      /*
        ECMWF Local definition 15.
        (Ocean ensemble seasonal forecast)
      */
      if (isec1[36] == 15)
      {
        fprintf(grprsm, " Ensemble member number               %9d\n", isec1[41]);
        fprintf(grprsm, " System number                        %9d\n", isec1[42]);
        fprintf(grprsm, " Method number                        %9d\n", isec1[43]);
      }
      /*
        ECMWF Local definition 16.
        (Seasonal forecast monthly mean atmosphere data)
      */
      if (isec1[36] == 16)
      {
        fprintf(grprsm, " Ensemble member number               %9d\n", isec1[41]);
        fprintf(grprsm, " System number                        %9d\n", isec1[43]);
        fprintf(grprsm, " Method number                        %9d\n", isec1[44]);
        fprintf(grprsm, " Verifying month                      %9d\n", isec1[45]);
        fprintf(grprsm, " Averaging period                     %9d\n", isec1[46]);
      }
      /*
        ECMWF Local definition 17.
        (Sst or sea-ice used by analysis)
      */
      if (isec1[36] == 17)
      {
        iyear = isec1[43];
        if (iyear > 100)
        {
          if (iyear < 19000000) iyear = iyear + 19000000;
          fprintf(grprsm, " Date of sst/ice field used           %9d\n", iyear);
        }
        else
          fprintf(grprsm, " Date of sst/ice field used           Not given\n");

        if (isec1[44] == 0) fprintf(grprsm, " Type of sst/ice field (= climatology)%9d\n", isec1[44]);
        if (isec1[44] == 1) fprintf(grprsm, " Type of sst/ice field (= 1/1 degree) %9d\n", isec1[44]);
        if (isec1[44] == 2) fprintf(grprsm, " Type of sst/ice field (= 2/2 degree) %9d\n", isec1[44]);

        fprintf(grprsm, " Number of ICE fields used:           %9d\n", isec1[45]);

        for (int jloop = 1; jloop < isec1[45]; jloop++)
        {
          iyear = isec1[44 + (jloop * 2)];
          if (iyear > 100)
          {
            if (iyear < 19000000) iyear = iyear + 19000000;
            fprintf(grprsm, " Date of ICE field%3d                 %9d\n", jloop, iyear);
            fprintf(grprsm, " Satellite number (ICE field%3d)      %9d\n", jloop, isec1[45 + (jloop * 2)]);
          }
          else
            fprintf(grprsm, "Date of sst/ice field used           Not given\n");
        }
      }
    }
  }
  /*
    -----------------------------------------------------------------
    Section 3 . Print Washington ensemble product information.
    -----------------------------------------------------------------
  */
  /*
    Washington EPS products (but not reformatted Washington EPS
    products.
  */
  if ((isec1[1] == 7 && isec1[23] == 1) && (!(ISEC1_SubCenterID == 98)))
  { /*   CALL KWPRS1 (iSEC0,iSEC1)*/
  }
  /*
    -----------------------------------------------------------------
    Section 4 . Print local MPIM information.
    -----------------------------------------------------------------
  */
  if (isec1[1] == 252 && isec1[36] == 1)
  {
    fprintf(grprsm, " MPIM local usage identifier.         %9d\n", isec1[36]);
    fprintf(grprsm, " Type of ensemble forecast            %9d\n", isec1[37]);
    fprintf(grprsm, " Individual ensemble member           %9d\n", isec1[38]);
    fprintf(grprsm, " Number of forecasts in ensemble      %9d\n", isec1[39]);
  }
}

static void
printQuasi(int *isec2)
{
  /*

    Print the qusai-regular information in the Grid Description
    Section (Section 2) of decoded GRIB data.

    Input Parameters:

       isec2 - Array of decoded integers from Section 2.

    Comments:

       Only data representation types catered for are Gaussian
       grid, latitude/longitude grid, Spherical Harmonics,
       Polar stereographic and Space view perspective.

    Converted from EMOS routine PTQUASI.

       Uwe Schulzweida   MPIfM   01/04/2001

  */

  char yout[64];

  /*
    -----------------------------------------------------------------
    Section 1. Print quasi-grid data.
    -----------------------------------------------------------------
  */
  // See if scanning is north->south or south->north
  fprintf(grprsm, "  Number of points along a parallel varies.\n");

  int ntos = (fmod((double) isec2[10], 128.) < 64);
  fprintf(grprsm, "  Number of points.   Parallel. %s\n", ntos ? "(North to South)" : "(South to North)");

  // Display number of points for each latitude
  int latcnt = isec2[2];
  int nextlat = 0;
  memset(yout, ' ', (size_t) 11);

  for (int j = 0; j < latcnt; ++j)
  {
    nextlat = nextlat + 1;
    snprintf(yout, sizeof(yout), "%4d", nextlat);

    // Finished?
    if (nextlat > latcnt) break;
    if (nextlat == latcnt)
    {
      fprintf(grprsm, " %5d                %-12s\n", isec2[nextlat + 21], yout);
      break;
    }
    // Look for neighbouring latitudes with same number of points
    unsigned nrepeat = 0;

  LABEL110:
    // If neighbouring latitudes have same number of points increase the repeat count.
    if (isec2[nextlat + 21 + 1] == isec2[nextlat + 21])
    {
      nrepeat = nrepeat + 1;
      nextlat = nextlat + 1;
      if (nextlat < latcnt) goto LABEL110;
    }
    // Display neighbouring latitudes with same number of points as 'nn to mm'.
    if (nrepeat >= 1) snprintf(yout + 4, sizeof(yout) - 4, "to %5d", nextlat);
    fprintf(grprsm, " %5d                %-12s\n", isec2[nextlat + 21], yout);
    memset(yout, ' ', (size_t) 11);
  }
}

void
gribPrintSec2DP(int *isec0, int *isec2, double *fsec2)
{
  /*

    Print the information in the Grid Description
    Section (Section 2) of decoded GRIB data.

    Input Parameters:

       isec0  - Array of decoded integers from Section 0

       isec2  - Array of decoded integers from Section 2

       fsec2  - Array of decoded floats from Section 2

    Comments:

       Only data representation types catered for are Gaussian
       grid, latitude/longitude grid, Spherical Harmonics,
       Polar stereographic and Space view perspective.


    Converted from EMOS routine GRPRS2.

       Uwe Schulzweida   MPIfM   01/04/2001

  */

  int ibit, iedit, ierr, iout, iresol;

  grsdef();
  /*
    -----------------------------------------------------------------
    Section 1 . Print GRIB Edition number.
    -----------------------------------------------------------------
  */
  iedit = isec0[1];
  fprintf(grprsm, " \n");
  fprintf(grprsm, " Section 2 - Grid Description Section.\n");
  fprintf(grprsm, " -------------------------------------\n");
  /*
    -----------------------------------------------------------------
    Section 2 . Print spherical harmonic data.
    -----------------------------------------------------------------
  */
  if (isec2[0] == 50 || isec2[0] == 60 || isec2[0] == 70 || isec2[0] == 80)
  {
    fprintf(grprsm, " Data represent type = spectral     (Table 6) %9d\n", isec2[0]);
    fprintf(grprsm, " J - Pentagonal resolution parameter.         %9d\n", isec2[1]);
    fprintf(grprsm, " K - Pentagonal resolution parameter.         %9d\n", isec2[2]);
    fprintf(grprsm, " M - Pentagonal resolution parameter.         %9d\n", isec2[3]);
    fprintf(grprsm, " Representation type (Table 9)                %9d\n", isec2[4]);
    fprintf(grprsm, " Representation mode (Table 10).              %9d\n", isec2[5]);
    for (int i = 7; i <= 11; ++i) fprintf(grprsm, " Not used.                                    %9d\n", isec2[i - 1]);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Section 3 . Print Gaussian grid data.
    -----------------------------------------------------------------
  */
  if (isec2[0] == 4 || isec2[0] == 14 || isec2[0] == 24 || isec2[0] == 34)
  {
    fprintf(grprsm, " (Southern latitudes and Western longitudes are negative.)\n");
    fprintf(grprsm, " Data represent type = gaussian     (Table 6) %9d\n", isec2[0]);
    /*
      Quasi-regular grids introduced in Edition 1.
    */
    if (isec2[16] == 0 || iedit < 1)
      fprintf(grprsm, " Number of points along a parallel.           %9d\n", isec2[1]);
    else
      printQuasi(isec2);

    fprintf(grprsm, " Number of points along a meridian.           %9d\n", isec2[2]);
    fprintf(grprsm, " Latitude of first grid point.                %9d\n", isec2[3]);
    fprintf(grprsm, " Longitude of first grid point.               %9d\n", isec2[4]);

    ibit = 8;
    iresol = isec2[5] + isec2[17] + isec2[18];
    prtbin(iresol, ibit, &iout, &ierr);

    fprintf(grprsm, " Resolution and components flag.               %8.8d\n", iout);
    fprintf(grprsm, " Latitude of last grid point.                 %9d\n", isec2[6]);
    fprintf(grprsm, " Longitude of last grid point.                %9d\n", isec2[7]);
    /*
      Print increment if given.
    */
    if (isec2[5] == 128)
      fprintf(grprsm, " i direction (East-West) increment.           %9d\n", isec2[8]);
    else
      fprintf(grprsm, " i direction (East-West) increment            Not given\n");

    fprintf(grprsm, " Number of parallels between pole and equator.%9d\n", isec2[9]);

    ibit = 8;
    prtbin(isec2[10], ibit, &iout, &ierr);

    fprintf(grprsm, " Scanning mode flags (Code Table 8)            %8.8d\n", iout);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Section 4 . Print Latitude / longitude grid data.
    -----------------------------------------------------------------
  */
  if (isec2[0] == 0 || isec2[0] == 10 || isec2[0] == 20 || isec2[0] == 30)
  {
    fprintf(grprsm, " (Southern latitudes and Western longitudes are negative.)\n");
    fprintf(grprsm, " Data represent type = lat/long     (Table 6) %9d\n", isec2[0]);
    /*
      Quasi-regular lat/long grids also possible.
    */
    if (isec2[16] == 0)
      fprintf(grprsm, " Number of points along a parallel.           %9d\n", isec2[1]);
    else
      printQuasi(isec2);

    fprintf(grprsm, " Number of points along a meridian.           %9d\n", isec2[2]);
    fprintf(grprsm, " Latitude of first grid point.                %9d\n", isec2[3]);
    fprintf(grprsm, " Longitude of first grid point.               %9d\n", isec2[4]);

    ibit = 8;
    iresol = isec2[5] + isec2[17] + isec2[18];
    prtbin(iresol, ibit, &iout, &ierr);

    fprintf(grprsm, " Resolution and components flag.               %8.8d\n", iout);
    fprintf(grprsm, " Latitude of last grid point.                 %9d\n", isec2[6]);
    fprintf(grprsm, " Longitude of last grid point.                %9d\n", isec2[7]);
    /*
      Print increment if given.
    */
    if (isec2[8] < 0)
      fprintf(grprsm, " i direction (East-West) increment            Not given\n");
    else
      fprintf(grprsm, " i direction (East-West) increment.           %9d\n", isec2[8]);

    if (isec2[9] < 0)
      fprintf(grprsm, " j direction (North-South) increment          Not given\n");
    else
      fprintf(grprsm, " j direction (North-South) increment.         %9d\n", isec2[9]);

    ibit = 8;
    prtbin(isec2[10], ibit, &iout, &ierr);

    fprintf(grprsm, " Scanning mode flags (Code Table 8)            %8.8d\n", iout);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Section 5 . Print polar stereographic data.
    -----------------------------------------------------------------
  */
  if (isec2[0] == 5)
  {
    fprintf(grprsm, " (Southern latitudes and Western longitudes are negative.)\n");
    fprintf(grprsm, " Data represent type = polar stereo (Table 6) %9d\n", isec2[0]);
    fprintf(grprsm, " Number of points along X axis.               %9d\n", isec2[1]);
    fprintf(grprsm, " Number of points along Y axis.               %9d\n", isec2[2]);
    fprintf(grprsm, " Latitude of first grid point.                %9d\n", isec2[3]);
    fprintf(grprsm, " Longitude of first grid point.               %9d\n", isec2[4]);
    ibit = 8;
    iresol = isec2[17] + isec2[18];
    prtbin(iresol, ibit, &iout, &ierr);
    fprintf(grprsm, " Resolution and components flag.               %8.8d\n", iout);
    fprintf(grprsm, " Orientation of the grid.                     %9d\n", isec2[6]);
    fprintf(grprsm, " X direction increment.                       %9d\n", isec2[8]);
    fprintf(grprsm, " Y direction increment.                       %9d\n", isec2[9]);
    ibit = 8;
    prtbin(isec2[10], ibit, &iout, &ierr);
    fprintf(grprsm, " Scanning mode flags (Code Table 8)            %8.8d\n", iout);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    fprintf(grprsm, " Projection centre flag.                      %9d\n", isec2[12]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Section 6 . Print Lambert conformal data.
    -----------------------------------------------------------------
  */
  if (isec2[0] == 3)
  {
    fprintf(grprsm, " (Southern latitudes and Western longitudes are negative.)\n");
    fprintf(grprsm, " Data represent type = Lambert      (Table 6) %9d\n", isec2[0]);
    fprintf(grprsm, " Number of points along X axis.               %9d\n", isec2[1]);
    fprintf(grprsm, " Number of points along Y axis.               %9d\n", isec2[2]);
    fprintf(grprsm, " Latitude of first grid point.                %9d\n", isec2[3]);
    fprintf(grprsm, " Longitude of first grid point.               %9d\n", isec2[4]);
    ibit = 8;
    iresol = isec2[17] + isec2[18] + isec2[5];
    prtbin(iresol, ibit, &iout, &ierr);
    fprintf(grprsm, " Resolution and components flag.               %8.8d\n", iout);
    fprintf(grprsm, " Orientation of the grid.                     %9d\n", isec2[6]);
    fprintf(grprsm, " X direction increment.                       %9d\n", isec2[8]);
    fprintf(grprsm, " Y direction increment.                       %9d\n", isec2[9]);
    ibit = 8;
    prtbin(isec2[10], ibit, &iout, &ierr);
    fprintf(grprsm, " Scanning mode flags (Code Table 8)            %8.8d\n", iout);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    fprintf(grprsm, " Projection centre flag.                      %9d\n", isec2[12]);
    fprintf(grprsm, " Latitude intersection 1 - Latin 1 -.         %9d\n", isec2[13]);
    fprintf(grprsm, " Latitude intersection 2 - Latin 2 -.         %9d\n", isec2[14]);
    fprintf(grprsm, " Latitude of Southern Pole.                   %9d\n", isec2[19]);
    fprintf(grprsm, " Longitude of Southern Pole.                  %9d\n", isec2[20]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Section 7 . Print space view perspective or orthographic data.
    -----------------------------------------------------------------
  */
  if (isec2[0] == 90)
  {
    fprintf(grprsm, " (Southern latitudes and Western longitudes are negative.)\n");
    fprintf(grprsm, " Data represent type = space/ortho  (Table 6) %9d\n", isec2[0]);
    fprintf(grprsm, " Number of points along X axis.               %9d\n", isec2[1]);
    fprintf(grprsm, " Number of points along Y axis.               %9d\n", isec2[2]);
    fprintf(grprsm, " Latitude of sub-satellite point.             %9d\n", isec2[3]);
    fprintf(grprsm, " Longitude of sub-satellite point.            %9d\n", isec2[4]);
    // iresol = isec2[17] + isec2[18];
    fprintf(grprsm, " Diameter of the earth in x direction.        %9d\n", isec2[6]);
    fprintf(grprsm, " Y coordinate of sub-satellite point.         %9d\n", isec2[9]);
    ibit = 8;
    prtbin(isec2[10], ibit, &iout, &ierr);
    fprintf(grprsm, " Scanning mode flags (Code Table 8)            %8.8d\n", iout);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    fprintf(grprsm, " Orientation of the grid.                     %9d\n", isec2[6]);
    fprintf(grprsm, " Altitude of the camera.                      %9d\n", isec2[13]);
    fprintf(grprsm, " Y coordinate of origin of sector image.      %9d\n", isec2[14]);
    fprintf(grprsm, " X coordinate of origin of sector image.      %9d\n", isec2[15]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Section 7.5 . Print ocean data
    -----------------------------------------------------------------
  */
  /*
  if ( isec2[0] == 192 && ISEC1_CenterID == 98 )
    {
      fprintf(grprsm, " Data represent type = ECMWF ocean  (Table 6) %9d\n", isec2[0]);
      if ( isec2[1] ==  32767 )
        fprintf(grprsm, " Number of points along the first axis.       Not used\n");
      else
        fprintf(grprsm, " Number of points along the first axis.       %9d\n", isec2[1]);

      if ( isec2[2] ==  32767 )
        fprintf(grprsm, " Number of points along the second axis.      Not used\n");
      else
        fprintf(grprsm, " Number of points along the second axis.      %9d\n", isec2[2]);

      ibit = 8;
      prtbin(isec2[10], ibit, &iout, &ierr);
      fprintf(grprsm, " Scanning mode flags (Code Table 8)            %8.8d\n", iout);
      goto LABEL800;
    }
    */
  /*
    -----------------------------------------------------------------
    Section 7.6 . Print triangular data
    -----------------------------------------------------------------
  */
  if (isec2[0] == 192 /* && ISEC1_CenterID == 78 */)
  {
    fprintf(grprsm, " Data represent type = triangular   (Table 6) %9d\n", isec2[0]);
    fprintf(grprsm, " Number of factor 2 in factorisation of Ni.   %9d\n", isec2[1]);
    fprintf(grprsm, " Number of factor 3 in factorisation of Ni.   %9d\n", isec2[2]);
    fprintf(grprsm, " Number of diamonds (Nd).                     %9d\n", isec2[3]);
    fprintf(grprsm, " Number of triangular subdivisions of the\n");
    fprintf(grprsm, "           icosahedron (Ni).                  %9d\n", isec2[4]);
    fprintf(grprsm, " Flag for orientation of diamonds (Table A).  %9d\n", isec2[5]);
    fprintf(grprsm, " Latitude of pole point.                      %9d\n", isec2[6]);
    fprintf(grprsm, " Longitude of pole point.                     %9d\n", isec2[7]);
    fprintf(grprsm, " Longitude of the first diamond.              %9d\n", isec2[8]);
    fprintf(grprsm, " Flag for storage sequence (Table B).         %9d\n", isec2[9]);
    fprintf(grprsm, " Number of vertical coordinate parameters.    %9d\n", isec2[11]);
    goto LABEL800;
  }
  /*
    -----------------------------------------------------------------
    Drop through to here => representation type not catered for.
    -----------------------------------------------------------------
  */
  fprintf(grprsm, "GRPRS2 :Data representation type not catered for -%d\n", isec2[0]);

  goto LABEL900;
  /*
    -----------------------------------------------------------------
    Section 8 . Print vertical coordinate parameters,
                rotated grid information,
                stretched grid information, if any.
    -----------------------------------------------------------------
  */
LABEL800:;
  /*
    Vertical coordinate parameters ...
  */
  if (isec2[11] != 0)
  {
    fprintf(grprsm, " \n");
    fprintf(grprsm, " Vertical Coordinate Parameters.\n");
    fprintf(grprsm, " -------------------------------\n");
    for (int i = 10; i < isec2[11] + 10; ++i) fprintf(grprsm, "    %20.12f\n", fsec2[i]);
  }
  /*
    Rotated and stretched grids introduced in Edition 1.
  */
  if (iedit < 1) goto LABEL900;
  /*
    Rotated grid information ...
  */
  if (isec2[0] == 10 || isec2[0] == 30 || isec2[0] == 14 || isec2[0] == 34 || isec2[0] == 60 || isec2[0] == 80 || isec2[0] == 30)
  {
    fprintf(grprsm, " \n");
    fprintf(grprsm, " Latitude of southern pole of rotation.       %9d\n", isec2[12]);
    fprintf(grprsm, " Longitude of southern pole of rotation.      %9d\n", isec2[13]);
    fprintf(grprsm, " Angle of rotation.                     %20.10f\n", fsec2[0]);
  }
  /*
    Stretched grid information ...
  */
  if (isec2[0] == 20 || isec2[0] == 30 || isec2[0] == 24 || isec2[0] == 34 || isec2[0] == 70 || isec2[0] == 80)
  {
    fprintf(grprsm, " \n");
    fprintf(grprsm, " Latitude of pole of stretching.              %9d\n", isec2[14]);
    fprintf(grprsm, " Longitude of pole of stretching.             %9d\n", isec2[15]);
    fprintf(grprsm, " Stretching factor.                     %20.10f\n", fsec2[1]);
  }

LABEL900:;

  return;
}

void
gribPrintSec2SP(int *isec0, int *isec2, float *fsec2sp)
{
  int inum = 10 + isec2[11];

  double *fsec2 = (double *) Malloc((size_t) inum * sizeof(double));
  if (fsec2 == NULL) SysError("No Memory!");

  for (int j = 0; j < inum; ++j) fsec2[j] = fsec2sp[j];

  gribPrintSec2DP(isec0, isec2, fsec2);

  Free(fsec2);
}

void
gribPrintSec3DP(int *isec0, int *isec3, double *fsec3)
{
  /*

    Print the information in the Bit-Map Section
    (Section 3) of decoded GRIB data.

    Input Parameters:

       isec0  - Array of decoded integers from Section 0

       isec3  - Array of decoded integers from Section 3

       fsec3  - Array of decoded floats from Section 3


    Converted from EMOS routine GRPRS3.

       Uwe Schulzweida   MPIfM   01/04/2001

  */

  UNUSED(isec0);

  grsdef();

  fprintf(grprsm, " \n");
  fprintf(grprsm, " Section 3 - Bit-map Section.\n");
  fprintf(grprsm, " -------------------------------------\n");

  if (isec3[0] != 0)
    fprintf(grprsm, " Predetermined bit-map number.                %9d\n", isec3[0]);
  else
    fprintf(grprsm, " No predetermined bit-map.\n");

  fprintf(grprsm, " Missing data value for integer data.    %14d\n", isec3[1]);

  fprintf(grprsm, " Missing data value for real data. %20.6g\n", fsec3[1]);
}

void
gribPrintSec3SP(int *isec0, int *isec3, float *fsec3sp)
{
  double fsec3[2];

  fsec3[0] = fsec3sp[0];
  fsec3[1] = fsec3sp[1];

  gribPrintSec3DP(isec0, isec3, fsec3);
}

void
gribPrintSec4DP(int *isec0, int *isec4, double *fsec4)
{
  /*

    Print the information in the Binary Data Section
    (Section 4) of decoded GRIB data.

    Input Parameters:

       isec0  - Array of decoded integers from Section 0

       isec4  - Array of decoded integers from Section 4

       fsec4  - Array of decoded floats from Section 4


    Converted from EMOS routine GRPRS4.

       Uwe Schulzweida   MPIfM   01/04/2001

  */
  int inum;

  UNUSED(isec0);

  grsdef();

  /*
    -----------------------------------------------------------------
    Section 1 . Print integer information from isec4.
    -----------------------------------------------------------------
  */
  fprintf(grprsm, " \n");
  fprintf(grprsm, " Section 4 - Binary Data  Section.\n");
  fprintf(grprsm, " -------------------------------------\n");

  fprintf(grprsm, " Number of data values coded/decoded.         %9d\n", isec4[0]);
  fprintf(grprsm, " Number of bits per data value.               %9d\n", isec4[1]);
  fprintf(grprsm, " Type of data       (0=grid pt, 128=spectral).%9d\n", isec4[2]);
  fprintf(grprsm, " Type of packing    (0=simple, 64=complex).   %9d\n", isec4[3]);
  fprintf(grprsm, " Type of data       (0=float, 32=integer).    %9d\n", isec4[4]);
  fprintf(grprsm, " Additional flags   (0=none, 16=present).     %9d\n", isec4[5]);
  fprintf(grprsm, " Reserved.                                    %9d\n", isec4[6]);
  fprintf(grprsm, " Number of values   (0=single, 64=matrix).    %9d\n", isec4[7]);
  fprintf(grprsm, " Secondary bit-maps (0=none, 32=present).     %9d\n", isec4[8]);
  fprintf(grprsm, " Values width       (0=constant, 16=variable).%9d\n", isec4[9]);
  /*
    If complex packing ..
  */
  if (isec4[3] == 64)
  {
    if (isec4[2] == 128)
    {
      fprintf(grprsm, " Byte offset of start of packed data (N).     %9d\n", isec4[15]);
      fprintf(grprsm, " Power (P * 1000).                            %9d\n", isec4[16]);
      fprintf(grprsm, " Pentagonal resolution parameter J for subset.%9d\n", isec4[17]);
      fprintf(grprsm, " Pentagonal resolution parameter K for subset.%9d\n", isec4[18]);
      fprintf(grprsm, " Pentagonal resolution parameter M for subset.%9d\n", isec4[19]);
    }
    else
    {
      fprintf(grprsm, " Bits number of 2nd order values    (none=>0).%9d\n", isec4[10]);
      fprintf(grprsm, " General extend. 2-order packing (0=no,8=yes).%9d\n", isec4[11]);
      fprintf(grprsm, " Boustrophedonic ordering        (0=no,4=yes).%9d\n", isec4[12]);
      fprintf(grprsm, " Spatial differencing order          (0=none).%9d\n", isec4[13] + isec4[14]);
    }
  }
  /*
    Number of non-missing values
  */
  if (isec4[20] != 0) fprintf(grprsm, " Number of non-missing values                 %9d\n", isec4[20]);
  /*
    Information on matrix of values , if present.
  */
  if (isec4[7] == 64)
  {
    fprintf(grprsm, " First dimension (rows) of each matrix.       %9d\n", isec4[49]);
    fprintf(grprsm, " Second dimension (columns) of each matrix.   %9d\n", isec4[50]);
    fprintf(grprsm, " First dimension coordinate values definition.%9d\n", isec4[51]);
    fprintf(grprsm, " (Code Table 12)\n");
    fprintf(grprsm, " NC1 - Number of coefficients for 1st dimension.%7d\n", isec4[52]);
    fprintf(grprsm, " Second dimension coordinate values definition.%8d\n", isec4[53]);
    fprintf(grprsm, " (Code Table 12)\n");
    fprintf(grprsm, " NC2 - Number of coefficients for 2nd dimension.%7d\n", isec4[54]);
    fprintf(grprsm, " 1st dimension physical signifance (Table 13). %8d\n", isec4[55]);
    fprintf(grprsm, " 2nd dimension physical signifance (Table 13).%8d\n", isec4[56]);
  }
  /*
    -----------------------------------------------------------------
    Section 2. Print values from fsec4.
    -----------------------------------------------------------------
  */

  inum = isec4[0];
  if (inum < 0) inum = -inum;
  if (inum > 20) inum = 20;
  /*
    Print first inum values.
  */
  fprintf(grprsm, " \n");
  fprintf(grprsm, " First %4d data values.\n", inum);

  if (isec4[4] == 0)
  {
    /*
      Print real values ...
    */
    for (int j = 0; j < inum; ++j)
    {
      if (fabs(fsec4[j]) > 0)
      {
        if (fabs(fsec4[j]) >= 0.1 && fabs(fsec4[j]) <= 1.e8)
          fprintf(grprsm, " %#16.8G    \n", fsec4[j]);
        else
          fprintf(grprsm, " %#20.8E\n", fsec4[j]);
      }
      else
        fprintf(grprsm, " %#16.0f    \n", fabs(fsec4[j]));
    }
  }
  else
  {
    /*
      Print integer values ...
    */
    fprintf(grprsm, " Print of integer values not supported\n");
    /*
      CALL SETPAR(IBIT,IDUM,IDUM)
      DO 212 J=1,INUM
         INSPT = 0
         CALL INXBIT(IVALUE,1,INSPT,FSEC4(J),1,IBIT,IBIT,'C',IRET)
         WRITE (*,9033) IVALUE
9033 FORMAT(' ',I15)
212   CONTINUE
    ENDIF
    */
  }
}

void
gribPrintSec4SP(int *isec0, int *isec4, float *fsec4sp)
{
  double fsec4[20];

  int inum = isec4[0];
  if (inum < 0) inum = -inum;
  if (inum > 20) inum = 20;

  for (int j = 0; j < inum; ++j) fsec4[j] = fsec4sp[j];

  gribPrintSec4DP(isec0, isec4, fsec4);
}

void
gribPrintSec4Wave(int *isec4)
{
  /*

    Print the wave coordinate information in the Binary Data
    Section (Section 4) of decoded GRIB data.

    Input Parameters:

       isec4 - Array of decoded integers from Section 4

    Comments:

       Wave coordinate information held in isec4 are 32-bit floats,
       hence the PTEMP and NTEMP used for printing are 4-byte variables.


    Converted from EMOS routine GRPRS4W.

       Uwe Schulzweida   MPIfM   01/04/2001

  */
  int ntemp[100];
  float *ptemp;

  grsdef();

  /*
    -----------------------------------------------------------------
    Section 1 . Print integer information from isec4.
    -----------------------------------------------------------------
  */
  fprintf(grprsm, " Coefficients defining first dimension coordinates:\n");
  for (int jloop = 0; jloop < isec4[52]; jloop++)
  {
    ntemp[jloop] = isec4[59 + jloop];
    ptemp = (float *) &ntemp[jloop];
    fprintf(grprsm, "%20.10f\n", *ptemp);
  }
  fprintf(grprsm, " Coefficients defining second dimension coordinates:\n");
  for (int jloop = 0; jloop < isec4[54]; jloop++)
  {
    ntemp[jloop] = isec4[59 + isec4[52] + jloop];
    ptemp = (float *) &ntemp[jloop];
    fprintf(grprsm, "%20.10f\n", *ptemp);
  }
}
#ifdef HAVE_CONFIG_H
#endif

#include <string.h>
#include <ctype.h>

int
gribOpen(const char *filename, const char *mode)
{
  int fileID = fileOpen(filename, mode);

#if defined(__sun)
  if (fileID != FILE_UNDEFID && tolower(*mode) == 'r') { fileSetBufferType(fileID, FILE_BUFTYPE_MMAP); }
#endif

  return fileID;
}

void
gribClose(int fileID)
{
  fileClose(fileID);
}

off_t
gribGetPos(int fileID)
{
  return fileGetPos(fileID);
}

int
gribCheckSeek(int fileID, long *offset, int *version)
{
  int ierr = gribFileSeek(fileID, offset);

  *version = -1;
  if (!ierr)
  {
    char buffer[4];
    if (fileRead(fileID, buffer, 4) == 4) *version = buffer[3];
  }

  return ierr;
}

int
gribFileSeek(int fileID, long *offset)
{
  // position file pointer after GRIB
  const long GRIB = 0x47524942;
  long code = 0;
  int retry = 4096 * 4096;

  *offset = 0;

  void *fileptr = filePtr(fileID);

  while (retry--)
  {
    int ch = filePtrGetc(fileptr);
    if (ch == EOF) return -1;

    code = ((code << 8) + ch) & 0xFFFFFFFF;
    if (code == GRIB)
    {
      if (CGRIBEX_Debug) Message("record offset = %ld", *offset);
      return 0;
    }

    (*offset)++;
  }

  if (CGRIBEX_Debug) Message("record offset = %ld", *offset);

  return 1;
}

static inline unsigned
read3ByteMSBFirst(void *fileptr)
{
  unsigned b1 = (unsigned) (filePtrGetc(fileptr));
  unsigned b2 = (unsigned) (filePtrGetc(fileptr));
  unsigned b3 = (unsigned) (filePtrGetc(fileptr));
  return GET_UINT3(b1, b2, b3);
}

size_t
gribReadSize(int fileID)
{
  size_t rgribsize = 0;
  void *fileptr = filePtr(fileID);
  off_t pos = fileGetPos(fileID);

  unsigned gribsize = read3ByteMSBFirst(fileptr);

  int gribversion = filePtrGetc(fileptr);

  if (gribsize == 24 && gribversion != 1 && gribversion != 2) gribversion = 0;

  if (CGRIBEX_Debug) Message("gribversion = %d", gribversion);

  if (gribversion == 0)
  {
    unsigned gdssize = 0, bmssize = 0;
    unsigned issize = 4, essize = 4;

    unsigned pdssize = gribsize;
    fileSetPos(fileID, (off_t) 3, SEEK_CUR);
    if (CGRIBEX_Debug) Message("pdssize     = %u", pdssize);
    int flag = filePtrGetc(fileptr);
    if (CGRIBEX_Debug) Message("flag        = %d", flag);

    fileSetPos(fileID, (off_t) pdssize - 8, SEEK_CUR);

    if (flag & 128)
    {
      gdssize = read3ByteMSBFirst(fileptr);
      fileSetPos(fileID, (off_t) gdssize - 3, SEEK_CUR);
      if (CGRIBEX_Debug) Message("gdssize     = %u", gdssize);
    }

    if (flag & 64)
    {
      bmssize = read3ByteMSBFirst(fileptr);
      fileSetPos(fileID, (off_t) bmssize - 3, SEEK_CUR);
      if (CGRIBEX_Debug) Message("bmssize     = %u", bmssize);
    }

    unsigned bdssize = read3ByteMSBFirst(fileptr);
    if (CGRIBEX_Debug) Message("bdssize     = %u", bdssize);

    gribsize = issize + pdssize + gdssize + bmssize + bdssize + essize;
    rgribsize = (size_t) gribsize;
  }
  else if (gribversion == 1)
  {
    if (gribsize > JP23SET)  // Large GRIB record
    {
      unsigned pdssize = read3ByteMSBFirst(fileptr);
      if (CGRIBEX_Debug) Message("pdssize     = %u", pdssize);

      int flag = 0;
      for (int i = 0; i < 5; ++i) flag = filePtrGetc(fileptr);
      if (CGRIBEX_Debug) Message("flag        = %d", flag);

      fileSetPos(fileID, (off_t) pdssize - 8, SEEK_CUR);

      unsigned gdssize = 0;
      if (flag & 128)
      {
        gdssize = read3ByteMSBFirst(fileptr);
        fileSetPos(fileID, (off_t) gdssize - 3, SEEK_CUR);
        if (CGRIBEX_Debug) Message("gdssize     = %u", gdssize);
      }

      unsigned bmssize = 0;
      if (flag & 64)
      {
        bmssize = read3ByteMSBFirst(fileptr);
        fileSetPos(fileID, (off_t) bmssize - 3, SEEK_CUR);
        if (CGRIBEX_Debug) Message("bmssize     = %u", bmssize);
      }

      unsigned bdssize = read3ByteMSBFirst(fileptr);
      if (CGRIBEX_Debug) Message("bdssize     = %u", bdssize);
      if (bdssize <= 120)
      {
        enum
        {
          issize = 4
        };
        gribsize &= JP23SET;
        gribsize *= 120;
        bdssize = correct_bdslen(bdssize, gribsize, issize + pdssize + gdssize + bmssize);
        if (CGRIBEX_Debug) Message("bdssize     = %u", bdssize);

        gribsize = issize + pdssize + gdssize + bmssize + bdssize + 4;
      }
    }
    rgribsize = (size_t) gribsize;
  }
  else if (gribversion == 2)
  {
    /* we set gribsize the following way because it doesn't matter then
       whether int is 4 or 8 bytes long - we don't have to care if the size
       really fits: if it does not, the record can not be read at all */
    rgribsize = 0;
    enum
    {
      g2size_bytes = 8
    };
    unsigned char g2size[g2size_bytes];
    filePtrRead(fileptr, g2size, g2size_bytes);
    for (int i = 0; i < g2size_bytes; ++i) rgribsize = (rgribsize << 8) | g2size[i];
  }
  else
  {
    rgribsize = 0;
    Warning("GRIB version %d unsupported!", gribversion);
  }

  if (filePtrEOF(fileptr)) rgribsize = 0;

  if (CGRIBEX_Debug) Message("gribsize = %zu", rgribsize);

  fileSetPos(fileID, pos, SEEK_SET);

  return rgribsize;
}

size_t
gribGetSize(int fileID)
{
  long offset;
  int ierr = gribFileSeek(fileID, &offset);  // position file pointer after GRIB
  if (ierr > 0)
  {
    Warning("GRIB record not found!");
    return 0;
  }

  if (ierr == -1) return 0;

  size_t recSize = gribReadSize(fileID);

  if (CGRIBEX_Debug) Message("recsize = %zu", recSize);

  fileSetPos(fileID, (off_t) -4, SEEK_CUR);

  return recSize;
}

int
gribRead(int fileID, void *buffer, size_t *buffersize)
{
  long offset;
  int ierr = gribFileSeek(fileID, &offset);  // position file pointer after GRIB
  if (ierr > 0)
  {
    Warning("GRIB record not found!");
    *buffersize = 0;
    return -2;
  }

  if (ierr == -1)
  {
    *buffersize = 0;
    return -1;
  }

  size_t recSize = gribReadSize(fileID);
  size_t readSize = recSize;

  if (readSize > *buffersize)
  {
    readSize = *buffersize;
    ierr = -3;  // Tell the caller that the buffer was insufficient.
  }

  *buffersize = recSize;  // Inform the caller about the record size.

  // Write the stuff to the buffer that has already been read in gribFileSeek().
  memcpy(buffer, "GRIB", 4);

  readSize -= 4;
  // Read the rest of the record into the buffer.
  size_t nread = fileRead(fileID, (char *) buffer + 4, readSize);

  if (nread != readSize) ierr = 1;

  return ierr;
}

int
gribWrite(int fileID, void *buffer, size_t buffersize)
{
  int nwrite = (int) (fileWrite(fileID, buffer, buffersize));
  if (nwrite != (int) buffersize)
  {
    perror(__func__);
    nwrite = -1;
  }

  return nwrite;
}
#include <string.h>
#include <ctype.h>

FILE *grprsm = NULL;
int CGRIBEX_grib_calendar = -1;

void
gribSetCalendar(int calendar)
{
  CGRIBEX_grib_calendar = calendar;
}

void
grsdef(void)
{
  /*
C---->
C**** GRSDEF - Initial (default) setting of common area variables
C              for GRIBEX package.
C
C     Purpose.
C     --------
C
C     Sets initial values for common area variables for all
C     routines of GRIBEX package, if not already done.
C
C**   Interface.
C     ----------
C
C     CALL GRSDEF
C
C     Input Parameters.
C     -----------------
C
C     None.
C
C     Output Parameters.
C     ------------------
C
C     None.
C
C     Method.
C     -------
C
C     Self-explanatory.
C
C     Externals.
C     ----------
C
C     None.
C
C     Reference.
C     ----------
C
C     See subroutine GRIBEX.
C
C     Comments.
C     ---------
C
C     None
C
C     Author.
C     -------
C
C     J. Clochard, Meteo France, for ECMWF - March 1998.
C
C     Modifications.
C     --------------
C
C     J. Clochard, Meteo France, for ECMWF - June 1999.
C     Add variable NSUBCE.
C     Use a static variable to determine if initialisation has already
C     been done. NUSER removed .
C     Reverse defaults for NEXT2O and NLOC2O, for consistency with
C     version 13.023 of software .
C
  */
  /*
C     ----------------------------------------------------------------
C*    Section 0 . Definition of variables.
C     ----------------------------------------------------------------
  */
  char *envString;
  char *env_stream;
  static bool lfirst = true;
  extern int CGRIBEX_Const;

  if (!lfirst) return;

  /*
    ----------------------------------------------------------------
    Section 1 . Set values, conditionally.
    ----------------------------------------------------------------
  */
  /*
    Common area variables have not been set. Set them.
  */
  // Set GRIB calendar.
  if (CGRIBEX_grib_calendar == -1)
  {
    CGRIBEX_grib_calendar = CALENDAR_PROLEPTIC;

    envString = getenv("GRIB_CALENDAR");
    if (envString)
    {
      if (strncmp(envString, "standard", 8) == 0)
        CGRIBEX_grib_calendar = CALENDAR_STANDARD;
      else if (strncmp(envString, "proleptic", 9) == 0)
        CGRIBEX_grib_calendar = CALENDAR_PROLEPTIC;
      else if (strncmp(envString, "360days", 7) == 0)
        CGRIBEX_grib_calendar = CALENDAR_360DAYS;
      else if (strncmp(envString, "365days", 7) == 0)
        CGRIBEX_grib_calendar = CALENDAR_365DAYS;
      else if (strncmp(envString, "366days", 7) == 0)
        CGRIBEX_grib_calendar = CALENDAR_366DAYS;
      else if (strncmp(envString, "none", 4) == 0)
        CGRIBEX_grib_calendar = CALENDAR_NONE;
    }
  }
  // Set GRIBEX compatibility mode.
  envString = getenv("GRIB_GRIBEX_MODE_ON");
  if (envString != NULL)
  {
    if (atoi(envString) == 1) CGRIBEX_Const = 0;
  }

  // See if output stream needs changing
  grprsm = stdout;
  env_stream = getenv("GRPRS_STREAM");
  if (env_stream)
  {
    if (isdigit((int) env_stream[0]))
    {
      int unit;
      unit = atoi(env_stream);
      if (unit < 1 || unit > 99)
        Warning("Invalid number for GRPRS_STREAM: %d", unit);
      else if (unit == 2)
        grprsm = stderr;
      else if (unit == 6)
        grprsm = stdout;
      else
      {
        char filename[] = "unit.00";
        snprintf(filename, sizeof(filename), "%2.2d", unit);
        grprsm = fopen(filename, "w");
        if (!grprsm) SysError("GRPRS_STREAM = %d", unit);
      }
    }
    else
    {
      if (env_stream[0])
      {
        grprsm = fopen(env_stream, "w");
        if (!grprsm) SysError("GRPRS_STREAM = %s", env_stream);
      }
    }
  }
  // Mark common area values set by user.
  lfirst = false;
}

// clang-format off

/* pack 8-bit bytes from 64-bit words to a packed buffer */
/* same as : for (int i = 0; i < bc; ++i) cp[i] = (unsigned char) up[i]; */

long packInt64(uint64_t *up, unsigned char *cp, long bc, long tc)
{
#if defined (CRAY)
  (void) _pack(up, cp, bc, tc);
#else
  unsigned char *cp0;
  uint64_t upi, *up0, *ip0, *ip1, *ip2, *ip3, *ip4, *ip5, *ip6, *ip7;
  long ipack = sizeof(int64_t);
  
  // Bytes until first word boundary in destination buffer

  long head = ( (long) cp ) & (ipack-1);
  if ( head != 0 ) head = ipack - head;

  long inner = bc - head;

  // Trailing bytes which do not make a full word

  long trail = inner & (ipack-1);

  // Number of bytes/words to be processed in fast loop

  inner -= trail;
  inner /= ipack;

  ip0 = up + head;
  ip1 = ip0 + 1;
  ip2 = ip0 + 2;
  ip3 = ip0 + 3;
  ip4 = ip0 + 4;
  ip5 = ip0 + 5;
  ip6 = ip0 + 6;
  ip7 = ip0 + 7;

  up0 = (uint64_t *)(void *)(cp + head);

  /* Here we should process any bytes until the first word boundary 
   * of our destination buffer 
   * That code is missing so far  because our output buffer is 
   * word aligned by FORTRAN 
   */

  long j = 0;

  if ( IS_BIGENDIAN() )
    {
#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
      for (long i = 0; i < inner; ++i)
	{
	  upi =             (   ip0[j]          << 56 ) 
	                 |  ( ( ip1[j] & 0xFF ) << 48 )
	                 |  ( ( ip2[j] & 0xFF ) << 40 )
	                 |  ( ( ip3[j] & 0xFF ) << 32 )
	                 |  ( ( ip4[j] & 0xFF ) << 24 ) ;
	  up0[i] = upi   |  ( ( ip5[j] & 0xFF ) << 16 )
	                 |  ( ( ip6[j] & 0xFF ) <<  8 )
	                 |    ( ip7[j] & 0xFF ) ;
	  j += ipack;
	}
    }
  else
    {
      for (long i = 0; i < inner; ++i)
	{
	  upi =             (   ip7[j]          << 56 ) 
	                 |  ( ( ip6[j] & 0xFF ) << 48 )
                         |  ( ( ip5[j] & 0xFF ) << 40 )
                         |  ( ( ip4[j] & 0xFF ) << 32 )
                         |  ( ( ip3[j] & 0xFF ) << 24 ) ;
	  up0[i] = upi   |  ( ( ip2[j] & 0xFF ) << 16 )
                         |  ( ( ip1[j] & 0xFF ) <<  8 )
                         |    ( ip0[j] & 0xFF ) ;
	  j += ipack;
	}
    }

  cp0 = (unsigned char *) ( up0 + inner );
  if ( trail > 0 )
    {
      up0[inner] = 0;
      for (long i = 0; i < trail ; ++i)
	{
	  *cp0 = (unsigned char) ip0[ipack*inner+i];
	  cp0++;
	}
    }

  if ( tc != -1 )
    {
      bc++;
      *cp0 = (unsigned char) tc;
    }
#endif
  return (bc);
}

/* unpack 8-bit bytes from a packed buffer with 64-bit words */
/* same as : for (int i = 0; i < bc; ++i) up[i] = (int64_t) cp[i]; */

long unpackInt64(const unsigned char *cp, uint64_t *up, long bc, long tc)
{
  const unsigned char *cp0;
  uint64_t *ip0, *ip1, *ip2, *ip3, *ip4, *ip5, *ip6, *ip7;
  long offset;
  long ipack = sizeof(int64_t);

  UNUSED(tc);

  // Bytes until first word boundary in source buffer

  long head = ( (long) cp ) & (ipack-1);
  if ( head != 0 ) head = ipack - head;
  if ( head > bc ) head = bc;

  long inner = bc - head;

  // Trailing bytes which do not make a full word
 
  long trail = inner & (ipack-1);
 
  // Number of bytes/words to be processed in fast loop

  inner -= trail;
  inner /= ipack;

  ip0 = up + head;
  ip1 = ip0 + 1;
  ip2 = ip0 + 2;
  ip3 = ip0 + 3;
  ip4 = ip0 + 4;
  ip5 = ip0 + 5;
  ip6 = ip0 + 6;
  ip7 = ip0 + 7;

  const uint64_t *up0 = (const uint64_t *)(const void *)(cp + head);

  /* Process any bytes until the first word boundary 
   * of our source buffer 
   */
  for (long i = 0; i < head; ++i) up[i] = (uint64_t) cp[i];

  long j = 0;

  if ( IS_BIGENDIAN() )
    {
#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
      for (long i = 0; i < inner; ++i)
	{
	  ip0[j] = (up0[i] >> 56) & 0xFF;
	  ip1[j] = (up0[i] >> 48) & 0xFF;
	  ip2[j] = (up0[i] >> 40) & 0xFF;
	  ip3[j] = (up0[i] >> 32) & 0xFF;
	  ip4[j] = (up0[i] >> 24) & 0xFF;
	  ip5[j] = (up0[i] >> 16) & 0xFF;
	  ip6[j] = (up0[i] >>  8) & 0xFF;
	  ip7[j] = (up0[i])       & 0xFF;

	  j += ipack;
	}
    }
  else
    {
      for (long i = 0; i < inner; ++i)
	{
	  ip7[j] = (up0[i] >> 56) & 0xFF;
	  ip6[j] = (up0[i] >> 48) & 0xFF;
	  ip5[j] = (up0[i] >> 40) & 0xFF;
	  ip4[j] = (up0[i] >> 32) & 0xFF;
	  ip3[j] = (up0[i] >> 24) & 0xFF;
	  ip2[j] = (up0[i] >> 16) & 0xFF;
	  ip1[j] = (up0[i] >>  8) & 0xFF;
	  ip0[j] = (up0[i])       & 0xFF;

	  j += ipack;
	}
    }

  if ( trail > 0 )
    {
      offset = head + ipack*inner;
      cp0 = cp + offset;
      for (long i = 0; i < trail; ++i) up[i+offset] = (uint64_t) cp0[i];
    }
  /*
  if ( tc != -1 ) {
    bc++;
    *cp0 = (unsigned char) tc;
  }
  */
  return bc;
}

/* pack 8-bit bytes from 32-bit words to a packed buffer */
/* same as : for (int i = 0; i < bc; ++i) cp[i] = (char) up[i]; */

long packInt32(uint32_t  *up, unsigned char *cp, long bc, long tc)
{
  unsigned char *cp0;
  uint32_t *up0, *ip0, *ip1, *ip2, *ip3;
  long ipack = sizeof(int32_t);
  
  // Bytes until first word boundary in destination buffer

  long head = ( (long) cp ) & (ipack-1);
  if ( head != 0 ) head = ipack - head;

  long inner = bc - head;

  // Trailing bytes which do not make a full word

  long trail = inner & (ipack-1);

  // Number of bytes/words to be processed in fast loop

  inner -= trail;
  inner /= ipack;

  ip0 = up + head;
  ip1 = ip0 + 1;
  ip2 = ip0 + 2;
  ip3 = ip0 + 3;

  up0 = (uint32_t *)(void *)(cp + head);

  /* Here we should process any bytes until the first word boundary 
   * of our destination buffer 
   * That code is missing so far  because our output buffer is 
   * word aligned by FORTRAN 
   */

  long j = 0;

  if ( IS_BIGENDIAN() )
    {
#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
      for (long i = 0; i < inner; ++i)
	{
	  up0[i] =          (   ip0[j]          << 24 ) 
	                 |  ( ( ip1[j] & 0xFF ) << 16 )
	                 |  ( ( ip2[j] & 0xFF ) <<  8 )
	                 |    ( ip3[j] & 0xFF ) ;
	  j += ipack;
	}
    }
  else
    {
      for (long i = 0; i < inner; ++i)
	{
	  up0[i] =          (   ip3[j]          << 24 ) 
	                 |  ( ( ip2[j] & 0xFF ) << 16 )
                         |  ( ( ip1[j] & 0xFF ) <<  8 )
                         |    ( ip0[j] & 0xFF ) ;
	  j += ipack;
	}
    }

  cp0 = (unsigned char *) ( up0 + inner );
  if ( trail > 0 )
    {
      up0[inner] = 0;
      for (long i = 0; i < trail; ++i)
	{
	  *cp0 = (unsigned char) ip0[ipack*inner+i];
	  cp0++;
	}
    }

  if ( tc != -1 )
    {
      bc++;
      *cp0 = (unsigned char) tc;
    }

  return (bc);
}

/* unpack 8-bit bytes from a packed buffer with 32-bit words */
/* same as : for (int i = 0; i < bc; ++i) up[i] = (int32_t) cp[i]; */

long unpackInt32(const unsigned char *cp, uint32_t *up, long bc, long tc)
{
  const unsigned char *cp0;
  uint32_t *ip0, *ip1, *ip2, *ip3;
  long offset;
  long ipack = sizeof(int32_t);

  UNUSED(tc);

  // Bytes until first word boundary in source buffer

  long head = ( (long) cp ) & (ipack-1);
  if ( head != 0 ) head = ipack - head;
  if ( head > bc ) head = bc;

  long inner = bc - head;

  // Trailing bytes which do not make a full word
 
  long trail = inner & (ipack-1);
 
  // Number of bytes/words to be processed in fast loop

  inner -= trail;
  inner /= ipack;

  ip0 = up + head;
  ip1 = ip0 + 1;
  ip2 = ip0 + 2;
  ip3 = ip0 + 3;

  const uint32_t *up0 = (const uint32_t *)(const void *)(cp + head);

  /* Process any bytes until the first word boundary 
   * of our source buffer 
   */
  for (long i = 0; i < head; ++i) up[i] = (uint32_t) cp[i];

  long j = 0;

  if ( IS_BIGENDIAN() )
    {
#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
      for (long i = 0; i < inner; ++i)
	{
	  ip0[j] = (up0[i] >> 24) & 0xFF;
	  ip1[j] = (up0[i] >> 16) & 0xFF;
	  ip2[j] = (up0[i] >>  8) & 0xFF;
	  ip3[j] = (up0[i])       & 0xFF;

	  j += ipack;
	}
    }
  else
    {
      for (long i = 0; i < inner; ++i)
	{
	  ip3[j] = (up0[i] >> 24) & 0xFF;
	  ip2[j] = (up0[i] >> 16) & 0xFF;
	  ip1[j] = (up0[i] >>  8) & 0xFF;
	  ip0[j] = (up0[i])       & 0xFF;

	  j += ipack;
	}
    }

  if ( trail > 0 )
    {
      offset = head + ipack*inner;
      cp0 = cp + offset;
      for (long i = 0; i < trail; ++i) up[i+offset] = (uint32_t) cp0[i];
    }
  /*
  if ( tc != -1 ) {
    bc++;
    *cp0 = (unsigned char) tc;
  }
  */

  return (bc);
}

// clang-format on
#include <stdio.h>

void
prtbin(int kin, int knbit, int *kout, int *kerr)
{
  /*

    Produces a decimal number with ones and zeroes
    corresponding to the ones and zeroes of the input
    binary number.
    eg input number 1011 binary, output number 1011 decimal.


    Input Parameters:

       kin   - Integer variable containing binary number.

       knbit - Number of bits in binary number.

    Output Parameters:

       kout  - Integer variable containing decimal value
               with ones and zeroes corresponding to those of
               the input binary number.

       kerr  - 0, If no error.
               1, Number of bits in binary number exceeds
                  maximum allowed or is less than 1.


    Converted from EMOS routine PRTBIN.

       Uwe Schulzweida   MPIfM   01/04/2001

  */
  int idec;
  int ik;
  int itemp;

  /*
    Check length of binary number to ensure decimal number
    generated will fit in the computer word - in this case will
    it fit in a Cray 48 bit integer?
  */
  if (knbit < 1 || knbit > 14)
  {
    *kerr = 1;
    printf(" prtbin : Error in binary number length - %3d bits.\n", knbit);
    return;
  }
  else
    *kerr = 0;
  /*
    -----------------------------------------------------------------
    Section 1. Generate required number.
    -----------------------------------------------------------------
  */
  *kout = 0;
  ik = kin;
  idec = 1;

  for (int j = 0; j < knbit; ++j)
  {
    itemp = ik - ((ik / 2) * 2);
    *kout = (*kout) + itemp * idec;
    ik = ik / 2;
    idec = idec * 10;
  }

  return;
}

void
ref2ibm(double *pref, int kbits)
{
  /*

    Purpose:
    --------

    Code and check reference value in IBM format

    Input Parameters:
    -----------------

    pref       - Reference value
    kbits      - Number of bits per computer word.

    Output Parameters:
    ------------------

    pref       - Reference value

    Method:
    -------

    Codes in IBM format, then decides to ensure that reference
    value used for packing is not different from that stored
    because of packing differences.

    Externals.
    ----------

    confp3    - Encode into IBM floating point format.
    decfp2    - Decode from IBM floating point format.

    Reference:
    ----------

    None.

    Comments:
    --------

    None.

    Author:
    -------

    J.D.Chambers     ECMWF      17:05:94

    Modifications:
    --------------

    Uwe Schulzweida   MPIfM   01/04/2001

    Convert to C from EMOS library version 130

  */

  int itrnd;
  int kexp, kmant;
  double ztemp, zdumm;
  extern int CGRIBEX_Debug;

  /* ----------------------------------------------------------------- */
  /*   Section 1. Convert to and from IBM format.                      */
  /* ----------------------------------------------------------------- */

  /*  Convert floating point reference value to IBM representation. */

  itrnd = 1;
  zdumm = ztemp = *pref;
  confp3(zdumm, &kexp, &kmant, kbits, itrnd);

  if (kexp == 0 && kmant == 0) return;

  /*  Set reference value to that actually stored in the GRIB code. */

  *pref = decfp2(kexp, kmant);

  /*  If the nearest number which can be represented in */
  /*  GRIB format is greater than the reference value,  */
  /*  find the nearest number in GRIB format lower      */
  /*  than the reference value.                         */

  if (ztemp < *pref)
  {
    /*  Convert floating point to GRIB representation */
    /*  using truncation to ensure that the converted */
    /*  number is smaller than the original one.      */

    itrnd = 0;
    zdumm = ztemp;
    confp3(zdumm, &kexp, &kmant, kbits, itrnd);

    /*  Set reference value to that stored in the GRIB code. */

    *pref = decfp2(kexp, kmant);

    if (ztemp < *pref)
    {
      if (CGRIBEX_Debug)
      {
        Message("Reference value error.");
        Message("Notify Met.Applications Section.");
        Message("ZTEMP = ", ztemp);
        Message("PREF = ", pref);
      }
      *pref = ztemp;
    }
  }

  return;
} /* ref2ibm */
#include <math.h>
#include <string.h>

unsigned
correct_bdslen(unsigned bdslen, long recsize, long gribpos)
{
  /*
    If a very large product, the section 4 length field holds
    the number of bytes in the product after section 4 upto
    the end of the padding bytes.
    This is a fixup to get round the restriction on product lengths
    due to the count being only 24 bits. It is only possible because
    the (default) rounding for GRIB products is 120 bytes.
  */
  if (recsize > JP23SET && bdslen <= 120) bdslen = (unsigned) (recsize - gribpos - bdslen);
  return bdslen;
}

int
grib1Sections(unsigned char *gribbuffer, long gribbufsize, unsigned char **pdsp, unsigned char **gdsp, unsigned char **bmsp,
              unsigned char **bdsp, long *gribrecsize)
{
  *gribrecsize = 0;
  *pdsp = NULL;
  *gdsp = NULL;
  *bmsp = NULL;
  *bdsp = NULL;

  unsigned char *section = gribbuffer;
  unsigned char *is = gribbuffer;
  if (!GRIB_START(section))
  {
    fprintf(stderr, "Wrong GRIB indicator section: found >%c%c%c%c<\n", section[0], section[1], section[2], section[3]);
    return -1;
  }

  unsigned recsize = GET_UINT3(section[4], section[5], section[6]);

  int gribversion = GRIB_EDITION(section);
  if (gribversion != 0 && gribversion != 1)
  {
    fprintf(stderr, "Error while decoding GRIB1 sections: GRIB edition %d records not supported!\n", gribversion);
    return -1;
  }

  unsigned grib1offset = (gribversion == 1) ? 4 : 0;

  unsigned char *pds = is + 4 + grib1offset;
  unsigned char *bufpointer = pds + PDS_Len;
  unsigned gribsize = 4 + grib1offset + PDS_Len;

  unsigned char *gds = NULL;
  if (PDS_HAS_GDS)
  {
    gds = bufpointer;
    bufpointer += GDS_Len;
    gribsize += GDS_Len;
  }

  unsigned char *bms = NULL;
  if (PDS_HAS_BMS)
  {
    bms = bufpointer;
    bufpointer += BMS_Len;
    gribsize += BMS_Len;
  }

  unsigned char *bds = bufpointer;
  unsigned bdslen = BDS_Len;
  if (recsize > JP23SET && bdslen <= 120)
  {
    recsize &= JP23SET;
    recsize *= 120;
    bdslen = correct_bdslen(bdslen, recsize, gribsize);
  }
  bufpointer += bdslen;
  gribsize += bdslen;
  gribsize += 4;

  *pdsp = pds;
  *gdsp = gds;
  *bmsp = bms;
  *bdsp = bds;

  *gribrecsize = gribsize;
  if (gribbufsize < gribsize)
  {
    fprintf(stderr, "Inconsistent length of GRIB message (grib_buffer_size=%ld < grib_record_size=%u)!\n", gribbufsize, gribsize);
    return 1;
  }

  if (!GRIB_FIN(bufpointer))  // end section - "7777" in ASCII
  {
    fprintf(stderr, "Missing GRIB end section: found >%c%c%c%c<\n", bufpointer[0], bufpointer[1], bufpointer[2], bufpointer[3]);
    return -2;
  }

  return 0;
}

int
grib2Sections(unsigned char *gribbuffer, long gribbufsize, unsigned char **idsp, unsigned char **lusp, unsigned char **gdsp,
              unsigned char **pdsp, unsigned char **drsp, unsigned char **bmsp, unsigned char **bdsp)
{
  UNUSED(gribbufsize);

  *idsp = NULL;
  *lusp = NULL;
  *gdsp = NULL;
  *pdsp = NULL;
  *drsp = NULL;
  *bmsp = NULL;
  *bdsp = NULL;

  unsigned char *section = gribbuffer;
  unsigned sec_len = 16;

  if (!GRIB_START(section))
  {
    fprintf(stderr, "wrong indicator section >%c%c%c%c<\n", section[0], section[1], section[2], section[3]);
    return -1;
  }

  int gribversion = GRIB_EDITION(section);
  if (gribversion != 2)
  {
    fprintf(stderr, "wrong GRIB version %d\n", gribversion);
    return -1;
  }

  unsigned gribsize = 0;
  for (int i = 0; i < 8; ++i) gribsize = (gribsize << 8) | section[8 + i];

  unsigned grib_len = sec_len;
  section += sec_len;

  /* section 1 */
  sec_len = GRIB2_SECLEN(section);
  int sec_num = GRIB2_SECNUM(section);
  // fprintf(stderr, "ids %d %ld\n", sec_num, sec_len);

  if (sec_num != 1)
  {
    fprintf(stderr, "Unexpected section1 number %d\n", sec_num);
    return -1;
  }

  *idsp = section;

  grib_len += sec_len;
  section += sec_len;

  /* section 2 and 3 */
  sec_len = GRIB2_SECLEN(section);
  sec_num = GRIB2_SECNUM(section);
  // fprintf(stderr, "lus %d %ld\n", sec_num, sec_len);

  if (sec_num == 2)
  {
    *lusp = section;

    grib_len += sec_len;
    section += sec_len;

    /* section 3 */
    sec_len = GRIB2_SECLEN(section);
    // sec_num = GRIB2_SECNUM(section);
    // fprintf(stderr, "gds %d %ld\n", sec_num, sec_len);

    *gdsp = section;
  }
  else if (sec_num == 3) { *gdsp = section; }
  else
  {
    fprintf(stderr, "Unexpected section3 number %d\n", sec_num);
    return -1;
  }

  grib_len += sec_len;
  section += sec_len;

  /* section 4 */
  sec_len = GRIB2_SECLEN(section);
  sec_num = GRIB2_SECNUM(section);
  // fprintf(stderr, "pds %d %ld\n", sec_num, sec_len);

  if (sec_num != 4)
  {
    fprintf(stderr, "Unexpected section4 number %d\n", sec_num);
    return -1;
  }

  *pdsp = section;

  grib_len += sec_len;
  section += sec_len;

  /* section 5 */
  sec_len = GRIB2_SECLEN(section);
  sec_num = GRIB2_SECNUM(section);
  // fprintf(stderr, "drs %d %ld\n", sec_num, sec_len);

  if (sec_num != 5)
  {
    fprintf(stderr, "Unexpected section5 number %d\n", sec_num);
    return -1;
  }

  *drsp = section;

  grib_len += sec_len;
  section += sec_len;

  /* section 6 */
  sec_len = GRIB2_SECLEN(section);
  sec_num = GRIB2_SECNUM(section);
  // fprintf(stderr, "bms %d %ld\n", sec_num, sec_len);

  if (sec_num != 6)
  {
    fprintf(stderr, "Unexpected section6 number %d\n", sec_num);
    return -1;
  }

  *bmsp = section;

  grib_len += sec_len;
  section += sec_len;

  /* section 7 */
  sec_len = GRIB2_SECLEN(section);
  sec_num = GRIB2_SECNUM(section);
  // fprintf(stderr, "bds %d %ld\n", sec_num, sec_len);

  if (sec_num != 7)
  {
    fprintf(stderr, "Unexpected section7 number %d\n", sec_num);
    return -1;
  }

  *bdsp = section;

  grib_len += sec_len;
  section += sec_len;

  /* skip multi GRIB sections */
  int msec = 1;
  while (!GRIB_FIN(section))
  {
    sec_len = GRIB2_SECLEN(section);
    sec_num = GRIB2_SECNUM(section);

    if (sec_num < 1 || sec_num > 7) break;

    if (sec_num == 7) fprintf(stderr, "Skipped unsupported multi GRIB section %d!\n", ++msec);

    if ((grib_len + sec_len) > gribsize) break;

    grib_len += sec_len;
    section += sec_len;
  }

  /* end section - "7777" in ASCII */
  if (!GRIB_FIN(section))
  {
    fprintf(stderr, "Missing end section >%2x %2x %2x %2x<\n", section[0], section[1], section[2], section[3]);
    return -2;
  }

  return 0;
}

int
grib_info_for_grads(off_t recpos, long recsize, unsigned char *gribbuffer, int *intnum, float *fltnum, off_t *bignum)
{
  long gribsize = 0;
  off_t bpos = 0;

  unsigned char *section = gribbuffer;
  unsigned char *is = gribbuffer;
  if (!GRIB_START(section))
  {
    fprintf(stderr, "wrong indicator section >%c%c%c%c<\n", section[0], section[1], section[2], section[3]);
    return -1;
  }

  int gribversion = GRIB_EDITION(section);
  if (recsize == 24 && gribversion == 0) gribversion = 0;

  unsigned grib1offset = (gribversion == 1) ? 4 : 0;

  unsigned char *pds = is + 4 + grib1offset;
  unsigned char *bufpointer = pds + PDS_Len;
  gribsize += 4 + grib1offset + PDS_Len;

  unsigned char *gds = NULL;
  if (PDS_HAS_GDS)
  {
    gds = bufpointer;
    bufpointer += GDS_Len;
    gribsize += GDS_Len;
  }

  unsigned char *bms = NULL;
  if (PDS_HAS_BMS)
  {
    bms = bufpointer;
    bufpointer += BMS_Len;
    bpos = recpos + gribsize + 6;
    gribsize += BMS_Len;
  }

  unsigned char *bds = bufpointer;

  off_t dpos = recpos + gribsize + 11;

  unsigned bdslen = BDS_Len;
  bdslen = correct_bdslen(bdslen, recsize, bds - gribbuffer);
  bufpointer += bdslen;
  gribsize += bdslen;
  gribsize += 4;

  if (gribsize > recsize)
  {
    fprintf(stderr, "GRIB buffer size %ld too small! Min size = %ld\n", recsize, gribsize);
    return 1;
  }

  /* end section - "7777" in ascii */
  if (!GRIB_FIN(bufpointer))
  {
    fprintf(stderr, "Missing end section >%2x %2x %2x %2x<\n", bufpointer[0], bufpointer[1], bufpointer[2], bufpointer[3]);
  }

  int bs = BDS_BinScale;
  if (bs > 32767) bs = 32768 - bs;
  float bsf = ldexpf(1.0f, bs);

  bignum[0] = dpos;
  bignum[1] = bms ? bpos : -999;
  intnum[0] = BDS_NumBits;

  /*  fltnum[0] = 1.0; */
  fltnum[0] = powf(10.0f, (float) PDS_DecimalScale);
  fltnum[1] = bsf;
  fltnum[2] = (float) BDS_RefValue;
  /*
  printf("intnum %d %d %d\n", intnum[0], intnum[1], intnum[2]);
  printf("fltnum %g %g %g\n", fltnum[0], fltnum[1], fltnum[2]);
  */
  return 0;
}

static int
get_level(unsigned char *pds)
{
  int level = 0;

  if (PDS_LevelType == 100)
    level = (int) (PDS_Level) *100;
  else if (PDS_LevelType == 99 || PDS_LevelType == 109)
    level = (int) (PDS_Level);
  else
    level = PDS_Level1;

  return level;
}

static double
get_cr(unsigned char *w1, unsigned char *w2)
{
  unsigned s1 = GET_UINT3(w1[0], w1[1], w1[2]);
  unsigned s2 = GET_UINT3(w2[0], w2[1], w2[2]);
  return ((double) s1) / s2;
}

static void
grib1PrintALL(int nrec, long offset, long recpos, long recsize, unsigned char *gribbuffer)
{
  static bool header = true;
  unsigned char *is = NULL, *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;

  if (header)
  {
    fprintf(stdout, "  Rec : Off Position   Size : V PDS  GDS    BMS    BDS : Code Level :  LType GType: CR LL\n");
    //               ----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+
    header = false;
  }

  is = gribbuffer;

  unsigned gribsize = GET_UINT3(is[4], is[5], is[6]);

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d :%4ld %8ld %6ld : GRIB message error\n", nrec, offset, recpos, recsize);
    return;
  }

  int GridType = (gds == NULL) ? -1 : (int) GDS_GridType;

  int level = get_level(pds);

  unsigned bdslen = BDS_Len;

  bool llarge = (gribsize > JP23SET && bdslen <= 120);

  bdslen = correct_bdslen(bdslen, recsize, bds - gribbuffer);

  double cr = (((BDS_Flag >> 4) & 1) && (BDS_Z == 128 || BDS_Z == 130)) ? get_cr(&bds[14], &gribbuffer[4]) : 1;

  fprintf(stdout, "%5d :%4ld %8ld %6ld :%2d%4d%5d %6d %6d : %3d %6d : %5d %5d %6.4g  %c", nrec, offset, recpos, recsize,
          GRIB_EDITION(is), PDS_Len, GDS_Len, BMS_Len, bdslen, PDS_Parameter, level, PDS_LevelType, GridType, cr,
          llarge ? 'T' : 'F');

  if (nerr > 0) fprintf(stdout, " <-- GRIB data corrupted!");
  fprintf(stdout, "\n");
}

static void
grib2PrintALL(int nrec, long offset, long recpos, long recsize, unsigned char *gribbuffer)
{
  static bool header = true;
  unsigned char *is = NULL, *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;
  unsigned char *ids = NULL, *lus = NULL, *drs = NULL;
  long ids_len = 0, lus_len = 0, gds_len = 0, pds_len = 0, drs_len = 0, bms_len = 0, bds_len = 0;
  double cr = 1;

  if (header)
  {
    fprintf(stdout, "  Rec : Off Position   Size : V IDS LUS GDS PDS  DRS    BMS    BDS : Parameter   Level :  LType GType: CR\n");
    //       ----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+
    header = false;
  }

  is = gribbuffer;

  int nerr = grib2Sections(gribbuffer, recsize, &ids, &lus, &gds, &pds, &drs, &bms, &bds);
  if (nerr)
  {
    fprintf(stdout, "%5d :%4ld %8ld %6ld : error\n", nrec, offset, recpos, recsize);
    return;
  }

  if (ids) ids_len = GRIB2_SECLEN(ids);
  if (lus) lus_len = GRIB2_SECLEN(lus);
  if (gds) gds_len = GRIB2_SECLEN(gds);
  if (pds) pds_len = GRIB2_SECLEN(pds);
  if (drs) drs_len = GRIB2_SECLEN(drs);
  if (bms) bms_len = GRIB2_SECLEN(bms);
  if (bds) bds_len = GRIB2_SECLEN(bds);

  // double cr = (((BDS_Flag >> 4)&1) && (BDS_Z == 128 || BDS_Z == 130)) ? get_cr(&bds[14], &gribbuffer[4]) : 1;

  int dis = GET_UINT1(is[6]);
  int gridtype = (int) (GET_UINT2(gds[12], gds[13]));
  int paramcat = GET_UINT1(pds[9]);
  int paramnum = GET_UINT1(pds[10]);
  int level1type = GET_UINT1(pds[22]);
  /* level1sf   = GET_UINT1(pds[23]); */
  int level1 = (int) (GET_UINT4(pds[24], pds[25], pds[26], pds[27]));
  /* level2type = GET_UINT1(pds[28]); */
  /* level2sf   = GET_UINT1(pds[29]); */
  /* level2     = GET_UINT4(pds[30],pds[31],pds[32],pds[33]); */
  /*
  printf("level %d %d %d %d %d %d %d\n", level1type, level1sf, level1, level1*level1sf, level2sf, level2, level2*level2sf);
  */
  char paramstr[16];
  snprintf(paramstr, sizeof(paramstr), "%d.%d.%d", paramnum, paramcat, dis);
  fprintf(stdout, "%5d :%4ld %8ld %6ld :%2d %3ld %3ld %3ld %3ld %4ld %6ld %6ld : %-9s %7d : %5d %5d %6.4g\n", nrec, offset, recpos,
          recsize, GRIB_EDITION(is), ids_len, lus_len, gds_len, pds_len, drs_len, bms_len, bds_len, paramstr, level1, level1type,
          gridtype, cr);
}

void
gribPrintALL(int nrec, long offset, long recpos, long recsize, unsigned char *gribbuffer)
{
  int gribversion = gribVersion(gribbuffer, (size_t) recsize);

  if (gribversion == 0 || gribversion == 1)
    grib1PrintALL(nrec, offset, recpos, recsize, gribbuffer);
  else if (gribversion == 2)
    grib2PrintALL(nrec, offset, recpos, recsize, gribbuffer);
  else { fprintf(stdout, "%5d :%4ld%9ld%7ld : GRIB version %d unsupported\n", nrec, offset, recpos, recsize, gribversion); }
}

static void
grib1PrintPDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  static int header = 1;
  unsigned char *is = NULL, *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;
  int century, subcenter, decimalscale;
  int fc_num = 0;
  int year = 0, date;

  UNUSED(recpos);

  if (header)
  {
    fprintf(stdout, "  Rec : PDS Tab Cen Sub Ver Grid Code LTyp Level1 Level2    Date  Time P1 P2 TU TR NAVE Scale FCnum CT\n");
    //               ----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+
    header = 0;
  }

  is = gribbuffer;

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d : GRIB message error\n", nrec);
    return;
  }

  switch (GRIB_EDITION(is))
  {
    case 0:
      year = GET_UINT1(pds[12]);
      century = 1;
      subcenter = 0;
      decimalscale = 0;
      break;
    case 1:
      year = PDS_Year;
      century = PDS_Century;
      subcenter = PDS_Subcenter;
      decimalscale = PDS_DecimalScale;
      break;
    default: fprintf(stderr, "Grib version %d not supported!", GRIB_EDITION(is)); exit(EXIT_FAILURE);
  }

  if (PDS_Len > 28)
    if (PDS_CenterID == 98 || PDS_Subcenter == 98 || (PDS_CenterID == 7 && PDS_Subcenter == 98))
      if (pds[40] == 1) fc_num = GET_UINT1(pds[49]);

  if (year < 0)
  {
    date = (-year) * 10000 + (int) PDS_Month * 100 + (int) PDS_Day;
    century = -century;
  }
  else { date = year * 10000 + (int) PDS_Month * 100 + (int) PDS_Day; }

  fprintf(stdout, "%5d :%4d%4d%4d%4d%4d %4d %4d%4d%7d%7d %8d%6d%3d%3d%3d%3d%5d%6d%5d%4d", nrec, PDS_Len, PDS_CodeTable,
          PDS_CenterID, subcenter, PDS_ModelID, PDS_GridDefinition, PDS_Parameter, PDS_LevelType, PDS_Level1, PDS_Level2, date,
          PDS_Time, PDS_TimePeriod1, PDS_TimePeriod2, PDS_TimeUnit, PDS_TimeRange, PDS_AvgNum, decimalscale, fc_num, century);

  if (nerr > 0) fprintf(stdout, " <-- GRIB data corrupted!");
  fprintf(stdout, "\n");
}

void
gribPrintPDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  int gribversion = gribVersion(gribbuffer, (size_t) recsize);

  if (gribversion == 0 || gribversion == 1) grib1PrintPDS(nrec, recpos, recsize, gribbuffer);
  /*
  else if ( gribversion == 2 )
    grib2PrintPDS(nrec, recpos, recsize, gribbuffer);
  */
  else { fprintf(stdout, "%5d :%4ld%9ld%7ld : GRIB version %d unsupported\n", nrec, 0L, recpos, recsize, gribversion); }
}

static void
grib1PrintGDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  static int header = 1;
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;

  UNUSED(recpos);

  if (header)
  {
    fprintf(stdout, "  Rec : GDS  NV PVPL Typ : xsize ysize   Lat1   Lon1   Lat2   Lon2    dx    dy\n");
    //               ----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+
    header = 0;
  }

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d : GRIB message error\n", nrec);
    return;
  }

  fprintf(stdout, "%5d :", nrec);

  if (gds)
    fprintf(stdout, "%4d%4d%4d %4d :%6d%6d%7d%7d%7d%7d%6d%6d", GDS_Len, GDS_NV, GDS_PVPL, GDS_GridType, GDS_NumLon, GDS_NumLat,
            GDS_FirstLat, GDS_FirstLon, GDS_LastLat, GDS_LastLon, GDS_LonIncr, GDS_LatIncr);
  else
    fprintf(stdout, " Grid Description Section not defined");

  if (nerr > 0) fprintf(stdout, " <-- GRIB data corrupted!");
  fprintf(stdout, "\n");
}

void
gribPrintGDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  int gribversion = gribVersion(gribbuffer, (size_t) recsize);

  if (gribversion == 0 || gribversion == 1) grib1PrintGDS(nrec, recpos, recsize, gribbuffer);
  /*
  else if ( gribversion == 2 )
    grib2PrintGDS(nrec, recpos, recsize, gribbuffer);
  */
  else { fprintf(stdout, "%5d :%4ld%9ld%7ld : GRIB version %d unsupported\n", nrec, 0L, recpos, recsize, gribversion); }
}

static void
grib1PrintBMS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  static int header = 1;
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;

  UNUSED(recpos);

  if (header)
  {
    fprintf(stdout, "  Rec : Code Level     BMS    Size\n");
    //               ----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+
    header = 0;
  }

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d : GRIB message error\n", nrec);
    return;
  }

  int level = get_level(pds);

  fprintf(stdout, "%5d :", nrec);

  if (bms)
    fprintf(stdout, "%4d%7d %7d %7d", PDS_Parameter, level, BMS_Len, BMS_BitmapSize);
  else
    fprintf(stdout, "%4d%7d Bit Map Section not defined", PDS_Parameter, level);

  if (nerr > 0) fprintf(stdout, " <-- GRIB data corrupted!");
  fprintf(stdout, "\n");
}

void
gribPrintBMS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  int gribversion = gribVersion(gribbuffer, (size_t) recsize);

  if (gribversion == 0 || gribversion == 1) grib1PrintBMS(nrec, recpos, recsize, gribbuffer);
  /*
  else if ( gribversion == 2 )
    grib2PrintBMS(nrec, recpos, recsize, gribbuffer);
  */
  else { fprintf(stdout, "%5d :%4ld%9ld%7ld : GRIB version %d unsupported\n", nrec, 0L, recpos, recsize, gribversion); }
}

static void
grib1PrintBDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  static int header = 1;
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;
  double scale;

  UNUSED(recpos);

  if (header)
  {
    fprintf(stdout, "  Rec : Code Level     BDS Flag     Scale   RefValue Bits  CR\n");
    //               ----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+
    header = 0;
  }

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d : GRIB message error\n", nrec);
    return;
  }

  int level = get_level(pds);

  double cr = (((BDS_Flag >> 4) & 1) && BDS_Z == 128) ? get_cr(&bds[17], &bds[20]) : 1;

  double refval = BDS_RefValue;

  if (BDS_BinScale < 0)
    scale = 1.0 / pow(2.0, (double) -BDS_BinScale);
  else
    scale = pow(2.0, (double) BDS_BinScale);

  if (PDS_DecimalScale != 0)
  {
    double decscale = pow(10.0, (double) -PDS_DecimalScale);
    refval *= decscale;
    scale *= decscale;
  }

  fprintf(stdout, "%5d :", nrec);

  if (bds)
    fprintf(stdout, "%4d%7d %7d %4d %8.5g %11.5g%4d %6.4g", PDS_Parameter, level, BDS_Len, BDS_Flag, scale, refval, BDS_NumBits,
            cr);
  else
    fprintf(stdout, " Binary Data Section not defined");

  if (nerr > 0) fprintf(stdout, " <-- GRIB data corrupted!");
  fprintf(stdout, "\n");
}

void
gribPrintBDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  int gribversion = gribVersion(gribbuffer, (size_t) recsize);

  if (gribversion == 0 || gribversion == 1) grib1PrintBDS(nrec, recpos, recsize, gribbuffer);
  /*
  else if ( gribversion == 2 )
    grib2PrintBDS(nrec, recpos, recsize, gribbuffer);
  */
  else { fprintf(stdout, "%5d :%4ld%9ld%7ld : GRIB version %d unsupported\n", nrec, 0L, recpos, recsize, gribversion); }
}

void
gribCheck1(int nrec, long recpos, long recsize, unsigned char *gribbuffer)
{
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;

  UNUSED(recpos);

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d : GRIB message error\n", nrec);
    return;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "%5d : <-- GRIB data corrupted!\n", nrec);
    return;
  }

  int level = get_level(pds);

  double cr = (((BDS_Flag >> 4) & 1) && BDS_Z == 128) ? get_cr(&bds[17], &bds[20]) : 1;

  if (IS_EQUAL(cr, 1) && BDS_NumBits == 24)
    fprintf(stdout, "GRIB record %5d : code = %4d   level = %7d\n", nrec, PDS_Parameter, level);
}

static void
repair1(unsigned char *gbuf, long gbufsize)
{
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;
  /* int recLen; */
  size_t bds_nbits;
  int bds_flag, lspherc, lcomplex /*, lcompress */;
  enum
  {
    bds_head = 11
  };
  size_t bds_ext = 0, bds_ubits;

  long gribrecsize;
  int nerr = grib1Sections(gbuf, gbufsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "GRIB message error\n");
    return;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "GRIB data corrupted!\n");
    return;
  }

  unsigned bds_len = BDS_Len;
  bds_nbits = BDS_NumBits;
  bds_flag = BDS_Flag;
  bds_ubits = (size_t) bds_flag & 15;
  lspherc = bds_flag >> 7;
  lcomplex = (bds_flag >> 6) & 1;
  /* lcompress = (bds_flag >> 4)&1; */

  if (lspherc)
  {
    if (lcomplex)
    {
      size_t jup, ioff;
      jup = (size_t) bds[15];
      ioff = (jup + 1) * (jup + 2);
      bds_ext = 4 + 3 + 4 * ioff;
    }
    else { bds_ext = 4; }
  }

  size_t datstart = bds_head + bds_ext;

  unsigned char *source = bds + datstart;

  size_t sourceLen = ((((bds_len - datstart) * 8 - bds_ubits) / bds_nbits) * bds_nbits) / 8;

  if (bds_nbits == 24)
  {
    unsigned char *pbuf = (unsigned char *) Malloc(sourceLen);
    ;
    size_t nelem = sourceLen / 3;
    for (size_t i = 0; i < nelem; ++i)
    {
      pbuf[3 * i] = source[i];
      pbuf[3 * i + 1] = source[nelem + i];
      pbuf[3 * i + 2] = source[2 * nelem + i];
    }
    memcpy(source, pbuf, sourceLen);
    Free(pbuf);
  }
}

void
gribRepair1(int nrec, long recsize, unsigned char *gribbuffer)
{
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "%5d : GRIB message error\n", nrec);
    return;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "%5d : <-- GRIB data corrupted!\n", nrec);
    return;
  }

  int level = get_level(pds);

  double cr = (((BDS_Flag >> 4) & 1) && BDS_Z == 128) ? get_cr(&bds[17], &bds[20]) : 1;

  if (IS_EQUAL(cr, 1) && BDS_NumBits == 24)
  {
    fprintf(stdout, "Repair GRIB record %5d : code = %4d   level = %7d\n", nrec, PDS_Parameter, level);
    repair1(gribbuffer, recsize);
  }
}
#include <stdio.h>
#include <string.h>

#if defined(HAVE_CONFIG_H)
#endif

#if defined(HAVE_LIBSZ)
#if defined(__cplusplus)
extern "C"
{
#endif
#include <szlib.h>
#ifdef __cplusplus
}
#endif

// clang-format off

#define OPTIONS_MASK        (SZ_RAW_OPTION_MASK | SZ_MSB_OPTION_MASK | SZ_NN_OPTION_MASK)

#define PIXELS_PER_BLOCK    (8)
#define PIXELS_PER_SCANLINE (PIXELS_PER_BLOCK*128)

#define MIN_COMPRESS        (0.95)
#define MIN_SIZE            (256)
#endif

#define  Z_SZIP  128

#if  defined (HAVE_LIBSZ) || defined (HAVE_LIBAEC)
#define SetLen3(var, offset, value) ((var[offset+0] = 0xFF & (value >> 16)), \
				     (var[offset+1] = 0xFF & (value >>  8)), \
				     (var[offset+2] = 0xFF & (value      )))
#define SetLen4(var, offset, value) ((var[offset+0] = 0xFF & (value >> 24)), \
				     (var[offset+1] = 0xFF & (value >> 16)), \
				     (var[offset+2] = 0xFF & (value >>  8)), \
				     (var[offset+3] = 0xFF & (value      )))
#endif

// clang-format on

int
gribGetZip(size_t recsize, unsigned char *gribbuffer, size_t *urecsize)
{
  int compress = 0;
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;

  int gribversion = gribVersion(gribbuffer, recsize);

  if (gribversion == 2) return compress;

  long gribrecsize;
  int nerr = grib1Sections(gribbuffer, (long) recsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "GRIB message error\n");
    return compress;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "GRIB data corrupted!\n");
    return compress;
  }

  /* bds_len   = BDS_Len; */
  /* bds_nbits = BDS_NumBits; */
  int bds_flag = BDS_Flag;
  /* lspherc   =  bds_flag >> 7; */
  /* lcomplex  = (bds_flag >> 6)&1; */
  int lcompress = (bds_flag >> 4) & 1;

  size_t gribsize = 0;
  if (lcompress)
  {
    compress = BDS_Z;
    if (compress == Z_SZIP) gribsize = (size_t) GET_UINT3(bds[14], bds[15], bds[16]);
  }

  *urecsize = gribsize;

  return compress;
}

int
gribZip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize)
{
#if !defined(HAVE_LIBSZ)
  static int libszwarn = 1;
#endif
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;
  bool llarge = false;

  unsigned gribLen = GET_UINT3(dbuf[4], dbuf[5], dbuf[6]);

  int rec_len = (int) gribLen;

  long gribrecsize;
  int nerr = grib1Sections(dbuf, dbufsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "GRIB message error\n");
    return (int) gribrecsize;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "GRIB data corrupted!\n");
    return (int) gribrecsize;
  }

  int bds_zoffset = 12;

  unsigned bds_len = BDS_Len;
  if (gribLen > JP23SET && bds_len <= 120)
  {
    gribLen &= JP23SET;
    gribLen *= 120;
    bds_len = correct_bdslen(bds_len, gribLen, bds - dbuf);
    llarge = true;
    bds_zoffset += 2;
  }

  if (gribLen > JP24SET || llarge) return (int) gribLen;

#if defined(HAVE_LIBSZ)
  {
    int bds_zstart = 14;
    unsigned gribLenOld = 0;
    int bds_head = 11;
    int bds_ext = 0;
    unsigned char *pbuf = NULL;

    int bds_nbits = BDS_NumBits;
    int bds_flag = BDS_Flag;
    int bds_ubits = bds_flag & 15;
    int lspherc = bds_flag >> 7;
    int lcomplex = (bds_flag >> 6) & 1;
    /* lcompress = (bds_flag >> 4)&1; */

    if (bds_nbits != 8 && bds_nbits != 16 && bds_nbits != 24 && bds_nbits != 32)
    {
      static bool linfo = true;
      if (linfo && bds_nbits != 0)
      {
        linfo = false;
        fprintf(stderr, "GRIB szip supports only 8, 16, 24 and 32 bit data!\n");
      }
      return rec_len;
    }

    int bits_per_sample = (bds_nbits == 24) ? 8 : bds_nbits;

    SZ_com_t sz_param; /* szip parameter block */
    sz_param.options_mask = OPTIONS_MASK;
    sz_param.bits_per_pixel = bits_per_sample;
    sz_param.pixels_per_block = PIXELS_PER_BLOCK;
    sz_param.pixels_per_scanline = PIXELS_PER_SCANLINE;

    if (lspherc)
    {
      bds_ext = 4;
      if (lcomplex)
      {
        int jup = bds[15];
        int ioff = (jup + 1) * (jup + 2);
        bds_ext += 3 + 4 * ioff;
      }
    }

    size_t datstart = bds_head + bds_ext;

    size_t datsize = ((((bds_len - datstart) * 8 - bds_ubits) / bds_nbits) * bds_nbits) / 8;

    if (datsize < MIN_SIZE) return rec_len;
    /*
    fprintf(stderr, "%d %d %d %d\n", bds_len, datstart, bds_len - datstart, datsize);
    */
    size_t sourceLen = datsize;
    size_t destLen = sbufsize;

    unsigned char *source = bds + datstart;
    unsigned char *dest = sbuf;

    if (bds_nbits == 24)
    {
      long nelem = sourceLen / 3;
      pbuf = (unsigned char *) Malloc(sourceLen);
      for (long i = 0; i < nelem; ++i)
      {
        pbuf[i] = source[3 * i];
        pbuf[nelem + i] = source[3 * i + 1];
        pbuf[2 * nelem + i] = source[3 * i + 2];
      }
      source = pbuf;
    }

    int status = SZ_BufftoBuffCompress(dest, &destLen, source, sourceLen, &sz_param);
    if (status != SZ_OK)
    {
      if (status == SZ_NO_ENCODER_ERROR)
        Warning("SZ_NO_ENCODER_ERROR code %3d level %3d", PDS_Parameter, PDS_Level2);
      else if (status == SZ_PARAM_ERROR)
        Warning("SZ_PARAM_ERROR code %3d level %3d", PDS_Parameter, PDS_Level2);
      else if (status == SZ_MEM_ERROR)
        Warning("SZ_MEM_ERROR code %3d level %3d", PDS_Parameter, PDS_Level2);
      else if (status == SZ_OUTBUFF_FULL)
        /*Warning("SZ_OUTBUFF_FULL code %3d level %3d", PDS_Parameter, PDS_Level2)*/;
      else
        Warning("SZ ERROR: %d code %3d level %3d", status, PDS_Parameter, PDS_Level2);
    }

    if (pbuf) Free(pbuf);
    /*
    fprintf(stderr, "sourceLen, destLen %d %d\n", sourceLen, destLen);
    */
    if (destLen < MIN_COMPRESS * sourceLen)
    {
      source = bds + datstart + bds_zoffset;
      memcpy(source, dest, destLen);

      /* ----++++ number of unused bits at end of section) */

      BDS_Flag -= bds_ubits;

      gribLenOld = gribLen;

      if (bds_ext)
        for (long i = bds_ext - 1; i >= 0; --i) bds[bds_zoffset + bds_head + i] = bds[bds_head + i];

      /*
      fprintf(stderr, "destLen, datsize, datstart %d %d %d\n", destLen, datsize, datstart);
      */
      /*	memcpy(bds + datstart + bds_zoffset, source, destLen); */
      /*
        fprintf(stderr, "z>>> %d %d %d %d <<<\n", (int) bds[0+datstart+bds_zoffset],
          (int)bds[1+datstart+bds_zoffset], (int)bds[2+datstart+bds_zoffset], (int)bds[3+datstart+bds_zoffset]);
      */
      if (llarge)
      {
        if (gribLenOld % 120)
        {
          fprintf(stderr, "Internal problem, record length not multiple of 120!");
          while (gribLenOld % 120) gribLenOld++;
        }
        // gribLenOld = gribLenOld / (-120);
        // gribLenOld = JP23SET - gribLenOld + 1;

        SetLen3(bds, bds_zstart, gribLenOld);
        SetLen4(bds, bds_zstart + 3, sourceLen);
        SetLen4(bds, bds_zstart + 7, destLen);
      }
      else
      {
        SetLen3(bds, bds_zstart, gribLenOld);
        SetLen3(bds, bds_zstart + 3, sourceLen);
        SetLen3(bds, bds_zstart + 6, destLen);
      }

      int bdsLen = datstart + bds_zoffset + destLen;

      bds[11] = 0;
      bds[12] = 0;

      BDS_Z = Z_SZIP;

      BDS_Flag += 16;
      if ((bdsLen % 2) == 1)
      {
        BDS_Flag += 8;
        bds[bdsLen++] = 0;
      }

      SetLen3(bds, 0, bdsLen);

      gribLen = (bds - dbuf) + bdsLen;

      dbuf[gribLen++] = '7';
      dbuf[gribLen++] = '7';
      dbuf[gribLen++] = '7';
      dbuf[gribLen++] = '7';

      if (llarge)
      {
        long bdslen = gribLen - 4;

        /*
          If a very large product, the section 4 length field holds
          the number of bytes in the product after section 4 upto
          the end of the padding bytes.
          This is a fixup to get round the restriction on product lengths
          due to the count being only 24 bits. It is only possible because
          the (default) rounding for GRIB products is 120 bytes.
        */
        while (gribLen % 120) dbuf[gribLen++] = 0;

        long itemp = gribLen / (-120);
        itemp = JP23SET - itemp + 1;

        SetLen3(dbuf, 4, itemp);

        bdslen = gribLen - bdslen;

        SetLen3(bds, 0, bdslen);
      }
      else { SetLen3(dbuf, 4, gribLen); }
    }
    else {}
    /*
    fprintf(stderr, "%3d %3d griblen in %6d  out %6d  CR %g   slen %6d dlen %6d  CR %g\n",
            PDS_Parameter, PDS_Level1, gribLenOld, gribLen,
            ((double)gribLenOld)/gribLen, sourceLen, destLen,
            ((double)sourceLen)/destLen);
    */
  }

#else

  UNUSED(sbuf);
  UNUSED(sbufsize);

  if (libszwarn)
  {
    Warning("Compression disabled, szlib not available!");
    libszwarn = 0;
  }
#endif

  if (llarge)
    while (gribLen % 120) dbuf[gribLen++] = 0;
  else
    while (gribLen & 7) dbuf[gribLen++] = 0;

  rec_len = (int) gribLen;

  return rec_len;
}

int
gribUnzip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize)
{
#if !defined(HAVE_LIBSZ)
  static int libszwarn = 1;
#endif
  unsigned char *pds = NULL, *gds = NULL, *bms = NULL, *bds = NULL;
  size_t gribLen = 0;
  size_t destLen, sourceLen;
  enum
  {
    bds_head = 11
  };
  int bds_ext = 0;

  UNUSED(dbufsize);

  long gribrecsize;
  int nerr = grib1Sections(sbuf, sbufsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "GRIB message error\n");
    return 0;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "GRIB data corrupted!\n");
    return 0;
  }

  // unsigned bds_len = BDS_Len;
  bool llarge = false;

  int bds_zoffset = 12;
  if (llarge) bds_zoffset += 2;

  int bds_nbits = BDS_NumBits;
  int bds_flag = BDS_Flag;
  int lspherc = bds_flag >> 7;
  int lcomplex = (bds_flag >> 6) & 1;
  /* lcompress = (bds_flag >> 4)&1; */

  if (lspherc)
  {
    if (lcomplex)
    {
      int jup = bds[bds_zoffset + 15];
      int ioff = (jup + 1) * (jup + 2);
      bds_ext = 4 + 3 + 4 * ioff;
    }
    else { bds_ext = 4; }
  }

  size_t datstart = bds_head + (size_t) bds_ext;

  unsigned char *source = bds + datstart + bds_zoffset;
  if (llarge)
    sourceLen = ((size_t) ((bds[21] << 24) + (bds[22] << 16) + (bds[23] << 8) + bds[24]));
  else
    sourceLen = ((size_t) ((bds[20] << 16) + (bds[21] << 8) + bds[22]));

  nerr = grib1Sections(dbuf, sbufsize, &pds, &gds, &bms, &bds, &gribrecsize);
  if (nerr < 0)
  {
    fprintf(stdout, "GRIB message error\n");
    return 0;
  }

  if (nerr > 0)
  {
    fprintf(stdout, "GRIB data corrupted!\n");
    return 0;
  }

  unsigned char *dest = bds + datstart;
  if (llarge)
    destLen = ((size_t) ((bds[17] << 24) + (bds[18] << 16) + (bds[19] << 8) + bds[20]));
  else
    destLen = ((size_t) ((bds[17] << 16) + (bds[18] << 8) + bds[19]));

  BDS_Flag = (unsigned char) (BDS_Flag - 16);

  size_t bdsLen = datstart + destLen;

#if defined(HAVE_LIBSZ)
  {
    int bds_zstart = 14;
    unsigned recLen = GET_UINT3(bds[bds_zstart], bds[bds_zstart + 1], bds[bds_zstart + 2]);

    int bits_per_sample = (bds_nbits == 24) ? 8 : bds_nbits;

    SZ_com_t sz_param; /* szip parameter block */
    sz_param.options_mask = OPTIONS_MASK;
    sz_param.bits_per_pixel = bits_per_sample;
    sz_param.pixels_per_block = PIXELS_PER_BLOCK;
    sz_param.pixels_per_scanline = PIXELS_PER_SCANLINE;

    if (bds_ext)
      for (long i = 0; i < bds_ext; ++i) bds[bds_head + i] = bds[bds_zoffset + bds_head + i];

    /*    fprintf(stderr, "gribUnzip: sourceLen %ld; destLen %ld\n", (long)sourceLen, (long)destLen);
    fprintf(stderr, "gribUnzip: sourceOff %d; destOff %d\n", bds[12], bds[11]);
    fprintf(stderr, "gribUnzip: reclen %d; bdslen %d\n", recLen, bdsLen);
    */

    size_t tmpLen = destLen;

    int status = SZ_BufftoBuffDecompress(dest, &tmpLen, source, sourceLen, &sz_param);
    if (status != SZ_OK)
    {
      if (status == SZ_NO_ENCODER_ERROR)
        Warning("SZ_NO_ENCODER_ERROR code %3d level %3d", PDS_Parameter, PDS_Level2);
      else if (status == SZ_PARAM_ERROR)
        Warning("SZ_PARAM_ERROR code %3d level %3d", PDS_Parameter, PDS_Level2);
      else if (status == SZ_MEM_ERROR)
        Warning("SZ_MEM_ERROR code %3d level %3d", PDS_Parameter, PDS_Level2);
      else if (status == SZ_OUTBUFF_FULL)
        Warning("SZ_OUTBUFF_FULL code %3d level %3d", PDS_Parameter, PDS_Level2);
      else
        Warning("SZ ERROR: %d code %3d level %3d", status, PDS_Parameter, PDS_Level2);
    }
    /*
    fprintf(stderr, "gribUnzip: sl = %ld  dl = %ld   tl = %ld\n",
            (long)sourceLen, (long)destLen,(long) tmpLen);
    */
    if (tmpLen != destLen)
      Warning("unzip size differ: code %3d level %3d  ibuflen %ld ubuflen %ld", PDS_Parameter, PDS_Level2, (long) destLen,
              (long) tmpLen);

    if (bds_nbits == 24)
    {
      long nelem = tmpLen / 3;
      unsigned char *pbuf = (unsigned char *) Malloc(tmpLen);
      for (long i = 0; i < nelem; ++i)
      {
        pbuf[3 * i] = dest[i];
        pbuf[3 * i + 1] = dest[nelem + i];
        pbuf[3 * i + 2] = dest[2 * nelem + i];
      }
      memcpy(dest, pbuf, tmpLen);
      Free(pbuf);
    }

    int bds_ubits = BDS_Flag & 15;
    BDS_Flag -= bds_ubits;

    if ((bdsLen % 2) == 1)
    {
      BDS_Flag += 8;
      bds[bdsLen++] = 0;
    }

    SetLen3(bds, 0, bdsLen);

    gribLen = (bds - dbuf) + bdsLen;

    dbuf[gribLen++] = '7';
    dbuf[gribLen++] = '7';
    dbuf[gribLen++] = '7';
    dbuf[gribLen++] = '7';

    if (llarge)
    {
      long itemp;
      bdsLen = gribLen - 4;
      /*
        If a very large product, the section 4 length field holds
        the number of bytes in the product after section 4 upto
        the end of the padding bytes.
        This is a fixup to get round the restriction on product lengths
        due to the count being only 24 bits. It is only possible because
        the (default) rounding for GRIB products is 120 bytes.
      */
      while (gribLen % 120) dbuf[gribLen++] = 0;

      if (gribLen != (size_t) recLen) fprintf(stderr, "Internal problem, recLen and gribLen differ!\n");

      itemp = gribLen / (-120);
      itemp = JP23SET - itemp + 1;

      SetLen3(dbuf, 4, itemp);

      bdsLen = gribLen - bdsLen;

      SetLen3(bds, 0, bdsLen);
    }
    else { SetLen3(dbuf, 4, recLen); }
    /*
    fprintf(stderr, "recLen, gribLen, bdsLen %d %d %d\n", recLen, gribLen, bdsLen);
    */
    if (llarge)
      while (gribLen % 120) dbuf[gribLen++] = 0;
    else
      while (gribLen & 7) dbuf[gribLen++] = 0;
    /*
    fprintf(stderr, "recLen, gribLen, bdsLen %d %d %d\n", recLen, gribLen, bdsLen);
    */
  }
#else
  UNUSED(bds_nbits);
  UNUSED(sourceLen);
  UNUSED(source);
  UNUSED(bdsLen);
  UNUSED(dest);

  if (libszwarn)
  {
    Warning("Decompression disabled, szlib not available!");
    libszwarn = 0;
  }
#endif

  return (int) gribLen;
}
#include <stdio.h>
#include <math.h>

// clang-format off


static void
scm0_double(double *pdl, double *pdr, double *pfl, double *pfr, int klg);


static
int rowina2(double *p, int ko, int ki, double *pw,
	    int kcode, double msval, int *kret)
{
  /* System generated locals */
  int pw_dim1, pw_offset, i_1;

  /* Local variables */
  double zwt1, zrdi, zpos;
  int ip;
  double zdo, zwt;

  /* Parameter adjustments */
  --p;
  pw_dim1 = ko + 3;
  pw_offset = pw_dim1;
  pw -= pw_offset;

  /* **** ROWINA2 - Interpolation of row of values. */
  /*     Input Parameters. */
  /*     ----------------- */
  /*     P      - Row of values to be interpolated. */
  /*              Dimension must be at least KO. */
  /*     KO     - Number of values required. */
  /*     KI     - Number of values in P on input. */
  /*     PW     - Working array. */
  /*              Dimension must be at least (0:KO+2,3). */
  /*     KCODE  - Interpolation required. */
  /*              1 , linear. */
  /*              3 , cubic. */
  /*     PMSVAL - Value used for missing data indicator. */

  /*     Output Parameters. */
  /*     ------------------ */
  /*     P     - Now contains KO values. */
  /*     KRET  - Return code */
  /*             0, OK */
  /*             Non-zero, error */

  /*     Author. */
  /*     ------- */
  /*     J.D.Chambers    ECMWF     22.07.94 */

  /*     ********************************    */
  /*     Section 1.  Linear interpolation .. */
  /*     ********************************    */

  *kret = 0;

  if ( kcode == 1 )
    {
      /*    Move input values to work array */
      for (int jl = 1; jl <= ki; ++jl)
	pw[jl + pw_dim1] = p[jl];

      /*    Arrange wrap-around value in work array */
      pw[ki + 1 + pw_dim1] = p[1];

      /*    Set up constants to be used to figure out weighting for */
      /*    values in interpolation. */
      zrdi = (double) ki;
      zdo = 1.0 / (double) ko;

      /*    Loop through the output points */
      for (int jl = 1; jl <= ko; ++jl)
	{

	  /*    Calculate weight from the start of row */
	  zpos = (jl - 1) * zdo;
	  zwt = zpos * zrdi;

	  /*    Get the current array position(minus 1) from the weight - */
	  /*    note the implicit truncation. */
	  ip = (int) zwt;

	  /*    If the left value is missing, use the right value */
	  if ( IS_EQUAL(pw[ip + 1 + pw_dim1], msval) )
	    {
	      p[jl] = pw[ip + 2 + pw_dim1];
	    }
	  /*    If the right value is missing, use the left value */
	  else if ( IS_EQUAL(pw[ip + 2 + pw_dim1], msval) )
	    {
	      p[jl] = pw[ip + 1 + pw_dim1];
	    }
	  /*    If neither missing, interpolate ... */
	  else
	    {

	      /*       Adjust the weight to range (0.0 to 1.0) */
	      zwt -= ip;

	      /*       Interpolate using the weighted values on either side */
	      /*       of the output point position */
	      p[jl] = (1.0 - zwt) * pw[ip + 1 + pw_dim1] +
		zwt * pw[ip + 2 + pw_dim1];
	    }
	}

      /*     *******************************    */
      /*     Section 2.  Cubic interpolation .. */
      /*     *******************************    */

    }
  else if ( kcode == 3 )
    {
      i_1 = ki;
      for (int jl = 1; jl <= i_1; ++jl)
	{
          if ( IS_EQUAL(p[jl], msval) )
	    {
	      fprintf(stderr," ROWINA2: ");
	      fprintf(stderr," Cubic interpolation not supported");
	      fprintf(stderr," for fields containing missing data.\n");
	      *kret = 1;
	      goto L900;
	    }
          pw[jl + pw_dim1] = p[jl];
	}
      pw[pw_dim1] = p[ki];
      pw[ki + 1 + pw_dim1] = p[1];
      pw[ki + 2 + pw_dim1] = p[2];
      i_1 = ki;
      for (int jl = 1; jl <= i_1; ++jl)
	{
          pw[jl + (pw_dim1 << 1)] =
	        - pw[jl - 1 + pw_dim1] / 3.0 -
	          pw[jl     + pw_dim1] * 0.5 +
	          pw[jl + 1 + pw_dim1] - pw[jl + 2 + pw_dim1] / 6.0;
          pw[jl + 1 + pw_dim1 * 3] =
                  pw[jl - 1 + pw_dim1] / 6.0 -
                  pw[jl     + pw_dim1] +
                  pw[jl + 1 + pw_dim1] * 0.5 +
                  pw[jl + 2 + pw_dim1] / 3.0;
	}

      scm0_double(&pw[(pw_dim1 << 1) + 1], &pw[pw_dim1 * 3 + 2],
		  &pw[pw_dim1 + 1], &pw[pw_dim1 + 2], ki);

      zrdi = (double) ki;
      zdo = 1.0 / (double) ko;
      for (int jl = 1; jl <= ko; ++jl)
	{
          zpos = (jl - 1) * zdo;
          zwt = zpos * zrdi;
          ip = (int) zwt + 1;
          zwt = zwt + 1.0 - ip;
          zwt1 = 1.0 - zwt;
          p[jl] = ((3.0 - zwt1 * 2.0) * pw[ip + pw_dim1] +
                  zwt * pw[ip + (pw_dim1 << 1)]) * zwt1 * zwt1 +
                  ((3.0 - zwt * 2.0) * pw[ip + 1 + pw_dim1] -
                  zwt1 * pw[ip + 1 + pw_dim1 * 3]) * zwt * zwt;
	}

    }
  else
    {
      /*    **************************************    */
      /*    Section 3.  Invalid interpolation code .. */
      /*    **************************************    */
      fprintf(stderr," ROWINA2:");
      fprintf(stderr," Invalid interpolation code = %2d\n",kcode);
      *kret = 2;
    }

L900:
    return 0;
} /* rowina2 */



int qu2reg2(double *pfield, int *kpoint, int klat, int klon,
	    double *ztemp, double msval, int *kret)
{
   /* System generated locals */
   int i_1, i_2;
   int kcode = 1;

   /* Local variables */
   int ilii, ilio, icode;
   double *zline = NULL;
   double *zwork = NULL;
   int iregno, iquano;


   zline = (double*) Malloc(2*(size_t)klon*sizeof(double));
   if ( zline == NULL ) SysError("No Memory!");

   zwork = (double*) Malloc(3*(2*(size_t)klon+3)*sizeof(double));
   if ( zwork == NULL ) SysError("No Memory!");

   /* Parameter adjustments */
   --pfield;
   --kpoint;

/* **** QU2REG - Convert quasi-regular grid data to regular. */
/*     Input Parameters. */
/*     ----------------- */
/*     PFIELD     - Array containing quasi-regular grid */
/*                  data. */
/*     KPOINT     - Array containing list of the number of */
/*                  points on each latitude (or longitude) of */
/*                  the quasi-regular grid. */
/*     KLAT       - Number of latitude lines */
/*     KLON       - Number of longitude lines */
/*     KCODE      - Interpolation required. */
/*                  1 , linear - data quasi-regular on */
/*                               latitude lines. */
/*                  3 , cubic -  data quasi-regular on */
/*                               latitude lines. */
/*                  11, linear - data quasi-regular on */
/*                               longitude lines. */
/*                  13, cubic -  data quasi-regular on */
/*                               longitude lines. */
/*     PMSVAL     - Value used for missing data indicator. */
/*     Output Parameters. */
/*     ------------------ */
/*     KRET       - return code */
/*                  0 = OK */
/*                  non-zero indicates fatal error */
/*     PFIELD     - Array containing regular grid data. */
/*     Author. */
/*     ------- */
/*     J.D.Chambers     ECMWF      22.07.94 */
/*     J.D.Chambers     ECMWF      13.09.94 */
/*     Add return code KRET and remove calls to ABORT. */


/* ------------------------------ */
/* Section 1. Set initial values. */
/* ------------------------------ */

   *kret = 0;

/* Check input parameters. */

   if (kcode != 1 && kcode != 3 && kcode != 11 && kcode != 13) {
      fprintf(stderr," QU2REG :");
      fprintf(stderr," Invalid interpolation type code = %2d\n",kcode);
      *kret = 1;
      goto L900;
   }

/* Set array indices to 0. */

   ilii = 0;
   ilio = 0;

/* Establish values of loop parameters. */

   if (kcode > 10) {

/*    Quasi-regular along longitude lines. */

      iquano = klon;
      iregno = klat;
      icode = kcode - 10;
   } else {

/*    Quasi-regular along latitude lines. */

      iquano = klat;
      iregno = klon;
      icode = kcode;
   }

/*     -------------------------------------------------------- */
/**    Section 2. Interpolate field from quasi to regular grid. */
/*     -------------------------------------------------------- */

   i_1 = iquano;
   for (int j230 = 1; j230 <= i_1; ++j230) {

      if (iregno != kpoint[j230]) {

/*       Line contains less values than required,so */
/*       extract quasi-regular grid values for a line */

         i_2 = kpoint[j230];
         for (int j210 = 1; j210 <= i_2; ++j210) {
            ++ilii;
            zline[j210 - 1] = pfield[ilii];
         }

/*       and interpolate this line. */

         rowina2(zline, iregno, kpoint[j230], zwork, icode, msval, kret);
         if (*kret != 0) goto L900;

/*       Add regular grid values for this line to the
         temporary array. */

         i_2 = iregno;
         for (int j220 = 1; j220 <= i_2; ++j220) {
            ++ilio;
            ztemp[ilio - 1] = zline[j220 - 1];
         }

      } else {

/*       Line contains the required number of values, so add */
/*       this line to the temporary array. */

         i_2 = iregno;
         for (int j225 = 1; j225 <= i_2; ++j225) {
            ++ilio;
            ++ilii;
            ztemp[ilio - 1] = pfield[ilii];
         }
      }
   }

   /* Copy temporary array to user array. */

   i_1 = klon * klat;
   for (int j240 = 1; j240 <= i_1; ++j240) {
      pfield[j240] = ztemp[j240 - 1];
   }

/* -------------------------------------------------------- */
/* Section 9. Return to calling routine. Format statements. */
/* -------------------------------------------------------- */

L900:

   Free(zline);
   Free(zwork);

   return 0;
} /* qu2reg2 */



#ifdef T
#undef T
#endif
#define T double
#ifdef T

/* calculate_pfactor: source code from grib_api-1.8.0 */
double TEMPLATE(calculate_pfactor,T)(const T *spectralField, long fieldTruncation, long subsetTruncation)
{
  /*long n_vals = ((fieldTruncation+1)*(fieldTruncation+2));*/
  long loop, index, m, n = 0;
  double zeps = 1.0e-15;
  long ismin = (subsetTruncation+1), ismax = (fieldTruncation+1);
  double weightedSumOverX = 0.0, weightedSumOverY = 0.0, sumOfWeights = 0.0;
  double numerator = 0.0, denominator = 0.0;

  // Setup the weights

  double range = (double) (ismax - ismin +1);

  double *weights = (double*) Malloc(((size_t)ismax+1)*sizeof(double));
  for( loop = ismin; loop <= ismax; loop++ )
    weights[loop] = range / (double) (loop-ismin+1);

  // Compute norms
  // Handle values 2 at a time (real and imaginary parts).
  double *norms = (double*) Malloc(((size_t)ismax+1)*sizeof(double));

  for( loop = 0; loop < ismax+1; loop++ ) norms[loop] = 0.0;

  // Form norms for the rows which contain part of the unscaled subset.

  index = -2;
  for( m = 0; m < subsetTruncation; m++ )
    for( n = m; n <= fieldTruncation; n++ ) {
      index += 2;
      if( n >= subsetTruncation ) {
        double tval = spectralField[index];
        tval=tval<0?-tval:tval;
        norms[n] = norms[n] > tval ? norms[n] : tval;
        tval = spectralField[index+1];
        tval=tval<0?-tval:tval;
        norms[n] = norms[n] > tval ? norms[n] : tval;
      }
    }

  // Form norms for the rows which do not contain part of the unscaled subset.

  for( m = subsetTruncation; m <= fieldTruncation; m++ )
    for( n = m; n <= fieldTruncation; n++ ) {
      double tval = spectralField[index];
      index += 2;
      tval=tval<0?-tval:tval;
      norms[n] = norms[n] > tval ? norms[n] : tval;
      tval = spectralField[index+1];
      tval=tval<0?-tval:tval;
      norms[n] = norms[n] > tval ? norms[n] : tval;
    }

  // Ensure the norms have a value which is not too small in case of problems with math functions (e.g. LOG).

  for( loop = ismin; loop <= ismax; loop++ ) {
    norms[n] = norms[n] > zeps ? norms[n] : zeps;
    if( IS_EQUAL(norms[n], zeps) ) weights[n] = 100.0 * zeps;
  }

  // Do linear fit to find the slope

  for( loop = ismin; loop <= ismax; loop++ ) {
    double x = log( (double) (loop*(loop+1)) );
    double y = log( norms[loop] );
    weightedSumOverX += x * weights[loop];
    weightedSumOverY += y * weights[loop];
    sumOfWeights = sumOfWeights + weights[loop];
  }
  weightedSumOverX /= sumOfWeights;
  weightedSumOverY /= sumOfWeights;

  // Perform a least square fit for the equation

  for( loop = ismin; loop <= ismax; loop++ ) {

    double x = log( (double)(loop*(loop+1)) );
    double y = log( norms[loop] );
    numerator += weights[loop] * (y-weightedSumOverY) * (x-weightedSumOverX);
    denominator += weights[loop] * ((x-weightedSumOverX) * (x-weightedSumOverX));
  }
  double slope = numerator / denominator;

  Free(weights);
  Free(norms);

  double pFactor = -slope;
  if( pFactor < -9999.9 ) pFactor = -9999.9;
  if( pFactor > 9999.9 )  pFactor = 9999.9;

  return pFactor;
}

void TEMPLATE(scale_complex,T)(T *fpdata, int pcStart, int pcScale, int trunc, int inv)
{

  if ( pcScale < -10000 || pcScale > 10000 )
    {
      fprintf(stderr, " %s: Invalid power given %6d\n", __func__, pcScale);
      return;
    }

  // Setup scaling factors = n(n+1)^^p for n = 1 to truncation

  if ( pcScale != 0 )
    {
      double *scale = (double*) Malloc(((size_t)trunc+1)*sizeof(double));
      const double power = (double) pcScale / 1000.;
      scale[0] = 1.0;

      if (pcScale != 1000)
        for (int n = 1; n <= trunc; ++n) scale[n] = pow((double) (n*(n+1)), power);
      else
        for (int n = 1; n <= trunc; ++n) scale[n] =     (double) (n*(n+1));

      if ( inv )
        for (int n = 1; n <= trunc; ++n) scale[n] = 1.0 / scale[n];

      // Scale the values

      size_t index = 0;

      for (int m = 0;   m < pcStart; ++m)
        for (int n = m; n <= trunc; n++, index += 2)
          if ( n >= pcStart )
            {
              fpdata[index  ] = (T)(fpdata[index  ] * scale[n]);
              fpdata[index+1] = (T)(fpdata[index+1] * scale[n]);
            }

      for (int m = pcStart; m <= trunc; ++m)
        for (int n = m;     n <= trunc; n++, index += 2)
          {
            fpdata[index  ] = (T)(fpdata[index  ] * scale[n]);
            fpdata[index+1] = (T)(fpdata[index+1] * scale[n]);
          }
      Free(scale);
    }
}


void TEMPLATE(scatter_complex,T)(T *fpdata, int pcStart, int trunc, int nsp)
{
  T *fphelp = (T*) Malloc((size_t)nsp*sizeof(T));
  size_t inext = 0;
  size_t pcStart_ = pcStart >= 0 ? (size_t)pcStart : 0U;
  size_t trunc_ = trunc >= 0 ? (size_t)trunc : 0U;
  for (size_t m = 0, index = 0; m <= pcStart_; ++m)
    {
      size_t n_copies = pcStart_ <= trunc_ ? (pcStart_ + 1 - m) * 2 : 0;
      for (size_t i = 0; i < n_copies; ++i) fphelp[index + i] = fpdata[inext + i];
      inext += n_copies;
      index += m <= trunc_ ? (trunc_ - m + 1) * 2 : 0;
    }
  for (size_t m = 0, index = 0; m <= trunc_; ++m)
    {
      size_t advIdx = m <= pcStart_ ? (pcStart_ - m + 1) * 2 : 0;
      index += advIdx;
      size_t copyStart = m > pcStart_ ? m : pcStart_ + 1;
      size_t n_copies = copyStart <= trunc_ ? (trunc_ - copyStart + 1) * 2 : 0;
      for (size_t i = 0; i < n_copies; ++i) fphelp[index + i] = fpdata[inext + i];
      inext += n_copies;
      index += n_copies;
    }
  for (size_t m = 0; m < (size_t)nsp; ++m) fpdata[m] = fphelp[m];

  Free(fphelp);
}


void TEMPLATE(gather_complex,T)(T *fpdata, size_t pcStart, size_t trunc, size_t nsp)
{
  T *restrict fphelp = (T*) Malloc(nsp*sizeof(T));
  size_t inext = 0;

  for (size_t m = 0, index = 0;   m <= pcStart; ++m)
    for (size_t n = m; n <= trunc; ++n)
      {
	if ( pcStart >= n )
	  {
	    fphelp[inext++] = fpdata[index];
	    fphelp[inext++] = fpdata[index+1];
	  }
	index += 2;
      }

  for (size_t m = 0, index = 0; m <= trunc; ++m)
    for (size_t n = m; n <= trunc; ++n)
      {
	if ( n > pcStart )
	  {
	    fphelp[inext++] = fpdata[index];
	    fphelp[inext++] = fpdata[index+1];
	  }
	index += 2;
      }

  for (size_t m = 0; m < nsp; ++m) fpdata[m] = fphelp[m];

  Free(fphelp);
}


static void TEMPLATE(scm0,T)(T *pdl, T *pdr, T *pfl, T *pfr, int klg)
{
  /* **** SCM0   - Apply SCM0 limiter to derivative estimates. */
  /* output: */
  /*   pdl   = the limited derivative at the left edge of the interval */
  /*   pdr   = the limited derivative at the right edge of the interval */
  /* inputs */
  /*   pdl   = the original derivative at the left edge */
  /*   pdr   = the original derivative at the right edge */
  /*   pfl   = function value at the left edge of the interval */
  /*   pfr   = function value at the right edge of the interval */
  /*   klg   = number of intervals where the derivatives are limited */

  /*  define constants */

  double zeps = 1.0e-12;
  double zfac = (1.0 - zeps) * 3.0;

  for (int jl = 0; jl < klg; ++jl)
    {
      double r_1;
      if ( (r_1 = pfr[jl] - pfl[jl], fabs(r_1)) > zeps )
	{
	  double zalpha = pdl[jl] / (pfr[jl] - pfl[jl]);
	  double zbeta  = pdr[jl] / (pfr[jl] - pfl[jl]);
	  if ( zalpha <= 0.0 ) pdl[jl] = 0.0;
	  if ( zbeta  <= 0.0 ) pdr[jl] = 0.0;
	  if ( zalpha > zfac ) pdl[jl] = (T)(zfac * (pfr[jl] - pfl[jl]));
	  if ( zbeta  > zfac ) pdr[jl] = (T)(zfac * (pfr[jl] - pfl[jl]));
	}
      else
	{
	  pdl[jl] = 0.0;
	  pdr[jl] = 0.0;
	}
    }
} /* scm0 */

static
int TEMPLATE(rowina3,T)(T *p, int ko, int ki, T *pw,
			int kcode, T msval, int *kret, int omisng, int operio, int oveggy)
{
  /*
C---->
C**** ROWINA3 - Interpolation of row of values.
C
C     Purpose.
C     --------
C
C     Interpolate a row of values.
C
C
C**   Interface.
C     ----------
C
C     CALL ROWINA3( P, KO, KI, PW, KCODE, PMSVAL, KRET, OMISNG, OPERIO)
C
C
C     Input Parameters.
C     -----------------
C
C     P      - Row of values to be interpolated.
C              Dimension must be at least KO.
C
C     KO     - Number of values required.
C
C     KI     - Number of values in P on input.
C
C     PW     - Working array.
C              Dimension must be at least (0:KO+2,3).
C
C     KCODE  - Interpolation required.
C              1 , linear.
C              3 , cubic.
C
C     PMSVAL - Value used for missing data indicator.
C
C     OMISNG - True if missing values are present in field.
C
C     OPERIO - True if input field is periodic.
C
C     OVEGGY - True if 'nearest neighbour' processing must be used
C              for interpolation
C
C     Output Parameters.
C     ------------------
C
C     P     - Now contains KO values.
C     KRET  - Return code
C             0, OK
C             Non-zero, error
C
C
C     Method.
C     -------
C
C     Linear or cubic interpolation performed as required.
C
C     Comments.
C     ---------
C
C     This is a version of ROWINA which allows for missing data
C     values and hence for bitmapped fields.
C
C
C     Author.
C     -------
C
C     J.D.Chambers    ECMWF     22.07.94
C
C
C     Modifications.
C     --------------
C
C     J.D.Chambers    ECMWF     13.09.94
C     Add return code KRET and remove calls to ABORT.
C
C     J. Clochard, Meteo France, for ECMWF - January 1998.
C     Addition of OMISNG and OPERIO arguments.
C
C
C     -----------------------------------------------------------------
*/
  /* System generated locals */
  int pw_dim1, pw_offset, i_1;

  /* Local variables */
  int ip;
  double zwt1, zrdi, zpos;
  double zdo, zwt;

  UNUSED(omisng);

  /* Parameter adjustments */
  --p;
  pw_dim1 = ko + 3;
  pw_offset = pw_dim1;
  pw -= pw_offset;

  *kret = 0;

  if ( kcode == 1 )
    {
      /*    Move input values to work array */
      for (int jl = 1; jl <= ki; ++jl)
	pw[jl + pw_dim1] = p[jl];

      if ( operio )
	{
	  /* Arrange wrap-around value in work array */
	  pw[ki + 1 + pw_dim1] = p[1];

	  /* Set up constants to be used to figure out weighting for */
	  /* values in interpolation. */
	  zrdi = (double) ki;
	  zdo = 1.0 / (double) ko;
	}
      else
	{
	  /* Repeat last value, to cope with "implicit truncation" below */
	  pw[ki + 1 + pw_dim1] = p[ki];

	  /* Set up constants to be used to figure out weighting for */
	  /* values in interpolation. */
	  zrdi = (double) (ki-1);
	  zdo = 1.0 / (double) (ko-1);
 	}

      /*    Loop through the output points */
      for (int jl = 1; jl <= ko; ++jl)
	{

	  /* Calculate weight from the start of row */
	  zpos = (jl - 1) * zdo;
	  zwt = zpos * zrdi;

	  /* Get the current array position(minus 1) from the weight - */
	  /* note the implicit truncation. */
	  ip = (int) zwt;

	  /* Adjust the weight to range (0.0 to 1.0) */
	  zwt -= ip;

          /* If 'nearest neighbour' processing must be used */
	  if ( oveggy )
	    {
              if ( zwt < 0.5 )
                p[jl] = pw[ip + 1 + pw_dim1];
	      else
		p[jl] = pw[ip + 2 + pw_dim1];
	    }
	  else
	    {
	      /*    If the left value is missing, use the right value */
	      if ( IS_EQUAL(pw[ip + 1 + pw_dim1], msval) )
		{
		  p[jl] = pw[ip + 2 + pw_dim1];
		}
	      /*    If the right value is missing, use the left value */
	      else if ( IS_EQUAL(pw[ip + 2 + pw_dim1], msval) )
		{
		  p[jl] = pw[ip + 1 + pw_dim1];
		}
	      /*    If neither missing, interpolate ... */
	      else
		{
		  /*  Interpolate using the weighted values on either side */
		  /*  of the output point position */
		  p[jl] = (T)((1.0 - zwt) * pw[ip+1 + pw_dim1]
                              + zwt * pw[ip+2 + pw_dim1]);
		}
	    }
	}
    }
  else if ( kcode == 3 )
    {
      /*     *******************************    */
      /*     Section 2.  Cubic interpolation .. */
      /*     *******************************    */
      i_1 = ki;
      for (int jl = 1; jl <= i_1; ++jl)
	{
          if ( IS_EQUAL(p[jl], msval) )
	    {
	      fprintf(stderr," ROWINA3: ");
	      fprintf(stderr," Cubic interpolation not supported");
	      fprintf(stderr," for fields containing missing data.\n");
	      *kret = 1;
	      goto L900;
	    }
          pw[jl + pw_dim1] = p[jl];
	}
      pw[pw_dim1] = p[ki];
      pw[ki + 1 + pw_dim1] = p[1];
      pw[ki + 2 + pw_dim1] = p[2];
      i_1 = ki;
      for (int jl = 1; jl <= i_1; ++jl)
	{
          pw[jl + (pw_dim1 << 1)] =
            (T)(- pw[jl - 1 + pw_dim1] / 3.0 -
                pw[jl     + pw_dim1] * 0.5 +
                pw[jl + 1 + pw_dim1] - pw[jl + 2 + pw_dim1] / 6.0);
          pw[jl + 1 + pw_dim1 * 3] =
            (T)(pw[jl - 1 + pw_dim1] / 6.0 -
                pw[jl     + pw_dim1] +
                pw[jl + 1 + pw_dim1] * 0.5 +
                pw[jl + 2 + pw_dim1] / 3.0);
	}

      TEMPLATE(scm0,T)(&pw[(pw_dim1 << 1) + 1], &pw[pw_dim1 * 3 + 2],
		       &pw[pw_dim1 + 1], &pw[pw_dim1 + 2], ki);

      zrdi = (double) ki;
      zdo = 1.0 / (double) ko;
      for (int jl = 1; jl <= ko; ++jl)
	{
          zpos = (jl - 1) * zdo;
          zwt = zpos * zrdi;
          ip = (int) zwt + 1;
          zwt = zwt + 1.0 - ip;
          zwt1 = 1.0 - zwt;
          p[jl] = (T)(((3.0 - zwt1 * 2.0) * pw[ip + pw_dim1] +
                       zwt * pw[ip + (pw_dim1 << 1)]) * zwt1 * zwt1 +
                      ((3.0 - zwt * 2.0) * pw[ip + 1 + pw_dim1] -
                       zwt1 * pw[ip + 1 + pw_dim1 * 3]) * zwt * zwt);
	}

    }
  else
    {
      /*    **************************************    */
      /*    Section 3.  Invalid interpolation code .. */
      /*    **************************************    */
      fprintf(stderr," ROWINA3:");
      fprintf(stderr," Invalid interpolation code = %2d\n",kcode);
      *kret = 2;
    }

L900:
    return 0;
} /* rowina3 */


int TEMPLATE(qu2reg3,T)(T *pfield, int *kpoint, int klat, int klon,
			T msval, int *kret, int omisng, int operio, int oveggy)
{
  /*
C**** QU2REG3 - Convert quasi-regular grid data to regular.
C
C     Purpose.
C     --------
C
C     Convert quasi-regular grid data to regular,
C     using either a linear or cubic interpolation.
C
C
C**   Interface.
C     ----------
C
C     CALL QU2REG3(PFIELD,KPOINT,KLAT,KLON,KCODE,PMSVAL,OMISNG,OPERIO,
C    X            OVEGGY)
C
C
C     Input Parameters.
C     -----------------
C
C     PFIELD     - Array containing quasi-regular grid data.
C
C     KPOINT     - Array containing list of the number of
C                  points on each latitude (or longitude) of
C                  the quasi-regular grid.
C
C     KLAT       - Number of latitude lines
C
C     KLON       - Number of longitude lines
C
C     KCODE      - Interpolation required.
C                  1 , linear - data quasi-regular on latitude lines.
C                  3 , cubic -  data quasi-regular on latitude lines.
C                  11, linear - data quasi-regular on longitude lines.
C                  13, cubic -  data quasi-regular on longitude lines.
C
C     PMSVAL     - Value used for missing data indicator.
C
C     OMISNG     - True if missing values are present in field.
C
C     OPERIO     - True if input field is periodic.
C
C     OVEGGY     - True if 'nearest neighbour' processing must be used
C                  for interpolation
C
C
C     Output Parameters.
C     ------------------
C
C     KRET       - return code
C                  0 = OK
C                  non-zero indicates fatal error
C
C
C     Output Parameters.
C     ------------------
C
C     PFIELD     - Array containing regular grid data.
C
C
C     Method.
C     -------
C
C     Data is interpolated and expanded into a temporary array,
C     which is then copied back into the user's array.
C     Returns an error code if an invalid interpolation is requested
C     or field size exceeds array dimensions.
C
C     Comments.
C     ---------
C
C     This routine is an adaptation of QU2REG to allow missing data
C     values, and hence bit mapped fields.
C
C
C     Author.
C     -------
C
C     J.D.Chambers     ECMWF      22.07.94
C
C
C     Modifications.
C     --------------
C
C     J.D.Chambers     ECMWF      13.09.94
C     Add return code KRET and remove calls to ABORT.
C
C     J.D.Chambers     ECMWF        Feb 1997
C     Allow for 64-bit pointers
C
C     J. Clochard, Meteo France, for ECMWF - January 1998.
C     Addition of OMISNG and OPERIO arguments.
C     Fix message for longitude number out of bounds, and routine
C     name in title and formats.
C
*/
   /* System generated locals */
   int i_1, i_2;
   int kcode = 1;

   /* Local variables */
   int ilii, ilio, icode;
   int iregno, iquano;

   T *ztemp = (T*) Malloc((size_t)klon*(size_t)klat*sizeof(T));
   T *zline = (T*) Malloc(2*(size_t)klon*sizeof(T));
   T *zwork = (T*) Malloc(3*(2*(size_t)klon+3)*sizeof(T));

   /* Parameter adjustments */
   --pfield;
   --kpoint;

/* ------------------------------ */
/* Section 1. Set initial values. */
/* ------------------------------ */

   *kret = 0;

/* Check input parameters. */

   if (kcode != 1 && kcode != 3 && kcode != 11 && kcode != 13) {
      fprintf(stderr," QU2REG :");
      fprintf(stderr," Invalid interpolation type code = %2d\n",kcode);
      *kret = 1;
      goto L900;
   }

/* Set array indices to 0. */

   ilii = 0;
   ilio = 0;

/* Establish values of loop parameters. */

   if (kcode > 10) {

/*    Quasi-regular along longitude lines. */

      iquano = klon;
      iregno = klat;
      icode = kcode - 10;
   } else {

/*    Quasi-regular along latitude lines. */

      iquano = klat;
      iregno = klon;
      icode = kcode;
   }

/*     -------------------------------------------------------- */
/**    Section 2. Interpolate field from quasi to regular grid. */
/*     -------------------------------------------------------- */

   i_1 = iquano;
   for (int j230 = 1; j230 <= i_1; ++j230) {

      if (iregno != kpoint[j230]) {

/*       Line contains less values than required,so */
/*       extract quasi-regular grid values for a line */

         i_2 = kpoint[j230];
         for (int j210 = 1; j210 <= i_2; ++j210) {
            ++ilii;
            zline[j210 - 1] = pfield[ilii];
         }

/*       and interpolate this line. */

         TEMPLATE(rowina3,T)(zline, iregno, kpoint[j230], zwork, icode, msval, kret, omisng, operio , oveggy);
         if (*kret != 0) goto L900;

/*       Add regular grid values for this line to the
         temporary array. */

         i_2 = iregno;
         for (int j220 = 1; j220 <= i_2; ++j220) {
            ++ilio;
            ztemp[ilio - 1] = zline[j220 - 1];
         }

      } else {

/*       Line contains the required number of values, so add */
/*       this line to the temporary array. */

         i_2 = iregno;
         for (int j225 = 1; j225 <= i_2; ++j225) {
            ++ilio;
            ++ilii;
            ztemp[ilio - 1] = pfield[ilii];
         }
      }
   }

/* Copy temporary array to user array. */

   i_1 = klon * klat;
   for (int j240 = 1; j240 <= i_1; ++j240) {
      pfield[j240] = ztemp[j240 - 1];
   }

/* -------------------------------------------------------- */
/* Section 9. Return to calling routine. Format statements. */
/* -------------------------------------------------------- */

L900:

   Free(zwork);
   Free(zline);
   Free(ztemp);

   return 0;
} /* qu2reg3 */

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */

#ifdef T
#undef T
#endif
#define T float
#ifdef T

/* calculate_pfactor: source code from grib_api-1.8.0 */
double TEMPLATE(calculate_pfactor,T)(const T *spectralField, long fieldTruncation, long subsetTruncation)
{
  /*long n_vals = ((fieldTruncation+1)*(fieldTruncation+2));*/
  long loop, index, m, n = 0;
  double zeps = 1.0e-15;
  long ismin = (subsetTruncation+1), ismax = (fieldTruncation+1);
  double weightedSumOverX = 0.0, weightedSumOverY = 0.0, sumOfWeights = 0.0;
  double numerator = 0.0, denominator = 0.0;

  // Setup the weights

  double range = (double) (ismax - ismin +1);

  double *weights = (double*) Malloc(((size_t)ismax+1)*sizeof(double));
  for( loop = ismin; loop <= ismax; loop++ )
    weights[loop] = range / (double) (loop-ismin+1);

  // Compute norms
  // Handle values 2 at a time (real and imaginary parts).
  double *norms = (double*) Malloc(((size_t)ismax+1)*sizeof(double));

  for( loop = 0; loop < ismax+1; loop++ ) norms[loop] = 0.0;

  // Form norms for the rows which contain part of the unscaled subset.

  index = -2;
  for( m = 0; m < subsetTruncation; m++ )
    for( n = m; n <= fieldTruncation; n++ ) {
      index += 2;
      if( n >= subsetTruncation ) {
        double tval = spectralField[index];
        tval=tval<0?-tval:tval;
        norms[n] = norms[n] > tval ? norms[n] : tval;
        tval = spectralField[index+1];
        tval=tval<0?-tval:tval;
        norms[n] = norms[n] > tval ? norms[n] : tval;
      }
    }

  // Form norms for the rows which do not contain part of the unscaled subset.

  for( m = subsetTruncation; m <= fieldTruncation; m++ )
    for( n = m; n <= fieldTruncation; n++ ) {
      double tval = spectralField[index];
      index += 2;
      tval=tval<0?-tval:tval;
      norms[n] = norms[n] > tval ? norms[n] : tval;
      tval = spectralField[index+1];
      tval=tval<0?-tval:tval;
      norms[n] = norms[n] > tval ? norms[n] : tval;
    }

  // Ensure the norms have a value which is not too small in case of problems with math functions (e.g. LOG).

  for( loop = ismin; loop <= ismax; loop++ ) {
    norms[n] = norms[n] > zeps ? norms[n] : zeps;
    if( IS_EQUAL(norms[n], zeps) ) weights[n] = 100.0 * zeps;
  }

  // Do linear fit to find the slope

  for( loop = ismin; loop <= ismax; loop++ ) {
    double x = log( (double) (loop*(loop+1)) );
    double y = log( norms[loop] );
    weightedSumOverX += x * weights[loop];
    weightedSumOverY += y * weights[loop];
    sumOfWeights = sumOfWeights + weights[loop];
  }
  weightedSumOverX /= sumOfWeights;
  weightedSumOverY /= sumOfWeights;

  // Perform a least square fit for the equation

  for( loop = ismin; loop <= ismax; loop++ ) {

    double x = log( (double)(loop*(loop+1)) );
    double y = log( norms[loop] );
    numerator += weights[loop] * (y-weightedSumOverY) * (x-weightedSumOverX);
    denominator += weights[loop] * ((x-weightedSumOverX) * (x-weightedSumOverX));
  }
  double slope = numerator / denominator;

  Free(weights);
  Free(norms);

  double pFactor = -slope;
  if( pFactor < -9999.9 ) pFactor = -9999.9;
  if( pFactor > 9999.9 )  pFactor = 9999.9;

  return pFactor;
}

void TEMPLATE(scale_complex,T)(T *fpdata, int pcStart, int pcScale, int trunc, int inv)
{

  if ( pcScale < -10000 || pcScale > 10000 )
    {
      fprintf(stderr, " %s: Invalid power given %6d\n", __func__, pcScale);
      return;
    }

  // Setup scaling factors = n(n+1)^^p for n = 1 to truncation

  if ( pcScale != 0 )
    {
      double *scale = (double*) Malloc(((size_t)trunc+1)*sizeof(double));
      const double power = (double) pcScale / 1000.;
      scale[0] = 1.0;

      if (pcScale != 1000)
        for (int n = 1; n <= trunc; ++n) scale[n] = pow((double) (n*(n+1)), power);
      else
        for (int n = 1; n <= trunc; ++n) scale[n] =     (double) (n*(n+1));

      if ( inv )
        for (int n = 1; n <= trunc; ++n) scale[n] = 1.0 / scale[n];

      // Scale the values

      size_t index = 0;

      for (int m = 0;   m < pcStart; ++m)
        for (int n = m; n <= trunc; n++, index += 2)
          if ( n >= pcStart )
            {
              fpdata[index  ] = (T)(fpdata[index  ] * scale[n]);
              fpdata[index+1] = (T)(fpdata[index+1] * scale[n]);
            }

      for (int m = pcStart; m <= trunc; ++m)
        for (int n = m;     n <= trunc; n++, index += 2)
          {
            fpdata[index  ] = (T)(fpdata[index  ] * scale[n]);
            fpdata[index+1] = (T)(fpdata[index+1] * scale[n]);
          }
      Free(scale);
    }
}


void TEMPLATE(scatter_complex,T)(T *fpdata, int pcStart, int trunc, int nsp)
{
  T *fphelp = (T*) Malloc((size_t)nsp*sizeof(T));
  size_t inext = 0;
  size_t pcStart_ = pcStart >= 0 ? (size_t)pcStart : 0U;
  size_t trunc_ = trunc >= 0 ? (size_t)trunc : 0U;
  for (size_t m = 0, index = 0; m <= pcStart_; ++m)
    {
      size_t n_copies = pcStart_ <= trunc_ ? (pcStart_ + 1 - m) * 2 : 0;
      for (size_t i = 0; i < n_copies; ++i) fphelp[index + i] = fpdata[inext + i];
      inext += n_copies;
      index += m <= trunc_ ? (trunc_ - m + 1) * 2 : 0;
    }
  for (size_t m = 0, index = 0; m <= trunc_; ++m)
    {
      size_t advIdx = m <= pcStart_ ? (pcStart_ - m + 1) * 2 : 0;
      index += advIdx;
      size_t copyStart = m > pcStart_ ? m : pcStart_ + 1;
      size_t n_copies = copyStart <= trunc_ ? (trunc_ - copyStart + 1) * 2 : 0;
      for (size_t i = 0; i < n_copies; ++i) fphelp[index + i] = fpdata[inext + i];
      inext += n_copies;
      index += n_copies;
    }
  for (size_t m = 0; m < (size_t)nsp; ++m) fpdata[m] = fphelp[m];

  Free(fphelp);
}


void TEMPLATE(gather_complex,T)(T *fpdata, size_t pcStart, size_t trunc, size_t nsp)
{
  T *restrict fphelp = (T*) Malloc(nsp*sizeof(T));
  size_t inext = 0;

  for (size_t m = 0, index = 0;   m <= pcStart; ++m)
    for (size_t n = m; n <= trunc; ++n)
      {
	if ( pcStart >= n )
	  {
	    fphelp[inext++] = fpdata[index];
	    fphelp[inext++] = fpdata[index+1];
	  }
	index += 2;
      }

  for (size_t m = 0, index = 0; m <= trunc; ++m)
    for (size_t n = m; n <= trunc; ++n)
      {
	if ( n > pcStart )
	  {
	    fphelp[inext++] = fpdata[index];
	    fphelp[inext++] = fpdata[index+1];
	  }
	index += 2;
      }

  for (size_t m = 0; m < nsp; ++m) fpdata[m] = fphelp[m];

  Free(fphelp);
}


static void TEMPLATE(scm0,T)(T *pdl, T *pdr, T *pfl, T *pfr, int klg)
{
  /* **** SCM0   - Apply SCM0 limiter to derivative estimates. */
  /* output: */
  /*   pdl   = the limited derivative at the left edge of the interval */
  /*   pdr   = the limited derivative at the right edge of the interval */
  /* inputs */
  /*   pdl   = the original derivative at the left edge */
  /*   pdr   = the original derivative at the right edge */
  /*   pfl   = function value at the left edge of the interval */
  /*   pfr   = function value at the right edge of the interval */
  /*   klg   = number of intervals where the derivatives are limited */

  /*  define constants */

  double zeps = 1.0e-12;
  double zfac = (1.0 - zeps) * 3.0;

  for (int jl = 0; jl < klg; ++jl)
    {
      double r_1;
      if ( (r_1 = pfr[jl] - pfl[jl], fabs(r_1)) > zeps )
	{
	  double zalpha = pdl[jl] / (pfr[jl] - pfl[jl]);
	  double zbeta  = pdr[jl] / (pfr[jl] - pfl[jl]);
	  if ( zalpha <= 0.0 ) pdl[jl] = 0.0;
	  if ( zbeta  <= 0.0 ) pdr[jl] = 0.0;
	  if ( zalpha > zfac ) pdl[jl] = (T)(zfac * (pfr[jl] - pfl[jl]));
	  if ( zbeta  > zfac ) pdr[jl] = (T)(zfac * (pfr[jl] - pfl[jl]));
	}
      else
	{
	  pdl[jl] = 0.0;
	  pdr[jl] = 0.0;
	}
    }
} /* scm0 */

static
int TEMPLATE(rowina3,T)(T *p, int ko, int ki, T *pw,
			int kcode, T msval, int *kret, int omisng, int operio, int oveggy)
{
  /*
C---->
C**** ROWINA3 - Interpolation of row of values.
C
C     Purpose.
C     --------
C
C     Interpolate a row of values.
C
C
C**   Interface.
C     ----------
C
C     CALL ROWINA3( P, KO, KI, PW, KCODE, PMSVAL, KRET, OMISNG, OPERIO)
C
C
C     Input Parameters.
C     -----------------
C
C     P      - Row of values to be interpolated.
C              Dimension must be at least KO.
C
C     KO     - Number of values required.
C
C     KI     - Number of values in P on input.
C
C     PW     - Working array.
C              Dimension must be at least (0:KO+2,3).
C
C     KCODE  - Interpolation required.
C              1 , linear.
C              3 , cubic.
C
C     PMSVAL - Value used for missing data indicator.
C
C     OMISNG - True if missing values are present in field.
C
C     OPERIO - True if input field is periodic.
C
C     OVEGGY - True if 'nearest neighbour' processing must be used
C              for interpolation
C
C     Output Parameters.
C     ------------------
C
C     P     - Now contains KO values.
C     KRET  - Return code
C             0, OK
C             Non-zero, error
C
C
C     Method.
C     -------
C
C     Linear or cubic interpolation performed as required.
C
C     Comments.
C     ---------
C
C     This is a version of ROWINA which allows for missing data
C     values and hence for bitmapped fields.
C
C
C     Author.
C     -------
C
C     J.D.Chambers    ECMWF     22.07.94
C
C
C     Modifications.
C     --------------
C
C     J.D.Chambers    ECMWF     13.09.94
C     Add return code KRET and remove calls to ABORT.
C
C     J. Clochard, Meteo France, for ECMWF - January 1998.
C     Addition of OMISNG and OPERIO arguments.
C
C
C     -----------------------------------------------------------------
*/
  /* System generated locals */
  int pw_dim1, pw_offset, i_1;

  /* Local variables */
  int ip;
  double zwt1, zrdi, zpos;
  double zdo, zwt;

  UNUSED(omisng);

  /* Parameter adjustments */
  --p;
  pw_dim1 = ko + 3;
  pw_offset = pw_dim1;
  pw -= pw_offset;

  *kret = 0;

  if ( kcode == 1 )
    {
      /*    Move input values to work array */
      for (int jl = 1; jl <= ki; ++jl)
	pw[jl + pw_dim1] = p[jl];

      if ( operio )
	{
	  /* Arrange wrap-around value in work array */
	  pw[ki + 1 + pw_dim1] = p[1];

	  /* Set up constants to be used to figure out weighting for */
	  /* values in interpolation. */
	  zrdi = (double) ki;
	  zdo = 1.0 / (double) ko;
	}
      else
	{
	  /* Repeat last value, to cope with "implicit truncation" below */
	  pw[ki + 1 + pw_dim1] = p[ki];

	  /* Set up constants to be used to figure out weighting for */
	  /* values in interpolation. */
	  zrdi = (double) (ki-1);
	  zdo = 1.0 / (double) (ko-1);
 	}

      /*    Loop through the output points */
      for (int jl = 1; jl <= ko; ++jl)
	{

	  /* Calculate weight from the start of row */
	  zpos = (jl - 1) * zdo;
	  zwt = zpos * zrdi;

	  /* Get the current array position(minus 1) from the weight - */
	  /* note the implicit truncation. */
	  ip = (int) zwt;

	  /* Adjust the weight to range (0.0 to 1.0) */
	  zwt -= ip;

          /* If 'nearest neighbour' processing must be used */
	  if ( oveggy )
	    {
              if ( zwt < 0.5 )
                p[jl] = pw[ip + 1 + pw_dim1];
	      else
		p[jl] = pw[ip + 2 + pw_dim1];
	    }
	  else
	    {
	      /*    If the left value is missing, use the right value */
	      if ( IS_EQUAL(pw[ip + 1 + pw_dim1], msval) )
		{
		  p[jl] = pw[ip + 2 + pw_dim1];
		}
	      /*    If the right value is missing, use the left value */
	      else if ( IS_EQUAL(pw[ip + 2 + pw_dim1], msval) )
		{
		  p[jl] = pw[ip + 1 + pw_dim1];
		}
	      /*    If neither missing, interpolate ... */
	      else
		{
		  /*  Interpolate using the weighted values on either side */
		  /*  of the output point position */
		  p[jl] = (T)((1.0 - zwt) * pw[ip+1 + pw_dim1]
                              + zwt * pw[ip+2 + pw_dim1]);
		}
	    }
	}
    }
  else if ( kcode == 3 )
    {
      /*     *******************************    */
      /*     Section 2.  Cubic interpolation .. */
      /*     *******************************    */
      i_1 = ki;
      for (int jl = 1; jl <= i_1; ++jl)
	{
          if ( IS_EQUAL(p[jl], msval) )
	    {
	      fprintf(stderr," ROWINA3: ");
	      fprintf(stderr," Cubic interpolation not supported");
	      fprintf(stderr," for fields containing missing data.\n");
	      *kret = 1;
	      goto L900;
	    }
          pw[jl + pw_dim1] = p[jl];
	}
      pw[pw_dim1] = p[ki];
      pw[ki + 1 + pw_dim1] = p[1];
      pw[ki + 2 + pw_dim1] = p[2];
      i_1 = ki;
      for (int jl = 1; jl <= i_1; ++jl)
	{
          pw[jl + (pw_dim1 << 1)] =
            (T)(- pw[jl - 1 + pw_dim1] / 3.0 -
                pw[jl     + pw_dim1] * 0.5 +
                pw[jl + 1 + pw_dim1] - pw[jl + 2 + pw_dim1] / 6.0);
          pw[jl + 1 + pw_dim1 * 3] =
            (T)(pw[jl - 1 + pw_dim1] / 6.0 -
                pw[jl     + pw_dim1] +
                pw[jl + 1 + pw_dim1] * 0.5 +
                pw[jl + 2 + pw_dim1] / 3.0);
	}

      TEMPLATE(scm0,T)(&pw[(pw_dim1 << 1) + 1], &pw[pw_dim1 * 3 + 2],
		       &pw[pw_dim1 + 1], &pw[pw_dim1 + 2], ki);

      zrdi = (double) ki;
      zdo = 1.0 / (double) ko;
      for (int jl = 1; jl <= ko; ++jl)
	{
          zpos = (jl - 1) * zdo;
          zwt = zpos * zrdi;
          ip = (int) zwt + 1;
          zwt = zwt + 1.0 - ip;
          zwt1 = 1.0 - zwt;
          p[jl] = (T)(((3.0 - zwt1 * 2.0) * pw[ip + pw_dim1] +
                       zwt * pw[ip + (pw_dim1 << 1)]) * zwt1 * zwt1 +
                      ((3.0 - zwt * 2.0) * pw[ip + 1 + pw_dim1] -
                       zwt1 * pw[ip + 1 + pw_dim1 * 3]) * zwt * zwt);
	}

    }
  else
    {
      /*    **************************************    */
      /*    Section 3.  Invalid interpolation code .. */
      /*    **************************************    */
      fprintf(stderr," ROWINA3:");
      fprintf(stderr," Invalid interpolation code = %2d\n",kcode);
      *kret = 2;
    }

L900:
    return 0;
} /* rowina3 */


int TEMPLATE(qu2reg3,T)(T *pfield, int *kpoint, int klat, int klon,
			T msval, int *kret, int omisng, int operio, int oveggy)
{
  /*
C**** QU2REG3 - Convert quasi-regular grid data to regular.
C
C     Purpose.
C     --------
C
C     Convert quasi-regular grid data to regular,
C     using either a linear or cubic interpolation.
C
C
C**   Interface.
C     ----------
C
C     CALL QU2REG3(PFIELD,KPOINT,KLAT,KLON,KCODE,PMSVAL,OMISNG,OPERIO,
C    X            OVEGGY)
C
C
C     Input Parameters.
C     -----------------
C
C     PFIELD     - Array containing quasi-regular grid data.
C
C     KPOINT     - Array containing list of the number of
C                  points on each latitude (or longitude) of
C                  the quasi-regular grid.
C
C     KLAT       - Number of latitude lines
C
C     KLON       - Number of longitude lines
C
C     KCODE      - Interpolation required.
C                  1 , linear - data quasi-regular on latitude lines.
C                  3 , cubic -  data quasi-regular on latitude lines.
C                  11, linear - data quasi-regular on longitude lines.
C                  13, cubic -  data quasi-regular on longitude lines.
C
C     PMSVAL     - Value used for missing data indicator.
C
C     OMISNG     - True if missing values are present in field.
C
C     OPERIO     - True if input field is periodic.
C
C     OVEGGY     - True if 'nearest neighbour' processing must be used
C                  for interpolation
C
C
C     Output Parameters.
C     ------------------
C
C     KRET       - return code
C                  0 = OK
C                  non-zero indicates fatal error
C
C
C     Output Parameters.
C     ------------------
C
C     PFIELD     - Array containing regular grid data.
C
C
C     Method.
C     -------
C
C     Data is interpolated and expanded into a temporary array,
C     which is then copied back into the user's array.
C     Returns an error code if an invalid interpolation is requested
C     or field size exceeds array dimensions.
C
C     Comments.
C     ---------
C
C     This routine is an adaptation of QU2REG to allow missing data
C     values, and hence bit mapped fields.
C
C
C     Author.
C     -------
C
C     J.D.Chambers     ECMWF      22.07.94
C
C
C     Modifications.
C     --------------
C
C     J.D.Chambers     ECMWF      13.09.94
C     Add return code KRET and remove calls to ABORT.
C
C     J.D.Chambers     ECMWF        Feb 1997
C     Allow for 64-bit pointers
C
C     J. Clochard, Meteo France, for ECMWF - January 1998.
C     Addition of OMISNG and OPERIO arguments.
C     Fix message for longitude number out of bounds, and routine
C     name in title and formats.
C
*/
   /* System generated locals */
   int i_1, i_2;
   int kcode = 1;

   /* Local variables */
   int ilii, ilio, icode;
   int iregno, iquano;

   T *ztemp = (T*) Malloc((size_t)klon*(size_t)klat*sizeof(T));
   T *zline = (T*) Malloc(2*(size_t)klon*sizeof(T));
   T *zwork = (T*) Malloc(3*(2*(size_t)klon+3)*sizeof(T));

   /* Parameter adjustments */
   --pfield;
   --kpoint;

/* ------------------------------ */
/* Section 1. Set initial values. */
/* ------------------------------ */

   *kret = 0;

/* Check input parameters. */

   if (kcode != 1 && kcode != 3 && kcode != 11 && kcode != 13) {
      fprintf(stderr," QU2REG :");
      fprintf(stderr," Invalid interpolation type code = %2d\n",kcode);
      *kret = 1;
      goto L900;
   }

/* Set array indices to 0. */

   ilii = 0;
   ilio = 0;

/* Establish values of loop parameters. */

   if (kcode > 10) {

/*    Quasi-regular along longitude lines. */

      iquano = klon;
      iregno = klat;
      icode = kcode - 10;
   } else {

/*    Quasi-regular along latitude lines. */

      iquano = klat;
      iregno = klon;
      icode = kcode;
   }

/*     -------------------------------------------------------- */
/**    Section 2. Interpolate field from quasi to regular grid. */
/*     -------------------------------------------------------- */

   i_1 = iquano;
   for (int j230 = 1; j230 <= i_1; ++j230) {

      if (iregno != kpoint[j230]) {

/*       Line contains less values than required,so */
/*       extract quasi-regular grid values for a line */

         i_2 = kpoint[j230];
         for (int j210 = 1; j210 <= i_2; ++j210) {
            ++ilii;
            zline[j210 - 1] = pfield[ilii];
         }

/*       and interpolate this line. */

         TEMPLATE(rowina3,T)(zline, iregno, kpoint[j230], zwork, icode, msval, kret, omisng, operio , oveggy);
         if (*kret != 0) goto L900;

/*       Add regular grid values for this line to the
         temporary array. */

         i_2 = iregno;
         for (int j220 = 1; j220 <= i_2; ++j220) {
            ++ilio;
            ztemp[ilio - 1] = zline[j220 - 1];
         }

      } else {

/*       Line contains the required number of values, so add */
/*       this line to the temporary array. */

         i_2 = iregno;
         for (int j225 = 1; j225 <= i_2; ++j225) {
            ++ilio;
            ++ilii;
            ztemp[ilio - 1] = pfield[ilii];
         }
      }
   }

/* Copy temporary array to user array. */

   i_1 = klon * klat;
   for (int j240 = 1; j240 <= i_1; ++j240) {
      pfield[j240] = ztemp[j240 - 1];
   }

/* -------------------------------------------------------- */
/* Section 9. Return to calling routine. Format statements. */
/* -------------------------------------------------------- */

L900:

   Free(zwork);
   Free(zline);
   Free(ztemp);

   return 0;
} /* qu2reg3 */

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */

// clang-format on
#include <string.h>

int
gribVersion(unsigned char *is, size_t buffersize)
{
  if (buffersize < 8) Error("Buffer too small (current size %d)!", (int) buffersize);

  return GRIB_EDITION(is);
}

static double
GET_Real(unsigned char *grib)
{
  int iexp = GET_UINT1(grib[0]);
  int imant = (int) (GET_UINT3(grib[1], grib[2], grib[3]));

  return decfp2(iexp, imant);
}

static size_t
decodeIS(unsigned char *is, int *isec0, int *iret)
{
  // Octets 1 - 4 : The letters G R I B. Four 8 bit fields.

  // Check letters -> GRIB, BUDG or TIDE.

  // Check that 'GRIB' is found where expected.
  bool lgrib = GRIB_START(is);

  // ECMWF pseudo-grib data uses 'BUDG' and 'TIDE'.
  bool lbudg = BUDG_START(is);
  bool ltide = TIDE_START(is);

  // Data is not GRIB or pseudo-grib.
  if (lgrib == false && lbudg == false && ltide == false)
  {
    *iret = 305;
    gprintf(__func__, "Input data is not GRIB or pseudo-grib.");
    gprintf(__func__, "Return code = %d", *iret);
  }
  if (lbudg || ltide)
  {
    *iret = 305;
    gprintf(__func__, "Pseudo-grib data unsupported.");
    gprintf(__func__, "Return code = %d", *iret);
  }

  // Octets 5 - 7 : Length of message. One 24 bit field.
  ISEC0_GRIB_Len = (int) (GRIB1_SECLEN(is));

  // Octet 8 : GRIB Edition Number. One 8 bit field.
  ISEC0_GRIB_Version = GRIB_EDITION(is);

  if (ISEC0_GRIB_Version > 1) Error("GRIB version %d unsupported!", ISEC0_GRIB_Version);

  int grib1offset = ISEC0_GRIB_Version * 4;

  size_t isLen = 4 + (size_t) grib1offset;

  return isLen;
}

static void
decodePDS_ECMWF_local_Extension_1(unsigned char *pds, int *isec1)
{
  isec1[36] = GET_UINT1(pds[40]);                  /* extension identifier       */
  isec1[37] = GET_UINT1(pds[41]);                  /* Class                      */
  isec1[38] = GET_UINT1(pds[42]);                  /* Type                       */
  isec1[39] = (int) (GET_UINT2(pds[43], pds[44])); /* Stream                     */
  /* isec1[40] = GET_UINT4(pds[45],pds[46],pds[47],pds[48]); */
  memcpy((char *) &isec1[40], &pds[45], 4);
  isec1[41] = GET_UINT1(pds[49]); /* Forecast number            */
  isec1[42] = GET_UINT1(pds[50]); /* Total number of forecasts  */
}

static void
decodePDS_DWD_local_Extension_254(unsigned char *pds, int *isec1)
{
  isec1[36] = GET_UINT1(pds[40]); /* extension identifier */
  for (int i = 0; i < 11; ++i) isec1[37 + i] = GET_UINT1(pds[41 + i]);

  int isvn = (int) (GET_UINT2(pds[52], pds[53]));

  isec1[48] = isvn % 0x8000; /* DWD experiment identifier            */
  isec1[49] = isvn >> 15;    /* DWD run type (0=main, 2=ass, 3=test) */
}

static void
decodePDS_DWD_local_Extension_253(unsigned char *pds, int *isec1)
{
  isec1[36] = GET_UINT1(pds[40]); /* extension identifier */
  for (int i = 0; i < 11; ++i) isec1[37 + i] = GET_UINT1(pds[41 + i]);

  int isvn = (int) (GET_UINT2(pds[52], pds[53]));

  isec1[48] = isvn % 0x8000;                       /* DWD experiment identifier            */
  isec1[49] = isvn >> 15;                          /* DWD run type (0=main, 2=ass, 3=test) */
  isec1[50] = GET_UINT1(pds[54]);                  /* User id, specified by table          */
  isec1[51] = (int) (GET_UINT2(pds[55], pds[56])); /* Experiment identifier                */
  isec1[52] = (int) (GET_UINT2(pds[57], pds[58])); /* Ensemble identification by table     */
  isec1[53] = (int) (GET_UINT2(pds[59], pds[60])); /* Number of ensemble members           */
  isec1[54] = (int) (GET_UINT2(pds[61], pds[62])); /* Actual number of ensemble member     */
  isec1[55] = GET_UINT1(pds[63]);                  /* Model major version number           */
  isec1[56] = GET_UINT1(pds[64]);                  /* Model minor version number           */
}

static void
decodePDS_MPIM_local_Extension_1(unsigned char *pds, int *isec1)
{
  isec1[36] = GET_UINT1(pds[40]);                  /* extension identifier            */
  isec1[37] = GET_UINT1(pds[41]);                  /* type of ensemble forecast       */
  isec1[38] = (int) (GET_UINT2(pds[42], pds[43])); /* individual ensemble member      */
  isec1[39] = (int) (GET_UINT2(pds[44], pds[45])); /* number of forecasts in ensemble */
}

static size_t
decodePDS(unsigned char *pds, int *isec0, int *isec1)
{
  size_t pdsLen = PDS_Len;

  // clang-format off
  ISEC1_CodeTable      = PDS_CodeTable;
  ISEC1_CenterID       = PDS_CenterID;
  ISEC1_ModelID        = PDS_ModelID;
  ISEC1_GridDefinition = PDS_GridDefinition;
  ISEC1_Sec2Or3Flag    = PDS_Sec2Or3Flag;
  ISEC1_Parameter      = PDS_Parameter;
  ISEC1_LevelType      = PDS_LevelType;

  if ( (ISEC1_LevelType !=  20) && 
       (ISEC1_LevelType != GRIB1_LTYPE_99)           && 
       (ISEC1_LevelType != GRIB1_LTYPE_ISOBARIC)     && 
       (ISEC1_LevelType != GRIB1_LTYPE_ISOBARIC_PA)  && 
       (ISEC1_LevelType != GRIB1_LTYPE_ALTITUDE)     && 
       (ISEC1_LevelType != GRIB1_LTYPE_HEIGHT)       && 
       (ISEC1_LevelType != GRIB1_LTYPE_SIGMA)        && 
       (ISEC1_LevelType != GRIB1_LTYPE_HYBRID)       && 
       (ISEC1_LevelType != GRIB1_LTYPE_LANDDEPTH)    && 
       (ISEC1_LevelType != GRIB1_LTYPE_ISENTROPIC)   && 
       (ISEC1_LevelType != 115) && 
       (ISEC1_LevelType != 117) && 
       (ISEC1_LevelType != 125) && 
       (ISEC1_LevelType != 127) && 
       (ISEC1_LevelType != GRIB1_LTYPE_SEADEPTH)     && 
       (ISEC1_LevelType != 210) )
    {
      ISEC1_Level1 = PDS_Level1;
      ISEC1_Level2 = PDS_Level2;
    }
  else
    {
      ISEC1_Level1 = (int)(PDS_Level);
      ISEC1_Level2 = 0;
    }

  /* ISEC1_Year        = PDS_Year; */
  ISEC1_Month          = PDS_Month;
  ISEC1_Day            = PDS_Day;
  ISEC1_Hour           = PDS_Hour;
  ISEC1_Minute         = PDS_Minute;
  ISEC1_TimeUnit       = PDS_TimeUnit;
  ISEC1_TimePeriod1    = PDS_TimePeriod1;
  ISEC1_TimePeriod2    = PDS_TimePeriod2;
  ISEC1_TimeRange      = PDS_TimeRange;
  ISEC1_AvgNum         = (int)(PDS_AvgNum);
  ISEC1_AvgMiss        = PDS_AvgMiss;

  if ( ISEC0_GRIB_Version == 1 )
    {
      ISEC1_Year           = PDS_Year;
      ISEC1_Century        = PDS_Century;
      ISEC1_SubCenterID    = PDS_Subcenter;
      ISEC1_DecScaleFactor = PDS_DecimalScale;
    }
  else
    {
      int year             = GET_UINT1(pds[12]);
      if ( year <= 100 )
	{
	  ISEC1_Year       = year;
	  ISEC1_Century    = 1;
	}
      else
	{
	  ISEC1_Year       = year%100;
	  ISEC1_Century    = 1 + (year-ISEC1_Year)/100;
	}
      ISEC1_SubCenterID    = 0;
      ISEC1_DecScaleFactor = 0;
    }

  if ( ISEC1_Year < 0 )
    {
      ISEC1_Year    = -ISEC1_Year;
      ISEC1_Century = -ISEC1_Century;
    }

  ISEC1_LocalFLag = 0;
  if ( pdsLen > 28 )
    {
      size_t localextlen = pdsLen-28;

      if ( localextlen > 4000 )
	{
	  Warning("PDS larger than 4000 bytes not supported!");
	}
      else
	{
	  ISEC1_LocalFLag = 1;

	  if ( ISEC1_CenterID == 78 || ISEC1_CenterID == 215 || ISEC1_CenterID == 250 )
	    {
	      if ( pds[40] == 254 ) 
                decodePDS_DWD_local_Extension_254(pds, isec1);
	      else if ( pds[40] == 253 )
                decodePDS_DWD_local_Extension_253(pds, isec1);
	    }
	  else if ( (ISEC1_CenterID    == 98 && ISEC1_LocalFLag ==  1) ||
		    (ISEC1_SubCenterID == 98 && ISEC1_LocalFLag ==  1) ||
		    (ISEC1_CenterID    ==  7 && ISEC1_SubCenterID == 98) )
	    {
	      if ( pds[40] == 1 )
		decodePDS_ECMWF_local_Extension_1(pds, isec1);
	    }
	  else if ( ISEC1_CenterID    == 252 && ISEC1_LocalFLag ==  1 )
	    {
	      if ( pds[40] == 1 )
		decodePDS_MPIM_local_Extension_1(pds, isec1);	      
	    }
	  else
	    {
	      for ( size_t i = 0; i < localextlen; i++ )
                isec1[24+i] = pds[28+i];
	    }
	}
    }
  // clang-format on

  return pdsLen;
}

static void
gribPrintSec2_double(int *isec0, int *isec2, double *fsec2)
{
  gribPrintSec2DP(isec0, isec2, fsec2);
}
static void
gribPrintSec3_double(int *isec0, int *isec3, double *fsec3)
{
  gribPrintSec3DP(isec0, isec3, fsec3);
}
static void
gribPrintSec4_double(int *isec0, int *isec4, double *fsec4)
{
  gribPrintSec4DP(isec0, isec4, fsec4);
}
static void
gribPrintSec2_float(int *isec0, int *isec2, float *fsec2)
{
  gribPrintSec2SP(isec0, isec2, fsec2);
}
static void
gribPrintSec3_float(int *isec0, int *isec3, float *fsec3)
{
  gribPrintSec3SP(isec0, isec3, fsec3);
}
static void
gribPrintSec4_float(int *isec0, int *isec4, float *fsec4)
{
  gribPrintSec4SP(isec0, isec4, fsec4);
}

// clang-format off

#ifdef T
#undef T
#endif
#define T double
#ifdef T

#include <inttypes.h>

static 
void TEMPLATE(decode_array_common,T)(const unsigned char *restrict igrib, long jlend, int NumBits, 
				     T fmin, T zscale, T *restrict fpdata)
{
  /* code from wgrib routine BDS_unpack */
  const unsigned char *bits = igrib;
  unsigned int tbits = 0;
  int n_bits = NumBits;
  int t_bits = 0;

  const unsigned jmask = (1U << n_bits) - 1U;
  for (long i = 0; i < jlend; ++i)
    {
      if (n_bits - t_bits > 8)
	{
	  tbits = (tbits << 16) | ((unsigned)bits[0] << 8) | ((unsigned)bits[1]);
	  bits += 2;
	  t_bits += 16;
	}

      while ( t_bits < n_bits )
	{
	  tbits = (tbits * 256) + *bits++;
	  t_bits += 8;
	}
      t_bits -= n_bits;
      fpdata[i] = (float)((tbits >> t_bits) & jmask);
    }
  // at least this vectorizes :)
  for (long i = 0; i < jlend; ++i)
    fpdata[i] = fmin + zscale*fpdata[i];
}

static
void TEMPLATE(decode_array_common2,T)(const unsigned char *restrict igrib, long jlend, int NumBits,
				      T fmin, T zscale, T *restrict fpdata)
{
  static const unsigned mask[] = {0,1,3,7,15,31,63,127,255};
  static const double shift[9] = {1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0};

  // code from wgrib routine BDS_unpack
  const unsigned char *bits = igrib;
  int n_bits = NumBits;
  int c_bits, j_bits;

  // older unoptimized code, not often used
  c_bits = 8;
  for (long i = 0; i < jlend; ++i)
    {
      double jj = 0.0;
      j_bits = n_bits;
      while (c_bits <= j_bits)
	{
	  if (c_bits == 8)
	    {
	      jj = jj * 256.0  + (double) (*bits++);
	      j_bits -= 8;
	    }
	  else
	    {
	      jj = (jj * shift[c_bits]) + (double) (*bits & mask[c_bits]);
	      bits++;
	      j_bits -= c_bits;
	      c_bits = 8;
	    }
	}

      if (j_bits)
	{
	  c_bits -= j_bits;
	  jj = (jj * shift[j_bits]) + (double) (((unsigned)*bits >> c_bits) & mask[j_bits]);
	}
      fpdata[i] = (T)(fmin + zscale*jj);
    }
}

static
void TEMPLATE(decode_array_2byte,T)(size_t jlend, const unsigned char *restrict igrib,
                                    T *fpdata, T fmin, T zscale)
{
  const uint16_t *restrict sgrib = (const uint16_t *)(const void *)(igrib);

  if ( IS_BIGENDIAN() )
    {
      for (size_t i = 0; i < jlend; ++i)
        {
          fpdata[i] = fmin + zscale * sgrib[i];
        }
    }
  else
    {
      for (size_t i = 0; i < jlend; ++i)
        {
          uint16_t ui16 = gribSwapByteOrder_uint16(sgrib[i]);
          fpdata[i] = fmin + zscale * ui16;
        }
    }
}

static 
void TEMPLATE(decode_array,T)(const unsigned char *restrict igrib, long jlend, int numBits, 
			      T fmin, T zscale, T *restrict fpdata)
{
#if defined _GET_X86_COUNTER || defined _GET_MACH_COUNTER 
  uint64_t start_decode, end_decode;
#endif

#ifdef VECTORCODE
  GRIBPACK *lgrib = NULL;

  if ( numBits%8 == 0 )
    {
      long jlenc = jlend * numBits / 8;
      if ( jlenc > 0 ) 
	{
	  lgrib = (GRIBPACK*) Malloc(jlenc*sizeof(GRIBPACK));
	  if ( lgrib == NULL ) SysError("No Memory!");

	  (void) UNPACK_GRIB(igrib, lgrib, jlenc, -1L);
	}
    }

  if ( numBits ==  0 )
    {
      for (long i = 0; i < jlend; ++i)
	fpdata[i] = fmin;
    }
  else if ( numBits ==  8 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (int)lgrib[i];
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 16 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (((int)lgrib[2*i  ] <<  8) +  (int)lgrib[2*i+1]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 24 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (((int)lgrib[3*i  ] << 16) + ((int)lgrib[3*i+1] <<  8) +
	  	 (int)lgrib[3*i+2]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 32 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (((unsigned int)lgrib[4*i  ] << 24) + ((unsigned int)lgrib[4*i+1] << 16) +
		((unsigned int)lgrib[4*i+2] <<  8) +  (unsigned int)lgrib[4*i+3]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits <= 25 )
    {
      TEMPLATE(decode_array_common,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else if ( numBits > 25 && numBits < 32 )
    {
      TEMPLATE(decode_array_common2,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }

  if ( lgrib ) Free(lgrib);

#else
  if ( numBits ==  0 )
    {
      for (long i = 0; i < jlend; ++i)
	fpdata[i] = fmin;
    }
  else if ( numBits ==  8 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (int)igrib[i];
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 16 )
    {
      TEMPLATE(decode_array_2byte,T)((size_t) jlend, igrib, fpdata, fmin, zscale);
    }
  else if ( numBits == 24 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (T)(((int)igrib[3*i  ] << 16) + ((int)igrib[3*i+1] <<  8) +
                     (int)igrib[3*i+2]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 32 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (T)(((unsigned int)igrib[4*i  ] << 24) + ((unsigned int)igrib[4*i+1] << 16) +
                     ((unsigned int)igrib[4*i+2] <<  8) +  (unsigned int)igrib[4*i+3]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits <= 25 )
    {
      TEMPLATE(decode_array_common,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else if ( numBits > 25 && numBits < 32 )
    {
      TEMPLATE(decode_array_common2,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }
#endif
}

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * End:
 */

#ifdef T
#undef T
#endif
#define T float
#ifdef T

#include <inttypes.h>

static 
void TEMPLATE(decode_array_common,T)(const unsigned char *restrict igrib, long jlend, int NumBits, 
				     T fmin, T zscale, T *restrict fpdata)
{
  /* code from wgrib routine BDS_unpack */
  const unsigned char *bits = igrib;
  unsigned int tbits = 0;
  int n_bits = NumBits;
  int t_bits = 0;

  const unsigned jmask = (1U << n_bits) - 1U;
  for (long i = 0; i < jlend; ++i)
    {
      if (n_bits - t_bits > 8)
	{
	  tbits = (tbits << 16) | ((unsigned)bits[0] << 8) | ((unsigned)bits[1]);
	  bits += 2;
	  t_bits += 16;
	}

      while ( t_bits < n_bits )
	{
	  tbits = (tbits * 256) + *bits++;
	  t_bits += 8;
	}
      t_bits -= n_bits;
      fpdata[i] = (float)((tbits >> t_bits) & jmask);
    }
  // at least this vectorizes :)
  for (long i = 0; i < jlend; ++i)
    fpdata[i] = fmin + zscale*fpdata[i];
}

static
void TEMPLATE(decode_array_common2,T)(const unsigned char *restrict igrib, long jlend, int NumBits,
				      T fmin, T zscale, T *restrict fpdata)
{
  static const unsigned mask[] = {0,1,3,7,15,31,63,127,255};
  static const double shift[9] = {1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0};

  // code from wgrib routine BDS_unpack
  const unsigned char *bits = igrib;
  int n_bits = NumBits;
  int c_bits, j_bits;

  // older unoptimized code, not often used
  c_bits = 8;
  for (long i = 0; i < jlend; ++i)
    {
      double jj = 0.0;
      j_bits = n_bits;
      while (c_bits <= j_bits)
	{
	  if (c_bits == 8)
	    {
	      jj = jj * 256.0  + (double) (*bits++);
	      j_bits -= 8;
	    }
	  else
	    {
	      jj = (jj * shift[c_bits]) + (double) (*bits & mask[c_bits]);
	      bits++;
	      j_bits -= c_bits;
	      c_bits = 8;
	    }
	}

      if (j_bits)
	{
	  c_bits -= j_bits;
	  jj = (jj * shift[j_bits]) + (double) (((unsigned)*bits >> c_bits) & mask[j_bits]);
	}
      fpdata[i] = (T)(fmin + zscale*jj);
    }
}

static
void TEMPLATE(decode_array_2byte,T)(size_t jlend, const unsigned char *restrict igrib,
                                    T *fpdata, T fmin, T zscale)
{
  const uint16_t *restrict sgrib = (const uint16_t *)(const void *)(igrib);

  if ( IS_BIGENDIAN() )
    {
      for (size_t i = 0; i < jlend; ++i)
        {
          fpdata[i] = fmin + zscale * sgrib[i];
        }
    }
  else
    {
      for (size_t i = 0; i < jlend; ++i)
        {
          uint16_t ui16 = gribSwapByteOrder_uint16(sgrib[i]);
          fpdata[i] = fmin + zscale * ui16;
        }
    }
}

static 
void TEMPLATE(decode_array,T)(const unsigned char *restrict igrib, long jlend, int numBits, 
			      T fmin, T zscale, T *restrict fpdata)
{
#if defined _GET_X86_COUNTER || defined _GET_MACH_COUNTER 
  uint64_t start_decode, end_decode;
#endif

#ifdef VECTORCODE
  GRIBPACK *lgrib = NULL;

  if ( numBits%8 == 0 )
    {
      long jlenc = jlend * numBits / 8;
      if ( jlenc > 0 ) 
	{
	  lgrib = (GRIBPACK*) Malloc(jlenc*sizeof(GRIBPACK));
	  if ( lgrib == NULL ) SysError("No Memory!");

	  (void) UNPACK_GRIB(igrib, lgrib, jlenc, -1L);
	}
    }

  if ( numBits ==  0 )
    {
      for (long i = 0; i < jlend; ++i)
	fpdata[i] = fmin;
    }
  else if ( numBits ==  8 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (int)lgrib[i];
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 16 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (((int)lgrib[2*i  ] <<  8) +  (int)lgrib[2*i+1]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 24 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (((int)lgrib[3*i  ] << 16) + ((int)lgrib[3*i+1] <<  8) +
	  	 (int)lgrib[3*i+2]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 32 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (((unsigned int)lgrib[4*i  ] << 24) + ((unsigned int)lgrib[4*i+1] << 16) +
		((unsigned int)lgrib[4*i+2] <<  8) +  (unsigned int)lgrib[4*i+3]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits <= 25 )
    {
      TEMPLATE(decode_array_common,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else if ( numBits > 25 && numBits < 32 )
    {
      TEMPLATE(decode_array_common2,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }

  if ( lgrib ) Free(lgrib);

#else
  if ( numBits ==  0 )
    {
      for (long i = 0; i < jlend; ++i)
	fpdata[i] = fmin;
    }
  else if ( numBits ==  8 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (int)igrib[i];
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 16 )
    {
      TEMPLATE(decode_array_2byte,T)((size_t) jlend, igrib, fpdata, fmin, zscale);
    }
  else if ( numBits == 24 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (T)(((int)igrib[3*i  ] << 16) + ((int)igrib[3*i+1] <<  8) +
                     (int)igrib[3*i+2]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits == 32 )
    for (long i = 0; i < jlend; ++i)
      {
	T dval = (T)(((unsigned int)igrib[4*i  ] << 24) + ((unsigned int)igrib[4*i+1] << 16) +
                     ((unsigned int)igrib[4*i+2] <<  8) +  (unsigned int)igrib[4*i+3]);
	fpdata[i] = fmin + zscale * dval;
      }
  else if ( numBits <= 25 )
    {
      TEMPLATE(decode_array_common,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else if ( numBits > 25 && numBits < 32 )
    {
      TEMPLATE(decode_array_common2,T)(igrib, jlend, numBits, fmin, zscale, fpdata);
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }
#endif
}

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * End:
 */


#ifdef T
#undef T
#endif
#define T double
#ifdef T

static
size_t TEMPLATE(decodeGDS,T)(unsigned char  *gds, int *isec0, int *isec2, T *fsec2, size_t *numGridVals)
{
  // int imisng = 0;
  bool ReducedGrid = false, VertCoorTab = false;
#ifdef VECTORCODE
  unsigned char *igrib;
  GRIBPACK *lgrib = NULL;
  size_t lGribLen = 0;
#endif

  *numGridVals = 0;

  memset(isec2, 0, 22*sizeof(int));

  const unsigned gdsLen = GDS_Len;

  unsigned ipvpl = GDS_PVPL;
  if ( ipvpl == 0 ) ipvpl = 0xFF;

  if ( ipvpl != 0xFF )
    { // Either vct or reduced grid
      if ( GDS_NV != 0 )
	{ // we have vct
	  VertCoorTab = true;
	  const unsigned ipl =  4*GDS_NV + ipvpl - 1;
	  if ( ipl < gdsLen ) ReducedGrid = true;
	}
      else
	{
	  VertCoorTab = false;
	  ReducedGrid = true;
	}
      // ReducedGrid = (gdsLen - 32 - 4*GDS_NV);
    }
 
  if ( ISEC0_GRIB_Version == 0 ) VertCoorTab = ((gdsLen - 32) > 0);
  
  if ( ReducedGrid )
    {
      const unsigned locnl = GDS_PVPL - 1U + (VertCoorTab * 4U * GDS_NV);
      const unsigned jlenl = (gdsLen - locnl)  >> 1;
      if ( jlenl == GDS_NumLat )
	{
	  ISEC2_Reduced = true;
          size_t accum = 0;
	  for ( size_t i = 0; i < jlenl; ++i )
	    {
              unsigned rpi = GET_UINT2(gds[locnl+2*i], gds[locnl+2*i+1]);
              ISEC2_ReducedPoints(i) = (int)rpi;
              accum += rpi;
	    }
          *numGridVals = accum;
	}
      else
	{
	  ReducedGrid = false;
	}
    }

  ISEC2_GridType = GDS_GridType;

  // Gaussian grid definition.

  if ( ISEC2_GridType == GRIB1_GTYPE_LATLON    ||
       ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN  ||
       ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
    {
      ISEC2_NumLat    = (int)(GDS_NumLat);
      if ( ! ReducedGrid )
	{
	  ISEC2_NumLon = (int)(GDS_NumLon);
	  *numGridVals  = (size_t)ISEC2_NumLon*(size_t)ISEC2_NumLat;
	}
      ISEC2_FirstLat  = GDS_FirstLat;
      ISEC2_FirstLon  = GDS_FirstLon;
      ISEC2_ResFlag   = GDS_ResFlag;
      ISEC2_LastLat   = GDS_LastLat;
      ISEC2_LastLon   = GDS_LastLon;
      ISEC2_LonIncr   = (int)(GDS_LonIncr);

      ISEC2_NumPar    = (int)GDS_NumPar;
      ISEC2_ScanFlag  = GDS_ScanFlag;
      if ( ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
	{
	  ISEC2_LatSP     = GDS_LatSP;
	  ISEC2_LonSP     = GDS_LonSP;
	  FSEC2_RotAngle  = (T)GDS_RotAngle;
	}
      // if ( Lons != Longitudes || Lats != Latitudes ) Error("Latitude/Longitude Conflict");
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN     ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN_ROT ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN_STR ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN_ROTSTR )
    {
      // iret = decodeGDS_GG(gds, gdspos, isec0, isec2, imisng);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LATLON     ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_STR ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_ROTSTR )
    {
      // iret = decodeGDS_LL(gds, gdspos, isec0, isec2, imisng);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LCC )
    {
      ISEC2_NumLon    = (int)(GDS_NumLon);
      ISEC2_NumLat    = (int)(GDS_NumLat);
      *numGridVals  = (size_t)ISEC2_NumLon*(size_t)ISEC2_NumLat;
      ISEC2_FirstLat  = GDS_FirstLat;
      ISEC2_FirstLon  = GDS_FirstLon;
      ISEC2_ResFlag   = GDS_ResFlag;
      ISEC2_Lambert_Lov   = GDS_Lambert_Lov;
      ISEC2_Lambert_dx    = GDS_Lambert_dx;
      ISEC2_Lambert_dy    = GDS_Lambert_dy;
      ISEC2_Lambert_LatS1 = GDS_Lambert_LatS1;
      ISEC2_Lambert_LatS2 = GDS_Lambert_LatS2;
      ISEC2_Lambert_LatSP = GDS_Lambert_LatSP;
      ISEC2_Lambert_LonSP = GDS_Lambert_LonSP;
      ISEC2_Lambert_ProjFlag = GDS_Lambert_ProjFlag;
      ISEC2_ScanFlag      = GDS_ScanFlag;
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_SPECTRAL )
    {
      ISEC2_PentaJ  = (int)(GDS_PentaJ); // Truncation
      ISEC2_PentaK  = (int)(GDS_PentaK);
      ISEC2_PentaM  = (int)(GDS_PentaM);
      ISEC2_RepType = GDS_RepType;
      ISEC2_RepMode = GDS_RepMode;
      *numGridVals  = ((size_t)ISEC2_PentaJ+1)*((size_t)ISEC2_PentaJ+2);
      isec2[ 6] = 0;
      isec2[ 7] = 0;
      isec2[ 8] = 0;
      isec2[ 9] = 0;
      isec2[10] = 0;
      // iret = decodeGDS_SH(gds, gdspos, isec0, isec2, imisng);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_GME )
    {
      ISEC2_GME_NI2    = (int)(GDS_GME_NI2);
      ISEC2_GME_NI3    = (int)(GDS_GME_NI3);
      ISEC2_GME_ND     = (int)(GDS_GME_ND);
      ISEC2_GME_NI     = (int)(GDS_GME_NI);
      ISEC2_GME_AFlag  = GDS_GME_AFlag;
      ISEC2_GME_LatPP  = GDS_GME_LatPP;
      ISEC2_GME_LonPP  = GDS_GME_LonPP;
      ISEC2_GME_LonMPL = GDS_GME_LonMPL;
      ISEC2_GME_BFlag  = GDS_GME_BFlag;
      *numGridVals  = ((size_t)ISEC2_GME_NI+1)*((size_t)ISEC2_GME_NI+1)*10;
      // iret = decodeGDS_TR(gds, gdspos, isec0, isec2, imisng);
    }
  else
    {
      static bool lwarn = true;
      unsigned nlon = GDS_NumLon, nlat = GDS_NumLat;
      ISEC2_NumLon = (int)nlon;
      ISEC2_NumLat = (int)nlat;
      *numGridVals  = (size_t)nlon*(size_t)nlat;
      if ( lwarn )
        {
          lwarn = false;
          Message("GRIB gridtype %d unsupported", ISEC2_GridType);
        }
    }

  // Vertical coordinate parameters for hybrid levels.
  // Get number of vertical coordinate parameters, if any.

  ISEC2_NumVCP = 0;

  isec2[17] = 0;
  isec2[18] = 0;

  if ( VertCoorTab )
    {
      int locnv;
      if ( ISEC0_GRIB_Version  == 0 )
	{
	  locnv = 32;
	  ISEC2_NumVCP = ((int)gdsLen - 32) >> 2;
	}
      else
	{
	  locnv = (int)GDS_PVPL - 1;
	  ISEC2_NumVCP = GDS_NV;
	}
#if defined (SX)
      lGribLen = 4*ISEC2_NumVCP;	      
      lgrib    = (GRIBPACK*) Malloc(lGribLen*sizeof(GRIBPACK));

      igrib = &gds[locnv];
      if ( ISEC2_NumVCP > 0 ) (void) UNPACK_GRIB(igrib, lgrib, lGribLen, -1L);
      for (int i = 0; i < ISEC2_NumVCP; ++i)
	{
	  const int iexp  = lgrib[4*i];
	  const int imant = GET_UINT3(lgrib[4*i+1], lgrib[4*i+2], lgrib[4*i+3]);
	  fsec2[10+i] = POW_2_M24 * imant * ldexp(1.0, 4 * (iexp - 64));
	}

      Free(lgrib);
#else
      for (int i = 0; i < ISEC2_NumVCP; ++i)
	{
	  const int iexp  = gds[locnv+4*i];
	  const int imant = (int)(GET_UINT3(gds[locnv+4*i+1], gds[locnv+4*i+2], gds[locnv+4*i+3]));
	  fsec2[10+i] = (T)decfp2(iexp,imant);
	}
#endif
    }

  return gdsLen;
}

#define ldexp_double ldexp
#define ldexp_float  ldexpf
#define pow_double pow
#define pow_float powf

static
void TEMPLATE(decodeBDS,T)(int decscale, unsigned char *bds, int *isec2, int *isec4, 
                           T *fsec4, int fsec4len, int dfunc, size_t bdsLen, size_t numGridVals, int *iret)
{
  size_t ioff = 0;
  enum { bds_head = 11 };
  T zscale = 0.;
  T fmin = 0.;
  T *fpdata = fsec4;

  *iret = 0;
  unsigned char *igrib = bds;

  memset(isec4, 0, 42*sizeof(int));

  // 4 bit flag / 4 bit count of unused bits at end of block octet.

  const int bds_flag = BDS_Flag;

  // 0------- grid point
  // 1------- spherical harmonics

  const bool lspherc = (bds_flag >> 7)&1;
  if ( lspherc ) isec4[2] = 128;
  else           isec4[2] = 0;

  // -0------  simple packing
  // -1------ complex packing

  const bool lcomplex = (bds_flag >> 6)&1;
  if ( lcomplex ) isec4[3] = 64;
  else            isec4[3] =  0;

  // ---0---- No additional flags
  // ---1---- No additional flags

  const bool lcompress = (bds_flag >> 4)&1;

  unsigned zoff;
  if ( lcompress )
    { isec4[5] = 16; isec4[6] = BDS_Z; zoff = 12; }
  else
    { isec4[5] =  0; isec4[6] = 0;     zoff =  0; }

  // ----++++ number of unused bits at end of section)

  const unsigned bds_ubits = bds_flag & 0xF;
  
  // scale factor (2 bytes)
  const int jscale = BDS_BinScale;

  // check for missing data indicators.

  const int iexp  = bds[ 6];
  const int imant = (int)(GET_UINT3(bds[ 7], bds[ 8], bds[ 9]));

  const int imiss = (jscale == 0xFFFF && iexp == 0xFF && imant == 0xFFFFFF);

  // convert reference value and scale factor.

  if ( ! (dfunc == 'J') && imiss == 0 )
    {
      fmin = (T)BDS_RefValue;
      zscale = TEMPLATE(ldexp,T)((T)1.0, jscale);
    }

  // get number of bits in each data value.

  unsigned dvbits = BDS_NumBits;
  ISEC4_NumBits = BDS_NumBits;

  // octet number of start of packed data calculated from start of block 4 - 1

  size_t locnd = zoff + bds_head;

  // if data is in spherical harmonic form, distinguish  between simple/complex packing (lcomplex = 0/1)

  if ( lspherc )
    {
      if ( !lcomplex )
	{
	  // no unpacked binary data present octet number of start of packed data
	  // calculated from start of block 4 - 1

	  ioff   = 1;
	  locnd += 4*ioff;  // RealCoef

	  // get real (0,0) coefficient in grib format and convert to floating point.
	  if ( dfunc != 'J' )
	    {
	      if ( imiss ) *fpdata++ = 0.0;
	      else         *fpdata++ = (T)BDS_RealCoef;
	    }
	}
      else // complex packed spherical harmonics
	{
	  isec4[15] = BDS_PackData;
	  // scaling factor
	  isec4[16] = BDS_Power;

	  // pentagonal resolution parameters of the unpacked section of data field

	  const int jup = bds[zoff+15];
	  const int kup = bds[zoff+16];
	  const int mup = bds[zoff+17];

	  isec4[zoff+17] = jup;
	  isec4[zoff+18] = kup;
	  isec4[zoff+19] = mup;

	  // unpacked binary data

	  locnd += 4; // 2 + power
	  locnd += 3; // j, k, m
	  ioff   = ((size_t)jup+1)*((size_t)jup+2);

	  if ( dfunc != 'J' )
	    for ( size_t i = 0; i < ioff; ++i )
	      {
		if ( imiss )
		  fpdata[i] = 0.0;
		else
		  {
		    const int iexp2  = (int)(bds[locnd+4*i]);
		    const int imant2 = (int)(GET_UINT3(bds[locnd+4*i+1], bds[locnd+4*i+2], bds[locnd+4*i+3]));
		    fpdata[i] = (T)decfp2(iexp2,imant2);
		  }
	      }
          fpdata += ioff;
	  locnd += 4*ioff;  /* RealCoef */
	}
    }
  else
    {
      if ( lcomplex )
	{
	  *iret = 1999;
	  gprintf(__func__, " Second order packed grids unsupported!");
	  gprintf(__func__, " Return code =  %d", *iret);
	  return;
	}
    }

  // Decode data values to floating point and store in fsec4.
  // First calculate the number of data values.
  // Take into account that spherical harmonics can be packed
  // simple (lcomplex = 0) or complex (lcomplex = 1)

  size_t jlend = bdsLen - locnd;

  if ( dvbits == 0 )
    {
      if ( jlend > 1 )
	{
	  *iret = 2001;
	  gprintf(__func__, " Number of bits per data value = 0!");
	  gprintf(__func__, " Return code =  %d", *iret);
	  return;
	}

      if ( numGridVals == 0 )
	{
	  *iret = 2002;
	  gprintf(__func__, " Constant field unsupported for this grid type!");
	  gprintf(__func__, " Return code =  %d", *iret);
	  return;
	}

      jlend = numGridVals - ioff;
    }
  else
    {
      jlend = (jlend*8 - bds_ubits) / dvbits;
    }

  ISEC4_NumValues        = (int)(jlend + ioff);
  ISEC4_NumNonMissValues = 0;

  if ( lcompress )
    {
      const size_t len = ((size_t) ((bds[17]<<16)+(bds[18]<<8)+bds[19]));

      ISEC4_NumValues = (int)(len*8/dvbits);

      if ( lspherc ) ISEC4_NumValues += lcomplex ? (int)ioff : 1;
    }

  if ( dfunc == 'J' ) return;

  // check length of output array.
  
  if ( ISEC4_NumValues > fsec4len )
    {
      *iret = 710;
      gprintf(__func__, " Output array too small. Length = %d", fsec4len);
      gprintf(__func__, " Number of values = %d", ISEC4_NumValues);
      gprintf(__func__, " Return code =  %d", *iret);
      return;
    }

  if ( imiss ) memset((char *)fpdata, 0, jlend*sizeof(T));
  else
    {
      igrib += locnd;

      TEMPLATE(decode_array,T)(igrib, (long)jlend, ISEC4_NumBits, fmin, zscale, fpdata);
    }

  if ( lspherc && lcomplex )
    {
      int pcStart = isec4[19], pcScale = isec4[16];
      TEMPLATE(scatter_complex,T)(fsec4, pcStart, ISEC2_PentaJ, ISEC4_NumValues);
      TEMPLATE(scale_complex,T)(fsec4, pcStart, pcScale, ISEC2_PentaJ, 1);
    }

  if ( CGRIBEX_Fix_ZSE )  // Fix ZeroShiftError of simple packed spherical harmonics
    if ( lspherc && !lcomplex )
      {
        // 20100705: Fix ZeroShiftError - Edi Kirk
	if ( IS_NOT_EQUAL(fsec4[1], 0.0) )
	  {
	    const T zserr = fsec4[1];
	    for (int i = 1; i < ISEC4_NumValues; ++i) fsec4[i] -= zserr;
	  }
      }

  if ( decscale )
    {
      const T scale = TEMPLATE(pow,T)((T)10.0, (T)-decscale);
      for (int i = 0; i < ISEC4_NumValues; ++i) fsec4[i] *= scale;
    }
}


void TEMPLATE(grib_decode,T)(int *isec0, int *isec1, int *isec2, T *fsec2, int *isec3,
			     T *fsec3, int *isec4, T *fsec4, int fsec4len, int *kgrib,
			     int kleng, int *kword, int dfunc, int *iret)
{
  UCHAR *bms = NULL;
  bool lsect2 = false, lsect3 = false;
  static bool lmissvalinfo = true;

  UNUSED(kleng);

  *iret = 0;

  grsdef();

  ISEC2_Reduced = false;

  // ----------------------------------------------------------------
  // IS Indicator Section (Section 0)
  // ----------------------------------------------------------------
  UCHAR *is = (UCHAR *) &kgrib[0];
  size_t isLen = decodeIS(is, isec0, iret);

  size_t gribLen = (size_t)ISEC0_GRIB_Len;

  /*
    When decoding or calculating length, previous editions
    of the GRIB code must be taken into account.

    In the table below, covering sections 0 and 1 of the GRIB
    code, octet numbering is from the beginning of the GRIB
    message;
    * indicates that the value is not available in the code edition;
    R indicates reserved, should be set to 0;
    Experimental edition is considered as edition -1.

    GRIB code edition -1 has fixed length of 20 octets for
    section 1, the length not included in the message.
    GRIB code edition 0 has fixed length of 24 octets for
    section 1, the length being included in the message.
    GRIB code edition 1 can have different lengths for section
    1, the minimum being 28 octets, length being included in
    the message.

                                         Octet numbers for code
                                                  editions

                 Contents.                   -1      0      1
                 ---------                ----------------------
       Letters GRIB                          1-4    1-4    1-4
       Total length of GRIB message.          *      *     5-7
       GRIB code edition number               *      *      8
       Length of Section 1.                   *     5-7    9-11
       Reserved octet (R).                    *      8(R)   *
       Version no. of Code Table 2.           *      *     12
       Identification of centre.              5      9     13
       Generating process.                    6     10     14
       Grid definition .                      7     11     15
       Flag (Code Table 1).                   8     12     16
       Indicator of parameter.                9     13     17
       Indicator of type of level.           10     14     18
       Height, pressure etc of levels.      11-12  15-16  19-20
       Year of century.                      13     17     21
       Month.                                14     18     22
       Day.                                  15     19     23
       Hour.                                 16     20     24
       Minute.                               17     21     25
       Indicator of unit of time.            18     22     26
       P1 - Period of time.                  19     23     27
       P2 - Period of time                  20(R)   24     28
       or reserved octet (R).
       Time range indicator.                21(R)   25     29
       or reserved octet (R).
       Number included in average.       22-23(R)  26-27  30-31
       or reserved octet (R).
       Number missing from average.         24(R)  28(R)   32
       or reserved octet (R).
       Century of data.                       *      *     33
       Designates sub-centre if not 0.        *      *     34
       Decimal scale factor.                  *      *    35-36
       Reserved. Set to 0.                    *      *    37-48
       (Need not be present)
       For originating centre use only.       *      *    49-nn
       (Need not be present)

    Identify which GRIB code edition is being decoded.

    In GRIB edition 1, the edition number is in octet 8.
    In GRIB edition 0, octet 8 is reserved and set to 0.
    In GRIB edition -1, octet 8 is a flag field and can have a
    a valid value of 0, 1, 2 or 3.

    However, GRIB edition number 0 has a fixed
    length of 24, included in the message, for section 1, so
    if the value extracted from octets 5-7 is 24 and that from
    octet 8 is 0, it is safe to assume edition 0 of the code.

  */

  // Set length of GRIB message to missing data value.
  if ( ISEC0_GRIB_Len == 24 && ISEC0_GRIB_Version == 0 ) ISEC0_GRIB_Len = 0;

  // ----------------------------------------------------------------
  // PDS Product Definition Section (Section 1)
  // ----------------------------------------------------------------
  UCHAR *pds = is + isLen;
  size_t pdsLen = decodePDS(pds, isec0, isec1);

  // ----------------------------------------------------------------
  // GDS Grid Description Section (Section 2)
  // ----------------------------------------------------------------
  size_t numGridVals = 0;
  size_t gdsLen = 0;
  const bool gdsIncluded = ISEC1_Sec2Or3Flag & 128;
  if ( gdsIncluded )
    {
      UCHAR *gds = is + isLen + pdsLen;
      gdsLen = TEMPLATE(decodeGDS,T)(gds, isec0, isec2, fsec2, &numGridVals);
    }

  // ----------------------------------------------------------------
  // BMS Bit-Map Section Section (Section 3)
  // ----------------------------------------------------------------
  isec3[0] = 0;
  size_t bmsLen = 0, bitmapSize = 0, imaskSize = 0;
  const bool bmsIncluded = ISEC1_Sec2Or3Flag & 64;
  if ( bmsIncluded )
    {
      bms = is + isLen + pdsLen + gdsLen;
      bmsLen = BMS_Len;

      imaskSize = (bmsLen > 6) ? (bmsLen - 6)<<3 : 0;
      bitmapSize = imaskSize - BMS_UnusedBits;
    }

  // ----------------------------------------------------------------
  // BDS Binary Data Section (Section 4)
  // ----------------------------------------------------------------
  UCHAR *bds = is + isLen + pdsLen + gdsLen + bmsLen;
  unsigned bdsLen = BDS_Len;
  /*
    If a very large product, the section 4 length field holds
    the number of bytes in the product after section 4 upto
    the end of the padding bytes.
    This is a fixup to get round the restriction on product lengths
    due to the count being only 24 bits. It is only possible because
    the (default) rounding for GRIB products is 120 bytes.
  */
  const bool llarge = (gribLen > JP23SET && bdsLen <= 120);
  if ( llarge )
    {
      gribLen &= JP23SET;
      gribLen *= 120;
      ISEC0_GRIB_Len = (int)gribLen;
      bdsLen = correct_bdslen(bdsLen, (int)gribLen, (long)(isLen+pdsLen+gdsLen+bmsLen));
    }

  TEMPLATE(decodeBDS,T)(ISEC1_DecScaleFactor, bds, isec2, isec4, fsec4, fsec4len, dfunc, bdsLen, numGridVals, iret);

  if ( *iret != 0 ) return;

  ISEC4_NumNonMissValues = ISEC4_NumValues;

  if ( bitmapSize > 0 )
    {
      if ( dfunc != 'L' && dfunc != 'J' )
	if ( DBL_IS_NAN(FSEC3_MissVal) && lmissvalinfo )
	  {
	    lmissvalinfo = false;
	    FSEC3_MissVal = (T)GRIB_MISSVAL;
	    Message("Missing value = NaN is unsupported, set to %g!", GRIB_MISSVAL);
	  }

      // ISEC4_NumNonMissValues = ISEC4_NumValues;
      ISEC4_NumValues = (int)bitmapSize;

      if ( dfunc != 'J' || bitmapSize == (size_t)ISEC4_NumNonMissValues )
	{
	  GRIBPACK bitmap;
	  /*
	  unsigned char *bitmap;
	  bitmap = BMS_Bitmap;
	  int j = ISEC4_NumNonMissValues;
	  for (int i = ISEC4_NumValues-1; i >= 0; --i)
	    {
	      fsec4[i] = ((bitmap[i/8]>>(7-(i&7)))&1) ? fsec4[--j] : FSEC3_MissVal;
	    }
	  */

	  GRIBPACK *imask = (GRIBPACK*) Malloc((size_t)imaskSize*sizeof(GRIBPACK));

#ifdef VECTORCODE
	  (void) UNPACK_GRIB(BMS_Bitmap, imask, imaskSize/8, -1L);
	  GRIBPACK *pbitmap = imask;
#else
	  GRIBPACK *pbitmap = BMS_Bitmap;
#endif

#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
	  for ( size_t i = imaskSize/8-1; i != (size_t)-1; --i )
	    {
	      bitmap = pbitmap[i];
	      imask[i*8+0] = 1 & (bitmap >> 7);
	      imask[i*8+1] = 1 & (bitmap >> 6);
	      imask[i*8+2] = 1 & (bitmap >> 5);
	      imask[i*8+3] = 1 & (bitmap >> 4);
	      imask[i*8+4] = 1 & (bitmap >> 3);
	      imask[i*8+5] = 1 & (bitmap >> 2);
	      imask[i*8+6] = 1 & (bitmap >> 1);
	      imask[i*8+7] = 1 & (bitmap);
	    }

	  int j = 0;
	  for (int i = 0; i < ISEC4_NumValues; ++i)
	    if ( imask[i] ) j++;

	  if ( ISEC4_NumNonMissValues != j )
	    {
	      if ( dfunc != 'J' && ISEC4_NumBits != 0 )
		Warning("Bitmap (%d) and data (%d) section differ, using bitmap section!", j, ISEC4_NumNonMissValues);

	      ISEC4_NumNonMissValues = j;
	    }

	  if ( dfunc != 'J' )
	    {
#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
	      for (int i = ISEC4_NumValues-1; i >= 0; --i)
		fsec4[i] = imask[i] ? fsec4[--j] : FSEC3_MissVal;
	    }

	  Free(imask);
	}
    }

  if ( ISEC2_Reduced )
    {
      int nvalues = 0;
      int nlat = ISEC2_NumLat;
      int nlon = ISEC2_ReducedPointsPtr[0];
      for (int ilat = 0; ilat < nlat; ++ilat) nvalues += ISEC2_ReducedPoints(ilat);
      for (int ilat = 1; ilat < nlat; ++ilat)
	if ( ISEC2_ReducedPoints(ilat) > nlon ) nlon = ISEC2_ReducedPoints(ilat);

      // int dlon = ISEC2_LastLon-ISEC2_FirstLon;
      // if ( dlon < 0 ) dlon += 360000;
	  
      if ( nvalues != ISEC4_NumValues ) *iret = -801;

      //printf("nlat %d  nlon %d \n", nlat, nlon);
      //printf("nvalues %d %d\n", nvalues, ISEC4_NumValues);

      if ( dfunc == 'R' && *iret == -801 )
	gprintf(__func__, "Number of values (%d) and sum of lons per row (%d) differ, abort conversion to regular Gaussian grid!",
		ISEC4_NumValues, nvalues);
      
      if ( dfunc == 'R' && *iret != -801 )
	{
	  ISEC2_Reduced = 0;
	  ISEC2_NumLon = nlon;
	  ISEC4_NumValues = nlon*nlat;

	  lsect3 = bitmapSize > 0;
          int lperio = 1;
	  int lveggy = (ISEC1_CodeTable == 128) && (ISEC1_CenterID == 98) && 
                      ((ISEC1_Parameter == 27) || (ISEC1_Parameter == 28) || 
                       (ISEC1_Parameter == 29) || (ISEC1_Parameter == 30) ||
                       (ISEC1_Parameter == 39) || (ISEC1_Parameter == 40) ||
                       (ISEC1_Parameter == 41) || (ISEC1_Parameter == 42) ||
                       (ISEC1_Parameter == 43));
	
	  (void) TEMPLATE(qu2reg3,T)(fsec4, ISEC2_ReducedPointsPtr, nlat, nlon, FSEC3_MissVal, iret, lsect3, lperio, lveggy);
	      
	  if ( bitmapSize > 0 )
	    {
	      int j = 0;	      
	      for (int i = 0; i < ISEC4_NumValues; ++i)
		if ( IS_NOT_EQUAL(fsec4[i], FSEC3_MissVal) ) j++;
		  
	      ISEC4_NumNonMissValues = j;
	    }
	}
    }

  if ( ISEC0_GRIB_Version == 1 ) isLen = 8;
  enum { esLen = 4 };
  gribLen = isLen + pdsLen + gdsLen + bmsLen + bdsLen + esLen;

  if ( !llarge && ISEC0_GRIB_Len && (size_t)ISEC0_GRIB_Len < gribLen )
    Warning("Inconsistent length of GRIB message (grib_message_size=%d < grib_record_size=%zu)!", ISEC0_GRIB_Len, gribLen);

  ISEC0_GRIB_Len = (int)gribLen;

  *kword = (int)((gribLen + sizeof(int) - 1) / sizeof(int));

  // ----------------------------------------------------------------
  // Section 9 . Abort/return to calling routine.
  // ----------------------------------------------------------------
  bool ldebug = false, l_iorj = false;
  if ( ldebug )
    {
      gprintf(__func__, "Section 9.");
      gprintf(__func__, "Output values set -");

      gribPrintSec0(isec0);
      gribPrintSec1(isec0, isec1);
      // Print section 2 if present.
      if ( lsect2 ) TEMPLATE(gribPrintSec2,T)(isec0, isec2, fsec2);

      if ( ! l_iorj )
	{
	  // Print section 3 if present.
	  if ( lsect3 ) TEMPLATE(gribPrintSec3,T)(isec0, isec3, fsec3);

	  TEMPLATE(gribPrintSec4,T)(isec0, isec4, fsec4);
	  // Special print for 2D spectra wave field real values in section 4
	  if ( (isec1[ 0] ==  140) && 
	       (isec1[ 1] ==   98) && 
	       (isec1[23] ==    1) && 
	       ((isec1[39] == 1045) || (isec1[39] == 1081))  && 
	       ((isec1[ 5] ==  250) || (isec1[ 5] ==  251)) )
	    gribPrintSec4Wave(isec4);
	}
    }
}

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * End:
 */

#ifdef T
#undef T
#endif
#define T float
#ifdef T

static
size_t TEMPLATE(decodeGDS,T)(unsigned char  *gds, int *isec0, int *isec2, T *fsec2, size_t *numGridVals)
{
  // int imisng = 0;
  bool ReducedGrid = false, VertCoorTab = false;
#ifdef VECTORCODE
  unsigned char *igrib;
  GRIBPACK *lgrib = NULL;
  size_t lGribLen = 0;
#endif

  *numGridVals = 0;

  memset(isec2, 0, 22*sizeof(int));

  const unsigned gdsLen = GDS_Len;

  unsigned ipvpl = GDS_PVPL;
  if ( ipvpl == 0 ) ipvpl = 0xFF;

  if ( ipvpl != 0xFF )
    { // Either vct or reduced grid
      if ( GDS_NV != 0 )
	{ // we have vct
	  VertCoorTab = true;
	  const unsigned ipl =  4*GDS_NV + ipvpl - 1;
	  if ( ipl < gdsLen ) ReducedGrid = true;
	}
      else
	{
	  VertCoorTab = false;
	  ReducedGrid = true;
	}
      // ReducedGrid = (gdsLen - 32 - 4*GDS_NV);
    }
 
  if ( ISEC0_GRIB_Version == 0 ) VertCoorTab = ((gdsLen - 32) > 0);
  
  if ( ReducedGrid )
    {
      const unsigned locnl = GDS_PVPL - 1U + (VertCoorTab * 4U * GDS_NV);
      const unsigned jlenl = (gdsLen - locnl)  >> 1;
      if ( jlenl == GDS_NumLat )
	{
	  ISEC2_Reduced = true;
          size_t accum = 0;
	  for ( size_t i = 0; i < jlenl; ++i )
	    {
              unsigned rpi = GET_UINT2(gds[locnl+2*i], gds[locnl+2*i+1]);
              ISEC2_ReducedPoints(i) = (int)rpi;
              accum += rpi;
	    }
          *numGridVals = accum;
	}
      else
	{
	  ReducedGrid = false;
	}
    }

  ISEC2_GridType = GDS_GridType;

  // Gaussian grid definition.

  if ( ISEC2_GridType == GRIB1_GTYPE_LATLON    ||
       ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN  ||
       ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
    {
      ISEC2_NumLat    = (int)(GDS_NumLat);
      if ( ! ReducedGrid )
	{
	  ISEC2_NumLon = (int)(GDS_NumLon);
	  *numGridVals  = (size_t)ISEC2_NumLon*(size_t)ISEC2_NumLat;
	}
      ISEC2_FirstLat  = GDS_FirstLat;
      ISEC2_FirstLon  = GDS_FirstLon;
      ISEC2_ResFlag   = GDS_ResFlag;
      ISEC2_LastLat   = GDS_LastLat;
      ISEC2_LastLon   = GDS_LastLon;
      ISEC2_LonIncr   = (int)(GDS_LonIncr);

      ISEC2_NumPar    = (int)GDS_NumPar;
      ISEC2_ScanFlag  = GDS_ScanFlag;
      if ( ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
	{
	  ISEC2_LatSP     = GDS_LatSP;
	  ISEC2_LonSP     = GDS_LonSP;
	  FSEC2_RotAngle  = (T)GDS_RotAngle;
	}
      // if ( Lons != Longitudes || Lats != Latitudes ) Error("Latitude/Longitude Conflict");
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN     ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN_ROT ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN_STR ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN_ROTSTR )
    {
      // iret = decodeGDS_GG(gds, gdspos, isec0, isec2, imisng);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LATLON     ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_STR ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_ROTSTR )
    {
      // iret = decodeGDS_LL(gds, gdspos, isec0, isec2, imisng);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LCC )
    {
      ISEC2_NumLon    = (int)(GDS_NumLon);
      ISEC2_NumLat    = (int)(GDS_NumLat);
      *numGridVals  = (size_t)ISEC2_NumLon*(size_t)ISEC2_NumLat;
      ISEC2_FirstLat  = GDS_FirstLat;
      ISEC2_FirstLon  = GDS_FirstLon;
      ISEC2_ResFlag   = GDS_ResFlag;
      ISEC2_Lambert_Lov   = GDS_Lambert_Lov;
      ISEC2_Lambert_dx    = GDS_Lambert_dx;
      ISEC2_Lambert_dy    = GDS_Lambert_dy;
      ISEC2_Lambert_LatS1 = GDS_Lambert_LatS1;
      ISEC2_Lambert_LatS2 = GDS_Lambert_LatS2;
      ISEC2_Lambert_LatSP = GDS_Lambert_LatSP;
      ISEC2_Lambert_LonSP = GDS_Lambert_LonSP;
      ISEC2_Lambert_ProjFlag = GDS_Lambert_ProjFlag;
      ISEC2_ScanFlag      = GDS_ScanFlag;
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_SPECTRAL )
    {
      ISEC2_PentaJ  = (int)(GDS_PentaJ); // Truncation
      ISEC2_PentaK  = (int)(GDS_PentaK);
      ISEC2_PentaM  = (int)(GDS_PentaM);
      ISEC2_RepType = GDS_RepType;
      ISEC2_RepMode = GDS_RepMode;
      *numGridVals  = ((size_t)ISEC2_PentaJ+1)*((size_t)ISEC2_PentaJ+2);
      isec2[ 6] = 0;
      isec2[ 7] = 0;
      isec2[ 8] = 0;
      isec2[ 9] = 0;
      isec2[10] = 0;
      // iret = decodeGDS_SH(gds, gdspos, isec0, isec2, imisng);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_GME )
    {
      ISEC2_GME_NI2    = (int)(GDS_GME_NI2);
      ISEC2_GME_NI3    = (int)(GDS_GME_NI3);
      ISEC2_GME_ND     = (int)(GDS_GME_ND);
      ISEC2_GME_NI     = (int)(GDS_GME_NI);
      ISEC2_GME_AFlag  = GDS_GME_AFlag;
      ISEC2_GME_LatPP  = GDS_GME_LatPP;
      ISEC2_GME_LonPP  = GDS_GME_LonPP;
      ISEC2_GME_LonMPL = GDS_GME_LonMPL;
      ISEC2_GME_BFlag  = GDS_GME_BFlag;
      *numGridVals  = ((size_t)ISEC2_GME_NI+1)*((size_t)ISEC2_GME_NI+1)*10;
      // iret = decodeGDS_TR(gds, gdspos, isec0, isec2, imisng);
    }
  else
    {
      static bool lwarn = true;
      unsigned nlon = GDS_NumLon, nlat = GDS_NumLat;
      ISEC2_NumLon = (int)nlon;
      ISEC2_NumLat = (int)nlat;
      *numGridVals  = (size_t)nlon*(size_t)nlat;
      if ( lwarn )
        {
          lwarn = false;
          Message("GRIB gridtype %d unsupported", ISEC2_GridType);
        }
    }

  // Vertical coordinate parameters for hybrid levels.
  // Get number of vertical coordinate parameters, if any.

  ISEC2_NumVCP = 0;

  isec2[17] = 0;
  isec2[18] = 0;

  if ( VertCoorTab )
    {
      int locnv;
      if ( ISEC0_GRIB_Version  == 0 )
	{
	  locnv = 32;
	  ISEC2_NumVCP = ((int)gdsLen - 32) >> 2;
	}
      else
	{
	  locnv = (int)GDS_PVPL - 1;
	  ISEC2_NumVCP = GDS_NV;
	}
#if defined (SX)
      lGribLen = 4*ISEC2_NumVCP;	      
      lgrib    = (GRIBPACK*) Malloc(lGribLen*sizeof(GRIBPACK));

      igrib = &gds[locnv];
      if ( ISEC2_NumVCP > 0 ) (void) UNPACK_GRIB(igrib, lgrib, lGribLen, -1L);
      for (int i = 0; i < ISEC2_NumVCP; ++i)
	{
	  const int iexp  = lgrib[4*i];
	  const int imant = GET_UINT3(lgrib[4*i+1], lgrib[4*i+2], lgrib[4*i+3]);
	  fsec2[10+i] = POW_2_M24 * imant * ldexp(1.0, 4 * (iexp - 64));
	}

      Free(lgrib);
#else
      for (int i = 0; i < ISEC2_NumVCP; ++i)
	{
	  const int iexp  = gds[locnv+4*i];
	  const int imant = (int)(GET_UINT3(gds[locnv+4*i+1], gds[locnv+4*i+2], gds[locnv+4*i+3]));
	  fsec2[10+i] = (T)decfp2(iexp,imant);
	}
#endif
    }

  return gdsLen;
}

#define ldexp_double ldexp
#define ldexp_float  ldexpf
#define pow_double pow
#define pow_float powf

static
void TEMPLATE(decodeBDS,T)(int decscale, unsigned char *bds, int *isec2, int *isec4, 
                           T *fsec4, int fsec4len, int dfunc, size_t bdsLen, size_t numGridVals, int *iret)
{
  size_t ioff = 0;
  enum { bds_head = 11 };
  T zscale = 0.;
  T fmin = 0.;
  T *fpdata = fsec4;

  *iret = 0;
  unsigned char *igrib = bds;

  memset(isec4, 0, 42*sizeof(int));

  // 4 bit flag / 4 bit count of unused bits at end of block octet.

  const int bds_flag = BDS_Flag;

  // 0------- grid point
  // 1------- spherical harmonics

  const bool lspherc = (bds_flag >> 7)&1;
  if ( lspherc ) isec4[2] = 128;
  else           isec4[2] = 0;

  // -0------  simple packing
  // -1------ complex packing

  const bool lcomplex = (bds_flag >> 6)&1;
  if ( lcomplex ) isec4[3] = 64;
  else            isec4[3] =  0;

  // ---0---- No additional flags
  // ---1---- No additional flags

  const bool lcompress = (bds_flag >> 4)&1;

  unsigned zoff;
  if ( lcompress )
    { isec4[5] = 16; isec4[6] = BDS_Z; zoff = 12; }
  else
    { isec4[5] =  0; isec4[6] = 0;     zoff =  0; }

  // ----++++ number of unused bits at end of section)

  const unsigned bds_ubits = bds_flag & 0xF;
  
  // scale factor (2 bytes)
  const int jscale = BDS_BinScale;

  // check for missing data indicators.

  const int iexp  = bds[ 6];
  const int imant = (int)(GET_UINT3(bds[ 7], bds[ 8], bds[ 9]));

  const int imiss = (jscale == 0xFFFF && iexp == 0xFF && imant == 0xFFFFFF);

  // convert reference value and scale factor.

  if ( ! (dfunc == 'J') && imiss == 0 )
    {
      fmin = (T)BDS_RefValue;
      zscale = TEMPLATE(ldexp,T)((T)1.0, jscale);
    }

  // get number of bits in each data value.

  unsigned dvbits = BDS_NumBits;
  ISEC4_NumBits = BDS_NumBits;

  // octet number of start of packed data calculated from start of block 4 - 1

  size_t locnd = zoff + bds_head;

  // if data is in spherical harmonic form, distinguish  between simple/complex packing (lcomplex = 0/1)

  if ( lspherc )
    {
      if ( !lcomplex )
	{
	  // no unpacked binary data present octet number of start of packed data
	  // calculated from start of block 4 - 1

	  ioff   = 1;
	  locnd += 4*ioff;  // RealCoef

	  // get real (0,0) coefficient in grib format and convert to floating point.
	  if ( dfunc != 'J' )
	    {
	      if ( imiss ) *fpdata++ = 0.0;
	      else         *fpdata++ = (T)BDS_RealCoef;
	    }
	}
      else // complex packed spherical harmonics
	{
	  isec4[15] = BDS_PackData;
	  // scaling factor
	  isec4[16] = BDS_Power;

	  // pentagonal resolution parameters of the unpacked section of data field

	  const int jup = bds[zoff+15];
	  const int kup = bds[zoff+16];
	  const int mup = bds[zoff+17];

	  isec4[zoff+17] = jup;
	  isec4[zoff+18] = kup;
	  isec4[zoff+19] = mup;

	  // unpacked binary data

	  locnd += 4; // 2 + power
	  locnd += 3; // j, k, m
	  ioff   = ((size_t)jup+1)*((size_t)jup+2);

	  if ( dfunc != 'J' )
	    for ( size_t i = 0; i < ioff; ++i )
	      {
		if ( imiss )
		  fpdata[i] = 0.0;
		else
		  {
		    const int iexp2  = (int)(bds[locnd+4*i]);
		    const int imant2 = (int)(GET_UINT3(bds[locnd+4*i+1], bds[locnd+4*i+2], bds[locnd+4*i+3]));
		    fpdata[i] = (T)decfp2(iexp2,imant2);
		  }
	      }
          fpdata += ioff;
	  locnd += 4*ioff;  /* RealCoef */
	}
    }
  else
    {
      if ( lcomplex )
	{
	  *iret = 1999;
	  gprintf(__func__, " Second order packed grids unsupported!");
	  gprintf(__func__, " Return code =  %d", *iret);
	  return;
	}
    }

  // Decode data values to floating point and store in fsec4.
  // First calculate the number of data values.
  // Take into account that spherical harmonics can be packed
  // simple (lcomplex = 0) or complex (lcomplex = 1)

  size_t jlend = bdsLen - locnd;

  if ( dvbits == 0 )
    {
      if ( jlend > 1 )
	{
	  *iret = 2001;
	  gprintf(__func__, " Number of bits per data value = 0!");
	  gprintf(__func__, " Return code =  %d", *iret);
	  return;
	}

      if ( numGridVals == 0 )
	{
	  *iret = 2002;
	  gprintf(__func__, " Constant field unsupported for this grid type!");
	  gprintf(__func__, " Return code =  %d", *iret);
	  return;
	}

      jlend = numGridVals - ioff;
    }
  else
    {
      jlend = (jlend*8 - bds_ubits) / dvbits;
    }

  ISEC4_NumValues        = (int)(jlend + ioff);
  ISEC4_NumNonMissValues = 0;

  if ( lcompress )
    {
      const size_t len = ((size_t) ((bds[17]<<16)+(bds[18]<<8)+bds[19]));

      ISEC4_NumValues = (int)(len*8/dvbits);

      if ( lspherc ) ISEC4_NumValues += lcomplex ? (int)ioff : 1;
    }

  if ( dfunc == 'J' ) return;

  // check length of output array.
  
  if ( ISEC4_NumValues > fsec4len )
    {
      *iret = 710;
      gprintf(__func__, " Output array too small. Length = %d", fsec4len);
      gprintf(__func__, " Number of values = %d", ISEC4_NumValues);
      gprintf(__func__, " Return code =  %d", *iret);
      return;
    }

  if ( imiss ) memset((char *)fpdata, 0, jlend*sizeof(T));
  else
    {
      igrib += locnd;

      TEMPLATE(decode_array,T)(igrib, (long)jlend, ISEC4_NumBits, fmin, zscale, fpdata);
    }

  if ( lspherc && lcomplex )
    {
      int pcStart = isec4[19], pcScale = isec4[16];
      TEMPLATE(scatter_complex,T)(fsec4, pcStart, ISEC2_PentaJ, ISEC4_NumValues);
      TEMPLATE(scale_complex,T)(fsec4, pcStart, pcScale, ISEC2_PentaJ, 1);
    }

  if ( CGRIBEX_Fix_ZSE )  // Fix ZeroShiftError of simple packed spherical harmonics
    if ( lspherc && !lcomplex )
      {
        // 20100705: Fix ZeroShiftError - Edi Kirk
	if ( IS_NOT_EQUAL(fsec4[1], 0.0) )
	  {
	    const T zserr = fsec4[1];
	    for (int i = 1; i < ISEC4_NumValues; ++i) fsec4[i] -= zserr;
	  }
      }

  if ( decscale )
    {
      const T scale = TEMPLATE(pow,T)((T)10.0, (T)-decscale);
      for (int i = 0; i < ISEC4_NumValues; ++i) fsec4[i] *= scale;
    }
}


void TEMPLATE(grib_decode,T)(int *isec0, int *isec1, int *isec2, T *fsec2, int *isec3,
			     T *fsec3, int *isec4, T *fsec4, int fsec4len, int *kgrib,
			     int kleng, int *kword, int dfunc, int *iret)
{
  UCHAR *bms = NULL;
  bool lsect2 = false, lsect3 = false;
  static bool lmissvalinfo = true;

  UNUSED(kleng);

  *iret = 0;

  grsdef();

  ISEC2_Reduced = false;

  // ----------------------------------------------------------------
  // IS Indicator Section (Section 0)
  // ----------------------------------------------------------------
  UCHAR *is = (UCHAR *) &kgrib[0];
  size_t isLen = decodeIS(is, isec0, iret);

  size_t gribLen = (size_t)ISEC0_GRIB_Len;

  /*
    When decoding or calculating length, previous editions
    of the GRIB code must be taken into account.

    In the table below, covering sections 0 and 1 of the GRIB
    code, octet numbering is from the beginning of the GRIB
    message;
    * indicates that the value is not available in the code edition;
    R indicates reserved, should be set to 0;
    Experimental edition is considered as edition -1.

    GRIB code edition -1 has fixed length of 20 octets for
    section 1, the length not included in the message.
    GRIB code edition 0 has fixed length of 24 octets for
    section 1, the length being included in the message.
    GRIB code edition 1 can have different lengths for section
    1, the minimum being 28 octets, length being included in
    the message.

                                         Octet numbers for code
                                                  editions

                 Contents.                   -1      0      1
                 ---------                ----------------------
       Letters GRIB                          1-4    1-4    1-4
       Total length of GRIB message.          *      *     5-7
       GRIB code edition number               *      *      8
       Length of Section 1.                   *     5-7    9-11
       Reserved octet (R).                    *      8(R)   *
       Version no. of Code Table 2.           *      *     12
       Identification of centre.              5      9     13
       Generating process.                    6     10     14
       Grid definition .                      7     11     15
       Flag (Code Table 1).                   8     12     16
       Indicator of parameter.                9     13     17
       Indicator of type of level.           10     14     18
       Height, pressure etc of levels.      11-12  15-16  19-20
       Year of century.                      13     17     21
       Month.                                14     18     22
       Day.                                  15     19     23
       Hour.                                 16     20     24
       Minute.                               17     21     25
       Indicator of unit of time.            18     22     26
       P1 - Period of time.                  19     23     27
       P2 - Period of time                  20(R)   24     28
       or reserved octet (R).
       Time range indicator.                21(R)   25     29
       or reserved octet (R).
       Number included in average.       22-23(R)  26-27  30-31
       or reserved octet (R).
       Number missing from average.         24(R)  28(R)   32
       or reserved octet (R).
       Century of data.                       *      *     33
       Designates sub-centre if not 0.        *      *     34
       Decimal scale factor.                  *      *    35-36
       Reserved. Set to 0.                    *      *    37-48
       (Need not be present)
       For originating centre use only.       *      *    49-nn
       (Need not be present)

    Identify which GRIB code edition is being decoded.

    In GRIB edition 1, the edition number is in octet 8.
    In GRIB edition 0, octet 8 is reserved and set to 0.
    In GRIB edition -1, octet 8 is a flag field and can have a
    a valid value of 0, 1, 2 or 3.

    However, GRIB edition number 0 has a fixed
    length of 24, included in the message, for section 1, so
    if the value extracted from octets 5-7 is 24 and that from
    octet 8 is 0, it is safe to assume edition 0 of the code.

  */

  // Set length of GRIB message to missing data value.
  if ( ISEC0_GRIB_Len == 24 && ISEC0_GRIB_Version == 0 ) ISEC0_GRIB_Len = 0;

  // ----------------------------------------------------------------
  // PDS Product Definition Section (Section 1)
  // ----------------------------------------------------------------
  UCHAR *pds = is + isLen;
  size_t pdsLen = decodePDS(pds, isec0, isec1);

  // ----------------------------------------------------------------
  // GDS Grid Description Section (Section 2)
  // ----------------------------------------------------------------
  size_t numGridVals = 0;
  size_t gdsLen = 0;
  const bool gdsIncluded = ISEC1_Sec2Or3Flag & 128;
  if ( gdsIncluded )
    {
      UCHAR *gds = is + isLen + pdsLen;
      gdsLen = TEMPLATE(decodeGDS,T)(gds, isec0, isec2, fsec2, &numGridVals);
    }

  // ----------------------------------------------------------------
  // BMS Bit-Map Section Section (Section 3)
  // ----------------------------------------------------------------
  isec3[0] = 0;
  size_t bmsLen = 0, bitmapSize = 0, imaskSize = 0;
  const bool bmsIncluded = ISEC1_Sec2Or3Flag & 64;
  if ( bmsIncluded )
    {
      bms = is + isLen + pdsLen + gdsLen;
      bmsLen = BMS_Len;

      imaskSize = (bmsLen > 6) ? (bmsLen - 6)<<3 : 0;
      bitmapSize = imaskSize - BMS_UnusedBits;
    }

  // ----------------------------------------------------------------
  // BDS Binary Data Section (Section 4)
  // ----------------------------------------------------------------
  UCHAR *bds = is + isLen + pdsLen + gdsLen + bmsLen;
  unsigned bdsLen = BDS_Len;
  /*
    If a very large product, the section 4 length field holds
    the number of bytes in the product after section 4 upto
    the end of the padding bytes.
    This is a fixup to get round the restriction on product lengths
    due to the count being only 24 bits. It is only possible because
    the (default) rounding for GRIB products is 120 bytes.
  */
  const bool llarge = (gribLen > JP23SET && bdsLen <= 120);
  if ( llarge )
    {
      gribLen &= JP23SET;
      gribLen *= 120;
      ISEC0_GRIB_Len = (int)gribLen;
      bdsLen = correct_bdslen(bdsLen, (int)gribLen, (long)(isLen+pdsLen+gdsLen+bmsLen));
    }

  TEMPLATE(decodeBDS,T)(ISEC1_DecScaleFactor, bds, isec2, isec4, fsec4, fsec4len, dfunc, bdsLen, numGridVals, iret);

  if ( *iret != 0 ) return;

  ISEC4_NumNonMissValues = ISEC4_NumValues;

  if ( bitmapSize > 0 )
    {
      if ( dfunc != 'L' && dfunc != 'J' )
	if ( DBL_IS_NAN(FSEC3_MissVal) && lmissvalinfo )
	  {
	    lmissvalinfo = false;
	    FSEC3_MissVal = (T)GRIB_MISSVAL;
	    Message("Missing value = NaN is unsupported, set to %g!", GRIB_MISSVAL);
	  }

      // ISEC4_NumNonMissValues = ISEC4_NumValues;
      ISEC4_NumValues = (int)bitmapSize;

      if ( dfunc != 'J' || bitmapSize == (size_t)ISEC4_NumNonMissValues )
	{
	  GRIBPACK bitmap;
	  /*
	  unsigned char *bitmap;
	  bitmap = BMS_Bitmap;
	  int j = ISEC4_NumNonMissValues;
	  for (int i = ISEC4_NumValues-1; i >= 0; --i)
	    {
	      fsec4[i] = ((bitmap[i/8]>>(7-(i&7)))&1) ? fsec4[--j] : FSEC3_MissVal;
	    }
	  */

	  GRIBPACK *imask = (GRIBPACK*) Malloc((size_t)imaskSize*sizeof(GRIBPACK));

#ifdef VECTORCODE
	  (void) UNPACK_GRIB(BMS_Bitmap, imask, imaskSize/8, -1L);
	  GRIBPACK *pbitmap = imask;
#else
	  GRIBPACK *pbitmap = BMS_Bitmap;
#endif

#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
	  for ( size_t i = imaskSize/8-1; i != (size_t)-1; --i )
	    {
	      bitmap = pbitmap[i];
	      imask[i*8+0] = 1 & (bitmap >> 7);
	      imask[i*8+1] = 1 & (bitmap >> 6);
	      imask[i*8+2] = 1 & (bitmap >> 5);
	      imask[i*8+3] = 1 & (bitmap >> 4);
	      imask[i*8+4] = 1 & (bitmap >> 3);
	      imask[i*8+5] = 1 & (bitmap >> 2);
	      imask[i*8+6] = 1 & (bitmap >> 1);
	      imask[i*8+7] = 1 & (bitmap);
	    }

	  int j = 0;
	  for (int i = 0; i < ISEC4_NumValues; ++i)
	    if ( imask[i] ) j++;

	  if ( ISEC4_NumNonMissValues != j )
	    {
	      if ( dfunc != 'J' && ISEC4_NumBits != 0 )
		Warning("Bitmap (%d) and data (%d) section differ, using bitmap section!", j, ISEC4_NumNonMissValues);

	      ISEC4_NumNonMissValues = j;
	    }

	  if ( dfunc != 'J' )
	    {
#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
	      for (int i = ISEC4_NumValues-1; i >= 0; --i)
		fsec4[i] = imask[i] ? fsec4[--j] : FSEC3_MissVal;
	    }

	  Free(imask);
	}
    }

  if ( ISEC2_Reduced )
    {
      int nvalues = 0;
      int nlat = ISEC2_NumLat;
      int nlon = ISEC2_ReducedPointsPtr[0];
      for (int ilat = 0; ilat < nlat; ++ilat) nvalues += ISEC2_ReducedPoints(ilat);
      for (int ilat = 1; ilat < nlat; ++ilat)
	if ( ISEC2_ReducedPoints(ilat) > nlon ) nlon = ISEC2_ReducedPoints(ilat);

      // int dlon = ISEC2_LastLon-ISEC2_FirstLon;
      // if ( dlon < 0 ) dlon += 360000;
	  
      if ( nvalues != ISEC4_NumValues ) *iret = -801;

      //printf("nlat %d  nlon %d \n", nlat, nlon);
      //printf("nvalues %d %d\n", nvalues, ISEC4_NumValues);

      if ( dfunc == 'R' && *iret == -801 )
	gprintf(__func__, "Number of values (%d) and sum of lons per row (%d) differ, abort conversion to regular Gaussian grid!",
		ISEC4_NumValues, nvalues);
      
      if ( dfunc == 'R' && *iret != -801 )
	{
	  ISEC2_Reduced = 0;
	  ISEC2_NumLon = nlon;
	  ISEC4_NumValues = nlon*nlat;

	  lsect3 = bitmapSize > 0;
          int lperio = 1;
	  int lveggy = (ISEC1_CodeTable == 128) && (ISEC1_CenterID == 98) && 
                      ((ISEC1_Parameter == 27) || (ISEC1_Parameter == 28) || 
                       (ISEC1_Parameter == 29) || (ISEC1_Parameter == 30) ||
                       (ISEC1_Parameter == 39) || (ISEC1_Parameter == 40) ||
                       (ISEC1_Parameter == 41) || (ISEC1_Parameter == 42) ||
                       (ISEC1_Parameter == 43));
	
	  (void) TEMPLATE(qu2reg3,T)(fsec4, ISEC2_ReducedPointsPtr, nlat, nlon, FSEC3_MissVal, iret, lsect3, lperio, lveggy);
	      
	  if ( bitmapSize > 0 )
	    {
	      int j = 0;	      
	      for (int i = 0; i < ISEC4_NumValues; ++i)
		if ( IS_NOT_EQUAL(fsec4[i], FSEC3_MissVal) ) j++;
		  
	      ISEC4_NumNonMissValues = j;
	    }
	}
    }

  if ( ISEC0_GRIB_Version == 1 ) isLen = 8;
  enum { esLen = 4 };
  gribLen = isLen + pdsLen + gdsLen + bmsLen + bdsLen + esLen;

  if ( !llarge && ISEC0_GRIB_Len && (size_t)ISEC0_GRIB_Len < gribLen )
    Warning("Inconsistent length of GRIB message (grib_message_size=%d < grib_record_size=%zu)!", ISEC0_GRIB_Len, gribLen);

  ISEC0_GRIB_Len = (int)gribLen;

  *kword = (int)((gribLen + sizeof(int) - 1) / sizeof(int));

  // ----------------------------------------------------------------
  // Section 9 . Abort/return to calling routine.
  // ----------------------------------------------------------------
  bool ldebug = false, l_iorj = false;
  if ( ldebug )
    {
      gprintf(__func__, "Section 9.");
      gprintf(__func__, "Output values set -");

      gribPrintSec0(isec0);
      gribPrintSec1(isec0, isec1);
      // Print section 2 if present.
      if ( lsect2 ) TEMPLATE(gribPrintSec2,T)(isec0, isec2, fsec2);

      if ( ! l_iorj )
	{
	  // Print section 3 if present.
	  if ( lsect3 ) TEMPLATE(gribPrintSec3,T)(isec0, isec3, fsec3);

	  TEMPLATE(gribPrintSec4,T)(isec0, isec4, fsec4);
	  // Special print for 2D spectra wave field real values in section 4
	  if ( (isec1[ 0] ==  140) && 
	       (isec1[ 1] ==   98) && 
	       (isec1[23] ==    1) && 
	       ((isec1[39] == 1045) || (isec1[39] == 1081))  && 
	       ((isec1[ 5] ==  250) || (isec1[ 5] ==  251)) )
	    gribPrintSec4Wave(isec4);
	}
    }
}

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * End:
 */
// clang-format on

// GRIB block 0 - indicator block
static void
encodeIS(GRIBPACK *lGrib, long *gribLen)
{
  long z;
  // z = *gribLen;

  lGrib[0] = 'G';
  lGrib[1] = 'R';
  lGrib[2] = 'I';
  lGrib[3] = 'B';

  // lGrib[4]-lGrib[6] contains full length of grib record.
  // included before finished CODEGB

  z = 7;
  Put1Byte(1);  // grib version
  z = 8;

  *gribLen = z;
}

// GRIB block 5 - end block
static void
encodeES(GRIBPACK *lGrib, long *gribLen, long bdsstart)
{
  long z = *gribLen;

  lGrib[z++] = '7';
  lGrib[z++] = '7';
  lGrib[z++] = '7';
  lGrib[z++] = '7';

  if (z > JP24SET)
  {
    long bdslen = z - 4;
    // fprintf(stderr, "Abort: GRIB record too large (max = %d)!\n", JP23SET);
    // exit(1);
    /*
      If a very large product, the section 4 length field holds
      the number of bytes in the product after section 4 upto
      the end of the padding bytes.
      This is a fixup to get round the restriction on product lengths
      due to the count being only 24 bits. It is only possible because
      the (default) rounding for GRIB products is 120 bytes.
    */
    while (z % 120) lGrib[z++] = 0;

    if (z > JP23SET * 120)
    {
      fprintf(stderr, "Abort: GRIB1 record too large (size = %ld; max = %d)!\n", z, JP23SET * 120);
      exit(1);
    }

    long itemp = z / (-120);
    itemp = JP23SET - itemp + 1;

    lGrib[4] = (GRIBPACK) (itemp >> 16);
    lGrib[5] = (GRIBPACK) (itemp >> 8);
    lGrib[6] = (GRIBPACK) itemp;

    bdslen = z - bdslen;
    lGrib[bdsstart] = (GRIBPACK) (bdslen >> 16);
    lGrib[bdsstart + 1] = (GRIBPACK) (bdslen >> 8);
    lGrib[bdsstart + 2] = (GRIBPACK) bdslen;
  }
  else
  {
    lGrib[4] = (GRIBPACK) (z >> 16);
    lGrib[5] = (GRIBPACK) (z >> 8);
    lGrib[6] = (GRIBPACK) z;

    while (z % 8) lGrib[z++] = 0;
  }

  *gribLen = z;
}

// GRIB block 1 - product definition block.

#define DWD_extension_253_len 38
#define DWD_extension_254_len 26
#define ECMWF_extension_1_len 24
#define MPIM_extension_1_len 18

static long
getLocalExtLen(int *isec1)
{
  long extlen = 0;

  if (ISEC1_LocalFLag)
  {
    if (ISEC1_CenterID == 78 || ISEC1_CenterID == 215 || ISEC1_CenterID == 250)
    {
      if (isec1[36] == 254)
        extlen = DWD_extension_254_len;
      else if (isec1[36] == 253)
        extlen = DWD_extension_253_len;
    }
    else if (ISEC1_CenterID == 98)
    {
      if (isec1[36] == 1) extlen = ECMWF_extension_1_len;
    }
    else if (ISEC1_CenterID == 252)
    {
      if (isec1[36] == 1) extlen = MPIM_extension_1_len;
    }
  }

  return extlen;
}

static long
getPdsLen(int *isec1)
{
  long pdslen = 28;

  pdslen += getLocalExtLen(isec1);

  return pdslen;
}

static void
encodePDS_DWD_local_Extension_254(GRIBPACK *lGrib, long *zs, int *isec1)
{
  long z = *zs;

  const long localextlen = getLocalExtLen(isec1);
  for (long i = 0; i < localextlen - 2; i++) Put1Byte(isec1[24 + i]);

  int isvn = isec1[49] << 15 | isec1[48];  // DWD experiment identifier
  Put2Byte(isvn);                          // DWD run type (0=main, 2=ass, 3=test)

  *zs = z;
}

static void
encodePDS_DWD_local_Extension_253(GRIBPACK *lGrib, long *zs, int *isec1)
{
  long z = *zs;

  const long localextlen = DWD_extension_254_len;
  for (long i = 0; i < localextlen - 2; i++) Put1Byte(isec1[24 + i]);

  int isvn = isec1[49] << 15 | isec1[48]; /* DWD experiment identifier    */
  Put2Byte(isvn);                         /* DWD run type (0=main, 2=ass, 3=test) */
  Put1Byte(isec1[50]);                    /* 55 User id, specified by table       */
  Put2Byte(isec1[51]);                    /* 56 Experiment identifier             */
  Put2Byte(isec1[52]);                    /* 58 Ensemble identification by table  */
  Put2Byte(isec1[53]);                    /* 60 Number of ensemble members        */
  Put2Byte(isec1[54]);                    /* 62 Actual number of ensemble member  */
  Put1Byte(isec1[55]);                    /* 64 Model major version number        */
  Put1Byte(isec1[56]);                    /* 65 Model minor version number        */
  Put1Byte(0);                            /* 66 Blank for even buffer length      */

  *zs = z;
}

static void
encodePDS_ECMWF_local_Extension_1(GRIBPACK *lGrib, long *zs, int *isec1)
{
  long z = *zs;

  const long localextlen = getLocalExtLen(isec1);
  for (long i = 0; i < localextlen - 12; i++) Put1Byte(isec1[24 + i]);
  /* 12 bytes explicitly encoded below:         */
  Put1Byte(isec1[36]); /* ECMWF local GRIB use definition identifier */
                       /*    1=MARS labelling or ensemble fcst. data */
  Put1Byte(isec1[37]); /* Class                                      */
  Put1Byte(isec1[38]); /* Type                                       */
  Put2Byte(isec1[39]); /* Stream                                     */

  // Version number or experiment identifier
  Put1Byte(((unsigned char *) &isec1[40])[0]);
  Put1Byte(((unsigned char *) &isec1[40])[1]);
  Put1Byte(((unsigned char *) &isec1[40])[2]);
  Put1Byte(((unsigned char *) &isec1[40])[3]);

  Put1Byte(isec1[41]); /* Ensemble forecast number                   */
  Put1Byte(isec1[42]); /* Total number of forecasts in ensemble      */
  Put1Byte(0);         /* (Spare)                                    */

  *zs = z;
}

static void
encodePDS_MPIM_local_Extension_1(GRIBPACK *lGrib, long *zs, int *isec1)
{
  long z = *zs;

  const long localextlen = getLocalExtLen(isec1);
  for (long i = 0; i < localextlen - 6; i++) Put1Byte(isec1[24 + i]);
  /* 6 bytes explicitly encoded below:          */
  Put1Byte(isec1[36]); /* MPIM local GRIB use definition identifier  */
                       /*    (extension identifier)                  */
  Put1Byte(isec1[37]); /* type of ensemble forecast                  */
  Put2Byte(isec1[38]); /* individual ensemble member                 */
  Put2Byte(isec1[39]); /* number of forecasts in ensemble            */

  *zs = z;
}

// GRIB BLOCK 1 - PRODUCT DESCRIPTION SECTION
static void
encodePDS(GRIBPACK *lpds, long pdsLen, int *isec1)
{
  GRIBPACK *lGrib = lpds;
  long z = 0;
  int ival;

  int century = ISEC1_Century;
  int year = ISEC1_Year;

  if (century < 0)
  {
    century = -century;
    year = -year;
  }

  Put3Byte(pdsLen);               /*  0 Length of Block 1        */
  Put1Byte(ISEC1_CodeTable);      /*  3 Local table number       */
  Put1Byte(ISEC1_CenterID);       /*  4 Identification of centre */
  Put1Byte(ISEC1_ModelID);        /*  5 Identification of model  */
  Put1Byte(ISEC1_GridDefinition); /*  6 Grid definition          */
  Put1Byte(ISEC1_Sec2Or3Flag);    /*  7 Block 2 included         */
  Put1Byte(ISEC1_Parameter);      /*  8 Parameter Code           */
  Put1Byte(ISEC1_LevelType);      /*  9 Type of level            */
  // clang-format off
  if ( (ISEC1_LevelType !=  20) &&
       (ISEC1_LevelType != GRIB1_LTYPE_99)           &&
       (ISEC1_LevelType != GRIB1_LTYPE_ISOBARIC)     &&
       (ISEC1_LevelType != GRIB1_LTYPE_ISOBARIC_PA)  &&
       (ISEC1_LevelType != GRIB1_LTYPE_ALTITUDE)     &&
       (ISEC1_LevelType != GRIB1_LTYPE_HEIGHT)       &&
       (ISEC1_LevelType != GRIB1_LTYPE_SIGMA)        &&
       (ISEC1_LevelType != GRIB1_LTYPE_HYBRID)       &&
       (ISEC1_LevelType != GRIB1_LTYPE_LANDDEPTH)    &&
       (ISEC1_LevelType != GRIB1_LTYPE_ISENTROPIC)   &&
       (ISEC1_LevelType != 115) &&
       (ISEC1_LevelType != 117) &&
       (ISEC1_LevelType != 125) &&
       (ISEC1_LevelType != 127) &&
       (ISEC1_LevelType != 160) &&
       (ISEC1_LevelType != 210) )
    {
      Put1Byte(ISEC1_Level1);
      Put1Byte(ISEC1_Level2);
    }
  else
    {
      Put2Byte(ISEC1_Level1);     /* 10 Level                    */    
    }
  // clang-format on

  Put1Int(year);          /* 12 Year of Century          */
  Put1Byte(ISEC1_Month);  /* 13 Month                    */
  Put1Byte(ISEC1_Day);    /* 14 Day                      */
  Put1Byte(ISEC1_Hour);   /* 15 Hour                     */
  Put1Byte(ISEC1_Minute); /* 16 Minute                   */

  Put1Byte(ISEC1_TimeUnit); /* 17 Time unit                */
  if (ISEC1_TimeRange == 10)
  {
    Put1Byte(ISEC1_TimePeriod1);
    Put1Byte(ISEC1_TimePeriod2);
  }
  else if (ISEC1_TimeRange == 113 || ISEC1_TimeRange == 0)
  {
    Put1Byte(ISEC1_TimePeriod1);
    Put1Byte(0);
  }
  else if (ISEC1_TimeRange == 5 || ISEC1_TimeRange == 4 || ISEC1_TimeRange == 3 || ISEC1_TimeRange == 2)
  {
    Put1Byte(ISEC1_TimePeriod1);
    Put1Byte(ISEC1_TimePeriod2);
  }
  else
  {
    Put1Byte(0);
    Put1Byte(0);
  }
  Put1Byte(ISEC1_TimeRange); /* 20 Timerange flag           */
  Put2Byte(ISEC1_AvgNum);    /* 21 Average                  */

  Put1Byte(ISEC1_AvgMiss);       /* 23 Missing from averages    */
  Put1Byte(century);             /* 24 Century                  */
  Put1Byte(ISEC1_SubCenterID);   /* 25 Subcenter                */
  Put2Int(ISEC1_DecScaleFactor); /* 26 Decimal scale factor     */

  if (ISEC1_LocalFLag)
  {
    if (ISEC1_CenterID == 78 || ISEC1_CenterID == 215 || ISEC1_CenterID == 250)
    {
      if (isec1[36] == 254)
        encodePDS_DWD_local_Extension_254(lGrib, &z, isec1);
      else if (isec1[36] == 253)
        encodePDS_DWD_local_Extension_253(lGrib, &z, isec1);
    }
    else if (ISEC1_CenterID == 98)
    {
      if (isec1[36] == 1) encodePDS_ECMWF_local_Extension_1(lGrib, &z, isec1);
    }
    else if (ISEC1_CenterID == 252)
    {
      if (isec1[36] == 1) encodePDS_MPIM_local_Extension_1(lGrib, &z, isec1);
    }
    else
    {
      const long localextlen = getLocalExtLen(isec1);
      for (long i = 0; i < localextlen; i++) Put1Byte(isec1[24 + i]);
    }
  }
}

// clang-format off


#ifdef T
#undef T
#endif
#define T double
#ifdef T


#define CGRIBEX_FPSCALE(data) (((data) - zref) * factor + 0.5)

static
void TEMPLATE(encode_array_common,T)(int numBits, size_t packStart, size_t datasize, GRIBPACK *lGrib,
				     const T *data, T zref, T factor, size_t *gz)
{
  size_t z = *gz;
  unsigned int ival;
  int cbits, jbits;
  unsigned int c;

  // code from gribw routine flist2bitstream

  cbits = 8;
  c = 0;
  for (size_t i = packStart; i < datasize; ++i)
    {
      // note float -> unsigned int .. truncate
      ival = (unsigned int)(CGRIBEX_FPSCALE(data[i]));
      /*
	if ( ival > max_nbpv_pow2 ) ival = max_nbpv_pow2;
	if ( ival < 0 ) ival = 0;
      */
      jbits = numBits;
      while ( cbits <= jbits ) 
	{
	  if ( cbits == 8 )
	    {
	      jbits -= 8;
	      lGrib[z++] = (ival >> jbits) & 0xFF;
	    }
	  else
	    {
	      jbits -= cbits;
	      lGrib[z++] = (GRIBPACK)((c << cbits)
                                      + ((ival >> jbits) & ((1U << cbits) - 1)));
	      cbits = 8;
	      c = 0;
	    }
	}
      /* now jbits < cbits */
      if ( jbits )
	{
	  c = (c << jbits) + (ival & ((1U << jbits)-1));
	  cbits -= jbits;
	}
    }
  if ( cbits != 8 ) lGrib[z++] = (GRIBPACK)(c << cbits);

  *gz = z;
}


static
void TEMPLATE(encode_array_2byte,T)(size_t datasize, GRIBPACK *restrict lGrib,
				    const T *restrict data, T zref, T factor, size_t *gz)
{
  uint16_t *restrict sgrib = (uint16_t *)(void *)(lGrib+*gz);

  if (IS_BIGENDIAN())
    {
      for (size_t i = 0; i < datasize; ++i)
        sgrib[i] = (uint16_t) CGRIBEX_FPSCALE(data[i]);
    }
  else
    {
      for (size_t i = 0; i < datasize; ++i)
        {
          uint16_t ui16 = (uint16_t) CGRIBEX_FPSCALE(data[i]);
          sgrib[i] = gribSwapByteOrder_uint16(ui16);
        }
    }

  *gz += 2*datasize;
}

static
void TEMPLATE(encode_array,T)(int numBits, size_t packStart, size_t datasize, 
			      GRIBPACK *restrict lGrib,
			      const T *restrict data, 
			      T zref, T factor, size_t *gz)
{
  size_t z = *gz;

  data += packStart;
  datasize -= packStart;

  if (numBits ==  8)
    {
      for (size_t i = 0; i < datasize; ++i)
	{
	  lGrib[z++] = (GRIBPACK) CGRIBEX_FPSCALE(data[i]);
	}
    }
  else if (numBits == 16)
    {
      if (sizeof(T) == sizeof(double))
      	{
          grib_encode_array_2byte_double(datasize, lGrib, (const double *)(const void *)data, zref, factor, &z);
        }
      else
        {
          TEMPLATE(encode_array_2byte,T)(datasize, lGrib, data, zref, factor, &z);
        }
    }
  else if (numBits == 24)
    {
      for (size_t i = 0; i < datasize; ++i)
	{
          uint32_t ui32 = (uint32_t) CGRIBEX_FPSCALE(data[i]);
          lGrib[z++] = (GRIBPACK)(ui32 >> 16);
          lGrib[z++] = (GRIBPACK)(ui32 >>  8);
          lGrib[z++] = (GRIBPACK)ui32;
	}
    }
  else if (numBits == 32)
    {
      for (size_t i = 0; i < datasize; ++i)
	{
          uint32_t ui32 = (uint32_t) CGRIBEX_FPSCALE(data[i]);
          lGrib[z++] = (GRIBPACK)(ui32 >> 24);
          lGrib[z++] = (GRIBPACK)(ui32 >> 16);
          lGrib[z++] = (GRIBPACK)(ui32 >>  8);
          lGrib[z++] = (GRIBPACK)ui32;
	}
    }
  else if (numBits > 0 && numBits <= 32)
    {
      TEMPLATE(encode_array_common,T)(numBits, 0, datasize, lGrib, data, zref, factor, &z);
    }
  else if (numBits == 0)
    {
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }

  *gz = z;
}

static
void TEMPLATE(encode_array_unrolled,T)(int numBits, size_t packStart, size_t datasize, 
				       GRIBPACK *restrict lGrib,
				       const T *restrict data, 
				       T zref, T factor, size_t *gz)
{
  size_t z = *gz;
#ifdef _ARCH_PWR6
  enum { CGRIBEX__UNROLL_DEPTH_2 = 8 };
#else
  enum { CGRIBEX__UNROLL_DEPTH_2 = 128 };
#endif
  size_t residual;
  size_t ofs;
  double dval[CGRIBEX__UNROLL_DEPTH_2];

  data += packStart;
  datasize -= packStart;
  residual =  datasize % CGRIBEX__UNROLL_DEPTH_2;
  ofs = datasize - residual;

  // reducing FP operations to single FMA is slowing down on pwr6 ...

  if      ( numBits ==  8 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(2, "pack 8 bit unrolled");
#endif
      unsigned char *cgrib = (unsigned char *) (lGrib + z);
      size_t i;
      for (i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
	{
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
	      dval[j] = CGRIBEX_FPSCALE(data[i+j]);
	    }
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
#ifdef _ARCH_PWR6
	      *cgrib++ =  (unsigned long) dval[j];
#else
	      *cgrib++ =  (unsigned char) dval[j];
#endif
	    }
	  z += CGRIBEX__UNROLL_DEPTH_2;
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  dval[j] = CGRIBEX_FPSCALE(data[i+j]);
	}
      for (size_t j = 0; j < residual; ++j) 
	{
#ifdef _ARCH_PWR6
	  *cgrib++ = (unsigned long) dval[j];
#else
	  *cgrib++ = (unsigned char) dval[j];
#endif
	}
      z += residual;

#ifdef _GET_IBM_COUNTER 
      hpmStop(2);
#endif
    }
  else if ( numBits == 16 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(3, "pack 16 bit unrolled");
#endif
#ifdef _ARCH_PWR6
      unsigned long ival;
#else
      uint16_t ival;
#endif
      uint16_t *sgrib = (uint16_t *)(void *)(lGrib+z);

      for (size_t i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
	{
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    dval[j] = CGRIBEX_FPSCALE(data[j]);
	  if ( IS_BIGENDIAN() )
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
#ifdef _ARCH_PWR6
		  *sgrib++ = (unsigned long) dval[j];
#else
		  *sgrib++ = (uint16_t) dval[j];
#endif
		}
	      z += 2*CGRIBEX__UNROLL_DEPTH_2;
	    }
	  else
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
		  ival = (uint16_t) dval[j];
                  *sgrib++ = gribSwapByteOrder_uint16(ival);
		}
	      z += 2*CGRIBEX__UNROLL_DEPTH_2;
	    }
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  dval[j] = CGRIBEX_FPSCALE(data[j]);
	}
      if ( IS_BIGENDIAN() )
	{
	  for (size_t j = 0; j < residual; ++j) 
	    {
#ifdef _ARCH_PWR6
	      *sgrib++ = (unsigned long) dval[j];
#else
              *sgrib++ = (uint16_t) dval[j];
#endif
	    }
	  z += 2*residual;
	}
      else
	{
	  for (size_t j = 0; j < residual; ++j) 
	    {
              ival = (uint16_t) dval[j];
	      lGrib[z  ] = (GRIBPACK)(ival >>  8);
	      lGrib[z+1] = (GRIBPACK)ival;
	      z += 2;
	    }
	}
#ifdef _GET_IBM_COUNTER 
      hpmStop(3);
#endif
    }
  else if ( numBits == 24 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(4, "pack 24 bit unrolled");
#endif
#ifdef _ARCH_PWR6
      unsigned long ival;
#else
      uint32_t ival;
#endif
      for (size_t i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
	{
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
	      dval[j] = CGRIBEX_FPSCALE(data[j]);
	    }
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
#ifdef _ARCH_PWR6
	      ival = (unsigned long) dval[j];
#else
	      ival = (uint32_t) dval[j];
#endif
	      lGrib[z  ] =  (GRIBPACK)(ival >> 16);
	      lGrib[z+1] =  (GRIBPACK)(ival >>  8);
	      lGrib[z+2] =  (GRIBPACK)ival;
	      z += 3;
	    }
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  dval[j] = CGRIBEX_FPSCALE(data[j]);
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  ival = (uint32_t) dval[j];
	  lGrib[z  ] =  (GRIBPACK)(ival >> 16);
	  lGrib[z+1] =  (GRIBPACK)(ival >>  8);
	  lGrib[z+2] =  (GRIBPACK)ival;
	  z += 3;
	}
#ifdef _GET_IBM_COUNTER 
      hpmStop(4);
#endif
    }
  else if ( numBits == 32 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(5, "pack 32 bit unrolled");
#endif
#ifdef _ARCH_PWR6
      unsigned long ival;
#else
      uint32_t ival;
#endif
      unsigned int *igrib = (unsigned int *)(void *)(lGrib + z);
      for (size_t i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
        {
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j) dval[j] = CGRIBEX_FPSCALE(data[i+j]);

	  if ( IS_BIGENDIAN() )
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
#ifdef _ARCH_PWR6
		  *igrib = (unsigned long) dval[j];
#else
		  *igrib = (uint32_t) dval[j];
#endif
		  igrib++;
		  z += 4;
		}
	    }
	  else
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
                  ival = (uint32_t) dval[j];
		  lGrib[z  ] =  (GRIBPACK)(ival >> 24);
		  lGrib[z+1] =  (GRIBPACK)(ival >> 16);
		  lGrib[z+2] =  (GRIBPACK)(ival >>  8);
		  lGrib[z+3] =  (GRIBPACK)ival;
		  z += 4;
		}
	    }
	}
      for (size_t j = 0; j < residual; ++j) 
	{
          dval[j] = CGRIBEX_FPSCALE(data[ofs+j]);
	}
      if ( IS_BIGENDIAN() )
	{
	  for (size_t j = 0; j < residual; ++j) 
	    {
#ifdef _ARCH_PWR6
	      *igrib = (unsigned long) dval[j];
#else
	      *igrib = (uint32_t) dval[j];
#endif
	      igrib++;
	      z += 4;
	    }
	}
      else
	{
          for (size_t j = 0; j < residual; ++j) 
	    {
	      ival = (uint32_t) dval[j];
	      lGrib[z  ] =  (GRIBPACK)(ival >> 24);
	      lGrib[z+1] =  (GRIBPACK)(ival >> 16);
	      lGrib[z+2] =  (GRIBPACK)(ival >>  8);
	      lGrib[z+3] =  (GRIBPACK)ival;
	      z += 4;
	    }
	}
#ifdef _GET_IBM_COUNTER 
      hpmStop(5);
#endif
    }
  else if ( numBits > 0 && numBits <= 32 )
    {
      TEMPLATE(encode_array_common,T)(numBits, 0, datasize, lGrib, data, zref, factor, &z);
    }
  else if ( numBits == 0 )
    {
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }

  *gz = z;
}

#ifdef CGRIBEX_FPSCALE
#undef CGRIBEX_FPSCALE
#endif

#endif /* T */

#ifdef T
#undef T
#endif
#define T float
#ifdef T


#define CGRIBEX_FPSCALE(data) (((data) - zref) * factor + 0.5)

static
void TEMPLATE(encode_array_common,T)(int numBits, size_t packStart, size_t datasize, GRIBPACK *lGrib,
				     const T *data, T zref, T factor, size_t *gz)
{
  size_t z = *gz;
  unsigned int ival;
  int cbits, jbits;
  unsigned int c;

  // code from gribw routine flist2bitstream

  cbits = 8;
  c = 0;
  for (size_t i = packStart; i < datasize; ++i)
    {
      // note float -> unsigned int .. truncate
      ival = (unsigned int)(CGRIBEX_FPSCALE(data[i]));
      /*
	if ( ival > max_nbpv_pow2 ) ival = max_nbpv_pow2;
	if ( ival < 0 ) ival = 0;
      */
      jbits = numBits;
      while ( cbits <= jbits ) 
	{
	  if ( cbits == 8 )
	    {
	      jbits -= 8;
	      lGrib[z++] = (ival >> jbits) & 0xFF;
	    }
	  else
	    {
	      jbits -= cbits;
	      lGrib[z++] = (GRIBPACK)((c << cbits)
                                      + ((ival >> jbits) & ((1U << cbits) - 1)));
	      cbits = 8;
	      c = 0;
	    }
	}
      /* now jbits < cbits */
      if ( jbits )
	{
	  c = (c << jbits) + (ival & ((1U << jbits)-1));
	  cbits -= jbits;
	}
    }
  if ( cbits != 8 ) lGrib[z++] = (GRIBPACK)(c << cbits);

  *gz = z;
}


static
void TEMPLATE(encode_array_2byte,T)(size_t datasize, GRIBPACK *restrict lGrib,
				    const T *restrict data, T zref, T factor, size_t *gz)
{
  uint16_t *restrict sgrib = (uint16_t *)(void *)(lGrib+*gz);

  if (IS_BIGENDIAN())
    {
      for (size_t i = 0; i < datasize; ++i)
        sgrib[i] = (uint16_t) CGRIBEX_FPSCALE(data[i]);
    }
  else
    {
      for (size_t i = 0; i < datasize; ++i)
        {
          uint16_t ui16 = (uint16_t) CGRIBEX_FPSCALE(data[i]);
          sgrib[i] = gribSwapByteOrder_uint16(ui16);
        }
    }

  *gz += 2*datasize;
}

static
void TEMPLATE(encode_array,T)(int numBits, size_t packStart, size_t datasize, 
			      GRIBPACK *restrict lGrib,
			      const T *restrict data, 
			      T zref, T factor, size_t *gz)
{
  size_t z = *gz;

  data += packStart;
  datasize -= packStart;

  if (numBits ==  8)
    {
      for (size_t i = 0; i < datasize; ++i)
	{
	  lGrib[z++] = (GRIBPACK) CGRIBEX_FPSCALE(data[i]);
	}
    }
  else if (numBits == 16)
    {
      if (sizeof(T) == sizeof(double))
      	{
          grib_encode_array_2byte_double(datasize, lGrib, (const double *)(const void *)data, zref, factor, &z);
        }
      else
        {
          TEMPLATE(encode_array_2byte,T)(datasize, lGrib, data, zref, factor, &z);
        }
    }
  else if (numBits == 24)
    {
      for (size_t i = 0; i < datasize; ++i)
	{
          uint32_t ui32 = (uint32_t) CGRIBEX_FPSCALE(data[i]);
          lGrib[z++] = (GRIBPACK)(ui32 >> 16);
          lGrib[z++] = (GRIBPACK)(ui32 >>  8);
          lGrib[z++] = (GRIBPACK)ui32;
	}
    }
  else if (numBits == 32)
    {
      for (size_t i = 0; i < datasize; ++i)
	{
          uint32_t ui32 = (uint32_t) CGRIBEX_FPSCALE(data[i]);
          lGrib[z++] = (GRIBPACK)(ui32 >> 24);
          lGrib[z++] = (GRIBPACK)(ui32 >> 16);
          lGrib[z++] = (GRIBPACK)(ui32 >>  8);
          lGrib[z++] = (GRIBPACK)ui32;
	}
    }
  else if (numBits > 0 && numBits <= 32)
    {
      TEMPLATE(encode_array_common,T)(numBits, 0, datasize, lGrib, data, zref, factor, &z);
    }
  else if (numBits == 0)
    {
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }

  *gz = z;
}

static
void TEMPLATE(encode_array_unrolled,T)(int numBits, size_t packStart, size_t datasize, 
				       GRIBPACK *restrict lGrib,
				       const T *restrict data, 
				       T zref, T factor, size_t *gz)
{
  size_t z = *gz;
#ifdef _ARCH_PWR6
  enum { CGRIBEX__UNROLL_DEPTH_2 = 8 };
#else
  enum { CGRIBEX__UNROLL_DEPTH_2 = 128 };
#endif
  size_t residual;
  size_t ofs;
  double dval[CGRIBEX__UNROLL_DEPTH_2];

  data += packStart;
  datasize -= packStart;
  residual =  datasize % CGRIBEX__UNROLL_DEPTH_2;
  ofs = datasize - residual;

  // reducing FP operations to single FMA is slowing down on pwr6 ...

  if      ( numBits ==  8 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(2, "pack 8 bit unrolled");
#endif
      unsigned char *cgrib = (unsigned char *) (lGrib + z);
      size_t i;
      for (i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
	{
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
	      dval[j] = CGRIBEX_FPSCALE(data[i+j]);
	    }
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
#ifdef _ARCH_PWR6
	      *cgrib++ =  (unsigned long) dval[j];
#else
	      *cgrib++ =  (unsigned char) dval[j];
#endif
	    }
	  z += CGRIBEX__UNROLL_DEPTH_2;
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  dval[j] = CGRIBEX_FPSCALE(data[i+j]);
	}
      for (size_t j = 0; j < residual; ++j) 
	{
#ifdef _ARCH_PWR6
	  *cgrib++ = (unsigned long) dval[j];
#else
	  *cgrib++ = (unsigned char) dval[j];
#endif
	}
      z += residual;

#ifdef _GET_IBM_COUNTER 
      hpmStop(2);
#endif
    }
  else if ( numBits == 16 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(3, "pack 16 bit unrolled");
#endif
#ifdef _ARCH_PWR6
      unsigned long ival;
#else
      uint16_t ival;
#endif
      uint16_t *sgrib = (uint16_t *)(void *)(lGrib+z);

      for (size_t i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
	{
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    dval[j] = CGRIBEX_FPSCALE(data[j]);
	  if ( IS_BIGENDIAN() )
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
#ifdef _ARCH_PWR6
		  *sgrib++ = (unsigned long) dval[j];
#else
		  *sgrib++ = (uint16_t) dval[j];
#endif
		}
	      z += 2*CGRIBEX__UNROLL_DEPTH_2;
	    }
	  else
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
		  ival = (uint16_t) dval[j];
                  *sgrib++ = gribSwapByteOrder_uint16(ival);
		}
	      z += 2*CGRIBEX__UNROLL_DEPTH_2;
	    }
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  dval[j] = CGRIBEX_FPSCALE(data[j]);
	}
      if ( IS_BIGENDIAN() )
	{
	  for (size_t j = 0; j < residual; ++j) 
	    {
#ifdef _ARCH_PWR6
	      *sgrib++ = (unsigned long) dval[j];
#else
              *sgrib++ = (uint16_t) dval[j];
#endif
	    }
	  z += 2*residual;
	}
      else
	{
	  for (size_t j = 0; j < residual; ++j) 
	    {
              ival = (uint16_t) dval[j];
	      lGrib[z  ] = (GRIBPACK)(ival >>  8);
	      lGrib[z+1] = (GRIBPACK)ival;
	      z += 2;
	    }
	}
#ifdef _GET_IBM_COUNTER 
      hpmStop(3);
#endif
    }
  else if ( numBits == 24 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(4, "pack 24 bit unrolled");
#endif
#ifdef _ARCH_PWR6
      unsigned long ival;
#else
      uint32_t ival;
#endif
      for (size_t i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
	{
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
	      dval[j] = CGRIBEX_FPSCALE(data[j]);
	    }
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
	    {
#ifdef _ARCH_PWR6
	      ival = (unsigned long) dval[j];
#else
	      ival = (uint32_t) dval[j];
#endif
	      lGrib[z  ] =  (GRIBPACK)(ival >> 16);
	      lGrib[z+1] =  (GRIBPACK)(ival >>  8);
	      lGrib[z+2] =  (GRIBPACK)ival;
	      z += 3;
	    }
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  dval[j] = CGRIBEX_FPSCALE(data[j]);
	}
      for (size_t j = 0; j < residual; ++j) 
	{
	  ival = (uint32_t) dval[j];
	  lGrib[z  ] =  (GRIBPACK)(ival >> 16);
	  lGrib[z+1] =  (GRIBPACK)(ival >>  8);
	  lGrib[z+2] =  (GRIBPACK)ival;
	  z += 3;
	}
#ifdef _GET_IBM_COUNTER 
      hpmStop(4);
#endif
    }
  else if ( numBits == 32 )
    {
#ifdef _GET_IBM_COUNTER 
      hpmStart(5, "pack 32 bit unrolled");
#endif
#ifdef _ARCH_PWR6
      unsigned long ival;
#else
      uint32_t ival;
#endif
      unsigned int *igrib = (unsigned int *)(void *)(lGrib + z);
      for (size_t i = 0; i < datasize - residual; i += CGRIBEX__UNROLL_DEPTH_2)
        {
	  for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j) dval[j] = CGRIBEX_FPSCALE(data[i+j]);

	  if ( IS_BIGENDIAN() )
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
#ifdef _ARCH_PWR6
		  *igrib = (unsigned long) dval[j];
#else
		  *igrib = (uint32_t) dval[j];
#endif
		  igrib++;
		  z += 4;
		}
	    }
	  else
	    {
	      for (size_t j = 0; j < CGRIBEX__UNROLL_DEPTH_2; ++j)
		{
                  ival = (uint32_t) dval[j];
		  lGrib[z  ] =  (GRIBPACK)(ival >> 24);
		  lGrib[z+1] =  (GRIBPACK)(ival >> 16);
		  lGrib[z+2] =  (GRIBPACK)(ival >>  8);
		  lGrib[z+3] =  (GRIBPACK)ival;
		  z += 4;
		}
	    }
	}
      for (size_t j = 0; j < residual; ++j) 
	{
          dval[j] = CGRIBEX_FPSCALE(data[ofs+j]);
	}
      if ( IS_BIGENDIAN() )
	{
	  for (size_t j = 0; j < residual; ++j) 
	    {
#ifdef _ARCH_PWR6
	      *igrib = (unsigned long) dval[j];
#else
	      *igrib = (uint32_t) dval[j];
#endif
	      igrib++;
	      z += 4;
	    }
	}
      else
	{
          for (size_t j = 0; j < residual; ++j) 
	    {
	      ival = (uint32_t) dval[j];
	      lGrib[z  ] =  (GRIBPACK)(ival >> 24);
	      lGrib[z+1] =  (GRIBPACK)(ival >> 16);
	      lGrib[z+2] =  (GRIBPACK)(ival >>  8);
	      lGrib[z+3] =  (GRIBPACK)ival;
	      z += 4;
	    }
	}
#ifdef _GET_IBM_COUNTER 
      hpmStop(5);
#endif
    }
  else if ( numBits > 0 && numBits <= 32 )
    {
      TEMPLATE(encode_array_common,T)(numBits, 0, datasize, lGrib, data, zref, factor, &z);
    }
  else if ( numBits == 0 )
    {
    }
  else
    {
      Error("Unimplemented packing factor %d!", numBits);
    }

  *gz = z;
}

#ifdef CGRIBEX_FPSCALE
#undef CGRIBEX_FPSCALE
#endif

#endif /* T */


#ifdef T
#undef T
#endif
#define T double
#ifdef T

// GRIB BLOCK 2 - GRID DESCRIPTION SECTION
static
void TEMPLATE(encodeGDS,T)(GRIBPACK *lGrib, long *gribLen, int *isec2, T *fsec2)
{
  long z = *gribLen;
  int exponent, mantissa;
  int ival;
  int gdslen = 32;

  if ( ISEC2_GridType == GRIB1_GTYPE_LCC ) gdslen += 10;

  if ( ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )  gdslen += 10;

  const int pvoffset = (ISEC2_NumVCP || ISEC2_Reduced) ? gdslen + 1 : 0xFF;

  if ( ISEC2_Reduced ) gdslen += 2 * ISEC2_NumLat;

  gdslen += ISEC2_NumVCP * 4;

  Put3Byte(gdslen);             /*  0- 2 Length of Block 2 Byte 0 */
  Put1Byte(ISEC2_NumVCP);       /*  3    NV */
  Put1Byte(pvoffset);           /*  4    PV */
  Put1Byte(ISEC2_GridType);     /*  5    LatLon=0 Gauss=4 Spectral=50 */

  if ( ISEC2_GridType == GRIB1_GTYPE_SPECTRAL )
    {
      Put2Byte(ISEC2_PentaJ);   /*  6- 7 Pentagonal resolution J  */
      Put2Byte(ISEC2_PentaK);   /*  8- 9 Pentagonal resolution K  */
      Put2Byte(ISEC2_PentaM);   /* 10-11 Pentagonal resolution M  */
      Put1Byte(ISEC2_RepType);  /* 12    Representation type      */
      Put1Byte(ISEC2_RepMode);  /* 13    Representation mode      */
      PutnZero(18);             /* 14-31 reserved                 */
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_GME )
    {
      Put2Byte(ISEC2_GME_NI2);
      Put2Byte(ISEC2_GME_NI3);
      Put3Byte(ISEC2_GME_ND);
      Put3Byte(ISEC2_GME_NI);
      Put1Byte(ISEC2_GME_AFlag);
      Put3Int(ISEC2_GME_LatPP);
      Put3Int(ISEC2_GME_LonPP);
      Put3Int(ISEC2_GME_LonMPL);
      Put1Byte(ISEC2_GME_BFlag);
      PutnZero(5);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LCC )
    {
      Put2Byte(ISEC2_NumLon);          /*  6- 7 Longitudes               */

      Put2Byte(ISEC2_NumLat);          /*  8- 9 Latitudes                */
      Put3Int(ISEC2_FirstLat);
      Put3Int(ISEC2_FirstLon);
      Put1Byte(ISEC2_ResFlag);         /* 16    Resolution flag          */
      Put3Int(ISEC2_Lambert_Lov);      /* 17-19 */
      Put3Int(ISEC2_Lambert_dx);       /* 20-22 */
      Put3Int(ISEC2_Lambert_dy);       /* 23-25 */
      Put1Byte(ISEC2_Lambert_ProjFlag);/* 26    Projection flag          */
      Put1Byte(ISEC2_ScanFlag);        /* 27    Scanning mode            */
      Put3Int(ISEC2_Lambert_LatS1);    /* 28-30 */  
      Put3Int(ISEC2_Lambert_LatS2);    /* 31-33 */
      Put3Int(ISEC2_Lambert_LatSP);    /* 34-36 */  
      Put3Int(ISEC2_Lambert_LonSP);    /* 37-39 */
      PutnZero(2);                     /* 34-41 */
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LATLON    ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN  ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
    {
      const int numlon = ISEC2_Reduced ? 0xFFFF : ISEC2_NumLon;
      Put2Byte(numlon);                /*  6- 7 Number of Longitudes     */

      Put2Byte(ISEC2_NumLat);          /*  8- 9 Number of Latitudes      */
      Put3Int(ISEC2_FirstLat);
      Put3Int(ISEC2_FirstLon);
      Put1Byte(ISEC2_ResFlag);         /* 16    Resolution flag          */
      Put3Int(ISEC2_LastLat);
      Put3Int(ISEC2_LastLon);
      const unsigned lonIncr = (ISEC2_ResFlag == 0) ? 0xFFFF : (unsigned)ISEC2_LonIncr;
      const unsigned latIncr = (ISEC2_ResFlag == 0) ? 0xFFFF : (unsigned)ISEC2_LatIncr;
      Put2Byte(lonIncr);               /* 23-24 i - direction increment  */
      if ( ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN )
	Put2Byte(ISEC2_NumPar);        /* 25-26 Latitudes Pole->Equator  */
      else
	Put2Byte(latIncr);             /* 25-26 j - direction increment  */

      Put1Byte(ISEC2_ScanFlag);        /* 27    Scanning mode            */
      PutnZero(4);                     /* 28-31 reserved                 */

      if ( ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
	{
	  Put3Int(ISEC2_LatSP);
	  Put3Int(ISEC2_LonSP);
	  Put1Real((double)(FSEC2_RotAngle));
	}
    }
  else
    {
      Error("Unsupported grid type %d", ISEC2_GridType);
    }

#if defined (SX)
#pragma vdir novector     /* vectorization gives wrong results on NEC */
#endif
  for (long i = 0; i < ISEC2_NumVCP; ++i)
    {
      Put1Real((double)(fsec2[10+i]));
    }

  if ( ISEC2_Reduced )
    for (long i = 0; i < ISEC2_NumLat; ++i) Put2Byte(ISEC2_ReducedPoints(i));

  *gribLen = z;
}

// GRIB BLOCK 3 - BIT MAP SECTION
static
void TEMPLATE(encodeBMS,T)(GRIBPACK *lGrib, long *gribLen, T *fsec3, int *isec4, T *data, long *datasize)
{
  long z = *gribLen;
  static bool lmissvalinfo = true;
  //  unsigned int c, imask;

  if ( DBL_IS_NAN(FSEC3_MissVal) && lmissvalinfo)
    {
      lmissvalinfo = false;
      Message("Missing value = NaN is unsupported!");
    }

  const long bitmapSize = ISEC4_NumValues;
  const long imaskSize = ((bitmapSize+7)>>3)<<3;
  GRIBPACK *bitmap = &lGrib[z+6];
  long fsec4size = 0;

#ifdef VECTORCODE
  unsigned int *imask = (unsigned int*) Malloc(imaskSize*sizeof(unsigned int));
  memset(imask, 0, imaskSize*sizeof(int));

#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
  for (long i = 0; i < bitmapSize; ++i)
    {
      if ( IS_NOT_EQUAL(data[i], FSEC3_MissVal) )
	{
	  data[fsec4size++] = data[i];
	  imask[i] = 1;
	}
    }

#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
  for (long i = 0; i < imaskSize/8; ++i)
    {
      bitmap[i] = (imask[i*8+0] << 7) | (imask[i*8+1] << 6) |
	          (imask[i*8+2] << 5) | (imask[i*8+3] << 4) |
	          (imask[i*8+4] << 3) | (imask[i*8+5] << 2) |
	          (imask[i*8+6] << 1) | (imask[i*8+7]);
    }

  Free(imask);
#else
  for (long i = 0; i < imaskSize/8; ++i) bitmap[i] = 0;

  for (long i = 0; i < bitmapSize; ++i)
    {
      if ( IS_NOT_EQUAL(data[i], FSEC3_MissVal) )
	{
	  data[fsec4size++] = data[i];
	  bitmap[i/8] |= (GRIBPACK)(1<<(7-(i&7)));
	}
    }
#endif

  const long bmsLen = imaskSize/8 + 6;
  const long bmsUnusedBits = imaskSize - bitmapSize;

  Put3Byte(bmsLen);   /*  0- 2 Length of Block 3 Byte 0 */
  Put1Byte(bmsUnusedBits);
  Put2Byte(0);

  *gribLen += bmsLen;

  *datasize = fsec4size;
}

#define pow_double pow
#define pow_float powf

// GRIB BLOCK 4 - BINARY DATA SECTION
static
int TEMPLATE(encodeBDS,T)(GRIBPACK *lGrib, long *gribLen, int decscale, int *isec2, int *isec4, long datasize, T *data,
			  long *datstart, long *datsize, int code)
{
  // Uwe Schulzweida, 11/04/2003 : Check that number of bits per value is not exceeded
  // Uwe Schulzweida,  6/05/2003 : Copy result to fpval to prevent integer overflow

  size_t z = (size_t)*gribLen;
  int numBits;
  int ival;
  long PackStart = 0;
  int Flag = 0;
  int binscale = 0;
  int bds_head = 11;
  int bds_ext = 0;
  /* ibits = BitsPerInt; */
  int exponent, mantissa;
  bool lspherc = false;
  int isubset = 0, itemp = 0, itrunc = 0;
  T factor = 1, fmin, fmax;
  const double jpepsln = 1.0e-12; // -----> tolerance used to check equality
                                  //        of floating point numbers - needed
		                  //        on some platforms (eg vpp700, linux)
  extern int CGRIBEX_Const;       // 1: Don't pack constant fields on regular grids

  if ( isec2 )
    {
      /* If section 2 is present, it says if data is spherical harmonic */

      lspherc =  ( isec2[0] == 50 || isec2[0] == 60 ||
                   isec2[0] == 70 || isec2[0] == 80 );

      isec4[2] = lspherc ? 128 : 0;
    }
  else
    {
      /* Section 4 says if it's spherical harmonic data.. */

      lspherc = ( isec4[2] == 128 );
    }

  /* Complex packing supported for spherical harmonics. */

  const bool lcomplex = ( lspherc && ( isec4[3] == 64 ) ) ||
                        ( lspherc && isec2 && ( isec2[5] == 2 ) );

  // Check input specification is consistent

  if ( lcomplex && isec2 )
    {
      if ( ( isec4[3] != 64 ) && ( isec2[5] == 2 ) )
	{
	  gprintf(__func__, "  COMPLEX mismatch. isec4[3] = %d\n", isec4[3]);
	  gprintf(__func__, "  COMPLEX mismatch. isec2[5] = %d\n", isec2[5]);
	  return (807);
	}
      else if ( ( isec4[3] == 64 ) && ( isec2[5] != 2 ) )
	{
	  gprintf(__func__, "  COMPLEX mismatch. isec4[3] = %d\n", isec4[3]);
	  gprintf(__func__, "  COMPLEX mismatch. isec2[5] = %d\n", isec2[5]);
	  return (807);
        }
      else if ( lcomplex )
	{
          // Truncation of full spectrum, which is supposed triangular, has to be diagnosed. Define also sub-set truncation.
	  isubset = isec4[17];
	  // When encoding, use the total number of data.
	  itemp   = isec4[0];
	  itrunc  = (int) (sqrt(itemp*4 + 1.) - 3) / 2;
	}
    }

  if ( decscale )
    {
      const T scale = TEMPLATE(pow,T)((T)10.0, (T)decscale);
      for (long i = 0; i < datasize; ++i) data[i] *= scale;
    }

  if ( lspherc )
    {
      if ( lcomplex )
	{
	  const int jup  = isubset;
	  const int ioff = (jup+1)*(jup+2);
	  bds_ext = 4 + 3 + 4*ioff;
	  PackStart = ioff;
	  Flag = 192;
	}
      else
	{
	  bds_ext = 4;
	  PackStart = 1;
	  Flag = 128;
	}
    }

  *datstart = bds_head + bds_ext;

  int nbpv = numBits = ISEC4_NumBits;

  if ( lspherc && lcomplex )
    {
      const int pcStart = isubset;
      const int pcScale = isec4[16];
      TEMPLATE(scale_complex,T)(data, pcStart, pcScale, itrunc, 0);
      TEMPLATE(gather_complex,T)(data, (size_t)pcStart, (size_t)itrunc, (size_t)datasize);
    }

  fmin = fmax = data[PackStart];

  TEMPLATE(minmax_val,T)(data+PackStart, datasize-PackStart, &fmin, &fmax);

  double zref = (double)fmin;
  if (!(zref < DBL_MAX && zref > -DBL_MAX))
    {
      gprintf(__func__, "Minimum value out of range: %g!", zref);
      return (707);
    }

  if ( CGRIBEX_Const && !lspherc )
    {
      if ( IS_EQUAL(fmin, fmax) ) nbpv = 0;
    }

  long blockLength = (*datstart) + (nbpv*(datasize - PackStart) + 7)/8;
  blockLength += blockLength & 1;

  const long unused_bits = blockLength*8 - (*datstart)*8 - nbpv*(datasize - PackStart);

  Flag += (int)unused_bits;


  // Adjust number of bits per value if full integer length to avoid hitting most significant bit (sign bit).
  // if( nbpv == ibits ) nbpv = nbpv - 1;
  /*
    Calculate the binary scaling factor to spread the range of values over the number of bits per value.
    Limit scaling to 2**-126 to 2**127 (using IEEE 32-bit floatsas a guideline).
  */
  const double range = fabs(fmax - fmin);

  if ( fabs(fmin) < FLT_MIN ) fmin = 0;
  /*
    Have to allow tolerance in comparisons on some platforms (eg vpp700 and linux),
    such as 0.9999999999999999 = 1.0, to avoid clipping ranges which are a power of 2.
  */
  if ( range <= jpepsln )
    {
      binscale = 0;
    }
  else if ( IS_NOT_EQUAL(fmin, 0.0) && (fabs(range/fmin) <= jpepsln) )
    {
      binscale = 0;
    }
  else if ( fabs(range-1.0) <= jpepsln )
    {
      binscale = 1 - nbpv;
    }
  else if ( range > 1.0 )
    {
      const double rangec = range + jpepsln;
      double p2 = 2.0;
      int jloop = 1;
      while ( jloop < 128 && p2 <= rangec )
        {
          p2 *= 2.0;
          ++jloop;
        }
      if (jloop < 128)
        binscale = jloop - nbpv;
      else
        {
          gprintf(__func__, "Problem calculating binary scale value for encode code %d!", code);
          gprintf(__func__, "> range %g rangec %g fmin %g fmax %g", range, rangec, fmin, fmax);
          return (707);
        }
    }
  else
    {
      const double rangec = range - jpepsln;
      double p05 = 0.5;
      int jloop = 1;
      while ( jloop < 127 && p05 >= rangec )
	{
          p05 *= 0.5;
          jloop++;
	}
      if ( jloop < 127 )
	{
	  binscale = 1 - jloop - nbpv;
	}
      else
	{
	  gprintf(__func__, "Problem calculating binary scale value for encode code %d!", code);
	  gprintf(__func__, "< range %g rangec %g fmin %g fmax %g", range, rangec, fmin, fmax);
	  return (707);
	}
    }

  const uint64_t max_nbpv_pow2 = (uint64_t) ((1ULL << nbpv) - 1);

  if ( binscale != 0 )
    {
      while ( (uint64_t)(ldexp(range, -binscale)+0.5) > max_nbpv_pow2 ) binscale++;

      factor = (T)intpow2(-binscale);
    }

  ref2ibm(&zref, BitsPerInt);

  Put3Byte(blockLength);      //  0-2 Length of Block 4
  Put1Byte(Flag);             //  3   Flag & Unused bits
  if ( binscale < 0 ) binscale = 32768 - binscale;
  Put2Byte(binscale);         //  4-5 Scale factor
  Put1Real(zref);             //  6-9 Reference value
  Put1Byte(nbpv);             //   10 Packing size

  if ( lspherc )
    {
      if ( lcomplex )
	{
	  const int jup = isubset;
	  int ioff = (int)z + bds_ext;
	  if ( ioff > 0xFFFF ) ioff = 0;
	  Put2Byte(ioff);
	  Put2Int(isec4[16]);
	  Put1Byte(jup);
	  Put1Byte(jup);
	  Put1Byte(jup);
	  for (long i = 0; i < ((jup+1)*(jup+2)); ++i) Put1Real((double)(data[i]));
	}
      else
	{
	  Put1Real((double)(data[0]));
	}
    }

  *datsize  = ((datasize-PackStart)*nbpv + 7)/8;

#if  defined  (_ARCH_PWR6)
  TEMPLATE(encode_array_unrolled,T)(nbpv, (size_t)PackStart, (size_t)datasize, lGrib, data, (T)zref, factor, &z);
#else
  TEMPLATE(encode_array,T)(nbpv, (size_t)PackStart, (size_t)datasize, lGrib, data, (T)zref, factor, &z);
#endif

  if ( unused_bits >= 8 ) Put1Byte(0);  //  Fillbyte

  *gribLen = (long)z;

  return 0;
}


void TEMPLATE(grib_encode,T)(int *isec0, int *isec1, int *isec2, T *fsec2, int *isec3,
			     T *fsec3, int *isec4, T *fsec4, int klenp, int *kgrib,
			     int kleng, int *kword, int efunc, int *kret)
{
  long gribLen = 0; // Counter of GRIB length for output
  long fsec4size = 0;
  long datstart, datsize;

  UNUSED(isec3);
  UNUSED(efunc);

  grsdef();

  unsigned char *CGrib = (unsigned char *) kgrib;

  const bool gdsIncluded = ISEC1_Sec2Or3Flag & 128;
  const bool bmsIncluded = ISEC1_Sec2Or3Flag & 64;

  // set max header len
  size_t len = 16384;

  // add data len
  const size_t numBytes = (size_t)((ISEC4_NumBits+7)>>3);

  len += numBytes*(size_t)klenp;

  // add bitmap len
  if ( bmsIncluded ) len += (size_t)((klenp+7)>>3);

#ifdef VECTORCODE
  GRIBPACK *lGrib = (GRIBPACK*) Malloc(len*sizeof(GRIBPACK));
  if ( lGrib == NULL ) SysError("No Memory!");
#else
  GRIBPACK *lGrib = CGrib;
#endif

  const long isLen = 8;
  encodeIS(lGrib, &gribLen);
  GRIBPACK *lpds = &lGrib[isLen];
  const long pdsLen = getPdsLen(isec1);

  encodePDS(lpds, pdsLen,  isec1);
  gribLen += pdsLen;
  /*
  if ( ( isec4[3] == 64 ) && ( isec2[5] == 2 ) )
    {
      static bool lwarn_cplx = true;

      if ( lwarn_cplx )
	Message("Complex packing of spectral data unsupported, using simple packing!");

      isec2[5] = 1;
      isec4[3] = 0;

      lwarn_cplx = false;
    }
  */
  if ( gdsIncluded ) TEMPLATE(encodeGDS,T)(lGrib, &gribLen, isec2, fsec2);
  /*
    ----------------------------------------------------------------
    BMS Bit-Map Section Section (Section 3)
    ----------------------------------------------------------------
  */ 
  if ( bmsIncluded )
    {
      TEMPLATE(encodeBMS,T)(lGrib, &gribLen, fsec3, isec4, fsec4, &fsec4size);
    }
  else
    {
      fsec4size = ISEC4_NumValues;
    }

  const long bdsstart = gribLen;
  int status = TEMPLATE(encodeBDS,T)(lGrib, &gribLen, ISEC1_DecScaleFactor, isec2,
                                     isec4, fsec4size, fsec4, &datstart, &datsize, ISEC1_Parameter);
  if ( status )
    {
      *kret = status;
      return;
    }

  encodeES(lGrib, &gribLen, bdsstart);

  if ( (size_t) gribLen > (size_t)kleng*sizeof(int) )
    Error("kgrib buffer too small! kleng = %d  gribLen = %d", kleng, gribLen);

#ifdef VECTORCODE
  if ( (size_t) gribLen > len )
    Error("lGrib buffer too small! len = %d  gribLen = %d", len, gribLen);

  (void) PACK_GRIB(lGrib, (unsigned char *)CGrib, gribLen, -1L);

  Free(lGrib);
#endif

  ISEC0_GRIB_Len     = (int)gribLen;
  ISEC0_GRIB_Version = 1;

  *kword = (int)((gribLen + (long)sizeof(int) - 1) / (long)sizeof(int));

  *kret = status;
}

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * End:
 */

#ifdef T
#undef T
#endif
#define T float
#ifdef T

// GRIB BLOCK 2 - GRID DESCRIPTION SECTION
static
void TEMPLATE(encodeGDS,T)(GRIBPACK *lGrib, long *gribLen, int *isec2, T *fsec2)
{
  long z = *gribLen;
  int exponent, mantissa;
  int ival;
  int gdslen = 32;

  if ( ISEC2_GridType == GRIB1_GTYPE_LCC ) gdslen += 10;

  if ( ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )  gdslen += 10;

  const int pvoffset = (ISEC2_NumVCP || ISEC2_Reduced) ? gdslen + 1 : 0xFF;

  if ( ISEC2_Reduced ) gdslen += 2 * ISEC2_NumLat;

  gdslen += ISEC2_NumVCP * 4;

  Put3Byte(gdslen);             /*  0- 2 Length of Block 2 Byte 0 */
  Put1Byte(ISEC2_NumVCP);       /*  3    NV */
  Put1Byte(pvoffset);           /*  4    PV */
  Put1Byte(ISEC2_GridType);     /*  5    LatLon=0 Gauss=4 Spectral=50 */

  if ( ISEC2_GridType == GRIB1_GTYPE_SPECTRAL )
    {
      Put2Byte(ISEC2_PentaJ);   /*  6- 7 Pentagonal resolution J  */
      Put2Byte(ISEC2_PentaK);   /*  8- 9 Pentagonal resolution K  */
      Put2Byte(ISEC2_PentaM);   /* 10-11 Pentagonal resolution M  */
      Put1Byte(ISEC2_RepType);  /* 12    Representation type      */
      Put1Byte(ISEC2_RepMode);  /* 13    Representation mode      */
      PutnZero(18);             /* 14-31 reserved                 */
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_GME )
    {
      Put2Byte(ISEC2_GME_NI2);
      Put2Byte(ISEC2_GME_NI3);
      Put3Byte(ISEC2_GME_ND);
      Put3Byte(ISEC2_GME_NI);
      Put1Byte(ISEC2_GME_AFlag);
      Put3Int(ISEC2_GME_LatPP);
      Put3Int(ISEC2_GME_LonPP);
      Put3Int(ISEC2_GME_LonMPL);
      Put1Byte(ISEC2_GME_BFlag);
      PutnZero(5);
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LCC )
    {
      Put2Byte(ISEC2_NumLon);          /*  6- 7 Longitudes               */

      Put2Byte(ISEC2_NumLat);          /*  8- 9 Latitudes                */
      Put3Int(ISEC2_FirstLat);
      Put3Int(ISEC2_FirstLon);
      Put1Byte(ISEC2_ResFlag);         /* 16    Resolution flag          */
      Put3Int(ISEC2_Lambert_Lov);      /* 17-19 */
      Put3Int(ISEC2_Lambert_dx);       /* 20-22 */
      Put3Int(ISEC2_Lambert_dy);       /* 23-25 */
      Put1Byte(ISEC2_Lambert_ProjFlag);/* 26    Projection flag          */
      Put1Byte(ISEC2_ScanFlag);        /* 27    Scanning mode            */
      Put3Int(ISEC2_Lambert_LatS1);    /* 28-30 */  
      Put3Int(ISEC2_Lambert_LatS2);    /* 31-33 */
      Put3Int(ISEC2_Lambert_LatSP);    /* 34-36 */  
      Put3Int(ISEC2_Lambert_LonSP);    /* 37-39 */
      PutnZero(2);                     /* 34-41 */
    }
  else if ( ISEC2_GridType == GRIB1_GTYPE_LATLON    ||
	    ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN  ||
	    ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
    {
      const int numlon = ISEC2_Reduced ? 0xFFFF : ISEC2_NumLon;
      Put2Byte(numlon);                /*  6- 7 Number of Longitudes     */

      Put2Byte(ISEC2_NumLat);          /*  8- 9 Number of Latitudes      */
      Put3Int(ISEC2_FirstLat);
      Put3Int(ISEC2_FirstLon);
      Put1Byte(ISEC2_ResFlag);         /* 16    Resolution flag          */
      Put3Int(ISEC2_LastLat);
      Put3Int(ISEC2_LastLon);
      const unsigned lonIncr = (ISEC2_ResFlag == 0) ? 0xFFFF : (unsigned)ISEC2_LonIncr;
      const unsigned latIncr = (ISEC2_ResFlag == 0) ? 0xFFFF : (unsigned)ISEC2_LatIncr;
      Put2Byte(lonIncr);               /* 23-24 i - direction increment  */
      if ( ISEC2_GridType == GRIB1_GTYPE_GAUSSIAN )
	Put2Byte(ISEC2_NumPar);        /* 25-26 Latitudes Pole->Equator  */
      else
	Put2Byte(latIncr);             /* 25-26 j - direction increment  */

      Put1Byte(ISEC2_ScanFlag);        /* 27    Scanning mode            */
      PutnZero(4);                     /* 28-31 reserved                 */

      if ( ISEC2_GridType == GRIB1_GTYPE_LATLON_ROT )
	{
	  Put3Int(ISEC2_LatSP);
	  Put3Int(ISEC2_LonSP);
	  Put1Real((double)(FSEC2_RotAngle));
	}
    }
  else
    {
      Error("Unsupported grid type %d", ISEC2_GridType);
    }

#if defined (SX)
#pragma vdir novector     /* vectorization gives wrong results on NEC */
#endif
  for (long i = 0; i < ISEC2_NumVCP; ++i)
    {
      Put1Real((double)(fsec2[10+i]));
    }

  if ( ISEC2_Reduced )
    for (long i = 0; i < ISEC2_NumLat; ++i) Put2Byte(ISEC2_ReducedPoints(i));

  *gribLen = z;
}

// GRIB BLOCK 3 - BIT MAP SECTION
static
void TEMPLATE(encodeBMS,T)(GRIBPACK *lGrib, long *gribLen, T *fsec3, int *isec4, T *data, long *datasize)
{
  long z = *gribLen;
  static bool lmissvalinfo = true;
  //  unsigned int c, imask;

  if ( DBL_IS_NAN(FSEC3_MissVal) && lmissvalinfo)
    {
      lmissvalinfo = false;
      Message("Missing value = NaN is unsupported!");
    }

  const long bitmapSize = ISEC4_NumValues;
  const long imaskSize = ((bitmapSize+7)>>3)<<3;
  GRIBPACK *bitmap = &lGrib[z+6];
  long fsec4size = 0;

#ifdef VECTORCODE
  unsigned int *imask = (unsigned int*) Malloc(imaskSize*sizeof(unsigned int));
  memset(imask, 0, imaskSize*sizeof(int));

#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
  for (long i = 0; i < bitmapSize; ++i)
    {
      if ( IS_NOT_EQUAL(data[i], FSEC3_MissVal) )
	{
	  data[fsec4size++] = data[i];
	  imask[i] = 1;
	}
    }

#if defined (CRAY)
#pragma _CRI ivdep
#endif
#if defined (SX)
#pragma vdir nodep
#endif
#ifdef __uxpch__
#pragma loop novrec
#endif
  for (long i = 0; i < imaskSize/8; ++i)
    {
      bitmap[i] = (imask[i*8+0] << 7) | (imask[i*8+1] << 6) |
	          (imask[i*8+2] << 5) | (imask[i*8+3] << 4) |
	          (imask[i*8+4] << 3) | (imask[i*8+5] << 2) |
	          (imask[i*8+6] << 1) | (imask[i*8+7]);
    }

  Free(imask);
#else
  for (long i = 0; i < imaskSize/8; ++i) bitmap[i] = 0;

  for (long i = 0; i < bitmapSize; ++i)
    {
      if ( IS_NOT_EQUAL(data[i], FSEC3_MissVal) )
	{
	  data[fsec4size++] = data[i];
	  bitmap[i/8] |= (GRIBPACK)(1<<(7-(i&7)));
	}
    }
#endif

  const long bmsLen = imaskSize/8 + 6;
  const long bmsUnusedBits = imaskSize - bitmapSize;

  Put3Byte(bmsLen);   /*  0- 2 Length of Block 3 Byte 0 */
  Put1Byte(bmsUnusedBits);
  Put2Byte(0);

  *gribLen += bmsLen;

  *datasize = fsec4size;
}

#define pow_double pow
#define pow_float powf

// GRIB BLOCK 4 - BINARY DATA SECTION
static
int TEMPLATE(encodeBDS,T)(GRIBPACK *lGrib, long *gribLen, int decscale, int *isec2, int *isec4, long datasize, T *data,
			  long *datstart, long *datsize, int code)
{
  // Uwe Schulzweida, 11/04/2003 : Check that number of bits per value is not exceeded
  // Uwe Schulzweida,  6/05/2003 : Copy result to fpval to prevent integer overflow

  size_t z = (size_t)*gribLen;
  int numBits;
  int ival;
  long PackStart = 0;
  int Flag = 0;
  int binscale = 0;
  int bds_head = 11;
  int bds_ext = 0;
  /* ibits = BitsPerInt; */
  int exponent, mantissa;
  bool lspherc = false;
  int isubset = 0, itemp = 0, itrunc = 0;
  T factor = 1, fmin, fmax;
  const double jpepsln = 1.0e-12; // -----> tolerance used to check equality
                                  //        of floating point numbers - needed
		                  //        on some platforms (eg vpp700, linux)
  extern int CGRIBEX_Const;       // 1: Don't pack constant fields on regular grids

  if ( isec2 )
    {
      /* If section 2 is present, it says if data is spherical harmonic */

      lspherc =  ( isec2[0] == 50 || isec2[0] == 60 ||
                   isec2[0] == 70 || isec2[0] == 80 );

      isec4[2] = lspherc ? 128 : 0;
    }
  else
    {
      /* Section 4 says if it's spherical harmonic data.. */

      lspherc = ( isec4[2] == 128 );
    }

  /* Complex packing supported for spherical harmonics. */

  const bool lcomplex = ( lspherc && ( isec4[3] == 64 ) ) ||
                        ( lspherc && isec2 && ( isec2[5] == 2 ) );

  // Check input specification is consistent

  if ( lcomplex && isec2 )
    {
      if ( ( isec4[3] != 64 ) && ( isec2[5] == 2 ) )
	{
	  gprintf(__func__, "  COMPLEX mismatch. isec4[3] = %d\n", isec4[3]);
	  gprintf(__func__, "  COMPLEX mismatch. isec2[5] = %d\n", isec2[5]);
	  return (807);
	}
      else if ( ( isec4[3] == 64 ) && ( isec2[5] != 2 ) )
	{
	  gprintf(__func__, "  COMPLEX mismatch. isec4[3] = %d\n", isec4[3]);
	  gprintf(__func__, "  COMPLEX mismatch. isec2[5] = %d\n", isec2[5]);
	  return (807);
        }
      else if ( lcomplex )
	{
          // Truncation of full spectrum, which is supposed triangular, has to be diagnosed. Define also sub-set truncation.
	  isubset = isec4[17];
	  // When encoding, use the total number of data.
	  itemp   = isec4[0];
	  itrunc  = (int) (sqrt(itemp*4 + 1.) - 3) / 2;
	}
    }

  if ( decscale )
    {
      const T scale = TEMPLATE(pow,T)((T)10.0, (T)decscale);
      for (long i = 0; i < datasize; ++i) data[i] *= scale;
    }

  if ( lspherc )
    {
      if ( lcomplex )
	{
	  const int jup  = isubset;
	  const int ioff = (jup+1)*(jup+2);
	  bds_ext = 4 + 3 + 4*ioff;
	  PackStart = ioff;
	  Flag = 192;
	}
      else
	{
	  bds_ext = 4;
	  PackStart = 1;
	  Flag = 128;
	}
    }

  *datstart = bds_head + bds_ext;

  int nbpv = numBits = ISEC4_NumBits;

  if ( lspherc && lcomplex )
    {
      const int pcStart = isubset;
      const int pcScale = isec4[16];
      TEMPLATE(scale_complex,T)(data, pcStart, pcScale, itrunc, 0);
      TEMPLATE(gather_complex,T)(data, (size_t)pcStart, (size_t)itrunc, (size_t)datasize);
    }

  fmin = fmax = data[PackStart];

  TEMPLATE(minmax_val,T)(data+PackStart, datasize-PackStart, &fmin, &fmax);

  double zref = (double)fmin;
  if (!(zref < DBL_MAX && zref > -DBL_MAX))
    {
      gprintf(__func__, "Minimum value out of range: %g!", zref);
      return (707);
    }

  if ( CGRIBEX_Const && !lspherc )
    {
      if ( IS_EQUAL(fmin, fmax) ) nbpv = 0;
    }

  long blockLength = (*datstart) + (nbpv*(datasize - PackStart) + 7)/8;
  blockLength += blockLength & 1;

  const long unused_bits = blockLength*8 - (*datstart)*8 - nbpv*(datasize - PackStart);

  Flag += (int)unused_bits;


  // Adjust number of bits per value if full integer length to avoid hitting most significant bit (sign bit).
  // if( nbpv == ibits ) nbpv = nbpv - 1;
  /*
    Calculate the binary scaling factor to spread the range of values over the number of bits per value.
    Limit scaling to 2**-126 to 2**127 (using IEEE 32-bit floatsas a guideline).
  */
  const double range = fabs(fmax - fmin);

  if ( fabs(fmin) < FLT_MIN ) fmin = 0;
  /*
    Have to allow tolerance in comparisons on some platforms (eg vpp700 and linux),
    such as 0.9999999999999999 = 1.0, to avoid clipping ranges which are a power of 2.
  */
  if ( range <= jpepsln )
    {
      binscale = 0;
    }
  else if ( IS_NOT_EQUAL(fmin, 0.0) && (fabs(range/fmin) <= jpepsln) )
    {
      binscale = 0;
    }
  else if ( fabs(range-1.0) <= jpepsln )
    {
      binscale = 1 - nbpv;
    }
  else if ( range > 1.0 )
    {
      const double rangec = range + jpepsln;
      double p2 = 2.0;
      int jloop = 1;
      while ( jloop < 128 && p2 <= rangec )
        {
          p2 *= 2.0;
          ++jloop;
        }
      if (jloop < 128)
        binscale = jloop - nbpv;
      else
        {
          gprintf(__func__, "Problem calculating binary scale value for encode code %d!", code);
          gprintf(__func__, "> range %g rangec %g fmin %g fmax %g", range, rangec, fmin, fmax);
          return (707);
        }
    }
  else
    {
      const double rangec = range - jpepsln;
      double p05 = 0.5;
      int jloop = 1;
      while ( jloop < 127 && p05 >= rangec )
	{
          p05 *= 0.5;
          jloop++;
	}
      if ( jloop < 127 )
	{
	  binscale = 1 - jloop - nbpv;
	}
      else
	{
	  gprintf(__func__, "Problem calculating binary scale value for encode code %d!", code);
	  gprintf(__func__, "< range %g rangec %g fmin %g fmax %g", range, rangec, fmin, fmax);
	  return (707);
	}
    }

  const uint64_t max_nbpv_pow2 = (uint64_t) ((1ULL << nbpv) - 1);

  if ( binscale != 0 )
    {
      while ( (uint64_t)(ldexp(range, -binscale)+0.5) > max_nbpv_pow2 ) binscale++;

      factor = (T)intpow2(-binscale);
    }

  ref2ibm(&zref, BitsPerInt);

  Put3Byte(blockLength);      //  0-2 Length of Block 4
  Put1Byte(Flag);             //  3   Flag & Unused bits
  if ( binscale < 0 ) binscale = 32768 - binscale;
  Put2Byte(binscale);         //  4-5 Scale factor
  Put1Real(zref);             //  6-9 Reference value
  Put1Byte(nbpv);             //   10 Packing size

  if ( lspherc )
    {
      if ( lcomplex )
	{
	  const int jup = isubset;
	  int ioff = (int)z + bds_ext;
	  if ( ioff > 0xFFFF ) ioff = 0;
	  Put2Byte(ioff);
	  Put2Int(isec4[16]);
	  Put1Byte(jup);
	  Put1Byte(jup);
	  Put1Byte(jup);
	  for (long i = 0; i < ((jup+1)*(jup+2)); ++i) Put1Real((double)(data[i]));
	}
      else
	{
	  Put1Real((double)(data[0]));
	}
    }

  *datsize  = ((datasize-PackStart)*nbpv + 7)/8;

#if  defined  (_ARCH_PWR6)
  TEMPLATE(encode_array_unrolled,T)(nbpv, (size_t)PackStart, (size_t)datasize, lGrib, data, (T)zref, factor, &z);
#else
  TEMPLATE(encode_array,T)(nbpv, (size_t)PackStart, (size_t)datasize, lGrib, data, (T)zref, factor, &z);
#endif

  if ( unused_bits >= 8 ) Put1Byte(0);  //  Fillbyte

  *gribLen = (long)z;

  return 0;
}


void TEMPLATE(grib_encode,T)(int *isec0, int *isec1, int *isec2, T *fsec2, int *isec3,
			     T *fsec3, int *isec4, T *fsec4, int klenp, int *kgrib,
			     int kleng, int *kword, int efunc, int *kret)
{
  long gribLen = 0; // Counter of GRIB length for output
  long fsec4size = 0;
  long datstart, datsize;

  UNUSED(isec3);
  UNUSED(efunc);

  grsdef();

  unsigned char *CGrib = (unsigned char *) kgrib;

  const bool gdsIncluded = ISEC1_Sec2Or3Flag & 128;
  const bool bmsIncluded = ISEC1_Sec2Or3Flag & 64;

  // set max header len
  size_t len = 16384;

  // add data len
  const size_t numBytes = (size_t)((ISEC4_NumBits+7)>>3);

  len += numBytes*(size_t)klenp;

  // add bitmap len
  if ( bmsIncluded ) len += (size_t)((klenp+7)>>3);

#ifdef VECTORCODE
  GRIBPACK *lGrib = (GRIBPACK*) Malloc(len*sizeof(GRIBPACK));
  if ( lGrib == NULL ) SysError("No Memory!");
#else
  GRIBPACK *lGrib = CGrib;
#endif

  const long isLen = 8;
  encodeIS(lGrib, &gribLen);
  GRIBPACK *lpds = &lGrib[isLen];
  const long pdsLen = getPdsLen(isec1);

  encodePDS(lpds, pdsLen,  isec1);
  gribLen += pdsLen;
  /*
  if ( ( isec4[3] == 64 ) && ( isec2[5] == 2 ) )
    {
      static bool lwarn_cplx = true;

      if ( lwarn_cplx )
	Message("Complex packing of spectral data unsupported, using simple packing!");

      isec2[5] = 1;
      isec4[3] = 0;

      lwarn_cplx = false;
    }
  */
  if ( gdsIncluded ) TEMPLATE(encodeGDS,T)(lGrib, &gribLen, isec2, fsec2);
  /*
    ----------------------------------------------------------------
    BMS Bit-Map Section Section (Section 3)
    ----------------------------------------------------------------
  */ 
  if ( bmsIncluded )
    {
      TEMPLATE(encodeBMS,T)(lGrib, &gribLen, fsec3, isec4, fsec4, &fsec4size);
    }
  else
    {
      fsec4size = ISEC4_NumValues;
    }

  const long bdsstart = gribLen;
  int status = TEMPLATE(encodeBDS,T)(lGrib, &gribLen, ISEC1_DecScaleFactor, isec2,
                                     isec4, fsec4size, fsec4, &datstart, &datsize, ISEC1_Parameter);
  if ( status )
    {
      *kret = status;
      return;
    }

  encodeES(lGrib, &gribLen, bdsstart);

  if ( (size_t) gribLen > (size_t)kleng*sizeof(int) )
    Error("kgrib buffer too small! kleng = %d  gribLen = %d", kleng, gribLen);

#ifdef VECTORCODE
  if ( (size_t) gribLen > len )
    Error("lGrib buffer too small! len = %d  gribLen = %d", len, gribLen);

  (void) PACK_GRIB(lGrib, (unsigned char *)CGrib, gribLen, -1L);

  Free(lGrib);
#endif

  ISEC0_GRIB_Len     = (int)gribLen;
  ISEC0_GRIB_Version = 1;

  *kword = (int)((gribLen + (long)sizeof(int) - 1) / (long)sizeof(int));

  *kret = status;
}

#endif /* T */

/*
 * Local Variables:
 * mode: c
 * End:
 */
// clang-format on

void encode_dummy(void);
void
encode_dummy(void)
{
  (void) encode_array_unrolled_double(0, 0, 0, NULL, NULL, 0, 0, NULL);
  (void) encode_array_unrolled_float(0, 0, 0, NULL, NULL, 0, 0, NULL);
}
static const char grb_libvers[] = "2.3.1";
const char *
cgribexLibraryVersion(void)
{
  return (grb_libvers);
}

#if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ > 5)
#pragma GCC diagnostic pop
#endif
#ifdef HAVE_CONFIG_H
#endif

#include <inttypes.h>
#include <stdlib.h>
#include <sys/types.h>
#ifdef WORDS_BIGENDIAN
#include <limits.h>
#endif


static const uint32_t crctab[]
    = { 0x00000000, 0x04c11db7, 0x09823b6e, 0x0d4326d9, 0x130476dc, 0x17c56b6b, 0x1a864db2, 0x1e475005, 0x2608edb8, 0x22c9f00f,
        0x2f8ad6d6, 0x2b4bcb61, 0x350c9b64, 0x31cd86d3, 0x3c8ea00a, 0x384fbdbd, 0x4c11db70, 0x48d0c6c7, 0x4593e01e, 0x4152fda9,
        0x5f15adac, 0x5bd4b01b, 0x569796c2, 0x52568b75, 0x6a1936c8, 0x6ed82b7f, 0x639b0da6, 0x675a1011, 0x791d4014, 0x7ddc5da3,
        0x709f7b7a, 0x745e66cd, 0x9823b6e0, 0x9ce2ab57, 0x91a18d8e, 0x95609039, 0x8b27c03c, 0x8fe6dd8b, 0x82a5fb52, 0x8664e6e5,
        0xbe2b5b58, 0xbaea46ef, 0xb7a96036, 0xb3687d81, 0xad2f2d84, 0xa9ee3033, 0xa4ad16ea, 0xa06c0b5d, 0xd4326d90, 0xd0f37027,
        0xddb056fe, 0xd9714b49, 0xc7361b4c, 0xc3f706fb, 0xceb42022, 0xca753d95, 0xf23a8028, 0xf6fb9d9f, 0xfbb8bb46, 0xff79a6f1,
        0xe13ef6f4, 0xe5ffeb43, 0xe8bccd9a, 0xec7dd02d, 0x34867077, 0x30476dc0, 0x3d044b19, 0x39c556ae, 0x278206ab, 0x23431b1c,
        0x2e003dc5, 0x2ac12072, 0x128e9dcf, 0x164f8078, 0x1b0ca6a1, 0x1fcdbb16, 0x018aeb13, 0x054bf6a4, 0x0808d07d, 0x0cc9cdca,
        0x7897ab07, 0x7c56b6b0, 0x71159069, 0x75d48dde, 0x6b93dddb, 0x6f52c06c, 0x6211e6b5, 0x66d0fb02, 0x5e9f46bf, 0x5a5e5b08,
        0x571d7dd1, 0x53dc6066, 0x4d9b3063, 0x495a2dd4, 0x44190b0d, 0x40d816ba, 0xaca5c697, 0xa864db20, 0xa527fdf9, 0xa1e6e04e,
        0xbfa1b04b, 0xbb60adfc, 0xb6238b25, 0xb2e29692, 0x8aad2b2f, 0x8e6c3698, 0x832f1041, 0x87ee0df6, 0x99a95df3, 0x9d684044,
        0x902b669d, 0x94ea7b2a, 0xe0b41de7, 0xe4750050, 0xe9362689, 0xedf73b3e, 0xf3b06b3b, 0xf771768c, 0xfa325055, 0xfef34de2,
        0xc6bcf05f, 0xc27dede8, 0xcf3ecb31, 0xcbffd686, 0xd5b88683, 0xd1799b34, 0xdc3abded, 0xd8fba05a, 0x690ce0ee, 0x6dcdfd59,
        0x608edb80, 0x644fc637, 0x7a089632, 0x7ec98b85, 0x738aad5c, 0x774bb0eb, 0x4f040d56, 0x4bc510e1, 0x46863638, 0x42472b8f,
        0x5c007b8a, 0x58c1663d, 0x558240e4, 0x51435d53, 0x251d3b9e, 0x21dc2629, 0x2c9f00f0, 0x285e1d47, 0x36194d42, 0x32d850f5,
        0x3f9b762c, 0x3b5a6b9b, 0x0315d626, 0x07d4cb91, 0x0a97ed48, 0x0e56f0ff, 0x1011a0fa, 0x14d0bd4d, 0x19939b94, 0x1d528623,
        0xf12f560e, 0xf5ee4bb9, 0xf8ad6d60, 0xfc6c70d7, 0xe22b20d2, 0xe6ea3d65, 0xeba91bbc, 0xef68060b, 0xd727bbb6, 0xd3e6a601,
        0xdea580d8, 0xda649d6f, 0xc423cd6a, 0xc0e2d0dd, 0xcda1f604, 0xc960ebb3, 0xbd3e8d7e, 0xb9ff90c9, 0xb4bcb610, 0xb07daba7,
        0xae3afba2, 0xaafbe615, 0xa7b8c0cc, 0xa379dd7b, 0x9b3660c6, 0x9ff77d71, 0x92b45ba8, 0x9675461f, 0x8832161a, 0x8cf30bad,
        0x81b02d74, 0x857130c3, 0x5d8a9099, 0x594b8d2e, 0x5408abf7, 0x50c9b640, 0x4e8ee645, 0x4a4ffbf2, 0x470cdd2b, 0x43cdc09c,
        0x7b827d21, 0x7f436096, 0x7200464f, 0x76c15bf8, 0x68860bfd, 0x6c47164a, 0x61043093, 0x65c52d24, 0x119b4be9, 0x155a565e,
        0x18197087, 0x1cd86d30, 0x029f3d35, 0x065e2082, 0x0b1d065b, 0x0fdc1bec, 0x3793a651, 0x3352bbe6, 0x3e119d3f, 0x3ad08088,
        0x2497d08d, 0x2056cd3a, 0x2d15ebe3, 0x29d4f654, 0xc5a92679, 0xc1683bce, 0xcc2b1d17, 0xc8ea00a0, 0xd6ad50a5, 0xd26c4d12,
        0xdf2f6bcb, 0xdbee767c, 0xe3a1cbc1, 0xe760d676, 0xea23f0af, 0xeee2ed18, 0xf0a5bd1d, 0xf464a0aa, 0xf9278673, 0xfde69bc4,
        0x89b8fd09, 0x8d79e0be, 0x803ac667, 0x84fbdbd0, 0x9abc8bd5, 0x9e7d9662, 0x933eb0bb, 0x97ffad0c, 0xafb010b1, 0xab710d06,
        0xa6322bdf, 0xa2f33668, 0xbcb4666d, 0xb8757bda, 0xb5365d03, 0xb1f740b4 };

uint32_t
memcrc(const unsigned char *b, size_t n)
{
  /*  Input arguments:
   *  const char*   b == byte sequence to checksum
   *  size_t        n == length of sequence
   */

  uint32_t s = 0;

  memcrc_r(&s, b, n);

  /* Extend with the length of the string. */
  while (n != 0)
  {
    register uint32_t c = n & 0377;
    n >>= 8;
    s = (s << 8) ^ crctab[(s >> 24) ^ c];
  }

  return ~s;
}

void
memcrc_r(uint32_t *state, const unsigned char *block, size_t block_len)
{
  /*  Input arguments:
   *  const char*   b == byte sequence to checksum
   *  size_t        n == length of sequence
   */

  register uint32_t c, s = *state;
  register size_t n = block_len;
  register const unsigned char *b = block;

  for (; n > 0; --n)
  {
    c = (uint32_t) (*b++);
    s = (s << 8) ^ crctab[(s >> 24) ^ c];
  }

  *state = s;
}

#ifdef WORDS_BIGENDIAN
#define SWAP_CSUM(BITWIDTH, BYTEWIDTH, NACC)                             \
  do {                                                                   \
    register const uint##BITWIDTH##_t *b = (uint##BITWIDTH##_t *) elems; \
    for (size_t i = 0; i < num_elems; ++i)                               \
    {                                                                    \
      for (size_t aofs = NACC; aofs > 0; --aofs)                         \
      {                                                                  \
        uint##BITWIDTH##_t accum = b[i + aofs - 1];                      \
        for (size_t j = 0; j < BYTEWIDTH; ++j)                           \
        {                                                                \
          uint32_t c = (uint32_t) (accum & UCHAR_MAX);                   \
          s = (s << 8) ^ crctab[(s >> 24) ^ c];                          \
          accum >>= 8;                                                   \
        }                                                                \
      }                                                                  \
    }                                                                    \
  } while (0)
#endif

/**
 *  Does endian-swapping prior to checksumming in case platform is big-endian
 *
 *  @param elems points to first first element with alignment elem_size
 *  @param num_elems number of elements to process
 *  @param elem_size size of each element in bytes
 */
void
memcrc_r_eswap(uint32_t *state, const unsigned char *elems, size_t num_elems, size_t elem_size)
{
#ifdef WORDS_BIGENDIAN
  register uint32_t s = *state;

  switch (elem_size)
  {
    case 1: memcrc_r(state, elems, num_elems * elem_size); return;
    case 2: SWAP_CSUM(16, 2, 1); break;
    case 4: SWAP_CSUM(32, 4, 1); break;
    case 8: SWAP_CSUM(64, 8, 1); break;
    case 16: SWAP_CSUM(64, 8, 2); break;
  }
  *state = s;
#else
  memcrc_r(state, elems, num_elems * elem_size);
#endif
}

uint32_t
memcrc_finish(uint32_t *state, off_t total_size)
{
  register uint32_t c, s = *state;
  register uint64_t n = (uint64_t) total_size;

  /* Extend with the length of the string. */
  while (n != 0)
  {
    c = n & 0377;
    n >>= 8;
    s = (s << 8) ^ crctab[(s >> 24) ^ c];
  }

  return ~s;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>
#include <errno.h>

#if !defined(HAVE_CONFIG_H) && !defined(HAVE_MALLOC_H) && defined(SX)
#define HAVE_MALLOC_H
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif


enum
{
  MALLOC_FUNC = 0,
  CALLOC_FUNC,
  REALLOC_FUNC,
  FREE_FUNC
};

static const char *const memfunc[] = { "Malloc", "Calloc", "Realloc", "Free" };

#undef MEM_UNDEFID
#define MEM_UNDEFID -1

#define MEM_MAXNAME 32 /* Min = 8, for  "unknown" ! */

static int dmemory_ExitOnError = 1;

typedef struct
{
  void *ptr;
  size_t size;
  size_t nobj;
  int item;
  int mtype;
  int line;
  char filename[MEM_MAXNAME];
  char functionname[MEM_MAXNAME];
} MemTable_t;

static MemTable_t *memTable;
static size_t memTableSize = 0;
static long memAccess = 0;

static size_t MemObjs = 0;
static size_t MaxMemObjs = 0;
static size_t MemUsed = 0;
static size_t MaxMemUsed = 0;

static int MEM_Debug = 0; /* If set to 1, debugging */
static int MEM_Info = 0;  /* If set to 1, print mem table at exit */

static const char *
get_filename(const char *file)
{
  const char *fnptr = strrchr(file, '/');
  if (fnptr)
    fnptr++;
  else
    fnptr = (char *) file;

  return fnptr;
}

void
memDebug(int debug)
{
  MEM_Debug = debug;
  if (MEM_Debug && !MEM_Info) MEM_Info = 1;
}

// If we're not using GNU C, elide __attribute__
#if !defined __GNUC__ && !defined __attribute__
#define __attribute__(x) /*NOTHING*/
#endif

static void memInternalProblem(const char *caller, const char *fmt, ...) __attribute__((noreturn));

static void memError(const char *caller, const char *file, int line, size_t size) __attribute__((noreturn));

static void
memInternalProblem(const char *caller, const char *fmt, ...)
{
  va_list args;
  va_start(args, fmt);

  printf("\n");
  fprintf(stderr, "Internal problem (%s) : ", caller);
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");

  va_end(args);

  exit(EXIT_FAILURE);
}

static void
memError(const char *caller, const char *file, int line, size_t size)
{
  fputs("\n", stdout);
  fprintf(stderr, "Error (%s) : Allocation of %zu bytes failed. [ line %d file %s ]\n", caller, size, line, get_filename(file));

  if (errno) perror("System error message ");

  exit(EXIT_FAILURE);
}

static void
memListPrintEntry(int mtype, int item, size_t size, void *ptr, const char *caller, const char *file, int line)
{
  fprintf(stderr, "[%-7s ", memfunc[mtype]);

  fprintf(stderr, "memory item %3d ", item);
  fprintf(stderr, "(%6zu byte) ", size);
  fprintf(stderr, "at %p", ptr);
  if (file != NULL)
  {
    fprintf(stderr, " line %4d", line);
    fprintf(stderr, " file %s", get_filename(file));
  }
  if (caller != NULL) fprintf(stderr, " (%s)", caller);
  fprintf(stderr, "]\n");
}

static void
memListPrintTable(void)
{
  if (MemObjs) fprintf(stderr, "\nMemory table:\n");

  for (size_t memID = 0; memID < memTableSize; memID++)
  {
    if (memTable[memID].item != MEM_UNDEFID)
      memListPrintEntry(memTable[memID].mtype, memTable[memID].item, memTable[memID].size * memTable[memID].nobj,
                        memTable[memID].ptr, memTable[memID].functionname, memTable[memID].filename, memTable[memID].line);
  }

  if (MemObjs)
  {
    fprintf(stderr, "  Memory access             : %6u\n", (unsigned) memAccess);
    fprintf(stderr, "  Maximum objects           : %6zu\n", memTableSize);
    fprintf(stderr, "  Objects used              : %6u\n", (unsigned) MaxMemObjs);
    fprintf(stderr, "  Objects in use            : %6u\n", (unsigned) MemObjs);
    fprintf(stderr, "  Memory allocated          : ");
    if (MemUsed > 1024 * 1024 * 1024)
      fprintf(stderr, " %5d GB\n", (int) (MemUsed / (1024 * 1024 * 1024)));
    else if (MemUsed > 1024 * 1024)
      fprintf(stderr, " %5d MB\n", (int) (MemUsed / (1024 * 1024)));
    else if (MemUsed > 1024)
      fprintf(stderr, " %5d KB\n", (int) (MemUsed / (1024)));
    else
      fprintf(stderr, " %5d Byte\n", (int) MemUsed);
  }

  if (MaxMemUsed)
  {
    fprintf(stderr, "  Maximum memory allocated  : ");
    if (MaxMemUsed > 1024 * 1024 * 1024)
      fprintf(stderr, " %5d GB\n", (int) (MaxMemUsed / (1024 * 1024 * 1024)));
    else if (MaxMemUsed > 1024 * 1024)
      fprintf(stderr, " %5d MB\n", (int) (MaxMemUsed / (1024 * 1024)));
    else if (MaxMemUsed > 1024)
      fprintf(stderr, " %5d KB\n", (int) (MaxMemUsed / (1024)));
    else
      fprintf(stderr, " %5d Byte\n", (int) MaxMemUsed);
  }
}

static void
memGetDebugLevel(void)
{
  const char *envstr = getenv("MEMORY_INFO");
  if (envstr && isdigit((int) envstr[0])) MEM_Info = atoi(envstr);

  envstr = getenv("MEMORY_DEBUG");
  if (envstr && isdigit((int) envstr[0])) MEM_Debug = atoi(envstr);

  if (MEM_Debug && !MEM_Info) MEM_Info = 1;

  if (MEM_Info) atexit(memListPrintTable);
}

static void
memInit(void)
{
  static int initDebugLevel = 0;

  if (!initDebugLevel)
  {
    memGetDebugLevel();
    initDebugLevel = 1;
  }
}

static int
memListDeleteEntry(void *ptr, size_t *size)
{
  int item = MEM_UNDEFID;
  size_t memID = 0;

  for (memID = 0; memID < memTableSize; memID++)
  {
    if (memTable[memID].item == MEM_UNDEFID) continue;
    if (memTable[memID].ptr == ptr) break;
  }

  if (memID != memTableSize)
  {
    MemObjs--;
    MemUsed -= memTable[memID].size * memTable[memID].nobj;
    *size = memTable[memID].size * memTable[memID].nobj;
    item = memTable[memID].item;
    memTable[memID].item = MEM_UNDEFID;
  }

  return item;
}

static void
memTableInitEntry(size_t memID)
{
  if (memID >= memTableSize) memInternalProblem(__func__, "memID %d undefined!", memID);

  memTable[memID].ptr = NULL;
  memTable[memID].item = MEM_UNDEFID;
  memTable[memID].size = 0;
  memTable[memID].nobj = 0;
  memTable[memID].mtype = MEM_UNDEFID;
  memTable[memID].line = MEM_UNDEFID;
}

static void
set_filename(const char *file, char *memEntyFilename)
{
  if (file)
  {
    const char *filename = get_filename(file);
    size_t len = strlen(filename);
    if (len > MEM_MAXNAME - 1) len = MEM_MAXNAME - 1;

    (void) memcpy(memEntyFilename, filename, len);
    memEntyFilename[len] = '\0';
  }
  else { (void) strcpy(memEntyFilename, "unknown"); }
}

static void
set_functionname(const char *functionname, char *memEntyFunctionname)
{
  if (functionname)
  {
    size_t len = strlen(functionname);
    if (len > MEM_MAXNAME - 1) len = MEM_MAXNAME - 1;

    (void) memcpy(memEntyFunctionname, functionname, len);
    memEntyFunctionname[len] = '\0';
  }
  else { (void) strcpy(memEntyFunctionname, "unknown"); }
}

static int
memListNewEntry(int mtype, void *ptr, size_t size, size_t nobj, const char *functionname, const char *file, int line)
{
  static int item = 0;
  size_t memID = 0;

  // Look for a free slot in memTable (Create the table the first time through).
  if (memTableSize == 0)
  {
    memTableSize = 8;
    size_t memSize = memTableSize * sizeof(MemTable_t);
    memTable = (MemTable_t *) malloc(memSize);
    if (memTable == NULL) memError(__func__, __FILE__, __LINE__, memSize);

    for (size_t i = 0; i < memTableSize; i++) memTableInitEntry(i);
  }
  else
  {
    while (memID < memTableSize)
    {
      if (memTable[memID].item == MEM_UNDEFID) break;
      memID++;
    }
  }

  // If the table overflows, double its size.
  if (memID == memTableSize)
  {
    memTableSize = 2 * memTableSize;
    size_t memSize = memTableSize * sizeof(MemTable_t);
    memTable = (MemTable_t *) realloc(memTable, memSize);
    if (memTable == NULL) memError(__func__, __FILE__, __LINE__, memSize);

    for (size_t i = memID; i < memTableSize; i++) memTableInitEntry(i);
  }

  memTable[memID].item = item;
  memTable[memID].ptr = ptr;
  memTable[memID].size = size;
  memTable[memID].nobj = nobj;
  memTable[memID].mtype = mtype;
  memTable[memID].line = line;

  set_filename(file, memTable[memID].filename);
  set_functionname(functionname, memTable[memID].functionname);

  MaxMemObjs++;
  MemObjs++;
  MemUsed += size * nobj;
  if (MemUsed > MaxMemUsed) MaxMemUsed = MemUsed;

  return item++;
}

static int
memListChangeEntry(intptr_t ptrold, void *ptr, size_t size, const char *functionname, const char *file, int line)
{
  int item = MEM_UNDEFID;
  size_t memID = 0;

  while (memID < memTableSize)
  {
    if (memTable[memID].item != MEM_UNDEFID && (intptr_t) memTable[memID].ptr == ptrold) break;
    memID++;
  }

  if (memID == memTableSize)
  {
    if ((void *) ptrold != NULL) memInternalProblem(__func__, "Item at %p not found.", ptrold);
  }
  else
  {
    item = memTable[memID].item;

    size_t sizeold = memTable[memID].size * memTable[memID].nobj;

    memTable[memID].ptr = ptr;
    memTable[memID].size = size;
    memTable[memID].nobj = 1;
    memTable[memID].mtype = REALLOC_FUNC;
    memTable[memID].line = line;

    set_filename(file, memTable[memID].filename);
    set_functionname(functionname, memTable[memID].functionname);

    MemUsed -= sizeold;
    MemUsed += size;
    if (MemUsed > MaxMemUsed) MaxMemUsed = MemUsed;
  }

  return item;
}

void *
memCalloc(size_t nobjs, size_t size, const char *file, const char *functionname, int line)
{
  void *ptr = NULL;

  memInit();

  if (nobjs * size > 0)
  {
    ptr = calloc(nobjs, size);

    if (MEM_Info)
    {
      memAccess++;

      int item = MEM_UNDEFID;
      if (ptr) item = memListNewEntry(CALLOC_FUNC, ptr, size, nobjs, functionname, file, line);

      if (MEM_Debug) memListPrintEntry(CALLOC_FUNC, item, size * nobjs, ptr, functionname, file, line);
    }

    if (ptr == NULL && dmemory_ExitOnError) memError(functionname, file, line, size * nobjs);
  }
  else
    fprintf(stderr, "Warning (%s) : Allocation of 0 bytes! [ line %d file %s ]\n", functionname, line, file);

  return ptr;
}

void *
memMalloc(size_t size, const char *file, const char *functionname, int line)
{
  void *ptr = NULL;

  memInit();

  if (size > 0)
  {
    ptr = malloc(size);

    if (MEM_Info)
    {
      memAccess++;

      int item = MEM_UNDEFID;
      if (ptr) item = memListNewEntry(MALLOC_FUNC, ptr, size, 1, functionname, file, line);

      if (MEM_Debug) memListPrintEntry(MALLOC_FUNC, item, size, ptr, functionname, file, line);
    }

    if (ptr == NULL && dmemory_ExitOnError) memError(functionname, file, line, size);
  }
  else
    fprintf(stderr, "Warning (%s) : Allocation of 0 bytes! [ line %d file %s ]\n", functionname, line, file);

  return ptr;
}

void *
memRealloc(void *ptrold, size_t size, const char *file, const char *functionname, int line)
{
  void *ptr = NULL;

  memInit();

  if (size > 0)
  {
    intptr_t ptrold_ = (intptr_t) ptrold;
    ptr = realloc(ptrold, size);

    if (MEM_Info)
    {
      memAccess++;

      int item = MEM_UNDEFID;
      if (ptr)
      {
        item = memListChangeEntry(ptrold_, ptr, size, functionname, file, line);
        if (item == MEM_UNDEFID) item = memListNewEntry(REALLOC_FUNC, ptr, size, 1, functionname, file, line);
      }

      if (MEM_Debug) memListPrintEntry(REALLOC_FUNC, item, size, ptr, functionname, file, line);
    }

    if (ptr == NULL && dmemory_ExitOnError) memError(functionname, file, line, size);
  }
  else
    fprintf(stderr, "Warning (%s) : Allocation of 0 bytes! [ line %d file %s ]\n", functionname, line, get_filename(file));

  return ptr;
}

void
memFree(void *ptr, const char *file, const char *functionname, int line)
{
  memInit();

  if (MEM_Info)
  {
    size_t size = 0;
    int item = memListDeleteEntry(ptr, &size);
    if (item >= 0)
    {
      if (MEM_Debug) memListPrintEntry(FREE_FUNC, item, size, ptr, functionname, file, line);
    }
    else
    {
      if (ptr && MEM_Debug)
        fprintf(stderr, "%s info: memory entry at %p not found. [line %4d file %s (%s)]\n", __func__, ptr, line, get_filename(file),
                functionname);
    }
  }

  free(ptr);
}

size_t
memTotal(void)
{
  size_t memtotal = 0;
#ifdef HAVE_MALLINFO
  struct mallinfo meminfo = mallinfo();
  if (MEM_Debug)
  {
    fprintf(stderr, "arena      %8zu (non-mmapped space allocated from system)\n", (size_t) meminfo.arena);
    fprintf(stderr, "ordblks    %8zu (number of free chunks)\n", (size_t) meminfo.ordblks);
    fprintf(stderr, "smblks     %8zu (number of fastbin blocks)\n", (size_t) meminfo.smblks);
    fprintf(stderr, "hblks      %8zu (number of mmapped regions)\n", (size_t) meminfo.hblks);
    fprintf(stderr, "hblkhd     %8zu (space in mmapped regions)\n", (size_t) meminfo.hblkhd);
    fprintf(stderr, "usmblks    %8zu (maximum total allocated space)\n", (size_t) meminfo.usmblks);
    fprintf(stderr, "fsmblks    %8zu (maximum total allocated space)\n", (size_t) meminfo.fsmblks);
    fprintf(stderr, "uordblks   %8zu (total allocated space)\n", (size_t) meminfo.uordblks);
    fprintf(stderr, "fordblks   %8zu (total free space)\n", (size_t) meminfo.fordblks);
    fprintf(stderr, "Memory in use:   %8zu bytes\n", (size_t) meminfo.usmblks + (size_t) meminfo.uordblks);
    fprintf(stderr, "Total heap size: %8zu bytes\n", (size_t) meminfo.arena);

    // malloc_stats();
  }

  memtotal = (size_t) meminfo.arena;
#endif

  return memtotal;
}

void
memExitOnError(void)
{
  dmemory_ExitOnError = 1;
}
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>

#if !defined(NAMESPACE_H)
#endif

int _ExitOnError = 1;  // If set to 1, exit on error
int _Verbose = 1;      // If set to 1, errors are reported
int _Debug = 0;        // If set to 1, debugging

/* If we're not using GNU C, elide __attribute__ */
#if !defined __GNUC__ && !defined __attribute__
#define __attribute__(x) /*NOTHING*/
#endif

void SysError_(const char *caller, const char *fmt, ...) __attribute__((noreturn));

void
SysError_(const char *caller, const char *fmt, ...)
{
  va_list args;
  int saved_errno = errno;

  va_start(args, fmt);

  printf("\n");
  fprintf(stderr, "%s  error (%s): ", PACKAGE_NAME, caller);
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");

  va_end(args);

  if (saved_errno)
  {
    errno = saved_errno;
    perror("System error message");
  }

  exit(EXIT_FAILURE);
}

void
Error_(const char *caller, const char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);

  printf("\n");
  fprintf(stderr, "%s  error (%s): ", PACKAGE_NAME, caller);
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");

  va_end(args);

  if (_ExitOnError) exit(EXIT_FAILURE);
}

typedef void (*cdiAbortCFunc)(const char *caller, const char *filename, const char *functionname, int line, const char *errorString,
                              va_list ap)
#ifdef __GNUC__
    __attribute__((noreturn))
#endif
    ;

void
cdiAbortC(const char *caller, const char *filename, const char *functionname, int line, const char *errorString, ...)
{
  va_list ap;
  va_start(ap, errorString);
  cdiAbortCFunc cdiAbortC_p = (cdiAbortCFunc) namespaceSwitchGet(NSSWITCH_ABORT).func;
  cdiAbortC_p(caller, filename, functionname, line, errorString, ap);
  va_end(ap);
}

void
cdiAbortC_serial(const char *caller, const char *filename, const char *functionname, int line, const char *errorString, va_list ap)
{
  fprintf(stderr, "%s  error, %s, %s, line %d%s%s\nerrorString: \"", PACKAGE_NAME, functionname, filename, line,
          caller ? ", called from " : "", caller ? caller : "");
  vfprintf(stderr, errorString, ap);
  fputs("\"\n", stderr);
  exit(EXIT_FAILURE);
}

typedef void (*cdiWarningFunc)(const char *caller, const char *fmt, va_list ap);

void
Warning_(const char *caller, const char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);

  if (_Verbose)
  {
    cdiWarningFunc cdiWarning_p = (cdiWarningFunc) namespaceSwitchGet(NSSWITCH_WARNING).func;
    cdiWarning_p(caller, fmt, args);
  }

  va_end(args);
}

void
cdiWarning(const char *caller, const char *fmt, va_list ap)
{
  fprintf(stderr, "%s  warning (%s): ", PACKAGE_NAME, caller);
  vfprintf(stderr, fmt, ap);
  fputc('\n', stderr);
}

void
Message_(const char *caller, const char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);

  fprintf(stdout, "%s  %-18s: ", PACKAGE_NAME, caller);
  vfprintf(stdout, fmt, args);
  fprintf(stdout, "\n");

  va_end(args);
}

bool
cdiObsoleteInfo(const char *oldFunction, const char *newFunction)
{
  fprintf(stdout, "cdi info: Function %s() is deprecated and might be removed in the future versions of CDI.\n", oldFunction);
  fprintf(stdout, "cdi info:    Consider switching to the new function %s() as soon as possible.\n", newFunction);
  return false;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef EXSE_H
#define EXSE_H

enum
{
  EXSE_PREC_FP16 = 2,
  EXSE_PREC_FP32 = 4,
  EXSE_PREC_FP64 = 8,
};

#endif
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stdio.h>
#include <string.h>
#include <ctype.h>


enum
{
  EXT_HEADER_LEN = 4,
};

union EXT_HEADER
{
  int32_t i32[EXT_HEADER_LEN];
  int64_t i64[EXT_HEADER_LEN];
};

static int initExtLib = 0;
static int extDefaultPrec = 0;
static int extDefaultNumber = EXT_REAL;

// A version string.
#undef LIBVERSION
#define LIBVERSION 2.0.0
#define XSTRING(x) #x
#define STRING(x) XSTRING(x)
static const char ext_libvers[] = STRING(LIBVERSION);

const char *
extLibraryVersion(void)
{
  return ext_libvers;
}

static int EXT_Debug = 0;  // If set to 1, debugging

void
extDebug(int debug)
{
  if (debug) Message("debug level %d", debug);
  EXT_Debug = debug;
}

static void
extLibInit(void)
{
  const char *envName = "EXT_PRECISION";

  char *envString = getenv(envName);
  if (envString)
  {
    if (strlen(envString) == 2)
    {
      switch (tolower((int) envString[0]))
      {
        case 'r':
        {
          extDefaultNumber = EXT_REAL;
          switch ((int) envString[1])
          {
            case '2': extDefaultPrec = EXSE_PREC_FP16; break;
            case '4': extDefaultPrec = EXSE_PREC_FP32; break;
            case '8': extDefaultPrec = EXSE_PREC_FP64; break;
            default: Warning("Invalid digit in %s: %s", envName, envString);
          }
          break;
        }
        case 'c':
        {
          extDefaultNumber = EXT_COMP;
          switch ((int) envString[1])
          {
            case '4': extDefaultPrec = EXSE_PREC_FP32; break;
            case '8': extDefaultPrec = EXSE_PREC_FP64; break;
            default: Warning("Invalid digit in %s: %s", envName, envString);
          }
          break;
        }
        default:
        {
          Warning("Invalid character in %s: %s", envName, envString);
          break;
        }
      }
    }
  }

  initExtLib = 1;
}

static void
extInit(extrec_t *extp)
{
  extp->checked = 0;
  extp->byteswap = 0;
  extp->prec = 0;
  extp->number = extDefaultNumber;
  extp->datasize = 0;
  extp->buffersize = 0;
  extp->buffer = NULL;
}

void *
extNew(void)
{
  if (!initExtLib) extLibInit();

  extrec_t *extp = (extrec_t *) Malloc(sizeof(extrec_t));

  extInit(extp);

  return (void *) extp;
}

void
extDelete(void *ext)
{
  extrec_t *extp = (extrec_t *) ext;

  if (extp)
  {
    if (extp->buffer) Free(extp->buffer);
    Free(extp);
  }
}

int
extCheckFiletype(int fileID, int *swap)
{
  size_t fact = 0;
  size_t data = 0;
  size_t dimxy = 0;
  unsigned char buffer[40], *pbuf;

  if (fileRead(fileID, buffer, 4) != 4) return 0;

  size_t blocklen = (size_t) get_uint32(buffer);
  size_t sblocklen = (size_t) get_swap_uint32(buffer);

  if (EXT_Debug) Message("blocklen = %d sblocklen = %d", blocklen, sblocklen);

  // clang-format off
  if (blocklen == 16)
    {
     *swap = 0;
      fact = blocklen / 4;
      if (fileRead(fileID, buffer, blocklen+8) != blocklen+8) return 0;
      pbuf = buffer+3*fact;      dimxy = (size_t) get_uint32(pbuf);
      pbuf = buffer+blocklen+4;  data  = (size_t) get_uint32(pbuf);
    }
  else if (blocklen == 32)
    {
     *swap = 0;
      fact = blocklen / 4;
      if (fileRead(fileID, buffer, blocklen+8) != blocklen+8) return 0;
      pbuf = buffer+3*fact;      dimxy = (size_t) get_uint64(pbuf);
      pbuf = buffer+blocklen+4;  data  = (size_t) get_uint32(pbuf);
    }
  else if (sblocklen == 16)
    {
     *swap = 1;
      fact = sblocklen / 4;
      if (fileRead(fileID, buffer, sblocklen+8) != sblocklen+8) return 0;
      pbuf = buffer+3*fact;       dimxy = (size_t) get_swap_uint32(pbuf);
      pbuf = buffer+sblocklen+4;  data  = (size_t) get_swap_uint32(pbuf);
    }
  else if (sblocklen == 32)
    {
     *swap = 1;
      fact = sblocklen / 4;
      if (fileRead(fileID, buffer, sblocklen+8) != sblocklen+8) return 0;
      pbuf = buffer+3*fact;       dimxy = (size_t) get_swap_uint64(pbuf);
      pbuf = buffer+sblocklen+4;  data  = (size_t) get_swap_uint32(pbuf);
    }
  // clang-format on

  fileRewind(fileID);

  if (EXT_Debug) Message("swap = %d fact = %d", *swap, fact);
  if (EXT_Debug) Message("dimxy = %lu data = %lu", dimxy, data);

  int found = data && (dimxy * fact == data || dimxy * fact * 2 == data || dimxy * fact / 2 == data);
  return found;
}

int
extInqHeader(void *ext, int *header)
{
  extrec_t *extp = (extrec_t *) ext;

  for (int i = 0; i < EXT_HEADER_LEN; i++) header[i] = extp->header[i];

  if (EXT_Debug) Message("datasize = %zu", extp->datasize);

  return 0;
}

int
extDefHeader(void *ext, const int *header)
{
  extrec_t *extp = (extrec_t *) ext;

  for (int i = 0; i < EXT_HEADER_LEN; i++) extp->header[i] = header[i];

  extp->datasize = (size_t) header[3];
  if (extp->number == EXT_COMP) extp->datasize *= 2;

  if (EXT_Debug) Message("datasize = %zu", extp->datasize);

  return 0;
}

static int
extInqData(extrec_t *extp, int prec, void *data)
{
  int ierr = 0;
  int byteswap = extp->byteswap;
  size_t datasize = extp->datasize, buffer_size = datasize * (size_t) prec;
  void *buffer = extp->buffer;
  int rprec = extp->prec;

  switch (rprec)
  {
    case EXSE_PREC_FP32:
    {
      if (byteswap) swap4byte(buffer, datasize);

      if (EXSE_PREC_FP32 == prec)
        memcpy(data, buffer, buffer_size);
      else if (EXSE_PREC_FP64 == prec)
        for (size_t i = 0; i < datasize; ++i) ((double *) data)[i] = (double) ((float *) buffer)[i];
#ifdef HAVE__FLOAT16
      else if (EXSE_PREC_FP16 == prec)
        for (size_t i = 0; i < datasize; ++i) ((_Float16 *) data)[i] = (_Float16) ((float *) buffer)[i];
#endif
      break;
    }
    case EXSE_PREC_FP64:
    {
      if (byteswap) swap8byte(buffer, datasize);

      if (EXSE_PREC_FP64 == prec)
        memcpy(data, buffer, buffer_size);
      else if (EXSE_PREC_FP32 == prec)
        for (size_t i = 0; i < datasize; ++i) ((float *) data)[i] = (float) ((double *) buffer)[i];
#ifdef HAVE__FLOAT16
      else if (EXSE_PREC_FP16 == prec)
        for (size_t i = 0; i < datasize; ++i) ((_Float16 *) data)[i] = (_Float16) ((double *) buffer)[i];
#endif
      break;
    }
#ifdef HAVE__FLOAT16
    case EXSE_PREC_FP16:
    {
      if (EXSE_PREC_FP16 == prec)
        memcpy(data, buffer, buffer_size);
      else if (EXSE_PREC_FP64 == prec)
        for (size_t i = 0; i < datasize; ++i) ((double *) data)[i] = (double) ((_Float16 *) buffer)[i];
      else if (EXSE_PREC_FP32 == prec)
        for (size_t i = 0; i < datasize; ++i) ((float *) data)[i] = (float) ((_Float16 *) buffer)[i];

      break;
    }
#endif
    default:
    {
      Error("unexpected data precision %d", rprec);
      break;
    }
  }

  return ierr;
}

int
extInqDataFP32(void *ext, float *data)
{
  return extInqData((extrec_t *) ext, EXSE_PREC_FP32, (void *) data);
}

int
extInqDataFP64(void *ext, double *data)
{
  return extInqData((extrec_t *) ext, EXSE_PREC_FP64, (void *) data);
}
#ifdef HAVE__FLOAT16
int
extInqDataFP16(void *ext, _Float16 *data)
{
  return extInqData((extrec_t *) ext, EXSE_PREC_FP16, (void *) data);
}
#endif

static int
extDefData(void *ext, int prec, const void *data)
{
  extrec_t *extp = (extrec_t *) ext;

  int rprec = extDefaultPrec ? extDefaultPrec : extp->prec;
  extp->prec = rprec ? rprec : prec;

  int *header = extp->header;

  size_t datasize = (size_t) header[3];
  if (extp->number == EXT_COMP) datasize *= 2;
  size_t blocklen = datasize * (size_t) rprec;

  extp->datasize = datasize;

  if (extp->buffersize != blocklen)
  {
    extp->buffersize = blocklen;
    extp->buffer = Realloc(extp->buffer, extp->buffersize);
  }

  switch (rprec)
  {
    case EXSE_PREC_FP32:
    {
      if (EXSE_PREC_FP32 == prec)
        memcpy(extp->buffer, data, blocklen);
      else if (EXSE_PREC_FP64 == prec)
        for (size_t i = 0; i < datasize; i++) ((float *) extp->buffer)[i] = (float) ((double *) data)[i];
#ifdef HAVE__FLOAT16
      else if (EXSE_PREC_FP16 == prec)
        for (size_t i = 0; i < datasize; i++) ((float *) extp->buffer)[i] = (float) ((_Float16 *) data)[i];
#endif
      break;
    }
    case EXSE_PREC_FP64:
    {
      if (EXSE_PREC_FP64 == prec)
        memcpy(extp->buffer, data, blocklen);
      else if (EXSE_PREC_FP32 == prec)
        for (size_t i = 0; i < datasize; i++) ((double *) extp->buffer)[i] = (double) ((float *) data)[i];
#ifdef HAVE__FLOAT16
      else if (EXSE_PREC_FP16 == prec)
        for (size_t i = 0; i < datasize; i++) ((double *) extp->buffer)[i] = (double) ((_Float16 *) data)[i];
#endif
      break;
    }
#ifdef HAVE__FLOAT16
    case EXSE_PREC_FP16:
    {
      if (EXSE_PREC_FP16 == prec)
        memcpy(extp->buffer, data, blocklen);
      else if (EXSE_PREC_FP32 == prec)
        for (size_t i = 0; i < datasize; i++) ((_Float16 *) extp->buffer)[i] = (_Float16) ((float *) data)[i];
      else if (EXSE_PREC_FP64 == prec)
        for (size_t i = 0; i < datasize; i++) ((_Float16 *) extp->buffer)[i] = (_Float16) ((double *) data)[i];

      break;
    }
#endif
    default:
    {
      Error("unexpected data precision %d", rprec);
      break;
    }
  }

  return 0;
}

int
extDefDataFP32(void *ext, const float *data)
{
  return extDefData(ext, EXSE_PREC_FP32, (void *) data);
}

int
extDefDataFP64(void *ext, const double *data)
{
  return extDefData(ext, EXSE_PREC_FP64, (void *) data);
}
#ifdef HAVE__FLOAT16
int
extDefDataFP16(void *ext, const _Float16 *data)
{
  return extDefData(ext, EXSE_PREC_FP16, (void *) data);
}
#endif

int
extRead(int fileID, void *ext)
{
  extrec_t *extp = (extrec_t *) ext;

  if (!extp->checked)
  {
    int status = extCheckFiletype(fileID, &extp->byteswap);
    if (status == 0) Error("Not a EXTRA file!");
    extp->checked = 1;
  }

  int byteswap = extp->byteswap;

  // read header record
  size_t blocklen = binReadF77Block(fileID, byteswap);

  if (fileEOF(fileID)) return -1;

  if (EXT_Debug) Message("blocklen = %lu", blocklen);

  size_t hprec = blocklen / EXT_HEADER_LEN;
  // extp->prec = (int) hprec;

  union EXT_HEADER tempheader;
  switch (hprec)
  {
    case EXSE_PREC_FP32:
    case EXSE_PREC_FP16:
    {
      binReadInt32(fileID, byteswap, EXT_HEADER_LEN, tempheader.i32);
      for (int i = 0; i < EXT_HEADER_LEN; i++) extp->header[i] = (int) tempheader.i32[i];
      break;
    }
    case EXSE_PREC_FP64:
    {
      binReadInt64(fileID, byteswap, EXT_HEADER_LEN, tempheader.i64);
      for (int i = 0; i < EXT_HEADER_LEN; i++) extp->header[i] = (int) tempheader.i64[i];
      break;
    }
    default:
    {
      Error("Unexpected header precision %d", hprec);
      break;
    }
  }

  size_t blocklen2 = binReadF77Block(fileID, byteswap);

  if (blocklen2 != blocklen)
  {
    Warning("Header blocklen differ (blocklen1=%d; blocklen2=%d)!", blocklen, blocklen2);
    if (blocklen2 != 0) return -1;
  }

  extp->datasize = (size_t) extp->header[3];

  if (EXT_Debug) Message("datasize = %zu", extp->datasize);

  blocklen = binReadF77Block(fileID, byteswap);

  if (extp->buffersize < blocklen)
  {
    extp->buffersize = blocklen;
    extp->buffer = Realloc(extp->buffer, extp->buffersize);
  }

  size_t dprec = blocklen / extp->datasize;
  extp->prec = (int) dprec;

  if (dprec == hprec || dprec == hprec / 2) { extp->number = EXT_REAL; }
  else if (dprec == hprec * 2)
  {
    dprec /= 2;
    extp->datasize *= 2;
    extp->number = EXT_COMP;
  }

  if (dprec != EXSE_PREC_FP32 && dprec != EXSE_PREC_FP64 && dprec != EXSE_PREC_FP16)
  {
    Warning("Unexpected data precision %d", dprec);
    return -1;
  }

  fileRead(fileID, extp->buffer, blocklen);

  blocklen2 = binReadF77Block(fileID, byteswap);

  if (blocklen2 != blocklen)
  {
    Warning("Data blocklen differ (blocklen1=%d; blocklen2=%d)!", blocklen, blocklen2);
    if (blocklen2 != 0) return -1;
  }

  return 0;
}

int
extWrite(int fileID, void *ext)
{
  extrec_t *extp = (extrec_t *) ext;
  union EXT_HEADER tempheader;
  int byteswap = extp->byteswap;
  int rprec = extp->prec;
  int number = extp->number;
  int *header = extp->header;

  // write header record
  size_t blocklen = EXT_HEADER_LEN * (size_t) ((rprec == EXSE_PREC_FP16) ? EXSE_PREC_FP32 : rprec);

  binWriteF77Block(fileID, byteswap, blocklen);

  switch (rprec)
  {
    case EXSE_PREC_FP16:
    case EXSE_PREC_FP32:
    {
      for (int i = 0; i < EXT_HEADER_LEN; i++) tempheader.i32[i] = (int32_t) header[i];
      binWriteInt32(fileID, byteswap, EXT_HEADER_LEN, tempheader.i32);
      break;
    }
    case EXSE_PREC_FP64:
    {
      for (int i = 0; i < EXT_HEADER_LEN; i++) tempheader.i64[i] = (int64_t) header[i];
      binWriteInt64(fileID, byteswap, EXT_HEADER_LEN, tempheader.i64);
      break;
    }
    default:
    {
      Error("unexpected header precision %d", rprec);
      break;
    }
  }

  binWriteF77Block(fileID, byteswap, blocklen);

  extp->datasize = (size_t) header[3];
  if (number == EXT_COMP) extp->datasize *= 2;
  blocklen = extp->datasize * (size_t) rprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  switch (rprec)
  {
#ifdef HAVE__FLOAT16
    case EXSE_PREC_FP16:
    {
      binWriteFlt16(fileID, extp->datasize, (_Float16 *) extp->buffer);
      break;
    }
#endif
    case EXSE_PREC_FP32:
    {
      binWriteFlt32(fileID, byteswap, extp->datasize, (float *) extp->buffer);
      break;
    }
    case EXSE_PREC_FP64:
    {
      binWriteFlt64(fileID, byteswap, extp->datasize, (double *) extp->buffer);
      break;
    }
    default:
    {
      Error("unexpected data precision %d", rprec);
      break;
    }
  }

  binWriteF77Block(fileID, byteswap, blocklen);

  return 0;
}
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
// strdup() from string.h
#ifdef __STDC_ALLOC_LIB__
#define __STDC_WANT_LIB_EXT2__ 1
#else
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 200809L
#endif

#ifdef HAVE_CONFIG_H
#endif

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>

// On Windows, define ssize_t manually
#ifdef _WIN32
#define ssize_t __int64
#include <io.h>
#else
#include <unistd.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>  // gettimeofday()
#endif


#ifdef CDI
#endif

#ifndef O_BINARY
#define O_BINARY 0
#endif

#ifdef HAVE_MMAP
#include <sys/mman.h>  // mmap() is defined in this header
#endif

#ifndef SSIZE_MAX
#define SSIZE_MAX LONG_MAX
#endif

#define MAX_FILES 8192
static int _file_max = MAX_FILES;

static void file_initialize(void);

static bool _file_init = false;

#ifdef HAVE_LIBPTHREAD
#include <pthread.h>

static pthread_once_t _file_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _file_mutex = PTHREAD_MUTEX_INITIALIZER;

#define FILE_LOCK() pthread_mutex_lock(&_file_mutex)
#define FILE_UNLOCK() pthread_mutex_unlock(&_file_mutex)
#define FILE_INIT() \
  if (_file_init == false) pthread_once(&_file_init_thread, file_initialize)

#else

#define FILE_LOCK()
#define FILE_UNLOCK()
#define FILE_INIT() \
  if (_file_init == false) file_initialize()
#endif

typedef struct
{
  int self;
  int flag;            // access and error flag
  int eof;             // end of file flag
  int fd;              // file descriptor used for read
  FILE *fp;            // FILE pointer used for write
  char *name;          // file name
  off_t size;          // file size
  off_t position;      // file position
  long access;         // file access
  off_t byteTrans;     //
  size_t blockSize;    // file block size
  int mode;            // file access mode
  int type;            // file type [1:open  2:fopen]
  int bufferType;      // buffer type [1:std  2:mmap]
  size_t bufferSize;   // file buffer size
  size_t mappedSize;   // mmap buffer size
  char *buffer;        // file buffer
  long bufferNumFill;  // number of buffer fill
  char *bufferPtr;     // file buffer pointer
  off_t bufferPos;
  off_t bufferStart;
  off_t bufferEnd;
  size_t bufferCnt;
  double time_in_sec;
} bfile_t;

enum FILE_Flags
{
  FILE_EOF = 010,
  FILE_ERROR = 020
};

#ifndef MIN_BUF_SIZE
#define MIN_BUF_SIZE 131072L
#endif

static const char *fbtname[] = { "unknown", "standard", "mmap" };
static const char *ftname[] = { "unknown", "open", "fopen" };

static size_t FileBufferSizeMin = MIN_BUF_SIZE;
static long FileBufferSizeEnv = -1;
static int FileBufferTypeEnv = 0;

static int FileTypeRead = FILE_TYPE_OPEN;
static int FileTypeWrite = FILE_TYPE_FOPEN;
static int FileFlagWrite = 0;

static int FileDebug = 0;  // If set to 1, debugging
static bool FileInfo = false;

static void file_table_print(void);

// A version string.
#undef LIBVERSION
#define LIBVERSION 1.9.1
#define XSTRING(x) #x
#define STRING(x) XSTRING(x)
static const char file_libvers[] = STRING(LIBVERSION);

/*
  21/05/2004  1.3.2 set min I/O Buffersize to 128k
  31/05/2005  1.4.0 replace fileTable by _fileList
  26/08/2005  1.4.1 fileClose with return value
                    checks for all fileptr
  01/09/2005  1.5.0 thread safe version
  06/11/2005  1.5.1 add filePtrEOF, filePtr, filePtrGetc
  03/02/2006  1.5.2 ansi C: define getpagesize and strdupx
  27/12/2007  1.6.0 add FILE_TYPE_FOPEN
  24/03/2008  1.6.1 add O_BINARY if available
                    remove default HAVE_MMAP
                    use HAVE_STRUCT_STAT_ST_BLKSIZE
  22/08/2010  1.7.0 refactor
  11/11/2010  1.7.1 update for changed interface of error.h
  02/02/2012  1.8.0 cleanup
  16/11/2012  1.8.1 added support for unbuffered write
  27/06/2013  1.8.2 added env. var. FILE_TYPE_WRITE (1:open; 2:fopen)
  29/04/2020  1.9.0 fileSetPos(): refactored
  30/04/2020  1.9.1 fileSetPos(): not initialized correctly (bug fix)
 */

typedef struct _filePtrToIdx
{
  int idx;
  bfile_t *ptr;
  struct _filePtrToIdx *next;
} filePtrToIdx;

static filePtrToIdx *_fileList = NULL;
static filePtrToIdx *_fileAvail = NULL;

static void
file_list_new(void)
{
  assert(_fileList == NULL);

  _fileList = (filePtrToIdx *) malloc((size_t) _file_max * sizeof(filePtrToIdx));
}

static void
file_list_delete(void)
{
  if (_fileList)
  {
    free(_fileList);
    _fileList = NULL;
  }
}

static void
file_init_pointer(void)
{
  for (int i = 0; i < _file_max; i++)
  {
    _fileList[i].next = _fileList + i + 1;
    _fileList[i].idx = i;
    _fileList[i].ptr = 0;
  }

  _fileList[_file_max - 1].next = 0;

  _fileAvail = _fileList;
}

static bfile_t *
file_to_pointer(int idx)
{
  bfile_t *fileptr = NULL;

  FILE_INIT();

  if (idx >= 0 && idx < _file_max)
  {
    FILE_LOCK();
    fileptr = _fileList[idx].ptr;
    FILE_UNLOCK();
  }
  else
    Error("file index %d undefined!", idx);

  return fileptr;
}

// Create an index from a pointer
static int
file_from_pointer(bfile_t *ptr)
{
  int idx = -1;

  if (ptr)
  {
    FILE_LOCK();

    if (_fileAvail)
    {
      filePtrToIdx *newptr = _fileAvail;
      _fileAvail = _fileAvail->next;
      newptr->next = 0;
      idx = newptr->idx;
      newptr->ptr = ptr;

      if (FileDebug) Message("Pointer %p has idx %d from file list", ptr, idx);
    }
    else
    {
      Warning("Too many open files (limit is %d)!", _file_max);
      idx = -2;
    }

    FILE_UNLOCK();
  }
  else
    Error("Internal problem (pointer %p undefined)", ptr);

  return idx;
}

static void
file_init_entry(bfile_t *fileptr)
{
  fileptr->self = file_from_pointer(fileptr);

  fileptr->flag = 0;
  fileptr->fd = -1;
  fileptr->fp = NULL;
  fileptr->mode = 0;
  fileptr->size = 0;
  fileptr->name = NULL;
  fileptr->access = 0;
  fileptr->position = 0;
  fileptr->byteTrans = 0;
  fileptr->type = 0;
  fileptr->bufferType = 0;
  fileptr->bufferSize = 0;
  fileptr->mappedSize = 0;
  fileptr->buffer = NULL;
  fileptr->bufferNumFill = 0;
  fileptr->bufferStart = 0;
  fileptr->bufferEnd = -1;
  fileptr->bufferPos = 0;
  fileptr->bufferCnt = 0;
  fileptr->bufferPtr = NULL;
  fileptr->time_in_sec = 0.0;
}

static bfile_t *
file_new_entry(void)
{
  bfile_t *fileptr = (bfile_t *) malloc(sizeof(bfile_t));
  if (fileptr) file_init_entry(fileptr);
  return fileptr;
}

static void
file_delete_entry(bfile_t *fileptr)
{
  int idx = fileptr->self;

  FILE_LOCK();

  free(fileptr);

  _fileList[idx].next = _fileAvail;
  _fileList[idx].ptr = 0;
  _fileAvail = &_fileList[idx];

  FILE_UNLOCK();

  if (FileDebug) Message("Removed idx %d from file list", idx);
}

const char *
fileLibraryVersion(void)
{
  return file_libvers;
}

static int
file_pagesize(void)
{
#ifdef _SC_PAGESIZE
  return (int) sysconf(_SC_PAGESIZE);
#else
#ifndef POSIXIO_DEFAULT_PAGESIZE
#define POSIXIO_DEFAULT_PAGESIZE 4096
#endif
  return (int) POSIXIO_DEFAULT_PAGESIZE;
#endif
}

static double
file_time(void)
{
#ifdef HAVE_SYS_TIME_H
  struct timeval mytime;
  gettimeofday(&mytime, NULL);
  return (double) mytime.tv_sec + (double) mytime.tv_usec * 1.0e-6;
#else
  return 0;
#endif
}

void
fileDebug(int debug)
{
  FileDebug = debug;
  if (FileDebug) Message("Debug level %d", debug);
}

void *
filePtr(int fileID)
{
  return (void *) file_to_pointer(fileID);
}

static void
file_pointer_info(const char *caller, int fileID)
{
  if (FileDebug)
  {
    fprintf(stdout, "%-18s : ", caller);
    fprintf(stdout, "The fileID %d underlying pointer is not valid!", fileID);
    fprintf(stdout, "\n");
  }
}

int
fileSetBufferType(int fileID, int type)
{
  int ret = 0;

  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr)
  {
    switch (type)
    {
      case FILE_BUFTYPE_STD:
      case FILE_BUFTYPE_MMAP: fileptr->bufferType = type; break;
      default: Error("File type %d not implemented!", type);
    }
  }

#ifndef HAVE_MMAP
  if (type == FILE_BUFTYPE_MMAP) ret = 1;
#endif

  return ret;
}

int
fileFlush(int fileID)
{
  int retval = 0;
  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr)
  {
    FILE *fp = fileptr->fp;
    retval = fflush(fp);
    if (retval == 0) retval = fflush(fp);
    if (retval != 0) retval = errno;
  }

  return retval;
}

void
fileClearerr(int fileID)
{
  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr)
  {
    if (fileptr->mode != 'r') clearerr(fileptr->fp);
  }
}

int
filePtrEOF(void *vfileptr)
{
  bfile_t *fileptr = (bfile_t *) vfileptr;
  return fileptr ? (fileptr->flag & FILE_EOF) != 0 : 0;
}

int
fileEOF(int fileID)
{
  bfile_t *fileptr = file_to_pointer(fileID);
  return fileptr ? (fileptr->flag & FILE_EOF) != 0 : 0;
}

void
fileRewind(int fileID)
{
  fileSetPos(fileID, (off_t) 0, SEEK_SET);
  fileClearerr(fileID);
}

off_t
fileGetPos(int fileID)
{
  off_t filepos = 0;

  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr) { filepos = (fileptr->mode == 'r' && fileptr->type == FILE_TYPE_OPEN) ? fileptr->position : ftell(fileptr->fp); }

  if (FileDebug) Message("Position %ld", filepos);

  return filepos;
}

static int
file_set_buffer_pos(bfile_t *fileptr)
{
  off_t position = fileptr->position;
  if (position < fileptr->bufferStart || position > fileptr->bufferEnd)
  {
    fileptr->bufferPos = (fileptr->bufferType == FILE_BUFTYPE_STD) ? position : position - position % file_pagesize();
    fileptr->bufferCnt = 0;
    fileptr->bufferPtr = NULL;

    return 1;
  }

  return 0;
}

static void
file_check_buffer_pos(bfile_t *fileptr)
{
  if (fileptr->bufferPos != fileptr->bufferEnd + 1)
  {
    if (FileDebug) Message("Reset buffer pos from %ld to %ld", fileptr->bufferPos, fileptr->bufferEnd + 1);

    fileptr->bufferPos = fileptr->bufferEnd + 1;
  }
}

static void
file_seek_buffer(bfile_t *fileptr, off_t offset, int whence)
{
  if (whence == SEEK_SET)
  {
    fileptr->position = offset;
    if (!file_set_buffer_pos(fileptr))
    {
      file_check_buffer_pos(fileptr);
      fileptr->bufferCnt = (size_t) (fileptr->bufferEnd - fileptr->position) + 1;
      fileptr->bufferPtr = fileptr->buffer + fileptr->position - fileptr->bufferStart;
    }
  }
  else if (whence == SEEK_CUR)
  {
    fileptr->position += offset;
    if (!file_set_buffer_pos(fileptr))
    {
      file_check_buffer_pos(fileptr);
      fileptr->bufferCnt -= (size_t) offset;
      fileptr->bufferPtr += offset;
    }
  }
}

int
fileSetPos(int fileID, off_t offset, int whence)
{
  int status = 0;

  if (FileDebug) Message("Offset %8ld  Whence %3d", (long) offset, whence);

  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr == 0)
  {
    file_pointer_info(__func__, fileID);
    return 1;
  }

  if (whence != SEEK_SET && whence != SEEK_CUR) Error("Whence = %d not implemented", whence);

  if (fileptr->mode == 'r' && fileptr->type == FILE_TYPE_OPEN)
    file_seek_buffer(fileptr, offset, whence);
  else
    status = fseek(fileptr->fp, offset, whence);

  if ((fileptr->position < fileptr->size) && ((fileptr->flag & FILE_EOF) != 0)) fileptr->flag -= FILE_EOF;

  return status;
}

static void
file_table_print(void)
{
  int lprintHeader = 1;

  for (int fileID = 0; fileID < _file_max; fileID++)
  {
    bfile_t *fileptr = file_to_pointer(fileID);
    if (fileptr)
    {
      if (lprintHeader)
      {
        fprintf(stderr, "\nFile table:\n");
        fprintf(stderr, "+-----+---------+");
        fprintf(stderr, "----------------------------------------------------+\n");
        fprintf(stderr, "|  ID |  Mode   |");
        fprintf(stderr, "  Name                                              |\n");
        fprintf(stderr, "+-----+---------+");
        fprintf(stderr, "----------------------------------------------------+\n");
        lprintHeader = 0;
      }

      fprintf(stderr, "| %3d | ", fileID);

      switch (fileptr->mode)
      {
        case 'r': fprintf(stderr, "read   "); break;
        case 'w': fprintf(stderr, "write  "); break;
        case 'a': fprintf(stderr, "append "); break;
        default: fprintf(stderr, "unknown");
      }

      fprintf(stderr, " | %-51s|\n", fileptr->name);
    }
  }

  if (lprintHeader == 0)
  {
    fprintf(stderr, "+-----+---------+");
    fprintf(stderr, "----------------------------------------------------+\n");
  }
}

char *
fileInqName(int fileID)
{
  bfile_t *fileptr = file_to_pointer(fileID);
  return fileptr ? fileptr->name : NULL;
}

int
fileInqMode(int fileID)
{
  bfile_t *fileptr = file_to_pointer(fileID);
  return fileptr ? fileptr->mode : 0;
}

static long
file_getenv(const char *envName)
{
  long envValue = -1;
  char *envString = getenv(envName);
  if (envString)
  {
    long fact = 1;
    for (int i = 0; i < (int) strlen(envString); i++)
    {
      if (!isdigit((int) envString[i]))
      {
        switch (tolower((int) envString[i]))
        {
          case 'k': fact = 1024; break;
          case 'm': fact = 1048576; break;
          case 'g': fact = 1073741824; break;
          default:
            fact = 0;
            Warning("Invalid number string in %s: %s", envName, envString);
            Warning("%s must comprise only digits [0-9].", envName);
        }
        break;
      }
    }

    if (fact) envValue = fact * atol(envString);

    if (FileDebug) Message("Set %s to %ld", envName, envValue);
  }

  return envValue;
}

static void
file_initialize(void)
{
  long value;

  FileInfo = (file_getenv("FILE_INFO") > 0);

  value = file_getenv("FILE_DEBUG");
  if (value >= 0) FileDebug = (int) value;

  value = file_getenv("FILE_MAX");
  if (value >= 0) _file_max = (int) value;

  if (FileInfo) fprintf(stderr, "FILE_MAX = %d\n", _file_max);

  value = file_getenv("FILE_BUFSIZE");
  if (value >= 0)
    FileBufferSizeEnv = value;
  else
  {
    value = file_getenv("GRIB_API_IO_BUFFER_SIZE");
    if (value >= 0) FileBufferSizeEnv = value;
  }

  if (FileInfo) fprintf(stderr, "FILE_BUFSIZE = %ld\n", FileBufferSizeEnv);

  value = file_getenv("FILE_TYPE_READ");
  if (value > 0)
  {
    switch (value)
    {
      case FILE_TYPE_OPEN:
      case FILE_TYPE_FOPEN: FileTypeRead = (int) value; break;
      default: Warning("File type %ld not implemented!", value);
    }
  }

  if (FileInfo)
    fprintf(stderr, "FILE_TYPE_READ = %d [%d:%s  %d:%s]\n", FileTypeRead, FILE_TYPE_OPEN, ftname[FILE_TYPE_OPEN], FILE_TYPE_FOPEN,
            ftname[FILE_TYPE_FOPEN]);

  value = file_getenv("FILE_TYPE_WRITE");
  if (value > 0)
  {
    switch (value)
    {
      case FILE_TYPE_OPEN:
      case FILE_TYPE_FOPEN: FileTypeWrite = (int) value; break;
      default: Warning("File type %ld not implemented!", value);
    }
  }

  if (FileInfo)
    fprintf(stderr, "FILE_TYPE_WRITE = %d [%d:%s  %d:%s]\n", FileTypeWrite, FILE_TYPE_OPEN, ftname[FILE_TYPE_OPEN], FILE_TYPE_FOPEN,
            ftname[FILE_TYPE_FOPEN]);

#ifdef O_NONBLOCK
  FileFlagWrite = O_NONBLOCK;
#endif
  char *envString = getenv("FILE_FLAG_WRITE");
  if (envString)
  {
#ifdef O_NONBLOCK
    if (strcmp(envString, "NONBLOCK") == 0) FileFlagWrite = O_NONBLOCK;
#endif
  }

  value = file_getenv("FILE_BUFTYPE");
#ifndef HAVE_MMAP
  if (value == FILE_BUFTYPE_MMAP)
  {
    Warning("MMAP not available!");
    value = 0;
  }
#endif
  if (value > 0)
  {
    switch (value)
    {
      case FILE_BUFTYPE_STD:
      case FILE_BUFTYPE_MMAP: FileBufferTypeEnv = (int) value; break;
      default: Warning("File buffer type %ld not implemented!", value);
    }
  }

  if (FileInfo)
    fprintf(stderr, "FILE_BUFTYPE = %d [%d:%s  %d:%s]\n", FileBufferTypeEnv, FILE_BUFTYPE_STD, fbtname[FILE_BUFTYPE_STD],
            FILE_BUFTYPE_MMAP, fbtname[FILE_BUFTYPE_MMAP]);

  file_list_new();
  atexit(file_list_delete);

  FILE_LOCK();
  file_init_pointer();
  FILE_UNLOCK();

  if (FileDebug) atexit(file_table_print);

  _file_init = true;
}

static size_t
file_get_buffersize(bfile_t *fileptr)
{
  size_t buffersize = 0;

  if (FileBufferSizeEnv >= 0)
    buffersize = (size_t) FileBufferSizeEnv;
  else if (fileptr->bufferSize > 0)
    buffersize = fileptr->bufferSize;
  else
  {
    buffersize = fileptr->blockSize * 4;
    if (buffersize < FileBufferSizeMin) buffersize = FileBufferSizeMin;
  }

  return buffersize;
}

static void
file_set_buffer(bfile_t *fileptr)
{
  size_t buffersize = 0;

  if (fileptr->mode == 'r')
  {
    if (FileBufferTypeEnv)
      fileptr->bufferType = FileBufferTypeEnv;
    else if (fileptr->bufferType == 0)
      fileptr->bufferType = FILE_BUFTYPE_STD;

    buffersize = file_get_buffersize(fileptr);

    if ((size_t) fileptr->size < buffersize) buffersize = (size_t) fileptr->size;

    if (fileptr->bufferType == FILE_BUFTYPE_MMAP)
    {
      size_t blocksize = (size_t) file_pagesize();
      size_t minblocksize = 4 * blocksize;
      buffersize = buffersize - buffersize % minblocksize;

      if (buffersize < (size_t) fileptr->size && buffersize < minblocksize) buffersize = minblocksize;
    }

    if (buffersize == 0) buffersize = 1;
  }
  else
  {
    fileptr->bufferType = FILE_BUFTYPE_STD;
    buffersize = file_get_buffersize(fileptr);
  }

  if (fileptr->bufferType == FILE_BUFTYPE_STD || fileptr->type == FILE_TYPE_FOPEN)
  {
    if (buffersize > 0)
    {
      fileptr->buffer = (char *) malloc(buffersize);
      if (fileptr->buffer == NULL) SysError("Allocation of file buffer failed!");
    }
  }

  if (fileptr->type == FILE_TYPE_FOPEN)
    if (setvbuf(fileptr->fp, fileptr->buffer, fileptr->buffer ? _IOFBF : _IONBF, buffersize)) SysError("setvbuf failed!");

  fileptr->bufferSize = buffersize;
}

static int
file_fill_buffer(bfile_t *fileptr)
{
  ssize_t nread;
  long offset = 0;

  if (FileDebug) Message("file ptr = %p  Cnt = %ld", fileptr, fileptr->bufferCnt);

  if ((fileptr->flag & FILE_EOF) != 0) return EOF;

  if (fileptr->buffer == NULL) file_set_buffer(fileptr);

  if (fileptr->bufferSize == 0) return EOF;

  int fd = fileptr->fd;

#ifdef HAVE_MMAP
  if (fileptr->bufferType == FILE_BUFTYPE_MMAP)
  {
    if (fileptr->bufferPos >= fileptr->size) { nread = 0; }
    else
    {
#ifdef CDI
      xassert(fileptr->bufferSize <= SSIZE_MAX);
#endif
      nread = (ssize_t) fileptr->bufferSize;
      if ((nread + fileptr->bufferPos) > fileptr->size) nread = fileptr->size - fileptr->bufferPos;

      if (fileptr->buffer)
      {
        int ret = munmap(fileptr->buffer, fileptr->mappedSize);
        if (ret == -1) SysError("munmap error for read %s", fileptr->name);
        fileptr->buffer = NULL;
      }

      fileptr->mappedSize = (size_t) nread;

      fileptr->buffer = (char *) mmap(NULL, (size_t) nread, PROT_READ, MAP_PRIVATE, fd, fileptr->bufferPos);

      if (fileptr->buffer == MAP_FAILED) SysError("mmap error for read %s", fileptr->name);

      offset = fileptr->position - fileptr->bufferPos;
    }
  }
  else
#endif
  {
    off_t retseek = lseek(fileptr->fd, fileptr->bufferPos, SEEK_SET);
    if (retseek == (off_t) -1) SysError("lseek error at pos %ld file %s", (long) fileptr->bufferPos, fileptr->name);

    nread = read(fd, fileptr->buffer, fileptr->bufferSize);
    if (nread > 0) offset = fileptr->position - fileptr->bufferPos;
  }

  if (nread <= 0)
  {
    fileptr->flag |= (nread == 0) ? FILE_EOF : FILE_ERROR;
    fileptr->bufferCnt = 0;
    return EOF;
  }

  fileptr->bufferPtr = fileptr->buffer;
  fileptr->bufferCnt = (size_t) nread;

  fileptr->bufferStart = fileptr->bufferPos;
  fileptr->bufferPos += nread;
  fileptr->bufferEnd = fileptr->bufferPos - 1;

  if (FileDebug)
  {
    Message("fileID = %d  Val     = %d", fileptr->self, (int) fileptr->buffer[0]);
    Message("fileID = %d  Start   = %ld", fileptr->self, fileptr->bufferStart);
    Message("fileID = %d  End     = %ld", fileptr->self, fileptr->bufferEnd);
    Message("fileID = %d  nread   = %ld", fileptr->self, nread);
    Message("fileID = %d  offset  = %ld", fileptr->self, offset);
    Message("fileID = %d  Pos     = %ld", fileptr->self, fileptr->bufferPos);
    Message("fileID = %d  postion = %ld", fileptr->self, fileptr->position);
  }

  if (offset > 0)
  {
    if (offset > nread) Error("Internal problem with buffer handling. nread = %d offset = %d", nread, offset);

    fileptr->bufferPtr += offset;
    fileptr->bufferCnt -= (size_t) offset;
  }

  fileptr->bufferNumFill++;

  return (unsigned char) *fileptr->bufferPtr;
}

static void
file_copy_from_buffer(bfile_t *fileptr, void *ptr, size_t size)
{
  if (FileDebug) Message("size = %ld  Cnt = %ld", size, fileptr->bufferCnt);

  if (fileptr->bufferCnt < size) Error("Buffer too small. bufferCnt = %d", fileptr->bufferCnt);

  if (size == 1)
  {
    ((char *) ptr)[0] = fileptr->bufferPtr[0];

    fileptr->bufferPtr++;
    fileptr->bufferCnt--;
  }
  else
  {
    memcpy(ptr, fileptr->bufferPtr, size);

    fileptr->bufferPtr += size;
    fileptr->bufferCnt -= size;
  }
}

static size_t
file_read_from_buffer(bfile_t *fileptr, void *ptr, size_t size)
{
  size_t nread;
  size_t offset = 0;

  if (FileDebug) Message("size = %ld  Cnt = %ld", size, (long) fileptr->bufferCnt);

  if (((long) fileptr->bufferCnt) < 0L) Error("Internal problem. bufferCnt = %ld", (long) fileptr->bufferCnt);

  size_t rsize = size;

  while (fileptr->bufferCnt < rsize)
  {
    nread = fileptr->bufferCnt;
    // fprintf(stderr, "rsize = %d nread = %d\n", (int) rsize, (int) nread);
    if (nread > (size_t) 0) file_copy_from_buffer(fileptr, (char *) ptr + offset, nread);
    offset += nread;
    rsize = (nread < rsize) ? rsize - nread : 0;

    if (file_fill_buffer(fileptr) == EOF) break;
  }

  nread = size - offset;

  if (fileptr->bufferCnt < nread) nread = fileptr->bufferCnt;

  if (nread > (unsigned) 0) file_copy_from_buffer(fileptr, (char *) ptr + offset, nread);

  return (nread + offset);
}

void
fileSetBufferSize(int fileID, long buffersize)
{
#ifdef CDI
  xassert(buffersize >= 0);
#endif
  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr) fileptr->bufferSize = (size_t) buffersize;
}

/*
 *   Open a file. Returns file ID, or -1 on error
 */
int
fileOpen(const char *filename, const char *mode)
#ifdef CDI
{
  int (*myFileOpen)(const char *filename, const char *mode)
      = (int (*)(const char *, const char *)) namespaceSwitchGet(NSSWITCH_FILE_OPEN).func;
  return myFileOpen(filename, mode);
}

int
fileOpen_serial(const char *filename, const char *mode)
#endif
{
  FILE *fp = NULL;  // file pointer    (used for write)
  int fd = -1;      // file descriptor (used for read)
  int fileID = FILE_UNDEFID;
  struct stat filestat;
  bfile_t *fileptr = NULL;

  FILE_INIT();

  int fmode = tolower((int) mode[0]);

  switch (fmode)
  {
    case 'r':
      if (FileTypeRead == FILE_TYPE_FOPEN)
        fp = fopen(filename, "rb");
      else
        fd = open(filename, O_RDONLY | O_BINARY);
      break;
    case 'x': fp = fopen(filename, "rb"); break;
    case 'w':
      if (FileTypeWrite == FILE_TYPE_FOPEN)
        fp = fopen(filename, "wb");
      else
        fd = open(filename, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY | FileFlagWrite, 0666);
      break;
    case 'a': fp = fopen(filename, "ab"); break;
    default: Error("Mode %c unexpected!", fmode);
  }

  if (FileDebug && fp == NULL && fd == -1) Message("Open failed on %s mode %c errno %d", filename, fmode, errno);

  if (fp)
  {
    if (stat(filename, &filestat) != 0) return fileID;

    fileptr = file_new_entry();
    if (fileptr)
    {
      fileID = fileptr->self;
      fileptr->fp = fp;
    }
  }
  else if (fd >= 0)
  {
    if (fstat(fd, &filestat) != 0) return fileID;

    fileptr = file_new_entry();
    if (fileptr)
    {
      fileID = fileptr->self;
      fileptr->fd = fd;
    }
  }

  if (fileID >= 0)
  {
    fileptr->mode = fmode;
    fileptr->name = strdup(filename);

#ifdef HAVE_STRUCT_STAT_ST_BLKSIZE
    fileptr->blockSize = (size_t) filestat.st_blksize;
#else
    fileptr->blockSize = (size_t) 4096;
#endif

    // clang-format off
      if      (fmode == 'r') fileptr->type = FileTypeRead;
      else if (fmode == 'w') fileptr->type = FileTypeWrite;
      else                   fileptr->type = FILE_TYPE_FOPEN;
    // clang-format on

    if (fmode == 'r') fileptr->size = filestat.st_size;

    // if (fileptr->type == FILE_TYPE_FOPEN) file_set_buffer(fileptr);
    file_set_buffer(fileptr);

    if (FileDebug) Message("File %s opened with ID %d", filename, fileID);
  }

  return fileID;
}

/*
 *   Close a file.
 */
int
fileClose(int fileID)
#ifdef CDI
{
  int (*myFileClose)(int fileID) = (int (*)(int)) namespaceSwitchGet(NSSWITCH_FILE_CLOSE).func;
  return myFileClose(fileID);
}

int
fileClose_serial(int fileID)
#endif
{
  double rout = 0;

  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr == NULL)
  {
    file_pointer_info(__func__, fileID);
    return 1;
  }

  const char *name = fileptr->name;

  if (FileDebug) Message("fileID = %d  filename = %s", fileID, name);

  if (FileInfo)
  {
    fprintf(stderr, "____________________________________________\n");
    fprintf(stderr, " file ID          : %d\n", fileID);
    fprintf(stderr, " file name        : %s\n", fileptr->name);
    fprintf(stderr, " file type        : %d (%s)\n", fileptr->type, ftname[fileptr->type]);

    if (fileptr->type == FILE_TYPE_FOPEN)
      fprintf(stderr, " file pointer     : %p\n", (void *) fileptr->fp);
    else
    {
      fprintf(stderr, " file descriptor  : %d\n", fileptr->fd);
      fprintf(stderr, " file flag        : %d\n", FileFlagWrite);
    }
    fprintf(stderr, " file mode        : %c\n", fileptr->mode);

    if (sizeof(off_t) > sizeof(long))
    {
#ifdef _WIN32
      fprintf(stderr, " file size        : %I64d\n", (long long) fileptr->size);
      if (fileptr->type == FILE_TYPE_OPEN) fprintf(stderr, " file position    : %I64d\n", (long long) fileptr->position);
      fprintf(stderr, " bytes transfered : %I64d\n", (long long) fileptr->byteTrans);
#else
      fprintf(stderr, " file size        : %lld\n", (long long) fileptr->size);
      if (fileptr->type == FILE_TYPE_OPEN) fprintf(stderr, " file position    : %lld\n", (long long) fileptr->position);
      fprintf(stderr, " bytes transfered : %lld\n", (long long) fileptr->byteTrans);
#endif
    }
    else
    {
      fprintf(stderr, " file size        : %ld\n", (long) fileptr->size);
      if (fileptr->type == FILE_TYPE_OPEN) fprintf(stderr, " file position    : %ld\n", (long) fileptr->position);
      fprintf(stderr, " bytes transfered : %ld\n", (long) fileptr->byteTrans);
    }

    if (fileptr->time_in_sec > 0) rout = (double) fileptr->byteTrans / (1024. * 1024. * fileptr->time_in_sec);

    fprintf(stderr, " wall time [s]    : %.2f\n", fileptr->time_in_sec);
    fprintf(stderr, " data rate [MB/s] : %.1f\n", rout);

    fprintf(stderr, " file access      : %ld\n", fileptr->access);
    if (fileptr->mode == 'r' && fileptr->type == FILE_TYPE_OPEN)
    {
      fprintf(stderr, " buffer type      : %d (%s)\n", fileptr->bufferType, fbtname[fileptr->bufferType]);
      fprintf(stderr, " num buffer fill  : %ld\n", fileptr->bufferNumFill);
    }
    fprintf(stderr, " buffer size      : %lu\n", (unsigned long) fileptr->bufferSize);
    fprintf(stderr, " block size       : %lu\n", (unsigned long) fileptr->blockSize);
    fprintf(stderr, " page size        : %d\n", file_pagesize());
    fprintf(stderr, "--------------------------------------------\n");
  }

  if (fileptr->type == FILE_TYPE_FOPEN)
  {
    if (fclose(fileptr->fp) == EOF) SysError("EOF returned for close of %s!", name);
  }
  else
  {
#ifdef HAVE_MMAP
    if (fileptr->buffer && fileptr->mappedSize)
    {
      if (munmap(fileptr->buffer, fileptr->mappedSize) == -1) SysError("munmap error for close %s", fileptr->name);
      fileptr->buffer = NULL;
    }
#endif
    if (close(fileptr->fd) == -1) SysError("EOF returned for close of %s!", name);
  }

  if (fileptr->name) free((void *) fileptr->name);
  if (fileptr->buffer) free((void *) fileptr->buffer);

  file_delete_entry(fileptr);

  return 0;
}

int
filePtrGetc(void *vfileptr)
{
  int ivalue = EOF;

  bfile_t *fileptr = (bfile_t *) vfileptr;
  if (fileptr)
  {
    if (fileptr->mode == 'r' && fileptr->type == FILE_TYPE_OPEN)
    {
      int fillret = (fileptr->bufferCnt == 0) ? file_fill_buffer(fileptr) : 0;
      if (fillret >= 0)
      {
        ivalue = (unsigned char) *fileptr->bufferPtr++;
        fileptr->bufferCnt--;
        fileptr->position++;

        fileptr->byteTrans++;
        fileptr->access++;
      }
    }
    else
    {
      ivalue = fgetc(fileptr->fp);
      if (ivalue >= 0)
      {
        fileptr->byteTrans++;
        fileptr->access++;
      }
      else
        fileptr->flag |= FILE_EOF;
    }
  }

  return ivalue;
}

int
fileGetc(int fileID)
{
  bfile_t *fileptr = file_to_pointer(fileID);
  return filePtrGetc((void *) fileptr);
}

size_t
filePtrRead(void *vfileptr, void *restrict ptr, size_t size)
{
  size_t nread = 0;

  bfile_t *fileptr = (bfile_t *) vfileptr;
  if (fileptr)
  {
    if (fileptr->mode == 'r' && fileptr->type == FILE_TYPE_OPEN) { nread = file_read_from_buffer(fileptr, ptr, size); }
    else
    {
      nread = fread(ptr, 1, size, fileptr->fp);
      if (nread != size) fileptr->flag |= (nread == 0) ? FILE_EOF : FILE_ERROR;
    }

    fileptr->position += (off_t) nread;
    fileptr->byteTrans += (off_t) nread;
    fileptr->access++;
  }

  if (FileDebug) Message("size %ld  nread %ld", size, nread);

  return nread;
}

size_t
fileRead(int fileID, void *restrict ptr, size_t size)
{
  size_t nread = 0;

  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr)
  {
    double t_begin = 0.0;

    if (FileInfo) t_begin = file_time();

    if (fileptr->type == FILE_TYPE_OPEN) { nread = file_read_from_buffer(fileptr, ptr, size); }
    else
    {
      nread = fread(ptr, 1, size, fileptr->fp);
      if (nread != size) fileptr->flag |= (nread == 0) ? FILE_EOF : FILE_ERROR;
    }

    if (FileInfo) fileptr->time_in_sec += file_time() - t_begin;

    fileptr->position += (off_t) nread;
    fileptr->byteTrans += (off_t) nread;
    fileptr->access++;
  }

  if (FileDebug) Message("size %ld  nread %ld", size, nread);

  return nread;
}

size_t
fileWrite(int fileID, const void *restrict ptr, size_t size)
{
  size_t nwrite = 0;

  bfile_t *fileptr = file_to_pointer(fileID);
  if (fileptr)
  {
    double t_begin = 0.0;

    if (FileInfo) t_begin = file_time();

    if (fileptr->type == FILE_TYPE_FOPEN) { nwrite = fwrite(ptr, 1, size, fileptr->fp); }
    else
    {
      ssize_t temp = write(fileptr->fd, ptr, size);
      if (temp == -1) perror("error writing to file");
      nwrite = (temp == -1) ? 0 : (size_t) temp;
    }

    if (FileInfo) fileptr->time_in_sec += file_time() - t_begin;

    fileptr->position += (off_t) nwrite;
    fileptr->byteTrans += (off_t) nwrite;
    fileptr->access++;
  }

  return nwrite;
}
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <float.h>

// Required on windows to be able to use M_PI
#define _USE_MATH_DEFINES
#include <math.h>

#ifndef M_SQRT2
#define M_SQRT2 1.41421356237309504880168872420969808
#endif

static void
cpledn(size_t kn, size_t kodd, const double *pfn, double pdx, int kflag, double *pw, double *pdxn, double *pxmod)
{
  // 1.0 Newton iteration step

  double zdlx = pdx;
  double zdlldn = 0.0;

  size_t ik = 1;

  if (kflag == 0)
  {
    double zdlk = 0.5 * pfn[0];
    for (size_t jn = 2 - kodd; jn <= kn; jn += 2)
    {
      // normalised ordinary Legendre polynomial == \overbar{p_n}^0
      zdlk = zdlk + pfn[ik] * cos((double) (jn) *zdlx);
      // normalised derivative == d/d\theta(\overbar{p_n}^0)
      zdlldn = zdlldn - pfn[ik] * (double) (jn) *sin((double) (jn) *zdlx);
      ik++;
    }
    // Newton method
    double zdlmod = -(zdlk / zdlldn);
    double zdlxn = zdlx + zdlmod;
    *pdxn = zdlxn;
    *pxmod = zdlmod;
  }

  // 2.0 Compute weights

  if (kflag == 1)
  {
    for (size_t jn = 2 - kodd; jn <= kn; jn += 2)
    {
      // normalised derivative
      zdlldn = zdlldn - pfn[ik] * (double) (jn) *sin((double) (jn) *zdlx);
      ik++;
    }
    *pw = (double) (2 * kn + 1) / (zdlldn * zdlldn);
  }
}

static void
gawl(double *pfn, double *pl, double *pw, size_t kn)
{
  double pmod = 0.0;
  double zw = 0.0;
  double zdlxn = 0.0;

  // 1.0 Initizialization

  int iflag = 0;
  int itemax = 20;

  size_t iodd = (kn % 2);

  double zdlx = *pl;

  // 2.0 Newton iteration

  for (int jter = 1; jter <= itemax + 1; ++jter)
  {
    cpledn(kn, iodd, pfn, zdlx, iflag, &zw, &zdlxn, &pmod);
    zdlx = zdlxn;
    if (iflag == 1) break;
    if (fabs(pmod) <= DBL_EPSILON * 1000.0) iflag = 1;
  }

  *pl = zdlxn;
  *pw = zw;
}

static void
gauaw(size_t kn, double *restrict pl, double *restrict pw)
{
  /*
   * 1.0 Initialize Fourier coefficients for ordinary Legendre polynomials
   *
   * Belousov, Swarztrauber, and ECHAM use zfn(0,0) = sqrt(2)
   * IFS normalisation chosen to be 0.5*Integral(Pnm**2) = 1 (zfn(0,0) = 2.0)
   */
  double *zfn = (double *) malloc((kn + 1) * (kn + 1) * sizeof(double));
  double *zfnlat = (double *) malloc((kn / 2 + 1 + 1) * sizeof(double));

  zfn[0] = M_SQRT2;
  for (size_t jn = 1; jn <= kn; ++jn)
  {
    double zfnn = zfn[0];
    for (size_t jgl = 1; jgl <= jn; ++jgl) { zfnn *= sqrt(1.0 - 0.25 / ((double) (jgl * jgl))); }

    zfn[jn * (kn + 1) + jn] = zfnn;

    size_t iodd = jn % 2;
    for (size_t jgl = 2; jgl <= jn - iodd; jgl += 2)
    {
      zfn[jn * (kn + 1) + jn - jgl]
          = zfn[jn * (kn + 1) + jn - jgl + 2] * ((double) ((jgl - 1) * (2 * jn - jgl + 2))) / ((double) (jgl * (2 * jn - jgl + 1)));
    }
  }

  // 2.0 Gaussian latitudes and weights

  size_t iodd = kn % 2;
  size_t ik = iodd;
  for (size_t jgl = iodd; jgl <= kn; jgl += 2)
  {
    zfnlat[ik] = zfn[kn * (kn + 1) + jgl];
    ik++;
  }

  // 2.1 Find first approximation of the roots of the Legendre polynomial of degree kn

  size_t ins2 = kn / 2 + (kn % 2);

  for (size_t jgl = 1; jgl <= ins2; ++jgl)
  {
    double z = ((double) (4 * jgl - 1)) * M_PI / ((double) (4 * kn + 2));
    pl[jgl - 1] = z + 1.0 / (tan(z) * ((double) (8 * kn * kn)));
  }

  // 2.2 Computes roots and weights for transformed theta

  for (size_t jgl = ins2; jgl >= 1; --jgl)
  {
    size_t jglm1 = jgl - 1;
    gawl(zfnlat, &(pl[jglm1]), &(pw[jglm1]), kn);
  }

  // convert to physical latitude

  for (size_t jgl = 0; jgl < ins2; ++jgl) pl[jgl] = cos(pl[jgl]);

  for (size_t jgl = 1; jgl <= kn / 2; ++jgl)
  {
    size_t jglm1 = jgl - 1;
    size_t isym = kn - jgl;
    pl[isym] = -pl[jglm1];
    pw[isym] = pw[jglm1];
  }

  free(zfnlat);
  free(zfn);
}

void
gaussianLatitudes(size_t nlats, double *latitudes, double *weights)
{
  gauaw(nlats, latitudes, weights);
}

bool
isGaussianLatitudes(size_t nlats, const double *latitudes)
{
  bool is_gauss_lats = false;

  if (nlats > 2)  // check if gaussian
  {
    size_t i;
    double *yv = (double *) malloc(nlats * sizeof(double));
    double *yw = (double *) malloc(nlats * sizeof(double));
    gaussianLatitudes(nlats, yv, yw);
    free(yw);

    for (i = 0; i < nlats; i++) yv[i] = asin(yv[i]) / M_PI * 180.0;

    for (i = 0; i < nlats; i++)
      if (fabs(yv[i] - latitudes[i]) > ((yv[0] - yv[1]) / 500.0)) break;

    if (i == nlats) is_gauss_lats = true;

    // check S->N
    if (is_gauss_lats == false)
    {
      for (i = 0; i < nlats; i++)
        if (fabs(yv[i] - latitudes[nlats - i - 1]) > ((yv[0] - yv[1]) / 500.0)) break;

      if (i == nlats) is_gauss_lats = true;
    }

    free(yv);
  }

  return is_gauss_lats;
}
#ifndef GET_NUM_MISSVALS_H
#define GET_NUM_MISSVALS_H

#include <stddef.h>

size_t get_num_missvalsSP(size_t size, float *data, float missval);
size_t get_num_missvalsDP(size_t size, double *data, double missval);
size_t get_cplx_num_missvalsSP(size_t size, float *data, float missval);
size_t get_cplx_num_missvalsDP(size_t size, double *data, double missval);

#endif
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */


size_t
get_num_missvalsSP(size_t size, float *data, float missval)
{
  size_t numMissVals = 0;

  if (DBL_IS_NAN(missval))
  {
    for (size_t i = 0; i < size; i++)
      if (DBL_IS_EQUAL(data[i], missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }
  else
  {
    for (size_t i = 0; i < size; i++)
      if (IS_EQUAL(data[i], missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }

  return numMissVals;
}

size_t
get_num_missvalsDP(size_t size, double *data, double missval)
{
  size_t numMissVals = 0;

  if (DBL_IS_NAN(missval))
  {
    for (size_t i = 0; i < size; i++)
      if (DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float) missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }
  else
  {
    for (size_t i = 0; i < size; i++)
      if (IS_EQUAL(data[i], missval) || IS_EQUAL(data[i], (float) missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }

  return numMissVals;
}

size_t
get_cplx_num_missvalsSP(size_t size, float *data, float missval)
{
  size_t numMissVals = 0;

  if (DBL_IS_NAN(missval))
  {
    for (size_t i = 0; i < 2 * size; i += 2)
      if (DBL_IS_EQUAL(data[i], missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }
  else
  {
    for (size_t i = 0; i < 2 * size; i += 2)
      if (IS_EQUAL(data[i], missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }

  return numMissVals;
}

size_t
get_cplx_num_missvalsDP(size_t size, double *data, double missval)
{
  size_t numMissVals = 0;

  if (DBL_IS_NAN(missval))
  {
    for (size_t i = 0; i < 2 * size; i += 2)
      if (DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float) missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }
  else
  {
    for (size_t i = 0; i < 2 * size; i += 2)
      if (IS_EQUAL(data[i], missval) || IS_EQUAL(data[i], (float) missval))
      {
        data[i] = missval;
        numMissVals++;
      }
  }

  return numMissVals;
}
#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBGRIB_API
#include <grib_api.h>
#endif

#include <stdio.h>


static char gribapi_libvers[64] = "";
#ifdef HAVE_LIBGRIB_API
static bool gribapi_libvers_init;
#endif

void
gribapiLibraryVersion(int *major_version, int *minor_version, int *revision_version)
{
#ifdef HAVE_LIBGRIB_API
  long version = grib_get_api_version();
  (*major_version) = (int) (version / 10000);
  (*minor_version) = (int) ((version - (*major_version) * 10000) / 100);
  (*revision_version) = (int) (version - (*major_version) * 10000 - (*minor_version) * 100);
#else
  (*major_version) = 0;
  (*minor_version) = 0;
  (*revision_version) = 0;
#endif
}

const char *
gribapiLibraryVersionString(void)
{
#ifdef HAVE_LIBGRIB_API
  if (!gribapi_libvers_init)
  {
    int major_version, minor_version, revision_version;
    gribapiLibraryVersion(&major_version, &minor_version, &revision_version);

    snprintf(gribapi_libvers, sizeof(gribapi_libvers), "%d.%d.%d", major_version, minor_version, revision_version);
    gribapi_libvers_init = true;
  }
#endif

  return gribapi_libvers;
}

void *
gribHandleNew(int editionNumber)
{
#ifdef HAVE_LIBGRIB_API
  grib_handle *gh = NULL;
  const char *fname = (editionNumber == 1) ? CDI_GRIB1_Template : CDI_GRIB2_Template;
  if (fname)
  {
    FILE *fp = fopen(fname, "r");
    if (fp)
    {
      int error;
      gh = grib_handle_new_from_file(NULL, fp, &error);
      fclose(fp);
      if (gh == NULL) Error("grib_handle_new_from_file failed!");
    }
    else { Error("Open failed on >%s<!", fname); }
  }

  if (gh == NULL)
  {
    gh = grib_handle_new_from_samples(NULL, (editionNumber == 1) ? "GRIB1" : "GRIB2");
    if (gh == NULL) Error("grib_handle_new_from_samples failed!");

    if (editionNumber == 1) GRIB_CHECK(my_grib_set_long(gh, "deleteLocalDefinition", 1L), 0);
    if (editionNumber == 2) GRIB_CHECK(my_grib_set_long(gh, "grib2LocalSectionPresent", 0L), 0);
    if (editionNumber == 2) GRIB_CHECK(my_grib_set_long(gh, "numberOfValues", 0L), 0);
  }

  return gh;
#else
  (void) editionNumber;
  return NULL;
#endif
}

void
gribHandleDelete(void *gh)
{
#ifdef HAVE_LIBGRIB_API
  grib_handle_delete((struct grib_handle *) gh);
#else
  (void) gh;
#endif
}

void
gribContainersNew(stream_t *streamptr)
{
  const int editionNumber = (streamptr->filetype == CDI_FILETYPE_GRB) ? 1 : 2;

#ifdef HAVE_LIBCGRIBEX
  if (editionNumber == 1 && !CDI_gribapi_grib1) {}
  else
#endif
  {
    const int nvars = streamptr->nvars;

#ifdef GRIBCONTAINER2D
    gribContainer_t **gribContainers;
    gribContainers = (gribContainer_t **) Malloc(nvars * sizeof(gribContainer_t *));

    for (int varID = 0; varID < nvars; ++varID)
    {
      const int nlevs = streamptr->vars[varID].nlevs;
      gribContainers[varID] = (gribContainer_t *) Malloc(nlevs * sizeof(gribContainer_t));

      for (int levelID = 0; levelID < nlevs; ++levelID)
      {
        gribContainers[varID][levelID].gribHandle = gribHandleNew(editionNumber);
        gribContainers[varID][levelID].init = false;
      }
    }

    streamptr->gribContainers = (void *) gribContainers;
#else
    gribContainer_t *gribContainers = (gribContainer_t *) Malloc((size_t) nvars * sizeof(gribContainer_t));

    for (int varID = 0; varID < nvars; ++varID)
    {
      gribContainers[varID].gribHandle = gribHandleNew(editionNumber);
      gribContainers[varID].init = false;
    }

    streamptr->gribContainers = (void *) gribContainers;
#endif
  }
}

void
gribContainersDelete(stream_t *streamptr)
{
  if (streamptr->gribContainers)
  {
    const int nvars = streamptr->nvars;

#ifdef GRIBCONTAINER2D
    gribContainer_t **gribContainers = (gribContainer_t **) streamptr->gribContainers;

    for (int varID = 0; varID < nvars; ++varID)
    {
      const int nlevs = streamptr->vars[varID].nlevs;
      for (int levelID = 0; levelID < nlevs; ++levelID) { gribHandleDelete(gribContainers[varID][levelID].gribHandle); }
      Free(gribContainers[varID]);
    }
#else
    gribContainer_t *gribContainers = (gribContainer_t *) streamptr->gribContainers;

    for (int varID = 0; varID < nvars; ++varID) { gribHandleDelete(gribContainers[varID].gribHandle); }
#endif

    Free(gribContainers);

    streamptr->gribContainers = NULL;
  }
}
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef INCLUDE_GUARD_CDI_GRIBAPI_UTILITIES_H
#define INCLUDE_GUARD_CDI_GRIBAPI_UTILITIES_H

#ifdef HAVE_LIBGRIB_API


#include <grib_api.h>

#include <stdbool.h>

char *gribCopyString(grib_handle *gribHandle, const char *key);
bool gribCheckString(grib_handle *gribHandle, const char *key, const char *expectedValue);

bool gribCheckLong(grib_handle *gribHandle, const char *key, long expectedValue);
long gribGetLong(grib_handle *gh, const char *key);
long gribGetLongDefault(grib_handle *gribHandle, const char *key, long defaultValue);

double gribGetDouble(grib_handle *gh, const char *key);
double gribGetDoubleDefault(grib_handle *gribHandle, const char *key, double defaultValue);

size_t gribGetArraySize(grib_handle *gribHandle, const char *key);
void gribGetDoubleArray(grib_handle *gribHandle, const char *key,
                        double *array);  // The caller is responsible to ensure a sufficiently large buffer.
void gribGetLongArray(grib_handle *gribHandle, const char *key,
                      long *array);  // The caller is responsible to ensure a sufficiently large buffer.

long gribEditionNumber(grib_handle *gh);
char *gribMakeTimeString(grib_handle *gh, CdiTimeType timeType);  // Returns NULL if timeType is kCdiTimeType_endTime and the field
                                                                  // does not have an integration period (statistical data).
int gribapiTimeIsFC(grib_handle *gh);
int gribapiGetTsteptype(grib_handle *gh);
int gribGetDatatype(grib_handle *gribHandle);
int gribapiGetParam(grib_handle *gh);
int gribapiGetGridType(grib_handle *gh);
bool gribapiGetGrid(grib_handle *gh, grid_t *grid);
size_t gribapiGetGridsize(grib_handle *gh);

#ifdef HIRLAM_EXTENSIONS
void gribapiSetDataTimeRangeIndicator(grib_handle *gh, int timeRangeIndicator);
void gribapiGetDataTimeRangeIndicator(grib_handle *gh, int *timeRangeIndicator);
#endif  // #ifdef HIRLAM_EXTENSIONS

extern struct cdiGribAPI_ts_str_map_elem
{
  long productionTemplate;
  const char sname[8];
} cdiGribAPI_ts_str_map[];

#endif

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#ifdef HAVE_LIBGRIB_API



#include <assert.h>
#include <time.h>

#define FAIL_ON_GRIB_ERROR(function, gribHandle, key, ...)                                                                       \
  do {                                                                                                                           \
    int errorCode = (int) function(gribHandle, key, __VA_ARGS__);                                                                \
    if (errorCode)                                                                                                               \
    {                                                                                                                            \
      fprintf(stderr, "%s:%d: Error in function `%s`: `%s` returned error code %d for key \"%s\"", __FILE__, __LINE__, __func__, \
              #function, errorCode, key);                                                                                        \
      exit(errorCode);                                                                                                           \
    }                                                                                                                            \
  } while (0)

// A simple wrapper for grib_get_string() that returns a newly allocated string.
char *
gribCopyString(grib_handle *gribHandle, const char *key)
{
  size_t length;
#ifdef HAVE_GRIB_GET_LENGTH
  if (!grib_get_length(gribHandle, key, &length))
  {
    char *result = (char *) Malloc(length);
    if (!grib_get_string(gribHandle, key, result, &length))
      result = (char *) Realloc(result, length);
    else
    {
      Free(result);
      result = NULL;
    }
    return result;
  }
  else
    return NULL;
#else
  length = 1024; /* there's an implementation limit
                  * that makes strings longer than
                  * this unlikely in grib_api versions
                  * not providing grib_get_length */
  int rc;
  char *result = (char *) Malloc(length);
  while ((rc = grib_get_string(gribHandle, key, result, &length)) == GRIB_BUFFER_TOO_SMALL || rc == GRIB_ARRAY_TOO_SMALL)
  {
    if (length <= 1024UL * 1024UL)
    {
      length *= 2;
      result = Realloc(result, length);
    }
    else
      break;
  }
  if (!rc)
    result = Realloc(result, length);
  else
  {
    Free(result);
    result = NULL;
  }
  return result;
#endif
}

// A simple wrapper for grib_get_string() for the usecase that the result is only compared to a given constant string.
// Returns true if the key exists and the value is equal to the given string.
bool
gribCheckString(grib_handle *gribHandle, const char *key, const char *expectedValue)
{
  size_t expectedLength = strlen(expectedValue) + 1;
#ifdef HAVE_GRIB_GET_LENGTH
  size_t length;
  if (grib_get_length(gribHandle, key, &length)) return false;
  if (length != expectedLength) return false;
  char *value = (char *) Malloc(length);
  if (grib_get_string(gribHandle, key, value, &length)) return false;
  int rc = str_is_equal(value, expectedValue);
  Free(value);
#else
  char *value = gribCopyString(gribHandle, key);
  int rc = value ? (strlen(value) + 1 == expectedLength ? str_is_equal(value, expectedValue) : false) : false;
  Free(value);
#endif
  return rc;
}

// A simple wrapper for grib_get_long() for the usecase that the result is only compared to a given constant value.
// Returns true if the key exists and the value is equal to the given one.
bool
gribCheckLong(grib_handle *gribHandle, const char *key, long expectedValue)
{
  long value;
  if (grib_get_long(gribHandle, key, &value)) return false;
  return value == expectedValue;
}

// A simple wrapper for grib_get_long() for the usecase that failure to fetch the value is fatal.
long
gribGetLong(grib_handle *gh, const char *key)
{
  long result;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, key, &result);
  return result;
}

// A simple wrapper for grib_get_long() for the usecase that a default value is used in the case that the operation fails.
long
gribGetLongDefault(grib_handle *gribHandle, const char *key, long defaultValue)
{
  long result;
  if (grib_get_long(gribHandle, key, &result) || result == GRIB_MISSING_LONG) result = defaultValue;
  return result;
}

// A simple wrapper for grib_get_double() for the usecase that failure to fetch the value is fatal.
double
gribGetDouble(grib_handle *gh, const char *key)
{
  double result;
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, key, &result);
  return result;
}

// A sample wrapper for grib_get_double() for the usecase that a default value is used in the case that the operation fails.
double
gribGetDoubleDefault(grib_handle *gribHandle, const char *key, double defaultValue)
{
  double result;
  if (grib_get_double(gribHandle, key, &result) || IS_EQUAL(result, GRIB_MISSING_DOUBLE)) result = defaultValue;
  return result;
}

// A simple wrapper for grib_get_size() for the usecase that failure to fetch the value is fatal.
size_t
gribGetArraySize(grib_handle *gribHandle, const char *key)
{
  size_t result;
  FAIL_ON_GRIB_ERROR(grib_get_size, gribHandle, key, &result);
  return result;
}

// A simple wrapper for grib_get_double_array() for the usecase that failure to fetch the data is fatal.
void
gribGetDoubleArray(grib_handle *gribHandle, const char *key, double *array)
{
  size_t valueCount = gribGetArraySize(gribHandle, key);
  FAIL_ON_GRIB_ERROR(grib_get_double_array, gribHandle, key, array, &valueCount);
}

// A simple wrapper for grib_get_long_array() for the usecase that failure to fetch the data is fatal.
void
gribGetLongArray(grib_handle *gribHandle, const char *key, long *array)
{
  size_t valueCount = gribGetArraySize(gribHandle, key);
  FAIL_ON_GRIB_ERROR(grib_get_long_array, gribHandle, key, array, &valueCount);
}

// We need the edition number so frequently, that it's convenient to give it its own function.
long
gribEditionNumber(grib_handle *gh)
{
  return gribGetLong(gh, "editionNumber");
}

// This return value of this should be passed to a call to resetTz(), it is a malloc'ed string with the content of the TZ
// environment variable before the call (or NULL if that was not set).
static char *
setUtc(void)
{
  char *temp = getenv("TZ"), *result = NULL;
  if (temp) result = strdup(temp);
  setenv("TZ", "UTC", 1);
  return result;
}

// Undoes the effect of setUtc(), pass to it the return value of the corresponding setUtc() call, it will free the string.
static void
resetTz(char *savedTz)
{
  if (savedTz)
  {
    setenv("TZ", savedTz, 1);
    Free(savedTz);
  }
  else { unsetenv("TZ"); }
}

// This function uses the system functions to normalize the date representation according to the gregorian calendar.
// Returns zero on success.
static int
normalizeDays(struct tm *me)
{
  char *savedTz = setUtc();  // Ensure that mktime() does not interprete the date according to our local time zone.

  int result = (mktime(me) == (time_t) -1);  // This does all the heavy lifting.

  resetTz(savedTz);
  return result;
}

// Returns zero on success.
static int
addSecondsToDate(struct tm *me, long long amount)
{
  // It is irrelevant here whether days are zero or one based, the correction would have be undone again so that it is effectless.
  long long seconds = ((me->tm_mday * 24ll + me->tm_hour) * 60 + me->tm_min) * 60
                      + me->tm_sec;  // The portion of the date that uses fixed increments.
  seconds += amount;
  me->tm_mday = (int) (seconds / 24 / 60 / 60);
  seconds -= (long long) me->tm_mday * 24 * 60 * 60;
  me->tm_hour = (int) (seconds / 60 / 60);
  seconds -= (long long) me->tm_hour * 60 * 60;
  me->tm_min = (int) (seconds / 60);
  seconds -= (long long) (me->tm_min * 60);
  me->tm_sec = (int) seconds;
  return normalizeDays(me);
}

static void
addMonthsToDate(struct tm *me, long long amount)
{
  long long months = me->tm_year * 12ll + me->tm_mon;
  months += amount;
  me->tm_year = (int) (months / 12);
  months -= (long long) me->tm_year * 12;
  me->tm_mon = (int) months;
}

// unit is a value according to code table 4.4 of the GRIB2 specification, returns non-zero on error
static int
addToDate(struct tm *me, long long amount, long unit)
{
  switch (unit)
  {
    case 0: return addSecondsToDate(me, 60 * amount);            // minute
    case 1: return addSecondsToDate(me, 60 * 60 * amount);       // hour
    case 2: return addSecondsToDate(me, 24 * 60 * 60 * amount);  // day

    case 3: addMonthsToDate(me, amount); return 0;             // month
    case 4: addMonthsToDate(me, 12 * amount); return 0;        // year
    case 5: addMonthsToDate(me, 10 * 12 * amount); return 0;   // decade
    case 6: addMonthsToDate(me, 30 * 12 * amount); return 0;   // normal
    case 7: addMonthsToDate(me, 100 * 12 * amount); return 0;  // century

    case 10: return addSecondsToDate(me, 3 * 60 * 60 * amount);   // eighth of a day
    case 11: return addSecondsToDate(me, 6 * 60 * 60 * amount);   // quarter day
    case 12: return addSecondsToDate(me, 12 * 60 * 60 * amount);  // half day
    case 13: return addSecondsToDate(me, amount);                 // second

    default: return 1;  // reserved, unknown, or missing
  }
}

static char *
makeDateString(struct tm *me)
{
  enum
  {
    size = 4 + 1 + 2 + 1 + 2 + 1 + 2 + 1 + 2 + 1 + 2 + 4 + 1
  };
  char *result = (char *) Malloc(size);
  assert(me->tm_year + 1900 < 10000 && me->tm_year + 1900 > -1000 && me->tm_mon >= 0 && me->tm_mon < 12 && me->tm_mday >= 1
         && me->tm_mday <= 31 && me->tm_hour >= 0 && me->tm_hour <= 24 && me->tm_min >= 0 && me->tm_min < 60 && me->tm_sec >= 0
         && me->tm_sec <= 60);
  int year = me->tm_year + 1900;
  if (year > 10000)
    year = 9999;
  else if (year < -999)
    year = -999;
  snprintf(result, size, "%04d-%02d-%02dT%02d:%02d:%02d.000", year, (me->tm_mon + 1) & 31, me->tm_mday & 31, me->tm_hour & 31,
           me->tm_min & 63, me->tm_sec & 63);
  return result;
}

// FIXME: This ignores any calendar definition that might be present.
// XXX: Identification templates are not implemented in grib_api-1.12.3, so even if I implemented the other calendars now, it
// wouldn't be possible to use them.
static int
getAvailabilityOfRelativeTimes(grib_handle *gh, bool *outHaveForecastTime, bool *outHaveTimeRange)
{
  switch (gribGetLong(gh, "productDefinitionTemplateNumber"))
  {
    case 20:
    case 30:
    case 31:
    case 254:
    case 311:
    case 2000: *outHaveForecastTime = false, *outHaveTimeRange = false; return 0;

    // case 55 and case 40455 are the same: 55 is the proposed standard value, 40455 is the value in the local use range that is
    // used by the dwd until the standard is updated.
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 15:
    case 32:
    case 33:
    case 40:
    case 41:
    case 44:
    case 45:
    case 48:
    case 51:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 60:
    case 1000:
    case 1002:
    case 1100:
    case 40033:
    case 40455:
    case 40456: *outHaveForecastTime = true, *outHaveTimeRange = false; return 0;

    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 34:
    case 42:
    case 43:
    case 46:
    case 47:
    case 61:
    case 67:
    case 68:
    case 91:
    case 1001:
    case 1101:
    case 40034: *outHaveForecastTime = true, *outHaveTimeRange = true; return 0;

    default: return 1;
  }
}

char *
gribMakeTimeString(grib_handle *gh, CdiTimeType timeType)
{
  // Get the parts of the reference date.
  struct tm date;
  date.tm_mon = (int) gribGetLong(gh, "month") - 1;  // months are zero based in struct tm and one based in GRIB
  date.tm_mday = (int) gribGetLong(gh, "day");
  date.tm_hour = (int) gribGetLong(gh, "hour");
  date.tm_min = (int) gribGetLong(gh, "minute");
  date.tm_isdst = 0;

  if (gribEditionNumber(gh) == 1)
  {
    date.tm_year = (int) gribGetLong(gh, "yearOfCentury");  // years are -1900 based both in struct tm and GRIB1
  }
  else
  {
    date.tm_year = (int) gribGetLong(gh, "year") - 1900;  // years are -1900 based in struct tm and zero based in GRIB2
    date.tm_sec = (int) gribGetLong(gh, "second");

    // If the start or end time are requested, we need to take the relative times into account.
    if (timeType != kCdiTimeType_referenceTime)
    {
      // Determine whether we have a forecast time and a time range.
      bool haveForecastTime, haveTimeRange;
      if (getAvailabilityOfRelativeTimes(gh, &haveForecastTime, &haveTimeRange)) return NULL;
      if (timeType == kCdiTimeType_endTime && !haveTimeRange)
        return NULL;  // tell the caller that the requested time does not exist

      // If we have relative times, apply the relative times to the date
      if (haveForecastTime)
      {
        long offset = gribGetLongDefault(gh, "forecastTime", 0);
        // if (stepUnits == indicatorOfUnitOfTimeRange) assert(startStep == forecastTime)
        long offsetUnit = gribGetLongDefault(gh, "indicatorOfUnitOfTimeRange", 255);
        if (addToDate(&date, offset, offsetUnit)) return NULL;
        if (timeType == kCdiTimeType_endTime)
        {
          assert(haveTimeRange);
          long range = gribGetLongDefault(gh, "lengthOfTimeRange", 0);
          // if (stepUnits == indicatorOfUnitForTimeRange) assert(endStep == startStep + lengthOfTimeRange)
          long rangeUnit = gribGetLongDefault(gh, "indicatorOfUnitForTimeRange", 255);
          if (addToDate(&date, range, rangeUnit)) return NULL;
        }
      }
    }
  }

  // Bake the date into a string.
  return makeDateString(&date);
}

int
gribapiTimeIsFC(grib_handle *gh)
{
  if (gribEditionNumber(gh) <= 1) return true;

  long sigofrtime;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "significanceOfReferenceTime", &sigofrtime);
  return sigofrtime != 3;
}

struct cdiGribAPI_ts_str_map_elem cdiGribAPI_ts_str_map[] = {
  // clang-format off
  [0]             = {  0, "" },
  [TSTEP_INSTANT] = {  0, "instant" },
  [TSTEP_AVG]     = {  8, "avg" },
  [TSTEP_ACCUM]   = {  8, "accum" },
  [TSTEP_MAX]     = {  8, "max" },
  [TSTEP_MIN]     = {  8, "min" },
  [TSTEP_DIFF]    = {  8, "diff" },
  [TSTEP_RMS]     = {  8, "rms" },
  [TSTEP_SD]      = {  8, "sd" },
  [TSTEP_COV]     = {  8, "cov" },
  [TSTEP_RATIO]   = {  8, "ratio" },
  [TSTEP_SUM]     = {  8, "sum" }
  // clang-format on
};

// Fetches the value of the "stepType" key and converts it into a constant in the TSTEP_* range.
int
gribapiGetTsteptype(grib_handle *gh)
{
  size_t len = 256;
  char stepType[256];
  int tsteptype = TSTEP_INSTANT;
  static bool lprint = true;

  if (gribapiTimeIsFC(gh))
  {
    int status = grib_get_string(gh, "stepType", stepType, &len);
    if (status == 0 && len > 1 && len < 256)
    {
      for (int i = TSTEP_INSTANT; i <= TSTEP_SUM; ++i)
        if (strncmp(cdiGribAPI_ts_str_map[i].sname, stepType, len) == 0)
        {
          tsteptype = i;
          goto tsteptypeFound;
        }

      if (lprint)
      {
        Message("Time stepType %s unsupported, set to instant!", stepType);
        lprint = false;
      }
      // printf("stepType: %s %ld %d\n", stepType, len, tsteptype);
    }

    long typeOfStat;
    status = grib_get_long(gh, "typeOfStatisticalProcessing", &typeOfStat);
    if (status == 0)
    {
      switch (typeOfStat)
      {
        case 0: return TSTEP_AVG;
        case 1: return TSTEP_ACCUM;
        case 2: return TSTEP_MAX;
        case 3: return TSTEP_MIN;
        case 4: return TSTEP_DIFF;
        case 5: return TSTEP_RMS;
        case 6: return TSTEP_SD;
        case 7: return TSTEP_COV;
        case 9: return TSTEP_RATIO;
        case 11: return TSTEP_SUM;
      }
    }

#ifdef HIRLAM_EXTENSIONS
    {
      // Normaly cdo looks in grib for attribute called "stepType", see above.
      // BUT NWP models such as Hirlam and Harmonie 37h1.2, use "timeRangeIndicator" instead!
      // Where for example:       0: for instanteneous fields; 4: for accumulated fields
      //  0:   Forecast product valid at reference time + P1
      //  2:   Product with a valid time ranging between reference time + P1 and reference time + P2
      //  4:   Accumulation (reference time + P1 to reference time + P2)
      //  5:   Difference(reference time + P2 minus reference time + P1) product considered valid at reference time + P2
      // More details on WMO standards:
      //               http://www.wmo.int/pages/prog/www/WDM/Guides/Guide-binary-2.html
      // tsteptype = TSTEP_INSTANT;  // default value for any case
      long timeRangeIND = 0;  // typically 0: for instanteneous fields; 4: for accumulated fields
      int rc = grib_get_long(gh, "timeRangeIndicator", &timeRangeIND);
      if (rc != 0)
      {
        // if ( lprint )
        Warning("Could not get 'stepType' either 'timeRangeIndicator'. Using default!");
        return tsteptype;
      }
      extern int cdiGribUseTimeRangeIndicator;
      cdiGribUseTimeRangeIndicator = 1;
      switch (timeRangeIND)
      {
        case 0: tsteptype = TSTEP_INSTANT; break;
        case 2:
          tsteptype = TSTEP_INSTANT2;
          strcpy(stepType, "instant2");
          break;  // was incorrectly set before into accum
        case 4: tsteptype = TSTEP_ACCUM; break;
        case 5: tsteptype = TSTEP_DIFF; break;
        default:
          if (lprint)
          {
            if (CDI_Debug)
              Warning("timeRangeIND = %d;  stepType= %s; tsteptype=%d unsupported timeRangeIND at the moment, set to instant!",
                      timeRangeIND, stepType, tsteptype);
            lprint = false;
          }
          break;
      }
      if (CDI_Debug) Warning("timeRangeIND = %d;  stepType= %s; tsteptype=%d", timeRangeIND, stepType, tsteptype);
    }
#endif  // HIRLAM_EXTENSIONS
  }

tsteptypeFound:
  return tsteptype;
}

int
gribGetDatatype(grib_handle *gribHandle)
{
  int datatype;
  if (gribEditionNumber(gribHandle) > 1 && gribCheckString(gribHandle, "packingType", "grid_ieee"))
  {
    datatype = gribCheckLong(gribHandle, "precision", 1) ? CDI_DATATYPE_FLT32 : CDI_DATATYPE_FLT64;
  }
  else
  {
    long bitsPerValue;
    datatype = (!grib_get_long(gribHandle, "bitsPerValue", &bitsPerValue) && bitsPerValue > 0 && bitsPerValue <= 32)
                   ? (int) bitsPerValue
                   : CDI_DATATYPE_PACK;
  }
  return datatype;
}

int
gribapiGetParam(grib_handle *gh)
{
  long pdis, pcat, pnum;
  if (gribEditionNumber(gh) <= 1)
  {
    pdis = 255;
    FAIL_ON_GRIB_ERROR(grib_get_long, gh, "table2Version", &pcat);
    FAIL_ON_GRIB_ERROR(grib_get_long, gh, "indicatorOfParameter", &pnum);
  }
  else
  {
    FAIL_ON_GRIB_ERROR(grib_get_long, gh, "discipline", &pdis);
    if (grib_get_long(gh, "parameterCategory", &pcat)) pcat = 0;
    if (grib_get_long(gh, "parameterNumber", &pnum)) pnum = 0;
  }
  return cdiEncodeParam((int) pnum, (int) pcat, (int) pdis);
}

static bool
has_ni(grib_handle *gh)
{
  return (gribGetLong(gh, "Ni") != (long) GRIB_MISSING_LONG);
}

int
gribapiGetGridType(grib_handle *gh)
{
  long gridDefinitionTemplateNumber = gribGetLongDefault(gh, "gridDefinitionTemplateNumber", -1);
  switch (gridDefinitionTemplateNumber)
  {
    case GRIB2_GTYPE_LATLON: return has_ni(gh) ? GRID_LONLAT : GRID_GENERIC;
    case GRIB2_GTYPE_GAUSSIAN: return has_ni(gh) ? GRID_GAUSSIAN : GRID_GAUSSIAN_REDUCED;
    case GRIB2_GTYPE_LATLON_ROT: return GRID_PROJECTION;
    case GRIB2_GTYPE_LCC: return CDI_PROJ_LCC;
    case GRIB2_GTYPE_LLAM: return CDI_PROJ_LCC;  // Handle LLAM as LCC
    case GRIB2_GTYPE_STERE: return CDI_PROJ_STERE;
    case GRIB2_GTYPE_SPECTRAL: return GRID_SPECTRAL;
    case GRIB2_GTYPE_GME: return GRID_GME;
    case GRIB2_GTYPE_UNSTRUCTURED: return GRID_UNSTRUCTURED;
    case GRIB2_GTYPE_HEALPIX: return CDI_PROJ_HEALPIX;
    // case GRIB2_GTYPE_HEALPIX: return GRID_HEALPIX;
    default:
    {
      static bool lwarn = true;
      if (lwarn)
      {
        lwarn = false;
        char mesg[256];
        size_t len = sizeof(mesg);
        if (grib_get_string(gh, "gridType", mesg, &len) != 0) mesg[0] = 0;
        Warning("gridDefinitionTemplateNumber %d unsupported (gridType=%s)!", gridDefinitionTemplateNumber, mesg);
      }
    }
  }

  return GRID_GENERIC;
}

static int
gribapiGetIsRotated(grib_handle *gh)
{
  return gribGetLongDefault(gh, "gridDefinitionTemplateNumber", -1) == GRIB2_GTYPE_LATLON_ROT;
}

size_t
gribapiGetGridsize(grib_handle *gh)
{
  size_t gridsize;
  FAIL_ON_GRIB_ERROR(grib_get_size, gh, "values", &gridsize);
  return gridsize;
}

static void
gribapiGetGridGaussianReduced(grib_handle *gh, grid_t *grid, long editionNumber, size_t numberOfPoints)
{
  long lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "numberOfParallelsBetweenAPoleAndTheEquator", &lpar);
  grid->np = (int) lpar;

  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "Nj", &lpar);
  size_t nlat = (size_t) lpar;

  grid->size = numberOfPoints;

  grid->reducedPointsSize = (int) nlat;
  grid->reducedPoints = (int *) Malloc(nlat * sizeof(int));
  long *pl = (long *) Malloc(nlat * sizeof(long));
  size_t dummy = nlat;
  FAIL_ON_GRIB_ERROR(grib_get_long_array, gh, "pl", pl, &dummy);
  for (size_t i = 0; i < nlat; ++i) grid->reducedPoints[i] = (int) pl[i];
  Free(pl);

  grid->y.size = nlat;
  grid->x.inc = 0;
  grid->y.inc = 0;
  grid->x.flag = 0;
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "longitudeOfFirstGridPointInDegrees", &grid->x.first);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "longitudeOfLastGridPointInDegrees", &grid->x.last);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "latitudeOfFirstGridPointInDegrees", &grid->y.first);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "latitudeOfLastGridPointInDegrees", &grid->y.last);

  // FAIL_ON_GRIB_ERROR(grib_get_double, gh, "iDirectionIncrementInDegrees", &grid->x.inc);
  // if ( IS_EQUAL(grid->x.inc, GRIB_MISSING_DOUBLE) ) grid->x.inc = 0;

  if (grid->x.last < grid->x.first)
  {
    if (grid->x.first >= 180.0)
      grid->x.first -= 360.0;
    else
      grid->x.last += 360.0;
  }

  grid->x.flag = 2;

  grid->y.flag = 0;
  // if (IS_NOT_EQUAL(grid->y.first, 0) || IS_NOT_EQUAL(grid->y.last, 0))
  {
    if (grid->y.size > 1)
    {
      if (editionNumber <= 1) {}
    }
    grid->y.flag = 2;
  }
}

static void
gribapiGetGridRegular(grib_handle *gh, grid_t *grid, long editionNumber, int gridtype, size_t numberOfPoints)
{
  long lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "Ni", &lpar);
  size_t nlon = (size_t) lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "Nj", &lpar);
  size_t nlat = (size_t) lpar;

  if (gridtype == GRID_GAUSSIAN)
  {
    FAIL_ON_GRIB_ERROR(grib_get_long, gh, "numberOfParallelsBetweenAPoleAndTheEquator", &lpar);
    grid->np = (int) lpar;
  }

  if (numberOfPoints != nlon * nlat) Error("numberOfPoints (%zu) and gridSize (%zu) differ!", numberOfPoints, nlon * nlat);

  grid->size = numberOfPoints;
  grid->x.size = nlon;
  grid->y.size = nlat;
  grid->x.inc = 0;
  grid->y.inc = 0;
  grid->x.flag = 0;
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "longitudeOfFirstGridPointInDegrees", &grid->x.first);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "longitudeOfLastGridPointInDegrees", &grid->x.last);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "latitudeOfFirstGridPointInDegrees", &grid->y.first);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "latitudeOfLastGridPointInDegrees", &grid->y.last);
  if (nlon > 1) FAIL_ON_GRIB_ERROR(grib_get_double, gh, "iDirectionIncrementInDegrees", &grid->x.inc);
  if (gridtype == GRID_LONLAT && nlat > 1) FAIL_ON_GRIB_ERROR(grib_get_double, gh, "jDirectionIncrementInDegrees", &grid->y.inc);

  long iscan = 0, jscan = 0;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "iScansNegatively", &iscan);
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "jScansPositively", &jscan);
  if (iscan) grid->x.inc = -grid->x.inc;
  if (!jscan) grid->y.inc = -grid->y.inc;

  if (grid->x.inc < -999 || grid->x.inc > 999) grid->x.inc = 0;
  if (grid->y.inc < -999 || grid->y.inc > 999) grid->y.inc = 0;

  // if ( IS_NOT_EQUAL(grid->x.first, 0) || IS_NOT_EQUAL(grid->x.last, 0) )
  {
    if (grid->x.size > 1)
    {
      // if ( editionNumber <= 1 )
      {
        if (grid->x.last < grid->x.first)
        {
          if (grid->x.first >= 180)
            grid->x.first -= 360;
          else
            grid->x.last += 360;
        }

        // correct xinc if necessary
        if (IS_EQUAL(grid->x.first, 0) && grid->x.last > 354 && grid->x.last < 360)
        {
          double xinc = 360. / (double) grid->x.size;
          if (fabs(grid->x.inc - xinc) > 0.0)
          {
            grid->x.inc = xinc;
            if (CDI_Debug) Message("set xinc to %g", grid->x.inc);
          }
        }
      }
    }
    grid->x.flag = 2;
  }

  grid->y.flag = 0;
  // if ( IS_NOT_EQUAL(grid->y.first, 0) || IS_NOT_EQUAL(grid->y.last, 0) )
  {
    if (grid->y.size > 1)
    {
      if (editionNumber <= 1) {}
    }
    grid->y.flag = 2;
  }
}

static void
gribapiGetGridProj(grib_handle *gh, grid_t *grid, size_t numberOfPoints)
{
  long lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "Nx", &lpar);
  size_t nlon = (size_t) lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "Ny", &lpar);
  size_t nlat = (size_t) lpar;

  if (numberOfPoints != nlon * nlat) Error("numberOfPoints (%zu) and gridSize (%zu) differ!", numberOfPoints, nlon * nlat);

  grid->size = numberOfPoints;
  grid->x.size = nlon;
  grid->y.size = nlat;

  double xinc, yinc;
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "DxInMetres", &xinc);
  FAIL_ON_GRIB_ERROR(grib_get_double, gh, "DyInMetres", &yinc);

  grid->x.first = 0;
  grid->x.last = 0;
  grid->x.inc = xinc;
  grid->y.first = 0;
  grid->y.last = 0;
  grid->y.inc = yinc;
  grid->x.flag = 2;
  grid->y.flag = 2;
}

static void
gribapiGetProjHealpix(grib_handle *gh, grid_t *grid, size_t numberOfPoints)
{
  (void) gh;
  grid->size = numberOfPoints;
}

static void
gribapiGetGridHealpix(grib_handle *gh, grid_t *grid, size_t numberOfPoints)
{
  (void) gh;
  grid->size = numberOfPoints;
}

static void
gribapiGetGridSpectral(grib_handle *gh, grid_t *grid, size_t datasize)
{
  size_t len = 256;
  char typeOfPacking[256];
  FAIL_ON_GRIB_ERROR(grib_get_string, gh, "packingType", typeOfPacking, &len);
  grid->lcomplex = 0;
  if (strncmp(typeOfPacking, "spectral_complex", len) == 0) grid->lcomplex = 1;

  grid->size = datasize;

  long lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "J", &lpar);
  grid->trunc = (int) lpar;
}

static void
gribapiGetGridGME(grib_handle *gh, grid_t *grid, size_t numberOfPoints)
{
  grid->size = numberOfPoints;

  long lpar;
  if (grib_get_long(gh, "nd", &lpar) == 0) grid->gme.nd = (int) lpar;
  if (grib_get_long(gh, "Ni", &lpar) == 0) grid->gme.ni = (int) lpar;
  if (grib_get_long(gh, "n2", &lpar) == 0) grid->gme.ni2 = (int) lpar;
  if (grib_get_long(gh, "n3", &lpar) == 0) grid->gme.ni3 = (int) lpar;
}

static void
gribapiGetGridUnstructured(grib_handle *gh, grid_t *grid, size_t numberOfPoints)
{
  unsigned char uuid[CDI_UUID_SIZE];
  /*
    char reference_link[8192];
    size_t len = sizeof(reference_link);
    reference_link[0] = 0;
  */
  grid->size = numberOfPoints;

  long lpar;
  if (grib_get_long(gh, "numberOfGridUsed", &lpar) == 0)
  {
    cdiDefVarKeyInt(&grid->keys, CDI_KEY_NUMBEROFGRIDUSED, (int) lpar);
    if (grib_get_long(gh, "numberOfGridInReference", &lpar) == 0)
      cdiDefVarKeyInt(&grid->keys, CDI_KEY_NUMBEROFGRIDINREFERENCE, (int) lpar);
    /*
      if ( grib_get_string(gh, "gridDescriptionFile", reference_link, &len) == 0 )
      {
      if ( strncmp(reference_link, "file://", 7) == 0 )
      grid->reference = strdup(reference_link);
      }
    */
    size_t len = (size_t) CDI_UUID_SIZE;
    if (grib_get_bytes(gh, "uuidOfHGrid", uuid, &len) == 0) cdiDefVarKeyBytes(&grid->keys, CDI_KEY_UUID, uuid, CDI_UUID_SIZE);
  }
}

static void
gribapiGetGridGeneric(grib_handle *gh, grid_t *grid, size_t numberOfPoints)
{
  long lpar;
  size_t nlon = (grib_get_long(gh, "Ni", &lpar) == 0) ? (size_t) lpar : 0;
  size_t nlat = (grib_get_long(gh, "Nj", &lpar) == 0) ? (size_t) lpar : 0;

  grid->size = numberOfPoints;

  bool lgeneric = (nlon > 0 && nlat > 0 && nlon * nlat == numberOfPoints);
  grid->x.size = lgeneric ? nlon : 0;
  grid->y.size = lgeneric ? nlat : 0;
}

// TODO: Simplify by use of the convenience functions (gribGetLong(), gribGetLongDefault(), etc.).
bool
gribapiGetGrid(grib_handle *gh, grid_t *grid)
{
  bool uvRelativeToGrid = false;
  long editionNumber = gribEditionNumber(gh);
  int gridtype = gribapiGetGridType(gh);
  int projtype = (gridtype == GRID_PROJECTION && gribapiGetIsRotated(gh)) ? CDI_PROJ_RLL : CDI_UNDEFID;
  if (gridtype == CDI_PROJ_LCC || gridtype == CDI_PROJ_STERE || gridtype == CDI_PROJ_HEALPIX)
  {
    projtype = gridtype;
    gridtype = GRID_PROJECTION;
  }
  /*
  if ( streamptr->unreduced && gridtype == GRID_GAUSSIAN_REDUCED )
    {
      gridtype = GRID_GAUSSIAN;
      ISEC2_NumLon = 2*ISEC2_NumLat;
      ISEC4_NumValues = ISEC2_NumLon*ISEC2_NumLat;
    }
  */
  grid_init(grid);
  cdiGridTypeInit(grid, gridtype, 0);

  size_t datasize;
  FAIL_ON_GRIB_ERROR(grib_get_size, gh, "values", &datasize);
  long lpar;
  FAIL_ON_GRIB_ERROR(grib_get_long, gh, "numberOfPoints", &lpar);
  size_t numberOfPoints = (size_t) lpar;

  if (gridtype == GRID_LONLAT || gridtype == GRID_GAUSSIAN || projtype == CDI_PROJ_RLL)
  {
    gribapiGetGridRegular(gh, grid, editionNumber, gridtype, numberOfPoints);
  }
  else if (gridtype == GRID_GAUSSIAN_REDUCED) { gribapiGetGridGaussianReduced(gh, grid, editionNumber, numberOfPoints); }
  else if (projtype == CDI_PROJ_LCC) { gribapiGetGridProj(gh, grid, numberOfPoints); }
  else if (projtype == CDI_PROJ_STERE) { gribapiGetGridProj(gh, grid, numberOfPoints); }
  else if (projtype == CDI_PROJ_HEALPIX) { gribapiGetProjHealpix(gh, grid, numberOfPoints); }
  else if (gridtype == GRID_HEALPIX) { gribapiGetGridHealpix(gh, grid, numberOfPoints); }
  else if (gridtype == GRID_SPECTRAL) { gribapiGetGridSpectral(gh, grid, datasize); }
  else if (gridtype == GRID_GME) { gribapiGetGridGME(gh, grid, numberOfPoints); }
  else if (gridtype == GRID_UNSTRUCTURED) { gribapiGetGridUnstructured(gh, grid, numberOfPoints); }
  else if (gridtype == GRID_GENERIC) { gribapiGetGridGeneric(gh, grid, numberOfPoints); }
  else { Error("Unsupported grid type: %s", gridNamePtr(gridtype)); }

  if (gridtype == GRID_GAUSSIAN || gridtype == GRID_LONLAT || projtype == CDI_PROJ_RLL || projtype == CDI_PROJ_LCC
      || projtype == CDI_PROJ_HEALPIX)
  {
    long temp = 0;
    GRIB_CHECK(grib_get_long(gh, "uvRelativeToGrid", &temp), 0);
    assert(temp == 0 || temp == 1);
    uvRelativeToGrid = (bool) temp;
  }

  if (gridtype == GRID_GAUSSIAN || gridtype == GRID_LONLAT || (gridtype == GRID_PROJECTION && projtype != CDI_PROJ_HEALPIX))
  {
    long iScansNegatively, jScansPositively, jPointsAreConsecutive;
    GRIB_CHECK(grib_get_long(gh, "iScansNegatively", &iScansNegatively), 0);
    GRIB_CHECK(grib_get_long(gh, "jScansPositively", &jScansPositively), 0);
    GRIB_CHECK(grib_get_long(gh, "jPointsAreConsecutive", &jPointsAreConsecutive), 0);

    int scanningMode = (int) (128 * iScansNegatively + 64 * jScansPositively + 32 * jPointsAreConsecutive);
    cdiDefVarKeyInt(&grid->keys, CDI_KEY_SCANNINGMODE, scanningMode);
    /* scanningMode  = 128 * iScansNegatively + 64 * jScansPositively + 32 * jPointsAreConsecutive;
                 64  = 128 * 0                + 64 *        1         + 32 * 0
                 00  = 128 * 0                + 64 *        0         + 32 * 0
                 96  = 128 * 0                + 64 *        1         + 32 * 1
       Default / implicit scanning mode is 64:
                          i and j scan positively, i points are consecutive (row-major)        */
#ifdef HIRLAM_EXTENSIONS
    if (cdiDebugExt >= 30 && editionNumber <= 1)
    {
      //  indicatorOfParameter=33,indicatorOfTypeOfLevel=105,level
      long paramId, levelTypeId, levelId;
      GRIB_CHECK(grib_get_long(gh, "indicatorOfParameter", &paramId), 0);
      GRIB_CHECK(grib_get_long(gh, "indicatorOfTypeOfLevel", &levelTypeId), 0);
      GRIB_CHECK(grib_get_long(gh, "level", &levelId), 0);
      Message("(param,ltype,level) = (%3d,%3d,%4d); Scanning mode = %02d -> bits:(%1d.%1d.%1d)*32;  uvRelativeToGrid = %02d",
              (int) paramId, (int) levelTypeId, (int) levelId, scanningMode, jPointsAreConsecutive, jScansPositively,
              iScansNegatively, uvRelativeToGrid);
    }
#endif  // HIRLAM_EXTENSIONS
  }

  grid->type = gridtype;
  grid->projtype = projtype;

  return uvRelativeToGrid;
}
#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef CDI_UUID_H
#define CDI_UUID_H

#ifdef HAVE_CONFIG_H
#endif


// clang-format off
#ifdef __cplusplus
extern "C" {
#endif

enum {
  uuidNumHexChars = 36,
};

static inline
int cdiUUIDIsNull(const unsigned char uuid[])
{
  int isNull = 1;
  for (size_t i = 0; i < CDI_UUID_SIZE; ++i) isNull &= (uuid[i] == 0);
  return isNull;
}

#ifndef _WIN32
void cdiCreateUUID(unsigned char uuid[CDI_UUID_SIZE]);
#endif

int cdiUUID2Str(const unsigned char uuid[], char uuidstr[]);
int cdiStr2UUID(const char *uuidstr, unsigned char uuid[]);

#ifdef __cplusplus
}
#endif
// clang-format on

#endif
#ifndef RESOURCE_UNPACK_H
#define RESOURCE_UNPACK_H

#ifdef HAVE_CONFIG_H
#endif

enum
{
  GRID = 1,
  ZAXIS = 2,
  TAXIS = 3,
  INSTITUTE = 4,
  MODEL = 5,
  STREAM = 6,
  VLIST = 7,
  DIST_GRID = 8,
  RESH_DELETE,
  START = 55555555,
  END = 99999999
};

typedef void (*cdiPostResUpdateHook)(int resH, int resType);

int reshUnpackResources(char *unpackBuffer, int unpackBufferSize, void *context, cdiPostResUpdateHook postHook);

extern int (*reshDistGridUnpack)(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context,
                                 int force_id);
#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef VLIST_H
#define VLIST_H

#ifdef HAVE_CONFIG_H
#endif

#ifndef ERROR_H
#endif

#include <stdbool.h>
#include <stddef.h> /* size_t */

#ifndef CDI_LIMITS_H
#endif

#define VALIDMISS 1.e+303


typedef struct
{
  bool flag;
  int index;
  int mlevelID;
  int flevelID;
} levinfo_t;

#define DEFAULT_LEVINFO(levID) \
  (levinfo_t) { 0, -1, levID, levID }
/*
#define DEFAULT_LEVINFO(levID) \
  (levinfo_t){ .flag = 0, .index = -1, .flevelID = levID, .mlevelID = levID}
*/
typedef struct
{
  int ens_index;
  int ens_count;
  int forecast_init_type;
} ensinfo_t;

typedef struct
{
  bool isUsed;
  bool flag;
  bool lvalidrange;
  signed char xyz;   /* order of spatial dimensions,
                      * a permutation of 123 */
  bool missvalused;  // true if missval is defined
  int mvarID;
  int fvarID;
  int param;
  int gridID;
  int zaxisID;
  int timetype;   // TIME_*
  int tsteptype;  // TSTEP_*
  int datatype;   // CDI_DATATYPE_PACKX for GRIB data, else CDI_DATATYPE_FLT32 or CDI_DATATYPE_FLT64
  int instID;
  int modelID;
  int tableID;
  int timave;
  int nsb;  // Number of significant bits
  double missval;
  double validrange[2];
  levinfo_t *levinfo;
  int comptype;   // compression type
  int complevel;  // compression level
  cdi_keys_t keys;
  cdi_atts_t atts;
  int subtypeID;  // subtype ID for tile-related meta-data, currently for GRIB-API only.

  int opt_grib_nentries;                // current no. key-value pairs
  int opt_grib_kvpair_size;             // current allocated size
  opt_key_val_pair_t *opt_grib_kvpair;  // (optional) list of keyword/value pairs
} var_t;

typedef struct
{
  // set when a vlist is passed to streamDefVlist() to safeguard against modifications of the wrong vlist object
  bool immutable;
  // set if this vlist has been created by CDI itself, and must not be destroyed by the user, consequently
  bool internal;
  int self;
  int nvars;  // number of variables
  int ngrids;
  int nzaxis;
  int nsubtypes;  // no. of variable subtypes (e.g. sets of tiles)
  long ntsteps;
  int taxisID;
  int tableID;
  int instID;
  int modelID;
  int varsAllocated;
  int gridIDs[MAX_GRIDS_PS];
  int zaxisIDs[MAX_ZAXES_PS];
  int subtypeIDs[MAX_SUBTYPES_PS];
  var_t *vars;
  cdi_keys_t keys;
  cdi_atts_t atts;
} vlist_t;

vlist_t *vlist_to_pointer(int vlistID);
void cdiVlistMakeInternal(int vlistID);
void cdiVlistMakeImmutable(int vlistID);
void cdiVlistDestroy_(int vlistID, bool assertInternal);
int vlistInqVarMissvalUsed(int vlistID, int varID);
int vlistHasTime(int vlistID);

int vlistUnpack(char *buffer, int bufferSize, int *pos, int originNamespace, void *context, int force_id);

/*      vlistDefVarValidrange: Define the valid range of a Variable */
void vlistDefVarValidrange(int vlistID, int varID, const double *validrange);

/*      vlistInqVarValidrange: Get the valid range of a Variable */
int vlistInqVarValidrange(int vlistID, int varID, double *validrange);

void vlistInqVarDimorder(int vlistID, int varID, int outDimorder[3]);

void resize_opt_grib_entries(var_t *var, int nentries);

static inline void
vlistAdd2GridIDs(vlist_t *vlistptr, int gridID)
{
  int index, ngrids = vlistptr->ngrids;
  for (index = 0; index < ngrids; index++)
  {
    if (vlistptr->gridIDs[index] == gridID) break;
    //      if ( gridIsEqual(vlistptr->gridIDs[index], gridID) ) break;
  }

  if (index == ngrids)
  {
    if (ngrids >= MAX_GRIDS_PS) Error("Internal limit exceeded: more than %d grids.", MAX_GRIDS_PS);
    vlistptr->gridIDs[ngrids] = gridID;
    ++(vlistptr->ngrids);
  }
}

static inline void
vlistAdd2ZaxisIDs(vlist_t *vlistptr, int zaxisID)
{
  int index, nzaxis = vlistptr->nzaxis;
  for (index = 0; index < nzaxis; index++)
    if (zaxisID == vlistptr->zaxisIDs[index]) break;

  if (index == nzaxis)
  {
    if (nzaxis >= MAX_ZAXES_PS) Error("Internal limit exceeded: more than %d zaxis.", MAX_ZAXES_PS);
    vlistptr->zaxisIDs[nzaxis] = zaxisID;
    ++(vlistptr->nzaxis);
  }
}

static inline void
vlistAdd2SubtypeIDs(vlist_t *vlistptr, int subtypeID)
{
  if (subtypeID == CDI_UNDEFID) return;

  int index, nsubs = vlistptr->nsubtypes;
  for (index = 0; index < nsubs; index++)
    if (vlistptr->subtypeIDs[index] == subtypeID) break;

  if (index == nsubs)
  {
    if (nsubs >= MAX_SUBTYPES_PS) Error("Internal limit exceeded: more than %d subs.", MAX_SUBTYPES_PS);
    vlistptr->subtypeIDs[nsubs] = subtypeID;
    ++(vlistptr->nsubtypes);
  }
}

#ifdef HAVE_LIBGRIB_API
extern int cdiNAdditionalGRIBKeys;
extern char *cdiAdditionalGRIBKeys[];
#endif

extern const resOps vlistOps;

#endif /* VLIST_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif

#include <assert.h>
#include <string.h>


int (*proj_lonlat_to_lcc_func)(struct CDI_GridProjParams gpp, size_t, double *, double *) = NULL;
int (*proj_lcc_to_lonlat_func)(struct CDI_GridProjParams gpp, double, double, size_t, double *, double *) = NULL;
int (*proj_lonlat_to_stere_func)(struct CDI_GridProjParams gpp, size_t, double *, double *) = NULL;
int (*proj_stere_to_lonlat_func)(struct CDI_GridProjParams gpp, double, double, size_t, double *, double *) = NULL;

// the value in the second pair of brackets must match the length of the longest string (including terminating NUL)
static const char Grids[][17] = {
  /*  0 */ "undefined",
  /*  1 */ "generic",
  /*  2 */ "gaussian",
  /*  3 */ "gaussian_reduced",
  /*  4 */ "lonlat",
  /*  5 */ "spectral",
  /*  6 */ "fourier",
  /*  7 */ "gme",
  /*  8 */ "trajectory",
  /*  9 */ "unstructured",
  /* 10 */ "curvilinear",
  /* 11 */ "healpix",
  /* 12 */ "projection",
  /* 13 */ "characterXY",
};

// must match table below
enum xystdname_idx
{
  grid_xystdname_grid_latlon,
  grid_xystdname_latlon,
  grid_xystdname_projection,
  grid_xystdname_char,
};
static const char xystdname_tab[][2][24] = {
  [grid_xystdname_grid_latlon] = { "grid_longitude", "grid_latitude" },
  [grid_xystdname_latlon] = { "longitude", "latitude" },
  [grid_xystdname_projection] = { "projection_x_coordinate", "projection_y_coordinate" },
  [grid_xystdname_char] = { "region", "region" },
};

static int gridCompareP(void *gridptr1, void *gridptr2);
static void gridDestroyP(void *gridptr);
static void gridPrintP(void *gridptr, FILE *fp);
static int gridGetPackSize(void *gridptr, void *context);
static void gridPack(void *gridptr, void *buff, int size, int *position, void *context);
static int gridTxCode(void *gridptr);

static const resOps gridOps = { gridCompareP, gridDestroyP, gridPrintP, gridGetPackSize, gridPack, gridTxCode };

grid_t *
grid_to_pointer(int gridID)
{
  return (grid_t *) reshGetVal(gridID, &gridOps);
}

#define gridMark4Update(gridID) reshSetStatus(gridID, &gridOps, RESH_DESYNC_IN_USE)

static inline bool
grid_is_irregular(int gridType)
{
  return (gridType == GRID_UNSTRUCTURED || gridType == GRID_CURVILINEAR);
}

static bool
cdiInqAttConvertedToFloat(int gridID, int atttype, const char *attname, int attlen, double *attflt)
{
  bool status = true;

  if (atttype == CDI_DATATYPE_INT32)
  {
    int attint = 0;
    int *pattint = attlen > 1 ? (int *) Malloc((size_t) attlen * sizeof(int)) : &attint;
    cdiInqAttInt(gridID, CDI_GLOBAL, attname, attlen, pattint);
    for (int i = 0; i < attlen; ++i) attflt[i] = (double) pattint[i];
    if (attlen > 1) Free(pattint);
  }
  else if (atttype == CDI_DATATYPE_FLT32 || atttype == CDI_DATATYPE_FLT64)
  {
    cdiInqAttFlt(gridID, CDI_GLOBAL, attname, attlen, attflt);
  }
  else { status = false; }

  return status;
}

static void
grid_axis_init(struct gridaxis_t *axisptr)
{
  axisptr->size = 0;
  axisptr->vals = NULL;
  axisptr->bounds = NULL;
  axisptr->flag = 0;
  axisptr->first = 0.0;
  axisptr->last = 0.0;
  axisptr->inc = 0.0;
#ifndef USE_MPI
  axisptr->clength = 0;
  axisptr->cvals = NULL;
#endif
  cdiInitKeys(&axisptr->keys);
}

enum cdiApplyRet
cdiGridApply(enum cdiApplyRet (*func)(int id, void *res, void *data), void *data)
{
  return cdiResHFilterApply(&gridOps, func, data);
}

void
grid_init(grid_t *gridptr)
{
  gridptr->self = CDI_UNDEFID;
  gridptr->type = CDI_UNDEFID;
  gridptr->datatype = CDI_UNDEFID;
  gridptr->proj = CDI_UNDEFID;
  gridptr->projtype = CDI_UNDEFID;
  gridptr->mask = NULL;
  gridptr->mask_gme = NULL;
  gridptr->size = 0;

  grid_axis_init(&gridptr->x);
  grid_axis_init(&gridptr->y);

  gridptr->indices = NULL;
  gridptr->area = NULL;
  gridptr->reducedPoints = NULL;
  gridptr->reducedPointsSize = 0;

  gridptr->gme.nd = 0;
  gridptr->gme.ni = 0;
  gridptr->gme.ni2 = 0;
  gridptr->gme.ni3 = 0;

  gridptr->trunc = 0;
  gridptr->nvertex = 0;
  gridptr->np = 0;
  gridptr->isCyclic = CDI_UNDEFID;

  gridptr->lcomplex = false;
  gridptr->hasdims = true;
  gridptr->name = NULL;
  gridptr->vtable = &cdiGridVtable;

  cdiInitKeys(&gridptr->keys);
  gridptr->atts.nalloc = MAX_ATTRIBUTES;
  gridptr->atts.nelems = 0;

  cdiDefVarKeyInt(&gridptr->keys, CDI_KEY_DATATYPE, CDI_DATATYPE_FLT64);
#ifdef HIRLAM_EXTENSIONS
  cdiDefVarKeyInt(&gridptr->keys, CDI_KEY_SCANNINGMODE, 64);
#endif

  gridptr->extraData = NULL;
}

static void
grid_free_components(grid_t *gridptr)
{
  void *p2free[] = { gridptr->indices,  gridptr->mask,     gridptr->mask_gme,      gridptr->x.vals, gridptr->y.vals,
#ifndef USE_MPI
                     gridptr->x.cvals,  gridptr->y.cvals,
#endif
                     gridptr->x.bounds, gridptr->y.bounds, gridptr->reducedPoints, gridptr->area,   gridptr->name };

  for (size_t i = 0; i < sizeof(p2free) / sizeof(p2free[0]); ++i)
    if (p2free[i]) Free(p2free[i]);

  cdiDeleteVarKeys(&(gridptr->x.keys));
  cdiDeleteVarKeys(&(gridptr->y.keys));
  cdiDeleteVarKeys(&(gridptr->keys));
  /* 12 pio tests fail
  int gridID = gridptr->self;
  if (gridID != CDI_UNDEFID) cdiDeleteAtts(gridID, CDI_GLOBAL);
  */
}

void
grid_free(grid_t *gridptr)
{
  if (gridptr)
  {
    grid_free_components(gridptr);
    grid_init(gridptr);
  }
}

static grid_t *
gridNewEntry(cdiResH resH)
{
  grid_t *gridptr = (grid_t *) Malloc(sizeof(grid_t));
  grid_init(gridptr);

  if (resH == CDI_UNDEFID)
    gridptr->self = reshPut(gridptr, &gridOps);
  else
  {
    gridptr->self = resH;
    reshReplace(resH, gridptr, &gridOps);
  }

  return gridptr;
}

static void
gridInit(void)
{
  static bool gridInitialized = false;
  if (gridInitialized) return;
  gridInitialized = true;
}

static void
grid_copy_base_scalar_fields(grid_t *gridptrOrig, grid_t *gridptrDup)
{
  memcpy(gridptrDup, gridptrOrig, sizeof(grid_t));
  gridptrDup->self = CDI_UNDEFID;
  cdiInitKeys(&gridptrDup->keys);
  cdiCopyVarKeys(&gridptrOrig->keys, &gridptrDup->keys);
  cdiInitKeys(&gridptrDup->x.keys);
  cdiCopyVarKeys(&gridptrOrig->x.keys, &gridptrDup->x.keys);
  cdiInitKeys(&gridptrDup->y.keys);
  cdiCopyVarKeys(&gridptrOrig->y.keys, &gridptrDup->y.keys);
}

static grid_t *
grid_copy_base(grid_t *gridptrOrig)
{
  grid_t *gridptrDup = (grid_t *) Malloc(sizeof(*gridptrDup));
  gridptrOrig->vtable->copyScalarFields(gridptrOrig, gridptrDup);
  gridptrOrig->vtable->copyArrayFields(gridptrOrig, gridptrDup);
  return gridptrDup;
}

unsigned
cdiGridCount(void)
{
  return reshCountType(&gridOps);
}

static inline void
gridaxisSetKey(struct gridaxis_t *axisptr, int key, const char *name)
{
  if (find_key(&axisptr->keys, key) == NULL)
    cdiDefVarKeyBytes(&axisptr->keys, key, (const unsigned char *) name, (int) strlen(name) + 1);
}

void
cdiGridTypeInit(grid_t *gridptr, int gridtype, size_t size)
{
  gridptr->type = gridtype;
  gridptr->size = size;

  // clang-format off
  if      (gridtype == GRID_LONLAT)           gridptr->nvertex = 2;
  else if (gridtype == GRID_GAUSSIAN)         gridptr->nvertex = 2;
  else if (gridtype == GRID_GAUSSIAN_REDUCED) gridptr->nvertex = 2;
  else if (gridtype == GRID_CURVILINEAR)      gridptr->nvertex = 4;
  else if (gridtype == GRID_UNSTRUCTURED)     gridptr->x.size = size;
  // clang-format on

  switch (gridtype)
  {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_GAUSSIAN_REDUCED:
    case GRID_TRAJECTORY:
    case GRID_CURVILINEAR:
    case GRID_UNSTRUCTURED:
    case GRID_GME:
    {
      if (gridtype == GRID_TRAJECTORY)
      {
        gridaxisSetKey(&gridptr->x, CDI_KEY_NAME, "tlon");
        gridaxisSetKey(&gridptr->y, CDI_KEY_NAME, "tlat");
      }
      else
      {
        gridaxisSetKey(&gridptr->x, CDI_KEY_NAME, "lon");
        gridaxisSetKey(&gridptr->y, CDI_KEY_NAME, "lat");
      }

      gridaxisSetKey(&gridptr->x, CDI_KEY_LONGNAME, "longitude");
      gridaxisSetKey(&gridptr->y, CDI_KEY_LONGNAME, "latitude");

      gridaxisSetKey(&gridptr->x, CDI_KEY_UNITS, "degrees_east");
      gridaxisSetKey(&gridptr->y, CDI_KEY_UNITS, "degrees_north");

      gridaxisSetKey(&gridptr->x, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_latlon][0]);
      gridaxisSetKey(&gridptr->y, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_latlon][1]);

      break;
    }
#ifndef USE_MPI
    case GRID_CHARXY:
    {
      if (gridptr->x.cvals) gridaxisSetKey(&gridptr->x, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_char][0]);
      if (gridptr->y.cvals) gridaxisSetKey(&gridptr->y, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_char][1]);

      break;
    }
#endif
    case GRID_GENERIC:
    case GRID_PROJECTION:
    {
      gridaxisSetKey(&gridptr->x, CDI_KEY_NAME, "x");
      gridaxisSetKey(&gridptr->y, CDI_KEY_NAME, "y");
      if (gridtype == GRID_PROJECTION)
      {
        gridaxisSetKey(&gridptr->x, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_projection][0]);
        gridaxisSetKey(&gridptr->y, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_projection][1]);
        gridaxisSetKey(&gridptr->x, CDI_KEY_UNITS, "m");
        gridaxisSetKey(&gridptr->y, CDI_KEY_UNITS, "m");
      }
      break;
    }
  }
}

// used also in CDO
void
gridGenXvals(size_t xsize, double xfirst, double xlast, double xinc, double *restrict xvals)
{
  if (fabs(xinc) <= 0 && xsize > 1)
  {
    if (xfirst >= xlast)
    {
      while (xfirst >= xlast) xlast += 360;
      xinc = (xlast - xfirst) / (double) xsize;
    }
    else { xinc = (xlast - xfirst) / (double) (xsize - 1); }
  }

  for (size_t i = 0; i < xsize; ++i) xvals[i] = xfirst + (double) i * xinc;
}

static void
calc_gaussgrid(double *restrict yvals, size_t ysize, double yfirst, double ylast)
{
  double *restrict yw = (double *) Malloc(ysize * sizeof(double));
  gaussianLatitudes(ysize, yvals, yw);
  Free(yw);
  for (size_t i = 0; i < ysize; i++) yvals[i] = asin(yvals[i]) / M_PI * 180.0;

  if (yfirst < ylast && yfirst > -90.0 && ylast < 90.0)
  {
    size_t yhsize = ysize / 2;
    for (size_t i = 0; i < yhsize; i++)
    {
      const double ytmp = yvals[i];
      yvals[i] = yvals[ysize - i - 1];
      yvals[ysize - i - 1] = ytmp;
    }
  }
}

static void
gridGenYvalsGaussian(size_t ysize, double yfirst, double ylast, double *restrict yvals)
{
  const double deleps = 0.002;

  calc_gaussgrid(yvals, ysize, yfirst, ylast);

  if (!(IS_EQUAL(yfirst, 0) && IS_EQUAL(ylast, 0)))
    if (fabs(yvals[0] - yfirst) > deleps || fabs(yvals[ysize - 1] - ylast) > deleps)
    {
      bool lfound = false;
      long ny = (long) (180. / (fabs(ylast - yfirst) / (double) (ysize - 1)) + 0.5);
      ny -= ny % 2;
      if (ny > 0 && (size_t) ny > ysize && ny < 4096)
      {
        double *ytmp = (double *) Malloc((size_t) ny * sizeof(double));
        calc_gaussgrid(ytmp, (size_t) ny, yfirst, ylast);

        size_t nstart = (size_t) ny - ysize;
        for (size_t i = 0; i < ((size_t) ny - ysize); i++)
          if (fabs(ytmp[i] - yfirst) < deleps)
          {
            nstart = i;
            break;
          }

        lfound = (nstart + ysize - 1) < (size_t) ny && fabs(ytmp[nstart + ysize - 1] - ylast) < deleps;
        if (lfound)
        {
          for (size_t i = 0; i < ysize; i++) yvals[i] = ytmp[i + nstart];
        }

        if (ytmp) Free(ytmp);
      }

      if (!lfound)
      {
        Warning("Cannot calculate gaussian latitudes for lat1 = %g latn = %g!", yfirst, ylast);
        for (size_t i = 0; i < ysize; i++) yvals[i] = 0;
        yvals[0] = yfirst;
        yvals[ysize - 1] = ylast;
      }
    }
}

static void
gridGenYvalsRegular(size_t ysize, double yfirst, double ylast, double yinc, double *restrict yvals)
{
  if (fabs(yinc) <= 0 && ysize > 1)
  {
    if (IS_EQUAL(yfirst, ylast) && IS_NOT_EQUAL(yfirst, 0)) ylast *= -1;

    if (yfirst > ylast)
      yinc = (yfirst - ylast) / (double) (ysize - 1);
    else if (yfirst < ylast)
      yinc = (ylast - yfirst) / (double) (ysize - 1);
    else
    {
      if (ysize % 2 != 0)
      {
        yinc = 180.0 / (double) (ysize - 1);
        yfirst = -90;
      }
      else
      {
        yinc = 180.0 / (double) ysize;
        yfirst = -90 + yinc / 2;
      }
    }
  }

  if (yfirst > ylast && yinc > 0) yinc = -yinc;

  for (size_t i = 0; i < ysize; i++) yvals[i] = yfirst + (double) i * yinc;
}

// used also in CDO
void
gridGenYvals(int gridtype, size_t ysize, double yfirst, double ylast, double yinc, double *restrict yvals)
{
  if (gridtype == GRID_GAUSSIAN || gridtype == GRID_GAUSSIAN_REDUCED)
  {
    if (ysize > 2) { gridGenYvalsGaussian(ysize, yfirst, ylast, yvals); }
    else
    {
      yvals[0] = yfirst;
      yvals[ysize - 1] = ylast;
    }
  }
  // else if (gridtype == GRID_LONLAT || gridtype == GRID_GENERIC)
  else { gridGenYvalsRegular(ysize, yfirst, ylast, yinc, yvals); }
  /*
    else
    Error("unable to calculate values for %s grid!", gridNamePtr(gridtype));
  */
}

/*
@Function  gridCreate
@Title     Create a horizontal Grid

@Prototype int gridCreate(int gridtype, SizeType size)
@Parameter
    @Item  gridtype  The type of the grid, one of the set of predefined CDI grid types.
                     The valid CDI grid types are @func{GRID_GENERIC}, @func{GRID_LONLAT},
                     @func{GRID_GAUSSIAN}, @func{GRID_PROJECTION}, @func{GRID_SPECTRAL},
                     @func{GRID_GME}, @func{GRID_CURVILINEAR} and @func{GRID_UNSTRUCTURED}.
    @Item  size      Number of gridpoints.

@Description
The function @func{gridCreate} creates a horizontal Grid.

@Result
@func{gridCreate} returns an identifier to the Grid.

@Example
Here is an example using @func{gridCreate} to create a regular lon/lat Grid:

@Source
   ...
#define  nlon  12
#define  nlat   6
   ...
double lons[nlon] = {0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330};
double lats[nlat] = {-75, -45, -15, 15, 45, 75};
int gridID;
   ...
gridID = gridCreate(GRID_LONLAT, nlon*nlat);
gridDefXsize(gridID, nlon);
gridDefYsize(gridID, nlat);
gridDefXvals(gridID, lons);
gridDefYvals(gridID, lats);
   ...
@EndSource
@EndFunction
*/
int
gridCreate(int gridtype, SizeType size)
{
  if (CDI_Debug) Message("gridtype=%s  size=%zu", gridNamePtr(gridtype), (size_t) size);

  xassert(size);
  gridInit();

  grid_t *gridptr = gridNewEntry(CDI_UNDEFID);
  if (!gridptr) Error("No memory");

  int gridID = gridptr->self;
  if (CDI_Debug) Message("gridID: %d", gridID);

  cdiGridTypeInit(gridptr, gridtype, (size_t) size);

  return gridID;
}

static void
gridDestroyKernel(grid_t *gridptr)
{
  xassert(gridptr);

  grid_free_components(gridptr);
  Free(gridptr);
}

/*
@Function  gridDestroy
@Title     Destroy a horizontal Grid

@Prototype void gridDestroy(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.

@EndFunction
*/
void
gridDestroy(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->destroy(gridptr);
  reshRemove(gridID, &gridOps);
}

static void
gridDestroyP(void *gridptr)
{
  ((grid_t *) gridptr)->vtable->destroy((grid_t *) gridptr);
}

const char *
gridNamePtr(int gridtype)
{
  int size = (int) (sizeof(Grids) / sizeof(Grids[0]));
  return (gridtype >= 0 && gridtype < size) ? Grids[gridtype] : Grids[GRID_GENERIC];
}

void
gridName(int gridtype, char *gridname)
{
  strcpy(gridname, gridNamePtr(gridtype));
}

/*
@Function  gridDefXname
@Title     Define the name of a X-axis

@Prototype void gridDefXname(int gridID, const char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  name     Name of the X-axis.

@Description
The function @func{gridDefXname} defines the name of a X-axis.

@EndFunction
*/
void
gridDefXname(int gridID, const char *name)
{
  (void) cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_NAME, name);
}

/*
@Function  gridDefXlongname
@Title     Define the longname of a X-axis

@Prototype void gridDefXlongname(int gridID, const char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  longname Longname of the X-axis.

@Description
The function @func{gridDefXlongname} defines the longname of a X-axis.

@EndFunction
*/
void
gridDefXlongname(int gridID, const char *longname)
{
  (void) cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_LONGNAME, longname);
}

/*
@Function  gridDefXunits
@Title     Define the units of a X-axis

@Prototype void gridDefXunits(int gridID, const char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  units    Units of the X-axis.

@Description
The function @func{gridDefXunits} defines the units of a X-axis.

@EndFunction
*/
void
gridDefXunits(int gridID, const char *units)
{
  (void) cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_UNITS, units);
}

/*
@Function  gridDefYname
@Title     Define the name of a Y-axis

@Prototype void gridDefYname(int gridID, const char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  name     Name of the Y-axis.

@Description
The function @func{gridDefYname} defines the name of a Y-axis.

@EndFunction
*/
void
gridDefYname(int gridID, const char *name)
{
  (void) cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_NAME, name);
}

/*
@Function  gridDefYlongname
@Title     Define the longname of a Y-axis

@Prototype void gridDefYlongname(int gridID, const char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  longname Longname of the Y-axis.

@Description
The function @func{gridDefYlongname} defines the longname of a Y-axis.

@EndFunction
*/
void
gridDefYlongname(int gridID, const char *longname)
{
  (void) cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_LONGNAME, longname);
}

/*
@Function  gridDefYunits
@Title     Define the units of a Y-axis

@Prototype void gridDefYunits(int gridID, const char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  units    Units of the Y-axis.

@Description
The function @func{gridDefYunits} defines the units of a Y-axis.

@EndFunction
*/
void
gridDefYunits(int gridID, const char *units)
{
  (void) cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_UNITS, units);
}

/*
@Function  gridInqXname
@Title     Get the name of a X-axis

@Prototype void gridInqXname(int gridID, char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  name     Name of the X-axis. The caller must allocate space for the
                    returned string. The maximum possible length, in characters, of
                    the string is given by the predefined constant @func{CDI_MAX_NAME}.

@Description
The function @func{gridInqXname} returns the name of a X-axis.

@Result
@func{gridInqXname} returns the name of the X-axis to the parameter name.

@EndFunction
*/
void
gridInqXname(int gridID, char *name)
{
  int length = CDI_MAX_NAME;
  (void) cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_NAME, name, &length);
}

/*
@Function  gridInqXlongname
@Title     Get the longname of a X-axis

@Prototype void gridInqXlongname(int gridID, char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  longname Longname of the X-axis. The caller must allocate space for the
                    returned string. The maximum possible length, in characters, of
                    the string is given by the predefined constant @func{CDI_MAX_NAME}.

@Description
The function @func{gridInqXlongname} returns the longname of a X-axis.

@Result
@func{gridInqXlongname} returns the longname of the X-axis to the parameter longname.

@EndFunction
*/
void
gridInqXlongname(int gridID, char *longname)
{
  int length = CDI_MAX_NAME;
  (void) cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_LONGNAME, longname, &length);
}

/*
@Function  gridInqXunits
@Title     Get the units of a X-axis

@Prototype void gridInqXunits(int gridID, char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  units    Units of the X-axis. The caller must allocate space for the
                    returned string. The maximum possible length, in characters, of
                    the string is given by the predefined constant @func{CDI_MAX_NAME}.

@Description
The function @func{gridInqXunits} returns the units of a X-axis.

@Result
@func{gridInqXunits} returns the units of the X-axis to the parameter units.

@EndFunction
*/
void
gridInqXunits(int gridID, char *units)
{
  int length = CDI_MAX_NAME;
  (void) cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_UNITS, units, &length);
}

/*
@Function  gridInqYname
@Title     Get the name of a Y-axis

@Prototype void gridInqYname(int gridID, char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  name     Name of the Y-axis. The caller must allocate space for the
                    returned string. The maximum possible length, in characters, of
                    the string is given by the predefined constant @func{CDI_MAX_NAME}.

@Description
The function @func{gridInqYname} returns the name of a Y-axis.

@Result
@func{gridInqYname} returns the name of the Y-axis to the parameter name.

@EndFunction
*/
void
gridInqYname(int gridID, char *name)
{
  int length = CDI_MAX_NAME;
  (void) cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_NAME, name, &length);
}

/*
@Function  gridInqYlongname
@Title     Get the longname of a Y-axis

@Prototype void gridInqYlongname(int gridID, char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  longname Longname of the Y-axis. The caller must allocate space for the
                    returned string. The maximum possible length, in characters, of
                    the string is given by the predefined constant @func{CDI_MAX_NAME}.

@Description
The function @func{gridInqYlongname} returns the longname of a Y-axis.

@Result
@func{gridInqYlongname} returns the longname of the Y-axis to the parameter longname.

@EndFunction
*/
void
gridInqYlongname(int gridID, char *longname)
{
  int length = CDI_MAX_NAME;
  (void) cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_LONGNAME, longname, &length);
}

/*
@Function  gridInqYunits
@Title     Get the units of a Y-axis

@Prototype void gridInqYunits(int gridID, char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  units    Units of the Y-axis. The caller must allocate space for the
                    returned string. The maximum possible length, in characters, of
                    the string is given by the predefined constant @func{CDI_MAX_NAME}.

@Description
The function @func{gridInqYunits} returns the units of a Y-axis.

@Result
@func{gridInqYunits} returns the units of the Y-axis to the parameter units.

@EndFunction
*/
void
gridInqYunits(int gridID, char *units)
{
  int length = CDI_MAX_NAME;
  (void) cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_UNITS, units, &length);
}

static void
gridDefIndicesSerial(grid_t *gridptr, const int64_t *indices)
{
  size_t size = gridptr->size;
  if (size == 0) Error("Size undefined for gridID = %d", gridptr->self);

  if (gridptr->indices && CDI_Debug) Warning("values already defined!");
  gridptr->indices = (int64_t *) Realloc(gridptr->indices, size * sizeof(int64_t));
  memcpy(gridptr->indices, indices, size * sizeof(int64_t));
}

void
gridDefIndices(int gridID, const int64_t *indices)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defIndices(gridptr, indices);
  gridMark4Update(gridID);
}

static const int64_t *
gridInqIndicesPtrSerial(grid_t *gridptr)
{
  return gridptr->indices;
}

static SizeType
gridInqIndicesSerial(grid_t *gridptr, int64_t *indices)
{
  size_t size = gridptr->size;
  if (CDI_Debug && size == 0) Warning("size undefined for gridID = %d", gridptr->self);

  if (gridptr->indices)
  {
    if (size && indices) memcpy(indices, gridptr->vtable->inqIndicesPtr(gridptr), size * sizeof(int64_t));
  }
  else
    size = 0;

  return (SizeType) size;
}

SizeType
gridInqIndices(int gridID, int64_t *indices)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqIndices(gridptr, indices);
}

void
gridDefProj(int gridID, int projID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->proj = projID;

  if (gridptr->type == GRID_CURVILINEAR)
  {
    grid_t *projptr = grid_to_pointer(projID);
    const char *xdimname = cdiInqVarKeyStringPtr(&gridptr->x.keys, CDI_KEY_DIMNAME);
    const char *ydimname = cdiInqVarKeyStringPtr(&gridptr->y.keys, CDI_KEY_DIMNAME);
    if (xdimname && find_key(&projptr->x.keys, CDI_KEY_NAME)) cdiDefKeyString(projID, CDI_XAXIS, CDI_KEY_NAME, xdimname);
    if (ydimname && find_key(&projptr->y.keys, CDI_KEY_NAME)) cdiDefKeyString(projID, CDI_YAXIS, CDI_KEY_NAME, ydimname);
  }
}

int
gridInqProj(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->proj;
}

int
gridInqProjType(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  int projtype = gridptr->projtype;
  if (projtype == -1)
  {
    char gmapname[CDI_MAX_NAME];
    int length = CDI_MAX_NAME;
    cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname, &length);
    if (gmapname[0])
    {
      // clang-format off
          if      (str_is_equal(gmapname, "rotated_latitude_longitude"))   projtype = CDI_PROJ_RLL;
          else if (str_is_equal(gmapname, "lambert_azimuthal_equal_area")) projtype = CDI_PROJ_LAEA;
          else if (str_is_equal(gmapname, "lambert_conformal_conic"))      projtype = CDI_PROJ_LCC;
          else if (str_is_equal(gmapname, "sinusoidal"))                   projtype = CDI_PROJ_SINU;
          else if (str_is_equal(gmapname, "polar_stereographic"))          projtype = CDI_PROJ_STERE;
          else if (str_is_equal(gmapname, "healpix"))                      projtype = CDI_PROJ_HEALPIX;
      // clang-format on
      gridptr->projtype = projtype;
    }
  }

  return projtype;
}

void
gridVerifyProj(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  int projtype = gridInqProjType(gridID);
  if (projtype == CDI_PROJ_RLL)
  {
    gridaxisSetKey(&gridptr->x, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_grid_latlon][0]);
    gridaxisSetKey(&gridptr->y, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_grid_latlon][1]);
    gridaxisSetKey(&gridptr->x, CDI_KEY_UNITS, "degrees");
    gridaxisSetKey(&gridptr->y, CDI_KEY_UNITS, "degrees");
  }
  else if (projtype == CDI_PROJ_LCC)
  {
    gridaxisSetKey(&gridptr->x, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_projection][0]);
    gridaxisSetKey(&gridptr->y, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_projection][1]);
    gridaxisSetKey(&gridptr->x, CDI_KEY_UNITS, "m");
    gridaxisSetKey(&gridptr->y, CDI_KEY_UNITS, "m");
  }
}

/*
@Function  gridInqType
@Title     Get the type of a Grid

@Prototype int gridInqType(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqType} returns the type of a Grid.

@Result
@func{gridInqType} returns the type of the grid,
one of the set of predefined CDI grid types.
The valid CDI grid types are @func{GRID_GENERIC}, @func{GRID_LONLAT},
@func{GRID_GAUSSIAN}, @func{GRID_PROJECTION}, @func{GRID_SPECTRAL}, @func{GRID_GME},
@func{GRID_CURVILINEAR} and @func{GRID_UNSTRUCTURED}.

@EndFunction
*/
int
gridInqType(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->type;
}

/*
@Function  gridInqSize
@Title     Get the size of a Grid

@Prototype SizeType gridInqSize(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqSize} returns the size of a Grid.

@Result
@func{gridInqSize} returns the number of grid points of a Grid.

@EndFunction
*/
SizeType
gridInqSize(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  size_t size = gridptr->size;
  if (size == 0)
  {
    size_t xsize = gridptr->x.size;
    size_t ysize = gridptr->y.size;
    size = ysize ? xsize * ysize : xsize;
    gridptr->size = size;
  }

  return (SizeType) size;
}

static int
nsp2trunc(size_t nsp)
{
  /*  nsp = (trunc+1)*(trunc+1)              */
  /*      => trunc^2 + 3*trunc - (x-2) = 0   */
  /*                                         */
  /*  with:  y^2 + p*y + q = 0               */
  /*         y = -p/2 +- sqrt((p/2)^2 - q)   */
  /*         p = 3 and q = - (x-2)           */
  int trunc = (int) (sqrt((double) nsp * 4 + 1.) - 3) / 2;
  return trunc;
}

int
gridInqTrunc(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->trunc == 0)
  {
    if (gridptr->type == GRID_SPECTRAL) gridptr->trunc = nsp2trunc(gridptr->size);
    /*
    else if      ( gridptr->type == GRID_GAUSSIAN )
      gridptr->trunc = nlat2trunc(gridptr->y.size);
    */
  }

  return gridptr->trunc;
}

void
gridDefTrunc(int gridID, int trunc)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->trunc != trunc)
  {
    gridMark4Update(gridID);
    gridptr->trunc = trunc;
  }
}

/*
@Function  gridDefXsize
@Title     Define the number of values of a X-axis

@Prototype void gridDefXsize(int gridID, SizeType xsize)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  xsize    Number of values of a X-axis.

@Description
The function @func{gridDefXsize} defines the number of values of a X-axis.

@EndFunction
*/
void
gridDefXsize(int gridID, SizeType xsize)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  SizeType gridSize = gridInqSize(gridID);
  if (xsize > gridSize) Error("xsize %lld is greater then gridsize %lld", (long long) xsize, (long long) gridSize);

  int gridType = gridInqType(gridID);
  if (gridType == GRID_UNSTRUCTURED && xsize != gridSize)
    Error("xsize %lld must be equal to gridsize %lld for gridtype: %s", (long long) xsize, (long long) gridSize,
          gridNamePtr(gridType));
  if (gridType == GRID_GAUSSIAN_REDUCED && xsize != 2 && xsize != gridSize)
    Error("xsize %lld must be equal to gridsize %lld for gridtype: %s", (long long) xsize, (long long) gridSize,
          gridNamePtr(gridType));

  if (gridptr->x.size != (size_t) xsize)
  {
    gridMark4Update(gridID);
    gridptr->x.size = (size_t) xsize;
  }

  if (gridType != GRID_UNSTRUCTURED && gridType != GRID_GAUSSIAN_REDUCED && gridType != GRID_PROJECTION)
  {
    size_t axisproduct = gridptr->x.size * gridptr->y.size;
    if (axisproduct > 0 && axisproduct != (size_t) gridSize)
      Error("Inconsistent grid declaration! (xsize=%zu ysize=%zu gridsize=%zu)", gridptr->x.size, gridptr->y.size,
            (size_t) gridSize);
  }
}

void
gridDefDatatype(int gridID, int datatype)
{
  cdiDefKeyInt(gridID, CDI_GLOBAL, CDI_KEY_DATATYPE, datatype);
}

int
gridInqDatatype(int gridID)
{
  int datatype = CDI_UNDEFID;
  cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_DATATYPE, &datatype);
  return datatype;
}

/*
@Function  gridInqXsize
@Title     Get the number of values of a X-axis

@Prototype SizeType gridInqXsize(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqXsize} returns the number of values of a X-axis.

@Result
@func{gridInqXsize} returns the number of values of a X-axis.

@EndFunction
*/
SizeType
gridInqXsize(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return (SizeType) gridptr->x.size;
}

/*
@Function  gridDefYsize
@Title     Define the number of values of a Y-axis

@Prototype void gridDefYsize(int gridID, SizeType ysize)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  ysize    Number of values of a Y-axis.

@Description
The function @func{gridDefYsize} defines the number of values of a Y-axis.

@EndFunction
*/
void
gridDefYsize(int gridID, SizeType ysize)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  SizeType gridSize = gridInqSize(gridID);

  if (ysize > gridSize) Error("ysize %lld is greater then gridsize %lld", (long long) ysize, (long long) gridSize);

  int gridType = gridInqType(gridID);
  if (gridType == GRID_UNSTRUCTURED && ysize != gridSize)
    Error("ysize %lld must be equal gridsize %lld for gridtype: %s", (long long) ysize, (long long) gridSize,
          gridNamePtr(gridType));

  if (gridptr->y.size != (size_t) ysize)
  {
    gridMark4Update(gridID);
    gridptr->y.size = (size_t) ysize;
  }

  if (gridType != GRID_UNSTRUCTURED && gridType != GRID_GAUSSIAN_REDUCED && gridType != GRID_PROJECTION)
  {
    size_t axisproduct = gridptr->x.size * gridptr->y.size;
    if (axisproduct > 0 && axisproduct != (size_t) gridSize)
      Error("Inconsistent grid declaration! (xsize=%zu ysize=%zu gridsize=%zu)", gridptr->x.size, gridptr->y.size,
            (size_t) gridSize);
  }
}

/*
@Function  gridInqYsize
@Title     Get the number of values of a Y-axis

@Prototype SizeType gridInqYsize(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqYsize} returns the number of values of a Y-axis.

@Result
@func{gridInqYsize} returns the number of values of a Y-axis.

@EndFunction
*/
SizeType
gridInqYsize(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return (SizeType) gridptr->y.size;
}

/*
@Function  gridDefNP
@Title     Define the number of parallels between a pole and the equator

@Prototype void gridDefNP(int gridID, int np)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  np       Number of parallels between a pole and the equator.

@Description
The function @func{gridDefNP} defines the number of parallels between a pole and the equator
of a Gaussian grid.

@EndFunction
*/
void
gridDefNP(int gridID, int np)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->np != np)
  {
    gridMark4Update(gridID);
    gridptr->np = np;
  }
}

/*
@Function  gridInqNP
@Title     Get the number of parallels between a pole and the equator

@Prototype int gridInqNP(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqNP} returns the number of parallels between a pole and the equator
of a Gaussian grid.

@Result
@func{gridInqNP} returns the number of parallels between a pole and the equator.

@EndFunction
*/
int
gridInqNP(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->np;
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridDefReducedPoints(int gridID, int reducedPointsSize, const int reducedPoints[])
{
  grid_t *gridptr = grid_to_pointer(gridID);

  gridptr->reducedPoints = (int *) Malloc((size_t) reducedPointsSize * sizeof(int));
  gridptr->reducedPointsSize = reducedPointsSize;
  memcpy(gridptr->reducedPoints, reducedPoints, (size_t) reducedPointsSize * sizeof(int));
  gridMark4Update(gridID);
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridInqReducedPoints(int gridID, int *reducedPoints)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->reducedPoints == 0) Error("undefined pointer!");

  memcpy(reducedPoints, gridptr->reducedPoints, (size_t) gridptr->reducedPointsSize * sizeof(int));
}

static SizeType
gridInqMaskSerialGeneric(grid_t *gridptr, mask_t **internalMask, int *restrict mask)
{
  size_t size = gridptr->size;

  if (CDI_Debug && size == 0) Warning("Size undefined for gridID = %d", gridptr->self);

  const mask_t *restrict mask_src = *internalMask;
  if (mask_src)
  {
    if (mask && size > 0)
      for (size_t i = 0; i < size; ++i) mask[i] = (int) mask_src[i];
  }
  else
    size = 0;

  return (SizeType) size;
}

static SizeType
gridInqMaskSerial(grid_t *gridptr, int *mask)
{
  return gridInqMaskSerialGeneric(gridptr, &gridptr->mask, mask);
}

int
gridInqMask(int gridID, int *mask)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqMask(gridptr, mask);
}

static void
gridDefMaskSerial(grid_t *gridptr, const int *mask)
{
  size_t size = gridptr->size;
  if (size == 0) Error("Size undefined for gridID = %d", gridptr->self);

  if (mask == NULL)
  {
    if (gridptr->mask)
    {
      Free(gridptr->mask);
      gridptr->mask = NULL;
    }
  }
  else
  {
    if (gridptr->mask == NULL)
      gridptr->mask = (mask_t *) Malloc(size * sizeof(mask_t));
    else if (CDI_Debug)
      Warning("grid mask already defined!");

    for (size_t i = 0; i < size; ++i) gridptr->mask[i] = (mask_t) (mask[i] != 0);
  }
}

void
gridDefMask(int gridID, const int *mask)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defMask(gridptr, mask);
  gridMark4Update(gridID);
}

static int
gridInqMaskGMESerial(grid_t *gridptr, int *mask_gme)
{
  return (int) gridInqMaskSerialGeneric(gridptr, &gridptr->mask_gme, mask_gme);
}

int
gridInqMaskGME(int gridID, int *mask)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqMaskGME(gridptr, mask);
}

static void
gridDefMaskGMESerial(grid_t *gridptr, const int *mask)
{
  size_t size = gridptr->size;
  if (size == 0) Error("Size undefined for gridID = %d", gridptr->self);

  if (gridptr->mask_gme == NULL)
    gridptr->mask_gme = (mask_t *) Malloc(size * sizeof(mask_t));
  else if (CDI_Debug)
    Warning("mask already defined!");

  for (size_t i = 0; i < size; ++i) gridptr->mask_gme[i] = (mask_t) (mask[i] != 0);
}

void
gridDefMaskGME(int gridID, const int *mask)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defMaskGME(gridptr, mask);
  gridMark4Update(gridID);
}

static void
copy_darray(size_t n, const double *restrict in, double *restrict out)
{
#ifdef _OPENMP
#pragma omp parallel for if (n > 99999) default(shared) schedule(static)
#endif
  for (size_t i = 0; i < n; ++i) out[i] = in[i];
}

static SizeType
gridInqXValsSerial(grid_t *gridptr, double *xvals)
{
  size_t size = grid_is_irregular(gridptr->type) ? gridptr->size : gridptr->x.size;
  if (CDI_Debug && size == 0) Warning("size undefined for gridID = %d", gridptr->self);

  if (gridptr->x.vals)
  {
    if (size && xvals) copy_darray(size, gridptr->vtable->inqXValsPtr(gridptr), xvals);
  }
  else
    size = 0;

  return (SizeType) size;
}

static SizeType
gridInqXValsPartSerial(grid_t *gridptr, int start, SizeType length, double *xvals)
{
  size_t size = grid_is_irregular(gridptr->type) ? gridptr->size : gridptr->x.size;
  if (CDI_Debug && size == 0) Warning("size undefined for gridID = %d", gridptr->self);

  if (gridptr->x.vals)
  {
    if (size && xvals && (size_t) length <= size)
    {
      const double *gridptr_xvals = gridptr->vtable->inqXValsPtr(gridptr);
      memcpy(xvals, gridptr_xvals + start, (size_t) length * sizeof(double));
    }
  }
  else
    size = 0;

  return (SizeType) size;
}

#ifndef USE_MPI
static SizeType
gridInqXCvalsSerial(grid_t *gridptr, char **xcvals)
{
  if (gridptr->type != GRID_CHARXY) Error("Function only valid for grid type 'GRID_CHARXY'.");

  size_t size = gridptr->x.size;
  size_t maxclength = 0;

  const char **gridptr_xcvals = gridptr->vtable->inqXCvalsPtr(gridptr);
  if (gridptr_xcvals && size && xcvals)
  {
    maxclength = (size_t) gridptr->x.clength;
    for (size_t i = 0; i < size; i++) memcpy(xcvals[i], gridptr_xcvals[i], maxclength * sizeof(char));
  }

  return (SizeType) maxclength;
}

static int
gridInqXIscSerial(grid_t *gridptr)
{
  /*
  if ( gridptr->type != GRID_CHARXY )
    Error("Axis type is 'char' but grid is not type 'GRID_CHARXY'.");
  */
  return gridptr->x.clength;
}
#endif

/*
@Function  gridInqXvals
@Title     Get all values of a X-axis

@Prototype SizeType gridInqXvals(int gridID, double *xvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  xvals    Pointer to the location into which the X-values are read.
                    The caller must allocate space for the returned values.

@Description
The function @func{gridInqXvals} returns all values of the X-axis.

@Result
Upon successful completion @func{gridInqXvals} returns the number of values and
the values are stored in @func{xvals}.
Otherwise, 0 is returned and @func{xvals} is empty.

@EndFunction
*/
SizeType
gridInqXvals(int gridID, double *xvals)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXVals(gridptr, xvals);
}

SizeType
gridInqXvalsPart(int gridID, int start, SizeType length, double *xvals)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXValsPart(gridptr, start, length, xvals);
}

SizeType
gridInqXCvals(int gridID, char **xcvals)
{
#ifndef USE_MPI
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXCvals(gridptr, xcvals);
#else
  (void) gridID;
  (void) xcvals;
  return 0;
#endif
}

int
gridInqXIsc(int gridID)
{
#ifndef USE_MPI
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXIsc(gridptr);
#else
  (void) gridID;
  return 0;
#endif
}

static void
gridDefXValsSerial(grid_t *gridptr, const double *xvals)
{
  size_t size = grid_is_irregular(gridptr->type) ? gridptr->size : gridptr->x.size;
  if (size == 0) Error("Size undefined for gridID = %d", gridptr->self);

  if (gridptr->x.vals && CDI_Debug) Warning("values already defined!");
  gridptr->x.vals = (double *) Realloc(gridptr->x.vals, size * sizeof(double));
  copy_darray(size, xvals, gridptr->x.vals);
}

#ifndef USE_MPI
static SizeType
gridInqYCvalsSerial(grid_t *gridptr, char **ycvals)
{
  if (gridptr->type != GRID_CHARXY) Error("Function only valid for grid type 'GRID_CHARXY'.");

  size_t size = gridptr->y.size;
  size_t maxclength = 0;

  const char **gridptr_ycvals = gridptr->vtable->inqYCvalsPtr(gridptr);
  if (gridptr_ycvals && size && ycvals)
  {
    maxclength = (size_t) gridptr->y.clength;
    for (size_t i = 0; i < size; i++) memcpy(ycvals[i], gridptr_ycvals[i], maxclength);
  }

  return (SizeType) maxclength;
}

static int
gridInqYIscSerial(grid_t *gridptr)
{
  // if ( gridptr->type != GRID_CHARXY ) Error("Axis type is 'char' but grid is not type 'GRID_CHARXY'.");
  return gridptr->y.clength;
}
#endif

/*
@Function  gridDefXvals
@Title     Define the values of a X-axis

@Prototype void gridDefXvals(int gridID, const double *xvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  xvals    X-values of the grid.

@Description
The function @func{gridDefXvals} defines all values of the X-axis.

@EndFunction
*/
void
gridDefXvals(int gridID, const double *xvals)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defXVals(gridptr, xvals);
  gridMark4Update(gridID);
}

static SizeType
gridInqYValsSerial(grid_t *gridptr, double *yvals)
{
  size_t size = grid_is_irregular(gridptr->type) ? gridptr->size : gridptr->y.size;
  if (CDI_Debug && size == 0) Warning("size undefined for gridID = %d!", gridptr->self);

  if (gridptr->y.vals)
  {
    if (size && yvals) copy_darray(size, gridptr->vtable->inqYValsPtr(gridptr), yvals);
  }
  else
    size = 0;

  return (SizeType) size;
}

static SizeType
gridInqYValsPartSerial(grid_t *gridptr, int start, SizeType length, double *yvals)
{
  size_t size = grid_is_irregular(gridptr->type) ? gridptr->size : gridptr->y.size;
  if (CDI_Debug && size == 0) Warning("size undefined for gridID = %d!", gridptr->self);

  if (gridptr->y.vals)
  {
    if (size && yvals && (size_t) length <= size)
    {
      const double *gridptr_yvals = gridptr->vtable->inqYValsPtr(gridptr);
      memcpy(yvals, gridptr_yvals + start, (size_t) length * sizeof(double));
    }
  }
  else
    size = 0;

  return (SizeType) size;
}

/*
@Function  gridInqYvals
@Title     Get all values of a Y-axis

@Prototype SizeType gridInqYvals(int gridID, double *yvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  yvals    Pointer to the location into which the Y-values are read.
                    The caller must allocate space for the returned values.

@Description
The function @func{gridInqYvals} returns all values of the Y-axis.

@Result
Upon successful completion @func{gridInqYvals} returns the number of values and
the values are stored in @func{yvals}.
Otherwise, 0 is returned and @func{yvals} is empty.

@EndFunction
*/
SizeType
gridInqYvals(int gridID, double *yvals)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYVals(gridptr, yvals);
}

SizeType
gridInqYvalsPart(int gridID, int start, SizeType size, double *yvals)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYValsPart(gridptr, start, size, yvals);
}

SizeType
gridInqYCvals(int gridID, char **ycvals)
{
#ifndef USE_MPI
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYCvals(gridptr, ycvals);
#else
  (void) gridID;
  (void) ycvals;
  return 0;
#endif
}

int
gridInqYIsc(int gridID)
{
#ifndef USE_MPI
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYIsc(gridptr);
#else
  (void) gridID;
  return 0;
#endif
}

static void
gridDefYValsSerial(grid_t *gridptr, const double *yvals)
{
  int gridtype = gridptr->type;
  size_t size = grid_is_irregular(gridtype) ? gridptr->size : gridptr->y.size;

  if (size == 0) Error("Size undefined for gridID = %d!", gridptr->self);

  if (gridptr->y.vals && CDI_Debug) Warning("Values already defined!");

  gridptr->y.vals = (double *) Realloc(gridptr->y.vals, size * sizeof(double));
  copy_darray(size, yvals, gridptr->y.vals);
}

/*
@Function  gridDefYvals
@Title     Define the values of a Y-axis

@Prototype void gridDefYvals(int gridID, const double *yvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  yvals    Y-values of the grid.

@Description
The function @func{gridDefYvals} defines all values of the Y-axis.

@EndFunction
*/
void
gridDefYvals(int gridID, const double *yvals)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defYVals(gridptr, yvals);
  gridMark4Update(gridID);
}

static double
gridInqXValSerial(grid_t *gridptr, SizeType index)
{
  return gridptr->x.vals ? gridptr->x.vals[index] : 0;
}

double
gridInqXval(int gridID, SizeType index)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXVal(gridptr, index);
}

static double
gridInqYValSerial(grid_t *gridptr, SizeType index)
{
  return gridptr->y.vals ? gridptr->y.vals[index] : 0;
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double
gridInqYval(int gridID, SizeType index)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYVal(gridptr, index);
}

static double
grid_calc_increment(size_t size, const double *vals)
{
  if (size > 1)
  {
    double inc = (vals[size - 1] - vals[0]) / (double) (size - 1);
    double abs_inc = fabs(inc);
    for (size_t i = 1; i < size; ++i)
      if (fabs(fabs(vals[i - 1] - vals[i]) - abs_inc) > 0.01 * abs_inc)
      {
        inc = 0.0;
        break;
      }

    return inc;
  }

  return 0.0;
}

static double
grid_calc_increment_in_meter(size_t size, const double *vals)
{
  if (size > 1)
  {
    double inc = (vals[size - 1] - vals[0]) / (double) (size - 1);
    return round(fabs(inc));
  }

  return 0.0;
}

static double
gridInqXIncBase(grid_t *gridptr)
{
  if (fabs(gridptr->x.inc) <= 0 && gridptr->x.vals)
  {
    size_t xsize = gridptr->x.size;
    if (xsize > 1)
    {
      const double *xvals = gridptr->vtable->inqXValsPtr(gridptr);
      gridptr->x.inc = grid_calc_increment(xsize, xvals);
    }
  }

  return gridptr->x.inc;
}

double
gridInqXincInMeter(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  const double *xvals = gridptr->vtable->inqXValsPtr(gridptr);

  if (fabs(gridptr->x.inc) <= 0 && xvals)
  {
    size_t xsize = gridptr->x.size;
    if (xsize > 1) gridptr->x.inc = grid_calc_increment_in_meter(xsize, xvals);
  }

  return gridptr->x.inc;
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double
gridInqXinc(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXInc(gridptr);
}

static double
gridInqYIncBase(grid_t *gridptr)
{
  if (fabs(gridptr->y.inc) <= 0 && gridptr->y.vals)
  {
    size_t ysize = gridptr->y.size;
    if (ysize > 1)
    {
      const double *yvals = gridptr->vtable->inqYValsPtr(gridptr);
      gridptr->y.inc = grid_calc_increment(ysize, yvals);
    }
  }

  return gridptr->y.inc;
}

double
gridInqYincInMeter(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  const double *yvals = gridptr->vtable->inqYValsPtr(gridptr);

  if (fabs(gridptr->y.inc) <= 0 && yvals)
  {
    size_t ysize = gridptr->y.size;
    if (ysize > 1) gridptr->y.inc = grid_calc_increment_in_meter(ysize, yvals);
  }

  return gridptr->y.inc;
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double
gridInqYinc(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYInc(gridptr);
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridInqParamRLL(int gridID, double *xpole, double *ypole, double *angle)
{
  *xpole = 0;
  *ypole = 0;
  *angle = 0;

  static const char projection[] = "rotated_latitude_longitude";
  char name[CDI_MAX_NAME + 1];
  int length = CDI_MAX_NAME;
  cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, name, &length);
  if (name[0] && str_is_equal(name, projection))
  {
    int atttype, attlen;

    int natts, nfound = 0;
    cdiInqNatts(gridID, CDI_GLOBAL, &natts);

    for (int iatt = 0; iatt < natts; ++iatt)
    {
      cdiInqAtt(gridID, CDI_GLOBAL, iatt, name, &atttype, &attlen);
      if (attlen == 1)
      {
        double *attflt;
        // clang-format off
              if      (str_is_equal(name, "grid_north_pole_longitude")) attflt = xpole;
              else if (str_is_equal(name, "grid_north_pole_latitude") ) attflt = ypole;
              else if (str_is_equal(name, "north_pole_grid_longitude")) attflt = angle;
              else continue;
        // clang-format on
        bool valid = cdiInqAttConvertedToFloat(gridID, atttype, name, attlen, attflt);
        if ((nfound += valid) == 3) return;
      }
    }
  }
  else
    Warning("%s mapping parameter missing!", projection);
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridDefParamRLL(int gridID, double xpole, double ypole, double angle)
{
  cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_UNITS, "degrees");
  cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_UNITS, "degrees");

  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_VARNAME, "rotated_pole");

  const char *gmapname = "rotated_latitude_longitude";
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname);
  cdiDefAttTxt(gridID, CDI_GLOBAL, "grid_mapping_name", (int) (strlen(gmapname)), gmapname);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "grid_north_pole_longitude", CDI_DATATYPE_FLT64, 1, &xpole);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "grid_north_pole_latitude", CDI_DATATYPE_FLT64, 1, &ypole);
  if (IS_NOT_EQUAL(angle, 0)) cdiDefAttFlt(gridID, CDI_GLOBAL, "north_pole_grid_longitude", CDI_DATATYPE_FLT64, 1, &angle);

  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->projtype = CDI_PROJ_RLL;

  gridVerifyProj(gridID);
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridInqParamGME(int gridID, int *nd, int *ni, int *ni2, int *ni3)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  *nd = gridptr->gme.nd;
  *ni = gridptr->gme.ni;
  *ni2 = gridptr->gme.ni2;
  *ni3 = gridptr->gme.ni3;
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridDefParamGME(int gridID, int nd, int ni, int ni2, int ni3)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->gme.nd != nd)
  {
    gridptr->gme.nd = nd;
    gridptr->gme.ni = ni;
    gridptr->gme.ni2 = ni2;
    gridptr->gme.ni3 = ni3;
    gridMark4Update(gridID);
  }
}

/*
@Function
@Title

@Prototype
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void
gridChangeType(int gridID, int gridtype)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (CDI_Debug) Message("Changed grid type from %s to %s", gridNamePtr(gridptr->type), gridNamePtr(gridtype));

  if (gridptr->type != gridtype)
  {
    gridptr->type = gridtype;
    gridMark4Update(gridID);
  }
}

static void
grid_check_cyclic(grid_t *gridptr)
{
  gridptr->isCyclic = 0;
  enum
  {
    numVertices = 4
  };
  size_t xsize = gridptr->x.size, ysize = gridptr->y.size;
  const double *xvals = gridptr->vtable->inqXValsPtr(gridptr), *yvals = gridptr->vtable->inqYValsPtr(gridptr),
               (*xbounds)[numVertices] = (const double(*)[numVertices]) gridptr->vtable->inqXBoundsPtr(gridptr);

  if (gridptr->type == GRID_GAUSSIAN || gridptr->type == GRID_LONLAT)
  {
    if (xvals && xsize > 1)
    {
      double xval1 = xvals[0];
      double xval2 = xvals[1];
      double xvaln = xvals[xsize - 1];
      if (xval2 < xval1) xval2 += 360;
      if (xvaln < xval1) xvaln += 360;

      if (IS_NOT_EQUAL(xval1, xvaln))
      {
        double xinc = xval2 - xval1;
        if (IS_EQUAL(xinc, 0)) xinc = (xvaln - xval1) / (double) (xsize - 1);

        const double x0 = xvaln + xinc - 360;

        if (fabs(x0 - xval1) < 0.01 * xinc) gridptr->isCyclic = 1;
      }
    }
  }
  else if (gridptr->type == GRID_CURVILINEAR)
  {
    bool lcheck = true;
    if (yvals && xvals)
    {
      if ((fabs(yvals[0] - yvals[xsize - 1]) > fabs(yvals[0] - yvals[xsize * ysize - xsize]))
          && (fabs(yvals[xsize * ysize - xsize] - yvals[xsize * ysize - 1]) > fabs(yvals[xsize - 1] - yvals[xsize * ysize - 1])))
        lcheck = false;
    }
    else
      lcheck = false;

    if (lcheck && xvals && xsize > 1)
    {
      size_t nc = 0;
      for (size_t j = 0; j < ysize; ++j)
      {
        size_t i1 = j * xsize, i2 = j * xsize + 1, in = j * xsize + (xsize - 1);
        double val1 = xvals[i1], val2 = xvals[i2], valn = xvals[in];
        double xinc = fabs(val2 - val1);

        if (val1 < 1 && valn > 300) val1 += 360;
        if (valn < 1 && val1 > 300) valn += 360;
        if (val1 < -179 && valn > 120) val1 += 360;
        if (valn < -179 && val1 > 120) valn += 360;
        if (fabs(valn - val1) > 180) val1 += 360;

        double x0 = valn + copysign(xinc, val1 - valn);

        nc += fabs(x0 - val1) < 0.5 * xinc;
      }
      gridptr->isCyclic = nc > ysize / 2;
    }

    if (lcheck && xbounds && xsize > 1)
    {
      bool isCyclic = true;
      for (size_t j = 0; j < ysize; ++j)
      {
        size_t i1 = j * xsize, i2 = j * xsize + (xsize - 1);
        for (size_t k1 = 0; k1 < numVertices; ++k1)
        {
          double val1 = xbounds[i1][k1];
          for (size_t k2 = 0; k2 < numVertices; ++k2)
          {
            double val2 = xbounds[i2][k2];

            if (val1 < 1 && val2 > 300) val1 += 360;
            if (val2 < 1 && val1 > 300) val2 += 360;
            if (val1 < -179 && val2 > 120) val1 += 360;
            if (val2 < -179 && val1 > 120) val2 += 360;
            if (fabs(val2 - val1) > 180) val1 += 360;

            if (fabs(val1 - val2) < 0.001) goto foundCloseVertices;
          }
        }
        // all vertices more than 0.001 degrees apart
        isCyclic = false;
        break;
      foundCloseVertices:;
      }
      gridptr->isCyclic = isCyclic;
    }
  }
}

int
gridIsCircular(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->isCyclic == CDI_UNDEFID) grid_check_cyclic(gridptr);

  return gridptr->isCyclic;
}

static bool
compareXYvals(grid_t *gridRef, grid_t *gridTest)
{
  bool differ = false;
  int gridtype = gridTest->type;

  size_t xsizeTest = grid_is_irregular(gridtype) ? gridTest->size : gridTest->x.size;
  size_t xsizeRef = (size_t) gridRef->vtable->inqXVals(gridRef, NULL);
  if (xsizeTest != xsizeRef) return true;

  if (xsizeTest > 0)
  {
    const double *xvalsRef = gridRef->vtable->inqXValsPtr(gridRef);
    const double *xvalsTest = gridTest->vtable->inqXValsPtr(gridTest);
    if (!xvalsTest) return true;

    for (size_t i = 0; i < xsizeTest; ++i)
      if (fabs(xvalsTest[i] - xvalsRef[i]) > 1.e-10) return true;
  }

  size_t ysizeTest = grid_is_irregular(gridtype) ? gridTest->size : gridTest->y.size;
  size_t ysizeRef = (size_t) gridRef->vtable->inqYVals(gridRef, NULL);
  if (ysizeTest != ysizeRef) return true;

  if (ysizeTest > 0)
  {
    const double *yvalsRef = gridRef->vtable->inqYValsPtr(gridRef);
    const double *yvalsTest = gridTest->vtable->inqYValsPtr(gridTest);
    if (!yvalsTest) return true;

    for (size_t i = 0; i < ysizeTest; ++i)
      if (fabs(yvalsTest[i] - yvalsRef[i]) > 1.e-10) return true;
  }

  return differ;
}

static bool
compareXYvals2(grid_t *gridRef, grid_t *gridTest)
{
  size_t gridsize = gridTest->size;
  bool differ = ((gridTest->x.vals == NULL) ^ (gridRef->x.vals == NULL)) || ((gridTest->y.vals == NULL) ^ (gridRef->y.vals == NULL))
                || ((gridTest->x.bounds == NULL) ^ (gridRef->x.bounds == NULL))
                || ((gridTest->y.bounds == NULL) ^ (gridRef->y.bounds == NULL));

  typedef double (*inqVal)(grid_t * grid, SizeType index);
  inqVal inqXValRef = gridRef->vtable->inqXVal, inqYValRef = gridRef->vtable->inqYVal, inqXValTest = gridTest->vtable->inqXVal,
         inqYValTest = gridTest->vtable->inqYVal;

  if (!differ && gridTest->x.vals)
    differ = fabs(inqXValTest(gridTest, 0) - inqXValRef(gridRef, 0)) > 1.e-9
             || fabs(inqXValTest(gridTest, (SizeType) (gridsize - 1)) - inqXValRef(gridRef, (SizeType) (gridsize - 1))) > 1.e-9;

  if (!differ && gridTest->y.vals)
    differ = fabs(inqYValTest(gridTest, 0) - inqYValRef(gridRef, 0)) > 1.e-9
             || fabs(inqYValTest(gridTest, (SizeType) gridsize - 1) - inqYValRef(gridRef, (SizeType) gridsize - 1)) > 1.e-9;

  return differ;
}

static bool
compare_bounds(const grid_t *grid, const grid_t *gridRef)
{
  bool differ = false;

  if ((grid->x.bounds && !gridRef->x.bounds) || (!grid->x.bounds && gridRef->x.bounds) || (grid->y.bounds && !gridRef->y.bounds)
      || (!grid->y.bounds && gridRef->y.bounds))
    differ = true;

  return differ;
}

static bool
compare_lonlat(int gridID, const grid_t *grid, const grid_t *gridRef)
{
  bool differ = false;
  /*
    printf("gridID      %d\n", gridID);
    printf("grid.xdef   %d\n", grid->x.flag);
    printf("grid.ydef   %d\n", grid->y.flag);
    printf("grid.xsize  %zu\n", grid->x.size);
    printf("grid.ysize  %zu\n", grid->y.size);
    printf("grid.xfirst %f\n", grid->x.first);
    printf("grid.yfirst %f\n", grid->y.first);
    printf("grid.xfirst %f\n", gridInqXval(gridID, 0));
    printf("grid.yfirst %f\n", gridInqYval(gridID, 0));
    printf("grid.xinc   %f\n", grid->x.inc);
    printf("grid.yinc   %f\n", grid->y.inc);
    printf("grid.xinc   %f\n", gridInqXinc(gridID));
    printf("grid.yinc   %f\n", gridInqYinc(gridID));
  */
  if (grid->x.size == gridRef->x.size && grid->y.size == gridRef->y.size)
  {
    if (grid->x.flag == 2 && grid->y.flag == 2)
    {
      if (!(IS_EQUAL(grid->x.first, 0) && IS_EQUAL(grid->x.last, 0) && IS_EQUAL(grid->x.inc, 0))
          && !(IS_EQUAL(grid->y.first, 0) && IS_EQUAL(grid->y.last, 0) && IS_EQUAL(grid->y.inc, 0))
          && IS_NOT_EQUAL(grid->x.first, grid->x.last) && IS_NOT_EQUAL(grid->y.first, grid->y.last))
      {
        if (IS_NOT_EQUAL(grid->x.first, gridInqXval(gridID, 0)) || IS_NOT_EQUAL(grid->y.first, gridInqYval(gridID, 0)))
        {
          differ = true;
        }
        if (!differ && fabs(grid->x.inc) > 0 && fabs(fabs(grid->x.inc) - fabs(gridRef->x.inc)) > fabs(grid->x.inc / 1000))
        {
          differ = true;
        }
        if (!differ && fabs(grid->y.inc) > 0 && fabs(fabs(grid->y.inc) - fabs(gridRef->y.inc)) > fabs(grid->y.inc / 1000))
        {
          differ = true;
        }
      }
    }
    else if (grid->x.vals && grid->y.vals)
      differ = gridRef->vtable->compareXYFull((grid_t *) gridRef, (grid_t *) grid);

    if (!differ) differ = compare_bounds(grid, gridRef);
  }
  else
    differ = true;

  return differ;
}

static bool
compare_projection(int gridID, const grid_t *grid, const grid_t *gridRef)
{
  bool differ = compare_lonlat(gridID, grid, gridRef);

  if (!differ)
  {
    // printf(">%s< >%s<\n", cdiInqVarKeyString(&grid->keys, CDI_KEY_GRIDMAP_VARNAME), cdiInqVarKeyString(&gridRef->keys,
    // CDI_KEY_GRIDMAP_VARNAME)); printf(">%s< >%s<\n", cdiInqVarKeyString(&grid->keys, CDI_KEY_GRIDMAP_NAME),
    // cdiInqVarKeyString(&gridRef->keys, CDI_KEY_GRIDMAP_NAME));
    // if (!str_is_equal(cdiInqVarKeyString(&grid->keys, CDI_KEY_GRIDMAP_VARNAME), cdiInqVarKeyString(&gridRef->keys,
    // CDI_KEY_GRIDMAP_VARNAME))) return true; if (!str_is_equal(cdiInqVarKeyString(&grid->keys, CDI_KEY_GRIDMAP_NAME),
    // cdiInqVarKeyString(&gridRef->keys, CDI_KEY_GRIDMAP_NAME))) return true;
  }

  return differ;
}

static bool
compare_generic(const grid_t *grid, const grid_t *gridRef)
{
  bool differ = false;

  if (grid->x.size == gridRef->x.size && grid->y.size == gridRef->y.size)
  {
    if (grid->x.flag == 1 && grid->y.flag == 1 && grid->x.vals && grid->y.vals)
      differ = gridRef->vtable->compareXYFull((grid_t *) gridRef, (grid_t *) grid);
  }
  else if ((grid->y.size == 0 || grid->y.size == 1) && grid->x.size == gridRef->x.size * gridRef->y.size) {}
  else
    differ = true;

  return differ;
}

static bool
compare_gaussian(int gridID, const grid_t *grid, const grid_t *gridRef)
{
  const double cmp_eps = 0.0015;
  bool differ = false;

  if (grid->x.size == gridRef->x.size && grid->y.size == gridRef->y.size)
  {
    if (grid->x.flag == 2 && grid->y.flag == 2)
    {
      if (!(IS_EQUAL(grid->x.first, 0) && IS_EQUAL(grid->x.last, 0) && IS_EQUAL(grid->x.inc, 0))
          && !(IS_EQUAL(grid->y.first, 0) && IS_EQUAL(grid->y.last, 0)))
        if (fabs(grid->x.first - gridInqXval(gridID, 0)) > cmp_eps || fabs(grid->y.first - gridInqYval(gridID, 0)) > cmp_eps
            || (fabs(grid->x.inc) > 0 && fabs(fabs(grid->x.inc) - fabs(gridRef->x.inc)) > fabs(grid->x.inc / 1000)))
        {
          differ = true;
        }
    }
    else if (grid->x.vals && grid->y.vals)
      differ = gridRef->vtable->compareXYFull((grid_t *) gridRef, (grid_t *) grid);

    if (!differ) differ = compare_bounds(grid, gridRef);
  }
  else
    differ = true;

  return differ;
}

static bool
compare_curvilinear(const grid_t *grid, const grid_t *gridRef)
{
  bool differ = false;

  /*
    printf("gridID      %d\n", gridID);
    printf("grid.xsize  %d\n", grid->x.size);
    printf("grid.ysize  %d\n", grid->y.size);
    printf("grid.xfirst %f\n", grid->x.vals[0]);
    printf("grid.yfirst %f\n", grid->y.vals[0]);
    printf("grid xfirst %f\n", gridInqXval(gridID, 0));
    printf("grid yfirst %f\n", gridInqYval(gridID, 0));
    printf("grid.xlast  %f\n", grid->x.vals[grid->size-1]);
    printf("grid.ylast  %f\n", grid->y.vals[grid->size-1]);
    printf("grid xlast  %f\n", gridInqXval(gridID, grid->size-1));
    printf("grid ylast  %f\n", gridInqYval(gridID, grid->size-1));
    printf("grid.nv     %d\n", grid->nvertex);
    printf("grid nv     %d\n", gridInqNvertex(gridID));
  */
  if (grid->x.size == gridRef->x.size && grid->y.size == gridRef->y.size)
    differ = gridRef->vtable->compareXYAO((grid_t *) gridRef, (grid_t *) grid);

  return differ;
}

static bool
compare_unstructured(const grid_t *grid, const grid_t *gridRef, bool compareCoord)
{
  bool differ = false;

  unsigned char uuid1[CDI_UUID_SIZE] = { 0 };
  unsigned char uuid2[CDI_UUID_SIZE] = { 0 };
  int length = CDI_UUID_SIZE;
  cdiInqVarKeyBytes(&gridRef->keys, CDI_KEY_UUID, uuid1, &length);
  length = CDI_UUID_SIZE;
  cdiInqVarKeyBytes(&grid->keys, CDI_KEY_UUID, uuid2, &length);
  differ = ((!cdiUUIDIsNull(uuid1) || !cdiUUIDIsNull(uuid2)) && memcmp(uuid1, uuid2, CDI_UUID_SIZE));
  if (!differ)
  {
    int numberA = cdiInqVarKeyInt(&grid->keys, CDI_KEY_NUMBEROFGRIDUSED);
    int numberB = cdiInqVarKeyInt(&gridRef->keys, CDI_KEY_NUMBEROFGRIDUSED);
    int positionA = cdiInqVarKeyInt(&grid->keys, CDI_KEY_NUMBEROFGRIDINREFERENCE);
    int positionB = cdiInqVarKeyInt(&gridRef->keys, CDI_KEY_NUMBEROFGRIDINREFERENCE);
    if (compareCoord)
    {
      differ = (grid->nvertex != gridRef->nvertex || (numberA > 0 && positionA != positionB)
                || gridRef->vtable->compareXYFull((grid_t *) gridRef, (grid_t *) grid));
    }
    else
    {
      if (((grid->x.vals == NULL) ^ (gridRef->x.vals == NULL)) && ((grid->y.vals == NULL) ^ (gridRef->y.vals == NULL)))
      {
        int nvertexA = grid->nvertex, nvertexB = gridRef->nvertex;
        differ = (nvertexA && nvertexB && (nvertexA != nvertexB))
                 || ((numberA && numberB && (numberA != numberB)) || (numberA && numberB && positionA != positionB));
      }
      else
      {
        differ = (grid->nvertex != gridRef->nvertex || numberA != numberB || (numberA > 0 && positionA != positionB)
                  || gridRef->vtable->compareXYAO((grid_t *) gridRef, (grid_t *) grid));
      }
    }
  }

  return differ;
}

static bool
gridCompare(int gridID, const grid_t *grid, bool compareCoord)
{
  bool differ = true;
  const grid_t *gridRef = grid_to_pointer(gridID);

  if (grid->type == gridRef->type || grid->type == GRID_GENERIC)
  {
    if (grid->size == gridRef->size)
    {
      differ = false;
      if (grid->type == GRID_LONLAT) { differ = compare_lonlat(gridID, grid, gridRef); }
      else if (grid->type == GRID_PROJECTION) { differ = compare_projection(gridID, grid, gridRef); }
      else if (grid->type == GRID_GENERIC) { differ = compare_generic(grid, gridRef); }
      else if (grid->type == GRID_GAUSSIAN) { differ = compare_gaussian(gridID, grid, gridRef); }
      else if (grid->type == GRID_CURVILINEAR) { differ = compare_curvilinear(grid, gridRef); }
      else if (grid->type == GRID_UNSTRUCTURED) { differ = compare_unstructured(grid, gridRef, compareCoord); }
    }
  }

  int scanningModeA = cdiInqVarKeyInt(&grid->keys, CDI_KEY_SCANNINGMODE);
  int scanningModeB = cdiInqVarKeyInt(&gridRef->keys, CDI_KEY_SCANNINGMODE);
  if (scanningModeA != scanningModeB)
  {
    // often grid definition may differ in UV-relativeToGrid
    differ = true;
#ifdef HIRLAM_EXTENSIONS
    if (cdiDebugExt >= 200)
      printf("gridCompare(gridID=%d): Differs: scanningModeA [%d] != scanningModeB(gridID) [%d]\n", gridID, scanningModeA,
             scanningModeB);
#endif  // HIRLAM_EXTENSIONS
  }

  return differ;
}

int
cmp_key_int(const cdi_keys_t *keysp1, const cdi_keys_t *keysp2, int key)
{
  int v1 = cdiInqVarKeyInt(keysp1, key);
  int v2 = cdiInqVarKeyInt(keysp2, key);
  return (v1 != v2);
}

int
gridCompareP(void *gridptr1, void *gridptr2)
{
  grid_t *g1 = (grid_t *) gridptr1;
  grid_t *g2 = (grid_t *) gridptr2;
  enum
  {
    equal = 0,
    differ = -1
  };

  xassert(g1);
  xassert(g2);

  if (cdiInqVarKeyInt(&g1->keys, CDI_KEY_DATATYPE) != cdiInqVarKeyInt(&g2->keys, CDI_KEY_DATATYPE)) return differ;
  if (g1->type != g2->type) return differ;
  if (g1->isCyclic != g2->isCyclic) return differ;
  if (g1->x.flag != g2->x.flag) return differ;
  if (g1->y.flag != g2->y.flag) return differ;
  if (g1->gme.nd != g2->gme.nd) return differ;
  if (g1->gme.ni != g2->gme.ni) return differ;
  if (g1->gme.ni2 != g2->gme.ni2) return differ;
  if (g1->gme.ni3 != g2->gme.ni3) return differ;
  if (cmp_key_int(&g1->keys, &g2->keys, CDI_KEY_NUMBEROFGRIDUSED)) return differ;
  if (cmp_key_int(&g1->keys, &g2->keys, CDI_KEY_NUMBEROFGRIDINREFERENCE)) return differ;
  if (g1->trunc != g2->trunc) return differ;
  if (g1->nvertex != g2->nvertex) return differ;
  if (g1->reducedPointsSize != g2->reducedPointsSize) return differ;
  if (g1->size != g2->size) return differ;
  if (g1->x.size != g2->x.size) return differ;
  if (g1->y.size != g2->y.size) return differ;
  if (g1->lcomplex != g2->lcomplex) return differ;

  if (IS_NOT_EQUAL(g1->x.first, g2->x.first)) return differ;
  if (IS_NOT_EQUAL(g1->y.first, g2->y.first)) return differ;
  if (IS_NOT_EQUAL(g1->x.last, g2->x.last)) return differ;
  if (IS_NOT_EQUAL(g1->y.last, g2->y.last)) return differ;
  if (IS_NOT_EQUAL(g1->x.inc, g2->x.inc)) return differ;
  if (IS_NOT_EQUAL(g1->y.inc, g2->y.inc)) return differ;
  if (cmp_key_int(&g1->keys, &g2->keys, CDI_KEY_SCANNINGMODE)) return differ;

  bool isIrregular = grid_is_irregular(g1->type);
  {
    const double *restrict g1_xvals = g1->vtable->inqXValsPtr(g1), *restrict g2_xvals = g2->vtable->inqXValsPtr(g2);
    if ((g1_xvals != NULL) ^ (g2_xvals != NULL)) return differ;
    if (g1_xvals)
    {
      size_t size = isIrregular ? g1->size : g1->x.size;
      xassert(size);
      for (size_t i = 0; i < size; i++)
        if (IS_NOT_EQUAL(g1_xvals[i], g2_xvals[i])) return differ;
    }
  }

  {
    const double *restrict g1_yvals = g1->vtable->inqYValsPtr(g1), *restrict g2_yvals = g2->vtable->inqYValsPtr(g2);
    if ((g1_yvals != NULL) ^ (g2_yvals != NULL)) return differ;
    if (g1_yvals)
    {
      size_t size = isIrregular ? g1->size : g1->y.size;
      xassert(size);
      for (size_t i = 0; i < size; i++)
        if (IS_NOT_EQUAL(g1_yvals[i], g2_yvals[i])) return differ;
    }
  }

  {
    const double *restrict g1_area = g1->vtable->inqAreaPtr(g1), *restrict g2_area = g2->vtable->inqAreaPtr(g2);
    if ((g1_area != NULL) ^ (g2_area != NULL)) return differ;
    if (g1_area)
    {
      size_t size = g1->size;
      xassert(size);

      for (size_t i = 0; i < size; i++)
        if (IS_NOT_EQUAL(g1_area[i], g2_area[i])) return differ;
    }
  }

  {
    const double *restrict g1_xbounds = g1->vtable->inqXBoundsPtr(g1), *restrict g2_xbounds = g2->vtable->inqXBoundsPtr(g2);
    if ((g1_xbounds != NULL) ^ (g2_xbounds != NULL)) return differ;
    if (g1_xbounds)
    {
      xassert(g1->nvertex);
      size_t size = (size_t) g1->nvertex * (isIrregular ? g1->size : g1->x.size);
      xassert(size);

      for (size_t i = 0; i < size; i++)
        if (IS_NOT_EQUAL(g1_xbounds[i], g2_xbounds[i])) return differ;
    }
  }

  {
    const double *restrict g1_ybounds = g1->vtable->inqYBoundsPtr(g1), *restrict g2_ybounds = g2->vtable->inqYBoundsPtr(g2);
    if ((g1_ybounds != NULL) ^ (g2_ybounds != NULL)) return differ;
    if (g1_ybounds)
    {
      xassert(g1->nvertex);
      size_t size = (size_t) g1->nvertex * (isIrregular ? g1->size : g1->y.size);
      xassert(size);

      for (size_t i = 0; i < size; i++)
        if (IS_NOT_EQUAL(g1_ybounds[i], g2_ybounds[i])) return differ;
    }
  }

  if (!str_is_equal(cdiInqVarKeyString(&g1->x.keys, CDI_KEY_NAME), cdiInqVarKeyString(&g2->x.keys, CDI_KEY_NAME))) return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->y.keys, CDI_KEY_NAME), cdiInqVarKeyString(&g2->y.keys, CDI_KEY_NAME))) return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->x.keys, CDI_KEY_LONGNAME), cdiInqVarKeyString(&g2->x.keys, CDI_KEY_LONGNAME)))
    return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->y.keys, CDI_KEY_LONGNAME), cdiInqVarKeyString(&g2->y.keys, CDI_KEY_LONGNAME)))
    return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->x.keys, CDI_KEY_UNITS), cdiInqVarKeyString(&g2->x.keys, CDI_KEY_UNITS))) return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->y.keys, CDI_KEY_UNITS), cdiInqVarKeyString(&g2->y.keys, CDI_KEY_UNITS))) return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->x.keys, CDI_KEY_STDNAME), cdiInqVarKeyString(&g2->x.keys, CDI_KEY_STDNAME)))
    return differ;
  if (!str_is_equal(cdiInqVarKeyString(&g1->y.keys, CDI_KEY_STDNAME), cdiInqVarKeyString(&g2->y.keys, CDI_KEY_STDNAME)))
    return differ;

  if (!str_is_equal(cdiInqVarKeyString(&g1->y.keys, CDI_KEY_REFERENCEURI), cdiInqVarKeyString(&g2->y.keys, CDI_KEY_REFERENCEURI)))
    return differ;

  if (g1->mask)
  {
    xassert(g1->size);
    if (!g2->mask) return differ;
    if (memcmp(g1->mask, g2->mask, g1->size * sizeof(mask_t))) return differ;
  }
  else if (g2->mask)
    return differ;

  if (g1->mask_gme)
  {
    xassert(g1->size);
    if (!g2->mask_gme) return differ;
    if (memcmp(g1->mask_gme, g2->mask_gme, g1->size * sizeof(mask_t))) return differ;
  }
  else if (g2->mask_gme)
    return differ;

  unsigned char uuid1[CDI_UUID_SIZE] = { 0 };
  unsigned char uuid2[CDI_UUID_SIZE] = { 0 };
  int length = CDI_UUID_SIZE;
  cdiInqVarKeyBytes(&g1->keys, CDI_KEY_UUID, uuid1, &length);
  length = CDI_UUID_SIZE;
  cdiInqVarKeyBytes(&g2->keys, CDI_KEY_UUID, uuid2, &length);
  if (memcmp(uuid1, uuid2, CDI_UUID_SIZE)) return differ;

  return equal;
}

static void
grid_complete(grid_t *grid)
{
  int gridID = grid->self;

  if (grid->datatype != CDI_UNDEFID) cdiDefKeyInt(gridID, CDI_GLOBAL, CDI_KEY_DATATYPE, grid->datatype);

  int gridtype = grid->type;
  switch (gridtype)
  {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_UNSTRUCTURED:
    case GRID_CURVILINEAR:
    case GRID_GENERIC:
    case GRID_PROJECTION:
    case GRID_HEALPIX:
    case GRID_CHARXY:
    {
      if (grid->x.size > 0) gridDefXsize(gridID, (SizeType) grid->x.size);
      if (grid->y.size > 0) gridDefYsize(gridID, (SizeType) grid->y.size);

      if (gridtype == GRID_GAUSSIAN) gridDefNP(gridID, grid->np);

      if (grid->nvertex > 0) gridDefNvertex(gridID, grid->nvertex);

      if (grid->x.flag == 2)
      {
        assert(gridtype != GRID_UNSTRUCTURED && gridtype != GRID_CURVILINEAR);
        double *xvals = (double *) Malloc(grid->x.size * sizeof(double));
        gridGenXvals(grid->x.size, grid->x.first, grid->x.last, grid->x.inc, xvals);
        grid->x.vals = xvals;
        // gridDefXinc(gridID, grid->x.inc);
      }

      if (grid->y.flag == 2)
      {
        assert(gridtype != GRID_UNSTRUCTURED && gridtype != GRID_CURVILINEAR);
        double *yvals = (double *) Malloc(grid->y.size * sizeof(double));
        gridGenYvals(gridtype, grid->y.size, grid->y.first, grid->y.last, grid->y.inc, yvals);
        grid->y.vals = yvals;
        // gridDefYinc(gridID, grid->y.inc);
      }

      if (grid->projtype == CDI_PROJ_RLL)
      {
        const char *name = cdiInqVarKeyString(&grid->x.keys, CDI_KEY_NAME);
        if (name[0] == 0 || name[0] == 'x') cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_NAME, "rlon");
        name = cdiInqVarKeyString(&grid->y.keys, CDI_KEY_NAME);
        if (name[0] == 0 || name[0] == 'y') cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_NAME, "rlat");
        name = cdiInqVarKeyString(&grid->x.keys, CDI_KEY_LONGNAME);
        if (name[0] == 0) cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_LONGNAME, "longitude in rotated pole grid");
        name = cdiInqVarKeyString(&grid->y.keys, CDI_KEY_LONGNAME);
        if (name[0] == 0) cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_LONGNAME, "latitude in rotated pole grid");
        name = cdiInqVarKeyString(&grid->x.keys, CDI_KEY_UNITS);
        if (name[0] == 0) cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_UNITS, "degrees");
        name = cdiInqVarKeyString(&grid->y.keys, CDI_KEY_UNITS);
        if (name[0] == 0) cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_UNITS, "degrees");
        cdiDefKeyString(gridID, CDI_XAXIS, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_grid_latlon][0]);
        cdiDefKeyString(gridID, CDI_YAXIS, CDI_KEY_STDNAME, xystdname_tab[grid_xystdname_grid_latlon][1]);
      }

      if (gridtype == GRID_UNSTRUCTURED)
      {
        int number = cdiInqVarKeyInt(&grid->keys, CDI_KEY_NUMBEROFGRIDUSED);
        if (number > 0)
        {
          cdiDefKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDUSED, number);
          int position = cdiInqVarKeyInt(&grid->keys, CDI_KEY_NUMBEROFGRIDINREFERENCE);
          if (position > 0) cdiDefKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDINREFERENCE, position);
        }
      }

      break;
    }
    case GRID_GAUSSIAN_REDUCED:
    {
      gridDefNP(gridID, grid->np);
      gridDefYsize(gridID, (SizeType) grid->y.size);
      if (grid->x.flag == 2)
      {
        double xvals[2] = { grid->x.first, grid->x.last };
        gridDefXsize(gridID, 2);
        gridDefXvals(gridID, xvals);
      }

      if (grid->y.flag == 2)
      {
        double *yvals = (double *) Malloc(grid->y.size * sizeof(double));
        gridGenYvals(gridtype, grid->y.size, grid->y.first, grid->y.last, grid->y.inc, yvals);
        grid->y.vals = yvals;
        // gridDefYinc(gridID, grid->y.inc);
      }
      break;
    }
    case GRID_SPECTRAL:
    {
      gridDefTrunc(gridID, grid->trunc);
      if (grid->lcomplex) gridDefComplexPacking(gridID, 1);
      break;
    }
    case GRID_FOURIER:
    {
      gridDefTrunc(gridID, grid->trunc);
      break;
    }
    case GRID_GME:
    {
      gridDefParamGME(gridID, grid->gme.nd, grid->gme.ni, grid->gme.ni2, grid->gme.ni3);
      break;
    }
      /*
    case GRID_GENERIC:
      {
        if ( grid->x.size > 0 && grid->y.size > 0 )
          {
            gridDefXsize(gridID, grid->x.size);
            gridDefYsize(gridID, grid->y.size);
            if ( grid->x.vals ) gridDefXvals(gridID, grid->x.vals);
            if ( grid->y.vals ) gridDefYvals(gridID, grid->y.vals);
          }
        break;
      }
      */
    case GRID_TRAJECTORY:
    {
      gridDefXsize(gridID, 1);
      gridDefYsize(gridID, 1);
      break;
    }
    default:
    {
      Error("Gridtype %s unsupported!", gridNamePtr(gridtype));
      break;
    }
  }
}

// Used only in iterator_grib.c
int
gridGenerate(const grid_t *grid)
{
  int gridType = grid->type;
  int gridID = gridCreate(gridType, (SizeType) grid->size);
  grid_t *restrict gridptr = grid_to_pointer(gridID);
  cdiCopyVarKey(&grid->keys, CDI_KEY_DATATYPE, &gridptr->keys);
  gridptr->x.size = grid->x.size;
  gridptr->y.size = grid->y.size;
  gridptr->np = grid->np;
  gridptr->nvertex = grid->nvertex;
  gridptr->x.flag = grid->x.flag;
  int valdef_group1 = 0;
  static const int valdef_group1_tab[]
      = { GRID_LONLAT, GRID_GAUSSIAN, GRID_UNSTRUCTURED, GRID_CURVILINEAR, GRID_GENERIC, GRID_PROJECTION, GRID_HEALPIX };
  for (size_t i = 0; i < sizeof(valdef_group1_tab) / sizeof(valdef_group1_tab[0]); ++i)
    valdef_group1 |= (gridType == valdef_group1_tab[i]);
  if (valdef_group1 && grid->x.flag == 1)
  {
    gridDefXvals(gridID, grid->x.vals);
    if (grid->x.bounds) gridDefXbounds(gridID, grid->x.bounds);
  }
  gridptr->x.first = grid->x.first;
  gridptr->x.last = grid->x.last;
  gridptr->x.inc = grid->x.inc;
  gridptr->y.flag = grid->y.flag;
  if ((valdef_group1 || gridType == GRID_GAUSSIAN_REDUCED) && grid->y.flag == 1)
  {
    gridDefYvals(gridID, grid->y.vals);
    if (grid->y.bounds) gridDefYbounds(gridID, grid->y.bounds);
  }
  gridptr->y.first = grid->y.first;
  gridptr->y.last = grid->y.last;
  gridptr->y.inc = grid->y.inc;
  if (valdef_group1 && grid->area) gridDefArea(gridID, grid->area);

  cdiCopyVarKey(&grid->keys, CDI_KEY_NUMBEROFGRIDUSED, &gridptr->keys);
  cdiCopyVarKey(&grid->keys, CDI_KEY_NUMBEROFGRIDINREFERENCE, &gridptr->keys);
  cdiCopyVarKey(&grid->keys, CDI_KEY_REFERENCEURI, &gridptr->keys);

  cdiCopyVarKey(&grid->keys, CDI_KEY_SCANNINGMODE, &gridptr->keys);

  if (gridType == GRID_PROJECTION) gridptr->name = strdup(grid->name);
  if (gridType == GRID_GAUSSIAN_REDUCED) gridDefReducedPoints(gridID, (int) grid->y.size, grid->reducedPoints);
  gridptr->trunc = grid->trunc;
  gridptr->lcomplex = grid->lcomplex;
  gridptr->gme.nd = grid->gme.nd;
  gridptr->gme.ni = grid->gme.ni;
  gridptr->gme.ni2 = grid->gme.ni2;
  gridptr->gme.ni3 = grid->gme.ni3;

  grid_complete(gridptr);

  cdiCopyVarKey(&grid->keys, CDI_KEY_UUID, &gridptr->keys);

  return gridID;
}

static void
grid_copy_base_array_fields(grid_t *gridptrOrig, grid_t *gridptrDup)
{
  size_t reducedPointsSize = gridptrOrig->reducedPointsSize > 0 ? (size_t) gridptrOrig->reducedPointsSize : (size_t) 0;
  size_t gridsize = gridptrOrig->size;
  int gridtype = gridptrOrig->type;
  bool isIrregular = grid_is_irregular(gridtype);
  if (reducedPointsSize)
  {
    gridptrDup->reducedPoints = (int *) Malloc(reducedPointsSize * sizeof(int));
    memcpy(gridptrDup->reducedPoints, gridptrOrig->reducedPoints, reducedPointsSize * sizeof(int));
  }

  if (gridptrOrig->x.vals != NULL)
  {
    size_t size = isIrregular ? gridsize : gridptrOrig->x.size;
    gridptrDup->x.vals = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->x.vals, gridptrOrig->x.vals, size * sizeof(double));
  }

  if (gridptrOrig->y.vals != NULL)
  {
    size_t size = isIrregular ? gridsize : gridptrOrig->y.size;
    gridptrDup->y.vals = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->y.vals, gridptrOrig->y.vals, size * sizeof(double));
  }

  if (gridptrOrig->x.bounds != NULL)
  {
    size_t size = (isIrregular ? gridsize : gridptrOrig->x.size) * (size_t) gridptrOrig->nvertex;
    gridptrDup->x.bounds = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->x.bounds, gridptrOrig->x.bounds, size * sizeof(double));
  }

  if (gridptrOrig->y.bounds != NULL)
  {
    size_t size = (isIrregular ? gridsize : gridptrOrig->y.size) * (size_t) gridptrOrig->nvertex;
    gridptrDup->y.bounds = (double *) Malloc(size * sizeof(double));
    memcpy(gridptrDup->y.bounds, gridptrOrig->y.bounds, size * sizeof(double));
  }

  {
    const double *gridptrOrig_area = gridptrOrig->vtable->inqAreaPtr(gridptrOrig);
    if (gridptrOrig_area != NULL)
    {
      size_t size = gridsize;
      gridptrDup->area = (double *) Malloc(size * sizeof(double));
      memcpy(gridptrDup->area, gridptrOrig_area, size * sizeof(double));
    }
  }

  if (gridptrOrig->mask != NULL)
  {
    size_t size = gridsize;
    gridptrDup->mask = (mask_t *) Malloc(size * sizeof(mask_t));
    memcpy(gridptrDup->mask, gridptrOrig->mask, size * sizeof(mask_t));
  }

  if (gridptrOrig->mask_gme != NULL)
  {
    size_t size = gridsize;
    gridptrDup->mask_gme = (mask_t *) Malloc(size * sizeof(mask_t));
    memcpy(gridptrDup->mask_gme, gridptrOrig->mask_gme, size * sizeof(mask_t));
  }
}

/*
@Function  gridDuplicate
@Title     Duplicate a horizontal Grid

@Prototype int gridDuplicate(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridDuplicate} duplicates a horizontal Grid.

@Result
@func{gridDuplicate} returns an identifier to the duplicated Grid.

@EndFunction
*/
int
gridDuplicate(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  grid_t *gridptrnew = gridptr->vtable->copy(gridptr);
  int gridIDnew = reshPut(gridptrnew, &gridOps);
  gridptrnew->self = gridIDnew;
  return gridIDnew;
}

void
gridCompress(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  int gridtype = gridInqType(gridID);
  if (gridtype == GRID_UNSTRUCTURED)
  {
    if (gridptr->mask_gme != NULL)
    {
      size_t gridsize = (size_t) gridInqSize(gridID);
      size_t nv = (size_t) gridptr->nvertex;
      double *restrict area = (double *) gridptr->vtable->inqAreaPtr(gridptr),
                       *restrict xvals = (double *) gridptr->vtable->inqXValsPtr(gridptr),
                       *restrict yvals = (double *) gridptr->vtable->inqYValsPtr(gridptr),
                       *restrict xbounds = (double *) gridptr->vtable->inqXBoundsPtr(gridptr),
                       *restrict ybounds = (double *) gridptr->vtable->inqYBoundsPtr(gridptr);
      mask_t *restrict mask_gme = gridptr->mask_gme;
      size_t *restrict selection = (size_t *) Malloc(gridsize * sizeof(selection[0]));
      size_t nselect;
      {
        size_t j = 0;
        for (size_t i = 0; i < gridsize; i++) selection[j] = i, j += (mask_gme[i] != 0);
        nselect = j;
      }
      selection = (size_t *) Realloc(selection, nselect * sizeof(selection[0]));
      if (xvals)
        for (size_t i = 0; i < nselect; i++) xvals[i] = xvals[selection[i]];
      if (yvals)
        for (size_t i = 0; i < nselect; i++) yvals[i] = yvals[selection[i]];
      if (area)
        for (size_t i = 0; i < nselect; i++) area[i] = area[selection[i]];
      if (xbounds)
        for (size_t i = 0; i < nselect; i++)
          for (size_t iv = 0; iv < nv; iv++) xbounds[i * nv + iv] = xbounds[selection[i] * nv + iv];
      if (ybounds)
        for (size_t i = 0; i < nselect; i++)
          for (size_t iv = 0; iv < nv; iv++) ybounds[i * nv + iv] = ybounds[selection[i] * nv + iv];
      Free(selection);

      /* fprintf(stderr, "grid compress %d %d %d\n", i, j, gridsize); */
      gridsize = nselect;
      gridptr->size = gridsize;
      gridptr->x.size = gridsize;
      gridptr->y.size = gridsize;

      double **resizeP[] = { &gridptr->x.vals, &gridptr->y.vals, &gridptr->area, &gridptr->x.bounds, &gridptr->y.bounds };
      size_t newSize[] = { gridsize, gridsize, gridsize, nv * gridsize, nv * gridsize };
      for (size_t i = 0; i < sizeof(resizeP) / sizeof(resizeP[0]); ++i)
        if (*(resizeP[i])) *(resizeP[i]) = (double *) Realloc(*(resizeP[i]), newSize[i] * sizeof(double));

      Free(gridptr->mask_gme);
      gridptr->mask_gme = NULL;
      gridMark4Update(gridID);
    }
  }
  else
    Warning("Unsupported grid type: %s", gridNamePtr(gridtype));
}

static void
gridDefAreaSerial(grid_t *gridptr, const double *area)
{
  size_t size = gridptr->size;
  if (size == 0) Error("size undefined for gridID = %d", gridptr->self);

  if (gridptr->area == NULL)
    gridptr->area = (double *) Malloc(size * sizeof(double));
  else if (CDI_Debug)
    Warning("values already defined!");

  memcpy(gridptr->area, area, size * sizeof(double));
}

void
gridDefArea(int gridID, const double *area)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defArea(gridptr, area);
  gridMark4Update(gridID);
}

static void
gridInqAreaSerial(grid_t *gridptr, double *area)
{
  if (gridptr->area) memcpy(area, gridptr->area, gridptr->size * sizeof(double));
}

void
gridInqArea(int gridID, double *area)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->inqArea(gridptr, area);
}

static int
gridInqPropPresenceBase(grid_t *gridptr, enum gridPropInq inq)
{
  bool present = false;
  switch (inq)
  {
    case GRID_PROP_MASK: present = gridptr->mask != NULL; break;
    case GRID_PROP_MASK_GME: present = gridptr->mask != NULL; break;
    case GRID_PROP_AREA: present = gridptr->area != NULL; break;
    case GRID_PROP_XVALS: present = gridptr->x.vals != NULL; break;
    case GRID_PROP_YVALS: present = gridptr->y.vals != NULL; break;
    case GRID_PROP_XBOUNDS: present = gridptr->x.bounds != NULL; break;
    case GRID_PROP_YBOUNDS: present = gridptr->y.bounds != NULL; break;
  }
  return present;
}

int
gridInqPropPresence(int gridID, enum gridPropInq inq)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqPropPresence(gridptr, inq);
}

int
gridHasArea(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqPropPresence(gridptr, GRID_PROP_AREA);
}

static const double *
gridInqAreaPtrBase(grid_t *gridptr)
{
  return gridptr->area;
}

const double *
gridInqAreaPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqAreaPtr(gridptr);
}

void
gridDefNvertex(int gridID, int nvertex)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  if (gridptr->nvertex != nvertex)
  {
    gridptr->nvertex = nvertex;
    gridMark4Update(gridID);
  }
}

int
gridInqNvertex(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->nvertex;
}

static void
gridDefBoundsGeneric(grid_t *gridptr, const double *bounds, size_t regularSize, double **field)
{
  bool isIrregular = grid_is_irregular(gridptr->type);
  size_t nvertex = (size_t) gridptr->nvertex;
  if (nvertex == 0)
  {
    Warning("nvertex undefined for gridID = %d. Cannot define bounds!", gridptr->self);
    return;
  }

  size_t size = nvertex * (isIrregular ? gridptr->size : regularSize);
  if (size == 0) Error("size undefined for gridID = %d", gridptr->self);

  if (*field == NULL && size)
    *field = (double *) Malloc(size * sizeof(double));
  else if (CDI_Debug)
    Warning("values already defined!");

  copy_darray(size, bounds, *field);
}

static void
gridDefXBoundsSerial(grid_t *gridptr, const double *xbounds)
{
  gridDefBoundsGeneric(gridptr, xbounds, gridptr->x.size, &gridptr->x.bounds);
}

/*
@Function  gridDefXbounds
@Title     Define the bounds of a X-axis

@Prototype void gridDefXbounds(int gridID, const double *xbounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  xbounds  X-bounds of the grid.

@Description
The function @func{gridDefXbounds} defines all bounds of the X-axis.

@EndFunction
*/
void
gridDefXbounds(int gridID, const double *xbounds)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defXBounds(gridptr, xbounds);
  gridMark4Update(gridID);
}

static SizeType
gridInqXBoundsSerial(grid_t *gridptr, double *xbounds)
{
  size_t nvertex = (size_t) gridptr->nvertex;

  bool isIrregular = grid_is_irregular(gridptr->type);
  size_t size = nvertex * (isIrregular ? gridptr->size : gridptr->x.size);

  if (gridptr->x.bounds)
  {
    if (size && xbounds) copy_darray(size, gridptr->vtable->inqXBoundsPtr(gridptr), xbounds);
  }
  else
    size = 0;

  return (SizeType) size;
}

/*
@Function  gridInqXbounds
@Title     Get the bounds of a X-axis

@Prototype SizeType gridInqXbounds(int gridID, double *xbounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  xbounds  Pointer to the location into which the X-bounds are read.
                    The caller must allocate space for the returned values.

@Description
The function @func{gridInqXbounds} returns the bounds of the X-axis.

@Result
Upon successful completion @func{gridInqXbounds} returns the number of bounds and
the bounds are stored in @func{xbounds}.
Otherwise, 0 is returned and @func{xbounds} is empty.

@EndFunction
*/
SizeType
gridInqXbounds(int gridID, double *xbounds)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXBounds(gridptr, xbounds);
}

static const double *
gridInqXBoundsPtrSerial(grid_t *gridptr)
{
  return gridptr->x.bounds;
}

const double *
gridInqXboundsPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXBoundsPtr(gridptr);
}

static void
gridDefYBoundsSerial(grid_t *gridptr, const double *ybounds)
{
  gridDefBoundsGeneric(gridptr, ybounds, gridptr->y.size, &gridptr->y.bounds);
}

//----------------------------------------------------------------------------
// Parallel Version
//----------------------------------------------------------------------------

SizeType
gridInqXboundsPart(int gridID, int start, SizeType size, double *xbounds)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  const double *gridptr_xbounds = gridptr->vtable->inqXBoundsPtr(gridptr);
  if (gridptr_xbounds && size && xbounds) memcpy(xbounds, gridptr_xbounds + start, (size_t) size * sizeof(double));

  return size;
}

SizeType
gridInqYboundsPart(int gridID, int start, SizeType size, double *ybounds)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  const double *gridptr_ybounds = gridptr->vtable->inqYBoundsPtr(gridptr);
  if (gridptr_ybounds && size && ybounds) memcpy(ybounds, gridptr_ybounds + start, (size_t) size * sizeof(double));

  return size;
}

/*
@Function  gridDefYbounds
@Title     Define the bounds of a Y-axis

@Prototype void gridDefYbounds(int gridID, const double *ybounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  ybounds  Y-bounds of the grid.

@Description
The function @func{gridDefYbounds} defines all bounds of the Y-axis.

@EndFunction
*/
void
gridDefYbounds(int gridID, const double *ybounds)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->vtable->defYBounds(gridptr, ybounds);
  gridMark4Update(gridID);
}

static SizeType
gridInqYBoundsSerial(grid_t *gridptr, double *ybounds)
{
  size_t nvertex = (size_t) gridptr->nvertex;

  bool isIrregular = grid_is_irregular(gridptr->type);
  size_t size = nvertex * (isIrregular ? gridptr->size : gridptr->y.size);

  if (gridptr->y.bounds)
  {
    if (size && ybounds) copy_darray(size, gridptr->vtable->inqYBoundsPtr(gridptr), ybounds);
  }
  else
    size = 0;

  return (SizeType) size;
}

/*
@Function  gridInqYbounds
@Title     Get the bounds of a Y-axis

@Prototype SizeType gridInqYbounds(int gridID, double *ybounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  ybounds  Pointer to the location into which the Y-bounds are read.
                    The caller must allocate space for the returned values.

@Description
The function @func{gridInqYbounds} returns the bounds of the Y-axis.

@Result
Upon successful completion @func{gridInqYbounds} returns the number of bounds and
the bounds are stored in @func{ybounds}.
Otherwise, 0 is returned and @func{ybounds} is empty.

@EndFunction
*/
SizeType
gridInqYbounds(int gridID, double *ybounds)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYBounds(gridptr, ybounds);
}

static const double *
gridInqYBoundsPtrSerial(grid_t *gridptr)
{
  return gridptr->y.bounds;
}

const double *
gridInqYboundsPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYBoundsPtr(gridptr);
}

static void
printDblsPrefixAutoBrk(FILE *fp, int dig, const char prefix[], size_t nbyte0, size_t n, const double vals[])
{
  fputs(prefix, fp);
  size_t nbyte = nbyte0;
  for (size_t i = 0; i < n; i++)
  {
    if (nbyte > 80)
    {
      fprintf(fp, "\n%*s", (int) nbyte0, "");
      nbyte = nbyte0;
    }
    nbyte += (size_t) fprintf(fp, "%.*g ", dig, vals[i]);
  }
  fputs("\n", fp);
}

static inline void *
resizeBuffer(void **buf, size_t *bufSize, size_t reqSize)
{
  if (reqSize > *bufSize)
  {
    *buf = Realloc(*buf, reqSize);
    *bufSize = reqSize;
  }
  return *buf;
}

static void
gridPrintAttributes(FILE *fp, int gridID)
{
  int cdiID = gridID;
  int varID = CDI_GLOBAL;
  int atttype, attlen;
  char attname[CDI_MAX_NAME + 1];
  void *attBuf = NULL;
  size_t attBufSize = 0;

  int natts;
  cdiInqNatts(cdiID, varID, &natts);

  for (int iatt = 0; iatt < natts; ++iatt)
  {
    cdiInqAtt(cdiID, varID, iatt, attname, &atttype, &attlen);

    if (attlen == 0) continue;

    if (atttype == CDI_DATATYPE_TXT)
    {
      size_t attSize = (size_t) (attlen + 1) * sizeof(char);
      char *atttxt = (char *) resizeBuffer(&attBuf, &attBufSize, attSize);
      cdiInqAttTxt(cdiID, varID, attname, attlen, atttxt);
      atttxt[attlen] = 0;
      fprintf(fp, "ATTR_TXT: %s = \"%s\"\n", attname, atttxt);
    }
    else if (atttype == CDI_DATATYPE_INT8 || atttype == CDI_DATATYPE_UINT8 || atttype == CDI_DATATYPE_INT16
             || atttype == CDI_DATATYPE_UINT16 || atttype == CDI_DATATYPE_INT32 || atttype == CDI_DATATYPE_UINT32)
    {
      size_t attSize = (size_t) attlen * sizeof(int);
      int *attint = (int *) resizeBuffer(&attBuf, &attBufSize, attSize);
      cdiInqAttInt(cdiID, varID, attname, attlen, &attint[0]);
      if (attlen == 1)
        fprintf(fp, "ATTR_INT: %s =", attname);
      else
        fprintf(fp, "ATTR_INT_%d: %s =", attlen, attname);
      for (int i = 0; i < attlen; ++i) fprintf(fp, " %d", attint[i]);
      fprintf(fp, "\n");
    }
    else if (atttype == CDI_DATATYPE_FLT32 || atttype == CDI_DATATYPE_FLT64)
    {
      size_t attSize = (size_t) attlen * sizeof(double);
      double *attflt = (double *) resizeBuffer(&attBuf, &attBufSize, attSize);
      int dig = (atttype == CDI_DATATYPE_FLT64) ? 15 : 7;
      cdiInqAttFlt(cdiID, varID, attname, attlen, attflt);
      if (attlen == 1)
        fprintf(fp, "ATTR_FLT: %s =", attname);
      else
        fprintf(fp, "ATTR_FLT_%d: %s =", attlen, attname);
      for (int i = 0; i < attlen; ++i) fprintf(fp, " %.*g", dig, attflt[i]);
      fprintf(fp, "\n");
    }
  }

  Free(attBuf);
}

static void
gridPrintKernel(int gridID, int opt, FILE *fp)
{
  char attstr[CDI_MAX_NAME];
  char attstr2[CDI_MAX_NAME];
  size_t nxvals = (size_t) gridInqXvals(gridID, NULL);
  size_t nyvals = (size_t) gridInqYvals(gridID, NULL);

  int type = gridInqType(gridID);
  size_t gridsize = (size_t) gridInqSize(gridID);
  size_t xsize = (size_t) gridInqXsize(gridID);
  size_t ysize = (size_t) gridInqYsize(gridID);
  int nvertex = gridInqNvertex(gridID);
  int datatype;
  cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_DATATYPE, &datatype);

  int dig = (datatype == CDI_DATATYPE_FLT64) ? 15 : 7;

  fprintf(fp,
          "gridtype  = %s\n"
          "gridsize  = %zu\n",
          gridNamePtr(type), gridsize);

  if (type != GRID_GME)
  {
    if (type != GRID_UNSTRUCTURED && type != GRID_SPECTRAL && type != GRID_FOURIER)
    {
      if (xsize > 0) fprintf(fp, "xsize     = %zu\n", xsize);
      if (ysize > 0) fprintf(fp, "ysize     = %zu\n", ysize);
    }

    if (nxvals > 0)
    {
      int length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_NAME, attstr, &length);
      if (attstr[0]) fprintf(fp, "xname     = %s\n", attstr);
      length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_DIMNAME, attstr2, &length);
      if (attstr2[0] && !str_is_equal(attstr, attstr2)) fprintf(fp, "xdimname  = %s\n", attstr2);
      length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_LONGNAME, attstr, &length);
      if (attstr[0]) fprintf(fp, "xlongname = %s\n", attstr);
      length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_XAXIS, CDI_KEY_UNITS, attstr, &length);
      if (attstr[0]) fprintf(fp, "xunits    = %s\n", attstr);
    }

    if (nyvals > 0)
    {
      int length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_NAME, attstr, &length);
      if (attstr[0]) fprintf(fp, "yname     = %s\n", attstr);
      length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_DIMNAME, attstr2, &length);
      if (attstr2[0] && !str_is_equal(attstr, attstr2)) fprintf(fp, "ydimname  = %s\n", attstr2);
      length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_LONGNAME, attstr, &length);
      if (attstr[0]) fprintf(fp, "ylongname = %s\n", attstr);
      length = CDI_MAX_NAME;
      cdiInqKeyString(gridID, CDI_YAXIS, CDI_KEY_UNITS, attstr, &length);
      if (attstr[0]) fprintf(fp, "yunits    = %s\n", attstr);
    }

    if (type == GRID_UNSTRUCTURED && nvertex > 0) fprintf(fp, "nvertex   = %d\n", nvertex);
  }

  switch (type)
  {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_GAUSSIAN_REDUCED:
    case GRID_GENERIC:
    case GRID_PROJECTION:
    case GRID_CURVILINEAR:
    case GRID_UNSTRUCTURED:
    case GRID_CHARXY:
    {
      if (type == GRID_GAUSSIAN || type == GRID_GAUSSIAN_REDUCED) fprintf(fp, "np        = %d\n", gridInqNP(gridID));

      if (type == GRID_UNSTRUCTURED)
      {
        int number = 0;
        cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDUSED, &number);
        if (number > 0)
        {
          fprintf(fp, "number    = %d\n", number);
          int position = 0;
          cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDINREFERENCE, &position);
          if (position >= 0) fprintf(fp, "position  = %d\n", position);
        }

        int length;
        if (CDI_NOERR == cdiInqKeyLen(gridID, CDI_GLOBAL, CDI_KEY_REFERENCEURI, &length))
        {
          char reference_link[8192];
          length = sizeof(reference_link);
          cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_REFERENCEURI, reference_link, &length);
          fprintf(fp, "uri       = %s\n", reference_link);
        }
      }

      if (nxvals > 0)
      {
        double xfirst = 0.0, xinc = 0.0;

        if (type == GRID_LONLAT || type == GRID_GAUSSIAN || type == GRID_PROJECTION || type == GRID_GENERIC)
        {
          xfirst = gridInqXval(gridID, 0);
          xinc = gridInqXinc(gridID);
        }

        if (IS_NOT_EQUAL(xinc, 0) && opt)
        {
          fprintf(fp,
                  "xfirst    = %.*g\n"
                  "xinc      = %.*g\n",
                  dig, xfirst, dig, xinc);
        }
        else
        {
          double *xvals = (double *) Malloc(nxvals * sizeof(double));
          gridInqXvals(gridID, xvals);
          static const char prefix[] = "xvals     = ";
          printDblsPrefixAutoBrk(fp, dig, prefix, sizeof(prefix) - 1, nxvals, xvals);
          Free(xvals);
        }
      }

      if (nyvals > 0)
      {
        double yfirst = 0.0, yinc = 0.0;

        if (type == GRID_LONLAT || type == GRID_GENERIC || type == GRID_PROJECTION || type == GRID_GENERIC)
        {
          yfirst = gridInqYval(gridID, 0);
          yinc = gridInqYinc(gridID);
        }

        if (IS_NOT_EQUAL(yinc, 0) && opt)
        {
          fprintf(fp,
                  "yfirst    = %.*g\n"
                  "yinc      = %.*g\n",
                  dig, yfirst, dig, yinc);
        }
        else
        {
          double *yvals = (double *) Malloc(nyvals * sizeof(double));
          gridInqYvals(gridID, yvals);
          static const char prefix[] = "yvals     = ";
          printDblsPrefixAutoBrk(fp, dig, prefix, sizeof(prefix) - 1, nyvals, yvals);
          Free(yvals);
        }
      }

      if (type == GRID_PROJECTION) gridPrintAttributes(fp, gridID);

      break;
    }
    case GRID_SPECTRAL:
    {
      fprintf(fp,
              "truncation = %d\n"
              "complexpacking = %d\n",
              gridInqTrunc(gridID), gridInqComplexPacking(gridID));
      break;
    }
    case GRID_FOURIER:
    {
      fprintf(fp, "truncation = %d\n", gridInqTrunc(gridID));
      break;
    }
    case GRID_GME:
    {
      int nd, ni, ni2, ni3;
      gridInqParamGME(gridID, &nd, &ni, &ni2, &ni3);
      fprintf(fp, "ni        = %d\n", ni);
      break;
    }
    default:
    {
      fprintf(stderr, "Unsupported grid type: %s\n", gridNamePtr(type));
      break;
    }
  }
}

void
gridPrintP(void *voidptr, FILE *fp)
{
  grid_t *gridptr = (grid_t *) voidptr;
  int gridID = gridptr->self;

  xassert(gridptr);

  gridPrintKernel(gridID, 0, fp);

  int datatype = CDI_UNDEFID;
  cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_DATATYPE, &datatype);

  fprintf(fp,
          "datatype  = %d\n"
          "nd        = %d\n"
          "ni        = %d\n"
          "ni2       = %d\n"
          "ni3       = %d\n"
          "trunc     = %d\n"
          "lcomplex  = %d\n"
          "reducedPointsSize   = %d\n",
          datatype, gridptr->gme.nd, gridptr->gme.ni, gridptr->gme.ni2, gridptr->gme.ni3, gridptr->trunc, gridptr->lcomplex,
          gridptr->reducedPointsSize);
}

static const double *
gridInqXValsPtrSerial(grid_t *gridptr)
{
  return gridptr->x.vals;
}

#ifndef USE_MPI
static const char **
gridInqXCvalsPtrSerial(grid_t *gridptr)
{
  return (const char **) gridptr->x.cvals;
}
#endif

const double *
gridInqXvalsPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXValsPtr(gridptr);
}

#ifndef USE_MPI
const char **
gridInqXCvalsPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqXCvalsPtr(gridptr);
}
#endif

static const double *
gridInqYValsPtrSerial(grid_t *gridptr)
{
  return gridptr->y.vals;
}

#ifndef USE_MPI
static const char **
gridInqYCvalsPtrSerial(grid_t *gridptr)
{
  return (const char **) gridptr->y.cvals;
}
#endif

const double *
gridInqYvalsPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYValsPtr(gridptr);
}

#ifndef USE_MPI
const char **
gridInqYCvalsPtr(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);
  return gridptr->vtable->inqYCvalsPtr(gridptr);
}
#endif

void
gridProjParamsInit(struct CDI_GridProjParams *gpp)
{
  // clang-format off
  gpp->mv      = CDI_Grid_Missval;   // Missing value
  gpp->lon_0   = CDI_Grid_Missval;   // The East longitude of the meridian which is parallel to the Y-axis
  gpp->lat_0   = CDI_Grid_Missval;   // Latitude of the projection origin
  gpp->lat_1   = CDI_Grid_Missval;   // First latitude from the pole at which the secant cone cuts the sphere
  gpp->lat_2   = CDI_Grid_Missval;   // Second latitude at which the secant cone cuts the sphere
  gpp->a       = CDI_Grid_Missval;   // Semi-major axis or earth radius in metres (optional)
  gpp->b       = CDI_Grid_Missval;   // Semi-minor axis in metres (optional)
  gpp->rf      = CDI_Grid_Missval;   // Inverse flattening (1/f) (optional)
  gpp->xval_0  = CDI_Grid_Missval;   // Longitude of the first grid point in degree (optional)
  gpp->yval_0  = CDI_Grid_Missval;   // Latitude of the first grid point in degree (optional)
  gpp->x_0     = CDI_Grid_Missval;   // False easting (optional)
  gpp->y_0     = CDI_Grid_Missval;   // False northing (optional)
  gpp->x_SP    = CDI_Grid_Missval;   // Longitude of southern pole
  gpp->y_SP    = CDI_Grid_Missval;   // Latitude of southern pole
  gpp->nside   = 0;                  // HEALPix number of points along a side (number of data points should be = 12 * nside * nside)
  gpp->order   = -1;                 // HEALPix ordering convention (0:ring; 1:nested)
  // clang-format on
}

static void
gridDefParamsCommon(int gridID, struct CDI_GridProjParams gpp)
{
  if (IS_NOT_EQUAL(gpp.a, gpp.mv))
  {
    if (IS_NOT_EQUAL(gpp.b, gpp.mv))
    {
      cdiDefAttFlt(gridID, CDI_GLOBAL, "semi_major_axis", CDI_DATATYPE_FLT64, 1, &gpp.a);
      cdiDefAttFlt(gridID, CDI_GLOBAL, "semi_minor_axis", CDI_DATATYPE_FLT64, 1, &gpp.b);
    }
    else { cdiDefAttFlt(gridID, CDI_GLOBAL, "earth_radius", CDI_DATATYPE_FLT64, 1, &gpp.a); }
  }
  if (IS_NOT_EQUAL(gpp.rf, gpp.mv)) cdiDefAttFlt(gridID, CDI_GLOBAL, "inverse_flattening", CDI_DATATYPE_FLT64, 1, &gpp.rf);
  if (IS_NOT_EQUAL(gpp.x_0, gpp.mv)) cdiDefAttFlt(gridID, CDI_GLOBAL, "false_easting", CDI_DATATYPE_FLT64, 1, &gpp.x_0);
  if (IS_NOT_EQUAL(gpp.y_0, gpp.mv)) cdiDefAttFlt(gridID, CDI_GLOBAL, "false_northing", CDI_DATATYPE_FLT64, 1, &gpp.y_0);
  if (IS_NOT_EQUAL(gpp.xval_0, gpp.mv))
    cdiDefAttFlt(gridID, CDI_GLOBAL, "longitudeOfFirstGridPointInDegrees", CDI_DATATYPE_FLT64, 1, &gpp.xval_0);
  if (IS_NOT_EQUAL(gpp.yval_0, gpp.mv))
    cdiDefAttFlt(gridID, CDI_GLOBAL, "latitudeOfFirstGridPointInDegrees", CDI_DATATYPE_FLT64, 1, &gpp.yval_0);
  if (IS_NOT_EQUAL(gpp.x_SP, gpp.mv))
    cdiDefAttFlt(gridID, CDI_GLOBAL, "longitudeOfSouthernPoleInDegrees", CDI_DATATYPE_FLT64, 1, &gpp.x_SP);
  if (IS_NOT_EQUAL(gpp.y_SP, gpp.mv))
    cdiDefAttFlt(gridID, CDI_GLOBAL, "latitudeOfSouthernPoleInDegrees", CDI_DATATYPE_FLT64, 1, &gpp.y_SP);
}

/*
@Function  gridDefParamsLCC
@Title     Define the parameters of a Lambert Conformal Conic grid

@Prototype void gridDefParamsLCC(int gridID, struct CDI_GridProjParams gridProjParams)
@Parameter
    @Item  gridID          Grid ID, from a previous call to @fref{gridCreate}.
    @Item  gridProjParams  Grid projection parameters.

@Description
The function @func{gridDefParamsLCC} defines the parameters of a Lambert Conformal Conic grid.

@EndFunction
*/
void
gridDefParamsLCC(int gridID, struct CDI_GridProjParams gpp)
{
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_VARNAME, "Lambert_Conformal");

  const char *gmapname = "lambert_conformal_conic";
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname);
  cdiDefAttTxt(gridID, CDI_GLOBAL, "grid_mapping_name", (int) (strlen(gmapname)), gmapname);
  int nlats = 0;
  double lats[2];
  lats[nlats++] = gpp.lat_1;
  if (IS_NOT_EQUAL(gpp.lat_1, gpp.lat_2)) lats[nlats++] = gpp.lat_2;
  cdiDefAttFlt(gridID, CDI_GLOBAL, "standard_parallel", CDI_DATATYPE_FLT64, nlats, lats);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "longitude_of_central_meridian", CDI_DATATYPE_FLT64, 1, &gpp.lon_0);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "latitude_of_projection_origin", CDI_DATATYPE_FLT64, 1, &gpp.lat_0);

  gridDefParamsCommon(gridID, gpp);

  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->projtype = CDI_PROJ_LCC;

  if (gridptr->type != GRID_PROJECTION) gridptr->type = GRID_PROJECTION;

  gridVerifyProj(gridID);
}

/*
@Function  gridInqParamsLCC
@Title     Get the parameter of a Lambert Conformal Conic grid

@Prototype void gridInqParamsLCC(int gridID, struct CDI_GridProjParams *gpp)
@Parameter
    @Item  gridID          Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  gridProjParams  Grid projection parameters.

@Description
The function @func{gridInqParamsLCC} returns the parameter of a Lambert Conformal Conic grid.

@EndFunction
*/
int
gridInqParamsLCC(int gridID, struct CDI_GridProjParams *gpp)
{
  int status = -1;
  if (gridInqType(gridID) != GRID_PROJECTION) return status;

  gridProjParamsInit(gpp);

  status = -2;
  const char *projection = "lambert_conformal_conic";
  char gmapname[CDI_MAX_NAME];
  int length = CDI_MAX_NAME;
  cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname, &length);
  if (gmapname[0] && str_is_equal(gmapname, projection))
  {
    char attname[CDI_MAX_NAME + 1];

    int natts;
    cdiInqNatts(gridID, CDI_GLOBAL, &natts);

    if (natts) status = 0;

    for (int iatt = 0; iatt < natts; ++iatt)
    {
      int atttype, attlen;
      cdiInqAtt(gridID, CDI_GLOBAL, iatt, attname, &atttype, &attlen);
      if (attlen > 2) continue;

      double attflt[2];
      if (cdiInqAttConvertedToFloat(gridID, atttype, attname, attlen, attflt))
      {
        // clang-format off
              if      (str_is_equal(attname, "earth_radius"))                       gpp->a      = attflt[0];
              else if (str_is_equal(attname, "semi_major_axis"))                    gpp->a      = attflt[0];
              else if (str_is_equal(attname, "semi_minor_axis"))                    gpp->b      = attflt[0];
              else if (str_is_equal(attname, "inverse_flattening"))                 gpp->rf     = attflt[0];
              else if (str_is_equal(attname, "longitude_of_central_meridian"))      gpp->lon_0  = attflt[0];
              else if (str_is_equal(attname, "latitude_of_projection_origin"))      gpp->lat_0  = attflt[0];
              else if (str_is_equal(attname, "false_easting"))                      gpp->x_0    = attflt[0];
              else if (str_is_equal(attname, "false_northing"))                     gpp->y_0    = attflt[0];
              else if (str_is_equal(attname, "longitudeOfFirstGridPointInDegrees")) gpp->xval_0 = attflt[0];
              else if (str_is_equal(attname, "latitudeOfFirstGridPointInDegrees"))  gpp->yval_0 = attflt[0];
              else if (str_is_equal(attname, "longitudeOfSouthernPoleInDegrees"))   gpp->x_SP   = attflt[0];
              else if (str_is_equal(attname, "latitudeOfSouthernPoleInDegrees"))    gpp->y_SP   = attflt[0];
              else if (str_is_equal(attname, "standard_parallel"))
                {
                  gpp->lat_1 = attflt[0];
                  gpp->lat_2 = (attlen == 2) ? attflt[1] : attflt[0];
                }
        // clang-format on
      }
    }
  }

  return status;
}

int
gridVerifyProjParamsLCC(struct CDI_GridProjParams *gpp)
{
  static bool lwarn = true;

  if (lwarn)
  {
    // lwarn = false;
    const char *projection = "lambert_conformal_conic";
    if (IS_EQUAL(gpp->lon_0, gpp->mv)) Warning("%s mapping parameter %s missing!", projection, "longitude_of_central_meridian");
    if (IS_EQUAL(gpp->lat_0, gpp->mv)) Warning("%s mapping parameter %s missing!", projection, "latitude_of_central_meridian");
    if (IS_EQUAL(gpp->lat_1, gpp->mv)) Warning("%s mapping parameter %s missing!", projection, "standard_parallel");
    if (IS_NOT_EQUAL(gpp->x_0, gpp->mv) && IS_NOT_EQUAL(gpp->y_0, gpp->mv)
        && (IS_EQUAL(gpp->xval_0, gpp->mv) || IS_EQUAL(gpp->yval_0, gpp->mv)))
    {
      if (proj_lcc_to_lonlat_func)
      {
        gpp->xval_0 = -gpp->x_0;
        gpp->yval_0 = -gpp->y_0;
        proj_lcc_to_lonlat_func(*gpp, 0.0, 0.0, (SizeType) 1, &gpp->xval_0, &gpp->yval_0);
      }
      if (IS_EQUAL(gpp->xval_0, gpp->mv) || IS_EQUAL(gpp->yval_0, gpp->mv))
        Warning("%s mapping parameter %s missing!", projection,
                "longitudeOfFirstGridPointInDegrees and latitudeOfFirstGridPointInDegrees");
    }
  }

  return 0;
}

int
gridVerifyProjParamsSTERE(struct CDI_GridProjParams *gpp)
{
  static bool lwarn = true;

  if (lwarn)
  {
    // lwarn = false;
    const char *projection = "polar_stereographic";
    if (IS_EQUAL(gpp->lon_0, gpp->mv))
      Warning("%s mapping parameter %s missing!", projection, "straight_vertical_longitude_from_pole");
    if (IS_EQUAL(gpp->lat_0, gpp->mv)) Warning("%s mapping parameter %s missing!", projection, "latitude_of_projection_origin");
    if (IS_EQUAL(gpp->lat_1, gpp->mv)) Warning("%s mapping parameter %s missing!", projection, "standard_parallel");
    if (IS_NOT_EQUAL(gpp->x_0, gpp->mv) && IS_NOT_EQUAL(gpp->y_0, gpp->mv)
        && (IS_EQUAL(gpp->xval_0, gpp->mv) || IS_EQUAL(gpp->yval_0, gpp->mv)))
    {
      if (proj_stere_to_lonlat_func)
      {
        gpp->xval_0 = -gpp->x_0;
        gpp->xval_0 = -gpp->y_0;
        proj_stere_to_lonlat_func(*gpp, 0.0, 0.0, (SizeType) 1, &gpp->xval_0, &gpp->yval_0);
      }
      if (IS_EQUAL(gpp->xval_0, gpp->mv) || IS_EQUAL(gpp->yval_0, gpp->mv))
        Warning("%s mapping parameter %s missing!", projection,
                "longitudeOfFirstGridPointInDegrees and latitudeOfFirstGridPointInDegrees");
    }
  }

  return 0;
}

int
gridVerifyProjParamsHEALPIX(struct CDI_GridProjParams *gpp)
{
  static bool lwarn = true;

  if (lwarn)
  {
    lwarn = false;
    const char *projection = "healpix";
    if (IS_EQUAL(gpp->nside, -1)) Error("%s mapping parameter %s missing!", projection, "nside");
    if (IS_EQUAL(gpp->order, -1)) Error("%s mapping parameter %s missing!", projection, "order");
    if (gpp->nside == 0) Error("%s mapping parameter %s unsupported!", projection, "nside", gpp->nside);
    if (gpp->order != 0 && gpp->order != 1) Error("%s mapping parameter %s=%d unsupported!", projection, "order", gpp->order);
  }

  return 0;
}

/*
@Function  gridDefParamsSTERE
@Title     Define the parameter of a Polar stereographic grid

@Prototype void gridDefParamsSTERE(int gridID, struct CDI_GridProjParams gridProjParams)
@Parameter
    @Item  gridID          Grid ID, from a previous call to @fref{gridCreate}.
    @Item  gridProjParams  Grid projection parameters.

@Description
The function @func{gridDefParamsSTERE} defines the parameter of a Polar stereographic grid.

@EndFunction
*/
void
gridDefParamsSTERE(int gridID, struct CDI_GridProjParams gpp)
{
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_VARNAME, "Polar_Stereographic");

  const char *gmapname = "polar_stereographic";
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname);
  cdiDefAttTxt(gridID, CDI_GLOBAL, "grid_mapping_name", (int) (strlen(gmapname)), gmapname);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "standard_parallel", CDI_DATATYPE_FLT64, 1, &gpp.lat_1);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "straight_vertical_longitude_from_pole", CDI_DATATYPE_FLT64, 1, &gpp.lon_0);
  cdiDefAttFlt(gridID, CDI_GLOBAL, "latitude_of_projection_origin", CDI_DATATYPE_FLT64, 1, &gpp.lat_0);

  gridDefParamsCommon(gridID, gpp);

  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->projtype = CDI_PROJ_STERE;

  gridVerifyProj(gridID);
}

void
gridDefParamsHEALPIX(int gridID, struct CDI_GridProjParams gpp)
{
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_VARNAME, "healpix");

  const char *gmapname = "healpix";
  cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname);
  cdiDefAttTxt(gridID, CDI_GLOBAL, "grid_mapping_name", (int) (strlen(gmapname)), gmapname);

  cdiDefAttInt(gridID, CDI_GLOBAL, "healpix_nside", CDI_DATATYPE_INT32, 1, &gpp.nside);
  const char *orderName = (gpp.order == 1) ? "nested" : "ring";
  cdiDefAttTxt(gridID, CDI_GLOBAL, "healpix_order", (int) (strlen(orderName)), orderName);

  // gridDefParamsCommon(gridID, gpp);

  grid_t *gridptr = grid_to_pointer(gridID);
  gridptr->projtype = CDI_PROJ_HEALPIX;

  // gridVerifyProj(gridID);
}

/*
@Function  gridInqParamsSTERE
@Title     Get the parameter of a Polar stereographic grid

@Prototype void gridInqParamsSTERE(int gridID, struct CDI_GridProjParams *gpp)
@Parameter
    @Item  gridID    Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.
    @Item  gridProjParams  Grid projection parameters.

@Description
The function @func{gridInqParamsSTERE} returns the parameter of a Polar stereographic grid.

@EndFunction
*/
int
gridInqParamsSTERE(int gridID, struct CDI_GridProjParams *gpp)
{
  int status = -1;
  if (gridInqType(gridID) != GRID_PROJECTION) return status;

  gridProjParamsInit(gpp);

  status = -2;
  const char *projection = "polar_stereographic";
  char gmapname[CDI_MAX_NAME];
  int length = CDI_MAX_NAME;
  cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname, &length);
  if (gmapname[0] && str_is_equal(gmapname, projection))
  {
    int atttype, attlen;
    char attname[CDI_MAX_NAME + 1];

    int natts;
    cdiInqNatts(gridID, CDI_GLOBAL, &natts);

    if (natts) status = 0;

    for (int iatt = 0; iatt < natts; ++iatt)
    {
      cdiInqAtt(gridID, CDI_GLOBAL, iatt, attname, &atttype, &attlen);
      if (attlen > 2) continue;

      double attflt[2];
      if (cdiInqAttConvertedToFloat(gridID, atttype, attname, attlen, attflt))
      {
        // clang-format off
              if      (str_is_equal(attname, "earth_radius"))                          gpp->a      = attflt[0];
              else if (str_is_equal(attname, "semi_major_axis"))                       gpp->a      = attflt[0];
              else if (str_is_equal(attname, "semi_minor_axis"))                       gpp->b      = attflt[0];
              else if (str_is_equal(attname, "inverse_flattening"))                    gpp->rf     = attflt[0];
              else if (str_is_equal(attname, "standard_parallel"))                     gpp->lat_1  = attflt[0];
              else if (str_is_equal(attname, "straight_vertical_longitude_from_pole")) gpp->lon_0  = attflt[0];
              else if (str_is_equal(attname, "latitude_of_projection_origin"))         gpp->lat_0  = attflt[0];
              else if (str_is_equal(attname, "false_easting"))                         gpp->x_0    = attflt[0];
              else if (str_is_equal(attname, "false_northing"))                        gpp->y_0    = attflt[0];
              else if (str_is_equal(attname, "longitudeOfFirstGridPointInDegrees"))    gpp->xval_0 = attflt[0];
              else if (str_is_equal(attname, "latitudeOfFirstGridPointInDegrees"))     gpp->yval_0 = attflt[0];
        // clang-format on
      }
    }
  }

  return status;
}

int
gridInqParamsHEALPIX(int gridID, struct CDI_GridProjParams *gpp)
{
  int status = -1;
  if (gridInqType(gridID) != GRID_PROJECTION) return status;

  gridProjParamsInit(gpp);

  status = -2;
  const char *projection = "healpix";
  char gmapname[CDI_MAX_NAME];
  int length = CDI_MAX_NAME;
  cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_GRIDMAP_NAME, gmapname, &length);
  if (gmapname[0] && str_is_equal(gmapname, projection))
  {
    int atttype, attlen;
    char attname[CDI_MAX_NAME + 1];

    int natts;
    cdiInqNatts(gridID, CDI_GLOBAL, &natts);

    if (natts) status = 0;

    for (int iatt = 0; iatt < natts; ++iatt)
    {
      cdiInqAtt(gridID, CDI_GLOBAL, iatt, attname, &atttype, &attlen);

      if (atttype == CDI_DATATYPE_TXT)
      {
        char attstring[256];
        if (cdiInqAttTxt(gridID, CDI_GLOBAL, attname, (int) sizeof(attstring), attstring) == 0)
        {
          attstring[attlen] = 0;
          if (str_is_equal(attname, "healpix_order")) gpp->order = strStartsWith(attstring, "nest");
        }
      }
      else
      {
        if (attlen > 2) continue;
        double attflt[2];
        if (cdiInqAttConvertedToFloat(gridID, atttype, attname, attlen, attflt))
        {
          // clang-format off
                  if      (str_is_equal(attname, "earth_radius"))                          gpp->a      = attflt[0];
                  else if (str_is_equal(attname, "semi_major_axis"))                       gpp->a      = attflt[0];
                  else if (str_is_equal(attname, "semi_minor_axis"))                       gpp->b      = attflt[0];
                  else if (str_is_equal(attname, "inverse_flattening"))                    gpp->rf     = attflt[0];
                  else if (str_is_equal(attname, "longitudeOfFirstGridPointInDegrees"))    gpp->xval_0 = attflt[0];
                  else if (str_is_equal(attname, "healpix_nside"))                         gpp->nside  = (int) lround(attflt[0]);
          // clang-format on
        }
      }
    }
  }

  return status;
}

void
gridDefComplexPacking(int gridID, int lcomplex)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->lcomplex != lcomplex)
  {
    gridptr->lcomplex = (lcomplex != 0);
    gridMark4Update(gridID);
  }
}

int
gridInqComplexPacking(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  return (int) gridptr->lcomplex;
}

void
gridDefHasDims(int gridID, int hasdims)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  if (gridptr->hasdims != (hasdims != 0))
  {
    gridptr->hasdims = (hasdims != 0);
    gridMark4Update(gridID);
  }
}

int
gridInqHasDims(int gridID)
{
  grid_t *gridptr = grid_to_pointer(gridID);

  return (int) gridptr->hasdims;
}

/*
@Function  gridDefNumber
@Title     Define the reference number for an unstructured grid

@Prototype void gridDefNumber(int gridID, int number)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  number   Reference number for an unstructured grid.

@Description
The function @func{gridDefNumber} defines the reference number for an unstructured grid.

@EndFunction
*/
void
gridDefNumber(int gridID, int number)
{
  cdiDefKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDUSED, number);
}

/*
@Function  gridInqNumber
@Title     Get the reference number to an unstructured grid

@Prototype int gridInqNumber(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqNumber} returns the reference number to an unstructured grid.

@Result
@func{gridInqNumber} returns the reference number to an unstructured grid.
@EndFunction
*/
int
gridInqNumber(int gridID)
{
  int number = 0;
  cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDUSED, &number);
  return number;
}

/*
@Function  gridDefPosition
@Title     Define the position of grid in the reference file

@Prototype void gridDefPosition(int gridID, int position)
@Parameter
    @Item  gridID     Grid ID, from a previous call to @fref{gridCreate}.
    @Item  position   Position of grid in the reference file.

@Description
The function @func{gridDefPosition} defines the position of grid in the reference file.

@EndFunction
*/
void
gridDefPosition(int gridID, int position)
{
  cdiDefKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDINREFERENCE, position);
}

/*
@Function  gridInqPosition
@Title     Get the position of grid in the reference file

@Prototype int gridInqPosition(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqPosition} returns the position of grid in the reference file.

@Result
@func{gridInqPosition} returns the position of grid in the reference file.
@EndFunction
*/
int
gridInqPosition(int gridID)
{
  int position = 0;
  cdiInqKeyInt(gridID, CDI_GLOBAL, CDI_KEY_NUMBEROFGRIDINREFERENCE, &position);
  return position;
}

/*
@Function  gridDefReference
@Title     Define the reference URI for an unstructured grid

@Prototype void gridDefReference(int gridID, const char *reference)
@Parameter
    @Item  gridID      Grid ID, from a previous call to @fref{gridCreate}.
    @Item  reference   Reference URI for an unstructured grid.

@Description
The function @func{gridDefReference} defines the reference URI for an unstructured grid.

@EndFunction
*/
void
gridDefReference(int gridID, const char *reference)
{
  if (reference)
  {
    cdiDefKeyString(gridID, CDI_GLOBAL, CDI_KEY_REFERENCEURI, reference);
    gridMark4Update(gridID);
  }
}

/*
@Function  gridInqReference
@Title     Get the reference URI to an unstructured grid

@Prototype char *gridInqReference(int gridID, char *reference)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqReference} returns the reference URI to an unstructured grid.

@Result
@func{gridInqReference} returns the reference URI to an unstructured grid.
@EndFunction
*/
int
gridInqReference(int gridID, char *reference)
{
  int length = 0;
  if (CDI_NOERR == cdiInqKeyLen(gridID, CDI_GLOBAL, CDI_KEY_REFERENCEURI, &length))
  {
    if (reference) cdiInqKeyString(gridID, CDI_GLOBAL, CDI_KEY_REFERENCEURI, reference, &length);
  }

  return length;
}

/*
@Function  gridDefUUID
@Title     Define the UUID for an unstructured grid

@Prototype void gridDefUUID(int gridID, const char *uuid)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}.
    @Item  uuid     UUID for an unstructured grid.

@Description
The function @func{gridDefUUID} defines the UUID for an unstructured grid.

@EndFunction
*/
void
gridDefUUID(int gridID, const unsigned char uuid[CDI_UUID_SIZE])
{
  cdiDefKeyBytes(gridID, CDI_GLOBAL, CDI_KEY_UUID, uuid, CDI_UUID_SIZE);

  gridMark4Update(gridID);
}

/*
@Function  gridInqUUID
@Title     Get the UUID to an unstructured grid

@Prototype void gridInqUUID(int gridID, char *uuid)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridInqUUID} returns the UUID to an unstructured grid.

@Result
@func{gridInqUUID} returns the UUID to an unstructured grid to the parameter uuid.
@EndFunction
*/
void
gridInqUUID(int gridID, unsigned char uuid[CDI_UUID_SIZE])
{
  memset(uuid, 0, CDI_UUID_SIZE);
  int length = CDI_UUID_SIZE;
  cdiInqKeyBytes(gridID, CDI_GLOBAL, CDI_KEY_UUID, uuid, &length);
}

void
cdiGridGetIndexList(unsigned ngrids, int *gridIndexList)
{
  reshGetResHListOfType(ngrids, gridIndexList, &gridOps);
}

static int
gridTxCode(void *voidP)
{
  grid_t *gridptr = (grid_t *) voidP;
  return gridptr->vtable->txCode;
}

enum
{
  GRID_PACK_INT_IDX_SELF,
  GRID_PACK_INT_IDX_TYPE,
  GRID_PACK_INT_IDX_IS_CYCLIC,
  GRID_PACK_INT_IDX_X_FLAG,
  GRID_PACK_INT_IDX_Y_FLAG,
  GRID_PACK_INT_IDX_GME_ND,
  GRID_PACK_INT_IDX_GME_NI,
  GRID_PACK_INT_IDX_GME_NI2,
  GRID_PACK_INT_IDX_GME_NI3,
  GRID_PACK_INT_IDX_TRUNC,
  GRID_PACK_INT_IDX_NVERTEX,
  GRID_PACK_INT_IDX_REDUCED_POINTS_SIZE,
  GRID_PACK_INT_IDX_SIZE,
  GRID_PACK_INT_IDX_X_SIZE,
  GRID_PACK_INT_IDX_Y_SIZE,
  GRID_PACK_INT_IDX_LCOMPLEX,
  GRID_PACK_INT_IDX_MEMBERMASK,
  /*
  GRID_PACK_INT_IDX_XTSTDNNAME,
  GRID_PACK_INT_IDX_YTSTDNNAME,
  GRID_PACK_INT_IDX_ISCANSNEGATIVELY,
  GRID_PACK_INT_IDX_JSCANSPOSITIVELY,
  GRID_PACK_INT_IDX_JPOINTSARECONSECUTIVE,
  */
  gridNint
};

enum
{
  GRID_PACK_DBL_IDX_X_FIRST,
  GRID_PACK_DBL_IDX_Y_FIRST,
  GRID_PACK_DBL_IDX_X_LAST,
  GRID_PACK_DBL_IDX_Y_LAST,
  GRID_PACK_DBL_IDX_X_INC,
  GRID_PACK_DBL_IDX_Y_INC,
  gridNdouble
};

enum
{
  gridHasMaskFlag = 1 << 0,
  gridHasGMEMaskFlag = 1 << 1,
  gridHasXValsFlag = 1 << 2,
  gridHasYValsFlag = 1 << 3,
  gridHasAreaFlag = 1 << 4,
  gridHasXBoundsFlag = 1 << 5,
  gridHasYBoundsFlag = 1 << 6,
  gridHasReducedPointsFlag = 1 << 7,
};

static int
gridGetComponentFlags(const grid_t *gridP)
{
  int flags = 0;
  for (int prop = 0; prop < GRID_PROP_YBOUNDS + 1; ++prop)
    flags |= (gridP->vtable->inqPropPresence((grid_t *) gridP, (enum gridPropInq) prop) << prop);
  flags |= (gridHasReducedPointsFlag & (int) ((unsigned) (gridP->reducedPoints == NULL) - 1U));
  return flags;
}

static int
gridGetPackSize(void *voidP, void *context)
{
  grid_t *gridP = (grid_t *) voidP;
  return gridP->vtable->getPackSize(gridP, context);
}

static int gridGetPackSizeScalars(grid_t *gridP, void *context);
static int gridGetPackSizeArrays(grid_t *gridP, void *context);

static int
gridGetPackSizeBase(grid_t *gridP, void *context)
{
  return gridP->vtable->getPackSizeScalars(gridP, context) + gridP->vtable->getPackSizeArrays(gridP, context);
}

static int
gridGetPackSizeScalars(grid_t *gridP, void *context)
{
  int packBuffSize = 0, ui32PackSize = serializeGetSize(1, CDI_DATATYPE_UINT32, context);

  packBuffSize += serializeGetSize(gridNint, CDI_DATATYPE_INT, context) + ui32PackSize;
  packBuffSize += serializeGetSize(gridNdouble, CDI_DATATYPE_FLT64, context) + ui32PackSize;

  packBuffSize += serializeKeysGetPackSize(&gridP->keys, context);
  packBuffSize += serializeKeysGetPackSize(&gridP->x.keys, context);
  packBuffSize += serializeKeysGetPackSize(&gridP->y.keys, context);

  return packBuffSize;
}

static int
gridGetPackSizeArrays(grid_t *gridP, void *context)
{
  int packBuffSize = 0, ui32PackSize = serializeGetSize(1, CDI_DATATYPE_UINT32, context);

  if (gridP->reducedPoints)
  {
    xassert(gridP->reducedPointsSize);
    packBuffSize += serializeGetSize(gridP->reducedPointsSize, CDI_DATATYPE_INT, context) + ui32PackSize;
  }

  if (gridP->vtable->inqXValsPtr(gridP))
  {
    size_t count = grid_is_irregular(gridP->type) ? gridP->size : gridP->x.size;
    xassert(count && count <= INT_MAX);
    packBuffSize += serializeGetSize((int) count, CDI_DATATYPE_FLT64, context) + ui32PackSize;
  }

  if (gridP->vtable->inqYValsPtr(gridP))
  {
    size_t count = grid_is_irregular(gridP->type) ? gridP->size : gridP->y.size;
    xassert(count && count <= INT_MAX);
    packBuffSize += serializeGetSize((int) count, CDI_DATATYPE_FLT64, context) + ui32PackSize;
  }

  if (gridP->vtable->inqAreaPtr(gridP))
  {
    size_t count = gridP->size;
    xassert(count && count <= INT_MAX);
    packBuffSize += serializeGetSize((int) count, CDI_DATATYPE_FLT64, context) + ui32PackSize;
  }

  if (gridP->x.bounds)
  {
    xassert(gridP->nvertex);
    size_t count = (grid_is_irregular(gridP->type) ? gridP->size : gridP->x.size) * (size_t) gridP->nvertex;
    xassert(count && count <= INT_MAX);
    packBuffSize += serializeGetSize((int) count, CDI_DATATYPE_FLT64, context) + ui32PackSize;
  }

  if (gridP->y.bounds)
  {
    xassert(gridP->nvertex);
    size_t count = (grid_is_irregular(gridP->type) ? gridP->size : gridP->y.size) * (size_t) gridP->nvertex;
    xassert(count && count <= INT_MAX);
    packBuffSize += (serializeGetSize((int) count, CDI_DATATYPE_FLT64, context) + ui32PackSize);
  }

  if (gridP->mask)
  {
    size_t count = gridP->size;
    xassert(count && count <= INT_MAX);
    packBuffSize += serializeGetSize((int) count, CDI_DATATYPE_UCHAR, context) + ui32PackSize;
  }

  if (gridP->mask_gme)
  {
    size_t count = gridP->size;
    xassert(count && count <= INT_MAX);
    packBuffSize += serializeGetSize((int) count, CDI_DATATYPE_UCHAR, context) + ui32PackSize;
  }

  return packBuffSize;
}

static grid_t *gridUnpackScalars(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context,
                                 int force_id, int *memberMaskP);

static void gridUnpackArrays(grid_t *gridP, int memberMask, char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos,
                             int originNamespace, void *context);

int
gridUnpack(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context, int force_id)
{
  gridInit();
  int memberMask;
  grid_t *gridP
      = gridUnpackScalars(unpackBuffer, unpackBufferSize, unpackBufferPos, originNamespace, context, force_id, &memberMask);
  gridP->vtable->unpackArrays(gridP, memberMask, unpackBuffer, unpackBufferSize, unpackBufferPos, originNamespace, context);
  reshSetStatus(gridP->self, &gridOps, reshGetStatus(gridP->self, &gridOps) & ~RESH_SYNC_BIT);
  return gridP->self;
}

static grid_t *
gridUnpackScalars(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context, int force_id,
                  int *memberMaskP)
{
  grid_t *gridP;
  uint32_t d;
  int memberMask;
  {
    int intBuffer[gridNint];
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, intBuffer, gridNint, CDI_DATATYPE_INT, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);

    xassert(cdiCheckSum(CDI_DATATYPE_INT, gridNint, intBuffer) == d);
    int targetID = namespaceAdaptKey(intBuffer[0], originNamespace);
    gridP = gridNewEntry(force_id ? targetID : CDI_UNDEFID);

    xassert(!force_id || targetID == gridP->self);

    gridP->type = intBuffer[GRID_PACK_INT_IDX_TYPE];
    gridP->isCyclic = (signed char) intBuffer[GRID_PACK_INT_IDX_IS_CYCLIC];
    gridP->x.flag = (short) intBuffer[GRID_PACK_INT_IDX_X_FLAG];
    gridP->y.flag = (short) intBuffer[GRID_PACK_INT_IDX_Y_FLAG];
    gridP->gme.nd = intBuffer[GRID_PACK_INT_IDX_GME_ND];
    gridP->gme.ni = intBuffer[GRID_PACK_INT_IDX_GME_NI];
    gridP->gme.ni2 = intBuffer[GRID_PACK_INT_IDX_GME_NI2];
    gridP->gme.ni3 = intBuffer[GRID_PACK_INT_IDX_GME_NI3];
    gridP->trunc = intBuffer[GRID_PACK_INT_IDX_TRUNC];
    gridP->nvertex = intBuffer[GRID_PACK_INT_IDX_NVERTEX];
    gridP->reducedPointsSize = intBuffer[GRID_PACK_INT_IDX_REDUCED_POINTS_SIZE];
    /* FIXME: use int64_t for the following 3 */
    gridP->size = (size_t) intBuffer[GRID_PACK_INT_IDX_SIZE];
    gridP->x.size = (size_t) intBuffer[GRID_PACK_INT_IDX_X_SIZE];
    gridP->y.size = (size_t) intBuffer[GRID_PACK_INT_IDX_Y_SIZE];
    gridP->lcomplex = (bool) intBuffer[GRID_PACK_INT_IDX_LCOMPLEX];
    memberMask = intBuffer[GRID_PACK_INT_IDX_MEMBERMASK];
  }

  {
    double doubleBuffer[gridNdouble];
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, doubleBuffer, gridNdouble, CDI_DATATYPE_FLT64, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(d == cdiCheckSum(CDI_DATATYPE_FLT, gridNdouble, doubleBuffer));

    gridP->x.first = doubleBuffer[GRID_PACK_DBL_IDX_X_FIRST];
    gridP->y.first = doubleBuffer[GRID_PACK_DBL_IDX_Y_FIRST];
    gridP->x.last = doubleBuffer[GRID_PACK_DBL_IDX_X_LAST];
    gridP->y.last = doubleBuffer[GRID_PACK_DBL_IDX_Y_LAST];
    gridP->x.inc = doubleBuffer[GRID_PACK_DBL_IDX_X_INC];
    gridP->y.inc = doubleBuffer[GRID_PACK_DBL_IDX_Y_INC];
  }

  serializeKeysUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &gridP->keys, context);
  serializeKeysUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &gridP->x.keys, context);
  serializeKeysUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &gridP->y.keys, context);

  *memberMaskP = memberMask;
  return gridP;
}

static void
gridUnpackArrays(grid_t *gridP, int memberMask, char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace,
                 void *context)
{
  UNUSED(originNamespace);
  uint32_t d;

  if (memberMask & gridHasReducedPointsFlag)
  {
    xassert(gridP->reducedPointsSize);
    gridP->reducedPoints = (int *) Malloc((size_t) gridP->reducedPointsSize * sizeof(int));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->reducedPoints, gridP->reducedPointsSize,
                    CDI_DATATYPE_INT, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_INT, gridP->reducedPointsSize, gridP->reducedPoints) == d);
  }

  bool isIrregular = grid_is_irregular(gridP->type);
  if (memberMask & gridHasXValsFlag)
  {
    size_t size = isIrregular ? gridP->size : gridP->x.size;
    xassert(size <= INT_MAX);
    gridP->x.vals = (double *) Malloc(size * sizeof(double));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->x.vals, (int) size, CDI_DATATYPE_FLT64, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->x.vals) == d);
  }

  if (memberMask & gridHasYValsFlag)
  {
    size_t size = isIrregular ? gridP->size : gridP->y.size;
    xassert(size > 0 && size <= INT_MAX);
    gridP->y.vals = (double *) Malloc(size * sizeof(double));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->y.vals, (int) size, CDI_DATATYPE_FLT64, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->y.vals) == d);
  }

  if (memberMask & gridHasAreaFlag)
  {
    size_t size = gridP->size;
    xassert(size > 0 && size <= INT_MAX);
    gridP->area = (double *) Malloc(size * sizeof(double));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->area, (int) size, CDI_DATATYPE_FLT64, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->area) == d);
  }

  if (memberMask & gridHasXBoundsFlag)
  {
    size_t size = (size_t) gridP->nvertex * (isIrregular ? gridP->size : gridP->x.size);
    xassert(size > 0 && size <= INT_MAX);

    gridP->x.bounds = (double *) Malloc(size * sizeof(double));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->x.bounds, (int) size, CDI_DATATYPE_FLT64, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->x.bounds) == d);
  }

  if (memberMask & gridHasYBoundsFlag)
  {
    size_t size = (size_t) gridP->nvertex * (isIrregular ? gridP->size : gridP->y.size);
    xassert(size && size <= INT_MAX);
    gridP->y.bounds = (double *) Malloc(size * sizeof(double));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->y.bounds, (int) size, CDI_DATATYPE_FLT64, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->y.bounds) == d);
  }

  if (memberMask & gridHasMaskFlag)
  {
    size_t size = gridP->size;
    xassert(size && size <= INT_MAX);
    gridP->mask = (mask_t *) Malloc(size * sizeof(mask_t));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->mask, (int) size, CDI_DATATYPE_UCHAR, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_UCHAR, (int) size, gridP->mask) == d);
  }

  if (memberMask & gridHasGMEMaskFlag)
  {
    size_t size = gridP->size;
    xassert(size && size <= INT_MAX);
    gridP->mask_gme = (mask_t *) Malloc(size * sizeof(mask_t));
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, gridP->mask_gme, (int) size, CDI_DATATYPE_UCHAR, context);
    serializeUnpack(unpackBuffer, unpackBufferSize, unpackBufferPos, &d, 1, CDI_DATATYPE_UINT32, context);
    xassert(cdiCheckSum(CDI_DATATYPE_UCHAR, (int) size, gridP->mask_gme) == d);
  }
}

void
gridPack(void *voidP, void *packBuffer, int packBufferSize, int *packBufferPos, void *context)
{
  grid_t *gridP = (grid_t *) voidP;
  gridP->vtable->pack(gridP, packBuffer, packBufferSize, packBufferPos, context);
}

static void
gridPackBase(grid_t *gridP, void *packBuffer, int packBufferSize, int *packBufferPos, void *context)
{
  int memberMask = gridP->vtable->packScalars(gridP, packBuffer, packBufferSize, packBufferPos, context);
  gridP->vtable->packArrays(gridP, memberMask, packBuffer, packBufferSize, packBufferPos, context);
}

static int
gridPackScalars(grid_t *gridP, void *packBuffer, int packBufferSize, int *packBufferPos, void *context)
{
  uint32_t d;
  int memberMask;

  {
    int intBuffer[gridNint];

    intBuffer[GRID_PACK_INT_IDX_SELF] = gridP->self;
    intBuffer[GRID_PACK_INT_IDX_TYPE] = gridP->type;
    intBuffer[GRID_PACK_INT_IDX_IS_CYCLIC] = gridP->isCyclic;
    intBuffer[GRID_PACK_INT_IDX_X_FLAG] = gridP->x.flag;
    intBuffer[GRID_PACK_INT_IDX_Y_FLAG] = gridP->y.flag;
    intBuffer[GRID_PACK_INT_IDX_GME_ND] = gridP->gme.nd;
    intBuffer[GRID_PACK_INT_IDX_GME_NI] = gridP->gme.ni;
    intBuffer[GRID_PACK_INT_IDX_GME_NI2] = gridP->gme.ni2;
    intBuffer[GRID_PACK_INT_IDX_GME_NI3] = gridP->gme.ni3;
    intBuffer[GRID_PACK_INT_IDX_TRUNC] = gridP->trunc;
    intBuffer[GRID_PACK_INT_IDX_NVERTEX] = gridP->nvertex;
    intBuffer[GRID_PACK_INT_IDX_REDUCED_POINTS_SIZE] = gridP->reducedPointsSize;
    xassert(gridP->size <= INT_MAX && gridP->x.size <= INT_MAX && gridP->y.size <= INT_MAX);
    intBuffer[GRID_PACK_INT_IDX_SIZE] = (int) gridP->size;
    intBuffer[GRID_PACK_INT_IDX_X_SIZE] = (int) gridP->x.size;
    intBuffer[GRID_PACK_INT_IDX_Y_SIZE] = (int) gridP->y.size;
    intBuffer[GRID_PACK_INT_IDX_LCOMPLEX] = gridP->lcomplex;
    intBuffer[GRID_PACK_INT_IDX_MEMBERMASK] = memberMask = gridGetComponentFlags(gridP);

    serializePack(intBuffer, gridNint, CDI_DATATYPE_INT, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_INT, gridNint, intBuffer);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  {
    double doubleBuffer[gridNdouble];

    doubleBuffer[GRID_PACK_DBL_IDX_X_FIRST] = gridP->x.first;
    doubleBuffer[GRID_PACK_DBL_IDX_Y_FIRST] = gridP->y.first;
    doubleBuffer[GRID_PACK_DBL_IDX_X_LAST] = gridP->x.last;
    doubleBuffer[GRID_PACK_DBL_IDX_Y_LAST] = gridP->y.last;
    doubleBuffer[GRID_PACK_DBL_IDX_X_INC] = gridP->x.inc;
    doubleBuffer[GRID_PACK_DBL_IDX_Y_INC] = gridP->y.inc;

    serializePack(doubleBuffer, gridNdouble, CDI_DATATYPE_FLT64, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_FLT, gridNdouble, doubleBuffer);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  serializeKeysPack(&gridP->keys, packBuffer, packBufferSize, packBufferPos, context);
  serializeKeysPack(&gridP->x.keys, packBuffer, packBufferSize, packBufferPos, context);
  serializeKeysPack(&gridP->y.keys, packBuffer, packBufferSize, packBufferPos, context);

  return memberMask;
}

static void
gridPackArrays(grid_t *gridP, int memberMask, void *packBuffer, int packBufferSize, int *packBufferPos, void *context)
{
  uint32_t d;
  bool isIrregular = grid_is_irregular(gridP->type);

  if (memberMask & gridHasReducedPointsFlag)
  {
    size_t size = (size_t) gridP->reducedPointsSize;
    xassert(size > 0 && size <= INT_MAX);
    serializePack(gridP->reducedPoints, (int) size, CDI_DATATYPE_INT, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_INT, (int) size, gridP->reducedPoints);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasXValsFlag)
  {
    size_t size = isIrregular ? gridP->size : gridP->x.size;
    xassert(size && size <= INT_MAX);

    const double *gridP_xvals = gridP->vtable->inqXValsPtr(gridP);
    serializePack(gridP_xvals, (int) size, CDI_DATATYPE_FLT64, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP_xvals);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasYValsFlag)
  {
    size_t size = isIrregular ? gridP->size : gridP->y.size;
    xassert(size && size <= INT_MAX);
    const double *gridP_yvals = gridP->vtable->inqYValsPtr(gridP);
    serializePack(gridP_yvals, (int) size, CDI_DATATYPE_FLT64, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP_yvals);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasAreaFlag)
  {
    size_t size = gridP->size;
    xassert(size && size <= INT_MAX);
    serializePack(gridP->area, (int) size, CDI_DATATYPE_FLT64, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->area);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasXBoundsFlag)
  {
    size_t size = (isIrregular ? gridP->size : gridP->x.size) * (size_t) gridP->nvertex;
    xassert(size && size <= INT_MAX);
    serializePack(gridP->x.bounds, (int) size, CDI_DATATYPE_FLT64, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->x.bounds);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasYBoundsFlag)
  {
    size_t size = (isIrregular ? gridP->size : gridP->y.size) * (size_t) gridP->nvertex;
    xassert(size && size <= INT_MAX);
    serializePack(gridP->y.bounds, (int) size, CDI_DATATYPE_FLT64, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_FLT, (int) size, gridP->y.bounds);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasMaskFlag)
  {
    size_t size = gridP->size;
    xassert(size && size <= INT_MAX);
    serializePack(gridP->mask, (int) size, CDI_DATATYPE_UCHAR, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_UCHAR, (int) size, gridP->mask);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }

  if (memberMask & gridHasGMEMaskFlag)
  {
    size_t size = gridP->size;
    xassert(size && size <= INT_MAX);
    serializePack(gridP->mask_gme, (int) size, CDI_DATATYPE_UCHAR, packBuffer, packBufferSize, packBufferPos, context);
    d = cdiCheckSum(CDI_DATATYPE_UCHAR, (int) size, gridP->mask_gme);
    serializePack(&d, 1, CDI_DATATYPE_UINT32, packBuffer, packBufferSize, packBufferPos, context);
  }
}

struct gridCompareSearchState
{
  int resIDValue;
  const grid_t *queryKey;
};

static enum cdiApplyRet
gridCompareSearch(int id, void *res, void *data)
{
  struct gridCompareSearchState *state = (struct gridCompareSearchState *) data;
  (void) res;
  if (gridCompare(id, state->queryKey, true) == false)
  {
    state->resIDValue = id;
    return CDI_APPLY_STOP;
  }
  else
    return CDI_APPLY_GO_ON;
}

// Add grid (which must be Malloc'ed to vlist if not already found)
struct addIfNewRes
cdiVlistAddGridIfNew(int vlistID, grid_t *grid, int mode)
{
  /*
    mode: 0 search in vlist and grid table
          1 search in grid table only
          2 search in grid table only and don't store the grid in vlist
   */
  bool gridIsDefinedGlobal = false;
  bool gridIsDefined = false;
  int gridID = CDI_UNDEFID;
  vlist_t *vlistptr = vlist_to_pointer(vlistID);

  int ngrids = vlistptr->ngrids;

  if (mode == 0)
    for (int index = 0; index < ngrids; index++)
    {
      if ((gridID = vlistptr->gridIDs[index]) != CDI_UNDEFID)
      {
        if (gridCompare(gridID, grid, false) == false)
        {
          gridIsDefined = true;
          break;
        }
      }
      else
        Error("Internal problem: undefined gridID in vlist %d, position %u!", vlistID, index);
    }

  if (!gridIsDefined)
  {
    struct gridCompareSearchState query;
    query.queryKey = grid;  // = { .queryKey = grid };
    if ((gridIsDefinedGlobal = (cdiGridApply(gridCompareSearch, &query) == CDI_APPLY_STOP))) gridID = query.resIDValue;

    if (mode == 1 && gridIsDefinedGlobal)
      for (int index = 0; index < ngrids; index++)
        if (vlistptr->gridIDs[index] == gridID)
        {
          gridIsDefinedGlobal = false;
          break;
        }
  }

  if (!gridIsDefined)
  {
    if (!gridIsDefinedGlobal)
    {
      grid->self = gridID = reshPut(grid, &gridOps);
      grid_complete(grid);
    }
    if (mode < 2)
    {
      if (ngrids >= MAX_GRIDS_PS) Error("Internal limit exceeded, MAX_GRIDS_PS=%d needs to be increased!", MAX_GRIDS_PS);
      vlistptr->gridIDs[ngrids] = gridID;
      vlistptr->ngrids++;
    }
  }

  return (struct addIfNewRes){ .Id = gridID, .isNew = (!gridIsDefined && !gridIsDefinedGlobal) };
}

const struct gridVirtTable cdiGridVtable = {
  .destroy = gridDestroyKernel,
  .copy = grid_copy_base,
  .copyScalarFields = grid_copy_base_scalar_fields,
  .copyArrayFields = grid_copy_base_array_fields,
  .defIndices = gridDefIndicesSerial,
  .inqIndices = gridInqIndicesSerial,
  .inqIndicesPtr = gridInqIndicesPtrSerial,
  .defXVals = gridDefXValsSerial,
  .defYVals = gridDefYValsSerial,
  .defMask = gridDefMaskSerial,
  .defMaskGME = gridDefMaskGMESerial,
  .defXBounds = gridDefXBoundsSerial,
  .defYBounds = gridDefYBoundsSerial,
  .defArea = gridDefAreaSerial,
  .inqXVal = gridInqXValSerial,
  .inqYVal = gridInqYValSerial,
  .inqXVals = gridInqXValsSerial,
  .inqXValsPart = gridInqXValsPartSerial,
  .inqYVals = gridInqYValsSerial,
  .inqYValsPart = gridInqYValsPartSerial,
  .inqXValsPtr = gridInqXValsPtrSerial,
  .inqYValsPtr = gridInqYValsPtrSerial,
#ifndef USE_MPI
  .inqXIsc = gridInqXIscSerial,
  .inqYIsc = gridInqYIscSerial,
  .inqXCvals = gridInqXCvalsSerial,
  .inqYCvals = gridInqYCvalsSerial,
  .inqXCvalsPtr = gridInqXCvalsPtrSerial,
  .inqYCvalsPtr = gridInqYCvalsPtrSerial,
#endif
  .inqXInc = gridInqXIncBase,
  .inqYInc = gridInqYIncBase,
  .compareXYFull = compareXYvals,
  .compareXYAO = compareXYvals2,
  .inqArea = gridInqAreaSerial,
  .inqAreaPtr = gridInqAreaPtrBase,
  .inqPropPresence = gridInqPropPresenceBase,
  .inqMask = gridInqMaskSerial,
  .inqMaskGME = gridInqMaskGMESerial,
  .inqXBounds = gridInqXBoundsSerial,
  .inqYBounds = gridInqYBoundsSerial,
  .inqXBoundsPtr = gridInqXBoundsPtrSerial,
  .inqYBoundsPtr = gridInqYBoundsPtrSerial,
  .txCode = GRID,
  .getPackSize = gridGetPackSizeBase,
  .getPackSizeScalars = gridGetPackSizeScalars,
  .getPackSizeArrays = gridGetPackSizeArrays,
  .unpackScalars = gridUnpackScalars,
  .unpackArrays = gridUnpackArrays,
  .pack = gridPackBase,
  .packScalars = gridPackScalars,
  .packArrays = gridPackArrays,
};

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <stdio.h>
#include <string.h>
#include <ctype.h>


static int initIegLib = 0;
static int iegDefaultDprec = 0;

// A version string.
#undef LIBVERSION
#define LIBVERSION 2.0.0
#define XSTRING(x) #x
#define STRING(x) XSTRING(x)
static const char ieg_libvers[] = STRING(LIBVERSION);

const char *
iegLibraryVersion(void)
{
  return ieg_libvers;
}

static int IEG_Debug = 0;  // If set to 1, debugging

static void
iegLibInit(void)
{
  const char *envName = "IEG_PRECISION";

  char *envString = getenv(envName);
  if (envString)
  {
    int nrun = (strlen(envString) == 2) ? 1 : 2;
    int pos = 0;
    while (nrun--)
    {
      switch (tolower((int) envString[pos]))
      {
        case 'r':
        {
          switch ((int) envString[pos + 1])
          {
            case '4': iegDefaultDprec = EXSE_PREC_FP32; break;
            case '8': iegDefaultDprec = EXSE_PREC_FP64; break;
            default: Warning("Invalid digit in %s: %s", envName, envString);
          }
          break;
        }
        default:
        {
          Warning("Invalid character in %s: %s", envName, envString);
          break;
        }
      }
      pos += 2;
    }
  }

  initIegLib = 1;
}

void
iegDebug(int debug)
{
  if (debug) Message("debug level %d", debug);
  IEG_Debug = debug;
}

static void
iegInit(iegrec_t *iegp)
{
  iegp->checked = 0;
  iegp->byteswap = 0;
  iegp->dprec = 0;
  iegp->refval = 0;
  iegp->datasize = 0;
  iegp->buffersize = 0;
  iegp->buffer = NULL;
}

void
iegInitMem(void *ieg)
{
  iegrec_t *iegp = (iegrec_t *) ieg;
  memset(iegp->ipdb, 0, sizeof(iegp->ipdb));
  memset(iegp->igdb, 0, sizeof(iegp->igdb));
  memset(iegp->vct, 0, sizeof(iegp->vct));
}

void *
iegNew(void)
{
  if (!initIegLib) iegLibInit();

  iegrec_t *iegp = (iegrec_t *) Malloc(sizeof(iegrec_t));
  iegInit(iegp);
  iegInitMem(iegp);

  return (void *) iegp;
}

void
iegDelete(void *ieg)
{
  iegrec_t *iegp = (iegrec_t *) ieg;

  if (iegp)
  {
    if (iegp->buffer) Free(iegp->buffer);
    Free(iegp);
  }
}

int
iegCheckFiletype(int fileID, int *swap)
{
  size_t data = 0;
  size_t dimx = 0, dimy = 0;
  size_t fact = 0;
  unsigned char buffer[1048], *pbuf;

  if (fileRead(fileID, buffer, 4) != 4) return 0;

  size_t blocklen = get_uint32(buffer);
  size_t sblocklen = get_swap_uint32(buffer);

  if (IEG_Debug) Message("blocklen = %d sblocklen = %d", blocklen, sblocklen);

  // clang-format off
  if (blocklen == 636 || blocklen == 640)
    {
     *swap = 0;
      fact = 4;
      if (fileRead(fileID, buffer, blocklen+8) != blocklen+8) return 0;
      pbuf = buffer+(37+4)*4;    dimx = (size_t) get_uint32(pbuf);
      pbuf = buffer+(37+5)*4;    dimy = (size_t) get_uint32(pbuf);
      pbuf = buffer+blocklen+4;  data = (size_t) get_uint32(pbuf);
    }
  else if (blocklen == 1040 || blocklen == 1036)
    {
     *swap = 0;
      fact = 8;
      if (fileRead(fileID, buffer, blocklen+8) != blocklen+8) return 0;
      pbuf = buffer+(37+4)*4;    dimx = (size_t) get_uint32(pbuf);
      pbuf = buffer+(37+5)*4;    dimy = (size_t) get_uint32(pbuf);
      pbuf = buffer+blocklen+4;  data = (size_t) get_uint32(pbuf);
    }
  else if (sblocklen == 636 || sblocklen == 640)
    {
     *swap = 1;
      fact = 4;
      if (fileRead(fileID, buffer, sblocklen+8) != sblocklen+8) return 0;
      pbuf = buffer+(37+4)*4;     dimx = (size_t) get_swap_uint32(pbuf);
      pbuf = buffer+(37+5)*4;     dimy = (size_t) get_swap_uint32(pbuf);
      pbuf = buffer+sblocklen+4;  data = (size_t) get_swap_uint32(pbuf);
    }
  else if (sblocklen == 1040 || sblocklen == 1036)
    {
     *swap = 1;
      fact = 8;
      if (fileRead(fileID, buffer, sblocklen+8) != sblocklen+8) return 0;
      pbuf = buffer+(37+4)*4;     dimx = (size_t) get_swap_uint32(pbuf);
      pbuf = buffer+(37+5)*4;     dimy = (size_t) get_swap_uint32(pbuf);
      pbuf = buffer+sblocklen+4;  data = (size_t) get_swap_uint32(pbuf);
    }
  // clang-format on

  fileRewind(fileID);

  if (IEG_Debug) Message("swap = %d fact = %d", *swap, fact);
  if (IEG_Debug) Message("dimx = %lu dimy = %lu data = %lu", dimx, dimy, data);

  int found = data && (dimx * dimy * fact == data || dimx * dimy * 8 == data);
  return found;
}

void
iegCopyMeta(void *dieg, void *sieg)
{
  iegrec_t *diegp = (iegrec_t *) dieg;
  iegrec_t *siegp = (iegrec_t *) sieg;

  // diegp->byteswap = siegp->byteswap;
  diegp->dprec = siegp->dprec;
  diegp->refval = siegp->refval;

  memcpy(diegp->ipdb, siegp->ipdb, sizeof(siegp->ipdb));
  memcpy(diegp->igdb, siegp->igdb, sizeof(siegp->igdb));
  memcpy(diegp->vct, siegp->vct, sizeof(siegp->vct));
}

static int
iegInqData(void *ieg, int prec, void *data)
{
  iegrec_t *iegp = (iegrec_t *) ieg;
  int ierr = 0;
  int byteswap = iegp->byteswap;
  size_t datasize = iegp->datasize;
  void *buffer = iegp->buffer;
  int dprec = iegp->dprec;

  switch (dprec)
  {
    case EXSE_PREC_FP32:
    {
      if (byteswap) swap4byte(buffer, datasize);

      if (dprec == prec)
        memcpy(data, buffer, datasize * sizeof(float));
      else
      {
        const float *restrict p = (float *) buffer;
        double *restrict q = (double *) data;
        for (size_t i = 0; i < datasize; i++) q[i] = p[i];
      }

      break;
    }
    case EXSE_PREC_FP64:
    {
      if (byteswap) swap8byte(buffer, datasize);

      if (dprec == prec)
        memcpy(data, buffer, datasize * sizeof(double));
      else
      {
        const double *restrict p = (double *) buffer;
        float *restrict q = (float *) data;
        for (size_t i = 0; i < datasize; i++) q[i] = (float) p[i];
      }

      break;
    }
    default:
    {
      Error("unexpected data precision %d", dprec);
      break;
    }
  }

  return ierr;
}

int
iegInqDataFP32(void *ieg, float *data)
{
  return iegInqData(ieg, EXSE_PREC_FP32, (void *) data);
}

int
iegInqDataFP64(void *ieg, double *data)
{
  return iegInqData(ieg, EXSE_PREC_FP64, (void *) data);
}

static int
iegDefData(iegrec_t *iegp, int prec, const void *data)
{
  int dprec = iegDefaultDprec ? iegDefaultDprec : iegp->dprec;
  iegp->dprec = dprec ? dprec : prec;

  size_t datasize = (size_t) IEG_G_NumLon(iegp->igdb) * (size_t) IEG_G_NumLat(iegp->igdb);
  size_t blocklen = datasize * (size_t) dprec;

  iegp->datasize = datasize;

  if (iegp->buffersize != blocklen)
  {
    iegp->buffersize = blocklen;
    iegp->buffer = Realloc(iegp->buffer, iegp->buffersize);
  }

  switch (dprec)
  {
    case EXSE_PREC_FP32:
    {
      if (dprec == prec)
        memcpy(iegp->buffer, data, datasize * sizeof(float));
      else
      {
        const double *restrict p = (const double *) data;
        float *restrict q = (float *) iegp->buffer;
        for (size_t i = 0; i < datasize; i++) q[i] = (float) p[i];
      }
      break;
    }
    case EXSE_PREC_FP64:
    {
      if (dprec == prec)
        memcpy(iegp->buffer, data, datasize * sizeof(double));
      else
      {
        const float *restrict p = (const float *) data;
        double *restrict q = (double *) iegp->buffer;
        for (size_t i = 0; i < datasize; i++) q[i] = p[i];
      }
      break;
    }
    default:
    {
      Error("unexpected data precision %d", dprec);
      break;
    }
  }

  return 0;
}

int
iegDefDataFP32(void *ieg, const float *data)
{
  return iegDefData((iegrec_t *) ieg, EXSE_PREC_FP32, (void *) data);
}

int
iegDefDataFP64(void *ieg, const double *data)
{
  return iegDefData((iegrec_t *) ieg, EXSE_PREC_FP64, (void *) data);
}

int
iegRead(int fileID, void *ieg)
{
  iegrec_t *iegp = (iegrec_t *) ieg;
  union
  {
    double d[200];
    float f[200];
    int32_t i32[200];
  } buf;

  if (!iegp->checked)
  {
    int status = iegCheckFiletype(fileID, &iegp->byteswap);
    if (status == 0) Error("Not a IEG file!");
    iegp->checked = 1;
  }

  int byteswap = iegp->byteswap;

  // read header record
  size_t blocklen = binReadF77Block(fileID, byteswap);

  if (fileEOF(fileID)) return -1;

  if (IEG_Debug) Message("blocklen = %lu", blocklen);

  int dprec = 0;
  if (blocklen == 636 || blocklen == 640)
    dprec = 4;
  else if (blocklen == 1040 || blocklen == 1036)
    dprec = 8;
  else
  {
    Warning("unexpecteted header size %d!", (int) blocklen);
    return -1;
  }

  iegp->dprec = dprec;

  binReadInt32(fileID, byteswap, 37, buf.i32);
  for (int i = 0; i < 37; i++) iegp->ipdb[i] = (int) buf.i32[i];

  binReadInt32(fileID, byteswap, 18, buf.i32);
  for (int i = 0; i < 18; i++) iegp->igdb[i] = (int) buf.i32[i];

  if (blocklen == 636 || blocklen == 1036)
  {
    fileRead(fileID, buf.f, 4);
    if (byteswap) swap4byte(buf.f, 1);
    iegp->refval = (double) buf.f[0];
  }
  else
  {
    fileRead(fileID, buf.d, 8);
    if (byteswap) swap8byte(buf.d, 1);
    iegp->refval = (double) buf.d[0];
  }

  binReadInt32(fileID, byteswap, 3, buf.i32);
  for (int i = 0; i < 3; i++) iegp->igdb[18 + i] = (int) buf.i32[i];

  if (dprec == EXSE_PREC_FP32)
  {
    fileRead(fileID, buf.f, 400);
    if (byteswap) swap4byte(buf.f, 100);
    for (int i = 0; i < 100; i++) iegp->vct[i] = (double) buf.f[i];
  }
  else
  {
    fileRead(fileID, buf.d, 800);
    if (byteswap) swap8byte(buf.d, 100);
    for (int i = 0; i < 100; i++) iegp->vct[i] = buf.d[i];
  }

  size_t blocklen2 = binReadF77Block(fileID, byteswap);

  if (blocklen2 != blocklen)
  {
    Warning("header blocklen differ!");
    return -1;
  }

  iegp->datasize = (size_t) IEG_G_NumLon(iegp->igdb) * (size_t) IEG_G_NumLat(iegp->igdb);

  if (IEG_Debug) Message("datasize = %zu", iegp->datasize);

  blocklen = binReadF77Block(fileID, byteswap);

  if (iegp->buffersize < blocklen)
  {
    iegp->buffer = Realloc(iegp->buffer, blocklen);
    iegp->buffersize = blocklen;
  }

  if (dprec != (int) (blocklen / iegp->datasize))
  {
    Warning("data precision differ! (h = %d; d = %d)", (int) dprec, (int) (blocklen / iegp->datasize));
    return -1;
  }

  fileRead(fileID, iegp->buffer, blocklen);

  blocklen2 = binReadF77Block(fileID, byteswap);

  if (blocklen2 != blocklen)
  {
    Warning("data blocklen differ!");
    return -1;
  }

  return 0;
}

int
iegWrite(int fileID, void *ieg)
{
  iegrec_t *iegp = (iegrec_t *) ieg;
  union
  {
    int32_t i32[200];
    float fvct[100];
  } buf;
  int dprec = iegp->dprec;
  int byteswap = iegp->byteswap;

  // write header record
  size_t blocklen = (dprec == EXSE_PREC_FP32) ? 636 : 1040;

  binWriteF77Block(fileID, byteswap, blocklen);

  for (int i = 0; i < 37; i++) buf.i32[i] = (int32_t) iegp->ipdb[i];
  binWriteInt32(fileID, byteswap, 37, buf.i32);

  for (int i = 0; i < 18; i++) buf.i32[i] = (int32_t) iegp->igdb[i];
  binWriteInt32(fileID, byteswap, 18, buf.i32);

  double refval = (double) iegp->refval;
  float refvalf = (float) iegp->refval;
  if (dprec == EXSE_PREC_FP32)
    binWriteFlt32(fileID, byteswap, 1, &refvalf);
  else
    binWriteFlt64(fileID, byteswap, 1, &refval);

  for (int i = 0; i < 3; i++) buf.i32[i] = (int32_t) iegp->igdb[18 + i];
  binWriteInt32(fileID, byteswap, 3, buf.i32);

  if (dprec == EXSE_PREC_FP32)
  {
    for (int i = 0; i < 100; i++) buf.fvct[i] = (float) iegp->vct[i];
    binWriteFlt32(fileID, byteswap, 100, buf.fvct);
  }
  else { binWriteFlt64(fileID, byteswap, 100, iegp->vct); }

  binWriteF77Block(fileID, byteswap, blocklen);

  iegp->datasize = (size_t) iegp->igdb[4] * (size_t) iegp->igdb[5];
  blocklen = iegp->datasize * (size_t) dprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  switch (dprec)
  {
    case EXSE_PREC_FP32:
    {
      binWriteFlt32(fileID, byteswap, iegp->datasize, (float *) iegp->buffer);
      break;
    }
    case EXSE_PREC_FP64:
    {
      binWriteFlt64(fileID, byteswap, iegp->datasize, (double *) iegp->buffer);
      break;
    }
    default:
    {
      Error("unexpected data precision %d", dprec);
      break;
    }
  }

  binWriteF77Block(fileID, byteswap, blocklen);

  return 0;
}
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef INCLUDE_GUARD_CDI_REFERENCE_COUNTING
#define INCLUDE_GUARD_CDI_REFERENCE_COUNTING


#include <sys/types.h>
#include <stdlib.h>

/*
This is a base class for all objects that need reference counting.
A CdiReferencedObject has a reference count of one when it is constructed, refObjectRetain() increments the reference count,
refObject Release() decrements it. When the reference count reaches zero, the destructor function is called before the memory of the
object is deallocated with Free().

>>> Warning <<<
This code is currently not thread-safe.

We are currently using the C99 standard, which does not have atomic types.
Also, there are still tons of systems out there that have a gcc without wrong C11 atomics support
(__STDC_NO_ATOMICS__ not defined even though stdatomics.h is not even present).
Consequently, it is impossible to write preprocessor code to even check for the presence of atomic types.
So, we have two options: provide multithreading support by means of locks, or wait a year or two before doing this right.
I, for one, prefer doing things right.
*/
typedef struct CdiReferencedObject CdiReferencedObject;
struct CdiReferencedObject
{
  // protected:
  void (*destructor)(CdiReferencedObject *me);  // Subclass constructors should set this to their own destructor.

  // private:    //Subclasses may read it to determine whether there is only one reference, though.
  size_t refCount;
};

void cdiRefObject_construct(CdiReferencedObject *me);
void cdiRefObject_retain(CdiReferencedObject *me);
void cdiRefObject_release(CdiReferencedObject *me);
void cdiRefObject_destruct(CdiReferencedObject *me);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef INCLUDE_GUARD_CDI_GRIB_FILE_H
#define INCLUDE_GUARD_CDI_GRIB_FILE_H


/*
CdiInputFile is a file abstraction that allows accessing an input file through any number of channels:
It is reference counted, so that it is closed at the right place,
and it is stateless, so that accesses from different callers cannot interfere with each other.
Once the reference counting code is threadsafe, CdiInputFile will also be threadsafe.
*/
typedef struct CdiInputFile
{
  // public:
  CdiReferencedObject super;

  // private:
  char *path;
  int fileDescriptor;
} CdiInputFile;

// Final class, the constructor is private and not defined here.
CdiInputFile *
cdiInputFile_make(const char *path);  // The caller is responsible to call cdiRefObject_release() on the returned object.
int cdiInputFile_read(const CdiInputFile *me, off_t readPosition, size_t readSize, size_t *outActualReadSize,
                      void *buffer);  // Returns one of CDI_EINVAL, CDI_ESYSTEM, CDI_EEOF, OR CDI_NOERR.
/* Returns path string, don't use after destruction of CdiInputFile
 * object */
const char *cdiInputFile_getPath(const CdiInputFile *me);
// Destructor is private as well.

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#define _XOPEN_SOURCE 600


#include <errno.h>
#include <fcntl.h>
#include <string.h>

// On Windows, define ssize_t and pread manually
#ifdef _WIN32
#define ssize_t __int64
#define pread read
#include <io.h>
#else
#include <unistd.h>
#endif

#if HAVE_LIBPTHREAD
#include <pthread.h>
#endif

static void cdiInputFile_destruct(CdiInputFile *me);

// For an explanation of the condestruct() pattern, see the comment in iterator_grib.c
// path != NULL -> construction
// path = NULL -> destruction
static CdiInputFile *
cdiInputFile_condestruct(CdiInputFile *me, const char *path)
{
#define super() (&me->super)
  if (!path) goto destruct;
  cdiRefObject_construct(super());
  me->path = strdup(path);
  if (!me->path) goto destructSuper;
  do {
    me->fileDescriptor = open(me->path, O_RDONLY);
  } while (me->fileDescriptor == -1 && (errno == EINTR || errno == EAGAIN));
  if (me->fileDescriptor == -1) goto freePath;
  // construction successfull, now we can set our own destructor
  super()->destructor = (void (*)(CdiReferencedObject *)) cdiInputFile_destruct;
  goto success;

  // ^        constructor code       ^
  // |                               |
  // v destructor/error-cleanup code v

destruct:
  close(me->fileDescriptor);
freePath:
  Free(me->path);
destructSuper:
  cdiRefObject_destruct(super());
  me = NULL;

success:
  return me;
#undef super
}

static CdiInputFile **openFileList = NULL;
static size_t openFileCount = 0, openFileListSize = 0;
#if HAVE_LIBPTHREAD
static pthread_mutex_t openFileListLock = PTHREAD_MUTEX_INITIALIZER;
#endif

// This either returns a new object, or retains and returns a preexisting open file.
CdiInputFile *
cdiInputFile_make(const char *path)
{
  CdiInputFile *result = NULL;
  xassert(path);
#if HAVE_LIBPTHREAD
  int error = pthread_mutex_lock(&openFileListLock);
  xassert(!error);
#endif
  {
    // Check the list of open files for the given path.
    for (size_t i = openFileCount; i-- && !result;)
    {
      if (!strcmp(path, openFileList[i]->path)) result = openFileList[i];
    }
    // If no open file was found, we open one, otherwise we just retain the existing one one more time.
    if (result) { cdiRefObject_retain(&result->super); }
    else
    {
      result = (CdiInputFile *) Malloc(sizeof(*result));
      if (!cdiInputFile_condestruct(result, path))
      {
        // An error occured during construction, avoid a memory leak.
        Free(result);
        result = NULL;
      }
      else
      {
        // Add the new file to the list of open files.
        if (openFileCount == openFileListSize)
        {
          openFileListSize *= 2;
          if (openFileListSize < 16) openFileListSize = 16;
          openFileList = (CdiInputFile **) Realloc(openFileList, openFileListSize);
        }
        xassert(openFileCount < openFileListSize);
        openFileList[openFileCount++] = result;
      }
    }
  }
#if HAVE_LIBPTHREAD
  error = pthread_mutex_unlock(&openFileListLock);
  xassert(!error);
#endif
  return result;
}

int
cdiInputFile_read(const CdiInputFile *me, off_t readPosition, size_t readSize, size_t *outActualReadSize, void *buffer)
{
  char *byteBuffer = (char *) buffer;
  size_t trash;
  if (!outActualReadSize) outActualReadSize = &trash;
  *outActualReadSize = 0;
  while (readSize)
  {
    ssize_t bytesRead = pread(me->fileDescriptor, byteBuffer, readSize, readPosition);
    if (bytesRead == -1) return (errno == EINVAL) ? CDI_EINVAL : CDI_ESYSTEM;
    if (bytesRead == 0) return CDI_EEOF;
    byteBuffer += bytesRead;
    readPosition += bytesRead;
    readSize -= (size_t) bytesRead;
    *outActualReadSize += (size_t) bytesRead;
  }
  return CDI_NOERR;
}

const char *
cdiInputFile_getPath(const CdiInputFile *me)
{
  return me->path;
}

void
cdiInputFile_destruct(CdiInputFile *me)
{
#if HAVE_LIBPTHREAD
  int error = pthread_mutex_lock(&openFileListLock);
  xassert(!error);
#endif
  {
    // Find the position of me in the list of open files.
    ssize_t position = (ssize_t) openFileCount;
    while (position > 0 && openFileList[--position] != me)
      ;
    // Remove me from the list
    openFileList[position] = openFileList[--openFileCount];
  }
#if HAVE_LIBPTHREAD
  error = pthread_mutex_unlock(&openFileListLock);
  xassert(!error);
#endif
  cdiInputFile_condestruct(me, NULL);
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef INSTITUTION_H
#define INSTITUTION_H

int instituteUnpack(void *buf, int size, int *position, int originNamespace, void *context, int force_id);

void instituteDefaultEntries(void);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */

#include <assert.h>
#include <stdlib.h>
#include <limits.h>


typedef struct
{
  int self;
  int center;
  int subcenter;
  char *name;
  char *longname;
} institute_t;

static int instituteCompareKernel(institute_t *ip1, institute_t *ip2);
static void instituteDestroyP(institute_t *instituteptr);
static void institutePrintP(institute_t *instituteptr, FILE *fp);
static int instituteGetPackSize(institute_t *instituteptr, void *context);
static void institutePackP(void *instituteptr, void *buf, int size, int *position, void *context);
static int instituteTxCode(void *instituteptr);

static const resOps instituteOps = { (int (*)(void *, void *)) instituteCompareKernel,
                                     (void (*)(void *)) instituteDestroyP,
                                     (void (*)(void *, FILE *)) institutePrintP,
                                     (int (*)(void *, void *)) instituteGetPackSize,
                                     institutePackP,
                                     instituteTxCode };

static void
instituteDefaultValue(institute_t *instituteptr)
{
  instituteptr->self = CDI_UNDEFID;
  instituteptr->center = CDI_UNDEFID;
  instituteptr->subcenter = CDI_UNDEFID;
  instituteptr->name = NULL;
  instituteptr->longname = NULL;
}

void
instituteDefaultEntries(void)
{
  // clang-format off
  cdiResH resH[]
    = { institutDef( 98,   0, "ECMWF",     "European Centre for Medium-Range Weather Forecasts"),
        institutDef(252,   1, "MPIMET",    "Max Planck Institute for Meteorology"),
        institutDef( 98, 232, "MPIMET",    "Max Planck Institute for Meteorology"),
        institutDef( 98, 255, "MPIMET",    "Max-Planck-Institute for Meteorology"),
        institutDef( 78, 255, "DWD",       "Deutscher Wetterdienst"),
        institutDef( 78,   0, "DWD",       "Deutscher Wetterdienst"),
        institutDef(215, 255, "MCH",       "MeteoSwiss"),
        institutDef(  7,   0, "NCEP",      "National Centers for Environmental Prediction"),
        institutDef(  7,   1, "NCEP",      "National Centers for Environmental Prediction"),
        institutDef( 60,   0, "NCAR",      "National Center for Atmospheric Research"),
        institutDef( 74,   0, "METOFFICE", "U.K. Met Office"),
        institutDef( 97,   0, "ESA",       "European Space Agency"),
        institutDef( 99,   0, "KNMI",      "Royal Netherlands Meteorological Institute"),
        institutDef( 80,   0, "CNMC",      "Reparto per la Meteorologia, Rome (REMET)"),
        // institutDef(  0,   0, "IPSL", "IPSL (Institut Pierre Simon Laplace, Paris, France)");
  };
  // clang-format on

  const size_t n = sizeof(resH) / sizeof(*resH);
  for (size_t i = 0; i < n; i++) reshSetStatus(resH[i], &instituteOps, RESH_IN_USE);
}

static int
instituteCompareKernel(institute_t *ip1, institute_t *ip2)
{
  int differ = 0;

  if (ip1->name)
  {
    if (ip1->center > 0 && ip2->center != ip1->center) differ = 1;
    if (ip1->subcenter > 0 && ip2->subcenter != ip1->subcenter) differ = 1;

    if (!differ)
    {
      if (ip2->name)
      {
        const size_t len1 = strlen(ip1->name);
        const size_t len2 = strlen(ip2->name);
        if ((len1 != len2) || memcmp(ip2->name, ip1->name, len2)) differ = 1;
      }
    }
  }
  else if (ip1->longname)
  {
    if (ip2->longname)
    {
      const size_t len1 = strlen(ip1->longname);
      const size_t len2 = strlen(ip2->longname);
      if ((len1 != len2) || memcmp(ip2->longname, ip1->longname, len2)) differ = 1;
    }
  }
  else
  {
    if (!(ip2->center == ip1->center && ip2->subcenter == ip1->subcenter)) differ = 1;
    if (ip1->subcenter > 0 && ip1->subcenter != 255 && ip2->subcenter != ip1->subcenter) differ = 1;
  }

  return differ;
}

struct instLoc
{
  institute_t *ip;
  int id;
};

static enum cdiApplyRet
findInstitute(int id, void *res, void *data)
{
  institute_t *ip1 = ((struct instLoc *) data)->ip;
  institute_t *ip2 = (institute_t *) res;
  if (!instituteCompareKernel(ip1, ip2))
  {
    ((struct instLoc *) data)->id = id;
    return CDI_APPLY_STOP;
  }
  else
    return CDI_APPLY_GO_ON;
}

int
institutInq(int center, int subcenter, const char *name, const char *longname)
{
  institute_t ip_ref;
  ip_ref.self = CDI_UNDEFID;
  ip_ref.center = center;
  ip_ref.subcenter = subcenter;
  ip_ref.name = (name && name[0]) ? (char *) name : NULL;
  ip_ref.longname = (longname && longname[0]) ? (char *) longname : NULL;

  struct instLoc state = { .ip = &ip_ref, .id = CDI_UNDEFID };
  cdiResHFilterApply(&instituteOps, findInstitute, &state);

  return state.id;
}

static institute_t *
instituteNewEntry(cdiResH resH, int center, int subcenter, const char *name, const char *longname)
{
  institute_t *instituteptr = (institute_t *) malloc(sizeof(institute_t));
  instituteDefaultValue(instituteptr);
  if (resH == CDI_UNDEFID)
    instituteptr->self = reshPut(instituteptr, &instituteOps);
  else
  {
    instituteptr->self = resH;
    reshReplace(resH, instituteptr, &instituteOps);
  }
  instituteptr->center = center;
  instituteptr->subcenter = subcenter;
  if (name && *name) instituteptr->name = strdup(name);
  if (longname && *longname) instituteptr->longname = strdup(longname);
  return instituteptr;
}

int
institutDef(int center, int subcenter, const char *name, const char *longname)
{
  institute_t *instituteptr = instituteNewEntry(CDI_UNDEFID, center, subcenter, name, longname);
  return instituteptr->self;
}

int
institutInqCenter(int instID)
{
  return instID != CDI_UNDEFID ? ((institute_t *) (reshGetVal(instID, &instituteOps)))->center : CDI_UNDEFID;
}

int
institutInqSubcenter(int instID)
{
  return instID != CDI_UNDEFID ? ((institute_t *) (reshGetVal(instID, &instituteOps)))->subcenter : CDI_UNDEFID;
}

const char *
institutInqNamePtr(int instID)
{
  return instID != CDI_UNDEFID ? ((institute_t *) (reshGetVal(instID, &instituteOps)))->name : NULL;
}

const char *
institutInqLongnamePtr(int instID)
{
  return instID != CDI_UNDEFID ? ((institute_t *) (reshGetVal(instID, &instituteOps)))->longname : NULL;
}

int
institutInqNumber(void)
{
  int instNum = (int) (reshCountType(&instituteOps));
  return instNum;
}

static void
instituteDestroyP(institute_t *instituteptr)
{
  xassert(instituteptr);
  free(instituteptr->name);
  free(instituteptr->longname);
  free(instituteptr);
}

static void
institutePrintP(institute_t *ip, FILE *fp)
{
  if (ip)
    fprintf(fp,
            "#\n"
            "# instituteID %d\n"
            "#\n"
            "self          = %d\n"
            "center        = %d\n"
            "subcenter     = %d\n"
            "name          = %s\n"
            "longname      = %s\n",
            ip->self, ip->self, ip->center, ip->subcenter, ip->name ? ip->name : "NN", ip->longname ? ip->longname : "NN");
}

static int
instituteTxCode(void *instituteptr)
{
  (void) instituteptr;
  return INSTITUTE;
}

enum
{
  INSTITUTE_PACK_INT_SELF,
  INSTITUTE_PACK_INT_CENTER,
  INSTITUTE_PACK_INT_SUBCENTER,
  INSTITUTE_PACK_INT_NAMELEN,
  INSTITUTE_PACK_INT_LNAMELEN,
  institute_nints,
};

static int
instituteGetPackSize(institute_t *ip, void *context)
{
  size_t namelen = strlen(ip->name), longnamelen = strlen(ip->longname);
  xassert(namelen < INT_MAX && longnamelen < INT_MAX);
  size_t txsize = (size_t) serializeGetSize(institute_nints, CDI_DATATYPE_INT, context)
                  + (size_t) serializeGetSize((int) namelen + 1, CDI_DATATYPE_TXT, context)
                  + (size_t) serializeGetSize((int) longnamelen + 1, CDI_DATATYPE_TXT, context);
  xassert(txsize <= INT_MAX);
  return (int) txsize;
}

static void
institutePackP(void *instituteptr, void *buf, int size, int *position, void *context)
{
  institute_t *p = (institute_t *) instituteptr;
  int tempbuf[institute_nints];
  tempbuf[INSTITUTE_PACK_INT_SELF] = p->self;
  tempbuf[INSTITUTE_PACK_INT_CENTER] = p->center;
  tempbuf[INSTITUTE_PACK_INT_SUBCENTER] = p->subcenter;
  tempbuf[INSTITUTE_PACK_INT_NAMELEN] = (int) strlen(p->name) + 1;
  tempbuf[INSTITUTE_PACK_INT_LNAMELEN] = (int) strlen(p->longname) + 1;
  serializePack(tempbuf, institute_nints, CDI_DATATYPE_INT, buf, size, position, context);
  serializePack(p->name, tempbuf[INSTITUTE_PACK_INT_NAMELEN], CDI_DATATYPE_TXT, buf, size, position, context);
  serializePack(p->longname, tempbuf[INSTITUTE_PACK_INT_LNAMELEN], CDI_DATATYPE_TXT, buf, size, position, context);
}

int
instituteUnpack(void *buf, int size, int *position, int originNamespace, void *context, int force_id)
{
#define adaptKey(key) (namespaceAdaptKey((key), originNamespace))
  int tempbuf[institute_nints];
  int instituteID;
  serializeUnpack(buf, size, position, tempbuf, institute_nints, CDI_DATATYPE_INT, context);
  char *name = (char *) malloc((size_t) tempbuf[INSTITUTE_PACK_INT_NAMELEN] + (size_t) tempbuf[INSTITUTE_PACK_INT_LNAMELEN]),
       *longname = name + tempbuf[INSTITUTE_PACK_INT_NAMELEN];
  serializeUnpack(buf, size, position, name, tempbuf[INSTITUTE_PACK_INT_NAMELEN], CDI_DATATYPE_TXT, context);
  serializeUnpack(buf, size, position, longname, tempbuf[INSTITUTE_PACK_INT_LNAMELEN], CDI_DATATYPE_TXT, context);
  int targetID = force_id ? adaptKey(tempbuf[INSTITUTE_PACK_INT_SELF]) : CDI_UNDEFID;
  institute_t *ip
      = instituteNewEntry(targetID, tempbuf[INSTITUTE_PACK_INT_CENTER], tempbuf[INSTITUTE_PACK_INT_SUBCENTER], name, longname);
  instituteID = ip->self;
  xassert(!force_id || instituteID == targetID);
  free(name);
  reshSetStatus(instituteID, &instituteOps, reshGetStatus(instituteID, &instituteOps) & ~RESH_SYNC_BIT);
#undef adaptKey
  return instituteID;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/*
 * This file is for the use of iterator.c and the CdiIterator subclasses only.
 */

#ifndef INCLUDE_GUARD_CDI_ITERATOR_INT_H
#define INCLUDE_GUARD_CDI_ITERATOR_INT_H


#include <stdbool.h>

/*
class CdiIterator

An iterator is an object that identifies the position of one record in a file, where a record is defined as the data belonging to
one level, timestep, and variable. Using iterators to read a file can be significantly faster than using streams, because they can
avoid building an index of the file. For file formats like grib that do not provide an index within the file, this makes the
difference between reading the file once or reading the file twice.

CdiIterator is an abstract base class. Which derived class is used depends on the type of the file. The class hierarchy currently
looks like this:

    CdiIterator <|--+-- CdiFallbackIterator
                    |
                    +-- CdiGribIterator

The fallback implementation currently uses the stream interface of CDI under the hood to provide full functionality for all
filetypes for which no iterator implementation exists yet.
*/
// TODO[NH]: Debug messages, print function.

struct CdiIterator
{
  int filetype;     // This is used to dispatch calls to the correct subclass.
  bool isAdvanced;  // Used to catch inquiries before the first call to CdiIteratorNextField(). //XXX: Advanced is probably not a
                    // good word (initialized?)

  // The metadata that can be accessed by the inquiry calls.
  // While theoretically redundant, these fields allow the handling of most inquiry calls within the base class.
  // Only the name is excempted because it needs an allocation.
  // These fields are set by the subclasses in the xxxIterNextField() method.
  int datatype, timesteptype;
  int gridId;
  CdiParam param;

  // The status information for reading/advancing is added in the subclasses.
};

void baseIterConstruct(CdiIterator *me, int filetype);
const char *baseIter_constructFromString(
    CdiIterator *me, const char *description);  // Returns a pointer past the end of the parsed portion of the description string.
void baseIterDestruct(CdiIterator *me);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/*
 * A fallback implementation of the iterator interface that opens a stream under the hood.
 *
 * This implementation is mainly available to provide iterator access to file formats that don't support iterator access natively,
 * nevertheless, it allows the file to dictate the order in which data is read, possibly providing performance benefits.
 */

#ifndef INCLUDE_GUARD_CDI_ITERATOR_FALLBACK_H
#define INCLUDE_GUARD_CDI_ITERATOR_FALLBACK_H

#ifdef HAVE_CONFIG_H
#endif

#include <stdlib.h>


typedef struct CdiFallbackIterator CdiFallbackIterator;

CdiIterator *cdiFallbackIterator_new(const char *path, int filetype);
CdiFallbackIterator *cdiFallbackIterator_clone(CdiIterator *me);
CdiIterator *cdiFallbackIterator_getSuper(CdiFallbackIterator *me);
char *cdiFallbackIterator_serialize(CdiIterator *me);
CdiFallbackIterator *cdiFallbackIterator_deserialize(const char *me);

int cdiFallbackIterator_nextField(CdiIterator *me);

char *cdiFallbackIterator_inqTime(CdiIterator *me, CdiTimeType timeType);
int cdiFallbackIterator_levelType(CdiIterator *me, int levelSelector, char **outName, char **outLongName, char **outStdName,
                                  char **outUnit);
int cdiFallbackIterator_level(CdiIterator *me, int levelSelector, double *outValue1, double *outValue2);
int cdiFallbackIterator_zaxisUuid(CdiIterator *me, int *outVgridNumber, int *outLevelCount, unsigned char outUuid[CDI_UUID_SIZE]);
char *cdiFallbackIterator_copyVariableName(CdiIterator *me);
int cdiFallbackIterator_inqTile(CdiIterator *me, int *outTileIndex, int *outTileAttribute);
int cdiFallbackIterator_inqTileCount(CdiIterator *me, int *outTileCount, int *outTileAttributeCount);

void cdiFallbackIterator_readField(CdiIterator *me, double *buffer, size_t *numMissVals);
void cdiFallbackIterator_readFieldF(CdiIterator *me, float *buffer, size_t *numMissVals);

void cdiFallbackIterator_delete(CdiIterator *super);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/*
 * An implementation of the iterator interface for GRIB files.
 * Since GRIB files do not contain an index, this avoids scanning the entire file to generate an in-memory index as streamOpenRead()
 * does. Consequently, using this interface is much more efficient for GRIB files.
 */

#ifndef INCLUDE_GUARD_CDI_ITERATOR_GRIB_H
#define INCLUDE_GUARD_CDI_ITERATOR_GRIB_H

#ifdef HAVE_CONFIG_H
#endif


#ifdef HAVE_LIBGRIB_API
#include <grib_api.h>
#endif

typedef struct recordList recordList;

CdiIterator *cdiGribIterator_new(const char *path, int filetype);
CdiGribIterator *cdiGribIterator_makeClone(CdiIterator *me);
CdiIterator *cdiGribIterator_getSuper(CdiGribIterator *me);
char *cdiGribIterator_serialize(CdiIterator *me);
CdiGribIterator *cdiGribIterator_deserialize(const char *me);

int cdiGribIterator_nextField(CdiIterator *me);

char *cdiGribIterator_inqTime(CdiIterator *me, CdiTimeType timeType);
int cdiGribIterator_levelType(CdiIterator *me, int levelSelector, char **outName, char **outLongName, char **outStdName,
                              char **outUnit);
int cdiGribIterator_level(CdiIterator *me, int levelSelector, double *outValue1, double *outValue2);
int cdiGribIterator_zaxisUuid(CdiIterator *me, int *outVgridNumber, int *outLevelCount, unsigned char outUuid[CDI_UUID_SIZE]);
int cdiGribIterator_inqTile(CdiIterator *me, int *outTileIndex, int *outTileAttribute);
int cdiGribIterator_inqTileCount(CdiIterator *me, int *outTileCount, int *outTileAttributeCount);
char *cdiGribIterator_copyVariableName(CdiIterator *me);

void cdiGribIterator_readField(CdiIterator *me, double *buffer, size_t *numMissVals);
void cdiGribIterator_readFieldF(CdiIterator *me, float *buffer, size_t *numMissVals);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */


#include <assert.h>
#include <ctype.h>

static const char kUnexpectedFileTypeMessage[] = "Internal error: Unexpected file type encountered in iterator.\n"
                                                 "This is either due to an illegal memory access by the application\n"
                                                 " or an internal logical error in CDI (unlikely, but possible).";
static const char kAdvancedString[] = "advanced";
static const char kUnadvancedString[] = "unadvanced";

// Returns a static string.
static const char *
fileType2String(int fileType)
{
  switch (fileType)
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRB: return "CDI::Iterator::GRIB1";
    case CDI_FILETYPE_GRB2: return "CDI::Iterator::GRIB2";
#endif
#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NC: return "CDI::Iterator::NetCDF";
    case CDI_FILETYPE_NC2: return "CDI::Iterator::NetCDF2";
    case CDI_FILETYPE_NC4: return "CDI::Iterator::NetCDF4";
    case CDI_FILETYPE_NC4C: return "CDI::Iterator::NetCDF4C";
    case CDI_FILETYPE_NC5: return "CDI::Iterator::NetCDF5";
    case CDI_FILETYPE_NCZARR: return "CDI::Iterator::NCZarr";
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV: return "CDI::Iterator::SRV";
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT: return "CDI::Iterator::EXT";
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG: return "CDI::Iterator::IEG";
#endif

    default: return NULL;
  }
}

static int
string2FileType(const char *fileType, const char **outRestString)
{
  // This first part unconditionally checks all known type strings, and only if the given string matches one of these strings, we
  // use fileType2string() to check whether support for this type has been compiled in. This is to avoid throwing "invalid type
  // string" errors when we just have a library version mismatch.
#define check(givenString, typeString, typeConstant)                                                           \
  do {                                                                                                         \
    if (givenString == strstr(givenString, typeString))                                                        \
    {                                                                                                          \
      if (outRestString) *outRestString = givenString + strlen(typeString);                                    \
      if (fileType2String(typeConstant)) return typeConstant;                                                  \
      Error("Support for " typeString                                                                          \
            " not compiled in. Please check that the result of `cdiIterator_serialize()` is only passed to a " \
            "`cdiIterator_deserialize()` implementation of the same CDI library version.");                    \
      return CDI_FILETYPE_UNDEF;                                                                               \
    }                                                                                                          \
  } while (0)
  check(fileType, "CDI::Iterator::GRIB1", CDI_FILETYPE_GRB);
  check(fileType, "CDI::Iterator::GRIB2", CDI_FILETYPE_GRB2);
  check(fileType, "CDI::Iterator::NetCDF", CDI_FILETYPE_NC);
  check(fileType, "CDI::Iterator::NetCDF2", CDI_FILETYPE_NC2);
  check(fileType, "CDI::Iterator::NetCDF4", CDI_FILETYPE_NC4);
  check(fileType, "CDI::Iterator::NetCDF4C", CDI_FILETYPE_NC4C);
  check(fileType, "CDI::Iterator::NetCDF5", CDI_FILETYPE_NC5);
  check(fileType, "CDI::Iterator::NCZarr", CDI_FILETYPE_NCZARR);
  check(fileType, "CDI::Iterator::SRV", CDI_FILETYPE_SRV);
  check(fileType, "CDI::Iterator::EXT", CDI_FILETYPE_EXT);
  check(fileType, "CDI::Iterator::IEG", CDI_FILETYPE_IEG);
#undef check

  // If this point is reached, the given string does not seem to be produced by a cdiIterator_serialize() call.
  Error("The string \"%s\" does not start with a valid iterator type. Please check the source of this string.", fileType);
  *outRestString = fileType;
  return CDI_FILETYPE_UNDEF;
}

/*
@Function cdiIterator_new
@Title Create an iterator for an input file

@Prototype CdiIterator* cdiIterator_new(const char* path)
@Parameter
    @item path Path to the file that is to be read.

@Result An iterator for the given file.

@Description
    Combined allocator and constructor for CdiIterator.

    The returned iterator does not point to the first field yet,
    it must first be advanced once before the first field can be introspected.
    This design decision has two benefits: 1. Empty files require no special
    cases, 2. Users can start a while(!cdiIterator_nextField(iterator)) loop
    right after the call to cdiIterator_new().
*/
CdiIterator *
cdiIterator_new(const char *path)
{
  int trash;
  const int filetype = cdiGetFiletype(path, &trash);
  switch (cdiBaseFiletype(filetype))
  {
    case CDI_FILETYPE_UNDEF: Warning("Can't open file \"%s\": unknown format\n", path); return NULL;

#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_new(path, filetype);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_new(path, filetype);

    default:
      Warning("the file \"%s\" is of type %s, but support for this format is not compiled in!", path, strfiletype(filetype));
      return NULL;
  }
}

void
baseIterConstruct(CdiIterator *me, int filetype)
{
  me->filetype = filetype;
  me->isAdvanced = false;
}

const char *
baseIter_constructFromString(CdiIterator *me, const char *description)
{
  const char *result = description;
  me->filetype = string2FileType(result, &result);
  assert(me->filetype != CDI_FILETYPE_UNDEF
         && "Please report this error.");  // This condition should have been checked for in a calling function.
  for (; *result && isspace(*result); result++)
    ;
  if (result == strstr(result, kAdvancedString))
  {
    me->isAdvanced = true;
    result += sizeof(kAdvancedString) - 1;
  }
  else if (result == strstr(result, kUnadvancedString))
  {
    me->isAdvanced = false;
    result += sizeof(kUnadvancedString) - 1;
  }
  else
  {
    Error("Invalid iterator description string \"%s\". Please check the origin of this string.", description);
    return NULL;
  }
  return result;
}

#define sanityCheck(me)                                                                                                     \
  do {                                                                                                                      \
    if (!me) xabort("NULL was passed to %s as an iterator. Please check the return value of cdiIterator_new().", __func__); \
    if (!me->isAdvanced) xabort("Calling %s is not allowed without calling cdiIterator_nextField() first.", __func__);      \
  } while (0)

/*
@Function cdiIterator_clone
@Title Make a copy of an iterator

@Prototype CdiIterator* cdiIterator_clone(CdiIterator* me)
@Parameter
    @item iterator The iterator to copy.

@Result The clone.

@Description
    Clones the given iterator. Make sure to call cdiIterator_delete() on both
    the copy and the original.

    This is not a cheap operation: Depending on the type of the file, it will
    either make a copy of the current field in memory (GRIB files), or reopen
    the file (all other file types). Use it sparingly. And if you do, try to
    avoid keeping too many clones around: their memory footprint is
    significant.
*/
CdiIterator *
cdiIterator_clone(CdiIterator *me)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_getSuper(cdiGribIterator_clone(me));
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_getSuper(cdiFallbackIterator_clone(me));

    default: Error(kUnexpectedFileTypeMessage); return NULL;
  }
}

/*
@Function cdiGribIterator_clone
@Title Gain access to GRIB specific functionality

@Prototype CdiGribIterator* cdiGribIterator_clone(CdiIterator* me)
@Parameter
    @item iterator The iterator to operate on.

@Result A clone that allows access to GRIB specific functionality, or NULL if the underlying file is not a GRIB file.

@Description
    Clones the given iterator iff the underlying file is a GRIB file, the returned iterator allows access to GRIB specific
functionality. Make sure to check that the return value is not NULL, and to call cdiGribIterator_delete() on the copy.

    This is not a cheap operation: It will make a copy of the current field in memory. Use it sparingly. And if you do, try to avoid
keeping too many clones around, their memory footprint is significant.
*/
CdiGribIterator *
cdiGribIterator_clone(CdiIterator *me)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_makeClone(me);
#endif

    default: return NULL;
  }
}

/*
@Function cdiIterator_serialize
@Title Serialize an iterator for sending it to another process

@Prototype char* cdiIterator_serialize(CdiIterator* me)
@Parameter
    @item iterator The iterator to operate on.

@Result A malloc'ed string that contains the full description of the iterator.

@Description
    Make sure to call Free() on the resulting string.
*/
char *
cdiIterator_serialize(CdiIterator *me)
{
  if (!me) xabort("NULL was passed to %s as an iterator. Please check the return value of cdiIterator_new().", __func__);
  char *subclassDescription = NULL;
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: subclassDescription = cdiGribIterator_serialize(me); break;
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      subclassDescription = cdiFallbackIterator_serialize(me);
      break;

    default: Error(kUnexpectedFileTypeMessage); return NULL;
  }

  const char *ftypeStr = fileType2String(me->filetype), *advStr = me->isAdvanced ? kAdvancedString : kUnadvancedString;
  size_t len = strlen(ftypeStr) + 1 + strlen(advStr) + 1 + strlen(subclassDescription) + 1;
  char *result = (char *) Malloc(len);
  snprintf(result, len, "%s %s %s", ftypeStr, advStr, subclassDescription);
  Free(subclassDescription);
  return result;
}

/*
@Function cdiIterator_deserialize
@Title Recreate an iterator from its textual description

@Prototype CdiIterator* cdiIterator_deserialize(const char* description)
@Parameter
    @item description The result of a call to cdiIterator_serialize().

@Result A clone of the original iterator.

@Description
    A pair of cdiIterator_serialize() and cdiIterator_deserialize() is functionally equivalent to a call to cdiIterator_clone()

    This function will reread the current field from disk, so don't expect immediate return.
*/
// This only checks the type of the iterator and calls the corresponding subclass function,
// the real deserialization is done in baseIter_constructFromString().
CdiIterator *
cdiIterator_deserialize(const char *description)
{
  switch (cdiBaseFiletype(string2FileType(description, NULL)))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_getSuper(cdiGribIterator_deserialize(description));
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_getSuper(cdiFallbackIterator_deserialize(description));

    default: Error(kUnexpectedFileTypeMessage); return NULL;
  }
}

/*
@Function cdiIterator_print
@Title Print a textual description of the iterator to a stream

@Prototype void cdiIterator_print(CdiIterator* iterator, FILE* stream);
@Parameter
    @item iterator The iterator to print.
    @item stream The stream to print to.

@Description
    Use for debugging output.
*/
void
cdiIterator_print(CdiIterator *me, FILE *stream)
{
  char *description = cdiIterator_serialize(me);
  fprintf(stream, "%s\n", description);
  Free(description);
}

/*
@Function cdiIterator_nextField
@Title Advance an iterator to the next field in the file

@Prototype int cdiIterator_nextField(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result An error code. May be one of:
  * CDI_NOERR: The iterator has successfully been advanced to the next field.
  * CDI_EEOF: No more fields to read in this file.

@Description
    One call to cdiIterator_nextField() is required before the metadata of the first field can be examined.
    Usually, it will be used directly as the condition for a while() loop.
*/
int
cdiIterator_nextField(CdiIterator *me)
{
  if (!me) xabort("NULL was passed in as an iterator. Please check the return value of cdiIterator_new().");
  me->isAdvanced = true;
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_nextField(me);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_nextField(me);

    default: Error(kUnexpectedFileTypeMessage); return CDI_EINVAL;
  }
}

static char *
cdiIterator_inqTime(CdiIterator *me, CdiTimeType timeType)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_inqTime(me, timeType);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_inqTime(me, timeType);

    default: Error(kUnexpectedFileTypeMessage); return NULL;
  }
}

/*
@Function cdiIterator_inqStartTime
@Title Get the start time of a measurement

@Prototype char* cdiIterator_inqStartTime(CdiIterator* me)
@Parameter
    @item iterator The iterator to operate on.

@Result A malloc'ed string containing the (start) time of the current field in the format "YYYY-MM-DDTHH:MM:SS.mmm".

@Description
The returned time is either the time of the data (fields defined at a time point),
or the start time of an integration time range (statistical fields).

Converts the time to the ISO-8601 format and returns it in a newly allocated buffer.
The caller is responsible to Free() the resulting string.

If the file is a GRIB file, the calendar that is used to resolve the relative times is the proleptic calendar
as it is implemented by the standard C mktime() function.
This is due to the fact that GRIB-API version 1.12.3 still does not implement the calendar identification fields.
*/
char *
cdiIterator_inqStartTime(CdiIterator *me)
{
  return cdiIterator_inqTime(me, kCdiTimeType_startTime);
}

/*
@Function cdiIterator_inqEndTime
@Title Get the end time of a measurement

@Prototype char* cdiIterator_inqEndTime(CdiIterator* me)
@Parameter
    @item iterator The iterator to operate on.

@Result A malloc'ed string containing the end time of the current field in the format "YYYY-MM-DDTHH:MM:SS.mmm", or NULL if no such
time is defined.

@Description
The returned time is the end time of an integration period if such a time exists (statistical fields).
Otherwise, NULL is returned.

Converts the time to the ISO-8601 format and returns it in a newly allocated buffer.
The caller is responsible to Free() the resulting string.

If the file is a GRIB file, the calendar that is used to resolve the relative times is the proleptic calendar
as it is implemented by the standard C mktime() function.
This is due to the fact that GRIB-API version 1.12.3 still does not implement the calendar identification fields.
*/
char *
cdiIterator_inqEndTime(CdiIterator *me)
{
  return cdiIterator_inqTime(me, kCdiTimeType_endTime);
}

/*
@Function cdiIterator_inqRTime
@Title Get the validity time of the current field

@Prototype char* cdiIterator_inqRTime(CdiIterator* me)
@Parameter
    @item iterator The iterator to operate on.

@Result A malloc'ed string containing the validity time of the current field in the format "YYYY-MM-DDTHH:MM:SS.mmm".

@Description
The returned time is the validity time as it is returned by taxisInqVtime(), only more precise.
That is, if the field is a time point, its time is returned,
if it is a statistical field with an integration period, the end time of the integration period is returned.

Converts the time to the ISO-8601 format and returns it in a newly allocated buffer.
The caller is responsible to Free() the resulting string.

If the file is a GRIB file, the calendar that is used to resolve the relative times is the proleptic calendar
as it is implemented by the standard C mktime() function.
This is due to the fact that GRIB-API version 1.12.3 still does not implement the calendar identification fields.
*/
char *
cdiIterator_inqRTime(CdiIterator *me)
{
  return cdiIterator_inqTime(me, kCdiTimeType_referenceTime);
}

/*
@Function cdiIterator_inqVTime
@Title Get the validity time of the current field

@Prototype char* cdiIterator_inqVTime(CdiIterator* me)
@Parameter
    @item iterator The iterator to operate on.

@Result A malloc'ed string containing the validity time of the current field in the format "YYYY-MM-DDTHH:MM:SS.mmm".

@Description
The returned time is the validity time as it is returned by taxisInqVtime(), only more precise.
That is, if the field is a time point, its time is returned,
if it is a statistical field with an integration period, the end time of the integration period is returned.

Converts the time to the ISO-8601 format and returns it in a newly allocated buffer.
The caller is responsible to Free() the resulting string.

If the file is a GRIB file, the calendar that is used to resolve the relative times is the proleptic calendar
as it is implemented by the standard C mktime() function.
This is due to the fact that GRIB-API version 1.12.3 still does not implement the calendar identification fields.
*/
char *
cdiIterator_inqVTime(CdiIterator *me)
{
  char *result = cdiIterator_inqEndTime(me);
  return (result) ? result : cdiIterator_inqStartTime(me);
}

/*
@Function cdiIterator_inqLevelType
@Title Get the type of a level

@Prototype int cdiIterator_inqLevelType(CdiIterator* me, int levelSelector, char **outName = NULL, char **outLongName = NULL, char
**outStdName = NULL, char **outUnit = NULL)
@Parameter
    @item iterator The iterator to operate on.
    @item levelSelector Zero for the top level, one for the bottom level
    @item outName Will be set to a Malloc()'ed string with the name of the level if not NULL.
    @item outLongName Will be set to a Malloc()'ed string with the long name of the level if not NULL.
    @item outStdName Will be set to a Malloc()'ed string with the standard name of the level if not NULL.
    @item outUnit Will be set to a Malloc()'ed string with the unit of the level if not NULL.

@Result An integer indicating the type of the level.

@Description
Find out some basic information about the given level, the levelSelector selects the function of the requested level.
If the requested level does not exist, this returns CDI_UNDEFID.
*/
int
cdiIterator_inqLevelType(CdiIterator *me, int levelSelector, char **outName, char **outLongName, char **outStdName, char **outUnit)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_levelType(me, levelSelector, outName, outLongName, outStdName, outUnit);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_levelType(me, levelSelector, outName, outLongName, outStdName, outUnit);

    default: Error(kUnexpectedFileTypeMessage); return CDI_UNDEFID;
  }
}

/*
@Function cdiIterator_inqLevel
@Title Get the value of the z-coordinate

@Prototype void cdiIterator_inqLevel(CdiIterator* me, int levelSelector, double* outValue1, double* outValue2 = NULL)
@Parameter
    @item iterator The iterator to operate on.
    @item levelSelector Zero for the top level, one for the bottom level
    @item outValue1 For "normal" levels this returns the value, for hybrid levels the first coordinate, for generalized levels the
level number.
    @item outValue2 Zero for "normal" levels, for hybrid levels, this returns the second coordinate, for generalized levels the
level count.

@Result An error code.

@Description
Returns the value of the z-coordinate, whatever that may be.
*/
int
cdiIterator_inqLevel(CdiIterator *me, int levelSelector, double *outValue1, double *outValue2)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_level(me, levelSelector, outValue1, outValue2);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_level(me, levelSelector, outValue1, outValue2);

    default: Error(kUnexpectedFileTypeMessage); return CDI_EINVAL;
  }
}

/*
@Function cdiIterator_inqLevelUuid
@Title Get the UUID of the z-axis used by this field

@Prototype int cdiIterator_inqLevelUuid(CdiIterator* me, int levelSelector, unsigned char (*outUuid)[16])
@Parameter
    @item iterator The iterator to operate on.
    @item outVgridNumber The number of the associated vertical grid description.
    @item outLevelCount The number of levels in the associated vertical grid description.
    @item outUuid A pointer to a user supplied buffer of 16 bytes to store the UUID in.

@Result An error code.

@Description
Returns identifying information for the external z-axis description. May only be called for generalized levels.
*/
int
cdiIterator_inqLevelUuid(CdiIterator *me, int *outVgridNumber, int *outLevelCount, unsigned char outUuid[CDI_UUID_SIZE])
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_zaxisUuid(me, outVgridNumber, outLevelCount, outUuid);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_zaxisUuid(me, outVgridNumber, outLevelCount, outUuid);

    default: Error(kUnexpectedFileTypeMessage); return CDI_ELIBNAVAIL;
  }
}

/*
@Function cdiIterator_inqTile
@Title Inquire the tile information for the current field

@Prototype int cdiIterator_inqTile(CdiIterator* me, int* outTileIndex, int* outTileAttribute)
@Parameter
    @item iterator The iterator to operate on.
    @item outTileIndex The index of the current tile, -1 if no tile information is available.
    @item outTileAttribute The attribute of the current tile, -1 if no tile information is available.

@Result An error code. CDI_EINVAL if there is no tile information associated with the current field.

@Description
Inquire the tile index and attribute for the current field.
*/
int
cdiIterator_inqTile(CdiIterator *me, int *outTileIndex, int *outTileAttribute)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_inqTile(me, outTileIndex, outTileAttribute);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_inqTile(me, outTileIndex, outTileAttribute);

    default: Error(kUnexpectedFileTypeMessage); return CDI_ELIBNAVAIL;
  }
}

/**
@Function cdiIterator_inqTileCount
@Title Inquire the tile count and tile attribute counts for the current field

@Prototype int cdiIterator_inqTileCount(CdiIterator* me, int* outTileCount, int* outTileAttributeCount)
@Parameter
    @item iterator The iterator to operate on.
    @item outTileCount The number of tiles used for this variable, zero if no tile information is available.
    @item outTileAttributeCount The number of attributes available for the tile of this field, zero if no tile information is
available. Note: This is not the global attribute count, which would be impossible to infer without reading the entire file if it's
a GRIB file.

@Result An error code. CDI_EINVAL if there is no tile information associated with the current field.

@Description
Inquire the tile count and tile attribute counts for the current field.
*/
int
cdiIterator_inqTileCount(CdiIterator *me, int *outTileCount, int *outTileAttributeCount)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_inqTileCount(me, outTileCount, outTileAttributeCount);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_inqTileCount(me, outTileCount, outTileAttributeCount);

    default: Error(kUnexpectedFileTypeMessage); return CDI_ELIBNAVAIL;
  }
}

/*
@Function cdiIterator_inqParam
@Title Get discipline, category, and number

@Prototype CdiParam cdiIterator_inqParam(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result A struct containing the requested information.

@Description
    Simple metadata inspection function.
*/
CdiParam
cdiIterator_inqParam(CdiIterator *me)
{
  sanityCheck(me);
  return me->param;
}

/*
@Function cdiIterator_inqParamParts
@Title Get discipline, category, and number

@Prototype void cdiIterator_inqParamParts(CdiIterator *me, int *outDiscipline, int *outCategory, int *outNumber)
@Parameter
    @item iterator The iterator to operate on.
    @item outDiscipline This is used to return the discipline.
    @item outCategory This is used to return the category.
    @item outNumber This is used to return the number.

@Description
    Simple metadata inspection function.

    Some FORTRAN compilers produce wrong code for the cdiIterator_inqParam()-wrapper,
    rendering it unusable from FORTRAN. This function is the workaround.
*/
void
cdiIterator_inqParamParts(CdiIterator *me, int *outDiscipline, int *outCategory, int *outNumber)
{
  CdiParam result = cdiIterator_inqParam(me);
  if (outDiscipline) *outDiscipline = result.discipline;
  if (outCategory) *outCategory = result.category;
  if (outNumber) *outNumber = result.number;
}

/*
@Function cdiIterator_inqDatatype
@Title Get the datatype of the current field

@Prototype int cdiIterator_inqDatatype(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result The datatype that is used to store this field on disk.

@Description
    Simple metadata inspection function.
*/
int
cdiIterator_inqDatatype(CdiIterator *me)
{
  sanityCheck(me);
  return me->datatype;
}

/*
@Function cdiIterator_inqFiletype
@Title Get the filetype of the current field

@Prototype int cdiIterator_inqFiletype(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result The filetype that is used to store this field on disk.

@Description
    Simple metadata inspection function.
*/
int
cdiIterator_inqFiletype(CdiIterator *me)
{
  return me->filetype;
}

/*
@Function cdiIterator_inqTsteptype
@Title Get the timestep type

@Prototype int cdiIterator_inqTsteptype(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result The timestep type.

@Description
    Simple metadata inspection function.
*/
int
cdiIterator_inqTsteptype(CdiIterator *me)
{
  sanityCheck(me);
  return me->timesteptype;
}

/*
@Function cdiIterator_inqVariableName
@Title Get the variable name of the current field

@Prototype char* cdiIterator_inqVariableName(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result A pointer to a C-string containing the name. The storage for this string is allocated with Malloc(), and it is the
responsibility of the caller to Free() it.

@Description
    Allocates a buffer to hold the string, copies the current variable name into this buffer, and returns the buffer.
    The caller is responsible to make the corresponding Free() call.
*/
char *
cdiIterator_inqVariableName(CdiIterator *me)
{
  sanityCheck(me);
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: return cdiGribIterator_copyVariableName(me);
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      return cdiFallbackIterator_copyVariableName(me);

    default: Error(kUnexpectedFileTypeMessage); return NULL;
  }
}

/*
@Function cdiIterator_inqGridId
@Title Get the ID of the current grid

@Prototype int cdiIterator_inqGridId(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Result A gridId that can be used for further introspection.

@Description
    This provides access to the grid related metadata.
    The resulting ID is only valid until the next time cdiIterator_nextField() is called.
*/
int
cdiIterator_inqGridId(CdiIterator *me)
{
  sanityCheck(me);
  return me->gridId;
}

/*
@Function cdiIterator_readField
@Title Read the whole field into a double buffer

@Prototype void cdiIterator_readField(CdiIterator *me, double *buffer, SizeType *numMissVals)
@Parameter
    @item iterator The iterator to operate on.
    @item buffer A pointer to the double array that the data should be written to.
    @item numMissVals A pointer to a variable where the count of missing values will be stored. May be NULL.

@Description
    It is assumed that the caller first analyses the return value of cdiIterator_inqGridId to determine the required size of the
buffer. Failing to do so results in undefined behavior. You have been warned.
*/
void
cdiIterator_readField(CdiIterator *me, double *buffer, SizeType *numMissVals)
{
  size_t numMiss = 0;
  sanityCheck(me);
  if (!buffer) xabort("NULL was passed in a buffer. Please provide a suitable buffer.");
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: cdiGribIterator_readField(me, buffer, &numMiss); return;
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      cdiFallbackIterator_readField(me, buffer, &numMiss);
      return;
    default: Error(kUnexpectedFileTypeMessage);
  }

  *numMissVals = (SizeType) numMiss;
}

/*
@Function cdiIterator_readFieldF
@Title Read the whole field into a double buffer

@Prototype void cdiIterator_readFieldF(CdiIterator  me, float *buffer, SizeType *numMissVals)
@Parameter
    @item iterator The iterator to operate on.
    @item buffer   A pointer to the double array that the data should be written to.
    @item numMissVals    A pointer to a variable where the count of missing values will be stored. May be NULL.

@Description
    It is assumed that the caller first analyses the return value of cdiIterator_inqGridId to determine the required size of the
buffer. Failing to do so results in undefined behavior. You have been warned.
*/
void
cdiIterator_readFieldF(CdiIterator *me, float *buffer, SizeType *numMissVals)
{
  size_t numMiss = 0;
  sanityCheck(me);
  if (!buffer) xabort("NULL was passed in a buffer. Please provide a suitable buffer.");
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: cdiGribIterator_readFieldF(me, buffer, &numMiss); return;
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      cdiFallbackIterator_readFieldF(me, buffer, &numMiss);
      return;
    default: Error(kUnexpectedFileTypeMessage);
  }

  *numMissVals = (SizeType) numMiss;
}

/*
@Function cdiIterator_delete
@Title Destroy an iterator

@Prototype void cdiIterator_delete(CdiIterator* iterator)
@Parameter
    @item iterator The iterator to operate on.

@Description
    Combined destructor & deallocator.
*/
void
cdiIterator_delete(CdiIterator *me)
{
  if (!me) xabort("NULL was passed in as an iterator. Please check the return value of cdiIterator_new().");
  switch (cdiBaseFiletype(me->filetype))
  {
#ifdef HAVE_LIBGRIB_API
    case CDI_FILETYPE_GRIB: cdiGribIterator_delete((CdiGribIterator *) me); break;
#endif

#ifdef HAVE_LIBNETCDF
    case CDI_FILETYPE_NETCDF:
#endif
#ifdef HAVE_LIBSERVICE
    case CDI_FILETYPE_SRV:
#endif
#ifdef HAVE_LIBEXTRA
    case CDI_FILETYPE_EXT:
#endif
#ifdef HAVE_LIBIEG
    case CDI_FILETYPE_IEG:
#endif
      cdiFallbackIterator_delete(me);
      break;

    default: Error(kUnexpectedFileTypeMessage);
  }
}

void
baseIterDestruct(CdiIterator *me)
{
  /*currently empty, but that's no reason not to call it*/
  (void) me;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
/* DO NOT REMOVE the config.h include file under any circumstances,
 * it's very much needed on some platforms */
#if defined(HAVE_CONFIG_H)
#endif
/* DO NOT REMOVE the above config.h include file under any
 * circumstances as long as it's the autoconf configuration header
 * used to build this package. When it's missing on some platforms,
 * some poor person has to do long, tedious debugging sessions, where
 * struct offsets almost imperceptibly change from one file to the
 * next to find out what happened */



#include <assert.h>
#include <limits.h>
#include <stdlib.h>

// On Windows, define ssize_t manually
#ifdef _WIN32
#define ssize_t __int64
#else
#include <unistd.h>
#endif

struct CdiFallbackIterator
{
  CdiIterator super;
  char *path;  // needed for clone() & serialize()
  int streamId, vlistId, subtypeId;

  int variableCount, curVariable;
  int curLevelCount, curLevel;
  int curSubtypeCount, curSubtype;
  int curTimestep;
};

CdiIterator *
cdiFallbackIterator_getSuper(CdiFallbackIterator *me)
{
  return &me->super;
}

CdiIterator *
cdiFallbackIterator_new(const char *path, int filetype)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) Malloc(sizeof(*me));
  baseIterConstruct(&me->super, filetype);
  me->subtypeId = CDI_UNDEFID;  // Will be set in cdiFallbackIterator_nextField()
  me->curSubtypeCount = -1;     // Will be set in cdiFallbackIterator_nextField()
  me->curLevelCount = -1;       // Will be set in cdiFallbackIterator_nextField()
  // These values are chosen so that the natural increment at the start of cdiFallbackIterator_nextField() will correctly position
  // us at the first slice.
  me->curTimestep = 0;
  me->curVariable = -1;
  me->curSubtype = -1;
  me->curLevel = -1;
  me->streamId = streamOpenRead(path);
  if (me->streamId != CDI_UNDEFID)
  {
    me->vlistId = streamInqVlist(me->streamId);
    if (me->vlistId != CDI_UNDEFID && (me->variableCount = vlistNvars(me->vlistId)) > 0
        && streamInqTimestep(me->streamId, me->curTimestep) > 0 && (me->path = strdup(path)))
    {
      return (CdiIterator *) me;
    }
    Free(me->path);
    streamClose(me->streamId);
  }
  baseIterDestruct(&me->super);
  Free(me);
  return NULL;
}

void
cdiFallbackIterator_delete(CdiIterator *super)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  Free(me->path);
  streamClose(me->streamId);
  baseIterDestruct(super);
  Free(me);
}

// Fetches the info that is derived from the current variable. Most of this is published by the data members in the base class.
static void
fetchVariableInfo(CdiFallbackIterator *me)
{
  // Fetch data that's published via base class data members.
  me->super.datatype = vlistInqVarDatatype(me->vlistId, me->curVariable);
  me->super.timesteptype = vlistInqVarTsteptype(me->vlistId, me->curVariable);
  me->super.gridId = vlistInqVarGrid(me->vlistId, me->curVariable);
  int param = vlistInqVarParam(me->vlistId, me->curVariable);
  cdiDecodeParam(param, &me->super.param.number, &me->super.param.category, &me->super.param.discipline);

  // Fetch the current level and subtype counts.
  me->curLevelCount = zaxisInqSize(vlistInqVarZaxis(me->vlistId, me->curVariable));
  me->subtypeId = vlistInqVarSubtype(me->vlistId, me->curVariable);
  me->curSubtypeCount = (me->subtypeId == CDI_UNDEFID) ? 1 : subtypeInqSize(me->subtypeId);
}

CdiFallbackIterator *
cdiFallbackIterator_clone(CdiIterator *super)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;

  // Make another stream for this file. This yields an unadvanced iterator.
  CdiFallbackIterator *clone = (CdiFallbackIterator *) (void *) cdiFallbackIterator_new(me->path, me->super.filetype);
  if (clone)
  {
    // Point the clone to the same position in the file.
    clone->variableCount = me->variableCount;
    clone->curVariable = me->curVariable;
    clone->curLevelCount = me->curLevelCount;
    clone->curLevel = me->curLevel;
    clone->curSubtypeCount = me->curSubtypeCount;
    clone->curSubtype = me->curSubtype;
    clone->curTimestep = me->curTimestep;

    clone->super.isAdvanced = super->isAdvanced;
    if (super->isAdvanced) fetchVariableInfo(clone);
  }

  return clone;
}

char *
cdiFallbackIterator_serialize(CdiIterator *super)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;

  char *escapedPath = cdiEscapeSpaces(me->path);
  size_t len = strlen(escapedPath) + 7 * (3 * sizeof(int) * CHAR_BIT / 8 + 1) + 1;
  char *result = (char *) Malloc(len);
  snprintf(result, len, "%s %d %d %d %d %d %d %d", escapedPath, me->variableCount, me->curVariable, me->curLevelCount, me->curLevel,
           me->curSubtypeCount, me->curSubtype, me->curTimestep);
  Free(escapedPath);
  return result;
}

CdiFallbackIterator *
cdiFallbackIterator_deserialize(const char *description)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) Malloc(sizeof(*me));
  if (!me) goto fail;

  description = baseIter_constructFromString(&me->super, description);

  while (*description == ' ') description++;
  me->path = cdiUnescapeSpaces(description, &description);
  if (!me->path) goto destructSuper;

  me->streamId = streamOpenRead(me->path);
  if (me->streamId == CDI_UNDEFID) goto freePath;
  me->vlistId = streamInqVlist(me->streamId);
  if (me->vlistId == CDI_UNDEFID) goto closeStream;

    // This reads one variable from the description string, does error checking, and advances the given string pointer.
#define decodeValue(variable, description)                                                                                    \
  do {                                                                                                                        \
    const char *savedStart = description;                                                                                     \
    long long decodedValue                                                                                                    \
        = strtoll(description, (char **) &description, 0); /*The cast is a workaround for the wrong signature of strtoll().*/ \
    variable = (int) decodedValue;                                                                                            \
    if (savedStart == description) goto closeStream;                                                                          \
    if ((long long) decodedValue != (long long) variable) goto closeStream;                                                   \
  } while (0)
  decodeValue(me->variableCount, description);
  decodeValue(me->curVariable, description);
  decodeValue(me->curLevelCount, description);
  decodeValue(me->curLevel, description);
  decodeValue(me->curSubtypeCount, description);
  decodeValue(me->curSubtype, description);
  decodeValue(me->curTimestep, description);
#undef decodeValue

  if (streamInqTimestep(me->streamId, me->curTimestep) <= 0) goto closeStream;
  if (me->super.isAdvanced) fetchVariableInfo(me);

  return me;

closeStream:
  streamClose(me->streamId);
freePath:
  Free(me->path);
destructSuper:
  baseIterDestruct(&me->super);
  Free(me);
fail:
  return NULL;
}

static int
advance(CdiFallbackIterator *me)
{
  me->curLevel++;
  if (me->curLevel >= me->curLevelCount)
  {
    me->curLevel = 0;
    me->curSubtype++;
    if (me->curSubtype >= me->curSubtypeCount)
    {
      me->curSubtype = 0;
      me->curVariable++;
      if (me->curVariable >= me->variableCount)
      {
        me->curVariable = 0;
        me->curTimestep++;
        if (streamInqTimestep(me->streamId, me->curTimestep) <= 0) return CDI_EEOF;
      }
    }
  }
  return CDI_NOERR;
}

int
cdiFallbackIterator_nextField(CdiIterator *super)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  int result = advance(me);
  if (result) return result;

  if (!me->curLevel && !me->curSubtype)
    fetchVariableInfo(me);  // Check whether we are processing a new variable/timestep and fetch the information that may have
                            // changed in this case.
  return CDI_NOERR;
}

char *
cdiFallbackIterator_inqTime(CdiIterator *super, CdiTimeType timeType)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;

  // retrieve the time information
  int taxisId = vlistInqTaxis(me->vlistId);
  int date = 0, time = 0;
  switch (timeType)
  {
    case kCdiTimeType_referenceTime:
      date = taxisInqRdate(taxisId);
      time = taxisInqRtime(taxisId);
      break;

    case kCdiTimeType_startTime:
      date = taxisInqVdate(taxisId);
      time = taxisInqVtime(taxisId);
      break;

    case kCdiTimeType_endTime:
      return NULL;  // The stream interface does not export the start/end times of statistical fields, so we treat all data as point
                    // of time data, returning the validity time as the start time.

    default: assert(0 && "internal error, please report this bug");
  }

  // decode the time information and reencode it into an ISO-compliant string
  int year, month, day, hour, minute, second;
  cdiDecodeDate(date, &year, &month, &day);
  cdiDecodeTime(time, &hour, &minute, &second);
  size_t len = 4 + 1 + 2 + 1 + 2 + 1 + 2 + 1 + 2 + 1 + 2 + 4 + 1;
  char *result = (char *) Malloc(len);
  snprintf(result, len, "%04d-%02d-%02dT%02d:%02d:%02d.000", year, month, day, hour, minute, second);
  return result;
}

int
cdiFallbackIterator_levelType(CdiIterator *super, int levelSelector, char **outName, char **outLongName, char **outStdName,
                              char **outUnit)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  int zaxisId = vlistInqVarZaxis(me->vlistId, me->curVariable);
  (void) levelSelector;
#define copyString(outPointer, key)                                   \
  do {                                                                \
    if (outPointer)                                                   \
    {                                                                 \
      char tempBuffer[CDI_MAX_NAME];                                  \
      int length = CDI_MAX_NAME;                                      \
      cdiInqKeyString(zaxisId, CDI_GLOBAL, key, tempBuffer, &length); \
      *outPointer = strdup(tempBuffer);                               \
    }                                                                 \
  } while (0)
  copyString(outName, CDI_KEY_NAME);
  copyString(outLongName, CDI_KEY_LONGNAME);
  copyString(outStdName, CDI_KEY_STDNAME);
  copyString(outUnit, CDI_KEY_UNITS);
#undef copyString
  int ltype = 0;
  cdiInqKeyInt(zaxisId, CDI_GLOBAL, CDI_KEY_TYPEOFFIRSTFIXEDSURFACE, &ltype);
  return ltype;
}

int
cdiFallbackIterator_level(CdiIterator *super, int levelSelector, double *outValue1, double *outValue2)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  int zaxisId = vlistInqVarZaxis(me->vlistId, me->curVariable);

  // handle NULL pointers once and for all
  double trash;
  if (!outValue1) outValue1 = &trash;
  if (!outValue2) outValue2 = &trash;

  // get the level value
  if (levelSelector)
  {
    *outValue1 = (zaxisInqLbounds(zaxisId, NULL)) ? zaxisInqLbound(zaxisId, me->curLevel) : zaxisInqLevel(zaxisId, me->curLevel);
  }
  else
  {
    *outValue1 = (zaxisInqUbounds(zaxisId, NULL)) ? zaxisInqUbound(zaxisId, me->curLevel) : zaxisInqLevel(zaxisId, me->curLevel);
  }
  *outValue2 = 0.0;

  // if this is a hybrid zaxis, lookup the coordinates in the vertical coordinate table
  ssize_t intLevel = (ssize_t) (2 * *outValue1);
  if (0 <= intLevel && intLevel < zaxisInqVctSize(zaxisId) - 1)
  {
    const double *coordinateTable = zaxisInqVctPtr(zaxisId);
    *outValue1 = coordinateTable[intLevel];
    *outValue2 = coordinateTable[intLevel + 1];
  }
  return CDI_NOERR;
}

int
cdiFallbackIterator_zaxisUuid(CdiIterator *super, int *outVgridNumber, int *outLevelCount, unsigned char outUuid[CDI_UUID_SIZE])
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  int zaxisId = vlistInqVarZaxis(me->vlistId, me->curVariable);
  int ltype = 0;
  cdiInqKeyInt(zaxisId, CDI_GLOBAL, CDI_KEY_TYPEOFFIRSTFIXEDSURFACE, &ltype);
  if (ltype != ZAXIS_HYBRID) return CDI_EINVAL;
  if (outVgridNumber)
  {
    *outVgridNumber = 0;
    cdiInqKeyInt(zaxisId, CDI_GLOBAL, CDI_KEY_NUMBEROFVGRIDUSED, outVgridNumber);
  }
  if (outLevelCount)
  {
    *outLevelCount = 0;
    cdiInqKeyInt(zaxisId, CDI_GLOBAL, CDI_KEY_NLEV, outLevelCount);
  }
  if (outUuid)
  {
    int length = CDI_UUID_SIZE;
    memset(outUuid, 0, (size_t) length);
    cdiInqKeyBytes(zaxisId, CDI_GLOBAL, CDI_KEY_UUID, outUuid, &length);
  }
  return CDI_NOERR;
}

int
cdiFallbackIterator_inqTile(CdiIterator *super, int *outTileIndex, int *outTileAttribute)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  int dummy = 0;
  if (!outTileIndex) outTileIndex = &dummy;
  if (!outTileAttribute) outTileAttribute = &dummy;

  int error = CDI_NOERR;
  if (me->subtypeId == CDI_UNDEFID)  // must not call subtypeInqAttribute() with an invalid subtype ID, because it would abort the
                                     // program instead of returning an error
  {
    error = CDI_EINVAL;
  }
  else
  {
    if (subtypeInqAttribute(me->subtypeId, me->curSubtype, "tileIndex", outTileIndex)) error = CDI_EINVAL;
    if (subtypeInqAttribute(me->subtypeId, me->curSubtype, "tileAttribute", outTileAttribute)) error = CDI_EINVAL;
  }
  if (error) *outTileIndex = *outTileAttribute = -1;  // Guarantee defined values in case of an error.
  return error;
}

int
cdiFallbackIterator_inqTileCount(CdiIterator *super, int *outTileCount, int *outTileAttributeCount)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  int temp = 0;
  if (!outTileCount) outTileCount = &temp;
  if (!outTileAttributeCount) outTileAttributeCount = &temp;

  int error = CDI_NOERR;
  if (me->subtypeId == CDI_UNDEFID)  // must not call subtypeInqAttribute() with an invalid subtype ID, because it would abort the
                                     // program instead of returning an error
  {
    error = CDI_EINVAL;
  }
  else
  {
    if (subtypeInqAttribute(me->subtypeId, me->curSubtype, "numberOfTiles", outTileCount)) error = CDI_EINVAL;
    if (subtypeInqAttribute(me->subtypeId, me->curSubtype, "numberOfTileAttributes", outTileAttributeCount)) error = CDI_EINVAL;
  }
  if (error) *outTileCount = *outTileAttributeCount = -1;  // Guarantee defined values in case of an error.
  return CDI_NOERR;
}

char *
cdiFallbackIterator_copyVariableName(CdiIterator *super)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  return vlistCopyVarName(me->vlistId, me->curVariable);
}

void
cdiFallbackIterator_readField(CdiIterator *super, double *buffer, size_t *numMissVals)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  SizeType missingValues = 0;
  streamReadVarSlice(me->streamId, me->curVariable, me->curLevel, buffer, &missingValues);
  if (numMissVals) *numMissVals = (size_t) missingValues;
}

void
cdiFallbackIterator_readFieldF(CdiIterator *super, float *buffer, size_t *numMissVals)
{
  CdiFallbackIterator *me = (CdiFallbackIterator *) (void *) super;
  SizeType missingValues = 0;
  streamReadVarSliceF(me->streamId, me->curVariable, me->curLevel, buffer, &missingValues);
  if (numMissVals) *numMissVals = (size_t) missingValues;
}

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef STREAM_GRB_H
#define STREAM_GRB_H

double zaxis_units_to_centimeter(int zaxisID);
double zaxis_units_to_meter(int zaxisID);
bool zaxis_units_is_Pa(int zaxisID);

void ensureBufferSize(size_t requiredSize, size_t *curSize, void **buffer);
int grbDecompress(size_t recsize, size_t *buffersize, void **gribbuffer);

static inline void
grib_check_recsize(int version, size_t recsize)
{
  if (recsize > 0xFFFFFFFF) Error("GRIB%d record size=%zu limit exceeded (max=%zu)", version, recsize, 0xFFFFFFFF);
}

static inline bool
gribbyte_get_bit(int number, int bit)
{
  return (bool) ((number >> (8 - bit)) & 1);
}
static inline void
gribbyte_set_bit(int *number, int bit)
{
  *number |= 1 << (8 - bit);
}
static inline void
gribbyte_clear_bit(int *number, int bit)
{
  *number &= ~(1 << (8 - bit));
}

int grbBitsPerValue(int datatype);

int fdbInqContents(stream_t *streamptr);
long grbInqContents(stream_t *streamptr);
int fdbInqTimestep(stream_t *streamptr, int tsID);
int grbInqTimestep(stream_t *streamptr, int tsID);

void grbDefField(stream_t *streamptr);
void grb_read_field(stream_t *streamptr, int memtype, void *data, size_t *numMissVals);
void grb_write_field(stream_t *streamptr, int memtype, const void *data, size_t numMissVals);
void grbCopyField(stream_t *streamptr2, stream_t *streamptr1);

void grb_read_var(stream_t *streamptr, int varID, int memtype, void *data, size_t *numMissVals);
void grb_write_var(stream_t *streamptr, int varID, int memtype, const void *data, size_t numMissVals);

void grb_read_var_slice(stream_t *streamptr, int varID, int levelID, int memtype, void *data, size_t *numMissVals);
void grb_write_var_slice(stream_t *streamptr, int varID, int levelID, int memtype, const void *data, size_t numMissVals);

int grib1ltypeToZaxisType(int grib_ltype);
int grib2ltypeToZaxisType(int grib_ltype);

int zaxisTypeToGrib1ltype(int zaxistype);
int zaxisTypeToGrib2ltype(int zaxistype);

int grbGetGridtype(int *gridID, SizeType gridsize, bool *gridIsRotated, bool *gridIsCurvilinear);

struct cdiGribParamChange
{
  int code, ltype, lev;
  bool active;
};

struct cdiGribScanModeChange
{
  int value;
  bool active;
};

extern struct cdiGribParamChange cdiGribChangeParameterID;
extern struct cdiGribScanModeChange cdiGribDataScanningMode;

// Used in CDO
void streamGrbChangeParameterIdentification(int code, int ltype, int lev);
void streamGrbDefDataScanningMode(int scanmode);

#endif /* STREAM_GRB_H */
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifndef ZAXIS_H
#define ZAXIS_H

#ifdef HAVE_CONFIG_H
#endif


// clang-format off
typedef struct
{
  double    *vals;
#ifndef USE_MPI
  char     **cvals;
  int        clength;
#endif
  double    *lbounds;
  double    *ubounds;
  double    *weights;
  int        self;
  int        scalar;
  int        type;
  int        size;
  int        direction;
  int        vctsize;
  unsigned   positive;
  double    *vct;
  cdi_keys_t keys;
  cdi_atts_t atts;
}
zaxis_t;
// clang-format on

void zaxisGetTypeDescription(int zaxisType, int *outPositive, const char **outName, const char **outLongName,
                             const char **outStdName,
                             const char **outUnit);  // The returned const char* point to static storage. Don't free or modify them.

unsigned cdiZaxisCount(void);

zaxis_t *zaxis_to_pointer(int zaxisID);

void cdiZaxisGetIndexList(unsigned numIDs, int *IDs);

int zaxisUnpack(char *unpackBuffer, int unpackBufferSize, int *unpackBufferPos, int originNamespace, void *context, int force_id);

const resOps *getZaxisOps(void);

const char *zaxisInqNamePtr(int zaxisID);

const double *zaxisInqLevelsPtr(int zaxisID);
#ifndef USE_MPI
char **zaxisInqCValsPtr(int zaxisID);
#endif
void zaxisResize(int zaxisID, int size);

#endif

/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
#ifdef HAVE_CONFIG_H
#endif



#include <assert.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_LIBGRIB_API

struct CdiGribIterator
{
  CdiIterator super;

  CdiInputFile *file;
  off_t fileOffset;
  unsigned char *gribBuffer;
  size_t bufferSize, curRecordSize;
  grib_handle *gribHandle;
};

CdiIterator *
cdiGribIterator_getSuper(CdiGribIterator *me)
{
  return &me->super;
}

// Since the error handling in constructors is usually very closely related to the workings of a destructor,
// this function combines both functions in one, using a centralized exit.
// The mode of operation depends on whether me is a NULL pointer on entry:
// If it is NULL, a new object is allocated and constructed, which is returned if construction is successful.
// If a non-NULL pointer is passed in, the object is destructed and NULL is returned. In this case, the other arguments are ignored.
static CdiGribIterator *
cdiGribIterator_condestruct(CdiGribIterator *me, const char *path, int filetype)
{
#define super() (&me->super)
  if (me) goto destruct;
  me = (CdiGribIterator *) Malloc(sizeof(*me));
  baseIterConstruct(super(), filetype);

  me->file = cdiInputFile_make(path);
  if (!me->file) goto destructSuper;
  me->fileOffset = 0;
  me->gribHandle = NULL;
  me->gribBuffer = NULL;
  me->bufferSize = me->curRecordSize = 0;
  me->super.gridId = CDI_UNDEFID;

  goto success;

  // ^        constructor code        ^
  // |                                |
  // v destructor/error-cleanup code  v

destruct:
  if (me->super.gridId != CDI_UNDEFID) gridDestroy(me->super.gridId);
  if (me->gribHandle) grib_handle_delete((struct grib_handle *) me->gribHandle);
  Free(me->gribBuffer);
  cdiRefObject_release(&me->file->super);
destructSuper:
  baseIterDestruct(super());
  Free(me);
  me = NULL;

success:
  return me;
#undef super
}

CdiIterator *
cdiGribIterator_new(const char *path, int filetype)
{
  return &cdiGribIterator_condestruct(NULL, path, filetype)->super;
}

CdiGribIterator *
cdiGribIterator_makeClone(CdiIterator *super)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;

  // Allocate memory and copy data. (operations that may fail)
  CdiGribIterator *result = (struct CdiGribIterator *) Malloc(sizeof(*result));
  if (!result) goto fail;

  result->file = me->file;
  result->fileOffset = me->fileOffset;
  result->gribBuffer = NULL;
  result->bufferSize = me->bufferSize;
  result->curRecordSize = me->curRecordSize;
  result->gribHandle = NULL;

  if (me->gribBuffer)
  {
    result->gribBuffer = (unsigned char *) Malloc(me->bufferSize);
    if (!result->gribBuffer) goto freeResult;
    memcpy(result->gribBuffer, me->gribBuffer, me->curRecordSize);
  }
  if (me->gribHandle)
  {
    result->gribHandle = grib_handle_new_from_message(NULL, result->gribBuffer, result->curRecordSize);
    if (!result->gribHandle) goto freeBuffer;
  }
  if (super->gridId != CDI_UNDEFID)
  {
    result->super.gridId = gridDuplicate(super->gridId);
    if (result->super.gridId == CDI_UNDEFID) goto deleteGribHandle;
  }

  // Finish construction. (operations that cannot fail)
  baseIterConstruct(&result->super, super->filetype);
  result->super.datatype = super->datatype;
  result->super.timesteptype = super->timesteptype;
  result->super.param = super->param;
  cdiRefObject_retain(&result->file->super);

  return result;

  // Error handling.
deleteGribHandle:
  if (result->gribHandle) grib_handle_delete(result->gribHandle);
freeBuffer:
  Free(result->gribBuffer);
freeResult:
  Free(result);
fail:
  return NULL;
}

char *
cdiGribIterator_serialize(CdiIterator *super)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;

  const char *path = cdiInputFile_getPath(me->file);
  char *escapedPath = cdiEscapeSpaces(path);
  size_t len = strlen(escapedPath) + 3 * sizeof(int) * CHAR_BIT / 8;
  char *result = (char *) Malloc(len);
  snprintf(result, len, "%s %zu", escapedPath, (size_t) me->fileOffset);
  Free(escapedPath);
  return result;
}

CdiGribIterator *
cdiGribIterator_deserialize(const char *description)
{
  char *path;
  CdiGribIterator *me = (CdiGribIterator *) Malloc(sizeof(*me));
  if (!me) goto fail;

  description = baseIter_constructFromString(&me->super, description);

  while (*description == ' ') description++;
  path = cdiUnescapeSpaces(description, &description);
  if (!path) goto destructSuper;

  me->file = cdiInputFile_make(path);
  Free(path);
  if (!me->file) goto destructSuper;

  {
    const char *savedStart = description;
    char *description_ = (char *) description;
    long long decodedOffset = strtoll(description, &description_, 0);
    description = description_;
    me->fileOffset = (off_t) decodedOffset;
    if (savedStart == description) goto closeFile;
    if ((unsigned long long) decodedOffset > (unsigned long long) me->fileOffset) goto closeFile;
  }

  me->gribBuffer = NULL;
  me->bufferSize = me->curRecordSize = 0;
  me->gribHandle = NULL;
  me->super.gridId = CDI_UNDEFID;
  if (me->super.isAdvanced && cdiGribIterator_nextField(&me->super)) goto closeFile;

  return me;

closeFile:
  cdiRefObject_release(&me->file->super);
destructSuper:
  baseIterDestruct(&me->super);
  Free(me);
fail:
  return NULL;
}

static void
cdiGribIterator_ensureBuffer(CdiGribIterator *me, size_t requiredSize)
{
  if (me->bufferSize < requiredSize)
  {
    me->bufferSize *= 2;
    if (me->bufferSize < requiredSize) me->bufferSize = requiredSize;
    me->gribBuffer = (unsigned char *) Realloc(me->gribBuffer, me->bufferSize);
  }
}

static bool
isGrib1DualLevel(int levelType)
{
  switch (levelType)
  {
    case 101:
    case 104:
    case 106:
    case 108:
    case 110:
    case 112:
    case 114:
    case 116:
    case 120:
    case 121:
    case 128:
    case 141:  // This is the complete list after grib_api-1.12.3/definitions/grib1/sections.1.def:106-117:, the code in
               // cdi/src/stream_gribapi.c:grib1GetLevel() seems to be incomplete.
      return true;
    default: return false;
  }
}

static const unsigned char *
positionOfGribMarker(const unsigned char *data, size_t size)
{
  for (const unsigned char *currentPosition = data, *end = data + size; currentPosition < end; currentPosition++)
  {
    currentPosition = (unsigned char *) memchr(currentPosition, 'G',
                                               size - (size_t) (currentPosition - data)
                                                   - 3);  //-3 to ensure that we don't overrun the buffer during the strncmp() call.
    if (!currentPosition) return NULL;
    if (!strncmp((const char *) currentPosition, "GRIB", 4)) return currentPosition;
  }
  return NULL;
}

// This clobbers the contents of the gribBuffer!
// Returns the file offset of the next 'GRIB' marker.
static ssize_t
scanToGribMarker(CdiGribIterator *me)
{
  cdiGribIterator_ensureBuffer(me, 8 * 1024);
  const size_t kMaxScanSize = 16 * 1024 * 1024;
  for (size_t scannedBytes = 0, scanSize; scannedBytes < kMaxScanSize; scannedBytes += scanSize)
  {
    // Load a chunk of data into our buffer.
    scanSize = me->bufferSize;
    if (scannedBytes + scanSize > kMaxScanSize) scanSize = kMaxScanSize - scannedBytes;
    assert(scanSize <= me->bufferSize);
    int status = cdiInputFile_read(me->file, me->fileOffset + (off_t) scannedBytes, scanSize, &scanSize, me->gribBuffer);
    if (status != CDI_NOERR && status != CDI_EEOF) return -1;

    const unsigned char *startPosition = positionOfGribMarker(me->gribBuffer, scanSize);
    if (startPosition) { return (ssize_t) (me->fileOffset + (off_t) scannedBytes + (off_t) (startPosition - me->gribBuffer)); }

    // Get the offset for the next iteration if there is a next iteration.
    scanSize -= 3;                           // so that we won't miss a 'GRIB' sequence that happens to be cut off
    scanSize &= ~(size_t) 0xf;               // make 16 bytes aligned
    if ((ssize_t) scanSize <= 0) return -1;  // ensure that we make progress
  }
  return -1;
}

static unsigned
decode24(void *beData)
{
  unsigned char *bytes = (unsigned char *) beData;
  return ((unsigned) bytes[0] << 16) + ((unsigned) bytes[1] << 8) + (unsigned) bytes[2];
}

static uint64_t
decode64(void *beData)
{
  unsigned char *bytes = (unsigned char *) beData;
  uint64_t result = 0;
  for (size_t i = 0; i < 8; i++) result = (result << 8) + bytes[i];
  return result;
}

// Determine the size of the GRIB record that begins at the given file offset.
static int
getRecordSize(CdiGribIterator *me, off_t gribFileOffset, size_t *outRecordSize)
{
  char buffer[16];
  size_t readSize;
  int status = cdiInputFile_read(me->file, gribFileOffset, sizeof(buffer), &readSize, buffer);
  if (status != CDI_NOERR && status != CDI_EEOF) return status;
  if (readSize < sizeof(buffer)) return CDI_EEOF;
  *outRecordSize = 0;
  switch (buffer[7])
  {
    case 1:
      *outRecordSize = decode24(&buffer[4]);
      if (*outRecordSize & (1 << 23))
      {
        *outRecordSize = 120 * (*outRecordSize & ((1 << 23) - 1));  // Rescaling for long records.
        // The corresponding code in cgribexlib.c:4532-4570: is much more complicated
        // due to the fact that it subtracts the padding bytes that are inserted after section 4.
        // However, we are only interested in the total size of data we need to read here,
        // so we can ignore the presence of some padding bytes.
      }
      return CDI_NOERR;

    case 2: *outRecordSize = decode64(&buffer[8]); return CDI_NOERR;

    default: return CDI_EUFTYPE;
  }
}

#if 0
static void hexdump(void *data, size_t size)
{
  unsigned char *charData = data;
  for(size_t offset = 0; offset < size; )
    {
      printf("%016zx:", offset);
      for(size_t i = 0; i < 64 && offset < size; i++, offset++)
        {
          if((i & 63) && !(i & 15)) printf(" |");
          if((i & 15) && !(i & 3)) printf("  ");
          printf(" %02x", charData[offset]);
        }
      printf("\n");
    }
}
#endif

// Read a record into memory and wrap it in a grib_handle.
// XXX: I have omitted checking for szip compression as it is done in grbReadVarDP() & friends since that appears to be a
// non-standard extension of the GRIB1 standard: bit 1 in octet 14 of the binary data section which is used to signal szip
// compression is defined to be reserved in the standard. As such, it seems prudent not to support this and to encourage people with
// such szip compressed files to switch to the GRIB2/JPEG2000 format. However, in the case that this reasoning is wrong, this
// function is probably the place to add the check for zsip compression.
static int
readMessage(CdiGribIterator *me)
{
  // Destroy the old grib_handle.
  if (me->gribHandle) grib_handle_delete(me->gribHandle), me->gribHandle = NULL;
  me->fileOffset += (off_t) me->curRecordSize;

  // Find the next record and determine its size.
  ssize_t gribFileOffset = scanToGribMarker(me);
  int result = CDI_EEOF;
  if (gribFileOffset < 0) goto fail;
  result = getRecordSize(me, gribFileOffset, &me->curRecordSize);
  if (result) goto fail;

  // Load the whole record into our buffer and create a grib_handle for it.
  cdiGribIterator_ensureBuffer(me, me->curRecordSize);
  result = cdiInputFile_read(me->file, gribFileOffset, me->curRecordSize, NULL, me->gribBuffer);
  if (result) goto fail;
  me->gribHandle = grib_handle_new_from_message(NULL, me->gribBuffer, me->curRecordSize);
  result = CDI_EUFSTRUCT;
  if (!me->gribHandle) goto fail;

  return CDI_NOERR;

fail:
  me->curRecordSize = 0;  // This ensures that we won't jump to an uncontrolled file position if cdiGribIterator_nextField() is
                          // called another time after it has returned an error.
  return result;
}

int
cdiGribIterator_nextField(CdiIterator *super)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;

  if (super->gridId != CDI_UNDEFID) gridDestroy(super->gridId), super->gridId = CDI_UNDEFID;

  // Get the next GRIB message into our buffer.
  int result = readMessage(me);
  if (result) return result;

  // Get the metadata that's published as variables in the base class.
  super->datatype = gribGetDatatype(me->gribHandle);
  super->timesteptype = gribapiGetTsteptype(me->gribHandle);
  cdiDecodeParam(gribapiGetParam(me->gribHandle), &super->param.number, &super->param.category, &super->param.discipline);
  grid_t grid;
  gribapiGetGrid(me->gribHandle, &grid);
  super->gridId = gridGenerate(&grid);

  return CDI_NOERR;
}

char *
cdiGribIterator_inqTime(CdiIterator *super, CdiTimeType timeType)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;
  return gribMakeTimeString(me->gribHandle, timeType);
}

int
cdiGribIterator_levelType(CdiIterator *super, int levelSelector, char **outName, char **outLongName, char **outStdName,
                          char **outUnit)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;

  // First determine the zaxis type corresponding to the given level.
  int zaxisType = ZAXIS_GENERIC;
  if (gribEditionNumber(me->gribHandle) <= 1)
  {
    int levelType = (int) gribGetLongDefault(me->gribHandle, "indicatorOfTypeOfLevel", 255);
    if (levelSelector && !isGrib1DualLevel(levelType)) levelType = 255;
    zaxisType = grib1ltypeToZaxisType(levelType);
  }
  else
  {
    int levelType
        = (int) gribGetLongDefault(me->gribHandle, levelSelector ? "typeOfSecondFixedSurface" : "typeOfFirstFixedSurface", 255);
    zaxisType = grib2ltypeToZaxisType(levelType);
  }

  // Then lookup the requested names.
  const char *name, *longName, *stdName, *unit;
  zaxisGetTypeDescription(zaxisType, NULL, &name, &longName, &stdName, &unit);
  if (outName) *outName = strdup(name);
  if (outLongName) *outLongName = strdup(longName);
  if (outStdName) *outStdName = strdup(stdName);
  if (outUnit) *outUnit = strdup(unit);

  return zaxisType;
}

static double
logicalLevelValue2(long gribType, long storedValue, long power)
{
  double factor = 1;
  assert(power >= 0);
  while (power--) factor *= 10;  // this is precise up to factor == 22.
  switch (gribType)
  {
    case GRIB2_LTYPE_LANDDEPTH:
    case GRIB2_LTYPE_ISOBARIC:
    case GRIB2_LTYPE_SIGMA:
      return (double) storedValue
             * (1000.0 / factor);  // The evaluation order allows the factors of ten to cancel out before rounding.

    case 255: return 0;

    default: return (double) storedValue / factor;
  }
}

// The output values must be preinitialized, this function does not always write them.
static int
readLevel2(grib_handle *gribHandle, const char *levelTypeKey, const char *powerKey, const char *valueKey, double *outValue1,
           double *outValue2)
{
  assert(levelTypeKey && powerKey && valueKey && outValue1 && outValue2);

  long levelType = gribGetLongDefault(gribHandle, levelTypeKey, 255);  // 1 byte
  switch (levelType)
  {
    case 255: break;

    case 105:
    case 113:
    {
      unsigned long value = (unsigned long) gribGetLongDefault(gribHandle, valueKey, 0);
      unsigned long coordinateCount = (unsigned long) gribGetLongDefault(gribHandle, "numberOfCoordinatesValues", 0);
      if (value >= coordinateCount / 2)
      {
        Error("Invalid level coordinate: Level has the hybrid coordinate index %lu, but only %lu coordinate pairs are present.",
              value, coordinateCount / 2);
        return CDI_EUFSTRUCT;
      }
      int status;
      // XXX: I'm not 100% sure about how the coordinate pairs are stored in the file.
      //     I'm assuming an array of pairs due to the example code in grib_api-1.12.3/examples/F90/set_pv.f90, but that may be
      //     wrong.
      if ((status = grib_get_double_element(gribHandle, "pv", (int) value * 2, outValue1))) return status;
      if ((status = grib_get_double_element(gribHandle, "pv", (int) value * 2 + 1, outValue2))) return status;
      break;
    }

    default:
    {
      long power = 255 & gribGetLongDefault(gribHandle, powerKey, 0);  // 1 byte
      if (power == 255) power = 0;
      long value = gribGetLongDefault(gribHandle, valueKey, 0);  // 4 bytes
      *outValue1 = logicalLevelValue2(levelType, value, power);
    }
  }
  return CDI_NOERR;
}

int
cdiGribIterator_level(CdiIterator *super, int levelSelector, double *outValue1, double *outValue2)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;
  double trash;
  if (!outValue1) outValue1 = &trash;
  if (!outValue2) outValue2 = &trash;
  *outValue1 = *outValue2 = 0;

  if (gribEditionNumber(me->gribHandle) > 1)
  {
    if (levelSelector)
    {
      return readLevel2(me->gribHandle, "typeOfFirstFixedSurface", "scaleFactorOfFirstFixedSurface",
                        "scaledValueOfFirstFixedSurface", outValue1, outValue2);
    }
    else
    {
      return readLevel2(me->gribHandle, "typeOfSecondFixedSurface", "scaleFactorOfSecondFixedSurface",
                        "scaledValueOfSecondFixedSurface", outValue1, outValue2);
    }
  }
  else
  {
    long levelType = (uint8_t) gribGetLongDefault(me->gribHandle, "indicatorOfTypeOfLevel", -1);  // 1 byte
    if (levelType == 255) {}
    else if (isGrib1DualLevel((int) levelType))
    {
      *outValue1 = (double) (gribGetLongDefault(me->gribHandle, (levelSelector ? "bottomLevel" : "topLevel"), 0));
    }
    else if (levelType == 100)
    {
      *outValue1 = 100 * (double) (gribGetLongDefault(me->gribHandle, "level", 0));  // 2 bytes
    }
    else
    {
      *outValue1 = (double) (gribGetLongDefault(me->gribHandle, "level", 0));  // 2 bytes
    }
  }
  return CDI_NOERR;
}

int
cdiGribIterator_zaxisUuid(CdiIterator *super, int *outVgridNumber, int *outLevelCount, unsigned char outUuid[CDI_UUID_SIZE])
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;

  if (outVgridNumber)
  {
    long temp;
    if (grib_get_long(me->gribHandle, "numberOfVGridUsed", &temp)) return CDI_EINVAL;
    *outVgridNumber = (int) temp;
  }
  if (outLevelCount)
  {
    long temp;
    if (grib_get_long(me->gribHandle, "nlev", &temp)) return CDI_EINVAL;
    *outLevelCount = (int) temp;
  }
  if (outUuid)
  {
    size_t size = CDI_UUID_SIZE;
    if (grib_get_bytes(me->gribHandle, "uuidOfVGrid", outUuid, &size)) return CDI_EINVAL;
    if (size != CDI_UUID_SIZE) return CDI_EUFSTRUCT;
  }

  return CDI_NOERR;
}

int
cdiGribIterator_inqTile(CdiIterator *super, int *outTileIndex, int *outTileAttribute)
{
  CdiGribIterator *me = (CdiGribIterator *) (void *) super;
  int trash;
  if (!outTileIndex) outTileIndex = &trash;
  if (!outTileAttribute) outTileAttribute = &trash;

  // Get the values if possible.
  int error = CDI_NOERR;
  long value;
  if (grib_get_long(me->gribHandle, "tileIndex", &value)) error = CDI_EINVAL;
  *outTileIndex = (int) value;
 