/****************************************************************************
 *    lib/b/FluentDefinition.cpp - This file is part of coala				*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "FluentDefinition.h"

using namespace B;

B::FluentDefinition::FluentDefinition(int line, Formula* fluent_list, bool defined, Types* types) : Statement(line, types),
																						C::FluentDefinition(line, fluent_list, types) {
	defined_ = defined;
}

B::FluentDefinition::~FluentDefinition ( ) { }

void B::FluentDefinition::print(Printer* p, bool ltl=false) {
	p->add("% fluent definition\n");
	C::FluentDefinition::print(p, ltl);

	p->setSection('c');



	for(vector<Formula*>::iterator n = F_->begin(); n != F_->end(); ++n) {
		FluentAction* f = (FluentAction*) *n;

		string fluent = f->print(p);
		set<Variable*>* vars = f->getVariables();

		if(not defined_) {
			p->add("% inertial rules\n");

			p->add("holds(" + fluent + ", " + p->T + ") :- ");
			p->add("holds(" + fluent + ", " + p->T + "-1), ");
			p->add("not holds(" + p->neg + fluent + ", " + p->T + ")");

			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}

			p->add(".\n");
			p->add("holds(" + p->neg + fluent + ", " + p->T + ") :- ");
			p->add("holds(" + p->neg + fluent + ", " + p->T + "-1), ");
			p->add("not holds(" + fluent + ", " + p->T + ")");

			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");
		}

		// print the constraint twice: for T=0 and T>0
		for(int i = 1; i <= 2; ++i) {
			string T;
			if(i == 1) {
				p->setSection('b');
				T = "0";
			}
			else {
				p->setSection('c');
				T = p->T;
			}

			if(defined_) {
				p->add("\n% Closed world assumptions for defined fluent\n");
				p->add("holds(" + p->neg + fluent + ", " + T + ") :- ");
				p->add("not holds(" + fluent + ", " + T + ")");
				if(!vars->empty()) {
					p->add(", ");
					types_.print(p, vars, line_);
				}
				p->add(".\n");
			}

			p->add("\n% exclusivity constraint\n");
			p->add(":- holds(" + fluent + ", " + T + "), ");
			p->add("holds(" + p->neg + fluent + ", " + T + ")");
			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");
		}

	}
}
