///////////////////////////////////////////////////////////////////////////////
// Name:        pdfglyphnames.inc
// Purpose:     Definition of glyph names
// Author:      Ulrich Telle
// Created:     2009-06-24
// Copyright:   (c) Ulrich Telle
// Licence:     wxWindows licence
///////////////////////////////////////////////////////////////////////////////

/// \file pdfglyphnames.inc Definition of glyph names.

typedef struct _wxGlyphDesc
{
  int           unicode;
  const wxChar* glyphname;
} wxGlyphDesc;

static const wxGlyphDesc gs_glyphName2UnicodeTable[] =
{
  { 0x0041, wxS("A") },
  { 0x00C6, wxS("AE") },
  { 0x01FC, wxS("AEacute") },
  { 0x01E2, wxS("AEmacron") },
  { 0xF7E6, wxS("AEsmall") },
  { 0x00C1, wxS("Aacute") },
  { 0xF7E1, wxS("Aacutesmall") },
  { 0x0102, wxS("Abreve") },
  { 0x1EAE, wxS("Abreveacute") },
  { 0x04D0, wxS("Abrevecyrillic") },
  { 0x1EB6, wxS("Abrevedotbelow") },
  { 0x1EB0, wxS("Abrevegrave") },
  { 0x1EB2, wxS("Abrevehookabove") },
  { 0x1EB4, wxS("Abrevetilde") },
  { 0x01CD, wxS("Acaron") },
  { 0x24B6, wxS("Acircle") },
  { 0x00C2, wxS("Acircumflex") },
  { 0x1EA4, wxS("Acircumflexacute") },
  { 0x1EAC, wxS("Acircumflexdotbelow") },
  { 0x1EA6, wxS("Acircumflexgrave") },
  { 0x1EA8, wxS("Acircumflexhookabove") },
  { 0xF7E2, wxS("Acircumflexsmall") },
  { 0x1EAA, wxS("Acircumflextilde") },
  { 0xF6C9, wxS("Acute") },
  { 0xF7B4, wxS("Acutesmall") },
  { 0x0410, wxS("Acyrillic") },
  { 0x0200, wxS("Adblgrave") },
  { 0x00C4, wxS("Adieresis") },
  { 0x04D2, wxS("Adieresiscyrillic") },
  { 0x01DE, wxS("Adieresismacron") },
  { 0xF7E4, wxS("Adieresissmall") },
  { 0x1EA0, wxS("Adotbelow") },
  { 0x01E0, wxS("Adotmacron") },
  { 0x00C0, wxS("Agrave") },
  { 0xF7E0, wxS("Agravesmall") },
  { 0x1EA2, wxS("Ahookabove") },
  { 0x04D4, wxS("Aiecyrillic") },
  { 0x0202, wxS("Ainvertedbreve") },
  { 0x0391, wxS("Alpha") },
  { 0x0386, wxS("Alphatonos") },
  { 0x0100, wxS("Amacron") },
  { 0xFF21, wxS("Amonospace") },
  { 0x0104, wxS("Aogonek") },
  { 0x00C5, wxS("Aring") },
  { 0x01FA, wxS("Aringacute") },
  { 0x1E00, wxS("Aringbelow") },
  { 0xF7E5, wxS("Aringsmall") },
  { 0xF761, wxS("Asmall") },
  { 0x00C3, wxS("Atilde") },
  { 0xF7E3, wxS("Atildesmall") },
  { 0x0531, wxS("Aybarmenian") },
  { 0x0042, wxS("B") },
  { 0x24B7, wxS("Bcircle") },
  { 0x1E02, wxS("Bdotaccent") },
  { 0x1E04, wxS("Bdotbelow") },
  { 0x0411, wxS("Becyrillic") },
  { 0x0532, wxS("Benarmenian") },
  { 0x0392, wxS("Beta") },
  { 0x0181, wxS("Bhook") },
  { 0x1E06, wxS("Blinebelow") },
  { 0xFF22, wxS("Bmonospace") },
  { 0xF6F4, wxS("Brevesmall") },
  { 0xF762, wxS("Bsmall") },
  { 0x0182, wxS("Btopbar") },
  { 0x0043, wxS("C") },
  { 0x053E, wxS("Caarmenian") },
  { 0x0106, wxS("Cacute") },
  { 0xF6CA, wxS("Caron") },
  { 0xF6F5, wxS("Caronsmall") },
  { 0x010C, wxS("Ccaron") },
  { 0x00C7, wxS("Ccedilla") },
  { 0x1E08, wxS("Ccedillaacute") },
  { 0xF7E7, wxS("Ccedillasmall") },
  { 0x24B8, wxS("Ccircle") },
  { 0x0108, wxS("Ccircumflex") },
  { 0x010A, wxS("Cdot") },
  { 0x010A, wxS("Cdotaccent") },
  { 0xF7B8, wxS("Cedillasmall") },
  { 0x0549, wxS("Chaarmenian") },
  { 0x04BC, wxS("Cheabkhasiancyrillic") },
  { 0x0427, wxS("Checyrillic") },
  { 0x04BE, wxS("Chedescenderabkhasiancyrillic") },
  { 0x04B6, wxS("Chedescendercyrillic") },
  { 0x04F4, wxS("Chedieresiscyrillic") },
  { 0x0543, wxS("Cheharmenian") },
  { 0x04CB, wxS("Chekhakassiancyrillic") },
  { 0x04B8, wxS("Cheverticalstrokecyrillic") },
  { 0x03A7, wxS("Chi") },
  { 0x0187, wxS("Chook") },
  { 0xF6F6, wxS("Circumflexsmall") },
  { 0xFF23, wxS("Cmonospace") },
  { 0x0551, wxS("Coarmenian") },
  { 0xF763, wxS("Csmall") },
  { 0x0044, wxS("D") },
  { 0x01F1, wxS("DZ") },
  { 0x01C4, wxS("DZcaron") },
  { 0x0534, wxS("Daarmenian") },
  { 0x0189, wxS("Dafrican") },
  { 0x010E, wxS("Dcaron") },
  { 0x1E10, wxS("Dcedilla") },
  { 0x24B9, wxS("Dcircle") },
  { 0x1E12, wxS("Dcircumflexbelow") },
  { 0x0110, wxS("Dcroat") },
  { 0x1E0A, wxS("Ddotaccent") },
  { 0x1E0C, wxS("Ddotbelow") },
  { 0x0414, wxS("Decyrillic") },
  { 0x03EE, wxS("Deicoptic") },
  { 0x0394, wxS("Delta") },
  { 0x0394, wxS("Deltagreek") },
  { 0x018A, wxS("Dhook") },
  { 0xF6CB, wxS("Dieresis") },
  { 0xF6CC, wxS("DieresisAcute") },
  { 0xF6CD, wxS("DieresisGrave") },
  { 0xF7A8, wxS("Dieresissmall") },
  { 0x03DC, wxS("Digammagreek") },
  { 0x0402, wxS("Djecyrillic") },
  { 0x1E0E, wxS("Dlinebelow") },
  { 0xFF24, wxS("Dmonospace") },
  { 0xF6F7, wxS("Dotaccentsmall") },
  { 0x0110, wxS("Dslash") },
  { 0xF764, wxS("Dsmall") },
  { 0x018B, wxS("Dtopbar") },
  { 0x01F2, wxS("Dz") },
  { 0x01C5, wxS("Dzcaron") },
  { 0x04E0, wxS("Dzeabkhasiancyrillic") },
  { 0x0405, wxS("Dzecyrillic") },
  { 0x040F, wxS("Dzhecyrillic") },
  { 0x0045, wxS("E") },
  { 0x00C9, wxS("Eacute") },
  { 0xF7E9, wxS("Eacutesmall") },
  { 0x0114, wxS("Ebreve") },
  { 0x011A, wxS("Ecaron") },
  { 0x1E1C, wxS("Ecedillabreve") },
  { 0x0535, wxS("Echarmenian") },
  { 0x24BA, wxS("Ecircle") },
  { 0x00CA, wxS("Ecircumflex") },
  { 0x1EBE, wxS("Ecircumflexacute") },
  { 0x1E18, wxS("Ecircumflexbelow") },
  { 0x1EC6, wxS("Ecircumflexdotbelow") },
  { 0x1EC0, wxS("Ecircumflexgrave") },
  { 0x1EC2, wxS("Ecircumflexhookabove") },
  { 0xF7EA, wxS("Ecircumflexsmall") },
  { 0x1EC4, wxS("Ecircumflextilde") },
  { 0x0404, wxS("Ecyrillic") },
  { 0x0204, wxS("Edblgrave") },
  { 0x00CB, wxS("Edieresis") },
  { 0xF7EB, wxS("Edieresissmall") },
  { 0x0116, wxS("Edot") },
  { 0x0116, wxS("Edotaccent") },
  { 0x1EB8, wxS("Edotbelow") },
  { 0x0424, wxS("Efcyrillic") },
  { 0x00C8, wxS("Egrave") },
  { 0xF7E8, wxS("Egravesmall") },
  { 0x0537, wxS("Eharmenian") },
  { 0x1EBA, wxS("Ehookabove") },
  { 0x2167, wxS("Eightroman") },
  { 0x0206, wxS("Einvertedbreve") },
  { 0x0464, wxS("Eiotifiedcyrillic") },
  { 0x041B, wxS("Elcyrillic") },
  { 0x216A, wxS("Elevenroman") },
  { 0x0112, wxS("Emacron") },
  { 0x1E16, wxS("Emacronacute") },
  { 0x1E14, wxS("Emacrongrave") },
  { 0x041C, wxS("Emcyrillic") },
  { 0xFF25, wxS("Emonospace") },
  { 0x041D, wxS("Encyrillic") },
  { 0x04A2, wxS("Endescendercyrillic") },
  { 0x014A, wxS("Eng") },
  { 0x04A4, wxS("Enghecyrillic") },
  { 0x04C7, wxS("Enhookcyrillic") },
  { 0x0118, wxS("Eogonek") },
  { 0x0190, wxS("Eopen") },
  { 0x0395, wxS("Epsilon") },
  { 0x0388, wxS("Epsilontonos") },
  { 0x0420, wxS("Ercyrillic") },
  { 0x018E, wxS("Ereversed") },
  { 0x042D, wxS("Ereversedcyrillic") },
  { 0x0421, wxS("Escyrillic") },
  { 0x04AA, wxS("Esdescendercyrillic") },
  { 0x01A9, wxS("Esh") },
  { 0xF765, wxS("Esmall") },
  { 0x0397, wxS("Eta") },
  { 0x0538, wxS("Etarmenian") },
  { 0x0389, wxS("Etatonos") },
  { 0x00D0, wxS("Eth") },
  { 0xF7F0, wxS("Ethsmall") },
  { 0x1EBC, wxS("Etilde") },
  { 0x1E1A, wxS("Etildebelow") },
  { 0x20AC, wxS("Euro") },
  { 0x01B7, wxS("Ezh") },
  { 0x01EE, wxS("Ezhcaron") },
  { 0x01B8, wxS("Ezhreversed") },
  { 0x0046, wxS("F") },
  { 0x24BB, wxS("Fcircle") },
  { 0x1E1E, wxS("Fdotaccent") },
  { 0x0556, wxS("Feharmenian") },
  { 0x03E4, wxS("Feicoptic") },
  { 0x0191, wxS("Fhook") },
  { 0x0472, wxS("Fitacyrillic") },
  { 0x2164, wxS("Fiveroman") },
  { 0xFF26, wxS("Fmonospace") },
  { 0x2163, wxS("Fourroman") },
  { 0xF766, wxS("Fsmall") },
  { 0x0047, wxS("G") },
  { 0x3387, wxS("GBsquare") },
  { 0x01F4, wxS("Gacute") },
  { 0x0393, wxS("Gamma") },
  { 0x0194, wxS("Gammaafrican") },
  { 0x03EA, wxS("Gangiacoptic") },
  { 0x011E, wxS("Gbreve") },
  { 0x01E6, wxS("Gcaron") },
  { 0x0122, wxS("Gcedilla") },
  { 0x24BC, wxS("Gcircle") },
  { 0x011C, wxS("Gcircumflex") },
  { 0x0122, wxS("Gcommaaccent") },
  { 0x0120, wxS("Gdot") },
  { 0x0120, wxS("Gdotaccent") },
  { 0x0413, wxS("Gecyrillic") },
  { 0x0542, wxS("Ghadarmenian") },
  { 0x0494, wxS("Ghemiddlehookcyrillic") },
  { 0x0492, wxS("Ghestrokecyrillic") },
  { 0x0490, wxS("Gheupturncyrillic") },
  { 0x0193, wxS("Ghook") },
  { 0x0533, wxS("Gimarmenian") },
  { 0x0403, wxS("Gjecyrillic") },
  { 0x1E20, wxS("Gmacron") },
  { 0xFF27, wxS("Gmonospace") },
  { 0xF6CE, wxS("Grave") },
  { 0xF760, wxS("Gravesmall") },
  { 0xF767, wxS("Gsmall") },
  { 0x029B, wxS("Gsmallhook") },
  { 0x01E4, wxS("Gstroke") },
  { 0x0048, wxS("H") },
  { 0x25CF, wxS("H18533") },
  { 0x25AA, wxS("H18543") },
  { 0x25AB, wxS("H18551") },
  { 0x25A1, wxS("H22073") },
  { 0x33CB, wxS("HPsquare") },
  { 0x04A8, wxS("Haabkhasiancyrillic") },
  { 0x04B2, wxS("Hadescendercyrillic") },
  { 0x042A, wxS("Hardsigncyrillic") },
  { 0x0126, wxS("Hbar") },
  { 0x1E2A, wxS("Hbrevebelow") },
  { 0x1E28, wxS("Hcedilla") },
  { 0x24BD, wxS("Hcircle") },
  { 0x0124, wxS("Hcircumflex") },
  { 0x1E26, wxS("Hdieresis") },
  { 0x1E22, wxS("Hdotaccent") },
  { 0x1E24, wxS("Hdotbelow") },
  { 0xFF28, wxS("Hmonospace") },
  { 0x0540, wxS("Hoarmenian") },
  { 0x03E8, wxS("Horicoptic") },
  { 0xF768, wxS("Hsmall") },
  { 0xF6CF, wxS("Hungarumlaut") },
  { 0xF6F8, wxS("Hungarumlautsmall") },
  { 0x3390, wxS("Hzsquare") },
  { 0x0049, wxS("I") },
  { 0x042F, wxS("IAcyrillic") },
  { 0x0132, wxS("IJ") },
  { 0x042E, wxS("IUcyrillic") },
  { 0x00CD, wxS("Iacute") },
  { 0xF7ED, wxS("Iacutesmall") },
  { 0x012C, wxS("Ibreve") },
  { 0x01CF, wxS("Icaron") },
  { 0x24BE, wxS("Icircle") },
  { 0x00CE, wxS("Icircumflex") },
  { 0xF7EE, wxS("Icircumflexsmall") },
  { 0x0406, wxS("Icyrillic") },
  { 0x0208, wxS("Idblgrave") },
  { 0x00CF, wxS("Idieresis") },
  { 0x1E2E, wxS("Idieresisacute") },
  { 0x04E4, wxS("Idieresiscyrillic") },
  { 0xF7EF, wxS("Idieresissmall") },
  { 0x0130, wxS("Idot") },
  { 0x0130, wxS("Idotaccent") },
  { 0x1ECA, wxS("Idotbelow") },
  { 0x04D6, wxS("Iebrevecyrillic") },
  { 0x0415, wxS("Iecyrillic") },
  { 0x2111, wxS("Ifraktur") },
  { 0x00CC, wxS("Igrave") },
  { 0xF7EC, wxS("Igravesmall") },
  { 0x1EC8, wxS("Ihookabove") },
  { 0x0418, wxS("Iicyrillic") },
  { 0x020A, wxS("Iinvertedbreve") },
  { 0x0419, wxS("Iishortcyrillic") },
  { 0x012A, wxS("Imacron") },
  { 0x04E2, wxS("Imacroncyrillic") },
  { 0xFF29, wxS("Imonospace") },
  { 0x053B, wxS("Iniarmenian") },
  { 0x0401, wxS("Iocyrillic") },
  { 0x012E, wxS("Iogonek") },
  { 0x0399, wxS("Iota") },
  { 0x0196, wxS("Iotaafrican") },
  { 0x03AA, wxS("Iotadieresis") },
  { 0x038A, wxS("Iotatonos") },
  { 0xF769, wxS("Ismall") },
  { 0x0197, wxS("Istroke") },
  { 0x0128, wxS("Itilde") },
  { 0x1E2C, wxS("Itildebelow") },
  { 0x0474, wxS("Izhitsacyrillic") },
  { 0x0476, wxS("Izhitsadblgravecyrillic") },
  { 0x004A, wxS("J") },
  { 0x0541, wxS("Jaarmenian") },
  { 0x24BF, wxS("Jcircle") },
  { 0x0134, wxS("Jcircumflex") },
  { 0x0408, wxS("Jecyrillic") },
  { 0x054B, wxS("Jheharmenian") },
  { 0xFF2A, wxS("Jmonospace") },
  { 0xF76A, wxS("Jsmall") },
  { 0x004B, wxS("K") },
  { 0x3385, wxS("KBsquare") },
  { 0x33CD, wxS("KKsquare") },
  { 0x04A0, wxS("Kabashkircyrillic") },
  { 0x1E30, wxS("Kacute") },
  { 0x041A, wxS("Kacyrillic") },
  { 0x049A, wxS("Kadescendercyrillic") },
  { 0x04C3, wxS("Kahookcyrillic") },
  { 0x039A, wxS("Kappa") },
  { 0x049E, wxS("Kastrokecyrillic") },
  { 0x049C, wxS("Kaverticalstrokecyrillic") },
  { 0x01E8, wxS("Kcaron") },
  { 0x0136, wxS("Kcedilla") },
  { 0x24C0, wxS("Kcircle") },
  { 0x0136, wxS("Kcommaaccent") },
  { 0x1E32, wxS("Kdotbelow") },
  { 0x0554, wxS("Keharmenian") },
  { 0x053F, wxS("Kenarmenian") },
  { 0x0425, wxS("Khacyrillic") },
  { 0x03E6, wxS("Kheicoptic") },
  { 0x0198, wxS("Khook") },
  { 0x040C, wxS("Kjecyrillic") },
  { 0x1E34, wxS("Klinebelow") },
  { 0xFF2B, wxS("Kmonospace") },
  { 0x0480, wxS("Koppacyrillic") },
  { 0x03DE, wxS("Koppagreek") },
  { 0x046E, wxS("Ksicyrillic") },
  { 0xF76B, wxS("Ksmall") },
  { 0x004C, wxS("L") },
  { 0x01C7, wxS("LJ") },
  { 0xF6BF, wxS("LL") },
  { 0x0139, wxS("Lacute") },
  { 0x039B, wxS("Lambda") },
  { 0x013D, wxS("Lcaron") },
  { 0x013B, wxS("Lcedilla") },
  { 0x24C1, wxS("Lcircle") },
  { 0x1E3C, wxS("Lcircumflexbelow") },
  { 0x013B, wxS("Lcommaaccent") },
  { 0x013F, wxS("Ldot") },
  { 0x013F, wxS("Ldotaccent") },
  { 0x1E36, wxS("Ldotbelow") },
  { 0x1E38, wxS("Ldotbelowmacron") },
  { 0x053C, wxS("Liwnarmenian") },
  { 0x01C8, wxS("Lj") },
  { 0x0409, wxS("Ljecyrillic") },
  { 0x1E3A, wxS("Llinebelow") },
  { 0xFF2C, wxS("Lmonospace") },
  { 0x0141, wxS("Lslash") },
  { 0xF6F9, wxS("Lslashsmall") },
  { 0xF76C, wxS("Lsmall") },
  { 0x004D, wxS("M") },
  { 0x3386, wxS("MBsquare") },
  { 0xF6D0, wxS("Macron") },
  { 0xF7AF, wxS("Macronsmall") },
  { 0x1E3E, wxS("Macute") },
  { 0x24C2, wxS("Mcircle") },
  { 0x1E40, wxS("Mdotaccent") },
  { 0x1E42, wxS("Mdotbelow") },
  { 0x0544, wxS("Menarmenian") },
  { 0xFF2D, wxS("Mmonospace") },
  { 0xF76D, wxS("Msmall") },
  { 0x019C, wxS("Mturned") },
  { 0x039C, wxS("Mu") },
  { 0x004E, wxS("N") },
  { 0x01CA, wxS("NJ") },
  { 0x0143, wxS("Nacute") },
  { 0x0147, wxS("Ncaron") },
  { 0x0145, wxS("Ncedilla") },
  { 0x24C3, wxS("Ncircle") },
  { 0x1E4A, wxS("Ncircumflexbelow") },
  { 0x0145, wxS("Ncommaaccent") },
  { 0x1E44, wxS("Ndotaccent") },
  { 0x1E46, wxS("Ndotbelow") },
  { 0x019D, wxS("Nhookleft") },
  { 0x2168, wxS("Nineroman") },
  { 0x01CB, wxS("Nj") },
  { 0x040A, wxS("Njecyrillic") },
  { 0x1E48, wxS("Nlinebelow") },
  { 0xFF2E, wxS("Nmonospace") },
  { 0x0546, wxS("Nowarmenian") },
  { 0xF76E, wxS("Nsmall") },
  { 0x00D1, wxS("Ntilde") },
  { 0xF7F1, wxS("Ntildesmall") },
  { 0x039D, wxS("Nu") },
  { 0x004F, wxS("O") },
  { 0x0152, wxS("OE") },
  { 0xF6FA, wxS("OEsmall") },
  { 0x00D3, wxS("Oacute") },
  { 0xF7F3, wxS("Oacutesmall") },
  { 0x04E8, wxS("Obarredcyrillic") },
  { 0x04EA, wxS("Obarreddieresiscyrillic") },
  { 0x014E, wxS("Obreve") },
  { 0x01D1, wxS("Ocaron") },
  { 0x019F, wxS("Ocenteredtilde") },
  { 0x24C4, wxS("Ocircle") },
  { 0x00D4, wxS("Ocircumflex") },
  { 0x1ED0, wxS("Ocircumflexacute") },
  { 0x1ED8, wxS("Ocircumflexdotbelow") },
  { 0x1ED2, wxS("Ocircumflexgrave") },
  { 0x1ED4, wxS("Ocircumflexhookabove") },
  { 0xF7F4, wxS("Ocircumflexsmall") },
  { 0x1ED6, wxS("Ocircumflextilde") },
  { 0x041E, wxS("Ocyrillic") },
  { 0x0150, wxS("Odblacute") },
  { 0x020C, wxS("Odblgrave") },
  { 0x00D6, wxS("Odieresis") },
  { 0x04E6, wxS("Odieresiscyrillic") },
  { 0xF7F6, wxS("Odieresissmall") },
  { 0x1ECC, wxS("Odotbelow") },
  { 0xF6FB, wxS("Ogoneksmall") },
  { 0x00D2, wxS("Ograve") },
  { 0xF7F2, wxS("Ogravesmall") },
  { 0x0555, wxS("Oharmenian") },
  { 0x2126, wxS("Ohm") },
  { 0x1ECE, wxS("Ohookabove") },
  { 0x01A0, wxS("Ohorn") },
  { 0x1EDA, wxS("Ohornacute") },
  { 0x1EE2, wxS("Ohorndotbelow") },
  { 0x1EDC, wxS("Ohorngrave") },
  { 0x1EDE, wxS("Ohornhookabove") },
  { 0x1EE0, wxS("Ohorntilde") },
  { 0x0150, wxS("Ohungarumlaut") },
  { 0x01A2, wxS("Oi") },
  { 0x020E, wxS("Oinvertedbreve") },
  { 0x014C, wxS("Omacron") },
  { 0x1E52, wxS("Omacronacute") },
  { 0x1E50, wxS("Omacrongrave") },
  { 0x03A9, wxS("Omega") },
  { 0x0460, wxS("Omegacyrillic") },
  { 0x03A9, wxS("Omegagreek") },
  { 0x047A, wxS("Omegaroundcyrillic") },
  { 0x047C, wxS("Omegatitlocyrillic") },
  { 0x038F, wxS("Omegatonos") },
  { 0x039F, wxS("Omicron") },
  { 0x038C, wxS("Omicrontonos") },
  { 0xFF2F, wxS("Omonospace") },
  { 0x2160, wxS("Oneroman") },
  { 0x01EA, wxS("Oogonek") },
  { 0x01EC, wxS("Oogonekmacron") },
  { 0x0186, wxS("Oopen") },
  { 0x00D8, wxS("Oslash") },
  { 0x01FE, wxS("Oslashacute") },
  { 0xF7F8, wxS("Oslashsmall") },
  { 0xF76F, wxS("Osmall") },
  { 0x01FE, wxS("Ostrokeacute") },
  { 0x047E, wxS("Otcyrillic") },
  { 0x00D5, wxS("Otilde") },
  { 0x1E4C, wxS("Otildeacute") },
  { 0x1E4E, wxS("Otildedieresis") },
  { 0xF7F5, wxS("Otildesmall") },
  { 0x0050, wxS("P") },
  { 0x1E54, wxS("Pacute") },
  { 0x24C5, wxS("Pcircle") },
  { 0x1E56, wxS("Pdotaccent") },
  { 0x041F, wxS("Pecyrillic") },
  { 0x054A, wxS("Peharmenian") },
  { 0x04A6, wxS("Pemiddlehookcyrillic") },
  { 0x03A6, wxS("Phi") },
  { 0x01A4, wxS("Phook") },
  { 0x03A0, wxS("Pi") },
  { 0x0553, wxS("Piwrarmenian") },
  { 0xFF30, wxS("Pmonospace") },
  { 0x03A8, wxS("Psi") },
  { 0x0470, wxS("Psicyrillic") },
  { 0xF770, wxS("Psmall") },
  { 0x0051, wxS("Q") },
  { 0x24C6, wxS("Qcircle") },
  { 0xFF31, wxS("Qmonospace") },
  { 0xF771, wxS("Qsmall") },
  { 0x0052, wxS("R") },
  { 0x054C, wxS("Raarmenian") },
  { 0x0154, wxS("Racute") },
  { 0x0158, wxS("Rcaron") },
  { 0x0156, wxS("Rcedilla") },
  { 0x24C7, wxS("Rcircle") },
  { 0x0156, wxS("Rcommaaccent") },
  { 0x0210, wxS("Rdblgrave") },
  { 0x1E58, wxS("Rdotaccent") },
  { 0x1E5A, wxS("Rdotbelow") },
  { 0x1E5C, wxS("Rdotbelowmacron") },
  { 0x0550, wxS("Reharmenian") },
  { 0x211C, wxS("Rfraktur") },
  { 0x03A1, wxS("Rho") },
  { 0xF6FC, wxS("Ringsmall") },
  { 0x0212, wxS("Rinvertedbreve") },
  { 0x1E5E, wxS("Rlinebelow") },
  { 0xFF32, wxS("Rmonospace") },
  { 0xF772, wxS("Rsmall") },
  { 0x0281, wxS("Rsmallinverted") },
  { 0x02B6, wxS("Rsmallinvertedsuperior") },
  { 0x0053, wxS("S") },
  { 0x250C, wxS("SF010000") },
  { 0x2514, wxS("SF020000") },
  { 0x2510, wxS("SF030000") },
  { 0x2518, wxS("SF040000") },
  { 0x253C, wxS("SF050000") },
  { 0x252C, wxS("SF060000") },
  { 0x2534, wxS("SF070000") },
  { 0x251C, wxS("SF080000") },
  { 0x2524, wxS("SF090000") },
  { 0x2500, wxS("SF100000") },
  { 0x2502, wxS("SF110000") },
  { 0x2561, wxS("SF190000") },
  { 0x2562, wxS("SF200000") },
  { 0x2556, wxS("SF210000") },
  { 0x2555, wxS("SF220000") },
  { 0x2563, wxS("SF230000") },
  { 0x2551, wxS("SF240000") },
  { 0x2557, wxS("SF250000") },
  { 0x255D, wxS("SF260000") },
  { 0x255C, wxS("SF270000") },
  { 0x255B, wxS("SF280000") },
  { 0x255E, wxS("SF360000") },
  { 0x255F, wxS("SF370000") },
  { 0x255A, wxS("SF380000") },
  { 0x2554, wxS("SF390000") },
  { 0x2569, wxS("SF400000") },
  { 0x2566, wxS("SF410000") },
  { 0x2560, wxS("SF420000") },
  { 0x2550, wxS("SF430000") },
  { 0x256C, wxS("SF440000") },
  { 0x2567, wxS("SF450000") },
  { 0x2568, wxS("SF460000") },
  { 0x2564, wxS("SF470000") },
  { 0x2565, wxS("SF480000") },
  { 0x2559, wxS("SF490000") },
  { 0x2558, wxS("SF500000") },
  { 0x2552, wxS("SF510000") },
  { 0x2553, wxS("SF520000") },
  { 0x256B, wxS("SF530000") },
  { 0x256A, wxS("SF540000") },
  { 0x015A, wxS("Sacute") },
  { 0x1E64, wxS("Sacutedotaccent") },
  { 0x03E0, wxS("Sampigreek") },
  { 0x0160, wxS("Scaron") },
  { 0x1E66, wxS("Scarondotaccent") },
  { 0xF6FD, wxS("Scaronsmall") },
  { 0x015E, wxS("Scedilla") },
  { 0x018F, wxS("Schwa") },
  { 0x04D8, wxS("Schwacyrillic") },
  { 0x04DA, wxS("Schwadieresiscyrillic") },
  { 0x24C8, wxS("Scircle") },
  { 0x015C, wxS("Scircumflex") },
  { 0x0218, wxS("Scommaaccent") },
  { 0x1E60, wxS("Sdotaccent") },
  { 0x1E62, wxS("Sdotbelow") },
  { 0x1E68, wxS("Sdotbelowdotaccent") },
  { 0x054D, wxS("Seharmenian") },
  { 0x2166, wxS("Sevenroman") },
  { 0x0547, wxS("Shaarmenian") },
  { 0x0428, wxS("Shacyrillic") },
  { 0x0429, wxS("Shchacyrillic") },
  { 0x03E2, wxS("Sheicoptic") },
  { 0x04BA, wxS("Shhacyrillic") },
  { 0x03EC, wxS("Shimacoptic") },
  { 0x03A3, wxS("Sigma") },
  { 0x2165, wxS("Sixroman") },
  { 0xFF33, wxS("Smonospace") },
  { 0x042C, wxS("Softsigncyrillic") },
  { 0xF773, wxS("Ssmall") },
  { 0x03DA, wxS("Stigmagreek") },
  { 0x0054, wxS("T") },
  { 0x03A4, wxS("Tau") },
  { 0x0166, wxS("Tbar") },
  { 0x0164, wxS("Tcaron") },
  { 0x0162, wxS("Tcedilla") },
  { 0x24C9, wxS("Tcircle") },
  { 0x1E70, wxS("Tcircumflexbelow") },
  { 0x0162, wxS("Tcommaaccent") },
  { 0x1E6A, wxS("Tdotaccent") },
  { 0x1E6C, wxS("Tdotbelow") },
  { 0x0422, wxS("Tecyrillic") },
  { 0x04AC, wxS("Tedescendercyrillic") },
  { 0x2169, wxS("Tenroman") },
  { 0x04B4, wxS("Tetsecyrillic") },
  { 0x0398, wxS("Theta") },
  { 0x01AC, wxS("Thook") },
  { 0x00DE, wxS("Thorn") },
  { 0xF7FE, wxS("Thornsmall") },
  { 0x2162, wxS("Threeroman") },
  { 0xF6FE, wxS("Tildesmall") },
  { 0x054F, wxS("Tiwnarmenian") },
  { 0x1E6E, wxS("Tlinebelow") },
  { 0xFF34, wxS("Tmonospace") },
  { 0x0539, wxS("Toarmenian") },
  { 0x01BC, wxS("Tonefive") },
  { 0x0184, wxS("Tonesix") },
  { 0x01A7, wxS("Tonetwo") },
  { 0x01AE, wxS("Tretroflexhook") },
  { 0x0426, wxS("Tsecyrillic") },
  { 0x040B, wxS("Tshecyrillic") },
  { 0xF774, wxS("Tsmall") },
  { 0x216B, wxS("Twelveroman") },
  { 0x2161, wxS("Tworoman") },
  { 0x0055, wxS("U") },
  { 0x00DA, wxS("Uacute") },
  { 0xF7FA, wxS("Uacutesmall") },
  { 0x016C, wxS("Ubreve") },
  { 0x01D3, wxS("Ucaron") },
  { 0x24CA, wxS("Ucircle") },
  { 0x00DB, wxS("Ucircumflex") },
  { 0x1E76, wxS("Ucircumflexbelow") },
  { 0xF7FB, wxS("Ucircumflexsmall") },
  { 0x0423, wxS("Ucyrillic") },
  { 0x0170, wxS("Udblacute") },
  { 0x0214, wxS("Udblgrave") },
  { 0x00DC, wxS("Udieresis") },
  { 0x01D7, wxS("Udieresisacute") },
  { 0x1E72, wxS("Udieresisbelow") },
  { 0x01D9, wxS("Udieresiscaron") },
  { 0x04F0, wxS("Udieresiscyrillic") },
  { 0x01DB, wxS("Udieresisgrave") },
  { 0x01D5, wxS("Udieresismacron") },
  { 0xF7FC, wxS("Udieresissmall") },
  { 0x1EE4, wxS("Udotbelow") },
  { 0x00D9, wxS("Ugrave") },
  { 0xF7F9, wxS("Ugravesmall") },
  { 0x1EE6, wxS("Uhookabove") },
  { 0x01AF, wxS("Uhorn") },
  { 0x1EE8, wxS("Uhornacute") },
  { 0x1EF0, wxS("Uhorndotbelow") },
  { 0x1EEA, wxS("Uhorngrave") },
  { 0x1EEC, wxS("Uhornhookabove") },
  { 0x1EEE, wxS("Uhorntilde") },
  { 0x0170, wxS("Uhungarumlaut") },
  { 0x04F2, wxS("Uhungarumlautcyrillic") },
  { 0x0216, wxS("Uinvertedbreve") },
  { 0x0478, wxS("Ukcyrillic") },
  { 0x016A, wxS("Umacron") },
  { 0x04EE, wxS("Umacroncyrillic") },
  { 0x1E7A, wxS("Umacrondieresis") },
  { 0xFF35, wxS("Umonospace") },
  { 0x0172, wxS("Uogonek") },
  { 0x03A5, wxS("Upsilon") },
  { 0x03D2, wxS("Upsilon1") },
  { 0x03D3, wxS("Upsilonacutehooksymbolgreek") },
  { 0x01B1, wxS("Upsilonafrican") },
  { 0x03AB, wxS("Upsilondieresis") },
  { 0x03D4, wxS("Upsilondieresishooksymbolgreek") },
  { 0x03D2, wxS("Upsilonhooksymbol") },
  { 0x038E, wxS("Upsilontonos") },
  { 0x016E, wxS("Uring") },
  { 0x040E, wxS("Ushortcyrillic") },
  { 0xF775, wxS("Usmall") },
  { 0x04AE, wxS("Ustraightcyrillic") },
  { 0x04B0, wxS("Ustraightstrokecyrillic") },
  { 0x0168, wxS("Utilde") },
  { 0x1E78, wxS("Utildeacute") },
  { 0x1E74, wxS("Utildebelow") },
  { 0x0056, wxS("V") },
  { 0x24CB, wxS("Vcircle") },
  { 0x1E7E, wxS("Vdotbelow") },
  { 0x0412, wxS("Vecyrillic") },
  { 0x054E, wxS("Vewarmenian") },
  { 0x01B2, wxS("Vhook") },
  { 0xFF36, wxS("Vmonospace") },
  { 0x0548, wxS("Voarmenian") },
  { 0xF776, wxS("Vsmall") },
  { 0x1E7C, wxS("Vtilde") },
  { 0x0057, wxS("W") },
  { 0x1E82, wxS("Wacute") },
  { 0x24CC, wxS("Wcircle") },
  { 0x0174, wxS("Wcircumflex") },
  { 0x1E84, wxS("Wdieresis") },
  { 0x1E86, wxS("Wdotaccent") },
  { 0x1E88, wxS("Wdotbelow") },
  { 0x1E80, wxS("Wgrave") },
  { 0xFF37, wxS("Wmonospace") },
  { 0xF777, wxS("Wsmall") },
  { 0x0058, wxS("X") },
  { 0x24CD, wxS("Xcircle") },
  { 0x1E8C, wxS("Xdieresis") },
  { 0x1E8A, wxS("Xdotaccent") },
  { 0x053D, wxS("Xeharmenian") },
  { 0x039E, wxS("Xi") },
  { 0xFF38, wxS("Xmonospace") },
  { 0xF778, wxS("Xsmall") },
  { 0x0059, wxS("Y") },
  { 0x00DD, wxS("Yacute") },
  { 0xF7FD, wxS("Yacutesmall") },
  { 0x0462, wxS("Yatcyrillic") },
  { 0x24CE, wxS("Ycircle") },
  { 0x0176, wxS("Ycircumflex") },
  { 0x0178, wxS("Ydieresis") },
  { 0xF7FF, wxS("Ydieresissmall") },
  { 0x1E8E, wxS("Ydotaccent") },
  { 0x1EF4, wxS("Ydotbelow") },
  { 0x042B, wxS("Yericyrillic") },
  { 0x04F8, wxS("Yerudieresiscyrillic") },
  { 0x1EF2, wxS("Ygrave") },
  { 0x01B3, wxS("Yhook") },
  { 0x1EF6, wxS("Yhookabove") },
  { 0x0545, wxS("Yiarmenian") },
  { 0x0407, wxS("Yicyrillic") },
  { 0x0552, wxS("Yiwnarmenian") },
  { 0xFF39, wxS("Ymonospace") },
  { 0xF779, wxS("Ysmall") },
  { 0x1EF8, wxS("Ytilde") },
  { 0x046A, wxS("Yusbigcyrillic") },
  { 0x046C, wxS("Yusbigiotifiedcyrillic") },
  { 0x0466, wxS("Yuslittlecyrillic") },
  { 0x0468, wxS("Yuslittleiotifiedcyrillic") },
  { 0x005A, wxS("Z") },
  { 0x0536, wxS("Zaarmenian") },
  { 0x0179, wxS("Zacute") },
  { 0x017D, wxS("Zcaron") },
  { 0xF6FF, wxS("Zcaronsmall") },
  { 0x24CF, wxS("Zcircle") },
  { 0x1E90, wxS("Zcircumflex") },
  { 0x017B, wxS("Zdot") },
  { 0x017B, wxS("Zdotaccent") },
  { 0x1E92, wxS("Zdotbelow") },
  { 0x0417, wxS("Zecyrillic") },
  { 0x0498, wxS("Zedescendercyrillic") },
  { 0x04DE, wxS("Zedieresiscyrillic") },
  { 0x0396, wxS("Zeta") },
  { 0x053A, wxS("Zhearmenian") },
  { 0x04C1, wxS("Zhebrevecyrillic") },
  { 0x0416, wxS("Zhecyrillic") },
  { 0x0496, wxS("Zhedescendercyrillic") },
  { 0x04DC, wxS("Zhedieresiscyrillic") },
  { 0x1E94, wxS("Zlinebelow") },
  { 0xFF3A, wxS("Zmonospace") },
  { 0xF77A, wxS("Zsmall") },
  { 0x01B5, wxS("Zstroke") },
  { 0x0061, wxS("a") },
  { 0x0986, wxS("aabengali") },
  { 0x00E1, wxS("aacute") },
  { 0x0906, wxS("aadeva") },
  { 0x0A86, wxS("aagujarati") },
  { 0x0A06, wxS("aagurmukhi") },
  { 0x0A3E, wxS("aamatragurmukhi") },
  { 0x3303, wxS("aarusquare") },
  { 0x09BE, wxS("aavowelsignbengali") },
  { 0x093E, wxS("aavowelsigndeva") },
  { 0x0ABE, wxS("aavowelsigngujarati") },
  { 0x055F, wxS("abbreviationmarkarmenian") },
  { 0x0970, wxS("abbreviationsigndeva") },
  { 0x0985, wxS("abengali") },
  { 0x311A, wxS("abopomofo") },
  { 0x0103, wxS("abreve") },
  { 0x1EAF, wxS("abreveacute") },
  { 0x04D1, wxS("abrevecyrillic") },
  { 0x1EB7, wxS("abrevedotbelow") },
  { 0x1EB1, wxS("abrevegrave") },
  { 0x1EB3, wxS("abrevehookabove") },
  { 0x1EB5, wxS("abrevetilde") },
  { 0x01CE, wxS("acaron") },
  { 0x24D0, wxS("acircle") },
  { 0x00E2, wxS("acircumflex") },
  { 0x1EA5, wxS("acircumflexacute") },
  { 0x1EAD, wxS("acircumflexdotbelow") },
  { 0x1EA7, wxS("acircumflexgrave") },
  { 0x1EA9, wxS("acircumflexhookabove") },
  { 0x1EAB, wxS("acircumflextilde") },
  { 0x00B4, wxS("acute") },
  { 0x0317, wxS("acutebelowcmb") },
  { 0x0301, wxS("acutecmb") },
  { 0x0301, wxS("acutecomb") },
  { 0x0954, wxS("acutedeva") },
  { 0x02CF, wxS("acutelowmod") },
  { 0x0341, wxS("acutetonecmb") },
  { 0x0430, wxS("acyrillic") },
  { 0x0201, wxS("adblgrave") },
  { 0x0A71, wxS("addakgurmukhi") },
  { 0x0905, wxS("adeva") },
  { 0x00E4, wxS("adieresis") },
  { 0x04D3, wxS("adieresiscyrillic") },
  { 0x01DF, wxS("adieresismacron") },
  { 0x1EA1, wxS("adotbelow") },
  { 0x01E1, wxS("adotmacron") },
  { 0x00E6, wxS("ae") },
  { 0x01FD, wxS("aeacute") },
  { 0x3150, wxS("aekorean") },
  { 0x01E3, wxS("aemacron") },
  { 0x2015, wxS("afii00208") },
  { 0x20A4, wxS("afii08941") },
  { 0x0410, wxS("afii10017") },
  { 0x0411, wxS("afii10018") },
  { 0x0412, wxS("afii10019") },
  { 0x0413, wxS("afii10020") },
  { 0x0414, wxS("afii10021") },
  { 0x0415, wxS("afii10022") },
  { 0x0401, wxS("afii10023") },
  { 0x0416, wxS("afii10024") },
  { 0x0417, wxS("afii10025") },
  { 0x0418, wxS("afii10026") },
  { 0x0419, wxS("afii10027") },
  { 0x041A, wxS("afii10028") },
  { 0x041B, wxS("afii10029") },
  { 0x041C, wxS("afii10030") },
  { 0x041D, wxS("afii10031") },
  { 0x041E, wxS("afii10032") },
  { 0x041F, wxS("afii10033") },
  { 0x0420, wxS("afii10034") },
  { 0x0421, wxS("afii10035") },
  { 0x0422, wxS("afii10036") },
  { 0x0423, wxS("afii10037") },
  { 0x0424, wxS("afii10038") },
  { 0x0425, wxS("afii10039") },
  { 0x0426, wxS("afii10040") },
  { 0x0427, wxS("afii10041") },
  { 0x0428, wxS("afii10042") },
  { 0x0429, wxS("afii10043") },
  { 0x042A, wxS("afii10044") },
  { 0x042B, wxS("afii10045") },
  { 0x042C, wxS("afii10046") },
  { 0x042D, wxS("afii10047") },
  { 0x042E, wxS("afii10048") },
  { 0x042F, wxS("afii10049") },
  { 0x0490, wxS("afii10050") },
  { 0x0402, wxS("afii10051") },
  { 0x0403, wxS("afii10052") },
  { 0x0404, wxS("afii10053") },
  { 0x0405, wxS("afii10054") },
  { 0x0406, wxS("afii10055") },
  { 0x0407, wxS("afii10056") },
  { 0x0408, wxS("afii10057") },
  { 0x0409, wxS("afii10058") },
  { 0x040A, wxS("afii10059") },
  { 0x040B, wxS("afii10060") },
  { 0x040C, wxS("afii10061") },
  { 0x040E, wxS("afii10062") },
  { 0xF6C4, wxS("afii10063") },
  { 0xF6C5, wxS("afii10064") },
  { 0x0430, wxS("afii10065") },
  { 0x0431, wxS("afii10066") },
  { 0x0432, wxS("afii10067") },
  { 0x0433, wxS("afii10068") },
  { 0x0434, wxS("afii10069") },
  { 0x0435, wxS("afii10070") },
  { 0x0451, wxS("afii10071") },
  { 0x0436, wxS("afii10072") },
  { 0x0437, wxS("afii10073") },
  { 0x0438, wxS("afii10074") },
  { 0x0439, wxS("afii10075") },
  { 0x043A, wxS("afii10076") },
  { 0x043B, wxS("afii10077") },
  { 0x043C, wxS("afii10078") },
  { 0x043D, wxS("afii10079") },
  { 0x043E, wxS("afii10080") },
  { 0x043F, wxS("afii10081") },
  { 0x0440, wxS("afii10082") },
  { 0x0441, wxS("afii10083") },
  { 0x0442, wxS("afii10084") },
  { 0x0443, wxS("afii10085") },
  { 0x0444, wxS("afii10086") },
  { 0x0445, wxS("afii10087") },
  { 0x0446, wxS("afii10088") },
  { 0x0447, wxS("afii10089") },
  { 0x0448, wxS("afii10090") },
  { 0x0449, wxS("afii10091") },
  { 0x044A, wxS("afii10092") },
  { 0x044B, wxS("afii10093") },
  { 0x044C, wxS("afii10094") },
  { 0x044D, wxS("afii10095") },
  { 0x044E, wxS("afii10096") },
  { 0x044F, wxS("afii10097") },
  { 0x0491, wxS("afii10098") },
  { 0x0452, wxS("afii10099") },
  { 0x0453, wxS("afii10100") },
  { 0x0454, wxS("afii10101") },
  { 0x0455, wxS("afii10102") },
  { 0x0456, wxS("afii10103") },
  { 0x0457, wxS("afii10104") },
  { 0x0458, wxS("afii10105") },
  { 0x0459, wxS("afii10106") },
  { 0x045A, wxS("afii10107") },
  { 0x045B, wxS("afii10108") },
  { 0x045C, wxS("afii10109") },
  { 0x045E, wxS("afii10110") },
  { 0x040F, wxS("afii10145") },
  { 0x0462, wxS("afii10146") },
  { 0x0472, wxS("afii10147") },
  { 0x0474, wxS("afii10148") },
  { 0xF6C6, wxS("afii10192") },
  { 0x045F, wxS("afii10193") },
  { 0x0463, wxS("afii10194") },
  { 0x0473, wxS("afii10195") },
  { 0x0475, wxS("afii10196") },
  { 0xF6C7, wxS("afii10831") },
  { 0xF6C8, wxS("afii10832") },
  { 0x04D9, wxS("afii10846") },
  { 0x200E, wxS("afii299") },
  { 0x200F, wxS("afii300") },
  { 0x200D, wxS("afii301") },
  { 0x066A, wxS("afii57381") },
  { 0x060C, wxS("afii57388") },
  { 0x0660, wxS("afii57392") },
  { 0x0661, wxS("afii57393") },
  { 0x0662, wxS("afii57394") },
  { 0x0663, wxS("afii57395") },
  { 0x0664, wxS("afii57396") },
  { 0x0665, wxS("afii57397") },
  { 0x0666, wxS("afii57398") },
  { 0x0667, wxS("afii57399") },
  { 0x0668, wxS("afii57400") },
  { 0x0669, wxS("afii57401") },
  { 0x061B, wxS("afii57403") },
  { 0x061F, wxS("afii57407") },
  { 0x0621, wxS("afii57409") },
  { 0x0622, wxS("afii57410") },
  { 0x0623, wxS("afii57411") },
  { 0x0624, wxS("afii57412") },
  { 0x0625, wxS("afii57413") },
  { 0x0626, wxS("afii57414") },
  { 0x0627, wxS("afii57415") },
  { 0x0628, wxS("afii57416") },
  { 0x0629, wxS("afii57417") },
  { 0x062A, wxS("afii57418") },
  { 0x062B, wxS("afii57419") },
  { 0x062C, wxS("afii57420") },
  { 0x062D, wxS("afii57421") },
  { 0x062E, wxS("afii57422") },
  { 0x062F, wxS("afii57423") },
  { 0x0630, wxS("afii57424") },
  { 0x0631, wxS("afii57425") },
  { 0x0632, wxS("afii57426") },
  { 0x0633, wxS("afii57427") },
  { 0x0634, wxS("afii57428") },
  { 0x0635, wxS("afii57429") },
  { 0x0636, wxS("afii57430") },
  { 0x0637, wxS("afii57431") },
  { 0x0638, wxS("afii57432") },
  { 0x0639, wxS("afii57433") },
  { 0x063A, wxS("afii57434") },
  { 0x0640, wxS("afii57440") },
  { 0x0641, wxS("afii57441") },
  { 0x0642, wxS("afii57442") },
  { 0x0643, wxS("afii57443") },
  { 0x0644, wxS("afii57444") },
  { 0x0645, wxS("afii57445") },
  { 0x0646, wxS("afii57446") },
  { 0x0648, wxS("afii57448") },
  { 0x0649, wxS("afii57449") },
  { 0x064A, wxS("afii57450") },
  { 0x064B, wxS("afii57451") },
  { 0x064C, wxS("afii57452") },
  { 0x064D, wxS("afii57453") },
  { 0x064E, wxS("afii57454") },
  { 0x064F, wxS("afii57455") },
  { 0x0650, wxS("afii57456") },
  { 0x0651, wxS("afii57457") },
  { 0x0652, wxS("afii57458") },
  { 0x0647, wxS("afii57470") },
  { 0x06A4, wxS("afii57505") },
  { 0x067E, wxS("afii57506") },
  { 0x0686, wxS("afii57507") },
  { 0x0698, wxS("afii57508") },
  { 0x06AF, wxS("afii57509") },
  { 0x0679, wxS("afii57511") },
  { 0x0688, wxS("afii57512") },
  { 0x0691, wxS("afii57513") },
  { 0x06BA, wxS("afii57514") },
  { 0x06D2, wxS("afii57519") },
  { 0x06D5, wxS("afii57534") },
  { 0x20AA, wxS("afii57636") },
  { 0x05BE, wxS("afii57645") },
  { 0x05C3, wxS("afii57658") },
  { 0x05D0, wxS("afii57664") },
  { 0x05D1, wxS("afii57665") },
  { 0x05D2, wxS("afii57666") },
  { 0x05D3, wxS("afii57667") },
  { 0x05D4, wxS("afii57668") },
  { 0x05D5, wxS("afii57669") },
  { 0x05D6, wxS("afii57670") },
  { 0x05D7, wxS("afii57671") },
  { 0x05D8, wxS("afii57672") },
  { 0x05D9, wxS("afii57673") },
  { 0x05DA, wxS("afii57674") },
  { 0x05DB, wxS("afii57675") },
  { 0x05DC, wxS("afii57676") },
  { 0x05DD, wxS("afii57677") },
  { 0x05DE, wxS("afii57678") },
  { 0x05DF, wxS("afii57679") },
  { 0x05E0, wxS("afii57680") },
  { 0x05E1, wxS("afii57681") },
  { 0x05E2, wxS("afii57682") },
  { 0x05E3, wxS("afii57683") },
  { 0x05E4, wxS("afii57684") },
  { 0x05E5, wxS("afii57685") },
  { 0x05E6, wxS("afii57686") },
  { 0x05E7, wxS("afii57687") },
  { 0x05E8, wxS("afii57688") },
  { 0x05E9, wxS("afii57689") },
  { 0x05EA, wxS("afii57690") },
  { 0xFB2A, wxS("afii57694") },
  { 0xFB2B, wxS("afii57695") },
  { 0xFB4B, wxS("afii57700") },
  { 0xFB1F, wxS("afii57705") },
  { 0x05F0, wxS("afii57716") },
  { 0x05F1, wxS("afii57717") },
  { 0x05F2, wxS("afii57718") },
  { 0xFB35, wxS("afii57723") },
  { 0x05B4, wxS("afii57793") },
  { 0x05B5, wxS("afii57794") },
  { 0x05B6, wxS("afii57795") },
  { 0x05BB, wxS("afii57796") },
  { 0x05B8, wxS("afii57797") },
  { 0x05B7, wxS("afii57798") },
  { 0x05B0, wxS("afii57799") },
  { 0x05B2, wxS("afii57800") },
  { 0x05B1, wxS("afii57801") },
  { 0x05B3, wxS("afii57802") },
  { 0x05C2, wxS("afii57803") },
  { 0x05C1, wxS("afii57804") },
  { 0x05B9, wxS("afii57806") },
  { 0x05BC, wxS("afii57807") },
  { 0x05BD, wxS("afii57839") },
  { 0x05BF, wxS("afii57841") },
  { 0x05C0, wxS("afii57842") },
  { 0x02BC, wxS("afii57929") },
  { 0x2105, wxS("afii61248") },
  { 0x2113, wxS("afii61289") },
  { 0x2116, wxS("afii61352") },
  { 0x202C, wxS("afii61573") },
  { 0x202D, wxS("afii61574") },
  { 0x202E, wxS("afii61575") },
  { 0x200C, wxS("afii61664") },
  { 0x066D, wxS("afii63167") },
  { 0x02BD, wxS("afii64937") },
  { 0x00E0, wxS("agrave") },
  { 0x0A85, wxS("agujarati") },
  { 0x0A05, wxS("agurmukhi") },
  { 0x3042, wxS("ahiragana") },
  { 0x1EA3, wxS("ahookabove") },
  { 0x0990, wxS("aibengali") },
  { 0x311E, wxS("aibopomofo") },
  { 0x0910, wxS("aideva") },
  { 0x04D5, wxS("aiecyrillic") },
  { 0x0A90, wxS("aigujarati") },
  { 0x0A10, wxS("aigurmukhi") },
  { 0x0A48, wxS("aimatragurmukhi") },
  { 0x0639, wxS("ainarabic") },
  { 0xFECA, wxS("ainfinalarabic") },
  { 0xFECB, wxS("aininitialarabic") },
  { 0xFECC, wxS("ainmedialarabic") },
  { 0x0203, wxS("ainvertedbreve") },
  { 0x09C8, wxS("aivowelsignbengali") },
  { 0x0948, wxS("aivowelsigndeva") },
  { 0x0AC8, wxS("aivowelsigngujarati") },
  { 0x30A2, wxS("akatakana") },
  { 0xFF71, wxS("akatakanahalfwidth") },
  { 0x314F, wxS("akorean") },
  { 0x05D0, wxS("alef") },
  { 0x0627, wxS("alefarabic") },
  { 0xFB30, wxS("alefdageshhebrew") },
  { 0xFE8E, wxS("aleffinalarabic") },
  { 0x0623, wxS("alefhamzaabovearabic") },
  { 0xFE84, wxS("alefhamzaabovefinalarabic") },
  { 0x0625, wxS("alefhamzabelowarabic") },
  { 0xFE88, wxS("alefhamzabelowfinalarabic") },
  { 0x05D0, wxS("alefhebrew") },
  { 0xFB4F, wxS("aleflamedhebrew") },
  { 0x0622, wxS("alefmaddaabovearabic") },
  { 0xFE82, wxS("alefmaddaabovefinalarabic") },
  { 0x0649, wxS("alefmaksuraarabic") },
  { 0xFEF0, wxS("alefmaksurafinalarabic") },
  { 0xFEF3, wxS("alefmaksurainitialarabic") },
  { 0xFEF4, wxS("alefmaksuramedialarabic") },
  { 0xFB2E, wxS("alefpatahhebrew") },
  { 0xFB2F, wxS("alefqamatshebrew") },
  { 0x2135, wxS("aleph") },
  { 0x224C, wxS("allequal") },
  { 0x03B1, wxS("alpha") },
  { 0x03AC, wxS("alphatonos") },
  { 0x0101, wxS("amacron") },
  { 0xFF41, wxS("amonospace") },
  { 0x0026, wxS("ampersand") },
  { 0xFF06, wxS("ampersandmonospace") },
  { 0xF726, wxS("ampersandsmall") },
  { 0x33C2, wxS("amsquare") },
  { 0x3122, wxS("anbopomofo") },
  { 0x3124, wxS("angbopomofo") },
  { 0x0E5A, wxS("angkhankhuthai") },
  { 0x2220, wxS("angle") },
  { 0x3008, wxS("anglebracketleft") },
  { 0xFE3F, wxS("anglebracketleftvertical") },
  { 0x3009, wxS("anglebracketright") },
  { 0xFE40, wxS("anglebracketrightvertical") },
  { 0x2329, wxS("angleleft") },
  { 0x232A, wxS("angleright") },
  { 0x212B, wxS("angstrom") },
  { 0x0387, wxS("anoteleia") },
  { 0x0952, wxS("anudattadeva") },
  { 0x0982, wxS("anusvarabengali") },
  { 0x0902, wxS("anusvaradeva") },
  { 0x0A82, wxS("anusvaragujarati") },
  { 0x0105, wxS("aogonek") },
  { 0x3300, wxS("apaatosquare") },
  { 0x249C, wxS("aparen") },
  { 0x055A, wxS("apostrophearmenian") },
  { 0x02BC, wxS("apostrophemod") },
  { 0xF8FF, wxS("apple") },
  { 0x2250, wxS("approaches") },
  { 0x2248, wxS("approxequal") },
  { 0x2252, wxS("approxequalorimage") },
  { 0x2245, wxS("approximatelyequal") },
  { 0x318E, wxS("araeaekorean") },
  { 0x318D, wxS("araeakorean") },
  { 0x2312, wxS("arc") },
  { 0x1E9A, wxS("arighthalfring") },
  { 0x00E5, wxS("aring") },
  { 0x01FB, wxS("aringacute") },
  { 0x1E01, wxS("aringbelow") },
  { 0x2194, wxS("arrowboth") },
  { 0x21E3, wxS("arrowdashdown") },
  { 0x21E0, wxS("arrowdashleft") },
  { 0x21E2, wxS("arrowdashright") },
  { 0x21E1, wxS("arrowdashup") },
  { 0x21D4, wxS("arrowdblboth") },
  { 0x21D3, wxS("arrowdbldown") },
  { 0x21D0, wxS("arrowdblleft") },
  { 0x21D2, wxS("arrowdblright") },
  { 0x21D1, wxS("arrowdblup") },
  { 0x2193, wxS("arrowdown") },
  { 0x2199, wxS("arrowdownleft") },
  { 0x2198, wxS("arrowdownright") },
  { 0x21E9, wxS("arrowdownwhite") },
  { 0x02C5, wxS("arrowheaddownmod") },
  { 0x02C2, wxS("arrowheadleftmod") },
  { 0x02C3, wxS("arrowheadrightmod") },
  { 0x02C4, wxS("arrowheadupmod") },
  { 0xF8E7, wxS("arrowhorizex") },
  { 0x2190, wxS("arrowleft") },
  { 0x21D0, wxS("arrowleftdbl") },
  { 0x21CD, wxS("arrowleftdblstroke") },
  { 0x21C6, wxS("arrowleftoverright") },
  { 0x21E6, wxS("arrowleftwhite") },
  { 0x2192, wxS("arrowright") },
  { 0x21CF, wxS("arrowrightdblstroke") },
  { 0x279E, wxS("arrowrightheavy") },
  { 0x21C4, wxS("arrowrightoverleft") },
  { 0x21E8, wxS("arrowrightwhite") },
  { 0x21E4, wxS("arrowtableft") },
  { 0x21E5, wxS("arrowtabright") },
  { 0x2191, wxS("arrowup") },
  { 0x2195, wxS("arrowupdn") },
  { 0x21A8, wxS("arrowupdnbse") },
  { 0x21A8, wxS("arrowupdownbase") },
  { 0x2196, wxS("arrowupleft") },
  { 0x21C5, wxS("arrowupleftofdown") },
  { 0x2197, wxS("arrowupright") },
  { 0x21E7, wxS("arrowupwhite") },
  { 0xF8E6, wxS("arrowvertex") },
  { 0x005E, wxS("asciicircum") },
  { 0xFF3E, wxS("asciicircummonospace") },
  { 0x007E, wxS("asciitilde") },
  { 0xFF5E, wxS("asciitildemonospace") },
  { 0x0251, wxS("ascript") },
  { 0x0252, wxS("ascriptturned") },
  { 0x3041, wxS("asmallhiragana") },
  { 0x30A1, wxS("asmallkatakana") },
  { 0xFF67, wxS("asmallkatakanahalfwidth") },
  { 0x002A, wxS("asterisk") },
  { 0x066D, wxS("asteriskaltonearabic") },
  { 0x066D, wxS("asteriskarabic") },
  { 0x2217, wxS("asteriskmath") },
  { 0xFF0A, wxS("asteriskmonospace") },
  { 0xFE61, wxS("asterisksmall") },
  { 0x2042, wxS("asterism") },
  { 0xF6E9, wxS("asuperior") },
  { 0x2243, wxS("asymptoticallyequal") },
  { 0x0040, wxS("at") },
  { 0x00E3, wxS("atilde") },
  { 0xFF20, wxS("atmonospace") },
  { 0xFE6B, wxS("atsmall") },
  { 0x0250, wxS("aturned") },
  { 0x0994, wxS("aubengali") },
  { 0x3120, wxS("aubopomofo") },
  { 0x0914, wxS("audeva") },
  { 0x0A94, wxS("augujarati") },
  { 0x0A14, wxS("augurmukhi") },
  { 0x09D7, wxS("aulengthmarkbengali") },
  { 0x0A4C, wxS("aumatragurmukhi") },
  { 0x09CC, wxS("auvowelsignbengali") },
  { 0x094C, wxS("auvowelsigndeva") },
  { 0x0ACC, wxS("auvowelsigngujarati") },
  { 0x093D, wxS("avagrahadeva") },
  { 0x0561, wxS("aybarmenian") },
  { 0x05E2, wxS("ayin") },
  { 0xFB20, wxS("ayinaltonehebrew") },
  { 0x05E2, wxS("ayinhebrew") },
  { 0x0062, wxS("b") },
  { 0x09AC, wxS("babengali") },
  { 0x005C, wxS("backslash") },
  { 0xFF3C, wxS("backslashmonospace") },
  { 0x092C, wxS("badeva") },
  { 0x0AAC, wxS("bagujarati") },
  { 0x0A2C, wxS("bagurmukhi") },
  { 0x3070, wxS("bahiragana") },
  { 0x0E3F, wxS("bahtthai") },
  { 0x30D0, wxS("bakatakana") },
  { 0x007C, wxS("bar") },
  { 0xFF5C, wxS("barmonospace") },
  { 0x3105, wxS("bbopomofo") },
  { 0x24D1, wxS("bcircle") },
  { 0x1E03, wxS("bdotaccent") },
  { 0x1E05, wxS("bdotbelow") },
  { 0x266C, wxS("beamedsixteenthnotes") },
  { 0x2235, wxS("because") },
  { 0x0431, wxS("becyrillic") },
  { 0x0628, wxS("beharabic") },
  { 0xFE90, wxS("behfinalarabic") },
  { 0xFE91, wxS("behinitialarabic") },
  { 0x3079, wxS("behiragana") },
  { 0xFE92, wxS("behmedialarabic") },
  { 0xFC9F, wxS("behmeeminitialarabic") },
  { 0xFC08, wxS("behmeemisolatedarabic") },
  { 0xFC6D, wxS("behnoonfinalarabic") },
  { 0x30D9, wxS("bekatakana") },
  { 0x0562, wxS("benarmenian") },
  { 0x05D1, wxS("bet") },
  { 0x03B2, wxS("beta") },
  { 0x03D0, wxS("betasymbolgreek") },
  { 0xFB31, wxS("betdagesh") },
  { 0xFB31, wxS("betdageshhebrew") },
  { 0x05D1, wxS("bethebrew") },
  { 0xFB4C, wxS("betrafehebrew") },
  { 0x09AD, wxS("bhabengali") },
  { 0x092D, wxS("bhadeva") },
  { 0x0AAD, wxS("bhagujarati") },
  { 0x0A2D, wxS("bhagurmukhi") },
  { 0x0253, wxS("bhook") },
  { 0x3073, wxS("bihiragana") },
  { 0x30D3, wxS("bikatakana") },
  { 0x0298, wxS("bilabialclick") },
  { 0x0A02, wxS("bindigurmukhi") },
  { 0x3331, wxS("birusquare") },
  { 0x25CF, wxS("blackcircle") },
  { 0x25C6, wxS("blackdiamond") },
  { 0x25BC, wxS("blackdownpointingtriangle") },
  { 0x25C4, wxS("blackleftpointingpointer") },
  { 0x25C0, wxS("blackleftpointingtriangle") },
  { 0x3010, wxS("blacklenticularbracketleft") },
  { 0xFE3B, wxS("blacklenticularbracketleftvertical") },
  { 0x3011, wxS("blacklenticularbracketright") },
  { 0xFE3C, wxS("blacklenticularbracketrightvertical") },
  { 0x25E3, wxS("blacklowerlefttriangle") },
  { 0x25E2, wxS("blacklowerrighttriangle") },
  { 0x25AC, wxS("blackrectangle") },
  { 0x25BA, wxS("blackrightpointingpointer") },
  { 0x25B6, wxS("blackrightpointingtriangle") },
  { 0x25AA, wxS("blacksmallsquare") },
  { 0x263B, wxS("blacksmilingface") },
  { 0x25A0, wxS("blacksquare") },
  { 0x2605, wxS("blackstar") },
  { 0x25E4, wxS("blackupperlefttriangle") },
  { 0x25E5, wxS("blackupperrighttriangle") },
  { 0x25B4, wxS("blackuppointingsmalltriangle") },
  { 0x25B2, wxS("blackuppointingtriangle") },
  { 0x2423, wxS("blank") },
  { 0x1E07, wxS("blinebelow") },
  { 0x2588, wxS("block") },
  { 0xFF42, wxS("bmonospace") },
  { 0x0E1A, wxS("bobaimaithai") },
  { 0x307C, wxS("bohiragana") },
  { 0x30DC, wxS("bokatakana") },
  { 0x249D, wxS("bparen") },
  { 0x33C3, wxS("bqsquare") },
  { 0xF8F4, wxS("braceex") },
  { 0x007B, wxS("braceleft") },
  { 0xF8F3, wxS("braceleftbt") },
  { 0xF8F2, wxS("braceleftmid") },
  { 0xFF5B, wxS("braceleftmonospace") },
  { 0xFE5B, wxS("braceleftsmall") },
  { 0xF8F1, wxS("bracelefttp") },
  { 0xFE37, wxS("braceleftvertical") },
  { 0x007D, wxS("braceright") },
  { 0xF8FE, wxS("bracerightbt") },
  { 0xF8FD, wxS("bracerightmid") },
  { 0xFF5D, wxS("bracerightmonospace") },
  { 0xFE5C, wxS("bracerightsmall") },
  { 0xF8FC, wxS("bracerighttp") },
  { 0xFE38, wxS("bracerightvertical") },
  { 0x005B, wxS("bracketleft") },
  { 0xF8F0, wxS("bracketleftbt") },
  { 0xF8EF, wxS("bracketleftex") },
  { 0xFF3B, wxS("bracketleftmonospace") },
  { 0xF8EE, wxS("bracketlefttp") },
  { 0x005D, wxS("bracketright") },
  { 0xF8FB, wxS("bracketrightbt") },
  { 0xF8FA, wxS("bracketrightex") },
  { 0xFF3D, wxS("bracketrightmonospace") },
  { 0xF8F9, wxS("bracketrighttp") },
  { 0x02D8, wxS("breve") },
  { 0x032E, wxS("brevebelowcmb") },
  { 0x0306, wxS("brevecmb") },
  { 0x032F, wxS("breveinvertedbelowcmb") },
  { 0x0311, wxS("breveinvertedcmb") },
  { 0x0361, wxS("breveinverteddoublecmb") },
  { 0x032A, wxS("bridgebelowcmb") },
  { 0x033A, wxS("bridgeinvertedbelowcmb") },
  { 0x00A6, wxS("brokenbar") },
  { 0x0180, wxS("bstroke") },
  { 0xF6EA, wxS("bsuperior") },
  { 0x0183, wxS("btopbar") },
  { 0x3076, wxS("buhiragana") },
  { 0x30D6, wxS("bukatakana") },
  { 0x2022, wxS("bullet") },
  { 0x25D8, wxS("bulletinverse") },
  { 0x2219, wxS("bulletoperator") },
  { 0x25CE, wxS("bullseye") },
  { 0x0063, wxS("c") },
  { 0x056E, wxS("caarmenian") },
  { 0x099A, wxS("cabengali") },
  { 0x0107, wxS("cacute") },
  { 0x091A, wxS("cadeva") },
  { 0x0A9A, wxS("cagujarati") },
  { 0x0A1A, wxS("cagurmukhi") },
  { 0x3388, wxS("calsquare") },
  { 0x0981, wxS("candrabindubengali") },
  { 0x0310, wxS("candrabinducmb") },
  { 0x0901, wxS("candrabindudeva") },
  { 0x0A81, wxS("candrabindugujarati") },
  { 0x21EA, wxS("capslock") },
  { 0x2105, wxS("careof") },
  { 0x02C7, wxS("caron") },
  { 0x032C, wxS("caronbelowcmb") },
  { 0x030C, wxS("caroncmb") },
  { 0x21B5, wxS("carriagereturn") },
  { 0x3118, wxS("cbopomofo") },
  { 0x010D, wxS("ccaron") },
  { 0x00E7, wxS("ccedilla") },
  { 0x1E09, wxS("ccedillaacute") },
  { 0x24D2, wxS("ccircle") },
  { 0x0109, wxS("ccircumflex") },
  { 0x0255, wxS("ccurl") },
  { 0x010B, wxS("cdot") },
  { 0x010B, wxS("cdotaccent") },
  { 0x33C5, wxS("cdsquare") },
  { 0x00B8, wxS("cedilla") },
  { 0x0327, wxS("cedillacmb") },
  { 0x00A2, wxS("cent") },
  { 0x2103, wxS("centigrade") },
  { 0xF6DF, wxS("centinferior") },
  { 0xFFE0, wxS("centmonospace") },
  { 0xF7A2, wxS("centoldstyle") },
  { 0xF6E0, wxS("centsuperior") },
  { 0x0579, wxS("chaarmenian") },
  { 0x099B, wxS("chabengali") },
  { 0x091B, wxS("chadeva") },
  { 0x0A9B, wxS("chagujarati") },
  { 0x0A1B, wxS("chagurmukhi") },
  { 0x3114, wxS("chbopomofo") },
  { 0x04BD, wxS("cheabkhasiancyrillic") },
  { 0x2713, wxS("checkmark") },
  { 0x0447, wxS("checyrillic") },
  { 0x04BF, wxS("chedescenderabkhasiancyrillic") },
  { 0x04B7, wxS("chedescendercyrillic") },
  { 0x04F5, wxS("chedieresiscyrillic") },
  { 0x0573, wxS("cheharmenian") },
  { 0x04CC, wxS("chekhakassiancyrillic") },
  { 0x04B9, wxS("cheverticalstrokecyrillic") },
  { 0x03C7, wxS("chi") },
  { 0x3277, wxS("chieuchacirclekorean") },
  { 0x3217, wxS("chieuchaparenkorean") },
  { 0x3269, wxS("chieuchcirclekorean") },
  { 0x314A, wxS("chieuchkorean") },
  { 0x3209, wxS("chieuchparenkorean") },
  { 0x0E0A, wxS("chochangthai") },
  { 0x0E08, wxS("chochanthai") },
  { 0x0E09, wxS("chochingthai") },
  { 0x0E0C, wxS("chochoethai") },
  { 0x0188, wxS("chook") },
  { 0x3276, wxS("cieucacirclekorean") },
  { 0x3216, wxS("cieucaparenkorean") },
  { 0x3268, wxS("cieuccirclekorean") },
  { 0x3148, wxS("cieuckorean") },
  { 0x3208, wxS("cieucparenkorean") },
  { 0x321C, wxS("cieucuparenkorean") },
  { 0x25CB, wxS("circle") },
  { 0x2297, wxS("circlemultiply") },
  { 0x2299, wxS("circleot") },
  { 0x2295, wxS("circleplus") },
  { 0x3036, wxS("circlepostalmark") },
  { 0x25D0, wxS("circlewithlefthalfblack") },
  { 0x25D1, wxS("circlewithrighthalfblack") },
  { 0x02C6, wxS("circumflex") },
  { 0x032D, wxS("circumflexbelowcmb") },
  { 0x0302, wxS("circumflexcmb") },
  { 0x2327, wxS("clear") },
  { 0x01C2, wxS("clickalveolar") },
  { 0x01C0, wxS("clickdental") },
  { 0x01C1, wxS("clicklateral") },
  { 0x01C3, wxS("clickretroflex") },
  { 0x2663, wxS("club") },
  { 0x2663, wxS("clubsuitblack") },
  { 0x2667, wxS("clubsuitwhite") },
  { 0x33A4, wxS("cmcubedsquare") },
  { 0xFF43, wxS("cmonospace") },
  { 0x33A0, wxS("cmsquaredsquare") },
  { 0x0581, wxS("coarmenian") },
  { 0x003A, wxS("colon") },
  { 0x20A1, wxS("colonmonetary") },
  { 0xFF1A, wxS("colonmonospace") },
  { 0x20A1, wxS("colonsign") },
  { 0xFE55, wxS("colonsmall") },
  { 0x02D1, wxS("colontriangularhalfmod") },
  { 0x02D0, wxS("colontriangularmod") },
  { 0x002C, wxS("comma") },
  { 0x0313, wxS("commaabovecmb") },
  { 0x0315, wxS("commaaboverightcmb") },
  { 0xF6C3, wxS("commaaccent") },
  { 0x060C, wxS("commaarabic") },
  { 0x055D, wxS("commaarmenian") },
  { 0xF6E1, wxS("commainferior") },
  { 0xFF0C, wxS("commamonospace") },
  { 0x0314, wxS("commareversedabovecmb") },
  { 0x02BD, wxS("commareversedmod") },
  { 0xFE50, wxS("commasmall") },
  { 0xF6E2, wxS("commasuperior") },
  { 0x0312, wxS("commaturnedabovecmb") },
  { 0x02BB, wxS("commaturnedmod") },
  { 0x263C, wxS("compass") },
  { 0x2245, wxS("congruent") },
  { 0x222E, wxS("contourintegral") },
  { 0x2303, wxS("control") },
  { 0x0006, wxS("controlACK") },
  { 0x0007, wxS("controlBEL") },
  { 0x0008, wxS("controlBS") },
  { 0x0018, wxS("controlCAN") },
  { 0x000D, wxS("controlCR") },
  { 0x0011, wxS("controlDC1") },
  { 0x0012, wxS("controlDC2") },
  { 0x0013, wxS("controlDC3") },
  { 0x0014, wxS("controlDC4") },
  { 0x007F, wxS("controlDEL") },
  { 0x0010, wxS("controlDLE") },
  { 0x0019, wxS("controlEM") },
  { 0x0005, wxS("controlENQ") },
  { 0x0004, wxS("controlEOT") },
  { 0x001B, wxS("controlESC") },
  { 0x0017, wxS("controlETB") },
  { 0x0003, wxS("controlETX") },
  { 0x000C, wxS("controlFF") },
  { 0x001C, wxS("controlFS") },
  { 0x001D, wxS("controlGS") },
  { 0x0009, wxS("controlHT") },
  { 0x000A, wxS("controlLF") },
  { 0x0015, wxS("controlNAK") },
  { 0x001E, wxS("controlRS") },
  { 0x000F, wxS("controlSI") },
  { 0x000E, wxS("controlSO") },
  { 0x0002, wxS("controlSOT") },
  { 0x0001, wxS("controlSTX") },
  { 0x001A, wxS("controlSUB") },
  { 0x0016, wxS("controlSYN") },
  { 0x001F, wxS("controlUS") },
  { 0x000B, wxS("controlVT") },
  { 0x00A9, wxS("copyright") },
  { 0xF8E9, wxS("copyrightsans") },
  { 0xF6D9, wxS("copyrightserif") },
  { 0x300C, wxS("cornerbracketleft") },
  { 0xFF62, wxS("cornerbracketlefthalfwidth") },
  { 0xFE41, wxS("cornerbracketleftvertical") },
  { 0x300D, wxS("cornerbracketright") },
  { 0xFF63, wxS("cornerbracketrighthalfwidth") },
  { 0xFE42, wxS("cornerbracketrightvertical") },
  { 0x337F, wxS("corporationsquare") },
  { 0x33C7, wxS("cosquare") },
  { 0x33C6, wxS("coverkgsquare") },
  { 0x249E, wxS("cparen") },
  { 0x20A2, wxS("cruzeiro") },
  { 0x0297, wxS("cstretched") },
  { 0x22CF, wxS("curlyand") },
  { 0x22CE, wxS("curlyor") },
  { 0x00A4, wxS("currency") },
  { 0xF6D1, wxS("cyrBreve") },
  { 0xF6D2, wxS("cyrFlex") },
  { 0xF6D4, wxS("cyrbreve") },
  { 0xF6D5, wxS("cyrflex") },
  { 0x0064, wxS("d") },
  { 0x0564, wxS("daarmenian") },
  { 0x09A6, wxS("dabengali") },
  { 0x0636, wxS("dadarabic") },
  { 0x0926, wxS("dadeva") },
  { 0xFEBE, wxS("dadfinalarabic") },
  { 0xFEBF, wxS("dadinitialarabic") },
  { 0xFEC0, wxS("dadmedialarabic") },
  { 0x05BC, wxS("dagesh") },
  { 0x05BC, wxS("dageshhebrew") },
  { 0x2020, wxS("dagger") },
  { 0x2021, wxS("daggerdbl") },
  { 0x0AA6, wxS("dagujarati") },
  { 0x0A26, wxS("dagurmukhi") },
  { 0x3060, wxS("dahiragana") },
  { 0x30C0, wxS("dakatakana") },
  { 0x062F, wxS("dalarabic") },
  { 0x05D3, wxS("dalet") },
  { 0xFB33, wxS("daletdagesh") },
  { 0xFB33, wxS("daletdageshhebrew") },
  { 0x05D3, wxS("dalethebrew") },
  { 0xFEAA, wxS("dalfinalarabic") },
  { 0x064F, wxS("dammaarabic") },
  { 0x064F, wxS("dammalowarabic") },
  { 0x064C, wxS("dammatanaltonearabic") },
  { 0x064C, wxS("dammatanarabic") },
  { 0x0964, wxS("danda") },
  { 0x05A7, wxS("dargahebrew") },
  { 0x05A7, wxS("dargalefthebrew") },
  { 0x0485, wxS("dasiapneumatacyrilliccmb") },
  { 0xF6D3, wxS("dblGrave") },
  { 0x300A, wxS("dblanglebracketleft") },
  { 0xFE3D, wxS("dblanglebracketleftvertical") },
  { 0x300B, wxS("dblanglebracketright") },
  { 0xFE3E, wxS("dblanglebracketrightvertical") },
  { 0x032B, wxS("dblarchinvertedbelowcmb") },
  { 0x21D4, wxS("dblarrowleft") },
  { 0x21D2, wxS("dblarrowright") },
  { 0x0965, wxS("dbldanda") },
  { 0xF6D6, wxS("dblgrave") },
  { 0x030F, wxS("dblgravecmb") },
  { 0x222C, wxS("dblintegral") },
  { 0x2017, wxS("dbllowline") },
  { 0x0333, wxS("dbllowlinecmb") },
  { 0x033F, wxS("dbloverlinecmb") },
  { 0x02BA, wxS("dblprimemod") },
  { 0x2016, wxS("dblverticalbar") },
  { 0x030E, wxS("dblverticallineabovecmb") },
  { 0x3109, wxS("dbopomofo") },
  { 0x33C8, wxS("dbsquare") },
  { 0x010F, wxS("dcaron") },
  { 0x1E11, wxS("dcedilla") },
  { 0x24D3, wxS("dcircle") },
  { 0x1E13, wxS("dcircumflexbelow") },
  { 0x0111, wxS("dcroat") },
  { 0x09A1, wxS("ddabengali") },
  { 0x0921, wxS("ddadeva") },
  { 0x0AA1, wxS("ddagujarati") },
  { 0x0A21, wxS("ddagurmukhi") },
  { 0x0688, wxS("ddalarabic") },
  { 0xFB89, wxS("ddalfinalarabic") },
  { 0x095C, wxS("dddhadeva") },
  { 0x09A2, wxS("ddhabengali") },
  { 0x0922, wxS("ddhadeva") },
  { 0x0AA2, wxS("ddhagujarati") },
  { 0x0A22, wxS("ddhagurmukhi") },
  { 0x1E0B, wxS("ddotaccent") },
  { 0x1E0D, wxS("ddotbelow") },
  { 0x066B, wxS("decimalseparatorarabic") },
  { 0x066B, wxS("decimalseparatorpersian") },
  { 0x0434, wxS("decyrillic") },
  { 0x00B0, wxS("degree") },
  { 0x05AD, wxS("dehihebrew") },
  { 0x3067, wxS("dehiragana") },
  { 0x03EF, wxS("deicoptic") },
  { 0x30C7, wxS("dekatakana") },
  { 0x232B, wxS("deleteleft") },
  { 0x2326, wxS("deleteright") },
  { 0x03B4, wxS("delta") },
  { 0x018D, wxS("deltaturned") },
  { 0x09F8, wxS("denominatorminusonenumeratorbengali") },
  { 0x02A4, wxS("dezh") },
  { 0x09A7, wxS("dhabengali") },
  { 0x0927, wxS("dhadeva") },
  { 0x0AA7, wxS("dhagujarati") },
  { 0x0A27, wxS("dhagurmukhi") },
  { 0x0257, wxS("dhook") },
  { 0x0385, wxS("dialytikatonos") },
  { 0x0344, wxS("dialytikatonoscmb") },
  { 0x2666, wxS("diamond") },
  { 0x2662, wxS("diamondsuitwhite") },
  { 0x00A8, wxS("dieresis") },
  { 0xF6D7, wxS("dieresisacute") },
  { 0x0324, wxS("dieresisbelowcmb") },
  { 0x0308, wxS("dieresiscmb") },
  { 0xF6D8, wxS("dieresisgrave") },
  { 0x0385, wxS("dieresistonos") },
  { 0x3062, wxS("dihiragana") },
  { 0x30C2, wxS("dikatakana") },
  { 0x3003, wxS("dittomark") },
  { 0x00F7, wxS("divide") },
  { 0x2223, wxS("divides") },
  { 0x2215, wxS("divisionslash") },
  { 0x0452, wxS("djecyrillic") },
  { 0x2593, wxS("dkshade") },
  { 0x1E0F, wxS("dlinebelow") },
  { 0x3397, wxS("dlsquare") },
  { 0x0111, wxS("dmacron") },
  { 0xFF44, wxS("dmonospace") },
  { 0x2584, wxS("dnblock") },
  { 0x0E0E, wxS("dochadathai") },
  { 0x0E14, wxS("dodekthai") },
  { 0x3069, wxS("dohiragana") },
  { 0x30C9, wxS("dokatakana") },
  { 0x0024, wxS("dollar") },
  { 0xF6E3, wxS("dollarinferior") },
  { 0xFF04, wxS("dollarmonospace") },
  { 0xF724, wxS("dollaroldstyle") },
  { 0xFE69, wxS("dollarsmall") },
  { 0xF6E4, wxS("dollarsuperior") },
  { 0x20AB, wxS("dong") },
  { 0x3326, wxS("dorusquare") },
  { 0x02D9, wxS("dotaccent") },
  { 0x0307, wxS("dotaccentcmb") },
  { 0x0323, wxS("dotbelowcmb") },
  { 0x0323, wxS("dotbelowcomb") },
  { 0x30FB, wxS("dotkatakana") },
  { 0x0131, wxS("dotlessi") },
  { 0xF6BE, wxS("dotlessj") },
  { 0x0284, wxS("dotlessjstrokehook") },
  { 0x22C5, wxS("dotmath") },
  { 0x25CC, wxS("dottedcircle") },
  { 0xFB1F, wxS("doubleyodpatah") },
  { 0xFB1F, wxS("doubleyodpatahhebrew") },
  { 0x031E, wxS("downtackbelowcmb") },
  { 0x02D5, wxS("downtackmod") },
  { 0x249F, wxS("dparen") },
  { 0xF6EB, wxS("dsuperior") },
  { 0x0256, wxS("dtail") },
  { 0x018C, wxS("dtopbar") },
  { 0x3065, wxS("duhiragana") },
  { 0x30C5, wxS("dukatakana") },
  { 0x01F3, wxS("dz") },
  { 0x02A3, wxS("dzaltone") },
  { 0x01C6, wxS("dzcaron") },
  { 0x02A5, wxS("dzcurl") },
  { 0x04E1, wxS("dzeabkhasiancyrillic") },
  { 0x0455, wxS("dzecyrillic") },
  { 0x045F, wxS("dzhecyrillic") },
  { 0x0065, wxS("e") },
  { 0x00E9, wxS("eacute") },
  { 0x2641, wxS("earth") },
  { 0x098F, wxS("ebengali") },
  { 0x311C, wxS("ebopomofo") },
  { 0x0115, wxS("ebreve") },
  { 0x090D, wxS("ecandradeva") },
  { 0x0A8D, wxS("ecandragujarati") },
  { 0x0945, wxS("ecandravowelsigndeva") },
  { 0x0AC5, wxS("ecandravowelsigngujarati") },
  { 0x011B, wxS("ecaron") },
  { 0x1E1D, wxS("ecedillabreve") },
  { 0x0565, wxS("echarmenian") },
  { 0x0587, wxS("echyiwnarmenian") },
  { 0x24D4, wxS("ecircle") },
  { 0x00EA, wxS("ecircumflex") },
  { 0x1EBF, wxS("ecircumflexacute") },
  { 0x1E19, wxS("ecircumflexbelow") },
  { 0x1EC7, wxS("ecircumflexdotbelow") },
  { 0x1EC1, wxS("ecircumflexgrave") },
  { 0x1EC3, wxS("ecircumflexhookabove") },
  { 0x1EC5, wxS("ecircumflextilde") },
  { 0x0454, wxS("ecyrillic") },
  { 0x0205, wxS("edblgrave") },
  { 0x090F, wxS("edeva") },
  { 0x00EB, wxS("edieresis") },
  { 0x0117, wxS("edot") },
  { 0x0117, wxS("edotaccent") },
  { 0x1EB9, wxS("edotbelow") },
  { 0x0A0F, wxS("eegurmukhi") },
  { 0x0A47, wxS("eematragurmukhi") },
  { 0x0444, wxS("efcyrillic") },
  { 0x00E8, wxS("egrave") },
  { 0x0A8F, wxS("egujarati") },
  { 0x0567, wxS("eharmenian") },
  { 0x311D, wxS("ehbopomofo") },
  { 0x3048, wxS("ehiragana") },
  { 0x1EBB, wxS("ehookabove") },
  { 0x311F, wxS("eibopomofo") },
  { 0x0038, wxS("eight") },
  { 0x0668, wxS("eightarabic") },
  { 0x09EE, wxS("eightbengali") },
  { 0x2467, wxS("eightcircle") },
  { 0x2791, wxS("eightcircleinversesansserif") },
  { 0x096E, wxS("eightdeva") },
  { 0x2471, wxS("eighteencircle") },
  { 0x2485, wxS("eighteenparen") },
  { 0x2499, wxS("eighteenperiod") },
  { 0x0AEE, wxS("eightgujarati") },
  { 0x0A6E, wxS("eightgurmukhi") },
  { 0x0668, wxS("eighthackarabic") },
  { 0x3028, wxS("eighthangzhou") },
  { 0x266B, wxS("eighthnotebeamed") },
  { 0x3227, wxS("eightideographicparen") },
  { 0x2088, wxS("eightinferior") },
  { 0xFF18, wxS("eightmonospace") },
  { 0xF738, wxS("eightoldstyle") },
  { 0x247B, wxS("eightparen") },
  { 0x248F, wxS("eightperiod") },
  { 0x06F8, wxS("eightpersian") },
  { 0x2177, wxS("eightroman") },
  { 0x2078, wxS("eightsuperior") },
  { 0x0E58, wxS("eightthai") },
  { 0x0207, wxS("einvertedbreve") },
  { 0x0465, wxS("eiotifiedcyrillic") },
  { 0x30A8, wxS("ekatakana") },
  { 0xFF74, wxS("ekatakanahalfwidth") },
  { 0x0A74, wxS("ekonkargurmukhi") },
  { 0x3154, wxS("ekorean") },
  { 0x043B, wxS("elcyrillic") },
  { 0x2208, wxS("element") },
  { 0x246A, wxS("elevencircle") },
  { 0x247E, wxS("elevenparen") },
  { 0x2492, wxS("elevenperiod") },
  { 0x217A, wxS("elevenroman") },
  { 0x2026, wxS("ellipsis") },
  { 0x22EE, wxS("ellipsisvertical") },
  { 0x0113, wxS("emacron") },
  { 0x1E17, wxS("emacronacute") },
  { 0x1E15, wxS("emacrongrave") },
  { 0x043C, wxS("emcyrillic") },
  { 0x2014, wxS("emdash") },
  { 0xFE31, wxS("emdashvertical") },
  { 0xFF45, wxS("emonospace") },
  { 0x055B, wxS("emphasismarkarmenian") },
  { 0x2205, wxS("emptyset") },
  { 0x3123, wxS("enbopomofo") },
  { 0x043D, wxS("encyrillic") },
  { 0x2013, wxS("endash") },
  { 0xFE32, wxS("endashvertical") },
  { 0x04A3, wxS("endescendercyrillic") },
  { 0x014B, wxS("eng") },
  { 0x3125, wxS("engbopomofo") },
  { 0x04A5, wxS("enghecyrillic") },
  { 0x04C8, wxS("enhookcyrillic") },
  { 0x2002, wxS("enspace") },
  { 0x0119, wxS("eogonek") },
  { 0x3153, wxS("eokorean") },
  { 0x025B, wxS("eopen") },
  { 0x029A, wxS("eopenclosed") },
  { 0x025C, wxS("eopenreversed") },
  { 0x025E, wxS("eopenreversedclosed") },
  { 0x025D, wxS("eopenreversedhook") },
  { 0x24A0, wxS("eparen") },
  { 0x03B5, wxS("epsilon") },
  { 0x03AD, wxS("epsilontonos") },
  { 0x003D, wxS("equal") },
  { 0xFF1D, wxS("equalmonospace") },
  { 0xFE66, wxS("equalsmall") },
  { 0x207C, wxS("equalsuperior") },
  { 0x2261, wxS("equivalence") },
  { 0x3126, wxS("erbopomofo") },
  { 0x0440, wxS("ercyrillic") },
  { 0x0258, wxS("ereversed") },
  { 0x044D, wxS("ereversedcyrillic") },
  { 0x0441, wxS("escyrillic") },
  { 0x04AB, wxS("esdescendercyrillic") },
  { 0x0283, wxS("esh") },
  { 0x0286, wxS("eshcurl") },
  { 0x090E, wxS("eshortdeva") },
  { 0x0946, wxS("eshortvowelsigndeva") },
  { 0x01AA, wxS("eshreversedloop") },
  { 0x0285, wxS("eshsquatreversed") },
  { 0x3047, wxS("esmallhiragana") },
  { 0x30A7, wxS("esmallkatakana") },
  { 0xFF6A, wxS("esmallkatakanahalfwidth") },
  { 0x212E, wxS("estimated") },
  { 0xF6EC, wxS("esuperior") },
  { 0x03B7, wxS("eta") },
  { 0x0568, wxS("etarmenian") },
  { 0x03AE, wxS("etatonos") },
  { 0x00F0, wxS("eth") },
  { 0x1EBD, wxS("etilde") },
  { 0x1E1B, wxS("etildebelow") },
  { 0x0591, wxS("etnahtafoukhhebrew") },
  { 0x0591, wxS("etnahtafoukhlefthebrew") },
  { 0x0591, wxS("etnahtahebrew") },
  { 0x0591, wxS("etnahtalefthebrew") },
  { 0x01DD, wxS("eturned") },
  { 0x3161, wxS("eukorean") },
  { 0x20AC, wxS("euro") },
  { 0x09C7, wxS("evowelsignbengali") },
  { 0x0947, wxS("evowelsigndeva") },
  { 0x0AC7, wxS("evowelsigngujarati") },
  { 0x0021, wxS("exclam") },
  { 0x055C, wxS("exclamarmenian") },
  { 0x203C, wxS("exclamdbl") },
  { 0x00A1, wxS("exclamdown") },
  { 0xF7A1, wxS("exclamdownsmall") },
  { 0xFF01, wxS("exclammonospace") },
  { 0xF721, wxS("exclamsmall") },
  { 0x2203, wxS("existential") },
  { 0x0292, wxS("ezh") },
  { 0x01EF, wxS("ezhcaron") },
  { 0x0293, wxS("ezhcurl") },
  { 0x01B9, wxS("ezhreversed") },
  { 0x01BA, wxS("ezhtail") },
  { 0x0066, wxS("f") },
  { 0x095E, wxS("fadeva") },
  { 0x0A5E, wxS("fagurmukhi") },
  { 0x2109, wxS("fahrenheit") },
  { 0x064E, wxS("fathaarabic") },
  { 0x064E, wxS("fathalowarabic") },
  { 0x064B, wxS("fathatanarabic") },
  { 0x3108, wxS("fbopomofo") },
  { 0x24D5, wxS("fcircle") },
  { 0x1E1F, wxS("fdotaccent") },
  { 0x0641, wxS("feharabic") },
  { 0x0586, wxS("feharmenian") },
  { 0xFED2, wxS("fehfinalarabic") },
  { 0xFED3, wxS("fehinitialarabic") },
  { 0xFED4, wxS("fehmedialarabic") },
  { 0x03E5, wxS("feicoptic") },
  { 0x2640, wxS("female") },
  { 0xFB00, wxS("ff") },
  { 0xFB03, wxS("ffi") },
  { 0xFB04, wxS("ffl") },
  { 0xFB01, wxS("fi") },
  { 0x246E, wxS("fifteencircle") },
  { 0x2482, wxS("fifteenparen") },
  { 0x2496, wxS("fifteenperiod") },
  { 0x2012, wxS("figuredash") },
  { 0x25A0, wxS("filledbox") },
  { 0x25AC, wxS("filledrect") },
  { 0x05DA, wxS("finalkaf") },
  { 0xFB3A, wxS("finalkafdagesh") },
  { 0xFB3A, wxS("finalkafdageshhebrew") },
  { 0x05DA, wxS("finalkafhebrew") },
  { 0x05DD, wxS("finalmem") },
  { 0x05DD, wxS("finalmemhebrew") },
  { 0x05DF, wxS("finalnun") },
  { 0x05DF, wxS("finalnunhebrew") },
  { 0x05E3, wxS("finalpe") },
  { 0x05E3, wxS("finalpehebrew") },
  { 0x05E5, wxS("finaltsadi") },
  { 0x05E5, wxS("finaltsadihebrew") },
  { 0x02C9, wxS("firsttonechinese") },
  { 0x25C9, wxS("fisheye") },
  { 0x0473, wxS("fitacyrillic") },
  { 0x0035, wxS("five") },
  { 0x0665, wxS("fivearabic") },
  { 0x09EB, wxS("fivebengali") },
  { 0x2464, wxS("fivecircle") },
  { 0x278E, wxS("fivecircleinversesansserif") },
  { 0x096B, wxS("fivedeva") },
  { 0x215D, wxS("fiveeighths") },
  { 0x0AEB, wxS("fivegujarati") },
  { 0x0A6B, wxS("fivegurmukhi") },
  { 0x0665, wxS("fivehackarabic") },
  { 0x3025, wxS("fivehangzhou") },
  { 0x3224, wxS("fiveideographicparen") },
  { 0x2085, wxS("fiveinferior") },
  { 0xFF15, wxS("fivemonospace") },
  { 0xF735, wxS("fiveoldstyle") },
  { 0x2478, wxS("fiveparen") },
  { 0x248C, wxS("fiveperiod") },
  { 0x06F5, wxS("fivepersian") },
  { 0x2174, wxS("fiveroman") },
  { 0x2075, wxS("fivesuperior") },
  { 0x0E55, wxS("fivethai") },
  { 0xFB02, wxS("fl") },
  { 0x0192, wxS("florin") },
  { 0xFF46, wxS("fmonospace") },
  { 0x3399, wxS("fmsquare") },
  { 0x0E1F, wxS("fofanthai") },
  { 0x0E1D, wxS("fofathai") },
  { 0x0E4F, wxS("fongmanthai") },
  { 0x2200, wxS("forall") },
  { 0x0034, wxS("four") },
  { 0x0664, wxS("fourarabic") },
  { 0x09EA, wxS("fourbengali") },
  { 0x2463, wxS("fourcircle") },
  { 0x278D, wxS("fourcircleinversesansserif") },
  { 0x096A, wxS("fourdeva") },
  { 0x0AEA, wxS("fourgujarati") },
  { 0x0A6A, wxS("fourgurmukhi") },
  { 0x0664, wxS("fourhackarabic") },
  { 0x3024, wxS("fourhangzhou") },
  { 0x3223, wxS("fourideographicparen") },
  { 0x2084, wxS("fourinferior") },
  { 0xFF14, wxS("fourmonospace") },
  { 0x09F7, wxS("fournumeratorbengali") },
  { 0xF734, wxS("fouroldstyle") },
  { 0x2477, wxS("fourparen") },
  { 0x248B, wxS("fourperiod") },
  { 0x06F4, wxS("fourpersian") },
  { 0x2173, wxS("fourroman") },
  { 0x2074, wxS("foursuperior") },
  { 0x246D, wxS("fourteencircle") },
  { 0x2481, wxS("fourteenparen") },
  { 0x2495, wxS("fourteenperiod") },
  { 0x0E54, wxS("fourthai") },
  { 0x02CB, wxS("fourthtonechinese") },
  { 0x24A1, wxS("fparen") },
  { 0x2044, wxS("fraction") },
  { 0x20A3, wxS("franc") },
  { 0x0067, wxS("g") },
  { 0x0997, wxS("gabengali") },
  { 0x01F5, wxS("gacute") },
  { 0x0917, wxS("gadeva") },
  { 0x06AF, wxS("gafarabic") },
  { 0xFB93, wxS("gaffinalarabic") },
  { 0xFB94, wxS("gafinitialarabic") },
  { 0xFB95, wxS("gafmedialarabic") },
  { 0x0A97, wxS("gagujarati") },
  { 0x0A17, wxS("gagurmukhi") },
  { 0x304C, wxS("gahiragana") },
  { 0x30AC, wxS("gakatakana") },
  { 0x03B3, wxS("gamma") },
  { 0x0263, wxS("gammalatinsmall") },
  { 0x02E0, wxS("gammasuperior") },
  { 0x03EB, wxS("gangiacoptic") },
  { 0x310D, wxS("gbopomofo") },
  { 0x011F, wxS("gbreve") },
  { 0x01E7, wxS("gcaron") },
  { 0x0123, wxS("gcedilla") },
  { 0x24D6, wxS("gcircle") },
  { 0x011D, wxS("gcircumflex") },
  { 0x0123, wxS("gcommaaccent") },
  { 0x0121, wxS("gdot") },
  { 0x0121, wxS("gdotaccent") },
  { 0x0433, wxS("gecyrillic") },
  { 0x3052, wxS("gehiragana") },
  { 0x30B2, wxS("gekatakana") },
  { 0x2251, wxS("geometricallyequal") },
  { 0x059C, wxS("gereshaccenthebrew") },
  { 0x05F3, wxS("gereshhebrew") },
  { 0x059D, wxS("gereshmuqdamhebrew") },
  { 0x00DF, wxS("germandbls") },
  { 0x059E, wxS("gershayimaccenthebrew") },
  { 0x05F4, wxS("gershayimhebrew") },
  { 0x3013, wxS("getamark") },
  { 0x0998, wxS("ghabengali") },
  { 0x0572, wxS("ghadarmenian") },
  { 0x0918, wxS("ghadeva") },
  { 0x0A98, wxS("ghagujarati") },
  { 0x0A18, wxS("ghagurmukhi") },
  { 0x063A, wxS("ghainarabic") },
  { 0xFECE, wxS("ghainfinalarabic") },
  { 0xFECF, wxS("ghaininitialarabic") },
  { 0xFED0, wxS("ghainmedialarabic") },
  { 0x0495, wxS("ghemiddlehookcyrillic") },
  { 0x0493, wxS("ghestrokecyrillic") },
  { 0x0491, wxS("gheupturncyrillic") },
  { 0x095A, wxS("ghhadeva") },
  { 0x0A5A, wxS("ghhagurmukhi") },
  { 0x0260, wxS("ghook") },
  { 0x3393, wxS("ghzsquare") },
  { 0x304E, wxS("gihiragana") },
  { 0x30AE, wxS("gikatakana") },
  { 0x0563, wxS("gimarmenian") },
  { 0x05D2, wxS("gimel") },
  { 0xFB32, wxS("gimeldagesh") },
  { 0xFB32, wxS("gimeldageshhebrew") },
  { 0x05D2, wxS("gimelhebrew") },
  { 0x0453, wxS("gjecyrillic") },
  { 0x01BE, wxS("glottalinvertedstroke") },
  { 0x0294, wxS("glottalstop") },
  { 0x0296, wxS("glottalstopinverted") },
  { 0x02C0, wxS("glottalstopmod") },
  { 0x0295, wxS("glottalstopreversed") },
  { 0x02C1, wxS("glottalstopreversedmod") },
  { 0x02E4, wxS("glottalstopreversedsuperior") },
  { 0x02A1, wxS("glottalstopstroke") },
  { 0x02A2, wxS("glottalstopstrokereversed") },
  { 0x1E21, wxS("gmacron") },
  { 0xFF47, wxS("gmonospace") },
  { 0x3054, wxS("gohiragana") },
  { 0x30B4, wxS("gokatakana") },
  { 0x24A2, wxS("gparen") },
  { 0x33AC, wxS("gpasquare") },
  { 0x2207, wxS("gradient") },
  { 0x0060, wxS("grave") },
  { 0x0316, wxS("gravebelowcmb") },
  { 0x0300, wxS("gravecmb") },
  { 0x0300, wxS("gravecomb") },
  { 0x0953, wxS("gravedeva") },
  { 0x02CE, wxS("gravelowmod") },
  { 0xFF40, wxS("gravemonospace") },
  { 0x0340, wxS("gravetonecmb") },
  { 0x003E, wxS("greater") },
  { 0x2265, wxS("greaterequal") },
  { 0x22DB, wxS("greaterequalorless") },
  { 0xFF1E, wxS("greatermonospace") },
  { 0x2273, wxS("greaterorequivalent") },
  { 0x2277, wxS("greaterorless") },
  { 0x2267, wxS("greateroverequal") },
  { 0xFE65, wxS("greatersmall") },
  { 0x0261, wxS("gscript") },
  { 0x01E5, wxS("gstroke") },
  { 0x3050, wxS("guhiragana") },
  { 0x00AB, wxS("guillemotleft") },
  { 0x00BB, wxS("guillemotright") },
  { 0x2039, wxS("guilsinglleft") },
  { 0x203A, wxS("guilsinglright") },
  { 0x30B0, wxS("gukatakana") },
  { 0x3318, wxS("guramusquare") },
  { 0x33C9, wxS("gysquare") },
  { 0x0068, wxS("h") },
  { 0x04A9, wxS("haabkhasiancyrillic") },
  { 0x06C1, wxS("haaltonearabic") },
  { 0x09B9, wxS("habengali") },
  { 0x04B3, wxS("hadescendercyrillic") },
  { 0x0939, wxS("hadeva") },
  { 0x0AB9, wxS("hagujarati") },
  { 0x0A39, wxS("hagurmukhi") },
  { 0x062D, wxS("haharabic") },
  { 0xFEA2, wxS("hahfinalarabic") },
  { 0xFEA3, wxS("hahinitialarabic") },
  { 0x306F, wxS("hahiragana") },
  { 0xFEA4, wxS("hahmedialarabic") },
  { 0x332A, wxS("haitusquare") },
  { 0x30CF, wxS("hakatakana") },
  { 0xFF8A, wxS("hakatakanahalfwidth") },
  { 0x0A4D, wxS("halantgurmukhi") },
  { 0x0621, wxS("hamzaarabic") },
  { 0x0621, wxS("hamzalowarabic") },
  { 0x3164, wxS("hangulfiller") },
  { 0x044A, wxS("hardsigncyrillic") },
  { 0x21BC, wxS("harpoonleftbarbup") },
  { 0x21C0, wxS("harpoonrightbarbup") },
  { 0x33CA, wxS("hasquare") },
  { 0x05B2, wxS("hatafpatah") },
  { 0x05B2, wxS("hatafpatah16") },
  { 0x05B2, wxS("hatafpatah23") },
  { 0x05B2, wxS("hatafpatah2f") },
  { 0x05B2, wxS("hatafpatahhebrew") },
  { 0x05B2, wxS("hatafpatahnarrowhebrew") },
  { 0x05B2, wxS("hatafpatahquarterhebrew") },
  { 0x05B2, wxS("hatafpatahwidehebrew") },
  { 0x05B3, wxS("hatafqamats") },
  { 0x05B3, wxS("hatafqamats1b") },
  { 0x05B3, wxS("hatafqamats28") },
  { 0x05B3, wxS("hatafqamats34") },
  { 0x05B3, wxS("hatafqamatshebrew") },
  { 0x05B3, wxS("hatafqamatsnarrowhebrew") },
  { 0x05B3, wxS("hatafqamatsquarterhebrew") },
  { 0x05B3, wxS("hatafqamatswidehebrew") },
  { 0x05B1, wxS("hatafsegol") },
  { 0x05B1, wxS("hatafsegol17") },
  { 0x05B1, wxS("hatafsegol24") },
  { 0x05B1, wxS("hatafsegol30") },
  { 0x05B1, wxS("hatafsegolhebrew") },
  { 0x05B1, wxS("hatafsegolnarrowhebrew") },
  { 0x05B1, wxS("hatafsegolquarterhebrew") },
  { 0x05B1, wxS("hatafsegolwidehebrew") },
  { 0x0127, wxS("hbar") },
  { 0x310F, wxS("hbopomofo") },
  { 0x1E2B, wxS("hbrevebelow") },
  { 0x1E29, wxS("hcedilla") },
  { 0x24D7, wxS("hcircle") },
  { 0x0125, wxS("hcircumflex") },
  { 0x1E27, wxS("hdieresis") },
  { 0x1E23, wxS("hdotaccent") },
  { 0x1E25, wxS("hdotbelow") },
  { 0x05D4, wxS("he") },
  { 0x2665, wxS("heart") },
  { 0x2665, wxS("heartsuitblack") },
  { 0x2661, wxS("heartsuitwhite") },
  { 0xFB34, wxS("hedagesh") },
  { 0xFB34, wxS("hedageshhebrew") },
  { 0x06C1, wxS("hehaltonearabic") },
  { 0x0647, wxS("heharabic") },
  { 0x05D4, wxS("hehebrew") },
  { 0xFBA7, wxS("hehfinalaltonearabic") },
  { 0xFEEA, wxS("hehfinalalttwoarabic") },
  { 0xFEEA, wxS("hehfinalarabic") },
  { 0xFBA5, wxS("hehhamzaabovefinalarabic") },
  { 0xFBA4, wxS("hehhamzaaboveisolatedarabic") },
  { 0xFBA8, wxS("hehinitialaltonearabic") },
  { 0xFEEB, wxS("hehinitialarabic") },
  { 0x3078, wxS("hehiragana") },
  { 0xFBA9, wxS("hehmedialaltonearabic") },
  { 0xFEEC, wxS("hehmedialarabic") },
  { 0x337B, wxS("heiseierasquare") },
  { 0x30D8, wxS("hekatakana") },
  { 0xFF8D, wxS("hekatakanahalfwidth") },
  { 0x3336, wxS("hekutaarusquare") },
  { 0x0267, wxS("henghook") },
  { 0x3339, wxS("herutusquare") },
  { 0x05D7, wxS("het") },
  { 0x05D7, wxS("hethebrew") },
  { 0x0266, wxS("hhook") },
  { 0x02B1, wxS("hhooksuperior") },
  { 0x327B, wxS("hieuhacirclekorean") },
  { 0x321B, wxS("hieuhaparenkorean") },
  { 0x326D, wxS("hieuhcirclekorean") },
  { 0x314E, wxS("hieuhkorean") },
  { 0x320D, wxS("hieuhparenkorean") },
  { 0x3072, wxS("hihiragana") },
  { 0x30D2, wxS("hikatakana") },
  { 0xFF8B, wxS("hikatakanahalfwidth") },
  { 0x05B4, wxS("hiriq") },
  { 0x05B4, wxS("hiriq14") },
  { 0x05B4, wxS("hiriq21") },
  { 0x05B4, wxS("hiriq2d") },
  { 0x05B4, wxS("hiriqhebrew") },
  { 0x05B4, wxS("hiriqnarrowhebrew") },
  { 0x05B4, wxS("hiriqquarterhebrew") },
  { 0x05B4, wxS("hiriqwidehebrew") },
  { 0x1E96, wxS("hlinebelow") },
  { 0xFF48, wxS("hmonospace") },
  { 0x0570, wxS("hoarmenian") },
  { 0x0E2B, wxS("hohipthai") },
  { 0x307B, wxS("hohiragana") },
  { 0x30DB, wxS("hokatakana") },
  { 0xFF8E, wxS("hokatakanahalfwidth") },
  { 0x05B9, wxS("holam") },
  { 0x05B9, wxS("holam19") },
  { 0x05B9, wxS("holam26") },
  { 0x05B9, wxS("holam32") },
  { 0x05B9, wxS("holamhebrew") },
  { 0x05B9, wxS("holamnarrowhebrew") },
  { 0x05B9, wxS("holamquarterhebrew") },
  { 0x05B9, wxS("holamwidehebrew") },
  { 0x0E2E, wxS("honokhukthai") },
  { 0x0309, wxS("hookabovecomb") },
  { 0x0309, wxS("hookcmb") },
  { 0x0321, wxS("hookpalatalizedbelowcmb") },
  { 0x0322, wxS("hookretroflexbelowcmb") },
  { 0x3342, wxS("hoonsquare") },
  { 0x03E9, wxS("horicoptic") },
  { 0x2015, wxS("horizontalbar") },
  { 0x031B, wxS("horncmb") },
  { 0x2668, wxS("hotsprings") },
  { 0x2302, wxS("house") },
  { 0x24A3, wxS("hparen") },
  { 0x02B0, wxS("hsuperior") },
  { 0x0265, wxS("hturned") },
  { 0x3075, wxS("huhiragana") },
  { 0x3333, wxS("huiitosquare") },
  { 0x30D5, wxS("hukatakana") },
  { 0xFF8C, wxS("hukatakanahalfwidth") },
  { 0x02DD, wxS("hungarumlaut") },
  { 0x030B, wxS("hungarumlautcmb") },
  { 0x0195, wxS("hv") },
  { 0x002D, wxS("hyphen") },
  { 0xF6E5, wxS("hypheninferior") },
  { 0xFF0D, wxS("hyphenmonospace") },
  { 0xFE63, wxS("hyphensmall") },
  { 0xF6E6, wxS("hyphensuperior") },
  { 0x2010, wxS("hyphentwo") },
  { 0x0069, wxS("i") },
  { 0x00ED, wxS("iacute") },
  { 0x044F, wxS("iacyrillic") },
  { 0x0987, wxS("ibengali") },
  { 0x3127, wxS("ibopomofo") },
  { 0x012D, wxS("ibreve") },
  { 0x01D0, wxS("icaron") },
  { 0x24D8, wxS("icircle") },
  { 0x00EE, wxS("icircumflex") },
  { 0x0456, wxS("icyrillic") },
  { 0x0209, wxS("idblgrave") },
  { 0x328F, wxS("ideographearthcircle") },
  { 0x328B, wxS("ideographfirecircle") },
  { 0x323F, wxS("ideographicallianceparen") },
  { 0x323A, wxS("ideographiccallparen") },
  { 0x32A5, wxS("ideographiccentrecircle") },
  { 0x3006, wxS("ideographicclose") },
  { 0x3001, wxS("ideographiccomma") },
  { 0xFF64, wxS("ideographiccommaleft") },
  { 0x3237, wxS("ideographiccongratulationparen") },
  { 0x32A3, wxS("ideographiccorrectcircle") },
  { 0x322F, wxS("ideographicearthparen") },
  { 0x323D, wxS("ideographicenterpriseparen") },
  { 0x329D, wxS("ideographicexcellentcircle") },
  { 0x3240, wxS("ideographicfestivalparen") },
  { 0x3296, wxS("ideographicfinancialcircle") },
  { 0x3236, wxS("ideographicfinancialparen") },
  { 0x322B, wxS("ideographicfireparen") },
  { 0x3232, wxS("ideographichaveparen") },
  { 0x32A4, wxS("ideographichighcircle") },
  { 0x3005, wxS("ideographiciterationmark") },
  { 0x3298, wxS("ideographiclaborcircle") },
  { 0x3238, wxS("ideographiclaborparen") },
  { 0x32A7, wxS("ideographicleftcircle") },
  { 0x32A6, wxS("ideographiclowcircle") },
  { 0x32A9, wxS("ideographicmedicinecircle") },
  { 0x322E, wxS("ideographicmetalparen") },
  { 0x322A, wxS("ideographicmoonparen") },
  { 0x3234, wxS("ideographicnameparen") },
  { 0x3002, wxS("ideographicperiod") },
  { 0x329E, wxS("ideographicprintcircle") },
  { 0x3243, wxS("ideographicreachparen") },
  { 0x3239, wxS("ideographicrepresentparen") },
  { 0x323E, wxS("ideographicresourceparen") },
  { 0x32A8, wxS("ideographicrightcircle") },
  { 0x3299, wxS("ideographicsecretcircle") },
  { 0x3242, wxS("ideographicselfparen") },
  { 0x3233, wxS("ideographicsocietyparen") },
  { 0x3000, wxS("ideographicspace") },
  { 0x3235, wxS("ideographicspecialparen") },
  { 0x3231, wxS("ideographicstockparen") },
  { 0x323B, wxS("ideographicstudyparen") },
  { 0x3230, wxS("ideographicsunparen") },
  { 0x323C, wxS("ideographicsuperviseparen") },
  { 0x322C, wxS("ideographicwaterparen") },
  { 0x322D, wxS("ideographicwoodparen") },
  { 0x3007, wxS("ideographiczero") },
  { 0x328E, wxS("ideographmetalcircle") },
  { 0x328A, wxS("ideographmooncircle") },
  { 0x3294, wxS("ideographnamecircle") },
  { 0x3290, wxS("ideographsuncircle") },
  { 0x328C, wxS("ideographwatercircle") },
  { 0x328D, wxS("ideographwoodcircle") },
  { 0x0907, wxS("ideva") },
  { 0x00EF, wxS("idieresis") },
  { 0x1E2F, wxS("idieresisacute") },
  { 0x04E5, wxS("idieresiscyrillic") },
  { 0x1ECB, wxS("idotbelow") },
  { 0x04D7, wxS("iebrevecyrillic") },
  { 0x0435, wxS("iecyrillic") },
  { 0x3275, wxS("ieungacirclekorean") },
  { 0x3215, wxS("ieungaparenkorean") },
  { 0x3267, wxS("ieungcirclekorean") },
  { 0x3147, wxS("ieungkorean") },
  { 0x3207, wxS("ieungparenkorean") },
  { 0x00EC, wxS("igrave") },
  { 0x0A87, wxS("igujarati") },
  { 0x0A07, wxS("igurmukhi") },
  { 0x3044, wxS("ihiragana") },
  { 0x1EC9, wxS("ihookabove") },
  { 0x0988, wxS("iibengali") },
  { 0x0438, wxS("iicyrillic") },
  { 0x0908, wxS("iideva") },
  { 0x0A88, wxS("iigujarati") },
  { 0x0A08, wxS("iigurmukhi") },
  { 0x0A40, wxS("iimatragurmukhi") },
  { 0x020B, wxS("iinvertedbreve") },
  { 0x0439, wxS("iishortcyrillic") },
  { 0x09C0, wxS("iivowelsignbengali") },
  { 0x0940, wxS("iivowelsigndeva") },
  { 0x0AC0, wxS("iivowelsigngujarati") },
  { 0x0133, wxS("ij") },
  { 0x30A4, wxS("ikatakana") },
  { 0xFF72, wxS("ikatakanahalfwidth") },
  { 0x3163, wxS("ikorean") },
  { 0x02DC, wxS("ilde") },
  { 0x05AC, wxS("iluyhebrew") },
  { 0x012B, wxS("imacron") },
  { 0x04E3, wxS("imacroncyrillic") },
  { 0x2253, wxS("imageorapproximatelyequal") },
  { 0x0A3F, wxS("imatragurmukhi") },
  { 0xFF49, wxS("imonospace") },
  { 0x2206, wxS("increment") },
  { 0x221E, wxS("infinity") },
  { 0x056B, wxS("iniarmenian") },
  { 0x222B, wxS("integral") },
  { 0x2321, wxS("integralbottom") },
  { 0x2321, wxS("integralbt") },
  { 0xF8F5, wxS("integralex") },
  { 0x2320, wxS("integraltop") },
  { 0x2320, wxS("integraltp") },
  { 0x2229, wxS("intersection") },
  { 0x3305, wxS("intisquare") },
  { 0x25D8, wxS("invbullet") },
  { 0x25D9, wxS("invcircle") },
  { 0x263B, wxS("invsmileface") },
  { 0x0451, wxS("iocyrillic") },
  { 0x012F, wxS("iogonek") },
  { 0x03B9, wxS("iota") },
  { 0x03CA, wxS("iotadieresis") },
  { 0x0390, wxS("iotadieresistonos") },
  { 0x0269, wxS("iotalatin") },
  { 0x03AF, wxS("iotatonos") },
  { 0x24A4, wxS("iparen") },
  { 0x0A72, wxS("irigurmukhi") },
  { 0x3043, wxS("ismallhiragana") },
  { 0x30A3, wxS("ismallkatakana") },
  { 0xFF68, wxS("ismallkatakanahalfwidth") },
  { 0x09FA, wxS("issharbengali") },
  { 0x0268, wxS("istroke") },
  { 0xF6ED, wxS("isuperior") },
  { 0x309D, wxS("iterationhiragana") },
  { 0x30FD, wxS("iterationkatakana") },
  { 0x0129, wxS("itilde") },
  { 0x1E2D, wxS("itildebelow") },
  { 0x3129, wxS("iubopomofo") },
  { 0x044E, wxS("iucyrillic") },
  { 0x09BF, wxS("ivowelsignbengali") },
  { 0x093F, wxS("ivowelsigndeva") },
  { 0x0ABF, wxS("ivowelsigngujarati") },
  { 0x0475, wxS("izhitsacyrillic") },
  { 0x0477, wxS("izhitsadblgravecyrillic") },
  { 0x006A, wxS("j") },
  { 0x0571, wxS("jaarmenian") },
  { 0x099C, wxS("jabengali") },
  { 0x091C, wxS("jadeva") },
  { 0x0A9C, wxS("jagujarati") },
  { 0x0A1C, wxS("jagurmukhi") },
  { 0x3110, wxS("jbopomofo") },
  { 0x01F0, wxS("jcaron") },
  { 0x24D9, wxS("jcircle") },
  { 0x0135, wxS("jcircumflex") },
  { 0x029D, wxS("jcrossedtail") },
  { 0x025F, wxS("jdotlessstroke") },
  { 0x0458, wxS("jecyrillic") },
  { 0x062C, wxS("jeemarabic") },
  { 0xFE9E, wxS("jeemfinalarabic") },
  { 0xFE9F, wxS("jeeminitialarabic") },
  { 0xFEA0, wxS("jeemmedialarabic") },
  { 0x0698, wxS("jeharabic") },
  { 0xFB8B, wxS("jehfinalarabic") },
  { 0x099D, wxS("jhabengali") },
  { 0x091D, wxS("jhadeva") },
  { 0x0A9D, wxS("jhagujarati") },
  { 0x0A1D, wxS("jhagurmukhi") },
  { 0x057B, wxS("jheharmenian") },
  { 0x3004, wxS("jis") },
  { 0xFF4A, wxS("jmonospace") },
  { 0x24A5, wxS("jparen") },
  { 0x02B2, wxS("jsuperior") },
  { 0x006B, wxS("k") },
  { 0x04A1, wxS("kabashkircyrillic") },
  { 0x0995, wxS("kabengali") },
  { 0x1E31, wxS("kacute") },
  { 0x043A, wxS("kacyrillic") },
  { 0x049B, wxS("kadescendercyrillic") },
  { 0x0915, wxS("kadeva") },
  { 0x05DB, wxS("kaf") },
  { 0x0643, wxS("kafarabic") },
  { 0xFB3B, wxS("kafdagesh") },
  { 0xFB3B, wxS("kafdageshhebrew") },
  { 0xFEDA, wxS("kaffinalarabic") },
  { 0x05DB, wxS("kafhebrew") },
  { 0xFEDB, wxS("kafinitialarabic") },
  { 0xFEDC, wxS("kafmedialarabic") },
  { 0xFB4D, wxS("kafrafehebrew") },
  { 0x0A95, wxS("kagujarati") },
  { 0x0A15, wxS("kagurmukhi") },
  { 0x304B, wxS("kahiragana") },
  { 0x04C4, wxS("kahookcyrillic") },
  { 0x30AB, wxS("kakatakana") },
  { 0xFF76, wxS("kakatakanahalfwidth") },
  { 0x03BA, wxS("kappa") },
  { 0x03F0, wxS("kappasymbolgreek") },
  { 0x3171, wxS("kapyeounmieumkorean") },
  { 0x3184, wxS("kapyeounphieuphkorean") },
  { 0x3178, wxS("kapyeounpieupkorean") },
  { 0x3179, wxS("kapyeounssangpieupkorean") },
  { 0x330D, wxS("karoriisquare") },
  { 0x0640, wxS("kashidaautoarabic") },
  { 0x0640, wxS("kashidaautonosidebearingarabic") },
  { 0x30F5, wxS("kasmallkatakana") },
  { 0x3384, wxS("kasquare") },
  { 0x0650, wxS("kasraarabic") },
  { 0x064D, wxS("kasratanarabic") },
  { 0x049F, wxS("kastrokecyrillic") },
  { 0xFF70, wxS("katahiraprolongmarkhalfwidth") },
  { 0x049D, wxS("kaverticalstrokecyrillic") },
  { 0x310E, wxS("kbopomofo") },
  { 0x3389, wxS("kcalsquare") },
  { 0x01E9, wxS("kcaron") },
  { 0x0137, wxS("kcedilla") },
  { 0x24DA, wxS("kcircle") },
  { 0x0137, wxS("kcommaaccent") },
  { 0x1E33, wxS("kdotbelow") },
  { 0x0584, wxS("keharmenian") },
  { 0x3051, wxS("kehiragana") },
  { 0x30B1, wxS("kekatakana") },
  { 0xFF79, wxS("kekatakanahalfwidth") },
  { 0x056F, wxS("kenarmenian") },
  { 0x30F6, wxS("kesmallkatakana") },
  { 0x0138, wxS("kgreenlandic") },
  { 0x0996, wxS("khabengali") },
  { 0x0445, wxS("khacyrillic") },
  { 0x0916, wxS("khadeva") },
  { 0x0A96, wxS("khagujarati") },
  { 0x0A16, wxS("khagurmukhi") },
  { 0x062E, wxS("khaharabic") },
  { 0xFEA6, wxS("khahfinalarabic") },
  { 0xFEA7, wxS("khahinitialarabic") },
  { 0xFEA8, wxS("khahmedialarabic") },
  { 0x03E7, wxS("kheicoptic") },
  { 0x0959, wxS("khhadeva") },
  { 0x0A59, wxS("khhagurmukhi") },
  { 0x3278, wxS("khieukhacirclekorean") },
  { 0x3218, wxS("khieukhaparenkorean") },
  { 0x326A, wxS("khieukhcirclekorean") },
  { 0x314B, wxS("khieukhkorean") },
  { 0x320A, wxS("khieukhparenkorean") },
  { 0x0E02, wxS("khokhaithai") },
  { 0x0E05, wxS("khokhonthai") },
  { 0x0E03, wxS("khokhuatthai") },
  { 0x0E04, wxS("khokhwaithai") },
  { 0x0E5B, wxS("khomutthai") },
  { 0x0199, wxS("khook") },
  { 0x0E06, wxS("khorakhangthai") },
  { 0x3391, wxS("khzsquare") },
  { 0x304D, wxS("kihiragana") },
  { 0x30AD, wxS("kikatakana") },
  { 0xFF77, wxS("kikatakanahalfwidth") },
  { 0x3315, wxS("kiroguramusquare") },
  { 0x3316, wxS("kiromeetorusquare") },
  { 0x3314, wxS("kirosquare") },
  { 0x326E, wxS("kiyeokacirclekorean") },
  { 0x320E, wxS("kiyeokaparenkorean") },
  { 0x3260, wxS("kiyeokcirclekorean") },
  { 0x3131, wxS("kiyeokkorean") },
  { 0x3200, wxS("kiyeokparenkorean") },
  { 0x3133, wxS("kiyeoksioskorean") },
  { 0x045C, wxS("kjecyrillic") },
  { 0x1E35, wxS("klinebelow") },
  { 0x3398, wxS("klsquare") },
  { 0x33A6, wxS("kmcubedsquare") },
  { 0xFF4B, wxS("kmonospace") },
  { 0x33A2, wxS("kmsquaredsquare") },
  { 0x3053, wxS("kohiragana") },
  { 0x33C0, wxS("kohmsquare") },
  { 0x0E01, wxS("kokaithai") },
  { 0x30B3, wxS("kokatakana") },
  { 0xFF7A, wxS("kokatakanahalfwidth") },
  { 0x331E, wxS("kooposquare") },
  { 0x0481, wxS("koppacyrillic") },
  { 0x327F, wxS("koreanstandardsymbol") },
  { 0x0343, wxS("koroniscmb") },
  { 0x24A6, wxS("kparen") },
  { 0x33AA, wxS("kpasquare") },
  { 0x046F, wxS("ksicyrillic") },
  { 0x33CF, wxS("ktsquare") },
  { 0x029E, wxS("kturned") },
  { 0x304F, wxS("kuhiragana") },
  { 0x30AF, wxS("kukatakana") },
  { 0xFF78, wxS("kukatakanahalfwidth") },
  { 0x33B8, wxS("kvsquare") },
  { 0x33BE, wxS("kwsquare") },
  { 0x006C, wxS("l") },
  { 0x09B2, wxS("labengali") },
  { 0x013A, wxS("lacute") },
  { 0x0932, wxS("ladeva") },
  { 0x0AB2, wxS("lagujarati") },
  { 0x0A32, wxS("lagurmukhi") },
  { 0x0E45, wxS("lakkhangyaothai") },
  { 0xFEFC, wxS("lamaleffinalarabic") },
  { 0xFEF8, wxS("lamalefhamzaabovefinalarabic") },
  { 0xFEF7, wxS("lamalefhamzaaboveisolatedarabic") },
  { 0xFEFA, wxS("lamalefhamzabelowfinalarabic") },
  { 0xFEF9, wxS("lamalefhamzabelowisolatedarabic") },
  { 0xFEFB, wxS("lamalefisolatedarabic") },
  { 0xFEF6, wxS("lamalefmaddaabovefinalarabic") },
  { 0xFEF5, wxS("lamalefmaddaaboveisolatedarabic") },
  { 0x0644, wxS("lamarabic") },
  { 0x03BB, wxS("lambda") },
  { 0x019B, wxS("lambdastroke") },
  { 0x05DC, wxS("lamed") },
  { 0xFB3C, wxS("lameddagesh") },
  { 0xFB3C, wxS("lameddageshhebrew") },
  { 0x05DC, wxS("lamedhebrew") },
  { 0xFEDE, wxS("lamfinalarabic") },
  { 0xFCCA, wxS("lamhahinitialarabic") },
  { 0xFEDF, wxS("laminitialarabic") },
  { 0xFCC9, wxS("lamjeeminitialarabic") },
  { 0xFCCB, wxS("lamkhahinitialarabic") },
  { 0xFDF2, wxS("lamlamhehisolatedarabic") },
  { 0xFEE0, wxS("lammedialarabic") },
  { 0xFD88, wxS("lammeemhahinitialarabic") },
  { 0xFCCC, wxS("lammeeminitialarabic") },
  { 0x25EF, wxS("largecircle") },
  { 0x019A, wxS("lbar") },
  { 0x026C, wxS("lbelt") },
  { 0x310C, wxS("lbopomofo") },
  { 0x013E, wxS("lcaron") },
  { 0x013C, wxS("lcedilla") },
  { 0x24DB, wxS("lcircle") },
  { 0x1E3D, wxS("lcircumflexbelow") },
  { 0x013C, wxS("lcommaaccent") },
  { 0x0140, wxS("ldot") },
  { 0x0140, wxS("ldotaccent") },
  { 0x1E37, wxS("ldotbelow") },
  { 0x1E39, wxS("ldotbelowmacron") },
  { 0x031A, wxS("leftangleabovecmb") },
  { 0x0318, wxS("lefttackbelowcmb") },
  { 0x003C, wxS("less") },
  { 0x2264, wxS("lessequal") },
  { 0x22DA, wxS("lessequalorgreater") },
  { 0xFF1C, wxS("lessmonospace") },
  { 0x2272, wxS("lessorequivalent") },
  { 0x2276, wxS("lessorgreater") },
  { 0x2266, wxS("lessoverequal") },
  { 0xFE64, wxS("lesssmall") },
  { 0x026E, wxS("lezh") },
  { 0x258C, wxS("lfblock") },
  { 0x026D, wxS("lhookretroflex") },
  { 0x20A4, wxS("lira") },
  { 0x056C, wxS("liwnarmenian") },
  { 0x01C9, wxS("lj") },
  { 0x0459, wxS("ljecyrillic") },
  { 0xF6C0, wxS("ll") },
  { 0x0933, wxS("lladeva") },
  { 0x0AB3, wxS("llagujarati") },
  { 0x1E3B, wxS("llinebelow") },
  { 0x0934, wxS("llladeva") },
  { 0x09E1, wxS("llvocalicbengali") },
  { 0x0961, wxS("llvocalicdeva") },
  { 0x09E3, wxS("llvocalicvowelsignbengali") },
  { 0x0963, wxS("llvocalicvowelsigndeva") },
  { 0x026B, wxS("lmiddletilde") },
  { 0xFF4C, wxS("lmonospace") },
  { 0x33D0, wxS("lmsquare") },
  { 0x0E2C, wxS("lochulathai") },
  { 0x2227, wxS("logicaland") },
  { 0x00AC, wxS("logicalnot") },
  { 0x2310, wxS("logicalnotreversed") },
  { 0x2228, wxS("logicalor") },
  { 0x0E25, wxS("lolingthai") },
  { 0x017F, wxS("longs") },
  { 0xFE4E, wxS("lowlinecenterline") },
  { 0x0332, wxS("lowlinecmb") },
  { 0xFE4D, wxS("lowlinedashed") },
  { 0x25CA, wxS("lozenge") },
  { 0x24A7, wxS("lparen") },
  { 0x0142, wxS("lslash") },
  { 0x2113, wxS("lsquare") },
  { 0xF6EE, wxS("lsuperior") },
  { 0x2591, wxS("ltshade") },
  { 0x0E26, wxS("luthai") },
  { 0x098C, wxS("lvocalicbengali") },
  { 0x090C, wxS("lvocalicdeva") },
  { 0x09E2, wxS("lvocalicvowelsignbengali") },
  { 0x0962, wxS("lvocalicvowelsigndeva") },
  { 0x33D3, wxS("lxsquare") },
  { 0x006D, wxS("m") },
  { 0x09AE, wxS("mabengali") },
  { 0x00AF, wxS("macron") },
  { 0x0331, wxS("macronbelowcmb") },
  { 0x0304, wxS("macroncmb") },
  { 0x02CD, wxS("macronlowmod") },
  { 0xFFE3, wxS("macronmonospace") },
  { 0x1E3F, wxS("macute") },
  { 0x092E, wxS("madeva") },
  { 0x0AAE, wxS("magujarati") },
  { 0x0A2E, wxS("magurmukhi") },
  { 0x05A4, wxS("mahapakhhebrew") },
  { 0x05A4, wxS("mahapakhlefthebrew") },
  { 0x307E, wxS("mahiragana") },
  { 0xF895, wxS("maichattawalowleftthai") },
  { 0xF894, wxS("maichattawalowrightthai") },
  { 0x0E4B, wxS("maichattawathai") },
  { 0xF893, wxS("maichattawaupperleftthai") },
  { 0xF88C, wxS("maieklowleftthai") },
  { 0xF88B, wxS("maieklowrightthai") },
  { 0x0E48, wxS("maiekthai") },
  { 0xF88A, wxS("maiekupperleftthai") },
  { 0xF884, wxS("maihanakatleftthai") },
  { 0x0E31, wxS("maihanakatthai") },
  { 0xF889, wxS("maitaikhuleftthai") },
  { 0x0E47, wxS("maitaikhuthai") },
  { 0xF88F, wxS("maitholowleftthai") },
  { 0xF88E, wxS("maitholowrightthai") },
  { 0x0E49, wxS("maithothai") },
  { 0xF88D, wxS("maithoupperleftthai") },
  { 0xF892, wxS("maitrilowleftthai") },
  { 0xF891, wxS("maitrilowrightthai") },
  { 0x0E4A, wxS("maitrithai") },
  { 0xF890, wxS("maitriupperleftthai") },
  { 0x0E46, wxS("maiyamokthai") },
  { 0x30DE, wxS("makatakana") },
  { 0xFF8F, wxS("makatakanahalfwidth") },
  { 0x2642, wxS("male") },
  { 0x3347, wxS("mansyonsquare") },
  { 0x05BE, wxS("maqafhebrew") },
  { 0x2642, wxS("mars") },
  { 0x05AF, wxS("masoracirclehebrew") },
  { 0x3383, wxS("masquare") },
  { 0x3107, wxS("mbopomofo") },
  { 0x33D4, wxS("mbsquare") },
  { 0x24DC, wxS("mcircle") },
  { 0x33A5, wxS("mcubedsquare") },
  { 0x1E41, wxS("mdotaccent") },
  { 0x1E43, wxS("mdotbelow") },
  { 0x0645, wxS("meemarabic") },
  { 0xFEE2, wxS("meemfinalarabic") },
  { 0xFEE3, wxS("meeminitialarabic") },
  { 0xFEE4, wxS("meemmedialarabic") },
  { 0xFCD1, wxS("meemmeeminitialarabic") },
  { 0xFC48, wxS("meemmeemisolatedarabic") },
  { 0x334D, wxS("meetorusquare") },
  { 0x3081, wxS("mehiragana") },
  { 0x337E, wxS("meizierasquare") },
  { 0x30E1, wxS("mekatakana") },
  { 0xFF92, wxS("mekatakanahalfwidth") },
  { 0x05DE, wxS("mem") },
  { 0xFB3E, wxS("memdagesh") },
  { 0xFB3E, wxS("memdageshhebrew") },
  { 0x05DE, wxS("memhebrew") },
  { 0x0574, wxS("menarmenian") },
  { 0x05A5, wxS("merkhahebrew") },
  { 0x05A6, wxS("merkhakefulahebrew") },
  { 0x05A6, wxS("merkhakefulalefthebrew") },
  { 0x05A5, wxS("merkhalefthebrew") },
  { 0x0271, wxS("mhook") },
  { 0x3392, wxS("mhzsquare") },
  { 0xFF65, wxS("middledotkatakanahalfwidth") },
  { 0x00B7, wxS("middot") },
  { 0x3272, wxS("mieumacirclekorean") },
  { 0x3212, wxS("mieumaparenkorean") },
  { 0x3264, wxS("mieumcirclekorean") },
  { 0x3141, wxS("mieumkorean") },
  { 0x3170, wxS("mieumpansioskorean") },
  { 0x3204, wxS("mieumparenkorean") },
  { 0x316E, wxS("mieumpieupkorean") },
  { 0x316F, wxS("mieumsioskorean") },
  { 0x307F, wxS("mihiragana") },
  { 0x30DF, wxS("mikatakana") },
  { 0xFF90, wxS("mikatakanahalfwidth") },
  { 0x2212, wxS("minus") },
  { 0x0320, wxS("minusbelowcmb") },
  { 0x2296, wxS("minuscircle") },
  { 0x02D7, wxS("minusmod") },
  { 0x2213, wxS("minusplus") },
  { 0x2032, wxS("minute") },
  { 0x334A, wxS("miribaarusquare") },
  { 0x3349, wxS("mirisquare") },
  { 0x0270, wxS("mlonglegturned") },
  { 0x3396, wxS("mlsquare") },
  { 0x33A3, wxS("mmcubedsquare") },
  { 0xFF4D, wxS("mmonospace") },
  { 0x339F, wxS("mmsquaredsquare") },
  { 0x3082, wxS("mohiragana") },
  { 0x33C1, wxS("mohmsquare") },
  { 0x30E2, wxS("mokatakana") },
  { 0xFF93, wxS("mokatakanahalfwidth") },
  { 0x33D6, wxS("molsquare") },
  { 0x0E21, wxS("momathai") },
  { 0x33A7, wxS("moverssquare") },
  { 0x33A8, wxS("moverssquaredsquare") },
  { 0x24A8, wxS("mparen") },
  { 0x33AB, wxS("mpasquare") },
  { 0x33B3, wxS("mssquare") },
  { 0xF6EF, wxS("msuperior") },
  { 0x026F, wxS("mturned") },
  { 0x03BC, wxS("mu") },
  { 0x00B5, wxS("mu1") },
  { 0x3382, wxS("muasquare") },
  { 0x226B, wxS("muchgreater") },
  { 0x226A, wxS("muchless") },
  { 0x338C, wxS("mufsquare") },
  { 0x03BC, wxS("mugreek") },
  { 0x338D, wxS("mugsquare") },
  { 0x3080, wxS("muhiragana") },
  { 0x30E0, wxS("mukatakana") },
  { 0xFF91, wxS("mukatakanahalfwidth") },
  { 0x3395, wxS("mulsquare") },
  { 0x00D7, wxS("multiply") },
  { 0x339B, wxS("mumsquare") },
  { 0x05A3, wxS("munahhebrew") },
  { 0x05A3, wxS("munahlefthebrew") },
  { 0x266A, wxS("musicalnote") },
  { 0x266B, wxS("musicalnotedbl") },
  { 0x266D, wxS("musicflatsign") },
  { 0x266F, wxS("musicsharpsign") },
  { 0x33B2, wxS("mussquare") },
  { 0x33B6, wxS("muvsquare") },
  { 0x33BC, wxS("muwsquare") },
  { 0x33B9, wxS("mvmegasquare") },
  { 0x33B7, wxS("mvsquare") },
  { 0x33BF, wxS("mwmegasquare") },
  { 0x33BD, wxS("mwsquare") },
  { 0x006E, wxS("n") },
  { 0x09A8, wxS("nabengali") },
  { 0x2207, wxS("nabla") },
  { 0x0144, wxS("nacute") },
  { 0x0928, wxS("nadeva") },
  { 0x0AA8, wxS("nagujarati") },
  { 0x0A28, wxS("nagurmukhi") },
  { 0x306A, wxS("nahiragana") },
  { 0x30CA, wxS("nakatakana") },
  { 0xFF85, wxS("nakatakanahalfwidth") },
  { 0x0149, wxS("napostrophe") },
  { 0x3381, wxS("nasquare") },
  { 0x310B, wxS("nbopomofo") },
  { 0x00A0, wxS("nbspace") },
  { 0x0148, wxS("ncaron") },
  { 0x0146, wxS("ncedilla") },
  { 0x24DD, wxS("ncircle") },
  { 0x1E4B, wxS("ncircumflexbelow") },
  { 0x0146, wxS("ncommaaccent") },
  { 0x1E45, wxS("ndotaccent") },
  { 0x1E47, wxS("ndotbelow") },
  { 0x306D, wxS("nehiragana") },
  { 0x30CD, wxS("nekatakana") },
  { 0xFF88, wxS("nekatakanahalfwidth") },
  { 0x20AA, wxS("newsheqelsign") },
  { 0x338B, wxS("nfsquare") },
  { 0x0999, wxS("ngabengali") },
  { 0x0919, wxS("ngadeva") },
  { 0x0A99, wxS("ngagujarati") },
  { 0x0A19, wxS("ngagurmukhi") },
  { 0x0E07, wxS("ngonguthai") },
  { 0x3093, wxS("nhiragana") },
  { 0x0272, wxS("nhookleft") },
  { 0x0273, wxS("nhookretroflex") },
  { 0x326F, wxS("nieunacirclekorean") },
  { 0x320F, wxS("nieunaparenkorean") },
  { 0x3135, wxS("nieuncieuckorean") },
  { 0x3261, wxS("nieuncirclekorean") },
  { 0x3136, wxS("nieunhieuhkorean") },
  { 0x3134, wxS("nieunkorean") },
  { 0x3168, wxS("nieunpansioskorean") },
  { 0x3201, wxS("nieunparenkorean") },
  { 0x3167, wxS("nieunsioskorean") },
  { 0x3166, wxS("nieuntikeutkorean") },
  { 0x306B, wxS("nihiragana") },
  { 0x30CB, wxS("nikatakana") },
  { 0xFF86, wxS("nikatakanahalfwidth") },
  { 0xF899, wxS("nikhahitleftthai") },
  { 0x0E4D, wxS("nikhahitthai") },
  { 0x0039, wxS("nine") },
  { 0x0669, wxS("ninearabic") },
  { 0x09EF, wxS("ninebengali") },
  { 0x2468, wxS("ninecircle") },
  { 0x2792, wxS("ninecircleinversesansserif") },
  { 0x096F, wxS("ninedeva") },
  { 0x0AEF, wxS("ninegujarati") },
  { 0x0A6F, wxS("ninegurmukhi") },
  { 0x0669, wxS("ninehackarabic") },
  { 0x3029, wxS("ninehangzhou") },
  { 0x3228, wxS("nineideographicparen") },
  { 0x2089, wxS("nineinferior") },
  { 0xFF19, wxS("ninemonospace") },
  { 0xF739, wxS("nineoldstyle") },
  { 0x247C, wxS("nineparen") },
  { 0x2490, wxS("nineperiod") },
  { 0x06F9, wxS("ninepersian") },
  { 0x2178, wxS("nineroman") },
  { 0x2079, wxS("ninesuperior") },
  { 0x2472, wxS("nineteencircle") },
  { 0x2486, wxS("nineteenparen") },
  { 0x249A, wxS("nineteenperiod") },
  { 0x0E59, wxS("ninethai") },
  { 0x01CC, wxS("nj") },
  { 0x045A, wxS("njecyrillic") },
  { 0x30F3, wxS("nkatakana") },
  { 0xFF9D, wxS("nkatakanahalfwidth") },
  { 0x019E, wxS("nlegrightlong") },
  { 0x1E49, wxS("nlinebelow") },
  { 0xFF4E, wxS("nmonospace") },
  { 0x339A, wxS("nmsquare") },
  { 0x09A3, wxS("nnabengali") },
  { 0x0923, wxS("nnadeva") },
  { 0x0AA3, wxS("nnagujarati") },
  { 0x0A23, wxS("nnagurmukhi") },
  { 0x0929, wxS("nnnadeva") },
  { 0x306E, wxS("nohiragana") },
  { 0x30CE, wxS("nokatakana") },
  { 0xFF89, wxS("nokatakanahalfwidth") },
  { 0x00A0, wxS("nonbreakingspace") },
  { 0x0E13, wxS("nonenthai") },
  { 0x0E19, wxS("nonuthai") },
  { 0x0646, wxS("noonarabic") },
  { 0xFEE6, wxS("noonfinalarabic") },
  { 0x06BA, wxS("noonghunnaarabic") },
  { 0xFB9F, wxS("noonghunnafinalarabic") },
  { 0xFEE7, wxS("nooninitialarabic") },
  { 0xFCD2, wxS("noonjeeminitialarabic") },
  { 0xFC4B, wxS("noonjeemisolatedarabic") },
  { 0xFEE8, wxS("noonmedialarabic") },
  { 0xFCD5, wxS("noonmeeminitialarabic") },
  { 0xFC4E, wxS("noonmeemisolatedarabic") },
  { 0xFC8D, wxS("noonnoonfinalarabic") },
  { 0x220C, wxS("notcontains") },
  { 0x2209, wxS("notelement") },
  { 0x2209, wxS("notelementof") },
  { 0x2260, wxS("notequal") },
  { 0x226F, wxS("notgreater") },
  { 0x2271, wxS("notgreaternorequal") },
  { 0x2279, wxS("notgreaternorless") },
  { 0x2262, wxS("notidentical") },
  { 0x226E, wxS("notless") },
  { 0x2270, wxS("notlessnorequal") },
  { 0x2226, wxS("notparallel") },
  { 0x2280, wxS("notprecedes") },
  { 0x2284, wxS("notsubset") },
  { 0x2281, wxS("notsucceeds") },
  { 0x2285, wxS("notsuperset") },
  { 0x0576, wxS("nowarmenian") },
  { 0x24A9, wxS("nparen") },
  { 0x33B1, wxS("nssquare") },
  { 0x207F, wxS("nsuperior") },
  { 0x00F1, wxS("ntilde") },
  { 0x03BD, wxS("nu") },
  { 0x306C, wxS("nuhiragana") },
  { 0x30CC, wxS("nukatakana") },
  { 0xFF87, wxS("nukatakanahalfwidth") },
  { 0x09BC, wxS("nuktabengali") },
  { 0x093C, wxS("nuktadeva") },
  { 0x0ABC, wxS("nuktagujarati") },
  { 0x0A3C, wxS("nuktagurmukhi") },
  { 0x0023, wxS("numbersign") },
  { 0xFF03, wxS("numbersignmonospace") },
  { 0xFE5F, wxS("numbersignsmall") },
  { 0x0374, wxS("numeralsigngreek") },
  { 0x0375, wxS("numeralsignlowergreek") },
  { 0x2116, wxS("numero") },
  { 0x05E0, wxS("nun") },
  { 0xFB40, wxS("nundagesh") },
  { 0xFB40, wxS("nundageshhebrew") },
  { 0x05E0, wxS("nunhebrew") },
  { 0x33B5, wxS("nvsquare") },
  { 0x33BB, wxS("nwsquare") },
  { 0x099E, wxS("nyabengali") },
  { 0x091E, wxS("nyadeva") },
  { 0x0A9E, wxS("nyagujarati") },
  { 0x0A1E, wxS("nyagurmukhi") },
  { 0x006F, wxS("o") },
  { 0x00F3, wxS("oacute") },
  { 0x0E2D, wxS("oangthai") },
  { 0x0275, wxS("obarred") },
  { 0x04E9, wxS("obarredcyrillic") },
  { 0x04EB, wxS("obarreddieresiscyrillic") },
  { 0x0993, wxS("obengali") },
  { 0x311B, wxS("obopomofo") },
  { 0x014F, wxS("obreve") },
  { 0x0911, wxS("ocandradeva") },
  { 0x0A91, wxS("ocandragujarati") },
  { 0x0949, wxS("ocandravowelsigndeva") },
  { 0x0AC9, wxS("ocandravowelsigngujarati") },
  { 0x01D2, wxS("ocaron") },
  { 0x24DE, wxS("ocircle") },
  { 0x00F4, wxS("ocircumflex") },
  { 0x1ED1, wxS("ocircumflexacute") },
  { 0x1ED9, wxS("ocircumflexdotbelow") },
  { 0x1ED3, wxS("ocircumflexgrave") },
  { 0x1ED5, wxS("ocircumflexhookabove") },
  { 0x1ED7, wxS("ocircumflextilde") },
  { 0x043E, wxS("ocyrillic") },
  { 0x0151, wxS("odblacute") },
  { 0x020D, wxS("odblgrave") },
  { 0x0913, wxS("odeva") },
  { 0x00F6, wxS("odieresis") },
  { 0x04E7, wxS("odieresiscyrillic") },
  { 0x1ECD, wxS("odotbelow") },
  { 0x0153, wxS("oe") },
  { 0x315A, wxS("oekorean") },
  { 0x02DB, wxS("ogonek") },
  { 0x0328, wxS("ogonekcmb") },
  { 0x00F2, wxS("ograve") },
  { 0x0A93, wxS("ogujarati") },
  { 0x0585, wxS("oharmenian") },
  { 0x304A, wxS("ohiragana") },
  { 0x1ECF, wxS("ohookabove") },
  { 0x01A1, wxS("ohorn") },
  { 0x1EDB, wxS("ohornacute") },
  { 0x1EE3, wxS("ohorndotbelow") },
  { 0x1EDD, wxS("ohorngrave") },
  { 0x1EDF, wxS("ohornhookabove") },
  { 0x1EE1, wxS("ohorntilde") },
  { 0x0151, wxS("ohungarumlaut") },
  { 0x01A3, wxS("oi") },
  { 0x020F, wxS("oinvertedbreve") },
  { 0x30AA, wxS("okatakana") },
  { 0xFF75, wxS("okatakanahalfwidth") },
  { 0x3157, wxS("okorean") },
  { 0x05AB, wxS("olehebrew") },
  { 0x014D, wxS("omacron") },
  { 0x1E53, wxS("omacronacute") },
  { 0x1E51, wxS("omacrongrave") },
  { 0x0950, wxS("omdeva") },
  { 0x03C9, wxS("omega") },
  { 0x03D6, wxS("omega1") },
  { 0x0461, wxS("omegacyrillic") },
  { 0x0277, wxS("omegalatinclosed") },
  { 0x047B, wxS("omegaroundcyrillic") },
  { 0x047D, wxS("omegatitlocyrillic") },
  { 0x03CE, wxS("omegatonos") },
  { 0x0AD0, wxS("omgujarati") },
  { 0x03BF, wxS("omicron") },
  { 0x03CC, wxS("omicrontonos") },
  { 0xFF4F, wxS("omonospace") },
  { 0x0031, wxS("one") },
  { 0x0661, wxS("onearabic") },
  { 0x09E7, wxS("onebengali") },
  { 0x2460, wxS("onecircle") },
  { 0x278A, wxS("onecircleinversesansserif") },
  { 0x0967, wxS("onedeva") },
  { 0x2024, wxS("onedotenleader") },
  { 0x215B, wxS("oneeighth") },
  { 0xF6DC, wxS("onefitted") },
  { 0x0AE7, wxS("onegujarati") },
  { 0x0A67, wxS("onegurmukhi") },
  { 0x0661, wxS("onehackarabic") },
  { 0x00BD, wxS("onehalf") },
  { 0x3021, wxS("onehangzhou") },
  { 0x3220, wxS("oneideographicparen") },
  { 0x2081, wxS("oneinferior") },
  { 0xFF11, wxS("onemonospace") },
  { 0x09F4, wxS("onenumeratorbengali") },
  { 0xF731, wxS("oneoldstyle") },
  { 0x2474, wxS("oneparen") },
  { 0x2488, wxS("oneperiod") },
  { 0x06F1, wxS("onepersian") },
  { 0x00BC, wxS("onequarter") },
  { 0x2170, wxS("oneroman") },
  { 0x00B9, wxS("onesuperior") },
  { 0x0E51, wxS("onethai") },
  { 0x2153, wxS("onethird") },
  { 0x01EB, wxS("oogonek") },
  { 0x01ED, wxS("oogonekmacron") },
  { 0x0A13, wxS("oogurmukhi") },
  { 0x0A4B, wxS("oomatragurmukhi") },
  { 0x0254, wxS("oopen") },
  { 0x24AA, wxS("oparen") },
  { 0x25E6, wxS("openbullet") },
  { 0x2325, wxS("option") },
  { 0x00AA, wxS("ordfeminine") },
  { 0x00BA, wxS("ordmasculine") },
  { 0x221F, wxS("orthogonal") },
  { 0x0912, wxS("oshortdeva") },
  { 0x094A, wxS("oshortvowelsigndeva") },
  { 0x00F8, wxS("oslash") },
  { 0x01FF, wxS("oslashacute") },
  { 0x3049, wxS("osmallhiragana") },
  { 0x30A9, wxS("osmallkatakana") },
  { 0xFF6B, wxS("osmallkatakanahalfwidth") },
  { 0x01FF, wxS("ostrokeacute") },
  { 0xF6F0, wxS("osuperior") },
  { 0x047F, wxS("otcyrillic") },
  { 0x00F5, wxS("otilde") },
  { 0x1E4D, wxS("otildeacute") },
  { 0x1E4F, wxS("otildedieresis") },
  { 0x3121, wxS("oubopomofo") },
  { 0x203E, wxS("overline") },
  { 0xFE4A, wxS("overlinecenterline") },
  { 0x0305, wxS("overlinecmb") },
  { 0xFE49, wxS("overlinedashed") },
  { 0xFE4C, wxS("overlinedblwavy") },
  { 0xFE4B, wxS("overlinewavy") },
  { 0x00AF, wxS("overscore") },
  { 0x09CB, wxS("ovowelsignbengali") },
  { 0x094B, wxS("ovowelsigndeva") },
  { 0x0ACB, wxS("ovowelsigngujarati") },
  { 0x0070, wxS("p") },
  { 0x3380, wxS("paampssquare") },
  { 0x332B, wxS("paasentosquare") },
  { 0x09AA, wxS("pabengali") },
  { 0x1E55, wxS("pacute") },
  { 0x092A, wxS("padeva") },
  { 0x21DF, wxS("pagedown") },
  { 0x21DE, wxS("pageup") },
  { 0x0AAA, wxS("pagujarati") },
  { 0x0A2A, wxS("pagurmukhi") },
  { 0x3071, wxS("pahiragana") },
  { 0x0E2F, wxS("paiyannoithai") },
  { 0x30D1, wxS("pakatakana") },
  { 0x0484, wxS("palatalizationcyrilliccmb") },
  { 0x04C0, wxS("palochkacyrillic") },
  { 0x317F, wxS("pansioskorean") },
  { 0x00B6, wxS("paragraph") },
  { 0x2225, wxS("parallel") },
  { 0x0028, wxS("parenleft") },
  { 0xFD3E, wxS("parenleftaltonearabic") },
  { 0xF8ED, wxS("parenleftbt") },
  { 0xF8EC, wxS("parenleftex") },
  { 0x208D, wxS("parenleftinferior") },
  { 0xFF08, wxS("parenleftmonospace") },
  { 0xFE59, wxS("parenleftsmall") },
  { 0x207D, wxS("parenleftsuperior") },
  { 0xF8EB, wxS("parenlefttp") },
  { 0xFE35, wxS("parenleftvertical") },
  { 0x0029, wxS("parenright") },
  { 0xFD3F, wxS("parenrightaltonearabic") },
  { 0xF8F8, wxS("parenrightbt") },
  { 0xF8F7, wxS("parenrightex") },
  { 0x208E, wxS("parenrightinferior") },
  { 0xFF09, wxS("parenrightmonospace") },
  { 0xFE5A, wxS("parenrightsmall") },
  { 0x207E, wxS("parenrightsuperior") },
  { 0xF8F6, wxS("parenrighttp") },
  { 0xFE36, wxS("parenrightvertical") },
  { 0x2202, wxS("partialdiff") },
  { 0x05C0, wxS("paseqhebrew") },
  { 0x0599, wxS("pashtahebrew") },
  { 0x33A9, wxS("pasquare") },
  { 0x05B7, wxS("patah") },
  { 0x05B7, wxS("patah11") },
  { 0x05B7, wxS("patah1d") },
  { 0x05B7, wxS("patah2a") },
  { 0x05B7, wxS("patahhebrew") },
  { 0x05B7, wxS("patahnarrowhebrew") },
  { 0x05B7, wxS("patahquarterhebrew") },
  { 0x05B7, wxS("patahwidehebrew") },
  { 0x05A1, wxS("pazerhebrew") },
  { 0x3106, wxS("pbopomofo") },
  { 0x24DF, wxS("pcircle") },
  { 0x1E57, wxS("pdotaccent") },
  { 0x05E4, wxS("pe") },
  { 0x043F, wxS("pecyrillic") },
  { 0xFB44, wxS("pedagesh") },
  { 0xFB44, wxS("pedageshhebrew") },
  { 0x333B, wxS("peezisquare") },
  { 0xFB43, wxS("pefinaldageshhebrew") },
  { 0x067E, wxS("peharabic") },
  { 0x057A, wxS("peharmenian") },
  { 0x05E4, wxS("pehebrew") },
  { 0xFB57, wxS("pehfinalarabic") },
  { 0xFB58, wxS("pehinitialarabic") },
  { 0x307A, wxS("pehiragana") },
  { 0xFB59, wxS("pehmedialarabic") },
  { 0x30DA, wxS("pekatakana") },
  { 0x04A7, wxS("pemiddlehookcyrillic") },
  { 0xFB4E, wxS("perafehebrew") },
  { 0x0025, wxS("percent") },
  { 0x066A, wxS("percentarabic") },
  { 0xFF05, wxS("percentmonospace") },
  { 0xFE6A, wxS("percentsmall") },
  { 0x002E, wxS("period") },
  { 0x0589, wxS("periodarmenian") },
  { 0x00B7, wxS("periodcentered") },
  { 0xFF61, wxS("periodhalfwidth") },
  { 0xF6E7, wxS("periodinferior") },
  { 0xFF0E, wxS("periodmonospace") },
  { 0xFE52, wxS("periodsmall") },
  { 0xF6E8, wxS("periodsuperior") },
  { 0x0342, wxS("perispomenigreekcmb") },
  { 0x22A5, wxS("perpendicular") },
  { 0x2030, wxS("perthousand") },
  { 0x20A7, wxS("peseta") },
  { 0x338A, wxS("pfsquare") },
  { 0x09AB, wxS("phabengali") },
  { 0x092B, wxS("phadeva") },
  { 0x0AAB, wxS("phagujarati") },
  { 0x0A2B, wxS("phagurmukhi") },
  { 0x03C6, wxS("phi") },
  { 0x03D5, wxS("phi1") },
  { 0x327A, wxS("phieuphacirclekorean") },
  { 0x321A, wxS("phieuphaparenkorean") },
  { 0x326C, wxS("phieuphcirclekorean") },
  { 0x314D, wxS("phieuphkorean") },
  { 0x320C, wxS("phieuphparenkorean") },
  { 0x0278, wxS("philatin") },
  { 0x0E3A, wxS("phinthuthai") },
  { 0x03D5, wxS("phisymbolgreek") },
  { 0x01A5, wxS("phook") },
  { 0x0E1E, wxS("phophanthai") },
  { 0x0E1C, wxS("phophungthai") },
  { 0x0E20, wxS("phosamphaothai") },
  { 0x03C0, wxS("pi") },
  { 0x3273, wxS("pieupacirclekorean") },
  { 0x3213, wxS("pieupaparenkorean") },
  { 0x3176, wxS("pieupcieuckorean") },
  { 0x3265, wxS("pieupcirclekorean") },
  { 0x3172, wxS("pieupkiyeokkorean") },
  { 0x3142, wxS("pieupkorean") },
  { 0x3205, wxS("pieupparenkorean") },
  { 0x3174, wxS("pieupsioskiyeokkorean") },
  { 0x3144, wxS("pieupsioskorean") },
  { 0x3175, wxS("pieupsiostikeutkorean") },
  { 0x3177, wxS("pieupthieuthkorean") },
  { 0x3173, wxS("pieuptikeutkorean") },
  { 0x3074, wxS("pihiragana") },
  { 0x30D4, wxS("pikatakana") },
  { 0x03D6, wxS("pisymbolgreek") },
  { 0x0583, wxS("piwrarmenian") },
  { 0x002B, wxS("plus") },
  { 0x031F, wxS("plusbelowcmb") },
  { 0x2295, wxS("pluscircle") },
  { 0x00B1, wxS("plusminus") },
  { 0x02D6, wxS("plusmod") },
  { 0xFF0B, wxS("plusmonospace") },
  { 0xFE62, wxS("plussmall") },
  { 0x207A, wxS("plussuperior") },
  { 0xFF50, wxS("pmonospace") },
  { 0x33D8, wxS("pmsquare") },
  { 0x307D, wxS("pohiragana") },
  { 0x261F, wxS("pointingindexdownwhite") },
  { 0x261C, wxS("pointingindexleftwhite") },
  { 0x261E, wxS("pointingindexrightwhite") },
  { 0x261D, wxS("pointingindexupwhite") },
  { 0x30DD, wxS("pokatakana") },
  { 0x0E1B, wxS("poplathai") },
  { 0x3012, wxS("postalmark") },
  { 0x3020, wxS("postalmarkface") },
  { 0x24AB, wxS("pparen") },
  { 0x227A, wxS("precedes") },
  { 0x211E, wxS("prescription") },
  { 0x02B9, wxS("primemod") },
  { 0x2035, wxS("primereversed") },
  { 0x220F, wxS("product") },
  { 0x2305, wxS("projective") },
  { 0x30FC, wxS("prolongedkana") },
  { 0x2318, wxS("propellor") },
  { 0x2282, wxS("propersubset") },
  { 0x2283, wxS("propersuperset") },
  { 0x2237, wxS("proportion") },
  { 0x221D, wxS("proportional") },
  { 0x03C8, wxS("psi") },
  { 0x0471, wxS("psicyrillic") },
  { 0x0486, wxS("psilipneumatacyrilliccmb") },
  { 0x33B0, wxS("pssquare") },
  { 0x3077, wxS("puhiragana") },
  { 0x30D7, wxS("pukatakana") },
  { 0x33B4, wxS("pvsquare") },
  { 0x33BA, wxS("pwsquare") },
  { 0x0071, wxS("q") },
  { 0x0958, wxS("qadeva") },
  { 0x05A8, wxS("qadmahebrew") },
  { 0x0642, wxS("qafarabic") },
  { 0xFED6, wxS("qaffinalarabic") },
  { 0xFED7, wxS("qafinitialarabic") },
  { 0xFED8, wxS("qafmedialarabic") },
  { 0x05B8, wxS("qamats") },
  { 0x05B8, wxS("qamats10") },
  { 0x05B8, wxS("qamats1a") },
  { 0x05B8, wxS("qamats1c") },
  { 0x05B8, wxS("qamats27") },
  { 0x05B8, wxS("qamats29") },
  { 0x05B8, wxS("qamats33") },
  { 0x05B8, wxS("qamatsde") },
  { 0x05B8, wxS("qamatshebrew") },
  { 0x05B8, wxS("qamatsnarrowhebrew") },
  { 0x05B8, wxS("qamatsqatanhebrew") },
  { 0x05B8, wxS("qamatsqatannarrowhebrew") },
  { 0x05B8, wxS("qamatsqatanquarterhebrew") },
  { 0x05B8, wxS("qamatsqatanwidehebrew") },
  { 0x05B8, wxS("qamatsquarterhebrew") },
  { 0x05B8, wxS("qamatswidehebrew") },
  { 0x059F, wxS("qarneyparahebrew") },
  { 0x3111, wxS("qbopomofo") },
  { 0x24E0, wxS("qcircle") },
  { 0x02A0, wxS("qhook") },
  { 0xFF51, wxS("qmonospace") },
  { 0x05E7, wxS("qof") },
  { 0xFB47, wxS("qofdagesh") },
  { 0xFB47, wxS("qofdageshhebrew") },
  { 0x05E7, wxS("qofhebrew") },
  { 0x24AC, wxS("qparen") },
  { 0x2669, wxS("quarternote") },
  { 0x05BB, wxS("qubuts") },
  { 0x05BB, wxS("qubuts18") },
  { 0x05BB, wxS("qubuts25") },
  { 0x05BB, wxS("qubuts31") },
  { 0x05BB, wxS("qubutshebrew") },
  { 0x05BB, wxS("qubutsnarrowhebrew") },
  { 0x05BB, wxS("qubutsquarterhebrew") },
  { 0x05BB, wxS("qubutswidehebrew") },
  { 0x003F, wxS("question") },
  { 0x061F, wxS("questionarabic") },
  { 0x055E, wxS("questionarmenian") },
  { 0x00BF, wxS("questiondown") },
  { 0xF7BF, wxS("questiondownsmall") },
  { 0x037E, wxS("questiongreek") },
  { 0xFF1F, wxS("questionmonospace") },
  { 0xF73F, wxS("questionsmall") },
  { 0x0022, wxS("quotedbl") },
  { 0x201E, wxS("quotedblbase") },
  { 0x201C, wxS("quotedblleft") },
  { 0xFF02, wxS("quotedblmonospace") },
  { 0x301E, wxS("quotedblprime") },
  { 0x301D, wxS("quotedblprimereversed") },
  { 0x201D, wxS("quotedblright") },
  { 0x2018, wxS("quoteleft") },
  { 0x201B, wxS("quoteleftreversed") },
  { 0x201B, wxS("quotereversed") },
  { 0x2019, wxS("quoteright") },
  { 0x0149, wxS("quoterightn") },
  { 0x201A, wxS("quotesinglbase") },
  { 0x0027, wxS("quotesingle") },
  { 0xFF07, wxS("quotesinglemonospace") },
  { 0x0072, wxS("r") },
  { 0x057C, wxS("raarmenian") },
  { 0x09B0, wxS("rabengali") },
  { 0x0155, wxS("racute") },
  { 0x0930, wxS("radeva") },
  { 0x221A, wxS("radical") },
  { 0xF8E5, wxS("radicalex") },
  { 0x33AE, wxS("radoverssquare") },
  { 0x33AF, wxS("radoverssquaredsquare") },
  { 0x33AD, wxS("radsquare") },
  { 0x05BF, wxS("rafe") },
  { 0x05BF, wxS("rafehebrew") },
  { 0x0AB0, wxS("ragujarati") },
  { 0x0A30, wxS("ragurmukhi") },
  { 0x3089, wxS("rahiragana") },
  { 0x30E9, wxS("rakatakana") },
  { 0xFF97, wxS("rakatakanahalfwidth") },
  { 0x09F1, wxS("ralowerdiagonalbengali") },
  { 0x09F0, wxS("ramiddlediagonalbengali") },
  { 0x0264, wxS("ramshorn") },
  { 0x2236, wxS("ratio") },
  { 0x3116, wxS("rbopomofo") },
  { 0x0159, wxS("rcaron") },
  { 0x0157, wxS("rcedilla") },
  { 0x24E1, wxS("rcircle") },
  { 0x0157, wxS("rcommaaccent") },
  { 0x0211, wxS("rdblgrave") },
  { 0x1E59, wxS("rdotaccent") },
  { 0x1E5B, wxS("rdotbelow") },
  { 0x1E5D, wxS("rdotbelowmacron") },
  { 0x203B, wxS("referencemark") },
  { 0x2286, wxS("reflexsubset") },
  { 0x2287, wxS("reflexsuperset") },
  { 0x00AE, wxS("registered") },
  { 0xF8E8, wxS("registersans") },
  { 0xF6DA, wxS("registerserif") },
  { 0x0631, wxS("reharabic") },
  { 0x0580, wxS("reharmenian") },
  { 0xFEAE, wxS("rehfinalarabic") },
  { 0x308C, wxS("rehiragana") },
  { 0x30EC, wxS("rekatakana") },
  { 0xFF9A, wxS("rekatakanahalfwidth") },
  { 0x05E8, wxS("resh") },
  { 0xFB48, wxS("reshdageshhebrew") },
  { 0x05E8, wxS("reshhebrew") },
  { 0x223D, wxS("reversedtilde") },
  { 0x0597, wxS("reviahebrew") },
  { 0x0597, wxS("reviamugrashhebrew") },
  { 0x2310, wxS("revlogicalnot") },
  { 0x027E, wxS("rfishhook") },
  { 0x027F, wxS("rfishhookreversed") },
  { 0x09DD, wxS("rhabengali") },
  { 0x095D, wxS("rhadeva") },
  { 0x03C1, wxS("rho") },
  { 0x027D, wxS("rhook") },
  { 0x027B, wxS("rhookturned") },
  { 0x02B5, wxS("rhookturnedsuperior") },
  { 0x03F1, wxS("rhosymbolgreek") },
  { 0x02DE, wxS("rhotichookmod") },
  { 0x3271, wxS("rieulacirclekorean") },
  { 0x3211, wxS("rieulaparenkorean") },
  { 0x3263, wxS("rieulcirclekorean") },
  { 0x3140, wxS("rieulhieuhkorean") },
  { 0x313A, wxS("rieulkiyeokkorean") },
  { 0x3169, wxS("rieulkiyeoksioskorean") },
  { 0x3139, wxS("rieulkorean") },
  { 0x313B, wxS("rieulmieumkorean") },
  { 0x316C, wxS("rieulpansioskorean") },
  { 0x3203, wxS("rieulparenkorean") },
  { 0x313F, wxS("rieulphieuphkorean") },
  { 0x313C, wxS("rieulpieupkorean") },
  { 0x316B, wxS("rieulpieupsioskorean") },
  { 0x313D, wxS("rieulsioskorean") },
  { 0x313E, wxS("rieulthieuthkorean") },
  { 0x316A, wxS("rieultikeutkorean") },
  { 0x316D, wxS("rieulyeorinhieuhkorean") },
  { 0x221F, wxS("rightangle") },
  { 0x0319, wxS("righttackbelowcmb") },
  { 0x22BF, wxS("righttriangle") },
  { 0x308A, wxS("rihiragana") },
  { 0x30EA, wxS("rikatakana") },
  { 0xFF98, wxS("rikatakanahalfwidth") },
  { 0x02DA, wxS("ring") },
  { 0x0325, wxS("ringbelowcmb") },
  { 0x030A, wxS("ringcmb") },
  { 0x02BF, wxS("ringhalfleft") },
  { 0x0559, wxS("ringhalfleftarmenian") },
  { 0x031C, wxS("ringhalfleftbelowcmb") },
  { 0x02D3, wxS("ringhalfleftcentered") },
  { 0x02BE, wxS("ringhalfright") },
  { 0x0339, wxS("ringhalfrightbelowcmb") },
  { 0x02D2, wxS("ringhalfrightcentered") },
  { 0x0213, wxS("rinvertedbreve") },
  { 0x3351, wxS("rittorusquare") },
  { 0x1E5F, wxS("rlinebelow") },
  { 0x027C, wxS("rlongleg") },
  { 0x027A, wxS("rlonglegturned") },
  { 0xFF52, wxS("rmonospace") },
  { 0x308D, wxS("rohiragana") },
  { 0x30ED, wxS("rokatakana") },
  { 0xFF9B, wxS("rokatakanahalfwidth") },
  { 0x0E23, wxS("roruathai") },
  { 0x24AD, wxS("rparen") },
  { 0x09DC, wxS("rrabengali") },
  { 0x0931, wxS("rradeva") },
  { 0x0A5C, wxS("rragurmukhi") },
  { 0x0691, wxS("rreharabic") },
  { 0xFB8D, wxS("rrehfinalarabic") },
  { 0x09E0, wxS("rrvocalicbengali") },
  { 0x0960, wxS("rrvocalicdeva") },
  { 0x0AE0, wxS("rrvocalicgujarati") },
  { 0x09C4, wxS("rrvocalicvowelsignbengali") },
  { 0x0944, wxS("rrvocalicvowelsigndeva") },
  { 0x0AC4, wxS("rrvocalicvowelsigngujarati") },
  { 0xF6F1, wxS("rsuperior") },
  { 0x2590, wxS("rtblock") },
  { 0x0279, wxS("rturned") },
  { 0x02B4, wxS("rturnedsuperior") },
  { 0x308B, wxS("ruhiragana") },
  { 0x30EB, wxS("rukatakana") },
  { 0xFF99, wxS("rukatakanahalfwidth") },
  { 0x09F2, wxS("rupeemarkbengali") },
  { 0x09F3, wxS("rupeesignbengali") },
  { 0xF6DD, wxS("rupiah") },
  { 0x0E24, wxS("ruthai") },
  { 0x098B, wxS("rvocalicbengali") },
  { 0x090B, wxS("rvocalicdeva") },
  { 0x0A8B, wxS("rvocalicgujarati") },
  { 0x09C3, wxS("rvocalicvowelsignbengali") },
  { 0x0943, wxS("rvocalicvowelsigndeva") },
  { 0x0AC3, wxS("rvocalicvowelsigngujarati") },
  { 0x0073, wxS("s") },
  { 0x09B8, wxS("sabengali") },
  { 0x015B, wxS("sacute") },
  { 0x1E65, wxS("sacutedotaccent") },
  { 0x0635, wxS("sadarabic") },
  { 0x0938, wxS("sadeva") },
  { 0xFEBA, wxS("sadfinalarabic") },
  { 0xFEBB, wxS("sadinitialarabic") },
  { 0xFEBC, wxS("sadmedialarabic") },
  { 0x0AB8, wxS("sagujarati") },
  { 0x0A38, wxS("sagurmukhi") },
  { 0x3055, wxS("sahiragana") },
  { 0x30B5, wxS("sakatakana") },
  { 0xFF7B, wxS("sakatakanahalfwidth") },
  { 0xFDFA, wxS("sallallahoualayhewasallamarabic") },
  { 0x05E1, wxS("samekh") },
  { 0xFB41, wxS("samekhdagesh") },
  { 0xFB41, wxS("samekhdageshhebrew") },
  { 0x05E1, wxS("samekhhebrew") },
  { 0x0E32, wxS("saraaathai") },
  { 0x0E41, wxS("saraaethai") },
  { 0x0E44, wxS("saraaimaimalaithai") },
  { 0x0E43, wxS("saraaimaimuanthai") },
  { 0x0E33, wxS("saraamthai") },
  { 0x0E30, wxS("saraathai") },
  { 0x0E40, wxS("saraethai") },
  { 0xF886, wxS("saraiileftthai") },
  { 0x0E35, wxS("saraiithai") },
  { 0xF885, wxS("saraileftthai") },
  { 0x0E34, wxS("saraithai") },
  { 0x0E42, wxS("saraothai") },
  { 0xF888, wxS("saraueeleftthai") },
  { 0x0E37, wxS("saraueethai") },
  { 0xF887, wxS("saraueleftthai") },
  { 0x0E36, wxS("sarauethai") },
  { 0x0E38, wxS("sarauthai") },
  { 0x0E39, wxS("sarauuthai") },
  { 0x3119, wxS("sbopomofo") },
  { 0x0161, wxS("scaron") },
  { 0x1E67, wxS("scarondotaccent") },
  { 0x015F, wxS("scedilla") },
  { 0x0259, wxS("schwa") },
  { 0x04D9, wxS("schwacyrillic") },
  { 0x04DB, wxS("schwadieresiscyrillic") },
  { 0x025A, wxS("schwahook") },
  { 0x24E2, wxS("scircle") },
  { 0x015D, wxS("scircumflex") },
  { 0x0219, wxS("scommaaccent") },
  { 0x1E61, wxS("sdotaccent") },
  { 0x1E63, wxS("sdotbelow") },
  { 0x1E69, wxS("sdotbelowdotaccent") },
  { 0x033C, wxS("seagullbelowcmb") },
  { 0x2033, wxS("second") },
  { 0x02CA, wxS("secondtonechinese") },
  { 0x00A7, wxS("section") },
  { 0x0633, wxS("seenarabic") },
  { 0xFEB2, wxS("seenfinalarabic") },
  { 0xFEB3, wxS("seeninitialarabic") },
  { 0xFEB4, wxS("seenmedialarabic") },
  { 0x05B6, wxS("segol") },
  { 0x05B6, wxS("segol13") },
  { 0x05B6, wxS("segol1f") },
  { 0x05B6, wxS("segol2c") },
  { 0x05B6, wxS("segolhebrew") },
  { 0x05B6, wxS("segolnarrowhebrew") },
  { 0x05B6, wxS("segolquarterhebrew") },
  { 0x0592, wxS("segoltahebrew") },
  { 0x05B6, wxS("segolwidehebrew") },
  { 0x057D, wxS("seharmenian") },
  { 0x305B, wxS("sehiragana") },
  { 0x30BB, wxS("sekatakana") },
  { 0xFF7E, wxS("sekatakanahalfwidth") },
  { 0x003B, wxS("semicolon") },
  { 0x061B, wxS("semicolonarabic") },
  { 0xFF1B, wxS("semicolonmonospace") },
  { 0xFE54, wxS("semicolonsmall") },
  { 0x309C, wxS("semivoicedmarkkana") },
  { 0xFF9F, wxS("semivoicedmarkkanahalfwidth") },
  { 0x3322, wxS("sentisquare") },
  { 0x3323, wxS("sentosquare") },
  { 0x0037, wxS("seven") },
  { 0x0667, wxS("sevenarabic") },
  { 0x09ED, wxS("sevenbengali") },
  { 0x2466, wxS("sevencircle") },
  { 0x2790, wxS("sevencircleinversesansserif") },
  { 0x096D, wxS("sevendeva") },
  { 0x215E, wxS("seveneighths") },
  { 0x0AED, wxS("sevengujarati") },
  { 0x0A6D, wxS("sevengurmukhi") },
  { 0x0667, wxS("sevenhackarabic") },
  { 0x3027, wxS("sevenhangzhou") },
  { 0x3226, wxS("sevenideographicparen") },
  { 0x2087, wxS("seveninferior") },
  { 0xFF17, wxS("sevenmonospace") },
  { 0xF737, wxS("sevenoldstyle") },
  { 0x247A, wxS("sevenparen") },
  { 0x248E, wxS("sevenperiod") },
  { 0x06F7, wxS("sevenpersian") },
  { 0x2176, wxS("sevenroman") },
  { 0x2077, wxS("sevensuperior") },
  { 0x2470, wxS("seventeencircle") },
  { 0x2484, wxS("seventeenparen") },
  { 0x2498, wxS("seventeenperiod") },
  { 0x0E57, wxS("seventhai") },
  { 0x00AD, wxS("sfthyphen") },
  { 0x0577, wxS("shaarmenian") },
  { 0x09B6, wxS("shabengali") },
  { 0x0448, wxS("shacyrillic") },
  { 0x0651, wxS("shaddaarabic") },
  { 0xFC61, wxS("shaddadammaarabic") },
  { 0xFC5E, wxS("shaddadammatanarabic") },
  { 0xFC60, wxS("shaddafathaarabic") },
  { 0xFC62, wxS("shaddakasraarabic") },
  { 0xFC5F, wxS("shaddakasratanarabic") },
  { 0x2592, wxS("shade") },
  { 0x2593, wxS("shadedark") },
  { 0x2591, wxS("shadelight") },
  { 0x2592, wxS("shademedium") },
  { 0x0936, wxS("shadeva") },
  { 0x0AB6, wxS("shagujarati") },
  { 0x0A36, wxS("shagurmukhi") },
  { 0x0593, wxS("shalshelethebrew") },
  { 0x3115, wxS("shbopomofo") },
  { 0x0449, wxS("shchacyrillic") },
  { 0x0634, wxS("sheenarabic") },
  { 0xFEB6, wxS("sheenfinalarabic") },
  { 0xFEB7, wxS("sheeninitialarabic") },
  { 0xFEB8, wxS("sheenmedialarabic") },
  { 0x03E3, wxS("sheicoptic") },
  { 0x20AA, wxS("sheqel") },
  { 0x20AA, wxS("sheqelhebrew") },
  { 0x05B0, wxS("sheva") },
  { 0x05B0, wxS("sheva115") },
  { 0x05B0, wxS("sheva15") },
  { 0x05B0, wxS("sheva22") },
  { 0x05B0, wxS("sheva2e") },
  { 0x05B0, wxS("shevahebrew") },
  { 0x05B0, wxS("shevanarrowhebrew") },
  { 0x05B0, wxS("shevaquarterhebrew") },
  { 0x05B0, wxS("shevawidehebrew") },
  { 0x04BB, wxS("shhacyrillic") },
  { 0x03ED, wxS("shimacoptic") },
  { 0x05E9, wxS("shin") },
  { 0xFB49, wxS("shindagesh") },
  { 0xFB49, wxS("shindageshhebrew") },
  { 0xFB2C, wxS("shindageshshindot") },
  { 0xFB2C, wxS("shindageshshindothebrew") },
  { 0xFB2D, wxS("shindageshsindot") },
  { 0xFB2D, wxS("shindageshsindothebrew") },
  { 0x05C1, wxS("shindothebrew") },
  { 0x05E9, wxS("shinhebrew") },
  { 0xFB2A, wxS("shinshindot") },
  { 0xFB2A, wxS("shinshindothebrew") },
  { 0xFB2B, wxS("shinsindot") },
  { 0xFB2B, wxS("shinsindothebrew") },
  { 0x0282, wxS("shook") },
  { 0x03C3, wxS("sigma") },
  { 0x03C2, wxS("sigma1") },
  { 0x03C2, wxS("sigmafinal") },
  { 0x03F2, wxS("sigmalunatesymbolgreek") },
  { 0x3057, wxS("sihiragana") },
  { 0x30B7, wxS("sikatakana") },
  { 0xFF7C, wxS("sikatakanahalfwidth") },
  { 0x05BD, wxS("siluqhebrew") },
  { 0x05BD, wxS("siluqlefthebrew") },
  { 0x223C, wxS("similar") },
  { 0x05C2, wxS("sindothebrew") },
  { 0x3274, wxS("siosacirclekorean") },
  { 0x3214, wxS("siosaparenkorean") },
  { 0x317E, wxS("sioscieuckorean") },
  { 0x3266, wxS("sioscirclekorean") },
  { 0x317A, wxS("sioskiyeokkorean") },
  { 0x3145, wxS("sioskorean") },
  { 0x317B, wxS("siosnieunkorean") },
  { 0x3206, wxS("siosparenkorean") },
  { 0x317D, wxS("siospieupkorean") },
  { 0x317C, wxS("siostikeutkorean") },
  { 0x0036, wxS("six") },
  { 0x0666, wxS("sixarabic") },
  { 0x09EC, wxS("sixbengali") },
  { 0x2465, wxS("sixcircle") },
  { 0x278F, wxS("sixcircleinversesansserif") },
  { 0x096C, wxS("sixdeva") },
  { 0x0AEC, wxS("sixgujarati") },
  { 0x0A6C, wxS("sixgurmukhi") },
  { 0x0666, wxS("sixhackarabic") },
  { 0x3026, wxS("sixhangzhou") },
  { 0x3225, wxS("sixideographicparen") },
  { 0x2086, wxS("sixinferior") },
  { 0xFF16, wxS("sixmonospace") },
  { 0xF736, wxS("sixoldstyle") },
  { 0x2479, wxS("sixparen") },
  { 0x248D, wxS("sixperiod") },
  { 0x06F6, wxS("sixpersian") },
  { 0x2175, wxS("sixroman") },
  { 0x2076, wxS("sixsuperior") },
  { 0x246F, wxS("sixteencircle") },
  { 0x09F9, wxS("sixteencurrencydenominatorbengali") },
  { 0x2483, wxS("sixteenparen") },
  { 0x2497, wxS("sixteenperiod") },
  { 0x0E56, wxS("sixthai") },
  { 0x002F, wxS("slash") },
  { 0xFF0F, wxS("slashmonospace") },
  { 0x017F, wxS("slong") },
  { 0x1E9B, wxS("slongdotaccent") },
  { 0x263A, wxS("smileface") },
  { 0xFF53, wxS("smonospace") },
  { 0x05C3, wxS("sofpasuqhebrew") },
  { 0x00AD, wxS("softhyphen") },
  { 0x044C, wxS("softsigncyrillic") },
  { 0x305D, wxS("sohiragana") },
  { 0x30BD, wxS("sokatakana") },
  { 0xFF7F, wxS("sokatakanahalfwidth") },
  { 0x0338, wxS("soliduslongoverlaycmb") },
  { 0x0337, wxS("solidusshortoverlaycmb") },
  { 0x0E29, wxS("sorusithai") },
  { 0x0E28, wxS("sosalathai") },
  { 0x0E0B, wxS("sosothai") },
  { 0x0E2A, wxS("sosuathai") },
  { 0x0020, wxS("space") },
  { 0x0020, wxS("spacehackarabic") },
  { 0x2660, wxS("spade") },
  { 0x2660, wxS("spadesuitblack") },
  { 0x2664, wxS("spadesuitwhite") },
  { 0x24AE, wxS("sparen") },
  { 0x033B, wxS("squarebelowcmb") },
  { 0x33C4, wxS("squarecc") },
  { 0x339D, wxS("squarecm") },
  { 0x25A9, wxS("squarediagonalcrosshatchfill") },
  { 0x25A4, wxS("squarehorizontalfill") },
  { 0x338F, wxS("squarekg") },
  { 0x339E, wxS("squarekm") },
  { 0x33CE, wxS("squarekmcapital") },
  { 0x33D1, wxS("squareln") },
  { 0x33D2, wxS("squarelog") },
  { 0x338E, wxS("squaremg") },
  { 0x33D5, wxS("squaremil") },
  { 0x339C, wxS("squaremm") },
  { 0x33A1, wxS("squaremsquared") },
  { 0x25A6, wxS("squareorthogonalcrosshatchfill") },
  { 0x25A7, wxS("squareupperlefttolowerrightfill") },
  { 0x25A8, wxS("squareupperrighttolowerleftfill") },
  { 0x25A5, wxS("squareverticalfill") },
  { 0x25A3, wxS("squarewhitewithsmallblack") },
  { 0x33DB, wxS("srsquare") },
  { 0x09B7, wxS("ssabengali") },
  { 0x0937, wxS("ssadeva") },
  { 0x0AB7, wxS("ssagujarati") },
  { 0x3149, wxS("ssangcieuckorean") },
  { 0x3185, wxS("ssanghieuhkorean") },
  { 0x3180, wxS("ssangieungkorean") },
  { 0x3132, wxS("ssangkiyeokkorean") },
  { 0x3165, wxS("ssangnieunkorean") },
  { 0x3143, wxS("ssangpieupkorean") },
  { 0x3146, wxS("ssangsioskorean") },
  { 0x3138, wxS("ssangtikeutkorean") },
  { 0xF6F2, wxS("ssuperior") },
  { 0x00A3, wxS("sterling") },
  { 0xFFE1, wxS("sterlingmonospace") },
  { 0x0336, wxS("strokelongoverlaycmb") },
  { 0x0335, wxS("strokeshortoverlaycmb") },
  { 0x2282, wxS("subset") },
  { 0x228A, wxS("subsetnotequal") },
  { 0x2286, wxS("subsetorequal") },
  { 0x227B, wxS("succeeds") },
  { 0x220B, wxS("suchthat") },
  { 0x3059, wxS("suhiragana") },
  { 0x30B9, wxS("sukatakana") },
  { 0xFF7D, wxS("sukatakanahalfwidth") },
  { 0x0652, wxS("sukunarabic") },
  { 0x2211, wxS("summation") },
  { 0x263C, wxS("sun") },
  { 0x2283, wxS("superset") },
  { 0x228B, wxS("supersetnotequal") },
  { 0x2287, wxS("supersetorequal") },
  { 0x33DC, wxS("svsquare") },
  { 0x337C, wxS("syouwaerasquare") },
  { 0x0074, wxS("t") },
  { 0x09A4, wxS("tabengali") },
  { 0x22A4, wxS("tackdown") },
  { 0x22A3, wxS("tackleft") },
  { 0x0924, wxS("tadeva") },
  { 0x0AA4, wxS("tagujarati") },
  { 0x0A24, wxS("tagurmukhi") },
  { 0x0637, wxS("taharabic") },
  { 0xFEC2, wxS("tahfinalarabic") },
  { 0xFEC3, wxS("tahinitialarabic") },
  { 0x305F, wxS("tahiragana") },
  { 0xFEC4, wxS("tahmedialarabic") },
  { 0x337D, wxS("taisyouerasquare") },
  { 0x30BF, wxS("takatakana") },
  { 0xFF80, wxS("takatakanahalfwidth") },
  { 0x0640, wxS("tatweelarabic") },
  { 0x03C4, wxS("tau") },
  { 0x05EA, wxS("tav") },
  { 0xFB4A, wxS("tavdages") },
  { 0xFB4A, wxS("tavdagesh") },
  { 0xFB4A, wxS("tavdageshhebrew") },
  { 0x05EA, wxS("tavhebrew") },
  { 0x0167, wxS("tbar") },
  { 0x310A, wxS("tbopomofo") },
  { 0x0165, wxS("tcaron") },
  { 0x02A8, wxS("tccurl") },
  { 0x0163, wxS("tcedilla") },
  { 0x0686, wxS("tcheharabic") },
  { 0xFB7B, wxS("tchehfinalarabic") },
  { 0xFB7C, wxS("tchehinitialarabic") },
  { 0xFB7D, wxS("tchehmedialarabic") },
  { 0x24E3, wxS("tcircle") },
  { 0x1E71, wxS("tcircumflexbelow") },
  { 0x0163, wxS("tcommaaccent") },
  { 0x1E97, wxS("tdieresis") },
  { 0x1E6B, wxS("tdotaccent") },
  { 0x1E6D, wxS("tdotbelow") },
  { 0x0442, wxS("tecyrillic") },
  { 0x04AD, wxS("tedescendercyrillic") },
  { 0x062A, wxS("teharabic") },
  { 0xFE96, wxS("tehfinalarabic") },
  { 0xFCA2, wxS("tehhahinitialarabic") },
  { 0xFC0C, wxS("tehhahisolatedarabic") },
  { 0xFE97, wxS("tehinitialarabic") },
  { 0x3066, wxS("tehiragana") },
  { 0xFCA1, wxS("tehjeeminitialarabic") },
  { 0xFC0B, wxS("tehjeemisolatedarabic") },
  { 0x0629, wxS("tehmarbutaarabic") },
  { 0xFE94, wxS("tehmarbutafinalarabic") },
  { 0xFE98, wxS("tehmedialarabic") },
  { 0xFCA4, wxS("tehmeeminitialarabic") },
  { 0xFC0E, wxS("tehmeemisolatedarabic") },
  { 0xFC73, wxS("tehnoonfinalarabic") },
  { 0x30C6, wxS("tekatakana") },
  { 0xFF83, wxS("tekatakanahalfwidth") },
  { 0x2121, wxS("telephone") },
  { 0x260E, wxS("telephoneblack") },
  { 0x05A0, wxS("telishagedolahebrew") },
  { 0x05A9, wxS("telishaqetanahebrew") },
  { 0x2469, wxS("tencircle") },
  { 0x3229, wxS("tenideographicparen") },
  { 0x247D, wxS("tenparen") },
  { 0x2491, wxS("tenperiod") },
  { 0x2179, wxS("tenroman") },
  { 0x02A7, wxS("tesh") },
  { 0x05D8, wxS("tet") },
  { 0xFB38, wxS("tetdagesh") },
  { 0xFB38, wxS("tetdageshhebrew") },
  { 0x05D8, wxS("tethebrew") },
  { 0x04B5, wxS("tetsecyrillic") },
  { 0x059B, wxS("tevirhebrew") },
  { 0x059B, wxS("tevirlefthebrew") },
  { 0x09A5, wxS("thabengali") },
  { 0x0925, wxS("thadeva") },
  { 0x0AA5, wxS("thagujarati") },
  { 0x0A25, wxS("thagurmukhi") },
  { 0x0630, wxS("thalarabic") },
  { 0xFEAC, wxS("thalfinalarabic") },
  { 0xF898, wxS("thanthakhatlowleftthai") },
  { 0xF897, wxS("thanthakhatlowrightthai") },
  { 0x0E4C, wxS("thanthakhatthai") },
  { 0xF896, wxS("thanthakhatupperleftthai") },
  { 0x062B, wxS("theharabic") },
  { 0xFE9A, wxS("thehfinalarabic") },
  { 0xFE9B, wxS("thehinitialarabic") },
  { 0xFE9C, wxS("thehmedialarabic") },
  { 0x2203, wxS("thereexists") },
  { 0x2234, wxS("therefore") },
  { 0x03B8, wxS("theta") },
  { 0x03D1, wxS("theta1") },
  { 0x03D1, wxS("thetasymbolgreek") },
  { 0x3279, wxS("thieuthacirclekorean") },
  { 0x3219, wxS("thieuthaparenkorean") },
  { 0x326B, wxS("thieuthcirclekorean") },
  { 0x314C, wxS("thieuthkorean") },
  { 0x320B, wxS("thieuthparenkorean") },
  { 0x246C, wxS("thirteencircle") },
  { 0x2480, wxS("thirteenparen") },
  { 0x2494, wxS("thirteenperiod") },
  { 0x0E11, wxS("thonangmonthothai") },
  { 0x01AD, wxS("thook") },
  { 0x0E12, wxS("thophuthaothai") },
  { 0x00FE, wxS("thorn") },
  { 0x0E17, wxS("thothahanthai") },
  { 0x0E10, wxS("thothanthai") },
  { 0x0E18, wxS("thothongthai") },
  { 0x0E16, wxS("thothungthai") },
  { 0x0482, wxS("thousandcyrillic") },
  { 0x066C, wxS("thousandsseparatorarabic") },
  { 0x066C, wxS("thousandsseparatorpersian") },
  { 0x0033, wxS("three") },
  { 0x0663, wxS("threearabic") },
  { 0x09E9, wxS("threebengali") },
  { 0x2462, wxS("threecircle") },
  { 0x278C, wxS("threecircleinversesansserif") },
  { 0x0969, wxS("threedeva") },
  { 0x215C, wxS("threeeighths") },
  { 0x0AE9, wxS("threegujarati") },
  { 0x0A69, wxS("threegurmukhi") },
  { 0x0663, wxS("threehackarabic") },
  { 0x3023, wxS("threehangzhou") },
  { 0x3222, wxS("threeideographicparen") },
  { 0x2083, wxS("threeinferior") },
  { 0xFF13, wxS("threemonospace") },
  { 0x09F6, wxS("threenumeratorbengali") },
  { 0xF733, wxS("threeoldstyle") },
  { 0x2476, wxS("threeparen") },
  { 0x248A, wxS("threeperiod") },
  { 0x06F3, wxS("threepersian") },
  { 0x00BE, wxS("threequarters") },
  { 0xF6DE, wxS("threequartersemdash") },
  { 0x2172, wxS("threeroman") },
  { 0x00B3, wxS("threesuperior") },
  { 0x0E53, wxS("threethai") },
  { 0x3394, wxS("thzsquare") },
  { 0x3061, wxS("tihiragana") },
  { 0x30C1, wxS("tikatakana") },
  { 0xFF81, wxS("tikatakanahalfwidth") },
  { 0x3270, wxS("tikeutacirclekorean") },
  { 0x3210, wxS("tikeutaparenkorean") },
  { 0x3262, wxS("tikeutcirclekorean") },
  { 0x3137, wxS("tikeutkorean") },
  { 0x3202, wxS("tikeutparenkorean") },
  { 0x02DC, wxS("tilde") },
  { 0x0330, wxS("tildebelowcmb") },
  { 0x0303, wxS("tildecmb") },
  { 0x0303, wxS("tildecomb") },
  { 0x0360, wxS("tildedoublecmb") },
  { 0x223C, wxS("tildeoperator") },
  { 0x0334, wxS("tildeoverlaycmb") },
  { 0x033E, wxS("tildeverticalcmb") },
  { 0x2297, wxS("timescircle") },
  { 0x0596, wxS("tipehahebrew") },
  { 0x0596, wxS("tipehalefthebrew") },
  { 0x0A70, wxS("tippigurmukhi") },
  { 0x0483, wxS("titlocyrilliccmb") },
  { 0x057F, wxS("tiwnarmenian") },
  { 0x1E6F, wxS("tlinebelow") },
  { 0xFF54, wxS("tmonospace") },
  { 0x0569, wxS("toarmenian") },
  { 0x3068, wxS("tohiragana") },
  { 0x30C8, wxS("tokatakana") },
  { 0xFF84, wxS("tokatakanahalfwidth") },
  { 0x02E5, wxS("tonebarextrahighmod") },
  { 0x02E9, wxS("tonebarextralowmod") },
  { 0x02E6, wxS("tonebarhighmod") },
  { 0x02E8, wxS("tonebarlowmod") },
  { 0x02E7, wxS("tonebarmidmod") },
  { 0x01BD, wxS("tonefive") },
  { 0x0185, wxS("tonesix") },
  { 0x01A8, wxS("tonetwo") },
  { 0x0384, wxS("tonos") },
  { 0x3327, wxS("tonsquare") },
  { 0x0E0F, wxS("topatakthai") },
  { 0x3014, wxS("tortoiseshellbracketleft") },
  { 0xFE5D, wxS("tortoiseshellbracketleftsmall") },
  { 0xFE39, wxS("tortoiseshellbracketleftvertical") },
  { 0x3015, wxS("tortoiseshellbracketright") },
  { 0xFE5E, wxS("tortoiseshellbracketrightsmall") },
  { 0xFE3A, wxS("tortoiseshellbracketrightvertical") },
  { 0x0E15, wxS("totaothai") },
  { 0x01AB, wxS("tpalatalhook") },
  { 0x24AF, wxS("tparen") },
  { 0x2122, wxS("trademark") },
  { 0xF8EA, wxS("trademarksans") },
  { 0xF6DB, wxS("trademarkserif") },
  { 0x0288, wxS("tretroflexhook") },
  { 0x25BC, wxS("triagdn") },
  { 0x25C4, wxS("triaglf") },
  { 0x25BA, wxS("triagrt") },
  { 0x25B2, wxS("triagup") },
  { 0x02A6, wxS("ts") },
  { 0x05E6, wxS("tsadi") },
  { 0xFB46, wxS("tsadidagesh") },
  { 0xFB46, wxS("tsadidageshhebrew") },
  { 0x05E6, wxS("tsadihebrew") },
  { 0x0446, wxS("tsecyrillic") },
  { 0x05B5, wxS("tsere") },
  { 0x05B5, wxS("tsere12") },
  { 0x05B5, wxS("tsere1e") },
  { 0x05B5, wxS("tsere2b") },
  { 0x05B5, wxS("tserehebrew") },
  { 0x05B5, wxS("tserenarrowhebrew") },
  { 0x05B5, wxS("tserequarterhebrew") },
  { 0x05B5, wxS("tserewidehebrew") },
  { 0x045B, wxS("tshecyrillic") },
  { 0xF6F3, wxS("tsuperior") },
  { 0x099F, wxS("ttabengali") },
  { 0x091F, wxS("ttadeva") },
  { 0x0A9F, wxS("ttagujarati") },
  { 0x0A1F, wxS("ttagurmukhi") },
  { 0x0679, wxS("tteharabic") },
  { 0xFB67, wxS("ttehfinalarabic") },
  { 0xFB68, wxS("ttehinitialarabic") },
  { 0xFB69, wxS("ttehmedialarabic") },
  { 0x09A0, wxS("tthabengali") },
  { 0x0920, wxS("tthadeva") },
  { 0x0AA0, wxS("tthagujarati") },
  { 0x0A20, wxS("tthagurmukhi") },
  { 0x0287, wxS("tturned") },
  { 0x3064, wxS("tuhiragana") },
  { 0x30C4, wxS("tukatakana") },
  { 0xFF82, wxS("tukatakanahalfwidth") },
  { 0x3063, wxS("tusmallhiragana") },
  { 0x30C3, wxS("tusmallkatakana") },
  { 0xFF6F, wxS("tusmallkatakanahalfwidth") },
  { 0x246B, wxS("twelvecircle") },
  { 0x247F, wxS("twelveparen") },
  { 0x2493, wxS("twelveperiod") },
  { 0x217B, wxS("twelveroman") },
  { 0x2473, wxS("twentycircle") },
  { 0x5344, wxS("twentyhangzhou") },
  { 0x2487, wxS("twentyparen") },
  { 0x249B, wxS("twentyperiod") },
  { 0x0032, wxS("two") },
  { 0x0662, wxS("twoarabic") },
  { 0x09E8, wxS("twobengali") },
  { 0x2461, wxS("twocircle") },
  { 0x278B, wxS("twocircleinversesansserif") },
  { 0x0968, wxS("twodeva") },
  { 0x2025, wxS("twodotenleader") },
  { 0x2025, wxS("twodotleader") },
  { 0xFE30, wxS("twodotleadervertical") },
  { 0x0AE8, wxS("twogujarati") },
  { 0x0A68, wxS("twogurmukhi") },
  { 0x0662, wxS("twohackarabic") },
  { 0x3022, wxS("twohangzhou") },
  { 0x3221, wxS("twoideographicparen") },
  { 0x2082, wxS("twoinferior") },
  { 0xFF12, wxS("twomonospace") },
  { 0x09F5, wxS("twonumeratorbengali") },
  { 0xF732, wxS("twooldstyle") },
  { 0x2475, wxS("twoparen") },
  { 0x2489, wxS("twoperiod") },
  { 0x06F2, wxS("twopersian") },
  { 0x2171, wxS("tworoman") },
  { 0x01BB, wxS("twostroke") },
  { 0x00B2, wxS("twosuperior") },
  { 0x0E52, wxS("twothai") },
  { 0x2154, wxS("twothirds") },
  { 0x0075, wxS("u") },
  { 0x00FA, wxS("uacute") },
  { 0x0289, wxS("ubar") },
  { 0x0989, wxS("ubengali") },
  { 0x3128, wxS("ubopomofo") },
  { 0x016D, wxS("ubreve") },
  { 0x01D4, wxS("ucaron") },
  { 0x24E4, wxS("ucircle") },
  { 0x00FB, wxS("ucircumflex") },
  { 0x1E77, wxS("ucircumflexbelow") },
  { 0x0443, wxS("ucyrillic") },
  { 0x0951, wxS("udattadeva") },
  { 0x0171, wxS("udblacute") },
  { 0x0215, wxS("udblgrave") },
  { 0x0909, wxS("udeva") },
  { 0x00FC, wxS("udieresis") },
  { 0x01D8, wxS("udieresisacute") },
  { 0x1E73, wxS("udieresisbelow") },
  { 0x01DA, wxS("udieresiscaron") },
  { 0x04F1, wxS("udieresiscyrillic") },
  { 0x01DC, wxS("udieresisgrave") },
  { 0x01D6, wxS("udieresismacron") },
  { 0x1EE5, wxS("udotbelow") },
  { 0x00F9, wxS("ugrave") },
  { 0x0A89, wxS("ugujarati") },
  { 0x0A09, wxS("ugurmukhi") },
  { 0x3046, wxS("uhiragana") },
  { 0x1EE7, wxS("uhookabove") },
  { 0x01B0, wxS("uhorn") },
  { 0x1EE9, wxS("uhornacute") },
  { 0x1EF1, wxS("uhorndotbelow") },
  { 0x1EEB, wxS("uhorngrave") },
  { 0x1EED, wxS("uhornhookabove") },
  { 0x1EEF, wxS("uhorntilde") },
  { 0x0171, wxS("uhungarumlaut") },
  { 0x04F3, wxS("uhungarumlautcyrillic") },
  { 0x0217, wxS("uinvertedbreve") },
  { 0x30A6, wxS("ukatakana") },
  { 0xFF73, wxS("ukatakanahalfwidth") },
  { 0x0479, wxS("ukcyrillic") },
  { 0x315C, wxS("ukorean") },
  { 0x016B, wxS("umacron") },
  { 0x04EF, wxS("umacroncyrillic") },
  { 0x1E7B, wxS("umacrondieresis") },
  { 0x0A41, wxS("umatragurmukhi") },
  { 0xFF55, wxS("umonospace") },
  { 0x005F, wxS("underscore") },
  { 0x2017, wxS("underscoredbl") },
  { 0xFF3F, wxS("underscoremonospace") },
  { 0xFE33, wxS("underscorevertical") },
  { 0xFE4F, wxS("underscorewavy") },
  { 0x222A, wxS("union") },
  { 0x2200, wxS("universal") },
  { 0x0173, wxS("uogonek") },
  { 0x24B0, wxS("uparen") },
  { 0x2580, wxS("upblock") },
  { 0x05C4, wxS("upperdothebrew") },
  { 0x03C5, wxS("upsilon") },
  { 0x03CB, wxS("upsilondieresis") },
  { 0x03B0, wxS("upsilondieresistonos") },
  { 0x028A, wxS("upsilonlatin") },
  { 0x03CD, wxS("upsilontonos") },
  { 0x031D, wxS("uptackbelowcmb") },
  { 0x02D4, wxS("uptackmod") },
  { 0x0A73, wxS("uragurmukhi") },
  { 0x016F, wxS("uring") },
  { 0x045E, wxS("ushortcyrillic") },
  { 0x3045, wxS("usmallhiragana") },
  { 0x30A5, wxS("usmallkatakana") },
  { 0xFF69, wxS("usmallkatakanahalfwidth") },
  { 0x04AF, wxS("ustraightcyrillic") },
  { 0x04B1, wxS("ustraightstrokecyrillic") },
  { 0x0169, wxS("utilde") },
  { 0x1E79, wxS("utildeacute") },
  { 0x1E75, wxS("utildebelow") },
  { 0x098A, wxS("uubengali") },
  { 0x090A, wxS("uudeva") },
  { 0x0A8A, wxS("uugujarati") },
  { 0x0A0A, wxS("uugurmukhi") },
  { 0x0A42, wxS("uumatragurmukhi") },
  { 0x09C2, wxS("uuvowelsignbengali") },
  { 0x0942, wxS("uuvowelsigndeva") },
  { 0x0AC2, wxS("uuvowelsigngujarati") },
  { 0x09C1, wxS("uvowelsignbengali") },
  { 0x0941, wxS("uvowelsigndeva") },
  { 0x0AC1, wxS("uvowelsigngujarati") },
  { 0x0076, wxS("v") },
  { 0x0935, wxS("vadeva") },
  { 0x0AB5, wxS("vagujarati") },
  { 0x0A35, wxS("vagurmukhi") },
  { 0x30F7, wxS("vakatakana") },
  { 0x05D5, wxS("vav") },
  { 0xFB35, wxS("vavdagesh") },
  { 0xFB35, wxS("vavdagesh65") },
  { 0xFB35, wxS("vavdageshhebrew") },
  { 0x05D5, wxS("vavhebrew") },
  { 0xFB4B, wxS("vavholam") },
  { 0xFB4B, wxS("vavholamhebrew") },
  { 0x05F0, wxS("vavvavhebrew") },
  { 0x05F1, wxS("vavyodhebrew") },
  { 0x24E5, wxS("vcircle") },
  { 0x1E7F, wxS("vdotbelow") },
  { 0x0432, wxS("vecyrillic") },
  { 0x06A4, wxS("veharabic") },
  { 0xFB6B, wxS("vehfinalarabic") },
  { 0xFB6C, wxS("vehinitialarabic") },
  { 0xFB6D, wxS("vehmedialarabic") },
  { 0x30F9, wxS("vekatakana") },
  { 0x2640, wxS("venus") },
  { 0x007C, wxS("verticalbar") },
  { 0x030D, wxS("verticallineabovecmb") },
  { 0x0329, wxS("verticallinebelowcmb") },
  { 0x02CC, wxS("verticallinelowmod") },
  { 0x02C8, wxS("verticallinemod") },
  { 0x057E, wxS("vewarmenian") },
  { 0x028B, wxS("vhook") },
  { 0x30F8, wxS("vikatakana") },
  { 0x09CD, wxS("viramabengali") },
  { 0x094D, wxS("viramadeva") },
  { 0x0ACD, wxS("viramagujarati") },
  { 0x0983, wxS("visargabengali") },
  { 0x0903, wxS("visargadeva") },
  { 0x0A83, wxS("visargagujarati") },
  { 0xFF56, wxS("vmonospace") },
  { 0x0578, wxS("voarmenian") },
  { 0x309E, wxS("voicediterationhiragana") },
  { 0x30FE, wxS("voicediterationkatakana") },
  { 0x309B, wxS("voicedmarkkana") },
  { 0xFF9E, wxS("voicedmarkkanahalfwidth") },
  { 0x30FA, wxS("vokatakana") },
  { 0x24B1, wxS("vparen") },
  { 0x1E7D, wxS("vtilde") },
  { 0x028C, wxS("vturned") },
  { 0x3094, wxS("vuhiragana") },
  { 0x30F4, wxS("vukatakana") },
  { 0x0077, wxS("w") },
  { 0x1E83, wxS("wacute") },
  { 0x3159, wxS("waekorean") },
  { 0x308F, wxS("wahiragana") },
  { 0x30EF, wxS("wakatakana") },
  { 0xFF9C, wxS("wakatakanahalfwidth") },
  { 0x3158, wxS("wakorean") },
  { 0x308E, wxS("wasmallhiragana") },
  { 0x30EE, wxS("wasmallkatakana") },
  { 0x3357, wxS("wattosquare") },
  { 0x301C, wxS("wavedash") },
  { 0xFE34, wxS("wavyunderscorevertical") },
  { 0x0648, wxS("wawarabic") },
  { 0xFEEE, wxS("wawfinalarabic") },
  { 0x0624, wxS("wawhamzaabovearabic") },
  { 0xFE86, wxS("wawhamzaabovefinalarabic") },
  { 0x33DD, wxS("wbsquare") },
  { 0x24E6, wxS("wcircle") },
  { 0x0175, wxS("wcircumflex") },
  { 0x1E85, wxS("wdieresis") },
  { 0x1E87, wxS("wdotaccent") },
  { 0x1E89, wxS("wdotbelow") },
  { 0x3091, wxS("wehiragana") },
  { 0x2118, wxS("weierstrass") },
  { 0x30F1, wxS("wekatakana") },
  { 0x315E, wxS("wekorean") },
  { 0x315D, wxS("weokorean") },
  { 0x1E81, wxS("wgrave") },
  { 0x25E6, wxS("whitebullet") },
  { 0x25CB, wxS("whitecircle") },
  { 0x25D9, wxS("whitecircleinverse") },
  { 0x300E, wxS("whitecornerbracketleft") },
  { 0xFE43, wxS("whitecornerbracketleftvertical") },
  { 0x300F, wxS("whitecornerbracketright") },
  { 0xFE44, wxS("whitecornerbracketrightvertical") },
  { 0x25C7, wxS("whitediamond") },
  { 0x25C8, wxS("whitediamondcontainingblacksmalldiamond") },
  { 0x25BF, wxS("whitedownpointingsmalltriangle") },
  { 0x25BD, wxS("whitedownpointingtriangle") },
  { 0x25C3, wxS("whiteleftpointingsmalltriangle") },
  { 0x25C1, wxS("whiteleftpointingtriangle") },
  { 0x3016, wxS("whitelenticularbracketleft") },
  { 0x3017, wxS("whitelenticularbracketright") },
  { 0x25B9, wxS("whiterightpointingsmalltriangle") },
  { 0x25B7, wxS("whiterightpointingtriangle") },
  { 0x25AB, wxS("whitesmallsquare") },
  { 0x263A, wxS("whitesmilingface") },
  { 0x25A1, wxS("whitesquare") },
  { 0x2606, wxS("whitestar") },
  { 0x260F, wxS("whitetelephone") },
  { 0x3018, wxS("whitetortoiseshellbracketleft") },
  { 0x3019, wxS("whitetortoiseshellbracketright") },
  { 0x25B5, wxS("whiteuppointingsmalltriangle") },
  { 0x25B3, wxS("whiteuppointingtriangle") },
  { 0x3090, wxS("wihiragana") },
  { 0x30F0, wxS("wikatakana") },
  { 0x315F, wxS("wikorean") },
  { 0xFF57, wxS("wmonospace") },
  { 0x3092, wxS("wohiragana") },
  { 0x30F2, wxS("wokatakana") },
  { 0xFF66, wxS("wokatakanahalfwidth") },
  { 0x20A9, wxS("won") },
  { 0xFFE6, wxS("wonmonospace") },
  { 0x0E27, wxS("wowaenthai") },
  { 0x24B2, wxS("wparen") },
  { 0x1E98, wxS("wring") },
  { 0x02B7, wxS("wsuperior") },
  { 0x028D, wxS("wturned") },
  { 0x01BF, wxS("wynn") },
  { 0x0078, wxS("x") },
  { 0x033D, wxS("xabovecmb") },
  { 0x3112, wxS("xbopomofo") },
  { 0x24E7, wxS("xcircle") },
  { 0x1E8D, wxS("xdieresis") },
  { 0x1E8B, wxS("xdotaccent") },
  { 0x056D, wxS("xeharmenian") },
  { 0x03BE, wxS("xi") },
  { 0xFF58, wxS("xmonospace") },
  { 0x24B3, wxS("xparen") },
  { 0x02E3, wxS("xsuperior") },
  { 0x0079, wxS("y") },
  { 0x334E, wxS("yaadosquare") },
  { 0x09AF, wxS("yabengali") },
  { 0x00FD, wxS("yacute") },
  { 0x092F, wxS("yadeva") },
  { 0x3152, wxS("yaekorean") },
  { 0x0AAF, wxS("yagujarati") },
  { 0x0A2F, wxS("yagurmukhi") },
  { 0x3084, wxS("yahiragana") },
  { 0x30E4, wxS("yakatakana") },
  { 0xFF94, wxS("yakatakanahalfwidth") },
  { 0x3151, wxS("yakorean") },
  { 0x0E4E, wxS("yamakkanthai") },
  { 0x3083, wxS("yasmallhiragana") },
  { 0x30E3, wxS("yasmallkatakana") },
  { 0xFF6C, wxS("yasmallkatakanahalfwidth") },
  { 0x0463, wxS("yatcyrillic") },
  { 0x24E8, wxS("ycircle") },
  { 0x0177, wxS("ycircumflex") },
  { 0x00FF, wxS("ydieresis") },
  { 0x1E8F, wxS("ydotaccent") },
  { 0x1EF5, wxS("ydotbelow") },
  { 0x064A, wxS("yeharabic") },
  { 0x06D2, wxS("yehbarreearabic") },
  { 0xFBAF, wxS("yehbarreefinalarabic") },
  { 0xFEF2, wxS("yehfinalarabic") },
  { 0x0626, wxS("yehhamzaabovearabic") },
  { 0xFE8A, wxS("yehhamzaabovefinalarabic") },
  { 0xFE8B, wxS("yehhamzaaboveinitialarabic") },
  { 0xFE8C, wxS("yehhamzaabovemedialarabic") },
  { 0xFEF3, wxS("yehinitialarabic") },
  { 0xFEF4, wxS("yehmedialarabic") },
  { 0xFCDD, wxS("yehmeeminitialarabic") },
  { 0xFC58, wxS("yehmeemisolatedarabic") },
  { 0xFC94, wxS("yehnoonfinalarabic") },
  { 0x06D1, wxS("yehthreedotsbelowarabic") },
  { 0x3156, wxS("yekorean") },
  { 0x00A5, wxS("yen") },
  { 0xFFE5, wxS("yenmonospace") },
  { 0x3155, wxS("yeokorean") },
  { 0x3186, wxS("yeorinhieuhkorean") },
  { 0x05AA, wxS("yerahbenyomohebrew") },
  { 0x05AA, wxS("yerahbenyomolefthebrew") },
  { 0x044B, wxS("yericyrillic") },
  { 0x04F9, wxS("yerudieresiscyrillic") },
  { 0x3181, wxS("yesieungkorean") },
  { 0x3183, wxS("yesieungpansioskorean") },
  { 0x3182, wxS("yesieungsioskorean") },
  { 0x059A, wxS("yetivhebrew") },
  { 0x1EF3, wxS("ygrave") },
  { 0x01B4, wxS("yhook") },
  { 0x1EF7, wxS("yhookabove") },
  { 0x0575, wxS("yiarmenian") },
  { 0x0457, wxS("yicyrillic") },
  { 0x3162, wxS("yikorean") },
  { 0x262F, wxS("yinyang") },
  { 0x0582, wxS("yiwnarmenian") },
  { 0xFF59, wxS("ymonospace") },
  { 0x05D9, wxS("yod") },
  { 0xFB39, wxS("yoddagesh") },
  { 0xFB39, wxS("yoddageshhebrew") },
  { 0x05D9, wxS("yodhebrew") },
  { 0x05F2, wxS("yodyodhebrew") },
  { 0xFB1F, wxS("yodyodpatahhebrew") },
  { 0x3088, wxS("yohiragana") },
  { 0x3189, wxS("yoikorean") },
  { 0x30E8, wxS("yokatakana") },
  { 0xFF96, wxS("yokatakanahalfwidth") },
  { 0x315B, wxS("yokorean") },
  { 0x3087, wxS("yosmallhiragana") },
  { 0x30E7, wxS("yosmallkatakana") },
  { 0xFF6E, wxS("yosmallkatakanahalfwidth") },
  { 0x03F3, wxS("yotgreek") },
  { 0x3188, wxS("yoyaekorean") },
  { 0x3187, wxS("yoyakorean") },
  { 0x0E22, wxS("yoyakthai") },
  { 0x0E0D, wxS("yoyingthai") },
  { 0x24B4, wxS("yparen") },
  { 0x037A, wxS("ypogegrammeni") },
  { 0x0345, wxS("ypogegrammenigreekcmb") },
  { 0x01A6, wxS("yr") },
  { 0x1E99, wxS("yring") },
  { 0x02B8, wxS("ysuperior") },
  { 0x1EF9, wxS("ytilde") },
  { 0x028E, wxS("yturned") },
  { 0x3086, wxS("yuhiragana") },
  { 0x318C, wxS("yuikorean") },
  { 0x30E6, wxS("yukatakana") },
  { 0xFF95, wxS("yukatakanahalfwidth") },
  { 0x3160, wxS("yukorean") },
  { 0x046B, wxS("yusbigcyrillic") },
  { 0x046D, wxS("yusbigiotifiedcyrillic") },
  { 0x0467, wxS("yuslittlecyrillic") },
  { 0x0469, wxS("yuslittleiotifiedcyrillic") },
  { 0x3085, wxS("yusmallhiragana") },
  { 0x30E5, wxS("yusmallkatakana") },
  { 0xFF6D, wxS("yusmallkatakanahalfwidth") },
  { 0x318B, wxS("yuyekorean") },
  { 0x318A, wxS("yuyeokorean") },
  { 0x09DF, wxS("yyabengali") },
  { 0x095F, wxS("yyadeva") },
  { 0x007A, wxS("z") },
  { 0x0566, wxS("zaarmenian") },
  { 0x017A, wxS("zacute") },
  { 0x095B, wxS("zadeva") },
  { 0x0A5B, wxS("zagurmukhi") },
  { 0x0638, wxS("zaharabic") },
  { 0xFEC6, wxS("zahfinalarabic") },
  { 0xFEC7, wxS("zahinitialarabic") },
  { 0x3056, wxS("zahiragana") },
  { 0xFEC8, wxS("zahmedialarabic") },
  { 0x0632, wxS("zainarabic") },
  { 0xFEB0, wxS("zainfinalarabic") },
  { 0x30B6, wxS("zakatakana") },
  { 0x0595, wxS("zaqefgadolhebrew") },
  { 0x0594, wxS("zaqefqatanhebrew") },
  { 0x0598, wxS("zarqahebrew") },
  { 0x05D6, wxS("zayin") },
  { 0xFB36, wxS("zayindagesh") },
  { 0xFB36, wxS("zayindageshhebrew") },
  { 0x05D6, wxS("zayinhebrew") },
  { 0x3117, wxS("zbopomofo") },
  { 0x017E, wxS("zcaron") },
  { 0x24E9, wxS("zcircle") },
  { 0x1E91, wxS("zcircumflex") },
  { 0x0291, wxS("zcurl") },
  { 0x017C, wxS("zdot") },
  { 0x017C, wxS("zdotaccent") },
  { 0x1E93, wxS("zdotbelow") },
  { 0x0437, wxS("zecyrillic") },
  { 0x0499, wxS("zedescendercyrillic") },
  { 0x04DF, wxS("zedieresiscyrillic") },
  { 0x305C, wxS("zehiragana") },
  { 0x30BC, wxS("zekatakana") },
  { 0x0030, wxS("zero") },
  { 0x0660, wxS("zeroarabic") },
  { 0x09E6, wxS("zerobengali") },
  { 0x0966, wxS("zerodeva") },
  { 0x0AE6, wxS("zerogujarati") },
  { 0x0A66, wxS("zerogurmukhi") },
  { 0x0660, wxS("zerohackarabic") },
  { 0x2080, wxS("zeroinferior") },
  { 0xFF10, wxS("zeromonospace") },
  { 0xF730, wxS("zerooldstyle") },
  { 0x06F0, wxS("zeropersian") },
  { 0x2070, wxS("zerosuperior") },
  { 0x0E50, wxS("zerothai") },
  { 0xFEFF, wxS("zerowidthjoiner") },
  { 0x200C, wxS("zerowidthnonjoiner") },
  { 0x200B, wxS("zerowidthspace") },
  { 0x03B6, wxS("zeta") },
  { 0x3113, wxS("zhbopomofo") },
  { 0x056A, wxS("zhearmenian") },
  { 0x04C2, wxS("zhebrevecyrillic") },
  { 0x0436, wxS("zhecyrillic") },
  { 0x0497, wxS("zhedescendercyrillic") },
  { 0x04DD, wxS("zhedieresiscyrillic") },
  { 0x3058, wxS("zihiragana") },
  { 0x30B8, wxS("zikatakana") },
  { 0x05AE, wxS("zinorhebrew") },
  { 0x1E95, wxS("zlinebelow") },
  { 0xFF5A, wxS("zmonospace") },
  { 0x305E, wxS("zohiragana") },
  { 0x30BE, wxS("zokatakana") },
  { 0x24B5, wxS("zparen") },
  { 0x0290, wxS("zretroflexhook") },
  { 0x01B6, wxS("zstroke") },
  { 0x305A, wxS("zuhiragana") },
  { 0x30BA, wxS("zukatakana") },
  { 0x0000, wxS("") }
};

static const size_t gs_glyphName2UnicodeTableSize = 4200;

static const wxGlyphDesc gs_zapfDingBats2UnicodeTable[] =
{
  { 0x2701, wxS("a1") },
  { 0x2721, wxS("a10") },
  { 0x275E, wxS("a100") },
  { 0x2761, wxS("a101") },
  { 0x2762, wxS("a102") },
  { 0x2763, wxS("a103") },
  { 0x2764, wxS("a104") },
  { 0x2710, wxS("a105") },
  { 0x2765, wxS("a106") },
  { 0x2766, wxS("a107") },
  { 0x2767, wxS("a108") },
  { 0x2660, wxS("a109") },
  { 0x261B, wxS("a11") },
  { 0x2665, wxS("a110") },
  { 0x2666, wxS("a111") },
  { 0x2663, wxS("a112") },
  { 0x2709, wxS("a117") },
  { 0x2708, wxS("a118") },
  { 0x2707, wxS("a119") },
  { 0x261E, wxS("a12") },
  { 0x2460, wxS("a120") },
  { 0x2461, wxS("a121") },
  { 0x2462, wxS("a122") },
  { 0x2463, wxS("a123") },
  { 0x2464, wxS("a124") },
  { 0x2465, wxS("a125") },
  { 0x2466, wxS("a126") },
  { 0x2467, wxS("a127") },
  { 0x2468, wxS("a128") },
  { 0x2469, wxS("a129") },
  { 0x270C, wxS("a13") },
  { 0x2776, wxS("a130") },
  { 0x2777, wxS("a131") },
  { 0x2778, wxS("a132") },
  { 0x2779, wxS("a133") },
  { 0x277A, wxS("a134") },
  { 0x277B, wxS("a135") },
  { 0x277C, wxS("a136") },
  { 0x277D, wxS("a137") },
  { 0x277E, wxS("a138") },
  { 0x277F, wxS("a139") },
  { 0x270D, wxS("a14") },
  { 0x2780, wxS("a140") },
  { 0x2781, wxS("a141") },
  { 0x2782, wxS("a142") },
  { 0x2783, wxS("a143") },
  { 0x2784, wxS("a144") },
  { 0x2785, wxS("a145") },
  { 0x2786, wxS("a146") },
  { 0x2787, wxS("a147") },
  { 0x2788, wxS("a148") },
  { 0x2789, wxS("a149") },
  { 0x270E, wxS("a15") },
  { 0x278A, wxS("a150") },
  { 0x278B, wxS("a151") },
  { 0x278C, wxS("a152") },
  { 0x278D, wxS("a153") },
  { 0x278E, wxS("a154") },
  { 0x278F, wxS("a155") },
  { 0x2790, wxS("a156") },
  { 0x2791, wxS("a157") },
  { 0x2792, wxS("a158") },
  { 0x2793, wxS("a159") },
  { 0x270F, wxS("a16") },
  { 0x2794, wxS("a160") },
  { 0x2192, wxS("a161") },
  { 0x27A3, wxS("a162") },
  { 0x2194, wxS("a163") },
  { 0x2195, wxS("a164") },
  { 0x2799, wxS("a165") },
  { 0x279B, wxS("a166") },
  { 0x279C, wxS("a167") },
  { 0x279D, wxS("a168") },
  { 0x279E, wxS("a169") },
  { 0x2711, wxS("a17") },
  { 0x279F, wxS("a170") },
  { 0x27A0, wxS("a171") },
  { 0x27A1, wxS("a172") },
  { 0x27A2, wxS("a173") },
  { 0x27A4, wxS("a174") },
  { 0x27A5, wxS("a175") },
  { 0x27A6, wxS("a176") },
  { 0x27A7, wxS("a177") },
  { 0x27A8, wxS("a178") },
  { 0x27A9, wxS("a179") },
  { 0x2712, wxS("a18") },
  { 0x27AB, wxS("a180") },
  { 0x27AD, wxS("a181") },
  { 0x27AF, wxS("a182") },
  { 0x27B2, wxS("a183") },
  { 0x27B3, wxS("a184") },
  { 0x27B5, wxS("a185") },
  { 0x27B8, wxS("a186") },
  { 0x27BA, wxS("a187") },
  { 0x27BB, wxS("a188") },
  { 0x27BC, wxS("a189") },
  { 0x2713, wxS("a19") },
  { 0x27BD, wxS("a190") },
  { 0x27BE, wxS("a191") },
  { 0x279A, wxS("a192") },
  { 0x27AA, wxS("a193") },
  { 0x27B6, wxS("a194") },
  { 0x27B9, wxS("a195") },
  { 0x2798, wxS("a196") },
  { 0x27B4, wxS("a197") },
  { 0x27B7, wxS("a198") },
  { 0x27AC, wxS("a199") },
  { 0x2702, wxS("a2") },
  { 0x2714, wxS("a20") },
  { 0x27AE, wxS("a200") },
  { 0x27B1, wxS("a201") },
  { 0x2703, wxS("a202") },
  { 0x2750, wxS("a203") },
  { 0x2752, wxS("a204") },
  { 0x276E, wxS("a205") },
  { 0x2770, wxS("a206") },
  { 0x2715, wxS("a21") },
  { 0x2716, wxS("a22") },
  { 0x2717, wxS("a23") },
  { 0x2718, wxS("a24") },
  { 0x2719, wxS("a25") },
  { 0x271A, wxS("a26") },
  { 0x271B, wxS("a27") },
  { 0x271C, wxS("a28") },
  { 0x2722, wxS("a29") },
  { 0x2704, wxS("a3") },
  { 0x2723, wxS("a30") },
  { 0x2724, wxS("a31") },
  { 0x2725, wxS("a32") },
  { 0x2726, wxS("a33") },
  { 0x2727, wxS("a34") },
  { 0x2605, wxS("a35") },
  { 0x2729, wxS("a36") },
  { 0x272A, wxS("a37") },
  { 0x272B, wxS("a38") },
  { 0x272C, wxS("a39") },
  { 0x260E, wxS("a4") },
  { 0x272D, wxS("a40") },
  { 0x272E, wxS("a41") },
  { 0x272F, wxS("a42") },
  { 0x2730, wxS("a43") },
  { 0x2731, wxS("a44") },
  { 0x2732, wxS("a45") },
  { 0x2733, wxS("a46") },
  { 0x2734, wxS("a47") },
  { 0x2735, wxS("a48") },
  { 0x2736, wxS("a49") },
  { 0x2706, wxS("a5") },
  { 0x2737, wxS("a50") },
  { 0x2738, wxS("a51") },
  { 0x2739, wxS("a52") },
  { 0x273A, wxS("a53") },
  { 0x273B, wxS("a54") },
  { 0x273C, wxS("a55") },
  { 0x273D, wxS("a56") },
  { 0x273E, wxS("a57") },
  { 0x273F, wxS("a58") },
  { 0x2740, wxS("a59") },
  { 0x271D, wxS("a6") },
  { 0x2741, wxS("a60") },
  { 0x2742, wxS("a61") },
  { 0x2743, wxS("a62") },
  { 0x2744, wxS("a63") },
  { 0x2745, wxS("a64") },
  { 0x2746, wxS("a65") },
  { 0x2747, wxS("a66") },
  { 0x2748, wxS("a67") },
  { 0x2749, wxS("a68") },
  { 0x274A, wxS("a69") },
  { 0x271E, wxS("a7") },
  { 0x274B, wxS("a70") },
  { 0x25CF, wxS("a71") },
  { 0x274D, wxS("a72") },
  { 0x25A0, wxS("a73") },
  { 0x274F, wxS("a74") },
  { 0x2751, wxS("a75") },
  { 0x25B2, wxS("a76") },
  { 0x25BC, wxS("a77") },
  { 0x25C6, wxS("a78") },
  { 0x2756, wxS("a79") },
  { 0x271F, wxS("a8") },
  { 0x25D7, wxS("a81") },
  { 0x2758, wxS("a82") },
  { 0x2759, wxS("a83") },
  { 0x275A, wxS("a84") },
  { 0x276F, wxS("a85") },
  { 0x2771, wxS("a86") },
  { 0x2772, wxS("a87") },
  { 0x2773, wxS("a88") },
  { 0x2768, wxS("a89") },
  { 0x2720, wxS("a9") },
  { 0x2769, wxS("a90") },
  { 0x276C, wxS("a91") },
  { 0x276D, wxS("a92") },
  { 0x276A, wxS("a93") },
  { 0x276B, wxS("a94") },
  { 0x2774, wxS("a95") },
  { 0x2775, wxS("a96") },
  { 0x275B, wxS("a97") },
  { 0x275C, wxS("a98") },
  { 0x275D, wxS("a99") }
};

static const size_t gs_zapfDingBats2UnicodeTableSize = 201;

static const wxGlyphDesc gs_unicode2GlyphNameTable[] =
{
  { 0x0001, wxS("controlSTX") },
  { 0x0002, wxS("controlSOT") },
  { 0x0003, wxS("controlETX") },
  { 0x0004, wxS("controlEOT") },
  { 0x0005, wxS("controlENQ") },
  { 0x0006, wxS("controlACK") },
  { 0x0007, wxS("controlBEL") },
  { 0x0008, wxS("controlBS") },
  { 0x0009, wxS("controlHT") },
  { 0x000A, wxS("controlLF") },
  { 0x000B, wxS("controlVT") },
  { 0x000C, wxS("controlFF") },
  { 0x000D, wxS("controlCR") },
  { 0x000E, wxS("controlSO") },
  { 0x000F, wxS("controlSI") },
  { 0x0010, wxS("controlDLE") },
  { 0x0011, wxS("controlDC1") },
  { 0x0012, wxS("controlDC2") },
  { 0x0013, wxS("controlDC3") },
  { 0x0014, wxS("controlDC4") },
  { 0x0015, wxS("controlNAK") },
  { 0x0016, wxS("controlSYN") },
  { 0x0017, wxS("controlETB") },
  { 0x0018, wxS("controlCAN") },
  { 0x0019, wxS("controlEM") },
  { 0x001A, wxS("controlSUB") },
  { 0x001B, wxS("controlESC") },
  { 0x001C, wxS("controlFS") },
  { 0x001D, wxS("controlGS") },
  { 0x001E, wxS("controlRS") },
  { 0x001F, wxS("controlUS") },
  { 0x0020, wxS("space") },
  { 0x0021, wxS("exclam") },
  { 0x0022, wxS("quotedbl") },
  { 0x0023, wxS("numbersign") },
  { 0x0024, wxS("dollar") },
  { 0x0025, wxS("percent") },
  { 0x0026, wxS("ampersand") },
  { 0x0027, wxS("quotesingle") },
  { 0x0028, wxS("parenleft") },
  { 0x0029, wxS("parenright") },
  { 0x002A, wxS("asterisk") },
  { 0x002B, wxS("plus") },
  { 0x002C, wxS("comma") },
  { 0x002D, wxS("hyphen") },
  { 0x002E, wxS("period") },
  { 0x002F, wxS("slash") },
  { 0x0030, wxS("zero") },
  { 0x0031, wxS("one") },
  { 0x0032, wxS("two") },
  { 0x0033, wxS("three") },
  { 0x0034, wxS("four") },
  { 0x0035, wxS("five") },
  { 0x0036, wxS("six") },
  { 0x0037, wxS("seven") },
  { 0x0038, wxS("eight") },
  { 0x0039, wxS("nine") },
  { 0x003A, wxS("colon") },
  { 0x003B, wxS("semicolon") },
  { 0x003C, wxS("less") },
  { 0x003D, wxS("equal") },
  { 0x003E, wxS("greater") },
  { 0x003F, wxS("question") },
  { 0x0040, wxS("at") },
  { 0x0041, wxS("A") },
  { 0x0042, wxS("B") },
  { 0x0043, wxS("C") },
  { 0x0044, wxS("D") },
  { 0x0045, wxS("E") },
  { 0x0046, wxS("F") },
  { 0x0047, wxS("G") },
  { 0x0048, wxS("H") },
  { 0x0049, wxS("I") },
  { 0x004A, wxS("J") },
  { 0x004B, wxS("K") },
  { 0x004C, wxS("L") },
  { 0x004D, wxS("M") },
  { 0x004E, wxS("N") },
  { 0x004F, wxS("O") },
  { 0x0050, wxS("P") },
  { 0x0051, wxS("Q") },
  { 0x0052, wxS("R") },
  { 0x0053, wxS("S") },
  { 0x0054, wxS("T") },
  { 0x0055, wxS("U") },
  { 0x0056, wxS("V") },
  { 0x0057, wxS("W") },
  { 0x0058, wxS("X") },
  { 0x0059, wxS("Y") },
  { 0x005A, wxS("Z") },
  { 0x005B, wxS("bracketleft") },
  { 0x005C, wxS("backslash") },
  { 0x005D, wxS("bracketright") },
  { 0x005E, wxS("asciicircum") },
  { 0x005F, wxS("underscore") },
  { 0x0060, wxS("grave") },
  { 0x0061, wxS("a") },
  { 0x0062, wxS("b") },
  { 0x0063, wxS("c") },
  { 0x0064, wxS("d") },
  { 0x0065, wxS("e") },
  { 0x0066, wxS("f") },
  { 0x0067, wxS("g") },
  { 0x0068, wxS("h") },
  { 0x0069, wxS("i") },
  { 0x006A, wxS("j") },
  { 0x006B, wxS("k") },
  { 0x006C, wxS("l") },
  { 0x006D, wxS("m") },
  { 0x006E, wxS("n") },
  { 0x006F, wxS("o") },
  { 0x0070, wxS("p") },
  { 0x0071, wxS("q") },
  { 0x0072, wxS("r") },
  { 0x0073, wxS("s") },
  { 0x0074, wxS("t") },
  { 0x0075, wxS("u") },
  { 0x0076, wxS("v") },
  { 0x0077, wxS("w") },
  { 0x0078, wxS("x") },
  { 0x0079, wxS("y") },
  { 0x007A, wxS("z") },
  { 0x007B, wxS("braceleft") },
  { 0x007C, wxS("bar") },
  { 0x007D, wxS("braceright") },
  { 0x007E, wxS("asciitilde") },
  { 0x007F, wxS("controlDEL") },
  { 0x00A0, wxS("space") },
  { 0x00A1, wxS("exclamdown") },
  { 0x00A2, wxS("cent") },
  { 0x00A3, wxS("sterling") },
  { 0x00A4, wxS("currency") },
  { 0x00A5, wxS("yen") },
  { 0x00A6, wxS("brokenbar") },
  { 0x00A7, wxS("section") },
  { 0x00A8, wxS("dieresis") },
  { 0x00A9, wxS("copyright") },
  { 0x00AA, wxS("ordfeminine") },
  { 0x00AB, wxS("guillemotleft") },
  { 0x00AC, wxS("logicalnot") },
  { 0x00AD, wxS("hyphen") },
  { 0x00AE, wxS("registered") },
  { 0x00AF, wxS("macron") },
  { 0x00B0, wxS("degree") },
  { 0x00B1, wxS("plusminus") },
  { 0x00B2, wxS("twosuperior") },
  { 0x00B3, wxS("threesuperior") },
  { 0x00B4, wxS("acute") },
  { 0x00B5, wxS("mu") },
  { 0x00B6, wxS("paragraph") },
  { 0x00B7, wxS("periodcentered") },
  { 0x00B8, wxS("cedilla") },
  { 0x00B9, wxS("onesuperior") },
  { 0x00BA, wxS("ordmasculine") },
  { 0x00BB, wxS("guillemotright") },
  { 0x00BC, wxS("onequarter") },
  { 0x00BD, wxS("onehalf") },
  { 0x00BE, wxS("threequarters") },
  { 0x00BF, wxS("questiondown") },
  { 0x00C0, wxS("Agrave") },
  { 0x00C1, wxS("Aacute") },
  { 0x00C2, wxS("Acircumflex") },
  { 0x00C3, wxS("Atilde") },
  { 0x00C4, wxS("Adieresis") },
  { 0x00C5, wxS("Aring") },
  { 0x00C6, wxS("AE") },
  { 0x00C7, wxS("Ccedilla") },
  { 0x00C8, wxS("Egrave") },
  { 0x00C9, wxS("Eacute") },
  { 0x00CA, wxS("Ecircumflex") },
  { 0x00CB, wxS("Edieresis") },
  { 0x00CC, wxS("Igrave") },
  { 0x00CD, wxS("Iacute") },
  { 0x00CE, wxS("Icircumflex") },
  { 0x00CF, wxS("Idieresis") },
  { 0x00D0, wxS("Eth") },
  { 0x00D1, wxS("Ntilde") },
  { 0x00D2, wxS("Ograve") },
  { 0x00D3, wxS("Oacute") },
  { 0x00D4, wxS("Ocircumflex") },
  { 0x00D5, wxS("Otilde") },
  { 0x00D6, wxS("Odieresis") },
  { 0x00D7, wxS("multiply") },
  { 0x00D8, wxS("Oslash") },
  { 0x00D9, wxS("Ugrave") },
  { 0x00DA, wxS("Uacute") },
  { 0x00DB, wxS("Ucircumflex") },
  { 0x00DC, wxS("Udieresis") },
  { 0x00DD, wxS("Yacute") },
  { 0x00DE, wxS("Thorn") },
  { 0x00DF, wxS("germandbls") },
  { 0x00E0, wxS("agrave") },
  { 0x00E1, wxS("aacute") },
  { 0x00E2, wxS("acircumflex") },
  { 0x00E3, wxS("atilde") },
  { 0x00E4, wxS("adieresis") },
  { 0x00E5, wxS("aring") },
  { 0x00E6, wxS("ae") },
  { 0x00E7, wxS("ccedilla") },
  { 0x00E8, wxS("egrave") },
  { 0x00E9, wxS("eacute") },
  { 0x00EA, wxS("ecircumflex") },
  { 0x00EB, wxS("edieresis") },
  { 0x00EC, wxS("igrave") },
  { 0x00ED, wxS("iacute") },
  { 0x00EE, wxS("icircumflex") },
  { 0x00EF, wxS("idieresis") },
  { 0x00F0, wxS("eth") },
  { 0x00F1, wxS("ntilde") },
  { 0x00F2, wxS("ograve") },
  { 0x00F3, wxS("oacute") },
  { 0x00F4, wxS("ocircumflex") },
  { 0x00F5, wxS("otilde") },
  { 0x00F6, wxS("odieresis") },
  { 0x00F7, wxS("divide") },
  { 0x00F8, wxS("oslash") },
  { 0x00F9, wxS("ugrave") },
  { 0x00FA, wxS("uacute") },
  { 0x00FB, wxS("ucircumflex") },
  { 0x00FC, wxS("udieresis") },
  { 0x00FD, wxS("yacute") },
  { 0x00FE, wxS("thorn") },
  { 0x00FF, wxS("ydieresis") },
  { 0x0100, wxS("Amacron") },
  { 0x0101, wxS("amacron") },
  { 0x0102, wxS("Abreve") },
  { 0x0103, wxS("abreve") },
  { 0x0104, wxS("Aogonek") },
  { 0x0105, wxS("aogonek") },
  { 0x0106, wxS("Cacute") },
  { 0x0107, wxS("cacute") },
  { 0x0108, wxS("Ccircumflex") },
  { 0x0109, wxS("ccircumflex") },
  { 0x010A, wxS("Cdotaccent") },
  { 0x010B, wxS("cdotaccent") },
  { 0x010C, wxS("Ccaron") },
  { 0x010D, wxS("ccaron") },
  { 0x010E, wxS("Dcaron") },
  { 0x010F, wxS("dcaron") },
  { 0x0110, wxS("Dcroat") },
  { 0x0111, wxS("dcroat") },
  { 0x0112, wxS("Emacron") },
  { 0x0113, wxS("emacron") },
  { 0x0114, wxS("Ebreve") },
  { 0x0115, wxS("ebreve") },
  { 0x0116, wxS("Edotaccent") },
  { 0x0117, wxS("edotaccent") },
  { 0x0118, wxS("Eogonek") },
  { 0x0119, wxS("eogonek") },
  { 0x011A, wxS("Ecaron") },
  { 0x011B, wxS("ecaron") },
  { 0x011C, wxS("Gcircumflex") },
  { 0x011D, wxS("gcircumflex") },
  { 0x011E, wxS("Gbreve") },
  { 0x011F, wxS("gbreve") },
  { 0x0120, wxS("Gdotaccent") },
  { 0x0121, wxS("gdotaccent") },
  { 0x0122, wxS("Gcommaaccent") },
  { 0x0123, wxS("gcommaaccent") },
  { 0x0124, wxS("Hcircumflex") },
  { 0x0125, wxS("hcircumflex") },
  { 0x0126, wxS("Hbar") },
  { 0x0127, wxS("hbar") },
  { 0x0128, wxS("Itilde") },
  { 0x0129, wxS("itilde") },
  { 0x012A, wxS("Imacron") },
  { 0x012B, wxS("imacron") },
  { 0x012C, wxS("Ibreve") },
  { 0x012D, wxS("ibreve") },
  { 0x012E, wxS("Iogonek") },
  { 0x012F, wxS("iogonek") },
  { 0x0130, wxS("Idotaccent") },
  { 0x0131, wxS("dotlessi") },
  { 0x0132, wxS("IJ") },
  { 0x0133, wxS("ij") },
  { 0x0134, wxS("Jcircumflex") },
  { 0x0135, wxS("jcircumflex") },
  { 0x0136, wxS("Kcommaaccent") },
  { 0x0137, wxS("kcommaaccent") },
  { 0x0138, wxS("kgreenlandic") },
  { 0x0139, wxS("Lacute") },
  { 0x013A, wxS("lacute") },
  { 0x013B, wxS("Lcommaaccent") },
  { 0x013C, wxS("lcommaaccent") },
  { 0x013D, wxS("Lcaron") },
  { 0x013E, wxS("lcaron") },
  { 0x013F, wxS("Ldot") },
  { 0x0140, wxS("ldot") },
  { 0x0141, wxS("Lslash") },
  { 0x0142, wxS("lslash") },
  { 0x0143, wxS("Nacute") },
  { 0x0144, wxS("nacute") },
  { 0x0145, wxS("Ncommaaccent") },
  { 0x0146, wxS("ncommaaccent") },
  { 0x0147, wxS("Ncaron") },
  { 0x0148, wxS("ncaron") },
  { 0x0149, wxS("napostrophe") },
  { 0x014A, wxS("Eng") },
  { 0x014B, wxS("eng") },
  { 0x014C, wxS("Omacron") },
  { 0x014D, wxS("omacron") },
  { 0x014E, wxS("Obreve") },
  { 0x014F, wxS("obreve") },
  { 0x0150, wxS("Ohungarumlaut") },
  { 0x0151, wxS("ohungarumlaut") },
  { 0x0152, wxS("OE") },
  { 0x0153, wxS("oe") },
  { 0x0154, wxS("Racute") },
  { 0x0155, wxS("racute") },
  { 0x0156, wxS("Rcommaaccent") },
  { 0x0157, wxS("rcommaaccent") },
  { 0x0158, wxS("Rcaron") },
  { 0x0159, wxS("rcaron") },
  { 0x015A, wxS("Sacute") },
  { 0x015B, wxS("sacute") },
  { 0x015C, wxS("Scircumflex") },
  { 0x015D, wxS("scircumflex") },
  { 0x015E, wxS("Scedilla") },
  { 0x015F, wxS("scedilla") },
  { 0x0160, wxS("Scaron") },
  { 0x0161, wxS("scaron") },
  { 0x0162, wxS("Tcommaaccent") },
  { 0x0163, wxS("tcommaaccent") },
  { 0x0164, wxS("Tcaron") },
  { 0x0165, wxS("tcaron") },
  { 0x0166, wxS("Tbar") },
  { 0x0167, wxS("tbar") },
  { 0x0168, wxS("Utilde") },
  { 0x0169, wxS("utilde") },
  { 0x016A, wxS("Umacron") },
  { 0x016B, wxS("umacron") },
  { 0x016C, wxS("Ubreve") },
  { 0x016D, wxS("ubreve") },
  { 0x016E, wxS("Uring") },
  { 0x016F, wxS("uring") },
  { 0x0170, wxS("Uhungarumlaut") },
  { 0x0171, wxS("uhungarumlaut") },
  { 0x0172, wxS("Uogonek") },
  { 0x0173, wxS("uogonek") },
  { 0x0174, wxS("Wcircumflex") },
  { 0x0175, wxS("wcircumflex") },
  { 0x0176, wxS("Ycircumflex") },
  { 0x0177, wxS("ycircumflex") },
  { 0x0178, wxS("Ydieresis") },
  { 0x0179, wxS("Zacute") },
  { 0x017A, wxS("zacute") },
  { 0x017B, wxS("Zdotaccent") },
  { 0x017C, wxS("zdotaccent") },
  { 0x017D, wxS("Zcaron") },
  { 0x017E, wxS("zcaron") },
  { 0x017F, wxS("longs") },
  { 0x0180, wxS("bstroke") },
  { 0x0181, wxS("Bhook") },
  { 0x0182, wxS("Btopbar") },
  { 0x0183, wxS("btopbar") },
  { 0x0184, wxS("Tonesix") },
  { 0x0185, wxS("tonesix") },
  { 0x0186, wxS("Oopen") },
  { 0x0187, wxS("Chook") },
  { 0x0188, wxS("chook") },
  { 0x0189, wxS("Dafrican") },
  { 0x018A, wxS("Dhook") },
  { 0x018B, wxS("Dtopbar") },
  { 0x018C, wxS("dtopbar") },
  { 0x018D, wxS("deltaturned") },
  { 0x018E, wxS("Ereversed") },
  { 0x018F, wxS("Schwa") },
  { 0x0190, wxS("Eopen") },
  { 0x0191, wxS("Fhook") },
  { 0x0192, wxS("florin") },
  { 0x0193, wxS("Ghook") },
  { 0x0194, wxS("Gammaafrican") },
  { 0x0195, wxS("hv") },
  { 0x0196, wxS("Iotaafrican") },
  { 0x0197, wxS("Istroke") },
  { 0x0198, wxS("Khook") },
  { 0x0199, wxS("khook") },
  { 0x019A, wxS("lbar") },
  { 0x019B, wxS("lambdastroke") },
  { 0x019C, wxS("Mturned") },
  { 0x019D, wxS("Nhookleft") },
  { 0x019E, wxS("nlegrightlong") },
  { 0x019F, wxS("Ocenteredtilde") },
  { 0x01A0, wxS("Ohorn") },
  { 0x01A1, wxS("ohorn") },
  { 0x01A2, wxS("Oi") },
  { 0x01A3, wxS("oi") },
  { 0x01A4, wxS("Phook") },
  { 0x01A5, wxS("phook") },
  { 0x01A6, wxS("yr") },
  { 0x01A7, wxS("Tonetwo") },
  { 0x01A8, wxS("tonetwo") },
  { 0x01A9, wxS("Esh") },
  { 0x01AA, wxS("eshreversedloop") },
  { 0x01AB, wxS("tpalatalhook") },
  { 0x01AC, wxS("Thook") },
  { 0x01AD, wxS("thook") },
  { 0x01AE, wxS("Tretroflexhook") },
  { 0x01AF, wxS("Uhorn") },
  { 0x01B0, wxS("uhorn") },
  { 0x01B1, wxS("Upsilonafrican") },
  { 0x01B2, wxS("Vhook") },
  { 0x01B3, wxS("Yhook") },
  { 0x01B4, wxS("yhook") },
  { 0x01B5, wxS("Zstroke") },
  { 0x01B6, wxS("zstroke") },
  { 0x01B7, wxS("Ezh") },
  { 0x01B8, wxS("Ezhreversed") },
  { 0x01B9, wxS("ezhreversed") },
  { 0x01BA, wxS("ezhtail") },
  { 0x01BB, wxS("twostroke") },
  { 0x01BC, wxS("Tonefive") },
  { 0x01BD, wxS("tonefive") },
  { 0x01BE, wxS("glottalinvertedstroke") },
  { 0x01BF, wxS("wynn") },
  { 0x01C0, wxS("clickdental") },
  { 0x01C1, wxS("clicklateral") },
  { 0x01C2, wxS("clickalveolar") },
  { 0x01C3, wxS("clickretroflex") },
  { 0x01C4, wxS("DZcaron") },
  { 0x01C5, wxS("Dzcaron") },
  { 0x01C6, wxS("dzcaron") },
  { 0x01C7, wxS("LJ") },
  { 0x01C8, wxS("Lj") },
  { 0x01C9, wxS("lj") },
  { 0x01CA, wxS("NJ") },
  { 0x01CB, wxS("Nj") },
  { 0x01CC, wxS("nj") },
  { 0x01CD, wxS("Acaron") },
  { 0x01CE, wxS("acaron") },
  { 0x01CF, wxS("Icaron") },
  { 0x01D0, wxS("icaron") },
  { 0x01D1, wxS("Ocaron") },
  { 0x01D2, wxS("ocaron") },
  { 0x01D3, wxS("Ucaron") },
  { 0x01D4, wxS("ucaron") },
  { 0x01D5, wxS("Udieresismacron") },
  { 0x01D6, wxS("udieresismacron") },
  { 0x01D7, wxS("Udieresisacute") },
  { 0x01D8, wxS("udieresisacute") },
  { 0x01D9, wxS("Udieresiscaron") },
  { 0x01DA, wxS("udieresiscaron") },
  { 0x01DB, wxS("Udieresisgrave") },
  { 0x01DC, wxS("udieresisgrave") },
  { 0x01DD, wxS("eturned") },
  { 0x01DE, wxS("Adieresismacron") },
  { 0x01DF, wxS("adieresismacron") },
  { 0x01E0, wxS("Adotmacron") },
  { 0x01E1, wxS("adotmacron") },
  { 0x01E2, wxS("AEmacron") },
  { 0x01E3, wxS("aemacron") },
  { 0x01E4, wxS("Gstroke") },
  { 0x01E5, wxS("gstroke") },
  { 0x01E6, wxS("Gcaron") },
  { 0x01E7, wxS("gcaron") },
  { 0x01E8, wxS("Kcaron") },
  { 0x01E9, wxS("kcaron") },
  { 0x01EA, wxS("Oogonek") },
  { 0x01EB, wxS("oogonek") },
  { 0x01EC, wxS("Oogonekmacron") },
  { 0x01ED, wxS("oogonekmacron") },
  { 0x01EE, wxS("Ezhcaron") },
  { 0x01EF, wxS("ezhcaron") },
  { 0x01F0, wxS("jcaron") },
  { 0x01F1, wxS("DZ") },
  { 0x01F2, wxS("Dz") },
  { 0x01F3, wxS("dz") },
  { 0x01F4, wxS("Gacute") },
  { 0x01F5, wxS("gacute") },
  { 0x01FA, wxS("Aringacute") },
  { 0x01FB, wxS("aringacute") },
  { 0x01FC, wxS("AEacute") },
  { 0x01FD, wxS("aeacute") },
  { 0x01FE, wxS("Oslashacute") },
  { 0x01FF, wxS("oslashacute") },
  { 0x0200, wxS("Adblgrave") },
  { 0x0201, wxS("adblgrave") },
  { 0x0202, wxS("Ainvertedbreve") },
  { 0x0203, wxS("ainvertedbreve") },
  { 0x0204, wxS("Edblgrave") },
  { 0x0205, wxS("edblgrave") },
  { 0x0206, wxS("Einvertedbreve") },
  { 0x0207, wxS("einvertedbreve") },
  { 0x0208, wxS("Idblgrave") },
  { 0x0209, wxS("idblgrave") },
  { 0x020A, wxS("Iinvertedbreve") },
  { 0x020B, wxS("iinvertedbreve") },
  { 0x020C, wxS("Odblgrave") },
  { 0x020D, wxS("odblgrave") },
  { 0x020E, wxS("Oinvertedbreve") },
  { 0x020F, wxS("oinvertedbreve") },
  { 0x0210, wxS("Rdblgrave") },
  { 0x0211, wxS("rdblgrave") },
  { 0x0212, wxS("Rinvertedbreve") },
  { 0x0213, wxS("rinvertedbreve") },
  { 0x0214, wxS("Udblgrave") },
  { 0x0215, wxS("udblgrave") },
  { 0x0216, wxS("Uinvertedbreve") },
  { 0x0217, wxS("uinvertedbreve") },
  { 0x0218, wxS("Scommaaccent") },
  { 0x0219, wxS("scommaaccent") },
  { 0x021A, wxS("Tcommaaccent") },
  { 0x021B, wxS("tcommaaccent") },
  { 0x0250, wxS("aturned") },
  { 0x0251, wxS("ascript") },
  { 0x0252, wxS("ascriptturned") },
  { 0x0253, wxS("bhook") },
  { 0x0254, wxS("oopen") },
  { 0x0255, wxS("ccurl") },
  { 0x0256, wxS("dtail") },
  { 0x0257, wxS("dhook") },
  { 0x0258, wxS("ereversed") },
  { 0x0259, wxS("schwa") },
  { 0x025A, wxS("schwahook") },
  { 0x025B, wxS("eopen") },
  { 0x025C, wxS("eopenreversed") },
  { 0x025D, wxS("eopenreversedhook") },
  { 0x025E, wxS("eopenreversedclosed") },
  { 0x025F, wxS("jdotlessstroke") },
  { 0x0260, wxS("ghook") },
  { 0x0261, wxS("gscript") },
  { 0x0263, wxS("gammalatinsmall") },
  { 0x0264, wxS("ramshorn") },
  { 0x0265, wxS("hturned") },
  { 0x0266, wxS("hhook") },
  { 0x0267, wxS("henghook") },
  { 0x0268, wxS("istroke") },
  { 0x0269, wxS("iotalatin") },
  { 0x026B, wxS("lmiddletilde") },
  { 0x026C, wxS("lbelt") },
  { 0x026D, wxS("lhookretroflex") },
  { 0x026E, wxS("lezh") },
  { 0x026F, wxS("mturned") },
  { 0x0270, wxS("mlonglegturned") },
  { 0x0271, wxS("mhook") },
  { 0x0272, wxS("nhookleft") },
  { 0x0273, wxS("nhookretroflex") },
  { 0x0275, wxS("obarred") },
  { 0x0277, wxS("omegalatinclosed") },
  { 0x0278, wxS("philatin") },
  { 0x0279, wxS("rturned") },
  { 0x027A, wxS("rlonglegturned") },
  { 0x027B, wxS("rhookturned") },
  { 0x027C, wxS("rlongleg") },
  { 0x027D, wxS("rhook") },
  { 0x027E, wxS("rfishhook") },
  { 0x027F, wxS("rfishhookreversed") },
  { 0x0281, wxS("Rsmallinverted") },
  { 0x0282, wxS("shook") },
  { 0x0283, wxS("esh") },
  { 0x0284, wxS("dotlessjstrokehook") },
  { 0x0285, wxS("eshsquatreversed") },
  { 0x0286, wxS("eshcurl") },
  { 0x0287, wxS("tturned") },
  { 0x0288, wxS("tretroflexhook") },
  { 0x0289, wxS("ubar") },
  { 0x028A, wxS("upsilonlatin") },
  { 0x028B, wxS("vhook") },
  { 0x028C, wxS("vturned") },
  { 0x028D, wxS("wturned") },
  { 0x028E, wxS("yturned") },
  { 0x0290, wxS("zretroflexhook") },
  { 0x0291, wxS("zcurl") },
  { 0x0292, wxS("ezh") },
  { 0x0293, wxS("ezhcurl") },
  { 0x0294, wxS("glottalstop") },
  { 0x0295, wxS("glottalstopreversed") },
  { 0x0296, wxS("glottalstopinverted") },
  { 0x0297, wxS("cstretched") },
  { 0x0298, wxS("bilabialclick") },
  { 0x029A, wxS("eopenclosed") },
  { 0x029B, wxS("Gsmallhook") },
  { 0x029D, wxS("jcrossedtail") },
  { 0x029E, wxS("kturned") },
  { 0x02A0, wxS("qhook") },
  { 0x02A1, wxS("glottalstopstroke") },
  { 0x02A2, wxS("glottalstopstrokereversed") },
  { 0x02A3, wxS("dzaltone") },
  { 0x02A4, wxS("dezh") },
  { 0x02A5, wxS("dzcurl") },
  { 0x02A6, wxS("ts") },
  { 0x02A7, wxS("tesh") },
  { 0x02A8, wxS("tccurl") },
  { 0x02B0, wxS("hsuperior") },
  { 0x02B1, wxS("hhooksuperior") },
  { 0x02B2, wxS("jsuperior") },
  { 0x02B4, wxS("rturnedsuperior") },
  { 0x02B5, wxS("rhookturnedsuperior") },
  { 0x02B6, wxS("Rsmallinvertedsuperior") },
  { 0x02B7, wxS("wsuperior") },
  { 0x02B8, wxS("ysuperior") },
  { 0x02B9, wxS("primemod") },
  { 0x02BA, wxS("dblprimemod") },
  { 0x02BB, wxS("commaturnedmod") },
  { 0x02BC, wxS("afii57929") },
  { 0x02BD, wxS("afii64937") },
  { 0x02BE, wxS("ringhalfright") },
  { 0x02BF, wxS("ringhalfleft") },
  { 0x02C0, wxS("glottalstopmod") },
  { 0x02C1, wxS("glottalstopreversedmod") },
  { 0x02C2, wxS("arrowheadleftmod") },
  { 0x02C3, wxS("arrowheadrightmod") },
  { 0x02C4, wxS("arrowheadupmod") },
  { 0x02C5, wxS("arrowheaddownmod") },
  { 0x02C6, wxS("circumflex") },
  { 0x02C7, wxS("caron") },
  { 0x02C8, wxS("verticallinemod") },
  { 0x02C9, wxS("firsttonechinese") },
  { 0x02CA, wxS("secondtonechinese") },
  { 0x02CB, wxS("fourthtonechinese") },
  { 0x02CC, wxS("verticallinelowmod") },
  { 0x02CD, wxS("macronlowmod") },
  { 0x02CE, wxS("gravelowmod") },
  { 0x02CF, wxS("acutelowmod") },
  { 0x02D0, wxS("colontriangularmod") },
  { 0x02D1, wxS("colontriangularhalfmod") },
  { 0x02D2, wxS("ringhalfrightcentered") },
  { 0x02D3, wxS("ringhalfleftcentered") },
  { 0x02D4, wxS("uptackmod") },
  { 0x02D5, wxS("downtackmod") },
  { 0x02D6, wxS("plusmod") },
  { 0x02D7, wxS("minusmod") },
  { 0x02D8, wxS("breve") },
  { 0x02D9, wxS("dotaccent") },
  { 0x02DA, wxS("ring") },
  { 0x02DB, wxS("ogonek") },
  { 0x02DC, wxS("tilde") },
  { 0x02DD, wxS("hungarumlaut") },
  { 0x02DE, wxS("rhotichookmod") },
  { 0x02E0, wxS("gammasuperior") },
  { 0x02E3, wxS("xsuperior") },
  { 0x02E4, wxS("glottalstopreversedsuperior") },
  { 0x02E5, wxS("tonebarextrahighmod") },
  { 0x02E6, wxS("tonebarhighmod") },
  { 0x02E7, wxS("tonebarmidmod") },
  { 0x02E8, wxS("tonebarlowmod") },
  { 0x02E9, wxS("tonebarextralowmod") },
  { 0x0300, wxS("gravecomb") },
  { 0x0301, wxS("acutecomb") },
  { 0x0302, wxS("circumflexcmb") },
  { 0x0303, wxS("tildecomb") },
  { 0x0304, wxS("macroncmb") },
  { 0x0305, wxS("overlinecmb") },
  { 0x0306, wxS("brevecmb") },
  { 0x0307, wxS("dotaccentcmb") },
  { 0x0308, wxS("dieresiscmb") },
  { 0x0309, wxS("hookabovecomb") },
  { 0x030A, wxS("ringcmb") },
  { 0x030B, wxS("hungarumlautcmb") },
  { 0x030C, wxS("caroncmb") },
  { 0x030D, wxS("verticallineabovecmb") },
  { 0x030E, wxS("dblverticallineabovecmb") },
  { 0x030F, wxS("dblgravecmb") },
  { 0x0310, wxS("candrabinducmb") },
  { 0x0311, wxS("breveinvertedcmb") },
  { 0x0312, wxS("commaturnedabovecmb") },
  { 0x0313, wxS("commaabovecmb") },
  { 0x0314, wxS("commareversedabovecmb") },
  { 0x0315, wxS("commaaboverightcmb") },
  { 0x0316, wxS("gravebelowcmb") },
  { 0x0317, wxS("acutebelowcmb") },
  { 0x0318, wxS("lefttackbelowcmb") },
  { 0x0319, wxS("righttackbelowcmb") },
  { 0x031A, wxS("leftangleabovecmb") },
  { 0x031B, wxS("horncmb") },
  { 0x031C, wxS("ringhalfleftbelowcmb") },
  { 0x031D, wxS("uptackbelowcmb") },
  { 0x031E, wxS("downtackbelowcmb") },
  { 0x031F, wxS("plusbelowcmb") },
  { 0x0320, wxS("minusbelowcmb") },
  { 0x0321, wxS("hookpalatalizedbelowcmb") },
  { 0x0322, wxS("hookretroflexbelowcmb") },
  { 0x0323, wxS("dotbelowcomb") },
  { 0x0324, wxS("dieresisbelowcmb") },
  { 0x0325, wxS("ringbelowcmb") },
  { 0x0327, wxS("cedillacmb") },
  { 0x0328, wxS("ogonekcmb") },
  { 0x0329, wxS("verticallinebelowcmb") },
  { 0x032A, wxS("bridgebelowcmb") },
  { 0x032B, wxS("dblarchinvertedbelowcmb") },
  { 0x032C, wxS("caronbelowcmb") },
  { 0x032D, wxS("circumflexbelowcmb") },
  { 0x032E, wxS("brevebelowcmb") },
  { 0x032F, wxS("breveinvertedbelowcmb") },
  { 0x0330, wxS("tildebelowcmb") },
  { 0x0331, wxS("macronbelowcmb") },
  { 0x0332, wxS("lowlinecmb") },
  { 0x0333, wxS("dbllowlinecmb") },
  { 0x0334, wxS("tildeoverlaycmb") },
  { 0x0335, wxS("strokeshortoverlaycmb") },
  { 0x0336, wxS("strokelongoverlaycmb") },
  { 0x0337, wxS("solidusshortoverlaycmb") },
  { 0x0338, wxS("soliduslongoverlaycmb") },
  { 0x0339, wxS("ringhalfrightbelowcmb") },
  { 0x033A, wxS("bridgeinvertedbelowcmb") },
  { 0x033B, wxS("squarebelowcmb") },
  { 0x033C, wxS("seagullbelowcmb") },
  { 0x033D, wxS("xabovecmb") },
  { 0x033E, wxS("tildeverticalcmb") },
  { 0x033F, wxS("dbloverlinecmb") },
  { 0x0340, wxS("gravetonecmb") },
  { 0x0341, wxS("acutetonecmb") },
  { 0x0342, wxS("perispomenigreekcmb") },
  { 0x0343, wxS("koroniscmb") },
  { 0x0344, wxS("dialytikatonoscmb") },
  { 0x0345, wxS("ypogegrammenigreekcmb") },
  { 0x0360, wxS("tildedoublecmb") },
  { 0x0361, wxS("breveinverteddoublecmb") },
  { 0x0374, wxS("numeralsigngreek") },
  { 0x0375, wxS("numeralsignlowergreek") },
  { 0x037A, wxS("ypogegrammeni") },
  { 0x037E, wxS("questiongreek") },
  { 0x0384, wxS("tonos") },
  { 0x0385, wxS("dieresistonos") },
  { 0x0386, wxS("Alphatonos") },
  { 0x0387, wxS("anoteleia") },
  { 0x0388, wxS("Epsilontonos") },
  { 0x0389, wxS("Etatonos") },
  { 0x038A, wxS("Iotatonos") },
  { 0x038C, wxS("Omicrontonos") },
  { 0x038E, wxS("Upsilontonos") },
  { 0x038F, wxS("Omegatonos") },
  { 0x0390, wxS("iotadieresistonos") },
  { 0x0391, wxS("Alpha") },
  { 0x0392, wxS("Beta") },
  { 0x0393, wxS("Gamma") },
  { 0x0394, wxS("Delta") },
  { 0x0395, wxS("Epsilon") },
  { 0x0396, wxS("Zeta") },
  { 0x0397, wxS("Eta") },
  { 0x0398, wxS("Theta") },
  { 0x0399, wxS("Iota") },
  { 0x039A, wxS("Kappa") },
  { 0x039B, wxS("Lambda") },
  { 0x039C, wxS("Mu") },
  { 0x039D, wxS("Nu") },
  { 0x039E, wxS("Xi") },
  { 0x039F, wxS("Omicron") },
  { 0x03A0, wxS("Pi") },
  { 0x03A1, wxS("Rho") },
  { 0x03A3, wxS("Sigma") },
  { 0x03A4, wxS("Tau") },
  { 0x03A5, wxS("Upsilon") },
  { 0x03A6, wxS("Phi") },
  { 0x03A7, wxS("Chi") },
  { 0x03A8, wxS("Psi") },
  { 0x03A9, wxS("Omega") },
  { 0x03AA, wxS("Iotadieresis") },
  { 0x03AB, wxS("Upsilondieresis") },
  { 0x03AC, wxS("alphatonos") },
  { 0x03AD, wxS("epsilontonos") },
  { 0x03AE, wxS("etatonos") },
  { 0x03AF, wxS("iotatonos") },
  { 0x03B0, wxS("upsilondieresistonos") },
  { 0x03B1, wxS("alpha") },
  { 0x03B2, wxS("beta") },
  { 0x03B3, wxS("gamma") },
  { 0x03B4, wxS("delta") },
  { 0x03B5, wxS("epsilon") },
  { 0x03B6, wxS("zeta") },
  { 0x03B7, wxS("eta") },
  { 0x03B8, wxS("theta") },
  { 0x03B9, wxS("iota") },
  { 0x03BA, wxS("kappa") },
  { 0x03BB, wxS("lambda") },
  { 0x03BC, wxS("mu") },
  { 0x03BD, wxS("nu") },
  { 0x03BE, wxS("xi") },
  { 0x03BF, wxS("omicron") },
  { 0x03C0, wxS("pi") },
  { 0x03C1, wxS("rho") },
  { 0x03C2, wxS("sigma1") },
  { 0x03C3, wxS("sigma") },
  { 0x03C4, wxS("tau") },
  { 0x03C5, wxS("upsilon") },
  { 0x03C6, wxS("phi") },
  { 0x03C7, wxS("chi") },
  { 0x03C8, wxS("psi") },
  { 0x03C9, wxS("omega") },
  { 0x03CA, wxS("iotadieresis") },
  { 0x03CB, wxS("upsilondieresis") },
  { 0x03CC, wxS("omicrontonos") },
  { 0x03CD, wxS("upsilontonos") },
  { 0x03CE, wxS("omegatonos") },
  { 0x03D0, wxS("betasymbolgreek") },
  { 0x03D1, wxS("theta1") },
  { 0x03D2, wxS("Upsilon1") },
  { 0x03D3, wxS("Upsilonacutehooksymbolgreek") },
  { 0x03D4, wxS("Upsilondieresishooksymbolgreek") },
  { 0x03D5, wxS("phi1") },
  { 0x03D6, wxS("omega1") },
  { 0x03DA, wxS("Stigmagreek") },
  { 0x03DC, wxS("Digammagreek") },
  { 0x03DE, wxS("Koppagreek") },
  { 0x03E0, wxS("Sampigreek") },
  { 0x03E2, wxS("Sheicoptic") },
  { 0x03E3, wxS("sheicoptic") },
  { 0x03E4, wxS("Feicoptic") },
  { 0x03E5, wxS("feicoptic") },
  { 0x03E6, wxS("Kheicoptic") },
  { 0x03E7, wxS("kheicoptic") },
  { 0x03E8, wxS("Horicoptic") },
  { 0x03E9, wxS("horicoptic") },
  { 0x03EA, wxS("Gangiacoptic") },
  { 0x03EB, wxS("gangiacoptic") },
  { 0x03EC, wxS("Shimacoptic") },
  { 0x03ED, wxS("shimacoptic") },
  { 0x03EE, wxS("Deicoptic") },
  { 0x03EF, wxS("deicoptic") },
  { 0x03F0, wxS("kappasymbolgreek") },
  { 0x03F1, wxS("rhosymbolgreek") },
  { 0x03F2, wxS("sigmalunatesymbolgreek") },
  { 0x03F3, wxS("yotgreek") },
  { 0x0401, wxS("afii10023") },
  { 0x0402, wxS("afii10051") },
  { 0x0403, wxS("afii10052") },
  { 0x0404, wxS("afii10053") },
  { 0x0405, wxS("afii10054") },
  { 0x0406, wxS("afii10055") },
  { 0x0407, wxS("afii10056") },
  { 0x0408, wxS("afii10057") },
  { 0x0409, wxS("afii10058") },
  { 0x040A, wxS("afii10059") },
  { 0x040B, wxS("afii10060") },
  { 0x040C, wxS("afii10061") },
  { 0x040E, wxS("afii10062") },
  { 0x040F, wxS("afii10145") },
  { 0x0410, wxS("afii10017") },
  { 0x0411, wxS("afii10018") },
  { 0x0412, wxS("afii10019") },
  { 0x0413, wxS("afii10020") },
  { 0x0414, wxS("afii10021") },
  { 0x0415, wxS("afii10022") },
  { 0x0416, wxS("afii10024") },
  { 0x0417, wxS("afii10025") },
  { 0x0418, wxS("afii10026") },
  { 0x0419, wxS("afii10027") },
  { 0x041A, wxS("afii10028") },
  { 0x041B, wxS("afii10029") },
  { 0x041C, wxS("afii10030") },
  { 0x041D, wxS("afii10031") },
  { 0x041E, wxS("afii10032") },
  { 0x041F, wxS("afii10033") },
  { 0x0420, wxS("afii10034") },
  { 0x0421, wxS("afii10035") },
  { 0x0422, wxS("afii10036") },
  { 0x0423, wxS("afii10037") },
  { 0x0424, wxS("afii10038") },
  { 0x0425, wxS("afii10039") },
  { 0x0426, wxS("afii10040") },
  { 0x0427, wxS("afii10041") },
  { 0x0428, wxS("afii10042") },
  { 0x0429, wxS("afii10043") },
  { 0x042A, wxS("afii10044") },
  { 0x042B, wxS("afii10045") },
  { 0x042C, wxS("afii10046") },
  { 0x042D, wxS("afii10047") },
  { 0x042E, wxS("afii10048") },
  { 0x042F, wxS("afii10049") },
  { 0x0430, wxS("afii10065") },
  { 0x0431, wxS("afii10066") },
  { 0x0432, wxS("afii10067") },
  { 0x0433, wxS("afii10068") },
  { 0x0434, wxS("afii10069") },
  { 0x0435, wxS("afii10070") },
  { 0x0436, wxS("afii10072") },
  { 0x0437, wxS("afii10073") },
  { 0x0438, wxS("afii10074") },
  { 0x0439, wxS("afii10075") },
  { 0x043A, wxS("afii10076") },
  { 0x043B, wxS("afii10077") },
  { 0x043C, wxS("afii10078") },
  { 0x043D, wxS("afii10079") },
  { 0x043E, wxS("afii10080") },
  { 0x043F, wxS("afii10081") },
  { 0x0440, wxS("afii10082") },
  { 0x0441, wxS("afii10083") },
  { 0x0442, wxS("afii10084") },
  { 0x0443, wxS("afii10085") },
  { 0x0444, wxS("afii10086") },
  { 0x0445, wxS("afii10087") },
  { 0x0446, wxS("afii10088") },
  { 0x0447, wxS("afii10089") },
  { 0x0448, wxS("afii10090") },
  { 0x0449, wxS("afii10091") },
  { 0x044A, wxS("afii10092") },
  { 0x044B, wxS("afii10093") },
  { 0x044C, wxS("afii10094") },
  { 0x044D, wxS("afii10095") },
  { 0x044E, wxS("afii10096") },
  { 0x044F, wxS("afii10097") },
  { 0x0451, wxS("afii10071") },
  { 0x0452, wxS("afii10099") },
  { 0x0453, wxS("afii10100") },
  { 0x0454, wxS("afii10101") },
  { 0x0455, wxS("afii10102") },
  { 0x0456, wxS("afii10103") },
  { 0x0457, wxS("afii10104") },
  { 0x0458, wxS("afii10105") },
  { 0x0459, wxS("afii10106") },
  { 0x045A, wxS("afii10107") },
  { 0x045B, wxS("afii10108") },
  { 0x045C, wxS("afii10109") },
  { 0x045E, wxS("afii10110") },
  { 0x045F, wxS("afii10193") },
  { 0x0460, wxS("Omegacyrillic") },
  { 0x0461, wxS("omegacyrillic") },
  { 0x0462, wxS("afii10146") },
  { 0x0463, wxS("afii10194") },
  { 0x0464, wxS("Eiotifiedcyrillic") },
  { 0x0465, wxS("eiotifiedcyrillic") },
  { 0x0466, wxS("Yuslittlecyrillic") },
  { 0x0467, wxS("yuslittlecyrillic") },
  { 0x0468, wxS("Yuslittleiotifiedcyrillic") },
  { 0x0469, wxS("yuslittleiotifiedcyrillic") },
  { 0x046A, wxS("Yusbigcyrillic") },
  { 0x046B, wxS("yusbigcyrillic") },
  { 0x046C, wxS("Yusbigiotifiedcyrillic") },
  { 0x046D, wxS("yusbigiotifiedcyrillic") },
  { 0x046E, wxS("Ksicyrillic") },
  { 0x046F, wxS("ksicyrillic") },
  { 0x0470, wxS("Psicyrillic") },
  { 0x0471, wxS("psicyrillic") },
  { 0x0472, wxS("afii10147") },
  { 0x0473, wxS("afii10195") },
  { 0x0474, wxS("afii10148") },
  { 0x0475, wxS("afii10196") },
  { 0x0476, wxS("Izhitsadblgravecyrillic") },
  { 0x0477, wxS("izhitsadblgravecyrillic") },
  { 0x0478, wxS("Ukcyrillic") },
  { 0x0479, wxS("ukcyrillic") },
  { 0x047A, wxS("Omegaroundcyrillic") },
  { 0x047B, wxS("omegaroundcyrillic") },
  { 0x047C, wxS("Omegatitlocyrillic") },
  { 0x047D, wxS("omegatitlocyrillic") },
  { 0x047E, wxS("Otcyrillic") },
  { 0x047F, wxS("otcyrillic") },
  { 0x0480, wxS("Koppacyrillic") },
  { 0x0481, wxS("koppacyrillic") },
  { 0x0482, wxS("thousandcyrillic") },
  { 0x0483, wxS("titlocyrilliccmb") },
  { 0x0484, wxS("palatalizationcyrilliccmb") },
  { 0x0485, wxS("dasiapneumatacyrilliccmb") },
  { 0x0486, wxS("psilipneumatacyrilliccmb") },
  { 0x0490, wxS("afii10050") },
  { 0x0491, wxS("afii10098") },
  { 0x0492, wxS("Ghestrokecyrillic") },
  { 0x0493, wxS("ghestrokecyrillic") },
  { 0x0494, wxS("Ghemiddlehookcyrillic") },
  { 0x0495, wxS("ghemiddlehookcyrillic") },
  { 0x0496, wxS("Zhedescendercyrillic") },
  { 0x0497, wxS("zhedescendercyrillic") },
  { 0x0498, wxS("Zedescendercyrillic") },
  { 0x0499, wxS("zedescendercyrillic") },
  { 0x049A, wxS("Kadescendercyrillic") },
  { 0x049B, wxS("kadescendercyrillic") },
  { 0x049C, wxS("Kaverticalstrokecyrillic") },
  { 0x049D, wxS("kaverticalstrokecyrillic") },
  { 0x049E, wxS("Kastrokecyrillic") },
  { 0x049F, wxS("kastrokecyrillic") },
  { 0x04A0, wxS("Kabashkircyrillic") },
  { 0x04A1, wxS("kabashkircyrillic") },
  { 0x04A2, wxS("Endescendercyrillic") },
  { 0x04A3, wxS("endescendercyrillic") },
  { 0x04A4, wxS("Enghecyrillic") },
  { 0x04A5, wxS("enghecyrillic") },
  { 0x04A6, wxS("Pemiddlehookcyrillic") },
  { 0x04A7, wxS("pemiddlehookcyrillic") },
  { 0x04A8, wxS("Haabkhasiancyrillic") },
  { 0x04A9, wxS("haabkhasiancyrillic") },
  { 0x04AA, wxS("Esdescendercyrillic") },
  { 0x04AB, wxS("esdescendercyrillic") },
  { 0x04AC, wxS("Tedescendercyrillic") },
  { 0x04AD, wxS("tedescendercyrillic") },
  { 0x04AE, wxS("Ustraightcyrillic") },
  { 0x04AF, wxS("ustraightcyrillic") },
  { 0x04B0, wxS("Ustraightstrokecyrillic") },
  { 0x04B1, wxS("ustraightstrokecyrillic") },
  { 0x04B2, wxS("Hadescendercyrillic") },
  { 0x04B3, wxS("hadescendercyrillic") },
  { 0x04B4, wxS("Tetsecyrillic") },
  { 0x04B5, wxS("tetsecyrillic") },
  { 0x04B6, wxS("Chedescendercyrillic") },
  { 0x04B7, wxS("chedescendercyrillic") },
  { 0x04B8, wxS("Cheverticalstrokecyrillic") },
  { 0x04B9, wxS("cheverticalstrokecyrillic") },
  { 0x04BA, wxS("Shhacyrillic") },
  { 0x04BB, wxS("shhacyrillic") },
  { 0x04BC, wxS("Cheabkhasiancyrillic") },
  { 0x04BD, wxS("cheabkhasiancyrillic") },
  { 0x04BE, wxS("Chedescenderabkhasiancyrillic") },
  { 0x04BF, wxS("chedescenderabkhasiancyrillic") },
  { 0x04C0, wxS("palochkacyrillic") },
  { 0x04C1, wxS("Zhebrevecyrillic") },
  { 0x04C2, wxS("zhebrevecyrillic") },
  { 0x04C3, wxS("Kahookcyrillic") },
  { 0x04C4, wxS("kahookcyrillic") },
  { 0x04C7, wxS("Enhookcyrillic") },
  { 0x04C8, wxS("enhookcyrillic") },
  { 0x04CB, wxS("Chekhakassiancyrillic") },
  { 0x04CC, wxS("chekhakassiancyrillic") },
  { 0x04D0, wxS("Abrevecyrillic") },
  { 0x04D1, wxS("abrevecyrillic") },
  { 0x04D2, wxS("Adieresiscyrillic") },
  { 0x04D3, wxS("adieresiscyrillic") },
  { 0x04D4, wxS("Aiecyrillic") },
  { 0x04D5, wxS("aiecyrillic") },
  { 0x04D6, wxS("Iebrevecyrillic") },
  { 0x04D7, wxS("iebrevecyrillic") },
  { 0x04D8, wxS("Schwacyrillic") },
  { 0x04D9, wxS("afii10846") },
  { 0x04DA, wxS("Schwadieresiscyrillic") },
  { 0x04DB, wxS("schwadieresiscyrillic") },
  { 0x04DC, wxS("Zhedieresiscyrillic") },
  { 0x04DD, wxS("zhedieresiscyrillic") },
  { 0x04DE, wxS("Zedieresiscyrillic") },
  { 0x04DF, wxS("zedieresiscyrillic") },
  { 0x04E0, wxS("Dzeabkhasiancyrillic") },
  { 0x04E1, wxS("dzeabkhasiancyrillic") },
  { 0x04E2, wxS("Imacroncyrillic") },
  { 0x04E3, wxS("imacroncyrillic") },
  { 0x04E4, wxS("Idieresiscyrillic") },
  { 0x04E5, wxS("idieresiscyrillic") },
  { 0x04E6, wxS("Odieresiscyrillic") },
  { 0x04E7, wxS("odieresiscyrillic") },
  { 0x04E8, wxS("Obarredcyrillic") },
  { 0x04E9, wxS("obarredcyrillic") },
  { 0x04EA, wxS("Obarreddieresiscyrillic") },
  { 0x04EB, wxS("obarreddieresiscyrillic") },
  { 0x04EE, wxS("Umacroncyrillic") },
  { 0x04EF, wxS("umacroncyrillic") },
  { 0x04F0, wxS("Udieresiscyrillic") },
  { 0x04F1, wxS("udieresiscyrillic") },
  { 0x04F2, wxS("Uhungarumlautcyrillic") },
  { 0x04F3, wxS("uhungarumlautcyrillic") },
  { 0x04F4, wxS("Chedieresiscyrillic") },
  { 0x04F5, wxS("chedieresiscyrillic") },
  { 0x04F8, wxS("Yerudieresiscyrillic") },
  { 0x04F9, wxS("yerudieresiscyrillic") },
  { 0x0531, wxS("Aybarmenian") },
  { 0x0532, wxS("Benarmenian") },
  { 0x0533, wxS("Gimarmenian") },
  { 0x0534, wxS("Daarmenian") },
  { 0x0535, wxS("Echarmenian") },
  { 0x0536, wxS("Zaarmenian") },
  { 0x0537, wxS("Eharmenian") },
  { 0x0538, wxS("Etarmenian") },
  { 0x0539, wxS("Toarmenian") },
  { 0x053A, wxS("Zhearmenian") },
  { 0x053B, wxS("Iniarmenian") },
  { 0x053C, wxS("Liwnarmenian") },
  { 0x053D, wxS("Xeharmenian") },
  { 0x053E, wxS("Caarmenian") },
  { 0x053F, wxS("Kenarmenian") },
  { 0x0540, wxS("Hoarmenian") },
  { 0x0541, wxS("Jaarmenian") },
  { 0x0542, wxS("Ghadarmenian") },
  { 0x0543, wxS("Cheharmenian") },
  { 0x0544, wxS("Menarmenian") },
  { 0x0545, wxS("Yiarmenian") },
  { 0x0546, wxS("Nowarmenian") },
  { 0x0547, wxS("Shaarmenian") },
  { 0x0548, wxS("Voarmenian") },
  { 0x0549, wxS("Chaarmenian") },
  { 0x054A, wxS("Peharmenian") },
  { 0x054B, wxS("Jheharmenian") },
  { 0x054C, wxS("Raarmenian") },
  { 0x054D, wxS("Seharmenian") },
  { 0x054E, wxS("Vewarmenian") },
  { 0x054F, wxS("Tiwnarmenian") },
  { 0x0550, wxS("Reharmenian") },
  { 0x0551, wxS("Coarmenian") },
  { 0x0552, wxS("Yiwnarmenian") },
  { 0x0553, wxS("Piwrarmenian") },
  { 0x0554, wxS("Keharmenian") },
  { 0x0555, wxS("Oharmenian") },
  { 0x0556, wxS("Feharmenian") },
  { 0x0559, wxS("ringhalfleftarmenian") },
  { 0x055A, wxS("apostrophearmenian") },
  { 0x055B, wxS("emphasismarkarmenian") },
  { 0x055C, wxS("exclamarmenian") },
  { 0x055D, wxS("commaarmenian") },
  { 0x055E, wxS("questionarmenian") },
  { 0x055F, wxS("abbreviationmarkarmenian") },
  { 0x0561, wxS("aybarmenian") },
  { 0x0562, wxS("benarmenian") },
  { 0x0563, wxS("gimarmenian") },
  { 0x0564, wxS("daarmenian") },
  { 0x0565, wxS("echarmenian") },
  { 0x0566, wxS("zaarmenian") },
  { 0x0567, wxS("eharmenian") },
  { 0x0568, wxS("etarmenian") },
  { 0x0569, wxS("toarmenian") },
  { 0x056A, wxS("zhearmenian") },
  { 0x056B, wxS("iniarmenian") },
  { 0x056C, wxS("liwnarmenian") },
  { 0x056D, wxS("xeharmenian") },
  { 0x056E, wxS("caarmenian") },
  { 0x056F, wxS("kenarmenian") },
  { 0x0570, wxS("hoarmenian") },
  { 0x0571, wxS("jaarmenian") },
  { 0x0572, wxS("ghadarmenian") },
  { 0x0573, wxS("cheharmenian") },
  { 0x0574, wxS("menarmenian") },
  { 0x0575, wxS("yiarmenian") },
  { 0x0576, wxS("nowarmenian") },
  { 0x0577, wxS("shaarmenian") },
  { 0x0578, wxS("voarmenian") },
  { 0x0579, wxS("chaarmenian") },
  { 0x057A, wxS("peharmenian") },
  { 0x057B, wxS("jheharmenian") },
  { 0x057C, wxS("raarmenian") },
  { 0x057D, wxS("seharmenian") },
  { 0x057E, wxS("vewarmenian") },
  { 0x057F, wxS("tiwnarmenian") },
  { 0x0580, wxS("reharmenian") },
  { 0x0581, wxS("coarmenian") },
  { 0x0582, wxS("yiwnarmenian") },
  { 0x0583, wxS("piwrarmenian") },
  { 0x0584, wxS("keharmenian") },
  { 0x0585, wxS("oharmenian") },
  { 0x0586, wxS("feharmenian") },
  { 0x0587, wxS("echyiwnarmenian") },
  { 0x0589, wxS("periodarmenian") },
  { 0x0591, wxS("etnahtahebrew") },
  { 0x0592, wxS("segoltahebrew") },
  { 0x0593, wxS("shalshelethebrew") },
  { 0x0594, wxS("zaqefqatanhebrew") },
  { 0x0595, wxS("zaqefgadolhebrew") },
  { 0x0596, wxS("tipehahebrew") },
  { 0x0597, wxS("reviahebrew") },
  { 0x0598, wxS("zarqahebrew") },
  { 0x0599, wxS("pashtahebrew") },
  { 0x059A, wxS("yetivhebrew") },
  { 0x059B, wxS("tevirhebrew") },
  { 0x059C, wxS("gereshaccenthebrew") },
  { 0x059D, wxS("gereshmuqdamhebrew") },
  { 0x059E, wxS("gershayimaccenthebrew") },
  { 0x059F, wxS("qarneyparahebrew") },
  { 0x05A0, wxS("telishagedolahebrew") },
  { 0x05A1, wxS("pazerhebrew") },
  { 0x05A3, wxS("munahhebrew") },
  { 0x05A4, wxS("mahapakhhebrew") },
  { 0x05A5, wxS("merkhahebrew") },
  { 0x05A6, wxS("merkhakefulahebrew") },
  { 0x05A7, wxS("dargahebrew") },
  { 0x05A8, wxS("qadmahebrew") },
  { 0x05A9, wxS("telishaqetanahebrew") },
  { 0x05AA, wxS("yerahbenyomohebrew") },
  { 0x05AB, wxS("olehebrew") },
  { 0x05AC, wxS("iluyhebrew") },
  { 0x05AD, wxS("dehihebrew") },
  { 0x05AE, wxS("zinorhebrew") },
  { 0x05AF, wxS("masoracirclehebrew") },
  { 0x05B0, wxS("afii57799") },
  { 0x05B1, wxS("afii57801") },
  { 0x05B2, wxS("afii57800") },
  { 0x05B3, wxS("afii57802") },
  { 0x05B4, wxS("afii57793") },
  { 0x05B5, wxS("afii57794") },
  { 0x05B6, wxS("afii57795") },
  { 0x05B7, wxS("afii57798") },
  { 0x05B8, wxS("afii57797") },
  { 0x05B9, wxS("afii57806") },
  { 0x05BB, wxS("afii57796") },
  { 0x05BC, wxS("afii57807") },
  { 0x05BD, wxS("afii57839") },
  { 0x05BE, wxS("afii57645") },
  { 0x05BF, wxS("afii57841") },
  { 0x05C0, wxS("afii57842") },
  { 0x05C1, wxS("afii57804") },
  { 0x05C2, wxS("afii57803") },
  { 0x05C3, wxS("afii57658") },
  { 0x05C4, wxS("upperdothebrew") },
  { 0x05D0, wxS("afii57664") },
  { 0x05D1, wxS("afii57665") },
  { 0x05D2, wxS("afii57666") },
  { 0x05D3, wxS("afii57667") },
  { 0x05D4, wxS("afii57668") },
  { 0x05D5, wxS("afii57669") },
  { 0x05D6, wxS("afii57670") },
  { 0x05D7, wxS("afii57671") },
  { 0x05D8, wxS("afii57672") },
  { 0x05D9, wxS("afii57673") },
  { 0x05DA, wxS("afii57674") },
  { 0x05DB, wxS("afii57675") },
  { 0x05DC, wxS("afii57676") },
  { 0x05DD, wxS("afii57677") },
  { 0x05DE, wxS("afii57678") },
  { 0x05DF, wxS("afii57679") },
  { 0x05E0, wxS("afii57680") },
  { 0x05E1, wxS("afii57681") },
  { 0x05E2, wxS("afii57682") },
  { 0x05E3, wxS("afii57683") },
  { 0x05E4, wxS("afii57684") },
  { 0x05E5, wxS("afii57685") },
  { 0x05E6, wxS("afii57686") },
  { 0x05E7, wxS("afii57687") },
  { 0x05E8, wxS("afii57688") },
  { 0x05E9, wxS("afii57689") },
  { 0x05EA, wxS("afii57690") },
  { 0x05F0, wxS("afii57716") },
  { 0x05F1, wxS("afii57717") },
  { 0x05F2, wxS("afii57718") },
  { 0x05F3, wxS("gereshhebrew") },
  { 0x05F4, wxS("gershayimhebrew") },
  { 0x060C, wxS("afii57388") },
  { 0x061B, wxS("afii57403") },
  { 0x061F, wxS("afii57407") },
  { 0x0621, wxS("afii57409") },
  { 0x0622, wxS("afii57410") },
  { 0x0623, wxS("afii57411") },
  { 0x0624, wxS("afii57412") },
  { 0x0625, wxS("afii57413") },
  { 0x0626, wxS("afii57414") },
  { 0x0627, wxS("afii57415") },
  { 0x0628, wxS("afii57416") },
  { 0x0629, wxS("afii57417") },
  { 0x062A, wxS("afii57418") },
  { 0x062B, wxS("afii57419") },
  { 0x062C, wxS("afii57420") },
  { 0x062D, wxS("afii57421") },
  { 0x062E, wxS("afii57422") },
  { 0x062F, wxS("afii57423") },
  { 0x0630, wxS("afii57424") },
  { 0x0631, wxS("afii57425") },
  { 0x0632, wxS("afii57426") },
  { 0x0633, wxS("afii57427") },
  { 0x0634, wxS("afii57428") },
  { 0x0635, wxS("afii57429") },
  { 0x0636, wxS("afii57430") },
  { 0x0637, wxS("afii57431") },
  { 0x0638, wxS("afii57432") },
  { 0x0639, wxS("afii57433") },
  { 0x063A, wxS("afii57434") },
  { 0x0640, wxS("afii57440") },
  { 0x0641, wxS("afii57441") },
  { 0x0642, wxS("afii57442") },
  { 0x0643, wxS("afii57443") },
  { 0x0644, wxS("afii57444") },
  { 0x0645, wxS("afii57445") },
  { 0x0646, wxS("afii57446") },
  { 0x0647, wxS("afii57470") },
  { 0x0648, wxS("afii57448") },
  { 0x0649, wxS("afii57449") },
  { 0x064A, wxS("afii57450") },
  { 0x064B, wxS("afii57451") },
  { 0x064C, wxS("afii57452") },
  { 0x064D, wxS("afii57453") },
  { 0x064E, wxS("afii57454") },
  { 0x064F, wxS("afii57455") },
  { 0x0650, wxS("afii57456") },
  { 0x0651, wxS("afii57457") },
  { 0x0652, wxS("afii57458") },
  { 0x0660, wxS("afii57392") },
  { 0x0661, wxS("afii57393") },
  { 0x0662, wxS("afii57394") },
  { 0x0663, wxS("afii57395") },
  { 0x0664, wxS("afii57396") },
  { 0x0665, wxS("afii57397") },
  { 0x0666, wxS("afii57398") },
  { 0x0667, wxS("afii57399") },
  { 0x0668, wxS("afii57400") },
  { 0x0669, wxS("afii57401") },
  { 0x066A, wxS("afii57381") },
  { 0x066B, wxS("decimalseparatorarabic") },
  { 0x066C, wxS("thousandsseparatorarabic") },
  { 0x066D, wxS("afii63167") },
  { 0x0679, wxS("afii57511") },
  { 0x067E, wxS("afii57506") },
  { 0x0686, wxS("afii57507") },
  { 0x0688, wxS("afii57512") },
  { 0x0691, wxS("afii57513") },
  { 0x0698, wxS("afii57508") },
  { 0x06A4, wxS("afii57505") },
  { 0x06AF, wxS("afii57509") },
  { 0x06BA, wxS("afii57514") },
  { 0x06C1, wxS("hehaltonearabic") },
  { 0x06D1, wxS("yehthreedotsbelowarabic") },
  { 0x06D2, wxS("afii57519") },
  { 0x06D5, wxS("afii57534") },
  { 0x06F0, wxS("zeropersian") },
  { 0x06F1, wxS("onepersian") },
  { 0x06F2, wxS("twopersian") },
  { 0x06F3, wxS("threepersian") },
  { 0x06F4, wxS("fourpersian") },
  { 0x06F5, wxS("fivepersian") },
  { 0x06F6, wxS("sixpersian") },
  { 0x06F7, wxS("sevenpersian") },
  { 0x06F8, wxS("eightpersian") },
  { 0x06F9, wxS("ninepersian") },
  { 0x0901, wxS("candrabindudeva") },
  { 0x0902, wxS("anusvaradeva") },
  { 0x0903, wxS("visargadeva") },
  { 0x0905, wxS("adeva") },
  { 0x0906, wxS("aadeva") },
  { 0x0907, wxS("ideva") },
  { 0x0908, wxS("iideva") },
  { 0x0909, wxS("udeva") },
  { 0x090A, wxS("uudeva") },
  { 0x090B, wxS("rvocalicdeva") },
  { 0x090C, wxS("lvocalicdeva") },
  { 0x090D, wxS("ecandradeva") },
  { 0x090E, wxS("eshortdeva") },
  { 0x090F, wxS("edeva") },
  { 0x0910, wxS("aideva") },
  { 0x0911, wxS("ocandradeva") },
  { 0x0912, wxS("oshortdeva") },
  { 0x0913, wxS("odeva") },
  { 0x0914, wxS("audeva") },
  { 0x0915, wxS("kadeva") },
  { 0x0916, wxS("khadeva") },
  { 0x0917, wxS("gadeva") },
  { 0x0918, wxS("ghadeva") },
  { 0x0919, wxS("ngadeva") },
  { 0x091A, wxS("cadeva") },
  { 0x091B, wxS("chadeva") },
  { 0x091C, wxS("jadeva") },
  { 0x091D, wxS("jhadeva") },
  { 0x091E, wxS("nyadeva") },
  { 0x091F, wxS("ttadeva") },
  { 0x0920, wxS("tthadeva") },
  { 0x0921, wxS("ddadeva") },
  { 0x0922, wxS("ddhadeva") },
  { 0x0923, wxS("nnadeva") },
  { 0x0924, wxS("tadeva") },
  { 0x0925, wxS("thadeva") },
  { 0x0926, wxS("dadeva") },
  { 0x0927, wxS("dhadeva") },
  { 0x0928, wxS("nadeva") },
  { 0x0929, wxS("nnnadeva") },
  { 0x092A, wxS("padeva") },
  { 0x092B, wxS("phadeva") },
  { 0x092C, wxS("badeva") },
  { 0x092D, wxS("bhadeva") },
  { 0x092E, wxS("madeva") },
  { 0x092F, wxS("yadeva") },
  { 0x0930, wxS("radeva") },
  { 0x0931, wxS("rradeva") },
  { 0x0932, wxS("ladeva") },
  { 0x0933, wxS("lladeva") },
  { 0x0934, wxS("llladeva") },
  { 0x0935, wxS("vadeva") },
  { 0x0936, wxS("shadeva") },
  { 0x0937, wxS("ssadeva") },
  { 0x0938, wxS("sadeva") },
  { 0x0939, wxS("hadeva") },
  { 0x093C, wxS("nuktadeva") },
  { 0x093D, wxS("avagrahadeva") },
  { 0x093E, wxS("aavowelsigndeva") },
  { 0x093F, wxS("ivowelsigndeva") },
  { 0x0940, wxS("iivowelsigndeva") },
  { 0x0941, wxS("uvowelsigndeva") },
  { 0x0942, wxS("uuvowelsigndeva") },
  { 0x0943, wxS("rvocalicvowelsigndeva") },
  { 0x0944, wxS("rrvocalicvowelsigndeva") },
  { 0x0945, wxS("ecandravowelsigndeva") },
  { 0x0946, wxS("eshortvowelsigndeva") },
  { 0x0947, wxS("evowelsigndeva") },
  { 0x0948, wxS("aivowelsigndeva") },
  { 0x0949, wxS("ocandravowelsigndeva") },
  { 0x094A, wxS("oshortvowelsigndeva") },
  { 0x094B, wxS("ovowelsigndeva") },
  { 0x094C, wxS("auvowelsigndeva") },
  { 0x094D, wxS("viramadeva") },
  { 0x0950, wxS("omdeva") },
  { 0x0951, wxS("udattadeva") },
  { 0x0952, wxS("anudattadeva") },
  { 0x0953, wxS("gravedeva") },
  { 0x0954, wxS("acutedeva") },
  { 0x0958, wxS("qadeva") },
  { 0x0959, wxS("khhadeva") },
  { 0x095A, wxS("ghhadeva") },
  { 0x095B, wxS("zadeva") },
  { 0x095C, wxS("dddhadeva") },
  { 0x095D, wxS("rhadeva") },
  { 0x095E, wxS("fadeva") },
  { 0x095F, wxS("yyadeva") },
  { 0x0960, wxS("rrvocalicdeva") },
  { 0x0961, wxS("llvocalicdeva") },
  { 0x0962, wxS("lvocalicvowelsigndeva") },
  { 0x0963, wxS("llvocalicvowelsigndeva") },
  { 0x0964, wxS("danda") },
  { 0x0965, wxS("dbldanda") },
  { 0x0966, wxS("zerodeva") },
  { 0x0967, wxS("onedeva") },
  { 0x0968, wxS("twodeva") },
  { 0x0969, wxS("threedeva") },
  { 0x096A, wxS("fourdeva") },
  { 0x096B, wxS("fivedeva") },
  { 0x096C, wxS("sixdeva") },
  { 0x096D, wxS("sevendeva") },
  { 0x096E, wxS("eightdeva") },
  { 0x096F, wxS("ninedeva") },
  { 0x0970, wxS("abbreviationsigndeva") },
  { 0x0981, wxS("candrabindubengali") },
  { 0x0982, wxS("anusvarabengali") },
  { 0x0983, wxS("visargabengali") },
  { 0x0985, wxS("abengali") },
  { 0x0986, wxS("aabengali") },
  { 0x0987, wxS("ibengali") },
  { 0x0988, wxS("iibengali") },
  { 0x0989, wxS("ubengali") },
  { 0x098A, wxS("uubengali") },
  { 0x098B, wxS("rvocalicbengali") },
  { 0x098C, wxS("lvocalicbengali") },
  { 0x098F, wxS("ebengali") },
  { 0x0990, wxS("aibengali") },
  { 0x0993, wxS("obengali") },
  { 0x0994, wxS("aubengali") },
  { 0x0995, wxS("kabengali") },
  { 0x0996, wxS("khabengali") },
  { 0x0997, wxS("gabengali") },
  { 0x0998, wxS("ghabengali") },
  { 0x0999, wxS("ngabengali") },
  { 0x099A, wxS("cabengali") },
  { 0x099B, wxS("chabengali") },
  { 0x099C, wxS("jabengali") },
  { 0x099D, wxS("jhabengali") },
  { 0x099E, wxS("nyabengali") },
  { 0x099F, wxS("ttabengali") },
  { 0x09A0, wxS("tthabengali") },
  { 0x09A1, wxS("ddabengali") },
  { 0x09A2, wxS("ddhabengali") },
  { 0x09A3, wxS("nnabengali") },
  { 0x09A4, wxS("tabengali") },
  { 0x09A5, wxS("thabengali") },
  { 0x09A6, wxS("dabengali") },
  { 0x09A7, wxS("dhabengali") },
  { 0x09A8, wxS("nabengali") },
  { 0x09AA, wxS("pabengali") },
  { 0x09AB, wxS("phabengali") },
  { 0x09AC, wxS("babengali") },
  { 0x09AD, wxS("bhabengali") },
  { 0x09AE, wxS("mabengali") },
  { 0x09AF, wxS("yabengali") },
  { 0x09B0, wxS("rabengali") },
  { 0x09B2, wxS("labengali") },
  { 0x09B6, wxS("shabengali") },
  { 0x09B7, wxS("ssabengali") },
  { 0x09B8, wxS("sabengali") },
  { 0x09B9, wxS("habengali") },
  { 0x09BC, wxS("nuktabengali") },
  { 0x09BE, wxS("aavowelsignbengali") },
  { 0x09BF, wxS("ivowelsignbengali") },
  { 0x09C0, wxS("iivowelsignbengali") },
  { 0x09C1, wxS("uvowelsignbengali") },
  { 0x09C2, wxS("uuvowelsignbengali") },
  { 0x09C3, wxS("rvocalicvowelsignbengali") },
  { 0x09C4, wxS("rrvocalicvowelsignbengali") },
  { 0x09C7, wxS("evowelsignbengali") },
  { 0x09C8, wxS("aivowelsignbengali") },
  { 0x09CB, wxS("ovowelsignbengali") },
  { 0x09CC, wxS("auvowelsignbengali") },
  { 0x09CD, wxS("viramabengali") },
  { 0x09D7, wxS("aulengthmarkbengali") },
  { 0x09DC, wxS("rrabengali") },
  { 0x09DD, wxS("rhabengali") },
  { 0x09DF, wxS("yyabengali") },
  { 0x09E0, wxS("rrvocalicbengali") },
  { 0x09E1, wxS("llvocalicbengali") },
  { 0x09E2, wxS("lvocalicvowelsignbengali") },
  { 0x09E3, wxS("llvocalicvowelsignbengali") },
  { 0x09E6, wxS("zerobengali") },
  { 0x09E7, wxS("onebengali") },
  { 0x09E8, wxS("twobengali") },
  { 0x09E9, wxS("threebengali") },
  { 0x09EA, wxS("fourbengali") },
  { 0x09EB, wxS("fivebengali") },
  { 0x09EC, wxS("sixbengali") },
  { 0x09ED, wxS("sevenbengali") },
  { 0x09EE, wxS("eightbengali") },
  { 0x09EF, wxS("ninebengali") },
  { 0x09F0, wxS("ramiddlediagonalbengali") },
  { 0x09F1, wxS("ralowerdiagonalbengali") },
  { 0x09F2, wxS("rupeemarkbengali") },
  { 0x09F3, wxS("rupeesignbengali") },
  { 0x09F4, wxS("onenumeratorbengali") },
  { 0x09F5, wxS("twonumeratorbengali") },
  { 0x09F6, wxS("threenumeratorbengali") },
  { 0x09F7, wxS("fournumeratorbengali") },
  { 0x09F8, wxS("denominatorminusonenumeratorbengali") },
  { 0x09F9, wxS("sixteencurrencydenominatorbengali") },
  { 0x09FA, wxS("issharbengali") },
  { 0x0A02, wxS("bindigurmukhi") },
  { 0x0A05, wxS("agurmukhi") },
  { 0x0A06, wxS("aagurmukhi") },
  { 0x0A07, wxS("igurmukhi") },
  { 0x0A08, wxS("iigurmukhi") },
  { 0x0A09, wxS("ugurmukhi") },
  { 0x0A0A, wxS("uugurmukhi") },
  { 0x0A0F, wxS("eegurmukhi") },
  { 0x0A10, wxS("aigurmukhi") },
  { 0x0A13, wxS("oogurmukhi") },
  { 0x0A14, wxS("augurmukhi") },
  { 0x0A15, wxS("kagurmukhi") },
  { 0x0A16, wxS("khagurmukhi") },
  { 0x0A17, wxS("gagurmukhi") },
  { 0x0A18, wxS("ghagurmukhi") },
  { 0x0A19, wxS("ngagurmukhi") },
  { 0x0A1A, wxS("cagurmukhi") },
  { 0x0A1B, wxS("chagurmukhi") },
  { 0x0A1C, wxS("jagurmukhi") },
  { 0x0A1D, wxS("jhagurmukhi") },
  { 0x0A1E, wxS("nyagurmukhi") },
  { 0x0A1F, wxS("ttagurmukhi") },
  { 0x0A20, wxS("tthagurmukhi") },
  { 0x0A21, wxS("ddagurmukhi") },
  { 0x0A22, wxS("ddhagurmukhi") },
  { 0x0A23, wxS("nnagurmukhi") },
  { 0x0A24, wxS("tagurmukhi") },
  { 0x0A25, wxS("thagurmukhi") },
  { 0x0A26, wxS("dagurmukhi") },
  { 0x0A27, wxS("dhagurmukhi") },
  { 0x0A28, wxS("nagurmukhi") },
  { 0x0A2A, wxS("pagurmukhi") },
  { 0x0A2B, wxS("phagurmukhi") },
  { 0x0A2C, wxS("bagurmukhi") },
  { 0x0A2D, wxS("bhagurmukhi") },
  { 0x0A2E, wxS("magurmukhi") },
  { 0x0A2F, wxS("yagurmukhi") },
  { 0x0A30, wxS("ragurmukhi") },
  { 0x0A32, wxS("lagurmukhi") },
  { 0x0A35, wxS("vagurmukhi") },
  { 0x0A36, wxS("shagurmukhi") },
  { 0x0A38, wxS("sagurmukhi") },
  { 0x0A39, wxS("hagurmukhi") },
  { 0x0A3C, wxS("nuktagurmukhi") },
  { 0x0A3E, wxS("aamatragurmukhi") },
  { 0x0A3F, wxS("imatragurmukhi") },
  { 0x0A40, wxS("iimatragurmukhi") },
  { 0x0A41, wxS("umatragurmukhi") },
  { 0x0A42, wxS("uumatragurmukhi") },
  { 0x0A47, wxS("eematragurmukhi") },
  { 0x0A48, wxS("aimatragurmukhi") },
  { 0x0A4B, wxS("oomatragurmukhi") },
  { 0x0A4C, wxS("aumatragurmukhi") },
  { 0x0A4D, wxS("halantgurmukhi") },
  { 0x0A59, wxS("khhagurmukhi") },
  { 0x0A5A, wxS("ghhagurmukhi") },
  { 0x0A5B, wxS("zagurmukhi") },
  { 0x0A5C, wxS("rragurmukhi") },
  { 0x0A5E, wxS("fagurmukhi") },
  { 0x0A66, wxS("zerogurmukhi") },
  { 0x0A67, wxS("onegurmukhi") },
  { 0x0A68, wxS("twogurmukhi") },
  { 0x0A69, wxS("threegurmukhi") },
  { 0x0A6A, wxS("fourgurmukhi") },
  { 0x0A6B, wxS("fivegurmukhi") },
  { 0x0A6C, wxS("sixgurmukhi") },
  { 0x0A6D, wxS("sevengurmukhi") },
  { 0x0A6E, wxS("eightgurmukhi") },
  { 0x0A6F, wxS("ninegurmukhi") },
  { 0x0A70, wxS("tippigurmukhi") },
  { 0x0A71, wxS("addakgurmukhi") },
  { 0x0A72, wxS("irigurmukhi") },
  { 0x0A73, wxS("uragurmukhi") },
  { 0x0A74, wxS("ekonkargurmukhi") },
  { 0x0A81, wxS("candrabindugujarati") },
  { 0x0A82, wxS("anusvaragujarati") },
  { 0x0A83, wxS("visargagujarati") },
  { 0x0A85, wxS("agujarati") },
  { 0x0A86, wxS("aagujarati") },
  { 0x0A87, wxS("igujarati") },
  { 0x0A88, wxS("iigujarati") },
  { 0x0A89, wxS("ugujarati") },
  { 0x0A8A, wxS("uugujarati") },
  { 0x0A8B, wxS("rvocalicgujarati") },
  { 0x0A8D, wxS("ecandragujarati") },
  { 0x0A8F, wxS("egujarati") },
  { 0x0A90, wxS("aigujarati") },
  { 0x0A91, wxS("ocandragujarati") },
  { 0x0A93, wxS("ogujarati") },
  { 0x0A94, wxS("augujarati") },
  { 0x0A95, wxS("kagujarati") },
  { 0x0A96, wxS("khagujarati") },
  { 0x0A97, wxS("gagujarati") },
  { 0x0A98, wxS("ghagujarati") },
  { 0x0A99, wxS("ngagujarati") },
  { 0x0A9A, wxS("cagujarati") },
  { 0x0A9B, wxS("chagujarati") },
  { 0x0A9C, wxS("jagujarati") },
  { 0x0A9D, wxS("jhagujarati") },
  { 0x0A9E, wxS("nyagujarati") },
  { 0x0A9F, wxS("ttagujarati") },
  { 0x0AA0, wxS("tthagujarati") },
  { 0x0AA1, wxS("ddagujarati") },
  { 0x0AA2, wxS("ddhagujarati") },
  { 0x0AA3, wxS("nnagujarati") },
  { 0x0AA4, wxS("tagujarati") },
  { 0x0AA5, wxS("thagujarati") },
  { 0x0AA6, wxS("dagujarati") },
  { 0x0AA7, wxS("dhagujarati") },
  { 0x0AA8, wxS("nagujarati") },
  { 0x0AAA, wxS("pagujarati") },
  { 0x0AAB, wxS("phagujarati") },
  { 0x0AAC, wxS("bagujarati") },
  { 0x0AAD, wxS("bhagujarati") },
  { 0x0AAE, wxS("magujarati") },
  { 0x0AAF, wxS("yagujarati") },
  { 0x0AB0, wxS("ragujarati") },
  { 0x0AB2, wxS("lagujarati") },
  { 0x0AB3, wxS("llagujarati") },
  { 0x0AB5, wxS("vagujarati") },
  { 0x0AB6, wxS("shagujarati") },
  { 0x0AB7, wxS("ssagujarati") },
  { 0x0AB8, wxS("sagujarati") },
  { 0x0AB9, wxS("hagujarati") },
  { 0x0ABC, wxS("nuktagujarati") },
  { 0x0ABE, wxS("aavowelsigngujarati") },
  { 0x0ABF, wxS("ivowelsigngujarati") },
  { 0x0AC0, wxS("iivowelsigngujarati") },
  { 0x0AC1, wxS("uvowelsigngujarati") },
  { 0x0AC2, wxS("uuvowelsigngujarati") },
  { 0x0AC3, wxS("rvocalicvowelsigngujarati") },
  { 0x0AC4, wxS("rrvocalicvowelsigngujarati") },
  { 0x0AC5, wxS("ecandravowelsigngujarati") },
  { 0x0AC7, wxS("evowelsigngujarati") },
  { 0x0AC8, wxS("aivowelsigngujarati") },
  { 0x0AC9, wxS("ocandravowelsigngujarati") },
  { 0x0ACB, wxS("ovowelsigngujarati") },
  { 0x0ACC, wxS("auvowelsigngujarati") },
  { 0x0ACD, wxS("viramagujarati") },
  { 0x0AD0, wxS("omgujarati") },
  { 0x0AE0, wxS("rrvocalicgujarati") },
  { 0x0AE6, wxS("zerogujarati") },
  { 0x0AE7, wxS("onegujarati") },
  { 0x0AE8, wxS("twogujarati") },
  { 0x0AE9, wxS("threegujarati") },
  { 0x0AEA, wxS("fourgujarati") },
  { 0x0AEB, wxS("fivegujarati") },
  { 0x0AEC, wxS("sixgujarati") },
  { 0x0AED, wxS("sevengujarati") },
  { 0x0AEE, wxS("eightgujarati") },
  { 0x0AEF, wxS("ninegujarati") },
  { 0x0E01, wxS("kokaithai") },
  { 0x0E02, wxS("khokhaithai") },
  { 0x0E03, wxS("khokhuatthai") },
  { 0x0E04, wxS("khokhwaithai") },
  { 0x0E05, wxS("khokhonthai") },
  { 0x0E06, wxS("khorakhangthai") },
  { 0x0E07, wxS("ngonguthai") },
  { 0x0E08, wxS("chochanthai") },
  { 0x0E09, wxS("chochingthai") },
  { 0x0E0A, wxS("chochangthai") },
  { 0x0E0B, wxS("sosothai") },
  { 0x0E0C, wxS("chochoethai") },
  { 0x0E0D, wxS("yoyingthai") },
  { 0x0E0E, wxS("dochadathai") },
  { 0x0E0F, wxS("topatakthai") },
  { 0x0E10, wxS("thothanthai") },
  { 0x0E11, wxS("thonangmonthothai") },
  { 0x0E12, wxS("thophuthaothai") },
  { 0x0E13, wxS("nonenthai") },
  { 0x0E14, wxS("dodekthai") },
  { 0x0E15, wxS("totaothai") },
  { 0x0E16, wxS("thothungthai") },
  { 0x0E17, wxS("thothahanthai") },
  { 0x0E18, wxS("thothongthai") },
  { 0x0E19, wxS("nonuthai") },
  { 0x0E1A, wxS("bobaimaithai") },
  { 0x0E1B, wxS("poplathai") },
  { 0x0E1C, wxS("phophungthai") },
  { 0x0E1D, wxS("fofathai") },
  { 0x0E1E, wxS("phophanthai") },
  { 0x0E1F, wxS("fofanthai") },
  { 0x0E20, wxS("phosamphaothai") },
  { 0x0E21, wxS("momathai") },
  { 0x0E22, wxS("yoyakthai") },
  { 0x0E23, wxS("roruathai") },
  { 0x0E24, wxS("ruthai") },
  { 0x0E25, wxS("lolingthai") },
  { 0x0E26, wxS("luthai") },
  { 0x0E27, wxS("wowaenthai") },
  { 0x0E28, wxS("sosalathai") },
  { 0x0E29, wxS("sorusithai") },
  { 0x0E2A, wxS("sosuathai") },
  { 0x0E2B, wxS("hohipthai") },
  { 0x0E2C, wxS("lochulathai") },
  { 0x0E2D, wxS("oangthai") },
  { 0x0E2E, wxS("honokhukthai") },
  { 0x0E2F, wxS("paiyannoithai") },
  { 0x0E30, wxS("saraathai") },
  { 0x0E31, wxS("maihanakatthai") },
  { 0x0E32, wxS("saraaathai") },
  { 0x0E33, wxS("saraamthai") },
  { 0x0E34, wxS("saraithai") },
  { 0x0E35, wxS("saraiithai") },
  { 0x0E36, wxS("sarauethai") },
  { 0x0E37, wxS("saraueethai") },
  { 0x0E38, wxS("sarauthai") },
  { 0x0E39, wxS("sarauuthai") },
  { 0x0E3A, wxS("phinthuthai") },
  { 0x0E3F, wxS("bahtthai") },
  { 0x0E40, wxS("saraethai") },
  { 0x0E41, wxS("saraaethai") },
  { 0x0E42, wxS("saraothai") },
  { 0x0E43, wxS("saraaimaimuanthai") },
  { 0x0E44, wxS("saraaimaimalaithai") },
  { 0x0E45, wxS("lakkhangyaothai") },
  { 0x0E46, wxS("maiyamokthai") },
  { 0x0E47, wxS("maitaikhuthai") },
  { 0x0E48, wxS("maiekthai") },
  { 0x0E49, wxS("maithothai") },
  { 0x0E4A, wxS("maitrithai") },
  { 0x0E4B, wxS("maichattawathai") },
  { 0x0E4C, wxS("thanthakhatthai") },
  { 0x0E4D, wxS("nikhahitthai") },
  { 0x0E4E, wxS("yamakkanthai") },
  { 0x0E4F, wxS("fongmanthai") },
  { 0x0E50, wxS("zerothai") },
  { 0x0E51, wxS("onethai") },
  { 0x0E52, wxS("twothai") },
  { 0x0E53, wxS("threethai") },
  { 0x0E54, wxS("fourthai") },
  { 0x0E55, wxS("fivethai") },
  { 0x0E56, wxS("sixthai") },
  { 0x0E57, wxS("seventhai") },
  { 0x0E58, wxS("eightthai") },
  { 0x0E59, wxS("ninethai") },
  { 0x0E5A, wxS("angkhankhuthai") },
  { 0x0E5B, wxS("khomutthai") },
  { 0x1E00, wxS("Aringbelow") },
  { 0x1E01, wxS("aringbelow") },
  { 0x1E02, wxS("Bdotaccent") },
  { 0x1E03, wxS("bdotaccent") },
  { 0x1E04, wxS("Bdotbelow") },
  { 0x1E05, wxS("bdotbelow") },
  { 0x1E06, wxS("Blinebelow") },
  { 0x1E07, wxS("blinebelow") },
  { 0x1E08, wxS("Ccedillaacute") },
  { 0x1E09, wxS("ccedillaacute") },
  { 0x1E0A, wxS("Ddotaccent") },
  { 0x1E0B, wxS("ddotaccent") },
  { 0x1E0C, wxS("Ddotbelow") },
  { 0x1E0D, wxS("ddotbelow") },
  { 0x1E0E, wxS("Dlinebelow") },
  { 0x1E0F, wxS("dlinebelow") },
  { 0x1E10, wxS("Dcedilla") },
  { 0x1E11, wxS("dcedilla") },
  { 0x1E12, wxS("Dcircumflexbelow") },
  { 0x1E13, wxS("dcircumflexbelow") },
  { 0x1E14, wxS("Emacrongrave") },
  { 0x1E15, wxS("emacrongrave") },
  { 0x1E16, wxS("Emacronacute") },
  { 0x1E17, wxS("emacronacute") },
  { 0x1E18, wxS("Ecircumflexbelow") },
  { 0x1E19, wxS("ecircumflexbelow") },
  { 0x1E1A, wxS("Etildebelow") },
  { 0x1E1B, wxS("etildebelow") },
  { 0x1E1C, wxS("Ecedillabreve") },
  { 0x1E1D, wxS("ecedillabreve") },
  { 0x1E1E, wxS("Fdotaccent") },
  { 0x1E1F, wxS("fdotaccent") },
  { 0x1E20, wxS("Gmacron") },
  { 0x1E21, wxS("gmacron") },
  { 0x1E22, wxS("Hdotaccent") },
  { 0x1E23, wxS("hdotaccent") },
  { 0x1E24, wxS("Hdotbelow") },
  { 0x1E25, wxS("hdotbelow") },
  { 0x1E26, wxS("Hdieresis") },
  { 0x1E27, wxS("hdieresis") },
  { 0x1E28, wxS("Hcedilla") },
  { 0x1E29, wxS("hcedilla") },
  { 0x1E2A, wxS("Hbrevebelow") },
  { 0x1E2B, wxS("hbrevebelow") },
  { 0x1E2C, wxS("Itildebelow") },
  { 0x1E2D, wxS("itildebelow") },
  { 0x1E2E, wxS("Idieresisacute") },
  { 0x1E2F, wxS("idieresisacute") },
  { 0x1E30, wxS("Kacute") },
  { 0x1E31, wxS("kacute") },
  { 0x1E32, wxS("Kdotbelow") },
  { 0x1E33, wxS("kdotbelow") },
  { 0x1E34, wxS("Klinebelow") },
  { 0x1E35, wxS("klinebelow") },
  { 0x1E36, wxS("Ldotbelow") },
  { 0x1E37, wxS("ldotbelow") },
  { 0x1E38, wxS("Ldotbelowmacron") },
  { 0x1E39, wxS("ldotbelowmacron") },
  { 0x1E3A, wxS("Llinebelow") },
  { 0x1E3B, wxS("llinebelow") },
  { 0x1E3C, wxS("Lcircumflexbelow") },
  { 0x1E3D, wxS("lcircumflexbelow") },
  { 0x1E3E, wxS("Macute") },
  { 0x1E3F, wxS("macute") },
  { 0x1E40, wxS("Mdotaccent") },
  { 0x1E41, wxS("mdotaccent") },
  { 0x1E42, wxS("Mdotbelow") },
  { 0x1E43, wxS("mdotbelow") },
  { 0x1E44, wxS("Ndotaccent") },
  { 0x1E45, wxS("ndotaccent") },
  { 0x1E46, wxS("Ndotbelow") },
  { 0x1E47, wxS("ndotbelow") },
  { 0x1E48, wxS("Nlinebelow") },
  { 0x1E49, wxS("nlinebelow") },
  { 0x1E4A, wxS("Ncircumflexbelow") },
  { 0x1E4B, wxS("ncircumflexbelow") },
  { 0x1E4C, wxS("Otildeacute") },
  { 0x1E4D, wxS("otildeacute") },
  { 0x1E4E, wxS("Otildedieresis") },
  { 0x1E4F, wxS("otildedieresis") },
  { 0x1E50, wxS("Omacrongrave") },
  { 0x1E51, wxS("omacrongrave") },
  { 0x1E52, wxS("Omacronacute") },
  { 0x1E53, wxS("omacronacute") },
  { 0x1E54, wxS("Pacute") },
  { 0x1E55, wxS("pacute") },
  { 0x1E56, wxS("Pdotaccent") },
  { 0x1E57, wxS("pdotaccent") },
  { 0x1E58, wxS("Rdotaccent") },
  { 0x1E59, wxS("rdotaccent") },
  { 0x1E5A, wxS("Rdotbelow") },
  { 0x1E5B, wxS("rdotbelow") },
  { 0x1E5C, wxS("Rdotbelowmacron") },
  { 0x1E5D, wxS("rdotbelowmacron") },
  { 0x1E5E, wxS("Rlinebelow") },
  { 0x1E5F, wxS("rlinebelow") },
  { 0x1E60, wxS("Sdotaccent") },
  { 0x1E61, wxS("sdotaccent") },
  { 0x1E62, wxS("Sdotbelow") },
  { 0x1E63, wxS("sdotbelow") },
  { 0x1E64, wxS("Sacutedotaccent") },
  { 0x1E65, wxS("sacutedotaccent") },
  { 0x1E66, wxS("Scarondotaccent") },
  { 0x1E67, wxS("scarondotaccent") },
  { 0x1E68, wxS("Sdotbelowdotaccent") },
  { 0x1E69, wxS("sdotbelowdotaccent") },
  { 0x1E6A, wxS("Tdotaccent") },
  { 0x1E6B, wxS("tdotaccent") },
  { 0x1E6C, wxS("Tdotbelow") },
  { 0x1E6D, wxS("tdotbelow") },
  { 0x1E6E, wxS("Tlinebelow") },
  { 0x1E6F, wxS("tlinebelow") },
  { 0x1E70, wxS("Tcircumflexbelow") },
  { 0x1E71, wxS("tcircumflexbelow") },
  { 0x1E72, wxS("Udieresisbelow") },
  { 0x1E73, wxS("udieresisbelow") },
  { 0x1E74, wxS("Utildebelow") },
  { 0x1E75, wxS("utildebelow") },
  { 0x1E76, wxS("Ucircumflexbelow") },
  { 0x1E77, wxS("ucircumflexbelow") },
  { 0x1E78, wxS("Utildeacute") },
  { 0x1E79, wxS("utildeacute") },
  { 0x1E7A, wxS("Umacrondieresis") },
  { 0x1E7B, wxS("umacrondieresis") },
  { 0x1E7C, wxS("Vtilde") },
  { 0x1E7D, wxS("vtilde") },
  { 0x1E7E, wxS("Vdotbelow") },
  { 0x1E7F, wxS("vdotbelow") },
  { 0x1E80, wxS("Wgrave") },
  { 0x1E81, wxS("wgrave") },
  { 0x1E82, wxS("Wacute") },
  { 0x1E83, wxS("wacute") },
  { 0x1E84, wxS("Wdieresis") },
  { 0x1E85, wxS("wdieresis") },
  { 0x1E86, wxS("Wdotaccent") },
  { 0x1E87, wxS("wdotaccent") },
  { 0x1E88, wxS("Wdotbelow") },
  { 0x1E89, wxS("wdotbelow") },
  { 0x1E8A, wxS("Xdotaccent") },
  { 0x1E8B, wxS("xdotaccent") },
  { 0x1E8C, wxS("Xdieresis") },
  { 0x1E8D, wxS("xdieresis") },
  { 0x1E8E, wxS("Ydotaccent") },
  { 0x1E8F, wxS("ydotaccent") },
  { 0x1E90, wxS("Zcircumflex") },
  { 0x1E91, wxS("zcircumflex") },
  { 0x1E92, wxS("Zdotbelow") },
  { 0x1E93, wxS("zdotbelow") },
  { 0x1E94, wxS("Zlinebelow") },
  { 0x1E95, wxS("zlinebelow") },
  { 0x1E96, wxS("hlinebelow") },
  { 0x1E97, wxS("tdieresis") },
  { 0x1E98, wxS("wring") },
  { 0x1E99, wxS("yring") },
  { 0x1E9A, wxS("arighthalfring") },
  { 0x1E9B, wxS("slongdotaccent") },
  { 0x1EA0, wxS("Adotbelow") },
  { 0x1EA1, wxS("adotbelow") },
  { 0x1EA2, wxS("Ahookabove") },
  { 0x1EA3, wxS("ahookabove") },
  { 0x1EA4, wxS("Acircumflexacute") },
  { 0x1EA5, wxS("acircumflexacute") },
  { 0x1EA6, wxS("Acircumflexgrave") },
  { 0x1EA7, wxS("acircumflexgrave") },
  { 0x1EA8, wxS("Acircumflexhookabove") },
  { 0x1EA9, wxS("acircumflexhookabove") },
  { 0x1EAA, wxS("Acircumflextilde") },
  { 0x1EAB, wxS("acircumflextilde") },
  { 0x1EAC, wxS("Acircumflexdotbelow") },
  { 0x1EAD, wxS("acircumflexdotbelow") },
  { 0x1EAE, wxS("Abreveacute") },
  { 0x1EAF, wxS("abreveacute") },
  { 0x1EB0, wxS("Abrevegrave") },
  { 0x1EB1, wxS("abrevegrave") },
  { 0x1EB2, wxS("Abrevehookabove") },
  { 0x1EB3, wxS("abrevehookabove") },
  { 0x1EB4, wxS("Abrevetilde") },
  { 0x1EB5, wxS("abrevetilde") },
  { 0x1EB6, wxS("Abrevedotbelow") },
  { 0x1EB7, wxS("abrevedotbelow") },
  { 0x1EB8, wxS("Edotbelow") },
  { 0x1EB9, wxS("edotbelow") },
  { 0x1EBA, wxS("Ehookabove") },
  { 0x1EBB, wxS("ehookabove") },
  { 0x1EBC, wxS("Etilde") },
  { 0x1EBD, wxS("etilde") },
  { 0x1EBE, wxS("Ecircumflexacute") },
  { 0x1EBF, wxS("ecircumflexacute") },
  { 0x1EC0, wxS("Ecircumflexgrave") },
  { 0x1EC1, wxS("ecircumflexgrave") },
  { 0x1EC2, wxS("Ecircumflexhookabove") },
  { 0x1EC3, wxS("ecircumflexhookabove") },
  { 0x1EC4, wxS("Ecircumflextilde") },
  { 0x1EC5, wxS("ecircumflextilde") },
  { 0x1EC6, wxS("Ecircumflexdotbelow") },
  { 0x1EC7, wxS("ecircumflexdotbelow") },
  { 0x1EC8, wxS("Ihookabove") },
  { 0x1EC9, wxS("ihookabove") },
  { 0x1ECA, wxS("Idotbelow") },
  { 0x1ECB, wxS("idotbelow") },
  { 0x1ECC, wxS("Odotbelow") },
  { 0x1ECD, wxS("odotbelow") },
  { 0x1ECE, wxS("Ohookabove") },
  { 0x1ECF, wxS("ohookabove") },
  { 0x1ED0, wxS("Ocircumflexacute") },
  { 0x1ED1, wxS("ocircumflexacute") },
  { 0x1ED2, wxS("Ocircumflexgrave") },
  { 0x1ED3, wxS("ocircumflexgrave") },
  { 0x1ED4, wxS("Ocircumflexhookabove") },
  { 0x1ED5, wxS("ocircumflexhookabove") },
  { 0x1ED6, wxS("Ocircumflextilde") },
  { 0x1ED7, wxS("ocircumflextilde") },
  { 0x1ED8, wxS("Ocircumflexdotbelow") },
  { 0x1ED9, wxS("ocircumflexdotbelow") },
  { 0x1EDA, wxS("Ohornacute") },
  { 0x1EDB, wxS("ohornacute") },
  { 0x1EDC, wxS("Ohorngrave") },
  { 0x1EDD, wxS("ohorngrave") },
  { 0x1EDE, wxS("Ohornhookabove") },
  { 0x1EDF, wxS("ohornhookabove") },
  { 0x1EE0, wxS("Ohorntilde") },
  { 0x1EE1, wxS("ohorntilde") },
  { 0x1EE2, wxS("Ohorndotbelow") },
  { 0x1EE3, wxS("ohorndotbelow") },
  { 0x1EE4, wxS("Udotbelow") },
  { 0x1EE5, wxS("udotbelow") },
  { 0x1EE6, wxS("Uhookabove") },
  { 0x1EE7, wxS("uhookabove") },
  { 0x1EE8, wxS("Uhornacute") },
  { 0x1EE9, wxS("uhornacute") },
  { 0x1EEA, wxS("Uhorngrave") },
  { 0x1EEB, wxS("uhorngrave") },
  { 0x1EEC, wxS("Uhornhookabove") },
  { 0x1EED, wxS("uhornhookabove") },
  { 0x1EEE, wxS("Uhorntilde") },
  { 0x1EEF, wxS("uhorntilde") },
  { 0x1EF0, wxS("Uhorndotbelow") },
  { 0x1EF1, wxS("uhorndotbelow") },
  { 0x1EF2, wxS("Ygrave") },
  { 0x1EF3, wxS("ygrave") },
  { 0x1EF4, wxS("Ydotbelow") },
  { 0x1EF5, wxS("ydotbelow") },
  { 0x1EF6, wxS("Yhookabove") },
  { 0x1EF7, wxS("yhookabove") },
  { 0x1EF8, wxS("Ytilde") },
  { 0x1EF9, wxS("ytilde") },
  { 0x2002, wxS("enspace") },
  { 0x200B, wxS("zerowidthspace") },
  { 0x200C, wxS("afii61664") },
  { 0x200D, wxS("afii301") },
  { 0x200E, wxS("afii299") },
  { 0x200F, wxS("afii300") },
  { 0x2010, wxS("hyphentwo") },
  { 0x2012, wxS("figuredash") },
  { 0x2013, wxS("endash") },
  { 0x2014, wxS("emdash") },
  { 0x2015, wxS("afii00208") },
  { 0x2016, wxS("dblverticalbar") },
  { 0x2017, wxS("underscoredbl") },
  { 0x2018, wxS("quoteleft") },
  { 0x2019, wxS("quoteright") },
  { 0x201A, wxS("quotesinglbase") },
  { 0x201B, wxS("quotereversed") },
  { 0x201C, wxS("quotedblleft") },
  { 0x201D, wxS("quotedblright") },
  { 0x201E, wxS("quotedblbase") },
  { 0x2020, wxS("dagger") },
  { 0x2021, wxS("daggerdbl") },
  { 0x2022, wxS("bullet") },
  { 0x2024, wxS("onedotenleader") },
  { 0x2025, wxS("twodotenleader") },
  { 0x2026, wxS("ellipsis") },
  { 0x202C, wxS("afii61573") },
  { 0x202D, wxS("afii61574") },
  { 0x202E, wxS("afii61575") },
  { 0x2030, wxS("perthousand") },
  { 0x2032, wxS("minute") },
  { 0x2033, wxS("second") },
  { 0x2035, wxS("primereversed") },
  { 0x2039, wxS("guilsinglleft") },
  { 0x203A, wxS("guilsinglright") },
  { 0x203B, wxS("referencemark") },
  { 0x203C, wxS("exclamdbl") },
  { 0x203E, wxS("overline") },
  { 0x2042, wxS("asterism") },
  { 0x2044, wxS("fraction") },
  { 0x2070, wxS("zerosuperior") },
  { 0x2074, wxS("foursuperior") },
  { 0x2075, wxS("fivesuperior") },
  { 0x2076, wxS("sixsuperior") },
  { 0x2077, wxS("sevensuperior") },
  { 0x2078, wxS("eightsuperior") },
  { 0x2079, wxS("ninesuperior") },
  { 0x207A, wxS("plussuperior") },
  { 0x207C, wxS("equalsuperior") },
  { 0x207D, wxS("parenleftsuperior") },
  { 0x207E, wxS("parenrightsuperior") },
  { 0x207F, wxS("nsuperior") },
  { 0x2080, wxS("zeroinferior") },
  { 0x2081, wxS("oneinferior") },
  { 0x2082, wxS("twoinferior") },
  { 0x2083, wxS("threeinferior") },
  { 0x2084, wxS("fourinferior") },
  { 0x2085, wxS("fiveinferior") },
  { 0x2086, wxS("sixinferior") },
  { 0x2087, wxS("seveninferior") },
  { 0x2088, wxS("eightinferior") },
  { 0x2089, wxS("nineinferior") },
  { 0x208D, wxS("parenleftinferior") },
  { 0x208E, wxS("parenrightinferior") },
  { 0x20A1, wxS("colonmonetary") },
  { 0x20A2, wxS("cruzeiro") },
  { 0x20A3, wxS("franc") },
  { 0x20A4, wxS("lira") },
  { 0x20A7, wxS("peseta") },
  { 0x20A9, wxS("won") },
  { 0x20AA, wxS("afii57636") },
  { 0x20AB, wxS("dong") },
  { 0x20AC, wxS("Euro") },
  { 0x2103, wxS("centigrade") },
  { 0x2105, wxS("afii61248") },
  { 0x2109, wxS("fahrenheit") },
  { 0x2111, wxS("Ifraktur") },
  { 0x2113, wxS("afii61289") },
  { 0x2116, wxS("afii61352") },
  { 0x2118, wxS("weierstrass") },
  { 0x211C, wxS("Rfraktur") },
  { 0x211E, wxS("prescription") },
  { 0x2121, wxS("telephone") },
  { 0x2122, wxS("trademark") },
  { 0x2126, wxS("Omega") },
  { 0x212B, wxS("angstrom") },
  { 0x212E, wxS("estimated") },
  { 0x2135, wxS("aleph") },
  { 0x2153, wxS("onethird") },
  { 0x2154, wxS("twothirds") },
  { 0x215B, wxS("oneeighth") },
  { 0x215C, wxS("threeeighths") },
  { 0x215D, wxS("fiveeighths") },
  { 0x215E, wxS("seveneighths") },
  { 0x2160, wxS("Oneroman") },
  { 0x2161, wxS("Tworoman") },
  { 0x2162, wxS("Threeroman") },
  { 0x2163, wxS("Fourroman") },
  { 0x2164, wxS("Fiveroman") },
  { 0x2165, wxS("Sixroman") },
  { 0x2166, wxS("Sevenroman") },
  { 0x2167, wxS("Eightroman") },
  { 0x2168, wxS("Nineroman") },
  { 0x2169, wxS("Tenroman") },
  { 0x216A, wxS("Elevenroman") },
  { 0x216B, wxS("Twelveroman") },
  { 0x2170, wxS("oneroman") },
  { 0x2171, wxS("tworoman") },
  { 0x2172, wxS("threeroman") },
  { 0x2173, wxS("fourroman") },
  { 0x2174, wxS("fiveroman") },
  { 0x2175, wxS("sixroman") },
  { 0x2176, wxS("sevenroman") },
  { 0x2177, wxS("eightroman") },
  { 0x2178, wxS("nineroman") },
  { 0x2179, wxS("tenroman") },
  { 0x217A, wxS("elevenroman") },
  { 0x217B, wxS("twelveroman") },
  { 0x2190, wxS("arrowleft") },
  { 0x2191, wxS("arrowup") },
  { 0x2192, wxS("arrowright") },
  { 0x2193, wxS("arrowdown") },
  { 0x2194, wxS("arrowboth") },
  { 0x2195, wxS("arrowupdn") },
  { 0x2196, wxS("arrowupleft") },
  { 0x2197, wxS("arrowupright") },
  { 0x2198, wxS("arrowdownright") },
  { 0x2199, wxS("arrowdownleft") },
  { 0x21A8, wxS("arrowupdnbse") },
  { 0x21B5, wxS("carriagereturn") },
  { 0x21BC, wxS("harpoonleftbarbup") },
  { 0x21C0, wxS("harpoonrightbarbup") },
  { 0x21C4, wxS("arrowrightoverleft") },
  { 0x21C5, wxS("arrowupleftofdown") },
  { 0x21C6, wxS("arrowleftoverright") },
  { 0x21CD, wxS("arrowleftdblstroke") },
  { 0x21CF, wxS("arrowrightdblstroke") },
  { 0x21D0, wxS("arrowdblleft") },
  { 0x21D1, wxS("arrowdblup") },
  { 0x21D2, wxS("arrowdblright") },
  { 0x21D3, wxS("arrowdbldown") },
  { 0x21D4, wxS("arrowdblboth") },
  { 0x21DE, wxS("pageup") },
  { 0x21DF, wxS("pagedown") },
  { 0x21E0, wxS("arrowdashleft") },
  { 0x21E1, wxS("arrowdashup") },
  { 0x21E2, wxS("arrowdashright") },
  { 0x21E3, wxS("arrowdashdown") },
  { 0x21E4, wxS("arrowtableft") },
  { 0x21E5, wxS("arrowtabright") },
  { 0x21E6, wxS("arrowleftwhite") },
  { 0x21E7, wxS("arrowupwhite") },
  { 0x21E8, wxS("arrowrightwhite") },
  { 0x21E9, wxS("arrowdownwhite") },
  { 0x21EA, wxS("capslock") },
  { 0x2200, wxS("universal") },
  { 0x2202, wxS("partialdiff") },
  { 0x2203, wxS("existential") },
  { 0x2205, wxS("emptyset") },
  { 0x2206, wxS("Delta") },
  { 0x2207, wxS("gradient") },
  { 0x2208, wxS("element") },
  { 0x2209, wxS("notelement") },
  { 0x220B, wxS("suchthat") },
  { 0x220C, wxS("notcontains") },
  { 0x220F, wxS("product") },
  { 0x2211, wxS("summation") },
  { 0x2212, wxS("minus") },
  { 0x2213, wxS("minusplus") },
  { 0x2215, wxS("divisionslash") },
  { 0x2217, wxS("asteriskmath") },
  { 0x2219, wxS("bulletoperator") },
  { 0x221A, wxS("radical") },
  { 0x221D, wxS("proportional") },
  { 0x221E, wxS("infinity") },
  { 0x221F, wxS("orthogonal") },
  { 0x2220, wxS("angle") },
  { 0x2223, wxS("divides") },
  { 0x2225, wxS("parallel") },
  { 0x2226, wxS("notparallel") },
  { 0x2227, wxS("logicaland") },
  { 0x2228, wxS("logicalor") },
  { 0x2229, wxS("intersection") },
  { 0x222A, wxS("union") },
  { 0x222B, wxS("integral") },
  { 0x222C, wxS("dblintegral") },
  { 0x222E, wxS("contourintegral") },
  { 0x2234, wxS("therefore") },
  { 0x2235, wxS("because") },
  { 0x2236, wxS("ratio") },
  { 0x2237, wxS("proportion") },
  { 0x223C, wxS("similar") },
  { 0x223D, wxS("reversedtilde") },
  { 0x2243, wxS("asymptoticallyequal") },
  { 0x2245, wxS("congruent") },
  { 0x2248, wxS("approxequal") },
  { 0x224C, wxS("allequal") },
  { 0x2250, wxS("approaches") },
  { 0x2251, wxS("geometricallyequal") },
  { 0x2252, wxS("approxequalorimage") },
  { 0x2253, wxS("imageorapproximatelyequal") },
  { 0x2260, wxS("notequal") },
  { 0x2261, wxS("equivalence") },
  { 0x2262, wxS("notidentical") },
  { 0x2264, wxS("lessequal") },
  { 0x2265, wxS("greaterequal") },
  { 0x2266, wxS("lessoverequal") },
  { 0x2267, wxS("greateroverequal") },
  { 0x226A, wxS("muchless") },
  { 0x226B, wxS("muchgreater") },
  { 0x226E, wxS("notless") },
  { 0x226F, wxS("notgreater") },
  { 0x2270, wxS("notlessnorequal") },
  { 0x2271, wxS("notgreaternorequal") },
  { 0x2272, wxS("lessorequivalent") },
  { 0x2273, wxS("greaterorequivalent") },
  { 0x2276, wxS("lessorgreater") },
  { 0x2277, wxS("greaterorless") },
  { 0x2279, wxS("notgreaternorless") },
  { 0x227A, wxS("precedes") },
  { 0x227B, wxS("succeeds") },
  { 0x2280, wxS("notprecedes") },
  { 0x2281, wxS("notsucceeds") },
  { 0x2282, wxS("propersubset") },
  { 0x2283, wxS("propersuperset") },
  { 0x2284, wxS("notsubset") },
  { 0x2285, wxS("notsuperset") },
  { 0x2286, wxS("reflexsubset") },
  { 0x2287, wxS("reflexsuperset") },
  { 0x228A, wxS("subsetnotequal") },
  { 0x228B, wxS("supersetnotequal") },
  { 0x2295, wxS("circleplus") },
  { 0x2296, wxS("minuscircle") },
  { 0x2297, wxS("circlemultiply") },
  { 0x2299, wxS("circleot") },
  { 0x22A3, wxS("tackleft") },
  { 0x22A4, wxS("tackdown") },
  { 0x22A5, wxS("perpendicular") },
  { 0x22BF, wxS("righttriangle") },
  { 0x22C5, wxS("dotmath") },
  { 0x22CE, wxS("curlyor") },
  { 0x22CF, wxS("curlyand") },
  { 0x22DA, wxS("lessequalorgreater") },
  { 0x22DB, wxS("greaterequalorless") },
  { 0x22EE, wxS("ellipsisvertical") },
  { 0x2302, wxS("house") },
  { 0x2303, wxS("control") },
  { 0x2305, wxS("projective") },
  { 0x2310, wxS("revlogicalnot") },
  { 0x2312, wxS("arc") },
  { 0x2318, wxS("propellor") },
  { 0x2320, wxS("integraltp") },
  { 0x2321, wxS("integralbt") },
  { 0x2325, wxS("option") },
  { 0x2326, wxS("deleteright") },
  { 0x2327, wxS("clear") },
  { 0x2329, wxS("angleleft") },
  { 0x232A, wxS("angleright") },
  { 0x232B, wxS("deleteleft") },
  { 0x2423, wxS("blank") },
  { 0x2460, wxS("onecircle") },
  { 0x2461, wxS("twocircle") },
  { 0x2462, wxS("threecircle") },
  { 0x2463, wxS("fourcircle") },
  { 0x2464, wxS("fivecircle") },
  { 0x2465, wxS("sixcircle") },
  { 0x2466, wxS("sevencircle") },
  { 0x2467, wxS("eightcircle") },
  { 0x2468, wxS("ninecircle") },
  { 0x2469, wxS("tencircle") },
  { 0x246A, wxS("elevencircle") },
  { 0x246B, wxS("twelvecircle") },
  { 0x246C, wxS("thirteencircle") },
  { 0x246D, wxS("fourteencircle") },
  { 0x246E, wxS("fifteencircle") },
  { 0x246F, wxS("sixteencircle") },
  { 0x2470, wxS("seventeencircle") },
  { 0x2471, wxS("eighteencircle") },
  { 0x2472, wxS("nineteencircle") },
  { 0x2473, wxS("twentycircle") },
  { 0x2474, wxS("oneparen") },
  { 0x2475, wxS("twoparen") },
  { 0x2476, wxS("threeparen") },
  { 0x2477, wxS("fourparen") },
  { 0x2478, wxS("fiveparen") },
  { 0x2479, wxS("sixparen") },
  { 0x247A, wxS("sevenparen") },
  { 0x247B, wxS("eightparen") },
  { 0x247C, wxS("nineparen") },
  { 0x247D, wxS("tenparen") },
  { 0x247E, wxS("elevenparen") },
  { 0x247F, wxS("twelveparen") },
  { 0x2480, wxS("thirteenparen") },
  { 0x2481, wxS("fourteenparen") },
  { 0x2482, wxS("fifteenparen") },
  { 0x2483, wxS("sixteenparen") },
  { 0x2484, wxS("seventeenparen") },
  { 0x2485, wxS("eighteenparen") },
  { 0x2486, wxS("nineteenparen") },
  { 0x2487, wxS("twentyparen") },
  { 0x2488, wxS("oneperiod") },
  { 0x2489, wxS("twoperiod") },
  { 0x248A, wxS("threeperiod") },
  { 0x248B, wxS("fourperiod") },
  { 0x248C, wxS("fiveperiod") },
  { 0x248D, wxS("sixperiod") },
  { 0x248E, wxS("sevenperiod") },
  { 0x248F, wxS("eightperiod") },
  { 0x2490, wxS("nineperiod") },
  { 0x2491, wxS("tenperiod") },
  { 0x2492, wxS("elevenperiod") },
  { 0x2493, wxS("twelveperiod") },
  { 0x2494, wxS("thirteenperiod") },
  { 0x2495, wxS("fourteenperiod") },
  { 0x2496, wxS("fifteenperiod") },
  { 0x2497, wxS("sixteenperiod") },
  { 0x2498, wxS("seventeenperiod") },
  { 0x2499, wxS("eighteenperiod") },
  { 0x249A, wxS("nineteenperiod") },
  { 0x249B, wxS("twentyperiod") },
  { 0x249C, wxS("aparen") },
  { 0x249D, wxS("bparen") },
  { 0x249E, wxS("cparen") },
  { 0x249F, wxS("dparen") },
  { 0x24A0, wxS("eparen") },
  { 0x24A1, wxS("fparen") },
  { 0x24A2, wxS("gparen") },
  { 0x24A3, wxS("hparen") },
  { 0x24A4, wxS("iparen") },
  { 0x24A5, wxS("jparen") },
  { 0x24A6, wxS("kparen") },
  { 0x24A7, wxS("lparen") },
  { 0x24A8, wxS("mparen") },
  { 0x24A9, wxS("nparen") },
  { 0x24AA, wxS("oparen") },
  { 0x24AB, wxS("pparen") },
  { 0x24AC, wxS("qparen") },
  { 0x24AD, wxS("rparen") },
  { 0x24AE, wxS("sparen") },
  { 0x24AF, wxS("tparen") },
  { 0x24B0, wxS("uparen") },
  { 0x24B1, wxS("vparen") },
  { 0x24B2, wxS("wparen") },
  { 0x24B3, wxS("xparen") },
  { 0x24B4, wxS("yparen") },
  { 0x24B5, wxS("zparen") },
  { 0x24B6, wxS("Acircle") },
  { 0x24B7, wxS("Bcircle") },
  { 0x24B8, wxS("Ccircle") },
  { 0x24B9, wxS("Dcircle") },
  { 0x24BA, wxS("Ecircle") },
  { 0x24BB, wxS("Fcircle") },
  { 0x24BC, wxS("Gcircle") },
  { 0x24BD, wxS("Hcircle") },
  { 0x24BE, wxS("Icircle") },
  { 0x24BF, wxS("Jcircle") },
  { 0x24C0, wxS("Kcircle") },
  { 0x24C1, wxS("Lcircle") },
  { 0x24C2, wxS("Mcircle") },
  { 0x24C3, wxS("Ncircle") },
  { 0x24C4, wxS("Ocircle") },
  { 0x24C5, wxS("Pcircle") },
  { 0x24C6, wxS("Qcircle") },
  { 0x24C7, wxS("Rcircle") },
  { 0x24C8, wxS("Scircle") },
  { 0x24C9, wxS("Tcircle") },
  { 0x24CA, wxS("Ucircle") },
  { 0x24CB, wxS("Vcircle") },
  { 0x24CC, wxS("Wcircle") },
  { 0x24CD, wxS("Xcircle") },
  { 0x24CE, wxS("Ycircle") },
  { 0x24CF, wxS("Zcircle") },
  { 0x24D0, wxS("acircle") },
  { 0x24D1, wxS("bcircle") },
  { 0x24D2, wxS("ccircle") },
  { 0x24D3, wxS("dcircle") },
  { 0x24D4, wxS("ecircle") },
  { 0x24D5, wxS("fcircle") },
  { 0x24D6, wxS("gcircle") },
  { 0x24D7, wxS("hcircle") },
  { 0x24D8, wxS("icircle") },
  { 0x24D9, wxS("jcircle") },
  { 0x24DA, wxS("kcircle") },
  { 0x24DB, wxS("lcircle") },
  { 0x24DC, wxS("mcircle") },
  { 0x24DD, wxS("ncircle") },
  { 0x24DE, wxS("ocircle") },
  { 0x24DF, wxS("pcircle") },
  { 0x24E0, wxS("qcircle") },
  { 0x24E1, wxS("rcircle") },
  { 0x24E2, wxS("scircle") },
  { 0x24E3, wxS("tcircle") },
  { 0x24E4, wxS("ucircle") },
  { 0x24E5, wxS("vcircle") },
  { 0x24E6, wxS("wcircle") },
  { 0x24E7, wxS("xcircle") },
  { 0x24E8, wxS("ycircle") },
  { 0x24E9, wxS("zcircle") },
  { 0x2500, wxS("SF100000") },
  { 0x2502, wxS("SF110000") },
  { 0x250C, wxS("SF010000") },
  { 0x2510, wxS("SF030000") },
  { 0x2514, wxS("SF020000") },
  { 0x2518, wxS("SF040000") },
  { 0x251C, wxS("SF080000") },
  { 0x2524, wxS("SF090000") },
  { 0x252C, wxS("SF060000") },
  { 0x2534, wxS("SF070000") },
  { 0x253C, wxS("SF050000") },
  { 0x2550, wxS("SF430000") },
  { 0x2551, wxS("SF240000") },
  { 0x2552, wxS("SF510000") },
  { 0x2553, wxS("SF520000") },
  { 0x2554, wxS("SF390000") },
  { 0x2555, wxS("SF220000") },
  { 0x2556, wxS("SF210000") },
  { 0x2557, wxS("SF250000") },
  { 0x2558, wxS("SF500000") },
  { 0x2559, wxS("SF490000") },
  { 0x255A, wxS("SF380000") },
  { 0x255B, wxS("SF280000") },
  { 0x255C, wxS("SF270000") },
  { 0x255D, wxS("SF260000") },
  { 0x255E, wxS("SF360000") },
  { 0x255F, wxS("SF370000") },
  { 0x2560, wxS("SF420000") },
  { 0x2561, wxS("SF190000") },
  { 0x2562, wxS("SF200000") },
  { 0x2563, wxS("SF230000") },
  { 0x2564, wxS("SF470000") },
  { 0x2565, wxS("SF480000") },
  { 0x2566, wxS("SF410000") },
  { 0x2567, wxS("SF450000") },
  { 0x2568, wxS("SF460000") },
  { 0x2569, wxS("SF400000") },
  { 0x256A, wxS("SF540000") },
  { 0x256B, wxS("SF530000") },
  { 0x256C, wxS("SF440000") },
  { 0x2580, wxS("upblock") },
  { 0x2584, wxS("dnblock") },
  { 0x2588, wxS("block") },
  { 0x258C, wxS("lfblock") },
  { 0x2590, wxS("rtblock") },
  { 0x2591, wxS("ltshade") },
  { 0x2592, wxS("shade") },
  { 0x2593, wxS("dkshade") },
  { 0x25A0, wxS("filledbox") },
  { 0x25A1, wxS("H22073") },
  { 0x25A3, wxS("squarewhitewithsmallblack") },
  { 0x25A4, wxS("squarehorizontalfill") },
  { 0x25A5, wxS("squareverticalfill") },
  { 0x25A6, wxS("squareorthogonalcrosshatchfill") },
  { 0x25A7, wxS("squareupperlefttolowerrightfill") },
  { 0x25A8, wxS("squareupperrighttolowerleftfill") },
  { 0x25A9, wxS("squarediagonalcrosshatchfill") },
  { 0x25AA, wxS("H18543") },
  { 0x25AB, wxS("H18551") },
  { 0x25AC, wxS("filledrect") },
  { 0x25B2, wxS("triagup") },
  { 0x25B3, wxS("whiteuppointingtriangle") },
  { 0x25B4, wxS("blackuppointingsmalltriangle") },
  { 0x25B5, wxS("whiteuppointingsmalltriangle") },
  { 0x25B6, wxS("blackrightpointingtriangle") },
  { 0x25B7, wxS("whiterightpointingtriangle") },
  { 0x25B9, wxS("whiterightpointingsmalltriangle") },
  { 0x25BA, wxS("triagrt") },
  { 0x25BC, wxS("triagdn") },
  { 0x25BD, wxS("whitedownpointingtriangle") },
  { 0x25BF, wxS("whitedownpointingsmalltriangle") },
  { 0x25C0, wxS("blackleftpointingtriangle") },
  { 0x25C1, wxS("whiteleftpointingtriangle") },
  { 0x25C3, wxS("whiteleftpointingsmalltriangle") },
  { 0x25C4, wxS("triaglf") },
  { 0x25C6, wxS("blackdiamond") },
  { 0x25C7, wxS("whitediamond") },
  { 0x25C8, wxS("whitediamondcontainingblacksmalldiamond") },
  { 0x25C9, wxS("fisheye") },
  { 0x25CA, wxS("lozenge") },
  { 0x25CB, wxS("circle") },
  { 0x25CC, wxS("dottedcircle") },
  { 0x25CE, wxS("bullseye") },
  { 0x25CF, wxS("H18533") },
  { 0x25D0, wxS("circlewithlefthalfblack") },
  { 0x25D1, wxS("circlewithrighthalfblack") },
  { 0x25D8, wxS("invbullet") },
  { 0x25D9, wxS("invcircle") },
  { 0x25E2, wxS("blacklowerrighttriangle") },
  { 0x25E3, wxS("blacklowerlefttriangle") },
  { 0x25E4, wxS("blackupperlefttriangle") },
  { 0x25E5, wxS("blackupperrighttriangle") },
  { 0x25E6, wxS("openbullet") },
  { 0x25EF, wxS("largecircle") },
  { 0x2605, wxS("blackstar") },
  { 0x2606, wxS("whitestar") },
  { 0x260E, wxS("telephoneblack") },
  { 0x260F, wxS("whitetelephone") },
  { 0x261C, wxS("pointingindexleftwhite") },
  { 0x261D, wxS("pointingindexupwhite") },
  { 0x261E, wxS("pointingindexrightwhite") },
  { 0x261F, wxS("pointingindexdownwhite") },
  { 0x262F, wxS("yinyang") },
  { 0x263A, wxS("smileface") },
  { 0x263B, wxS("invsmileface") },
  { 0x263C, wxS("sun") },
  { 0x2640, wxS("female") },
  { 0x2641, wxS("earth") },
  { 0x2642, wxS("male") },
  { 0x2660, wxS("spade") },
  { 0x2661, wxS("heartsuitwhite") },
  { 0x2662, wxS("diamondsuitwhite") },
  { 0x2663, wxS("club") },
  { 0x2664, wxS("spadesuitwhite") },
  { 0x2665, wxS("heart") },
  { 0x2666, wxS("diamond") },
  { 0x2667, wxS("clubsuitwhite") },
  { 0x2668, wxS("hotsprings") },
  { 0x2669, wxS("quarternote") },
  { 0x266A, wxS("musicalnote") },
  { 0x266B, wxS("musicalnotedbl") },
  { 0x266C, wxS("beamedsixteenthnotes") },
  { 0x266D, wxS("musicflatsign") },
  { 0x266F, wxS("musicsharpsign") },
  { 0x2713, wxS("checkmark") },
  { 0x278A, wxS("onecircleinversesansserif") },
  { 0x278B, wxS("twocircleinversesansserif") },
  { 0x278C, wxS("threecircleinversesansserif") },
  { 0x278D, wxS("fourcircleinversesansserif") },
  { 0x278E, wxS("fivecircleinversesansserif") },
  { 0x278F, wxS("sixcircleinversesansserif") },
  { 0x2790, wxS("sevencircleinversesansserif") },
  { 0x2791, wxS("eightcircleinversesansserif") },
  { 0x2792, wxS("ninecircleinversesansserif") },
  { 0x279E, wxS("arrowrightheavy") },
  { 0x3000, wxS("ideographicspace") },
  { 0x3001, wxS("ideographiccomma") },
  { 0x3002, wxS("ideographicperiod") },
  { 0x3003, wxS("dittomark") },
  { 0x3004, wxS("jis") },
  { 0x3005, wxS("ideographiciterationmark") },
  { 0x3006, wxS("ideographicclose") },
  { 0x3007, wxS("ideographiczero") },
  { 0x3008, wxS("anglebracketleft") },
  { 0x3009, wxS("anglebracketright") },
  { 0x300A, wxS("dblanglebracketleft") },
  { 0x300B, wxS("dblanglebracketright") },
  { 0x300C, wxS("cornerbracketleft") },
  { 0x300D, wxS("cornerbracketright") },
  { 0x300E, wxS("whitecornerbracketleft") },
  { 0x300F, wxS("whitecornerbracketright") },
  { 0x3010, wxS("blacklenticularbracketleft") },
  { 0x3011, wxS("blacklenticularbracketright") },
  { 0x3012, wxS("postalmark") },
  { 0x3013, wxS("getamark") },
  { 0x3014, wxS("tortoiseshellbracketleft") },
  { 0x3015, wxS("tortoiseshellbracketright") },
  { 0x3016, wxS("whitelenticularbracketleft") },
  { 0x3017, wxS("whitelenticularbracketright") },
  { 0x3018, wxS("whitetortoiseshellbracketleft") },
  { 0x3019, wxS("whitetortoiseshellbracketright") },
  { 0x301C, wxS("wavedash") },
  { 0x301D, wxS("quotedblprimereversed") },
  { 0x301E, wxS("quotedblprime") },
  { 0x3020, wxS("postalmarkface") },
  { 0x3021, wxS("onehangzhou") },
  { 0x3022, wxS("twohangzhou") },
  { 0x3023, wxS("threehangzhou") },
  { 0x3024, wxS("fourhangzhou") },
  { 0x3025, wxS("fivehangzhou") },
  { 0x3026, wxS("sixhangzhou") },
  { 0x3027, wxS("sevenhangzhou") },
  { 0x3028, wxS("eighthangzhou") },
  { 0x3029, wxS("ninehangzhou") },
  { 0x3036, wxS("circlepostalmark") },
  { 0x3041, wxS("asmallhiragana") },
  { 0x3042, wxS("ahiragana") },
  { 0x3043, wxS("ismallhiragana") },
  { 0x3044, wxS("ihiragana") },
  { 0x3045, wxS("usmallhiragana") },
  { 0x3046, wxS("uhiragana") },
  { 0x3047, wxS("esmallhiragana") },
  { 0x3048, wxS("ehiragana") },
  { 0x3049, wxS("osmallhiragana") },
  { 0x304A, wxS("ohiragana") },
  { 0x304B, wxS("kahiragana") },
  { 0x304C, wxS("gahiragana") },
  { 0x304D, wxS("kihiragana") },
  { 0x304E, wxS("gihiragana") },
  { 0x304F, wxS("kuhiragana") },
  { 0x3050, wxS("guhiragana") },
  { 0x3051, wxS("kehiragana") },
  { 0x3052, wxS("gehiragana") },
  { 0x3053, wxS("kohiragana") },
  { 0x3054, wxS("gohiragana") },
  { 0x3055, wxS("sahiragana") },
  { 0x3056, wxS("zahiragana") },
  { 0x3057, wxS("sihiragana") },
  { 0x3058, wxS("zihiragana") },
  { 0x3059, wxS("suhiragana") },
  { 0x305A, wxS("zuhiragana") },
  { 0x305B, wxS("sehiragana") },
  { 0x305C, wxS("zehiragana") },
  { 0x305D, wxS("sohiragana") },
  { 0x305E, wxS("zohiragana") },
  { 0x305F, wxS("tahiragana") },
  { 0x3060, wxS("dahiragana") },
  { 0x3061, wxS("tihiragana") },
  { 0x3062, wxS("dihiragana") },
  { 0x3063, wxS("tusmallhiragana") },
  { 0x3064, wxS("tuhiragana") },
  { 0x3065, wxS("duhiragana") },
  { 0x3066, wxS("tehiragana") },
  { 0x3067, wxS("dehiragana") },
  { 0x3068, wxS("tohiragana") },
  { 0x3069, wxS("dohiragana") },
  { 0x306A, wxS("nahiragana") },
  { 0x306B, wxS("nihiragana") },
  { 0x306C, wxS("nuhiragana") },
  { 0x306D, wxS("nehiragana") },
  { 0x306E, wxS("nohiragana") },
  { 0x306F, wxS("hahiragana") },
  { 0x3070, wxS("bahiragana") },
  { 0x3071, wxS("pahiragana") },
  { 0x3072, wxS("hihiragana") },
  { 0x3073, wxS("bihiragana") },
  { 0x3074, wxS("pihiragana") },
  { 0x3075, wxS("huhiragana") },
  { 0x3076, wxS("buhiragana") },
  { 0x3077, wxS("puhiragana") },
  { 0x3078, wxS("hehiragana") },
  { 0x3079, wxS("behiragana") },
  { 0x307A, wxS("pehiragana") },
  { 0x307B, wxS("hohiragana") },
  { 0x307C, wxS("bohiragana") },
  { 0x307D, wxS("pohiragana") },
  { 0x307E, wxS("mahiragana") },
  { 0x307F, wxS("mihiragana") },
  { 0x3080, wxS("muhiragana") },
  { 0x3081, wxS("mehiragana") },
  { 0x3082, wxS("mohiragana") },
  { 0x3083, wxS("yasmallhiragana") },
  { 0x3084, wxS("yahiragana") },
  { 0x3085, wxS("yusmallhiragana") },
  { 0x3086, wxS("yuhiragana") },
  { 0x3087, wxS("yosmallhiragana") },
  { 0x3088, wxS("yohiragana") },
  { 0x3089, wxS("rahiragana") },
  { 0x308A, wxS("rihiragana") },
  { 0x308B, wxS("ruhiragana") },
  { 0x308C, wxS("rehiragana") },
  { 0x308D, wxS("rohiragana") },
  { 0x308E, wxS("wasmallhiragana") },
  { 0x308F, wxS("wahiragana") },
  { 0x3090, wxS("wihiragana") },
  { 0x3091, wxS("wehiragana") },
  { 0x3092, wxS("wohiragana") },
  { 0x3093, wxS("nhiragana") },
  { 0x3094, wxS("vuhiragana") },
  { 0x309B, wxS("voicedmarkkana") },
  { 0x309C, wxS("semivoicedmarkkana") },
  { 0x309D, wxS("iterationhiragana") },
  { 0x309E, wxS("voicediterationhiragana") },
  { 0x30A1, wxS("asmallkatakana") },
  { 0x30A2, wxS("akatakana") },
  { 0x30A3, wxS("ismallkatakana") },
  { 0x30A4, wxS("ikatakana") },
  { 0x30A5, wxS("usmallkatakana") },
  { 0x30A6, wxS("ukatakana") },
  { 0x30A7, wxS("esmallkatakana") },
  { 0x30A8, wxS("ekatakana") },
  { 0x30A9, wxS("osmallkatakana") },
  { 0x30AA, wxS("okatakana") },
  { 0x30AB, wxS("kakatakana") },
  { 0x30AC, wxS("gakatakana") },
  { 0x30AD, wxS("kikatakana") },
  { 0x30AE, wxS("gikatakana") },
  { 0x30AF, wxS("kukatakana") },
  { 0x30B0, wxS("gukatakana") },
  { 0x30B1, wxS("kekatakana") },
  { 0x30B2, wxS("gekatakana") },
  { 0x30B3, wxS("kokatakana") },
  { 0x30B4, wxS("gokatakana") },
  { 0x30B5, wxS("sakatakana") },
  { 0x30B6, wxS("zakatakana") },
  { 0x30B7, wxS("sikatakana") },
  { 0x30B8, wxS("zikatakana") },
  { 0x30B9, wxS("sukatakana") },
  { 0x30BA, wxS("zukatakana") },
  { 0x30BB, wxS("sekatakana") },
  { 0x30BC, wxS("zekatakana") },
  { 0x30BD, wxS("sokatakana") },
  { 0x30BE, wxS("zokatakana") },
  { 0x30BF, wxS("takatakana") },
  { 0x30C0, wxS("dakatakana") },
  { 0x30C1, wxS("tikatakana") },
  { 0x30C2, wxS("dikatakana") },
  { 0x30C3, wxS("tusmallkatakana") },
  { 0x30C4, wxS("tukatakana") },
  { 0x30C5, wxS("dukatakana") },
  { 0x30C6, wxS("tekatakana") },
  { 0x30C7, wxS("dekatakana") },
  { 0x30C8, wxS("tokatakana") },
  { 0x30C9, wxS("dokatakana") },
  { 0x30CA, wxS("nakatakana") },
  { 0x30CB, wxS("nikatakana") },
  { 0x30CC, wxS("nukatakana") },
  { 0x30CD, wxS("nekatakana") },
  { 0x30CE, wxS("nokatakana") },
  { 0x30CF, wxS("hakatakana") },
  { 0x30D0, wxS("bakatakana") },
  { 0x30D1, wxS("pakatakana") },
  { 0x30D2, wxS("hikatakana") },
  { 0x30D3, wxS("bikatakana") },
  { 0x30D4, wxS("pikatakana") },
  { 0x30D5, wxS("hukatakana") },
  { 0x30D6, wxS("bukatakana") },
  { 0x30D7, wxS("pukatakana") },
  { 0x30D8, wxS("hekatakana") },
  { 0x30D9, wxS("bekatakana") },
  { 0x30DA, wxS("pekatakana") },
  { 0x30DB, wxS("hokatakana") },
  { 0x30DC, wxS("bokatakana") },
  { 0x30DD, wxS("pokatakana") },
  { 0x30DE, wxS("makatakana") },
  { 0x30DF, wxS("mikatakana") },
  { 0x30E0, wxS("mukatakana") },
  { 0x30E1, wxS("mekatakana") },
  { 0x30E2, wxS("mokatakana") },
  { 0x30E3, wxS("yasmallkatakana") },
  { 0x30E4, wxS("yakatakana") },
  { 0x30E5, wxS("yusmallkatakana") },
  { 0x30E6, wxS("yukatakana") },
  { 0x30E7, wxS("yosmallkatakana") },
  { 0x30E8, wxS("yokatakana") },
  { 0x30E9, wxS("rakatakana") },
  { 0x30EA, wxS("rikatakana") },
  { 0x30EB, wxS("rukatakana") },
  { 0x30EC, wxS("rekatakana") },
  { 0x30ED, wxS("rokatakana") },
  { 0x30EE, wxS("wasmallkatakana") },
  { 0x30EF, wxS("wakatakana") },
  { 0x30F0, wxS("wikatakana") },
  { 0x30F1, wxS("wekatakana") },
  { 0x30F2, wxS("wokatakana") },
  { 0x30F3, wxS("nkatakana") },
  { 0x30F4, wxS("vukatakana") },
  { 0x30F5, wxS("kasmallkatakana") },
  { 0x30F6, wxS("kesmallkatakana") },
  { 0x30F7, wxS("vakatakana") },
  { 0x30F8, wxS("vikatakana") },
  { 0x30F9, wxS("vekatakana") },
  { 0x30FA, wxS("vokatakana") },
  { 0x30FB, wxS("dotkatakana") },
  { 0x30FC, wxS("prolongedkana") },
  { 0x30FD, wxS("iterationkatakana") },
  { 0x30FE, wxS("voicediterationkatakana") },
  { 0x3105, wxS("bbopomofo") },
  { 0x3106, wxS("pbopomofo") },
  { 0x3107, wxS("mbopomofo") },
  { 0x3108, wxS("fbopomofo") },
  { 0x3109, wxS("dbopomofo") },
  { 0x310A, wxS("tbopomofo") },
  { 0x310B, wxS("nbopomofo") },
  { 0x310C, wxS("lbopomofo") },
  { 0x310D, wxS("gbopomofo") },
  { 0x310E, wxS("kbopomofo") },
  { 0x310F, wxS("hbopomofo") },
  { 0x3110, wxS("jbopomofo") },
  { 0x3111, wxS("qbopomofo") },
  { 0x3112, wxS("xbopomofo") },
  { 0x3113, wxS("zhbopomofo") },
  { 0x3114, wxS("chbopomofo") },
  { 0x3115, wxS("shbopomofo") },
  { 0x3116, wxS("rbopomofo") },
  { 0x3117, wxS("zbopomofo") },
  { 0x3118, wxS("cbopomofo") },
  { 0x3119, wxS("sbopomofo") },
  { 0x311A, wxS("abopomofo") },
  { 0x311B, wxS("obopomofo") },
  { 0x311C, wxS("ebopomofo") },
  { 0x311D, wxS("ehbopomofo") },
  { 0x311E, wxS("aibopomofo") },
  { 0x311F, wxS("eibopomofo") },
  { 0x3120, wxS("aubopomofo") },
  { 0x3121, wxS("oubopomofo") },
  { 0x3122, wxS("anbopomofo") },
  { 0x3123, wxS("enbopomofo") },
  { 0x3124, wxS("angbopomofo") },
  { 0x3125, wxS("engbopomofo") },
  { 0x3126, wxS("erbopomofo") },
  { 0x3127, wxS("ibopomofo") },
  { 0x3128, wxS("ubopomofo") },
  { 0x3129, wxS("iubopomofo") },
  { 0x3131, wxS("kiyeokkorean") },
  { 0x3132, wxS("ssangkiyeokkorean") },
  { 0x3133, wxS("kiyeoksioskorean") },
  { 0x3134, wxS("nieunkorean") },
  { 0x3135, wxS("nieuncieuckorean") },
  { 0x3136, wxS("nieunhieuhkorean") },
  { 0x3137, wxS("tikeutkorean") },
  { 0x3138, wxS("ssangtikeutkorean") },
  { 0x3139, wxS("rieulkorean") },
  { 0x313A, wxS("rieulkiyeokkorean") },
  { 0x313B, wxS("rieulmieumkorean") },
  { 0x313C, wxS("rieulpieupkorean") },
  { 0x313D, wxS("rieulsioskorean") },
  { 0x313E, wxS("rieulthieuthkorean") },
  { 0x313F, wxS("rieulphieuphkorean") },
  { 0x3140, wxS("rieulhieuhkorean") },
  { 0x3141, wxS("mieumkorean") },
  { 0x3142, wxS("pieupkorean") },
  { 0x3143, wxS("ssangpieupkorean") },
  { 0x3144, wxS("pieupsioskorean") },
  { 0x3145, wxS("sioskorean") },
  { 0x3146, wxS("ssangsioskorean") },
  { 0x3147, wxS("ieungkorean") },
  { 0x3148, wxS("cieuckorean") },
  { 0x3149, wxS("ssangcieuckorean") },
  { 0x314A, wxS("chieuchkorean") },
  { 0x314B, wxS("khieukhkorean") },
  { 0x314C, wxS("thieuthkorean") },
  { 0x314D, wxS("phieuphkorean") },
  { 0x314E, wxS("hieuhkorean") },
  { 0x314F, wxS("akorean") },
  { 0x3150, wxS("aekorean") },
  { 0x3151, wxS("yakorean") },
  { 0x3152, wxS("yaekorean") },
  { 0x3153, wxS("eokorean") },
  { 0x3154, wxS("ekorean") },
  { 0x3155, wxS("yeokorean") },
  { 0x3156, wxS("yekorean") },
  { 0x3157, wxS("okorean") },
  { 0x3158, wxS("wakorean") },
  { 0x3159, wxS("waekorean") },
  { 0x315A, wxS("oekorean") },
  { 0x315B, wxS("yokorean") },
  { 0x315C, wxS("ukorean") },
  { 0x315D, wxS("weokorean") },
  { 0x315E, wxS("wekorean") },
  { 0x315F, wxS("wikorean") },
  { 0x3160, wxS("yukorean") },
  { 0x3161, wxS("eukorean") },
  { 0x3162, wxS("yikorean") },
  { 0x3163, wxS("ikorean") },
  { 0x3164, wxS("hangulfiller") },
  { 0x3165, wxS("ssangnieunkorean") },
  { 0x3166, wxS("nieuntikeutkorean") },
  { 0x3167, wxS("nieunsioskorean") },
  { 0x3168, wxS("nieunpansioskorean") },
  { 0x3169, wxS("rieulkiyeoksioskorean") },
  { 0x316A, wxS("rieultikeutkorean") },
  { 0x316B, wxS("rieulpieupsioskorean") },
  { 0x316C, wxS("rieulpansioskorean") },
  { 0x316D, wxS("rieulyeorinhieuhkorean") },
  { 0x316E, wxS("mieumpieupkorean") },
  { 0x316F, wxS("mieumsioskorean") },
  { 0x3170, wxS("mieumpansioskorean") },
  { 0x3171, wxS("kapyeounmieumkorean") },
  { 0x3172, wxS("pieupkiyeokkorean") },
  { 0x3173, wxS("pieuptikeutkorean") },
  { 0x3174, wxS("pieupsioskiyeokkorean") },
  { 0x3175, wxS("pieupsiostikeutkorean") },
  { 0x3176, wxS("pieupcieuckorean") },
  { 0x3177, wxS("pieupthieuthkorean") },
  { 0x3178, wxS("kapyeounpieupkorean") },
  { 0x3179, wxS("kapyeounssangpieupkorean") },
  { 0x317A, wxS("sioskiyeokkorean") },
  { 0x317B, wxS("siosnieunkorean") },
  { 0x317C, wxS("siostikeutkorean") },
  { 0x317D, wxS("siospieupkorean") },
  { 0x317E, wxS("sioscieuckorean") },
  { 0x317F, wxS("pansioskorean") },
  { 0x3180, wxS("ssangieungkorean") },
  { 0x3181, wxS("yesieungkorean") },
  { 0x3182, wxS("yesieungsioskorean") },
  { 0x3183, wxS("yesieungpansioskorean") },
  { 0x3184, wxS("kapyeounphieuphkorean") },
  { 0x3185, wxS("ssanghieuhkorean") },
  { 0x3186, wxS("yeorinhieuhkorean") },
  { 0x3187, wxS("yoyakorean") },
  { 0x3188, wxS("yoyaekorean") },
  { 0x3189, wxS("yoikorean") },
  { 0x318A, wxS("yuyeokorean") },
  { 0x318B, wxS("yuyekorean") },
  { 0x318C, wxS("yuikorean") },
  { 0x318D, wxS("araeakorean") },
  { 0x318E, wxS("araeaekorean") },
  { 0x3200, wxS("kiyeokparenkorean") },
  { 0x3201, wxS("nieunparenkorean") },
  { 0x3202, wxS("tikeutparenkorean") },
  { 0x3203, wxS("rieulparenkorean") },
  { 0x3204, wxS("mieumparenkorean") },
  { 0x3205, wxS("pieupparenkorean") },
  { 0x3206, wxS("siosparenkorean") },
  { 0x3207, wxS("ieungparenkorean") },
  { 0x3208, wxS("cieucparenkorean") },
  { 0x3209, wxS("chieuchparenkorean") },
  { 0x320A, wxS("khieukhparenkorean") },
  { 0x320B, wxS("thieuthparenkorean") },
  { 0x320C, wxS("phieuphparenkorean") },
  { 0x320D, wxS("hieuhparenkorean") },
  { 0x320E, wxS("kiyeokaparenkorean") },
  { 0x320F, wxS("nieunaparenkorean") },
  { 0x3210, wxS("tikeutaparenkorean") },
  { 0x3211, wxS("rieulaparenkorean") },
  { 0x3212, wxS("mieumaparenkorean") },
  { 0x3213, wxS("pieupaparenkorean") },
  { 0x3214, wxS("siosaparenkorean") },
  { 0x3215, wxS("ieungaparenkorean") },
  { 0x3216, wxS("cieucaparenkorean") },
  { 0x3217, wxS("chieuchaparenkorean") },
  { 0x3218, wxS("khieukhaparenkorean") },
  { 0x3219, wxS("thieuthaparenkorean") },
  { 0x321A, wxS("phieuphaparenkorean") },
  { 0x321B, wxS("hieuhaparenkorean") },
  { 0x321C, wxS("cieucuparenkorean") },
  { 0x3220, wxS("oneideographicparen") },
  { 0x3221, wxS("twoideographicparen") },
  { 0x3222, wxS("threeideographicparen") },
  { 0x3223, wxS("fourideographicparen") },
  { 0x3224, wxS("fiveideographicparen") },
  { 0x3225, wxS("sixideographicparen") },
  { 0x3226, wxS("sevenideographicparen") },
  { 0x3227, wxS("eightideographicparen") },
  { 0x3228, wxS("nineideographicparen") },
  { 0x3229, wxS("tenideographicparen") },
  { 0x322A, wxS("ideographicmoonparen") },
  { 0x322B, wxS("ideographicfireparen") },
  { 0x322C, wxS("ideographicwaterparen") },
  { 0x322D, wxS("ideographicwoodparen") },
  { 0x322E, wxS("ideographicmetalparen") },
  { 0x322F, wxS("ideographicearthparen") },
  { 0x3230, wxS("ideographicsunparen") },
  { 0x3231, wxS("ideographicstockparen") },
  { 0x3232, wxS("ideographichaveparen") },
  { 0x3233, wxS("ideographicsocietyparen") },
  { 0x3234, wxS("ideographicnameparen") },
  { 0x3235, wxS("ideographicspecialparen") },
  { 0x3236, wxS("ideographicfinancialparen") },
  { 0x3237, wxS("ideographiccongratulationparen") },
  { 0x3238, wxS("ideographiclaborparen") },
  { 0x3239, wxS("ideographicrepresentparen") },
  { 0x323A, wxS("ideographiccallparen") },
  { 0x323B, wxS("ideographicstudyparen") },
  { 0x323C, wxS("ideographicsuperviseparen") },
  { 0x323D, wxS("ideographicenterpriseparen") },
  { 0x323E, wxS("ideographicresourceparen") },
  { 0x323F, wxS("ideographicallianceparen") },
  { 0x3240, wxS("ideographicfestivalparen") },
  { 0x3242, wxS("ideographicselfparen") },
  { 0x3243, wxS("ideographicreachparen") },
  { 0x3260, wxS("kiyeokcirclekorean") },
  { 0x3261, wxS("nieuncirclekorean") },
  { 0x3262, wxS("tikeutcirclekorean") },
  { 0x3263, wxS("rieulcirclekorean") },
  { 0x3264, wxS("mieumcirclekorean") },
  { 0x3265, wxS("pieupcirclekorean") },
  { 0x3266, wxS("sioscirclekorean") },
  { 0x3267, wxS("ieungcirclekorean") },
  { 0x3268, wxS("cieuccirclekorean") },
  { 0x3269, wxS("chieuchcirclekorean") },
  { 0x326A, wxS("khieukhcirclekorean") },
  { 0x326B, wxS("thieuthcirclekorean") },
  { 0x326C, wxS("phieuphcirclekorean") },
  { 0x326D, wxS("hieuhcirclekorean") },
  { 0x326E, wxS("kiyeokacirclekorean") },
  { 0x326F, wxS("nieunacirclekorean") },
  { 0x3270, wxS("tikeutacirclekorean") },
  { 0x3271, wxS("rieulacirclekorean") },
  { 0x3272, wxS("mieumacirclekorean") },
  { 0x3273, wxS("pieupacirclekorean") },
  { 0x3274, wxS("siosacirclekorean") },
  { 0x3275, wxS("ieungacirclekorean") },
  { 0x3276, wxS("cieucacirclekorean") },
  { 0x3277, wxS("chieuchacirclekorean") },
  { 0x3278, wxS("khieukhacirclekorean") },
  { 0x3279, wxS("thieuthacirclekorean") },
  { 0x327A, wxS("phieuphacirclekorean") },
  { 0x327B, wxS("hieuhacirclekorean") },
  { 0x327F, wxS("koreanstandardsymbol") },
  { 0x328A, wxS("ideographmooncircle") },
  { 0x328B, wxS("ideographfirecircle") },
  { 0x328C, wxS("ideographwatercircle") },
  { 0x328D, wxS("ideographwoodcircle") },
  { 0x328E, wxS("ideographmetalcircle") },
  { 0x328F, wxS("ideographearthcircle") },
  { 0x3290, wxS("ideographsuncircle") },
  { 0x3294, wxS("ideographnamecircle") },
  { 0x3296, wxS("ideographicfinancialcircle") },
  { 0x3298, wxS("ideographiclaborcircle") },
  { 0x3299, wxS("ideographicsecretcircle") },
  { 0x329D, wxS("ideographicexcellentcircle") },
  { 0x329E, wxS("ideographicprintcircle") },
  { 0x32A3, wxS("ideographiccorrectcircle") },
  { 0x32A4, wxS("ideographichighcircle") },
  { 0x32A5, wxS("ideographiccentrecircle") },
  { 0x32A6, wxS("ideographiclowcircle") },
  { 0x32A7, wxS("ideographicleftcircle") },
  { 0x32A8, wxS("ideographicrightcircle") },
  { 0x32A9, wxS("ideographicmedicinecircle") },
  { 0x3300, wxS("apaatosquare") },
  { 0x3303, wxS("aarusquare") },
  { 0x3305, wxS("intisquare") },
  { 0x330D, wxS("karoriisquare") },
  { 0x3314, wxS("kirosquare") },
  { 0x3315, wxS("kiroguramusquare") },
  { 0x3316, wxS("kiromeetorusquare") },
  { 0x3318, wxS("guramusquare") },
  { 0x331E, wxS("kooposquare") },
  { 0x3322, wxS("sentisquare") },
  { 0x3323, wxS("sentosquare") },
  { 0x3326, wxS("dorusquare") },
  { 0x3327, wxS("tonsquare") },
  { 0x332A, wxS("haitusquare") },
  { 0x332B, wxS("paasentosquare") },
  { 0x3331, wxS("birusquare") },
  { 0x3333, wxS("huiitosquare") },
  { 0x3336, wxS("hekutaarusquare") },
  { 0x3339, wxS("herutusquare") },
  { 0x333B, wxS("peezisquare") },
  { 0x3342, wxS("hoonsquare") },
  { 0x3347, wxS("mansyonsquare") },
  { 0x3349, wxS("mirisquare") },
  { 0x334A, wxS("miribaarusquare") },
  { 0x334D, wxS("meetorusquare") },
  { 0x334E, wxS("yaadosquare") },
  { 0x3351, wxS("rittorusquare") },
  { 0x3357, wxS("wattosquare") },
  { 0x337B, wxS("heiseierasquare") },
  { 0x337C, wxS("syouwaerasquare") },
  { 0x337D, wxS("taisyouerasquare") },
  { 0x337E, wxS("meizierasquare") },
  { 0x337F, wxS("corporationsquare") },
  { 0x3380, wxS("paampssquare") },
  { 0x3381, wxS("nasquare") },
  { 0x3382, wxS("muasquare") },
  { 0x3383, wxS("masquare") },
  { 0x3384, wxS("kasquare") },
  { 0x3385, wxS("KBsquare") },
  { 0x3386, wxS("MBsquare") },
  { 0x3387, wxS("GBsquare") },
  { 0x3388, wxS("calsquare") },
  { 0x3389, wxS("kcalsquare") },
  { 0x338A, wxS("pfsquare") },
  { 0x338B, wxS("nfsquare") },
  { 0x338C, wxS("mufsquare") },
  { 0x338D, wxS("mugsquare") },
  { 0x338E, wxS("squaremg") },
  { 0x338F, wxS("squarekg") },
  { 0x3390, wxS("Hzsquare") },
  { 0x3391, wxS("khzsquare") },
  { 0x3392, wxS("mhzsquare") },
  { 0x3393, wxS("ghzsquare") },
  { 0x3394, wxS("thzsquare") },
  { 0x3395, wxS("mulsquare") },
  { 0x3396, wxS("mlsquare") },
  { 0x3397, wxS("dlsquare") },
  { 0x3398, wxS("klsquare") },
  { 0x3399, wxS("fmsquare") },
  { 0x339A, wxS("nmsquare") },
  { 0x339B, wxS("mumsquare") },
  { 0x339C, wxS("squaremm") },
  { 0x339D, wxS("squarecm") },
  { 0x339E, wxS("squarekm") },
  { 0x339F, wxS("mmsquaredsquare") },
  { 0x33A0, wxS("cmsquaredsquare") },
  { 0x33A1, wxS("squaremsquared") },
  { 0x33A2, wxS("kmsquaredsquare") },
  { 0x33A3, wxS("mmcubedsquare") },
  { 0x33A4, wxS("cmcubedsquare") },
  { 0x33A5, wxS("mcubedsquare") },
  { 0x33A6, wxS("kmcubedsquare") },
  { 0x33A7, wxS("moverssquare") },
  { 0x33A8, wxS("moverssquaredsquare") },
  { 0x33A9, wxS("pasquare") },
  { 0x33AA, wxS("kpasquare") },
  { 0x33AB, wxS("mpasquare") },
  { 0x33AC, wxS("gpasquare") },
  { 0x33AD, wxS("radsquare") },
  { 0x33AE, wxS("radoverssquare") },
  { 0x33AF, wxS("radoverssquaredsquare") },
  { 0x33B0, wxS("pssquare") },
  { 0x33B1, wxS("nssquare") },
  { 0x33B2, wxS("mussquare") },
  { 0x33B3, wxS("mssquare") },
  { 0x33B4, wxS("pvsquare") },
  { 0x33B5, wxS("nvsquare") },
  { 0x33B6, wxS("muvsquare") },
  { 0x33B7, wxS("mvsquare") },
  { 0x33B8, wxS("kvsquare") },
  { 0x33B9, wxS("mvmegasquare") },
  { 0x33BA, wxS("pwsquare") },
  { 0x33BB, wxS("nwsquare") },
  { 0x33BC, wxS("muwsquare") },
  { 0x33BD, wxS("mwsquare") },
  { 0x33BE, wxS("kwsquare") },
  { 0x33BF, wxS("mwmegasquare") },
  { 0x33C0, wxS("kohmsquare") },
  { 0x33C1, wxS("mohmsquare") },
  { 0x33C2, wxS("amsquare") },
  { 0x33C3, wxS("bqsquare") },
  { 0x33C4, wxS("squarecc") },
  { 0x33C5, wxS("cdsquare") },
  { 0x33C6, wxS("coverkgsquare") },
  { 0x33C7, wxS("cosquare") },
  { 0x33C8, wxS("dbsquare") },
  { 0x33C9, wxS("gysquare") },
  { 0x33CA, wxS("hasquare") },
  { 0x33CB, wxS("HPsquare") },
  { 0x33CD, wxS("KKsquare") },
  { 0x33CE, wxS("squarekmcapital") },
  { 0x33CF, wxS("ktsquare") },
  { 0x33D0, wxS("lmsquare") },
  { 0x33D1, wxS("squareln") },
  { 0x33D2, wxS("squarelog") },
  { 0x33D3, wxS("lxsquare") },
  { 0x33D4, wxS("mbsquare") },
  { 0x33D5, wxS("squaremil") },
  { 0x33D6, wxS("molsquare") },
  { 0x33D8, wxS("pmsquare") },
  { 0x33DB, wxS("srsquare") },
  { 0x33DC, wxS("svsquare") },
  { 0x33DD, wxS("wbsquare") },
  { 0x5344, wxS("twentyhangzhou") },
  { 0xF6BE, wxS("dotlessj") },
  { 0xF6BF, wxS("LL") },
  { 0xF6C0, wxS("ll") },
  { 0xF6C1, wxS("Scedilla") },
  { 0xF6C2, wxS("scedilla") },
  { 0xF6C3, wxS("commaaccent") },
  { 0xF6C4, wxS("afii10063") },
  { 0xF6C5, wxS("afii10064") },
  { 0xF6C6, wxS("afii10192") },
  { 0xF6C7, wxS("afii10831") },
  { 0xF6C8, wxS("afii10832") },
  { 0xF6C9, wxS("Acute") },
  { 0xF6CA, wxS("Caron") },
  { 0xF6CB, wxS("Dieresis") },
  { 0xF6CC, wxS("DieresisAcute") },
  { 0xF6CD, wxS("DieresisGrave") },
  { 0xF6CE, wxS("Grave") },
  { 0xF6CF, wxS("Hungarumlaut") },
  { 0xF6D0, wxS("Macron") },
  { 0xF6D1, wxS("cyrBreve") },
  { 0xF6D2, wxS("cyrFlex") },
  { 0xF6D3, wxS("dblGrave") },
  { 0xF6D4, wxS("cyrbreve") },
  { 0xF6D5, wxS("cyrflex") },
  { 0xF6D6, wxS("dblgrave") },
  { 0xF6D7, wxS("dieresisacute") },
  { 0xF6D8, wxS("dieresisgrave") },
  { 0xF6D9, wxS("copyrightserif") },
  { 0xF6DA, wxS("registerserif") },
  { 0xF6DB, wxS("trademarkserif") },
  { 0xF6DC, wxS("onefitted") },
  { 0xF6DD, wxS("rupiah") },
  { 0xF6DE, wxS("threequartersemdash") },
  { 0xF6DF, wxS("centinferior") },
  { 0xF6E0, wxS("centsuperior") },
  { 0xF6E1, wxS("commainferior") },
  { 0xF6E2, wxS("commasuperior") },
  { 0xF6E3, wxS("dollarinferior") },
  { 0xF6E4, wxS("dollarsuperior") },
  { 0xF6E5, wxS("hypheninferior") },
  { 0xF6E6, wxS("hyphensuperior") },
  { 0xF6E7, wxS("periodinferior") },
  { 0xF6E8, wxS("periodsuperior") },
  { 0xF6E9, wxS("asuperior") },
  { 0xF6EA, wxS("bsuperior") },
  { 0xF6EB, wxS("dsuperior") },
  { 0xF6EC, wxS("esuperior") },
  { 0xF6ED, wxS("isuperior") },
  { 0xF6EE, wxS("lsuperior") },
  { 0xF6EF, wxS("msuperior") },
  { 0xF6F0, wxS("osuperior") },
  { 0xF6F1, wxS("rsuperior") },
  { 0xF6F2, wxS("ssuperior") },
  { 0xF6F3, wxS("tsuperior") },
  { 0xF6F4, wxS("Brevesmall") },
  { 0xF6F5, wxS("Caronsmall") },
  { 0xF6F6, wxS("Circumflexsmall") },
  { 0xF6F7, wxS("Dotaccentsmall") },
  { 0xF6F8, wxS("Hungarumlautsmall") },
  { 0xF6F9, wxS("Lslashsmall") },
  { 0xF6FA, wxS("OEsmall") },
  { 0xF6FB, wxS("Ogoneksmall") },
  { 0xF6FC, wxS("Ringsmall") },
  { 0xF6FD, wxS("Scaronsmall") },
  { 0xF6FE, wxS("Tildesmall") },
  { 0xF6FF, wxS("Zcaronsmall") },
  { 0xF721, wxS("exclamsmall") },
  { 0xF724, wxS("dollaroldstyle") },
  { 0xF726, wxS("ampersandsmall") },
  { 0xF730, wxS("zerooldstyle") },
  { 0xF731, wxS("oneoldstyle") },
  { 0xF732, wxS("twooldstyle") },
  { 0xF733, wxS("threeoldstyle") },
  { 0xF734, wxS("fouroldstyle") },
  { 0xF735, wxS("fiveoldstyle") },
  { 0xF736, wxS("sixoldstyle") },
  { 0xF737, wxS("sevenoldstyle") },
  { 0xF738, wxS("eightoldstyle") },
  { 0xF739, wxS("nineoldstyle") },
  { 0xF73F, wxS("questionsmall") },
  { 0xF760, wxS("Gravesmall") },
  { 0xF761, wxS("Asmall") },
  { 0xF762, wxS("Bsmall") },
  { 0xF763, wxS("Csmall") },
  { 0xF764, wxS("Dsmall") },
  { 0xF765, wxS("Esmall") },
  { 0xF766, wxS("Fsmall") },
  { 0xF767, wxS("Gsmall") },
  { 0xF768, wxS("Hsmall") },
  { 0xF769, wxS("Ismall") },
  { 0xF76A, wxS("Jsmall") },
  { 0xF76B, wxS("Ksmall") },
  { 0xF76C, wxS("Lsmall") },
  { 0xF76D, wxS("Msmall") },
  { 0xF76E, wxS("Nsmall") },
  { 0xF76F, wxS("Osmall") },
  { 0xF770, wxS("Psmall") },
  { 0xF771, wxS("Qsmall") },
  { 0xF772, wxS("Rsmall") },
  { 0xF773, wxS("Ssmall") },
  { 0xF774, wxS("Tsmall") },
  { 0xF775, wxS("Usmall") },
  { 0xF776, wxS("Vsmall") },
  { 0xF777, wxS("Wsmall") },
  { 0xF778, wxS("Xsmall") },
  { 0xF779, wxS("Ysmall") },
  { 0xF77A, wxS("Zsmall") },
  { 0xF7A1, wxS("exclamdownsmall") },
  { 0xF7A2, wxS("centoldstyle") },
  { 0xF7A8, wxS("Dieresissmall") },
  { 0xF7AF, wxS("Macronsmall") },
  { 0xF7B4, wxS("Acutesmall") },
  { 0xF7B8, wxS("Cedillasmall") },
  { 0xF7BF, wxS("questiondownsmall") },
  { 0xF7E0, wxS("Agravesmall") },
  { 0xF7E1, wxS("Aacutesmall") },
  { 0xF7E2, wxS("Acircumflexsmall") },
  { 0xF7E3, wxS("Atildesmall") },
  { 0xF7E4, wxS("Adieresissmall") },
  { 0xF7E5, wxS("Aringsmall") },
  { 0xF7E6, wxS("AEsmall") },
  { 0xF7E7, wxS("Ccedillasmall") },
  { 0xF7E8, wxS("Egravesmall") },
  { 0xF7E9, wxS("Eacutesmall") },
  { 0xF7EA, wxS("Ecircumflexsmall") },
  { 0xF7EB, wxS("Edieresissmall") },
  { 0xF7EC, wxS("Igravesmall") },
  { 0xF7ED, wxS("Iacutesmall") },
  { 0xF7EE, wxS("Icircumflexsmall") },
  { 0xF7EF, wxS("Idieresissmall") },
  { 0xF7F0, wxS("Ethsmall") },
  { 0xF7F1, wxS("Ntildesmall") },
  { 0xF7F2, wxS("Ogravesmall") },
  { 0xF7F3, wxS("Oacutesmall") },
  { 0xF7F4, wxS("Ocircumflexsmall") },
  { 0xF7F5, wxS("Otildesmall") },
  { 0xF7F6, wxS("Odieresissmall") },
  { 0xF7F8, wxS("Oslashsmall") },
  { 0xF7F9, wxS("Ugravesmall") },
  { 0xF7FA, wxS("Uacutesmall") },
  { 0xF7FB, wxS("Ucircumflexsmall") },
  { 0xF7FC, wxS("Udieresissmall") },
  { 0xF7FD, wxS("Yacutesmall") },
  { 0xF7FE, wxS("Thornsmall") },
  { 0xF7FF, wxS("Ydieresissmall") },
  { 0xF884, wxS("maihanakatleftthai") },
  { 0xF885, wxS("saraileftthai") },
  { 0xF886, wxS("saraiileftthai") },
  { 0xF887, wxS("saraueleftthai") },
  { 0xF888, wxS("saraueeleftthai") },
  { 0xF889, wxS("maitaikhuleftthai") },
  { 0xF88A, wxS("maiekupperleftthai") },
  { 0xF88B, wxS("maieklowrightthai") },
  { 0xF88C, wxS("maieklowleftthai") },
  { 0xF88D, wxS("maithoupperleftthai") },
  { 0xF88E, wxS("maitholowrightthai") },
  { 0xF88F, wxS("maitholowleftthai") },
  { 0xF890, wxS("maitriupperleftthai") },
  { 0xF891, wxS("maitrilowrightthai") },
  { 0xF892, wxS("maitrilowleftthai") },
  { 0xF893, wxS("maichattawaupperleftthai") },
  { 0xF894, wxS("maichattawalowrightthai") },
  { 0xF895, wxS("maichattawalowleftthai") },
  { 0xF896, wxS("thanthakhatupperleftthai") },
  { 0xF897, wxS("thanthakhatlowrightthai") },
  { 0xF898, wxS("thanthakhatlowleftthai") },
  { 0xF899, wxS("nikhahitleftthai") },
  { 0xF8E5, wxS("radicalex") },
  { 0xF8E6, wxS("arrowvertex") },
  { 0xF8E7, wxS("arrowhorizex") },
  { 0xF8E8, wxS("registersans") },
  { 0xF8E9, wxS("copyrightsans") },
  { 0xF8EA, wxS("trademarksans") },
  { 0xF8EB, wxS("parenlefttp") },
  { 0xF8EC, wxS("parenleftex") },
  { 0xF8ED, wxS("parenleftbt") },
  { 0xF8EE, wxS("bracketlefttp") },
  { 0xF8EF, wxS("bracketleftex") },
  { 0xF8F0, wxS("bracketleftbt") },
  { 0xF8F1, wxS("bracelefttp") },
  { 0xF8F2, wxS("braceleftmid") },
  { 0xF8F3, wxS("braceleftbt") },
  { 0xF8F4, wxS("braceex") },
  { 0xF8F5, wxS("integralex") },
  { 0xF8F6, wxS("parenrighttp") },
  { 0xF8F7, wxS("parenrightex") },
  { 0xF8F8, wxS("parenrightbt") },
  { 0xF8F9, wxS("bracketrighttp") },
  { 0xF8FA, wxS("bracketrightex") },
  { 0xF8FB, wxS("bracketrightbt") },
  { 0xF8FC, wxS("bracerighttp") },
  { 0xF8FD, wxS("bracerightmid") },
  { 0xF8FE, wxS("bracerightbt") },
  { 0xF8FF, wxS("apple") },
  { 0xFB00, wxS("ff") },
  { 0xFB01, wxS("fi") },
  { 0xFB02, wxS("fl") },
  { 0xFB03, wxS("ffi") },
  { 0xFB04, wxS("ffl") },
  { 0xFB1F, wxS("yodyodpatahhebrew") },
  { 0xFB20, wxS("ayinaltonehebrew") },
  { 0xFB2A, wxS("shinshindothebrew") },
  { 0xFB2B, wxS("shinsindothebrew") },
  { 0xFB2C, wxS("shindageshshindothebrew") },
  { 0xFB2D, wxS("shindageshsindothebrew") },
  { 0xFB2E, wxS("alefpatahhebrew") },
  { 0xFB2F, wxS("alefqamatshebrew") },
  { 0xFB30, wxS("alefdageshhebrew") },
  { 0xFB31, wxS("betdageshhebrew") },
  { 0xFB32, wxS("gimeldageshhebrew") },
  { 0xFB33, wxS("daletdageshhebrew") },
  { 0xFB34, wxS("hedageshhebrew") },
  { 0xFB35, wxS("vavdageshhebrew") },
  { 0xFB36, wxS("zayindageshhebrew") },
  { 0xFB38, wxS("tetdageshhebrew") },
  { 0xFB39, wxS("yoddageshhebrew") },
  { 0xFB3A, wxS("finalkafdageshhebrew") },
  { 0xFB3B, wxS("kafdageshhebrew") },
  { 0xFB3C, wxS("lameddageshhebrew") },
  { 0xFB3E, wxS("memdageshhebrew") },
  { 0xFB40, wxS("nundageshhebrew") },
  { 0xFB41, wxS("samekhdageshhebrew") },
  { 0xFB43, wxS("pefinaldageshhebrew") },
  { 0xFB44, wxS("pedageshhebrew") },
  { 0xFB46, wxS("tsadidageshhebrew") },
  { 0xFB47, wxS("qofdageshhebrew") },
  { 0xFB48, wxS("reshdageshhebrew") },
  { 0xFB49, wxS("shindageshhebrew") },
  { 0xFB4A, wxS("tavdageshhebrew") },
  { 0xFB4B, wxS("vavholamhebrew") },
  { 0xFB4C, wxS("betrafehebrew") },
  { 0xFB4D, wxS("kafrafehebrew") },
  { 0xFB4E, wxS("perafehebrew") },
  { 0xFB4F, wxS("aleflamedhebrew") },
  { 0xFB57, wxS("pehfinalarabic") },
  { 0xFB58, wxS("pehinitialarabic") },
  { 0xFB59, wxS("pehmedialarabic") },
  { 0xFB67, wxS("ttehfinalarabic") },
  { 0xFB68, wxS("ttehinitialarabic") },
  { 0xFB69, wxS("ttehmedialarabic") },
  { 0xFB6B, wxS("vehfinalarabic") },
  { 0xFB6C, wxS("vehinitialarabic") },
  { 0xFB6D, wxS("vehmedialarabic") },
  { 0xFB7B, wxS("tchehfinalarabic") },
  { 0xFB7C, wxS("tchehinitialarabic") },
  { 0xFB7D, wxS("tchehmedialarabic") },
  { 0xFB89, wxS("ddalfinalarabic") },
  { 0xFB8B, wxS("jehfinalarabic") },
  { 0xFB8D, wxS("rrehfinalarabic") },
  { 0xFB93, wxS("gaffinalarabic") },
  { 0xFB94, wxS("gafinitialarabic") },
  { 0xFB95, wxS("gafmedialarabic") },
  { 0xFB9F, wxS("noonghunnafinalarabic") },
  { 0xFBA4, wxS("hehhamzaaboveisolatedarabic") },
  { 0xFBA5, wxS("hehhamzaabovefinalarabic") },
  { 0xFBA7, wxS("hehfinalaltonearabic") },
  { 0xFBA8, wxS("hehinitialaltonearabic") },
  { 0xFBA9, wxS("hehmedialaltonearabic") },
  { 0xFBAF, wxS("yehbarreefinalarabic") },
  { 0xFC08, wxS("behmeemisolatedarabic") },
  { 0xFC0B, wxS("tehjeemisolatedarabic") },
  { 0xFC0C, wxS("tehhahisolatedarabic") },
  { 0xFC0E, wxS("tehmeemisolatedarabic") },
  { 0xFC48, wxS("meemmeemisolatedarabic") },
  { 0xFC4B, wxS("noonjeemisolatedarabic") },
  { 0xFC4E, wxS("noonmeemisolatedarabic") },
  { 0xFC58, wxS("yehmeemisolatedarabic") },
  { 0xFC5E, wxS("shaddadammatanarabic") },
  { 0xFC5F, wxS("shaddakasratanarabic") },
  { 0xFC60, wxS("shaddafathaarabic") },
  { 0xFC61, wxS("shaddadammaarabic") },
  { 0xFC62, wxS("shaddakasraarabic") },
  { 0xFC6D, wxS("behnoonfinalarabic") },
  { 0xFC73, wxS("tehnoonfinalarabic") },
  { 0xFC8D, wxS("noonnoonfinalarabic") },
  { 0xFC94, wxS("yehnoonfinalarabic") },
  { 0xFC9F, wxS("behmeeminitialarabic") },
  { 0xFCA1, wxS("tehjeeminitialarabic") },
  { 0xFCA2, wxS("tehhahinitialarabic") },
  { 0xFCA4, wxS("tehmeeminitialarabic") },
  { 0xFCC9, wxS("lamjeeminitialarabic") },
  { 0xFCCA, wxS("lamhahinitialarabic") },
  { 0xFCCB, wxS("lamkhahinitialarabic") },
  { 0xFCCC, wxS("lammeeminitialarabic") },
  { 0xFCD1, wxS("meemmeeminitialarabic") },
  { 0xFCD2, wxS("noonjeeminitialarabic") },
  { 0xFCD5, wxS("noonmeeminitialarabic") },
  { 0xFCDD, wxS("yehmeeminitialarabic") },
  { 0xFD3E, wxS("parenleftaltonearabic") },
  { 0xFD3F, wxS("parenrightaltonearabic") },
  { 0xFD88, wxS("lammeemhahinitialarabic") },
  { 0xFDF2, wxS("lamlamhehisolatedarabic") },
  { 0xFDFA, wxS("sallallahoualayhewasallamarabic") },
  { 0xFE30, wxS("twodotleadervertical") },
  { 0xFE31, wxS("emdashvertical") },
  { 0xFE32, wxS("endashvertical") },
  { 0xFE33, wxS("underscorevertical") },
  { 0xFE34, wxS("wavyunderscorevertical") },
  { 0xFE35, wxS("parenleftvertical") },
  { 0xFE36, wxS("parenrightvertical") },
  { 0xFE37, wxS("braceleftvertical") },
  { 0xFE38, wxS("bracerightvertical") },
  { 0xFE39, wxS("tortoiseshellbracketleftvertical") },
  { 0xFE3A, wxS("tortoiseshellbracketrightvertical") },
  { 0xFE3B, wxS("blacklenticularbracketleftvertical") },
  { 0xFE3C, wxS("blacklenticularbracketrightvertical") },
  { 0xFE3D, wxS("dblanglebracketleftvertical") },
  { 0xFE3E, wxS("dblanglebracketrightvertical") },
  { 0xFE3F, wxS("anglebracketleftvertical") },
  { 0xFE40, wxS("anglebracketrightvertical") },
  { 0xFE41, wxS("cornerbracketleftvertical") },
  { 0xFE42, wxS("cornerbracketrightvertical") },
  { 0xFE43, wxS("whitecornerbracketleftvertical") },
  { 0xFE44, wxS("whitecornerbracketrightvertical") },
  { 0xFE49, wxS("overlinedashed") },
  { 0xFE4A, wxS("overlinecenterline") },
  { 0xFE4B, wxS("overlinewavy") },
  { 0xFE4C, wxS("overlinedblwavy") },
  { 0xFE4D, wxS("lowlinedashed") },
  { 0xFE4E, wxS("lowlinecenterline") },
  { 0xFE4F, wxS("underscorewavy") },
  { 0xFE50, wxS("commasmall") },
  { 0xFE52, wxS("periodsmall") },
  { 0xFE54, wxS("semicolonsmall") },
  { 0xFE55, wxS("colonsmall") },
  { 0xFE59, wxS("parenleftsmall") },
  { 0xFE5A, wxS("parenrightsmall") },
  { 0xFE5B, wxS("braceleftsmall") },
  { 0xFE5C, wxS("bracerightsmall") },
  { 0xFE5D, wxS("tortoiseshellbracketleftsmall") },
  { 0xFE5E, wxS("tortoiseshellbracketrightsmall") },
  { 0xFE5F, wxS("numbersignsmall") },
  { 0xFE61, wxS("asterisksmall") },
  { 0xFE62, wxS("plussmall") },
  { 0xFE63, wxS("hyphensmall") },
  { 0xFE64, wxS("lesssmall") },
  { 0xFE65, wxS("greatersmall") },
  { 0xFE66, wxS("equalsmall") },
  { 0xFE69, wxS("dollarsmall") },
  { 0xFE6A, wxS("percentsmall") },
  { 0xFE6B, wxS("atsmall") },
  { 0xFE82, wxS("alefmaddaabovefinalarabic") },
  { 0xFE84, wxS("alefhamzaabovefinalarabic") },
  { 0xFE86, wxS("wawhamzaabovefinalarabic") },
  { 0xFE88, wxS("alefhamzabelowfinalarabic") },
  { 0xFE8A, wxS("yehhamzaabovefinalarabic") },
  { 0xFE8B, wxS("yehhamzaaboveinitialarabic") },
  { 0xFE8C, wxS("yehhamzaabovemedialarabic") },
  { 0xFE8E, wxS("aleffinalarabic") },
  { 0xFE90, wxS("behfinalarabic") },
  { 0xFE91, wxS("behinitialarabic") },
  { 0xFE92, wxS("behmedialarabic") },
  { 0xFE94, wxS("tehmarbutafinalarabic") },
  { 0xFE96, wxS("tehfinalarabic") },
  { 0xFE97, wxS("tehinitialarabic") },
  { 0xFE98, wxS("tehmedialarabic") },
  { 0xFE9A, wxS("thehfinalarabic") },
  { 0xFE9B, wxS("thehinitialarabic") },
  { 0xFE9C, wxS("thehmedialarabic") },
  { 0xFE9E, wxS("jeemfinalarabic") },
  { 0xFE9F, wxS("jeeminitialarabic") },
  { 0xFEA0, wxS("jeemmedialarabic") },
  { 0xFEA2, wxS("hahfinalarabic") },
  { 0xFEA3, wxS("hahinitialarabic") },
  { 0xFEA4, wxS("hahmedialarabic") },
  { 0xFEA6, wxS("khahfinalarabic") },
  { 0xFEA7, wxS("khahinitialarabic") },
  { 0xFEA8, wxS("khahmedialarabic") },
  { 0xFEAA, wxS("dalfinalarabic") },
  { 0xFEAC, wxS("thalfinalarabic") },
  { 0xFEAE, wxS("rehfinalarabic") },
  { 0xFEB0, wxS("zainfinalarabic") },
  { 0xFEB2, wxS("seenfinalarabic") },
  { 0xFEB3, wxS("seeninitialarabic") },
  { 0xFEB4, wxS("seenmedialarabic") },
  { 0xFEB6, wxS("sheenfinalarabic") },
  { 0xFEB7, wxS("sheeninitialarabic") },
  { 0xFEB8, wxS("sheenmedialarabic") },
  { 0xFEBA, wxS("sadfinalarabic") },
  { 0xFEBB, wxS("sadinitialarabic") },
  { 0xFEBC, wxS("sadmedialarabic") },
  { 0xFEBE, wxS("dadfinalarabic") },
  { 0xFEBF, wxS("dadinitialarabic") },
  { 0xFEC0, wxS("dadmedialarabic") },
  { 0xFEC2, wxS("tahfinalarabic") },
  { 0xFEC3, wxS("tahinitialarabic") },
  { 0xFEC4, wxS("tahmedialarabic") },
  { 0xFEC6, wxS("zahfinalarabic") },
  { 0xFEC7, wxS("zahinitialarabic") },
  { 0xFEC8, wxS("zahmedialarabic") },
  { 0xFECA, wxS("ainfinalarabic") },
  { 0xFECB, wxS("aininitialarabic") },
  { 0xFECC, wxS("ainmedialarabic") },
  { 0xFECE, wxS("ghainfinalarabic") },
  { 0xFECF, wxS("ghaininitialarabic") },
  { 0xFED0, wxS("ghainmedialarabic") },
  { 0xFED2, wxS("fehfinalarabic") },
  { 0xFED3, wxS("fehinitialarabic") },
  { 0xFED4, wxS("fehmedialarabic") },
  { 0xFED6, wxS("qaffinalarabic") },
  { 0xFED7, wxS("qafinitialarabic") },
  { 0xFED8, wxS("qafmedialarabic") },
  { 0xFEDA, wxS("kaffinalarabic") },
  { 0xFEDB, wxS("kafinitialarabic") },
  { 0xFEDC, wxS("kafmedialarabic") },
  { 0xFEDE, wxS("lamfinalarabic") },
  { 0xFEDF, wxS("laminitialarabic") },
  { 0xFEE0, wxS("lammedialarabic") },
  { 0xFEE2, wxS("meemfinalarabic") },
  { 0xFEE3, wxS("meeminitialarabic") },
  { 0xFEE4, wxS("meemmedialarabic") },
  { 0xFEE6, wxS("noonfinalarabic") },
  { 0xFEE7, wxS("nooninitialarabic") },
  { 0xFEE8, wxS("noonmedialarabic") },
  { 0xFEEA, wxS("hehfinalarabic") },
  { 0xFEEB, wxS("hehinitialarabic") },
  { 0xFEEC, wxS("hehmedialarabic") },
  { 0xFEEE, wxS("wawfinalarabic") },
  { 0xFEF0, wxS("alefmaksurafinalarabic") },
  { 0xFEF2, wxS("yehfinalarabic") },
  { 0xFEF3, wxS("yehinitialarabic") },
  { 0xFEF4, wxS("yehmedialarabic") },
  { 0xFEF5, wxS("lamalefmaddaaboveisolatedarabic") },
  { 0xFEF6, wxS("lamalefmaddaabovefinalarabic") },
  { 0xFEF7, wxS("lamalefhamzaaboveisolatedarabic") },
  { 0xFEF8, wxS("lamalefhamzaabovefinalarabic") },
  { 0xFEF9, wxS("lamalefhamzabelowisolatedarabic") },
  { 0xFEFA, wxS("lamalefhamzabelowfinalarabic") },
  { 0xFEFB, wxS("lamalefisolatedarabic") },
  { 0xFEFC, wxS("lamaleffinalarabic") },
  { 0xFEFF, wxS("zerowidthjoiner") },
  { 0xFF01, wxS("exclammonospace") },
  { 0xFF02, wxS("quotedblmonospace") },
  { 0xFF03, wxS("numbersignmonospace") },
  { 0xFF04, wxS("dollarmonospace") },
  { 0xFF05, wxS("percentmonospace") },
  { 0xFF06, wxS("ampersandmonospace") },
  { 0xFF07, wxS("quotesinglemonospace") },
  { 0xFF08, wxS("parenleftmonospace") },
  { 0xFF09, wxS("parenrightmonospace") },
  { 0xFF0A, wxS("asteriskmonospace") },
  { 0xFF0B, wxS("plusmonospace") },
  { 0xFF0C, wxS("commamonospace") },
  { 0xFF0D, wxS("hyphenmonospace") },
  { 0xFF0E, wxS("periodmonospace") },
  { 0xFF0F, wxS("slashmonospace") },
  { 0xFF10, wxS("zeromonospace") },
  { 0xFF11, wxS("onemonospace") },
  { 0xFF12, wxS("twomonospace") },
  { 0xFF13, wxS("threemonospace") },
  { 0xFF14, wxS("fourmonospace") },
  { 0xFF15, wxS("fivemonospace") },
  { 0xFF16, wxS("sixmonospace") },
  { 0xFF17, wxS("sevenmonospace") },
  { 0xFF18, wxS("eightmonospace") },
  { 0xFF19, wxS("ninemonospace") },
  { 0xFF1A, wxS("colonmonospace") },
  { 0xFF1B, wxS("semicolonmonospace") },
  { 0xFF1C, wxS("lessmonospace") },
  { 0xFF1D, wxS("equalmonospace") },
  { 0xFF1E, wxS("greatermonospace") },
  { 0xFF1F, wxS("questionmonospace") },
  { 0xFF20, wxS("atmonospace") },
  { 0xFF21, wxS("Amonospace") },
  { 0xFF22, wxS("Bmonospace") },
  { 0xFF23, wxS("Cmonospace") },
  { 0xFF24, wxS("Dmonospace") },
  { 0xFF25, wxS("Emonospace") },
  { 0xFF26, wxS("Fmonospace") },
  { 0xFF27, wxS("Gmonospace") },
  { 0xFF28, wxS("Hmonospace") },
  { 0xFF29, wxS("Imonospace") },
  { 0xFF2A, wxS("Jmonospace") },
  { 0xFF2B, wxS("Kmonospace") },
  { 0xFF2C, wxS("Lmonospace") },
  { 0xFF2D, wxS("Mmonospace") },
  { 0xFF2E, wxS("Nmonospace") },
  { 0xFF2F, wxS("Omonospace") },
  { 0xFF30, wxS("Pmonospace") },
  { 0xFF31, wxS("Qmonospace") },
  { 0xFF32, wxS("Rmonospace") },
  { 0xFF33, wxS("Smonospace") },
  { 0xFF34, wxS("Tmonospace") },
  { 0xFF35, wxS("Umonospace") },
  { 0xFF36, wxS("Vmonospace") },
  { 0xFF37, wxS("Wmonospace") },
  { 0xFF38, wxS("Xmonospace") },
  { 0xFF39, wxS("Ymonospace") },
  { 0xFF3A, wxS("Zmonospace") },
  { 0xFF3B, wxS("bracketleftmonospace") },
  { 0xFF3C, wxS("backslashmonospace") },
  { 0xFF3D, wxS("bracketrightmonospace") },
  { 0xFF3E, wxS("asciicircummonospace") },
  { 0xFF3F, wxS("underscoremonospace") },
  { 0xFF40, wxS("gravemonospace") },
  { 0xFF41, wxS("amonospace") },
  { 0xFF42, wxS("bmonospace") },
  { 0xFF43, wxS("cmonospace") },
  { 0xFF44, wxS("dmonospace") },
  { 0xFF45, wxS("emonospace") },
  { 0xFF46, wxS("fmonospace") },
  { 0xFF47, wxS("gmonospace") },
  { 0xFF48, wxS("hmonospace") },
  { 0xFF49, wxS("imonospace") },
  { 0xFF4A, wxS("jmonospace") },
  { 0xFF4B, wxS("kmonospace") },
  { 0xFF4C, wxS("lmonospace") },
  { 0xFF4D, wxS("mmonospace") },
  { 0xFF4E, wxS("nmonospace") },
  { 0xFF4F, wxS("omonospace") },
  { 0xFF50, wxS("pmonospace") },
  { 0xFF51, wxS("qmonospace") },
  { 0xFF52, wxS("rmonospace") },
  { 0xFF53, wxS("smonospace") },
  { 0xFF54, wxS("tmonospace") },
  { 0xFF55, wxS("umonospace") },
  { 0xFF56, wxS("vmonospace") },
  { 0xFF57, wxS("wmonospace") },
  { 0xFF58, wxS("xmonospace") },
  { 0xFF59, wxS("ymonospace") },
  { 0xFF5A, wxS("zmonospace") },
  { 0xFF5B, wxS("braceleftmonospace") },
  { 0xFF5C, wxS("barmonospace") },
  { 0xFF5D, wxS("bracerightmonospace") },
  { 0xFF5E, wxS("asciitildemonospace") },
  { 0xFF61, wxS("periodhalfwidth") },
  { 0xFF62, wxS("cornerbracketlefthalfwidth") },
  { 0xFF63, wxS("cornerbracketrighthalfwidth") },
  { 0xFF64, wxS("ideographiccommaleft") },
  { 0xFF65, wxS("middledotkatakanahalfwidth") },
  { 0xFF66, wxS("wokatakanahalfwidth") },
  { 0xFF67, wxS("asmallkatakanahalfwidth") },
  { 0xFF68, wxS("ismallkatakanahalfwidth") },
  { 0xFF69, wxS("usmallkatakanahalfwidth") },
  { 0xFF6A, wxS("esmallkatakanahalfwidth") },
  { 0xFF6B, wxS("osmallkatakanahalfwidth") },
  { 0xFF6C, wxS("yasmallkatakanahalfwidth") },
  { 0xFF6D, wxS("yusmallkatakanahalfwidth") },
  { 0xFF6E, wxS("yosmallkatakanahalfwidth") },
  { 0xFF6F, wxS("tusmallkatakanahalfwidth") },
  { 0xFF70, wxS("katahiraprolongmarkhalfwidth") },
  { 0xFF71, wxS("akatakanahalfwidth") },
  { 0xFF72, wxS("ikatakanahalfwidth") },
  { 0xFF73, wxS("ukatakanahalfwidth") },
  { 0xFF74, wxS("ekatakanahalfwidth") },
  { 0xFF75, wxS("okatakanahalfwidth") },
  { 0xFF76, wxS("kakatakanahalfwidth") },
  { 0xFF77, wxS("kikatakanahalfwidth") },
  { 0xFF78, wxS("kukatakanahalfwidth") },
  { 0xFF79, wxS("kekatakanahalfwidth") },
  { 0xFF7A, wxS("kokatakanahalfwidth") },
  { 0xFF7B, wxS("sakatakanahalfwidth") },
  { 0xFF7C, wxS("sikatakanahalfwidth") },
  { 0xFF7D, wxS("sukatakanahalfwidth") },
  { 0xFF7E, wxS("sekatakanahalfwidth") },
  { 0xFF7F, wxS("sokatakanahalfwidth") },
  { 0xFF80, wxS("takatakanahalfwidth") },
  { 0xFF81, wxS("tikatakanahalfwidth") },
  { 0xFF82, wxS("tukatakanahalfwidth") },
  { 0xFF83, wxS("tekatakanahalfwidth") },
  { 0xFF84, wxS("tokatakanahalfwidth") },
  { 0xFF85, wxS("nakatakanahalfwidth") },
  { 0xFF86, wxS("nikatakanahalfwidth") },
  { 0xFF87, wxS("nukatakanahalfwidth") },
  { 0xFF88, wxS("nekatakanahalfwidth") },
  { 0xFF89, wxS("nokatakanahalfwidth") },
  { 0xFF8A, wxS("hakatakanahalfwidth") },
  { 0xFF8B, wxS("hikatakanahalfwidth") },
  { 0xFF8C, wxS("hukatakanahalfwidth") },
  { 0xFF8D, wxS("hekatakanahalfwidth") },
  { 0xFF8E, wxS("hokatakanahalfwidth") },
  { 0xFF8F, wxS("makatakanahalfwidth") },
  { 0xFF90, wxS("mikatakanahalfwidth") },
  { 0xFF91, wxS("mukatakanahalfwidth") },
  { 0xFF92, wxS("mekatakanahalfwidth") },
  { 0xFF93, wxS("mokatakanahalfwidth") },
  { 0xFF94, wxS("yakatakanahalfwidth") },
  { 0xFF95, wxS("yukatakanahalfwidth") },
  { 0xFF96, wxS("yokatakanahalfwidth") },
  { 0xFF97, wxS("rakatakanahalfwidth") },
  { 0xFF98, wxS("rikatakanahalfwidth") },
  { 0xFF99, wxS("rukatakanahalfwidth") },
  { 0xFF9A, wxS("rekatakanahalfwidth") },
  { 0xFF9B, wxS("rokatakanahalfwidth") },
  { 0xFF9C, wxS("wakatakanahalfwidth") },
  { 0xFF9D, wxS("nkatakanahalfwidth") },
  { 0xFF9E, wxS("voicedmarkkanahalfwidth") },
  { 0xFF9F, wxS("semivoicedmarkkanahalfwidth") },
  { 0xFFE0, wxS("centmonospace") },
  { 0xFFE1, wxS("sterlingmonospace") },
  { 0xFFE3, wxS("macronmonospace") },
  { 0xFFE5, wxS("yenmonospace") },
  { 0xFFE6, wxS("wonmonospace") },
  { 0x0000, wxS("") }
};

static const size_t gs_unicode2GlyphNameTableSize = 3684;
