/** @file

Copyright (c) 2021, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __DEFS_IIO_H__
#define __DEFS_IIO_H__

#include <fsp/api.h>

#define IIO_MODE_GEN4_ONLY                  0
#define IIO_MODE_GEN5                       1
#define IIO_MODE_CXL                        2
#define IIO_MODE_FORCE_CXL                  3
#define IIO_MODE_INVALID                    0xFF

#define IIO_BIFURCATE_xxxxxxxx          0xFE
#define IIO_BIFURCATE_x4x4x4x4          0x0
#define IIO_BIFURCATE_x4x4xxx8          0x1
#define IIO_BIFURCATE_xxx8x4x4          0x2
#define IIO_BIFURCATE_xxx8xxx8          0x3
#define IIO_BIFURCATE_xxxxxx16          0x4
#define IIO_BIFURCATE_x2x2x4x8          0x5
#define IIO_BIFURCATE_x4x2x2x8          0x6
#define IIO_BIFURCATE_x8x2x2x4          0x7
#define IIO_BIFURCATE_x8x4x2x2          0x8
#define IIO_BIFURCATE_x2x2x4x4x4        0x9
#define IIO_BIFURCATE_x4x2x2x4x4        0xA
#define IIO_BIFURCATE_x4x4x2x2x4        0xB
#define IIO_BIFURCATE_x4x4x4x2x2        0xC
#define IIO_BIFURCATE_x2x2x2x2x8        0xD
#define IIO_BIFURCATE_x8x2x2x2x2        0xE
#define IIO_BIFURCATE_x2x2x2x2x4x4      0xF
#define IIO_BIFURCATE_x2x2x4x2x2x4      0x10
#define IIO_BIFURCATE_x2x2x4x4x2x2      0x11
#define IIO_BIFURCATE_x4x2x2x2x2x4      0x12
#define IIO_BIFURCATE_x4x2x2x4x2x2      0x13
#define IIO_BIFURCATE_x4x4x2x2x2x2      0x14
#define IIO_BIFURCATE_x2x2x2x2x2x2x4    0x15
#define IIO_BIFURCATE_x2x2x2x2x4x2x2    0x16
#define IIO_BIFURCATE_x2x2x4x2x2x2x2    0x17
#define IIO_BIFURCATE_x4x2x2x2x2x2x2    0x18
#define IIO_BIFURCATE_x2x2x2x2x2x2x2x2  0x19
#define IIO_BIFURCATE_AUTO              0xFF

//------------------------------------------------------------------------------------
// IIO IPs located in extended stacks for SPR program
//------------------------------------------------------------------------------------
#define HCX_BUS_RANGE             0x04
#define HCB_BUS_RANGE             0x08
#define CPM_BUS_OFFSET            0x01
#define HQM_BUS_OFFSET            0x03
#define CPM1_BUS_OFFSET           0x05
#define HQM1_BUS_OFFSET           0x07
#define CPM_MMIO_SIZE             0x100000000         // 4G MMIO resource for CPM
#define HQM_MMIO_SIZE             0x400000000         // 16G MMIO resource for HQM
#define CPM_RESERVED_BUS          0x01
#define HQM_RESERVED_BUS          0x01

#define HCT_BUS_RANGE             0x02
#define HCM_BUS_RANGE             0x02
#define TIP_BUS_OFFSET            0x01
#define VID_BUS_OFFSET            0x01
#define TIP_MMIO_SIZE             0x80000            // 512K MMIO resource for TIP
#define VID_MMIO_SIZE             0x1000000          // 16MB MMIO resource for VID
#define TIP_RESERVED_BUS          0x01
#define VID_RESERVED_BUS          0x01

#pragma pack(1)
// It's better to align with UPD_IIO_PCIE_PORT_CONFIG
typedef struct {
  UINT8    SLOTEIP;
  UINT8    SLOTHPCAP;
  UINT8    SLOTHPSUP;
  UINT8    SLOTPIP;
  UINT8    SLOTAIP;
  UINT8    SLOTMRLSP;
  UINT8    SLOTPCP;
  UINT8    SLOTABP;
  UINT8    SLOTIMP;
  UINT8    SLOTSPLS;
  UINT8    SLOTSPLV;
  UINT16   SLOTPSP;
  BOOLEAN  VppEnabled;
  UINT8    VppPort;
  UINT8    VppAddress;
  UINT8    MuxAddress;
  UINT8    ChannelID;
  UINT8    PciePortEnable;
  UINT8    PEXPHIDE;
  UINT8    HidePEXPMenu;
  UINT8    PciePortOwnership;
  UINT8    RetimerConnectCount;
  UINT8    ConfigIOU;
  UINT8    PcieHotPlugOnPort;
  UINT8    VMDEnabled;
  UINT8    VMDPortEnable;
  UINT8    VMDHotPlugEnable;
  UINT8    PcieMaxPayload;
  UINT8    PciePortLinkSpeed;
  UINT8    DfxDnTxPresetGen3;
} UPD_IIO_PCIE_PORT_CONFIG_ENTRY;
#pragma pack()

//------------------------------------------------------------------------------------
// Uncomment line(s) below to override macro definitions in FSP IioUniversalDataHob.h
//------------------------------------------------------------------------------------
// #define MAX_SOCKET                4
// #define MAX_IMC                   4
// #define MAX_CH                    8
// #define MAX_IIO_PORTS_PER_SOCKET  57
// #define MAX_IIO_STACK             12

#endif
