% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{sqlParseVariables}
\alias{sqlParseVariables}
\alias{sqlCommentSpec}
\alias{sqlQuoteSpec}
\alias{sqlParseVariablesImpl}
\title{Parse interpolated variables from SQL.}
\usage{
sqlParseVariables(conn, sql, ...)

sqlCommentSpec(start, end, endRequired)

sqlQuoteSpec(start, end, escape = "", doubleEscape = TRUE)

sqlParseVariablesImpl(sql, quotes, comments)
}
\arguments{
\item{sql}{SQL to parse (a character string)}

\item{start, end}{Start and end characters for quotes and comments}

\item{endRequired}{Is the ending character of a comment required?}

\item{escape}{What character can be used to escape quoting characters?
Defaults to \code{""}, i.e. nothing.}

\item{doubleEscape}{Can quoting characters be escaped by doubling them?
Defaults to \code{TRUE}.}

\item{quotes}{A list of \code{QuoteSpec} calls defining the quoting
specification.}

\item{comments}{A list of \code{CommentSpec} calls defining the commenting
specification.}
}
\description{
If you're implementing a backend that uses non-ANSI quoting or commenting
rules, you'll need to implement a method for \code{sqlParseVariables} that
calls \code{sqlParseVariablesImpl} with the appropriate quote and
comment specifications.
}
\examples{
# Use [] for quoting and no comments
sqlParseVariablesImpl("[?a]",
  list(sqlQuoteSpec("[", "]", "\\\\", FALSE)),
  list()
)

# Standard quotes, use # for commenting
sqlParseVariablesImpl("# ?a\\n?b",
  list(sqlQuoteSpec("'", "'"), sqlQuoteSpec('"', '"')),
  list(sqlCommentSpec("#", "\\n", FALSE))
)
}
\keyword{internal}
