
/* plan.c */

#include "plan.h"
#include "argp.h"
#include "color.h"
#include "utf8.h"
#include "xref.h"
#include "gen.h"

void print_plan( void ) {
  /*const*/ struct xram *xram;
  for ( xram = &xram0000; xram; xram = xram->next ) {
    if ( xram->selected && xram->ram_level > 0 ) {
      printf( "%s%s " ,        COLOR( xram->ram  , RAMNO_C )          );
      {
        int i;
        for ( i = 0; i < xram->n_indent; ++i ) putchar(' ');
      }
      printf( "%s%s%s", UTF82( COLOR( xram->title, TITLE_C ) ), NEWLN );
      if ( opt.expand_xref ) {
        const struct xref *xref;
        for ( xref = xram->xref; xref; xref = xref->next ) {
          {
            int i;
            for ( i = 0; i < 1 + N_DIG * (SHIFTWIDTH+1); ++i )
              putchar(' ');
          }
          {
            /*const*/ struct xram *const xram2 = xref->xram;
            printf(
              "%s%s %s%s %s%s%s",
              UTF82( COLOR( INDIC_XREF  , XINDIC  ) ),
              COLOR       ( xram2->ram  , RAMNO_X )  ,
              UTF82( COLOR( xram2->title, TITLE_X ) ),
              NEWLN
            );
          }
        }
      }
    }
  }
}

