/***************************************************************************
                          misc.c  -  description
                             -------------------
    begin                : Wed Apr 19 2000
    copyright            : (C) 2000 by Thomas Ott
    email                : ott@mpe.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * file: utils/math_utils.c
 * Purpose: miscellanious utility functions - implementation
 * Author: Thomas Ott
 *
 * History: 30.06.1999: file created
 */

#include <stdio.h>
#include <stdlib.h>

#ifdef WIN
#pragma warning (disable: 4996) // disable warning for deprecated POSIX name
#endif

void get2ints(int *i1, int *i2, int min1, int max1, int min2, int max2) {
	int v1, v2;
	char in = 0;

	v1 = max1 + 1;
	v2 = max2 + 1;
	while ((v1 < min1) || (v1 > max1) || (v2 < min2) || (v2 > max2)) {
		fscanf(stdin, "%i %i", &v1, &v2);
		while (in != '\n') in = getchar();
		if ((v1 < min1) || (v1 > max1) || (v2 < min2) || (v2 > max2)) {
			printf("BAD VALUE - REENTER CHOICE\n");
		}
	}
	*i1 = v1;
	*i2 = v2;
	return;
}
			
int get_integer(int min, int max)
{
	int i;
	char in = 0;
	
	i = max + 1;
	while ((i < min) || (i > max)) {
		fscanf(stdin, "%i", &i);
		while (in != '\n') in = getchar();
		if ((i < min) || (i > max)) {
			printf("BAD VALUE - REENTER CHOICE\n");
		}
	}
	return i;
}

void get2floats(float *f1, float *f2) {
	char in = 0;

	fscanf(stdin, "%f %f", f1, f2);
	while (in != '\n') in = getchar();

	return;
}
			
float get_float()
{
	float f;
	char in = 0;
	
	fscanf(stdin, "%f", &f);
	while (in != '\n') in = getchar();

	return f;
}

void get2doubles(double *f1, double *f2) {
	char in = 0;

	fscanf(stdin, "%lf %lf", f1, f2);
	while (in != '\n') in = getchar();

	return;
}
			
double get_double()
{
	double f;
	char in = 0;
	
	fscanf(stdin, "%lf", &f);
	while (in != '\n') in = getchar();

	return f;
}
