/* Ergo, version 3.3, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2013 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */
#ifndef COMPUTE_OVERLAP_MAT_RECURSIVE_HEADER
#define COMPUTE_OVERLAP_MAT_RECURSIVE_HEADER

#ifdef USE_CHUNKS_AND_TASKS

#include "chunks_and_tasks.h"
#include "cht_type_lib.h"
#include "cht_matrix_lib.h"
#include "DistrBasisSetChunk.h"
#include "IntegralInfoChunk.h"
#include "cht_matrix_type.h"

ergo_real compute_one_element_of_overlap_mat_2bsets(const BasisInfoStruct & b1, int i1, const BasisInfoStruct & b2, int i2);

struct MatrixInfoStruct {
  int n;
  int leavesSizeMax;
  int leafInternalBlocksize;
};

class ComputeOverlapMatRecursive : public cht::Task {
public:
  cht::ID execute(const DistrBasisSetChunk &, const DistrBasisSetChunk &, const chttl::ChunkBasic<MatrixInfoStruct> &);
  CHT_TASK_INPUT((DistrBasisSetChunk, // First basis set part
		  DistrBasisSetChunk, // Second basis set part
		  chttl::ChunkBasic<MatrixInfoStruct> // Info about matrix size and blockSize
		  ));
  CHT_TASK_OUTPUT((CHTMLMatType));
  CHT_TASK_TYPE_DECLARATION;
};

#endif
#endif
