// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file core_typesTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "core_typesTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "core_types.hpp"


using namespace eprosima::fastdds::dds::xtypes;

namespace eprosima {
namespace fastdds {
namespace rtps {
namespace core {
namespace detail {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_EntityId_t_type_identifier(
        TypeIdentifierPair& type_ids_EntityId_t)
{

    ReturnCode_t return_code_EntityId_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EntityId_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::EntityId_t", type_ids_EntityId_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EntityId_t)
    {
        StructTypeFlag struct_flags_EntityId_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_EntityId_t = "eprosima::fastdds::rtps::core::detail::EntityId_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EntityId_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EntityId_t;
        CompleteTypeDetail detail_EntityId_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EntityId_t, ann_custom_EntityId_t, type_name_EntityId_t.to_string());
        CompleteStructHeader header_EntityId_t;
        header_EntityId_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_EntityId_t);
        CompleteStructMemberSeq member_seq_EntityId_t;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_4", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_4_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_4 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_byte_4_ec))};
                if (!element_identifier_anonymous_array_byte_4_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_4 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_4 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_4 = 0;
                PlainCollectionHeader header_anonymous_array_byte_4 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_4, element_flags_anonymous_array_byte_4);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(4));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_4, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_4));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_4", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_4 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_EntityId_t.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_EntityId_t);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityId_t, member_value);
        }
        CompleteStructType struct_type_EntityId_t = TypeObjectUtils::build_complete_struct_type(struct_flags_EntityId_t, header_EntityId_t, member_seq_EntityId_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_EntityId_t, type_name_EntityId_t.to_string(), type_ids_EntityId_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::EntityId_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ProtocolVersion_t_type_identifier(
        TypeIdentifierPair& type_ids_ProtocolVersion_t)
{

    ReturnCode_t return_code_ProtocolVersion_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ProtocolVersion_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::ProtocolVersion_t", type_ids_ProtocolVersion_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ProtocolVersion_t)
    {
        StructTypeFlag struct_flags_ProtocolVersion_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ProtocolVersion_t = "eprosima::fastdds::rtps::core::detail::ProtocolVersion_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ProtocolVersion_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ProtocolVersion_t;
        CompleteTypeDetail detail_ProtocolVersion_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ProtocolVersion_t, ann_custom_ProtocolVersion_t, type_name_ProtocolVersion_t.to_string());
        CompleteStructHeader header_ProtocolVersion_t;
        header_ProtocolVersion_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ProtocolVersion_t);
        CompleteStructMemberSeq member_seq_ProtocolVersion_t;
        {
            TypeIdentifierPair type_ids_major;
            ReturnCode_t return_code_major {eprosima::fastdds::dds::RETCODE_OK};
            return_code_major =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_major);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_major)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "major Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_major = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_major = 0x00000000;
            bool common_major_ec {false};
            CommonStructMember common_major {TypeObjectUtils::build_common_struct_member(member_id_major, member_flags_major, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_major, common_major_ec))};
            if (!common_major_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure major member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_major = "major";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_major;
            ann_custom_ProtocolVersion_t.reset();
            CompleteMemberDetail detail_major = TypeObjectUtils::build_complete_member_detail(name_major, member_ann_builtin_major, ann_custom_ProtocolVersion_t);
            CompleteStructMember member_major = TypeObjectUtils::build_complete_struct_member(common_major, detail_major);
            TypeObjectUtils::add_complete_struct_member(member_seq_ProtocolVersion_t, member_major);
        }
        {
            TypeIdentifierPair type_ids_minor;
            ReturnCode_t return_code_minor {eprosima::fastdds::dds::RETCODE_OK};
            return_code_minor =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_minor);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_minor)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "minor Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_minor = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_minor = 0x00000001;
            bool common_minor_ec {false};
            CommonStructMember common_minor {TypeObjectUtils::build_common_struct_member(member_id_minor, member_flags_minor, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_minor, common_minor_ec))};
            if (!common_minor_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure minor member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_minor = "minor";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_minor;
            ann_custom_ProtocolVersion_t.reset();
            CompleteMemberDetail detail_minor = TypeObjectUtils::build_complete_member_detail(name_minor, member_ann_builtin_minor, ann_custom_ProtocolVersion_t);
            CompleteStructMember member_minor = TypeObjectUtils::build_complete_struct_member(common_minor, detail_minor);
            TypeObjectUtils::add_complete_struct_member(member_seq_ProtocolVersion_t, member_minor);
        }
        CompleteStructType struct_type_ProtocolVersion_t = TypeObjectUtils::build_complete_struct_type(struct_flags_ProtocolVersion_t, header_ProtocolVersion_t, member_seq_ProtocolVersion_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ProtocolVersion_t, type_name_ProtocolVersion_t.to_string(), type_ids_ProtocolVersion_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::ProtocolVersion_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_VendorId_t_type_identifier(
        TypeIdentifierPair& type_ids_VendorId_t)
{

    ReturnCode_t return_code_VendorId_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_VendorId_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::VendorId_t", type_ids_VendorId_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_VendorId_t)
    {
        StructTypeFlag struct_flags_VendorId_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_VendorId_t = "eprosima::fastdds::rtps::core::detail::VendorId_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_VendorId_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_VendorId_t;
        CompleteTypeDetail detail_VendorId_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_VendorId_t, ann_custom_VendorId_t, type_name_VendorId_t.to_string());
        CompleteStructHeader header_VendorId_t;
        header_VendorId_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_VendorId_t);
        CompleteStructMemberSeq member_seq_VendorId_t;
        {
            TypeIdentifierPair type_ids_vendorId;
            ReturnCode_t return_code_vendorId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_vendorId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_2", type_ids_vendorId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_vendorId)
            {
                return_code_vendorId =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_vendorId);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_vendorId)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_vendorId, element_identifier_anonymous_array_byte_2_ec))};
                if (!element_identifier_anonymous_array_byte_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_2 = EK_COMPLETE;
                if (TK_NONE == type_ids_vendorId.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_2 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_2 = 0;
                PlainCollectionHeader header_anonymous_array_byte_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_2, element_flags_anonymous_array_byte_2);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_2, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_2", type_ids_vendorId))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_vendorId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_vendorId = 0x00000000;
            bool common_vendorId_ec {false};
            CommonStructMember common_vendorId {TypeObjectUtils::build_common_struct_member(member_id_vendorId, member_flags_vendorId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_vendorId, common_vendorId_ec))};
            if (!common_vendorId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure vendorId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_vendorId = "vendorId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_vendorId;
            ann_custom_VendorId_t.reset();
            CompleteMemberDetail detail_vendorId = TypeObjectUtils::build_complete_member_detail(name_vendorId, member_ann_builtin_vendorId, ann_custom_VendorId_t);
            CompleteStructMember member_vendorId = TypeObjectUtils::build_complete_struct_member(common_vendorId, detail_vendorId);
            TypeObjectUtils::add_complete_struct_member(member_seq_VendorId_t, member_vendorId);
        }
        CompleteStructType struct_type_VendorId_t = TypeObjectUtils::build_complete_struct_type(struct_flags_VendorId_t, header_VendorId_t, member_seq_VendorId_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_VendorId_t, type_name_VendorId_t.to_string(), type_ids_VendorId_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::VendorId_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_GuidPrefix_t_type_identifier(
        TypeIdentifierPair& type_ids_GuidPrefix_t)
{

    ReturnCode_t return_code_GuidPrefix_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_GuidPrefix_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::GuidPrefix_t", type_ids_GuidPrefix_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_GuidPrefix_t)
    {
        StructTypeFlag struct_flags_GuidPrefix_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_GuidPrefix_t = "eprosima::fastdds::rtps::core::detail::GuidPrefix_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_GuidPrefix_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_GuidPrefix_t;
        CompleteTypeDetail detail_GuidPrefix_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_GuidPrefix_t, ann_custom_GuidPrefix_t, type_name_GuidPrefix_t.to_string());
        CompleteStructHeader header_GuidPrefix_t;
        header_GuidPrefix_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_GuidPrefix_t);
        CompleteStructMemberSeq member_seq_GuidPrefix_t;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_12", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_12_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_12 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_byte_12_ec))};
                if (!element_identifier_anonymous_array_byte_12_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_12 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_12 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_12 = 0;
                PlainCollectionHeader header_anonymous_array_byte_12 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_12, element_flags_anonymous_array_byte_12);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(12));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_12, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_12));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_12", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_12 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_GuidPrefix_t.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_GuidPrefix_t);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_GuidPrefix_t, member_value);
        }
        CompleteStructType struct_type_GuidPrefix_t = TypeObjectUtils::build_complete_struct_type(struct_flags_GuidPrefix_t, header_GuidPrefix_t, member_seq_GuidPrefix_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_GuidPrefix_t, type_name_GuidPrefix_t.to_string(), type_ids_GuidPrefix_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::GuidPrefix_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_GUID_t_type_identifier(
        TypeIdentifierPair& type_ids_GUID_t)
{

    ReturnCode_t return_code_GUID_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_GUID_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::GUID_t", type_ids_GUID_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_GUID_t)
    {
        StructTypeFlag struct_flags_GUID_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_GUID_t = "eprosima::fastdds::rtps::core::detail::GUID_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_GUID_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_GUID_t;
        CompleteTypeDetail detail_GUID_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_GUID_t, ann_custom_GUID_t, type_name_GUID_t.to_string());
        CompleteStructHeader header_GUID_t;
        header_GUID_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_GUID_t);
        CompleteStructMemberSeq member_seq_GUID_t;
        {
            TypeIdentifierPair type_ids_guidPrefix;
            ReturnCode_t return_code_guidPrefix {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guidPrefix =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::GuidPrefix_t", type_ids_guidPrefix);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guidPrefix)
            {
                ::eprosima::fastdds::rtps::core::detail::register_GuidPrefix_t_type_identifier(type_ids_guidPrefix);
            }
            StructMemberFlag member_flags_guidPrefix = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_guidPrefix = 0x00000000;
            bool common_guidPrefix_ec {false};
            CommonStructMember common_guidPrefix {TypeObjectUtils::build_common_struct_member(member_id_guidPrefix, member_flags_guidPrefix, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guidPrefix, common_guidPrefix_ec))};
            if (!common_guidPrefix_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guidPrefix member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guidPrefix = "guidPrefix";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guidPrefix;
            ann_custom_GUID_t.reset();
            CompleteMemberDetail detail_guidPrefix = TypeObjectUtils::build_complete_member_detail(name_guidPrefix, member_ann_builtin_guidPrefix, ann_custom_GUID_t);
            CompleteStructMember member_guidPrefix = TypeObjectUtils::build_complete_struct_member(common_guidPrefix, detail_guidPrefix);
            TypeObjectUtils::add_complete_struct_member(member_seq_GUID_t, member_guidPrefix);
        }
        {
            TypeIdentifierPair type_ids_entityId;
            ReturnCode_t return_code_entityId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_entityId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::EntityId_t", type_ids_entityId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_entityId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_EntityId_t_type_identifier(type_ids_entityId);
            }
            StructMemberFlag member_flags_entityId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_entityId = 0x00000001;
            bool common_entityId_ec {false};
            CommonStructMember common_entityId {TypeObjectUtils::build_common_struct_member(member_id_entityId, member_flags_entityId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_entityId, common_entityId_ec))};
            if (!common_entityId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure entityId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_entityId = "entityId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_entityId;
            ann_custom_GUID_t.reset();
            CompleteMemberDetail detail_entityId = TypeObjectUtils::build_complete_member_detail(name_entityId, member_ann_builtin_entityId, ann_custom_GUID_t);
            CompleteStructMember member_entityId = TypeObjectUtils::build_complete_struct_member(common_entityId, detail_entityId);
            TypeObjectUtils::add_complete_struct_member(member_seq_GUID_t, member_entityId);
        }
        CompleteStructType struct_type_GUID_t = TypeObjectUtils::build_complete_struct_type(struct_flags_GUID_t, header_GUID_t, member_seq_GUID_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_GUID_t, type_name_GUID_t.to_string(), type_ids_GUID_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::GUID_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceNumber_t_type_identifier(
        TypeIdentifierPair& type_ids_SequenceNumber_t)
{

    ReturnCode_t return_code_SequenceNumber_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceNumber_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::SequenceNumber_t", type_ids_SequenceNumber_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceNumber_t)
    {
        StructTypeFlag struct_flags_SequenceNumber_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceNumber_t = "eprosima::fastdds::rtps::core::detail::SequenceNumber_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceNumber_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceNumber_t;
        CompleteTypeDetail detail_SequenceNumber_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceNumber_t, ann_custom_SequenceNumber_t, type_name_SequenceNumber_t.to_string());
        CompleteStructHeader header_SequenceNumber_t;
        header_SequenceNumber_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceNumber_t);
        CompleteStructMemberSeq member_seq_SequenceNumber_t;
        {
            TypeIdentifierPair type_ids_high;
            ReturnCode_t return_code_high {eprosima::fastdds::dds::RETCODE_OK};
            return_code_high =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_high);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_high)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "high Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_high = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_high = 0x00000000;
            bool common_high_ec {false};
            CommonStructMember common_high {TypeObjectUtils::build_common_struct_member(member_id_high, member_flags_high, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_high, common_high_ec))};
            if (!common_high_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure high member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_high = "high";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_high;
            ann_custom_SequenceNumber_t.reset();
            CompleteMemberDetail detail_high = TypeObjectUtils::build_complete_member_detail(name_high, member_ann_builtin_high, ann_custom_SequenceNumber_t);
            CompleteStructMember member_high = TypeObjectUtils::build_complete_struct_member(common_high, detail_high);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumber_t, member_high);
        }
        {
            TypeIdentifierPair type_ids_low;
            ReturnCode_t return_code_low {eprosima::fastdds::dds::RETCODE_OK};
            return_code_low =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_low);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_low)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "low Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_low = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_low = 0x00000001;
            bool common_low_ec {false};
            CommonStructMember common_low {TypeObjectUtils::build_common_struct_member(member_id_low, member_flags_low, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_low, common_low_ec))};
            if (!common_low_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure low member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_low = "low";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_low;
            ann_custom_SequenceNumber_t.reset();
            CompleteMemberDetail detail_low = TypeObjectUtils::build_complete_member_detail(name_low, member_ann_builtin_low, ann_custom_SequenceNumber_t);
            CompleteStructMember member_low = TypeObjectUtils::build_complete_struct_member(common_low, detail_low);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumber_t, member_low);
        }
        CompleteStructType struct_type_SequenceNumber_t = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceNumber_t, header_SequenceNumber_t, member_seq_SequenceNumber_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceNumber_t, type_name_SequenceNumber_t.to_string(), type_ids_SequenceNumber_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::SequenceNumber_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Count_t_type_identifier(
        TypeIdentifierPair& type_ids_Count_t)
{

    ReturnCode_t return_code_Count_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Count_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::Count_t", type_ids_Count_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Count_t)
    {
        StructTypeFlag struct_flags_Count_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Count_t = "eprosima::fastdds::rtps::core::detail::Count_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Count_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Count_t;
        CompleteTypeDetail detail_Count_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Count_t, ann_custom_Count_t, type_name_Count_t.to_string());
        CompleteStructHeader header_Count_t;
        header_Count_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Count_t);
        CompleteStructMemberSeq member_seq_Count_t;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_Count_t.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_Count_t);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_Count_t, member_value);
        }
        CompleteStructType struct_type_Count_t = TypeObjectUtils::build_complete_struct_type(struct_flags_Count_t, header_Count_t, member_seq_Count_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Count_t, type_name_Count_t.to_string(), type_ids_Count_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::Count_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Time_t_type_identifier(
        TypeIdentifierPair& type_ids_Time_t)
{

    ReturnCode_t return_code_Time_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Time_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::Time_t", type_ids_Time_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Time_t)
    {
        StructTypeFlag struct_flags_Time_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Time_t = "eprosima::fastdds::rtps::core::detail::Time_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Time_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Time_t;
        CompleteTypeDetail detail_Time_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Time_t, ann_custom_Time_t, type_name_Time_t.to_string());
        CompleteStructHeader header_Time_t;
        header_Time_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Time_t);
        CompleteStructMemberSeq member_seq_Time_t;
        {
            TypeIdentifierPair type_ids_seconds;
            ReturnCode_t return_code_seconds {eprosima::fastdds::dds::RETCODE_OK};
            return_code_seconds =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_seconds);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_seconds)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "seconds Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_seconds = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_seconds = 0x00000000;
            bool common_seconds_ec {false};
            CommonStructMember common_seconds {TypeObjectUtils::build_common_struct_member(member_id_seconds, member_flags_seconds, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_seconds, common_seconds_ec))};
            if (!common_seconds_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure seconds member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_seconds = "seconds";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_seconds;
            ann_custom_Time_t.reset();
            CompleteMemberDetail detail_seconds = TypeObjectUtils::build_complete_member_detail(name_seconds, member_ann_builtin_seconds, ann_custom_Time_t);
            CompleteStructMember member_seconds = TypeObjectUtils::build_complete_struct_member(common_seconds, detail_seconds);
            TypeObjectUtils::add_complete_struct_member(member_seq_Time_t, member_seconds);
        }
        {
            TypeIdentifierPair type_ids_fraction;
            ReturnCode_t return_code_fraction {eprosima::fastdds::dds::RETCODE_OK};
            return_code_fraction =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_fraction);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_fraction)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "fraction Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_fraction = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_fraction = 0x00000001;
            bool common_fraction_ec {false};
            CommonStructMember common_fraction {TypeObjectUtils::build_common_struct_member(member_id_fraction, member_flags_fraction, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_fraction, common_fraction_ec))};
            if (!common_fraction_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure fraction member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_fraction = "fraction";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_fraction;
            ann_custom_Time_t.reset();
            CompleteMemberDetail detail_fraction = TypeObjectUtils::build_complete_member_detail(name_fraction, member_ann_builtin_fraction, ann_custom_Time_t);
            CompleteStructMember member_fraction = TypeObjectUtils::build_complete_struct_member(common_fraction, detail_fraction);
            TypeObjectUtils::add_complete_struct_member(member_seq_Time_t, member_fraction);
        }
        CompleteStructType struct_type_Time_t = TypeObjectUtils::build_complete_struct_type(struct_flags_Time_t, header_Time_t, member_seq_Time_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Time_t, type_name_Time_t.to_string(), type_ids_Time_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::Time_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_Timestamp_type_identifier(
        TypeIdentifierPair& type_ids_Timestamp)
{
    ReturnCode_t return_code_Timestamp {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Timestamp =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::Timestamp", type_ids_Timestamp);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Timestamp)
    {
        AliasTypeFlag alias_flags_Timestamp = 0;
        QualifiedTypeName type_name_Timestamp = "eprosima::fastdds::rtps::core::detail::Timestamp";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Timestamp;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Timestamp;
        CompleteTypeDetail detail_Timestamp = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Timestamp, ann_custom_Timestamp, type_name_Timestamp.to_string());
        CompleteAliasHeader header_Timestamp = TypeObjectUtils::build_complete_alias_header(detail_Timestamp);
        AliasMemberFlag related_flags_Timestamp = 0;
        return_code_Timestamp =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "eprosima::fastdds::rtps::core::detail::Time_t", type_ids_Timestamp);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_Timestamp)
        {
            ::eprosima::fastdds::rtps::core::detail::register_Time_t_type_identifier(type_ids_Timestamp);
        }
        bool common_Timestamp_ec {false};
        CommonAliasBody common_Timestamp {TypeObjectUtils::build_common_alias_body(related_flags_Timestamp,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Timestamp, common_Timestamp_ec))};
        if (!common_Timestamp_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::rtps::core::detail::Timestamp related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_Timestamp;
        ann_custom_Timestamp.reset();
        CompleteAliasBody body_Timestamp = TypeObjectUtils::build_complete_alias_body(common_Timestamp,
                member_ann_builtin_Timestamp, ann_custom_Timestamp);
        CompleteAliasType alias_type_Timestamp = TypeObjectUtils::build_complete_alias_type(alias_flags_Timestamp,
                header_Timestamp, body_Timestamp);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_Timestamp,
                    type_name_Timestamp.to_string(), type_ids_Timestamp))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::rtps::core::detail::Timestamp already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceNumberSet_type_identifier(
        TypeIdentifierPair& type_ids_SequenceNumberSet)
{

    ReturnCode_t return_code_SequenceNumberSet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceNumberSet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::SequenceNumberSet", type_ids_SequenceNumberSet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceNumberSet)
    {
        StructTypeFlag struct_flags_SequenceNumberSet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceNumberSet = "eprosima::fastdds::rtps::core::detail::SequenceNumberSet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceNumberSet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceNumberSet;
        CompleteTypeDetail detail_SequenceNumberSet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceNumberSet, ann_custom_SequenceNumberSet, type_name_SequenceNumberSet.to_string());
        CompleteStructHeader header_SequenceNumberSet;
        header_SequenceNumberSet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceNumberSet);
        CompleteStructMemberSeq member_seq_SequenceNumberSet;
        {
            TypeIdentifierPair type_ids_bitmapBase;
            ReturnCode_t return_code_bitmapBase {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bitmapBase =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::SequenceNumber_t", type_ids_bitmapBase);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitmapBase)
            {
                ::eprosima::fastdds::rtps::core::detail::register_SequenceNumber_t_type_identifier(type_ids_bitmapBase);
            }
            StructMemberFlag member_flags_bitmapBase = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bitmapBase = 0x00000000;
            bool common_bitmapBase_ec {false};
            CommonStructMember common_bitmapBase {TypeObjectUtils::build_common_struct_member(member_id_bitmapBase, member_flags_bitmapBase, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitmapBase, common_bitmapBase_ec))};
            if (!common_bitmapBase_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bitmapBase member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bitmapBase = "bitmapBase";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bitmapBase;
            ann_custom_SequenceNumberSet.reset();
            CompleteMemberDetail detail_bitmapBase = TypeObjectUtils::build_complete_member_detail(name_bitmapBase, member_ann_builtin_bitmapBase, ann_custom_SequenceNumberSet);
            CompleteStructMember member_bitmapBase = TypeObjectUtils::build_complete_struct_member(common_bitmapBase, detail_bitmapBase);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumberSet, member_bitmapBase);
        }
        {
            TypeIdentifierPair type_ids_numBits;
            ReturnCode_t return_code_numBits {eprosima::fastdds::dds::RETCODE_OK};
            return_code_numBits =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_numBits);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_numBits)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "numBits Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_numBits = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_numBits = 0x00000001;
            bool common_numBits_ec {false};
            CommonStructMember common_numBits {TypeObjectUtils::build_common_struct_member(member_id_numBits, member_flags_numBits, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_numBits, common_numBits_ec))};
            if (!common_numBits_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure numBits member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_numBits = "numBits";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_numBits;
            ann_custom_SequenceNumberSet.reset();
            CompleteMemberDetail detail_numBits = TypeObjectUtils::build_complete_member_detail(name_numBits, member_ann_builtin_numBits, ann_custom_SequenceNumberSet);
            CompleteStructMember member_numBits = TypeObjectUtils::build_complete_struct_member(common_numBits, detail_numBits);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumberSet, member_numBits);
        }
        {
            TypeIdentifierPair type_ids_bitmap;
            ReturnCode_t return_code_bitmap {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bitmap =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_8", type_ids_bitmap);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitmap)
            {
                return_code_bitmap =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_bitmap);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitmap)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_8_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_8 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitmap, element_identifier_anonymous_array_byte_8_ec))};
                if (!element_identifier_anonymous_array_byte_8_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_8 = EK_COMPLETE;
                if (TK_NONE == type_ids_bitmap.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_8 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_8 = 0;
                PlainCollectionHeader header_anonymous_array_byte_8 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_8, element_flags_anonymous_array_byte_8);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(8));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_8, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_8));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_8", type_ids_bitmap))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_8 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bitmap = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bitmap = 0x00000002;
            bool common_bitmap_ec {false};
            CommonStructMember common_bitmap {TypeObjectUtils::build_common_struct_member(member_id_bitmap, member_flags_bitmap, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitmap, common_bitmap_ec))};
            if (!common_bitmap_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bitmap member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bitmap = "bitmap";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bitmap;
            ann_custom_SequenceNumberSet.reset();
            CompleteMemberDetail detail_bitmap = TypeObjectUtils::build_complete_member_detail(name_bitmap, member_ann_builtin_bitmap, ann_custom_SequenceNumberSet);
            CompleteStructMember member_bitmap = TypeObjectUtils::build_complete_struct_member(common_bitmap, detail_bitmap);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumberSet, member_bitmap);
        }
        CompleteStructType struct_type_SequenceNumberSet = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceNumberSet, header_SequenceNumberSet, member_seq_SequenceNumberSet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceNumberSet, type_name_SequenceNumberSet.to_string(), type_ids_SequenceNumberSet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::SequenceNumberSet already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Locator_t_type_identifier(
        TypeIdentifierPair& type_ids_Locator_t)
{

    ReturnCode_t return_code_Locator_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Locator_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::Locator_t", type_ids_Locator_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Locator_t)
    {
        StructTypeFlag struct_flags_Locator_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Locator_t = "eprosima::fastdds::rtps::core::detail::Locator_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Locator_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Locator_t;
        CompleteTypeDetail detail_Locator_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Locator_t, ann_custom_Locator_t, type_name_Locator_t.to_string());
        CompleteStructHeader header_Locator_t;
        header_Locator_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Locator_t);
        CompleteStructMemberSeq member_seq_Locator_t;
        {
            TypeIdentifierPair type_ids_kind;
            ReturnCode_t return_code_kind {eprosima::fastdds::dds::RETCODE_OK};
            return_code_kind =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_kind);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_kind)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "kind Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_kind = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_kind = 0x00000000;
            bool common_kind_ec {false};
            CommonStructMember common_kind {TypeObjectUtils::build_common_struct_member(member_id_kind, member_flags_kind, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_kind, common_kind_ec))};
            if (!common_kind_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure kind member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_kind = "kind";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_kind;
            ann_custom_Locator_t.reset();
            CompleteMemberDetail detail_kind = TypeObjectUtils::build_complete_member_detail(name_kind, member_ann_builtin_kind, ann_custom_Locator_t);
            CompleteStructMember member_kind = TypeObjectUtils::build_complete_struct_member(common_kind, detail_kind);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator_t, member_kind);
        }
        {
            TypeIdentifierPair type_ids_port;
            ReturnCode_t return_code_port {eprosima::fastdds::dds::RETCODE_OK};
            return_code_port =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_port);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_port)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "port Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_port = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_port = 0x00000001;
            bool common_port_ec {false};
            CommonStructMember common_port {TypeObjectUtils::build_common_struct_member(member_id_port, member_flags_port, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_port, common_port_ec))};
            if (!common_port_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure port member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_port = "port";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_port;
            ann_custom_Locator_t.reset();
            CompleteMemberDetail detail_port = TypeObjectUtils::build_complete_member_detail(name_port, member_ann_builtin_port, ann_custom_Locator_t);
            CompleteStructMember member_port = TypeObjectUtils::build_complete_struct_member(common_port, detail_port);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator_t, member_port);
        }
        {
            TypeIdentifierPair type_ids_address;
            ReturnCode_t return_code_address {eprosima::fastdds::dds::RETCODE_OK};
            return_code_address =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_16", type_ids_address);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_address)
            {
                return_code_address =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_address);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_address)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_16_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_16 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_address, element_identifier_anonymous_array_byte_16_ec))};
                if (!element_identifier_anonymous_array_byte_16_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_16 = EK_COMPLETE;
                if (TK_NONE == type_ids_address.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_16 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_16 = 0;
                PlainCollectionHeader header_anonymous_array_byte_16 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_16, element_flags_anonymous_array_byte_16);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(16));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_16, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_16));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_16", type_ids_address))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_16 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_address = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_address = 0x00000002;
            bool common_address_ec {false};
            CommonStructMember common_address {TypeObjectUtils::build_common_struct_member(member_id_address, member_flags_address, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_address, common_address_ec))};
            if (!common_address_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure address member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_address = "address";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_address;
            ann_custom_Locator_t.reset();
            CompleteMemberDetail detail_address = TypeObjectUtils::build_complete_member_detail(name_address, member_ann_builtin_address, ann_custom_Locator_t);
            CompleteStructMember member_address = TypeObjectUtils::build_complete_struct_member(common_address, detail_address);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator_t, member_address);
        }
        CompleteStructType struct_type_Locator_t = TypeObjectUtils::build_complete_struct_type(struct_flags_Locator_t, header_Locator_t, member_seq_Locator_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Locator_t, type_name_Locator_t.to_string(), type_ids_Locator_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::Locator_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Duration_t_type_identifier(
        TypeIdentifierPair& type_ids_Duration_t)
{

    ReturnCode_t return_code_Duration_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Duration_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::Duration_t", type_ids_Duration_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Duration_t)
    {
        StructTypeFlag struct_flags_Duration_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Duration_t = "eprosima::fastdds::rtps::core::detail::Duration_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Duration_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Duration_t;
        CompleteTypeDetail detail_Duration_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Duration_t, ann_custom_Duration_t, type_name_Duration_t.to_string());
        CompleteStructHeader header_Duration_t;
        header_Duration_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Duration_t);
        CompleteStructMemberSeq member_seq_Duration_t;
        {
            TypeIdentifierPair type_ids_seconds;
            ReturnCode_t return_code_seconds {eprosima::fastdds::dds::RETCODE_OK};
            return_code_seconds =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_seconds);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_seconds)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "seconds Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_seconds = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_seconds = 0x00000000;
            bool common_seconds_ec {false};
            CommonStructMember common_seconds {TypeObjectUtils::build_common_struct_member(member_id_seconds, member_flags_seconds, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_seconds, common_seconds_ec))};
            if (!common_seconds_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure seconds member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_seconds = "seconds";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_seconds;
            ann_custom_Duration_t.reset();
            CompleteMemberDetail detail_seconds = TypeObjectUtils::build_complete_member_detail(name_seconds, member_ann_builtin_seconds, ann_custom_Duration_t);
            CompleteStructMember member_seconds = TypeObjectUtils::build_complete_struct_member(common_seconds, detail_seconds);
            TypeObjectUtils::add_complete_struct_member(member_seq_Duration_t, member_seconds);
        }
        {
            TypeIdentifierPair type_ids_fraction;
            ReturnCode_t return_code_fraction {eprosima::fastdds::dds::RETCODE_OK};
            return_code_fraction =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_fraction);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_fraction)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "fraction Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_fraction = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_fraction = 0x00000001;
            bool common_fraction_ec {false};
            CommonStructMember common_fraction {TypeObjectUtils::build_common_struct_member(member_id_fraction, member_flags_fraction, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_fraction, common_fraction_ec))};
            if (!common_fraction_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure fraction member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_fraction = "fraction";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_fraction;
            ann_custom_Duration_t.reset();
            CompleteMemberDetail detail_fraction = TypeObjectUtils::build_complete_member_detail(name_fraction, member_ann_builtin_fraction, ann_custom_Duration_t);
            CompleteStructMember member_fraction = TypeObjectUtils::build_complete_struct_member(common_fraction, detail_fraction);
            TypeObjectUtils::add_complete_struct_member(member_seq_Duration_t, member_fraction);
        }
        CompleteStructType struct_type_Duration_t = TypeObjectUtils::build_complete_struct_type(struct_flags_Duration_t, header_Duration_t, member_seq_Duration_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Duration_t, type_name_Duration_t.to_string(), type_ids_Duration_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::Duration_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_DomainId_t_type_identifier(
        TypeIdentifierPair& type_ids_DomainId_t)
{
    ReturnCode_t return_code_DomainId_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DomainId_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::DomainId_t", type_ids_DomainId_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DomainId_t)
    {
        AliasTypeFlag alias_flags_DomainId_t = 0;
        QualifiedTypeName type_name_DomainId_t = "eprosima::fastdds::rtps::core::detail::DomainId_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DomainId_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DomainId_t;
        CompleteTypeDetail detail_DomainId_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DomainId_t, ann_custom_DomainId_t, type_name_DomainId_t.to_string());
        CompleteAliasHeader header_DomainId_t = TypeObjectUtils::build_complete_alias_header(detail_DomainId_t);
        AliasMemberFlag related_flags_DomainId_t = 0;
        return_code_DomainId_t =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint32_t", type_ids_DomainId_t);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_DomainId_t)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::DomainId_t related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_DomainId_t_ec {false};
        CommonAliasBody common_DomainId_t {TypeObjectUtils::build_common_alias_body(related_flags_DomainId_t,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_DomainId_t, common_DomainId_t_ec))};
        if (!common_DomainId_t_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::rtps::core::detail::DomainId_t related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_DomainId_t;
        ann_custom_DomainId_t.reset();
        CompleteAliasBody body_DomainId_t = TypeObjectUtils::build_complete_alias_body(common_DomainId_t,
                member_ann_builtin_DomainId_t, ann_custom_DomainId_t);
        CompleteAliasType alias_type_DomainId_t = TypeObjectUtils::build_complete_alias_type(alias_flags_DomainId_t,
                header_DomainId_t, body_DomainId_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_DomainId_t,
                    type_name_DomainId_t.to_string(), type_ids_DomainId_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::rtps::core::detail::DomainId_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_BuiltinEndpointQos_t_type_identifier(
        TypeIdentifierPair& type_ids_BuiltinEndpointQos_t)
{
    ReturnCode_t return_code_BuiltinEndpointQos_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BuiltinEndpointQos_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::BuiltinEndpointQos_t", type_ids_BuiltinEndpointQos_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BuiltinEndpointQos_t)
    {
        AliasTypeFlag alias_flags_BuiltinEndpointQos_t = 0;
        QualifiedTypeName type_name_BuiltinEndpointQos_t = "eprosima::fastdds::rtps::core::detail::BuiltinEndpointQos_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BuiltinEndpointQos_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BuiltinEndpointQos_t;
        CompleteTypeDetail detail_BuiltinEndpointQos_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BuiltinEndpointQos_t, ann_custom_BuiltinEndpointQos_t, type_name_BuiltinEndpointQos_t.to_string());
        CompleteAliasHeader header_BuiltinEndpointQos_t = TypeObjectUtils::build_complete_alias_header(detail_BuiltinEndpointQos_t);
        AliasMemberFlag related_flags_BuiltinEndpointQos_t = 0;
        return_code_BuiltinEndpointQos_t =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint32_t", type_ids_BuiltinEndpointQos_t);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_BuiltinEndpointQos_t)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::BuiltinEndpointQos_t related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_BuiltinEndpointQos_t_ec {false};
        CommonAliasBody common_BuiltinEndpointQos_t {TypeObjectUtils::build_common_alias_body(related_flags_BuiltinEndpointQos_t,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_BuiltinEndpointQos_t, common_BuiltinEndpointQos_t_ec))};
        if (!common_BuiltinEndpointQos_t_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::rtps::core::detail::BuiltinEndpointQos_t related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_BuiltinEndpointQos_t;
        ann_custom_BuiltinEndpointQos_t.reset();
        CompleteAliasBody body_BuiltinEndpointQos_t = TypeObjectUtils::build_complete_alias_body(common_BuiltinEndpointQos_t,
                member_ann_builtin_BuiltinEndpointQos_t, ann_custom_BuiltinEndpointQos_t);
        CompleteAliasType alias_type_BuiltinEndpointQos_t = TypeObjectUtils::build_complete_alias_type(alias_flags_BuiltinEndpointQos_t,
                header_BuiltinEndpointQos_t, body_BuiltinEndpointQos_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_BuiltinEndpointQos_t,
                    type_name_BuiltinEndpointQos_t.to_string(), type_ids_BuiltinEndpointQos_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::rtps::core::detail::BuiltinEndpointQos_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StatusInfo_t_type_identifier(
        TypeIdentifierPair& type_ids_StatusInfo_t)
{

    ReturnCode_t return_code_StatusInfo_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StatusInfo_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::StatusInfo_t", type_ids_StatusInfo_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StatusInfo_t)
    {
        StructTypeFlag struct_flags_StatusInfo_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StatusInfo_t = "eprosima::fastdds::rtps::core::detail::StatusInfo_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StatusInfo_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StatusInfo_t;
        CompleteTypeDetail detail_StatusInfo_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StatusInfo_t, ann_custom_StatusInfo_t, type_name_StatusInfo_t.to_string());
        CompleteStructHeader header_StatusInfo_t;
        header_StatusInfo_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StatusInfo_t);
        CompleteStructMemberSeq member_seq_StatusInfo_t;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_4", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_4_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_4 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_byte_4_ec))};
                if (!element_identifier_anonymous_array_byte_4_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_4 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_4 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_4 = 0;
                PlainCollectionHeader header_anonymous_array_byte_4 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_4, element_flags_anonymous_array_byte_4);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(4));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_4, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_4));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_4", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_4 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_StatusInfo_t.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_StatusInfo_t);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_StatusInfo_t, member_value);
        }
        CompleteStructType struct_type_StatusInfo_t = TypeObjectUtils::build_complete_struct_type(struct_flags_StatusInfo_t, header_StatusInfo_t, member_seq_StatusInfo_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StatusInfo_t, type_name_StatusInfo_t.to_string(), type_ids_StatusInfo_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::StatusInfo_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_KeyHash_t_type_identifier(
        TypeIdentifierPair& type_ids_KeyHash_t)
{

    ReturnCode_t return_code_KeyHash_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_KeyHash_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::KeyHash_t", type_ids_KeyHash_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_KeyHash_t)
    {
        StructTypeFlag struct_flags_KeyHash_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_KeyHash_t = "eprosima::fastdds::rtps::core::detail::KeyHash_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_KeyHash_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_KeyHash_t;
        CompleteTypeDetail detail_KeyHash_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_KeyHash_t, ann_custom_KeyHash_t, type_name_KeyHash_t.to_string());
        CompleteStructHeader header_KeyHash_t;
        header_KeyHash_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_KeyHash_t);
        CompleteStructMemberSeq member_seq_KeyHash_t;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_16", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_16_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_16 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_byte_16_ec))};
                if (!element_identifier_anonymous_array_byte_16_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_16 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_16 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_16 = 0;
                PlainCollectionHeader header_anonymous_array_byte_16 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_16, element_flags_anonymous_array_byte_16);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(16));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_16, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_16));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_16", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_16 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_KeyHash_t.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_KeyHash_t);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_KeyHash_t, member_value);
        }
        CompleteStructType struct_type_KeyHash_t = TypeObjectUtils::build_complete_struct_type(struct_flags_KeyHash_t, header_KeyHash_t, member_seq_KeyHash_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_KeyHash_t, type_name_KeyHash_t.to_string(), type_ids_KeyHash_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::KeyHash_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_EntityName_t_type_identifier(
        TypeIdentifierPair& type_ids_EntityName_t)
{

    ReturnCode_t return_code_EntityName_t {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EntityName_t =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::detail::EntityName_t", type_ids_EntityName_t);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EntityName_t)
    {
        StructTypeFlag struct_flags_EntityName_t = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_EntityName_t = "eprosima::fastdds::rtps::core::detail::EntityName_t";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EntityName_t;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EntityName_t;
        CompleteTypeDetail detail_EntityName_t = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EntityName_t, ann_custom_EntityName_t, type_name_EntityName_t.to_string());
        CompleteStructHeader header_EntityName_t;
        header_EntityName_t = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_EntityName_t);
        CompleteStructMemberSeq member_seq_EntityName_t;
        {
            TypeIdentifierPair type_ids_name;
            ReturnCode_t return_code_name {eprosima::fastdds::dds::RETCODE_OK};
            return_code_name =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_name);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_name)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_name))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_name = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_name = 0x00000000;
            bool common_name_ec {false};
            CommonStructMember common_name {TypeObjectUtils::build_common_struct_member(member_id_name, member_flags_name, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_name, common_name_ec))};
            if (!common_name_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure name member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_name = "name";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_name;
            ann_custom_EntityName_t.reset();
            CompleteMemberDetail detail_name = TypeObjectUtils::build_complete_member_detail(name_name, member_ann_builtin_name, ann_custom_EntityName_t);
            CompleteStructMember member_name = TypeObjectUtils::build_complete_struct_member(common_name, detail_name);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityName_t, member_name);
        }
        CompleteStructType struct_type_EntityName_t = TypeObjectUtils::build_complete_struct_type(struct_flags_EntityName_t, header_EntityName_t, member_seq_EntityName_t);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_EntityName_t, type_name_EntityName_t.to_string(), type_ids_EntityName_t))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::detail::EntityName_t already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace detail
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Header_type_identifier(
        TypeIdentifierPair& type_ids_Header)
{

    ReturnCode_t return_code_Header {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Header =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::Header", type_ids_Header);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Header)
    {
        StructTypeFlag struct_flags_Header = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Header = "eprosima::fastdds::rtps::core::Header";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Header;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Header;
        CompleteTypeDetail detail_Header = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Header, ann_custom_Header, type_name_Header.to_string());
        CompleteStructHeader header_Header;
        header_Header = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Header);
        CompleteStructMemberSeq member_seq_Header;
        {
            TypeIdentifierPair type_ids_prefix;
            ReturnCode_t return_code_prefix {eprosima::fastdds::dds::RETCODE_OK};
            return_code_prefix =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_4", type_ids_prefix);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_prefix)
            {
                return_code_prefix =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_prefix);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_prefix)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_4_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_4 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_prefix, element_identifier_anonymous_array_byte_4_ec))};
                if (!element_identifier_anonymous_array_byte_4_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_4 = EK_COMPLETE;
                if (TK_NONE == type_ids_prefix.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_4 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_4 = 0;
                PlainCollectionHeader header_anonymous_array_byte_4 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_4, element_flags_anonymous_array_byte_4);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(4));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_4, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_4));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_4", type_ids_prefix))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_4 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_prefix = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_prefix = 0x00000000;
            bool common_prefix_ec {false};
            CommonStructMember common_prefix {TypeObjectUtils::build_common_struct_member(member_id_prefix, member_flags_prefix, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_prefix, common_prefix_ec))};
            if (!common_prefix_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure prefix member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_prefix = "prefix";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_prefix;
            ann_custom_Header.reset();
            CompleteMemberDetail detail_prefix = TypeObjectUtils::build_complete_member_detail(name_prefix, member_ann_builtin_prefix, ann_custom_Header);
            CompleteStructMember member_prefix = TypeObjectUtils::build_complete_struct_member(common_prefix, detail_prefix);
            TypeObjectUtils::add_complete_struct_member(member_seq_Header, member_prefix);
        }
        {
            TypeIdentifierPair type_ids_version;
            ReturnCode_t return_code_version {eprosima::fastdds::dds::RETCODE_OK};
            return_code_version =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::ProtocolVersion_t", type_ids_version);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_version)
            {
                ::eprosima::fastdds::rtps::core::detail::register_ProtocolVersion_t_type_identifier(type_ids_version);
            }
            StructMemberFlag member_flags_version = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_version = 0x00000001;
            bool common_version_ec {false};
            CommonStructMember common_version {TypeObjectUtils::build_common_struct_member(member_id_version, member_flags_version, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_version, common_version_ec))};
            if (!common_version_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure version member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_version = "version";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_version;
            ann_custom_Header.reset();
            CompleteMemberDetail detail_version = TypeObjectUtils::build_complete_member_detail(name_version, member_ann_builtin_version, ann_custom_Header);
            CompleteStructMember member_version = TypeObjectUtils::build_complete_struct_member(common_version, detail_version);
            TypeObjectUtils::add_complete_struct_member(member_seq_Header, member_version);
        }
        {
            TypeIdentifierPair type_ids_vendorId;
            ReturnCode_t return_code_vendorId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_vendorId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::VendorId_t", type_ids_vendorId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_vendorId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_VendorId_t_type_identifier(type_ids_vendorId);
            }
            StructMemberFlag member_flags_vendorId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_vendorId = 0x00000002;
            bool common_vendorId_ec {false};
            CommonStructMember common_vendorId {TypeObjectUtils::build_common_struct_member(member_id_vendorId, member_flags_vendorId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_vendorId, common_vendorId_ec))};
            if (!common_vendorId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure vendorId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_vendorId = "vendorId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_vendorId;
            ann_custom_Header.reset();
            CompleteMemberDetail detail_vendorId = TypeObjectUtils::build_complete_member_detail(name_vendorId, member_ann_builtin_vendorId, ann_custom_Header);
            CompleteStructMember member_vendorId = TypeObjectUtils::build_complete_struct_member(common_vendorId, detail_vendorId);
            TypeObjectUtils::add_complete_struct_member(member_seq_Header, member_vendorId);
        }
        {
            TypeIdentifierPair type_ids_guidPrefix;
            ReturnCode_t return_code_guidPrefix {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guidPrefix =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::GuidPrefix_t", type_ids_guidPrefix);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guidPrefix)
            {
                ::eprosima::fastdds::rtps::core::detail::register_GuidPrefix_t_type_identifier(type_ids_guidPrefix);
            }
            StructMemberFlag member_flags_guidPrefix = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_guidPrefix = 0x00000003;
            bool common_guidPrefix_ec {false};
            CommonStructMember common_guidPrefix {TypeObjectUtils::build_common_struct_member(member_id_guidPrefix, member_flags_guidPrefix, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guidPrefix, common_guidPrefix_ec))};
            if (!common_guidPrefix_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guidPrefix member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guidPrefix = "guidPrefix";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guidPrefix;
            ann_custom_Header.reset();
            CompleteMemberDetail detail_guidPrefix = TypeObjectUtils::build_complete_member_detail(name_guidPrefix, member_ann_builtin_guidPrefix, ann_custom_Header);
            CompleteStructMember member_guidPrefix = TypeObjectUtils::build_complete_struct_member(common_guidPrefix, detail_guidPrefix);
            TypeObjectUtils::add_complete_struct_member(member_seq_Header, member_guidPrefix);
        }
        CompleteStructType struct_type_Header = TypeObjectUtils::build_complete_struct_type(struct_flags_Header, header_Header, member_seq_Header);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Header, type_name_Header.to_string(), type_ids_Header))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::Header already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SubmessageHeader_type_identifier(
        TypeIdentifierPair& type_ids_SubmessageHeader)
{

    ReturnCode_t return_code_SubmessageHeader {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SubmessageHeader =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_SubmessageHeader);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SubmessageHeader)
    {
        StructTypeFlag struct_flags_SubmessageHeader = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SubmessageHeader = "eprosima::fastdds::rtps::core::SubmessageHeader";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SubmessageHeader;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SubmessageHeader;
        CompleteTypeDetail detail_SubmessageHeader = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SubmessageHeader, ann_custom_SubmessageHeader, type_name_SubmessageHeader.to_string());
        CompleteStructHeader header_SubmessageHeader;
        header_SubmessageHeader = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SubmessageHeader);
        CompleteStructMemberSeq member_seq_SubmessageHeader;
        {
            TypeIdentifierPair type_ids_submessageId;
            ReturnCode_t return_code_submessageId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submessageId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_submessageId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submessageId)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "submessageId Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_submessageId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submessageId = 0x00000000;
            bool common_submessageId_ec {false};
            CommonStructMember common_submessageId {TypeObjectUtils::build_common_struct_member(member_id_submessageId, member_flags_submessageId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submessageId, common_submessageId_ec))};
            if (!common_submessageId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submessageId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submessageId = "submessageId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submessageId;
            ann_custom_SubmessageHeader.reset();
            CompleteMemberDetail detail_submessageId = TypeObjectUtils::build_complete_member_detail(name_submessageId, member_ann_builtin_submessageId, ann_custom_SubmessageHeader);
            CompleteStructMember member_submessageId = TypeObjectUtils::build_complete_struct_member(common_submessageId, detail_submessageId);
            TypeObjectUtils::add_complete_struct_member(member_seq_SubmessageHeader, member_submessageId);
        }
        {
            TypeIdentifierPair type_ids_flags;
            ReturnCode_t return_code_flags {eprosima::fastdds::dds::RETCODE_OK};
            return_code_flags =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_flags);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_flags)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "flags Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_flags = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_flags = 0x00000001;
            bool common_flags_ec {false};
            CommonStructMember common_flags {TypeObjectUtils::build_common_struct_member(member_id_flags, member_flags_flags, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_flags, common_flags_ec))};
            if (!common_flags_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure flags member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_flags = "flags";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flags;
            ann_custom_SubmessageHeader.reset();
            CompleteMemberDetail detail_flags = TypeObjectUtils::build_complete_member_detail(name_flags, member_ann_builtin_flags, ann_custom_SubmessageHeader);
            CompleteStructMember member_flags = TypeObjectUtils::build_complete_struct_member(common_flags, detail_flags);
            TypeObjectUtils::add_complete_struct_member(member_seq_SubmessageHeader, member_flags);
        }
        {
            TypeIdentifierPair type_ids_submessageLength;
            ReturnCode_t return_code_submessageLength {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submessageLength =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_submessageLength);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submessageLength)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "submessageLength Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_submessageLength = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submessageLength = 0x00000002;
            bool common_submessageLength_ec {false};
            CommonStructMember common_submessageLength {TypeObjectUtils::build_common_struct_member(member_id_submessageLength, member_flags_submessageLength, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submessageLength, common_submessageLength_ec))};
            if (!common_submessageLength_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submessageLength member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submessageLength = "submessageLength";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submessageLength;
            ann_custom_SubmessageHeader.reset();
            CompleteMemberDetail detail_submessageLength = TypeObjectUtils::build_complete_member_detail(name_submessageLength, member_ann_builtin_submessageLength, ann_custom_SubmessageHeader);
            CompleteStructMember member_submessageLength = TypeObjectUtils::build_complete_struct_member(common_submessageLength, detail_submessageLength);
            TypeObjectUtils::add_complete_struct_member(member_seq_SubmessageHeader, member_submessageLength);
        }
        CompleteStructType struct_type_SubmessageHeader = TypeObjectUtils::build_complete_struct_type(struct_flags_SubmessageHeader, header_SubmessageHeader, member_seq_SubmessageHeader);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SubmessageHeader, type_name_SubmessageHeader.to_string(), type_ids_SubmessageHeader))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::SubmessageHeader already registered in TypeObjectRegistry for a different type.");
        }
    }
}namespace SubmessageKind {
} // namespace SubmessageKind
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AckNackSubmessage_type_identifier(
        TypeIdentifierPair& type_ids_AckNackSubmessage)
{

    ReturnCode_t return_code_AckNackSubmessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AckNackSubmessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::AckNackSubmessage", type_ids_AckNackSubmessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AckNackSubmessage)
    {
        StructTypeFlag struct_flags_AckNackSubmessage = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AckNackSubmessage = "eprosima::fastdds::rtps::core::AckNackSubmessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AckNackSubmessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AckNackSubmessage;
        CompleteTypeDetail detail_AckNackSubmessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AckNackSubmessage, ann_custom_AckNackSubmessage, type_name_AckNackSubmessage.to_string());
        CompleteStructHeader header_AckNackSubmessage;
        header_AckNackSubmessage = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AckNackSubmessage);
        CompleteStructMemberSeq member_seq_AckNackSubmessage;
        {
            TypeIdentifierPair type_ids_submsgHeader;
            ReturnCode_t return_code_submsgHeader {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submsgHeader =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_submsgHeader);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submsgHeader)
            {
                ::eprosima::fastdds::rtps::core::register_SubmessageHeader_type_identifier(type_ids_submsgHeader);
            }
            StructMemberFlag member_flags_submsgHeader = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submsgHeader = 0x00000000;
            bool common_submsgHeader_ec {false};
            CommonStructMember common_submsgHeader {TypeObjectUtils::build_common_struct_member(member_id_submsgHeader, member_flags_submsgHeader, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submsgHeader, common_submsgHeader_ec))};
            if (!common_submsgHeader_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submsgHeader member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submsgHeader = "submsgHeader";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submsgHeader;
            ann_custom_AckNackSubmessage.reset();
            CompleteMemberDetail detail_submsgHeader = TypeObjectUtils::build_complete_member_detail(name_submsgHeader, member_ann_builtin_submsgHeader, ann_custom_AckNackSubmessage);
            CompleteStructMember member_submsgHeader = TypeObjectUtils::build_complete_struct_member(common_submsgHeader, detail_submsgHeader);
            TypeObjectUtils::add_complete_struct_member(member_seq_AckNackSubmessage, member_submsgHeader);
        }
        {
            TypeIdentifierPair type_ids_readerId;
            ReturnCode_t return_code_readerId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_readerId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::EntityId_t", type_ids_readerId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_readerId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_EntityId_t_type_identifier(type_ids_readerId);
            }
            StructMemberFlag member_flags_readerId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_readerId = 0x00000001;
            bool common_readerId_ec {false};
            CommonStructMember common_readerId {TypeObjectUtils::build_common_struct_member(member_id_readerId, member_flags_readerId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_readerId, common_readerId_ec))};
            if (!common_readerId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure readerId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_readerId = "readerId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_readerId;
            ann_custom_AckNackSubmessage.reset();
            CompleteMemberDetail detail_readerId = TypeObjectUtils::build_complete_member_detail(name_readerId, member_ann_builtin_readerId, ann_custom_AckNackSubmessage);
            CompleteStructMember member_readerId = TypeObjectUtils::build_complete_struct_member(common_readerId, detail_readerId);
            TypeObjectUtils::add_complete_struct_member(member_seq_AckNackSubmessage, member_readerId);
        }
        {
            TypeIdentifierPair type_ids_writerId;
            ReturnCode_t return_code_writerId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_writerId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::EntityId_t", type_ids_writerId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_writerId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_EntityId_t_type_identifier(type_ids_writerId);
            }
            StructMemberFlag member_flags_writerId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_writerId = 0x00000002;
            bool common_writerId_ec {false};
            CommonStructMember common_writerId {TypeObjectUtils::build_common_struct_member(member_id_writerId, member_flags_writerId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_writerId, common_writerId_ec))};
            if (!common_writerId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure writerId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_writerId = "writerId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_writerId;
            ann_custom_AckNackSubmessage.reset();
            CompleteMemberDetail detail_writerId = TypeObjectUtils::build_complete_member_detail(name_writerId, member_ann_builtin_writerId, ann_custom_AckNackSubmessage);
            CompleteStructMember member_writerId = TypeObjectUtils::build_complete_struct_member(common_writerId, detail_writerId);
            TypeObjectUtils::add_complete_struct_member(member_seq_AckNackSubmessage, member_writerId);
        }
        {
            TypeIdentifierPair type_ids_readerSNState;
            ReturnCode_t return_code_readerSNState {eprosima::fastdds::dds::RETCODE_OK};
            return_code_readerSNState =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::SequenceNumberSet", type_ids_readerSNState);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_readerSNState)
            {
                ::eprosima::fastdds::rtps::core::detail::register_SequenceNumberSet_type_identifier(type_ids_readerSNState);
            }
            StructMemberFlag member_flags_readerSNState = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_readerSNState = 0x00000003;
            bool common_readerSNState_ec {false};
            CommonStructMember common_readerSNState {TypeObjectUtils::build_common_struct_member(member_id_readerSNState, member_flags_readerSNState, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_readerSNState, common_readerSNState_ec))};
            if (!common_readerSNState_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure readerSNState member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_readerSNState = "readerSNState";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_readerSNState;
            ann_custom_AckNackSubmessage.reset();
            CompleteMemberDetail detail_readerSNState = TypeObjectUtils::build_complete_member_detail(name_readerSNState, member_ann_builtin_readerSNState, ann_custom_AckNackSubmessage);
            CompleteStructMember member_readerSNState = TypeObjectUtils::build_complete_struct_member(common_readerSNState, detail_readerSNState);
            TypeObjectUtils::add_complete_struct_member(member_seq_AckNackSubmessage, member_readerSNState);
        }
        {
            TypeIdentifierPair type_ids_count;
            ReturnCode_t return_code_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::Count_t", type_ids_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_count)
            {
                ::eprosima::fastdds::rtps::core::detail::register_Count_t_type_identifier(type_ids_count);
            }
            StructMemberFlag member_flags_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_count = 0x00000004;
            bool common_count_ec {false};
            CommonStructMember common_count {TypeObjectUtils::build_common_struct_member(member_id_count, member_flags_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_count, common_count_ec))};
            if (!common_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_count = "count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_count;
            ann_custom_AckNackSubmessage.reset();
            CompleteMemberDetail detail_count = TypeObjectUtils::build_complete_member_detail(name_count, member_ann_builtin_count, ann_custom_AckNackSubmessage);
            CompleteStructMember member_count = TypeObjectUtils::build_complete_struct_member(common_count, detail_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_AckNackSubmessage, member_count);
        }
        CompleteStructType struct_type_AckNackSubmessage = TypeObjectUtils::build_complete_struct_type(struct_flags_AckNackSubmessage, header_AckNackSubmessage, member_seq_AckNackSubmessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AckNackSubmessage, type_name_AckNackSubmessage.to_string(), type_ids_AckNackSubmessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::AckNackSubmessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_HeartBeatSubmessage_type_identifier(
        TypeIdentifierPair& type_ids_HeartBeatSubmessage)
{

    ReturnCode_t return_code_HeartBeatSubmessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_HeartBeatSubmessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::HeartBeatSubmessage", type_ids_HeartBeatSubmessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_HeartBeatSubmessage)
    {
        StructTypeFlag struct_flags_HeartBeatSubmessage = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_HeartBeatSubmessage = "eprosima::fastdds::rtps::core::HeartBeatSubmessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_HeartBeatSubmessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_HeartBeatSubmessage;
        CompleteTypeDetail detail_HeartBeatSubmessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_HeartBeatSubmessage, ann_custom_HeartBeatSubmessage, type_name_HeartBeatSubmessage.to_string());
        CompleteStructHeader header_HeartBeatSubmessage;
        header_HeartBeatSubmessage = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_HeartBeatSubmessage);
        CompleteStructMemberSeq member_seq_HeartBeatSubmessage;
        {
            TypeIdentifierPair type_ids_submsgHeader;
            ReturnCode_t return_code_submsgHeader {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submsgHeader =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_submsgHeader);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submsgHeader)
            {
                ::eprosima::fastdds::rtps::core::register_SubmessageHeader_type_identifier(type_ids_submsgHeader);
            }
            StructMemberFlag member_flags_submsgHeader = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submsgHeader = 0x00000000;
            bool common_submsgHeader_ec {false};
            CommonStructMember common_submsgHeader {TypeObjectUtils::build_common_struct_member(member_id_submsgHeader, member_flags_submsgHeader, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submsgHeader, common_submsgHeader_ec))};
            if (!common_submsgHeader_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submsgHeader member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submsgHeader = "submsgHeader";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submsgHeader;
            ann_custom_HeartBeatSubmessage.reset();
            CompleteMemberDetail detail_submsgHeader = TypeObjectUtils::build_complete_member_detail(name_submsgHeader, member_ann_builtin_submsgHeader, ann_custom_HeartBeatSubmessage);
            CompleteStructMember member_submsgHeader = TypeObjectUtils::build_complete_struct_member(common_submsgHeader, detail_submsgHeader);
            TypeObjectUtils::add_complete_struct_member(member_seq_HeartBeatSubmessage, member_submsgHeader);
        }
        {
            TypeIdentifierPair type_ids_readerId;
            ReturnCode_t return_code_readerId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_readerId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::EntityId_t", type_ids_readerId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_readerId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_EntityId_t_type_identifier(type_ids_readerId);
            }
            StructMemberFlag member_flags_readerId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_readerId = 0x00000001;
            bool common_readerId_ec {false};
            CommonStructMember common_readerId {TypeObjectUtils::build_common_struct_member(member_id_readerId, member_flags_readerId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_readerId, common_readerId_ec))};
            if (!common_readerId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure readerId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_readerId = "readerId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_readerId;
            ann_custom_HeartBeatSubmessage.reset();
            CompleteMemberDetail detail_readerId = TypeObjectUtils::build_complete_member_detail(name_readerId, member_ann_builtin_readerId, ann_custom_HeartBeatSubmessage);
            CompleteStructMember member_readerId = TypeObjectUtils::build_complete_struct_member(common_readerId, detail_readerId);
            TypeObjectUtils::add_complete_struct_member(member_seq_HeartBeatSubmessage, member_readerId);
        }
        {
            TypeIdentifierPair type_ids_writerId;
            ReturnCode_t return_code_writerId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_writerId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::EntityId_t", type_ids_writerId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_writerId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_EntityId_t_type_identifier(type_ids_writerId);
            }
            StructMemberFlag member_flags_writerId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_writerId = 0x00000002;
            bool common_writerId_ec {false};
            CommonStructMember common_writerId {TypeObjectUtils::build_common_struct_member(member_id_writerId, member_flags_writerId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_writerId, common_writerId_ec))};
            if (!common_writerId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure writerId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_writerId = "writerId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_writerId;
            ann_custom_HeartBeatSubmessage.reset();
            CompleteMemberDetail detail_writerId = TypeObjectUtils::build_complete_member_detail(name_writerId, member_ann_builtin_writerId, ann_custom_HeartBeatSubmessage);
            CompleteStructMember member_writerId = TypeObjectUtils::build_complete_struct_member(common_writerId, detail_writerId);
            TypeObjectUtils::add_complete_struct_member(member_seq_HeartBeatSubmessage, member_writerId);
        }
        {
            TypeIdentifierPair type_ids_firstSN;
            ReturnCode_t return_code_firstSN {eprosima::fastdds::dds::RETCODE_OK};
            return_code_firstSN =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::SequenceNumber_t", type_ids_firstSN);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_firstSN)
            {
                ::eprosima::fastdds::rtps::core::detail::register_SequenceNumber_t_type_identifier(type_ids_firstSN);
            }
            StructMemberFlag member_flags_firstSN = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_firstSN = 0x00000003;
            bool common_firstSN_ec {false};
            CommonStructMember common_firstSN {TypeObjectUtils::build_common_struct_member(member_id_firstSN, member_flags_firstSN, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_firstSN, common_firstSN_ec))};
            if (!common_firstSN_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure firstSN member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_firstSN = "firstSN";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_firstSN;
            ann_custom_HeartBeatSubmessage.reset();
            CompleteMemberDetail detail_firstSN = TypeObjectUtils::build_complete_member_detail(name_firstSN, member_ann_builtin_firstSN, ann_custom_HeartBeatSubmessage);
            CompleteStructMember member_firstSN = TypeObjectUtils::build_complete_struct_member(common_firstSN, detail_firstSN);
            TypeObjectUtils::add_complete_struct_member(member_seq_HeartBeatSubmessage, member_firstSN);
        }
        {
            TypeIdentifierPair type_ids_lastSN;
            ReturnCode_t return_code_lastSN {eprosima::fastdds::dds::RETCODE_OK};
            return_code_lastSN =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::SequenceNumber_t", type_ids_lastSN);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_lastSN)
            {
                ::eprosima::fastdds::rtps::core::detail::register_SequenceNumber_t_type_identifier(type_ids_lastSN);
            }
            StructMemberFlag member_flags_lastSN = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_lastSN = 0x00000004;
            bool common_lastSN_ec {false};
            CommonStructMember common_lastSN {TypeObjectUtils::build_common_struct_member(member_id_lastSN, member_flags_lastSN, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_lastSN, common_lastSN_ec))};
            if (!common_lastSN_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure lastSN member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_lastSN = "lastSN";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_lastSN;
            ann_custom_HeartBeatSubmessage.reset();
            CompleteMemberDetail detail_lastSN = TypeObjectUtils::build_complete_member_detail(name_lastSN, member_ann_builtin_lastSN, ann_custom_HeartBeatSubmessage);
            CompleteStructMember member_lastSN = TypeObjectUtils::build_complete_struct_member(common_lastSN, detail_lastSN);
            TypeObjectUtils::add_complete_struct_member(member_seq_HeartBeatSubmessage, member_lastSN);
        }
        {
            TypeIdentifierPair type_ids_count;
            ReturnCode_t return_code_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::Count_t", type_ids_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_count)
            {
                ::eprosima::fastdds::rtps::core::detail::register_Count_t_type_identifier(type_ids_count);
            }
            StructMemberFlag member_flags_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_count = 0x00000005;
            bool common_count_ec {false};
            CommonStructMember common_count {TypeObjectUtils::build_common_struct_member(member_id_count, member_flags_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_count, common_count_ec))};
            if (!common_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_count = "count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_count;
            ann_custom_HeartBeatSubmessage.reset();
            CompleteMemberDetail detail_count = TypeObjectUtils::build_complete_member_detail(name_count, member_ann_builtin_count, ann_custom_HeartBeatSubmessage);
            CompleteStructMember member_count = TypeObjectUtils::build_complete_struct_member(common_count, detail_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_HeartBeatSubmessage, member_count);
        }
        CompleteStructType struct_type_HeartBeatSubmessage = TypeObjectUtils::build_complete_struct_type(struct_flags_HeartBeatSubmessage, header_HeartBeatSubmessage, member_seq_HeartBeatSubmessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_HeartBeatSubmessage, type_name_HeartBeatSubmessage.to_string(), type_ids_HeartBeatSubmessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::HeartBeatSubmessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InfoDestinationSubmessage_type_identifier(
        TypeIdentifierPair& type_ids_InfoDestinationSubmessage)
{

    ReturnCode_t return_code_InfoDestinationSubmessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InfoDestinationSubmessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::InfoDestinationSubmessage", type_ids_InfoDestinationSubmessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InfoDestinationSubmessage)
    {
        StructTypeFlag struct_flags_InfoDestinationSubmessage = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_InfoDestinationSubmessage = "eprosima::fastdds::rtps::core::InfoDestinationSubmessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InfoDestinationSubmessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InfoDestinationSubmessage;
        CompleteTypeDetail detail_InfoDestinationSubmessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InfoDestinationSubmessage, ann_custom_InfoDestinationSubmessage, type_name_InfoDestinationSubmessage.to_string());
        CompleteStructHeader header_InfoDestinationSubmessage;
        header_InfoDestinationSubmessage = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_InfoDestinationSubmessage);
        CompleteStructMemberSeq member_seq_InfoDestinationSubmessage;
        {
            TypeIdentifierPair type_ids_submsgHeader;
            ReturnCode_t return_code_submsgHeader {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submsgHeader =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_submsgHeader);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submsgHeader)
            {
                ::eprosima::fastdds::rtps::core::register_SubmessageHeader_type_identifier(type_ids_submsgHeader);
            }
            StructMemberFlag member_flags_submsgHeader = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submsgHeader = 0x00000000;
            bool common_submsgHeader_ec {false};
            CommonStructMember common_submsgHeader {TypeObjectUtils::build_common_struct_member(member_id_submsgHeader, member_flags_submsgHeader, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submsgHeader, common_submsgHeader_ec))};
            if (!common_submsgHeader_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submsgHeader member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submsgHeader = "submsgHeader";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submsgHeader;
            ann_custom_InfoDestinationSubmessage.reset();
            CompleteMemberDetail detail_submsgHeader = TypeObjectUtils::build_complete_member_detail(name_submsgHeader, member_ann_builtin_submsgHeader, ann_custom_InfoDestinationSubmessage);
            CompleteStructMember member_submsgHeader = TypeObjectUtils::build_complete_struct_member(common_submsgHeader, detail_submsgHeader);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoDestinationSubmessage, member_submsgHeader);
        }
        {
            TypeIdentifierPair type_ids_guidPrefix;
            ReturnCode_t return_code_guidPrefix {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guidPrefix =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::GuidPrefix_t", type_ids_guidPrefix);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guidPrefix)
            {
                ::eprosima::fastdds::rtps::core::detail::register_GuidPrefix_t_type_identifier(type_ids_guidPrefix);
            }
            StructMemberFlag member_flags_guidPrefix = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_guidPrefix = 0x00000001;
            bool common_guidPrefix_ec {false};
            CommonStructMember common_guidPrefix {TypeObjectUtils::build_common_struct_member(member_id_guidPrefix, member_flags_guidPrefix, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guidPrefix, common_guidPrefix_ec))};
            if (!common_guidPrefix_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guidPrefix member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guidPrefix = "guidPrefix";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guidPrefix;
            ann_custom_InfoDestinationSubmessage.reset();
            CompleteMemberDetail detail_guidPrefix = TypeObjectUtils::build_complete_member_detail(name_guidPrefix, member_ann_builtin_guidPrefix, ann_custom_InfoDestinationSubmessage);
            CompleteStructMember member_guidPrefix = TypeObjectUtils::build_complete_struct_member(common_guidPrefix, detail_guidPrefix);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoDestinationSubmessage, member_guidPrefix);
        }
        CompleteStructType struct_type_InfoDestinationSubmessage = TypeObjectUtils::build_complete_struct_type(struct_flags_InfoDestinationSubmessage, header_InfoDestinationSubmessage, member_seq_InfoDestinationSubmessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InfoDestinationSubmessage, type_name_InfoDestinationSubmessage.to_string(), type_ids_InfoDestinationSubmessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::InfoDestinationSubmessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InfoSourceSubmessage_type_identifier(
        TypeIdentifierPair& type_ids_InfoSourceSubmessage)
{

    ReturnCode_t return_code_InfoSourceSubmessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InfoSourceSubmessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::InfoSourceSubmessage", type_ids_InfoSourceSubmessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InfoSourceSubmessage)
    {
        StructTypeFlag struct_flags_InfoSourceSubmessage = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_InfoSourceSubmessage = "eprosima::fastdds::rtps::core::InfoSourceSubmessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InfoSourceSubmessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InfoSourceSubmessage;
        CompleteTypeDetail detail_InfoSourceSubmessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InfoSourceSubmessage, ann_custom_InfoSourceSubmessage, type_name_InfoSourceSubmessage.to_string());
        CompleteStructHeader header_InfoSourceSubmessage;
        header_InfoSourceSubmessage = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_InfoSourceSubmessage);
        CompleteStructMemberSeq member_seq_InfoSourceSubmessage;
        {
            TypeIdentifierPair type_ids_submsgHeader;
            ReturnCode_t return_code_submsgHeader {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submsgHeader =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_submsgHeader);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submsgHeader)
            {
                ::eprosima::fastdds::rtps::core::register_SubmessageHeader_type_identifier(type_ids_submsgHeader);
            }
            StructMemberFlag member_flags_submsgHeader = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submsgHeader = 0x00000000;
            bool common_submsgHeader_ec {false};
            CommonStructMember common_submsgHeader {TypeObjectUtils::build_common_struct_member(member_id_submsgHeader, member_flags_submsgHeader, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submsgHeader, common_submsgHeader_ec))};
            if (!common_submsgHeader_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submsgHeader member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submsgHeader = "submsgHeader";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submsgHeader;
            ann_custom_InfoSourceSubmessage.reset();
            CompleteMemberDetail detail_submsgHeader = TypeObjectUtils::build_complete_member_detail(name_submsgHeader, member_ann_builtin_submsgHeader, ann_custom_InfoSourceSubmessage);
            CompleteStructMember member_submsgHeader = TypeObjectUtils::build_complete_struct_member(common_submsgHeader, detail_submsgHeader);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoSourceSubmessage, member_submsgHeader);
        }
        {
            TypeIdentifierPair type_ids_unused;
            ReturnCode_t return_code_unused {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unused =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_unused);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unused)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "unused Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_unused = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unused = 0x00000001;
            bool common_unused_ec {false};
            CommonStructMember common_unused {TypeObjectUtils::build_common_struct_member(member_id_unused, member_flags_unused, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unused, common_unused_ec))};
            if (!common_unused_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unused member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unused = "unused";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unused;
            ann_custom_InfoSourceSubmessage.reset();
            CompleteMemberDetail detail_unused = TypeObjectUtils::build_complete_member_detail(name_unused, member_ann_builtin_unused, ann_custom_InfoSourceSubmessage);
            CompleteStructMember member_unused = TypeObjectUtils::build_complete_struct_member(common_unused, detail_unused);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoSourceSubmessage, member_unused);
        }
        {
            TypeIdentifierPair type_ids_version;
            ReturnCode_t return_code_version {eprosima::fastdds::dds::RETCODE_OK};
            return_code_version =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::ProtocolVersion_t", type_ids_version);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_version)
            {
                ::eprosima::fastdds::rtps::core::detail::register_ProtocolVersion_t_type_identifier(type_ids_version);
            }
            StructMemberFlag member_flags_version = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_version = 0x00000002;
            bool common_version_ec {false};
            CommonStructMember common_version {TypeObjectUtils::build_common_struct_member(member_id_version, member_flags_version, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_version, common_version_ec))};
            if (!common_version_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure version member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_version = "version";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_version;
            ann_custom_InfoSourceSubmessage.reset();
            CompleteMemberDetail detail_version = TypeObjectUtils::build_complete_member_detail(name_version, member_ann_builtin_version, ann_custom_InfoSourceSubmessage);
            CompleteStructMember member_version = TypeObjectUtils::build_complete_struct_member(common_version, detail_version);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoSourceSubmessage, member_version);
        }
        {
            TypeIdentifierPair type_ids_vendorId;
            ReturnCode_t return_code_vendorId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_vendorId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::VendorId_t", type_ids_vendorId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_vendorId)
            {
                ::eprosima::fastdds::rtps::core::detail::register_VendorId_t_type_identifier(type_ids_vendorId);
            }
            StructMemberFlag member_flags_vendorId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_vendorId = 0x00000003;
            bool common_vendorId_ec {false};
            CommonStructMember common_vendorId {TypeObjectUtils::build_common_struct_member(member_id_vendorId, member_flags_vendorId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_vendorId, common_vendorId_ec))};
            if (!common_vendorId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure vendorId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_vendorId = "vendorId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_vendorId;
            ann_custom_InfoSourceSubmessage.reset();
            CompleteMemberDetail detail_vendorId = TypeObjectUtils::build_complete_member_detail(name_vendorId, member_ann_builtin_vendorId, ann_custom_InfoSourceSubmessage);
            CompleteStructMember member_vendorId = TypeObjectUtils::build_complete_struct_member(common_vendorId, detail_vendorId);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoSourceSubmessage, member_vendorId);
        }
        {
            TypeIdentifierPair type_ids_guidPrefix;
            ReturnCode_t return_code_guidPrefix {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guidPrefix =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::GuidPrefix_t", type_ids_guidPrefix);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guidPrefix)
            {
                ::eprosima::fastdds::rtps::core::detail::register_GuidPrefix_t_type_identifier(type_ids_guidPrefix);
            }
            StructMemberFlag member_flags_guidPrefix = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_guidPrefix = 0x00000004;
            bool common_guidPrefix_ec {false};
            CommonStructMember common_guidPrefix {TypeObjectUtils::build_common_struct_member(member_id_guidPrefix, member_flags_guidPrefix, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guidPrefix, common_guidPrefix_ec))};
            if (!common_guidPrefix_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guidPrefix member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guidPrefix = "guidPrefix";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guidPrefix;
            ann_custom_InfoSourceSubmessage.reset();
            CompleteMemberDetail detail_guidPrefix = TypeObjectUtils::build_complete_member_detail(name_guidPrefix, member_ann_builtin_guidPrefix, ann_custom_InfoSourceSubmessage);
            CompleteStructMember member_guidPrefix = TypeObjectUtils::build_complete_struct_member(common_guidPrefix, detail_guidPrefix);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoSourceSubmessage, member_guidPrefix);
        }
        CompleteStructType struct_type_InfoSourceSubmessage = TypeObjectUtils::build_complete_struct_type(struct_flags_InfoSourceSubmessage, header_InfoSourceSubmessage, member_seq_InfoSourceSubmessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InfoSourceSubmessage, type_name_InfoSourceSubmessage.to_string(), type_ids_InfoSourceSubmessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::InfoSourceSubmessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InfoTimestampSubmessage_type_identifier(
        TypeIdentifierPair& type_ids_InfoTimestampSubmessage)
{

    ReturnCode_t return_code_InfoTimestampSubmessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InfoTimestampSubmessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::InfoTimestampSubmessage", type_ids_InfoTimestampSubmessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InfoTimestampSubmessage)
    {
        StructTypeFlag struct_flags_InfoTimestampSubmessage = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_InfoTimestampSubmessage = "eprosima::fastdds::rtps::core::InfoTimestampSubmessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InfoTimestampSubmessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InfoTimestampSubmessage;
        CompleteTypeDetail detail_InfoTimestampSubmessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InfoTimestampSubmessage, ann_custom_InfoTimestampSubmessage, type_name_InfoTimestampSubmessage.to_string());
        CompleteStructHeader header_InfoTimestampSubmessage;
        header_InfoTimestampSubmessage = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_InfoTimestampSubmessage);
        CompleteStructMemberSeq member_seq_InfoTimestampSubmessage;
        {
            TypeIdentifierPair type_ids_submsgHeader;
            ReturnCode_t return_code_submsgHeader {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submsgHeader =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_submsgHeader);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submsgHeader)
            {
                ::eprosima::fastdds::rtps::core::register_SubmessageHeader_type_identifier(type_ids_submsgHeader);
            }
            StructMemberFlag member_flags_submsgHeader = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submsgHeader = 0x00000000;
            bool common_submsgHeader_ec {false};
            CommonStructMember common_submsgHeader {TypeObjectUtils::build_common_struct_member(member_id_submsgHeader, member_flags_submsgHeader, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submsgHeader, common_submsgHeader_ec))};
            if (!common_submsgHeader_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submsgHeader member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submsgHeader = "submsgHeader";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submsgHeader;
            ann_custom_InfoTimestampSubmessage.reset();
            CompleteMemberDetail detail_submsgHeader = TypeObjectUtils::build_complete_member_detail(name_submsgHeader, member_ann_builtin_submsgHeader, ann_custom_InfoTimestampSubmessage);
            CompleteStructMember member_submsgHeader = TypeObjectUtils::build_complete_struct_member(common_submsgHeader, detail_submsgHeader);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoTimestampSubmessage, member_submsgHeader);
        }
        {
            TypeIdentifierPair type_ids_timestamp;
            ReturnCode_t return_code_timestamp {eprosima::fastdds::dds::RETCODE_OK};
            return_code_timestamp =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::detail::Timestamp", type_ids_timestamp);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_timestamp)
            {
                ::eprosima::fastdds::rtps::core::detail::register_Timestamp_type_identifier(type_ids_timestamp);
            }
            StructMemberFlag member_flags_timestamp = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_timestamp = 0x00000001;
            bool common_timestamp_ec {false};
            CommonStructMember common_timestamp {TypeObjectUtils::build_common_struct_member(member_id_timestamp, member_flags_timestamp, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_timestamp, common_timestamp_ec))};
            if (!common_timestamp_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure timestamp member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_timestamp = "timestamp";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_timestamp;
            ann_custom_InfoTimestampSubmessage.reset();
            CompleteMemberDetail detail_timestamp = TypeObjectUtils::build_complete_member_detail(name_timestamp, member_ann_builtin_timestamp, ann_custom_InfoTimestampSubmessage);
            CompleteStructMember member_timestamp = TypeObjectUtils::build_complete_struct_member(common_timestamp, detail_timestamp);
            TypeObjectUtils::add_complete_struct_member(member_seq_InfoTimestampSubmessage, member_timestamp);
        }
        CompleteStructType struct_type_InfoTimestampSubmessage = TypeObjectUtils::build_complete_struct_type(struct_flags_InfoTimestampSubmessage, header_InfoTimestampSubmessage, member_seq_InfoTimestampSubmessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InfoTimestampSubmessage, type_name_InfoTimestampSubmessage.to_string(), type_ids_InfoTimestampSubmessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::InfoTimestampSubmessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Submessage_type_identifier(
        TypeIdentifierPair& type_ids_Submessage)
{
    ReturnCode_t return_code_Submessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Submessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::Submessage", type_ids_Submessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Submessage)
    {
        UnionTypeFlag union_flags_Submessage = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Submessage = "eprosima::fastdds::rtps::core::Submessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Submessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Submessage;
        CompleteTypeDetail detail_Submessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Submessage, ann_custom_Submessage, type_name_Submessage.to_string());
        CompleteUnionHeader header_Submessage = TypeObjectUtils::build_complete_union_header(detail_Submessage);
        UnionDiscriminatorFlag member_flags_Submessage = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Submessage =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_char", type_ids_Submessage);

        if (return_code_Submessage != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Submessage;
        if (EK_COMPLETE == type_ids_Submessage.type_identifier1()._d() || TK_NONE == type_ids_Submessage.type_identifier2()._d())
        {
            common_Submessage = TypeObjectUtils::build_common_discriminator_member(member_flags_Submessage, type_ids_Submessage.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Submessage.type_identifier2()._d())
        {
            common_Submessage = TypeObjectUtils::build_common_discriminator_member(member_flags_Submessage, type_ids_Submessage.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::Submessage discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Submessage.reset();
        ann_custom_Submessage.reset();
        CompleteDiscriminatorMember discriminator_Submessage = TypeObjectUtils::build_complete_discriminator_member(common_Submessage,
                type_ann_builtin_Submessage, ann_custom_Submessage);
        CompleteUnionMemberSeq member_seq_Submessage;
        {
            return_code_Submessage =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::HeartBeatSubmessage", type_ids_Submessage);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Submessage)
            {
                ::eprosima::fastdds::rtps::core::register_HeartBeatSubmessage_type_identifier(type_ids_Submessage);
            }
            UnionMemberFlag member_flags_heartbeat_submsg = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_heartbeat_submsg;
            TypeObjectUtils::add_union_case_label(label_seq_heartbeat_submsg, static_cast<int32_t>(SubmessageKind::HEARTBEAT));
            MemberId member_id_heartbeat_submsg = 0x00000001;
            bool common_heartbeat_submsg_ec {false};
            CommonUnionMember common_heartbeat_submsg {TypeObjectUtils::build_common_union_member(member_id_heartbeat_submsg,
                    member_flags_heartbeat_submsg, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Submessage,
                        common_heartbeat_submsg_ec), label_seq_heartbeat_submsg)};
            if (!common_heartbeat_submsg_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union heartbeat_submsg member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_heartbeat_submsg = "heartbeat_submsg";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_heartbeat_submsg;
            ann_custom_Submessage.reset();
            CompleteMemberDetail detail_heartbeat_submsg = TypeObjectUtils::build_complete_member_detail(name_heartbeat_submsg, member_ann_builtin_heartbeat_submsg, ann_custom_Submessage);
            CompleteUnionMember member_heartbeat_submsg = TypeObjectUtils::build_complete_union_member(common_heartbeat_submsg, detail_heartbeat_submsg);
            TypeObjectUtils::add_complete_union_member(member_seq_Submessage, member_heartbeat_submsg);
        }
        {
            return_code_Submessage =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::InfoTimestampSubmessage", type_ids_Submessage);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Submessage)
            {
                ::eprosima::fastdds::rtps::core::register_InfoTimestampSubmessage_type_identifier(type_ids_Submessage);
            }
            UnionMemberFlag member_flags_info_ts_submsg = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_info_ts_submsg;
            TypeObjectUtils::add_union_case_label(label_seq_info_ts_submsg, static_cast<int32_t>(SubmessageKind::INFO_TS));
            MemberId member_id_info_ts_submsg = 0x00000002;
            bool common_info_ts_submsg_ec {false};
            CommonUnionMember common_info_ts_submsg {TypeObjectUtils::build_common_union_member(member_id_info_ts_submsg,
                    member_flags_info_ts_submsg, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Submessage,
                        common_info_ts_submsg_ec), label_seq_info_ts_submsg)};
            if (!common_info_ts_submsg_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union info_ts_submsg member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_info_ts_submsg = "info_ts_submsg";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_info_ts_submsg;
            ann_custom_Submessage.reset();
            CompleteMemberDetail detail_info_ts_submsg = TypeObjectUtils::build_complete_member_detail(name_info_ts_submsg, member_ann_builtin_info_ts_submsg, ann_custom_Submessage);
            CompleteUnionMember member_info_ts_submsg = TypeObjectUtils::build_complete_union_member(common_info_ts_submsg, detail_info_ts_submsg);
            TypeObjectUtils::add_complete_union_member(member_seq_Submessage, member_info_ts_submsg);
        }
        {
            return_code_Submessage =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::InfoSourceSubmessage", type_ids_Submessage);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Submessage)
            {
                ::eprosima::fastdds::rtps::core::register_InfoSourceSubmessage_type_identifier(type_ids_Submessage);
            }
            UnionMemberFlag member_flags_info_src_submsg = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_info_src_submsg;
            TypeObjectUtils::add_union_case_label(label_seq_info_src_submsg, static_cast<int32_t>(SubmessageKind::INFO_SRC));
            MemberId member_id_info_src_submsg = 0x00000003;
            bool common_info_src_submsg_ec {false};
            CommonUnionMember common_info_src_submsg {TypeObjectUtils::build_common_union_member(member_id_info_src_submsg,
                    member_flags_info_src_submsg, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Submessage,
                        common_info_src_submsg_ec), label_seq_info_src_submsg)};
            if (!common_info_src_submsg_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union info_src_submsg member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_info_src_submsg = "info_src_submsg";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_info_src_submsg;
            ann_custom_Submessage.reset();
            CompleteMemberDetail detail_info_src_submsg = TypeObjectUtils::build_complete_member_detail(name_info_src_submsg, member_ann_builtin_info_src_submsg, ann_custom_Submessage);
            CompleteUnionMember member_info_src_submsg = TypeObjectUtils::build_complete_union_member(common_info_src_submsg, detail_info_src_submsg);
            TypeObjectUtils::add_complete_union_member(member_seq_Submessage, member_info_src_submsg);
        }
        {
            return_code_Submessage =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::InfoDestinationSubmessage", type_ids_Submessage);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Submessage)
            {
                ::eprosima::fastdds::rtps::core::register_InfoDestinationSubmessage_type_identifier(type_ids_Submessage);
            }
            UnionMemberFlag member_flags_info_dst_submsg = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_info_dst_submsg;
            TypeObjectUtils::add_union_case_label(label_seq_info_dst_submsg, static_cast<int32_t>(SubmessageKind::INFO_DST));
            MemberId member_id_info_dst_submsg = 0x00000004;
            bool common_info_dst_submsg_ec {false};
            CommonUnionMember common_info_dst_submsg {TypeObjectUtils::build_common_union_member(member_id_info_dst_submsg,
                    member_flags_info_dst_submsg, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Submessage,
                        common_info_dst_submsg_ec), label_seq_info_dst_submsg)};
            if (!common_info_dst_submsg_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union info_dst_submsg member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_info_dst_submsg = "info_dst_submsg";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_info_dst_submsg;
            ann_custom_Submessage.reset();
            CompleteMemberDetail detail_info_dst_submsg = TypeObjectUtils::build_complete_member_detail(name_info_dst_submsg, member_ann_builtin_info_dst_submsg, ann_custom_Submessage);
            CompleteUnionMember member_info_dst_submsg = TypeObjectUtils::build_complete_union_member(common_info_dst_submsg, detail_info_dst_submsg);
            TypeObjectUtils::add_complete_union_member(member_seq_Submessage, member_info_dst_submsg);
        }
        {
            return_code_Submessage =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::SubmessageHeader", type_ids_Submessage);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Submessage)
            {
                ::eprosima::fastdds::rtps::core::register_SubmessageHeader_type_identifier(type_ids_Submessage);
            }
            UnionMemberFlag member_flags_unknown_submsg = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_unknown_submsg;
            MemberId member_id_unknown_submsg = 0x00000005;
            bool common_unknown_submsg_ec {false};
            CommonUnionMember common_unknown_submsg {TypeObjectUtils::build_common_union_member(member_id_unknown_submsg,
                    member_flags_unknown_submsg, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Submessage,
                        common_unknown_submsg_ec), label_seq_unknown_submsg)};
            if (!common_unknown_submsg_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union unknown_submsg member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unknown_submsg = "unknown_submsg";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unknown_submsg;
            ann_custom_Submessage.reset();
            CompleteMemberDetail detail_unknown_submsg = TypeObjectUtils::build_complete_member_detail(name_unknown_submsg, member_ann_builtin_unknown_submsg, ann_custom_Submessage);
            CompleteUnionMember member_unknown_submsg = TypeObjectUtils::build_complete_union_member(common_unknown_submsg, detail_unknown_submsg);
            TypeObjectUtils::add_complete_union_member(member_seq_Submessage, member_unknown_submsg);
        }
        CompleteUnionType union_type_Submessage = TypeObjectUtils::build_complete_union_type(union_flags_Submessage, header_Submessage, discriminator_Submessage,
                member_seq_Submessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Submessage, type_name_Submessage.to_string(), type_ids_Submessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::Submessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_RTPSMessage_type_identifier(
        TypeIdentifierPair& type_ids_RTPSMessage)
{

    ReturnCode_t return_code_RTPSMessage {eprosima::fastdds::dds::RETCODE_OK};
    return_code_RTPSMessage =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::rtps::core::RTPSMessage", type_ids_RTPSMessage);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_RTPSMessage)
    {
        StructTypeFlag struct_flags_RTPSMessage = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_RTPSMessage = "eprosima::fastdds::rtps::core::RTPSMessage";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_RTPSMessage;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_RTPSMessage;
        CompleteTypeDetail detail_RTPSMessage = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_RTPSMessage, ann_custom_RTPSMessage, type_name_RTPSMessage.to_string());
        CompleteStructHeader header_RTPSMessage;
        header_RTPSMessage = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_RTPSMessage);
        CompleteStructMemberSeq member_seq_RTPSMessage;
        {
            TypeIdentifierPair type_ids_msg_header;
            ReturnCode_t return_code_msg_header {eprosima::fastdds::dds::RETCODE_OK};
            return_code_msg_header =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::rtps::core::Header", type_ids_msg_header);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_msg_header)
            {
                ::eprosima::fastdds::rtps::core::register_Header_type_identifier(type_ids_msg_header);
            }
            StructMemberFlag member_flags_msg_header = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_msg_header = 0x00000000;
            bool common_msg_header_ec {false};
            CommonStructMember common_msg_header {TypeObjectUtils::build_common_struct_member(member_id_msg_header, member_flags_msg_header, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_msg_header, common_msg_header_ec))};
            if (!common_msg_header_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure msg_header member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_msg_header = "msg_header";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_msg_header;
            ann_custom_RTPSMessage.reset();
            CompleteMemberDetail detail_msg_header = TypeObjectUtils::build_complete_member_detail(name_msg_header, member_ann_builtin_msg_header, ann_custom_RTPSMessage);
            CompleteStructMember member_msg_header = TypeObjectUtils::build_complete_struct_member(common_msg_header, detail_msg_header);
            TypeObjectUtils::add_complete_struct_member(member_seq_RTPSMessage, member_msg_header);
        }
        {
            TypeIdentifierPair type_ids_submessages;
            ReturnCode_t return_code_submessages {eprosima::fastdds::dds::RETCODE_OK};
            return_code_submessages =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded", type_ids_submessages);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_submessages)
            {
                return_code_submessages =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "eprosima::fastdds::rtps::core::Submessage", type_ids_submessages);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_submessages)
                {
                    ::eprosima::fastdds::rtps::core::register_Submessage_type_identifier(type_ids_submessages);
                }
                bool element_identifier_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submessages, element_identifier_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_submessages.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded, element_flags_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded", type_ids_submessages))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_eprosima_fastdds_rtps_core_Submessage_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_submessages = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_submessages = 0x00000001;
            bool common_submessages_ec {false};
            CommonStructMember common_submessages {TypeObjectUtils::build_common_struct_member(member_id_submessages, member_flags_submessages, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_submessages, common_submessages_ec))};
            if (!common_submessages_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure submessages member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_submessages = "submessages";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_submessages;
            ann_custom_RTPSMessage.reset();
            CompleteMemberDetail detail_submessages = TypeObjectUtils::build_complete_member_detail(name_submessages, member_ann_builtin_submessages, ann_custom_RTPSMessage);
            CompleteStructMember member_submessages = TypeObjectUtils::build_complete_struct_member(common_submessages, detail_submessages);
            TypeObjectUtils::add_complete_struct_member(member_seq_RTPSMessage, member_submessages);
        }
        CompleteStructType struct_type_RTPSMessage = TypeObjectUtils::build_complete_struct_type(struct_flags_RTPSMessage, header_RTPSMessage, member_seq_RTPSMessage);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_RTPSMessage, type_name_RTPSMessage.to_string(), type_ids_RTPSMessage))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::rtps::core::RTPSMessage already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace core

} // namespace rtps

} // namespace fastdds

} // namespace eprosima

