/*
 * $Id: conn_usb.c,v 1.13 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_usb.h"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_usb_bus_main_merge *forward_main;
};

void *
conn_usb_create(
	const char *name,
	struct sig_manage *port_manage,

	struct sig_usb_bus *port_usb,

	struct sig_boolean *port_power,
	struct sig_usb_bus_main *port_main
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_main = sig_usb_bus_main_merge(port_usb->bus, port_main);
	cpssp->forward_power = sig_boolean_merge(port_power, port_usb->power);

	return cpssp;
}

void
conn_usb_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
conn_usb_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
conn_usb_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
