/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#include "dlgedit.h"
#include "ui_dlgedit.h"

dlgEdit::dlgEdit(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dlgEdit)
{
    ui->setupUi(this);
    QStringList s;
    sColoumn0 = "foreign";
    sColoumn1 = "native";
    ui->grid1->setHorizontalHeaderLabels(QStringList()<<sColoumn0<<sColoumn1);
    vDataInitInProgress = false;

    connect(&vTimer,SIGNAL(timeout()),this,SLOT(on_timer()));
}

dlgEdit::~dlgEdit()
{
    vDataInitInProgress = true;
    delete ui;
}

bool dlgEdit::event(QEvent *ev)
{
    if (ev->type() == QEvent::Hide)
    {
        fDestroyGrid();
        return true;
    }
    if (ev->type() == QEvent::Resize)
    {
        fCellsResize();
    }
    return QWidget::event(ev);
}

void dlgEdit::fDestroyGrid()
{
    int count = ui->grid1->rowCount();
    for (int i = 0; i < count; ++i)
    {
        for (int j = 0; j < 2; ++j)
        {
            if(ui->grid1->item(i,j)!=nullptr)
                delete ui->grid1->item(i,j);
        }
    }
}

//+++ 'topicdata' contains couples (0-foreign word, 1-native word)
void dlgEdit::EditOpen(QList<QStringList> *topicdata)
{
    TopicData = topicdata;
    int count = topicdata->count();
    vDataInitInProgress = true;
    ui->grid1->setRowCount(count);
    if (count > 0)
    {
        for (int i = 0; i < count; ++i)
        {
            for (int j = 0; j < 2; ++j)
            {
                ui->grid1->setItem(i,j,new QTableWidgetItem(topicdata->at(i)[j]));
            }
        }
        vDataInitInProgress = false;
    }
    fAddRow();
    this->show();
    fCellsResize();
    ui->lbRules->show();
    vTimer.start(25000);
}

void dlgEdit::fAddRow()
{
    vDataInitInProgress = true;
    int count = ui->grid1->rowCount();
    ui->grid1->setRowCount(count+1);
    for (int i = 0; i < 2; ++i)
    {
        ui->grid1->setItem(count,i,new QTableWidgetItem());
    }
    vDataInitInProgress = false;
}

void dlgEdit::fCellsResize()
{
    int tableWidth = ui->grid1->viewport()->width();
    ui->grid1->setColumnWidth(0,int(tableWidth/2));
    ui->grid1->setColumnWidth(1,tableWidth/2);
    ui->grid1->resizeRowsToContents();
}

void dlgEdit::GetUiText(QJsonObject *uitext)
{
    QJsonObject jobj;
    jobj.insert("coloumn0",QJsonValue(sColoumn0));
    jobj.insert("coloumn1",QJsonValue(sColoumn1));
    jobj.insert("rules",QJsonValue(ui->lbRules->text()));
    jobj.insert("save",QJsonValue(ui->pbSave->text()));
    jobj.insert("exit",QJsonValue(ui->pbExit->text()));
    uitext->insert("dlgEdit", QJsonValue(jobj));
}

void dlgEdit::SetUiText(QJsonObject *uitext)
{
    QJsonObject jobj=uitext->value("dlgEdit").toObject();
    sColoumn0 = jobj.value("coloumn0").toString();
    sColoumn1 = jobj.value("coloumn1").toString();
    ui->lbRules->setText(jobj.value("rules").toString());
    ui->pbSave->setText(jobj.value("save").toString());
    ui->pbExit->setText(jobj.value("exit").toString());
}

void dlgEdit::on_grid1_cellChanged(int row, int column)
{
    fCellsResize();
    ui->grid1->resizeRowToContents(row);
    if(vDataInitInProgress)
        return;

    if(column<1)
        ++column;
    else
    {
        ++row;
        column = 0;
    }

    if(row>=ui->grid1->rowCount())
    {
        fAddRow();
    }
    ui->grid1->setCurrentCell(row,column);
}

void dlgEdit::on_timer()
{
    ui->lbRules->hide();
}

void dlgEdit::on_pbSave_clicked()
{
    TopicData->clear();
    QStringList sl;
    int count = ui->grid1->rowCount();
    for (int i = 0; i < count; ++i)
    {
        sl.clear();
        for (int j = 0; j < 2; ++j)
        {
            sl.append(ui->grid1->item(i,j)->text());
        }
        TopicData->append(sl);
    }
    emit Savefile();
    this->hide();
}

void dlgEdit::on_pbExit_clicked()
{
    this->hide();
}
