/** @file
 * @brief HID report descriptor - option value
 *
 * Copyright (C) 2010 Nikolai Kondrashov
 *
 * This file is part of hidrd.
 *
 * Hidrd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Hidrd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hidrd; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @author Nikolai Kondrashov <spbnick@gmail.com>
 *
 * @(#) $Id: value.h 300 2010-03-23 10:00:15Z spb_nick $
 */

#ifndef __HIDRD_OPT_VALUE_H__
#define __HIDRD_OPT_VALUE_H__

#include <stdbool.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef union hidrd_opt_value {
    const char *string;     /**< String */
    bool        boolean;    /**< Boolean */
    int32_t     s32;        /**< Signed 32-bit integer */
    uint32_t    u32;        /**< Unsigned 32-bit integer */
} hidrd_opt_value;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __HIDRD_OPT_VALUE_H__ */
