/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

FilterPlugin::FilterPlugin()
{
	handle = NULL;
}

FilterPlugin::~FilterPlugin()
{
}

bool FilterPlugin::loadplugin(std::string filename)
{
	handle = dlopen(filename.c_str(), RTLD_LAZY);
	
	if (!handle)
	{
		syslog(LOG_ERR, "dlopen(): %s\n", dlerror());
		return false;
	}
	
	initfilterplugin = (initfilterplugintype) dlsym(handle, "initfilterplugin");
	closefilterplugin = (closefilterplugintype) dlsym(handle, "closefilterplugin");
	filter = (filtertype) dlsym(handle, "filter");
	
	if (!initfilterplugin || !closefilterplugin || !filter)
	{
		syslog(LOG_ERR, "%s: dlsym(): %s\n", filename.c_str(), dlerror());
		return false;
	}
	
	return true;
}

bool FilterPlugin::unloadplugin(void)
{
	if (handle) dlclose(handle);
	
	return true;
}

bool FilterPlugin::callinitfilterplugin(class Options &options, bool debugmode)
{
	return (*initfilterplugin)(filterplugininfo, options, debugmode);
}

void FilterPlugin::callclosefilterplugin(void)
{
	return (*closefilterplugin)();
}

bool FilterPlugin::callfilter(char *originalbuffer, char *modifiedbuffer, struct imevent &imevent)
{
	return (*filter)(originalbuffer, modifiedbuffer, imevent);
}
