# Contributing to Jakarta Servlet

Thanks for your interest in this project.

## Project description

Jakarta Servlet is a standard technology for interacting with the web on the
Jakarta EE platform. 

* https://projects.eclipse.org/projects/ee4j.servlet

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/ee4j.servlet/developer

The project maintains the following source code repositories

* https://github.com/eclipse-ee4j/servlet-api

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Project Contribution Guidelines

 * Code should adhere to the style defined at https://github.com/eclipse-ee4j/ee4j.
 * Contributions should be made via github pull requests at https://github.com/eclipse-ee4j/servlet-api/pulls 
 * Authors of Pull Requests should seek review from committers outside of their own organisation and perspective.
 * Committers and Contributors may review any Pull Requests or Commits, even if not requested or assigned.
 * Pull Request by Committers that receive no review responses after a reasonable time, considering time zones and working days, can be interpreted as approved.
 * Pull Requests should pass continuous integration tests prior to merging.
 * Pull Requests for significant contributions, new features or changed behaviour should be open for comment and review in a non draft state for at least 1 week prior to merging.
 * In exceptional cases when a consensus on a Pull Request or Commit cannot be established through normal review and discussion, then any committer may request a formal consensus vote (ie. +1, 0, -1). Any such vote will be scheduled, conducted and adjudicated by the Project Leader(s).
 * If the consensus for a merged Pull Request or commit is disputed, then it shall be considered reverted and consensus must be sought for it to remain rather than for it's reversion.
 * In trivial or exceptional circumstances, these guidelines may be bypassed if the reasons for doing so are documented.

## Eclipse Development Process

This Eclipse Foundation open project is governed by the Eclipse Foundation
Development Process and operates under the terms of the Eclipse IP Policy.

The Jakarta EE Specification Committee has adopted the Jakarta EE Specification
Process (JESP) in accordance with the Eclipse Foundation Specification Process
v1.2 (EFSP) to ensure that the specification process is complied with by all
Jakarta EE specification projects.

* https://eclipse.org/projects/dev_process
* https://www.eclipse.org/org/documents/Eclipse_IP_Policy.pdf
* https://jakarta.ee/about/jesp/
* https://www.eclipse.org/legal/efsp_non_assert.php

## Contact

Contact the project developers via the project's "dev" list.

* https://accounts.eclipse.org/mailing-list/servlet-dev

