(** String with variables of the form ${...} or $(...)

    Variables cannot contain "${", "$(", ")" or "}". For instance in "$(cat ${x})", only
    "${x}" will be considered a variable, the rest is text. *)

open Import

type t
val t : t Sexp.Of_sexp.t
val sexp_of_t : t -> Sexp.t

val loc : t -> Loc.t

val to_string : t -> string

(** [t] generated by the OCaml code. The first argument should be [__POS__]. The second is
    either a string to parse, a variable name or plain text. *)
val virt      : (string * int * int * int) -> string -> t
val virt_var  : (string * int * int * int) -> string -> t
val virt_text : (string * int * int * int) -> string -> t

val just_a_var : t -> string option

val vars : t -> String_set.t

val fold : t -> init:'a -> f:('a -> Loc.t -> string -> 'a) -> 'a
val iter : t -> f:(Loc.t -> string -> unit) -> unit

val expand : t -> f:(Loc.t -> string -> string option) -> string
val partial_expand : t -> f:(Loc.t -> string -> string option) -> (string, t) either
