/*
 * Copyright (c) 2006, The Joust Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the Joust Project nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * File created by keithkml
 */

/*
 * Created by IntelliJ IDEA.
 * User: keithkml
 * Date: Jan 26, 2006
 * Time: 9:28:23 AM
 */

package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmdFactory;
import net.kano.joscar.rvproto.rvproxy.DefaultRvProxyCmdFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;

public class StreamProxyConnection implements ProxyConnection {
  private static final Logger LOGGER = Logger
      .getLogger(StreamProxyConnection.class.getName());

  private StreamInfoProvider provider;

  public StreamProxyConnection(StreamInfoProvider stream) {
    this.provider = stream;
  }

  public RvProxyCmd readPacket() throws IOException {
    InputStream in = provider.getStreamInfo().getInputStream();
    RvProxyPacket packet = RvProxyPacket.readPacket(in);
    LOGGER.fine("Got proxy packet: " + packet);
    RvProxyCmdFactory factory = new DefaultRvProxyCmdFactory();
    return factory.getRvProxyCmd(packet);
  }

  public void sendProxyPacket(RvProxyCmd initCmd) throws IOException {
    RvProxyPacket packet = new RvProxyPacket(initCmd);
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    packet.write(bout);
    bout.writeTo(provider.getStreamInfo().getOutputStream());
  }

}
