/* Built-in files */

#include "types.h"

const char *builtins[]=
{
	"joerc",
		"-notite         Don't send terminal initialization and termination strings:\n"
		"-assume_color	Assume terminal has ANSI color support even if termcap/terminfo entry\n"
		"-assume_256color\n"
		"-guess_non_utf8	Allow guess of non-UTF-8 file encoding in a UTF-8 locale.\n"
		"-guess_utf16	Allow guess of UTF-16 encoding\n"
		"-guess_crlf     Automatically detect MS-DOS files and set -crlf appropriately\n"
		"-guess_indent	Guess indent character (tab or space).\n"
		"-menu_above	Position menu/list above prompt when enabled.  Otherwise position\n"
		"-transpose	Transpose rows with columns in all menus.\n"
		"-joe_state     Use ~/.joe_state file\n"
		"-brpaste	When JOE starts, send command to the terminal emulator that\n"
		"-pastehack	If keyboard input comes in as one block assume it's a mouse\n"
		"-restore	Restore previous cursor position when files are opened\n"
		"-search_prompting\n"
		"-lmsg \\i%k%T%W%I%X %n %m%y%R %M %x\n"
		"-rmsg  %S Row %4r Col %3c %t  Ctrl-K H for help\n"
		"-smsg ** Line %r Col %c Offset %o(0x%O) %e %a(0x%A) Width %w ** \n"
		"-zmsg ** Line %r Col %c Offset %o(0x%O) ** \n"
		"-highlight\n"
		"-istep 4\n"
		":include ftyperc\n"
		":defmenu root\n"
		"mode,\"overwrite\",rtn	T Overtype %Zoverwrite%\n"
		"mode,\"hex\",rtn	' Hex edit mode\n"
		"mode,\"autoindent\",rtn	I Autoindent %Zautoindent%\n"
		"mode,\"wordwrap\",rtn	W Word wrap %Zwordwrap%\n"
		"mode,\"tab\",rtn	D Tab width %Ztab%\n"
		"mode,\"lmargin\",rtn	L Left margin %Zlmargin%\n"
		"mode,\"rmargin\",rtn	R Right margin %Zrmargin%\n"
		"mode,\"square\",rtn	X Column mode %Zsquare%\n"
		"mode,\"indentc\",rtn	% % Indent char %Zindentc%\n"
		"mode,\"istep\",rtn	% % Indent step %Zistep%\n"
		"menu,\"indent\",rtn	= Indent select\n"
		"mode,\"highlight\",rtn	H Highlighting %Zhighlight%\n"
		"mode,\"crlf\",rtn	Z CR-LF/MS-DOS %Zcrlf%\n"
		"mode,\"linums\",rtn	N Line numbers %Zlinums%\n"
		"mode,\"beep\",rtn	B Beep %Zbeep%\n"
		"mode,\"rdonly\",rtn	O Read only %Zrdonly%\n"
		"mode,\"syntax\",rtn	Y Syntax\n"
		"mode,\"encoding\",rtn	E Encoding\n"
		"mode,\"asis\",rtn	% % Meta chars as-is\n"
		"mode,\"language\",rtn	V Language\n"
		"mode,\"picture\",rtn	P picture %Zpicture%\n"
		"mode,\"type\",rtn		F File type [%Ztype%]\n"
		"menu,\"more-options\",rtn	  % % More options...\n"
		":defmenu more-options menu,\"root\",rtn\n"
		"menu,\"^G\",rtn	% % ^G options\n"
		"menu,\"search\",rtn	% % search options\n"
		"menu,\"paragraph\",rtn	% % paragraph options\n"
		"menu,\"file\",rtn	% % file options\n"
		"menu,\"menu\",rtn	% % menu options\n"
		"menu,\"global\",rtn	% % global options\n"
		"menu,\"cursor\",rtn	% % cursor options\n"
		"menu,\"marking\",rtn	% % marking options\n"
		"menu,\"tab\",rtn	% % tab/indent options\n"
		":defmenu indent menu,\"root\",rtn\n"
		"mode,\"istep\",rtn,\"1\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 1, Indent character = 32\",rtn	1 Space\n"
		"mode,\"istep\",rtn,\"2\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 2, Indent character = 32\",rtn	2 Spaces\n"
		"mode,\"istep\",rtn,\"3\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 3, Indent character = 32\",rtn	3 Spaces\n"
		"mode,\"istep\",rtn,\"4\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 4, Indent character = 32\",rtn	4 Spaces\n"
		"mode,\"istep\",rtn,\"5\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 5, Indent character = 32\",rtn	5 Spaces\n"
		"mode,\"istep\",rtn,\"8\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 8, Indent character = 32\",rtn	8 Spaces\n"
		"mode,\"istep\",rtn,\"10\",rtn,mode,\"indentc\",rtn,\"32\",rtn,msg,\"Indent step = 10, Indent character = 32\",rtn	0 Ten\n"
		"mode,\"istep\",rtn,\"1\",rtn,mode,\"indentc\",rtn,\"9\",rtn,msg,\"Indent step = 1, Indent character = 9\",rtn	T Tab\n"
		":defmenu menu menu,\"more-options\",rtn\n"
		"mode,\"menu_explorer\",rtn	% % Menu explorer %Zmenu_explorer%\n"
		"mode,\"menu_above\",rtn	% % Menu position %Zmenu_above%\n"
		"mode,\"menu_jump\",rtn	% % Jump into menu %Zmenu_jump%\n"
		"mode,\"transpose\",rtn	% % Transpose menus %Ztranspose%\n"
		":defmenu ^G menu,\"more-options\",rtn\n"
		"mode,\"highlighter_context\",rtn	% % ^G uses highlighter context %Zhighlighter_context%\n"
		"mode,\"single_quoted\",rtn	% % ^G ignores '...' %Zsingle_quoted%\n"
		"mode,\"no_double_quoted\",rtn	% % ^G no ignore \"...\" %Zno_double_quoted%\n"
		"mode,\"c_comment\",rtn	% % ^G ignores /*...*/ %Zc_comment%\n"
		"mode,\"cpp_comment\",rtn	% % ^G ignores //... %Zcpp_comment%\n"
		"mode,\"pound_comment\",rtn	% % ^G ignores #... %Zpound_comment%\n"
		"mode,\"vhdl_comment\",rtn	% % ^G ignores --... %Zvhdl_comment%\n"
		"mode,\"semi_comment\",rtn	% % ^G ignores ;... %Zsemi_comment%\n"
		"mode,\"tex_comment\",rtn % % ^G ignores %%... %Ztex_comment%\n"
		"mode,\"text_delimiters\",rtn % % Text delimiters %Ztext_delimiters%\n"
		":defmenu search menu,\"more-options\",rtn\n"
		"mode,\"icase\",rtn	% % Case insensitivity %Zicase%\n"
		"mode,\"wrap\",rtn	% % Search wraps %Zwrap%\n"
		"mode,\"search_prompting\",rtn	% % Search prompting %Zsearch_prompting%\n"
		"mode,\"csmode\",rtn	% % Continued search %Zcsmode%\n"
		":defmenu paragraph menu,\"more-options\",rtn\n"
		"mode,\"french\",rtn	% % French spacing %Zfrench%\n"
		"mode,\"flowed\",rtn	% % Flowed text %Zflowed%\n"
		"mode,\"cpara\",rtn	% % Paragraph indent chars %Zcpara%\n"
		"mode,\"cnotpara\",rtn	% % Not-paragraph chars %Zcnotpara%\n"
		":defmenu file menu,\"more-options\",rtn\n"
		"mode,\"restore\",rtn	% % Restore cursor %Zrestore%\n"
		"mode,\"guess_crlf\",rtn	% % Auto detect CR-LF %Zguess_crlf%\n"
		"mode,\"guess_indent\",rtn	% % Guess indent %Zguess_indent%\n"
		"mode,\"guess_non_utf8\",rtn	% % Guess non-UTF-8 %Zguess_non_utf8%\n"
		"mode,\"guess_utf8\",rtn	% % Guess UTF-8 %Zguess_utf8%\n"
		"mode,\"guess_utf16\",rtn	% % Guess UTF-16 %Zguess_utf16%\n"
		"mode,\"force\",rtn	% % Force last NL %Zforce%\n"
		"mode,\"nobackup\",rtn	% % No backup %Znobackup%\n"
		":defmenu global menu,\"more-options\",rtn\n"
		"mode,\"nolocks\",rtn	% % Disable locks %Znolocks%\n"
		"mode,\"nobackups\",rtn	% % Disable backups %Znobackups%\n"
		"mode,\"nodeadjoe\",rtn	% % Disable DEADJOE %Znodeadjoe%\n"
		"mode,\"nomodcheck\",rtn	% % Disable mtime check %Znomodcheck%\n"
		"mode,\"nocurdir\",rtn	% % Disable current dir %Znocurdir%\n"
		"mode,\"exask\",rtn	% % Exit ask %Zexask%\n"
		"mode,\"nosta\",rtn	% % Disable status line %Znosta%\n"
		"mode,\"keepup\",rtn	% % Fast status line %Zkeepup%\n"
		"mode,\"break_hardlinks\",rtn	% % Break hard links %Zbreak_hardlinks%\n"
		"mode,\"break_links\",rtn	% % Break links %Zbreak_links%\n"
		"mode,\"joe_state\",rtn	% % Joe_state file %Zjoe_state%\n"
		"mode,\"undo_keep\",rtn	% % No. undo records %Zundo_keep%\n"
		"mode,\"backpath\",rtn	% % Path to backup files %Zbackpath%\n"
		":defmenu cursor menu,\"more-options\",rtn\n"
		"mode,\"pg\",rtn	% % No. PgUp/PgDn lines %Zpg%\n"
		"mode,\"mid\",rtn	C Center on scroll %Zmid%\n"
		"mode,\"floatmouse\",rtn	% % Click past end %Zfloatmouse%\n"
		"mode,\"rtbutton\",rtn	% % Right button %Zrtbutton%\n"
		":defmenu marking menu,\"more-options\",rtn\n"
		"mode,\"autoswap\",rtn	% % Autoswap mode %Zautoswap%\n"
		"mode,\"marking\",rtn	% % Marking %Zmarking%\n"
		"mode,\"lightoff\",rtn	% % Auto unmask %Zlightoff%\n"
		":defmenu tab menu,\"more-options\",rtn\n"
		"mode,\"smarthome\",rtn	% % Smart home key %Zsmarthome%\n"
		"mode,\"smartbacks\",rtn	% % Smart backspace %Zsmartbacks%\n"
		"mode,\"indentfirst\",rtn	% % To indent first %Zindentfirst%\n"
		"mode,\"purify\",rtn	% % Clean up indents %Zpurify%\n"
		"mode,\"spaces\",rtn	% % No tabs %Zspaces%\n"
		"{Basic\n"
		"\\i   Help Screen    \\|turn off with ^KH    more help with ESC . (^[.)              \\i\n"
		"\\i \\i\\|\\uCURSOR\\u           \\|\\uGO TO\\u            \\|\\uBLOCK\\u      \\|\\uDELETE\\u   \\|\\uMISC\\u         \\|\\uEXIT\\u      \\|\\i \\i\n"
		"\\i \\i\\|^B left ^F right \\|^U  prev. screen \\|^KB begin  \\|^D char. \\|^KJ reformat \\|^KX save  \\|\\i \\i\n"
		"\\i \\i\\|^P up   ^N down  \\|^V  next screen  \\|^KK end    \\|^Y line  \\|^KA center   \\|^C  abort \\|\\i \\i\n"
		"\\i \\i\\|^Z previous word \\|^A  beg. of line \\|^KM move   \\|^W >word \\|^T  options  \\|^KZ shell \\|\\i \\i\n"
		"\\i \\i\\|^X next word     \\|^E  end of line  \\|^KC copy   \\|^O word< \\|^R  refresh  \\|\\uFILE\\u      \\|\\i \\i\n"
		"\\i \\i\\|\\uSEARCH\\u           \\|^KU top of file  \\|^KW file   \\|^J >line \\|\\uSPELL\\u        \\|^KE edit  \\|\\i \\i\n"
		"\\i \\i\\|^KF find text    \\|^KV end of file  \\|^KY delete \\|^_ undo  \\|^[N word     \\|^KR insert\\|\\i \\i\n"
		"\\i \\i\\|^L  find next    \\|^KL to line No.  \\|^K/ filter \\|^^ redo  \\|^[L file     \\|^KD save  \\|\\i \\i\n"
		"}\n"
		"{Windows\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i\\|^KO Split the window in half           \\|F1 - F4 Pop-up shell window           \\|\\i \\i\n"
		"\\i \\i\\|^KG Make current window bigger         \\|^KT Make current window smaller       \\|\\i \\i\n"
		"\\i \\i\\|^KN Go to the window below             \\|^KP Go to the window above            \\|\\i \\i\n"
		"\\i \\i\\|^[V Switch to next buffer              \\|^[U Switch to previous buffer         \\|\\i \\i\n"
		"\\i \\i\\|^C  Eliminate the current window       \\|^KI Show all windows / Show one window\\|\\i \\i\n"
		"}\n"
		"{Advanced\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i\\|\\uMACROS\\u         \\|\\uMISC\\u            \\|\\uSCROLL\\u    \\|\\uSHELL\\u       \\|\\uGOTO\\u       \\|\\uI-SEARCH\\u     \\|\\i \\i\n"
		"\\i \\i\\|^K[ 0-9 Record \\|^K SPACE status \\|^[W Up    \\|^K' Window  \\|^[B To ^KB \\|^[R Backwards\\|\\i \\i\n"
		"\\i \\i\\|^K]     Stop   \\|^K\\\\ Repeat      \\|^[Z Down  \\|^[! Command \\|^[K To ^KK \\|^[S Forwards \\|\\i \\i\n"
		"\\i \\i\\|^K 0-9  Play   \\|\\uINSERT\\u          \\|^K< Left  \\|\\uQUOTE\\u       \\|\\uDELETE\\u     \\|\\uBOOKMARKS\\u    \\|\\i \\i\n"
		"\\i \\i\\|^K?     Query  \\|^] split line   \\|^K> Right \\|^[' Ctrl-   \\|^[Y yank   \\|^[ 0-9 Goto  \\|\\i \\i\n"
		"\\i \\i\\|^[D     Dump   \\|^SPACE ins space\\|          \\|^\\\\ Meta-    \\|^[O line<  \\|^[^[   Set   \\|\\i \\i\n"
		"}\n"
		"{Programs\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i\\|\\uGOTO\\u                 \\|\\uINDENT\\u   \\|\\uCOMPILING\\u          \\uQUICK\\u                       \\|\\i \\i\n"
		"\\i \\i\\|^G  Matching ( [ {   \\|^K, less \\|^[C Compile & parse ^G  find word under cursor \\|\\i \\i\n"
		"\\i \\i\\|^K- Previous place   \\|^K. more \\|^[G Grep & parse    ^[ENTER complete word      \\|\\i \\i\n"
		"\\i \\i\\|^K= Next place       \\|\\uFILE\\u     \\|^[= To next error   ^[Y paste deleted text     \\|\\i \\i\n"
		"\\i \\i\\|^K; Tags file search \\|^K `     \\|^[- To prev. error  ^[^Y cycle through deleted \\|\\i \\i\n"
		"\\i \\i\\|                     \\| revert  \\|^[ SP Jump to error                            \\|\\i \\i\n"
		"}\n"
		"{Search\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\iSearch sequences:                                                            \\|\\i \\i\n"
		"\\i \\i    \\\\^  \\\\$  matches beg./end of line       \\\\.     match any single char      \\|\\i \\i\n"
		"\\i \\i    \\\\<  \\\\>  matches beg./end of word       \\\\!     match char or expression   \\|\\i \\i\n"
		"\\i \\i    \\\\(  \\\\)  grouping                       \\\\|     match left or right         \\|\\i \\i\n"
		"\\i \\i    \\\\[a-z]  matches one of a set                                             \\|\\i \\i\n"
		"\\i \\i    \\\\{1,3}  match 1 - 3 occurrences        \\\\?     match 0 or 1 occurrence     \\|\\i \\i\n"
		"\\i \\i    \\\\+      match 1 or more occurrences    \\\\*     match 0 or more occurrences \\|\\i \\i\n"
		"\\i \\iReplace sequences:                                                           \\|\\i \\i\n"
		"\\i \\i    \\\\&      replaced with entire match     \\\\1 - 9 replaced with Nth group   \\|\\i \\i\n"
		"\\i \\i    \\\\u \\\\l   convert next to upper/lower    \\\\U \\\\L  case convert until \\\\E     \\|\\i \\i\n"
		"}\n"
		"{Escape sequences\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\iEscape sequences: \\\\x{10fff}  Unicode code point   \\\\p{Ll}  Unicode category \\|\\i \\i\n"
		"\\i \\i    \\\\i / \\\\I  Identifier start      \\\\t  tab          \\\\e  escape               \\|\\i \\i\n"
		"\\i \\i    \\\\c / \\\\C  Identifier continue   \\\\n  newline      \\\\r  carriage return      \\|\\i \\i\n"
		"\\i \\i    \\\\d / \\\\D  Digit / Not a digit   \\\\b  backspace  \\\\xFF  hex character        \\|\\i \\i\n"
		"\\i \\i    \\\\w / \\\\W  Word / Not a word     \\\\a  alert      \\\\377  octal character      \\|\\i \\i\n"
		"\\i \\i    \\\\s / \\\\S  Space / Not a space   \\\\f  formfeed     \\\\\\\\  backslash            \\|\\i \\i\n"
		"}\n"
		"{SearchOptions\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\iSearch options:                                                              \\|\\i \\i\n"
		"\\i \\i     r Replace      k Restrict search to highlighted block                   \\|\\i \\i\n"
		"\\i \\i     i Ignore case  b Search backwards instead of forwards                   \\|\\i \\i\n"
		"\\i \\i                    a Search across all loaded files                         \\|\\i \\i\n"
		"\\i \\i                    e Search across all files in Grep or Compile error list  \\|\\i \\i\n"
		"\\i \\i w / n  Allow / prevent wrap to start of file                                \\|\\i \\i\n"
		"\\i \\i x / y  Search text is standard format / JOE format regular expression       \\|\\i \\i\n"
		"\\i \\i   nnn  Perform exactly nnn replacements                                     \\|\\i \\i\n"
		"}\n"
		"{Math\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\uCOMMANDS\\u (hit ESC m for math)  \\uFUNCTIONS\\u                                    \\|\\i \\i\n"
		"\\i \\i     hex hex display mode       sin cos tab asin acos atan                   \\|\\i \\i\n"
		"\\i \\i     dec decimal mode           sinh cosh tanh asinh acosh atanh             \\|\\i \\i\n"
		"\\i \\i     ins type result into file  sqrt cbrt exp ln log                         \\|\\i \\i\n"
		"\\i \\i    eval evaluate block         int floor ceil abs erg ergc                  \\|\\i \\i\n"
		"\\i \\i    0xff enter number in hex    joe(..macro..) - runs an editor macro        \\|\\i \\i\n"
		"\\i \\i    3e-4 floating point decimal \\uBLOCK\\u                                        \\|\\i \\i\n"
		"\\i \\i    a=10 assign a variable      sum cnt  Sum, count                          \\|\\i \\i\n"
		"\\i \\i 2+3:ins multiple commands      avg dev  Average, std. deviation             \\|\\i \\i\n"
		"\\i \\i    e pi constants              \\uOPERATORS\\u                                    \\|\\i \\i\n"
		"\\i \\i     ans previous result        ! ^  * / %  + -  < <= > >= == !=  &&  ||  ? :\\|\\i \\i\n"
		"}\n"
		"{Names\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i Hit TAB at file name prompts to generate menu of file names                 \\|\\i \\i\n"
		"\\i \\i Or use up/down keys to access history of previously entered names           \\|\\i \\i\n"
		"\\i \\i Special file names:                                                         \\|\\i \\i\n"
		"\\i \\i      !command                 Pipe in/out of a shell command                \\|\\i \\i\n"
		"\\i \\i      >>filename               Append to a file                              \\|\\i \\i\n"
		"\\i \\i      -                        Read/Write to/from standard I/O               \\|\\i \\i\n"
		"\\i \\i      filename,START,SIZE      Read/Write a part of a file/device            \\|\\i \\i\n"
		"\\i \\i          Give START/SIZE in decimal (255), octal (0377) or hex (0xFF)       \\|\\i \\i\n"
		"}\n"
		"{Joe\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i Send bug reports to: http://sourceforge.net/projects/joe-editor \\|\\i \\i\n"
		"\\i \\i \\|\\i \\i\n"
		"\\i \\i  default joerc file is here /home/jhallen/etc/joe/joerc \\|\\i \\i\n"
		"\\i \\i  default syntax and i18n files are here /home/jhallen/share/joe \\|\\i \\i\n"
		"\\i \\i  additional documentation can be found here /home/jhallen/share/doc/joe \\|\\i \\i\n"
		"}\n"
		"{CharTable\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,                        \\i\n"
		"\\i \\i\\| Dec  \\u 0123 4567  8901 2345    0123 4567  8901 2345 \\u  Dec \\|\\i \\i\n"
		"\\i \\i\\|     |                                              |     \\|\\i \\i\n"
		"\\i \\i\\|   0 | \\u@ABC\\u \\uDEFG\\u  \\uHIJK\\u \\uLMNO\\u    \\i\\u@ABC\\u\\i \\i\\uDEFG\\u\\i  \\i\\uHIJK\\u\\i \\i\\uLMNO\\u\\i | 128 \\|\\i \\i\n"
		"\\i \\i\\|  16 | \\uPQRS\\u \\uTUVW\\u  \\uXYZ[\\u \\u\\\\]^_\\u    \\i\\uPQRS\\u\\i \\i\\uTUVW\\u\\i  \\i\\uXYZ[\\u\\i \\i\\u\\\\]^_\\u\\i | 144 \\|\\i \\i\n"
		"\\i \\i\\|  32 |  !\"# $%&'  ()*+ ,-./    \xa0\xa1\xa2\xa3 \xa4\xa5\xa6\xa7  \xa8\xa9\xaa\xab \xac\xad\xae\xaf | 160 \\|\\i \\i\n"
		"\\i \\i\\|  48 | 0123 4567  89:; <=>?    \xb0\xb1\xb2\xb3 \xb4\xb5\xb6\xb7  \xb8\xb9\xba\xbb \xbc\xbd\xbe\xbf | 176 \\|\\i \\i\n"
		"\\i \\i\\|  64 | @ABC DEFG  HIJK LMNO    \xc0\xc1\xc2\xc3 \xc4\xc5\xc6\xc7  \xc8\xc9\xca\xcb \xcc\xcd\xce\xcf | 192 \\|\\i \\i\n"
		"\\i \\i\\|  80 | PQRS TUVW  XYZ[ \\\\]^_    \xd0\xd1\xd2\xd3 \xd4\xd5\xd6\xd7  \xd8\xd9\xda\xdb \xdc\xdd\xde\xdf | 208 \\|\\i \\i\n"
		"\\i \\i\\|  96 | `abc defg  hijk lmno    \xe0\xe1\xe2\xe3 \xe4\xe5\xe6\xe7  \xe8\xe9\xea\xeb \xec\xed\xee\xef | 224 \\|\\i \\i\n"
		"\\i \\i\\| 112 | pqrs tuvw  xyz{ |}~\x7f    \xf0\xf1\xf2\xf3 \xf4\xf5\xf6\xf7  \xf8\xf9\xfa\xfb \xfc\xfd\xfe\xff | 240 \\|\\i \\i\n"
		"}\n"
		":windows		Bindings common to all windows\n"
		"type		U+0 TO U+10FFFF\n"
		"abort		^C		Abort window\n"
		"abort		^K Q\n"
		"abort		^K ^Q\n"
		"abort		^K q\n"
		"arg		^K \\		Repeat next command\n"
		"explode		^K I		Show all windows or show only one window\n"
		"explode		^K ^I\n"
		"explode		^K i\n"
		"help		^K H		Help menu\n"
		"help		^K ^H\n"
		"help		^K h\n"
		"hnext		^[ .		Next help window\n"
		"hprev		^[ ,		Previous help window\n"
		"math		^[ m		Calculator\n"
		"math		^[ M		Calculator\n"
		"msg		^[ h		Display a message\n"
		"msg		^[ H		Display a message\n"
		"msg		^[ ^H		Display a message\n"
		"nextw		^K N		Goto next window\n"
		"nextw		^K ^N\n"
		"nextw		^K n\n"
		"pgdn		.kN		Screen down\n"
		"pgdn		^V\n"
		"pgdn		^[ [ 6 ~\n"
		"pgup		.kP		Screen up\n"
		"pgup		^U\n"
		"pgup		^[ [ 5 ~\n"
		"play		^K 0 TO 9	Execute macro\n"
		"prevw		^K P		Goto previous window\n"
		"prevw		^K ^P\n"
		"prevw		^K p\n"
		"query		^K ?		Macro query insert\n"
		"record		^K [		Record a macro\n"
		"retype		^R		Refresh screen\n"
		"rtn		^M		Return\n"
		"shell		^K Z		Shell escape\n"
		"shell		^K ^Z\n"
		"shell		^K z\n"
		"stop		^K ]		Stop recording\n"
		"defmdown	MDOWN		Move the cursor to the mouse location\n"
		"defmup		MUP\n"
		"defmdrag	MDRAG		Select a region of characters\n"
		"defm2down	M2DOWN		Select the word at the mouse location\n"
		"defm2up		M2UP\n"
		"defm2drag	M2DRAG		Select a region of words\n"
		"defm3down	M3DOWN		Select the line at the mouse location\n"
		"defm3up		M3UP\n"
		"defm3drag	M3DRAG		Select a region of lines\n"
		"xtmouse		^[ [ M		Introduces an xterm mouse event\n"
		"extmouse	^[ [ <		Introduces an extended xterm mouse event\n"
		":main			Text editing window\n"
		":inherit windows\n"
		":def ispellfile filt,\"cat >ispell.tmp;ispell ispell.tmp </dev/tty >/dev/tty;cat ispell.tmp;/bin/rm ispell.tmp\",rtn,retype\n"
		":def ispellword psh,nextword,markk,prevword,markb,filt,\"cat >ispell.tmp;ispell ispell.tmp </dev/tty >/dev/tty;tr -d <ispell.tmp '\\\\012';/bin/rm ispell.tmp\",rtn,retype,nextword\n"
		":def aspellfile filt,\"SPLTMP=ispell.tmp;cat >$SPLTMP;aspell --lang=\",language,\".\",charset,\" -x -c $SPLTMP </dev/tty >/dev/tty;cat $SPLTMP;/bin/rm $SPLTMP\",rtn,retype\n"
		":def aspellword psh,nextword,markk,prevword,markb,filt,\"SPLTMP=ispell.tmp;cat >$SPLTMP;aspell --lang=\",language,\".\",charset,\" -x -c $SPLTMP </dev/tty >/dev/tty;tr -d <$SPLTMP '\\\\012';/bin/rm $SPLTMP\",rtn,retype,nextword\n"
		"aspellfile	^[ l\n"
		"aspellword	^[ n\n"
		":def compile mwind!,mfit!,querysave,query,scratch,\"* Build Log *\",rtn,bof,markb,eof,\" \",markk,blkdel,build\n"
		":def grep_find mwind!,mfit!,scratch,\"* Grep Log *\",rtn,bof,markb,eof,\" \",markk,blkdel,grep\n"
		":def man scratch,\"* Man Page *\",rtn,bof,markb,eof,\" \",markk,blkdel,\" \",ltarw,run,\"man -P cat -S 2:3 \"\n"
		":def shell1 scratch_push,\"* Startup Log *\",rtn,scratch_push,\"* Shell 1 *\",rtn,vtbknd!,eof\n"
		":def shell2 scratch_push,\"* Startup Log *\",rtn,scratch_push,\"* Shell 2 *\",rtn,vtbknd!,eof\n"
		":def shell3 scratch_push,\"* Startup Log *\",rtn,scratch_push,\"* Shell 3 *\",rtn,vtbknd!,eof\n"
		":def shell4 scratch_push,\"* Startup Log *\",rtn,scratch_push,\"* Shell 4 *\",rtn,vtbknd!,eof\n"
		":def shell_clear psh,bof,markb,eof,markk,blkdel\n"
		":def shell_parse parserr\n"
		":def shell_gparse gparse\n"
		":def shell_release release\n"
		":def shell_math maths\n"
		":def shell_typemath txt,math,\"ins\",rtn,rtn,txt,\"\x0d\x04\",rtn\n"
		":def shell_rtn rtn\n"
		":def shell_edit edit\n"
		":def shell_dellin dellin\n"
		":def shell_cd cd\n"
		":def shell_pop popabort\n"
		":def shell_markb markb\n"
		":def shell_markk markk\n"
		"paste			^[ ] 5 2 ;		Base64 paste (obsolete)\n"
		"brpaste			^[ [ 2 0 0 ~		Bracketed paste\n"
		"brpaste_done		^[ [ 2 0 1 ~		Bracketed paste done\n"
		"insc			^[ [ 2 ~\n"
		"insc			^[ [ L			SCO\n"
		"delch			^[ [ 3 ~\n"
		"pgup			^[ [ I		SCO\n"
		"pgdn			^[ [ G		SCO\n"
		"home			^[ [ 1 ~		Putty, Linux, Cygwin\n"
		"home			^[ [ H			Xterm, Konsole, SCO\n"
		"home			^[ O H			gnome-terminal\n"
		"home			^[ [ 7 ~		RxVT\n"
		"eol			^[ [ 4 ~		Putty, Linux, Cygwin, ssh\n"
		"eol			^[ [ F			Xterm, Konsole, SCO\n"
		"eol			^[ O F			gnome-terminal\n"
		"eol			^[ [ 8 ~		RxVT\n"
		"rtarw,ltarw,begin_marking,rtarw,toggle_marking	^[ [ 1 ; 5 C    Mark right Xterm\n"
		"rtarw,ltarw,begin_marking,rtarw,toggle_marking	^[ [ 5 C        Mark right Gnome-terminal\n"
		"rtarw,ltarw,begin_marking,rtarw,toggle_marking	^[ O c		Mark right RxVT Ctrl-rtarw\n"
		"ltarw,rtarw,begin_marking,ltarw,toggle_marking	^[ [ 1 ; 5 D    Mark left\n"
		"ltarw,rtarw,begin_marking,ltarw,toggle_marking	^[ [ 5 D        Mark left\n"
		"ltarw,rtarw,begin_marking,ltarw,toggle_marking	^[ O d		Mark left RxVT Ctrl-ltarw\n"
		"uparw,dnarw,begin_marking,uparw,toggle_marking	^[ [ 1 ; 5 A    Mark up\n"
		"uparw,dnarw,begin_marking,uparw,toggle_marking	^[ [ 5 A        Mark up\n"
		"uparw,dnarw,begin_marking,uparw,toggle_marking	^[ O a		Mark up RxVT Ctrl-uparw\n"
		"dnarw,uparw,begin_marking,dnarw,toggle_marking	^[ [ 1 ; 5 B    Mark down\n"
		"dnarw,uparw,begin_marking,dnarw,toggle_marking	^[ [ 5 B        Mark down\n"
		"dnarw,uparw,begin_marking,dnarw,toggle_marking	^[ O b		Mark down RxVT Ctrl-dnarw\n"
		"blkdel,nmark   ^[ [ 3 ; 5 -	Gnome-terminal Ctrl-Del\n"
		"blkdel,nmark   ^[ [ 3 ; 5 ~	Xterm Ctrl-Del\n"
		"yank		^[ [ 2 ; 5 -	Gnome-terminal Ctrl-Ins\n"
		"yank		^[ [ 2 ; 5 ~    Xterm Ctrl-Ins\n"
		"delbol		^[ o		Delete to beginning of line\n"
		"delbol		^[ ^O		Delete to beginning of line\n"
		"dnslide		^[ z		Scroll down one line\n"
		"dnslide		^[ Z		Scroll down one line\n"
		"dnslide		^[ ^Z		Scroll down one line\n"
		"dnslide,dnslide,dnslide,dnslide		MWDOWN\n"
		"compile		^[ c		Compile\n"
		"compile		^[ C\n"
		"compile		^[ ^C		Compile\n"
		"grep_find	^[ g		Grep\n"
		"grep_find	^[ G		Grep\n"
		"grep_find	^[ ^G		Grep\n"
		"execmd		^[ x		Prompt for command to execute\n"
		"execmd		^[ X		Prompt for command to execute\n"
		"execmd		^[ ^X		Prompt for command to execute\n"
		"finish		^[ ^I		Complete word in document\n"
		"finish		^[ ^M		Complete word: used to be math\n"
		"mwind!,mfit,jump,bol		^[ SP\n"
		"isrch		^[ s		Forward incremental search\n"
		"isrch		^[ S		Forward incremental search\n"
		"isrch		^[ ^S		Forward incremental search\n"
		"notmod		^[ ~		Not modified\n"
		"mwind,mfit,prevw,nxterr		^[ =		To next error\n"
		"parserr		^[ e		Parse errors in current buffer\n"
		"parserr		^[ E		Parse errors in current buffer\n"
		"parserr		^[ ^E		Parse errors in current buffer\n"
		"mwind,mfit,prevw,prverr		^[ -		To previous error\n"
		"rsrch		^[ r		Backward incremental search\n"
		"rsrch		^[ R		Backward incremental search\n"
		"rsrch		^[ ^R		Backward incremental search\n"
		"run		^[ !		Run a program in a window\n"
		"tomarkb		^[ b		Go to beginning of marked block\n"
		"tomarkb		^[ ^B		Go to beginning of marked block\n"
		"tomarkk		^[ k		Go to end of marked block\n"
		"tomarkk		^[ ^K		Go to end of marked block\n"
		"tomarkk		^[ K		Go to end of marked block\n"
		"txt		^[ i		Prompt for text and insert it\n"
		"txt		^[ I		Prompt for text and insert it\n"
		"upslide		^[ w		Scroll up one line\n"
		"upslide		^[ ^W		Scroll up one line\n"
		"upslide		^[ W		Scroll up one line\n"
		"upslide,upslide,upslide,upslide		MWUP\n"
		"yank		^[ y		Undelete text\n"
		"yankpop		^[ ^Y		Undelete text\n"
		"yank		^[ Y		Undelete text\n"
		"insc		^@		Ctrl-space used to insert a space\n"
		"nbuf		^[ v		Next buffer\n"
		"nbuf		^[ V		Next buffer\n"
		"nbuf		^[ ^V		Next buffer\n"
		"pbuf		^[ u		Prev buffer\n"
		"pbuf		^[ U		Prev buffer\n"
		"pbuf		^[ ^U		Prev buffer\n"
		"quote8		^\\		Enter Meta chars\n"
		"quote		^[ '		Enter Ctrl chars\n"
		"quote		^Q\n"
		"backs		^?		Backspace\n"
		"backs		^H\n"
		"backw		^O		Backspace word\n"
		"bknd		^K '		Shell window\n"
		"blkcpy		^K C		Copy marked block\n"
		"blkcpy		^K ^C\n"
		"blkcpy		^K c\n"
		"blkdel		^K Y		Delete marked block\n"
		"blkdel		^K ^Y\n"
		"blkdel		^K y\n"
		"blkmove		^K M		Move marked block\n"
		"blkmove		^K ^M\n"
		"blkmove		^K m\n"
		"blksave		^K W		Save marked block\n"
		"blksave		^K ^W\n"
		"blksave		^K w\n"
		"bof		^K U		Goto beginning of file\n"
		"bof		^K ^U\n"
		"bof		^K u\n"
		"home		.kh\n"
		"home		^A\n"
		"center		^K A		Center line\n"
		"center		^K ^A\n"
		"center		^K a\n"
		"crawll		^K <		Pan left\n"
		"crawlr		^K >		Pan right\n"
		"delch		.kD		Delete character\n"
		"delch		^D\n"
		"deleol		^J		Delete to end of line\n"
		"dellin		^Y		Delete entire line\n"
		"delw		^W		Delete word to right\n"
		"dnarw		.kd		Go down\n"
		"dnarw		^N\n"
		"dnarw		^[ O B\n"
		"dnarw		^[ [ B\n"
		"edit		^K E		Edit a file\n"
		"edit		^K ^E\n"
		"edit		^K e\n"
		"eof		^K V		Go to end of file\n"
		"eof		^K ^V\n"
		"eof		^K v\n"
		"eol		.kH		Go to end of line\n"
		"eol		.@7\n"
		"eol		^E\n"
		"exsave		^K X		Save and exit\n"
		"exsave		^K ^X\n"
		"exsave		^K x\n"
		"ffirst		^K F		Find first\n"
		"ffirst		^K ^F\n"
		"ffirst		^K f\n"
		"filt		^K /		Filter block\n"
		"fnext		^L		Find next\n"
		"fmtblk		^K J		Format paragraphs in block\n"
		"fmtblk		^K ^J\n"
		"fmtblk		^K j\n"
		"gomark		^[ 0 TO 9	Goto bookmark\n"
		"groww		^K G		Grow window\n"
		"groww		^K ^G\n"
		"groww		^K g\n"
		"insc		.kI		Insert a space\n"
		"insf		^K R		Insert a file\n"
		"insf		^K ^R\n"
		"insf		^K r\n"
		"lindent		^K ,		Indent to left\n"
		"line		^K L		Goto line no.\n"
		"line		^K ^L\n"
		"line		^K l\n"
		"ltarw		.kl		Go left\n"
		"ltarw		^B\n"
		"ltarw		^[ O D\n"
		"ltarw		^[ [ D\n"
		"macros		^[ d		Dump keyboard macros\n"
		"macros		^[ ^D\n"
		"markb		^K B		Set beginning of marked block\n"
		"markb		^K ^B\n"
		"markb		^K b\n"
		"markk		^K K		Set end of marked block\n"
		"markk		^K ^K\n"
		"markk		^K k\n"
		"menu,\"root\",rtn	^T\n"
		"nextpos		^K =		Goto next position in position history\n"
		"nextword	^X		Goto next word\n"
		"open		^]		Split line\n"
		"prevpos		^K -		Previous position in history\n"
		"prevword	^Z		Previous word\n"
		"reload		^K `		Revert file\n"
		"redo		^^		Redo changes\n"
		"rindent		^K .		Indent to right\n"
		"rtarw		.kr		Go right\n"
		"rtarw		^F\n"
		"rtarw		^[ O C\n"
		"rtarw		^[ [ C\n"
		"run		^K !		Run a shell command\n"
		"save		^K D		Save file\n"
		"save		^K S\n"
		"save		^K ^D\n"
		"save		^K ^S\n"
		"save		^K d\n"
		"save		^K s\n"
		"setmark		^[ ^[		Set bookmark\n"
		"shrinkw		^K T		Shrink window\n"
		"shrinkw		^K ^T\n"
		"shrinkw		^K t\n"
		"splitw		^K O		Split window\n"
		"splitw		^K ^O\n"
		"splitw		^K o\n"
		"stat		^K SP		Show status\n"
		"stat		^K ^@		Show status\n"
		"tag		^K ;		Tags file search\n"
		"tomatch		^G		Goto matching parenthasis\n"
		"undo		^_		Undo changes\n"
		"uparw		.ku		Go up\n"
		"uparw		^P\n"
		"uparw		^[ O A\n"
		"uparw		^[ [ A\n"
		"shell1		^[ [ 1 1 ~\n"
		"shell1		^[ O P\n"
		"shell1		^[ [ [ A\n"
		"shell1		.k1\n"
		"shell2		^[ [ 1 2 ~\n"
		"shell2		^[ O Q\n"
		"shell2		^[ [ [ B\n"
		"shell2		.k2\n"
		"shell3		^[ [ 1 3 ~\n"
		"shell3		^[ O R\n"
		"shell3		^[ [ [ C\n"
		"shell3		.k3\n"
		"shell4		^[ [ 1 4 ~\n"
		"shell4		^[ O S\n"
		"shell4		^[ [ [ D\n"
		"shell4		.k4\n"
		":prompt			Prompt windows\n"
		":inherit main\n"
		"if,\"byte>size\",then,complete,complete,else,delch,endif	^D\n"
		"complete	^I\n"
		"dnarw,eol	.kd		Go down\n"
		"dnarw,eol	^N\n"
		"dnarw,eol	^[ O B\n"
		"dnarw,eol	^[ [ B\n"
		"uparw,eol	.ku		Go up\n"
		"uparw,eol	^P\n"
		"uparw,eol	^[ O A\n"
		"uparw,eol	^[ [ A\n"
		":menu			Selection menus\n"
		":inherit windows\n"
		"pgupmenu			^[ [ I\n"
		"pgdnmenu			^[ [ G\n"
		"bolmenu			^[ [ 1 ~		Putty, Linux, Cygwin\n"
		"bolmenu			^[ [ H			Xterm, Konsole\n"
		"bolmenu			^[ O H			gnome-terminal\n"
		"bolmenu			^[ [ 7 ~		RxVT\n"
		"eolmenu			^[ [ 4 ~		Putty, Linux, Cygwin, ssh\n"
		"eolmenu			^[ [ F			Xterm, Konsole\n"
		"eolmenu			^[ O F			gnome-terminal\n"
		"eolmenu			^[ [ 8 ~		RxVT\n"
		"abort		^[ ^[	Why?\n"
		"backsmenu	^?\n"
		"backsmenu	^H\n"
		"bofmenu		^K U\n"
		"bofmenu		^K ^U\n"
		"bofmenu		^K u\n"
		"bolmenu		.kh\n"
		"bolmenu		^A\n"
		"dnarwmenu	.kd\n"
		"dnarwmenu	^N\n"
		"dnarwmenu	^[ [ B\n"
		"dnarwmenu	^[ O B\n"
		"dnarwmenu	MWDOWN\n"
		"eofmenu		^K V\n"
		"eofmenu		^K ^V\n"
		"eofmenu		^K v\n"
		"eolmenu		.kH\n"
		"eolmenu		^E\n"
		"ltarwmenu	.kl\n"
		"ltarwmenu	^B\n"
		"ltarwmenu	^[ [ D\n"
		"ltarwmenu	^[ O D\n"
		"pgdnmenu	.kN		Screen down\n"
		"pgdnmenu	^V\n"
		"pgdnmenu	^[ [ 6 ~\n"
		"pgupmenu	.kP		Screen up\n"
		"pgupmenu	^U\n"
		"pgupmenu	^[ [ 5 ~\n"
		"rtarwmenu	.kr\n"
		"rtarwmenu	^F\n"
		"rtarwmenu	^[ [ C\n"
		"rtarwmenu	^[ O C\n"
		"rtn		SP\n"
		"rtn		^I\n"
		"rtn		^K H\n"
		"rtn		^K h\n"
		"rtn		^K ^H\n"
		"tabmenu		^I\n"
		"uparwmenu	.ku\n"
		"uparwmenu	^P\n"
		"uparwmenu	^[ [ A\n"
		"uparwmenu	^[ O A\n"
		"uparwmenu	MWUP\n"
		"defm2down	M2DOWN		Hits return key\n"
		":query			Single-key query window\n"
		":inherit windows\n"
		":querya			Single-key query window for quoting\n"
		"type		U+0 TO U+10FFFF\n"
		":querysr		Search & replace query window\n"
		"type		U+0 TO U+10FFFF\n"
		":shell			Input to shell windows\n"
		":inherit main\n"
		"\"\x03\"		^C		Abort\n"
		"\"\x04\"		^D		Eof\n"
		"\"	\"	^I		Tab\n"
		"\"\x08\"		^H		Backspace\n"
		"\"\x0d\"		^M		Return\n"
		"\"\x7f\"		^?		Backspace\n"
		":vtshell		Input to ANSI shell windows\n"
		":inherit main\n"
		"\"\x1b[A\"		\x1b [ A\n"
		"\"\x1b[A\"		.ku\n"
		"\"\x1b[B\"		\x1b [ B\n"
		"\"\x1b[B\"		.kd\n"
		"\"\x1b[C\"		\x1b [ C\n"
		"\"\x1b[C\"		.kr\n"
		"\"\x1b[D\"		\x1b [ D\n"
		"\"\x1b[D\"		.kl\n"
		"\"\x01\"		^A		BOL for bash\n"
		"\"\x03\"		^C		Abort\n"
		"\"\x04\"		^D		Eof\n"
		"\"\x05\"		^E		EOL for bash\n"
		"\"	\"	^I		Tab\n"
		"\"\x08\"		^H		Backspace\n"
		"\"\x0d\"		^M		Return\n"
		"\"\x7f\"		^?		Backspace\n"
,	"ftyperc",
		"[text]\n"
		"*\n"
		"*.txt\n"
		"[not_text]\n"
		"*.*\n"
		"-wordwrap\n"
		"[diff]\n"
		"*\n"
		"+\\? [A-Za-z]\n"
		"+Index: [A-Za-z]\n"
		"+Only in\n"
		"+Nur in\n"
		"+--- \n"
		"+\\*\\*\\* \n"
		"+[1-9][0-9]*[cda]\n"
		"*.diff\n"
		"*.patch\n"
		"-syntax diff\n"
		"[troff]\n"
		"*.1\n"
		"*.1.in\n"
		"-wordwrap\n"
		"-syntax troff\n"
		"[tex]\n"
		"*.tex\n"
		"*.sty\n"
		"-syntax tex\n"
		"-tex_comment\n"
		"-no_double_quoted\n"
		"-wordwrap\n"
		"[email]\n"
		"*.article*\n"
		"*.followup\n"
		"*.letter\n"
		"*tmp/nn.*\n"
		"*tmp/Re*\n"
		"*tmp/snd.*\n"
		"*tmp/dmt*\n"
		"*tmp/pico.*\n"
		"*tmp/mutt-*\n"
		"-wordwrap\n"
		"-syntax mail\n"
		"[avr]\n"
		"*.avr\n"
		"*.inc\n"
		"-syntax avr\n"
		"-autoindent\n"
		"-wordwrap\n"
		"-tab 8\n"
		"[assembly]\n"
		"*.asm\n"
		"*.s\n"
		"*.S\n"
		"-wordwrap\n"
		"-syntax asm\n"
		"[mason]\n"
		"*.mas\n"
		"-autoindent\n"
		"-syntax mason\n"
		"-smarthome\n"
		"-smartbacks\n"
		"[sml]\n"
		"*.sml\n"
		"-autoindent\n"
		"-syntax sml\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-istep 2\n"
		"[ocaml]\n"
		"*.ml\n"
		"*.mli\n"
		"-autoindent\n"
		"-syntax ocaml\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-istep 2\n"
		"[ruby]\n"
		"*.rb\n"
		"*\n"
		"+#![ 	]*[^\\n]*ruby[0-9.]*\\>\n"
		"*.gemspec\n"
		"*Gemfile\n"
		"*Rakefile\n"
		"*Guardfile\n"
		"*.rabl\n"
		"-autoindent\n"
		"-pound_comment\n"
		"-syntax ruby\n"
		"-text_delimiters do=end\n"
		"[perl]\n"
		"*\n"
		"+#![ 	]*[^\\n]*perl[0-9.]*\\>\n"
		"*.pl\n"
		"*.pm\n"
		"*.t\n"
		"-autoindent\n"
		"-syntax perl\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-pound_comment\n"
		"-single_quoted\n"
		"[sql]\n"
		"*.sql\n"
		"-autoindent\n"
		"-syntax sql\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"-c_comment\n"
		"-vhdl_comment\n"
		"-cpp_comment\n"
		"-text_delimiters BEGIN|Begin|begin=END|End|end\n"
		"-cpara >#!;*/%\n"
		"[awk]\n"
		"*.awk\n"
		"-autoindent\n"
		"-syntax awk\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-pound_comment\n"
		"[yacc]\n"
		"*.y\n"
		"-autoindent\n"
		"-syntax c\n"
		"-highlighter_context\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-text_delimiters #if|#ifdef|#ifndef=#elif=#else=#endif\n"
		"-cpara >#!;*/%\n"
		"[lex]\n"
		"*.l\n"
		"*.lex\n"
		"-autoindent\n"
		"-syntax c\n"
		"-highlighter_context\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-text_delimiters #if|#ifdef|#ifndef=#elif=#else=#endif\n"
		"-cpara >#!;*/%\n"
		"[ada]\n"
		"*.adb\n"
		"*.ads\n"
		"-syntax ada\n"
		"-autoindent\n"
		"-istep 2\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-vhdl_comment\n"
		"-text_delimiters declare|Declare|DECLARE|exception|Exception|EXCEPTION|if|If|IF|loop|Loop|LOOP|case|Case|CASE|package|Package|PACKAGE|procedure|Procedure|PROCEDURE|record|Record|RECORD|function|Function|FUNCTION=end|End|END\n"
		"[cobol]\n"
		"*.cbl\n"
		"*.cob\n"
		"-syntax cobol\n"
		"[rexx]\n"
		"*.rex\n"
		"*.REX\n"
		"*\n"
		"+#![ 	]*[^\\n]*rexx[0-9.]*\\>\n"
		"-syntax rexx\n"
		"-autoindent\n"
		"[sed]\n"
		"*.sed\n"
		"-syntax sed\n"
		"[postscript]\n"
		"*.ps\n"
		"*.eps\n"
		"-syntax ps\n"
		"[c]\n"
		"*.c\n"
		"*.cpp\n"
		"*.cc\n"
		"*.c++\n"
		"*.h\n"
		"*.h.in\n"
		"*.hpp\n"
		"*.h++\n"
		"*.hh\n"
		"*.mm\n"
		"-autoindent\n"
		"-syntax c\n"
		"-highlighter_context\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-text_delimiters #if|#ifdef|#ifndef=#elif=#else=#endif\n"
		"-cpara >#!;*/%\n"
		"[verilog]\n"
		"*.v\n"
		"*.vh\n"
		"-autoindent\n"
		"-syntax verilog\n"
		"-istep 2\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-text_delimiters `ifdef|`ifndef=`else=`endif:begin=end:case|casex|casez=endcase:function=endfunction:module=endmodule:task=endtask:attribute=endattribute:primitive=endprimitive:table=endtable\n"
		"-cpara >#!;*/%\n"
		"[vhdl]\n"
		"*.vhd\n"
		"-autoindent\n"
		"-syntax vhdl\n"
		"-istep 2\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-vhdl_comment\n"
		"-text_delimiters entity|ENTITY|if|IF|component|COMPONENT|loop|LOOP|configuration|CONFIGURATION|units|UNITS|record|RECORD|case|CASE|function|FUNCTION|package|PACKAGE|architecture|ARCHITECTURE|block|BLOCK|process|PROCESS|generate|GENERATE=end|END\n"
		"-cpara >#!;*-/%\n"
		"[xml]\n"
		"*.xml\n"
		"*.xsd\n"
		"*\n"
		"+<.xml\n"
		"*.jnlp\n"
		"*.resx\n"
		"*build.xml\n"
		"-autoindent\n"
		"-syntax xml\n"
		"[plist]\n"
		"*.plist\n"
		"-autoindent\n"
		"-syntax xml\n"
		"[html]\n"
		"*.htm\n"
		"*.html\n"
		"-wordwrap\n"
		"-autoindent\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-syntax html\n"
		"[css]\n"
		"*.css\n"
		"-wordwrap\n"
		"-autoindent\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-syntax css\n"
		"[java]\n"
		"*.java\n"
		"-autoindent\n"
		"-syntax java\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-purify\n"
		"-cpara >#!;*/%\n"
		"[javascript]\n"
		"*.js\n"
		"*\n"
		"+#![ 	]*[^\\n]*nodejs[0-9.]*\\>\n"
		"-autoindent\n"
		"-syntax js\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-cpara >#!;*/%\n"
		"[json]\n"
		"*.json\n"
		"-autoindent\n"
		"-syntax json\n"
		"-smarthome\n"
		"-smartbacks\n"
		"[typescript]\n"
		"*.ts\n"
		"-autoindent\n"
		"-syntax typescript\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-cpara >#!;*/%\n"
		"[php]\n"
		"*.php\n"
		"-autoindent\n"
		"-syntax php\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"[python]\n"
		"*\n"
		"+#![ 	]*[^\\n]*python[0-9.]*\\>\n"
		"*.py\n"
		"-autoindent\n"
		"-syntax python\n"
		"-highlighter_context\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"-pound_comment\n"
		"[csh]\n"
		"*\n"
		"+#![ 	]*[^\\n 	]*/csh\\>\n"
		"+#![ 	]*[^\\n 	]*/tcsh\\>\n"
		"*.csh\n"
		"*.login\n"
		"*.logout\n"
		"*.tcsh\n"
		"*.tcshrc\n"
		"-autoindent\n"
		"-syntax csh\n"
		"-pound_comment\n"
		"[sh]\n"
		"*\n"
		"+#![ 	]*[^\\n 	]*/sh\\>\n"
		"+#![ 	]*[^\\n 	]*/bash\\>\n"
		"*.sh\n"
		"*profile\n"
		"*.bash\n"
		"*.bashrc\n"
		"*.bash_login\n"
		"*.bash_logout\n"
		"-autoindent\n"
		"-syntax sh\n"
		"-highlighter_context\n"
		"-pound_comment\n"
		"-text_delimiters do=done:if=elif=else=fi:case=esac\n"
		"[lisp]\n"
		"*.lisp\n"
		"*.lsp\n"
		"*.el\n"
		"-autoindent\n"
		"-syntax lisp\n"
		"-semi_comment\n"
		"[ksh]\n"
		"*\n"
		"+#![ 	]*[^\\n 	]*/ksh\\>\n"
		"*.ksh\n"
		"-autoindent\n"
		"-syntax sh\n"
		"-highlighter_context\n"
		"-pound_comment\n"
		"-text_delimiters do=done:if=elif=else=fi:case=esac\n"
		"[pascal]\n"
		"*.p\n"
		"*.pas\n"
		"-autoindent\n"
		"-syntax pascal\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-text_delimiters begin|BEGIN|record|RECORD|case|CASE=end|END:repeat|REPEAT=until|UNTIL\n"
		"[fortran]\n"
		"*.f\n"
		"*.f90\n"
		"*.for\n"
		"*.FOR\n"
		"-autoindent\n"
		"-syntax fortran\n"
		"[skill]\n"
		"*.il\n"
		"-semi_comment\n"
		"-syntax skill\n"
		"-autoindent\n"
		"-istep 3\n"
		"-indentc 32\n"
		"-smartbacks\n"
		"-smarthome\n"
		"-indentfirst\n"
		"[lua]\n"
		"*.lua\n"
		"*\n"
		"+#![ 	]*[^\\n]*lua[0-9.]*\\>\n"
		"-autoindent\n"
		"-syntax lua\n"
		"[tcl]\n"
		"*.tcl\n"
		"-autoindent\n"
		"-syntax tcl\n"
		"[go]\n"
		"*.go\n"
		"-autoindent\n"
		"-syntax go\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"-c_comment\n"
		"-text_delimiters #if|#ifdef|#ifndef=#elif=#else=#endif\n"
		"-cpara >#!;*/%\n"
		"[c#]\n"
		"*.cs\n"
		"-autoindent\n"
		"-syntax csharp\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-cpara >#!;*/%\n"
		"-text_delimiters #region=#endregion:#if=#elif=#else=#endif\n"
		"[jsf]\n"
		"*.jsf\n"
		"*.jsf.in\n"
		"-autoindent\n"
		"-syntax jsf\n"
		"-smarthome\n"
		"[m4]\n"
		"*.ac\n"
		"*.m4\n"
		"-autoindent\n"
		"-syntax m4\n"
		"[matlab]\n"
		"*.m\n"
		"-wordwrap\n"
		"-syntax matlab\n"
		"[conf]\n"
		"*.am\n"
		"*rc\n"
		"*Makefile\n"
		"*makefile.in\n"
		"*Makefile.in\n"
		"*makefile\n"
		"*AKEFILE\n"
		"-autoindent\n"
		"-syntax conf\n"
		"-pound_comment\n"
		"[bat]\n"
		"*.bat\n"
		"*.cmd\n"
		"-autoindent\n"
		"-syntax batch\n"
		"[joerc]\n"
		"*ftyperc\n"
		"*joerc\n"
		"*jmacsrc\n"
		"*jstarrc\n"
		"*rjoerc\n"
		"*jpicorc\n"
		"*joerc.in\n"
		"*jmacsrc.in\n"
		"*jstarrc.in\n"
		"*rjoerc.in\n"
		"*jpicorc.in\n"
		"-syntax joerc\n"
		"[markdown]\n"
		"*.md\n"
		"-syntax md\n"
		"-wordwrap\n"
		"[yaml]\n"
		"*.yml\n"
		"*.yaml\n"
		"-autoindent\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-pound_comment\n"
		"-syntax yaml\n"
		"[debian]\n"
		"*apt/sources.list\n"
		"*sources.list.*\n"
		"-pound_comment\n"
		"-syntax debian\n"
		"[java_properties]\n"
		"*.properties\n"
		"-encoding iso-8859-1\n"
		"-pound_comment\n"
		"-syntax properties\n"
		"[ini]\n"
		"*.ini\n"
		"*.inf\n"
		"*hgrc\n"
		"*.gitconfig\n"
		"*.git/config\n"
		"-syntax ini\n"
		"-pound_comment\n"
		"-semi_comment\n"
		"[erb]\n"
		"*.erb\n"
		"-syntax erb\n"
		"[erb_html]\n"
		"*.html.erb\n"
		"-syntax htmlerb\n"
		"[haml]\n"
		"*.haml\n"
		"-syntax haml\n"
		"-istep 2\n"
		"-indentc 32\n"
		"-autoindent\n"
		"-smarthome\n"
		"-smartbacks\n"
		"[erlang]\n"
		"*.erl\n"
		"*.eterm\n"
		"*.app.src\n"
		"*rebar.config\n"
		"*.hrl\n"
		"*.erlang\n"
		"-syntax erlang\n"
		"-autoindent\n"
		"[sieve]\n"
		"*.sieve\n"
		"-syntax sieve\n"
		"-autoindent\n"
		"[puppet]\n"
		"*.pp\n"
		"-syntax puppet\n"
		"-pound_comment\n"
		"-autoindent\n"
		"[iptables]\n"
		"*\n"
		"+# Generated by iptables-save\n"
		"+# Generated by ip6tables-save\n"
		"-syntax iptables\n"
		"-pound_comment\n"
		"[powershell]\n"
		"*.ps1\n"
		"-syntax powershell\n"
		"[git-commit]\n"
		"*COMMIT_EDITMSG\n"
		"-syntax git-commit\n"
		"[elixir]\n"
		"*.ex\n"
		"*.exs\n"
		"-autoindent\n"
		"-syntax elixir\n"
		"-pound_comment\n"
		"-text_delimiters do=end\n"
		"[r]\n"
		"*.r\n"
		"-autoindent\n"
		"-syntax r\n"
		"-pound_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"[groovy]\n"
		"*.gvy\n"
		"*.groovy\n"
		"*.gy\n"
		"*.gsh\n"
		"-autoindent\n"
		"-syntax groovy\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"[clojure]\n"
		"*.clj\n"
		"*.cljs\n"
		"*.cljc\n"
		"*.edn\n"
		"-autoindent\n"
		"-syntax clojure\n"
		"-semi_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"[rust]\n"
		"*.rs\n"
		"-autoindent\n"
		"-syntax rust\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"[coffee]\n"
		"*.coffee\n"
		"-autoindent\n"
		"-syntax coffee\n"
		"-pound_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"[scala]\n"
		"*.scala\n"
		"-autoindent\n"
		"-syntax scala\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"[swift]\n"
		"*.swift\n"
		"-autoindent\n"
		"-syntax swift\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
		"[d]\n"
		"*.d\n"
		"-autoindent\n"
		"-syntax d\n"
		"-c_comment\n"
		"-cpp_comment\n"
		"-smarthome\n"
		"-smartbacks\n"
		"-purify\n"
		"-single_quoted\n"
,	"c.jsf",
		"\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"-\n"
		"\n"
		"\n"
		"=Idle\n"
		"=Bad		bold red\n"
		"=Preproc 	blue\n"
		"=Define		bold blue\n"
		"=Comment 	green\n"
		"=IncLocal	cyan\n"
		"=IncSystem	bold cyan\n"
		"=Constant 	cyan\n"
		"=Escape 	bold cyan\n"
		"=Type 		bold\n"
		"=Keyword 	bold\n"
		"=CppKeyword	bold\n"
		"=Brace		magenta\n"
		"=Control\n"
		"\n"
		":reset Idle\n"
		"	*		first		noeat\n"
		"	\" \\t\"		reset\n"
		"\n"
		":first Idle\n"
		"	*		idle		noeat\n"
		"	\"#\"		pre		recolor=-1\n"
		"\n"
		":pre Preproc\n"
		"	*		preproc		noeat\n"
		"	\" \\t\"		pre\n"
		"	\"a-z\"		preident	recolor=-1 buffer\n"
		"\n"
		":preident Preproc\n"
		"	*		preproc		noeat strings\n"
		"	\"define\"	predef\n"
		"	\"include\"	preinc\n"
		"done\n"
		"	\"a-z\"		preident\n"
		"\n"
		":preinc Preproc\n"
		"	*		preinc\n"
		"	\" \\t\"		preinc_ws\n"
		"	\"\\n\"		reset\n"
		"	\n"
		":preinc_ws Preproc\n"
		"	*		prebad		recolor=-1\n"
		"	\" \\t\"		preinc_ws\n"
		"	\"\\\"\"		preinc_local	recolor=-1\n"
		"	\"<\"		preinc_system	recolor=-1\n"
		"\n"
		":preinc_local IncLocal string\n"
		"	*		preinc_local\n"
		"	\"\\\"\\n\"		reset\n"
		"	\n"
		":preinc_system IncSystem string\n"
		"	*		preinc_system\n"
		"	\">\\n\"		reset\n"
		"\n"
		":prebad	Bad	\n"
		"	*		prebad\n"
		"	\"\\n\"		reset\n"
		"\n"
		"\n"
		":predef Preproc\n"
		"	*		predef\n"
		"	\" \\t\"		predef_ws\n"
		"	\"\\n\"		reset\n"
		"	\n"
		":predef_ws Preproc\n"
		"	*		prebad		recolor=-1\n"
		"	\" \\t\"		predef_ws\n"
		"	\"\\c\"		predef_ident	recolor=-1\n"
		"\n"
		":predef_ident Define\n"
		"	*		idle		noeat\n"
		"	\"\\c\"		predef_ident\n"
		"\n"
		"\n"
		":preproc Preproc\n"
		"	*		preproc\n"
		"	\"\\n\"		reset\n"
		"	\"\\\\\"		preproc_cont\n"
		"	\"/\"		preproc_slash\n"
		"	\n"
		":preproc_slash Preproc\n"
		"	*		preproc		noeat\n"
		"	\"*\"		comment		recolor=-2\n"
		"	\"/\"		line_comment	recolor=-2\n"
		"	\n"
		":preproc_cont Preproc\n"
		"	*		preproc_cont\n"
		"	\"\\n\"		preproc\n"
		"\n"
		"\n"
		":idle Idle\n"
		"	*		idle\n"
		"	\"\\n\"		reset\n"
		"	\"/\"		slash\n"
		"	\"0\"		first_digit	recolor=-1\n"
		"	\"1-9\"		decimal	recolor=-1\n"
		"	\".\"		maybe_float\n"
		"	\"\\\"\"		string		recolor=-1\n"
		"	\"'\"		char		recolor=-1\n"
		"	\"\\i\"		ident		buffer\n"
		"	\"\\\\\"		outside_escape	recolor=-1\n"
		"	\"{}\"		brace		recolor=-1\n"
		"	\",:;=()><[]*&|!~+\\-%^\"	control		recolor=-1\n"
		"\n"
		":outside_escape	Escape\n"
		"	*	idle\n"
		"\n"
		":brace Brace\n"
		"	*	idle	noeat\n"
		"\n"
		":control Control\n"
		"	*	idle	noeat\n"
		"\n"
		":slash Idle\n"
		"	*		idle		noeat recolor=-2	# Not sure about this\n"
		"	\"*\"		comment		recolor=-2\n"
		"	\"/\"		line_comment	recolor=-2\n"
		"\n"
		":comment Comment comment\n"
		"	*		comment\n"
		"	\"*\"		maybe_end_comment\n"
		"\n"
		":maybe_end_comment Comment comment\n"
		"	*		comment\n"
		"	\"/\"		idle\n"
		"	\"*\"		maybe_end_comment\n"
		"\n"
		":line_comment Comment comment\n"
		"	*		line_comment\n"
		"	\"\\n\"		reset\n"
		"\n"
		":first_digit Constant\n"
		"	*		idle	noeat\n"
		"	\"xX\"		hex\n"
		"	\".\"		float\n"
		"	\"eE\"		epart\n"
		"	\"0-7\"		octal\n"
		"	\"89\"		bad_number	recolor=-1\n"
		"\n"
		":bad_number Bad\n"
		"	*		idle	noeat\n"
		"	\"0-9\"		bad_number\n"
		"\n"
		":octal Constant\n"
		"	*		idle	noeat\n"
		"	\"0-7\"		octal\n"
		"	\"89\"		bad_number	recolor=-1\n"
		"\n"
		":hex Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9A-Fa-f\"	hex\n"
		"\n"
		":decimal Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9\"		decimal\n"
		"	\"eE\"		epart\n"
		"	\".\"		float\n"
		"\n"
		":maybe_float Constant\n"
		"	*		idle	recolor=-2	noeat\n"
		"	\"0-9\"		float		recolor=-2\n"
		"\n"
		":float Constant\n"
		"	*		idle	noeat\n"
		"	\"eE\"		epart\n"
		"	\"0-9\"		float\n"
		"\n"
		":epart Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9+\\-\"	enum\n"
		"\n"
		":enum Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9\"		enum\n"
		"\n"
		":string	Constant string\n"
		"	*		string\n"
		"	\"\\\"\"		idle\n"
		"	\"\\\\\"		string_escape	recolor=-1\n"
		"	\"%\"		string_control	recolor=-1\n"
		"\n"
		":string_escape Escape string\n"
		"	*		string\n"
		"	\"x\"		string_hex\n"
		"	\"0-7\"		string_octal2\n"
		"	\"\\n\"		string		recolor=-2\n"
		"\n"
		":string_hex Escape string\n"
		"	*		string		noeat\n"
		"	\"0-9a-fA-F\"	string_hex\n"
		"\n"
		":string_octal2 Escape string\n"
		"	*		string		noeat\n"
		"	\"0-7\"		string_octal3\n"
		"\n"
		":string_octal3 Escape string\n"
		"	*		string		noeat\n"
		"	\"0-7\"		string\n"
		"\n"
		":string_control Escape string\n"
		"	*		string\n"
		"	\"\\\"\"		string noeat\n"
		"	\"\\n\"		reset\n"
		"	\"\\\\\"		string_escape	recolor=-1\n"
		"	\"0-9.\\-+ #hjILtz$\"	string_control\n"
		"\n"
		":char Constant string\n"
		"	*		char\n"
		"	\"\\n\"		reset\n"
		"	\"'\"		idle\n"
		"	\"\\\\\"		char_escape	recolor=-1\n"
		"\n"
		":char_escape	Escape string\n"
		"	*		char\n"
		"	\"x\"		char_hex\n"
		"	\"0-7\"		char_octal2\n"
		"	\"\\n\"		char		recolor=-2\n"
		"\n"
		":char_hex Escape string\n"
		"	*		char		noeat\n"
		"	\"0-9a-fA-F\"	char_hex\n"
		"\n"
		":char_octal2 Escape string\n"
		"	*		char		noeat\n"
		"	\"0-7\"		char_octal3\n"
		"\n"
		":char_octal3 Escape string\n"
		"	*		char		noeat\n"
		"	\"0-7\"		char\n"
		"\n"
		":ident Idle\n"
		"	*		idle		noeat strings\n"
		"	\"int\"		type\n"
		"	\"float\"		type\n"
		"	\"long\"		type\n"
		"	\"short\"		type\n"
		"	\"char\"		type\n"
		"	\"double\"	type\n"
		"	\"signed\"	type\n"
		"	\"unsigned\"	type\n"
		"	\"void\"		type\n"
		"	\"static\"	type\n"
		"	\"register\"	type\n"
		"	\"extern\"	type\n"
		"	\"inline\"	type\n"
		"	\"auto\"		type\n"
		"	\"const\"		type\n"
		"	\"volatile\"	type\n"
		"	\"if\"		kw\n"
		"	\"else\"		kw\n"
		"	\"while\"		kw\n"
		"	\"for\"		kw\n"
		"	\"break\"		kw\n"
		"	\"continue\"	kw\n"
		"	\"do\"		kw\n"
		"	\"case\"		kw\n"
		"	\"default\"	kw\n"
		"	\"switch\"	kw\n"
		"	\"goto\"		kw\n"
		"	\"struct\"	kw\n"
		"	\"enum\"		kw\n"
		"	\"return\"	kw\n"
		"	\"sizeof\"	kw\n"
		"	\"typedef\"	kw\n"
		"	\"union\"		kw\n"
		"	\"asm\"		kw\n"
		"	#\"asm\"			cppkw (listed above as a C keyword)\n"
		"	\"bool\"			cppkw\n"
		"	\"catch\"			cppkw\n"
		"	\"class\"			cppkw\n"
		"	\"const_cast\"		cppkw\n"
		"	\"delete\"		cppkw\n"
		"	\"dynamic_cast\"		cppkw\n"
		"	\"explicit\"		cppkw\n"
		"	\"false\"			cppkw\n"
		"	\"friend\"		cppkw\n"
		"	#\"inline\"		cppkw (listed above as a C keyword)\n"
		"	\"mutable\"		cppkw\n"
		"	\"namespace\"		cppkw\n"
		"	\"new\"			cppkw\n"
		"	\"operator\"		cppkw\n"
		"	\"private\"		cppkw\n"
		"	\"protected\"		cppkw\n"
		"	\"public\"		cppkw\n"
		"	\"reinterpret_cast\"	cppkw\n"
		"	\"static_cast\"		cppkw\n"
		"	\"template\"		cppkw\n"
		"	\"this\"			cppkw\n"
		"	\"throw\"			cppkw\n"
		"	\"true\"			cppkw\n"
		"	\"try\"			cppkw\n"
		"	\"typeid\"		cppkw\n"
		"	\"typename\"		cppkw\n"
		"	\"using\"			cppkw\n"
		"	\"virtual\"		cppkw\n"
		"	\"wchar_t\"		type\n"
		"	\"typeof\"		cppkw\n"
		"done\n"
		"	\"\\c\"		ident\n"
		"\n"
		":type Type\n"
		"	*	idle	noeat\n"
		"\n"
		":kw Keyword\n"
		"	*	idle	noeat\n"
		"\n"
		":cppkw CppKeyword\n"
		"	*	idle	noeat\n"
,	NULL
};
