package junit.test.svg;

import junit.framework.TestCase;
import latexDraw.parsers.svg.CSSStyleList;

import org.junit.Test;

/** 
 * This class contains tests on CSSStyleList class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 03/29/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestCSSStyleList extends TestCase
{
	protected CSSStyleList list = new CSSStyleList();
	
	@Test
	public void testAddCSSStyle()
	{
		list.clear();
		list.addCSSStyle(null, null);
		assertEquals(0, list.size());
		list.addCSSStyle("", null);
		assertEquals(0, list.size());
		list.addCSSStyle(null, "");
		assertEquals(0, list.size());
		list.addCSSStyle("name", "value");
		assertEquals(1, list.size());
		assertEquals("value", list.getCSSValue("name"));
		list.clear();
	}
	
	
	@Test
	public void testGetCSSValue()
	{
		list.clear();
		assertNull(list.getCSSValue(null));
		assertNull(list.getCSSValue(""));
		assertNull(list.getCSSValue("test"));
		list.addCSSStyle("name", "value");
		assertEquals(1, list.size());
		assertEquals("value", list.getCSSValue("name"));
		assertNull(list.getCSSValue(null));
		assertNull(list.getCSSValue(""));
		assertNull(list.getCSSValue("test"));
		list.clear();
	}
	
	
	@Test
	public void testOnCSSStyle()
	{
		list.clear();
		list.addCSSStyle(null, null);
		assertEquals(0, list.size());
		list.addCSSStyle("", null);
		assertEquals(0, list.size());
		list.addCSSStyle(null, "");
		assertEquals(0, list.size());
		list.addCSSStyle("name", "value");
		assertEquals(1, list.size());
		assertEquals("value", list.getCSSValue("name"));
		list.clear();
	}
}
