/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcas_gsi_utils.h
    \brief  This file contains the headers for utility functions to retrieve
            info from gsi credentials/contexts (at the gssapi level)
    \author Martijn Steenbakkers for EGEE

    This file contains utility functions to retrieve info from gsi
    credentials/contexts (at the gssapi and gsi level)
    The following functions are defined:
    -# lcas_cred_to_x509()
    -# lcas_cred_to_x509_chain()
    -# lcas_gss_cred_to_dn()
*/

#ifndef _LCAS_GSI_UTILS_H
#define _LCAS_GSI_UTILS_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include <openssl/x509.h>
#include <gssapi.h>

/******************************************************************************
 *                 Module definition
 *****************************************************************************/

#ifndef LCAS_GSI_UTILS_C
#   define LCAS_GSI_UTILS_STORAGE_CLASS extern
#else
#   define LCAS_GSI_UTILS_STORAGE_CLASS
#endif

/******************************************************************************
Function:       lcas_gss_cred_to_dn() (copied from GLOBUS gatekeeper.c)
Description:    Get the globusid from gssapi
Parameters:
                globus_cred: globus credential
Returns:        globusid string (which could be freeed)
******************************************************************************/
/*!
    \fn lcas_gss_cred_to_dn(
        gss_cred_id_t globus_cred
        )
    \brief Get the globus DN from GLOBUS credential (gssapi).

    (copied and modified from GLOBUS gatekeeper.c)
    \param globus_cred GLOBUS credential
    \return globus DN string (which may should be freed)
    \internal
*/
LCAS_GSI_UTILS_STORAGE_CLASS char * lcas_gss_cred_to_dn(
        gss_cred_id_t globus_cred
);

/******************************************************************************
Function:       lcas_cred_to_x509()
Description:    Return the pointer to X509 structure from gss credential
Parameters:
                cred: globus credential
Returns:        pointer to X509 struct or NULL
******************************************************************************/
LCAS_GSI_UTILS_STORAGE_CLASS X509 * lcas_cred_to_x509(
        gss_cred_id_t cred
);


/******************************************************************************
Function:       lcas_cred_to_x509_chain()
Description:    Return the pointer to X509 chain from gss credential
Parameters:
                cred: globus credential
Returns:        pointer to X509 chain or NULL
******************************************************************************/
LCAS_GSI_UTILS_STORAGE_CLASS STACK_OF(X509) * lcas_cred_to_x509_chain(
        gss_cred_id_t cred
);

#endif /* _LCAS_GSI_UTILS_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/src/grid_credential_handling/gsi_handling/_lcas_gsi_utils.h,v $
    $Date: 2010-05-03 10:42:50 $
    $Revision: 1.2 $
    $Author: okoeroo $
******************************************************************************/
