/*
 *  Copyright 1994-2019 Olivier Girondel
 *  Copyright 2019 Laurent Marsac
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BLUR_H
#define __BLUR_H

static enum BorderMode border_mode;

json_t *
get_parameters()
{
  json_t *params = json_object();
  plugin_parameters_add_string_list(params, BPP_BORDER_MODE, BM_NB, border_list, border_mode);

  return params;
}


void
set_parameters(const json_t *in_parameters)
{
  int border_mode_idx = 0;
  if (plugin_parameter_parse_string_list_as_int_range(in_parameters, BPP_BORDER_MODE, BM_NB, border_list, &border_mode_idx, 0, BM_NB-1)) {
    border_mode = (enum BorderMode)border_mode_idx;
  }
}


json_t *
parameters(json_t *in_parameters)
{
  set_parameters(in_parameters);

  return get_parameters();
}


#endif /* __BLUR_H */
