/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.builder.ILisaacErrorHandler;
import org.lisaac.ldt.editors.AbstractLisaacEditor;
import org.lisaac.ldt.editors.LisaacEditor;
import org.lisaac.ldt.model.AliasString;
import org.lisaac.ldt.model.ILisaacContext;
import org.lisaac.ldt.model.ILisaacFileVisitor;
import org.lisaac.ldt.model.ILisaacModel;
import org.lisaac.ldt.model.LipParser;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.LisaacPath;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.lip.LIP;

public class LisaacModel
implements ILisaacModel {
    private static HashMap<IProject, LisaacModel> modelList;
    private LisaacPath modelPath;
    private HashMap<String, Prototype> prototypes;
    private LIP lipCode;
    private IProject project;
    private ILisaacErrorHandler reporter;
    private LisaacParser parser;
    private AliasString aliasString;
    private boolean isProjectCompiled;
    public static AbstractLisaacEditor currentEditor;

    static {
        currentEditor = null;
    }

    public LisaacModel(IProject project) {
        this.project = project;
        this.prototypes = new HashMap();
        this.aliasString = new AliasString();
        if (modelList == null) {
            modelList = new HashMap();
        }
        modelList.put(project, this);
        this.modelPath = new LisaacPath(project, "make.lip");
        this.isProjectCompiled = false;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public AliasString getAliasString() {
        return this.aliasString;
    }

    public LisaacParser getParser() {
        return this.parser;
    }

    public LisaacPath getPathManager() {
        return this.modelPath;
    }

    public LIP getLipCode() {
        return this.lipCode;
    }

    public Prototype getPrototype(String name) throws CoreException {
        String prototypePath;
        Prototype result = null;
        if (this.prototypes != null && (result = this.prototypes.get(name)) == null && this.modelPath != null && (prototypePath = this.modelPath.getFullPath(name)) != null) {
            Path location = new Path(prototypePath);
            IPath projectLocation = this.project.getLocation();
            IFile file = null;
            if (projectLocation.isPrefixOf((IPath)location)) {
                location = location.removeFirstSegments(projectLocation.segmentCount());
                file = this.project.getFile((IPath)location);
            } else {
                IFolder lib = this.project.getFolder("lib");
                if (!lib.exists()) {
                    lib.create(false, true, null);
                }
                if (!(file = lib.getFile((IPath)new Path(location.lastSegment()))).isAccessible() && !file.exists()) {
                    file.createLink((IPath)location, 0, null);
                }
            }
            result = this.parsePrototype(file, file.getContents(), new ILisaacErrorHandler(){

                public void fatalError(String msg, Position position) {
                }

                public void semanticError(String msg, Position position) {
                }

                public void syntaxError(String msg, Position position) {
                }

                public void warning(String msg, Position position) {
                }

                public void enableErrorReport(boolean enable) {
                }
            });
        }
        return result;
    }

    public void refreshPresentation() {
        AbstractLisaacEditor part = currentEditor;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (currentEditor != null) {
            display.asyncExec(new Runnable((IWorkbenchPart)part){
                private final /* synthetic */ IWorkbenchPart val$part;
                {
                    this.val$part = iWorkbenchPart;
                }

                public void run() {
                    ((AbstractLisaacEditor)this.val$part).refreshPresentation();
                }
            });
        }
    }

    public void accept(ILisaacFileVisitor visitor) {
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && resource.getName().endsWith(".li")) {
                        String name = LisaacModel.extractPrototypeName(resource.getName());
                        visitor.visit(LisaacModel.this.getPrototype(name));
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Prototype parsePrototype(IFile file, InputStream contents, ILisaacErrorHandler reporter) {
        this.reporter = reporter;
        String name = file.getName();
        String prototypeName = LisaacModel.extractPrototypeName(name);
        this.modelPath.addPath(prototypeName, file.getLocation());
        this.parser = new LisaacParser(prototypeName, contents, this);
        Prototype prototype = new Prototype(file, prototypeName, this);
        ILisaacContext context = this.parser.readContext();
        while (context != null) {
            context = context.parseDefinition(prototype) ? this.parser.readContext() : context.getNextContext();
        }
        this.parser.setLastSection(null);
        this.prototypes.put(prototype.getName(), prototype);
        return prototype;
    }

    public void removePrototype(IResource resource) {
        this.prototypes.remove(LisaacModel.extractPrototypeName(resource.getName()));
    }

    public void parseLip(String name, InputStream contents, ILisaacErrorHandler reporter) throws CoreException {
        this.reporter = reporter;
        this.lipCode = new LIP(name);
        LipParser lipParser = new LipParser(contents, this);
        if (!lipParser.parse()) {
            reporter.syntaxError("Syntax error.", lipParser.getPosition());
            return;
        }
    }

    public void removeLip(IResource resource) {
    }

    public static String extractPrototypeName(String s) {
        int idx = s.indexOf(46);
        if (idx != -1) {
            return s.substring(0, idx).toUpperCase();
        }
        return s.toUpperCase();
    }

    public ILisaacErrorHandler getReporter() {
        return this.reporter;
    }

    public static LisaacModel getModel(IProject p) {
        if (modelList != null) {
            return modelList.get(p);
        }
        return null;
    }

    public static Prototype getCurrentPrototype() throws CoreException {
        IWorkbenchWindow w = LisaacPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return null;
        }
        IPartService service = w.getPartService();
        if (service == null) {
            return null;
        }
        Object part = service.getActivePart();
        if (part == null || !(part instanceof LisaacEditor)) {
            part = currentEditor;
        }
        if (part instanceof LisaacEditor) {
            IProject project = ((LisaacEditor)((Object)part)).getProject();
            String filename = ((LisaacEditor)((Object)part)).getFileName();
            LisaacModel model = LisaacModel.getModel(project);
            if (model != null) {
                return model.getPrototype(LisaacModel.extractPrototypeName(filename));
            }
        }
        return null;
    }

    public void refreshPath() {
        this.modelPath = new LisaacPath(this.project, "make.lip");
    }

    public boolean needCompilation() {
        return !this.isProjectCompiled;
    }

    public void setCompiled(boolean done) {
        this.isProjectCompiled = done;
    }
}

