/* desktop-entry-impl-gio.c generated by valac 0.10.4, the Vala compiler
 * generated from desktop-entry-impl-gio.vala, do not modify */

/*
 * Desktop Agnostic Library: Desktop Entry implementation using GLib.
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/fdo.h>
#include <libdesktop-agnostic/vfs.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO (desktop_agnostic_fdo_desktop_entry_gio_get_type ())
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO, DesktopAgnosticFDODesktopEntryGio))
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO, DesktopAgnosticFDODesktopEntryGioClass))
#define DESKTOP_AGNOSTIC_FDO_IS_DESKTOP_ENTRY_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO))
#define DESKTOP_AGNOSTIC_FDO_IS_DESKTOP_ENTRY_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO))
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO, DesktopAgnosticFDODesktopEntryGioClass))

typedef struct _DesktopAgnosticFDODesktopEntryGio DesktopAgnosticFDODesktopEntryGio;
typedef struct _DesktopAgnosticFDODesktopEntryGioClass DesktopAgnosticFDODesktopEntryGioClass;
typedef struct _DesktopAgnosticFDODesktopEntryGioPrivate DesktopAgnosticFDODesktopEntryGioPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _DesktopAgnosticFDODesktopEntryGio {
	GObject parent_instance;
	DesktopAgnosticFDODesktopEntryGioPrivate * priv;
};

struct _DesktopAgnosticFDODesktopEntryGioClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticFDODesktopEntryGioPrivate {
	GKeyFile* _keyfile;
	gboolean loaded;
	DesktopAgnosticVFSFile* _file;
};


static gpointer desktop_agnostic_fdo_desktop_entry_gio_parent_class = NULL;
static DesktopAgnosticFDODesktopEntryIface* desktop_agnostic_fdo_desktop_entry_gio_desktop_agnostic_fdo_desktop_entry_parent_iface = NULL;

#define DESKTOP_AGNOSTIC_FDO_GROUP "Desktop Entry"
GType desktop_agnostic_fdo_desktop_entry_gio_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO, DesktopAgnosticFDODesktopEntryGioPrivate))
enum  {
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_FILE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_KEYFILE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_DATA,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ENTRY_TYPE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_NAME,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ICON
};
static gboolean desktop_agnostic_fdo_desktop_entry_gio_real_key_exists (DesktopAgnosticFDODesktopEntry* base, const char* key);
static gboolean desktop_agnostic_fdo_desktop_entry_gio_real_get_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_gio_real_set_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key, gboolean value);
static char* desktop_agnostic_fdo_desktop_entry_gio_real_get_string (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_gio_real_set_string (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* value);
static char* desktop_agnostic_fdo_desktop_entry_gio_real_get_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale);
static void desktop_agnostic_fdo_desktop_entry_gio_real_set_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale, const char* value);
static char** desktop_agnostic_fdo_desktop_entry_gio_real_get_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_gio_real_set_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key, char** value);
static gboolean desktop_agnostic_fdo_desktop_entry_gio_real_exists (DesktopAgnosticFDODesktopEntry* base);
static GPid desktop_agnostic_fdo_desktop_entry_gio_real_launch (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryLaunchFlags flags, GSList* documents, GError** error);
static void desktop_agnostic_fdo_desktop_entry_gio_real_save (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* new_file, GError** error);
DesktopAgnosticFDODesktopEntryGio* desktop_agnostic_fdo_desktop_entry_gio_new (void);
DesktopAgnosticFDODesktopEntryGio* desktop_agnostic_fdo_desktop_entry_gio_construct (GType object_type);
static void desktop_agnostic_fdo_desktop_entry_gio_finalize (GObject* obj);
static void desktop_agnostic_fdo_desktop_entry_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_fdo_desktop_entry_gio_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType register_plugin (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean desktop_agnostic_fdo_desktop_entry_gio_real_key_exists (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGio * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_val_if_fail (key != NULL, FALSE);
	if (g_key_file_has_group (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP)) {
		gboolean _tmp1_;
		_tmp1_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean desktop_agnostic_fdo_desktop_entry_gio_real_get_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGio * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_;
		_tmp0_ = g_key_file_get_boolean (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-gio.vala:204: Error trying to retrieve '%s': %s", key, err->message);
			result = FALSE;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally0:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key, gboolean value) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, value);
}


static char* desktop_agnostic_fdo_desktop_entry_gio_real_get_string (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGio * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_val_if_fail (key != NULL, NULL);
	{
		char* _tmp0_;
		_tmp0_ = g_key_file_get_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-gio.vala:224: Error trying to retrieve '%s': %s", key, err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally1:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_string (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* value) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	g_key_file_set_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, value);
}


static char* desktop_agnostic_fdo_desktop_entry_gio_real_get_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale) {
	DesktopAgnosticFDODesktopEntryGio * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_val_if_fail (key != NULL, NULL);
	{
		char* _tmp0_;
		_tmp0_ = g_key_file_get_locale_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, locale, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-gio.vala:244: Error trying to retrieve '%s[%s]': %s", key, locale, err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally2:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale, const char* value) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_if_fail (key != NULL);
	g_return_if_fail (locale != NULL);
	g_return_if_fail (value != NULL);
	g_key_file_set_locale_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, locale, value);
}


static char** desktop_agnostic_fdo_desktop_entry_gio_real_get_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGio * self;
	char** result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_val_if_fail (key != NULL, NULL);
	{
		gint _tmp1__length1;
		gint __tmp1__size_;
		char** _tmp2_;
		gsize _tmp0_;
		char** _tmp1_;
		_tmp1_ = (_tmp2_ = g_key_file_get_string_list (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp1_;
		return result;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-gio.vala:266: Error trying to retrieve '%s': %s", key, err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally3:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key, char** value) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	g_return_if_fail (key != NULL);
	g_key_file_set_string_list (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, (const gchar* const*) value, _vala_array_length (value));
}


/**
     * Based on EggDesktopFile's egg_desktop_file_can_launch().
     */
static gboolean desktop_agnostic_fdo_desktop_entry_gio_real_exists (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticFDODesktopEntryGio * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	switch (desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self)) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION:
		{
			gboolean _tmp0_;
			char* exec;
			gint argv_length1;
			gint _argv_size_;
			char** _tmp4_;
			char** argv;
			char* _tmp5_;
			gboolean _tmp6_ = FALSE;
			char* _tmp8_;
			gboolean _tmp9_;
			_tmp0_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "TryExec", &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp0_) {
				char* _tmp1_;
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = (_tmp2_ = g_find_program_in_path (_tmp1_ = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "TryExec"))) != NULL, _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_)) {
					result = TRUE;
					return result;
				}
			}
			exec = NULL;
			argv = (_tmp4_ = NULL, argv_length1 = 0, _argv_size_ = argv_length1, _tmp4_);
			;
			exec = (_tmp5_ = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Exec"), _g_free0 (exec), _tmp5_);
			if (exec == NULL) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = g_shell_parse_argv (exec, &argv_length1, &argv, &_inner_error_);
				if (_inner_error_ != NULL) {
					argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (exec);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp6_ = !_tmp7_;
			}
			if (_tmp6_) {
				result = FALSE;
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (exec);
				return result;
			}
			result = (_tmp9_ = (_tmp8_ = g_find_program_in_path (argv[0])) != NULL, _g_free0 (_tmp8_), _tmp9_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exec);
			return result;
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exec);
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK:
		{
			gboolean _tmp10_;
			_tmp10_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp10_) {
				char* uri;
				DesktopAgnosticVFSFile* file;
				uri = g_key_file_get_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				file = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				result = desktop_agnostic_vfs_file_exists (file);
				_g_object_unref0 (file);
				_g_free0 (uri);
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


/**
     * Launch desktop entry.
     * @return always zero.
     */
static GPid desktop_agnostic_fdo_desktop_entry_gio_real_launch (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryLaunchFlags flags, GSList* documents, GError** error) {
	DesktopAgnosticFDODesktopEntryGio * self;
	GPid result = 0;
	GList* uris;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	uris = NULL;
	{
		GSList* s_collection;
		GSList* s_it;
		s_collection = documents;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* s;
			s = (const char*) s_it->data;
			{
				uris = g_list_append (uris, s);
			}
		}
	}
	switch (desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self)) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION:
		{
			GAppInfo* info;
			info = NULL;
			if (self->priv->_file != NULL) {
				char* _tmp0_;
				GAppInfo* _tmp1_;
				info = (_tmp1_ = (GAppInfo*) g_desktop_app_info_new_from_filename (_tmp0_ = desktop_agnostic_vfs_file_get_path (self->priv->_file)), _g_object_unref0 (info), _tmp1_);
				_g_free0 (_tmp0_);
			} else {
				GAppInfo* _tmp2_;
				info = (_tmp2_ = (GAppInfo*) g_desktop_app_info_new_from_keyfile (self->priv->_keyfile), _g_object_unref0 (info), _tmp2_);
			}
			g_app_info_launch_uris (info, uris, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (info);
				_g_list_free0 (uris);
				return 0;
			}
			_g_object_unref0 (info);
			break;
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK:
		{
			gboolean _tmp3_;
			_tmp3_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_list_free0 (uris);
				return 0;
			}
			if (_tmp3_) {
				char* uri;
				uri = g_key_file_get_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_list_free0 (uris);
					return 0;
				}
				g_app_info_launch_default_for_uri (uri, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					_g_list_free0 (uris);
					return 0;
				}
				_g_free0 (uri);
			} else {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_NOT_LAUNCHABLE, "Invalid desktop entry.");
				{
					g_propagate_error (error, _inner_error_);
					_g_list_free0 (uris);
					return 0;
				}
			}
			break;
		}
		default:
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_NOT_LAUNCHABLE, "Unknown desktop entry type.");
			{
				g_propagate_error (error, _inner_error_);
				_g_list_free0 (uris);
				return 0;
			}
		}
	}
	result = (GPid) 0;
	_g_list_free0 (uris);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_save (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* new_file, GError** error) {
	DesktopAgnosticFDODesktopEntryGio * self;
	DesktopAgnosticVFSFile* file;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	file = NULL;
	if (new_file != NULL) {
		DesktopAgnosticVFSFile* _tmp0_;
		file = (_tmp0_ = _g_object_ref0 (new_file), _g_object_unref0 (file), _tmp0_);
	} else {
		if (self->priv->_file != NULL) {
			DesktopAgnosticVFSFile* _tmp1_;
			file = (_tmp1_ = _g_object_ref0 (self->priv->_file), _g_object_unref0 (file), _tmp1_);
		} else {
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_INVALID_FILE, "No filename specified.");
			{
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				return;
			}
		}
	}
	desktop_agnostic_vfs_file_replace_contents (file, _tmp2_ = g_key_file_to_data (self->priv->_keyfile, NULL, NULL), &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (file);
}


DesktopAgnosticFDODesktopEntryGio* desktop_agnostic_fdo_desktop_entry_gio_construct (GType object_type) {
	DesktopAgnosticFDODesktopEntryGio * self = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticFDODesktopEntryGio* desktop_agnostic_fdo_desktop_entry_gio_new (void) {
	return desktop_agnostic_fdo_desktop_entry_gio_construct (DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO);
}


static DesktopAgnosticVFSFile* desktop_agnostic_fdo_desktop_entry_gio_real_get_file (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticFDODesktopEntryGio* self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	result = self->priv->_file;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_file (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* value) {
	DesktopAgnosticFDODesktopEntryGio* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	if (value != NULL) {
		if (self->priv->loaded) {
			g_warning ("desktop-entry-impl-gio.vala:46: The desktop entry has already been ini" \
"tialized.");
		} else {
			if (desktop_agnostic_vfs_file_exists (value)) {
				char* path;
				DesktopAgnosticVFSFile* _tmp0_;
				char* _tmp1_;
				path = NULL;
				self->priv->_file = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file), _tmp0_);
				path = (_tmp1_ = desktop_agnostic_vfs_file_get_path (value), _g_free0 (path), _tmp1_);
				if (path == NULL) {
					char* data;
					gsize data_len = 0UL;
					char* _tmp2_ = NULL;
					char* _tmp3_;
					data = NULL;
					desktop_agnostic_vfs_file_load_contents (self->priv->_file, &_tmp2_, &data_len, &_inner_error_);
					data = (_tmp3_ = _tmp2_, _g_free0 (data), _tmp3_);
					if (_inner_error_ != NULL) {
						_g_free0 (data);
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					g_key_file_load_from_data (self->priv->_keyfile, data, data_len, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (data);
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (data);
				} else {
					g_key_file_load_from_file (self->priv->_keyfile, path, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->loaded = TRUE;
				_g_free0 (path);
			}
		}
	}
	g_object_notify ((GObject *) self, "file");
}


static GKeyFile* desktop_agnostic_fdo_desktop_entry_gio_real_get_keyfile (DesktopAgnosticFDODesktopEntry* base) {
	GKeyFile* result;
	DesktopAgnosticFDODesktopEntryGio* self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	result = self->priv->_keyfile;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_keyfile (DesktopAgnosticFDODesktopEntry* base, GKeyFile* value) {
	DesktopAgnosticFDODesktopEntryGio* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	if (value != NULL) {
		if (self->priv->loaded) {
			g_warning ("desktop-entry-impl-gio.vala:85: The desktop entry has already been ini" \
"tialized.");
		} else {
			char* data;
			gsize length = 0UL;
			char* _tmp0_;
			data = NULL;
			data = (_tmp0_ = g_key_file_to_data (value, &length, NULL), _g_free0 (data), _tmp0_);
			g_key_file_load_from_data (self->priv->_keyfile, data, length, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->loaded = TRUE;
			_g_free0 (data);
		}
	}
	g_object_notify ((GObject *) self, "keyfile");
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_data (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGio* self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	if (value != NULL) {
		_tmp0_ = _vala_strcmp0 (value, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (self->priv->loaded) {
			g_warning ("desktop-entry-impl-gio.vala:109: The desktop entry has already been in" \
"itialized.");
		} else {
			g_key_file_load_from_data (self->priv->_keyfile, value, strlen (value), G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->loaded = TRUE;
		}
	}
	g_object_notify ((GObject *) self, "data");
}


static DesktopAgnosticFDODesktopEntryType desktop_agnostic_fdo_desktop_entry_gio_real_get_entry_type (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticFDODesktopEntryType result;
	DesktopAgnosticFDODesktopEntryGio* self;
	char* type;
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	type = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Type");
	_tmp0_ = type;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("Application"))))
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION;
			_g_free0 (type);
			return result;
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("Link"))))
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK;
			_g_free0 (type);
			return result;
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("Directory"))))
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_DIRECTORY;
			_g_free0 (type);
			return result;
		}
	} else
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_UNKNOWN;
			_g_free0 (type);
			return result;
		}
	}
	_g_free0 (type);
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_entry_type (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryType value) {
	DesktopAgnosticFDODesktopEntryGio* self;
	char* _tmp0_;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	desktop_agnostic_fdo_desktop_entry_set_string ((DesktopAgnosticFDODesktopEntry*) self, "Type", _tmp0_ = desktop_agnostic_fdo_desktop_entry_type_to_string (value));
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "entry-type");
}


static char* desktop_agnostic_fdo_desktop_entry_gio_real_get_name (DesktopAgnosticFDODesktopEntry* base) {
	char* result;
	DesktopAgnosticFDODesktopEntryGio* self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	result = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Name");
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_name (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGio* self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	desktop_agnostic_fdo_desktop_entry_set_string ((DesktopAgnosticFDODesktopEntry*) self, "Name", value);
	g_object_notify ((GObject *) self, "name");
}


static char* desktop_agnostic_fdo_desktop_entry_gio_real_get_icon (DesktopAgnosticFDODesktopEntry* base) {
	char* result;
	DesktopAgnosticFDODesktopEntryGio* self;
	char* icon_name;
	gboolean _tmp0_ = FALSE;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	icon_name = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Icon");
	if (icon_name != NULL) {
		char* _tmp1_;
		_tmp0_ = _vala_strcmp0 (_tmp1_ = g_path_get_basename (icon_name), icon_name) == 0;
		_g_free0 (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char** _tmp2_;
		char** _tmp3_;
		gint _tmp3__length1;
		char* _tmp4_;
		char** _tmp5_;
		char** _tmp6_;
		gint _tmp6__length1;
		char* _tmp7_;
		char** _tmp8_;
		char** _tmp9_;
		gint _tmp9__length1;
		char* _tmp10_;
		icon_name = (_tmp4_ = g_strdup ((_tmp3_ = _tmp2_ = g_strsplit (icon_name, ".png", 2), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)[0]), _g_free0 (icon_name), _tmp4_);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		icon_name = (_tmp7_ = g_strdup ((_tmp6_ = _tmp5_ = g_strsplit (icon_name, ".svg", 2), _tmp6__length1 = _vala_array_length (_tmp5_), _tmp6_)[0]), _g_free0 (icon_name), _tmp7_);
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		icon_name = (_tmp10_ = g_strdup ((_tmp9_ = _tmp8_ = g_strsplit (icon_name, ".xpm", 2), _tmp9__length1 = _vala_array_length (_tmp8_), _tmp9_)[0]), _g_free0 (icon_name), _tmp10_);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	}
	result = icon_name;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gio_real_set_icon (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGio* self;
	self = (DesktopAgnosticFDODesktopEntryGio*) base;
	if (value == NULL) {
		g_warning ("desktop-entry-impl-gio.vala:179: Cannot set a NULL value for 'Icon'.");
	} else {
		desktop_agnostic_fdo_desktop_entry_set_string ((DesktopAgnosticFDODesktopEntry*) self, "Icon", value);
	}
	g_object_notify ((GObject *) self, "icon");
}


static void desktop_agnostic_fdo_desktop_entry_gio_class_init (DesktopAgnosticFDODesktopEntryGioClass * klass) {
	desktop_agnostic_fdo_desktop_entry_gio_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticFDODesktopEntryGioPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_fdo_desktop_entry_gio_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_fdo_desktop_entry_gio_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_fdo_desktop_entry_gio_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_FILE, "file");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_KEYFILE, "keyfile");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_DATA, "data");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ENTRY_TYPE, "entry-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ICON, "icon");
}


static void desktop_agnostic_fdo_desktop_entry_gio_desktop_agnostic_fdo_desktop_entry_interface_init (DesktopAgnosticFDODesktopEntryIface * iface) {
	desktop_agnostic_fdo_desktop_entry_gio_desktop_agnostic_fdo_desktop_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->key_exists = desktop_agnostic_fdo_desktop_entry_gio_real_key_exists;
	iface->get_boolean = desktop_agnostic_fdo_desktop_entry_gio_real_get_boolean;
	iface->set_boolean = desktop_agnostic_fdo_desktop_entry_gio_real_set_boolean;
	iface->get_string = desktop_agnostic_fdo_desktop_entry_gio_real_get_string;
	iface->set_string = desktop_agnostic_fdo_desktop_entry_gio_real_set_string;
	iface->get_localestring = desktop_agnostic_fdo_desktop_entry_gio_real_get_localestring;
	iface->set_localestring = desktop_agnostic_fdo_desktop_entry_gio_real_set_localestring;
	iface->get_string_list = desktop_agnostic_fdo_desktop_entry_gio_real_get_string_list;
	iface->set_string_list = desktop_agnostic_fdo_desktop_entry_gio_real_set_string_list;
	iface->exists = desktop_agnostic_fdo_desktop_entry_gio_real_exists;
	iface->launch = desktop_agnostic_fdo_desktop_entry_gio_real_launch;
	iface->save = desktop_agnostic_fdo_desktop_entry_gio_real_save;
	iface->get_file = desktop_agnostic_fdo_desktop_entry_gio_real_get_file;
	iface->set_file = desktop_agnostic_fdo_desktop_entry_gio_real_set_file;
	iface->get_keyfile = desktop_agnostic_fdo_desktop_entry_gio_real_get_keyfile;
	iface->set_keyfile = desktop_agnostic_fdo_desktop_entry_gio_real_set_keyfile;
	iface->set_data = desktop_agnostic_fdo_desktop_entry_gio_real_set_data;
	iface->get_entry_type = desktop_agnostic_fdo_desktop_entry_gio_real_get_entry_type;
	iface->set_entry_type = desktop_agnostic_fdo_desktop_entry_gio_real_set_entry_type;
	iface->get_name = desktop_agnostic_fdo_desktop_entry_gio_real_get_name;
	iface->set_name = desktop_agnostic_fdo_desktop_entry_gio_real_set_name;
	iface->get_icon = desktop_agnostic_fdo_desktop_entry_gio_real_get_icon;
	iface->set_icon = desktop_agnostic_fdo_desktop_entry_gio_real_set_icon;
}


static void desktop_agnostic_fdo_desktop_entry_gio_instance_init (DesktopAgnosticFDODesktopEntryGio * self) {
	self->priv = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_GET_PRIVATE (self);
	self->priv->_keyfile = g_key_file_new ();
	self->priv->loaded = FALSE;
	self->priv->_file = NULL;
}


static void desktop_agnostic_fdo_desktop_entry_gio_finalize (GObject* obj) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO (obj);
	_g_key_file_free0 (self->priv->_keyfile);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (desktop_agnostic_fdo_desktop_entry_gio_parent_class)->finalize (obj);
}


GType desktop_agnostic_fdo_desktop_entry_gio_get_type (void) {
	static volatile gsize desktop_agnostic_fdo_desktop_entry_gio_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_fdo_desktop_entry_gio_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticFDODesktopEntryGioClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_fdo_desktop_entry_gio_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticFDODesktopEntryGio), 0, (GInstanceInitFunc) desktop_agnostic_fdo_desktop_entry_gio_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_fdo_desktop_entry_info = { (GInterfaceInitFunc) desktop_agnostic_fdo_desktop_entry_gio_desktop_agnostic_fdo_desktop_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_fdo_desktop_entry_gio_type_id;
		desktop_agnostic_fdo_desktop_entry_gio_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticFDODesktopEntryGio", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_fdo_desktop_entry_gio_type_id, DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY, &desktop_agnostic_fdo_desktop_entry_info);
		g_once_init_leave (&desktop_agnostic_fdo_desktop_entry_gio_type_id__volatile, desktop_agnostic_fdo_desktop_entry_gio_type_id);
	}
	return desktop_agnostic_fdo_desktop_entry_gio_type_id__volatile;
}


static void desktop_agnostic_fdo_desktop_entry_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_FILE:
		g_value_set_object (value, desktop_agnostic_fdo_desktop_entry_get_file ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_KEYFILE:
		g_value_set_pointer (value, desktop_agnostic_fdo_desktop_entry_get_keyfile ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ENTRY_TYPE:
		g_value_set_enum (value, desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_NAME:
		g_value_take_string (value, desktop_agnostic_fdo_desktop_entry_get_name ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ICON:
		g_value_take_string (value, desktop_agnostic_fdo_desktop_entry_get_icon ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_fdo_desktop_entry_gio_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticFDODesktopEntryGio * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_FILE:
		desktop_agnostic_fdo_desktop_entry_set_file ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_KEYFILE:
		desktop_agnostic_fdo_desktop_entry_set_keyfile ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_pointer (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_DATA:
		desktop_agnostic_fdo_desktop_entry_set_data ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ENTRY_TYPE:
		desktop_agnostic_fdo_desktop_entry_set_entry_type ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_enum (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_NAME:
		desktop_agnostic_fdo_desktop_entry_set_name ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GIO_ICON:
		desktop_agnostic_fdo_desktop_entry_set_icon ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result = 0UL;
	result = DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GIO;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




