//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QEVENT_C_H
#define QEVENT_C_H

#include <QtGui>
#include "pascalbind.h"

C_EXPORT QInputEventH QInputEvent_create(QEvent::Type type, unsigned int modifiers);
C_EXPORT void QInputEvent_destroy(QInputEventH handle);
C_EXPORT unsigned int QInputEvent_modifiers(QInputEventH handle);
C_EXPORT QMouseEventH QMouseEvent_create(QEvent::Type type, const QPointH pos, Qt::MouseButton button, unsigned int buttons, unsigned int modifiers);
C_EXPORT void QMouseEvent_destroy(QMouseEventH handle);
C_EXPORT QMouseEventH QMouseEvent_create2(QEvent::Type type, const QPointH pos, const QPointH globalPos, Qt::MouseButton button, unsigned int buttons, unsigned int modifiers);
C_EXPORT const QPointH QMouseEvent_pos(QMouseEventH handle);
C_EXPORT const QPointH QMouseEvent_globalPos(QMouseEventH handle);
C_EXPORT int QMouseEvent_x(QMouseEventH handle);
C_EXPORT int QMouseEvent_y(QMouseEventH handle);
C_EXPORT int QMouseEvent_globalX(QMouseEventH handle);
C_EXPORT int QMouseEvent_globalY(QMouseEventH handle);
C_EXPORT Qt::MouseButton QMouseEvent_button(QMouseEventH handle);
C_EXPORT unsigned int QMouseEvent_buttons(QMouseEventH handle);
C_EXPORT QMouseEventH QMouseEvent_createExtendedMouseEvent(QEvent::Type type, const QPointFH pos, const QPointH globalPos, Qt::MouseButton button, unsigned int buttons, unsigned int modifiers);
C_EXPORT bool QMouseEvent_hasExtendedInfo(QMouseEventH handle);
C_EXPORT void QMouseEvent_posF(QMouseEventH handle, PQtPointF retval);
C_EXPORT QHoverEventH QHoverEvent_create(QEvent::Type type, const QPointH pos, const QPointH oldPos);
C_EXPORT void QHoverEvent_destroy(QHoverEventH handle);
C_EXPORT const QPointH QHoverEvent_pos(QHoverEventH handle);
C_EXPORT const QPointH QHoverEvent_oldPos(QHoverEventH handle);
C_EXPORT QWheelEventH QWheelEvent_create(const QPointH pos, int delta, unsigned int buttons, unsigned int modifiers, Qt::Orientation orient);
C_EXPORT void QWheelEvent_destroy(QWheelEventH handle);
C_EXPORT QWheelEventH QWheelEvent_create2(const QPointH pos, const QPointH globalPos, int delta, unsigned int buttons, unsigned int modifiers, Qt::Orientation orient);
C_EXPORT int QWheelEvent_delta(QWheelEventH handle);
C_EXPORT const QPointH QWheelEvent_pos(QWheelEventH handle);
C_EXPORT const QPointH QWheelEvent_globalPos(QWheelEventH handle);
C_EXPORT int QWheelEvent_x(QWheelEventH handle);
C_EXPORT int QWheelEvent_y(QWheelEventH handle);
C_EXPORT int QWheelEvent_globalX(QWheelEventH handle);
C_EXPORT int QWheelEvent_globalY(QWheelEventH handle);
C_EXPORT unsigned int QWheelEvent_buttons(QWheelEventH handle);
C_EXPORT Qt::Orientation QWheelEvent_orientation(QWheelEventH handle);
C_EXPORT QTabletEventH QTabletEvent_create(QEvent::Type t, const QPointH pos, const QPointH globalPos, const QPointFH hiResGlobalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, unsigned int keyState, qint64 uniqueID);
C_EXPORT void QTabletEvent_destroy(QTabletEventH handle);
C_EXPORT const QPointH QTabletEvent_pos(QTabletEventH handle);
C_EXPORT const QPointH QTabletEvent_globalPos(QTabletEventH handle);
C_EXPORT const QPointFH QTabletEvent_hiResGlobalPos(QTabletEventH handle);
C_EXPORT int QTabletEvent_x(QTabletEventH handle);
C_EXPORT int QTabletEvent_y(QTabletEventH handle);
C_EXPORT int QTabletEvent_globalX(QTabletEventH handle);
C_EXPORT int QTabletEvent_globalY(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_hiResGlobalX(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_hiResGlobalY(QTabletEventH handle);
C_EXPORT QTabletEvent::TabletDevice QTabletEvent_device(QTabletEventH handle);
C_EXPORT QTabletEvent::PointerType QTabletEvent_pointerType(QTabletEventH handle);
C_EXPORT qint64 QTabletEvent_uniqueId(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_pressure(QTabletEventH handle);
C_EXPORT int QTabletEvent_z(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_tangentialPressure(QTabletEventH handle);
C_EXPORT qreal QTabletEvent_rotation(QTabletEventH handle);
C_EXPORT int QTabletEvent_xTilt(QTabletEventH handle);
C_EXPORT int QTabletEvent_yTilt(QTabletEventH handle);
C_EXPORT QKeyEventH QKeyEvent_create(QEvent::Type type, int key, unsigned int modifiers, PWideString text, bool autorep, ushort count);
C_EXPORT void QKeyEvent_destroy(QKeyEventH handle);
C_EXPORT int QKeyEvent_key(QKeyEventH handle);
C_EXPORT bool QKeyEvent_matches(QKeyEventH handle, QKeySequence::StandardKey key);
C_EXPORT unsigned int QKeyEvent_modifiers(QKeyEventH handle);
C_EXPORT void QKeyEvent_text(QKeyEventH handle, PWideString retval);
C_EXPORT bool QKeyEvent_isAutoRepeat(QKeyEventH handle);
C_EXPORT int QKeyEvent_count(QKeyEventH handle);
C_EXPORT QKeyEventH QKeyEvent_createExtendedKeyEvent(QEvent::Type type, int key, unsigned int modifiers, quint32 nativeScanCode, quint32 nativeVirtualKey, quint32 nativeModifiers, PWideString text, bool autorep, ushort count);
C_EXPORT bool QKeyEvent_hasExtendedInfo(QKeyEventH handle);
C_EXPORT quint32 QKeyEvent_nativeScanCode(QKeyEventH handle);
C_EXPORT quint32 QKeyEvent_nativeVirtualKey(QKeyEventH handle);
C_EXPORT quint32 QKeyEvent_nativeModifiers(QKeyEventH handle);
C_EXPORT QFocusEventH QFocusEvent_create(QEvent::Type type, Qt::FocusReason reason);
C_EXPORT void QFocusEvent_destroy(QFocusEventH handle);
C_EXPORT bool QFocusEvent_gotFocus(QFocusEventH handle);
C_EXPORT bool QFocusEvent_lostFocus(QFocusEventH handle);
C_EXPORT Qt::FocusReason QFocusEvent_reason(QFocusEventH handle);
C_EXPORT QPaintEventH QPaintEvent_create(const QRegionH paintRegion);
C_EXPORT void QPaintEvent_destroy(QPaintEventH handle);
C_EXPORT QPaintEventH QPaintEvent_create2(PRect paintRect);
C_EXPORT void QPaintEvent_rect(QPaintEventH handle, PRect retval);
C_EXPORT const QRegionH QPaintEvent_region(QPaintEventH handle);
C_EXPORT QMoveEventH QMoveEvent_create(const QPointH pos, const QPointH oldPos);
C_EXPORT void QMoveEvent_destroy(QMoveEventH handle);
C_EXPORT const QPointH QMoveEvent_pos(QMoveEventH handle);
C_EXPORT const QPointH QMoveEvent_oldPos(QMoveEventH handle);
C_EXPORT QResizeEventH QResizeEvent_create(const QSizeH size, const QSizeH oldSize);
C_EXPORT void QResizeEvent_destroy(QResizeEventH handle);
C_EXPORT const QSizeH QResizeEvent_size(QResizeEventH handle);
C_EXPORT const QSizeH QResizeEvent_oldSize(QResizeEventH handle);
C_EXPORT QCloseEventH QCloseEvent_create();
C_EXPORT void QCloseEvent_destroy(QCloseEventH handle);
C_EXPORT QIconDragEventH QIconDragEvent_create();
C_EXPORT void QIconDragEvent_destroy(QIconDragEventH handle);
C_EXPORT QShowEventH QShowEvent_create();
C_EXPORT void QShowEvent_destroy(QShowEventH handle);
C_EXPORT QHideEventH QHideEvent_create();
C_EXPORT void QHideEvent_destroy(QHideEventH handle);
C_EXPORT QContextMenuEventH QContextMenuEvent_create(QContextMenuEvent::Reason reason, const QPointH pos, const QPointH globalPos, unsigned int modifiers);
C_EXPORT void QContextMenuEvent_destroy(QContextMenuEventH handle);
C_EXPORT QContextMenuEventH QContextMenuEvent_create2(QContextMenuEvent::Reason reason, const QPointH pos, const QPointH globalPos);
C_EXPORT QContextMenuEventH QContextMenuEvent_create3(QContextMenuEvent::Reason reason, const QPointH pos);
C_EXPORT int QContextMenuEvent_x(QContextMenuEventH handle);
C_EXPORT int QContextMenuEvent_y(QContextMenuEventH handle);
C_EXPORT int QContextMenuEvent_globalX(QContextMenuEventH handle);
C_EXPORT int QContextMenuEvent_globalY(QContextMenuEventH handle);
C_EXPORT const QPointH QContextMenuEvent_pos(QContextMenuEventH handle);
C_EXPORT const QPointH QContextMenuEvent_globalPos(QContextMenuEventH handle);
C_EXPORT QContextMenuEvent::Reason QContextMenuEvent_reason(QContextMenuEventH handle);
C_EXPORT QInputMethodEventH QInputMethodEvent_create();
C_EXPORT void QInputMethodEvent_destroy(QInputMethodEventH handle);
C_EXPORT void QInputMethodEvent_setCommitString(QInputMethodEventH handle, PWideString commitString, int replaceFrom, int replaceLength);
C_EXPORT void QInputMethodEvent_preeditString(QInputMethodEventH handle, PWideString retval);
C_EXPORT void QInputMethodEvent_commitString(QInputMethodEventH handle, PWideString retval);
C_EXPORT int QInputMethodEvent_replacementStart(QInputMethodEventH handle);
C_EXPORT int QInputMethodEvent_replacementLength(QInputMethodEventH handle);
C_EXPORT QInputMethodEventH QInputMethodEvent_create3(const QInputMethodEventH other);
C_EXPORT QDropEventH QDropEvent_create(const QPointH pos, unsigned int actions, const QMimeDataH data, unsigned int buttons, unsigned int modifiers, QEvent::Type type);
C_EXPORT void QDropEvent_destroy(QDropEventH handle);
C_EXPORT const QPointH QDropEvent_pos(QDropEventH handle);
C_EXPORT unsigned int QDropEvent_mouseButtons(QDropEventH handle);
C_EXPORT unsigned int QDropEvent_keyboardModifiers(QDropEventH handle);
C_EXPORT unsigned int QDropEvent_possibleActions(QDropEventH handle);
C_EXPORT Qt::DropAction QDropEvent_proposedAction(QDropEventH handle);
C_EXPORT void QDropEvent_acceptProposedAction(QDropEventH handle);
C_EXPORT Qt::DropAction QDropEvent_dropAction(QDropEventH handle);
C_EXPORT void QDropEvent_setDropAction(QDropEventH handle, Qt::DropAction action);
C_EXPORT QWidgetH QDropEvent_source(QDropEventH handle);
C_EXPORT const QMimeDataH QDropEvent_mimeData(QDropEventH handle);
C_EXPORT const char* QDropEvent_format(QDropEventH handle, int n);
C_EXPORT void QDropEvent_encodedData(QDropEventH handle, QByteArrayH retval, const char* AnonParam1);
C_EXPORT bool QDropEvent_provides(QDropEventH handle, const char* AnonParam1);
C_EXPORT QDragMoveEventH QDragMoveEvent_create(const QPointH pos, unsigned int actions, const QMimeDataH data, unsigned int buttons, unsigned int modifiers, QEvent::Type type);
C_EXPORT void QDragMoveEvent_destroy(QDragMoveEventH handle);
C_EXPORT void QDragMoveEvent_answerRect(QDragMoveEventH handle, PRect retval);
C_EXPORT void QDragMoveEvent_accept(QDragMoveEventH handle);
C_EXPORT void QDragMoveEvent_ignore(QDragMoveEventH handle);
C_EXPORT void QDragMoveEvent_accept2(QDragMoveEventH handle, PRect r);
C_EXPORT void QDragMoveEvent_ignore2(QDragMoveEventH handle, PRect r);
C_EXPORT QDragEnterEventH QDragEnterEvent_create(const QPointH pos, unsigned int actions, const QMimeDataH data, unsigned int buttons, unsigned int modifiers);
C_EXPORT void QDragEnterEvent_destroy(QDragEnterEventH handle);
C_EXPORT QDragLeaveEventH QDragLeaveEvent_create();
C_EXPORT void QDragLeaveEvent_destroy(QDragLeaveEventH handle);
C_EXPORT QHelpEventH QHelpEvent_create(QEvent::Type type, const QPointH pos, const QPointH globalPos);
C_EXPORT void QHelpEvent_destroy(QHelpEventH handle);
C_EXPORT int QHelpEvent_x(QHelpEventH handle);
C_EXPORT int QHelpEvent_y(QHelpEventH handle);
C_EXPORT int QHelpEvent_globalX(QHelpEventH handle);
C_EXPORT int QHelpEvent_globalY(QHelpEventH handle);
C_EXPORT const QPointH QHelpEvent_pos(QHelpEventH handle);
C_EXPORT const QPointH QHelpEvent_globalPos(QHelpEventH handle);
C_EXPORT QStatusTipEventH QStatusTipEvent_create(PWideString tip);
C_EXPORT void QStatusTipEvent_destroy(QStatusTipEventH handle);
C_EXPORT void QStatusTipEvent_tip(QStatusTipEventH handle, PWideString retval);
C_EXPORT QWhatsThisClickedEventH QWhatsThisClickedEvent_create(PWideString href);
C_EXPORT void QWhatsThisClickedEvent_destroy(QWhatsThisClickedEventH handle);
C_EXPORT void QWhatsThisClickedEvent_href(QWhatsThisClickedEventH handle, PWideString retval);
C_EXPORT QActionEventH QActionEvent_create(int type, QActionH action, QActionH before);
C_EXPORT void QActionEvent_destroy(QActionEventH handle);
C_EXPORT QActionH QActionEvent_action(QActionEventH handle);
C_EXPORT QActionH QActionEvent_before(QActionEventH handle);
C_EXPORT QFileOpenEventH QFileOpenEvent_create(PWideString file);
C_EXPORT void QFileOpenEvent_destroy(QFileOpenEventH handle);
C_EXPORT void QFileOpenEvent_file(QFileOpenEventH handle, PWideString retval);
C_EXPORT QShortcutEventH QShortcutEvent_create(const QKeySequenceH key, int id, bool ambiguous);
C_EXPORT void QShortcutEvent_destroy(QShortcutEventH handle);
C_EXPORT const QKeySequenceH QShortcutEvent_key(QShortcutEventH handle);
C_EXPORT int QShortcutEvent_shortcutId(QShortcutEventH handle);
C_EXPORT bool QShortcutEvent_isAmbiguous(QShortcutEventH handle);
C_EXPORT QWindowStateChangeEventH QWindowStateChangeEvent_create(unsigned int aOldState);
C_EXPORT void QWindowStateChangeEvent_destroy(QWindowStateChangeEventH handle);
C_EXPORT QWindowStateChangeEventH QWindowStateChangeEvent_create2(unsigned int aOldState, bool isOverride);
C_EXPORT unsigned int QWindowStateChangeEvent_oldState(QWindowStateChangeEventH handle);
C_EXPORT bool QWindowStateChangeEvent_isOverride(QWindowStateChangeEventH handle);

#endif
