/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2025 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/
#include "SDL_internal.h"

/*
 * Windows scancode to SDL scancode mapping table
 * https://learn.microsoft.com/windows/win32/inputdev/about-keyboard-input#scan-codes */

/* *INDENT-OFF* */ // clang-format off
static const SDL_Scancode windows_scancode_table[] = {
    /*0x00*/ SDL_SCANCODE_UNKNOWN,
    /*0x01*/ SDL_SCANCODE_ESCAPE,
    /*0x02*/ SDL_SCANCODE_1,
    /*0x03*/ SDL_SCANCODE_2,
    /*0x04*/ SDL_SCANCODE_3,
    /*0x05*/ SDL_SCANCODE_4,
    /*0x06*/ SDL_SCANCODE_5,
    /*0x07*/ SDL_SCANCODE_6,
    /*0x08*/ SDL_SCANCODE_7,
    /*0x09*/ SDL_SCANCODE_8,
    /*0x0a*/ SDL_SCANCODE_9,
    /*0x0b*/ SDL_SCANCODE_0,
    /*0x0c*/ SDL_SCANCODE_MINUS,
    /*0x0d*/ SDL_SCANCODE_EQUALS,
    /*0x0e*/ SDL_SCANCODE_BACKSPACE,
    /*0x0f*/ SDL_SCANCODE_TAB,
    /*0x10*/ SDL_SCANCODE_Q,
    /*0x11*/ SDL_SCANCODE_W,
    /*0x12*/ SDL_SCANCODE_E,
    /*0x13*/ SDL_SCANCODE_R,
    /*0x14*/ SDL_SCANCODE_T,
    /*0x15*/ SDL_SCANCODE_Y,
    /*0x16*/ SDL_SCANCODE_U,
    /*0x17*/ SDL_SCANCODE_I,
    /*0x18*/ SDL_SCANCODE_O,
    /*0x19*/ SDL_SCANCODE_P,
    /*0x1a*/ SDL_SCANCODE_LEFTBRACKET,
    /*0x1b*/ SDL_SCANCODE_RIGHTBRACKET,
    /*0x1c*/ SDL_SCANCODE_RETURN,
    /*0x1d*/ SDL_SCANCODE_LCTRL,
    /*0x1e*/ SDL_SCANCODE_A,
    /*0x1f*/ SDL_SCANCODE_S,
    /*0x20*/ SDL_SCANCODE_D,
    /*0x21*/ SDL_SCANCODE_F,
    /*0x22*/ SDL_SCANCODE_G,
    /*0x23*/ SDL_SCANCODE_H,
    /*0x24*/ SDL_SCANCODE_J,
    /*0x25*/ SDL_SCANCODE_K,
    /*0x26*/ SDL_SCANCODE_L,
    /*0x27*/ SDL_SCANCODE_SEMICOLON,
    /*0x28*/ SDL_SCANCODE_APOSTROPHE,
    /*0x29*/ SDL_SCANCODE_GRAVE,
    /*0x2a*/ SDL_SCANCODE_LSHIFT,
    /*0x2b*/ SDL_SCANCODE_BACKSLASH,
    /*0x2c*/ SDL_SCANCODE_Z,
    /*0x2d*/ SDL_SCANCODE_X,
    /*0x2e*/ SDL_SCANCODE_C,
    /*0x2f*/ SDL_SCANCODE_V,
    /*0x30*/ SDL_SCANCODE_B,
    /*0x31*/ SDL_SCANCODE_N,
    /*0x32*/ SDL_SCANCODE_M,
    /*0x33*/ SDL_SCANCODE_COMMA,
    /*0x34*/ SDL_SCANCODE_PERIOD,
    /*0x35*/ SDL_SCANCODE_SLASH,
    /*0x36*/ SDL_SCANCODE_RSHIFT,
    /*0x37*/ SDL_SCANCODE_KP_MULTIPLY,
    /*0x38*/ SDL_SCANCODE_LALT,
    /*0x39*/ SDL_SCANCODE_SPACE,
    /*0x3a*/ SDL_SCANCODE_CAPSLOCK,
    /*0x3b*/ SDL_SCANCODE_F1,
    /*0x3c*/ SDL_SCANCODE_F2,
    /*0x3d*/ SDL_SCANCODE_F3,
    /*0x3e*/ SDL_SCANCODE_F4,
    /*0x3f*/ SDL_SCANCODE_F5,
    /*0x40*/ SDL_SCANCODE_F6,
    /*0x41*/ SDL_SCANCODE_F7,
    /*0x42*/ SDL_SCANCODE_F8,
    /*0x43*/ SDL_SCANCODE_F9,
    /*0x44*/ SDL_SCANCODE_F10,
    /*0x45*/ SDL_SCANCODE_NUMLOCKCLEAR,
    /*0x46*/ SDL_SCANCODE_SCROLLLOCK,
    /*0x47*/ SDL_SCANCODE_KP_7,
    /*0x48*/ SDL_SCANCODE_KP_8,
    /*0x49*/ SDL_SCANCODE_KP_9,
    /*0x4a*/ SDL_SCANCODE_KP_MINUS,
    /*0x4b*/ SDL_SCANCODE_KP_4,
    /*0x4c*/ SDL_SCANCODE_KP_5,
    /*0x4d*/ SDL_SCANCODE_KP_6,
    /*0x4e*/ SDL_SCANCODE_KP_PLUS,
    /*0x4f*/ SDL_SCANCODE_KP_1,
    /*0x50*/ SDL_SCANCODE_KP_2,
    /*0x51*/ SDL_SCANCODE_KP_3,
    /*0x52*/ SDL_SCANCODE_KP_0,
    /*0x53*/ SDL_SCANCODE_KP_PERIOD,
    /*0x54*/ SDL_SCANCODE_UNKNOWN,
    /*0x55*/ SDL_SCANCODE_UNKNOWN,
    /*0x56*/ SDL_SCANCODE_NONUSBACKSLASH,
    /*0x57*/ SDL_SCANCODE_F11,
    /*0x58*/ SDL_SCANCODE_F12,
    /*0x59*/ SDL_SCANCODE_KP_EQUALS,
    /*0x5a*/ SDL_SCANCODE_UNKNOWN,
    /*0x5b*/ SDL_SCANCODE_UNKNOWN,
    /*0x5c*/ SDL_SCANCODE_INTERNATIONAL6,
    /*0x5d*/ SDL_SCANCODE_UNKNOWN,
    /*0x5e*/ SDL_SCANCODE_UNKNOWN,
    /*0x5f*/ SDL_SCANCODE_UNKNOWN,
    /*0x60*/ SDL_SCANCODE_UNKNOWN,
    /*0x61*/ SDL_SCANCODE_UNKNOWN,
    /*0x62*/ SDL_SCANCODE_UNKNOWN,
    /*0x63*/ SDL_SCANCODE_UNKNOWN,
    /*0x64*/ SDL_SCANCODE_F13,
    /*0x65*/ SDL_SCANCODE_F14,
    /*0x66*/ SDL_SCANCODE_F15,
    /*0x67*/ SDL_SCANCODE_F16,
    /*0x68*/ SDL_SCANCODE_F17,
    /*0x69*/ SDL_SCANCODE_F18,
    /*0x6a*/ SDL_SCANCODE_F19,
    /*0x6b*/ SDL_SCANCODE_F20,
    /*0x6c*/ SDL_SCANCODE_F21,
    /*0x6d*/ SDL_SCANCODE_F22,
    /*0x6e*/ SDL_SCANCODE_F23,
    /*0x6f*/ SDL_SCANCODE_UNKNOWN,
    /*0x70*/ SDL_SCANCODE_INTERNATIONAL2,
    /*0x71*/ SDL_SCANCODE_LANG2,
    /*0x72*/ SDL_SCANCODE_LANG1,
    /*0x73*/ SDL_SCANCODE_INTERNATIONAL1,
    /*0x74*/ SDL_SCANCODE_UNKNOWN,
    /*0x75*/ SDL_SCANCODE_UNKNOWN,
    /*0x76*/ SDL_SCANCODE_F24,
    /*0x77*/ SDL_SCANCODE_LANG4,
    /*0x78*/ SDL_SCANCODE_LANG3,
    /*0x79*/ SDL_SCANCODE_INTERNATIONAL4,
    /*0x7a*/ SDL_SCANCODE_UNKNOWN,
    /*0x7b*/ SDL_SCANCODE_INTERNATIONAL5,
    /*0x7c*/ SDL_SCANCODE_UNKNOWN,
    /*0x7d*/ SDL_SCANCODE_INTERNATIONAL3,
    /*0x7e*/ SDL_SCANCODE_KP_COMMA,
    /*0x7f*/ SDL_SCANCODE_UNKNOWN,
    /*0xe000*/ SDL_SCANCODE_UNKNOWN,
    /*0xe001*/ SDL_SCANCODE_UNKNOWN,
    /*0xe002*/ SDL_SCANCODE_UNKNOWN,
    /*0xe003*/ SDL_SCANCODE_UNKNOWN,
    /*0xe004*/ SDL_SCANCODE_UNKNOWN,
    /*0xe005*/ SDL_SCANCODE_UNKNOWN,
    /*0xe006*/ SDL_SCANCODE_UNKNOWN,
    /*0xe007*/ SDL_SCANCODE_UNKNOWN,
    /*0xe008*/ SDL_SCANCODE_UNKNOWN,
    /*0xe009*/ SDL_SCANCODE_UNKNOWN,
    /*0xe00a*/ SDL_SCANCODE_PASTE,
    /*0xe00b*/ SDL_SCANCODE_UNKNOWN,
    /*0xe00c*/ SDL_SCANCODE_UNKNOWN,
    /*0xe00d*/ SDL_SCANCODE_UNKNOWN,
    /*0xe00e*/ SDL_SCANCODE_UNKNOWN,
    /*0xe00f*/ SDL_SCANCODE_UNKNOWN,
    /*0xe010*/ SDL_SCANCODE_MEDIA_PREVIOUS_TRACK,
    /*0xe011*/ SDL_SCANCODE_UNKNOWN,
    /*0xe012*/ SDL_SCANCODE_UNKNOWN,
    /*0xe013*/ SDL_SCANCODE_UNKNOWN,
    /*0xe014*/ SDL_SCANCODE_UNKNOWN,
    /*0xe015*/ SDL_SCANCODE_UNKNOWN,
    /*0xe016*/ SDL_SCANCODE_UNKNOWN,
    /*0xe017*/ SDL_SCANCODE_CUT,
    /*0xe018*/ SDL_SCANCODE_COPY,
    /*0xe019*/ SDL_SCANCODE_MEDIA_NEXT_TRACK,
    /*0xe01a*/ SDL_SCANCODE_UNKNOWN,
    /*0xe01b*/ SDL_SCANCODE_UNKNOWN,
    /*0xe01c*/ SDL_SCANCODE_KP_ENTER,
    /*0xe01d*/ SDL_SCANCODE_RCTRL,
    /*0xe01e*/ SDL_SCANCODE_UNKNOWN,
    /*0xe01f*/ SDL_SCANCODE_UNKNOWN,
    /*0xe020*/ SDL_SCANCODE_MUTE,
    /*0xe021*/ SDL_SCANCODE_UNKNOWN, // LaunchApp2
    /*0xe022*/ SDL_SCANCODE_MEDIA_PLAY_PAUSE,
    /*0xe023*/ SDL_SCANCODE_UNKNOWN,
    /*0xe024*/ SDL_SCANCODE_MEDIA_STOP,
    /*0xe025*/ SDL_SCANCODE_UNKNOWN,
    /*0xe026*/ SDL_SCANCODE_UNKNOWN,
    /*0xe027*/ SDL_SCANCODE_UNKNOWN,
    /*0xe028*/ SDL_SCANCODE_UNKNOWN,
    /*0xe029*/ SDL_SCANCODE_UNKNOWN,
    /*0xe02a*/ SDL_SCANCODE_UNKNOWN,
    /*0xe02b*/ SDL_SCANCODE_UNKNOWN,
    /*0xe02c*/ SDL_SCANCODE_MEDIA_EJECT,
    /*0xe02d*/ SDL_SCANCODE_UNKNOWN,
    /*0xe02e*/ SDL_SCANCODE_VOLUMEDOWN,
    /*0xe02f*/ SDL_SCANCODE_UNKNOWN,
    /*0xe030*/ SDL_SCANCODE_VOLUMEUP,
    /*0xe031*/ SDL_SCANCODE_UNKNOWN,
    /*0xe032*/ SDL_SCANCODE_AC_HOME,
    /*0xe033*/ SDL_SCANCODE_UNKNOWN,
    /*0xe034*/ SDL_SCANCODE_UNKNOWN,
    /*0xe035*/ SDL_SCANCODE_KP_DIVIDE,
    /*0xe036*/ SDL_SCANCODE_UNKNOWN,
    /*0xe037*/ SDL_SCANCODE_PRINTSCREEN,
    /*0xe038*/ SDL_SCANCODE_RALT,
    /*0xe039*/ SDL_SCANCODE_UNKNOWN,
    /*0xe03a*/ SDL_SCANCODE_UNKNOWN,
    /*0xe03b*/ SDL_SCANCODE_HELP,
    /*0xe03c*/ SDL_SCANCODE_UNKNOWN,
    /*0xe03d*/ SDL_SCANCODE_UNKNOWN,
    /*0xe03e*/ SDL_SCANCODE_UNKNOWN,
    /*0xe03f*/ SDL_SCANCODE_UNKNOWN,
    /*0xe040*/ SDL_SCANCODE_UNKNOWN,
    /*0xe041*/ SDL_SCANCODE_UNKNOWN,
    /*0xe042*/ SDL_SCANCODE_UNKNOWN,
    /*0xe043*/ SDL_SCANCODE_UNKNOWN,
    /*0xe044*/ SDL_SCANCODE_UNKNOWN,
    /*0xe045*/ SDL_SCANCODE_NUMLOCKCLEAR,
    /*0xe046*/ SDL_SCANCODE_PAUSE,
    /*0xe047*/ SDL_SCANCODE_HOME,
    /*0xe048*/ SDL_SCANCODE_UP,
    /*0xe049*/ SDL_SCANCODE_PAGEUP,
    /*0xe04a*/ SDL_SCANCODE_UNKNOWN,
    /*0xe04b*/ SDL_SCANCODE_LEFT,
    /*0xe04c*/ SDL_SCANCODE_UNKNOWN,
    /*0xe04d*/ SDL_SCANCODE_RIGHT,
    /*0xe04e*/ SDL_SCANCODE_UNKNOWN,
    /*0xe04f*/ SDL_SCANCODE_END,
    /*0xe050*/ SDL_SCANCODE_DOWN,
    /*0xe051*/ SDL_SCANCODE_PAGEDOWN,
    /*0xe052*/ SDL_SCANCODE_INSERT,
    /*0xe053*/ SDL_SCANCODE_DELETE,
    /*0xe054*/ SDL_SCANCODE_UNKNOWN,
    /*0xe055*/ SDL_SCANCODE_UNKNOWN,
    /*0xe056*/ SDL_SCANCODE_UNKNOWN,
    /*0xe057*/ SDL_SCANCODE_UNKNOWN,
    /*0xe058*/ SDL_SCANCODE_UNKNOWN,
    /*0xe059*/ SDL_SCANCODE_UNKNOWN,
    /*0xe05a*/ SDL_SCANCODE_UNKNOWN,
    /*0xe05b*/ SDL_SCANCODE_LGUI,
    /*0xe05c*/ SDL_SCANCODE_RGUI,
    /*0xe05d*/ SDL_SCANCODE_APPLICATION,
    /*0xe05e*/ SDL_SCANCODE_POWER,
    /*0xe05f*/ SDL_SCANCODE_SLEEP,
    /*0xe060*/ SDL_SCANCODE_UNKNOWN,
    /*0xe061*/ SDL_SCANCODE_UNKNOWN,
    /*0xe062*/ SDL_SCANCODE_UNKNOWN,
    /*0xe063*/ SDL_SCANCODE_UNKNOWN,
    /*0xe064*/ SDL_SCANCODE_UNKNOWN,
    /*0xe065*/ SDL_SCANCODE_AC_SEARCH,
    /*0xe066*/ SDL_SCANCODE_AC_BOOKMARKS,
    /*0xe067*/ SDL_SCANCODE_AC_REFRESH,
    /*0xe068*/ SDL_SCANCODE_AC_STOP,
    /*0xe069*/ SDL_SCANCODE_AC_FORWARD,
    /*0xe06a*/ SDL_SCANCODE_AC_BACK,
    /*0xe06b*/ SDL_SCANCODE_UNKNOWN,    // LaunchApp1
    /*0xe06c*/ SDL_SCANCODE_UNKNOWN,    // LaunchMail
    /*0xe06d*/ SDL_SCANCODE_MEDIA_SELECT,
    /*0xe06e*/ SDL_SCANCODE_UNKNOWN,
    /*0xe06f*/ SDL_SCANCODE_UNKNOWN,
    /*0xe070*/ SDL_SCANCODE_UNKNOWN,
    /*0xe071*/ SDL_SCANCODE_UNKNOWN,
    /*0xe072*/ SDL_SCANCODE_UNKNOWN,
    /*0xe073*/ SDL_SCANCODE_UNKNOWN,
    /*0xe074*/ SDL_SCANCODE_UNKNOWN,
    /*0xe075*/ SDL_SCANCODE_UNKNOWN,
    /*0xe076*/ SDL_SCANCODE_UNKNOWN,
    /*0xe077*/ SDL_SCANCODE_UNKNOWN,
    /*0xe078*/ SDL_SCANCODE_UNKNOWN,
    /*0xe079*/ SDL_SCANCODE_UNKNOWN,
    /*0xe07a*/ SDL_SCANCODE_UNKNOWN,
    /*0xe07b*/ SDL_SCANCODE_UNKNOWN,
    /*0xe07c*/ SDL_SCANCODE_UNKNOWN,
    /*0xe07d*/ SDL_SCANCODE_UNKNOWN,
    /*0xe07e*/ SDL_SCANCODE_UNKNOWN,
    /*0xe07f*/ SDL_SCANCODE_UNKNOWN
};
/* *INDENT-ON* */ // clang-format on
