/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

int main() {
	int i;
	int ret;

#ifdef SA_OPEN_SWAP
	ret = sa_open_swap();
	if (ret != 0) {
		printf("%s:%d ERROR: sa_open_swap(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	uint16_t number;
	ret = sa_count_swaps(&number);
	if (ret != 0) {
		printf("%s:%d ERROR: sa_count_swaps(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
	size_t swaps_size = number * 2;
	struct sa_swap* swaps = (struct sa_swap*) malloc(swaps_size * sizeof(struct sa_swap));

	struct sa_swap swap;
	uint16_t written;
	for (i = 0; i < 1100000; ++i) {
		ret = sa_count_swaps(&number);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_count_swaps(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_reset_swaps();
		if (ret != 0) {
			printf("%s:%d ERROR: sa_reset_swaps(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_swap(0, &swap);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_swap(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_swaps(swaps, swaps_size, &written);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_swaps(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}
	}
	free(swaps);

#ifdef SA_CLOSE_SWAP
	ret = sa_close_swap();
	if (ret != 0) {
		printf("%s:%d ERROR: sa_close_swap(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return EXIT_SUCCESS;
}
