/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 *
 * \file      PicoUsbID.h 
 * \brief     Pico Technology USB PID/VID/DID information.
 *
 * USB devices are uniquely identified by three hex ID numbers.
 * This file contains those IDs for Pico Technology devices so that the
 * driver can recognize them. The IDs are as follows: 
 * <ul>
 * <li>Vendor ID (VID) identifies the company producing the device. Pico's 
 *     VID is 0CE9.
 * <li>Product ID (PID) identifies the type of device. For example, the PID 
 *     of a PicoScope 5000 Series PC Oscilloscope is 1008.
 * <li>Device ID (DID) provides further identification within a product group. 
 *     For example, all Pico USB TC08s have the same PID but we can identify 
 *     between units fitted with different versions of the processor by DID 
 *     in order to choose the correct firmware to download.
 * </ul>
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: PicoUsbID.h,v 1.4 2008/02/05 10:48:55 mark Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef PICOUSBID_H
#define PICOUSBID_H


/* ************************************************************************* */
/** Vendor id for Pico Technology */
/* ************************************************************************* */
const int VENDOR_ID_PICO_TECHNOLOGY = 0x0CE9;


/* ************************************************************************* */
/** \name Humidiprobe */
/* ************************************************************************* */
/*@{*/
/** HumidiProbe product ID */
const int PRODUCT_ID_HUMIDIPROBE = 0x1006;
/** HumidiProbe device ID, FX Processor, no FW loaded */
const int DEVICE_ID_HUMIDIPROBEMK1_CLEAN = 0x0000;
/** HumidiProbe device ID, FX1 Processor, no FW loaded */
const int DEVICE_ID_HUMIDIPROBEMK2_CLEAN = 0x0001;
/** HumidiProbe device ID, FX Processor, with FW loaded */
const int DEVICE_ID_HUMIDIPROBEMK1_LOADED = 0x0100;
/** HumidiProbe device ID, FX1 Processor, with FW loaded */
const int DEVICE_ID_HUMIDIPROBEMK2_LOADED = 0x0200;
/*@}*/


/* ************************************************************************* */
/** \name USB TC08 */
/* ************************************************************************* */
/*@{*/
/** USB TC08 product ID */
const int PRODUCT_ID_USB_TC08 = 0x1000;
/** USB TC08 device ID, FX Processor, no FW loaded */
const int DEVICE_ID_USB_TC08MK1_CLEAN = 0x0000;
/** USB TC08 device ID, FX1 Processor, no FW loaded */
const int DEVICE_ID_USB_TC08MK2_CLEAN = 0x0001;
/** USB TC08 device ID, FX Processor, with FW loaded */
const int DEVICE_ID_USB_TC08MK1_LOADED = 0x0100;
/** USB TC08 device ID, FX1 Processor, with FW loaded */
const int DEVICE_ID_USB_TC08MK2_LOADED = 0x0200;
/*@}*/

/* ************************************************************************* */
/** \name PicoScope 2000*/
/* ************************************************************************* */
/*@{*/
/** PS2000 product ID */
const int PRODUCT_ID_PS2000 = 0x1007;
/** PS2202 device ID. Note this is the same with or without firmware */
const int DEVICE_ID_PS2202 = 0x0001;
/** PS2203,4,5 device ID. Note this is the same with or without firmware */
const int DEVICE_ID_PS220X = 0x0003;
/** PS210x device ID. Note this is the same with or without firmware */
const int DEVICE_ID_PS210X = 0x0002;
/*@}*/

/* ************************************************************************* */
/** \name PicoScope 3000*/
/* ************************************************************************* */
/*@{*/
/** PS3000 product ID */
const int PRODUCT_ID_PS3000 = 0x1001;
/** PS320x device ID. Note this is the same with or without firmware */
const int DEVICE_ID_PS320X = 0x0000;
/** PS3x2x device ID. Note this is the same with or without firmware */
const int DEVICE_ID_PS3X2X = 0x0001;
/*@}*/

/* ************************************************************************* */
/** \name PicoScope 5000*/
/* ************************************************************************* */
/*@{*/
/** PS5000 product ID */
const int PRODUCT_ID_PS5000 = 0x1008;
/** PS520x device ID, no FW loaded */
const int DEVICE_ID_PS520X_CLEAN = 0x0001;
/** PS520x device ID, with FW loaded */
const int DEVICE_ID_PS520X_LOADED = 0x0002;
/*@}*/

#endif /* PICOUSBID_H */
