// Generated by gmmproc 2.39.4 -- DO NOT MODIFY!


#include <glibmm.h>

#include <wnckmm/screen.h>
#include <wnckmm/private/screen_p.h>


/** This file is part of wnckmm

    Copyright (c) 2013 Povilas Kanapickas  <povilas@radix.lt>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <wnckmm/libwnck-wrapper.h>
#include <wnckmm/window.h>
#include <wnckmm/workspace.h>

namespace Wnck {

} // namespace Wnck


namespace
{


static void Screen_signal_active_window_changed_callback(WnckScreen* self, WnckWindow* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_active_window_changed_info =
{
  "active-window-changed",
  (GCallback) &Screen_signal_active_window_changed_callback,
  (GCallback) &Screen_signal_active_window_changed_callback
};


static void Screen_signal_active_workspace_changed_callback(WnckScreen* self, WnckWorkspace* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Workspace* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_active_workspace_changed_info =
{
  "active-workspace-changed",
  (GCallback) &Screen_signal_active_workspace_changed_callback,
  (GCallback) &Screen_signal_active_workspace_changed_callback
};


static void Screen_signal_application_closed_callback(WnckScreen* self, WnckApplication* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Application* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_application_closed_info =
{
  "application-closed",
  (GCallback) &Screen_signal_application_closed_callback,
  (GCallback) &Screen_signal_application_closed_callback
};


static void Screen_signal_application_opened_callback(WnckScreen* self, WnckApplication* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Application* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_application_opened_info =
{
  "application-opened",
  (GCallback) &Screen_signal_application_opened_callback,
  (GCallback) &Screen_signal_application_opened_callback
};


static const Glib::SignalProxyInfo Screen_signal_backgroupnd_changed_info =
{
  "background-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Screen_signal_class_group_closed_callback(WnckScreen* self, WnckClassGroup* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,ClassGroup* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_class_group_closed_info =
{
  "class-group-closed",
  (GCallback) &Screen_signal_class_group_closed_callback,
  (GCallback) &Screen_signal_class_group_closed_callback
};


static void Screen_signal_class_group_opened_callback(WnckScreen* self, WnckClassGroup* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,ClassGroup* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_class_group_opened_info =
{
  "class-group-opened",
  (GCallback) &Screen_signal_class_group_opened_callback,
  (GCallback) &Screen_signal_class_group_opened_callback
};


static const Glib::SignalProxyInfo Screen_signal_showing_desktop_changed_info =
{
  "showing-desktop-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Screen_signal_viewports_changed_info =
{
  "viewports-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Screen_signal_window_opened_callback(WnckScreen* self, WnckWindow* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_window_opened_info =
{
  "window-opened",
  (GCallback) &Screen_signal_window_opened_callback,
  (GCallback) &Screen_signal_window_opened_callback
};


static void Screen_signal_window_closed_callback(WnckScreen* self, WnckWindow* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_window_closed_info =
{
  "window-closed",
  (GCallback) &Screen_signal_window_closed_callback,
  (GCallback) &Screen_signal_window_closed_callback
};


static const Glib::SignalProxyInfo Screen_signal_window_manager_changed_info =
{
  "window-manager-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Screen_signal_window_stacking_changed_info =
{
  "window-stacking-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Screen_signal_workspace_created_callback(WnckScreen* self, WnckWorkspace* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Workspace* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_workspace_created_info =
{
  "workspace-created",
  (GCallback) &Screen_signal_workspace_created_callback,
  (GCallback) &Screen_signal_workspace_created_callback
};


static void Screen_signal_workspace_destroyed_callback(WnckScreen* self, WnckWorkspace* p0,void* data)
{
  using namespace Wnck;
  typedef sigc::slot< void,Workspace* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Screen_signal_workspace_destroyed_info =
{
  "workspace-destroyed",
  (GCallback) &Screen_signal_workspace_destroyed_callback,
  (GCallback) &Screen_signal_workspace_destroyed_callback
};


} // anonymous namespace


namespace Glib
{

Wnck::Screen* wrap(WnckScreen* object, bool take_copy)
{
  return dynamic_cast<Wnck::Screen*> (Glib::wrap_auto ((GObject*)(object), take_copy));
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Wnck
{


/* The *_Class implementation: */

const Glib::Class& Screen_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Screen_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(wnck_screen_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Screen_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->active_window_changed = &active_window_changed_callback;
  klass->active_workspace_changed = &active_workspace_changed_callback;
  klass->application_closed = &application_closed_callback;
  klass->application_opened = &application_opened_callback;
  klass->background_changed = &background_changed_callback;
  klass->class_group_closed = &class_group_closed_callback;
  klass->class_group_opened = &class_group_opened_callback;
  klass->showing_desktop_changed = &showing_desktop_changed_callback;
  klass->viewports_changed = &viewports_changed_callback;
  klass->window_opened = &window_opened_callback;
  klass->window_closed = &window_closed_callback;
  klass->window_manager_changed = &window_manager_changed_callback;
  klass->window_stacking_changed = &window_stacking_changed_callback;
  klass->workspace_created = &workspace_created_callback;
  klass->workspace_destroyed = &workspace_destroyed_callback;
}


void Screen_Class::active_window_changed_callback(WnckScreen* self, WnckWindow* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_active_window_changed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->active_window_changed)
    (*base->active_window_changed)(self, p0);
}
void Screen_Class::active_workspace_changed_callback(WnckScreen* self, WnckWorkspace* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_active_workspace_changed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->active_workspace_changed)
    (*base->active_workspace_changed)(self, p0);
}
void Screen_Class::application_closed_callback(WnckScreen* self, WnckApplication* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_application_closed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->application_closed)
    (*base->application_closed)(self, p0);
}
void Screen_Class::application_opened_callback(WnckScreen* self, WnckApplication* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_application_opened(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->application_opened)
    (*base->application_opened)(self, p0);
}
void Screen_Class::background_changed_callback(WnckScreen* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_backgroupnd_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->background_changed)
    (*base->background_changed)(self);
}
void Screen_Class::class_group_closed_callback(WnckScreen* self, WnckClassGroup* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_class_group_closed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->class_group_closed)
    (*base->class_group_closed)(self, p0);
}
void Screen_Class::class_group_opened_callback(WnckScreen* self, WnckClassGroup* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_class_group_opened(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->class_group_opened)
    (*base->class_group_opened)(self, p0);
}
void Screen_Class::showing_desktop_changed_callback(WnckScreen* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_showing_desktop_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->showing_desktop_changed)
    (*base->showing_desktop_changed)(self);
}
void Screen_Class::viewports_changed_callback(WnckScreen* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_viewports_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->viewports_changed)
    (*base->viewports_changed)(self);
}
void Screen_Class::window_opened_callback(WnckScreen* self, WnckWindow* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_opened(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_opened)
    (*base->window_opened)(self, p0);
}
void Screen_Class::window_closed_callback(WnckScreen* self, WnckWindow* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_closed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_closed)
    (*base->window_closed)(self, p0);
}
void Screen_Class::window_manager_changed_callback(WnckScreen* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_manager_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_manager_changed)
    (*base->window_manager_changed)(self);
}
void Screen_Class::window_stacking_changed_callback(WnckScreen* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_stacking_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_stacking_changed)
    (*base->window_stacking_changed)(self);
}
void Screen_Class::workspace_created_callback(WnckScreen* self, WnckWorkspace* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_workspace_created(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->workspace_created)
    (*base->workspace_created)(self, p0);
}
void Screen_Class::workspace_destroyed_callback(WnckScreen* self, WnckWorkspace* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_workspace_destroyed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->workspace_destroyed)
    (*base->workspace_destroyed)(self, p0);
}


Glib::ObjectBase* Screen_Class::wrap_new(GObject* object)
{
  return new Screen((WnckScreen*)object);
}


Screen::Screen(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Screen::Screen(WnckScreen* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Screen::~Screen()
{}


Screen::CppClassType Screen::screen_class_; // initialize static member

GType Screen::get_type()
{
  return screen_class_.init().get_type();
}


GType Screen::get_base_type()
{
  return wnck_screen_get_type();
}


Screen* Screen::get_default()
{
  return Glib::wrap(wnck_screen_get_default());
}


Screen* Screen::get(int index)
{
  return Glib::wrap(wnck_screen_get(index));
}


Screen* Screen::get_for_root(gulong root_id)
{
  return Glib::wrap(wnck_screen_get_for_root(root_id));
}


int Screen::get_number() const
{
  return wnck_screen_get_number(const_cast<WnckScreen*>(gobj()));
}

int Screen::get_width() const
{
  return wnck_screen_get_width(const_cast<WnckScreen*>(gobj()));
}

int Screen::get_height() const
{
  return wnck_screen_get_height(const_cast<WnckScreen*>(gobj()));
}

void Screen::force_update()
{
  wnck_screen_force_update(gobj());
}

std::string Screen::get_window_manager_name()
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_screen_get_window_manager_name(gobj()));
}

bool Screen::net_wm_supports(const std::string& atom)
{
  return wnck_screen_net_wm_supports(gobj(), atom.c_str());
}

Window* Screen::get_active_window() const
{
  return Glib::wrap(wnck_screen_get_active_window(const_cast<WnckScreen*>(gobj())));
}

Window* Screen::get_previously_active_window() const
{
  return Glib::wrap(wnck_screen_get_previously_active_window(const_cast<WnckScreen*>(gobj())));
}

Glib::ListHandle<Window*> Screen::get_windows() const
{
  return Glib::ListHandle<Window*>(wnck_screen_get_windows(const_cast<WnckScreen*>(gobj())), Glib::OWNERSHIP_NONE);
}

Glib::ListHandle<Window*> Screen::get_windows_stacked() const
{
  return Glib::ListHandle<Window*>(wnck_screen_get_windows_stacked(const_cast<WnckScreen*>(gobj())), Glib::OWNERSHIP_NONE);
}

Workspace* Screen::get_active_workspace() const
{
  return Glib::wrap(wnck_screen_get_active_workspace(const_cast<WnckScreen*>(gobj())));
}

Workspace* Screen::get_workspace(int workspace) const
{
  return Glib::wrap(wnck_screen_get_workspace(const_cast<WnckScreen*>(gobj()), workspace));
}

int Screen::get_workspace_count() const
{
  return wnck_screen_get_workspace_count(const_cast<WnckScreen*>(gobj()));
}

void Screen::set_workspace_count(int count) const
{
  wnck_screen_change_workspace_count(const_cast<WnckScreen*>(gobj()), count);
}

void Screen::move_viewport(int x, int y) const
{
  wnck_screen_move_viewport(const_cast<WnckScreen*>(gobj()), x, y);
}

gulong Screen::get_background_pixmap_xid() const
{
  return wnck_screen_get_background_pixmap(const_cast<WnckScreen*>(gobj()));
}

void Screen::set_showing_desktop(bool show) const
{
  wnck_screen_toggle_showing_desktop(const_cast<WnckScreen*>(gobj()), static_cast<int>(show));
}


Glib::SignalProxy1< void,Window* > Screen::signal_active_window_changed()
{
  return Glib::SignalProxy1< void,Window* >(this, &Screen_signal_active_window_changed_info);
}


Glib::SignalProxy1< void,Workspace* > Screen::signal_active_workspace_changed()
{
  return Glib::SignalProxy1< void,Workspace* >(this, &Screen_signal_active_workspace_changed_info);
}


Glib::SignalProxy1< void,Application* > Screen::signal_application_closed()
{
  return Glib::SignalProxy1< void,Application* >(this, &Screen_signal_application_closed_info);
}


Glib::SignalProxy1< void,Application* > Screen::signal_application_opened()
{
  return Glib::SignalProxy1< void,Application* >(this, &Screen_signal_application_opened_info);
}


Glib::SignalProxy0< void > Screen::signal_backgroupnd_changed()
{
  return Glib::SignalProxy0< void >(this, &Screen_signal_backgroupnd_changed_info);
}


Glib::SignalProxy1< void,ClassGroup* > Screen::signal_class_group_closed()
{
  return Glib::SignalProxy1< void,ClassGroup* >(this, &Screen_signal_class_group_closed_info);
}


Glib::SignalProxy1< void,ClassGroup* > Screen::signal_class_group_opened()
{
  return Glib::SignalProxy1< void,ClassGroup* >(this, &Screen_signal_class_group_opened_info);
}


Glib::SignalProxy0< void > Screen::signal_showing_desktop_changed()
{
  return Glib::SignalProxy0< void >(this, &Screen_signal_showing_desktop_changed_info);
}


Glib::SignalProxy0< void > Screen::signal_viewports_changed()
{
  return Glib::SignalProxy0< void >(this, &Screen_signal_viewports_changed_info);
}


Glib::SignalProxy1< void,Window* > Screen::signal_window_opened()
{
  return Glib::SignalProxy1< void,Window* >(this, &Screen_signal_window_opened_info);
}


Glib::SignalProxy1< void,Window* > Screen::signal_window_closed()
{
  return Glib::SignalProxy1< void,Window* >(this, &Screen_signal_window_closed_info);
}


Glib::SignalProxy0< void > Screen::signal_window_manager_changed()
{
  return Glib::SignalProxy0< void >(this, &Screen_signal_window_manager_changed_info);
}


Glib::SignalProxy0< void > Screen::signal_window_stacking_changed()
{
  return Glib::SignalProxy0< void >(this, &Screen_signal_window_stacking_changed_info);
}


Glib::SignalProxy1< void,Workspace* > Screen::signal_workspace_created()
{
  return Glib::SignalProxy1< void,Workspace* >(this, &Screen_signal_workspace_created_info);
}


Glib::SignalProxy1< void,Workspace* > Screen::signal_workspace_destroyed()
{
  return Glib::SignalProxy1< void,Workspace* >(this, &Screen_signal_workspace_destroyed_info);
}


void Wnck::Screen::on_active_window_changed(Window* previously_active_window)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->active_window_changed)
    (*base->active_window_changed)(gobj(),previously_active_window->gobj());
}
void Wnck::Screen::on_active_workspace_changed(Workspace* previously_active_workspace)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->active_workspace_changed)
    (*base->active_workspace_changed)(gobj(),previously_active_workspace->gobj());
}
void Wnck::Screen::on_application_closed(Application* app)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->application_closed)
    (*base->application_closed)(gobj(),app->gobj());
}
void Wnck::Screen::on_application_opened(Application* app)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->application_opened)
    (*base->application_opened)(gobj(),app->gobj());
}
void Wnck::Screen::on_backgroupnd_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->background_changed)
    (*base->background_changed)(gobj());
}
void Wnck::Screen::on_class_group_closed(ClassGroup* app)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->class_group_closed)
    (*base->class_group_closed)(gobj(),app->gobj());
}
void Wnck::Screen::on_class_group_opened(ClassGroup* app)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->class_group_opened)
    (*base->class_group_opened)(gobj(),app->gobj());
}
void Wnck::Screen::on_showing_desktop_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->showing_desktop_changed)
    (*base->showing_desktop_changed)(gobj());
}
void Wnck::Screen::on_viewports_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->viewports_changed)
    (*base->viewports_changed)(gobj());
}
void Wnck::Screen::on_window_opened(Window* window)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_opened)
    (*base->window_opened)(gobj(),window->gobj());
}
void Wnck::Screen::on_window_closed(Window* window)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_closed)
    (*base->window_closed)(gobj(),window->gobj());
}
void Wnck::Screen::on_window_manager_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_manager_changed)
    (*base->window_manager_changed)(gobj());
}
void Wnck::Screen::on_window_stacking_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_stacking_changed)
    (*base->window_stacking_changed)(gobj());
}
void Wnck::Screen::on_workspace_created(Workspace* workspace)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->workspace_created)
    (*base->workspace_created)(gobj(),workspace->gobj());
}
void Wnck::Screen::on_workspace_destroyed(Workspace* workspace)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->workspace_destroyed)
    (*base->workspace_destroyed)(gobj(),workspace->gobj());
}


} // namespace Wnck


