/* special.c -- DVI command 239 to 242.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include <alloca.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include "extern.h"
#include "fax.h"


#define FIRST	1
#define LAST	2
#define ALL	3

struct _special
  {
    int code;				/* Code number. */
    char *head;				/* Header name (RFC format). */
    int len;				/* Precomputed length of it. */
    int use;				/* FIRST, LAST or ALL. */
    char *str;				/* Single header value. */
    char **vec;				/* Array of header values. */
    int ent;				/* Number of values. */
    int alloc;				/* Allocated space. */
  };

#define magic(i)	(specialv[i].code)
#define header(i)	(specialv[i].head)
#define length(i)	(specialv[i].len)
#define select(i)	(specialv[i].use)
#define string(i)	(specialv[i].str)
#define vector(i)	(specialv[i].vec)
#define entry(i, c)	(specialv[i].vec[c])
#define entries(i)	(specialv[i].ent)
#define allocated(i)	(specialv[i].alloc)

const char *prefix = "fax-";

struct _special specialv[] =
  {
    {FROM, "from:", 5, LAST, 0, 0, 0, 0},
    {REPLY_TO, "reply-to:", 9, LAST, 0, 0, 0, 0},
    {TO, "to:", 3, LAST, 0, 0, 0, 0},
    {CC, "cc:", 3, ALL, 0, 0, 0, 0},
    {ORGANIZATION, "organization:", 13, LAST, 0, 0, 0, 0},
  };

int specials = sizeof (specialv) / sizeof (specialv[0]);


int
DEFUN (special, (size),
int size)
{
  char *buf, *pos;
  char *head, *val;
  int len, sub;

  if (size < 4)
    len = get_number (size, UNSIGNED);
  else
    len = get_number (size, SIGNED);

  buf = alloca (len + 1);
  get_block (buf, len);
  buf[len] = 0;

  if (*buf == *prefix && strncmp (buf, prefix, strlen (prefix)) == 0)
    {
      head = buf + strlen (prefix);

      for (sub = 0; sub < specials; ++sub)
	if (strncmp (head, header (sub), length (sub)) == 0)
	  {
	    for (pos = head + length (sub); isspace (*pos); ++pos)
	      ;

	    val = strdup (pos);
	    if (!val)
	      die ("%s: %s\n", prog_name, strerror (errno));

	    switch (select (sub))
	      {
	      case FIRST:

		if (!string (sub))
		  string (sub) = val;

		return (0);

	      case LAST:

		if (string (sub))
		  free (string (sub));
		string (sub) = val;

		return (0);

	      case ALL:

		if (entries (sub) == allocated (sub))
		  {
		    allocated (sub) += 8;

		    vector (sub) = realloc (vector (sub),
		      allocated (sub) * sizeof (char *));
		    if (!vector (sub))
		      die ("%s: %s\n", prog_name, strerror (errno));

		    memset (vector (sub) + entries (sub), 0,
		      8 * sizeof (char *));
		  }

		entry (sub, entries (sub)) = val; ++entries (sub);

		return (0);

	      default:

		die ("%s:%s:%s: `switch (%d)' shouldn't happen\n",
		  prog_name, __FILE__, __LINE__, select (sub));
	      }
	  }
    }

  return (0);
}


char *
DEFUN (fax, (code),
int code)
{
  int sub, ent;

  if (code != 0)
    {
      for (sub = 0; sub < specials; ++sub)
	if (magic (sub) == code)
	  switch (select (sub))
	    {
	    case FIRST:
	    case LAST:

	      return (char *) string (sub);

	    case ALL:

	      return (char *) vector (sub);
	    }

      return (0);
    }

  for (sub = 0; sub < specials; ++sub)
    switch (select (sub))
      {
      case FIRST:
      case LAST:

	if (string (sub))
	  {
	    free (string (sub));
	    string (sub) = 0;
	  }

	break;

      case ALL:

	if (vector (sub))
	  {
	    for (ent = 0; ent < entries (sub); ++ent)
	      {
		free (entry (sub, ent));
		entry (sub, ent) = 0;
	      }

	    entries (sub) = 0;
	  }
      }

  return (0);
}
