// clang-format off
/*
 * Copyright (c) 2020, 2022, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0,
 * as published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms, as
 * designated in a particular file or component or in included license
 * documentation. The authors of MySQL hereby grant you an additional
 * permission to link the program and your derivative works with the
 * separately licensed software that they have included with MySQL.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */




// Generated from /Users/kojima/dev/ngshell/mysqlshdk/libs/parser/grammars/MySQLParser.g4 by ANTLR 4.10.1


#include "MySQLParserListener.h"
#include "MySQLParserVisitor.h"

#include "MySQLParser.h"

#include "mysqlshdk/libs/parser/MySQLBaseRecognizer.h"

using namespace antlrcpp;
using namespace parsers;

using namespace antlr4;

namespace {

struct MySQLParserStaticData final {
  MySQLParserStaticData(std::vector<std::string> ruleNames,
                        std::vector<std::string> literalNames,
                        std::vector<std::string> symbolicNames)
      : ruleNames(std::move(ruleNames)), literalNames(std::move(literalNames)),
        symbolicNames(std::move(symbolicNames)),
        vocabulary(this->literalNames, this->symbolicNames) {}

  MySQLParserStaticData(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData(MySQLParserStaticData&&) = delete;
  MySQLParserStaticData& operator=(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData& operator=(MySQLParserStaticData&&) = delete;

  std::vector<antlr4::dfa::DFA> decisionToDFA;
  antlr4::atn::PredictionContextCache sharedContextCache;
  const std::vector<std::string> ruleNames;
  const std::vector<std::string> literalNames;
  const std::vector<std::string> symbolicNames;
  const antlr4::dfa::Vocabulary vocabulary;
  antlr4::atn::SerializedATNView serializedATN;
  std::unique_ptr<antlr4::atn::ATN> atn;
};

std::once_flag mysqlparserParserOnceFlag;
MySQLParserStaticData *mysqlparserParserStaticData = nullptr;

void mysqlparserParserInitialize() {
  assert(mysqlparserParserStaticData == nullptr);
  auto staticData = std::make_unique<MySQLParserStaticData>(
    std::vector<std::string>{
      "query", "simpleStatement", "alterStatement", "alterDatabase", "alterDatabaseOption", 
      "alterEvent", "alterLogfileGroup", "alterLogfileGroupOptions", "alterLogfileGroupOption", 
      "alterServer", "alterTable", "alterTableActions", "alterCommandList", 
      "alterCommandsModifierList", "standaloneAlterCommands", "alterPartition", 
      "alterList", "alterCommandsModifier", "alterListItem", "place", "restrict", 
      "alterOrderList", "alterAlgorithmOption", "alterLockOption", "indexLockAndAlgorithm", 
      "withValidation", "removePartitioning", "allOrPartitionNameList", 
      "alterTablespace", "alterUndoTablespace", "undoTableSpaceOptions", 
      "undoTableSpaceOption", "alterTablespaceOptions", "alterTablespaceOption", 
      "changeTablespaceOption", "alterView", "viewTail", "viewQueryBlock", 
      "viewCheckOption", "alterInstanceStatement", "createStatement", "createDatabase", 
      "createDatabaseOption", "createTable", "tableElementList", "tableElement", 
      "duplicateAsQueryExpression", "queryExpressionOrParens", "createRoutine", 
      "createProcedure", "createFunction", "createUdf", "routineCreateOption", 
      "routineAlterOptions", "routineOption", "createIndex", "indexNameAndType", 
      "createIndexTarget", "createLogfileGroup", "logfileGroupOptions", 
      "logfileGroupOption", "createServer", "serverOptions", "serverOption", 
      "createTablespace", "createUndoTablespace", "tsDataFileName", "tsDataFile", 
      "tablespaceOptions", "tablespaceOption", "tsOptionInitialSize", "tsOptionUndoRedoBufferSize", 
      "tsOptionAutoextendSize", "tsOptionMaxSize", "tsOptionExtentSize", 
      "tsOptionNodegroup", "tsOptionEngine", "tsOptionWait", "tsOptionComment", 
      "tsOptionFileblockSize", "tsOptionEncryption", "tsOptionEngineAttribute", 
      "createView", "viewReplaceOrAlgorithm", "viewAlgorithm", "viewSuid", 
      "createTrigger", "triggerFollowsPrecedesClause", "createEvent", "createRole", 
      "createSpatialReference", "srsAttribute", "dropStatement", "dropDatabase", 
      "dropEvent", "dropFunction", "dropProcedure", "dropIndex", "dropLogfileGroup", 
      "dropLogfileGroupOption", "dropServer", "dropTable", "dropTableSpace", 
      "dropTrigger", "dropView", "dropRole", "dropSpatialReference", "dropUndoTablespace", 
      "renameTableStatement", "renamePair", "truncateTableStatement", "importStatement", 
      "callStatement", "deleteStatement", "partitionDelete", "deleteStatementOption", 
      "doStatement", "handlerStatement", "handlerReadOrScan", "insertStatement", 
      "insertLockOption", "insertFromConstructor", "fields", "insertValues", 
      "insertQueryExpression", "valueList", "values", "valuesReference", 
      "insertUpdateList", "loadStatement", "dataOrXml", "xmlRowsIdentifiedBy", 
      "loadDataFileTail", "loadDataFileTargetList", "fieldOrVariableList", 
      "replaceStatement", "selectStatement", "selectStatementWithInto", 
      "queryExpression", "queryExpressionBody", "queryExpressionParens", 
      "queryPrimary", "querySpecification", "subquery", "querySpecOption", 
      "limitClause", "simpleLimitClause", "limitOptions", "limitOption", 
      "intoClause", "procedureAnalyseClause", "havingClause", "windowClause", 
      "windowDefinition", "windowSpec", "windowSpecDetails", "windowFrameClause", 
      "windowFrameUnits", "windowFrameExtent", "windowFrameStart", "windowFrameBetween", 
      "windowFrameBound", "windowFrameExclusion", "withClause", "commonTableExpression", 
      "groupByClause", "olapOption", "orderClause", "direction", "fromClause", 
      "tableReferenceList", "tableValueConstructor", "explicitTable", "rowValueExplicit", 
      "selectOption", "lockingClauseList", "lockingClause", "lockStrengh", 
      "lockedRowAction", "selectItemList", "selectItem", "selectAlias", 
      "whereClause", "tableReference", "escapedTableReference", "joinedTable", 
      "naturalJoinType", "innerJoinType", "outerJoinType", "tableFactor", 
      "singleTable", "singleTableParens", "derivedTable", "tableReferenceListParens", 
      "tableFunction", "columnsClause", "jtColumn", "onEmptyOrError", "onEmptyOrErrorJsonTable", 
      "onEmpty", "onError", "jsonOnResponse", "unionOption", "tableAlias", 
      "indexHintList", "indexHint", "indexHintType", "keyOrIndex", "constraintKeyType", 
      "indexHintClause", "indexList", "indexListElement", "updateStatement", 
      "transactionOrLockingStatement", "transactionStatement", "beginWork", 
      "startTransactionOptionList", "savepointStatement", "lockStatement", 
      "lockItem", "lockOption", "xaStatement", "xaConvert", "xid", "replicationStatement", 
      "resetOption", "sourceResetOptions", "replicationLoad", "changeReplicationSource", 
      "changeSource", "sourceDefinitions", "sourceDefinition", "changeReplicationSourceAutoPosition", 
      "changeReplicationSourceHost", "changeReplicationSourceBind", "changeReplicationSourceUser", 
      "changeReplicationSourcePassword", "changeReplicationSourcePort", 
      "changeReplicationSourceConnectRetry", "changeReplicationSourceRetryCount", 
      "changeReplicationSourceDelay", "changeReplicationSourceSSL", "changeReplicationSourceSSLCA", 
      "changeReplicationSourceSSLCApath", "changeReplicationSourceSSLCipher", 
      "changeReplicationSourceSSLCLR", "changeReplicationSourceSSLCLRpath", 
      "changeReplicationSourceSSLKey", "changeReplicationSourceSSLVerifyServerCert", 
      "changeReplicationSourceTLSVersion", "changeReplicationSourceTLSCiphersuites", 
      "changeReplicationSourceSSLCert", "changeReplicationSourcePublicKey", 
      "changeReplicationSourceGetSourcePublicKey", "changeReplicationSourceHeartbeatPeriod", 
      "changeReplicationSourceCompressionAlgorithm", "changeReplicationSourceZstdCompressionLevel", 
      "privilegeCheckDef", "tablePrimaryKeyCheckDef", "assignGtidsToAnonymousTransactionsDefinition", 
      "sourceTlsCiphersuitesDef", "sourceFileDef", "sourceLogFile", "sourceLogPos", 
      "serverIdList", "changeReplication", "filterDefinition", "filterDbList", 
      "filterTableList", "filterStringList", "filterWildDbTableString", 
      "filterDbPairList", "startReplicaStatement", "stopReplicaStatement", 
      "replicaUntil", "userOption", "passwordOption", "defaultAuthOption", 
      "pluginDirOption", "replicaThreadOptions", "replicaThreadOption", 
      "groupReplication", "groupReplicationStartOptions", "groupReplicationStartOption", 
      "groupReplicationUser", "groupReplicationPassword", "groupReplicationPluginAuth", 
      "replica", "preparedStatement", "executeStatement", "executeVarList", 
      "cloneStatement", "dataDirSSL", "ssl", "accountManagementStatement", 
      "alterUserStatement", "alterUserList", "alterUser", "oldAlterUser", 
      "userFunction", "createUserStatement", "createUserTail", "userAttributes", 
      "defaultRoleClause", "requireClause", "connectOptions", "accountLockPasswordExpireOptions", 
      "dropUserStatement", "grantStatement", "grantTargetList", "grantOptions", 
      "exceptRoleList", "withRoles", "grantAs", "versionedRequireClause", 
      "renameUserStatement", "revokeStatement", "onTypeTo", "aclType", "roleOrPrivilegesList", 
      "roleOrPrivilege", "grantIdentifier", "requireList", "requireListElement", 
      "grantOption", "setRoleStatement", "roleList", "role", "tableAdministrationStatement", 
      "histogram", "checkOption", "repairType", "installUninstallStatement", 
      "setStatement", "startOptionValueList", "transactionCharacteristics", 
      "transactionAccessMode", "isolationLevel", "optionValueListContinued", 
      "optionValueNoOptionType", "optionValue", "startOptionValueListFollowingOptionType", 
      "optionValueFollowingOptionType", "setExprOrDefault", "showDatabasesStatement", 
      "showTablesStatement", "showTriggersStatement", "showEventsStatement", 
      "showTableStatusStatement", "showOpenTablesStatement", "showPluginsStatement", 
      "showEngineLogsStatement", "showEngineMutexStatement", "showEngineStatusStatement", 
      "showColumnsStatement", "showBinaryLogsStatement", "showReplicasStatement", 
      "showBinlogEventsStatement", "showRelaylogEventsStatement", "showKeysStatement", 
      "showEnginesStatement", "showCountWarningsStatement", "showCountErrorsStatement", 
      "showWarningsStatement", "showErrorsStatement", "showProfilesStatement", 
      "showProfileStatement", "showStatusStatement", "showProcessListStatement", 
      "showVariablesStatement", "showCharacterSetStatement", "showCollationStatement", 
      "showPrivilegesStatement", "showGrantsStatement", "showCreateDatabaseStatement", 
      "showCreateTableStatement", "showCreateViewStatement", "showMasterStatusStatement", 
      "showReplicaStatusStatement", "showCreateProcedureStatement", "showCreateFunctionStatement", 
      "showCreateTriggerStatement", "showCreateProcedureStatusStatement", 
      "showCreateFunctionStatusStatement", "showCreateProcedureCodeStatement", 
      "showCreateFunctionCodeStatement", "showCreateEventStatement", "showCreateUserStatement", 
      "showCommandType", "engineOrAll", "fromOrIn", "inDb", "profileDefinitions", 
      "profileDefinition", "otherAdministrativeStatement", "keyCacheListOrParts", 
      "keyCacheList", "assignToKeycache", "assignToKeycachePartition", "cacheKeyList", 
      "keyUsageElement", "keyUsageList", "flushOption", "logType", "flushTables", 
      "flushTablesOptions", "preloadTail", "preloadList", "preloadKeys", 
      "adminPartition", "resourceGroupManagement", "createResourceGroup", 
      "resourceGroupVcpuList", "vcpuNumOrRange", "resourceGroupPriority", 
      "resourceGroupEnableDisable", "alterResourceGroup", "setResourceGroup", 
      "threadIdList", "dropResourceGroup", "utilityStatement", "describeStatement", 
      "explainStatement", "explainableStatement", "helpCommand", "useCommand", 
      "restartServer", "expr", "boolPri", "compOp", "predicate", "predicateOperations", 
      "bitExpr", "simpleExpr", "arrayCast", "jsonOperator", "sumExpr", "groupingOperation", 
      "windowFunctionCall", "windowingClause", "leadLagInfo", "stableInteger", 
      "paramOrVar", "nullTreatment", "jsonFunction", "inSumExpr", "identListArg", 
      "identList", "fulltextOptions", "runtimeFunctionCall", "returningType", 
      "geometryFunction", "timeFunctionParameters", "fractionalPrecision", 
      "weightStringLevels", "weightStringLevelListItem", "dateTimeTtype", 
      "trimFunction", "substringFunction", "functionCall", "udfExprList", 
      "udfExpr", "userVariable", "userVariableIdentifier", "inExpressionUserVariableAssignment", 
      "rvalueSystemOrUserVariable", "lvalueVariable", "rvalueSystemVariable", 
      "whenExpression", "thenExpression", "elseExpression", "castType", 
      "exprList", "charset", "notRule", "not2Rule", "interval", "intervalTimeStamp", 
      "exprListWithParentheses", "exprWithParentheses", "simpleExprWithParentheses", 
      "orderList", "orderExpression", "groupList", "groupingExpression", 
      "channel", "compoundStatement", "returnStatement", "ifStatement", 
      "ifBody", "thenStatement", "compoundStatementList", "caseStatement", 
      "elseStatement", "labeledBlock", "unlabeledBlock", "label", "beginEndBlock", 
      "labeledControl", "unlabeledControl", "loopBlock", "whileDoBlock", 
      "repeatUntilBlock", "spDeclarations", "spDeclaration", "variableDeclaration", 
      "conditionDeclaration", "spCondition", "sqlstate", "handlerDeclaration", 
      "handlerCondition", "cursorDeclaration", "iterateStatement", "leaveStatement", 
      "getDiagnosticsStatement", "signalAllowedExpr", "statementInformationItem", 
      "conditionInformationItem", "signalInformationItemName", "signalStatement", 
      "resignalStatement", "signalInformationItem", "cursorOpen", "cursorClose", 
      "cursorFetch", "schedule", "columnDefinition", "checkOrReferences", 
      "checkConstraint", "constraintEnforcement", "tableConstraintDef", 
      "constraintName", "fieldDefinition", "columnAttribute", "columnFormat", 
      "storageMedia", "now", "nowOrSignedLiteral", "gcolAttribute", "references", 
      "deleteOption", "keyList", "keyPart", "keyListWithExpression", "keyPartOrExpression", 
      "keyListVariants", "indexType", "indexOption", "commonIndexOption", 
      "visibility", "indexTypeClause", "fulltextIndexOption", "spatialIndexOption", 
      "dataTypeDefinition", "dataType", "nchar", "realType", "fieldLength", 
      "fieldOptions", "charsetWithOptBinary", "ascii", "unicode", "wsNumCodepoints", 
      "typeDatetimePrecision", "functionDatetimePrecision", "charsetName", 
      "collationName", "createTableOptions", "createTableOptionsSpaceSeparated", 
      "createTableOption", "ternaryOption", "defaultCollation", "defaultEncryption", 
      "defaultCharset", "partitionClause", "partitionTypeDef", "subPartitions", 
      "partitionKeyAlgorithm", "partitionDefinitions", "partitionDefinition", 
      "partitionValuesIn", "partitionOption", "subpartitionDefinition", 
      "partitionValueItemListParen", "partitionValueItem", "definerClause", 
      "ifExists", "ifNotExists", "procedureParameter", "functionParameter", 
      "collate", "typeWithOptCollate", "schemaIdentifierPair", "viewRefList", 
      "updateList", "updateElement", "charsetClause", "fieldsClause", "fieldTerm", 
      "linesClause", "lineTerm", "userList", "createUserList", "createUser", 
      "createUserWithMfa", "identification", "identifiedByPassword", "identifiedByRandomPassword", 
      "identifiedWithPlugin", "identifiedWithPluginAsAuth", "identifiedWithPluginByPassword", 
      "identifiedWithPluginByRandomPassword", "initialAuth", "retainCurrentPassword", 
      "discardOldPassword", "userRegistration", "factor", "replacePassword", 
      "userIdentifierOrText", "user", "likeClause", "likeOrWhere", "onlineOption", 
      "noWriteToBinLog", "usePartition", "fieldIdentifier", "columnName", 
      "columnInternalRef", "columnInternalRefList", "columnRef", "insertIdentifier", 
      "indexName", "indexRef", "tableWild", "schemaName", "schemaRef", "procedureName", 
      "procedureRef", "functionName", "functionRef", "triggerName", "triggerRef", 
      "viewName", "viewRef", "tablespaceName", "tablespaceRef", "logfileGroupName", 
      "logfileGroupRef", "eventName", "eventRef", "udfName", "serverName", 
      "serverRef", "engineRef", "tableName", "filterTableRef", "tableRefWithWildcard", 
      "tableRef", "tableRefList", "tableAliasRefList", "parameterName", 
      "labelIdentifier", "labelRef", "roleIdentifier", "pluginRef", "componentRef", 
      "resourceGroupRef", "windowName", "pureIdentifier", "identifier", 
      "identifierList", "identifierListWithParentheses", "qualifiedIdentifier", 
      "simpleIdentifier", "dotIdentifier", "ulong_number", "real_ulong_number", 
      "ulonglong_number", "real_ulonglong_number", "signedLiteral", "signedLiteralOrNull", 
      "literal", "literalOrNull", "nullAsLiteral", "stringList", "textStringLiteral", 
      "textString", "textStringHash", "textLiteral", "textStringNoLinebreak", 
      "textStringLiteralList", "numLiteral", "boolLiteral", "nullLiteral", 
      "int64Literal", "temporalLiteral", "floatOptions", "standardFloatOptions", 
      "precision", "textOrIdentifier", "lValueIdentifier", "roleIdentifierOrText", 
      "sizeNumber", "parentheses", "equal", "optionType", "rvalueSystemVariableType", 
      "setVarIdentType", "jsonAttribute", "identifierKeyword", "identifierKeywordsAmbiguous1RolesAndLabels", 
      "identifierKeywordsAmbiguous2Labels", "labelKeyword", "identifierKeywordsAmbiguous3Roles", 
      "identifierKeywordsUnambiguous", "roleKeyword", "lValueKeyword", "identifierKeywordsAmbiguous4SystemVariables", 
      "roleOrIdentifierKeyword", "roleOrLabelKeyword"
    },
    std::vector<std::string>{
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "'='", "':='", "'<=>'", "'>='", "'>'", "'<='", "'<'", "'!='", 
      "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "'~'", "'<<'", "'>>'", "'&&'", 
      "'&'", "'^'", "'||'", "'|'", "'.'", "','", "';'", "':'", "'('", "')'", 
      "'{'", "'}'", "'_'", "'->'", "'->>'", "'@'", "", "'\\N'", "'\\u003F'", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "'<>'"
    },
    std::vector<std::string>{
      "", "ACCESSIBLE_SYMBOL", "ACCOUNT_SYMBOL", "ACTION_SYMBOL", "ADD_SYMBOL", 
      "ADDDATE_SYMBOL", "AFTER_SYMBOL", "AGAINST_SYMBOL", "AGGREGATE_SYMBOL", 
      "ALGORITHM_SYMBOL", "ALL_SYMBOL", "ALTER_SYMBOL", "ALWAYS_SYMBOL", 
      "ANALYSE_SYMBOL", "ANALYZE_SYMBOL", "AND_SYMBOL", "ANY_SYMBOL", "AS_SYMBOL", 
      "ASC_SYMBOL", "ASCII_SYMBOL", "ASENSITIVE_SYMBOL", "AT_SYMBOL", "AUTHORS_SYMBOL", 
      "AUTOEXTEND_SIZE_SYMBOL", "AUTO_INCREMENT_SYMBOL", "AVG_ROW_LENGTH_SYMBOL", 
      "AVG_SYMBOL", "BACKUP_SYMBOL", "BEFORE_SYMBOL", "BEGIN_SYMBOL", "BETWEEN_SYMBOL", 
      "BIGINT_SYMBOL", "BINARY_SYMBOL", "BINLOG_SYMBOL", "BIN_NUM_SYMBOL", 
      "BIT_AND_SYMBOL", "BIT_OR_SYMBOL", "BIT_SYMBOL", "BIT_XOR_SYMBOL", 
      "BLOB_SYMBOL", "BLOCK_SYMBOL", "BOOLEAN_SYMBOL", "BOOL_SYMBOL", "BOTH_SYMBOL", 
      "BTREE_SYMBOL", "BY_SYMBOL", "BYTE_SYMBOL", "CACHE_SYMBOL", "CALL_SYMBOL", 
      "CASCADE_SYMBOL", "CASCADED_SYMBOL", "CASE_SYMBOL", "CAST_SYMBOL", 
      "CATALOG_NAME_SYMBOL", "CHAIN_SYMBOL", "CHANGE_SYMBOL", "CHANGED_SYMBOL", 
      "CHANNEL_SYMBOL", "CHARSET_SYMBOL", "CHARACTER_SYMBOL", "CHAR_SYMBOL", 
      "CHECKSUM_SYMBOL", "CHECK_SYMBOL", "CIPHER_SYMBOL", "CLASS_ORIGIN_SYMBOL", 
      "CLIENT_SYMBOL", "CLOSE_SYMBOL", "COALESCE_SYMBOL", "CODE_SYMBOL", 
      "COLLATE_SYMBOL", "COLLATION_SYMBOL", "COLUMNS_SYMBOL", "COLUMN_SYMBOL", 
      "COLUMN_NAME_SYMBOL", "COLUMN_FORMAT_SYMBOL", "COMMENT_SYMBOL", "COMMITTED_SYMBOL", 
      "COMMIT_SYMBOL", "COMPACT_SYMBOL", "COMPLETION_SYMBOL", "COMPRESSED_SYMBOL", 
      "COMPRESSION_SYMBOL", "CONCURRENT_SYMBOL", "CONDITION_SYMBOL", "CONNECTION_SYMBOL", 
      "CONSISTENT_SYMBOL", "CONSTRAINT_SYMBOL", "CONSTRAINT_CATALOG_SYMBOL", 
      "CONSTRAINT_NAME_SYMBOL", "CONSTRAINT_SCHEMA_SYMBOL", "CONTAINS_SYMBOL", 
      "CONTEXT_SYMBOL", "CONTINUE_SYMBOL", "CONTRIBUTORS_SYMBOL", "CONVERT_SYMBOL", 
      "COUNT_SYMBOL", "CPU_SYMBOL", "CREATE_SYMBOL", "CROSS_SYMBOL", "CUBE_SYMBOL", 
      "CURDATE_SYMBOL", "CURRENT_SYMBOL", "CURRENT_DATE_SYMBOL", "CURRENT_TIME_SYMBOL", 
      "CURRENT_TIMESTAMP_SYMBOL", "CURRENT_USER_SYMBOL", "CURSOR_SYMBOL", 
      "CURSOR_NAME_SYMBOL", "CURTIME_SYMBOL", "DATABASE_SYMBOL", "DATABASES_SYMBOL", 
      "DATAFILE_SYMBOL", "DATA_SYMBOL", "DATETIME_SYMBOL", "DATE_ADD_SYMBOL", 
      "DATE_SUB_SYMBOL", "DATE_SYMBOL", "DAYOFMONTH_SYMBOL", "DAY_HOUR_SYMBOL", 
      "DAY_MICROSECOND_SYMBOL", "DAY_MINUTE_SYMBOL", "DAY_SECOND_SYMBOL", 
      "DAY_SYMBOL", "DEALLOCATE_SYMBOL", "DEC_SYMBOL", "DECIMAL_NUM_SYMBOL", 
      "DECIMAL_SYMBOL", "DECLARE_SYMBOL", "DEFAULT_SYMBOL", "DEFAULT_AUTH_SYMBOL", 
      "DEFINER_SYMBOL", "DELAYED_SYMBOL", "DELAY_KEY_WRITE_SYMBOL", "DELETE_SYMBOL", 
      "DESC_SYMBOL", "DESCRIBE_SYMBOL", "DES_KEY_FILE_SYMBOL", "DETERMINISTIC_SYMBOL", 
      "DIAGNOSTICS_SYMBOL", "DIRECTORY_SYMBOL", "DISABLE_SYMBOL", "DISCARD_SYMBOL", 
      "DISK_SYMBOL", "DISTINCT_SYMBOL", "DISTINCTROW_SYMBOL", "DIV_SYMBOL", 
      "DOUBLE_SYMBOL", "DO_SYMBOL", "DROP_SYMBOL", "DUAL_SYMBOL", "DUMPFILE_SYMBOL", 
      "DUPLICATE_SYMBOL", "DYNAMIC_SYMBOL", "EACH_SYMBOL", "ELSE_SYMBOL", 
      "ELSEIF_SYMBOL", "ENABLE_SYMBOL", "ENCLOSED_SYMBOL", "ENCRYPTION_SYMBOL", 
      "END_SYMBOL", "ENDS_SYMBOL", "END_OF_INPUT_SYMBOL", "ENGINES_SYMBOL", 
      "ENGINE_SYMBOL", "ENUM_SYMBOL", "ERROR_SYMBOL", "ERRORS_SYMBOL", "ESCAPED_SYMBOL", 
      "ESCAPE_SYMBOL", "EVENTS_SYMBOL", "EVENT_SYMBOL", "EVERY_SYMBOL", 
      "EXCHANGE_SYMBOL", "EXECUTE_SYMBOL", "EXISTS_SYMBOL", "EXIT_SYMBOL", 
      "EXPANSION_SYMBOL", "EXPIRE_SYMBOL", "EXPLAIN_SYMBOL", "EXPORT_SYMBOL", 
      "EXTENDED_SYMBOL", "EXTENT_SIZE_SYMBOL", "EXTRACT_SYMBOL", "FALSE_SYMBOL", 
      "FAST_SYMBOL", "FAULTS_SYMBOL", "FETCH_SYMBOL", "FIELDS_SYMBOL", "FILE_SYMBOL", 
      "FILE_BLOCK_SIZE_SYMBOL", "FILTER_SYMBOL", "FIRST_SYMBOL", "FIXED_SYMBOL", 
      "FLOAT4_SYMBOL", "FLOAT8_SYMBOL", "FLOAT_SYMBOL", "FLUSH_SYMBOL", 
      "FOLLOWS_SYMBOL", "FORCE_SYMBOL", "FOREIGN_SYMBOL", "FOR_SYMBOL", 
      "FORMAT_SYMBOL", "FOUND_SYMBOL", "FROM_SYMBOL", "FULL_SYMBOL", "FULLTEXT_SYMBOL", 
      "FUNCTION_SYMBOL", "GET_SYMBOL", "GENERAL_SYMBOL", "GENERATED_SYMBOL", 
      "GROUP_REPLICATION_SYMBOL", "GEOMETRYCOLLECTION_SYMBOL", "GEOMETRY_SYMBOL", 
      "GET_FORMAT_SYMBOL", "GLOBAL_SYMBOL", "GRANT_SYMBOL", "GRANTS_SYMBOL", 
      "GROUP_SYMBOL", "GROUP_CONCAT_SYMBOL", "HANDLER_SYMBOL", "HASH_SYMBOL", 
      "HAVING_SYMBOL", "HELP_SYMBOL", "HIGH_PRIORITY_SYMBOL", "HOST_SYMBOL", 
      "HOSTS_SYMBOL", "HOUR_MICROSECOND_SYMBOL", "HOUR_MINUTE_SYMBOL", "HOUR_SECOND_SYMBOL", 
      "HOUR_SYMBOL", "IDENTIFIED_SYMBOL", "IF_SYMBOL", "IGNORE_SYMBOL", 
      "IGNORE_SERVER_IDS_SYMBOL", "IMPORT_SYMBOL", "INDEXES_SYMBOL", "INDEX_SYMBOL", 
      "INFILE_SYMBOL", "INITIAL_SIZE_SYMBOL", "INNER_SYMBOL", "INOUT_SYMBOL", 
      "INSENSITIVE_SYMBOL", "INSERT_SYMBOL", "INSERT_METHOD_SYMBOL", "INSTANCE_SYMBOL", 
      "INSTALL_SYMBOL", "INTEGER_SYMBOL", "INTERVAL_SYMBOL", "INTO_SYMBOL", 
      "INT_SYMBOL", "INVOKER_SYMBOL", "IN_SYMBOL", "IO_AFTER_GTIDS_SYMBOL", 
      "IO_BEFORE_GTIDS_SYMBOL", "IO_THREAD_SYMBOL", "IO_SYMBOL", "IPC_SYMBOL", 
      "IS_SYMBOL", "ISOLATION_SYMBOL", "ISSUER_SYMBOL", "ITERATE_SYMBOL", 
      "JOIN_SYMBOL", "JSON_SYMBOL", "KEYS_SYMBOL", "KEY_BLOCK_SIZE_SYMBOL", 
      "KEY_SYMBOL", "KILL_SYMBOL", "LANGUAGE_SYMBOL", "LAST_SYMBOL", "LEADING_SYMBOL", 
      "LEAVES_SYMBOL", "LEAVE_SYMBOL", "LEFT_SYMBOL", "LESS_SYMBOL", "LEVEL_SYMBOL", 
      "LIKE_SYMBOL", "LIMIT_SYMBOL", "LINEAR_SYMBOL", "LINES_SYMBOL", "LINESTRING_SYMBOL", 
      "LIST_SYMBOL", "LOAD_SYMBOL", "LOCALTIME_SYMBOL", "LOCALTIMESTAMP_SYMBOL", 
      "LOCAL_SYMBOL", "LOCATOR_SYMBOL", "LOCKS_SYMBOL", "LOCK_SYMBOL", "LOGFILE_SYMBOL", 
      "LOGS_SYMBOL", "LONGBLOB_SYMBOL", "LONGTEXT_SYMBOL", "LONG_NUM_SYMBOL", 
      "LONG_SYMBOL", "LOOP_SYMBOL", "LOW_PRIORITY_SYMBOL", "MASTER_AUTO_POSITION_SYMBOL", 
      "MASTER_BIND_SYMBOL", "MASTER_CONNECT_RETRY_SYMBOL", "MASTER_DELAY_SYMBOL", 
      "MASTER_HOST_SYMBOL", "MASTER_LOG_FILE_SYMBOL", "MASTER_LOG_POS_SYMBOL", 
      "MASTER_PASSWORD_SYMBOL", "MASTER_PORT_SYMBOL", "MASTER_RETRY_COUNT_SYMBOL", 
      "MASTER_SERVER_ID_SYMBOL", "MASTER_SSL_CAPATH_SYMBOL", "MASTER_SSL_CA_SYMBOL", 
      "MASTER_SSL_CERT_SYMBOL", "MASTER_SSL_CIPHER_SYMBOL", "MASTER_SSL_CRL_SYMBOL", 
      "MASTER_SSL_CRLPATH_SYMBOL", "MASTER_SSL_KEY_SYMBOL", "MASTER_SSL_SYMBOL", 
      "MASTER_SSL_VERIFY_SERVER_CERT_SYMBOL", "MASTER_SYMBOL", "MASTER_TLS_VERSION_SYMBOL", 
      "MASTER_USER_SYMBOL", "MASTER_HEARTBEAT_PERIOD_SYMBOL", "MATCH_SYMBOL", 
      "MAX_CONNECTIONS_PER_HOUR_SYMBOL", "MAX_QUERIES_PER_HOUR_SYMBOL", 
      "MAX_ROWS_SYMBOL", "MAX_SIZE_SYMBOL", "MAX_STATEMENT_TIME_SYMBOL", 
      "MAX_SYMBOL", "MAX_UPDATES_PER_HOUR_SYMBOL", "MAX_USER_CONNECTIONS_SYMBOL", 
      "MAXVALUE_SYMBOL", "MEDIUMBLOB_SYMBOL", "MEDIUMINT_SYMBOL", "MEDIUMTEXT_SYMBOL", 
      "MEDIUM_SYMBOL", "MEMORY_SYMBOL", "MERGE_SYMBOL", "MESSAGE_TEXT_SYMBOL", 
      "MICROSECOND_SYMBOL", "MID_SYMBOL", "MIDDLEINT_SYMBOL", "MIGRATE_SYMBOL", 
      "MINUTE_MICROSECOND_SYMBOL", "MINUTE_SECOND_SYMBOL", "MINUTE_SYMBOL", 
      "MIN_ROWS_SYMBOL", "MIN_SYMBOL", "MODE_SYMBOL", "MODIFIES_SYMBOL", 
      "MODIFY_SYMBOL", "MOD_SYMBOL", "MONTH_SYMBOL", "MULTILINESTRING_SYMBOL", 
      "MULTIPOINT_SYMBOL", "MULTIPOLYGON_SYMBOL", "MUTEX_SYMBOL", "MYSQL_ERRNO_SYMBOL", 
      "NAMES_SYMBOL", "NAME_SYMBOL", "NATIONAL_SYMBOL", "NATURAL_SYMBOL", 
      "NCHAR_STRING_SYMBOL", "NCHAR_SYMBOL", "NDB_SYMBOL", "NDBCLUSTER_SYMBOL", 
      "NEG_SYMBOL", "NEVER_SYMBOL", "NEW_SYMBOL", "NEXT_SYMBOL", "NODEGROUP_SYMBOL", 
      "NONE_SYMBOL", "NONBLOCKING_SYMBOL", "NOT_SYMBOL", "NOW_SYMBOL", "NO_SYMBOL", 
      "NO_WAIT_SYMBOL", "NO_WRITE_TO_BINLOG_SYMBOL", "NULL_SYMBOL", "NUMBER_SYMBOL", 
      "NUMERIC_SYMBOL", "NVARCHAR_SYMBOL", "OFFLINE_SYMBOL", "OFFSET_SYMBOL", 
      "OLD_PASSWORD_SYMBOL", "ON_SYMBOL", "ONE_SYMBOL", "ONLINE_SYMBOL", 
      "ONLY_SYMBOL", "OPEN_SYMBOL", "OPTIMIZE_SYMBOL", "OPTIMIZER_COSTS_SYMBOL", 
      "OPTIONS_SYMBOL", "OPTION_SYMBOL", "OPTIONALLY_SYMBOL", "ORDER_SYMBOL", 
      "OR_SYMBOL", "OUTER_SYMBOL", "OUTFILE_SYMBOL", "OUT_SYMBOL", "OWNER_SYMBOL", 
      "PACK_KEYS_SYMBOL", "PAGE_SYMBOL", "PARSER_SYMBOL", "PARTIAL_SYMBOL", 
      "PARTITIONING_SYMBOL", "PARTITIONS_SYMBOL", "PARTITION_SYMBOL", "PASSWORD_SYMBOL", 
      "PHASE_SYMBOL", "PLUGINS_SYMBOL", "PLUGIN_DIR_SYMBOL", "PLUGIN_SYMBOL", 
      "POINT_SYMBOL", "POLYGON_SYMBOL", "PORT_SYMBOL", "POSITION_SYMBOL", 
      "PRECEDES_SYMBOL", "PRECISION_SYMBOL", "PREPARE_SYMBOL", "PRESERVE_SYMBOL", 
      "PREV_SYMBOL", "PRIMARY_SYMBOL", "PRIVILEGES_SYMBOL", "PROCEDURE_SYMBOL", 
      "PROCESS_SYMBOL", "PROCESSLIST_SYMBOL", "PROFILE_SYMBOL", "PROFILES_SYMBOL", 
      "PROXY_SYMBOL", "PURGE_SYMBOL", "QUARTER_SYMBOL", "QUERY_SYMBOL", 
      "QUICK_SYMBOL", "RANGE_SYMBOL", "READS_SYMBOL", "READ_ONLY_SYMBOL", 
      "READ_SYMBOL", "READ_WRITE_SYMBOL", "REAL_SYMBOL", "REBUILD_SYMBOL", 
      "RECOVER_SYMBOL", "REDOFILE_SYMBOL", "REDO_BUFFER_SIZE_SYMBOL", "REDUNDANT_SYMBOL", 
      "REFERENCES_SYMBOL", "REGEXP_SYMBOL", "RELAY_SYMBOL", "RELAYLOG_SYMBOL", 
      "RELAY_LOG_FILE_SYMBOL", "RELAY_LOG_POS_SYMBOL", "RELAY_THREAD_SYMBOL", 
      "RELEASE_SYMBOL", "RELOAD_SYMBOL", "REMOVE_SYMBOL", "RENAME_SYMBOL", 
      "REORGANIZE_SYMBOL", "REPAIR_SYMBOL", "REPEATABLE_SYMBOL", "REPEAT_SYMBOL", 
      "REPLACE_SYMBOL", "REPLICATION_SYMBOL", "REPLICATE_DO_DB_SYMBOL", 
      "REPLICATE_IGNORE_DB_SYMBOL", "REPLICATE_DO_TABLE_SYMBOL", "REPLICATE_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_WILD_DO_TABLE_SYMBOL", "REPLICATE_WILD_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_REWRITE_DB_SYMBOL", "REQUIRE_SYMBOL", "RESET_SYMBOL", "RESIGNAL_SYMBOL", 
      "RESTORE_SYMBOL", "RESTRICT_SYMBOL", "RESUME_SYMBOL", "RETURNED_SQLSTATE_SYMBOL", 
      "RETURNS_SYMBOL", "RETURN_SYMBOL", "REVERSE_SYMBOL", "REVOKE_SYMBOL", 
      "RIGHT_SYMBOL", "RLIKE_SYMBOL", "ROLLBACK_SYMBOL", "ROLLUP_SYMBOL", 
      "ROTATE_SYMBOL", "ROUTINE_SYMBOL", "ROWS_SYMBOL", "ROW_COUNT_SYMBOL", 
      "ROW_FORMAT_SYMBOL", "ROW_SYMBOL", "RTREE_SYMBOL", "SAVEPOINT_SYMBOL", 
      "SCHEDULE_SYMBOL", "SCHEMA_SYMBOL", "SCHEMA_NAME_SYMBOL", "SCHEMAS_SYMBOL", 
      "SECOND_MICROSECOND_SYMBOL", "SECOND_SYMBOL", "SECURITY_SYMBOL", "SELECT_SYMBOL", 
      "SENSITIVE_SYMBOL", "SEPARATOR_SYMBOL", "SERIALIZABLE_SYMBOL", "SERIAL_SYMBOL", 
      "SESSION_SYMBOL", "SERVER_SYMBOL", "SERVER_OPTIONS_SYMBOL", "SESSION_USER_SYMBOL", 
      "SET_SYMBOL", "SET_VAR_SYMBOL", "SHARE_SYMBOL", "SHOW_SYMBOL", "SHUTDOWN_SYMBOL", 
      "SIGNAL_SYMBOL", "SIGNED_SYMBOL", "SIMPLE_SYMBOL", "SLAVE_SYMBOL", 
      "SLOW_SYMBOL", "SMALLINT_SYMBOL", "SNAPSHOT_SYMBOL", "SOME_SYMBOL", 
      "SOCKET_SYMBOL", "SONAME_SYMBOL", "SOUNDS_SYMBOL", "SOURCE_SYMBOL", 
      "SPATIAL_SYMBOL", "SPECIFIC_SYMBOL", "SQLEXCEPTION_SYMBOL", "SQLSTATE_SYMBOL", 
      "SQLWARNING_SYMBOL", "SQL_AFTER_GTIDS_SYMBOL", "SQL_AFTER_MTS_GAPS_SYMBOL", 
      "SQL_BEFORE_GTIDS_SYMBOL", "SQL_BIG_RESULT_SYMBOL", "SQL_BUFFER_RESULT_SYMBOL", 
      "SQL_CACHE_SYMBOL", "SQL_CALC_FOUND_ROWS_SYMBOL", "SQL_NO_CACHE_SYMBOL", 
      "SQL_SMALL_RESULT_SYMBOL", "SQL_SYMBOL", "SQL_THREAD_SYMBOL", "SSL_SYMBOL", 
      "STACKED_SYMBOL", "STARTING_SYMBOL", "STARTS_SYMBOL", "START_SYMBOL", 
      "STATS_AUTO_RECALC_SYMBOL", "STATS_PERSISTENT_SYMBOL", "STATS_SAMPLE_PAGES_SYMBOL", 
      "STATUS_SYMBOL", "STDDEV_SAMP_SYMBOL", "STDDEV_SYMBOL", "STDDEV_POP_SYMBOL", 
      "STD_SYMBOL", "STOP_SYMBOL", "STORAGE_SYMBOL", "STORED_SYMBOL", "STRAIGHT_JOIN_SYMBOL", 
      "STRING_SYMBOL", "SUBCLASS_ORIGIN_SYMBOL", "SUBDATE_SYMBOL", "SUBJECT_SYMBOL", 
      "SUBPARTITIONS_SYMBOL", "SUBPARTITION_SYMBOL", "SUBSTR_SYMBOL", "SUBSTRING_SYMBOL", 
      "SUM_SYMBOL", "SUPER_SYMBOL", "SUSPEND_SYMBOL", "SWAPS_SYMBOL", "SWITCHES_SYMBOL", 
      "SYSDATE_SYMBOL", "SYSTEM_USER_SYMBOL", "TABLES_SYMBOL", "TABLESPACE_SYMBOL", 
      "TABLE_REF_PRIORITY_SYMBOL", "TABLE_SYMBOL", "TABLE_CHECKSUM_SYMBOL", 
      "TABLE_NAME_SYMBOL", "TEMPORARY_SYMBOL", "TEMPTABLE_SYMBOL", "TERMINATED_SYMBOL", 
      "TEXT_SYMBOL", "THAN_SYMBOL", "THEN_SYMBOL", "TIMESTAMP_SYMBOL", "TIMESTAMP_ADD_SYMBOL", 
      "TIMESTAMP_DIFF_SYMBOL", "TIME_SYMBOL", "TINYBLOB_SYMBOL", "TINYINT_SYMBOL", 
      "TINYTEXT_SYMBOL", "TO_SYMBOL", "TRAILING_SYMBOL", "TRANSACTION_SYMBOL", 
      "TRIGGERS_SYMBOL", "TRIGGER_SYMBOL", "TRIM_SYMBOL", "TRUE_SYMBOL", 
      "TRUNCATE_SYMBOL", "TYPES_SYMBOL", "TYPE_SYMBOL", "UDF_RETURNS_SYMBOL", 
      "UNCOMMITTED_SYMBOL", "UNDEFINED_SYMBOL", "UNDOFILE_SYMBOL", "UNDO_BUFFER_SIZE_SYMBOL", 
      "UNDO_SYMBOL", "UNICODE_SYMBOL", "UNINSTALL_SYMBOL", "UNION_SYMBOL", 
      "UNIQUE_SYMBOL", "UNKNOWN_SYMBOL", "UNLOCK_SYMBOL", "UNSIGNED_SYMBOL", 
      "UNTIL_SYMBOL", "UPDATE_SYMBOL", "UPGRADE_SYMBOL", "USAGE_SYMBOL", 
      "USER_RESOURCES_SYMBOL", "USER_SYMBOL", "USE_FRM_SYMBOL", "USE_SYMBOL", 
      "USING_SYMBOL", "UTC_DATE_SYMBOL", "UTC_TIMESTAMP_SYMBOL", "UTC_TIME_SYMBOL", 
      "VALIDATION_SYMBOL", "VALUES_SYMBOL", "VALUE_SYMBOL", "VARBINARY_SYMBOL", 
      "VARCHAR_SYMBOL", "VARCHARACTER_SYMBOL", "VARIABLES_SYMBOL", "VARIANCE_SYMBOL", 
      "VARYING_SYMBOL", "VAR_POP_SYMBOL", "VAR_SAMP_SYMBOL", "VIEW_SYMBOL", 
      "VIRTUAL_SYMBOL", "WAIT_SYMBOL", "WARNINGS_SYMBOL", "WEEK_SYMBOL", 
      "WEIGHT_STRING_SYMBOL", "WHEN_SYMBOL", "WHERE_SYMBOL", "WHILE_SYMBOL", 
      "WITH_SYMBOL", "WITHOUT_SYMBOL", "WORK_SYMBOL", "WRAPPER_SYMBOL", 
      "WRITE_SYMBOL", "X509_SYMBOL", "XA_SYMBOL", "XID_SYMBOL", "XML_SYMBOL", 
      "XOR_SYMBOL", "YEAR_MONTH_SYMBOL", "YEAR_SYMBOL", "ZEROFILL_SYMBOL", 
      "PERSIST_SYMBOL", "ROLE_SYMBOL", "ADMIN_SYMBOL", "INVISIBLE_SYMBOL", 
      "VISIBLE_SYMBOL", "EXCEPT_SYMBOL", "COMPONENT_SYMBOL", "RECURSIVE_SYMBOL", 
      "JSON_OBJECTAGG_SYMBOL", "JSON_ARRAYAGG_SYMBOL", "OF_SYMBOL", "SKIP_SYMBOL", 
      "LOCKED_SYMBOL", "NOWAIT_SYMBOL", "GROUPING_SYMBOL", "PERSIST_ONLY_SYMBOL", 
      "HISTOGRAM_SYMBOL", "BUCKETS_SYMBOL", "REMOTE_SYMBOL", "CLONE_SYMBOL", 
      "CUME_DIST_SYMBOL", "DENSE_RANK_SYMBOL", "EXCLUDE_SYMBOL", "FIRST_VALUE_SYMBOL", 
      "FOLLOWING_SYMBOL", "GROUPS_SYMBOL", "LAG_SYMBOL", "LAST_VALUE_SYMBOL", 
      "LEAD_SYMBOL", "NTH_VALUE_SYMBOL", "NTILE_SYMBOL", "NULLS_SYMBOL", 
      "OTHERS_SYMBOL", "OVER_SYMBOL", "PERCENT_RANK_SYMBOL", "PRECEDING_SYMBOL", 
      "RANK_SYMBOL", "RESPECT_SYMBOL", "ROW_NUMBER_SYMBOL", "TIES_SYMBOL", 
      "UNBOUNDED_SYMBOL", "WINDOW_SYMBOL", "EMPTY_SYMBOL", "JSON_TABLE_SYMBOL", 
      "NESTED_SYMBOL", "ORDINALITY_SYMBOL", "PATH_SYMBOL", "HISTORY_SYMBOL", 
      "REUSE_SYMBOL", "SRID_SYMBOL", "THREAD_PRIORITY_SYMBOL", "RESOURCE_SYMBOL", 
      "SYSTEM_SYMBOL", "VCPU_SYMBOL", "MASTER_PUBLIC_KEY_PATH_SYMBOL", "GET_MASTER_PUBLIC_KEY_SYMBOL", 
      "RESTART_SYMBOL", "DEFINITION_SYMBOL", "DESCRIPTION_SYMBOL", "ORGANIZATION_SYMBOL", 
      "REFERENCE_SYMBOL", "OPTIONAL_SYMBOL", "SECONDARY_SYMBOL", "SECONDARY_ENGINE_SYMBOL", 
      "SECONDARY_LOAD_SYMBOL", "SECONDARY_UNLOAD_SYMBOL", "ACTIVE_SYMBOL", 
      "INACTIVE_SYMBOL", "LATERAL_SYMBOL", "RETAIN_SYMBOL", "OLD_SYMBOL", 
      "NETWORK_NAMESPACE_SYMBOL", "ENFORCED_SYMBOL", "ARRAY_SYMBOL", "OJ_SYMBOL", 
      "MEMBER_SYMBOL", "RANDOM_SYMBOL", "MASTER_COMPRESSION_ALGORITHM_SYMBOL", 
      "MASTER_ZSTD_COMPRESSION_LEVEL_SYMBOL", "PRIVILEGE_CHECKS_USER_SYMBOL", 
      "MASTER_TLS_CIPHERSUITES_SYMBOL", "REQUIRE_ROW_FORMAT_SYMBOL", "PASSWORD_LOCK_TIME_SYMBOL", 
      "FAILED_LOGIN_ATTEMPTS_SYMBOL", "REQUIRE_TABLE_PRIMARY_KEY_CHECK_SYMBOL", 
      "STREAM_SYMBOL", "OFF_SYMBOL", "NOT2_SYMBOL", "CONCAT_PIPES_SYMBOL", 
      "INT_NUMBER", "LONG_NUMBER", "ULONGLONG_NUMBER", "EQUAL_OPERATOR", 
      "ASSIGN_OPERATOR", "NULL_SAFE_EQUAL_OPERATOR", "GREATER_OR_EQUAL_OPERATOR", 
      "GREATER_THAN_OPERATOR", "LESS_OR_EQUAL_OPERATOR", "LESS_THAN_OPERATOR", 
      "NOT_EQUAL_OPERATOR", "PLUS_OPERATOR", "MINUS_OPERATOR", "MULT_OPERATOR", 
      "DIV_OPERATOR", "MOD_OPERATOR", "LOGICAL_NOT_OPERATOR", "BITWISE_NOT_OPERATOR", 
      "SHIFT_LEFT_OPERATOR", "SHIFT_RIGHT_OPERATOR", "LOGICAL_AND_OPERATOR", 
      "BITWISE_AND_OPERATOR", "BITWISE_XOR_OPERATOR", "LOGICAL_OR_OPERATOR", 
      "BITWISE_OR_OPERATOR", "DOT_SYMBOL", "COMMA_SYMBOL", "SEMICOLON_SYMBOL", 
      "COLON_SYMBOL", "OPEN_PAR_SYMBOL", "CLOSE_PAR_SYMBOL", "OPEN_CURLY_SYMBOL", 
      "CLOSE_CURLY_SYMBOL", "UNDERLINE_SYMBOL", "JSON_SEPARATOR_SYMBOL", 
      "JSON_UNQUOTED_SEPARATOR_SYMBOL", "AT_SIGN_SYMBOL", "AT_AT_SIGN_SYMBOL", 
      "NULL2_SYMBOL", "PARAM_MARKER", "HEX_NUMBER", "BIN_NUMBER", "DECIMAL_NUMBER", 
      "FLOAT_NUMBER", "TIMESTAMPADD_SYMBOL", "TIMESTAMPDIFF_SYMBOL", "RETURNING_SYMBOL", 
      "JSON_VALUE_SYMBOL", "TLS_SYMBOL", "ATTRIBUTE_SYMBOL", "ENGINE_ATTRIBUTE_SYMBOL", 
      "SECONDARY_ENGINE_ATTRIBUTE_SYMBOL", "SOURCE_CONNECTION_AUTO_FAILOVER_SYMBOL", 
      "ZONE_SYMBOL", "GRAMMAR_SELECTOR_DERIVED_EXPR", "REPLICA_SYMBOL", 
      "REPLICAS_SYMBOL", "ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_SYMBOL", 
      "GET_SOURCE_PUBLIC_KEY_SYMBOL", "SOURCE_AUTO_POSITION_SYMBOL", "SOURCE_BIND_SYMBOL", 
      "SOURCE_COMPRESSION_ALGORITHM_SYMBOL", "SOURCE_CONNECT_RETRY_SYMBOL", 
      "SOURCE_DELAY_SYMBOL", "SOURCE_HEARTBEAT_PERIOD_SYMBOL", "SOURCE_HOST_SYMBOL", 
      "SOURCE_LOG_FILE_SYMBOL", "SOURCE_LOG_POS_SYMBOL", "SOURCE_PASSWORD_SYMBOL", 
      "SOURCE_PORT_SYMBOL", "SOURCE_PUBLIC_KEY_PATH_SYMBOL", "SOURCE_RETRY_COUNT_SYMBOL", 
      "SOURCE_SSL_SYMBOL", "SOURCE_SSL_CA_SYMBOL", "SOURCE_SSL_CAPATH_SYMBOL", 
      "SOURCE_SSL_CERT_SYMBOL", "SOURCE_SSL_CIPHER_SYMBOL", "SOURCE_SSL_CRL_SYMBOL", 
      "SOURCE_SSL_CRLPATH_SYMBOL", "SOURCE_SSL_KEY_SYMBOL", "SOURCE_SSL_VERIFY_SERVER_CERT_SYMBOL", 
      "SOURCE_TLS_CIPHERSUITES_SYMBOL", "SOURCE_TLS_VERSION_SYMBOL", "SOURCE_USER_SYMBOL", 
      "SOURCE_ZSTD_COMPRESSION_LEVEL_SYMBOL", "ST_COLLECT_SYMBOL", "KEYRING_SYMBOL", 
      "AUTHENTICATION_SYMBOL", "FACTOR_SYMBOL", "FINISH_SYMBOL", "INITIATE_SYMBOL", 
      "REGISTRATION_SYMBOL", "UNREGISTER_SYMBOL", "INITIAL_SYMBOL", "CHALLENGE_RESPONSE_SYMBOL", 
      "GTID_ONLY_SYMBOL", "WHITESPACE", "INVALID_INPUT", "UNDERSCORE_CHARSET", 
      "IDENTIFIER", "NCHAR_TEXT", "BACK_TICK_QUOTED_ID", "DOUBLE_QUOTED_TEXT", 
      "SINGLE_QUOTED_TEXT", "VERSION_COMMENT_START", "MYSQL_COMMENT_START", 
      "VERSION_COMMENT_END", "BLOCK_COMMENT", "INVALID_BLOCK_COMMENT", "POUND_COMMENT", 
      "DASHDASH_COMMENT", "SIMPLE_IDENTIFIER", "NOT_EQUAL2_OPERATOR"
    }
  );
  static const int32_t serializedATNSegment[] = {
  	4,1,859,9238,2,0,7,0,2,1,7,1,2,2,7,2,2,3,7,3,2,4,7,4,2,5,7,5,2,6,7,6,
  	2,7,7,7,2,8,7,8,2,9,7,9,2,10,7,10,2,11,7,11,2,12,7,12,2,13,7,13,2,14,
  	7,14,2,15,7,15,2,16,7,16,2,17,7,17,2,18,7,18,2,19,7,19,2,20,7,20,2,21,
  	7,21,2,22,7,22,2,23,7,23,2,24,7,24,2,25,7,25,2,26,7,26,2,27,7,27,2,28,
  	7,28,2,29,7,29,2,30,7,30,2,31,7,31,2,32,7,32,2,33,7,33,2,34,7,34,2,35,
  	7,35,2,36,7,36,2,37,7,37,2,38,7,38,2,39,7,39,2,40,7,40,2,41,7,41,2,42,
  	7,42,2,43,7,43,2,44,7,44,2,45,7,45,2,46,7,46,2,47,7,47,2,48,7,48,2,49,
  	7,49,2,50,7,50,2,51,7,51,2,52,7,52,2,53,7,53,2,54,7,54,2,55,7,55,2,56,
  	7,56,2,57,7,57,2,58,7,58,2,59,7,59,2,60,7,60,2,61,7,61,2,62,7,62,2,63,
  	7,63,2,64,7,64,2,65,7,65,2,66,7,66,2,67,7,67,2,68,7,68,2,69,7,69,2,70,
  	7,70,2,71,7,71,2,72,7,72,2,73,7,73,2,74,7,74,2,75,7,75,2,76,7,76,2,77,
  	7,77,2,78,7,78,2,79,7,79,2,80,7,80,2,81,7,81,2,82,7,82,2,83,7,83,2,84,
  	7,84,2,85,7,85,2,86,7,86,2,87,7,87,2,88,7,88,2,89,7,89,2,90,7,90,2,91,
  	7,91,2,92,7,92,2,93,7,93,2,94,7,94,2,95,7,95,2,96,7,96,2,97,7,97,2,98,
  	7,98,2,99,7,99,2,100,7,100,2,101,7,101,2,102,7,102,2,103,7,103,2,104,
  	7,104,2,105,7,105,2,106,7,106,2,107,7,107,2,108,7,108,2,109,7,109,2,110,
  	7,110,2,111,7,111,2,112,7,112,2,113,7,113,2,114,7,114,2,115,7,115,2,116,
  	7,116,2,117,7,117,2,118,7,118,2,119,7,119,2,120,7,120,2,121,7,121,2,122,
  	7,122,2,123,7,123,2,124,7,124,2,125,7,125,2,126,7,126,2,127,7,127,2,128,
  	7,128,2,129,7,129,2,130,7,130,2,131,7,131,2,132,7,132,2,133,7,133,2,134,
  	7,134,2,135,7,135,2,136,7,136,2,137,7,137,2,138,7,138,2,139,7,139,2,140,
  	7,140,2,141,7,141,2,142,7,142,2,143,7,143,2,144,7,144,2,145,7,145,2,146,
  	7,146,2,147,7,147,2,148,7,148,2,149,7,149,2,150,7,150,2,151,7,151,2,152,
  	7,152,2,153,7,153,2,154,7,154,2,155,7,155,2,156,7,156,2,157,7,157,2,158,
  	7,158,2,159,7,159,2,160,7,160,2,161,7,161,2,162,7,162,2,163,7,163,2,164,
  	7,164,2,165,7,165,2,166,7,166,2,167,7,167,2,168,7,168,2,169,7,169,2,170,
  	7,170,2,171,7,171,2,172,7,172,2,173,7,173,2,174,7,174,2,175,7,175,2,176,
  	7,176,2,177,7,177,2,178,7,178,2,179,7,179,2,180,7,180,2,181,7,181,2,182,
  	7,182,2,183,7,183,2,184,7,184,2,185,7,185,2,186,7,186,2,187,7,187,2,188,
  	7,188,2,189,7,189,2,190,7,190,2,191,7,191,2,192,7,192,2,193,7,193,2,194,
  	7,194,2,195,7,195,2,196,7,196,2,197,7,197,2,198,7,198,2,199,7,199,2,200,
  	7,200,2,201,7,201,2,202,7,202,2,203,7,203,2,204,7,204,2,205,7,205,2,206,
  	7,206,2,207,7,207,2,208,7,208,2,209,7,209,2,210,7,210,2,211,7,211,2,212,
  	7,212,2,213,7,213,2,214,7,214,2,215,7,215,2,216,7,216,2,217,7,217,2,218,
  	7,218,2,219,7,219,2,220,7,220,2,221,7,221,2,222,7,222,2,223,7,223,2,224,
  	7,224,2,225,7,225,2,226,7,226,2,227,7,227,2,228,7,228,2,229,7,229,2,230,
  	7,230,2,231,7,231,2,232,7,232,2,233,7,233,2,234,7,234,2,235,7,235,2,236,
  	7,236,2,237,7,237,2,238,7,238,2,239,7,239,2,240,7,240,2,241,7,241,2,242,
  	7,242,2,243,7,243,2,244,7,244,2,245,7,245,2,246,7,246,2,247,7,247,2,248,
  	7,248,2,249,7,249,2,250,7,250,2,251,7,251,2,252,7,252,2,253,7,253,2,254,
  	7,254,2,255,7,255,2,256,7,256,2,257,7,257,2,258,7,258,2,259,7,259,2,260,
  	7,260,2,261,7,261,2,262,7,262,2,263,7,263,2,264,7,264,2,265,7,265,2,266,
  	7,266,2,267,7,267,2,268,7,268,2,269,7,269,2,270,7,270,2,271,7,271,2,272,
  	7,272,2,273,7,273,2,274,7,274,2,275,7,275,2,276,7,276,2,277,7,277,2,278,
  	7,278,2,279,7,279,2,280,7,280,2,281,7,281,2,282,7,282,2,283,7,283,2,284,
  	7,284,2,285,7,285,2,286,7,286,2,287,7,287,2,288,7,288,2,289,7,289,2,290,
  	7,290,2,291,7,291,2,292,7,292,2,293,7,293,2,294,7,294,2,295,7,295,2,296,
  	7,296,2,297,7,297,2,298,7,298,2,299,7,299,2,300,7,300,2,301,7,301,2,302,
  	7,302,2,303,7,303,2,304,7,304,2,305,7,305,2,306,7,306,2,307,7,307,2,308,
  	7,308,2,309,7,309,2,310,7,310,2,311,7,311,2,312,7,312,2,313,7,313,2,314,
  	7,314,2,315,7,315,2,316,7,316,2,317,7,317,2,318,7,318,2,319,7,319,2,320,
  	7,320,2,321,7,321,2,322,7,322,2,323,7,323,2,324,7,324,2,325,7,325,2,326,
  	7,326,2,327,7,327,2,328,7,328,2,329,7,329,2,330,7,330,2,331,7,331,2,332,
  	7,332,2,333,7,333,2,334,7,334,2,335,7,335,2,336,7,336,2,337,7,337,2,338,
  	7,338,2,339,7,339,2,340,7,340,2,341,7,341,2,342,7,342,2,343,7,343,2,344,
  	7,344,2,345,7,345,2,346,7,346,2,347,7,347,2,348,7,348,2,349,7,349,2,350,
  	7,350,2,351,7,351,2,352,7,352,2,353,7,353,2,354,7,354,2,355,7,355,2,356,
  	7,356,2,357,7,357,2,358,7,358,2,359,7,359,2,360,7,360,2,361,7,361,2,362,
  	7,362,2,363,7,363,2,364,7,364,2,365,7,365,2,366,7,366,2,367,7,367,2,368,
  	7,368,2,369,7,369,2,370,7,370,2,371,7,371,2,372,7,372,2,373,7,373,2,374,
  	7,374,2,375,7,375,2,376,7,376,2,377,7,377,2,378,7,378,2,379,7,379,2,380,
  	7,380,2,381,7,381,2,382,7,382,2,383,7,383,2,384,7,384,2,385,7,385,2,386,
  	7,386,2,387,7,387,2,388,7,388,2,389,7,389,2,390,7,390,2,391,7,391,2,392,
  	7,392,2,393,7,393,2,394,7,394,2,395,7,395,2,396,7,396,2,397,7,397,2,398,
  	7,398,2,399,7,399,2,400,7,400,2,401,7,401,2,402,7,402,2,403,7,403,2,404,
  	7,404,2,405,7,405,2,406,7,406,2,407,7,407,2,408,7,408,2,409,7,409,2,410,
  	7,410,2,411,7,411,2,412,7,412,2,413,7,413,2,414,7,414,2,415,7,415,2,416,
  	7,416,2,417,7,417,2,418,7,418,2,419,7,419,2,420,7,420,2,421,7,421,2,422,
  	7,422,2,423,7,423,2,424,7,424,2,425,7,425,2,426,7,426,2,427,7,427,2,428,
  	7,428,2,429,7,429,2,430,7,430,2,431,7,431,2,432,7,432,2,433,7,433,2,434,
  	7,434,2,435,7,435,2,436,7,436,2,437,7,437,2,438,7,438,2,439,7,439,2,440,
  	7,440,2,441,7,441,2,442,7,442,2,443,7,443,2,444,7,444,2,445,7,445,2,446,
  	7,446,2,447,7,447,2,448,7,448,2,449,7,449,2,450,7,450,2,451,7,451,2,452,
  	7,452,2,453,7,453,2,454,7,454,2,455,7,455,2,456,7,456,2,457,7,457,2,458,
  	7,458,2,459,7,459,2,460,7,460,2,461,7,461,2,462,7,462,2,463,7,463,2,464,
  	7,464,2,465,7,465,2,466,7,466,2,467,7,467,2,468,7,468,2,469,7,469,2,470,
  	7,470,2,471,7,471,2,472,7,472,2,473,7,473,2,474,7,474,2,475,7,475,2,476,
  	7,476,2,477,7,477,2,478,7,478,2,479,7,479,2,480,7,480,2,481,7,481,2,482,
  	7,482,2,483,7,483,2,484,7,484,2,485,7,485,2,486,7,486,2,487,7,487,2,488,
  	7,488,2,489,7,489,2,490,7,490,2,491,7,491,2,492,7,492,2,493,7,493,2,494,
  	7,494,2,495,7,495,2,496,7,496,2,497,7,497,2,498,7,498,2,499,7,499,2,500,
  	7,500,2,501,7,501,2,502,7,502,2,503,7,503,2,504,7,504,2,505,7,505,2,506,
  	7,506,2,507,7,507,2,508,7,508,2,509,7,509,2,510,7,510,2,511,7,511,2,512,
  	7,512,2,513,7,513,2,514,7,514,2,515,7,515,2,516,7,516,2,517,7,517,2,518,
  	7,518,2,519,7,519,2,520,7,520,2,521,7,521,2,522,7,522,2,523,7,523,2,524,
  	7,524,2,525,7,525,2,526,7,526,2,527,7,527,2,528,7,528,2,529,7,529,2,530,
  	7,530,2,531,7,531,2,532,7,532,2,533,7,533,2,534,7,534,2,535,7,535,2,536,
  	7,536,2,537,7,537,2,538,7,538,2,539,7,539,2,540,7,540,2,541,7,541,2,542,
  	7,542,2,543,7,543,2,544,7,544,2,545,7,545,2,546,7,546,2,547,7,547,2,548,
  	7,548,2,549,7,549,2,550,7,550,2,551,7,551,2,552,7,552,2,553,7,553,2,554,
  	7,554,2,555,7,555,2,556,7,556,2,557,7,557,2,558,7,558,2,559,7,559,2,560,
  	7,560,2,561,7,561,2,562,7,562,2,563,7,563,2,564,7,564,2,565,7,565,2,566,
  	7,566,2,567,7,567,2,568,7,568,2,569,7,569,2,570,7,570,2,571,7,571,2,572,
  	7,572,2,573,7,573,2,574,7,574,2,575,7,575,2,576,7,576,2,577,7,577,2,578,
  	7,578,2,579,7,579,2,580,7,580,2,581,7,581,2,582,7,582,2,583,7,583,2,584,
  	7,584,2,585,7,585,2,586,7,586,2,587,7,587,2,588,7,588,2,589,7,589,2,590,
  	7,590,2,591,7,591,2,592,7,592,2,593,7,593,2,594,7,594,2,595,7,595,2,596,
  	7,596,2,597,7,597,2,598,7,598,2,599,7,599,2,600,7,600,2,601,7,601,2,602,
  	7,602,2,603,7,603,2,604,7,604,2,605,7,605,2,606,7,606,2,607,7,607,2,608,
  	7,608,2,609,7,609,2,610,7,610,2,611,7,611,2,612,7,612,2,613,7,613,2,614,
  	7,614,2,615,7,615,2,616,7,616,2,617,7,617,2,618,7,618,2,619,7,619,2,620,
  	7,620,2,621,7,621,2,622,7,622,2,623,7,623,2,624,7,624,2,625,7,625,2,626,
  	7,626,2,627,7,627,2,628,7,628,2,629,7,629,2,630,7,630,2,631,7,631,2,632,
  	7,632,2,633,7,633,2,634,7,634,2,635,7,635,2,636,7,636,2,637,7,637,2,638,
  	7,638,2,639,7,639,2,640,7,640,2,641,7,641,2,642,7,642,2,643,7,643,2,644,
  	7,644,2,645,7,645,2,646,7,646,2,647,7,647,2,648,7,648,2,649,7,649,2,650,
  	7,650,2,651,7,651,2,652,7,652,2,653,7,653,2,654,7,654,2,655,7,655,2,656,
  	7,656,2,657,7,657,2,658,7,658,2,659,7,659,2,660,7,660,2,661,7,661,2,662,
  	7,662,2,663,7,663,2,664,7,664,2,665,7,665,2,666,7,666,2,667,7,667,2,668,
  	7,668,2,669,7,669,2,670,7,670,2,671,7,671,2,672,7,672,2,673,7,673,2,674,
  	7,674,2,675,7,675,2,676,7,676,2,677,7,677,2,678,7,678,2,679,7,679,2,680,
  	7,680,2,681,7,681,2,682,7,682,2,683,7,683,2,684,7,684,2,685,7,685,2,686,
  	7,686,2,687,7,687,2,688,7,688,2,689,7,689,2,690,7,690,2,691,7,691,2,692,
  	7,692,2,693,7,693,2,694,7,694,2,695,7,695,2,696,7,696,2,697,7,697,2,698,
  	7,698,2,699,7,699,2,700,7,700,2,701,7,701,2,702,7,702,2,703,7,703,2,704,
  	7,704,2,705,7,705,2,706,7,706,2,707,7,707,2,708,7,708,2,709,7,709,2,710,
  	7,710,2,711,7,711,2,712,7,712,2,713,7,713,2,714,7,714,2,715,7,715,2,716,
  	7,716,2,717,7,717,2,718,7,718,2,719,7,719,1,0,1,0,3,0,1443,8,0,1,0,3,
  	0,1446,8,0,3,0,1448,8,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1529,
  	8,1,1,2,1,2,1,2,1,2,1,2,1,2,3,2,1537,8,2,1,2,1,2,1,2,3,2,1542,8,2,1,2,
  	1,2,1,2,1,2,1,2,1,2,1,2,1,2,3,2,1552,8,2,1,3,1,3,1,3,4,3,1557,8,3,11,
  	3,12,3,1558,1,3,1,3,1,3,1,3,1,3,3,3,1566,8,3,1,4,1,4,1,4,1,4,3,4,1572,
  	8,4,1,4,3,4,1575,8,4,1,5,3,5,1578,8,5,1,5,1,5,1,5,1,5,1,5,3,5,1585,8,
  	5,1,5,1,5,1,5,3,5,1590,8,5,1,5,3,5,1593,8,5,1,5,1,5,1,5,3,5,1598,8,5,
  	1,5,1,5,1,5,1,5,3,5,1604,8,5,3,5,1606,8,5,1,5,1,5,3,5,1610,8,5,1,5,1,
  	5,3,5,1614,8,5,1,6,1,6,1,6,1,6,1,6,1,6,1,6,3,6,1623,8,6,1,7,1,7,3,7,1627,
  	8,7,1,7,5,7,1630,8,7,10,7,12,7,1633,9,7,1,8,1,8,1,8,3,8,1638,8,8,1,9,
  	1,9,1,9,1,9,1,10,3,10,1645,8,10,1,10,1,10,1,10,3,10,1650,8,10,1,11,1,
  	11,1,11,3,11,1655,8,11,1,11,1,11,1,11,1,11,1,11,3,11,1662,8,11,1,11,3,
  	11,1665,8,11,1,12,1,12,1,12,1,12,3,12,1671,8,12,1,12,3,12,1674,8,12,1,
  	13,1,13,1,13,5,13,1679,8,13,10,13,12,13,1682,9,13,1,14,1,14,1,14,1,14,
  	1,14,1,14,1,14,3,14,1691,8,14,1,15,1,15,1,15,3,15,1696,8,15,1,15,1,15,
  	1,15,3,15,1701,8,15,1,15,1,15,1,15,1,15,1,15,1,15,3,15,1709,8,15,1,15,
  	1,15,1,15,1,15,3,15,1715,8,15,1,15,1,15,3,15,1719,8,15,1,15,1,15,1,15,
  	3,15,1724,8,15,1,15,1,15,1,15,1,15,1,15,5,15,1731,8,15,10,15,12,15,1734,
  	9,15,1,15,1,15,1,15,3,15,1739,8,15,1,15,1,15,5,15,1743,8,15,10,15,12,
  	15,1746,9,15,1,15,1,15,1,15,3,15,1751,8,15,1,15,1,15,1,15,1,15,1,15,1,
  	15,1,15,3,15,1760,8,15,1,15,1,15,1,15,1,15,3,15,1766,8,15,1,15,1,15,1,
  	15,1,15,1,15,1,15,1,15,3,15,1775,8,15,1,15,1,15,1,15,1,15,1,15,1,15,1,
  	15,1,15,1,15,1,15,1,15,1,15,3,15,1789,8,15,1,16,1,16,3,16,1793,8,16,1,
  	16,1,16,1,16,1,16,3,16,1799,8,16,5,16,1801,8,16,10,16,12,16,1804,9,16,
  	1,17,1,17,1,17,3,17,1809,8,17,1,18,1,18,3,18,1813,8,18,1,18,1,18,1,18,
  	3,18,1818,8,18,1,18,3,18,1821,8,18,1,18,1,18,1,18,1,18,3,18,1827,8,18,
  	1,18,1,18,1,18,1,18,3,18,1833,8,18,1,18,1,18,1,18,1,18,3,18,1839,8,18,
  	1,18,1,18,3,18,1843,8,18,1,18,1,18,1,18,3,18,1848,8,18,1,18,1,18,3,18,
  	1852,8,18,1,18,1,18,3,18,1856,8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1872,8,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,3,18,1880,8,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1888,8,18,
  	1,18,1,18,1,18,1,18,1,18,3,18,1895,8,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1924,8,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1939,8,18,1,18,3,18,
  	1942,8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1951,8,18,1,19,1,19,
  	1,19,3,19,1956,8,19,1,20,1,20,1,21,1,21,3,21,1962,8,21,1,21,1,21,1,21,
  	3,21,1967,8,21,5,21,1969,8,21,10,21,12,21,1972,9,21,1,22,1,22,3,22,1976,
  	8,22,1,22,1,22,3,22,1980,8,22,1,23,1,23,3,23,1984,8,23,1,23,1,23,3,23,
  	1988,8,23,1,24,1,24,3,24,1992,8,24,1,24,1,24,3,24,1996,8,24,3,24,1998,
  	8,24,1,25,1,25,1,25,1,25,1,26,1,26,1,26,1,27,1,27,3,27,2009,8,27,1,28,
  	1,28,1,28,1,28,1,28,1,28,3,28,2017,8,28,1,28,1,28,1,28,1,28,1,28,3,28,
  	2024,8,28,1,29,1,29,1,29,1,29,1,29,1,29,3,29,2032,8,29,1,30,1,30,3,30,
  	2036,8,30,1,30,5,30,2039,8,30,10,30,12,30,2042,9,30,1,31,1,31,1,32,1,
  	32,3,32,2048,8,32,1,32,5,32,2051,8,32,10,32,12,32,2054,9,32,1,33,1,33,
  	3,33,2058,8,33,1,33,1,33,1,33,1,33,1,33,1,33,1,33,1,33,3,33,2068,8,33,
  	1,34,1,34,3,34,2072,8,34,1,34,1,34,1,34,3,34,2077,8,34,1,35,3,35,2080,
  	8,35,1,35,3,35,2083,8,35,1,35,3,35,2086,8,35,1,35,1,35,1,35,1,35,1,36,
  	3,36,2093,8,36,1,36,1,36,1,36,1,37,1,37,3,37,2100,8,37,1,38,1,38,3,38,
  	2104,8,38,1,38,1,38,1,38,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,
  	1,39,1,39,1,39,1,39,1,39,3,39,2123,8,39,1,39,1,39,1,39,1,39,3,39,2129,
  	8,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,3,39,2139,8,39,1,39,3,39,
  	2142,8,39,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,
  	1,40,1,40,1,40,1,40,1,40,1,40,1,40,3,40,2163,8,40,1,41,1,41,3,41,2167,
  	8,41,1,41,1,41,5,41,2171,8,41,10,41,12,41,2174,9,41,1,42,1,42,1,42,1,
  	42,3,42,2180,8,42,1,43,3,43,2183,8,43,1,43,1,43,3,43,2187,8,43,1,43,1,
  	43,1,43,1,43,1,43,3,43,2194,8,43,1,43,3,43,2197,8,43,1,43,3,43,2200,8,
  	43,1,43,3,43,2203,8,43,1,43,1,43,1,43,1,43,1,43,1,43,1,43,3,43,2212,8,
  	43,1,44,1,44,1,44,5,44,2217,8,44,10,44,12,44,2220,9,44,1,45,1,45,3,45,
  	2224,8,45,1,46,3,46,2227,8,46,1,46,3,46,2230,8,46,1,46,1,46,1,47,1,47,
  	3,47,2236,8,47,1,48,1,48,1,48,1,48,3,48,2242,8,48,1,48,3,48,2245,8,48,
  	1,48,1,48,1,49,3,49,2250,8,49,1,49,1,49,1,49,3,49,2255,8,49,1,49,1,49,
  	1,49,1,49,1,49,5,49,2262,8,49,10,49,12,49,2265,9,49,3,49,2267,8,49,1,
  	49,1,49,5,49,2271,8,49,10,49,12,49,2274,9,49,1,49,1,49,1,50,3,50,2279,
  	8,50,1,50,1,50,1,50,3,50,2284,8,50,1,50,1,50,1,50,1,50,1,50,5,50,2291,
  	8,50,10,50,12,50,2294,9,50,3,50,2296,8,50,1,50,1,50,1,50,1,50,5,50,2302,
  	8,50,10,50,12,50,2305,9,50,1,50,1,50,1,51,3,51,2310,8,51,1,51,1,51,1,
  	51,3,51,2315,8,51,1,51,1,51,1,51,1,51,1,51,1,51,1,52,1,52,3,52,2325,8,
  	52,1,52,3,52,2328,8,52,1,53,4,53,2331,8,53,11,53,12,53,2332,1,54,1,54,
  	1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,1,54,
  	1,54,3,54,2352,8,54,1,55,3,55,2355,8,55,1,55,3,55,2358,8,55,1,55,1,55,
  	1,55,1,55,3,55,2364,8,55,1,55,3,55,2367,8,55,3,55,2369,8,55,1,55,1,55,
  	5,55,2373,8,55,10,55,12,55,2376,9,55,1,55,1,55,1,55,1,55,1,55,5,55,2383,
  	8,55,10,55,12,55,2386,9,55,1,55,1,55,1,55,1,55,1,55,5,55,2393,8,55,10,
  	55,12,55,2396,9,55,3,55,2398,8,55,1,55,3,55,2401,8,55,1,56,1,56,3,56,
  	2405,8,56,1,56,1,56,1,56,1,56,1,56,1,56,3,56,2413,8,56,1,57,1,57,1,57,
  	1,57,1,58,1,58,1,58,1,58,1,58,1,58,1,58,3,58,2426,8,58,1,59,1,59,3,59,
  	2430,8,59,1,59,5,59,2433,8,59,10,59,12,59,2436,9,59,1,60,1,60,1,60,1,
  	60,1,60,1,60,3,60,2444,8,60,1,61,1,61,1,61,1,61,1,61,1,61,1,61,1,61,1,
  	62,1,62,1,62,1,62,1,62,5,62,2459,8,62,10,62,12,62,2462,9,62,1,62,1,62,
  	1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,1,63,
  	3,63,2480,8,63,1,64,1,64,1,64,1,64,1,64,1,64,1,64,3,64,2489,8,64,1,64,
  	3,64,2492,8,64,1,65,1,65,1,65,1,65,1,65,1,65,3,65,2500,8,65,1,66,1,66,
  	1,66,3,66,2505,8,66,1,66,1,66,3,66,2509,8,66,1,67,1,67,1,67,1,68,1,68,
  	3,68,2516,8,68,1,68,5,68,2519,8,68,10,68,12,68,2522,9,68,1,69,1,69,1,
  	69,1,69,1,69,1,69,1,69,1,69,1,69,1,69,1,69,1,69,3,69,2536,8,69,1,70,1,
  	70,3,70,2540,8,70,1,70,1,70,1,71,1,71,3,71,2546,8,71,1,71,1,71,1,72,1,
  	72,3,72,2552,8,72,1,72,1,72,1,73,1,73,3,73,2558,8,73,1,73,1,73,1,74,1,
  	74,3,74,2564,8,74,1,74,1,74,1,75,1,75,3,75,2570,8,75,1,75,1,75,1,76,3,
  	76,2575,8,76,1,76,1,76,3,76,2579,8,76,1,76,1,76,1,77,1,77,1,78,1,78,3,
  	78,2587,8,78,1,78,1,78,1,79,1,79,3,79,2593,8,79,1,79,1,79,1,80,1,80,3,
  	80,2599,8,80,1,80,1,80,1,81,1,81,3,81,2605,8,81,1,81,1,81,1,82,3,82,2610,
  	8,82,1,82,3,82,2613,8,82,1,82,3,82,2616,8,82,1,82,1,82,1,82,1,82,1,83,
  	1,83,1,83,3,83,2625,8,83,1,83,3,83,2628,8,83,1,84,1,84,1,84,1,84,1,85,
  	1,85,1,85,1,85,1,86,3,86,2639,8,86,1,86,1,86,1,86,3,86,2644,8,86,1,86,
  	1,86,1,86,1,86,1,86,1,86,1,86,1,86,1,86,3,86,2655,8,86,1,86,1,86,1,87,
  	1,87,1,87,1,88,3,88,2663,8,88,1,88,1,88,3,88,2667,8,88,1,88,1,88,1,88,
  	1,88,1,88,1,88,1,88,3,88,2676,8,88,1,88,3,88,2679,8,88,1,88,1,88,1,88,
  	1,88,3,88,2685,8,88,3,88,2687,8,88,1,88,1,88,3,88,2691,8,88,1,88,1,88,
  	1,88,1,89,1,89,3,89,2698,8,89,1,89,1,89,1,90,1,90,1,90,1,90,1,90,1,90,
  	1,90,5,90,2709,8,90,10,90,12,90,2712,9,90,1,90,1,90,1,90,1,90,3,90,2718,
  	8,90,1,90,1,90,5,90,2722,8,90,10,90,12,90,2725,9,90,3,90,2727,8,90,1,
  	91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,91,1,
  	91,3,91,2744,8,91,1,92,1,92,1,92,1,92,1,92,1,92,1,92,1,92,1,92,1,92,1,
  	92,1,92,1,92,1,92,1,92,1,92,1,92,1,92,3,92,2764,8,92,1,93,1,93,3,93,2768,
  	8,93,1,93,1,93,1,94,1,94,3,94,2774,8,94,1,94,1,94,1,95,1,95,3,95,2780,
  	8,95,1,95,1,95,1,96,1,96,3,96,2786,8,96,1,96,1,96,1,97,3,97,2791,8,97,
  	1,97,1,97,1,97,1,97,1,97,3,97,2798,8,97,1,98,1,98,1,98,1,98,1,98,3,98,
  	2805,8,98,1,98,5,98,2808,8,98,10,98,12,98,2811,9,98,3,98,2813,8,98,1,
  	99,1,99,3,99,2817,8,99,1,100,1,100,3,100,2821,8,100,1,100,1,100,1,101,
  	3,101,2826,8,101,1,101,1,101,3,101,2830,8,101,1,101,1,101,3,101,2834,
  	8,101,1,102,1,102,1,102,1,102,3,102,2840,8,102,1,102,5,102,2843,8,102,
  	10,102,12,102,2846,9,102,3,102,2848,8,102,1,103,1,103,3,103,2852,8,103,
  	1,103,1,103,1,104,1,104,3,104,2858,8,104,1,104,1,104,3,104,2862,8,104,
  	1,105,1,105,3,105,2866,8,105,1,105,1,105,1,106,1,106,1,106,1,106,3,106,
  	2874,8,106,1,106,1,106,1,107,1,107,1,107,1,107,3,107,2882,8,107,1,108,
  	1,108,1,108,1,108,1,108,5,108,2889,8,108,10,108,12,108,2892,9,108,1,109,
  	1,109,1,109,1,109,1,110,1,110,3,110,2900,8,110,1,110,1,110,1,111,1,111,
  	1,111,1,111,1,111,1,112,1,112,1,112,1,112,3,112,2913,8,112,1,112,3,112,
  	2916,8,112,1,113,1,113,3,113,2920,8,113,1,113,1,113,5,113,2924,8,113,
  	10,113,12,113,2927,9,113,1,113,1,113,1,113,1,113,1,113,3,113,2934,8,113,
  	1,113,1,113,1,113,3,113,2939,8,113,1,113,3,113,2942,8,113,1,113,3,113,
  	2945,8,113,1,113,3,113,2948,8,113,1,113,3,113,2951,8,113,3,113,2953,8,
  	113,1,113,1,113,1,113,1,113,3,113,2959,8,113,3,113,2961,8,113,1,114,1,
  	114,1,114,1,114,1,114,1,115,1,115,1,116,1,116,1,116,1,116,1,116,3,116,
  	2975,8,116,1,117,1,117,1,117,1,117,3,117,2981,8,117,1,117,1,117,1,117,
  	1,117,1,117,3,117,2988,8,117,1,117,3,117,2991,8,117,3,117,2993,8,117,
  	3,117,2995,8,117,1,118,1,118,1,118,1,118,1,118,1,118,1,118,1,118,3,118,
  	3005,8,118,3,118,3007,8,118,1,119,1,119,3,119,3011,8,119,1,119,3,119,
  	3014,8,119,1,119,3,119,3017,8,119,1,119,1,119,3,119,3021,8,119,1,119,
  	1,119,1,119,3,119,3026,8,119,1,119,1,119,1,119,1,119,3,119,3032,8,119,
  	1,119,3,119,3035,8,119,1,119,3,119,3038,8,119,1,120,1,120,1,121,1,121,
  	3,121,3044,8,121,1,121,3,121,3047,8,121,1,121,1,121,1,122,1,122,1,122,
  	5,122,3054,8,122,10,122,12,122,3057,9,122,1,123,1,123,1,123,1,124,1,124,
  	1,124,3,124,3065,8,124,1,124,1,124,3,124,3069,8,124,1,125,1,125,3,125,
  	3073,8,125,1,125,1,125,1,125,1,125,3,125,3079,8,125,1,125,5,125,3082,
  	8,125,10,125,12,125,3085,9,125,1,126,1,126,3,126,3089,8,126,1,126,1,126,
  	1,126,3,126,3094,8,126,5,126,3096,8,126,10,126,12,126,3099,9,126,1,127,
  	1,127,1,127,3,127,3104,8,127,1,128,1,128,1,128,1,128,1,128,1,128,1,129,
  	1,129,1,129,3,129,3115,8,129,1,129,3,129,3118,8,129,1,129,1,129,1,129,
  	3,129,3123,8,129,1,129,1,129,1,129,1,129,3,129,3129,8,129,1,129,3,129,
  	3132,8,129,1,129,3,129,3135,8,129,1,129,3,129,3138,8,129,1,129,3,129,
  	3141,8,129,1,129,1,129,1,130,1,130,1,131,1,131,1,131,1,131,1,131,1,132,
  	1,132,1,132,3,132,3155,8,132,1,132,3,132,3158,8,132,1,132,1,132,3,132,
  	3162,8,132,1,133,1,133,3,133,3166,8,133,1,133,1,133,1,134,1,134,3,134,
  	3172,8,134,1,134,1,134,1,134,3,134,3177,8,134,5,134,3179,8,134,10,134,
  	12,134,3182,9,134,1,135,1,135,3,135,3186,8,135,1,135,3,135,3189,8,135,
  	1,135,1,135,3,135,3193,8,135,1,135,1,135,1,135,1,135,3,135,3199,8,135,
  	1,136,1,136,3,136,3203,8,136,1,136,1,136,3,136,3207,8,136,1,137,1,137,
  	1,137,1,137,1,137,1,137,1,137,3,137,3216,8,137,1,137,1,137,1,137,1,137,
  	3,137,3222,8,137,1,138,1,138,3,138,3226,8,138,1,138,1,138,3,138,3230,
  	8,138,1,138,3,138,3233,8,138,1,138,1,138,3,138,3237,8,138,1,138,3,138,
  	3240,8,138,3,138,3242,8,138,1,138,1,138,3,138,3246,8,138,1,139,1,139,
  	1,139,1,139,3,139,3252,8,139,1,139,1,139,3,139,3256,8,139,3,139,3258,
  	8,139,1,139,1,139,3,139,3262,8,139,1,139,1,139,3,139,3266,8,139,5,139,
  	3268,8,139,10,139,12,139,3271,9,139,1,140,1,140,1,140,1,140,3,140,3277,
  	8,140,3,140,3279,8,140,1,140,1,140,1,141,1,141,1,141,1,141,1,141,3,141,
  	3288,8,141,1,142,1,142,5,142,3292,8,142,10,142,12,142,3295,9,142,1,142,
  	1,142,3,142,3299,8,142,1,142,3,142,3302,8,142,1,142,3,142,3305,8,142,
  	1,142,3,142,3308,8,142,1,142,3,142,3311,8,142,1,142,1,142,3,142,3315,
  	8,142,1,143,1,143,1,144,1,144,1,145,1,145,1,145,1,146,1,146,1,146,1,147,
  	1,147,1,147,3,147,3330,8,147,1,148,1,148,3,148,3334,8,148,1,149,1,149,
  	1,149,1,149,3,149,3340,8,149,1,149,3,149,3343,8,149,1,149,3,149,3346,
  	8,149,1,149,1,149,1,149,1,149,3,149,3352,8,149,1,149,1,149,1,149,3,149,
  	3357,8,149,5,149,3359,8,149,10,149,12,149,3362,9,149,3,149,3364,8,149,
  	1,150,1,150,1,150,1,150,1,150,1,150,3,150,3372,8,150,3,150,3374,8,150,
  	1,150,1,150,1,151,1,151,1,151,1,152,1,152,1,152,1,152,5,152,3385,8,152,
  	10,152,12,152,3388,9,152,1,153,1,153,1,153,1,153,1,154,1,154,1,154,1,
  	154,1,155,3,155,3399,8,155,1,155,1,155,1,155,3,155,3404,8,155,1,155,3,
  	155,3407,8,155,1,155,3,155,3410,8,155,1,156,1,156,1,156,3,156,3415,8,
  	156,1,157,1,157,1,158,1,158,3,158,3421,8,158,1,159,1,159,1,159,1,159,
  	1,159,1,159,1,159,1,159,1,159,1,159,1,159,1,159,1,159,1,159,3,159,3437,
  	8,159,1,160,1,160,1,160,1,160,1,160,1,161,1,161,1,161,1,161,1,161,1,161,
  	1,161,1,161,1,161,1,161,1,161,1,161,1,161,3,161,3457,8,161,1,162,1,162,
  	1,162,1,162,1,162,1,162,1,162,3,162,3466,8,162,1,163,1,163,3,163,3470,
  	8,163,1,163,1,163,1,163,5,163,3475,8,163,10,163,12,163,3478,9,163,1,164,
  	1,164,3,164,3482,8,164,1,164,1,164,1,164,1,165,1,165,1,165,1,165,3,165,
  	3491,8,165,1,166,1,166,1,166,1,166,1,166,3,166,3498,8,166,1,167,1,167,
  	1,167,1,167,1,168,1,168,1,169,1,169,1,169,3,169,3509,8,169,1,170,1,170,
  	1,170,5,170,3514,8,170,10,170,12,170,3517,9,170,1,171,1,171,1,171,1,171,
  	5,171,3523,8,171,10,171,12,171,3526,9,171,1,172,1,172,1,172,1,173,1,173,
  	1,173,3,173,3534,8,173,1,173,1,173,1,174,1,174,1,174,1,174,1,174,1,174,
  	1,174,1,174,3,174,3546,8,174,1,175,4,175,3549,8,175,11,175,12,175,3550,
  	1,176,1,176,1,176,1,176,1,176,3,176,3558,8,176,1,176,1,176,3,176,3562,
  	8,176,1,176,1,176,1,176,1,176,3,176,3568,8,176,1,177,1,177,1,177,3,177,
  	3573,8,177,1,178,1,178,1,178,3,178,3578,8,178,1,179,1,179,3,179,3582,
  	8,179,1,179,1,179,5,179,3586,8,179,10,179,12,179,3589,9,179,1,180,1,180,
  	1,180,3,180,3594,8,180,3,180,3596,8,180,1,181,3,181,3599,8,181,1,181,
  	1,181,3,181,3603,8,181,1,182,1,182,1,182,1,183,1,183,1,183,1,183,1,183,
  	3,183,3613,8,183,1,183,1,183,1,183,3,183,3618,8,183,1,183,5,183,3621,
  	8,183,10,183,12,183,3624,9,183,1,184,1,184,5,184,3628,8,184,10,184,12,
  	184,3631,9,184,1,185,1,185,1,185,1,185,1,185,1,185,3,185,3639,8,185,1,
  	185,1,185,1,185,1,185,1,185,1,185,3,185,3647,8,185,1,185,1,185,1,185,
  	3,185,3652,8,185,1,186,1,186,3,186,3656,8,186,1,186,1,186,1,186,1,186,
  	3,186,3662,8,186,1,186,3,186,3665,8,186,1,187,3,187,3668,8,187,1,187,
  	1,187,3,187,3672,8,187,1,188,1,188,3,188,3676,8,188,1,188,1,188,1,189,
  	1,189,1,189,1,189,1,189,1,189,3,189,3686,8,189,1,190,1,190,3,190,3690,
  	8,190,1,190,3,190,3693,8,190,1,190,3,190,3696,8,190,1,191,1,191,1,191,
  	3,191,3701,8,191,1,191,1,191,1,192,1,192,3,192,3707,8,192,1,192,1,192,
  	3,192,3711,8,192,1,192,1,192,1,192,1,192,3,192,3717,8,192,1,192,3,192,
  	3720,8,192,3,192,3722,8,192,1,193,1,193,1,193,3,193,3727,8,193,1,193,
  	1,193,1,194,1,194,1,194,1,194,1,194,1,194,1,194,1,194,3,194,3739,8,194,
  	1,195,1,195,1,195,1,195,1,195,5,195,3746,8,195,10,195,12,195,3749,9,195,
  	1,195,1,195,1,196,1,196,1,196,1,196,1,196,1,196,1,196,1,196,3,196,3761,
  	8,196,1,196,3,196,3764,8,196,1,196,1,196,1,196,3,196,3769,8,196,1,196,
  	1,196,1,196,1,196,1,196,3,196,3776,8,196,1,197,1,197,3,197,3780,8,197,
  	1,197,3,197,3783,8,197,1,198,1,198,1,198,1,198,3,198,3789,8,198,1,199,
  	1,199,1,199,1,199,1,200,1,200,1,200,1,200,1,201,1,201,1,201,1,201,3,201,
  	3803,8,201,1,202,1,202,1,203,1,203,1,203,3,203,3810,8,203,1,203,1,203,
  	1,204,1,204,1,204,5,204,3817,8,204,10,204,12,204,3820,9,204,1,205,1,205,
  	1,205,3,205,3825,8,205,1,205,1,205,1,205,1,205,1,205,1,205,1,205,3,205,
  	3834,8,205,1,205,1,205,3,205,3838,8,205,1,205,1,205,3,205,3842,8,205,
  	1,206,1,206,1,207,1,207,1,208,1,208,1,208,1,208,3,208,3852,8,208,3,208,
  	3854,8,208,1,209,1,209,1,209,1,209,1,209,1,209,3,209,3862,8,209,1,210,
  	1,210,1,210,5,210,3867,8,210,10,210,12,210,3870,9,210,1,211,1,211,3,211,
  	3874,8,211,1,212,1,212,3,212,3878,8,212,1,212,1,212,3,212,3882,8,212,
  	1,212,3,212,3885,8,212,1,212,1,212,1,212,1,212,3,212,3891,8,212,1,212,
  	3,212,3894,8,212,1,212,3,212,3897,8,212,1,213,1,213,1,213,1,213,3,213,
  	3903,8,213,1,214,1,214,1,214,5,214,3908,8,214,10,214,12,214,3911,9,214,
  	1,214,1,214,3,214,3915,8,214,1,214,1,214,3,214,3919,8,214,1,214,3,214,
  	3922,8,214,1,214,3,214,3925,8,214,1,214,3,214,3928,8,214,3,214,3930,8,
  	214,1,215,1,215,3,215,3934,8,215,1,216,1,216,1,216,1,216,1,216,3,216,
  	3941,8,216,1,217,1,217,1,217,1,217,3,217,3947,8,217,1,217,1,217,3,217,
  	3951,8,217,1,217,1,217,1,217,3,217,3956,8,217,1,217,3,217,3959,8,217,
  	1,217,3,217,3962,8,217,1,217,3,217,3965,8,217,3,217,3967,8,217,1,217,
  	1,217,1,217,3,217,3972,8,217,1,218,1,218,1,218,1,218,1,218,5,218,3979,
  	8,218,10,218,12,218,3982,9,218,1,218,1,218,1,218,1,218,1,218,1,218,1,
  	218,1,218,1,218,1,218,3,218,3994,8,218,3,218,3996,8,218,1,219,1,219,3,
  	219,4000,8,219,1,219,1,219,1,220,1,220,3,220,4006,8,220,1,220,3,220,4009,
  	8,220,1,220,3,220,4012,8,220,1,221,1,221,1,221,1,221,3,221,4018,8,221,
  	1,221,1,221,1,221,1,221,1,221,3,221,4025,8,221,3,221,4027,8,221,1,221,
  	1,221,1,221,1,221,1,221,1,221,3,221,4035,8,221,1,221,1,221,1,221,1,221,
  	3,221,4041,8,221,1,222,1,222,1,222,3,222,4046,8,222,1,222,3,222,4049,
  	8,222,1,223,1,223,1,223,1,223,1,223,3,223,4056,8,223,3,223,4058,8,223,
  	1,224,1,224,1,224,1,224,1,224,1,224,1,224,3,224,4067,8,224,1,224,1,224,
  	1,224,1,224,1,224,5,224,4074,8,224,10,224,12,224,4077,9,224,1,224,1,224,
  	1,224,1,224,3,224,4083,8,224,1,224,3,224,4086,8,224,1,224,1,224,1,224,
  	1,224,1,224,1,224,3,224,4094,8,224,1,225,1,225,3,225,4098,8,225,1,225,
  	1,225,1,225,1,225,1,225,3,225,4105,8,225,1,225,3,225,4108,8,225,3,225,
  	4110,8,225,1,226,1,226,1,226,1,226,1,226,1,226,3,226,4118,8,226,1,227,
  	1,227,1,227,1,227,3,227,4124,8,227,1,227,1,227,1,227,1,228,1,228,1,228,
  	1,228,3,228,4133,8,228,1,229,1,229,1,229,1,229,1,229,3,229,4140,8,229,
  	1,230,1,230,1,230,5,230,4145,8,230,10,230,12,230,4148,9,230,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,1,231,
  	1,231,1,231,1,231,1,231,1,231,1,231,3,231,4278,8,231,1,232,1,232,1,233,
  	1,233,1,234,1,234,1,235,1,235,1,236,1,236,1,237,1,237,1,238,1,238,1,239,
  	1,239,1,240,1,240,1,241,1,241,1,242,1,242,1,243,1,243,1,244,1,244,1,245,
  	1,245,1,246,1,246,1,247,1,247,1,248,1,248,1,249,1,249,1,250,1,250,1,251,
  	1,251,1,252,1,252,1,253,1,253,1,254,1,254,1,255,1,255,1,256,1,256,1,257,
  	1,257,3,257,4332,8,257,1,258,1,258,1,259,1,259,1,259,3,259,4339,8,259,
  	1,260,1,260,3,260,4343,8,260,1,261,1,261,1,261,1,261,1,261,1,261,1,261,
  	1,261,1,261,1,261,1,261,1,261,1,261,1,261,3,261,4359,8,261,1,262,1,262,
  	1,263,1,263,1,264,1,264,1,264,1,264,5,264,4369,8,264,10,264,12,264,4372,
  	9,264,3,264,4374,8,264,1,264,1,264,1,265,1,265,1,265,1,265,1,265,1,265,
  	5,265,4384,8,265,10,265,12,265,4387,9,265,1,265,1,265,3,265,4391,8,265,
  	1,266,1,266,1,266,1,266,3,266,4397,8,266,1,266,1,266,1,266,1,266,1,266,
  	3,266,4404,8,266,1,266,1,266,1,266,1,266,1,266,3,266,4411,8,266,1,266,
  	1,266,1,266,1,266,1,266,3,266,4418,8,266,1,266,1,266,1,266,1,266,1,266,
  	3,266,4425,8,266,1,266,1,266,1,266,1,266,1,266,3,266,4432,8,266,1,266,
  	1,266,1,266,1,266,1,266,3,266,4439,8,266,1,266,3,266,4442,8,266,1,267,
  	1,267,1,267,5,267,4447,8,267,10,267,12,267,4450,9,267,1,268,1,268,1,268,
  	5,268,4455,8,268,10,268,12,268,4458,9,268,1,269,1,269,1,269,5,269,4463,
  	8,269,10,269,12,269,4466,9,269,1,270,1,270,1,271,1,271,1,271,5,271,4473,
  	8,271,10,271,12,271,4476,9,271,1,272,1,272,1,272,3,272,4481,8,272,1,272,
  	1,272,3,272,4485,8,272,1,272,3,272,4488,8,272,1,272,3,272,4491,8,272,
  	1,272,3,272,4494,8,272,1,272,3,272,4497,8,272,1,272,3,272,4500,8,272,
  	1,273,1,273,1,273,3,273,4505,8,273,1,273,3,273,4508,8,273,1,274,1,274,
  	1,274,1,274,1,274,3,274,4515,8,274,1,274,1,274,5,274,4519,8,274,10,274,
  	12,274,4522,9,274,1,275,1,275,1,275,1,275,1,276,1,276,1,276,1,276,1,277,
  	1,277,1,277,1,277,1,278,1,278,1,278,1,278,1,279,1,279,1,279,5,279,4543,
  	8,279,10,279,12,279,4546,9,279,1,280,1,280,1,281,1,281,1,281,1,281,3,
  	281,4554,8,281,1,281,1,281,3,281,4558,8,281,1,282,1,282,1,282,5,282,4563,
  	8,282,10,282,12,282,4566,9,282,1,283,1,283,1,283,3,283,4571,8,283,1,284,
  	1,284,1,284,1,284,1,285,1,285,1,285,1,285,1,286,1,286,1,286,1,286,1,287,
  	1,287,1,288,1,288,1,288,1,288,1,288,3,288,4592,8,288,1,288,1,288,1,288,
  	1,288,3,288,4598,8,288,1,289,1,289,1,289,1,289,3,289,4604,8,289,1,290,
  	1,290,1,290,5,290,4609,8,290,10,290,12,290,4612,9,290,1,291,1,291,1,291,
  	1,291,1,291,3,291,4619,8,291,1,291,1,291,1,291,1,291,3,291,4625,8,291,
  	1,291,1,291,1,291,1,291,1,291,1,291,1,291,1,291,1,291,1,291,3,291,4637,
  	8,291,3,291,4639,8,291,1,292,1,292,1,292,1,292,3,292,4645,8,292,1,292,
  	1,292,3,292,4649,8,292,3,292,4651,8,292,1,293,1,293,3,293,4655,8,293,
  	1,293,1,293,1,294,1,294,1,294,1,294,1,294,1,294,1,294,1,294,3,294,4667,
  	8,294,1,295,1,295,1,295,1,295,3,295,4673,8,295,1,295,1,295,1,295,1,295,
  	3,295,4679,8,295,1,295,1,295,1,295,1,295,1,295,1,295,3,295,4687,8,295,
  	1,295,1,295,3,295,4691,8,295,1,295,1,295,3,295,4695,8,295,1,295,1,295,
  	1,295,1,295,3,295,4701,8,295,3,295,4703,8,295,1,295,1,295,1,295,1,295,
  	1,295,1,295,1,295,1,295,1,295,1,295,1,295,3,295,4716,8,295,1,295,1,295,
  	3,295,4720,8,295,3,295,4722,8,295,3,295,4724,8,295,1,296,1,296,1,296,
  	5,296,4729,8,296,10,296,12,296,4732,9,296,1,297,1,297,1,297,1,297,1,297,
  	1,297,1,297,1,297,3,297,4742,8,297,1,297,3,297,4745,8,297,3,297,4747,
  	8,297,1,297,1,297,3,297,4751,8,297,1,297,1,297,1,297,3,297,4756,8,297,
  	3,297,4758,8,297,1,297,1,297,1,297,3,297,4763,8,297,1,297,1,297,1,297,
  	1,297,3,297,4769,8,297,1,297,3,297,4772,8,297,3,297,4774,8,297,1,297,
  	1,297,3,297,4778,8,297,1,297,3,297,4781,8,297,1,297,1,297,1,297,1,297,
  	1,297,1,297,1,297,1,297,3,297,4791,8,297,1,297,1,297,1,297,1,297,1,297,
  	1,297,1,297,1,297,3,297,4801,8,297,1,297,1,297,1,297,1,297,1,297,3,297,
  	4808,8,297,3,297,4810,8,297,3,297,4812,8,297,1,298,1,298,1,298,1,298,
  	1,298,1,298,3,298,4820,8,298,1,298,1,298,3,298,4824,8,298,1,298,1,298,
  	1,298,1,298,3,298,4830,8,298,1,298,3,298,4833,8,298,3,298,4835,8,298,
  	1,298,1,298,1,298,1,298,1,298,1,298,1,298,1,298,3,298,4845,8,298,1,298,
  	1,298,3,298,4849,8,298,1,298,1,298,1,298,1,298,3,298,4855,8,298,1,298,
  	1,298,1,298,1,298,1,298,3,298,4862,8,298,3,298,4864,8,298,1,298,1,298,
  	1,298,3,298,4869,8,298,3,298,4871,8,298,1,299,1,299,1,299,1,300,1,300,
  	1,300,1,300,3,300,4880,8,300,1,300,1,300,1,300,1,300,1,301,1,301,3,301,
  	4888,8,301,1,301,3,301,4891,8,301,1,301,5,301,4894,8,301,10,301,12,301,
  	4897,9,301,1,301,1,301,3,301,4901,8,301,1,301,3,301,4904,8,301,1,302,
  	1,302,1,302,1,302,3,302,4910,8,302,1,303,1,303,1,303,1,303,3,303,4916,
  	8,303,1,303,3,303,4919,8,303,1,304,1,304,1,304,3,304,4924,8,304,1,305,
  	1,305,1,305,1,305,1,305,1,305,1,305,1,305,1,305,4,305,4935,8,305,11,305,
  	12,305,4936,1,306,1,306,1,306,1,306,1,306,1,306,1,306,1,306,1,306,1,306,
  	3,306,4949,8,306,1,306,1,306,1,306,3,306,4954,8,306,1,306,1,306,1,306,
  	1,306,1,306,1,306,3,306,4962,8,306,1,306,1,306,1,306,1,306,3,306,4968,
  	8,306,3,306,4970,8,306,1,306,1,306,1,306,1,306,1,306,1,306,1,306,3,306,
  	4979,8,306,3,306,4981,8,306,1,307,1,307,1,307,1,307,3,307,4987,8,307,
  	1,307,1,307,1,308,1,308,1,308,1,308,1,308,1,308,1,308,1,308,3,308,4999,
  	8,308,1,308,1,308,1,308,3,308,5004,8,308,3,308,5006,8,308,1,308,1,308,
  	3,308,5010,8,308,1,308,1,308,1,308,1,308,3,308,5016,8,308,1,308,3,308,
  	5019,8,308,1,308,3,308,5022,8,308,1,308,1,308,1,308,1,308,1,308,1,308,
  	1,308,1,308,3,308,5032,8,308,3,308,5034,8,308,1,309,1,309,1,309,1,309,
  	3,309,5040,8,309,1,310,1,310,1,310,4,310,5045,8,310,11,310,12,310,5046,
  	1,310,1,310,1,310,1,310,3,310,5053,8,310,1,311,1,311,1,311,1,312,1,312,
  	1,312,1,312,1,312,3,312,5063,8,312,1,312,1,312,3,312,5067,8,312,1,313,
  	1,313,1,313,3,313,5072,8,313,1,314,1,314,1,314,1,315,1,315,1,315,1,315,
  	1,315,1,315,1,315,1,315,1,315,1,315,5,315,5087,8,315,10,315,12,315,5090,
  	9,315,1,316,1,316,1,316,1,316,1,316,1,316,1,316,1,316,1,316,1,316,1,316,
  	1,316,1,316,3,316,5105,8,316,1,316,1,316,1,316,3,316,5110,8,316,1,316,
  	1,316,1,316,1,316,1,316,1,316,3,316,5118,8,316,1,316,1,316,1,316,1,316,
  	1,316,1,316,3,316,5126,8,316,1,317,1,317,1,317,3,317,5131,8,317,1,317,
  	1,317,1,317,1,317,3,317,5137,8,317,1,317,3,317,5140,8,317,3,317,5142,
  	8,317,1,318,1,318,1,319,1,319,1,319,5,319,5149,8,319,10,319,12,319,5152,
  	9,319,1,320,1,320,1,320,3,320,5157,8,320,1,320,1,320,1,320,1,320,3,320,
  	5163,8,320,3,320,5165,8,320,1,320,1,320,3,320,5169,8,320,1,320,1,320,
  	1,320,1,320,1,320,1,320,1,320,1,320,1,320,3,320,5180,8,320,1,320,1,320,
  	1,320,1,320,1,320,3,320,5187,8,320,1,320,1,320,1,320,1,320,3,320,5193,
  	8,320,1,320,1,320,1,320,3,320,5198,8,320,1,321,1,321,1,321,3,321,5203,
  	8,321,1,321,1,321,1,321,3,321,5208,8,321,1,321,1,321,1,321,1,321,1,321,
  	1,321,3,321,5216,8,321,1,322,1,322,3,322,5220,8,322,1,322,5,322,5223,
  	8,322,10,322,12,322,5226,9,322,1,323,1,323,1,323,1,323,1,323,1,323,3,
  	323,5234,8,323,1,324,1,324,1,324,1,324,1,324,1,324,1,324,1,324,1,324,
  	1,324,3,324,5246,8,324,1,325,1,325,1,325,1,325,1,325,1,325,1,325,1,325,
  	1,325,1,325,1,325,1,325,3,325,5260,8,325,1,325,1,325,1,325,1,325,1,325,
  	1,325,1,325,3,325,5269,8,325,3,325,5271,8,325,1,326,1,326,1,326,5,326,
  	5276,8,326,10,326,12,326,5279,9,326,1,327,1,327,1,327,1,327,3,327,5285,
  	8,327,3,327,5287,8,327,1,328,1,328,3,328,5291,8,328,1,328,1,328,1,328,
  	1,328,3,328,5297,8,328,1,328,1,328,1,328,1,328,5,328,5303,8,328,10,328,
  	12,328,5306,9,328,1,328,1,328,1,328,1,328,3,328,5312,8,328,1,328,1,328,
  	3,328,5316,8,328,1,328,1,328,1,328,1,328,3,328,5322,8,328,1,328,1,328,
  	1,328,5,328,5327,8,328,10,328,12,328,5330,9,328,3,328,5332,8,328,1,329,
  	1,329,1,329,1,329,1,329,1,329,1,329,3,329,5341,8,329,1,329,1,329,1,329,
  	1,329,3,329,5347,8,329,1,330,1,330,1,330,3,330,5352,8,330,1,331,1,331,
  	1,332,1,332,1,332,1,332,1,332,1,332,1,332,1,332,1,332,1,332,1,332,1,332,
  	1,332,1,332,1,332,1,332,1,332,5,332,5373,8,332,10,332,12,332,5376,9,332,
  	3,332,5378,8,332,1,333,1,333,1,333,1,334,1,334,1,334,1,334,1,334,1,334,
  	1,334,1,334,1,334,1,334,1,334,3,334,5394,8,334,1,334,1,334,1,334,3,334,
  	5399,8,334,1,334,3,334,5402,8,334,1,334,1,334,3,334,5406,8,334,1,334,
  	3,334,5409,8,334,1,334,1,334,1,334,1,334,1,334,1,334,1,334,1,334,1,334,
  	1,334,1,334,1,334,3,334,5423,8,334,1,334,1,334,1,334,1,334,3,334,5429,
  	8,334,1,334,1,334,1,334,3,334,5434,8,334,1,334,3,334,5437,8,334,3,334,
  	5439,8,334,1,335,1,335,3,335,5443,8,335,1,335,1,335,1,335,3,335,5448,
  	8,335,3,335,5450,8,335,1,336,1,336,1,336,1,337,1,337,1,337,1,337,1,337,
  	1,337,1,337,3,337,5462,8,337,1,338,1,338,5,338,5466,8,338,10,338,12,338,
  	5469,9,338,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,
  	1,339,1,339,3,339,5483,8,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,
  	1,339,1,339,1,339,3,339,5495,8,339,1,339,1,339,3,339,5499,8,339,3,339,
  	5501,8,339,1,340,1,340,1,340,1,340,1,340,1,340,3,340,5509,8,340,1,341,
  	1,341,1,341,1,341,1,341,3,341,5516,8,341,1,342,1,342,1,342,1,342,1,343,
  	1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,3,343,5531,8,343,1,344,
  	1,344,1,344,3,344,5536,8,344,1,345,1,345,3,345,5540,8,345,1,345,1,345,
  	3,345,5544,8,345,1,345,3,345,5547,8,345,1,346,1,346,3,346,5551,8,346,
  	1,346,1,346,3,346,5555,8,346,1,346,3,346,5558,8,346,1,347,1,347,1,347,
  	3,347,5563,8,347,1,347,3,347,5566,8,347,1,348,1,348,1,348,1,348,3,348,
  	5572,8,348,1,348,3,348,5575,8,348,1,349,1,349,1,349,1,349,3,349,5581,
  	8,349,1,349,3,349,5584,8,349,1,350,1,350,1,350,1,351,1,351,1,351,1,351,
  	1,351,1,352,1,352,1,352,1,352,1,352,1,353,1,353,1,353,1,353,1,353,1,354,
  	1,354,3,354,5606,8,354,1,354,1,354,1,354,1,354,3,354,5612,8,354,1,354,
  	3,354,5615,8,354,1,355,1,355,1,355,1,355,1,356,1,356,1,356,1,356,3,356,
  	5625,8,356,1,357,1,357,1,357,1,357,1,357,3,357,5632,8,357,1,357,1,357,
  	3,357,5636,8,357,1,357,3,357,5639,8,357,1,357,3,357,5642,8,357,1,358,
  	1,358,1,358,1,358,1,358,3,358,5649,8,358,1,358,1,358,3,358,5653,8,358,
  	1,358,3,358,5656,8,358,1,358,3,358,5659,8,358,1,359,1,359,1,359,3,359,
  	5664,8,359,1,359,1,359,1,359,1,359,3,359,5670,8,359,1,359,3,359,5673,
  	8,359,1,360,1,360,3,360,5677,8,360,1,360,1,360,1,361,1,361,1,361,1,361,
  	1,361,1,361,1,361,1,362,1,362,1,362,1,362,1,362,1,362,1,362,1,363,1,363,
  	1,363,3,363,5698,8,363,1,364,1,364,1,364,3,364,5703,8,364,1,365,1,365,
  	1,365,1,366,1,366,1,366,3,366,5711,8,366,1,366,1,366,1,366,3,366,5716,
  	8,366,1,366,3,366,5719,8,366,1,367,1,367,3,367,5723,8,367,1,367,1,367,
  	3,367,5727,8,367,1,368,1,368,3,368,5731,8,368,1,368,1,368,1,369,1,369,
  	3,369,5737,8,369,1,369,1,369,3,369,5741,8,369,1,370,1,370,1,370,3,370,
  	5746,8,370,1,371,1,371,1,371,3,371,5751,8,371,1,372,1,372,1,372,1,373,
  	1,373,1,373,1,373,1,373,1,373,3,373,5762,8,373,3,373,5764,8,373,1,374,
  	1,374,1,374,1,374,3,374,5770,8,374,1,374,1,374,1,375,1,375,1,375,1,375,
  	1,375,1,376,1,376,1,376,1,376,1,376,1,377,1,377,1,377,1,377,1,378,1,378,
  	1,378,1,378,1,378,3,378,5793,8,378,1,378,3,378,5796,8,378,1,379,1,379,
  	1,379,1,379,1,379,1,380,1,380,1,380,1,380,1,380,1,381,1,381,1,381,1,381,
  	1,381,1,382,1,382,1,382,1,382,1,382,3,382,5818,8,382,1,383,1,383,1,383,
  	1,383,1,383,3,383,5825,8,383,1,384,1,384,1,384,1,384,1,384,1,384,1,385,
  	1,385,1,385,1,385,1,385,1,385,1,386,1,386,1,386,1,386,1,386,1,387,1,387,
  	1,387,1,387,1,387,1,388,1,388,1,388,1,388,3,388,5853,8,388,3,388,5855,
  	8,388,1,389,1,389,3,389,5859,8,389,1,390,1,390,1,391,1,391,1,391,1,392,
  	1,392,1,392,5,392,5869,8,392,10,392,12,392,5872,9,392,1,393,1,393,1,393,
  	1,393,1,393,1,393,1,393,3,393,5881,8,393,1,394,1,394,1,394,1,394,1,394,
  	1,394,1,394,1,394,3,394,5891,8,394,1,394,1,394,3,394,5895,8,394,1,394,
  	1,394,1,394,1,394,5,394,5901,8,394,10,394,12,394,5904,9,394,3,394,5906,
  	8,394,1,394,1,394,3,394,5910,8,394,1,394,1,394,1,394,1,394,1,394,1,394,
  	1,394,1,394,3,394,5920,8,394,1,395,1,395,3,395,5924,8,395,1,396,1,396,
  	1,396,5,396,5929,8,396,10,396,12,396,5932,9,396,1,397,1,397,3,397,5936,
  	8,397,1,398,1,398,1,398,1,398,1,398,1,398,3,398,5944,8,398,1,399,1,399,
  	1,399,3,399,5949,8,399,1,399,1,399,1,400,1,400,3,400,5955,8,400,1,401,
  	1,401,1,401,5,401,5960,8,401,10,401,12,401,5963,9,401,1,402,1,402,3,402,
  	5967,8,402,1,402,1,402,1,402,1,402,3,402,5973,8,402,1,402,1,402,1,402,
  	1,402,1,402,3,402,5980,8,402,1,403,1,403,1,404,1,404,1,404,1,404,1,404,
  	1,404,3,404,5990,8,404,3,404,5992,8,404,1,405,1,405,1,405,1,405,1,405,
  	3,405,5999,8,405,1,406,1,406,1,406,3,406,6004,8,406,1,406,1,406,3,406,
  	6008,8,406,1,406,3,406,6011,8,406,1,407,1,407,1,407,5,407,6016,8,407,
  	10,407,12,407,6019,9,407,1,408,1,408,3,408,6023,8,408,1,408,1,408,3,408,
  	6027,8,408,1,409,1,409,1,409,1,409,1,409,1,410,1,410,1,410,1,410,3,410,
  	6038,8,410,1,411,1,411,1,411,1,411,1,411,1,411,3,411,6046,8,411,1,411,
  	1,411,3,411,6050,8,411,1,411,3,411,6053,8,411,1,411,3,411,6056,8,411,
  	1,412,1,412,3,412,6060,8,412,1,412,1,412,3,412,6064,8,412,1,412,5,412,
  	6067,8,412,10,412,12,412,6070,9,412,1,413,1,413,1,413,3,413,6075,8,413,
  	1,414,1,414,3,414,6079,8,414,1,414,1,414,1,415,1,415,1,416,1,416,1,416,
  	1,416,1,416,3,416,6090,8,416,1,416,3,416,6093,8,416,1,416,3,416,6096,
  	8,416,1,416,3,416,6099,8,416,1,417,1,417,1,417,1,417,1,417,1,417,3,417,
  	6107,8,417,1,418,1,418,3,418,6111,8,418,1,418,5,418,6114,8,418,10,418,
  	12,418,6117,9,418,1,419,1,419,1,419,1,419,1,419,3,419,6124,8,419,1,420,
  	1,420,1,420,1,420,1,420,1,420,3,420,6132,8,420,1,421,1,421,1,421,1,421,
  	3,421,6138,8,421,1,422,1,422,1,422,1,422,1,422,1,422,1,422,1,422,1,422,
  	1,422,1,422,1,422,1,422,1,422,1,422,3,422,6155,8,422,1,422,1,422,1,423,
  	1,423,1,423,1,423,1,423,1,423,1,423,1,423,3,423,6167,8,423,1,424,1,424,
  	1,424,1,425,1,425,1,425,1,426,1,426,1,427,1,427,1,427,1,427,3,427,6181,
  	8,427,1,427,3,427,6184,8,427,1,427,1,427,3,427,6188,8,427,1,427,1,427,
  	1,427,1,427,1,427,1,427,1,427,1,427,1,427,5,427,6199,8,427,10,427,12,
  	427,6202,9,427,1,428,1,428,1,428,1,428,1,428,1,428,3,428,6210,8,428,1,
  	428,1,428,1,428,1,428,1,428,1,428,1,428,1,428,1,428,1,428,5,428,6222,
  	8,428,10,428,12,428,6225,9,428,1,429,1,429,1,430,1,430,3,430,6231,8,430,
  	1,430,1,430,1,430,1,430,3,430,6237,8,430,1,430,1,430,1,430,1,430,3,430,
  	6243,8,430,1,431,1,431,1,431,1,431,1,431,1,431,3,431,6251,8,431,1,431,
  	1,431,1,431,1,431,1,431,1,431,1,431,1,431,1,431,3,431,6262,8,431,1,431,
  	1,431,3,431,6266,8,431,1,432,1,432,1,432,1,432,1,432,1,432,1,432,1,432,
  	1,432,1,432,1,432,1,432,1,432,1,432,1,432,1,432,1,432,1,432,1,432,1,432,
  	1,432,1,432,1,432,1,432,1,432,1,432,1,432,5,432,6295,8,432,10,432,12,
  	432,6298,9,432,1,433,1,433,1,433,3,433,6303,8,433,1,433,1,433,1,433,1,
  	433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,
  	1,433,1,433,3,433,6322,8,433,1,433,1,433,1,433,1,433,1,433,3,433,6329,
  	8,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,
  	1,433,3,433,6343,8,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,
  	1,433,3,433,6354,8,433,1,433,1,433,1,433,3,433,6359,8,433,1,433,1,433,
  	1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,3,433,6371,8,433,1,433,
  	1,433,1,433,1,433,1,433,1,433,1,433,1,433,3,433,6381,8,433,1,433,1,433,
  	1,433,4,433,6386,8,433,11,433,12,433,6387,1,433,3,433,6391,8,433,1,433,
  	1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,
  	1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,1,433,
  	1,433,1,433,1,433,1,433,1,433,1,433,1,433,3,433,6425,8,433,1,433,1,433,
  	1,433,1,433,1,433,1,433,5,433,6433,8,433,10,433,12,433,6436,9,433,1,434,
  	1,434,1,434,1,435,1,435,1,435,1,435,1,435,1,435,3,435,6447,8,435,1,436,
  	1,436,1,436,3,436,6452,8,436,1,436,1,436,1,436,1,436,3,436,6458,8,436,
  	1,436,1,436,1,436,1,436,1,436,1,436,3,436,6466,8,436,1,436,1,436,1,436,
  	1,436,1,436,1,436,3,436,6474,8,436,1,436,1,436,1,436,3,436,6479,8,436,
  	1,436,1,436,1,436,3,436,6484,8,436,1,436,1,436,1,436,1,436,3,436,6490,
  	8,436,1,436,1,436,1,436,3,436,6495,8,436,1,436,1,436,1,436,3,436,6500,
  	8,436,1,436,1,436,1,436,1,436,3,436,6506,8,436,1,436,1,436,1,436,1,436,
  	1,436,1,436,3,436,6514,8,436,1,436,1,436,1,436,1,436,1,436,1,436,1,436,
  	3,436,6523,8,436,1,436,1,436,1,436,3,436,6528,8,436,1,436,1,436,3,436,
  	6532,8,436,1,436,1,436,3,436,6536,8,436,1,436,1,436,1,436,3,436,6541,
  	8,436,3,436,6543,8,436,1,437,1,437,1,437,1,437,1,437,1,438,1,438,1,438,
  	1,438,1,438,1,438,1,438,1,438,1,438,1,438,1,438,1,438,3,438,6562,8,438,
  	1,438,1,438,1,438,1,438,1,438,1,438,3,438,6570,8,438,1,438,1,438,3,438,
  	6574,8,438,1,438,1,438,1,438,1,438,1,438,3,438,6581,8,438,1,438,1,438,
  	1,438,1,438,1,438,1,438,1,438,1,438,1,438,1,438,3,438,6593,8,438,1,438,
  	3,438,6596,8,438,1,438,1,438,3,438,6600,8,438,1,439,1,439,1,439,3,439,
  	6605,8,439,1,440,1,440,1,440,1,440,3,440,6611,8,440,1,440,1,440,3,440,
  	6615,8,440,1,440,1,440,3,440,6619,8,440,1,441,1,441,3,441,6623,8,441,
  	1,442,1,442,1,442,3,442,6628,8,442,1,443,1,443,1,443,1,444,1,444,1,444,
  	1,444,1,444,3,444,6638,8,444,1,444,1,444,1,444,1,444,1,444,1,444,1,444,
  	3,444,6647,8,444,3,444,6649,8,444,1,445,3,445,6652,8,445,1,445,1,445,
  	1,446,1,446,1,446,1,446,1,446,3,446,6661,8,446,1,447,1,447,1,447,5,447,
  	6666,8,447,10,447,12,447,6669,9,447,1,448,1,448,1,448,1,448,1,448,1,448,
  	1,448,1,448,1,448,1,448,3,448,6681,8,448,1,448,1,448,1,448,3,448,6686,
  	8,448,1,449,1,449,1,449,1,449,1,449,3,449,6693,8,449,1,449,1,449,1,449,
  	1,449,3,449,6699,8,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,4,449,6723,8,449,11,449,12,449,6724,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,3,449,6736,8,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,3,449,6768,8,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,3,449,6787,
  	8,449,1,449,1,449,1,449,1,449,3,449,6793,8,449,1,449,1,449,3,449,6797,
  	8,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,3,449,6824,8,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,3,449,6836,8,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,3,449,6849,8,449,1,449,1,449,3,449,6853,
  	8,449,1,449,1,449,3,449,6857,8,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,3,449,6885,8,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,3,449,
  	6935,8,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,1,449,3,449,6945,
  	8,449,1,449,1,449,3,449,6949,8,449,1,449,1,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,3,449,6961,8,449,1,449,1,449,1,449,3,449,6966,
  	8,449,1,450,1,450,1,450,1,451,1,451,1,451,1,451,1,451,1,451,1,451,1,451,
  	1,451,1,451,1,451,3,451,6982,8,451,1,451,1,451,1,451,1,451,1,451,1,451,
  	1,451,1,451,1,451,1,451,1,451,1,451,1,451,1,451,1,451,1,451,1,451,1,451,
  	3,451,7002,8,451,1,452,1,452,3,452,7006,8,452,1,452,1,452,1,453,1,453,
  	1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,5,454,7020,8,454,10,454,
  	12,454,7023,9,454,3,454,7025,8,454,1,455,1,455,1,455,3,455,7030,8,455,
  	1,455,3,455,7033,8,455,1,456,1,456,1,457,1,457,1,457,1,457,1,457,3,457,
  	7042,8,457,1,457,1,457,3,457,7046,8,457,1,457,1,457,1,457,1,457,3,457,
  	7052,8,457,1,457,1,457,1,457,1,457,3,457,7058,8,457,1,457,1,457,3,457,
  	7062,8,457,1,457,1,457,1,458,1,458,1,458,1,458,1,458,1,458,1,458,3,458,
  	7073,8,458,1,458,1,458,1,458,1,458,3,458,7079,8,458,3,458,7081,8,458,
  	1,458,1,458,1,459,1,459,1,459,3,459,7088,8,459,1,459,1,459,1,459,1,459,
  	1,459,3,459,7095,8,459,1,459,1,459,3,459,7099,8,459,1,460,1,460,1,460,
  	5,460,7104,8,460,10,460,12,460,7107,9,460,1,461,1,461,3,461,7111,8,461,
  	1,462,1,462,1,462,1,463,1,463,3,463,7118,8,463,1,464,1,464,1,464,1,464,
  	1,465,1,465,1,465,1,465,3,465,7128,8,465,1,465,3,465,7131,8,465,1,466,
  	1,466,1,466,3,466,7136,8,466,1,466,1,466,1,466,3,466,7141,8,466,3,466,
  	7143,8,466,1,466,1,466,3,466,7147,8,466,1,467,1,467,3,467,7151,8,467,
  	1,468,1,468,1,468,1,469,1,469,1,469,1,470,1,470,1,470,1,471,1,471,3,471,
  	7164,8,471,1,471,1,471,3,471,7168,8,471,1,471,3,471,7171,8,471,1,471,
  	1,471,3,471,7175,8,471,1,471,1,471,3,471,7179,8,471,1,471,1,471,3,471,
  	7183,8,471,1,471,1,471,1,471,1,471,1,471,3,471,7190,8,471,1,471,1,471,
  	3,471,7194,8,471,1,471,1,471,3,471,7198,8,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,3,471,7207,8,471,1,471,1,471,3,471,7211,8,471,1,472,
  	1,472,1,472,5,472,7216,8,472,10,472,12,472,7219,9,472,1,473,1,473,1,473,
  	3,473,7224,8,473,1,474,1,474,1,475,1,475,1,476,1,476,3,476,7232,8,476,
  	1,477,1,477,1,478,1,478,1,478,1,478,1,479,1,479,1,479,1,479,1,480,1,480,
  	1,480,1,480,1,481,1,481,1,481,5,481,7251,8,481,10,481,12,481,7254,9,481,
  	1,482,1,482,3,482,7258,8,482,1,483,1,483,1,483,5,483,7263,8,483,10,483,
  	12,483,7266,9,483,1,484,1,484,1,485,1,485,1,485,1,485,1,485,1,486,1,486,
  	1,486,1,486,1,486,1,486,1,486,1,486,1,486,1,486,1,486,1,486,1,486,3,486,
  	7288,8,486,1,487,1,487,1,487,1,488,1,488,1,488,1,488,1,488,1,489,1,489,
  	1,489,1,489,1,489,1,489,3,489,7304,8,489,1,490,1,490,1,490,1,491,1,491,
  	1,491,4,491,7312,8,491,11,491,12,491,7313,1,492,1,492,3,492,7318,8,492,
  	1,492,1,492,1,492,4,492,7323,8,492,11,492,12,492,7324,1,492,3,492,7328,
  	8,492,1,492,1,492,1,492,1,493,1,493,1,493,1,494,1,494,1,494,3,494,7339,
  	8,494,1,495,1,495,1,496,1,496,1,496,1,497,1,497,3,497,7348,8,497,1,497,
  	3,497,7351,8,497,1,497,1,497,1,498,1,498,1,498,3,498,7358,8,498,1,499,
  	1,499,1,499,3,499,7363,8,499,1,500,1,500,1,500,1,500,1,500,1,501,1,501,
  	1,501,1,501,1,501,1,501,1,501,1,502,1,502,1,502,1,502,1,502,1,502,1,502,
  	1,503,1,503,1,503,4,503,7387,8,503,11,503,12,503,7388,1,504,1,504,1,504,
  	1,504,3,504,7395,8,504,1,505,1,505,1,505,1,505,3,505,7401,8,505,1,505,
  	1,505,3,505,7405,8,505,1,506,1,506,1,506,1,506,1,506,1,506,1,507,1,507,
  	3,507,7415,8,507,1,508,1,508,3,508,7419,8,508,1,508,1,508,1,509,1,509,
  	1,509,1,509,1,509,1,509,1,509,5,509,7430,8,509,10,509,12,509,7433,9,509,
  	1,509,1,509,1,510,1,510,1,510,1,510,1,510,1,510,1,510,3,510,7444,8,510,
  	1,511,1,511,1,511,1,511,1,511,1,511,1,512,1,512,1,512,1,513,1,513,1,513,
  	1,514,1,514,3,514,7460,8,514,1,514,1,514,1,514,1,514,5,514,7466,8,514,
  	10,514,12,514,7469,9,514,1,514,1,514,1,514,1,514,1,514,5,514,7476,8,514,
  	10,514,12,514,7479,9,514,3,514,7481,8,514,1,515,1,515,1,515,3,515,7486,
  	8,515,1,516,1,516,3,516,7490,8,516,1,516,1,516,1,516,1,517,1,517,3,517,
  	7497,8,517,1,517,1,517,1,517,3,517,7502,8,517,1,518,1,518,1,519,1,519,
  	1,519,3,519,7509,8,519,1,519,1,519,1,519,1,519,5,519,7515,8,519,10,519,
  	12,519,7518,9,519,3,519,7520,8,519,1,520,1,520,1,520,3,520,7525,8,520,
  	1,520,1,520,1,520,1,520,5,520,7531,8,520,10,520,12,520,7534,9,520,3,520,
  	7536,8,520,1,521,1,521,1,521,1,521,1,522,1,522,1,522,1,523,1,523,1,523,
  	1,524,1,524,3,524,7550,8,524,1,524,3,524,7553,8,524,1,524,1,524,1,524,
  	1,524,1,525,1,525,1,525,1,525,1,525,1,525,1,525,3,525,7566,8,525,1,525,
  	1,525,3,525,7570,8,525,3,525,7572,8,525,1,526,1,526,1,526,3,526,7577,
  	8,526,1,527,1,527,1,527,3,527,7582,8,527,1,528,1,528,1,528,1,529,3,529,
  	7588,8,529,1,529,1,529,1,530,1,530,3,530,7594,8,530,1,530,1,530,5,530,
  	7598,8,530,10,530,12,530,7601,9,530,1,530,1,530,3,530,7605,8,530,1,530,
  	3,530,7608,8,530,1,530,1,530,5,530,7612,8,530,10,530,12,530,7615,9,530,
  	1,530,1,530,3,530,7619,8,530,1,530,3,530,7622,8,530,1,530,1,530,5,530,
  	7626,8,530,10,530,12,530,7629,9,530,1,530,3,530,7632,8,530,1,530,1,530,
  	1,530,1,530,3,530,7638,8,530,3,530,7640,8,530,1,530,3,530,7643,8,530,
  	1,530,1,530,5,530,7647,8,530,10,530,12,530,7650,9,530,1,530,1,530,1,530,
  	3,530,7655,8,530,1,530,1,530,1,530,1,530,1,530,1,530,3,530,7663,8,530,
  	3,530,7665,8,530,3,530,7667,8,530,1,531,1,531,3,531,7671,8,531,1,532,
  	1,532,5,532,7675,8,532,10,532,12,532,7678,9,532,1,532,1,532,3,532,7682,
  	8,532,1,532,1,532,3,532,7686,8,532,1,532,1,532,1,532,3,532,7691,8,532,
  	1,532,1,532,5,532,7695,8,532,10,532,12,532,7698,9,532,1,532,1,532,5,532,
  	7702,8,532,10,532,12,532,7705,9,532,3,532,7707,8,532,3,532,7709,8,532,
  	1,533,3,533,7712,8,533,1,533,1,533,1,533,1,533,1,533,1,533,1,533,1,533,
  	1,533,1,533,1,533,3,533,7725,8,533,1,533,1,533,3,533,7729,8,533,1,533,
  	1,533,1,533,1,533,3,533,7735,8,533,1,533,1,533,1,533,1,533,1,533,3,533,
  	7742,8,533,1,533,1,533,1,533,3,533,7747,8,533,1,533,1,533,1,533,1,533,
  	1,533,1,533,1,533,1,533,1,533,1,533,1,533,1,533,3,533,7761,8,533,1,533,
  	1,533,1,533,1,533,1,533,1,533,3,533,7769,8,533,1,533,1,533,1,533,1,533,
  	3,533,7775,8,533,1,533,1,533,1,533,3,533,7780,8,533,1,534,1,534,1,535,
  	1,535,1,536,1,536,1,536,1,537,1,537,3,537,7791,8,537,1,538,1,538,3,538,
  	7795,8,538,1,538,1,538,1,538,3,538,7800,8,538,1,538,1,538,3,538,7804,
  	8,538,1,538,3,538,7807,8,538,1,539,1,539,1,539,3,539,7812,8,539,1,539,
  	1,539,3,539,7816,8,539,1,539,1,539,1,539,1,539,1,539,1,539,3,539,7824,
  	8,539,1,539,1,539,1,539,1,539,1,539,1,539,3,539,7832,8,539,3,539,7834,
  	8,539,1,540,1,540,1,540,1,540,1,540,1,540,1,540,3,540,7843,8,540,1,541,
  	1,541,1,541,1,541,5,541,7849,8,541,10,541,12,541,7852,9,541,1,541,1,541,
  	1,542,1,542,3,542,7858,8,542,1,542,3,542,7861,8,542,1,543,1,543,1,543,
  	1,543,5,543,7867,8,543,10,543,12,543,7870,9,543,1,543,1,543,1,544,1,544,
  	1,544,3,544,7877,8,544,3,544,7879,8,544,1,545,1,545,1,545,1,545,3,545,
  	7885,8,545,1,546,1,546,1,547,1,547,3,547,7891,8,547,1,548,1,548,3,548,
  	7895,8,548,1,548,1,548,1,548,1,548,1,548,1,548,1,548,1,548,3,548,7905,
  	8,548,1,548,1,548,1,548,1,548,3,548,7911,8,548,1,548,3,548,7914,8,548,
  	1,549,1,549,1,550,1,550,1,550,1,551,1,551,1,551,1,551,3,551,7925,8,551,
  	1,552,1,552,1,553,1,553,1,553,1,554,1,554,3,554,7934,8,554,1,554,3,554,
  	7937,8,554,1,554,1,554,1,554,3,554,7942,8,554,3,554,7944,8,554,1,554,
  	3,554,7947,8,554,1,554,3,554,7950,8,554,1,554,1,554,3,554,7954,8,554,
  	1,554,3,554,7957,8,554,1,554,1,554,3,554,7961,8,554,1,554,1,554,1,554,
  	3,554,7966,8,554,1,554,3,554,7969,8,554,1,554,1,554,3,554,7973,8,554,
  	1,554,3,554,7976,8,554,1,554,1,554,3,554,7980,8,554,1,554,1,554,1,554,
  	3,554,7985,8,554,1,554,1,554,3,554,7989,8,554,1,554,1,554,1,554,1,554,
  	1,554,1,554,1,554,1,554,1,554,1,554,3,554,8001,8,554,1,554,1,554,3,554,
  	8005,8,554,1,554,1,554,1,554,1,554,3,554,8011,8,554,1,554,3,554,8014,
  	8,554,1,554,1,554,1,554,3,554,8019,8,554,1,554,1,554,3,554,8023,8,554,
  	1,554,1,554,3,554,8027,8,554,1,554,1,554,1,554,3,554,8032,8,554,1,554,
  	1,554,1,554,1,554,1,554,1,554,1,554,3,554,8041,8,554,1,554,3,554,8044,
  	8,554,1,554,1,554,3,554,8048,8,554,1,554,1,554,3,554,8052,8,554,1,554,
  	3,554,8055,8,554,1,554,1,554,3,554,8059,8,554,1,554,1,554,3,554,8063,
  	8,554,1,554,1,554,1,554,3,554,8068,8,554,1,554,1,554,1,554,3,554,8073,
  	8,554,1,554,1,554,1,554,1,554,3,554,8079,8,554,1,555,1,555,1,555,3,555,
  	8084,8,555,1,556,1,556,1,556,3,556,8089,8,556,3,556,8091,8,556,1,557,
  	1,557,1,557,3,557,8096,8,557,1,557,1,557,1,558,4,558,8101,8,558,11,558,
  	12,558,8102,1,559,1,559,1,559,1,559,1,559,1,559,3,559,8111,8,559,1,559,
  	1,559,1,559,1,559,3,559,8117,8,559,3,559,8119,8,559,1,560,1,560,3,560,
  	8123,8,560,1,560,1,560,3,560,8127,8,560,1,561,1,561,3,561,8131,8,561,
  	1,561,1,561,3,561,8135,8,561,1,562,1,562,1,562,1,562,1,563,1,563,1,563,
  	1,563,1,564,1,564,1,564,1,564,1,564,3,564,8150,8,564,1,565,1,565,1,565,
  	1,565,3,565,8156,8,565,1,566,1,566,1,566,1,566,1,566,3,566,8163,8,566,
  	1,567,1,567,3,567,8167,8,567,1,567,5,567,8170,8,567,10,567,12,567,8173,
  	9,567,1,568,4,568,8176,8,568,11,568,12,568,8177,1,569,1,569,3,569,8182,
  	8,569,1,569,1,569,1,569,1,569,3,569,8188,8,569,1,569,1,569,3,569,8192,
  	8,569,1,569,1,569,3,569,8196,8,569,1,569,1,569,1,569,3,569,8201,8,569,
  	1,569,1,569,1,569,3,569,8206,8,569,1,569,1,569,1,569,3,569,8211,8,569,
  	1,569,1,569,1,569,3,569,8216,8,569,1,569,1,569,1,569,1,569,3,569,8222,
  	8,569,1,569,1,569,1,569,1,569,3,569,8228,8,569,1,569,1,569,1,569,3,569,
  	8233,8,569,1,569,1,569,1,569,3,569,8238,8,569,1,569,1,569,1,569,3,569,
  	8243,8,569,1,569,1,569,1,569,3,569,8248,8,569,1,569,1,569,1,569,3,569,
  	8253,8,569,1,569,1,569,1,569,3,569,8258,8,569,1,569,1,569,1,569,3,569,
  	8263,8,569,1,569,1,569,1,569,1,569,1,569,1,569,1,569,1,569,3,569,8273,
  	8,569,1,569,1,569,1,569,1,569,3,569,8279,8,569,1,569,1,569,1,569,1,569,
  	3,569,8285,8,569,1,569,1,569,1,569,1,569,3,569,8291,8,569,1,569,3,569,
  	8294,8,569,1,569,1,569,1,569,1,569,1,569,3,569,8301,8,569,1,569,1,569,
  	1,569,3,569,8306,8,569,1,569,1,569,1,569,1,569,1,569,1,569,1,569,3,569,
  	8315,8,569,1,569,1,569,1,569,1,569,3,569,8321,8,569,1,569,1,569,1,569,
  	3,569,8326,8,569,1,570,1,570,3,570,8330,8,570,1,571,3,571,8333,8,571,
  	1,571,1,571,3,571,8337,8,571,1,571,1,571,1,572,3,572,8342,8,572,1,572,
  	1,572,3,572,8346,8,572,1,572,1,572,1,573,3,573,8351,8,573,1,573,1,573,
  	3,573,8355,8,573,1,573,1,573,1,574,1,574,1,574,1,574,1,574,3,574,8364,
  	8,574,1,574,3,574,8367,8,574,1,574,3,574,8370,8,574,1,575,3,575,8373,
  	8,575,1,575,1,575,3,575,8377,8,575,1,575,1,575,3,575,8381,8,575,1,575,
  	1,575,3,575,8385,8,575,1,575,1,575,1,575,1,575,1,575,1,575,1,575,1,575,
  	1,575,1,575,1,575,1,575,1,575,3,575,8400,8,575,1,575,3,575,8403,8,575,
  	3,575,8405,8,575,1,576,1,576,1,576,3,576,8410,8,576,1,576,1,576,1,576,
  	1,576,1,576,1,576,1,576,3,576,8419,8,576,1,576,3,576,8422,8,576,1,576,
  	1,576,3,576,8426,8,576,1,577,1,577,1,577,1,577,1,578,1,578,1,578,1,578,
  	5,578,8436,8,578,10,578,12,578,8439,9,578,1,578,1,578,1,579,1,579,1,579,
  	1,579,1,579,1,579,1,579,3,579,8450,8,579,1,579,1,579,1,579,3,579,8455,
  	8,579,1,579,5,579,8458,8,579,10,579,12,579,8461,9,579,1,579,1,579,1,579,
  	1,579,5,579,8467,8,579,10,579,12,579,8470,9,579,1,579,1,579,3,579,8474,
  	8,579,1,580,1,580,1,580,1,580,1,580,5,580,8481,8,580,10,580,12,580,8484,
  	9,580,1,580,1,580,3,580,8488,8,580,1,581,1,581,3,581,8492,8,581,1,581,
  	1,581,3,581,8496,8,581,1,581,1,581,3,581,8500,8,581,1,581,1,581,1,581,
  	3,581,8505,8,581,1,581,1,581,1,581,3,581,8510,8,581,1,581,1,581,1,581,
  	1,581,3,581,8516,8,581,1,581,1,581,1,581,3,581,8521,8,581,1,581,3,581,
  	8524,8,581,1,582,1,582,1,582,5,582,8529,8,582,10,582,12,582,8532,9,582,
  	1,583,1,583,1,583,1,583,5,583,8538,8,583,10,583,12,583,8541,9,583,1,583,
  	1,583,1,584,1,584,3,584,8547,8,584,1,585,1,585,1,585,1,585,1,586,1,586,
  	1,586,1,587,1,587,1,587,1,587,1,588,3,588,8561,8,588,1,588,1,588,1,589,
  	1,589,1,589,1,590,1,590,1,590,1,591,1,591,3,591,8573,8,591,1,592,1,592,
  	1,592,1,592,1,592,1,592,1,593,1,593,1,593,5,593,8584,8,593,10,593,12,
  	593,8587,9,593,1,594,1,594,1,594,5,594,8592,8,594,10,594,12,594,8595,
  	9,594,1,595,1,595,1,595,1,595,3,595,8601,8,595,1,596,1,596,1,596,1,597,
  	1,597,4,597,8608,8,597,11,597,12,597,8609,1,598,1,598,1,598,1,598,3,598,
  	8616,8,598,1,598,1,598,1,598,1,598,1,598,1,598,3,598,8624,8,598,1,599,
  	1,599,4,599,8628,8,599,11,599,12,599,8629,1,600,1,600,1,600,1,600,1,601,
  	1,601,1,601,5,601,8639,8,601,10,601,12,601,8642,9,601,1,602,1,602,1,602,
  	5,602,8647,8,602,10,602,12,602,8650,9,602,1,603,1,603,1,603,1,603,3,603,
  	8656,8,603,1,603,1,603,1,603,3,603,8661,8,603,1,603,1,603,3,603,8665,
  	8,603,1,604,1,604,1,604,1,604,3,604,8671,8,604,1,605,1,605,1,605,1,605,
  	1,605,1,605,1,605,1,605,1,605,3,605,8682,8,605,1,606,1,606,1,606,1,606,
  	3,606,8688,8,606,1,606,1,606,1,607,1,607,1,607,1,607,1,607,1,608,1,608,
  	1,608,1,608,1,609,1,609,1,609,1,609,1,609,1,609,1,610,1,610,1,610,1,610,
  	1,610,1,610,1,611,1,611,1,611,1,611,1,611,1,611,1,611,1,612,1,612,1,612,
  	1,612,1,612,3,612,8725,8,612,1,613,1,613,1,613,1,613,1,614,1,614,1,614,
  	1,614,1,615,1,615,1,615,1,615,1,615,1,615,1,615,1,615,1,615,1,615,1,615,
  	1,615,1,615,1,615,1,615,3,615,8750,8,615,1,616,1,616,1,616,1,617,1,617,
  	1,617,1,618,1,618,1,618,1,618,3,618,8762,8,618,3,618,8764,8,618,1,619,
  	1,619,1,619,3,619,8769,8,619,3,619,8771,8,619,1,620,1,620,1,620,1,621,
  	1,621,3,621,8778,8,621,1,622,1,622,1,623,1,623,1,624,1,624,1,624,1,625,
  	1,625,1,625,3,625,8790,8,625,3,625,8792,8,625,1,626,1,626,1,626,1,626,
  	3,626,8798,8,626,1,627,1,627,1,628,1,628,1,628,1,628,5,628,8806,8,628,
  	10,628,12,628,8809,9,628,1,628,1,628,1,629,1,629,1,630,1,630,3,630,8817,
  	8,630,1,631,1,631,1,632,1,632,1,633,1,633,1,633,1,633,1,633,3,633,8828,
  	8,633,1,633,1,633,1,634,1,634,1,635,1,635,1,636,1,636,1,637,1,637,1,638,
  	1,638,1,639,1,639,1,640,1,640,1,641,1,641,1,642,1,642,3,642,8850,8,642,
  	1,643,1,643,3,643,8854,8,643,1,644,1,644,1,645,1,645,1,646,1,646,1,647,
  	1,647,1,648,1,648,1,649,1,649,1,650,1,650,1,651,1,651,1,652,1,652,1,653,
  	1,653,1,654,1,654,3,654,8878,8,654,1,655,1,655,1,655,1,656,1,656,1,656,
  	1,656,1,656,1,656,3,656,8889,8,656,3,656,8891,8,656,1,657,1,657,3,657,
  	8895,8,657,1,658,1,658,1,658,5,658,8900,8,658,10,658,12,658,8903,9,658,
  	1,659,1,659,1,659,5,659,8908,8,659,10,659,12,659,8911,9,659,1,660,1,660,
  	1,661,1,661,3,661,8917,8,661,1,662,1,662,1,663,1,663,3,663,8923,8,663,
  	1,664,1,664,1,665,1,665,1,666,1,666,1,667,1,667,1,668,1,668,1,668,3,668,
  	8936,8,668,1,669,1,669,3,669,8940,8,669,1,670,1,670,1,670,5,670,8945,
  	8,670,10,670,12,670,8948,9,670,1,671,1,671,1,671,1,671,1,672,1,672,3,
  	672,8956,8,672,1,673,1,673,1,673,3,673,8961,8,673,3,673,8963,8,673,1,
  	673,1,673,1,673,1,673,3,673,8969,8,673,1,674,1,674,1,674,1,675,1,675,
  	1,676,1,676,1,677,1,677,1,678,1,678,1,678,1,678,1,678,3,678,8985,8,678,
  	1,679,1,679,1,679,1,679,1,679,3,679,8992,8,679,1,680,1,680,1,680,3,680,
  	8997,8,680,1,681,1,681,1,681,1,681,1,681,1,681,3,681,9005,8,681,1,681,
  	3,681,9008,8,681,1,682,1,682,1,682,3,682,9013,8,682,1,683,1,683,1,684,
  	1,684,1,684,1,684,5,684,9021,8,684,10,684,12,684,9024,9,684,1,684,1,684,
  	1,685,1,685,1,685,3,685,9031,8,685,1,686,1,686,1,686,3,686,9036,8,686,
  	1,687,1,687,1,687,3,687,9041,8,687,1,688,3,688,9044,8,688,1,688,1,688,
  	3,688,9048,8,688,1,688,5,688,9051,8,688,10,688,12,688,9054,9,688,1,689,
  	1,689,1,690,1,690,1,690,5,690,9061,8,690,10,690,12,690,9064,9,690,1,691,
  	1,691,1,691,3,691,9069,8,691,1,692,1,692,1,693,1,693,1,694,1,694,1,695,
  	1,695,1,695,1,695,1,695,1,695,3,695,9083,8,695,1,696,1,696,3,696,9087,
  	8,696,1,697,1,697,1,698,1,698,1,698,1,698,1,698,1,698,1,699,1,699,3,699,
  	9099,8,699,1,700,1,700,3,700,9103,8,700,1,701,1,701,3,701,9107,8,701,
  	1,702,1,702,3,702,9111,8,702,1,703,1,703,1,703,1,704,1,704,1,705,1,705,
  	1,705,1,705,1,705,1,705,1,705,3,705,9125,8,705,1,706,1,706,1,706,1,706,
  	1,706,1,706,3,706,9133,8,706,1,707,1,707,1,707,1,707,1,707,1,707,1,707,
  	3,707,9142,8,707,1,707,1,707,1,708,1,708,1,709,1,709,1,709,1,709,1,709,
  	1,709,1,709,1,709,3,709,9156,8,709,1,709,1,709,1,709,1,709,1,709,3,709,
  	9163,8,709,3,709,9165,8,709,1,710,1,710,1,711,1,711,1,712,1,712,1,712,
  	1,712,1,712,1,712,1,712,1,712,1,712,1,712,1,712,3,712,9182,8,712,1,712,
  	1,712,1,712,3,712,9187,8,712,3,712,9189,8,712,1,713,1,713,1,714,1,714,
  	1,714,3,714,9196,8,714,1,715,1,715,1,715,3,715,9201,8,715,1,715,1,715,
  	1,715,3,715,9206,8,715,3,715,9208,8,715,1,716,1,716,1,716,1,716,3,716,
  	9214,8,716,1,717,1,717,1,718,1,718,1,718,1,718,1,718,3,718,9223,8,718,
  	1,719,1,719,1,719,1,719,1,719,1,719,1,719,1,719,1,719,1,719,1,719,3,719,
  	9236,8,719,1,719,0,4,854,856,864,866,720,0,2,4,6,8,10,12,14,16,18,20,
  	22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,
  	68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,
  	112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,
  	148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,
  	184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,
  	220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,
  	256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,
  	292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,
  	328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,
  	364,366,368,370,372,374,376,378,380,382,384,386,388,390,392,394,396,398,
  	400,402,404,406,408,410,412,414,416,418,420,422,424,426,428,430,432,434,
  	436,438,440,442,444,446,448,450,452,454,456,458,460,462,464,466,468,470,
  	472,474,476,478,480,482,484,486,488,490,492,494,496,498,500,502,504,506,
  	508,510,512,514,516,518,520,522,524,526,528,530,532,534,536,538,540,542,
  	544,546,548,550,552,554,556,558,560,562,564,566,568,570,572,574,576,578,
  	580,582,584,586,588,590,592,594,596,598,600,602,604,606,608,610,612,614,
  	616,618,620,622,624,626,628,630,632,634,636,638,640,642,644,646,648,650,
  	652,654,656,658,660,662,664,666,668,670,672,674,676,678,680,682,684,686,
  	688,690,692,694,696,698,700,702,704,706,708,710,712,714,716,718,720,722,
  	724,726,728,730,732,734,736,738,740,742,744,746,748,750,752,754,756,758,
  	760,762,764,766,768,770,772,774,776,778,780,782,784,786,788,790,792,794,
  	796,798,800,802,804,806,808,810,812,814,816,818,820,822,824,826,828,830,
  	832,834,836,838,840,842,844,846,848,850,852,854,856,858,860,862,864,866,
  	868,870,872,874,876,878,880,882,884,886,888,890,892,894,896,898,900,902,
  	904,906,908,910,912,914,916,918,920,922,924,926,928,930,932,934,936,938,
  	940,942,944,946,948,950,952,954,956,958,960,962,964,966,968,970,972,974,
  	976,978,980,982,984,986,988,990,992,994,996,998,1000,1002,1004,1006,1008,
  	1010,1012,1014,1016,1018,1020,1022,1024,1026,1028,1030,1032,1034,1036,
  	1038,1040,1042,1044,1046,1048,1050,1052,1054,1056,1058,1060,1062,1064,
  	1066,1068,1070,1072,1074,1076,1078,1080,1082,1084,1086,1088,1090,1092,
  	1094,1096,1098,1100,1102,1104,1106,1108,1110,1112,1114,1116,1118,1120,
  	1122,1124,1126,1128,1130,1132,1134,1136,1138,1140,1142,1144,1146,1148,
  	1150,1152,1154,1156,1158,1160,1162,1164,1166,1168,1170,1172,1174,1176,
  	1178,1180,1182,1184,1186,1188,1190,1192,1194,1196,1198,1200,1202,1204,
  	1206,1208,1210,1212,1214,1216,1218,1220,1222,1224,1226,1228,1230,1232,
  	1234,1236,1238,1240,1242,1244,1246,1248,1250,1252,1254,1256,1258,1260,
  	1262,1264,1266,1268,1270,1272,1274,1276,1278,1280,1282,1284,1286,1288,
  	1290,1292,1294,1296,1298,1300,1302,1304,1306,1308,1310,1312,1314,1316,
  	1318,1320,1322,1324,1326,1328,1330,1332,1334,1336,1338,1340,1342,1344,
  	1346,1348,1350,1352,1354,1356,1358,1360,1362,1364,1366,1368,1370,1372,
  	1374,1376,1378,1380,1382,1384,1386,1388,1390,1392,1394,1396,1398,1400,
  	1402,1404,1406,1408,1410,1412,1414,1416,1418,1420,1422,1424,1426,1428,
  	1430,1432,1434,1436,1438,0,169,1,0,722,723,2,0,17,17,590,590,2,0,49,49,
  	471,471,1,0,645,646,2,0,4,4,148,148,1,0,724,725,2,0,50,50,284,284,2,0,
  	140,140,156,156,2,0,232,232,458,458,4,0,126,126,249,249,437,437,556,556,
  	2,0,130,130,250,250,2,0,441,441,604,604,2,0,374,374,638,638,3,0,335,335,
  	578,578,602,602,2,0,6,6,28,28,3,0,133,133,242,242,614,614,2,0,197,197,
  	415,415,2,0,571,571,574,574,3,0,232,232,295,295,431,431,2,0,191,191,367,
  	367,4,0,191,191,268,268,367,367,419,419,2,0,750,750,753,756,3,0,131,131,
  	223,223,295,295,1,0,626,627,2,0,82,82,295,295,2,0,112,112,653,653,2,0,
  	278,278,484,484,2,0,131,131,295,295,7,0,10,10,143,143,223,223,531,532,
  	534,534,536,536,555,555,2,0,381,381,773,773,2,0,747,749,786,786,3,0,432,
  	432,484,484,683,683,2,0,18,18,134,134,2,0,272,272,478,478,2,0,98,98,239,
  	239,2,0,10,10,143,143,2,0,198,198,232,232,2,0,236,236,265,265,2,0,386,
  	386,649,649,2,0,29,29,543,543,2,0,261,261,472,472,2,0,32,32,316,316,2,
  	0,296,296,806,806,2,0,300,300,812,812,2,0,297,297,807,807,2,0,318,318,
  	830,830,2,0,303,303,815,815,2,0,304,304,816,816,2,0,298,298,809,809,2,
  	0,305,305,818,818,2,0,299,299,810,810,2,0,314,314,819,819,2,0,308,308,
  	820,820,2,0,307,307,821,821,2,0,310,310,823,823,2,0,311,311,824,824,2,
  	0,312,312,825,825,2,0,313,313,826,826,2,0,315,315,827,827,2,0,317,317,
  	829,829,2,0,738,738,828,828,2,0,309,309,822,822,2,0,712,712,817,817,2,
  	0,713,713,805,805,2,0,319,319,811,811,2,0,735,735,808,808,2,0,736,736,
  	831,831,2,0,383,383,743,744,2,0,301,301,813,813,2,0,302,302,814,814,2,
  	0,528,528,530,530,2,0,449,449,538,538,2,0,514,514,802,802,2,0,123,123,
  	148,148,3,0,369,369,539,539,650,650,2,0,287,287,611,611,2,0,128,128,719,
  	719,3,0,206,206,422,422,574,574,4,0,242,242,443,443,497,497,614,614,13,
  	0,133,133,148,148,170,170,173,173,188,188,236,236,423,423,427,427,451,
  	451,510,510,565,565,594,594,616,616,4,0,483,483,572,572,618,618,636,636,
  	2,0,97,97,148,148,2,0,128,128,369,369,2,0,180,180,431,431,5,0,56,56,180,
  	180,184,184,333,333,431,431,3,0,180,180,431,431,619,619,2,0,76,76,601,
  	601,2,0,203,203,251,251,2,0,235,236,263,263,6,0,10,10,96,96,256,256,334,
  	334,522,522,567,567,2,0,84,84,430,430,5,0,136,136,225,225,421,421,547,
  	547,617,617,5,0,32,32,163,163,165,165,208,208,515,515,2,0,618,618,710,
  	710,2,0,134,135,178,178,3,0,183,183,596,596,610,610,2,0,15,15,767,767,
  	2,0,394,394,770,770,2,0,10,10,16,16,2,0,750,750,752,757,3,0,145,145,349,
  	349,760,762,1,0,758,759,1,0,765,766,2,0,758,759,764,764,2,0,35,36,38,
  	38,2,0,326,326,345,345,5,0,548,548,551,551,564,564,632,632,635,635,4,
  	0,678,679,692,692,694,694,696,696,2,0,684,684,686,686,2,0,681,681,685,
  	685,2,0,191,191,268,268,2,0,232,232,695,695,2,0,5,5,558,558,1,0,114,115,
  	1,0,791,792,4,0,113,113,116,116,583,583,586,586,4,0,211,211,279,279,351,
  	353,411,412,2,0,371,371,745,745,2,0,745,745,763,763,5,0,118,121,226,228,
  	341,342,494,494,655,655,9,0,122,122,229,229,337,337,343,343,350,350,429,
  	429,495,495,640,640,656,656,3,0,92,92,175,175,605,605,2,0,101,101,540,
  	540,2,0,377,377,485,485,10,0,53,53,64,64,73,73,87,89,107,107,336,336,
  	355,355,492,492,557,557,576,576,2,0,554,554,637,637,3,0,128,128,152,152,
  	192,192,3,0,128,128,142,142,334,334,3,0,204,204,402,402,513,513,3,0,44,
  	44,220,220,488,488,1,0,661,662,2,0,599,599,621,621,5,0,31,31,249,249,
  	331,331,516,516,588,588,4,0,126,126,192,192,195,195,378,378,1,0,41,42,
  	2,0,290,290,330,330,4,0,211,212,279,279,351,353,411,412,3,0,512,512,612,
  	612,657,657,1,0,544,546,2,0,61,61,575,575,6,0,78,78,80,80,128,128,152,
  	152,192,192,442,442,3,0,191,191,268,268,373,373,2,0,142,142,334,334,2,
  	0,280,280,432,432,2,0,323,323,344,344,2,0,112,112,236,236,3,0,240,240,
  	251,251,397,397,2,0,541,541,579,579,2,0,380,380,385,385,2,0,284,284,375,
  	375,2,0,846,846,848,848,3,0,747,749,787,787,789,790,2,0,747,749,787,787,
  	2,0,747,749,789,790,1,0,787,788,2,0,183,183,596,596,2,0,376,376,785,785,
  	1,0,747,749,1,0,750,751,3,0,173,173,510,510,714,714,32,0,19,19,29,29,
  	46,47,58,58,61,61,75,75,77,77,90,90,123,123,147,147,159,159,196,197,219,
  	219,222,222,234,234,245,245,267,267,373,373,415,415,417,417,455,455,468,
  	468,480,480,489,489,512,512,514,514,543,543,552,552,597,597,606,607,651,
  	651,677,677,9,0,170,170,188,188,369,369,423,423,427,427,451,451,459,459,
  	565,565,709,709,165,0,2,3,5,9,12,12,16,16,21,21,23,27,33,33,37,37,40,
  	42,44,44,50,50,53,54,56,57,63,68,70,71,73,74,76,76,78,82,84,85,87,89,
  	91,91,96,96,101,101,107,107,111,113,116,116,122,122,129,130,132,132,138,
  	142,150,152,156,156,158,158,160,160,162,166,168,169,171,172,176,177,179,
  	181,184,185,189,192,201,202,204,204,208,208,210,213,216,216,220,220,224,
  	225,229,230,233,233,235,235,238,238,243,244,250,250,255,256,258,259,262,
  	262,264,264,268,268,270,270,273,274,279,280,286,286,288,289,296,296,298,
  	314,316,319,321,324,327,328,333,337,340,340,343,344,346,346,348,348,350,
  	358,361,361,363,363,365,368,374,374,377,377,379,379,381,381,384,384,386,
  	387,390,390,398,404,406,413,418,419,421,421,424,426,429,431,434,434,438,
  	439,441,442,445,449,452,452,454,454,456,456,460,466,470,470,472,474,476,
  	476,481,483,485,486,488,488,490,490,492,492,495,496,500,501,503,503,508,
  	508,513,513,515,515,517,517,519,522,528,530,532,532,535,535,538,538,540,
  	540,542,542,544,547,553,553,556,561,566,568,571,572,575,578,580,581,583,
  	583,586,586,592,593,598,599,601,604,610,610,613,613,615,615,617,619,625,
  	625,627,627,631,631,636,636,638,641,646,648,650,650,652,653,656,656,659,
  	662,664,664,669,671,674,675,680,680,682,682,689,690,693,693,695,695,697,
  	698,702,708,711,713,715,725,727,730,732,732,735,738,791,796,798,800,802,
  	842,4,0,583,583,586,586,731,731,733,744,5,0,214,214,284,284,502,502,658,
  	658,673,673,54,0,2,2,12,12,19,19,27,27,29,29,46,47,58,58,61,61,66,66,
  	75,75,77,77,90,90,123,123,147,147,159,159,196,197,201,201,210,210,219,
  	219,222,222,224,224,245,245,267,267,373,373,387,387,390,390,398,398,401,
  	401,405,405,413,413,415,415,417,417,452,452,455,455,468,468,470,470,480,
  	480,489,489,496,496,503,503,512,512,514,514,519,520,543,543,552,552,597,
  	597,606,607,615,615,648,648,651,651,659,659,661,662,677,677,720,723,159,
  	0,3,3,5,9,13,13,16,16,21,21,23,26,33,33,37,37,40,42,44,44,50,50,53,54,
  	56,57,63,65,67,68,70,71,73,74,76,76,78,82,84,85,87,89,91,91,96,96,101,
  	101,107,107,111,113,116,116,122,122,129,130,132,132,136,136,138,142,150,
  	152,156,156,158,158,160,160,162,166,168,169,171,171,176,176,179,181,184,
  	185,189,192,202,202,204,204,208,208,211,214,216,216,220,220,225,225,229,
  	230,233,233,235,235,238,238,243,244,250,250,255,256,258,259,262,262,264,
  	264,268,268,270,270,273,274,279,280,284,284,286,286,288,289,296,296,298,
  	305,307,314,316,319,321,325,327,328,333,337,340,340,343,344,346,346,348,
  	348,350,358,361,361,363,363,365,368,374,374,377,377,379,379,381,382,384,
  	384,399,400,402,404,406,412,418,419,421,421,424,426,429,431,434,434,438,
  	442,445,449,454,454,456,456,460,466,472,474,476,476,481,483,485,486,488,
  	488,490,490,492,492,495,495,500,502,508,508,513,513,515,515,517,517,521,
  	522,528,530,532,533,535,535,538,538,540,540,542,542,544,547,553,553,556,
  	561,565,568,571,572,575,578,580,581,583,583,586,586,592,593,598,604,610,
  	610,613,613,617,619,627,627,631,631,636,636,638,641,647,647,650,650,652,
  	653,656,656,664,664,669,671,674,676,680,680,682,682,689,690,693,693,695,
  	695,697,698,702,708,711,712,716,717,719,719,724,725,727,728,791,792,797,
  	797,5,0,99,99,206,206,234,234,484,484,487,487,6,0,172,172,177,177,386,
  	386,565,565,625,625,646,646,10351,0,1447,1,0,0,0,2,1528,1,0,0,0,4,1530,
  	1,0,0,0,6,1553,1,0,0,0,8,1574,1,0,0,0,10,1577,1,0,0,0,12,1615,1,0,0,0,
  	14,1624,1,0,0,0,16,1637,1,0,0,0,18,1639,1,0,0,0,20,1644,1,0,0,0,22,1664,
  	1,0,0,0,24,1673,1,0,0,0,26,1675,1,0,0,0,28,1690,1,0,0,0,30,1788,1,0,0,
  	0,32,1792,1,0,0,0,34,1808,1,0,0,0,36,1950,1,0,0,0,38,1955,1,0,0,0,40,
  	1957,1,0,0,0,42,1959,1,0,0,0,44,1973,1,0,0,0,46,1981,1,0,0,0,48,1997,
  	1,0,0,0,50,1999,1,0,0,0,52,2003,1,0,0,0,54,2008,1,0,0,0,56,2010,1,0,0,
  	0,58,2025,1,0,0,0,60,2033,1,0,0,0,62,2043,1,0,0,0,64,2045,1,0,0,0,66,
  	2067,1,0,0,0,68,2076,1,0,0,0,70,2079,1,0,0,0,72,2092,1,0,0,0,74,2097,
  	1,0,0,0,76,2101,1,0,0,0,78,2141,1,0,0,0,80,2143,1,0,0,0,82,2164,1,0,0,
  	0,84,2179,1,0,0,0,86,2182,1,0,0,0,88,2213,1,0,0,0,90,2223,1,0,0,0,92,
  	2226,1,0,0,0,94,2235,1,0,0,0,96,2237,1,0,0,0,98,2249,1,0,0,0,100,2278,
  	1,0,0,0,102,2309,1,0,0,0,104,2327,1,0,0,0,106,2330,1,0,0,0,108,2351,1,
  	0,0,0,110,2354,1,0,0,0,112,2412,1,0,0,0,114,2414,1,0,0,0,116,2418,1,0,
  	0,0,118,2427,1,0,0,0,120,2443,1,0,0,0,122,2445,1,0,0,0,124,2453,1,0,0,
  	0,126,2479,1,0,0,0,128,2481,1,0,0,0,130,2493,1,0,0,0,132,2508,1,0,0,0,
  	134,2510,1,0,0,0,136,2513,1,0,0,0,138,2535,1,0,0,0,140,2537,1,0,0,0,142,
  	2543,1,0,0,0,144,2549,1,0,0,0,146,2555,1,0,0,0,148,2561,1,0,0,0,150,2567,
  	1,0,0,0,152,2574,1,0,0,0,154,2582,1,0,0,0,156,2584,1,0,0,0,158,2590,1,
  	0,0,0,160,2596,1,0,0,0,162,2602,1,0,0,0,164,2609,1,0,0,0,166,2627,1,0,
  	0,0,168,2629,1,0,0,0,170,2633,1,0,0,0,172,2638,1,0,0,0,174,2658,1,0,0,
  	0,176,2662,1,0,0,0,178,2695,1,0,0,0,180,2726,1,0,0,0,182,2743,1,0,0,0,
  	184,2745,1,0,0,0,186,2765,1,0,0,0,188,2771,1,0,0,0,190,2777,1,0,0,0,192,
  	2783,1,0,0,0,194,2790,1,0,0,0,196,2799,1,0,0,0,198,2816,1,0,0,0,200,2818,
  	1,0,0,0,202,2825,1,0,0,0,204,2835,1,0,0,0,206,2849,1,0,0,0,208,2855,1,
  	0,0,0,210,2863,1,0,0,0,212,2869,1,0,0,0,214,2877,1,0,0,0,216,2883,1,0,
  	0,0,218,2893,1,0,0,0,220,2897,1,0,0,0,222,2903,1,0,0,0,224,2908,1,0,0,
  	0,226,2919,1,0,0,0,228,2962,1,0,0,0,230,2967,1,0,0,0,232,2969,1,0,0,0,
  	234,2976,1,0,0,0,236,3006,1,0,0,0,238,3008,1,0,0,0,240,3039,1,0,0,0,242,
  	3046,1,0,0,0,244,3050,1,0,0,0,246,3058,1,0,0,0,248,3068,1,0,0,0,250,3070,
  	1,0,0,0,252,3088,1,0,0,0,254,3100,1,0,0,0,256,3105,1,0,0,0,258,3111,1,
  	0,0,0,260,3144,1,0,0,0,262,3146,1,0,0,0,264,3154,1,0,0,0,266,3163,1,0,
  	0,0,268,3171,1,0,0,0,270,3183,1,0,0,0,272,3206,1,0,0,0,274,3221,1,0,0,
  	0,276,3225,1,0,0,0,278,3257,1,0,0,0,280,3272,1,0,0,0,282,3287,1,0,0,0,
  	284,3289,1,0,0,0,286,3316,1,0,0,0,288,3318,1,0,0,0,290,3320,1,0,0,0,292,
  	3323,1,0,0,0,294,3326,1,0,0,0,296,3333,1,0,0,0,298,3335,1,0,0,0,300,3365,
  	1,0,0,0,302,3377,1,0,0,0,304,3380,1,0,0,0,306,3389,1,0,0,0,308,3393,1,
  	0,0,0,310,3398,1,0,0,0,312,3411,1,0,0,0,314,3416,1,0,0,0,316,3420,1,0,
  	0,0,318,3436,1,0,0,0,320,3438,1,0,0,0,322,3456,1,0,0,0,324,3458,1,0,0,
  	0,326,3467,1,0,0,0,328,3479,1,0,0,0,330,3486,1,0,0,0,332,3497,1,0,0,0,
  	334,3499,1,0,0,0,336,3503,1,0,0,0,338,3505,1,0,0,0,340,3510,1,0,0,0,342,
  	3518,1,0,0,0,344,3527,1,0,0,0,346,3530,1,0,0,0,348,3545,1,0,0,0,350,3548,
  	1,0,0,0,352,3567,1,0,0,0,354,3572,1,0,0,0,356,3577,1,0,0,0,358,3581,1,
  	0,0,0,360,3595,1,0,0,0,362,3598,1,0,0,0,364,3604,1,0,0,0,366,3617,1,0,
  	0,0,368,3625,1,0,0,0,370,3651,1,0,0,0,372,3664,1,0,0,0,374,3671,1,0,0,
  	0,376,3673,1,0,0,0,378,3685,1,0,0,0,380,3687,1,0,0,0,382,3697,1,0,0,0,
  	384,3721,1,0,0,0,386,3723,1,0,0,0,388,3730,1,0,0,0,390,3740,1,0,0,0,392,
  	3775,1,0,0,0,394,3782,1,0,0,0,396,3788,1,0,0,0,398,3790,1,0,0,0,400,3794,
  	1,0,0,0,402,3802,1,0,0,0,404,3804,1,0,0,0,406,3809,1,0,0,0,408,3813,1,
  	0,0,0,410,3841,1,0,0,0,412,3843,1,0,0,0,414,3845,1,0,0,0,416,3853,1,0,
  	0,0,418,3855,1,0,0,0,420,3863,1,0,0,0,422,3873,1,0,0,0,424,3877,1,0,0,
  	0,426,3902,1,0,0,0,428,3929,1,0,0,0,430,3931,1,0,0,0,432,3940,1,0,0,0,
  	434,3971,1,0,0,0,436,3995,1,0,0,0,438,3997,1,0,0,0,440,4011,1,0,0,0,442,
  	4013,1,0,0,0,444,4048,1,0,0,0,446,4050,1,0,0,0,448,4093,1,0,0,0,450,4109,
  	1,0,0,0,452,4111,1,0,0,0,454,4119,1,0,0,0,456,4132,1,0,0,0,458,4134,1,
  	0,0,0,460,4141,1,0,0,0,462,4277,1,0,0,0,464,4279,1,0,0,0,466,4281,1,0,
  	0,0,468,4283,1,0,0,0,470,4285,1,0,0,0,472,4287,1,0,0,0,474,4289,1,0,0,
  	0,476,4291,1,0,0,0,478,4293,1,0,0,0,480,4295,1,0,0,0,482,4297,1,0,0,0,
  	484,4299,1,0,0,0,486,4301,1,0,0,0,488,4303,1,0,0,0,490,4305,1,0,0,0,492,
  	4307,1,0,0,0,494,4309,1,0,0,0,496,4311,1,0,0,0,498,4313,1,0,0,0,500,4315,
  	1,0,0,0,502,4317,1,0,0,0,504,4319,1,0,0,0,506,4321,1,0,0,0,508,4323,1,
  	0,0,0,510,4325,1,0,0,0,512,4327,1,0,0,0,514,4331,1,0,0,0,516,4333,1,0,
  	0,0,518,4338,1,0,0,0,520,4342,1,0,0,0,522,4358,1,0,0,0,524,4360,1,0,0,
  	0,526,4362,1,0,0,0,528,4364,1,0,0,0,530,4377,1,0,0,0,532,4441,1,0,0,0,
  	534,4443,1,0,0,0,536,4451,1,0,0,0,538,4459,1,0,0,0,540,4467,1,0,0,0,542,
  	4469,1,0,0,0,544,4477,1,0,0,0,546,4501,1,0,0,0,548,4514,1,0,0,0,550,4523,
  	1,0,0,0,552,4527,1,0,0,0,554,4531,1,0,0,0,556,4535,1,0,0,0,558,4539,1,
  	0,0,0,560,4547,1,0,0,0,562,4557,1,0,0,0,564,4559,1,0,0,0,566,4570,1,0,
  	0,0,568,4572,1,0,0,0,570,4576,1,0,0,0,572,4580,1,0,0,0,574,4584,1,0,0,
  	0,576,4597,1,0,0,0,578,4599,1,0,0,0,580,4605,1,0,0,0,582,4613,1,0,0,0,
  	584,4650,1,0,0,0,586,4652,1,0,0,0,588,4666,1,0,0,0,590,4668,1,0,0,0,592,
  	4725,1,0,0,0,594,4811,1,0,0,0,596,4870,1,0,0,0,598,4872,1,0,0,0,600,4875,
  	1,0,0,0,602,4903,1,0,0,0,604,4909,1,0,0,0,606,4918,1,0,0,0,608,4920,1,
  	0,0,0,610,4925,1,0,0,0,612,4980,1,0,0,0,614,4982,1,0,0,0,616,4990,1,0,
  	0,0,618,5039,1,0,0,0,620,5052,1,0,0,0,622,5054,1,0,0,0,624,5057,1,0,0,
  	0,626,5068,1,0,0,0,628,5073,1,0,0,0,630,5076,1,0,0,0,632,5091,1,0,0,0,
  	634,5141,1,0,0,0,636,5143,1,0,0,0,638,5145,1,0,0,0,640,5197,1,0,0,0,642,
  	5215,1,0,0,0,644,5217,1,0,0,0,646,5233,1,0,0,0,648,5245,1,0,0,0,650,5270,
  	1,0,0,0,652,5272,1,0,0,0,654,5280,1,0,0,0,656,5331,1,0,0,0,658,5346,1,
  	0,0,0,660,5351,1,0,0,0,662,5353,1,0,0,0,664,5377,1,0,0,0,666,5379,1,0,
  	0,0,668,5438,1,0,0,0,670,5449,1,0,0,0,672,5451,1,0,0,0,674,5454,1,0,0,
  	0,676,5467,1,0,0,0,678,5500,1,0,0,0,680,5508,1,0,0,0,682,5515,1,0,0,0,
  	684,5517,1,0,0,0,686,5530,1,0,0,0,688,5532,1,0,0,0,690,5537,1,0,0,0,692,
  	5548,1,0,0,0,694,5559,1,0,0,0,696,5567,1,0,0,0,698,5576,1,0,0,0,700,5585,
  	1,0,0,0,702,5588,1,0,0,0,704,5593,1,0,0,0,706,5598,1,0,0,0,708,5603,1,
  	0,0,0,710,5616,1,0,0,0,712,5620,1,0,0,0,714,5626,1,0,0,0,716,5643,1,0,
  	0,0,718,5660,1,0,0,0,720,5674,1,0,0,0,722,5680,1,0,0,0,724,5687,1,0,0,
  	0,726,5694,1,0,0,0,728,5699,1,0,0,0,730,5704,1,0,0,0,732,5707,1,0,0,0,
  	734,5720,1,0,0,0,736,5728,1,0,0,0,738,5734,1,0,0,0,740,5742,1,0,0,0,742,
  	5747,1,0,0,0,744,5752,1,0,0,0,746,5755,1,0,0,0,748,5765,1,0,0,0,750,5773,
  	1,0,0,0,752,5778,1,0,0,0,754,5783,1,0,0,0,756,5787,1,0,0,0,758,5797,1,
  	0,0,0,760,5802,1,0,0,0,762,5807,1,0,0,0,764,5812,1,0,0,0,766,5819,1,0,
  	0,0,768,5826,1,0,0,0,770,5832,1,0,0,0,772,5838,1,0,0,0,774,5843,1,0,0,
  	0,776,5854,1,0,0,0,778,5858,1,0,0,0,780,5860,1,0,0,0,782,5862,1,0,0,0,
  	784,5865,1,0,0,0,786,5880,1,0,0,0,788,5919,1,0,0,0,790,5923,1,0,0,0,792,
  	5925,1,0,0,0,794,5933,1,0,0,0,796,5937,1,0,0,0,798,5945,1,0,0,0,800,5954,
  	1,0,0,0,802,5956,1,0,0,0,804,5979,1,0,0,0,806,5981,1,0,0,0,808,5983,1,
  	0,0,0,810,5998,1,0,0,0,812,6010,1,0,0,0,814,6012,1,0,0,0,816,6020,1,0,
  	0,0,818,6028,1,0,0,0,820,6037,1,0,0,0,822,6039,1,0,0,0,824,6057,1,0,0,
  	0,826,6071,1,0,0,0,828,6076,1,0,0,0,830,6082,1,0,0,0,832,6084,1,0,0,0,
  	834,6100,1,0,0,0,836,6108,1,0,0,0,838,6118,1,0,0,0,840,6131,1,0,0,0,842,
  	6133,1,0,0,0,844,6139,1,0,0,0,846,6166,1,0,0,0,848,6168,1,0,0,0,850,6171,
  	1,0,0,0,852,6174,1,0,0,0,854,6187,1,0,0,0,856,6203,1,0,0,0,858,6226,1,
  	0,0,0,860,6228,1,0,0,0,862,6265,1,0,0,0,864,6267,1,0,0,0,866,6424,1,0,
  	0,0,868,6437,1,0,0,0,870,6446,1,0,0,0,872,6542,1,0,0,0,874,6544,1,0,0,
  	0,876,6599,1,0,0,0,878,6601,1,0,0,0,880,6606,1,0,0,0,882,6622,1,0,0,0,
  	884,6627,1,0,0,0,886,6629,1,0,0,0,888,6648,1,0,0,0,890,6651,1,0,0,0,892,
  	6660,1,0,0,0,894,6662,1,0,0,0,896,6685,1,0,0,0,898,6965,1,0,0,0,900,6967,
  	1,0,0,0,902,7001,1,0,0,0,904,7003,1,0,0,0,906,7009,1,0,0,0,908,7011,1,
  	0,0,0,910,7026,1,0,0,0,912,7034,1,0,0,0,914,7036,1,0,0,0,916,7065,1,0,
  	0,0,918,7098,1,0,0,0,920,7100,1,0,0,0,922,7108,1,0,0,0,924,7112,1,0,0,
  	0,926,7117,1,0,0,0,928,7119,1,0,0,0,930,7130,1,0,0,0,932,7146,1,0,0,0,
  	934,7148,1,0,0,0,936,7152,1,0,0,0,938,7155,1,0,0,0,940,7158,1,0,0,0,942,
  	7210,1,0,0,0,944,7212,1,0,0,0,946,7223,1,0,0,0,948,7225,1,0,0,0,950,7227,
  	1,0,0,0,952,7231,1,0,0,0,954,7233,1,0,0,0,956,7235,1,0,0,0,958,7239,1,
  	0,0,0,960,7243,1,0,0,0,962,7247,1,0,0,0,964,7255,1,0,0,0,966,7259,1,0,
  	0,0,968,7267,1,0,0,0,970,7269,1,0,0,0,972,7287,1,0,0,0,974,7289,1,0,0,
  	0,976,7292,1,0,0,0,978,7297,1,0,0,0,980,7305,1,0,0,0,982,7311,1,0,0,0,
  	984,7315,1,0,0,0,986,7332,1,0,0,0,988,7335,1,0,0,0,990,7340,1,0,0,0,992,
  	7342,1,0,0,0,994,7345,1,0,0,0,996,7354,1,0,0,0,998,7362,1,0,0,0,1000,
  	7364,1,0,0,0,1002,7369,1,0,0,0,1004,7376,1,0,0,0,1006,7386,1,0,0,0,1008,
  	7394,1,0,0,0,1010,7396,1,0,0,0,1012,7406,1,0,0,0,1014,7414,1,0,0,0,1016,
  	7416,1,0,0,0,1018,7422,1,0,0,0,1020,7443,1,0,0,0,1022,7445,1,0,0,0,1024,
  	7451,1,0,0,0,1026,7454,1,0,0,0,1028,7457,1,0,0,0,1030,7485,1,0,0,0,1032,
  	7489,1,0,0,0,1034,7496,1,0,0,0,1036,7503,1,0,0,0,1038,7505,1,0,0,0,1040,
  	7521,1,0,0,0,1042,7537,1,0,0,0,1044,7541,1,0,0,0,1046,7544,1,0,0,0,1048,
  	7547,1,0,0,0,1050,7571,1,0,0,0,1052,7573,1,0,0,0,1054,7581,1,0,0,0,1056,
  	7583,1,0,0,0,1058,7587,1,0,0,0,1060,7666,1,0,0,0,1062,7668,1,0,0,0,1064,
  	7672,1,0,0,0,1066,7779,1,0,0,0,1068,7781,1,0,0,0,1070,7783,1,0,0,0,1072,
  	7785,1,0,0,0,1074,7790,1,0,0,0,1076,7806,1,0,0,0,1078,7808,1,0,0,0,1080,
  	7842,1,0,0,0,1082,7844,1,0,0,0,1084,7855,1,0,0,0,1086,7862,1,0,0,0,1088,
  	7878,1,0,0,0,1090,7884,1,0,0,0,1092,7886,1,0,0,0,1094,7890,1,0,0,0,1096,
  	7913,1,0,0,0,1098,7915,1,0,0,0,1100,7917,1,0,0,0,1102,7924,1,0,0,0,1104,
  	7926,1,0,0,0,1106,7928,1,0,0,0,1108,8078,1,0,0,0,1110,8083,1,0,0,0,1112,
  	8090,1,0,0,0,1114,8092,1,0,0,0,1116,8100,1,0,0,0,1118,8118,1,0,0,0,1120,
  	8126,1,0,0,0,1122,8134,1,0,0,0,1124,8136,1,0,0,0,1126,8140,1,0,0,0,1128,
  	8149,1,0,0,0,1130,8155,1,0,0,0,1132,8162,1,0,0,0,1134,8164,1,0,0,0,1136,
  	8175,1,0,0,0,1138,8325,1,0,0,0,1140,8329,1,0,0,0,1142,8332,1,0,0,0,1144,
  	8341,1,0,0,0,1146,8350,1,0,0,0,1148,8358,1,0,0,0,1150,8404,1,0,0,0,1152,
  	8406,1,0,0,0,1154,8427,1,0,0,0,1156,8431,1,0,0,0,1158,8442,1,0,0,0,1160,
  	8487,1,0,0,0,1162,8523,1,0,0,0,1164,8525,1,0,0,0,1166,8533,1,0,0,0,1168,
  	8546,1,0,0,0,1170,8548,1,0,0,0,1172,8552,1,0,0,0,1174,8555,1,0,0,0,1176,
  	8560,1,0,0,0,1178,8564,1,0,0,0,1180,8567,1,0,0,0,1182,8570,1,0,0,0,1184,
  	8574,1,0,0,0,1186,8580,1,0,0,0,1188,8588,1,0,0,0,1190,8596,1,0,0,0,1192,
  	8602,1,0,0,0,1194,8605,1,0,0,0,1196,8623,1,0,0,0,1198,8625,1,0,0,0,1200,
  	8631,1,0,0,0,1202,8635,1,0,0,0,1204,8643,1,0,0,0,1206,8651,1,0,0,0,1208,
  	8666,1,0,0,0,1210,8681,1,0,0,0,1212,8683,1,0,0,0,1214,8691,1,0,0,0,1216,
  	8696,1,0,0,0,1218,8700,1,0,0,0,1220,8706,1,0,0,0,1222,8712,1,0,0,0,1224,
  	8719,1,0,0,0,1226,8726,1,0,0,0,1228,8730,1,0,0,0,1230,8749,1,0,0,0,1232,
  	8751,1,0,0,0,1234,8754,1,0,0,0,1236,8757,1,0,0,0,1238,8770,1,0,0,0,1240,
  	8772,1,0,0,0,1242,8777,1,0,0,0,1244,8779,1,0,0,0,1246,8781,1,0,0,0,1248,
  	8783,1,0,0,0,1250,8791,1,0,0,0,1252,8797,1,0,0,0,1254,8799,1,0,0,0,1256,
  	8801,1,0,0,0,1258,8812,1,0,0,0,1260,8816,1,0,0,0,1262,8818,1,0,0,0,1264,
  	8820,1,0,0,0,1266,8822,1,0,0,0,1268,8831,1,0,0,0,1270,8833,1,0,0,0,1272,
  	8835,1,0,0,0,1274,8837,1,0,0,0,1276,8839,1,0,0,0,1278,8841,1,0,0,0,1280,
  	8843,1,0,0,0,1282,8845,1,0,0,0,1284,8849,1,0,0,0,1286,8853,1,0,0,0,1288,
  	8855,1,0,0,0,1290,8857,1,0,0,0,1292,8859,1,0,0,0,1294,8861,1,0,0,0,1296,
  	8863,1,0,0,0,1298,8865,1,0,0,0,1300,8867,1,0,0,0,1302,8869,1,0,0,0,1304,
  	8871,1,0,0,0,1306,8873,1,0,0,0,1308,8877,1,0,0,0,1310,8879,1,0,0,0,1312,
  	8882,1,0,0,0,1314,8894,1,0,0,0,1316,8896,1,0,0,0,1318,8904,1,0,0,0,1320,
  	8912,1,0,0,0,1322,8916,1,0,0,0,1324,8918,1,0,0,0,1326,8922,1,0,0,0,1328,
  	8924,1,0,0,0,1330,8926,1,0,0,0,1332,8928,1,0,0,0,1334,8930,1,0,0,0,1336,
  	8935,1,0,0,0,1338,8939,1,0,0,0,1340,8941,1,0,0,0,1342,8949,1,0,0,0,1344,
  	8953,1,0,0,0,1346,8968,1,0,0,0,1348,8970,1,0,0,0,1350,8973,1,0,0,0,1352,
  	8975,1,0,0,0,1354,8977,1,0,0,0,1356,8984,1,0,0,0,1358,8991,1,0,0,0,1360,
  	8996,1,0,0,0,1362,9007,1,0,0,0,1364,9012,1,0,0,0,1366,9014,1,0,0,0,1368,
  	9016,1,0,0,0,1370,9030,1,0,0,0,1372,9035,1,0,0,0,1374,9040,1,0,0,0,1376,
  	9047,1,0,0,0,1378,9055,1,0,0,0,1380,9057,1,0,0,0,1382,9068,1,0,0,0,1384,
  	9070,1,0,0,0,1386,9072,1,0,0,0,1388,9074,1,0,0,0,1390,9082,1,0,0,0,1392,
  	9086,1,0,0,0,1394,9088,1,0,0,0,1396,9090,1,0,0,0,1398,9098,1,0,0,0,1400,
  	9102,1,0,0,0,1402,9106,1,0,0,0,1404,9110,1,0,0,0,1406,9112,1,0,0,0,1408,
  	9115,1,0,0,0,1410,9124,1,0,0,0,1412,9132,1,0,0,0,1414,9141,1,0,0,0,1416,
  	9145,1,0,0,0,1418,9164,1,0,0,0,1420,9166,1,0,0,0,1422,9168,1,0,0,0,1424,
  	9188,1,0,0,0,1426,9190,1,0,0,0,1428,9195,1,0,0,0,1430,9207,1,0,0,0,1432,
  	9213,1,0,0,0,1434,9215,1,0,0,0,1436,9222,1,0,0,0,1438,9235,1,0,0,0,1440,
  	1443,3,2,1,0,1441,1443,3,430,215,0,1442,1440,1,0,0,0,1442,1441,1,0,0,
  	0,1443,1445,1,0,0,0,1444,1446,5,774,0,0,1445,1444,1,0,0,0,1445,1446,1,
  	0,0,0,1446,1448,1,0,0,0,1447,1442,1,0,0,0,1447,1448,1,0,0,0,1448,1449,
  	1,0,0,0,1449,1450,5,0,0,1,1450,1,1,0,0,0,1451,1529,3,4,2,0,1452,1529,
  	3,80,40,0,1453,1529,3,184,92,0,1454,1529,3,216,108,0,1455,1529,3,220,
  	110,0,1456,1457,4,1,0,0,1457,1529,3,222,111,0,1458,1529,3,224,112,0,1459,
  	1529,3,226,113,0,1460,1529,3,232,116,0,1461,1529,3,234,117,0,1462,1529,
  	3,238,119,0,1463,1529,3,258,129,0,1464,1529,3,270,135,0,1465,1529,3,272,
  	136,0,1466,1529,3,424,212,0,1467,1529,3,426,213,0,1468,1529,3,448,224,
  	0,1469,1529,3,576,288,0,1470,1471,4,1,1,0,1471,1529,3,582,291,0,1472,
  	1529,3,588,294,0,1473,1529,3,656,328,0,1474,1529,3,664,332,0,1475,1529,
  	3,666,333,0,1476,1529,3,688,344,0,1477,1529,3,690,345,0,1478,1529,3,692,
  	346,0,1479,1529,3,694,347,0,1480,1529,3,696,348,0,1481,1529,3,698,349,
  	0,1482,1529,3,700,350,0,1483,1529,3,702,351,0,1484,1529,3,704,352,0,1485,
  	1529,3,706,353,0,1486,1529,3,708,354,0,1487,1529,3,710,355,0,1488,1529,
  	3,712,356,0,1489,1529,3,714,357,0,1490,1529,3,716,358,0,1491,1529,3,718,
  	359,0,1492,1529,3,720,360,0,1493,1529,3,722,361,0,1494,1529,3,724,362,
  	0,1495,1529,3,726,363,0,1496,1529,3,728,364,0,1497,1529,3,730,365,0,1498,
  	1529,3,732,366,0,1499,1529,3,734,367,0,1500,1529,3,736,368,0,1501,1529,
  	3,738,369,0,1502,1529,3,740,370,0,1503,1529,3,742,371,0,1504,1529,3,744,
  	372,0,1505,1529,3,746,373,0,1506,1529,3,748,374,0,1507,1529,3,750,375,
  	0,1508,1529,3,752,376,0,1509,1529,3,754,377,0,1510,1529,3,756,378,0,1511,
  	1529,3,758,379,0,1512,1529,3,760,380,0,1513,1529,3,762,381,0,1514,1529,
  	3,764,382,0,1515,1529,3,766,383,0,1516,1529,3,768,384,0,1517,1529,3,770,
  	385,0,1518,1529,3,772,386,0,1519,1520,4,1,2,0,1520,1529,3,774,387,0,1521,
  	1522,4,1,3,0,1522,1529,3,820,410,0,1523,1529,3,788,394,0,1524,1529,3,
  	840,420,0,1525,1529,3,1028,514,0,1526,1529,3,1038,519,0,1527,1529,3,1040,
  	520,0,1528,1451,1,0,0,0,1528,1452,1,0,0,0,1528,1453,1,0,0,0,1528,1454,
  	1,0,0,0,1528,1455,1,0,0,0,1528,1456,1,0,0,0,1528,1458,1,0,0,0,1528,1459,
  	1,0,0,0,1528,1460,1,0,0,0,1528,1461,1,0,0,0,1528,1462,1,0,0,0,1528,1463,
  	1,0,0,0,1528,1464,1,0,0,0,1528,1465,1,0,0,0,1528,1466,1,0,0,0,1528,1467,
  	1,0,0,0,1528,1468,1,0,0,0,1528,1469,1,0,0,0,1528,1470,1,0,0,0,1528,1472,
  	1,0,0,0,1528,1473,1,0,0,0,1528,1474,1,0,0,0,1528,1475,1,0,0,0,1528,1476,
  	1,0,0,0,1528,1477,1,0,0,0,1528,1478,1,0,0,0,1528,1479,1,0,0,0,1528,1480,
  	1,0,0,0,1528,1481,1,0,0,0,1528,1482,1,0,0,0,1528,1483,1,0,0,0,1528,1484,
  	1,0,0,0,1528,1485,1,0,0,0,1528,1486,1,0,0,0,1528,1487,1,0,0,0,1528,1488,
  	1,0,0,0,1528,1489,1,0,0,0,1528,1490,1,0,0,0,1528,1491,1,0,0,0,1528,1492,
  	1,0,0,0,1528,1493,1,0,0,0,1528,1494,1,0,0,0,1528,1495,1,0,0,0,1528,1496,
  	1,0,0,0,1528,1497,1,0,0,0,1528,1498,1,0,0,0,1528,1499,1,0,0,0,1528,1500,
  	1,0,0,0,1528,1501,1,0,0,0,1528,1502,1,0,0,0,1528,1503,1,0,0,0,1528,1504,
  	1,0,0,0,1528,1505,1,0,0,0,1528,1506,1,0,0,0,1528,1507,1,0,0,0,1528,1508,
  	1,0,0,0,1528,1509,1,0,0,0,1528,1510,1,0,0,0,1528,1511,1,0,0,0,1528,1512,
  	1,0,0,0,1528,1513,1,0,0,0,1528,1514,1,0,0,0,1528,1515,1,0,0,0,1528,1516,
  	1,0,0,0,1528,1517,1,0,0,0,1528,1518,1,0,0,0,1528,1519,1,0,0,0,1528,1521,
  	1,0,0,0,1528,1523,1,0,0,0,1528,1524,1,0,0,0,1528,1525,1,0,0,0,1528,1526,
  	1,0,0,0,1528,1527,1,0,0,0,1529,3,1,0,0,0,1530,1551,5,11,0,0,1531,1552,
  	3,20,10,0,1532,1552,3,6,3,0,1533,1534,5,422,0,0,1534,1536,3,1274,637,
  	0,1535,1537,3,106,53,0,1536,1535,1,0,0,0,1536,1537,1,0,0,0,1537,1552,
  	1,0,0,0,1538,1539,5,206,0,0,1539,1541,3,1278,639,0,1540,1542,3,106,53,
  	0,1541,1540,1,0,0,0,1541,1542,1,0,0,0,1542,1552,1,0,0,0,1543,1552,3,70,
  	35,0,1544,1552,3,10,5,0,1545,1552,3,56,28,0,1546,1547,4,2,4,0,1547,1552,
  	3,58,29,0,1548,1552,3,12,6,0,1549,1552,3,18,9,0,1550,1552,3,78,39,0,1551,
  	1531,1,0,0,0,1551,1532,1,0,0,0,1551,1533,1,0,0,0,1551,1538,1,0,0,0,1551,
  	1543,1,0,0,0,1551,1544,1,0,0,0,1551,1545,1,0,0,0,1551,1546,1,0,0,0,1551,
  	1548,1,0,0,0,1551,1549,1,0,0,0,1551,1550,1,0,0,0,1552,5,1,0,0,0,1553,
  	1554,5,109,0,0,1554,1565,3,1270,635,0,1555,1557,3,8,4,0,1556,1555,1,0,
  	0,0,1557,1558,1,0,0,0,1558,1556,1,0,0,0,1558,1559,1,0,0,0,1559,1566,1,
  	0,0,0,1560,1561,4,3,5,0,1561,1562,5,615,0,0,1562,1563,5,112,0,0,1563,
  	1564,5,139,0,0,1564,1566,5,357,0,0,1565,1556,1,0,0,0,1565,1560,1,0,0,
  	0,1566,7,1,0,0,0,1567,1575,3,84,42,0,1568,1569,5,435,0,0,1569,1571,5,
  	386,0,0,1570,1572,5,750,0,0,1571,1570,1,0,0,0,1571,1572,1,0,0,0,1572,
  	1573,1,0,0,0,1573,1575,3,1140,570,0,1574,1567,1,0,0,0,1574,1568,1,0,0,
  	0,1575,9,1,0,0,0,1576,1578,3,1170,585,0,1577,1576,1,0,0,0,1577,1578,1,
  	0,0,0,1578,1579,1,0,0,0,1579,1580,5,170,0,0,1580,1584,3,1298,649,0,1581,
  	1582,5,383,0,0,1582,1583,5,490,0,0,1583,1585,3,1050,525,0,1584,1581,1,
  	0,0,0,1584,1585,1,0,0,0,1585,1592,1,0,0,0,1586,1587,5,383,0,0,1587,1589,
  	5,79,0,0,1588,1590,5,371,0,0,1589,1588,1,0,0,0,1589,1590,1,0,0,0,1590,
  	1591,1,0,0,0,1591,1593,5,418,0,0,1592,1586,1,0,0,0,1592,1593,1,0,0,0,
  	1593,1597,1,0,0,0,1594,1595,5,453,0,0,1595,1596,5,590,0,0,1596,1598,3,
  	1338,669,0,1597,1594,1,0,0,0,1597,1598,1,0,0,0,1598,1605,1,0,0,0,1599,
  	1606,5,156,0,0,1600,1603,5,140,0,0,1601,1602,5,383,0,0,1602,1604,3,574,
  	287,0,1603,1601,1,0,0,0,1603,1604,1,0,0,0,1604,1606,1,0,0,0,1605,1599,
  	1,0,0,0,1605,1600,1,0,0,0,1605,1606,1,0,0,0,1606,1609,1,0,0,0,1607,1608,
  	5,75,0,0,1608,1610,3,1376,688,0,1609,1607,1,0,0,0,1609,1610,1,0,0,0,1610,
  	1613,1,0,0,0,1611,1612,5,147,0,0,1612,1614,3,972,486,0,1613,1611,1,0,
  	0,0,1613,1614,1,0,0,0,1614,11,1,0,0,0,1615,1616,5,288,0,0,1616,1617,5,
  	217,0,0,1617,1618,3,1294,647,0,1618,1619,5,4,0,0,1619,1620,5,603,0,0,
  	1620,1622,3,1376,688,0,1621,1623,3,14,7,0,1622,1621,1,0,0,0,1622,1623,
  	1,0,0,0,1623,13,1,0,0,0,1624,1631,3,16,8,0,1625,1627,5,773,0,0,1626,1625,
  	1,0,0,0,1626,1627,1,0,0,0,1627,1628,1,0,0,0,1628,1630,3,16,8,0,1629,1626,
  	1,0,0,0,1630,1633,1,0,0,0,1631,1629,1,0,0,0,1631,1632,1,0,0,0,1632,15,
  	1,0,0,0,1633,1631,1,0,0,0,1634,1638,3,140,70,0,1635,1638,3,152,76,0,1636,
  	1638,3,154,77,0,1637,1634,1,0,0,0,1637,1635,1,0,0,0,1637,1636,1,0,0,0,
  	1638,17,1,0,0,0,1639,1640,5,503,0,0,1640,1641,3,1304,652,0,1641,1642,
  	3,124,62,0,1642,19,1,0,0,0,1643,1645,3,1244,622,0,1644,1643,1,0,0,0,1644,
  	1645,1,0,0,0,1645,1646,1,0,0,0,1646,1647,5,574,0,0,1647,1649,3,1314,657,
  	0,1648,1650,3,22,11,0,1649,1648,1,0,0,0,1649,1650,1,0,0,0,1650,21,1,0,
  	0,0,1651,1654,3,24,12,0,1652,1655,3,1148,574,0,1653,1655,3,52,26,0,1654,
  	1652,1,0,0,0,1654,1653,1,0,0,0,1654,1655,1,0,0,0,1655,1665,1,0,0,0,1656,
  	1665,3,1148,574,0,1657,1665,3,52,26,0,1658,1659,3,26,13,0,1659,1660,5,
  	773,0,0,1660,1662,1,0,0,0,1661,1658,1,0,0,0,1661,1662,1,0,0,0,1662,1663,
  	1,0,0,0,1663,1665,3,28,14,0,1664,1651,1,0,0,0,1664,1656,1,0,0,0,1664,
  	1657,1,0,0,0,1664,1661,1,0,0,0,1665,23,1,0,0,0,1666,1674,3,26,13,0,1667,
  	1668,3,26,13,0,1668,1669,5,773,0,0,1669,1671,1,0,0,0,1670,1667,1,0,0,
  	0,1670,1671,1,0,0,0,1671,1672,1,0,0,0,1672,1674,3,32,16,0,1673,1666,1,
  	0,0,0,1673,1670,1,0,0,0,1674,25,1,0,0,0,1675,1680,3,34,17,0,1676,1677,
  	5,773,0,0,1677,1679,3,34,17,0,1678,1676,1,0,0,0,1679,1682,1,0,0,0,1680,
  	1678,1,0,0,0,1680,1681,1,0,0,0,1681,27,1,0,0,0,1682,1680,1,0,0,0,1683,
  	1684,5,141,0,0,1684,1691,5,572,0,0,1685,1686,5,234,0,0,1686,1691,5,572,
  	0,0,1687,1691,3,30,15,0,1688,1689,4,14,6,0,1689,1691,7,0,0,0,1690,1683,
  	1,0,0,0,1690,1685,1,0,0,0,1690,1687,1,0,0,0,1690,1688,1,0,0,0,1691,29,
  	1,0,0,0,1692,1693,5,4,0,0,1693,1695,5,405,0,0,1694,1696,3,1246,623,0,
  	1695,1694,1,0,0,0,1695,1696,1,0,0,0,1696,1700,1,0,0,0,1697,1701,3,1156,
  	578,0,1698,1699,5,404,0,0,1699,1701,3,1352,676,0,1700,1697,1,0,0,0,1700,
  	1698,1,0,0,0,1701,1789,1,0,0,0,1702,1703,5,148,0,0,1703,1704,5,405,0,
  	0,1704,1789,3,1340,670,0,1705,1706,5,438,0,0,1706,1708,5,405,0,0,1707,
  	1709,3,1246,623,0,1708,1707,1,0,0,0,1708,1709,1,0,0,0,1709,1710,1,0,0,
  	0,1710,1789,3,54,27,0,1711,1712,5,388,0,0,1712,1714,5,405,0,0,1713,1715,
  	3,1246,623,0,1714,1713,1,0,0,0,1714,1715,1,0,0,0,1715,1716,1,0,0,0,1716,
  	1718,3,54,27,0,1717,1719,3,1246,623,0,1718,1717,1,0,0,0,1718,1719,1,0,
  	0,0,1719,1789,1,0,0,0,1720,1721,5,14,0,0,1721,1723,5,405,0,0,1722,1724,
  	3,1246,623,0,1723,1722,1,0,0,0,1723,1724,1,0,0,0,1724,1725,1,0,0,0,1725,
  	1789,3,54,27,0,1726,1727,5,62,0,0,1727,1728,5,405,0,0,1728,1732,3,54,
  	27,0,1729,1731,3,660,330,0,1730,1729,1,0,0,0,1731,1734,1,0,0,0,1732,1730,
  	1,0,0,0,1732,1733,1,0,0,0,1733,1789,1,0,0,0,1734,1732,1,0,0,0,1735,1736,
  	5,455,0,0,1736,1738,5,405,0,0,1737,1739,3,1246,623,0,1738,1737,1,0,0,
  	0,1738,1739,1,0,0,0,1739,1740,1,0,0,0,1740,1744,3,54,27,0,1741,1743,3,
  	662,331,0,1742,1741,1,0,0,0,1743,1746,1,0,0,0,1744,1742,1,0,0,0,1744,
  	1745,1,0,0,0,1745,1789,1,0,0,0,1746,1744,1,0,0,0,1747,1748,5,67,0,0,1748,
  	1750,5,405,0,0,1749,1751,3,1246,623,0,1750,1749,1,0,0,0,1750,1751,1,0,
  	0,0,1751,1752,1,0,0,0,1752,1789,3,1352,676,0,1753,1754,5,597,0,0,1754,
  	1755,5,405,0,0,1755,1789,3,54,27,0,1756,1757,5,454,0,0,1757,1759,5,405,
  	0,0,1758,1760,3,1246,623,0,1759,1758,1,0,0,0,1759,1760,1,0,0,0,1760,1765,
  	1,0,0,0,1761,1762,3,1340,670,0,1762,1763,5,248,0,0,1763,1764,3,1156,578,
  	0,1764,1766,1,0,0,0,1765,1761,1,0,0,0,1765,1766,1,0,0,0,1766,1789,1,0,
  	0,0,1767,1768,5,172,0,0,1768,1769,5,405,0,0,1769,1770,3,1338,669,0,1770,
  	1771,5,645,0,0,1771,1772,5,574,0,0,1772,1774,3,1314,657,0,1773,1775,3,
  	50,25,0,1774,1773,1,0,0,0,1774,1775,1,0,0,0,1775,1789,1,0,0,0,1776,1777,
  	4,15,7,0,1777,1778,5,141,0,0,1778,1779,5,405,0,0,1779,1780,3,54,27,0,
  	1780,1781,5,572,0,0,1781,1789,1,0,0,0,1782,1783,4,15,8,0,1783,1784,5,
  	234,0,0,1784,1785,5,405,0,0,1785,1786,3,54,27,0,1786,1787,5,572,0,0,1787,
  	1789,1,0,0,0,1788,1692,1,0,0,0,1788,1702,1,0,0,0,1788,1705,1,0,0,0,1788,
  	1711,1,0,0,0,1788,1720,1,0,0,0,1788,1726,1,0,0,0,1788,1735,1,0,0,0,1788,
  	1747,1,0,0,0,1788,1753,1,0,0,0,1788,1756,1,0,0,0,1788,1767,1,0,0,0,1788,
  	1776,1,0,0,0,1788,1782,1,0,0,0,1789,31,1,0,0,0,1790,1793,3,36,18,0,1791,
  	1793,3,1136,568,0,1792,1790,1,0,0,0,1792,1791,1,0,0,0,1793,1802,1,0,0,
  	0,1794,1798,5,773,0,0,1795,1799,3,36,18,0,1796,1799,3,34,17,0,1797,1799,
  	3,1136,568,0,1798,1795,1,0,0,0,1798,1796,1,0,0,0,1798,1797,1,0,0,0,1799,
  	1801,1,0,0,0,1800,1794,1,0,0,0,1801,1804,1,0,0,0,1802,1800,1,0,0,0,1802,
  	1803,1,0,0,0,1803,33,1,0,0,0,1804,1802,1,0,0,0,1805,1809,3,44,22,0,1806,
  	1809,3,46,23,0,1807,1809,3,50,25,0,1808,1805,1,0,0,0,1808,1806,1,0,0,
  	0,1808,1807,1,0,0,0,1809,35,1,0,0,0,1810,1812,5,4,0,0,1811,1813,5,72,
  	0,0,1812,1811,1,0,0,0,1812,1813,1,0,0,0,1813,1826,1,0,0,0,1814,1815,3,
  	1338,669,0,1815,1817,3,1064,532,0,1816,1818,3,1054,527,0,1817,1816,1,
  	0,0,0,1817,1818,1,0,0,0,1818,1820,1,0,0,0,1819,1821,3,38,19,0,1820,1819,
  	1,0,0,0,1820,1821,1,0,0,0,1821,1827,1,0,0,0,1822,1823,5,776,0,0,1823,
  	1824,3,88,44,0,1824,1825,5,777,0,0,1825,1827,1,0,0,0,1826,1814,1,0,0,
  	0,1826,1822,1,0,0,0,1827,1951,1,0,0,0,1828,1829,5,4,0,0,1829,1951,3,1060,
  	530,0,1830,1832,5,55,0,0,1831,1833,5,72,0,0,1832,1831,1,0,0,0,1832,1833,
  	1,0,0,0,1833,1834,1,0,0,0,1834,1835,3,1254,627,0,1835,1836,3,1338,669,
  	0,1836,1838,3,1064,532,0,1837,1839,3,38,19,0,1838,1837,1,0,0,0,1838,1839,
  	1,0,0,0,1839,1951,1,0,0,0,1840,1842,5,348,0,0,1841,1843,5,72,0,0,1842,
  	1841,1,0,0,0,1842,1843,1,0,0,0,1843,1844,1,0,0,0,1844,1845,3,1254,627,
  	0,1845,1847,3,1064,532,0,1846,1848,3,38,19,0,1847,1846,1,0,0,0,1847,1848,
  	1,0,0,0,1848,1951,1,0,0,0,1849,1871,5,148,0,0,1850,1852,5,72,0,0,1851,
  	1850,1,0,0,0,1851,1852,1,0,0,0,1852,1853,1,0,0,0,1853,1855,3,1254,627,
  	0,1854,1856,3,40,20,0,1855,1854,1,0,0,0,1855,1856,1,0,0,0,1856,1872,1,
  	0,0,0,1857,1858,5,199,0,0,1858,1859,5,265,0,0,1859,1872,3,1254,627,0,
  	1860,1861,5,420,0,0,1861,1872,5,265,0,0,1862,1863,3,414,207,0,1863,1864,
  	3,1264,632,0,1864,1872,1,0,0,0,1865,1866,4,18,9,0,1866,1867,5,62,0,0,
  	1867,1872,3,1338,669,0,1868,1869,4,18,10,0,1869,1870,5,86,0,0,1870,1872,
  	3,1338,669,0,1871,1851,1,0,0,0,1871,1857,1,0,0,0,1871,1860,1,0,0,0,1871,
  	1862,1,0,0,0,1871,1865,1,0,0,0,1871,1868,1,0,0,0,1872,1951,1,0,0,0,1873,
  	1874,5,140,0,0,1874,1951,5,263,0,0,1875,1876,5,156,0,0,1876,1951,5,263,
  	0,0,1877,1879,5,11,0,0,1878,1880,5,72,0,0,1879,1878,1,0,0,0,1879,1880,
  	1,0,0,0,1880,1881,1,0,0,0,1881,1894,3,1254,627,0,1882,1883,5,506,0,0,
  	1883,1887,5,128,0,0,1884,1885,4,18,11,0,1885,1888,3,958,479,0,1886,1888,
  	3,1360,680,0,1887,1884,1,0,0,0,1887,1886,1,0,0,0,1888,1895,1,0,0,0,1889,
  	1890,5,148,0,0,1890,1895,5,128,0,0,1891,1892,4,18,12,0,1892,1893,5,506,
  	0,0,1893,1895,3,1098,549,0,1894,1882,1,0,0,0,1894,1889,1,0,0,0,1894,1891,
  	1,0,0,0,1895,1951,1,0,0,0,1896,1897,4,18,13,0,1897,1898,5,11,0,0,1898,
  	1899,5,236,0,0,1899,1900,3,1264,632,0,1900,1901,3,1098,549,0,1901,1951,
  	1,0,0,0,1902,1903,4,18,14,0,1903,1904,5,11,0,0,1904,1905,5,62,0,0,1905,
  	1906,3,1338,669,0,1906,1907,3,1058,529,0,1907,1951,1,0,0,0,1908,1909,
  	4,18,15,0,1909,1910,5,11,0,0,1910,1911,5,86,0,0,1911,1912,3,1338,669,
  	0,1912,1913,3,1058,529,0,1913,1951,1,0,0,0,1914,1915,4,18,16,0,1915,1916,
  	5,453,0,0,1916,1917,5,72,0,0,1917,1918,3,1254,627,0,1918,1919,5,590,0,
  	0,1919,1920,3,1338,669,0,1920,1951,1,0,0,0,1921,1923,5,453,0,0,1922,1924,
  	7,1,0,0,1923,1922,1,0,0,0,1923,1924,1,0,0,0,1924,1925,1,0,0,0,1925,1951,
  	3,1308,654,0,1926,1927,5,453,0,0,1927,1928,3,414,207,0,1928,1929,3,1264,
  	632,0,1929,1930,5,590,0,0,1930,1931,3,1262,631,0,1931,1951,1,0,0,0,1932,
  	1933,5,94,0,0,1933,1934,5,590,0,0,1934,1938,3,946,473,0,1935,1936,4,18,
  	17,0,1936,1939,5,128,0,0,1937,1939,3,1130,565,0,1938,1935,1,0,0,0,1938,
  	1937,1,0,0,0,1939,1941,1,0,0,0,1940,1942,3,1180,590,0,1941,1940,1,0,0,
  	0,1941,1942,1,0,0,0,1942,1951,1,0,0,0,1943,1951,5,198,0,0,1944,1945,5,
  	393,0,0,1945,1946,5,45,0,0,1946,1951,3,42,21,0,1947,1948,4,18,18,0,1948,
  	1949,5,615,0,0,1949,1951,5,403,0,0,1950,1810,1,0,0,0,1950,1828,1,0,0,
  	0,1950,1830,1,0,0,0,1950,1840,1,0,0,0,1950,1849,1,0,0,0,1950,1873,1,0,
  	0,0,1950,1875,1,0,0,0,1950,1877,1,0,0,0,1950,1896,1,0,0,0,1950,1902,1,
  	0,0,0,1950,1908,1,0,0,0,1950,1914,1,0,0,0,1950,1921,1,0,0,0,1950,1926,
  	1,0,0,0,1950,1932,1,0,0,0,1950,1943,1,0,0,0,1950,1944,1,0,0,0,1950,1947,
  	1,0,0,0,1951,37,1,0,0,0,1952,1953,5,6,0,0,1953,1956,3,1338,669,0,1954,
  	1956,5,191,0,0,1955,1952,1,0,0,0,1955,1954,1,0,0,0,1956,39,1,0,0,0,1957,
  	1958,7,2,0,0,1958,41,1,0,0,0,1959,1961,3,1338,669,0,1960,1962,3,336,168,
  	0,1961,1960,1,0,0,0,1961,1962,1,0,0,0,1962,1970,1,0,0,0,1963,1964,5,773,
  	0,0,1964,1966,3,1338,669,0,1965,1967,3,336,168,0,1966,1965,1,0,0,0,1966,
  	1967,1,0,0,0,1967,1969,1,0,0,0,1968,1963,1,0,0,0,1969,1972,1,0,0,0,1970,
  	1968,1,0,0,0,1970,1971,1,0,0,0,1971,43,1,0,0,0,1972,1970,1,0,0,0,1973,
  	1975,5,9,0,0,1974,1976,5,750,0,0,1975,1974,1,0,0,0,1975,1976,1,0,0,0,
  	1976,1979,1,0,0,0,1977,1980,5,128,0,0,1978,1980,3,1338,669,0,1979,1977,
  	1,0,0,0,1979,1978,1,0,0,0,1980,45,1,0,0,0,1981,1983,5,287,0,0,1982,1984,
  	5,750,0,0,1983,1982,1,0,0,0,1983,1984,1,0,0,0,1984,1987,1,0,0,0,1985,
  	1988,5,128,0,0,1986,1988,3,1338,669,0,1987,1985,1,0,0,0,1987,1986,1,0,
  	0,0,1988,47,1,0,0,0,1989,1991,3,44,22,0,1990,1992,3,46,23,0,1991,1990,
  	1,0,0,0,1991,1992,1,0,0,0,1992,1998,1,0,0,0,1993,1995,3,46,23,0,1994,
  	1996,3,44,22,0,1995,1994,1,0,0,0,1995,1996,1,0,0,0,1996,1998,1,0,0,0,
  	1997,1989,1,0,0,0,1997,1993,1,0,0,0,1998,49,1,0,0,0,1999,2000,4,25,19,
  	0,2000,2001,7,3,0,0,2001,2002,5,625,0,0,2002,51,1,0,0,0,2003,2004,5,452,
  	0,0,2004,2005,5,403,0,0,2005,53,1,0,0,0,2006,2009,5,10,0,0,2007,2009,
  	3,1340,670,0,2008,2006,1,0,0,0,2008,2007,1,0,0,0,2009,55,1,0,0,0,2010,
  	2011,5,572,0,0,2011,2023,3,1290,645,0,2012,2013,7,4,0,0,2013,2014,5,111,
  	0,0,2014,2016,3,1376,688,0,2015,2017,3,64,32,0,2016,2015,1,0,0,0,2016,
  	2017,1,0,0,0,2017,2024,1,0,0,0,2018,2019,5,453,0,0,2019,2020,5,590,0,
  	0,2020,2024,3,1338,669,0,2021,2022,4,28,20,0,2022,2024,3,64,32,0,2023,
  	2012,1,0,0,0,2023,2018,1,0,0,0,2023,2021,1,0,0,0,2024,57,1,0,0,0,2025,
  	2026,5,605,0,0,2026,2027,5,572,0,0,2027,2028,3,1290,645,0,2028,2029,5,
  	506,0,0,2029,2031,7,5,0,0,2030,2032,3,60,30,0,2031,2030,1,0,0,0,2031,
  	2032,1,0,0,0,2032,59,1,0,0,0,2033,2040,3,62,31,0,2034,2036,5,773,0,0,
  	2035,2034,1,0,0,0,2035,2036,1,0,0,0,2036,2037,1,0,0,0,2037,2039,3,62,
  	31,0,2038,2035,1,0,0,0,2039,2042,1,0,0,0,2040,2038,1,0,0,0,2040,2041,
  	1,0,0,0,2041,61,1,0,0,0,2042,2040,1,0,0,0,2043,2044,3,152,76,0,2044,63,
  	1,0,0,0,2045,2052,3,66,33,0,2046,2048,5,773,0,0,2047,2046,1,0,0,0,2047,
  	2048,1,0,0,0,2048,2049,1,0,0,0,2049,2051,3,66,33,0,2050,2047,1,0,0,0,
  	2051,2054,1,0,0,0,2052,2050,1,0,0,0,2052,2053,1,0,0,0,2053,65,1,0,0,0,
  	2054,2052,1,0,0,0,2055,2057,5,238,0,0,2056,2058,5,750,0,0,2057,2056,1,
  	0,0,0,2057,2058,1,0,0,0,2058,2059,1,0,0,0,2059,2068,3,1404,702,0,2060,
  	2068,3,144,72,0,2061,2068,3,146,73,0,2062,2068,3,152,76,0,2063,2068,3,
  	154,77,0,2064,2068,3,160,80,0,2065,2066,4,33,21,0,2066,2068,3,162,81,
  	0,2067,2055,1,0,0,0,2067,2060,1,0,0,0,2067,2061,1,0,0,0,2067,2062,1,0,
  	0,0,2067,2063,1,0,0,0,2067,2064,1,0,0,0,2067,2065,1,0,0,0,2068,67,1,0,
  	0,0,2069,2071,5,238,0,0,2070,2072,5,750,0,0,2071,2070,1,0,0,0,2071,2072,
  	1,0,0,0,2072,2073,1,0,0,0,2073,2077,3,1404,702,0,2074,2077,3,144,72,0,
  	2075,2077,3,146,73,0,2076,2069,1,0,0,0,2076,2074,1,0,0,0,2076,2075,1,
  	0,0,0,2077,69,1,0,0,0,2078,2080,3,168,84,0,2079,2078,1,0,0,0,2079,2080,
  	1,0,0,0,2080,2082,1,0,0,0,2081,2083,3,1170,585,0,2082,2081,1,0,0,0,2082,
  	2083,1,0,0,0,2083,2085,1,0,0,0,2084,2086,3,170,85,0,2085,2084,1,0,0,0,
  	2085,2086,1,0,0,0,2086,2087,1,0,0,0,2087,2088,5,636,0,0,2088,2089,3,1286,
  	643,0,2089,2090,3,72,36,0,2090,71,1,0,0,0,2091,2093,3,1256,628,0,2092,
  	2091,1,0,0,0,2092,2093,1,0,0,0,2093,2094,1,0,0,0,2094,2095,5,17,0,0,2095,
  	2096,3,74,37,0,2096,73,1,0,0,0,2097,2099,3,94,47,0,2098,2100,3,76,38,
  	0,2099,2098,1,0,0,0,2099,2100,1,0,0,0,2100,75,1,0,0,0,2101,2103,5,645,
  	0,0,2102,2104,7,6,0,0,2103,2102,1,0,0,0,2103,2104,1,0,0,0,2104,2105,1,
  	0,0,0,2105,2106,5,62,0,0,2106,2107,5,391,0,0,2107,77,1,0,0,0,2108,2109,
  	4,39,22,0,2109,2138,5,244,0,0,2110,2111,5,482,0,0,2111,2112,3,1398,699,
  	0,2112,2113,5,316,0,0,2113,2114,5,265,0,0,2114,2139,1,0,0,0,2115,2116,
  	4,39,23,0,2116,2117,5,451,0,0,2117,2122,5,795,0,0,2118,2119,4,39,24,0,
  	2119,2120,5,200,0,0,2120,2121,5,57,0,0,2121,2123,3,1338,669,0,2122,2118,
  	1,0,0,0,2122,2123,1,0,0,0,2123,2128,1,0,0,0,2124,2125,5,373,0,0,2125,
  	2126,5,480,0,0,2126,2127,5,383,0,0,2127,2129,5,165,0,0,2128,2124,1,0,
  	0,0,2128,2129,1,0,0,0,2129,2139,1,0,0,0,2130,2131,4,39,25,0,2131,2132,
  	7,7,0,0,2132,2133,3,1338,669,0,2133,2134,3,1338,669,0,2134,2139,1,0,0,
  	0,2135,2136,4,39,26,0,2136,2137,5,451,0,0,2137,2139,5,833,0,0,2138,2110,
  	1,0,0,0,2138,2115,1,0,0,0,2138,2130,1,0,0,0,2138,2135,1,0,0,0,2139,2142,
  	1,0,0,0,2140,2142,1,0,0,0,2141,2108,1,0,0,0,2141,2140,1,0,0,0,2142,79,
  	1,0,0,0,2143,2162,5,97,0,0,2144,2163,3,82,41,0,2145,2163,3,86,43,0,2146,
  	2163,3,100,50,0,2147,2163,3,98,49,0,2148,2163,3,102,51,0,2149,2163,3,
  	116,58,0,2150,2163,3,164,82,0,2151,2163,3,172,86,0,2152,2163,3,110,55,
  	0,2153,2163,3,122,61,0,2154,2163,3,128,64,0,2155,2163,3,176,88,0,2156,
  	2157,4,40,27,0,2157,2163,3,178,89,0,2158,2159,4,40,28,0,2159,2163,3,180,
  	90,0,2160,2161,4,40,29,0,2161,2163,3,130,65,0,2162,2144,1,0,0,0,2162,
  	2145,1,0,0,0,2162,2146,1,0,0,0,2162,2147,1,0,0,0,2162,2148,1,0,0,0,2162,
  	2149,1,0,0,0,2162,2150,1,0,0,0,2162,2151,1,0,0,0,2162,2152,1,0,0,0,2162,
  	2153,1,0,0,0,2162,2154,1,0,0,0,2162,2155,1,0,0,0,2162,2156,1,0,0,0,2162,
  	2158,1,0,0,0,2162,2160,1,0,0,0,2163,81,1,0,0,0,2164,2166,5,109,0,0,2165,
  	2167,3,1174,587,0,2166,2165,1,0,0,0,2166,2167,1,0,0,0,2167,2168,1,0,0,
  	0,2168,2172,3,1268,634,0,2169,2171,3,84,42,0,2170,2169,1,0,0,0,2171,2174,
  	1,0,0,0,2172,2170,1,0,0,0,2172,2173,1,0,0,0,2173,83,1,0,0,0,2174,2172,
  	1,0,0,0,2175,2180,3,1146,573,0,2176,2180,3,1142,571,0,2177,2178,4,42,
  	30,0,2178,2180,3,1144,572,0,2179,2175,1,0,0,0,2179,2176,1,0,0,0,2179,
  	2177,1,0,0,0,2180,85,1,0,0,0,2181,2183,5,577,0,0,2182,2181,1,0,0,0,2182,
  	2183,1,0,0,0,2183,2184,1,0,0,0,2184,2186,5,574,0,0,2185,2187,3,1174,587,
  	0,2186,2185,1,0,0,0,2186,2187,1,0,0,0,2187,2188,1,0,0,0,2188,2211,3,1308,
  	654,0,2189,2190,5,776,0,0,2190,2191,3,88,44,0,2191,2192,5,777,0,0,2192,
  	2194,1,0,0,0,2193,2189,1,0,0,0,2193,2194,1,0,0,0,2194,2196,1,0,0,0,2195,
  	2197,3,1134,567,0,2196,2195,1,0,0,0,2196,2197,1,0,0,0,2197,2199,1,0,0,
  	0,2198,2200,3,1148,574,0,2199,2198,1,0,0,0,2199,2200,1,0,0,0,2200,2202,
  	1,0,0,0,2201,2203,3,92,46,0,2202,2201,1,0,0,0,2202,2203,1,0,0,0,2203,
  	2212,1,0,0,0,2204,2205,5,275,0,0,2205,2212,3,1314,657,0,2206,2207,5,776,
  	0,0,2207,2208,5,275,0,0,2208,2209,3,1314,657,0,2209,2210,5,777,0,0,2210,
  	2212,1,0,0,0,2211,2193,1,0,0,0,2211,2204,1,0,0,0,2211,2206,1,0,0,0,2212,
  	87,1,0,0,0,2213,2218,3,90,45,0,2214,2215,5,773,0,0,2215,2217,3,90,45,
  	0,2216,2214,1,0,0,0,2217,2220,1,0,0,0,2218,2216,1,0,0,0,2218,2219,1,0,
  	0,0,2219,89,1,0,0,0,2220,2218,1,0,0,0,2221,2224,3,1052,526,0,2222,2224,
  	3,1060,530,0,2223,2221,1,0,0,0,2223,2222,1,0,0,0,2224,91,1,0,0,0,2225,
  	2227,7,8,0,0,2226,2225,1,0,0,0,2226,2227,1,0,0,0,2227,2229,1,0,0,0,2228,
  	2230,5,17,0,0,2229,2228,1,0,0,0,2229,2230,1,0,0,0,2230,2231,1,0,0,0,2231,
  	2232,3,94,47,0,2232,93,1,0,0,0,2233,2236,3,276,138,0,2234,2236,3,280,
  	140,0,2235,2233,1,0,0,0,2235,2234,1,0,0,0,2236,95,1,0,0,0,2237,2241,5,
  	97,0,0,2238,2242,3,98,49,0,2239,2242,3,100,50,0,2240,2242,3,102,51,0,
  	2241,2238,1,0,0,0,2241,2239,1,0,0,0,2241,2240,1,0,0,0,2242,2244,1,0,0,
  	0,2243,2245,5,774,0,0,2244,2243,1,0,0,0,2244,2245,1,0,0,0,2245,2246,1,
  	0,0,0,2246,2247,5,0,0,1,2247,97,1,0,0,0,2248,2250,3,1170,585,0,2249,2248,
  	1,0,0,0,2249,2250,1,0,0,0,2250,2251,1,0,0,0,2251,2254,5,422,0,0,2252,
  	2253,4,49,31,0,2253,2255,3,1174,587,0,2254,2252,1,0,0,0,2254,2255,1,0,
  	0,0,2255,2256,1,0,0,0,2256,2257,3,1272,636,0,2257,2266,5,776,0,0,2258,
  	2263,3,1176,588,0,2259,2260,5,773,0,0,2260,2262,3,1176,588,0,2261,2259,
  	1,0,0,0,2262,2265,1,0,0,0,2263,2261,1,0,0,0,2263,2264,1,0,0,0,2264,2267,
  	1,0,0,0,2265,2263,1,0,0,0,2266,2258,1,0,0,0,2266,2267,1,0,0,0,2267,2268,
  	1,0,0,0,2268,2272,5,777,0,0,2269,2271,3,104,52,0,2270,2269,1,0,0,0,2271,
  	2274,1,0,0,0,2272,2270,1,0,0,0,2272,2273,1,0,0,0,2273,2275,1,0,0,0,2274,
  	2272,1,0,0,0,2275,2276,3,972,486,0,2276,99,1,0,0,0,2277,2279,3,1170,585,
  	0,2278,2277,1,0,0,0,2278,2279,1,0,0,0,2279,2280,1,0,0,0,2280,2283,5,206,
  	0,0,2281,2282,4,50,32,0,2282,2284,3,1174,587,0,2283,2281,1,0,0,0,2283,
  	2284,1,0,0,0,2284,2285,1,0,0,0,2285,2286,3,1276,638,0,2286,2295,5,776,
  	0,0,2287,2292,3,1178,589,0,2288,2289,5,773,0,0,2289,2291,3,1178,589,0,
  	2290,2288,1,0,0,0,2291,2294,1,0,0,0,2292,2290,1,0,0,0,2292,2293,1,0,0,
  	0,2293,2296,1,0,0,0,2294,2292,1,0,0,0,2295,2287,1,0,0,0,2295,2296,1,0,
  	0,0,2296,2297,1,0,0,0,2297,2298,5,777,0,0,2298,2299,5,474,0,0,2299,2303,
  	3,1182,591,0,2300,2302,3,104,52,0,2301,2300,1,0,0,0,2302,2305,1,0,0,0,
  	2303,2301,1,0,0,0,2303,2304,1,0,0,0,2304,2306,1,0,0,0,2305,2303,1,0,0,
  	0,2306,2307,3,972,486,0,2307,101,1,0,0,0,2308,2310,5,8,0,0,2309,2308,
  	1,0,0,0,2309,2310,1,0,0,0,2310,2311,1,0,0,0,2311,2314,5,206,0,0,2312,
  	2313,4,51,33,0,2313,2315,3,1174,587,0,2314,2312,1,0,0,0,2314,2315,1,0,
  	0,0,2315,2316,1,0,0,0,2316,2317,3,1300,650,0,2317,2318,5,474,0,0,2318,
  	2319,7,9,0,0,2319,2320,5,520,0,0,2320,2321,3,1376,688,0,2321,103,1,0,
  	0,0,2322,2328,3,108,54,0,2323,2325,5,371,0,0,2324,2323,1,0,0,0,2324,2325,
  	1,0,0,0,2325,2326,1,0,0,0,2326,2328,5,137,0,0,2327,2322,1,0,0,0,2327,
  	2324,1,0,0,0,2328,105,1,0,0,0,2329,2331,3,104,52,0,2330,2329,1,0,0,0,
  	2331,2332,1,0,0,0,2332,2330,1,0,0,0,2332,2333,1,0,0,0,2333,107,1,0,0,
  	0,2334,2335,5,75,0,0,2335,2352,3,1376,688,0,2336,2337,5,267,0,0,2337,
  	2352,5,537,0,0,2338,2339,5,373,0,0,2339,2352,5,537,0,0,2340,2341,5,90,
  	0,0,2341,2352,5,537,0,0,2342,2343,5,433,0,0,2343,2344,5,537,0,0,2344,
  	2352,5,112,0,0,2345,2346,5,347,0,0,2346,2347,5,537,0,0,2347,2352,5,112,
  	0,0,2348,2349,5,537,0,0,2349,2350,5,496,0,0,2350,2352,7,10,0,0,2351,2334,
  	1,0,0,0,2351,2336,1,0,0,0,2351,2338,1,0,0,0,2351,2340,1,0,0,0,2351,2342,
  	1,0,0,0,2351,2345,1,0,0,0,2351,2348,1,0,0,0,2352,109,1,0,0,0,2353,2355,
  	3,1244,622,0,2354,2353,1,0,0,0,2354,2355,1,0,0,0,2355,2397,1,0,0,0,2356,
  	2358,5,609,0,0,2357,2356,1,0,0,0,2357,2358,1,0,0,0,2358,2359,1,0,0,0,
  	2359,2368,5,236,0,0,2360,2361,4,55,34,0,2361,2363,3,1262,631,0,2362,2364,
  	3,1100,550,0,2363,2362,1,0,0,0,2363,2364,1,0,0,0,2364,2369,1,0,0,0,2365,
  	2367,3,112,56,0,2366,2365,1,0,0,0,2366,2367,1,0,0,0,2367,2369,1,0,0,0,
  	2368,2360,1,0,0,0,2368,2366,1,0,0,0,2369,2370,1,0,0,0,2370,2374,3,114,
  	57,0,2371,2373,3,1094,547,0,2372,2371,1,0,0,0,2373,2376,1,0,0,0,2374,
  	2372,1,0,0,0,2374,2375,1,0,0,0,2375,2398,1,0,0,0,2376,2374,1,0,0,0,2377,
  	2378,5,205,0,0,2378,2379,5,236,0,0,2379,2380,3,1262,631,0,2380,2384,3,
  	114,57,0,2381,2383,3,1102,551,0,2382,2381,1,0,0,0,2383,2386,1,0,0,0,2384,
  	2382,1,0,0,0,2384,2385,1,0,0,0,2385,2398,1,0,0,0,2386,2384,1,0,0,0,2387,
  	2388,5,523,0,0,2388,2389,5,236,0,0,2389,2390,3,1262,631,0,2390,2394,3,
  	114,57,0,2391,2393,3,1104,552,0,2392,2391,1,0,0,0,2393,2396,1,0,0,0,2394,
  	2392,1,0,0,0,2394,2395,1,0,0,0,2395,2398,1,0,0,0,2396,2394,1,0,0,0,2397,
  	2357,1,0,0,0,2397,2377,1,0,0,0,2397,2387,1,0,0,0,2398,2400,1,0,0,0,2399,
  	2401,3,48,24,0,2400,2399,1,0,0,0,2400,2401,1,0,0,0,2401,111,1,0,0,0,2402,
  	2413,3,1262,631,0,2403,2405,3,1262,631,0,2404,2403,1,0,0,0,2404,2405,
  	1,0,0,0,2405,2406,1,0,0,0,2406,2407,5,621,0,0,2407,2413,3,1092,546,0,
  	2408,2409,3,1262,631,0,2409,2410,5,599,0,0,2410,2411,3,1092,546,0,2411,
  	2413,1,0,0,0,2412,2402,1,0,0,0,2412,2404,1,0,0,0,2412,2408,1,0,0,0,2413,
  	113,1,0,0,0,2414,2415,5,383,0,0,2415,2416,3,1314,657,0,2416,2417,3,1090,
  	545,0,2417,115,1,0,0,0,2418,2419,5,288,0,0,2419,2420,5,217,0,0,2420,2421,
  	3,1292,646,0,2421,2422,5,4,0,0,2422,2423,5,603,0,0,2423,2425,3,1376,688,
  	0,2424,2426,3,118,59,0,2425,2424,1,0,0,0,2425,2426,1,0,0,0,2426,117,1,
  	0,0,0,2427,2434,3,120,60,0,2428,2430,5,773,0,0,2429,2428,1,0,0,0,2429,
  	2430,1,0,0,0,2430,2431,1,0,0,0,2431,2433,3,120,60,0,2432,2429,1,0,0,0,
  	2433,2436,1,0,0,0,2434,2432,1,0,0,0,2434,2435,1,0,0,0,2435,119,1,0,0,
  	0,2436,2434,1,0,0,0,2437,2444,3,140,70,0,2438,2444,3,142,71,0,2439,2444,
  	3,150,75,0,2440,2444,3,152,76,0,2441,2444,3,154,77,0,2442,2444,3,156,
  	78,0,2443,2437,1,0,0,0,2443,2438,1,0,0,0,2443,2439,1,0,0,0,2443,2440,
  	1,0,0,0,2443,2441,1,0,0,0,2443,2442,1,0,0,0,2444,121,1,0,0,0,2445,2446,
  	5,503,0,0,2446,2447,3,1302,651,0,2447,2448,5,199,0,0,2448,2449,5,112,
  	0,0,2449,2450,5,648,0,0,2450,2451,3,1398,699,0,2451,2452,3,124,62,0,2452,
  	123,1,0,0,0,2453,2454,5,390,0,0,2454,2455,5,776,0,0,2455,2460,3,126,63,
  	0,2456,2457,5,773,0,0,2457,2459,3,126,63,0,2458,2456,1,0,0,0,2459,2462,
  	1,0,0,0,2460,2458,1,0,0,0,2460,2461,1,0,0,0,2461,2463,1,0,0,0,2462,2460,
  	1,0,0,0,2463,2464,5,777,0,0,2464,125,1,0,0,0,2465,2466,5,224,0,0,2466,
  	2480,3,1376,688,0,2467,2468,5,109,0,0,2468,2480,3,1376,688,0,2469,2470,
  	5,618,0,0,2470,2480,3,1376,688,0,2471,2472,5,406,0,0,2472,2480,3,1376,
  	688,0,2473,2474,5,519,0,0,2474,2480,3,1376,688,0,2475,2476,5,398,0,0,
  	2476,2480,3,1376,688,0,2477,2478,5,413,0,0,2478,2480,3,1350,675,0,2479,
  	2465,1,0,0,0,2479,2467,1,0,0,0,2479,2469,1,0,0,0,2479,2471,1,0,0,0,2479,
  	2473,1,0,0,0,2479,2475,1,0,0,0,2479,2477,1,0,0,0,2480,127,1,0,0,0,2481,
  	2482,5,572,0,0,2482,2483,3,1288,644,0,2483,2488,3,132,66,0,2484,2485,
  	5,620,0,0,2485,2486,5,288,0,0,2486,2487,5,217,0,0,2487,2489,3,1294,647,
  	0,2488,2484,1,0,0,0,2488,2489,1,0,0,0,2489,2491,1,0,0,0,2490,2492,3,136,
  	68,0,2491,2490,1,0,0,0,2491,2492,1,0,0,0,2492,129,1,0,0,0,2493,2494,5,
  	605,0,0,2494,2495,5,572,0,0,2495,2496,3,1288,644,0,2496,2497,5,4,0,0,
  	2497,2499,3,134,67,0,2498,2500,3,60,30,0,2499,2498,1,0,0,0,2499,2500,
  	1,0,0,0,2500,131,1,0,0,0,2501,2504,4,66,35,0,2502,2503,5,4,0,0,2503,2505,
  	3,134,67,0,2504,2502,1,0,0,0,2504,2505,1,0,0,0,2505,2509,1,0,0,0,2506,
  	2507,5,4,0,0,2507,2509,3,134,67,0,2508,2501,1,0,0,0,2508,2506,1,0,0,0,
  	2509,133,1,0,0,0,2510,2511,5,111,0,0,2511,2512,3,1376,688,0,2512,135,
  	1,0,0,0,2513,2520,3,138,69,0,2514,2516,5,773,0,0,2515,2514,1,0,0,0,2515,
  	2516,1,0,0,0,2516,2517,1,0,0,0,2517,2519,3,138,69,0,2518,2515,1,0,0,0,
  	2519,2522,1,0,0,0,2520,2518,1,0,0,0,2520,2521,1,0,0,0,2521,137,1,0,0,
  	0,2522,2520,1,0,0,0,2523,2536,3,140,70,0,2524,2536,3,144,72,0,2525,2536,
  	3,146,73,0,2526,2536,3,148,74,0,2527,2536,3,150,75,0,2528,2536,3,152,
  	76,0,2529,2536,3,154,77,0,2530,2536,3,156,78,0,2531,2532,4,69,36,0,2532,
  	2536,3,158,79,0,2533,2534,4,69,37,0,2534,2536,3,160,80,0,2535,2523,1,
  	0,0,0,2535,2524,1,0,0,0,2535,2525,1,0,0,0,2535,2526,1,0,0,0,2535,2527,
  	1,0,0,0,2535,2528,1,0,0,0,2535,2529,1,0,0,0,2535,2530,1,0,0,0,2535,2531,
  	1,0,0,0,2535,2533,1,0,0,0,2536,139,1,0,0,0,2537,2539,5,238,0,0,2538,2540,
  	5,750,0,0,2539,2538,1,0,0,0,2539,2540,1,0,0,0,2540,2541,1,0,0,0,2541,
  	2542,3,1404,702,0,2542,141,1,0,0,0,2543,2545,7,11,0,0,2544,2546,5,750,
  	0,0,2545,2544,1,0,0,0,2545,2546,1,0,0,0,2546,2547,1,0,0,0,2547,2548,3,
  	1404,702,0,2548,143,1,0,0,0,2549,2551,5,23,0,0,2550,2552,5,750,0,0,2551,
  	2550,1,0,0,0,2551,2552,1,0,0,0,2552,2553,1,0,0,0,2553,2554,3,1404,702,
  	0,2554,145,1,0,0,0,2555,2557,5,324,0,0,2556,2558,5,750,0,0,2557,2556,
  	1,0,0,0,2557,2558,1,0,0,0,2558,2559,1,0,0,0,2559,2560,3,1404,702,0,2560,
  	147,1,0,0,0,2561,2563,5,181,0,0,2562,2564,5,750,0,0,2563,2562,1,0,0,0,
  	2563,2564,1,0,0,0,2564,2565,1,0,0,0,2565,2566,3,1404,702,0,2566,149,1,
  	0,0,0,2567,2569,5,368,0,0,2568,2570,5,750,0,0,2569,2568,1,0,0,0,2569,
  	2570,1,0,0,0,2570,2571,1,0,0,0,2571,2572,3,1352,676,0,2572,151,1,0,0,
  	0,2573,2575,5,553,0,0,2574,2573,1,0,0,0,2574,2575,1,0,0,0,2575,2576,1,
  	0,0,0,2576,2578,5,163,0,0,2577,2579,5,750,0,0,2578,2577,1,0,0,0,2578,
  	2579,1,0,0,0,2579,2580,1,0,0,0,2580,2581,3,1306,653,0,2581,153,1,0,0,
  	0,2582,2583,7,12,0,0,2583,155,1,0,0,0,2584,2586,5,75,0,0,2585,2587,5,
  	750,0,0,2586,2585,1,0,0,0,2586,2587,1,0,0,0,2587,2588,1,0,0,0,2588,2589,
  	3,1376,688,0,2589,157,1,0,0,0,2590,2592,5,189,0,0,2591,2593,5,750,0,0,
  	2592,2591,1,0,0,0,2592,2593,1,0,0,0,2593,2594,1,0,0,0,2594,2595,3,1404,
  	702,0,2595,159,1,0,0,0,2596,2598,5,158,0,0,2597,2599,5,750,0,0,2598,2597,
  	1,0,0,0,2598,2599,1,0,0,0,2599,2600,1,0,0,0,2600,2601,3,1370,685,0,2601,
  	161,1,0,0,0,2602,2604,5,163,0,0,2603,2605,5,750,0,0,2604,2603,1,0,0,0,
  	2604,2605,1,0,0,0,2605,2606,1,0,0,0,2606,2607,3,1416,708,0,2607,163,1,
  	0,0,0,2608,2610,3,166,83,0,2609,2608,1,0,0,0,2609,2610,1,0,0,0,2610,2612,
  	1,0,0,0,2611,2613,3,1170,585,0,2612,2611,1,0,0,0,2612,2613,1,0,0,0,2613,
  	2615,1,0,0,0,2614,2616,3,170,85,0,2615,2614,1,0,0,0,2615,2616,1,0,0,0,
  	2616,2617,1,0,0,0,2617,2618,5,636,0,0,2618,2619,3,1284,642,0,2619,2620,
  	3,72,36,0,2620,165,1,0,0,0,2621,2622,5,394,0,0,2622,2624,5,458,0,0,2623,
  	2625,3,168,84,0,2624,2623,1,0,0,0,2624,2625,1,0,0,0,2625,2628,1,0,0,0,
  	2626,2628,3,168,84,0,2627,2621,1,0,0,0,2627,2626,1,0,0,0,2628,167,1,0,
  	0,0,2629,2630,5,9,0,0,2630,2631,5,750,0,0,2631,2632,7,13,0,0,2632,169,
  	1,0,0,0,2633,2634,5,537,0,0,2634,2635,5,496,0,0,2635,2636,7,10,0,0,2636,
  	171,1,0,0,0,2637,2639,3,1170,585,0,2638,2637,1,0,0,0,2638,2639,1,0,0,
  	0,2639,2640,1,0,0,0,2640,2643,5,594,0,0,2641,2642,4,86,38,0,2642,2644,
  	3,1174,587,0,2643,2641,1,0,0,0,2643,2644,1,0,0,0,2644,2645,1,0,0,0,2645,
  	2646,3,1280,640,0,2646,2647,7,14,0,0,2647,2648,7,15,0,0,2648,2649,5,383,
  	0,0,2649,2650,3,1314,657,0,2650,2651,5,200,0,0,2651,2652,5,153,0,0,2652,
  	2654,5,487,0,0,2653,2655,3,174,87,0,2654,2653,1,0,0,0,2654,2655,1,0,0,
  	0,2655,2656,1,0,0,0,2656,2657,3,972,486,0,2657,173,1,0,0,0,2658,2659,
  	7,16,0,0,2659,2660,3,1398,699,0,2660,175,1,0,0,0,2661,2663,3,1170,585,
  	0,2662,2661,1,0,0,0,2662,2663,1,0,0,0,2663,2664,1,0,0,0,2664,2666,5,170,
  	0,0,2665,2667,3,1174,587,0,2666,2665,1,0,0,0,2666,2667,1,0,0,0,2667,2668,
  	1,0,0,0,2668,2669,3,1296,648,0,2669,2670,5,383,0,0,2670,2671,5,490,0,
  	0,2671,2678,3,1050,525,0,2672,2673,5,383,0,0,2673,2675,5,79,0,0,2674,
  	2676,5,371,0,0,2675,2674,1,0,0,0,2675,2676,1,0,0,0,2676,2677,1,0,0,0,
  	2677,2679,5,418,0,0,2678,2672,1,0,0,0,2678,2679,1,0,0,0,2679,2686,1,0,
  	0,0,2680,2687,5,156,0,0,2681,2684,5,140,0,0,2682,2683,5,383,0,0,2683,
  	2685,3,574,287,0,2684,2682,1,0,0,0,2684,2685,1,0,0,0,2685,2687,1,0,0,
  	0,2686,2680,1,0,0,0,2686,2681,1,0,0,0,2686,2687,1,0,0,0,2687,2690,1,0,
  	0,0,2688,2689,5,75,0,0,2689,2691,3,1376,688,0,2690,2688,1,0,0,0,2690,
  	2691,1,0,0,0,2691,2692,1,0,0,0,2692,2693,5,147,0,0,2693,2694,3,972,486,
  	0,2694,177,1,0,0,0,2695,2697,5,659,0,0,2696,2698,3,1174,587,0,2697,2696,
  	1,0,0,0,2697,2698,1,0,0,0,2698,2699,1,0,0,0,2699,2700,3,652,326,0,2700,
  	179,1,0,0,0,2701,2702,5,394,0,0,2702,2703,5,458,0,0,2703,2704,5,523,0,
  	0,2704,2705,5,718,0,0,2705,2706,5,710,0,0,2706,2710,3,1356,678,0,2707,
  	2709,3,182,91,0,2708,2707,1,0,0,0,2709,2712,1,0,0,0,2710,2708,1,0,0,0,
  	2710,2711,1,0,0,0,2711,2727,1,0,0,0,2712,2710,1,0,0,0,2713,2714,5,523,
  	0,0,2714,2715,5,718,0,0,2715,2717,5,710,0,0,2716,2718,3,1174,587,0,2717,
  	2716,1,0,0,0,2717,2718,1,0,0,0,2718,2719,1,0,0,0,2719,2723,3,1356,678,
  	0,2720,2722,3,182,91,0,2721,2720,1,0,0,0,2722,2725,1,0,0,0,2723,2721,
  	1,0,0,0,2723,2724,1,0,0,0,2724,2727,1,0,0,0,2725,2723,1,0,0,0,2726,2701,
  	1,0,0,0,2726,2713,1,0,0,0,2727,181,1,0,0,0,2728,2729,5,357,0,0,2729,2730,
  	5,580,0,0,2730,2744,3,1378,689,0,2731,2732,5,715,0,0,2732,2733,5,580,
  	0,0,2733,2744,3,1378,689,0,2734,2735,5,717,0,0,2735,2736,3,1378,689,0,
  	2736,2737,5,230,0,0,2737,2738,5,45,0,0,2738,2739,3,1356,678,0,2739,2744,
  	1,0,0,0,2740,2741,5,716,0,0,2741,2742,5,580,0,0,2742,2744,3,1378,689,
  	0,2743,2728,1,0,0,0,2743,2731,1,0,0,0,2743,2734,1,0,0,0,2743,2740,1,0,
  	0,0,2744,183,1,0,0,0,2745,2763,5,148,0,0,2746,2764,3,186,93,0,2747,2764,
  	3,188,94,0,2748,2764,3,190,95,0,2749,2764,3,192,96,0,2750,2764,3,194,
  	97,0,2751,2764,3,196,98,0,2752,2764,3,200,100,0,2753,2764,3,202,101,0,
  	2754,2764,3,204,102,0,2755,2764,3,206,103,0,2756,2764,3,208,104,0,2757,
  	2758,4,92,39,0,2758,2764,3,210,105,0,2759,2760,4,92,40,0,2760,2764,3,
  	212,106,0,2761,2762,4,92,41,0,2762,2764,3,214,107,0,2763,2746,1,0,0,0,
  	2763,2747,1,0,0,0,2763,2748,1,0,0,0,2763,2749,1,0,0,0,2763,2750,1,0,0,
  	0,2763,2751,1,0,0,0,2763,2752,1,0,0,0,2763,2753,1,0,0,0,2763,2754,1,0,
  	0,0,2763,2755,1,0,0,0,2763,2756,1,0,0,0,2763,2757,1,0,0,0,2763,2759,1,
  	0,0,0,2763,2761,1,0,0,0,2764,185,1,0,0,0,2765,2767,5,109,0,0,2766,2768,
  	3,1172,586,0,2767,2766,1,0,0,0,2767,2768,1,0,0,0,2768,2769,1,0,0,0,2769,
  	2770,3,1270,635,0,2770,187,1,0,0,0,2771,2773,5,170,0,0,2772,2774,3,1172,
  	586,0,2773,2772,1,0,0,0,2773,2774,1,0,0,0,2774,2775,1,0,0,0,2775,2776,
  	3,1298,649,0,2776,189,1,0,0,0,2777,2779,5,206,0,0,2778,2780,3,1172,586,
  	0,2779,2778,1,0,0,0,2779,2780,1,0,0,0,2780,2781,1,0,0,0,2781,2782,3,1278,
  	639,0,2782,191,1,0,0,0,2783,2785,5,422,0,0,2784,2786,3,1172,586,0,2785,
  	2784,1,0,0,0,2785,2786,1,0,0,0,2786,2787,1,0,0,0,2787,2788,3,1274,637,
  	0,2788,193,1,0,0,0,2789,2791,3,1244,622,0,2790,2789,1,0,0,0,2790,2791,
  	1,0,0,0,2791,2792,1,0,0,0,2792,2793,5,236,0,0,2793,2794,3,1264,632,0,
  	2794,2795,5,383,0,0,2795,2797,3,1314,657,0,2796,2798,3,48,24,0,2797,2796,
  	1,0,0,0,2797,2798,1,0,0,0,2798,195,1,0,0,0,2799,2800,5,288,0,0,2800,2801,
  	5,217,0,0,2801,2812,3,1294,647,0,2802,2809,3,198,99,0,2803,2805,5,773,
  	0,0,2804,2803,1,0,0,0,2804,2805,1,0,0,0,2805,2806,1,0,0,0,2806,2808,3,
  	198,99,0,2807,2804,1,0,0,0,2808,2811,1,0,0,0,2809,2807,1,0,0,0,2809,2810,
  	1,0,0,0,2810,2813,1,0,0,0,2811,2809,1,0,0,0,2812,2802,1,0,0,0,2812,2813,
  	1,0,0,0,2813,197,1,0,0,0,2814,2817,3,154,77,0,2815,2817,3,152,76,0,2816,
  	2814,1,0,0,0,2816,2815,1,0,0,0,2817,199,1,0,0,0,2818,2820,5,503,0,0,2819,
  	2821,3,1172,586,0,2820,2819,1,0,0,0,2820,2821,1,0,0,0,2821,2822,1,0,0,
  	0,2822,2823,3,1304,652,0,2823,201,1,0,0,0,2824,2826,5,577,0,0,2825,2824,
  	1,0,0,0,2825,2826,1,0,0,0,2826,2827,1,0,0,0,2827,2829,7,17,0,0,2828,2830,
  	3,1172,586,0,2829,2828,1,0,0,0,2829,2830,1,0,0,0,2830,2831,1,0,0,0,2831,
  	2833,3,1316,658,0,2832,2834,7,2,0,0,2833,2832,1,0,0,0,2833,2834,1,0,0,
  	0,2834,203,1,0,0,0,2835,2836,5,572,0,0,2836,2847,3,1290,645,0,2837,2844,
  	3,198,99,0,2838,2840,5,773,0,0,2839,2838,1,0,0,0,2839,2840,1,0,0,0,2840,
  	2841,1,0,0,0,2841,2843,3,198,99,0,2842,2839,1,0,0,0,2843,2846,1,0,0,0,
  	2844,2842,1,0,0,0,2844,2845,1,0,0,0,2845,2848,1,0,0,0,2846,2844,1,0,0,
  	0,2847,2837,1,0,0,0,2847,2848,1,0,0,0,2848,205,1,0,0,0,2849,2851,5,594,
  	0,0,2850,2852,3,1172,586,0,2851,2850,1,0,0,0,2851,2852,1,0,0,0,2852,2853,
  	1,0,0,0,2853,2854,3,1282,641,0,2854,207,1,0,0,0,2855,2857,5,636,0,0,2856,
  	2858,3,1172,586,0,2857,2856,1,0,0,0,2857,2858,1,0,0,0,2858,2859,1,0,0,
  	0,2859,2861,3,1186,593,0,2860,2862,7,2,0,0,2861,2860,1,0,0,0,2861,2862,
  	1,0,0,0,2862,209,1,0,0,0,2863,2865,5,659,0,0,2864,2866,3,1172,586,0,2865,
  	2864,1,0,0,0,2865,2866,1,0,0,0,2866,2867,1,0,0,0,2867,2868,3,652,326,
  	0,2868,211,1,0,0,0,2869,2870,5,523,0,0,2870,2871,5,718,0,0,2871,2873,
  	5,710,0,0,2872,2874,3,1172,586,0,2873,2872,1,0,0,0,2873,2874,1,0,0,0,
  	2874,2875,1,0,0,0,2875,2876,3,1356,678,0,2876,213,1,0,0,0,2877,2878,5,
  	605,0,0,2878,2879,5,572,0,0,2879,2881,3,1290,645,0,2880,2882,3,60,30,
  	0,2881,2880,1,0,0,0,2881,2882,1,0,0,0,2882,215,1,0,0,0,2883,2884,5,453,
  	0,0,2884,2885,7,17,0,0,2885,2890,3,218,109,0,2886,2887,5,773,0,0,2887,
  	2889,3,218,109,0,2888,2886,1,0,0,0,2889,2892,1,0,0,0,2890,2888,1,0,0,
  	0,2890,2891,1,0,0,0,2891,217,1,0,0,0,2892,2890,1,0,0,0,2893,2894,3,1314,
  	657,0,2894,2895,5,590,0,0,2895,2896,3,1308,654,0,2896,219,1,0,0,0,2897,
  	2899,5,597,0,0,2898,2900,5,574,0,0,2899,2898,1,0,0,0,2899,2900,1,0,0,
  	0,2900,2901,1,0,0,0,2901,2902,3,1314,657,0,2902,221,1,0,0,0,2903,2904,
  	5,234,0,0,2904,2905,5,574,0,0,2905,2906,5,203,0,0,2906,2907,3,1380,690,
  	0,2907,223,1,0,0,0,2908,2909,5,48,0,0,2909,2915,3,1274,637,0,2910,2912,
  	5,776,0,0,2911,2913,3,944,472,0,2912,2911,1,0,0,0,2912,2913,1,0,0,0,2913,
  	2914,1,0,0,0,2914,2916,5,777,0,0,2915,2910,1,0,0,0,2915,2916,1,0,0,0,
  	2916,225,1,0,0,0,2917,2918,4,113,42,0,2918,2920,3,326,163,0,2919,2917,
  	1,0,0,0,2919,2920,1,0,0,0,2920,2921,1,0,0,0,2921,2925,5,133,0,0,2922,
  	2924,3,230,115,0,2923,2922,1,0,0,0,2924,2927,1,0,0,0,2925,2923,1,0,0,
  	0,2925,2926,1,0,0,0,2926,2960,1,0,0,0,2927,2925,1,0,0,0,2928,2952,5,203,
  	0,0,2929,2930,3,1318,659,0,2930,2931,5,621,0,0,2931,2933,3,340,170,0,
  	2932,2934,3,364,182,0,2933,2932,1,0,0,0,2933,2934,1,0,0,0,2934,2953,1,
  	0,0,0,2935,2938,3,1314,657,0,2936,2937,4,113,43,0,2937,2939,3,406,203,
  	0,2938,2936,1,0,0,0,2938,2939,1,0,0,0,2939,2941,1,0,0,0,2940,2942,3,228,
  	114,0,2941,2940,1,0,0,0,2941,2942,1,0,0,0,2942,2944,1,0,0,0,2943,2945,
  	3,364,182,0,2944,2943,1,0,0,0,2944,2945,1,0,0,0,2945,2947,1,0,0,0,2946,
  	2948,3,334,167,0,2947,2946,1,0,0,0,2947,2948,1,0,0,0,2948,2950,1,0,0,
  	0,2949,2951,3,292,146,0,2950,2949,1,0,0,0,2950,2951,1,0,0,0,2951,2953,
  	1,0,0,0,2952,2929,1,0,0,0,2952,2935,1,0,0,0,2953,2961,1,0,0,0,2954,2955,
  	3,1318,659,0,2955,2956,5,203,0,0,2956,2958,3,340,170,0,2957,2959,3,364,
  	182,0,2958,2957,1,0,0,0,2958,2959,1,0,0,0,2959,2961,1,0,0,0,2960,2928,
  	1,0,0,0,2960,2954,1,0,0,0,2961,227,1,0,0,0,2962,2963,5,405,0,0,2963,2964,
  	5,776,0,0,2964,2965,3,1340,670,0,2965,2966,5,777,0,0,2966,229,1,0,0,0,
  	2967,2968,7,18,0,0,2968,231,1,0,0,0,2969,2974,5,147,0,0,2970,2971,4,116,
  	44,0,2971,2975,3,944,472,0,2972,2973,4,116,45,0,2973,2975,3,358,179,0,
  	2974,2970,1,0,0,0,2974,2972,1,0,0,0,2975,233,1,0,0,0,2976,2994,5,219,
  	0,0,2977,2978,3,1314,657,0,2978,2980,5,387,0,0,2979,2981,3,406,203,0,
  	2980,2979,1,0,0,0,2980,2981,1,0,0,0,2981,2995,1,0,0,0,2982,2992,3,1338,
  	669,0,2983,2993,5,66,0,0,2984,2985,5,435,0,0,2985,2987,3,236,118,0,2986,
  	2988,3,364,182,0,2987,2986,1,0,0,0,2987,2988,1,0,0,0,2988,2990,1,0,0,
  	0,2989,2991,3,290,145,0,2990,2989,1,0,0,0,2990,2991,1,0,0,0,2991,2993,
  	1,0,0,0,2992,2983,1,0,0,0,2992,2984,1,0,0,0,2993,2995,1,0,0,0,2994,2977,
  	1,0,0,0,2994,2982,1,0,0,0,2995,235,1,0,0,0,2996,3007,7,19,0,0,2997,3004,
  	3,1338,669,0,2998,3005,7,20,0,0,2999,3000,7,21,0,0,3000,3001,5,776,0,
  	0,3001,3002,3,252,126,0,3002,3003,5,777,0,0,3003,3005,1,0,0,0,3004,2998,
  	1,0,0,0,3004,2999,1,0,0,0,3005,3007,1,0,0,0,3006,2996,1,0,0,0,3006,2997,
  	1,0,0,0,3007,237,1,0,0,0,3008,3010,5,242,0,0,3009,3011,3,240,120,0,3010,
  	3009,1,0,0,0,3010,3011,1,0,0,0,3011,3013,1,0,0,0,3012,3014,5,232,0,0,
  	3013,3012,1,0,0,0,3013,3014,1,0,0,0,3014,3016,1,0,0,0,3015,3017,5,248,
  	0,0,3016,3015,1,0,0,0,3016,3017,1,0,0,0,3017,3018,1,0,0,0,3018,3020,3,
  	1314,657,0,3019,3021,3,1248,624,0,3020,3019,1,0,0,0,3020,3021,1,0,0,0,
  	3021,3034,1,0,0,0,3022,3025,3,242,121,0,3023,3024,4,119,46,0,3024,3026,
  	3,254,127,0,3025,3023,1,0,0,0,3025,3026,1,0,0,0,3026,3035,1,0,0,0,3027,
  	3028,5,506,0,0,3028,3031,3,1188,594,0,3029,3030,4,119,47,0,3030,3032,
  	3,254,127,0,3031,3029,1,0,0,0,3031,3032,1,0,0,0,3032,3035,1,0,0,0,3033,
  	3035,3,248,124,0,3034,3022,1,0,0,0,3034,3027,1,0,0,0,3034,3033,1,0,0,
  	0,3035,3037,1,0,0,0,3036,3038,3,256,128,0,3037,3036,1,0,0,0,3037,3038,
  	1,0,0,0,3038,239,1,0,0,0,3039,3040,7,22,0,0,3040,241,1,0,0,0,3041,3043,
  	5,776,0,0,3042,3044,3,244,122,0,3043,3042,1,0,0,0,3043,3044,1,0,0,0,3044,
  	3045,1,0,0,0,3045,3047,5,777,0,0,3046,3041,1,0,0,0,3046,3047,1,0,0,0,
  	3047,3048,1,0,0,0,3048,3049,3,246,123,0,3049,243,1,0,0,0,3050,3055,3,
  	1260,630,0,3051,3052,5,773,0,0,3052,3054,3,1260,630,0,3053,3051,1,0,0,
  	0,3054,3057,1,0,0,0,3055,3053,1,0,0,0,3055,3056,1,0,0,0,3056,245,1,0,
  	0,0,3057,3055,1,0,0,0,3058,3059,7,23,0,0,3059,3060,3,250,125,0,3060,247,
  	1,0,0,0,3061,3069,3,94,47,0,3062,3064,5,776,0,0,3063,3065,3,244,122,0,
  	3064,3063,1,0,0,0,3064,3065,1,0,0,0,3065,3066,1,0,0,0,3066,3067,5,777,
  	0,0,3067,3069,3,94,47,0,3068,3061,1,0,0,0,3068,3062,1,0,0,0,3069,249,
  	1,0,0,0,3070,3072,5,776,0,0,3071,3073,3,252,126,0,3072,3071,1,0,0,0,3072,
  	3073,1,0,0,0,3073,3074,1,0,0,0,3074,3083,5,777,0,0,3075,3076,5,773,0,
  	0,3076,3078,5,776,0,0,3077,3079,3,252,126,0,3078,3077,1,0,0,0,3078,3079,
  	1,0,0,0,3079,3080,1,0,0,0,3080,3082,5,777,0,0,3081,3075,1,0,0,0,3082,
  	3085,1,0,0,0,3083,3081,1,0,0,0,3083,3084,1,0,0,0,3084,251,1,0,0,0,3085,
  	3083,1,0,0,0,3086,3089,3,854,427,0,3087,3089,5,128,0,0,3088,3086,1,0,
  	0,0,3088,3087,1,0,0,0,3089,3097,1,0,0,0,3090,3093,5,773,0,0,3091,3094,
  	3,854,427,0,3092,3094,5,128,0,0,3093,3091,1,0,0,0,3093,3092,1,0,0,0,3094,
  	3096,1,0,0,0,3095,3090,1,0,0,0,3096,3099,1,0,0,0,3097,3095,1,0,0,0,3097,
  	3098,1,0,0,0,3098,253,1,0,0,0,3099,3097,1,0,0,0,3100,3101,5,17,0,0,3101,
  	3103,3,1338,669,0,3102,3104,3,1256,628,0,3103,3102,1,0,0,0,3103,3104,
  	1,0,0,0,3104,255,1,0,0,0,3105,3106,5,383,0,0,3106,3107,5,151,0,0,3107,
  	3108,5,265,0,0,3108,3109,5,614,0,0,3109,3110,3,1188,594,0,3110,257,1,
  	0,0,0,3111,3112,5,281,0,0,3112,3114,3,260,130,0,3113,3115,7,24,0,0,3114,
  	3113,1,0,0,0,3114,3115,1,0,0,0,3115,3117,1,0,0,0,3116,3118,5,284,0,0,
  	3117,3116,1,0,0,0,3117,3118,1,0,0,0,3118,3119,1,0,0,0,3119,3120,5,237,
  	0,0,3120,3122,3,1376,688,0,3121,3123,7,8,0,0,3122,3121,1,0,0,0,3122,3123,
  	1,0,0,0,3123,3124,1,0,0,0,3124,3125,5,248,0,0,3125,3126,5,574,0,0,3126,
  	3128,3,1314,657,0,3127,3129,3,1248,624,0,3128,3127,1,0,0,0,3128,3129,
  	1,0,0,0,3129,3131,1,0,0,0,3130,3132,3,1192,596,0,3131,3130,1,0,0,0,3131,
  	3132,1,0,0,0,3132,3134,1,0,0,0,3133,3135,3,262,131,0,3134,3133,1,0,0,
  	0,3134,3135,1,0,0,0,3135,3137,1,0,0,0,3136,3138,3,1194,597,0,3137,3136,
  	1,0,0,0,3137,3138,1,0,0,0,3138,3140,1,0,0,0,3139,3141,3,1198,599,0,3140,
  	3139,1,0,0,0,3140,3141,1,0,0,0,3141,3142,1,0,0,0,3142,3143,3,264,132,
  	0,3143,259,1,0,0,0,3144,3145,7,25,0,0,3145,261,1,0,0,0,3146,3147,5,484,
  	0,0,3147,3148,5,230,0,0,3148,3149,5,45,0,0,3149,3150,3,1372,686,0,3150,
  	263,1,0,0,0,3151,3152,5,232,0,0,3152,3153,5,747,0,0,3153,3155,7,26,0,
  	0,3154,3151,1,0,0,0,3154,3155,1,0,0,0,3155,3157,1,0,0,0,3156,3158,3,266,
  	133,0,3157,3156,1,0,0,0,3157,3158,1,0,0,0,3158,3161,1,0,0,0,3159,3160,
  	5,506,0,0,3160,3162,3,1188,594,0,3161,3159,1,0,0,0,3161,3162,1,0,0,0,
  	3162,265,1,0,0,0,3163,3165,5,776,0,0,3164,3166,3,268,134,0,3165,3164,
  	1,0,0,0,3165,3166,1,0,0,0,3166,3167,1,0,0,0,3167,3168,5,777,0,0,3168,
  	267,1,0,0,0,3169,3172,3,1258,629,0,3170,3172,3,924,462,0,3171,3169,1,
  	0,0,0,3171,3170,1,0,0,0,3172,3180,1,0,0,0,3173,3176,5,773,0,0,3174,3177,
  	3,1258,629,0,3175,3177,3,924,462,0,3176,3174,1,0,0,0,3176,3175,1,0,0,
  	0,3177,3179,1,0,0,0,3178,3173,1,0,0,0,3179,3182,1,0,0,0,3180,3178,1,0,
  	0,0,3180,3181,1,0,0,0,3181,269,1,0,0,0,3182,3180,1,0,0,0,3183,3185,5,
  	458,0,0,3184,3186,7,27,0,0,3185,3184,1,0,0,0,3185,3186,1,0,0,0,3186,3188,
  	1,0,0,0,3187,3189,5,248,0,0,3188,3187,1,0,0,0,3188,3189,1,0,0,0,3189,
  	3190,1,0,0,0,3190,3192,3,1314,657,0,3191,3193,3,1248,624,0,3192,3191,
  	1,0,0,0,3192,3193,1,0,0,0,3193,3198,1,0,0,0,3194,3199,3,242,121,0,3195,
  	3196,5,506,0,0,3196,3199,3,1188,594,0,3197,3199,3,248,124,0,3198,3194,
  	1,0,0,0,3198,3195,1,0,0,0,3198,3197,1,0,0,0,3199,271,1,0,0,0,3200,3202,
  	3,276,138,0,3201,3203,3,350,175,0,3202,3201,1,0,0,0,3202,3203,1,0,0,0,
  	3203,3207,1,0,0,0,3204,3207,3,280,140,0,3205,3207,3,274,137,0,3206,3200,
  	1,0,0,0,3206,3204,1,0,0,0,3206,3205,1,0,0,0,3207,273,1,0,0,0,3208,3209,
  	5,776,0,0,3209,3210,3,274,137,0,3210,3211,5,777,0,0,3211,3222,1,0,0,0,
  	3212,3213,3,276,138,0,3213,3215,3,298,149,0,3214,3216,3,350,175,0,3215,
  	3214,1,0,0,0,3215,3216,1,0,0,0,3216,3222,1,0,0,0,3217,3218,4,137,48,0,
  	3218,3219,3,280,140,0,3219,3220,3,298,149,0,3220,3222,1,0,0,0,3221,3208,
  	1,0,0,0,3221,3212,1,0,0,0,3221,3217,1,0,0,0,3222,275,1,0,0,0,3223,3224,
  	4,138,49,0,3224,3226,3,326,163,0,3225,3223,1,0,0,0,3225,3226,1,0,0,0,
  	3226,3241,1,0,0,0,3227,3229,3,278,139,0,3228,3230,3,334,167,0,3229,3228,
  	1,0,0,0,3229,3230,1,0,0,0,3230,3232,1,0,0,0,3231,3233,3,290,145,0,3232,
  	3231,1,0,0,0,3232,3233,1,0,0,0,3233,3242,1,0,0,0,3234,3236,3,280,140,
  	0,3235,3237,3,334,167,0,3236,3235,1,0,0,0,3236,3237,1,0,0,0,3237,3239,
  	1,0,0,0,3238,3240,3,290,145,0,3239,3238,1,0,0,0,3239,3240,1,0,0,0,3240,
  	3242,1,0,0,0,3241,3227,1,0,0,0,3241,3234,1,0,0,0,3242,3245,1,0,0,0,3243,
  	3244,4,138,50,0,3244,3246,3,300,150,0,3245,3243,1,0,0,0,3245,3246,1,0,
  	0,0,3246,277,1,0,0,0,3247,3258,3,282,141,0,3248,3249,3,280,140,0,3249,
  	3251,5,608,0,0,3250,3252,3,404,202,0,3251,3250,1,0,0,0,3251,3252,1,0,
  	0,0,3252,3255,1,0,0,0,3253,3256,3,282,141,0,3254,3256,3,280,140,0,3255,
  	3253,1,0,0,0,3255,3254,1,0,0,0,3256,3258,1,0,0,0,3257,3247,1,0,0,0,3257,
  	3248,1,0,0,0,3258,3269,1,0,0,0,3259,3261,5,608,0,0,3260,3262,3,404,202,
  	0,3261,3260,1,0,0,0,3261,3262,1,0,0,0,3262,3265,1,0,0,0,3263,3266,3,282,
  	141,0,3264,3266,3,280,140,0,3265,3263,1,0,0,0,3265,3264,1,0,0,0,3266,
  	3268,1,0,0,0,3267,3259,1,0,0,0,3268,3271,1,0,0,0,3269,3267,1,0,0,0,3269,
  	3270,1,0,0,0,3270,279,1,0,0,0,3271,3269,1,0,0,0,3272,3278,5,776,0,0,3273,
  	3279,3,280,140,0,3274,3276,3,276,138,0,3275,3277,3,350,175,0,3276,3275,
  	1,0,0,0,3276,3277,1,0,0,0,3277,3279,1,0,0,0,3278,3273,1,0,0,0,3278,3274,
  	1,0,0,0,3279,3280,1,0,0,0,3280,3281,5,777,0,0,3281,281,1,0,0,0,3282,3288,
  	3,284,142,0,3283,3284,4,141,51,0,3284,3288,3,342,171,0,3285,3286,4,141,
  	52,0,3286,3288,3,344,172,0,3287,3282,1,0,0,0,3287,3283,1,0,0,0,3287,3285,
  	1,0,0,0,3288,283,1,0,0,0,3289,3293,5,497,0,0,3290,3292,3,348,174,0,3291,
  	3290,1,0,0,0,3292,3295,1,0,0,0,3293,3291,1,0,0,0,3293,3294,1,0,0,0,3294,
  	3296,1,0,0,0,3295,3293,1,0,0,0,3296,3298,3,358,179,0,3297,3299,3,298,
  	149,0,3298,3297,1,0,0,0,3298,3299,1,0,0,0,3299,3301,1,0,0,0,3300,3302,
  	3,338,169,0,3301,3300,1,0,0,0,3301,3302,1,0,0,0,3302,3304,1,0,0,0,3303,
  	3305,3,364,182,0,3304,3303,1,0,0,0,3304,3305,1,0,0,0,3305,3307,1,0,0,
  	0,3306,3308,3,330,165,0,3307,3306,1,0,0,0,3307,3308,1,0,0,0,3308,3310,
  	1,0,0,0,3309,3311,3,302,151,0,3310,3309,1,0,0,0,3310,3311,1,0,0,0,3311,
  	3314,1,0,0,0,3312,3313,4,142,53,0,3313,3315,3,304,152,0,3314,3312,1,0,
  	0,0,3314,3315,1,0,0,0,3315,285,1,0,0,0,3316,3317,3,280,140,0,3317,287,
  	1,0,0,0,3318,3319,7,28,0,0,3319,289,1,0,0,0,3320,3321,5,276,0,0,3321,
  	3322,3,294,147,0,3322,291,1,0,0,0,3323,3324,5,276,0,0,3324,3325,3,296,
  	148,0,3325,293,1,0,0,0,3326,3329,3,296,148,0,3327,3328,7,29,0,0,3328,
  	3330,3,296,148,0,3329,3327,1,0,0,0,3329,3330,1,0,0,0,3330,295,1,0,0,0,
  	3331,3334,3,1338,669,0,3332,3334,7,30,0,0,3333,3331,1,0,0,0,3333,3332,
  	1,0,0,0,3334,297,1,0,0,0,3335,3363,5,248,0,0,3336,3337,5,396,0,0,3337,
  	3339,3,1370,685,0,3338,3340,3,1192,596,0,3339,3338,1,0,0,0,3339,3340,
  	1,0,0,0,3340,3342,1,0,0,0,3341,3343,3,1194,597,0,3342,3341,1,0,0,0,3342,
  	3343,1,0,0,0,3343,3345,1,0,0,0,3344,3346,3,1198,599,0,3345,3344,1,0,0,
  	0,3345,3346,1,0,0,0,3346,3364,1,0,0,0,3347,3348,5,150,0,0,3348,3364,3,
  	1370,685,0,3349,3352,3,1398,699,0,3350,3352,3,924,462,0,3351,3349,1,0,
  	0,0,3351,3350,1,0,0,0,3352,3360,1,0,0,0,3353,3356,5,773,0,0,3354,3357,
  	3,1398,699,0,3355,3357,3,924,462,0,3356,3354,1,0,0,0,3356,3355,1,0,0,
  	0,3357,3359,1,0,0,0,3358,3353,1,0,0,0,3359,3362,1,0,0,0,3360,3358,1,0,
  	0,0,3360,3361,1,0,0,0,3361,3364,1,0,0,0,3362,3360,1,0,0,0,3363,3336,1,
  	0,0,0,3363,3347,1,0,0,0,3363,3351,1,0,0,0,3364,299,1,0,0,0,3365,3366,
  	5,422,0,0,3366,3367,5,13,0,0,3367,3373,5,776,0,0,3368,3371,5,747,0,0,
  	3369,3370,5,773,0,0,3370,3372,5,747,0,0,3371,3369,1,0,0,0,3371,3372,1,
  	0,0,0,3372,3374,1,0,0,0,3373,3368,1,0,0,0,3373,3374,1,0,0,0,3374,3375,
  	1,0,0,0,3375,3376,5,777,0,0,3376,301,1,0,0,0,3377,3378,5,221,0,0,3378,
  	3379,3,854,427,0,3379,303,1,0,0,0,3380,3381,5,699,0,0,3381,3386,3,306,
  	153,0,3382,3383,5,773,0,0,3383,3385,3,306,153,0,3384,3382,1,0,0,0,3385,
  	3388,1,0,0,0,3386,3384,1,0,0,0,3386,3387,1,0,0,0,3387,305,1,0,0,0,3388,
  	3386,1,0,0,0,3389,3390,3,1334,667,0,3390,3391,5,17,0,0,3391,3392,3,308,
  	154,0,3392,307,1,0,0,0,3393,3394,5,776,0,0,3394,3395,3,310,155,0,3395,
  	3396,5,777,0,0,3396,309,1,0,0,0,3397,3399,3,1334,667,0,3398,3397,1,0,
  	0,0,3398,3399,1,0,0,0,3399,3403,1,0,0,0,3400,3401,5,405,0,0,3401,3402,
  	5,45,0,0,3402,3404,3,962,481,0,3403,3400,1,0,0,0,3403,3404,1,0,0,0,3404,
  	3406,1,0,0,0,3405,3407,3,334,167,0,3406,3405,1,0,0,0,3406,3407,1,0,0,
  	0,3407,3409,1,0,0,0,3408,3410,3,312,156,0,3409,3408,1,0,0,0,3409,3410,
  	1,0,0,0,3410,311,1,0,0,0,3411,3412,3,314,157,0,3412,3414,3,316,158,0,
  	3413,3415,3,324,162,0,3414,3413,1,0,0,0,3414,3415,1,0,0,0,3415,313,1,
  	0,0,0,3416,3417,7,31,0,0,3417,315,1,0,0,0,3418,3421,3,318,159,0,3419,
  	3421,3,320,160,0,3420,3418,1,0,0,0,3420,3419,1,0,0,0,3421,317,1,0,0,0,
  	3422,3423,5,698,0,0,3423,3437,5,693,0,0,3424,3425,3,1354,677,0,3425,3426,
  	5,693,0,0,3426,3437,1,0,0,0,3427,3428,5,786,0,0,3428,3437,5,693,0,0,3429,
  	3430,5,247,0,0,3430,3431,3,854,427,0,3431,3432,3,952,476,0,3432,3433,
  	5,693,0,0,3433,3437,1,0,0,0,3434,3435,5,101,0,0,3435,3437,5,487,0,0,3436,
  	3422,1,0,0,0,3436,3424,1,0,0,0,3436,3427,1,0,0,0,3436,3429,1,0,0,0,3436,
  	3434,1,0,0,0,3437,319,1,0,0,0,3438,3439,5,30,0,0,3439,3440,3,322,161,
  	0,3440,3441,5,15,0,0,3441,3442,3,322,161,0,3442,321,1,0,0,0,3443,3457,
  	3,318,159,0,3444,3445,5,698,0,0,3445,3457,5,682,0,0,3446,3447,3,1354,
  	677,0,3447,3448,5,682,0,0,3448,3457,1,0,0,0,3449,3450,5,786,0,0,3450,
  	3457,5,682,0,0,3451,3452,5,247,0,0,3452,3453,3,854,427,0,3453,3454,3,
  	952,476,0,3454,3455,5,682,0,0,3455,3457,1,0,0,0,3456,3443,1,0,0,0,3456,
  	3444,1,0,0,0,3456,3446,1,0,0,0,3456,3449,1,0,0,0,3456,3451,1,0,0,0,3457,
  	323,1,0,0,0,3458,3465,5,680,0,0,3459,3460,5,101,0,0,3460,3466,5,487,0,
  	0,3461,3466,5,217,0,0,3462,3466,5,697,0,0,3463,3464,5,373,0,0,3464,3466,
  	5,690,0,0,3465,3459,1,0,0,0,3465,3461,1,0,0,0,3465,3462,1,0,0,0,3465,
  	3463,1,0,0,0,3466,325,1,0,0,0,3467,3469,5,645,0,0,3468,3470,5,665,0,0,
  	3469,3468,1,0,0,0,3469,3470,1,0,0,0,3470,3471,1,0,0,0,3471,3476,3,328,
  	164,0,3472,3473,5,773,0,0,3473,3475,3,328,164,0,3474,3472,1,0,0,0,3475,
  	3478,1,0,0,0,3476,3474,1,0,0,0,3476,3477,1,0,0,0,3477,327,1,0,0,0,3478,
  	3476,1,0,0,0,3479,3481,3,1338,669,0,3480,3482,3,1256,628,0,3481,3480,
  	1,0,0,0,3481,3482,1,0,0,0,3482,3483,1,0,0,0,3483,3484,5,17,0,0,3484,3485,
  	3,286,143,0,3485,329,1,0,0,0,3486,3487,5,217,0,0,3487,3488,5,45,0,0,3488,
  	3490,3,962,481,0,3489,3491,3,332,166,0,3490,3489,1,0,0,0,3490,3491,1,
  	0,0,0,3491,331,1,0,0,0,3492,3493,5,645,0,0,3493,3498,5,481,0,0,3494,3495,
  	4,166,54,0,3495,3496,5,645,0,0,3496,3498,5,99,0,0,3497,3492,1,0,0,0,3497,
  	3494,1,0,0,0,3498,333,1,0,0,0,3499,3500,5,393,0,0,3500,3501,5,45,0,0,
  	3501,3502,3,962,481,0,3502,335,1,0,0,0,3503,3504,7,32,0,0,3504,337,1,
  	0,0,0,3505,3508,5,203,0,0,3506,3509,5,149,0,0,3507,3509,3,340,170,0,3508,
  	3506,1,0,0,0,3508,3507,1,0,0,0,3509,339,1,0,0,0,3510,3515,3,366,183,0,
  	3511,3512,5,773,0,0,3512,3514,3,366,183,0,3513,3511,1,0,0,0,3514,3517,
  	1,0,0,0,3515,3513,1,0,0,0,3515,3516,1,0,0,0,3516,341,1,0,0,0,3517,3515,
  	1,0,0,0,3518,3519,5,626,0,0,3519,3524,3,346,173,0,3520,3521,5,773,0,0,
  	3521,3523,3,346,173,0,3522,3520,1,0,0,0,3523,3526,1,0,0,0,3524,3522,1,
  	0,0,0,3524,3525,1,0,0,0,3525,343,1,0,0,0,3526,3524,1,0,0,0,3527,3528,
  	5,574,0,0,3528,3529,3,1314,657,0,3529,345,1,0,0,0,3530,3531,5,487,0,0,
  	3531,3533,5,776,0,0,3532,3534,3,252,126,0,3533,3532,1,0,0,0,3533,3534,
  	1,0,0,0,3534,3535,1,0,0,0,3535,3536,5,777,0,0,3536,347,1,0,0,0,3537,3546,
  	3,288,144,0,3538,3546,5,535,0,0,3539,3540,4,174,55,0,3540,3546,5,533,
  	0,0,3541,3542,4,174,56,0,3542,3543,5,325,0,0,3543,3544,5,750,0,0,3544,
  	3546,3,1352,676,0,3545,3537,1,0,0,0,3545,3538,1,0,0,0,3545,3539,1,0,0,
  	0,3545,3541,1,0,0,0,3546,349,1,0,0,0,3547,3549,3,352,176,0,3548,3547,
  	1,0,0,0,3549,3550,1,0,0,0,3550,3548,1,0,0,0,3550,3551,1,0,0,0,3551,351,
  	1,0,0,0,3552,3553,5,200,0,0,3553,3557,3,354,177,0,3554,3555,4,176,57,
  	0,3555,3556,5,668,0,0,3556,3558,3,1318,659,0,3557,3554,1,0,0,0,3557,3558,
  	1,0,0,0,3558,3561,1,0,0,0,3559,3560,4,176,58,0,3560,3562,3,356,178,0,
  	3561,3559,1,0,0,0,3561,3562,1,0,0,0,3562,3568,1,0,0,0,3563,3564,5,287,
  	0,0,3564,3565,5,251,0,0,3565,3566,5,508,0,0,3566,3568,5,346,0,0,3567,
  	3552,1,0,0,0,3567,3563,1,0,0,0,3568,353,1,0,0,0,3569,3573,5,614,0,0,3570,
  	3571,4,177,59,0,3571,3573,5,508,0,0,3572,3569,1,0,0,0,3572,3570,1,0,0,
  	0,3573,355,1,0,0,0,3574,3575,5,669,0,0,3575,3578,5,670,0,0,3576,3578,
  	5,671,0,0,3577,3574,1,0,0,0,3577,3576,1,0,0,0,3578,357,1,0,0,0,3579,3582,
  	3,360,180,0,3580,3582,5,760,0,0,3581,3579,1,0,0,0,3581,3580,1,0,0,0,3582,
  	3587,1,0,0,0,3583,3584,5,773,0,0,3584,3586,3,360,180,0,3585,3583,1,0,
  	0,0,3586,3589,1,0,0,0,3587,3585,1,0,0,0,3587,3588,1,0,0,0,3588,359,1,
  	0,0,0,3589,3587,1,0,0,0,3590,3596,3,1266,633,0,3591,3593,3,854,427,0,
  	3592,3594,3,362,181,0,3593,3592,1,0,0,0,3593,3594,1,0,0,0,3594,3596,1,
  	0,0,0,3595,3590,1,0,0,0,3595,3591,1,0,0,0,3596,361,1,0,0,0,3597,3599,
  	5,17,0,0,3598,3597,1,0,0,0,3598,3599,1,0,0,0,3599,3602,1,0,0,0,3600,3603,
  	3,1338,669,0,3601,3603,3,1370,685,0,3602,3600,1,0,0,0,3602,3601,1,0,0,
  	0,3603,363,1,0,0,0,3604,3605,5,643,0,0,3605,3606,3,854,427,0,3606,365,
  	1,0,0,0,3607,3618,3,378,189,0,3608,3612,5,778,0,0,3609,3610,4,183,60,
  	0,3610,3613,3,1338,669,0,3611,3613,5,732,0,0,3612,3609,1,0,0,0,3612,3611,
  	1,0,0,0,3613,3614,1,0,0,0,3614,3615,3,368,184,0,3615,3616,5,779,0,0,3616,
  	3618,1,0,0,0,3617,3607,1,0,0,0,3617,3608,1,0,0,0,3618,3622,1,0,0,0,3619,
  	3621,3,370,185,0,3620,3619,1,0,0,0,3621,3624,1,0,0,0,3622,3620,1,0,0,
  	0,3622,3623,1,0,0,0,3623,367,1,0,0,0,3624,3622,1,0,0,0,3625,3629,3,378,
  	189,0,3626,3628,3,370,185,0,3627,3626,1,0,0,0,3628,3631,1,0,0,0,3629,
  	3627,1,0,0,0,3629,3630,1,0,0,0,3630,369,1,0,0,0,3631,3629,1,0,0,0,3632,
  	3633,3,374,187,0,3633,3638,3,366,183,0,3634,3635,5,383,0,0,3635,3639,
  	3,854,427,0,3636,3637,5,621,0,0,3637,3639,3,1342,671,0,3638,3634,1,0,
  	0,0,3638,3636,1,0,0,0,3638,3639,1,0,0,0,3639,3652,1,0,0,0,3640,3641,3,
  	376,188,0,3641,3646,3,366,183,0,3642,3643,5,383,0,0,3643,3647,3,854,427,
  	0,3644,3645,5,621,0,0,3645,3647,3,1342,671,0,3646,3642,1,0,0,0,3646,3644,
  	1,0,0,0,3647,3652,1,0,0,0,3648,3649,3,372,186,0,3649,3650,3,378,189,0,
  	3650,3652,1,0,0,0,3651,3632,1,0,0,0,3651,3640,1,0,0,0,3651,3648,1,0,0,
  	0,3652,371,1,0,0,0,3653,3655,5,359,0,0,3654,3656,5,239,0,0,3655,3654,
  	1,0,0,0,3655,3656,1,0,0,0,3656,3657,1,0,0,0,3657,3665,5,261,0,0,3658,
  	3659,5,359,0,0,3659,3661,7,33,0,0,3660,3662,5,395,0,0,3661,3660,1,0,0,
  	0,3661,3662,1,0,0,0,3662,3663,1,0,0,0,3663,3665,5,261,0,0,3664,3653,1,
  	0,0,0,3664,3658,1,0,0,0,3665,373,1,0,0,0,3666,3668,7,34,0,0,3667,3666,
  	1,0,0,0,3667,3668,1,0,0,0,3668,3669,1,0,0,0,3669,3672,5,261,0,0,3670,
  	3672,5,555,0,0,3671,3667,1,0,0,0,3671,3670,1,0,0,0,3672,375,1,0,0,0,3673,
  	3675,7,33,0,0,3674,3676,5,395,0,0,3675,3674,1,0,0,0,3675,3676,1,0,0,0,
  	3676,3677,1,0,0,0,3677,3678,5,261,0,0,3678,377,1,0,0,0,3679,3686,3,380,
  	190,0,3680,3686,3,382,191,0,3681,3686,3,384,192,0,3682,3686,3,386,193,
  	0,3683,3684,4,189,61,0,3684,3686,3,388,194,0,3685,3679,1,0,0,0,3685,3680,
  	1,0,0,0,3685,3681,1,0,0,0,3685,3682,1,0,0,0,3685,3683,1,0,0,0,3686,379,
  	1,0,0,0,3687,3689,3,1314,657,0,3688,3690,3,1248,624,0,3689,3688,1,0,0,
  	0,3689,3690,1,0,0,0,3690,3692,1,0,0,0,3691,3693,3,406,203,0,3692,3691,
  	1,0,0,0,3692,3693,1,0,0,0,3693,3695,1,0,0,0,3694,3696,3,408,204,0,3695,
  	3694,1,0,0,0,3695,3696,1,0,0,0,3696,381,1,0,0,0,3697,3700,5,776,0,0,3698,
  	3701,3,380,190,0,3699,3701,3,382,191,0,3700,3698,1,0,0,0,3700,3699,1,
  	0,0,0,3701,3702,1,0,0,0,3702,3703,5,777,0,0,3703,383,1,0,0,0,3704,3706,
  	3,286,143,0,3705,3707,3,406,203,0,3706,3705,1,0,0,0,3706,3707,1,0,0,0,
  	3707,3710,1,0,0,0,3708,3709,4,192,62,0,3709,3711,3,1256,628,0,3710,3708,
  	1,0,0,0,3710,3711,1,0,0,0,3711,3722,1,0,0,0,3712,3713,4,192,63,0,3713,
  	3714,5,726,0,0,3714,3716,3,286,143,0,3715,3717,3,406,203,0,3716,3715,
  	1,0,0,0,3716,3717,1,0,0,0,3717,3719,1,0,0,0,3718,3720,3,1256,628,0,3719,
  	3718,1,0,0,0,3719,3720,1,0,0,0,3720,3722,1,0,0,0,3721,3704,1,0,0,0,3721,
  	3712,1,0,0,0,3722,385,1,0,0,0,3723,3726,5,776,0,0,3724,3727,3,340,170,
  	0,3725,3727,3,386,193,0,3726,3724,1,0,0,0,3726,3725,1,0,0,0,3727,3728,
  	1,0,0,0,3728,3729,5,777,0,0,3729,387,1,0,0,0,3730,3731,5,701,0,0,3731,
  	3732,5,776,0,0,3732,3733,3,854,427,0,3733,3734,5,773,0,0,3734,3735,3,
  	1370,685,0,3735,3736,3,390,195,0,3736,3738,5,777,0,0,3737,3739,3,406,
  	203,0,3738,3737,1,0,0,0,3738,3739,1,0,0,0,3739,389,1,0,0,0,3740,3741,
  	5,71,0,0,3741,3742,5,776,0,0,3742,3747,3,392,196,0,3743,3744,5,773,0,
  	0,3744,3746,3,392,196,0,3745,3743,1,0,0,0,3746,3749,1,0,0,0,3747,3745,
  	1,0,0,0,3747,3748,1,0,0,0,3748,3750,1,0,0,0,3749,3747,1,0,0,0,3750,3751,
  	5,777,0,0,3751,391,1,0,0,0,3752,3753,3,1338,669,0,3753,3754,5,200,0,0,
  	3754,3755,5,703,0,0,3755,3776,1,0,0,0,3756,3757,3,1338,669,0,3757,3760,
  	3,1108,554,0,3758,3759,4,196,64,0,3759,3761,3,1180,590,0,3760,3758,1,
  	0,0,0,3760,3761,1,0,0,0,3761,3763,1,0,0,0,3762,3764,5,174,0,0,3763,3762,
  	1,0,0,0,3763,3764,1,0,0,0,3764,3765,1,0,0,0,3765,3766,5,704,0,0,3766,
  	3768,3,1370,685,0,3767,3769,3,396,198,0,3768,3767,1,0,0,0,3768,3769,1,
  	0,0,0,3769,3776,1,0,0,0,3770,3771,5,702,0,0,3771,3772,5,704,0,0,3772,
  	3773,3,1370,685,0,3773,3774,3,390,195,0,3774,3776,1,0,0,0,3775,3752,1,
  	0,0,0,3775,3756,1,0,0,0,3775,3770,1,0,0,0,3776,393,1,0,0,0,3777,3779,
  	3,398,199,0,3778,3780,3,400,200,0,3779,3778,1,0,0,0,3779,3780,1,0,0,0,
  	3780,3783,1,0,0,0,3781,3783,3,400,200,0,3782,3777,1,0,0,0,3782,3781,1,
  	0,0,0,3783,395,1,0,0,0,3784,3789,3,394,197,0,3785,3786,3,400,200,0,3786,
  	3787,3,398,199,0,3787,3789,1,0,0,0,3788,3784,1,0,0,0,3788,3785,1,0,0,
  	0,3789,397,1,0,0,0,3790,3791,3,402,201,0,3791,3792,5,383,0,0,3792,3793,
  	5,700,0,0,3793,399,1,0,0,0,3794,3795,3,402,201,0,3795,3796,5,383,0,0,
  	3796,3797,5,165,0,0,3797,401,1,0,0,0,3798,3803,5,165,0,0,3799,3803,5,
  	376,0,0,3800,3801,5,128,0,0,3801,3803,3,1370,685,0,3802,3798,1,0,0,0,
  	3802,3799,1,0,0,0,3802,3800,1,0,0,0,3803,403,1,0,0,0,3804,3805,7,35,0,
  	0,3805,405,1,0,0,0,3806,3810,5,17,0,0,3807,3808,4,203,65,0,3808,3810,
  	5,750,0,0,3809,3806,1,0,0,0,3809,3807,1,0,0,0,3809,3810,1,0,0,0,3810,
  	3811,1,0,0,0,3811,3812,3,1338,669,0,3812,407,1,0,0,0,3813,3818,3,410,
  	205,0,3814,3815,5,773,0,0,3815,3817,3,410,205,0,3816,3814,1,0,0,0,3817,
  	3820,1,0,0,0,3818,3816,1,0,0,0,3818,3819,1,0,0,0,3819,409,1,0,0,0,3820,
  	3818,1,0,0,0,3821,3822,3,412,206,0,3822,3824,3,414,207,0,3823,3825,3,
  	418,209,0,3824,3823,1,0,0,0,3824,3825,1,0,0,0,3825,3826,1,0,0,0,3826,
  	3827,5,776,0,0,3827,3828,3,420,210,0,3828,3829,5,777,0,0,3829,3842,1,
  	0,0,0,3830,3831,5,620,0,0,3831,3833,3,414,207,0,3832,3834,3,418,209,0,
  	3833,3832,1,0,0,0,3833,3834,1,0,0,0,3834,3835,1,0,0,0,3835,3837,5,776,
  	0,0,3836,3838,3,420,210,0,3837,3836,1,0,0,0,3837,3838,1,0,0,0,3838,3839,
  	1,0,0,0,3839,3840,5,777,0,0,3840,3842,1,0,0,0,3841,3821,1,0,0,0,3841,
  	3830,1,0,0,0,3842,411,1,0,0,0,3843,3844,7,36,0,0,3844,413,1,0,0,0,3845,
  	3846,7,37,0,0,3846,415,1,0,0,0,3847,3848,5,420,0,0,3848,3854,5,265,0,
  	0,3849,3851,5,609,0,0,3850,3852,3,414,207,0,3851,3850,1,0,0,0,3851,3852,
  	1,0,0,0,3852,3854,1,0,0,0,3853,3847,1,0,0,0,3853,3849,1,0,0,0,3854,417,
  	1,0,0,0,3855,3861,5,200,0,0,3856,3862,5,261,0,0,3857,3858,5,393,0,0,3858,
  	3862,5,45,0,0,3859,3860,5,217,0,0,3860,3862,5,45,0,0,3861,3856,1,0,0,
  	0,3861,3857,1,0,0,0,3861,3859,1,0,0,0,3862,419,1,0,0,0,3863,3868,3,422,
  	211,0,3864,3865,5,773,0,0,3865,3867,3,422,211,0,3866,3864,1,0,0,0,3867,
  	3870,1,0,0,0,3868,3866,1,0,0,0,3868,3869,1,0,0,0,3869,421,1,0,0,0,3870,
  	3868,1,0,0,0,3871,3874,3,1338,669,0,3872,3874,5,420,0,0,3873,3871,1,0,
  	0,0,3873,3872,1,0,0,0,3874,423,1,0,0,0,3875,3876,4,212,66,0,3876,3878,
  	3,326,163,0,3877,3875,1,0,0,0,3877,3878,1,0,0,0,3878,3879,1,0,0,0,3879,
  	3881,5,614,0,0,3880,3882,5,295,0,0,3881,3880,1,0,0,0,3881,3882,1,0,0,
  	0,3882,3884,1,0,0,0,3883,3885,5,232,0,0,3884,3883,1,0,0,0,3884,3885,1,
  	0,0,0,3885,3886,1,0,0,0,3886,3887,3,340,170,0,3887,3888,5,506,0,0,3888,
  	3890,3,1188,594,0,3889,3891,3,364,182,0,3890,3889,1,0,0,0,3890,3891,1,
  	0,0,0,3891,3893,1,0,0,0,3892,3894,3,334,167,0,3893,3892,1,0,0,0,3893,
  	3894,1,0,0,0,3894,3896,1,0,0,0,3895,3897,3,292,146,0,3896,3895,1,0,0,
  	0,3896,3897,1,0,0,0,3897,425,1,0,0,0,3898,3903,3,428,214,0,3899,3903,
  	3,434,217,0,3900,3903,3,436,218,0,3901,3903,3,442,221,0,3902,3898,1,0,
  	0,0,3902,3899,1,0,0,0,3902,3900,1,0,0,0,3902,3901,1,0,0,0,3903,427,1,
  	0,0,0,3904,3905,5,543,0,0,3905,3909,5,592,0,0,3906,3908,3,432,216,0,3907,
  	3906,1,0,0,0,3908,3911,1,0,0,0,3909,3907,1,0,0,0,3909,3910,1,0,0,0,3910,
  	3930,1,0,0,0,3911,3909,1,0,0,0,3912,3914,5,77,0,0,3913,3915,5,647,0,0,
  	3914,3913,1,0,0,0,3914,3915,1,0,0,0,3915,3921,1,0,0,0,3916,3918,5,15,
  	0,0,3917,3919,5,373,0,0,3918,3917,1,0,0,0,3918,3919,1,0,0,0,3919,3920,
  	1,0,0,0,3920,3922,5,54,0,0,3921,3916,1,0,0,0,3921,3922,1,0,0,0,3922,3927,
  	1,0,0,0,3923,3925,5,373,0,0,3924,3923,1,0,0,0,3924,3925,1,0,0,0,3925,
  	3926,1,0,0,0,3926,3928,5,450,0,0,3927,3924,1,0,0,0,3927,3928,1,0,0,0,
  	3928,3930,1,0,0,0,3929,3904,1,0,0,0,3929,3912,1,0,0,0,3930,429,1,0,0,
  	0,3931,3933,5,29,0,0,3932,3934,5,647,0,0,3933,3932,1,0,0,0,3933,3934,
  	1,0,0,0,3934,431,1,0,0,0,3935,3936,5,645,0,0,3936,3937,5,85,0,0,3937,
  	3941,5,517,0,0,3938,3939,5,435,0,0,3939,3941,7,38,0,0,3940,3935,1,0,0,
  	0,3940,3938,1,0,0,0,3941,433,1,0,0,0,3942,3943,5,489,0,0,3943,3972,3,
  	1338,669,0,3944,3946,5,480,0,0,3945,3947,5,647,0,0,3946,3945,1,0,0,0,
  	3946,3947,1,0,0,0,3947,3966,1,0,0,0,3948,3950,5,590,0,0,3949,3951,5,489,
  	0,0,3950,3949,1,0,0,0,3950,3951,1,0,0,0,3951,3952,1,0,0,0,3952,3967,3,
  	1338,669,0,3953,3955,5,15,0,0,3954,3956,5,373,0,0,3955,3954,1,0,0,0,3955,
  	3956,1,0,0,0,3956,3957,1,0,0,0,3957,3959,5,54,0,0,3958,3953,1,0,0,0,3958,
  	3959,1,0,0,0,3959,3964,1,0,0,0,3960,3962,5,373,0,0,3961,3960,1,0,0,0,
  	3961,3962,1,0,0,0,3962,3963,1,0,0,0,3963,3965,5,450,0,0,3964,3961,1,0,
  	0,0,3964,3965,1,0,0,0,3965,3967,1,0,0,0,3966,3948,1,0,0,0,3966,3958,1,
  	0,0,0,3967,3972,1,0,0,0,3968,3969,5,450,0,0,3969,3970,5,489,0,0,3970,
  	3972,3,1338,669,0,3971,3942,1,0,0,0,3971,3944,1,0,0,0,3971,3968,1,0,0,
  	0,3972,435,1,0,0,0,3973,3974,5,287,0,0,3974,3975,7,17,0,0,3975,3980,3,
  	438,219,0,3976,3977,5,773,0,0,3977,3979,3,438,219,0,3978,3976,1,0,0,0,
  	3979,3982,1,0,0,0,3980,3978,1,0,0,0,3980,3981,1,0,0,0,3981,3996,1,0,0,
  	0,3982,3980,1,0,0,0,3983,3984,4,218,67,0,3984,3985,5,287,0,0,3985,3986,
  	5,244,0,0,3986,3987,5,200,0,0,3987,3996,5,27,0,0,3988,3993,5,611,0,0,
  	3989,3994,5,571,0,0,3990,3994,5,574,0,0,3991,3992,4,218,68,0,3992,3994,
  	5,244,0,0,3993,3989,1,0,0,0,3993,3990,1,0,0,0,3993,3991,1,0,0,0,3994,
  	3996,1,0,0,0,3995,3973,1,0,0,0,3995,3983,1,0,0,0,3995,3988,1,0,0,0,3996,
  	437,1,0,0,0,3997,3999,3,1314,657,0,3998,4000,3,406,203,0,3999,3998,1,
  	0,0,0,3999,4000,1,0,0,0,4000,4001,1,0,0,0,4001,4002,3,440,220,0,4002,
  	439,1,0,0,0,4003,4005,5,435,0,0,4004,4006,5,284,0,0,4005,4004,1,0,0,0,
  	4005,4006,1,0,0,0,4006,4012,1,0,0,0,4007,4009,5,295,0,0,4008,4007,1,0,
  	0,0,4008,4009,1,0,0,0,4009,4010,1,0,0,0,4010,4012,5,649,0,0,4011,4003,
  	1,0,0,0,4011,4008,1,0,0,0,4012,441,1,0,0,0,4013,4040,5,651,0,0,4014,4015,
  	7,39,0,0,4015,4017,3,446,223,0,4016,4018,7,40,0,0,4017,4016,1,0,0,0,4017,
  	4018,1,0,0,0,4018,4041,1,0,0,0,4019,4020,5,159,0,0,4020,4026,3,446,223,
  	0,4021,4024,5,566,0,0,4022,4023,5,200,0,0,4023,4025,5,340,0,0,4024,4022,
  	1,0,0,0,4024,4025,1,0,0,0,4025,4027,1,0,0,0,4026,4021,1,0,0,0,4026,4027,
  	1,0,0,0,4027,4041,1,0,0,0,4028,4029,5,417,0,0,4029,4041,3,446,223,0,4030,
  	4031,5,77,0,0,4031,4034,3,446,223,0,4032,4033,5,384,0,0,4033,4035,5,407,
  	0,0,4034,4032,1,0,0,0,4034,4035,1,0,0,0,4035,4041,1,0,0,0,4036,4037,5,
  	480,0,0,4037,4041,3,446,223,0,4038,4039,5,439,0,0,4039,4041,3,444,222,
  	0,4040,4014,1,0,0,0,4040,4019,1,0,0,0,4040,4028,1,0,0,0,4040,4030,1,0,
  	0,0,4040,4036,1,0,0,0,4040,4038,1,0,0,0,4041,443,1,0,0,0,4042,4045,4,
  	222,69,0,4043,4044,5,94,0,0,4044,4046,5,652,0,0,4045,4043,1,0,0,0,4045,
  	4046,1,0,0,0,4046,4049,1,0,0,0,4047,4049,1,0,0,0,4048,4042,1,0,0,0,4048,
  	4047,1,0,0,0,4049,445,1,0,0,0,4050,4057,3,1372,686,0,4051,4052,5,773,
  	0,0,4052,4055,3,1372,686,0,4053,4054,5,773,0,0,4054,4056,3,1350,675,0,
  	4055,4053,1,0,0,0,4055,4056,1,0,0,0,4056,4058,1,0,0,0,4057,4051,1,0,0,
  	0,4057,4058,1,0,0,0,4058,447,1,0,0,0,4059,4060,5,428,0,0,4060,4061,7,
  	41,0,0,4061,4066,5,289,0,0,4062,4063,5,590,0,0,4063,4067,3,1376,688,0,
  	4064,4065,5,28,0,0,4065,4067,3,854,427,0,4066,4062,1,0,0,0,4066,4064,
  	1,0,0,0,4067,4094,1,0,0,0,4068,4094,3,458,229,0,4069,4070,5,468,0,0,4070,
  	4075,3,450,225,0,4071,4072,5,773,0,0,4072,4074,3,450,225,0,4073,4071,
  	1,0,0,0,4074,4077,1,0,0,0,4075,4073,1,0,0,0,4075,4076,1,0,0,0,4076,4094,
  	1,0,0,0,4077,4075,1,0,0,0,4078,4079,4,224,70,0,4079,4080,5,468,0,0,4080,
  	4085,5,658,0,0,4081,4083,3,1172,586,0,4082,4081,1,0,0,0,4082,4083,1,0,
  	0,0,4083,4084,1,0,0,0,4084,4086,3,1338,669,0,4085,4082,1,0,0,0,4085,4086,
  	1,0,0,0,4086,4094,1,0,0,0,4087,4094,3,544,272,0,4088,4094,3,546,273,0,
  	4089,4094,3,530,265,0,4090,4094,3,454,227,0,4091,4092,4,224,71,0,4092,
  	4094,3,562,281,0,4093,4059,1,0,0,0,4093,4068,1,0,0,0,4093,4069,1,0,0,
  	0,4093,4078,1,0,0,0,4093,4087,1,0,0,0,4093,4088,1,0,0,0,4093,4089,1,0,
  	0,0,4093,4090,1,0,0,0,4093,4091,1,0,0,0,4094,449,1,0,0,0,4095,4097,5,
  	316,0,0,4096,4098,3,452,226,0,4097,4096,1,0,0,0,4097,4098,1,0,0,0,4098,
  	4110,1,0,0,0,4099,4100,4,225,72,0,4100,4101,5,430,0,0,4101,4110,5,47,
  	0,0,4102,4104,3,574,287,0,4103,4105,5,10,0,0,4104,4103,1,0,0,0,4104,4105,
  	1,0,0,0,4105,4107,1,0,0,0,4106,4108,3,970,485,0,4107,4106,1,0,0,0,4107,
  	4108,1,0,0,0,4108,4110,1,0,0,0,4109,4095,1,0,0,0,4109,4099,1,0,0,0,4109,
  	4102,1,0,0,0,4110,451,1,0,0,0,4111,4112,4,226,73,0,4112,4117,5,590,0,
  	0,4113,4114,4,226,74,0,4114,4118,3,1352,676,0,4115,4116,4,226,75,0,4116,
  	4118,3,1356,678,0,4117,4113,1,0,0,0,4117,4115,1,0,0,0,4118,453,1,0,0,
  	0,4119,4123,5,281,0,0,4120,4124,5,112,0,0,4121,4122,5,574,0,0,4122,4124,
  	3,1314,657,0,4123,4120,1,0,0,0,4123,4121,1,0,0,0,4124,4125,1,0,0,0,4125,
  	4126,5,203,0,0,4126,4127,5,316,0,0,4127,455,1,0,0,0,4128,4133,5,316,0,
  	0,4129,4130,4,228,76,0,4130,4131,5,459,0,0,4131,4133,5,522,0,0,4132,4128,
  	1,0,0,0,4132,4129,1,0,0,0,4133,457,1,0,0,0,4134,4135,5,55,0,0,4135,4136,
  	3,456,228,0,4136,4137,5,590,0,0,4137,4139,3,460,230,0,4138,4140,3,970,
  	485,0,4139,4138,1,0,0,0,4139,4140,1,0,0,0,4140,459,1,0,0,0,4141,4146,
  	3,462,231,0,4142,4143,5,773,0,0,4143,4145,3,462,231,0,4144,4142,1,0,0,
  	0,4145,4148,1,0,0,0,4146,4144,1,0,0,0,4146,4147,1,0,0,0,4147,461,1,0,
  	0,0,4148,4146,1,0,0,0,4149,4150,3,466,233,0,4150,4151,5,750,0,0,4151,
  	4152,3,1378,689,0,4152,4278,1,0,0,0,4153,4154,5,729,0,0,4154,4155,5,750,
  	0,0,4155,4278,3,1378,689,0,4156,4157,3,468,234,0,4157,4158,5,750,0,0,
  	4158,4159,3,1378,689,0,4159,4278,1,0,0,0,4160,4161,3,470,235,0,4161,4162,
  	5,750,0,0,4162,4163,3,1378,689,0,4163,4278,1,0,0,0,4164,4165,3,472,236,
  	0,4165,4166,5,750,0,0,4166,4167,3,1378,689,0,4167,4278,1,0,0,0,4168,4169,
  	3,474,237,0,4169,4170,5,750,0,0,4170,4171,3,1350,675,0,4171,4278,1,0,
  	0,0,4172,4173,3,476,238,0,4173,4174,5,750,0,0,4174,4175,3,1350,675,0,
  	4175,4278,1,0,0,0,4176,4177,3,478,239,0,4177,4178,5,750,0,0,4178,4179,
  	3,1350,675,0,4179,4278,1,0,0,0,4180,4181,3,480,240,0,4181,4182,5,750,
  	0,0,4182,4183,3,1350,675,0,4183,4278,1,0,0,0,4184,4185,3,482,241,0,4185,
  	4186,5,750,0,0,4186,4187,3,1350,675,0,4187,4278,1,0,0,0,4188,4189,3,484,
  	242,0,4189,4190,5,750,0,0,4190,4191,3,1378,689,0,4191,4278,1,0,0,0,4192,
  	4193,3,486,243,0,4193,4194,5,750,0,0,4194,4195,3,1378,689,0,4195,4278,
  	1,0,0,0,4196,4197,3,498,249,0,4197,4198,5,750,0,0,4198,4199,3,1378,689,
  	0,4199,4278,1,0,0,0,4200,4201,3,502,251,0,4201,4202,5,750,0,0,4202,4203,
  	3,1378,689,0,4203,4278,1,0,0,0,4204,4205,3,500,250,0,4205,4206,5,750,
  	0,0,4206,4207,3,520,260,0,4207,4278,1,0,0,0,4208,4209,3,488,244,0,4209,
  	4210,5,750,0,0,4210,4211,3,1378,689,0,4211,4278,1,0,0,0,4212,4213,3,494,
  	247,0,4213,4214,5,750,0,0,4214,4215,3,1378,689,0,4215,4278,1,0,0,0,4216,
  	4217,3,496,248,0,4217,4218,5,750,0,0,4218,4219,3,1350,675,0,4219,4278,
  	1,0,0,0,4220,4221,3,490,245,0,4221,4222,5,750,0,0,4222,4223,3,1376,688,
  	0,4223,4278,1,0,0,0,4224,4225,3,492,246,0,4225,4226,5,750,0,0,4226,4227,
  	3,1378,689,0,4227,4278,1,0,0,0,4228,4229,3,504,252,0,4229,4230,5,750,
  	0,0,4230,4231,3,1378,689,0,4231,4278,1,0,0,0,4232,4233,3,506,253,0,4233,
  	4234,5,750,0,0,4234,4235,3,1350,675,0,4235,4278,1,0,0,0,4236,4237,3,508,
  	254,0,4237,4238,5,750,0,0,4238,4239,3,1350,675,0,4239,4278,1,0,0,0,4240,
  	4241,5,233,0,0,4241,4242,5,750,0,0,4242,4278,3,528,264,0,4243,4244,3,
  	510,255,0,4244,4245,5,750,0,0,4245,4246,3,1370,685,0,4246,4278,1,0,0,
  	0,4247,4248,3,512,256,0,4248,4249,5,750,0,0,4249,4250,3,1350,675,0,4250,
  	4278,1,0,0,0,4251,4252,3,464,232,0,4252,4253,5,750,0,0,4253,4254,3,1350,
  	675,0,4254,4278,1,0,0,0,4255,4256,5,737,0,0,4256,4257,5,750,0,0,4257,
  	4278,3,514,257,0,4258,4259,5,739,0,0,4259,4260,5,750,0,0,4260,4278,3,
  	1350,675,0,4261,4262,5,742,0,0,4262,4263,5,750,0,0,4263,4278,3,516,258,
  	0,4264,4265,4,231,77,0,4265,4266,5,799,0,0,4266,4267,5,750,0,0,4267,4278,
  	3,1352,676,0,4268,4269,4,231,78,0,4269,4270,5,804,0,0,4270,4271,5,750,
  	0,0,4271,4278,3,518,259,0,4272,4273,4,231,79,0,4273,4274,5,842,0,0,4274,
  	4275,5,750,0,0,4275,4278,3,1352,676,0,4276,4278,3,522,261,0,4277,4149,
  	1,0,0,0,4277,4153,1,0,0,0,4277,4156,1,0,0,0,4277,4160,1,0,0,0,4277,4164,
  	1,0,0,0,4277,4168,1,0,0,0,4277,4172,1,0,0,0,4277,4176,1,0,0,0,4277,4180,
  	1,0,0,0,4277,4184,1,0,0,0,4277,4188,1,0,0,0,4277,4192,1,0,0,0,4277,4196,
  	1,0,0,0,4277,4200,1,0,0,0,4277,4204,1,0,0,0,4277,4208,1,0,0,0,4277,4212,
  	1,0,0,0,4277,4216,1,0,0,0,4277,4220,1,0,0,0,4277,4224,1,0,0,0,4277,4228,
  	1,0,0,0,4277,4232,1,0,0,0,4277,4236,1,0,0,0,4277,4240,1,0,0,0,4277,4243,
  	1,0,0,0,4277,4247,1,0,0,0,4277,4251,1,0,0,0,4277,4255,1,0,0,0,4277,4258,
  	1,0,0,0,4277,4261,1,0,0,0,4277,4264,1,0,0,0,4277,4268,1,0,0,0,4277,4272,
  	1,0,0,0,4277,4276,1,0,0,0,4278,463,1,0,0,0,4279,4280,7,42,0,0,4280,465,
  	1,0,0,0,4281,4282,7,43,0,0,4282,467,1,0,0,0,4283,4284,7,44,0,0,4284,469,
  	1,0,0,0,4285,4286,7,45,0,0,4286,471,1,0,0,0,4287,4288,7,46,0,0,4288,473,
  	1,0,0,0,4289,4290,7,47,0,0,4290,475,1,0,0,0,4291,4292,7,48,0,0,4292,477,
  	1,0,0,0,4293,4294,7,49,0,0,4294,479,1,0,0,0,4295,4296,7,50,0,0,4296,481,
  	1,0,0,0,4297,4298,7,51,0,0,4298,483,1,0,0,0,4299,4300,7,52,0,0,4300,485,
  	1,0,0,0,4301,4302,7,53,0,0,4302,487,1,0,0,0,4303,4304,7,54,0,0,4304,489,
  	1,0,0,0,4305,4306,7,55,0,0,4306,491,1,0,0,0,4307,4308,7,56,0,0,4308,493,
  	1,0,0,0,4309,4310,7,57,0,0,4310,495,1,0,0,0,4311,4312,7,58,0,0,4312,497,
  	1,0,0,0,4313,4314,7,59,0,0,4314,499,1,0,0,0,4315,4316,7,60,0,0,4316,501,
  	1,0,0,0,4317,4318,7,61,0,0,4318,503,1,0,0,0,4319,4320,7,62,0,0,4320,505,
  	1,0,0,0,4321,4322,7,63,0,0,4322,507,1,0,0,0,4323,4324,7,64,0,0,4324,509,
  	1,0,0,0,4325,4326,7,65,0,0,4326,511,1,0,0,0,4327,4328,7,66,0,0,4328,513,
  	1,0,0,0,4329,4332,3,1236,618,0,4330,4332,5,376,0,0,4331,4329,1,0,0,0,
  	4331,4330,1,0,0,0,4332,515,1,0,0,0,4333,4334,7,67,0,0,4334,517,1,0,0,
  	0,4335,4339,5,744,0,0,4336,4339,5,284,0,0,4337,4339,3,1370,685,0,4338,
  	4335,1,0,0,0,4338,4336,1,0,0,0,4338,4337,1,0,0,0,4339,519,1,0,0,0,4340,
  	4343,3,1378,689,0,4341,4343,5,376,0,0,4342,4340,1,0,0,0,4342,4341,1,0,
  	0,0,4343,521,1,0,0,0,4344,4345,3,524,262,0,4345,4346,5,750,0,0,4346,4347,
  	3,1378,689,0,4347,4359,1,0,0,0,4348,4349,3,526,263,0,4349,4350,5,750,
  	0,0,4350,4351,3,1354,677,0,4351,4359,1,0,0,0,4352,4353,5,447,0,0,4353,
  	4354,5,750,0,0,4354,4359,3,1378,689,0,4355,4356,5,448,0,0,4356,4357,5,
  	750,0,0,4357,4359,3,1350,675,0,4358,4344,1,0,0,0,4358,4348,1,0,0,0,4358,
  	4352,1,0,0,0,4358,4355,1,0,0,0,4359,523,1,0,0,0,4360,4361,7,68,0,0,4361,
  	525,1,0,0,0,4362,4363,7,69,0,0,4363,527,1,0,0,0,4364,4373,5,776,0,0,4365,
  	4370,3,1350,675,0,4366,4367,5,773,0,0,4367,4369,3,1350,675,0,4368,4366,
  	1,0,0,0,4369,4372,1,0,0,0,4370,4368,1,0,0,0,4370,4371,1,0,0,0,4371,4374,
  	1,0,0,0,4372,4370,1,0,0,0,4373,4365,1,0,0,0,4373,4374,1,0,0,0,4374,4375,
  	1,0,0,0,4375,4376,5,777,0,0,4376,529,1,0,0,0,4377,4378,5,55,0,0,4378,
  	4379,5,459,0,0,4379,4380,5,190,0,0,4380,4385,3,532,266,0,4381,4382,5,
  	773,0,0,4382,4384,3,532,266,0,4383,4381,1,0,0,0,4384,4387,1,0,0,0,4385,
  	4383,1,0,0,0,4385,4386,1,0,0,0,4386,4390,1,0,0,0,4387,4385,1,0,0,0,4388,
  	4389,4,265,80,0,4389,4391,3,970,485,0,4390,4388,1,0,0,0,4390,4391,1,0,
  	0,0,4391,531,1,0,0,0,4392,4393,5,460,0,0,4393,4394,5,750,0,0,4394,4396,
  	5,776,0,0,4395,4397,3,534,267,0,4396,4395,1,0,0,0,4396,4397,1,0,0,0,4397,
  	4398,1,0,0,0,4398,4442,5,777,0,0,4399,4400,5,461,0,0,4400,4401,5,750,
  	0,0,4401,4403,5,776,0,0,4402,4404,3,534,267,0,4403,4402,1,0,0,0,4403,
  	4404,1,0,0,0,4404,4405,1,0,0,0,4405,4442,5,777,0,0,4406,4407,5,462,0,
  	0,4407,4408,5,750,0,0,4408,4410,5,776,0,0,4409,4411,3,536,268,0,4410,
  	4409,1,0,0,0,4410,4411,1,0,0,0,4411,4412,1,0,0,0,4412,4442,5,777,0,0,
  	4413,4414,5,463,0,0,4414,4415,5,750,0,0,4415,4417,5,776,0,0,4416,4418,
  	3,536,268,0,4417,4416,1,0,0,0,4417,4418,1,0,0,0,4418,4419,1,0,0,0,4419,
  	4442,5,777,0,0,4420,4421,5,464,0,0,4421,4422,5,750,0,0,4422,4424,5,776,
  	0,0,4423,4425,3,538,269,0,4424,4423,1,0,0,0,4424,4425,1,0,0,0,4425,4426,
  	1,0,0,0,4426,4442,5,777,0,0,4427,4428,5,465,0,0,4428,4429,5,750,0,0,4429,
  	4431,5,776,0,0,4430,4432,3,538,269,0,4431,4430,1,0,0,0,4431,4432,1,0,
  	0,0,4432,4433,1,0,0,0,4433,4442,5,777,0,0,4434,4435,5,466,0,0,4435,4436,
  	5,750,0,0,4436,4438,5,776,0,0,4437,4439,3,542,271,0,4438,4437,1,0,0,0,
  	4438,4439,1,0,0,0,4439,4440,1,0,0,0,4440,4442,5,777,0,0,4441,4392,1,0,
  	0,0,4441,4399,1,0,0,0,4441,4406,1,0,0,0,4441,4413,1,0,0,0,4441,4420,1,
  	0,0,0,4441,4427,1,0,0,0,4441,4434,1,0,0,0,4442,533,1,0,0,0,4443,4448,
  	3,1270,635,0,4444,4445,5,773,0,0,4445,4447,3,1270,635,0,4446,4444,1,0,
  	0,0,4447,4450,1,0,0,0,4448,4446,1,0,0,0,4448,4449,1,0,0,0,4449,535,1,
  	0,0,0,4450,4448,1,0,0,0,4451,4456,3,1310,655,0,4452,4453,5,773,0,0,4453,
  	4455,3,1310,655,0,4454,4452,1,0,0,0,4455,4458,1,0,0,0,4456,4454,1,0,0,
  	0,4456,4457,1,0,0,0,4457,537,1,0,0,0,4458,4456,1,0,0,0,4459,4464,3,540,
  	270,0,4460,4461,5,773,0,0,4461,4463,3,540,270,0,4462,4460,1,0,0,0,4463,
  	4466,1,0,0,0,4464,4462,1,0,0,0,4464,4465,1,0,0,0,4465,539,1,0,0,0,4466,
  	4464,1,0,0,0,4467,4468,3,1378,689,0,4468,541,1,0,0,0,4469,4474,3,1184,
  	592,0,4470,4471,5,773,0,0,4471,4473,3,1184,592,0,4472,4470,1,0,0,0,4473,
  	4476,1,0,0,0,4474,4472,1,0,0,0,4474,4475,1,0,0,0,4475,543,1,0,0,0,4476,
  	4474,1,0,0,0,4477,4478,5,543,0,0,4478,4480,3,574,287,0,4479,4481,3,558,
  	279,0,4480,4479,1,0,0,0,4480,4481,1,0,0,0,4481,4484,1,0,0,0,4482,4483,
  	5,613,0,0,4483,4485,3,548,274,0,4484,4482,1,0,0,0,4484,4485,1,0,0,0,4485,
  	4487,1,0,0,0,4486,4488,3,550,275,0,4487,4486,1,0,0,0,4487,4488,1,0,0,
  	0,4488,4490,1,0,0,0,4489,4491,3,552,276,0,4490,4489,1,0,0,0,4490,4491,
  	1,0,0,0,4491,4493,1,0,0,0,4492,4494,3,554,277,0,4493,4492,1,0,0,0,4493,
  	4494,1,0,0,0,4494,4496,1,0,0,0,4495,4497,3,556,278,0,4496,4495,1,0,0,
  	0,4496,4497,1,0,0,0,4497,4499,1,0,0,0,4498,4500,3,970,485,0,4499,4498,
  	1,0,0,0,4499,4500,1,0,0,0,4500,545,1,0,0,0,4501,4502,5,552,0,0,4502,4504,
  	3,574,287,0,4503,4505,3,558,279,0,4504,4503,1,0,0,0,4504,4505,1,0,0,0,
  	4505,4507,1,0,0,0,4506,4508,3,970,485,0,4507,4506,1,0,0,0,4507,4508,1,
  	0,0,0,4508,547,1,0,0,0,4509,4515,3,522,261,0,4510,4511,7,70,0,0,4511,
  	4512,5,750,0,0,4512,4515,3,1372,686,0,4513,4515,5,529,0,0,4514,4509,1,
  	0,0,0,4514,4510,1,0,0,0,4514,4513,1,0,0,0,4515,4520,1,0,0,0,4516,4517,
  	5,773,0,0,4517,4519,3,522,261,0,4518,4516,1,0,0,0,4519,4522,1,0,0,0,4520,
  	4518,1,0,0,0,4520,4521,1,0,0,0,4521,549,1,0,0,0,4522,4520,1,0,0,0,4523,
  	4524,5,618,0,0,4524,4525,5,750,0,0,4525,4526,3,1372,686,0,4526,551,1,
  	0,0,0,4527,4528,5,406,0,0,4528,4529,5,750,0,0,4529,4530,3,1372,686,0,
  	4530,553,1,0,0,0,4531,4532,5,129,0,0,4532,4533,5,750,0,0,4533,4534,3,
  	1372,686,0,4534,555,1,0,0,0,4535,4536,5,409,0,0,4536,4537,5,750,0,0,4537,
  	4538,3,1372,686,0,4538,557,1,0,0,0,4539,4544,3,560,280,0,4540,4541,5,
  	773,0,0,4541,4543,3,560,280,0,4542,4540,1,0,0,0,4543,4546,1,0,0,0,4544,
  	4542,1,0,0,0,4544,4545,1,0,0,0,4545,559,1,0,0,0,4546,4544,1,0,0,0,4547,
  	4548,7,71,0,0,4548,561,1,0,0,0,4549,4550,5,543,0,0,4550,4553,5,210,0,
  	0,4551,4552,4,281,81,0,4552,4554,3,564,282,0,4553,4551,1,0,0,0,4553,4554,
  	1,0,0,0,4554,4558,1,0,0,0,4555,4556,5,552,0,0,4556,4558,5,210,0,0,4557,
  	4549,1,0,0,0,4557,4555,1,0,0,0,4558,563,1,0,0,0,4559,4564,3,566,283,0,
  	4560,4561,5,773,0,0,4561,4563,3,566,283,0,4562,4560,1,0,0,0,4563,4566,
  	1,0,0,0,4564,4562,1,0,0,0,4564,4565,1,0,0,0,4565,565,1,0,0,0,4566,4564,
  	1,0,0,0,4567,4571,3,568,284,0,4568,4571,3,570,285,0,4569,4571,3,572,286,
  	0,4570,4567,1,0,0,0,4570,4568,1,0,0,0,4570,4569,1,0,0,0,4571,567,1,0,
  	0,0,4572,4573,5,618,0,0,4573,4574,5,750,0,0,4574,4575,3,1378,689,0,4575,
  	569,1,0,0,0,4576,4577,5,406,0,0,4577,4578,5,750,0,0,4578,4579,3,1378,
  	689,0,4579,571,1,0,0,0,4580,4581,5,129,0,0,4581,4582,5,750,0,0,4582,4583,
  	3,1378,689,0,4583,573,1,0,0,0,4584,4585,7,72,0,0,4585,575,1,0,0,0,4586,
  	4587,5,417,0,0,4587,4588,3,1338,669,0,4588,4591,5,203,0,0,4589,4592,3,
  	1376,688,0,4590,4592,3,924,462,0,4591,4589,1,0,0,0,4591,4590,1,0,0,0,
  	4592,4598,1,0,0,0,4593,4598,3,578,289,0,4594,4595,7,73,0,0,4595,4596,
  	5,417,0,0,4596,4598,3,1338,669,0,4597,4586,1,0,0,0,4597,4593,1,0,0,0,
  	4597,4594,1,0,0,0,4598,577,1,0,0,0,4599,4600,5,173,0,0,4600,4603,3,1338,
  	669,0,4601,4602,5,621,0,0,4602,4604,3,580,290,0,4603,4601,1,0,0,0,4603,
  	4604,1,0,0,0,4604,579,1,0,0,0,4605,4610,3,924,462,0,4606,4607,5,773,0,
  	0,4607,4609,3,924,462,0,4608,4606,1,0,0,0,4609,4612,1,0,0,0,4610,4608,
  	1,0,0,0,4610,4611,1,0,0,0,4611,581,1,0,0,0,4612,4610,1,0,0,0,4613,4638,
  	5,677,0,0,4614,4615,5,284,0,0,4615,4616,5,112,0,0,4616,4618,5,139,0,0,
  	4617,4619,3,1408,704,0,4618,4617,1,0,0,0,4618,4619,1,0,0,0,4619,4620,
  	1,0,0,0,4620,4639,3,1370,685,0,4621,4624,5,676,0,0,4622,4623,5,200,0,
  	0,4623,4625,5,459,0,0,4624,4622,1,0,0,0,4624,4625,1,0,0,0,4625,4639,1,
  	0,0,0,4626,4627,4,291,82,0,4627,4628,5,244,0,0,4628,4629,5,203,0,0,4629,
  	4630,3,1238,619,0,4630,4631,5,775,0,0,4631,4632,3,1350,675,0,4632,4633,
  	5,230,0,0,4633,4634,5,45,0,0,4634,4636,3,1370,685,0,4635,4637,3,584,292,
  	0,4636,4635,1,0,0,0,4636,4637,1,0,0,0,4637,4639,1,0,0,0,4638,4614,1,0,
  	0,0,4638,4621,1,0,0,0,4638,4626,1,0,0,0,4639,583,1,0,0,0,4640,4651,3,
  	586,293,0,4641,4642,5,112,0,0,4642,4644,5,139,0,0,4643,4645,3,1408,704,
  	0,4644,4643,1,0,0,0,4644,4645,1,0,0,0,4645,4646,1,0,0,0,4646,4648,3,1370,
  	685,0,4647,4649,3,586,293,0,4648,4647,1,0,0,0,4648,4649,1,0,0,0,4649,
  	4651,1,0,0,0,4650,4640,1,0,0,0,4650,4641,1,0,0,0,4651,585,1,0,0,0,4652,
  	4654,5,467,0,0,4653,4655,5,373,0,0,4654,4653,1,0,0,0,4654,4655,1,0,0,
  	0,4655,4656,1,0,0,0,4656,4657,5,539,0,0,4657,587,1,0,0,0,4658,4667,3,
  	590,295,0,4659,4667,3,600,300,0,4660,4667,3,614,307,0,4661,4667,3,616,
  	308,0,4662,4667,3,630,315,0,4663,4667,3,632,316,0,4664,4665,4,294,83,
  	0,4665,4667,3,650,325,0,4666,4658,1,0,0,0,4666,4659,1,0,0,0,4666,4660,
  	1,0,0,0,4666,4661,1,0,0,0,4666,4662,1,0,0,0,4666,4663,1,0,0,0,4666,4664,
  	1,0,0,0,4667,589,1,0,0,0,4668,4669,5,11,0,0,4669,4672,5,618,0,0,4670,
  	4671,4,295,84,0,4671,4673,3,1172,586,0,4672,4670,1,0,0,0,4672,4673,1,
  	0,0,0,4673,4723,1,0,0,0,4674,4675,4,295,85,0,4675,4679,3,1204,602,0,4676,
  	4677,4,295,86,0,4677,4679,3,592,296,0,4678,4674,1,0,0,0,4678,4676,1,0,
  	0,0,4679,4680,1,0,0,0,4680,4681,3,602,301,0,4681,4724,1,0,0,0,4682,4683,
  	4,295,87,0,4683,4702,3,598,299,0,4684,4687,3,1214,607,0,4685,4687,3,1212,
  	606,0,4686,4684,1,0,0,0,4686,4685,1,0,0,0,4687,4690,1,0,0,0,4688,4689,
  	4,295,88,0,4689,4691,3,1234,617,0,4690,4688,1,0,0,0,4690,4691,1,0,0,0,
  	4691,4694,1,0,0,0,4692,4693,4,295,89,0,4693,4695,3,1226,613,0,4694,4692,
  	1,0,0,0,4694,4695,1,0,0,0,4695,4703,1,0,0,0,4696,4697,4,295,90,0,4697,
  	4703,3,1228,614,0,4698,4700,4,295,91,0,4699,4701,3,1230,615,0,4700,4699,
  	1,0,0,0,4700,4701,1,0,0,0,4701,4703,1,0,0,0,4702,4686,1,0,0,0,4702,4696,
  	1,0,0,0,4702,4698,1,0,0,0,4703,4724,1,0,0,0,4704,4705,4,295,92,0,4705,
  	4706,3,598,299,0,4706,4707,3,1212,606,0,4707,4724,1,0,0,0,4708,4709,4,
  	295,93,0,4709,4721,3,1238,619,0,4710,4711,5,128,0,0,4711,4715,5,659,0,
  	0,4712,4716,5,10,0,0,4713,4716,5,369,0,0,4714,4716,3,652,326,0,4715,4712,
  	1,0,0,0,4715,4713,1,0,0,0,4715,4714,1,0,0,0,4716,4722,1,0,0,0,4717,4719,
  	4,295,94,0,4718,4720,3,1230,615,0,4719,4718,1,0,0,0,4719,4720,1,0,0,0,
  	4720,4722,1,0,0,0,4721,4710,1,0,0,0,4721,4717,1,0,0,0,4722,4724,1,0,0,
  	0,4723,4678,1,0,0,0,4723,4682,1,0,0,0,4723,4704,1,0,0,0,4723,4708,1,0,
  	0,0,4724,591,1,0,0,0,4725,4730,3,594,297,0,4726,4727,5,773,0,0,4727,4729,
  	3,594,297,0,4728,4726,1,0,0,0,4729,4732,1,0,0,0,4730,4728,1,0,0,0,4730,
  	4731,1,0,0,0,4731,593,1,0,0,0,4732,4730,1,0,0,0,4733,4734,4,297,95,0,
  	4734,4812,3,596,298,0,4735,4736,4,297,96,0,4736,4809,3,1238,619,0,4737,
  	4746,3,1212,606,0,4738,4739,5,458,0,0,4739,4741,3,1370,685,0,4740,4742,
  	3,1226,613,0,4741,4740,1,0,0,0,4741,4742,1,0,0,0,4742,4747,1,0,0,0,4743,
  	4745,3,1226,613,0,4744,4743,1,0,0,0,4744,4745,1,0,0,0,4745,4747,1,0,0,
  	0,4746,4738,1,0,0,0,4746,4744,1,0,0,0,4747,4810,1,0,0,0,4748,4757,3,1214,
  	607,0,4749,4751,3,1226,613,0,4750,4749,1,0,0,0,4750,4751,1,0,0,0,4751,
  	4758,1,0,0,0,4752,4753,5,458,0,0,4753,4755,3,1370,685,0,4754,4756,3,1226,
  	613,0,4755,4754,1,0,0,0,4755,4756,1,0,0,0,4756,4758,1,0,0,0,4757,4750,
  	1,0,0,0,4757,4752,1,0,0,0,4758,4810,1,0,0,0,4759,4810,3,1216,608,0,4760,
  	4762,3,1218,609,0,4761,4763,3,1226,613,0,4762,4761,1,0,0,0,4762,4763,
  	1,0,0,0,4763,4810,1,0,0,0,4764,4773,3,1220,610,0,4765,4766,5,458,0,0,
  	4766,4768,3,1370,685,0,4767,4769,3,1226,613,0,4768,4767,1,0,0,0,4768,
  	4769,1,0,0,0,4769,4774,1,0,0,0,4770,4772,3,1226,613,0,4771,4770,1,0,0,
  	0,4771,4772,1,0,0,0,4772,4774,1,0,0,0,4773,4765,1,0,0,0,4773,4771,1,0,
  	0,0,4774,4810,1,0,0,0,4775,4777,3,1222,611,0,4776,4778,3,1226,613,0,4777,
  	4776,1,0,0,0,4777,4778,1,0,0,0,4778,4810,1,0,0,0,4779,4781,3,1228,614,
  	0,4780,4779,1,0,0,0,4780,4781,1,0,0,0,4781,4810,1,0,0,0,4782,4783,4,297,
  	97,0,4783,4784,5,4,0,0,4784,4785,3,1232,616,0,4785,4790,3,1210,605,0,
  	4786,4787,5,4,0,0,4787,4788,3,1232,616,0,4788,4789,3,1210,605,0,4789,
  	4791,1,0,0,0,4790,4786,1,0,0,0,4790,4791,1,0,0,0,4791,4810,1,0,0,0,4792,
  	4793,4,297,98,0,4793,4794,5,348,0,0,4794,4795,3,1232,616,0,4795,4800,
  	3,1210,605,0,4796,4797,5,348,0,0,4797,4798,3,1232,616,0,4798,4799,3,1210,
  	605,0,4799,4801,1,0,0,0,4800,4796,1,0,0,0,4800,4801,1,0,0,0,4801,4810,
  	1,0,0,0,4802,4803,4,297,99,0,4803,4804,5,148,0,0,4804,4807,3,1232,616,
  	0,4805,4806,5,148,0,0,4806,4808,3,1232,616,0,4807,4805,1,0,0,0,4807,4808,
  	1,0,0,0,4808,4810,1,0,0,0,4809,4737,1,0,0,0,4809,4748,1,0,0,0,4809,4759,
  	1,0,0,0,4809,4760,1,0,0,0,4809,4764,1,0,0,0,4809,4775,1,0,0,0,4809,4780,
  	1,0,0,0,4809,4782,1,0,0,0,4809,4792,1,0,0,0,4809,4802,1,0,0,0,4810,4812,
  	1,0,0,0,4811,4733,1,0,0,0,4811,4735,1,0,0,0,4812,595,1,0,0,0,4813,4814,
  	3,1238,619,0,4814,4815,5,230,0,0,4815,4834,5,45,0,0,4816,4819,3,1372,
  	686,0,4817,4818,4,298,100,0,4818,4820,3,1234,617,0,4819,4817,1,0,0,0,
  	4819,4820,1,0,0,0,4820,4823,1,0,0,0,4821,4822,4,298,101,0,4822,4824,3,
  	1226,613,0,4823,4821,1,0,0,0,4823,4824,1,0,0,0,4824,4835,1,0,0,0,4825,
  	4826,4,298,102,0,4826,4827,5,734,0,0,4827,4829,5,406,0,0,4828,4830,3,
  	1234,617,0,4829,4828,1,0,0,0,4829,4830,1,0,0,0,4830,4832,1,0,0,0,4831,
  	4833,3,1226,613,0,4832,4831,1,0,0,0,4832,4833,1,0,0,0,4833,4835,1,0,0,
  	0,4834,4816,1,0,0,0,4834,4825,1,0,0,0,4835,4871,1,0,0,0,4836,4837,3,1238,
  	619,0,4837,4838,5,230,0,0,4838,4839,5,645,0,0,4839,4863,3,1398,699,0,
  	4840,4841,5,45,0,0,4841,4844,3,1372,686,0,4842,4843,4,298,103,0,4843,
  	4845,3,1234,617,0,4844,4842,1,0,0,0,4844,4845,1,0,0,0,4845,4848,1,0,0,
  	0,4846,4847,4,298,104,0,4847,4849,3,1226,613,0,4848,4846,1,0,0,0,4848,
  	4849,1,0,0,0,4849,4864,1,0,0,0,4850,4851,5,17,0,0,4851,4854,3,1374,687,
  	0,4852,4853,4,298,105,0,4853,4855,3,1226,613,0,4854,4852,1,0,0,0,4854,
  	4855,1,0,0,0,4855,4864,1,0,0,0,4856,4857,4,298,106,0,4857,4858,5,45,0,
  	0,4858,4859,5,734,0,0,4859,4861,5,406,0,0,4860,4862,3,1226,613,0,4861,
  	4860,1,0,0,0,4861,4862,1,0,0,0,4862,4864,1,0,0,0,4863,4840,1,0,0,0,4863,
  	4850,1,0,0,0,4863,4856,1,0,0,0,4863,4864,1,0,0,0,4864,4871,1,0,0,0,4865,
  	4866,4,298,107,0,4866,4868,3,1238,619,0,4867,4869,3,1228,614,0,4868,4867,
  	1,0,0,0,4868,4869,1,0,0,0,4869,4871,1,0,0,0,4870,4813,1,0,0,0,4870,4836,
  	1,0,0,0,4870,4865,1,0,0,0,4871,597,1,0,0,0,4872,4873,5,618,0,0,4873,4874,
  	3,1406,703,0,4874,599,1,0,0,0,4875,4876,5,97,0,0,4876,4879,5,618,0,0,
  	4877,4878,4,300,108,0,4878,4880,3,1174,587,0,4879,4877,1,0,0,0,4879,4880,
  	1,0,0,0,4880,4881,1,0,0,0,4881,4882,3,1204,602,0,4882,4883,3,606,303,
  	0,4883,4884,3,602,301,0,4884,601,1,0,0,0,4885,4887,4,301,109,0,4886,4888,
  	3,608,304,0,4887,4886,1,0,0,0,4887,4888,1,0,0,0,4888,4890,1,0,0,0,4889,
  	4891,3,610,305,0,4890,4889,1,0,0,0,4890,4891,1,0,0,0,4891,4895,1,0,0,
  	0,4892,4894,3,612,306,0,4893,4892,1,0,0,0,4894,4897,1,0,0,0,4895,4893,
  	1,0,0,0,4895,4896,1,0,0,0,4896,4900,1,0,0,0,4897,4895,1,0,0,0,4898,4899,
  	4,301,110,0,4899,4901,3,604,302,0,4900,4898,1,0,0,0,4900,4901,1,0,0,0,
  	4901,4904,1,0,0,0,4902,4904,1,0,0,0,4903,4885,1,0,0,0,4903,4902,1,0,0,
  	0,4904,603,1,0,0,0,4905,4906,5,796,0,0,4906,4910,3,1370,685,0,4907,4908,
  	5,75,0,0,4908,4910,3,1370,685,0,4909,4905,1,0,0,0,4909,4907,1,0,0,0,4910,
  	605,1,0,0,0,4911,4915,4,303,111,0,4912,4913,5,128,0,0,4913,4914,5,659,
  	0,0,4914,4916,3,652,326,0,4915,4912,1,0,0,0,4915,4916,1,0,0,0,4916,4919,
  	1,0,0,0,4917,4919,1,0,0,0,4918,4911,1,0,0,0,4918,4917,1,0,0,0,4919,607,
  	1,0,0,0,4920,4923,5,467,0,0,4921,4924,3,644,322,0,4922,4924,7,74,0,0,
  	4923,4921,1,0,0,0,4923,4922,1,0,0,0,4924,609,1,0,0,0,4925,4934,5,645,
  	0,0,4926,4927,5,322,0,0,4927,4935,3,1350,675,0,4928,4929,5,327,0,0,4929,
  	4935,3,1350,675,0,4930,4931,5,321,0,0,4931,4935,3,1350,675,0,4932,4933,
  	5,328,0,0,4933,4935,3,1350,675,0,4934,4926,1,0,0,0,4934,4928,1,0,0,0,
  	4934,4930,1,0,0,0,4934,4932,1,0,0,0,4935,4936,1,0,0,0,4936,4934,1,0,0,
  	0,4936,4937,1,0,0,0,4937,611,1,0,0,0,4938,4939,5,2,0,0,4939,4981,7,75,
  	0,0,4940,4969,5,406,0,0,4941,4948,5,177,0,0,4942,4943,5,247,0,0,4943,
  	4944,3,1352,676,0,4944,4945,5,122,0,0,4945,4949,1,0,0,0,4946,4949,5,365,
  	0,0,4947,4949,5,128,0,0,4948,4942,1,0,0,0,4948,4946,1,0,0,0,4948,4947,
  	1,0,0,0,4948,4949,1,0,0,0,4949,4970,1,0,0,0,4950,4953,5,705,0,0,4951,
  	4954,3,1352,676,0,4952,4954,5,128,0,0,4953,4951,1,0,0,0,4953,4952,1,0,
  	0,0,4954,4970,1,0,0,0,4955,4956,5,706,0,0,4956,4961,5,247,0,0,4957,4958,
  	3,1352,676,0,4958,4959,5,122,0,0,4959,4962,1,0,0,0,4960,4962,5,128,0,
  	0,4961,4957,1,0,0,0,4961,4960,1,0,0,0,4962,4970,1,0,0,0,4963,4964,4,306,
  	112,0,4964,4965,5,467,0,0,4965,4967,5,101,0,0,4966,4968,7,76,0,0,4967,
  	4966,1,0,0,0,4967,4968,1,0,0,0,4968,4970,1,0,0,0,4969,4941,1,0,0,0,4969,
  	4950,1,0,0,0,4969,4955,1,0,0,0,4969,4963,1,0,0,0,4970,4981,1,0,0,0,4971,
  	4972,4,306,113,0,4972,4973,5,741,0,0,4973,4981,3,1352,676,0,4974,4975,
  	4,306,114,0,4975,4978,5,740,0,0,4976,4979,3,1352,676,0,4977,4979,5,698,
  	0,0,4978,4976,1,0,0,0,4978,4977,1,0,0,0,4979,4981,1,0,0,0,4980,4938,1,
  	0,0,0,4980,4940,1,0,0,0,4980,4971,1,0,0,0,4980,4974,1,0,0,0,4981,613,
  	1,0,0,0,4982,4983,5,148,0,0,4983,4986,5,618,0,0,4984,4985,4,307,115,0,
  	4985,4987,3,1172,586,0,4986,4984,1,0,0,0,4986,4987,1,0,0,0,4987,4988,
  	1,0,0,0,4988,4989,3,1202,601,0,4989,615,1,0,0,0,4990,5033,5,215,0,0,4991,
  	4992,4,308,116,0,4992,4993,3,638,319,0,4993,4994,5,590,0,0,4994,4998,
  	3,1202,601,0,4995,4996,5,645,0,0,4996,4997,5,660,0,0,4997,4999,5,391,
  	0,0,4998,4995,1,0,0,0,4998,4999,1,0,0,0,4999,5034,1,0,0,0,5000,5006,3,
  	638,319,0,5001,5003,5,10,0,0,5002,5004,5,421,0,0,5003,5002,1,0,0,0,5003,
  	5004,1,0,0,0,5004,5006,1,0,0,0,5005,5000,1,0,0,0,5005,5001,1,0,0,0,5006,
  	5007,1,0,0,0,5007,5009,5,383,0,0,5008,5010,3,636,318,0,5009,5008,1,0,
  	0,0,5009,5010,1,0,0,0,5010,5011,1,0,0,0,5011,5012,3,642,321,0,5012,5013,
  	5,590,0,0,5013,5015,3,618,309,0,5014,5016,3,628,314,0,5015,5014,1,0,0,
  	0,5015,5016,1,0,0,0,5016,5018,1,0,0,0,5017,5019,3,620,310,0,5018,5017,
  	1,0,0,0,5018,5019,1,0,0,0,5019,5021,1,0,0,0,5020,5022,3,626,313,0,5021,
  	5020,1,0,0,0,5021,5022,1,0,0,0,5022,5034,1,0,0,0,5023,5024,5,427,0,0,
  	5024,5025,5,383,0,0,5025,5026,3,1238,619,0,5026,5027,5,590,0,0,5027,5031,
  	3,618,309,0,5028,5029,5,645,0,0,5029,5030,5,215,0,0,5030,5032,5,391,0,
  	0,5031,5028,1,0,0,0,5031,5032,1,0,0,0,5032,5034,1,0,0,0,5033,4991,1,0,
  	0,0,5033,5005,1,0,0,0,5033,5023,1,0,0,0,5034,617,1,0,0,0,5035,5036,4,
  	309,117,0,5036,5040,3,1204,602,0,5037,5038,4,309,118,0,5038,5040,3,1202,
  	601,0,5039,5035,1,0,0,0,5039,5037,1,0,0,0,5040,619,1,0,0,0,5041,5042,
  	4,310,119,0,5042,5044,5,645,0,0,5043,5045,3,648,324,0,5044,5043,1,0,0,
  	0,5045,5046,1,0,0,0,5046,5044,1,0,0,0,5046,5047,1,0,0,0,5047,5053,1,0,
  	0,0,5048,5049,4,310,120,0,5049,5050,5,645,0,0,5050,5051,5,215,0,0,5051,
  	5053,5,391,0,0,5052,5041,1,0,0,0,5052,5048,1,0,0,0,5053,621,1,0,0,0,5054,
  	5055,5,663,0,0,5055,5056,3,652,326,0,5056,623,1,0,0,0,5057,5058,5,645,
  	0,0,5058,5066,5,659,0,0,5059,5067,3,652,326,0,5060,5062,5,10,0,0,5061,
  	5063,3,622,311,0,5062,5061,1,0,0,0,5062,5063,1,0,0,0,5063,5067,1,0,0,
  	0,5064,5067,5,369,0,0,5065,5067,5,128,0,0,5066,5059,1,0,0,0,5066,5060,
  	1,0,0,0,5066,5064,1,0,0,0,5066,5065,1,0,0,0,5067,625,1,0,0,0,5068,5069,
  	5,17,0,0,5069,5071,5,618,0,0,5070,5072,3,624,312,0,5071,5070,1,0,0,0,
  	5071,5072,1,0,0,0,5072,627,1,0,0,0,5073,5074,4,314,121,0,5074,5075,3,
  	608,304,0,5075,629,1,0,0,0,5076,5077,5,453,0,0,5077,5078,5,618,0,0,5078,
  	5079,3,1238,619,0,5079,5080,5,590,0,0,5080,5088,3,1238,619,0,5081,5082,
  	5,773,0,0,5082,5083,3,1238,619,0,5083,5084,5,590,0,0,5084,5085,3,1238,
  	619,0,5085,5087,1,0,0,0,5086,5081,1,0,0,0,5087,5090,1,0,0,0,5088,5086,
  	1,0,0,0,5088,5089,1,0,0,0,5089,631,1,0,0,0,5090,5088,1,0,0,0,5091,5125,
  	5,477,0,0,5092,5093,4,316,122,0,5093,5094,3,638,319,0,5094,5095,5,203,
  	0,0,5095,5096,3,1202,601,0,5096,5126,1,0,0,0,5097,5098,3,638,319,0,5098,
  	5099,3,634,317,0,5099,5100,5,203,0,0,5100,5101,3,1202,601,0,5101,5126,
  	1,0,0,0,5102,5104,5,10,0,0,5103,5105,5,421,0,0,5104,5103,1,0,0,0,5104,
  	5105,1,0,0,0,5105,5117,1,0,0,0,5106,5107,4,316,123,0,5107,5109,5,383,
  	0,0,5108,5110,3,636,318,0,5109,5108,1,0,0,0,5109,5110,1,0,0,0,5110,5111,
  	1,0,0,0,5111,5118,3,642,321,0,5112,5113,5,773,0,0,5113,5114,5,215,0,0,
  	5114,5115,5,391,0,0,5115,5116,5,203,0,0,5116,5118,3,1202,601,0,5117,5106,
  	1,0,0,0,5117,5112,1,0,0,0,5118,5126,1,0,0,0,5119,5120,5,427,0,0,5120,
  	5121,5,383,0,0,5121,5122,3,1238,619,0,5122,5123,5,203,0,0,5123,5124,3,
  	1202,601,0,5124,5126,1,0,0,0,5125,5092,1,0,0,0,5125,5097,1,0,0,0,5125,
  	5102,1,0,0,0,5125,5119,1,0,0,0,5126,633,1,0,0,0,5127,5128,4,317,124,0,
  	5128,5130,5,383,0,0,5129,5131,3,636,318,0,5130,5129,1,0,0,0,5130,5131,
  	1,0,0,0,5131,5132,1,0,0,0,5132,5142,3,642,321,0,5133,5139,4,317,125,0,
  	5134,5136,5,383,0,0,5135,5137,3,636,318,0,5136,5135,1,0,0,0,5136,5137,
  	1,0,0,0,5137,5138,1,0,0,0,5138,5140,3,642,321,0,5139,5134,1,0,0,0,5139,
  	5140,1,0,0,0,5140,5142,1,0,0,0,5141,5127,1,0,0,0,5141,5133,1,0,0,0,5142,
  	635,1,0,0,0,5143,5144,7,77,0,0,5144,637,1,0,0,0,5145,5150,3,640,320,0,
  	5146,5147,5,773,0,0,5147,5149,3,640,320,0,5148,5146,1,0,0,0,5149,5152,
  	1,0,0,0,5150,5148,1,0,0,0,5150,5151,1,0,0,0,5151,639,1,0,0,0,5152,5150,
  	1,0,0,0,5153,5164,4,320,126,0,5154,5156,3,1402,701,0,5155,5157,3,1256,
  	628,0,5156,5155,1,0,0,0,5156,5157,1,0,0,0,5157,5165,1,0,0,0,5158,5159,
  	3,1402,701,0,5159,5162,5,783,0,0,5160,5163,3,1398,699,0,5161,5163,5,858,
  	0,0,5162,5160,1,0,0,0,5162,5161,1,0,0,0,5163,5165,1,0,0,0,5164,5154,1,
  	0,0,0,5164,5158,1,0,0,0,5165,5198,1,0,0,0,5166,5168,7,78,0,0,5167,5169,
  	3,1256,628,0,5168,5167,1,0,0,0,5168,5169,1,0,0,0,5169,5198,1,0,0,0,5170,
  	5198,7,79,0,0,5171,5172,5,215,0,0,5172,5198,5,391,0,0,5173,5174,5,509,
  	0,0,5174,5198,5,110,0,0,5175,5179,5,97,0,0,5176,5177,5,577,0,0,5177,5180,
  	5,571,0,0,5178,5180,7,80,0,0,5179,5176,1,0,0,0,5179,5178,1,0,0,0,5179,
  	5180,1,0,0,0,5180,5198,1,0,0,0,5181,5182,5,287,0,0,5182,5198,5,571,0,
  	0,5183,5186,5,459,0,0,5184,5187,5,65,0,0,5185,5187,3,574,287,0,5186,5184,
  	1,0,0,0,5186,5185,1,0,0,0,5187,5198,1,0,0,0,5188,5189,5,509,0,0,5189,
  	5198,5,636,0,0,5190,5192,5,11,0,0,5191,5193,5,483,0,0,5192,5191,1,0,0,
  	0,5192,5193,1,0,0,0,5193,5198,1,0,0,0,5194,5195,4,320,127,0,5195,5196,
  	7,81,0,0,5196,5198,5,659,0,0,5197,5153,1,0,0,0,5197,5166,1,0,0,0,5197,
  	5170,1,0,0,0,5197,5171,1,0,0,0,5197,5173,1,0,0,0,5197,5175,1,0,0,0,5197,
  	5181,1,0,0,0,5197,5183,1,0,0,0,5197,5188,1,0,0,0,5197,5190,1,0,0,0,5197,
  	5194,1,0,0,0,5198,641,1,0,0,0,5199,5202,5,760,0,0,5200,5201,5,772,0,0,
  	5201,5203,5,760,0,0,5202,5200,1,0,0,0,5202,5203,1,0,0,0,5203,5216,1,0,
  	0,0,5204,5207,3,1270,635,0,5205,5206,5,772,0,0,5206,5208,5,760,0,0,5207,
  	5205,1,0,0,0,5207,5208,1,0,0,0,5208,5216,1,0,0,0,5209,5216,3,1314,657,
  	0,5210,5211,4,321,128,0,5211,5212,3,1270,635,0,5212,5213,5,772,0,0,5213,
  	5214,3,1314,657,0,5214,5216,1,0,0,0,5215,5199,1,0,0,0,5215,5204,1,0,0,
  	0,5215,5209,1,0,0,0,5215,5210,1,0,0,0,5216,643,1,0,0,0,5217,5224,3,646,
  	323,0,5218,5220,5,15,0,0,5219,5218,1,0,0,0,5219,5220,1,0,0,0,5220,5221,
  	1,0,0,0,5221,5223,3,646,323,0,5222,5219,1,0,0,0,5223,5226,1,0,0,0,5224,
  	5222,1,0,0,0,5224,5225,1,0,0,0,5225,645,1,0,0,0,5226,5224,1,0,0,0,5227,
  	5228,5,63,0,0,5228,5234,3,1372,686,0,5229,5230,5,259,0,0,5230,5234,3,
  	1372,686,0,5231,5232,5,559,0,0,5232,5234,3,1372,686,0,5233,5227,1,0,0,
  	0,5233,5229,1,0,0,0,5233,5231,1,0,0,0,5234,647,1,0,0,0,5235,5236,5,215,
  	0,0,5236,5246,5,391,0,0,5237,5238,5,322,0,0,5238,5246,3,1350,675,0,5239,
  	5240,5,327,0,0,5240,5246,3,1350,675,0,5241,5242,5,321,0,0,5242,5246,3,
  	1350,675,0,5243,5244,5,328,0,0,5244,5246,3,1350,675,0,5245,5235,1,0,0,
  	0,5245,5237,1,0,0,0,5245,5239,1,0,0,0,5245,5241,1,0,0,0,5245,5243,1,0,
  	0,0,5246,649,1,0,0,0,5247,5248,5,506,0,0,5248,5249,5,659,0,0,5249,5271,
  	3,652,326,0,5250,5251,5,506,0,0,5251,5252,5,659,0,0,5252,5271,7,82,0,
  	0,5253,5254,5,506,0,0,5254,5255,5,128,0,0,5255,5259,5,659,0,0,5256,5260,
  	3,652,326,0,5257,5260,5,369,0,0,5258,5260,5,10,0,0,5259,5256,1,0,0,0,
  	5259,5257,1,0,0,0,5259,5258,1,0,0,0,5260,5261,1,0,0,0,5261,5262,5,590,
  	0,0,5262,5271,3,652,326,0,5263,5264,5,506,0,0,5264,5265,5,659,0,0,5265,
  	5268,5,10,0,0,5266,5267,5,663,0,0,5267,5269,3,652,326,0,5268,5266,1,0,
  	0,0,5268,5269,1,0,0,0,5269,5271,1,0,0,0,5270,5247,1,0,0,0,5270,5250,1,
  	0,0,0,5270,5253,1,0,0,0,5270,5263,1,0,0,0,5271,651,1,0,0,0,5272,5277,
  	3,654,327,0,5273,5274,5,773,0,0,5274,5276,3,654,327,0,5275,5273,1,0,0,
  	0,5276,5279,1,0,0,0,5277,5275,1,0,0,0,5277,5278,1,0,0,0,5278,653,1,0,
  	0,0,5279,5277,1,0,0,0,5280,5286,3,1402,701,0,5281,5284,5,783,0,0,5282,
  	5285,3,1398,699,0,5283,5285,5,858,0,0,5284,5282,1,0,0,0,5284,5283,1,0,
  	0,0,5285,5287,1,0,0,0,5286,5281,1,0,0,0,5286,5287,1,0,0,0,5287,655,1,
  	0,0,0,5288,5290,5,14,0,0,5289,5291,3,1246,623,0,5290,5289,1,0,0,0,5290,
  	5291,1,0,0,0,5291,5292,1,0,0,0,5292,5293,5,574,0,0,5293,5296,3,1316,658,
  	0,5294,5295,4,328,129,0,5295,5297,3,658,329,0,5296,5294,1,0,0,0,5296,
  	5297,1,0,0,0,5297,5332,1,0,0,0,5298,5299,5,62,0,0,5299,5300,5,574,0,0,
  	5300,5304,3,1316,658,0,5301,5303,3,660,330,0,5302,5301,1,0,0,0,5303,5306,
  	1,0,0,0,5304,5302,1,0,0,0,5304,5305,1,0,0,0,5305,5332,1,0,0,0,5306,5304,
  	1,0,0,0,5307,5308,5,61,0,0,5308,5309,5,574,0,0,5309,5311,3,1316,658,0,
  	5310,5312,7,83,0,0,5311,5310,1,0,0,0,5311,5312,1,0,0,0,5312,5332,1,0,
  	0,0,5313,5315,5,388,0,0,5314,5316,3,1246,623,0,5315,5314,1,0,0,0,5315,
  	5316,1,0,0,0,5316,5317,1,0,0,0,5317,5318,5,574,0,0,5318,5332,3,1316,658,
  	0,5319,5321,5,455,0,0,5320,5322,3,1246,623,0,5321,5320,1,0,0,0,5321,5322,
  	1,0,0,0,5322,5323,1,0,0,0,5323,5324,5,574,0,0,5324,5328,3,1316,658,0,
  	5325,5327,3,662,331,0,5326,5325,1,0,0,0,5327,5330,1,0,0,0,5328,5326,1,
  	0,0,0,5328,5329,1,0,0,0,5329,5332,1,0,0,0,5330,5328,1,0,0,0,5331,5288,
  	1,0,0,0,5331,5298,1,0,0,0,5331,5307,1,0,0,0,5331,5313,1,0,0,0,5331,5319,
  	1,0,0,0,5332,657,1,0,0,0,5333,5334,5,614,0,0,5334,5335,5,674,0,0,5335,
  	5336,5,383,0,0,5336,5340,3,1340,670,0,5337,5338,5,645,0,0,5338,5339,5,
  	747,0,0,5339,5341,5,675,0,0,5340,5337,1,0,0,0,5340,5341,1,0,0,0,5341,
  	5347,1,0,0,0,5342,5343,5,148,0,0,5343,5344,5,674,0,0,5344,5345,5,383,
  	0,0,5345,5347,3,1340,670,0,5346,5333,1,0,0,0,5346,5342,1,0,0,0,5347,659,
  	1,0,0,0,5348,5349,5,200,0,0,5349,5352,5,615,0,0,5350,5352,7,84,0,0,5351,
  	5348,1,0,0,0,5351,5350,1,0,0,0,5352,661,1,0,0,0,5353,5354,7,85,0,0,5354,
  	663,1,0,0,0,5355,5356,5,245,0,0,5356,5357,5,410,0,0,5357,5358,3,1338,
  	669,0,5358,5359,5,520,0,0,5359,5360,3,1370,685,0,5360,5378,1,0,0,0,5361,
  	5362,5,245,0,0,5362,5363,5,664,0,0,5363,5378,3,1380,690,0,5364,5365,5,
  	607,0,0,5365,5366,5,410,0,0,5366,5378,3,1328,664,0,5367,5368,5,607,0,
  	0,5368,5369,5,664,0,0,5369,5374,3,1330,665,0,5370,5371,5,773,0,0,5371,
  	5373,3,1330,665,0,5372,5370,1,0,0,0,5373,5376,1,0,0,0,5374,5372,1,0,0,
  	0,5374,5375,1,0,0,0,5375,5378,1,0,0,0,5376,5374,1,0,0,0,5377,5355,1,0,
  	0,0,5377,5361,1,0,0,0,5377,5364,1,0,0,0,5377,5367,1,0,0,0,5378,665,1,
  	0,0,0,5379,5380,5,506,0,0,5380,5381,3,668,334,0,5381,667,1,0,0,0,5382,
  	5383,3,678,339,0,5383,5384,3,676,338,0,5384,5439,1,0,0,0,5385,5386,5,
  	592,0,0,5386,5439,3,670,335,0,5387,5388,3,1410,705,0,5388,5389,3,682,
  	341,0,5389,5439,1,0,0,0,5390,5393,5,406,0,0,5391,5392,5,200,0,0,5392,
  	5394,3,1238,619,0,5393,5391,1,0,0,0,5393,5394,1,0,0,0,5394,5395,1,0,0,
  	0,5395,5422,3,1408,704,0,5396,5398,3,1372,686,0,5397,5399,3,1234,617,
  	0,5398,5397,1,0,0,0,5398,5399,1,0,0,0,5399,5401,1,0,0,0,5400,5402,3,1226,
  	613,0,5401,5400,1,0,0,0,5401,5402,1,0,0,0,5402,5423,1,0,0,0,5403,5405,
  	3,1372,686,0,5404,5406,3,1234,617,0,5405,5404,1,0,0,0,5405,5406,1,0,0,
  	0,5406,5408,1,0,0,0,5407,5409,3,1226,613,0,5408,5407,1,0,0,0,5408,5409,
  	1,0,0,0,5409,5423,1,0,0,0,5410,5411,4,334,130,0,5411,5412,5,382,0,0,5412,
  	5413,5,776,0,0,5413,5414,3,1372,686,0,5414,5415,5,777,0,0,5415,5423,1,
  	0,0,0,5416,5417,4,334,131,0,5417,5418,5,406,0,0,5418,5419,5,776,0,0,5419,
  	5420,3,1372,686,0,5420,5421,5,777,0,0,5421,5423,1,0,0,0,5422,5396,1,0,
  	0,0,5422,5403,1,0,0,0,5422,5410,1,0,0,0,5422,5416,1,0,0,0,5423,5439,1,
  	0,0,0,5424,5425,4,334,132,0,5425,5428,5,406,0,0,5426,5427,5,200,0,0,5427,
  	5429,3,1238,619,0,5428,5426,1,0,0,0,5428,5429,1,0,0,0,5429,5430,1,0,0,
  	0,5430,5431,5,590,0,0,5431,5433,5,734,0,0,5432,5434,3,1234,617,0,5433,
  	5432,1,0,0,0,5433,5434,1,0,0,0,5434,5436,1,0,0,0,5435,5437,3,1226,613,
  	0,5436,5435,1,0,0,0,5436,5437,1,0,0,0,5437,5439,1,0,0,0,5438,5382,1,0,
  	0,0,5438,5385,1,0,0,0,5438,5387,1,0,0,0,5438,5390,1,0,0,0,5438,5424,1,
  	0,0,0,5439,669,1,0,0,0,5440,5442,3,672,336,0,5441,5443,3,674,337,0,5442,
  	5441,1,0,0,0,5442,5443,1,0,0,0,5443,5450,1,0,0,0,5444,5447,3,674,337,
  	0,5445,5446,5,773,0,0,5446,5448,3,672,336,0,5447,5445,1,0,0,0,5447,5448,
  	1,0,0,0,5448,5450,1,0,0,0,5449,5440,1,0,0,0,5449,5444,1,0,0,0,5450,671,
  	1,0,0,0,5451,5452,5,435,0,0,5452,5453,7,38,0,0,5453,673,1,0,0,0,5454,
  	5455,5,258,0,0,5455,5461,5,274,0,0,5456,5457,5,456,0,0,5457,5462,5,435,
  	0,0,5458,5459,5,435,0,0,5459,5462,7,86,0,0,5460,5462,5,500,0,0,5461,5456,
  	1,0,0,0,5461,5458,1,0,0,0,5461,5460,1,0,0,0,5462,675,1,0,0,0,5463,5464,
  	5,773,0,0,5464,5466,3,680,340,0,5465,5463,1,0,0,0,5466,5469,1,0,0,0,5467,
  	5465,1,0,0,0,5467,5468,1,0,0,0,5468,677,1,0,0,0,5469,5467,1,0,0,0,5470,
  	5471,3,932,466,0,5471,5472,3,1408,704,0,5472,5473,3,686,343,0,5473,5501,
  	1,0,0,0,5474,5501,3,1192,596,0,5475,5476,3,924,462,0,5476,5477,3,1408,
  	704,0,5477,5478,3,854,427,0,5478,5501,1,0,0,0,5479,5480,5,783,0,0,5480,
  	5482,5,783,0,0,5481,5483,3,1414,707,0,5482,5481,1,0,0,0,5482,5483,1,0,
  	0,0,5483,5484,1,0,0,0,5484,5485,3,932,466,0,5485,5486,3,1408,704,0,5486,
  	5487,3,686,343,0,5487,5501,1,0,0,0,5488,5498,5,356,0,0,5489,5490,3,1408,
  	704,0,5490,5491,3,854,427,0,5491,5499,1,0,0,0,5492,5494,3,1130,565,0,
  	5493,5495,3,1180,590,0,5494,5493,1,0,0,0,5494,5495,1,0,0,0,5495,5499,
  	1,0,0,0,5496,5497,4,339,133,0,5497,5499,5,128,0,0,5498,5489,1,0,0,0,5498,
  	5492,1,0,0,0,5498,5496,1,0,0,0,5499,5501,1,0,0,0,5500,5470,1,0,0,0,5500,
  	5474,1,0,0,0,5500,5475,1,0,0,0,5500,5479,1,0,0,0,5500,5488,1,0,0,0,5501,
  	679,1,0,0,0,5502,5503,3,1410,705,0,5503,5504,3,932,466,0,5504,5505,3,
  	1408,704,0,5505,5506,3,686,343,0,5506,5509,1,0,0,0,5507,5509,3,678,339,
  	0,5508,5502,1,0,0,0,5508,5507,1,0,0,0,5509,681,1,0,0,0,5510,5511,3,684,
  	342,0,5511,5512,3,676,338,0,5512,5516,1,0,0,0,5513,5514,5,592,0,0,5514,
  	5516,3,670,335,0,5515,5510,1,0,0,0,5515,5513,1,0,0,0,5516,683,1,0,0,0,
  	5517,5518,3,932,466,0,5518,5519,3,1408,704,0,5519,5520,3,686,343,0,5520,
  	685,1,0,0,0,5521,5531,3,854,427,0,5522,5531,5,128,0,0,5523,5531,5,383,
  	0,0,5524,5531,5,10,0,0,5525,5531,5,32,0,0,5526,5527,4,343,134,0,5527,
  	5531,5,487,0,0,5528,5529,4,343,135,0,5529,5531,5,710,0,0,5530,5521,1,
  	0,0,0,5530,5522,1,0,0,0,5530,5523,1,0,0,0,5530,5524,1,0,0,0,5530,5525,
  	1,0,0,0,5530,5526,1,0,0,0,5530,5528,1,0,0,0,5531,687,1,0,0,0,5532,5533,
  	5,509,0,0,5533,5535,5,110,0,0,5534,5536,3,1242,621,0,5535,5534,1,0,0,
  	0,5535,5536,1,0,0,0,5536,689,1,0,0,0,5537,5539,5,509,0,0,5538,5540,3,
  	776,388,0,5539,5538,1,0,0,0,5539,5540,1,0,0,0,5540,5541,1,0,0,0,5541,
  	5543,5,571,0,0,5542,5544,3,782,391,0,5543,5542,1,0,0,0,5543,5544,1,0,
  	0,0,5544,5546,1,0,0,0,5545,5547,3,1242,621,0,5546,5545,1,0,0,0,5546,5547,
  	1,0,0,0,5547,691,1,0,0,0,5548,5550,5,509,0,0,5549,5551,5,204,0,0,5550,
  	5549,1,0,0,0,5550,5551,1,0,0,0,5551,5552,1,0,0,0,5552,5554,5,593,0,0,
  	5553,5555,3,782,391,0,5554,5553,1,0,0,0,5554,5555,1,0,0,0,5555,5557,1,
  	0,0,0,5556,5558,3,1242,621,0,5557,5556,1,0,0,0,5557,5558,1,0,0,0,5558,
  	693,1,0,0,0,5559,5560,5,509,0,0,5560,5562,5,169,0,0,5561,5563,3,782,391,
  	0,5562,5561,1,0,0,0,5562,5563,1,0,0,0,5563,5565,1,0,0,0,5564,5566,3,1242,
  	621,0,5565,5564,1,0,0,0,5565,5566,1,0,0,0,5566,695,1,0,0,0,5567,5568,
  	5,509,0,0,5568,5569,5,574,0,0,5569,5571,5,547,0,0,5570,5572,3,782,391,
  	0,5571,5570,1,0,0,0,5571,5572,1,0,0,0,5572,5574,1,0,0,0,5573,5575,3,1242,
  	621,0,5574,5573,1,0,0,0,5574,5575,1,0,0,0,5575,697,1,0,0,0,5576,5577,
  	5,509,0,0,5577,5578,5,387,0,0,5578,5580,5,571,0,0,5579,5581,3,782,391,
  	0,5580,5579,1,0,0,0,5580,5581,1,0,0,0,5581,5583,1,0,0,0,5582,5584,3,1242,
  	621,0,5583,5582,1,0,0,0,5583,5584,1,0,0,0,5584,699,1,0,0,0,5585,5586,
  	5,509,0,0,5586,5587,5,408,0,0,5587,701,1,0,0,0,5588,5589,5,509,0,0,5589,
  	5590,5,163,0,0,5590,5591,3,778,389,0,5591,5592,5,289,0,0,5592,703,1,0,
  	0,0,5593,5594,5,509,0,0,5594,5595,5,163,0,0,5595,5596,3,778,389,0,5596,
  	5597,5,354,0,0,5597,705,1,0,0,0,5598,5599,5,509,0,0,5599,5600,5,163,0,
  	0,5600,5601,3,778,389,0,5601,5602,5,547,0,0,5602,707,1,0,0,0,5603,5605,
  	5,509,0,0,5604,5606,3,776,388,0,5605,5604,1,0,0,0,5605,5606,1,0,0,0,5606,
  	5607,1,0,0,0,5607,5608,5,71,0,0,5608,5609,7,87,0,0,5609,5611,3,1314,657,
  	0,5610,5612,3,782,391,0,5611,5610,1,0,0,0,5611,5612,1,0,0,0,5612,5614,
  	1,0,0,0,5613,5615,3,1242,621,0,5614,5613,1,0,0,0,5614,5615,1,0,0,0,5615,
  	709,1,0,0,0,5616,5617,5,509,0,0,5617,5618,7,41,0,0,5618,5619,5,289,0,
  	0,5619,711,1,0,0,0,5620,5624,5,509,0,0,5621,5622,5,514,0,0,5622,5625,
  	5,225,0,0,5623,5625,5,803,0,0,5624,5621,1,0,0,0,5624,5623,1,0,0,0,5625,
  	713,1,0,0,0,5626,5627,5,509,0,0,5627,5628,5,33,0,0,5628,5631,5,169,0,
  	0,5629,5630,5,251,0,0,5630,5632,3,1372,686,0,5631,5629,1,0,0,0,5631,5632,
  	1,0,0,0,5632,5635,1,0,0,0,5633,5634,5,203,0,0,5634,5636,3,1354,677,0,
  	5635,5633,1,0,0,0,5635,5636,1,0,0,0,5636,5638,1,0,0,0,5637,5639,3,290,
  	145,0,5638,5637,1,0,0,0,5638,5639,1,0,0,0,5639,5641,1,0,0,0,5640,5642,
  	3,970,485,0,5641,5640,1,0,0,0,5641,5642,1,0,0,0,5642,715,1,0,0,0,5643,
  	5644,5,509,0,0,5644,5645,5,446,0,0,5645,5648,5,169,0,0,5646,5647,5,251,
  	0,0,5647,5649,3,1372,686,0,5648,5646,1,0,0,0,5648,5649,1,0,0,0,5649,5652,
  	1,0,0,0,5650,5651,5,203,0,0,5651,5653,3,1354,677,0,5652,5650,1,0,0,0,
  	5652,5653,1,0,0,0,5653,5655,1,0,0,0,5654,5656,3,290,145,0,5655,5654,1,
  	0,0,0,5655,5656,1,0,0,0,5656,5658,1,0,0,0,5657,5659,3,970,485,0,5658,
  	5657,1,0,0,0,5658,5659,1,0,0,0,5659,717,1,0,0,0,5660,5663,5,509,0,0,5661,
  	5662,4,359,136,0,5662,5664,5,180,0,0,5663,5661,1,0,0,0,5663,5664,1,0,
  	0,0,5664,5665,1,0,0,0,5665,5666,7,88,0,0,5666,5667,3,780,390,0,5667,5669,
  	3,1314,657,0,5668,5670,3,782,391,0,5669,5668,1,0,0,0,5669,5670,1,0,0,
  	0,5670,5672,1,0,0,0,5671,5673,3,364,182,0,5672,5671,1,0,0,0,5672,5673,
  	1,0,0,0,5673,719,1,0,0,0,5674,5676,5,509,0,0,5675,5677,5,553,0,0,5676,
  	5675,1,0,0,0,5676,5677,1,0,0,0,5677,5678,1,0,0,0,5678,5679,5,162,0,0,
  	5679,721,1,0,0,0,5680,5681,5,509,0,0,5681,5682,5,95,0,0,5682,5683,5,776,
  	0,0,5683,5684,5,760,0,0,5684,5685,5,777,0,0,5685,5686,5,639,0,0,5686,
  	723,1,0,0,0,5687,5688,5,509,0,0,5688,5689,5,95,0,0,5689,5690,5,776,0,
  	0,5690,5691,5,760,0,0,5691,5692,5,777,0,0,5692,5693,5,166,0,0,5693,725,
  	1,0,0,0,5694,5695,5,509,0,0,5695,5697,5,639,0,0,5696,5698,3,290,145,0,
  	5697,5696,1,0,0,0,5697,5698,1,0,0,0,5698,727,1,0,0,0,5699,5700,5,509,
  	0,0,5700,5702,5,166,0,0,5701,5703,3,290,145,0,5702,5701,1,0,0,0,5702,
  	5703,1,0,0,0,5703,729,1,0,0,0,5704,5705,5,509,0,0,5705,5706,5,426,0,0,
  	5706,731,1,0,0,0,5707,5708,5,509,0,0,5708,5710,5,425,0,0,5709,5711,3,
  	784,392,0,5710,5709,1,0,0,0,5710,5711,1,0,0,0,5711,5715,1,0,0,0,5712,
  	5713,5,200,0,0,5713,5714,5,430,0,0,5714,5716,5,747,0,0,5715,5712,1,0,
  	0,0,5715,5716,1,0,0,0,5716,5718,1,0,0,0,5717,5719,3,290,145,0,5718,5717,
  	1,0,0,0,5718,5719,1,0,0,0,5719,733,1,0,0,0,5720,5722,5,509,0,0,5721,5723,
  	3,1410,705,0,5722,5721,1,0,0,0,5722,5723,1,0,0,0,5723,5724,1,0,0,0,5724,
  	5726,5,547,0,0,5725,5727,3,1242,621,0,5726,5725,1,0,0,0,5726,5727,1,0,
  	0,0,5727,735,1,0,0,0,5728,5730,5,509,0,0,5729,5731,5,204,0,0,5730,5729,
  	1,0,0,0,5730,5731,1,0,0,0,5731,5732,1,0,0,0,5732,5733,5,424,0,0,5733,
  	737,1,0,0,0,5734,5736,5,509,0,0,5735,5737,3,1410,705,0,5736,5735,1,0,
  	0,0,5736,5737,1,0,0,0,5737,5738,1,0,0,0,5738,5740,5,631,0,0,5739,5741,
  	3,1242,621,0,5740,5739,1,0,0,0,5740,5741,1,0,0,0,5741,739,1,0,0,0,5742,
  	5743,5,509,0,0,5743,5745,3,946,473,0,5744,5746,3,1242,621,0,5745,5744,
  	1,0,0,0,5745,5746,1,0,0,0,5746,741,1,0,0,0,5747,5748,5,509,0,0,5748,5750,
  	5,70,0,0,5749,5751,3,1242,621,0,5750,5749,1,0,0,0,5750,5751,1,0,0,0,5751,
  	743,1,0,0,0,5752,5753,5,509,0,0,5753,5754,5,421,0,0,5754,745,1,0,0,0,
  	5755,5756,5,509,0,0,5756,5763,5,216,0,0,5757,5758,5,200,0,0,5758,5761,
  	3,1238,619,0,5759,5760,5,621,0,0,5760,5762,3,1202,601,0,5761,5759,1,0,
  	0,0,5761,5762,1,0,0,0,5762,5764,1,0,0,0,5763,5757,1,0,0,0,5763,5764,1,
  	0,0,0,5764,747,1,0,0,0,5765,5766,5,509,0,0,5766,5767,5,97,0,0,5767,5769,
  	5,109,0,0,5768,5770,3,1174,587,0,5769,5768,1,0,0,0,5769,5770,1,0,0,0,
  	5770,5771,1,0,0,0,5771,5772,3,1270,635,0,5772,749,1,0,0,0,5773,5774,5,
  	509,0,0,5774,5775,5,97,0,0,5775,5776,5,574,0,0,5776,5777,3,1314,657,0,
  	5777,751,1,0,0,0,5778,5779,5,509,0,0,5779,5780,5,97,0,0,5780,5781,5,636,
  	0,0,5781,5782,3,1286,643,0,5782,753,1,0,0,0,5783,5784,5,509,0,0,5784,
  	5785,5,316,0,0,5785,5786,5,547,0,0,5786,755,1,0,0,0,5787,5788,5,509,0,
  	0,5788,5789,3,574,287,0,5789,5792,5,547,0,0,5790,5791,4,378,137,0,5791,
  	5793,5,370,0,0,5792,5790,1,0,0,0,5792,5793,1,0,0,0,5793,5795,1,0,0,0,
  	5794,5796,3,970,485,0,5795,5794,1,0,0,0,5795,5796,1,0,0,0,5796,757,1,
  	0,0,0,5797,5798,5,509,0,0,5798,5799,5,97,0,0,5799,5800,5,422,0,0,5800,
  	5801,3,1274,637,0,5801,759,1,0,0,0,5802,5803,5,509,0,0,5803,5804,5,97,
  	0,0,5804,5805,5,206,0,0,5805,5806,3,1278,639,0,5806,761,1,0,0,0,5807,
  	5808,5,509,0,0,5808,5809,5,97,0,0,5809,5810,5,594,0,0,5810,5811,3,1282,
  	641,0,5811,763,1,0,0,0,5812,5813,5,509,0,0,5813,5814,5,97,0,0,5814,5815,
  	5,422,0,0,5815,5817,5,547,0,0,5816,5818,3,1242,621,0,5817,5816,1,0,0,
  	0,5817,5818,1,0,0,0,5818,765,1,0,0,0,5819,5820,5,509,0,0,5820,5821,5,
  	97,0,0,5821,5822,5,206,0,0,5822,5824,5,547,0,0,5823,5825,3,1242,621,0,
  	5824,5823,1,0,0,0,5824,5825,1,0,0,0,5825,767,1,0,0,0,5826,5827,5,509,
  	0,0,5827,5828,5,97,0,0,5828,5829,5,422,0,0,5829,5830,5,68,0,0,5830,5831,
  	3,1274,637,0,5831,769,1,0,0,0,5832,5833,5,509,0,0,5833,5834,5,97,0,0,
  	5834,5835,5,206,0,0,5835,5836,5,68,0,0,5836,5837,3,1278,639,0,5837,771,
  	1,0,0,0,5838,5839,5,509,0,0,5839,5840,5,97,0,0,5840,5841,5,170,0,0,5841,
  	5842,3,1298,649,0,5842,773,1,0,0,0,5843,5844,5,509,0,0,5844,5845,5,97,
  	0,0,5845,5846,5,618,0,0,5846,5847,3,1238,619,0,5847,775,1,0,0,0,5848,
  	5855,5,204,0,0,5849,5850,4,388,138,0,5850,5852,5,180,0,0,5851,5853,5,
  	204,0,0,5852,5851,1,0,0,0,5852,5853,1,0,0,0,5853,5855,1,0,0,0,5854,5848,
  	1,0,0,0,5854,5849,1,0,0,0,5855,777,1,0,0,0,5856,5859,3,1306,653,0,5857,
  	5859,5,10,0,0,5858,5856,1,0,0,0,5858,5857,1,0,0,0,5859,779,1,0,0,0,5860,
  	5861,7,87,0,0,5861,781,1,0,0,0,5862,5863,3,780,390,0,5863,5864,3,1338,
  	669,0,5864,783,1,0,0,0,5865,5870,3,786,393,0,5866,5867,5,773,0,0,5867,
  	5869,3,786,393,0,5868,5866,1,0,0,0,5869,5872,1,0,0,0,5870,5868,1,0,0,
  	0,5870,5871,1,0,0,0,5871,785,1,0,0,0,5872,5870,1,0,0,0,5873,5874,5,40,
  	0,0,5874,5881,5,255,0,0,5875,5876,5,91,0,0,5876,5881,5,568,0,0,5877,5878,
  	5,400,0,0,5878,5881,5,185,0,0,5879,5881,7,89,0,0,5880,5873,1,0,0,0,5880,
  	5875,1,0,0,0,5880,5877,1,0,0,0,5880,5879,1,0,0,0,5881,787,1,0,0,0,5882,
  	5883,5,33,0,0,5883,5920,3,1376,688,0,5884,5885,5,47,0,0,5885,5886,5,236,
  	0,0,5886,5887,3,790,395,0,5887,5890,5,251,0,0,5888,5891,3,1338,669,0,
  	5889,5891,5,128,0,0,5890,5888,1,0,0,0,5890,5889,1,0,0,0,5891,5920,1,0,
  	0,0,5892,5894,5,196,0,0,5893,5895,3,1246,623,0,5894,5893,1,0,0,0,5894,
  	5895,1,0,0,0,5895,5905,1,0,0,0,5896,5906,3,808,404,0,5897,5902,3,804,
  	402,0,5898,5899,5,773,0,0,5899,5901,3,804,402,0,5900,5898,1,0,0,0,5901,
  	5904,1,0,0,0,5902,5900,1,0,0,0,5902,5903,1,0,0,0,5903,5906,1,0,0,0,5904,
  	5902,1,0,0,0,5905,5896,1,0,0,0,5905,5897,1,0,0,0,5906,5920,1,0,0,0,5907,
  	5909,5,266,0,0,5908,5910,7,90,0,0,5909,5908,1,0,0,0,5909,5910,1,0,0,0,
  	5910,5911,1,0,0,0,5911,5920,3,854,427,0,5912,5913,5,281,0,0,5913,5914,
  	5,236,0,0,5914,5915,5,248,0,0,5915,5916,5,47,0,0,5916,5920,3,812,406,
  	0,5917,5918,4,394,139,0,5918,5920,5,510,0,0,5919,5882,1,0,0,0,5919,5884,
  	1,0,0,0,5919,5892,1,0,0,0,5919,5907,1,0,0,0,5919,5912,1,0,0,0,5919,5917,
  	1,0,0,0,5920,789,1,0,0,0,5921,5924,3,792,396,0,5922,5924,3,796,398,0,
  	5923,5921,1,0,0,0,5923,5922,1,0,0,0,5924,791,1,0,0,0,5925,5930,3,794,
  	397,0,5926,5927,5,773,0,0,5927,5929,3,794,397,0,5928,5926,1,0,0,0,5929,
  	5932,1,0,0,0,5930,5928,1,0,0,0,5930,5931,1,0,0,0,5931,793,1,0,0,0,5932,
  	5930,1,0,0,0,5933,5935,3,1314,657,0,5934,5936,3,798,399,0,5935,5934,1,
  	0,0,0,5935,5936,1,0,0,0,5936,795,1,0,0,0,5937,5938,3,1314,657,0,5938,
  	5939,5,405,0,0,5939,5940,5,776,0,0,5940,5941,3,54,27,0,5941,5943,5,777,
  	0,0,5942,5944,3,798,399,0,5943,5942,1,0,0,0,5943,5944,1,0,0,0,5944,797,
  	1,0,0,0,5945,5946,3,414,207,0,5946,5948,5,776,0,0,5947,5949,3,802,401,
  	0,5948,5947,1,0,0,0,5948,5949,1,0,0,0,5949,5950,1,0,0,0,5950,5951,5,777,
  	0,0,5951,799,1,0,0,0,5952,5955,3,1338,669,0,5953,5955,5,420,0,0,5954,
  	5952,1,0,0,0,5954,5953,1,0,0,0,5955,801,1,0,0,0,5956,5961,3,800,400,0,
  	5957,5958,5,773,0,0,5958,5960,3,800,400,0,5959,5957,1,0,0,0,5960,5963,
  	1,0,0,0,5961,5959,1,0,0,0,5961,5962,1,0,0,0,5962,803,1,0,0,0,5963,5961,
  	1,0,0,0,5964,5980,7,91,0,0,5965,5967,3,806,403,0,5966,5965,1,0,0,0,5966,
  	5967,1,0,0,0,5967,5968,1,0,0,0,5968,5980,5,289,0,0,5969,5970,5,445,0,
  	0,5970,5972,5,289,0,0,5971,5973,3,970,485,0,5972,5971,1,0,0,0,5972,5973,
  	1,0,0,0,5973,5980,1,0,0,0,5974,5975,4,402,140,0,5975,5976,5,430,0,0,5976,
  	5980,5,47,0,0,5977,5978,4,402,141,0,5978,5980,5,389,0,0,5979,5964,1,0,
  	0,0,5979,5966,1,0,0,0,5979,5969,1,0,0,0,5979,5974,1,0,0,0,5979,5977,1,
  	0,0,0,5980,805,1,0,0,0,5981,5982,7,92,0,0,5982,807,1,0,0,0,5983,5991,
  	7,17,0,0,5984,5985,5,645,0,0,5985,5986,5,435,0,0,5986,5992,5,287,0,0,
  	5987,5989,3,1340,670,0,5988,5990,3,810,405,0,5989,5988,1,0,0,0,5989,5990,
  	1,0,0,0,5990,5992,1,0,0,0,5991,5984,1,0,0,0,5991,5987,1,0,0,0,5991,5992,
  	1,0,0,0,5992,809,1,0,0,0,5993,5994,5,200,0,0,5994,5999,5,179,0,0,5995,
  	5996,5,645,0,0,5996,5997,5,435,0,0,5997,5999,5,287,0,0,5998,5993,1,0,
  	0,0,5998,5995,1,0,0,0,5999,811,1,0,0,0,6000,6001,3,1314,657,0,6001,6003,
  	3,818,409,0,6002,6004,3,798,399,0,6003,6002,1,0,0,0,6003,6004,1,0,0,0,
  	6004,6007,1,0,0,0,6005,6006,5,232,0,0,6006,6008,5,270,0,0,6007,6005,1,
  	0,0,0,6007,6008,1,0,0,0,6008,6011,1,0,0,0,6009,6011,3,814,407,0,6010,
  	6000,1,0,0,0,6010,6009,1,0,0,0,6011,813,1,0,0,0,6012,6017,3,816,408,0,
  	6013,6014,5,773,0,0,6014,6016,3,816,408,0,6015,6013,1,0,0,0,6016,6019,
  	1,0,0,0,6017,6015,1,0,0,0,6017,6018,1,0,0,0,6018,815,1,0,0,0,6019,6017,
  	1,0,0,0,6020,6022,3,1314,657,0,6021,6023,3,798,399,0,6022,6021,1,0,0,
  	0,6022,6023,1,0,0,0,6023,6026,1,0,0,0,6024,6025,5,232,0,0,6025,6027,5,
  	270,0,0,6026,6024,1,0,0,0,6026,6027,1,0,0,0,6027,817,1,0,0,0,6028,6029,
  	5,405,0,0,6029,6030,5,776,0,0,6030,6031,3,54,27,0,6031,6032,5,777,0,0,
  	6032,819,1,0,0,0,6033,6038,3,822,411,0,6034,6038,3,832,416,0,6035,6038,
  	3,834,417,0,6036,6038,3,838,419,0,6037,6033,1,0,0,0,6037,6034,1,0,0,0,
  	6037,6035,1,0,0,0,6037,6036,1,0,0,0,6038,821,1,0,0,0,6039,6040,5,97,0,
  	0,6040,6041,5,709,0,0,6041,6042,5,217,0,0,6042,6043,3,1338,669,0,6043,
  	6045,5,599,0,0,6044,6046,3,1408,704,0,6045,6044,1,0,0,0,6045,6046,1,0,
  	0,0,6046,6047,1,0,0,0,6047,6049,7,93,0,0,6048,6050,3,824,412,0,6049,6048,
  	1,0,0,0,6049,6050,1,0,0,0,6050,6052,1,0,0,0,6051,6053,3,828,414,0,6052,
  	6051,1,0,0,0,6052,6053,1,0,0,0,6053,6055,1,0,0,0,6054,6056,3,830,415,
  	0,6055,6054,1,0,0,0,6055,6056,1,0,0,0,6056,823,1,0,0,0,6057,6059,5,711,
  	0,0,6058,6060,3,1408,704,0,6059,6058,1,0,0,0,6059,6060,1,0,0,0,6060,6061,
  	1,0,0,0,6061,6068,3,826,413,0,6062,6064,5,773,0,0,6063,6062,1,0,0,0,6063,
  	6064,1,0,0,0,6064,6065,1,0,0,0,6065,6067,3,826,413,0,6066,6063,1,0,0,
  	0,6067,6070,1,0,0,0,6068,6066,1,0,0,0,6068,6069,1,0,0,0,6069,825,1,0,
  	0,0,6070,6068,1,0,0,0,6071,6074,5,747,0,0,6072,6073,5,759,0,0,6073,6075,
  	5,747,0,0,6074,6072,1,0,0,0,6074,6075,1,0,0,0,6075,827,1,0,0,0,6076,6078,
  	5,708,0,0,6077,6079,3,1408,704,0,6078,6077,1,0,0,0,6078,6079,1,0,0,0,
  	6079,6080,1,0,0,0,6080,6081,5,747,0,0,6081,829,1,0,0,0,6082,6083,7,7,
  	0,0,6083,831,1,0,0,0,6084,6085,5,11,0,0,6085,6086,5,709,0,0,6086,6087,
  	5,217,0,0,6087,6089,3,1332,666,0,6088,6090,3,824,412,0,6089,6088,1,0,
  	0,0,6089,6090,1,0,0,0,6090,6092,1,0,0,0,6091,6093,3,828,414,0,6092,6091,
  	1,0,0,0,6092,6093,1,0,0,0,6093,6095,1,0,0,0,6094,6096,3,830,415,0,6095,
  	6094,1,0,0,0,6095,6096,1,0,0,0,6096,6098,1,0,0,0,6097,6099,5,198,0,0,
  	6098,6097,1,0,0,0,6098,6099,1,0,0,0,6099,833,1,0,0,0,6100,6101,5,506,
  	0,0,6101,6102,5,709,0,0,6102,6103,5,217,0,0,6103,6106,3,1338,669,0,6104,
  	6105,5,200,0,0,6105,6107,3,836,418,0,6106,6104,1,0,0,0,6106,6107,1,0,
  	0,0,6107,835,1,0,0,0,6108,6115,3,1352,676,0,6109,6111,5,773,0,0,6110,
  	6109,1,0,0,0,6110,6111,1,0,0,0,6111,6112,1,0,0,0,6112,6114,3,1352,676,
  	0,6113,6110,1,0,0,0,6114,6117,1,0,0,0,6115,6113,1,0,0,0,6115,6116,1,0,
  	0,0,6116,837,1,0,0,0,6117,6115,1,0,0,0,6118,6119,5,148,0,0,6119,6120,
  	5,709,0,0,6120,6121,5,217,0,0,6121,6123,3,1332,666,0,6122,6124,5,198,
  	0,0,6123,6122,1,0,0,0,6123,6124,1,0,0,0,6124,839,1,0,0,0,6125,6132,3,
  	842,421,0,6126,6132,3,844,422,0,6127,6132,3,848,424,0,6128,6132,3,850,
  	425,0,6129,6130,4,420,142,0,6130,6132,3,852,426,0,6131,6125,1,0,0,0,6131,
  	6126,1,0,0,0,6131,6127,1,0,0,0,6131,6128,1,0,0,0,6131,6129,1,0,0,0,6132,
  	841,1,0,0,0,6133,6134,7,94,0,0,6134,6137,3,1314,657,0,6135,6138,3,1372,
  	686,0,6136,6138,3,1258,629,0,6137,6135,1,0,0,0,6137,6136,1,0,0,0,6137,
  	6138,1,0,0,0,6138,843,1,0,0,0,6139,6154,7,94,0,0,6140,6141,4,422,143,
  	0,6141,6155,5,180,0,0,6142,6143,4,422,144,0,6143,6155,5,404,0,0,6144,
  	6145,5,201,0,0,6145,6146,5,750,0,0,6146,6155,3,1398,699,0,6147,6148,4,
  	422,145,0,6148,6155,5,14,0,0,6149,6150,4,422,146,0,6150,6151,5,14,0,0,
  	6151,6152,5,201,0,0,6152,6153,5,750,0,0,6153,6155,3,1398,699,0,6154,6140,
  	1,0,0,0,6154,6142,1,0,0,0,6154,6144,1,0,0,0,6154,6147,1,0,0,0,6154,6149,
  	1,0,0,0,6154,6155,1,0,0,0,6155,6156,1,0,0,0,6156,6157,3,846,423,0,6157,
  	845,1,0,0,0,6158,6167,3,272,136,0,6159,6167,3,226,113,0,6160,6167,3,238,
  	119,0,6161,6167,3,270,135,0,6162,6167,3,424,212,0,6163,6164,5,200,0,0,
  	6164,6165,5,84,0,0,6165,6167,3,1352,676,0,6166,6158,1,0,0,0,6166,6159,
  	1,0,0,0,6166,6160,1,0,0,0,6166,6161,1,0,0,0,6166,6162,1,0,0,0,6166,6163,
  	1,0,0,0,6167,847,1,0,0,0,6168,6169,5,222,0,0,6169,6170,3,1398,699,0,6170,
  	849,1,0,0,0,6171,6172,5,620,0,0,6172,6173,3,1338,669,0,6173,851,1,0,0,
  	0,6174,6175,5,714,0,0,6175,853,1,0,0,0,6176,6177,6,427,-1,0,6177,6183,
  	3,856,428,0,6178,6180,5,257,0,0,6179,6181,3,948,474,0,6180,6179,1,0,0,
  	0,6180,6181,1,0,0,0,6181,6182,1,0,0,0,6182,6184,7,95,0,0,6183,6178,1,
  	0,0,0,6183,6184,1,0,0,0,6184,6188,1,0,0,0,6185,6186,5,371,0,0,6186,6188,
  	3,854,427,4,6187,6176,1,0,0,0,6187,6185,1,0,0,0,6188,6200,1,0,0,0,6189,
  	6190,10,3,0,0,6190,6191,7,96,0,0,6191,6199,3,854,427,4,6192,6193,10,2,
  	0,0,6193,6194,5,654,0,0,6194,6199,3,854,427,3,6195,6196,10,1,0,0,6196,
  	6197,7,97,0,0,6197,6199,3,854,427,2,6198,6189,1,0,0,0,6198,6192,1,0,0,
  	0,6198,6195,1,0,0,0,6199,6202,1,0,0,0,6200,6198,1,0,0,0,6200,6201,1,0,
  	0,0,6201,855,1,0,0,0,6202,6200,1,0,0,0,6203,6204,6,428,-1,0,6204,6205,
  	3,860,430,0,6205,6223,1,0,0,0,6206,6207,10,3,0,0,6207,6209,5,257,0,0,
  	6208,6210,3,948,474,0,6209,6208,1,0,0,0,6209,6210,1,0,0,0,6210,6211,1,
  	0,0,0,6211,6222,5,376,0,0,6212,6213,10,2,0,0,6213,6214,3,858,429,0,6214,
  	6215,3,860,430,0,6215,6222,1,0,0,0,6216,6217,10,1,0,0,6217,6218,3,858,
  	429,0,6218,6219,7,98,0,0,6219,6220,3,286,143,0,6220,6222,1,0,0,0,6221,
  	6206,1,0,0,0,6221,6212,1,0,0,0,6221,6216,1,0,0,0,6222,6225,1,0,0,0,6223,
  	6221,1,0,0,0,6223,6224,1,0,0,0,6224,857,1,0,0,0,6225,6223,1,0,0,0,6226,
  	6227,7,99,0,0,6227,859,1,0,0,0,6228,6242,3,864,432,0,6229,6231,3,948,
  	474,0,6230,6229,1,0,0,0,6230,6231,1,0,0,0,6231,6232,1,0,0,0,6232,6243,
  	3,862,431,0,6233,6234,4,430,153,0,6234,6236,5,733,0,0,6235,6237,5,668,
  	0,0,6236,6235,1,0,0,0,6236,6237,1,0,0,0,6237,6238,1,0,0,0,6238,6243,3,
  	960,480,0,6239,6240,5,521,0,0,6240,6241,5,275,0,0,6241,6243,3,864,432,
  	0,6242,6230,1,0,0,0,6242,6233,1,0,0,0,6242,6239,1,0,0,0,6242,6243,1,0,
  	0,0,6243,861,1,0,0,0,6244,6250,5,251,0,0,6245,6251,3,286,143,0,6246,6247,
  	5,776,0,0,6247,6248,3,944,472,0,6248,6249,5,777,0,0,6249,6251,1,0,0,0,
  	6250,6245,1,0,0,0,6250,6246,1,0,0,0,6251,6266,1,0,0,0,6252,6253,5,30,
  	0,0,6253,6254,3,864,432,0,6254,6255,5,15,0,0,6255,6256,3,860,430,0,6256,
  	6266,1,0,0,0,6257,6258,5,275,0,0,6258,6261,3,866,433,0,6259,6260,5,168,
  	0,0,6260,6262,3,866,433,0,6261,6259,1,0,0,0,6261,6262,1,0,0,0,6262,6266,
  	1,0,0,0,6263,6264,5,444,0,0,6264,6266,3,864,432,0,6265,6244,1,0,0,0,6265,
  	6252,1,0,0,0,6265,6257,1,0,0,0,6265,6263,1,0,0,0,6266,863,1,0,0,0,6267,
  	6268,6,432,-1,0,6268,6269,3,866,433,0,6269,6296,1,0,0,0,6270,6271,10,
  	7,0,0,6271,6272,5,769,0,0,6272,6295,3,864,432,8,6273,6274,10,6,0,0,6274,
  	6275,7,100,0,0,6275,6295,3,864,432,7,6276,6277,10,5,0,0,6277,6278,7,101,
  	0,0,6278,6295,3,864,432,6,6279,6280,10,3,0,0,6280,6281,7,102,0,0,6281,
  	6295,3,864,432,4,6282,6283,10,2,0,0,6283,6284,5,768,0,0,6284,6295,3,864,
  	432,3,6285,6286,10,1,0,0,6286,6287,5,771,0,0,6287,6295,3,864,432,2,6288,
  	6289,10,4,0,0,6289,6290,7,101,0,0,6290,6291,5,247,0,0,6291,6292,3,854,
  	427,0,6292,6293,3,952,476,0,6293,6295,1,0,0,0,6294,6270,1,0,0,0,6294,
  	6273,1,0,0,0,6294,6276,1,0,0,0,6294,6279,1,0,0,0,6294,6282,1,0,0,0,6294,
  	6285,1,0,0,0,6294,6288,1,0,0,0,6295,6298,1,0,0,0,6296,6294,1,0,0,0,6296,
  	6297,1,0,0,0,6297,865,1,0,0,0,6298,6296,1,0,0,0,6299,6300,6,433,-1,0,
  	6300,6302,3,1258,629,0,6301,6303,3,870,435,0,6302,6301,1,0,0,0,6302,6303,
  	1,0,0,0,6303,6425,1,0,0,0,6304,6425,3,898,449,0,6305,6425,3,918,459,0,
  	6306,6425,3,1364,682,0,6307,6425,5,786,0,0,6308,6425,3,930,465,0,6309,
  	6425,3,928,464,0,6310,6425,3,872,436,0,6311,6312,4,433,161,0,6312,6425,
  	3,874,437,0,6313,6314,4,433,162,0,6314,6425,3,876,438,0,6315,6316,7,103,
  	0,0,6316,6425,3,866,433,15,6317,6318,3,950,475,0,6318,6319,3,866,433,
  	14,6319,6425,1,0,0,0,6320,6322,5,487,0,0,6321,6320,1,0,0,0,6321,6322,
  	1,0,0,0,6322,6323,1,0,0,0,6323,6324,5,776,0,0,6324,6325,3,944,472,0,6325,
  	6326,5,777,0,0,6326,6425,1,0,0,0,6327,6329,5,174,0,0,6328,6327,1,0,0,
  	0,6328,6329,1,0,0,0,6329,6330,1,0,0,0,6330,6425,3,286,143,0,6331,6332,
  	5,778,0,0,6332,6333,3,1338,669,0,6333,6334,3,854,427,0,6334,6335,5,779,
  	0,0,6335,6425,1,0,0,0,6336,6337,5,320,0,0,6337,6338,3,892,446,0,6338,
  	6339,5,7,0,0,6339,6340,5,776,0,0,6340,6342,3,864,432,0,6341,6343,3,896,
  	448,0,6342,6341,1,0,0,0,6342,6343,1,0,0,0,6343,6344,1,0,0,0,6344,6345,
  	5,777,0,0,6345,6425,1,0,0,0,6346,6347,5,32,0,0,6347,6425,3,866,433,9,
  	6348,6349,5,52,0,0,6349,6350,5,776,0,0,6350,6353,3,854,427,0,6351,6352,
  	5,21,0,0,6352,6354,5,284,0,0,6353,6351,1,0,0,0,6353,6354,1,0,0,0,6354,
  	6355,1,0,0,0,6355,6356,5,17,0,0,6356,6358,3,942,471,0,6357,6359,3,868,
  	434,0,6358,6357,1,0,0,0,6358,6359,1,0,0,0,6359,6360,1,0,0,0,6360,6361,
  	5,777,0,0,6361,6425,1,0,0,0,6362,6363,4,433,163,0,6363,6364,5,52,0,0,
  	6364,6365,5,776,0,0,6365,6366,3,854,427,0,6366,6367,5,21,0,0,6367,6368,
  	5,586,0,0,6368,6370,5,800,0,0,6369,6371,5,247,0,0,6370,6369,1,0,0,0,6370,
  	6371,1,0,0,0,6371,6372,1,0,0,0,6372,6373,3,1370,685,0,6373,6374,5,17,
  	0,0,6374,6375,5,113,0,0,6375,6376,3,1126,563,0,6376,6377,5,777,0,0,6377,
  	6425,1,0,0,0,6378,6380,5,51,0,0,6379,6381,3,854,427,0,6380,6379,1,0,0,
  	0,6380,6381,1,0,0,0,6381,6385,1,0,0,0,6382,6383,3,936,468,0,6383,6384,
  	3,938,469,0,6384,6386,1,0,0,0,6385,6382,1,0,0,0,6386,6387,1,0,0,0,6387,
  	6385,1,0,0,0,6387,6388,1,0,0,0,6388,6390,1,0,0,0,6389,6391,3,940,470,
  	0,6390,6389,1,0,0,0,6390,6391,1,0,0,0,6391,6392,1,0,0,0,6392,6393,5,159,
  	0,0,6393,6425,1,0,0,0,6394,6395,5,94,0,0,6395,6396,5,776,0,0,6396,6397,
  	3,854,427,0,6397,6398,5,773,0,0,6398,6399,3,942,471,0,6399,6400,5,777,
  	0,0,6400,6425,1,0,0,0,6401,6402,5,94,0,0,6402,6403,5,776,0,0,6403,6404,
  	3,854,427,0,6404,6405,5,621,0,0,6405,6406,3,1130,565,0,6406,6407,5,777,
  	0,0,6407,6425,1,0,0,0,6408,6409,5,128,0,0,6409,6410,5,776,0,0,6410,6411,
  	3,1346,673,0,6411,6412,5,777,0,0,6412,6425,1,0,0,0,6413,6414,5,626,0,
  	0,6414,6415,5,776,0,0,6415,6416,3,1346,673,0,6416,6417,5,777,0,0,6417,
  	6425,1,0,0,0,6418,6419,5,247,0,0,6419,6420,3,854,427,0,6420,6421,3,952,
  	476,0,6421,6422,5,758,0,0,6422,6423,3,854,427,0,6423,6425,1,0,0,0,6424,
  	6299,1,0,0,0,6424,6304,1,0,0,0,6424,6305,1,0,0,0,6424,6306,1,0,0,0,6424,
  	6307,1,0,0,0,6424,6308,1,0,0,0,6424,6309,1,0,0,0,6424,6310,1,0,0,0,6424,
  	6311,1,0,0,0,6424,6313,1,0,0,0,6424,6315,1,0,0,0,6424,6317,1,0,0,0,6424,
  	6321,1,0,0,0,6424,6328,1,0,0,0,6424,6331,1,0,0,0,6424,6336,1,0,0,0,6424,
  	6346,1,0,0,0,6424,6348,1,0,0,0,6424,6362,1,0,0,0,6424,6378,1,0,0,0,6424,
  	6394,1,0,0,0,6424,6401,1,0,0,0,6424,6408,1,0,0,0,6424,6413,1,0,0,0,6424,
  	6418,1,0,0,0,6425,6434,1,0,0,0,6426,6427,10,16,0,0,6427,6428,5,746,0,
  	0,6428,6433,3,866,433,17,6429,6430,10,24,0,0,6430,6431,5,69,0,0,6431,
  	6433,3,1398,699,0,6432,6426,1,0,0,0,6432,6429,1,0,0,0,6433,6436,1,0,0,
  	0,6434,6432,1,0,0,0,6434,6435,1,0,0,0,6435,867,1,0,0,0,6436,6434,1,0,
  	0,0,6437,6438,4,434,166,0,6438,6439,5,731,0,0,6439,869,1,0,0,0,6440,6441,
  	4,435,167,0,6441,6442,5,781,0,0,6442,6447,3,1370,685,0,6443,6444,4,435,
  	168,0,6444,6445,5,782,0,0,6445,6447,3,1370,685,0,6446,6440,1,0,0,0,6446,
  	6443,1,0,0,0,6447,871,1,0,0,0,6448,6449,5,26,0,0,6449,6451,5,776,0,0,
  	6450,6452,5,143,0,0,6451,6450,1,0,0,0,6451,6452,1,0,0,0,6452,6453,1,0,
  	0,0,6453,6454,3,890,445,0,6454,6457,5,777,0,0,6455,6456,4,436,169,0,6456,
  	6458,3,878,439,0,6457,6455,1,0,0,0,6457,6458,1,0,0,0,6458,6543,1,0,0,
  	0,6459,6460,7,104,0,0,6460,6461,5,776,0,0,6461,6462,3,890,445,0,6462,
  	6465,5,777,0,0,6463,6464,4,436,170,0,6464,6466,3,878,439,0,6465,6463,
  	1,0,0,0,6465,6466,1,0,0,0,6466,6543,1,0,0,0,6467,6468,4,436,171,0,6468,
  	6543,3,888,444,0,6469,6470,4,436,172,0,6470,6471,5,832,0,0,6471,6473,
  	5,776,0,0,6472,6474,5,143,0,0,6473,6472,1,0,0,0,6473,6474,1,0,0,0,6474,
  	6475,1,0,0,0,6475,6476,3,890,445,0,6476,6478,5,777,0,0,6477,6479,3,878,
  	439,0,6478,6477,1,0,0,0,6478,6479,1,0,0,0,6479,6543,1,0,0,0,6480,6481,
  	5,95,0,0,6481,6489,5,776,0,0,6482,6484,5,10,0,0,6483,6482,1,0,0,0,6483,
  	6484,1,0,0,0,6484,6485,1,0,0,0,6485,6490,5,760,0,0,6486,6490,3,890,445,
  	0,6487,6488,5,143,0,0,6488,6490,3,944,472,0,6489,6483,1,0,0,0,6489,6486,
  	1,0,0,0,6489,6487,1,0,0,0,6490,6491,1,0,0,0,6491,6494,5,777,0,0,6492,
  	6493,4,436,173,0,6493,6495,3,878,439,0,6494,6492,1,0,0,0,6494,6495,1,
  	0,0,0,6495,6543,1,0,0,0,6496,6497,7,105,0,0,6497,6499,5,776,0,0,6498,
  	6500,5,143,0,0,6499,6498,1,0,0,0,6499,6500,1,0,0,0,6500,6501,1,0,0,0,
  	6501,6502,3,890,445,0,6502,6505,5,777,0,0,6503,6504,4,436,174,0,6504,
  	6506,3,878,439,0,6505,6503,1,0,0,0,6505,6506,1,0,0,0,6506,6543,1,0,0,
  	0,6507,6508,7,106,0,0,6508,6509,5,776,0,0,6509,6510,3,890,445,0,6510,
  	6513,5,777,0,0,6511,6512,4,436,175,0,6512,6514,3,878,439,0,6513,6511,
  	1,0,0,0,6513,6514,1,0,0,0,6514,6543,1,0,0,0,6515,6516,5,564,0,0,6516,
  	6517,5,776,0,0,6517,6518,5,143,0,0,6518,6519,3,890,445,0,6519,6522,5,
  	777,0,0,6520,6521,4,436,176,0,6521,6523,3,878,439,0,6522,6520,1,0,0,0,
  	6522,6523,1,0,0,0,6523,6543,1,0,0,0,6524,6525,5,218,0,0,6525,6527,5,776,
  	0,0,6526,6528,5,143,0,0,6527,6526,1,0,0,0,6527,6528,1,0,0,0,6528,6529,
  	1,0,0,0,6529,6531,3,944,472,0,6530,6532,3,334,167,0,6531,6530,1,0,0,0,
  	6531,6532,1,0,0,0,6532,6535,1,0,0,0,6533,6534,5,499,0,0,6534,6536,3,1372,
  	686,0,6535,6533,1,0,0,0,6535,6536,1,0,0,0,6536,6537,1,0,0,0,6537,6540,
  	5,777,0,0,6538,6539,4,436,177,0,6539,6541,3,878,439,0,6540,6538,1,0,0,
  	0,6540,6541,1,0,0,0,6541,6543,1,0,0,0,6542,6448,1,0,0,0,6542,6459,1,0,
  	0,0,6542,6467,1,0,0,0,6542,6469,1,0,0,0,6542,6480,1,0,0,0,6542,6496,1,
  	0,0,0,6542,6507,1,0,0,0,6542,6515,1,0,0,0,6542,6524,1,0,0,0,6543,873,
  	1,0,0,0,6544,6545,5,672,0,0,6545,6546,5,776,0,0,6546,6547,3,944,472,0,
  	6547,6548,5,777,0,0,6548,875,1,0,0,0,6549,6550,7,107,0,0,6550,6551,3,
  	1406,703,0,6551,6552,3,878,439,0,6552,6600,1,0,0,0,6553,6561,5,688,0,
  	0,6554,6555,4,438,178,0,6555,6562,3,960,480,0,6556,6557,4,438,179,0,6557,
  	6558,5,776,0,0,6558,6559,3,882,441,0,6559,6560,5,777,0,0,6560,6562,1,
  	0,0,0,6561,6554,1,0,0,0,6561,6556,1,0,0,0,6562,6563,1,0,0,0,6563,6564,
  	3,878,439,0,6564,6600,1,0,0,0,6565,6566,7,108,0,0,6566,6567,5,776,0,0,
  	6567,6569,3,854,427,0,6568,6570,3,880,440,0,6569,6568,1,0,0,0,6569,6570,
  	1,0,0,0,6570,6571,1,0,0,0,6571,6573,5,777,0,0,6572,6574,3,886,443,0,6573,
  	6572,1,0,0,0,6573,6574,1,0,0,0,6574,6575,1,0,0,0,6575,6576,3,878,439,
  	0,6576,6600,1,0,0,0,6577,6578,7,109,0,0,6578,6580,3,958,479,0,6579,6581,
  	3,886,443,0,6580,6579,1,0,0,0,6580,6581,1,0,0,0,6581,6582,1,0,0,0,6582,
  	6583,3,878,439,0,6583,6600,1,0,0,0,6584,6585,5,687,0,0,6585,6586,5,776,
  	0,0,6586,6587,3,854,427,0,6587,6588,5,773,0,0,6588,6589,3,866,433,0,6589,
  	6592,5,777,0,0,6590,6591,5,203,0,0,6591,6593,7,110,0,0,6592,6590,1,0,
  	0,0,6592,6593,1,0,0,0,6593,6595,1,0,0,0,6594,6596,3,886,443,0,6595,6594,
  	1,0,0,0,6595,6596,1,0,0,0,6596,6597,1,0,0,0,6597,6598,3,878,439,0,6598,
  	6600,1,0,0,0,6599,6549,1,0,0,0,6599,6553,1,0,0,0,6599,6565,1,0,0,0,6599,
  	6577,1,0,0,0,6599,6584,1,0,0,0,6600,877,1,0,0,0,6601,6604,5,691,0,0,6602,
  	6605,3,1334,667,0,6603,6605,3,308,154,0,6604,6602,1,0,0,0,6604,6603,1,
  	0,0,0,6605,879,1,0,0,0,6606,6614,5,773,0,0,6607,6610,4,440,180,0,6608,
  	6611,3,1354,677,0,6609,6611,5,786,0,0,6610,6608,1,0,0,0,6610,6609,1,0,
  	0,0,6611,6615,1,0,0,0,6612,6613,4,440,181,0,6613,6615,3,882,441,0,6614,
  	6607,1,0,0,0,6614,6612,1,0,0,0,6615,6618,1,0,0,0,6616,6617,5,773,0,0,
  	6617,6619,3,854,427,0,6618,6616,1,0,0,0,6618,6619,1,0,0,0,6619,881,1,
  	0,0,0,6620,6623,3,1388,694,0,6621,6623,3,884,442,0,6622,6620,1,0,0,0,
  	6622,6621,1,0,0,0,6623,883,1,0,0,0,6624,6628,5,786,0,0,6625,6628,3,1338,
  	669,0,6626,6628,3,924,462,0,6627,6624,1,0,0,0,6627,6625,1,0,0,0,6627,
  	6626,1,0,0,0,6628,885,1,0,0,0,6629,6630,7,111,0,0,6630,6631,5,689,0,0,
  	6631,887,1,0,0,0,6632,6633,5,667,0,0,6633,6634,5,776,0,0,6634,6635,3,
  	890,445,0,6635,6637,5,777,0,0,6636,6638,3,878,439,0,6637,6636,1,0,0,0,
  	6637,6638,1,0,0,0,6638,6649,1,0,0,0,6639,6640,5,666,0,0,6640,6641,5,776,
  	0,0,6641,6642,3,890,445,0,6642,6643,5,773,0,0,6643,6644,3,890,445,0,6644,
  	6646,5,777,0,0,6645,6647,3,878,439,0,6646,6645,1,0,0,0,6646,6647,1,0,
  	0,0,6647,6649,1,0,0,0,6648,6632,1,0,0,0,6648,6639,1,0,0,0,6649,889,1,
  	0,0,0,6650,6652,5,10,0,0,6651,6650,1,0,0,0,6651,6652,1,0,0,0,6652,6653,
  	1,0,0,0,6653,6654,3,854,427,0,6654,891,1,0,0,0,6655,6661,3,894,447,0,
  	6656,6657,5,776,0,0,6657,6658,3,894,447,0,6658,6659,5,777,0,0,6659,6661,
  	1,0,0,0,6660,6655,1,0,0,0,6660,6656,1,0,0,0,6661,893,1,0,0,0,6662,6667,
  	3,1346,673,0,6663,6664,5,773,0,0,6664,6666,3,1346,673,0,6665,6663,1,0,
  	0,0,6666,6669,1,0,0,0,6667,6665,1,0,0,0,6667,6668,1,0,0,0,6668,895,1,
  	0,0,0,6669,6667,1,0,0,0,6670,6671,5,251,0,0,6671,6672,5,41,0,0,6672,6686,
  	5,346,0,0,6673,6674,5,251,0,0,6674,6675,5,359,0,0,6675,6676,5,267,0,0,
  	6676,6680,5,346,0,0,6677,6678,5,645,0,0,6678,6679,5,430,0,0,6679,6681,
  	5,176,0,0,6680,6677,1,0,0,0,6680,6681,1,0,0,0,6681,6686,1,0,0,0,6682,
  	6683,5,645,0,0,6683,6684,5,430,0,0,6684,6686,5,176,0,0,6685,6670,1,0,
  	0,0,6685,6673,1,0,0,0,6685,6682,1,0,0,0,6686,897,1,0,0,0,6687,6688,5,
  	60,0,0,6688,6689,5,776,0,0,6689,6692,3,944,472,0,6690,6691,5,621,0,0,
  	6691,6693,3,1130,565,0,6692,6690,1,0,0,0,6692,6693,1,0,0,0,6693,6694,
  	1,0,0,0,6694,6695,5,777,0,0,6695,6966,1,0,0,0,6696,6698,5,105,0,0,6697,
  	6699,3,1406,703,0,6698,6697,1,0,0,0,6698,6699,1,0,0,0,6699,6966,1,0,0,
  	0,6700,6701,5,116,0,0,6701,6966,3,958,479,0,6702,6703,5,122,0,0,6703,
  	6966,3,958,479,0,6704,6705,5,229,0,0,6705,6966,3,958,479,0,6706,6707,
  	5,242,0,0,6707,6708,5,776,0,0,6708,6709,3,854,427,0,6709,6710,5,773,0,
  	0,6710,6711,3,854,427,0,6711,6712,5,773,0,0,6712,6713,3,854,427,0,6713,
  	6714,5,773,0,0,6714,6715,3,854,427,0,6715,6716,5,777,0,0,6716,6966,1,
  	0,0,0,6717,6718,5,247,0,0,6718,6719,5,776,0,0,6719,6722,3,854,427,0,6720,
  	6721,5,773,0,0,6721,6723,3,854,427,0,6722,6720,1,0,0,0,6723,6724,1,0,
  	0,0,6724,6722,1,0,0,0,6724,6725,1,0,0,0,6725,6726,1,0,0,0,6726,6727,5,
  	777,0,0,6727,6966,1,0,0,0,6728,6729,4,449,182,0,6729,6730,5,794,0,0,6730,
  	6731,5,776,0,0,6731,6732,3,866,433,0,6732,6733,5,773,0,0,6733,6735,3,
  	1376,688,0,6734,6736,3,900,450,0,6735,6734,1,0,0,0,6735,6736,1,0,0,0,
  	6736,6737,1,0,0,0,6737,6738,3,394,197,0,6738,6739,5,777,0,0,6739,6966,
  	1,0,0,0,6740,6741,5,272,0,0,6741,6742,5,776,0,0,6742,6743,3,854,427,0,
  	6743,6744,5,773,0,0,6744,6745,3,854,427,0,6745,6746,5,777,0,0,6746,6966,
  	1,0,0,0,6747,6748,5,343,0,0,6748,6966,3,958,479,0,6749,6750,5,350,0,0,
  	6750,6966,3,958,479,0,6751,6752,5,478,0,0,6752,6753,5,776,0,0,6753,6754,
  	3,854,427,0,6754,6755,5,773,0,0,6755,6756,3,854,427,0,6756,6757,5,777,
  	0,0,6757,6966,1,0,0,0,6758,6759,5,495,0,0,6759,6966,3,958,479,0,6760,
  	6761,5,586,0,0,6761,6966,3,958,479,0,6762,6763,5,583,0,0,6763,6764,5,
  	776,0,0,6764,6767,3,854,427,0,6765,6766,5,773,0,0,6766,6768,3,854,427,
  	0,6767,6765,1,0,0,0,6767,6768,1,0,0,0,6768,6769,1,0,0,0,6769,6770,5,777,
  	0,0,6770,6966,1,0,0,0,6771,6966,3,914,457,0,6772,6966,3,598,299,0,6773,
  	6774,5,626,0,0,6774,6966,3,958,479,0,6775,6776,5,656,0,0,6776,6966,3,
  	958,479,0,6777,6778,7,112,0,0,6778,6779,5,776,0,0,6779,6780,3,854,427,
  	0,6780,6786,5,773,0,0,6781,6787,3,854,427,0,6782,6783,5,247,0,0,6783,
  	6784,3,854,427,0,6784,6785,3,952,476,0,6785,6787,1,0,0,0,6786,6781,1,
  	0,0,0,6786,6782,1,0,0,0,6787,6788,1,0,0,0,6788,6789,5,777,0,0,6789,6966,
  	1,0,0,0,6790,6792,5,100,0,0,6791,6793,3,1406,703,0,6792,6791,1,0,0,0,
  	6792,6793,1,0,0,0,6793,6966,1,0,0,0,6794,6796,5,108,0,0,6795,6797,3,904,
  	452,0,6796,6795,1,0,0,0,6796,6797,1,0,0,0,6797,6966,1,0,0,0,6798,6799,
  	7,113,0,0,6799,6800,5,776,0,0,6800,6801,3,854,427,0,6801,6802,5,773,0,
  	0,6802,6803,5,247,0,0,6803,6804,3,854,427,0,6804,6805,3,952,476,0,6805,
  	6806,5,777,0,0,6806,6966,1,0,0,0,6807,6808,5,182,0,0,6808,6809,5,776,
  	0,0,6809,6810,3,952,476,0,6810,6811,5,203,0,0,6811,6812,3,854,427,0,6812,
  	6813,5,777,0,0,6813,6966,1,0,0,0,6814,6815,5,213,0,0,6815,6816,5,776,
  	0,0,6816,6817,3,912,456,0,6817,6818,5,773,0,0,6818,6819,3,854,427,0,6819,
  	6820,5,777,0,0,6820,6966,1,0,0,0,6821,6823,5,372,0,0,6822,6824,3,904,
  	452,0,6823,6822,1,0,0,0,6823,6824,1,0,0,0,6824,6966,1,0,0,0,6825,6826,
  	5,414,0,0,6826,6827,5,776,0,0,6827,6828,3,864,432,0,6828,6829,5,251,0,
  	0,6829,6830,3,854,427,0,6830,6831,5,777,0,0,6831,6966,1,0,0,0,6832,6966,
  	3,916,458,0,6833,6835,5,569,0,0,6834,6836,3,904,452,0,6835,6834,1,0,0,
  	0,6835,6836,1,0,0,0,6836,6966,1,0,0,0,6837,6838,7,114,0,0,6838,6839,5,
  	776,0,0,6839,6840,3,954,477,0,6840,6841,5,773,0,0,6841,6842,3,854,427,
  	0,6842,6843,5,773,0,0,6843,6844,3,854,427,0,6844,6845,5,777,0,0,6845,
  	6966,1,0,0,0,6846,6848,5,622,0,0,6847,6849,3,1406,703,0,6848,6847,1,0,
  	0,0,6848,6849,1,0,0,0,6849,6966,1,0,0,0,6850,6852,5,624,0,0,6851,6853,
  	3,904,452,0,6852,6851,1,0,0,0,6852,6853,1,0,0,0,6853,6966,1,0,0,0,6854,
  	6856,5,623,0,0,6855,6857,3,904,452,0,6856,6855,1,0,0,0,6856,6857,1,0,
  	0,0,6857,6966,1,0,0,0,6858,6859,5,19,0,0,6859,6966,3,958,479,0,6860,6861,
  	5,58,0,0,6861,6966,3,958,479,0,6862,6863,5,67,0,0,6863,6966,3,956,478,
  	0,6864,6865,5,70,0,0,6865,6966,3,958,479,0,6866,6867,5,109,0,0,6867,6966,
  	3,1406,703,0,6868,6869,5,231,0,0,6869,6870,5,776,0,0,6870,6871,3,854,
  	427,0,6871,6872,5,773,0,0,6872,6873,3,854,427,0,6873,6874,5,773,0,0,6874,
  	6875,3,854,427,0,6875,6876,5,777,0,0,6876,6966,1,0,0,0,6877,6878,5,201,
  	0,0,6878,6879,5,776,0,0,6879,6880,3,854,427,0,6880,6881,5,773,0,0,6881,
  	6884,3,854,427,0,6882,6883,5,773,0,0,6883,6885,3,854,427,0,6884,6882,
  	1,0,0,0,6884,6885,1,0,0,0,6885,6886,1,0,0,0,6886,6887,5,777,0,0,6887,
  	6966,1,0,0,0,6888,6889,5,337,0,0,6889,6966,3,958,479,0,6890,6891,5,349,
  	0,0,6891,6892,5,776,0,0,6892,6893,3,854,427,0,6893,6894,5,773,0,0,6894,
  	6895,3,854,427,0,6895,6896,5,777,0,0,6896,6966,1,0,0,0,6897,6898,4,449,
  	183,0,6898,6899,5,406,0,0,6899,6966,3,958,479,0,6900,6901,5,429,0,0,6901,
  	6966,3,958,479,0,6902,6903,5,457,0,0,6903,6904,5,776,0,0,6904,6905,3,
  	854,427,0,6905,6906,5,773,0,0,6906,6907,3,854,427,0,6907,6908,5,777,0,
  	0,6908,6966,1,0,0,0,6909,6910,5,458,0,0,6910,6911,5,776,0,0,6911,6912,
  	3,854,427,0,6912,6913,5,773,0,0,6913,6914,3,854,427,0,6914,6915,5,773,
  	0,0,6915,6916,3,854,427,0,6916,6917,5,777,0,0,6917,6966,1,0,0,0,6918,
  	6919,5,476,0,0,6919,6966,3,958,479,0,6920,6921,5,485,0,0,6921,6966,3,
  	1406,703,0,6922,6923,5,597,0,0,6923,6924,5,776,0,0,6924,6925,3,854,427,
  	0,6925,6926,5,773,0,0,6926,6927,3,854,427,0,6927,6928,5,777,0,0,6928,
  	6966,1,0,0,0,6929,6930,5,640,0,0,6930,6931,5,776,0,0,6931,6934,3,854,
  	427,0,6932,6933,5,773,0,0,6933,6935,3,854,427,0,6934,6932,1,0,0,0,6934,
  	6935,1,0,0,0,6935,6936,1,0,0,0,6936,6937,5,777,0,0,6937,6966,1,0,0,0,
  	6938,6939,5,641,0,0,6939,6940,5,776,0,0,6940,6960,3,854,427,0,6941,6942,
  	5,17,0,0,6942,6943,5,60,0,0,6943,6945,3,1124,562,0,6944,6941,1,0,0,0,
  	6944,6945,1,0,0,0,6945,6948,1,0,0,0,6946,6947,4,449,184,0,6947,6949,3,
  	908,454,0,6948,6946,1,0,0,0,6948,6949,1,0,0,0,6949,6961,1,0,0,0,6950,
  	6951,5,17,0,0,6951,6952,5,32,0,0,6952,6961,3,1124,562,0,6953,6954,5,773,
  	0,0,6954,6955,3,1350,675,0,6955,6956,5,773,0,0,6956,6957,3,1350,675,0,
  	6957,6958,5,773,0,0,6958,6959,3,1350,675,0,6959,6961,1,0,0,0,6960,6944,
  	1,0,0,0,6960,6950,1,0,0,0,6960,6953,1,0,0,0,6961,6962,1,0,0,0,6962,6963,
  	5,777,0,0,6963,6966,1,0,0,0,6964,6966,3,902,451,0,6965,6687,1,0,0,0,6965,
  	6696,1,0,0,0,6965,6700,1,0,0,0,6965,6702,1,0,0,0,6965,6704,1,0,0,0,6965,
  	6706,1,0,0,0,6965,6717,1,0,0,0,6965,6728,1,0,0,0,6965,6740,1,0,0,0,6965,
  	6747,1,0,0,0,6965,6749,1,0,0,0,6965,6751,1,0,0,0,6965,6758,1,0,0,0,6965,
  	6760,1,0,0,0,6965,6762,1,0,0,0,6965,6771,1,0,0,0,6965,6772,1,0,0,0,6965,
  	6773,1,0,0,0,6965,6775,1,0,0,0,6965,6777,1,0,0,0,6965,6790,1,0,0,0,6965,
  	6794,1,0,0,0,6965,6798,1,0,0,0,6965,6807,1,0,0,0,6965,6814,1,0,0,0,6965,
  	6821,1,0,0,0,6965,6825,1,0,0,0,6965,6832,1,0,0,0,6965,6833,1,0,0,0,6965,
  	6837,1,0,0,0,6965,6846,1,0,0,0,6965,6850,1,0,0,0,6965,6854,1,0,0,0,6965,
  	6858,1,0,0,0,6965,6860,1,0,0,0,6965,6862,1,0,0,0,6965,6864,1,0,0,0,6965,
  	6866,1,0,0,0,6965,6868,1,0,0,0,6965,6877,1,0,0,0,6965,6888,1,0,0,0,6965,
  	6890,1,0,0,0,6965,6897,1,0,0,0,6965,6900,1,0,0,0,6965,6902,1,0,0,0,6965,
  	6909,1,0,0,0,6965,6918,1,0,0,0,6965,6920,1,0,0,0,6965,6922,1,0,0,0,6965,
  	6929,1,0,0,0,6965,6938,1,0,0,0,6965,6964,1,0,0,0,6966,899,1,0,0,0,6967,
  	6968,5,793,0,0,6968,6969,3,942,471,0,6969,901,1,0,0,0,6970,6971,4,451,
  	185,0,6971,6972,5,90,0,0,6972,6973,5,776,0,0,6973,6974,3,854,427,0,6974,
  	6975,5,773,0,0,6975,6976,3,854,427,0,6976,6977,5,777,0,0,6977,7002,1,
  	0,0,0,6978,6979,5,211,0,0,6979,6981,5,776,0,0,6980,6982,3,944,472,0,6981,
  	6980,1,0,0,0,6981,6982,1,0,0,0,6982,6983,1,0,0,0,6983,7002,5,777,0,0,
  	6984,6985,5,279,0,0,6985,7002,3,956,478,0,6986,6987,5,351,0,0,6987,7002,
  	3,956,478,0,6988,6989,5,352,0,0,6989,7002,3,956,478,0,6990,6991,5,353,
  	0,0,6991,7002,3,956,478,0,6992,6993,5,411,0,0,6993,6994,5,776,0,0,6994,
  	6995,3,854,427,0,6995,6996,5,773,0,0,6996,6997,3,854,427,0,6997,6998,
  	5,777,0,0,6998,7002,1,0,0,0,6999,7000,5,412,0,0,7000,7002,3,956,478,0,
  	7001,6970,1,0,0,0,7001,6978,1,0,0,0,7001,6984,1,0,0,0,7001,6986,1,0,0,
  	0,7001,6988,1,0,0,0,7001,6990,1,0,0,0,7001,6992,1,0,0,0,7001,6999,1,0,
  	0,0,7002,903,1,0,0,0,7003,7005,5,776,0,0,7004,7006,3,906,453,0,7005,7004,
  	1,0,0,0,7005,7006,1,0,0,0,7006,7007,1,0,0,0,7007,7008,5,777,0,0,7008,
  	905,1,0,0,0,7009,7010,5,747,0,0,7010,907,1,0,0,0,7011,7024,5,274,0,0,
  	7012,7013,3,1352,676,0,7013,7014,5,759,0,0,7014,7015,3,1352,676,0,7015,
  	7025,1,0,0,0,7016,7021,3,910,455,0,7017,7018,5,773,0,0,7018,7020,3,910,
  	455,0,7019,7017,1,0,0,0,7020,7023,1,0,0,0,7021,7019,1,0,0,0,7021,7022,
  	1,0,0,0,7022,7025,1,0,0,0,7023,7021,1,0,0,0,7024,7012,1,0,0,0,7024,7016,
  	1,0,0,0,7025,909,1,0,0,0,7026,7032,3,1352,676,0,7027,7029,7,32,0,0,7028,
  	7030,5,476,0,0,7029,7028,1,0,0,0,7029,7030,1,0,0,0,7030,7033,1,0,0,0,
  	7031,7033,5,476,0,0,7032,7027,1,0,0,0,7032,7031,1,0,0,0,7032,7033,1,0,
  	0,0,7033,911,1,0,0,0,7034,7035,7,115,0,0,7035,913,1,0,0,0,7036,7037,5,
  	595,0,0,7037,7061,5,776,0,0,7038,7041,3,854,427,0,7039,7040,5,203,0,0,
  	7040,7042,3,854,427,0,7041,7039,1,0,0,0,7041,7042,1,0,0,0,7042,7062,1,
  	0,0,0,7043,7045,5,269,0,0,7044,7046,3,854,427,0,7045,7044,1,0,0,0,7045,
  	7046,1,0,0,0,7046,7047,1,0,0,0,7047,7048,5,203,0,0,7048,7062,3,854,427,
  	0,7049,7051,5,591,0,0,7050,7052,3,854,427,0,7051,7050,1,0,0,0,7051,7052,
  	1,0,0,0,7052,7053,1,0,0,0,7053,7054,5,203,0,0,7054,7062,3,854,427,0,7055,
  	7057,5,43,0,0,7056,7058,3,854,427,0,7057,7056,1,0,0,0,7057,7058,1,0,0,
  	0,7058,7059,1,0,0,0,7059,7060,5,203,0,0,7060,7062,3,854,427,0,7061,7038,
  	1,0,0,0,7061,7043,1,0,0,0,7061,7049,1,0,0,0,7061,7055,1,0,0,0,7062,7063,
  	1,0,0,0,7063,7064,5,777,0,0,7064,915,1,0,0,0,7065,7066,5,563,0,0,7066,
  	7067,5,776,0,0,7067,7080,3,854,427,0,7068,7069,5,773,0,0,7069,7072,3,
  	854,427,0,7070,7071,5,773,0,0,7071,7073,3,854,427,0,7072,7070,1,0,0,0,
  	7072,7073,1,0,0,0,7073,7081,1,0,0,0,7074,7075,5,203,0,0,7075,7078,3,854,
  	427,0,7076,7077,5,200,0,0,7077,7079,3,854,427,0,7078,7076,1,0,0,0,7078,
  	7079,1,0,0,0,7079,7081,1,0,0,0,7080,7068,1,0,0,0,7080,7074,1,0,0,0,7081,
  	7082,1,0,0,0,7082,7083,5,777,0,0,7083,917,1,0,0,0,7084,7085,3,1336,668,
  	0,7085,7087,5,776,0,0,7086,7088,3,920,460,0,7087,7086,1,0,0,0,7087,7088,
  	1,0,0,0,7088,7089,1,0,0,0,7089,7090,5,777,0,0,7090,7099,1,0,0,0,7091,
  	7092,3,1344,672,0,7092,7094,5,776,0,0,7093,7095,3,944,472,0,7094,7093,
  	1,0,0,0,7094,7095,1,0,0,0,7095,7096,1,0,0,0,7096,7097,5,777,0,0,7097,
  	7099,1,0,0,0,7098,7084,1,0,0,0,7098,7091,1,0,0,0,7099,919,1,0,0,0,7100,
  	7105,3,922,461,0,7101,7102,5,773,0,0,7102,7104,3,922,461,0,7103,7101,
  	1,0,0,0,7104,7107,1,0,0,0,7105,7103,1,0,0,0,7105,7106,1,0,0,0,7106,921,
  	1,0,0,0,7107,7105,1,0,0,0,7108,7110,3,854,427,0,7109,7111,3,362,181,0,
  	7110,7109,1,0,0,0,7110,7111,1,0,0,0,7111,923,1,0,0,0,7112,7113,5,783,
  	0,0,7113,7114,3,926,463,0,7114,925,1,0,0,0,7115,7118,3,1398,699,0,7116,
  	7118,5,858,0,0,7117,7115,1,0,0,0,7117,7116,1,0,0,0,7118,927,1,0,0,0,7119,
  	7120,3,924,462,0,7120,7121,5,751,0,0,7121,7122,3,854,427,0,7122,929,1,
  	0,0,0,7123,7131,3,924,462,0,7124,7125,5,783,0,0,7125,7127,5,783,0,0,7126,
  	7128,3,1412,706,0,7127,7126,1,0,0,0,7127,7128,1,0,0,0,7128,7129,1,0,0,
  	0,7129,7131,3,934,467,0,7130,7123,1,0,0,0,7130,7124,1,0,0,0,7131,931,
  	1,0,0,0,7132,7133,4,466,186,0,7133,7135,3,1338,669,0,7134,7136,3,1348,
  	674,0,7135,7134,1,0,0,0,7135,7136,1,0,0,0,7136,7143,1,0,0,0,7137,7138,
  	4,466,187,0,7138,7140,3,1400,700,0,7139,7141,3,1348,674,0,7140,7139,1,
  	0,0,0,7140,7141,1,0,0,0,7141,7143,1,0,0,0,7142,7132,1,0,0,0,7142,7137,
  	1,0,0,0,7143,7147,1,0,0,0,7144,7145,5,128,0,0,7145,7147,3,1348,674,0,
  	7146,7142,1,0,0,0,7146,7144,1,0,0,0,7147,933,1,0,0,0,7148,7150,3,1398,
  	699,0,7149,7151,3,1348,674,0,7150,7149,1,0,0,0,7150,7151,1,0,0,0,7151,
  	935,1,0,0,0,7152,7153,5,642,0,0,7153,7154,3,854,427,0,7154,937,1,0,0,
  	0,7155,7156,5,582,0,0,7156,7157,3,854,427,0,7157,939,1,0,0,0,7158,7159,
  	5,154,0,0,7159,7160,3,854,427,0,7160,941,1,0,0,0,7161,7163,5,32,0,0,7162,
  	7164,3,1114,557,0,7163,7162,1,0,0,0,7163,7164,1,0,0,0,7164,7211,1,0,0,
  	0,7165,7167,5,60,0,0,7166,7168,3,1114,557,0,7167,7166,1,0,0,0,7167,7168,
  	1,0,0,0,7168,7170,1,0,0,0,7169,7171,3,1118,559,0,7170,7169,1,0,0,0,7170,
  	7171,1,0,0,0,7171,7211,1,0,0,0,7172,7174,3,1110,555,0,7173,7175,3,1114,
  	557,0,7174,7173,1,0,0,0,7174,7175,1,0,0,0,7175,7211,1,0,0,0,7176,7178,
  	5,512,0,0,7177,7179,5,249,0,0,7178,7177,1,0,0,0,7178,7179,1,0,0,0,7179,
  	7211,1,0,0,0,7180,7182,5,612,0,0,7181,7183,5,249,0,0,7182,7181,1,0,0,
  	0,7182,7183,1,0,0,0,7183,7211,1,0,0,0,7184,7211,5,116,0,0,7185,7186,4,
  	471,188,0,7186,7211,5,656,0,0,7187,7189,5,586,0,0,7188,7190,3,1126,563,
  	0,7189,7188,1,0,0,0,7189,7190,1,0,0,0,7190,7211,1,0,0,0,7191,7193,5,113,
  	0,0,7192,7194,3,1126,563,0,7193,7192,1,0,0,0,7193,7194,1,0,0,0,7194,7211,
  	1,0,0,0,7195,7197,5,126,0,0,7196,7198,3,1392,696,0,7197,7196,1,0,0,0,
  	7197,7198,1,0,0,0,7198,7211,1,0,0,0,7199,7200,4,471,189,0,7200,7211,5,
  	262,0,0,7201,7202,4,471,190,0,7202,7211,3,1112,556,0,7203,7204,4,471,
  	191,0,7204,7206,5,195,0,0,7205,7207,3,1394,697,0,7206,7205,1,0,0,0,7206,
  	7207,1,0,0,0,7207,7211,1,0,0,0,7208,7209,4,471,192,0,7209,7211,7,116,
  	0,0,7210,7161,1,0,0,0,7210,7165,1,0,0,0,7210,7172,1,0,0,0,7210,7176,1,
  	0,0,0,7210,7180,1,0,0,0,7210,7184,1,0,0,0,7210,7185,1,0,0,0,7210,7187,
  	1,0,0,0,7210,7191,1,0,0,0,7210,7195,1,0,0,0,7210,7199,1,0,0,0,7210,7201,
  	1,0,0,0,7210,7203,1,0,0,0,7210,7208,1,0,0,0,7211,943,1,0,0,0,7212,7217,
  	3,854,427,0,7213,7214,5,773,0,0,7214,7216,3,854,427,0,7215,7213,1,0,0,
  	0,7216,7219,1,0,0,0,7217,7215,1,0,0,0,7217,7218,1,0,0,0,7218,945,1,0,
  	0,0,7219,7217,1,0,0,0,7220,7221,5,60,0,0,7221,7224,5,506,0,0,7222,7224,
  	5,58,0,0,7223,7220,1,0,0,0,7223,7222,1,0,0,0,7224,947,1,0,0,0,7225,7226,
  	7,117,0,0,7226,949,1,0,0,0,7227,7228,7,118,0,0,7228,951,1,0,0,0,7229,
  	7232,3,954,477,0,7230,7232,7,119,0,0,7231,7229,1,0,0,0,7231,7230,1,0,
  	0,0,7232,953,1,0,0,0,7233,7234,7,120,0,0,7234,955,1,0,0,0,7235,7236,5,
  	776,0,0,7236,7237,3,944,472,0,7237,7238,5,777,0,0,7238,957,1,0,0,0,7239,
  	7240,5,776,0,0,7240,7241,3,854,427,0,7241,7242,5,777,0,0,7242,959,1,0,
  	0,0,7243,7244,5,776,0,0,7244,7245,3,866,433,0,7245,7246,5,777,0,0,7246,
  	961,1,0,0,0,7247,7252,3,964,482,0,7248,7249,5,773,0,0,7249,7251,3,964,
  	482,0,7250,7248,1,0,0,0,7251,7254,1,0,0,0,7252,7250,1,0,0,0,7252,7253,
  	1,0,0,0,7253,963,1,0,0,0,7254,7252,1,0,0,0,7255,7257,3,854,427,0,7256,
  	7258,3,336,168,0,7257,7256,1,0,0,0,7257,7258,1,0,0,0,7258,965,1,0,0,0,
  	7259,7264,3,968,484,0,7260,7261,5,773,0,0,7261,7263,3,968,484,0,7262,
  	7260,1,0,0,0,7263,7266,1,0,0,0,7264,7262,1,0,0,0,7264,7265,1,0,0,0,7265,
  	967,1,0,0,0,7266,7264,1,0,0,0,7267,7268,3,854,427,0,7268,969,1,0,0,0,
  	7269,7270,4,485,193,0,7270,7271,5,200,0,0,7271,7272,5,57,0,0,7272,7273,
  	3,1378,689,0,7273,971,1,0,0,0,7274,7288,3,2,1,0,7275,7288,3,974,487,0,
  	7276,7288,3,976,488,0,7277,7288,3,984,492,0,7278,7288,3,988,494,0,7279,
  	7288,3,990,495,0,7280,7288,3,996,498,0,7281,7288,3,998,499,0,7282,7288,
  	3,1026,513,0,7283,7288,3,1024,512,0,7284,7288,3,1044,522,0,7285,7288,
  	3,1048,524,0,7286,7288,3,1046,523,0,7287,7274,1,0,0,0,7287,7275,1,0,0,
  	0,7287,7276,1,0,0,0,7287,7277,1,0,0,0,7287,7278,1,0,0,0,7287,7279,1,0,
  	0,0,7287,7280,1,0,0,0,7287,7281,1,0,0,0,7287,7282,1,0,0,0,7287,7283,1,
  	0,0,0,7287,7284,1,0,0,0,7287,7285,1,0,0,0,7287,7286,1,0,0,0,7288,973,
  	1,0,0,0,7289,7290,5,475,0,0,7290,7291,3,854,427,0,7291,975,1,0,0,0,7292,
  	7293,5,231,0,0,7293,7294,3,978,489,0,7294,7295,5,159,0,0,7295,7296,5,
  	231,0,0,7296,977,1,0,0,0,7297,7298,3,854,427,0,7298,7303,3,980,490,0,
  	7299,7300,5,155,0,0,7300,7304,3,978,489,0,7301,7302,5,154,0,0,7302,7304,
  	3,982,491,0,7303,7299,1,0,0,0,7303,7301,1,0,0,0,7303,7304,1,0,0,0,7304,
  	979,1,0,0,0,7305,7306,5,582,0,0,7306,7307,3,982,491,0,7307,981,1,0,0,
  	0,7308,7309,3,972,486,0,7309,7310,5,774,0,0,7310,7312,1,0,0,0,7311,7308,
  	1,0,0,0,7312,7313,1,0,0,0,7313,7311,1,0,0,0,7313,7314,1,0,0,0,7314,983,
  	1,0,0,0,7315,7317,5,51,0,0,7316,7318,3,854,427,0,7317,7316,1,0,0,0,7317,
  	7318,1,0,0,0,7318,7322,1,0,0,0,7319,7320,3,936,468,0,7320,7321,3,980,
  	490,0,7321,7323,1,0,0,0,7322,7319,1,0,0,0,7323,7324,1,0,0,0,7324,7322,
  	1,0,0,0,7324,7325,1,0,0,0,7325,7327,1,0,0,0,7326,7328,3,986,493,0,7327,
  	7326,1,0,0,0,7327,7328,1,0,0,0,7328,7329,1,0,0,0,7329,7330,5,159,0,0,
  	7330,7331,5,51,0,0,7331,985,1,0,0,0,7332,7333,5,154,0,0,7333,7334,3,982,
  	491,0,7334,987,1,0,0,0,7335,7336,3,992,496,0,7336,7338,3,994,497,0,7337,
  	7339,3,1324,662,0,7338,7337,1,0,0,0,7338,7339,1,0,0,0,7339,989,1,0,0,
  	0,7340,7341,3,994,497,0,7341,991,1,0,0,0,7342,7343,3,1322,661,0,7343,
  	7344,5,775,0,0,7344,993,1,0,0,0,7345,7347,5,29,0,0,7346,7348,3,1006,503,
  	0,7347,7346,1,0,0,0,7347,7348,1,0,0,0,7348,7350,1,0,0,0,7349,7351,3,982,
  	491,0,7350,7349,1,0,0,0,7350,7351,1,0,0,0,7351,7352,1,0,0,0,7352,7353,
  	5,159,0,0,7353,995,1,0,0,0,7354,7355,3,992,496,0,7355,7357,3,998,499,
  	0,7356,7358,3,1324,662,0,7357,7356,1,0,0,0,7357,7358,1,0,0,0,7358,997,
  	1,0,0,0,7359,7363,3,1000,500,0,7360,7363,3,1002,501,0,7361,7363,3,1004,
  	502,0,7362,7359,1,0,0,0,7362,7360,1,0,0,0,7362,7361,1,0,0,0,7363,999,
  	1,0,0,0,7364,7365,5,294,0,0,7365,7366,3,982,491,0,7366,7367,5,159,0,0,
  	7367,7368,5,294,0,0,7368,1001,1,0,0,0,7369,7370,5,644,0,0,7370,7371,3,
  	854,427,0,7371,7372,5,147,0,0,7372,7373,3,982,491,0,7373,7374,5,159,0,
  	0,7374,7375,5,644,0,0,7375,1003,1,0,0,0,7376,7377,5,457,0,0,7377,7378,
  	3,982,491,0,7378,7379,5,613,0,0,7379,7380,3,854,427,0,7380,7381,5,159,
  	0,0,7381,7382,5,457,0,0,7382,1005,1,0,0,0,7383,7384,3,1008,504,0,7384,
  	7385,5,774,0,0,7385,7387,1,0,0,0,7386,7383,1,0,0,0,7387,7388,1,0,0,0,
  	7388,7386,1,0,0,0,7388,7389,1,0,0,0,7389,1007,1,0,0,0,7390,7395,3,1010,
  	505,0,7391,7395,3,1012,506,0,7392,7395,3,1018,509,0,7393,7395,3,1022,
  	511,0,7394,7390,1,0,0,0,7394,7391,1,0,0,0,7394,7392,1,0,0,0,7394,7393,
  	1,0,0,0,7395,1009,1,0,0,0,7396,7397,5,127,0,0,7397,7398,3,1340,670,0,
  	7398,7400,3,1108,554,0,7399,7401,3,1180,590,0,7400,7399,1,0,0,0,7400,
  	7401,1,0,0,0,7401,7404,1,0,0,0,7402,7403,5,128,0,0,7403,7405,3,854,427,
  	0,7404,7402,1,0,0,0,7404,7405,1,0,0,0,7405,1011,1,0,0,0,7406,7407,5,127,
  	0,0,7407,7408,3,1338,669,0,7408,7409,5,83,0,0,7409,7410,5,200,0,0,7410,
  	7411,3,1014,507,0,7411,1013,1,0,0,0,7412,7415,3,1350,675,0,7413,7415,
  	3,1016,508,0,7414,7412,1,0,0,0,7414,7413,1,0,0,0,7415,1015,1,0,0,0,7416,
  	7418,5,526,0,0,7417,7419,5,627,0,0,7418,7417,1,0,0,0,7418,7419,1,0,0,
  	0,7419,7420,1,0,0,0,7420,7421,3,1376,688,0,7421,1017,1,0,0,0,7422,7423,
  	5,127,0,0,7423,7424,7,121,0,0,7424,7425,5,219,0,0,7425,7426,5,200,0,0,
  	7426,7431,3,1020,510,0,7427,7428,5,773,0,0,7428,7430,3,1020,510,0,7429,
  	7427,1,0,0,0,7430,7433,1,0,0,0,7431,7429,1,0,0,0,7431,7432,1,0,0,0,7432,
  	7434,1,0,0,0,7433,7431,1,0,0,0,7434,7435,3,972,486,0,7435,1019,1,0,0,
  	0,7436,7444,3,1014,507,0,7437,7444,3,1338,669,0,7438,7444,5,527,0,0,7439,
  	7440,3,948,474,0,7440,7441,5,202,0,0,7441,7444,1,0,0,0,7442,7444,5,525,
  	0,0,7443,7436,1,0,0,0,7443,7437,1,0,0,0,7443,7438,1,0,0,0,7443,7439,1,
  	0,0,0,7443,7442,1,0,0,0,7444,1021,1,0,0,0,7445,7446,5,127,0,0,7446,7447,
  	3,1338,669,0,7447,7448,5,106,0,0,7448,7449,5,200,0,0,7449,7450,3,272,
  	136,0,7450,1023,1,0,0,0,7451,7452,5,260,0,0,7452,7453,3,1324,662,0,7453,
  	1025,1,0,0,0,7454,7455,5,271,0,0,7455,7456,3,1324,662,0,7456,1027,1,0,
  	0,0,7457,7459,5,207,0,0,7458,7460,7,122,0,0,7459,7458,1,0,0,0,7459,7460,
  	1,0,0,0,7460,7461,1,0,0,0,7461,7480,5,138,0,0,7462,7467,3,1032,516,0,
  	7463,7464,5,773,0,0,7464,7466,3,1032,516,0,7465,7463,1,0,0,0,7466,7469,
  	1,0,0,0,7467,7465,1,0,0,0,7467,7468,1,0,0,0,7468,7481,1,0,0,0,7469,7467,
  	1,0,0,0,7470,7471,5,83,0,0,7471,7472,3,1030,515,0,7472,7477,3,1034,517,
  	0,7473,7474,5,773,0,0,7474,7476,3,1034,517,0,7475,7473,1,0,0,0,7476,7479,
  	1,0,0,0,7477,7475,1,0,0,0,7477,7478,1,0,0,0,7478,7481,1,0,0,0,7479,7477,
  	1,0,0,0,7480,7462,1,0,0,0,7480,7470,1,0,0,0,7481,1029,1,0,0,0,7482,7486,
  	3,1362,681,0,7483,7486,3,930,465,0,7484,7486,3,1344,672,0,7485,7482,1,
  	0,0,0,7485,7483,1,0,0,0,7485,7484,1,0,0,0,7486,1031,1,0,0,0,7487,7490,
  	3,924,462,0,7488,7490,3,1338,669,0,7489,7487,1,0,0,0,7489,7488,1,0,0,
  	0,7490,7491,1,0,0,0,7491,7492,5,750,0,0,7492,7493,7,123,0,0,7493,1033,
  	1,0,0,0,7494,7497,3,924,462,0,7495,7497,3,1338,669,0,7496,7494,1,0,0,
  	0,7496,7495,1,0,0,0,7497,7498,1,0,0,0,7498,7501,5,750,0,0,7499,7502,3,
  	1036,518,0,7500,7502,5,473,0,0,7501,7499,1,0,0,0,7501,7500,1,0,0,0,7502,
  	1035,1,0,0,0,7503,7504,7,124,0,0,7504,1037,1,0,0,0,7505,7508,5,511,0,
  	0,7506,7509,3,1338,669,0,7507,7509,3,1016,508,0,7508,7506,1,0,0,0,7508,
  	7507,1,0,0,0,7509,7519,1,0,0,0,7510,7511,5,506,0,0,7511,7516,3,1042,521,
  	0,7512,7513,5,773,0,0,7513,7515,3,1042,521,0,7514,7512,1,0,0,0,7515,7518,
  	1,0,0,0,7516,7514,1,0,0,0,7516,7517,1,0,0,0,7517,7520,1,0,0,0,7518,7516,
  	1,0,0,0,7519,7510,1,0,0,0,7519,7520,1,0,0,0,7520,1039,1,0,0,0,7521,7524,
  	5,469,0,0,7522,7525,3,1338,669,0,7523,7525,3,1016,508,0,7524,7522,1,0,
  	0,0,7524,7523,1,0,0,0,7524,7525,1,0,0,0,7525,7535,1,0,0,0,7526,7527,5,
  	506,0,0,7527,7532,3,1042,521,0,7528,7529,5,773,0,0,7529,7531,3,1042,521,
  	0,7530,7528,1,0,0,0,7531,7534,1,0,0,0,7532,7530,1,0,0,0,7532,7533,1,0,
  	0,0,7533,7536,1,0,0,0,7534,7532,1,0,0,0,7535,7526,1,0,0,0,7535,7536,1,
  	0,0,0,7536,1041,1,0,0,0,7537,7538,3,1036,518,0,7538,7539,5,750,0,0,7539,
  	7540,3,1030,515,0,7540,1043,1,0,0,0,7541,7542,5,387,0,0,7542,7543,3,1338,
  	669,0,7543,1045,1,0,0,0,7544,7545,5,66,0,0,7545,7546,3,1338,669,0,7546,
  	1047,1,0,0,0,7547,7552,5,186,0,0,7548,7550,5,367,0,0,7549,7548,1,0,0,
  	0,7549,7550,1,0,0,0,7550,7551,1,0,0,0,7551,7553,5,203,0,0,7552,7549,1,
  	0,0,0,7552,7553,1,0,0,0,7553,7554,1,0,0,0,7554,7555,3,1338,669,0,7555,
  	7556,5,248,0,0,7556,7557,3,1340,670,0,7557,1049,1,0,0,0,7558,7559,5,21,
  	0,0,7559,7572,3,854,427,0,7560,7561,5,171,0,0,7561,7562,3,854,427,0,7562,
  	7565,3,952,476,0,7563,7564,5,542,0,0,7564,7566,3,854,427,0,7565,7563,
  	1,0,0,0,7565,7566,1,0,0,0,7566,7569,1,0,0,0,7567,7568,5,160,0,0,7568,
  	7570,3,854,427,0,7569,7567,1,0,0,0,7569,7570,1,0,0,0,7570,7572,1,0,0,
  	0,7571,7558,1,0,0,0,7571,7560,1,0,0,0,7572,1051,1,0,0,0,7573,7574,3,1252,
  	626,0,7574,7576,3,1064,532,0,7575,7577,3,1054,527,0,7576,7575,1,0,0,0,
  	7576,7577,1,0,0,0,7577,1053,1,0,0,0,7578,7579,4,527,194,0,7579,7582,3,
  	1056,528,0,7580,7582,3,1078,539,0,7581,7578,1,0,0,0,7581,7580,1,0,0,0,
  	7582,1055,1,0,0,0,7583,7584,5,62,0,0,7584,7585,3,958,479,0,7585,1057,
  	1,0,0,0,7586,7588,5,371,0,0,7587,7586,1,0,0,0,7587,7588,1,0,0,0,7588,
  	7589,1,0,0,0,7589,7590,5,730,0,0,7590,1059,1,0,0,0,7591,7593,7,37,0,0,
  	7592,7594,3,112,56,0,7593,7592,1,0,0,0,7593,7594,1,0,0,0,7594,7595,1,
  	0,0,0,7595,7599,3,1090,545,0,7596,7598,3,1094,547,0,7597,7596,1,0,0,0,
  	7598,7601,1,0,0,0,7599,7597,1,0,0,0,7599,7600,1,0,0,0,7600,7667,1,0,0,
  	0,7601,7599,1,0,0,0,7602,7604,5,205,0,0,7603,7605,3,414,207,0,7604,7603,
  	1,0,0,0,7604,7605,1,0,0,0,7605,7607,1,0,0,0,7606,7608,3,1262,631,0,7607,
  	7606,1,0,0,0,7607,7608,1,0,0,0,7608,7609,1,0,0,0,7609,7613,3,1090,545,
  	0,7610,7612,3,1102,551,0,7611,7610,1,0,0,0,7612,7615,1,0,0,0,7613,7611,
  	1,0,0,0,7613,7614,1,0,0,0,7614,7667,1,0,0,0,7615,7613,1,0,0,0,7616,7618,
  	5,523,0,0,7617,7619,3,414,207,0,7618,7617,1,0,0,0,7618,7619,1,0,0,0,7619,
  	7621,1,0,0,0,7620,7622,3,1262,631,0,7621,7620,1,0,0,0,7621,7622,1,0,0,
  	0,7622,7623,1,0,0,0,7623,7627,3,1090,545,0,7624,7626,3,1104,552,0,7625,
  	7624,1,0,0,0,7626,7629,1,0,0,0,7627,7625,1,0,0,0,7627,7628,1,0,0,0,7628,
  	7667,1,0,0,0,7629,7627,1,0,0,0,7630,7632,3,1062,531,0,7631,7630,1,0,0,
  	0,7631,7632,1,0,0,0,7632,7664,1,0,0,0,7633,7634,5,420,0,0,7634,7640,5,
  	265,0,0,7635,7637,5,609,0,0,7636,7638,3,414,207,0,7637,7636,1,0,0,0,7637,
  	7638,1,0,0,0,7638,7640,1,0,0,0,7639,7633,1,0,0,0,7639,7635,1,0,0,0,7640,
  	7642,1,0,0,0,7641,7643,3,112,56,0,7642,7641,1,0,0,0,7642,7643,1,0,0,0,
  	7643,7644,1,0,0,0,7644,7648,3,1090,545,0,7645,7647,3,1094,547,0,7646,
  	7645,1,0,0,0,7647,7650,1,0,0,0,7648,7646,1,0,0,0,7648,7649,1,0,0,0,7649,
  	7665,1,0,0,0,7650,7648,1,0,0,0,7651,7652,5,199,0,0,7652,7654,5,265,0,
  	0,7653,7655,3,1262,631,0,7654,7653,1,0,0,0,7654,7655,1,0,0,0,7655,7656,
  	1,0,0,0,7656,7657,3,1082,541,0,7657,7658,3,1078,539,0,7658,7665,1,0,0,
  	0,7659,7662,3,1056,528,0,7660,7661,4,530,195,0,7661,7663,3,1058,529,0,
  	7662,7660,1,0,0,0,7662,7663,1,0,0,0,7663,7665,1,0,0,0,7664,7639,1,0,0,
  	0,7664,7651,1,0,0,0,7664,7659,1,0,0,0,7665,7667,1,0,0,0,7666,7591,1,0,
  	0,0,7666,7602,1,0,0,0,7666,7616,1,0,0,0,7666,7631,1,0,0,0,7667,1061,1,
  	0,0,0,7668,7670,5,86,0,0,7669,7671,3,1338,669,0,7670,7669,1,0,0,0,7670,
  	7671,1,0,0,0,7671,1063,1,0,0,0,7672,7708,3,1108,554,0,7673,7675,3,1066,
  	533,0,7674,7673,1,0,0,0,7675,7678,1,0,0,0,7676,7674,1,0,0,0,7676,7677,
  	1,0,0,0,7677,7709,1,0,0,0,7678,7676,1,0,0,0,7679,7681,4,532,196,0,7680,
  	7682,3,1180,590,0,7681,7680,1,0,0,0,7681,7682,1,0,0,0,7682,7685,1,0,0,
  	0,7683,7684,5,209,0,0,7684,7686,5,12,0,0,7685,7683,1,0,0,0,7685,7686,
  	1,0,0,0,7686,7687,1,0,0,0,7687,7688,5,17,0,0,7688,7690,3,958,479,0,7689,
  	7691,7,125,0,0,7690,7689,1,0,0,0,7690,7691,1,0,0,0,7691,7706,1,0,0,0,
  	7692,7696,4,532,197,0,7693,7695,3,1076,538,0,7694,7693,1,0,0,0,7695,7698,
  	1,0,0,0,7696,7694,1,0,0,0,7696,7697,1,0,0,0,7697,7707,1,0,0,0,7698,7696,
  	1,0,0,0,7699,7703,4,532,198,0,7700,7702,3,1066,533,0,7701,7700,1,0,0,
  	0,7702,7705,1,0,0,0,7703,7701,1,0,0,0,7703,7704,1,0,0,0,7704,7707,1,0,
  	0,0,7705,7703,1,0,0,0,7706,7692,1,0,0,0,7706,7699,1,0,0,0,7707,7709,1,
  	0,0,0,7708,7676,1,0,0,0,7708,7679,1,0,0,0,7709,1065,1,0,0,0,7710,7712,
  	5,371,0,0,7711,7710,1,0,0,0,7711,7712,1,0,0,0,7712,7713,1,0,0,0,7713,
  	7780,3,1386,693,0,7714,7715,4,533,199,0,7715,7716,5,371,0,0,7716,7780,
  	5,720,0,0,7717,7728,5,128,0,0,7718,7719,4,533,200,0,7719,7729,3,1358,
  	679,0,7720,7721,4,533,201,0,7721,7729,3,1074,537,0,7722,7724,5,372,0,
  	0,7723,7725,3,904,452,0,7724,7723,1,0,0,0,7724,7725,1,0,0,0,7725,7729,
  	1,0,0,0,7726,7727,4,533,202,0,7727,7729,3,958,479,0,7728,7718,1,0,0,0,
  	7728,7720,1,0,0,0,7728,7722,1,0,0,0,7728,7726,1,0,0,0,7729,7780,1,0,0,
  	0,7730,7731,5,383,0,0,7731,7732,5,614,0,0,7732,7734,5,372,0,0,7733,7735,
  	3,904,452,0,7734,7733,1,0,0,0,7734,7735,1,0,0,0,7735,7780,1,0,0,0,7736,
  	7780,5,24,0,0,7737,7738,5,501,0,0,7738,7739,5,128,0,0,7739,7780,5,627,
  	0,0,7740,7742,5,420,0,0,7741,7740,1,0,0,0,7741,7742,1,0,0,0,7742,7743,
  	1,0,0,0,7743,7780,5,265,0,0,7744,7746,5,609,0,0,7745,7747,5,265,0,0,7746,
  	7745,1,0,0,0,7746,7747,1,0,0,0,7747,7780,1,0,0,0,7748,7749,5,75,0,0,7749,
  	7780,3,1376,688,0,7750,7780,3,1180,590,0,7751,7752,5,74,0,0,7752,7780,
  	3,1068,534,0,7753,7754,5,553,0,0,7754,7780,3,1070,535,0,7755,7756,4,533,
  	203,0,7756,7757,5,707,0,0,7757,7780,3,1356,678,0,7758,7760,4,533,204,
  	0,7759,7761,3,1062,531,0,7760,7759,1,0,0,0,7760,7761,1,0,0,0,7761,7762,
  	1,0,0,0,7762,7780,3,1056,528,0,7763,7764,4,533,205,0,7764,7780,3,1058,
  	529,0,7765,7766,4,533,206,0,7766,7768,5,797,0,0,7767,7769,5,750,0,0,7768,
  	7767,1,0,0,0,7768,7769,1,0,0,0,7769,7770,1,0,0,0,7770,7780,3,1416,708,
  	0,7771,7772,4,533,207,0,7772,7774,5,798,0,0,7773,7775,5,750,0,0,7774,
  	7773,1,0,0,0,7774,7775,1,0,0,0,7775,7776,1,0,0,0,7776,7780,3,1416,708,
  	0,7777,7778,4,533,208,0,7778,7780,3,1098,549,0,7779,7711,1,0,0,0,7779,
  	7714,1,0,0,0,7779,7717,1,0,0,0,7779,7730,1,0,0,0,7779,7736,1,0,0,0,7779,
  	7737,1,0,0,0,7779,7741,1,0,0,0,7779,7744,1,0,0,0,7779,7748,1,0,0,0,7779,
  	7750,1,0,0,0,7779,7751,1,0,0,0,7779,7753,1,0,0,0,7779,7755,1,0,0,0,7779,
  	7758,1,0,0,0,7779,7763,1,0,0,0,7779,7765,1,0,0,0,7779,7771,1,0,0,0,7779,
  	7777,1,0,0,0,7780,1067,1,0,0,0,7781,7782,7,126,0,0,7782,1069,1,0,0,0,
  	7783,7784,7,127,0,0,7784,1071,1,0,0,0,7785,7786,5,372,0,0,7786,7787,3,
  	1128,564,0,7787,1073,1,0,0,0,7788,7791,3,1072,536,0,7789,7791,3,1360,
  	680,0,7790,7788,1,0,0,0,7790,7789,1,0,0,0,7791,1075,1,0,0,0,7792,7794,
  	5,609,0,0,7793,7795,5,265,0,0,7794,7793,1,0,0,0,7794,7795,1,0,0,0,7795,
  	7807,1,0,0,0,7796,7797,5,75,0,0,7797,7807,3,1372,686,0,7798,7800,3,948,
  	474,0,7799,7798,1,0,0,0,7799,7800,1,0,0,0,7800,7801,1,0,0,0,7801,7807,
  	5,376,0,0,7802,7804,5,420,0,0,7803,7802,1,0,0,0,7803,7804,1,0,0,0,7804,
  	7805,1,0,0,0,7805,7807,5,265,0,0,7806,7792,1,0,0,0,7806,7796,1,0,0,0,
  	7806,7799,1,0,0,0,7806,7803,1,0,0,0,7807,1077,1,0,0,0,7808,7809,5,443,
  	0,0,7809,7811,3,1314,657,0,7810,7812,3,1342,671,0,7811,7810,1,0,0,0,7811,
  	7812,1,0,0,0,7812,7815,1,0,0,0,7813,7814,5,320,0,0,7814,7816,7,128,0,
  	0,7815,7813,1,0,0,0,7815,7816,1,0,0,0,7816,7833,1,0,0,0,7817,7818,5,383,
  	0,0,7818,7819,5,614,0,0,7819,7823,3,1080,540,0,7820,7821,5,383,0,0,7821,
  	7822,5,133,0,0,7822,7824,3,1080,540,0,7823,7820,1,0,0,0,7823,7824,1,0,
  	0,0,7824,7834,1,0,0,0,7825,7826,5,383,0,0,7826,7827,5,133,0,0,7827,7831,
  	3,1080,540,0,7828,7829,5,383,0,0,7829,7830,5,614,0,0,7830,7832,3,1080,
  	540,0,7831,7828,1,0,0,0,7831,7832,1,0,0,0,7832,7834,1,0,0,0,7833,7817,
  	1,0,0,0,7833,7825,1,0,0,0,7833,7834,1,0,0,0,7834,1079,1,0,0,0,7835,7843,
  	7,2,0,0,7836,7837,5,506,0,0,7837,7843,3,1386,693,0,7838,7839,5,506,0,
  	0,7839,7843,5,128,0,0,7840,7841,5,373,0,0,7841,7843,5,3,0,0,7842,7835,
  	1,0,0,0,7842,7836,1,0,0,0,7842,7838,1,0,0,0,7842,7840,1,0,0,0,7843,1081,
  	1,0,0,0,7844,7845,5,776,0,0,7845,7850,3,1084,542,0,7846,7847,5,773,0,
  	0,7847,7849,3,1084,542,0,7848,7846,1,0,0,0,7849,7852,1,0,0,0,7850,7848,
  	1,0,0,0,7850,7851,1,0,0,0,7851,7853,1,0,0,0,7852,7850,1,0,0,0,7853,7854,
  	5,777,0,0,7854,1083,1,0,0,0,7855,7857,3,1338,669,0,7856,7858,3,1114,557,
  	0,7857,7856,1,0,0,0,7857,7858,1,0,0,0,7858,7860,1,0,0,0,7859,7861,3,336,
  	168,0,7860,7859,1,0,0,0,7860,7861,1,0,0,0,7861,1085,1,0,0,0,7862,7863,
  	5,776,0,0,7863,7868,3,1088,544,0,7864,7865,5,773,0,0,7865,7867,3,1088,
  	544,0,7866,7864,1,0,0,0,7867,7870,1,0,0,0,7868,7866,1,0,0,0,7868,7869,
  	1,0,0,0,7869,7871,1,0,0,0,7870,7868,1,0,0,0,7871,7872,5,777,0,0,7872,
  	1087,1,0,0,0,7873,7879,3,1084,542,0,7874,7876,3,958,479,0,7875,7877,3,
  	336,168,0,7876,7875,1,0,0,0,7876,7877,1,0,0,0,7877,7879,1,0,0,0,7878,
  	7873,1,0,0,0,7878,7874,1,0,0,0,7879,1089,1,0,0,0,7880,7881,4,545,209,
  	0,7881,7885,3,1086,543,0,7882,7883,4,545,210,0,7883,7885,3,1082,541,0,
  	7884,7880,1,0,0,0,7884,7882,1,0,0,0,7885,1091,1,0,0,0,7886,7887,7,129,
  	0,0,7887,1093,1,0,0,0,7888,7891,3,1096,548,0,7889,7891,3,1100,550,0,7890,
  	7888,1,0,0,0,7890,7889,1,0,0,0,7891,1095,1,0,0,0,7892,7894,5,264,0,0,
  	7893,7895,5,750,0,0,7894,7893,1,0,0,0,7894,7895,1,0,0,0,7895,7896,1,0,
  	0,0,7896,7914,3,1350,675,0,7897,7898,5,75,0,0,7898,7914,3,1376,688,0,
  	7899,7900,4,548,211,0,7900,7914,3,1098,549,0,7901,7902,4,548,212,0,7902,
  	7904,5,797,0,0,7903,7905,5,750,0,0,7904,7903,1,0,0,0,7904,7905,1,0,0,
  	0,7905,7906,1,0,0,0,7906,7914,3,1416,708,0,7907,7908,4,548,213,0,7908,
  	7910,5,798,0,0,7909,7911,5,750,0,0,7910,7909,1,0,0,0,7910,7911,1,0,0,
  	0,7911,7912,1,0,0,0,7912,7914,3,1416,708,0,7913,7892,1,0,0,0,7913,7897,
  	1,0,0,0,7913,7899,1,0,0,0,7913,7901,1,0,0,0,7913,7907,1,0,0,0,7914,1097,
  	1,0,0,0,7915,7916,7,130,0,0,7916,1099,1,0,0,0,7917,7918,7,131,0,0,7918,
  	7919,3,1092,546,0,7919,1101,1,0,0,0,7920,7925,3,1096,548,0,7921,7922,
  	5,645,0,0,7922,7923,5,401,0,0,7923,7925,3,1338,669,0,7924,7920,1,0,0,
  	0,7924,7921,1,0,0,0,7925,1103,1,0,0,0,7926,7927,3,1096,548,0,7927,1105,
  	1,0,0,0,7928,7929,3,1108,554,0,7929,7930,5,0,0,1,7930,1107,1,0,0,0,7931,
  	7933,7,132,0,0,7932,7934,3,1114,557,0,7933,7932,1,0,0,0,7933,7934,1,0,
  	0,0,7934,7936,1,0,0,0,7935,7937,3,1116,558,0,7936,7935,1,0,0,0,7936,7937,
  	1,0,0,0,7937,8079,1,0,0,0,7938,7944,5,437,0,0,7939,7941,5,146,0,0,7940,
  	7942,5,416,0,0,7941,7940,1,0,0,0,7941,7942,1,0,0,0,7942,7944,1,0,0,0,
  	7943,7938,1,0,0,0,7943,7939,1,0,0,0,7944,7946,1,0,0,0,7945,7947,3,1396,
  	698,0,7946,7945,1,0,0,0,7946,7947,1,0,0,0,7947,7949,1,0,0,0,7948,7950,
  	3,1116,558,0,7949,7948,1,0,0,0,7949,7950,1,0,0,0,7950,8079,1,0,0,0,7951,
  	7953,7,133,0,0,7952,7954,3,1392,696,0,7953,7952,1,0,0,0,7953,7954,1,0,
  	0,0,7954,7956,1,0,0,0,7955,7957,3,1116,558,0,7956,7955,1,0,0,0,7956,7957,
  	1,0,0,0,7957,8079,1,0,0,0,7958,7960,5,37,0,0,7959,7961,3,1114,557,0,7960,
  	7959,1,0,0,0,7960,7961,1,0,0,0,7961,8079,1,0,0,0,7962,8079,7,134,0,0,
  	7963,7965,5,60,0,0,7964,7966,3,1114,557,0,7965,7964,1,0,0,0,7965,7966,
  	1,0,0,0,7966,7968,1,0,0,0,7967,7969,3,1118,559,0,7968,7967,1,0,0,0,7968,
  	7969,1,0,0,0,7969,8079,1,0,0,0,7970,7972,3,1110,555,0,7971,7973,3,1114,
  	557,0,7972,7971,1,0,0,0,7972,7973,1,0,0,0,7973,7975,1,0,0,0,7974,7976,
  	5,32,0,0,7975,7974,1,0,0,0,7975,7976,1,0,0,0,7976,8079,1,0,0,0,7977,7979,
  	5,32,0,0,7978,7980,3,1114,557,0,7979,7978,1,0,0,0,7979,7980,1,0,0,0,7980,
  	8079,1,0,0,0,7981,7982,5,60,0,0,7982,7985,5,633,0,0,7983,7985,5,629,0,
  	0,7984,7981,1,0,0,0,7984,7983,1,0,0,0,7985,7986,1,0,0,0,7986,7988,3,1114,
  	557,0,7987,7989,3,1118,559,0,7988,7987,1,0,0,0,7988,7989,1,0,0,0,7989,
  	8079,1,0,0,0,7990,7991,5,358,0,0,7991,8001,5,629,0,0,7992,8001,5,379,
  	0,0,7993,7994,5,361,0,0,7994,8001,5,629,0,0,7995,7996,5,358,0,0,7996,
  	7997,5,60,0,0,7997,8001,5,633,0,0,7998,7999,5,361,0,0,7999,8001,5,633,
  	0,0,8000,7990,1,0,0,0,8000,7992,1,0,0,0,8000,7993,1,0,0,0,8000,7995,1,
  	0,0,0,8000,7998,1,0,0,0,8001,8002,1,0,0,0,8002,8004,3,1114,557,0,8003,
  	8005,5,32,0,0,8004,8003,1,0,0,0,8004,8005,1,0,0,0,8005,8079,1,0,0,0,8006,
  	8007,5,628,0,0,8007,8079,3,1114,557,0,8008,8010,5,656,0,0,8009,8011,3,
  	1114,557,0,8010,8009,1,0,0,0,8010,8011,1,0,0,0,8011,8013,1,0,0,0,8012,
  	8014,3,1116,558,0,8013,8012,1,0,0,0,8013,8014,1,0,0,0,8014,8079,1,0,0,
  	0,8015,8079,5,116,0,0,8016,8018,5,586,0,0,8017,8019,3,1126,563,0,8018,
  	8017,1,0,0,0,8018,8019,1,0,0,0,8019,8079,1,0,0,0,8020,8022,5,583,0,0,
  	8021,8023,3,1126,563,0,8022,8021,1,0,0,0,8022,8023,1,0,0,0,8023,8079,
  	1,0,0,0,8024,8026,5,113,0,0,8025,8027,3,1126,563,0,8026,8025,1,0,0,0,
  	8026,8027,1,0,0,0,8027,8079,1,0,0,0,8028,8079,5,587,0,0,8029,8031,5,39,
  	0,0,8030,8032,3,1114,557,0,8031,8030,1,0,0,0,8031,8032,1,0,0,0,8032,8079,
  	1,0,0,0,8033,8079,7,135,0,0,8034,8035,5,293,0,0,8035,8079,5,628,0,0,8036,
  	8040,5,293,0,0,8037,8038,5,60,0,0,8038,8041,5,633,0,0,8039,8041,5,629,
  	0,0,8040,8037,1,0,0,0,8040,8039,1,0,0,0,8040,8041,1,0,0,0,8041,8043,1,
  	0,0,0,8042,8044,3,1118,559,0,8043,8042,1,0,0,0,8043,8044,1,0,0,0,8044,
  	8079,1,0,0,0,8045,8047,5,589,0,0,8046,8048,3,1118,559,0,8047,8046,1,0,
  	0,0,8047,8048,1,0,0,0,8048,8079,1,0,0,0,8049,8051,5,580,0,0,8050,8052,
  	3,1114,557,0,8051,8050,1,0,0,0,8051,8052,1,0,0,0,8052,8054,1,0,0,0,8053,
  	8055,3,1118,559,0,8054,8053,1,0,0,0,8054,8055,1,0,0,0,8055,8079,1,0,0,
  	0,8056,8058,5,332,0,0,8057,8059,3,1118,559,0,8058,8057,1,0,0,0,8058,8059,
  	1,0,0,0,8059,8079,1,0,0,0,8060,8062,5,291,0,0,8061,8063,3,1118,559,0,
  	8062,8061,1,0,0,0,8062,8063,1,0,0,0,8063,8079,1,0,0,0,8064,8065,5,164,
  	0,0,8065,8067,3,1368,684,0,8066,8068,3,1118,559,0,8067,8066,1,0,0,0,8067,
  	8068,1,0,0,0,8068,8079,1,0,0,0,8069,8070,5,506,0,0,8070,8072,3,1368,684,
  	0,8071,8073,3,1118,559,0,8072,8071,1,0,0,0,8072,8073,1,0,0,0,8073,8079,
  	1,0,0,0,8074,8079,5,501,0,0,8075,8076,4,554,214,0,8076,8079,5,262,0,0,
  	8077,8079,7,136,0,0,8078,7931,1,0,0,0,8078,7943,1,0,0,0,8078,7951,1,0,
  	0,0,8078,7958,1,0,0,0,8078,7962,1,0,0,0,8078,7963,1,0,0,0,8078,7970,1,
  	0,0,0,8078,7977,1,0,0,0,8078,7984,1,0,0,0,8078,8000,1,0,0,0,8078,8006,
  	1,0,0,0,8078,8008,1,0,0,0,8078,8015,1,0,0,0,8078,8016,1,0,0,0,8078,8020,
  	1,0,0,0,8078,8024,1,0,0,0,8078,8028,1,0,0,0,8078,8029,1,0,0,0,8078,8033,
  	1,0,0,0,8078,8034,1,0,0,0,8078,8036,1,0,0,0,8078,8045,1,0,0,0,8078,8049,
  	1,0,0,0,8078,8056,1,0,0,0,8078,8060,1,0,0,0,8078,8064,1,0,0,0,8078,8069,
  	1,0,0,0,8078,8074,1,0,0,0,8078,8075,1,0,0,0,8078,8077,1,0,0,0,8079,1109,
  	1,0,0,0,8080,8084,5,361,0,0,8081,8082,5,358,0,0,8082,8084,5,60,0,0,8083,
  	8080,1,0,0,0,8083,8081,1,0,0,0,8084,1111,1,0,0,0,8085,8091,5,437,0,0,
  	8086,8088,5,146,0,0,8087,8089,5,416,0,0,8088,8087,1,0,0,0,8088,8089,1,
  	0,0,0,8089,8091,1,0,0,0,8090,8085,1,0,0,0,8090,8086,1,0,0,0,8091,1113,
  	1,0,0,0,8092,8095,5,776,0,0,8093,8096,3,1356,678,0,8094,8096,5,789,0,
  	0,8095,8093,1,0,0,0,8095,8094,1,0,0,0,8096,8097,1,0,0,0,8097,8098,5,777,
  	0,0,8098,1115,1,0,0,0,8099,8101,7,137,0,0,8100,8099,1,0,0,0,8101,8102,
  	1,0,0,0,8102,8100,1,0,0,0,8102,8103,1,0,0,0,8103,1117,1,0,0,0,8104,8119,
  	3,1120,560,0,8105,8119,3,1122,561,0,8106,8119,5,46,0,0,8107,8108,3,946,
  	473,0,8108,8110,3,1130,565,0,8109,8111,5,32,0,0,8110,8109,1,0,0,0,8110,
  	8111,1,0,0,0,8111,8119,1,0,0,0,8112,8116,5,32,0,0,8113,8114,3,946,473,
  	0,8114,8115,3,1130,565,0,8115,8117,1,0,0,0,8116,8113,1,0,0,0,8116,8117,
  	1,0,0,0,8117,8119,1,0,0,0,8118,8104,1,0,0,0,8118,8105,1,0,0,0,8118,8106,
  	1,0,0,0,8118,8107,1,0,0,0,8118,8112,1,0,0,0,8119,1119,1,0,0,0,8120,8122,
  	5,19,0,0,8121,8123,5,32,0,0,8122,8121,1,0,0,0,8122,8123,1,0,0,0,8123,
  	8127,1,0,0,0,8124,8125,5,32,0,0,8125,8127,5,19,0,0,8126,8120,1,0,0,0,
  	8126,8124,1,0,0,0,8127,1121,1,0,0,0,8128,8130,5,606,0,0,8129,8131,5,32,
  	0,0,8130,8129,1,0,0,0,8130,8131,1,0,0,0,8131,8135,1,0,0,0,8132,8133,5,
  	32,0,0,8133,8135,5,606,0,0,8134,8128,1,0,0,0,8134,8132,1,0,0,0,8135,1123,
  	1,0,0,0,8136,8137,5,776,0,0,8137,8138,3,1352,676,0,8138,8139,5,777,0,
  	0,8139,1125,1,0,0,0,8140,8141,5,776,0,0,8141,8142,5,747,0,0,8142,8143,
  	5,777,0,0,8143,1127,1,0,0,0,8144,8150,1,0,0,0,8145,8150,3,1406,703,0,
  	8146,8147,5,776,0,0,8147,8148,5,747,0,0,8148,8150,5,777,0,0,8149,8144,
  	1,0,0,0,8149,8145,1,0,0,0,8149,8146,1,0,0,0,8150,1129,1,0,0,0,8151,8156,
  	3,1398,699,0,8152,8156,5,32,0,0,8153,8154,4,565,215,0,8154,8156,5,128,
  	0,0,8155,8151,1,0,0,0,8155,8152,1,0,0,0,8155,8153,1,0,0,0,8156,1131,1,
  	0,0,0,8157,8163,3,1398,699,0,8158,8159,4,566,216,0,8159,8163,5,128,0,
  	0,8160,8161,4,566,217,0,8161,8163,5,32,0,0,8162,8157,1,0,0,0,8162,8158,
  	1,0,0,0,8162,8160,1,0,0,0,8163,1133,1,0,0,0,8164,8171,3,1138,569,0,8165,
  	8167,5,773,0,0,8166,8165,1,0,0,0,8166,8167,1,0,0,0,8167,8168,1,0,0,0,
  	8168,8170,3,1138,569,0,8169,8166,1,0,0,0,8170,8173,1,0,0,0,8171,8169,
  	1,0,0,0,8171,8172,1,0,0,0,8172,1135,1,0,0,0,8173,8171,1,0,0,0,8174,8176,
  	3,1138,569,0,8175,8174,1,0,0,0,8176,8177,1,0,0,0,8177,8175,1,0,0,0,8177,
  	8178,1,0,0,0,8178,1137,1,0,0,0,8179,8181,5,163,0,0,8180,8182,5,750,0,
  	0,8181,8180,1,0,0,0,8181,8182,1,0,0,0,8182,8183,1,0,0,0,8183,8326,3,1306,
  	653,0,8184,8185,4,569,218,0,8185,8187,5,721,0,0,8186,8188,3,1408,704,
  	0,8187,8186,1,0,0,0,8187,8188,1,0,0,0,8188,8191,1,0,0,0,8189,8192,5,376,
  	0,0,8190,8192,3,1398,699,0,8191,8189,1,0,0,0,8191,8190,1,0,0,0,8192,8326,
  	1,0,0,0,8193,8195,5,323,0,0,8194,8196,5,750,0,0,8195,8194,1,0,0,0,8195,
  	8196,1,0,0,0,8196,8197,1,0,0,0,8197,8326,3,1354,677,0,8198,8200,5,344,
  	0,0,8199,8201,5,750,0,0,8200,8199,1,0,0,0,8200,8201,1,0,0,0,8201,8202,
  	1,0,0,0,8202,8326,3,1354,677,0,8203,8205,5,25,0,0,8204,8206,5,750,0,0,
  	8205,8204,1,0,0,0,8205,8206,1,0,0,0,8206,8207,1,0,0,0,8207,8326,3,1354,
  	677,0,8208,8210,5,406,0,0,8209,8211,5,750,0,0,8210,8209,1,0,0,0,8210,
  	8211,1,0,0,0,8211,8212,1,0,0,0,8212,8326,3,1370,685,0,8213,8215,5,75,
  	0,0,8214,8216,5,750,0,0,8215,8214,1,0,0,0,8215,8216,1,0,0,0,8216,8217,
  	1,0,0,0,8217,8326,3,1370,685,0,8218,8219,4,569,219,0,8219,8221,5,81,0,
  	0,8220,8222,5,750,0,0,8221,8220,1,0,0,0,8221,8222,1,0,0,0,8222,8223,1,
  	0,0,0,8223,8326,3,1372,686,0,8224,8225,4,569,220,0,8225,8227,5,158,0,
  	0,8226,8228,5,750,0,0,8227,8226,1,0,0,0,8227,8228,1,0,0,0,8228,8229,1,
  	0,0,0,8229,8326,3,1372,686,0,8230,8232,5,24,0,0,8231,8233,5,750,0,0,8232,
  	8231,1,0,0,0,8232,8233,1,0,0,0,8233,8234,1,0,0,0,8234,8326,3,1354,677,
  	0,8235,8237,5,399,0,0,8236,8238,5,750,0,0,8237,8236,1,0,0,0,8237,8238,
  	1,0,0,0,8238,8239,1,0,0,0,8239,8326,3,1140,570,0,8240,8242,7,138,0,0,
  	8241,8243,5,750,0,0,8242,8241,1,0,0,0,8242,8243,1,0,0,0,8243,8244,1,0,
  	0,0,8244,8326,3,1140,570,0,8245,8247,7,139,0,0,8246,8248,5,750,0,0,8247,
  	8246,1,0,0,0,8247,8248,1,0,0,0,8248,8249,1,0,0,0,8249,8326,3,1350,675,
  	0,8250,8252,5,132,0,0,8251,8253,5,750,0,0,8252,8251,1,0,0,0,8252,8253,
  	1,0,0,0,8253,8254,1,0,0,0,8254,8326,3,1350,675,0,8255,8257,5,486,0,0,
  	8256,8258,5,750,0,0,8257,8256,1,0,0,0,8257,8258,1,0,0,0,8258,8259,1,0,
  	0,0,8259,8326,7,140,0,0,8260,8262,5,608,0,0,8261,8263,5,750,0,0,8262,
  	8261,1,0,0,0,8262,8263,1,0,0,0,8263,8264,1,0,0,0,8264,8265,5,776,0,0,
  	8265,8266,3,1316,658,0,8266,8267,5,777,0,0,8267,8326,1,0,0,0,8268,8326,
  	3,1146,573,0,8269,8326,3,1142,571,0,8270,8272,5,243,0,0,8271,8273,5,750,
  	0,0,8272,8271,1,0,0,0,8272,8273,1,0,0,0,8273,8274,1,0,0,0,8274,8326,7,
  	141,0,0,8275,8276,5,112,0,0,8276,8278,5,139,0,0,8277,8279,5,750,0,0,8278,
  	8277,1,0,0,0,8278,8279,1,0,0,0,8279,8280,1,0,0,0,8280,8326,3,1372,686,
  	0,8281,8282,5,236,0,0,8282,8284,5,139,0,0,8283,8285,5,750,0,0,8284,8283,
  	1,0,0,0,8284,8285,1,0,0,0,8285,8286,1,0,0,0,8286,8326,3,1372,686,0,8287,
  	8293,5,572,0,0,8288,8290,4,569,221,0,8289,8291,5,750,0,0,8290,8289,1,
  	0,0,0,8290,8291,1,0,0,0,8291,8294,1,0,0,0,8292,8294,1,0,0,0,8293,8288,
  	1,0,0,0,8293,8292,1,0,0,0,8294,8295,1,0,0,0,8295,8326,3,1338,669,0,8296,
  	8297,5,553,0,0,8297,8326,7,142,0,0,8298,8300,5,84,0,0,8299,8301,5,750,
  	0,0,8300,8299,1,0,0,0,8300,8301,1,0,0,0,8301,8302,1,0,0,0,8302,8326,3,
  	1372,686,0,8303,8305,5,264,0,0,8304,8306,5,750,0,0,8305,8304,1,0,0,0,
  	8305,8306,1,0,0,0,8306,8307,1,0,0,0,8307,8326,3,1354,677,0,8308,8309,
  	4,569,222,0,8309,8310,5,543,0,0,8310,8326,5,592,0,0,8311,8312,4,569,223,
  	0,8312,8314,5,797,0,0,8313,8315,5,750,0,0,8314,8313,1,0,0,0,8314,8315,
  	1,0,0,0,8315,8316,1,0,0,0,8316,8326,3,1416,708,0,8317,8318,4,569,224,
  	0,8318,8320,5,798,0,0,8319,8321,5,750,0,0,8320,8319,1,0,0,0,8320,8321,
  	1,0,0,0,8321,8322,1,0,0,0,8322,8326,3,1416,708,0,8323,8324,4,569,225,
  	0,8324,8326,3,144,72,0,8325,8179,1,0,0,0,8325,8184,1,0,0,0,8325,8193,
  	1,0,0,0,8325,8198,1,0,0,0,8325,8203,1,0,0,0,8325,8208,1,0,0,0,8325,8213,
  	1,0,0,0,8325,8218,1,0,0,0,8325,8224,1,0,0,0,8325,8230,1,0,0,0,8325,8235,
  	1,0,0,0,8325,8240,1,0,0,0,8325,8245,1,0,0,0,8325,8250,1,0,0,0,8325,8255,
  	1,0,0,0,8325,8260,1,0,0,0,8325,8268,1,0,0,0,8325,8269,1,0,0,0,8325,8270,
  	1,0,0,0,8325,8275,1,0,0,0,8325,8281,1,0,0,0,8325,8287,1,0,0,0,8325,8296,
  	1,0,0,0,8325,8298,1,0,0,0,8325,8303,1,0,0,0,8325,8308,1,0,0,0,8325,8311,
  	1,0,0,0,8325,8317,1,0,0,0,8325,8323,1,0,0,0,8326,1139,1,0,0,0,8327,8330,
  	3,1350,675,0,8328,8330,5,128,0,0,8329,8327,1,0,0,0,8329,8328,1,0,0,0,
  	8330,1141,1,0,0,0,8331,8333,5,128,0,0,8332,8331,1,0,0,0,8332,8333,1,0,
  	0,0,8333,8334,1,0,0,0,8334,8336,5,69,0,0,8335,8337,5,750,0,0,8336,8335,
  	1,0,0,0,8336,8337,1,0,0,0,8337,8338,1,0,0,0,8338,8339,3,1132,566,0,8339,
  	1143,1,0,0,0,8340,8342,5,128,0,0,8341,8340,1,0,0,0,8341,8342,1,0,0,0,
  	8342,8343,1,0,0,0,8343,8345,5,158,0,0,8344,8346,5,750,0,0,8345,8344,1,
  	0,0,0,8345,8346,1,0,0,0,8346,8347,1,0,0,0,8347,8348,3,1370,685,0,8348,
  	1145,1,0,0,0,8349,8351,5,128,0,0,8350,8349,1,0,0,0,8350,8351,1,0,0,0,
  	8351,8352,1,0,0,0,8352,8354,3,946,473,0,8353,8355,5,750,0,0,8354,8353,
  	1,0,0,0,8354,8355,1,0,0,0,8355,8356,1,0,0,0,8356,8357,3,1130,565,0,8357,
  	1147,1,0,0,0,8358,8359,5,405,0,0,8359,8360,5,45,0,0,8360,8363,3,1150,
  	575,0,8361,8362,5,404,0,0,8362,8364,3,1352,676,0,8363,8361,1,0,0,0,8363,
  	8364,1,0,0,0,8364,8366,1,0,0,0,8365,8367,3,1152,576,0,8366,8365,1,0,0,
  	0,8366,8367,1,0,0,0,8367,8369,1,0,0,0,8368,8370,3,1156,578,0,8369,8368,
  	1,0,0,0,8369,8370,1,0,0,0,8370,1149,1,0,0,0,8371,8373,5,277,0,0,8372,
  	8371,1,0,0,0,8372,8373,1,0,0,0,8373,8374,1,0,0,0,8374,8376,5,265,0,0,
  	8375,8377,3,1154,577,0,8376,8375,1,0,0,0,8376,8377,1,0,0,0,8377,8378,
  	1,0,0,0,8378,8380,5,776,0,0,8379,8381,3,1340,670,0,8380,8379,1,0,0,0,
  	8380,8381,1,0,0,0,8381,8382,1,0,0,0,8382,8405,5,777,0,0,8383,8385,5,277,
  	0,0,8384,8383,1,0,0,0,8384,8385,1,0,0,0,8385,8386,1,0,0,0,8386,8387,5,
  	220,0,0,8387,8388,5,776,0,0,8388,8389,3,864,432,0,8389,8390,5,777,0,0,
  	8390,8405,1,0,0,0,8391,8402,7,143,0,0,8392,8393,5,776,0,0,8393,8394,3,
  	864,432,0,8394,8395,5,777,0,0,8395,8403,1,0,0,0,8396,8397,5,71,0,0,8397,
  	8399,5,776,0,0,8398,8400,3,1340,670,0,8399,8398,1,0,0,0,8399,8400,1,0,
  	0,0,8400,8401,1,0,0,0,8401,8403,5,777,0,0,8402,8392,1,0,0,0,8402,8396,
  	1,0,0,0,8403,8405,1,0,0,0,8404,8372,1,0,0,0,8404,8384,1,0,0,0,8404,8391,
  	1,0,0,0,8405,1151,1,0,0,0,8406,8407,5,561,0,0,8407,8409,5,45,0,0,8408,
  	8410,5,277,0,0,8409,8408,1,0,0,0,8409,8410,1,0,0,0,8410,8421,1,0,0,0,
  	8411,8412,5,220,0,0,8412,8413,5,776,0,0,8413,8414,3,864,432,0,8414,8415,
  	5,777,0,0,8415,8422,1,0,0,0,8416,8418,5,265,0,0,8417,8419,3,1154,577,
  	0,8418,8417,1,0,0,0,8418,8419,1,0,0,0,8419,8420,1,0,0,0,8420,8422,3,1342,
  	671,0,8421,8411,1,0,0,0,8421,8416,1,0,0,0,8422,8425,1,0,0,0,8423,8424,
  	5,560,0,0,8424,8426,3,1352,676,0,8425,8423,1,0,0,0,8425,8426,1,0,0,0,
  	8426,1153,1,0,0,0,8427,8428,5,9,0,0,8428,8429,5,750,0,0,8429,8430,3,1352,
  	676,0,8430,1155,1,0,0,0,8431,8432,5,776,0,0,8432,8437,3,1158,579,0,8433,
  	8434,5,773,0,0,8434,8436,3,1158,579,0,8435,8433,1,0,0,0,8436,8439,1,0,
  	0,0,8437,8435,1,0,0,0,8437,8438,1,0,0,0,8438,8440,1,0,0,0,8439,8437,1,
  	0,0,0,8440,8441,5,777,0,0,8441,1157,1,0,0,0,8442,8443,5,405,0,0,8443,
  	8454,3,1338,669,0,8444,8445,5,626,0,0,8445,8446,5,273,0,0,8446,8449,5,
  	581,0,0,8447,8450,3,1166,583,0,8448,8450,5,329,0,0,8449,8447,1,0,0,0,
  	8449,8448,1,0,0,0,8450,8455,1,0,0,0,8451,8452,5,626,0,0,8452,8453,5,251,
  	0,0,8453,8455,3,1160,580,0,8454,8444,1,0,0,0,8454,8451,1,0,0,0,8454,8455,
  	1,0,0,0,8455,8459,1,0,0,0,8456,8458,3,1162,581,0,8457,8456,1,0,0,0,8458,
  	8461,1,0,0,0,8459,8457,1,0,0,0,8459,8460,1,0,0,0,8460,8473,1,0,0,0,8461,
  	8459,1,0,0,0,8462,8463,5,776,0,0,8463,8468,3,1164,582,0,8464,8465,5,773,
  	0,0,8465,8467,3,1164,582,0,8466,8464,1,0,0,0,8467,8470,1,0,0,0,8468,8466,
  	1,0,0,0,8468,8469,1,0,0,0,8469,8471,1,0,0,0,8470,8468,1,0,0,0,8471,8472,
  	5,777,0,0,8472,8474,1,0,0,0,8473,8462,1,0,0,0,8473,8474,1,0,0,0,8474,
  	1159,1,0,0,0,8475,8488,3,1166,583,0,8476,8477,5,776,0,0,8477,8482,3,1166,
  	583,0,8478,8479,5,773,0,0,8479,8481,3,1166,583,0,8480,8478,1,0,0,0,8481,
  	8484,1,0,0,0,8482,8480,1,0,0,0,8482,8483,1,0,0,0,8483,8485,1,0,0,0,8484,
  	8482,1,0,0,0,8485,8486,5,777,0,0,8486,8488,1,0,0,0,8487,8475,1,0,0,0,
  	8487,8476,1,0,0,0,8488,1161,1,0,0,0,8489,8491,5,572,0,0,8490,8492,5,750,
  	0,0,8491,8490,1,0,0,0,8491,8492,1,0,0,0,8492,8493,1,0,0,0,8493,8524,3,
  	1338,669,0,8494,8496,5,553,0,0,8495,8494,1,0,0,0,8495,8496,1,0,0,0,8496,
  	8497,1,0,0,0,8497,8499,5,163,0,0,8498,8500,5,750,0,0,8499,8498,1,0,0,
  	0,8499,8500,1,0,0,0,8500,8501,1,0,0,0,8501,8524,3,1306,653,0,8502,8504,
  	5,368,0,0,8503,8505,5,750,0,0,8504,8503,1,0,0,0,8504,8505,1,0,0,0,8505,
  	8506,1,0,0,0,8506,8524,3,1352,676,0,8507,8509,7,144,0,0,8508,8510,5,750,
  	0,0,8509,8508,1,0,0,0,8509,8510,1,0,0,0,8510,8511,1,0,0,0,8511,8524,3,
  	1352,676,0,8512,8513,7,145,0,0,8513,8515,5,139,0,0,8514,8516,5,750,0,
  	0,8515,8514,1,0,0,0,8515,8516,1,0,0,0,8516,8517,1,0,0,0,8517,8524,3,1376,
  	688,0,8518,8520,5,75,0,0,8519,8521,5,750,0,0,8520,8519,1,0,0,0,8520,8521,
  	1,0,0,0,8521,8522,1,0,0,0,8522,8524,3,1376,688,0,8523,8489,1,0,0,0,8523,
  	8495,1,0,0,0,8523,8502,1,0,0,0,8523,8507,1,0,0,0,8523,8512,1,0,0,0,8523,
  	8518,1,0,0,0,8524,1163,1,0,0,0,8525,8526,5,561,0,0,8526,8530,3,1398,699,
  	0,8527,8529,3,1162,581,0,8528,8527,1,0,0,0,8529,8532,1,0,0,0,8530,8528,
  	1,0,0,0,8530,8531,1,0,0,0,8531,1165,1,0,0,0,8532,8530,1,0,0,0,8533,8534,
  	5,776,0,0,8534,8539,3,1168,584,0,8535,8536,5,773,0,0,8536,8538,3,1168,
  	584,0,8537,8535,1,0,0,0,8538,8541,1,0,0,0,8539,8537,1,0,0,0,8539,8540,
  	1,0,0,0,8540,8542,1,0,0,0,8541,8539,1,0,0,0,8542,8543,5,777,0,0,8543,
  	1167,1,0,0,0,8544,8547,3,864,432,0,8545,8547,5,329,0,0,8546,8544,1,0,
  	0,0,8546,8545,1,0,0,0,8547,1169,1,0,0,0,8548,8549,5,130,0,0,8549,8550,
  	5,750,0,0,8550,8551,3,1238,619,0,8551,1171,1,0,0,0,8552,8553,5,231,0,
  	0,8553,8554,5,174,0,0,8554,1173,1,0,0,0,8555,8556,5,231,0,0,8556,8557,
  	3,948,474,0,8557,8558,5,174,0,0,8558,1175,1,0,0,0,8559,8561,7,146,0,0,
  	8560,8559,1,0,0,0,8560,8561,1,0,0,0,8561,8562,1,0,0,0,8562,8563,3,1178,
  	589,0,8563,1177,1,0,0,0,8564,8565,3,1320,660,0,8565,8566,3,1182,591,0,
  	8566,1179,1,0,0,0,8567,8568,5,69,0,0,8568,8569,3,1132,566,0,8569,1181,
  	1,0,0,0,8570,8572,3,1108,554,0,8571,8573,3,1180,590,0,8572,8571,1,0,0,
  	0,8572,8573,1,0,0,0,8573,1183,1,0,0,0,8574,8575,5,776,0,0,8575,8576,3,
  	1270,635,0,8576,8577,5,773,0,0,8577,8578,3,1270,635,0,8578,8579,5,777,
  	0,0,8579,1185,1,0,0,0,8580,8585,3,1286,643,0,8581,8582,5,773,0,0,8582,
  	8584,3,1286,643,0,8583,8581,1,0,0,0,8584,8587,1,0,0,0,8585,8583,1,0,0,
  	0,8585,8586,1,0,0,0,8586,1187,1,0,0,0,8587,8585,1,0,0,0,8588,8593,3,1190,
  	595,0,8589,8590,5,773,0,0,8590,8592,3,1190,595,0,8591,8589,1,0,0,0,8592,
  	8595,1,0,0,0,8593,8591,1,0,0,0,8593,8594,1,0,0,0,8594,1189,1,0,0,0,8595,
  	8593,1,0,0,0,8596,8597,3,1258,629,0,8597,8600,5,750,0,0,8598,8601,3,854,
  	427,0,8599,8601,5,128,0,0,8600,8598,1,0,0,0,8600,8599,1,0,0,0,8601,1191,
  	1,0,0,0,8602,8603,3,946,473,0,8603,8604,3,1130,565,0,8604,1193,1,0,0,
  	0,8605,8607,5,71,0,0,8606,8608,3,1196,598,0,8607,8606,1,0,0,0,8608,8609,
  	1,0,0,0,8609,8607,1,0,0,0,8609,8610,1,0,0,0,8610,1195,1,0,0,0,8611,8612,
  	5,579,0,0,8612,8613,5,45,0,0,8613,8624,3,1372,686,0,8614,8616,5,392,0,
  	0,8615,8614,1,0,0,0,8615,8616,1,0,0,0,8616,8617,1,0,0,0,8617,8618,5,157,
  	0,0,8618,8619,5,45,0,0,8619,8624,3,1372,686,0,8620,8621,5,167,0,0,8621,
  	8622,5,45,0,0,8622,8624,3,1372,686,0,8623,8611,1,0,0,0,8623,8615,1,0,
  	0,0,8623,8620,1,0,0,0,8624,1197,1,0,0,0,8625,8627,5,278,0,0,8626,8628,
  	3,1200,600,0,8627,8626,1,0,0,0,8628,8629,1,0,0,0,8629,8627,1,0,0,0,8629,
  	8630,1,0,0,0,8630,1199,1,0,0,0,8631,8632,7,147,0,0,8632,8633,5,45,0,0,
  	8633,8634,3,1372,686,0,8634,1201,1,0,0,0,8635,8640,3,1238,619,0,8636,
  	8637,5,773,0,0,8637,8639,3,1238,619,0,8638,8636,1,0,0,0,8639,8642,1,0,
  	0,0,8640,8638,1,0,0,0,8640,8641,1,0,0,0,8641,1203,1,0,0,0,8642,8640,1,
  	0,0,0,8643,8648,3,1206,603,0,8644,8645,5,773,0,0,8645,8647,3,1206,603,
  	0,8646,8644,1,0,0,0,8647,8650,1,0,0,0,8648,8646,1,0,0,0,8648,8649,1,0,
  	0,0,8649,1205,1,0,0,0,8650,8648,1,0,0,0,8651,8664,3,1238,619,0,8652,8655,
  	3,1210,605,0,8653,8654,4,603,226,0,8654,8656,3,1208,604,0,8655,8653,1,
  	0,0,0,8655,8656,1,0,0,0,8656,8665,1,0,0,0,8657,8660,3,1216,608,0,8658,
  	8659,4,603,227,0,8659,8661,3,1224,612,0,8660,8658,1,0,0,0,8660,8661,1,
  	0,0,0,8661,8665,1,0,0,0,8662,8663,4,603,228,0,8663,8665,3,1208,604,0,
  	8664,8652,1,0,0,0,8664,8657,1,0,0,0,8664,8662,1,0,0,0,8664,8665,1,0,0,
  	0,8665,1207,1,0,0,0,8666,8667,5,15,0,0,8667,8670,3,1210,605,0,8668,8669,
  	5,15,0,0,8669,8671,3,1210,605,0,8670,8668,1,0,0,0,8670,8671,1,0,0,0,8671,
  	1209,1,0,0,0,8672,8682,3,1212,606,0,8673,8674,4,605,229,0,8674,8682,3,
  	1214,607,0,8675,8682,3,1216,608,0,8676,8682,3,1218,609,0,8677,8678,4,
  	605,230,0,8678,8682,3,1220,610,0,8679,8680,4,605,231,0,8680,8682,3,1222,
  	611,0,8681,8672,1,0,0,0,8681,8673,1,0,0,0,8681,8675,1,0,0,0,8681,8676,
  	1,0,0,0,8681,8677,1,0,0,0,8681,8679,1,0,0,0,8682,1211,1,0,0,0,8683,8684,
  	5,230,0,0,8684,8687,5,45,0,0,8685,8686,4,606,232,0,8686,8688,5,406,0,
  	0,8687,8685,1,0,0,0,8687,8688,1,0,0,0,8688,8689,1,0,0,0,8689,8690,3,1370,
  	685,0,8690,1213,1,0,0,0,8691,8692,5,230,0,0,8692,8693,5,45,0,0,8693,8694,
  	5,734,0,0,8694,8695,5,406,0,0,8695,1215,1,0,0,0,8696,8697,5,230,0,0,8697,
  	8698,5,645,0,0,8698,8699,3,1398,699,0,8699,1217,1,0,0,0,8700,8701,5,230,
  	0,0,8701,8702,5,645,0,0,8702,8703,3,1398,699,0,8703,8704,5,17,0,0,8704,
  	8705,3,1374,687,0,8705,1219,1,0,0,0,8706,8707,5,230,0,0,8707,8708,5,645,
  	0,0,8708,8709,3,1398,699,0,8709,8710,5,45,0,0,8710,8711,3,1370,685,0,
  	8711,1221,1,0,0,0,8712,8713,5,230,0,0,8713,8714,5,645,0,0,8714,8715,3,
  	1398,699,0,8715,8716,5,45,0,0,8716,8717,5,734,0,0,8717,8718,5,406,0,0,
  	8718,1223,1,0,0,0,8719,8720,5,840,0,0,8720,8724,5,834,0,0,8721,8725,3,
  	1214,607,0,8722,8725,3,1218,609,0,8723,8725,3,1212,606,0,8724,8721,1,
  	0,0,0,8724,8722,1,0,0,0,8724,8723,1,0,0,0,8725,1225,1,0,0,0,8726,8727,
  	5,727,0,0,8727,8728,5,101,0,0,8728,8729,5,406,0,0,8729,1227,1,0,0,0,8730,
  	8731,5,141,0,0,8731,8732,5,728,0,0,8732,8733,5,406,0,0,8733,1229,1,0,
  	0,0,8734,8735,3,1232,616,0,8735,8736,5,837,0,0,8736,8737,5,838,0,0,8737,
  	8750,1,0,0,0,8738,8739,3,1232,616,0,8739,8740,5,839,0,0,8740,8750,1,0,
  	0,0,8741,8742,3,1232,616,0,8742,8743,5,836,0,0,8743,8744,5,838,0,0,8744,
  	8745,5,506,0,0,8745,8746,5,841,0,0,8746,8747,5,17,0,0,8747,8748,3,1374,
  	687,0,8748,8750,1,0,0,0,8749,8734,1,0,0,0,8749,8738,1,0,0,0,8749,8741,
  	1,0,0,0,8750,1231,1,0,0,0,8751,8752,3,1382,691,0,8752,8753,5,835,0,0,
  	8753,1233,1,0,0,0,8754,8755,5,458,0,0,8755,8756,3,1372,686,0,8756,1235,
  	1,0,0,0,8757,8763,3,1398,699,0,8758,8761,5,783,0,0,8759,8762,3,1398,699,
  	0,8760,8762,5,858,0,0,8761,8759,1,0,0,0,8761,8760,1,0,0,0,8762,8764,1,
  	0,0,0,8763,8758,1,0,0,0,8763,8764,1,0,0,0,8764,1237,1,0,0,0,8765,8771,
  	3,1236,618,0,8766,8768,5,105,0,0,8767,8769,3,1406,703,0,8768,8767,1,0,
  	0,0,8768,8769,1,0,0,0,8769,8771,1,0,0,0,8770,8765,1,0,0,0,8770,8766,1,
  	0,0,0,8771,1239,1,0,0,0,8772,8773,5,275,0,0,8773,8774,3,1370,685,0,8774,
  	1241,1,0,0,0,8775,8778,3,1240,620,0,8776,8778,3,364,182,0,8777,8775,1,
  	0,0,0,8777,8776,1,0,0,0,8778,1243,1,0,0,0,8779,8780,7,148,0,0,8780,1245,
  	1,0,0,0,8781,8782,7,149,0,0,8782,1247,1,0,0,0,8783,8784,5,405,0,0,8784,
  	8785,3,1342,671,0,8785,1249,1,0,0,0,8786,8792,3,1348,674,0,8787,8789,
  	3,1344,672,0,8788,8790,3,1348,674,0,8789,8788,1,0,0,0,8789,8790,1,0,0,
  	0,8790,8792,1,0,0,0,8791,8786,1,0,0,0,8791,8787,1,0,0,0,8792,1251,1,0,
  	0,0,8793,8794,4,626,233,0,8794,8798,3,1338,669,0,8795,8796,4,626,234,
  	0,8796,8798,3,1250,625,0,8797,8793,1,0,0,0,8797,8795,1,0,0,0,8798,1253,
  	1,0,0,0,8799,8800,3,1338,669,0,8800,1255,1,0,0,0,8801,8802,5,776,0,0,
  	8802,8807,3,1254,627,0,8803,8804,5,773,0,0,8804,8806,3,1254,627,0,8805,
  	8803,1,0,0,0,8806,8809,1,0,0,0,8807,8805,1,0,0,0,8807,8808,1,0,0,0,8808,
  	8810,1,0,0,0,8809,8807,1,0,0,0,8810,8811,5,777,0,0,8811,1257,1,0,0,0,
  	8812,8813,3,1250,625,0,8813,1259,1,0,0,0,8814,8817,3,1258,629,0,8815,
  	8817,3,1266,633,0,8816,8814,1,0,0,0,8816,8815,1,0,0,0,8817,1261,1,0,0,
  	0,8818,8819,3,1338,669,0,8819,1263,1,0,0,0,8820,8821,3,1250,625,0,8821,
  	1265,1,0,0,0,8822,8823,3,1338,669,0,8823,8827,5,772,0,0,8824,8825,3,1338,
  	669,0,8825,8826,5,772,0,0,8826,8828,1,0,0,0,8827,8824,1,0,0,0,8827,8828,
  	1,0,0,0,8828,8829,1,0,0,0,8829,8830,5,760,0,0,8830,1267,1,0,0,0,8831,
  	8832,3,1338,669,0,8832,1269,1,0,0,0,8833,8834,3,1338,669,0,8834,1271,
  	1,0,0,0,8835,8836,3,1344,672,0,8836,1273,1,0,0,0,8837,8838,3,1344,672,
  	0,8838,1275,1,0,0,0,8839,8840,3,1344,672,0,8840,1277,1,0,0,0,8841,8842,
  	3,1344,672,0,8842,1279,1,0,0,0,8843,8844,3,1344,672,0,8844,1281,1,0,0,
  	0,8845,8846,3,1344,672,0,8846,1283,1,0,0,0,8847,8850,3,1344,672,0,8848,
  	8850,3,1348,674,0,8849,8847,1,0,0,0,8849,8848,1,0,0,0,8850,1285,1,0,0,
  	0,8851,8854,3,1344,672,0,8852,8854,3,1348,674,0,8853,8851,1,0,0,0,8853,
  	8852,1,0,0,0,8854,1287,1,0,0,0,8855,8856,3,1338,669,0,8856,1289,1,0,0,
  	0,8857,8858,3,1338,669,0,8858,1291,1,0,0,0,8859,8860,3,1338,669,0,8860,
  	1293,1,0,0,0,8861,8862,3,1338,669,0,8862,1295,1,0,0,0,8863,8864,3,1344,
  	672,0,8864,1297,1,0,0,0,8865,8866,3,1344,672,0,8866,1299,1,0,0,0,8867,
  	8868,3,1338,669,0,8868,1301,1,0,0,0,8869,8870,3,1398,699,0,8870,1303,
  	1,0,0,0,8871,8872,3,1398,699,0,8872,1305,1,0,0,0,8873,8874,3,1398,699,
  	0,8874,1307,1,0,0,0,8875,8878,3,1344,672,0,8876,8878,3,1348,674,0,8877,
  	8875,1,0,0,0,8877,8876,1,0,0,0,8878,1309,1,0,0,0,8879,8880,3,1270,635,
  	0,8880,8881,3,1348,674,0,8881,1311,1,0,0,0,8882,8890,3,1338,669,0,8883,
  	8884,5,772,0,0,8884,8891,5,760,0,0,8885,8888,3,1348,674,0,8886,8887,5,
  	772,0,0,8887,8889,5,760,0,0,8888,8886,1,0,0,0,8888,8889,1,0,0,0,8889,
  	8891,1,0,0,0,8890,8883,1,0,0,0,8890,8885,1,0,0,0,8890,8891,1,0,0,0,8891,
  	1313,1,0,0,0,8892,8895,3,1344,672,0,8893,8895,3,1348,674,0,8894,8892,
  	1,0,0,0,8894,8893,1,0,0,0,8895,1315,1,0,0,0,8896,8901,3,1314,657,0,8897,
  	8898,5,773,0,0,8898,8900,3,1314,657,0,8899,8897,1,0,0,0,8900,8903,1,0,
  	0,0,8901,8899,1,0,0,0,8901,8902,1,0,0,0,8902,1317,1,0,0,0,8903,8901,1,
  	0,0,0,8904,8909,3,1312,656,0,8905,8906,5,773,0,0,8906,8908,3,1312,656,
  	0,8907,8905,1,0,0,0,8908,8911,1,0,0,0,8909,8907,1,0,0,0,8909,8910,1,0,
  	0,0,8910,1319,1,0,0,0,8911,8909,1,0,0,0,8912,8913,3,1338,669,0,8913,1321,
  	1,0,0,0,8914,8917,3,1336,668,0,8915,8917,3,1424,712,0,8916,8914,1,0,0,
  	0,8916,8915,1,0,0,0,8917,1323,1,0,0,0,8918,8919,3,1322,661,0,8919,1325,
  	1,0,0,0,8920,8923,3,1336,668,0,8921,8923,3,1430,715,0,8922,8920,1,0,0,
  	0,8922,8921,1,0,0,0,8923,1327,1,0,0,0,8924,8925,3,1338,669,0,8925,1329,
  	1,0,0,0,8926,8927,3,1370,685,0,8927,1331,1,0,0,0,8928,8929,3,1338,669,
  	0,8929,1333,1,0,0,0,8930,8931,3,1338,669,0,8931,1335,1,0,0,0,8932,8936,
  	7,150,0,0,8933,8934,4,668,235,0,8934,8936,5,849,0,0,8935,8932,1,0,0,0,
  	8935,8933,1,0,0,0,8936,1337,1,0,0,0,8937,8940,3,1336,668,0,8938,8940,
  	3,1418,709,0,8939,8937,1,0,0,0,8939,8938,1,0,0,0,8940,1339,1,0,0,0,8941,
  	8946,3,1338,669,0,8942,8943,5,773,0,0,8943,8945,3,1338,669,0,8944,8942,
  	1,0,0,0,8945,8948,1,0,0,0,8946,8944,1,0,0,0,8946,8947,1,0,0,0,8947,1341,
  	1,0,0,0,8948,8946,1,0,0,0,8949,8950,5,776,0,0,8950,8951,3,1340,670,0,
  	8951,8952,5,777,0,0,8952,1343,1,0,0,0,8953,8955,3,1338,669,0,8954,8956,
  	3,1348,674,0,8955,8954,1,0,0,0,8955,8956,1,0,0,0,8956,1345,1,0,0,0,8957,
  	8962,3,1338,669,0,8958,8960,3,1348,674,0,8959,8961,3,1348,674,0,8960,
  	8959,1,0,0,0,8960,8961,1,0,0,0,8961,8963,1,0,0,0,8962,8958,1,0,0,0,8962,
  	8963,1,0,0,0,8963,8969,1,0,0,0,8964,8965,4,673,236,0,8965,8966,3,1348,
  	674,0,8966,8967,3,1348,674,0,8967,8969,1,0,0,0,8968,8957,1,0,0,0,8968,
  	8964,1,0,0,0,8969,1347,1,0,0,0,8970,8971,5,772,0,0,8971,8972,3,1338,669,
  	0,8972,1349,1,0,0,0,8973,8974,7,151,0,0,8974,1351,1,0,0,0,8975,8976,7,
  	152,0,0,8976,1353,1,0,0,0,8977,8978,7,153,0,0,8978,1355,1,0,0,0,8979,
  	8985,5,747,0,0,8980,8981,4,678,237,0,8981,8985,5,787,0,0,8982,8985,5,
  	749,0,0,8983,8985,5,748,0,0,8984,8979,1,0,0,0,8984,8980,1,0,0,0,8984,
  	8982,1,0,0,0,8984,8983,1,0,0,0,8985,1357,1,0,0,0,8986,8992,3,1362,681,
  	0,8987,8988,5,758,0,0,8988,8992,3,1350,675,0,8989,8990,5,759,0,0,8990,
  	8992,3,1350,675,0,8991,8986,1,0,0,0,8991,8987,1,0,0,0,8991,8989,1,0,0,
  	0,8992,1359,1,0,0,0,8993,8997,3,1358,679,0,8994,8995,4,680,238,0,8995,
  	8997,3,1366,683,0,8996,8993,1,0,0,0,8996,8994,1,0,0,0,8997,1361,1,0,0,
  	0,8998,9008,3,1376,688,0,8999,9008,3,1382,691,0,9000,9008,3,1390,695,
  	0,9001,9008,3,1386,693,0,9002,9008,3,1384,692,0,9003,9005,5,845,0,0,9004,
  	9003,1,0,0,0,9004,9005,1,0,0,0,9005,9006,1,0,0,0,9006,9008,7,154,0,0,
  	9007,8998,1,0,0,0,9007,8999,1,0,0,0,9007,9000,1,0,0,0,9007,9001,1,0,0,
  	0,9007,9002,1,0,0,0,9007,9004,1,0,0,0,9008,1363,1,0,0,0,9009,9013,3,1362,
  	681,0,9010,9011,4,682,239,0,9011,9013,3,1366,683,0,9012,9009,1,0,0,0,
  	9012,9010,1,0,0,0,9013,1365,1,0,0,0,9014,9015,5,376,0,0,9015,1367,1,0,
  	0,0,9016,9017,5,776,0,0,9017,9022,3,1372,686,0,9018,9019,5,773,0,0,9019,
  	9021,3,1372,686,0,9020,9018,1,0,0,0,9021,9024,1,0,0,0,9022,9020,1,0,0,
  	0,9022,9023,1,0,0,0,9023,9025,1,0,0,0,9024,9022,1,0,0,0,9025,9026,5,777,
  	0,0,9026,1369,1,0,0,0,9027,9031,5,850,0,0,9028,9029,4,685,240,0,9029,
  	9031,5,849,0,0,9030,9027,1,0,0,0,9030,9028,1,0,0,0,9031,1371,1,0,0,0,
  	9032,9036,3,1370,685,0,9033,9036,5,787,0,0,9034,9036,5,788,0,0,9035,9032,
  	1,0,0,0,9035,9033,1,0,0,0,9035,9034,1,0,0,0,9036,1373,1,0,0,0,9037,9041,
  	3,1370,685,0,9038,9039,4,687,241,0,9039,9041,5,787,0,0,9040,9037,1,0,
  	0,0,9040,9038,1,0,0,0,9041,1375,1,0,0,0,9042,9044,5,845,0,0,9043,9042,
  	1,0,0,0,9043,9044,1,0,0,0,9044,9045,1,0,0,0,9045,9048,3,1370,685,0,9046,
  	9048,5,847,0,0,9047,9043,1,0,0,0,9047,9046,1,0,0,0,9048,9052,1,0,0,0,
  	9049,9051,3,1370,685,0,9050,9049,1,0,0,0,9051,9054,1,0,0,0,9052,9050,
  	1,0,0,0,9052,9053,1,0,0,0,9053,1377,1,0,0,0,9054,9052,1,0,0,0,9055,9056,
  	3,1370,685,0,9056,1379,1,0,0,0,9057,9062,3,1370,685,0,9058,9059,5,773,
  	0,0,9059,9061,3,1370,685,0,9060,9058,1,0,0,0,9061,9064,1,0,0,0,9062,9060,
  	1,0,0,0,9062,9063,1,0,0,0,9063,1381,1,0,0,0,9064,9062,1,0,0,0,9065,9069,
  	3,1388,694,0,9066,9069,5,789,0,0,9067,9069,5,790,0,0,9068,9065,1,0,0,
  	0,9068,9066,1,0,0,0,9068,9067,1,0,0,0,9069,1383,1,0,0,0,9070,9071,7,155,
  	0,0,9071,1385,1,0,0,0,9072,9073,7,156,0,0,9073,1387,1,0,0,0,9074,9075,
  	7,157,0,0,9075,1389,1,0,0,0,9076,9077,5,116,0,0,9077,9083,5,850,0,0,9078,
  	9079,5,586,0,0,9079,9083,5,850,0,0,9080,9081,5,583,0,0,9081,9083,5,850,
  	0,0,9082,9076,1,0,0,0,9082,9078,1,0,0,0,9082,9080,1,0,0,0,9083,1391,1,
  	0,0,0,9084,9087,3,1114,557,0,9085,9087,3,1396,698,0,9086,9084,1,0,0,0,
  	9086,9085,1,0,0,0,9087,1393,1,0,0,0,9088,9089,3,1396,698,0,9089,1395,
  	1,0,0,0,9090,9091,5,776,0,0,9091,9092,5,747,0,0,9092,9093,5,773,0,0,9093,
  	9094,5,747,0,0,9094,9095,5,777,0,0,9095,1397,1,0,0,0,9096,9099,3,1338,
  	669,0,9097,9099,3,1370,685,0,9098,9096,1,0,0,0,9098,9097,1,0,0,0,9099,
  	1399,1,0,0,0,9100,9103,3,1336,668,0,9101,9103,3,1432,716,0,9102,9100,
  	1,0,0,0,9102,9101,1,0,0,0,9103,1401,1,0,0,0,9104,9107,3,1326,663,0,9105,
  	9107,3,1370,685,0,9106,9104,1,0,0,0,9106,9105,1,0,0,0,9107,1403,1,0,0,
  	0,9108,9111,3,1356,678,0,9109,9111,3,1336,668,0,9110,9108,1,0,0,0,9110,
  	9109,1,0,0,0,9111,1405,1,0,0,0,9112,9113,5,776,0,0,9113,9114,5,777,0,
  	0,9114,1407,1,0,0,0,9115,9116,7,158,0,0,9116,1409,1,0,0,0,9117,9118,4,
  	705,242,0,9118,9125,5,658,0,0,9119,9120,4,705,243,0,9120,9125,5,673,0,
  	0,9121,9125,5,214,0,0,9122,9125,5,284,0,0,9123,9125,5,502,0,0,9124,9117,
  	1,0,0,0,9124,9119,1,0,0,0,9124,9121,1,0,0,0,9124,9122,1,0,0,0,9124,9123,
  	1,0,0,0,9125,1411,1,0,0,0,9126,9127,5,214,0,0,9127,9133,5,772,0,0,9128,
  	9129,5,284,0,0,9129,9133,5,772,0,0,9130,9131,5,502,0,0,9131,9133,5,772,
  	0,0,9132,9126,1,0,0,0,9132,9128,1,0,0,0,9132,9130,1,0,0,0,9133,1413,1,
  	0,0,0,9134,9135,4,707,244,0,9135,9142,5,658,0,0,9136,9137,4,707,245,0,
  	9137,9142,5,673,0,0,9138,9142,5,214,0,0,9139,9142,5,284,0,0,9140,9142,
  	5,502,0,0,9141,9134,1,0,0,0,9141,9136,1,0,0,0,9141,9138,1,0,0,0,9141,
  	9139,1,0,0,0,9141,9140,1,0,0,0,9142,9143,1,0,0,0,9143,9144,5,772,0,0,
  	9144,1415,1,0,0,0,9145,9146,3,1370,685,0,9146,1417,1,0,0,0,9147,9155,
  	4,709,246,0,9148,9156,3,1424,712,0,9149,9156,3,1436,718,0,9150,9156,5,
  	173,0,0,9151,9152,4,709,247,0,9152,9156,5,510,0,0,9153,9154,4,709,248,
  	0,9154,9156,5,714,0,0,9155,9148,1,0,0,0,9155,9149,1,0,0,0,9155,9150,1,
  	0,0,0,9155,9151,1,0,0,0,9155,9153,1,0,0,0,9156,9165,1,0,0,0,9157,9163,
  	3,1428,714,0,9158,9163,3,1420,710,0,9159,9163,3,1422,711,0,9160,9163,
  	3,1426,713,0,9161,9163,3,1434,717,0,9162,9157,1,0,0,0,9162,9158,1,0,0,
  	0,9162,9159,1,0,0,0,9162,9160,1,0,0,0,9162,9161,1,0,0,0,9163,9165,1,0,
  	0,0,9164,9147,1,0,0,0,9164,9162,1,0,0,0,9165,1419,1,0,0,0,9166,9167,7,
  	159,0,0,9167,1421,1,0,0,0,9168,9169,7,160,0,0,9169,1423,1,0,0,0,9170,
  	9181,4,712,249,0,9171,9182,3,1438,719,0,9172,9182,5,170,0,0,9173,9182,
  	5,188,0,0,9174,9182,5,369,0,0,9175,9182,5,423,0,0,9176,9182,5,427,0,0,
  	9177,9182,5,451,0,0,9178,9182,5,459,0,0,9179,9182,5,709,0,0,9180,9182,
  	5,565,0,0,9181,9171,1,0,0,0,9181,9172,1,0,0,0,9181,9173,1,0,0,0,9181,
  	9174,1,0,0,0,9181,9175,1,0,0,0,9181,9176,1,0,0,0,9181,9177,1,0,0,0,9181,
  	9178,1,0,0,0,9181,9179,1,0,0,0,9181,9180,1,0,0,0,9182,9189,1,0,0,0,9183,
  	9187,3,1428,714,0,9184,9187,3,1426,713,0,9185,9187,3,1434,717,0,9186,
  	9183,1,0,0,0,9186,9184,1,0,0,0,9186,9185,1,0,0,0,9187,9189,1,0,0,0,9188,
  	9170,1,0,0,0,9188,9186,1,0,0,0,9189,1425,1,0,0,0,9190,9191,7,161,0,0,
  	9191,1427,1,0,0,0,9192,9196,7,162,0,0,9193,9194,4,714,250,0,9194,9196,
  	7,163,0,0,9195,9192,1,0,0,0,9195,9193,1,0,0,0,9196,1429,1,0,0,0,9197,
  	9200,4,715,251,0,9198,9201,3,1438,719,0,9199,9201,3,1436,718,0,9200,9198,
  	1,0,0,0,9200,9199,1,0,0,0,9201,9208,1,0,0,0,9202,9206,3,1428,714,0,9203,
  	9206,3,1422,711,0,9204,9206,3,1434,717,0,9205,9202,1,0,0,0,9205,9203,
  	1,0,0,0,9205,9204,1,0,0,0,9206,9208,1,0,0,0,9207,9197,1,0,0,0,9207,9205,
  	1,0,0,0,9208,1431,1,0,0,0,9209,9214,3,1428,714,0,9210,9214,3,1420,710,
  	0,9211,9214,3,1422,711,0,9212,9214,3,1426,713,0,9213,9209,1,0,0,0,9213,
  	9210,1,0,0,0,9213,9211,1,0,0,0,9213,9212,1,0,0,0,9214,1433,1,0,0,0,9215,
  	9216,7,164,0,0,9216,1435,1,0,0,0,9217,9223,7,165,0,0,9218,9219,4,718,
  	252,0,9219,9223,5,510,0,0,9220,9221,4,718,253,0,9221,9223,5,234,0,0,9222,
  	9217,1,0,0,0,9222,9218,1,0,0,0,9222,9220,1,0,0,0,9223,1437,1,0,0,0,9224,
  	9236,7,166,0,0,9225,9226,4,719,254,0,9226,9236,5,510,0,0,9227,9228,4,
  	719,255,0,9228,9236,7,167,0,0,9229,9230,4,719,256,0,9230,9236,7,168,0,
  	0,9231,9232,4,719,257,0,9232,9236,5,660,0,0,9233,9234,4,719,258,0,9234,
  	9236,5,306,0,0,9235,9224,1,0,0,0,9235,9225,1,0,0,0,9235,9227,1,0,0,0,
  	9235,9229,1,0,0,0,9235,9231,1,0,0,0,9235,9233,1,0,0,0,9236,1439,1,0,0,
  	0,1178,1442,1445,1447,1528,1536,1541,1551,1558,1565,1571,1574,1577,1584,
  	1589,1592,1597,1603,1605,1609,1613,1622,1626,1631,1637,1644,1649,1654,
  	1661,1664,1670,1673,1680,1690,1695,1700,1708,1714,1718,1723,1732,1738,
  	1744,1750,1759,1765,1774,1788,1792,1798,1802,1808,1812,1817,1820,1826,
  	1832,1838,1842,1847,1851,1855,1871,1879,1887,1894,1923,1938,1941,1950,
  	1955,1961,1966,1970,1975,1979,1983,1987,1991,1995,1997,2008,2016,2023,
  	2031,2035,2040,2047,2052,2057,2067,2071,2076,2079,2082,2085,2092,2099,
  	2103,2122,2128,2138,2141,2162,2166,2172,2179,2182,2186,2193,2196,2199,
  	2202,2211,2218,2223,2226,2229,2235,2241,2244,2249,2254,2263,2266,2272,
  	2278,2283,2292,2295,2303,2309,2314,2324,2327,2332,2351,2354,2357,2363,
  	2366,2368,2374,2384,2394,2397,2400,2404,2412,2425,2429,2434,2443,2460,
  	2479,2488,2491,2499,2504,2508,2515,2520,2535,2539,2545,2551,2557,2563,
  	2569,2574,2578,2586,2592,2598,2604,2609,2612,2615,2624,2627,2638,2643,
  	2654,2662,2666,2675,2678,2684,2686,2690,2697,2710,2717,2723,2726,2743,
  	2763,2767,2773,2779,2785,2790,2797,2804,2809,2812,2816,2820,2825,2829,
  	2833,2839,2844,2847,2851,2857,2861,2865,2873,2881,2890,2899,2912,2915,
  	2919,2925,2933,2938,2941,2944,2947,2950,2952,2958,2960,2974,2980,2987,
  	2990,2992,2994,3004,3006,3010,3013,3016,3020,3025,3031,3034,3037,3043,
  	3046,3055,3064,3068,3072,3078,3083,3088,3093,3097,3103,3114,3117,3122,
  	3128,3131,3134,3137,3140,3154,3157,3161,3165,3171,3176,3180,3185,3188,
  	3192,3198,3202,3206,3215,3221,3225,3229,3232,3236,3239,3241,3245,3251,
  	3255,3257,3261,3265,3269,3276,3278,3287,3293,3298,3301,3304,3307,3310,
  	3314,3329,3333,3339,3342,3345,3351,3356,3360,3363,3371,3373,3386,3398,
  	3403,3406,3409,3414,3420,3436,3456,3465,3469,3476,3481,3490,3497,3508,
  	3515,3524,3533,3545,3550,3557,3561,3567,3572,3577,3581,3587,3593,3595,
  	3598,3602,3612,3617,3622,3629,3638,3646,3651,3655,3661,3664,3667,3671,
  	3675,3685,3689,3692,3695,3700,3706,3710,3716,3719,3721,3726,3738,3747,
  	3760,3763,3768,3775,3779,3782,3788,3802,3809,3818,3824,3833,3837,3841,
  	3851,3853,3861,3868,3873,3877,3881,3884,3890,3893,3896,3902,3909,3914,
  	3918,3921,3924,3927,3929,3933,3940,3946,3950,3955,3958,3961,3964,3966,
  	3971,3980,3993,3995,3999,4005,4008,4011,4017,4024,4026,4034,4040,4045,
  	4048,4055,4057,4066,4075,4082,4085,4093,4097,4104,4107,4109,4117,4123,
  	4132,4139,4146,4277,4331,4338,4342,4358,4370,4373,4385,4390,4396,4403,
  	4410,4417,4424,4431,4438,4441,4448,4456,4464,4474,4480,4484,4487,4490,
  	4493,4496,4499,4504,4507,4514,4520,4544,4553,4557,4564,4570,4591,4597,
  	4603,4610,4618,4624,4636,4638,4644,4648,4650,4654,4666,4672,4678,4686,
  	4690,4694,4700,4702,4715,4719,4721,4723,4730,4741,4744,4746,4750,4755,
  	4757,4762,4768,4771,4773,4777,4780,4790,4800,4807,4809,4811,4819,4823,
  	4829,4832,4834,4844,4848,4854,4861,4863,4868,4870,4879,4887,4890,4895,
  	4900,4903,4909,4915,4918,4923,4934,4936,4948,4953,4961,4967,4969,4978,
  	4980,4986,4998,5003,5005,5009,5015,5018,5021,5031,5033,5039,5046,5052,
  	5062,5066,5071,5088,5104,5109,5117,5125,5130,5136,5139,5141,5150,5156,
  	5162,5164,5168,5179,5186,5192,5197,5202,5207,5215,5219,5224,5233,5245,
  	5259,5268,5270,5277,5284,5286,5290,5296,5304,5311,5315,5321,5328,5331,
  	5340,5346,5351,5374,5377,5393,5398,5401,5405,5408,5422,5428,5433,5436,
  	5438,5442,5447,5449,5461,5467,5482,5494,5498,5500,5508,5515,5530,5535,
  	5539,5543,5546,5550,5554,5557,5562,5565,5571,5574,5580,5583,5605,5611,
  	5614,5624,5631,5635,5638,5641,5648,5652,5655,5658,5663,5669,5672,5676,
  	5697,5702,5710,5715,5718,5722,5726,5730,5736,5740,5745,5750,5761,5763,
  	5769,5792,5795,5817,5824,5852,5854,5858,5870,5880,5890,5894,5902,5905,
  	5909,5919,5923,5930,5935,5943,5948,5954,5961,5966,5972,5979,5989,5991,
  	5998,6003,6007,6010,6017,6022,6026,6037,6045,6049,6052,6055,6059,6063,
  	6068,6074,6078,6089,6092,6095,6098,6106,6110,6115,6123,6131,6137,6154,
  	6166,6180,6183,6187,6198,6200,6209,6221,6223,6230,6236,6242,6250,6261,
  	6265,6294,6296,6302,6321,6328,6342,6353,6358,6370,6380,6387,6390,6424,
  	6432,6434,6446,6451,6457,6465,6473,6478,6483,6489,6494,6499,6505,6513,
  	6522,6527,6531,6535,6540,6542,6561,6569,6573,6580,6592,6595,6599,6604,
  	6610,6614,6618,6622,6627,6637,6646,6648,6651,6660,6667,6680,6685,6692,
  	6698,6724,6735,6767,6786,6792,6796,6823,6835,6848,6852,6856,6884,6934,
  	6944,6948,6960,6965,6981,7001,7005,7021,7024,7029,7032,7041,7045,7051,
  	7057,7061,7072,7078,7080,7087,7094,7098,7105,7110,7117,7127,7130,7135,
  	7140,7142,7146,7150,7163,7167,7170,7174,7178,7182,7189,7193,7197,7206,
  	7210,7217,7223,7231,7252,7257,7264,7287,7303,7313,7317,7324,7327,7338,
  	7347,7350,7357,7362,7388,7394,7400,7404,7414,7418,7431,7443,7459,7467,
  	7477,7480,7485,7489,7496,7501,7508,7516,7519,7524,7532,7535,7549,7552,
  	7565,7569,7571,7576,7581,7587,7593,7599,7604,7607,7613,7618,7621,7627,
  	7631,7637,7639,7642,7648,7654,7662,7664,7666,7670,7676,7681,7685,7690,
  	7696,7703,7706,7708,7711,7724,7728,7734,7741,7746,7760,7768,7774,7779,
  	7790,7794,7799,7803,7806,7811,7815,7823,7831,7833,7842,7850,7857,7860,
  	7868,7876,7878,7884,7890,7894,7904,7910,7913,7924,7933,7936,7941,7943,
  	7946,7949,7953,7956,7960,7965,7968,7972,7975,7979,7984,7988,8000,8004,
  	8010,8013,8018,8022,8026,8031,8040,8043,8047,8051,8054,8058,8062,8067,
  	8072,8078,8083,8088,8090,8095,8102,8110,8116,8118,8122,8126,8130,8134,
  	8149,8155,8162,8166,8171,8177,8181,8187,8191,8195,8200,8205,8210,8215,
  	8221,8227,8232,8237,8242,8247,8252,8257,8262,8272,8278,8284,8290,8293,
  	8300,8305,8314,8320,8325,8329,8332,8336,8341,8345,8350,8354,8363,8366,
  	8369,8372,8376,8380,8384,8399,8402,8404,8409,8418,8421,8425,8437,8449,
  	8454,8459,8468,8473,8482,8487,8491,8495,8499,8504,8509,8515,8520,8523,
  	8530,8539,8546,8560,8572,8585,8593,8600,8609,8615,8623,8629,8640,8648,
  	8655,8660,8664,8670,8681,8687,8724,8749,8761,8763,8768,8770,8777,8789,
  	8791,8797,8807,8816,8827,8849,8853,8877,8888,8890,8894,8901,8909,8916,
  	8922,8935,8939,8946,8955,8960,8962,8968,8984,8991,8996,9004,9007,9012,
  	9022,9030,9035,9040,9043,9047,9052,9062,9068,9082,9086,9098,9102,9106,
  	9110,9124,9132,9141,9155,9162,9164,9181,9186,9188,9195,9200,9205,9207,
  	9213,9222,9235
  };
  staticData->serializedATN = antlr4::atn::SerializedATNView(serializedATNSegment, sizeof(serializedATNSegment) / sizeof(serializedATNSegment[0]));

  antlr4::atn::ATNDeserializer deserializer;
  staticData->atn = deserializer.deserialize(staticData->serializedATN);

  const size_t count = staticData->atn->getNumberOfDecisions();
  staticData->decisionToDFA.reserve(count);
  for (size_t i = 0; i < count; i++) { 
    staticData->decisionToDFA.emplace_back(staticData->atn->getDecisionState(i), i);
  }
  mysqlparserParserStaticData = staticData.release();
}

}

MySQLParser::MySQLParser(TokenStream *input) : MySQLParser(input, antlr4::atn::ParserATNSimulatorOptions()) {}

MySQLParser::MySQLParser(TokenStream *input, const antlr4::atn::ParserATNSimulatorOptions &options) : MySQLBaseRecognizer(input) {
  MySQLParser::initialize();
  _interpreter = new atn::ParserATNSimulator(this, *mysqlparserParserStaticData->atn, mysqlparserParserStaticData->decisionToDFA, mysqlparserParserStaticData->sharedContextCache, options);
}

MySQLParser::~MySQLParser() {
  delete _interpreter;
}

const atn::ATN& MySQLParser::getATN() const {
  return *mysqlparserParserStaticData->atn;
}

std::string MySQLParser::getGrammarFileName() const {
  return "MySQLParser.g4";
}

const std::vector<std::string>& MySQLParser::getRuleNames() const {
  return mysqlparserParserStaticData->ruleNames;
}

const dfa::Vocabulary& MySQLParser::getVocabulary() const {
  return mysqlparserParserStaticData->vocabulary;
}

antlr4::atn::SerializedATNView MySQLParser::getSerializedATN() const {
  return mysqlparserParserStaticData->serializedATN;
}


//----------------- QueryContext ------------------------------------------------------------------

MySQLParser::QueryContext::QueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::SimpleStatementContext* MySQLParser::QueryContext::simpleStatement() {
  return getRuleContext<MySQLParser::SimpleStatementContext>(0);
}

MySQLParser::BeginWorkContext* MySQLParser::QueryContext::beginWork() {
  return getRuleContext<MySQLParser::BeginWorkContext>(0);
}

tree::TerminalNode* MySQLParser::QueryContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::QueryContext::getRuleIndex() const {
  return MySQLParser::RuleQuery;
}

void MySQLParser::QueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuery(this);
}

void MySQLParser::QueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuery(this);
}


std::any MySQLParser::QueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryContext* MySQLParser::query() {
  QueryContext *_localctx = _tracker.createInstance<QueryContext>(_ctx, getState());
  enterRule(_localctx, 0, MySQLParser::RuleQuery);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1447);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 2, _ctx)) {
    case 1: {
      setState(1442);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 0, _ctx)) {
      case 1: {
        setState(1440);
        simpleStatement();
        break;
      }

      case 2: {
        setState(1441);
        beginWork();
        break;
      }

      default:
        break;
      }
      setState(1445);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::SEMICOLON_SYMBOL) {
        setState(1444);
        match(MySQLParser::SEMICOLON_SYMBOL);
      }
      break;
    }

    default:
      break;
    }
    setState(1449);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleStatementContext ------------------------------------------------------------------

MySQLParser::SimpleStatementContext::SimpleStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterStatementContext* MySQLParser::SimpleStatementContext::alterStatement() {
  return getRuleContext<MySQLParser::AlterStatementContext>(0);
}

MySQLParser::CreateStatementContext* MySQLParser::SimpleStatementContext::createStatement() {
  return getRuleContext<MySQLParser::CreateStatementContext>(0);
}

MySQLParser::DropStatementContext* MySQLParser::SimpleStatementContext::dropStatement() {
  return getRuleContext<MySQLParser::DropStatementContext>(0);
}

MySQLParser::RenameTableStatementContext* MySQLParser::SimpleStatementContext::renameTableStatement() {
  return getRuleContext<MySQLParser::RenameTableStatementContext>(0);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::SimpleStatementContext::truncateTableStatement() {
  return getRuleContext<MySQLParser::TruncateTableStatementContext>(0);
}

MySQLParser::ImportStatementContext* MySQLParser::SimpleStatementContext::importStatement() {
  return getRuleContext<MySQLParser::ImportStatementContext>(0);
}

MySQLParser::CallStatementContext* MySQLParser::SimpleStatementContext::callStatement() {
  return getRuleContext<MySQLParser::CallStatementContext>(0);
}

MySQLParser::DeleteStatementContext* MySQLParser::SimpleStatementContext::deleteStatement() {
  return getRuleContext<MySQLParser::DeleteStatementContext>(0);
}

MySQLParser::DoStatementContext* MySQLParser::SimpleStatementContext::doStatement() {
  return getRuleContext<MySQLParser::DoStatementContext>(0);
}

MySQLParser::HandlerStatementContext* MySQLParser::SimpleStatementContext::handlerStatement() {
  return getRuleContext<MySQLParser::HandlerStatementContext>(0);
}

MySQLParser::InsertStatementContext* MySQLParser::SimpleStatementContext::insertStatement() {
  return getRuleContext<MySQLParser::InsertStatementContext>(0);
}

MySQLParser::LoadStatementContext* MySQLParser::SimpleStatementContext::loadStatement() {
  return getRuleContext<MySQLParser::LoadStatementContext>(0);
}

MySQLParser::ReplaceStatementContext* MySQLParser::SimpleStatementContext::replaceStatement() {
  return getRuleContext<MySQLParser::ReplaceStatementContext>(0);
}

MySQLParser::SelectStatementContext* MySQLParser::SimpleStatementContext::selectStatement() {
  return getRuleContext<MySQLParser::SelectStatementContext>(0);
}

MySQLParser::UpdateStatementContext* MySQLParser::SimpleStatementContext::updateStatement() {
  return getRuleContext<MySQLParser::UpdateStatementContext>(0);
}

MySQLParser::TransactionOrLockingStatementContext* MySQLParser::SimpleStatementContext::transactionOrLockingStatement() {
  return getRuleContext<MySQLParser::TransactionOrLockingStatementContext>(0);
}

MySQLParser::ReplicationStatementContext* MySQLParser::SimpleStatementContext::replicationStatement() {
  return getRuleContext<MySQLParser::ReplicationStatementContext>(0);
}

MySQLParser::PreparedStatementContext* MySQLParser::SimpleStatementContext::preparedStatement() {
  return getRuleContext<MySQLParser::PreparedStatementContext>(0);
}

MySQLParser::CloneStatementContext* MySQLParser::SimpleStatementContext::cloneStatement() {
  return getRuleContext<MySQLParser::CloneStatementContext>(0);
}

MySQLParser::AccountManagementStatementContext* MySQLParser::SimpleStatementContext::accountManagementStatement() {
  return getRuleContext<MySQLParser::AccountManagementStatementContext>(0);
}

MySQLParser::TableAdministrationStatementContext* MySQLParser::SimpleStatementContext::tableAdministrationStatement() {
  return getRuleContext<MySQLParser::TableAdministrationStatementContext>(0);
}

MySQLParser::InstallUninstallStatementContext* MySQLParser::SimpleStatementContext::installUninstallStatement() {
  return getRuleContext<MySQLParser::InstallUninstallStatementContext>(0);
}

MySQLParser::SetStatementContext* MySQLParser::SimpleStatementContext::setStatement() {
  return getRuleContext<MySQLParser::SetStatementContext>(0);
}

MySQLParser::ShowDatabasesStatementContext* MySQLParser::SimpleStatementContext::showDatabasesStatement() {
  return getRuleContext<MySQLParser::ShowDatabasesStatementContext>(0);
}

MySQLParser::ShowTablesStatementContext* MySQLParser::SimpleStatementContext::showTablesStatement() {
  return getRuleContext<MySQLParser::ShowTablesStatementContext>(0);
}

MySQLParser::ShowTriggersStatementContext* MySQLParser::SimpleStatementContext::showTriggersStatement() {
  return getRuleContext<MySQLParser::ShowTriggersStatementContext>(0);
}

MySQLParser::ShowEventsStatementContext* MySQLParser::SimpleStatementContext::showEventsStatement() {
  return getRuleContext<MySQLParser::ShowEventsStatementContext>(0);
}

MySQLParser::ShowTableStatusStatementContext* MySQLParser::SimpleStatementContext::showTableStatusStatement() {
  return getRuleContext<MySQLParser::ShowTableStatusStatementContext>(0);
}

MySQLParser::ShowOpenTablesStatementContext* MySQLParser::SimpleStatementContext::showOpenTablesStatement() {
  return getRuleContext<MySQLParser::ShowOpenTablesStatementContext>(0);
}

MySQLParser::ShowPluginsStatementContext* MySQLParser::SimpleStatementContext::showPluginsStatement() {
  return getRuleContext<MySQLParser::ShowPluginsStatementContext>(0);
}

MySQLParser::ShowEngineLogsStatementContext* MySQLParser::SimpleStatementContext::showEngineLogsStatement() {
  return getRuleContext<MySQLParser::ShowEngineLogsStatementContext>(0);
}

MySQLParser::ShowEngineMutexStatementContext* MySQLParser::SimpleStatementContext::showEngineMutexStatement() {
  return getRuleContext<MySQLParser::ShowEngineMutexStatementContext>(0);
}

MySQLParser::ShowEngineStatusStatementContext* MySQLParser::SimpleStatementContext::showEngineStatusStatement() {
  return getRuleContext<MySQLParser::ShowEngineStatusStatementContext>(0);
}

MySQLParser::ShowColumnsStatementContext* MySQLParser::SimpleStatementContext::showColumnsStatement() {
  return getRuleContext<MySQLParser::ShowColumnsStatementContext>(0);
}

MySQLParser::ShowBinaryLogsStatementContext* MySQLParser::SimpleStatementContext::showBinaryLogsStatement() {
  return getRuleContext<MySQLParser::ShowBinaryLogsStatementContext>(0);
}

MySQLParser::ShowReplicasStatementContext* MySQLParser::SimpleStatementContext::showReplicasStatement() {
  return getRuleContext<MySQLParser::ShowReplicasStatementContext>(0);
}

MySQLParser::ShowBinlogEventsStatementContext* MySQLParser::SimpleStatementContext::showBinlogEventsStatement() {
  return getRuleContext<MySQLParser::ShowBinlogEventsStatementContext>(0);
}

MySQLParser::ShowRelaylogEventsStatementContext* MySQLParser::SimpleStatementContext::showRelaylogEventsStatement() {
  return getRuleContext<MySQLParser::ShowRelaylogEventsStatementContext>(0);
}

MySQLParser::ShowKeysStatementContext* MySQLParser::SimpleStatementContext::showKeysStatement() {
  return getRuleContext<MySQLParser::ShowKeysStatementContext>(0);
}

MySQLParser::ShowEnginesStatementContext* MySQLParser::SimpleStatementContext::showEnginesStatement() {
  return getRuleContext<MySQLParser::ShowEnginesStatementContext>(0);
}

MySQLParser::ShowCountWarningsStatementContext* MySQLParser::SimpleStatementContext::showCountWarningsStatement() {
  return getRuleContext<MySQLParser::ShowCountWarningsStatementContext>(0);
}

MySQLParser::ShowCountErrorsStatementContext* MySQLParser::SimpleStatementContext::showCountErrorsStatement() {
  return getRuleContext<MySQLParser::ShowCountErrorsStatementContext>(0);
}

MySQLParser::ShowWarningsStatementContext* MySQLParser::SimpleStatementContext::showWarningsStatement() {
  return getRuleContext<MySQLParser::ShowWarningsStatementContext>(0);
}

MySQLParser::ShowErrorsStatementContext* MySQLParser::SimpleStatementContext::showErrorsStatement() {
  return getRuleContext<MySQLParser::ShowErrorsStatementContext>(0);
}

MySQLParser::ShowProfilesStatementContext* MySQLParser::SimpleStatementContext::showProfilesStatement() {
  return getRuleContext<MySQLParser::ShowProfilesStatementContext>(0);
}

MySQLParser::ShowProfileStatementContext* MySQLParser::SimpleStatementContext::showProfileStatement() {
  return getRuleContext<MySQLParser::ShowProfileStatementContext>(0);
}

MySQLParser::ShowStatusStatementContext* MySQLParser::SimpleStatementContext::showStatusStatement() {
  return getRuleContext<MySQLParser::ShowStatusStatementContext>(0);
}

MySQLParser::ShowProcessListStatementContext* MySQLParser::SimpleStatementContext::showProcessListStatement() {
  return getRuleContext<MySQLParser::ShowProcessListStatementContext>(0);
}

MySQLParser::ShowVariablesStatementContext* MySQLParser::SimpleStatementContext::showVariablesStatement() {
  return getRuleContext<MySQLParser::ShowVariablesStatementContext>(0);
}

MySQLParser::ShowCharacterSetStatementContext* MySQLParser::SimpleStatementContext::showCharacterSetStatement() {
  return getRuleContext<MySQLParser::ShowCharacterSetStatementContext>(0);
}

MySQLParser::ShowCollationStatementContext* MySQLParser::SimpleStatementContext::showCollationStatement() {
  return getRuleContext<MySQLParser::ShowCollationStatementContext>(0);
}

MySQLParser::ShowPrivilegesStatementContext* MySQLParser::SimpleStatementContext::showPrivilegesStatement() {
  return getRuleContext<MySQLParser::ShowPrivilegesStatementContext>(0);
}

MySQLParser::ShowGrantsStatementContext* MySQLParser::SimpleStatementContext::showGrantsStatement() {
  return getRuleContext<MySQLParser::ShowGrantsStatementContext>(0);
}

MySQLParser::ShowCreateDatabaseStatementContext* MySQLParser::SimpleStatementContext::showCreateDatabaseStatement() {
  return getRuleContext<MySQLParser::ShowCreateDatabaseStatementContext>(0);
}

MySQLParser::ShowCreateTableStatementContext* MySQLParser::SimpleStatementContext::showCreateTableStatement() {
  return getRuleContext<MySQLParser::ShowCreateTableStatementContext>(0);
}

MySQLParser::ShowCreateViewStatementContext* MySQLParser::SimpleStatementContext::showCreateViewStatement() {
  return getRuleContext<MySQLParser::ShowCreateViewStatementContext>(0);
}

MySQLParser::ShowMasterStatusStatementContext* MySQLParser::SimpleStatementContext::showMasterStatusStatement() {
  return getRuleContext<MySQLParser::ShowMasterStatusStatementContext>(0);
}

MySQLParser::ShowReplicaStatusStatementContext* MySQLParser::SimpleStatementContext::showReplicaStatusStatement() {
  return getRuleContext<MySQLParser::ShowReplicaStatusStatementContext>(0);
}

MySQLParser::ShowCreateProcedureStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureStatementContext>(0);
}

MySQLParser::ShowCreateFunctionStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionStatementContext>(0);
}

MySQLParser::ShowCreateTriggerStatementContext* MySQLParser::SimpleStatementContext::showCreateTriggerStatement() {
  return getRuleContext<MySQLParser::ShowCreateTriggerStatementContext>(0);
}

MySQLParser::ShowCreateProcedureStatusStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureStatusStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureStatusStatementContext>(0);
}

MySQLParser::ShowCreateFunctionStatusStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionStatusStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionStatusStatementContext>(0);
}

MySQLParser::ShowCreateProcedureCodeStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureCodeStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureCodeStatementContext>(0);
}

MySQLParser::ShowCreateFunctionCodeStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionCodeStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionCodeStatementContext>(0);
}

MySQLParser::ShowCreateEventStatementContext* MySQLParser::SimpleStatementContext::showCreateEventStatement() {
  return getRuleContext<MySQLParser::ShowCreateEventStatementContext>(0);
}

MySQLParser::ShowCreateUserStatementContext* MySQLParser::SimpleStatementContext::showCreateUserStatement() {
  return getRuleContext<MySQLParser::ShowCreateUserStatementContext>(0);
}

MySQLParser::ResourceGroupManagementContext* MySQLParser::SimpleStatementContext::resourceGroupManagement() {
  return getRuleContext<MySQLParser::ResourceGroupManagementContext>(0);
}

MySQLParser::OtherAdministrativeStatementContext* MySQLParser::SimpleStatementContext::otherAdministrativeStatement() {
  return getRuleContext<MySQLParser::OtherAdministrativeStatementContext>(0);
}

MySQLParser::UtilityStatementContext* MySQLParser::SimpleStatementContext::utilityStatement() {
  return getRuleContext<MySQLParser::UtilityStatementContext>(0);
}

MySQLParser::GetDiagnosticsStatementContext* MySQLParser::SimpleStatementContext::getDiagnosticsStatement() {
  return getRuleContext<MySQLParser::GetDiagnosticsStatementContext>(0);
}

MySQLParser::SignalStatementContext* MySQLParser::SimpleStatementContext::signalStatement() {
  return getRuleContext<MySQLParser::SignalStatementContext>(0);
}

MySQLParser::ResignalStatementContext* MySQLParser::SimpleStatementContext::resignalStatement() {
  return getRuleContext<MySQLParser::ResignalStatementContext>(0);
}


size_t MySQLParser::SimpleStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleStatement;
}

void MySQLParser::SimpleStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleStatement(this);
}

void MySQLParser::SimpleStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleStatement(this);
}


std::any MySQLParser::SimpleStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleStatementContext* MySQLParser::simpleStatement() {
  SimpleStatementContext *_localctx = _tracker.createInstance<SimpleStatementContext>(_ctx, getState());
  enterRule(_localctx, 2, MySQLParser::RuleSimpleStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1528);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 3, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1451);
      alterStatement();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1452);
      createStatement();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1453);
      dropStatement();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1454);
      renameTableStatement();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1455);
      truncateTableStatement();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1456);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1457);
      importStatement();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1458);
      callStatement();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1459);
      deleteStatement();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1460);
      doStatement();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1461);
      handlerStatement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1462);
      insertStatement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1463);
      loadStatement();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1464);
      replaceStatement();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1465);
      selectStatement();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1466);
      updateStatement();
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1467);
      transactionOrLockingStatement();
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1468);
      replicationStatement();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(1469);
      preparedStatement();
      break;
    }

    case 19: {
      enterOuterAlt(_localctx, 19);
      setState(1470);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1471);
      cloneStatement();
      break;
    }

    case 20: {
      enterOuterAlt(_localctx, 20);
      setState(1472);
      accountManagementStatement();
      break;
    }

    case 21: {
      enterOuterAlt(_localctx, 21);
      setState(1473);
      tableAdministrationStatement();
      break;
    }

    case 22: {
      enterOuterAlt(_localctx, 22);
      setState(1474);
      installUninstallStatement();
      break;
    }

    case 23: {
      enterOuterAlt(_localctx, 23);
      setState(1475);
      setStatement();
      break;
    }

    case 24: {
      enterOuterAlt(_localctx, 24);
      setState(1476);
      showDatabasesStatement();
      break;
    }

    case 25: {
      enterOuterAlt(_localctx, 25);
      setState(1477);
      showTablesStatement();
      break;
    }

    case 26: {
      enterOuterAlt(_localctx, 26);
      setState(1478);
      showTriggersStatement();
      break;
    }

    case 27: {
      enterOuterAlt(_localctx, 27);
      setState(1479);
      showEventsStatement();
      break;
    }

    case 28: {
      enterOuterAlt(_localctx, 28);
      setState(1480);
      showTableStatusStatement();
      break;
    }

    case 29: {
      enterOuterAlt(_localctx, 29);
      setState(1481);
      showOpenTablesStatement();
      break;
    }

    case 30: {
      enterOuterAlt(_localctx, 30);
      setState(1482);
      showPluginsStatement();
      break;
    }

    case 31: {
      enterOuterAlt(_localctx, 31);
      setState(1483);
      showEngineLogsStatement();
      break;
    }

    case 32: {
      enterOuterAlt(_localctx, 32);
      setState(1484);
      showEngineMutexStatement();
      break;
    }

    case 33: {
      enterOuterAlt(_localctx, 33);
      setState(1485);
      showEngineStatusStatement();
      break;
    }

    case 34: {
      enterOuterAlt(_localctx, 34);
      setState(1486);
      showColumnsStatement();
      break;
    }

    case 35: {
      enterOuterAlt(_localctx, 35);
      setState(1487);
      showBinaryLogsStatement();
      break;
    }

    case 36: {
      enterOuterAlt(_localctx, 36);
      setState(1488);
      showReplicasStatement();
      break;
    }

    case 37: {
      enterOuterAlt(_localctx, 37);
      setState(1489);
      showBinlogEventsStatement();
      break;
    }

    case 38: {
      enterOuterAlt(_localctx, 38);
      setState(1490);
      showRelaylogEventsStatement();
      break;
    }

    case 39: {
      enterOuterAlt(_localctx, 39);
      setState(1491);
      showKeysStatement();
      break;
    }

    case 40: {
      enterOuterAlt(_localctx, 40);
      setState(1492);
      showEnginesStatement();
      break;
    }

    case 41: {
      enterOuterAlt(_localctx, 41);
      setState(1493);
      showCountWarningsStatement();
      break;
    }

    case 42: {
      enterOuterAlt(_localctx, 42);
      setState(1494);
      showCountErrorsStatement();
      break;
    }

    case 43: {
      enterOuterAlt(_localctx, 43);
      setState(1495);
      showWarningsStatement();
      break;
    }

    case 44: {
      enterOuterAlt(_localctx, 44);
      setState(1496);
      showErrorsStatement();
      break;
    }

    case 45: {
      enterOuterAlt(_localctx, 45);
      setState(1497);
      showProfilesStatement();
      break;
    }

    case 46: {
      enterOuterAlt(_localctx, 46);
      setState(1498);
      showProfileStatement();
      break;
    }

    case 47: {
      enterOuterAlt(_localctx, 47);
      setState(1499);
      showStatusStatement();
      break;
    }

    case 48: {
      enterOuterAlt(_localctx, 48);
      setState(1500);
      showProcessListStatement();
      break;
    }

    case 49: {
      enterOuterAlt(_localctx, 49);
      setState(1501);
      showVariablesStatement();
      break;
    }

    case 50: {
      enterOuterAlt(_localctx, 50);
      setState(1502);
      showCharacterSetStatement();
      break;
    }

    case 51: {
      enterOuterAlt(_localctx, 51);
      setState(1503);
      showCollationStatement();
      break;
    }

    case 52: {
      enterOuterAlt(_localctx, 52);
      setState(1504);
      showPrivilegesStatement();
      break;
    }

    case 53: {
      enterOuterAlt(_localctx, 53);
      setState(1505);
      showGrantsStatement();
      break;
    }

    case 54: {
      enterOuterAlt(_localctx, 54);
      setState(1506);
      showCreateDatabaseStatement();
      break;
    }

    case 55: {
      enterOuterAlt(_localctx, 55);
      setState(1507);
      showCreateTableStatement();
      break;
    }

    case 56: {
      enterOuterAlt(_localctx, 56);
      setState(1508);
      showCreateViewStatement();
      break;
    }

    case 57: {
      enterOuterAlt(_localctx, 57);
      setState(1509);
      showMasterStatusStatement();
      break;
    }

    case 58: {
      enterOuterAlt(_localctx, 58);
      setState(1510);
      showReplicaStatusStatement();
      break;
    }

    case 59: {
      enterOuterAlt(_localctx, 59);
      setState(1511);
      showCreateProcedureStatement();
      break;
    }

    case 60: {
      enterOuterAlt(_localctx, 60);
      setState(1512);
      showCreateFunctionStatement();
      break;
    }

    case 61: {
      enterOuterAlt(_localctx, 61);
      setState(1513);
      showCreateTriggerStatement();
      break;
    }

    case 62: {
      enterOuterAlt(_localctx, 62);
      setState(1514);
      showCreateProcedureStatusStatement();
      break;
    }

    case 63: {
      enterOuterAlt(_localctx, 63);
      setState(1515);
      showCreateFunctionStatusStatement();
      break;
    }

    case 64: {
      enterOuterAlt(_localctx, 64);
      setState(1516);
      showCreateProcedureCodeStatement();
      break;
    }

    case 65: {
      enterOuterAlt(_localctx, 65);
      setState(1517);
      showCreateFunctionCodeStatement();
      break;
    }

    case 66: {
      enterOuterAlt(_localctx, 66);
      setState(1518);
      showCreateEventStatement();
      break;
    }

    case 67: {
      enterOuterAlt(_localctx, 67);
      setState(1519);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1520);
      showCreateUserStatement();
      break;
    }

    case 68: {
      enterOuterAlt(_localctx, 68);
      setState(1521);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1522);
      resourceGroupManagement();
      break;
    }

    case 69: {
      enterOuterAlt(_localctx, 69);
      setState(1523);
      otherAdministrativeStatement();
      break;
    }

    case 70: {
      enterOuterAlt(_localctx, 70);
      setState(1524);
      utilityStatement();
      break;
    }

    case 71: {
      enterOuterAlt(_localctx, 71);
      setState(1525);
      getDiagnosticsStatement();
      break;
    }

    case 72: {
      enterOuterAlt(_localctx, 72);
      setState(1526);
      signalStatement();
      break;
    }

    case 73: {
      enterOuterAlt(_localctx, 73);
      setState(1527);
      resignalStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterStatementContext ------------------------------------------------------------------

MySQLParser::AlterStatementContext::AlterStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterStatementContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

MySQLParser::AlterTableContext* MySQLParser::AlterStatementContext::alterTable() {
  return getRuleContext<MySQLParser::AlterTableContext>(0);
}

MySQLParser::AlterDatabaseContext* MySQLParser::AlterStatementContext::alterDatabase() {
  return getRuleContext<MySQLParser::AlterDatabaseContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::AlterStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::AlterStatementContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::AlterViewContext* MySQLParser::AlterStatementContext::alterView() {
  return getRuleContext<MySQLParser::AlterViewContext>(0);
}

MySQLParser::AlterEventContext* MySQLParser::AlterStatementContext::alterEvent() {
  return getRuleContext<MySQLParser::AlterEventContext>(0);
}

MySQLParser::AlterTablespaceContext* MySQLParser::AlterStatementContext::alterTablespace() {
  return getRuleContext<MySQLParser::AlterTablespaceContext>(0);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::AlterStatementContext::alterUndoTablespace() {
  return getRuleContext<MySQLParser::AlterUndoTablespaceContext>(0);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::AlterStatementContext::alterLogfileGroup() {
  return getRuleContext<MySQLParser::AlterLogfileGroupContext>(0);
}

MySQLParser::AlterServerContext* MySQLParser::AlterStatementContext::alterServer() {
  return getRuleContext<MySQLParser::AlterServerContext>(0);
}

MySQLParser::AlterInstanceStatementContext* MySQLParser::AlterStatementContext::alterInstanceStatement() {
  return getRuleContext<MySQLParser::AlterInstanceStatementContext>(0);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::AlterStatementContext::routineAlterOptions() {
  return getRuleContext<MySQLParser::RoutineAlterOptionsContext>(0);
}


size_t MySQLParser::AlterStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterStatement;
}

void MySQLParser::AlterStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterStatement(this);
}

void MySQLParser::AlterStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterStatement(this);
}


std::any MySQLParser::AlterStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterStatementContext* MySQLParser::alterStatement() {
  AlterStatementContext *_localctx = _tracker.createInstance<AlterStatementContext>(_ctx, getState());
  enterRule(_localctx, 4, MySQLParser::RuleAlterStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1530);
    match(MySQLParser::ALTER_SYMBOL);
    setState(1551);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 6, _ctx)) {
    case 1: {
      setState(1531);
      alterTable();
      break;
    }

    case 2: {
      setState(1532);
      alterDatabase();
      break;
    }

    case 3: {
      setState(1533);
      match(MySQLParser::PROCEDURE_SYMBOL);
      setState(1534);
      procedureRef();
      setState(1536);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 75) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 75)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 75))
        | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 75))
        | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 75)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 347) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 347)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 347))
        | (1ULL << (MySQLParser::NOT_SYMBOL - 347))
        | (1ULL << (MySQLParser::NO_SYMBOL - 347)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1535);
        routineAlterOptions();
      }
      break;
    }

    case 4: {
      setState(1538);
      match(MySQLParser::FUNCTION_SYMBOL);
      setState(1539);
      functionRef();
      setState(1541);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 75) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 75)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 75))
        | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 75))
        | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 75)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 347) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 347)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 347))
        | (1ULL << (MySQLParser::NOT_SYMBOL - 347))
        | (1ULL << (MySQLParser::NO_SYMBOL - 347)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1540);
        routineAlterOptions();
      }
      break;
    }

    case 5: {
      setState(1543);
      alterView();
      break;
    }

    case 6: {
      setState(1544);
      alterEvent();
      break;
    }

    case 7: {
      setState(1545);
      alterTablespace();
      break;
    }

    case 8: {
      setState(1546);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1547);
      alterUndoTablespace();
      break;
    }

    case 9: {
      setState(1548);
      alterLogfileGroup();
      break;
    }

    case 10: {
      setState(1549);
      alterServer();
      break;
    }

    case 11: {
      setState(1550);
      alterInstanceStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseContext::AlterDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::AlterDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DIRECTORY_SYMBOL() {
  return getToken(MySQLParser::DIRECTORY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

std::vector<MySQLParser::AlterDatabaseOptionContext *> MySQLParser::AlterDatabaseContext::alterDatabaseOption() {
  return getRuleContexts<MySQLParser::AlterDatabaseOptionContext>();
}

MySQLParser::AlterDatabaseOptionContext* MySQLParser::AlterDatabaseContext::alterDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::AlterDatabaseOptionContext>(i);
}


size_t MySQLParser::AlterDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabase;
}

void MySQLParser::AlterDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabase(this);
}

void MySQLParser::AlterDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabase(this);
}


std::any MySQLParser::AlterDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseContext* MySQLParser::alterDatabase() {
  AlterDatabaseContext *_localctx = _tracker.createInstance<AlterDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 6, MySQLParser::RuleAlterDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1553);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(1554);
    schemaRef();
    setState(1565);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 8, _ctx)) {
    case 1: {
      setState(1556); 
      _errHandler->sync(this);
      alt = 1;
      do {
        switch (alt) {
          case 1: {
                setState(1555);
                alterDatabaseOption();
                break;
              }

        default:
          throw NoViableAltException(this);
        }
        setState(1558); 
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 7, _ctx);
      } while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER);
      break;
    }

    case 2: {
      setState(1560);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(1561);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(1562);
      match(MySQLParser::DATA_SYMBOL);
      setState(1563);
      match(MySQLParser::DIRECTORY_SYMBOL);
      setState(1564);
      match(MySQLParser::NAME_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseOptionContext::AlterDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::AlterDatabaseOptionContext::createDatabaseOption() {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::ONLY_SYMBOL() {
  return getToken(MySQLParser::ONLY_SYMBOL, 0);
}

MySQLParser::TernaryOptionContext* MySQLParser::AlterDatabaseOptionContext::ternaryOption() {
  return getRuleContext<MySQLParser::TernaryOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabaseOption;
}

void MySQLParser::AlterDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabaseOption(this);
}

void MySQLParser::AlterDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabaseOption(this);
}


std::any MySQLParser::AlterDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseOptionContext* MySQLParser::alterDatabaseOption() {
  AlterDatabaseOptionContext *_localctx = _tracker.createInstance<AlterDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 8, MySQLParser::RuleAlterDatabaseOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1574);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 10, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1567);
      createDatabaseOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1568);
      match(MySQLParser::READ_SYMBOL);
      setState(1569);
      match(MySQLParser::ONLY_SYMBOL);
      setState(1571);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::EQUAL_OPERATOR) {
        setState(1570);
        match(MySQLParser::EQUAL_OPERATOR);
      }
      setState(1573);
      ternaryOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterEventContext ------------------------------------------------------------------

MySQLParser::AlterEventContext::AlterEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::AlterEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::AlterEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::AlterEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterEventContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::AlterEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

MySQLParser::ReplicaContext* MySQLParser::AlterEventContext::replica() {
  return getRuleContext<MySQLParser::ReplicaContext>(0);
}


size_t MySQLParser::AlterEventContext::getRuleIndex() const {
  return MySQLParser::RuleAlterEvent;
}

void MySQLParser::AlterEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterEvent(this);
}

void MySQLParser::AlterEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterEvent(this);
}


std::any MySQLParser::AlterEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterEventContext* MySQLParser::alterEvent() {
  AlterEventContext *_localctx = _tracker.createInstance<AlterEventContext>(_ctx, getState());
  enterRule(_localctx, 10, MySQLParser::RuleAlterEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1577);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(1576);
      definerClause();
    }
    setState(1579);
    match(MySQLParser::EVENT_SYMBOL);
    setState(1580);
    eventRef();
    setState(1584);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 12, _ctx)) {
    case 1: {
      setState(1581);
      match(MySQLParser::ON_SYMBOL);
      setState(1582);
      match(MySQLParser::SCHEDULE_SYMBOL);
      setState(1583);
      schedule();
      break;
    }

    default:
      break;
    }
    setState(1592);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(1586);
      match(MySQLParser::ON_SYMBOL);
      setState(1587);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(1589);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(1588);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(1591);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(1597);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RENAME_SYMBOL) {
      setState(1594);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1595);
      match(MySQLParser::TO_SYMBOL);
      setState(1596);
      identifier();
    }
    setState(1605);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(1599);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(1600);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(1603);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(1601);
          match(MySQLParser::ON_SYMBOL);
          setState(1602);
          replica();
        }
        break;
      }

      case MySQLParser::EOF:
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL:
      case MySQLParser::SEMICOLON_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(1609);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(1607);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(1608);
      textLiteral();
    }
    setState(1613);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DO_SYMBOL) {
      setState(1611);
      match(MySQLParser::DO_SYMBOL);
      setState(1612);
      compoundStatement();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupContext::AlterLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::AlterLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::AlterLogfileGroupContext::alterLogfileGroupOptions() {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionsContext>(0);
}


size_t MySQLParser::AlterLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroup;
}

void MySQLParser::AlterLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroup(this);
}

void MySQLParser::AlterLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroup(this);
}


std::any MySQLParser::AlterLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::alterLogfileGroup() {
  AlterLogfileGroupContext *_localctx = _tracker.createInstance<AlterLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 12, MySQLParser::RuleAlterLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1615);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(1616);
    match(MySQLParser::GROUP_SYMBOL);
    setState(1617);
    logfileGroupRef();
    setState(1618);
    match(MySQLParser::ADD_SYMBOL);
    setState(1619);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(1620);
    textLiteral();
    setState(1622);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(1621);
      alterLogfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionsContext::AlterLogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterLogfileGroupOptionContext *> MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption() {
  return getRuleContexts<MySQLParser::AlterLogfileGroupOptionContext>();
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterLogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOptions;
}

void MySQLParser::AlterLogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOptions(this);
}

void MySQLParser::AlterLogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOptions(this);
}


std::any MySQLParser::AlterLogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::alterLogfileGroupOptions() {
  AlterLogfileGroupOptionsContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 14, MySQLParser::RuleAlterLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1624);
    alterLogfileGroupOption();
    setState(1631);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(1626);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1625);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(1628);
      alterLogfileGroupOption();
      setState(1633);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionContext::AlterLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}


size_t MySQLParser::AlterLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOption;
}

void MySQLParser::AlterLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOption(this);
}

void MySQLParser::AlterLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOption(this);
}


std::any MySQLParser::AlterLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::alterLogfileGroupOption() {
  AlterLogfileGroupOptionContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 16, MySQLParser::RuleAlterLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1637);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1634);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1635);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(1636);
        tsOptionWait();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterServerContext ------------------------------------------------------------------

MySQLParser::AlterServerContext::AlterServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::AlterServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::AlterServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::AlterServerContext::getRuleIndex() const {
  return MySQLParser::RuleAlterServer;
}

void MySQLParser::AlterServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterServer(this);
}

void MySQLParser::AlterServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterServer(this);
}


std::any MySQLParser::AlterServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterServerContext* MySQLParser::alterServer() {
  AlterServerContext *_localctx = _tracker.createInstance<AlterServerContext>(_ctx, getState());
  enterRule(_localctx, 18, MySQLParser::RuleAlterServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1639);
    match(MySQLParser::SERVER_SYMBOL);
    setState(1640);
    serverRef();
    setState(1641);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableContext ------------------------------------------------------------------

MySQLParser::AlterTableContext::AlterTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::OnlineOptionContext* MySQLParser::AlterTableContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::AlterTableActionsContext* MySQLParser::AlterTableContext::alterTableActions() {
  return getRuleContext<MySQLParser::AlterTableActionsContext>(0);
}


size_t MySQLParser::AlterTableContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTable;
}

void MySQLParser::AlterTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTable(this);
}

void MySQLParser::AlterTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTable(this);
}


std::any MySQLParser::AlterTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableContext* MySQLParser::alterTable() {
  AlterTableContext *_localctx = _tracker.createInstance<AlterTableContext>(_ctx, getState());
  enterRule(_localctx, 20, MySQLParser::RuleAlterTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1644);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(1643);
      onlineOption();
    }
    setState(1646);
    match(MySQLParser::TABLE_SYMBOL);
    setState(1647);
    tableRef();
    setState(1649);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 25, _ctx)) {
    case 1: {
      setState(1648);
      alterTableActions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableActionsContext ------------------------------------------------------------------

MySQLParser::AlterTableActionsContext::AlterTableActionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandListContext* MySQLParser::AlterTableActionsContext::alterCommandList() {
  return getRuleContext<MySQLParser::AlterCommandListContext>(0);
}

MySQLParser::PartitionClauseContext* MySQLParser::AlterTableActionsContext::partitionClause() {
  return getRuleContext<MySQLParser::PartitionClauseContext>(0);
}

MySQLParser::RemovePartitioningContext* MySQLParser::AlterTableActionsContext::removePartitioning() {
  return getRuleContext<MySQLParser::RemovePartitioningContext>(0);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::AlterTableActionsContext::standaloneAlterCommands() {
  return getRuleContext<MySQLParser::StandaloneAlterCommandsContext>(0);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterTableActionsContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTableActionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterTableActionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTableActions;
}

void MySQLParser::AlterTableActionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTableActions(this);
}

void MySQLParser::AlterTableActionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTableActions(this);
}


std::any MySQLParser::AlterTableActionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTableActions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableActionsContext* MySQLParser::alterTableActions() {
  AlterTableActionsContext *_localctx = _tracker.createInstance<AlterTableActionsContext>(_ctx, getState());
  enterRule(_localctx, 22, MySQLParser::RuleAlterTableActions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1664);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 28, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1651);
      alterCommandList();
      setState(1654);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::PARTITION_SYMBOL: {
          setState(1652);
          partitionClause();
          break;
        }

        case MySQLParser::REMOVE_SYMBOL: {
          setState(1653);
          removePartitioning();
          break;
        }

        case MySQLParser::EOF:
        case MySQLParser::SEMICOLON_SYMBOL: {
          break;
        }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1656);
      partitionClause();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1657);
      removePartitioning();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1661);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 27, _ctx)) {
      case 1: {
        setState(1658);
        alterCommandsModifierList();
        setState(1659);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1663);
      standaloneAlterCommands();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandListContext ------------------------------------------------------------------

MySQLParser::AlterCommandListContext::AlterCommandListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterCommandListContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

MySQLParser::AlterListContext* MySQLParser::AlterCommandListContext::alterList() {
  return getRuleContext<MySQLParser::AlterListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterCommandListContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterCommandListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandList;
}

void MySQLParser::AlterCommandListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandList(this);
}

void MySQLParser::AlterCommandListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandList(this);
}


std::any MySQLParser::AlterCommandListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandListContext* MySQLParser::alterCommandList() {
  AlterCommandListContext *_localctx = _tracker.createInstance<AlterCommandListContext>(_ctx, getState());
  enterRule(_localctx, 24, MySQLParser::RuleAlterCommandList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1673);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 30, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1666);
      alterCommandsModifierList();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1670);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 29, _ctx)) {
      case 1: {
        setState(1667);
        alterCommandsModifierList();
        setState(1668);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1672);
      alterList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierListContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierListContext::AlterCommandsModifierListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterCommandsModifierListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifierList;
}

void MySQLParser::AlterCommandsModifierListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifierList(this);
}

void MySQLParser::AlterCommandsModifierListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifierList(this);
}


std::any MySQLParser::AlterCommandsModifierListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifierList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::alterCommandsModifierList() {
  AlterCommandsModifierListContext *_localctx = _tracker.createInstance<AlterCommandsModifierListContext>(_ctx, getState());
  enterRule(_localctx, 26, MySQLParser::RuleAlterCommandsModifierList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1675);
    alterCommandsModifier();
    setState(1680);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1676);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1677);
        alterCommandsModifier(); 
      }
      setState(1682);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- StandaloneAlterCommandsContext ------------------------------------------------------------------

MySQLParser::StandaloneAlterCommandsContext::StandaloneAlterCommandsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

MySQLParser::AlterPartitionContext* MySQLParser::StandaloneAlterCommandsContext::alterPartition() {
  return getRuleContext<MySQLParser::AlterPartitionContext>(0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_LOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_LOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_UNLOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_UNLOAD_SYMBOL, 0);
}


size_t MySQLParser::StandaloneAlterCommandsContext::getRuleIndex() const {
  return MySQLParser::RuleStandaloneAlterCommands;
}

void MySQLParser::StandaloneAlterCommandsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterStandaloneAlterCommands(this);
}

void MySQLParser::StandaloneAlterCommandsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitStandaloneAlterCommands(this);
}


std::any MySQLParser::StandaloneAlterCommandsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitStandaloneAlterCommands(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::standaloneAlterCommands() {
  StandaloneAlterCommandsContext *_localctx = _tracker.createInstance<StandaloneAlterCommandsContext>(_ctx, getState());
  enterRule(_localctx, 28, MySQLParser::RuleStandaloneAlterCommands);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1690);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 32, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1683);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1684);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1685);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1686);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1687);
      alterPartition();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1688);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1689);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::SECONDARY_LOAD_SYMBOL

      || _la == MySQLParser::SECONDARY_UNLOAD_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterPartitionContext ------------------------------------------------------------------

MySQLParser::AlterPartitionContext::AlterPartitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

MySQLParser::PartitionDefinitionsContext* MySQLParser::AlterPartitionContext::partitionDefinitions() {
  return getRuleContext<MySQLParser::PartitionDefinitionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITIONS_SYMBOL() {
  return getToken(MySQLParser::PARTITIONS_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::AlterPartitionContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

std::vector<MySQLParser::NoWriteToBinLogContext *> MySQLParser::AlterPartitionContext::noWriteToBinLog() {
  return getRuleContexts<MySQLParser::NoWriteToBinLogContext>();
}

MySQLParser::NoWriteToBinLogContext* MySQLParser::AlterPartitionContext::noWriteToBinLog(size_t i) {
  return getRuleContext<MySQLParser::NoWriteToBinLogContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AlterPartitionContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REBUILD_SYMBOL() {
  return getToken(MySQLParser::REBUILD_SYMBOL, 0);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::AlterPartitionContext::allOrPartitionNameList() {
  return getRuleContext<MySQLParser::AllOrPartitionNameListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::OPTIMIZE_SYMBOL() {
  return getToken(MySQLParser::OPTIMIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ANALYZE_SYMBOL() {
  return getToken(MySQLParser::ANALYZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

std::vector<MySQLParser::CheckOptionContext *> MySQLParser::AlterPartitionContext::checkOption() {
  return getRuleContexts<MySQLParser::CheckOptionContext>();
}

MySQLParser::CheckOptionContext* MySQLParser::AlterPartitionContext::checkOption(size_t i) {
  return getRuleContext<MySQLParser::CheckOptionContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REPAIR_SYMBOL() {
  return getToken(MySQLParser::REPAIR_SYMBOL, 0);
}

std::vector<MySQLParser::RepairTypeContext *> MySQLParser::AlterPartitionContext::repairType() {
  return getRuleContexts<MySQLParser::RepairTypeContext>();
}

MySQLParser::RepairTypeContext* MySQLParser::AlterPartitionContext::repairType(size_t i) {
  return getRuleContext<MySQLParser::RepairTypeContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::COALESCE_SYMBOL() {
  return getToken(MySQLParser::COALESCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REORGANIZE_SYMBOL() {
  return getToken(MySQLParser::REORGANIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::EXCHANGE_SYMBOL() {
  return getToken(MySQLParser::EXCHANGE_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterPartitionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterPartitionContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterPartitionContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}


size_t MySQLParser::AlterPartitionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterPartition;
}

void MySQLParser::AlterPartitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterPartition(this);
}

void MySQLParser::AlterPartitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterPartition(this);
}


std::any MySQLParser::AlterPartitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterPartition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterPartitionContext* MySQLParser::alterPartition() {
  AlterPartitionContext *_localctx = _tracker.createInstance<AlterPartitionContext>(_ctx, getState());
  enterRule(_localctx, 30, MySQLParser::RuleAlterPartition);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1788);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 46, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1692);
      match(MySQLParser::ADD_SYMBOL);
      setState(1693);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1695);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1694);
        noWriteToBinLog();
      }
      setState(1700);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::OPEN_PAR_SYMBOL: {
          setState(1697);
          partitionDefinitions();
          break;
        }

        case MySQLParser::PARTITIONS_SYMBOL: {
          setState(1698);
          match(MySQLParser::PARTITIONS_SYMBOL);
          setState(1699);
          real_ulong_number();
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1702);
      match(MySQLParser::DROP_SYMBOL);
      setState(1703);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1704);
      identifierList();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1705);
      match(MySQLParser::REBUILD_SYMBOL);
      setState(1706);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1708);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 35, _ctx)) {
      case 1: {
        setState(1707);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1710);
      allOrPartitionNameList();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1711);
      match(MySQLParser::OPTIMIZE_SYMBOL);
      setState(1712);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1714);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 36, _ctx)) {
      case 1: {
        setState(1713);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1716);
      allOrPartitionNameList();
      setState(1718);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1717);
        noWriteToBinLog();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1720);
      match(MySQLParser::ANALYZE_SYMBOL);
      setState(1721);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1723);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 38, _ctx)) {
      case 1: {
        setState(1722);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1725);
      allOrPartitionNameList();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1726);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1727);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1728);
      allOrPartitionNameList();
      setState(1732);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::CHANGED_SYMBOL || ((((_la - 180) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 180)) & ((1ULL << (MySQLParser::EXTENDED_SYMBOL - 180))
        | (1ULL << (MySQLParser::FAST_SYMBOL - 180))
        | (1ULL << (MySQLParser::FOR_SYMBOL - 180)))) != 0) || _la == MySQLParser::MEDIUM_SYMBOL || _la == MySQLParser::QUICK_SYMBOL) {
        setState(1729);
        checkOption();
        setState(1734);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1735);
      match(MySQLParser::REPAIR_SYMBOL);
      setState(1736);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1738);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 40, _ctx)) {
      case 1: {
        setState(1737);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1740);
      allOrPartitionNameList();
      setState(1744);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::EXTENDED_SYMBOL || _la == MySQLParser::QUICK_SYMBOL || _la == MySQLParser::USE_FRM_SYMBOL) {
        setState(1741);
        repairType();
        setState(1746);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1747);
      match(MySQLParser::COALESCE_SYMBOL);
      setState(1748);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1750);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1749);
        noWriteToBinLog();
      }
      setState(1752);
      real_ulong_number();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1753);
      match(MySQLParser::TRUNCATE_SYMBOL);
      setState(1754);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1755);
      allOrPartitionNameList();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1756);
      match(MySQLParser::REORGANIZE_SYMBOL);
      setState(1757);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1759);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 43, _ctx)) {
      case 1: {
        setState(1758);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1765);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 44, _ctx)) {
      case 1: {
        setState(1761);
        identifierList();
        setState(1762);
        match(MySQLParser::INTO_SYMBOL);
        setState(1763);
        partitionDefinitions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1767);
      match(MySQLParser::EXCHANGE_SYMBOL);
      setState(1768);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1769);
      identifier();
      setState(1770);
      match(MySQLParser::WITH_SYMBOL);
      setState(1771);
      match(MySQLParser::TABLE_SYMBOL);
      setState(1772);
      tableRef();
      setState(1774);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 45, _ctx)) {
      case 1: {
        setState(1773);
        withValidation();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1776);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1777);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1778);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1779);
      allOrPartitionNameList();
      setState(1780);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1782);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1783);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1784);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1785);
      allOrPartitionNameList();
      setState(1786);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListContext ------------------------------------------------------------------

MySQLParser::AlterListContext::AlterListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterListItemContext *> MySQLParser::AlterListContext::alterListItem() {
  return getRuleContexts<MySQLParser::AlterListItemContext>();
}

MySQLParser::AlterListItemContext* MySQLParser::AlterListContext::alterListItem(size_t i) {
  return getRuleContext<MySQLParser::AlterListItemContext>(i);
}

std::vector<MySQLParser::CreateTableOptionsSpaceSeparatedContext *> MySQLParser::AlterListContext::createTableOptionsSpaceSeparated() {
  return getRuleContexts<MySQLParser::CreateTableOptionsSpaceSeparatedContext>();
}

MySQLParser::CreateTableOptionsSpaceSeparatedContext* MySQLParser::AlterListContext::createTableOptionsSpaceSeparated(size_t i) {
  return getRuleContext<MySQLParser::CreateTableOptionsSpaceSeparatedContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}


size_t MySQLParser::AlterListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterList;
}

void MySQLParser::AlterListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterList(this);
}

void MySQLParser::AlterListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterList(this);
}


std::any MySQLParser::AlterListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListContext* MySQLParser::alterList() {
  AlterListContext *_localctx = _tracker.createInstance<AlterListContext>(_ctx, getState());
  enterRule(_localctx, 32, MySQLParser::RuleAlterList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1792);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 47, _ctx)) {
    case 1: {
      setState(1790);
      alterListItem();
      break;
    }

    case 2: {
      setState(1791);
      createTableOptionsSpaceSeparated();
      break;
    }

    default:
      break;
    }
    setState(1802);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(1794);
      match(MySQLParser::COMMA_SYMBOL);
      setState(1798);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 48, _ctx)) {
      case 1: {
        setState(1795);
        alterListItem();
        break;
      }

      case 2: {
        setState(1796);
        alterCommandsModifier();
        break;
      }

      case 3: {
        setState(1797);
        createTableOptionsSpaceSeparated();
        break;
      }

      default:
        break;
      }
      setState(1804);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierContext::AlterCommandsModifierContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::AlterCommandsModifierContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::AlterCommandsModifierContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterCommandsModifierContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}


size_t MySQLParser::AlterCommandsModifierContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifier;
}

void MySQLParser::AlterCommandsModifierContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifier(this);
}

void MySQLParser::AlterCommandsModifierContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifier(this);
}


std::any MySQLParser::AlterCommandsModifierContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifier(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::alterCommandsModifier() {
  AlterCommandsModifierContext *_localctx = _tracker.createInstance<AlterCommandsModifierContext>(_ctx, getState());
  enterRule(_localctx, 34, MySQLParser::RuleAlterCommandsModifier);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1808);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 50, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1805);
      alterAlgorithmOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1806);
      alterLockOption();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1807);
      withValidation();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListItemContext ------------------------------------------------------------------

MySQLParser::AlterListItemContext::AlterListItemContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterListItemContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::FieldDefinitionContext* MySQLParser::AlterListItemContext::fieldDefinition() {
  return getRuleContext<MySQLParser::FieldDefinitionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::TableElementListContext* MySQLParser::AlterListItemContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::COLUMN_SYMBOL() {
  return getToken(MySQLParser::COLUMN_SYMBOL, 0);
}

MySQLParser::CheckOrReferencesContext* MySQLParser::AlterListItemContext::checkOrReferences() {
  return getRuleContext<MySQLParser::CheckOrReferencesContext>(0);
}

MySQLParser::PlaceContext* MySQLParser::AlterListItemContext::place() {
  return getRuleContext<MySQLParser::PlaceContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::AlterListItemContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHANGE_SYMBOL() {
  return getToken(MySQLParser::CHANGE_SYMBOL, 0);
}

MySQLParser::ColumnInternalRefContext* MySQLParser::AlterListItemContext::columnInternalRef() {
  return getRuleContext<MySQLParser::ColumnInternalRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::MODIFY_SYMBOL() {
  return getToken(MySQLParser::MODIFY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PRIMARY_SYMBOL() {
  return getToken(MySQLParser::PRIMARY_SYMBOL, 0);
}

MySQLParser::KeyOrIndexContext* MySQLParser::AlterListItemContext::keyOrIndex() {
  return getRuleContext<MySQLParser::KeyOrIndexContext>(0);
}

MySQLParser::IndexRefContext* MySQLParser::AlterListItemContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONSTRAINT_SYMBOL() {
  return getToken(MySQLParser::CONSTRAINT_SYMBOL, 0);
}

MySQLParser::RestrictContext* MySQLParser::AlterListItemContext::restrict() {
  return getRuleContext<MySQLParser::RestrictContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEYS_SYMBOL() {
  return getToken(MySQLParser::KEYS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::VisibilityContext* MySQLParser::AlterListItemContext::visibility() {
  return getRuleContext<MySQLParser::VisibilityContext>(0);
}

MySQLParser::ExprWithParenthesesContext* MySQLParser::AlterListItemContext::exprWithParentheses() {
  return getRuleContext<MySQLParser::ExprWithParenthesesContext>(0);
}

MySQLParser::SignedLiteralOrNullContext* MySQLParser::AlterListItemContext::signedLiteralOrNull() {
  return getRuleContext<MySQLParser::SignedLiteralOrNullContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::ConstraintEnforcementContext* MySQLParser::AlterListItemContext::constraintEnforcement() {
  return getRuleContext<MySQLParser::ConstraintEnforcementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::AlterListItemContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IndexNameContext* MySQLParser::AlterListItemContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONVERT_SYMBOL() {
  return getToken(MySQLParser::CONVERT_SYMBOL, 0);
}

MySQLParser::CharsetContext* MySQLParser::AlterListItemContext::charset() {
  return getRuleContext<MySQLParser::CharsetContext>(0);
}

MySQLParser::CharsetNameContext* MySQLParser::AlterListItemContext::charsetName() {
  return getRuleContext<MySQLParser::CharsetNameContext>(0);
}

MySQLParser::CollateContext* MySQLParser::AlterListItemContext::collate() {
  return getRuleContext<MySQLParser::CollateContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FORCE_SYMBOL() {
  return getToken(MySQLParser::FORCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::AlterOrderListContext* MySQLParser::AlterListItemContext::alterOrderList() {
  return getRuleContext<MySQLParser::AlterOrderListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::AlterListItemContext::getRuleIndex() const {
  return MySQLParser::RuleAlterListItem;
}

void MySQLParser::AlterListItemContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterListItem(this);
}

void MySQLParser::AlterListItemContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterListItem(this);
}


std::any MySQLParser::AlterListItemContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterListItem(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListItemContext* MySQLParser::alterListItem() {
  AlterListItemContext *_localctx = _tracker.createInstance<AlterListItemContext>(_ctx, getState());
  enterRule(_localctx, 36, MySQLParser::RuleAlterListItem);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1950);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 68, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1810);
      match(MySQLParser::ADD_SYMBOL);
      setState(1812);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 51, _ctx)) {
      case 1: {
        setState(1811);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1826);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 54, _ctx)) {
      case 1: {
        setState(1814);
        identifier();
        setState(1815);
        fieldDefinition();
        setState(1817);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 52, _ctx)) {
        case 1: {
          setState(1816);
          checkOrReferences();
          break;
        }

        default:
          break;
        }
        setState(1820);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
          setState(1819);
          place();
        }
        break;
      }

      case 2: {
        setState(1822);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(1823);
        tableElementList();
        setState(1824);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1828);
      match(MySQLParser::ADD_SYMBOL);
      setState(1829);
      tableConstraintDef();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1830);
      match(MySQLParser::CHANGE_SYMBOL);
      setState(1832);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 55, _ctx)) {
      case 1: {
        setState(1831);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1834);
      columnInternalRef();
      setState(1835);
      identifier();
      setState(1836);
      fieldDefinition();
      setState(1838);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1837);
        place();
      }
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1840);
      match(MySQLParser::MODIFY_SYMBOL);
      setState(1842);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 57, _ctx)) {
      case 1: {
        setState(1841);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1844);
      columnInternalRef();
      setState(1845);
      fieldDefinition();
      setState(1847);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1846);
        place();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1849);
      match(MySQLParser::DROP_SYMBOL);
      setState(1871);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 61, _ctx)) {
      case 1: {
        setState(1851);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 59, _ctx)) {
        case 1: {
          setState(1850);
          match(MySQLParser::COLUMN_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(1853);
        columnInternalRef();
        setState(1855);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
          setState(1854);
          restrict();
        }
        break;
      }

      case 2: {
        setState(1857);
        match(MySQLParser::FOREIGN_SYMBOL);
        setState(1858);
        match(MySQLParser::KEY_SYMBOL);
        setState(1859);
        columnInternalRef();
        break;
      }

      case 3: {
        setState(1860);
        match(MySQLParser::PRIMARY_SYMBOL);
        setState(1861);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 4: {
        setState(1862);
        keyOrIndex();
        setState(1863);
        indexRef();
        break;
      }

      case 5: {
        setState(1865);

        if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
        setState(1866);
        match(MySQLParser::CHECK_SYMBOL);
        setState(1867);
        identifier();
        break;
      }

      case 6: {
        setState(1868);

        if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
        setState(1869);
        match(MySQLParser::CONSTRAINT_SYMBOL);
        setState(1870);
        identifier();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1873);
      match(MySQLParser::DISABLE_SYMBOL);
      setState(1874);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1875);
      match(MySQLParser::ENABLE_SYMBOL);
      setState(1876);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1877);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1879);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 62, _ctx)) {
      case 1: {
        setState(1878);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1881);
      columnInternalRef();
      setState(1894);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 64, _ctx)) {
      case 1: {
        setState(1882);
        match(MySQLParser::SET_SYMBOL);
        setState(1883);
        match(MySQLParser::DEFAULT_SYMBOL);
        setState(1887);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 63, _ctx)) {
        case 1: {
          setState(1884);

          if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
          setState(1885);
          exprWithParentheses();
          break;
        }

        case 2: {
          setState(1886);
          signedLiteralOrNull();
          break;
        }

        default:
          break;
        }
        break;
      }

      case 2: {
        setState(1889);
        match(MySQLParser::DROP_SYMBOL);
        setState(1890);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 3: {
        setState(1891);

        if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
        setState(1892);
        match(MySQLParser::SET_SYMBOL);
        setState(1893);
        visibility();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1896);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1897);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1898);
      match(MySQLParser::INDEX_SYMBOL);
      setState(1899);
      indexRef();
      setState(1900);
      visibility();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1902);

      if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
      setState(1903);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1904);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1905);
      identifier();
      setState(1906);
      constraintEnforcement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1908);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(1909);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1910);
      match(MySQLParser::CONSTRAINT_SYMBOL);
      setState(1911);
      identifier();
      setState(1912);
      constraintEnforcement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1914);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1915);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1916);
      match(MySQLParser::COLUMN_SYMBOL);
      setState(1917);
      columnInternalRef();
      setState(1918);
      match(MySQLParser::TO_SYMBOL);
      setState(1919);
      identifier();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1921);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1923);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 65, _ctx)) {
      case 1: {
        setState(1922);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::AS_SYMBOL || _la == MySQLParser::TO_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

      default:
        break;
      }
      setState(1925);
      tableName();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1926);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1927);
      keyOrIndex();
      setState(1928);
      indexRef();
      setState(1929);
      match(MySQLParser::TO_SYMBOL);
      setState(1930);
      indexName();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1932);
      match(MySQLParser::CONVERT_SYMBOL);
      setState(1933);
      match(MySQLParser::TO_SYMBOL);
      setState(1934);
      charset();
      setState(1938);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 66, _ctx)) {
      case 1: {
        setState(1935);

        if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
        setState(1936);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 2: {
        setState(1937);
        charsetName();
        break;
      }

      default:
        break;
      }
      setState(1941);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COLLATE_SYMBOL) {
        setState(1940);
        collate();
      }
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1943);
      match(MySQLParser::FORCE_SYMBOL);
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1944);
      match(MySQLParser::ORDER_SYMBOL);
      setState(1945);
      match(MySQLParser::BY_SYMBOL);
      setState(1946);
      alterOrderList();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(1947);

      if (!(serverVersion >= 50708 && serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion >= 50708 && serverVersion < 80000");
      setState(1948);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(1949);
      match(MySQLParser::PARTITIONING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PlaceContext ------------------------------------------------------------------

MySQLParser::PlaceContext::PlaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PlaceContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::PlaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::PlaceContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}


size_t MySQLParser::PlaceContext::getRuleIndex() const {
  return MySQLParser::RulePlace;
}

void MySQLParser::PlaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPlace(this);
}

void MySQLParser::PlaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPlace(this);
}


std::any MySQLParser::PlaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPlace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PlaceContext* MySQLParser::place() {
  PlaceContext *_localctx = _tracker.createInstance<PlaceContext>(_ctx, getState());
  enterRule(_localctx, 38, MySQLParser::RulePlace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1955);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::AFTER_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1952);
        match(MySQLParser::AFTER_SYMBOL);
        setState(1953);
        identifier();
        break;
      }

      case MySQLParser::FIRST_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1954);
        match(MySQLParser::FIRST_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RestrictContext ------------------------------------------------------------------

MySQLParser::RestrictContext::RestrictContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RestrictContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RestrictContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::RestrictContext::getRuleIndex() const {
  return MySQLParser::RuleRestrict;
}

void MySQLParser::RestrictContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRestrict(this);
}

void MySQLParser::RestrictContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRestrict(this);
}


std::any MySQLParser::RestrictContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRestrict(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RestrictContext* MySQLParser::restrict() {
  RestrictContext *_localctx = _tracker.createInstance<RestrictContext>(_ctx, getState());
  enterRule(_localctx, 40, MySQLParser::RuleRestrict);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1957);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterOrderListContext ------------------------------------------------------------------

MySQLParser::AlterOrderListContext::AlterOrderListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterOrderListContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterOrderListContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

std::vector<MySQLParser::DirectionContext *> MySQLParser::AlterOrderListContext::direction() {
  return getRuleContexts<MySQLParser::DirectionContext>();
}

MySQLParser::DirectionContext* MySQLParser::AlterOrderListContext::direction(size_t i) {
  return getRuleContext<MySQLParser::DirectionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterOrderListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterOrderListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterOrderListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterOrderList;
}

void MySQLParser::AlterOrderListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterOrderList(this);
}

void MySQLParser::AlterOrderListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterOrderList(this);
}


std::any MySQLParser::AlterOrderListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterOrderList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterOrderListContext* MySQLParser::alterOrderList() {
  AlterOrderListContext *_localctx = _tracker.createInstance<AlterOrderListContext>(_ctx, getState());
  enterRule(_localctx, 42, MySQLParser::RuleAlterOrderList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1959);
    identifier();
    setState(1961);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
      setState(1960);
      direction();
    }
    setState(1970);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 72, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1963);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1964);
        identifier();
        setState(1966);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
          setState(1965);
          direction();
        } 
      }
      setState(1972);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 72, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterAlgorithmOptionContext ------------------------------------------------------------------

MySQLParser::AlterAlgorithmOptionContext::AlterAlgorithmOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterAlgorithmOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterAlgorithmOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterAlgorithmOption;
}

void MySQLParser::AlterAlgorithmOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterAlgorithmOption(this);
}

void MySQLParser::AlterAlgorithmOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterAlgorithmOption(this);
}


std::any MySQLParser::AlterAlgorithmOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterAlgorithmOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::alterAlgorithmOption() {
  AlterAlgorithmOptionContext *_localctx = _tracker.createInstance<AlterAlgorithmOptionContext>(_ctx, getState());
  enterRule(_localctx, 44, MySQLParser::RuleAlterAlgorithmOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1973);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(1975);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 73, _ctx)) {
    case 1: {
      setState(1974);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(1979);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 74, _ctx)) {
    case 1: {
      setState(1977);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(1978);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLockOptionContext ------------------------------------------------------------------

MySQLParser::AlterLockOptionContext::AlterLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::LOCK_SYMBOL() {
  return getToken(MySQLParser::LOCK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterLockOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLockOption;
}

void MySQLParser::AlterLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLockOption(this);
}

void MySQLParser::AlterLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLockOption(this);
}


std::any MySQLParser::AlterLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLockOptionContext* MySQLParser::alterLockOption() {
  AlterLockOptionContext *_localctx = _tracker.createInstance<AlterLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 46, MySQLParser::RuleAlterLockOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1981);
    match(MySQLParser::LOCK_SYMBOL);
    setState(1983);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 75, _ctx)) {
    case 1: {
      setState(1982);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(1987);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 76, _ctx)) {
    case 1: {
      setState(1985);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(1986);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexLockAndAlgorithmContext ------------------------------------------------------------------

MySQLParser::IndexLockAndAlgorithmContext::IndexLockAndAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}


size_t MySQLParser::IndexLockAndAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleIndexLockAndAlgorithm;
}

void MySQLParser::IndexLockAndAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexLockAndAlgorithm(this);
}

void MySQLParser::IndexLockAndAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexLockAndAlgorithm(this);
}


std::any MySQLParser::IndexLockAndAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexLockAndAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::indexLockAndAlgorithm() {
  IndexLockAndAlgorithmContext *_localctx = _tracker.createInstance<IndexLockAndAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 48, MySQLParser::RuleIndexLockAndAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1997);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1989);
        alterAlgorithmOption();
        setState(1991);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LOCK_SYMBOL) {
          setState(1990);
          alterLockOption();
        }
        break;
      }

      case MySQLParser::LOCK_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1993);
        alterLockOption();
        setState(1995);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(1994);
          alterAlgorithmOption();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithValidationContext ------------------------------------------------------------------

MySQLParser::WithValidationContext::WithValidationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithValidationContext::VALIDATION_SYMBOL() {
  return getToken(MySQLParser::VALIDATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITHOUT_SYMBOL() {
  return getToken(MySQLParser::WITHOUT_SYMBOL, 0);
}


size_t MySQLParser::WithValidationContext::getRuleIndex() const {
  return MySQLParser::RuleWithValidation;
}

void MySQLParser::WithValidationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithValidation(this);
}

void MySQLParser::WithValidationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithValidation(this);
}


std::any MySQLParser::WithValidationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithValidation(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithValidationContext* MySQLParser::withValidation() {
  WithValidationContext *_localctx = _tracker.createInstance<WithValidationContext>(_ctx, getState());
  enterRule(_localctx, 50, MySQLParser::RuleWithValidation);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1999);

    if (!(serverVersion >= 50706)) throw FailedPredicateException(this, "serverVersion >= 50706");
    setState(2000);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::WITH_SYMBOL

    || _la == MySQLParser::WITHOUT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2001);
    match(MySQLParser::VALIDATION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RemovePartitioningContext ------------------------------------------------------------------

MySQLParser::RemovePartitioningContext::RemovePartitioningContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::REMOVE_SYMBOL() {
  return getToken(MySQLParser::REMOVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::RemovePartitioningContext::getRuleIndex() const {
  return MySQLParser::RuleRemovePartitioning;
}

void MySQLParser::RemovePartitioningContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRemovePartitioning(this);
}

void MySQLParser::RemovePartitioningContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRemovePartitioning(this);
}


std::any MySQLParser::RemovePartitioningContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRemovePartitioning(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RemovePartitioningContext* MySQLParser::removePartitioning() {
  RemovePartitioningContext *_localctx = _tracker.createInstance<RemovePartitioningContext>(_ctx, getState());
  enterRule(_localctx, 52, MySQLParser::RuleRemovePartitioning);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2003);
    match(MySQLParser::REMOVE_SYMBOL);
    setState(2004);
    match(MySQLParser::PARTITIONING_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AllOrPartitionNameListContext ------------------------------------------------------------------

MySQLParser::AllOrPartitionNameListContext::AllOrPartitionNameListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AllOrPartitionNameListContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AllOrPartitionNameListContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}


size_t MySQLParser::AllOrPartitionNameListContext::getRuleIndex() const {
  return MySQLParser::RuleAllOrPartitionNameList;
}

void MySQLParser::AllOrPartitionNameListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAllOrPartitionNameList(this);
}

void MySQLParser::AllOrPartitionNameListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAllOrPartitionNameList(this);
}


std::any MySQLParser::AllOrPartitionNameListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAllOrPartitionNameList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::allOrPartitionNameList() {
  AllOrPartitionNameListContext *_localctx = _tracker.createInstance<AllOrPartitionNameListContext>(_ctx, getState());
  enterRule(_localctx, 54, MySQLParser::RuleAllOrPartitionNameList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2008);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 80, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2006);
      match(MySQLParser::ALL_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2007);
      identifierList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceContext::AlterTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterTablespaceContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterTablespaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::AlterTablespaceContext::alterTablespaceOptions() {
  return getRuleContext<MySQLParser::AlterTablespaceOptionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}


size_t MySQLParser::AlterTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespace;
}

void MySQLParser::AlterTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespace(this);
}

void MySQLParser::AlterTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespace(this);
}


std::any MySQLParser::AlterTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceContext* MySQLParser::alterTablespace() {
  AlterTablespaceContext *_localctx = _tracker.createInstance<AlterTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 56, MySQLParser::RuleAlterTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2010);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2011);
    tablespaceRef();
    setState(2023);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 82, _ctx)) {
    case 1: {
      setState(2012);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::ADD_SYMBOL || _la == MySQLParser::DROP_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(2013);
      match(MySQLParser::DATAFILE_SYMBOL);
      setState(2014);
      textLiteral();
      setState(2016);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 81, _ctx)) {
      case 1: {
        setState(2015);
        alterTablespaceOptions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2018);
      match(MySQLParser::RENAME_SYMBOL);
      setState(2019);
      match(MySQLParser::TO_SYMBOL);
      setState(2020);
      identifier();
      break;
    }

    case 3: {
      setState(2021);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2022);
      alterTablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterUndoTablespaceContext::AlterUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::ACTIVE_SYMBOL() {
  return getToken(MySQLParser::ACTIVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::INACTIVE_SYMBOL() {
  return getToken(MySQLParser::INACTIVE_SYMBOL, 0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::AlterUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::AlterUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterUndoTablespace;
}

void MySQLParser::AlterUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterUndoTablespace(this);
}

void MySQLParser::AlterUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterUndoTablespace(this);
}


std::any MySQLParser::AlterUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::alterUndoTablespace() {
  AlterUndoTablespaceContext *_localctx = _tracker.createInstance<AlterUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 58, MySQLParser::RuleAlterUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2025);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2026);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2027);
    tablespaceRef();
    setState(2028);
    match(MySQLParser::SET_SYMBOL);
    setState(2029);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ACTIVE_SYMBOL

    || _la == MySQLParser::INACTIVE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2031);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2030);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionsContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionsContext::UndoTableSpaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::UndoTableSpaceOptionContext *> MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption() {
  return getRuleContexts<MySQLParser::UndoTableSpaceOptionContext>();
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption(size_t i) {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::UndoTableSpaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOptions;
}

void MySQLParser::UndoTableSpaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOptions(this);
}

void MySQLParser::UndoTableSpaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOptions(this);
}


std::any MySQLParser::UndoTableSpaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::undoTableSpaceOptions() {
  UndoTableSpaceOptionsContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 60, MySQLParser::RuleUndoTableSpaceOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2033);
    undoTableSpaceOption();
    setState(2040);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(2035);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2034);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2037);
      undoTableSpaceOption();
      setState(2042);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionContext::UndoTableSpaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionEngineContext* MySQLParser::UndoTableSpaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::UndoTableSpaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOption;
}

void MySQLParser::UndoTableSpaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOption(this);
}

void MySQLParser::UndoTableSpaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOption(this);
}


std::any MySQLParser::UndoTableSpaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::undoTableSpaceOption() {
  UndoTableSpaceOptionContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 62, MySQLParser::RuleUndoTableSpaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2043);
    tsOptionEngine();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionsContext::AlterTablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterTablespaceOptionContext *> MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption() {
  return getRuleContexts<MySQLParser::AlterTablespaceOptionContext>();
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::AlterTablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterTablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOptions;
}

void MySQLParser::AlterTablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOptions(this);
}

void MySQLParser::AlterTablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOptions(this);
}


std::any MySQLParser::AlterTablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::alterTablespaceOptions() {
  AlterTablespaceOptionsContext *_localctx = _tracker.createInstance<AlterTablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 64, MySQLParser::RuleAlterTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2045);
    alterTablespaceOption();
    setState(2052);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 87, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2047);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 86, _ctx)) {
        case 1: {
          setState(2046);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2049);
        alterTablespaceOption(); 
      }
      setState(2054);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 87, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionContext::AlterTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::AlterTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterTablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}

MySQLParser::TsOptionEngineAttributeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngineAttribute() {
  return getRuleContext<MySQLParser::TsOptionEngineAttributeContext>(0);
}


size_t MySQLParser::AlterTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOption;
}

void MySQLParser::AlterTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOption(this);
}

void MySQLParser::AlterTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOption(this);
}


std::any MySQLParser::AlterTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::alterTablespaceOption() {
  AlterTablespaceOptionContext *_localctx = _tracker.createInstance<AlterTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 66, MySQLParser::RuleAlterTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2067);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 89, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2055);
      match(MySQLParser::INITIAL_SIZE_SYMBOL);
      setState(2057);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 88, _ctx)) {
      case 1: {
        setState(2056);
        match(MySQLParser::EQUAL_OPERATOR);
        break;
      }

      default:
        break;
      }
      setState(2059);
      sizeNumber();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2060);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2061);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2062);
      tsOptionEngine();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2063);
      tsOptionWait();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2064);
      tsOptionEncryption();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2065);

      if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
      setState(2066);
      tsOptionEngineAttribute();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ChangeTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::ChangeTablespaceOptionContext::ChangeTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::ChangeTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}


size_t MySQLParser::ChangeTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleChangeTablespaceOption;
}

void MySQLParser::ChangeTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterChangeTablespaceOption(this);
}

void MySQLParser::ChangeTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitChangeTablespaceOption(this);
}


std::any MySQLParser::ChangeTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitChangeTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ChangeTablespaceOptionContext* MySQLParser::changeTablespaceOption() {
  ChangeTablespaceOptionContext *_localctx = _tracker.createInstance<ChangeTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 68, MySQLParser::RuleChangeTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2076);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2069);
        match(MySQLParser::INITIAL_SIZE_SYMBOL);
        setState(2071);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 90, _ctx)) {
        case 1: {
          setState(2070);
          match(MySQLParser::EQUAL_OPERATOR);
          break;
        }

        default:
          break;
        }
        setState(2073);
        sizeNumber();
        break;
      }

      case MySQLParser::AUTOEXTEND_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2074);
        tsOptionAutoextendSize();
        break;
      }

      case MySQLParser::MAX_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2075);
        tsOptionMaxSize();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterViewContext ------------------------------------------------------------------

MySQLParser::AlterViewContext::AlterViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefContext* MySQLParser::AlterViewContext::viewRef() {
  return getRuleContext<MySQLParser::ViewRefContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::AlterViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::AlterViewContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::AlterViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::AlterViewContext::getRuleIndex() const {
  return MySQLParser::RuleAlterView;
}

void MySQLParser::AlterViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterView(this);
}

void MySQLParser::AlterViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterView(this);
}


std::any MySQLParser::AlterViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterViewContext* MySQLParser::alterView() {
  AlterViewContext *_localctx = _tracker.createInstance<AlterViewContext>(_ctx, getState());
  enterRule(_localctx, 70, MySQLParser::RuleAlterView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2079);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL) {
      setState(2078);
      viewAlgorithm();
    }
    setState(2082);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2081);
      definerClause();
    }
    setState(2085);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2084);
      viewSuid();
    }
    setState(2087);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2088);
    viewRef();
    setState(2089);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewTailContext ------------------------------------------------------------------

MySQLParser::ViewTailContext::ViewTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewTailContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::ViewQueryBlockContext* MySQLParser::ViewTailContext::viewQueryBlock() {
  return getRuleContext<MySQLParser::ViewQueryBlockContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ViewTailContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ViewTailContext::getRuleIndex() const {
  return MySQLParser::RuleViewTail;
}

void MySQLParser::ViewTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewTail(this);
}

void MySQLParser::ViewTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewTail(this);
}


std::any MySQLParser::ViewTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewTailContext* MySQLParser::viewTail() {
  ViewTailContext *_localctx = _tracker.createInstance<ViewTailContext>(_ctx, getState());
  enterRule(_localctx, 72, MySQLParser::RuleViewTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2092);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2091);
      columnInternalRefList();
    }
    setState(2094);
    match(MySQLParser::AS_SYMBOL);
    setState(2095);
    viewQueryBlock();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewQueryBlockContext ------------------------------------------------------------------

MySQLParser::ViewQueryBlockContext::ViewQueryBlockContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::ViewQueryBlockContext::queryExpressionOrParens() {
  return getRuleContext<MySQLParser::QueryExpressionOrParensContext>(0);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::ViewQueryBlockContext::viewCheckOption() {
  return getRuleContext<MySQLParser::ViewCheckOptionContext>(0);
}


size_t MySQLParser::ViewQueryBlockContext::getRuleIndex() const {
  return MySQLParser::RuleViewQueryBlock;
}

void MySQLParser::ViewQueryBlockContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewQueryBlock(this);
}

void MySQLParser::ViewQueryBlockContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewQueryBlock(this);
}


std::any MySQLParser::ViewQueryBlockContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewQueryBlock(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewQueryBlockContext* MySQLParser::viewQueryBlock() {
  ViewQueryBlockContext *_localctx = _tracker.createInstance<ViewQueryBlockContext>(_ctx, getState());
  enterRule(_localctx, 74, MySQLParser::RuleViewQueryBlock);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2097);
    queryExpressionOrParens();
    setState(2099);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::WITH_SYMBOL) {
      setState(2098);
      viewCheckOption();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewCheckOptionContext ------------------------------------------------------------------

MySQLParser::ViewCheckOptionContext::ViewCheckOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::OPTION_SYMBOL() {
  return getToken(MySQLParser::OPTION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CASCADED_SYMBOL() {
  return getToken(MySQLParser::CASCADED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}


size_t MySQLParser::ViewCheckOptionContext::getRuleIndex() const {
  return MySQLParser::RuleViewCheckOption;
}

void MySQLParser::ViewCheckOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewCheckOption(this);
}

void MySQLParser::ViewCheckOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewCheckOption(this);
}


std::any MySQLParser::ViewCheckOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewCheckOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::viewCheckOption() {
  ViewCheckOptionContext *_localctx = _tracker.createInstance<ViewCheckOptionContext>(_ctx, getState());
  enterRule(_localctx, 76, MySQLParser::RuleViewCheckOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2101);
    match(MySQLParser::WITH_SYMBOL);
    setState(2103);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL) {
      setState(2102);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(2105);
    match(MySQLParser::CHECK_SYMBOL);
    setState(2106);
    match(MySQLParser::OPTION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterInstanceStatementContext ------------------------------------------------------------------

MySQLParser::AlterInstanceStatementContext::AlterInstanceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::INSTANCE_SYMBOL() {
  return getToken(MySQLParser::INSTANCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ROTATE_SYMBOL() {
  return getToken(MySQLParser::ROTATE_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::AlterInstanceStatementContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::MASTER_SYMBOL() {
  return getToken(MySQLParser::MASTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::RELOAD_SYMBOL() {
  return getToken(MySQLParser::RELOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::TLS_SYMBOL() {
  return getToken(MySQLParser::TLS_SYMBOL, 0);
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterInstanceStatementContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterInstanceStatementContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::KEYRING_SYMBOL() {
  return getToken(MySQLParser::KEYRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::CHANNEL_SYMBOL() {
  return getToken(MySQLParser::CHANNEL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ROLLBACK_SYMBOL() {
  return getToken(MySQLParser::ROLLBACK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ERROR_SYMBOL() {
  return getToken(MySQLParser::ERROR_SYMBOL, 0);
}


size_t MySQLParser::AlterInstanceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterInstanceStatement;
}

void MySQLParser::AlterInstanceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterInstanceStatement(this);
}

void MySQLParser::AlterInstanceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterInstanceStatement(this);
}


std::any MySQLParser::AlterInstanceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterInstanceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterInstanceStatementContext* MySQLParser::alterInstanceStatement() {
  AlterInstanceStatementContext *_localctx = _tracker.createInstance<AlterInstanceStatementContext>(_ctx, getState());
  enterRule(_localctx, 78, MySQLParser::RuleAlterInstanceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2141);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 101, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2108);

      if (!(serverVersion >= 50713)) throw FailedPredicateException(this, "serverVersion >= 50713");
      setState(2109);
      match(MySQLParser::INSTANCE_SYMBOL);
      setState(2138);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 100, _ctx)) {
      case 1: {
        setState(2110);
        match(MySQLParser::ROTATE_SYMBOL);
        setState(2111);
        textOrIdentifier();
        setState(2112);
        match(MySQLParser::MASTER_SYMBOL);
        setState(2113);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 2: {
        setState(2115);

        if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
        setState(2116);
        match(MySQLParser::RELOAD_SYMBOL);
        setState(2117);
        match(MySQLParser::TLS_SYMBOL);
        setState(2122);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 98, _ctx)) {
        case 1: {
          setState(2118);

          if (!(serverVersion >= 80021)) throw FailedPredicateException(this, "serverVersion >= 80021");
          setState(2119);
          match(MySQLParser::FOR_SYMBOL);
          setState(2120);
          match(MySQLParser::CHANNEL_SYMBOL);
          setState(2121);
          identifier();
          break;
        }

        default:
          break;
        }
        setState(2128);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NO_SYMBOL) {
          setState(2124);
          match(MySQLParser::NO_SYMBOL);
          setState(2125);
          match(MySQLParser::ROLLBACK_SYMBOL);
          setState(2126);
          match(MySQLParser::ON_SYMBOL);
          setState(2127);
          match(MySQLParser::ERROR_SYMBOL);
        }
        break;
      }

      case 3: {
        setState(2130);

        if (!(serverVersion >= 80021)) throw FailedPredicateException(this, "serverVersion >= 80021");
        setState(2131);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DISABLE_SYMBOL

        || _la == MySQLParser::ENABLE_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        setState(2132);
        identifier();
        setState(2133);
        identifier();
        break;
      }

      case 4: {
        setState(2135);

        if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
        setState(2136);
        match(MySQLParser::RELOAD_SYMBOL);
        setState(2137);
        match(MySQLParser::KEYRING_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);

      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateStatementContext ------------------------------------------------------------------

MySQLParser::CreateStatementContext::CreateStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateStatementContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

MySQLParser::CreateDatabaseContext* MySQLParser::CreateStatementContext::createDatabase() {
  return getRuleContext<MySQLParser::CreateDatabaseContext>(0);
}

MySQLParser::CreateTableContext* MySQLParser::CreateStatementContext::createTable() {
  return getRuleContext<MySQLParser::CreateTableContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateStatementContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateStatementContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateStatementContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::CreateStatementContext::createLogfileGroup() {
  return getRuleContext<MySQLParser::CreateLogfileGroupContext>(0);
}

MySQLParser::CreateViewContext* MySQLParser::CreateStatementContext::createView() {
  return getRuleContext<MySQLParser::CreateViewContext>(0);
}

MySQLParser::CreateTriggerContext* MySQLParser::CreateStatementContext::createTrigger() {
  return getRuleContext<MySQLParser::CreateTriggerContext>(0);
}

MySQLParser::CreateIndexContext* MySQLParser::CreateStatementContext::createIndex() {
  return getRuleContext<MySQLParser::CreateIndexContext>(0);
}

MySQLParser::CreateServerContext* MySQLParser::CreateStatementContext::createServer() {
  return getRuleContext<MySQLParser::CreateServerContext>(0);
}

MySQLParser::CreateTablespaceContext* MySQLParser::CreateStatementContext::createTablespace() {
  return getRuleContext<MySQLParser::CreateTablespaceContext>(0);
}

MySQLParser::CreateEventContext* MySQLParser::CreateStatementContext::createEvent() {
  return getRuleContext<MySQLParser::CreateEventContext>(0);
}

MySQLParser::CreateRoleContext* MySQLParser::CreateStatementContext::createRole() {
  return getRuleContext<MySQLParser::CreateRoleContext>(0);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::CreateStatementContext::createSpatialReference() {
  return getRuleContext<MySQLParser::CreateSpatialReferenceContext>(0);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::CreateStatementContext::createUndoTablespace() {
  return getRuleContext<MySQLParser::CreateUndoTablespaceContext>(0);
}


size_t MySQLParser::CreateStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCreateStatement;
}

void MySQLParser::CreateStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateStatement(this);
}

void MySQLParser::CreateStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateStatement(this);
}


std::any MySQLParser::CreateStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateStatementContext* MySQLParser::createStatement() {
  CreateStatementContext *_localctx = _tracker.createInstance<CreateStatementContext>(_ctx, getState());
  enterRule(_localctx, 80, MySQLParser::RuleCreateStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2143);
    match(MySQLParser::CREATE_SYMBOL);
    setState(2162);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 102, _ctx)) {
    case 1: {
      setState(2144);
      createDatabase();
      break;
    }

    case 2: {
      setState(2145);
      createTable();
      break;
    }

    case 3: {
      setState(2146);
      createFunction();
      break;
    }

    case 4: {
      setState(2147);
      createProcedure();
      break;
    }

    case 5: {
      setState(2148);
      createUdf();
      break;
    }

    case 6: {
      setState(2149);
      createLogfileGroup();
      break;
    }

    case 7: {
      setState(2150);
      createView();
      break;
    }

    case 8: {
      setState(2151);
      createTrigger();
      break;
    }

    case 9: {
      setState(2152);
      createIndex();
      break;
    }

    case 10: {
      setState(2153);
      createServer();
      break;
    }

    case 11: {
      setState(2154);
      createTablespace();
      break;
    }

    case 12: {
      setState(2155);
      createEvent();
      break;
    }

    case 13: {
      setState(2156);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2157);
      createRole();
      break;
    }

    case 14: {
      setState(2158);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2159);
      createSpatialReference();
      break;
    }

    case 15: {
      setState(2160);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2161);
      createUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseContext::CreateDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaNameContext* MySQLParser::CreateDatabaseContext::schemaName() {
  return getRuleContext<MySQLParser::SchemaNameContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateDatabaseContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::CreateDatabaseOptionContext *> MySQLParser::CreateDatabaseContext::createDatabaseOption() {
  return getRuleContexts<MySQLParser::CreateDatabaseOptionContext>();
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::CreateDatabaseContext::createDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(i);
}


size_t MySQLParser::CreateDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabase;
}

void MySQLParser::CreateDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabase(this);
}

void MySQLParser::CreateDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabase(this);
}


std::any MySQLParser::CreateDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseContext* MySQLParser::createDatabase() {
  CreateDatabaseContext *_localctx = _tracker.createInstance<CreateDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 82, MySQLParser::RuleCreateDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2164);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2166);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 103, _ctx)) {
    case 1: {
      setState(2165);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2168);
    schemaName();
    setState(2172);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2169);
        createDatabaseOption(); 
      }
      setState(2174);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseOptionContext::CreateDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::DefaultCharsetContext* MySQLParser::CreateDatabaseOptionContext::defaultCharset() {
  return getRuleContext<MySQLParser::DefaultCharsetContext>(0);
}

MySQLParser::DefaultCollationContext* MySQLParser::CreateDatabaseOptionContext::defaultCollation() {
  return getRuleContext<MySQLParser::DefaultCollationContext>(0);
}

MySQLParser::DefaultEncryptionContext* MySQLParser::CreateDatabaseOptionContext::defaultEncryption() {
  return getRuleContext<MySQLParser::DefaultEncryptionContext>(0);
}


size_t MySQLParser::CreateDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabaseOption;
}

void MySQLParser::CreateDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabaseOption(this);
}

void MySQLParser::CreateDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabaseOption(this);
}


std::any MySQLParser::CreateDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::createDatabaseOption() {
  CreateDatabaseOptionContext *_localctx = _tracker.createInstance<CreateDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 84, MySQLParser::RuleCreateDatabaseOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2179);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 105, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2175);
      defaultCharset();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2176);
      defaultCollation();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2177);

      if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
      setState(2178);
      defaultEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTableContext ------------------------------------------------------------------

MySQLParser::CreateTableContext::CreateTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::CreateTableContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::LIKE_SYMBOL() {
  return getToken(MySQLParser::LIKE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTableContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TableElementListContext* MySQLParser::CreateTableContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

MySQLParser::CreateTableOptionsContext* MySQLParser::CreateTableContext::createTableOptions() {
  return getRuleContext<MySQLParser::CreateTableOptionsContext>(0);
}

MySQLParser::PartitionClauseContext* MySQLParser::CreateTableContext::partitionClause() {
  return getRuleContext<MySQLParser::PartitionClauseContext>(0);
}

MySQLParser::DuplicateAsQueryExpressionContext* MySQLParser::CreateTableContext::duplicateAsQueryExpression() {
  return getRuleContext<MySQLParser::DuplicateAsQueryExpressionContext>(0);
}


size_t MySQLParser::CreateTableContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTable;
}

void MySQLParser::CreateTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTable(this);
}

void MySQLParser::CreateTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTable(this);
}


std::any MySQLParser::CreateTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTableContext* MySQLParser::createTable() {
  CreateTableContext *_localctx = _tracker.createInstance<CreateTableContext>(_ctx, getState());
  enterRule(_localctx, 86, MySQLParser::RuleCreateTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2182);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2181);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2184);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2186);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 107, _ctx)) {
    case 1: {
      setState(2185);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2188);
    tableName();
    setState(2211);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 112, _ctx)) {
    case 1: {
      setState(2193);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 108, _ctx)) {
      case 1: {
        setState(2189);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(2190);
        tableElementList();
        setState(2191);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(2196);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 109, _ctx)) {
      case 1: {
        setState(2195);
        createTableOptions();
        break;
      }

      default:
        break;
      }
      setState(2199);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 110, _ctx)) {
      case 1: {
        setState(2198);
        partitionClause();
        break;
      }

      default:
        break;
      }
      setState(2202);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 111, _ctx)) {
      case 1: {
        setState(2201);
        duplicateAsQueryExpression();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2204);
      match(MySQLParser::LIKE_SYMBOL);
      setState(2205);
      tableRef();
      break;
    }

    case 3: {
      setState(2206);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2207);
      match(MySQLParser::LIKE_SYMBOL);
      setState(2208);
      tableRef();
      setState(2209);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementListContext ------------------------------------------------------------------

MySQLParser::TableElementListContext::TableElementListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TableElementContext *> MySQLParser::TableElementListContext::tableElement() {
  return getRuleContexts<MySQLParser::TableElementContext>();
}

MySQLParser::TableElementContext* MySQLParser::TableElementListContext::tableElement(size_t i) {
  return getRuleContext<MySQLParser::TableElementContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableElementListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableElementListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableElementListContext::getRuleIndex() const {
  return MySQLParser::RuleTableElementList;
}

void MySQLParser::TableElementListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElementList(this);
}

void MySQLParser::TableElementListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElementList(this);
}


std::any MySQLParser::TableElementListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElementList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementListContext* MySQLParser::tableElementList() {
  TableElementListContext *_localctx = _tracker.createInstance<TableElementListContext>(_ctx, getState());
  enterRule(_localctx, 88, MySQLParser::RuleTableElementList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2213);
    tableElement();
    setState(2218);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2214);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2215);
      tableElement();
      setState(2220);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementContext ------------------------------------------------------------------

MySQLParser::TableElementContext::TableElementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ColumnDefinitionContext* MySQLParser::TableElementContext::columnDefinition() {
  return getRuleContext<MySQLParser::ColumnDefinitionContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::TableElementContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}


size_t MySQLParser::TableElementContext::getRuleIndex() const {
  return MySQLParser::RuleTableElement;
}

void MySQLParser::TableElementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElement(this);
}

void MySQLParser::TableElementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElement(this);
}


std::any MySQLParser::TableElementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementContext* MySQLParser::tableElement() {
  TableElementContext *_localctx = _tracker.createInstance<TableElementContext>(_ctx, getState());
  enterRule(_localctx, 90, MySQLParser::RuleTableElement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2223);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 114, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2221);
      columnDefinition();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2222);
      tableConstraintDef();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DuplicateAsQueryExpressionContext ------------------------------------------------------------------

MySQLParser::DuplicateAsQueryExpressionContext::DuplicateAsQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::DuplicateAsQueryExpressionContext::queryExpressionOrParens() {
  return getRuleContext<MySQLParser::QueryExpressionOrParensContext>(0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQueryExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQueryExpressionContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQueryExpressionContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DuplicateAsQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleDuplicateAsQueryExpression;
}

void MySQLParser::DuplicateAsQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDuplicateAsQueryExpression(this);
}

void MySQLParser::DuplicateAsQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDuplicateAsQueryExpression(this);
}


std::any MySQLParser::DuplicateAsQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDuplicateAsQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DuplicateAsQueryExpressionContext* MySQLParser::duplicateAsQueryExpression() {
  DuplicateAsQueryExpressionContext *_localctx = _tracker.createInstance<DuplicateAsQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 92, MySQLParser::RuleDuplicateAsQueryExpression);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2226);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 115, _ctx)) {
    case 1: {
      setState(2225);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(2229);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 116, _ctx)) {
    case 1: {
      setState(2228);
      match(MySQLParser::AS_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2231);
    queryExpressionOrParens();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionOrParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionOrParensContext::QueryExpressionOrParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionOrParensContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionOrParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::QueryExpressionOrParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionOrParens;
}

void MySQLParser::QueryExpressionOrParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionOrParens(this);
}

void MySQLParser::QueryExpressionOrParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionOrParens(this);
}


std::any MySQLParser::QueryExpressionOrParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionOrParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::queryExpressionOrParens() {
  QueryExpressionOrParensContext *_localctx = _tracker.createInstance<QueryExpressionOrParensContext>(_ctx, getState());
  enterRule(_localctx, 94, MySQLParser::RuleQueryExpressionOrParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2235);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 117, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2233);
      queryExpression();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2234);
      queryExpressionParens();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoutineContext ------------------------------------------------------------------

MySQLParser::CreateRoutineContext::CreateRoutineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateRoutineContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateRoutineContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateRoutineContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::CreateRoutineContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRoutine;
}

void MySQLParser::CreateRoutineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRoutine(this);
}

void MySQLParser::CreateRoutineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRoutine(this);
}


std::any MySQLParser::CreateRoutineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRoutine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoutineContext* MySQLParser::createRoutine() {
  CreateRoutineContext *_localctx = _tracker.createInstance<CreateRoutineContext>(_ctx, getState());
  enterRule(_localctx, 96, MySQLParser::RuleCreateRoutine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2237);
    match(MySQLParser::CREATE_SYMBOL);
    setState(2241);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 118, _ctx)) {
    case 1: {
      setState(2238);
      createProcedure();
      break;
    }

    case 2: {
      setState(2239);
      createFunction();
      break;
    }

    case 3: {
      setState(2240);
      createUdf();
      break;
    }

    default:
      break;
    }
    setState(2244);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SEMICOLON_SYMBOL) {
      setState(2243);
      match(MySQLParser::SEMICOLON_SYMBOL);
    }
    setState(2246);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateProcedureContext ------------------------------------------------------------------

MySQLParser::CreateProcedureContext::CreateProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureNameContext* MySQLParser::CreateProcedureContext::procedureName() {
  return getRuleContext<MySQLParser::ProcedureNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateProcedureContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateProcedureContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateProcedureContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::ProcedureParameterContext *> MySQLParser::CreateProcedureContext::procedureParameter() {
  return getRuleContexts<MySQLParser::ProcedureParameterContext>();
}

MySQLParser::ProcedureParameterContext* MySQLParser::CreateProcedureContext::procedureParameter(size_t i) {
  return getRuleContext<MySQLParser::ProcedureParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateProcedureContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateProcedureContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateProcedureContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleCreateProcedure;
}

void MySQLParser::CreateProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateProcedure(this);
}

void MySQLParser::CreateProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateProcedure(this);
}


std::any MySQLParser::CreateProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateProcedureContext* MySQLParser::createProcedure() {
  CreateProcedureContext *_localctx = _tracker.createInstance<CreateProcedureContext>(_ctx, getState());
  enterRule(_localctx, 98, MySQLParser::RuleCreateProcedure);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2249);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2248);
      definerClause();
    }
    setState(2251);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2254);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 121, _ctx)) {
    case 1: {
      setState(2252);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2253);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2256);
    procedureName();
    setState(2257);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2266);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 123, _ctx)) {
    case 1: {
      setState(2258);
      procedureParameter();
      setState(2263);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2259);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2260);
        procedureParameter();
        setState(2265);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2268);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2272);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2269);
        routineCreateOption(); 
      }
      setState(2274);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx);
    }
    setState(2275);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateFunctionContext ------------------------------------------------------------------

MySQLParser::CreateFunctionContext::CreateFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionNameContext* MySQLParser::CreateFunctionContext::functionName() {
  return getRuleContext<MySQLParser::FunctionNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

MySQLParser::TypeWithOptCollateContext* MySQLParser::CreateFunctionContext::typeWithOptCollate() {
  return getRuleContext<MySQLParser::TypeWithOptCollateContext>(0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateFunctionContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateFunctionContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateFunctionContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::FunctionParameterContext *> MySQLParser::CreateFunctionContext::functionParameter() {
  return getRuleContexts<MySQLParser::FunctionParameterContext>();
}

MySQLParser::FunctionParameterContext* MySQLParser::CreateFunctionContext::functionParameter(size_t i) {
  return getRuleContext<MySQLParser::FunctionParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateFunctionContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateFunctionContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateFunctionContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateFunction;
}

void MySQLParser::CreateFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateFunction(this);
}

void MySQLParser::CreateFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateFunction(this);
}


std::any MySQLParser::CreateFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateFunctionContext* MySQLParser::createFunction() {
  CreateFunctionContext *_localctx = _tracker.createInstance<CreateFunctionContext>(_ctx, getState());
  enterRule(_localctx, 100, MySQLParser::RuleCreateFunction);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2278);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2277);
      definerClause();
    }
    setState(2280);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2283);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 126, _ctx)) {
    case 1: {
      setState(2281);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2282);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2285);
    functionName();
    setState(2286);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2295);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 128, _ctx)) {
    case 1: {
      setState(2287);
      functionParameter();
      setState(2292);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2288);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2289);
        functionParameter();
        setState(2294);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2297);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2298);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2299);
    typeWithOptCollate();
    setState(2303);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 129, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2300);
        routineCreateOption(); 
      }
      setState(2305);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 129, _ctx);
    }
    setState(2306);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUdfContext ------------------------------------------------------------------

MySQLParser::CreateUdfContext::CreateUdfContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUdfContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::UdfNameContext* MySQLParser::CreateUdfContext::udfName() {
  return getRuleContext<MySQLParser::UdfNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::SONAME_SYMBOL() {
  return getToken(MySQLParser::SONAME_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateUdfContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::STRING_SYMBOL() {
  return getToken(MySQLParser::STRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::INT_SYMBOL() {
  return getToken(MySQLParser::INT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::REAL_SYMBOL() {
  return getToken(MySQLParser::REAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::DECIMAL_SYMBOL() {
  return getToken(MySQLParser::DECIMAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::AGGREGATE_SYMBOL() {
  return getToken(MySQLParser::AGGREGATE_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateUdfContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateUdfContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUdf;
}

void MySQLParser::CreateUdfContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUdf(this);
}

void MySQLParser::CreateUdfContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUdf(this);
}


std::any MySQLParser::CreateUdfContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUdf(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUdfContext* MySQLParser::createUdf() {
  CreateUdfContext *_localctx = _tracker.createInstance<CreateUdfContext>(_ctx, getState());
  enterRule(_localctx, 102, MySQLParser::RuleCreateUdf);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2309);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::AGGREGATE_SYMBOL) {
      setState(2308);
      match(MySQLParser::AGGREGATE_SYMBOL);
    }
    setState(2311);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2314);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 131, _ctx)) {
    case 1: {
      setState(2312);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2313);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2316);
    udfName();
    setState(2317);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2318);
    antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DECIMAL_SYMBOL || _la == MySQLParser::INT_SYMBOL || _la == MySQLParser::REAL_SYMBOL || _la == MySQLParser::STRING_SYMBOL)) {
      antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2319);
    match(MySQLParser::SONAME_SYMBOL);
    setState(2320);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineCreateOptionContext ------------------------------------------------------------------

MySQLParser::RoutineCreateOptionContext::RoutineCreateOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::RoutineOptionContext* MySQLParser::RoutineCreateOptionContext::routineOption() {
  return getRuleContext<MySQLParser::RoutineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::DETERMINISTIC_SYMBOL() {
  return getToken(MySQLParser::DETERMINISTIC_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}


size_t MySQLParser::RoutineCreateOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineCreateOption;
}

void MySQLParser::RoutineCreateOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineCreateOption(this);
}

void MySQLParser::RoutineCreateOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineCreateOption(this);
}


std::any MySQLParser::RoutineCreateOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineCreateOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::routineCreateOption() {
  RoutineCreateOptionContext *_localctx = _tracker.createInstance<RoutineCreateOptionContext>(_ctx, getState());
  enterRule(_localctx, 104, MySQLParser::RuleRoutineCreateOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2327);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::CONTAINS_SYMBOL:
      case MySQLParser::LANGUAGE_SYMBOL:
      case MySQLParser::MODIFIES_SYMBOL:
      case MySQLParser::NO_SYMBOL:
      case MySQLParser::READS_SYMBOL:
      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2322);
        routineOption();
        break;
      }

      case MySQLParser::DETERMINISTIC_SYMBOL:
      case MySQLParser::NOT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2324);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NOT_SYMBOL) {
          setState(2323);
          match(MySQLParser::NOT_SYMBOL);
        }
        setState(2326);
        match(MySQLParser::DETERMINISTIC_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineAlterOptionsContext ------------------------------------------------------------------

MySQLParser::RoutineAlterOptionsContext::RoutineAlterOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::RoutineAlterOptionsContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::RoutineAlterOptionsContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}


size_t MySQLParser::RoutineAlterOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineAlterOptions;
}

void MySQLParser::RoutineAlterOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineAlterOptions(this);
}

void MySQLParser::RoutineAlterOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineAlterOptions(this);
}


std::any MySQLParser::RoutineAlterOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineAlterOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::routineAlterOptions() {
  RoutineAlterOptionsContext *_localctx = _tracker.createInstance<RoutineAlterOptionsContext>(_ctx, getState());
  enterRule(_localctx, 106, MySQLParser::RuleRoutineAlterOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2330); 
    _errHandler->sync(this);
    _la = _input->LA(1);
    do {
      setState(2329);
      routineCreateOption();
      setState(2332); 
      _errHandler->sync(this);
      _la = _input->LA(1);
    } while (((((_la - 75) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 75)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 75))
      | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 75))
      | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 75)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 347) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 347)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 347))
      | (1ULL << (MySQLParser::NOT_SYMBOL - 347))
      | (1ULL << (MySQLParser::NO_SYMBOL - 347)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineOptionContext ------------------------------------------------------------------

MySQLParser::RoutineOptionContext::RoutineOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::RoutineOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::LANGUAGE_SYMBOL() {
  return getToken(MySQLParser::LANGUAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::CONTAINS_SYMBOL() {
  return getToken(MySQLParser::CONTAINS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::READS_SYMBOL() {
  return getToken(MySQLParser::READS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::MODIFIES_SYMBOL() {
  return getToken(MySQLParser::MODIFIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::RoutineOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineOption;
}

void MySQLParser::RoutineOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineOption(this);
}

void MySQLParser::RoutineOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineOption(this);
}


std::any MySQLParser::RoutineOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineOptionContext* MySQLParser::routineOption() {
  RoutineOptionContext *_localctx = _tracker.createInstance<RoutineOptionContext>(_ctx, getState());
  enterRule(_localctx, 108, MySQLParser::RuleRoutineOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2351);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2334);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::COMMENT_SYMBOL);
        setState(2335);
        textLiteral();
        break;
      }

      case MySQLParser::LANGUAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2336);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::LANGUAGE_SYMBOL);
        setState(2337);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2338);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::NO_SYMBOL);
        setState(2339);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::CONTAINS_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2340);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::CONTAINS_SYMBOL);
        setState(2341);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::READS_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2342);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::READS_SYMBOL);
        setState(2343);
        match(MySQLParser::SQL_SYMBOL);
        setState(2344);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::MODIFIES_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2345);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::MODIFIES_SYMBOL);
        setState(2346);
        match(MySQLParser::SQL_SYMBOL);
        setState(2347);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2348);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::SQL_SYMBOL);
        setState(2349);
        match(MySQLParser::SECURITY_SYMBOL);
        setState(2350);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _input->LT(1);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
          antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexContext ------------------------------------------------------------------

MySQLParser::CreateIndexContext::CreateIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CreateIndexTargetContext* MySQLParser::CreateIndexContext::createIndexTarget() {
  return getRuleContext<MySQLParser::CreateIndexTargetContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::IndexNameContext* MySQLParser::CreateIndexContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

MySQLParser::OnlineOptionContext* MySQLParser::CreateIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::FULLTEXT_SYMBOL() {
  return getToken(MySQLParser::FULLTEXT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::CreateIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::UNIQUE_SYMBOL() {
  return getToken(MySQLParser::UNIQUE_SYMBOL, 0);
}

std::vector<MySQLParser::IndexOptionContext *> MySQLParser::CreateIndexContext::indexOption() {
  return getRuleContexts<MySQLParser::IndexOptionContext>();
}

MySQLParser::IndexOptionContext* MySQLParser::CreateIndexContext::indexOption(size_t i) {
  return getRuleContext<MySQLParser::IndexOptionContext>(i);
}

std::vector<MySQLParser::FulltextIndexOptionContext *> MySQLParser::CreateIndexContext::fulltextIndexOption() {
  return getRuleContexts<MySQLParser::FulltextIndexOptionContext>();
}

MySQLParser::FulltextIndexOptionContext* MySQLParser::CreateIndexContext::fulltextIndexOption(size_t i) {
  return getRuleContext<MySQLParser::FulltextIndexOptionContext>(i);
}

std::vector<MySQLParser::SpatialIndexOptionContext *> MySQLParser::CreateIndexContext::spatialIndexOption() {
  return getRuleContexts<MySQLParser::SpatialIndexOptionContext>();
}

MySQLParser::SpatialIndexOptionContext* MySQLParser::CreateIndexContext::spatialIndexOption(size_t i) {
  return getRuleContext<MySQLParser::SpatialIndexOptionContext>(i);
}

MySQLParser::IndexTypeClauseContext* MySQLParser::CreateIndexContext::indexTypeClause() {
  return getRuleContext<MySQLParser::IndexTypeClauseContext>(0);
}

MySQLParser::IndexNameAndTypeContext* MySQLParser::CreateIndexContext::indexNameAndType() {
  return getRuleContext<MySQLParser::IndexNameAndTypeContext>(0);
}


size_t MySQLParser::CreateIndexContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndex;
}

void MySQLParser::CreateIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndex(this);
}

void MySQLParser::CreateIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndex(this);
}


std::any MySQLParser::CreateIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexContext* MySQLParser::createIndex() {
  CreateIndexContext *_localctx = _tracker.createInstance<CreateIndexContext>(_ctx, getState());
  enterRule(_localctx, 110, MySQLParser::RuleCreateIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2354);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2353);
      onlineOption();
    }
    setState(2397);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INDEX_SYMBOL:
      case MySQLParser::UNIQUE_SYMBOL: {
        setState(2357);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::UNIQUE_SYMBOL) {
          setState(2356);
          match(MySQLParser::UNIQUE_SYMBOL);
        }
        setState(2359);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
        setState(2368);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 140, _ctx)) {
        case 1: {
          setState(2360);

          if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
          setState(2361);
          indexName();
          setState(2363);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::TYPE_SYMBOL

          || _la == MySQLParser::USING_SYMBOL) {
            setState(2362);
            indexTypeClause();
          }
          break;
        }

        case 2: {
          setState(2366);
          _errHandler->sync(this);

          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 139, _ctx)) {
          case 1: {
            setState(2365);
            indexNameAndType();
            break;
          }

          default:
            break;
          }
          break;
        }

        default:
          break;
        }
        setState(2370);
        createIndexTarget();
        setState(2374);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 141, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2371);
            indexOption(); 
          }
          setState(2376);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 141, _ctx);
        }
        break;
      }

      case MySQLParser::FULLTEXT_SYMBOL: {
        setState(2377);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::FULLTEXT_SYMBOL);
        setState(2378);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2379);
        indexName();
        setState(2380);
        createIndexTarget();
        setState(2384);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2381);
            fulltextIndexOption(); 
          }
          setState(2386);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        setState(2387);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::SPATIAL_SYMBOL);
        setState(2388);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2389);
        indexName();
        setState(2390);
        createIndexTarget();
        setState(2394);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 143, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2391);
            spatialIndexOption(); 
          }
          setState(2396);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 143, _ctx);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
    setState(2400);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2399);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexNameAndTypeContext ------------------------------------------------------------------

MySQLParser::IndexNameAndTypeContext::IndexNameAndTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexNameContext* MySQLParser::IndexNameAndTypeContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::IndexTypeContext* MySQLParser::IndexNameAndTypeContext::indexType() {
  return getRuleContext<MySQLParser::IndexTypeContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::TYPE_SYMBOL() {
  return getToken(MySQLParser::TYPE_SYMBOL, 0);
}


size_t MySQLParser::IndexNameAndTypeContext::getRuleIndex() const {
  return MySQLParser::RuleIndexNameAndType;
}

void MySQLParser::IndexNameAndTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexNameAndType(this);
}

void MySQLParser::IndexNameAndTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexNameAndType(this);
}


std::any MySQLParser::IndexNameAndTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexNameAndType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexNameAndTypeContext* MySQLParser::indexNameAndType() {
  IndexNameAndTypeContext *_localctx = _tracker.createInstance<IndexNameAndTypeContext>(_ctx, getState());
  enterRule(_localctx, 112, MySQLParser::RuleIndexNameAndType);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2412);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 147, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2402);
      indexName();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2404);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 146, _ctx)) {
      case 1: {
        setState(2403);
        indexName();
        break;
      }

      default:
        break;
      }
      setState(2406);
      match(MySQLParser::USING_SYMBOL);
      setState(2407);
      indexType();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2408);
      indexName();
      setState(2409);
      match(MySQLParser::TYPE_SYMBOL);
      setState(2410);
      indexType();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexTargetContext ------------------------------------------------------------------

MySQLParser::CreateIndexTargetContext::CreateIndexTargetContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateIndexTargetContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateIndexTargetContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::KeyListVariantsContext* MySQLParser::CreateIndexTargetContext::keyListVariants() {
  return getRuleContext<MySQLParser::KeyListVariantsContext>(0);
}


size_t MySQLParser::CreateIndexTargetContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndexTarget;
}

void MySQLParser::CreateIndexTargetContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndexTarget(this);
}

void MySQLParser::CreateIndexTargetContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndexTarget(this);
}


std::any MySQLParser::CreateIndexTargetContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndexTarget(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexTargetContext* MySQLParser::createIndexTarget() {
  CreateIndexTargetContext *_localctx = _tracker.createInstance<CreateIndexTargetContext>(_ctx, getState());
  enterRule(_localctx, 114, MySQLParser::RuleCreateIndexTarget);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2414);
    match(MySQLParser::ON_SYMBOL);
    setState(2415);
    tableRef();
    setState(2416);
    keyListVariants();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateLogfileGroupContext ------------------------------------------------------------------

MySQLParser::CreateLogfileGroupContext::CreateLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupNameContext* MySQLParser::CreateLogfileGroupContext::logfileGroupName() {
  return getRuleContext<MySQLParser::LogfileGroupNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::CreateLogfileGroupContext::logfileGroupOptions() {
  return getRuleContext<MySQLParser::LogfileGroupOptionsContext>(0);
}


size_t MySQLParser::CreateLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleCreateLogfileGroup;
}

void MySQLParser::CreateLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateLogfileGroup(this);
}

void MySQLParser::CreateLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateLogfileGroup(this);
}


std::any MySQLParser::CreateLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::createLogfileGroup() {
  CreateLogfileGroupContext *_localctx = _tracker.createInstance<CreateLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 116, MySQLParser::RuleCreateLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2418);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2419);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2420);
    logfileGroupName();
    setState(2421);
    match(MySQLParser::ADD_SYMBOL);
    setState(2422);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(2423);
    textLiteral();
    setState(2425);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2424);
      logfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionsContext::LogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LogfileGroupOptionContext *> MySQLParser::LogfileGroupOptionsContext::logfileGroupOption() {
  return getRuleContexts<MySQLParser::LogfileGroupOptionContext>();
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::LogfileGroupOptionsContext::logfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::LogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::LogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOptions;
}

void MySQLParser::LogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOptions(this);
}

void MySQLParser::LogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOptions(this);
}


std::any MySQLParser::LogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::logfileGroupOptions() {
  LogfileGroupOptionsContext *_localctx = _tracker.createInstance<LogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 118, MySQLParser::RuleLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2427);
    logfileGroupOption();
    setState(2434);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(2429);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2428);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2431);
      logfileGroupOption();
      setState(2436);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionContext::LogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionUndoRedoBufferSize() {
  return getRuleContext<MySQLParser::TsOptionUndoRedoBufferSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::LogfileGroupOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::LogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::LogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::LogfileGroupOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}


size_t MySQLParser::LogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOption;
}

void MySQLParser::LogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOption(this);
}

void MySQLParser::LogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOption(this);
}


std::any MySQLParser::LogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::logfileGroupOption() {
  LogfileGroupOptionContext *_localctx = _tracker.createInstance<LogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 120, MySQLParser::RuleLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2443);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2437);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::REDO_BUFFER_SIZE_SYMBOL:
      case MySQLParser::UNDO_BUFFER_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2438);
        tsOptionUndoRedoBufferSize();
        break;
      }

      case MySQLParser::NODEGROUP_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2439);
        tsOptionNodegroup();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2440);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2441);
        tsOptionWait();
        break;
      }

      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2442);
        tsOptionComment();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateServerContext ------------------------------------------------------------------

MySQLParser::CreateServerContext::CreateServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerNameContext* MySQLParser::CreateServerContext::serverName() {
  return getRuleContext<MySQLParser::ServerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::WRAPPER_SYMBOL() {
  return getToken(MySQLParser::WRAPPER_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::CreateServerContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::CreateServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::CreateServerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateServer;
}

void MySQLParser::CreateServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateServer(this);
}

void MySQLParser::CreateServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateServer(this);
}


std::any MySQLParser::CreateServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateServerContext* MySQLParser::createServer() {
  CreateServerContext *_localctx = _tracker.createInstance<CreateServerContext>(_ctx, getState());
  enterRule(_localctx, 122, MySQLParser::RuleCreateServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2445);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2446);
    serverName();
    setState(2447);
    match(MySQLParser::FOREIGN_SYMBOL);
    setState(2448);
    match(MySQLParser::DATA_SYMBOL);
    setState(2449);
    match(MySQLParser::WRAPPER_SYMBOL);
    setState(2450);
    textOrIdentifier();
    setState(2451);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionsContext ------------------------------------------------------------------

MySQLParser::ServerOptionsContext::ServerOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPTIONS_SYMBOL() {
  return getToken(MySQLParser::OPTIONS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

std::vector<MySQLParser::ServerOptionContext *> MySQLParser::ServerOptionsContext::serverOption() {
  return getRuleContexts<MySQLParser::ServerOptionContext>();
}

MySQLParser::ServerOptionContext* MySQLParser::ServerOptionsContext::serverOption(size_t i) {
  return getRuleContext<MySQLParser::ServerOptionContext>(i);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ServerOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ServerOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleServerOptions;
}

void MySQLParser::ServerOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOptions(this);
}

void MySQLParser::ServerOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOptions(this);
}


std::any MySQLParser::ServerOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionsContext* MySQLParser::serverOptions() {
  ServerOptionsContext *_localctx = _tracker.createInstance<ServerOptionsContext>(_ctx, getState());
  enterRule(_localctx, 124, MySQLParser::RuleServerOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2453);
    match(MySQLParser::OPTIONS_SYMBOL);
    setState(2454);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2455);
    serverOption();
    setState(2460);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2456);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2457);
      serverOption();
      setState(2462);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
    setState(2463);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionContext ------------------------------------------------------------------

MySQLParser::ServerOptionContext::ServerOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::ServerOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::HOST_SYMBOL() {
  return getToken(MySQLParser::HOST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::USER_SYMBOL() {
  return getToken(MySQLParser::USER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PASSWORD_SYMBOL() {
  return getToken(MySQLParser::PASSWORD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::SOCKET_SYMBOL() {
  return getToken(MySQLParser::SOCKET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::OWNER_SYMBOL() {
  return getToken(MySQLParser::OWNER_SYMBOL, 0);
}

MySQLParser::Ulong_numberContext* MySQLParser::ServerOptionContext::ulong_number() {
  return getRuleContext<MySQLParser::Ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PORT_SYMBOL() {
  return getToken(MySQLParser::PORT_SYMBOL, 0);
}


size_t MySQLParser::ServerOptionContext::getRuleIndex() const {
  return MySQLParser::RuleServerOption;
}

void MySQLParser::ServerOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOption(this);
}

void MySQLParser::ServerOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOption(this);
}


std::any MySQLParser::ServerOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionContext* MySQLParser::serverOption() {
  ServerOptionContext *_localctx = _tracker.createInstance<ServerOptionContext>(_ctx, getState());
  enterRule(_localctx, 126, MySQLParser::RuleServerOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2479);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::HOST_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2465);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::HOST_SYMBOL);
        setState(2466);
        textLiteral();
        break;
      }

      case MySQLParser::DATABASE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2467);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::DATABASE_SYMBOL);
        setState(2468);
        textLiteral();
        break;
      }

      case MySQLParser::USER_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2469);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::USER_SYMBOL);
        setState(2470);
        textLiteral();
        break;
      }

      case MySQLParser::PASSWORD_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2471);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PASSWORD_SYMBOL);
        setState(2472);
        textLiteral();
        break;
      }

      case MySQLParser::SOCKET_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2473);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::SOCKET_SYMBOL);
        setState(2474);
        textLiteral();
        break;
      }

      case MySQLParser::OWNER_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2475);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::OWNER_SYMBOL);
        setState(2476);
        textLiteral();
        break;
      }

      case MySQLParser::PORT_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2477);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PORT_SYMBOL);
        setState(2478);
        ulong_number();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateTablespaceContext::CreateTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

MySQLParser::TsDataFileNameContext* MySQLParser::CreateTablespaceContext::tsDataFileName() {
  return getRuleContext<MySQLParser::TsDataFileNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::USE_SYMBOL() {
  return getToken(MySQLParser::USE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::CreateTablespaceContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::CreateTablespaceContext::tablespaceOptions() {
  return getRuleContext<MySQLParser::TablespaceOptionsContext>(0);
}


size_t MySQLParser::CreateTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTablespace;
}

void MySQLParser::CreateTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTablespace(this);
}

void MySQLParser::CreateTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTablespace(this);
}


std::any MySQLParser::CreateTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTablespaceContext* MySQLParser::createTablespace() {
  CreateTablespaceContext *_localctx = _tracker.createInstance<CreateTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 128, MySQLParser::RuleCreateTablespace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2481);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2482);
    tablespaceName();
    setState(2483);
    tsDataFileName();
    setState(2488);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 154, _ctx)) {
    case 1: {
      setState(2484);
      match(MySQLParser::USE_SYMBOL);
      setState(2485);
      match(MySQLParser::LOGFILE_SYMBOL);
      setState(2486);
      match(MySQLParser::GROUP_SYMBOL);
      setState(2487);
      logfileGroupRef();
      break;
    }

    default:
      break;
    }
    setState(2491);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 155, _ctx)) {
    case 1: {
      setState(2490);
      tablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateUndoTablespaceContext::CreateUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateUndoTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::CreateUndoTablespaceContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::CreateUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::CreateUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUndoTablespace;
}

void MySQLParser::CreateUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUndoTablespace(this);
}

void MySQLParser::CreateUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUndoTablespace(this);
}


std::any MySQLParser::CreateUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::createUndoTablespace() {
  CreateUndoTablespaceContext *_localctx = _tracker.createInstance<CreateUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 130, MySQLParser::RuleCreateUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2493);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2494);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2495);
    tablespaceName();
    setState(2496);
    match(MySQLParser::ADD_SYMBOL);
    setState(2497);
    tsDataFile();
    setState(2499);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2498);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileNameContext ------------------------------------------------------------------

MySQLParser::TsDataFileNameContext::TsDataFileNameContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileNameContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::TsDataFileNameContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}


size_t MySQLParser::TsDataFileNameContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFileName;
}

void MySQLParser::TsDataFileNameContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFileName(this);
}

void MySQLParser::TsDataFileNameContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFileName(this);
}


std::any MySQLParser::TsDataFileNameContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFileName(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileNameContext* MySQLParser::tsDataFileName() {
  TsDataFileNameContext *_localctx = _tracker.createInstance<TsDataFileNameContext>(_ctx, getState());
  enterRule(_localctx, 132, MySQLParser::RuleTsDataFileName);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2508);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 158, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2501);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2504);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 157, _ctx)) {
      case 1: {
        setState(2502);
        match(MySQLParser::ADD_SYMBOL);
        setState(2503);
        tsDataFile();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2506);
      match(MySQLParser::ADD_SYMBOL);
      setState(2507);
      tsDataFile();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileContext ------------------------------------------------------------------

MySQLParser::TsDataFileContext::TsDataFileContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsDataFileContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}


size_t MySQLParser::TsDataFileContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFile;
}

void MySQLParser::TsDataFileContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFile(this);
}

void MySQLParser::TsDataFileContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFile(this);
}


std::any MySQLParser::TsDataFileContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFile(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileContext* MySQLParser::tsDataFile() {
  TsDataFileContext *_localctx = _tracker.createInstance<TsDataFileContext>(_ctx, getState());
  enterRule(_localctx, 134, MySQLParser::RuleTsDataFile);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2510);
    match(MySQLParser::DATAFILE_SYMBOL);
    setState(2511);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionsContext::TablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TablespaceOptionContext *> MySQLParser::TablespaceOptionsContext::tablespaceOption() {
  return getRuleContexts<MySQLParser::TablespaceOptionContext>();
}

MySQLParser::TablespaceOptionContext* MySQLParser::TablespaceOptionsContext::tablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::TablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOptions;
}

void MySQLParser::TablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOptions(this);
}

void MySQLParser::TablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOptions(this);
}


std::any MySQLParser::TablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::tablespaceOptions() {
  TablespaceOptionsContext *_localctx = _tracker.createInstance<TablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 136, MySQLParser::RuleTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2513);
    tablespaceOption();
    setState(2520);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 160, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2515);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 159, _ctx)) {
        case 1: {
          setState(2514);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2517);
        tablespaceOption(); 
      }
      setState(2522);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 160, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionContext::TablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::TablespaceOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::TablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::TablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::TablespaceOptionContext::tsOptionExtentSize() {
  return getRuleContext<MySQLParser::TsOptionExtentSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::TablespaceOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::TablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::TablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::TablespaceOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::TablespaceOptionContext::tsOptionFileblockSize() {
  return getRuleContext<MySQLParser::TsOptionFileblockSizeContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::TablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}


size_t MySQLParser::TablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOption;
}

void MySQLParser::TablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOption(this);
}

void MySQLParser::TablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOption(this);
}


std::any MySQLParser::TablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionContext* MySQLParser::tablespaceOption() {
  TablespaceOptionContext *_localctx = _tracker.createInstance<TablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 138, MySQLParser::RuleTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2535);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 161, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2523);
      tsOptionInitialSize();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2524);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2525);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2526);
      tsOptionExtentSize();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2527);
      tsOptionNodegroup();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2528);
      tsOptionEngine();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2529);
      tsOptionWait();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(2530);
      tsOptionComment();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(2531);

      if (!(serverVersion >= 50707)) throw FailedPredicateException(this, "serverVersion >= 50707");
      setState(2532);
      tsOptionFileblockSize();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(2533);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2534);
      tsOptionEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionInitialSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionInitialSizeContext::TsOptionInitialSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionInitialSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionInitialSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionInitialSize;
}

void MySQLParser::TsOptionInitialSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionInitialSize(this);
}

void MySQLParser::TsOptionInitialSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionInitialSize(this);
}


std::any MySQLParser::TsOptionInitialSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionInitialSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::tsOptionInitialSize() {
  TsOptionInitialSizeContext *_localctx = _tracker.createInstance<TsOptionInitialSizeContext>(_ctx, getState());
  enterRule(_localctx, 140, MySQLParser::RuleTsOptionInitialSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2537);
    match(MySQLParser::INITIAL_SIZE_SYMBOL);
    setState(2539);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 162, _ctx)) {
    case 1: {
      setState(2538);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2541);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionUndoRedoBufferSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionUndoRedoBufferSizeContext::TsOptionUndoRedoBufferSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionUndoRedoBufferSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::UNDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::UNDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::REDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::REDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionUndoRedoBufferSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionUndoRedoBufferSize;
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionUndoRedoBufferSize(this);
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionUndoRedoBufferSize(this);
}


std::any MySQLParser::TsOptionUndoRedoBufferSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionUndoRedoBufferSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::tsOptionUndoRedoBufferSize() {
  TsOptionUndoRedoBufferSizeContext *_localctx = _tracker.createInstance<TsOptionUndoRedoBufferSizeContext>(_ctx, getState());
  enterRule(_localctx, 142, MySQLParser::RuleTsOptionUndoRedoBufferSize);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2543);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2545);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 163, _ctx)) {
    case 1: {
      setState(2544);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2547);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionAutoextendSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionAutoextendSizeContext::TsOptionAutoextendSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::AUTOEXTEND_SIZE_SYMBOL() {
  return getToken(MySQLParser::AUTOEXTEND_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionAutoextendSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionAutoextendSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionAutoextendSize;
}

void MySQLParser::TsOptionAutoextendSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionAutoextendSize(this);
}

void MySQLParser::TsOptionAutoextendSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionAutoextendSize(this);
}


std::any MySQLParser::TsOptionAutoextendSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionAutoextendSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::tsOptionAutoextendSize() {
  TsOptionAutoextendSizeContext *_localctx = _tracker.createInstance<TsOptionAutoextendSizeContext>(_ctx, getState());
  enterRule(_localctx, 144, MySQLParser::RuleTsOptionAutoextendSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2549);
    match(MySQLParser::AUTOEXTEND_SIZE_SYMBOL);
    setState(2551);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 164, _ctx)) {
    case 1: {
      setState(2550);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2553);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionMaxSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionMaxSizeContext::TsOptionMaxSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::MAX_SIZE_SYMBOL() {
  return getToken(MySQLParser::MAX_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionMaxSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionMaxSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionMaxSize;
}

void MySQLParser::TsOptionMaxSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionMaxSize(this);
}

void MySQLParser::TsOptionMaxSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionMaxSize(this);
}


std::any MySQLParser::TsOptionMaxSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionMaxSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::tsOptionMaxSize() {
  TsOptionMaxSizeContext *_localctx = _tracker.createInstance<TsOptionMaxSizeContext>(_ctx, getState());
  enterRule(_localctx, 146, MySQLParser::RuleTsOptionMaxSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2555);
    match(MySQLParser::MAX_SIZE_SYMBOL);
    setState(2557);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 165, _ctx)) {
    case 1: {
      setState(2556);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2559);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionExtentSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionExtentSizeContext::TsOptionExtentSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EXTENT_SIZE_SYMBOL() {
  return getToken(MySQLParser::EXTENT_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionExtentSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionExtentSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionExtentSize;
}

void MySQLParser::TsOptionExtentSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionExtentSize(this);
}

void MySQLParser::TsOptionExtentSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionExtentSize(this);
}


std::any MySQLParser::TsOptionExtentSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionExtentSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::tsOptionExtentSize() {
  TsOptionExtentSizeContext *_localctx = _tracker.createInstance<TsOptionExtentSizeContext>(_ctx, getState());
  enterRule(_localctx, 148, MySQLParser::RuleTsOptionExtentSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2561);
    match(MySQLParser::EXTENT_SIZE_SYMBOL);
    setState(2563);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 166, _ctx)) {
    case 1: {
      setState(2562);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2565);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionNodegroupContext ------------------------------------------------------------------

MySQLParser::TsOptionNodegroupContext::TsOptionNodegroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::NODEGROUP_SYMBOL() {
  return getToken(MySQLParser::NODEGROUP_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::TsOptionNodegroupContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionNodegroupContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionNodegroup;
}

void MySQLParser::TsOptionNodegroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionNodegroup(this);
}

void MySQLParser::TsOptionNodegroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionNodegroup(this);
}


std::any MySQLParser::TsOptionNodegroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionNodegroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::tsOptionNodegroup() {
  TsOptionNodegroupContext *_localctx = _tracker.createInstance<TsOptionNodegroupContext>(_ctx, getState());
  enterRule(_localctx, 150, MySQLParser::RuleTsOptionNodegroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2567);
    match(MySQLParser::NODEGROUP_SYMBOL);
    setState(2569);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EQUAL_OPERATOR) {
      setState(2568);
      match(MySQLParser::EQUAL_OPERATOR);
    }
    setState(2571);
    real_ulong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineContext::TsOptionEngineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::EngineRefContext* MySQLParser::TsOptionEngineContext::engineRef() {
  return getRuleContext<MySQLParser::EngineRefContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::STORAGE_SYMBOL() {
  return getToken(MySQLParser::STORAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngine;
}

void MySQLParser::TsOptionEngineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngine(this);
}

void MySQLParser::TsOptionEngineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngine(this);
}


std::any MySQLParser::TsOptionEngineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineContext* MySQLParser::tsOptionEngine() {
  TsOptionEngineContext *_localctx = _tracker.createInstance<TsOptionEngineContext>(_ctx, getState());
  enterRule(_localctx, 152, MySQLParser::RuleTsOptionEngine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2574);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::STORAGE_SYMBOL) {
      setState(2573);
      match(MySQLParser::STORAGE_SYMBOL);
    }
    setState(2576);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2578);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 169, _ctx)) {
    case 1: {
      setState(2577);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2580);
    engineRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionWaitContext ------------------------------------------------------------------

MySQLParser::TsOptionWaitContext::TsOptionWaitContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::WAIT_SYMBOL() {
  return getToken(MySQLParser::WAIT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::NO_WAIT_SYMBOL() {
  return getToken(MySQLParser::NO_WAIT_SYMBOL, 0);
}


size_t MySQLParser::TsOptionWaitContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionWait;
}

void MySQLParser::TsOptionWaitContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionWait(this);
}

void MySQLParser::TsOptionWaitContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionWait(this);
}


std::any MySQLParser::TsOptionWaitContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionWait(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionWaitContext* MySQLParser::tsOptionWait() {
  TsOptionWaitContext *_localctx = _tracker.createInstance<TsOptionWaitContext>(_ctx, getState());
  enterRule(_localctx, 154, MySQLParser::RuleTsOptionWait);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2582);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::WAIT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionCommentContext ------------------------------------------------------------------

MySQLParser::TsOptionCommentContext::TsOptionCommentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsOptionCommentContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionCommentContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionComment;
}

void MySQLParser::TsOptionCommentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionComment(this);
}

void MySQLParser::TsOptionCommentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionComment(this);
}


std::any MySQLParser::TsOptionCommentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionComment(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionCommentContext* MySQLParser::tsOptionComment() {
  TsOptionCommentContext *_localctx = _tracker.createInstance<TsOptionCommentContext>(_ctx, getState());
  enterRule(_localctx, 156, MySQLParser::RuleTsOptionComment);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2584);
    match(MySQLParser::COMMENT_SYMBOL);
    setState(2586);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 170, _ctx)) {
    case 1: {
      setState(2585);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2588);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionFileblockSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionFileblockSizeContext::TsOptionFileblockSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::FILE_BLOCK_SIZE_SYMBOL() {
  return getToken(MySQLParser::FILE_BLOCK_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionFileblockSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionFileblockSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionFileblockSize;
}

void MySQLParser::TsOptionFileblockSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionFileblockSize(this);
}

void MySQLParser::TsOptionFileblockSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionFileblockSize(this);
}


std::any MySQLParser::TsOptionFileblockSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionFileblockSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::tsOptionFileblockSize() {
  TsOptionFileblockSizeContext *_localctx = _tracker.createInstance<TsOptionFileblockSizeContext>(_ctx, getState());
  enterRule(_localctx, 158, MySQLParser::RuleTsOptionFileblockSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2590);
    match(MySQLParser::FILE_BLOCK_SIZE_SYMBOL);
    setState(2592);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 171, _ctx)) {
    case 1: {
      setState(2591);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2594);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEncryptionContext ------------------------------------------------------------------

MySQLParser::TsOptionEncryptionContext::TsOptionEncryptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::ENCRYPTION_SYMBOL() {
  return getToken(MySQLParser::ENCRYPTION_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::TsOptionEncryptionContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEncryptionContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEncryption;
}

void MySQLParser::TsOptionEncryptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEncryption(this);
}

void MySQLParser::TsOptionEncryptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEncryption(this);
}


std::any MySQLParser::TsOptionEncryptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEncryption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::tsOptionEncryption() {
  TsOptionEncryptionContext *_localctx = _tracker.createInstance<TsOptionEncryptionContext>(_ctx, getState());
  enterRule(_localctx, 160, MySQLParser::RuleTsOptionEncryption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2596);
    match(MySQLParser::ENCRYPTION_SYMBOL);
    setState(2598);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 172, _ctx)) {
    case 1: {
      setState(2597);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2600);
    textStringLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineAttributeContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineAttributeContext::TsOptionEngineAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineAttributeContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::JsonAttributeContext* MySQLParser::TsOptionEngineAttributeContext::jsonAttribute() {
  return getRuleContext<MySQLParser::JsonAttributeContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineAttributeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngineAttribute;
}

void MySQLParser::TsOptionEngineAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngineAttribute(this);
}

void MySQLParser::TsOptionEngineAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngineAttribute(this);
}


std::any MySQLParser::TsOptionEngineAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngineAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineAttributeContext* MySQLParser::tsOptionEngineAttribute() {
  TsOptionEngineAttributeContext *_localctx = _tracker.createInstance<TsOptionEngineAttributeContext>(_ctx, getState());
  enterRule(_localctx, 162, MySQLParser::RuleTsOptionEngineAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2602);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2604);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 173, _ctx)) {
    case 1: {
      setState(2603);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2606);
    jsonAttribute();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateViewContext ------------------------------------------------------------------

MySQLParser::CreateViewContext::CreateViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewNameContext* MySQLParser::CreateViewContext::viewName() {
  return getRuleContext<MySQLParser::ViewNameContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::CreateViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::CreateViewContext::viewReplaceOrAlgorithm() {
  return getRuleContext<MySQLParser::ViewReplaceOrAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::CreateViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::CreateViewContext::getRuleIndex() const {
  return MySQLParser::RuleCreateView;
}

void MySQLParser::CreateViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateView(this);
}

void MySQLParser::CreateViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateView(this);
}


std::any MySQLParser::CreateViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateViewContext* MySQLParser::createView() {
  CreateViewContext *_localctx = _tracker.createInstance<CreateViewContext>(_ctx, getState());
  enterRule(_localctx, 164, MySQLParser::RuleCreateView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2609);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::OR_SYMBOL) {
      setState(2608);
      viewReplaceOrAlgorithm();
    }
    setState(2612);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2611);
      definerClause();
    }
    setState(2615);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2614);
      viewSuid();
    }
    setState(2617);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2618);
    viewName();
    setState(2619);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewReplaceOrAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewReplaceOrAlgorithmContext::ViewReplaceOrAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::ViewReplaceOrAlgorithmContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}


size_t MySQLParser::ViewReplaceOrAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewReplaceOrAlgorithm;
}

void MySQLParser::ViewReplaceOrAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewReplaceOrAlgorithm(this);
}

void MySQLParser::ViewReplaceOrAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewReplaceOrAlgorithm(this);
}


std::any MySQLParser::ViewReplaceOrAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewReplaceOrAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::viewReplaceOrAlgorithm() {
  ViewReplaceOrAlgorithmContext *_localctx = _tracker.createInstance<ViewReplaceOrAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 166, MySQLParser::RuleViewReplaceOrAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2627);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2621);
        match(MySQLParser::OR_SYMBOL);
        setState(2622);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2624);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(2623);
          viewAlgorithm();
        }
        break;
      }

      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2626);
        viewAlgorithm();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewAlgorithmContext::ViewAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::UNDEFINED_SYMBOL() {
  return getToken(MySQLParser::UNDEFINED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::MERGE_SYMBOL() {
  return getToken(MySQLParser::MERGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::TEMPTABLE_SYMBOL() {
  return getToken(MySQLParser::TEMPTABLE_SYMBOL, 0);
}


size_t MySQLParser::ViewAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewAlgorithm;
}

void MySQLParser::ViewAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewAlgorithm(this);
}

void MySQLParser::ViewAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewAlgorithm(this);
}


std::any MySQLParser::ViewAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::viewAlgorithm() {
  ViewAlgorithmContext *_localctx = _tracker.createInstance<ViewAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 168, MySQLParser::RuleViewAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2629);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(2630);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(2631);
    antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::MERGE_SYMBOL || _la == MySQLParser::TEMPTABLE_SYMBOL

    || _la == MySQLParser::UNDEFINED_SYMBOL)) {
      antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewSuidContext ------------------------------------------------------------------

MySQLParser::ViewSuidContext::ViewSuidContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::ViewSuidContext::getRuleIndex() const {
  return MySQLParser::RuleViewSuid;
}

void MySQLParser::ViewSuidContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewSuid(this);
}

void MySQLParser::ViewSuidContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewSuid(this);
}


std::any MySQLParser::ViewSuidContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewSuid(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewSuidContext* MySQLParser::viewSuid() {
  ViewSuidContext *_localctx = _tracker.createInstance<ViewSuidContext>(_ctx, getState());
  enterRule(_localctx, 170, MySQLParser::RuleViewSuid);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2633);
    match(MySQLParser::SQL_SYMBOL);
    setState(2634);
    match(MySQLParser::SECURITY_SYMBOL);
    setState(2635);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTriggerContext ------------------------------------------------------------------

MySQLParser::CreateTriggerContext::CreateTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerNameContext* MySQLParser::CreateTriggerContext::triggerName() {
  return getRuleContext<MySQLParser::TriggerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTriggerContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::EACH_SYMBOL() {
  return getToken(MySQLParser::EACH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateTriggerContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::BEFORE_SYMBOL() {
  return getToken(MySQLParser::BEFORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateTriggerContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTriggerContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::CreateTriggerContext::triggerFollowsPrecedesClause() {
  return getRuleContext<MySQLParser::TriggerFollowsPrecedesClauseContext>(0);
}


size_t MySQLParser::CreateTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTrigger;
}

void MySQLParser::CreateTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTrigger(this);
}

void MySQLParser::CreateTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTrigger(this);
}


std::any MySQLParser::CreateTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTriggerContext* MySQLParser::createTrigger() {
  CreateTriggerContext *_localctx = _tracker.createInstance<CreateTriggerContext>(_ctx, getState());
  enterRule(_localctx, 172, MySQLParser::RuleCreateTrigger);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2638);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2637);
      definerClause();
    }
    setState(2640);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2643);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 180, _ctx)) {
    case 1: {
      setState(2641);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2642);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2645);
    triggerName();
    setState(2646);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::AFTER_SYMBOL

    || _la == MySQLParser::BEFORE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2647);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELETE_SYMBOL || _la == MySQLParser::INSERT_SYMBOL || _la == MySQLParser::UPDATE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2648);
    match(MySQLParser::ON_SYMBOL);
    setState(2649);
    tableRef();
    setState(2650);
    match(MySQLParser::FOR_SYMBOL);
    setState(2651);
    match(MySQLParser::EACH_SYMBOL);
    setState(2652);
    match(MySQLParser::ROW_SYMBOL);
    setState(2654);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 181, _ctx)) {
    case 1: {
      setState(2653);
      triggerFollowsPrecedesClause();
      break;
    }

    default:
      break;
    }
    setState(2656);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TriggerFollowsPrecedesClauseContext ------------------------------------------------------------------

MySQLParser::TriggerFollowsPrecedesClauseContext::TriggerFollowsPrecedesClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextOrIdentifierContext* MySQLParser::TriggerFollowsPrecedesClauseContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::FOLLOWS_SYMBOL() {
  return getToken(MySQLParser::FOLLOWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::PRECEDES_SYMBOL() {
  return getToken(MySQLParser::PRECEDES_SYMBOL, 0);
}


size_t MySQLParser::TriggerFollowsPrecedesClauseContext::getRuleIndex() const {
  return MySQLParser::RuleTriggerFollowsPrecedesClause;
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTriggerFollowsPrecedesClause(this);
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTriggerFollowsPrecedesClause(this);
}


std::any MySQLParser::TriggerFollowsPrecedesClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTriggerFollowsPrecedesClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::triggerFollowsPrecedesClause() {
  TriggerFollowsPrecedesClauseContext *_localctx = _tracker.createInstance<TriggerFollowsPrecedesClauseContext>(_ctx, getState());
  enterRule(_localctx, 174, MySQLParser::RuleTriggerFollowsPrecedesClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2658);
    antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::FOLLOWS_SYMBOL || _la == MySQLParser::PRECEDES_SYMBOL)) {
      antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2659);
    textOrIdentifier();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateEventContext ------------------------------------------------------------------

MySQLParser::CreateEventContext::CreateEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventNameContext* MySQLParser::CreateEventContext::eventName() {
  return getRuleContext<MySQLParser::EventNameContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::CreateEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::CreateEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateEventContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

MySQLParser::ReplicaContext* MySQLParser::CreateEventContext::replica() {
  return getRuleContext<MySQLParser::ReplicaContext>(0);
}


size_t MySQLParser::CreateEventContext::getRuleIndex() const {
  return MySQLParser::RuleCreateEvent;
}

void MySQLParser::CreateEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateEvent(this);
}

void MySQLParser::CreateEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateEvent(this);
}


std::any MySQLParser::CreateEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateEventContext* MySQLParser::createEvent() {
  CreateEventContext *_localctx = _tracker.createInstance<CreateEventContext>(_ctx, getState());
  enterRule(_localctx, 176, MySQLParser::RuleCreateEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2662);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2661);
      definerClause();
    }
    setState(2664);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2666);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 183, _ctx)) {
    case 1: {
      setState(2665);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2668);
    eventName();
    setState(2669);
    match(MySQLParser::ON_SYMBOL);
    setState(2670);
    match(MySQLParser::SCHEDULE_SYMBOL);
    setState(2671);
    schedule();
    setState(2678);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(2672);
      match(MySQLParser::ON_SYMBOL);
      setState(2673);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(2675);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(2674);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(2677);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(2686);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(2680);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(2681);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(2684);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(2682);
          match(MySQLParser::ON_SYMBOL);
          setState(2683);
          replica();
        }
        break;
      }

      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(2690);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(2688);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(2689);
      textLiteral();
    }
    setState(2692);
    match(MySQLParser::DO_SYMBOL);
    setState(2693);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoleContext ------------------------------------------------------------------

MySQLParser::CreateRoleContext::CreateRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::CreateRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateRoleContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateRoleContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRole;
}

void MySQLParser::CreateRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRole(this);
}

void MySQLParser::CreateRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRole(this);
}


std::any MySQLParser::CreateRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoleContext* MySQLParser::createRole() {
  CreateRoleContext *_localctx = _tracker.createInstance<CreateRoleContext>(_ctx, getState());
  enterRule(_localctx, 178, MySQLParser::RuleCreateRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2695);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2697);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 189, _ctx)) {
    case 1: {
      setState(2696);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2699);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::CreateSpatialReferenceContext::CreateSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::CreateSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

std::vector<MySQLParser::SrsAttributeContext *> MySQLParser::CreateSpatialReferenceContext::srsAttribute() {
  return getRuleContexts<MySQLParser::SrsAttributeContext>();
}

MySQLParser::SrsAttributeContext* MySQLParser::CreateSpatialReferenceContext::srsAttribute(size_t i) {
  return getRuleContext<MySQLParser::SrsAttributeContext>(i);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateSpatialReferenceContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateSpatialReference;
}

void MySQLParser::CreateSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateSpatialReference(this);
}

void MySQLParser::CreateSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateSpatialReference(this);
}


std::any MySQLParser::CreateSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::createSpatialReference() {
  CreateSpatialReferenceContext *_localctx = _tracker.createInstance<CreateSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 180, MySQLParser::RuleCreateSpatialReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2726);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2701);
        match(MySQLParser::OR_SYMBOL);
        setState(2702);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2703);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2704);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2705);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2706);
        real_ulonglong_number();
        setState(2710);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 715) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 715)) & ((1ULL << (MySQLParser::DEFINITION_SYMBOL - 715))
          | (1ULL << (MySQLParser::DESCRIPTION_SYMBOL - 715))
          | (1ULL << (MySQLParser::ORGANIZATION_SYMBOL - 715)))) != 0)) {
          setState(2707);
          srsAttribute();
          setState(2712);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2713);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2714);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2715);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2717);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 191, _ctx)) {
        case 1: {
          setState(2716);
          ifNotExists();
          break;
        }

        default:
          break;
        }
        setState(2719);
        real_ulonglong_number();
        setState(2723);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 715) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 715)) & ((1ULL << (MySQLParser::DEFINITION_SYMBOL - 715))
          | (1ULL << (MySQLParser::DESCRIPTION_SYMBOL - 715))
          | (1ULL << (MySQLParser::ORGANIZATION_SYMBOL - 715)))) != 0)) {
          setState(2720);
          srsAttribute();
          setState(2725);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SrsAttributeContext ------------------------------------------------------------------

MySQLParser::SrsAttributeContext::SrsAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::TEXT_SYMBOL() {
  return getToken(MySQLParser::TEXT_SYMBOL, 0);
}

MySQLParser::TextStringNoLinebreakContext* MySQLParser::SrsAttributeContext::textStringNoLinebreak() {
  return getRuleContext<MySQLParser::TextStringNoLinebreakContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DEFINITION_SYMBOL() {
  return getToken(MySQLParser::DEFINITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::ORGANIZATION_SYMBOL() {
  return getToken(MySQLParser::ORGANIZATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::SrsAttributeContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DESCRIPTION_SYMBOL() {
  return getToken(MySQLParser::DESCRIPTION_SYMBOL, 0);
}


size_t MySQLParser::SrsAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleSrsAttribute;
}

void MySQLParser::SrsAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSrsAttribute(this);
}

void MySQLParser::SrsAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSrsAttribute(this);
}


std::any MySQLParser::SrsAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSrsAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SrsAttributeContext* MySQLParser::srsAttribute() {
  SrsAttributeContext *_localctx = _tracker.createInstance<SrsAttributeContext>(_ctx, getState());
  enterRule(_localctx, 182, MySQLParser::RuleSrsAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2743);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NAME_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2728);
        match(MySQLParser::NAME_SYMBOL);
        setState(2729);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2730);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::DEFINITION_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2731);
        match(MySQLParser::DEFINITION_SYMBOL);
        setState(2732);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2733);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::ORGANIZATION_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2734);
        match(MySQLParser::ORGANIZATION_SYMBOL);
        setState(2735);
        textStringNoLinebreak();
        setState(2736);
        match(MySQLParser::IDENTIFIED_SYMBOL);
        setState(2737);
        match(MySQLParser::BY_SYMBOL);
        setState(2738);
        real_ulonglong_number();
        break;
      }

      case MySQLParser::DESCRIPTION_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2740);
        match(MySQLParser::DESCRIPTION_SYMBOL);
        setState(2741);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2742);
        textStringNoLinebreak();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropStatementContext ------------------------------------------------------------------

MySQLParser::DropStatementContext::DropStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropStatementContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::DropDatabaseContext* MySQLParser::DropStatementContext::dropDatabase() {
  return getRuleContext<MySQLParser::DropDatabaseContext>(0);
}

MySQLParser::DropEventContext* MySQLParser::DropStatementContext::dropEvent() {
  return getRuleContext<MySQLParser::DropEventContext>(0);
}

MySQLParser::DropFunctionContext* MySQLParser::DropStatementContext::dropFunction() {
  return getRuleContext<MySQLParser::DropFunctionContext>(0);
}

MySQLParser::DropProcedureContext* MySQLParser::DropStatementContext::dropProcedure() {
  return getRuleContext<MySQLParser::DropProcedureContext>(0);
}

MySQLParser::DropIndexContext* MySQLParser::DropStatementContext::dropIndex() {
  return getRuleContext<MySQLParser::DropIndexContext>(0);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::DropStatementContext::dropLogfileGroup() {
  return getRuleContext<MySQLParser::DropLogfileGroupContext>(0);
}

MySQLParser::DropServerContext* MySQLParser::DropStatementContext::dropServer() {
  return getRuleContext<MySQLParser::DropServerContext>(0);
}

MySQLParser::DropTableContext* MySQLParser::DropStatementContext::dropTable() {
  return getRuleContext<MySQLParser::DropTableContext>(0);
}

MySQLParser::DropTableSpaceContext* MySQLParser::DropStatementContext::dropTableSpace() {
  return getRuleContext<MySQLParser::DropTableSpaceContext>(0);
}

MySQLParser::DropTriggerContext* MySQLParser::DropStatementContext::dropTrigger() {
  return getRuleContext<MySQLParser::DropTriggerContext>(0);
}

MySQLParser::DropViewContext* MySQLParser::DropStatementContext::dropView() {
  return getRuleContext<MySQLParser::DropViewContext>(0);
}

MySQLParser::DropRoleContext* MySQLParser::DropStatementContext::dropRole() {
  return getRuleContext<MySQLParser::DropRoleContext>(0);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::DropStatementContext::dropSpatialReference() {
  return getRuleContext<MySQLParser::DropSpatialReferenceContext>(0);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::DropStatementContext::dropUndoTablespace() {
  return getRuleContext<MySQLParser::DropUndoTablespaceContext>(0);
}


size_t MySQLParser::DropStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDropStatement;
}

void MySQLParser::DropStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropStatement(this);
}

void MySQLParser::DropStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropStatement(this);
}


std::any MySQLParser::DropStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropStatementContext* MySQLParser::dropStatement() {
  DropStatementContext *_localctx = _tracker.createInstance<DropStatementContext>(_ctx, getState());
  enterRule(_localctx, 184, MySQLParser::RuleDropStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2745);
    match(MySQLParser::DROP_SYMBOL);
    setState(2763);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 195, _ctx)) {
    case 1: {
      setState(2746);
      dropDatabase();
      break;
    }

    case 2: {
      setState(2747);
      dropEvent();
      break;
    }

    case 3: {
      setState(2748);
      dropFunction();
      break;
    }

    case 4: {
      setState(2749);
      dropProcedure();
      break;
    }

    case 5: {
      setState(2750);
      dropIndex();
      break;
    }

    case 6: {
      setState(2751);
      dropLogfileGroup();
      break;
    }

    case 7: {
      setState(2752);
      dropServer();
      break;
    }

    case 8: {
      setState(2753);
      dropTable();
      break;
    }

    case 9: {
      setState(2754);
      dropTableSpace();
      break;
    }

    case 10: {
      setState(2755);
      dropTrigger();
      break;
    }

    case 11: {
      setState(2756);
      dropView();
      break;
    }

    case 12: {
      setState(2757);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2758);
      dropRole();
      break;
    }

    case 13: {
      setState(2759);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2760);
      dropSpatialReference();
      break;
    }

    case 14: {
      setState(2761);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2762);
      dropUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropDatabaseContext ------------------------------------------------------------------

MySQLParser::DropDatabaseContext::DropDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::DropDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropDatabaseContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleDropDatabase;
}

void MySQLParser::DropDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropDatabase(this);
}

void MySQLParser::DropDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropDatabase(this);
}


std::any MySQLParser::DropDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropDatabaseContext* MySQLParser::dropDatabase() {
  DropDatabaseContext *_localctx = _tracker.createInstance<DropDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 186, MySQLParser::RuleDropDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2765);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2767);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 196, _ctx)) {
    case 1: {
      setState(2766);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2769);
    schemaRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropEventContext ------------------------------------------------------------------

MySQLParser::DropEventContext::DropEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::DropEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropEventContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropEventContext::getRuleIndex() const {
  return MySQLParser::RuleDropEvent;
}

void MySQLParser::DropEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropEvent(this);
}

void MySQLParser::DropEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropEvent(this);
}


std::any MySQLParser::DropEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropEventContext* MySQLParser::dropEvent() {
  DropEventContext *_localctx = _tracker.createInstance<DropEventContext>(_ctx, getState());
  enterRule(_localctx, 188, MySQLParser::RuleDropEvent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2771);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2773);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 197, _ctx)) {
    case 1: {
      setState(2772);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2775);
    eventRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropFunctionContext ------------------------------------------------------------------

MySQLParser::DropFunctionContext::DropFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::DropFunctionContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropFunctionContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleDropFunction;
}

void MySQLParser::DropFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropFunction(this);
}

void MySQLParser::DropFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropFunction(this);
}


std::any MySQLParser::DropFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropFunctionContext* MySQLParser::dropFunction() {
  DropFunctionContext *_localctx = _tracker.createInstance<DropFunctionContext>(_ctx, getState());
  enterRule(_localctx, 190, MySQLParser::RuleDropFunction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2777);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2779);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 198, _ctx)) {
    case 1: {
      setState(2778);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2781);
    functionRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropProcedureContext ------------------------------------------------------------------

MySQLParser::DropProcedureContext::DropProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::DropProcedureContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropProcedureContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleDropProcedure;
}

void MySQLParser::DropProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropProcedure(this);
}

void MySQLParser::DropProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropProcedure(this);
}


std::any MySQLParser::DropProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropProcedureContext* MySQLParser::dropProcedure() {
  DropProcedureContext *_localctx = _tracker.createInstance<DropProcedureContext>(_ctx, getState());
  enterRule(_localctx, 192, MySQLParser::RuleDropProcedure);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2783);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2785);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 199, _ctx)) {
    case 1: {
      setState(2784);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2787);
    procedureRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropIndexContext ------------------------------------------------------------------

MySQLParser::DropIndexContext::DropIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexRefContext* MySQLParser::DropIndexContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DropIndexContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::OnlineOptionContext* MySQLParser::DropIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::DropIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}


size_t MySQLParser::DropIndexContext::getRuleIndex() const {
  return MySQLParser::RuleDropIndex;
}

void MySQLParser::DropIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropIndex(this);
}

void MySQLParser::DropIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropIndex(this);
}


std::any MySQLParser::DropIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropIndexContext* MySQLParser::dropIndex() {
  DropIndexContext *_localctx = _tracker.createInstance<DropIndexContext>(_ctx, getState());
  enterRule(_localctx, 194, MySQLParser::RuleDropIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2790);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2789);
      onlineOption();
    }
    setState(2792);
    antlrcpp::downCast<DropIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
    setState(2793);
    indexRef();
    setState(2794);
    match(MySQLParser::ON_SYMBOL);
    setState(2795);
    tableRef();
    setState(2797);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2796);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupContext::DropLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::DropLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroup;
}

void MySQLParser::DropLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroup(this);
}

void MySQLParser::DropLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroup(this);
}


std::any MySQLParser::DropLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::dropLogfileGroup() {
  DropLogfileGroupContext *_localctx = _tracker.createInstance<DropLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 196, MySQLParser::RuleDropLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2799);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2800);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2801);
    logfileGroupRef();
    setState(2812);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2802);
      dropLogfileGroupOption();
      setState(2809);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
        setState(2804);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2803);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2806);
        dropLogfileGroupOption();
        setState(2811);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupOptionContext::DropLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionWaitContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::DropLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroupOption;
}

void MySQLParser::DropLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroupOption(this);
}

void MySQLParser::DropLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroupOption(this);
}


std::any MySQLParser::DropLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::dropLogfileGroupOption() {
  DropLogfileGroupOptionContext *_localctx = _tracker.createInstance<DropLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 198, MySQLParser::RuleDropLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2816);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2814);
        tsOptionWait();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2815);
        tsOptionEngine();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropServerContext ------------------------------------------------------------------

MySQLParser::DropServerContext::DropServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::DropServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropServerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropServerContext::getRuleIndex() const {
  return MySQLParser::RuleDropServer;
}

void MySQLParser::DropServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropServer(this);
}

void MySQLParser::DropServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropServer(this);
}


std::any MySQLParser::DropServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropServerContext* MySQLParser::dropServer() {
  DropServerContext *_localctx = _tracker.createInstance<DropServerContext>(_ctx, getState());
  enterRule(_localctx, 200, MySQLParser::RuleDropServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2818);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2820);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 206, _ctx)) {
    case 1: {
      setState(2819);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2822);
    serverRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableContext ------------------------------------------------------------------

MySQLParser::DropTableContext::DropTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefListContext* MySQLParser::DropTableContext::tableRefList() {
  return getRuleContext<MySQLParser::TableRefListContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTableContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropTableContext::getRuleIndex() const {
  return MySQLParser::RuleDropTable;
}

void MySQLParser::DropTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTable(this);
}

void MySQLParser::DropTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTable(this);
}


std::any MySQLParser::DropTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableContext* MySQLParser::dropTable() {
  DropTableContext *_localctx = _tracker.createInstance<DropTableContext>(_ctx, getState());
  enterRule(_localctx, 202, MySQLParser::RuleDropTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2825);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2824);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2827);
    antlrcpp::downCast<DropTableContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
      antlrcpp::downCast<DropTableContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2829);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 208, _ctx)) {
    case 1: {
      setState(2828);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2831);
    tableRefList();
    setState(2833);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2832);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableSpaceContext ------------------------------------------------------------------

MySQLParser::DropTableSpaceContext::DropTableSpaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropTableSpaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropTableSpaceContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropTableSpaceContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropTableSpaceContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropTableSpaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropTableSpace;
}

void MySQLParser::DropTableSpaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTableSpace(this);
}

void MySQLParser::DropTableSpaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTableSpace(this);
}


std::any MySQLParser::DropTableSpaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTableSpace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableSpaceContext* MySQLParser::dropTableSpace() {
  DropTableSpaceContext *_localctx = _tracker.createInstance<DropTableSpaceContext>(_ctx, getState());
  enterRule(_localctx, 204, MySQLParser::RuleDropTableSpace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2835);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2836);
    tablespaceRef();
    setState(2847);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2837);
      dropLogfileGroupOption();
      setState(2844);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
        setState(2839);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2838);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2841);
        dropLogfileGroupOption();
        setState(2846);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTriggerContext ------------------------------------------------------------------

MySQLParser::DropTriggerContext::DropTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerRefContext* MySQLParser::DropTriggerContext::triggerRef() {
  return getRuleContext<MySQLParser::TriggerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTriggerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleDropTrigger;
}

void MySQLParser::DropTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTrigger(this);
}

void MySQLParser::DropTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTrigger(this);
}


std::any MySQLParser::DropTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTriggerContext* MySQLParser::dropTrigger() {
  DropTriggerContext *_localctx = _tracker.createInstance<DropTriggerContext>(_ctx, getState());
  enterRule(_localctx, 206, MySQLParser::RuleDropTrigger);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2849);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2851);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 213, _ctx)) {
    case 1: {
      setState(2850);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2853);
    triggerRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropViewContext ------------------------------------------------------------------

MySQLParser::DropViewContext::DropViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefListContext* MySQLParser::DropViewContext::viewRefList() {
  return getRuleContext<MySQLParser::ViewRefListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropViewContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropViewContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropViewContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropViewContext::getRuleIndex() const {
  return MySQLParser::RuleDropView;
}

void MySQLParser::DropViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropView(this);
}

void MySQLParser::DropViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropView(this);
}


std::any MySQLParser::DropViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropViewContext* MySQLParser::dropView() {
  DropViewContext *_localctx = _tracker.createInstance<DropViewContext>(_ctx, getState());
  enterRule(_localctx, 208, MySQLParser::RuleDropView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2855);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2857);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 214, _ctx)) {
    case 1: {
      setState(2856);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2859);
    viewRefList();
    setState(2861);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2860);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropRoleContext ------------------------------------------------------------------

MySQLParser::DropRoleContext::DropRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::DropRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropRoleContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropRoleContext::getRuleIndex() const {
  return MySQLParser::RuleDropRole;
}

void MySQLParser::DropRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropRole(this);
}

void MySQLParser::DropRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropRole(this);
}


std::any MySQLParser::DropRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropRoleContext* MySQLParser::dropRole() {
  DropRoleContext *_localctx = _tracker.createInstance<DropRoleContext>(_ctx, getState());
  enterRule(_localctx, 210, MySQLParser::RuleDropRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2863);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2865);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 216, _ctx)) {
    case 1: {
      setState(2864);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2867);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::DropSpatialReferenceContext::DropSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::DropSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropSpatialReferenceContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleDropSpatialReference;
}

void MySQLParser::DropSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropSpatialReference(this);
}

void MySQLParser::DropSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropSpatialReference(this);
}


std::any MySQLParser::DropSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::dropSpatialReference() {
  DropSpatialReferenceContext *_localctx = _tracker.createInstance<DropSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 212, MySQLParser::RuleDropSpatialReference);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2869);
    match(MySQLParser::SPATIAL_SYMBOL);
    setState(2870);
    match(MySQLParser::REFERENCE_SYMBOL);
    setState(2871);
    match(MySQLParser::SYSTEM_SYMBOL);
    setState(2873);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 217, _ctx)) {
    case 1: {
      setState(2872);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2875);
    real_ulonglong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::DropUndoTablespaceContext::DropUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::DropUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::DropUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropUndoTablespace;
}

void MySQLParser::DropUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropUndoTablespace(this);
}

void MySQLParser::DropUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropUndoTablespace(this);
}


std::any MySQLParser::DropUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::dropUndoTablespace() {
  DropUndoTablespaceContext *_localctx = _tracker.createInstance<DropUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 214, MySQLParser::RuleDropUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2877);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2878);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2879);
    tablespaceRef();
    setState(2881);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2880);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenameTableStatementContext ------------------------------------------------------------------

MySQLParser::RenameTableStatementContext::RenameTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

std::vector<MySQLParser::RenamePairContext *> MySQLParser::RenameTableStatementContext::renamePair() {
  return getRuleContexts<MySQLParser::RenamePairContext>();
}

MySQLParser::RenamePairContext* MySQLParser::RenameTableStatementContext::renamePair(size_t i) {
  return getRuleContext<MySQLParser::RenamePairContext>(i);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::RenameTableStatementContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::RenameTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleRenameTableStatement;
}

void MySQLParser::RenameTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenameTableStatement(this);
}

void MySQLParser::RenameTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenameTableStatement(this);
}


std::any MySQLParser::RenameTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenameTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenameTableStatementContext* MySQLParser::renameTableStatement() {
  RenameTableStatementContext *_localctx = _tracker.createInstance<RenameTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 216, MySQLParser::RuleRenameTableStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2883);
    match(MySQLParser::RENAME_SYMBOL);
    setState(2884);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2885);
    renamePair();
    setState(2890);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2886);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2887);
      renamePair();
      setState(2892);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenamePairContext ------------------------------------------------------------------

MySQLParser::RenamePairContext::RenamePairContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefContext* MySQLParser::RenamePairContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::RenamePairContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::RenamePairContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}


size_t MySQLParser::RenamePairContext::getRuleIndex() const {
  return MySQLParser::RuleRenamePair;
}

void MySQLParser::RenamePairContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenamePair(this);
}

void MySQLParser::RenamePairContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenamePair(this);
}


std::any MySQLParser::RenamePairContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenamePair(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenamePairContext* MySQLParser::renamePair() {
  RenamePairContext *_localctx = _tracker.createInstance<RenamePairContext>(_ctx, getState());
  enterRule(_localctx, 218, MySQLParser::RuleRenamePair);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2893);
    tableRef();
    setState(2894);
    match(MySQLParser::TO_SYMBOL);
    setState(2895);
    tableName();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TruncateTableStatementContext ------------------------------------------------------------------

MySQLParser::TruncateTableStatementContext::TruncateTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::TruncateTableStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}


size_t MySQLParser::TruncateTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleTruncateTableStatement;
}

void MySQLParser::TruncateTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTruncateTableStatement(this);
}

void MySQLParser::TruncateTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTruncateTableStatement(this);
}


std::any MySQLParser::TruncateTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTruncateTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::truncateTableStatement() {
  TruncateTableStatementContext *_localctx = _tracker.createInstance<TruncateTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 220, MySQLParser::RuleTruncateTableStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2897);
    match(MySQLParser::TRUNCATE_SYMBOL);
    setState(2899);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 220, _ctx)) {
    case 1: {
      setState(2898);
      match(MySQLParser::TABLE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2901);
    tableRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ImportStatementContext ------------------------------------------------------------------

MySQLParser::ImportStatementContext::ImportStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ImportStatementContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TextStringLiteralListContext* MySQLParser::ImportStatementContext::textStringLiteralList() {
  return getRuleContext<MySQLParser::TextStringLiteralListContext>(0);
}


size_t MySQLParser::ImportStatementContext::getRuleIndex() const {
  return MySQLParser::RuleImportStatement;
}

void MySQLParser::ImportStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterImportStatement(this);
}

void MySQLParser::ImportStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitImportStatement(this);
}


std::any MySQLParser::ImportStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitImportStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ImportStatementContext* MySQLParser::importStatement() {
  ImportStatementContext *_localctx = _tracker.createInstance<ImportStatementContext>(_ctx, getState());
  enterRule(_localctx, 222, MySQLParser::RuleImportStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2903);
    match(MySQLParser::IMPORT_SYMBOL);
    setState(2904);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2905);
    match(MySQLParser::FROM_SYMBOL);
    setState(2906);
    textStringLiteralList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CallStatementContext ------------------------------------------------------------------

MySQLParser::CallStatementContext::CallStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CallStatementContext::CALL_SYMBOL() {
  return getToken(MySQLParser::CALL_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::CallStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::CallStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}


size_t MySQLParser::CallStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCallStatement;
}

void MySQLParser::CallStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCallStatement(this);
}

void MySQLParser::CallStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCallStatement(this);
}


std::any MySQLParser::CallStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCallStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CallStatementContext* MySQLParser::callStatement() {
  CallStatementContext *_localctx = _tracker.createInstance<CallStatementContext>(_ctx, getState());
  enterRule(_localctx, 224, MySQLParser::RuleCallStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2908);
    match(MySQLParser::CALL_SYMBOL);
    setState(2909);
    procedureRef();
    setState(2915);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2910);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2912);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 221, _ctx)) {
      case 1: {
        setState(2911);
        exprList();
        break;
      }

      default:
        break;
      }
      setState(2914);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementContext ------------------------------------------------------------------

MySQLParser::DeleteStatementContext::DeleteStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TableAliasRefListContext* MySQLParser::DeleteStatementContext::tableAliasRefList() {
  return getRuleContext<MySQLParser::TableAliasRefListContext>(0);
}

MySQLParser::TableReferenceListContext* MySQLParser::DeleteStatementContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::DeleteStatementContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

std::vector<MySQLParser::DeleteStatementOptionContext *> MySQLParser::DeleteStatementContext::deleteStatementOption() {
  return getRuleContexts<MySQLParser::DeleteStatementOptionContext>();
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::DeleteStatementContext::deleteStatementOption(size_t i) {
  return getRuleContext<MySQLParser::DeleteStatementOptionContext>(i);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DeleteStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::DeleteStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::DeleteStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::PartitionDeleteContext* MySQLParser::DeleteStatementContext::partitionDelete() {
  return getRuleContext<MySQLParser::PartitionDeleteContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::DeleteStatementContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::DeleteStatementContext::simpleLimitClause() {
  return getRuleContext<MySQLParser::SimpleLimitClauseContext>(0);
}


size_t MySQLParser::DeleteStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatement;
}

void MySQLParser::DeleteStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatement(this);
}

void MySQLParser::DeleteStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatement(this);
}


std::any MySQLParser::DeleteStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementContext* MySQLParser::deleteStatement() {
  DeleteStatementContext *_localctx = _tracker.createInstance<DeleteStatementContext>(_ctx, getState());
  enterRule(_localctx, 226, MySQLParser::RuleDeleteStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2919);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 223, _ctx)) {
    case 1: {
      setState(2917);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2918);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(2921);
    match(MySQLParser::DELETE_SYMBOL);
    setState(2925);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 224, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2922);
        deleteStatementOption(); 
      }
      setState(2927);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 224, _ctx);
    }
    setState(2960);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 233, _ctx)) {
    case 1: {
      setState(2928);
      match(MySQLParser::FROM_SYMBOL);
      setState(2952);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 231, _ctx)) {
      case 1: {
        setState(2929);
        tableAliasRefList();
        setState(2930);
        match(MySQLParser::USING_SYMBOL);
        setState(2931);
        tableReferenceList();
        setState(2933);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(2932);
          whereClause();
        }
        break;
      }

      case 2: {
        setState(2935);
        tableRef();
        setState(2938);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 226, _ctx)) {
        case 1: {
          setState(2936);

          if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
          setState(2937);
          tableAlias();
          break;
        }

        default:
          break;
        }
        setState(2941);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::PARTITION_SYMBOL) {
          setState(2940);
          partitionDelete();
        }
        setState(2944);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(2943);
          whereClause();
        }
        setState(2947);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ORDER_SYMBOL) {
          setState(2946);
          orderClause();
        }
        setState(2950);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LIMIT_SYMBOL) {
          setState(2949);
          simpleLimitClause();
        }
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2954);
      tableAliasRefList();
      setState(2955);
      match(MySQLParser::FROM_SYMBOL);
      setState(2956);
      tableReferenceList();
      setState(2958);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::WHERE_SYMBOL) {
        setState(2957);
        whereClause();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PartitionDeleteContext ------------------------------------------------------------------

MySQLParser::PartitionDeleteContext::PartitionDeleteContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::PartitionDeleteContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::PartitionDeleteContext::getRuleIndex() const {
  return MySQLParser::RulePartitionDelete;
}

void MySQLParser::PartitionDeleteContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPartitionDelete(this);
}

void MySQLParser::PartitionDeleteContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPartitionDelete(this);
}


std::any MySQLParser::PartitionDeleteContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPartitionDelete(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PartitionDeleteContext* MySQLParser::partitionDelete() {
  PartitionDeleteContext *_localctx = _tracker.createInstance<PartitionDeleteContext>(_ctx, getState());
  enterRule(_localctx, 228, MySQLParser::RulePartitionDelete);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2962);
    match(MySQLParser::PARTITION_SYMBOL);
    setState(2963);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2964);
    identifierList();
    setState(2965);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementOptionContext ------------------------------------------------------------------

MySQLParser::DeleteStatementOptionContext::DeleteStatementOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::QUICK_SYMBOL() {
  return getToken(MySQLParser::QUICK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DeleteStatementOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatementOption;
}

void MySQLParser::DeleteStatementOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatementOption(this);
}

void MySQLParser::DeleteStatementOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatementOption(this);
}


std::any MySQLParser::DeleteStatementOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatementOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::deleteStatementOption() {
  DeleteStatementOptionContext *_localctx = _tracker.createInstance<DeleteStatementOptionContext>(_ctx, getState());
  enterRule(_localctx, 230, MySQLParser::RuleDeleteStatementOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2967);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::IGNORE_SYMBOL

    || _la == MySQLParser::LOW_PRIORITY_SYMBOL || _la == MySQLParser::QUICK_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DoStatementContext ------------------------------------------------------------------

MySQLParser::DoStatementContext::DoStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DoStatementContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::DoStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}

MySQLParser::SelectItemListContext* MySQLParser::DoStatementContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}


size_t MySQLParser::DoStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDoStatement;
}

void MySQLParser::DoStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDoStatement(this);
}

void MySQLParser::DoStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDoStatement(this);
}


std::any MySQLParser::DoStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDoStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DoStatementContext* MySQLParser::doStatement() {
  DoStatementContext *_localctx = _tracker.createInstance<DoStatementContext>(_ctx, getState());
  enterRule(_localctx, 232, MySQLParser::RuleDoStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2969);
    match(MySQLParser::DO_SYMBOL);
    setState(2974);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 234, _ctx)) {
    case 1: {
      setState(2970);

      if (!(serverVersion < 50709)) throw FailedPredicateException(this, "serverVersion < 50709");
      setState(2971);
      exprList();
      break;
    }

    case 2: {
      setState(2972);

      if (!(serverVersion >= 50709)) throw FailedPredicateException(this, "serverVersion >= 50709");
      setState(2973);
      selectItemList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerStatementContext ------------------------------------------------------------------

MySQLParser::HandlerStatementContext::HandlerStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::HANDLER_SYMBOL() {
  return getToken(MySQLParser::HANDLER_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::HandlerStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::OPEN_SYMBOL() {
  return getToken(MySQLParser::OPEN_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerStatementContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::CLOSE_SYMBOL() {
  return getToken(MySQLParser::CLOSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::HandlerStatementContext::handlerReadOrScan() {
  return getRuleContext<MySQLParser::HandlerReadOrScanContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::HandlerStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::HandlerStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::HandlerStatementContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}


size_t MySQLParser::HandlerStatementContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerStatement;
}

void MySQLParser::HandlerStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerStatement(this);
}

void MySQLParser::HandlerStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerStatement(this);
}


std::any MySQLParser::HandlerStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerStatementContext* MySQLParser::handlerStatement() {
  HandlerStatementContext *_localctx = _tracker.createInstance<HandlerStatementContext>(_ctx, getState());
  enterRule(_localctx, 234, MySQLParser::RuleHandlerStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2976);
    match(MySQLParser::HANDLER_SYMBOL);
    setState(2994);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 239, _ctx)) {
    case 1: {
      setState(2977);
      tableRef();
      setState(2978);
      match(MySQLParser::OPEN_SYMBOL);
      setState(2980);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 235, _ctx)) {
      case 1: {
        setState(2979);
        tableAlias();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2982);
      identifier();
      setState(2992);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::CLOSE_SYMBOL: {
          setState(2983);
          match(MySQLParser::CLOSE_SYMBOL);
          break;
        }

        case MySQLParser::READ_SYMBOL: {
          setState(2984);
          match(MySQLParser::READ_SYMBOL);
          setState(2985);
          handlerReadOrScan();
          setState(2987);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::WHERE_SYMBOL) {
            setState(2986);
            whereClause();
          }
          setState(2990);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::LIMIT_SYMBOL) {
            setState(2989);
            limitClause();
          }
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerReadOrScanContext ------------------------------------------------------------------

MySQLParser::HandlerReadOrScanContext::HandlerReadOrScanContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::NEXT_SYMBOL() {
  return getToken(MySQLParser::NEXT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerReadOrScanContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::ValuesContext* MySQLParser::HandlerReadOrScanContext::values() {
  return getRuleContext<MySQLParser::ValuesContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::PREV_SYMBOL() {
  return getToken(MySQLParser::PREV_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LAST_SYMBOL() {
  return getToken(MySQLParser::LAST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_THAN_OPERATOR() {
  return getToken(MySQLParser::LESS_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_THAN_OPERATOR() {
  return getToken(MySQLParser::GREATER_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::LESS_OR_EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::GREATER_OR_EQUAL_OPERATOR, 0);
}


size_t MySQLParser::HandlerReadOrScanContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerReadOrScan;
}

void MySQLParser::HandlerReadOrScanContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerReadOrScan(this);
}

void MySQLParser::HandlerReadOrScanContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerReadOrScan(this);
}


std::any MySQLParser::HandlerReadOrScanContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerReadOrScan(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::handlerReadOrScan() {
  HandlerReadOrScanContext *_localctx = _tracker.createInstance<HandlerReadOrScanContext>(_ctx, getState());
  enterRule(_localctx, 236, MySQLParser::RuleHandlerReadOrScan);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3006);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 241, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2996);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2997);
      identifier();
      setState(3004);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::FIRST_SYMBOL:
        case MySQLParser::LAST_SYMBOL:
        case MySQLParser::NEXT_SYMBOL:
        case MySQLParser::PREV_SYMBOL: {
          setState(2998);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::LAST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL

          || _la == MySQLParser::PREV_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        case MySQLParser::EQUAL_OPERATOR:
        case MySQLParser::GREATER_OR_EQUAL_OPERATOR:
        case MySQLParser::GREATER_THAN_OPERATOR:
        case MySQLParser::LESS_OR_EQUAL_OPERATOR:
        case MySQLParser::LESS_THAN_OPERATOR: {
          setState(2999);
          _la = _input->LA(1);
          if (!(((((_la - 750) & ~ 0x3fULL) == 0) &&
            ((1ULL << (_la - 750)) & ((1ULL << (MySQLParser::EQUAL_OPERATOR - 750))
            | (1ULL << (MySQLParser::GREATER_OR_EQUAL_OPERATOR - 750))
            | (1ULL << (MySQLParser::GREATER_THAN_OPERATOR - 750))
            | (1ULL << (MySQLParser::LESS_OR_EQUAL_OPERATOR - 750))
            | (1ULL << (MySQLParser::LESS_THAN_OPERATOR - 750)))) != 0))) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          setState(3000);
          match(MySQLParser::OPEN_PAR_SYMBOL);
          setState(3001);
          values();
          setState(3002);
          match(MySQLParser::CLOSE_PAR_SYMBOL);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertStatementContext ------------------------------------------------------------------

MySQLParser::InsertStatementContext::InsertStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::InsertStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::InsertStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::InsertStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

MySQLParser::InsertLockOptionContext* MySQLParser::InsertStatementContext::insertLockOption() {
  return getRuleContext<MySQLParser::InsertLockOptionContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::InsertStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::InsertUpdateListContext* MySQLParser::InsertStatementContext::insertUpdateList() {
  return getRuleContext<MySQLParser::InsertUpdateListContext>(0);
}

MySQLParser::ValuesReferenceContext* MySQLParser::InsertStatementContext::valuesReference() {
  return getRuleContext<MySQLParser::ValuesReferenceContext>(0);
}


size_t MySQLParser::InsertStatementContext::getRuleIndex() const {
  return MySQLParser::RuleInsertStatement;
}

void MySQLParser::InsertStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertStatement(this);
}

void MySQLParser::InsertStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertStatement(this);
}


std::any MySQLParser::InsertStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertStatementContext* MySQLParser::insertStatement() {
  InsertStatementContext *_localctx = _tracker.createInstance<InsertStatementContext>(_ctx, getState());
  enterRule(_localctx, 238, MySQLParser::RuleInsertStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3008);
    match(MySQLParser::INSERT_SYMBOL);
    setState(3010);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 242, _ctx)) {
    case 1: {
      setState(3009);
      insertLockOption();
      break;
    }

    default:
      break;
    }
    setState(3013);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 243, _ctx)) {
    case 1: {
      setState(3012);
      match(MySQLParser::IGNORE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3016);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 244, _ctx)) {
    case 1: {
      setState(3015);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3018);
    tableRef();
    setState(3020);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 245, _ctx)) {
    case 1: {
      setState(3019);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3034);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 248, _ctx)) {
    case 1: {
      setState(3022);
      insertFromConstructor();
      setState(3025);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 246, _ctx)) {
      case 1: {
        setState(3023);

        if (!( serverVersion >= 80018)) throw FailedPredicateException(this, " serverVersion >= 80018");
        setState(3024);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3027);
      match(MySQLParser::SET_SYMBOL);
      setState(3028);
      updateList();
      setState(3031);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 247, _ctx)) {
      case 1: {
        setState(3029);

        if (!( serverVersion >= 80018)) throw FailedPredicateException(this, " serverVersion >= 80018");
        setState(3030);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 3: {
      setState(3033);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
    setState(3037);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(3036);
      insertUpdateList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertLockOptionContext ------------------------------------------------------------------

MySQLParser::InsertLockOptionContext::InsertLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}


size_t MySQLParser::InsertLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertLockOption;
}

void MySQLParser::InsertLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertLockOption(this);
}

void MySQLParser::InsertLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertLockOption(this);
}


std::any MySQLParser::InsertLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertLockOptionContext* MySQLParser::insertLockOption() {
  InsertLockOptionContext *_localctx = _tracker.createInstance<InsertLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 240, MySQLParser::RuleInsertLockOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3039);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertFromConstructorContext ------------------------------------------------------------------

MySQLParser::InsertFromConstructorContext::InsertFromConstructorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::InsertValuesContext* MySQLParser::InsertFromConstructorContext::insertValues() {
  return getRuleContext<MySQLParser::InsertValuesContext>(0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertFromConstructorContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertFromConstructorContext::getRuleIndex() const {
  return MySQLParser::RuleInsertFromConstructor;
}

void MySQLParser::InsertFromConstructorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertFromConstructor(this);
}

void MySQLParser::InsertFromConstructorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertFromConstructor(this);
}


std::any MySQLParser::InsertFromConstructorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertFromConstructor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::insertFromConstructor() {
  InsertFromConstructorContext *_localctx = _tracker.createInstance<InsertFromConstructorContext>(_ctx, getState());
  enterRule(_localctx, 242, MySQLParser::RuleInsertFromConstructor);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3046);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3041);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3043);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 250, _ctx)) {
      case 1: {
        setState(3042);
        fields();
        break;
      }

      default:
        break;
      }
      setState(3045);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
    setState(3048);
    insertValues();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldsContext ------------------------------------------------------------------

MySQLParser::FieldsContext::FieldsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::InsertIdentifierContext *> MySQLParser::FieldsContext::insertIdentifier() {
  return getRuleContexts<MySQLParser::InsertIdentifierContext>();
}

MySQLParser::InsertIdentifierContext* MySQLParser::FieldsContext::insertIdentifier(size_t i) {
  return getRuleContext<MySQLParser::InsertIdentifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldsContext::getRuleIndex() const {
  return MySQLParser::RuleFields;
}

void MySQLParser::FieldsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFields(this);
}

void MySQLParser::FieldsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFields(this);
}


std::any MySQLParser::FieldsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFields(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldsContext* MySQLParser::fields() {
  FieldsContext *_localctx = _tracker.createInstance<FieldsContext>(_ctx, getState());
  enterRule(_localctx, 244, MySQLParser::RuleFields);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3050);
    insertIdentifier();
    setState(3055);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3051);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3052);
      insertIdentifier();
      setState(3057);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertValuesContext ------------------------------------------------------------------

MySQLParser::InsertValuesContext::InsertValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ValueListContext* MySQLParser::InsertValuesContext::valueList() {
  return getRuleContext<MySQLParser::ValueListContext>(0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUES_SYMBOL() {
  return getToken(MySQLParser::VALUES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUE_SYMBOL() {
  return getToken(MySQLParser::VALUE_SYMBOL, 0);
}


size_t MySQLParser::InsertValuesContext::getRuleIndex() const {
  return MySQLParser::RuleInsertValues;
}

void MySQLParser::InsertValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertValues(this);
}

void MySQLParser::InsertValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertValues(this);
}


std::any MySQLParser::InsertValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertValuesContext* MySQLParser::insertValues() {
  InsertValuesContext *_localctx = _tracker.createInstance<InsertValuesContext>(_ctx, getState());
  enterRule(_localctx, 246, MySQLParser::RuleInsertValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3058);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::VALUES_SYMBOL

    || _la == MySQLParser::VALUE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(3059);
    valueList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertQueryExpressionContext ------------------------------------------------------------------

MySQLParser::InsertQueryExpressionContext::InsertQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::InsertQueryExpressionContext::queryExpressionOrParens() {
  return getRuleContext<MySQLParser::QueryExpressionOrParensContext>(0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertQueryExpressionContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertQueryExpression;
}

void MySQLParser::InsertQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertQueryExpression(this);
}

void MySQLParser::InsertQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertQueryExpression(this);
}


std::any MySQLParser::InsertQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::insertQueryExpression() {
  InsertQueryExpressionContext *_localctx = _tracker.createInstance<InsertQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 248, MySQLParser::RuleInsertQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3068);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 254, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3061);
      queryExpressionOrParens();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3062);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3064);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 253, _ctx)) {
      case 1: {
        setState(3063);
        fields();
        break;
      }

      default:
        break;
      }
      setState(3066);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      setState(3067);
      queryExpressionOrParens();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValueListContext ------------------------------------------------------------------

MySQLParser::ValueListContext::ValueListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::OPEN_PAR_SYMBOL() {
  return getTokens(MySQLParser::OPEN_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::OPEN_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL() {
  return getTokens(MySQLParser::CLOSE_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, i);
}

std::vector<MySQLParser::ValuesContext *> MySQLParser::ValueListContext::values() {
  return getRuleContexts<MySQLParser::ValuesContext>();
}

MySQLParser::ValuesContext* MySQLParser::ValueListContext::values(size_t i) {
  return getRuleContext<MySQLParser::ValuesContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValueListContext::getRuleIndex() const {
  return MySQLParser::RuleValueList;
}

void MySQLParser::ValueListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValueList(this);
}

void MySQLParser::ValueListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValueList(this);
}


std::any MySQLParser::ValueListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValueList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValueListContext* MySQLParser::valueList() {
  ValueListContext *_localctx = _tracker.createInstance<ValueListContext>(_ctx, getState());
  enterRule(_localctx, 250, MySQLParser::RuleValueList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3070);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3072);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 255, _ctx)) {
    case 1: {
      setState(3071);
      values();
      break;
    }

    default:
      break;
    }
    setState(3074);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(3083);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 257, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3075);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3076);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(3078);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 256, _ctx)) {
        case 1: {
          setState(3077);
          values();
          break;
        }

        default:
          break;
        }
        setState(3080);
        match(MySQLParser::CLOSE_PAR_SYMBOL); 
      }
      setState(3085);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 257, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesContext ------------------------------------------------------------------

MySQLParser::ValuesContext::ValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ExprContext *> MySQLParser::ValuesContext::expr() {
  return getRuleContexts<MySQLParser::ExprContext>();
}

MySQLParser::ExprContext* MySQLParser::ValuesContext::expr(size_t i) {
  return getRuleContext<MySQLParser::ExprContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::DEFAULT_SYMBOL() {
  return getTokens(MySQLParser::DEFAULT_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::DEFAULT_SYMBOL(size_t i) {
  return getToken(MySQLParser::DEFAULT_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValuesContext::getRuleIndex() const {
  return MySQLParser::RuleValues;
}

void MySQLParser::ValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValues(this);
}

void MySQLParser::ValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValues(this);
}


std::any MySQLParser::ValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesContext* MySQLParser::values() {
  ValuesContext *_localctx = _tracker.createInstance<ValuesContext>(_ctx, getState());
  enterRule(_localctx, 252, MySQLParser::RuleValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3088);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 258, _ctx)) {
    case 1: {
      setState(3086);
      expr(0);
      break;
    }

    case 2: {
      setState(3087);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3097);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3090);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3093);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 259, _ctx)) {
      case 1: {
        setState(3091);
        expr(0);
        break;
      }

      case 2: {
        setState(3092);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(3099);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesReferenceContext ------------------------------------------------------------------

MySQLParser::ValuesReferenceContext::ValuesReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ValuesReferenceContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::ValuesReferenceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ValuesReferenceContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ValuesReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleValuesReference;
}

void MySQLParser::ValuesReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValuesReference(this);
}

void MySQLParser::ValuesReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValuesReference(this);
}


std::any MySQLParser::ValuesReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValuesReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesReferenceContext* MySQLParser::valuesReference() {
  ValuesReferenceContext *_localctx = _tracker.createInstance<ValuesReferenceContext>(_ctx, getState());
  enterRule(_localctx, 254, MySQLParser::RuleValuesReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3100);
    match(MySQLParser::AS_SYMBOL);
    setState(3101);
    identifier();
    setState(3103);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3102);
      columnInternalRefList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertUpdateListContext ------------------------------------------------------------------

MySQLParser::InsertUpdateListContext::InsertUpdateListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::DUPLICATE_SYMBOL() {
  return getToken(MySQLParser::DUPLICATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertUpdateListContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}


size_t MySQLParser::InsertUpdateListContext::getRuleIndex() const {
  return MySQLParser::RuleInsertUpdateList;
}

void MySQLParser::InsertUpdateListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertUpdateList(this);
}

void MySQLParser::InsertUpdateListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertUpdateList(this);
}


std::any MySQLParser::InsertUpdateListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertUpdateList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertUpdateListContext* MySQLParser::insertUpdateList() {
  InsertUpdateListContext *_localctx = _tracker.createInstance<InsertUpdateListContext>(_ctx, getState());
  enterRule(_localctx, 256, MySQLParser::RuleInsertUpdateList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3105);
    match(MySQLParser::ON_SYMBOL);
    setState(3106);
    match(MySQLParser::DUPLICATE_SYMBOL);
    setState(3107);
    match(MySQLParser::KEY_SYMBOL);
    setState(3108);
    match(MySQLParser::UPDATE_SYMBOL);
    setState(3109);
    updateList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadStatementContext ------------------------------------------------------------------

MySQLParser::LoadStatementContext::LoadStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOAD_SYMBOL() {
  return getToken(MySQLParser::LOAD_SYMBOL, 0);
}

MySQLParser::DataOrXmlContext* MySQLParser::LoadStatementContext::dataOrXml() {
  return getRuleContext<MySQLParser::DataOrXmlContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::INFILE_SYMBOL() {
  return getToken(MySQLParser::INFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::LoadStatementContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::LoadStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::LoadStatementContext::loadDataFileTail() {
  return getRuleContext<MySQLParser::LoadDataFileTailContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::LoadStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::CharsetClauseContext* MySQLParser::LoadStatementContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::LoadStatementContext::xmlRowsIdentifiedBy() {
  return getRuleContext<MySQLParser::XmlRowsIdentifiedByContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::LoadStatementContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::LoadStatementContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::CONCURRENT_SYMBOL() {
  return getToken(MySQLParser::CONCURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::LoadStatementContext::getRuleIndex() const {
  return MySQLParser::RuleLoadStatement;
}

void MySQLParser::LoadStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadStatement(this);
}

void MySQLParser::LoadStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadStatement(this);
}


std::any MySQLParser::LoadStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadStatementContext* MySQLParser::loadStatement() {
  LoadStatementContext *_localctx = _tracker.createInstance<LoadStatementContext>(_ctx, getState());
  enterRule(_localctx, 258, MySQLParser::RuleLoadStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3111);
    match(MySQLParser::LOAD_SYMBOL);
    setState(3112);
    dataOrXml();
    setState(3114);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CONCURRENT_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL) {
      setState(3113);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CONCURRENT_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(3117);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::LOCAL_SYMBOL) {
      setState(3116);
      match(MySQLParser::LOCAL_SYMBOL);
    }
    setState(3119);
    match(MySQLParser::INFILE_SYMBOL);
    setState(3120);
    textLiteral();
    setState(3122);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL) {
      setState(3121);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(3124);
    match(MySQLParser::INTO_SYMBOL);
    setState(3125);
    match(MySQLParser::TABLE_SYMBOL);
    setState(3126);
    tableRef();
    setState(3128);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::PARTITION_SYMBOL) {
      setState(3127);
      usePartition();
    }
    setState(3131);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CHARSET_SYMBOL

    || _la == MySQLParser::CHAR_SYMBOL) {
      setState(3130);
      charsetClause();
    }
    setState(3134);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ROWS_SYMBOL) {
      setState(3133);
      xmlRowsIdentifiedBy();
    }
    setState(3137);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COLUMNS_SYMBOL) {
      setState(3136);
      fieldsClause();
    }
    setState(3140);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::LINES_SYMBOL) {
      setState(3139);
      linesClause();
    }
    setState(3142);
    loadDataFileTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DataOrXmlContext ------------------------------------------------------------------

MySQLParser::DataOrXmlContext::DataOrXmlContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::XML_SYMBOL() {
  return getToken(MySQLParser::XML_SYMBOL, 0);
}


size_t MySQLParser::DataOrXmlContext::getRuleIndex() const {
  return MySQLParser::RuleDataOrXml;
}

void MySQLParser::DataOrXmlContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDataOrXml(this);
}

void MySQLParser::DataOrXmlContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDataOrXml(this);
}


std::any MySQLParser::DataOrXmlContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDataOrXml(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DataOrXmlContext* MySQLParser::dataOrXml() {
  DataOrXmlContext *_localctx = _tracker.createInstance<DataOrXmlContext>(_ctx, getState());
  enterRule(_localctx, 260, MySQLParser::RuleDataOrXml);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3144);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DATA_SYMBOL || _la == MySQLParser::XML_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- XmlRowsIdentifiedByContext ------------------------------------------------------------------

MySQLParser::XmlRowsIdentifiedByContext::XmlRowsIdentifiedByContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::TextStringContext* MySQLParser::XmlRowsIdentifiedByContext::textString() {
  return getRuleContext<MySQLParser::TextStringContext>(0);
}


size_t MySQLParser::XmlRowsIdentifiedByContext::getRuleIndex() const {
  return MySQLParser::RuleXmlRowsIdentifiedBy;
}

void MySQLParser::XmlRowsIdentifiedByContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterXmlRowsIdentifiedBy(this);
}

void MySQLParser::XmlRowsIdentifiedByContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitXmlRowsIdentifiedBy(this);
}


std::any MySQLParser::XmlRowsIdentifiedByContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitXmlRowsIdentifiedBy(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::xmlRowsIdentifiedBy() {
  XmlRowsIdentifiedByContext *_localctx = _tracker.createInstance<XmlRowsIdentifiedByContext>(_ctx, getState());
  enterRule(_localctx, 262, MySQLParser::RuleXmlRowsIdentifiedBy);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3146);
    match(MySQLParser::ROWS_SYMBOL);
    setState(3147);
    match(MySQLParser::IDENTIFIED_SYMBOL);
    setState(3148);
    match(MySQLParser::BY_SYMBOL);
    setState(3149);
    textString();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTailContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTailContext::LoadDataFileTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::LoadDataFileTailContext::loadDataFileTargetList() {
  return getRuleContext<MySQLParser::LoadDataFileTargetListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::LoadDataFileTailContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::LINES_SYMBOL() {
  return getToken(MySQLParser::LINES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}


size_t MySQLParser::LoadDataFileTailContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTail;
}

void MySQLParser::LoadDataFileTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTail(this);
}

void MySQLParser::LoadDataFileTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTail(this);
}


std::any MySQLParser::LoadDataFileTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::loadDataFileTail() {
  LoadDataFileTailContext *_localctx = _tracker.createInstance<LoadDataFileTailContext>(_ctx, getState());
  enterRule(_localctx, 264, MySQLParser::RuleLoadDataFileTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3154);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::IGNORE_SYMBOL) {
      setState(3151);
      match(MySQLParser::IGNORE_SYMBOL);
      setState(3152);
      match(MySQLParser::INT_NUMBER);
      setState(3153);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::LINES_SYMBOL || _la == MySQLParser::ROWS_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(3157);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3156);
      loadDataFileTargetList();
    }
    setState(3161);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SET_SYMBOL) {
      setState(3159);
      match(MySQLParser::SET_SYMBOL);
      setState(3160);
      updateList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTargetListContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTargetListContext::LoadDataFileTargetListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::LoadDataFileTargetListContext::fieldOrVariableList() {
  return getRuleContext<MySQLParser::FieldOrVariableListContext>(0);
}


size_t MySQLParser::LoadDataFileTargetListContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTargetList;
}

void MySQLParser::LoadDataFileTargetListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTargetList(this);
}

void MySQLParser::LoadDataFileTargetListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTargetList(this);
}


std::any MySQLParser::LoadDataFileTargetListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTargetList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::loadDataFileTargetList() {
  LoadDataFileTargetListContext *_localctx = _tracker.createInstance<LoadDataFileTargetListContext>(_ctx, getState());
  enterRule(_localctx, 266, MySQLParser::RuleLoadDataFileTargetList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3163);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3165);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 273, _ctx)) {
    case 1: {
      setState(3164);
      fieldOrVariableList();
      break;
    }

    default:
      break;
    }
    setState(3167);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldOrVariableListContext ------------------------------------------------------------------

MySQLParser::FieldOrVariableListContext::FieldOrVariableListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ColumnRefContext *> MySQLParser::FieldOrVariableListContext::columnRef() {
  return getRuleContexts<MySQLParser::ColumnRefContext>();
}

MySQLParser::ColumnRefContext* MySQLParser::FieldOrVariableListContext::columnRef(size_t i) {
  return getRuleContext<MySQLParser::ColumnRefContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::FieldOrVariableListContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::FieldOrVariableListContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldOrVariableListContext::getRuleIndex() const {
  return MySQLParser::RuleFieldOrVariableList;
}

void MySQLParser::FieldOrVariableListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFieldOrVariableList(this);
}

void MySQLParser::FieldOrVariableListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFieldOrVariableList(this);
}


std::any MySQLParser::FieldOrVariableListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFieldOrVariableList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::fieldOrVariableList() {
  FieldOrVariableListContext *_localctx = _tracker.createInstance<FieldOrVariableListContext>(_ctx, getState());
  enterRule(_localctx, 268, MySQLParser::RuleFieldOrVariableList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3171);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 274, _ctx)) {
    case 1: {
      setState(3169);
      columnRef();
      break;
    }

    case 2: {
      setState(3170);
      userVariable();
      break;
    }

    default:
      break;
    }
    setState(3180);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3173);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3176);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 275, _ctx)) {
      case 1: {
        setState(3174);
        columnRef();
        break;
      }

      case 2: {
        setState(3175);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3182);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ReplaceStatementContext ------------------------------------------------------------------

MySQLParser::ReplaceStatementContext::ReplaceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::ReplaceStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::ReplaceStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::ReplaceStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::ReplaceStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::ReplaceStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}


size_t MySQLParser::ReplaceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleReplaceStatement;
}

void MySQLParser::ReplaceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterReplaceStatement(this);
}

void MySQLParser::ReplaceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitReplaceStatement(this);
}


std::any MySQLParser::ReplaceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitReplaceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ReplaceStatementContext* MySQLParser::replaceStatement() {
  ReplaceStatementContext *_localctx = _tracker.createInstance<ReplaceStatementContext>(_ctx, getState());
  enterRule(_localctx, 270, MySQLParser::RuleReplaceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3183);
    match(MySQLParser::REPLACE_SYMBOL);
    setState(3185);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 277, _ctx)) {
    case 1: {
      setState(3184);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(3188);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 278, _ctx)) {
    case 1: {
      setState(3187);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3190);
    tableRef();
    setState(3192);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 279, _ctx)) {
    case 1: {
      setState(3191);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3198);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 280, _ctx)) {
    case 1: {
      setState(3194);
      insertFromConstructor();
      break;
    }

    case 2: {
      setState(3195);
      match(MySQLParser::SET_SYMBOL);
      setState(3196);
      updateList();
      break;
    }

    case 3: {
      setState(3197);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementContext ------------------------------------------------------------------

MySQLParser::SelectStatementContext::SelectStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SelectStatementContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}


size_t MySQLParser::SelectStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatement;
}

void MySQLParser::SelectStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatement(this);
}

void MySQLParser::SelectStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatement(this);
}


std::any MySQLParser::SelectStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementContext* MySQLParser::selectStatement() {
  SelectStatementContext *_localctx = _tracker.createInstance<SelectStatementContext>(_ctx, getState());
  enterRule(_localctx, 272, MySQLParser::RuleSelectStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3206);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 282, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3200);
      queryExpression();
      setState(3202);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
        setState(3201);
        lockingClauseList();
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3204);
      queryExpressionParens();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3205);
      selectStatementWithInto();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementWithIntoContext ------------------------------------------------------------------

MySQLParser::SelectStatementWithIntoContext::SelectStatementWithIntoContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementWithIntoContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementWithIntoContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::IntoClauseContext* MySQLParser::SelectStatementWithIntoContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementWithIntoContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SelectStatementWithIntoContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SelectStatementWithIntoContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatementWithInto;
}

void MySQLParser::SelectStatementWithIntoContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatementWithInto(this);
}

void MySQLParser::SelectStatementWithIntoContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatementWithInto(this);
}


std::any MySQLParser::SelectStatementWithIntoContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatementWithInto(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::selectStatementWithInto() {
  SelectStatementWithIntoContext *_localctx = _tracker.createInstance<SelectStatementWithIntoContext>(_ctx, getState());
  enterRule(_localctx, 274, MySQLParser::RuleSelectStatementWithInto);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3221);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 284, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3208);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3209);
      selectStatementWithInto();
      setState(3210);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3212);
      queryExpression();
      setState(3213);
      intoClause();
      setState(3215);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
        setState(3214);
        lockingClauseList();
      }
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3217);

      if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
      setState(3218);
      queryExpressionParens();
      setState(3219);
      intoClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionContext ------------------------------------------------------------------

MySQLParser::QueryExpressionContext::QueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::QueryExpressionContext::queryExpressionBody() {
  return getRuleContext<MySQLParser::QueryExpressionBodyContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::QueryExpressionContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::QueryExpressionContext::procedureAnalyseClause() {
  return getRuleContext<MySQLParser::ProcedureAnalyseClauseContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::QueryExpressionContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::QueryExpressionContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}


size_t MySQLParser::QueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpression;
}

void MySQLParser::QueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpression(this);
}

void MySQLParser::QueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpression(this);
}


std::any MySQLParser::QueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionContext* MySQLParser::queryExpression() {
  QueryExpressionContext *_localctx = _tracker.createInstance<QueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 276, MySQLParser::RuleQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3225);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 285, _ctx)) {
    case 1: {
      setState(3223);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3224);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(3241);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 290, _ctx)) {
    case 1: {
      setState(3227);
      queryExpressionBody();
      setState(3229);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 286, _ctx)) {
      case 1: {
        setState(3228);
        orderClause();
        break;
      }

      default:
        break;
      }
      setState(3232);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 287, _ctx)) {
      case 1: {
        setState(3231);
        limitClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3234);
      queryExpressionParens();
      setState(3236);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 288, _ctx)) {
      case 1: {
        setState(3235);
        orderClause();
        break;
      }

      default:
        break;
      }
      setState(3239);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 289, _ctx)) {
      case 1: {
        setState(3238);
        limitClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
    setState(3245);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 291, _ctx)) {
    case 1: {
      setState(3243);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3244);
      procedureAnalyseClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionBodyContext ------------------------------------------------------------------

MySQLParser::QueryExpressionBodyContext::QueryExpressionBodyContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::QueryPrimaryContext *> MySQLParser::QueryExpressionBodyContext::queryPrimary() {
  return getRuleContexts<MySQLParser::QueryPrimaryContext>();
}

MySQLParser::QueryPrimaryContext* MySQLParser::QueryExpressionBodyContext::queryPrimary(size_t i) {
  return getRuleContext<MySQLParser::QueryPrimaryContext>(i);
}

std::vector<MySQLParser::QueryExpressionParensContext *> MySQLParser::QueryExpressionBodyContext::queryExpressionParens() {
  return getRuleContexts<MySQLParser::QueryExpressionParensContext>();
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionBodyContext::queryExpressionParens(size_t i) {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL() {
  return getTokens(MySQLParser::UNION_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL(size_t i) {
  return getToken(MySQLParser::UNION_SYMBOL, i);
}

std::vector<MySQLParser::UnionOptionContext *> MySQLParser::QueryExpressionBodyContext::unionOption() {
  return getRuleContexts<MySQLParser::UnionOptionContext>();
}

MySQLParser::UnionOptionContext* MySQLParser::QueryExpressionBodyContext::unionOption(size_t i) {
  return getRuleContext<MySQLParser::UnionOptionContext>(i);
}


size_t MySQLParser::QueryExpressionBodyContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionBody;
}

void MySQLParser::QueryExpressionBodyContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionBody(this);
}

void MySQLParser::QueryExpressionBodyContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionBody(this);
}


std::any MySQLParser::QueryExpressionBodyContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionBody(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::queryExpressionBody() {
  QueryExpressionBodyContext *_localctx = _tracker.createInstance<QueryExpressionBodyContext>(_ctx, getState());
  enterRule(_localctx, 278, MySQLParser::RuleQueryExpressionBody);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3257);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 294, _ctx)) {
    case 1: {
      setState(3247);
      queryPrimary();
      break;
    }

    case 2: {
      setState(3248);
      queryExpressionParens();
      setState(3249);
      match(MySQLParser::UNION_SYMBOL);
      setState(3251);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 292, _ctx)) {
      case 1: {
        setState(3250);
        unionOption();
        break;
      }

      default:
        break;
      }
      setState(3255);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 293, _ctx)) {
      case 1: {
        setState(3253);
        queryPrimary();
        break;
      }

      case 2: {
        setState(3254);
        queryExpressionParens();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
    setState(3269);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 297, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3259);
        match(MySQLParser::UNION_SYMBOL);
        setState(3261);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 295, _ctx)) {
        case 1: {
          setState(3260);
          unionOption();
          break;
        }

        default:
          break;
        }
        setState(3265);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 296, _ctx)) {
        case 1: {
          setState(3263);
          queryPrimary();
          break;
        }

        case 2: {
          setState(3264);
          queryExpressionParens();
          break;
        }

        default:
          break;
        } 
      }
      setState(3271);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 297, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionParensContext::QueryExpressionParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionParensContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::QueryExpressionParensContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}


size_t MySQLParser::QueryExpressionParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionParens;
}

void MySQLParser::QueryExpressionParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionParens(this);
}

void MySQLParser::QueryExpressionParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionParens(this);
}


std::any MySQLParser::QueryExpressionParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::queryExpressionParens() {
  QueryExpressionParensContext *_localctx = _tracker.createInstance<QueryExpressionParensContext>(_ctx, getState());
  enterRule(_localctx, 280, MySQLParser::RuleQueryExpressionParens);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3272);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3278);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 299, _ctx)) {
    case 1: {
      setState(3273);
      queryExpressionParens();
      break;
    }

    case 2: {
      setState(3274);
      queryExpression();
      setState(3276);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
        setState(3275);
        lockingClauseList();
      }
      break;
    }

    default:
      break;
    }
    setState(3280);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryPrimaryContext ------------------------------------------------------------------

MySQLParser::QueryPrimaryContext::QueryPrimaryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QuerySpecificationContext* MySQLParser::QueryPrimaryContext::querySpecification() {
  return getRuleContext<MySQLParser::QuerySpecificationContext>(0);
}

MySQLParser::TableValueConstructorContext* MySQLParser::QueryPrimaryContext::tableValueConstructor() {
  return getRuleContext<MySQLParser::TableValueConstructorContext>(0);
}

MySQLParser::ExplicitTableContext* MySQLParser::QueryPrimaryContext::explicitTable() {
  return getRuleContext<MySQLParser::ExplicitTableContext>(0);
}


size_t MySQLParser::QueryPrimaryContext::getRuleIndex() const {
  return MySQLParser::RuleQueryPrimary;
}

void MySQLParser::QueryPrimaryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryPrimary(this);
}

void MySQLParser::QueryPrimaryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryPrimary(this);
}


std::any MySQLParser::QueryPrimaryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryPrimary(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryPrimaryContext* MySQLParser::queryPrimary() {
  QueryPrimaryContext *_localctx = _tracker.createInstance<QueryPrimaryContext>(_ctx, getState());
  enterRule(_localctx, 282, MySQLParser::RuleQueryPrimary);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3287);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 300, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3282);
      querySpecification();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3283);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(3284);
      tableValueConstructor();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3285);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(3286);
      explicitTable();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecificationContext ------------------------------------------------------------------

MySQLParser::QuerySpecificationContext::QuerySpecificationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecificationContext::SELECT_SYMBOL() {
  return getToken(MySQLParser::SELECT_SYMBOL, 0);
}

MySQLParser::SelectItemListContext* MySQLParser::QuerySpecificationContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}

std::vector<MySQLParser::SelectOptionContext *> MySQLParser::QuerySpecificationContext::selectOption() {
  return getRuleContexts<MySQLParser::SelectOptionContext>();
}

MySQLParser::SelectOptionContext* MySQLParser::QuerySpecificationContext::selectOption(size_t i) {
  return getRuleContext<MySQLParser::SelectOptionContext>(i);
}

MySQLParser::IntoClauseContext* MySQLParser::QuerySpecificationContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::FromClauseContext* MySQLParser::QuerySpecificationContext::fromClause() {
  return getRuleContext<MySQLParser::FromClauseContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::QuerySpecificationContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::GroupByClauseContext* MySQLParser::QuerySpecificationContext::groupByClause() {
  return getRuleContext<MySQLParser::GroupByClauseContext>(0);
}

MySQLParser::HavingClauseContext* MySQLParser::QuerySpecificationContext::havingClause() {
  return getRuleContext<MySQLParser::HavingClauseContext>(0);
}

MySQLParser::WindowClauseContext* MySQLParser::QuerySpecificationContext::windowClause() {
  return getRuleContext<MySQLParser::WindowClauseContext>(0);
}


size_t MySQLParser::QuerySpecificationContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecification;
}

void MySQLParser::QuerySpecificationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecification(this);
}

void MySQLParser::QuerySpecificationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecification(this);
}


std::any MySQLParser::QuerySpecificationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecification(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecificationContext* MySQLParser::querySpecification() {
  QuerySpecificationContext *_localctx = _tracker.createInstance<QuerySpecificationContext>(_ctx, getState());
  enterRule(_localctx, 284, MySQLParser::RuleQuerySpecification);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3289);
    match(MySQLParser::SELECT_SYMBOL);
    setState(3293);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 301, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3290);
        selectOption(); 
      }
      setState(3295);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 301, _ctx);
    }
    setState(3296);
    selectItemList();
    setState(3298);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 302, _ctx)) {
    case 1: {
      setState(3297);
      intoClause();
      break;
    }

    default:
      break;
    }
    setState(3301);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 303, _ctx)) {
    case 1: {
      setState(3300);
      fromClause();
      break;
    }

    default:
      break;
    }
    setState(3304);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 304, _ctx)) {
    case 1: {
      setState(3303);
      whereClause();
      break;
    }

    default:
      break;
    }
    setState(3307);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 305, _ctx)) {
    case 1: {
      setState(3306);
      groupByClause();
      break;
    }

    default:
      break;
    }
    setState(3310);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 306, _ctx)) {
    case 1: {
      setState(3309);
      havingClause();
      break;
    }

    default:
      break;
    }
    setState(3314);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 307, _ctx)) {
    case 1: {
      setState(3312);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3313);
      windowClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SubqueryContext ------------------------------------------------------------------

MySQLParser::SubqueryContext::SubqueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SubqueryContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SubqueryContext::getRuleIndex() const {
  return MySQLParser::RuleSubquery;
}

void MySQLParser::SubqueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSubquery(this);
}

void MySQLParser::SubqueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSubquery(this);
}


std::any MySQLParser::SubqueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSubquery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SubqueryContext* MySQLParser::subquery() {
  SubqueryContext *_localctx = _tracker.createInstance<SubqueryContext>(_ctx, getState());
  enterRule(_localctx, 286, MySQLParser::RuleSubquery);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3316);
    queryExpressionParens();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecOptionContext ------------------------------------------------------------------

MySQLParser::QuerySpecOptionContext::QuerySpecOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::DISTINCT_SYMBOL() {
  return getToken(MySQLParser::DISTINCT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::STRAIGHT_JOIN_SYMBOL() {
  return getToken(MySQLParser::STRAIGHT_JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_SMALL_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_SMALL_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BIG_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BIG_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BUFFER_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BUFFER_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_CALC_FOUND_ROWS_SYMBOL() {
  return getToken(MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL, 0);
}


size_t MySQLParser::QuerySpecOptionContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecOption;
}

void MySQLParser::QuerySpecOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecOption(this);
}

void MySQLParser::QuerySpecOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecOption(this);
}


std::any MySQLParser::QuerySpecOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecOptionContext* MySQLParser::querySpecOption() {
  QuerySpecOptionContext *_localctx = _tracker.createInstance<QuerySpecOptionContext>(_ctx, getState());
  enterRule(_localctx, 288, MySQLParser::RuleQuerySpecOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3318);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ALL_SYMBOL || _la == MySQLParser::DISTINCT_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || ((((_la - 531) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 531)) & ((1ULL << (MySQLParser::SQL_BIG_RESULT_SYMBOL - 531))
      | (1ULL << (MySQLParser::SQL_BUFFER_RESULT_SYMBOL - 531))
      | (1ULL << (MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL - 531))
      | (1ULL << (MySQLParser::SQL_SMALL_RESULT_SYMBOL - 531))
      | (1ULL << (MySQLParser::STRAIGHT_JOIN_SYMBOL - 531)))) != 0))) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitClauseContext ------------------------------------------------------------------

MySQLParser::LimitClauseContext::LimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionsContext* MySQLParser::LimitClauseContext::limitOptions() {
  return getRuleContext<MySQLParser::LimitOptionsContext>(0);
}


size_t MySQLParser::LimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleLimitClause;
}

void MySQLParser::LimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitClause(this);
}

void MySQLParser::LimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitClause(this);
}


std::any MySQLParser::LimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitClauseContext* MySQLParser::limitClause() {
  LimitClauseContext *_localctx = _tracker.createInstance<LimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 290, MySQLParser::RuleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3320);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3321);
    limitOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleLimitClauseContext ------------------------------------------------------------------

MySQLParser::SimpleLimitClauseContext::SimpleLimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SimpleLimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionContext* MySQLParser::SimpleLimitClauseContext::limitOption() {
  return getRuleContext<MySQLParser::LimitOptionContext>(0);
}


size_t MySQLParser::SimpleLimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleLimitClause;
}

void MySQLParser::SimpleLimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleLimitClause(this);
}

void MySQLParser::SimpleLimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleLimitClause(this);
}


std::any MySQLParser::SimpleLimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::simpleLimitClause() {
  SimpleLimitClauseContext *_localctx = _tracker.createInstance<SimpleLimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 292, MySQLParser::RuleSimpleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3323);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3324);
    limitOption();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionsContext ------------------------------------------------------------------

MySQLParser::LimitOptionsContext::LimitOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LimitOptionContext *> MySQLParser::LimitOptionsContext::limitOption() {
  return getRuleContexts<MySQLParser::LimitOptionContext>();
}

MySQLParser::LimitOptionContext* MySQLParser::LimitOptionsContext::limitOption(size_t i) {
  return getRuleContext<MySQLParser::LimitOptionContext>(i);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::OFFSET_SYMBOL() {
  return getToken(MySQLParser::OFFSET_SYMBOL, 0);
}


size_t MySQLParser::LimitOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOptions;
}

void MySQLParser::LimitOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOptions(this);
}

void MySQLParser::LimitOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOptions(this);
}


std::any MySQLParser::LimitOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionsContext* MySQLParser::limitOptions() {
  LimitOptionsContext *_localctx = _tracker.createInstance<LimitOptionsContext>(_ctx, getState());
  enterRule(_localctx, 294, MySQLParser::RuleLimitOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3326);
    limitOption();
    setState(3329);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 308, _ctx)) {
    case 1: {
      setState(3327);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::OFFSET_SYMBOL || _la == MySQLParser::COMMA_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(3328);
      limitOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionContext ------------------------------------------------------------------

MySQLParser::LimitOptionContext::LimitOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::LimitOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::ULONGLONG_NUMBER() {
  return getToken(MySQLParser::ULONGLONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::LONG_NUMBER() {
  return getToken(MySQLParser::LONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}


size_t MySQLParser::LimitOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOption;
}

void MySQLParser::LimitOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOption(this);
}

void MySQLParser::LimitOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOption(this);
}


std::any MySQLParser::LimitOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionContext* MySQLParser::limitOption() {
  LimitOptionContext *_localctx = _tracker.createInstance<LimitOptionContext>(_ctx, getState());
  enterRule(_localctx, 296, MySQLParser::RuleLimitOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3333);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 309, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3331);
      identifier();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3332);
      _la = _input->LA(1);
      if (!(((((_la - 747) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 747)) & ((1ULL << (MySQLParser::INT_NUMBER - 747))
        | (1ULL << (MySQLParser::LONG_NUMBER - 747))
        | (1ULL << (MySQLParser::ULONGLONG_NUMBER - 747))
        | (1ULL << (MySQLParser::PARAM_MARKER - 747)))) != 0))) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IntoClauseContext ------------------------------------------------------------------

MySQLParser::IntoClauseContext::IntoClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::IntoClauseContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::OUTFILE_SYMBOL() {
  return getToken(MySQLParser::OUTFILE_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::IntoClauseContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::DUMPFILE_SYMBOL() {
  return getToken(MySQLParser::DUMPFILE_SYMBOL, 0);
}

std::vector<MySQLParser::TextOrIdentifierContext *> MySQLParser::IntoClauseContext::textOrIdentifier() {
  return getRuleContexts<MySQLParser::TextOrIdentifierContext>();
}

MySQLParser::TextOrIdentifierContext* MySQLParser::IntoClauseContext::textOrIdentifier(size_t i) {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::IntoClauseContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::IntoClauseContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

MySQLParser::CharsetClauseContext* MySQLParser::IntoClauseContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::IntoClauseContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::IntoClauseContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::IntoClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::IntoClauseContext::getRuleIndex() const {
  return MySQLParser::RuleIntoClause;
}

void MySQLParser::IntoClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIntoClause(this);
}

void MySQLParser::IntoClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIntoClause(this);
}


std::any MySQLParser::IntoClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIntoClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IntoClauseContext* MySQLParser::intoClause() {
  IntoClauseContext *_localctx = _tracker.createInstance<IntoClauseContext>(_ctx, getState());
  enterRule(_localctx, 298, MySQLParser::RuleIntoClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3335);
    match(MySQLParser::INTO_SYMBOL);
    setState(3363);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 316, _ctx)) {
    case 1: {
      setState(3336);
      match(MySQLParser::OUTFILE_SYMBOL);
      setState(3337);
      textStringLiteral();
      setState(3339);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 310, _ctx)) {
      case 1: {
        setState(3338);
        charsetClause();
        break;
      }

      default:
        break;
      }
      setState(3342);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 311, _ctx)) {
      case 1: {
        setState(3341);
        fieldsClause();
        break;
      }

      default:
        break;
      }
      setState(3345);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 312, _ctx)) {
      case 1: {
        setState(3344);
        linesClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3347);
      match(MySQLParser::DUMPFILE_SYMBOL);
      setState(3348);
      textStringLiteral();
      break;
    }

    case 3: {
      setState(3351);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 313, _ctx)) {
      case 1: {
        setState(3349);
        textOrIdentifier();
        break;
      }

      case 2: {
        setState(3350);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3360);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 315, _ctx);
      while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
        if (alt == 1) {
          setState(3353);
          match(MySQLParser::COMMA_SYMBOL);
          setState(3356);
          _errHandler->sync(this);
          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 314, _ctx)) {
          case 1: {
            setState(3354);
            textOrIdentifier();
            break;
          }

          case 2: {
            setState(3355);
            userVariable();
            break;
          }

          default:
            break;
          } 
        }
        setState(3362);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 315, _ctx);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ProcedureAnalyseClauseContext ------------------------------------------------------------------

MySQLParser::ProcedureAnalyseClauseContext::ProcedureAnalyseClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::ANALYSE_SYMBOL() {
  return getToken(MySQLParser::ANALYSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER() {
  return getTokens(MySQLParser::INT_NUMBER);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER(size_t i) {
  return getToken(MySQLParser::INT_NUMBER, i);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::ProcedureAnalyseClauseContext::getRuleIndex() const {
  return MySQLParser::RuleProcedureAnalyseClause;
}

void MySQLParser::ProcedureAnalyseClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterProcedureAnalyseClause(this);
}

void MySQLParser::ProcedureAnalyseClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitProcedureAnalyseClause(this);
}


std::any MySQLParser::ProcedureAnalyseClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitProcedureAnalyseClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::procedureAnalyseClause() {
  ProcedureAnalyseClauseContext *_localctx = _tracker.createInstance<ProcedureAnalyseClauseContext>(_ctx, getState());
  enterRule(_localctx, 300, MySQLParser::RuleProcedureAnalyseClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3365);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(3366);
    match(MySQLParser::ANALYSE_SYMBOL);
    setState(3367);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3373);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::INT_NUMBER) {
      setState(3368);
      match(MySQLParser::INT_NUMBER);
      setState(3371);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(3369);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3370);
        match(MySQLParser::INT_NUMBER);
      }
    }
    setState(3375);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HavingClauseContext ------------------------------------------------------------------

MySQLParser::HavingClauseContext::HavingClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HavingClauseContext::HAVING_SYMBOL() {
  return getToken(MySQLParser::HAVING_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::HavingClauseContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}


size_t MySQLParser::HavingClauseContext::getRuleIndex() const {
  return MySQLParser::RuleHavingClause;
}

void MySQLParser::HavingClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHavingClause(this);
}

void MySQLParser::HavingClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHavingClause(this);
}


std::any MySQLParser::HavingClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHavingClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HavingClauseContext* MySQLParser::havingClause() {
  HavingClauseContext *_localctx = _tracker.createInstance<HavingClauseContext>(_ctx, getState());
  enterRule(_localctx, 302, MySQLParser::RuleHavingClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3377);
    match(MySQLParser::HAVING_SYMBOL);
    setState(3378);
    expr(0);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowClauseContext ------------------------------------------------------------------

MySQLParser::WindowClauseContext::WindowClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowClauseContext::WINDOW_SYMBOL() {
  return getToken(MySQLParser::WINDOW_SYMBOL, 0);
}

std::vector<MySQLParser::WindowDefinitionContext *> MySQLParser::WindowClauseContext::windowDefinition() {
  return getRuleContexts<MySQLParser::WindowDefinitionContext>();
}

MySQLParser::WindowDefinitionContext* MySQLParser::WindowClauseContext::windowDefinition(size_t i) {
  return getRuleContext<MySQLParser::WindowDefinitionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::WindowClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WindowClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WindowClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowClause;
}

void MySQLParser::WindowClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowClause(this);
}

void MySQLParser::WindowClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowClause(this);
}


std::any MySQLParser::WindowClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowClauseContext* MySQLParser::windowClause() {
  WindowClauseContext *_localctx = _tracker.createInstance<WindowClauseContext>(_ctx, getState());
  enterRule(_localctx, 304, MySQLParser::RuleWindowClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3380);
    match(MySQLParser::WINDOW_SYMBOL);
    setState(3381);
    windowDefinition();
    setState(3386);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 319, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3382);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3383);
        windowDefinition(); 
      }
      setState(3388);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 319, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowDefinitionContext ------------------------------------------------------------------

MySQLParser::WindowDefinitionContext::WindowDefinitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowDefinitionContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowDefinitionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::WindowSpecContext* MySQLParser::WindowDefinitionContext::windowSpec() {
  return getRuleContext<MySQLParser::WindowSpecContext>(0);
}


size_t MySQLParser::WindowDefinitionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowDefinition;
}

void MySQLParser::WindowDefinitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowDefinition(this);
}

void MySQLParser::WindowDefinitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowDefinition(this);
}


std::any MySQLParser::WindowDefinitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowDefinition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowDefinitionContext* MySQLParser::windowDefinition() {
  WindowDefinitionContext *_localctx = _tracker.createInstance<WindowDefinitionContext>(_ctx, getState());
  enterRule(_localctx, 306, MySQLParser::RuleWindowDefinition);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3389);
    windowName();
    setState(3390);
    match(MySQLParser::AS_SYMBOL);
    setState(3391);
    windowSpec();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecContext ------------------------------------------------------------------

MySQLParser::WindowSpecContext::WindowSpecContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowSpecContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::WindowSpecContext::windowSpecDetails() {
  return getRuleContext<MySQLParser::WindowSpecDetailsContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::WindowSpecContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpec;
}

void MySQLParser::WindowSpecContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpec(this);
}

void MySQLParser::WindowSpecContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpec(this);
}


std::any MySQLParser::WindowSpecContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpec(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecContext* MySQLParser::windowSpec() {
  WindowSpecContext *_localctx = _tracker.createInstance<WindowSpecContext>(_ctx, getState());
  enterRule(_localctx, 308, MySQLParser::RuleWindowSpec);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3393);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3394);
    windowSpecDetails();
    setState(3395);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecDetailsContext ------------------------------------------------------------------

MySQLParser::WindowSpecDetailsContext::WindowSpecDetailsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowSpecDetailsContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::WindowSpecDetailsContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::WindowSpecDetailsContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::WindowSpecDetailsContext::windowFrameClause() {
  return getRuleContext<MySQLParser::WindowFrameClauseContext>(0);
}


size_t MySQLParser::WindowSpecDetailsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpecDetails;
}

void MySQLParser::WindowSpecDetailsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpecDetails(this);
}

void MySQLParser::WindowSpecDetailsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpecDetails(this);
}


std::any MySQLParser::WindowSpecDetailsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpecDetails(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::windowSpecDetails() {
  WindowSpecDetailsContext *_localctx = _tracker.createInstance<WindowSpecDetailsContext>(_ctx, getState());
  enterRule(_localctx, 310, MySQLParser::RuleWindowSpecDetails);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3398);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 320, _ctx)) {
    case 1: {
      setState(3397);
      windowName();
      break;
    }

    default:
      break;
    }
    setState(3403);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::PARTITION_SYMBOL) {
      setState(3400);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(3401);
      match(MySQLParser::BY_SYMBOL);
      setState(3402);
      orderList();
    }
    setState(3406);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ORDER_SYMBOL) {
      setState(3405);
      orderClause();
    }
    setState(3409);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL) {
      setState(3408);
      windowFrameClause();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameClauseContext ------------------------------------------------------------------

MySQLParser::WindowFrameClauseContext::WindowFrameClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::WindowFrameClauseContext::windowFrameUnits() {
  return getRuleContext<MySQLParser::WindowFrameUnitsContext>(0);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::WindowFrameClauseContext::windowFrameExtent() {
  return getRuleContext<MySQLParser::WindowFrameExtentContext>(0);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::WindowFrameClauseContext::windowFrameExclusion() {
  return getRuleContext<MySQLParser::WindowFrameExclusionContext>(0);
}


size_t MySQLParser::WindowFrameClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameClause;
}

void MySQLParser::WindowFrameClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameClause(this);
}

void MySQLParser::WindowFrameClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameClause(this);
}


std::any MySQLParser::WindowFrameClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::windowFrameClause() {
  WindowFrameClauseContext *_localctx = _tracker.createInstance<WindowFrameClauseContext>(_ctx, getState());
  enterRule(_localctx, 312, MySQLParser::RuleWindowFrameClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3411);
    windowFrameUnits();
    setState(3412);
    windowFrameExtent();
    setState(3414);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EXCLUDE_SYMBOL) {
      setState(3413);
      windowFrameExclusion();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameUnitsContext ------------------------------------------------------------------

MySQLParser::WindowFrameUnitsContext::WindowFrameUnitsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::RANGE_SYMBOL() {
  return getToken(MySQLParser::RANGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::GROUPS_SYMBOL() {
  return getToken(MySQLParser::GROUPS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameUnitsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameUnits;
}

void MySQLParser::WindowFrameUnitsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameUnits(this);
}

void MySQLParser::WindowFrameUnitsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameUnits(this);
}


std::any MySQLParser::WindowFrameUnitsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameUnits(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::windowFrameUnits() {
  WindowFrameUnitsContext *_localctx = _tracker.createInstance<WindowFrameUnitsContext>(_ctx, getState());
  enterRule(_localctx, 314, MySQLParser::RuleWindowFrameUnits);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3416);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExtentContext ------------------------------------------------------------------

MySQLParser::WindowFrameExtentContext::WindowFrameExtentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameExtentContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::WindowFrameExtentContext::windowFrameBetween() {
  return getRuleContext<MySQLParser::WindowFrameBetweenContext>(0);
}


size_t MySQLParser::WindowFrameExtentContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExtent;
}

void MySQLParser::WindowFrameExtentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExtent(this);
}

void MySQLParser::WindowFrameExtentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExtent(this);
}


std::any MySQLParser::WindowFrameExtentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExtent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::windowFrameExtent() {
  WindowFrameExtentContext *_localctx = _tracker.createInstance<WindowFrameExtentContext>(_ctx, getState());
  enterRule(_localctx, 316, MySQLParser::RuleWindowFrameExtent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3420);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CURRENT_SYMBOL:
      case MySQLParser::INTERVAL_SYMBOL:
      case MySQLParser::UNBOUNDED_SYMBOL:
      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::PARAM_MARKER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER: {
        enterOuterAlt(_localctx, 1);
        setState(3418);
        windowFrameStart();
        break;
      }

      case MySQLParser::BETWEEN_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3419);
        windowFrameBetween();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameStartContext ------------------------------------------------------------------

MySQLParser::WindowFrameStartContext::WindowFrameStartContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PRECEDING_SYMBOL() {
  return getToken(MySQLParser::PRECEDING_SYMBOL, 0);
}

MySQLParser::Ulonglong_numberContext* MySQLParser::WindowFrameStartContext::ulonglong_number() {
  return getRuleContext<MySQLParser::Ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameStartContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameStartContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameStartContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameStart;
}

void MySQLParser::WindowFrameStartContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameStart(this);
}

void MySQLParser::WindowFrameStartContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameStart(this);
}


std::any MySQLParser::WindowFrameStartContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameStart(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameStartContext* MySQLParser::windowFrameStart() {
  WindowFrameStartContext *_localctx = _tracker.createInstance<WindowFrameStartContext>(_ctx, getState());
  enterRule(_localctx, 318, MySQLParser::RuleWindowFrameStart);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3436);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::UNBOUNDED_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3422);
        match(MySQLParser::UNBOUNDED_SYMBOL);
        setState(3423);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER: {
        enterOuterAlt(_localctx, 2);
        setState(3424);
        ulonglong_number();
        setState(3425);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::PARAM_MARKER: {
        enterOuterAlt(_localctx, 3);
        setState(3427);
        match(MySQLParser::PARAM_MARKER);
        setState(3428);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INTERVAL_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(3429);
        match(MySQLParser::INTERVAL_SYMBOL);
        setState(3430);
        expr(0);
        setState(3431);
        interval();
        setState(3432);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::CURRENT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(3434);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3435);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBetweenContext ------------------------------------------------------------------

MySQLParser::WindowFrameBetweenContext::WindowFrameBetweenContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::BETWEEN_SYMBOL() {
  return getToken(MySQLParser::BETWEEN_SYMBOL, 0);
}

std::vector<MySQLParser::WindowFrameBoundContext *> MySQLParser::WindowFrameBetweenContext::windowFrameBound() {
  return getRuleContexts<MySQLParser::WindowFrameBoundContext>();
}

MySQLParser::WindowFrameBoundContext* MySQLParser::WindowFrameBetweenContext::windowFrameBound(size_t i) {
  return getRuleContext<MySQLParser::WindowFrameBoundContext>(i);
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::AND_SYMBOL() {
  return getToken(MySQLParser::AND_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameBetweenContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBetween;
}

void MySQLParser::WindowFrameBetweenContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBetween(this);
}

void MySQLParser::WindowFrameBetweenContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBetween(this);
}


std::any MySQLParser::WindowFrameBetweenContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBetween(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::windowFrameBetween() {
  WindowFrameBetweenContext *_localctx = _tracker.createInstance<WindowFrameBetweenContext>(_ctx, getState());
  enterRule(_localctx, 320, MySQLParser::RuleWindowFrameBetween);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3438);
    match(MySQLParser::BETWEEN_SYMBOL);
    setState(3439);
    windowFrameBound();
    setState(3440);
    match(MySQLParser::AND_SYMBOL);
    setState(3441);
    windowFrameBound();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBoundContext ------------------------------------------------------------------

MySQLParser::WindowFrameBoundContext::WindowFrameBoundContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameBoundContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::FOLLOWING_SYMBOL() {
  return getToken(MySQLParser::FOLLOWING_SYMBOL, 0);
}

MySQLParser::Ulonglong_numberContext* MySQLParser::WindowFrameBoundContext::ulonglong_number() {
  return getRuleContext<MySQLParser::Ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameBoundContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameBoundContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}


size_t MySQLParser::WindowFrameBoundContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBound;
}

void MySQLParser::WindowFrameBoundContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBound(this);
}

void MySQLParser::WindowFrameBoundContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBound(this);
}


std::any MySQLParser::WindowFrameBoundContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBound(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBoundContext* MySQLParser::windowFrameBound() {
  WindowFrameBoundContext *_localctx = _tracker.createInstance<WindowFrameBoundContext>(_ctx, getState());
  enterRule(_localctx, 322, MySQLParser::RuleWindowFrameBound);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3456);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 327, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3443);
      windowFrameStart();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3444);
      match(MySQLParser::UNBOUNDED_SYMBOL);
      setState(3445);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3446);
      ulonglong_number();
      setState(3447);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3449);
      match(MySQLParser::PARAM_MARKER);
      setState(3450);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(3451);
      match(MySQLParser::INTERVAL_SYMBOL);
      setState(3452);
      expr(0);
      setState(3453);
      interval();
      setState(3454);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExclusionContext ------------------------------------------------------------------

MySQLParser::WindowFrameExclusionContext::WindowFrameExclusionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::EXCLUDE_SYMBOL() {
  return getToken(MySQLParser::EXCLUDE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::TIES_SYMBOL() {
  return getToken(MySQLParser::TIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::OTHERS_SYMBOL() {
  return getToken(MySQLParser::OTHERS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameExclusionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExclusion;
}

void MySQLParser::WindowFrameExclusionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExclusion(this);
}

void MySQLParser::WindowFrameExclusionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExclusion(this);
}


std::any MySQLParser::WindowFrameExclusionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExclusion(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::windowFrameExclusion() {
  WindowFrameExclusionContext *_localctx = _tracker.createInstance<WindowFrameExclusionContext>(_ctx, getState());
  enterRule(_localctx, 324, MySQLParser::RuleWindowFrameExclusion);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3458);
    match(MySQLParser::EXCLUDE_SYMBOL);
    setState(3465);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CURRENT_SYMBOL: {
        setState(3459);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3460);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

      case MySQLParser::GROUP_SYMBOL: {
        setState(3461);
        match(MySQLParser::GROUP_SYMBOL);
        break;
      }

      case MySQLParser::TIES_SYMBOL: {
        setState(3462);
        match(MySQLParser::TIES_SYMBOL);
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        setState(3463);
        match(MySQLParser::NO_SYMBOL);
        setState(3464);
        match(MySQLParser::OTHERS_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithClauseContext ------------------------------------------------------------------

MySQLParser::WithClauseContext::WithClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithClauseContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

std::vector<MySQLParser::CommonTableExpressionContext *> MySQLParser::WithClauseContext::commonTableExpression() {
  return getRuleContexts<MySQLParser::CommonTableExpressionContext>();
}

MySQLParser::CommonTableExpressionContext* MySQLParser::WithClauseContext::commonTableExpression(size_t i) {
  return getRuleContext<MySQLParser::CommonTableExpressionContext>(i);
}

tree::TerminalNode* MySQLParser::WithClauseContext::RECURSIVE_SYMBOL() {
  return getToken(MySQLParser::RECURSIVE_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::WithClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WithClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WithClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWithClause;
}

void MySQLParser::WithClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithClause(this);
}

void MySQLParser::WithClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithClause(this);
}


std::any MySQLParser::WithClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithClauseContext* MySQLParser::withClause() {
  WithClauseContext *_localctx = _tracker.createInstance<WithClauseContext>(_ctx, getState());
  enterRule(_localctx, 326, MySQLParser::RuleWithClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3467);
    match(MySQLParser::WITH_SYMBOL);
    setState(3469);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 329, _ctx)) {
    case 1: {
      setState(3468);
      match(MySQLParser::RECURSIVE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3471);
    commonTableExpression();
    setState(3476);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 330, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3472);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3473);
        commonTableExpression(); 
      }
      setState(3478);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 330, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CommonTableExpressionContext ------------------------------------------------------------------

MySQLParser::CommonTableExpressionContext::CommonTableExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::CommonTableExpressionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::CommonTableExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::SubqueryContext* MySQLParser::CommonTableExpressionContext::subquery() {
  return getRuleContext<MySQLParser::SubqueryContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::CommonTableExpressionContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::CommonTableExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleCommonTableExpression;
}

void MySQLParser::CommonTableExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCommonTableExpression(this);
}

void MySQLParser::CommonTableExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCommonTableExpression(this);
}


std::any MySQLParser::CommonTableExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCommonTableExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CommonTableExpressionContext* MySQLParser::commonTableExpression() {
  CommonTableExpressionContext *_localctx = _tracker.createInstance<CommonTableExpressionContext>(_ctx, getState());
  enterRule(_localctx, 328, MySQLParser::RuleCommonTableExpression);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3479);
    identifier();
    setState(3481);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3480);
      columnInternalRefList();
    }
    setState(3483);
    match(MySQLParser::AS_SYMBOL);
    setState(3484);
    subquery();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- GroupByClauseContext ------------------------------------------------------------------

MySQLParser::GroupByClauseContext::GroupByClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::GroupByClauseContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OlapOptionContext* MySQLParser::GroupByClauseContext::olapOption() {
  return getRuleContext<MySQLParser::OlapOptionContext>(0);
}


size_t MySQLParser::GroupByClauseContext::getRuleIndex() const {
  return MySQLParser::RuleGroupByClause;
}

void MySQLParser::GroupByClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterGroupByClause(this);
}

void MySQLParser::GroupByClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitGroupByClause(this);
}


std::any MySQLParser::GroupByClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitGroupByClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::GroupByClauseContext* MySQLParser::groupByClause() {
  GroupByClauseContext *_localctx = _tracker.createInstance<GroupByClauseContext>(_ctx, getState());
  enterRule(_localctx, 330, MySQLParser::RuleGroupByClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3486);
    match(MySQLParser::GROUP_SYMBOL);
    setState(3487);
    match(MySQLParser::BY_SYMBOL);
    setState(3488);
    orderList();
    setState(3490);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 332, _ctx)) {
    case 1: {
      setState(3489);
      olapOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- OlapOptionContext ------------------------------------------------------------------

MySQLParser::OlapOptionContext::OlapOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::OlapOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OlapOptionContext::ROLLUP_SYMBOL() {
  return getToken(MySQLParser::ROLLUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OlapOptionContext::CUBE_SYMBOL() {
  return getToken(MySQLParser::CUBE_SYMBOL, 0);
}


size_t MySQLParser::OlapOptionContext::getRuleIndex() const {
  return MySQLParser::RuleOlapOption;
}

void MySQLParser::OlapOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterOlapOption(this);
}

void MySQLParser::OlapOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitOlapOption(this);
}


std::any MySQLParser::OlapOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitOlapOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::OlapOptionContext* MySQLParser::olapOption() {
  OlapOptionContext *_localctx = _tracker.createInstance<OlapOptionContext>(_ctx, getState());
  enterRule(_localctx, 332, MySQLParser::RuleOlapOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3497);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 333, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3492);
      match(MySQLParser::WITH_SYMBOL);
      setState(3493);
      match(MySQLParser::ROLLUP_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3494);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3495);
      match(MySQLParser::WITH_SYMBOL);
      setState(3496);
      match(MySQLParser::CUBE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- OrderClauseContext ------------------------------------------------------------------

MySQLParser::OrderClauseContext::OrderClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::OrderClauseContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OrderClauseContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::OrderClauseContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}


size_t MySQLParser::OrderClauseContext::getRuleIndex() const {
  return MySQLParser::RuleOrderClause;
}

void MySQLParser::OrderClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterOrderClause(this);
}

void MySQLParser::OrderClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitOrderClause(this);
}


std::any MySQLParser::OrderClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitOrderClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::OrderClauseContext* MySQLParser::orderClause() {
  OrderClauseContext *_localctx = _tracker.createInstance<OrderClauseContext>(_ctx, getState());
  enterRule(_localctx, 334, MySQLParser::RuleOrderClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3499);
    match(MySQLParser::ORDER_SYMBOL);
    setState(3500);
    match(MySQLParser::BY_SYMBOL);
    setState(3501);
    orderList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DirectionContext ------------------------------------------------------------------

MySQLParser::DirectionContext::DirectionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DirectionContext::ASC_SYMBOL() {
  return getToken(MySQLParser::ASC_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DirectionContext::DESC_SYMBOL() {
  return getToken(MySQLParser::DESC_SYMBOL, 0);
}


size_t MySQLParser::DirectionContext::getRuleIndex() const {
  return MySQLParser::RuleDirection;
}

void MySQLParser::DirectionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDirection(this);
}

void MySQLParser::DirectionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDirection(this);
}


std::any MySQLParser::DirectionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDirection(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DirectionContext* MySQLParser::direction() {
  DirectionContext *_localctx = _tracker.createInstance<DirectionContext>(_ctx, getState());
  enterRule(_localctx, 336, MySQLParser::RuleDirection);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3503);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FromClauseContext ------------------------------------------------------------------

MySQLParser::FromClauseContext::FromClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::FromClauseContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::FromClauseContext::DUAL_SYMBOL() {
  return getToken(MySQLParser::DUAL_SYMBOL, 0);
}

MySQLParser::TableReferenceListContext* MySQLParser::FromClauseContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}


size_t MySQLParser::FromClauseContext::getRuleIndex() const {
  return MySQLParser::RuleFromClause;
}

void MySQLParser::FromClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFromClause(this);
}

void MySQLParser::FromClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFromClause(this);
}


std::any MySQLParser::FromClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFromClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FromClauseContext* MySQLParser::fromClause() {
  FromClauseContext *_localctx = _tracker.createInstance<FromClauseContext>(_ctx, getState());
  enterRule(_localctx, 338, MySQLParser::RuleFromClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3505);
    match(MySQLParser::FROM_SYMBOL);
    setState(3508);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 334, _ctx)) {
    case 1: {
      setState(3506);
      match(MySQLParser::DUAL_SYMBOL);
      break;
    }

    case 2: {
      setState(3507);
      tableReferenceList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableReferenceListContext ------------------------------------------------------------------

MySQLParser::TableReferenceListContext::TableReferenceListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TableReferenceContext *> MySQLParser::TableReferenceListContext::tableReference() {
  return getRuleContexts<MySQLParser::TableReferenceContext>();
}

MySQLParser::TableReferenceContext* MySQLParser::TableReferenceListContext::tableReference(size_t i) {
  return getRuleContext<MySQLParser::TableReferenceContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableReferenceListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableReferenceListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableReferenceListContext::getRuleIndex() const {
  return MySQLParser::RuleTableReferenceList;
}

void MySQLParser::TableReferenceListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableReferenceList(this);
}

void MySQLParser::TableReferenceListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableReferenceList(this);
}


std::any MySQLParser::TableReferenceListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableReferenceList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableReferenceListContext* MySQLParser::tableReferenceList() {
  TableReferenceListContext *_localctx = _tracker.createInstance<TableReferenceListContext>(_ctx, getState());
  enterRule(_localctx, 340, MySQLParser::RuleTableReferenceList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3510);
    tableReference();
    setState(3515);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 335, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3511);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3512);
        tableReference(); 
      }
      setState(3517);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 335, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableValueConstructorContext ------------------------------------------------------------------

MySQLParser::TableValueConstructorContext::TableValueConstructorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TableValueConstructorContext::VALUES_SYMBOL() {
  return getToken(MySQLParser::VALUES_SYMBOL, 0);
}

std::vector<MySQLParser::RowValueExplicitContext *> MySQLParser::TableValueConstructorContext::rowValueExplicit() {
  return getRuleContexts<MySQLParser::RowValueExplicitContext>();
}

MySQLParser::RowValueExplicitContext* MySQLParser::TableValueConstructorContext::rowValueExplicit(size_t i) {
  return getRuleContext<MySQLParser::RowValueExplicitContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableValueConstructorContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableValueConstructorContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableValueConstructorContext::getRuleIndex() const {
  return MySQLParser::RuleTableValueConstructor;
}

void MySQLParser::TableValueConstructorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableValueConstructor(this);
}

void MySQLParser::TableValueConstructorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableValueConstructor(this);
}


std::any MySQLParser::TableValueConstructorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableValueConstructor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableValueConstructorContext* MySQLParser::tableValueConstructor() {
  TableValueConstructorContext *_localctx = _tracker.createInstance<TableValueConstructorContext>(_ctx, getState());
  enterRule(_localctx, 342, MySQLParser::RuleTableValueConstructor);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3518);
    match(MySQLParser::VALUES_SYMBOL);
    setState(3519);
    rowValueExplicit();
    setState(3524);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 336, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3520);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3521);
        rowValueExplicit(); 
      }
      setState(3526);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 336, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ExplicitTableContext ------------------------------------------------------------------

MySQLParser::ExplicitTableContext::ExplicitTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ExplicitTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::ExplicitTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}


size_t MySQLParser::ExplicitTableContext::getRuleIndex() const {
  return MySQLParser::RuleExplicitTable;
}

void MySQLParser::ExplicitTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterExplicitTable(this);
}

void MySQLParser::ExplicitTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitExplicitTable(this);
}


std::any MySQLParser::ExplicitTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitExplicitTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ExplicitTableContext* MySQLParser::explicitTable() {
  ExplicitTableContext *_localctx = _tracker.createInstance<ExplicitTableContext>(_ctx, getState());
  enterRule(_localctx, 344, MySQLParser::RuleExplicitTable);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3527);
    match(MySQLParser::TABLE_SYMBOL);
    setState(3528);
    tableRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RowValueExplicitContext ------------------------------------------------------------------

MySQLParser::RowValueExplicitContext::RowValueExplicitContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RowValueExplicitContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RowValueExplicitContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RowValueExplicitContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::ValuesContext* MySQLParser::RowValueExplicitContext::values() {
  return getRuleContext<MySQLParser::ValuesContext>(0);
}


size_t MySQLParser::RowValueExplicitContext::getRuleIndex() const {
  return MySQLParser::RuleRowValueExplicit;
}

void MySQLParser::RowValueExplicitContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRowValueExplicit(this);
}

void MySQLParser::RowValueExplicitContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRowValueExplicit(this);
}


std::any MySQLParser::RowValueExplicitContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRowValueExplicit(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RowValueExplicitContext* MySQLParser::rowValueExplicit() {
  RowValueExplicitContext *_localctx = _tracker.createInstance<RowValueExplicitContext>(_ctx, getState());
  enterRule(_localctx, 346, MySQLParser::RuleRowValueExplicit);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3530);
    match(MySQLParser::ROW_SYMBOL);
    setState(3531);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3533);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 337, _ctx)) {
    case 1: {
      setState(3532);
      values();
      break;
    }

    default:
      break;
    }
    setState(3535);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectOptionContext ------------------------------------------------------------------

MySQLParser::SelectOptionContext::SelectOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QuerySpecOptionContext* MySQLParser::SelectOptionContext::querySpecOption() {
  return getRuleContext<MySQLParser::QuerySpecOptionContext>(0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::SQL_NO_CACHE_SYMBOL() {
  return getToken(MySQLParser::SQL_NO_CACHE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::SQL_CACHE_SYMBOL() {
  return getToken(MySQLParser::SQL_CACHE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::MAX_STATEMENT_TIME_SYMBOL() {
  return getToken(MySQLParser::MAX_STATEMENT_TIME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::SelectOptionContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}


size_t MySQLParser::SelectOptionContext::getRuleIndex() const {
  return MySQLParser::RuleSelectOption;
}

void MySQLParser::SelectOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectOption(this);
}

void MySQLParser::SelectOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectOption(this);
}


std::any MySQLParser::SelectOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectOptionContext* MySQLParser::selectOption() {
  SelectOptionContext *_localctx = _tracker.createInstance<SelectOptionContext>(_ctx, getState());
  enterRule(_localctx, 348, MySQLParser::RuleSelectOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3545);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 338, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3537);
      querySpecOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3538);
      match(MySQLParser::SQL_NO_CACHE_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3539);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3540);
      match(MySQLParser::SQL_CACHE_SYMBOL);
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3541);

      if (!(serverVersion >= 50704 && serverVersion < 50708)) throw FailedPredicateException(this, "serverVersion >= 50704 && serverVersion < 50708");
      setState(3542);
      match(MySQLParser::MAX_STATEMENT_TIME_SYMBOL);
      setState(3543);
      match(MySQLParser::EQUAL_OPERATOR);
      setState(3544);
      real_ulong_number();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockingClauseListContext ------------------------------------------------------------------

MySQLParser::LockingClauseListContext::LockingClauseListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LockingClauseContext *> MySQLParser::LockingClauseListContext::lockingClause() {
  return getRuleContexts<MySQLParser::LockingClauseContext>();
}

MySQLParser::LockingClauseContext* MySQLParser::LockingClauseListContext::lockingClause(size_t i) {
  return getRuleContext<MySQLParser::LockingClauseContext>(i);
}


size_t MySQLParser::LockingClauseListContext::getRuleIndex() const {
  return MySQLParser::RuleLockingClauseList;
}

void MySQLParser::LockingClauseListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockingClauseList(this);
}

void MySQLParser::LockingClauseListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockingClauseList(this);
}


std::any MySQLParser::LockingClauseListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockingClauseList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockingClauseListContext* MySQLParser::lockingClauseList() {
  LockingClauseListContext *_localctx = _tracker.createInstance<LockingClauseListContext>(_ctx, getState());
  enterRule(_localctx, 350, MySQLParser::RuleLockingClauseList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3548); 
    _errHandler->sync(this);
    _la = _input->LA(1);
    do {
      setState(3547);
      lockingClause();
      setState(3550); 
      _errHandler->sync(this);
      _la = _input->LA(1);
    } while (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockingClauseContext ------------------------------------------------------------------

MySQLParser::LockingClauseContext::LockingClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LockingClauseContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

MySQLParser::LockStrenghContext* MySQLParser::LockingClauseContext::lockStrengh() {
  return getRuleContext<MySQLParser::LockStrenghContext>(0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::OF_SYMBOL() {
  return getToken(MySQLParser::OF_SYMBOL, 0);
}

MySQLParser::TableAliasRefListContext* MySQLParser::LockingClauseContext::tableAliasRefList() {
  return getRuleContext<MySQLParser::TableAliasRefListContext>(0);
}

MySQLParser::LockedRowActionContext* MySQLParser::LockingClauseContext::lockedRowAction() {
  return getRuleContext<MySQLParser::LockedRowActionContext>(0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::LOCK_SYMBOL() {
  return getToken(MySQLParser::LOCK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::IN_SYMBOL() {
  return getToken(MySQLParser::IN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::SHARE_SYMBOL() {
  return getToken(MySQLParser::SHARE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::MODE_SYMBOL() {
  return getToken(MySQLParser::MODE_SYMBOL, 0);
}


size_t MySQLParser::LockingClauseContext::getRuleIndex() const {
  return MySQLParser::RuleLockingClause;
}

void MySQLParser::LockingClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockingClause(this);
}

void MySQLParser::LockingClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockingClause(this);
}


std::any MySQLParser::LockingClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockingClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockingClauseContext* MySQLParser::lockingClause() {
  LockingClauseContext *_localctx = _tracker.createInstance<LockingClauseContext>(_ctx, getState());
  enterRule(_localctx, 352, MySQLParser::RuleLockingClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3567);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::FOR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3552);
        match(MySQLParser::FOR_SYMBOL);
        setState(3553);
        lockStrengh();
        setState(3557);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 340, _ctx)) {
        case 1: {
          setState(3554);

          if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
          setState(3555);
          match(MySQLParser::OF_SYMBOL);
          setState(3556);
          tableAliasRefList();
          break;
        }

        default:
          break;
        }
        setState(3561);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 341, _ctx)) {
        case 1: {
          setState(3559);

          if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
          setState(3560);
          lockedRowAction();
          break;
        }

        default:
          break;
        }
        break;
      }

      case MySQLParser::LOCK_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3563);
        match(MySQLParser::LOCK_SYMBOL);
        setState(3564);
        match(MySQLParser::IN_SYMBOL);
        setState(3565);
        match(MySQLParser::SHARE_SYMBOL);
        setState(3566);
        match(MySQLParser::MODE_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockStrenghContext ------------------------------------------------------------------

MySQLParser::LockStrenghContext::LockStrenghContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LockStrenghContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockStrenghContext::SHARE_SYMBOL() {
  return getToken(MySQLParser::SHARE_SYMBOL, 0);
}


size_t MySQLParser::LockStrenghContext::getRuleIndex() const {
  return MySQLParser::RuleLockStrengh;
}

void MySQLParser::LockStrenghContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockStrengh(this);
}

void MySQLParser::LockStrenghContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockStrengh(this);
}


std::any MySQLParser::LockStrenghContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockStrengh(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockStrenghContext* MySQLParser::lockStrengh() {
  LockStrenghContext *_localctx = _tracker.createInstance<LockStrenghContext>(_ctx, getState());
  enterRule(_localctx, 354, MySQLParser::RuleLockStrengh);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3572);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 343, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3569);
      match(MySQLParser::UPDATE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3570);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3571);
      match(MySQLParser::SHARE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockedRowActionContext ------------------------------------------------------------------

MySQLParser::LockedRowActionContext::LockedRowActionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LockedRowActionContext::SKIP_SYMBOL() {
  return getToken(MySQLParser::SKIP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockedRowActionContext::LOCKED_SYMBOL() {
  return getToken(MySQLParser::LOCKED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockedRowActionContext::NOWAIT_SYMBOL() {
  return getToken(MySQLParser::NOWAIT_SYMBOL, 0);
}


size_t MySQLParser::LockedRowActionContext::getRuleIndex() const {
  return MySQLParser::RuleLockedRowAction;
}

void MySQLParser::LockedRowActionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockedRowAction(this);
}

void MySQLParser::LockedRowActionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockedRowAction(this);
}


std::any MySQLParser::LockedRowActionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockedRowAction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockedRowActionContext* MySQLParser::lockedRowAction() {
  LockedRowActionContext *_localctx = _tracker.createInstance<LockedRowActionContext>(_ctx, getState());
  enterRule(_localctx, 356, MySQLParser::RuleLockedRowAction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3577);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::SKIP_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3574);
        match(MySQLParser::SKIP_SYMBOL);
        setState(3575);
        match(MySQLParser::LOCKED_SYMBOL);
        break;
      }

      case MySQLParser::NOWAIT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3576);
        match(MySQLParser::NOWAIT_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectItemListContext ------------------------------------------------------------------

MySQLParser::SelectItemListContext::SelectItemListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::SelectItemContext *> MySQLParser::SelectItemListContext::selectItem() {
  return getRuleContexts<MySQLParser::SelectItemContext>();
}

MySQLParser::SelectItemContext* MySQLParser::SelectItemListContext::selectItem(size_t i) {
  return getRuleContext<MySQLParser::SelectItemContext>(i);
}

tree::TerminalNode* MySQLParser::SelectItemListContext::MULT_OPERATOR() {
  return getToken(MySQLParser::MULT_OPERATOR, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::SelectItemListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::SelectItemListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::SelectItemListContext::getRuleIndex() const {
  return MySQLParser::RuleSelectItemList;
}

void MySQLParser::SelectItemListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectItemList(this);
}

void MySQLParser::SelectItemListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectItemList(this);
}


std::any MySQLParser::SelectItemListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectItemList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectItemListContext* MySQLParser::selectItemList() {
  SelectItemListContext *_localctx = _tracker.createInstance<SelectItemListContext>(_ctx, getState());
  enterRule(_localctx, 358, MySQLParser::RuleSelectItemList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3581);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 345, _ctx)) {
    case 1: {
      setState(3579);
      selectItem();
      break;
    }

    case 2: {
      setState(3580);
      match(MySQLParser::MULT_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(3587);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 346, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3583);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3584);
        selectItem(); 
      }
      setState(3589);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 346, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectItemContext ------------------------------------------------------------------

MySQLParser::SelectItemContext::SelectItemContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableWildContext* MySQLParser::SelectItemContext::tableWild() {
  return getRuleContext<MySQLParser::TableWildContext>(0);
}

MySQLParser::ExprContext* MySQLParser::SelectItemContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::SelectAliasContext* MySQLParser::SelectItemContext::selectAlias() {
  return getRuleContext<MySQLParser::SelectAliasContext>(0);
}


size_t MySQLParser::SelectItemContext::getRuleIndex() const {
  return MySQLParser::RuleSelectItem;
}

void MySQLParser::SelectItemContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectItem(this);
}

void MySQLParser::SelectItemContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectItem(this);
}


std::any MySQLParser::SelectItemContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSe