#ifndef _TCL_WS_FYPTES_H
#define _TCL_WS_FYPTES_H

/* tcl_ws-ftypes.h
  
   Definitions for Tcl objects that represet libwireshark's ftypes.

   Copyright (C) 2007, 2008, 2009, 2010 Eloy Paris

   This is part of Network Expect (nexp)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

extern Tcl_Obj *Tcl_NewUInt32Obj(uint32_t);
extern Tcl_Obj *Tcl_NewInt32Obj(int32_t);
extern Tcl_Obj *Tcl_NewUInt64Obj(uint64_t);
extern Tcl_Obj *Tcl_NewInt64Obj(int64_t);
extern Tcl_Obj *Tcl_NewAddrObj(struct addr *);

extern int Tcl_GetUInt8FromObj(Tcl_Obj *, uint8_t *);
extern int Tcl_GetUInt16FromObj(Tcl_Obj *, uint16_t *);
extern int Tcl_GetUInt32FromObj(Tcl_Obj *, uint32_t *);
extern int Tcl_GetUInt64FromObj(Tcl_Obj *, uint64_t *);

extern int Tcl_GetInt32FromObj(Tcl_Obj *, int32_t *);
extern int Tcl_GetInt64FromObj(Tcl_Obj *, int64_t *);

extern int Tcl_GetAddrFromObj(Tcl_Obj *, struct addr *);
extern int Tcl_GetIPAddrFromObj(Tcl_Obj *, ip_addr_t *);

extern void nexp_register_tcl_ws_ftypes(void);

#endif /* _TCL_WS_FYPTES_H */
