## Usage

```js
var isExtendable = require('{%= name %}');
```

Returns true if the value is any of the following:

- array
- plain object
- function 

## Notes

All objects in JavaScript can have keys, but it's a pain to check for this, since we ether need to verify that the value is not `null` or `undefined` and:

- the value is not a primitive, or
- that the object is a plain object, function or array

Also note that an `extendable` object is not the same as an [extensible object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/isExtensible), which is one that (in es6) is not sealed, frozen, or marked as non-extensible using `preventExtensions`.

## Release history

### v1.0.0 - 2017/07/20

**Breaking changes**

- No longer considers date, regex or error objects to be extendable