module.exports = {
    docs: {
        Puppeteer: [
            {
              type: 'doc',
              id: 'puppeteer.puppeteer',
              label: 'Puppeteer',
            },
            {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.clearcustomqueryhandlers',
                label: 'clearcustomqueryhandlers',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.connect',
                label: 'connect',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.customqueryhandlernames',
                label: 'customqueryhandlersnames',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.devices',
                label: 'devices',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.errors',
                label: 'errors',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.networkconditions',
                label: 'networkconditions',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.registercustomqueryhandler',
                label: 'registercustomqueryhandler',
              },
              {
                type: 'doc',
                id: 'puppeteer.puppeteer.unregistercustomqueryhandler',
                label: 'unregistercustomqueryhandler',
              },
            ]
            }
        ],
        "BrowserFetcher": [
            {
              type: 'doc',
              id: 'puppeteer.browserfetcher',
              label: 'BrowserFetcher',
            },
            {
              Methods: [
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.candownload',
                  label: 'candownload',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.download',
                  label: 'download',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.host',
                  label: 'host',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.localrevisions',
                  label: 'localrevisions',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.platform',
                  label: 'platform',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.product',
                  label: 'product',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.remove',
                  label: 'remove',
                },
                {
                  type: 'doc',
                  id: 'puppeteer.browserfetcher.revisioninfo',
                  label: 'revisioninfo',
                },
              ]
            },
        ],
        "Browser": [
          {
            type: 'doc',
            id: 'puppeteer.browser',
            label: 'Browser',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.browser.browsercontexts',
                label: 'browsercontexts',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.close',
                label: 'close',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.createincognitobrowsercontext',
                label: 'createincognitobrowsercontext',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.defaultbrowsercontext',
                label: 'defaultbrowsercontext',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.disconnect',
                label: 'disconnect',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.isconnected',
                label: 'isconnected',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.newpage',
                label: 'newpage',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.pages',
                label: 'pages',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.process',
                label: 'process',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.target',
                label: 'target',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.useragent',
                label: 'useragent',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.waitfortarget',
                label: 'waitfortarget',
              },
              {
                type: 'doc',
                id: 'puppeteer.browser.wsendpoint',
                label: 'wsendpoint',
              },
            ]
          },
        ],
        "BrowserContext": [
          {
            type: 'doc',
            id: 'puppeteer.browsercontext',
            label: 'BrowserContext',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.browser',
                label: 'browser',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.overridepermissions',
                label: 'overridepermissions',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.close',
                label: 'close',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.isincognito',
                label: 'isincognito',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.newpage',
                label: 'newpage',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.overridepermissions',
                label: 'overridepermissions',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.pages',
                label: 'pages',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.targets',
                label: 'targets',
              },
              {
                type: 'doc',
                id: 'puppeteer.browsercontext.waitfortarget',
                label: 'waitfortarget',
              },
            ]
          },
        ],
        "Page": [
          {
            type: 'doc',
            id: 'puppeteer.page',
            label: 'Page',
          },
          {
            Namespaces: [
              {
                type: 'doc',
                id: 'puppeteer.page.accessibility',
                label: 'accessibility',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.coverage',
                label: 'coverage',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.isdraginterceptionenabled',
                label: 'isDragInterceptionEnabled',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.keyboard',
                label: 'keyboard',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.mouse',
                label: 'mouse',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.touchscreen',
                label: 'touchScreen',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.tracing',
                label: 'tracing',
              },
            ]
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.page._',
                label: '$',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.__',
                label: '$$',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.__eval',
                label: '$$eval',
              },
              {
                type: 'doc',
                id: 'puppeteer.page._eval',
                label: '$eval',
              },
              {
                type: 'doc',
                id: 'puppeteer.page._x',
                label: '$x',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.addscripttag',
                label: 'addScriptTag',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.addstyletag',
                label: 'addStyleTag',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.authenticate',
                label: 'authenticate',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.bringtofront',
                label: 'bringToFront',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.browser',
                label: 'browser',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.browsercontext',
                label: 'browserContext',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.click',
                label: 'click',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.close',
                label: 'close',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.content',
                label: 'content()',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.cookies',
                label: 'cookies',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.createpdfstream',
                label: 'createPDFStream',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.deletecookie',
                label: 'deleteCookie',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulate',
                label: 'emulate',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulatecputhrottling',
                label: 'emulateCPUThrottling',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulateidlestate',
                label: 'emulateIdleState',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulatemediafeatures',
                label: 'emulateMediaFeatures',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulatenetworkconditions',
                label: 'emulateNetworkConditions',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulatetimezone',
                label: 'emulateTimeZone',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.emulatevisiondeficiency',
                label: 'emulateVisionDefinciency',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.evaluate',
                label: 'evaluate',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.evaluatehandle',
                label: 'evaluateHandle',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.evaluateonnewdocument',
                label: 'evaluateOnNewDocument',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.exposefunction',
                label: 'exposeFunction',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.focus',
                label: 'focus',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.frames',
                label: 'frames',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.goback',
                label: 'goBack',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.goforward',
                label: 'goForward',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.goto',
                label: 'goTo',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.hover',
                label: 'hover',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.isclosed',
                label: 'isClosed',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.isjavascriptenabled',
                label: 'isJavaScriptEnbled',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.mainframe',
                label: 'mainFrame',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.metrics',
                label: 'metrics',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.once',
                label: 'once',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.pdf',
                label: 'PDF',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.queryobjects',
                label: 'queryObjects',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.reload',
                label: 'reload',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.screenshot',
                label: 'screenshot',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.select',
                label: 'select',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setbypasscsp',
                label: 'setByPassCSP',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setcacheenabled',
                label: 'setCacheEnaled',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setcontent',
                label: 'setContent',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setcookie',
                label: 'setCookie',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setdefaultnavigationtimeout',
                label: 'setDefaultNavigationTimeOut',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setdefaulttimeout',
                label: 'setDefaultTimeOut',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setdraginterception',
                label: 'setDragInterception',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setextrahttpheaders',
                label: 'setExtraHTTPHeader',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setgeolocation',
                label: 'setGeoLocation',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setjavascriptenabled',
                label: 'setJavaScriptEnabled',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setofflinemode',
                label: 'setOfflineMode',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setrequestinterception',
                label: 'setRequestInterception',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setuseragent',
                label: 'setUserAgent',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.setviewport',
                label: 'setViewPort',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.tap',
                label: 'tap',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.target',
                label: 'target',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.title',
                label: 'title',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.type',
                label: 'type',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.url',
                label: 'url',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.viewport',
                label: 'viewport',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitfor',
                label: 'waitFor',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitforfilechooser',
                label: 'waitForFileChooser',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitforfunction',
                label: 'waitForFunction',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitfornavigation',
                label: 'waitForNavigation',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitforrequest',
                label: 'waitForRequest',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitforresponse',
                label: 'waitForResponse',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitforselector',
                label: 'waitForSelector',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitfortimeout',
                label: 'waittimeout',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.waitforxpath',
                label: 'waitForXPath',
              },
              {
                type: 'doc',
                id: 'puppeteer.page.workers',
                label: 'workers',
              },
            ]
          },
        ],
        "WebWorker": [
          {
            type: 'doc',
            id: 'puppeteer.webworker',
            label: 'WebWorker',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.webworker.evaluate',
                label: 'evaluate',
              },
              {
                type: 'doc',
                id: 'puppeteer.webworker.evaluatehandle',
                label: 'evaluatehandle',
              },
              {
                type: 'doc',
                id: 'puppeteer.webworker.executioncontext',
                label: 'executioncontext',
              },
              {
                type: 'doc',
                id: 'puppeteer.webworker.url',
                label: 'url',
              },
            ]
          },
        ],
        "Accessibility": [
          {
            type: 'doc',
            id: 'puppeteer.accessibility',
            label: 'Accessibility',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.accessibility.snapshot',
                label: 'snapshot',
              },
            ]
          },
        ],
        "Keyboard": [
          {
            type: 'doc',
            id: 'puppeteer.keyboard',
            label: 'keyboard',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.keyboard.down',
                label: 'down',
              },
              {
                type: 'doc',
                id: 'puppeteer.keyboard.press',
                label: 'press',
              },
              {
                type: 'doc',
                id: 'puppeteer.keyboard.sendcharacter',
                label: 'sendCharacter',
              },
              {
                type: 'doc',
                id: 'puppeteer.keyboard.type',
                label: 'type',
              },
              {
                type: 'doc',
                id: 'puppeteer.keyboard.up',
                label: 'up',
              },
            ]
          },
        ],
        "Mouse": [
          {
            type: 'doc',
            id: 'puppeteer.mouse',
            label: 'mouse',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.mouse.click',
                label: 'click',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.down',
                label: 'down',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.drag',
                label: 'drag',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.draganddrop',
                label: 'dragAndDrop',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.dragenter',
                label: 'dragEnter',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.dragover',
                label: 'dragOver',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.drop',
                label: 'drop',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.move',
                label: 'move',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.up',
                label: 'up',
              },
              {
                type: 'doc',
                id: 'puppeteer.mouse.wheel',
                label: 'wheel',
              },
            ]
          },
        ],
        "TouchScreen": [
          {
            type: 'doc',
            id: 'puppeteer.touchscreen',
            label: 'touchScreen',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.touchscreen.tap',
                label: 'tap'
              }
            ]
          },
        ],
        "Tracing": [
          {
            type: 'doc',
            id: 'puppeteer.tracing',
            label: 'Tracing',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.tracing._client',
                label: 'client',
              },
              {
                type: 'doc',
                id: 'puppeteer.tracing._path',
                label: 'path',
              },
              {
                type: 'doc',
                id: 'puppeteer.tracing._recording',
                label: 'recording',
              },
              {
                type: 'doc',
                id: 'puppeteer.tracing.start',
                label: 'start',
              },
              {
                type: 'doc',
                id: 'puppeteer.tracing.stop',
                label: 'stop',
              },
            ]
          },
        ],
        "Dialog": [
          {
            type: 'doc',
            id: 'puppeteer.dialog',
            label: 'dialog',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.dialog.accept',
                label: 'accept',
              },
              {
                type: 'doc',
                id: 'puppeteer.dialog.defaultvalue',
                label: 'defaultValue',
              },
              {
                type: 'doc',
                id: 'puppeteer.dialog.dismiss',
                label: 'dismiss',
              },
              {
                type: 'doc',
                id: 'puppeteer.dialog.message',
                label: 'message',
              },
              {
                type: 'doc',
                id: 'puppeteer.dialog.type',
                label: 'type',
              },
            ]
          },
        ],
        "ConsoleMessage": [
          {
            type: 'doc',
            id: 'puppeteer.consolemessage',
            label: 'consoleMessage',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.consolemessage.args',
                label: 'args',
              },
              {
                type: 'doc',
                id: 'puppeteer.consolemessage.location',
                label: 'location',
              },
              {
                type: 'doc',
                id: 'puppeteer.consolemessage.stacktrace',
                label: 'stackTrace',
              },
              {
                type: 'doc',
                id: 'puppeteer.consolemessage.text',
                label: 'text',
              },
              {
                type: 'doc',
                id: 'puppeteer.consolemessage.type',
                label: 'type',
              },
            ]
          },
        ],
        "Frame": [
          {
            type: 'doc',
            id: 'puppeteer.frame',
            label: 'frame',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.frame._',
                label: '$',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.__',
                label: '$$',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.__eval',
                label: '$$eval',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame._eval',
                label: '$eval',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame._x',
                label: '$x',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.addscripttag',
                label: 'addScriptTag',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.addstyletag',
                label: 'addStyleTag',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.childframes',
                label: 'childFrames',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.click',
                label: 'click',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.content',
                label: 'content',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.evaluate',
                label: 'evaluate',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.evaluatehandle',
                label: 'evaluateHandle',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.executioncontext',
                label: 'executionContext',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.focus',
                label: 'focus',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.goto',
                label: 'goTo',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.hover',
                label: 'hover',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.isdetached',
                label: 'isDetached',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.name',
                label: 'name',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.parentframe',
                label: 'parentFrame',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.select',
                label: 'select',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.setcontent',
                label: 'setContent',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.tap',
                label: 'tap',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.title',
                label: 'title',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.type',
                label: 'type',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.url',
                label: 'url',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.waitfor',
                label: 'waitFor',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.waitforfunction',
                label: 'waitForFunction',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.waitfornavigation',
                label: 'waitForNavigation',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.waitforselector',
                label: 'waitForSelector',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.waitfortimeout',
                label: 'waitForTimeOut',
              },
              {
                type: 'doc',
                id: 'puppeteer.frame.waitforxpath',
                label: 'waitForXPath',
              },
            ]
          }
        ],
        "FileChooser": [
          {
            type: 'doc',
            id: 'puppeteer.filechooser',
            label: 'FileChooser',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.filechooser.accept',
                label: 'accept',
              },
              {
                type: 'doc',
                id: 'puppeteer.filechooser.cancel',
                label: 'cancel',
              },
              {
                type: 'doc',
                id: 'puppeteer.filechooser.ismultiple',
                label: 'ismultiple',
              },
            ]
          },
        ],
        "ExecutionContext": [
          {
            type: 'doc',
            id: 'puppeteer.executioncontext',
            label: 'executionContext',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.executioncontext.evaluate',
                label: 'evaluate',
              },
              {
                type: 'doc',
                id: 'puppeteer.executioncontext.evaluatehandle',
                label: 'evaluateHandle',
              },
              {
                type: 'doc',
                id: 'puppeteer.executioncontext.frame',
                label: 'frame',
              },
              {
                type: 'doc',
                id: 'puppeteer.executioncontext.queryobjects',
                label: 'queryobjects',
              },
            ]
          },
        ],
        "JSHandle": [
          {
            type: 'doc',
            id: 'puppeteer.jshandle',
            label: 'JSHandle',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.jshandle.aselement',
                label: 'asElement',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.dispose',
                label: 'dispose',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.evaluate',
                label: 'evaluate',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.evaluatehandle',
                label: 'evaluateHandle',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.executioncontext',
                label: 'executionContext',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.getproperties',
                label: 'getProperties',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.getproperty',
                label: 'getProperty',
              },
              {
                type: 'doc',
                id: 'puppeteer.jshandle.jsonvalue',
                label: 'JSONValue',
              },
            ]
          },
        ],
        "ElementHandle": [
          {
            type: 'doc',
            id: 'puppeteer.elementhandle',
            label: 'elementHandle',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.elementhandle._',
                label: '$',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.__',
                label: '$$',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.__eval',
                label: '$$eval',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle._eval',
                label: '$eval',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle._x',
                label: '$x',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.aselement',
                label: 'asElement',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.boundingbox',
                label: 'boundingBox',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.boxmodel',
                label: 'boxModel',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.click',
                label: 'click',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.contentframe',
                label: 'contentFrame',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.focus',
                label: 'focus',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.hover',
                label: 'hover',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.clickablepoint',
                label: 'clickablePoint',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.drag',
                label: 'drag',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.draganddrop',
                label: 'dragAndDrop',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.dragenter',
                label: 'dragEnter',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.dragover',
                label: 'dragOver',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.drop',
                label: 'drop',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.isintersectingviewport',
                label: 'isIntersectingViewPort',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.press',
                label: 'press',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.screenshot',
                label: 'screenshot',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.select',
                label: 'select',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.tap',
                label: 'tap',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.type',
                label: 'type',
              },
              {
                type: 'doc',
                id: 'puppeteer.elementhandle.uploadfile',
                label: 'uploadFile',
              },
            ]
          },
        ],
        "HTTPRequest": [
          {
            type: 'doc',
            id: 'puppeteer.httprequest',
            label: 'httpRequest',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.httprequest.abort',
                label: 'abort',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.aborterrorreason',
                label: 'abortErrorReason',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.enqueueinterceptaction',
                label: 'enqueueInterCeptaction',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.failure',
                label: 'failure',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.finalizeinterceptions',
                label: 'finalizeInterception',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.frame',
                label: 'frame',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.headers',
                label: 'headers',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.isnavigationrequest',
                label: 'isNavigationRequest',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.method',
                label: 'method',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.postdata',
                label: 'postData',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.redirectchain',
                label: 'redirectChain',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.resourcetype',
                label: 'resourceType',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.respond',
                label: 'respond',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.response',
                label: 'response',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.responseforrequest',
                label: 'responseForRequest',
              },
              {
                type: 'doc',
                id: 'puppeteer.httprequest.url',
                label: 'hurl',
              },
            ]
          },
        ],
        "HTTPRespose": [
          {
            type: 'doc',
            id: 'puppeteer.httpresponse',
            label: 'httpResponse',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.buffer',
                label: 'buffer',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.frame',
                label: 'frame',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.fromcache',
                label: 'fromCache',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.fromserviceworker',
                label: 'fromServiceWorker',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.headers',
                label: 'headers',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.json',
                label: 'JSON',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.ok',
                label: 'OK',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.remoteaddress',
                label: 'remoteAddress',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.request',
                label: 'request',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.securitydetails',
                label: 'securityDetails',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.status',
                label: 'status',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.statustext',
                label: 'statusText',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.text',
                label: 'text',
              },
              {
                type: 'doc',
                id: 'puppeteer.httpresponse.url',
                label: 'URL',
              },
            ]
          },
        ],
        "SecurityDetails": [
          {
            type: 'doc',
            id: 'puppeteer.securitydetails',
            label: 'securityDetails',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.securitydetails.issuer',
                label: 'issuer',
              },
              {
                type: 'doc',
                id: 'puppeteer.securitydetails.protocol',
                label: 'protocol',
              },
              {
                type: 'doc',
                id: 'puppeteer.securitydetails.subjectalternativenames',
                label: 'subjectAlternativeNames',
              },
              {
                type: 'doc',
                id: 'puppeteer.securitydetails.subjectname',
                label: 'subjectName',
              },
              {
                type: 'doc',
                id: 'puppeteer.securitydetails.validfrom',
                label: 'validFrom',
              },
              {
                type: 'doc',
                id: 'puppeteer.securitydetails.validto',
                label: 'validTo',
              },
            ]
          },
        ],
        "Target": [
          {
            type: 'doc',
            id: 'puppeteer.target',
            label: 'target',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.target.browser',
                label: 'browser',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.browsercontext',
                label: 'browserContext',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.createcdpsession',
                label: 'createCDPSSession',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.opener',
                label: 'opener',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.page',
                label: 'page',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.type',
                label: 'type',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.url',
                label: 'url',
              },
              {
                type: 'doc',
                id: 'puppeteer.target.worker',
                label: 'worker',
              },
            ]
          },
        ],
        "CDPSession": [
          {
            type: 'doc',
            id: 'puppeteer.cdpsession',
            label: 'CDPSession',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.cdpsession.connection',
                label: 'connection',
              },
              {
                type: 'doc',
                id: 'puppeteer.cdpsession.detach',
                label: 'detach',
              },
              {
                type: 'doc',
                id: 'puppeteer.cdpsession.send',
                label: 'send',
              },
            ]
          },
        ],
        "Coverage": [
          {
            type: 'doc',
            id: 'puppeteer.coverage',
            label: 'coverage',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.coverage.startcsscoverage',
                label: 'startCSSCoverage',
              },
              {
                type: 'doc',
                id: 'puppeteer.coverage.startjscoverage',
                label: 'startJSCoverage',
              },
              {
                type: 'doc',
                id: 'puppeteer.coverage.stopcsscoverage',
                label: 'stopCSSCoverage',
              },
              {
                type: 'doc',
                id: 'puppeteer.coverage.stopjscoverage',
                label: 'stopJSCoverage',
              },
            ]
          },
        ],
        "TimeOutError": [
          {
            type: 'doc',
            id: 'puppeteer.timeouterror',
            label: 'timeOutError',
          },
        ],
        "EventEmitter": [
          {
            type: 'doc',
            id: 'puppeteer.eventemitter',
            label: 'eventEmitter',
          },
          {
            Methods: [
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.addlistener',
                label: 'addListener',
              },
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.emit',
                label: 'emit',
              },
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.listenercount',
                label: 'listenerCount',
              },
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.off',
                label: 'off',
              },
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.on',
                label: 'on',
              },
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.once',
                label: 'once',
              },
              {
                type: 'doc',
                id: 'puppeteer.eventemitter.removelistener',
                label: 'removeListener',
              },{
                type: 'doc',
                id: 'puppeteer.eventemitter.removealllisteners',
                label: 'removeAllListener',
              },
            ]
          },
        ],
    },
};
