/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_GLOBAL_H__
#define __NB_GLOBAL_H__

#define DEFAULT_CONFIG_DIR ".notebook"
#define DEFAULT_NOTES_FILE "notes.xml"

#include <glib.h>
#include <gtk/gtk.h>

#include "nb_note.h"
#include "nb_note_list.h"

enum {
	NEW,
	INSERTED,
	CLEAN,
	EDITED
};

typedef struct _global Global;

struct _global
{
	Note * current_note;
	gboolean inserted_note;
	gboolean modified_note;
	gboolean show_icon_list;
	NoteList * nl;
	GtkListStore * store;
	gchar * default_browser;
};

/* create and free object */
Global		* nb_global_new (void);
void		nb_global_free (Global * self);

/* notes management */
void		nb_global_new_note (Global * self);
void		nb_global_delete_note (Global * self);
void		nb_global_update_note (Global * self);
gboolean	nb_global_save_note (Global * self);
void		nb_global_check_attachments (Global * self);

/* import/export of NoteList */
void		nb_global_import_note_list (Global * self, gchar * filename);
void		nb_global_export_note_list (Global * self, ExportType * type, gchar * filename);

/* quit */
gboolean	nb_global_quit (Global * self);

/* read/write from/to xml doc */
gboolean        nb_global_update_xml_file (Global * self, Note * n, gint action);

void		nb_global_launch_web_browser (Global * self, gchar * url);

void		nb_global_add_attachments (Global * self, GSList * selection);

#endif
