#!/bin/sh

# container-tools - Manage systemd-nspawn containers
# Copyright (C) 2014-2018 Daniel Baumann <daniel.baumann@open-infrastructure.net>
#
# SPDX-License-Identifier: GPL-3.0+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

set -e

DIRECTORIES="/etc/container-tools/debconf /etc/container-tools/debconf/*/"

for DIRECTORY in ${DIRECTORIES}
do
	if [ -e "${DIRECTORY}/.git" ] && [ -e /usr/bin/git ]
	then
		echo "Updating ${DIRECTORY}..."

		if [ -e /etc/default/container-tools ]
		then
			. /etc/default/container-tools
		fi

		DEBCONF_ID="${DEBCONF_ID:-HEAD}"

		cd "${DIRECTORY}"

		git clean -dfx
		git checkout -f ${DEBCONF_ID}
		git pull --rebase
		echo

		cd "${OLDPWD}"
	fi
done
