/* A Bison parser, made by GNU Bison 3.7.6.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30706

/* Bison version string.  */
#define YYBISON_VERSION "3.7.6"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 25 "../../../openbgpd-portable/src/bgpd/parse.y"

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/ip_ipsp.h>
#include <netinet/icmp6.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <endian.h>
#include <err.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <netdb.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "bgpd.h"
#include "session.h"
#include "rde.h"
#include "log.h"

#ifndef nitems
#define nitems(_a)	(sizeof((_a)) / sizeof((_a)[0]))
#endif

#define MACRO_NAME_LEN		128

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 check_file_secrecy(int, const char *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);
int		 expand_macro(void);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};
int		 symset(const char *, const char *, int);
char		*symget(const char *);

struct filter_rib_l {
	struct filter_rib_l	*next;
	char			 name[PEER_DESCR_LEN];
};

struct filter_peers_l {
	struct filter_peers_l	*next;
	struct filter_peers	 p;
};

struct filter_prefix_l {
	struct filter_prefix_l	*next;
	struct filter_prefix	 p;
};

struct filter_prefixlen {
	enum comp_ops		op;
	int			len_min;
	int			len_max;
};

struct filter_as_l {
	struct filter_as_l	*next;
	struct filter_as	 a;
};

struct filter_match_l {
	struct filter_match	 m;
	struct filter_prefix_l	*prefix_l;
	struct filter_as_l	*as_l;
	struct filter_prefixset	*prefixset;
} fmopts;

struct aspa_tas_l {
	struct aspa_tas_l	*next;
	uint32_t		 as;
	uint32_t		 num;
};

struct flowspec_context {
	uint8_t			*components[FLOWSPEC_TYPE_MAX];
	uint16_t		 complen[FLOWSPEC_TYPE_MAX];
	uint8_t			 aid;
	uint8_t			 type;
	uint8_t			 addr_type;
};

struct peer	*alloc_peer(void);
struct peer	*new_peer(void);
struct peer	*new_group(void);
int		 add_mrtconfig(enum mrt_type, char *, int, struct peer *,
		    char *);
struct rde_rib	*add_rib(char *);
struct rde_rib	*find_rib(char *);
int		 rib_add_fib(struct rde_rib *, u_int);
int		 get_id(struct peer *);
int		 merge_prefixspec(struct filter_prefix *,
		    struct filter_prefixlen *);
int		 expand_rule(struct filter_rule *, struct filter_rib_l *,
		    struct filter_peers_l *, struct filter_match_l *,
		    struct filter_set_head *);
int		 str2key(char *, char *, size_t);
int		 neighbor_consistent(struct peer *);
int		 merge_filterset(struct filter_set_head *, struct filter_set *);
void		 optimize_filters(struct filter_head *);
struct filter_rule	*get_rule(enum action_types);

int		 parsecommunity(struct community *, int, char *);
int		 parseextcommunity(struct community *, char *,
		    char *);
static int	 new_as_set(char *);
static void	 add_as_set(uint32_t);
static void	 done_as_set(void);
static struct prefixset	*new_prefix_set(char *, int);
static void	 add_roa_set(struct prefixset_item *, uint32_t, uint8_t,
		    time_t);
static struct rtr_config	*get_rtr(struct bgpd_addr *);
static int	 insert_rtr(struct rtr_config *);
static int	 merge_aspa_set(uint32_t, struct aspa_tas_l *, time_t);
static int	 map_tos(char *, int *);
static int	 getservice(char *);
static int	 parse_flags(char *);
static struct flowspec_config	*flow_to_flowspec(struct flowspec_context *);
static void	 flow_free(struct flowspec_context *);
static int	 push_prefix(struct bgpd_addr *, uint8_t);
static int	 push_binop(uint8_t, long long);
static int	 push_unary_numop(enum comp_ops, long long);
static int	 push_binary_numop(enum comp_ops, long long, long long);
static int	 geticmptypebyname(char *, uint8_t);
static int	 geticmpcodebyname(u_long, char *, uint8_t);

static struct bgpd_config	*conf;
static struct network_head	*netconf;
static struct peer_head		*new_peers, *cur_peers;
static struct rtr_config_head	*cur_rtrs;
static struct peer		*curpeer;
static struct peer		*curgroup;
static struct rde_rib		*currib;
static struct l3vpn		*curvpn;
static struct prefixset		*curpset, *curoset;
static struct roa_tree		*curroatree;
static struct rtr_config	*currtr;
static struct filter_head	*filter_l;
static struct filter_head	*peerfilter_l;
static struct filter_head	*groupfilter_l;
static struct filter_rule	*curpeer_filter[2];
static struct filter_rule	*curgroup_filter[2];
static struct flowspec_context	*curflow;
static int			 noexpires;

typedef struct {
	union {
		long long		 number;
		char			*string;
		struct bgpd_addr	 addr;
		uint8_t			 u8;
		struct filter_rib_l	*filter_rib;
		struct filter_peers_l	*filter_peers;
		struct filter_match_l	 filter_match;
		struct filter_prefixset	*filter_prefixset;
		struct filter_prefix_l	*filter_prefix;
		struct filter_as_l	*filter_as;
		struct filter_set	*filter_set;
		struct filter_set_head	*filter_set_head;
		struct aspa_tas_l	*aspa_elm;
		struct {
			struct bgpd_addr	prefix;
			uint8_t			len;
		}			prefix;
		struct filter_prefixlen	prefixlen;
		struct prefixset_item	*prefixset_item;
		struct {
			enum auth_enc_alg	enc_alg;
			uint8_t			enc_key_len;
			char			enc_key[IPSEC_ENC_KEY_LEN];
		}			encspec;
	} v;
	int lineno;
} YYSTYPE;


#line 288 "parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    AS = 258,                      /* AS  */
    ROUTERID = 259,                /* ROUTERID  */
    HOLDTIME = 260,                /* HOLDTIME  */
    YMIN = 261,                    /* YMIN  */
    LISTEN = 262,                  /* LISTEN  */
    ON = 263,                      /* ON  */
    FIBUPDATE = 264,               /* FIBUPDATE  */
    FIBPRIORITY = 265,             /* FIBPRIORITY  */
    RTABLE = 266,                  /* RTABLE  */
    NONE = 267,                    /* NONE  */
    UNICAST = 268,                 /* UNICAST  */
    VPN = 269,                     /* VPN  */
    RD = 270,                      /* RD  */
    EXPORT = 271,                  /* EXPORT  */
    EXPORTTRGT = 272,              /* EXPORTTRGT  */
    IMPORTTRGT = 273,              /* IMPORTTRGT  */
    DEFAULTROUTE = 274,            /* DEFAULTROUTE  */
    RDE = 275,                     /* RDE  */
    RIB = 276,                     /* RIB  */
    EVALUATE = 277,                /* EVALUATE  */
    IGNORE = 278,                  /* IGNORE  */
    COMPARE = 279,                 /* COMPARE  */
    RTR = 280,                     /* RTR  */
    PORT = 281,                    /* PORT  */
    GROUP = 282,                   /* GROUP  */
    NEIGHBOR = 283,                /* NEIGHBOR  */
    NETWORK = 284,                 /* NETWORK  */
    EBGP = 285,                    /* EBGP  */
    IBGP = 286,                    /* IBGP  */
    FLOWSPEC = 287,                /* FLOWSPEC  */
    PROTO = 288,                   /* PROTO  */
    FLAGS = 289,                   /* FLAGS  */
    FRAGMENT = 290,                /* FRAGMENT  */
    TOS = 291,                     /* TOS  */
    LENGTH = 292,                  /* LENGTH  */
    ICMPTYPE = 293,                /* ICMPTYPE  */
    CODE = 294,                    /* CODE  */
    LOCALAS = 295,                 /* LOCALAS  */
    REMOTEAS = 296,                /* REMOTEAS  */
    DESCR = 297,                   /* DESCR  */
    LOCALADDR = 298,               /* LOCALADDR  */
    MULTIHOP = 299,                /* MULTIHOP  */
    PASSIVE = 300,                 /* PASSIVE  */
    MAXPREFIX = 301,               /* MAXPREFIX  */
    RESTART = 302,                 /* RESTART  */
    ANNOUNCE = 303,                /* ANNOUNCE  */
    CAPABILITIES = 304,            /* CAPABILITIES  */
    REFRESH = 305,                 /* REFRESH  */
    AS4BYTE = 306,                 /* AS4BYTE  */
    CONNECTRETRY = 307,            /* CONNECTRETRY  */
    ENHANCED = 308,                /* ENHANCED  */
    ADDPATH = 309,                 /* ADDPATH  */
    SEND = 310,                    /* SEND  */
    RECV = 311,                    /* RECV  */
    PLUS = 312,                    /* PLUS  */
    POLICY = 313,                  /* POLICY  */
    ROLE = 314,                    /* ROLE  */
    DEMOTE = 315,                  /* DEMOTE  */
    ENFORCE = 316,                 /* ENFORCE  */
    NEIGHBORAS = 317,              /* NEIGHBORAS  */
    ASOVERRIDE = 318,              /* ASOVERRIDE  */
    REFLECTOR = 319,               /* REFLECTOR  */
    DEPEND = 320,                  /* DEPEND  */
    DOWN = 321,                    /* DOWN  */
    DUMP = 322,                    /* DUMP  */
    IN = 323,                      /* IN  */
    OUT = 324,                     /* OUT  */
    SOCKET = 325,                  /* SOCKET  */
    RESTRICTED = 326,              /* RESTRICTED  */
    LOG = 327,                     /* LOG  */
    TRANSPARENT = 328,             /* TRANSPARENT  */
    TCP = 329,                     /* TCP  */
    MD5SIG = 330,                  /* MD5SIG  */
    PASSWORD = 331,                /* PASSWORD  */
    KEY = 332,                     /* KEY  */
    TTLSECURITY = 333,             /* TTLSECURITY  */
    ALLOW = 334,                   /* ALLOW  */
    DENY = 335,                    /* DENY  */
    MATCH = 336,                   /* MATCH  */
    QUICK = 337,                   /* QUICK  */
    FROM = 338,                    /* FROM  */
    TO = 339,                      /* TO  */
    ANY = 340,                     /* ANY  */
    CONNECTED = 341,               /* CONNECTED  */
    STATIC = 342,                  /* STATIC  */
    COMMUNITY = 343,               /* COMMUNITY  */
    EXTCOMMUNITY = 344,            /* EXTCOMMUNITY  */
    LARGECOMMUNITY = 345,          /* LARGECOMMUNITY  */
    DELETE = 346,                  /* DELETE  */
    MAXCOMMUNITIES = 347,          /* MAXCOMMUNITIES  */
    MAXEXTCOMMUNITIES = 348,       /* MAXEXTCOMMUNITIES  */
    MAXLARGECOMMUNITIES = 349,     /* MAXLARGECOMMUNITIES  */
    PREFIX = 350,                  /* PREFIX  */
    PREFIXLEN = 351,               /* PREFIXLEN  */
    PREFIXSET = 352,               /* PREFIXSET  */
    ASPASET = 353,                 /* ASPASET  */
    ROASET = 354,                  /* ROASET  */
    ORIGINSET = 355,               /* ORIGINSET  */
    OVS = 356,                     /* OVS  */
    AVS = 357,                     /* AVS  */
    EXPIRES = 358,                 /* EXPIRES  */
    ASSET = 359,                   /* ASSET  */
    SOURCEAS = 360,                /* SOURCEAS  */
    TRANSITAS = 361,               /* TRANSITAS  */
    PEERAS = 362,                  /* PEERAS  */
    PROVIDERAS = 363,              /* PROVIDERAS  */
    CUSTOMERAS = 364,              /* CUSTOMERAS  */
    MAXASLEN = 365,                /* MAXASLEN  */
    MAXASSEQ = 366,                /* MAXASSEQ  */
    SET = 367,                     /* SET  */
    LOCALPREF = 368,               /* LOCALPREF  */
    MED = 369,                     /* MED  */
    METRIC = 370,                  /* METRIC  */
    NEXTHOP = 371,                 /* NEXTHOP  */
    REJECT = 372,                  /* REJECT  */
    BLACKHOLE = 373,               /* BLACKHOLE  */
    NOMODIFY = 374,                /* NOMODIFY  */
    SELF = 375,                    /* SELF  */
    PREPEND_SELF = 376,            /* PREPEND_SELF  */
    PREPEND_PEER = 377,            /* PREPEND_PEER  */
    PFTABLE = 378,                 /* PFTABLE  */
    WEIGHT = 379,                  /* WEIGHT  */
    RTLABEL = 380,                 /* RTLABEL  */
    ORIGIN = 381,                  /* ORIGIN  */
    PRIORITY = 382,                /* PRIORITY  */
    ERROR = 383,                   /* ERROR  */
    INCLUDE = 384,                 /* INCLUDE  */
    IPSEC = 385,                   /* IPSEC  */
    ESP = 386,                     /* ESP  */
    AH = 387,                      /* AH  */
    SPI = 388,                     /* SPI  */
    IKE = 389,                     /* IKE  */
    IPV4 = 390,                    /* IPV4  */
    IPV6 = 391,                    /* IPV6  */
    QUALIFY = 392,                 /* QUALIFY  */
    VIA = 393,                     /* VIA  */
    NE = 394,                      /* NE  */
    LE = 395,                      /* LE  */
    GE = 396,                      /* GE  */
    XRANGE = 397,                  /* XRANGE  */
    LONGER = 398,                  /* LONGER  */
    MAXLEN = 399,                  /* MAXLEN  */
    MAX = 400,                     /* MAX  */
    STRING = 401,                  /* STRING  */
    NUMBER = 402                   /* NUMBER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define AS 258
#define ROUTERID 259
#define HOLDTIME 260
#define YMIN 261
#define LISTEN 262
#define ON 263
#define FIBUPDATE 264
#define FIBPRIORITY 265
#define RTABLE 266
#define NONE 267
#define UNICAST 268
#define VPN 269
#define RD 270
#define EXPORT 271
#define EXPORTTRGT 272
#define IMPORTTRGT 273
#define DEFAULTROUTE 274
#define RDE 275
#define RIB 276
#define EVALUATE 277
#define IGNORE 278
#define COMPARE 279
#define RTR 280
#define PORT 281
#define GROUP 282
#define NEIGHBOR 283
#define NETWORK 284
#define EBGP 285
#define IBGP 286
#define FLOWSPEC 287
#define PROTO 288
#define FLAGS 289
#define FRAGMENT 290
#define TOS 291
#define LENGTH 292
#define ICMPTYPE 293
#define CODE 294
#define LOCALAS 295
#define REMOTEAS 296
#define DESCR 297
#define LOCALADDR 298
#define MULTIHOP 299
#define PASSIVE 300
#define MAXPREFIX 301
#define RESTART 302
#define ANNOUNCE 303
#define CAPABILITIES 304
#define REFRESH 305
#define AS4BYTE 306
#define CONNECTRETRY 307
#define ENHANCED 308
#define ADDPATH 309
#define SEND 310
#define RECV 311
#define PLUS 312
#define POLICY 313
#define ROLE 314
#define DEMOTE 315
#define ENFORCE 316
#define NEIGHBORAS 317
#define ASOVERRIDE 318
#define REFLECTOR 319
#define DEPEND 320
#define DOWN 321
#define DUMP 322
#define IN 323
#define OUT 324
#define SOCKET 325
#define RESTRICTED 326
#define LOG 327
#define TRANSPARENT 328
#define TCP 329
#define MD5SIG 330
#define PASSWORD 331
#define KEY 332
#define TTLSECURITY 333
#define ALLOW 334
#define DENY 335
#define MATCH 336
#define QUICK 337
#define FROM 338
#define TO 339
#define ANY 340
#define CONNECTED 341
#define STATIC 342
#define COMMUNITY 343
#define EXTCOMMUNITY 344
#define LARGECOMMUNITY 345
#define DELETE 346
#define MAXCOMMUNITIES 347
#define MAXEXTCOMMUNITIES 348
#define MAXLARGECOMMUNITIES 349
#define PREFIX 350
#define PREFIXLEN 351
#define PREFIXSET 352
#define ASPASET 353
#define ROASET 354
#define ORIGINSET 355
#define OVS 356
#define AVS 357
#define EXPIRES 358
#define ASSET 359
#define SOURCEAS 360
#define TRANSITAS 361
#define PEERAS 362
#define PROVIDERAS 363
#define CUSTOMERAS 364
#define MAXASLEN 365
#define MAXASSEQ 366
#define SET 367
#define LOCALPREF 368
#define MED 369
#define METRIC 370
#define NEXTHOP 371
#define REJECT 372
#define BLACKHOLE 373
#define NOMODIFY 374
#define SELF 375
#define PREPEND_SELF 376
#define PREPEND_PEER 377
#define PFTABLE 378
#define WEIGHT 379
#define RTLABEL 380
#define ORIGIN 381
#define PRIORITY 382
#define ERROR 383
#define INCLUDE 384
#define IPSEC 385
#define ESP 386
#define AH 387
#define SPI 388
#define IKE 389
#define IPV4 390
#define IPV6 391
#define QUALIFY 392
#define VIA 393
#define NE 394
#define LE 395
#define GE 396
#define XRANGE 397
#define LONGER 398
#define MAXLEN 399
#define MAX 400
#define STRING 401
#define NUMBER 402

/* Value type.  */


extern YYSTYPE yylval;

int yyparse (void);


/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_AS = 3,                         /* AS  */
  YYSYMBOL_ROUTERID = 4,                   /* ROUTERID  */
  YYSYMBOL_HOLDTIME = 5,                   /* HOLDTIME  */
  YYSYMBOL_YMIN = 6,                       /* YMIN  */
  YYSYMBOL_LISTEN = 7,                     /* LISTEN  */
  YYSYMBOL_ON = 8,                         /* ON  */
  YYSYMBOL_FIBUPDATE = 9,                  /* FIBUPDATE  */
  YYSYMBOL_FIBPRIORITY = 10,               /* FIBPRIORITY  */
  YYSYMBOL_RTABLE = 11,                    /* RTABLE  */
  YYSYMBOL_NONE = 12,                      /* NONE  */
  YYSYMBOL_UNICAST = 13,                   /* UNICAST  */
  YYSYMBOL_VPN = 14,                       /* VPN  */
  YYSYMBOL_RD = 15,                        /* RD  */
  YYSYMBOL_EXPORT = 16,                    /* EXPORT  */
  YYSYMBOL_EXPORTTRGT = 17,                /* EXPORTTRGT  */
  YYSYMBOL_IMPORTTRGT = 18,                /* IMPORTTRGT  */
  YYSYMBOL_DEFAULTROUTE = 19,              /* DEFAULTROUTE  */
  YYSYMBOL_RDE = 20,                       /* RDE  */
  YYSYMBOL_RIB = 21,                       /* RIB  */
  YYSYMBOL_EVALUATE = 22,                  /* EVALUATE  */
  YYSYMBOL_IGNORE = 23,                    /* IGNORE  */
  YYSYMBOL_COMPARE = 24,                   /* COMPARE  */
  YYSYMBOL_RTR = 25,                       /* RTR  */
  YYSYMBOL_PORT = 26,                      /* PORT  */
  YYSYMBOL_GROUP = 27,                     /* GROUP  */
  YYSYMBOL_NEIGHBOR = 28,                  /* NEIGHBOR  */
  YYSYMBOL_NETWORK = 29,                   /* NETWORK  */
  YYSYMBOL_EBGP = 30,                      /* EBGP  */
  YYSYMBOL_IBGP = 31,                      /* IBGP  */
  YYSYMBOL_FLOWSPEC = 32,                  /* FLOWSPEC  */
  YYSYMBOL_PROTO = 33,                     /* PROTO  */
  YYSYMBOL_FLAGS = 34,                     /* FLAGS  */
  YYSYMBOL_FRAGMENT = 35,                  /* FRAGMENT  */
  YYSYMBOL_TOS = 36,                       /* TOS  */
  YYSYMBOL_LENGTH = 37,                    /* LENGTH  */
  YYSYMBOL_ICMPTYPE = 38,                  /* ICMPTYPE  */
  YYSYMBOL_CODE = 39,                      /* CODE  */
  YYSYMBOL_LOCALAS = 40,                   /* LOCALAS  */
  YYSYMBOL_REMOTEAS = 41,                  /* REMOTEAS  */
  YYSYMBOL_DESCR = 42,                     /* DESCR  */
  YYSYMBOL_LOCALADDR = 43,                 /* LOCALADDR  */
  YYSYMBOL_MULTIHOP = 44,                  /* MULTIHOP  */
  YYSYMBOL_PASSIVE = 45,                   /* PASSIVE  */
  YYSYMBOL_MAXPREFIX = 46,                 /* MAXPREFIX  */
  YYSYMBOL_RESTART = 47,                   /* RESTART  */
  YYSYMBOL_ANNOUNCE = 48,                  /* ANNOUNCE  */
  YYSYMBOL_CAPABILITIES = 49,              /* CAPABILITIES  */
  YYSYMBOL_REFRESH = 50,                   /* REFRESH  */
  YYSYMBOL_AS4BYTE = 51,                   /* AS4BYTE  */
  YYSYMBOL_CONNECTRETRY = 52,              /* CONNECTRETRY  */
  YYSYMBOL_ENHANCED = 53,                  /* ENHANCED  */
  YYSYMBOL_ADDPATH = 54,                   /* ADDPATH  */
  YYSYMBOL_SEND = 55,                      /* SEND  */
  YYSYMBOL_RECV = 56,                      /* RECV  */
  YYSYMBOL_PLUS = 57,                      /* PLUS  */
  YYSYMBOL_POLICY = 58,                    /* POLICY  */
  YYSYMBOL_ROLE = 59,                      /* ROLE  */
  YYSYMBOL_DEMOTE = 60,                    /* DEMOTE  */
  YYSYMBOL_ENFORCE = 61,                   /* ENFORCE  */
  YYSYMBOL_NEIGHBORAS = 62,                /* NEIGHBORAS  */
  YYSYMBOL_ASOVERRIDE = 63,                /* ASOVERRIDE  */
  YYSYMBOL_REFLECTOR = 64,                 /* REFLECTOR  */
  YYSYMBOL_DEPEND = 65,                    /* DEPEND  */
  YYSYMBOL_DOWN = 66,                      /* DOWN  */
  YYSYMBOL_DUMP = 67,                      /* DUMP  */
  YYSYMBOL_IN = 68,                        /* IN  */
  YYSYMBOL_OUT = 69,                       /* OUT  */
  YYSYMBOL_SOCKET = 70,                    /* SOCKET  */
  YYSYMBOL_RESTRICTED = 71,                /* RESTRICTED  */
  YYSYMBOL_LOG = 72,                       /* LOG  */
  YYSYMBOL_TRANSPARENT = 73,               /* TRANSPARENT  */
  YYSYMBOL_TCP = 74,                       /* TCP  */
  YYSYMBOL_MD5SIG = 75,                    /* MD5SIG  */
  YYSYMBOL_PASSWORD = 76,                  /* PASSWORD  */
  YYSYMBOL_KEY = 77,                       /* KEY  */
  YYSYMBOL_TTLSECURITY = 78,               /* TTLSECURITY  */
  YYSYMBOL_ALLOW = 79,                     /* ALLOW  */
  YYSYMBOL_DENY = 80,                      /* DENY  */
  YYSYMBOL_MATCH = 81,                     /* MATCH  */
  YYSYMBOL_QUICK = 82,                     /* QUICK  */
  YYSYMBOL_FROM = 83,                      /* FROM  */
  YYSYMBOL_TO = 84,                        /* TO  */
  YYSYMBOL_ANY = 85,                       /* ANY  */
  YYSYMBOL_CONNECTED = 86,                 /* CONNECTED  */
  YYSYMBOL_STATIC = 87,                    /* STATIC  */
  YYSYMBOL_COMMUNITY = 88,                 /* COMMUNITY  */
  YYSYMBOL_EXTCOMMUNITY = 89,              /* EXTCOMMUNITY  */
  YYSYMBOL_LARGECOMMUNITY = 90,            /* LARGECOMMUNITY  */
  YYSYMBOL_DELETE = 91,                    /* DELETE  */
  YYSYMBOL_MAXCOMMUNITIES = 92,            /* MAXCOMMUNITIES  */
  YYSYMBOL_MAXEXTCOMMUNITIES = 93,         /* MAXEXTCOMMUNITIES  */
  YYSYMBOL_MAXLARGECOMMUNITIES = 94,       /* MAXLARGECOMMUNITIES  */
  YYSYMBOL_PREFIX = 95,                    /* PREFIX  */
  YYSYMBOL_PREFIXLEN = 96,                 /* PREFIXLEN  */
  YYSYMBOL_PREFIXSET = 97,                 /* PREFIXSET  */
  YYSYMBOL_ASPASET = 98,                   /* ASPASET  */
  YYSYMBOL_ROASET = 99,                    /* ROASET  */
  YYSYMBOL_ORIGINSET = 100,                /* ORIGINSET  */
  YYSYMBOL_OVS = 101,                      /* OVS  */
  YYSYMBOL_AVS = 102,                      /* AVS  */
  YYSYMBOL_EXPIRES = 103,                  /* EXPIRES  */
  YYSYMBOL_ASSET = 104,                    /* ASSET  */
  YYSYMBOL_SOURCEAS = 105,                 /* SOURCEAS  */
  YYSYMBOL_TRANSITAS = 106,                /* TRANSITAS  */
  YYSYMBOL_PEERAS = 107,                   /* PEERAS  */
  YYSYMBOL_PROVIDERAS = 108,               /* PROVIDERAS  */
  YYSYMBOL_CUSTOMERAS = 109,               /* CUSTOMERAS  */
  YYSYMBOL_MAXASLEN = 110,                 /* MAXASLEN  */
  YYSYMBOL_MAXASSEQ = 111,                 /* MAXASSEQ  */
  YYSYMBOL_SET = 112,                      /* SET  */
  YYSYMBOL_LOCALPREF = 113,                /* LOCALPREF  */
  YYSYMBOL_MED = 114,                      /* MED  */
  YYSYMBOL_METRIC = 115,                   /* METRIC  */
  YYSYMBOL_NEXTHOP = 116,                  /* NEXTHOP  */
  YYSYMBOL_REJECT = 117,                   /* REJECT  */
  YYSYMBOL_BLACKHOLE = 118,                /* BLACKHOLE  */
  YYSYMBOL_NOMODIFY = 119,                 /* NOMODIFY  */
  YYSYMBOL_SELF = 120,                     /* SELF  */
  YYSYMBOL_PREPEND_SELF = 121,             /* PREPEND_SELF  */
  YYSYMBOL_PREPEND_PEER = 122,             /* PREPEND_PEER  */
  YYSYMBOL_PFTABLE = 123,                  /* PFTABLE  */
  YYSYMBOL_WEIGHT = 124,                   /* WEIGHT  */
  YYSYMBOL_RTLABEL = 125,                  /* RTLABEL  */
  YYSYMBOL_ORIGIN = 126,                   /* ORIGIN  */
  YYSYMBOL_PRIORITY = 127,                 /* PRIORITY  */
  YYSYMBOL_ERROR = 128,                    /* ERROR  */
  YYSYMBOL_INCLUDE = 129,                  /* INCLUDE  */
  YYSYMBOL_IPSEC = 130,                    /* IPSEC  */
  YYSYMBOL_ESP = 131,                      /* ESP  */
  YYSYMBOL_AH = 132,                       /* AH  */
  YYSYMBOL_SPI = 133,                      /* SPI  */
  YYSYMBOL_IKE = 134,                      /* IKE  */
  YYSYMBOL_IPV4 = 135,                     /* IPV4  */
  YYSYMBOL_IPV6 = 136,                     /* IPV6  */
  YYSYMBOL_QUALIFY = 137,                  /* QUALIFY  */
  YYSYMBOL_VIA = 138,                      /* VIA  */
  YYSYMBOL_NE = 139,                       /* NE  */
  YYSYMBOL_LE = 140,                       /* LE  */
  YYSYMBOL_GE = 141,                       /* GE  */
  YYSYMBOL_XRANGE = 142,                   /* XRANGE  */
  YYSYMBOL_LONGER = 143,                   /* LONGER  */
  YYSYMBOL_MAXLEN = 144,                   /* MAXLEN  */
  YYSYMBOL_MAX = 145,                      /* MAX  */
  YYSYMBOL_STRING = 146,                   /* STRING  */
  YYSYMBOL_NUMBER = 147,                   /* NUMBER  */
  YYSYMBOL_148_n_ = 148,                   /* '\n'  */
  YYSYMBOL_149_ = 149,                     /* '='  */
  YYSYMBOL_150_ = 150,                     /* '{'  */
  YYSYMBOL_151_ = 151,                     /* '}'  */
  YYSYMBOL_152_ = 152,                     /* '/'  */
  YYSYMBOL_153_ = 153,                     /* '+'  */
  YYSYMBOL_154_ = 154,                     /* '-'  */
  YYSYMBOL_155_ = 155,                     /* ','  */
  YYSYMBOL_156_ = 156,                     /* '<'  */
  YYSYMBOL_157_ = 157,                     /* '>'  */
  YYSYMBOL_YYACCEPT = 158,                 /* $accept  */
  YYSYMBOL_grammar = 159,                  /* grammar  */
  YYSYMBOL_asnumber = 160,                 /* asnumber  */
  YYSYMBOL_as4number = 161,                /* as4number  */
  YYSYMBOL_as4number_any = 162,            /* as4number_any  */
  YYSYMBOL_string = 163,                   /* string  */
  YYSYMBOL_yesno = 164,                    /* yesno  */
  YYSYMBOL_varset = 165,                   /* varset  */
  YYSYMBOL_include = 166,                  /* include  */
  YYSYMBOL_as_set = 167,                   /* as_set  */
  YYSYMBOL_168_1 = 168,                    /* $@1  */
  YYSYMBOL_as_set_l = 169,                 /* as_set_l  */
  YYSYMBOL_prefixset = 170,                /* prefixset  */
  YYSYMBOL_171_2 = 171,                    /* $@2  */
  YYSYMBOL_prefixset_l = 172,              /* prefixset_l  */
  YYSYMBOL_prefixset_item = 173,           /* prefixset_item  */
  YYSYMBOL_roa_set = 174,                  /* roa_set  */
  YYSYMBOL_175_3 = 175,                    /* $@3  */
  YYSYMBOL_origin_set = 176,               /* origin_set  */
  YYSYMBOL_177_4 = 177,                    /* $@4  */
  YYSYMBOL_expires = 178,                  /* expires  */
  YYSYMBOL_roa_set_l = 179,                /* roa_set_l  */
  YYSYMBOL_aspa_set = 180,                 /* aspa_set  */
  YYSYMBOL_aspa_set_l = 181,               /* aspa_set_l  */
  YYSYMBOL_aspa_elm = 182,                 /* aspa_elm  */
  YYSYMBOL_aspa_tas_l = 183,               /* aspa_tas_l  */
  YYSYMBOL_aspa_tas = 184,                 /* aspa_tas  */
  YYSYMBOL_rtr = 185,                      /* rtr  */
  YYSYMBOL_186_5 = 186,                    /* $@5  */
  YYSYMBOL_rtropt_l = 187,                 /* rtropt_l  */
  YYSYMBOL_rtropt = 188,                   /* rtropt  */
  YYSYMBOL_conf_main = 189,                /* conf_main  */
  YYSYMBOL_rib = 190,                      /* rib  */
  YYSYMBOL_191_6 = 191,                    /* $@6  */
  YYSYMBOL_ribopts = 192,                  /* ribopts  */
  YYSYMBOL_fibupdate = 193,                /* fibupdate  */
  YYSYMBOL_mrtdump = 194,                  /* mrtdump  */
  YYSYMBOL_network = 195,                  /* network  */
  YYSYMBOL_flowspec = 196,                 /* flowspec  */
  YYSYMBOL_197_7 = 197,                    /* $@7  */
  YYSYMBOL_proto = 198,                    /* proto  */
  YYSYMBOL_proto_list = 199,               /* proto_list  */
  YYSYMBOL_proto_item = 200,               /* proto_item  */
  YYSYMBOL_from = 201,                     /* from  */
  YYSYMBOL_202_8 = 202,                    /* $@8  */
  YYSYMBOL_to = 203,                       /* to  */
  YYSYMBOL_204_9 = 204,                    /* $@9  */
  YYSYMBOL_ipportspec = 205,               /* ipportspec  */
  YYSYMBOL_ipspec = 206,                   /* ipspec  */
  YYSYMBOL_portspec = 207,                 /* portspec  */
  YYSYMBOL_port_list = 208,                /* port_list  */
  YYSYMBOL_port_item = 209,                /* port_item  */
  YYSYMBOL_port = 210,                     /* port  */
  YYSYMBOL_flow_rules = 211,               /* flow_rules  */
  YYSYMBOL_flow_rules_l = 212,             /* flow_rules_l  */
  YYSYMBOL_flowrule = 213,                 /* flowrule  */
  YYSYMBOL_214_10 = 214,                   /* $@10  */
  YYSYMBOL_215_11 = 215,                   /* $@11  */
  YYSYMBOL_flags = 216,                    /* flags  */
  YYSYMBOL_flag = 217,                     /* flag  */
  YYSYMBOL_icmpspec = 218,                 /* icmpspec  */
  YYSYMBOL_icmp_list = 219,                /* icmp_list  */
  YYSYMBOL_icmp_item = 220,                /* icmp_item  */
  YYSYMBOL_icmptype = 221,                 /* icmptype  */
  YYSYMBOL_tos = 222,                      /* tos  */
  YYSYMBOL_lengthspec = 223,               /* lengthspec  */
  YYSYMBOL_length_list = 224,              /* length_list  */
  YYSYMBOL_length_item = 225,              /* length_item  */
  YYSYMBOL_length = 226,                   /* length  */
  YYSYMBOL_inout = 227,                    /* inout  */
  YYSYMBOL_restricted = 228,               /* restricted  */
  YYSYMBOL_address = 229,                  /* address  */
  YYSYMBOL_prefix = 230,                   /* prefix  */
  YYSYMBOL_addrspec = 231,                 /* addrspec  */
  YYSYMBOL_optnumber = 232,                /* optnumber  */
  YYSYMBOL_l3vpn = 233,                    /* l3vpn  */
  YYSYMBOL_234_12 = 234,                   /* $@12  */
  YYSYMBOL_l3vpnopts_l = 235,              /* l3vpnopts_l  */
  YYSYMBOL_l3vpnopts = 236,                /* l3vpnopts  */
  YYSYMBOL_neighbor = 237,                 /* neighbor  */
  YYSYMBOL_238_13 = 238,                   /* $@13  */
  YYSYMBOL_239_14 = 239,                   /* $@14  */
  YYSYMBOL_group = 240,                    /* group  */
  YYSYMBOL_241_15 = 241,                   /* $@15  */
  YYSYMBOL_groupopts_l = 242,              /* groupopts_l  */
  YYSYMBOL_addpathextra = 243,             /* addpathextra  */
  YYSYMBOL_addpathmax = 244,               /* addpathmax  */
  YYSYMBOL_peeropts_h = 245,               /* peeropts_h  */
  YYSYMBOL_peeropts_l = 246,               /* peeropts_l  */
  YYSYMBOL_peeropts = 247,                 /* peeropts  */
  YYSYMBOL_restart = 248,                  /* restart  */
  YYSYMBOL_af = 249,                       /* af  */
  YYSYMBOL_safi = 250,                     /* safi  */
  YYSYMBOL_nettype = 251,                  /* nettype  */
  YYSYMBOL_espah = 252,                    /* espah  */
  YYSYMBOL_encspec = 253,                  /* encspec  */
  YYSYMBOL_filterrule = 254,               /* filterrule  */
  YYSYMBOL_action = 255,                   /* action  */
  YYSYMBOL_quick = 256,                    /* quick  */
  YYSYMBOL_direction = 257,                /* direction  */
  YYSYMBOL_filter_rib_h = 258,             /* filter_rib_h  */
  YYSYMBOL_filter_rib_l = 259,             /* filter_rib_l  */
  YYSYMBOL_filter_rib = 260,               /* filter_rib  */
  YYSYMBOL_filter_peer_h = 261,            /* filter_peer_h  */
  YYSYMBOL_filter_peer_l = 262,            /* filter_peer_l  */
  YYSYMBOL_filter_peer = 263,              /* filter_peer  */
  YYSYMBOL_filter_prefix_h = 264,          /* filter_prefix_h  */
  YYSYMBOL_filter_prefix_m = 265,          /* filter_prefix_m  */
  YYSYMBOL_filter_prefix_l = 266,          /* filter_prefix_l  */
  YYSYMBOL_filter_prefix = 267,            /* filter_prefix  */
  YYSYMBOL_filter_as_h = 268,              /* filter_as_h  */
  YYSYMBOL_filter_as_t_l = 269,            /* filter_as_t_l  */
  YYSYMBOL_filter_as_t = 270,              /* filter_as_t  */
  YYSYMBOL_filter_as_l_h = 271,            /* filter_as_l_h  */
  YYSYMBOL_filter_as_l = 272,              /* filter_as_l  */
  YYSYMBOL_filter_as = 273,                /* filter_as  */
  YYSYMBOL_filter_match_h = 274,           /* filter_match_h  */
  YYSYMBOL_275_16 = 275,                   /* $@16  */
  YYSYMBOL_filter_match = 276,             /* filter_match  */
  YYSYMBOL_filter_elm = 277,               /* filter_elm  */
  YYSYMBOL_prefixlenop = 278,              /* prefixlenop  */
  YYSYMBOL_filter_as_type = 279,           /* filter_as_type  */
  YYSYMBOL_filter_set = 280,               /* filter_set  */
  YYSYMBOL_filter_set_l = 281,             /* filter_set_l  */
  YYSYMBOL_community = 282,                /* community  */
  YYSYMBOL_delete = 283,                   /* delete  */
  YYSYMBOL_enforce = 284,                  /* enforce  */
  YYSYMBOL_filter_set_opt = 285,           /* filter_set_opt  */
  YYSYMBOL_origincode = 286,               /* origincode  */
  YYSYMBOL_validity = 287,                 /* validity  */
  YYSYMBOL_aspa_validity = 288,            /* aspa_validity  */
  YYSYMBOL_optnl = 289,                    /* optnl  */
  YYSYMBOL_comma = 290,                    /* comma  */
  YYSYMBOL_unaryop = 291,                  /* unaryop  */
  YYSYMBOL_equalityop = 292,               /* equalityop  */
  YYSYMBOL_binaryop = 293                  /* binaryop  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   893

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  158
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  136
/* YYNRULES -- Number of rules.  */
#define YYNRULES  409
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  751

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   402


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     148,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   153,   155,   154,     2,   152,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     156,   149,   157,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   150,     2,   151,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   299,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   321,   332,   364,   374,   401,   406,   412,   415,
     430,   458,   473,   473,   487,   495,   496,   498,   498,   508,
     518,   532,   548,   565,   565,   570,   573,   573,   587,   599,
     602,   610,   620,   632,   633,   636,   637,   640,   657,   658,
     665,   671,   679,   688,   688,   700,   701,   704,   715,   723,
     728,   735,   739,   746,   754,   762,   776,   790,   797,   808,
     814,   820,   829,   857,   889,   899,   909,   922,   935,   948,
     964,   971,   987,   987,   997,   998,  1007,  1016,  1017,  1025,
    1055,  1076,  1105,  1124,  1147,  1167,  1167,  1196,  1197,  1200,
    1205,  1212,  1224,  1233,  1233,  1239,  1239,  1245,  1246,  1247,
    1250,  1251,  1257,  1258,  1261,  1262,  1265,  1269,  1273,  1279,
    1287,  1297,  1298,  1301,  1302,  1305,  1306,  1307,  1307,  1310,
    1310,  1313,  1314,  1317,  1318,  1325,  1340,  1344,  1348,  1351,
    1361,  1362,  1365,  1366,  1369,  1374,  1392,  1406,  1418,  1427,
    1447,  1456,  1457,  1460,  1461,  1464,  1468,  1472,  1478,  1486,
    1487,  1490,  1491,  1494,  1515,  1533,  1553,  1560,  1563,  1564,
    1567,  1567,  1612,  1613,  1614,  1615,  1618,  1636,  1654,  1672,
    1678,  1681,  1682,  1681,  1716,  1716,  1748,  1749,  1750,  1751,
    1752,  1755,  1756,  1766,  1767,  1777,  1778,  1779,  1782,  1783,
    1784,  1785,  1788,  1791,  1798,  1802,  1813,  1826,  1836,  1843,
    1846,  1849,  1860,  1876,  1884,  1892,  1911,  1914,  1917,  1920,
    1923,  1926,  1936,  1980,  1983,  2002,  2005,  2008,  2011,  2017,
    2023,  2038,  2046,  2054,  2072,  2088,  2098,  2191,  2194,  2201,
    2213,  2214,  2224,  2240,  2252,  2276,  2282,  2293,  2299,  2302,
    2317,  2318,  2328,  2329,  2332,  2333,  2334,  2335,  2338,  2339,
    2342,  2343,  2346,  2349,  2382,  2409,  2410,  2411,  2414,  2415,
    2418,  2419,  2422,  2423,  2424,  2426,  2427,  2433,  2455,  2456,
    2459,  2460,  2466,  2473,  2493,  2500,  2521,  2527,  2535,  2550,
    2565,  2566,  2569,  2570,  2571,  2583,  2584,  2590,  2605,  2606,
    2609,  2610,  2622,  2626,  2633,  2656,  2657,  2658,  2671,  2672,
    2678,  2686,  2692,  2700,  2714,  2717,  2717,  2725,  2726,  2729,
    2742,  2749,  2761,  2773,  2791,  2813,  2832,  2848,  2860,  2872,
    2880,  2887,  2936,  2956,  2964,  2974,  2975,  2981,  2992,  3035,
    3051,  3052,  3053,  3054,  3057,  3058,  3065,  3068,  3073,  3082,
    3083,  3086,  3087,  3090,  3091,  3094,  3109,  3119,  3129,  3144,
    3154,  3164,  3179,  3189,  3199,  3214,  3224,  3234,  3241,  3246,
    3251,  3256,  3261,  3271,  3281,  3286,  3313,  3327,  3355,  3373,
    3389,  3397,  3412,  3427,  3442,  3443,  3446,  3447,  3448,  3449,
    3452,  3453,  3454,  3455,  3456,  3457,  3460,  3461,  3464,  3465
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "AS", "ROUTERID",
  "HOLDTIME", "YMIN", "LISTEN", "ON", "FIBUPDATE", "FIBPRIORITY", "RTABLE",
  "NONE", "UNICAST", "VPN", "RD", "EXPORT", "EXPORTTRGT", "IMPORTTRGT",
  "DEFAULTROUTE", "RDE", "RIB", "EVALUATE", "IGNORE", "COMPARE", "RTR",
  "PORT", "GROUP", "NEIGHBOR", "NETWORK", "EBGP", "IBGP", "FLOWSPEC",
  "PROTO", "FLAGS", "FRAGMENT", "TOS", "LENGTH", "ICMPTYPE", "CODE",
  "LOCALAS", "REMOTEAS", "DESCR", "LOCALADDR", "MULTIHOP", "PASSIVE",
  "MAXPREFIX", "RESTART", "ANNOUNCE", "CAPABILITIES", "REFRESH", "AS4BYTE",
  "CONNECTRETRY", "ENHANCED", "ADDPATH", "SEND", "RECV", "PLUS", "POLICY",
  "ROLE", "DEMOTE", "ENFORCE", "NEIGHBORAS", "ASOVERRIDE", "REFLECTOR",
  "DEPEND", "DOWN", "DUMP", "IN", "OUT", "SOCKET", "RESTRICTED", "LOG",
  "TRANSPARENT", "TCP", "MD5SIG", "PASSWORD", "KEY", "TTLSECURITY",
  "ALLOW", "DENY", "MATCH", "QUICK", "FROM", "TO", "ANY", "CONNECTED",
  "STATIC", "COMMUNITY", "EXTCOMMUNITY", "LARGECOMMUNITY", "DELETE",
  "MAXCOMMUNITIES", "MAXEXTCOMMUNITIES", "MAXLARGECOMMUNITIES", "PREFIX",
  "PREFIXLEN", "PREFIXSET", "ASPASET", "ROASET", "ORIGINSET", "OVS", "AVS",
  "EXPIRES", "ASSET", "SOURCEAS", "TRANSITAS", "PEERAS", "PROVIDERAS",
  "CUSTOMERAS", "MAXASLEN", "MAXASSEQ", "SET", "LOCALPREF", "MED",
  "METRIC", "NEXTHOP", "REJECT", "BLACKHOLE", "NOMODIFY", "SELF",
  "PREPEND_SELF", "PREPEND_PEER", "PFTABLE", "WEIGHT", "RTLABEL", "ORIGIN",
  "PRIORITY", "ERROR", "INCLUDE", "IPSEC", "ESP", "AH", "SPI", "IKE",
  "IPV4", "IPV6", "QUALIFY", "VIA", "NE", "LE", "GE", "XRANGE", "LONGER",
  "MAXLEN", "MAX", "STRING", "NUMBER", "'\\n'", "'='", "'{'", "'}'", "'/'",
  "'+'", "'-'", "','", "'<'", "'>'", "$accept", "grammar", "asnumber",
  "as4number", "as4number_any", "string", "yesno", "varset", "include",
  "as_set", "$@1", "as_set_l", "prefixset", "$@2", "prefixset_l",
  "prefixset_item", "roa_set", "$@3", "origin_set", "$@4", "expires",
  "roa_set_l", "aspa_set", "aspa_set_l", "aspa_elm", "aspa_tas_l",
  "aspa_tas", "rtr", "$@5", "rtropt_l", "rtropt", "conf_main", "rib",
  "$@6", "ribopts", "fibupdate", "mrtdump", "network", "flowspec", "$@7",
  "proto", "proto_list", "proto_item", "from", "$@8", "to", "$@9",
  "ipportspec", "ipspec", "portspec", "port_list", "port_item", "port",
  "flow_rules", "flow_rules_l", "flowrule", "$@10", "$@11", "flags",
  "flag", "icmpspec", "icmp_list", "icmp_item", "icmptype", "tos",
  "lengthspec", "length_list", "length_item", "length", "inout",
  "restricted", "address", "prefix", "addrspec", "optnumber", "l3vpn",
  "$@12", "l3vpnopts_l", "l3vpnopts", "neighbor", "$@13", "$@14", "group",
  "$@15", "groupopts_l", "addpathextra", "addpathmax", "peeropts_h",
  "peeropts_l", "peeropts", "restart", "af", "safi", "nettype", "espah",
  "encspec", "filterrule", "action", "quick", "direction", "filter_rib_h",
  "filter_rib_l", "filter_rib", "filter_peer_h", "filter_peer_l",
  "filter_peer", "filter_prefix_h", "filter_prefix_m", "filter_prefix_l",
  "filter_prefix", "filter_as_h", "filter_as_t_l", "filter_as_t",
  "filter_as_l_h", "filter_as_l", "filter_as", "filter_match_h", "$@16",
  "filter_match", "filter_elm", "prefixlenop", "filter_as_type",
  "filter_set", "filter_set_l", "community", "delete", "enforce",
  "filter_set_opt", "origincode", "validity", "aspa_validity", "optnl",
  "comma", "unaryop", "equalityop", "binaryop", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,    10,    61,
     123,   125,    47,    43,    45,    44,    60,    62
};
#endif

#define YYPACT_NINF (-569)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-397)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -569,   682,  -569,   -61,   -38,   -43,    23,   106,   -26,    -2,
       2,    -9,    43,   -43,    -4,   -25,    56,    12,    52,     9,
      36,   -26,  -569,  -569,  -569,    42,   -18,    46,    53,    55,
      35,    82,    61,    64,  -569,    79,    84,    86,    89,   100,
     102,   107,   112,   120,   136,   145,   148,   150,   163,   165,
     245,   173,   187,   224,  -569,  -569,  -569,  -569,   194,  -569,
    -569,   198,  -569,   -43,  -569,  -569,  -569,  -569,   340,   210,
     212,   329,   240,   214,  -569,   228,   241,  -569,  -569,   242,
     253,   280,   122,  -569,  -569,   251,    10,   338,  -569,  -569,
     277,   293,   293,   326,   334,   305,   -26,  -569,    -4,  -569,
    -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,  -569,  -569,   130,  -569,  -569,  -569,   458,  -569,
    -569,   466,   348,  -569,  -569,   352,  -569,  -569,   353,  -569,
     355,   280,   369,   378,   254,  -569,  -569,  -569,   383,   389,
     280,   402,   391,  -569,  -569,   396,   398,  -569,  -569,   293,
     293,   -23,   395,   293,   293,   403,  -569,   228,   242,  -569,
    -569,  -569,   -19,   218,   219,  -569,    29,  -569,   293,  -569,
    -569,  -569,  -569,  -569,  -569,   457,  -569,    63,   125,   186,
     121,   407,   408,   410,   207,   411,   414,   293,   457,  -569,
     280,   280,  -569,   182,  -569,  -569,   235,   169,   261,  -569,
    -569,  -569,  -569,  -569,   280,   402,  -569,  -569,   417,  -569,
    -569,   396,   413,  -569,   -38,  -569,    57,  -569,  -569,   271,
     420,   423,  -569,   427,  -569,   293,  -569,  -569,  -569,    44,
    -569,  -569,  -569,   428,   -26,   429,   559,  -569,  -569,    74,
     591,  -569,   -16,  -569,   438,   439,  -569,   440,   442,  -569,
     443,   444,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,
    -569,   446,   448,  -569,  -569,  -569,   300,   453,  -569,  -569,
    -569,  -569,   293,  -569,   -33,   -33,  -569,  -569,  -569,  -569,
    -569,  -569,  -569,  -569,   293,  -569,  -569,  -569,  -569,   -53,
     451,  -569,  -569,   293,  -569,   555,    22,    22,  -569,  -569,
     396,  -569,  -569,   271,   497,   293,   454,   450,   494,   499,
     247,   -20,  -569,   271,  -569,   273,   730,  -569,   459,   -38,
     462,  -569,  -569,  -569,   293,  -569,   -44,  -569,  -569,  -569,
     600,  -569,   219,   464,   -43,   293,  -569,   472,    24,    76,
     592,   475,   219,   -38,   -38,    -4,   -43,   476,  -569,   477,
     236,    19,   480,    40,   -26,   -43,   614,   481,   482,   483,
     -26,   563,   -26,   743,   526,   316,  -569,  -569,   597,  -569,
     493,   495,   496,   498,  -569,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,   247,  -569,  -569,   285,  -569,  -569,   500,  -569,
     501,  -569,   244,  -569,  -569,   451,  -569,   313,   320,   412,
    -569,  -569,   619,  -569,  -569,  -569,   247,  -569,   502,   539,
     508,   293,  -569,  -569,   273,   509,   271,   426,  -569,   514,
    -569,   247,  -569,  -569,  -569,   247,  -569,   511,   176,  -569,
    -569,  -569,    30,   280,   164,    26,  -569,  -569,  -569,  -569,
      11,  -569,   519,  -569,  -569,  -569,   521,  -569,  -569,   194,
    -569,   228,  -569,  -569,    37,   -26,   -26,   -26,   -26,   598,
     434,   -10,    80,  -569,  -569,  -569,   -26,   -26,  -569,  -569,
     522,  -569,   452,  -569,  -569,   447,  -569,   293,  -569,   -26,
    -569,  -569,    13,  -569,  -569,  -569,  -569,  -569,   520,   300,
     247,  -569,  -569,   500,   247,  -569,  -569,   247,  -569,  -569,
    -569,   293,  -569,  -569,   -53,   219,   412,   523,   271,  -569,
     525,  -569,   497,  -569,   565,   -53,   530,  -569,   527,   528,
     273,   467,  -569,   529,   459,   247,  -569,  -569,  -569,   -11,
     534,   537,   541,   283,   544,   548,   549,   551,  -569,  -569,
    -569,   552,   553,    14,   -20,   -20,    47,  -569,  -569,  -569,
     164,  -569,    96,   558,   524,   -26,   566,   567,   569,  -569,
    -569,  -569,   550,  -569,  -569,  -569,  -569,  -569,   570,   626,
    -569,  -569,  -569,  -569,  -569,   -26,   572,   -26,  -569,  -569,
    -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,    -4,
      -4,   300,  -569,  -569,   583,  -569,  -569,   554,   285,  -569,
     568,   244,   571,   313,   324,   219,  -569,  -569,  -569,  -569,
     293,  -569,   273,   573,  -569,  -569,  -569,  -569,   576,  -569,
    -569,   577,  -569,  -569,   575,    30,   581,   582,  -569,  -569,
    -569,   308,   -20,  -569,   -20,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,  -569,  -569,  -569,  -569,   294,  -569,  -569,  -569,
     584,  -569,  -569,    -6,   -53,  -569,   273,  -569,  -569,  -569,
    -569,   585,   586,  -569,  -569,  -569,  -569,   672,  -569,   228,
     228,   247,   589,  -569,  -569,  -569,  -569,  -569,  -569,   247,
    -569,  -569,   273,   497,  -569,  -569,  -569,  -569,  -569,  -569,
    -569,   271,   587,   327,  -569,  -569,  -569,   293,  -569,    47,
    -569,   158,   590,   349,  -569,   273,  -569,  -569,  -569,   593,
     588,   594,   601,   602,   324,    56,   247,  -569,  -569,   351,
    -569,   271,  -569,  -569,   387,  -569,   158,  -569,  -569,   596,
    -569,  -569,   611,  -569,  -569,  -569,   607,   273,   308,  -569,
      -6,  -569,  -569,   613,  -569,  -569,  -569,  -569,   618,  -569,
    -569
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     1,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     3,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   278,    21,    23,    22,    24,    70,   173,
      72,     0,    73,     0,    29,    78,    77,    89,     0,     0,
       0,     0,     0,    62,    28,   194,     0,   262,   263,     0,
       0,   354,     0,   105,    90,     0,     0,   171,    81,    79,
       0,   394,   394,     0,     0,     0,     0,    31,     0,     4,
       5,     6,     7,     8,    10,     9,    11,    16,    12,    15,
      13,    14,    17,    18,     0,    19,    20,   279,   282,    71,
      74,    75,     0,    92,    87,     0,    84,    85,     0,    27,
       0,   354,     0,     0,     0,   100,   269,   268,     0,     0,
     354,   131,     0,   169,   170,   178,     0,   172,    91,   394,
     394,     0,    43,   394,   394,     0,    80,    30,   173,   176,
     177,   192,     0,     0,     0,   180,    97,    86,   394,   196,
     101,   174,   175,   384,   359,   361,   360,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   394,   361,   355,
     354,   354,   104,     0,   137,   139,     0,     0,     0,   113,
     115,   143,   135,   136,   354,   132,   133,   141,     0,   179,
      82,   178,    37,   395,     0,    54,   394,    55,    45,     0,
      46,    32,    88,   207,   287,   394,   283,   280,   281,     0,
     130,   129,    76,     0,     0,     0,     0,    93,    94,     0,
       0,   362,     0,   365,     0,     0,   368,     0,     0,   371,
       0,     0,   379,   378,   380,   381,   377,   382,   383,   385,
     374,     0,     0,   386,   391,   390,     0,     0,   102,   103,
     111,   112,   394,   107,     0,     0,   159,   160,   144,   401,
     402,   404,   168,   400,   394,   403,   405,   142,   161,   165,
       0,   157,   158,   394,   150,   154,     0,     0,   106,   134,
     178,    99,    39,     0,    49,   394,   397,     0,     0,     0,
     396,   345,    48,     0,    34,     0,     0,   193,     0,     0,
       0,   296,   297,   292,   394,   293,   325,   288,   182,    98,
      97,    96,     0,     0,     0,   394,    65,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,     0,     0,     0,   251,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,   197,   195,     0,   250,
       0,     0,     0,     0,   366,   367,   369,   370,   372,   373,
     375,   376,   396,   358,   387,     0,   148,   149,     0,   138,
     147,   140,     0,   409,   408,     0,   166,     0,     0,     0,
     120,   114,   117,   121,   116,    83,   396,    40,     0,     0,
     398,   394,    53,    56,     0,     0,     0,     0,   346,     0,
      42,   396,    25,    26,    35,   396,   208,     0,   394,   285,
     294,   295,     0,   354,     0,     0,    95,    69,    67,    68,
       0,   200,     0,   223,   236,   237,     0,   222,   258,   213,
     212,   215,   216,   218,   260,     0,     0,     0,     0,     0,
       0,     0,     0,   235,   234,   254,     0,     0,   240,   252,
       0,   221,     0,   256,   255,     0,   247,   394,   248,     0,
     270,   271,     0,   217,   199,   198,   389,   388,     0,     0,
     396,   109,   146,     0,   396,   163,   167,   396,   152,   155,
     156,   394,   119,   122,   126,     0,     0,     0,     0,    50,
       0,   399,    49,    44,     0,     0,     0,   347,     0,     0,
       0,     0,   206,     0,     0,   396,   290,   274,   350,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   351,   352,
     353,     0,     0,     0,   345,   345,     0,   329,   330,   308,
     326,   327,     0,     0,     0,     0,     0,     0,     0,   183,
     181,   190,     0,    64,    66,   224,   259,   214,     0,   260,
     241,   229,   226,   227,   230,     0,     0,     0,   364,   363,
     233,   264,   265,   266,   267,   225,   239,   238,   253,     0,
       0,     0,   257,   245,     0,   356,   357,     0,     0,   145,
       0,     0,     0,     0,     0,     0,   127,   118,    38,    41,
     394,    51,     0,     0,   348,    47,    33,    36,     0,   209,
     205,     0,   284,   286,     0,     0,     0,     0,   336,   337,
     338,     0,   345,   300,   345,   342,   392,   343,   393,   344,
     331,   332,   340,   339,   298,   299,   396,   310,   328,   321,
       0,   407,   406,     0,   320,   312,     0,   333,   185,   189,
     186,     0,     0,   184,   261,   242,   228,   201,   231,   243,
     244,   396,     0,   108,   110,   162,   164,   151,   153,   396,
     124,   128,     0,    49,   349,   211,   210,   289,   291,   335,
     334,     0,     0,   396,   305,   307,   341,   394,   309,     0,
     314,     0,     0,   396,   318,     0,   322,   187,   188,     0,
     203,     0,     0,     0,     0,    60,   396,    58,    52,   396,
     301,     0,   398,   311,   396,   313,     0,   323,   202,     0,
     232,   249,     0,   123,   125,    61,     0,     0,   303,   306,
     316,   319,   204,   272,    57,    59,   304,   317,     0,   246,
     273
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -569,  -569,     8,  -180,  -309,   -94,    -5,  -569,  -569,  -569,
    -569,  -569,  -569,  -569,  -569,  -290,  -569,  -569,  -569,  -569,
    -488,   431,  -569,  -569,   460,  -569,    28,  -569,  -569,  -569,
     337,  -569,  -569,  -569,  -569,   418,   759,   331,  -569,  -569,
    -569,  -569,  -374,  -569,  -569,  -569,  -569,   470,  -569,   263,
    -569,  -568,  -159,  -569,  -569,   578,  -569,  -569,   510,  -343,
    -569,  -569,  -382,  -569,  -569,  -569,  -569,  -371,  -244,   302,
    -569,     4,   -15,  -569,  -162,  -569,  -569,  -569,  -569,   547,
    -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -296,
     223,   -14,  -569,  -569,  -569,  -569,  -569,  -569,  -569,  -569,
    -569,  -569,  -293,  -569,  -569,  -410,  -569,    50,   109,  -515,
    -569,  -569,  -520,    65,   108,  -529,  -569,  -569,  -569,   257,
    -447,  -569,  -121,   221,  -402,   622,  -569,  -127,  -569,  -569,
    -569,   -91,  -202,  -189,  -569,  -476
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,   423,    58,   654,    75,   368,    35,    36,    37,
     315,   425,    38,   303,   406,   309,    39,   219,    40,   313,
     409,   310,    41,   216,   217,   716,   717,    42,   128,   335,
     336,    43,    44,   166,   237,   238,   369,    46,    47,   141,
     201,   490,   273,   202,   296,   203,   297,   401,   402,   502,
     679,   503,   504,   204,   205,   206,   274,   275,   389,   390,
     207,   497,   294,   295,   278,   287,   494,   288,   289,   146,
     148,   325,   311,   161,   210,    48,   233,   435,   562,    49,
      50,   223,    51,   130,   240,   710,   730,   317,   521,   371,
     570,    82,   585,   140,   482,   749,    52,    53,   118,   229,
     163,   428,   226,   326,   525,   327,   547,   692,   693,   694,
     548,   646,   549,   702,   703,   704,   433,   434,   550,   551,
     420,   552,   135,   382,   188,   242,   580,   383,   265,   637,
     639,   151,   416,   505,   656,   395
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,   152,    83,    65,   157,   232,   424,   189,   290,    60,
     170,   491,    57,   407,   308,   498,    89,    73,   633,   192,
     427,   495,   526,   655,   611,   429,   647,   554,   605,    61,
     442,   463,   553,   319,   304,   555,   680,   332,   234,   613,
     235,   556,   642,   557,   558,   492,   396,   319,   399,   301,
     528,   578,   386,   333,   334,    15,   649,   320,   212,   213,
     321,   322,   220,   221,    69,    70,   119,   121,  -324,   268,
     269,   320,    76,    85,   321,   322,   417,   239,   143,   144,
     466,   143,   144,   298,   568,   372,   214,    54,   444,   393,
     626,   156,   581,   582,   583,   445,   266,   644,   645,   160,
     332,   394,   467,    59,  -324,   512,   569,   400,    55,    56,
      77,    78,   584,   387,    63,   323,   333,   334,   159,   388,
      64,    79,    80,   418,   419,   307,   514,   224,   215,   323,
     373,   225,    91,   651,   318,   627,    64,    68,   405,   430,
     422,    56,    74,   652,   701,    66,   734,   593,   553,    67,
     599,   496,   538,   539,   540,    87,   145,    71,   649,    84,
      59,   236,   563,   449,   450,   464,  -396,   528,    79,    80,
      62,   443,    95,   437,   559,    64,    59,   560,   705,   723,
     489,   385,    88,   448,   256,   695,    96,   696,    90,    72,
      59,    77,    78,   392,   324,   718,    92,   741,    86,    93,
     650,    94,   397,   290,   508,   305,   739,    97,   136,   137,
     243,   617,   306,    98,   410,   688,   244,   245,   609,   415,
     649,   678,    57,   520,   674,   621,   524,    99,   516,   329,
     676,   623,   100,   432,   101,   651,   478,   102,   252,   253,
     254,   255,   422,    56,   440,   652,   653,   138,   103,   139,
     104,   451,   174,   529,   176,   105,   530,   531,   532,   533,
     106,   534,   126,   127,   535,   536,   537,    59,   107,   538,
     539,   540,   246,   114,   541,   542,   158,    80,   247,   248,
     543,   403,   403,   455,   108,   456,   457,   458,   598,   459,
     460,   488,   601,   109,   461,   603,   110,   651,   111,   544,
     545,   227,   228,   683,   422,    56,   117,   652,   279,   280,
     281,   112,   527,   113,   546,   507,   282,   173,   283,   284,
     511,   115,  -396,   625,   305,   285,   286,    57,   270,   271,
     518,   306,   272,   249,   519,   116,   462,   523,   439,   250,
     251,    56,   174,   175,   176,   120,   606,   706,   122,   468,
     452,    57,    57,   125,   260,   474,   123,   476,   124,   469,
     261,   262,   596,   173,   -63,   230,   231,   177,   178,   179,
     180,    77,    78,   715,   129,   181,   182,   183,   184,   185,
     186,   276,   277,   279,   280,   281,   591,   131,   174,   175,
     176,   282,   134,   283,   132,   305,   727,   142,  -394,   597,
     285,   286,   306,   600,   187,   133,   602,   291,   292,   147,
     604,   293,   290,   177,   178,   179,   180,    79,    80,   422,
      56,   181,   182,   183,   184,   185,   186,   149,   715,    79,
      80,   270,   271,   631,   624,   193,   194,   195,   196,   197,
     198,   150,   697,   155,   699,   698,   681,   480,   481,   306,
     571,   572,   573,   574,    79,    80,   579,   567,   691,   291,
     292,   586,   587,   279,   280,   281,   499,   500,   618,   489,
     230,   231,   338,   283,   592,   697,   153,   714,  -302,   162,
     285,   286,   306,   339,   154,   199,   200,   340,   341,   576,
     577,   721,   164,   342,   165,   669,   670,   697,   167,   697,
    -315,   726,   738,   168,   306,   169,   306,   343,   344,   345,
     346,   347,   348,   349,   737,   350,   171,   721,   632,   682,
     143,   144,   726,   589,   590,   172,   351,   352,   353,   190,
     354,   355,   356,   357,   358,   697,   191,   208,   740,   359,
     360,   361,   306,   209,   211,   362,   218,   643,   241,   222,
     659,   279,   280,   281,   257,   258,   259,   263,   230,   231,
     264,   283,   501,   300,   302,   279,   280,   281,   285,   286,
     666,   312,   668,   515,   314,   283,   330,   316,   328,   363,
     711,   331,   285,   286,   364,   374,   375,   376,   713,   377,
     378,   379,   337,   380,   398,   381,   338,   365,   282,   384,
     408,   412,   411,   214,   414,   224,   722,   339,   431,   234,
     438,   340,   341,    64,   446,   619,   632,   342,   620,  -191,
     441,   447,   470,   453,   454,   736,   465,   471,   472,   473,
     479,   343,   344,   345,   346,   347,   348,   349,   475,   350,
     483,   484,   486,   485,   487,   506,   387,   510,   575,   509,
     351,   352,   353,   493,   354,   355,   356,   357,   358,  -395,
     513,   517,   522,   359,   360,   361,   565,   566,   588,   362,
     612,   595,   658,   568,   608,   610,   632,   614,   615,   616,
     622,   628,     2,     3,   629,     4,     5,     6,   630,     7,
     634,     8,     9,    10,   635,   636,    11,   638,   663,   640,
     641,   735,    12,   363,   657,   673,   632,    13,   364,    14,
    -191,    15,   660,   661,    16,   662,   672,   664,   667,   675,
     684,   365,   677,   632,   685,   686,   687,   689,   690,   709,
     700,   707,   708,   729,    17,   338,   712,    64,   720,   366,
     728,   725,   367,   742,   421,   731,   339,   732,   436,    18,
     340,   341,    19,   733,    20,    21,   342,   743,   744,   748,
      45,    22,    23,    24,   750,   745,   561,   404,   413,   607,
     343,   344,   345,   346,   347,   348,   349,   564,   350,    25,
      26,    27,    28,   299,   594,   391,    29,   370,   746,   351,
     352,   353,   665,   354,   355,   356,   357,   358,    30,    31,
     719,     0,   359,   360,   361,   747,   173,   648,   362,   724,
     267,    32,   671,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
      34,   174,   175,   176,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,     0,     0,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   177,   178,   179,   180,
     365,     0,     0,     0,   181,   182,   183,   184,   185,   186,
       0,     0,     0,     0,     0,     0,    64,     0,   426,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   477
};

static const yytype_int16 yycheck[] =
{
      15,    92,    16,     8,    98,   164,   315,   134,   197,     5,
     131,   385,     4,   303,   216,   397,    21,    13,   533,   140,
     316,   392,   432,   552,   512,   318,   546,     1,   504,     6,
       6,    12,   434,     3,   214,     9,   604,    26,     9,   515,
      11,    15,    28,    17,    18,   388,   290,     3,    26,   211,
       3,    61,    85,    42,    43,    29,    62,    27,   149,   150,
      30,    31,   153,   154,    21,    22,    58,    63,   112,   190,
     191,    27,    97,    21,    30,    31,    96,   168,    68,    69,
      40,    68,    69,   204,    47,   101,   109,   148,    12,   142,
     101,    96,    12,    13,    14,    19,   187,   544,   545,   114,
      26,   154,    62,   146,   148,   414,    69,    85,   146,   147,
     135,   136,    32,   146,     8,    85,    42,    43,   114,   152,
     146,   146,   147,   143,   144,   216,   416,   146,   151,    85,
     146,   150,   150,   139,   225,   146,   146,   146,   300,   319,
     146,   147,   146,   149,   150,   147,   714,   134,   550,   147,
     493,   395,   105,   106,   107,   146,   146,   114,    62,   147,
     146,   166,   151,   343,   344,   146,   109,     3,   146,   147,
     147,   147,   137,   332,   148,   146,   146,   151,   654,   699,
     382,   272,   146,   342,   180,   632,   104,   634,   146,   146,
     146,   135,   136,   284,   150,   683,   150,   726,   146,   146,
     104,   146,   293,   392,   406,   148,   721,   146,    86,    87,
     147,   520,   155,   149,   305,   625,   153,   154,   508,   310,
      62,   603,   214,   425,   598,   521,   428,   148,   417,   234,
     601,   524,   148,   324,   148,   139,   363,   148,   117,   118,
     119,   120,   146,   147,   335,   149,   150,   125,   148,   127,
     148,   345,    88,    89,    90,   148,    92,    93,    94,    95,
     148,    97,    22,    23,   100,   101,   102,   146,   148,   105,
     106,   107,   147,    28,   110,   111,   146,   147,   153,   154,
     116,   296,   297,    47,   148,    49,    50,    51,   490,    53,
      54,   382,   494,   148,    58,   497,   148,   139,   148,   135,
     136,    83,    84,   612,   146,   147,    82,   149,   139,   140,
     141,   148,   433,   148,   150,   406,   147,    63,   149,   150,
     411,   148,   146,   525,   148,   156,   157,   319,   146,   147,
     421,   155,   150,   147,   425,   148,   350,   428,   334,   153,
     154,   147,    88,    89,    90,   147,   505,   656,     8,   354,
     346,   343,   344,    24,   147,   360,   146,   362,   146,   355,
     153,   154,   489,    63,   150,   146,   147,   113,   114,   115,
     116,   135,   136,   682,   146,   121,   122,   123,   124,   125,
     126,   146,   147,   139,   140,   141,   477,   146,    88,    89,
      90,   147,   112,   149,   152,   148,   705,   146,   151,   490,
     156,   157,   155,   494,   150,   152,   497,   146,   147,    71,
     501,   150,   601,   113,   114,   115,   116,   146,   147,   146,
     147,   121,   122,   123,   124,   125,   126,   150,   737,   146,
     147,   146,   147,   150,   525,    33,    34,    35,    36,    37,
      38,   148,   148,   138,   646,   151,   605,   131,   132,   155,
     455,   456,   457,   458,   146,   147,   461,   449,   150,   146,
     147,   466,   467,   139,   140,   141,   146,   147,     1,   671,
     146,   147,     5,   149,   479,   148,   150,   679,   151,    21,
     156,   157,   155,    16,   150,    83,    84,    20,    21,    55,
      56,   693,    26,    26,   146,   589,   590,   148,   146,   148,
     151,   703,   151,   150,   155,   150,   155,    40,    41,    42,
      43,    44,    45,    46,   716,    48,   147,   719,   533,   610,
      68,    69,   724,    76,    77,   147,    59,    60,    61,   146,
      63,    64,    65,    66,    67,   148,   147,   146,   151,    72,
      73,    74,   155,   147,   146,    78,   151,   543,    91,   146,
     555,   139,   140,   141,   147,   147,   146,   146,   146,   147,
     146,   149,   150,   146,   151,   139,   140,   141,   156,   157,
     575,   151,   577,   147,   151,   149,   147,   150,   150,   112,
     671,    22,   156,   157,   117,   147,   147,   147,   679,   147,
     147,   147,     1,   147,    39,   147,     5,   130,   147,   146,
     103,   151,   148,   109,   105,   146,   697,    16,   146,     9,
     146,    20,    21,   146,    22,   148,   631,    26,   151,    28,
     148,   146,     8,   147,   147,   716,   146,   146,   146,   146,
     104,    40,    41,    42,    43,    44,    45,    46,    75,    48,
      43,   148,   146,   148,   146,    26,   146,   108,    50,   147,
      59,    60,    61,   152,    63,    64,    65,    66,    67,   151,
     151,   147,   151,    72,    73,    74,   147,   146,   146,    78,
     105,   151,   148,    47,   151,   150,   691,   147,   151,   151,
     151,   147,     0,     1,   147,     3,     4,     5,   147,     7,
     146,     9,    10,    11,   146,   146,    14,   146,   148,   147,
     147,   715,    20,   112,   146,   151,   721,    25,   117,    27,
      28,    29,   146,   146,    32,   146,   133,   147,   146,   151,
     147,   130,   151,   738,   148,   148,   151,   146,   146,    57,
     146,   146,   146,   145,    52,     5,   147,   146,   151,   148,
     147,   151,   151,   147,   313,   151,    16,   146,   330,    67,
      20,    21,    70,   151,    72,    73,    26,   146,   151,   146,
       1,    79,    80,    81,   146,   737,   435,   297,   308,   506,
      40,    41,    42,    43,    44,    45,    46,   440,    48,    97,
      98,    99,   100,   205,   482,   275,   104,   240,   738,    59,
      60,    61,   569,    63,    64,    65,    66,    67,   116,   117,
     691,    -1,    72,    73,    74,   740,    63,   550,    78,   701,
     188,   129,   591,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   146,    -1,
     148,    88,    89,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   113,   114,   115,   116,
     130,    -1,    -1,    -1,   121,   122,   123,   124,   125,   126,
      -1,    -1,    -1,    -1,    -1,    -1,   146,    -1,   148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   159,     0,     1,     3,     4,     5,     7,     9,    10,
      11,    14,    20,    25,    27,    29,    32,    52,    67,    70,
      72,    73,    79,    80,    81,    97,    98,    99,   100,   104,
     116,   117,   129,   146,   148,   165,   166,   167,   170,   174,
     176,   180,   185,   189,   190,   194,   195,   196,   233,   237,
     238,   240,   254,   255,   148,   146,   147,   160,   161,   146,
     229,     6,   147,     8,   146,   164,   147,   147,   146,    21,
      22,   114,   146,   229,   146,   163,    97,   135,   136,   146,
     147,   230,   249,   249,   147,    21,   146,   146,   146,   164,
     146,   150,   150,   146,   146,   137,   104,   146,   149,   148,
     148,   148,   148,   148,   148,   148,   148,   148,   148,   148,
     148,   148,   148,   148,    28,   148,   148,    82,   256,   160,
     147,   229,     8,   146,   146,    24,    22,    23,   186,   146,
     241,   146,   152,   152,   112,   280,    86,    87,   125,   127,
     251,   197,   146,    68,    69,   146,   227,    71,   228,   150,
     148,   289,   289,   150,   150,   138,   164,   163,   146,   229,
     230,   231,    21,   258,    26,   146,   191,   146,   150,   150,
     280,   147,   147,    63,    88,    89,    90,   113,   114,   115,
     116,   121,   122,   123,   124,   125,   126,   150,   282,   285,
     146,   147,   280,    33,    34,    35,    36,    37,    38,    83,
      84,   198,   201,   203,   211,   212,   213,   218,   146,   147,
     232,   146,   289,   289,   109,   151,   181,   182,   151,   175,
     289,   289,   146,   239,   146,   150,   260,    83,    84,   257,
     146,   147,   210,   234,     9,    11,   164,   192,   193,   289,
     242,    91,   283,   147,   153,   154,   147,   153,   154,   147,
     153,   154,   117,   118,   119,   120,   229,   147,   147,   146,
     147,   153,   154,   146,   146,   286,   289,   283,   280,   280,
     146,   147,   150,   200,   214,   215,   146,   147,   222,   139,
     140,   141,   147,   149,   150,   156,   157,   223,   225,   226,
     291,   146,   147,   150,   220,   221,   202,   204,   280,   213,
     146,   232,   151,   171,   161,   148,   155,   289,   290,   173,
     179,   230,   151,   177,   151,   168,   150,   245,   289,     3,
      27,    30,    31,    85,   150,   229,   261,   263,   150,   164,
     147,    22,    26,    42,    43,   187,   188,     1,     5,    16,
      20,    21,    26,    40,    41,    42,    43,    44,    45,    46,
      48,    59,    60,    61,    63,    64,    65,    66,    67,    72,
      73,    74,    78,   112,   117,   130,   148,   151,   164,   194,
     237,   247,   101,   146,   147,   147,   147,   147,   147,   147,
     147,   147,   281,   285,   146,   289,    85,   146,   152,   216,
     217,   216,   289,   142,   154,   293,   226,   289,    39,    26,
      85,   205,   206,   230,   205,   232,   172,   173,   103,   178,
     289,   148,   151,   182,   105,   289,   290,    96,   143,   144,
     278,   179,   146,   160,   162,   169,   148,   247,   259,   260,
     161,   146,   289,   274,   275,   235,   193,   210,   146,   229,
     289,   148,     6,   147,    12,    19,    22,   146,   210,   161,
     161,   163,   229,   147,   147,    47,    49,    50,    51,    53,
      54,    58,   249,    12,   146,   146,    40,    62,   164,   229,
       8,   146,   146,   146,   164,    75,   164,   150,   285,   104,
     131,   132,   252,    43,   148,   148,   146,   146,   289,   290,
     199,   200,   217,   152,   224,   225,   226,   219,   220,   146,
     147,   150,   207,   209,   210,   291,    26,   289,   290,   147,
     108,   289,   162,   151,   173,   147,   291,   147,   289,   289,
     290,   246,   151,   289,   290,   262,   263,   280,     3,    89,
      92,    93,    94,    95,    97,   100,   101,   102,   105,   106,
     107,   110,   111,   116,   135,   136,   150,   264,   268,   270,
     276,   277,   279,   282,     1,     9,    15,    17,    18,   148,
     151,   195,   236,   151,   188,   147,   146,   160,    47,    69,
     248,   164,   164,   164,   164,    50,    55,    56,    61,   164,
     284,    12,    13,    14,    32,   250,   164,   164,   146,    76,
      77,   289,   164,   134,   227,   151,   285,   289,   290,   217,
     289,   290,   289,   290,   289,   293,   210,   207,   151,   173,
     150,   178,   105,   293,   147,   151,   151,   162,     1,   148,
     151,   247,   151,   260,   289,   290,   101,   146,   147,   147,
     147,   150,   230,   267,   146,   146,   146,   287,   146,   288,
     147,   147,    28,   229,   278,   278,   269,   270,   277,    62,
     104,   139,   149,   150,   162,   273,   292,   146,   148,   164,
     146,   146,   146,   148,   147,   248,   164,   146,   164,   163,
     163,   281,   133,   151,   200,   151,   225,   151,   220,   208,
     209,   210,   289,   162,   147,   148,   148,   151,   263,   146,
     146,   150,   265,   266,   267,   278,   278,   148,   151,   290,
     146,   150,   271,   272,   273,   293,   162,   146,   146,    57,
     243,   289,   147,   289,   290,   162,   183,   184,   178,   266,
     151,   290,   289,   270,   272,   151,   290,   162,   147,   145,
     244,   151,   146,   151,   209,   249,   289,   290,   151,   267,
     151,   273,   147,   146,   151,   184,   265,   271,   146,   253,
     146
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   158,   159,   159,   159,   159,   159,   159,   159,   159,
     159,   159,   159,   159,   159,   159,   159,   159,   159,   159,
     159,   159,   160,   161,   161,   162,   162,   163,   163,   164,
     165,   166,   168,   167,   167,   169,   169,   171,   170,   170,
     172,   172,   173,   175,   174,   174,   177,   176,   176,   178,
     178,   179,   179,   180,   180,   181,   181,   182,   183,   183,
     184,   184,   185,   186,   185,   187,   187,   188,   188,   188,
     189,   189,   189,   189,   189,   189,   189,   189,   189,   189,
     189,   189,   189,   189,   189,   189,   189,   189,   189,   189,
     189,   189,   191,   190,   192,   192,   192,   193,   193,   194,
     195,   195,   195,   195,   195,   197,   196,   198,   198,   199,
     199,   200,   200,   202,   201,   204,   203,   205,   205,   205,
     206,   206,   207,   207,   208,   208,   209,   209,   209,   210,
     210,   211,   211,   212,   212,   213,   213,   214,   213,   215,
     213,   213,   213,   213,   213,   216,   216,   216,   216,   217,
     218,   218,   219,   219,   220,   220,   220,   221,   221,   222,
     222,   223,   223,   224,   224,   225,   225,   225,   226,   227,
     227,   228,   228,   229,   230,   230,   231,   231,   232,   232,
     234,   233,   235,   235,   235,   235,   236,   236,   236,   236,
     236,   238,   239,   237,   241,   240,   242,   242,   242,   242,
     242,   243,   243,   244,   244,   245,   245,   245,   246,   246,
     246,   246,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     247,   247,   247,   247,   247,   247,   247,   247,   247,   247,
     248,   248,   249,   249,   250,   250,   250,   250,   251,   251,
     252,   252,   253,   253,   254,   255,   255,   255,   256,   256,
     257,   257,   258,   258,   258,   259,   259,   260,   261,   261,
     262,   262,   263,   263,   263,   263,   263,   263,   264,   264,
     264,   264,   265,   265,   265,   266,   266,   267,   268,   268,
     269,   269,   270,   270,   270,   271,   271,   271,   272,   272,
     273,   273,   273,   273,   274,   275,   274,   276,   276,   277,
     277,   277,   277,   277,   277,   277,   277,   277,   277,   277,
     277,   277,   277,   277,   277,   278,   278,   278,   278,   278,
     279,   279,   279,   279,   280,   280,   280,   281,   281,   282,
     282,   283,   283,   284,   284,   285,   285,   285,   285,   285,
     285,   285,   285,   285,   285,   285,   285,   285,   285,   285,
     285,   285,   285,   285,   285,   285,   285,   285,   285,   285,
     285,   286,   287,   288,   289,   289,   290,   290,   290,   290,
     291,   291,   291,   291,   291,   291,   292,   292,   293,   293
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     2,     1,     1,
       3,     2,     0,     8,     5,     1,     3,     0,     8,     5,
       1,     3,     2,     0,     7,     4,     0,     8,     5,     0,
       2,     4,     6,     6,     4,     1,     3,     9,     1,     3,
       1,     2,     2,     0,     8,     1,     3,     2,     2,     2,
       2,     3,     2,     2,     3,     3,     5,     2,     2,     2,
       3,     2,     4,     6,     3,     3,     4,     3,     4,     2,
       2,     3,     0,     5,     1,     3,     2,     0,     2,     5,
       3,     4,     5,     5,     4,     0,     5,     2,     6,     1,
       3,     1,     1,     0,     3,     0,     3,     1,     3,     2,
       1,     1,     1,     5,     1,     3,     1,     2,     3,     1,
       1,     0,     1,     1,     2,     1,     1,     0,     3,     0,
       3,     1,     2,     1,     2,     3,     2,     1,     1,     1,
       2,     6,     1,     3,     1,     3,     3,     1,     1,     1,
       1,     1,     5,     1,     3,     1,     2,     3,     1,     1,
       1,     0,     1,     1,     3,     3,     1,     1,     0,     1,
       0,     8,     0,     2,     3,     3,     2,     3,     3,     2,
       1,     0,     0,     5,     0,     6,     0,     2,     3,     3,
       3,     0,     2,     0,     2,     4,     3,     0,     0,     2,
       3,     3,     2,     2,     3,     2,     2,     2,     2,     1,
       1,     2,     2,     2,     3,     3,     3,     3,     4,     3,
       3,     4,     6,     3,     2,     2,     2,     2,     3,     3,
       2,     3,     4,     4,     4,     3,     8,     2,     2,     6,
       1,     1,     2,     3,     2,     2,     2,     3,     2,     3,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     7,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     6,     1,     3,     1,     1,     5,
       1,     3,     1,     1,     2,     2,     1,     1,     2,     2,
       2,     4,     1,     3,     4,     1,     3,     2,     1,     3,
       1,     3,     2,     4,     3,     1,     3,     4,     1,     3,
       1,     1,     2,     3,     0,     0,     2,     1,     2,     1,
       1,     2,     2,     2,     3,     3,     2,     2,     2,     2,
       2,     3,     2,     2,     2,     0,     1,     2,     3,     4,
       1,     1,     1,     1,     0,     2,     6,     3,     1,     1,
       1,     0,     1,     1,     1,     2,     3,     3,     2,     3,
       3,     2,     3,     3,     2,     3,     3,     2,     2,     2,
       2,     2,     2,     2,     1,     2,     2,     3,     4,     4,
       2,     1,     1,     1,     0,     2,     0,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 21: /* grammar: grammar error '\n'  */
#line 318 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { file->errors++; }
#line 2510 "parse.c"
    break;

  case 22: /* asnumber: NUMBER  */
#line 321 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			/*
			 * According to iana 65535 and 4294967295 are reserved
			 * but enforcing this is not duty of the parser.
			 */
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("AS too big: max %u", UINT_MAX);
				YYERROR;
			}
		}
#line 2525 "parse.c"
    break;

  case 23: /* as4number: STRING  */
#line 332 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			const char	*errstr;
			char		*dot;
			uint32_t	 uvalh = 0, uval;

			if ((dot = strchr((yyvsp[0].v.string),'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum((yyvsp[0].v.string), 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", (yyvsp[0].v.string), errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				free((yyvsp[0].v.string));
			} else {
				yyerror("AS %s is bad", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (uvalh == 0 && (uval == AS_TRANS || uval == 0)) {
				yyerror("AS %u is reserved and may not be used",
				    uval);
				YYERROR;
			}
			(yyval.v.number) = uval | (uvalh << 16);
		}
#line 2562 "parse.c"
    break;

  case 24: /* as4number: asnumber  */
#line 364 "../../../openbgpd-portable/src/bgpd/parse.y"
                           {
			if ((yyvsp[0].v.number) == AS_TRANS || (yyvsp[0].v.number) == 0) {
				yyerror("AS %u is reserved and may not be used",
				    (uint32_t)(yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 2575 "parse.c"
    break;

  case 25: /* as4number_any: STRING  */
#line 374 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			const char	*errstr;
			char		*dot;
			uint32_t	 uvalh = 0, uval;

			if ((dot = strchr((yyvsp[0].v.string),'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum((yyvsp[0].v.string), 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", (yyvsp[0].v.string), errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				free((yyvsp[0].v.string));
			} else {
				yyerror("AS %s is bad", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			(yyval.v.number) = uval | (uvalh << 16);
		}
#line 2607 "parse.c"
    break;

  case 26: /* as4number_any: asnumber  */
#line 401 "../../../openbgpd-portable/src/bgpd/parse.y"
                           {
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 2615 "parse.c"
    break;

  case 27: /* string: string STRING  */
#line 406 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (asprintf(&(yyval.v.string), "%s %s", (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1)
				fatal("string: asprintf");
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.string));
		}
#line 2626 "parse.c"
    break;

  case 29: /* yesno: STRING  */
#line 415 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[0].v.string), "yes"))
				(yyval.v.number) = 1;
			else if (!strcmp((yyvsp[0].v.string), "no"))
				(yyval.v.number) = 0;
			else {
				yyerror("syntax error, "
				    "either yes or no expected");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2644 "parse.c"
    break;

  case 30: /* varset: STRING '=' string  */
#line 430 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			char *s = (yyvsp[-2].v.string);
			if (strlen((yyvsp[-2].v.string)) >= MACRO_NAME_LEN) {
				yyerror("macro name to long, max %d characters",
				    MACRO_NAME_LEN - 1);
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			do {
				if (isalnum((unsigned char)*s) || *s == '_')
					continue;
				yyerror("macro name can only contain "
					    "alphanumerics and '_'");
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			} while (*++s);

			if (cmd_opts & BGPD_OPT_VERBOSE)
				printf("%s = \"%s\"\n", (yyvsp[-2].v.string), (yyvsp[0].v.string));
			if (symset((yyvsp[-2].v.string), (yyvsp[0].v.string), 0) == -1)
				fatal("cannot store variable");
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 2675 "parse.c"
    break;

  case 31: /* include: INCLUDE STRING  */
#line 458 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct file	*nfile;

			if ((nfile = pushfile((yyvsp[0].v.string), 1)) == NULL) {
				yyerror("failed to include file %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			file = nfile;
			lungetc('\n');
		}
#line 2693 "parse.c"
    break;

  case 32: /* $@1: %empty  */
#line 473 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (strlen((yyvsp[-2].v.string)) >= SET_NAME_LEN) {
				yyerror("as-set name %s too long", (yyvsp[-2].v.string));
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			if (new_as_set((yyvsp[-2].v.string)) != 0) {
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
		}
#line 2710 "parse.c"
    break;

  case 33: /* as_set: ASSET STRING '{' optnl $@1 as_set_l optnl '}'  */
#line 484 "../../../openbgpd-portable/src/bgpd/parse.y"
                                     {
			done_as_set();
		}
#line 2718 "parse.c"
    break;

  case 34: /* as_set: ASSET STRING '{' optnl '}'  */
#line 487 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (new_as_set((yyvsp[-3].v.string)) != 0) {
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
		}
#line 2730 "parse.c"
    break;

  case 35: /* as_set_l: as4number_any  */
#line 495 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { add_as_set((yyvsp[0].v.number)); }
#line 2736 "parse.c"
    break;

  case 36: /* as_set_l: as_set_l comma as4number_any  */
#line 496 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { add_as_set((yyvsp[0].v.number)); }
#line 2742 "parse.c"
    break;

  case 37: /* $@2: %empty  */
#line 498 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((curpset = new_prefix_set((yyvsp[-2].v.string), 0)) == NULL) {
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
		}
#line 2754 "parse.c"
    break;

  case 38: /* prefixset: PREFIXSET STRING '{' optnl $@2 prefixset_l optnl '}'  */
#line 504 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
#line 2763 "parse.c"
    break;

  case 39: /* prefixset: PREFIXSET STRING '{' optnl '}'  */
#line 508 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((curpset = new_prefix_set((yyvsp[-3].v.string), 0)) == NULL) {
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
#line 2777 "parse.c"
    break;

  case 40: /* prefixset_l: prefixset_item  */
#line 518 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct prefixset_item	*psi;
			if ((yyvsp[0].v.prefixset_item)->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, (yyvsp[0].v.prefixset_item));
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&(yyvsp[0].v.prefixset_item)->p.addr), (yyvsp[0].v.prefixset_item)->p.len);
				free((yyvsp[0].v.prefixset_item));
			}
		}
#line 2796 "parse.c"
    break;

  case 41: /* prefixset_l: prefixset_l comma prefixset_item  */
#line 532 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct prefixset_item	*psi;
			if ((yyvsp[0].v.prefixset_item)->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, (yyvsp[0].v.prefixset_item));
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&(yyvsp[0].v.prefixset_item)->p.addr), (yyvsp[0].v.prefixset_item)->p.len);
				free((yyvsp[0].v.prefixset_item));
			}
		}
#line 2815 "parse.c"
    break;

  case 42: /* prefixset_item: prefix prefixlenop  */
#line 548 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.prefixlen).op != OP_NONE && (yyvsp[0].v.prefixlen).op != OP_RANGE) {
				yyerror("unsupported prefixlen operation in "
				    "prefix-set");
				YYERROR;
			}
			if (((yyval.v.prefixset_item) = calloc(1, sizeof(*(yyval.v.prefixset_item)))) == NULL)
				fatal(NULL);
			memcpy(&(yyval.v.prefixset_item)->p.addr, &(yyvsp[-1].v.prefix).prefix, sizeof((yyval.v.prefixset_item)->p.addr));
			(yyval.v.prefixset_item)->p.len = (yyvsp[-1].v.prefix).len;
			if (merge_prefixspec(&(yyval.v.prefixset_item)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.prefixset_item));
				YYERROR;
			}
		}
#line 2835 "parse.c"
    break;

  case 43: /* $@3: %empty  */
#line 565 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curroatree = &conf->roa;
		}
#line 2843 "parse.c"
    break;

  case 44: /* roa_set: ROASET '{' optnl $@3 roa_set_l optnl '}'  */
#line 567 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			curroatree = NULL;
		}
#line 2851 "parse.c"
    break;

  case 46: /* $@4: %empty  */
#line 573 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((curoset = new_prefix_set((yyvsp[-2].v.string), 1)) == NULL) {
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			curroatree = &curoset->roaitems;
			noexpires = 1;
			free((yyvsp[-2].v.string));
		}
#line 2865 "parse.c"
    break;

  case 47: /* origin_set: ORIGINSET STRING '{' optnl $@4 roa_set_l optnl '}'  */
#line 581 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curroatree = NULL;
			noexpires = 0;
		}
#line 2876 "parse.c"
    break;

  case 48: /* origin_set: ORIGINSET STRING '{' optnl '}'  */
#line 587 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			if ((curoset = new_prefix_set((yyvsp[-3].v.string), 1)) == NULL) {
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curroatree = NULL;
		}
#line 2891 "parse.c"
    break;

  case 49: /* expires: %empty  */
#line 599 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			(yyval.v.number) = 0;
		}
#line 2899 "parse.c"
    break;

  case 50: /* expires: EXPIRES NUMBER  */
#line 602 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (noexpires) {
				yyerror("syntax error, expires not allowed");
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 2911 "parse.c"
    break;

  case 51: /* roa_set_l: prefixset_item SOURCEAS as4number_any expires  */
#line 610 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                        {
			if ((yyvsp[-3].v.prefixset_item)->p.len_min != (yyvsp[-3].v.prefixset_item)->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free((yyvsp[-3].v.prefixset_item));
				YYERROR;
			}
			add_roa_set((yyvsp[-3].v.prefixset_item), (yyvsp[-1].v.number), (yyvsp[-3].v.prefixset_item)->p.len_max, (yyvsp[0].v.number));
			free((yyvsp[-3].v.prefixset_item));
		}
#line 2926 "parse.c"
    break;

  case 52: /* roa_set_l: roa_set_l comma prefixset_item SOURCEAS as4number_any expires  */
#line 620 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                                {
			if ((yyvsp[-3].v.prefixset_item)->p.len_min != (yyvsp[-3].v.prefixset_item)->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free((yyvsp[-3].v.prefixset_item));
				YYERROR;
			}
			add_roa_set((yyvsp[-3].v.prefixset_item), (yyvsp[-1].v.number), (yyvsp[-3].v.prefixset_item)->p.len_max, (yyvsp[0].v.number));
			free((yyvsp[-3].v.prefixset_item));
		}
#line 2941 "parse.c"
    break;

  case 57: /* aspa_elm: CUSTOMERAS as4number expires PROVIDERAS '{' optnl aspa_tas_l optnl '}'  */
#line 641 "../../../openbgpd-portable/src/bgpd/parse.y"
                                         {
			int rv;
			struct aspa_tas_l *a, *n;

			rv = merge_aspa_set((yyvsp[-7].v.number), (yyvsp[-2].v.aspa_elm), (yyvsp[-6].v.number));

			for (a = (yyvsp[-2].v.aspa_elm); a != NULL; a = n) {
				n = a->next;
				free(a);
			}

			if (rv == -1)
				YYERROR;
		}
#line 2960 "parse.c"
    break;

  case 58: /* aspa_tas_l: aspa_tas  */
#line 657 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.aspa_elm) = (yyvsp[0].v.aspa_elm); }
#line 2966 "parse.c"
    break;

  case 59: /* aspa_tas_l: aspa_tas_l comma aspa_tas  */
#line 658 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			(yyvsp[0].v.aspa_elm)->next = (yyvsp[-2].v.aspa_elm);
			(yyvsp[0].v.aspa_elm)->num = (yyvsp[-2].v.aspa_elm)->num + 1;
			(yyval.v.aspa_elm) = (yyvsp[0].v.aspa_elm);
		}
#line 2976 "parse.c"
    break;

  case 60: /* aspa_tas: as4number_any  */
#line 665 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (((yyval.v.aspa_elm) = calloc(1, sizeof(*(yyval.v.aspa_elm)))) == NULL)
				fatal(NULL);
			(yyval.v.aspa_elm)->as = (yyvsp[0].v.number);
			(yyval.v.aspa_elm)->num = 1;
		}
#line 2987 "parse.c"
    break;

  case 61: /* aspa_tas: as4number_any af  */
#line 671 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			if (((yyval.v.aspa_elm) = calloc(1, sizeof(*(yyval.v.aspa_elm)))) == NULL)
				fatal(NULL);
			(yyval.v.aspa_elm)->as = (yyvsp[-1].v.number);
			(yyval.v.aspa_elm)->num = 1;
		}
#line 2998 "parse.c"
    break;

  case 62: /* rtr: RTR address  */
#line 679 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			currtr = get_rtr(&(yyvsp[0].v.addr));
			currtr->remote_port = RTR_PORT;
			if (insert_rtr(currtr) == -1) {
				free(currtr);
				YYERROR;
			}
			currtr = NULL;
		}
#line 3012 "parse.c"
    break;

  case 63: /* $@5: %empty  */
#line 688 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			currtr = get_rtr(&(yyvsp[0].v.addr));
			currtr->remote_port = RTR_PORT;
		}
#line 3021 "parse.c"
    break;

  case 64: /* rtr: RTR address $@5 '{' optnl rtropt_l optnl '}'  */
#line 691 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			if (insert_rtr(currtr) == -1) {
				free(currtr);
				YYERROR;
			}
			currtr = NULL;
		}
#line 3033 "parse.c"
    break;

  case 67: /* rtropt: DESCR STRING  */
#line 704 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (strlcpy(currtr->descr, (yyvsp[0].v.string),
			    sizeof(currtr->descr)) >=
			    sizeof(currtr->descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(currtr->descr) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3049 "parse.c"
    break;

  case 68: /* rtropt: LOCALADDR address  */
#line 715 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.addr).aid != currtr->remote_addr.aid) {
				yyerror("Bad address family %s for "
				    "local-addr", aid2str((yyvsp[0].v.addr).aid));
				YYERROR;
			}
			currtr->local_addr = (yyvsp[0].v.addr);
		}
#line 3062 "parse.c"
    break;

  case 69: /* rtropt: PORT port  */
#line 723 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			currtr->remote_port = (yyvsp[0].v.number);
		}
#line 3070 "parse.c"
    break;

  case 70: /* conf_main: AS as4number  */
#line 728 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			conf->as = (yyvsp[0].v.number);
			if ((yyvsp[0].v.number) > USHRT_MAX)
				conf->short_as = AS_TRANS;
			else
				conf->short_as = (yyvsp[0].v.number);
		}
#line 3082 "parse.c"
    break;

  case 71: /* conf_main: AS as4number asnumber  */
#line 735 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			conf->as = (yyvsp[-1].v.number);
			conf->short_as = (yyvsp[0].v.number);
		}
#line 3091 "parse.c"
    break;

  case 72: /* conf_main: ROUTERID address  */
#line 739 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.addr).aid != AID_INET) {
				yyerror("router-id must be an IPv4 address");
				YYERROR;
			}
			conf->bgpid = (yyvsp[0].v.addr).v4.s_addr;
		}
#line 3103 "parse.c"
    break;

  case 73: /* conf_main: HOLDTIME NUMBER  */
#line 746 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->holdtime = (yyvsp[0].v.number);
		}
#line 3116 "parse.c"
    break;

  case 74: /* conf_main: HOLDTIME YMIN NUMBER  */
#line 754 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->min_holdtime = (yyvsp[0].v.number);
		}
#line 3129 "parse.c"
    break;

  case 75: /* conf_main: LISTEN ON address  */
#line 762 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			struct listen_addr	*la;
			struct sockaddr		*sa;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			la->reconf = RECONF_REINIT;
			sa = addr2sa(&(yyvsp[0].v.addr), BGP_PORT, &la->sa_len);
			memcpy(&la->sa, sa, la->sa_len);
			TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
		}
#line 3148 "parse.c"
    break;

  case 76: /* conf_main: LISTEN ON address PORT port  */
#line 776 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct listen_addr	*la;
			struct sockaddr		*sa;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			la->reconf = RECONF_REINIT;
			sa = addr2sa(&(yyvsp[-2].v.addr), (yyvsp[0].v.number), &la->sa_len);
			memcpy(&la->sa, sa, la->sa_len);
			TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
		}
#line 3167 "parse.c"
    break;

  case 77: /* conf_main: FIBPRIORITY NUMBER  */
#line 790 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!kr_check_prio((yyvsp[0].v.number))) {
				yyerror("fib-priority %lld out of range", (yyvsp[0].v.number));
				YYERROR;
			}
			conf->fib_priority = (yyvsp[0].v.number);
		}
#line 3179 "parse.c"
    break;

  case 78: /* conf_main: FIBUPDATE yesno  */
#line 797 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct rde_rib *rr;
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE cannot find the main RIB!");

			if ((yyvsp[0].v.number) == 0)
				rr->flags |= F_RIB_NOFIBSYNC;
			else
				rr->flags &= ~F_RIB_NOFIBSYNC;
		}
#line 3195 "parse.c"
    break;

  case 79: /* conf_main: TRANSPARENT yesno  */
#line 808 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				conf->flags |= BGPD_FLAG_DECISION_TRANS_AS;
			else
				conf->flags &= ~BGPD_FLAG_DECISION_TRANS_AS;
		}
#line 3206 "parse.c"
    break;

  case 80: /* conf_main: REJECT ASSET yesno  */
#line 814 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				conf->flags |= BGPD_FLAG_NO_AS_SET;
			else
				conf->flags &= ~BGPD_FLAG_NO_AS_SET;
		}
#line 3217 "parse.c"
    break;

  case 81: /* conf_main: LOG STRING  */
#line 820 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (!strcmp((yyvsp[0].v.string), "updates"))
				conf->log |= BGPD_LOG_UPDATES;
			else {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3231 "parse.c"
    break;

  case 82: /* conf_main: DUMP STRING STRING optnumber  */
#line 829 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			int action;

			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad timeout");
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!strcmp((yyvsp[-2].v.string), "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp((yyvsp[-2].v.string), "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp((yyvsp[-2].v.string), "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			if (add_mrtconfig(action, (yyvsp[-1].v.string), (yyvsp[0].v.number), NULL, NULL) == -1) {
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
		}
#line 3264 "parse.c"
    break;

  case 83: /* conf_main: DUMP RIB STRING STRING STRING optnumber  */
#line 857 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                        {
			int action;

			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad timeout");
				free((yyvsp[-3].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!strcmp((yyvsp[-2].v.string), "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp((yyvsp[-2].v.string), "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp((yyvsp[-2].v.string), "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free((yyvsp[-3].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			if (add_mrtconfig(action, (yyvsp[-1].v.string), (yyvsp[0].v.number), NULL, (yyvsp[-3].v.string)) == -1) {
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			free((yyvsp[-1].v.string));
		}
#line 3301 "parse.c"
    break;

  case 84: /* conf_main: RDE STRING EVALUATE  */
#line 889 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[-1].v.string), "route-age"))
				conf->flags |= BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
		}
#line 3316 "parse.c"
    break;

  case 85: /* conf_main: RDE STRING IGNORE  */
#line 899 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[-1].v.string), "route-age"))
				conf->flags &= ~BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
		}
#line 3331 "parse.c"
    break;

  case 86: /* conf_main: RDE MED COMPARE STRING  */
#line 909 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[0].v.string), "always"))
				conf->flags |= BGPD_FLAG_DECISION_MED_ALWAYS;
			else if (!strcmp((yyvsp[0].v.string), "strict"))
				conf->flags &= ~BGPD_FLAG_DECISION_MED_ALWAYS;
			else {
				yyerror("rde med compare: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3349 "parse.c"
    break;

  case 87: /* conf_main: RDE EVALUATE STRING  */
#line 922 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			if (!strcmp((yyvsp[0].v.string), "all"))
				conf->flags |= BGPD_FLAG_DECISION_ALL_PATHS;
			else if (!strcmp((yyvsp[0].v.string), "default"))
				conf->flags &= ~BGPD_FLAG_DECISION_ALL_PATHS;
			else {
				yyerror("rde evaluate: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3367 "parse.c"
    break;

  case 88: /* conf_main: NEXTHOP QUALIFY VIA STRING  */
#line 935 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[0].v.string), "bgp"))
				conf->flags |= BGPD_FLAG_NEXTHOP_BGP;
			else if (!strcmp((yyvsp[0].v.string), "default"))
				conf->flags |= BGPD_FLAG_NEXTHOP_DEFAULT;
			else {
				yyerror("nexthop depend on: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3385 "parse.c"
    break;

  case 89: /* conf_main: RTABLE NUMBER  */
#line 948 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			struct rde_rib *rr;
			if ((yyvsp[0].v.number) > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", (yyvsp[0].v.number),
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (!ktable_exists((yyvsp[0].v.number), NULL)) {
				yyerror("rtable id %lld does not exist", (yyvsp[0].v.number));
				YYERROR;
			}
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE cannot find the main RIB!");
			rr->rtableid = (yyvsp[0].v.number);
		}
#line 3406 "parse.c"
    break;

  case 90: /* conf_main: CONNECTRETRY NUMBER  */
#line 964 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			if ((yyvsp[0].v.number) > USHRT_MAX || (yyvsp[0].v.number) < 1) {
				yyerror("invalid connect-retry");
				YYERROR;
			}
			conf->connectretry = (yyvsp[0].v.number);
		}
#line 3418 "parse.c"
    break;

  case 91: /* conf_main: SOCKET STRING restricted  */
#line 971 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if (strlen((yyvsp[-1].v.string)) >=
			    sizeof(((struct sockaddr_un *)0)->sun_path)) {
				yyerror("socket path too long");
				YYERROR;
			}
			if ((yyvsp[0].v.number)) {
				free(conf->rcsock);
				conf->rcsock = (yyvsp[-1].v.string);
			} else {
				free(conf->csock);
				conf->csock = (yyvsp[-1].v.string);
			}
		}
#line 3437 "parse.c"
    break;

  case 92: /* $@6: %empty  */
#line 987 "../../../openbgpd-portable/src/bgpd/parse.y"
                                 {
			if ((currib = add_rib((yyvsp[0].v.string))) == NULL) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3449 "parse.c"
    break;

  case 93: /* rib: RDE RIB STRING $@6 ribopts  */
#line 993 "../../../openbgpd-portable/src/bgpd/parse.y"
                          {
			currib = NULL;
		}
#line 3457 "parse.c"
    break;

  case 95: /* ribopts: RTABLE NUMBER fibupdate  */
#line 998 "../../../openbgpd-portable/src/bgpd/parse.y"
                                          {
			if ((yyvsp[-1].v.number) > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", (yyvsp[-1].v.number),
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (rib_add_fib(currib, (yyvsp[-1].v.number)) == -1)
				YYERROR;
		}
#line 3471 "parse.c"
    break;

  case 96: /* ribopts: yesno EVALUATE  */
#line 1007 "../../../openbgpd-portable/src/bgpd/parse.y"
                                 {
			if ((yyvsp[-1].v.number)) {
				yyerror("bad rde rib definition");
				YYERROR;
			}
			currib->flags |= F_RIB_NOEVALUATE;
		}
#line 3483 "parse.c"
    break;

  case 98: /* fibupdate: FIBUPDATE yesno  */
#line 1017 "../../../openbgpd-portable/src/bgpd/parse.y"
                                  {
			if ((yyvsp[0].v.number) == 0)
				currib->flags |= F_RIB_NOFIBSYNC;
			else
				currib->flags &= ~F_RIB_NOFIBSYNC;
		}
#line 3494 "parse.c"
    break;

  case 99: /* mrtdump: DUMP STRING inout STRING optnumber  */
#line 1025 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			int action;

			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad timeout");
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!strcmp((yyvsp[-3].v.string), "all"))
				action = (yyvsp[-2].v.number) ? MRT_ALL_IN : MRT_ALL_OUT;
			else if (!strcmp((yyvsp[-3].v.string), "updates"))
				action = (yyvsp[-2].v.number) ? MRT_UPDATE_IN : MRT_UPDATE_OUT;
			else {
				yyerror("unknown mrt msg dump type");
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (add_mrtconfig(action, (yyvsp[-1].v.string), (yyvsp[0].v.number), curpeer, NULL) ==
			    -1) {
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			free((yyvsp[-1].v.string));
		}
#line 3527 "parse.c"
    break;

  case 100: /* network: NETWORK prefix filter_set  */
#line 1055 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct network	*n, *m;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			memcpy(&n->net.prefix, &(yyvsp[-1].v.prefix).prefix,
			    sizeof(n->net.prefix));
			n->net.prefixlen = (yyvsp[-1].v.prefix).len;
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));
			TAILQ_FOREACH(m, netconf, entry) {
				if (n->net.type == m->net.type &&
				    n->net.prefixlen == m->net.prefixlen &&
				    prefix_compare(&n->net.prefix,
				    &m->net.prefix, n->net.prefixlen) == 0)
					yyerror("duplicate prefix "
					    "in network statement");
			}

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3553 "parse.c"
    break;

  case 101: /* network: NETWORK PREFIXSET STRING filter_set  */
#line 1076 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct prefixset *ps;
			struct network	*n;
			if ((ps = find_prefixset((yyvsp[-1].v.string), &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			if (ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s has prefixlen operators "
				    "and cannot be used in network statements.",
				    ps->name);
				free((yyvsp[-1].v.string));
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			strlcpy(n->net.psname, ps->name, sizeof(n->net.psname));
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			n->net.type = NETWORK_PREFIXSET;
			TAILQ_INSERT_TAIL(netconf, n, entry);
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.filter_set_head));
		}
#line 3587 "parse.c"
    break;

  case 102: /* network: NETWORK af RTLABEL STRING filter_set  */
#line 1105 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid((yyvsp[-3].v.number), SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown address family");
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			n->net.type = NETWORK_RTLABEL;
			n->net.rtlabel = rtlabel_name2id((yyvsp[-1].v.string));
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3611 "parse.c"
    break;

  case 103: /* network: NETWORK af PRIORITY NUMBER filter_set  */
#line 1124 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct network	*n;
			if (!kr_check_prio((yyvsp[-1].v.number))) {
				yyerror("priority %lld out of range", (yyvsp[-1].v.number));
				YYERROR;
			}

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid((yyvsp[-3].v.number), SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown address family");
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			n->net.type = NETWORK_PRIORITY;
			n->net.priority = (yyvsp[-1].v.number);
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3639 "parse.c"
    break;

  case 104: /* network: NETWORK af nettype filter_set  */
#line 1147 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid((yyvsp[-2].v.number), SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown address family");
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			n->net.type = (yyvsp[-1].v.number) ? NETWORK_STATIC : NETWORK_CONNECTED;
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3662 "parse.c"
    break;

  case 105: /* $@7: %empty  */
#line 1167 "../../../openbgpd-portable/src/bgpd/parse.y"
                              {
			if ((curflow = calloc(1, sizeof(*curflow))) == NULL)
				fatal("new_flowspec");
			curflow->aid = (yyvsp[0].v.number);
		}
#line 3672 "parse.c"
    break;

  case 106: /* flowspec: FLOWSPEC af $@7 flow_rules filter_set  */
#line 1171 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			struct flowspec_config *f;

			f = flow_to_flowspec(curflow);
			if (f == NULL) {
				yyerror("out of memory");
				free((yyvsp[0].v.filter_set_head));
				flow_free(curflow);
				curflow = NULL;
				YYERROR;
			}
			filterset_move((yyvsp[0].v.filter_set_head), &f->attrset);
			free((yyvsp[0].v.filter_set_head));
			flow_free(curflow);
			curflow = NULL;

			if (RB_INSERT(flowspec_tree, &conf->flowspecs, f) !=
			    NULL) {
				yyerror("duplicate flowspec definition");
				flowspec_free(f);
				YYERROR;
			}
		}
#line 3700 "parse.c"
    break;

  case 109: /* proto_list: proto_item  */
#line 1200 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			curflow->type = FLOWSPEC_TYPE_PROTO;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3710 "parse.c"
    break;

  case 110: /* proto_list: proto_list comma proto_item  */
#line 1205 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			curflow->type = FLOWSPEC_TYPE_PROTO;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3720 "parse.c"
    break;

  case 111: /* proto_item: STRING  */
#line 1212 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct protoent *p;

			p = getprotobyname((yyvsp[0].v.string));
			if (p == NULL) {
				yyerror("unknown protocol %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			(yyval.v.number) = p->p_proto;
			free((yyvsp[0].v.string));
		}
#line 3737 "parse.c"
    break;

  case 112: /* proto_item: NUMBER  */
#line 1224 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 255) {
				yyerror("protocol outside range");
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 3749 "parse.c"
    break;

  case 113: /* $@8: %empty  */
#line 1233 "../../../openbgpd-portable/src/bgpd/parse.y"
                       {
			curflow->type = FLOWSPEC_TYPE_SRC_PORT;
			curflow->addr_type = FLOWSPEC_TYPE_SOURCE;
		}
#line 3758 "parse.c"
    break;

  case 115: /* $@9: %empty  */
#line 1239 "../../../openbgpd-portable/src/bgpd/parse.y"
                     {
			curflow->type = FLOWSPEC_TYPE_DST_PORT;
			curflow->addr_type = FLOWSPEC_TYPE_DEST;
		}
#line 3767 "parse.c"
    break;

  case 121: /* ipspec: prefix  */
#line 1251 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_prefix(&(yyvsp[0].v.prefix).prefix, (yyvsp[0].v.prefix).len) == -1)
				YYERROR;
		}
#line 3776 "parse.c"
    break;

  case 126: /* port_item: port  */
#line 1265 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3785 "parse.c"
    break;

  case 127: /* port_item: unaryop port  */
#line 1269 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop((yyvsp[-1].v.u8), (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3794 "parse.c"
    break;

  case 128: /* port_item: port binaryop port  */
#line 1273 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binary_numop((yyvsp[-1].v.u8), (yyvsp[-2].v.number), (yyvsp[0].v.number)))
				YYERROR;
		}
#line 3803 "parse.c"
    break;

  case 129: /* port: NUMBER  */
#line 1279 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("port must be between %u and %u",
				    1, USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 3816 "parse.c"
    break;

  case 130: /* port: STRING  */
#line 1287 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.number) = getservice((yyvsp[0].v.string))) == -1) {
				yyerror("unknown port '%s'", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3829 "parse.c"
    break;

  case 137: /* $@10: %empty  */
#line 1307 "../../../openbgpd-portable/src/bgpd/parse.y"
                        {
			curflow->type = FLOWSPEC_TYPE_TCP_FLAGS;
		}
#line 3837 "parse.c"
    break;

  case 139: /* $@11: %empty  */
#line 1310 "../../../openbgpd-portable/src/bgpd/parse.y"
                           {
			curflow->type = FLOWSPEC_TYPE_FRAG;
		}
#line 3845 "parse.c"
    break;

  case 142: /* flowrule: LENGTH lengthspec  */
#line 1314 "../../../openbgpd-portable/src/bgpd/parse.y"
                                    {
			curflow->type = FLOWSPEC_TYPE_PKT_LEN;
		}
#line 3853 "parse.c"
    break;

  case 144: /* flowrule: TOS tos  */
#line 1318 "../../../openbgpd-portable/src/bgpd/parse.y"
                          {
			curflow->type = FLOWSPEC_TYPE_DSCP;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number) >> 2) == -1)
				YYERROR;
		}
#line 3863 "parse.c"
    break;

  case 145: /* flags: flag '/' flag  */
#line 1325 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyvsp[-2].v.number) & (yyvsp[0].v.number)) != (yyvsp[-2].v.number)) {
				yyerror("bad flag combination, "
				    "check bit not in mask");
				YYERROR;
			}
			if (push_binop(FLOWSPEC_OP_BIT_MATCH, (yyvsp[-2].v.number)) == -1)
				YYERROR;
			/* check if extra mask op is needed */
			if ((yyvsp[0].v.number) & ~(yyvsp[-2].v.number)) {
				if (push_binop(FLOWSPEC_OP_BIT_NOT |
				    FLOWSPEC_OP_AND, (yyvsp[0].v.number) & ~(yyvsp[-2].v.number)) == -1)
					YYERROR;
			}
		}
#line 3883 "parse.c"
    break;

  case 146: /* flags: '/' flag  */
#line 1340 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binop(FLOWSPEC_OP_BIT_NOT, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3892 "parse.c"
    break;

  case 147: /* flags: flag  */
#line 1344 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binop(0, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3901 "parse.c"
    break;

  case 149: /* flag: STRING  */
#line 1351 "../../../openbgpd-portable/src/bgpd/parse.y"
                         {
			if (((yyval.v.number) = parse_flags((yyvsp[0].v.string))) < 0) {
				yyerror("bad flags %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3914 "parse.c"
    break;

  case 154: /* icmp_item: icmptype  */
#line 1369 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curflow->type = FLOWSPEC_TYPE_ICMP_TYPE;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3924 "parse.c"
    break;

  case 155: /* icmp_item: icmptype CODE STRING  */
#line 1374 "../../../openbgpd-portable/src/bgpd/parse.y"
                                       {
			int code;

			if ((code = geticmpcodebyname((yyvsp[-2].v.number), (yyvsp[0].v.string), curflow->aid)) ==
			    -1) {
				yyerror("unknown icmp-code %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			curflow->type = FLOWSPEC_TYPE_ICMP_TYPE;
			if (push_unary_numop(OP_EQ, (yyvsp[-2].v.number)) == -1)
				YYERROR;
			curflow->type = FLOWSPEC_TYPE_ICMP_CODE;
			if (push_unary_numop(OP_EQ, code) == -1)
				YYERROR;
		}
#line 3947 "parse.c"
    break;

  case 156: /* icmp_item: icmptype CODE NUMBER  */
#line 1392 "../../../openbgpd-portable/src/bgpd/parse.y"
                                       {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 255) {
				yyerror("illegal icmp-code %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			curflow->type = FLOWSPEC_TYPE_ICMP_TYPE;
			if (push_unary_numop(OP_EQ, (yyvsp[-2].v.number)) == -1)
				YYERROR;
			curflow->type = FLOWSPEC_TYPE_ICMP_CODE;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3964 "parse.c"
    break;

  case 157: /* icmptype: STRING  */
#line 1406 "../../../openbgpd-portable/src/bgpd/parse.y"
                         {
			int type;

			if ((type = geticmptypebyname((yyvsp[0].v.string), curflow->aid)) ==
			    -1) {
				yyerror("unknown icmp-type %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			(yyval.v.number) = type;
			free((yyvsp[0].v.string));
		}
#line 3981 "parse.c"
    break;

  case 158: /* icmptype: NUMBER  */
#line 1418 "../../../openbgpd-portable/src/bgpd/parse.y"
                         {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 255) {
				yyerror("illegal icmp-type %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 3993 "parse.c"
    break;

  case 159: /* tos: STRING  */
#line 1427 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			int val;
			char *end;

			if (map_tos((yyvsp[0].v.string), &val))
				(yyval.v.number) = val;
			else if ((yyvsp[0].v.string)[0] == '0' && (yyvsp[0].v.string)[1] == 'x') {
				errno = 0;
				(yyval.v.number) = strtoul((yyvsp[0].v.string), &end, 16);
				if (errno || *end != '\0')
					(yyval.v.number) = 256;
			} else
				(yyval.v.number) = 256;
			if ((yyval.v.number) < 0 || (yyval.v.number) > 255) {
				yyerror("illegal tos value %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4018 "parse.c"
    break;

  case 160: /* tos: NUMBER  */
#line 1447 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyval.v.number) < 0 || (yyval.v.number) > 255) {
				yyerror("illegal tos value %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4030 "parse.c"
    break;

  case 165: /* length_item: length  */
#line 1464 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 4039 "parse.c"
    break;

  case 166: /* length_item: unaryop length  */
#line 1468 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop((yyvsp[-1].v.u8), (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 4048 "parse.c"
    break;

  case 167: /* length_item: length binaryop length  */
#line 1472 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binary_numop((yyvsp[-1].v.u8), (yyvsp[-2].v.number), (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 4057 "parse.c"
    break;

  case 168: /* length: NUMBER  */
#line 1478 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyval.v.number) < 0 || (yyval.v.number) > USHRT_MAX) {
				yyerror("illegal ptk length value %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4069 "parse.c"
    break;

  case 169: /* inout: IN  */
#line 1486 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 1; }
#line 4075 "parse.c"
    break;

  case 170: /* inout: OUT  */
#line 1487 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 4081 "parse.c"
    break;

  case 171: /* restricted: %empty  */
#line 1490 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 4087 "parse.c"
    break;

  case 172: /* restricted: RESTRICTED  */
#line 1491 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 1; }
#line 4093 "parse.c"
    break;

  case 173: /* address: STRING  */
#line 1494 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			uint8_t	len;

			if (!host((yyvsp[0].v.string), &(yyval.v.addr), &len)) {
				yyerror("could not parse address spec \"%s\"",
				    (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			if (((yyval.v.addr).aid == AID_INET && len != 32) ||
			    ((yyval.v.addr).aid == AID_INET6 && len != 128)) {
				/* unreachable */
				yyerror("got prefixlen %u, expected %u",
				    len, (yyval.v.addr).aid == AID_INET ? 32 : 128);
				YYERROR;
			}
		}
#line 4117 "parse.c"
    break;

  case 174: /* prefix: STRING '/' NUMBER  */
#line 1515 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			char	*s;
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("bad prefixlen %lld", (yyvsp[0].v.number));
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			if (asprintf(&s, "%s/%lld", (yyvsp[-2].v.string), (yyvsp[0].v.number)) == -1)
				fatal(NULL);
			free((yyvsp[-2].v.string));

			if (!host(s, &(yyval.v.prefix).prefix, &(yyval.v.prefix).len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
#line 4140 "parse.c"
    break;

  case 175: /* prefix: NUMBER '/' NUMBER  */
#line 1533 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			char	*s;

			/* does not match IPv6 */
			if ((yyvsp[-2].v.number) < 0 || (yyvsp[-2].v.number) > 255 || (yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 32) {
				yyerror("bad prefix %lld/%lld", (yyvsp[-2].v.number), (yyvsp[0].v.number));
				YYERROR;
			}
			if (asprintf(&s, "%lld/%lld", (yyvsp[-2].v.number), (yyvsp[0].v.number)) == -1)
				fatal(NULL);

			if (!host(s, &(yyval.v.prefix).prefix, &(yyval.v.prefix).len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
#line 4163 "parse.c"
    break;

  case 176: /* addrspec: address  */
#line 1553 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			memcpy(&(yyval.v.prefix).prefix, &(yyvsp[0].v.addr), sizeof(struct bgpd_addr));
			if ((yyval.v.prefix).prefix.aid == AID_INET)
				(yyval.v.prefix).len = 32;
			else
				(yyval.v.prefix).len = 128;
		}
#line 4175 "parse.c"
    break;

  case 178: /* optnumber: %empty  */
#line 1563 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0; }
#line 4181 "parse.c"
    break;

  case 180: /* $@12: %empty  */
#line 1567 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			u_int rdomain, label;

			if (get_mpe_config((yyvsp[0].v.string), &rdomain, &label) == -1) {
				if ((cmd_opts & BGPD_OPT_NOACTION) == 0) {
					yyerror("troubles getting config of %s",
					    (yyvsp[0].v.string));
					free((yyvsp[0].v.string));
					free((yyvsp[-2].v.string));
					YYERROR;
				}
			}

			if (!(curvpn = calloc(1, sizeof(struct l3vpn))))
				fatal(NULL);
			strlcpy(curvpn->ifmpe, (yyvsp[0].v.string), IFNAMSIZ);

			if (strlcpy(curvpn->descr, (yyvsp[-2].v.string),
			    sizeof(curvpn->descr)) >=
			    sizeof(curvpn->descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    (yyvsp[-2].v.string), sizeof(curvpn->descr) - 1);
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				free(curvpn);
				curvpn = NULL;
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));

			TAILQ_INIT(&curvpn->import);
			TAILQ_INIT(&curvpn->export);
			TAILQ_INIT(&curvpn->net_l);
			curvpn->label = label;
			curvpn->rtableid = rdomain;
			netconf = &curvpn->net_l;
		}
#line 4224 "parse.c"
    break;

  case 181: /* l3vpn: VPN STRING ON STRING $@12 '{' l3vpnopts_l '}'  */
#line 1604 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			/* insert into list */
			SIMPLEQ_INSERT_TAIL(&conf->l3vpns, curvpn, entry);
			curvpn = NULL;
			netconf = &conf->networks;
		}
#line 4235 "parse.c"
    break;

  case 186: /* l3vpnopts: RD STRING  */
#line 1618 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			struct community	ext;

			memset(&ext, 0, sizeof(ext));
			if (parseextcommunity(&ext, "rt", (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
			/*
			 * RD is almost encoded like an ext-community,
			 * but only almost so convert here.
			 */
			if (community_to_rd(&ext, &curvpn->rd) == -1) {
				yyerror("bad encoding of rd");
				YYERROR;
			}
		}
#line 4258 "parse.c"
    break;

  case 187: /* l3vpnopts: EXPORTTRGT STRING STRING  */
#line 1636 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				free((yyvsp[-1].v.string));
				free(set);
				YYERROR;
			}
			free((yyvsp[0].v.string));
			free((yyvsp[-1].v.string));
			TAILQ_INSERT_TAIL(&curvpn->export, set, entry);
		}
#line 4281 "parse.c"
    break;

  case 188: /* l3vpnopts: IMPORTTRGT STRING STRING  */
#line 1654 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				free((yyvsp[-1].v.string));
				free(set);
				YYERROR;
			}
			free((yyvsp[0].v.string));
			free((yyvsp[-1].v.string));
			TAILQ_INSERT_TAIL(&curvpn->import, set, entry);
		}
#line 4304 "parse.c"
    break;

  case 189: /* l3vpnopts: FIBUPDATE yesno  */
#line 1672 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) == 0)
				curvpn->flags |= F_RIB_NOFIBSYNC;
			else
				curvpn->flags &= ~F_RIB_NOFIBSYNC;
		}
#line 4315 "parse.c"
    break;

  case 191: /* $@13: %empty  */
#line 1681 "../../../openbgpd-portable/src/bgpd/parse.y"
                  {	curpeer = new_peer(); }
#line 4321 "parse.c"
    break;

  case 192: /* $@14: %empty  */
#line 1682 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			memcpy(&curpeer->conf.remote_addr, &(yyvsp[0].v.prefix).prefix,
			    sizeof(curpeer->conf.remote_addr));
			curpeer->conf.remote_masklen = (yyvsp[0].v.prefix).len;
			if (((yyvsp[0].v.prefix).prefix.aid == AID_INET && (yyvsp[0].v.prefix).len != 32) ||
			    ((yyvsp[0].v.prefix).prefix.aid == AID_INET6 && (yyvsp[0].v.prefix).len != 128))
				curpeer->conf.template = 1;
			curpeer->conf.capabilities.mp[
			    curpeer->conf.remote_addr.aid] = 1;
			if (get_id(curpeer)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
#line 4340 "parse.c"
    break;

  case 193: /* neighbor: $@13 NEIGHBOR addrspec $@14 peeropts_h  */
#line 1696 "../../../openbgpd-portable/src/bgpd/parse.y"
                               {
			if (curpeer_filter[0] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[0], entry);
			if (curpeer_filter[1] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[1], entry);
			curpeer_filter[0] = NULL;
			curpeer_filter[1] = NULL;

			if (neighbor_consistent(curpeer) == -1) {
				free(curpeer);
				YYERROR;
			}
			if (RB_INSERT(peer_head, new_peers, curpeer) != NULL)
				fatalx("%s: peer tree is corrupt", __func__);
			curpeer = curgroup;
		}
#line 4363 "parse.c"
    break;

  case 194: /* $@15: %empty  */
#line 1716 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curgroup = curpeer = new_group();
			if (strlcpy(curgroup->conf.group, (yyvsp[0].v.string),
			    sizeof(curgroup->conf.group)) >=
			    sizeof(curgroup->conf.group)) {
				yyerror("group name \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(curgroup->conf.group) - 1);
				free((yyvsp[0].v.string));
				free(curgroup);
				YYERROR;
			}
			free((yyvsp[0].v.string));
			if (get_id(curgroup)) {
				yyerror("get_id failed");
				free(curgroup);
				YYERROR;
			}
		}
#line 4386 "parse.c"
    break;

  case 195: /* group: GROUP string $@15 '{' groupopts_l '}'  */
#line 1733 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (curgroup_filter[0] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[0], entry);
			if (curgroup_filter[1] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[1], entry);
			curgroup_filter[0] = NULL;
			curgroup_filter[1] = NULL;

			free(curgroup);
			curgroup = NULL;
		}
#line 4404 "parse.c"
    break;

  case 201: /* addpathextra: %empty  */
#line 1755 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0;	}
#line 4410 "parse.c"
    break;

  case 202: /* addpathextra: PLUS NUMBER  */
#line 1756 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("additional paths must be between "
				    "%u and %u", 1, USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4423 "parse.c"
    break;

  case 203: /* addpathmax: %empty  */
#line 1766 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0;	}
#line 4429 "parse.c"
    break;

  case 204: /* addpathmax: MAX NUMBER  */
#line 1767 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("maximum additional paths must be "
				    "between %u and %u", 1, USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4442 "parse.c"
    break;

  case 212: /* peeropts: REMOTEAS as4number  */
#line 1788 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.remote_as = (yyvsp[0].v.number);
		}
#line 4450 "parse.c"
    break;

  case 213: /* peeropts: LOCALAS as4number  */
#line 1791 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.local_as = (yyvsp[0].v.number);
			if ((yyvsp[0].v.number) > USHRT_MAX)
				curpeer->conf.local_short_as = AS_TRANS;
			else
				curpeer->conf.local_short_as = (yyvsp[0].v.number);
		}
#line 4462 "parse.c"
    break;

  case 214: /* peeropts: LOCALAS as4number asnumber  */
#line 1798 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			curpeer->conf.local_as = (yyvsp[-1].v.number);
			curpeer->conf.local_short_as = (yyvsp[0].v.number);
		}
#line 4471 "parse.c"
    break;

  case 215: /* peeropts: DESCR string  */
#line 1802 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (strlcpy(curpeer->conf.descr, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.descr)) >=
			    sizeof(curpeer->conf.descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(curpeer->conf.descr) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4487 "parse.c"
    break;

  case 216: /* peeropts: LOCALADDR address  */
#line 1813 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.addr).aid == AID_INET)
				memcpy(&curpeer->conf.local_addr_v4, &(yyvsp[0].v.addr),
				    sizeof(curpeer->conf.local_addr_v4));
			else if ((yyvsp[0].v.addr).aid == AID_INET6)
				memcpy(&curpeer->conf.local_addr_v6, &(yyvsp[0].v.addr),
				    sizeof(curpeer->conf.local_addr_v6));
			else {
				yyerror("Unsupported address family %s for "
				    "local-addr", aid2str((yyvsp[0].v.addr).aid));
				YYERROR;
			}
		}
#line 4505 "parse.c"
    break;

  case 217: /* peeropts: yesno LOCALADDR  */
#line 1826 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[-1].v.number)) {
				yyerror("bad local-address definition");
				YYERROR;
			}
			memset(&curpeer->conf.local_addr_v4, 0,
			    sizeof(curpeer->conf.local_addr_v4));
			memset(&curpeer->conf.local_addr_v6, 0,
			    sizeof(curpeer->conf.local_addr_v6));
		}
#line 4520 "parse.c"
    break;

  case 218: /* peeropts: MULTIHOP NUMBER  */
#line 1836 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 2 || (yyvsp[0].v.number) > 255) {
				yyerror("invalid multihop distance %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			curpeer->conf.distance = (yyvsp[0].v.number);
		}
#line 4532 "parse.c"
    break;

  case 219: /* peeropts: PASSIVE  */
#line 1843 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.passive = 1;
		}
#line 4540 "parse.c"
    break;

  case 220: /* peeropts: DOWN  */
#line 1846 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.down = 1;
		}
#line 4548 "parse.c"
    break;

  case 221: /* peeropts: DOWN STRING  */
#line 1849 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.down = 1;
			if (strlcpy(curpeer->conf.reason, (yyvsp[0].v.string),
				sizeof(curpeer->conf.reason)) >=
				sizeof(curpeer->conf.reason)) {
				    yyerror("shutdown reason too long");
				    free((yyvsp[0].v.string));
				    YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4564 "parse.c"
    break;

  case 222: /* peeropts: RIB STRING  */
#line 1860 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!find_rib((yyvsp[0].v.string))) {
				yyerror("rib \"%s\" does not exist.", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (strlcpy(curpeer->conf.rib, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.rib)) >=
			    sizeof(curpeer->conf.rib)) {
				yyerror("rib name \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(curpeer->conf.rib) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4585 "parse.c"
    break;

  case 223: /* peeropts: HOLDTIME NUMBER  */
#line 1876 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.holdtime = (yyvsp[0].v.number);
		}
#line 4598 "parse.c"
    break;

  case 224: /* peeropts: HOLDTIME YMIN NUMBER  */
#line 1884 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.min_holdtime = (yyvsp[0].v.number);
		}
#line 4611 "parse.c"
    break;

  case 225: /* peeropts: ANNOUNCE af safi  */
#line 1892 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			uint8_t		aid, safi;
			uint16_t	afi;

			if ((yyvsp[0].v.number) == SAFI_NONE) {
				for (aid = 0; aid < AID_MAX; aid++) {
					if (aid2afi(aid, &afi, &safi) == -1 ||
					    afi != (yyvsp[-1].v.number))
						continue;
					curpeer->conf.capabilities.mp[aid] = 0;
				}
			} else {
				if (afi2aid((yyvsp[-1].v.number), (yyvsp[0].v.number), &aid) == -1) {
					yyerror("unknown AFI/SAFI pair");
					YYERROR;
				}
				curpeer->conf.capabilities.mp[aid] = 1;
			}
		}
#line 4635 "parse.c"
    break;

  case 226: /* peeropts: ANNOUNCE CAPABILITIES yesno  */
#line 1911 "../../../openbgpd-portable/src/bgpd/parse.y"
                                              {
			curpeer->conf.announce_capa = (yyvsp[0].v.number);
		}
#line 4643 "parse.c"
    break;

  case 227: /* peeropts: ANNOUNCE REFRESH yesno  */
#line 1914 "../../../openbgpd-portable/src/bgpd/parse.y"
                                         {
			curpeer->conf.capabilities.refresh = (yyvsp[0].v.number);
		}
#line 4651 "parse.c"
    break;

  case 228: /* peeropts: ANNOUNCE ENHANCED REFRESH yesno  */
#line 1917 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                  {
			curpeer->conf.capabilities.enhanced_rr = (yyvsp[0].v.number);
		}
#line 4659 "parse.c"
    break;

  case 229: /* peeropts: ANNOUNCE RESTART yesno  */
#line 1920 "../../../openbgpd-portable/src/bgpd/parse.y"
                                         {
			curpeer->conf.capabilities.grestart.restart = (yyvsp[0].v.number);
		}
#line 4667 "parse.c"
    break;

  case 230: /* peeropts: ANNOUNCE AS4BYTE yesno  */
#line 1923 "../../../openbgpd-portable/src/bgpd/parse.y"
                                         {
			curpeer->conf.capabilities.as4byte = (yyvsp[0].v.number);
		}
#line 4675 "parse.c"
    break;

  case 231: /* peeropts: ANNOUNCE ADDPATH RECV yesno  */
#line 1926 "../../../openbgpd-portable/src/bgpd/parse.y"
                                              {
			int8_t *ap = curpeer->conf.capabilities.add_path;
			uint8_t i;

			for (i = 0; i < AID_MAX; i++)
				if ((yyvsp[0].v.number))
					*ap++ |= CAPA_AP_RECV;
				else
					*ap++ &= ~CAPA_AP_RECV;
		}
#line 4690 "parse.c"
    break;

  case 232: /* peeropts: ANNOUNCE ADDPATH SEND STRING addpathextra addpathmax  */
#line 1936 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                       {
			int8_t *ap = curpeer->conf.capabilities.add_path;
			enum addpath_mode mode;
			u_int8_t i;

			if (!strcmp((yyvsp[-2].v.string), "no")) {
				free((yyvsp[-2].v.string));
				if ((yyvsp[-1].v.number) != 0 || (yyvsp[0].v.number) != 0) {
					yyerror("no additional option allowed "
					    "for 'add-path send no'");
					YYERROR;
				}
				for (i = 0; i < AID_MAX; i++)
					*ap++ &= ~CAPA_AP_SEND;
				break;
			} else if (!strcmp((yyvsp[-2].v.string), "all")) {
				free((yyvsp[-2].v.string));
				if ((yyvsp[-1].v.number) != 0 || (yyvsp[0].v.number) != 0) {
					yyerror("no additional option allowed "
					    "for 'add-path send all'");
					YYERROR;
				}
				mode = ADDPATH_EVAL_ALL;
			} else if (!strcmp((yyvsp[-2].v.string), "best")) {
				free((yyvsp[-2].v.string));
				mode = ADDPATH_EVAL_BEST;
			} else if (!strcmp((yyvsp[-2].v.string), "ecmp")) {
				free((yyvsp[-2].v.string));
				mode = ADDPATH_EVAL_ECMP;
			} else if (!strcmp((yyvsp[-2].v.string), "as-wide-best")) {
				free((yyvsp[-2].v.string));
				mode = ADDPATH_EVAL_AS_WIDE;
			} else {
				yyerror("announce add-path send: "
				    "unknown mode \"%s\"", (yyvsp[-2].v.string));
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			for (i = 0; i < AID_MAX; i++)
				*ap++ |= CAPA_AP_SEND;
			curpeer->conf.eval.mode = mode;
			curpeer->conf.eval.extrapaths = (yyvsp[-1].v.number);
			curpeer->conf.eval.maxpaths = (yyvsp[0].v.number);
		}
#line 4739 "parse.c"
    break;

  case 233: /* peeropts: ANNOUNCE POLICY enforce  */
#line 1980 "../../../openbgpd-portable/src/bgpd/parse.y"
                                          {
			curpeer->conf.capabilities.policy = (yyvsp[0].v.number);
		}
#line 4747 "parse.c"
    break;

  case 234: /* peeropts: ROLE STRING  */
#line 1983 "../../../openbgpd-portable/src/bgpd/parse.y"
                              {
			if (strcmp((yyvsp[0].v.string), "provider") == 0) {
				curpeer->conf.role = ROLE_PROVIDER;
			} else if (strcmp((yyvsp[0].v.string), "rs") == 0) {
				curpeer->conf.role = ROLE_RS;
			} else if (strcmp((yyvsp[0].v.string), "rs-client") == 0) {
				curpeer->conf.role = ROLE_RS_CLIENT;
			} else if (strcmp((yyvsp[0].v.string), "customer") == 0) {
				curpeer->conf.role = ROLE_CUSTOMER;
			} else if (strcmp((yyvsp[0].v.string), "peer") == 0) {
				curpeer->conf.role = ROLE_PEER;
			} else {
				yyerror("syntax error, one of none, provider, "
				    "rs, rs-client, customer, peer expected");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4771 "parse.c"
    break;

  case 235: /* peeropts: ROLE NONE  */
#line 2002 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			curpeer->conf.role = ROLE_NONE;
		}
#line 4779 "parse.c"
    break;

  case 236: /* peeropts: EXPORT NONE  */
#line 2005 "../../../openbgpd-portable/src/bgpd/parse.y"
                              {
			curpeer->conf.export_type = EXPORT_NONE;
		}
#line 4787 "parse.c"
    break;

  case 237: /* peeropts: EXPORT DEFAULTROUTE  */
#line 2008 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			curpeer->conf.export_type = EXPORT_DEFAULT_ROUTE;
		}
#line 4795 "parse.c"
    break;

  case 238: /* peeropts: ENFORCE NEIGHBORAS yesno  */
#line 2011 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if ((yyvsp[0].v.number))
				curpeer->conf.enforce_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_as = ENFORCE_AS_OFF;
		}
#line 4806 "parse.c"
    break;

  case 239: /* peeropts: ENFORCE LOCALAS yesno  */
#line 2017 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number))
				curpeer->conf.enforce_local_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_local_as = ENFORCE_AS_OFF;
		}
#line 4817 "parse.c"
    break;

  case 240: /* peeropts: ASOVERRIDE yesno  */
#line 2023 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			if ((yyvsp[0].v.number)) {
				struct filter_rule	*r;
				struct filter_set	*s;

				if ((s = calloc(1, sizeof(struct filter_set)))
				    == NULL)
					fatal(NULL);
				s->type = ACTION_SET_AS_OVERRIDE;

				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
		}
#line 4837 "parse.c"
    break;

  case 241: /* peeropts: MAXPREFIX NUMBER restart  */
#line 2038 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if ((yyvsp[-1].v.number) < 0 || (yyvsp[-1].v.number) > UINT_MAX) {
				yyerror("bad maximum number of prefixes");
				YYERROR;
			}
			curpeer->conf.max_prefix = (yyvsp[-1].v.number);
			curpeer->conf.max_prefix_restart = (yyvsp[0].v.number);
		}
#line 4850 "parse.c"
    break;

  case 242: /* peeropts: MAXPREFIX NUMBER OUT restart  */
#line 2046 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			if ((yyvsp[-2].v.number) < 0 || (yyvsp[-2].v.number) > UINT_MAX) {
				yyerror("bad maximum number of prefixes");
				YYERROR;
			}
			curpeer->conf.max_out_prefix = (yyvsp[-2].v.number);
			curpeer->conf.max_out_prefix_restart = (yyvsp[0].v.number);
		}
#line 4863 "parse.c"
    break;

  case 243: /* peeropts: TCP MD5SIG PASSWORD string  */
#line 2054 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (strlcpy(curpeer->conf.auth.md5key, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.auth.md5key)) >=
			    sizeof(curpeer->conf.auth.md5key)) {
				yyerror("tcp md5sig password too long: max %zu",
				    sizeof(curpeer->conf.auth.md5key) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen((yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 4886 "parse.c"
    break;

  case 244: /* peeropts: TCP MD5SIG KEY string  */
#line 2072 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (str2key((yyvsp[0].v.string), curpeer->conf.auth.md5key,
			    sizeof(curpeer->conf.auth.md5key)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen((yyvsp[0].v.string)) / 2;
			free((yyvsp[0].v.string));
		}
#line 4907 "parse.c"
    break;

  case 245: /* peeropts: IPSEC espah IKE  */
#line 2088 "../../../openbgpd-portable/src/bgpd/parse.y"
                                  {
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				YYERROR;
			}
			if ((yyvsp[-1].v.number))
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_ESP;
			else
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_AH;
		}
#line 4922 "parse.c"
    break;

  case 246: /* peeropts: IPSEC espah inout SPI NUMBER STRING STRING encspec  */
#line 2098 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                     {
			enum auth_alg	auth_alg;
			uint8_t		keylen;

			if (curpeer->conf.auth.method &&
			    (((curpeer->conf.auth.spi_in && (yyvsp[-5].v.number) == 1) ||
			    (curpeer->conf.auth.spi_out && (yyvsp[-5].v.number) == 0)) ||
			    ((yyvsp[-6].v.number) == 1 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_ESP) ||
			    ((yyvsp[-6].v.number) == 0 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_AH))) {
				yyerror("auth method cannot be redefined");
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}

			if (!strcmp((yyvsp[-2].v.string), "sha1")) {
				auth_alg = AUTH_AALG_SHA1HMAC;
				keylen = 20;
			} else if (!strcmp((yyvsp[-2].v.string), "md5")) {
				auth_alg = AUTH_AALG_MD5HMAC;
				keylen = 16;
			} else {
				yyerror("unknown auth algorithm \"%s\"", (yyvsp[-2].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));

			if (strlen((yyvsp[-1].v.string)) / 2 != keylen) {
				yyerror("auth key len: must be %u bytes, "
				    "is %zu bytes", keylen, strlen((yyvsp[-1].v.string)) / 2);
				free((yyvsp[-1].v.string));
				YYERROR;
			}

			if ((yyvsp[-6].v.number))
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_ESP;
			else {
				if ((yyvsp[0].v.encspec).enc_alg) {
					yyerror("\"ipsec ah\" doesn't take "
					    "encryption keys");
					free((yyvsp[-1].v.string));
					YYERROR;
				}
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_AH;
			}

			if ((yyvsp[-3].v.number) <= SPI_RESERVED_MAX || (yyvsp[-3].v.number) > UINT_MAX) {
				yyerror("bad spi number %lld", (yyvsp[-3].v.number));
				free((yyvsp[-1].v.string));
				YYERROR;
			}

			if ((yyvsp[-5].v.number) == 1) {
				if (str2key((yyvsp[-1].v.string), curpeer->conf.auth.auth_key_in,
				    sizeof(curpeer->conf.auth.auth_key_in)) ==
				    -1) {
					free((yyvsp[-1].v.string));
					YYERROR;
				}
				curpeer->conf.auth.spi_in = (yyvsp[-3].v.number);
				curpeer->conf.auth.auth_alg_in = auth_alg;
				curpeer->conf.auth.enc_alg_in = (yyvsp[0].v.encspec).enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_in,
				    &(yyvsp[0].v.encspec).enc_key,
				    sizeof(curpeer->conf.auth.enc_key_in));
				curpeer->conf.auth.enc_keylen_in =
				    (yyvsp[0].v.encspec).enc_key_len;
				curpeer->conf.auth.auth_keylen_in = keylen;
			} else {
				if (str2key((yyvsp[-1].v.string), curpeer->conf.auth.auth_key_out,
				    sizeof(curpeer->conf.auth.auth_key_out)) ==
				    -1) {
					free((yyvsp[-1].v.string));
					YYERROR;
				}
				curpeer->conf.auth.spi_out = (yyvsp[-3].v.number);
				curpeer->conf.auth.auth_alg_out = auth_alg;
				curpeer->conf.auth.enc_alg_out = (yyvsp[0].v.encspec).enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_out,
				    &(yyvsp[0].v.encspec).enc_key,
				    sizeof(curpeer->conf.auth.enc_key_out));
				curpeer->conf.auth.enc_keylen_out =
				    (yyvsp[0].v.encspec).enc_key_len;
				curpeer->conf.auth.auth_keylen_out = keylen;
			}
			free((yyvsp[-1].v.string));
		}
#line 5020 "parse.c"
    break;

  case 247: /* peeropts: TTLSECURITY yesno  */
#line 2191 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.ttlsec = (yyvsp[0].v.number);
		}
#line 5028 "parse.c"
    break;

  case 248: /* peeropts: SET filter_set_opt  */
#line 2194 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			struct filter_rule	*r;

			r = get_rule((yyvsp[0].v.filter_set)->type);
			if (merge_filterset(&r->set, (yyvsp[0].v.filter_set)) == -1)
				YYERROR;
		}
#line 5040 "parse.c"
    break;

  case 249: /* peeropts: SET '{' optnl filter_set_l optnl '}'  */
#line 2201 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct filter_rule	*r;
			struct filter_set	*s;

			while ((s = TAILQ_FIRST((yyvsp[-2].v.filter_set_head))) != NULL) {
				TAILQ_REMOVE((yyvsp[-2].v.filter_set_head), s, entry);
				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
			free((yyvsp[-2].v.filter_set_head));
		}
#line 5057 "parse.c"
    break;

  case 251: /* peeropts: REFLECTOR  */
#line 2214 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != 0) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
		}
#line 5072 "parse.c"
    break;

  case 252: /* peeropts: REFLECTOR address  */
#line 2224 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.addr).aid != AID_INET) {
				yyerror("route reflector cluster-id must be "
				    "an IPv4 address");
				YYERROR;
			}
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != (yyvsp[0].v.addr).v4.s_addr) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
			conf->clusterid = (yyvsp[0].v.addr).v4.s_addr;
		}
#line 5093 "parse.c"
    break;

  case 253: /* peeropts: DEPEND ON STRING  */
#line 2240 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (strlcpy(curpeer->conf.if_depend, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.if_depend)) >=
			    sizeof(curpeer->conf.if_depend)) {
				yyerror("interface name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string),
				    sizeof(curpeer->conf.if_depend) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5110 "parse.c"
    break;

  case 254: /* peeropts: DEMOTE STRING  */
#line 2252 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
#ifdef HAVE_CARP
			if (strlcpy(curpeer->conf.demote_group, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.demote_group)) >=
			    sizeof(curpeer->conf.demote_group)) {
				yyerror("demote group name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string),
				    sizeof(curpeer->conf.demote_group) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
			if (carp_demote_init(curpeer->conf.demote_group,
			    cmd_opts & BGPD_OPT_FORCE_DEMOTE) == -1) {
				yyerror("error initializing group \"%s\"",
				    curpeer->conf.demote_group);
				YYERROR;
			}
#else
			yyerror("carp demote not supported");
			free((yyvsp[0].v.string));
			YYERROR;
#endif
		}
#line 5139 "parse.c"
    break;

  case 255: /* peeropts: TRANSPARENT yesno  */
#line 2276 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				curpeer->conf.flags |= PEERFLAG_TRANS_AS;
			else
				curpeer->conf.flags &= ~PEERFLAG_TRANS_AS;
		}
#line 5150 "parse.c"
    break;

  case 256: /* peeropts: LOG STRING  */
#line 2282 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (!strcmp((yyvsp[0].v.string), "updates"))
				curpeer->conf.flags |= PEERFLAG_LOG_UPDATES;
			else if (!strcmp((yyvsp[0].v.string), "no"))
				curpeer->conf.flags &= ~PEERFLAG_LOG_UPDATES;
			else {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5166 "parse.c"
    break;

  case 257: /* peeropts: REJECT ASSET yesno  */
#line 2293 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				curpeer->conf.flags |= PEERFLAG_NO_AS_SET;
			else
				curpeer->conf.flags &= ~PEERFLAG_NO_AS_SET;
		}
#line 5177 "parse.c"
    break;

  case 258: /* peeropts: PORT port  */
#line 2299 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			curpeer->conf.remote_port = (yyvsp[0].v.number);
		}
#line 5185 "parse.c"
    break;

  case 259: /* peeropts: RDE EVALUATE STRING  */
#line 2302 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			if (!strcmp((yyvsp[0].v.string), "all"))
				curpeer->conf.flags |= PEERFLAG_EVALUATE_ALL;
			else if (!strcmp((yyvsp[0].v.string), "default"))
				curpeer->conf.flags &= ~PEERFLAG_EVALUATE_ALL;
			else {
				yyerror("rde evaluate: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5203 "parse.c"
    break;

  case 260: /* restart: %empty  */
#line 2317 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0; }
#line 5209 "parse.c"
    break;

  case 261: /* restart: RESTART NUMBER  */
#line 2318 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("restart out of range. 1 to %u minutes",
				    USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 5222 "parse.c"
    break;

  case 262: /* af: IPV4  */
#line 2328 "../../../openbgpd-portable/src/bgpd/parse.y"
                        { (yyval.v.number) = AFI_IPv4; }
#line 5228 "parse.c"
    break;

  case 263: /* af: IPV6  */
#line 2329 "../../../openbgpd-portable/src/bgpd/parse.y"
                        { (yyval.v.number) = AFI_IPv6; }
#line 5234 "parse.c"
    break;

  case 264: /* safi: NONE  */
#line 2332 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_NONE; }
#line 5240 "parse.c"
    break;

  case 265: /* safi: UNICAST  */
#line 2333 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_UNICAST; }
#line 5246 "parse.c"
    break;

  case 266: /* safi: VPN  */
#line 2334 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_MPLSVPN; }
#line 5252 "parse.c"
    break;

  case 267: /* safi: FLOWSPEC  */
#line 2335 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_FLOWSPEC; }
#line 5258 "parse.c"
    break;

  case 268: /* nettype: STATIC  */
#line 2338 "../../../openbgpd-portable/src/bgpd/parse.y"
                         { (yyval.v.number) = 1; }
#line 5264 "parse.c"
    break;

  case 269: /* nettype: CONNECTED  */
#line 2339 "../../../openbgpd-portable/src/bgpd/parse.y"
                            { (yyval.v.number) = 0; }
#line 5270 "parse.c"
    break;

  case 270: /* espah: ESP  */
#line 2342 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 1; }
#line 5276 "parse.c"
    break;

  case 271: /* espah: AH  */
#line 2343 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 5282 "parse.c"
    break;

  case 272: /* encspec: %empty  */
#line 2346 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			memset(&(yyval.v.encspec), 0, sizeof((yyval.v.encspec)));
		}
#line 5290 "parse.c"
    break;

  case 273: /* encspec: STRING STRING  */
#line 2349 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			memset(&(yyval.v.encspec), 0, sizeof((yyval.v.encspec)));
			if (!strcmp((yyvsp[-1].v.string), "3des") || !strcmp((yyvsp[-1].v.string), "3des-cbc")) {
				(yyval.v.encspec).enc_alg = AUTH_EALG_3DESCBC;
				(yyval.v.encspec).enc_key_len = 21; /* XXX verify */
			} else if (!strcmp((yyvsp[-1].v.string), "aes") ||
			    !strcmp((yyvsp[-1].v.string), "aes-128-cbc")) {
				(yyval.v.encspec).enc_alg = AUTH_EALG_AES;
				(yyval.v.encspec).enc_key_len = 16;
			} else {
				yyerror("unknown enc algorithm \"%s\"", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));

			if (strlen((yyvsp[0].v.string)) / 2 != (yyval.v.encspec).enc_key_len) {
				yyerror("enc key length wrong: should be %u "
				    "bytes, is %zu bytes",
				    (yyval.v.encspec).enc_key_len * 2, strlen((yyvsp[0].v.string)));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (str2key((yyvsp[0].v.string), (yyval.v.encspec).enc_key, sizeof((yyval.v.encspec).enc_key)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5326 "parse.c"
    break;

  case 274: /* filterrule: action quick filter_rib_h direction filter_peer_h filter_match_h filter_set  */
#line 2384 "../../../openbgpd-portable/src/bgpd/parse.y"
                {
			struct filter_rule	 r;
			struct filter_rib_l	 *rb, *rbnext;

			memset(&r, 0, sizeof(r));
			r.action = (yyvsp[-6].v.u8);
			r.quick = (yyvsp[-5].v.u8);
			r.dir = (yyvsp[-3].v.u8);
			if ((yyvsp[-4].v.filter_rib)) {
				if (r.dir != DIR_IN) {
					yyerror("rib only allowed on \"from\" "
					    "rules.");

					for (rb = (yyvsp[-4].v.filter_rib); rb != NULL; rb = rbnext) {
						rbnext = rb->next;
						free(rb);
					}
					YYERROR;
				}
			}
			if (expand_rule(&r, (yyvsp[-4].v.filter_rib), (yyvsp[-2].v.filter_peers), &(yyvsp[-1].v.filter_match), (yyvsp[0].v.filter_set_head)) == -1)
				YYERROR;
		}
#line 5354 "parse.c"
    break;

  case 275: /* action: ALLOW  */
#line 2409 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = ACTION_ALLOW; }
#line 5360 "parse.c"
    break;

  case 276: /* action: DENY  */
#line 2410 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = ACTION_DENY; }
#line 5366 "parse.c"
    break;

  case 277: /* action: MATCH  */
#line 2411 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = ACTION_NONE; }
#line 5372 "parse.c"
    break;

  case 278: /* quick: %empty  */
#line 2414 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 0; }
#line 5378 "parse.c"
    break;

  case 279: /* quick: QUICK  */
#line 2415 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 1; }
#line 5384 "parse.c"
    break;

  case 280: /* direction: FROM  */
#line 2418 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = DIR_IN; }
#line 5390 "parse.c"
    break;

  case 281: /* direction: TO  */
#line 2419 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = DIR_OUT; }
#line 5396 "parse.c"
    break;

  case 282: /* filter_rib_h: %empty  */
#line 2422 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_rib) = NULL; }
#line 5402 "parse.c"
    break;

  case 283: /* filter_rib_h: RIB filter_rib  */
#line 2423 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_rib) = (yyvsp[0].v.filter_rib); }
#line 5408 "parse.c"
    break;

  case 284: /* filter_rib_h: RIB '{' optnl filter_rib_l optnl '}'  */
#line 2424 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_rib) = (yyvsp[-2].v.filter_rib); }
#line 5414 "parse.c"
    break;

  case 285: /* filter_rib_l: filter_rib  */
#line 2426 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_rib) = (yyvsp[0].v.filter_rib); }
#line 5420 "parse.c"
    break;

  case 286: /* filter_rib_l: filter_rib_l comma filter_rib  */
#line 2427 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			(yyvsp[0].v.filter_rib)->next = (yyvsp[-2].v.filter_rib);
			(yyval.v.filter_rib) = (yyvsp[0].v.filter_rib);
		}
#line 5429 "parse.c"
    break;

  case 287: /* filter_rib: STRING  */
#line 2433 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!find_rib((yyvsp[0].v.string))) {
				yyerror("rib \"%s\" does not exist.", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (((yyval.v.filter_rib) = calloc(1, sizeof(struct filter_rib_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_rib)->next = NULL;
			if (strlcpy((yyval.v.filter_rib)->name, (yyvsp[0].v.string), sizeof((yyval.v.filter_rib)->name)) >=
			    sizeof((yyval.v.filter_rib)->name)) {
				yyerror("rib name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string), sizeof((yyval.v.filter_rib)->name) - 1);
				free((yyvsp[0].v.string));
				free((yyval.v.filter_rib));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5454 "parse.c"
    break;

  case 289: /* filter_peer_h: '{' optnl filter_peer_l optnl '}'  */
#line 2456 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_peers) = (yyvsp[-2].v.filter_peers); }
#line 5460 "parse.c"
    break;

  case 290: /* filter_peer_l: filter_peer  */
#line 2459 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_peers) = (yyvsp[0].v.filter_peers); }
#line 5466 "parse.c"
    break;

  case 291: /* filter_peer_l: filter_peer_l comma filter_peer  */
#line 2460 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			(yyvsp[0].v.filter_peers)->next = (yyvsp[-2].v.filter_peers);
			(yyval.v.filter_peers) = (yyvsp[0].v.filter_peers);
		}
#line 5475 "parse.c"
    break;

  case 292: /* filter_peer: ANY  */
#line 2466 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.peerid = (yyval.v.filter_peers)->p.groupid = 0;
			(yyval.v.filter_peers)->next = NULL;
		}
#line 5487 "parse.c"
    break;

  case 293: /* filter_peer: address  */
#line 2473 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			struct peer *p;

			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.remote_as = (yyval.v.filter_peers)->p.groupid = (yyval.v.filter_peers)->p.peerid = 0;
			(yyval.v.filter_peers)->next = NULL;
			RB_FOREACH(p, peer_head, new_peers)
				if (!memcmp(&p->conf.remote_addr,
				    &(yyvsp[0].v.addr), sizeof(p->conf.remote_addr))) {
					(yyval.v.filter_peers)->p.peerid = p->conf.id;
					break;
				}
			if ((yyval.v.filter_peers)->p.peerid == 0) {
				yyerror("no such peer: %s", log_addr(&(yyvsp[0].v.addr)));
				free((yyval.v.filter_peers));
				YYERROR;
			}
		}
#line 5512 "parse.c"
    break;

  case 294: /* filter_peer: AS as4number  */
#line 2493 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.groupid = (yyval.v.filter_peers)->p.peerid = 0;
			(yyval.v.filter_peers)->p.remote_as = (yyvsp[0].v.number);
		}
#line 5524 "parse.c"
    break;

  case 295: /* filter_peer: GROUP STRING  */
#line 2500 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			struct peer *p;

			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.remote_as = (yyval.v.filter_peers)->p.peerid = 0;
			(yyval.v.filter_peers)->next = NULL;
			RB_FOREACH(p, peer_head, new_peers)
				if (!strcmp(p->conf.group, (yyvsp[0].v.string))) {
					(yyval.v.filter_peers)->p.groupid = p->conf.groupid;
					break;
				}
			if ((yyval.v.filter_peers)->p.groupid == 0) {
				yyerror("no such group: \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				free((yyval.v.filter_peers));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5550 "parse.c"
    break;

  case 296: /* filter_peer: EBGP  */
#line 2521 "../../../openbgpd-portable/src/bgpd/parse.y"
                       {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.ebgp = 1;
		}
#line 5561 "parse.c"
    break;

  case 297: /* filter_peer: IBGP  */
#line 2527 "../../../openbgpd-portable/src/bgpd/parse.y"
                       {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.ibgp = 1;
		}
#line 5572 "parse.c"
    break;

  case 298: /* filter_prefix_h: IPV4 prefixlenop  */
#line 2535 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                         {
			if ((yyvsp[0].v.prefixlen).op == OP_NONE) {
				(yyvsp[0].v.prefixlen).op = OP_RANGE;
				(yyvsp[0].v.prefixlen).len_min = 0;
				(yyvsp[0].v.prefixlen).len_max = -1;
			}
			if (((yyval.v.filter_prefix) = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_prefix)->p.addr.aid = AID_INET;
			if (merge_prefixspec(&(yyval.v.filter_prefix)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.filter_prefix));
				YYERROR;
			}
		}
#line 5592 "parse.c"
    break;

  case 299: /* filter_prefix_h: IPV6 prefixlenop  */
#line 2550 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.prefixlen).op == OP_NONE) {
				(yyvsp[0].v.prefixlen).op = OP_RANGE;
				(yyvsp[0].v.prefixlen).len_min = 0;
				(yyvsp[0].v.prefixlen).len_max = -1;
			}
			if (((yyval.v.filter_prefix) = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_prefix)->p.addr.aid = AID_INET6;
			if (merge_prefixspec(&(yyval.v.filter_prefix)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.filter_prefix));
				YYERROR;
			}
		}
#line 5612 "parse.c"
    break;

  case 300: /* filter_prefix_h: PREFIX filter_prefix  */
#line 2565 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_prefix) = (yyvsp[0].v.filter_prefix); }
#line 5618 "parse.c"
    break;

  case 301: /* filter_prefix_h: PREFIX '{' filter_prefix_m '}'  */
#line 2566 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_prefix) = (yyvsp[-1].v.filter_prefix); }
#line 5624 "parse.c"
    break;

  case 303: /* filter_prefix_m: '{' filter_prefix_l '}'  */
#line 2570 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_prefix) = (yyvsp[-1].v.filter_prefix); }
#line 5630 "parse.c"
    break;

  case 304: /* filter_prefix_m: '{' filter_prefix_l '}' filter_prefix_m  */
#line 2572 "../../../openbgpd-portable/src/bgpd/parse.y"
                {
			struct filter_prefix_l	*p;

			/* merge, both can be lists */
			for (p = (yyvsp[-2].v.filter_prefix); p != NULL && p->next != NULL; p = p->next)
				;	/* nothing */
			if (p != NULL)
				p->next = (yyvsp[0].v.filter_prefix);
			(yyval.v.filter_prefix) = (yyvsp[-2].v.filter_prefix);
		}
#line 5645 "parse.c"
    break;

  case 305: /* filter_prefix_l: filter_prefix  */
#line 2583 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_prefix) = (yyvsp[0].v.filter_prefix); }
#line 5651 "parse.c"
    break;

  case 306: /* filter_prefix_l: filter_prefix_l comma filter_prefix  */
#line 2584 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			(yyvsp[0].v.filter_prefix)->next = (yyvsp[-2].v.filter_prefix);
			(yyval.v.filter_prefix) = (yyvsp[0].v.filter_prefix);
		}
#line 5660 "parse.c"
    break;

  case 307: /* filter_prefix: prefix prefixlenop  */
#line 2590 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if (((yyval.v.filter_prefix) = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			memcpy(&(yyval.v.filter_prefix)->p.addr, &(yyvsp[-1].v.prefix).prefix,
			    sizeof((yyval.v.filter_prefix)->p.addr));
			(yyval.v.filter_prefix)->p.len = (yyvsp[-1].v.prefix).len;

			if (merge_prefixspec(&(yyval.v.filter_prefix)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.filter_prefix));
				YYERROR;
			}
		}
#line 5678 "parse.c"
    break;

  case 309: /* filter_as_h: '{' filter_as_t_l '}'  */
#line 2606 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_as) = (yyvsp[-1].v.filter_as); }
#line 5684 "parse.c"
    break;

  case 311: /* filter_as_t_l: filter_as_t_l comma filter_as_t  */
#line 2610 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = (yyvsp[-2].v.filter_as); a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = (yyvsp[0].v.filter_as);
			(yyval.v.filter_as) = (yyvsp[-2].v.filter_as);
		}
#line 5699 "parse.c"
    break;

  case 312: /* filter_as_t: filter_as_type filter_as  */
#line 2622 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			(yyval.v.filter_as) = (yyvsp[0].v.filter_as);
			(yyval.v.filter_as)->a.type = (yyvsp[-1].v.u8);
		}
#line 5708 "parse.c"
    break;

  case 313: /* filter_as_t: filter_as_type '{' filter_as_l_h '}'  */
#line 2626 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct filter_as_l	*a;

			(yyval.v.filter_as) = (yyvsp[-1].v.filter_as);
			for (a = (yyval.v.filter_as); a != NULL; a = a->next)
				a->a.type = (yyvsp[-3].v.u8);
		}
#line 5720 "parse.c"
    break;

  case 314: /* filter_as_t: filter_as_type ASSET STRING  */
#line 2633 "../../../openbgpd-portable/src/bgpd/parse.y"
                                              {
			if (as_sets_lookup(&conf->as_sets, (yyvsp[0].v.string)) == NULL) {
				yyerror("as-set \"%s\" not defined", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.type = (yyvsp[-2].v.u8);
			(yyval.v.filter_as)->a.flags = AS_FLAG_AS_SET_NAME;
			if (strlcpy((yyval.v.filter_as)->a.name, (yyvsp[0].v.string), sizeof((yyval.v.filter_as)->a.name)) >=
			    sizeof((yyval.v.filter_as)->a.name)) {
				yyerror("as-set name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string), sizeof((yyval.v.filter_as)->a.name) - 1);
				free((yyvsp[0].v.string));
				free((yyval.v.filter_as));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5746 "parse.c"
    break;

  case 316: /* filter_as_l_h: '{' filter_as_l '}'  */
#line 2657 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_as) = (yyvsp[-1].v.filter_as); }
#line 5752 "parse.c"
    break;

  case 317: /* filter_as_l_h: '{' filter_as_l '}' filter_as_l_h  */
#line 2659 "../../../openbgpd-portable/src/bgpd/parse.y"
                {
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = (yyvsp[-2].v.filter_as); a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = (yyvsp[0].v.filter_as);
			(yyval.v.filter_as) = (yyvsp[-2].v.filter_as);
		}
#line 5767 "parse.c"
    break;

  case 319: /* filter_as_l: filter_as_l comma filter_as  */
#line 2672 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			(yyvsp[0].v.filter_as)->next = (yyvsp[-2].v.filter_as);
			(yyval.v.filter_as) = (yyvsp[0].v.filter_as);
		}
#line 5776 "parse.c"
    break;

  case 320: /* filter_as: as4number_any  */
#line 2678 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.as_min = (yyvsp[0].v.number);
			(yyval.v.filter_as)->a.as_max = (yyvsp[0].v.number);
			(yyval.v.filter_as)->a.op = OP_EQ;
		}
#line 5789 "parse.c"
    break;

  case 321: /* filter_as: NEIGHBORAS  */
#line 2686 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.flags = AS_FLAG_NEIGHBORAS;
		}
#line 5800 "parse.c"
    break;

  case 322: /* filter_as: equalityop as4number_any  */
#line 2692 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.op = (yyvsp[-1].v.u8);
			(yyval.v.filter_as)->a.as_min = (yyvsp[0].v.number);
			(yyval.v.filter_as)->a.as_max = (yyvsp[0].v.number);
		}
#line 5813 "parse.c"
    break;

  case 323: /* filter_as: as4number_any binaryop as4number_any  */
#line 2700 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                       {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			if ((yyvsp[-2].v.number) >= (yyvsp[0].v.number)) {
				yyerror("start AS is bigger than end");
				YYERROR;
			}
			(yyval.v.filter_as)->a.op = (yyvsp[-1].v.u8);
			(yyval.v.filter_as)->a.as_min = (yyvsp[-2].v.number);
			(yyval.v.filter_as)->a.as_max = (yyvsp[0].v.number);
		}
#line 5830 "parse.c"
    break;

  case 324: /* filter_match_h: %empty  */
#line 2714 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			memset(&(yyval.v.filter_match), 0, sizeof((yyval.v.filter_match)));
		}
#line 5838 "parse.c"
    break;

  case 325: /* $@16: %empty  */
#line 2717 "../../../openbgpd-portable/src/bgpd/parse.y"
                  {
			memset(&fmopts, 0, sizeof(fmopts));
		}
#line 5846 "parse.c"
    break;

  case 326: /* filter_match_h: $@16 filter_match  */
#line 2720 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			memcpy(&(yyval.v.filter_match), &fmopts, sizeof((yyval.v.filter_match)));
		}
#line 5854 "parse.c"
    break;

  case 329: /* filter_elm: filter_prefix_h  */
#line 2729 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified");
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("\"prefix-set\" already specified, "
				    "cannot be used with \"prefix\" in the "
				    "same filter rule");
				YYERROR;
			}
			fmopts.prefix_l = (yyvsp[0].v.filter_prefix);
		}
#line 5872 "parse.c"
    break;

  case 330: /* filter_elm: filter_as_h  */
#line 2742 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.as_l != NULL) {
				yyerror("AS filters already specified");
				YYERROR;
			}
			fmopts.as_l = (yyvsp[0].v.filter_as);
		}
#line 5884 "parse.c"
    break;

  case 331: /* filter_elm: MAXASLEN NUMBER  */
#line 2749 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad max-as-len %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_MAX;
			fmopts.m.aslen.aslen = (yyvsp[0].v.number);
		}
#line 5901 "parse.c"
    break;

  case 332: /* filter_elm: MAXASSEQ NUMBER  */
#line 2761 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad max-as-seq %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_SEQ;
			fmopts.m.aslen.aslen = (yyvsp[0].v.number);
		}
#line 5918 "parse.c"
    break;

  case 333: /* filter_elm: community STRING  */
#line 2773 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (parsecommunity(&fmopts.m.community[i], (yyvsp[-1].v.u8), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5941 "parse.c"
    break;

  case 334: /* filter_elm: EXTCOMMUNITY STRING STRING  */
#line 2791 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.string));
		}
#line 5968 "parse.c"
    break;

  case 335: /* filter_elm: EXTCOMMUNITY OVS STRING  */
#line 2813 "../../../openbgpd-portable/src/bgpd/parse.y"
                                          {
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    "ovs", (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5992 "parse.c"
    break;

  case 336: /* filter_elm: MAXCOMMUNITIES NUMBER  */
#line 2832 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT16_MAX) {
				yyerror("bad max-comunities %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (fmopts.m.maxcomm != 0) {
				yyerror("%s already specified",
				    "max-communities");
				YYERROR;
			}
			/*
			 * Offset by 1 since 0 means not used.
			 * The match function then uses >= to compensate.
			 */
			fmopts.m.maxcomm = (yyvsp[0].v.number) + 1;
		}
#line 6013 "parse.c"
    break;

  case 337: /* filter_elm: MAXEXTCOMMUNITIES NUMBER  */
#line 2848 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT16_MAX) {
				yyerror("bad max-ext-communities %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (fmopts.m.maxextcomm != 0) {
				yyerror("%s already specified",
				    "max-ext-communities");
				YYERROR;
			}
			fmopts.m.maxextcomm = (yyvsp[0].v.number) + 1;
		}
#line 6030 "parse.c"
    break;

  case 338: /* filter_elm: MAXLARGECOMMUNITIES NUMBER  */
#line 2860 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT16_MAX) {
				yyerror("bad max-large-communities %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (fmopts.m.maxlargecomm != 0) {
				yyerror("%s already specified",
				    "max-large-communities");
				YYERROR;
			}
			fmopts.m.maxlargecomm = (yyvsp[0].v.number) + 1;
		}
#line 6047 "parse.c"
    break;

  case 339: /* filter_elm: NEXTHOP address  */
#line 2872 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.addr = (yyvsp[0].v.addr);
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_ADDR;
		}
#line 6060 "parse.c"
    break;

  case 340: /* filter_elm: NEXTHOP NEIGHBOR  */
#line 2880 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_NEIGHBOR;
		}
#line 6072 "parse.c"
    break;

  case 341: /* filter_elm: PREFIXSET STRING prefixlenop  */
#line 2887 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			struct prefixset *ps;
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified, cannot "
				    "be used with \"prefix-set\" in the same "
				    "filter rule");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("prefix-set filter already specified");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if ((ps = find_prefixset((yyvsp[-1].v.string), &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (strlcpy(fmopts.m.prefixset.name, (yyvsp[-1].v.string),
			    sizeof(fmopts.m.prefixset.name)) >=
			    sizeof(fmopts.m.prefixset.name)) {
				yyerror("prefix-set name too long");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!((yyvsp[0].v.prefixlen).op == OP_NONE ||
			    ((yyvsp[0].v.prefixlen).op == OP_RANGE &&
			     (yyvsp[0].v.prefixlen).len_min == -1 && (yyvsp[0].v.prefixlen).len_max == -1))) {
				yyerror("prefix-sets can only use option "
				    "or-longer");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if ((yyvsp[0].v.prefixlen).op == OP_RANGE && ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s contains prefixlen "
				    "operators and cannot be used with an "
				    "or-longer filter", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if ((yyvsp[0].v.prefixlen).op == OP_RANGE && (yyvsp[0].v.prefixlen).len_min == -1 &&
			    (yyvsp[0].v.prefixlen).len_min == -1)
				fmopts.m.prefixset.flags |=
				    PREFIXSET_FLAG_LONGER;
			fmopts.m.prefixset.flags |= PREFIXSET_FLAG_FILTER;
			free((yyvsp[-1].v.string));
		}
#line 6126 "parse.c"
    break;

  case 342: /* filter_elm: ORIGINSET STRING  */
#line 2936 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			if (fmopts.m.originset.name[0] != '\0') {
				yyerror("origin-set filter already specified");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (find_prefixset((yyvsp[0].v.string), &conf->originsets) == NULL) {
				yyerror("origin-set '%s' not defined", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (strlcpy(fmopts.m.originset.name, (yyvsp[0].v.string),
			    sizeof(fmopts.m.originset.name)) >=
			    sizeof(fmopts.m.originset.name)) {
				yyerror("origin-set name too long");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6151 "parse.c"
    break;

  case 343: /* filter_elm: OVS validity  */
#line 2956 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.ovs.is_set) {
				yyerror("ovs filter already specified");
				YYERROR;
			}
			fmopts.m.ovs.validity = (yyvsp[0].v.number);
			fmopts.m.ovs.is_set = 1;
		}
#line 6164 "parse.c"
    break;

  case 344: /* filter_elm: AVS aspa_validity  */
#line 2964 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (fmopts.m.avs.is_set) {
				yyerror("avs filter already specified");
				YYERROR;
			}
			fmopts.m.avs.validity = (yyvsp[0].v.number);
			fmopts.m.avs.is_set = 1;
		}
#line 6177 "parse.c"
    break;

  case 345: /* prefixlenop: %empty  */
#line 2974 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen))); }
#line 6183 "parse.c"
    break;

  case 346: /* prefixlenop: LONGER  */
#line 2975 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			(yyval.v.prefixlen).op = OP_RANGE;
			(yyval.v.prefixlen).len_min = -1;
			(yyval.v.prefixlen).len_max = -1;
		}
#line 6194 "parse.c"
    break;

  case 347: /* prefixlenop: MAXLEN NUMBER  */
#line 2981 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}

			(yyval.v.prefixlen).op = OP_RANGE;
			(yyval.v.prefixlen).len_min = -1;
			(yyval.v.prefixlen).len_max = (yyvsp[0].v.number);
		}
#line 6210 "parse.c"
    break;

  case 348: /* prefixlenop: PREFIXLEN unaryop NUMBER  */
#line 2992 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			int min, max;

			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}
			/*
			 * convert the unary operation into the equivalent
			 * range check
			 */
			(yyval.v.prefixlen).op = OP_RANGE;

			switch ((yyvsp[-1].v.u8)) {
			case OP_NE:
				(yyval.v.prefixlen).op = (yyvsp[-1].v.u8);
			case OP_EQ:
				min = max = (yyvsp[0].v.number);
				break;
			case OP_LT:
				if ((yyvsp[0].v.number) == 0) {
					yyerror("prefixlen must be > 0");
					YYERROR;
				}
				(yyvsp[0].v.number) -= 1;
			case OP_LE:
				min = -1;
				max = (yyvsp[0].v.number);
				break;
			case OP_GT:
				(yyvsp[0].v.number) += 1;
			case OP_GE:
				min = (yyvsp[0].v.number);
				max = -1;
				break;
			default:
				yyerror("unknown prefixlen operation");
				YYERROR;
			}
			(yyval.v.prefixlen).len_min = min;
			(yyval.v.prefixlen).len_max = max;
		}
#line 6258 "parse.c"
    break;

  case 349: /* prefixlenop: PREFIXLEN NUMBER binaryop NUMBER  */
#line 3035 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			if ((yyvsp[-2].v.number) < 0 || (yyvsp[-2].v.number) > 128 || (yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("prefixlen must be < 128");
				YYERROR;
			}
			if ((yyvsp[-2].v.number) > (yyvsp[0].v.number)) {
				yyerror("start prefixlen is bigger than end");
				YYERROR;
			}
			(yyval.v.prefixlen).op = (yyvsp[-1].v.u8);
			(yyval.v.prefixlen).len_min = (yyvsp[-2].v.number);
			(yyval.v.prefixlen).len_max = (yyvsp[0].v.number);
		}
#line 6277 "parse.c"
    break;

  case 350: /* filter_as_type: AS  */
#line 3051 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_ALL; }
#line 6283 "parse.c"
    break;

  case 351: /* filter_as_type: SOURCEAS  */
#line 3052 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_SOURCE; }
#line 6289 "parse.c"
    break;

  case 352: /* filter_as_type: TRANSITAS  */
#line 3053 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_TRANSIT; }
#line 6295 "parse.c"
    break;

  case 353: /* filter_as_type: PEERAS  */
#line 3054 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_PEER; }
#line 6301 "parse.c"
    break;

  case 354: /* filter_set: %empty  */
#line 3057 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                { (yyval.v.filter_set_head) = NULL; }
#line 6307 "parse.c"
    break;

  case 355: /* filter_set: SET filter_set_opt  */
#line 3058 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			if (((yyval.v.filter_set_head) = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT((yyval.v.filter_set_head));
			TAILQ_INSERT_TAIL((yyval.v.filter_set_head), (yyvsp[0].v.filter_set), entry);
		}
#line 6319 "parse.c"
    break;

  case 356: /* filter_set: SET '{' optnl filter_set_l optnl '}'  */
#line 3065 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_set_head) = (yyvsp[-2].v.filter_set_head); }
#line 6325 "parse.c"
    break;

  case 357: /* filter_set_l: filter_set_l comma filter_set_opt  */
#line 3068 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			(yyval.v.filter_set_head) = (yyvsp[-2].v.filter_set_head);
			if (merge_filterset((yyval.v.filter_set_head), (yyvsp[0].v.filter_set)) == 1)
				YYERROR;
		}
#line 6335 "parse.c"
    break;

  case 358: /* filter_set_l: filter_set_opt  */
#line 3073 "../../../openbgpd-portable/src/bgpd/parse.y"
                                 {
			if (((yyval.v.filter_set_head) = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT((yyval.v.filter_set_head));
			TAILQ_INSERT_TAIL((yyval.v.filter_set_head), (yyvsp[0].v.filter_set), entry);
		}
#line 6347 "parse.c"
    break;

  case 359: /* community: COMMUNITY  */
#line 3082 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.u8) = COMMUNITY_TYPE_BASIC; }
#line 6353 "parse.c"
    break;

  case 360: /* community: LARGECOMMUNITY  */
#line 3083 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.u8) = COMMUNITY_TYPE_LARGE; }
#line 6359 "parse.c"
    break;

  case 361: /* delete: %empty  */
#line 3086 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 0; }
#line 6365 "parse.c"
    break;

  case 362: /* delete: DELETE  */
#line 3087 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 1; }
#line 6371 "parse.c"
    break;

  case 363: /* enforce: yesno  */
#line 3090 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = (yyvsp[0].v.number); }
#line 6377 "parse.c"
    break;

  case 364: /* enforce: ENFORCE  */
#line 3091 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 2; }
#line 6383 "parse.c"
    break;

  case 365: /* filter_set_opt: LOCALPREF NUMBER  */
#line 3094 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad localpref %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) >= 0) {
				(yyval.v.filter_set)->type = ACTION_SET_LOCALPREF;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_LOCALPREF;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6403 "parse.c"
    break;

  case 366: /* filter_set_opt: LOCALPREF '+' NUMBER  */
#line 3109 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad localpref +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_LOCALPREF;
			(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
		}
#line 6418 "parse.c"
    break;

  case 367: /* filter_set_opt: LOCALPREF '-' NUMBER  */
#line 3119 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad localpref -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_LOCALPREF;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6433 "parse.c"
    break;

  case 368: /* filter_set_opt: MED NUMBER  */
#line 3129 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad metric %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) >= 0) {
				(yyval.v.filter_set)->type = ACTION_SET_MED;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6453 "parse.c"
    break;

  case 369: /* filter_set_opt: MED '+' NUMBER  */
#line 3144 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
		}
#line 6468 "parse.c"
    break;

  case 370: /* filter_set_opt: MED '-' NUMBER  */
#line 3154 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6483 "parse.c"
    break;

  case 371: /* filter_set_opt: METRIC NUMBER  */
#line 3164 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {	/* alias for MED */
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad metric %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) >= 0) {
				(yyval.v.filter_set)->type = ACTION_SET_MED;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6503 "parse.c"
    break;

  case 372: /* filter_set_opt: METRIC '+' NUMBER  */
#line 3179 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
		}
#line 6518 "parse.c"
    break;

  case 373: /* filter_set_opt: METRIC '-' NUMBER  */
#line 3189 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6533 "parse.c"
    break;

  case 374: /* filter_set_opt: WEIGHT NUMBER  */
#line 3199 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad weight %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) > 0) {
				(yyval.v.filter_set)->type = ACTION_SET_WEIGHT;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_WEIGHT;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6553 "parse.c"
    break;

  case 375: /* filter_set_opt: WEIGHT '+' NUMBER  */
#line 3214 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad weight +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_WEIGHT;
			(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
		}
#line 6568 "parse.c"
    break;

  case 376: /* filter_set_opt: WEIGHT '-' NUMBER  */
#line 3224 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad weight -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_WEIGHT;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6583 "parse.c"
    break;

  case 377: /* filter_set_opt: NEXTHOP address  */
#line 3234 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP;
			memcpy(&(yyval.v.filter_set)->action.nexthop, &(yyvsp[0].v.addr),
			    sizeof((yyval.v.filter_set)->action.nexthop));
		}
#line 6595 "parse.c"
    break;

  case 378: /* filter_set_opt: NEXTHOP BLACKHOLE  */
#line 3241 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_BLACKHOLE;
		}
#line 6605 "parse.c"
    break;

  case 379: /* filter_set_opt: NEXTHOP REJECT  */
#line 3246 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_REJECT;
		}
#line 6615 "parse.c"
    break;

  case 380: /* filter_set_opt: NEXTHOP NOMODIFY  */
#line 3251 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_NOMODIFY;
		}
#line 6625 "parse.c"
    break;

  case 381: /* filter_set_opt: NEXTHOP SELF  */
#line 3256 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_SELF;
		}
#line 6635 "parse.c"
    break;

  case 382: /* filter_set_opt: PREPEND_SELF NUMBER  */
#line 3261 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_PREPEND_SELF;
			(yyval.v.filter_set)->action.prepend = (yyvsp[0].v.number);
		}
#line 6650 "parse.c"
    break;

  case 383: /* filter_set_opt: PREPEND_PEER NUMBER  */
#line 3271 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_PREPEND_PEER;
			(yyval.v.filter_set)->action.prepend = (yyvsp[0].v.number);
		}
#line 6665 "parse.c"
    break;

  case 384: /* filter_set_opt: ASOVERRIDE  */
#line 3281 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_AS_OVERRIDE;
		}
#line 6675 "parse.c"
    break;

  case 385: /* filter_set_opt: PFTABLE STRING  */
#line 3286 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_PFTABLE;
			if (!(cmd_opts & BGPD_OPT_NOACTION) &&
			    pftable_exists((yyvsp[0].v.string)) != 0) {
				yyerror("pftable name does not exist");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			if (strlcpy((yyval.v.filter_set)->action.pftable, (yyvsp[0].v.string),
			    sizeof((yyval.v.filter_set)->action.pftable)) >=
			    sizeof((yyval.v.filter_set)->action.pftable)) {
				yyerror("pftable name too long");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			if (pftable_add((yyvsp[0].v.string)) != 0) {
				yyerror("Couldn't register table");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6707 "parse.c"
    break;

  case 386: /* filter_set_opt: RTLABEL STRING  */
#line 3313 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_RTLABEL;
			if (strlcpy((yyval.v.filter_set)->action.rtlabel, (yyvsp[0].v.string),
			    sizeof((yyval.v.filter_set)->action.rtlabel)) >=
			    sizeof((yyval.v.filter_set)->action.rtlabel)) {
				yyerror("rtlabel name too long");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6726 "parse.c"
    break;

  case 387: /* filter_set_opt: community delete STRING  */
#line 3327 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			uint8_t f1, f2, f3;

			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[-1].v.u8))
				(yyval.v.filter_set)->type = ACTION_DEL_COMMUNITY;
			else
				(yyval.v.filter_set)->type = ACTION_SET_COMMUNITY;

			if (parsecommunity(&(yyval.v.filter_set)->action.community, (yyvsp[-2].v.u8), (yyvsp[0].v.string)) ==
			    -1) {
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
			/* Don't allow setting of any match */
			f1 = (yyval.v.filter_set)->action.community.flags >> 8;
			f2 = (yyval.v.filter_set)->action.community.flags >> 16;
			f3 = (yyval.v.filter_set)->action.community.flags >> 24;
			if (!(yyvsp[-1].v.u8) && (f1 == COMMUNITY_ANY ||
			    f2 == COMMUNITY_ANY || f3 == COMMUNITY_ANY)) {
				yyerror("'*' is not allowed in set community");
				free((yyval.v.filter_set));
				YYERROR;
			}
		}
#line 6759 "parse.c"
    break;

  case 388: /* filter_set_opt: EXTCOMMUNITY delete STRING STRING  */
#line 3355 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                    {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[-2].v.u8))
				(yyval.v.filter_set)->type = ACTION_DEL_COMMUNITY;
			else
				(yyval.v.filter_set)->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&(yyval.v.filter_set)->action.community,
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.string));
		}
#line 6782 "parse.c"
    break;

  case 389: /* filter_set_opt: EXTCOMMUNITY delete OVS STRING  */
#line 3373 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                 {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[-2].v.u8))
				(yyval.v.filter_set)->type = ACTION_DEL_COMMUNITY;
			else
				(yyval.v.filter_set)->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&(yyval.v.filter_set)->action.community,
			    "ovs", (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6803 "parse.c"
    break;

  case 390: /* filter_set_opt: ORIGIN origincode  */
#line 3389 "../../../openbgpd-portable/src/bgpd/parse.y"
                                    {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_ORIGIN;
			(yyval.v.filter_set)->action.origin = (yyvsp[0].v.number);
		}
#line 6814 "parse.c"
    break;

  case 391: /* origincode: STRING  */
#line 3397 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!strcmp((yyvsp[0].v.string), "egp"))
				(yyval.v.number) = ORIGIN_EGP;
			else if (!strcmp((yyvsp[0].v.string), "igp"))
				(yyval.v.number) = ORIGIN_IGP;
			else if (!strcmp((yyvsp[0].v.string), "incomplete"))
				(yyval.v.number) = ORIGIN_INCOMPLETE;
			else {
				yyerror("unknown origin \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6833 "parse.c"
    break;

  case 392: /* validity: STRING  */
#line 3412 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!strcmp((yyvsp[0].v.string), "not-found"))
				(yyval.v.number) = ROA_NOTFOUND;
			else if (!strcmp((yyvsp[0].v.string), "invalid"))
				(yyval.v.number) = ROA_INVALID;
			else if (!strcmp((yyvsp[0].v.string), "valid"))
				(yyval.v.number) = ROA_VALID;
			else {
				yyerror("unknown roa validity \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6852 "parse.c"
    break;

  case 393: /* aspa_validity: STRING  */
#line 3427 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!strcmp((yyvsp[0].v.string), "unknown"))
				(yyval.v.number) = ASPA_UNKNOWN;
			else if (!strcmp((yyvsp[0].v.string), "invalid"))
				(yyval.v.number) = ASPA_INVALID;
			else if (!strcmp((yyvsp[0].v.string), "valid"))
				(yyval.v.number) = ASPA_VALID;
			else {
				yyerror("unknown aspa validity \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6871 "parse.c"
    break;

  case 400: /* unaryop: '='  */
#line 3452 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_EQ; }
#line 6877 "parse.c"
    break;

  case 401: /* unaryop: NE  */
#line 3453 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_NE; }
#line 6883 "parse.c"
    break;

  case 402: /* unaryop: LE  */
#line 3454 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_LE; }
#line 6889 "parse.c"
    break;

  case 403: /* unaryop: '<'  */
#line 3455 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_LT; }
#line 6895 "parse.c"
    break;

  case 404: /* unaryop: GE  */
#line 3456 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_GE; }
#line 6901 "parse.c"
    break;

  case 405: /* unaryop: '>'  */
#line 3457 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_GT; }
#line 6907 "parse.c"
    break;

  case 406: /* equalityop: '='  */
#line 3460 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_EQ; }
#line 6913 "parse.c"
    break;

  case 407: /* equalityop: NE  */
#line 3461 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_NE; }
#line 6919 "parse.c"
    break;

  case 408: /* binaryop: '-'  */
#line 3464 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_RANGE; }
#line 6925 "parse.c"
    break;

  case 409: /* binaryop: XRANGE  */
#line 3465 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_XRANGE; }
#line 6931 "parse.c"
    break;


#line 6935 "parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;
#endif


/*-------------------------------------------------------.
| yyreturn -- parsing is finished, clean up and return.  |
`-------------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 3468 "../../../openbgpd-portable/src/bgpd/parse.y"


struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		fatalx("yyerror vasprintf");
	va_end(ap);
	logit(LOG_CRIT, "%s:%d: %s", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* this has to be sorted always */
	static const struct keywords keywords[] = {
		{ "AS",			AS},
		{ "IPv4",		IPV4},
		{ "IPv6",		IPV6},
		{ "add-path",		ADDPATH},
		{ "ah",			AH},
		{ "allow",		ALLOW},
		{ "announce",		ANNOUNCE},
		{ "any",		ANY},
		{ "as-4byte",		AS4BYTE },
		{ "as-override",	ASOVERRIDE},
		{ "as-set",		ASSET },
		{ "aspa-set",		ASPASET},
		{ "avs",		AVS},
		{ "blackhole",		BLACKHOLE},
		{ "capabilities",	CAPABILITIES},
		{ "community",		COMMUNITY},
		{ "compare",		COMPARE},
		{ "connect-retry",	CONNECTRETRY},
		{ "connected",		CONNECTED},
		{ "customer-as",	CUSTOMERAS},
		{ "default-route",	DEFAULTROUTE},
		{ "delete",		DELETE},
		{ "demote",		DEMOTE},
		{ "deny",		DENY},
		{ "depend",		DEPEND},
		{ "descr",		DESCR},
		{ "down",		DOWN},
		{ "dump",		DUMP},
		{ "ebgp",		EBGP},
		{ "enforce",		ENFORCE},
		{ "enhanced",		ENHANCED },
		{ "esp",		ESP},
		{ "evaluate",		EVALUATE},
		{ "expires",		EXPIRES},
		{ "export",		EXPORT},
		{ "export-target",	EXPORTTRGT},
		{ "ext-community",	EXTCOMMUNITY},
		{ "fib-priority",	FIBPRIORITY},
		{ "fib-update",		FIBUPDATE},
		{ "flags",		FLAGS},
		{ "flowspec",		FLOWSPEC},
		{ "fragment",		FRAGMENT},
		{ "from",		FROM},
		{ "group",		GROUP},
		{ "holdtime",		HOLDTIME},
		{ "ibgp",		IBGP},
		{ "ignore",		IGNORE},
		{ "ike",		IKE},
		{ "import-target",	IMPORTTRGT},
		{ "in",			IN},
		{ "include",		INCLUDE},
		{ "inet",		IPV4},
		{ "inet6",		IPV6},
		{ "ipsec",		IPSEC},
		{ "key",		KEY},
		{ "large-community",	LARGECOMMUNITY},
		{ "listen",		LISTEN},
		{ "local-address",	LOCALADDR},
		{ "local-as",		LOCALAS},
		{ "localpref",		LOCALPREF},
		{ "log",		LOG},
		{ "match",		MATCH},
		{ "max",		MAX},
		{ "max-as-len",		MAXASLEN},
		{ "max-as-seq",		MAXASSEQ},
		{ "max-communities",	MAXCOMMUNITIES},
		{ "max-ext-communities",	MAXEXTCOMMUNITIES},
		{ "max-large-communities",	MAXLARGECOMMUNITIES},
		{ "max-prefix",		MAXPREFIX},
		{ "maxlen",		MAXLEN},
		{ "md5sig",		MD5SIG},
		{ "med",		MED},
		{ "metric",		METRIC},
		{ "min",		YMIN},
		{ "multihop",		MULTIHOP},
		{ "neighbor",		NEIGHBOR},
		{ "neighbor-as",	NEIGHBORAS},
		{ "network",		NETWORK},
		{ "nexthop",		NEXTHOP},
		{ "no-modify",		NOMODIFY},
		{ "none",		NONE},
		{ "on",			ON},
		{ "or-longer",		LONGER},
		{ "origin",		ORIGIN},
		{ "origin-set",		ORIGINSET},
		{ "out",		OUT},
		{ "ovs",		OVS},
		{ "passive",		PASSIVE},
		{ "password",		PASSWORD},
		{ "peer-as",		PEERAS},
		{ "pftable",		PFTABLE},
		{ "plus",		PLUS},
		{ "policy",		POLICY},
		{ "port",		PORT},
		{ "prefix",		PREFIX},
		{ "prefix-set",		PREFIXSET},
		{ "prefixlen",		PREFIXLEN},
		{ "prepend-neighbor",	PREPEND_PEER},
		{ "prepend-self",	PREPEND_SELF},
		{ "priority",		PRIORITY},
		{ "proto",		PROTO},
		{ "provider-as",	PROVIDERAS},
		{ "qualify",		QUALIFY},
		{ "quick",		QUICK},
		{ "rd",			RD},
		{ "rde",		RDE},
		{ "recv",		RECV},
		{ "refresh",		REFRESH },
		{ "reject",		REJECT},
		{ "remote-as",		REMOTEAS},
		{ "restart",		RESTART},
		{ "restricted",		RESTRICTED},
		{ "rib",		RIB},
		{ "roa-set",		ROASET },
		{ "role",		ROLE},
		{ "route-reflector",	REFLECTOR},
		{ "router-id",		ROUTERID},
		{ "rtable",		RTABLE},
		{ "rtlabel",		RTLABEL},
		{ "rtr",		RTR},
		{ "self",		SELF},
		{ "send",		SEND},
		{ "set",		SET},
		{ "socket",		SOCKET },
		{ "source-as",		SOURCEAS},
		{ "spi",		SPI},
		{ "static",		STATIC},
		{ "tcp",		TCP},
		{ "to",			TO},
		{ "tos",		TOS},
		{ "transit-as",		TRANSITAS},
		{ "transparent-as",	TRANSPARENT},
		{ "ttl-security",	TTLSECURITY},
		{ "unicast",		UNICAST},
		{ "via",		VIA},
		{ "vpn",		VPN},
		{ "weight",		WEIGHT}
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, nitems(keywords), sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return (c);
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return (EOF);
			return (quotec);
		}
		return (c);
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return ('\n');
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return (EOF);
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			err(1, "lungetc");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* skip to either EOF or the first real EOL */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
expand_macro(void)
{
	char	 buf[MACRO_NAME_LEN];
	char	*p, *val;
	int	 c;

	p = buf;
	while (1) {
		if ((c = lgetc('$')) == EOF)
			return (ERROR);
		if (p + 1 >= buf + sizeof(buf) - 1) {
			yyerror("macro name too long");
			return (ERROR);
		}
		if (isalnum(c) || c == '_') {
			*p++ = c;
			continue;
		}
		*p = '\0';
		lungetc(c);
		break;
	}
	val = symget(buf);
	if (val == NULL) {
		yyerror("macro '%s' not defined", buf);
		return (ERROR);
	}
	p = val + strlen(val) - 1;
	lungetc(DONE_EXPAND);
	while (p >= val) {
		lungetc((unsigned char)*p);
		p--;
	}
	lungetc(START_EXPAND);
	return (0);
}

int
yylex(void)
{
	char	 buf[8096];
	char	*p;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(0)) == ' ' || c == '\t')
		; /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#')
		while ((c = lgetc(0)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && !expanding) {
		c = expand_macro();
		if (c != 0)
			return (c);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			if ((c = lgetc(quotec)) == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				if ((next = lgetc(quotec)) == EOF)
					return (0);
				if (next == quotec || next == ' ' ||
				    next == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error: unterminated quote");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return (STRING);
	case '!':
		next = lgetc(0);
		if (next == '=')
			return (NE);
		lungetc(next);
		break;
	case '<':
		next = lgetc(0);
		if (next == '=')
			return (LE);
		lungetc(next);
		break;
	case '>':
		next = lgetc(0);
		if (next == '<')
			return (XRANGE);
		else if (next == '=')
			return (GE);
		lungetc(next);
		break;
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc((unsigned char)*--p);
			c = (unsigned char)*--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && x != '<' && x != '>' && \
	x != '!' && x != '=' && x != '/' && x != '#' && \
	x != ','))

	if (isalnum(c) || c == ':' || c == '_' || c == '*') {
		do {
			if (c == '$' && !expanding) {
				c = expand_macro();
				if (c != 0)
					return (c);
			} else
				*p++ = c;

			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			if ((yylval.v.string = strdup(buf)) == NULL)
				fatal("yylex: strdup");
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
check_file_secrecy(int fd, const char *fname)
{
	struct stat	st;

	if (fstat(fd, &st)) {
		log_warn("cannot stat %s", fname);
		return (-1);
	}
	return (0);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	if ((nfile = calloc(1, sizeof(struct file))) == NULL) {
		log_warn("%s", __func__);
		return (NULL);
	}
	if ((nfile->name = strdup(name)) == NULL) {
		log_warn("%s", __func__);
		free(nfile);
		return (NULL);
	}
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		log_warn("%s: %s", __func__, nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	if (secret &&
	    check_file_secrecy(fileno(nfile->stream), nfile->name)) {
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = malloc(nfile->ungetsize);
	if (nfile->ungetbuf == NULL) {
		log_warn("%s", __func__);
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return (file ? 0 : EOF);
}

static void
init_config(struct bgpd_config *c)
{
	u_int rdomid;

	c->min_holdtime = MIN_HOLDTIME;
	c->holdtime = INTERVAL_HOLD;
	c->connectretry = INTERVAL_CONNECTRETRY;
	c->bgpid = get_bgpid();
	c->fib_priority = kr_default_prio();
	c->default_tableid = getrtable();
	if (!ktable_exists(c->default_tableid, &rdomid))
		fatalx("current routing table %u does not exist",
		    c->default_tableid);
	if (rdomid != c->default_tableid)
		fatalx("current routing table %u is not a routing domain",
		    c->default_tableid);

	if (asprintf(&c->csock, "%s.%d", SOCKET_NAME, c->default_tableid) == -1)
		fatal(NULL);
}

struct bgpd_config *
parse_config(char *filename, struct peer_head *ph, struct rtr_config_head *rh)
{
	struct sym		*sym, *next;
	struct rde_rib		*rr;
	struct network		*n;
	int			 errors = 0;

	conf = new_config();
	init_config(conf);

	if ((filter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((peerfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((groupfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	TAILQ_INIT(filter_l);
	TAILQ_INIT(peerfilter_l);
	TAILQ_INIT(groupfilter_l);

	curpeer = NULL;
	curgroup = NULL;

	cur_peers = ph;
	cur_rtrs = rh;
	new_peers = &conf->peers;
	netconf = &conf->networks;

	if ((rr = add_rib("Adj-RIB-In")) == NULL)
		fatal("add_rib failed");
	rr->flags = F_RIB_NOFIB | F_RIB_NOEVALUATE;
	if ((rr = add_rib("Loc-RIB")) == NULL)
		fatal("add_rib failed");
	rib_add_fib(rr, conf->default_tableid);
	rr->flags = F_RIB_LOCAL;

	if ((file = pushfile(filename, 1)) == NULL)
		goto errors;
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	/* check that we dont try to announce our own routes */
	TAILQ_FOREACH(n, netconf, entry)
	    if (n->net.priority == conf->fib_priority) {
		    errors++;
		    logit(LOG_CRIT, "network priority %d == fib-priority "
			"%d is not allowed.",
			n->net.priority, conf->fib_priority);
	    }

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if ((cmd_opts & BGPD_OPT_VERBOSE2) && !sym->used)
			fprintf(stderr, "warning: macro \"%s\" not "
			    "used\n", sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (!conf->as) {
		log_warnx("configuration error: AS not given");
		errors++;
	}

	/* clear the globals */
	curpeer = NULL;
	curgroup = NULL;
	cur_peers = NULL;
	new_peers = NULL;
	netconf = NULL;
	curflow = NULL;

	if (errors) {
errors:
		while ((rr = SIMPLEQ_FIRST(&ribnames)) != NULL) {
			SIMPLEQ_REMOVE_HEAD(&ribnames, entry);
			free(rr);
		}

		filterlist_free(filter_l);
		filterlist_free(peerfilter_l);
		filterlist_free(groupfilter_l);

		free_config(conf);
		return (NULL);
	}

	/* Create default listeners if none where specified. */
	if (TAILQ_EMPTY(conf->listen_addrs)) {
		struct listen_addr *la;

		if ((la = calloc(1, sizeof(struct listen_addr))) == NULL)
			fatal("setup_listeners calloc");
		la->fd = -1;
		la->flags = DEFAULT_LISTENER;
		la->reconf = RECONF_REINIT;
		la->sa_len = sizeof(struct sockaddr_in);
		((struct sockaddr_in *)&la->sa)->sin_family = AF_INET;
		((struct sockaddr_in *)&la->sa)->sin_addr.s_addr =
		    htonl(INADDR_ANY);
		((struct sockaddr_in *)&la->sa)->sin_port = htons(BGP_PORT);
		TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);

		if ((la = calloc(1, sizeof(struct listen_addr))) == NULL)
			fatal("setup_listeners calloc");
		la->fd = -1;
		la->flags = DEFAULT_LISTENER;
		la->reconf = RECONF_REINIT;
		la->sa_len = sizeof(struct sockaddr_in6);
		((struct sockaddr_in6 *)&la->sa)->sin6_family = AF_INET6;
		((struct sockaddr_in6 *)&la->sa)->sin6_port = htons(BGP_PORT);
		TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
	}

	/* update clusterid in case it was not set explicitly */
	if ((conf->flags & BGPD_FLAG_REFLECTOR) && conf->clusterid == 0)
		conf->clusterid = conf->bgpid;

	/*
	 * Concatenate filter list and static group and peer filtersets
	 * together. Static group sets come first then peer sets
	 * last normal filter rules.
	 */
	TAILQ_CONCAT(conf->filters, groupfilter_l, entry);
	TAILQ_CONCAT(conf->filters, peerfilter_l, entry);
	TAILQ_CONCAT(conf->filters, filter_l, entry);

	optimize_filters(conf->filters);

	free(filter_l);
	free(peerfilter_l);
	free(groupfilter_l);

	return (conf);
}

int
symset(const char *nam, const char *val, int persist)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	if ((sym = calloc(1, sizeof(*sym))) == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	ret;

	if ((val = strrchr(s, '=')) == NULL)
		return (-1);
	sym = strndup(s, val - s);
	if (sym == NULL)
		fatal("%s: strndup", __func__);
	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

static int
cmpcommunity(struct community *a, struct community *b)
{
	if (a->flags > b->flags)
		return 1;
	if (a->flags < b->flags)
		return -1;
	if (a->data1 > b->data1)
		return 1;
	if (a->data1 < b->data1)
		return -1;
	if (a->data2 > b->data2)
		return 1;
	if (a->data2 < b->data2)
		return -1;
	if (a->data3 > b->data3)
		return 1;
	if (a->data3 < b->data3)
		return -1;
	return 0;
}

static int
getcommunity(char *s, int large, uint32_t *val, uint32_t *flag)
{
	long long	 max = USHRT_MAX;
	const char	*errstr;

	*flag = 0;
	*val = 0;
	if (strcmp(s, "*") == 0) {
		*flag = COMMUNITY_ANY;
		return 0;
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		return 0;
	} else if (strcmp(s, "local-as") == 0) {
		*flag = COMMUNITY_LOCAL_AS;
		return 0;
	}
	if (large)
		max = UINT_MAX;
	*val = strtonum(s, 0, max, &errstr);
	if (errstr) {
		yyerror("Community %s is %s (max: %lld)", s, errstr, max);
		return -1;
	}
	return 0;
}

static void
setcommunity(struct community *c, uint32_t as, uint32_t data,
    uint32_t asflag, uint32_t dataflag)
{
	c->flags = COMMUNITY_TYPE_BASIC;
	c->flags |= asflag << 8;
	c->flags |= dataflag << 16;
	c->data1 = as;
	c->data2 = data;
	c->data3 = 0;
}

static int
parselargecommunity(struct community *c, char *s)
{
	char *p, *q;
	uint32_t dflag1, dflag2, dflag3;

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if ((q = strchr(p, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*q++ = 0;

	if (getcommunity(s, 1, &c->data1, &dflag1) == -1 ||
	    getcommunity(p, 1, &c->data2, &dflag2) == -1 ||
	    getcommunity(q, 1, &c->data3, &dflag3) == -1)
		return (-1);
	c->flags = COMMUNITY_TYPE_LARGE;
	c->flags |= dflag1 << 8;;
	c->flags |= dflag2 << 16;;
	c->flags |= dflag3 << 24;;
	return (0);
}

int
parsecommunity(struct community *c, int type, char *s)
{
	char *p;
	uint32_t as, data, asflag, dataflag;

	if (type == COMMUNITY_TYPE_LARGE)
		return parselargecommunity(c, s);

	/* Well-known communities */
	if (strcasecmp(s, "GRACEFUL_SHUTDOWN") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_GRACEFUL_SHUTDOWN, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPORT, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_ADVERTISE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_ADVERTISE, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT_SUBCONFED") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPSUBCONFED, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_PEER") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_PEER, 0, 0);
		return (0);
	} else if (strcasecmp(s, "BLACKHOLE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_BLACKHOLE, 0, 0);
		return (0);
	}

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if (getcommunity(s, 0, &as, &asflag) == -1 ||
	    getcommunity(p, 0, &data, &dataflag) == -1)
		return (-1);
	setcommunity(c, as, data, asflag, dataflag);
	return (0);
}

static int
parsesubtype(char *name, int *type, int *subtype)
{
	const struct ext_comm_pairs *cp;
	int found = 0;

	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (strcmp(name, cp->subname) == 0) {
			if (found == 0) {
				*type = cp->type;
				*subtype = cp->subtype;
			}
			found++;
		}
	}
	if (found > 1)
		*type = -1;
	return (found);
}

static int
parseextvalue(int type, char *s, uint32_t *v, uint32_t *flag)
{
	const char	*errstr;
	char		*p;
	struct in_addr	 ip;
	uint32_t	 uvalh, uval;

	if (type != -1) {
		/* nothing */
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_TWO_AS;
	} else if (strcmp(s, "local-as") == 0) {
		*flag = COMMUNITY_LOCAL_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_TWO_AS;
	} else if ((p = strchr(s, '.')) == NULL) {
		/* AS_PLAIN number (4 or 2 byte) */
		strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr == NULL)
			type = EXT_COMMUNITY_TRANS_TWO_AS;
		else
			type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if (strchr(p + 1, '.') == NULL) {
		/* AS_DOT number (4-byte) */
		type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else {
		/* more than one dot -> IP address */
		type = EXT_COMMUNITY_TRANS_IPV4;
	}

	switch (type & EXT_COMMUNITY_VALUE) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
		uval = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		*v = uval;
		break;
	case EXT_COMMUNITY_TRANS_FOUR_AS:
		if ((p = strchr(s, '.')) == NULL) {
			uval = strtonum(s, 0, UINT_MAX, &errstr);
			if (errstr) {
				yyerror("Bad ext-community %s is %s", s,
				    errstr);
				return (-1);
			}
			*v = uval;
			break;
		}
		*p++ = '\0';
		uvalh = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		uval = strtonum(p, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", p, errstr);
			return (-1);
		}
		*v = uval | (uvalh << 16);
		break;
	case EXT_COMMUNITY_TRANS_IPV4:
		if (inet_aton(s, &ip) == 0) {
			yyerror("Bad ext-community %s not parseable", s);
			return (-1);
		}
		*v = ntohl(ip.s_addr);
		break;
	default:
		fatalx("%s: unexpected type %d", __func__, type);
	}
	return (type);
}

int
parseextcommunity(struct community *c, char *t, char *s)
{
	const struct ext_comm_pairs *cp;
	char		*p, *ep;
	uint64_t	 ullval;
	uint32_t	 uval, uval2, dflag1 = 0, dflag2 = 0;
	int		 type = 0, subtype = 0;

	if (strcmp(t, "*") == 0 && strcmp(s, "*") == 0) {
		c->flags = COMMUNITY_TYPE_EXT;
		c->flags |= COMMUNITY_ANY << 24;
		return (0);
	}
	if (parsesubtype(t, &type, &subtype) == 0) {
		yyerror("Bad ext-community unknown type");
		return (-1);
	}

	switch (type) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
	case EXT_COMMUNITY_TRANS_FOUR_AS:
	case EXT_COMMUNITY_TRANS_IPV4:
	case EXT_COMMUNITY_GEN_TWO_AS:
	case EXT_COMMUNITY_GEN_FOUR_AS:
	case EXT_COMMUNITY_GEN_IPV4:
	case -1:
		if (strcmp(s, "*") == 0) {
			dflag1 = COMMUNITY_ANY;
			break;
		}
		if ((p = strchr(s, ':')) == NULL) {
			yyerror("Bad ext-community %s", s);
			return (-1);
		}
		*p++ = '\0';
		if ((type = parseextvalue(type, s, &uval, &dflag1)) == -1)
			return (-1);

		switch (type) {
		case EXT_COMMUNITY_TRANS_TWO_AS:
		case EXT_COMMUNITY_GEN_TWO_AS:
			if (getcommunity(p, 1, &uval2, &dflag2) == -1)
				return (-1);
			break;
		case EXT_COMMUNITY_TRANS_IPV4:
		case EXT_COMMUNITY_TRANS_FOUR_AS:
		case EXT_COMMUNITY_GEN_IPV4:
		case EXT_COMMUNITY_GEN_FOUR_AS:
			if (getcommunity(p, 0, &uval2, &dflag2) == -1)
				return (-1);
			break;
		default:
			fatalx("parseextcommunity: unexpected result");
		}

		c->data1 = uval;
		c->data2 = uval2;
		break;
	case EXT_COMMUNITY_TRANS_OPAQUE:
	case EXT_COMMUNITY_TRANS_EVPN:
		if (strcmp(s, "*") == 0) {
			dflag1 = COMMUNITY_ANY;
			break;
		}
		errno = 0;
		ullval = strtoull(s, &ep, 0);
		if (s[0] == '\0' || *ep != '\0') {
			yyerror("Bad ext-community bad value");
			return (-1);
		}
		if (errno == ERANGE && ullval > EXT_COMMUNITY_OPAQUE_MAX) {
			yyerror("Bad ext-community value too big");
			return (-1);
		}
		c->data1 = ullval >> 32;
		c->data2 = ullval;
		break;
	case EXT_COMMUNITY_NON_TRANS_OPAQUE:
		if (subtype == EXT_COMMUNITY_SUBTYPE_OVS) {
			if (strcmp(s, "valid") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_VALID;
				break;
			} else if (strcmp(s, "invalid") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_INVALID;
				break;
			} else if (strcmp(s, "not-found") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_NOTFOUND;
				break;
			} else if (strcmp(s, "*") == 0) {
				dflag1 = COMMUNITY_ANY;
				break;
			}
		}
		yyerror("Bad ext-community %s", s);
		return (-1);
	}

	c->data3 = type << 8 | subtype;

	/* special handling of ext-community rt * since type is not known */
	if (dflag1 == COMMUNITY_ANY && type == -1) {
		c->flags = COMMUNITY_TYPE_EXT;
		c->flags |= dflag1 << 8;
		return (0);
	}

	/* verify type/subtype combo */
	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (cp->type == type && cp->subtype == subtype) {
			c->flags = COMMUNITY_TYPE_EXT;
			c->flags |= dflag1 << 8;
			c->flags |= dflag2 << 16;
			return (0);
		}
	}

	yyerror("Bad ext-community bad format for type");
	return (-1);
}

struct peer *
alloc_peer(void)
{
	struct peer	*p;
	uint8_t		 i;

	if ((p = calloc(1, sizeof(struct peer))) == NULL)
		fatal("new_peer");

	/* some sane defaults */
	p->state = STATE_NONE;
	p->reconf_action = RECONF_REINIT;
	p->conf.distance = 1;
	p->conf.export_type = EXPORT_UNSET;
	p->conf.announce_capa = 1;
	for (i = 0; i < AID_MAX; i++)
		p->conf.capabilities.mp[i] = 0;
	p->conf.capabilities.refresh = 1;
	p->conf.capabilities.grestart.restart = 1;
	p->conf.capabilities.as4byte = 1;
	p->conf.capabilities.policy = 1;
	p->conf.local_as = conf->as;
	p->conf.local_short_as = conf->short_as;
	p->conf.remote_port = BGP_PORT;

	if (conf->flags & BGPD_FLAG_DECISION_TRANS_AS)
		p->conf.flags |= PEERFLAG_TRANS_AS;
	if (conf->flags & BGPD_FLAG_DECISION_ALL_PATHS)
		p->conf.flags |= PEERFLAG_EVALUATE_ALL;
	if (conf->flags & BGPD_FLAG_NO_AS_SET)
		p->conf.flags |= PEERFLAG_NO_AS_SET;

	return (p);
}

struct peer *
new_peer(void)
{
	struct peer		*p;

	p = alloc_peer();

	if (curgroup != NULL) {
		memcpy(p, curgroup, sizeof(struct peer));
		p->conf.groupid = curgroup->conf.id;
	}
	return (p);
}

struct peer *
new_group(void)
{
	return (alloc_peer());
}

int
add_mrtconfig(enum mrt_type type, char *name, int timeout, struct peer *p,
    char *rib)
{
	struct mrt	*m, *n;

	LIST_FOREACH(m, conf->mrt, entry) {
		if ((rib && strcmp(rib, m->rib)) ||
		    (!rib && *m->rib))
			continue;
		if (p == NULL) {
			if (m->peer_id != 0 || m->group_id != 0)
				continue;
		} else {
			if (m->peer_id != p->conf.id ||
			    m->group_id != p->conf.groupid)
				continue;
		}
		if (m->type == type) {
			yyerror("only one mrtdump per type allowed.");
			return (-1);
		}
	}

	if ((n = calloc(1, sizeof(struct mrt_config))) == NULL)
		fatal("add_mrtconfig");

	n->type = type;
	n->state = MRT_STATE_OPEN;
	if (strlcpy(MRT2MC(n)->name, name, sizeof(MRT2MC(n)->name)) >=
	    sizeof(MRT2MC(n)->name)) {
		yyerror("filename \"%s\" too long: max %zu",
		    name, sizeof(MRT2MC(n)->name) - 1);
		free(n);
		return (-1);
	}
	MRT2MC(n)->ReopenTimerInterval = timeout;
	if (p != NULL) {
		if (curgroup == p) {
			n->peer_id = 0;
			n->group_id = p->conf.id;
		} else {
			n->peer_id = p->conf.id;
			n->group_id = p->conf.groupid;
		}
	}
	if (rib) {
		if (!find_rib(rib)) {
			yyerror("rib \"%s\" does not exist.", rib);
			free(n);
			return (-1);
		}
		if (strlcpy(n->rib, rib, sizeof(n->rib)) >=
		    sizeof(n->rib)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(n->rib) - 1);
			free(n);
			return (-1);
		}
	}

	LIST_INSERT_HEAD(conf->mrt, n, entry);

	return (0);
}

struct rde_rib *
add_rib(char *name)
{
	struct rde_rib	*rr;

	if ((rr = find_rib(name)) == NULL) {
		if ((rr = calloc(1, sizeof(*rr))) == NULL) {
			log_warn("add_rib");
			return (NULL);
		}
		if (strlcpy(rr->name, name, sizeof(rr->name)) >=
		    sizeof(rr->name)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(rr->name) - 1);
			free(rr);
			return (NULL);
		}
		rr->flags = F_RIB_NOFIB;
		SIMPLEQ_INSERT_TAIL(&ribnames, rr, entry);
	}
	return (rr);
}

struct rde_rib *
find_rib(char *name)
{
	struct rde_rib	*rr;

	SIMPLEQ_FOREACH(rr, &ribnames, entry) {
		if (!strcmp(rr->name, name))
			return (rr);
	}
	return (NULL);
}

int
rib_add_fib(struct rde_rib *rr, u_int rtableid)
{
	u_int	rdom;

	if (!ktable_exists(rtableid, &rdom)) {
		yyerror("rtable id %u does not exist", rtableid);
		return (-1);
	}
	/*
	 * conf->default_tableid is also a rdomain because that is checked
	 * in init_config()
	 */
	if (rdom != conf->default_tableid) {
		log_warnx("rtable %u does not belong to rdomain %u",
		    rtableid, conf->default_tableid);
		return (-1);
	}
	rr->rtableid = rtableid;
	rr->flags &= ~F_RIB_NOFIB;
	return (0);
}

struct prefixset *
find_prefixset(char *name, struct prefixset_head *p)
{
	struct prefixset *ps;

	SIMPLEQ_FOREACH(ps, p, entry) {
		if (!strcmp(ps->name, name))
			return (ps);
	}
	return (NULL);
}

int
get_id(struct peer *newpeer)
{
	static uint32_t id = PEER_ID_STATIC_MIN;
	struct peer	*p = NULL;

	/* check if the peer already existed before */
	if (newpeer->conf.remote_addr.aid) {
		/* neighbor */
		if (cur_peers)
			RB_FOREACH(p, peer_head, cur_peers)
				if (p->conf.remote_masklen ==
				    newpeer->conf.remote_masklen &&
				    memcmp(&p->conf.remote_addr,
				    &newpeer->conf.remote_addr,
				    sizeof(p->conf.remote_addr)) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.id;
			return (0);
		}
	} else {
		/* group */
		if (cur_peers)
			RB_FOREACH(p, peer_head, cur_peers)
				if (strcmp(p->conf.group,
				    newpeer->conf.group) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.groupid;
			return (0);
		}
	}

	/* else new one */
	if (id < PEER_ID_STATIC_MAX) {
		newpeer->conf.id = id++;
		return (0);
	}

	return (-1);
}

int
merge_prefixspec(struct filter_prefix *p, struct filter_prefixlen *pl)
{
	uint8_t max_len = 0;

	switch (p->addr.aid) {
	case AID_INET:
	case AID_VPN_IPv4:
		max_len = 32;
		break;
	case AID_INET6:
	case AID_VPN_IPv6:
		max_len = 128;
		break;
	}

	if (pl->op == OP_NONE) {
		p->len_min = p->len_max = p->len;
		return (0);
	}

	if (pl->len_min == -1)
		pl->len_min = p->len;
	if (pl->len_max == -1)
		pl->len_max = max_len;

	if (pl->len_max > max_len) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_max, max_len);
		return (-1);
	}
	if (pl->len_min > pl->len_max) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_min, pl->len_max);
		return (-1);
	}
	if (pl->len_min < p->len) {
		yyerror("prefixlen %d smaller than prefix, limit %d",
		    pl->len_min, p->len);
		return (-1);
	}

	p->op = pl->op;
	p->len_min = pl->len_min;
	p->len_max = pl->len_max;
	return (0);
}

int
expand_rule(struct filter_rule *rule, struct filter_rib_l *rib,
    struct filter_peers_l *peer, struct filter_match_l *match,
    struct filter_set_head *set)
{
	struct filter_rule	*r;
	struct filter_rib_l	*rb, *rbnext;
	struct filter_peers_l	*p, *pnext;
	struct filter_prefix_l	*prefix, *prefix_next;
	struct filter_as_l	*a, *anext;
	struct filter_set	*s;

	rb = rib;
	do {
		p = peer;
		do {
			a = match->as_l;
			do {
				prefix = match->prefix_l;
				do {
					if ((r = calloc(1,
					    sizeof(struct filter_rule))) ==
						 NULL) {
						log_warn("expand_rule");
						return (-1);
					}

					memcpy(r, rule, sizeof(struct filter_rule));
					memcpy(&r->match, match,
					    sizeof(struct filter_match));
					filterset_copy(set, &r->set);

					if (rb != NULL)
						strlcpy(r->rib, rb->name,
						    sizeof(r->rib));

					if (p != NULL)
						memcpy(&r->peer, &p->p,
						    sizeof(struct filter_peers));

					if (prefix != NULL)
						memcpy(&r->match.prefix, &prefix->p,
						    sizeof(r->match.prefix));

					if (a != NULL)
						memcpy(&r->match.as, &a->a,
						    sizeof(struct filter_as));

					TAILQ_INSERT_TAIL(filter_l, r, entry);

					if (prefix != NULL)
						prefix = prefix->next;
				} while (prefix != NULL);

				if (a != NULL)
					a = a->next;
			} while (a != NULL);

			if (p != NULL)
				p = p->next;
		} while (p != NULL);

		if (rb != NULL)
			rb = rb->next;
	} while (rb != NULL);

	for (rb = rib; rb != NULL; rb = rbnext) {
		rbnext = rb->next;
		free(rb);
	}

	for (p = peer; p != NULL; p = pnext) {
		pnext = p->next;
		free(p);
	}

	for (a = match->as_l; a != NULL; a = anext) {
		anext = a->next;
		free(a);
	}

	for (prefix = match->prefix_l; prefix != NULL; prefix = prefix_next) {
		prefix_next = prefix->next;
		free(prefix);
	}

	if (set != NULL) {
		while ((s = TAILQ_FIRST(set)) != NULL) {
			TAILQ_REMOVE(set, s, entry);
			free(s);
		}
		free(set);
	}

	return (0);
}

int
str2key(char *s, char *dest, size_t max_len)
{
	unsigned	i;
	char		t[3];

	if (strlen(s) / 2 > max_len) {
		yyerror("key too long");
		return (-1);
	}

	if (strlen(s) % 2) {
		yyerror("key must be of even length");
		return (-1);
	}

	for (i = 0; i < strlen(s) / 2; i++) {
		t[0] = s[2*i];
		t[1] = s[2*i + 1];
		t[2] = 0;
		if (!isxdigit(t[0]) || !isxdigit(t[1])) {
			yyerror("key must be specified in hex");
			return (-1);
		}
		dest[i] = strtoul(t, NULL, 16);
	}

	return (0);
}

int
neighbor_consistent(struct peer *p)
{
	struct bgpd_addr *local_addr;
	struct peer *xp;

	switch (p->conf.remote_addr.aid) {
	case AID_INET:
		local_addr = &p->conf.local_addr_v4;
		break;
	case AID_INET6:
		local_addr = &p->conf.local_addr_v6;
		break;
	default:
		yyerror("Bad address family for remote-addr");
		return (-1);
	}

	/* with any form of ipsec local-address is required */
	if ((p->conf.auth.method == AUTH_IPSEC_IKE_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_IKE_AH ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    local_addr->aid == AID_UNSPEC) {
		yyerror("neighbors with any form of IPsec configured "
		    "need local-address to be specified");
		return (-1);
	}

	/* with static keying we need both directions */
	if ((p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    (!p->conf.auth.spi_in || !p->conf.auth.spi_out)) {
		yyerror("with manual keyed IPsec, SPIs and keys "
		    "for both directions are required");
		return (-1);
	}

	if (!conf->as) {
		yyerror("AS needs to be given before neighbor definitions");
		return (-1);
	}

	/* set default values if they where undefined */
	p->conf.ebgp = (p->conf.remote_as != conf->as);
	if (p->conf.enforce_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_as = p->conf.ebgp ?
		    ENFORCE_AS_ON : ENFORCE_AS_OFF;
	if (p->conf.enforce_local_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_local_as = ENFORCE_AS_ON;

	if (p->conf.remote_as == 0 && !p->conf.template) {
		yyerror("peer AS may not be zero");
		return (-1);
	}

	/* EBGP neighbors are not allowed in route reflector clusters */
	if (p->conf.reflector_client && p->conf.ebgp) {
		yyerror("EBGP neighbors are not allowed in route "
		    "reflector clusters");
		return (-1);
	}

	/* BGP role and RFC 9234 role are only valid for EBGP neighbors */
	if (!p->conf.ebgp) {
		p->conf.role = ROLE_NONE;
		p->conf.capabilities.policy = 0;
	} else if (p->conf.role == ROLE_NONE) {
		/* no role, no policy capability */
		p->conf.capabilities.policy = 0;
	}

	/* check for duplicate peer definitions */
	RB_FOREACH(xp, peer_head, new_peers)
		if (xp->conf.remote_masklen ==
		    p->conf.remote_masklen &&
		    memcmp(&xp->conf.remote_addr,
		    &p->conf.remote_addr,
		    sizeof(p->conf.remote_addr)) == 0)
			break;
	if (xp != NULL) {
		char *descr = log_fmt_peer(&p->conf);
		yyerror("duplicate %s", descr);
		free(descr);
		return (-1);
	}

	return (0);
}

static void
filterset_add(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		if (s->type < t->type) {
			TAILQ_INSERT_BEFORE(t, s, entry);
			return;
		}
		if (s->type == t->type) {
			switch (s->type) {
			case ACTION_SET_COMMUNITY:
			case ACTION_DEL_COMMUNITY:
				switch (cmpcommunity(&s->action.community,
				    &t->action.community)) {
				case -1:
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				case 0:
					break;
				case 1:
					continue;
				}
				break;
			case ACTION_SET_NEXTHOP:
				/* only last nexthop per AF matters */
				if (s->action.nexthop.aid <
				    t->action.nexthop.aid) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				} else if (s->action.nexthop.aid ==
				    t->action.nexthop.aid) {
					t->action.nexthop = s->action.nexthop;
					break;
				}
				continue;
			case ACTION_SET_NEXTHOP_BLACKHOLE:
			case ACTION_SET_NEXTHOP_REJECT:
			case ACTION_SET_NEXTHOP_NOMODIFY:
			case ACTION_SET_NEXTHOP_SELF:
				/* set it only once */
				break;
			case ACTION_SET_LOCALPREF:
			case ACTION_SET_MED:
			case ACTION_SET_WEIGHT:
				/* only last set matters */
				t->action.metric = s->action.metric;
				break;
			case ACTION_SET_RELATIVE_LOCALPREF:
			case ACTION_SET_RELATIVE_MED:
			case ACTION_SET_RELATIVE_WEIGHT:
				/* sum all relative numbers */
				t->action.relative += s->action.relative;
				break;
			case ACTION_SET_ORIGIN:
				/* only last set matters */
				t->action.origin = s->action.origin;
				break;
			case ACTION_PFTABLE:
				/* only last set matters */
				strlcpy(t->action.pftable, s->action.pftable,
				    sizeof(t->action.pftable));
				break;
			case ACTION_RTLABEL:
				/* only last set matters */
				strlcpy(t->action.rtlabel, s->action.rtlabel,
				    sizeof(t->action.rtlabel));
				break;
			default:
				break;
			}
			free(s);
			return;
		}
	}

	TAILQ_INSERT_TAIL(sh, s, entry);
}

int
merge_filterset(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		/*
		 * need to cycle across the full list because even
		 * if types are not equal filterset_cmp() may return 0.
		 */
		if (filterset_cmp(s, t) == 0) {
			if (s->type == ACTION_SET_COMMUNITY)
				yyerror("community is already set");
			else if (s->type == ACTION_DEL_COMMUNITY)
				yyerror("community will already be deleted");
			else
				yyerror("redefining set parameter %s",
				    filterset_name(s->type));
			return (-1);
		}
	}

	filterset_add(sh, s);
	return (0);
}

static int
filter_equal(struct filter_rule *fa, struct filter_rule *fb)
{
	if (fa == NULL || fb == NULL)
		return 0;
	if (fa->action != fb->action || fa->quick != fb->quick ||
	    fa->dir != fb->dir)
		return 0;
	if (memcmp(&fa->peer, &fb->peer, sizeof(fa->peer)))
		return 0;
	if (memcmp(&fa->match, &fb->match, sizeof(fa->match)))
		return 0;

	return 1;
}

/* do a basic optimization by folding equal rules together */
void
optimize_filters(struct filter_head *fh)
{
	struct filter_rule *r, *nr;

	TAILQ_FOREACH_SAFE(r, fh, entry, nr) {
		while (filter_equal(r, nr)) {
			struct filter_set	*t;

			while ((t = TAILQ_FIRST(&nr->set)) != NULL) {
				TAILQ_REMOVE(&nr->set, t, entry);
				filterset_add(&r->set, t);
			}

			TAILQ_REMOVE(fh, nr, entry);
			free(nr);
			nr = TAILQ_NEXT(r, entry);
		}
	}
}

struct filter_rule *
get_rule(enum action_types type)
{
	struct filter_rule	*r;
	int			 out;

	switch (type) {
	case ACTION_SET_PREPEND_SELF:
	case ACTION_SET_NEXTHOP_NOMODIFY:
	case ACTION_SET_NEXTHOP_SELF:
		out = 1;
		break;
	default:
		out = 0;
		break;
	}
	r = (curpeer == curgroup) ? curgroup_filter[out] : curpeer_filter[out];
	if (r == NULL) {
		if ((r = calloc(1, sizeof(struct filter_rule))) == NULL)
			fatal(NULL);
		r->quick = 0;
		r->dir = out ? DIR_OUT : DIR_IN;
		r->action = ACTION_NONE;
		TAILQ_INIT(&r->set);
		if (curpeer == curgroup) {
			/* group */
			r->peer.groupid = curgroup->conf.id;
			curgroup_filter[out] = r;
		} else {
			/* peer */
			r->peer.peerid = curpeer->conf.id;
			curpeer_filter[out] = r;
		}
	}
	return (r);
}

struct set_table *curset;
static int
new_as_set(char *name)
{
	struct as_set *aset;

	if (as_sets_lookup(&conf->as_sets, name) != NULL) {
		yyerror("as-set \"%s\" already exists", name);
		return -1;
	}

	aset = as_sets_new(&conf->as_sets, name, 0, sizeof(uint32_t));
	if (aset == NULL)
		fatal(NULL);

	curset = aset->set;
	return 0;
}

static void
add_as_set(uint32_t as)
{
	if (curset == NULL)
		fatalx("%s: bad mojo jojo", __func__);

	if (set_add(curset, &as, 1) != 0)
		fatal(NULL);
}

static void
done_as_set(void)
{
	curset = NULL;
}

static struct prefixset *
new_prefix_set(char *name, int is_roa)
{
	const char *type = "prefix-set";
	struct prefixset_head *sets = &conf->prefixsets;
	struct prefixset *pset;

	if (is_roa) {
		type = "origin-set";
		sets = &conf->originsets;
	}

	if (find_prefixset(name, sets) != NULL) {
		yyerror("%s \"%s\" already exists", type, name);
		return NULL;
	}
	if ((pset = calloc(1, sizeof(*pset))) == NULL)
		fatal("prefixset");
	if (strlcpy(pset->name, name, sizeof(pset->name)) >=
	    sizeof(pset->name)) {
		yyerror("%s \"%s\" too long: max %zu", type,
		    name, sizeof(pset->name) - 1);
		free(pset);
		return NULL;
	}
	RB_INIT(&pset->psitems);
	RB_INIT(&pset->roaitems);
	return pset;
}

static void
add_roa_set(struct prefixset_item *npsi, uint32_t as, uint8_t max,
    time_t expires)
{
	struct roa *roa, *r;

	if ((roa = calloc(1, sizeof(*roa))) == NULL)
		fatal("add_roa_set");

	roa->aid = npsi->p.addr.aid;
	roa->prefixlen = npsi->p.len;
	roa->maxlen = max;
	roa->asnum = as;
	roa->expires = expires;
	switch (roa->aid) {
	case AID_INET:
		roa->prefix.inet = npsi->p.addr.v4;
		break;
	case AID_INET6:
		roa->prefix.inet6 = npsi->p.addr.v6;
		break;
	default:
		fatalx("Bad address family for roa_set address");
	}

	r = RB_INSERT(roa_tree, curroatree, roa);
	if (r != NULL) {
		/* just ignore duplicates */
		if (r->expires != 0 && expires != 0 && expires > r->expires)
			r->expires = expires;
		free(roa);
	}
}

static struct rtr_config *
get_rtr(struct bgpd_addr *addr)
{
	struct rtr_config *n;

	n = calloc(1, sizeof(*n));
	if (n == NULL) {
		yyerror("out of memory");
		return NULL;
	}

	n->remote_addr = *addr;
	strlcpy(n->descr, log_addr(addr), sizeof(currtr->descr));

	return n;
}

static int
insert_rtr(struct rtr_config *new)
{
	static uint32_t id;
	struct rtr_config *r;

	if (id == UINT32_MAX) {
		yyerror("out of rtr session IDs");
		return -1;
	}

	SIMPLEQ_FOREACH(r, &conf->rtrs, entry)
		if (memcmp(&r->remote_addr, &new->remote_addr,
		    sizeof(r->remote_addr)) == 0 &&
		    r->remote_port == new->remote_port) {
			yyerror("duplicate rtr session to %s:%u",
			    log_addr(&new->remote_addr), new->remote_port);
			return -1;
		}

	if (cur_rtrs)
		SIMPLEQ_FOREACH(r, cur_rtrs, entry)
			if (memcmp(&r->remote_addr, &new->remote_addr,
			    sizeof(r->remote_addr)) == 0 &&
			    r->remote_port == new->remote_port) {
				new->id = r->id;
				break;
			}

	if (new->id == 0)
		new->id = ++id;

	SIMPLEQ_INSERT_TAIL(&conf->rtrs, currtr, entry);

	return 0;
}

static int
merge_aspa_set(uint32_t as, struct aspa_tas_l *tas, time_t expires)
{
	struct aspa_set	*aspa, needle = { .as = as };
	uint32_t i, num, *newtas;

	aspa = RB_FIND(aspa_tree, &conf->aspa, &needle);
	if (aspa == NULL) {
		if ((aspa = calloc(1, sizeof(*aspa))) == NULL) {
			yyerror("out of memory");
			return -1;
		}
		aspa->as = as;
		aspa->expires = expires;
		RB_INSERT(aspa_tree, &conf->aspa, aspa);
	}

	if (UINT32_MAX - aspa->num <= tas->num) {
		yyerror("aspa_set overflow");
		return -1;
	}
	num = aspa->num + tas->num;
	newtas = recallocarray(aspa->tas, aspa->num, num, sizeof(uint32_t));
	if (newtas == NULL) {
		yyerror("out of memory");
		return -1;
	}
	/* fill starting at the end since the tas list is reversed */
	if (num > 0) {
		for (i = num - 1; tas; tas = tas->next, i--)
			newtas[i] = tas->as;
	}

	aspa->num = num;
	aspa->tas = newtas;
	/* take the longest expiry time, same logic as for ROA entries */
	if (aspa->expires != 0 && expires != 0 && expires > aspa->expires)
		aspa->expires = expires;

	return 0;
}

static int
kw_casecmp(const void *k, const void *e)
{
	return (strcasecmp(k, ((const struct keywords *)e)->k_name));
}

static int
map_tos(char *s, int *val)
{
	/* DiffServ Codepoints and other TOS mappings */
	const struct keywords	 toswords[] = {
		{ "af11",		IPTOS_DSCP_AF11 },
		{ "af12",		IPTOS_DSCP_AF12 },
		{ "af13",		IPTOS_DSCP_AF13 },
		{ "af21",		IPTOS_DSCP_AF21 },
		{ "af22",		IPTOS_DSCP_AF22 },
		{ "af23",		IPTOS_DSCP_AF23 },
		{ "af31",		IPTOS_DSCP_AF31 },
		{ "af32",		IPTOS_DSCP_AF32 },
		{ "af33",		IPTOS_DSCP_AF33 },
		{ "af41",		IPTOS_DSCP_AF41 },
		{ "af42",		IPTOS_DSCP_AF42 },
		{ "af43",		IPTOS_DSCP_AF43 },
		{ "critical",		IPTOS_PREC_CRITIC_ECP },
		{ "cs0",		IPTOS_DSCP_CS0 },
		{ "cs1",		IPTOS_DSCP_CS1 },
		{ "cs2",		IPTOS_DSCP_CS2 },
		{ "cs3",		IPTOS_DSCP_CS3 },
		{ "cs4",		IPTOS_DSCP_CS4 },
		{ "cs5",		IPTOS_DSCP_CS5 },
		{ "cs6",		IPTOS_DSCP_CS6 },
		{ "cs7",		IPTOS_DSCP_CS7 },
		{ "ef",			IPTOS_DSCP_EF },
		{ "inetcontrol",	IPTOS_PREC_INTERNETCONTROL },
		{ "lowdelay",		IPTOS_LOWDELAY },
		{ "netcontrol",		IPTOS_PREC_NETCONTROL },
		{ "reliability",	IPTOS_RELIABILITY },
		{ "throughput",		IPTOS_THROUGHPUT }
	};
	const struct keywords	*p;

	p = bsearch(s, toswords, nitems(toswords), sizeof(toswords[0]),
	    kw_casecmp);

	if (p) {
		*val = p->k_val;
		return (1);
	}
	return (0);
}

static int
getservice(char *n)
{
	struct servent	*s;

	s = getservbyname(n, "tcp");
	if (s == NULL)
		s = getservbyname(n, "udp");
	if (s == NULL)
		return -1;
	return s->s_port;
}

static int
parse_flags(char *s)
{
	const char *flags = FLOWSPEC_TCP_FLAG_STRING;
	char *p, *q;
	uint8_t f = 0;

	if (curflow->type == FLOWSPEC_TYPE_FRAG) {
		if (curflow->aid == AID_INET)
			flags = FLOWSPEC_FRAG_STRING4;
		else
			flags = FLOWSPEC_FRAG_STRING6;
	}

	for (p = s; *p; p++) {
		if ((q = strchr(flags, *p)) == NULL)
			return -1;
		f |= 1 << (q - flags);
	}
	return (f ? f : 0xff);
}

static void
component_finish(int type, uint8_t *data, int len)
{
	uint8_t *last;
	int i;

	switch (type) {
	case FLOWSPEC_TYPE_DEST:
	case FLOWSPEC_TYPE_SOURCE:
		/* nothing to do */
		return;
	default:
		break;
	}

	i = 0;
	do {
		last = data + i;
		i += FLOWSPEC_OP_LEN(*last) + 1;
	} while (i < len);
	*last |= FLOWSPEC_OP_EOL;
}

static struct flowspec_config *
flow_to_flowspec(struct flowspec_context *ctx)
{
	struct flowspec_config *f;
	int i, len = 0;
	uint8_t aid;

	switch (ctx->aid) {
	case AID_INET:
		aid = AID_FLOWSPECv4;
		break;
	case AID_INET6:
		aid = AID_FLOWSPECv6;
		break;
	default:
		return NULL;
	}

	for (i = FLOWSPEC_TYPE_MIN; i < FLOWSPEC_TYPE_MAX; i++)
		if (ctx->components[i] != NULL)
			len += ctx->complen[i] + 1;

	f = flowspec_alloc(aid, len);
	if (f == NULL)
		return NULL;

	len = 0;
	for (i = FLOWSPEC_TYPE_MIN; i < FLOWSPEC_TYPE_MAX; i++)
		if (ctx->components[i] != NULL) {
			f->flow->data[len++] = i;
			component_finish(i, ctx->components[i],
			    ctx->complen[i]);
			memcpy(f->flow->data + len, ctx->components[i],
			    ctx->complen[i]);
			len += ctx->complen[i];
		}

	return f;
}

static void
flow_free(struct flowspec_context *ctx)
{
	int i;

	for (i = 0; i < FLOWSPEC_TYPE_MAX; i++)
		free(ctx->components[i]);
	free(ctx);
}

static int
push_prefix(struct bgpd_addr *addr, uint8_t len)
{
	void *data;
	uint8_t *comp;
	int complen, l;

	if (curflow->components[curflow->addr_type] != NULL) {
		yyerror("flowspec address already set");
		return -1;
	}

	if (curflow->aid != addr->aid) {
		yyerror("wrong address family for flowspec address");
		return -1;
	}

	switch (curflow->aid) {
	case AID_INET:
		complen = PREFIX_SIZE(len);
		data = &addr->v4;
		break;
	case AID_INET6:
		/* IPv6 includes an offset byte */
		complen = PREFIX_SIZE(len) + 1;
		data = &addr->v6;
		break;
	default:
		yyerror("unsupported address family for flowspec address");
		return -1;
	}
	comp = malloc(complen);
	if (comp == NULL) {
		yyerror("out of memory");
		return -1;
	}

	l = 0;
	comp[l++] = len;
	if (curflow->aid == AID_INET6)
		comp[l++] = 0;
	memcpy(comp + l, data, complen - l);

	curflow->complen[curflow->addr_type] = complen;
	curflow->components[curflow->addr_type] = comp;

	return 0;
}

static int
push_binop(uint8_t binop, long long val)
{
	uint8_t *comp;
	int complen;
	uint8_t u8;

	if (val < 0 || val > 0xff) {
		yyerror("unsupported value for flowspec bin_op");
		return -1;
	}
	u8 = val;

	complen = curflow->complen[curflow->type];
	comp = realloc(curflow->components[curflow->type],
	    complen + 2);
	if (comp == NULL) {
		yyerror("out of memory");
		return -1;
	}

	comp[complen++] = binop;
	comp[complen++] = u8;
	curflow->complen[curflow->type] = complen;
	curflow->components[curflow->type] = comp;

	return 0;
}

static uint8_t
component_numop(enum comp_ops op, int and, int len)
{
	uint8_t flag = 0;

	switch (op) {
	case OP_EQ:
		flag |= FLOWSPEC_OP_NUM_EQ;
		break;
	case OP_NE:
		flag |= FLOWSPEC_OP_NUM_NOT;
		break;
	case OP_LE:
		flag |= FLOWSPEC_OP_NUM_LE;
		break;
	case OP_LT:
		flag |= FLOWSPEC_OP_NUM_LT;
		break;
	case OP_GE:
		flag |= FLOWSPEC_OP_NUM_GE;
		break;
	case OP_GT:
		flag |= FLOWSPEC_OP_NUM_GT;
		break;
	default:
		fatalx("unsupported op");
	}

	switch (len) {
	case 2:
		flag |= 1 << FLOWSPEC_OP_LEN_SHIFT;
		break;
	case 4:
		flag |= 2 << FLOWSPEC_OP_LEN_SHIFT;
		break;
	case 8:
		flag |= 3 << FLOWSPEC_OP_LEN_SHIFT;
		break;
	}

	if (and)
		flag |= FLOWSPEC_OP_AND;

	return flag;
}

static int
push_numop(enum comp_ops op, int and, long long val)
{
	uint8_t *comp;
	void *data;
	uint32_t u32;
	uint16_t u16;
	uint8_t u8;
	int len, complen;

	if (val < 0 || val > 0xffffffff) {
		yyerror("unsupported value for flowspec num_op");
		return -1;
	} else if (val <= 255) {
		len = 1;
		u8 = val;
		data = &u8;
	} else if (val <= 0xffff) {
		len = 2;
		u16 = htons(val);
		data = &u16;
	} else {
		len = 4;
		u32 = htonl(val);
		data = &u32;
	}

	complen = curflow->complen[curflow->type];
	comp = realloc(curflow->components[curflow->type],
	    complen + len + 1);
	if (comp == NULL) {
		yyerror("out of memory");
		return -1;
	}

	comp[complen++] = component_numop(op, and, len);
	memcpy(comp + complen, data, len);
	complen += len;
	curflow->complen[curflow->type] = complen;
	curflow->components[curflow->type] = comp;

	return 0;
}

static int
push_unary_numop(enum comp_ops op, long long val)
{
	return push_numop(op, 0, val);
}

static int
push_binary_numop(enum comp_ops op, long long min, long long max)
{
	switch (op) {
	case OP_RANGE:
		if (push_numop(OP_GE, 0, min) == -1)
			return -1;
		return push_numop(OP_LE, 1, max);
	case OP_XRANGE:
		if (push_numop(OP_LT, 0, min) == -1)
			return -1;
		return push_numop(OP_GT, 0, max);
	default:
		yyerror("unsupported binary flowspec num_op");
		return -1;
	}
}

struct icmptypeent {
	const char *name;
	u_int8_t type;
};

struct icmpcodeent {
	const char *name;
	u_int8_t type;
	u_int8_t code;
};

static const struct icmptypeent icmp_type[] = {
	{ "echoreq",	ICMP_ECHO },
	{ "echorep",	ICMP_ECHOREPLY },
	{ "unreach",	ICMP_UNREACH },
	{ "squench",	ICMP_SOURCEQUENCH },
	{ "redir",	ICMP_REDIRECT },
	{ "althost",	ICMP_ALTHOSTADDR },
	{ "routeradv",	ICMP_ROUTERADVERT },
	{ "routersol",	ICMP_ROUTERSOLICIT },
	{ "timex",	ICMP_TIMXCEED },
	{ "paramprob",	ICMP_PARAMPROB },
	{ "timereq",	ICMP_TSTAMP },
	{ "timerep",	ICMP_TSTAMPREPLY },
	{ "inforeq",	ICMP_IREQ },
	{ "inforep",	ICMP_IREQREPLY },
	{ "maskreq",	ICMP_MASKREQ },
	{ "maskrep",	ICMP_MASKREPLY },
	{ "trace",	ICMP_TRACEROUTE },
	{ "dataconv",	ICMP_DATACONVERR },
	{ "mobredir",	ICMP_MOBILE_REDIRECT },
	{ "ipv6-where",	ICMP_IPV6_WHEREAREYOU },
	{ "ipv6-here",	ICMP_IPV6_IAMHERE },
	{ "mobregreq",	ICMP_MOBILE_REGREQUEST },
	{ "mobregrep",	ICMP_MOBILE_REGREPLY },
	{ "skip",	ICMP_SKIP },
	{ "photuris",	ICMP_PHOTURIS }
};

static const struct icmptypeent icmp6_type[] = {
	{ "unreach",	ICMP6_DST_UNREACH },
	{ "toobig",	ICMP6_PACKET_TOO_BIG },
	{ "timex",	ICMP6_TIME_EXCEEDED },
	{ "paramprob",	ICMP6_PARAM_PROB },
	{ "echoreq",	ICMP6_ECHO_REQUEST },
	{ "echorep",	ICMP6_ECHO_REPLY },
	{ "groupqry",	ICMP6_MEMBERSHIP_QUERY },
	{ "listqry",	MLD_LISTENER_QUERY },
	{ "grouprep",	ICMP6_MEMBERSHIP_REPORT },
	{ "listenrep",	MLD_LISTENER_REPORT },
	{ "groupterm",	ICMP6_MEMBERSHIP_REDUCTION },
	{ "listendone", MLD_LISTENER_DONE },
	{ "routersol",	ND_ROUTER_SOLICIT },
	{ "routeradv",	ND_ROUTER_ADVERT },
	{ "neighbrsol", ND_NEIGHBOR_SOLICIT },
	{ "neighbradv", ND_NEIGHBOR_ADVERT },
	{ "redir",	ND_REDIRECT },
	{ "routrrenum", ICMP6_ROUTER_RENUMBERING },
	{ "wrureq",	ICMP6_WRUREQUEST },
	{ "wrurep",	ICMP6_WRUREPLY },
	{ "fqdnreq",	ICMP6_FQDN_QUERY },
	{ "fqdnrep",	ICMP6_FQDN_REPLY },
	{ "niqry",	ICMP6_NI_QUERY },
	{ "nirep",	ICMP6_NI_REPLY },
	{ "mtraceresp",	MLD_MTRACE_RESP },
	{ "mtrace",	MLD_MTRACE },
	{ "listenrepv2", MLDV2_LISTENER_REPORT },
};

static const struct icmpcodeent icmp_code[] = {
	{ "net-unr",		ICMP_UNREACH,	ICMP_UNREACH_NET },
	{ "host-unr",		ICMP_UNREACH,	ICMP_UNREACH_HOST },
	{ "proto-unr",		ICMP_UNREACH,	ICMP_UNREACH_PROTOCOL },
	{ "port-unr",		ICMP_UNREACH,	ICMP_UNREACH_PORT },
	{ "needfrag",		ICMP_UNREACH,	ICMP_UNREACH_NEEDFRAG },
	{ "srcfail",		ICMP_UNREACH,	ICMP_UNREACH_SRCFAIL },
	{ "net-unk",		ICMP_UNREACH,	ICMP_UNREACH_NET_UNKNOWN },
	{ "host-unk",		ICMP_UNREACH,	ICMP_UNREACH_HOST_UNKNOWN },
	{ "isolate",		ICMP_UNREACH,	ICMP_UNREACH_ISOLATED },
	{ "net-prohib",		ICMP_UNREACH,	ICMP_UNREACH_NET_PROHIB },
	{ "host-prohib",	ICMP_UNREACH,	ICMP_UNREACH_HOST_PROHIB },
	{ "net-tos",		ICMP_UNREACH,	ICMP_UNREACH_TOSNET },
	{ "host-tos",		ICMP_UNREACH,	ICMP_UNREACH_TOSHOST },
	{ "filter-prohib",	ICMP_UNREACH,	ICMP_UNREACH_FILTER_PROHIB },
	{ "host-preced",	ICMP_UNREACH,	ICMP_UNREACH_HOST_PRECEDENCE },
	{ "cutoff-preced",	ICMP_UNREACH,	ICMP_UNREACH_PRECEDENCE_CUTOFF },
	{ "redir-net",		ICMP_REDIRECT,	ICMP_REDIRECT_NET },
	{ "redir-host",		ICMP_REDIRECT,	ICMP_REDIRECT_HOST },
	{ "redir-tos-net",	ICMP_REDIRECT,	ICMP_REDIRECT_TOSNET },
	{ "redir-tos-host",	ICMP_REDIRECT,	ICMP_REDIRECT_TOSHOST },
	{ "normal-adv",		ICMP_ROUTERADVERT, ICMP_ROUTERADVERT_NORMAL },
	{ "common-adv",		ICMP_ROUTERADVERT, ICMP_ROUTERADVERT_NOROUTE_COMMON },
	{ "transit",		ICMP_TIMXCEED,	ICMP_TIMXCEED_INTRANS },
	{ "reassemb",		ICMP_TIMXCEED,	ICMP_TIMXCEED_REASS },
	{ "badhead",		ICMP_PARAMPROB,	ICMP_PARAMPROB_ERRATPTR },
	{ "optmiss",		ICMP_PARAMPROB,	ICMP_PARAMPROB_OPTABSENT },
	{ "badlen",		ICMP_PARAMPROB,	ICMP_PARAMPROB_LENGTH },
	{ "unknown-ind",	ICMP_PHOTURIS,	ICMP_PHOTURIS_UNKNOWN_INDEX },
	{ "auth-fail",		ICMP_PHOTURIS,	ICMP_PHOTURIS_AUTH_FAILED },
	{ "decrypt-fail",	ICMP_PHOTURIS,	ICMP_PHOTURIS_DECRYPT_FAILED }
};

static const struct icmpcodeent icmp6_code[] = {
	{ "admin-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_ADMIN },
	{ "noroute-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_NOROUTE },
	{ "beyond-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_BEYONDSCOPE },
	{ "addr-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_ADDR },
	{ "port-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_NOPORT },
	{ "transit", ICMP6_TIME_EXCEEDED, ICMP6_TIME_EXCEED_TRANSIT },
	{ "reassemb", ICMP6_TIME_EXCEEDED, ICMP6_TIME_EXCEED_REASSEMBLY },
	{ "badhead", ICMP6_PARAM_PROB, ICMP6_PARAMPROB_HEADER },
	{ "nxthdr", ICMP6_PARAM_PROB, ICMP6_PARAMPROB_NEXTHEADER },
	{ "redironlink", ND_REDIRECT, ND_REDIRECT_ONLINK },
	{ "redirrouter", ND_REDIRECT, ND_REDIRECT_ROUTER }
};

static int
geticmptypebyname(char *w, uint8_t aid)
{
	size_t	i;

	switch (aid) {
	case AID_INET:
		for (i = 0; i < nitems(icmp_type); i++) {
			if (!strcmp(w, icmp_type[i].name))
				return (icmp_type[i].type);
		}
		break;
	case AID_INET6:
		for (i = 0; i < nitems(icmp6_type); i++) {
			if (!strcmp(w, icmp6_type[i].name))
				return (icmp6_type[i].type);
		}
		break;
	}
	return -1;
}

static int
geticmpcodebyname(u_long type, char *w, uint8_t aid)
{
	size_t	i;

	switch (aid) {
	case AID_INET:
		for (i = 0; i < nitems(icmp_code); i++) {
			if (type == icmp_code[i].type &&
			    !strcmp(w, icmp_code[i].name))
				return (icmp_code[i].code);
		}
		break;
	case AID_INET6:
		for (i = 0; i < nitems(icmp6_code); i++) {
			if (type == icmp6_code[i].type &&
			    !strcmp(w, icmp6_code[i].name))
				return (icmp6_code[i].code);
		}
		break;
	}
	return -1;
}
