/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTCAPABILITIESACCESS_H_
#define OPENDRIM_BOOTCAPABILITIESACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_BootCapabilities.h"
#include "assocOpenDRIM_BootCapabilities.h"

int Boot_OpenDRIM_BootCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_BootCapabilities_unload(string& errorMessage);

int Boot_OpenDRIM_BootCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootCapabilities& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootCapabilities& newInstance, const OpenDRIM_BootCapabilities& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootCapabilities& instance, string& errorMessage);

int Boot_OpenDRIM_BootCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootCapabilities& instance, string& errorMessage);

int Boot_OpenDRIM_BootCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_BootCapabilities>& OpenDRIM_BootCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_BootCapabilities>& OpenDRIM_BootCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootCapabilities_populate(OpenDRIM_BootCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_BOOTCAPABILITIESACCESS_H_*/
