#!/bin/bash

################################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_DNSGeneralSettingData.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_DNSGeneralSettingData provider module";
Name = "DNS_OpenDRIM_DNSGeneralSettingDataModule";
Location = "cmpiDNS_OpenDRIM_DNSGeneralSettingDataProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_DNSGeneralSettingData provider";
Name = "DNS_OpenDRIM_DNSGeneralSettingDataProvider";
ProviderModuleName = "DNS_OpenDRIM_DNSGeneralSettingDataModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_DNSGeneralSettingData provider capabilities";
ProviderModuleName = "DNS_OpenDRIM_DNSGeneralSettingDataModule";
ProviderName = "DNS_OpenDRIM_DNSGeneralSettingDataProvider";
ClassName = "OpenDRIM_DNSGeneralSettingData";
ProviderType = {2};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "InstanceID", "ElementName", "AddressOrigin", "AppendPrimarySuffixes", "AppendParentSuffixes", "DNSSuffixesToAppend"};
CapabilityID = "DNS_OpenDRIM_DNSGeneralSettingData";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_DNSGeneralSettingData.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_DNSGeneralSettingData]   
   provider: DNS_OpenDRIM_DNSGeneralSettingDataProvider
   location: cmpiDNS_OpenDRIM_DNSGeneralSettingDataProvider
   type: instance
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_DNSGeneralSettingData.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_DNSGeneralSettingData-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_DNSGeneralSettingData.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
