/*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

#ifndef SHARE_VM_UTILITIES_DTRACE_USDT2_DISABLED_HPP
#define SHARE_VM_UTILITIES_DTRACE_USDT2_DISABLED_HPP

/* This file contains dummy provider probes needed when compiling a hotspot
 * that does not support dtrace probes. This could be because we're building
 * on a system that doesn't support dtrace or because we're bulding a variant
 * of hotspot (like core) where we do not support dtrace
 */
#if !defined(DTRACE_ENABLED)

/* hotspot provider probes */
#define HOTSPOT_CLASS_LOADED(arg0, arg1, arg2, arg3)
#define HOTSPOT_CLASS_LOADED_ENABLED()  0
#define HOTSPOT_CLASS_UNLOADED(arg0, arg1, arg2, arg3)
#define HOTSPOT_CLASS_UNLOADED_ENABLED()  0
#define HOTSPOT_CLASS_INITIALIZATION_REQUIRED(arg0, arg1, arg2, arg3)
#define HOTSPOT_CLASS_INITIALIZATION_REQUIRED_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_RECURSIVE(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_RECURSIVE_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_CONCURRENT(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_CONCURRENT_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_ERRONEOUS(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_ERRONEOUS_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_SUPER_FAILED(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_SUPER_FAILED_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_CLINIT(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_CLINIT_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_ERROR(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_ERROR_ENABLED() 0
#define HOTSPOT_CLASS_INITIALIZATION_END(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_CLASS_INITIALIZATION_END_ENABLED() 0
#define HOTSPOT_COMPILED_METHOD_LOAD(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
#define HOTSPOT_COMPILED_METHOD_LOAD_ENABLED()  0
#define HOTSPOT_COMPILED_METHOD_UNLOAD(arg0, arg1, arg2, arg3, arg4, arg5)
#define HOTSPOT_COMPILED_METHOD_UNLOAD_ENABLED() 0
#define HOTSPOT_GC_BEGIN(arg0)
#define HOTSPOT_GC_BEGIN_ENABLED() 0
#define HOTSPOT_GC_END()
#define HOTSPOT_GC_END_ENABLED() 0
#define HOTSPOT_MEM_POOL_GC_BEGIN(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
#define HOTSPOT_MEM_POOL_GC_BEGIN_ENABLED() 0
#define HOTSPOT_MEM_POOL_GC_END(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
#define HOTSPOT_MEM_POOL_GC_END_ENABLED() 0
#define HOTSPOT_METHOD_COMPILE_BEGIN(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
#define HOTSPOT_METHOD_COMPILE_BEGIN_ENABLED() 0
#define HOTSPOT_METHOD_COMPILE_END(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
#define HOTSPOT_METHOD_COMPILE_END_ENABLED() 0
#define HOTSPOT_METHOD_ENTRY(arg0, arg1, arg2, arg3, arg4, arg5, arg6)
#define HOTSPOT_METHOD_ENTRY_ENABLED() 0
#define HOTSPOT_METHOD_RETURN(arg0, arg1, arg2, arg3, arg4, arg5, arg6)
#define HOTSPOT_METHOD_RETURN_ENABLED() 0
#define HOTSPOT_MONITOR_CONTENDED_ENTER(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_CONTENDED_ENTER_ENABLED() 0
#define HOTSPOT_MONITOR_CONTENDED_ENTERED(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_CONTENDED_ENTERED_ENABLED() 0
#define HOTSPOT_MONITOR_CONTENDED_EXIT(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_CONTENDED_EXIT_ENABLED() 0
#define HOTSPOT_MONITOR_NOTIFY(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_NOTIFY_ENABLED() 0
#define HOTSPOT_MONITOR_NOTIFYALL(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_NOTIFYALL_ENABLED() 0
#define HOTSPOT_MONITOR_WAIT(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_MONITOR_WAIT_ENABLED() 0
#define HOTSPOT_MONITOR_WAIT_PROBE(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_WAIT_PROBE_ENABLED() 0
#define HOTSPOT_MONITOR_WAITED(arg0, arg1, arg2, arg3)
#define HOTSPOT_MONITOR_WAITED_ENABLED() 0
#define HOTSPOT_OBJECT_ALLOC(arg0, arg1, arg2, arg3)
#define HOTSPOT_OBJECT_ALLOC_ENABLED() 0
#define HOTSPOT_THREAD_START(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_THREAD_START_ENABLED() 0
#define HOTSPOT_THREAD_STOP(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_THREAD_STOP_ENABLED() 0
#define HOTSPOT_THREAD_SLEEP_BEGIN(arg0)
#define HOTSPOT_THREAD_SLEEP_BEGIN_ENABLED() 0
#define HOTSPOT_THREAD_SLEEP_END(arg0)
#define HOTSPOT_THREAD_SLEEP_END_ENABLED() 0
#define HOTSPOT_THREAD_YIELD()
#define HOTSPOT_THREAD_YIELD_ENABLED() 0
#define HOTSPOT_THREAD_PARK_BEGIN(arg0, arg1, arg2)
#define HOTSPOT_THREAD_PARK_BEGIN_ENABLED() 0
#define HOTSPOT_THREAD_PARK_END(arg0)
#define HOTSPOT_THREAD_PARK_END_ENABLED() 0
#define HOTSPOT_THREAD_UNPARK(arg0)
#define HOTSPOT_THREAD_UNPARK_ENABLED() 0
#define HOTSPOT_VM_INIT_BEGIN()
#define HOTSPOT_VM_INIT_BEGIN_ENABLED() 0
#define HOTSPOT_VM_INIT_END()
#define HOTSPOT_VM_INIT_END_ENABLED() 0
#define HOTSPOT_VM_SHUTDOWN()
#define HOTSPOT_VM_SHUTDOWN_ENABLED() 0
#define HOTSPOT_VMOPS_REQUEST(arg0, arg1, arg2)
#define HOTSPOT_VMOPS_REQUEST_ENABLED() 0
#define HOTSPOT_VMOPS_BEGIN(arg0, arg1, arg2)
#define HOTSPOT_VMOPS_BEGIN_ENABLED() 0
#define HOTSPOT_VMOPS_END(arg0, arg1, arg2)
#define HOTSPOT_VMOPS_END_ENABLED() 0

/* hs_private provider probes */
#define HS_PRIVATE_CMS_INITMARK_BEGIN()
#define HS_PRIVATE_CMS_INITMARK_BEGIN_ENABLED() 0
#define HS_PRIVATE_CMS_INITMARK_END()
#define HS_PRIVATE_CMS_INITMARK_END_ENABLED() 0
#define HS_PRIVATE_CMS_REMARK_BEGIN()
#define HS_PRIVATE_CMS_REMARK_BEGIN_ENABLED() 0
#define HS_PRIVATE_CMS_REMARK_END()
#define HS_PRIVATE_CMS_REMARK_END_ENABLED() 0
#define HS_PRIVATE_HASHTABLE_NEW_ENTRY(arg0, arg1, arg2, arg3)
#define HS_PRIVATE_HASHTABLE_NEW_ENTRY_ENABLED() 0
#define HS_PRIVATE_SAFEPOINT_BEGIN()
#define HS_PRIVATE_SAFEPOINT_BEGIN_ENABLED() 0
#define HS_PRIVATE_SAFEPOINT_END()
#define HS_PRIVATE_SAFEPOINT_END_ENABLED() 0

/* hotspot_jni provider probes */
#define HOTSPOT_JNI_ALLOCOBJECT_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_ALLOCOBJECT_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ALLOCOBJECT_RETURN(arg0)
#define HOTSPOT_JNI_ALLOCOBJECT_RETURN_ENABLED()  0
#define HOTSPOT_JNI_ATTACHCURRENTTHREAD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_ATTACHCURRENTTHREAD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ATTACHCURRENTTHREAD_RETURN(arg0)
#define HOTSPOT_JNI_ATTACHCURRENTTHREAD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_ATTACHCURRENTTHREADASDAEMON_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_ATTACHCURRENTTHREADASDAEMON_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ATTACHCURRENTTHREADASDAEMON_RETURN(arg0)
#define HOTSPOT_JNI_ATTACHCURRENTTHREADASDAEMON_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLBOOLEANMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLBOOLEANMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLBOOLEANMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLBOOLEANMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLBOOLEANMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLBOOLEANMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLBOOLEANMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLBOOLEANMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLBOOLEANMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLBOOLEANMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLBOOLEANMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLBOOLEANMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLBYTEMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLBYTEMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLBYTEMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLBYTEMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLBYTEMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLBYTEMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLBYTEMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLBYTEMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLBYTEMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLBYTEMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLBYTEMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLBYTEMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLCHARMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLCHARMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLCHARMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLCHARMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLCHARMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLCHARMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLCHARMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLCHARMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLCHARMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLCHARMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLCHARMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLCHARMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLDOUBLEMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLDOUBLEMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLDOUBLEMETHOD_RETURN()
#define HOTSPOT_JNI_CALLDOUBLEMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLDOUBLEMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLDOUBLEMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLDOUBLEMETHODA_RETURN()
#define HOTSPOT_JNI_CALLDOUBLEMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLDOUBLEMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLDOUBLEMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLDOUBLEMETHODV_RETURN()
#define HOTSPOT_JNI_CALLDOUBLEMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLFLOATMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLFLOATMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLFLOATMETHOD_RETURN()
#define HOTSPOT_JNI_CALLFLOATMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLFLOATMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLFLOATMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLFLOATMETHODA_RETURN()
#define HOTSPOT_JNI_CALLFLOATMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLFLOATMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLFLOATMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLFLOATMETHODV_RETURN()
#define HOTSPOT_JNI_CALLFLOATMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLINTMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLINTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLINTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLINTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLINTMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLINTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLINTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLINTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLINTMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLINTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLINTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLINTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLLONGMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLLONGMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLLONGMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLLONGMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLLONGMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLLONGMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLLONGMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLLONGMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLLONGMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLLONGMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLLONGMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLLONGMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALBOOLEANMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALBYTEMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALCHARMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHOD_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODA_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODV_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALDOUBLEMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHOD_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODA_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODV_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALFLOATMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALINTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALLONGMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALOBJECTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLNONVIRTUALSHORTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHOD_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODA_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODA_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODV_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODV_RETURN()
#define HOTSPOT_JNI_CALLNONVIRTUALVOIDMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLOBJECTMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLOBJECTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLOBJECTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLOBJECTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLOBJECTMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLOBJECTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLOBJECTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLOBJECTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLOBJECTMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLOBJECTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLOBJECTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLOBJECTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSHORTMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSHORTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSHORTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSHORTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSHORTMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSHORTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSHORTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSHORTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSHORTMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSHORTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSHORTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSHORTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICBOOLEANMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBYTEMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICBYTEMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBYTEMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICBYTEMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICBYTEMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICCHARMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICCHARMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICCHARMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICCHARMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICCHARMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICCHARMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICCHARMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICCHARMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICCHARMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICCHARMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICCHARMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICCHARMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHOD_RETURN()
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODA_RETURN()
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODV_RETURN()
#define HOTSPOT_JNI_CALLSTATICDOUBLEMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICFLOATMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICFLOATMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICFLOATMETHOD_RETURN()
#define HOTSPOT_JNI_CALLSTATICFLOATMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODA_RETURN()
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODV_RETURN()
#define HOTSPOT_JNI_CALLSTATICFLOATMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICINTMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICINTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICINTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICINTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICINTMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICINTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICINTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICINTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICINTMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICINTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICINTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICINTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICLONGMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICLONGMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICLONGMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICLONGMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICLONGMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICLONGMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICLONGMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICLONGMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICLONGMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICLONGMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICLONGMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICLONGMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICOBJECTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICSHORTMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICSHORTMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICSHORTMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICSHORTMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODA_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODV_RETURN(arg0)
#define HOTSPOT_JNI_CALLSTATICSHORTMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICVOIDMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICVOIDMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICVOIDMETHOD_RETURN()
#define HOTSPOT_JNI_CALLSTATICVOIDMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODA_RETURN()
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODV_RETURN()
#define HOTSPOT_JNI_CALLSTATICVOIDMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLVOIDMETHOD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLVOIDMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLVOIDMETHOD_RETURN()
#define HOTSPOT_JNI_CALLVOIDMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLVOIDMETHODA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLVOIDMETHODA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLVOIDMETHODA_RETURN()
#define HOTSPOT_JNI_CALLVOIDMETHODA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CALLVOIDMETHODV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CALLVOIDMETHODV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CALLVOIDMETHODV_RETURN()
#define HOTSPOT_JNI_CALLVOIDMETHODV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_CREATEJAVAVM_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_CREATEJAVAVM_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_CREATEJAVAVM_RETURN(arg0)
#define HOTSPOT_JNI_CREATEJAVAVM_RETURN_ENABLED()  0
#define HOTSPOT_JNI_DEFINECLASS_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_DEFINECLASS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_DEFINECLASS_RETURN(arg0)
#define HOTSPOT_JNI_DEFINECLASS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_DELETEGLOBALREF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_DELETEGLOBALREF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_DELETEGLOBALREF_RETURN()
#define HOTSPOT_JNI_DELETEGLOBALREF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_DELETELOCALREF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_DELETELOCALREF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_DELETELOCALREF_RETURN()
#define HOTSPOT_JNI_DELETELOCALREF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_DELETEWEAKGLOBALREF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_DELETEWEAKGLOBALREF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_DELETEWEAKGLOBALREF_RETURN()
#define HOTSPOT_JNI_DELETEWEAKGLOBALREF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_DESTROYJAVAVM_ENTRY(arg0)
#define HOTSPOT_JNI_DESTROYJAVAVM_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_DESTROYJAVAVM_RETURN(arg0)
#define HOTSPOT_JNI_DESTROYJAVAVM_RETURN_ENABLED()  0
#define HOTSPOT_JNI_DETACHCURRENTTHREAD_ENTRY(arg0)
#define HOTSPOT_JNI_DETACHCURRENTTHREAD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_DETACHCURRENTTHREAD_RETURN(arg0)
#define HOTSPOT_JNI_DETACHCURRENTTHREAD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_ENSURELOCALCAPACITY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_ENSURELOCALCAPACITY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ENSURELOCALCAPACITY_RETURN(arg0)
#define HOTSPOT_JNI_ENSURELOCALCAPACITY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONCHECK_ENTRY(arg0)
#define HOTSPOT_JNI_EXCEPTIONCHECK_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONCHECK_RETURN(arg0)
#define HOTSPOT_JNI_EXCEPTIONCHECK_RETURN_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONCLEAR_ENTRY(arg0)
#define HOTSPOT_JNI_EXCEPTIONCLEAR_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONCLEAR_RETURN()
#define HOTSPOT_JNI_EXCEPTIONCLEAR_RETURN_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONDESCRIBE_ENTRY(arg0)
#define HOTSPOT_JNI_EXCEPTIONDESCRIBE_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONDESCRIBE_RETURN()
#define HOTSPOT_JNI_EXCEPTIONDESCRIBE_RETURN_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONOCCURRED_ENTRY(arg0)
#define HOTSPOT_JNI_EXCEPTIONOCCURRED_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_EXCEPTIONOCCURRED_RETURN(arg0)
#define HOTSPOT_JNI_EXCEPTIONOCCURRED_RETURN_ENABLED()  0
#define HOTSPOT_JNI_FATALERROR_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_FATALERROR_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_FINDCLASS_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_FINDCLASS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_FINDCLASS_RETURN(arg0)
#define HOTSPOT_JNI_FINDCLASS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_FROMREFLECTEDFIELD_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_FROMREFLECTEDFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_FROMREFLECTEDFIELD_RETURN(arg0)
#define HOTSPOT_JNI_FROMREFLECTEDFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_FROMREFLECTEDMETHOD_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_FROMREFLECTEDMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_FROMREFLECTEDMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_FROMREFLECTEDMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETARRAYLENGTH_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETARRAYLENGTH_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETARRAYLENGTH_RETURN(arg0)
#define HOTSPOT_JNI_GETARRAYLENGTH_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETBOOLEANARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETBOOLEANARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETBOOLEANARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETBOOLEANARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETBOOLEANARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETBOOLEANARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETBOOLEANARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETBOOLEANARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETBOOLEANFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETBOOLEANFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETBOOLEANFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETBOOLEANFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETBYTEARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETBYTEARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETBYTEARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETBYTEARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETBYTEARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETBYTEARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETBYTEARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETBYTEARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETBYTEFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETBYTEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETBYTEFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETBYTEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETCHARARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETCHARARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETCHARARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETCHARARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETCHARARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETCHARARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETCHARARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETCHARARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETCHARFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETCHARFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETCHARFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETCHARFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETCREATEDJAVAVMS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETCREATEDJAVAVMS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETCREATEDJAVAVMS_RETURN(arg0)
#define HOTSPOT_JNI_GETCREATEDJAVAVMS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETDEFAULTJAVAVMINITARGS_ENTRY(arg0)
#define HOTSPOT_JNI_GETDEFAULTJAVAVMINITARGS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETDEFAULTJAVAVMINITARGS_RETURN(arg0)
#define HOTSPOT_JNI_GETDEFAULTJAVAVMINITARGS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETDIRECTBUFFERADDRESS_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETDIRECTBUFFERADDRESS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETDIRECTBUFFERADDRESS_RETURN(arg0)
#define HOTSPOT_JNI_GETDIRECTBUFFERADDRESS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETDIRECTBUFFERCAPACITY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETDIRECTBUFFERCAPACITY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETDIRECTBUFFERCAPACITY_RETURN(arg0)
#define HOTSPOT_JNI_GETDIRECTBUFFERCAPACITY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETDOUBLEARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETDOUBLEARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETDOUBLEARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETDOUBLEARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETDOUBLEARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETDOUBLEARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETDOUBLEARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETDOUBLEARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETDOUBLEFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETDOUBLEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETDOUBLEFIELD_RETURN()
#define HOTSPOT_JNI_GETDOUBLEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETENV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETENV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETENV_RETURN(arg0)
#define HOTSPOT_JNI_GETENV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETFIELDID_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_GETFIELDID_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETFIELDID_RETURN(arg0)
#define HOTSPOT_JNI_GETFIELDID_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETFLOATARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETFLOATARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETFLOATARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETFLOATARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETFLOATARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETFLOATARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETFLOATARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETFLOATARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETFLOATFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETFLOATFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETFLOATFIELD_RETURN()
#define HOTSPOT_JNI_GETFLOATFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETINTARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETINTARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETINTARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETINTARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETINTARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETINTARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETINTARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETINTARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETINTFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETINTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETINTFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETINTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETJAVAVM_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETJAVAVM_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETJAVAVM_RETURN(arg0)
#define HOTSPOT_JNI_GETJAVAVM_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETLONGARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETLONGARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETLONGARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETLONGARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETLONGARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETLONGARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETLONGARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETLONGARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETLONGFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETLONGFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETLONGFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETLONGFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETMETHODID_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_GETMETHODID_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETMETHODID_RETURN(arg0)
#define HOTSPOT_JNI_GETMETHODID_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTARRAYELEMENT_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETOBJECTARRAYELEMENT_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTARRAYELEMENT_RETURN(arg0)
#define HOTSPOT_JNI_GETOBJECTARRAYELEMENT_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTCLASS_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETOBJECTCLASS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTCLASS_RETURN(arg0)
#define HOTSPOT_JNI_GETOBJECTCLASS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETOBJECTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETOBJECTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTREFTYPE_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETOBJECTREFTYPE_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETOBJECTREFTYPE_RETURN(arg0)
#define HOTSPOT_JNI_GETOBJECTREFTYPE_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETPRIMITIVEARRAYCRITICAL_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETPRIMITIVEARRAYCRITICAL_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETPRIMITIVEARRAYCRITICAL_RETURN(arg0)
#define HOTSPOT_JNI_GETPRIMITIVEARRAYCRITICAL_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSHORTARRAYELEMENTS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSHORTARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSHORTARRAYELEMENTS_RETURN(arg0)
#define HOTSPOT_JNI_GETSHORTARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSHORTARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETSHORTARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSHORTARRAYREGION_RETURN()
#define HOTSPOT_JNI_GETSHORTARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSHORTFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSHORTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSHORTFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSHORTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICBOOLEANFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICBOOLEANFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICBOOLEANFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICBOOLEANFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICBYTEFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICBYTEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICBYTEFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICBYTEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICCHARFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICCHARFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICCHARFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICCHARFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICDOUBLEFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICDOUBLEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICDOUBLEFIELD_RETURN()
#define HOTSPOT_JNI_GETSTATICDOUBLEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICFIELDID_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_GETSTATICFIELDID_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICFIELDID_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICFIELDID_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICFLOATFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICFLOATFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICFLOATFIELD_RETURN()
#define HOTSPOT_JNI_GETSTATICFLOATFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICINTFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICINTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICINTFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICINTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICLONGFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICLONGFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICLONGFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICLONGFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICMETHODID_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_GETSTATICMETHODID_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICMETHODID_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICMETHODID_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICOBJECTFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICOBJECTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICOBJECTFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICOBJECTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICSHORTFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTATICSHORTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTATICSHORTFIELD_RETURN(arg0)
#define HOTSPOT_JNI_GETSTATICSHORTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGCHARS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTRINGCHARS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGCHARS_RETURN(arg0)
#define HOTSPOT_JNI_GETSTRINGCHARS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGCRITICAL_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTRINGCRITICAL_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGCRITICAL_RETURN(arg0)
#define HOTSPOT_JNI_GETSTRINGCRITICAL_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGLENGTH_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETSTRINGLENGTH_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGLENGTH_RETURN(arg0)
#define HOTSPOT_JNI_GETSTRINGLENGTH_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETSTRINGREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGREGION_RETURN()
#define HOTSPOT_JNI_GETSTRINGREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGUTFCHARS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_GETSTRINGUTFCHARS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGUTFCHARS_RETURN(arg0)
#define HOTSPOT_JNI_GETSTRINGUTFCHARS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGUTFLENGTH_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETSTRINGUTFLENGTH_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGUTFLENGTH_RETURN(arg0)
#define HOTSPOT_JNI_GETSTRINGUTFLENGTH_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGUTFREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_GETSTRINGUTFREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSTRINGUTFREGION_RETURN()
#define HOTSPOT_JNI_GETSTRINGUTFREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETSUPERCLASS_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETSUPERCLASS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETSUPERCLASS_RETURN(arg0)
#define HOTSPOT_JNI_GETSUPERCLASS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_GETVERSION_ENTRY(arg0)
#define HOTSPOT_JNI_GETVERSION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETVERSION_RETURN(arg0)
#define HOTSPOT_JNI_GETVERSION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_ISASSIGNABLEFROM_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_ISASSIGNABLEFROM_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ISASSIGNABLEFROM_RETURN(arg0)
#define HOTSPOT_JNI_ISASSIGNABLEFROM_RETURN_ENABLED()  0
#define HOTSPOT_JNI_ISINSTANCEOF_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_ISINSTANCEOF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ISINSTANCEOF_RETURN(arg0)
#define HOTSPOT_JNI_ISINSTANCEOF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_ISSAMEOBJECT_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_ISSAMEOBJECT_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_ISSAMEOBJECT_RETURN(arg0)
#define HOTSPOT_JNI_ISSAMEOBJECT_RETURN_ENABLED()  0
#define HOTSPOT_JNI_MONITORENTER_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_MONITORENTER_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_MONITORENTER_RETURN(arg0)
#define HOTSPOT_JNI_MONITORENTER_RETURN_ENABLED()  0
#define HOTSPOT_JNI_MONITOREXIT_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_MONITOREXIT_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_MONITOREXIT_RETURN(arg0)
#define HOTSPOT_JNI_MONITOREXIT_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWBOOLEANARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWBOOLEANARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWBOOLEANARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWBOOLEANARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWBYTEARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWBYTEARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWBYTEARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWBYTEARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWCHARARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWCHARARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWCHARARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWCHARARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWDIRECTBYTEBUFFER_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_NEWDIRECTBYTEBUFFER_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWDIRECTBYTEBUFFER_RETURN(arg0)
#define HOTSPOT_JNI_NEWDIRECTBYTEBUFFER_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWDOUBLEARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWDOUBLEARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWDOUBLEARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWDOUBLEARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWFLOATARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWFLOATARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWFLOATARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWFLOATARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWGLOBALREF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWGLOBALREF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWGLOBALREF_RETURN(arg0)
#define HOTSPOT_JNI_NEWGLOBALREF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWINTARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWINTARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWINTARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWINTARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWLOCALREF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWLOCALREF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWLOCALREF_RETURN(arg0)
#define HOTSPOT_JNI_NEWLOCALREF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWLONGARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWLONGARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWLONGARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWLONGARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECT_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_NEWOBJECT_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECT_RETURN(arg0)
#define HOTSPOT_JNI_NEWOBJECT_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECTA_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_NEWOBJECTA_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECTA_RETURN(arg0)
#define HOTSPOT_JNI_NEWOBJECTA_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECTARRAY_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_NEWOBJECTARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECTARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWOBJECTARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECTV_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_NEWOBJECTV_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWOBJECTV_RETURN(arg0)
#define HOTSPOT_JNI_NEWOBJECTV_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWSHORTARRAY_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWSHORTARRAY_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWSHORTARRAY_RETURN(arg0)
#define HOTSPOT_JNI_NEWSHORTARRAY_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWSTRING_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_NEWSTRING_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWSTRING_RETURN(arg0)
#define HOTSPOT_JNI_NEWSTRING_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWSTRINGUTF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWSTRINGUTF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWSTRINGUTF_RETURN(arg0)
#define HOTSPOT_JNI_NEWSTRINGUTF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_NEWWEAKGLOBALREF_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_NEWWEAKGLOBALREF_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_NEWWEAKGLOBALREF_RETURN(arg0)
#define HOTSPOT_JNI_NEWWEAKGLOBALREF_RETURN_ENABLED()  0
#define HOTSPOT_JNI_POPLOCALFRAME_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_POPLOCALFRAME_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_POPLOCALFRAME_RETURN(arg0)
#define HOTSPOT_JNI_POPLOCALFRAME_RETURN_ENABLED()  0
#define HOTSPOT_JNI_PUSHLOCALFRAME_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_PUSHLOCALFRAME_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_PUSHLOCALFRAME_RETURN(arg0)
#define HOTSPOT_JNI_PUSHLOCALFRAME_RETURN_ENABLED()  0
#define HOTSPOT_JNI_REGISTERNATIVES_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_REGISTERNATIVES_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_REGISTERNATIVES_RETURN(arg0)
#define HOTSPOT_JNI_REGISTERNATIVES_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASEBOOLEANARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASEBOOLEANARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASEBOOLEANARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASEBOOLEANARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASEBYTEARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASEBYTEARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASEBYTEARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASEBYTEARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASECHARARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASECHARARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASECHARARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASECHARARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASEDOUBLEARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASEDOUBLEARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASEDOUBLEARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASEDOUBLEARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASEFLOATARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASEFLOATARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASEFLOATARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASEFLOATARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASEINTARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASEINTARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASEINTARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASEINTARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASELONGARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASELONGARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASELONGARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASELONGARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASEPRIMITIVEARRAYCRITICAL_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASEPRIMITIVEARRAYCRITICAL_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASEPRIMITIVEARRAYCRITICAL_RETURN()
#define HOTSPOT_JNI_RELEASEPRIMITIVEARRAYCRITICAL_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASESHORTARRAYELEMENTS_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_RELEASESHORTARRAYELEMENTS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASESHORTARRAYELEMENTS_RETURN()
#define HOTSPOT_JNI_RELEASESHORTARRAYELEMENTS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASESTRINGCHARS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_RELEASESTRINGCHARS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASESTRINGCHARS_RETURN()
#define HOTSPOT_JNI_RELEASESTRINGCHARS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASESTRINGCRITICAL_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_RELEASESTRINGCRITICAL_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASESTRINGCRITICAL_RETURN()
#define HOTSPOT_JNI_RELEASESTRINGCRITICAL_RETURN_ENABLED()  0
#define HOTSPOT_JNI_RELEASESTRINGUTFCHARS_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_RELEASESTRINGUTFCHARS_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_RELEASESTRINGUTFCHARS_RETURN()
#define HOTSPOT_JNI_RELEASESTRINGUTFCHARS_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETBOOLEANARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETBOOLEANARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETBOOLEANARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETBOOLEANARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETBOOLEANFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETBOOLEANFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETBOOLEANFIELD_RETURN()
#define HOTSPOT_JNI_SETBOOLEANFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETBYTEARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETBYTEARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETBYTEARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETBYTEARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETBYTEFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETBYTEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETBYTEFIELD_RETURN()
#define HOTSPOT_JNI_SETBYTEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETCHARARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETCHARARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETCHARARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETCHARARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETCHARFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETCHARFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETCHARFIELD_RETURN()
#define HOTSPOT_JNI_SETCHARFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETDOUBLEARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETDOUBLEARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETDOUBLEARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETDOUBLEARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETDOUBLEFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_SETDOUBLEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETDOUBLEFIELD_RETURN()
#define HOTSPOT_JNI_SETDOUBLEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETFLOATARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETFLOATARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETFLOATARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETFLOATARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETFLOATFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_SETFLOATFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETFLOATFIELD_RETURN()
#define HOTSPOT_JNI_SETFLOATFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETINTARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETINTARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETINTARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETINTARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETINTFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETINTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETINTFIELD_RETURN()
#define HOTSPOT_JNI_SETINTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETLONGARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETLONGARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETLONGARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETLONGARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETLONGFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETLONGFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETLONGFIELD_RETURN()
#define HOTSPOT_JNI_SETLONGFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETOBJECTARRAYELEMENT_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETOBJECTARRAYELEMENT_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETOBJECTARRAYELEMENT_RETURN()
#define HOTSPOT_JNI_SETOBJECTARRAYELEMENT_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETOBJECTFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETOBJECTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETOBJECTFIELD_RETURN()
#define HOTSPOT_JNI_SETOBJECTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSHORTARRAYREGION_ENTRY(arg0, arg1, arg2, arg3, arg4)
#define HOTSPOT_JNI_SETSHORTARRAYREGION_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSHORTARRAYREGION_RETURN()
#define HOTSPOT_JNI_SETSHORTARRAYREGION_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSHORTFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSHORTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSHORTFIELD_RETURN()
#define HOTSPOT_JNI_SETSHORTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICBOOLEANFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICBOOLEANFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICBOOLEANFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICBOOLEANFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICBYTEFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICBYTEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICBYTEFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICBYTEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICCHARFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICCHARFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICCHARFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICCHARFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICDOUBLEFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_SETSTATICDOUBLEFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICDOUBLEFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICDOUBLEFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICFLOATFIELD_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_SETSTATICFLOATFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICFLOATFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICFLOATFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICINTFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICINTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICINTFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICINTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICLONGFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICLONGFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICLONGFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICLONGFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICOBJECTFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICOBJECTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICOBJECTFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICOBJECTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICSHORTFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_SETSTATICSHORTFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_SETSTATICSHORTFIELD_RETURN()
#define HOTSPOT_JNI_SETSTATICSHORTFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_THROW_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_THROW_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_THROW_RETURN(arg0)
#define HOTSPOT_JNI_THROW_RETURN_ENABLED()  0
#define HOTSPOT_JNI_THROWNEW_ENTRY(arg0, arg1, arg2)
#define HOTSPOT_JNI_THROWNEW_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_THROWNEW_RETURN(arg0)
#define HOTSPOT_JNI_THROWNEW_RETURN_ENABLED()  0
#define HOTSPOT_JNI_TOREFLECTEDFIELD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_TOREFLECTEDFIELD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_TOREFLECTEDFIELD_RETURN(arg0)
#define HOTSPOT_JNI_TOREFLECTEDFIELD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_TOREFLECTEDMETHOD_ENTRY(arg0, arg1, arg2, arg3)
#define HOTSPOT_JNI_TOREFLECTEDMETHOD_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_TOREFLECTEDMETHOD_RETURN(arg0)
#define HOTSPOT_JNI_TOREFLECTEDMETHOD_RETURN_ENABLED()  0
#define HOTSPOT_JNI_UNREGISTERNATIVES_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_UNREGISTERNATIVES_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_UNREGISTERNATIVES_RETURN(arg0)
#define HOTSPOT_JNI_UNREGISTERNATIVES_RETURN_ENABLED()  0

/* Modules */
#define HOTSPOT_JNI_GETMODULE_ENTRY(arg0, arg1)
#define HOTSPOT_JNI_GETMODULE_ENTRY_ENABLED()  0
#define HOTSPOT_JNI_GETMODULE_RETURN(arg0)
#define HOTSPOT_JNI_GETMODULE_RETURN_ENABLED()

#else /* !defined(DTRACE_ENABLED) */
#error This file should only be included when dtrace is not enabled
#endif /* !defined(DTRACE_ENABLED) */

#endif // SHARE_VM_UTILITIES_DTRACE_USDT2_DISABLED_HPP
