"testLmFisher" <-
function(x, beta, y, testLevel = 0.95){
  
  # Checking for NAs in y, beta is assumed not to contain any
  indexNA <- which(is.na(y))

  if(length(indexNA) > 0) {
    x[indexNA, ] <- NA 
  }

  # Checking for NAs in x, beta is assumed not to contain any
  indexNA <- which(is.na(x), arr.ind=TRUE)

  if(length(indexNA) > 0) {

    x[indexNA[, 1], ] <- NA 
    y[indexNA[, 1]] <- NA
    # Eliminating the NAs
    x <- matrix(x[ ! is.na(x)], ncol = ncol(x))
    y <- y[ ! is.na(y)]
  }

  # Prediction.
  completeX <- cbind(rep(1, nrow(x)), x)
  predictedSample <- completeX %*% beta

  n <- length(y)
  p <- length(beta)

  sse <- sum((predictedSample - y) ** 2)
  ssr <- sum((predictedSample - mean(y)) ** 2)

  # p is the length of beta including the intercept, therefore 
  # the DFs are p-1, hence the 'p-1' and 'n-p-2' below. 
  valueFisher <- (ssr / (p - 1)) / (sse / (n - p - 2))

  fTest <- pf(valueFisher, p - 1, n - p - 2) 

  return(list(test = "Fisher",
       testResult = as.numeric(fTest < 1 - testLevel), 
       pValue = fTest,
       threshold = 1 - testLevel))

}

