/*
 * Copyright holder 2001-2011 Vedder Bruno.
 * Work continued by 2016-2020 Carlos Donizete Froes [a.k.a coringao]
 *
 * This file is part of Osmose Emulator, a Sega Master System and Game Gear
 * software emulator.
 *
 * Osmose Emulator is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Osmose Emulator is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Osmose Emulator. If not, see <http://www.gnu.org/licenses/>.
 *
 * Many thanks to Vedder Bruno, the original author of Osmose Emulator.
 *
 */

#ifndef JOYSTICK_H
#define JOYSTICK_H

#include <iostream>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <linux/joystick.h>
#include "Pthreadcpp.h"

using namespace std;

#define MAX_DEVNAME_LEN	128
#define MAX_JOYID_LEN	128
#define DEFAULT_POLLING_PERIOD	  3


/**
 * Joystick listener interface.
 * Inherit this class and provide virtual methods in order to be a full Joystick listener.
 */
class JoystickListener
{
public:
	virtual void buttonChanged(unsigned int button, bool pressed) = 0; /* True when pressed */
    virtual void xAxisChanged(int value) = 0;
	virtual void yAxisChanged(int value) = 0;
	virtual void joystickError() = 0;
};

class Joystick : public Thread
{
public:
    
    Joystick(const char *dev_name, JoystickListener *l);
    const char * getStrID() { return joystickID;  }
    const char * getDeviceName() { return deviceName; }
    void setListener(JoystickListener *lstnr) { listener = lstnr; }
    void setPollingPeriod(int ms);
    int  getPollingPeriod() { return pollingPeriod; }
	unsigned int getAxisNumber() { return (unsigned int)axisNbr; }
	unsigned int getButtonNumber() { return (unsigned int)buttonNbr; }
	unsigned int getDriverVersion() {return driverVersion; }
    ~Joystick();
    
protected:
    
	void *run(void *);
    
private:
    
	char deviceName[MAX_DEVNAME_LEN];
    char joystickID[MAX_JOYID_LEN];
    int  joystickFD;
	unsigned char axisNbr;
	unsigned char buttonNbr;
	unsigned int  driverVersion; // Unused-Major-Minor-Lower 8 bits packed.
	
    JoystickListener *listener;
    int pollingPeriod;
	bool done;

	bool readDevice(struct js_event *jse);
	
};

#endif	// JOYSTICK_H
