///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_XFORM_SYSTEM_CHOOSER_H
#define __OVITO_XFORM_SYSTEM_CHOOSER_H

#include <core/Core.h>
#include <core/actions/Action.h>
#include <core/actions/ActionManager.h>
#include <core/viewport/input/XFormManager.h>

namespace Core {

/******************************************************************************
* This combo box lets the user choose the current transformation coordinate system.
******************************************************************************/
class XFormSystemChooser : public Action
{
	Q_OBJECT
	
public:
	
	/// Initializes the object.
    XFormSystemChooser();

protected:
    
	/// This is called by the system after the action object has been bound to its ActionProxy. 
	virtual void initializeAction(ActionProxy* proxy);
    
private Q_SLOTS:

	/// Is called when the xform system has been changed.
	void onXFormSystemChanged();

	/// Is called when the user has choosen an item from the list.
	void onSelectionChanged(int index);

private:
	
	/// The selector widget.
	QComboBox* comboBox;
};

};

#endif // __OVITO_XFORM_SYSTEM_CHOOSER_H
