'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS28EA00 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS28EA00
\- 1-Wire Digital Thermometer with Sequence Detect and PIO
.SH SYNOPSIS
Thermometer, PIO and Chain.
.PP
.B 42
[.]XXXXXXXXXXXX[XX][/[
.so man3/temperatures_mini.3so
.B die
|
.B power
|
.B temphigh
|
.B templow
|
.B PIO.A|B|ALL.BYTE
|
.B latch.A|B|ALL.BYTE
|
.B sensed.A|B|ALL.BYTE

.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 42
.SH SPECIAL PROPERTIES
.SS power
.I read-only,yes-no
.br
Is the chip powered externally (=1) or from the parasitically from the data bus (=0)?
.SH TEMPERATURE PROPERTIES
.SS temperature
.I read-only, floating point
.br
Measured temperature with 12 bit resolution. 
.SS temperature9 temperature10 temperature11 temperature12
.I read-only, floating point
Measured temperature at 9 to 12 bit resolution. There is a tradeoff of time versus accuracy in the temperature measurement.
.SS fasttemp
.I read-only, floating point
.br
Equivalent to
.I temperature9
.SH PIO PROPERTIES
.SS PIO.A|B|ALL|BYTE
.I read-write, yes-no
.br
Two channels of sensors/switches. We use the logical raqther than eletrical interpretation: 0=off (non-conducting) 1=on (conducting -- to ground)
.PP
The
.I PIO
channels are alternatively used for the sequence-detect (chain) mode.
.PP
Reading
.I sensed
gives the inverse value of the cooresponding
.I PIO.
.PP
Reading
.I PIO
gives the actual pin values. Use the
.I latch
property to see how the pin is set.
.SS latch.A|B|ALL|BYTE
.I read-only, yes-no
.br
Set (intended) va;ue of the
.I PIO
pins.
.SS sensed.A|B|ALL|BYTE
.I read-only, yes-no
.br
Actual logical level at the
.I PIO
pins.
.SH SPECIAL PROPERTIES
.SS power
.I read-only,yes-no
.br
Is the chip powered externally (=1) or from the parasitically from the data bus (=0)?
.so man3/temperature_threshold.3so
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH DESCRIPTION
.so man3/description.3so
.SS DS28EA00
The
.B DS28EA00 (3)
is one of several available 1-wire temperature sensors. It is the replacement for the
.B DS18S20 (3)
Alternatives are
.B DS1822 (3)
as well as temperature/vlotage measurements in the
.B DS2436 (3)
and
.B DS2438 (3).
For truly versatile temperature measurements, see the protean
.B DS1921 (3) Thermachron (3).
.br
The
.B DS28EA00
has special switch/sequence detect properties. In sequence mode, the PIO pins are daisy-chained to the next DS28EA00, allowing the system to step through the physical sequence of the DS28EA00s.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS28EA00.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
