/*
 * Copyright (C) 2011 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef LayerFlushScheduler_h
#define LayerFlushScheduler_h

#if USE(ACCELERATED_COMPOSITING)

#include "LayerFlushSchedulerClient.h"
#include <wtf/Noncopyable.h>
#include <wtf/RetainPtr.h>

namespace WebCore {
    
class LayerFlushScheduler {
    WTF_MAKE_NONCOPYABLE(LayerFlushScheduler);
public:
    LayerFlushScheduler(LayerFlushSchedulerClient*);
    ~LayerFlushScheduler();

    void schedule();
    void invalidate();

    void suspend();
    void resume();

    bool isSuspended() const { return m_isSuspended; }

private:
    bool m_isSuspended;
    LayerFlushSchedulerClient* m_client;
    
#if PLATFORM(MAC)
    RetainPtr<CFRunLoopObserverRef> m_runLoopObserver;
    static void runLoopObserverCallback(CFRunLoopObserverRef, CFRunLoopActivity, void* context);
    void runLoopObserverCallback();
#endif
};

} // namespace WebCore

#endif // USE(ACCELERATED_COMPOSITING)

#endif // LayerFlushScheduler_h
