# HighsInfo

Scalar information about a solved model is communicated via an instance of the HighsInfo class

## valid
- Indicates whether the values in a HighsInfo instance are valid
- Type: bool

## simplex\_iteration\_count
- The number of simplex iterations performed
- Type: integer

## ipm\_iteration\_count
- The number of interior point iterations performed
- Type: integer

## crossover\_iteration\_count
- The number of crossover iterations performed
- Type: integer

## qp\_iteration\_count
- The number of QP iterations performed
- Type: integer

## primal\_solution\_status
- Comparison with [SolutionStatus](@ref) gives the status of the [primal](@ref Primal-values) solution
- Type: integer

## dual\_solution\_status
- Comparison with [SolutionStatus](@ref) gives the status of the [dual](@ref Dual-values) solution
- Type: integer

## basis\_validity
- Comparison with [BasisValidity](@ref) gives the status of any basis information
- Type: integer

## objective\_function\_value
- The optimal value of the objective function
- Type: double

## mip\_node\_count
- The number of nodes generated by the MIP solver
- Type: long integer

## mip\_dual\_bound
- The [dual bound](@ref terminology-mip) for the MIP solver
- Type: double

## mip\_gap
- The absolute value of the gap between the primal and bounds, relative to the primal bound.
- Type: double

## max\_integrality\_violation
- The maximum deviation from an integer value over all the discrete variables
- Type: double

## num\_primal\_infeasibilities
- The number of variables violating a bound by more than the [primal feasibility tolerance](@ref primal_feasibility_tolerance).
- Type: integer

## max\_primal\_infeasibility
- The maximum violation of a bound on a variable
- Type: double

## sum\_primal\_infeasibilities
- The sum of violations of bounds by variables
- Type: double

## num\_dual\_infeasibilities
- The number of variables violating dual feasibility by more than the [dual feasibility tolerance](@ref dual_feasibility_tolerance).
- Type: integer

## max\_dual\_infeasibility
- The maximum dual feasibility violation
- Type: double

## sum\_dual\_infeasibilities
- The sum of dual feasibility violations
- Type: double

