
/****************************************************************************
 **
 ** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
 ** All rights reserved.
 ** Contact: chuebsch@moliso.de
 **
 ** This file is part of the ShelXle
 **
 ** This file may be used under the terms of the GNU Lesser
 ** General Public License version 2.1 as published by the Free Software
 ** Foundation and appearing in the file COPYING included in the
 ** packaging of this file.  Please review the following information to
 ** ensure the GNU Lesser General Public License version 2.1 requirements
 ** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
 **
 **
 ****************************************************************************/
#include <molecule.h> 
#include <QtOpenGL>
#include <QGLWidget>
#if defined (Q_WS_MAC)
#include <OpenGL/glu.h>
//#include <glu.h>
#else
#include <GL/glu.h>
#endif
const double g2r=180.0/M_PI;
#include "itsme.h"

Molecule::Molecule(){
  proba=50;
  program_in_use=false;
  useShaders=true;
  g_program=0;
  g_Program=NULL;
  shaders_work=false;
  qPeakRad=0.05;
  q=NULL;
  growQPeak=false;
  tubes=0;
  qboMin=0.97;
  qboMax=1.67;
  HAWink=135;
  HAMax=2.5;
  dratom=0;
  LOD=4;
  highlightEquivalents = true;
  mQolor=QColor(128,76,76);
  monoQrom=false;
  nopm1=false;
  bondColorStyle=0;
  bondStrength=0.05;
  //nonPositiveDefinite=0;
  Kovalenz_Radien[0  ]=55  ;Kovalenz_Radien[1  ]=1   ;Kovalenz_Radien[2  ]=123 ;Kovalenz_Radien[3  ]=90  ;
  Kovalenz_Radien[4  ]=80  ;Kovalenz_Radien[5  ]=77  ;Kovalenz_Radien[6  ]=74  ;Kovalenz_Radien[7  ]=71  ;
  Kovalenz_Radien[8  ]=72  ;Kovalenz_Radien[9  ]=1   ;Kovalenz_Radien[10 ]=154 ;Kovalenz_Radien[11 ]=149 ;
  Kovalenz_Radien[12 ]=118 ;Kovalenz_Radien[13 ]=111 ;Kovalenz_Radien[14 ]=106 ;Kovalenz_Radien[15 ]=102 ;
  Kovalenz_Radien[16 ]=99  ;Kovalenz_Radien[17 ]=1   ;Kovalenz_Radien[18 ]=203 ;Kovalenz_Radien[19 ]=174 ;
  Kovalenz_Radien[20 ]=144 ;Kovalenz_Radien[21 ]=132 ;Kovalenz_Radien[22 ]=122 ;Kovalenz_Radien[23 ]=118 ;
  Kovalenz_Radien[24 ]=117 ;Kovalenz_Radien[25 ]=117 ;Kovalenz_Radien[26 ]=116 ;Kovalenz_Radien[27 ]=124 ;
  Kovalenz_Radien[28 ]=117 ;Kovalenz_Radien[29 ]=125 ;Kovalenz_Radien[30 ]=126 ;Kovalenz_Radien[31 ]=122 ;
  Kovalenz_Radien[32 ]=120 ;Kovalenz_Radien[33 ]=116 ;Kovalenz_Radien[34 ]=114 ;Kovalenz_Radien[35 ]=1   ;
  Kovalenz_Radien[36 ]=218 ;Kovalenz_Radien[37 ]=191 ;Kovalenz_Radien[38 ]=162 ;Kovalenz_Radien[39 ]=145 ;
  Kovalenz_Radien[40 ]=134 ;Kovalenz_Radien[41 ]=130 ;Kovalenz_Radien[42 ]=127 ;Kovalenz_Radien[43 ]=125 ;
  Kovalenz_Radien[44 ]=125 ;Kovalenz_Radien[45 ]=128 ;Kovalenz_Radien[46 ]=134 ;Kovalenz_Radien[47 ]=148 ;
  Kovalenz_Radien[48 ]=144 ;Kovalenz_Radien[49 ]=141 ;Kovalenz_Radien[50 ]=140 ;Kovalenz_Radien[51 ]=136 ;
  Kovalenz_Radien[52 ]=133 ;Kovalenz_Radien[53 ]=1   ;Kovalenz_Radien[54 ]=235 ;Kovalenz_Radien[55 ]=198 ;
  Kovalenz_Radien[56 ]=169 ;Kovalenz_Radien[57 ]=165 ;Kovalenz_Radien[58 ]=165 ;Kovalenz_Radien[59 ]=164 ;
  Kovalenz_Radien[60 ]=164 ;Kovalenz_Radien[61 ]=162 ;Kovalenz_Radien[62 ]=185 ;Kovalenz_Radien[63 ]=161 ;
  Kovalenz_Radien[64 ]=159 ;Kovalenz_Radien[65 ]=159 ;Kovalenz_Radien[66 ]=157 ;Kovalenz_Radien[67 ]=157 ;
  Kovalenz_Radien[68 ]=156 ;Kovalenz_Radien[69 ]=170 ;Kovalenz_Radien[70 ]=156 ;Kovalenz_Radien[71 ]=144 ;
  Kovalenz_Radien[72 ]=134 ;Kovalenz_Radien[73 ]=130 ;Kovalenz_Radien[74 ]=128 ;Kovalenz_Radien[75 ]=126 ;
  Kovalenz_Radien[76 ]=127 ;Kovalenz_Radien[77 ]=130 ;Kovalenz_Radien[78 ]=134 ;Kovalenz_Radien[79 ]=149 ;
  Kovalenz_Radien[80 ]=148 ;Kovalenz_Radien[81 ]=147 ;Kovalenz_Radien[82 ]=146 ;Kovalenz_Radien[83 ]=146 ;
  Kovalenz_Radien[84 ]=145 ;Kovalenz_Radien[85 ]=1   ;Kovalenz_Radien[86 ]=0   ;Kovalenz_Radien[87 ]=1   ;
  Kovalenz_Radien[88 ]=188 ;Kovalenz_Radien[89 ]=165 ;Kovalenz_Radien[90 ]=161 ;Kovalenz_Radien[91 ]=142 ;
  Kovalenz_Radien[92 ]=130 ;Kovalenz_Radien[93 ]=151 ;Kovalenz_Radien[94 ]=182 ;
  //printf("Kovalenz_Radien H hat :%d \n",Kovalenz_Radien[0]);
  /*  //EN{
      ElNeg[0]=220; ElNeg[1]=550; ElNeg[2]= 97; ElNeg[3]=147;
      ElNeg[4]=201; ElNeg[5]=250; ElNeg[6]=307; ElNeg[7]=350;
      ElNeg[8]=410; ElNeg[9]=480; ElNeg[10]=101;ElNeg[11]=123;
      ElNeg[12]=147;ElNeg[13]=174;ElNeg[14]=206;ElNeg[15]=244;
      ElNeg[16]=283;ElNeg[17]=320;ElNeg[18]= 91;ElNeg[19]=104;
      ElNeg[20]=120;ElNeg[21]=132;ElNeg[22]=145;ElNeg[23]=156;
      ElNeg[24]=160;ElNeg[25]=164;ElNeg[26]=170;ElNeg[27]=175;
      ElNeg[28]=175;ElNeg[29]=166;ElNeg[30]=182;ElNeg[31]=202;
      ElNeg[32]=220;ElNeg[33]=248;ElNeg[34]=274;ElNeg[35]=290;
      ElNeg[36]= 89;ElNeg[37]= 99;ElNeg[38]=111;ElNeg[39]=122;
      ElNeg[40]=123;ElNeg[41]=130;ElNeg[42]=136;ElNeg[43]=142;
      ElNeg[44]=145;ElNeg[45]=130;ElNeg[46]=142;ElNeg[47]=146;
      ElNeg[48]=149;ElNeg[49]=172;ElNeg[50]=182;ElNeg[51]=201;
      ElNeg[52]=221;ElNeg[53]=240;ElNeg[54]= 86;ElNeg[55]= 97;
      ElNeg[56]=108;ElNeg[57]=108;ElNeg[58]=107;ElNeg[59]=107;
      ElNeg[60]=107;ElNeg[61]=107;ElNeg[62]=110;ElNeg[63]=111;
      ElNeg[64]=110;ElNeg[65]=110;ElNeg[66]=110;ElNeg[67]=111;
      ElNeg[68]=111;ElNeg[69]=106;ElNeg[70]=114;ElNeg[71]=123;
      ElNeg[72]=133;ElNeg[73]=140;ElNeg[74]=146;ElNeg[75]=152;
      ElNeg[76]=155;ElNeg[77]=142;ElNeg[78]=142;ElNeg[79]=144;
      ElNeg[80]=144;ElNeg[81]=155;ElNeg[82]=167;
      */
  for (int i=0; i<109; i++){
    if (i<95) arad[i]=(i)?Kovalenz_Radien[i]/(250.0):Kovalenz_Radien[i]/(500.0);
    else arad[i]=0.5;
    AtomStyle[i]=ATOM_STYLE_WALLS|ATOM_STYLE_RINGS|ATOM_STYLE_SPHERE;

    switch (i){
      case 0://H
        AtomColor[i]=QColor(Qt::white).darker(20);
        break;
      case 2://Li
        AtomColor[i]=QColor(Qt::darkRed);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 3://Be
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 4://B
        AtomColor[i]=QColor(Qt::darkBlue);
        break;
      case 5://C
        AtomColor[i]=QColor("#242424");
        AtomStyle[i]|=ATOM_STYLE_WHITERING;
        break;
      case 6://N
        AtomColor[i]=QColor(Qt::blue);
        AtomStyle[i]|=ATOM_STYLE_WHITERING;
        break;
      case 7://O
        AtomColor[i]=QColor(Qt::red);
        AtomStyle[i]|=ATOM_STYLE_WHITERING;
        break;
      case 8://F
        AtomColor[i]=QColor("chartreuse");
        break;
      case 9://ne
        AtomColor[i]=QColor(192,192,192,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 10://na
        AtomColor[i]=QColor(239,154,251,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 11://mg
        AtomColor[i]=QColor(51,153,255,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 12://al
        AtomColor[i]=QColor(102,179,255,128);
        break;
      case 13://si
        AtomColor[i]=QColor(128,128,128,128);
        break;
      case 14://p
        AtomColor[i]=QColor(183,41,244,128);
        break;
      case 15://s
        AtomColor[i]=QColor(190,190,0,128);
        break;
      case 16://cl
        AtomColor[i]=QColor( 65,111, 65,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;

      case 18://k
        AtomColor[i]=QColor(192,46,180,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 19://ca
        AtomColor[i]=QColor(170,170,128,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 20:
        AtomColor[i]=QColor(236,136,171,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 21:
        AtomColor[i]=QColor(242,59,3,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 22:
        AtomColor[i]=QColor(100,128,0,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 23:
        AtomColor[i]=QColor(255,255,0,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 24:
        AtomColor[i]=QColor(204,153,153,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 25:
        AtomColor[i]=QColor(0,162,0,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 26:
        AtomColor[i]=QColor(109,0,109,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 27:
        AtomColor[i]=QColor(170,82,64,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 28://Cu
        AtomColor[i]=QColor("salmon");
        AtomStyle[i]|=ATOM_STYLE_METAL;

        break;
      case 29:
        AtomColor[i]=QColor(63,123,111,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 30:
        AtomColor[i]=QColor(78,254,208,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 31:
        AtomColor[i]=QColor(136,136,136,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 32:
        AtomColor[i]=QColor(191,218,255,128);
        break;
      case 33:
        AtomColor[i]=QColor(90,23,23,128);
        break;
      case 34:
        AtomColor[i]=QColor(222,188,133,128);
        break;
      case 35:
        AtomColor[i]=QColor(240,120,0,128);
        break;
      case 36:	
        AtomColor[i]=QColor(50,15,0,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 37:
        AtomColor[i]=QColor(192,192,192,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 38:
        AtomColor[i]=QColor(204,113,32,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 39:
        AtomColor[i]=QColor(236,97,59,128);
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 40:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 41:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 42:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 43:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 44:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 45:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 46:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 47:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 48:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 49:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 54:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 55:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 56:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 57:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 58:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 59:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 61:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 62:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 63:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 67:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 68:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 69:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 70:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 71:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 72:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 73:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 74:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 75:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 76:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 77:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 79:
        AtomStyle[i]|=ATOM_STYLE_METAL;
        AtomColor[i]=QColor("silver");
        break;
      case 80:
        AtomStyle[i]|=ATOM_STYLE_METAL;
        AtomColor[i]=QColor("silver");
        break;
      case 81:
        AtomStyle[i]|=ATOM_STYLE_METAL;
        AtomColor[i]=QColor("silver");
        break;
      case 82:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 83: 
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 86:
        AtomStyle[i]|=ATOM_STYLE_METAL;
        AtomColor[i]=QColor("silver");
        break;
      case 87:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 88:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 89:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 91:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 92:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 93:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;
      case 97:
        AtomColor[i]=QColor("silver");
        AtomStyle[i]|=ATOM_STYLE_METAL;
        break;

      case 78://Au
        AtomColor[i]=QColor("goldenrod");
        AtomStyle[i]|=ATOM_STYLE_METAL;

        break;
      default:
        AtomColor[i]=QColor("silver");
        break;
    }
    AtomColor[i].setAlpha(127);
  }
  AtomStyle[0]=ATOM_STYLE_SPHERE|ATOM_STYLE_NOLABEL|ATOM_STYLE_NOADP;
}

void Molecule::mySphere(int bal){
  static const GLuint idx1[240] = {
    1,     12,     14,//  0 0.546533 0.618034 0.546533
    12,      0,     13,//  1 0.546533 0.546533 0.618034
    13,      5,     14,//  2 0.546533 0.546533 0.618034
    12,     13,     14,//  3 0.618034 0.618034 0.618034
    0,     12,     16,//  4 0.546533 0.618034 0.546533
    12,      1,     15,//  5 0.546533 0.546533 0.618034
    15,      7,     16,//  6 0.546533 0.546533 0.618034
    12,     15,     16,//  7 0.618034 0.618034 0.618034
    10,     17,     18,//  8 0.546533 0.618034 0.546533
    17,      0,     16,//  9 0.546533 0.546533 0.618034
    16,      7,     18,// 10 0.546533 0.546533 0.618034
    17,     16,     18,// 11 0.618034 0.618034 0.618034
    0,     17,     20,// 12 0.546533 0.618034 0.546533
    17,     10,     19,// 13 0.546533 0.546533 0.618034
    19,     11,     20,// 14 0.546533 0.546533 0.618034
    17,     19,     20,// 15 0.618034 0.618034 0.618034
    11,     21,     20,// 16 0.546533 0.618034 0.546533
    21,      5,     13,// 17 0.546533 0.546533 0.618034
    13,      0,     20,// 18 0.546533 0.546533 0.618034
    21,     13,     20,// 19 0.618034 0.618034 0.618034
    5,     21,     23,// 20 0.546533 0.618034 0.546533
    21,     11,     22,// 21 0.546533 0.546533 0.618034
    22,      4,     23,// 22 0.546533 0.546533 0.618034
    21,     22,     23,// 23 0.618034 0.618034 0.618034
    2,     24,     25,// 24 0.546533 0.618034 0.546533
    24,     11,     19,// 25 0.546533 0.546533 0.618034
    19,     10,     25,// 26 0.546533 0.546533 0.618034
    24,     19,     25,// 27 0.618034 0.618034 0.618034
    11,     24,     22,// 28 0.546533 0.618034 0.546533
    24,      2,     26,// 29 0.546533 0.546533 0.618034
    26,      4,     22,// 30 0.546533 0.546533 0.618034
    24,     26,     22,// 31 0.618034 0.618034 0.618034
    10,     27,     25,// 32 0.546533 0.618034 0.546533
    27,      6,     28,// 33 0.546533 0.546533 0.618034
    28,      2,     25,// 34 0.546533 0.546533 0.618034
    27,     28,     25,// 35 0.618034 0.618034 0.618034
    6,     27,     29,// 36 0.546533 0.618034 0.546533
    27,     10,     18,// 37 0.546533 0.546533 0.618034
    18,      7,     29,// 38 0.546533 0.546533 0.618034
    27,     18,     29,// 39 0.618034 0.618034 0.618034
    7,     30,     29,// 40 0.546533 0.618034 0.546533
    30,      8,     31,// 41 0.546533 0.546533 0.618034
    31,      6,     29,// 42 0.546533 0.546533 0.618034
    30,     31,     29,// 43 0.618034 0.618034 0.618034
    8,     30,     32,// 44 0.546533 0.618034 0.546533
    30,      7,     15,// 45 0.546533 0.546533 0.618034
    15,      1,     32,// 46 0.546533 0.546533 0.618034
    30,     15,     32,// 47 0.618034 0.618034 0.618034
    9,     33,     34,// 48 0.546533 0.618034 0.546533
    33,      1,     14,// 49 0.546533 0.546533 0.618034
    14,      5,     34,// 50 0.546533 0.546533 0.618034
    33,     14,     34,// 51 0.618034 0.618034 0.618034
    1,     33,     32,// 52 0.546533 0.618034 0.546533
    33,      9,     35,// 53 0.546533 0.546533 0.618034
    35,      8,     32,// 54 0.546533 0.546533 0.618034
    33,     35,     32,// 55 0.618034 0.618034 0.618034
    4,     36,     23,// 56 0.546533 0.618034 0.546533
    36,      9,     34,// 57 0.546533 0.546533 0.618034
    34,      5,     23,// 58 0.546533 0.546533 0.618034
    36,     34,     23,// 59 0.618034 0.618034 0.618034
    9,     36,     38,// 60 0.546533 0.618034 0.546533
    36,      4,     37,// 61 0.546533 0.546533 0.618034
    37,      3,     38,// 62 0.546533 0.546533 0.618034
    36,     37,     38,// 63 0.618034 0.618034 0.618034
    3,     39,     38,// 64 0.546533 0.618034 0.546533
    39,      8,     35,// 65 0.546533 0.546533 0.618034
    35,      9,     38,// 66 0.546533 0.546533 0.618034
    39,     35,     38,// 67 0.618034 0.618034 0.618034
    8,     39,     31,// 68 0.546533 0.618034 0.546533
    39,      3,     40,// 69 0.546533 0.546533 0.618034
    40,      6,     31,// 70 0.546533 0.546533 0.618034
    39,     40,     31,// 71 0.618034 0.618034 0.618034
    3,     41,     40,// 72 0.546533 0.618034 0.546533
    41,      2,     28,// 73 0.546533 0.546533 0.618034
    28,      6,     40,// 74 0.546533 0.546533 0.618034
    41,     28,     40,// 75 0.618034 0.618034 0.618034
    2,     41,     26,// 76 0.546533 0.618034 0.546533
    41,      3,     37,// 77 0.546533 0.546533 0.618034
    37,      4,     26,// 78 0.546533 0.546533 0.618034
    41,     37,     26 // 79 0.618034 0.618034 0.618034
  };
  static const GLuint idx2[960] = {
    1,     42,     44,//  0 0.275904 0.321244 0.275904
    42,     12,     43,//  1 0.275904 0.312869 0.285473
    43,     14,     44,//  2 0.312869 0.275904 0.285473
    42,     43,     44,//  3 0.285473 0.285473 0.321244
    12,     45,     47,//  4 0.275904 0.285473 0.312869
    45,      0,     46,//  5 0.275904 0.275904 0.321244
    46,     13,     47,//  6 0.275904 0.312869 0.285473
    45,     46,     47,//  7 0.321244 0.285473 0.285473
    13,     48,     50,//  8 0.275904 0.285473 0.312869
    48,      5,     49,//  9 0.275904 0.275904 0.321244
    49,     14,     50,// 10 0.275904 0.312869 0.285473
    48,     49,     50,// 11 0.321244 0.285473 0.285473
    12,     47,     43,// 12 0.312869 0.324920 0.312869
    47,     13,     50,// 13 0.312869 0.312869 0.324920
    50,     14,     43,// 14 0.312869 0.312869 0.324920
    47,     50,     43,// 15 0.324920 0.324920 0.324920
    0,     45,     52,// 16 0.275904 0.321244 0.275904
    45,     12,     51,// 17 0.275904 0.312869 0.285473
    51,     16,     52,// 18 0.312869 0.275904 0.285473
    45,     51,     52,// 19 0.285473 0.285473 0.321244
    12,     42,     54,// 20 0.275904 0.285473 0.312869
    42,      1,     53,// 21 0.275904 0.275904 0.321244
    53,     15,     54,// 22 0.275904 0.312869 0.285473
    42,     53,     54,// 23 0.321244 0.285473 0.285473
    15,     55,     57,// 24 0.275904 0.285473 0.312869
    55,      7,     56,// 25 0.275904 0.275904 0.321244
    56,     16,     57,// 26 0.275904 0.312869 0.285473
    55,     56,     57,// 27 0.321244 0.285473 0.285473
    12,     54,     51,// 28 0.312869 0.324920 0.312869
    54,     15,     57,// 29 0.312869 0.312869 0.324920
    57,     16,     51,// 30 0.312869 0.312869 0.324920
    54,     57,     51,// 31 0.324920 0.324920 0.324920
    10,     58,     60,// 32 0.275904 0.321244 0.275904
    58,     17,     59,// 33 0.275904 0.312869 0.285473
    59,     18,     60,// 34 0.312869 0.275904 0.285473
    58,     59,     60,// 35 0.285473 0.285473 0.321244
    17,     61,     62,// 36 0.275904 0.285473 0.312869
    61,      0,     52,// 37 0.275904 0.275904 0.321244
    52,     16,     62,// 38 0.275904 0.312869 0.285473
    61,     52,     62,// 39 0.321244 0.285473 0.285473
    16,     56,     64,// 40 0.275904 0.285473 0.312869
    56,      7,     63,// 41 0.275904 0.275904 0.321244
    63,     18,     64,// 42 0.275904 0.312869 0.285473
    56,     63,     64,// 43 0.321244 0.285473 0.285473
    17,     62,     59,// 44 0.312869 0.324920 0.312869
    62,     16,     64,// 45 0.312869 0.312869 0.324920
    64,     18,     59,// 46 0.312869 0.312869 0.324920
    62,     64,     59,// 47 0.324920 0.324920 0.324920
    0,     61,     66,// 48 0.275904 0.321244 0.275904
    61,     17,     65,// 49 0.275904 0.312869 0.285473
    65,     20,     66,// 50 0.312869 0.275904 0.285473
    61,     65,     66,// 51 0.285473 0.285473 0.321244
    17,     58,     68,// 52 0.275904 0.285473 0.312869
    58,     10,     67,// 53 0.275904 0.275904 0.321244
    67,     19,     68,// 54 0.275904 0.312869 0.285473
    58,     67,     68,// 55 0.321244 0.285473 0.285473
    19,     69,     71,// 56 0.275904 0.285473 0.312869
    69,     11,     70,// 57 0.275904 0.275904 0.321244
    70,     20,     71,// 58 0.275904 0.312869 0.285473
    69,     70,     71,// 59 0.321244 0.285473 0.285473
    17,     68,     65,// 60 0.312869 0.324920 0.312869
    68,     19,     71,// 61 0.312869 0.312869 0.324920
    71,     20,     65,// 62 0.312869 0.312869 0.324920
    68,     71,     65,// 63 0.324920 0.324920 0.324920
    11,     72,     70,// 64 0.275904 0.321244 0.275904
    72,     21,     73,// 65 0.275904 0.312869 0.285473
    73,     20,     70,// 66 0.312869 0.275904 0.285473
    72,     73,     70,// 67 0.285473 0.285473 0.321244
    21,     74,     75,// 68 0.275904 0.285473 0.312869
    74,      5,     48,// 69 0.275904 0.275904 0.321244
    48,     13,     75,// 70 0.275904 0.312869 0.285473
    74,     48,     75,// 71 0.321244 0.285473 0.285473
    13,     46,     76,// 72 0.275904 0.285473 0.312869
    46,      0,     66,// 73 0.275904 0.275904 0.321244
    66,     20,     76,// 74 0.275904 0.312869 0.285473
    46,     66,     76,// 75 0.321244 0.285473 0.285473
    21,     75,     73,// 76 0.312869 0.324920 0.312869
    75,     13,     76,// 77 0.312869 0.312869 0.324920
    76,     20,     73,// 78 0.312869 0.312869 0.324920
    75,     76,     73,// 79 0.324920 0.324920 0.324920
    5,     74,     78,// 80 0.275904 0.321244 0.275904
    74,     21,     77,// 81 0.275904 0.312869 0.285473
    77,     23,     78,// 82 0.312869 0.275904 0.285473
    74,     77,     78,// 83 0.285473 0.285473 0.321244
    21,     72,     80,// 84 0.275904 0.285473 0.312869
    72,     11,     79,// 85 0.275904 0.275904 0.321244
    79,     22,     80,// 86 0.275904 0.312869 0.285473
    72,     79,     80,// 87 0.321244 0.285473 0.285473
    22,     81,     83,// 88 0.275904 0.285473 0.312869
    81,      4,     82,// 89 0.275904 0.275904 0.321244
    82,     23,     83,// 90 0.275904 0.312869 0.285473
    81,     82,     83,// 91 0.321244 0.285473 0.285473
    21,     80,     77,// 92 0.312869 0.324920 0.312869
    80,     22,     83,// 93 0.312869 0.312869 0.324920
    83,     23,     77,// 94 0.312869 0.312869 0.324920
    80,     83,     77,// 95 0.324920 0.324920 0.324920
    2,     84,     86,// 96 0.275904 0.321244 0.275904
    84,     24,     85,// 97 0.275904 0.312869 0.285473
    85,     25,     86,// 98 0.312869 0.275904 0.285473
    84,     85,     86,// 99 0.285473 0.285473 0.321244
    24,     87,     88,//100 0.275904 0.285473 0.312869
    87,     11,     69,//101 0.275904 0.275904 0.321244
    69,     19,     88,//102 0.275904 0.312869 0.285473
    87,     69,     88,//103 0.321244 0.285473 0.285473
    19,     67,     90,//104 0.275904 0.285473 0.312869
    67,     10,     89,//105 0.275904 0.275904 0.321244
    89,     25,     90,//106 0.275904 0.312869 0.285473
    67,     89,     90,//107 0.321244 0.285473 0.285473
    24,     88,     85,//108 0.312869 0.324920 0.312869
    88,     19,     90,//109 0.312869 0.312869 0.324920
    90,     25,     85,//110 0.312869 0.312869 0.324920
    88,     90,     85,//111 0.324920 0.324920 0.324920
    11,     87,     79,//112 0.275904 0.321244 0.275904
    87,     24,     91,//113 0.275904 0.312869 0.285473
    91,     22,     79,//114 0.312869 0.275904 0.285473
    87,     91,     79,//115 0.285473 0.285473 0.321244
    24,     84,     93,//116 0.275904 0.285473 0.312869
    84,      2,     92,//117 0.275904 0.275904 0.321244
    92,     26,     93,//118 0.275904 0.312869 0.285473
    84,     92,     93,//119 0.321244 0.285473 0.285473
    26,     94,     95,//120 0.275904 0.285473 0.312869
    94,      4,     81,//121 0.275904 0.275904 0.321244
    81,     22,     95,//122 0.275904 0.312869 0.285473
    94,     81,     95,//123 0.321244 0.285473 0.285473
    24,     93,     91,//124 0.312869 0.324920 0.312869
    93,     26,     95,//125 0.312869 0.312869 0.324920
    95,     22,     91,//126 0.312869 0.312869 0.324920
    93,     95,     91,//127 0.324920 0.324920 0.324920
    10,     96,     89,//128 0.275904 0.321244 0.275904
    96,     27,     97,//129 0.275904 0.312869 0.285473
    97,     25,     89,//130 0.312869 0.275904 0.285473
    96,     97,     89,//131 0.285473 0.285473 0.321244
    27,     98,    100,//132 0.275904 0.285473 0.312869
    98,      6,     99,//133 0.275904 0.275904 0.321244
    99,     28,    100,//134 0.275904 0.312869 0.285473
    98,     99,    100,//135 0.321244 0.285473 0.285473
    28,    101,    102,//136 0.275904 0.285473 0.312869
    101,      2,     86,//137 0.275904 0.275904 0.321244
    86,     25,    102,//138 0.275904 0.312869 0.285473
    101,     86,    102,//139 0.321244 0.285473 0.285473
    27,    100,     97,//140 0.312869 0.324920 0.312869
    100,     28,    102,//141 0.312869 0.312869 0.324920
    102,     25,     97,//142 0.312869 0.312869 0.324920
    100,    102,     97,//143 0.324920 0.324920 0.324920
    6,     98,    104,//144 0.275904 0.321244 0.275904
    98,     27,    103,//145 0.275904 0.312869 0.285473
    103,     29,    104,//146 0.312869 0.275904 0.285473
    98,    103,    104,//147 0.285473 0.285473 0.321244
    27,     96,    105,//148 0.275904 0.285473 0.312869
    96,     10,     60,//149 0.275904 0.275904 0.321244
    60,     18,    105,//150 0.275904 0.312869 0.285473
    96,     60,    105,//151 0.321244 0.285473 0.285473
    18,     63,    107,//152 0.275904 0.285473 0.312869
    63,      7,    106,//153 0.275904 0.275904 0.321244
    106,     29,    107,//154 0.275904 0.312869 0.285473
    63,    106,    107,//155 0.321244 0.285473 0.285473
    27,    105,    103,//156 0.312869 0.324920 0.312869
    105,     18,    107,//157 0.312869 0.312869 0.324920
    107,     29,    103,//158 0.312869 0.312869 0.324920
    105,    107,    103,//159 0.324920 0.324920 0.324920
    7,    108,    106,//160 0.275904 0.321244 0.275904
    108,     30,    109,//161 0.275904 0.312869 0.285473
    109,     29,    106,//162 0.312869 0.275904 0.285473
    108,    109,    106,//163 0.285473 0.285473 0.321244
    30,    110,    112,//164 0.275904 0.285473 0.312869
    110,      8,    111,//165 0.275904 0.275904 0.321244
    111,     31,    112,//166 0.275904 0.312869 0.285473
    110,    111,    112,//167 0.321244 0.285473 0.285473
    31,    113,    114,//168 0.275904 0.285473 0.312869
    113,      6,    104,//169 0.275904 0.275904 0.321244
    104,     29,    114,//170 0.275904 0.312869 0.285473
    113,    104,    114,//171 0.321244 0.285473 0.285473
    30,    112,    109,//172 0.312869 0.324920 0.312869
    112,     31,    114,//173 0.312869 0.312869 0.324920
    114,     29,    109,//174 0.312869 0.312869 0.324920
    112,    114,    109,//175 0.324920 0.324920 0.324920
    8,    110,    116,//176 0.275904 0.321244 0.275904
    110,     30,    115,//177 0.275904 0.312869 0.285473
    115,     32,    116,//178 0.312869 0.275904 0.285473
    110,    115,    116,//179 0.285473 0.285473 0.321244
    30,    108,    117,//180 0.275904 0.285473 0.312869
    108,      7,     55,//181 0.275904 0.275904 0.321244
    55,     15,    117,//182 0.275904 0.312869 0.285473
    108,     55,    117,//183 0.321244 0.285473 0.285473
    15,     53,    119,//184 0.275904 0.285473 0.312869
    53,      1,    118,//185 0.275904 0.275904 0.321244
    118,     32,    119,//186 0.275904 0.312869 0.285473
    53,    118,    119,//187 0.321244 0.285473 0.285473
    30,    117,    115,//188 0.312869 0.324920 0.312869
    117,     15,    119,//189 0.312869 0.312869 0.324920
    119,     32,    115,//190 0.312869 0.312869 0.324920
    117,    119,    115,//191 0.324920 0.324920 0.324920
    9,    120,    122,//192 0.275904 0.321244 0.275904
    120,     33,    121,//193 0.275904 0.312869 0.285473
    121,     34,    122,//194 0.312869 0.275904 0.285473
    120,    121,    122,//195 0.285473 0.285473 0.321244
    33,    123,    124,//196 0.275904 0.285473 0.312869
    123,      1,     44,//197 0.275904 0.275904 0.321244
    44,     14,    124,//198 0.275904 0.312869 0.285473
    123,     44,    124,//199 0.321244 0.285473 0.285473
    14,     49,    126,//200 0.275904 0.285473 0.312869
    49,      5,    125,//201 0.275904 0.275904 0.321244
    125,     34,    126,//202 0.275904 0.312869 0.285473
    49,    125,    126,//203 0.321244 0.285473 0.285473
    33,    124,    121,//204 0.312869 0.324920 0.312869
    124,     14,    126,//205 0.312869 0.312869 0.324920
    126,     34,    121,//206 0.312869 0.312869 0.324920
    124,    126,    121,//207 0.324920 0.324920 0.324920
    1,    123,    118,//208 0.275904 0.321244 0.275904
    123,     33,    127,//209 0.275904 0.312869 0.285473
    127,     32,    118,//210 0.312869 0.275904 0.285473
    123,    127,    118,//211 0.285473 0.285473 0.321244
    33,    120,    129,//212 0.275904 0.285473 0.312869
    120,      9,    128,//213 0.275904 0.275904 0.321244
    128,     35,    129,//214 0.275904 0.312869 0.285473
    120,    128,    129,//215 0.321244 0.285473 0.285473
    35,    130,    131,//216 0.275904 0.285473 0.312869
    130,      8,    116,//217 0.275904 0.275904 0.321244
    116,     32,    131,//218 0.275904 0.312869 0.285473
    130,    116,    131,//219 0.321244 0.285473 0.285473
    33,    129,    127,//220 0.312869 0.324920 0.312869
    129,     35,    131,//221 0.312869 0.312869 0.324920
    131,     32,    127,//222 0.312869 0.312869 0.324920
    129,    131,    127,//223 0.324920 0.324920 0.324920
    4,    132,     82,//224 0.275904 0.321244 0.275904
    132,     36,    133,//225 0.275904 0.312869 0.285473
    133,     23,     82,//226 0.312869 0.275904 0.285473
    132,    133,     82,//227 0.285473 0.285473 0.321244
    36,    134,    135,//228 0.275904 0.285473 0.312869
    134,      9,    122,//229 0.275904 0.275904 0.321244
    122,     34,    135,//230 0.275904 0.312869 0.285473
    134,    122,    135,//231 0.321244 0.285473 0.285473
    34,    125,    136,//232 0.275904 0.285473 0.312869
    125,      5,     78,//233 0.275904 0.275904 0.321244
    78,     23,    136,//234 0.275904 0.312869 0.285473
    125,     78,    136,//235 0.321244 0.285473 0.285473
    36,    135,    133,//236 0.312869 0.324920 0.312869
    135,     34,    136,//237 0.312869 0.312869 0.324920
    136,     23,    133,//238 0.312869 0.312869 0.324920
    135,    136,    133,//239 0.324920 0.324920 0.324920
    9,    134,    138,//240 0.275904 0.321244 0.275904
    134,     36,    137,//241 0.275904 0.312869 0.285473
    137,     38,    138,//242 0.312869 0.275904 0.285473
    134,    137,    138,//243 0.285473 0.285473 0.321244
    36,    132,    140,//244 0.275904 0.285473 0.312869
    132,      4,    139,//245 0.275904 0.275904 0.321244
    139,     37,    140,//246 0.275904 0.312869 0.285473
    132,    139,    140,//247 0.321244 0.285473 0.285473
    37,    141,    143,//248 0.275904 0.285473 0.312869
    141,      3,    142,//249 0.275904 0.275904 0.321244
    142,     38,    143,//250 0.275904 0.312869 0.285473
    141,    142,    143,//251 0.321244 0.285473 0.285473
    36,    140,    137,//252 0.312869 0.324920 0.312869
    140,     37,    143,//253 0.312869 0.312869 0.324920
    143,     38,    137,//254 0.312869 0.312869 0.324920
    140,    143,    137,//255 0.324920 0.324920 0.324920
    3,    144,    142,//256 0.275904 0.321244 0.275904
    144,     39,    145,//257 0.275904 0.312869 0.285473
    145,     38,    142,//258 0.312869 0.275904 0.285473
    144,    145,    142,//259 0.285473 0.285473 0.321244
    39,    146,    147,//260 0.275904 0.285473 0.312869
    146,      8,    130,//261 0.275904 0.275904 0.321244
    130,     35,    147,//262 0.275904 0.312869 0.285473
    146,    130,    147,//263 0.321244 0.285473 0.285473
    35,    128,    148,//264 0.275904 0.285473 0.312869
    128,      9,    138,//265 0.275904 0.275904 0.321244
    138,     38,    148,//266 0.275904 0.312869 0.285473
    128,    138,    148,//267 0.321244 0.285473 0.285473
    39,    147,    145,//268 0.312869 0.324920 0.312869
    147,     35,    148,//269 0.312869 0.312869 0.324920
    148,     38,    145,//270 0.312869 0.312869 0.324920
    147,    148,    145,//271 0.324920 0.324920 0.324920
    8,    146,    111,//272 0.275904 0.321244 0.275904
    146,     39,    149,//273 0.275904 0.312869 0.285473
    149,     31,    111,//274 0.312869 0.275904 0.285473
    146,    149,    111,//275 0.285473 0.285473 0.321244
    39,    144,    151,//276 0.275904 0.285473 0.312869
    144,      3,    150,//277 0.275904 0.275904 0.321244
    150,     40,    151,//278 0.275904 0.312869 0.285473
    144,    150,    151,//279 0.321244 0.285473 0.285473
    40,    152,    153,//280 0.275904 0.285473 0.312869
    152,      6,    113,//281 0.275904 0.275904 0.321244
    113,     31,    153,//282 0.275904 0.312869 0.285473
    152,    113,    153,//283 0.321244 0.285473 0.285473
    39,    151,    149,//284 0.312869 0.324920 0.312869
    151,     40,    153,//285 0.312869 0.312869 0.324920
    153,     31,    149,//286 0.312869 0.312869 0.324920
    151,    153,    149,//287 0.324920 0.324920 0.324920
    3,    154,    150,//288 0.275904 0.321244 0.275904
    154,     41,    155,//289 0.275904 0.312869 0.285473
    155,     40,    150,//290 0.312869 0.275904 0.285473
    154,    155,    150,//291 0.285473 0.285473 0.321244
    41,    156,    157,//292 0.275904 0.285473 0.312869
    156,      2,    101,//293 0.275904 0.275904 0.321244
    101,     28,    157,//294 0.275904 0.312869 0.285473
    156,    101,    157,//295 0.321244 0.285473 0.285473
    28,     99,    158,//296 0.275904 0.285473 0.312869
    99,      6,    152,//297 0.275904 0.275904 0.321244
    152,     40,    158,//298 0.275904 0.312869 0.285473
    99,    152,    158,//299 0.321244 0.285473 0.285473
    41,    157,    155,//300 0.312869 0.324920 0.312869
    157,     28,    158,//301 0.312869 0.312869 0.324920
    158,     40,    155,//302 0.312869 0.312869 0.324920
    157,    158,    155,//303 0.324920 0.324920 0.324920
    2,    156,     92,//304 0.275904 0.321244 0.275904
    156,     41,    159,//305 0.275904 0.312869 0.285473
    159,     26,     92,//306 0.312869 0.275904 0.285473
    156,    159,     92,//307 0.285473 0.285473 0.321244
    41,    154,    160,//308 0.275904 0.285473 0.312869
    154,      3,    141,//309 0.275904 0.275904 0.321244
    141,     37,    160,//310 0.275904 0.312869 0.285473
    154,    141,    160,//311 0.321244 0.285473 0.285473
    37,    139,    161,//312 0.275904 0.285473 0.312869
    139,      4,     94,//313 0.275904 0.275904 0.321244
    94,     26,    161,//314 0.275904 0.312869 0.285473
    139,     94,    161,//315 0.321244 0.285473 0.285473
    41,    160,    159,//316 0.312869 0.324920 0.312869
    160,     37,    161,//317 0.312869 0.312869 0.324920
    161,     26,    159,//318 0.312869 0.312869 0.324920
    160,    161,    159 //319 0.324920 0.324920 0.324920
  };
  static const GLuint idx3[3840] = {
    1,    162,    164,//  0 0.138283 0.162173 0.138283
    162,     42,    163,//  1 0.138283 0.161146 0.139482
    163,     44,    164,//  2 0.161146 0.138283 0.139482
    162,    163,    164,//  3 0.139482 0.139482 0.162173
    42,    165,    167,//  4 0.138283 0.157997 0.143103
    165,     12,    166,//  5 0.138283 0.156918 0.144288
    166,     43,    167,//  6 0.156918 0.143103 0.139510
    165,    166,    167,//  7 0.144288 0.139510 0.157997
    43,    168,    170,//  8 0.156918 0.139510 0.143103
    168,     14,    169,//  9 0.156918 0.138283 0.144288
    169,     44,    170,// 10 0.138283 0.143103 0.157997
    168,    169,    170,// 11 0.144288 0.157997 0.139510
    42,    167,    163,// 12 0.143103 0.144387 0.161146
    167,     43,    170,// 13 0.143103 0.143103 0.162284
    170,     44,    163,// 14 0.143103 0.161146 0.144387
    167,    170,    163,// 15 0.162284 0.144387 0.144387
    12,    171,    173,// 16 0.138283 0.144288 0.156918
    171,     45,    172,// 17 0.138283 0.143103 0.157997
    172,     47,    173,// 18 0.143103 0.156918 0.139510
    171,    172,    173,// 19 0.157997 0.139510 0.144288
    45,    174,    176,// 20 0.138283 0.139482 0.161146
    174,      0,    175,// 21 0.138283 0.138283 0.162173
    175,     46,    176,// 22 0.138283 0.161146 0.139482
    174,    175,    176,// 23 0.162173 0.139482 0.139482
    46,    177,    179,// 24 0.138283 0.157997 0.143103
    177,     13,    178,// 25 0.138283 0.156918 0.144288
    178,     47,    179,// 26 0.156918 0.143103 0.139510
    177,    178,    179,// 27 0.144288 0.139510 0.157997
    45,    176,    172,// 28 0.161146 0.144387 0.143103
    176,     46,    179,// 29 0.161146 0.143103 0.144387
    179,     47,    172,// 30 0.143103 0.143103 0.162284
    176,    179,    172,// 31 0.144387 0.162284 0.144387
    13,    180,    182,// 32 0.138283 0.144288 0.156918
    180,     48,    181,// 33 0.138283 0.143103 0.157997
    181,     50,    182,// 34 0.143103 0.156918 0.139510
    180,    181,    182,// 35 0.157997 0.139510 0.144288
    48,    183,    185,// 36 0.138283 0.139482 0.161146
    183,      5,    184,// 37 0.138283 0.138283 0.162173
    184,     49,    185,// 38 0.138283 0.161146 0.139482
    183,    184,    185,// 39 0.162173 0.139482 0.139482
    49,    186,    188,// 40 0.138283 0.157997 0.143103
    186,     14,    187,// 41 0.138283 0.156918 0.144288
    187,     50,    188,// 42 0.156918 0.143103 0.139510
    186,    187,    188,// 43 0.144288 0.139510 0.157997
    48,    185,    181,// 44 0.161146 0.144387 0.143103
    185,     49,    188,// 45 0.161146 0.143103 0.144387
    188,     50,    181,// 46 0.143103 0.143103 0.162284
    185,    188,    181,// 47 0.144387 0.162284 0.144387
    12,    173,    166,// 48 0.156918 0.164485 0.156918
    173,     47,    189,// 49 0.156918 0.163002 0.158459
    189,     43,    166,// 50 0.163002 0.156918 0.158459
    173,    189,    166,// 51 0.158459 0.158459 0.164485
    47,    178,    190,// 52 0.156918 0.158459 0.163002
    178,     13,    182,// 53 0.156918 0.156918 0.164485
    182,     50,    190,// 54 0.156918 0.163002 0.158459
    178,    182,    190,// 55 0.164485 0.158459 0.158459
    50,    187,    191,// 56 0.156918 0.158459 0.163002
    187,     14,    168,// 57 0.156918 0.156918 0.164485
    168,     43,    191,// 58 0.156918 0.163002 0.158459
    187,    168,    191,// 59 0.164485 0.158459 0.158459
    47,    190,    189,// 60 0.163002 0.164647 0.163002
    190,     50,    191,// 61 0.163002 0.163002 0.164647
    191,     43,    189,// 62 0.163002 0.163002 0.164647
    190,    191,    189,// 63 0.164647 0.164647 0.164647
    0,    174,    193,// 64 0.138283 0.162173 0.138283
    174,     45,    192,// 65 0.138283 0.161146 0.139482
    192,     52,    193,// 66 0.161146 0.138283 0.139482
    174,    192,    193,// 67 0.139482 0.139482 0.162173
    45,    171,    195,// 68 0.138283 0.157997 0.143103
    171,     12,    194,// 69 0.138283 0.156918 0.144288
    194,     51,    195,// 70 0.156918 0.143103 0.139510
    171,    194,    195,// 71 0.144288 0.139510 0.157997
    51,    196,    198,// 72 0.156918 0.139510 0.143103
    196,     16,    197,// 73 0.156918 0.138283 0.144288
    197,     52,    198,// 74 0.138283 0.143103 0.157997
    196,    197,    198,// 75 0.144288 0.157997 0.139510
    45,    195,    192,// 76 0.143103 0.144387 0.161146
    195,     51,    198,// 77 0.143103 0.143103 0.162284
    198,     52,    192,// 78 0.143103 0.161146 0.144387
    195,    198,    192,// 79 0.162284 0.144387 0.144387
    12,    165,    200,// 80 0.138283 0.144288 0.156918
    165,     42,    199,// 81 0.138283 0.143103 0.157997
    199,     54,    200,// 82 0.143103 0.156918 0.139510
    165,    199,    200,// 83 0.157997 0.139510 0.144288
    42,    162,    202,// 84 0.138283 0.139482 0.161146
    162,      1,    201,// 85 0.138283 0.138283 0.162173
    201,     53,    202,// 86 0.138283 0.161146 0.139482
    162,    201,    202,// 87 0.162173 0.139482 0.139482
    53,    203,    205,// 88 0.138283 0.157997 0.143103
    203,     15,    204,// 89 0.138283 0.156918 0.144288
    204,     54,    205,// 90 0.156918 0.143103 0.139510
    203,    204,    205,// 91 0.144288 0.139510 0.157997
    42,    202,    199,// 92 0.161146 0.144387 0.143103
    202,     53,    205,// 93 0.161146 0.143103 0.144387
    205,     54,    199,// 94 0.143103 0.143103 0.162284
    202,    205,    199,// 95 0.144387 0.162284 0.144387
    15,    206,    208,// 96 0.138283 0.144288 0.156918
    206,     55,    207,// 97 0.138283 0.143103 0.157997
    207,     57,    208,// 98 0.143103 0.156918 0.139510
    206,    207,    208,// 99 0.157997 0.139510 0.144288
    55,    209,    211,//100 0.138283 0.139482 0.161146
    209,      7,    210,//101 0.138283 0.138283 0.162173
    210,     56,    211,//102 0.138283 0.161146 0.139482
    209,    210,    211,//103 0.162173 0.139482 0.139482
    56,    212,    214,//104 0.138283 0.157997 0.143103
    212,     16,    213,//105 0.138283 0.156918 0.144288
    213,     57,    214,//106 0.156918 0.143103 0.139510
    212,    213,    214,//107 0.144288 0.139510 0.157997
    55,    211,    207,//108 0.161146 0.144387 0.143103
    211,     56,    214,//109 0.161146 0.143103 0.144387
    214,     57,    207,//110 0.143103 0.143103 0.162284
    211,    214,    207,//111 0.144387 0.162284 0.144387
    12,    200,    194,//112 0.156918 0.164485 0.156918
    200,     54,    215,//113 0.156918 0.163002 0.158459
    215,     51,    194,//114 0.163002 0.156918 0.158459
    200,    215,    194,//115 0.158459 0.158459 0.164485
    54,    204,    216,//116 0.156918 0.158459 0.163002
    204,     15,    208,//117 0.156918 0.156918 0.164485
    208,     57,    216,//118 0.156918 0.163002 0.158459
    204,    208,    216,//119 0.164485 0.158459 0.158459
    57,    213,    217,//120 0.156918 0.158459 0.163002
    213,     16,    196,//121 0.156918 0.156918 0.164485
    196,     51,    217,//122 0.156918 0.163002 0.158459
    213,    196,    217,//123 0.164485 0.158459 0.158459
    54,    216,    215,//124 0.163002 0.164647 0.163002
    216,     57,    217,//125 0.163002 0.163002 0.164647
    217,     51,    215,//126 0.163002 0.163002 0.164647
    216,    217,    215,//127 0.164647 0.164647 0.164647
    10,    218,    220,//128 0.138283 0.162173 0.138283
    218,     58,    219,//129 0.138283 0.161146 0.139482
    219,     60,    220,//130 0.161146 0.138283 0.139482
    218,    219,    220,//131 0.139482 0.139482 0.162173
    58,    221,    223,//132 0.138283 0.157997 0.143103
    221,     17,    222,//133 0.138283 0.156918 0.144288
    222,     59,    223,//134 0.156918 0.143103 0.139510
    221,    222,    223,//135 0.144288 0.139510 0.157997
    59,    224,    226,//136 0.156918 0.139510 0.143103
    224,     18,    225,//137 0.156918 0.138283 0.144288
    225,     60,    226,//138 0.138283 0.143103 0.157997
    224,    225,    226,//139 0.144288 0.157997 0.139510
    58,    223,    219,//140 0.143103 0.144387 0.161146
    223,     59,    226,//141 0.143103 0.143103 0.162284
    226,     60,    219,//142 0.143103 0.161146 0.144387
    223,    226,    219,//143 0.162284 0.144387 0.144387
    17,    227,    229,//144 0.138283 0.144288 0.156918
    227,     61,    228,//145 0.138283 0.143103 0.157997
    228,     62,    229,//146 0.143103 0.156918 0.139510
    227,    228,    229,//147 0.157997 0.139510 0.144288
    61,    230,    231,//148 0.138283 0.139482 0.161146
    230,      0,    193,//149 0.138283 0.138283 0.162173
    193,     52,    231,//150 0.138283 0.161146 0.139482
    230,    193,    231,//151 0.162173 0.139482 0.139482
    52,    197,    233,//152 0.138283 0.157997 0.143103
    197,     16,    232,//153 0.138283 0.156918 0.144288
    232,     62,    233,//154 0.156918 0.143103 0.139510
    197,    232,    233,//155 0.144288 0.139510 0.157997
    61,    231,    228,//156 0.161146 0.144387 0.143103
    231,     52,    233,//157 0.161146 0.143103 0.144387
    233,     62,    228,//158 0.143103 0.143103 0.162284
    231,    233,    228,//159 0.144387 0.162284 0.144387
    16,    212,    235,//160 0.138283 0.144288 0.156918
    212,     56,    234,//161 0.138283 0.143103 0.157997
    234,     64,    235,//162 0.143103 0.156918 0.139510
    212,    234,    235,//163 0.157997 0.139510 0.144288
    56,    210,    237,//164 0.138283 0.139482 0.161146
    210,      7,    236,//165 0.138283 0.138283 0.162173
    236,     63,    237,//166 0.138283 0.161146 0.139482
    210,    236,    237,//167 0.162173 0.139482 0.139482
    63,    238,    240,//168 0.138283 0.157997 0.143103
    238,     18,    239,//169 0.138283 0.156918 0.144288
    239,     64,    240,//170 0.156918 0.143103 0.139510
    238,    239,    240,//171 0.144288 0.139510 0.157997
    56,    237,    234,//172 0.161146 0.144387 0.143103
    237,     63,    240,//173 0.161146 0.143103 0.144387
    240,     64,    234,//174 0.143103 0.143103 0.162284
    237,    240,    234,//175 0.144387 0.162284 0.144387
    17,    229,    222,//176 0.156918 0.164485 0.156918
    229,     62,    241,//177 0.156918 0.163002 0.158459
    241,     59,    222,//178 0.163002 0.156918 0.158459
    229,    241,    222,//179 0.158459 0.158459 0.164485
    62,    232,    242,//180 0.156918 0.158459 0.163002
    232,     16,    235,//181 0.156918 0.156918 0.164485
    235,     64,    242,//182 0.156918 0.163002 0.158459
    232,    235,    242,//183 0.164485 0.158459 0.158459
    64,    239,    243,//184 0.156918 0.158459 0.163002
    239,     18,    224,//185 0.156918 0.156918 0.164485
    224,     59,    243,//186 0.156918 0.163002 0.158459
    239,    224,    243,//187 0.164485 0.158459 0.158459
    62,    242,    241,//188 0.163002 0.164647 0.163002
    242,     64,    243,//189 0.163002 0.163002 0.164647
    243,     59,    241,//190 0.163002 0.163002 0.164647
    242,    243,    241,//191 0.164647 0.164647 0.164647
    0,    230,    245,//192 0.138283 0.162173 0.138283
    230,     61,    244,//193 0.138283 0.161146 0.139482
    244,     66,    245,//194 0.161146 0.138283 0.139482
    230,    244,    245,//195 0.139482 0.139482 0.162173
    61,    227,    247,//196 0.138283 0.157997 0.143103
    227,     17,    246,//197 0.138283 0.156918 0.144288
    246,     65,    247,//198 0.156918 0.143103 0.139510
    227,    246,    247,//199 0.144288 0.139510 0.157997
    65,    248,    250,//200 0.156918 0.139510 0.143103
    248,     20,    249,//201 0.156918 0.138283 0.144288
    249,     66,    250,//202 0.138283 0.143103 0.157997
    248,    249,    250,//203 0.144288 0.157997 0.139510
    61,    247,    244,//204 0.143103 0.144387 0.161146
    247,     65,    250,//205 0.143103 0.143103 0.162284
    250,     66,    244,//206 0.143103 0.161146 0.144387
    247,    250,    244,//207 0.162284 0.144387 0.144387
    17,    221,    252,//208 0.138283 0.144288 0.156918
    221,     58,    251,//209 0.138283 0.143103 0.157997
    251,     68,    252,//210 0.143103 0.156918 0.139510
    221,    251,    252,//211 0.157997 0.139510 0.144288
    58,    218,    254,//212 0.138283 0.139482 0.161146
    218,     10,    253,//213 0.138283 0.138283 0.162173
    253,     67,    254,//214 0.138283 0.161146 0.139482
    218,    253,    254,//215 0.162173 0.139482 0.139482
    67,    255,    257,//216 0.138283 0.157997 0.143103
    255,     19,    256,//217 0.138283 0.156918 0.144288
    256,     68,    257,//218 0.156918 0.143103 0.139510
    255,    256,    257,//219 0.144288 0.139510 0.157997
    58,    254,    251,//220 0.161146 0.144387 0.143103
    254,     67,    257,//221 0.161146 0.143103 0.144387
    257,     68,    251,//222 0.143103 0.143103 0.162284
    254,    257,    251,//223 0.144387 0.162284 0.144387
    19,    258,    260,//224 0.138283 0.144288 0.156918
    258,     69,    259,//225 0.138283 0.143103 0.157997
    259,     71,    260,//226 0.143103 0.156918 0.139510
    258,    259,    260,//227 0.157997 0.139510 0.144288
    69,    261,    263,//228 0.138283 0.139482 0.161146
    261,     11,    262,//229 0.138283 0.138283 0.162173
    262,     70,    263,//230 0.138283 0.161146 0.139482
    261,    262,    263,//231 0.162173 0.139482 0.139482
    70,    264,    266,//232 0.138283 0.157997 0.143103
    264,     20,    265,//233 0.138283 0.156918 0.144288
    265,     71,    266,//234 0.156918 0.143103 0.139510
    264,    265,    266,//235 0.144288 0.139510 0.157997
    69,    263,    259,//236 0.161146 0.144387 0.143103
    263,     70,    266,//237 0.161146 0.143103 0.144387
    266,     71,    259,//238 0.143103 0.143103 0.162284
    263,    266,    259,//239 0.144387 0.162284 0.144387
    17,    252,    246,//240 0.156918 0.164485 0.156918
    252,     68,    267,//241 0.156918 0.163002 0.158459
    267,     65,    246,//242 0.163002 0.156918 0.158459
    252,    267,    246,//243 0.158459 0.158459 0.164485
    68,    256,    268,//244 0.156918 0.158459 0.163002
    256,     19,    260,//245 0.156918 0.156918 0.164485
    260,     71,    268,//246 0.156918 0.163002 0.158459
    256,    260,    268,//247 0.164485 0.158459 0.158459
    71,    265,    269,//248 0.156918 0.158459 0.163002
    265,     20,    248,//249 0.156918 0.156918 0.164485
    248,     65,    269,//250 0.156918 0.163002 0.158459
    265,    248,    269,//251 0.164485 0.158459 0.158459
    68,    268,    267,//252 0.163002 0.164647 0.163002
    268,     71,    269,//253 0.163002 0.163002 0.164647
    269,     65,    267,//254 0.163002 0.163002 0.164647
    268,    269,    267,//255 0.164647 0.164647 0.164647
    11,    270,    262,//256 0.138283 0.162173 0.138283
    270,     72,    271,//257 0.138283 0.161146 0.139482
    271,     70,    262,//258 0.161146 0.138283 0.139482
    270,    271,    262,//259 0.139482 0.139482 0.162173
    72,    272,    274,//260 0.138283 0.157997 0.143103
    272,     21,    273,//261 0.138283 0.156918 0.144288
    273,     73,    274,//262 0.156918 0.143103 0.139510
    272,    273,    274,//263 0.144288 0.139510 0.157997
    73,    275,    276,//264 0.156918 0.139510 0.143103
    275,     20,    264,//265 0.156918 0.138283 0.144288
    264,     70,    276,//266 0.138283 0.143103 0.157997
    275,    264,    276,//267 0.144288 0.157997 0.139510
    72,    274,    271,//268 0.143103 0.144387 0.161146
    274,     73,    276,//269 0.143103 0.143103 0.162284
    276,     70,    271,//270 0.143103 0.161146 0.144387
    274,    276,    271,//271 0.162284 0.144387 0.144387
    21,    277,    279,//272 0.138283 0.144288 0.156918
    277,     74,    278,//273 0.138283 0.143103 0.157997
    278,     75,    279,//274 0.143103 0.156918 0.139510
    277,    278,    279,//275 0.157997 0.139510 0.144288
    74,    280,    281,//276 0.138283 0.139482 0.161146
    280,      5,    183,//277 0.138283 0.138283 0.162173
    183,     48,    281,//278 0.138283 0.161146 0.139482
    280,    183,    281,//279 0.162173 0.139482 0.139482
    48,    180,    283,//280 0.138283 0.157997 0.143103
    180,     13,    282,//281 0.138283 0.156918 0.144288
    282,     75,    283,//282 0.156918 0.143103 0.139510
    180,    282,    283,//283 0.144288 0.139510 0.157997
    74,    281,    278,//284 0.161146 0.144387 0.143103
    281,     48,    283,//285 0.161146 0.143103 0.144387
    283,     75,    278,//286 0.143103 0.143103 0.162284
    281,    283,    278,//287 0.144387 0.162284 0.144387
    13,    177,    285,//288 0.138283 0.144288 0.156918
    177,     46,    284,//289 0.138283 0.143103 0.157997
    284,     76,    285,//290 0.143103 0.156918 0.139510
    177,    284,    285,//291 0.157997 0.139510 0.144288
    46,    175,    286,//292 0.138283 0.139482 0.161146
    175,      0,    245,//293 0.138283 0.138283 0.162173
    245,     66,    286,//294 0.138283 0.161146 0.139482
    175,    245,    286,//295 0.162173 0.139482 0.139482
    66,    249,    288,//296 0.138283 0.157997 0.143103
    249,     20,    287,//297 0.138283 0.156918 0.144288
    287,     76,    288,//298 0.156918 0.143103 0.139510
    249,    287,    288,//299 0.144288 0.139510 0.157997
    46,    286,    284,//300 0.161146 0.144387 0.143103
    286,     66,    288,//301 0.161146 0.143103 0.144387
    288,     76,    284,//302 0.143103 0.143103 0.162284
    286,    288,    284,//303 0.144387 0.162284 0.144387
    21,    279,    273,//304 0.156918 0.164485 0.156918
    279,     75,    289,//305 0.156918 0.163002 0.158459
    289,     73,    273,//306 0.163002 0.156918 0.158459
    279,    289,    273,//307 0.158459 0.158459 0.164485
    75,    282,    290,//308 0.156918 0.158459 0.163002
    282,     13,    285,//309 0.156918 0.156918 0.164485
    285,     76,    290,//310 0.156918 0.163002 0.158459
    282,    285,    290,//311 0.164485 0.158459 0.158459
    76,    287,    291,//312 0.156918 0.158459 0.163002
    287,     20,    275,//313 0.156918 0.156918 0.164485
    275,     73,    291,//314 0.156918 0.163002 0.158459
    287,    275,    291,//315 0.164485 0.158459 0.158459
    75,    290,    289,//316 0.163002 0.164647 0.163002
    290,     76,    291,//317 0.163002 0.163002 0.164647
    291,     73,    289,//318 0.163002 0.163002 0.164647
    290,    291,    289,//319 0.164647 0.164647 0.164647
    5,    280,    293,//320 0.138283 0.162173 0.138283
    280,     74,    292,//321 0.138283 0.161146 0.139482
    292,     78,    293,//322 0.161146 0.138283 0.139482
    280,    292,    293,//323 0.139482 0.139482 0.162173
    74,    277,    295,//324 0.138283 0.157997 0.143103
    277,     21,    294,//325 0.138283 0.156918 0.144288
    294,     77,    295,//326 0.156918 0.143103 0.139510
    277,    294,    295,//327 0.144288 0.139510 0.157997
    77,    296,    298,//328 0.156918 0.139510 0.143103
    296,     23,    297,//329 0.156918 0.138283 0.144288
    297,     78,    298,//330 0.138283 0.143103 0.157997
    296,    297,    298,//331 0.144288 0.157997 0.139510
    74,    295,    292,//332 0.143103 0.144387 0.161146
    295,     77,    298,//333 0.143103 0.143103 0.162284
    298,     78,    292,//334 0.143103 0.161146 0.144387
    295,    298,    292,//335 0.162284 0.144387 0.144387
    21,    272,    300,//336 0.138283 0.144288 0.156918
    272,     72,    299,//337 0.138283 0.143103 0.157997
    299,     80,    300,//338 0.143103 0.156918 0.139510
    272,    299,    300,//339 0.157997 0.139510 0.144288
    72,    270,    302,//340 0.138283 0.139482 0.161146
    270,     11,    301,//341 0.138283 0.138283 0.162173
    301,     79,    302,//342 0.138283 0.161146 0.139482
    270,    301,    302,//343 0.162173 0.139482 0.139482
    79,    303,    305,//344 0.138283 0.157997 0.143103
    303,     22,    304,//345 0.138283 0.156918 0.144288
    304,     80,    305,//346 0.156918 0.143103 0.139510
    303,    304,    305,//347 0.144288 0.139510 0.157997
    72,    302,    299,//348 0.161146 0.144387 0.143103
    302,     79,    305,//349 0.161146 0.143103 0.144387
    305,     80,    299,//350 0.143103 0.143103 0.162284
    302,    305,    299,//351 0.144387 0.162284 0.144387
    22,    306,    308,//352 0.138283 0.144288 0.156918
    306,     81,    307,//353 0.138283 0.143103 0.157997
    307,     83,    308,//354 0.143103 0.156918 0.139510
    306,    307,    308,//355 0.157997 0.139510 0.144288
    81,    309,    311,//356 0.138283 0.139482 0.161146
    309,      4,    310,//357 0.138283 0.138283 0.162173
    310,     82,    311,//358 0.138283 0.161146 0.139482
    309,    310,    311,//359 0.162173 0.139482 0.139482
    82,    312,    314,//360 0.138283 0.157997 0.143103
    312,     23,    313,//361 0.138283 0.156918 0.144288
    313,     83,    314,//362 0.156918 0.143103 0.139510
    312,    313,    314,//363 0.144288 0.139510 0.157997
    81,    311,    307,//364 0.161146 0.144387 0.143103
    311,     82,    314,//365 0.161146 0.143103 0.144387
    314,     83,    307,//366 0.143103 0.143103 0.162284
    311,    314,    307,//367 0.144387 0.162284 0.144387
    21,    300,    294,//368 0.156918 0.164485 0.156918
    300,     80,    315,//369 0.156918 0.163002 0.158459
    315,     77,    294,//370 0.163002 0.156918 0.158459
    300,    315,    294,//371 0.158459 0.158459 0.164485
    80,    304,    316,//372 0.156918 0.158459 0.163002
    304,     22,    308,//373 0.156918 0.156918 0.164485
    308,     83,    316,//374 0.156918 0.163002 0.158459
    304,    308,    316,//375 0.164485 0.158459 0.158459
    83,    313,    317,//376 0.156918 0.158459 0.163002
    313,     23,    296,//377 0.156918 0.156918 0.164485
    296,     77,    317,//378 0.156918 0.163002 0.158459
    313,    296,    317,//379 0.164485 0.158459 0.158459
    80,    316,    315,//380 0.163002 0.164647 0.163002
    316,     83,    317,//381 0.163002 0.163002 0.164647
    317,     77,    315,//382 0.163002 0.163002 0.164647
    316,    317,    315,//383 0.164647 0.164647 0.164647
    2,    318,    320,//384 0.138283 0.162173 0.138283
    318,     84,    319,//385 0.138283 0.161146 0.139482
    319,     86,    320,//386 0.161146 0.138283 0.139482
    318,    319,    320,//387 0.139482 0.139482 0.162173
    84,    321,    323,//388 0.138283 0.157997 0.143103
    321,     24,    322,//389 0.138283 0.156918 0.144288
    322,     85,    323,//390 0.156918 0.143103 0.139510
    321,    322,    323,//391 0.144288 0.139510 0.157997
    85,    324,    326,//392 0.156918 0.139510 0.143103
    324,     25,    325,//393 0.156918 0.138283 0.144288
    325,     86,    326,//394 0.138283 0.143103 0.157997
    324,    325,    326,//395 0.144288 0.157997 0.139510
    84,    323,    319,//396 0.143103 0.144387 0.161146
    323,     85,    326,//397 0.143103 0.143103 0.162284
    326,     86,    319,//398 0.143103 0.161146 0.144387
    323,    326,    319,//399 0.162284 0.144387 0.144387
    24,    327,    329,//400 0.138283 0.144288 0.156918
    327,     87,    328,//401 0.138283 0.143103 0.157997
    328,     88,    329,//402 0.143103 0.156918 0.139510
    327,    328,    329,//403 0.157997 0.139510 0.144288
    87,    330,    331,//404 0.138283 0.139482 0.161146
    330,     11,    261,//405 0.138283 0.138283 0.162173
    261,     69,    331,//406 0.138283 0.161146 0.139482
    330,    261,    331,//407 0.162173 0.139482 0.139482
    69,    258,    333,//408 0.138283 0.157997 0.143103
    258,     19,    332,//409 0.138283 0.156918 0.144288
    332,     88,    333,//410 0.156918 0.143103 0.139510
    258,    332,    333,//411 0.144288 0.139510 0.157997
    87,    331,    328,//412 0.161146 0.144387 0.143103
    331,     69,    333,//413 0.161146 0.143103 0.144387
    333,     88,    328,//414 0.143103 0.143103 0.162284
    331,    333,    328,//415 0.144387 0.162284 0.144387
    19,    255,    335,//416 0.138283 0.144288 0.156918
    255,     67,    334,//417 0.138283 0.143103 0.157997
    334,     90,    335,//418 0.143103 0.156918 0.139510
    255,    334,    335,//419 0.157997 0.139510 0.144288
    67,    253,    337,//420 0.138283 0.139482 0.161146
    253,     10,    336,//421 0.138283 0.138283 0.162173
    336,     89,    337,//422 0.138283 0.161146 0.139482
    253,    336,    337,//423 0.162173 0.139482 0.139482
    89,    338,    340,//424 0.138283 0.157997 0.143103
    338,     25,    339,//425 0.138283 0.156918 0.144288
    339,     90,    340,//426 0.156918 0.143103 0.139510
    338,    339,    340,//427 0.144288 0.139510 0.157997
    67,    337,    334,//428 0.161146 0.144387 0.143103
    337,     89,    340,//429 0.161146 0.143103 0.144387
    340,     90,    334,//430 0.143103 0.143103 0.162284
    337,    340,    334,//431 0.144387 0.162284 0.144387
    24,    329,    322,//432 0.156918 0.164485 0.156918
    329,     88,    341,//433 0.156918 0.163002 0.158459
    341,     85,    322,//434 0.163002 0.156918 0.158459
    329,    341,    322,//435 0.158459 0.158459 0.164485
    88,    332,    342,//436 0.156918 0.158459 0.163002
    332,     19,    335,//437 0.156918 0.156918 0.164485
    335,     90,    342,//438 0.156918 0.163002 0.158459
    332,    335,    342,//439 0.164485 0.158459 0.158459
    90,    339,    343,//440 0.156918 0.158459 0.163002
    339,     25,    324,//441 0.156918 0.156918 0.164485
    324,     85,    343,//442 0.156918 0.163002 0.158459
    339,    324,    343,//443 0.164485 0.158459 0.158459
    88,    342,    341,//444 0.163002 0.164647 0.163002
    342,     90,    343,//445 0.163002 0.163002 0.164647
    343,     85,    341,//446 0.163002 0.163002 0.164647
    342,    343,    341,//447 0.164647 0.164647 0.164647
    11,    330,    301,//448 0.138283 0.162173 0.138283
    330,     87,    344,//449 0.138283 0.161146 0.139482
    344,     79,    301,//450 0.161146 0.138283 0.139482
    330,    344,    301,//451 0.139482 0.139482 0.162173
    87,    327,    346,//452 0.138283 0.157997 0.143103
    327,     24,    345,//453 0.138283 0.156918 0.144288
    345,     91,    346,//454 0.156918 0.143103 0.139510
    327,    345,    346,//455 0.144288 0.139510 0.157997
    91,    347,    348,//456 0.156918 0.139510 0.143103
    347,     22,    303,//457 0.156918 0.138283 0.144288
    303,     79,    348,//458 0.138283 0.143103 0.157997
    347,    303,    348,//459 0.144288 0.157997 0.139510
    87,    346,    344,//460 0.143103 0.144387 0.161146
    346,     91,    348,//461 0.143103 0.143103 0.162284
    348,     79,    344,//462 0.143103 0.161146 0.144387
    346,    348,    344,//463 0.162284 0.144387 0.144387
    24,    321,    350,//464 0.138283 0.144288 0.156918
    321,     84,    349,//465 0.138283 0.143103 0.157997
    349,     93,    350,//466 0.143103 0.156918 0.139510
    321,    349,    350,//467 0.157997 0.139510 0.144288
    84,    318,    352,//468 0.138283 0.139482 0.161146
    318,      2,    351,//469 0.138283 0.138283 0.162173
    351,     92,    352,//470 0.138283 0.161146 0.139482
    318,    351,    352,//471 0.162173 0.139482 0.139482
    92,    353,    355,//472 0.138283 0.157997 0.143103
    353,     26,    354,//473 0.138283 0.156918 0.144288
    354,     93,    355,//474 0.156918 0.143103 0.139510
    353,    354,    355,//475 0.144288 0.139510 0.157997
    84,    352,    349,//476 0.161146 0.144387 0.143103
    352,     92,    355,//477 0.161146 0.143103 0.144387
    355,     93,    349,//478 0.143103 0.143103 0.162284
    352,    355,    349,//479 0.144387 0.162284 0.144387
    26,    356,    358,//480 0.138283 0.144288 0.156918
    356,     94,    357,//481 0.138283 0.143103 0.157997
    357,     95,    358,//482 0.143103 0.156918 0.139510
    356,    357,    358,//483 0.157997 0.139510 0.144288
    94,    359,    360,//484 0.138283 0.139482 0.161146
    359,      4,    309,//485 0.138283 0.138283 0.162173
    309,     81,    360,//486 0.138283 0.161146 0.139482
    359,    309,    360,//487 0.162173 0.139482 0.139482
    81,    306,    362,//488 0.138283 0.157997 0.143103
    306,     22,    361,//489 0.138283 0.156918 0.144288
    361,     95,    362,//490 0.156918 0.143103 0.139510
    306,    361,    362,//491 0.144288 0.139510 0.157997
    94,    360,    357,//492 0.161146 0.144387 0.143103
    360,     81,    362,//493 0.161146 0.143103 0.144387
    362,     95,    357,//494 0.143103 0.143103 0.162284
    360,    362,    357,//495 0.144387 0.162284 0.144387
    24,    350,    345,//496 0.156918 0.164485 0.156918
    350,     93,    363,//497 0.156918 0.163002 0.158459
    363,     91,    345,//498 0.163002 0.156918 0.158459
    350,    363,    345,//499 0.158459 0.158459 0.164485
    93,    354,    364,//500 0.156918 0.158459 0.163002
    354,     26,    358,//501 0.156918 0.156918 0.164485
    358,     95,    364,//502 0.156918 0.163002 0.158459
    354,    358,    364,//503 0.164485 0.158459 0.158459
    95,    361,    365,//504 0.156918 0.158459 0.163002
    361,     22,    347,//505 0.156918 0.156918 0.164485
    347,     91,    365,//506 0.156918 0.163002 0.158459
    361,    347,    365,//507 0.164485 0.158459 0.158459
    93,    364,    363,//508 0.163002 0.164647 0.163002
    364,     95,    365,//509 0.163002 0.163002 0.164647
    365,     91,    363,//510 0.163002 0.163002 0.164647
    364,    365,    363,//511 0.164647 0.164647 0.164647
    10,    366,    336,//512 0.138283 0.162173 0.138283
    366,     96,    367,//513 0.138283 0.161146 0.139482
    367,     89,    336,//514 0.161146 0.138283 0.139482
    366,    367,    336,//515 0.139482 0.139482 0.162173
    96,    368,    370,//516 0.138283 0.157997 0.143103
    368,     27,    369,//517 0.138283 0.156918 0.144288
    369,     97,    370,//518 0.156918 0.143103 0.139510
    368,    369,    370,//519 0.144288 0.139510 0.157997
    97,    371,    372,//520 0.156918 0.139510 0.143103
    371,     25,    338,//521 0.156918 0.138283 0.144288
    338,     89,    372,//522 0.138283 0.143103 0.157997
    371,    338,    372,//523 0.144288 0.157997 0.139510
    96,    370,    367,//524 0.143103 0.144387 0.161146
    370,     97,    372,//525 0.143103 0.143103 0.162284
    372,     89,    367,//526 0.143103 0.161146 0.144387
    370,    372,    367,//527 0.162284 0.144387 0.144387
    27,    373,    375,//528 0.138283 0.144288 0.156918
    373,     98,    374,//529 0.138283 0.143103 0.157997
    374,    100,    375,//530 0.143103 0.156918 0.139510
    373,    374,    375,//531 0.157997 0.139510 0.144288
    98,    376,    378,//532 0.138283 0.139482 0.161146
    376,      6,    377,//533 0.138283 0.138283 0.162173
    377,     99,    378,//534 0.138283 0.161146 0.139482
    376,    377,    378,//535 0.162173 0.139482 0.139482
    99,    379,    381,//536 0.138283 0.157997 0.143103
    379,     28,    380,//537 0.138283 0.156918 0.144288
    380,    100,    381,//538 0.156918 0.143103 0.139510
    379,    380,    381,//539 0.144288 0.139510 0.157997
    98,    378,    374,//540 0.161146 0.144387 0.143103
    378,     99,    381,//541 0.161146 0.143103 0.144387
    381,    100,    374,//542 0.143103 0.143103 0.162284
    378,    381,    374,//543 0.144387 0.162284 0.144387
    28,    382,    384,//544 0.138283 0.144288 0.156918
    382,    101,    383,//545 0.138283 0.143103 0.157997
    383,    102,    384,//546 0.143103 0.156918 0.139510
    382,    383,    384,//547 0.157997 0.139510 0.144288
    101,    385,    386,//548 0.138283 0.139482 0.161146
    385,      2,    320,//549 0.138283 0.138283 0.162173
    320,     86,    386,//550 0.138283 0.161146 0.139482
    385,    320,    386,//551 0.162173 0.139482 0.139482
    86,    325,    388,//552 0.138283 0.157997 0.143103
    325,     25,    387,//553 0.138283 0.156918 0.144288
    387,    102,    388,//554 0.156918 0.143103 0.139510
    325,    387,    388,//555 0.144288 0.139510 0.157997
    101,    386,    383,//556 0.161146 0.144387 0.143103
    386,     86,    388,//557 0.161146 0.143103 0.144387
    388,    102,    383,//558 0.143103 0.143103 0.162284
    386,    388,    383,//559 0.144387 0.162284 0.144387
    27,    375,    369,//560 0.156918 0.164485 0.156918
    375,    100,    389,//561 0.156918 0.163002 0.158459
    389,     97,    369,//562 0.163002 0.156918 0.158459
    375,    389,    369,//563 0.158459 0.158459 0.164485
    100,    380,    390,//564 0.156918 0.158459 0.163002
    380,     28,    384,//565 0.156918 0.156918 0.164485
    384,    102,    390,//566 0.156918 0.163002 0.158459
    380,    384,    390,//567 0.164485 0.158459 0.158459
    102,    387,    391,//568 0.156918 0.158459 0.163002
    387,     25,    371,//569 0.156918 0.156918 0.164485
    371,     97,    391,//570 0.156918 0.163002 0.158459
    387,    371,    391,//571 0.164485 0.158459 0.158459
    100,    390,    389,//572 0.163002 0.164647 0.163002
    390,    102,    391,//573 0.163002 0.163002 0.164647
    391,     97,    389,//574 0.163002 0.163002 0.164647
    390,    391,    389,//575 0.164647 0.164647 0.164647
    6,    376,    393,//576 0.138283 0.162173 0.138283
    376,     98,    392,//577 0.138283 0.161146 0.139482
    392,    104,    393,//578 0.161146 0.138283 0.139482
    376,    392,    393,//579 0.139482 0.139482 0.162173
    98,    373,    395,//580 0.138283 0.157997 0.143103
    373,     27,    394,//581 0.138283 0.156918 0.144288
    394,    103,    395,//582 0.156918 0.143103 0.139510
    373,    394,    395,//583 0.144288 0.139510 0.157997
    103,    396,    398,//584 0.156918 0.139510 0.143103
    396,     29,    397,//585 0.156918 0.138283 0.144288
    397,    104,    398,//586 0.138283 0.143103 0.157997
    396,    397,    398,//587 0.144288 0.157997 0.139510
    98,    395,    392,//588 0.143103 0.144387 0.161146
    395,    103,    398,//589 0.143103 0.143103 0.162284
    398,    104,    392,//590 0.143103 0.161146 0.144387
    395,    398,    392,//591 0.162284 0.144387 0.144387
    27,    368,    400,//592 0.138283 0.144288 0.156918
    368,     96,    399,//593 0.138283 0.143103 0.157997
    399,    105,    400,//594 0.143103 0.156918 0.139510
    368,    399,    400,//595 0.157997 0.139510 0.144288
    96,    366,    401,//596 0.138283 0.139482 0.161146
    366,     10,    220,//597 0.138283 0.138283 0.162173
    220,     60,    401,//598 0.138283 0.161146 0.139482
    366,    220,    401,//599 0.162173 0.139482 0.139482
    60,    225,    403,//600 0.138283 0.157997 0.143103
    225,     18,    402,//601 0.138283 0.156918 0.144288
    402,    105,    403,//602 0.156918 0.143103 0.139510
    225,    402,    403,//603 0.144288 0.139510 0.157997
    96,    401,    399,//604 0.161146 0.144387 0.143103
    401,     60,    403,//605 0.161146 0.143103 0.144387
    403,    105,    399,//606 0.143103 0.143103 0.162284
    401,    403,    399,//607 0.144387 0.162284 0.144387
    18,    238,    405,//608 0.138283 0.144288 0.156918
    238,     63,    404,//609 0.138283 0.143103 0.157997
    404,    107,    405,//610 0.143103 0.156918 0.139510
    238,    404,    405,//611 0.157997 0.139510 0.144288
    63,    236,    407,//612 0.138283 0.139482 0.161146
    236,      7,    406,//613 0.138283 0.138283 0.162173
    406,    106,    407,//614 0.138283 0.161146 0.139482
    236,    406,    407,//615 0.162173 0.139482 0.139482
    106,    408,    410,//616 0.138283 0.157997 0.143103
    408,     29,    409,//617 0.138283 0.156918 0.144288
    409,    107,    410,//618 0.156918 0.143103 0.139510
    408,    409,    410,//619 0.144288 0.139510 0.157997
    63,    407,    404,//620 0.161146 0.144387 0.143103
    407,    106,    410,//621 0.161146 0.143103 0.144387
    410,    107,    404,//622 0.143103 0.143103 0.162284
    407,    410,    404,//623 0.144387 0.162284 0.144387
    27,    400,    394,//624 0.156918 0.164485 0.156918
    400,    105,    411,//625 0.156918 0.163002 0.158459
    411,    103,    394,//626 0.163002 0.156918 0.158459
    400,    411,    394,//627 0.158459 0.158459 0.164485
    105,    402,    412,//628 0.156918 0.158459 0.163002
    402,     18,    405,//629 0.156918 0.156918 0.164485
    405,    107,    412,//630 0.156918 0.163002 0.158459
    402,    405,    412,//631 0.164485 0.158459 0.158459
    107,    409,    413,//632 0.156918 0.158459 0.163002
    409,     29,    396,//633 0.156918 0.156918 0.164485
    396,    103,    413,//634 0.156918 0.163002 0.158459
    409,    396,    413,//635 0.164485 0.158459 0.158459
    105,    412,    411,//636 0.163002 0.164647 0.163002
    412,    107,    413,//637 0.163002 0.163002 0.164647
    413,    103,    411,//638 0.163002 0.163002 0.164647
    412,    413,    411,//639 0.164647 0.164647 0.164647
    7,    414,    406,//640 0.138283 0.162173 0.138283
    414,    108,    415,//641 0.138283 0.161146 0.139482
    415,    106,    406,//642 0.161146 0.138283 0.139482
    414,    415,    406,//643 0.139482 0.139482 0.162173
    108,    416,    418,//644 0.138283 0.157997 0.143103
    416,     30,    417,//645 0.138283 0.156918 0.144288
    417,    109,    418,//646 0.156918 0.143103 0.139510
    416,    417,    418,//647 0.144288 0.139510 0.157997
    109,    419,    420,//648 0.156918 0.139510 0.143103
    419,     29,    408,//649 0.156918 0.138283 0.144288
    408,    106,    420,//650 0.138283 0.143103 0.157997
    419,    408,    420,//651 0.144288 0.157997 0.139510
    108,    418,    415,//652 0.143103 0.144387 0.161146
    418,    109,    420,//653 0.143103 0.143103 0.162284
    420,    106,    415,//654 0.143103 0.161146 0.144387
    418,    420,    415,//655 0.162284 0.144387 0.144387
    30,    421,    423,//656 0.138283 0.144288 0.156918
    421,    110,    422,//657 0.138283 0.143103 0.157997
    422,    112,    423,//658 0.143103 0.156918 0.139510
    421,    422,    423,//659 0.157997 0.139510 0.144288
    110,    424,    426,//660 0.138283 0.139482 0.161146
    424,      8,    425,//661 0.138283 0.138283 0.162173
    425,    111,    426,//662 0.138283 0.161146 0.139482
    424,    425,    426,//663 0.162173 0.139482 0.139482
    111,    427,    429,//664 0.138283 0.157997 0.143103
    427,     31,    428,//665 0.138283 0.156918 0.144288
    428,    112,    429,//666 0.156918 0.143103 0.139510
    427,    428,    429,//667 0.144288 0.139510 0.157997
    110,    426,    422,//668 0.161146 0.144387 0.143103
    426,    111,    429,//669 0.161146 0.143103 0.144387
    429,    112,    422,//670 0.143103 0.143103 0.162284
    426,    429,    422,//671 0.144387 0.162284 0.144387
    31,    430,    432,//672 0.138283 0.144288 0.156918
    430,    113,    431,//673 0.138283 0.143103 0.157997
    431,    114,    432,//674 0.143103 0.156918 0.139510
    430,    431,    432,//675 0.157997 0.139510 0.144288
    113,    433,    434,//676 0.138283 0.139482 0.161146
    433,      6,    393,//677 0.138283 0.138283 0.162173
    393,    104,    434,//678 0.138283 0.161146 0.139482
    433,    393,    434,//679 0.162173 0.139482 0.139482
    104,    397,    436,//680 0.138283 0.157997 0.143103
    397,     29,    435,//681 0.138283 0.156918 0.144288
    435,    114,    436,//682 0.156918 0.143103 0.139510
    397,    435,    436,//683 0.144288 0.139510 0.157997
    113,    434,    431,//684 0.161146 0.144387 0.143103
    434,    104,    436,//685 0.161146 0.143103 0.144387
    436,    114,    431,//686 0.143103 0.143103 0.162284
    434,    436,    431,//687 0.144387 0.162284 0.144387
    30,    423,    417,//688 0.156918 0.164485 0.156918
    423,    112,    437,//689 0.156918 0.163002 0.158459
    437,    109,    417,//690 0.163002 0.156918 0.158459
    423,    437,    417,//691 0.158459 0.158459 0.164485
    112,    428,    438,//692 0.156918 0.158459 0.163002
    428,     31,    432,//693 0.156918 0.156918 0.164485
    432,    114,    438,//694 0.156918 0.163002 0.158459
    428,    432,    438,//695 0.164485 0.158459 0.158459
    114,    435,    439,//696 0.156918 0.158459 0.163002
    435,     29,    419,//697 0.156918 0.156918 0.164485
    419,    109,    439,//698 0.156918 0.163002 0.158459
    435,    419,    439,//699 0.164485 0.158459 0.158459
    112,    438,    437,//700 0.163002 0.164647 0.163002
    438,    114,    439,//701 0.163002 0.163002 0.164647
    439,    109,    437,//702 0.163002 0.163002 0.164647
    438,    439,    437,//703 0.164647 0.164647 0.164647
    8,    424,    441,//704 0.138283 0.162173 0.138283
    424,    110,    440,//705 0.138283 0.161146 0.139482
    440,    116,    441,//706 0.161146 0.138283 0.139482
    424,    440,    441,//707 0.139482 0.139482 0.162173
    110,    421,    443,//708 0.138283 0.157997 0.143103
    421,     30,    442,//709 0.138283 0.156918 0.144288
    442,    115,    443,//710 0.156918 0.143103 0.139510
    421,    442,    443,//711 0.144288 0.139510 0.157997
    115,    444,    446,//712 0.156918 0.139510 0.143103
    444,     32,    445,//713 0.156918 0.138283 0.144288
    445,    116,    446,//714 0.138283 0.143103 0.157997
    444,    445,    446,//715 0.144288 0.157997 0.139510
    110,    443,    440,//716 0.143103 0.144387 0.161146
    443,    115,    446,//717 0.143103 0.143103 0.162284
    446,    116,    440,//718 0.143103 0.161146 0.144387
    443,    446,    440,//719 0.162284 0.144387 0.144387
    30,    416,    448,//720 0.138283 0.144288 0.156918
    416,    108,    447,//721 0.138283 0.143103 0.157997
    447,    117,    448,//722 0.143103 0.156918 0.139510
    416,    447,    448,//723 0.157997 0.139510 0.144288
    108,    414,    449,//724 0.138283 0.139482 0.161146
    414,      7,    209,//725 0.138283 0.138283 0.162173
    209,     55,    449,//726 0.138283 0.161146 0.139482
    414,    209,    449,//727 0.162173 0.139482 0.139482
    55,    206,    451,//728 0.138283 0.157997 0.143103
    206,     15,    450,//729 0.138283 0.156918 0.144288
    450,    117,    451,//730 0.156918 0.143103 0.139510
    206,    450,    451,//731 0.144288 0.139510 0.157997
    108,    449,    447,//732 0.161146 0.144387 0.143103
    449,     55,    451,//733 0.161146 0.143103 0.144387
    451,    117,    447,//734 0.143103 0.143103 0.162284
    449,    451,    447,//735 0.144387 0.162284 0.144387
    15,    203,    453,//736 0.138283 0.144288 0.156918
    203,     53,    452,//737 0.138283 0.143103 0.157997
    452,    119,    453,//738 0.143103 0.156918 0.139510
    203,    452,    453,//739 0.157997 0.139510 0.144288
    53,    201,    455,//740 0.138283 0.139482 0.161146
    201,      1,    454,//741 0.138283 0.138283 0.162173
    454,    118,    455,//742 0.138283 0.161146 0.139482
    201,    454,    455,//743 0.162173 0.139482 0.139482
    118,    456,    458,//744 0.138283 0.157997 0.143103
    456,     32,    457,//745 0.138283 0.156918 0.144288
    457,    119,    458,//746 0.156918 0.143103 0.139510
    456,    457,    458,//747 0.144288 0.139510 0.157997
    53,    455,    452,//748 0.161146 0.144387 0.143103
    455,    118,    458,//749 0.161146 0.143103 0.144387
    458,    119,    452,//750 0.143103 0.143103 0.162284
    455,    458,    452,//751 0.144387 0.162284 0.144387
    30,    448,    442,//752 0.156918 0.164485 0.156918
    448,    117,    459,//753 0.156918 0.163002 0.158459
    459,    115,    442,//754 0.163002 0.156918 0.158459
    448,    459,    442,//755 0.158459 0.158459 0.164485
    117,    450,    460,//756 0.156918 0.158459 0.163002
    450,     15,    453,//757 0.156918 0.156918 0.164485
    453,    119,    460,//758 0.156918 0.163002 0.158459
    450,    453,    460,//759 0.164485 0.158459 0.158459
    119,    457,    461,//760 0.156918 0.158459 0.163002
    457,     32,    444,//761 0.156918 0.156918 0.164485
    444,    115,    461,//762 0.156918 0.163002 0.158459
    457,    444,    461,//763 0.164485 0.158459 0.158459
    117,    460,    459,//764 0.163002 0.164647 0.163002
    460,    119,    461,//765 0.163002 0.163002 0.164647
    461,    115,    459,//766 0.163002 0.163002 0.164647
    460,    461,    459,//767 0.164647 0.164647 0.164647
    9,    462,    464,//768 0.138283 0.162173 0.138283
    462,    120,    463,//769 0.138283 0.161146 0.139482
    463,    122,    464,//770 0.161146 0.138283 0.139482
    462,    463,    464,//771 0.139482 0.139482 0.162173
    120,    465,    467,//772 0.138283 0.157997 0.143103
    465,     33,    466,//773 0.138283 0.156918 0.144288
    466,    121,    467,//774 0.156918 0.143103 0.139510
    465,    466,    467,//775 0.144288 0.139510 0.157997
    121,    468,    470,//776 0.156918 0.139510 0.143103
    468,     34,    469,//777 0.156918 0.138283 0.144288
    469,    122,    470,//778 0.138283 0.143103 0.157997
    468,    469,    470,//779 0.144288 0.157997 0.139510
    120,    467,    463,//780 0.143103 0.144387 0.161146
    467,    121,    470,//781 0.143103 0.143103 0.162284
    470,    122,    463,//782 0.143103 0.161146 0.144387
    467,    470,    463,//783 0.162284 0.144387 0.144387
    33,    471,    473,//784 0.138283 0.144288 0.156918
    471,    123,    472,//785 0.138283 0.143103 0.157997
    472,    124,    473,//786 0.143103 0.156918 0.139510
    471,    472,    473,//787 0.157997 0.139510 0.144288
    123,    474,    475,//788 0.138283 0.139482 0.161146
    474,      1,    164,//789 0.138283 0.138283 0.162173
    164,     44,    475,//790 0.138283 0.161146 0.139482
    474,    164,    475,//791 0.162173 0.139482 0.139482
    44,    169,    477,//792 0.138283 0.157997 0.143103
    169,     14,    476,//793 0.138283 0.156918 0.144288
    476,    124,    477,//794 0.156918 0.143103 0.139510
    169,    476,    477,//795 0.144288 0.139510 0.157997
    123,    475,    472,//796 0.161146 0.144387 0.143103
    475,     44,    477,//797 0.161146 0.143103 0.144387
    477,    124,    472,//798 0.143103 0.143103 0.162284
    475,    477,    472,//799 0.144387 0.162284 0.144387
    14,    186,    479,//800 0.138283 0.144288 0.156918
    186,     49,    478,//801 0.138283 0.143103 0.157997
    478,    126,    479,//802 0.143103 0.156918 0.139510
    186,    478,    479,//803 0.157997 0.139510 0.144288
    49,    184,    481,//804 0.138283 0.139482 0.161146
    184,      5,    480,//805 0.138283 0.138283 0.162173
    480,    125,    481,//806 0.138283 0.161146 0.139482
    184,    480,    481,//807 0.162173 0.139482 0.139482
    125,    482,    484,//808 0.138283 0.157997 0.143103
    482,     34,    483,//809 0.138283 0.156918 0.144288
    483,    126,    484,//810 0.156918 0.143103 0.139510
    482,    483,    484,//811 0.144288 0.139510 0.157997
    49,    481,    478,//812 0.161146 0.144387 0.143103
    481,    125,    484,//813 0.161146 0.143103 0.144387
    484,    126,    478,//814 0.143103 0.143103 0.162284
    481,    484,    478,//815 0.144387 0.162284 0.144387
    33,    473,    466,//816 0.156918 0.164485 0.156918
    473,    124,    485,//817 0.156918 0.163002 0.158459
    485,    121,    466,//818 0.163002 0.156918 0.158459
    473,    485,    466,//819 0.158459 0.158459 0.164485
    124,    476,    486,//820 0.156918 0.158459 0.163002
    476,     14,    479,//821 0.156918 0.156918 0.164485
    479,    126,    486,//822 0.156918 0.163002 0.158459
    476,    479,    486,//823 0.164485 0.158459 0.158459
    126,    483,    487,//824 0.156918 0.158459 0.163002
    483,     34,    468,//825 0.156918 0.156918 0.164485
    468,    121,    487,//826 0.156918 0.163002 0.158459
    483,    468,    487,//827 0.164485 0.158459 0.158459
    124,    486,    485,//828 0.163002 0.164647 0.163002
    486,    126,    487,//829 0.163002 0.163002 0.164647
    487,    121,    485,//830 0.163002 0.163002 0.164647
    486,    487,    485,//831 0.164647 0.164647 0.164647
    1,    474,    454,//832 0.138283 0.162173 0.138283
    474,    123,    488,//833 0.138283 0.161146 0.139482
    488,    118,    454,//834 0.161146 0.138283 0.139482
    474,    488,    454,//835 0.139482 0.139482 0.162173
    123,    471,    490,//836 0.138283 0.157997 0.143103
    471,     33,    489,//837 0.138283 0.156918 0.144288
    489,    127,    490,//838 0.156918 0.143103 0.139510
    471,    489,    490,//839 0.144288 0.139510 0.157997
    127,    491,    492,//840 0.156918 0.139510 0.143103
    491,     32,    456,//841 0.156918 0.138283 0.144288
    456,    118,    492,//842 0.138283 0.143103 0.157997
    491,    456,    492,//843 0.144288 0.157997 0.139510
    123,    490,    488,//844 0.143103 0.144387 0.161146
    490,    127,    492,//845 0.143103 0.143103 0.162284
    492,    118,    488,//846 0.143103 0.161146 0.144387
    490,    492,    488,//847 0.162284 0.144387 0.144387
    33,    465,    494,//848 0.138283 0.144288 0.156918
    465,    120,    493,//849 0.138283 0.143103 0.157997
    493,    129,    494,//850 0.143103 0.156918 0.139510
    465,    493,    494,//851 0.157997 0.139510 0.144288
    120,    462,    496,//852 0.138283 0.139482 0.161146
    462,      9,    495,//853 0.138283 0.138283 0.162173
    495,    128,    496,//854 0.138283 0.161146 0.139482
    462,    495,    496,//855 0.162173 0.139482 0.139482
    128,    497,    499,//856 0.138283 0.157997 0.143103
    497,     35,    498,//857 0.138283 0.156918 0.144288
    498,    129,    499,//858 0.156918 0.143103 0.139510
    497,    498,    499,//859 0.144288 0.139510 0.157997
    120,    496,    493,//860 0.161146 0.144387 0.143103
    496,    128,    499,//861 0.161146 0.143103 0.144387
    499,    129,    493,//862 0.143103 0.143103 0.162284
    496,    499,    493,//863 0.144387 0.162284 0.144387
    35,    500,    502,//864 0.138283 0.144288 0.156918
    500,    130,    501,//865 0.138283 0.143103 0.157997
    501,    131,    502,//866 0.143103 0.156918 0.139510
    500,    501,    502,//867 0.157997 0.139510 0.144288
    130,    503,    504,//868 0.138283 0.139482 0.161146
    503,      8,    441,//869 0.138283 0.138283 0.162173
    441,    116,    504,//870 0.138283 0.161146 0.139482
    503,    441,    504,//871 0.162173 0.139482 0.139482
    116,    445,    506,//872 0.138283 0.157997 0.143103
    445,     32,    505,//873 0.138283 0.156918 0.144288
    505,    131,    506,//874 0.156918 0.143103 0.139510
    445,    505,    506,//875 0.144288 0.139510 0.157997
    130,    504,    501,//876 0.161146 0.144387 0.143103
    504,    116,    506,//877 0.161146 0.143103 0.144387
    506,    131,    501,//878 0.143103 0.143103 0.162284
    504,    506,    501,//879 0.144387 0.162284 0.144387
    33,    494,    489,//880 0.156918 0.164485 0.156918
    494,    129,    507,//881 0.156918 0.163002 0.158459
    507,    127,    489,//882 0.163002 0.156918 0.158459
    494,    507,    489,//883 0.158459 0.158459 0.164485
    129,    498,    508,//884 0.156918 0.158459 0.163002
    498,     35,    502,//885 0.156918 0.156918 0.164485
    502,    131,    508,//886 0.156918 0.163002 0.158459
    498,    502,    508,//887 0.164485 0.158459 0.158459
    131,    505,    509,//888 0.156918 0.158459 0.163002
    505,     32,    491,//889 0.156918 0.156918 0.164485
    491,    127,    509,//890 0.156918 0.163002 0.158459
    505,    491,    509,//891 0.164485 0.158459 0.158459
    129,    508,    507,//892 0.163002 0.164647 0.163002
    508,    131,    509,//893 0.163002 0.163002 0.164647
    509,    127,    507,//894 0.163002 0.163002 0.164647
    508,    509,    507,//895 0.164647 0.164647 0.164647
    4,    510,    310,//896 0.138283 0.162173 0.138283
    510,    132,    511,//897 0.138283 0.161146 0.139482
    511,     82,    310,//898 0.161146 0.138283 0.139482
    510,    511,    310,//899 0.139482 0.139482 0.162173
    132,    512,    514,//900 0.138283 0.157997 0.143103
    512,     36,    513,//901 0.138283 0.156918 0.144288
    513,    133,    514,//902 0.156918 0.143103 0.139510
    512,    513,    514,//903 0.144288 0.139510 0.157997
    133,    515,    516,//904 0.156918 0.139510 0.143103
    515,     23,    312,//905 0.156918 0.138283 0.144288
    312,     82,    516,//906 0.138283 0.143103 0.157997
    515,    312,    516,//907 0.144288 0.157997 0.139510
    132,    514,    511,//908 0.143103 0.144387 0.161146
    514,    133,    516,//909 0.143103 0.143103 0.162284
    516,     82,    511,//910 0.143103 0.161146 0.144387
    514,    516,    511,//911 0.162284 0.144387 0.144387
    36,    517,    519,//912 0.138283 0.144288 0.156918
    517,    134,    518,//913 0.138283 0.143103 0.157997
    518,    135,    519,//914 0.143103 0.156918 0.139510
    517,    518,    519,//915 0.157997 0.139510 0.144288
    134,    520,    521,//916 0.138283 0.139482 0.161146
    520,      9,    464,//917 0.138283 0.138283 0.162173
    464,    122,    521,//918 0.138283 0.161146 0.139482
    520,    464,    521,//919 0.162173 0.139482 0.139482
    122,    469,    523,//920 0.138283 0.157997 0.143103
    469,     34,    522,//921 0.138283 0.156918 0.144288
    522,    135,    523,//922 0.156918 0.143103 0.139510
    469,    522,    523,//923 0.144288 0.139510 0.157997
    134,    521,    518,//924 0.161146 0.144387 0.143103
    521,    122,    523,//925 0.161146 0.143103 0.144387
    523,    135,    518,//926 0.143103 0.143103 0.162284
    521,    523,    518,//927 0.144387 0.162284 0.144387
    34,    482,    525,//928 0.138283 0.144288 0.156918
    482,    125,    524,//929 0.138283 0.143103 0.157997
    524,    136,    525,//930 0.143103 0.156918 0.139510
    482,    524,    525,//931 0.157997 0.139510 0.144288
    125,    480,    526,//932 0.138283 0.139482 0.161146
    480,      5,    293,//933 0.138283 0.138283 0.162173
    293,     78,    526,//934 0.138283 0.161146 0.139482
    480,    293,    526,//935 0.162173 0.139482 0.139482
    78,    297,    528,//936 0.138283 0.157997 0.143103
    297,     23,    527,//937 0.138283 0.156918 0.144288
    527,    136,    528,//938 0.156918 0.143103 0.139510
    297,    527,    528,//939 0.144288 0.139510 0.157997
    125,    526,    524,//940 0.161146 0.144387 0.143103
    526,     78,    528,//941 0.161146 0.143103 0.144387
    528,    136,    524,//942 0.143103 0.143103 0.162284
    526,    528,    524,//943 0.144387 0.162284 0.144387
    36,    519,    513,//944 0.156918 0.164485 0.156918
    519,    135,    529,//945 0.156918 0.163002 0.158459
    529,    133,    513,//946 0.163002 0.156918 0.158459
    519,    529,    513,//947 0.158459 0.158459 0.164485
    135,    522,    530,//948 0.156918 0.158459 0.163002
    522,     34,    525,//949 0.156918 0.156918 0.164485
    525,    136,    530,//950 0.156918 0.163002 0.158459
    522,    525,    530,//951 0.164485 0.158459 0.158459
    136,    527,    531,//952 0.156918 0.158459 0.163002
    527,     23,    515,//953 0.156918 0.156918 0.164485
    515,    133,    531,//954 0.156918 0.163002 0.158459
    527,    515,    531,//955 0.164485 0.158459 0.158459
    135,    530,    529,//956 0.163002 0.164647 0.163002
    530,    136,    531,//957 0.163002 0.163002 0.164647
    531,    133,    529,//958 0.163002 0.163002 0.164647
    530,    531,    529,//959 0.164647 0.164647 0.164647
    9,    520,    533,//960 0.138283 0.162173 0.138283
    520,    134,    532,//961 0.138283 0.161146 0.139482
    532,    138,    533,//962 0.161146 0.138283 0.139482
    520,    532,    533,//963 0.139482 0.139482 0.162173
    134,    517,    535,//964 0.138283 0.157997 0.143103
    517,     36,    534,//965 0.138283 0.156918 0.144288
    534,    137,    535,//966 0.156918 0.143103 0.139510
    517,    534,    535,//967 0.144288 0.139510 0.157997
    137,    536,    538,//968 0.156918 0.139510 0.143103
    536,     38,    537,//969 0.156918 0.138283 0.144288
    537,    138,    538,//970 0.138283 0.143103 0.157997
    536,    537,    538,//971 0.144288 0.157997 0.139510
    134,    535,    532,//972 0.143103 0.144387 0.161146
    535,    137,    538,//973 0.143103 0.143103 0.162284
    538,    138,    532,//974 0.143103 0.161146 0.144387
    535,    538,    532,//975 0.162284 0.144387 0.144387
    36,    512,    540,//976 0.138283 0.144288 0.156918
    512,    132,    539,//977 0.138283 0.143103 0.157997
    539,    140,    540,//978 0.143103 0.156918 0.139510
    512,    539,    540,//979 0.157997 0.139510 0.144288
    132,    510,    542,//980 0.138283 0.139482 0.161146
    510,      4,    541,//981 0.138283 0.138283 0.162173
    541,    139,    542,//982 0.138283 0.161146 0.139482
    510,    541,    542,//983 0.162173 0.139482 0.139482
    139,    543,    545,//984 0.138283 0.157997 0.143103
    543,     37,    544,//985 0.138283 0.156918 0.144288
    544,    140,    545,//986 0.156918 0.143103 0.139510
    543,    544,    545,//987 0.144288 0.139510 0.157997
    132,    542,    539,//988 0.161146 0.144387 0.143103
    542,    139,    545,//989 0.161146 0.143103 0.144387
    545,    140,    539,//990 0.143103 0.143103 0.162284
    542,    545,    539,//991 0.144387 0.162284 0.144387
    37,    546,    548,//992 0.138283 0.144288 0.156918
    546,    141,    547,//993 0.138283 0.143103 0.157997
    547,    143,    548,//994 0.143103 0.156918 0.139510
    546,    547,    548,//995 0.157997 0.139510 0.144288
    141,    549,    551,//996 0.138283 0.139482 0.161146
    549,      3,    550,//997 0.138283 0.138283 0.162173
    550,    142,    551,//998 0.138283 0.161146 0.139482
    549,    550,    551,//999 0.162173 0.139482 0.139482
    142,    552,    554,//1000 0.138283 0.157997 0.143103
    552,     38,    553,//1001 0.138283 0.156918 0.144288
    553,    143,    554,//1002 0.156918 0.143103 0.139510
    552,    553,    554,//1003 0.144288 0.139510 0.157997
    141,    551,    547,//1004 0.161146 0.144387 0.143103
    551,    142,    554,//1005 0.161146 0.143103 0.144387
    554,    143,    547,//1006 0.143103 0.143103 0.162284
    551,    554,    547,//1007 0.144387 0.162284 0.144387
    36,    540,    534,//1008 0.156918 0.164485 0.156918
    540,    140,    555,//1009 0.156918 0.163002 0.158459
    555,    137,    534,//1010 0.163002 0.156918 0.158459
    540,    555,    534,//1011 0.158459 0.158459 0.164485
    140,    544,    556,//1012 0.156918 0.158459 0.163002
    544,     37,    548,//1013 0.156918 0.156918 0.164485
    548,    143,    556,//1014 0.156918 0.163002 0.158459
    544,    548,    556,//1015 0.164485 0.158459 0.158459
    143,    553,    557,//1016 0.156918 0.158459 0.163002
    553,     38,    536,//1017 0.156918 0.156918 0.164485
    536,    137,    557,//1018 0.156918 0.163002 0.158459
    553,    536,    557,//1019 0.164485 0.158459 0.158459
    140,    556,    555,//1020 0.163002 0.164647 0.163002
    556,    143,    557,//1021 0.163002 0.163002 0.164647
    557,    137,    555,//1022 0.163002 0.163002 0.164647
    556,    557,    555,//1023 0.164647 0.164647 0.164647
    3,    558,    550,//1024 0.138283 0.162173 0.138283
    558,    144,    559,//1025 0.138283 0.161146 0.139482
    559,    142,    550,//1026 0.161146 0.138283 0.139482
    558,    559,    550,//1027 0.139482 0.139482 0.162173
    144,    560,    562,//1028 0.138283 0.157997 0.143103
    560,     39,    561,//1029 0.138283 0.156918 0.144288
    561,    145,    562,//1030 0.156918 0.143103 0.139510
    560,    561,    562,//1031 0.144288 0.139510 0.157997
    145,    563,    564,//1032 0.156918 0.139510 0.143103
    563,     38,    552,//1033 0.156918 0.138283 0.144288
    552,    142,    564,//1034 0.138283 0.143103 0.157997
    563,    552,    564,//1035 0.144288 0.157997 0.139510
    144,    562,    559,//1036 0.143103 0.144387 0.161146
    562,    145,    564,//1037 0.143103 0.143103 0.162284
    564,    142,    559,//1038 0.143103 0.161146 0.144387
    562,    564,    559,//1039 0.162284 0.144387 0.144387
    39,    565,    567,//1040 0.138283 0.144288 0.156918
    565,    146,    566,//1041 0.138283 0.143103 0.157997
    566,    147,    567,//1042 0.143103 0.156918 0.139510
    565,    566,    567,//1043 0.157997 0.139510 0.144288
    146,    568,    569,//1044 0.138283 0.139482 0.161146
    568,      8,    503,//1045 0.138283 0.138283 0.162173
    503,    130,    569,//1046 0.138283 0.161146 0.139482
    568,    503,    569,//1047 0.162173 0.139482 0.139482
    130,    500,    571,//1048 0.138283 0.157997 0.143103
    500,     35,    570,//1049 0.138283 0.156918 0.144288
    570,    147,    571,//1050 0.156918 0.143103 0.139510
    500,    570,    571,//1051 0.144288 0.139510 0.157997
    146,    569,    566,//1052 0.161146 0.144387 0.143103
    569,    130,    571,//1053 0.161146 0.143103 0.144387
    571,    147,    566,//1054 0.143103 0.143103 0.162284
    569,    571,    566,//1055 0.144387 0.162284 0.144387
    35,    497,    573,//1056 0.138283 0.144288 0.156918
    497,    128,    572,//1057 0.138283 0.143103 0.157997
    572,    148,    573,//1058 0.143103 0.156918 0.139510
    497,    572,    573,//1059 0.157997 0.139510 0.144288
    128,    495,    574,//1060 0.138283 0.139482 0.161146
    495,      9,    533,//1061 0.138283 0.138283 0.162173
    533,    138,    574,//1062 0.138283 0.161146 0.139482
    495,    533,    574,//1063 0.162173 0.139482 0.139482
    138,    537,    576,//1064 0.138283 0.157997 0.143103
    537,     38,    575,//1065 0.138283 0.156918 0.144288
    575,    148,    576,//1066 0.156918 0.143103 0.139510
    537,    575,    576,//1067 0.144288 0.139510 0.157997
    128,    574,    572,//1068 0.161146 0.144387 0.143103
    574,    138,    576,//1069 0.161146 0.143103 0.144387
    576,    148,    572,//1070 0.143103 0.143103 0.162284
    574,    576,    572,//1071 0.144387 0.162284 0.144387
    39,    567,    561,//1072 0.156918 0.164485 0.156918
    567,    147,    577,//1073 0.156918 0.163002 0.158459
    577,    145,    561,//1074 0.163002 0.156918 0.158459
    567,    577,    561,//1075 0.158459 0.158459 0.164485
    147,    570,    578,//1076 0.156918 0.158459 0.163002
    570,     35,    573,//1077 0.156918 0.156918 0.164485
    573,    148,    578,//1078 0.156918 0.163002 0.158459
    570,    573,    578,//1079 0.164485 0.158459 0.158459
    148,    575,    579,//1080 0.156918 0.158459 0.163002
    575,     38,    563,//1081 0.156918 0.156918 0.164485
    563,    145,    579,//1082 0.156918 0.163002 0.158459
    575,    563,    579,//1083 0.164485 0.158459 0.158459
    147,    578,    577,//1084 0.163002 0.164647 0.163002
    578,    148,    579,//1085 0.163002 0.163002 0.164647
    579,    145,    577,//1086 0.163002 0.163002 0.164647
    578,    579,    577,//1087 0.164647 0.164647 0.164647
    8,    568,    425,//1088 0.138283 0.162173 0.138283
    568,    146,    580,//1089 0.138283 0.161146 0.139482
    580,    111,    425,//1090 0.161146 0.138283 0.139482
    568,    580,    425,//1091 0.139482 0.139482 0.162173
    146,    565,    582,//1092 0.138283 0.157997 0.143103
    565,     39,    581,//1093 0.138283 0.156918 0.144288
    581,    149,    582,//1094 0.156918 0.143103 0.139510
    565,    581,    582,//1095 0.144288 0.139510 0.157997
    149,    583,    584,//1096 0.156918 0.139510 0.143103
    583,     31,    427,//1097 0.156918 0.138283 0.144288
    427,    111,    584,//1098 0.138283 0.143103 0.157997
    583,    427,    584,//1099 0.144288 0.157997 0.139510
    146,    582,    580,//1100 0.143103 0.144387 0.161146
    582,    149,    584,//1101 0.143103 0.143103 0.162284
    584,    111,    580,//1102 0.143103 0.161146 0.144387
    582,    584,    580,//1103 0.162284 0.144387 0.144387
    39,    560,    586,//1104 0.138283 0.144288 0.156918
    560,    144,    585,//1105 0.138283 0.143103 0.157997
    585,    151,    586,//1106 0.143103 0.156918 0.139510
    560,    585,    586,//1107 0.157997 0.139510 0.144288
    144,    558,    588,//1108 0.138283 0.139482 0.161146
    558,      3,    587,//1109 0.138283 0.138283 0.162173
    587,    150,    588,//1110 0.138283 0.161146 0.139482
    558,    587,    588,//1111 0.162173 0.139482 0.139482
    150,    589,    591,//1112 0.138283 0.157997 0.143103
    589,     40,    590,//1113 0.138283 0.156918 0.144288
    590,    151,    591,//1114 0.156918 0.143103 0.139510
    589,    590,    591,//1115 0.144288 0.139510 0.157997
    144,    588,    585,//1116 0.161146 0.144387 0.143103
    588,    150,    591,//1117 0.161146 0.143103 0.144387
    591,    151,    585,//1118 0.143103 0.143103 0.162284
    588,    591,    585,//1119 0.144387 0.162284 0.144387
    40,    592,    594,//1120 0.138283 0.144288 0.156918
    592,    152,    593,//1121 0.138283 0.143103 0.157997
    593,    153,    594,//1122 0.143103 0.156918 0.139510
    592,    593,    594,//1123 0.157997 0.139510 0.144288
    152,    595,    596,//1124 0.138283 0.139482 0.161146
    595,      6,    433,//1125 0.138283 0.138283 0.162173
    433,    113,    596,//1126 0.138283 0.161146 0.139482
    595,    433,    596,//1127 0.162173 0.139482 0.139482
    113,    430,    598,//1128 0.138283 0.157997 0.143103
    430,     31,    597,//1129 0.138283 0.156918 0.144288
    597,    153,    598,//1130 0.156918 0.143103 0.139510
    430,    597,    598,//1131 0.144288 0.139510 0.157997
    152,    596,    593,//1132 0.161146 0.144387 0.143103
    596,    113,    598,//1133 0.161146 0.143103 0.144387
    598,    153,    593,//1134 0.143103 0.143103 0.162284
    596,    598,    593,//1135 0.144387 0.162284 0.144387
    39,    586,    581,//1136 0.156918 0.164485 0.156918
    586,    151,    599,//1137 0.156918 0.163002 0.158459
    599,    149,    581,//1138 0.163002 0.156918 0.158459
    586,    599,    581,//1139 0.158459 0.158459 0.164485
    151,    590,    600,//1140 0.156918 0.158459 0.163002
    590,     40,    594,//1141 0.156918 0.156918 0.164485
    594,    153,    600,//1142 0.156918 0.163002 0.158459
    590,    594,    600,//1143 0.164485 0.158459 0.158459
    153,    597,    601,//1144 0.156918 0.158459 0.163002
    597,     31,    583,//1145 0.156918 0.156918 0.164485
    583,    149,    601,//1146 0.156918 0.163002 0.158459
    597,    583,    601,//1147 0.164485 0.158459 0.158459
    151,    600,    599,//1148 0.163002 0.164647 0.163002
    600,    153,    601,//1149 0.163002 0.163002 0.164647
    601,    149,    599,//1150 0.163002 0.163002 0.164647
    600,    601,    599,//1151 0.164647 0.164647 0.164647
    3,    602,    587,//1152 0.138283 0.162173 0.138283
    602,    154,    603,//1153 0.138283 0.161146 0.139482
    603,    150,    587,//1154 0.161146 0.138283 0.139482
    602,    603,    587,//1155 0.139482 0.139482 0.162173
    154,    604,    606,//1156 0.138283 0.157997 0.143103
    604,     41,    605,//1157 0.138283 0.156918 0.144288
    605,    155,    606,//1158 0.156918 0.143103 0.139510
    604,    605,    606,//1159 0.144288 0.139510 0.157997
    155,    607,    608,//1160 0.156918 0.139510 0.143103
    607,     40,    589,//1161 0.156918 0.138283 0.144288
    589,    150,    608,//1162 0.138283 0.143103 0.157997
    607,    589,    608,//1163 0.144288 0.157997 0.139510
    154,    606,    603,//1164 0.143103 0.144387 0.161146
    606,    155,    608,//1165 0.143103 0.143103 0.162284
    608,    150,    603,//1166 0.143103 0.161146 0.144387
    606,    608,    603,//1167 0.162284 0.144387 0.144387
    41,    609,    611,//1168 0.138283 0.144288 0.156918
    609,    156,    610,//1169 0.138283 0.143103 0.157997
    610,    157,    611,//1170 0.143103 0.156918 0.139510
    609,    610,    611,//1171 0.157997 0.139510 0.144288
    156,    612,    613,//1172 0.138283 0.139482 0.161146
    612,      2,    385,//1173 0.138283 0.138283 0.162173
    385,    101,    613,//1174 0.138283 0.161146 0.139482
    612,    385,    613,//1175 0.162173 0.139482 0.139482
    101,    382,    615,//1176 0.138283 0.157997 0.143103
    382,     28,    614,//1177 0.138283 0.156918 0.144288
    614,    157,    615,//1178 0.156918 0.143103 0.139510
    382,    614,    615,//1179 0.144288 0.139510 0.157997
    156,    613,    610,//1180 0.161146 0.144387 0.143103
    613,    101,    615,//1181 0.161146 0.143103 0.144387
    615,    157,    610,//1182 0.143103 0.143103 0.162284
    613,    615,    610,//1183 0.144387 0.162284 0.144387
    28,    379,    617,//1184 0.138283 0.144288 0.156918
    379,     99,    616,//1185 0.138283 0.143103 0.157997
    616,    158,    617,//1186 0.143103 0.156918 0.139510
    379,    616,    617,//1187 0.157997 0.139510 0.144288
    99,    377,    618,//1188 0.138283 0.139482 0.161146
    377,      6,    595,//1189 0.138283 0.138283 0.162173
    595,    152,    618,//1190 0.138283 0.161146 0.139482
    377,    595,    618,//1191 0.162173 0.139482 0.139482
    152,    592,    620,//1192 0.138283 0.157997 0.143103
    592,     40,    619,//1193 0.138283 0.156918 0.144288
    619,    158,    620,//1194 0.156918 0.143103 0.139510
    592,    619,    620,//1195 0.144288 0.139510 0.157997
    99,    618,    616,//1196 0.161146 0.144387 0.143103
    618,    152,    620,//1197 0.161146 0.143103 0.144387
    620,    158,    616,//1198 0.143103 0.143103 0.162284
    618,    620,    616,//1199 0.144387 0.162284 0.144387
    41,    611,    605,//1200 0.156918 0.164485 0.156918
    611,    157,    621,//1201 0.156918 0.163002 0.158459
    621,    155,    605,//1202 0.163002 0.156918 0.158459
    611,    621,    605,//1203 0.158459 0.158459 0.164485
    157,    614,    622,//1204 0.156918 0.158459 0.163002
    614,     28,    617,//1205 0.156918 0.156918 0.164485
    617,    158,    622,//1206 0.156918 0.163002 0.158459
    614,    617,    622,//1207 0.164485 0.158459 0.158459
    158,    619,    623,//1208 0.156918 0.158459 0.163002
    619,     40,    607,//1209 0.156918 0.156918 0.164485
    607,    155,    623,//1210 0.156918 0.163002 0.158459
    619,    607,    623,//1211 0.164485 0.158459 0.158459
    157,    622,    621,//1212 0.163002 0.164647 0.163002
    622,    158,    623,//1213 0.163002 0.163002 0.164647
    623,    155,    621,//1214 0.163002 0.163002 0.164647
    622,    623,    621,//1215 0.164647 0.164647 0.164647
    2,    612,    351,//1216 0.138283 0.162173 0.138283
    612,    156,    624,//1217 0.138283 0.161146 0.139482
    624,     92,    351,//1218 0.161146 0.138283 0.139482
    612,    624,    351,//1219 0.139482 0.139482 0.162173
    156,    609,    626,//1220 0.138283 0.157997 0.143103
    609,     41,    625,//1221 0.138283 0.156918 0.144288
    625,    159,    626,//1222 0.156918 0.143103 0.139510
    609,    625,    626,//1223 0.144288 0.139510 0.157997
    159,    627,    628,//1224 0.156918 0.139510 0.143103
    627,     26,    353,//1225 0.156918 0.138283 0.144288
    353,     92,    628,//1226 0.138283 0.143103 0.157997
    627,    353,    628,//1227 0.144288 0.157997 0.139510
    156,    626,    624,//1228 0.143103 0.144387 0.161146
    626,    159,    628,//1229 0.143103 0.143103 0.162284
    628,     92,    624,//1230 0.143103 0.161146 0.144387
    626,    628,    624,//1231 0.162284 0.144387 0.144387
    41,    604,    630,//1232 0.138283 0.144288 0.156918
    604,    154,    629,//1233 0.138283 0.143103 0.157997
    629,    160,    630,//1234 0.143103 0.156918 0.139510
    604,    629,    630,//1235 0.157997 0.139510 0.144288
    154,    602,    631,//1236 0.138283 0.139482 0.161146
    602,      3,    549,//1237 0.138283 0.138283 0.162173
    549,    141,    631,//1238 0.138283 0.161146 0.139482
    602,    549,    631,//1239 0.162173 0.139482 0.139482
    141,    546,    633,//1240 0.138283 0.157997 0.143103
    546,     37,    632,//1241 0.138283 0.156918 0.144288
    632,    160,    633,//1242 0.156918 0.143103 0.139510
    546,    632,    633,//1243 0.144288 0.139510 0.157997
    154,    631,    629,//1244 0.161146 0.144387 0.143103
    631,    141,    633,//1245 0.161146 0.143103 0.144387
    633,    160,    629,//1246 0.143103 0.143103 0.162284
    631,    633,    629,//1247 0.144387 0.162284 0.144387
    37,    543,    635,//1248 0.138283 0.144288 0.156918
    543,    139,    634,//1249 0.138283 0.143103 0.157997
    634,    161,    635,//1250 0.143103 0.156918 0.139510
    543,    634,    635,//1251 0.157997 0.139510 0.144288
    139,    541,    636,//1252 0.138283 0.139482 0.161146
    541,      4,    359,//1253 0.138283 0.138283 0.162173
    359,     94,    636,//1254 0.138283 0.161146 0.139482
    541,    359,    636,//1255 0.162173 0.139482 0.139482
    94,    356,    638,//1256 0.138283 0.157997 0.143103
    356,     26,    637,//1257 0.138283 0.156918 0.144288
    637,    161,    638,//1258 0.156918 0.143103 0.139510
    356,    637,    638,//1259 0.144288 0.139510 0.157997
    139,    636,    634,//1260 0.161146 0.144387 0.143103
    636,     94,    638,//1261 0.161146 0.143103 0.144387
    638,    161,    634,//1262 0.143103 0.143103 0.162284
    636,    638,    634,//1263 0.144387 0.162284 0.144387
    41,    630,    625,//1264 0.156918 0.164485 0.156918
    630,    160,    639,//1265 0.156918 0.163002 0.158459
    639,    159,    625,//1266 0.163002 0.156918 0.158459
    630,    639,    625,//1267 0.158459 0.158459 0.164485
    160,    632,    640,//1268 0.156918 0.158459 0.163002
    632,     37,    635,//1269 0.156918 0.156918 0.164485
    635,    161,    640,//1270 0.156918 0.163002 0.158459
    632,    635,    640,//1271 0.164485 0.158459 0.158459
    161,    637,    641,//1272 0.156918 0.158459 0.163002
    637,     26,    627,//1273 0.156918 0.156918 0.164485
    627,    159,    641,//1274 0.156918 0.163002 0.158459
    637,    627,    641,//1275 0.164485 0.158459 0.158459
    160,    640,    639,//1276 0.163002 0.164647 0.163002
    640,    161,    641,//1277 0.163002 0.163002 0.164647
    641,    159,    639,//1278 0.163002 0.163002 0.164647
    640,    641,    639 //1279 0.164647 0.164647 0.164647
  };
  static const GLfloat v[1926] = {
    -0.525731,   0.850651,   0.000000,//0      
    0.525731,   0.850651,   0.000000,//1      
    -0.525731,  -0.850651,   0.000000,//2      
    0.525731,  -0.850651,   0.000000,//3      
    0.000000,  -0.525731,   0.850651,//4      
    0.000000,   0.525731,   0.850651,//5      
    0.000000,  -0.525731,  -0.850651,//6      
    0.000000,   0.525731,  -0.850651,//7      
    0.850651,   0.000000,  -0.525731,//8      
    0.850651,   0.000000,   0.525731,//9      
    -0.850651,   0.000000,  -0.525731,//10     
    -0.850651,   0.000000,   0.525731,//11     
    0.000000,   1.000000,   0.000000,//12     
    -0.309017,   0.809017,   0.500000,//13     
    0.309017,   0.809017,   0.500000,//14     
    0.309017,   0.809017,  -0.500000,//15     
    -0.309017,   0.809017,  -0.500000,//16     
    -0.809017,   0.500000,  -0.309017,//17     
    -0.500000,   0.309017,  -0.809017,//18     
    -1.000000,   0.000000,   0.000000,//19     
    -0.809017,   0.500000,   0.309017,//20     
    -0.500000,   0.309017,   0.809017,//21     
    -0.500000,  -0.309017,   0.809017,//22     
    0.000000,   0.000000,   1.000000,//23     
    -0.809017,  -0.500000,   0.309017,//24     
    -0.809017,  -0.500000,  -0.309017,//25     
    -0.309017,  -0.809017,   0.500000,//26     
    -0.500000,  -0.309017,  -0.809017,//27     
    -0.309017,  -0.809017,  -0.500000,//28     
    0.000000,   0.000000,  -1.000000,//29     
    0.500000,   0.309017,  -0.809017,//30     
    0.500000,  -0.309017,  -0.809017,//31     
    0.809017,   0.500000,  -0.309017,//32     
    0.809017,   0.500000,   0.309017,//33     
    0.500000,   0.309017,   0.809017,//34     
    1.000000,   0.000000,   0.000000,//35     
    0.500000,  -0.309017,   0.809017,//36     
    0.309017,  -0.809017,   0.500000,//37     
    0.809017,  -0.500000,   0.309017,//38     
    0.809017,  -0.500000,  -0.309017,//39     
    0.309017,  -0.809017,  -0.500000,//40     
    0.000000,  -1.000000,   0.000000,//41     
    0.273267,   0.961938,   0.000000,//42     
    0.162460,   0.951057,   0.262866,//43     
    0.433889,   0.862668,   0.259892,//44     
    -0.273267,   0.961938,   0.000000,//45     
    -0.433889,   0.862668,   0.259892,//46     
    -0.162460,   0.951057,   0.262866,//47     
    -0.160622,   0.693780,   0.702046,//48     
    0.160622,   0.693780,   0.702046,//49     
    0.000000,   0.850651,   0.525731,//50     
    -0.162460,   0.951057,  -0.262866,//51     
    -0.433889,   0.862668,  -0.259892,//52     
    0.433889,   0.862668,  -0.259892,//53     
    0.162460,   0.951057,  -0.262866,//54     
    0.160622,   0.693780,  -0.702046,//55     
    -0.160622,   0.693780,  -0.702046,//56     
    0.000000,   0.850651,  -0.525731,//57     
    -0.862668,   0.259892,  -0.433889,//58     
    -0.688191,   0.425325,  -0.587785,//59     
    -0.702046,   0.160622,  -0.693780,//60     
    -0.693780,   0.702046,  -0.160622,//61     
    -0.587785,   0.688191,  -0.425325,//62     
    -0.259892,   0.433889,  -0.862668,//63     
    -0.425325,   0.587785,  -0.688191,//64     
    -0.850651,   0.525731,   0.000000,//65     
    -0.693780,   0.702046,   0.160622,//66     
    -0.961938,   0.000000,  -0.273267,//67     
    -0.951057,   0.262866,  -0.162460,//68     
    -0.961938,   0.000000,   0.273267,//69     
    -0.862668,   0.259892,   0.433889,//70     
    -0.951057,   0.262866,   0.162460,//71     
    -0.702046,   0.160622,   0.693780,//72     
    -0.688191,   0.425325,   0.587785,//73     
    -0.259892,   0.433889,   0.862668,//74     
    -0.425325,   0.587785,   0.688191,//75     
    -0.587785,   0.688191,   0.425325,//76     
    -0.262866,   0.162460,   0.951057,//77     
    0.000000,   0.273267,   0.961938,//78     
    -0.702046,  -0.160622,   0.693780,//79     
    -0.525731,   0.000000,   0.850651,//80     
    -0.259892,  -0.433889,   0.862668,//81     
    0.000000,  -0.273267,   0.961938,//82     
    -0.262866,  -0.162460,   0.951057,//83     
    -0.693780,  -0.702046,   0.160622,//84     
    -0.850651,  -0.525731,   0.000000,//85     
    -0.693780,  -0.702046,  -0.160622,//86     
    -0.862668,  -0.259892,   0.433889,//87     
    -0.951057,  -0.262866,   0.162460,//88     
    -0.862668,  -0.259892,  -0.433889,//89     
    -0.951057,  -0.262866,  -0.162460,//90     
    -0.688191,  -0.425325,   0.587785,//91     
    -0.433889,  -0.862668,   0.259892,//92     
    -0.587785,  -0.688191,   0.425325,//93     
    -0.160622,  -0.693780,   0.702046,//94     
    -0.425325,  -0.587785,   0.688191,//95     
    -0.702046,  -0.160622,  -0.693780,//96     
    -0.688191,  -0.425325,  -0.587785,//97     
    -0.259892,  -0.433889,  -0.862668,//98     
    -0.160622,  -0.693780,  -0.702046,//99     
    -0.425325,  -0.587785,  -0.688191,//100    
    -0.433889,  -0.862668,  -0.259892,//101    
    -0.587785,  -0.688191,  -0.425325,//102    
    -0.262866,  -0.162460,  -0.951057,//103    
    0.000000,  -0.273267,  -0.961938,//104    
    -0.525731,   0.000000,  -0.850651,//105    
    0.000000,   0.273267,  -0.961938,//106    
    -0.262866,   0.162460,  -0.951057,//107    
    0.259892,   0.433889,  -0.862668,//108    
    0.262866,   0.162460,  -0.951057,//109    
    0.702046,   0.160622,  -0.693780,//110    
    0.702046,  -0.160622,  -0.693780,//111    
    0.525731,   0.000000,  -0.850651,//112    
    0.259892,  -0.433889,  -0.862668,//113    
    0.262866,  -0.162460,  -0.951057,//114    
    0.688191,   0.425325,  -0.587785,//115    
    0.862668,   0.259892,  -0.433889,//116    
    0.425325,   0.587785,  -0.688191,//117    
    0.693780,   0.702046,  -0.160622,//118    
    0.587785,   0.688191,  -0.425325,//119    
    0.862668,   0.259892,   0.433889,//120    
    0.688191,   0.425325,   0.587785,//121    
    0.702046,   0.160622,   0.693780,//122    
    0.693780,   0.702046,   0.160622,//123    
    0.587785,   0.688191,   0.425325,//124    
    0.259892,   0.433889,   0.862668,//125    
    0.425325,   0.587785,   0.688191,//126    
    0.850651,   0.525731,   0.000000,//127    
    0.961938,   0.000000,   0.273267,//128    
    0.951057,   0.262866,   0.162460,//129    
    0.961938,   0.000000,  -0.273267,//130    
    0.951057,   0.262866,  -0.162460,//131    
    0.259892,  -0.433889,   0.862668,//132    
    0.262866,  -0.162460,   0.951057,//133    
    0.702046,  -0.160622,   0.693780,//134    
    0.525731,   0.000000,   0.850651,//135    
    0.262866,   0.162460,   0.951057,//136    
    0.688191,  -0.425325,   0.587785,//137    
    0.862668,  -0.259892,   0.433889,//138    
    0.160622,  -0.693780,   0.702046,//139    
    0.425325,  -0.587785,   0.688191,//140    
    0.433889,  -0.862668,   0.259892,//141    
    0.693780,  -0.702046,   0.160622,//142    
    0.587785,  -0.688191,   0.425325,//143    
    0.693780,  -0.702046,  -0.160622,//144    
    0.850651,  -0.525731,   0.000000,//145    
    0.862668,  -0.259892,  -0.433889,//146    
    0.951057,  -0.262866,  -0.162460,//147    
    0.951057,  -0.262866,   0.162460,//148    
    0.688191,  -0.425325,  -0.587785,//149    
    0.433889,  -0.862668,  -0.259892,//150    
    0.587785,  -0.688191,  -0.425325,//151    
    0.160622,  -0.693780,  -0.702046,//152    
    0.425325,  -0.587785,  -0.688191,//153    
    0.273267,  -0.961938,   0.000000,//154    
    0.162460,  -0.951057,  -0.262866,//155    
    -0.273267,  -0.961938,   0.000000,//156    
    -0.162460,  -0.951057,  -0.262866,//157    
    0.000000,  -0.850651,  -0.525731,//158    
    -0.162460,  -0.951057,   0.262866,//159    
    0.162460,  -0.951057,   0.262866,//160    
    0.000000,  -0.850651,   0.525731,//161    
    0.403355,   0.915043,   0.000000,//162    
    0.358229,   0.924305,   0.131655,//163    
    0.484442,   0.864929,   0.131200,//164    
    0.137952,   0.990439,   0.000000,//165    
    0.082242,   0.987688,   0.133071,//166    
    0.220117,   0.966393,   0.132792,//167    
    0.238677,   0.891007,   0.386187,//168    
    0.375039,   0.843911,   0.383614,//169    
    0.301259,   0.916244,   0.264083,//170    
    -0.137952,   0.990439,   0.000000,//171    
    -0.220117,   0.966393,   0.132792,//172    
    -0.082242,   0.987688,   0.133071,//173    
    -0.403355,   0.915043,   0.000000,//174    
    -0.484442,   0.864929,   0.131200,//175    
    -0.358229,   0.924305,   0.131655,//176    
    -0.375039,   0.843911,   0.383614,//177    
    -0.238677,   0.891007,   0.386187,//178    
    -0.301259,   0.916244,   0.264083,//179    
    -0.237086,   0.758652,   0.606825,//180    
    -0.081142,   0.780204,   0.620240,//181    
    -0.156434,   0.840178,   0.519258,//182    
    -0.081086,   0.615642,   0.783843,//183    
    0.081086,   0.615642,   0.783843,//184    
    0.000000,   0.702907,   0.711282,//185    
    0.237086,   0.758652,   0.606825,//186    
    0.156434,   0.840178,   0.519258,//187    
    0.081142,   0.780204,   0.620240,//188    
    0.000000,   0.963861,   0.266405,//189    
    -0.082324,   0.912983,   0.399607,//190    
    0.082324,   0.912983,   0.399607,//191    
    -0.358229,   0.924305,  -0.131655,//192    
    -0.484442,   0.864929,  -0.131200,//193    
    -0.082242,   0.987688,  -0.133071,//194    
    -0.220117,   0.966393,  -0.132792,//195    
    -0.238677,   0.891007,  -0.386187,//196    
    -0.375039,   0.843911,  -0.383614,//197    
    -0.301259,   0.916244,  -0.264083,//198    
    0.220117,   0.966393,  -0.132792,//199    
    0.082242,   0.987688,  -0.133071,//200    
    0.484442,   0.864929,  -0.131200,//201    
    0.358229,   0.924305,  -0.131655,//202    
    0.375039,   0.843911,  -0.383614,//203    
    0.238677,   0.891007,  -0.386187,//204    
    0.301259,   0.916244,  -0.264083,//205    
    0.237086,   0.758652,  -0.606825,//206    
    0.081142,   0.780204,  -0.620240,//207    
    0.156434,   0.840178,  -0.519258,//208    
    0.081086,   0.615642,  -0.783843,//209    
    -0.081086,   0.615642,  -0.783843,//210    
    0.000000,   0.702907,  -0.711282,//211    
    -0.237086,   0.758652,  -0.606825,//212    
    -0.156434,   0.840178,  -0.519258,//213    
    -0.081142,   0.780204,  -0.620240,//214    
    0.000000,   0.963861,  -0.266405,//215    
    0.082324,   0.912983,  -0.399607,//216    
    -0.082324,   0.912983,  -0.399607,//217    
    -0.864929,   0.131200,  -0.484442,//218    
    -0.792649,   0.213023,  -0.571252,//219    
    -0.783843,   0.081086,  -0.615642,//220    
    -0.843911,   0.383614,  -0.375039,//221    
    -0.757935,   0.468430,  -0.453991,//222    
    -0.783452,   0.346153,  -0.516122,//223    
    -0.601501,   0.371748,  -0.707107,//224    
    -0.606825,   0.237086,  -0.758652,//225    
    -0.702310,   0.296005,  -0.647412,//226    
    -0.758652,   0.606825,  -0.237086,//227    
    -0.647412,   0.702310,  -0.296005,//228    
    -0.707107,   0.601501,  -0.371748,//229    
    -0.615642,   0.783843,  -0.081086,//230    
    -0.571252,   0.792649,  -0.213023,//231    
    -0.453991,   0.757935,  -0.468430,//232    
    -0.516122,   0.783452,  -0.346153,//233    
    -0.296005,   0.647412,  -0.702310,//234    
    -0.371748,   0.707107,  -0.601501,//235    
    -0.131200,   0.484442,  -0.864929,//236    
    -0.213023,   0.571252,  -0.792649,//237    
    -0.383614,   0.375039,  -0.843911,//238    
    -0.468430,   0.453991,  -0.757935,//239    
    -0.346153,   0.516122,  -0.783452,//240    
    -0.646578,   0.564254,  -0.513375,//241    
    -0.513375,   0.646578,  -0.564254,//242    
    -0.564254,   0.513375,  -0.646578,//243    
    -0.702907,   0.711282,   0.000000,//244    
    -0.615642,   0.783843,   0.081086,//245    
    -0.840178,   0.519258,  -0.156434,//246    
    -0.780204,   0.620240,  -0.081142,//247    
    -0.840178,   0.519258,   0.156434,//248    
    -0.758652,   0.606825,   0.237086,//249    
    -0.780204,   0.620240,   0.081142,//250    
    -0.916244,   0.264083,  -0.301259,//251    
    -0.891007,   0.386187,  -0.238677,//252    
    -0.915043,   0.000000,  -0.403355,//253    
    -0.924305,   0.131655,  -0.358229,//254    
    -0.990439,   0.000000,  -0.137952,//255    
    -0.987688,   0.133071,  -0.082242,//256    
    -0.966393,   0.132792,  -0.220117,//257    
    -0.990439,   0.000000,   0.137952,//258    
    -0.966393,   0.132792,   0.220117,//259    
    -0.987688,   0.133071,   0.082242,//260    
    -0.915043,   0.000000,   0.403355,//261    
    -0.864929,   0.131200,   0.484442,//262    
    -0.924305,   0.131655,   0.358229,//263    
    -0.843911,   0.383614,   0.375039,//264    
    -0.891007,   0.386187,   0.238677,//265    
    -0.916244,   0.264083,   0.301259,//266    
    -0.912983,   0.399607,  -0.082324,//267    
    -0.963861,   0.266405,   0.000000,//268    
    -0.912983,   0.399607,   0.082324,//269    
    -0.783843,   0.081086,   0.615642,//270    
    -0.792649,   0.213023,   0.571252,//271    
    -0.606825,   0.237086,   0.758652,//272    
    -0.601501,   0.371748,   0.707107,//273    
    -0.702310,   0.296005,   0.647412,//274    
    -0.757935,   0.468430,   0.453991,//275    
    -0.783452,   0.346153,   0.516122,//276    
    -0.383614,   0.375039,   0.843911,//277    
    -0.346153,   0.516122,   0.783452,//278    
    -0.468430,   0.453991,   0.757935,//279    
    -0.131200,   0.484442,   0.864929,//280    
    -0.213023,   0.571252,   0.792649,//281    
    -0.371748,   0.707107,   0.601501,//282    
    -0.296005,   0.647412,   0.702310,//283    
    -0.516122,   0.783452,   0.346153,//284    
    -0.453991,   0.757935,   0.468430,//285    
    -0.571252,   0.792649,   0.213023,//286    
    -0.707107,   0.601501,   0.371748,//287    
    -0.647412,   0.702310,   0.296005,//288    
    -0.564254,   0.513375,   0.646578,//289    
    -0.513375,   0.646578,   0.564254,//290    
    -0.646578,   0.564254,   0.513375,//291    
    -0.131655,   0.358229,   0.924305,//292    
    0.000000,   0.403355,   0.915043,//293    
    -0.386187,   0.238677,   0.891007,//294    
    -0.264083,   0.301259,   0.916244,//295    
    -0.133071,   0.082242,   0.987688,//296    
    0.000000,   0.137952,   0.990439,//297    
    -0.132792,   0.220117,   0.966393,//298    
    -0.620240,   0.081142,   0.780204,//299    
    -0.519258,   0.156434,   0.840178,//300    
    -0.783843,  -0.081086,   0.615642,//301    
    -0.711282,   0.000000,   0.702907,//302    
    -0.606825,  -0.237086,   0.758652,//303    
    -0.519258,  -0.156434,   0.840178,//304    
    -0.620240,  -0.081142,   0.780204,//305    
    -0.383614,  -0.375039,   0.843911,//306    
    -0.264083,  -0.301259,   0.916244,//307    
    -0.386187,  -0.238677,   0.891007,//308    
    -0.131200,  -0.484442,   0.864929,//309    
    0.000000,  -0.403355,   0.915043,//310    
    -0.131655,  -0.358229,   0.924305,//311    
    0.000000,  -0.137952,   0.990439,//312    
    -0.133071,  -0.082242,   0.987688,//313    
    -0.132792,  -0.220117,   0.966393,//314    
    -0.399607,   0.082324,   0.912983,//315    
    -0.399607,  -0.082324,   0.912983,//316    
    -0.266405,   0.000000,   0.963861,//317    
    -0.615642,  -0.783843,   0.081086,//318    
    -0.702907,  -0.711282,   0.000000,//319    
    -0.615642,  -0.783843,  -0.081086,//320    
    -0.758652,  -0.606825,   0.237086,//321    
    -0.840178,  -0.519258,   0.156434,//322    
    -0.780204,  -0.620240,   0.081142,//323    
    -0.840178,  -0.519258,  -0.156434,//324    
    -0.758652,  -0.606825,  -0.237086,//325    
    -0.780204,  -0.620240,  -0.081142,//326    
    -0.843911,  -0.383614,   0.375039,//327    
    -0.916244,  -0.264083,   0.301259,//328    
    -0.891007,  -0.386187,   0.238677,//329    
    -0.864929,  -0.131200,   0.484442,//330    
    -0.924305,  -0.131655,   0.358229,//331    
    -0.987688,  -0.133071,   0.082242,//332    
    -0.966393,  -0.132792,   0.220117,//333    
    -0.966393,  -0.132792,  -0.220117,//334    
    -0.987688,  -0.133071,  -0.082242,//335    
    -0.864929,  -0.131200,  -0.484442,//336    
    -0.924305,  -0.131655,  -0.358229,//337    
    -0.843911,  -0.383614,  -0.375039,//338    
    -0.891007,  -0.386187,  -0.238677,//339    
    -0.916244,  -0.264083,  -0.301259,//340    
    -0.912983,  -0.399607,   0.082324,//341    
    -0.963861,  -0.266405,   0.000000,//342    
    -0.912983,  -0.399607,  -0.082324,//343    
    -0.792649,  -0.213023,   0.571252,//344    
    -0.757935,  -0.468430,   0.453991,//345    
    -0.783452,  -0.346153,   0.516122,//346    
    -0.601501,  -0.371748,   0.707107,//347    
    -0.702310,  -0.296005,   0.647412,//348    
    -0.647412,  -0.702310,   0.296005,//349    
    -0.707107,  -0.601501,   0.371748,//350    
    -0.484442,  -0.864929,   0.131200,//351    
    -0.571252,  -0.792649,   0.213023,//352    
    -0.375039,  -0.843911,   0.383614,//353    
    -0.453991,  -0.757935,   0.468430,//354    
    -0.516122,  -0.783452,   0.346153,//355    
    -0.237086,  -0.758652,   0.606825,//356    
    -0.296005,  -0.647412,   0.702310,//357    
    -0.371748,  -0.707107,   0.601501,//358    
    -0.081086,  -0.615642,   0.783843,//359    
    -0.213023,  -0.571252,   0.792649,//360    
    -0.468430,  -0.453991,   0.757935,//361    
    -0.346153,  -0.516122,   0.783452,//362    
    -0.646578,  -0.564254,   0.513375,//363    
    -0.513375,  -0.646578,   0.564254,//364    
    -0.564254,  -0.513375,   0.646578,//365    
    -0.783843,  -0.081086,  -0.615642,//366    
    -0.792649,  -0.213023,  -0.571252,//367    
    -0.606825,  -0.237086,  -0.758652,//368    
    -0.601501,  -0.371748,  -0.707107,//369    
    -0.702310,  -0.296005,  -0.647412,//370    
    -0.757935,  -0.468430,  -0.453991,//371    
    -0.783452,  -0.346153,  -0.516122,//372    
    -0.383614,  -0.375039,  -0.843911,//373    
    -0.346153,  -0.516122,  -0.783452,//374    
    -0.468430,  -0.453991,  -0.757935,//375    
    -0.131200,  -0.484442,  -0.864929,//376    
    -0.081086,  -0.615642,  -0.783843,//377    
    -0.213023,  -0.571252,  -0.792649,//378    
    -0.237086,  -0.758652,  -0.606825,//379    
    -0.371748,  -0.707107,  -0.601501,//380    
    -0.296005,  -0.647412,  -0.702310,//381    
    -0.375039,  -0.843911,  -0.383614,//382    
    -0.516122,  -0.783452,  -0.346153,//383    
    -0.453991,  -0.757935,  -0.468430,//384    
    -0.484442,  -0.864929,  -0.131200,//385    
    -0.571252,  -0.792649,  -0.213023,//386    
    -0.707107,  -0.601501,  -0.371748,//387    
    -0.647412,  -0.702310,  -0.296005,//388    
    -0.564254,  -0.513375,  -0.646578,//389    
    -0.513375,  -0.646578,  -0.564254,//390    
    -0.646578,  -0.564254,  -0.513375,//391    
    -0.131655,  -0.358229,  -0.924305,//392    
    0.000000,  -0.403355,  -0.915043,//393    
    -0.386187,  -0.238677,  -0.891007,//394    
    -0.264083,  -0.301259,  -0.916244,//395    
    -0.133071,  -0.082242,  -0.987688,//396    
    0.000000,  -0.137952,  -0.990439,//397    
    -0.132792,  -0.220117,  -0.966393,//398    
    -0.620240,  -0.081142,  -0.780204,//399    
    -0.519258,  -0.156434,  -0.840178,//400    
    -0.711282,   0.000000,  -0.702907,//401    
    -0.519258,   0.156434,  -0.840178,//402    
    -0.620240,   0.081142,  -0.780204,//403    
    -0.264083,   0.301259,  -0.916244,//404    
    -0.386187,   0.238677,  -0.891007,//405    
    0.000000,   0.403355,  -0.915043,//406    
    -0.131655,   0.358229,  -0.924305,//407    
    0.000000,   0.137952,  -0.990439,//408    
    -0.133071,   0.082242,  -0.987688,//409    
    -0.132792,   0.220117,  -0.966393,//410    
    -0.399607,  -0.082324,  -0.912983,//411    
    -0.399607,   0.082324,  -0.912983,//412    
    -0.266405,   0.000000,  -0.963861,//413    
    0.131200,   0.484442,  -0.864929,//414    
    0.131655,   0.358229,  -0.924305,//415    
    0.383614,   0.375039,  -0.843911,//416    
    0.386187,   0.238677,  -0.891007,//417    
    0.264083,   0.301259,  -0.916244,//418    
    0.133071,   0.082242,  -0.987688,//419    
    0.132792,   0.220117,  -0.966393,//420    
    0.606825,   0.237086,  -0.758652,//421    
    0.620240,   0.081142,  -0.780204,//422    
    0.519258,   0.156434,  -0.840178,//423    
    0.783843,   0.081086,  -0.615642,//424    
    0.783843,  -0.081086,  -0.615642,//425    
    0.711282,   0.000000,  -0.702907,//426    
    0.606825,  -0.237086,  -0.758652,//427    
    0.519258,  -0.156434,  -0.840178,//428    
    0.620240,  -0.081142,  -0.780204,//429    
    0.383614,  -0.375039,  -0.843911,//430    
    0.264083,  -0.301259,  -0.916244,//431    
    0.386187,  -0.238677,  -0.891007,//432    
    0.131200,  -0.484442,  -0.864929,//433    
    0.131655,  -0.358229,  -0.924305,//434    
    0.133071,  -0.082242,  -0.987688,//435    
    0.132792,  -0.220117,  -0.966393,//436    
    0.399607,   0.082324,  -0.912983,//437    
    0.399607,  -0.082324,  -0.912983,//438    
    0.266405,   0.000000,  -0.963861,//439    
    0.792649,   0.213023,  -0.571252,//440    
    0.864929,   0.131200,  -0.484442,//441    
    0.601501,   0.371748,  -0.707107,//442    
    0.702310,   0.296005,  -0.647412,//443    
    0.757935,   0.468430,  -0.453991,//444    
    0.843911,   0.383614,  -0.375039,//445    
    0.783452,   0.346153,  -0.516122,//446    
    0.346153,   0.516122,  -0.783452,//447    
    0.468430,   0.453991,  -0.757935,//448    
    0.213023,   0.571252,  -0.792649,//449    
    0.371748,   0.707107,  -0.601501,//450    
    0.296005,   0.647412,  -0.702310,//451    
    0.516122,   0.783452,  -0.346153,//452    
    0.453991,   0.757935,  -0.468430,//453    
    0.615642,   0.783843,  -0.081086,//454    
    0.571252,   0.792649,  -0.213023,//455    
    0.758652,   0.606825,  -0.237086,//456    
    0.707107,   0.601501,  -0.371748,//457    
    0.647412,   0.702310,  -0.296005,//458    
    0.564254,   0.513375,  -0.646578,//459    
    0.513375,   0.646578,  -0.564254,//460    
    0.646578,   0.564254,  -0.513375,//461    
    0.864929,   0.131200,   0.484442,//462    
    0.792649,   0.213023,   0.571252,//463    
    0.783843,   0.081086,   0.615642,//464    
    0.843911,   0.383614,   0.375039,//465    
    0.757935,   0.468430,   0.453991,//466    
    0.783452,   0.346153,   0.516122,//467    
    0.601501,   0.371748,   0.707107,//468    
    0.606825,   0.237086,   0.758652,//469    
    0.702310,   0.296005,   0.647412,//470    
    0.758652,   0.606825,   0.237086,//471    
    0.647412,   0.702310,   0.296005,//472    
    0.707107,   0.601501,   0.371748,//473    
    0.615642,   0.783843,   0.081086,//474    
    0.571252,   0.792649,   0.213023,//475    
    0.453991,   0.757935,   0.468430,//476    
    0.516122,   0.783452,   0.346153,//477    
    0.296005,   0.647412,   0.702310,//478    
    0.371748,   0.707107,   0.601501,//479    
    0.131200,   0.484442,   0.864929,//480    
    0.213023,   0.571252,   0.792649,//481    
    0.383614,   0.375039,   0.843911,//482    
    0.468430,   0.453991,   0.757935,//483    
    0.346153,   0.516122,   0.783452,//484    
    0.646578,   0.564254,   0.513375,//485    
    0.513375,   0.646578,   0.564254,//486    
    0.564254,   0.513375,   0.646578,//487    
    0.702907,   0.711282,   0.000000,//488    
    0.840178,   0.519258,   0.156434,//489    
    0.780204,   0.620240,   0.081142,//490    
    0.840178,   0.519258,  -0.156434,//491    
    0.780204,   0.620240,  -0.081142,//492    
    0.916244,   0.264083,   0.301259,//493    
    0.891007,   0.386187,   0.238677,//494    
    0.915043,   0.000000,   0.403355,//495    
    0.924305,   0.131655,   0.358229,//496    
    0.990439,   0.000000,   0.137952,//497    
    0.987688,   0.133071,   0.082242,//498    
    0.966393,   0.132792,   0.220117,//499    
    0.990439,   0.000000,  -0.137952,//500    
    0.966393,   0.132792,  -0.220117,//501    
    0.987688,   0.133071,  -0.082242,//502    
    0.915043,   0.000000,  -0.403355,//503    
    0.924305,   0.131655,  -0.358229,//504    
    0.891007,   0.386187,  -0.238677,//505    
    0.916244,   0.264083,  -0.301259,//506    
    0.912983,   0.399607,   0.082324,//507    
    0.963861,   0.266405,   0.000000,//508    
    0.912983,   0.399607,  -0.082324,//509    
    0.131200,  -0.484442,   0.864929,//510    
    0.131655,  -0.358229,   0.924305,//511    
    0.383614,  -0.375039,   0.843911,//512    
    0.386187,  -0.238677,   0.891007,//513    
    0.264083,  -0.301259,   0.916244,//514    
    0.133071,  -0.082242,   0.987688,//515    
    0.132792,  -0.220117,   0.966393,//516    
    0.606825,  -0.237086,   0.758652,//517    
    0.620240,  -0.081142,   0.780204,//518    
    0.519258,  -0.156434,   0.840178,//519    
    0.783843,  -0.081086,   0.615642,//520    
    0.711282,   0.000000,   0.702907,//521    
    0.519258,   0.156434,   0.840178,//522    
    0.620240,   0.081142,   0.780204,//523    
    0.264083,   0.301259,   0.916244,//524    
    0.386187,   0.238677,   0.891007,//525    
    0.131655,   0.358229,   0.924305,//526    
    0.133071,   0.082242,   0.987688,//527    
    0.132792,   0.220117,   0.966393,//528    
    0.399607,  -0.082324,   0.912983,//529    
    0.399607,   0.082324,   0.912983,//530    
    0.266405,   0.000000,   0.963861,//531    
    0.792649,  -0.213023,   0.571252,//532    
    0.864929,  -0.131200,   0.484442,//533    
    0.601501,  -0.371748,   0.707107,//534    
    0.702310,  -0.296005,   0.647412,//535    
    0.757935,  -0.468430,   0.453991,//536    
    0.843911,  -0.383614,   0.375039,//537    
    0.783452,  -0.346153,   0.516122,//538    
    0.346153,  -0.516122,   0.783452,//539    
    0.468430,  -0.453991,   0.757935,//540    
    0.081086,  -0.615642,   0.783843,//541    
    0.213023,  -0.571252,   0.792649,//542    
    0.237086,  -0.758652,   0.606825,//543    
    0.371748,  -0.707107,   0.601501,//544    
    0.296005,  -0.647412,   0.702310,//545    
    0.375039,  -0.843911,   0.383614,//546    
    0.516122,  -0.783452,   0.346153,//547    
    0.453991,  -0.757935,   0.468430,//548    
    0.484442,  -0.864929,   0.131200,//549    
    0.615642,  -0.783843,   0.081086,//550    
    0.571252,  -0.792649,   0.213023,//551    
    0.758652,  -0.606825,   0.237086,//552    
    0.707107,  -0.601501,   0.371748,//553    
    0.647412,  -0.702310,   0.296005,//554    
    0.564254,  -0.513375,   0.646578,//555    
    0.513375,  -0.646578,   0.564254,//556    
    0.646578,  -0.564254,   0.513375,//557    
    0.615642,  -0.783843,  -0.081086,//558    
    0.702907,  -0.711282,   0.000000,//559    
    0.758652,  -0.606825,  -0.237086,//560    
    0.840178,  -0.519258,  -0.156434,//561    
    0.780204,  -0.620240,  -0.081142,//562    
    0.840178,  -0.519258,   0.156434,//563    
    0.780204,  -0.620240,   0.081142,//564    
    0.843911,  -0.383614,  -0.375039,//565    
    0.916244,  -0.264083,  -0.301259,//566    
    0.891007,  -0.386187,  -0.238677,//567    
    0.864929,  -0.131200,  -0.484442,//568    
    0.924305,  -0.131655,  -0.358229,//569    
    0.987688,  -0.133071,  -0.082242,//570    
    0.966393,  -0.132792,  -0.220117,//571    
    0.966393,  -0.132792,   0.220117,//572    
    0.987688,  -0.133071,   0.082242,//573    
    0.924305,  -0.131655,   0.358229,//574    
    0.891007,  -0.386187,   0.238677,//575    
    0.916244,  -0.264083,   0.301259,//576    
    0.912983,  -0.399607,  -0.082324,//577    
    0.963861,  -0.266405,   0.000000,//578    
    0.912983,  -0.399607,   0.082324,//579    
    0.792649,  -0.213023,  -0.571252,//580    
    0.757935,  -0.468430,  -0.453991,//581    
    0.783452,  -0.346153,  -0.516122,//582    
    0.601501,  -0.371748,  -0.707107,//583    
    0.702310,  -0.296005,  -0.647412,//584    
    0.647412,  -0.702310,  -0.296005,//585    
    0.707107,  -0.601501,  -0.371748,//586    
    0.484442,  -0.864929,  -0.131200,//587    
    0.571252,  -0.792649,  -0.213023,//588    
    0.375039,  -0.843911,  -0.383614,//589    
    0.453991,  -0.757935,  -0.468430,//590    
    0.516122,  -0.783452,  -0.346153,//591    
    0.237086,  -0.758652,  -0.606825,//592    
    0.296005,  -0.647412,  -0.702310,//593    
    0.371748,  -0.707107,  -0.601501,//594    
    0.081086,  -0.615642,  -0.783843,//595    
    0.213023,  -0.571252,  -0.792649,//596    
    0.468430,  -0.453991,  -0.757935,//597    
    0.346153,  -0.516122,  -0.783452,//598    
    0.646578,  -0.564254,  -0.513375,//599    
    0.513375,  -0.646578,  -0.564254,//600    
    0.564254,  -0.513375,  -0.646578,//601    
    0.403355,  -0.915043,   0.000000,//602    
    0.358229,  -0.924305,  -0.131655,//603    
    0.137952,  -0.990439,   0.000000,//604    
    0.082242,  -0.987688,  -0.133071,//605    
    0.220117,  -0.966393,  -0.132792,//606    
    0.238677,  -0.891007,  -0.386187,//607    
    0.301259,  -0.916244,  -0.264083,//608    
    -0.137952,  -0.990439,   0.000000,//609    
    -0.220117,  -0.966393,  -0.132792,//610    
    -0.082242,  -0.987688,  -0.133071,//611    
    -0.403355,  -0.915043,   0.000000,//612    
    -0.358229,  -0.924305,  -0.131655,//613    
    -0.238677,  -0.891007,  -0.386187,//614    
    -0.301259,  -0.916244,  -0.264083,//615    
    -0.081142,  -0.780204,  -0.620240,//616    
    -0.156434,  -0.840178,  -0.519258,//617    
    0.000000,  -0.702907,  -0.711282,//618    
    0.156434,  -0.840178,  -0.519258,//619    
    0.081142,  -0.780204,  -0.620240,//620    
    0.000000,  -0.963861,  -0.266405,//621    
    -0.082324,  -0.912983,  -0.399607,//622    
    0.082324,  -0.912983,  -0.399607,//623    
    -0.358229,  -0.924305,   0.131655,//624    
    -0.082242,  -0.987688,   0.133071,//625    
    -0.220117,  -0.966393,   0.132792,//626    
    -0.238677,  -0.891007,   0.386187,//627    
    -0.301259,  -0.916244,   0.264083,//628    
    0.220117,  -0.966393,   0.132792,//629    
    0.082242,  -0.987688,   0.133071,//630    
    0.358229,  -0.924305,   0.131655,//631    
    0.238677,  -0.891007,   0.386187,//632    
    0.301259,  -0.916244,   0.264083,//633    
    0.081142,  -0.780204,   0.620240,//634    
    0.156434,  -0.840178,   0.519258,//635    
    0.000000,  -0.702907,   0.711282,//636    
    -0.156434,  -0.840178,   0.519258,//637    
    -0.081142,  -0.780204,   0.620240,//638    
    0.000000,  -0.963861,   0.266405,//639    
    0.082324,  -0.912983,   0.399607,//640    
    -0.082324,  -0.912983,   0.399607 //641    
  };
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, 0, v);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, 0, v);
  switch (bal){
    case 1:glDrawElements(GL_TRIANGLES, 240, GL_UNSIGNED_INT,idx1);break;
    case 2:glDrawElements(GL_TRIANGLES, 960, GL_UNSIGNED_INT,idx2);break;
    case 3:glDrawElements(GL_TRIANGLES, 3840, GL_UNSIGNED_INT,idx3);break;
  }
  glDisableClientState(GL_VERTEX_ARRAY);
  glDisableClientState(GL_NORMAL_ARRAY);
}

void Molecule::sphere(int adp,int style){
  if (useShaders&&program_in_use&&(g_Program!=NULL)){
    //printf("%d style %d adp %d %d %d %d %d %d\n",style,adp,lichtH,wallH,ballH,ringH,adpsH,lodH);
    g_Program->setUniformValue(lichtH, 1);
    g_Program->setUniformValue(wallH, 0);
    g_Program->setUniformValue(ballH, ((ATOM_STYLE_SPHERE&style))?1:0);
    g_Program->setUniformValue(ringH, ((ATOM_STYLE_RINGS&style))?1:0);
    g_Program->setUniformValue(openH, ((ATOM_STYLE_SOLID&style))?0:1);
    g_Program->setUniformValue(adpsH, ((ATOM_STYLE_NOADP&style))?0:1);
    g_Program->setUniformValue(whiteringH, (ATOM_STYLE_WHITERING&style)?1:0);
    g_Program->setUniformValue(lodH, qMin(LOD-1,3));
   /* int total = -1,program_id=g_program;
    glGetProgramiv( program_id, GL_ACTIVE_UNIFORMS, &total ); 
    for(int i=0; i<total; ++i)  {
      int name_len=-1, num=-1;
      GLenum type = GL_ZERO;
      char name[100];
      glGetActiveUniform( program_id, GLuint(i), sizeof(name)-1,
          &name_len, &num, &type, name );
      const char *ts;
      switch (type){
        case   GL_FLOAT:   ts="float";break;
        case   GL_FLOAT_VEC2:  ts="vec2";break;
        case   GL_FLOAT_VEC3:  ts="vec3";break;
        case   GL_FLOAT_VEC4:  ts="vec4";break;
        case   GL_DOUBLE:  ts="double";break;
        case   GL_INT:   ts="int";break;
        case   GL_INT_VEC2:  ts="ivec2";break;
        case   GL_INT_VEC3:  ts="ivec3";break;
        case   GL_INT_VEC4:  ts="ivec4";break;
        case   GL_UNSIGNED_INT:  ts="unsigned int";break;
        case   GL_BOOL:  ts="bool";break;
        case   GL_BOOL_VEC2:   ts="bvec2";break;
        case   GL_BOOL_VEC3:   ts="bvec3";break;
        case   GL_BOOL_VEC4:   ts="bvec4";break;
        case   GL_FLOAT_MAT2:  ts="mat2";break;
        case   GL_FLOAT_MAT3:  ts="mat3";break;
        case   GL_FLOAT_MAT4:  ts="mat4";break;
      }
      name[name_len] = 0;
      int location = glGetUniformLocation( program_id, name );
      int val=-1;
      if ((location>=0)&&((type==GL_INT)||(type==GL_BOOL))){glGetUniformiv(program_id,location,&val); }
      if (location>=0)printf("%2d/%2d %-42s=%d size%d %s loc%d\n",i,total,name,val,num,ts,location);
      if ((0==strcmp(name,"lighting"))&&val==0) return;
    }*/ 
  }
  if (adp) glEnable(GL_BLEND);
  if (dratom){ 
    glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
    glEnable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    if (dratom==3)glColor3d(0.4,0.8,1.0);
    if (dratom<3) glColor3d(1.0,1.0,0.0);
    if (dratom==3)triacontaeder(0.106f);//gluSphere(q,0.33,7,7);
    else if (dratom==5) {
      triacontaeder(0.618f);//gluSphere(q,1.00,7,7);
      //gluSphere(q,1.0,4*LOD,9*LOD);
    }
    else triacontaeder(0.09f);//gluSphere(q,0.3,5,5);
    glEnable(GL_DEPTH_TEST);
    glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
  }
  else{ 
    //gluSphere(q,1.0,4*LOD,9*LOD);
    mySphere(qMin(LOD-1,3));
    glDisable(GL_BLEND);
  }
}

void Molecule::ellipse(int style){
  glDisable(GL_BLEND);
  if (style&ATOM_STYLE_WALLS){
    glEnable(GL_ALPHA_TEST);
    glDisable(GL_CULL_FACE);
    if (style&ATOM_STYLE_PLAID) glBindTexture(GL_TEXTURE_2D, adpwall_plaid);
    else glBindTexture(GL_TEXTURE_2D, adpwall);
    glEnable(GL_TEXTURE_2D);
    glBegin(GL_QUADS);
    glNormal3f(-1.0,0,0);

    glTexCoord2d(0,0);
    glVertex3f(0.0,-1.0,-1.0);
    glTexCoord2d(0,1);
    glVertex3f(0.0,-1.0, 1.0);
    glTexCoord2d(1,1);
    glVertex3f(0.0, 1.0, 1.0);
    glTexCoord2d(1,0);
    glVertex3f(0.0, 1.0,-1.0);

    glNormal3f(0.0,-1,0);
    glTexCoord2d(0,0);
    glVertex3f(-1.0,0.0,-1.0);
    glTexCoord2d(0,1);
    glVertex3f(-1.0,0.0, 1.0);
    glTexCoord2d(1,1);
    glVertex3f( 1.0,0.0, 1.0);
    glTexCoord2d(1,0);
    glVertex3f( 1.0,0.0,-1.0);

    glNormal3f(0.0,0,-1);
    glTexCoord2d(0,0);
    glVertex3f(-1.0,-1.0,0.0);
    glTexCoord2d(0,1);
    glVertex3f(-1.0, 1.0,0.0);
    glTexCoord2d(1,1);
    glVertex3f( 1.0, 1.0,0.0);
    glTexCoord2d(1,0);
    glVertex3f( 1.0,-1.0,0.0);
    glEnd();
    glDisable(GL_TEXTURE_2D);
  }
  //  glEnable(GL_CULL_FACE);
  if ((style&ATOM_STYLE_SOLID)&& ( style&ATOM_STYLE_SPHERE)){
    //gluSphere(q,0.96,4*LOD,9*LOD);
    mySphere(qMin(LOD-1,3));
  }
  if (style&ATOM_STYLE_RINGS){
    glPushMatrix();
    if (style&ATOM_STYLE_WHITERING) glColor3f(1,1,1);
    else glColor3f(0,0,0);
    glDisable(GL_LIGHTING);
    glDisable(GL_CULL_FACE);
    gluQuadricNormals(q, GL_SMOOTH);   // ein Zylinder
    glPushMatrix();
    gluCylinder(q, 1.1, 1.1, 0.15 , 5*LOD, 1);
    glPopMatrix();

    glPushMatrix();
    glRotated(90.0,1.0,0.0,0.0);
    gluCylinder(q, 1.1, 1.1, 0.15 , 5*LOD, 1);
    glPopMatrix();

    glPushMatrix();
    glRotated(90.0,0.0,1.0,0.0);
    gluCylinder(q, 1.1, 1.1, 0.15 , 5*LOD, 1);
    glPopMatrix();

    glPopMatrix();
    glEnable(GL_LIGHTING);
  }
}


void Molecule::dodecaeder(GLfloat r){
  if (program_in_use&&(g_Program!=NULL)){
    g_Program->setUniformValue(lichtH, 1);
    g_Program->setUniformValue(wallH, 0);
    g_Program->setUniformValue(ringH, 0);
    g_Program->setUniformValue(openH, 0);
    g_Program->setUniformValue(adpsH, 0);
  }
  static const GLfloat dodev[324]={
    0.000000, -0.618034,  1.618034,  1.000000, -1.000000,  1.000000,  1.618034,  0.000000,  0.618034,
    0.000000, -0.618034,  1.618034,  1.618034,  0.000000,  0.618034,  1.000000,  1.000000,  1.000000,
    0.000000, -0.618034,  1.618034,  1.000000,  1.000000,  1.000000,  0.000000,  0.618034,  1.618034,
    0.000000,  0.618034,  1.618034, -1.000000,  1.000000,  1.000000, -1.618034,  0.000000,  0.618034,
    0.000000,  0.618034,  1.618034, -1.618034,  0.000000,  0.618034, -1.000000, -1.000000,  1.000000,
    0.000000,  0.618034,  1.618034, -1.000000, -1.000000,  1.000000,  0.000000, -0.618034,  1.618034,
    0.000000,  0.618034,  1.618034,  1.000000,  1.000000,  1.000000,  0.618034,  1.618034,  0.000000,
    0.000000,  0.618034,  1.618034,  0.618034,  1.618034,  0.000000, -0.618034,  1.618034,  0.000000,
    0.000000,  0.618034,  1.618034, -0.618034,  1.618034,  0.000000, -1.000000,  1.000000,  1.000000,
    1.000000,  1.000000,  1.000000,  1.618034,  0.000000,  0.618034,  1.618034,  0.000000, -0.618034,
    1.000000,  1.000000,  1.000000,  1.618034,  0.000000, -0.618034,  1.000000,  1.000000, -1.000000,
    1.000000,  1.000000,  1.000000,  1.000000,  1.000000, -1.000000,  0.618034,  1.618034,  0.000000,
    0.000000, -0.618034,  1.618034, -1.000000, -1.000000,  1.000000, -0.618034, -1.618034,  0.000000,
    0.000000, -0.618034,  1.618034, -0.618034, -1.618034,  0.000000,  0.618034, -1.618034,  0.000000,
    0.000000, -0.618034,  1.618034,  0.618034, -1.618034,  0.000000,  1.000000, -1.000000,  1.000000,
    -1.000000,  1.000000,  1.000000, -0.618034,  1.618034,  0.000000, -1.000000,  1.000000, -1.000000,
    -1.000000,  1.000000,  1.000000, -1.000000,  1.000000, -1.000000, -1.618034,  0.000000, -0.618034,
    -1.000000,  1.000000,  1.000000, -1.618034,  0.000000, -0.618034, -1.618034,  0.000000,  0.618034,
    -1.000000, -1.000000,  1.000000, -1.618034,  0.000000,  0.618034, -1.618034,  0.000000, -0.618034,
    -1.000000, -1.000000,  1.000000, -1.618034,  0.000000, -0.618034, -1.000000, -1.000000, -1.000000,
    -1.000000, -1.000000,  1.000000, -1.000000, -1.000000, -1.000000, -0.618034, -1.618034,  0.000000,
    1.618034,  0.000000,  0.618034,  1.000000, -1.000000,  1.000000,  0.618034, -1.618034,  0.000000,
    1.618034,  0.000000,  0.618034,  0.618034, -1.618034,  0.000000,  1.000000, -1.000000, -1.000000,
    1.618034,  0.000000,  0.618034,  1.000000, -1.000000, -1.000000,  1.618034,  0.000000, -0.618034,
    -0.618034,  1.618034,  0.000000,  0.618034,  1.618034,  0.000000,  1.000000,  1.000000, -1.000000,
    -0.618034,  1.618034,  0.000000,  1.000000,  1.000000, -1.000000,  0.000000,  0.618034, -1.618034,
    -0.618034,  1.618034,  0.000000,  0.000000,  0.618034, -1.618034, -1.000000,  1.000000, -1.000000,
    0.000000,  0.618034, -1.618034,  1.000000,  1.000000, -1.000000,  1.618034,  0.000000, -0.618034,
    0.000000,  0.618034, -1.618034,  1.618034,  0.000000, -0.618034,  1.000000, -1.000000, -1.000000,
    0.000000,  0.618034, -1.618034,  1.000000, -1.000000, -1.000000,  0.000000, -0.618034, -1.618034,
    -1.618034,  0.000000, -0.618034, -1.000000,  1.000000, -1.000000,  0.000000,  0.618034, -1.618034,
    -1.618034,  0.000000, -0.618034,  0.000000,  0.618034, -1.618034,  0.000000, -0.618034, -1.618034,
    -1.618034,  0.000000, -0.618034,  0.000000, -0.618034, -1.618034, -1.000000, -1.000000, -1.000000,
    0.000000, -0.618034, -1.618034,  1.000000, -1.000000, -1.000000,  0.618034, -1.618034,  0.000000,
    0.000000, -0.618034, -1.618034,  0.618034, -1.618034,  0.000000, -0.618034, -1.618034,  0.000000,
    0.000000, -0.618034, -1.618034, -0.618034, -1.618034,  0.000000, -1.000000, -1.000000, -1.000000};
  static const GLfloat doden[324]={
    0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,
    0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,
    0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,
    -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651,
    -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651,
    -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651,
    0.000000,  0.850651,  0.525731,  0.000000,  0.850651,  0.525731,  0.000000,  0.850651,  0.525731,
    0.000000,  0.850651,  0.525731,  0.000000,  0.850651,  0.525731,  0.000000,  0.850651,  0.525731,
    -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731,
    0.850651,  0.525731,  0.000000,  0.850651,  0.525731,  0.000000,  0.850651,  0.525731,  0.000000,
    0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,
    0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,  0.850651,  0.525731, -0.000000,
    -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731,
    -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731,
    -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731,
    -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000,
    -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000,
    -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000,
    -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000,
    -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000,
    -0.850651, -0.525731, -0.000000, -0.850651, -0.525731,  0.000000, -0.850651, -0.525731,  0.000000,
    0.850651, -0.525731, -0.000000,  0.850651, -0.525731,  0.000000,  0.850651, -0.525731,  0.000000,
    0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,
    0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,
    -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731,
    0.000000,  0.850651, -0.525731,  0.000000,  0.850651, -0.525731,  0.000000,  0.850651, -0.525731,
    -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731, -0.000000,  0.850651, -0.525731,
    0.525731,  0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731,  0.000000, -0.850651,
    0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,
    0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,  0.525731, -0.000000, -0.850651,
    -0.525731,  0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731,  0.000000, -0.850651,
    -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651,
    -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651,
    0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731,  0.000000, -0.850651, -0.525731,
    -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731,
    -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731, -0.000000, -0.850651, -0.525731};
  glPushMatrix();
  glScaled(r,r,r);
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, 0, dodev);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, 0, doden);
  glDrawArrays(GL_TRIANGLES, 0, 108);
  glDisableClientState(GL_VERTEX_ARRAY);
  glDisableClientState(GL_NORMAL_ARRAY);
  glPopMatrix();
}
void Molecule::icosaeder(GLfloat r){
  if (program_in_use&&(g_Program!=NULL)){
    g_Program->setUniformValue(lichtH, 1);
    g_Program->setUniformValue(wallH, 0);
    g_Program->setUniformValue(ringH, 0);
    g_Program->setUniformValue(openH, 0);
    g_Program->setUniformValue(adpsH, 0);
  }
  static const GLfloat icov[180]={
    1.000000,  0.000000,  1.618034,  0.000000,  1.618034,  1.000000, -1.000000,  0.000000,  1.618034,
    0.000000, -1.618034,  1.000000,  1.000000,  0.000000,  1.618034, -1.000000,  0.000000,  1.618034,
    1.000000,  0.000000,  1.618034,  1.618034,  1.000000,  0.000000,  0.000000,  1.618034,  1.000000,
    1.000000,  0.000000,  1.618034,  0.000000, -1.618034,  1.000000,  1.618034, -1.000000,  0.000000,
    1.000000,  0.000000,  1.618034,  1.618034, -1.000000,  0.000000,  1.618034,  1.000000,  0.000000,
    -1.000000,  0.000000,  1.618034,  0.000000,  1.618034,  1.000000, -1.618034,  1.000000,  0.000000,
    -1.000000,  0.000000,  1.618034, -1.618034, -1.000000,  0.000000,  0.000000, -1.618034,  1.000000,
    -1.000000,  0.000000,  1.618034, -1.618034,  1.000000,  0.000000, -1.618034, -1.000000,  0.000000,
    0.000000,  1.618034,  1.000000,  1.618034,  1.000000,  0.000000,  0.000000,  1.618034, -1.000000,
    0.000000,  1.618034,  1.000000,  0.000000,  1.618034, -1.000000, -1.618034,  1.000000,  0.000000,
    0.000000, -1.618034,  1.000000, -1.618034, -1.000000,  0.000000,  0.000000, -1.618034, -1.000000,
    0.000000, -1.618034,  1.000000,  0.000000, -1.618034, -1.000000,  1.618034, -1.000000,  0.000000,
    1.618034,  1.000000,  0.000000,  1.618034, -1.000000,  0.000000,  1.000000,  0.000000, -1.618034,
    1.618034,  1.000000,  0.000000,  1.000000,  0.000000, -1.618034,  0.000000,  1.618034, -1.000000,
    -1.618034,  1.000000,  0.000000, -1.000000,  0.000000, -1.618034, -1.618034, -1.000000,  0.000000,
    -1.618034,  1.000000,  0.000000,  0.000000,  1.618034, -1.000000, -1.000000,  0.000000, -1.618034,
    -1.618034, -1.000000,  0.000000, -1.000000,  0.000000, -1.618034,  0.000000, -1.618034, -1.000000,
    1.618034, -1.000000,  0.000000,  0.000000, -1.618034, -1.000000,  1.000000,  0.000000, -1.618034,
    0.000000,  1.618034, -1.000000,  1.000000,  0.000000, -1.618034, -1.000000,  0.000000, -1.618034,
    0.000000, -1.618034, -1.000000, -1.000000,  0.000000, -1.618034,  1.000000,  0.000000, -1.618034};
  static const GLfloat icon[180]={
    -0.000000,  0.356822,  0.934172, -0.000000,  0.356822,  0.934172, -0.000000,  0.356822,  0.934172,
    0.000000, -0.356822,  0.934172, -0.000000, -0.356822,  0.934172, -0.000000, -0.356822,  0.934172,
    0.577350,  0.577350,  0.577350,  0.577350,  0.577350,  0.577350,  0.577350,  0.577350,  0.577350,
    0.577350, -0.577350,  0.577350,  0.577350, -0.577350,  0.577350,  0.577350, -0.577350,  0.577350,
    0.934172, -0.000000,  0.356822,  0.934172, -0.000000,  0.356822,  0.934172, -0.000000,  0.356822,
    -0.577350,  0.577350,  0.577350, -0.577350,  0.577350,  0.577350, -0.577350,  0.577350,  0.577350,
    -0.577350, -0.577350,  0.577350, -0.577350, -0.577350,  0.577350, -0.577350, -0.577350,  0.577350,
    -0.934172, -0.000000,  0.356822, -0.934172, -0.000000,  0.356822, -0.934172, -0.000000,  0.356822,
    0.356822,  0.934172, -0.000000,  0.356822,  0.934172, -0.000000,  0.356822,  0.934172, -0.000000,
    -0.356822,  0.934172, -0.000000, -0.356822,  0.934172, -0.000000, -0.356822,  0.934172, -0.000000,
    -0.356822, -0.934172, -0.000000, -0.356822, -0.934172, -0.000000, -0.356822, -0.934172, -0.000000,
    0.356822, -0.934172, -0.000000,  0.356822, -0.934172, -0.000000,  0.356822, -0.934172, -0.000000,
    0.934172, -0.000000, -0.356822,  0.934172, -0.000000, -0.356822,  0.934172, -0.000000, -0.356822,
    0.577350,  0.577350, -0.577350,  0.577350,  0.577350, -0.577350,  0.577350,  0.577350, -0.577350,
    -0.934172, -0.000000, -0.356822, -0.934172, -0.000000, -0.356822, -0.934172, -0.000000, -0.356822,
    -0.577350,  0.577350, -0.577350, -0.577350,  0.577350, -0.577350, -0.577350,  0.577350, -0.577350,
    -0.577350, -0.577350, -0.577350, -0.577350, -0.577350, -0.577350, -0.577350, -0.577350, -0.577350,
    0.577350, -0.577350, -0.577350,  0.577350, -0.577350, -0.577350,  0.577350, -0.577350, -0.577350,
    -0.000000,  0.356822, -0.934172, -0.000000,  0.356822, -0.934172, -0.000000,  0.356822, -0.934172,
    0.000000, -0.356822, -0.934172,  0.000000, -0.356822, -0.934172,  0.000000, -0.356822, -0.934172};
  glPushMatrix();
  glScaled(r,r,r);
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, 0, icov);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, 0, icon);
  glDrawArrays(GL_TRIANGLES, 0, 60);
  glDisableClientState(GL_VERTEX_ARRAY);
  glDisableClientState(GL_NORMAL_ARRAY);
  glPopMatrix();
  icocnt++;
}
void Molecule::triacontaeder(GLfloat r){
  if (program_in_use&&(g_Program!=NULL)){
    g_Program->setUniformValue(lichtH, 1);
    g_Program->setUniformValue(wallH, 0);
    g_Program->setUniformValue(ringH, 0);
    g_Program->setUniformValue(openH, 0);
    g_Program->setUniformValue(adpsH, 0);
  }
  static const GLfloat triv[540]={ 
    1.000000,  0.000000,  1.618034,  0.000000,  0.618034,  1.618034,  0.000000, -0.618034,  1.618034,
    1.000000,  0.000000,  1.618034,  1.000000,  1.000000,  1.000000,  0.000000,  0.618034,  1.618034,
    1.000000,  0.000000,  1.618034,  0.000000, -0.618034,  1.618034,  1.000000, -1.000000,  1.000000,
    1.000000,  0.000000,  1.618034,  1.618034,  0.000000,  0.618034,  1.000000,  1.000000,  1.000000,
    1.000000,  0.000000,  1.618034,  1.000000, -1.000000,  1.000000,  1.618034,  0.000000,  0.618034,
    1.618034,  0.000000,  0.618034,  1.618034,  0.000000, -0.618034,  1.618034,  1.000000,  0.000000,
    1.618034,  0.000000,  0.618034,  1.618034, -1.000000,  0.000000,  1.618034,  0.000000, -0.618034,
    -1.618034,  0.000000,  0.618034, -1.618034,  1.000000,  0.000000, -1.618034,  0.000000, -0.618034,
    -1.618034,  0.000000,  0.618034, -1.618034,  0.000000, -0.618034, -1.618034, -1.000000,  0.000000,
    1.618034,  1.000000,  0.000000,  1.000000,  1.000000, -1.000000,  0.618034,  1.618034,  0.000000,
    1.618034,  1.000000,  0.000000,  1.618034,  0.000000, -0.618034,  1.000000,  1.000000, -1.000000,
    0.000000,  0.618034,  1.618034, -1.000000,  0.000000,  1.618034,  0.000000, -0.618034,  1.618034,
    0.000000,  0.618034,  1.618034, -1.000000,  1.000000,  1.000000, -1.000000,  0.000000,  1.618034,
    -0.618034,  1.618034,  0.000000, -1.000000,  1.000000, -1.000000, -1.618034,  1.000000,  0.000000,
    -0.618034,  1.618034,  0.000000,  0.000000,  1.618034, -1.000000, -1.000000,  1.000000, -1.000000,
    -1.618034,  1.000000,  0.000000, -1.000000,  1.000000, -1.000000, -1.618034,  0.000000, -0.618034,
    0.000000,  0.618034,  1.618034,  0.000000,  1.618034,  1.000000, -1.000000,  1.000000,  1.000000,
    -1.618034, -1.000000,  0.000000, -1.000000, -1.000000, -1.000000, -0.618034, -1.618034,  0.000000,
    -1.618034, -1.000000,  0.000000, -1.618034,  0.000000, -0.618034, -1.000000, -1.000000, -1.000000,
    0.618034, -1.618034,  0.000000,  1.000000, -1.000000, -1.000000,  1.618034, -1.000000,  0.000000,
    0.618034, -1.618034,  0.000000,  0.000000, -1.618034, -1.000000,  1.000000, -1.000000, -1.000000,
    1.618034, -1.000000,  0.000000,  1.000000, -1.000000, -1.000000,  1.618034,  0.000000, -0.618034,
    1.000000,  1.000000, -1.000000,  0.000000,  0.618034, -1.618034,  0.000000,  1.618034, -1.000000,
    1.000000,  1.000000, -1.000000,  1.000000,  0.000000, -1.618034,  0.000000,  0.618034, -1.618034,
    0.000000,  1.618034, -1.000000,  0.000000,  0.618034, -1.618034, -1.000000,  1.000000, -1.000000,
    -1.000000,  0.000000,  1.618034, -1.000000, -1.000000,  1.000000,  0.000000, -0.618034,  1.618034,
    -1.000000, -1.000000, -1.000000,  0.000000, -0.618034, -1.618034,  0.000000, -1.618034, -1.000000,
    -1.000000, -1.000000, -1.000000, -1.000000,  0.000000, -1.618034,  0.000000, -0.618034, -1.618034,
    -1.000000,  0.000000,  1.618034, -1.000000,  1.000000,  1.000000, -1.618034,  0.000000,  0.618034,
    0.000000, -1.618034, -1.000000,  0.000000, -0.618034, -1.618034,  1.000000, -1.000000, -1.000000,
    -1.000000,  0.000000,  1.618034, -1.618034,  0.000000,  0.618034, -1.000000, -1.000000,  1.000000,
    1.000000, -1.000000, -1.000000,  0.000000, -0.618034, -1.618034,  1.000000,  0.000000, -1.618034,
    1.000000,  0.000000, -1.618034,  0.000000, -0.618034, -1.618034,  0.000000,  0.618034, -1.618034,
    0.000000,  0.618034, -1.618034,  0.000000, -0.618034, -1.618034, -1.000000,  0.000000, -1.618034,
    0.000000, -0.618034,  1.618034,  0.000000, -1.618034,  1.000000,  1.000000, -1.000000,  1.000000,
    1.000000,  1.000000,  1.000000,  1.618034,  1.000000,  0.000000,  0.618034,  1.618034,  0.000000,
    1.000000,  1.000000,  1.000000,  0.618034,  1.618034,  0.000000,  0.000000,  1.618034,  1.000000,
    0.000000,  1.618034,  1.000000,  0.618034,  1.618034,  0.000000, -0.618034,  1.618034,  0.000000,
    0.000000,  1.618034,  1.000000, -0.618034,  1.618034,  0.000000, -1.000000,  1.000000,  1.000000,
    -1.000000, -1.000000,  1.000000, -1.618034, -1.000000,  0.000000, -0.618034, -1.618034,  0.000000,
    -1.000000, -1.000000,  1.000000, -0.618034, -1.618034,  0.000000,  0.000000, -1.618034,  1.000000,
    0.000000, -1.618034,  1.000000, -0.618034, -1.618034,  0.000000,  0.618034, -1.618034,  0.000000,
    0.000000, -1.618034,  1.000000,  0.618034, -1.618034,  0.000000,  1.000000, -1.000000,  1.000000,
    0.618034,  1.618034,  0.000000,  0.000000,  1.618034, -1.000000, -0.618034,  1.618034,  0.000000,
    -0.618034, -1.618034,  0.000000,  0.000000, -1.618034, -1.000000,  0.618034, -1.618034,  0.000000,
    0.618034,  1.618034,  0.000000,  1.000000,  1.000000, -1.000000,  0.000000,  1.618034, -1.000000,
    0.000000,  0.618034,  1.618034,  1.000000,  1.000000,  1.000000,  0.000000,  1.618034,  1.000000,
    -0.618034, -1.618034,  0.000000, -1.000000, -1.000000, -1.000000,  0.000000, -1.618034, -1.000000,
    1.618034,  0.000000, -0.618034,  1.000000,  0.000000, -1.618034,  1.000000,  1.000000, -1.000000,
    1.618034,  0.000000, -0.618034,  1.000000, -1.000000, -1.000000,  1.000000,  0.000000, -1.618034,
    -1.618034,  0.000000, -0.618034, -1.000000,  1.000000, -1.000000, -1.000000,  0.000000, -1.618034,
    -1.618034,  0.000000, -0.618034, -1.000000,  0.000000, -1.618034, -1.000000, -1.000000, -1.000000,
    -1.000000,  1.000000, -1.000000,  0.000000,  0.618034, -1.618034, -1.000000,  0.000000, -1.618034,
    0.000000, -0.618034,  1.618034, -1.000000, -1.000000,  1.000000,  0.000000, -1.618034,  1.000000,
    1.000000,  1.000000,  1.000000,  1.618034,  0.000000,  0.618034,  1.618034,  1.000000,  0.000000,
    -1.000000,  1.000000,  1.000000, -1.618034,  1.000000,  0.000000, -1.618034,  0.000000,  0.618034,
    -1.000000,  1.000000,  1.000000, -0.618034,  1.618034,  0.000000, -1.618034,  1.000000,  0.000000,
    -1.000000, -1.000000,  1.000000, -1.618034,  0.000000,  0.618034, -1.618034, -1.000000,  0.000000,
    1.000000, -1.000000,  1.000000,  1.618034, -1.000000,  0.000000,  1.618034,  0.000000,  0.618034,
    1.000000, -1.000000,  1.000000,  0.618034, -1.618034,  0.000000,  1.618034, -1.000000,  0.000000};
  static const GLfloat trin[540]={ 
    -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000,
    0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,
    0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,
    0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,
    0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,
    1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,
    1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,
    -1.000000, -0.000000, -0.000000, -1.000000, -0.000000, -0.000000, -1.000000, -0.000000, -0.000000,
    -1.000000, -0.000000,  0.000000, -1.000000, -0.000000,  0.000000, -1.000000, -0.000000,  0.000000,
    0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,
    0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,
    -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000,
    -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017,
    -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017,
    -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017,
    -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000,
    -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017,
    -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017,
    -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000,
    0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,
    0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,
    0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,
    0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,
    0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,
    -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017,
    -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017,
    -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017,
    -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017,
    -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000,
    0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,
    -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000,
    0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,
    -0.000000, -0.000000, -1.000000, -0.000000, -0.000000, -1.000000, -0.000000, -0.000000, -1.000000,
    -0.000000,  0.000000, -1.000000, -0.000000,  0.000000, -1.000000, -0.000000,  0.000000, -1.000000,
    0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,
    0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,
    0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,
    -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000,
    -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017,
    -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017,
    -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017,
    -0.000000, -1.000000, -0.000000, -0.000000, -1.000000, -0.000000, -0.000000, -1.000000, -0.000000,
    0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,
    -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000, -0.000000,  1.000000, -0.000000,
    -0.000000, -1.000000,  0.000000, -0.000000, -1.000000,  0.000000, -0.000000, -1.000000,  0.000000,
    0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,
    0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,
    -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017,
    0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,
    0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,
    -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000, -0.809017,  0.309017, -0.500000,
    -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000,
    -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017,
    -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017,
    0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,
    -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000,
    -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017,
    -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000,
    0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,  0.809017, -0.309017,  0.500000,
    0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017};
  glPushMatrix();
  glEnable(GL_CULL_FACE);
  glScaled(r,r,r);
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, 0, triv);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, 0, trin);
  glDrawArrays(GL_TRIANGLES, 0, 180);
  glDisableClientState(GL_VERTEX_ARRAY);
  glDisableClientState(GL_NORMAL_ARRAY);
  glDisable(GL_CULL_FACE);
  glPopMatrix();


}
void Molecule::cube(GLfloat r){
  if (program_in_use&&(g_Program!=NULL)){
    g_Program->setUniformValue(lichtH, 1);
    g_Program->setUniformValue(wallH, 0);
    g_Program->setUniformValue(ringH, 0);
    g_Program->setUniformValue(openH, 0);
    g_Program->setUniformValue(adpsH, 0);
  }
  static const GLfloat cubv[108]={
    -0.618034, -1.618034,  0.000000, -1.618034,  0.000000, -0.618034,  0.000000,  0.618034, -1.618034,
    -0.618034, -1.618034,  0.000000,  0.000000,  0.618034, -1.618034,  1.000000, -1.000000, -1.000000,
    -1.000000,  1.000000,  1.000000,  0.618034,  1.618034,  0.000000,  0.000000,  0.618034, -1.618034,
    -1.000000,  1.000000,  1.000000,  0.000000,  0.618034, -1.618034, -1.618034,  0.000000, -0.618034,
    -1.000000,  1.000000,  1.000000, -0.618034, -1.618034,  0.000000,  0.000000, -0.618034,  1.618034,
    -1.000000,  1.000000,  1.000000, -1.618034,  0.000000, -0.618034, -0.618034, -1.618034,  0.000000,
    -1.000000,  1.000000,  1.000000,  1.618034,  0.000000,  0.618034,  0.618034,  1.618034,  0.000000,
    -1.000000,  1.000000,  1.000000,  0.000000, -0.618034,  1.618034,  1.618034,  0.000000,  0.618034,
    0.000000, -0.618034,  1.618034,  1.000000, -1.000000, -1.000000,  1.618034,  0.000000,  0.618034,
    0.000000, -0.618034,  1.618034, -0.618034, -1.618034,  0.000000,  1.000000, -1.000000, -1.000000,
    1.618034,  0.000000,  0.618034,  0.000000,  0.618034, -1.618034,  0.618034,  1.618034,  0.000000,
    1.618034,  0.000000,  0.618034,  1.000000, -1.000000, -1.000000,  0.000000,  0.618034, -1.618034};
  static const GLfloat cubn[108]={
    -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017,
    -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017, -0.309017, -0.500000, -0.809017,
    -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017,
    -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017, -0.500000,  0.809017, -0.309017,
    -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000,
    -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000, -0.809017, -0.309017,  0.500000,
    0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,
    0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,  0.309017,  0.500000,  0.809017,
    0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,
    0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,  0.500000, -0.809017,  0.309017,
    0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,
    0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000,  0.809017,  0.309017, -0.500000};
  glPushMatrix();
  glScaled(r,r,r);
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, 0, cubv);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, 0, cubn);
  glDrawArrays(GL_TRIANGLES, 0, 36);
  glDisableClientState(GL_VERTEX_ARRAY);
  glDisableClientState(GL_NORMAL_ARRAY);
  glPopMatrix();
}
double Molecule::dieder(V3 a,V3 b, V3 c){

  static double erg;
  double A[3],B[3],sig;
  sig=a.x*b.y*c.z - a.z*b.y*c.x +
    a.z*b.x*c.y - a.x*b.z*c.y +
    a.y*b.z*c.x - a.y*b.x*c.z;

  A[0]= a.y*b.z - a.z*b.y;
  A[1]=-a.x*b.z + a.z*b.x;
  A[2]= a.x*b.y - a.y*b.x;

  B[0]=-b.y*c.z + b.z*c.y;
  B[1]= b.x*c.z - b.z*c.x;
  B[2]=-b.x*c.y + b.y*c.x;
  //  printf("A%f B%f\n",sqrt(A[0]*A[0]+A[1]*A[1]+A[2]*A[2]),sqrt(B[0]*B[0]+B[1]*B[1]+B[2]*B[2]));
  erg=(A[0]*B[0]+A[1]*B[1]+A[2]*B[2])/(sqrt(A[0]*A[0]+A[1]*A[1]+A[2]*A[2])*sqrt(B[0]*B[0]+B[1]*B[1]+B[2]*B[2]));
  erg=acos(erg)/M_PI*180.0f;
  return (sig>0)?(erg):(-erg);
}

double Molecule::winkel(V3 a,V3 b){

  static double erg;
  if ((Norm(a)<0.001)||(Norm(b)<0.001)) return 0;
  erg= a*b /(sqrt(Norm(a))*sqrt(Norm(b)));
  //  erg=(a.x*b.x+a.y*b.y+a.z*b.z)/(sqrt(a.x*a.x+a.y*a.y+a.z*a.z)*sqrt(b.x*b.x+b.y*b.y+b.z*b.z));
  erg=acos(erg)/M_PI*180.0;
  return(erg);
}

V3 Molecule::kreuzX(double x1,double y1,double z1,double x2,double y2,double z2) {

  static V3 erg;
  erg.x=-y1*z2+z1*y2;
  erg.y=-z1*x2+x1*z2;
  erg.z=-x1*y2+y1*x2;
  return(erg);
}


bool Molecule::decodeSymmCard(QString symmCard){ 
  /*! decodes a symmetry card like 'SYMM -X, 1/2+Y, -Z' and feeds cell.symmops and cell.trans lists.
   * @param symmCard like 'SYMM -X, 1/2+Y, -Z'.
   * \returns true on sucess.
   * */ 
  QString sc=symmCard.toUpper().remove("SYMM").trimmed();
  sc=sc.remove("'");
  sc=sc.remove(" ");
  QStringList axe=sc.split(",");
  QStringList bruch;
  if (axe.size()!=3) return false;
  double sx[3],sy[3],sz[3],t[3];
  for (int i=0; i<3; i++){
    sx[i]=0;sy[i]=0;sz[i]=0;t[i]=0;
    if (axe.at(i).contains("-X")) {sx[i]=-1.0;axe[i].remove("-X");}
    else if (axe.at(i).contains("X")) {sx[i]=1.0;axe[i].remove("X");}
    if (axe.at(i).contains("-Y")) {sy[i]=-1.0;axe[i].remove("-Y");}
    else if (axe.at(i).contains("Y")) {sy[i]=1.0;axe[i].remove("Y");}
    if (axe.at(i).contains("-Z")) {sz[i]=-1.0;axe[i].remove("-Z");}
    else if (axe.at(i).contains("Z")) {sz[i]=1.0;axe[i].remove("Z");}
    if (axe.at(i).endsWith("+")) axe[i].remove("+");
    if (axe.at(i).contains("/")) {
      bruch=axe.at(i).split("/");
      if (bruch.size()==2) t[i]=bruch.at(0).toDouble() / bruch.at(1).toDouble();
    }
    else if (!axe.at(i).isEmpty()) t[i]=axe.at(i).toDouble();
  }
  Matrix sm = Matrix(sx[0],sy[0],sz[0],	  sx[1],sy[1],sz[1],  sx[2],sy[2],sz[2]);

  cell.symmops.append(sm);
  cell.trans.append(V3(t[0],t[1],t[2]));
  return true;
}

bool Molecule::decodeSymmCardEQIV(QString symmCard){
  /*! decodes a symmetry card like 'SYMM -X, 1/2+Y, -Z' and feeds Molecule.symmopsEQIV, Molecule.transEQIV and Molecule.labelEQIV.
   * \returns true on success.
   * @param symmCard like 'SYMM -X, 1/2+Y, -Z'.
   */
  QString sc=symmCard.toUpper().remove("EQIV").trimmed();
  labelEQIV.append(sc.section(' ',0,0));
  sc.remove(labelEQIV.last());
  sc=sc.remove("'");
  sc=sc.remove(" ");
  QStringList axe=sc.split(",");
  QStringList bruch;
  if (axe.size()!=3) return false;
  double sx[3],sy[3],sz[3],t[3];
  for (int i=0; i<3; i++){
    sx[i]=0;sy[i]=0;sz[i]=0;t[i]=0;
    if (axe.at(i).contains("-X")) {sx[i]=-1.0;axe[i].remove("-X");}
    else if (axe.at(i).contains("X")) {sx[i]=1.0;axe[i].remove("X");}
    if (axe.at(i).contains("-Y")) {sy[i]=-1.0;axe[i].remove("-Y");}
    else if (axe.at(i).contains("Y")) {sy[i]=1.0;axe[i].remove("Y");}
    if (axe.at(i).contains("-Z")) {sz[i]=-1.0;axe[i].remove("-Z");}
    else if (axe.at(i).contains("Z")) {sz[i]=1.0;axe[i].remove("Z");}
    if (axe.at(i).endsWith("+")) axe[i].remove("+");
    if (axe.at(i).contains("/")) {
      bruch=axe.at(i).split("/");
      if (bruch.size()==2) t[i]=bruch.at(0).toDouble() / bruch.at(1).toDouble();
    }
    else if (!axe.at(i).isEmpty()) t[i]=axe.at(i).toDouble();
  }
  Matrix sm = Matrix(sx[0],sy[0],sz[0],	  sx[1],sy[1],sz[1],  sx[2],sy[2],sz[2]);
  symmopsEQIV.append(sm);
  transEQIV.append(V3(t[0],t[1],t[2]));
  //  qDebug()<<sx[0]<<sy[0]<<sz[0]<<   sx[1]<<sy[1]<<sz[1]<<  sx[2]<<sy[2]<<sz[2]<<t[0]<<t[1]<<t[2];
  return true;
}

QString Molecule::symmCard2Code(QString symmCard){
  /*! Creates a internal symmetry code from a human readable symmetry card.
   * @param symmCard human readable symmetry card like "-X, 1/2+Y, -Z"
   * \returns internal symmetry code like 'n_555:1'
   */
  QString sc=symmCard.toUpper().trimmed();
  sc=sc.remove("'");
  sc=sc.remove(" ");
  QStringList axe=sc.split(",");
  QStringList bruch;
  if (axe.size()!=3) return "";
  double sx[3],sy[3],sz[3],t[3];
  for (int i=0; i<3; i++){
    sx[i]=0;sy[i]=0;sz[i]=0;t[i]=0;
    if (axe.at(i).contains("-X")) {sx[i]=-1.0;axe[i].remove("-X");}
    else if (axe.at(i).contains("X")) {sx[i]=1.0;axe[i].remove("X");}
    if (axe.at(i).contains("-Y")) {sy[i]=-1.0;axe[i].remove("-Y");}
    else if (axe.at(i).contains("Y")) {sy[i]=1.0;axe[i].remove("Y");}
    if (axe.at(i).contains("-Z")) {sz[i]=-1.0;axe[i].remove("-Z");}
    else if (axe.at(i).contains("Z")) {sz[i]=1.0;axe[i].remove("Z");}
    if (axe.at(i).endsWith("+")) axe[i].remove("+");
    if (axe.at(i).contains("/")) {
      bruch=axe.at(i).split("/");
      if (bruch.size()==2) t[i]=bruch.at(0).toDouble() / bruch.at(1).toDouble();
    }
    else if (!axe.at(i).isEmpty()) t[i]=axe.at(i).toDouble();
  }
  Matrix sm = Matrix(sx[0],sy[0],sz[0],	  sx[1],sy[1],sz[1],  sx[2],sy[2],sz[2]);
  if (!cell.symmops.contains(sm)) return "";
  V3 r;
  r.x=fmod(t[0]+10,1.0);
  r.y=fmod(t[1]+10,1.0);
  r.z=fmod(t[2]+10,1.0);
  for (int i=0; i<cell.symmops.size();i++){
    if ((cell.symmops.at(i)==sm)&&(cell.trans.at(i)==r)){
      QString ss=QString("%1_%2%3%4:1,")
        .arg(i+1)
        .arg((int)(t[0]-r.x) +5)
        .arg((int)(t[1]-r.y) +5)
        .arg((int)(t[2]-r.z) +5);
      return ss;
    }
  }
  return "";
}

double Molecule::shortestDistance(QString sc){
  /*! computes the shortest distance for the given internal symmetry code.
  */
  double erg=100000;
  V3 frac;
  int s,h,k,l,symmgroup;
  sscanf(sc.toLatin1(),"%d_%1d%1d%1d:%d",&s,&h,&k,&l,&symmgroup);
  //printf("BS:!%s! %d h%d k%d l%d sg%d\n",brauchSymm.at(j).toStdString().c_str(),s,h,k,l,symmgroup);
  h-=5;
  k-=5;
  l-=5;
  s--;
  for (int i=0;i<asymm.size();i++){
    if ((asymm[i].molindex==symmgroup)&&(asymm[i].an>-1)){
      frac=cell.symmops.at(s)*asymm[i].frac+cell.trans.at(s)+V3(h,k,l);
      for (int j=0;j<asymm.size();j++){
        if (asymm.at(j).an<0)continue;
        erg=qMin(erg,fl(frac.x-asymm.at(j).frac.x,frac.y-asymm.at(j).frac.y,frac.z-asymm.at(j).frac.z));
      }
    }
  }
  return erg;
}



void Molecule::loadSettings(){
  /*! Loads molecular parameters stored in shelxle.ini 
  */
  QSettings einstellung( QSettings::IniFormat, QSettings::UserScope ,PROGRAM_NAME,PROGRAM_NAME );
  //einstellung.sync();
  einstellung.beginGroup("PSE");
  pseSize=einstellung.value("FontSize",10).toInt();
  einstellung.endGroup();
  einstellung.beginGroup("Atoms");
  int acsize;
  acsize = einstellung.beginReadArray("CovaleceRadii");
  // printf("H hat %d actsize %d\n", Kovalenz_Radien[0], acsize);
  for (int i = 0; i < acsize; ++i) {
    einstellung.setArrayIndex(i);
    Kovalenz_Radien[i] = einstellung.value("Radius").toInt();
    //    printf ("%d = %d\n",i,Kovalenz_Radien[i]);
  }
  einstellung.endArray();
  acsize = einstellung.beginReadArray("BallRadii");
  for (int i = 0; i < acsize; ++i) {
    einstellung.setArrayIndex(i);
    arad[i]=einstellung.value("Radius").toDouble();
  }
  einstellung.endArray();
  acsize = einstellung.beginReadArray("AtomColors");
  // printf("H hat %d Col actsize %d\n", Kovalenz_Radien[0], acsize);
  for (int i = 0; i < acsize; ++i) {
    einstellung.setArrayIndex(i);
    AtomColor[i] = einstellung.value("Color").value<QColor>();
    AtomColor[i].setAlphaF(0.5);
  }
  einstellung.endArray();
  acsize = einstellung.beginReadArray("AtomStyles");

  for (int i = 0; i < acsize; ++i) {
    einstellung.setArrayIndex(i);
    AtomStyle[i] = einstellung.value("Style").toInt();
  }
  einstellung.endArray();
  einstellung.endGroup();
  einstellung.beginGroup("Bonds");
  bondColor=einstellung.value("BondColor",QColor(Qt::darkGray)).value<QColor>();
  bondColorStyle=einstellung.value("BondStyle",0).toInt();
  bondStrength=einstellung.value("BondStrength",0.05).toDouble();
  HAMax=einstellung.value("HBondMaxDist",2.5).toDouble();
  HAWink=einstellung.value("HBondMaxAng",135.0).toDouble();

  enviBondColor=einstellung.value("enviBondColor",QColor(Qt::darkGreen)).value<QColor>();
  enviHBColor=einstellung.value("enviHBColor",QColor(Qt::darkYellow)).value<QColor>();
  enviDefaultColor=einstellung.value("enviDefaultColor",QColor(Qt::black)).value<QColor>();
  einstellung.endGroup();
  einstellung.beginGroup("QPeaks");
  qPeakRad = einstellung.value("QPeaksRadius",0.05).toDouble();
  einstellung.endGroup();
  einstellung.beginGroup("Window");
  LOD=einstellung.value("LevelOfDetail",4).toInt();
  if (einstellung.contains("Use_GLSL_Shaders")) useShaders=einstellung.value("Use_GLSL_Shaders").toBool();
  einstellung.endGroup();
}
void Molecule::setHBondMaxDist(double d){if ((d>0.0)&&(d<4.0)) HAMax=d;}
void Molecule::setHBondMaxAngl(double w){if ((w>0.0)&&(w<180.0)) HAWink=w;}

double Molecule::hbdist(){return HAMax;}
double Molecule::hbangl(){return HAWink;}
#include <stdio.h>
QString Molecule::symmcode2human(int s){
  /*! @param s the Nth symmetry operation of the space group.
   *  \returns human readable string. 
   */
  QString erg;
  Matrix m;
  V3 t;
  int h=0,k=0,l=0;
  m=cell.symmops.at(s);
  QString symstrX,symstrY,symstrZ;
  if (m.m11==1) symstrX.append("+x");
  if (m.m11==-1) symstrX.append("-x");
  if (m.m21==1) symstrX.append("+y");
  if (m.m21==-1) symstrX.append("-y");
  if (m.m31==1) symstrX.append("+z");
  if (m.m31==-1) symstrX.append("-z");

  if (m.m12==1) symstrY.append("+x");
  if (m.m12==-1) symstrY.append("-x");
  if (m.m22==1) symstrY.append("+y");
  if (m.m22==-1) symstrY.append("-y");
  if (m.m32==1) symstrY.append("+z");
  if (m.m32==-1) symstrY.append("-z");

  if (m.m13==1) symstrZ.append("+x");
  if (m.m13==-1) symstrZ.append("-x");
  if (m.m23==1) symstrZ.append("+y");
  if (m.m23==-1) symstrZ.append("-y");
  if (m.m33==1) symstrZ.append("+z");
  if (m.m33==-1) symstrZ.append("-z");
  t=cell.trans.at(s);
  V3 zaehler,nenner;
  double egal;
  for (int g=1;g<7; g++){
    nenner.x=(t.x<0)?-g:g;;
    zaehler.x=(int)round((t.x+h)*g);
    if (fabs(modf(t.x*g,&egal))<0.05) break;
  }
  for (int g=1;g<7; g++){
    nenner.y=(t.y<0)?-g:g;
    zaehler.y=(int)round((t.y+k)*g);
    if (fabs(modf(t.y*g,&egal))<0.05) break;
  }
  for (int g=1;g<7; g++){
    nenner.z=(t.z<0)?-g:g;
    zaehler.z=(int)round((t.z+l)*g);
    if (fabs(modf(t.z*g,&egal))<0.05) break;
  }
  erg=(QString(" %1/%2%3, %4/%5%6, %7/%8%9")
      .arg(zaehler.x)
      .arg(nenner.x)
      .arg(symstrX)
      .arg(zaehler.y)
      .arg(nenner.y)
      .arg(symstrY)
      .arg(zaehler.z)
      .arg(nenner.z)
      .arg(symstrZ));
  erg.remove(QRegExp("0/\\d"));
  erg.replace("1/1","1");
  erg.replace("2/1","2");
  erg.replace("3/1","3");
  erg.replace("4/1","4");
  erg.replace("5/1","5");
  erg.replace("6/1","6");
  return erg;
}

QString Molecule::symmcode2human(QString brauchSymm){
  /*! @param brauchSymm internal symmetry code n_555
   *  \returns human readable string 
   */
  QString erg;
  Matrix m;
  V3 t;
  int h,k,l,s;
  sscanf(brauchSymm.toLatin1(),"%d_%1d%1d%1d",&s,&h,&k,&l);
  h-=5;
  k-=5;
  l-=5;
  s--;
  m=cell.symmops.at(s);
  QString symstrX,symstrY,symstrZ;
  if (m.m11==1) symstrX.append("+x");
  if (m.m11==-1) symstrX.append("-x");
  if (m.m21==1) symstrX.append("+y");
  if (m.m21==-1) symstrX.append("-y");
  if (m.m31==1) symstrX.append("+z");
  if (m.m31==-1) symstrX.append("-z");

  if (m.m12==1) symstrY.append("+x");
  if (m.m12==-1) symstrY.append("-x");
  if (m.m22==1) symstrY.append("+y");
  if (m.m22==-1) symstrY.append("-y");
  if (m.m32==1) symstrY.append("+z");
  if (m.m32==-1) symstrY.append("-z");

  if (m.m13==1) symstrZ.append("+x");
  if (m.m13==-1) symstrZ.append("-x");
  if (m.m23==1) symstrZ.append("+y");
  if (m.m23==-1) symstrZ.append("-y");
  if (m.m33==1) symstrZ.append("+z");
  if (m.m33==-1) symstrZ.append("-z");
  t=cell.trans.at(s);
  V3 zaehler,nenner;
  double egal;
  for (int g=1;g<7; g++){
    nenner.x=(t.x<0)?-g:g;;
    zaehler.x=(int)round((t.x+h)*g);
    if (fabs(modf(t.x*g,&egal))<0.05) break;
  }
  for (int g=1;g<7; g++){
    nenner.y=(t.y<0)?-g:g;
    zaehler.y=(int)round((t.y+k)*g);
    if (fabs(modf(t.y*g,&egal))<0.05) break;
  }
  for (int g=1;g<7; g++){
    nenner.z=(t.z<0)?-g:g;
    zaehler.z=(int)round((t.z+l)*g);
    if (fabs(modf(t.z*g,&egal))<0.05) break;
  }
  erg=(QString("%1/%2%3, %4/%5%6, %7/%8%9")
      .arg(zaehler.x)
      .arg(nenner.x)
      .arg(symstrX)
      .arg(zaehler.y)
      .arg(nenner.y)
      .arg(symstrY)
      .arg(zaehler.z)
      .arg(nenner.z)
      .arg(symstrZ));


  erg.remove(QRegExp("0/\\d"));
  erg.replace("1/1","1");
  erg.replace("2/1","2");
  erg.replace("3/1","3");
  erg.replace("4/1","4");
  erg.replace("5/1","5");
  erg.replace("6/1","6");
  return erg;
}

QString Molecule::symmcode2human(QString brauchSymm, int j){
  /*! @param brauchSymm internal symmetry code n_555
   *  @param j symmetry number to prepend the human readable string returned.
   *  \returns human readable string 
   */
  QString erg;
  Matrix m;
  V3 t;
  int h,k,l,s;
  sscanf(brauchSymm.toLatin1(),"%d_%1d%1d%1d",&s,&h,&k,&l);
  h-=5;
  k-=5;
  l-=5;
  s--;
  m=cell.symmops.at(s);
  QString symstrX,symstrY,symstrZ;
  if (m.m11==1) symstrX.append("+x");
  if (m.m11==-1) symstrX.append("-x");
  if (m.m21==1) symstrX.append("+y");
  if (m.m21==-1) symstrX.append("-y");
  if (m.m31==1) symstrX.append("+z");
  if (m.m31==-1) symstrX.append("-z");

  if (m.m12==1) symstrY.append("+x");
  if (m.m12==-1) symstrY.append("-x");
  if (m.m22==1) symstrY.append("+y");
  if (m.m22==-1) symstrY.append("-y");
  if (m.m32==1) symstrY.append("+z");
  if (m.m32==-1) symstrY.append("-z");

  if (m.m13==1) symstrZ.append("+x");
  if (m.m13==-1) symstrZ.append("-x");
  if (m.m23==1) symstrZ.append("+y");
  if (m.m23==-1) symstrZ.append("-y");
  if (m.m33==1) symstrZ.append("+z");
  if (m.m33==-1) symstrZ.append("-z");
  t=cell.trans.at(s);
  V3 zaehler,nenner;
  double egal;
  for (int g=1;g<7; g++){
    nenner.x=(t.x<0)?-g:g;;
    zaehler.x=(int)round(((t.x+h)*g));//+0.0001
    if (fabs(modf(t.x*g,&egal))<0.05) break;
  }
  for (int g=1;g<7; g++){
    nenner.y=(t.y<0)?-g:g;
    zaehler.y=(int)round(((t.y+k)*g));//+0.001
    if (fabs(modf(t.y*g,&egal))<0.05) break;
  }
  for (int g=1;g<7; g++){
    nenner.z=(t.z<0)?-g:g;
    zaehler.z=(int)round(((t.z+l)*g));//+0.001
    if (fabs(modf(t.z*g,&egal))<0.05) break;
  }

  erg=(QString("&raquo;%1 :<b> %2/%3%4, %5/%6%7, %8/%9%10</b><br>")
      .arg(j)
      .arg(zaehler.x)
      .arg(nenner.x)
      .arg(symstrX)
      .arg(zaehler.y)
      .arg(nenner.y)
      .arg(symstrY)
      .arg(zaehler.z)
      .arg(nenner.z)
      .arg(symstrZ));

  erg.remove(QRegExp("0/\\d"));
  erg.replace("1/1","1");
  erg.replace("2/1","2");
  erg.replace("3/1","3");
  erg.replace("4/1","4");
  erg.replace("5/1","5");
  erg.replace("6/1","6");
  return erg;
}

QString Molecule::symmcode2human(QStringList brauchSymm){
  /*! @param brauchSymm list of internal symmetry codes 
   *  \returns human readable string sepearated by <br>
   */
  QString erg;
  Matrix m;
  V3 t;
  int h,k,l,s;
  for (int j=0; j<brauchSymm.size();j++){
    sscanf(brauchSymm[j].toLatin1(),"%d_%1d%1d%1d",&s,&h,&k,&l);
    h-=5;
    k-=5;
    l-=5;
    s--;
    m=cell.symmops.at(s);
    QString symstrX,symstrY,symstrZ;
    if (m.m11==1) symstrX.append("+x");
    if (m.m11==-1) symstrX.append("-x");
    if (m.m21==1) symstrX.append("+y");
    if (m.m21==-1) symstrX.append("-y");
    if (m.m31==1) symstrX.append("+z");
    if (m.m31==-1) symstrX.append("-z");

    if (m.m12==1) symstrY.append("+x");
    if (m.m12==-1) symstrY.append("-x");
    if (m.m22==1) symstrY.append("+y");
    if (m.m22==-1) symstrY.append("-y");
    if (m.m32==1) symstrY.append("+z");
    if (m.m32==-1) symstrY.append("-z");

    if (m.m13==1) symstrZ.append("+x");
    if (m.m13==-1) symstrZ.append("-x");
    if (m.m23==1) symstrZ.append("+y");
    if (m.m23==-1) symstrZ.append("-y");
    if (m.m33==1) symstrZ.append("+z");
    if (m.m33==-1) symstrZ.append("-z");
    t=cell.trans.at(s);
    V3 zaehler,nenner;
    double egal;
    for (int g=1;g<7; g++){
      nenner.x=(t.x<0)?-g:g;;
      zaehler.x=(int)round((t.x+h)*g);
      if (fabs(modf(t.x*g,&egal))<0.05) break;
    }
    for (int g=1;g<7; g++){
      nenner.y=(t.y<0)?-g:g;
      zaehler.y=(int)round((t.y+k)*g);
      if (fabs(modf(t.y*g,&egal))<0.05) break;
    }
    for (int g=1;g<7; g++){
      nenner.z=(t.z<0)?-g:g;
      zaehler.z=(int)round((t.z+l)*g);
      if (fabs(modf(t.z*g,&egal))<0.05) break;
    }
    erg.append(QString("&raquo;%1 :<b> %2/%3%4, %5/%6%7, %8/%9%10</b><br>")
        .arg(j+1)
        .arg(zaehler.x)
        .arg(nenner.x)
        .arg(symstrX)
        .arg(zaehler.y)
        .arg(nenner.y)
        .arg(symstrY)
        .arg(zaehler.z)
        .arg(nenner.z)
        .arg(symstrZ));

  }
  erg.remove(QRegExp("0/\\d"));
  erg.replace("1/1","1");
  erg.replace("2/1","2");
  erg.replace("3/1","3");
  erg.replace("4/1","4");
  erg.replace("5/1","5");
  erg.replace("6/1","6");
  return erg;
}

void Molecule::frac2kart(V3 x, V3 &y){
  /*!
   * converts a fractional coordinate into a cartesian using cell information.
   * @param[in] x fractional coordinate.
   * @param[out] y cartesian coordinate.
   */
  Matrix u;
  u.m11 = cell.a;
  u.m21 = 0.0;
  u.m31 = 0.0;
  u.m12 = cell.b * cell.cosga;
  u.m22 = cell.b * cell.singa;
  u.m32 = 0.0;
  u.m13 = cell.c * cell.cosbe;
  u.m23 = cell.tau;
  u.m33 = cell.c * cell.phi / cell.singa;

  y.x = x.x * u.m11 + x.y * u.m12 + x.z * u.m13;
  y.y = x.x * u.m21 + x.y * u.m22 + x.z * u.m23;
  y.z = x.x * u.m31 + x.y * u.m32 + x.z * u.m33;

}

void Molecule::kart2frac(V3 x, V3 &y){
  /*!
   * converts a cartesian coordinate into a fractional using cell information.
   * @param[in] x cartesian coordinate.
   * @param[out] y fractional coordinate.
   */
  Matrix u;
  y.x =0.0 ;
  y.y =0.0 ;
  y.z =0.0;
  u.m11 = 1.0/cell.a;
  u.m21 = 0.0;
  u.m31 = 0.0;
  u.m12 = -1.0/(cell.a * cell.tanga);
  u.m22 = 1.0/(cell.b * cell.singa);
  u.m32 = 0.0;
  u.m13 = (cell.cosal*cell.cosga-cell.cosbe)/(cell.a*cell.phi*cell.singa);
  u.m23 = (cell.cosbe*cell.cosga-cell.cosal)/(cell.b*cell.phi*cell.singa);
  u.m33 = cell.singa/(cell.c*cell.phi);
  // Wird jetzt hier genauso wie in int Tab B S.345 gerechnet (M^-1^).
  y.x = x.x * u.m11 + x.y * u.m12 + x.z * u.m13;
  y.y = x.x * u.m21 + x.y * u.m22 + x.z * u.m23;
  y.z = x.x * u.m31 + x.y * u.m32 + x.z * u.m33;
}

QString Molecule::pse(int oz){

  static QStringList PSE;

  PSE<<"H"<<"He"<<"Li"<<"Be"<<"B"<<"C"<<"N"<<"O"<<"F"<<"Ne"<<"Na"<<"Mg"<<"Al"<<"Si"<<"P"<<"S"<<"Cl"<<"Ar"<<
    "K"<<"Ca"<<"Sc"<<"Ti"<<"V"<<"Cr"<<"Mn"<<"Fe"<<"Co"<<"Ni"<<"Cu"<<"Zn"<<"Ga"<<"Ge"<<"As"<<"Se"<<"Br"<<"Kr"<<
    "Rb"<<"Sr"<<"Y"<<"Zr"<<"Nb"<<"Mo"<<"Tc"<<"Ru"<<"Rh"<<"Pd"<<"Ag"<<"Cd"<<"In"<<"Sn"<<"Sb"<<"Te"<<"I"<<"Xe"<<
    "Cs"<<"Ba"<< "La"<<"Ce"<<"Pr"<<"Nd"<<"Pm"<<"Sm"<<"Eu"<<"Gd"<<"Tb"<<"Dy"<<"Ho"<<"Er"<<"Tm"<<"Yb"<<"Lu"<<
    "Hf"<<"Ta"<<"W"<<"Re"<<"Os"<<"Ir"<<"Pt"<<"Au"<<"Hg"<<"Tl"<<"Pb"<<"Bi"<<"Po"<<"At"<<"Rn"<<"Fr"<<"Ra"<<
    "Ac"<<"Th"<<"Pa"<<"U"<<"Np"<<"Pu"<<"Am"<<"Cm"<<"Bk"<<"Cf"<<"Es"<<"Fm"<<"Md"<<"No"<<"Lr"<<"Ku"<<"Ha"<<"Rf"<<"Ns"<<"Hs"<<"Mt";
  if ((oz>-1)&&(oz<PSE.size())) return PSE.at(oz);
  return "";

}

int Molecule::getOZ(QString S1){
  QString s=S1;
  s=s.remove('$');
  s=s.section(QRegExp("[^A-Za-z]"),0,0);
  s=s.toUpper();
  static QStringList PSE;
  if (s=="CNT") return -66;
  if (s=="D") return 0;
  PSE<<"H"<<"HE"<<"LI"<<"BE"<<"B"<<"C"<<"N"<<"O"<<"F"<<"NE"<<"NA"<<"MG"<<"AL"<<"SI"<<"P"<<"S"<<"CL"<<"AR"<<
    "K"<<"CA"<<"SC"<<"TI"<<"V"<<"CR"<<"MN"<<"FE"<<"CO"<<"NI"<<"CU"<<"ZN"<<"GA"<<"GE"<<"AS"<<"SE"<<"BR"<<"KR"<<
    "RB"<<"SR"<<"Y"<<"ZR"<<"NB"<<"MO"<<"TC"<<"RU"<<"RH"<<"PD"<<"AG"<<"CD"<<"IN"<<"SN"<<"SB"<<"TE"<<"I"<<"XE"<<
    "CS"<<"BA"<< "LA"<<"CE"<<"PR"<<"ND"<<"PM"<<"SM"<<"EU"<<"GD"<<"TB"<<"DY"<<"HO"<<"ER"<<"TM"<<"YB"<<"LU"<<
    "HF"<<"TA"<<"W"<<"RE"<<"OS"<<"IR"<<"PT"<<"AU"<<"HG"<<"TL"<<"PB"<<"BI"<<"PO"<<"AT"<<"RN"<<"FR"<<"RA"<<
    "AC"<<"TH"<<"PA"<<"U"<<"NP"<<"PU"<<"AM"<<"CM"<<"BK"<<"CF"<<"ES"<<"FM"<<"MD"<<"NO"<<"LR"<<"KU"<<"HA"<<"RF"<<"NS"<<"HS"<<"MT";

  return PSE.indexOf(s);
}

void Molecule::uniqueInCell(){
  /*! Moves centers of gravity of each fragment into the unit cell box and close to the origin.
   * */
  QList<int> flags;
  int toflipp=0;
  for (int i=0; i<asymm.size(); i++) if (asymm.at(i).an>-1){
    flags.append(-1);
    toflipp++;
  }else flags.append(0);
  flags[0]=1;
  double dk;
  V3 prime,dp,D,floorD;
  //  V3 D,floorD;
  QList<V3> minMol;
  for (int i=0; i<maxmol; i++) minMol.append(V3(0,0,0));
  SdmItem sdmItem;
  sdmItem.a1=0;
  sdmItem.a2=1;
  sdmItem.sn=0;
  sdmItem.covalent=true;
  QList<SdmItem> starter;
  QList<int> mii;
  for (int j=0; j<maxmol; j++){
    int mi=0;
    for (int i=0; i<asymm.size(); i++){
      if ((asymm.at(i).molindex-1)!=j) continue;
      minMol[j]+=asymm.at(i).frac;
      mi++;
    }
    mii.append(mi);
    minMol[j]*=1.0/mi;
  }
  for (int j=0; j<maxmol; j++){
    if (mii.at(j)==0){
      sdmItem.sn=0;
      sdmItem.floorD=V3(floor(minMol.at(j).x),floor(minMol.at(j).y),floor(minMol.at(j).z));
      sdmItem.a2=sdmItem.a1=j;
      starter.append(sdmItem);
    }else{
      double min=99999.0;
      for (int n=0;n<cell.symmops.size();  n++){
        prime=cell.symmops.at(n) * minMol.at(j) + cell.trans.at(n);
        D=prime + V3(0.05,0.05,0.05) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        dp=D - floorD - V3(0.5,0.5,0.5);
        dk=fl(dp.x,dp.y,dp.z);
        if (dk<min){
          sdmItem.d=dk;
          min=dk;
          sdmItem.floorD=floorD;
          sdmItem.a1=j;
          sdmItem.a2=j;
          sdmItem.sn=n;
        }
      }
      starter.append(sdmItem);
    }
  }
  for (int i=0; i<asymm.size(); i++){
    if (asymm.at(i).molindex<1) continue;
    int n=  starter.at(asymm.at(i).molindex-1).sn;
    V3 f=starter.at(asymm.at(i).molindex-1).floorD;
    asymm[i].frac= cell.symmops.at(n) * asymm.at(i).frac + cell.trans.at(n) - f;
    frac2kart(asymm[i].frac,asymm[i].pos);

  }
  packer(sdmcompleter());
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::enviSDM(double range){
  /*! Calculates the shortes distance matrix for the ENVIronment functionality in the given range.
   * @param range maximal distances around each atom to generate a matrix entry. 
   */

  // George Sheldrick Seminar ideas
  double dk,dddd;
  V3 prime,dp,D,floorD;
  envi_sdm.clear();
  SdmItem sdmItem;
  sdmItem.a1=0;
  sdmItem.a2=1;
  sdmItem.sn=0;
  //sdmItem.p1=sdmItem.p2=V3(0,0,0);
  for (int i=0; i<asymm.size(); i++){ 
    for (int j=0; j<asymm.size(); j++ ){
      //  bool hma=false;
      for (int n=0;n<cell.symmops.size();  n++){
        prime=cell.symmops.at(n) * asymm.at(i).frac + cell.trans.at(n);
        D=prime - asymm.at(j).frac+ V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        for (int h=-1; h<2; h++){
          for (int k=-1; k<2; k++){
            for (int l=-1; l<2; l++){
              V3 fD=floorD+V3(h,k,l);  
              dp=D - fD - V3(0.5,0.5,0.5);
              dk=fl(dp.x,dp.y,dp.z);
              if ((dk>0.01)&&((range)>=dk)){
                sdmItem.d=dk;
                sdmItem.floorD=fD;
                sdmItem.a1=i;
                sdmItem.a2=j;
                sdmItem.sn=n;
                if ((asymm[i].an>-1)&&(asymm[j].an>-1)&&
                    ((asymm[i].part*asymm[j].part==0)||
                     (asymm[i].part==asymm[j].part)))
                  dddd=(Kovalenz_Radien[asymm[i].an]+ Kovalenz_Radien[asymm[j].an])*0.012;
                else dddd=0;
                if (sdmItem.d<dddd){
                  sdmItem.covalent=true;
                }else sdmItem.covalent=false;
                envi_sdm.append(sdmItem);
              }
            }
          }
        }
      }
    }
  }
  qSort(envi_sdm.begin(),envi_sdm.end());
  //histogram
  /*
     double hmi,hma;
     hmi=envi_sdm.first().d;
     hma=envi_sdm.last().d;
     double hstep=(hma-hmi)/20.0;
     printf("%g %g %g %d\n",hma,hmi,hstep,envi_sdm.size());
     if (hstep<0.01) return;
     int hbox[20]={
     0,0,0,0,0,
     0,0,0,0,0,
     0,0,0,0,0,
     0,0,0,0,0};
     for (int i=0; i<envi_sdm.size();i++){
     int hind=(int) (envi_sdm.at(i).d/hstep);
     hbox[hind]++;
     }
     for (int i=0;i<20;i++){
     printf("%g-%g %d  (%g)\n",hmi+hstep*i,hmi+i*hstep+hstep,hbox[i],hma);
     }
  // */
}


QStringList Molecule::sdmcompleter(){
  /*! Calculates the shortest distance matrix. 
   * Counts the number of fragmets in the asymmetric unit. 
   * Finds possible hydrogen bond contacts.
   * \returns internal symmtry code list for grown structures.
   */
  // George Sheldrick Seminar ideas
  //  printf("sdm1 %d\n",__LINE__);
  //  QTime zeit; zeit.start();
  double dk,dddd;
  V3 prime,dp,D,floorD;
  contact.clear();
  sdm.clear();
  SdmItem sdmItem;
  sdmItem.a1=0;
  sdmItem.a2=0;
  sdmItem.sn=0;
  SdmItem sdmItem2;
  sdmItem2.a1=0;
  sdmItem2.a2=0;
  sdmItem2.sn=0;

  knoepfe.clear();
  Knopf kn;
  kn.neighbors.clear();
  for (int i=0; i<asymm.size(); i++){
    kn.neighbors.clear();
    for (int j=0; j<asymm.size(); j++ ){
      double min=1000000;
      bool hma=false;
      for (int n=0;n<cell.symmops.size();  n++){
        //for (int n=0;n<1;  n++){
        prime=cell.symmops.at(n) * asymm.at(i).frac + cell.trans.at(n);
        D=prime - asymm.at(j).frac+ V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        dp=D - floorD - V3(0.5,0.5,0.5);
        dk=fl(dp.x,dp.y,dp.z);
        if (n) dk+=0.0001;
        if ((dk>0.01)&&((min+0.00)>=dk)){
          min=fmin(dk,min);
          sdmItem.d=min;
          sdmItem.floorD=floorD;
          sdmItem.a1=i;
          sdmItem.a2=j;
          sdmItem.sn=n;
          hma=true;
        }
      }
      if ((asymm[sdmItem.a1].an>-1)&&(asymm[sdmItem.a2].an>-1)&&
          ((asymm[sdmItem.a1].part*asymm[sdmItem.a2].part==0)||
           (asymm[sdmItem.a1].part==asymm[sdmItem.a2].part)))
        dddd=(Kovalenz_Radien[asymm[sdmItem.a1].an]+ Kovalenz_Radien[asymm[sdmItem.a2].an])*0.012;
      else dddd=0;
      if (sdmItem.d<dddd){
        if (hma) kn.neighbors.append(j);
        sdmItem.covalent=true;
      }else sdmItem.covalent=false;
      if (hma) sdm.append(sdmItem);
      }
      knoepfe.append(kn);
    }
    //  printf("sdm2 %d\n",zeit.elapsed()); zeit.restart();
    for (int i=0; i<asymm.size(); i++){ //wasserstoffbrueckensuche
      for (int j=0; j<asymm.size(); j++ ){
        for (int nn=0;nn<cell.symmops.size();  nn++){
          prime=cell.symmops.at(nn) * asymm.at(i).frac + cell.trans.at(nn);
          D=prime - asymm.at(j).frac+ V3(0.5,0.5,0.5) ;
          floorD=V3(floor(D.x),floor(D.y),floor(D.z));
          dp=D - floorD - V3(0.5,0.5,0.5);
          dk=fl(dp.x,dp.y,dp.z);
          if((1)&&(abs(asymm[i].an-7)<2)&&(abs(asymm[j].an-7)<2)&&(fabs(dk-2.725)<0.275)){//N O F mit abstanden zwischen 2.45 bis 3 A koennten H=Bruecken sein
            sdmItem2.d=dk;
            sdmItem2.floorD=floorD;
            sdmItem2.a1=i;
            sdmItem2.a2=j;
            sdmItem2.sn=nn;
            sdmItem2.covalent=true;
            double ang1=361,ang2=361,an;
            for (int oo=0; oo<knoepfe.at(i).neighbors.size(); oo++){
              an=wl(asymm.at(j).frac,
                  cell.symmops.at(nn) * asymm.at(i).frac + cell.trans.at(nn)-floorD,
                  cell.symmops.at(nn) * asymm.at(knoepfe.at(i).neighbors.at(oo)).frac + cell.trans.at(nn)-floorD);
              ang1=(an<ang1)?an:ang1;
            }
            for (int oo=0; oo<knoepfe.at(j).neighbors.size(); oo++){
              an=wl(
                  cell.symmops.at(nn) * asymm.at(i).frac  + cell.trans.at(nn)-floorD,
                  asymm.at(j).frac,
                  asymm.at(knoepfe.at(j).neighbors.at(oo)).frac);
              ang2=(an<ang2)?an:ang2;
            }
            if ((qMax(ang1,ang2)!=361)&&((qMin(ang1,ang2)<90)||(qMax(ang1,ang2)>180))) sdmItem2.covalent=false;
            else {
              contact.append(sdmItem2);
            }
          }
        }
      }
    }
    //  printf("sdm3 %d\n",zeit.elapsed());//\n"); zeit.restart();
    QString bs;
    QStringList brauchSymm;
    int someleft=0,nextmol=0;
    maxmol=1;
    for (int i=0; i<asymm.size();i++) asymm[i].molindex=-1;
    asymm[0].molindex=1;//starter;
    do {
      nextmol=0;
      do {
        someleft=0;
        for  (int i=0; i<sdm.size();i++){
          if ((sdm.at(i).covalent)&&(asymm[sdm.at(i).a1].molindex*asymm[sdm.at(i).a2].molindex<0)) {
            asymm[sdm.at(i).a1].molindex=maxmol;
            asymm[sdm.at(i).a2].molindex=maxmol;
            someleft++;
          }
        }
      }while (someleft);
      for ( int i=0; i<asymm.size();i++) {
        if ((asymm[i].an>-1)&&(asymm[i].molindex<0)) {nextmol=i;break;}
      }
      if (nextmol) {
        asymm[nextmol].molindex=(++maxmol);
      }
    }while (nextmol);
    Fragments=QString("<b>The asymmetric unit contains %1 fragments.</b><br>").arg(maxmol);
    for (int k =0; k<sdm.size();k++){
      if (sdm.at(k).covalent){
        if (asymm[sdm.at(k).a1].molindex<1) continue;
        if (asymm[sdm.at(k).a1].molindex>6) continue;
        for (int n=0;n<cell.symmops.size();  n++){
          if (((asymm[sdm.at(k).a1].part!=0)&&(asymm[sdm.at(k).a2].part!=0)&&(asymm[sdm.at(k).a1].part!=asymm[sdm.at(k).a2].part)))continue;
          if ((asymm[sdm.at(k).a1].an==asymm[sdm.at(k).a2].an)&&(asymm[sdm.at(k).a1].an==0)) continue;
          prime=cell.symmops.at(n) * asymm[sdm.at(k).a1].frac + cell.trans.at(n);
          D=prime - asymm[sdm.at(k).a2].frac+ V3(0.5,0.5,0.5) ;
          floorD=V3(floor(D.x),floor(D.y),floor(D.z));
          dp=D - floorD - V3(0.5,0.5,0.5);
          if ((n==0)&&(V3(0,0,0)==floorD)) continue;
          dk=fl(dp.x,dp.y,dp.z);
          dddd=(sdm.at(k).d+0.2);
          if ((dk>0.001)&&(dddd>=dk)) {
            bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm[sdm.at(k).a1].molindex);
            if  ((!brauchSymm.contains(bs))) {
              brauchSymm.append(bs);
              //            printf("%d %d %d %d [%d]\n",n+1,(int)floorD.x,(int)floorD.y,(int)floorD.z ,brauchSymm.size());
            }
          }
        }
      }
    }
    //  printf("sdm4 %d\n",zeit.elapsed()); zeit.restart();
    qSort(sdm.begin(),sdm.end());
    //  printf("sdm5 %d\n",zeit.elapsed());//\n"); zeit.restart();
    enviSDM(2.5);
    //  printf("sdm5 %d\n",zeit.elapsed());//\n"); zeit.restart();

    QList<int> flags;
    for (int i=0; i<asymm.size(); i++) flags.append((asymm.at(i).an<0)?-1:1);
    for (int i=0; i<envi_sdm.size(); i++)
      if ((flags.at(envi_sdm.at(i).a1)*flags.at(envi_sdm.at(i).a2))==-1) {
        //if ((qbeforehkl)||((flags.at(sdm.at(i).a1)==-1)&&((asymm.at(sdm.at(i).a2).an>-1)))){
        //   if (((asymm[envi_sdm.at(i).a1].Label=="Q11")||(asymm[envi_sdm.at(i).a2].Label=="Q11"))&&(envi_sdm.at(i).d<2.6))
        //       qDebug()<<asymm[envi_sdm.at(i).a1].Label<<asymm[envi_sdm.at(i).a2].Label<<envi_sdm.at(i).d<<flags[envi_sdm.at(i).a1]<<flags[envi_sdm.at(i).a2];
        if (asymm[envi_sdm.at(i).a1].an>-1) continue;
        if (asymm[envi_sdm.at(i).a1].an==-66) continue;
        if ((envi_sdm.at(i).sn==0)&&(envi_sdm.at(i).floorD==V3(0,0,0))) {flags[envi_sdm.at(i).a1]=1;continue;}
        if (envi_sdm.at(i).d>2.4) continue;
        asymm[envi_sdm.at(i).a1].frac = cell.symmops.at(envi_sdm.at(i).sn) * asymm[envi_sdm.at(i).a1].frac + cell.trans.at(envi_sdm.at(i).sn) - envi_sdm.at(i).floorD;
        flags[envi_sdm.at(i).a1]=1;
        frac2kart(asymm[envi_sdm.at(i).a1].frac,asymm[envi_sdm.at(i).a1].pos);
        //}
      }
    //  printf("sdm6 %d\n",zeit.elapsed()); zeit.restart();
    return brauchSymm;
  }

  /*
     qDebug()<<neededSymm.size()<<ss;
  // */

  Connection Molecule::connecting(const CEnvironment &atom,bool eac){
    /*! Creates bonds and lbonds depending on covalent radii.
     * If edit atom style flag (eac) is not set FREE and BIND instructions are considered.
     * Feeds also Molecule.knoepfe list.
     * \returns the Connection bond list.
     * */
    Connection bonds;
    bonds.clear();
    lbonds.clear();
    MyBond bond;
    double soll=0;
    for (int i=0; i<atom.size(); i++){
      for (int j=0; j<=i; j++ ){
        double d = sqrt(Distance(atom.at(i).pos,atom.at(j).pos));
        if ((atom.at(i).part<0)&&(atom.at(j).part!=0)&&(atom.at(i).symmGroup!=atom.at(j).symmGroup)) continue;
        if ((atom.at(j).part<0)&&(atom.at(i).part!=0)&&(atom.at(i).symmGroup!=atom.at(j).symmGroup)) continue;
        if ((atom.at(i).an==0)&&(atom.at(j).an==0)) continue;
        if ((atom.at(i).an>-1)&&(atom.at(j).an>-1)&&
            ((!atom.at(i).part)||(!atom.at(j).part)||(atom.at(i).part==atom.at(j).part)))
          soll=(Kovalenz_Radien[atom.at(i).an]+ Kovalenz_Radien[atom.at(j).an])*0.012;
        else
          soll=-1;
        if ((d>0.1)&&(d<soll)) {
          bond.ato1=&atom[i];
          bond.ato2=&atom[j];
          bond.a1=i;
          bond.a2=j;
          bond.length=d;
          bonds.append(bond);
        }
        else if ((d<qboMax)&&(d>qboMin)){
          if ((atom.at(i).an==-42)||(atom.at(j).an==-42)) continue;//belo: wuff!
          if ((atom.at(i).an==0)||(atom.at(j).an==0)) continue;
          if  ((!atom.at(i).part)||(!atom.at(j).part)||(atom.at(i).part==atom.at(j).part)){ 
            bond.ato1=&atom[i];
            bond.ato2=&atom[j];
            bond.a1=i;
            bond.a2=j;
            bond.length=d;
            lbonds.append(bond);
          }
        }
      }
    }
    if (!eac) for (int i=0; i<freeatoms.size(); i++){
      MyAtom a1, a2;
      bool bo=false;
      if (freeatoms.at(i).Lab1.contains('_')) a1.resiNr=freeatoms.at(i).Lab1.section('_',1,1).toInt(&bo);
      if (!bo) a1.resiNr=-1;
      if (freeatoms.at(i).Lab2.contains('_'))a2.resiNr=freeatoms.at(i).Lab2.section('_',1,1).toInt(&bo);
      if (!bo)a2.resiNr=-1;
      a1.Label = freeatoms.at(i).Lab1.section('_',0,0);
      a2.Label = freeatoms.at(i).Lab2.section('_',0,0);
      //printf("#%d %d\n",a2.resiNr,a1.resiNr);

      for (int j=0;j<bonds.size();j++){
        if (((a1.resiNr>-1)&& (bonds.at(j).ato1->resiNr!=a1.resiNr))|| 
            ((a2.resiNr>-1)&& (bonds.at(j).ato2->resiNr!=a2.resiNr))) continue;
        if (((a1.resiNr>-1)&& (bonds.at(j).ato2->resiNr!=a1.resiNr))|| 
            ((a2.resiNr>-1)&& (bonds.at(j).ato1->resiNr!=a2.resiNr))) continue;
        if (((bonds.at(j).ato1->Label.section('_',0,0).toUpper()== a1.Label)&&
              (bonds.at(j).ato2->Label.section('_',0,0).toUpper()== a2.Label))||
            ((bonds.at(j).ato2->Label.section('_',0,0).toUpper()== a1.Label)&&
             (bonds.at(j).ato1->Label.section('_',0,0).toUpper()== a2.Label))){
          bonds.removeAt(j);
          j=qMax(j-1,0);
        }
      }
    }
    if (!eac) for (int i=0; i<bindatoms.size(); i++){
      MyAtom a1, a2;
      bool bo=false;
      int sy1=-1,sy2=-1;
      if (bindatoms.at(i).Lab1.contains("_$"))sy1=bindatoms.at(i).Lab1.section("_$",1,1).toInt(&bo);
      if (bindatoms.at(i).Lab2.contains("_$"))sy2=bindatoms.at(i).Lab2.section("_$",1,1).toInt(&bo);
      bo=false;
      if (bindatoms.at(i).Lab1.contains('_'))a1.resiNr=bindatoms.at(i).Lab1.section('_',1,1).toInt(&bo);
      if (!bo) a1.resiNr=-1;
      if (bindatoms.at(i).Lab2.contains('_'))a2.resiNr=bindatoms.at(i).Lab2.section('_',1,1).toInt(&bo);
      if (!bo)a2.resiNr=-1;
      a1.Label = bindatoms.at(i).Lab1.section('_',0,0);
      a2.Label = bindatoms.at(i).Lab2.section('_',0,0);
      //printf("#%d %d\n",a2.resiNr,a1.resiNr);
      double mindd=50.0;
      // if (qMax(sy1,sy2)>-1) 
      {
        for (int iii=0; iii<atom.size(); iii++){
          for (int jjj=0; jjj<atom.size(); jjj++){
            //	  qDebug()<<eqivMap.value(QString("$%1").arg(sy2));
            if ((a1.resiNr>-1)&& (atom.at(iii).resiNr!=a1.resiNr)) continue;
            if ((a2.resiNr>-1)&& (atom.at(jjj).resiNr!=a2.resiNr)) continue;
            if ((sy1>-1)&&(atom.at(iii).symmGroup==0)) continue;
            if ((sy2>-1)&&(atom.at(jjj).symmGroup==0)) continue;
            if ((sy1>-1)&&(eqivMap.value(QString("$%1").arg(sy1))!=atom.at(iii).symmGroup)) continue;
            if ((sy2>-1)&&(eqivMap.value(QString("$%1").arg(sy2))!=atom.at(jjj).symmGroup)) continue;
            if ((atom.at(iii).Label.section('_',0,0).section(QString::fromUtf8("»"),0,0).toUpper() == a1.Label.toUpper())&&
                (atom.at(jjj).Label.section('_',0,0).section(QString::fromUtf8("»"),0,0).toUpper() == a2.Label.toUpper())){
              bond.ato1=&atom[iii];
              bond.ato2=&atom[jjj];
              bond.a1=iii;
              bond.a2=jjj;
              bond.length=sqrt(Distance(atom[iii].pos,atom[jjj].pos));
              if ((mindd+0.01)>=bond.length) bonds.append(bond);
              mindd=qMin(bond.length, mindd);

            }
          }
        }
      }
      /*    else 
            for (int j=0; j<sdm.size(); j++){
            if ((a1.resiNr>-1)&& (asymm[sdm.at(j).a1].resiNr!=a1.resiNr)) continue;
            if ((a2.resiNr>-1)&& (asymm[sdm.at(j).a2].resiNr!=a2.resiNr)) continue;
            if ((sy1>-1)&&(atom[sdm.at(j).a1].symmGroup==0)) continue;
            if ((sy2>-1)&&(atom[sdm.at(j).a2].symmGroup==0)) continue;
            if ((sy1>-1)&&(eqivMap.value(QString("$%1").arg(sy1))!=atom[sdm.at(j).a1].symmGroup)) continue;
            if ((sy2>-1)&&(eqivMap.value(QString("$%1").arg(sy2))!=atom[sdm.at(j).a2].symmGroup)) continue;
            if ((asymm[sdm.at(j).a1].Label.section('_',0,0).toUpper() == a1.Label.toUpper())&&
            (asymm[sdm.at(j).a2].Label.section('_',0,0).toUpper() == a2.Label.toUpper())){
            bond.ato1=&atom[sdm.at(j).a1];
            bond.ato2=&atom[sdm.at(j).a2];
            bond.a1=sdm.at(j).a1;
            bond.a2=sdm.at(j).a2;
            bond.length=sqrt(Distance(atom[sdm.at(j).a1].pos,atom[sdm.at(j).a2].pos));
//bond.length=sdm.at(j).d;
//if (sdm.at(j).sn) continue;
//if (sdm.at(j).floorD==V3(0,0,0)){
if (mindd>bond.length) bonds.append(bond);
mindd=qMin(bond.length, mindd);
//}
}
}// */
for (int j=0; j < bonds.size(); j++){
  if (((bonds.at(j).ato1->Label.section('_',0,0).section(QString::fromUtf8("»"),0,0).toUpper()==a1.Label.toUpper())&&
        (bonds.at(j).ato2->Label.section('_',0,0).section(QString::fromUtf8("»"),0,0).toUpper()==a2.Label.toUpper()))||
      ((bonds.at(j).ato1->Label.section('_',0,0).section(QString::fromUtf8("»"),0,0).toUpper()==a2.Label.toUpper())&&
       (bonds.at(j).ato2->Label.section('_',0,0).section(QString::fromUtf8("»"),0,0).toUpper()==a1.Label.toUpper()))) 
    if (bonds.at(j).length>(mindd+0.1)) {
      bonds.removeAt(j);
      if (j) j--;
    }
}
}
//-->Verknopfung   !!!
knoepfe.clear();
Knopf kn;
kn.neighbors.clear();
for (int i=0; i<asymm.size(); i++){
  kn.neighbors.clear();
  for (int j=0; j<bonds.size(); j++){
    if (bonds.at(j).a1==i){
      kn.neighbors.append(bonds.at(j).a2);
    }
    if (bonds.at(j).a2==i){
      kn.neighbors.append(bonds.at(j).a1);
    }
  }
  knoepfe.append(kn);  
}

return bonds;
}

double Molecule::fl(double x,double y,double z){
  double a,b,c;
  a = (cell.ga==90.0)?0.0:2.0*x*y*cell.a*cell.b*cell.cosga;
  b = (cell.be==90.0)?0.0:2.0*x*z*cell.a*cell.c*cell.cosbe;
  c = (cell.al==90.0)?0.0:2.0*y*z*cell.b*cell.c*cell.cosal;
  double erg=sqrt(x*x*cell.a*cell.a+
      y*y*cell.b*cell.b+
      z*z*cell.c*cell.c+
      a+b+c);
  return erg;
}

double Molecule::wl(V3 p2, V3 p1, V3 p3){
  V3 f1=p2-p1;//12
  V3 f2=p3-p1;//13
  V3 f3=p3-p2;//23
  double a=0,b=0,c=0;
  a =  (cell.ga==90.0)?0.0:2.0*f1.x*f1.y*cell.a*cell.b*cell.cosga;
  a += (cell.be==90.0)?0.0:2.0*f1.x*f1.z*cell.a*cell.c*cell.cosbe;
  a += (cell.al==90.0)?0.0:2.0*f1.y*f1.z*cell.b*cell.c*cell.cosal;

  b =  (cell.ga==90.0)?0.0:2.0*f2.x*f2.y*cell.a*cell.b*cell.cosga;
  b += (cell.be==90.0)?0.0:2.0*f2.x*f2.z*cell.a*cell.c*cell.cosbe;
  b += (cell.al==90.0)?0.0:2.0*f2.y*f2.z*cell.b*cell.c*cell.cosal;

  c = ( cell.ga==90.0)?0.0:2.0*f3.x*f3.y*cell.a*cell.b*cell.cosga;
  c += (cell.be==90.0)?0.0:2.0*f3.x*f3.z*cell.a*cell.c*cell.cosbe;
  c += (cell.al==90.0)?0.0:2.0*f3.y*f3.z*cell.b*cell.c*cell.cosal;
  double d12,d13,d23;
  d12 = f1.x*f1.x*cell.a*cell.a+
    f1.y*f1.y*cell.b*cell.b+
    f1.z*f1.z*cell.c*cell.c+a;	
  d13 = f2.x*f2.x*cell.a*cell.a+
    f2.y*f2.y*cell.b*cell.b+
    f2.z*f2.z*cell.c*cell.c+b;	
  d23 = f3.x*f3.x*cell.a*cell.a+
    f3.y*f3.y*cell.b*cell.b+
    f3.z*f3.z*cell.c*cell.c+c;
  double erg=acos((d12+d13-d23)/(2.0*sqrt(d12)*sqrt(d13)))*g2r;
  return erg;
}

void Molecule::cellSetup(){
  cell.cosal=cos(cell.al/g2r);
  cell.cosbe=cos(cell.be/g2r);
  cell.cosga=cos(cell.ga/g2r);
  cell.singa=sin(cell.ga/g2r);
  cell.tanga=tan(cell.ga/g2r);
  cell.phi=  sqrt(1-(cell.cosal*cell.cosal)-
      (cell.cosbe*cell.cosbe)-(cell.cosga*cell.cosga)
      +2*cell.cosal*cell.cosbe*cell.cosga);
  cell.tau=cell.c *((cell.cosal- cell.cosbe* cell.cosga)/ cell.singa);
  cell.V = cell.a*cell.b*cell.c*cell.phi;
  cell.as=cell.c*cell.b*sin(cell.al/g2r)/cell.V;
  cell.bs=cell.c*cell.a*sin(cell.be/g2r)/cell.V;
  cell.cs=cell.a*cell.b*cell.singa/cell.V;
  cell.G.m11=cell.a*cell.a;
  cell.G.m22=cell.b*cell.b;
  cell.G.m33=cell.c*cell.c;
  cell.G.m12=cell.G.m21=cell.a*cell.b*cell.cosga;
  cell.G.m13=cell.G.m31=cell.a*cell.c*cell.cosbe;
  cell.G.m23=cell.G.m32=cell.b*cell.c*cell.cosal;
  cell.Gi=inverse(cell.G);
}

void Molecule::applyLatticeCentro(int gitter){
  /*! Adds centrings and inversion symmetry to the symmops and trans list. 
   * @param gitter the parameter of the shelx LATT instruction. ==> see Shelxl manual.
   */
  int z=cell.symmops.size();
  cell.ns0=z;
  Matrix inv(-1.0,0.0,0.0, 0.0,-1.0,0.0, 0.0,0.0,-1.0);  
  cell.centeric=false;
  if (gitter>0){ 
    for (int i=0; i<z;i++){
      Matrix m=cell.symmops.at(i)*inv;
      cell.symmops.append(m);
      cell.trans.append(cell.trans.at(i));
    }
    cell.centeric=true;
  }
  gitter=(gitter>0)?gitter:-gitter;
  z=cell.symmops.size();
  cell.centered=false;
  switch (gitter){
    case 5 :
      for (int i=0; i<z;i++){
        V3 tt = cell.trans.at(i)+V3(0.0, 0.5, 0.5);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        cell.centered=true;
      }
      break;
    case 6 :
      for (int i=0; i<z;i++){
        V3 tt = cell.trans.at(i)+V3(0.5, 0.0, 0.5);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        cell.centered=true;
      }
      break;
    case 7 :
      for (int i=0; i<z;i++){
        V3 tt = cell.trans.at(i)+V3(0.5, 0.5, 0.0);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        cell.centered=true;
      }
      break;
    case 4 :
      for (int i=0; i<z;i++){
        V3 tt = cell.trans.at(i)+V3(0.0, 0.5, 0.5);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        tt = cell.trans.at(i)+V3(0.5, 0.0, 0.5);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        tt = cell.trans.at(i)+V3(0.5, 0.5, 0.0);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        cell.centered=true;
      }
      break;
    case 2 :
      for (int i=0; i<z;i++){
        V3 tt = cell.trans.at(i)+V3(0.5, 0.5, 0.5);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        cell.centered=true;
      }
      break;
    case 3 :
      for (int i=0; i<z;i++){
        V3 tt = cell.trans.at(i)+V3(2.0/3.0, 1.0/3.0, 1.0/3.0);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        tt = cell.trans.at(i)+V3(1.0/3.0, 2.0/3.0, 2.0/3.0);
        tt.x=(tt.x>1)?tt.x-1:tt.x;
        tt.y=(tt.y>1)?tt.y-1:tt.y;
        tt.z=(tt.z>1)?tt.z-1:tt.z;
        cell.symmops.append(cell.symmops.at(i));
        cell.trans.append(tt);
        cell.centered=true;

      }
      break;
    case 0 :break;  
  }

}

double Molecule::dimension(){
  /*! calculates the maximal interatomic distance (Ang) of showatoms environment if this is 0 then 10.0 is returned instead.
  */
  double max=0,gg=0;
  for (int i=0;i<showatoms.size();i++)
    for (int j=i+1;j<showatoms.size();j++){
      if ((showatoms[j].an>=0)&&(showatoms[j].an>=0)) 
        gg=sqrt( Distance(showatoms[i].pos,showatoms[j].pos));
      max=(max<gg)?gg:max;
    }
  if (max==0) return 10.0;
  return max;
}

double Molecule::dimension(CEnvironment ce){
  /*! calculates the maximal interatomic distance (Ang) of showatoms environment if this is 0 then 10.0 is returned instead.
  */
  double max=0,gg=0;
  for (int i=0;i<ce.size();i++)
    for (int j=i+1;j<ce.size();j++){
      if ((ce[j].an>=0)&&(ce[j].an>=0)) 
        gg=sqrt( Distance(ce[i].pos,ce[j].pos));
      max=(max<gg)?gg:max;
    }
  if (max==0) return 10.0;
  return max;
}

#define Ato4d(arr)       arr[0], arr[1], arr[2], arr[3]
#include <QGLWidget>

void Molecule::atoms(CEnvironment atom,int proba){
  /*! Draws atoms as spheres or as ellipses cubes or icosahedrons.
   * @params atoms list of atoms to be drawn .
   * @params proba ellipsoid probability (currently 10 30 50 70 90 %).
   *
   * Molecule.dratom controls the wireframe style of the resulting atom .
   *
   * Molecule.tubes atom balls is drawn in bondstrength.
   *
   * Molecule.adp atom is drawn as a ellipsoid. 
   *
   * Molecule.monoQrom Q-Peaks are drawn in Color Molecule.mQolor .
   * */
  if (shaders_work&&g_program&&useShaders&&(g_Program!=NULL)) {
    Licht=1;
    g_Program->bind();
    g_Program->setUniformValue(lichtH,1);
    /*glGetUniformiv(g_program,lichtH,&Licht);
    if (!Licht) {
      int ect=0;
      GLenum err = GL_NO_ERROR;
      while((err = glGetError()) != GL_NO_ERROR)
      {
        printf("DAVOR %d %d [%d]\n",err==GL_INVALID_VALUE ,err == GL_INVALID_OPERATION,++ect); 
      }
    }*/
    shaderAtoms(atom, proba);
    g_Program->release();
    return;
  }//else{printf("%d %d %d %p\n",shaders_work,g_program,useShaders,g_Program);}
  int myAdp=adp;
  int myStyle=7;
  int pminus=0;
  int wire=0;
  GLfloat white[4]={0.2f, 0.2f, 0.3f, 0.0f};
  GLfloat black[4]={0.0f, 0.0f, 0.0f, 1.0f};
  for  (int i=0; i<atom.size();i++){
    if ((!dratom)&&(atom.at(i).hidden)) continue;
    if ((nopm1)&&(atom.at(i).symmGroup)&&(atom.at(i).part<0))continue;
    if ((dratom==2)&&(atom.at(i).part==0))continue;
    if ((dratom==2)&&(atom.at(i).symmGroup)&&(atom.at(i).part<0))continue;
    if ((dratom==2)&&(atom.at(i).hidden))continue;
    if ((dratom==5)&&(atom.at(i).hidden))continue;
    int  nonPositiveDefinite=0;
    glPushMatrix();
    nonPositiveDefinite=0;
    glTranslated(atom.at(i).pos.x,atom.at(i).pos.y,atom.at(i).pos.z);
    double rad=(atom.at(i).an==-2)?0.5:qPeakRad;
    bool parthigh=false;
    if (dratom==5){
      wire=1;
      dratom=0;
    }
    if (dratom==2) {
      dratom=0;
      parthigh=true;
    }
    if (!dratom){
      //     printf("ph %d alpha %g tubes %d,myAdp %d %d\n",parthigh,AtomColor[atom.at(i).an].alphaF(),tubes,myAdp,((!myAdp)||((myStyle&ATOM_STYLE_SPHERE)&&(!(myStyle&ATOM_STYLE_SOLID)))));
      if (atom.at(i).an>-1) {
        myStyle=AtomStyle[atom.at(i).an];
        if (atom.at(i).Label.contains("(noADP)")) myStyle|=ATOM_STYLE_NOADP;
        glColor4d(AtomColor[atom.at(i).an].redF(),
            AtomColor[atom.at(i).an].greenF(),
            AtomColor[atom.at(i).an].blueF(),
            AtomColor[atom.at(i).an].alphaF());
        rad=arad[atom.at(i).an];
        if (parthigh) {
          QColor pcolor;
          switch (atom.at(i).part){
            case 1: pcolor=QColor("lightskyblue");break;
            case 2: pcolor=QColor("darkgoldenrod");break;
            case 3: pcolor=Qt::green;break;
            case 4: pcolor=Qt::yellow;break;
            case 5: pcolor=QColor("orange");break;
            case 6: pcolor=Qt::black;break;
            case 7: pcolor=QColor("lightsalmon");break;
            case 8: pcolor=QColor("lightseagreen");break;
            case -1: pcolor=QColor("aquamarine");break;
            case -2: pcolor=QColor("olive");break;
            case -3: pcolor=QColor("bisque");break;
            case 666: pcolor=QColor("fuchsia");break;
            default: if (atom.at(i).part>0)
                       pcolor=QColor::colorNames().at(qMin(atom.at(i).part,QColor::colorNames().size()-1));
                     else pcolor=Qt::magenta;
          }
          if (atom.at(i).part==666) pcolor.setAlpha(200);
          else pcolor.setAlpha(140);
          glColor4d(pcolor.redF(),
              pcolor.greenF(),
              pcolor.blueF(),
              pcolor.alphaF());

        }

        if ((highlightEquivalents)&&(!parthigh)&&(atom.at(i).symmGroup)) {
          glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,white );
          glColor4d(qMin(1.0,(AtomColor[atom.at(i).an].redF()+0.1)   * 1.2),
              qMin(1.0,(AtomColor[atom.at(i).an].greenF()+0.1) * 1.2),
              qMin(1.0,(AtomColor[atom.at(i).an].blueF()+0.1)  * 1.2),
              1.0);
        }
        else glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,black );
        if ((atom.at(i).symmGroup)&&(atom.at(i).part<0)){
          glColor4d(AtomColor[atom.at(i).an].redF(),
              AtomColor[atom.at(i).an].greenF(),
              1.0,
              0.3);
          pminus=1;
          myStyle|=ATOM_STYLE_NOADP;
        }
        myAdp=(myStyle&ATOM_STYLE_NOADP)?0:adp;
      }
      if (wire) {myStyle|=ATOM_STYLE_SPHERE;if (myStyle&ATOM_STYLE_SOLID)myStyle-=ATOM_STYLE_SOLID; }
      if (tubes){
        rad=bondStrength;
        if (atom.at(i).part==666) rad*=4.5;
        myAdp=0;
        nonPositiveDefinite=0;
      }
      if ((atom.at(i).an<0)||(atom.at(i).Label.startsWith('Q',Qt::CaseInsensitive))){
        glColor4d(1.0 ,0.7, 0.8 ,0.4);
        if (atom.at(i).an==-66) {
          rad*=2;
          glColor4d(0.6,0.3,0.1,0.3);
          dodecaeder(rad);
        }else{
        if((atom.at(i).an==-1)&&(!monoQrom)) Farbverlauf(atom.at(i).peakHeight, pmin, pmax);
        if (monoQrom) glColor3d(mQolor.redF(),mQolor.greenF(),mQolor.blueF());
        //      if (!wire)
        icosaeder(rad);
        }
      }
      else {
        if (myAdp){
          V3 ev=V3(0,0,0);
          double *arr=jacobi(atom.at(i).uc,ev);
          if ((ev.x>0)&&(ev.y>0)&&(ev.z>0)){
            nonPositiveDefinite=0;
            glRotated(Ato4d(arr));
            double psc=(parthigh)?1.32:1.0;
            if (atom.at(i).part==666) psc*=1.2;
            switch (proba ) {
              case 10 :{ glScaled(0.76*sqrt(ev.x)*psc,0.76*sqrt(ev.y)*psc,0.76*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 10% Wahrscheinlichkeit
              case 30 :{ glScaled(1.19*sqrt(ev.x)*psc,1.19*sqrt(ev.y)*psc,1.19*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 30% Wahrscheinlichkeit
              case 50 :{ glScaled(1.54*sqrt(ev.x)*psc,1.54*sqrt(ev.y)*psc,1.54*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 50% Wahrscheinlichkeit
              case 70 :{ glScaled(1.91*sqrt(ev.x)*psc,1.91*sqrt(ev.y)*psc,1.91*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 70% Wahrscheinlichkeit
              case 90 :{ glScaled(2.50*sqrt(ev.x)*psc,2.50*sqrt(ev.y)*psc,2.50*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 90% Wahrscheinlichkeit
              default: ;
            }
          }else {nonPositiveDefinite=1;}
        }

        if (parthigh) {
          rad*=1.32;
          if (atom.at(i).part==666) rad*=1.2;
          glEnable(GL_BLEND);
          myStyle&=(ATOM_STYLE_SPHERE|ATOM_STYLE_NOADP);
          myStyle|=ATOM_STYLE_SPHERE;
        }

        /*
#define ATOM_STYLE_WALLS 1
#define ATOM_STYLE_RINGS 2
#define ATOM_STYLE_SPHERE 4
#define ATOM_STYLE_SOLID 8
#define ATOM_STYLE_WHITERING 16
#define ATOM_STYLE_NOLABEL 32
*/
        if (atom.at(i).an>-1) {
          if (myAdp&&intern) {
            if (!nonPositiveDefinite) ellipse(myStyle);
            else {
              cube(rad);
            }

          }
          else if ((!myAdp)||((myStyle&ATOM_STYLE_SPHERE)&&(!(myStyle&ATOM_STYLE_SOLID)))){
            if (!myAdp) glScaled(rad,rad,rad);
            if (!nonPositiveDefinite) {
              if (wire)dratom =5;
              sphere(myAdp|pminus);
            }
            else {
              cube(rad);
            }
          }
        }
        else
          icosaeder(rad);
      } 
    } 
    else{
      atom[i].hidden=0;
      sphere(0);
    }
    //    glEnable(GL_COLOR_MATERIAL);
    glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,black );     
    glPopMatrix();
    if (parthigh) dratom=2;
  }
}
void Molecule::pappe(){
  glEnable(GL_ALPHA_TEST);
  g_Program->setUniformValue(wallH, 1);
const GLfloat v[]={
-1.,-1., 0.,
 1.,-1., 0.,
-1., 1., 0.,

-1., 1., 0.,
 1.,-1., 0.,
 1., 1., 0.,

-1., 0.,-1.,
 1., 0.,-1.,
-1., 0., 1.,

-1., 0., 1.,
 1., 0.,-1.,
 1., 0., 1.,

 0.,-1.,-1.,
 0., 1.,-1.,
 0.,-1., 1.,

 0.,-1., 1.,
 0., 1.,-1.,
 0., 1., 1.,

 1.,-1., 0.,
-1.,-1., 0.,
-1., 1., 0.,

 1.,-1., 0.,
-1., 1., 0.,
 1., 1., 0.,

 1., 0.,-1.,
-1., 0.,-1.,
-1., 0., 1.,

 1., 0.,-1.,
-1., 0., 1.,
 1., 0., 1.,

 0., 1.,-1.,
 0.,-1.,-1.,
 0.,-1., 1.,

 0., 1.,-1.,
 0.,-1., 1.,
 0., 1., 1.,
};
const GLfloat n[]={
 0., 0., 1.,
 0., 0., 1.,
 0., 0., 1.,

 0., 0., 1.,
 0., 0., 1.,
 0., 0., 1.,

 0.,-1., 0.,
 0.,-1., 0.,
 0.,-1., 0.,

 0.,-1., 0.,
 0.,-1., 0.,
 0.,-1., 0.,

 1., 0., 0.,
 1., 0., 0.,
 1., 0., 0.,

 1., 0., 0.,
 1., 0., 0.,
 1., 0., 0.,


 0., 0.,-1.,
 0., 0.,-1.,
 0., 0.,-1.,

 0., 0.,-1.,
 0., 0.,-1.,
 0., 0.,-1.,

 0., 1., 0.,
 0., 1., 0.,
 0., 1., 0.,

 0., 1., 0.,
 0., 1., 0.,
 0., 1., 0.,

-1., 0., 0.,
-1., 0., 0.,
-1., 0., 0.,

-1., 0., 0.,
-1., 0., 0.,
-1., 0., 0.,
};
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, 0, v);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, 0, n);
  glDrawArrays(GL_TRIANGLES, 0, 36);
  glDisableClientState(GL_VERTEX_ARRAY);
  glDisableClientState(GL_NORMAL_ARRAY);
}
void Molecule::shaderAtoms(CEnvironment atom,int proba){
  /*! Draws atoms as spheres or as ellipses cubes or icosahedrons.
   * @params atoms list of atoms to be drawn .
   * @params proba ellipsoid probability (currently 10 30 50 70 90 %).
   *
   * Molecule.dratom controls the wireframe style of the resulting atom .
   *
   * Molecule.tubes atom balls is drawn in bondstrength.
   *
   * Molecule.adp atom is drawn as a ellipsoid. 
   *
   * Molecule.monoQrom Q-Peaks are drawn in Color Molecule.mQolor .
   * */
  int myAdp=adp;
  int myStyle=7;
  int pminus=0;
  int wire=0;
  //  if (!intern) return;
  Licht=1;
  g_Program->bind();
  g_Program->setUniformValue(lichtH, 1);
  //glGetUniformiv(g_program,lichtH,&Licht);
  //if (!Licht) {
  //  glUseProgram(0);
  //  return;//licht geht nicht an
  //}
  program_in_use=true;
  for  (int i=0; i<atom.size();i++){
    if ((!dratom)&&(atom.at(i).hidden)) continue;
    if ((nopm1)&&(atom.at(i).symmGroup)&&(atom.at(i).part<0))continue;
    if ((dratom==2)&&(atom.at(i).part==0))continue;
    if ((dratom==2)&&(atom.at(i).symmGroup)&&(atom.at(i).part<0))continue;
    if ((dratom==2)&&(atom.at(i).hidden))continue;
    if ((dratom==5)&&(atom.at(i).hidden))continue;
    bool  nonPositiveDefinite=false;
    glPushMatrix();
    glTranslated(atom.at(i).pos.x,atom.at(i).pos.y,atom.at(i).pos.z);
    double rad=(atom.at(i).an==-2)?0.5:qPeakRad;
    bool parthigh=false;
    if (dratom==5){
      wire=1;
      dratom=0;
    }
    if (dratom==2) {
      dratom=0;
      parthigh=true;
    }
    if (!dratom){
      if (atom.at(i).an>-1) {
        myStyle=AtomStyle[atom.at(i).an];
        if (atom.at(i).Label.contains("(noADP)")) myStyle|=ATOM_STYLE_NOADP;
        glColor4d(AtomColor[atom.at(i).an].redF(),
            AtomColor[atom.at(i).an].greenF(),
            AtomColor[atom.at(i).an].blueF(),
            1.0);//AtomColor[atom.at(i).an].alphaF());
        rad=arad[atom.at(i).an];
        if (parthigh) {
          glEnable(GL_BLEND);
          QColor pcolor;
          switch (atom.at(i).part){
            case 1: pcolor=QColor("lightskyblue");break;
            case 2: pcolor=QColor("darkgoldenrod");break;
            case 3: pcolor=Qt::green;break;
            case 4: pcolor=Qt::yellow;break;
            case 5: pcolor=QColor("orange");break;
            case 6: pcolor=Qt::black;break;
            case 7: pcolor=QColor("lightsalmon");break;
            case 8: pcolor=QColor("lightseagreen");break;
            case -1: pcolor=QColor("aquamarine");break;
            case -2: pcolor=QColor("olive");break;
            case -3: pcolor=QColor("bisque");break;
            case 666: pcolor=QColor("fuchsia");break;
            default: if (atom.at(i).part>0)
                       pcolor=QColor::colorNames().at(qMin(atom.at(i).part,QColor::colorNames().size()-1));
                     else pcolor=Qt::magenta;
          }
          if (atom.at(i).part==666) pcolor.setAlpha(100);
          else pcolor.setAlpha(90);
          glColor4d(pcolor.redF(), pcolor.greenF(), pcolor.blueF(), pcolor.alphaF());

        }

        if ((highlightEquivalents)&&(!parthigh)&&(atom.at(i).symmGroup)) {
          glColor4d(qMin(1.0,(AtomColor[atom.at(i).an].redF()+0.1)   * 1.2),
              qMin(1.0,(AtomColor[atom.at(i).an].greenF()+0.1) * 1.2),
              qMin(1.0,(AtomColor[atom.at(i).an].blueF()+0.1)  * 1.2),
              1.0);
        }
        if ((atom.at(i).symmGroup)&&(atom.at(i).part<0)){
          glColor4d(AtomColor[atom.at(i).an].redF(),
              AtomColor[atom.at(i).an].greenF(),
              1.0,
              0.3);
          pminus=1;
          myStyle|=ATOM_STYLE_NOADP;
        }
        myAdp=(myStyle&ATOM_STYLE_NOADP)?0:adp;
      }
      if (wire) {myStyle|=ATOM_STYLE_SPHERE;if (myStyle&ATOM_STYLE_SOLID)myStyle-=ATOM_STYLE_SOLID; }
      if (tubes){
        rad=bondStrength;
        if (atom.at(i).part==666) rad*=4.5;
        myAdp=0;
        nonPositiveDefinite=false;
      }
      if ((atom.at(i).an<0)||(atom.at(i).Label.startsWith('Q',Qt::CaseInsensitive))){
        glColor4d(1.0 ,0.7, 0.8 ,0.4);
        if (atom.at(i).an==-42) {//belos sit!
          rad*=0.8;
          Farbverlauf(atom.at(i).sof,lmin,lmax);
          //dodecaeder(rad);
          triacontaeder(rad);
        }
        else if (atom.at(i).an==-66) {//centroids
          rad*=2;
          glColor4d(0.6,0.3,0.1,0.3);
          dodecaeder(rad);
        }else{
        if((atom.at(i).an==-1)&&(!monoQrom)) Farbverlauf(atom.at(i).peakHeight, pmin, pmax);
        if (monoQrom) glColor3d(mQolor.redF(),mQolor.greenF(),mQolor.blueF());
        //      if (!wire)
        icosaeder(rad);
      }
      }
      else {
        if (myAdp){          
          V3 ev=V3(0,0,0);
          double *arr=jacobi(atom.at(i).uc,ev);
          if ((ev.x>0)&&(ev.y>0)&&(ev.z>0)){
            nonPositiveDefinite=false;
            glRotated(Ato4d(arr));
            double psc=(parthigh)?1.32:1.0;
            if (atom.at(i).part==666) psc*=1.2;
            switch (proba ) {
              case 10 :{ glScaled(0.76*sqrt(ev.x)*psc,0.76*sqrt(ev.y)*psc,0.76*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 10% Wahrscheinlichkeit
              case 30 :{ glScaled(1.19*sqrt(ev.x)*psc,1.19*sqrt(ev.y)*psc,1.19*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 30% Wahrscheinlichkeit
              case 50 :{ glScaled(1.54*sqrt(ev.x)*psc,1.54*sqrt(ev.y)*psc,1.54*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 50% Wahrscheinlichkeit
              case 70 :{ glScaled(1.91*sqrt(ev.x)*psc,1.91*sqrt(ev.y)*psc,1.91*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 70% Wahrscheinlichkeit
              case 90 :{ glScaled(2.50*sqrt(ev.x)*psc,2.50*sqrt(ev.y)*psc,2.50*sqrt(ev.z)*psc);break;}   //Hauptachsen der Eliipsoide 90% Wahrscheinlichkeit
              default: ;
            }
          }else {nonPositiveDefinite=true;}
        }else{
          myStyle&=(ATOM_STYLE_SPHERE|ATOM_STYLE_NOADP);
          myStyle|=ATOM_STYLE_NOADP;
        }

        if (parthigh) {
          rad*=1.32;
          if (atom.at(i).part==666) rad*=1.2;
          glEnable(GL_BLEND);
          myStyle&=(ATOM_STYLE_SPHERE|ATOM_STYLE_NOADP);
          myStyle|=ATOM_STYLE_SPHERE;
          myStyle|=ATOM_STYLE_SOLID;

        }

        /*
#define ATOM_STYLE_WALLS 1
#define ATOM_STYLE_RINGS 2
#define ATOM_STYLE_SPHERE 4
#define ATOM_STYLE_SOLID 8
#define ATOM_STYLE_WHITERING 16
#define ATOM_STYLE_NOLABEL 32
#define ATOM_STYLE_NOADP 64
*/

        /* if (i==0) printf("%s  ST %4d ball %d ring %d open %d wall %d white %d %d\n"
           ,atom.at(i).Label.toStdString().c_str()
           ,myStyle
           , ((ATOM_STYLE_SPHERE&myStyle))?1:0
           , ((ATOM_STYLE_RINGS&myStyle))?1:0
           , ((ATOM_STYLE_SOLID&myStyle))?0:1
           , ((ATOM_STYLE_WALLS&myStyle))?1:0
           , (ATOM_STYLE_WHITERING&myStyle)?1:0,qMin(LOD-1,3));// */

        int walls=((ATOM_STYLE_WALLS&myStyle))?1:0;
        if ((!wire)&&(myAdp)&&(walls)) pappe();
        if (atom.at(i).an>-1) {
          if (myAdp&&intern) {
            if (!nonPositiveDefinite) sphere(myAdp,myStyle);
            else {
              cube(rad);
            }

          }
          else if ((!myAdp)||wire||parthigh){
            if (!myAdp) glScaled(rad,rad,rad);
            if (!nonPositiveDefinite) {
              if (wire)dratom =5;
              sphere(myAdp||pminus,myStyle);
            }
            else {
              cube(rad);
            }
          }
        }
        else
          icosaeder(rad);
      } 
    } 
    else{
      atom[i].hidden=0;
      sphere(0,myStyle);
    }
    glPopMatrix();
    if (parthigh) dratom=2;
  }
  g_Program->release();
  program_in_use=false;
}

void Molecule::Farbverlauf (GLfloat wrt,GLfloat min,GLfloat max){
  if (min+0.001>=max)max+=0.002;
  GLclampd ff[4];
  int lauf=0;
  const GLclampd farbe[6][4]={{1.0,0.0,0.0,1.0},
    {1.0,1.0,0.0,1.0},
    {0.0,1.0,0.0,1.0},
    {0.0,1.0,1.0,1.0},
    {0.0,0.0,1.0,1.0},
    {1.0,0.0,1.0,1.0}};
  GLfloat nwrt=(wrt-min)/(max-min);
  nwrt=(nwrt>=1.0)?0.99999:nwrt;
  nwrt=(nwrt<=0.0)?0.00001:nwrt;
  lauf=(int (nwrt/0.2));
  nwrt-=(0.2*lauf);
  nwrt/=(0.2);

  ff[0]=(1.0-nwrt)*farbe[lauf][0]+farbe[lauf+1][0]*nwrt;
  ff[1]=(1.0-nwrt)*farbe[lauf][1]+farbe[lauf+1][1]*nwrt;
  ff[2]=(1.0-nwrt)*farbe[lauf][2]+farbe[lauf+1][2]*nwrt;
  ff[3]=1.0;

  glColor4dv(ff);
  return;
}

void Molecule::bonds(Connection bond){ 
  /*! @params bond list of bonds to be drawn
   * draws bonds as cylinders with radius Molecule.bondStrength .
   * Bonds start and stop at the atom surface.
   */ 
  if (q==NULL) {
    q= gluNewQuadric();
    //printf("%p gluNewQuadric in bonds\n",q);
  }
  gluQuadricDrawStyle(q,GLU_FILL);
  GLfloat white[4]={0.2, 0.2, 0.3, 0.0};
  GLfloat black[4]={0.0, 0.0, 0.0, 1.0};
  glDisable(GL_BLEND);
  glEnable(GL_ALPHA_TEST);
  glBindTexture(GL_TEXTURE_2D, hbtex);
  //printf("Doing Bonds adp=%d proba=%d tubes%d\n",adp,proba,tubes);
  V3 vec,bondir;
  double kurz=0,ara1,ara2;
  double wink;
  bool parthigh=false;
  double psc=1.0;
  if (dratom==2) {
    dratom=0;
    parthigh=true;
    psc=1.32;
    glEnable(GL_BLEND);
    glDisable(GL_ALPHA_TEST);
    //    glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
  }
  for (int i=0; i<bond.size();i++){
    if (bond.at(i).ato1->hidden) continue;
    if (bond.at(i).ato2->hidden) continue;
    if ((parthigh)&&((bond.at(i).ato1->part==0)||(bond.at(i).ato2->part==0))) continue;
    if ((parthigh)&&(((bond.at(i).ato1->part<0)&&(bond.at(i).ato1->symmGroup))||((bond.at(i).ato2->part<0)&&(bond.at(i).ato2->symmGroup)))) continue;
    if ((nopm1)&&(bond.at(i).ato1->symmGroup)&&(bond.at(i).ato1->part<0))continue;
    if ((nopm1)&&(bond.at(i).ato2->symmGroup)&&(bond.at(i).ato2->part<0))continue;
    if ((ATOM_STYLE_METAL&AtomStyle[bond.at(i).ato1->an])!=(ATOM_STYLE_METAL&AtomStyle[bond.at(i).ato2->an])){
      glEnable(GL_TEXTURE_2D);
    } else glDisable(GL_TEXTURE_2D);
    glColor4d(0.5,0.3,0.3,1.0);
    if (adp) {
      V3 hin=Normalize(bond.at(i).ato2->pos-bond.at(i).ato1->pos);
      double r=1;
      switch (proba){
        case 10:r=0.76;break;
        case 30:r=1.19;break;
        case 50:r=1.54;break;
        case 70:r=1.91;break;
        case 90:r=2.50;break;
      }      
      ara1=sqrt((hin*bond.at(i).ato1->uc)*hin);
      ara1*=r;
      ara2=sqrt((hin*bond.at(i).ato2->uc)*hin);
      ara2*=r;
      //      printf("%s-%s %f %f %d %f\n",bond.at(i).ato1->Label.toStdString().c_str(),bond.at(i).ato2->Label.toStdString().c_str(),ara1, ara2, proba,r);
    }
    else{
      ara1=arad[bond.at(i).ato1->an];
      ara2=arad[bond.at(i).ato2->an];
    }
    if (((bond.at(i).ato1->symmGroup)&&(bond.at(i).ato1->part<0))||
        (ATOM_STYLE_NOADP&AtomStyle[bond.at(i).ato1->an])) ara1=arad[bond.at(i).ato1->an];
    if (((bond.at(i).ato2->symmGroup)&&(bond.at(i).ato2->part<0))||
        (ATOM_STYLE_NOADP&AtomStyle[bond.at(i).ato2->an])) ara2=arad[bond.at(i).ato2->an];
    if (tubes) ara1=ara2=bondStrength;
    if (bond.at(i).ato2->an>-1) {
      glColor4d(AtomColor[bond.at(i).ato2->an].redF(),
          AtomColor[bond.at(i).ato2->an].greenF(),
          AtomColor[bond.at(i).ato2->an].blueF(),
          AtomColor[bond.at(i).ato2->an].alphaF());

    }

    ara1=qMax(ara1,bondStrength);
    ara2=qMax(ara2,bondStrength);

    if ((highlightEquivalents)&&(bond.at(i).ato2->symmGroup|bond.at(i).ato1->symmGroup))
      glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,white );
    else glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,black );
    if ((bond.at(i).ato2->symmGroup|bond.at(i).ato1->symmGroup)&&((bond.at(i).ato2->part<0)||(bond.at(i).ato1->part<0))){
      //		    glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,blue );
      glColor4d(AtomColor[bond.at(i).ato2->an].redF(),
          AtomColor[bond.at(i).ato2->an].greenF(),
          1.0,
          0.3);
      glEnable(GL_BLEND);
    }
    vec.x=(bond.at(i).ato2->pos.y-bond.at(i).ato1->pos.y);
    vec.y=(bond.at(i).ato1->pos.x-bond.at(i).ato2->pos.x);
    vec.z=0;
    if (Norm(vec)) vec=Normalize(vec);
    else vec=V3(0,1,0);
    bondir =V3(0,0,0);
    if (bondStrength<ara2)
      bondir= Normalize(bond.at(i).ato1->pos-bond.at(i).ato2->pos)*(0.9*sqrt((ara2*ara2)-bondStrength*bondStrength));
    kurz=sqrt(Norm(bondir));//  */
    //printf("%s--%s kurz %f len %f ara2 %f\n",bond.at(i).ato1->Label.toStdString().c_str(),bond.at(i).ato2->Label.toStdString().c_str(),kurz,bond.at(i).length,ara2);
    glPushMatrix();
    //    glTranslated (mitsav.x,mitsav.y,mitsav.z);
    glTranslated (
        bond.at(i).ato2->pos.x+bondir.x,
        bond.at(i).ato2->pos.y+bondir.y,
        bond.at(i).ato2->pos.z+bondir.z);//Anfangspunkt
    wink=acos(((bond.at(i).ato1->pos.z-bond.at(i).ato2->pos.z)/
          (sqrt((bond.at(i).ato1->pos.x-bond.at(i).ato2->pos.x)*(bond.at(i).ato1->pos.x-bond.at(i).ato2->pos.x)+
                (bond.at(i).ato1->pos.y-bond.at(i).ato2->pos.y)*(bond.at(i).ato1->pos.y-bond.at(i).ato2->pos.y)+
                (bond.at(i).ato1->pos.z-bond.at(i).ato2->pos.z)*(bond.at(i).ato1->pos.z-bond.at(i).ato2->pos.z)))))/M_PI*180.0;

    glRotated(wink,vec.x,vec.y,vec.z); // drehen
    gluQuadricNormals(q, GL_SMOOTH);   // ein Zylinder
    gluQuadricTexture(q,GL_TRUE);
    if (parthigh) {
      glEnable(GL_BLEND);
      QColor pcolor;
      switch (bond.at(i).ato1->part){
        case 1: pcolor=QColor("lightskyblue");break;
        case 2: pcolor=QColor("darkgoldenrod");break;
        case 3: pcolor=Qt::green;break;
        case 4: pcolor=Qt::yellow;break;
        case 5: pcolor=QColor("orange");break;
        case 6: pcolor=Qt::black;break;
        case 7: pcolor=QColor("lightsalmon");break;
        case 8: pcolor=QColor("lightseagreen");break;
        case -1: pcolor=QColor("aquamarine");break;
        case -2: pcolor=QColor("olive");break;
        case -3: pcolor=QColor("bisque");break;
        case 666: pcolor=QColor("fuchsia");break;
        default: if (bond.at(i).ato1->part>0)
                   pcolor=QColor::colorNames().at(qMin(bond.at(i).ato1->part,QColor::colorNames().size()-1));
                 else pcolor=Qt::magenta;
      }
      pcolor.setAlpha(140);
      glColor4d(pcolor.redF(),
          pcolor.greenF(),
          pcolor.blueF(),
          pcolor.alphaF());

    }
    //if (trans) {glEnable(GL_BLEND);glEnable(GL_CULL_FACE);}
    gluCylinder(q, bondStrength*psc, bondStrength*psc, (float)(bond.at(i).length /2.0f -kurz), 5*LOD, 1);
    //if (trans) {glDisable(GL_BLEND);glDisable(GL_CULL_FACE);}
    glPopMatrix();

    if (bond.at(i).ato1->an>-1){ 
      glColor4d(AtomColor[bond.at(i).ato1->an].redF(),
          AtomColor[bond.at(i).ato1->an].greenF(),
          AtomColor[bond.at(i).ato1->an].blueF(),
          AtomColor[bond.at(i).ato1->an].alphaF());

    }
    if ((bond.at(i).ato2->symmGroup|bond.at(i).ato1->symmGroup)&&((bond.at(i).ato2->part<0)||(bond.at(i).ato1->part<0))){
      //		    glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION,blue );
      glColor4d(AtomColor[bond.at(i).ato1->an].redF(),
          AtomColor[bond.at(i).ato1->an].greenF(),
          1.0,
          0.3);
      glEnable(GL_BLEND);
    }

    vec.x=(bond.at(i).ato1->pos.y-bond.at(i).ato2->pos.y);
    vec.y=(bond.at(i).ato2->pos.x-bond.at(i).ato1->pos.x);
    vec.z=0;
    if (Norm(vec)) vec=Normalize(vec);
    else vec=V3(0,1,0);

    bondir =V3(0,0,0);
    if (bondStrength<ara1)
      bondir= Normalize(bond.at(i).ato2->pos-bond.at(i).ato1->pos)*(0.9*sqrt((ara1*ara1)-bondStrength*bondStrength));
    kurz=sqrt(Norm(bondir));// */
    glPushMatrix();
    //    glTranslated (mitsav.x,mitsav.y,mitsav.z);
    glTranslated (
        bond.at(i).ato1->pos.x+bondir.x,
        bond.at(i).ato1->pos.y+bondir.y,
        bond.at(i).ato1->pos.z+bondir.z);//Anfangspunkt
    wink=acos(((bond.at(i).ato2->pos.z-bond.at(i).ato1->pos.z)/
          (sqrt((bond.at(i).ato2->pos.x-bond.at(i).ato1->pos.x)*(bond.at(i).ato2->pos.x-bond.at(i).ato1->pos.x)+
                (bond.at(i).ato2->pos.y-bond.at(i).ato1->pos.y)*(bond.at(i).ato2->pos.y-bond.at(i).ato1->pos.y)+
                (bond.at(i).ato2->pos.z-bond.at(i).ato1->pos.z)*(bond.at(i).ato2->pos.z-bond.at(i).ato1->pos.z)))))/M_PI*180.0;
    glRotated(wink,vec.x,vec.y,vec.z); // drehen
    gluQuadricNormals(q, GL_SMOOTH);   // ein Zylinder
    gluQuadricTexture(q,GL_TRUE);
    //if (trans) {glEnable(GL_BLEND);glEnable(GL_CULL_FACE);}
    if (parthigh) {
      glEnable(GL_BLEND);
      QColor pcolor;
      switch (bond.at(i).ato2->part){
        case 1: pcolor=QColor("lightskyblue");break;
        case 2: pcolor=QColor("darkgoldenrod");break;
        case 3: pcolor=Qt::green;break;
        case 4: pcolor=Qt::yellow;break;
        case 5: pcolor=QColor("orange");break;
        case 6: pcolor=Qt::black;break;
        case 7: pcolor=QColor("lightsalmon");break;
        case 8: pcolor=QColor("lightseagreen");break;
        case -1: pcolor=QColor("aquamarine");break;
        case -2: pcolor=QColor("olive");break;
        case -3: pcolor=QColor("bisque");break;
        case 666: pcolor=QColor("fuchsia");break;
        default: if (bond.at(i).ato2->part>0)
                   pcolor=QColor::colorNames().at(qMin(bond.at(i).ato2->part,QColor::colorNames().size()-1));
                 else pcolor=Qt::magenta;
      }
      pcolor.setAlpha(140);
      glColor4d(pcolor.redF(),
          pcolor.greenF(),
          pcolor.blueF(),
          pcolor.alphaF());

    }
    gluCylinder(q, bondStrength*psc, bondStrength*psc, (float)bond.at(i).length/2.0f-kurz, 5*LOD, 1);

    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glPopMatrix();
  }

}

QString Molecule::h_bonds(Connection bond,CEnvironment atoms) {
  /*! calculates Hydrogen bonds and draws them as stippled cylinders 
   * \returns a html table of the found H-bonds
   */

  if (q==NULL) {
    q= gluNewQuadric();
    //printf("%p gluNewQuadric in h_bonds\n",q);
  }
  gluQuadricDrawStyle(q,GLU_FILL);
  glDisable(GL_CULL_FACE);
  if (HAMax<0.01)return "";
  glEnable(GL_ALPHA_TEST);
  glBindTexture(GL_TEXTURE_2D, hbtex);
  glEnable(GL_TEXTURE_2D);
  QString hbonds;
  double gg=0,kk=0,ll=0;
  double kurz=0,ara1,ara2;
  float wink,hb_wink;
  V3 vec,bondir;
  const MyAtom *Hyd,*Acc,*Don;//Wasserstoff Akzeptor und Donor
  hbonds.append("<h2>Hydrogen Bonds</h2><table border=1><tr><th>Donor---Hydrogen...Acceptor</th><th>Don--Hyd [&Aring;]</th><th> Hyd--Acc [&Aring;]</th><th>Don--Acc [&Aring;]</th><th>D--H-----A </th></tr>");
  for (int i=0;i<bond.size();i++) {
    if (((bond.at(i).ato1->an == 0)&&
          (bond.at(i).ato2->an >  5)&&
          (bond.at(i).ato2->an <  9))||
        ((bond.at(i).ato2->an == 0)&&
         (bond.at(i).ato1->an >  5)&&
         (bond.at(i).ato1->an <  9))) {
      Hyd=(bond.at(i).ato1->an==0)?bond.at(i).ato1:bond.at(i).ato2;
      Don=(bond.at(i).ato1->an==0)?bond.at(i).ato2:bond.at(i).ato1;
      for (int j=0; j<atoms.size();j++){
        if ((atoms.at(j).an<6)||(atoms.at(j).an>8)) continue;
        if ((Don->part!=0)&&(atoms.at(j).part!=Don->part)) continue;
        if ((Hyd->part!=0)&&(atoms.at(j).part!=Hyd->part)) continue;

        //printf("%d %d %d\n",bond.at(i).ato1->an,bond.at(i).ato2->an,atoms.at(j).an);
        Acc=&atoms.at(j);
        if (Acc==Don) continue;
        gg=sqrt( Distance(Hyd->pos,atoms.at(j).pos));


        if (gg<=HAMax){
          hb_wink=winkel(Acc->pos-Hyd->pos, Don->pos-Hyd->pos);
          /* printf("%s %s %s %f %f\n",bond.at(i).ato1->Label.toStdString().c_str(),
             bond.at(i).ato2->Label.toStdString().c_str(),
             atoms.at(j).Label.toStdString().c_str(),gg,hb_wink);*/
          if ((gg>=1.3)&&(fabs(hb_wink)>HAWink)) {//wenn AbstandRichtig
            ll=sqrt(Distance(Acc->pos,Don->pos));
            kk=sqrt(Distance(Don->pos,Hyd->pos));
            hbonds.append(QString("<tr><td>%1---%2...%3</td><td>%4</td><td>%5</td><td>%6</td><td>%7&deg;</td></tr>")
                .arg(Don->Label)
                .arg(Hyd->Label)
                .arg(Acc->Label)
                .arg(kk,6,'f',2)
                .arg(gg,6,'f',2)
                .arg(ll,6,'f',3)
                .arg(hb_wink,5,'f',1));
            glPushMatrix();
            ara1=arad[0];
            ara2=arad[Acc->an];
            if (adp) {
              V3 hin=Normalize(bond.at(i).ato2->pos-bond.at(i).ato1->pos);
              double r=1;
              switch (proba){
                case 10:r=0.76;break;
                case 30:r=1.19;break;
                case 50:r=1.54;break;
                case 70:r=1.91;break;
                case 90:r=2.50;break;
              }      
              ara1=sqrt((hin*bond.at(i).ato1->uc)*hin);
              ara1*=r;
              ara2=sqrt((hin*bond.at(i).ato2->uc)*hin);
              ara2*=r;
              //      printf("%s-%s %f %f %d %f\n",bond.at(i).ato1->Label.toStdString().c_str(),bond.at(i).ato2->Label.toStdString().c_str(),ara1, ara2, proba,r);
            }
            if (ATOM_STYLE_NOADP&AtomStyle[bond.at(i).ato1->an])ara1=arad[0];
            if (ATOM_STYLE_NOADP&AtomStyle[bond.at(i).ato2->an])ara2=arad[Acc->an];
            if (tubes) ara1=ara2=bondStrength;
            bondir =V3(0,0,0);
            if (bondStrength<ara2)
              bondir= Normalize(Hyd->pos-Acc->pos)*(1.2*sqrt((ara2*ara2)-bondStrength*bondStrength));
            if (bondStrength<ara1)
              kurz=(1.2*sqrt((ara1*ara1)-bondStrength*bondStrength)+1.2*sqrt(ara2*ara2)-bondStrength*bondStrength);//  */
            else kurz=0;
            glTranslated(Acc->pos.x+bondir.x,Acc->pos.y+bondir.y,Acc->pos.z+bondir.z);//z
            vec=kreuzX(Hyd->pos.x-Acc->pos.x,
                Hyd->pos.y-Acc->pos.y,
                Hyd->pos.z-Acc->pos.z,
                0.0f,0.0f,1.0f);
            wink=acos(((Hyd->pos.z-Acc->pos.z)/
                  (sqrt((Acc->pos.x-Hyd->pos.x)*(Acc->pos.x-Hyd->pos.x)+
                        (Acc->pos.y-Hyd->pos.y)*(Acc->pos.y-Hyd->pos.y)+
                        (Acc->pos.z-Hyd->pos.z)*(Acc->pos.z-Hyd->pos.z)))))/M_PI*180.0;
            //printf("%f %f %f %f\n",wink, vec.x, vec.y, vec.z);
            glRotatef(wink, vec.x, vec.y, vec.z); // drehen
            gluQuadricNormals(q, GL_SMOOTH);   // ein Zylinder
            //if (!adp)
            if (gg>2.0) glColor4f(1,0.6,0,1);	else glColor4f(1,1,0,1);
            gluQuadricTexture(q,GL_TRUE);
            gluCylinder(q,bondStrength*0.85 , bondStrength*0.85, (float)gg-kurz, 5*LOD, 1);

            glPopMatrix();
          }
        }
      }
    }
  }
  //glDisable( GL_BLEND);
  glDisable(GL_ALPHA_TEST);

  glDisable(GL_TEXTURE_2D);
  glEnable(   GL_CULL_FACE);
  if (hbonds.contains("deg;")) hbonds.append("</table><br>");
  else hbonds.clear();
  return hbonds;
}

void Molecule::h_bonds2(Connection bond,CEnvironment atoms) {
  /*! calculates Hydrogen bonds and draws them as stippled cylinders 
  */
  gluQuadricNormals(q, GL_SMOOTH);   
  gluQuadricTexture(q,GL_TRUE);
  gluQuadricDrawStyle(q,GLU_FILL);
  glDisable(GL_CULL_FACE);
  if (HAMax<0.01)return ;
  glEnable(GL_ALPHA_TEST);
  glBindTexture(GL_TEXTURE_2D, hbtex);
  glEnable(GL_TEXTURE_2D);
  double gg=0;//,kk=0,ll=0;
  double kurz=0,ara1,ara2;
  float wink,hb_wink;
  V3 vec,bondir;
  const MyAtom *Hyd,*Acc,*Don;//Wasserstoff Akzeptor und Donor
  for (int i=0;i<bond.size();i++) {
    if (((bond.at(i).ato1->an == 0)&&
          (bond.at(i).ato2->an >  5)&&
          (bond.at(i).ato2->an <  9))||
        ((bond.at(i).ato2->an == 0)&&
         (bond.at(i).ato1->an >  5)&&
         (bond.at(i).ato1->an <  9))) {
      Hyd=(bond.at(i).ato1->an==0)?bond.at(i).ato1:bond.at(i).ato2;
      Don=(bond.at(i).ato1->an==0)?bond.at(i).ato2:bond.at(i).ato1;
      for (int j=0; j<atoms.size();j++){
        if ((atoms.at(j).an<6)||(atoms.at(j).an>8)) continue;
        if ((Don->part!=0)&&(atoms.at(j).part!=Don->part)) continue;
        if ((Hyd->part!=0)&&(atoms.at(j).part!=Hyd->part)) continue;

        //printf("%d %d %d\n",bond.at(i).ato1->an,bond.at(i).ato2->an,atoms.at(j).an);
        Acc=&atoms.at(j);
        if (Acc==Don) continue;
        gg=sqrt( Distance(Hyd->pos,atoms.at(j).pos));


        if (gg<=HAMax){
          hb_wink=winkel(Acc->pos-Hyd->pos, Don->pos-Hyd->pos);
          /* printf("%s %s %s %f %f\n",bond.at(i).ato1->Label.toStdString().c_str(),
             bond.at(i).ato2->Label.toStdString().c_str(),
             atoms.at(j).Label.toStdString().c_str(),gg,hb_wink);*/
          if ((gg>=1.3)&&(fabs(hb_wink)>HAWink)) {//wenn AbstandRichtig
            //ll=sqrt(Distance(Acc->pos,Don->pos));
            //kk=sqrt(Distance(Don->pos,Hyd->pos));
            glPushMatrix();
            ara1=arad[0];
            ara2=arad[Acc->an];
            if (adp) {
              V3 hin=Normalize(bond.at(i).ato2->pos-bond.at(i).ato1->pos);
              double r=1;
              switch (proba){
                case 10:r=0.76;break;
                case 30:r=1.19;break;
                case 50:r=1.54;break;
                case 70:r=1.91;break;
                case 90:r=2.50;break;
              }      
              ara1=sqrt((hin*bond.at(i).ato1->uc)*hin);
              ara1*=r;
              ara2=sqrt((hin*bond.at(i).ato2->uc)*hin);
              ara2*=r;
              //      printf("%s-%s %f %f %d %f\n",bond.at(i).ato1->Label.toStdString().c_str(),bond.at(i).ato2->Label.toStdString().c_str(),ara1, ara2, proba,r);
            }
            if (ATOM_STYLE_NOADP&AtomStyle[bond.at(i).ato1->an])ara1=arad[0];
            if (ATOM_STYLE_NOADP&AtomStyle[bond.at(i).ato2->an])ara2=arad[Acc->an];
            if (tubes) ara1=ara2=bondStrength;
            bondir =V3(0,0,0);
            if (bondStrength<ara2)
              bondir= Normalize(Hyd->pos-Acc->pos)*(1.2*sqrt((ara2*ara2)-bondStrength*bondStrength));
            if (bondStrength<ara1)
              kurz=(1.2*sqrt((ara1*ara1)-bondStrength*bondStrength)+1.2*sqrt(ara2*ara2)-bondStrength*bondStrength);//  */
            else kurz=0;
            glTranslated(Acc->pos.x+bondir.x,Acc->pos.y+bondir.y,Acc->pos.z+bondir.z);//z
            vec=kreuzX(Hyd->pos.x-Acc->pos.x,
                Hyd->pos.y-Acc->pos.y,
                Hyd->pos.z-Acc->pos.z,
                0.0f,0.0f,1.0f);
            wink=acos(((Hyd->pos.z-Acc->pos.z)/
                  (sqrt((Acc->pos.x-Hyd->pos.x)*(Acc->pos.x-Hyd->pos.x)+
                        (Acc->pos.y-Hyd->pos.y)*(Acc->pos.y-Hyd->pos.y)+
                        (Acc->pos.z-Hyd->pos.z)*(Acc->pos.z-Hyd->pos.z)))))/M_PI*180.0;
            //printf("%f %f %f %f\n",wink, vec.x, vec.y, vec.z);
            glRotatef(wink, vec.x, vec.y, vec.z); // drehen
            //if (!adp)
            if (gg>2.0) glColor4f(1,0.6,0,1);	else glColor4f(1,1,0,1);
            gluCylinder(q,bondStrength*0.85 , bondStrength*0.85, (float)gg-kurz, 5*LOD, 1);

            glPopMatrix();
          }
        }
      }
    }
  }
  //glDisable( GL_BLEND);
  glDisable(GL_ALPHA_TEST);

  glDisable(GL_TEXTURE_2D);
  glEnable(   GL_CULL_FACE);
}
void Molecule::hirsh(Connection bond){
  return;
  V3 hin;
  //  double zab,zba;
  for (int i=0; i<bond.size();i++){
    hin=Normalize(bond.at(i).ato2->pos-bond.at(i).ato1->pos);
    //    zab=(hin*bond.at(i).ato1->uc)*hin; 
    //    zba=(hin*bond.at(i).ato2->uc)*hin; 
    /*    printf("%-9s = %-9s zab %g zba %g  %g\n",
          bond.at(i).ato1->Label.toStdString().c_str(),
          bond.at(i).ato2->Label.toStdString().c_str(),
          zab,zba,fabs(zab-zba)*1000);*/
  }
}

void Molecule::lbond(){
  /*! draws line bonds from lbonds list. 
  */

  glPushMatrix();
  glEnable(GL_BLEND);
  glDisable(GL_LIGHTING);
  glBegin(GL_LINES);
  glColor3f(0.5,0.3,0.3);
  for (int i=0; i<lbonds.size();i++)
    if (lbonds.at(i).ato1->hidden+lbonds.at(i).ato2->hidden==0){
      glVertex3d(lbonds.at(i).ato1->pos.x,lbonds.at(i).ato1->pos.y,lbonds.at(i).ato1->pos.z);
      glVertex3d(lbonds.at(i).ato2->pos.x,lbonds.at(i).ato2->pos.y,lbonds.at(i).ato2->pos.z);
    }
  glEnd();
  glEnable(GL_LIGHTING);    
  glDisable(GL_BLEND);
  glPopMatrix();

}

void Molecule::dbond(Connection bond){
  /*! draws line bonds from bond list .
  */

  glPushMatrix();
  glEnable(GL_BLEND);
  glDisable(GL_LIGHTING);
  glBegin(GL_LINES);
  glLineWidth(3);
  glColor3f(0.0,0.0,0.0);
  for (int i=0; i<bond.size();i++)
    if (bond.at(i).ato1->hidden+bond.at(i).ato2->hidden==0){
      glVertex3d(bond.at(i).ato1->pos.x,bond.at(i).ato1->pos.y,bond.at(i).ato1->pos.z);
      glVertex3d(bond.at(i).ato2->pos.x,bond.at(i).ato2->pos.y,bond.at(i).ato2->pos.z);
    }
  glEnd();
  glEnable(GL_LIGHTING);    
  glDisable(GL_BLEND);
  glPopMatrix();

}
void Molecule::unitCell(){
  /*!draws a unit cell box
   *
   * */
  V3 uz0f,uz1f,uz2f,uz3f,uz4f,uz5f,uz6f,uz7f;
  V3 uz0k,uz1k,uz2k,uz3k,uz4k,uz5k,uz6k,uz7k;
  uz0f.x=0.0;  uz0f.y=0.0;  uz0f.z=0.0;
  uz1f.x=1.0;  uz1f.y=0.0;  uz1f.z=0.0;
  uz2f.x=0.0;  uz2f.y=1.0;  uz2f.z=0.0;
  uz3f.x=0.0;  uz3f.y=0.0;  uz3f.z=1.0;
  uz4f.x=1.0;  uz4f.y=1.0;  uz4f.z=0.0;
  uz5f.x=1.0;  uz5f.y=0.0;  uz5f.z=1.0;
  uz6f.x=0.0;  uz6f.y=1.0;  uz6f.z=1.0;
  uz7f.x=1.0;  uz7f.y=1.0;  uz7f.z=1.0;
  frac2kart(uz0f,uz0k);
  frac2kart(uz1f,uz1k);
  frac2kart(uz2f,uz2k);
  frac2kart(uz3f,uz3k);
  frac2kart(uz4f,uz4k);
  frac2kart(uz5f,uz5k);
  frac2kart(uz6f,uz6k);
  frac2kart(uz7f,uz7k);
  glEnable(GL_BLEND);
  glDisable(GL_LIGHTING);
  glLineWidth(2);
  glPushMatrix();
  glBegin(GL_LINES);
  glColor4f(1.0f,0.0f,0.0f,1.0);
  glVertex3d(uz0k.x,uz0k.y,uz0k.z);
  glVertex3d(uz1k.x,uz1k.y,uz1k.z);

  glColor4f(0.0f,1.0f,0.0f,1.0);
  glVertex3d(uz0k.x,uz0k.y,uz0k.z);
  glVertex3d(uz2k.x,uz2k.y,uz2k.z);

  glColor4f(0.0f,0.0f,1.0f,1.0);
  glVertex3d(uz0k.x,uz0k.y,uz0k.z);
  glVertex3d(uz3k.x,uz3k.y,uz3k.z);

  glColor4f(0.6f,0.6f,0.8f,1.0);
  glVertex3d(uz1k.x,uz1k.y,uz1k.z);
  glVertex3d(uz4k.x,uz4k.y,uz4k.z);

  glVertex3d(uz1k.x,uz1k.y,uz1k.z);
  glVertex3d(uz5k.x,uz5k.y,uz5k.z);

  glVertex3d(uz2k.x,uz2k.y,uz2k.z);
  glVertex3d(uz4k.x,uz4k.y,uz4k.z);

  glVertex3d(uz2k.x,uz2k.y,uz2k.z);
  glVertex3d(uz6k.x,uz6k.y,uz6k.z);

  glVertex3d(uz3k.x,uz3k.y,uz3k.z);
  glVertex3d(uz5k.x,uz5k.y,uz5k.z);

  glVertex3d(uz3k.x,uz3k.y,uz3k.z);
  glVertex3d(uz6k.x,uz6k.y,uz6k.z);

  glVertex3d(uz7k.x,uz7k.y,uz7k.z);
  glVertex3d(uz5k.x,uz5k.y,uz5k.z);

  glVertex3d(uz7k.x,uz7k.y,uz7k.z);
  glVertex3d(uz4k.x,uz4k.y,uz4k.z);

  glVertex3d(uz7k.x,uz7k.y,uz7k.z);
  glVertex3d(uz6k.x,uz6k.y,uz6k.z);

  glEnd();
  glPopMatrix();
  glLineWidth(1);
  glEnable(GL_LIGHTING);  
  glDisable(GL_BLEND);
}

void Molecule::Uf2Uo(const Matrix x, Matrix & y) {
  /*! Turns fractional Uij's into cartesinan based Uij's.
   * @param[in] x fractional Uij matrix.
   * @param[out] y cartesinan Uij matrix.
   */
  Matrix o,a,w;   /*Cholesky decomposition of the real space Metric tensor
                    Wird fr die Umrechnung von fraktionellen in kartesischen Korrdinaten bentigt.*/
  a.m11 =cell.as;
  a.m12 = 0;
  a.m13 = 0;
  a.m21 = 0;
  a.m22 = cell.bs;
  a.m23 = 0;
  a.m31 = 0;
  a.m32 = 0;
  a.m33 = cell.cs;
  w=(a*x)*a;
  o.m11 =cell.a;
  o.m12 = 0.0;
  o.m13 = 0.0;
  o.m21 = cell.b*cell.cosga;
  o.m22 = cell.b*cell.singa;
  o.m23 = 0.0;
  o.m31 = cell.c* cell.cosbe;
  o.m32 = cell.tau;
  o.m33 = cell.c* cell.phi / cell.singa ;
  //  Matrix to=;
  y=(o*w)*transponse(o);
  /*  printf("%f %f %f %f %f %f %f %f %f\n%f %f %f %f %f %f %f %f %f\n%f %f %f %f %f %f %f %f %f\n%f %f %f %f %f %f %f %f %f\n",
      o.m11,o.m12,o.m13,o.m21,o.m22,o.m23,o.m31,o.m32,o.m33,
      to.m11,to.m21,to.m31,to.m12,to.m22,to.m32,to.m13,to.m23,to.m33,  
      x.m11,x.m12,x.m13,x.m21,x.m22,x.m23,x.m31,x.m32,x.m33,
      w.m11,w.m12,w.m13,w.m21,w.m22,w.m23,w.m31,w.m32,w.m33
      );*/
  //  printf("%f %f %f %f %f %f\n",y.m11*10000,y.m22*10000,y.m33*10000,y.m12*10000,y.m13*10000,y.m23*10000);//		  */
}

void Molecule::Usym (Matrix x,Matrix sym, Matrix & y){
  /*! Applies the symmetry matrix sym to Uij's 
   * @param[in] x Uij matrix.
   * @param[in] sym symmtry matrix.
   * @param[out] y resulting Uij matrix. 
   */
  //y=(transponse(sym)*x)*sym;
  y=(sym*x)*transponse(sym);
}
//void Molecule::

#define ROTATE(a,i,j,k,l) g=a[i][j];h=a[k][l];a[i][j]=g-s*(h+g*tau); a[k][l]=h+s*(g-h*tau);
//NumericalRecepies....
double * Molecule::jacobi(const Matrix &uij, V3 &ev) { 

  int j,iq,ip,i,n=3,nrot; 
  double tresh=0,theta,tau,t,sm,s,h,g,c; 
  double a[3][3],b[3],z[3],v[3][3],d[3];
  a[0][0]=uij.m11;
  a[0][1]=uij.m12;
  a[0][2]=uij.m13;
  a[1][0]=uij.m21;
  a[1][1]=uij.m22;
  a[1][2]=uij.m23;
  a[2][0]=uij.m31;
  a[2][1]=uij.m32;
  a[2][2]=uij.m33;
  static double erg[4]={0.0,1.0,0.0,0.0};
  for (ip=1;ip<=n;ip++) {   
    for (iq=1;iq<=n;iq++) v[ip-1][iq-1]=0.0; 
    v[ip-1][ip-1]=1.0; 
  } 
  for (ip=1;ip<=n;ip++) {  
    b[ip-1]=d[ip-1]=a[ip-1][ip-1]; 
    z[ip-1]=0.0; 
  } 
  nrot=0; 
  for (i=1;i<=150;i++) {
    sm=0.0; 
    for (ip=1;ip<=n-1;ip++) { 
      for (iq=ip+1;iq<=n;iq++) 
        sm += fabs(a[ip-1][iq-1]);       
    } 

    //printf("sm =%20.19f\n",sm);

    if (float(sm) < tresh) { 
      if ((v[0][0]+v[1][1]+v[2][2])!=3.0) {
        erg[0]=acos((v[0][0]+v[1][1]+v[2][2]-1.0)/2.0);
        erg[1]=(v[2][1]-v[1][2])/(2.0*sin(erg[0]));
        erg[2]=(v[0][2]-v[2][0])/(2.0*sin(erg[0]));
        erg[3]=(v[1][0]-v[0][1])/(2.0*sin(erg[0]));
        erg[0]*=180.0/M_PI;}
      else {erg[0]=0.0;erg[1]=1.0;erg[2]=0.0;erg[3]=0.0; }
      //printf("%d??ERG:%f %f %f %f\n",i,Ato4d(erg));
      /*
         printf("=%d======================================\n%8.5f %8.5f %8.5f \n%8.5f %8.5f %8.5f \n%8.5f %8.5f %8.5f \n%8.5f %8.5f %8.5f\n========================================\n",i,
         d[0],d[1],d[2],v[0][0],v[0][1],v[0][2]
         ,v[1][0],v[1][1],v[1][2]
         ,v[2][0],v[2][1],v[2][2]
         );*/
      ev=V3(d[0],d[1],d[2]);
      return (double*) erg;
    }
    if (i < 4) tresh=0.00001;  
    else tresh=0.0001;
    for (ip=1;ip<=n-1;ip++) { 
      for (iq=ip+1;iq<=n;iq++) { 
        //printf("\np:%i q:%i i:%i nrot:%i\n",ip,iq,i,nrot);
        g=100.0*fabs(a[ip-1][iq-1]);  
        if ((i > 4) && ((fabs(d[ip-1])+g) == fabs(d[ip-1])) && ((fabs(d[iq-1])+g) == fabs(d[iq-1]))) {a[ip-1][iq-1]=0.0;}
        else if (fabs(a[ip-1][iq-1]) >= tresh) { 
          h=d[iq-1]-d[ip-1]; 
          if ((fabs(h)+g) == fabs(h)) {t=(a[ip-1][iq-1])/h; } 
          else { theta=0.5*h/(a[ip-1][iq-1]);  
            t=1.0/(fabs(theta)+sqrt(1.0+theta*theta)); 
            if (theta < 0.0) {t = -1.0*t;}
          } 
          c=1.0/sqrt(1+t*t); 
          s=t*c; 
          tau=s/(1.0+c); 
          h=t*a[ip-1][iq-1];
          z[ip-1] -= h;
          z[iq-1] += h;
          d[ip-1] -= h;
          d[iq-1] += h;
          a[ip-1][iq-1]=0.0;
          for (j=1;j<=ip-1;j++) { 
            ROTATE(a,j-1,ip-1,j-1,iq-1)
              //printf("%i %i %i %i",j,ip,j,iq);
          } 
          for (j=ip+1;j<=iq-1;j++) { 
            ROTATE(a,ip-1,j-1,j-1,iq-1)
              //printf("%i %i %i %i ",ip,j,j,iq);
          } 
          for (j=iq+1;j<=n;j++) {  
            ROTATE(a,ip-1,j-1,iq-1,j-1)
              //printf("%i %i %i %i",ip,j,iq,j);
          } 
          for (j=1;j<=n;j++) { 
            ROTATE(v,j-1,ip-1,j-1,iq-1)
          } 
          ++(nrot);	  
          //    printf("U|\n%f %f %f  \n%f %f %f\n%f %f %f\nV|\n%f %f %f  \n%f %f %f\n%f %f %f\n\n",a[0][0],a[1][0],a[2][0],a[0][1],a[1][1],a[2][1],a[0][2],a[1][2],a[2][2],v[0][0],v[1][0],v[2][0],v[0][1],v[1][1],v[2][1],v[0][2],v[1][2],v[2][2]);
        } //else ;//printf("nix:%f p%i q%i",fabs(a[ip-1][iq-1]),ip,iq);
      } 
    } 
    for (ip=1;ip<=n;ip++) { 
      b[ip-1] += z[ip-1];
      d[ip-1] =b[ip-1];
      z[ip-1] =0.0;
    } 
  } 
  erg[0]=acos((v[0][0]+v[1][1]+v[2][2]-1.0)/2.0);
  if (erg[0]==0) {
    erg[1]=1.0;
    erg[2]=0.0;
    erg[3]=0.0;
  }else{
    erg[1]=(v[2][1]-v[1][2])/(2.0*sin(erg[0]));
    erg[2]=(v[0][2]-v[2][0])/(2.0*sin(erg[0]));
    erg[3]=(v[1][0]-v[0][1])/(2.0*sin(erg[0]));
    erg[0]*=180.0/M_PI;
  }
  /*printf("=%d=======================================\n%8.5f %8.5f %8.5f \n%8.5f %8.5f %8.5f \n%8.5f %8.5f %8.5f \n%8.5f %8.5f %8.5f\n========================================\n",i,
    d[0],d[1],d[2],v[0][0],v[0][1],v[0][2]
    ,v[1][0],v[1][1],v[1][2]
    ,v[2][0],v[2][1],v[2][2]

    );*/
  ev=V3(d[0],d[1],d[2]);
  return (double*)erg;
}

void Molecule::fuse(){
  /*! reduces the showatoms list to the asymmetric unit.
   * */
  HumanSymmetry=QString("Used Symmetry:<br>%1").arg(symmcode2human(QStringList()));
  usedSymmetry.clear();
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::grow(){
  /*! completes covalent bound molecule fragments. 
   *
   * */
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  showbonds.clear();
  QStringList brauchSymm;
  QString bs;
  brauchSymm.clear();
  V3 prime,dp,D,floorD;
  double dk,dddd;
  for (int k =0; k<sdm.size();k++){
    if ((sdm.at(k).covalent)||(growQPeak)){
      if (!(growQPeak)&&(asymm[sdm.at(k).a1].molindex<1)) continue;
      for (int n=0;n<cell.symmops.size();  n++){
        if (((asymm[sdm.at(k).a1].part!=0)&&(asymm[sdm.at(k).a2].part!=0)&&(asymm[sdm.at(k).a1].part!=asymm[sdm.at(k).a2].part)))continue;
        if ((asymm[sdm.at(k).a1].an==asymm[sdm.at(k).a2].an)&&(asymm[sdm.at(k).a1].an==0)) continue;
        prime=cell.symmops.at(n) * asymm[sdm.at(k).a1].frac + cell.trans.at(n);
        D=prime - asymm[sdm.at(k).a2].frac+ V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        dp=D - floorD - V3(0.5,0.5,0.5);
        if ((n==0)&&(V3(0,0,0)==floorD)) continue;
        dk=fl(dp.x,dp.y,dp.z);
        //printf ("%f n%d\n",dk,n);
        dddd=(sdm.at(k).covalent)?(sdm.at(k).d+0.2):0;
        if ((asymm[sdm.at(k).a1].an<0)&&(asymm[sdm.at(k).a2].an<0)) dddd=1.8;//||
        if ( (dk>0.001)&&(dddd>=dk)) {
          bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm[sdm.at(k).a1].molindex);
          //	     printf("%s %s %g %g\n",asymm[sdm.at(k).a1].Label.toStdString().c_str(),asymm[sdm.at(k).a2].Label.toStdString().c_str(),sdm.at(k).d,dddd);
          //             printf("(grow)%s\n",bs.toStdString().c_str());
          if  ((!brauchSymm.contains(bs))) {
            brauchSymm.append(bs);
          }
        }
      }
    }
  }
  for (int i=0; i<bindatoms.size(); i++){
    MyAtom a1, a2;
    bool bo=false;
    int sy1=-1,sy2=-1;
    if (bindatoms.at(i).Lab1.contains("_$"))sy1=bindatoms.at(i).Lab1.section("_$",1,1).toInt(&bo);
    if (bindatoms.at(i).Lab2.contains("_$"))sy2=bindatoms.at(i).Lab2.section("_$",1,1).toInt(&bo);
    bo=false;
    if (bindatoms.at(i).Lab1.contains('_'))a1.resiNr=bindatoms.at(i).Lab1.section('_',1,1).toInt(&bo);
    if (!bo) a1.resiNr=-1;
    if (bindatoms.at(i).Lab2.contains('_'))a2.resiNr=bindatoms.at(i).Lab2.section('_',1,1).toInt(&bo);
    if (!bo)a2.resiNr=-1;
    a1.Label = bindatoms.at(i).Lab1.section('_',0,0);
    a2.Label = bindatoms.at(i).Lab2.section('_',0,0);
    int frag1=0,frag2=0;
    for (int ii=0; ii<asymm.size();ii++){
      if ((a1.resiNr>-1)&& (asymm[ii].resiNr!=a1.resiNr)) continue;
      if ((a2.resiNr>-1)&& (asymm[ii].resiNr!=a2.resiNr)) continue;
      if (asymm[ii].Label.section('_',0,0).toUpper() == a1.Label.toUpper()){
        frag1=asymm[ii].molindex;
      }
      if (asymm[ii].Label.section('_',0,0).toUpper() == a2.Label.toUpper()){
        frag2=asymm[ii].molindex;
      }
    }
    QString ss;
    QList<Matrix> smm;
    QList<V3> tmm;
    int syy1=-1;
    if (sy1>-1) syy1=labelEQIV.indexOf(QString("$%1").arg(sy1));
    if (syy1>-1) {
      smm.append(symmopsEQIV.at(syy1));
      tmm.append(transEQIV.at(syy1));
    }
    int syy2=-1;
    if (sy2>-1) syy2=labelEQIV.indexOf(QString("$%1").arg(sy2));
    if (syy2>-1) {
      smm.append(symmopsEQIV.at(syy2));
      tmm.append(transEQIV.at(syy2));
    }
    for (int ui=0; ui<smm.size(); ui++)
      if (cell.symmops.contains(smm.at(ui))) {
        V3 r;
        r.x=fmod(tmm.at(ui).x+10,1.0);
        r.y=fmod(tmm.at(ui).y+10,1.0);
        r.z=fmod(tmm.at(ui).z+10,1.0);

        //	qDebug()<<"da"<<r.x<<r.y<<r.z<<maxmol<<frag1<<frag2<<cell.symmops.indexOf(smm.at(ui));
        for (int is=0; is<cell.symmops.size();is++){
          if ((cell.symmops.at(is)==smm.at(ui))&&(cell.trans.at(is)==r))
            for (int yi=1; yi<=5; yi++){
              ss=QString("%1_%2%3%4:%5,")
                .arg(is+1)
                .arg((int)(tmm.at(ui).x-r.x) +5)
                .arg((int)(tmm.at(ui).y-r.y) +5)
                .arg((int)(tmm.at(ui).z-r.z) +5)
                .arg(((sy1>-1)&&(!ui))?frag1:frag2);
              if  (!brauchSymm.contains(ss)) {
                brauchSymm.append(ss);
                //		printf("### %d  = %d\n",((sy1>-1)&&(!ui))?sy1:sy2,brauchSymm.size());
                eqivMap[labelEQIV.at(((sy1>-1)&&(!ui))?sy1-1:sy2-1)]=brauchSymm.size();
                //		qDebug()<<ss;
              }
            }
        }
      }
  }

  /*  for (int i=0; i<sdm.size();i++){
      if ((sdm.at(i).sn==0)&&(V3(0,0,0)==sdm.at(i).floorD)) continue;
      double dddd=((Kovalenz_Radien[asymm[sdm.at(i).a1].an]+ Kovalenz_Radien[asymm[sdm.at(i).a2].an])*0.01+0.5);
      if (dddd>sdm.at(i).d){
      bs=QString("%1_%2%3%4:%5,").arg(sdm.at(i).sn+1).arg(5-(int)sdm.at(i).floorD.x).arg(5-(int)sdm.at(i).floorD.y).arg(5-(int)sdm.at(i).floorD.z).arg(asymm[sdm.at(i).a1].molindex);
      / *        printf("%s %f %s %s\n",bs.toStdString().c_str(),sdm.at(i).d,
      asymm[sdm.at(i).a1].Label.toStdString().c_str(),
      asymm[sdm.at(i).a2].Label.toStdString().c_str());
   * /
   if  (!brauchSymm.contains(bs)) {
   brauchSymm.append(bs);
   }
   }
   } */
  //packer(brauchSymm);
  usedSymmetry+=brauchSymm;    
  //complete();
  packer(brauchSymm);
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::grow_plus(){
  /*! completes covalent bound molecule fragments. 
   *
   * */
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  showbonds.clear();
  QStringList brauchSymm;
  QString bs;
  brauchSymm.clear();
  V3 prime,dp,D,floorD;
  double dk,dddd;
  for (int k =0; k<sdm.size();k++){
    if ((sdm.at(k).covalent)||(growQPeak)){
      if (!(growQPeak)&&(asymm[sdm.at(k).a1].molindex<1)) continue;
      for (int n=0;n<cell.symmops.size();  n++){
        if (((asymm[sdm.at(k).a1].part!=0)&&(asymm[sdm.at(k).a2].part!=0)&&(asymm[sdm.at(k).a1].part!=asymm[sdm.at(k).a2].part)))continue;
        if ((asymm[sdm.at(k).a1].an==asymm[sdm.at(k).a2].an)&&(asymm[sdm.at(k).a1].an==0)) continue;
        prime=cell.symmops.at(n) * asymm[sdm.at(k).a1].frac + cell.trans.at(n);
        D=prime - asymm[sdm.at(k).a2].frac+ V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        dp=D - floorD - V3(0.5,0.5,0.5);
        if ((n==0)&&(V3(0,0,0)==floorD)) continue;
        dk=fl(dp.x,dp.y,dp.z);
        //printf ("%f n%d\n",dk,n);
        dddd=(sdm.at(k).covalent)?(sdm.at(k).d+0.2):0;
        if ((asymm[sdm.at(k).a1].an<0)&&(asymm[sdm.at(k).a2].an<0)) dddd=1.8;//||
        if ( (dk>0.001)&&(dddd>=dk)) {
          bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm[sdm.at(k).a1].molindex);
          //	     printf("%s %s %g %g\n",asymm[sdm.at(k).a1].Label.toStdString().c_str(),asymm[sdm.at(k).a2].Label.toStdString().c_str(),sdm.at(k).d,dddd);
          //             printf("(grow)%s\n",bs.toStdString().c_str());
          if  ((!brauchSymm.contains(bs))) {
            brauchSymm.append(bs);
          }
        }
      }
    }
  }
  for (int i=0; i<bindatoms.size(); i++){
    MyAtom a1, a2;
    bool bo=false;
    int sy1=-1,sy2=-1;
    if (bindatoms.at(i).Lab1.contains("_$"))sy1=bindatoms.at(i).Lab1.section("_$",1,1).toInt(&bo);
    if (bindatoms.at(i).Lab2.contains("_$"))sy2=bindatoms.at(i).Lab2.section("_$",1,1).toInt(&bo);
    bo=false;
    if (bindatoms.at(i).Lab1.contains('_'))a1.resiNr=bindatoms.at(i).Lab1.section('_',1,1).toInt(&bo);
    if (!bo) a1.resiNr=-1;
    if (bindatoms.at(i).Lab2.contains('_'))a2.resiNr=bindatoms.at(i).Lab2.section('_',1,1).toInt(&bo);
    if (!bo)a2.resiNr=-1;
    a1.Label = bindatoms.at(i).Lab1.section('_',0,0);
    a2.Label = bindatoms.at(i).Lab2.section('_',0,0);
    int frag1=0,frag2=0;
    for (int ii=0; ii<asymm.size();ii++){
      if ((a1.resiNr>-1)&& (asymm[ii].resiNr!=a1.resiNr)) continue;
      if ((a2.resiNr>-1)&& (asymm[ii].resiNr!=a2.resiNr)) continue;
      if (asymm[ii].Label.section('_',0,0).toUpper() == a1.Label.toUpper()){
        frag1=asymm[ii].molindex;
      }
      if (asymm[ii].Label.section('_',0,0).toUpper() == a2.Label.toUpper()){
        frag2=asymm[ii].molindex;
      }
    }
    QString ss;
    QList<Matrix> smm;
    QList<V3> tmm;
    int syy1=-1;
    if (sy1>-1) syy1=labelEQIV.indexOf(QString("$%1").arg(sy1));
    if (syy1>-1) {
      smm.append(symmopsEQIV.at(syy1));
      tmm.append(transEQIV.at(syy1));
    }
    int syy2=-1;
    if (sy2>-1) syy2=labelEQIV.indexOf(QString("$%1").arg(sy2));
    if (syy2>-1) {
      smm.append(symmopsEQIV.at(syy2));
      tmm.append(transEQIV.at(syy2));
    }
    for (int ui=0; ui<smm.size(); ui++)
      if (cell.symmops.contains(smm.at(ui))) {
        V3 r;
        r.x=fmod(tmm.at(ui).x+10,1.0);
        r.y=fmod(tmm.at(ui).y+10,1.0);
        r.z=fmod(tmm.at(ui).z+10,1.0);

        //	qDebug()<<"da"<<r.x<<r.y<<r.z<<maxmol<<frag1<<frag2<<cell.symmops.indexOf(smm.at(ui));
        for (int is=0; is<cell.symmops.size();is++){
          if ((cell.symmops.at(is)==smm.at(ui))&&(cell.trans.at(is)==r))
            for (int yi=1; yi<=5; yi++){
              ss=QString("%1_%2%3%4:%5,")
                .arg(is+1)
                .arg((int)(tmm.at(ui).x-r.x) +5)
                .arg((int)(tmm.at(ui).y-r.y) +5)
                .arg((int)(tmm.at(ui).z-r.z) +5)
                .arg(((sy1>-1)&&(!ui))?frag1:frag2);
              if  (!brauchSymm.contains(ss)) {
                brauchSymm.append(ss);
                //		printf("### %d  = %d\n",((sy1>-1)&&(!ui))?sy1:sy2,brauchSymm.size());
                eqivMap[labelEQIV.at(((sy1>-1)&&(!ui))?sy1-1:sy2-1)]=brauchSymm.size();
                //		qDebug()<<ss;
              }
            }
        }
      }
  }

  /*  for (int i=0; i<sdm.size();i++){
      if ((sdm.at(i).sn==0)&&(V3(0,0,0)==sdm.at(i).floorD)) continue;
      double dddd=((Kovalenz_Radien[asymm[sdm.at(i).a1].an]+ Kovalenz_Radien[asymm[sdm.at(i).a2].an])*0.01+0.5);
      if (dddd>sdm.at(i).d){
      bs=QString("%1_%2%3%4:%5,").arg(sdm.at(i).sn+1).arg(5-(int)sdm.at(i).floorD.x).arg(5-(int)sdm.at(i).floorD.y).arg(5-(int)sdm.at(i).floorD.z).arg(asymm[sdm.at(i).a1].molindex);
      / *        printf("%s %f %s %s\n",bs.toStdString().c_str(),sdm.at(i).d,
      asymm[sdm.at(i).a1].Label.toStdString().c_str(),
      asymm[sdm.at(i).a2].Label.toStdString().c_str());
   * /
   if  (!brauchSymm.contains(bs)) {
   brauchSymm.append(bs);
   }
   }
   } */
  //packer(brauchSymm);
  usedSymmetry+=brauchSymm;    
  complete();
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::fillCell(){
  /*! Fills the unit cell with molecules.
   *
   * */
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  showbonds.clear();
  QStringList brauchSymm;
  QString bs;
  brauchSymm.clear();
  V3 prime,dp,D,floorD;
  //double dk,dddd;
  for (int k =0; k<sdm.size();k++){
    if (sdm.at(k).covalent){
      if (asymm[sdm.at(k).a1].molindex<1) continue;
      for (int n=0;n<cell.symmops.size();  n++){
        //if (((asymm[sdm.at(k).a1].part!=0)&&(asymm[sdm.at(k).a2].part!=0)&&(asymm[sdm.at(k).a1].part!=asymm[sdm.at(k).a2].part)))continue;
        //if ((asymm[sdm.at(k).a1].an==asymm[sdm.at(k).a2].an)&&(asymm[sdm.at(k).a1].an==0)) continue;
        D=prime=cell.symmops.at(n) * asymm[sdm.at(k).a1].frac + cell.trans.at(n);
        //D=prime - asymm[sdm.at(k).a2].frac+ V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        //dp=D - floorD - V3(0.5,0.5,0.5);
        if ((n==0)&&(V3(0,0,0)==floorD)) continue;
        //dk=fl(dp.x,dp.y,dp.z);
        //printf ("%f n%d\n",dk,n);
        //dddd=(sdm.at(k).d+0.2);
        //if ( (dk>0.001)&&(dddd>=dk)) {
        bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm[sdm.at(k).a1].molindex);
        //	     printf("%s %s %g %g\n",asymm[sdm.at(k).a1].Label.toStdString().c_str(),asymm[sdm.at(k).a2].Label.toStdString().c_str(),sdm.at(k).d,dddd);
        //             printf("(grow)%s\n",bs.toStdString().c_str());
        if  (!brauchSymm.contains(bs)) {
          brauchSymm.append(bs);
        }
        //}
      }
    }
  }
  /*  for (int i=0; i<sdm.size();i++){
      if ((sdm.at(i).sn==0)&&(V3(0,0,0)==sdm.at(i).floorD)) continue;
      double dddd=((Kovalenz_Radien[asymm[sdm.at(i).a1].an]+ Kovalenz_Radien[asymm[sdm.at(i).a2].an])*0.01+0.5);
      if (dddd>sdm.at(i).d){
      bs=QString("%1_%2%3%4:%5,").arg(sdm.at(i).sn+1).arg(5-(int)sdm.at(i).floorD.x).arg(5-(int)sdm.at(i).floorD.y).arg(5-(int)sdm.at(i).floorD.z).arg(asymm[sdm.at(i).a1].molindex);
      / *        printf("%s %f %s %s\n",bs.toStdString().c_str(),sdm.at(i).d,
      asymm[sdm.at(i).a1].Label.toStdString().c_str(),
      asymm[sdm.at(i).a2].Label.toStdString().c_str());
   * /
   if  (!brauchSymm.contains(bs)) {
   brauchSymm.append(bs);
   }
   }
   } */
  packer(brauchSymm);
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::expandAll(){
  /*! like Molecule.expandAt but this searches vor neighboring molecules arround every atom of the asymmetric unit and adds them to the showatoms list.
  */
  //if (index>=showatoms.size()) return;
  //  V3 expander= showatoms.at(index).frac;
  V3 prime,floorD,D;
  double SUCHRAD=3.2;
  for (int i=0; i<asymm.size();i++){//Rapunzel lass dein H herunter
    if (asymm.at(i).an==0) {
      SUCHRAD-=0.7;
      break;
    }
  }
  //  printf(" Rapunzels H ist %f lang\n",SUCHRAD);
  QStringList brauchSymm;
  QString bs;
  brauchSymm.clear();
  //  brauchSymm+=(usedSymmetry);
  double dk;
  for (int j=0; j<asymm.size();j++){
    if (asymm.at(j).an<0) continue;
    for (int n=0; n<cell.symmops.size();n++){
      for (int i=0; i<asymm.size();i++){
        if (asymm.at(i).an<0) continue;
        prime=cell.symmops.at(n) * asymm.at(i).frac + cell.trans.at(n);
        D=prime - asymm.at(j).frac + V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        if ((n==0)&&(floorD==V3(0,0,0))) {continue;}
        D=D - floorD - V3(0.5,0.5,0.5);
        dk=fl(D.x,D.y,D.z);
        if (dk<SUCHRAD){
          bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm.at(i).molindex);
          if  ((!brauchSymm.contains(bs))&&(asymm.at(i).molindex>0)) {
            brauchSymm.append(bs);
          }
        }
      }
    }
  }
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  packer(brauchSymm);
  showbonds.clear();
  showbonds=connecting(showatoms);
}


void Molecule::complete(){
  /*! If the current visible atoms are covalently bound to  symmetry equivalents the latter are added to the showatoms list.
   * */
  //if (index>=showatoms.size()) return;
  //  V3 expander= showatoms.at(index).frac;
  V3 prime,floorD,D;
  QStringList brauchSymm;
  QString bs;
  //  brauchSymm.clear();
  brauchSymm+=(usedSymmetry);
  double dk;
  int s,h,k,l,symmgroup;
  V3 pos0;
  for (int sy=0; sy<usedSymmetry.size(); sy++){ 
    sscanf(usedSymmetry.at(sy).toLatin1(),"%d_%1d%1d%1d:%d",&s,&h,&k,&l,&symmgroup);
    h-=5;
    k-=5;
    l-=5;
    s--;
    for (int j=0; j<asymm.size();j++){
      if (asymm.at(j).an<0) continue;
      for (int n=0; n<cell.symmops.size();n++){
        for (int i=0; i<asymm.size();i++){
          if (asymm.at(i).an<1) continue;
          if (asymm[i].molindex!=symmgroup) continue;
          pos0=cell.symmops.at(s)*asymm.at(i).frac+cell.trans.at(s)+V3(h,k,l);
          prime=cell.symmops.at(n) * asymm.at(j).frac + cell.trans.at(n);
          D=prime - pos0 + V3(0.5,0.5,0.5) ;
          floorD=V3(floor(D.x),floor(D.y),floor(D.z));
          if ((n==0)&&(floorD==V3(0,0,0))) {continue;}
          D=D - floorD - V3(0.5,0.5,0.5);
          dk=fl(D.x,D.y,D.z);
          double dddd=qMin(1.7,(Kovalenz_Radien[asymm.at(i).an]+ Kovalenz_Radien[asymm.at(j).an])*0.012);
          if (dk<dddd){
            bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm.at(i).molindex);
            if  ((!brauchSymm.contains(bs))&&(asymm.at(i).molindex>0)) {
              brauchSymm.append(bs);
            }
          }
        }
      }
    }
  }
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  packer(brauchSymm);
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::expandAt(int index){
  /*! searches SUCHRAD=3.2 A around the given atom for symmetry equivalent molecules and adds them to the showatoms list.
   *  if Hydrogens are inside the structure the SUCHRAD is reduced about 0.7 A.
   *  @param index index of the specified atom from the current showatoms list.
   */
  if (index>=showatoms.size()) return;
  V3 expander= showatoms.at(index).frac;
  V3 prime,floorD,D;
  double SUCHRAD=3.2;
  for (int i=0; i<asymm.size();i++){//Rapunzel lass dein H herunter
    if (asymm.at(i).an==0) {
      SUCHRAD-=0.7;
      break;
    }
  }
  //printf(" Rapunzels H ist %f lang\n",SUCHRAD);
  QStringList brauchSymm;
  QString bs;
  brauchSymm.clear();
  brauchSymm+=(usedSymmetry);
  double dk;
  for (int n=0; n<cell.symmops.size();n++){
    for (int i=0; i<asymm.size();i++){
      prime=cell.symmops.at(n) * asymm.at(i).frac + cell.trans.at(n);
      D=prime - expander + V3(0.5,0.5,0.5) ;
      floorD=V3(floor(D.x),floor(D.y),floor(D.z));
      if ((n==0)&&(floorD==V3(0,0,0))) {continue;}
      D=D - floorD - V3(0.5,0.5,0.5);
      dk=fl(D.x,D.y,D.z);
      if (dk<SUCHRAD){
        bs=QString("%1_%2%3%4:%5,").arg(n+1).arg(5-(int)floorD.x).arg(5-(int)floorD.y).arg(5-(int)floorD.z).arg(asymm.at(i).molindex);
        if  ((!brauchSymm.contains(bs))&&(asymm.at(i).molindex>0)) {
          brauchSymm.append(bs);
        }
      }
    }
  }
  showatoms.clear();
  for (int i=0; i<asymm.size();i++){
    showatoms.append(asymm[i]);
    showatoms[i].molindex=asymm[i].molindex;
  }
  packer(brauchSymm);
  showbonds.clear();
  showbonds=connecting(showatoms);
}

void Molecule::packer(QStringList brauchSymm){
  /*! Packs symmetry equivalent atoms according to the given list of internal symmetry codes and adds them to the showatoms list
   * HumanSymmetry is feeeded with a human readalble list of used symmetry.
   * @param brauchSymm list of internal symmetry codes.
   */
  usedSymmetry.clear();
  usedSymmetry+=(brauchSymm);
  MyAtom  newAtom;
  newAtom.hidden=0;
  int s,h,k,l,gibscho=0,symmgroup;
  //      balken->setMinimum(0);
  //      balken->setMaximum(brauchSymm.size());
  //      balken->show();
  HumanSymmetry=QString("Used Symmetry:<br>%1").arg(symmcode2human(brauchSymm));
  QString pre,suff;
  for (int j=0;j<brauchSymm.size();j++){
    //	balken->setValue(j);

    sscanf(brauchSymm.at(j).toLatin1(),"%d_%1d%1d%1d:%d",&s,&h,&k,&l,&symmgroup);
    //printf("BS:!%s! %d h%d k%d l%d sg%d\n",brauchSymm.at(j).toStdString().c_str(),s,h,k,l,symmgroup);
    h-=5;
    k-=5;
    l-=5;
    s--;
    for (int i=0;i<asymm.size();i++){
      // if (asymm[i].molindex) printf ("doch %d %d %s\n",asymm[i].an,asymm[i].molindex,asymm.at(i).Label.toStdString().c_str());
      if ((asymm[i].molindex==symmgroup)&&(asymm[i].an>-1)){
        newAtom.frac=cell.symmops.at(s)*asymm[i].frac+cell.trans.at(s)+V3(h,k,l);
        newAtom.part=asymm[i].part;
        frac2kart(newAtom.frac,newAtom.pos);
        newAtom.Label=QString("%1%2%3")
          .arg(asymm.at(i).Label)
          .arg(QString::fromUtf8("»"))
          .arg(j+1);// */
        newAtom.an=asymm[i].an;
        newAtom.symmGroup=j+1;
        newAtom.sof_org=asymm[i].sof_org;
        newAtom.molindex=asymm[i].molindex;
        newAtom.ResiClass=asymm[i].ResiClass;
        newAtom.resiNr=asymm[i].resiNr;
        if ((asymm[i].uc.m12==0.0 )&&(asymm[i].uc.m23==0.0)&&(asymm[i].uc.m13==0.0)){
          newAtom.uc.m11=newAtom.uc.m22=newAtom.uc.m33=asymm[i].uf.m11;
          newAtom.uc.m12=newAtom.uc.m13=newAtom.uc.m23=newAtom.uc.m21=newAtom.uc.m31=newAtom.uc.m32=0.0;
          newAtom.uf=asymm[i].uf;
        }
        else {
          Usym(asymm[i].uf,cell.symmops[s],newAtom.uf);
          Uf2Uo(newAtom.uf,newAtom.uc);
        }
        gibscho=0;
        if (newAtom.part>=0){
          for(int gbt=0;gbt<showatoms.size();gbt++){
            if (showatoms.at(gbt).an<0) continue;
            if (showatoms.at(gbt).part!=newAtom.part)continue;
            if (fl(newAtom.frac.x-showatoms[gbt].frac.x,
                  newAtom.frac.y-showatoms[gbt].frac.y,
                  newAtom.frac.z-showatoms[gbt].frac.z)<0.2) gibscho=1;
          }
        }
        if (!gibscho) {
          showatoms.append(newAtom);
        }
      }// /*
      else if ((growQPeak)&&(asymm[i].an==-1)&&(asymm[i].molindex==symmgroup)){
        newAtom.frac=cell.symmops.at(s)*asymm[i].frac+cell.trans.at(s)+V3(h,k,l);
        newAtom.part=asymm[i].part;
        frac2kart(newAtom.frac,newAtom.pos);
        newAtom.Label=asymm.at(i).Label;
        newAtom.an=asymm[i].an;
        newAtom.symmGroup=j+1;
        newAtom.sof_org=asymm[i].sof_org;
        newAtom.sof=asymm[i].sof;
        newAtom.molindex=asymm[i].molindex;
        newAtom.ResiClass=asymm[i].ResiClass;
        newAtom.resiNr=asymm[i].resiNr;
        newAtom.peakHeight=asymm[i].peakHeight;
        newAtom.orginalLine= asymm[i].orginalLine;
        gibscho=0;
        if (newAtom.part>=0){
          for(int gbt=0;gbt<showatoms.size();gbt++){
            if (fl(newAtom.frac.x-showatoms[gbt].frac.x,
                  newAtom.frac.y-showatoms[gbt].frac.y,
                  newAtom.frac.z-showatoms[gbt].frac.z)<0.1) gibscho=1;
          }
        }
        if (!gibscho) {
          showatoms.append(newAtom);
        }
      }// */
    }
  }
  //statusBar()->showMessage(tr("Neighbor search is finished"));
}

bool Molecule::checkExtensions(){
  bool gut=true;
  int glmajor=0,glminor=0;
  float vv=0.0;

  const char *extensionString =(const char *) glGetString(GL_EXTENSIONS);
  //printf("%s \n",extensionString);
  const char *verstring=(char*)glGetString(GL_VERSION);
  if ((verstring==NULL)||(sscanf(verstring,"%d.%d",&glmajor,&glminor)!=2)) glminor=glmajor=0;
  //printf("!!%s \n",verstring);
  if (glmajor<2) return false;
  verstring=(char*)glGetString(GL_SHADING_LANGUAGE_VERSION);
  if ((verstring==NULL)||(sscanf(verstring,"%f",&vv)!=1)) vv=0.0;
    //qDebug()<<vv<<glminor<<glmajor<<verstring;
  if (vv<1.2) return false;

  QString pth=QDir::homePath()+"/GL-Extensions.txt";
  FILE *extf=fopen(pth.toStdString().c_str(),"wt");
  fwrite(extensionString,sizeof(char),strlen(extensionString)+1,extf);
  fclose(extf);
  if (NULL==strstr(extensionString, "GL_ARB_vertex_shader"))gut=false;
  if (NULL==strstr(extensionString, "GL_ARB_fragment_shader")) gut=false;
  return gut;
}

int Molecule::installShader(){
  if (!checkExtensions()) {
      //printf("insallShader::missing Extensions!\n");
      return 0;
  }
  QFile logshad(QDir::homePath()+"/shaderlog.txt");
  logshad.open(QFile::WriteOnly|QFile::Text);
  logshad.write(QDateTime::currentDateTime().toString().toLatin1());
  logshad.write("\n\ntest\n");
  logshad.flush(); // */
  static const char* avs=
    "#version 120\n"
    "uniform bool lighting;\n"
    "varying vec3 nor, lightDirection, normal, uv, pos,eye;\n"
    "varying vec4 gcolor;\n"
    "varying float ep,np;\n"
    "void main(void){\n"
    "nor=gl_Normal;\n"
    "gcolor=gl_Color;\n"
    "uv = gl_Vertex.xyz;\n"
    "if (lighting){\n"
    "normal = gl_NormalMatrix * gl_Normal;\n"
    "vec4 eyePos = gl_ModelViewMatrixInverse * vec4(0., 0., 0., 1.);\n"
    "eye = eyePos.xyz - gl_Vertex.xyz;\n"
    "lightDirection=normalize(vec3(1.0,1.0,1.0));\n"
    "pos = (gl_ModelViewMatrix * gl_Vertex).xyz;\n"
    "}\n"
    "gl_Position = ftransform();\n"
    "}\n";
  static const char* afs=
    "#version 120\n"
    "varying vec3 nor, lightDirection, normal, uv, pos,eye;\n"
    "varying vec4 gcolor;\n"
    "uniform int LOD;\n"
    "uniform bool lighting, wall, ring, ball, open, whitering, eli;\n"
    "void main(void) {\n"
    "vec4 specular, ambient, diffuse;\n"
    "specular = gl_LightSource[0].specular;\n"
    "ambient = gl_LightSource[0].ambient;\n"
    "diffuse = gl_LightSource[0].diffuse;\n"
    "vec4 color;\n"
    "gl_FragColor.a=1.0;\n"
    "float cut=0.07;\n"
    "if (lighting){\n"
    "vec3 N = normalize(normal);\n"
    "gl_MaterialParameters M = gl_FrontMaterial;\n"
    "float NdotL = dot(N, lightDirection);\n"
    "float RdotL = dot(reflect(normalize(pos), N), lightDirection);\n"
    "color = ((ambient + diffuse * max(NdotL, 0.0)) * gcolor +\n"
    "(M.specular * specular * pow(max(RdotL, 0.0), M.shininess)));\n"
    "}else{\n"
    "color=gcolor;\n"
    "}\n"
    "if (wall){\n"
    "float R=0.92;\n"
    "if (LOD==3) R=0.98;\n"
    "else if (LOD==2)R=0.97; \n"
    "gl_FragColor.a=(length(uv)<R)?1.0:0.0;\n"
    "gl_FragColor.xyz = color.xyz;\n"
    "}else{\n"
    "if (eli) {\n"
    "vec3 XYZ=abs(nor);\n"
    "if ((ring)&&(min(XYZ.x,min(XYZ.y,XYZ.z))<=cut)){ \n"
    "if (whitering) gl_FragColor.xyz = mix(color.xyz,vec3(1.0,1.0,1.0),0.6);\n"
    "else gl_FragColor.xyz = mix(color.xyz,vec3(0.0,0.0,0.0),0.6);\n"
    "}\n"
    "else if (open){\n"
    "int ep=0,np=0;\n"
    "ep+=(eye.x>=0.0)?1:0;\n"
    "ep+=(eye.y>=0.0)?2:0;\n"
    "ep+=(eye.z>=0.0)?4:0;\n"
    "np+=(nor.x>=0.0)?1:0;\n"
    "np+=(nor.y>=0.0)?2:0;\n"
    "np+=(nor.z>=0.0)?4:0;\n"
    "if (ep==np) gl_FragColor.a=0.0;\n else {if (ball) gl_FragColor = color; else gl_FragColor.a=0.0;}}\n"
    "else if (ball) gl_FragColor = color; else gl_FragColor.a=0.0;\n"
    "} else gl_FragColor = color; \n"
    "}\n"
    "}\n";
  logshad.write("test 0\n");
  logshad.flush();

  //	/* create program object and attach shaders * /

  logshad.write("test 1\n");
  g_Program->addShaderFromSourceCode(QGLShader::Vertex,avs);
  logshad.write(g_Program->log().toLatin1());
  logshad.write(g_Program->shaders().last()->log().toLatin1());

  logshad.write("test 2\n");
  logshad.flush();
  g_Program->addShaderFromSourceCode(QGLShader::Fragment,afs);
  logshad.write(g_Program->log().toLatin1());
  logshad.write(g_Program->shaders().last()->log().toLatin1());
      //error

  logshad.write(QString("test 3 %1\n").arg(g_Program->isLinked()).toLatin1());
  logshad.flush();
  g_Program->link();
  logshad.write(g_Program->log().toLatin1());
  logshad.flush();
  logshad.write("test 4\n");
  logshad.flush();
  logshad.write(g_Program->log().toLatin1());
  logshad.close();
  g_Program->bind();
  wallH = g_Program->uniformLocation( "wall");
  ringH = g_Program->uniformLocation( "ring");
  ballH = g_Program->uniformLocation( "ball");
  openH = g_Program->uniformLocation( "open");
  adpsH = g_Program->uniformLocation( "eli");
  whiteringH = g_Program->uniformLocation( "whitering");
  lichtH = g_Program->uniformLocation( "lighting");
  lodH = g_Program->uniformLocation( "LOD");
  shaders_work=true;
  /*  WRITE SHADERS TO files use '-linux -i4 -brf afs.glsl'
   *  to make them human readable.   
  FILE *avsf=fopen("avs.glsl","wt");
  fprintf(avsf,"%s",avs);
  fclose(avsf);
  FILE *afsf=fopen("afs.glsl","wt");
  fprintf(afsf,"%s",afs);
  fclose(afsf);
  //                                         */
  //printf("%s\n\n%s\n\n",avs,afs);
  printf("%s",g_Program->log().toStdString().c_str());
  g_Program->release();
  return g_Program->programId();
}
