/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.sikuli.guide.SikuliGuideDialog;

public class NavigationDialog
extends SikuliGuideDialog
implements ActionListener {
    String message;
    String title = null;
    int response;
    JLabel messageLabel;
    String command = null;
    Button next;
    Button prev;
    Button close;
    Box button_row;

    public void setTitle(String string) {
        this.title = string;
        this.updateMessageLabel();
    }

    @Override
    public String getActionCommand() {
        return this.command;
    }

    public NavigationDialog(Object object, String string, int n) {
        super(object);
        this.owner = object;
        this.message = string;
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        this.messageLabel = new JLabel();
        this.updateMessageLabel();
        Box box = new Box(0);
        box.add(this.messageLabel);
        this.next = new Button("Next");
        this.next.setActionCommand("Next");
        this.prev = new Button("Previous");
        this.prev.setActionCommand("Previous");
        this.close = new Button("Close");
        this.close.setActionCommand("Close");
        this.button_row = new Box(0);
        this.setButtons(this.button_row, n);
        container.add(box);
        container.add(this.button_row);
        this.next.addActionListener(this);
        this.prev.addActionListener(this);
        this.close.addActionListener(this);
    }

    void updateMessageLabel() {
        String string = this.generateHTML(-1);
        this.messageLabel.setText(string);
        Dimension dimension = this.messageLabel.getPreferredSize();
        if (dimension.width > 300) {
            string = this.generateHTML(300);
            this.messageLabel.setText(string);
        }
        this.setAlwaysOnTop(true);
        this.pack();
    }

    String generateHTML(int n) {
        String string = n < 0 ? "<html><div>" : "<html><div style='width:" + n + "'>";
        if (this.title != null) {
            string = string + "<div style='font-size:10px;color:white;background-color:#333333;padding:2px;'>" + this.title + "</div>";
        }
        string = string + "<div style='font-size:12px;color:white;padding:2px;'>" + this.message + "</div>";
        string = string + "</div></html>";
        return string;
    }

    public void setStyle(int n) {
        this.button_row.removeAll();
        this.setButtons(this.button_row, n);
        this.setAlwaysOnTop(true);
        this.pack();
    }

    private void setButtons(Container container, int n) {
        if (n == 0) {
            container.add(this.next);
            container.add(this.close);
        } else if (n == 1) {
            container.add(this.prev);
            container.add(this.next);
            container.add(this.close);
        } else if (n == 2) {
            container.add(this.prev);
            container.add(this.close);
        } else if (n == 4) {
            container.add(this.next);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.command = actionEvent.getActionCommand();
        this.dismiss();
    }

    class Button
    extends JButton {
        public Button(String string) {
            super(string);
            Font font = new Font("sansserif", 1, 14);
            this.setFont(font);
            this.setFocusable(false);
        }
    }
}

