/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_13 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 3346, "epsg", 3346,
        "LKS94 / Lithuania TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"LKS94 / Lithuania TM\",GEOGCS[\"LKS94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Lithuania_1994_ETRS89\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6126\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4669\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",24],PARAMETER[\"scale_factor\",0.9998],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3346\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def (filter, first, last, 3347, "epsg", 3347,
        "NAD83 / Statistics Canada Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-9");
    add_proj4text (p, 1,
        "1.86666666666666 +x_0=6200000 +y_0=3000000 +datum=NAD83 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Statistics Canada Lambert\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",49],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",63.390675],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-91.86666666666666],PARAMETER[\"false_easting\",62");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",3000000],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3347\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 3348, "epsg", 3348,
        "NAD83(CSRS) / Statistics Canada Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-9");
    add_proj4text (p, 1,
        "1.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 ");
    add_proj4text (p, 2,
        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Statistics Canada Lambert\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 7,
        "17\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",49],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",77],PARAMETER[\"latitude_of_origin\",63.39067");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"central_meridian\",-91.86666666666666],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",6200000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3348\"]]");
    p = add_epsg_def (filter, first, last, 3349, "epsg", 3349,
        "WGS 84 / PDC Mercator (deprecated)");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / PDC Mercator (deprecated)\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Mercator_1SP\"],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 7,
        ",-150],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 8,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 9,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 10,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3349\"]]");
    p = add_epsg_def (filter, first, last, 3350, "epsg", 3350,
        "Pulkovo 1942 / CS63 zone C0");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.1 +lon_0=21.95 +k=1 +x_0=250000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.");
    add_proj4text (p, 2,
        "82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone C0\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0.1],PARAMETER[\"central_meridian\",21.95],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",250000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"3350\"]]");
    p = add_epsg_def (filter, first, last, 3351, "epsg", 3351,
        "Pulkovo 1942 / CS63 zone C1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.1 +lon_0=24.95 +k=1 +x_0=1250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0");
    add_proj4text (p, 2,
        ".82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone C1\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0.1],PARAMETER[\"central_meridian\",24.95],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",125000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"3351\"]]");
    p = add_epsg_def (filter, first, last, 3352, "epsg", 3352,
        "Pulkovo 1942 / CS63 zone C2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.1 +lon_0=27.95 +k=1 +x_0=2250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0");
    add_proj4text (p, 2,
        ".82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone C2\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0.1],PARAMETER[\"central_meridian\",27.95],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",225000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"3352\"]]");
    p = add_epsg_def (filter, first, last, 3353, "epsg", 3353,
        "Mhast (onshore) / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast (onshore) / UTM zone 32S\",GEOGCS[\"Mhast");
    add_srs_wkt (p, 1,
        " (onshore)\",DATUM[\"Mhast_onshore\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6704\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4704\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3353\"]]");
    p = add_epsg_def (filter, first, last, 3354, "epsg", 3354,
        "Mhast (offshore) / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast (offshore) / UTM zone 32S\",GEOGCS[\"Mhas");
    add_srs_wkt (p, 1,
        "t (offshore)\",DATUM[\"Mhast_offshore\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6705\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4705\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"3354\"]]");
    p = add_epsg_def (filter, first, last, 3355, "epsg", 3355,
        "Egypt Gulf of Suez S-650 TL / Red Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=81");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt Gulf of Suez S-650 TL / Red Belt\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Egypt Gulf of Suez S-650 TL\",DATUM[\"Egypt_Gulf_of_S");
    add_srs_wkt (p, 2,
        "uez_S_650_TL\",SPHEROID[\"Helmert 1906\",6378200,298.3,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-146.21,112.63,4.05");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6706\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4706\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",31],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",615000],PARAMETER[\"false_northing\",8");
    add_srs_wkt (p, 11,
        "10000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"3355\"]]");
    p = add_epsg_def (filter, first, last, 3356, "epsg", 3356,
        "Grand Cayman 1959 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=67.8,106.1,138");
    add_proj4text (p, 1,
        ".8,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Grand Cayman 1959 / UTM zone 17N\",GEOGCS[\"Gra");
    add_srs_wkt (p, 1,
        "nd Cayman 1959\",DATUM[\"Grand_Cayman_1959\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7008\"]],TOWGS84[67.8,106.1,138.8,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6723\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4723\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-81],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3356\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 3357, "epsg", 3357,
        "Little Cayman 1961 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=42,124,147,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Little Cayman 1961 / UTM zone 17N\",GEOGCS[\"Li");
    add_srs_wkt (p, 1,
        "ttle Cayman 1961\",DATUM[\"Little_Cayman_1961\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],TOWGS84[42,124,147,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6726\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4726\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-81],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3357\"]]");
    p = add_epsg_def (filter, first, last, 3358, "epsg", 3358,
        "NAD83(HARN) / North Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Carolina\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",36.16666666666666],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",34.33333333333334],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 10,
        "origin\",33.75],PARAMETER[\"central_meridian\",-79],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",609601.22],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"3358\"]]");
    p = add_epsg_def (filter, first, last, 3359, "epsg", 3359,
        "NAD83(HARN) / North Carolina (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024385 +y_0=");
    add_proj4text (p, 2,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Carolina (ftUS) (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_R");
    add_srs_wkt (p, 2,
        "eference_Network\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",36.16666666666666],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",34.33333333333334],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",33.75],PARAMETER[\"central_");
    add_srs_wkt (p, 11,
        "meridian\",-79],PARAMETER[\"false_easting\",2000004.0000");
    add_srs_wkt (p, 12,
        "08],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3359\"]]");
    p = add_epsg_def (filter, first, last, 3360, "epsg", 3360,
        "NAD83(HARN) / South Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Carolina\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",34.83333333333334],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",32.5],PARAMETER[\"latitude_of_origin\",31.8");
    add_srs_wkt (p, 10,
        "3333333333333],PARAMETER[\"central_meridian\",-81],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",609600],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"33");
    add_srs_wkt (p, 14,
        "60\"]]");
    p = add_epsg_def (filter, first, last, 3361, "epsg", 3361,
        "NAD83(HARN) / South Carolina (ft)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Carolina (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_1\",34.83333333333334],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",32.5],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 10,
        "31.83333333333333],PARAMETER[\"central_meridian\",-81],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",2000000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "02\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"3361\"]]");
    p = add_epsg_def (filter, first, last, 3362, "epsg", 3362,
        "NAD83(HARN) / Pennsylvania North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_1\",41.95],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",40.88333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",40.16666666666666],PARAMETER[\"central_meridian\",-77.7");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",600000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"3362\"]]");
    p = add_epsg_def (filter, first, last, 3363, "epsg", 3363,
        "NAD83(HARN) / Pennsylvania North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",41.95],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_2\",40.88333333333333],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 10,
        "rigin\",40.16666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-77.75],PARAMETER[\"false_easting\",1968500],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3363\"]]");
    p = add_epsg_def (filter, first, last, 3364, "epsg", 3364,
        "NAD83(HARN) / Pennsylvania South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_1\",40.96666666666667],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",39.93333333333333],PARAMETER[\"latitude");
    add_srs_wkt (p, 10,
        "_of_origin\",39.33333333333334],PARAMETER[\"central_meri");
    add_srs_wkt (p, 11,
        "dian\",-77.75],PARAMETER[\"false_easting\",600000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"3364\"]]");
    p = add_epsg_def (filter, first, last, 3365, "epsg", 3365,
        "NAD83(HARN) / Pennsylvania South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Pennsylvania South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",40.96666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",39.93333333333333],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",39.33333333333334],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-77.75],PARAMETER[\"false_easting\",196850");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3365");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def (filter, first, last, 3366, "epsg", 3366,
        "Hong Kong 1963 Grid System (deprecated)");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=22.31213333333334 +lon_0=114.178555555");
    add_proj4text (p, 1,
        "5556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hong Kong 1963 Grid System (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Hong Kong 1963\",DATUM[\"Hong_Kong_1963\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1858\",6378293.645208759,294.2606763692654,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"6738\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4738\"]],PROJECTION[\"Cassini_So");
    add_srs_wkt (p, 7,
        "ldner\"],PARAMETER[\"latitude_of_origin\",22.31213333333");
    add_srs_wkt (p, 8,
        "334],PARAMETER[\"central_meridian\",114.1785555555556],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",40243.57775604237],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",19069.93351512578],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3366\"]]");
    p = add_epsg_def (filter, first, last, 3367, "epsg", 3367,
        "IGN Astro 1960 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN Astro 1960 / UTM zone 28N\",GEOGCS[\"IGN As");
    add_srs_wkt (p, 1,
        "tro 1960\",DATUM[\"IGN_Astro_1960\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4700\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"3367\"]]");
    p = add_epsg_def (filter, first, last, 3368, "epsg", 3368,
        "IGN Astro 1960 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN Astro 1960 / UTM zone 29N\",GEOGCS[\"IGN As");
    add_srs_wkt (p, 1,
        "tro 1960\",DATUM[\"IGN_Astro_1960\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4700\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3368\"]]");
    p = add_epsg_def (filter, first, last, 3369, "epsg", 3369,
        "IGN Astro 1960 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN Astro 1960 / UTM zone 30N\",GEOGCS[\"IGN As");
    add_srs_wkt (p, 1,
        "tro 1960\",DATUM[\"IGN_Astro_1960\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4700\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3369\"]]");
    p = add_epsg_def (filter, first, last, 3370, "epsg", 3370,
        "NAD27 / UTM zone 59N");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 59N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "370\"]]");
    p = add_epsg_def (filter, first, last, 3371, "epsg", 3371,
        "NAD27 / UTM zone 60N");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 60N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "371\"]]");
    p = add_epsg_def (filter, first, last, 3372, "epsg", 3372,
        "NAD83 / UTM zone 59N");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 59N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",171],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"3372\"]]");
    p = add_epsg_def (filter, first, last, 3373, "epsg", 3373,
        "NAD83 / UTM zone 60N");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 60N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",177],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"3373\"]]");
    p = add_epsg_def (filter, first, last, 3374, "epsg", 3374,
        "FD54 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FD54 / UTM zone 29N\",GEOGCS[\"FD54\",DATUM[\"F");
    add_srs_wkt (p, 1,
        "aroe_Datum_1954\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6741\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4741\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3374\"]]");
    p = add_epsg_def (filter, first, last, 3375, "epsg", 3375,
        "GDM2000 / Peninsula RSO");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.02579646666");
    add_proj4text (p, 1,
        "66 +k=0.99984 +x_0=804671 +y_0=0 +gamma=323.130102361111");
    add_proj4text (p, 2,
        "1 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Peninsula RSO\",GEOGCS[\"GDM2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4742\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_center\",4],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 8,
        "_center\",102.25],PARAMETER[\"azimuth\",323.025796466666");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"rectified_grid_angle\",323.1301023611111]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",804671],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"337");
    add_srs_wkt (p, 14,
        "5\"]]");
    p = add_epsg_def (filter, first, last, 3376, "epsg", 3376,
        "GDM2000 / East Malaysia BRSO");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.9");
    add_proj4text (p, 1,
        "9984 +x_0=0 +y_0=0 +gamma=53.13010236111111 +ellps=GRS80");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / East Malaysia BRSO\",GEOGCS[\"GDM2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4742\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 8,
        "e_of_center\",115],PARAMETER[\"azimuth\",53.31580995],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"rectified_grid_angle\",53.13010236111111],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.99984],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3376\"]]");
    p = add_epsg_def (filter, first, last, 3377, "epsg", 3377,
        "GDM2000 / Johor Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.121679744444445 +lon_0=103.427936236");
    add_proj4text (p, 1,
        "1111 +x_0=-14810.562 +y_0=8758.32 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Johor Grid\",GEOGCS[\"GDM2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",2.121679744444445],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",103.4279362361111],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",-14810.562],PARAMETER[\"false_northing\",8758.32],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3377\"]]");
    p = add_epsg_def (filter, first, last, 3378, "epsg", 3378,
        "GDM2000 / Sembilan and Melaka Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.682347636111111 +lon_0=101.974905041");
    add_proj4text (p, 1,
        "6667 +x_0=3673.785 +y_0=-4240.573 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Sembilan and Melaka Grid\",GEOGCS[\"G");
    add_srs_wkt (p, 1,
        "DM2000\",DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",2.682347636111111],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",101.9749050416667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",3673.785],PARAMETER[\"false_northing\",-");
    add_srs_wkt (p, 10,
        "4240.573],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"3378\"]]");
    p = add_epsg_def (filter, first, last, 3379, "epsg", 3379,
        "GDM2000 / PahangGrid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.769388088888889 +lon_0=102.368298983");
    add_proj4text (p, 1,
        "3333 +x_0=-7368.228 +y_0=6485.858 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / PahangGrid\",GEOGCS[\"GDM2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",3.769388088888889],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",102.3682989833333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",-7368.228],PARAMETER[\"false_northing\",6485.858],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3379\"]]");
    p = add_epsg_def (filter, first, last, 3380, "epsg", 3380,
        "GDM2000 / Selangor Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.68464905 +lon_0=101.3891079138889 +x");
    add_proj4text (p, 1,
        "_0=-34836.161 +y_0=56464.049 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Selangor Grid\",GEOGCS[\"GDM2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",3.68464905],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",101.3891079138889],PARAMETER[\"false_easting\",-");
    add_srs_wkt (p, 9,
        "34836.161],PARAMETER[\"false_northing\",56464.049],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "380\"]]");
    p = add_epsg_def (filter, first, last, 3381, "epsg", 3381,
        "GDM2000 / Terengganu Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.9762852 +lon_0=103.070275625 +x_0=19");
    add_proj4text (p, 1,
        "594.245 +y_0=3371.895 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Terengganu Grid\",GEOGCS[\"GDM2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",4.9762852],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",103.070275625],PARAMETER[\"false_easting\",19594.");
    add_srs_wkt (p, 9,
        "245],PARAMETER[\"false_northing\",3371.895],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3381\"]]");
    p = add_epsg_def (filter, first, last, 3382, "epsg", 3382,
        "GDM2000 / Pinang Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.421517541666667 +lon_0=100.344376963");
    add_proj4text (p, 1,
        "8889 +x_0=-23.414 +y_0=62.283 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Pinang Grid\",GEOGCS[\"GDM2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",5.421517541666667],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",100.3443769638889],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",-23.414],PARAMETER[\"false_northing\",62.283],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"338");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def (filter, first, last, 3383, "epsg", 3383,
        "GDM2000 / Kedah and Perlis Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.964672713888889 +lon_0=100.636371111");
    add_proj4text (p, 1,
        "1111 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Kedah and Perlis Grid\",GEOGCS[\"GDM2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",5.964672713888889],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",100.6363711111111],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 11,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3383\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def (filter, first, last, 3384, "epsg", 3384,
        "GDM2000 / Perak Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.859063022222222 +lon_0=100.815410586");
    add_proj4text (p, 1,
        "1111 +x_0=-1.769 +y_0=133454.779 +ellps=GRS80 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Perak Grid\",GEOGCS[\"GDM2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",4.859063022222222],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",100.8154105861111],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",-1.769],PARAMETER[\"false_northing\",133454.779],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3384\"]]");
    p = add_epsg_def (filter, first, last, 3385, "epsg", 3385,
        "GDM2000 / Kelantan Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.972543658333334 +lon_0=102.295241669");
    add_proj4text (p, 1,
        "4444 +x_0=13227.851 +y_0=8739.894 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDM2000 / Kelantan Grid\",GEOGCS[\"GDM2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geodetic_Datum_of_Malaysia_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6742\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4742\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",5.972543658333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",102.2952416694444],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",13227.851],PARAMETER[\"false_northing\",8739.894],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3385\"]]");
    p = add_epsg_def (filter, first, last, 3386, "epsg", 3386,
        "KKJ / Finland zone 0");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345");
    add_proj4text (p, 2,
        ",-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 0\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4123\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",18],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3386\"]]");
    p = add_epsg_def (filter, first, last, 3387, "epsg", 3387,
        "KKJ / Finland zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 5\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4123\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",33],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3387\"]]");
    p = add_epsg_def (filter, first, last, 3388, "epsg", 3388,
        "Pulkovo 1942 / Caspian Sea Mercator");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=51 +lat_ts=42 +x_0=0 +y_0=0 +ellps=kra");
    add_proj4text (p, 1,
        "ss +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Caspian Sea Mercator\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Mercator_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",42],PARAMETER[\"central_meridian\",51],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"none");
    add_srs_wkt (p, 11,
        "\",NORTH],AXIS[\"none\",EAST],AUTHORITY[\"EPSG\",\"3388\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def (filter, first, last, 3389, "epsg", 3389,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 60");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 60\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "80],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",60500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3389\"]]");
    p = add_epsg_def (filter, first, last, 3390, "epsg", 3390,
        "Pulkovo 1995 / 3-degree Gauss-Kruger zone 60");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,");
    add_proj4text (p, 2,
        "-0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 60\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "80],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",60500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3390\"]]");
    p = add_epsg_def (filter, first, last, 3391, "epsg", 3391,
        "Karbala 1979 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=70.995,-335.91");
    add_proj4text (p, 1,
        "6,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / UTM zone 37N\",GEOGCS[\"Karbala ");
    add_srs_wkt (p, 1,
        "1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4743\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3391\"]]");
    p = add_epsg_def (filter, first, last, 3392, "epsg", 3392,
        "Karbala 1979 / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=70.995,-335.91");
    add_proj4text (p, 1,
        "6,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / UTM zone 38N\",GEOGCS[\"Karbala ");
    add_srs_wkt (p, 1,
        "1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4743\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3392\"]]");
    p = add_epsg_def (filter, first, last, 3393, "epsg", 3393,
        "Karbala 1979 / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=70.995,-335.91");
    add_proj4text (p, 1,
        "6,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / UTM zone 39N\",GEOGCS[\"Karbala ");
    add_srs_wkt (p, 1,
        "1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4743\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3393\"]]");
    p = add_epsg_def (filter, first, last, 3394, "epsg", 3394,
        "Nahrwan 1934 / Iraq zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / Iraq zone\",GEOGCS[\"Nahrwan 193");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RGS)\"");
    add_srs_wkt (p, 2,
        ",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4744");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"latitude_of_origin\",32.5],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",45],PARAMETER[\"scale_factor\",0.9987864078],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",1500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",1166200],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"3394\"]]");
    p = add_epsg_def (filter, first, last, 3395, "epsg", 3395,
        "WGS 84 / World Mercator");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"M");
    add_srs_wkt (p, 6,
        "ercator_1SP\"],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 9,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 10,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3395\"]]");
    p = add_epsg_def (filter, first, last, 3396, "epsg", 3396,
        "PD/83 / 3-degree Gauss-Kruger zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3396\"]]");
    p = add_epsg_def (filter, first, last, 3397, "epsg", 3397,
        "PD/83 / 3-degree Gauss-Kruger zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3397\"]]");
    p = add_epsg_def (filter, first, last, 3398, "epsg", 3398,
        "RD/83 / 3-degree Gauss-Kruger zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 2,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4745\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3398\"]]");
    p = add_epsg_def (filter, first, last, 3399, "epsg", 3399,
        "RD/83 / 3-degree Gauss-Kruger zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 2,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4745\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3399\"]]");
    p = add_epsg_def (filter, first, last, 3400, "epsg", 3400,
        "NAD83 / Alberta 10-TM (Forest)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 10-TM (Forest)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-115],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9992],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"3400\"]]");
    p = add_epsg_def (filter, first, last, 3401, "epsg", 3401,
        "NAD83 / Alberta 10-TM (Resource)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 10-TM (Resource)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-115],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9992],PARAMETER[\"false_easting\",0],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"3401\"]]");
    p = add_epsg_def (filter, first, last, 3402, "epsg", 3402,
        "NAD83(CSRS) / Alberta 10-TM (Forest)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 10-TM (Forest)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-115],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9992],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3402\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 3403, "epsg", 3403,
        "NAD83(CSRS) / Alberta 10-TM (Resource)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 10-TM (Resource)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"461");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-11");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9992],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3403\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3404, "epsg", 3404,
        "NAD83(HARN) / North Carolina (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Carolina (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",36.16666666666666],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",34.33333333333334],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",33.75],PARAMETER[\"central_meridian\",-79");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",2000000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3404\"]]");
    p = add_epsg_def (filter, first, last, 3405, "epsg", 3405,
        "VN-2000 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=-192.873,-39.38");
    add_proj4text (p, 1,
        "2,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / UTM zone 48N\",GEOGCS[\"VN-2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-192.873,-39");
    add_srs_wkt (p, 3,
        ".382,-111.202,-0.00205,-0.0005,0.00335,0.0188],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",105],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3405\"]]");
    p = add_epsg_def (filter, first, last, 3406, "epsg", 3406,
        "VN-2000 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=-192.873,-39.38");
    add_proj4text (p, 1,
        "2,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / UTM zone 49N\",GEOGCS[\"VN-2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-192.873,-39");
    add_srs_wkt (p, 3,
        ".382,-111.202,-0.00205,-0.0005,0.00335,0.0188],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",111],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3406\"]]");
    p = add_epsg_def (filter, first, last, 3407, "epsg", 3407,
        "Hong Kong 1963 Grid System");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=22.31213333333334 +lon_0=114.178555555");
    add_proj4text (p, 1,
        "5556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +to_meter=0.3047972");
    add_proj4text (p, 3,
        "654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hong Kong 1963 Grid System\",GEOGCS[\"Hong Kong");
    add_srs_wkt (p, 1,
        " 1963\",DATUM[\"Hong_Kong_1963\",SPHEROID[\"Clarke 1858\"");
    add_srs_wkt (p, 2,
        ",6378293.645208759,294.2606763692654,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7007\"]],AUTHORITY[\"EPSG\",\"6738\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4738\"]],PROJECTION[\"Cassini_Soldner\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",22.31213333333334],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",114.1785555555556],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",132033.92],PARAMETER[\"false_northing\",6");
    add_srs_wkt (p, 10,
        "2565.96],UNIT[\"Clarke's foot\",0.3047972654,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9005\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"3407\"]]");
    p = add_epsg_def (filter, first, last, 3408, "epsg", 3408,
        "NSIDC EASE-Grid North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +");
    add_proj4text (p, 1,
        "b=6371228 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC EASE-Grid North\",GEOGCS[\"Unspecified da");
    add_srs_wkt (p, 1,
        "tum based upon the International 1924 Authalic Sphere\",");
    add_srs_wkt (p, 2,
        "DATUM[\"Not_specified_based_on_International_1924_Authal");
    add_srs_wkt (p, 3,
        "ic_Sphere\",SPHEROID[\"International 1924 Authalic Spher");
    add_srs_wkt (p, 4,
        "e\",6371228,0,AUTHORITY[\"EPSG\",\"7057\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6053\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4053\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_center\",90],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"3408\"]]");
    p = add_epsg_def (filter, first, last, 3409, "epsg", 3409,
        "NSIDC EASE-Grid South");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 ");
    add_proj4text (p, 1,
        "+b=6371228 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC EASE-Grid South\",GEOGCS[\"Unspecified da");
    add_srs_wkt (p, 1,
        "tum based upon the International 1924 Authalic Sphere\",");
    add_srs_wkt (p, 2,
        "DATUM[\"Not_specified_based_on_International_1924_Authal");
    add_srs_wkt (p, 3,
        "ic_Sphere\",SPHEROID[\"International 1924 Authalic Spher");
    add_srs_wkt (p, 4,
        "e\",6371228,0,AUTHORITY[\"EPSG\",\"7057\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6053\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4053\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_center\",-90],PARAMETER[\"longitude_of_center");
    add_srs_wkt (p, 10,
        "\",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3409\"]]");
    p = add_epsg_def (filter, first, last, 3410, "epsg", 3410,
        "NSIDC EASE-Grid Global");
    add_proj4text (p, 0,
        "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +a=6371228 +");
    add_proj4text (p, 1,
        "b=6371228 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC EASE-Grid Global\",GEOGCS[\"Unspecified d");
    add_srs_wkt (p, 1,
        "atum based upon the International 1924 Authalic Sphere\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"Not_specified_based_on_International_1924_Autha");
    add_srs_wkt (p, 3,
        "lic_Sphere\",SPHEROID[\"International 1924 Authalic Sphe");
    add_srs_wkt (p, 4,
        "re\",6371228,0,AUTHORITY[\"EPSG\",\"7057\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6053\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4053\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Cylindrical_Equal_Area\"],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",30],PARAMETER[\"central_meridian\",0],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3410\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 3411, "epsg", 3411,
        "NSIDC Sea Ice Polar Stereographic North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC Sea Ice Polar Stereographic North\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Unspecified datum based upon the Hughes 1980 ellipso");
    add_srs_wkt (p, 2,
        "id\",DATUM[\"Not_specified_based_on_Hughes_1980_ellipsoi");
    add_srs_wkt (p, 3,
        "d\",SPHEROID[\"Hughes 1980\",6378273,298.279411123064,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Polar");
    add_srs_wkt (p, 8,
        "_Stereographic\"],PARAMETER[\"latitude_of_origin\",70],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-45],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"3411\"]]");
    p = add_epsg_def (filter, first, last, 3412, "epsg", 3412,
        "NSIDC Sea Ice Polar Stereographic South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NSIDC Sea Ice Polar Stereographic South\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Unspecified datum based upon the Hughes 1980 ellipso");
    add_srs_wkt (p, 2,
        "id\",DATUM[\"Not_specified_based_on_Hughes_1980_ellipsoi");
    add_srs_wkt (p, 3,
        "d\",SPHEROID[\"Hughes 1980\",6378273,298.279411123064,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Polar");
    add_srs_wkt (p, 8,
        "_Stereographic\"],PARAMETER[\"latitude_of_origin\",-70],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3412\"]]");
    p = add_epsg_def (filter, first, last, 3413, "epsg", 3413,
        "WGS 84 / NSIDC Sea Ice Polar Stereographic North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC Sea Ice Polar Stereographic Nort");
    add_srs_wkt (p, 1,
        "h\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS ");
    add_srs_wkt (p, 2,
        "84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4326\"]],PROJECTION[\"Polar_Stereographic\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",70],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-45],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3413\"]]");
    p = add_epsg_def (filter, first, last, 3414, "epsg", 3414,
        "SVY21 / Singapore TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.83333333");
    add_proj4text (p, 1,
        "33333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SVY21 / Singapore TM\",GEOGCS[\"SVY21\",DATUM[\"");
    add_srs_wkt (p, 1,
        "SVY21\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6757\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4757\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 6,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",1.36666666");
    add_srs_wkt (p, 7,
        "6666667],PARAMETER[\"central_meridian\",103.833333333333");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",28001.642],PARAMETER[\"false_northing\",38744.572],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3414\"]]");
    p = add_epsg_def (filter, first, last, 3415, "epsg", 3415,
        "WGS 72BE / South China Sea Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_2=24 +lat_0=21 +lon_0=114 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=500000 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 2,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / South China Sea Lambert\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 72BE\",DATUM[\"WGS_1972_Transit_Broadcast_Ephemeris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7043\"]],TOWGS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",18],PARAMETER[\"standard_parallel_2\",2");
    add_srs_wkt (p, 9,
        "4],PARAMETER[\"latitude_of_origin\",21],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",114],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3415\"]]");
    p = add_epsg_def (filter, first, last, 3416, "epsg", 3416,
        "ETRS89 / Austria Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.3333");
    add_proj4text (p, 1,
        "3333333333 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Austria Lambert\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",49],PARAMETER[\"standard_parallel_2\",46],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",47.5],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",13.33333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",400000],PARAMETER[\"false_northing\",400000],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3416\"]]");
    p = add_epsg_def (filter, first, last, 3417, "epsg", 3417,
        "NAD83 / Iowa North (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.99");
    add_proj4text (p, 2,
        "99898402 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa North (ft US)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",43.2");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"standard_parallel_2\",42.0666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"latitude_of_origin\",41.5],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",-93.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",4921250],PARAMETER[\"false_northing\",3280833.33330");
    add_srs_wkt (p, 12,
        "0001],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"3417\"]]");
    p = add_epsg_def (filter, first, last, 3418, "epsg", 3418,
        "NAD83 / Iowa South (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa South (ft US)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.7");
    add_srs_wkt (p, 8,
        "8333333333333],PARAMETER[\"standard_parallel_2\",40.6166");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"latitude_of_origin\",40],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-93.5],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",1640416.6667],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3418\"]]");
    p = add_epsg_def (filter, first, last, 3419, "epsg", 3419,
        "NAD83 / Kansas North (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas North (ft US)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39");
    add_srs_wkt (p, 8,
        ".78333333333333],PARAMETER[\"standard_parallel_2\",38.71");
    add_srs_wkt (p, 9,
        "666666666667],PARAMETER[\"latitude_of_origin\",38.333333");
    add_srs_wkt (p, 10,
        "33333334],PARAMETER[\"central_meridian\",-98],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",1312333.3333],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"3419\"]]");
    p = add_epsg_def (filter, first, last, 3420, "epsg", 3420,
        "NAD83 / Kansas South (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99");
    add_proj4text (p, 2,
        "998984 +y_0=399999.99998984 +datum=NAD83 +units=us-ft +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas South (ft US)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38");
    add_srs_wkt (p, 8,
        ".56666666666667],PARAMETER[\"standard_parallel_2\",37.26");
    add_srs_wkt (p, 9,
        "666666666667],PARAMETER[\"latitude_of_origin\",36.666666");
    add_srs_wkt (p, 10,
        "66666666],PARAMETER[\"central_meridian\",-98.5],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",1312333.3333],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1312333.3333],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 13,
        "6012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3420\"]]");
    p = add_epsg_def (filter, first, last, 3421, "epsg", 3421,
        "NAD83 / Nevada East (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000.00001016 +y_0=8000000.000010163 +datum=");
    add_proj4text (p, 2,
        "NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada East (ft US)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",34.75],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-115.5833333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",65616");
    add_srs_wkt (p, 10,
        "6.6667],PARAMETER[\"false_northing\",26246666.66670001],");
    add_srs_wkt (p, 11,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"3421\"]]");
    p = add_epsg_def (filter, first, last, 3422, "epsg", 3422,
        "NAD83 / Nevada Central (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000.00001016 +y_0=6000000 +datum=NAD83 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada Central (ft US)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",34.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-116.6666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "640416.6667],PARAMETER[\"false_northing\",19685000],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3422\"]]");
    p = add_epsg_def (filter, first, last, 3423, "epsg", 3423,
        "NAD83 / Nevada West (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +datum");
    add_proj4text (p, 2,
        "=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada West (ft US)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",34.75],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-118.5833333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",26246");
    add_srs_wkt (p, 10,
        "66.6667],PARAMETER[\"false_northing\",13123333.3333],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"3423\"]]");
    p = add_epsg_def (filter, first, last, 3424, "epsg", 3424,
        "NAD83 / New Jersey (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +datum=NAD83 +units=us-ft +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Jersey (ft US)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",38.8333333333");
    add_srs_wkt (p, 8,
        "3334],PARAMETER[\"central_meridian\",-74.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",49212");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 11,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3424");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 3425, "epsg", 3425,
        "NAD83(HARN) / Iowa North (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.99");
    add_proj4text (p, 2,
        "99898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Iowa North (ft US)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_1\",43.26666666666667],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",42.06666666666667],PARAMETER[\"latitude");
    add_srs_wkt (p, 10,
        "_of_origin\",41.5],PARAMETER[\"central_meridian\",-93.5]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",4921250],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",3280833.333300001],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3425\"]]");
    p = add_epsg_def (filter, first, last, 3426, "epsg", 3426,
        "NAD83(HARN) / Iowa South (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Iowa South (ft US)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_1\",41.78333333333333],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",40.61666666666667],PARAMETER[\"latitude");
    add_srs_wkt (p, 10,
        "_of_origin\",40],PARAMETER[\"central_meridian\",-93.5],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",1640416.6667],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3426\"]]");
    p = add_epsg_def (filter, first, last, 3427, "epsg", 3427,
        "NAD83(HARN) / Kansas North (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kansas North (ft US)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",39.78333333333333],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",38.71666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",38.33333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 11,
        "ridian\",-98],PARAMETER[\"false_easting\",1312333.3333],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3427\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 3428, "epsg", 3428,
        "NAD83(HARN) / Kansas South (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99");
    add_proj4text (p, 2,
        "998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 3,
        "0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kansas South (ft US)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",38.56666666666667],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",37.26666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",36.66666666666666],PARAMETER[\"central_me");
    add_srs_wkt (p, 11,
        "ridian\",-98.5],PARAMETER[\"false_easting\",1312333.3333");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",1312333.3333],UNIT[\"US s");
    add_srs_wkt (p, 13,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 14,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"3428\"]]");
    p = add_epsg_def (filter, first, last, 3429, "epsg", 3429,
        "NAD83(HARN) / Nevada East (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada East (ft US)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",34.75],PARAMETER[\"central_meridian\",-115.58");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",656166.6667],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",26246666.66670001],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3429\"]]");
    p = add_epsg_def (filter, first, last, 3430, "epsg", 3430,
        "NAD83(HARN) / Nevada Central (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada Central (ft US)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",34.75],PARAMETER[\"central_meridian\",-116");
    add_srs_wkt (p, 9,
        ".6666666666667],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1640416.6667],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",19685000],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3430\"]]");
    p = add_epsg_def (filter, first, last, 3431, "epsg", 3431,
        "NAD83(HARN) / Nevada West (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nevada West (ft US)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",34.75],PARAMETER[\"central_meridian\",-118.58");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",2624666.6667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",13123333.3333],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3431\"]]");
    p = add_epsg_def (filter, first, last, 3432, "epsg", 3432,
        "NAD83(HARN) / New Jersey (ft US)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Jersey (ft US)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",38.83333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-74.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",492125],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3432\"]]");
    p = add_epsg_def (filter, first, last, 3433, "epsg", 3433,
        "NAD83 / Arkansas North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36");
    add_srs_wkt (p, 8,
        ".23333333333333],PARAMETER[\"standard_parallel_2\",34.93");
    add_srs_wkt (p, 9,
        "333333333333],PARAMETER[\"latitude_of_origin\",34.333333");
    add_srs_wkt (p, 10,
        "33333334],PARAMETER[\"central_meridian\",-92],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",1312333.3333],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"3433\"]]");
    p = add_epsg_def (filter, first, last, 3434, "epsg", 3434,
        "NAD83 / Arkansas South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399");
    add_proj4text (p, 2,
        "999.99998984 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34");
    add_srs_wkt (p, 8,
        ".76666666666667],PARAMETER[\"standard_parallel_2\",33.3]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"latitude_of_origin\",32.66666666666666],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"central_meridian\",-92],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",1312333.3333],PARAMETER[\"false_northing\",1312333.");
    add_srs_wkt (p, 12,
        "3333],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"3434\"]]");
    p = add_epsg_def (filter, first, last, 3435, "epsg", 3435,
        "NAD83 / Illinois East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois East (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",36.66666666");
    add_srs_wkt (p, 8,
        "666666],PARAMETER[\"central_meridian\",-88.3333333333333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.999975],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",984250.0000000002],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"3435\"]]");
    p = add_epsg_def (filter, first, last, 3436, "epsg", 3436,
        "NAD83 / Illinois West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois West (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",36.66666666");
    add_srs_wkt (p, 8,
        "666666],PARAMETER[\"central_meridian\",-90.1666666666666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.999941177],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",2296583.333300001],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"3436\"]]");
    p = add_epsg_def (filter, first, last, 3437, "epsg", 3437,
        "NAD83 / New Hampshire (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000.0000000001 +y_0=0 +datum=NAD83 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Hampshire (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",42.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-71.66666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.999966667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",984250.0000000002],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3437\"]]");
    p = add_epsg_def (filter, first, last, 3438, "epsg", 3438,
        "NAD83 / Rhode Island (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=99999.99998983997 +y_0=0 +datum=NAD83 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Rhode Island (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",41.0833333333");
    add_srs_wkt (p, 8,
        "3334],PARAMETER[\"central_meridian\",-71.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99999375],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 10,
        "28083.3333],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3438\"]]");
    p = add_epsg_def (filter, first, last, 3439, "epsg", 3439,
        "PSD93 / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-180.624,-225.");
    add_proj4text (p, 1,
        "516,173.919,-0.81,-1.898,8.336,16.7101 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSD93 / UTM zone 39N\",GEOGCS[\"PSD93\",DATUM[\"");
    add_srs_wkt (p, 1,
        "PDO_Survey_Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
        "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6134\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4134\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"343");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def (filter, first, last, 3440, "epsg", 3440,
        "PSD93 / UTM zone 40N");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-180.624,-225.");
    add_proj4text (p, 1,
        "516,173.919,-0.81,-1.898,8.336,16.7101 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSD93 / UTM zone 40N\",GEOGCS[\"PSD93\",DATUM[\"");
    add_srs_wkt (p, 1,
        "PDO_Survey_Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6");
    add_srs_wkt (p, 2,
        "378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6134\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4134\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"344");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 3441, "epsg", 3441,
        "NAD83(HARN) / Arkansas North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arkansas North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",36.23333333333333],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",34.93333333333333],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",34.33333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 11,
        "ridian\",-92],PARAMETER[\"false_easting\",1312333.3333],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3441\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 3442, "epsg", 3442,
        "NAD83(HARN) / Arkansas South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399");
    add_proj4text (p, 2,
        "999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arkansas South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",34.76666666666667],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",33.3],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",32.66666666666666],PARAMETER[\"central_meridian\",-92],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",1312333.3333],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",1312333.3333],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 13,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3442\"]]");
    p = add_epsg_def (filter, first, last, 3443, "epsg", 3443,
        "NAD83(HARN) / Illinois East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Illinois East (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",36.66666666666666],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-88.33333333333333],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999975],PARAMETER[\"false_easting\",984250.0000000002],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3443\"]]");
    p = add_epsg_def (filter, first, last, 3444, "epsg", 3444,
        "NAD83(HARN) / Illinois West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Illinois West (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",36.66666666666666],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-90.16666666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999941177],PARAMETER[\"false_easting\",2296583.333300001");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3444\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 3445, "epsg", 3445,
        "NAD83(HARN) / New Hampshire (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Hampshire (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",42.5],PARAMETER[\"central_meridian\",-71.66");
    add_srs_wkt (p, 9,
        "666666666667],PARAMETER[\"scale_factor\",0.999966667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",984250.0000000002],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3445\"]]");
    p = add_epsg_def (filter, first, last, 3446, "epsg", 3446,
        "NAD83(HARN) / Rhode Island (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Rhode Island (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",41.08333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-71.5],PARAMETER[\"scale_factor\",0.99999375],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",328083.3333],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"3446\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

