require 'wsapi.xavante'

local PathToCgi = '/var/www/wiki/'

local simplerules = {

    { match = "^[^%./]*/$", 
      with = xavante.redirecthandler, params = {"/wiki.cgi"} },
    { match = { "^/wiki.cgi$" }, 
      with = wsapi.xavante.makeGenericHandler(PathToCgi, true) },
    { match = { "^/wiki$" }, 
      with = xavante.redirecthandler, params = {"/wiki.cgi"} },
    { match = { "^/wiki/(.*)$" }, 
      with = xavante.redirecthandler, 
      params = {"/wiki.cgi",
        function(req,res,cap) 
	print(req.cmd_url)
  		req.cmd_url = "/wiki.cgi?p="..cap[1] 
  		return "reparse" 
  	end } },

} 

-- add your vhost rules to the virtualhosts map
-- 
config.virtualhosts["mydomain:8080"] = {
	rules = simplerules,
}

