/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWCMDPROGRESS_TEST_H
#define _WCVIEWCMDPROGRESS_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
#include "subcommander/LogData.h"
class WcViewCmdProgress;

// qt
#include <QtCore/QObject>

// sys
#include <vector>

typedef std::vector<LogDataPtr> LogDatas;

class WcViewCmdProgressTest : public QObject, public CppUnit::TestCase 
{
  CPPUNIT_TEST_SUITE( WcViewCmdProgressTest );
  CPPUNIT_TEST( listStarted );
  CPPUNIT_TEST( listFinished );
  CPPUNIT_TEST( listFinishedFailed );
  CPPUNIT_TEST_SUITE_END(); 
  
public:
  void setUp();
  void tearDown();
  
  // QObject
  bool event( QEvent* e );

  // Tests
  void listStarted();
  void listFinished();
  void listFinishedFailed();
  
private:
  void processEvents();
  void ASSERT_MSG( const sc::String& expected, const sc::String& actual );
  
  WcViewCmdProgress* _progress;
  LogDatas           _ld;
};

#endif // _WCVIEWCMDPROGRESS_TEST_H
